/* ml-spectra-processing 14.17.0 | MIT | https://github.com/mljs/spectra-processing#readme */
function t(t){const e=t.re.length,r=t.re,o=t.im,n=new Float64Array(e);for(let t=0;t<e;t++)n[t]=Math.hypot(r[t],o[t]);return n}const e=Object.prototype.toString;function r(t){const r=e.call(t);return r.endsWith("Array]")&&!r.includes("Big")}function o(t,e){if(void 0!==t){if(!r(t))throw new TypeError("output option must be an array if specified");if(t.length!==e)throw new TypeError("the output array does not have the correct length");return t}return new Float64Array(e)}function n(t){const e=t.slice();for(let t=0;t<e.length;t++)e[t]<0&&(e[t]*=-1);return e}function s(t,e={}){if(!r(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");const{exact:o=!1}=e||{},n=t.slice(),s=h(0,n.length-1),l=i(n,s);if(n.length%2==1||!o)return l;return(l+i(n,s+1))/2}function i(t,e){let r=0,o=t.length-1,n=0,s=0,i=0;for(;;){if(o<=r)return t[e];if(o===r+1)return t[r]>t[o]&&l(t,r,o),t[e];for(n=h(r,o),t[n]>t[o]&&l(t,n,o),t[r]>t[o]&&l(t,r,o),t[n]>t[r]&&l(t,n,r),l(t,n,r+1),s=r+1,i=o;;){do{s++}while(t[r]>t[s]);do{i--}while(t[i]>t[r]);if(i<s)break;l(t,s,i)}l(t,r,i),i<=e&&(r=s),i>=e&&(o=i-1)}}function l(t,e,r){const o=t[r];t[r]=t[e],t[e]=o}function h(t,e){return Math.floor((t+e)/2)}function a(t){return s(n(t))}function u(t,e={}){const{minLength:o}=e;if(!r(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");if("number"!=typeof t[0])throw new TypeError("input must contain numbers");if(o&&t.length<o)throw new Error(`input must have a length of at least ${o}`)}function f(t,e,r={}){const{sorted:o=!0}=r;if(o){let r=0,o=t.length-1,n=0;for(;o-r>1;)if(n=r+(o-r>>1),t[n]<e)r=n;else{if(!(t[n]>e))return n;o=n}return r<t.length-1?Math.abs(e-t[r])<Math.abs(t[r+1]-e)?r:r+1:r}{let r=0,o=Number.POSITIVE_INFINITY;for(let n=0;n<t.length;n++){const s=Math.abs(t[n]-e);s<o&&(o=s,r=n)}return r}}function c(t,e={}){let{fromIndex:r,toIndex:o}=e;const{from:n,to:s}=e;return void 0===r&&(r=void 0!==n?f(t,n):0),void 0===o&&(o=void 0!==s?f(t,s):t.length-1),r<0&&(r=0),o<0&&(o=0),r>=t.length&&(r=t.length-1),o>=t.length&&(o=t.length-1),r>o&&([r,o]=[o,r]),{fromIndex:r,toIndex:o}}function g(t,e={}){u(t);const{fromIndex:r,toIndex:o}=c(t,e);let n=0;for(let e=r;e<=o;e++)n+=Math.abs(t[e]);return n}function m(t,e){let o=!1,n=0;if(r(e)){if(t.length!==e.length)throw new Error("size of array1 and array2 must be identical")}else o=!0,n=e;const s=new Float64Array(t.length);if(o)for(let e=0;e<t.length;e++)s[e]=t[e]+n;else for(let r=0;r<t.length;r++)s[r]=t[r]+e[r];return s}function w(t,e={}){const{variableLabel:r="x",fctString:o=r}=e,n=new Function(r,`return Number(${o.replaceAll(/(?<before>^|\W)(?<after>[\da-z]{2,}\()/g,"$<before>Math.$<after>").replaceAll("Math.Math","Math")})`),s=Float64Array.from(t);for(let e=0;e<t.length;e++)if(s[e]=n(t[e]),Number.isNaN(s[e]))throw new Error(`The callback ${o} does not return a number: ${t[e]}`);return s}function y(t,e,n={}){let s=!1,i=0;if(r(e)){if(t.length!==e.length)throw new Error("size of array1 and array2 must be identical")}else s=!0,i=e;const l=o(n.output,t.length);if(s)for(let e=0;e<t.length;e++)l[e]=t[e]*i;else for(let r=0;r<t.length;r++)l[r]=t[r]*e[r];return l}function p(t,e){const r=y(t,e);let o=0;for(let e=0;e<t.length;e++)o+=r[e];return o}function d(t,e,r={}){const{tau:o=1,lag:n=t.length-1}=r,s=new Float64Array(1+2*n/o);if(t.length===e.length){const r=e.length,i=new Float64Array(2*r),l=new Float64Array(2*r);for(let t=0;t<r;t++)l[r+t]=e[t];for(let e=2*r-(o-1);e>0;e-=o){let h=0;for(let t=e;t<2*r;t++)i[h]=l[t],h++;const a=[];for(let t=0;t<r;t++)a[t]=i[t];s[(h-(r-n))/o]=p(t,a)}}return s}function x(t,e={}){return d(t,t,e)}function b(t){u(t);const e=((t=Float64Array.from(t).sort()).length-1)/4,r=(t.length-1)*(3/4),o=(t.length-1)/2,n=e%1,s=r%1,i=o%1;return{min:t[0],q1:0===n?t[e]:t[e|0]*(1-n)+t[1+(e|0)]*n,median:0===i?t[o]:t[o|0]*(1-i)+t[1+(o|0)]*i,q3:0===s?t[r]:t[r|0]*(1-s)+t[1+(r|0)]*s,max:t.at(-1)}}function M(t){const e=b(t),r=e.q3-e.q1,o=e.q1-1.5*r,n=e.q3+1.5*r,s=[];let i=e.median,l=e.median;for(const e of t)e<o||e>n?s.push(e):(e<i&&(i=e),e>l&&(l=e));return{...e,lowerWhisker:o,upperWhisker:n,minWhisker:i,maxWhisker:l,iqr:r,outliers:s}}function v(t,e){if(t.length!==e.length)throw new TypeError("length of array1 and array2 must be identical")}function A(t,e){const r=t.length;let o=0,n=0,s=0,i=0,l=0;for(let h=0;h<r;h++){const r=t[h],a=e[h];o+=r,n+=r**2,s+=a,i+=a**2,l+=r*a}return(r*l-o*s)/(Math.sqrt(r*n-o**2)*Math.sqrt(r*i-s**2))}function E(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}function I(t){if(Object.prototype.hasOwnProperty.call(t,"__esModule"))return t;var e=t.default;if("function"==typeof e){var r=function t(){var r=!1;try{r=this instanceof t}catch{}return r?Reflect.construct(e,arguments,this.constructor):e.apply(this,arguments)};r.prototype=e.prototype}else r={};return Object.defineProperty(r,"__esModule",{value:!0}),Object.keys(t).forEach(function(e){var o=Object.getOwnPropertyDescriptor(t,e);Object.defineProperty(r,e,o.get?o:{enumerable:!0,get:function(){return t[e]}})}),r}var S={},R=I(Object.freeze({__proto__:null,isAnyArray:r}));var N=I(Object.freeze({__proto__:null,default:function(t){var e,o=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!r(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");if(void 0!==o.output){if(!r(o.output))throw new TypeError("output option must be an array if specified");e=o.output}else e=new Array(t.length);var n=function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!r(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");var o=e.fromIndex,n=void 0===o?0:o,s=e.toIndex,i=void 0===s?t.length:s;if(n<0||n>=t.length||!Number.isInteger(n))throw new Error("fromIndex must be a positive integer smaller than length");if(i<=n||i>t.length||!Number.isInteger(i))throw new Error("toIndex must be an integer greater than fromIndex and at most equal to length");for(var l=t[n],h=n+1;h<i;h++)t[h]<l&&(l=t[h]);return l}(t),s=function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!r(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");var o=e.fromIndex,n=void 0===o?0:o,s=e.toIndex,i=void 0===s?t.length:s;if(n<0||n>=t.length||!Number.isInteger(n))throw new Error("fromIndex must be a positive integer smaller than length");if(i<=n||i>t.length||!Number.isInteger(i))throw new Error("toIndex must be an integer greater than fromIndex and at most equal to length");for(var l=t[n],h=n+1;h<i;h++)t[h]>l&&(l=t[h]);return l}(t);if(n===s)throw new RangeError("minimum and maximum input values are equal. Cannot rescale a constant array");var i=o.min,l=void 0===i?o.autoMinMax?n:0:i,h=o.max,a=void 0===h?o.autoMinMax?s:1:h;if(l>=a)throw new RangeError("min option must be smaller than max option");for(var u=(a-l)/(s-n),f=0;f<t.length;f++)e[f]=(t[f]-n)*u+l;return e}}));Object.defineProperty(S,"__esModule",{value:!0});var F=R,T=N;const _=" ".repeat(2),k=" ".repeat(4);function C(t,e={}){const{maxRows:r=15,maxColumns:o=10,maxNumSize:n=8,padMinus:s="auto"}=e;return`${t.constructor.name} {\n${_}[\n${k}${function(t,e,r,o,n){const{rows:s,columns:i}=t,l=Math.min(s,e),h=Math.min(i,r),a=[];if("auto"===n){n=!1;t:for(let e=0;e<l;e++)for(let r=0;r<h;r++)if(t.get(e,r)<0){n=!0;break t}}for(let e=0;e<l;e++){let r=[];for(let s=0;s<h;s++)r.push(V(t.get(e,s),o,n));a.push(`${r.join(" ")}`)}h!==i&&(a[a.length-1]+=` ... ${i-r} more columns`);l!==s&&a.push(`... ${s-e} more rows`);return a.join(`\n${k}`)}(t,r,o,n,s)}\n${_}]\n${_}rows: ${t.rows}\n${_}columns: ${t.columns}\n}`}function V(t,e,r){return(t>=0&&r?` ${q(t,e-1)}`:q(t,e)).padEnd(e)}function q(t,e){let r=t.toString();if(r.length<=e)return r;let o=t.toFixed(e);if(o.length>e&&(o=t.toFixed(Math.max(0,e-(o.length-e)))),o.length<=e&&!o.startsWith("0.000")&&!o.startsWith("-0.000"))return o;let n=t.toExponential(e);return n.length>e&&(n=t.toExponential(Math.max(0,e-(n.length-e)))),n.slice(0)}function z(t,e,r){let o=r?t.rows:t.rows-1;if(e<0||e>o)throw new RangeError("Row index out of range")}function P(t,e,r){let o=r?t.columns:t.columns-1;if(e<0||e>o)throw new RangeError("Column index out of range")}function j(t,e){if(e.to1DArray&&(e=e.to1DArray()),e.length!==t.columns)throw new RangeError("vector size must be the same as the number of columns");return e}function $(t,e){if(e.to1DArray&&(e=e.to1DArray()),e.length!==t.rows)throw new RangeError("vector size must be the same as the number of rows");return e}function D(t,e){if(!F.isAnyArray(e))throw new TypeError("row indices must be an array");for(let r=0;r<e.length;r++)if(e[r]<0||e[r]>=t.rows)throw new RangeError("row indices are out of range")}function O(t,e){if(!F.isAnyArray(e))throw new TypeError("column indices must be an array");for(let r=0;r<e.length;r++)if(e[r]<0||e[r]>=t.columns)throw new RangeError("column indices are out of range")}function L(t,e,r,o,n){if(5!==arguments.length)throw new RangeError("expected 4 arguments");if(U("startRow",e),U("endRow",r),U("startColumn",o),U("endColumn",n),e>r||o>n||e<0||e>=t.rows||r<0||r>=t.rows||o<0||o>=t.columns||n<0||n>=t.columns)throw new RangeError("Submatrix indices are out of range")}function Y(t,e=0){let r=[];for(let o=0;o<t;o++)r.push(e);return r}function U(t,e){if("number"!=typeof e)throw new TypeError(`${t} must be a number`)}function X(t){if(t.isEmpty())throw new Error("Empty matrix has no elements to index")}class G{static from1DArray(t,e,r){if(t*e!==r.length)throw new RangeError("data length does not match given dimensions");let o=new Q(t,e);for(let n=0;n<t;n++)for(let t=0;t<e;t++)o.set(n,t,r[n*e+t]);return o}static rowVector(t){let e=new Q(1,t.length);for(let r=0;r<t.length;r++)e.set(0,r,t[r]);return e}static columnVector(t){let e=new Q(t.length,1);for(let r=0;r<t.length;r++)e.set(r,0,t[r]);return e}static zeros(t,e){return new Q(t,e)}static ones(t,e){return new Q(t,e).fill(1)}static rand(t,e,r={}){if("object"!=typeof r)throw new TypeError("options must be an object");const{random:o=Math.random}=r;let n=new Q(t,e);for(let r=0;r<t;r++)for(let t=0;t<e;t++)n.set(r,t,o());return n}static randInt(t,e,r={}){if("object"!=typeof r)throw new TypeError("options must be an object");const{min:o=0,max:n=1e3,random:s=Math.random}=r;if(!Number.isInteger(o))throw new TypeError("min must be an integer");if(!Number.isInteger(n))throw new TypeError("max must be an integer");if(o>=n)throw new RangeError("min must be smaller than max");let i=n-o,l=new Q(t,e);for(let r=0;r<t;r++)for(let t=0;t<e;t++){let e=o+Math.round(s()*i);l.set(r,t,e)}return l}static eye(t,e,r){void 0===e&&(e=t),void 0===r&&(r=1);let o=Math.min(t,e),n=this.zeros(t,e);for(let t=0;t<o;t++)n.set(t,t,r);return n}static diag(t,e,r){let o=t.length;void 0===e&&(e=o),void 0===r&&(r=e);let n=Math.min(o,e,r),s=this.zeros(e,r);for(let e=0;e<n;e++)s.set(e,e,t[e]);return s}static min(t,e){t=this.checkMatrix(t),e=this.checkMatrix(e);let r=t.rows,o=t.columns,n=new Q(r,o);for(let s=0;s<r;s++)for(let r=0;r<o;r++)n.set(s,r,Math.min(t.get(s,r),e.get(s,r)));return n}static max(t,e){t=this.checkMatrix(t),e=this.checkMatrix(e);let r=t.rows,o=t.columns,n=new this(r,o);for(let s=0;s<r;s++)for(let r=0;r<o;r++)n.set(s,r,Math.max(t.get(s,r),e.get(s,r)));return n}static checkMatrix(t){return G.isMatrix(t)?t:new Q(t)}static isMatrix(t){return null!=t&&"Matrix"===t.klass}get size(){return this.rows*this.columns}apply(t){if("function"!=typeof t)throw new TypeError("callback must be a function");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)t.call(this,e,r);return this}to1DArray(){let t=[];for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)t.push(this.get(e,r));return t}to2DArray(){let t=[];for(let e=0;e<this.rows;e++){t.push([]);for(let r=0;r<this.columns;r++)t[e].push(this.get(e,r))}return t}toJSON(){return this.to2DArray()}isRowVector(){return 1===this.rows}isColumnVector(){return 1===this.columns}isVector(){return 1===this.rows||1===this.columns}isSquare(){return this.rows===this.columns}isEmpty(){return 0===this.rows||0===this.columns}isSymmetric(){if(this.isSquare()){for(let t=0;t<this.rows;t++)for(let e=0;e<=t;e++)if(this.get(t,e)!==this.get(e,t))return!1;return!0}return!1}isDistance(){if(!this.isSymmetric())return!1;for(let t=0;t<this.rows;t++)if(0!==this.get(t,t))return!1;return!0}isEchelonForm(){let t=0,e=0,r=-1,o=!0,n=!1;for(;t<this.rows&&o;){for(e=0,n=!1;e<this.columns&&!1===n;)0===this.get(t,e)?e++:1===this.get(t,e)&&e>r?(n=!0,r=e):(o=!1,n=!0);t++}return o}isReducedEchelonForm(){let t=0,e=0,r=-1,o=!0,n=!1;for(;t<this.rows&&o;){for(e=0,n=!1;e<this.columns&&!1===n;)0===this.get(t,e)?e++:1===this.get(t,e)&&e>r?(n=!0,r=e):(o=!1,n=!0);for(let r=e+1;r<this.rows;r++)0!==this.get(t,r)&&(o=!1);t++}return o}echelonForm(){let t=this.clone(),e=0,r=0;for(;e<t.rows&&r<t.columns;){let o=e;for(let n=e;n<t.rows;n++)t.get(n,r)>t.get(o,r)&&(o=n);if(0===t.get(o,r))r++;else{t.swapRows(e,o);let n=t.get(e,r);for(let o=r;o<t.columns;o++)t.set(e,o,t.get(e,o)/n);for(let o=e+1;o<t.rows;o++){let n=t.get(o,r)/t.get(e,r);t.set(o,r,0);for(let s=r+1;s<t.columns;s++)t.set(o,s,t.get(o,s)-t.get(e,s)*n)}e++,r++}}return t}reducedEchelonForm(){let t=this.echelonForm(),e=t.columns,r=t.rows,o=r-1;for(;o>=0;)if(0===t.maxRow(o))o--;else{let n=0,s=!1;for(;n<r&&!1===s;)1===t.get(o,n)?s=!0:n++;for(let r=0;r<o;r++){let s=t.get(r,n);for(let i=n;i<e;i++){let e=t.get(r,i)-s*t.get(o,i);t.set(r,i,e)}}o--}return t}set(){throw new Error("set method is unimplemented")}get(){throw new Error("get method is unimplemented")}repeat(t={}){if("object"!=typeof t)throw new TypeError("options must be an object");const{rows:e=1,columns:r=1}=t;if(!Number.isInteger(e)||e<=0)throw new TypeError("rows must be a positive integer");if(!Number.isInteger(r)||r<=0)throw new TypeError("columns must be a positive integer");let o=new Q(this.rows*e,this.columns*r);for(let t=0;t<e;t++)for(let e=0;e<r;e++)o.setSubMatrix(this,this.rows*t,this.columns*e);return o}fill(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,t);return this}neg(){return this.mulS(-1)}getRow(t){z(this,t);let e=[];for(let r=0;r<this.columns;r++)e.push(this.get(t,r));return e}getRowVector(t){return Q.rowVector(this.getRow(t))}setRow(t,e){z(this,t),e=j(this,e);for(let r=0;r<this.columns;r++)this.set(t,r,e[r]);return this}swapRows(t,e){z(this,t),z(this,e);for(let r=0;r<this.columns;r++){let o=this.get(t,r);this.set(t,r,this.get(e,r)),this.set(e,r,o)}return this}getColumn(t){P(this,t);let e=[];for(let r=0;r<this.rows;r++)e.push(this.get(r,t));return e}getColumnVector(t){return Q.columnVector(this.getColumn(t))}setColumn(t,e){P(this,t),e=$(this,e);for(let r=0;r<this.rows;r++)this.set(r,t,e[r]);return this}swapColumns(t,e){P(this,t),P(this,e);for(let r=0;r<this.rows;r++){let o=this.get(r,t);this.set(r,t,this.get(r,e)),this.set(r,e,o)}return this}addRowVector(t){t=j(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)+t[r]);return this}subRowVector(t){t=j(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)-t[r]);return this}mulRowVector(t){t=j(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)*t[r]);return this}divRowVector(t){t=j(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)/t[r]);return this}addColumnVector(t){t=$(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)+t[e]);return this}subColumnVector(t){t=$(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)-t[e]);return this}mulColumnVector(t){t=$(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)*t[e]);return this}divColumnVector(t){t=$(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)/t[e]);return this}mulRow(t,e){z(this,t);for(let r=0;r<this.columns;r++)this.set(t,r,this.get(t,r)*e);return this}mulColumn(t,e){P(this,t);for(let r=0;r<this.rows;r++)this.set(r,t,this.get(r,t)*e);return this}max(t){if(this.isEmpty())return NaN;switch(t){case"row":{const t=new Array(this.rows).fill(Number.NEGATIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.get(e,r)>t[e]&&(t[e]=this.get(e,r));return t}case"column":{const t=new Array(this.columns).fill(Number.NEGATIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.get(e,r)>t[r]&&(t[r]=this.get(e,r));return t}case void 0:{let t=this.get(0,0);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.get(e,r)>t&&(t=this.get(e,r));return t}default:throw new Error(`invalid option: ${t}`)}}maxIndex(){X(this);let t=this.get(0,0),e=[0,0];for(let r=0;r<this.rows;r++)for(let o=0;o<this.columns;o++)this.get(r,o)>t&&(t=this.get(r,o),e[0]=r,e[1]=o);return e}min(t){if(this.isEmpty())return NaN;switch(t){case"row":{const t=new Array(this.rows).fill(Number.POSITIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.get(e,r)<t[e]&&(t[e]=this.get(e,r));return t}case"column":{const t=new Array(this.columns).fill(Number.POSITIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.get(e,r)<t[r]&&(t[r]=this.get(e,r));return t}case void 0:{let t=this.get(0,0);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.get(e,r)<t&&(t=this.get(e,r));return t}default:throw new Error(`invalid option: ${t}`)}}minIndex(){X(this);let t=this.get(0,0),e=[0,0];for(let r=0;r<this.rows;r++)for(let o=0;o<this.columns;o++)this.get(r,o)<t&&(t=this.get(r,o),e[0]=r,e[1]=o);return e}maxRow(t){if(z(this,t),this.isEmpty())return NaN;let e=this.get(t,0);for(let r=1;r<this.columns;r++)this.get(t,r)>e&&(e=this.get(t,r));return e}maxRowIndex(t){z(this,t),X(this);let e=this.get(t,0),r=[t,0];for(let o=1;o<this.columns;o++)this.get(t,o)>e&&(e=this.get(t,o),r[1]=o);return r}minRow(t){if(z(this,t),this.isEmpty())return NaN;let e=this.get(t,0);for(let r=1;r<this.columns;r++)this.get(t,r)<e&&(e=this.get(t,r));return e}minRowIndex(t){z(this,t),X(this);let e=this.get(t,0),r=[t,0];for(let o=1;o<this.columns;o++)this.get(t,o)<e&&(e=this.get(t,o),r[1]=o);return r}maxColumn(t){if(P(this,t),this.isEmpty())return NaN;let e=this.get(0,t);for(let r=1;r<this.rows;r++)this.get(r,t)>e&&(e=this.get(r,t));return e}maxColumnIndex(t){P(this,t),X(this);let e=this.get(0,t),r=[0,t];for(let o=1;o<this.rows;o++)this.get(o,t)>e&&(e=this.get(o,t),r[0]=o);return r}minColumn(t){if(P(this,t),this.isEmpty())return NaN;let e=this.get(0,t);for(let r=1;r<this.rows;r++)this.get(r,t)<e&&(e=this.get(r,t));return e}minColumnIndex(t){P(this,t),X(this);let e=this.get(0,t),r=[0,t];for(let o=1;o<this.rows;o++)this.get(o,t)<e&&(e=this.get(o,t),r[0]=o);return r}diag(){let t=Math.min(this.rows,this.columns),e=[];for(let r=0;r<t;r++)e.push(this.get(r,r));return e}norm(t="frobenius"){switch(t){case"max":return this.max();case"frobenius":return Math.sqrt(this.dot(this));default:throw new RangeError(`unknown norm type: ${t}`)}}cumulativeSum(){let t=0;for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)t+=this.get(e,r),this.set(e,r,t);return this}dot(t){G.isMatrix(t)&&(t=t.to1DArray());let e=this.to1DArray();if(e.length!==t.length)throw new RangeError("vectors do not have the same size");let r=0;for(let o=0;o<e.length;o++)r+=e[o]*t[o];return r}mmul(t){t=Q.checkMatrix(t);let e=this.rows,r=this.columns,o=t.columns,n=new Q(e,o),s=new Float64Array(r);for(let i=0;i<o;i++){for(let e=0;e<r;e++)s[e]=t.get(e,i);for(let t=0;t<e;t++){let e=0;for(let o=0;o<r;o++)e+=this.get(t,o)*s[o];n.set(t,i,e)}}return n}mpow(t){if(!this.isSquare())throw new RangeError("Matrix must be square");if(!Number.isInteger(t)||t<0)throw new RangeError("Exponent must be a non-negative integer");let e=Q.eye(this.rows),r=this;for(let o=t;o>=1;o/=2)1&o&&(e=e.mmul(r)),r=r.mmul(r);return e}strassen2x2(t){t=Q.checkMatrix(t);let e=new Q(2,2);const r=this.get(0,0),o=t.get(0,0),n=this.get(0,1),s=t.get(0,1),i=this.get(1,0),l=t.get(1,0),h=this.get(1,1),a=t.get(1,1),u=(r+h)*(o+a),f=(i+h)*o,c=r*(s-a),g=h*(l-o),m=(r+n)*a,w=u+g-m+(n-h)*(l+a),y=c+m,p=f+g,d=u-f+c+(i-r)*(o+s);return e.set(0,0,w),e.set(0,1,y),e.set(1,0,p),e.set(1,1,d),e}strassen3x3(t){t=Q.checkMatrix(t);let e=new Q(3,3);const r=this.get(0,0),o=this.get(0,1),n=this.get(0,2),s=this.get(1,0),i=this.get(1,1),l=this.get(1,2),h=this.get(2,0),a=this.get(2,1),u=this.get(2,2),f=t.get(0,0),c=t.get(0,1),g=t.get(0,2),m=t.get(1,0),w=t.get(1,1),y=t.get(1,2),p=t.get(2,0),d=t.get(2,1),x=t.get(2,2),b=(r-s)*(-c+w),M=(-r+s+i)*(f-c+w),v=(s+i)*(-f+c),A=r*f,E=(-r+h+a)*(f-g+y),I=(-r+h)*(g-y),S=(h+a)*(-f+g),R=(-n+a+u)*(w+p-d),N=(n-u)*(w-d),F=n*p,T=(a+u)*(-p+d),_=(-n+i+l)*(y+p-x),k=(n-l)*(y-x),C=(i+l)*(-p+x),V=A+F+o*m,q=(r+o+n-s-i-a-u)*w+M+v+A+R+F+T,z=A+E+S+(r+o+n-i-l-h-a)*y+F+_+C,P=b+i*(-f+c+m-w-y-p+x)+M+A+F+_+k,j=b+M+v+A+l*d,$=F+_+k+C+s*g,D=A+E+I+a*(-f+g+m-w-y-p+d)+R+N+F,O=R+N+F+T+h*c,L=A+E+I+S+u*x;return e.set(0,0,V),e.set(0,1,q),e.set(0,2,z),e.set(1,0,P),e.set(1,1,j),e.set(1,2,$),e.set(2,0,D),e.set(2,1,O),e.set(2,2,L),e}mmulStrassen(t){t=Q.checkMatrix(t);let e=this.clone(),r=e.rows,o=e.columns,n=t.rows,s=t.columns;function i(t,e,r){let o=t.rows,n=t.columns;if(o===e&&n===r)return t;{let o=G.zeros(e,r);return o=o.setSubMatrix(t,0,0),o}}o!==n&&console.warn(`Multiplying ${r} x ${o} and ${n} x ${s} matrix: dimensions do not match.`);let l=Math.max(r,n),h=Math.max(o,s);return e=i(e,l,h),function t(e,r,o,n){if(o<=512||n<=512)return e.mmul(r);o%2==1&&n%2==1?(e=i(e,o+1,n+1),r=i(r,o+1,n+1)):o%2==1?(e=i(e,o+1,n),r=i(r,o+1,n)):n%2==1&&(e=i(e,o,n+1),r=i(r,o,n+1));let s=parseInt(e.rows/2,10),l=parseInt(e.columns/2,10),h=e.subMatrix(0,s-1,0,l-1),a=r.subMatrix(0,s-1,0,l-1),u=e.subMatrix(0,s-1,l,e.columns-1),f=r.subMatrix(0,s-1,l,r.columns-1),c=e.subMatrix(s,e.rows-1,0,l-1),g=r.subMatrix(s,r.rows-1,0,l-1),m=e.subMatrix(s,e.rows-1,l,e.columns-1),w=r.subMatrix(s,r.rows-1,l,r.columns-1),y=t(G.add(h,m),G.add(a,w),s,l),p=t(G.add(c,m),a,s,l),d=t(h,G.sub(f,w),s,l),x=t(m,G.sub(g,a),s,l),b=t(G.add(h,u),w,s,l),M=t(G.sub(c,h),G.add(a,f),s,l),v=t(G.sub(u,m),G.add(g,w),s,l),A=G.add(y,x);A.sub(b),A.add(v);let E=G.add(d,b),I=G.add(p,x),S=G.sub(y,p);S.add(d),S.add(M);let R=G.zeros(2*A.rows,2*A.columns);return R=R.setSubMatrix(A,0,0),R=R.setSubMatrix(E,A.rows,0),R=R.setSubMatrix(I,0,A.columns),R=R.setSubMatrix(S,A.rows,A.columns),R.subMatrix(0,o-1,0,n-1)}(e,t=i(t,l,h),l,h)}scaleRows(t={}){if("object"!=typeof t)throw new TypeError("options must be an object");const{min:e=0,max:r=1}=t;if(!Number.isFinite(e))throw new TypeError("min must be a number");if(!Number.isFinite(r))throw new TypeError("max must be a number");if(e>=r)throw new RangeError("min must be smaller than max");let o=new Q(this.rows,this.columns);for(let t=0;t<this.rows;t++){const n=this.getRow(t);n.length>0&&T(n,{min:e,max:r,output:n}),o.setRow(t,n)}return o}scaleColumns(t={}){if("object"!=typeof t)throw new TypeError("options must be an object");const{min:e=0,max:r=1}=t;if(!Number.isFinite(e))throw new TypeError("min must be a number");if(!Number.isFinite(r))throw new TypeError("max must be a number");if(e>=r)throw new RangeError("min must be smaller than max");let o=new Q(this.rows,this.columns);for(let t=0;t<this.columns;t++){const n=this.getColumn(t);n.length&&T(n,{min:e,max:r,output:n}),o.setColumn(t,n)}return o}flipRows(){const t=Math.ceil(this.columns/2);for(let e=0;e<this.rows;e++)for(let r=0;r<t;r++){let t=this.get(e,r),o=this.get(e,this.columns-1-r);this.set(e,r,o),this.set(e,this.columns-1-r,t)}return this}flipColumns(){const t=Math.ceil(this.rows/2);for(let e=0;e<this.columns;e++)for(let r=0;r<t;r++){let t=this.get(r,e),o=this.get(this.rows-1-r,e);this.set(r,e,o),this.set(this.rows-1-r,e,t)}return this}kroneckerProduct(t){t=Q.checkMatrix(t);let e=this.rows,r=this.columns,o=t.rows,n=t.columns,s=new Q(e*o,r*n);for(let i=0;i<e;i++)for(let e=0;e<r;e++)for(let r=0;r<o;r++)for(let l=0;l<n;l++)s.set(o*i+r,n*e+l,this.get(i,e)*t.get(r,l));return s}kroneckerSum(t){if(t=Q.checkMatrix(t),!this.isSquare()||!t.isSquare())throw new Error("Kronecker Sum needs two Square Matrices");let e=this.rows,r=t.rows,o=this.kroneckerProduct(Q.eye(r,r)),n=Q.eye(e,e).kroneckerProduct(t);return o.add(n)}transpose(){let t=new Q(this.columns,this.rows);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)t.set(r,e,this.get(e,r));return t}sortRows(t=B){for(let e=0;e<this.rows;e++)this.setRow(e,this.getRow(e).sort(t));return this}sortColumns(t=B){for(let e=0;e<this.columns;e++)this.setColumn(e,this.getColumn(e).sort(t));return this}subMatrix(t,e,r,o){L(this,t,e,r,o);let n=new Q(e-t+1,o-r+1);for(let s=t;s<=e;s++)for(let e=r;e<=o;e++)n.set(s-t,e-r,this.get(s,e));return n}subMatrixRow(t,e,r){if(void 0===e&&(e=0),void 0===r&&(r=this.columns-1),e>r||e<0||e>=this.columns||r<0||r>=this.columns)throw new RangeError("Argument out of range");let o=new Q(t.length,r-e+1);for(let n=0;n<t.length;n++)for(let s=e;s<=r;s++){if(t[n]<0||t[n]>=this.rows)throw new RangeError(`Row index out of range: ${t[n]}`);o.set(n,s-e,this.get(t[n],s))}return o}subMatrixColumn(t,e,r){if(void 0===e&&(e=0),void 0===r&&(r=this.rows-1),e>r||e<0||e>=this.rows||r<0||r>=this.rows)throw new RangeError("Argument out of range");let o=new Q(r-e+1,t.length);for(let n=0;n<t.length;n++)for(let s=e;s<=r;s++){if(t[n]<0||t[n]>=this.columns)throw new RangeError(`Column index out of range: ${t[n]}`);o.set(s-e,n,this.get(s,t[n]))}return o}setSubMatrix(t,e,r){if((t=Q.checkMatrix(t)).isEmpty())return this;L(this,e,e+t.rows-1,r,r+t.columns-1);for(let o=0;o<t.rows;o++)for(let n=0;n<t.columns;n++)this.set(e+o,r+n,t.get(o,n));return this}selection(t,e){D(this,t),O(this,e);let r=new Q(t.length,e.length);for(let o=0;o<t.length;o++){let n=t[o];for(let t=0;t<e.length;t++){let s=e[t];r.set(o,t,this.get(n,s))}}return r}trace(){let t=Math.min(this.rows,this.columns),e=0;for(let r=0;r<t;r++)e+=this.get(r,r);return e}clone(){return this.constructor.copy(this,new Q(this.rows,this.columns))}static copy(t,e){for(const[r,o,n]of t.entries())e.set(r,o,n);return e}sum(t){switch(t){case"row":return function(t){let e=Y(t.rows);for(let r=0;r<t.rows;++r)for(let o=0;o<t.columns;++o)e[r]+=t.get(r,o);return e}(this);case"column":return function(t){let e=Y(t.columns);for(let r=0;r<t.rows;++r)for(let o=0;o<t.columns;++o)e[o]+=t.get(r,o);return e}(this);case void 0:return function(t){let e=0;for(let r=0;r<t.rows;r++)for(let o=0;o<t.columns;o++)e+=t.get(r,o);return e}(this);default:throw new Error(`invalid option: ${t}`)}}product(t){switch(t){case"row":return function(t){let e=Y(t.rows,1);for(let r=0;r<t.rows;++r)for(let o=0;o<t.columns;++o)e[r]*=t.get(r,o);return e}(this);case"column":return function(t){let e=Y(t.columns,1);for(let r=0;r<t.rows;++r)for(let o=0;o<t.columns;++o)e[o]*=t.get(r,o);return e}(this);case void 0:return function(t){let e=1;for(let r=0;r<t.rows;r++)for(let o=0;o<t.columns;o++)e*=t.get(r,o);return e}(this);default:throw new Error(`invalid option: ${t}`)}}mean(t){const e=this.sum(t);switch(t){case"row":for(let t=0;t<this.rows;t++)e[t]/=this.columns;return e;case"column":for(let t=0;t<this.columns;t++)e[t]/=this.rows;return e;case void 0:return e/this.size;default:throw new Error(`invalid option: ${t}`)}}variance(t,e={}){if("object"==typeof t&&(e=t,t=void 0),"object"!=typeof e)throw new TypeError("options must be an object");const{unbiased:r=!0,mean:o=this.mean(t)}=e;if("boolean"!=typeof r)throw new TypeError("unbiased must be a boolean");switch(t){case"row":if(!F.isAnyArray(o))throw new TypeError("mean must be an array");return function(t,e,r){const o=t.rows,n=t.columns,s=[];for(let i=0;i<o;i++){let o=0,l=0,h=0;for(let e=0;e<n;e++)h=t.get(i,e)-r[i],o+=h,l+=h*h;e?s.push((l-o*o/n)/(n-1)):s.push((l-o*o/n)/n)}return s}(this,r,o);case"column":if(!F.isAnyArray(o))throw new TypeError("mean must be an array");return function(t,e,r){const o=t.rows,n=t.columns,s=[];for(let i=0;i<n;i++){let n=0,l=0,h=0;for(let e=0;e<o;e++)h=t.get(e,i)-r[i],n+=h,l+=h*h;e?s.push((l-n*n/o)/(o-1)):s.push((l-n*n/o)/o)}return s}(this,r,o);case void 0:if("number"!=typeof o)throw new TypeError("mean must be a number");return function(t,e,r){const o=t.rows,n=t.columns,s=o*n;let i=0,l=0,h=0;for(let e=0;e<o;e++)for(let o=0;o<n;o++)h=t.get(e,o)-r,i+=h,l+=h*h;return e?(l-i*i/s)/(s-1):(l-i*i/s)/s}(this,r,o);default:throw new Error(`invalid option: ${t}`)}}standardDeviation(t,e){"object"==typeof t&&(e=t,t=void 0);const r=this.variance(t,e);if(void 0===t)return Math.sqrt(r);for(let t=0;t<r.length;t++)r[t]=Math.sqrt(r[t]);return r}center(t,e={}){if("object"==typeof t&&(e=t,t=void 0),"object"!=typeof e)throw new TypeError("options must be an object");const{center:r=this.mean(t)}=e;switch(t){case"row":if(!F.isAnyArray(r))throw new TypeError("center must be an array");return function(t,e){for(let r=0;r<t.rows;r++)for(let o=0;o<t.columns;o++)t.set(r,o,t.get(r,o)-e[r])}(this,r),this;case"column":if(!F.isAnyArray(r))throw new TypeError("center must be an array");return function(t,e){for(let r=0;r<t.rows;r++)for(let o=0;o<t.columns;o++)t.set(r,o,t.get(r,o)-e[o])}(this,r),this;case void 0:if("number"!=typeof r)throw new TypeError("center must be a number");return function(t,e){for(let r=0;r<t.rows;r++)for(let o=0;o<t.columns;o++)t.set(r,o,t.get(r,o)-e)}(this,r),this;default:throw new Error(`invalid option: ${t}`)}}scale(t,e={}){if("object"==typeof t&&(e=t,t=void 0),"object"!=typeof e)throw new TypeError("options must be an object");let r=e.scale;switch(t){case"row":if(void 0===r)r=function(t){const e=[];for(let r=0;r<t.rows;r++){let o=0;for(let e=0;e<t.columns;e++)o+=t.get(r,e)**2/(t.columns-1);e.push(Math.sqrt(o))}return e}(this);else if(!F.isAnyArray(r))throw new TypeError("scale must be an array");return function(t,e){for(let r=0;r<t.rows;r++)for(let o=0;o<t.columns;o++)t.set(r,o,t.get(r,o)/e[r])}(this,r),this;case"column":if(void 0===r)r=function(t){const e=[];for(let r=0;r<t.columns;r++){let o=0;for(let e=0;e<t.rows;e++)o+=t.get(e,r)**2/(t.rows-1);e.push(Math.sqrt(o))}return e}(this);else if(!F.isAnyArray(r))throw new TypeError("scale must be an array");return function(t,e){for(let r=0;r<t.rows;r++)for(let o=0;o<t.columns;o++)t.set(r,o,t.get(r,o)/e[o])}(this,r),this;case void 0:if(void 0===r)r=function(t){const e=t.size-1;let r=0;for(let o=0;o<t.columns;o++)for(let n=0;n<t.rows;n++)r+=t.get(n,o)**2/e;return Math.sqrt(r)}(this);else if("number"!=typeof r)throw new TypeError("scale must be a number");return function(t,e){for(let r=0;r<t.rows;r++)for(let o=0;o<t.columns;o++)t.set(r,o,t.get(r,o)/e)}(this,r),this;default:throw new Error(`invalid option: ${t}`)}}toString(t){return C(this,t)}[Symbol.iterator](){return this.entries()}*entries(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)yield[t,e,this.get(t,e)]}*values(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)yield this.get(t,e)}}function B(t,e){return t-e}function W(t){return t.every(t=>"number"==typeof t)}G.prototype.klass="Matrix","undefined"!=typeof Symbol&&(G.prototype[Symbol.for("nodejs.util.inspect.custom")]=function(){return C(this)}),G.random=G.rand,G.randomInt=G.randInt,G.diagonal=G.diag,G.prototype.diagonal=G.prototype.diag,G.identity=G.eye,G.prototype.negate=G.prototype.neg,G.prototype.tensorProduct=G.prototype.kroneckerProduct;let Q=class t extends G{data;#t(t,e){if(this.data=[],!(Number.isInteger(e)&&e>=0))throw new TypeError("nColumns must be a positive integer");for(let r=0;r<t;r++)this.data.push(new Float64Array(e));this.rows=t,this.columns=e}constructor(e,r){if(super(),t.isMatrix(e))this.#t(e.rows,e.columns),t.copy(e,this);else if(Number.isInteger(e)&&e>=0)this.#t(e,r);else{if(!F.isAnyArray(e))throw new TypeError("First argument must be a positive number or an array");{const t=e;if("number"!=typeof(r=(e=t.length)?t[0].length:0))throw new TypeError("Data must be a 2D array with at least one element");this.data=[];for(let o=0;o<e;o++){if(t[o].length!==r)throw new RangeError("Inconsistent array dimensions");if(!W(t[o]))throw new TypeError("Input data contains non-numeric values");this.data.push(Float64Array.from(t[o]))}this.rows=e,this.columns=r}}}set(t,e,r){return this.data[t][e]=r,this}get(t,e){return this.data[t][e]}removeRow(t){return z(this,t),this.data.splice(t,1),this.rows-=1,this}addRow(t,e){return void 0===e&&(e=t,t=this.rows),z(this,t,!0),e=Float64Array.from(j(this,e)),this.data.splice(t,0,e),this.rows+=1,this}removeColumn(t){P(this,t);for(let e=0;e<this.rows;e++){const r=new Float64Array(this.columns-1);for(let o=0;o<t;o++)r[o]=this.data[e][o];for(let o=t+1;o<this.columns;o++)r[o-1]=this.data[e][o];this.data[e]=r}return this.columns-=1,this}addColumn(t,e){void 0===e&&(e=t,t=this.columns),P(this,t,!0),e=$(this,e);for(let r=0;r<this.rows;r++){const o=new Float64Array(this.columns+1);let n=0;for(;n<t;n++)o[n]=this.data[r][n];for(o[n++]=e[r];n<this.columns+1;n++)o[n]=this.data[r][n-1];this.data[r]=o}return this.columns+=1,this}};!function(t,e){t.prototype.add=function(t){return"number"==typeof t?this.addS(t):this.addM(t)},t.prototype.addS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)+t);return this},t.prototype.addM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)+t.get(e,r));return this},t.add=function(t,r){return new e(t).add(r)},t.prototype.sub=function(t){return"number"==typeof t?this.subS(t):this.subM(t)},t.prototype.subS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)-t);return this},t.prototype.subM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)-t.get(e,r));return this},t.sub=function(t,r){return new e(t).sub(r)},t.prototype.subtract=t.prototype.sub,t.prototype.subtractS=t.prototype.subS,t.prototype.subtractM=t.prototype.subM,t.subtract=t.sub,t.prototype.mul=function(t){return"number"==typeof t?this.mulS(t):this.mulM(t)},t.prototype.mulS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)*t);return this},t.prototype.mulM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)*t.get(e,r));return this},t.mul=function(t,r){return new e(t).mul(r)},t.prototype.multiply=t.prototype.mul,t.prototype.multiplyS=t.prototype.mulS,t.prototype.multiplyM=t.prototype.mulM,t.multiply=t.mul,t.prototype.div=function(t){return"number"==typeof t?this.divS(t):this.divM(t)},t.prototype.divS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)/t);return this},t.prototype.divM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)/t.get(e,r));return this},t.div=function(t,r){return new e(t).div(r)},t.prototype.divide=t.prototype.div,t.prototype.divideS=t.prototype.divS,t.prototype.divideM=t.prototype.divM,t.divide=t.div,t.prototype.mod=function(t){return"number"==typeof t?this.modS(t):this.modM(t)},t.prototype.modS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)%t);return this},t.prototype.modM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)%t.get(e,r));return this},t.mod=function(t,r){return new e(t).mod(r)},t.prototype.modulus=t.prototype.mod,t.prototype.modulusS=t.prototype.modS,t.prototype.modulusM=t.prototype.modM,t.modulus=t.mod,t.prototype.and=function(t){return"number"==typeof t?this.andS(t):this.andM(t)},t.prototype.andS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)&t);return this},t.prototype.andM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)&t.get(e,r));return this},t.and=function(t,r){return new e(t).and(r)},t.prototype.or=function(t){return"number"==typeof t?this.orS(t):this.orM(t)},t.prototype.orS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)|t);return this},t.prototype.orM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)|t.get(e,r));return this},t.or=function(t,r){return new e(t).or(r)},t.prototype.xor=function(t){return"number"==typeof t?this.xorS(t):this.xorM(t)},t.prototype.xorS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)^t);return this},t.prototype.xorM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)^t.get(e,r));return this},t.xor=function(t,r){return new e(t).xor(r)},t.prototype.leftShift=function(t){return"number"==typeof t?this.leftShiftS(t):this.leftShiftM(t)},t.prototype.leftShiftS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)<<t);return this},t.prototype.leftShiftM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)<<t.get(e,r));return this},t.leftShift=function(t,r){return new e(t).leftShift(r)},t.prototype.signPropagatingRightShift=function(t){return"number"==typeof t?this.signPropagatingRightShiftS(t):this.signPropagatingRightShiftM(t)},t.prototype.signPropagatingRightShiftS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)>>t);return this},t.prototype.signPropagatingRightShiftM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)>>t.get(e,r));return this},t.signPropagatingRightShift=function(t,r){return new e(t).signPropagatingRightShift(r)},t.prototype.rightShift=function(t){return"number"==typeof t?this.rightShiftS(t):this.rightShiftM(t)},t.prototype.rightShiftS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)>>>t);return this},t.prototype.rightShiftM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)>>>t.get(e,r));return this},t.rightShift=function(t,r){return new e(t).rightShift(r)},t.prototype.zeroFillRightShift=t.prototype.rightShift,t.prototype.zeroFillRightShiftS=t.prototype.rightShiftS,t.prototype.zeroFillRightShiftM=t.prototype.rightShiftM,t.zeroFillRightShift=t.rightShift,t.prototype.not=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,~this.get(t,e));return this},t.not=function(t){return new e(t).not()},t.prototype.abs=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.abs(this.get(t,e)));return this},t.abs=function(t){return new e(t).abs()},t.prototype.acos=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.acos(this.get(t,e)));return this},t.acos=function(t){return new e(t).acos()},t.prototype.acosh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.acosh(this.get(t,e)));return this},t.acosh=function(t){return new e(t).acosh()},t.prototype.asin=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.asin(this.get(t,e)));return this},t.asin=function(t){return new e(t).asin()},t.prototype.asinh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.asinh(this.get(t,e)));return this},t.asinh=function(t){return new e(t).asinh()},t.prototype.atan=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.atan(this.get(t,e)));return this},t.atan=function(t){return new e(t).atan()},t.prototype.atanh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.atanh(this.get(t,e)));return this},t.atanh=function(t){return new e(t).atanh()},t.prototype.cbrt=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.cbrt(this.get(t,e)));return this},t.cbrt=function(t){return new e(t).cbrt()},t.prototype.ceil=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.ceil(this.get(t,e)));return this},t.ceil=function(t){return new e(t).ceil()},t.prototype.clz32=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.clz32(this.get(t,e)));return this},t.clz32=function(t){return new e(t).clz32()},t.prototype.cos=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.cos(this.get(t,e)));return this},t.cos=function(t){return new e(t).cos()},t.prototype.cosh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.cosh(this.get(t,e)));return this},t.cosh=function(t){return new e(t).cosh()},t.prototype.exp=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.exp(this.get(t,e)));return this},t.exp=function(t){return new e(t).exp()},t.prototype.expm1=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.expm1(this.get(t,e)));return this},t.expm1=function(t){return new e(t).expm1()},t.prototype.floor=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.floor(this.get(t,e)));return this},t.floor=function(t){return new e(t).floor()},t.prototype.fround=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.fround(this.get(t,e)));return this},t.fround=function(t){return new e(t).fround()},t.prototype.log=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log(this.get(t,e)));return this},t.log=function(t){return new e(t).log()},t.prototype.log1p=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log1p(this.get(t,e)));return this},t.log1p=function(t){return new e(t).log1p()},t.prototype.log10=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log10(this.get(t,e)));return this},t.log10=function(t){return new e(t).log10()},t.prototype.log2=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log2(this.get(t,e)));return this},t.log2=function(t){return new e(t).log2()},t.prototype.round=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.round(this.get(t,e)));return this},t.round=function(t){return new e(t).round()},t.prototype.sign=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sign(this.get(t,e)));return this},t.sign=function(t){return new e(t).sign()},t.prototype.sin=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sin(this.get(t,e)));return this},t.sin=function(t){return new e(t).sin()},t.prototype.sinh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sinh(this.get(t,e)));return this},t.sinh=function(t){return new e(t).sinh()},t.prototype.sqrt=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sqrt(this.get(t,e)));return this},t.sqrt=function(t){return new e(t).sqrt()},t.prototype.tan=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.tan(this.get(t,e)));return this},t.tan=function(t){return new e(t).tan()},t.prototype.tanh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.tanh(this.get(t,e)));return this},t.tanh=function(t){return new e(t).tanh()},t.prototype.trunc=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.trunc(this.get(t,e)));return this},t.trunc=function(t){return new e(t).trunc()},t.pow=function(t,r){return new e(t).pow(r)},t.prototype.pow=function(t){return"number"==typeof t?this.powS(t):this.powM(t)},t.prototype.powS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)**t);return this},t.prototype.powM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)**t.get(e,r));return this}}(G,Q);class J extends G{#e;get size(){return this.#e.size}get rows(){return this.#e.rows}get columns(){return this.#e.columns}get diagonalSize(){return this.rows}static isSymmetricMatrix(t){return Q.isMatrix(t)&&"SymmetricMatrix"===t.klassType}static zeros(t){return new this(t)}static ones(t){return new this(t).fill(1)}constructor(t){if(super(),Q.isMatrix(t)){if(!t.isSymmetric())throw new TypeError("not symmetric data");this.#e=Q.copy(t,new Q(t.rows,t.rows))}else if(Number.isInteger(t)&&t>=0)this.#e=new Q(t,t);else if(this.#e=new Q(t),!this.isSymmetric())throw new TypeError("not symmetric data")}clone(){const t=new J(this.diagonalSize);for(const[e,r,o]of this.upperRightEntries())t.set(e,r,o);return t}toMatrix(){return new Q(this)}get(t,e){return this.#e.get(t,e)}set(t,e,r){return this.#e.set(t,e,r),this.#e.set(e,t,r),this}removeCross(t){return this.#e.removeRow(t),this.#e.removeColumn(t),this}addCross(t,e){void 0===e&&(e=t,t=this.diagonalSize);const r=e.slice();return r.splice(t,1),this.#e.addRow(t,r),this.#e.addColumn(t,e),this}applyMask(t){if(t.length!==this.diagonalSize)throw new RangeError("Mask size do not match with matrix size");const e=[];for(const[r,o]of t.entries())o||e.push(r);e.reverse();for(const t of e)this.removeCross(t);return this}toCompact(){const{diagonalSize:t}=this,e=new Array(t*(t+1)/2);for(let r=0,o=0,n=0;n<e.length;n++)e[n]=this.get(o,r),++r>=t&&(r=++o);return e}static fromCompact(t){const e=t.length,r=(Math.sqrt(8*e+1)-1)/2;if(!Number.isInteger(r))throw new TypeError(`This array is not a compact representation of a Symmetric Matrix, ${JSON.stringify(t)}`);const o=new J(r);for(let n=0,s=0,i=0;i<e;i++)o.set(n,s,t[i]),++n>=r&&(n=++s);return o}*upperRightEntries(){for(let t=0,e=0;t<this.diagonalSize;void 0){const r=this.get(t,e);yield[t,e,r],++e>=this.diagonalSize&&(e=++t)}}*upperRightValues(){for(let t=0,e=0;t<this.diagonalSize;void 0){const r=this.get(t,e);yield r,++e>=this.diagonalSize&&(e=++t)}}}J.prototype.klassType="SymmetricMatrix";class H extends J{static isDistanceMatrix(t){return J.isSymmetricMatrix(t)&&"DistanceMatrix"===t.klassSubType}constructor(t){if(super(t),!this.isDistance())throw new TypeError("Provided arguments do no produce a distance matrix")}set(t,e,r){return t===e&&(r=0),super.set(t,e,r)}addCross(t,e){return void 0===e&&(e=t,t=this.diagonalSize),(e=e.slice())[t]=0,super.addCross(t,e)}toSymmetricMatrix(){return new J(this)}clone(){const t=new H(this.diagonalSize);for(const[e,r,o]of this.upperRightEntries())e!==r&&t.set(e,r,o);return t}toCompact(){const{diagonalSize:t}=this,e=new Array((t-1)*t/2);for(let r=1,o=0,n=0;n<e.length;n++)e[n]=this.get(o,r),++r>=t&&(r=1+ ++o);return e}static fromCompact(t){const e=t.length;if(0===e)return new this(0);const r=(Math.sqrt(8*e+1)+1)/2;if(!Number.isInteger(r))throw new TypeError(`This array is not a compact representation of a DistanceMatrix, ${JSON.stringify(t)}`);const o=new this(r);for(let n=1,s=0,i=0;i<e;i++)o.set(n,s,t[i]),++n>=r&&(n=1+ ++s);return o}}H.prototype.klassSubType="DistanceMatrix";class Z extends G{constructor(t,e,r){super(),this.matrix=t,this.rows=e,this.columns=r}}class K extends Z{constructor(t,e,r){D(t,e),O(t,r),super(t,e.length,r.length),this.rowIndices=e,this.columnIndices=r}set(t,e,r){return this.matrix.set(this.rowIndices[t],this.columnIndices[e],r),this}get(t,e){return this.matrix.get(this.rowIndices[t],this.columnIndices[e])}}class tt extends G{constructor(t,e={}){const{rows:r=1}=e;if(t.length%r!==0)throw new Error("the data length is not divisible by the number of rows");super(),this.rows=r,this.columns=t.length/r,this.data=t}set(t,e,r){let o=this._calculateIndex(t,e);return this.data[o]=r,this}get(t,e){let r=this._calculateIndex(t,e);return this.data[r]}_calculateIndex(t,e){return t*this.columns+e}}class et extends G{constructor(t){super(),this.data=t,this.rows=t.length,this.columns=t[0].length}set(t,e,r){return this.data[t][e]=r,this}get(t,e){return this.data[t][e]}}class rt{constructor(t){let e,r,o,n,s,i,l,h,a,u=(t=et.checkMatrix(t)).clone(),f=u.rows,c=u.columns,g=new Float64Array(f),m=1;for(e=0;e<f;e++)g[e]=e;for(h=new Float64Array(f),r=0;r<c;r++){for(e=0;e<f;e++)h[e]=u.get(e,r);for(e=0;e<f;e++){for(a=Math.min(e,r),s=0,o=0;o<a;o++)s+=u.get(e,o)*h[o];h[e]-=s,u.set(e,r,h[e])}for(n=r,e=r+1;e<f;e++)Math.abs(h[e])>Math.abs(h[n])&&(n=e);if(n!==r){for(o=0;o<c;o++)i=u.get(n,o),u.set(n,o,u.get(r,o)),u.set(r,o,i);l=g[n],g[n]=g[r],g[r]=l,m=-m}if(r<f&&0!==u.get(r,r))for(e=r+1;e<f;e++)u.set(e,r,u.get(e,r)/u.get(r,r))}this.LU=u,this.pivotVector=g,this.pivotSign=m}isSingular(){let t=this.LU,e=t.columns;for(let r=0;r<e;r++)if(0===t.get(r,r))return!0;return!1}solve(t){t=Q.checkMatrix(t);let e=this.LU;if(e.rows!==t.rows)throw new Error("Invalid matrix dimensions");if(this.isSingular())throw new Error("LU matrix is singular");let r,o,n,s=t.columns,i=t.subMatrixRow(this.pivotVector,0,s-1),l=e.columns;for(n=0;n<l;n++)for(r=n+1;r<l;r++)for(o=0;o<s;o++)i.set(r,o,i.get(r,o)-i.get(n,o)*e.get(r,n));for(n=l-1;n>=0;n--){for(o=0;o<s;o++)i.set(n,o,i.get(n,o)/e.get(n,n));for(r=0;r<n;r++)for(o=0;o<s;o++)i.set(r,o,i.get(r,o)-i.get(n,o)*e.get(r,n))}return i}get determinant(){let t=this.LU;if(!t.isSquare())throw new Error("Matrix must be square");let e=this.pivotSign,r=t.columns;for(let o=0;o<r;o++)e*=t.get(o,o);return e}get lowerTriangularMatrix(){let t=this.LU,e=t.rows,r=t.columns,o=new Q(e,r);for(let n=0;n<e;n++)for(let e=0;e<r;e++)n>e?o.set(n,e,t.get(n,e)):n===e?o.set(n,e,1):o.set(n,e,0);return o}get upperTriangularMatrix(){let t=this.LU,e=t.rows,r=t.columns,o=new Q(e,r);for(let n=0;n<e;n++)for(let e=0;e<r;e++)n<=e?o.set(n,e,t.get(n,e)):o.set(n,e,0);return o}get pivotPermutationVector(){return Array.from(this.pivotVector)}}function ot(t,e){let r=0;return Math.abs(t)>Math.abs(e)?(r=e/t,Math.abs(t)*Math.sqrt(1+r*r)):0!==e?(r=t/e,Math.abs(e)*Math.sqrt(1+r*r)):0}class nt{constructor(t){let e,r,o,n,s=(t=et.checkMatrix(t)).clone(),i=t.rows,l=t.columns,h=new Float64Array(l);for(o=0;o<l;o++){let t=0;for(e=o;e<i;e++)t=ot(t,s.get(e,o));if(0!==t){for(s.get(o,o)<0&&(t=-t),e=o;e<i;e++)s.set(e,o,s.get(e,o)/t);for(s.set(o,o,s.get(o,o)+1),r=o+1;r<l;r++){for(n=0,e=o;e<i;e++)n+=s.get(e,o)*s.get(e,r);for(n=-n/s.get(o,o),e=o;e<i;e++)s.set(e,r,s.get(e,r)+n*s.get(e,o))}}h[o]=-t}this.QR=s,this.Rdiag=h}solve(t){t=Q.checkMatrix(t);let e=this.QR,r=e.rows;if(t.rows!==r)throw new Error("Matrix row dimensions must agree");if(!this.isFullRank())throw new Error("Matrix is rank deficient");let o,n,s,i,l=t.columns,h=t.clone(),a=e.columns;for(s=0;s<a;s++)for(n=0;n<l;n++){for(i=0,o=s;o<r;o++)i+=e.get(o,s)*h.get(o,n);for(i=-i/e.get(s,s),o=s;o<r;o++)h.set(o,n,h.get(o,n)+i*e.get(o,s))}for(s=a-1;s>=0;s--){for(n=0;n<l;n++)h.set(s,n,h.get(s,n)/this.Rdiag[s]);for(o=0;o<s;o++)for(n=0;n<l;n++)h.set(o,n,h.get(o,n)-h.get(s,n)*e.get(o,s))}return h.subMatrix(0,a-1,0,l-1)}isFullRank(){let t=this.QR.columns;for(let e=0;e<t;e++)if(0===this.Rdiag[e])return!1;return!0}get upperTriangularMatrix(){let t,e,r=this.QR,o=r.columns,n=new Q(o,o);for(t=0;t<o;t++)for(e=0;e<o;e++)t<e?n.set(t,e,r.get(t,e)):t===e?n.set(t,e,this.Rdiag[t]):n.set(t,e,0);return n}get orthogonalMatrix(){let t,e,r,o,n=this.QR,s=n.rows,i=n.columns,l=new Q(s,i);for(r=i-1;r>=0;r--){for(t=0;t<s;t++)l.set(t,r,0);for(l.set(r,r,1),e=r;e<i;e++)if(0!==n.get(r,r)){for(o=0,t=r;t<s;t++)o+=n.get(t,r)*l.get(t,e);for(o=-o/n.get(r,r),t=r;t<s;t++)l.set(t,e,l.get(t,e)+o*n.get(t,r))}}return l}}class st{constructor(t,e={}){if((t=et.checkMatrix(t)).isEmpty())throw new Error("Matrix must be non-empty");let r=t.rows,o=t.columns;const{computeLeftSingularVectors:n=!0,computeRightSingularVectors:s=!0,autoTranspose:i=!1}=e;let l,h=Boolean(n),a=Boolean(s),u=!1;if(r<o)if(i){l=t.transpose(),r=l.rows,o=l.columns,u=!0;let e=h;h=a,a=e}else l=t.clone(),console.warn("Computing SVD on a matrix with more columns than rows. Consider enabling autoTranspose");else l=t.clone();let f=Math.min(r,o),c=Math.min(r+1,o),g=new Float64Array(c),m=new Q(r,f),w=new Q(o,o),y=new Float64Array(o),p=new Float64Array(r),d=new Float64Array(c);for(let t=0;t<c;t++)d[t]=t;let x=Math.min(r-1,o),b=Math.max(0,Math.min(o-2,r)),M=Math.max(x,b);for(let t=0;t<M;t++){if(t<x){g[t]=0;for(let e=t;e<r;e++)g[t]=ot(g[t],l.get(e,t));if(0!==g[t]){l.get(t,t)<0&&(g[t]=-g[t]);for(let e=t;e<r;e++)l.set(e,t,l.get(e,t)/g[t]);l.set(t,t,l.get(t,t)+1)}g[t]=-g[t]}for(let e=t+1;e<o;e++){if(t<x&&0!==g[t]){let o=0;for(let n=t;n<r;n++)o+=l.get(n,t)*l.get(n,e);o=-o/l.get(t,t);for(let n=t;n<r;n++)l.set(n,e,l.get(n,e)+o*l.get(n,t))}y[e]=l.get(t,e)}if(h&&t<x)for(let e=t;e<r;e++)m.set(e,t,l.get(e,t));if(t<b){y[t]=0;for(let e=t+1;e<o;e++)y[t]=ot(y[t],y[e]);if(0!==y[t]){y[t+1]<0&&(y[t]=0-y[t]);for(let e=t+1;e<o;e++)y[e]/=y[t];y[t+1]+=1}if(y[t]=-y[t],t+1<r&&0!==y[t]){for(let e=t+1;e<r;e++)p[e]=0;for(let e=t+1;e<r;e++)for(let r=t+1;r<o;r++)p[e]+=y[r]*l.get(e,r);for(let e=t+1;e<o;e++){let o=-y[e]/y[t+1];for(let n=t+1;n<r;n++)l.set(n,e,l.get(n,e)+o*p[n])}}if(a)for(let e=t+1;e<o;e++)w.set(e,t,y[e])}}let v=Math.min(o,r+1);if(x<o&&(g[x]=l.get(x,x)),r<v&&(g[v-1]=0),b+1<v&&(y[b]=l.get(b,v-1)),y[v-1]=0,h){for(let t=x;t<f;t++){for(let e=0;e<r;e++)m.set(e,t,0);m.set(t,t,1)}for(let t=x-1;t>=0;t--)if(0!==g[t]){for(let e=t+1;e<f;e++){let o=0;for(let n=t;n<r;n++)o+=m.get(n,t)*m.get(n,e);o=-o/m.get(t,t);for(let n=t;n<r;n++)m.set(n,e,m.get(n,e)+o*m.get(n,t))}for(let e=t;e<r;e++)m.set(e,t,-m.get(e,t));m.set(t,t,1+m.get(t,t));for(let e=0;e<t-1;e++)m.set(e,t,0)}else{for(let e=0;e<r;e++)m.set(e,t,0);m.set(t,t,1)}}if(a)for(let t=o-1;t>=0;t--){if(t<b&&0!==y[t])for(let e=t+1;e<o;e++){let r=0;for(let n=t+1;n<o;n++)r+=w.get(n,t)*w.get(n,e);r=-r/w.get(t+1,t);for(let n=t+1;n<o;n++)w.set(n,e,w.get(n,e)+r*w.get(n,t))}for(let e=0;e<o;e++)w.set(e,t,0);w.set(t,t,1)}let A=v-1,E=Number.EPSILON;for(;v>0;){let t,e;for(t=v-2;t>=-1&&-1!==t;t--){const e=Number.MIN_VALUE+E*Math.abs(g[t]+Math.abs(g[t+1]));if(Math.abs(y[t])<=e||Number.isNaN(y[t])){y[t]=0;break}}if(t===v-2)e=4;else{let r;for(r=v-1;r>=t&&r!==t;r--){let e=(r!==v?Math.abs(y[r]):0)+(r!==t+1?Math.abs(y[r-1]):0);if(Math.abs(g[r])<=E*e){g[r]=0;break}}r===t?e=3:r===v-1?e=1:(e=2,t=r)}switch(t++,e){case 1:{let e=y[v-2];y[v-2]=0;for(let r=v-2;r>=t;r--){let n=ot(g[r],e),s=g[r]/n,i=e/n;if(g[r]=n,r!==t&&(e=-i*y[r-1],y[r-1]=s*y[r-1]),a)for(let t=0;t<o;t++)n=s*w.get(t,r)+i*w.get(t,v-1),w.set(t,v-1,-i*w.get(t,r)+s*w.get(t,v-1)),w.set(t,r,n)}break}case 2:{let e=y[t-1];y[t-1]=0;for(let o=t;o<v;o++){let n=ot(g[o],e),s=g[o]/n,i=e/n;if(g[o]=n,e=-i*y[o],y[o]=s*y[o],h)for(let e=0;e<r;e++)n=s*m.get(e,o)+i*m.get(e,t-1),m.set(e,t-1,-i*m.get(e,o)+s*m.get(e,t-1)),m.set(e,o,n)}break}case 3:{const e=Math.max(Math.abs(g[v-1]),Math.abs(g[v-2]),Math.abs(y[v-2]),Math.abs(g[t]),Math.abs(y[t])),n=g[v-1]/e,s=g[v-2]/e,i=y[v-2]/e,l=g[t]/e,u=y[t]/e,f=((s+n)*(s-n)+i*i)/2,c=n*i*(n*i);let p=0;0===f&&0===c||(p=f<0?0-Math.sqrt(f*f+c):Math.sqrt(f*f+c),p=c/(f+p));let d=(l+n)*(l-n)+p,x=l*u;for(let e=t;e<v-1;e++){let n=ot(d,x);0===n&&(n=Number.MIN_VALUE);let s=d/n,i=x/n;if(e!==t&&(y[e-1]=n),d=s*g[e]+i*y[e],y[e]=s*y[e]-i*g[e],x=i*g[e+1],g[e+1]=s*g[e+1],a)for(let t=0;t<o;t++)n=s*w.get(t,e)+i*w.get(t,e+1),w.set(t,e+1,-i*w.get(t,e)+s*w.get(t,e+1)),w.set(t,e,n);if(n=ot(d,x),0===n&&(n=Number.MIN_VALUE),s=d/n,i=x/n,g[e]=n,d=s*y[e]+i*g[e+1],g[e+1]=-i*y[e]+s*g[e+1],x=i*y[e+1],y[e+1]=s*y[e+1],h&&e<r-1)for(let t=0;t<r;t++)n=s*m.get(t,e)+i*m.get(t,e+1),m.set(t,e+1,-i*m.get(t,e)+s*m.get(t,e+1)),m.set(t,e,n)}y[v-2]=d;break}case 4:if(g[t]<=0&&(g[t]=g[t]<0?-g[t]:0,a))for(let e=0;e<=A;e++)w.set(e,t,-w.get(e,t));for(;t<A&&!(g[t]>=g[t+1]);){let e=g[t];if(g[t]=g[t+1],g[t+1]=e,a&&t<o-1)for(let r=0;r<o;r++)e=w.get(r,t+1),w.set(r,t+1,w.get(r,t)),w.set(r,t,e);if(h&&t<r-1)for(let o=0;o<r;o++)e=m.get(o,t+1),m.set(o,t+1,m.get(o,t)),m.set(o,t,e);t++}v--}}if(u){let t=w;w=m,m=t}this.m=r,this.n=o,this.s=g,this.U=m,this.V=w}solve(t){let e=t,r=this.threshold,o=this.s.length,n=Q.zeros(o,o);for(let t=0;t<o;t++)Math.abs(this.s[t])<=r?n.set(t,t,0):n.set(t,t,1/this.s[t]);let s=this.U,i=this.rightSingularVectors,l=i.mmul(n),h=i.rows,a=s.rows,u=Q.zeros(h,a);for(let t=0;t<h;t++)for(let e=0;e<a;e++){let r=0;for(let n=0;n<o;n++)r+=l.get(t,n)*s.get(e,n);u.set(t,e,r)}return u.mmul(e)}solveForDiagonal(t){return this.solve(Q.diag(t))}inverse(){let t=this.V,e=this.threshold,r=t.rows,o=t.columns,n=new Q(r,this.s.length);for(let s=0;s<r;s++)for(let r=0;r<o;r++)Math.abs(this.s[r])>e&&n.set(s,r,t.get(s,r)/this.s[r]);let s=this.U,i=s.rows,l=s.columns,h=new Q(r,i);for(let t=0;t<r;t++)for(let e=0;e<i;e++){let r=0;for(let o=0;o<l;o++)r+=n.get(t,o)*s.get(e,o);h.set(t,e,r)}return h}get condition(){return this.s[0]/this.s[Math.min(this.m,this.n)-1]}get norm2(){return this.s[0]}get rank(){let t=Math.max(this.m,this.n)*this.s[0]*Number.EPSILON,e=0,r=this.s;for(let o=0,n=r.length;o<n;o++)r[o]>t&&e++;return e}get diagonal(){return Array.from(this.s)}get threshold(){return Number.EPSILON/2*Math.max(this.m,this.n)*this.s[0]}get leftSingularVectors(){return this.U}get rightSingularVectors(){return this.V}get diagonalMatrix(){return Q.diag(this.s)}}function it(t,e,r=!1){return t=et.checkMatrix(t),e=et.checkMatrix(e),r?new st(t).solve(e):t.isSquare()?new rt(t).solve(e):new nt(t).solve(e)}function lt(t,e){let r=[];for(let o=0;o<t;o++)o!==e&&r.push(o);return r}function ht(t,e,r,o=1e-9,n=1e-9){if(t>n)return new Array(e.rows+1).fill(0);{let t=e.addRow(r,[0]);for(let e=0;e<t.rows;e++)Math.abs(t.get(e,0))<o&&t.set(e,0,0);return t.to1DArray()}}class at{constructor(t,e={}){const{assumeSymmetric:r=!1}=e;if(!(t=et.checkMatrix(t)).isSquare())throw new Error("Matrix is not a square matrix");if(t.isEmpty())throw new Error("Matrix must be non-empty");let o,n,s=t.columns,i=new Q(s,s),l=new Float64Array(s),h=new Float64Array(s),a=t,u=!1;if(u=!!r||t.isSymmetric(),u){for(o=0;o<s;o++)for(n=0;n<s;n++)i.set(o,n,a.get(o,n));!function(t,e,r,o){let n,s,i,l,h,a,u,f;for(h=0;h<t;h++)r[h]=o.get(t-1,h);for(l=t-1;l>0;l--){for(f=0,i=0,a=0;a<l;a++)f+=Math.abs(r[a]);if(0===f)for(e[l]=r[l-1],h=0;h<l;h++)r[h]=o.get(l-1,h),o.set(l,h,0),o.set(h,l,0);else{for(a=0;a<l;a++)r[a]/=f,i+=r[a]*r[a];for(n=r[l-1],s=Math.sqrt(i),n>0&&(s=-s),e[l]=f*s,i-=n*s,r[l-1]=n-s,h=0;h<l;h++)e[h]=0;for(h=0;h<l;h++){for(n=r[h],o.set(h,l,n),s=e[h]+o.get(h,h)*n,a=h+1;a<=l-1;a++)s+=o.get(a,h)*r[a],e[a]+=o.get(a,h)*n;e[h]=s}for(n=0,h=0;h<l;h++)e[h]/=i,n+=e[h]*r[h];for(u=n/(i+i),h=0;h<l;h++)e[h]-=u*r[h];for(h=0;h<l;h++){for(n=r[h],s=e[h],a=h;a<=l-1;a++)o.set(a,h,o.get(a,h)-(n*e[a]+s*r[a]));r[h]=o.get(l-1,h),o.set(l,h,0)}}r[l]=i}for(l=0;l<t-1;l++){if(o.set(t-1,l,o.get(l,l)),o.set(l,l,1),i=r[l+1],0!==i){for(a=0;a<=l;a++)r[a]=o.get(a,l+1)/i;for(h=0;h<=l;h++){for(s=0,a=0;a<=l;a++)s+=o.get(a,l+1)*o.get(a,h);for(a=0;a<=l;a++)o.set(a,h,o.get(a,h)-s*r[a])}}for(a=0;a<=l;a++)o.set(a,l+1,0)}for(h=0;h<t;h++)r[h]=o.get(t-1,h),o.set(t-1,h,0);o.set(t-1,t-1,1),e[0]=0}(s,h,l,i),function(t,e,r,o){let n,s,i,l,h,a,u,f,c,g,m,w,y,p,d,x;for(i=1;i<t;i++)e[i-1]=e[i];e[t-1]=0;let b=0,M=0,v=Number.EPSILON;for(a=0;a<t;a++){for(M=Math.max(M,Math.abs(r[a])+Math.abs(e[a])),u=a;u<t&&!(Math.abs(e[u])<=v*M);)u++;if(u>a)do{for(n=r[a],f=(r[a+1]-n)/(2*e[a]),c=ot(f,1),f<0&&(c=-c),r[a]=e[a]/(f+c),r[a+1]=e[a]*(f+c),g=r[a+1],s=n-r[a],i=a+2;i<t;i++)r[i]-=s;for(b+=s,f=r[u],m=1,w=m,y=m,p=e[a+1],d=0,x=0,i=u-1;i>=a;i--)for(y=w,w=m,x=d,n=m*e[i],s=m*f,c=ot(f,e[i]),e[i+1]=d*c,d=e[i]/c,m=f/c,f=m*r[i]-d*n,r[i+1]=s+d*(m*n+d*r[i]),h=0;h<t;h++)s=o.get(h,i+1),o.set(h,i+1,d*o.get(h,i)+m*s),o.set(h,i,m*o.get(h,i)-d*s);f=-d*x*y*p*e[a]/g,e[a]=d*f,r[a]=m*f}while(Math.abs(e[a])>v*M);r[a]=r[a]+b,e[a]=0}for(i=0;i<t-1;i++){for(h=i,f=r[i],l=i+1;l<t;l++)r[l]<f&&(h=l,f=r[l]);if(h!==i)for(r[h]=r[i],r[i]=f,l=0;l<t;l++)f=o.get(l,i),o.set(l,i,o.get(l,h)),o.set(l,h,f)}}(s,h,l,i)}else{let t=new Q(s,s),e=new Float64Array(s);for(n=0;n<s;n++)for(o=0;o<s;o++)t.set(o,n,a.get(o,n));!function(t,e,r,o){let n,s,i,l,h,a,u,f=0,c=t-1;for(a=f+1;a<=c-1;a++){for(u=0,l=a;l<=c;l++)u+=Math.abs(e.get(l,a-1));if(0!==u){for(i=0,l=c;l>=a;l--)r[l]=e.get(l,a-1)/u,i+=r[l]*r[l];for(s=Math.sqrt(i),r[a]>0&&(s=-s),i-=r[a]*s,r[a]=r[a]-s,h=a;h<t;h++){for(n=0,l=c;l>=a;l--)n+=r[l]*e.get(l,h);for(n/=i,l=a;l<=c;l++)e.set(l,h,e.get(l,h)-n*r[l])}for(l=0;l<=c;l++){for(n=0,h=c;h>=a;h--)n+=r[h]*e.get(l,h);for(n/=i,h=a;h<=c;h++)e.set(l,h,e.get(l,h)-n*r[h])}r[a]=u*r[a],e.set(a,a-1,u*s)}}for(l=0;l<t;l++)for(h=0;h<t;h++)o.set(l,h,l===h?1:0);for(a=c-1;a>=f+1;a--)if(0!==e.get(a,a-1)){for(l=a+1;l<=c;l++)r[l]=e.get(l,a-1);for(h=a;h<=c;h++){for(s=0,l=a;l<=c;l++)s+=r[l]*o.get(l,h);for(s=s/r[a]/e.get(a,a-1),l=a;l<=c;l++)o.set(l,h,o.get(l,h)+s*r[l])}}}(s,t,e,i),function(t,e,r,o,n){let s,i,l,h,a,u,f,c,g,m,w,y,p,d,x,b=t-1,M=0,v=t-1,A=Number.EPSILON,E=0,I=0,S=0,R=0,N=0,F=0,T=0,_=0;for(s=0;s<t;s++)for((s<M||s>v)&&(r[s]=n.get(s,s),e[s]=0),i=Math.max(s-1,0);i<t;i++)I+=Math.abs(n.get(s,i));for(;b>=M;){for(h=b;h>M&&(F=Math.abs(n.get(h-1,h-1))+Math.abs(n.get(h,h)),0===F&&(F=I),!(Math.abs(n.get(h,h-1))<A*F));)h--;if(h===b)n.set(b,b,n.get(b,b)+E),r[b]=n.get(b,b),e[b]=0,b--,_=0;else if(h===b-1){if(f=n.get(b,b-1)*n.get(b-1,b),S=(n.get(b-1,b-1)-n.get(b,b))/2,R=S*S+f,T=Math.sqrt(Math.abs(R)),n.set(b,b,n.get(b,b)+E),n.set(b-1,b-1,n.get(b-1,b-1)+E),c=n.get(b,b),R>=0){for(T=S>=0?S+T:S-T,r[b-1]=c+T,r[b]=r[b-1],0!==T&&(r[b]=c-f/T),e[b-1]=0,e[b]=0,c=n.get(b,b-1),F=Math.abs(c)+Math.abs(T),S=c/F,R=T/F,N=Math.sqrt(S*S+R*R),S/=N,R/=N,i=b-1;i<t;i++)T=n.get(b-1,i),n.set(b-1,i,R*T+S*n.get(b,i)),n.set(b,i,R*n.get(b,i)-S*T);for(s=0;s<=b;s++)T=n.get(s,b-1),n.set(s,b-1,R*T+S*n.get(s,b)),n.set(s,b,R*n.get(s,b)-S*T);for(s=M;s<=v;s++)T=o.get(s,b-1),o.set(s,b-1,R*T+S*o.get(s,b)),o.set(s,b,R*o.get(s,b)-S*T)}else r[b-1]=c+S,r[b]=c+S,e[b-1]=T,e[b]=-T;b-=2,_=0}else{if(c=n.get(b,b),g=0,f=0,h<b&&(g=n.get(b-1,b-1),f=n.get(b,b-1)*n.get(b-1,b)),10===_){for(E+=c,s=M;s<=b;s++)n.set(s,s,n.get(s,s)-c);F=Math.abs(n.get(b,b-1))+Math.abs(n.get(b-1,b-2)),c=g=.75*F,f=-.4375*F*F}if(30===_&&(F=(g-c)/2,F=F*F+f,F>0)){for(F=Math.sqrt(F),g<c&&(F=-F),F=c-f/((g-c)/2+F),s=M;s<=b;s++)n.set(s,s,n.get(s,s)-F);E+=F,c=g=f=.964}for(_+=1,a=b-2;a>=h&&(T=n.get(a,a),N=c-T,F=g-T,S=(N*F-f)/n.get(a+1,a)+n.get(a,a+1),R=n.get(a+1,a+1)-T-N-F,N=n.get(a+2,a+1),F=Math.abs(S)+Math.abs(R)+Math.abs(N),S/=F,R/=F,N/=F,a!==h)&&!(Math.abs(n.get(a,a-1))*(Math.abs(R)+Math.abs(N))<A*(Math.abs(S)*(Math.abs(n.get(a-1,a-1))+Math.abs(T)+Math.abs(n.get(a+1,a+1)))));)a--;for(s=a+2;s<=b;s++)n.set(s,s-2,0),s>a+2&&n.set(s,s-3,0);for(l=a;l<=b-1&&(d=l!==b-1,l!==a&&(S=n.get(l,l-1),R=n.get(l+1,l-1),N=d?n.get(l+2,l-1):0,c=Math.abs(S)+Math.abs(R)+Math.abs(N),0!==c&&(S/=c,R/=c,N/=c)),0!==c);l++)if(F=Math.sqrt(S*S+R*R+N*N),S<0&&(F=-F),0!==F){for(l!==a?n.set(l,l-1,-F*c):h!==a&&n.set(l,l-1,-n.get(l,l-1)),S+=F,c=S/F,g=R/F,T=N/F,R/=S,N/=S,i=l;i<t;i++)S=n.get(l,i)+R*n.get(l+1,i),d&&(S+=N*n.get(l+2,i),n.set(l+2,i,n.get(l+2,i)-S*T)),n.set(l,i,n.get(l,i)-S*c),n.set(l+1,i,n.get(l+1,i)-S*g);for(s=0;s<=Math.min(b,l+3);s++)S=c*n.get(s,l)+g*n.get(s,l+1),d&&(S+=T*n.get(s,l+2),n.set(s,l+2,n.get(s,l+2)-S*N)),n.set(s,l,n.get(s,l)-S),n.set(s,l+1,n.get(s,l+1)-S*R);for(s=M;s<=v;s++)S=c*o.get(s,l)+g*o.get(s,l+1),d&&(S+=T*o.get(s,l+2),o.set(s,l+2,o.get(s,l+2)-S*N)),o.set(s,l,o.get(s,l)-S),o.set(s,l+1,o.get(s,l+1)-S*R)}}}if(0===I)return;for(b=t-1;b>=0;b--)if(S=r[b],R=e[b],0===R)for(h=b,n.set(b,b,1),s=b-1;s>=0;s--){for(f=n.get(s,s)-S,N=0,i=h;i<=b;i++)N+=n.get(s,i)*n.get(i,b);if(e[s]<0)T=f,F=N;else if(h=s,0===e[s]?n.set(s,b,0!==f?-N/f:-N/(A*I)):(c=n.get(s,s+1),g=n.get(s+1,s),R=(r[s]-S)*(r[s]-S)+e[s]*e[s],u=(c*F-T*N)/R,n.set(s,b,u),n.set(s+1,b,Math.abs(c)>Math.abs(T)?(-N-f*u)/c:(-F-g*u)/T)),u=Math.abs(n.get(s,b)),A*u*u>1)for(i=s;i<=b;i++)n.set(i,b,n.get(i,b)/u)}else if(R<0)for(h=b-1,Math.abs(n.get(b,b-1))>Math.abs(n.get(b-1,b))?(n.set(b-1,b-1,R/n.get(b,b-1)),n.set(b-1,b,-(n.get(b,b)-S)/n.get(b,b-1))):(x=ut(0,-n.get(b-1,b),n.get(b-1,b-1)-S,R),n.set(b-1,b-1,x[0]),n.set(b-1,b,x[1])),n.set(b,b-1,0),n.set(b,b,1),s=b-2;s>=0;s--){for(m=0,w=0,i=h;i<=b;i++)m+=n.get(s,i)*n.get(i,b-1),w+=n.get(s,i)*n.get(i,b);if(f=n.get(s,s)-S,e[s]<0)T=f,N=m,F=w;else if(h=s,0===e[s]?(x=ut(-m,-w,f,R),n.set(s,b-1,x[0]),n.set(s,b,x[1])):(c=n.get(s,s+1),g=n.get(s+1,s),y=(r[s]-S)*(r[s]-S)+e[s]*e[s]-R*R,p=2*(r[s]-S)*R,0===y&&0===p&&(y=A*I*(Math.abs(f)+Math.abs(R)+Math.abs(c)+Math.abs(g)+Math.abs(T))),x=ut(c*N-T*m+R*w,c*F-T*w-R*m,y,p),n.set(s,b-1,x[0]),n.set(s,b,x[1]),Math.abs(c)>Math.abs(T)+Math.abs(R)?(n.set(s+1,b-1,(-m-f*n.get(s,b-1)+R*n.get(s,b))/c),n.set(s+1,b,(-w-f*n.get(s,b)-R*n.get(s,b-1))/c)):(x=ut(-N-g*n.get(s,b-1),-F-g*n.get(s,b),T,R),n.set(s+1,b-1,x[0]),n.set(s+1,b,x[1]))),u=Math.max(Math.abs(n.get(s,b-1)),Math.abs(n.get(s,b))),A*u*u>1)for(i=s;i<=b;i++)n.set(i,b-1,n.get(i,b-1)/u),n.set(i,b,n.get(i,b)/u)}for(s=0;s<t;s++)if(s<M||s>v)for(i=s;i<t;i++)o.set(s,i,n.get(s,i));for(i=t-1;i>=M;i--)for(s=M;s<=v;s++){for(T=0,l=M;l<=Math.min(i,v);l++)T+=o.get(s,l)*n.get(l,i);o.set(s,i,T)}}(s,h,l,i,t)}this.n=s,this.e=h,this.d=l,this.V=i}get realEigenvalues(){return Array.from(this.d)}get imaginaryEigenvalues(){return Array.from(this.e)}get eigenvectorMatrix(){return this.V}get diagonalMatrix(){let t,e,r=this.n,o=this.e,n=this.d,s=new Q(r,r);for(t=0;t<r;t++){for(e=0;e<r;e++)s.set(t,e,0);s.set(t,t,n[t]),o[t]>0?s.set(t,t+1,o[t]):o[t]<0&&s.set(t,t-1,o[t])}return s}}function ut(t,e,r,o){let n,s;return Math.abs(r)>Math.abs(o)?(n=o/r,s=r+n*o,[(t+n*e)/s,(e-n*t)/s]):(n=r/o,s=o+n*r,[(n*t+e)/s,(n*e-t)/s])}class ft{constructor(t){if(!(t=et.checkMatrix(t)).isSymmetric())throw new Error("Matrix is not symmetric");let e,r,o,n=t,s=n.rows,i=new Q(s,s),l=!0;for(r=0;r<s;r++){let t=0;for(o=0;o<r;o++){let s=0;for(e=0;e<o;e++)s+=i.get(o,e)*i.get(r,e);s=(n.get(r,o)-s)/i.get(o,o),i.set(r,o,s),t+=s*s}for(t=n.get(r,r)-t,l&&=t>0,i.set(r,r,Math.sqrt(Math.max(t,0))),o=r+1;o<s;o++)i.set(r,o,0)}this.L=i,this.positiveDefinite=l}isPositiveDefinite(){return this.positiveDefinite}solve(t){t=et.checkMatrix(t);let e=this.L,r=e.rows;if(t.rows!==r)throw new Error("Matrix dimensions do not match");if(!1===this.isPositiveDefinite())throw new Error("Matrix is not positive definite");let o,n,s,i=t.columns,l=t.clone();for(s=0;s<r;s++)for(n=0;n<i;n++){for(o=0;o<s;o++)l.set(s,n,l.get(s,n)-l.get(o,n)*e.get(s,o));l.set(s,n,l.get(s,n)/e.get(s,s))}for(s=r-1;s>=0;s--)for(n=0;n<i;n++){for(o=s+1;o<r;o++)l.set(s,n,l.get(s,n)-l.get(o,n)*e.get(o,s));l.set(s,n,l.get(s,n)/e.get(s,s))}return l}get lowerTriangularMatrix(){return this.L}}class ct{constructor(t,e={}){t=et.checkMatrix(t);let{Y:r}=e;const{scaleScores:o=!1,maxIterations:n=1e3,terminationCriteria:s=1e-10}=e;let i;if(r){if(r=F.isAnyArray(r)&&"number"==typeof r[0]?Q.columnVector(r):et.checkMatrix(r),r.rows!==t.rows)throw new Error("Y should have the same number of rows as X");i=r.getColumnVector(0)}else i=t.getColumnVector(0);let l,h,a,u,f=1;for(let e=0;e<n&&f>s;e++)a=t.transpose().mmul(i).div(i.transpose().mmul(i).get(0,0)),a=a.div(a.norm()),l=t.mmul(a).div(a.transpose().mmul(a).get(0,0)),e>0&&(f=l.clone().sub(u).pow(2).sum()),u=l.clone(),r?(h=r.transpose().mmul(l).div(l.transpose().mmul(l).get(0,0)),h=h.div(h.norm()),i=r.mmul(h).div(h.transpose().mmul(h).get(0,0))):i=l;if(r){let e=t.transpose().mmul(l).div(l.transpose().mmul(l).get(0,0));e=e.div(e.norm());let o=t.clone().sub(l.clone().mmul(e.transpose())),n=i.transpose().mmul(l).div(l.transpose().mmul(l).get(0,0)),s=r.clone().sub(l.clone().mulS(n.get(0,0)).mmul(h.transpose()));this.t=l,this.p=e.transpose(),this.w=a.transpose(),this.q=h,this.u=i,this.s=l.transpose().mmul(l),this.xResidual=o,this.yResidual=s,this.betas=n}else this.w=a.transpose(),this.s=l.transpose().mmul(l).sqrt(),this.t=o?l.clone().div(this.s.get(0,0)):l,this.xResidual=t.sub(l.mmul(a.transpose()))}}S.AbstractMatrix=G,S.CHO=ft,S.CholeskyDecomposition=ft,S.DistanceMatrix=H,S.EVD=at,S.EigenvalueDecomposition=at,S.LU=rt,S.LuDecomposition=rt;var gt=S.Matrix=Q;S.MatrixColumnSelectionView=class extends Z{constructor(t,e){O(t,e),super(t,t.rows,e.length),this.columnIndices=e}set(t,e,r){return this.matrix.set(t,this.columnIndices[e],r),this}get(t,e){return this.matrix.get(t,this.columnIndices[e])}},S.MatrixColumnView=class extends Z{constructor(t,e){P(t,e),super(t,t.rows,1),this.column=e}set(t,e,r){return this.matrix.set(t,this.column,r),this}get(t){return this.matrix.get(t,this.column)}},S.MatrixFlipColumnView=class extends Z{constructor(t){super(t,t.rows,t.columns)}set(t,e,r){return this.matrix.set(t,this.columns-e-1,r),this}get(t,e){return this.matrix.get(t,this.columns-e-1)}},S.MatrixFlipRowView=class extends Z{constructor(t){super(t,t.rows,t.columns)}set(t,e,r){return this.matrix.set(this.rows-t-1,e,r),this}get(t,e){return this.matrix.get(this.rows-t-1,e)}},S.MatrixRowSelectionView=class extends Z{constructor(t,e){D(t,e),super(t,e.length,t.columns),this.rowIndices=e}set(t,e,r){return this.matrix.set(this.rowIndices[t],e,r),this}get(t,e){return this.matrix.get(this.rowIndices[t],e)}},S.MatrixRowView=class extends Z{constructor(t,e){z(t,e),super(t,1,t.columns),this.row=e}set(t,e,r){return this.matrix.set(this.row,e,r),this}get(t,e){return this.matrix.get(this.row,e)}},S.MatrixSelectionView=K,S.MatrixSubView=class extends Z{constructor(t,e,r,o,n){L(t,e,r,o,n),super(t,r-e+1,n-o+1),this.startRow=e,this.startColumn=o}set(t,e,r){return this.matrix.set(this.startRow+t,this.startColumn+e,r),this}get(t,e){return this.matrix.get(this.startRow+t,this.startColumn+e)}},S.MatrixTransposeView=class extends Z{constructor(t){super(t,t.columns,t.rows)}set(t,e,r){return this.matrix.set(e,t,r),this}get(t,e){return this.matrix.get(e,t)}},S.NIPALS=ct,S.Nipals=ct,S.QR=nt,S.QrDecomposition=nt,S.SVD=st,S.SingularValueDecomposition=st,S.SymmetricMatrix=J,S.WrapperMatrix1D=tt,S.WrapperMatrix2D=et,S.correlation=function(t,e=t,r={}){t=new Q(t);let o=!1;if("object"!=typeof e||Q.isMatrix(e)||F.isAnyArray(e)?e=new Q(e):(r=e,e=t,o=!0),t.rows!==e.rows)throw new TypeError("Both matrices must have the same number of rows");const{center:n=!0,scale:s=!0}=r;n&&(t.center("column"),o||e.center("column")),s&&(t.scale("column"),o||e.scale("column"));const i=t.standardDeviation("column",{unbiased:!0}),l=o?i:e.standardDeviation("column",{unbiased:!0}),h=t.transpose().mmul(e);for(let e=0;e<h.rows;e++)for(let r=0;r<h.columns;r++)h.set(e,r,h.get(e,r)*(1/(i[e]*l[r]))*(1/(t.rows-1)));return h},S.covariance=function(t,e=t,r={}){t=new Q(t);let o=!1;if("object"!=typeof e||Q.isMatrix(e)||F.isAnyArray(e)?e=new Q(e):(r=e,e=t,o=!0),t.rows!==e.rows)throw new TypeError("Both matrices must have the same number of rows");const{center:n=!0}=r;n&&(t=t.center("column"),o||(e=e.center("column")));const s=t.transpose().mmul(e);for(let e=0;e<s.rows;e++)for(let r=0;r<s.columns;r++)s.set(e,r,s.get(e,r)*(1/(t.rows-1)));return s};var mt=S.default=Q;S.determinant=function t(e){if((e=Q.checkMatrix(e)).isSquare()){if(0===e.columns)return 1;let r,o,n,s;if(2===e.columns)return r=e.get(0,0),o=e.get(0,1),n=e.get(1,0),s=e.get(1,1),r*s-o*n;if(3===e.columns){let s,i,l;return s=new K(e,[1,2],[1,2]),i=new K(e,[1,2],[0,2]),l=new K(e,[1,2],[0,1]),r=e.get(0,0),o=e.get(0,1),n=e.get(0,2),r*t(s)-o*t(i)+n*t(l)}return new rt(e).determinant}throw Error("determinant can only be calculated for a square matrix")},S.inverse=function(t,e=!1){return t=et.checkMatrix(t),e?new st(t).inverse():it(t,Q.eye(t.rows))},S.linearDependencies=function(t,e={}){const{thresholdValue:r=1e-9,thresholdError:o=1e-9}=e;let n=(t=Q.checkMatrix(t)).rows,s=new Q(n,n);for(let e=0;e<n;e++){let i=Q.columnVector(t.getRow(e)),l=t.subMatrixRow(lt(n,e)).transpose(),h=new st(l).solve(i),a=Q.sub(i,l.mmul(h)).abs().max();s.setRow(e,ht(a,h,e,r,o))}return s},S.pseudoInverse=function(t,e=Number.EPSILON){if((t=Q.checkMatrix(t)).isEmpty())return t.transpose();let r=new st(t,{autoTranspose:!0}),o=r.leftSingularVectors,n=r.rightSingularVectors,s=r.diagonal;for(let t=0;t<s.length;t++)Math.abs(s[t])>e?s[t]=1/s[t]:s[t]=0;return n.mmul(Q.diag(s).mmul(o.transpose()))},S.solve=it,S.wrap=function(t,e){if(F.isAnyArray(t))return t[0]&&F.isAnyArray(t[0])?new et(t):new tt(t,e);throw new Error("the argument is not an array")};const wt=gt;mt.Matrix&&mt.Matrix;const yt=(t,e)=>Math.abs(t-e);function pt(t,e,r={}){const{fct:o=yt}=r,n=t.length,s=e.length,i=new wt(n,s);for(let r=0;r<n;r++)for(let n=0;n<s;n++)i.set(r,n,o(t[r],e[n]));return i}function dt(t){if(!r(t))throw new TypeError("input must be an array");const e=new Float64Array(t.length);if(0===t.length)return e;e[0]=t[0];for(let r=1;r<t.length;r++)e[r]=e[r-1]+t[r];return e}function xt(t,e={}){u(t);const{fromIndex:r,toIndex:o}=c(t,e);let n=t[r];for(let e=r+1;e<=o;e++)n+=t[e];return n/(o-r+1)}function bt(t,e={}){if(!r(t))throw new TypeError("input must be an array");const{unbiased:o=!0,mean:n=xt(t)}=e;let s=0;for(const e of t){const t=e-n;s+=t*t}return o?s/(t.length-1):s/t.length}function Mt(t,e={}){return Math.sqrt(bt(t,e))}function vt(t){return{...M(t),mean:xt(t),sd:Mt(t),nb:t.length}}function At(t,e,n={}){let s=!1,i=0;if(r(e)){if(t.length!==e.length)throw new RangeError("size of array1 and array2 must be identical")}else s=!0,i=e;const l=o(n.output,t.length);if(s)for(let e=0;e<t.length;e++)l[e]=t[e]/i;else for(let r=0;r<t.length;r++)l[r]=t[r]/e[r];return l}function Et(t){return u(t),t instanceof Float64Array?t.slice(0):Float64Array.from(t)}function It(t,e={}){const{target:r,targetIndex:o}=e;return void 0===o?void 0!==r?f(t,r):0:o}function St(t){if(this.size=0|t,this.size<=1||this.size&this.size-1)throw new Error("FFT size must be a power of two and bigger than 1");this._csize=t<<1;for(var e=new Array(2*this.size),r=0;r<e.length;r+=2){const t=Math.PI*r/this.size;e[r]=Math.cos(t),e[r+1]=-Math.sin(t)}this.table=e;for(var o=0,n=1;this.size>n;n<<=1)o++;this._width=o%2==0?o-1:o,this._bitrev=new Array(1<<this._width);for(var s=0;s<this._bitrev.length;s++){this._bitrev[s]=0;for(var i=0;i<this._width;i+=2){var l=this._width-i-2;this._bitrev[s]|=(s>>>i&3)<<l}}this._out=null,this._data=null,this._inv=0}var Rt=St;St.prototype.fromComplexArray=function(t,e){for(var r=e||new Array(t.length>>>1),o=0;o<t.length;o+=2)r[o>>>1]=t[o];return r},St.prototype.createComplexArray=function(){const t=new Array(this._csize);for(var e=0;e<t.length;e++)t[e]=0;return t},St.prototype.toComplexArray=function(t,e){for(var r=e||this.createComplexArray(),o=0;o<r.length;o+=2)r[o]=t[o>>>1],r[o+1]=0;return r},St.prototype.completeSpectrum=function(t){for(var e=this._csize,r=e>>>1,o=2;o<r;o+=2)t[e-o]=t[o],t[e-o+1]=-t[o+1]},St.prototype.transform=function(t,e){if(t===e)throw new Error("Input and output buffers must be different");this._out=t,this._data=e,this._inv=0,this._transform4(),this._out=null,this._data=null},St.prototype.realTransform=function(t,e){if(t===e)throw new Error("Input and output buffers must be different");this._out=t,this._data=e,this._inv=0,this._realTransform4(),this._out=null,this._data=null},St.prototype.inverseTransform=function(t,e){if(t===e)throw new Error("Input and output buffers must be different");this._out=t,this._data=e,this._inv=1,this._transform4();for(var r=0;r<t.length;r++)t[r]/=this.size;this._out=null,this._data=null},St.prototype._transform4=function(){var t,e,r=this._out,o=this._csize,n=1<<this._width,s=o/n<<1,i=this._bitrev;if(4===s)for(t=0,e=0;t<o;t+=s,e++){const r=i[e];this._singleTransform2(t,r,n)}else for(t=0,e=0;t<o;t+=s,e++){const r=i[e];this._singleTransform4(t,r,n)}var l=this._inv?-1:1,h=this.table;for(n>>=2;n>=2;n>>=2){var a=(s=o/n<<1)>>>2;for(t=0;t<o;t+=s)for(var u=t+a,f=t,c=0;f<u;f+=2,c+=n){const t=f,e=t+a,o=e+a,n=o+a,s=r[t],i=r[t+1],u=r[e],g=r[e+1],m=r[o],w=r[o+1],y=r[n],p=r[n+1],d=s,x=i,b=h[c],M=l*h[c+1],v=u*b-g*M,A=u*M+g*b,E=h[2*c],I=l*h[2*c+1],S=m*E-w*I,R=m*I+w*E,N=h[3*c],F=l*h[3*c+1],T=y*N-p*F,_=y*F+p*N,k=d+S,C=x+R,V=d-S,q=x-R,z=v+T,P=A+_,j=l*(v-T),$=l*(A-_),D=k+z,O=C+P,L=k-z,Y=C-P,U=V+$,X=q-j,G=V-$,B=q+j;r[t]=D,r[t+1]=O,r[e]=U,r[e+1]=X,r[o]=L,r[o+1]=Y,r[n]=G,r[n+1]=B}}},St.prototype._singleTransform2=function(t,e,r){const o=this._out,n=this._data,s=n[e],i=n[e+1],l=n[e+r],h=n[e+r+1],a=s+l,u=i+h,f=s-l,c=i-h;o[t]=a,o[t+1]=u,o[t+2]=f,o[t+3]=c},St.prototype._singleTransform4=function(t,e,r){const o=this._out,n=this._data,s=this._inv?-1:1,i=2*r,l=3*r,h=n[e],a=n[e+1],u=n[e+r],f=n[e+r+1],c=n[e+i],g=n[e+i+1],m=n[e+l],w=n[e+l+1],y=h+c,p=a+g,d=h-c,x=a-g,b=u+m,M=f+w,v=s*(u-m),A=s*(f-w),E=y+b,I=p+M,S=d+A,R=x-v,N=y-b,F=p-M,T=d-A,_=x+v;o[t]=E,o[t+1]=I,o[t+2]=S,o[t+3]=R,o[t+4]=N,o[t+5]=F,o[t+6]=T,o[t+7]=_},St.prototype._realTransform4=function(){var t,e,r=this._out,o=this._csize,n=1<<this._width,s=o/n<<1,i=this._bitrev;if(4===s)for(t=0,e=0;t<o;t+=s,e++){const r=i[e];this._singleRealTransform2(t,r>>>1,n>>>1)}else for(t=0,e=0;t<o;t+=s,e++){const r=i[e];this._singleRealTransform4(t,r>>>1,n>>>1)}var l=this._inv?-1:1,h=this.table;for(n>>=2;n>=2;n>>=2){var a=(s=o/n<<1)>>>1,u=a>>>1,f=u>>>1;for(t=0;t<o;t+=s)for(var c=0,g=0;c<=f;c+=2,g+=n){var m=t+c,w=m+u,y=w+u,p=y+u,d=r[m],x=r[m+1],b=r[w],M=r[w+1],v=r[y],A=r[y+1],E=r[p],I=r[p+1],S=d,R=x,N=h[g],F=l*h[g+1],T=b*N-M*F,_=b*F+M*N,k=h[2*g],C=l*h[2*g+1],V=v*k-A*C,q=v*C+A*k,z=h[3*g],P=l*h[3*g+1],j=E*z-I*P,$=E*P+I*z,D=S+V,O=R+q,L=S-V,Y=R-q,U=T+j,X=_+$,G=l*(T-j),B=l*(_-$),W=D+U,Q=O+X,J=L+B,H=Y-G;if(r[m]=W,r[m+1]=Q,r[w]=J,r[w+1]=H,0!==c){if(c!==f){var Z=L+-l*B,K=-Y+-l*G,tt=D+-l*U,et=-O- -l*X,rt=t+u-c,ot=t+a-c;r[rt]=Z,r[rt+1]=K,r[ot]=tt,r[ot+1]=et}}else{var nt=D-U,st=O-X;r[y]=nt,r[y+1]=st}}}},St.prototype._singleRealTransform2=function(t,e,r){const o=this._out,n=this._data,s=n[e],i=n[e+r],l=s+i,h=s-i;o[t]=l,o[t+1]=0,o[t+2]=h,o[t+3]=0},St.prototype._singleRealTransform4=function(t,e,r){const o=this._out,n=this._data,s=this._inv?-1:1,i=2*r,l=3*r,h=n[e],a=n[e+r],u=n[e+i],f=n[e+l],c=h+u,g=h-u,m=a+f,w=s*(a-f),y=c+m,p=g,d=-w,x=c-m,b=g,M=w;o[t]=y,o[t+1]=0,o[t+2]=p,o[t+3]=d,o[t+4]=x,o[t+5]=0,o[t+6]=b,o[t+7]=M};var Nt=E(Rt);function Ft(t,e){return t===Array?new t(e).fill(0):new t(e)}function Tt(t,e){return t===Array?new t(e).fill(0):new t(e)}function _t(t={}){const{from:e=0,to:r=1,length:o=1e3,includeFrom:n=!0,includeTo:s=!0,distribution:i="uniform"}=t,l=new Float64Array(o);let h=o;n&&s?h=o-1:!n&&s||n&&!s?h=o:n||s||(h=o+1);const a=(r-e)/h;if("uniform"===i)if(n){let t=0;for(;t<o;)l[t]=e+a*t,t++}else{let t=0;for(;t<o;)l[t]=e+a*(t+1),t++}else{if("log"!==i)throw new Error("distribution must be uniform or log");{const t=(r/e)**(1/h),s=Math.log(e)/Math.log(t);if(n){let e=0;for(;e<o;)l[e]=t**(s+e),e++}else{let e=0;for(;e<o;)l[e]=t**(s+e+1),e++}}}return l}const kt=1/16777216;function Ct(t,e){const r=65535&(t>>>=0);return((t-r)*(e>>>=0)>>>0)+r*e>>>0}class Vt{random;state;constructor(t=Date.now()){this.state=new Uint32Array(4),this.init(t),this.random=this.getFloat.bind(this)}getUint32(){return this.nextState(),this.state[3]+this.state[2]>>>0}getFloat(){return(this.getUint32()>>>8)*kt}init(t){if(!Number.isInteger(t))throw new TypeError("seed must be an integer");this.state[0]=t,this.state[1]=0,this.state[2]=0,this.state[3]=0;for(let t=1;t<8;t++)this.state[3&t]^=t+Ct(1812433253,this.state[t-1&3]^this.state[t-1&3]>>>30>>>0)>>>0;this.periodCertification();for(let t=0;t<8;t++)this.nextState()}periodCertification(){0===this.state[0]&&0===this.state[1]&&0===this.state[2]&&0===this.state[3]&&(this.state[0]=88,this.state[1]=83,this.state[2]=65,this.state[3]=68)}nextState(){let t=this.state[0];t^=t<<15,t^=t>>>18,t^=this.state[3]<<11,this.state[0]=this.state[1],this.state[1]=this.state[2],this.state[2]=this.state[3],this.state[3]=t}}function qt(t={}){const{mean:e=0,standardDeviation:r=1,length:o=1e3,range:n=1,seed:s,distribution:i="normal"}=t,l=new Vt(s),h=new Float64Array(o);switch(i){case"normal":{const t=new zt(e,r,l);for(let e=0;e<o;e++)h[e]=t.generateGaussian();break}case"uniform":for(let t=0;t<o;t++)h[t]=(l.random()-.5)*n+e;break;default:throw new Error(`unknown distribution: ${String(i)}`)}return h}class zt{#r=0;#o=!1;#n;#s;#i;constructor(t,e,r){this.#n=t,this.#s=e,this.#i=r}generateGaussian(){let t,e,r,o;if(this.#o)this.#o=!1,t=this.#r*this.#s+this.#n;else{do{e=2*this.#i.random()-1,r=2*this.#i.random()-1,o=e*e+r*r}while(o>=1||0===o);o=Math.sqrt(-2*Math.log(o)/o),this.#r=r*o,this.#o=!0,t=this.#n+this.#s*e*o}return t}}function Pt(t={}){const{from:e=0,step:r=1,length:o=1e3}=t,n=new Float64Array(o);let s=0;for(;s<o;)n[s]=e+r*s,s++;return n}function jt(t={}){const{targetMin:e=0,targetMax:r=1,clamp:o=!0,algorithmOptions:n={},algorithm:s="linear"}=t;let{originalMin:i=0,originalMax:l=1}=t;const h=function(t="linear",e={}){return r=>{switch(t){case"linear":return r;case"logarithmic":return Math.log10(r);case"power":return r**(e.power||2);default:throw new Error(`Unknown kind ${String(t)}`)}}}(s,n);i=h(i),l=h(l);const a=l-i,u=r-e;return function(t){t=function(t,e,r,o=!0){if(t<e){if(o)return e;throw new RangeError(`Value ${t} is out of range [${e}, ${r}]`)}if(t>r){if(o)return r;throw new RangeError(`Value ${t} is out of range [${e}, ${r}]`)}return t}(t=h(t),i,l,o);return e+(t-i)/a*u}}function $t(t){return 0!==t&&!(t&t-1)}function Dt(t){return 0===t?1:(t--,t|=t>>1,t|=t>>2,t|=t>>4,t|=t>>8,(t|=t>>16)+1)}async function Ot(t){if("object"!=typeof t)return t;const e=[];return await Lt(t,e),await Promise.all(e),t}function Lt(t,e){if("object"!=typeof t)return t;for(const r in t)"function"==typeof t[r].then?e.push(t[r].then(e=>t[r]=e)):"object"==typeof t[r]&&Lt(t[r],e);return t}function Yt(t){return"object"!=typeof t?t:t=Ut(t)}function Ut(t){if("object"!=typeof t)return t;if(ArrayBuffer.isView(t))return Array.from(t);for(const e in t)ArrayBuffer.isView(t[e])?t[e]=Array.from(t[e]):"object"==typeof t[e]&&Ut(t[e]);return t}function Xt(t,e,r){return JSON.stringify(t,(t,r)=>(ArrayBuffer.isView(r)&&(r=Array.from(r)),e?e(t,r):r),r)}function Gt(t,e){let o=!1,n=0;if(r(e)){if(t.length!==e.length)throw new Error("size of array1 and array2 must be identical")}else o=!0,n=e;const s=new Float64Array(t.length);if(o)for(let e=0;e<t.length;e++)s[e]=t[e]-n;else for(let r=0;r<t.length;r++)s[r]=t[r]-e[r];return s}function Bt(t,e,r,o){const{controlPoints:i,factorStd:l=3,learningRate:h=.5,minWeight:a=.01}=o,u=n(Gt(t,e)),f=l*(1.4826*s(u)),c=new Float64Array(u.length);for(let t=0;t<u.length;t++)c[t]=Math.exp(-((u[t]/f)**2));let g=Number.MIN_SAFE_INTEGER;const m=Float64Array.from(r),w=1-h;for(let t=0;t<m.length;t++){if(i&&i[t]>0)continue;const e=Math.max(a,w*r[t]+h*c[t]);m[t]=e,g=Math.max(g,e)}return m[0]=g,m[r.length-1]=g,m}function Wt(t,e={}){const{propertiesToRemove:r=[],...o}=e;if(r.length>0)for(const e of r)Qt(t,e,o);else Qt(t,"",o);return t}function Qt(t,e,r={}){const o=new WeakMap;!function t(n,s,i){if(Zt(n)){if(o.has(n))return;o.set(n,null);for(const r of Reflect.ownKeys(n))e&&r===e||!e&&Kt(n[r])?Reflect.deleteProperty(n,r):t(n[r],n,r);!e&&Kt(n)&&s&&Reflect.deleteProperty(s,i)}else if(Ht(n)){if(o.has(n))return;o.set(n,null);for(let e=0;e<n.length;e++)t(n[e],n,e);for(let t=n.length-1;t>=0;t--)!Kt(n[t])||Ht(n[t])&&0===n[t].length&&!1===r?.removeEmptyArrayAndObject||n.splice(t,1);for(const r of Reflect.ownKeys(n)){"string"==typeof r&&/^\d+$/.test(r)||(e&&r===e||!e&&Kt(n[r])?Reflect.deleteProperty(n,r):t(n[r],n,r))}!e&&0===n.length&&s&&r?.removeEmptyArrayAndObject&&Reflect.deleteProperty(s,i)}}(t)}function Jt(t){return Object.prototype.toString.call(t)}function Ht(t){return Array.isArray?Array.isArray(t):"[object Array]"===Jt(t)}function Zt(t){return"[object Object]"===Jt(t)}function Kt(t){return function(t){return void 0===t}(t)||function(t){return"[object Null]"===Jt(t)}(t)||function(t){return"[object String]"===Jt(t)}(t)&&0===t.length||Ht(t)&&0===t.length||Zt(t)&&0===Object.keys(t).length}function te(t,e={}){u(t);const{forceFFT:r=!1}=e,o=t.length;return $t(o)?ee(t):r?re(ee(re(t,Dt(o))),o):function(t,e={}){const{inClockwise:r=!0}=e,o=[0,...t,0],n=new Float64Array(t.length);for(let t=1;t<o.length-1;t++){let e=0;for(let r=0;r<t-1;r++){const n=Math.log((t-r)/(t-r-1));e+=o[r]*n+(o[r+1]-o[r])*((t-r)*n-1)}const s=o[t-1]-o[t+1];let i=0;for(let e=t+1;e<o.length-1;e++){const r=Math.log((e-t)/(e-t+1));i+=o[e]*r+(o[e-1]-o[e])*(1+(e-t)*r)}n[t-1]=(r?1:-1)*(e+s+i)/Math.PI}return n}(t)}function ee(t){const e=t.length,r=new Nt(e),o=new Float64Array(2*e);r.realTransform(o,t),r.completeSpectrum(o);const n=new Float64Array(e);for(let t=1;t<e;t++)n[t]=Math.sign(e/2-t);for(let t=0;t<e;t++)o[2*t]*=n[t],o[2*t+1]*=n[t];const s=new Float64Array(2*e);r.inverseTransform(s,o);const i=new Float64Array(e);for(let t=0;t<e;t++)i[t]=s[2*t+1];return i}function re(t,e){u(t);const r=t.length,o=(r-1)/(e-1),n=new Float64Array(e);let s=0,i=Math.floor(s),l=Math.min(Math.ceil(s),r-1),h=s-i;for(let a=0;a<e;a++)n[a]=t[i]*(1-h)+t[l]*h,s+=o,i=Math.floor(s),l=Math.min(Math.ceil(s),r-1),h=s-i;return n}function oe(t,e={}){u(t);const{fromIndex:r,toIndex:o}=c(t,e);let n=t[r];for(let e=r+1;e<=o;e++)t[e]>n&&(n=t[e]);return n}function ne(t,e={}){u(t);const{fromIndex:r,toIndex:o}=c(t,e);let n=t[r];for(let e=r+1;e<=o;e++)t[e]<n&&(n=t[e]);return n}function se(t,e={}){u(t);const r=e.histogram,{centerX:o=!0,nbSlots:s=(void 0===r?256:r.x.length),logBaseX:i,logBaseY:l,absolute:h=!1}=e;if(h&&(t=n(t)),i){t=t.slice();const e=Math.log10(i);for(let r=0;r<t.length;r++)t[r]=Math.log10(t[r])/e}const{min:a=ne(t),max:f=oe(t)}=e,c=(f-a)/(s+Number.EPSILON),g=void 0===r?new Float64Array(s):r.y,m=void 0===r?Array.from(_t({from:a+(o?c/2:0),to:f-(o?c/2:0),length:s})):r.x;for(const e of t){g[Math.max(Math.min(Math.floor((e-a-Number.EPSILON)/c),s-1),0)]++}if(l){const t=Math.log10(l);for(let e=0;e<g.length;e++)g[e]=Math.log10(g[e]+1)/t}return{x:m,y:g}}function ie(t,e={}){if(t.length<3)return!0;const{tolerance:r=.05}=e;let o=0,n=Number.MAX_SAFE_INTEGER;for(let e=0;e<t.length-1;++e){const r=t[e+1]-t[e];r<n&&(n=r),r>o&&(o=r)}return(o-n)/o<r}function le(t){if(t.length<=2)return 1;if(t[0]===t[1]){for(let e=1;e<t.length-1;e++)if(t[e]!==t[e+1])return 0;return 1}if(t[0]<t.at(-1)){for(let e=0;e<t.length-1;e++)if(t[e]>=t[e+1])return 0;return 1}for(let e=0;e<t.length-1;e++)if(t[e]<=t[e+1])return 0;return-1}function he(t,e,r={}){const{recenter:o=!0,similarityFct:n=(t,e)=>t===e?1:0}=r,s=ue(t),i=ue(e),l=Math.min(s,i);o&&(t=t.slice());let h=0;for(let r=0;r<l;r++){const s=1/l/(1<<r);for(let i=0;i<1<<r;i++){const a=(1<<r)-1+i,u=t[a],f=e[a];h+=n(u,f)*s,o&&ae(t,l,r,i,f-u)}}return h}function ae(t,e,r,o,n){for(let s=r;s<e;s++){const e=o*(1<<s-r),i=(1<<s)-1,l=1<<s-r;for(let r=e;r<e+l;r++){t[i+r]+=n}}}function ue(t){const e=Math.log2(t.length+1);if(e%1!=0)throw new Error("the array length is not a power of 2 minus 1");return e}function fe(t,e={}){u(t);const{fromIndex:r,toIndex:o}=c(t,e);let n=t[r];for(let e=r+1;e<=o;e++)t[e]>=0?t[e]>n&&(n=t[e]):-t[e]>n&&(n=-t[e]);return n}function ce(t,e={}){u(t);const{fromIndex:r,toIndex:o}=c(t,e);let n=r;for(let e=r+1;e<=o;e++)t[e]>t[n]&&(n=e);return n}function ge(t,e){v(t,e);let r=0;for(let o=0;o<t.length;o++)r+=Math.abs(t[o]-e[o]);return r/t.length}function me(t,e){v(t,e);let r=0;for(let o=0;o<t.length;o++)r+=(t[o]-e[o])**2;return r/t.length}function we(t,e,r={}){if(u(t,{minLength:1}),u(e),t.length!==e.length)throw new Error("array and weights must have the same length");const{fromIndex:o,toIndex:n}=c(t,r);let s=0,i=t[o]*e[o];s+=e[o];for(let r=o+1;r<=n;r++)i+=t[r]*e[r],s+=e[r];if(0===s)throw new Error("sum of weights must be > 0");return i/s}function ye(t){const e=s(t),r=new Float64Array(t.length);for(let o=0;o<t.length;o++)r[o]=Math.abs(t[o]-e);return{median:e,mad:s(r)}}function pe(t,e={}){u(t);const{fromIndex:r,toIndex:o}=c(t,e);let n=r;for(let e=r+1;e<=o;e++)t[e]<t[n]&&(n=e);return n}function de(t){u(t,{minLength:2});let e=t[1]-t[0],r=e;for(let o=0;o<t.length-1;o++){const n=t[o+1]-t[o];n<e&&(e=n),n>r&&(r=n)}return{min:e,max:r}}function xe(t){u(t);let e=t[0],r=t[0];for(const o of t)o<e&&(e=o),o>r&&(r=o);return{min:e,max:r}}function be(t){if(0===t.length)throw new TypeError("input must not be empty");let e=0,r=0,o=0;const n={};for(const s of t)o=n[s],o?(n[s]++,o++):(n[s]=1,o=1),o>r&&(r=o,e=s);return e}const Me=[-.005387729650712429,.008226878746769157,.02198786811111689,-.03656379714117627,-.012692614766297404,.03348066254097446,-.008368748197417368,-.0005087819496582806],ve=[.0008862163904564247,-.0023339375937419,.07952836873415717,-.05273963823400997,-.7122890234154284,.662328840472003,1.5622155839842302,-1.5657455823417585,-.9700050433032906,1],Ae=[-3.6719225470772936,21.12946554483405,17.445385985570866,-44.6382324441787,-18.851064805871424,17.644729840837403,8.3705032834312,.10526468069939171,-.20243350835593876],Ee=[1.7211476576120028,-22.643693341313973,10.826866735546016,48.560921310873994,-20.14326346804852,-28.66081804998,3.971343795334387,6.242641248542475,1],Ie=[-6.81149956853777e-10,2.8522533178221704e-8,-6.794655751811263e-7,.0021455899538880526,.029015791000532906,.14286953440815717,.3377855389120359,.38707973897260434,.11703015634199525,-.16379404719331705,-.1311027816799519],Se=[.011059242293464892,.15226433829533179,.848854343457902,2.5930192162362027,4.778465929458438,5.381683457070069,3.4662540724256723,1],Re=[26633922742578204e-28,-2.304047769118826e-10,460469890584318e-20,.00015754461742496055,.0018712349281955923,.009508047013259196,.018557330651423107,-.0022242652921344794,-.0350353787183178],Ne=[7646752923027944e-20,.00263861676657016,.03415891436709477,.22009110576413124,.7620591645536234,1.3653349817554064,1],Fe=[9905570997331033e-32,-2811287356288318e-29,4.625961635228786e-9,4.4969678992770644e-7,14962478375834237e-21,.00020938631748758808,.001056288621524929,-.0011295143874558028,-.016743100507663373],Te=[2.82243172016108e-7,27533547476472603e-21,.0009640118070051656,.016074608709367652,.1381518657490833,.5914293448864175,1];function _e(t,e){let r=0;for(const o of t)r=r*e+o;return r}function ke(t,e,r,o,n){const s=t-e;return n*t+_e(r,s)/_e(o,s)*t}function Ce(t){let e,r,o,n,s=!1;if(Number.isNaN(t))return Number.NaN;if(t<0||t>2)throw new RangeError(`erfcinv()::invalid input argument. Value must be on the interval [0,2]. Value: \`${t}\`.`);return 0===t?Number.POSITIVE_INFINITY:2===t?Number.NEGATIVE_INFINITY:1===t?0:(t>1?(r=2-t,t=1-r,s=!0):(r=t,t=1-t),t<=.5?(o=t*(t+10),n=_e(Me,t)/_e(ve,t),e=.08913147449493408*o+o*n,s?-e:e):r>=.25?(o=Math.sqrt(-2*Math.log(r)),r-=.25,n=_e(Ae,r)/_e(Ee,r),e=o/(2.249481201171875+n),s?-e:e):(r=Math.sqrt(-Math.log(r)),r<3?ke(r,1.125,Ie,Se,.807220458984375):r<6?ke(r,3,Re,Ne,.9399557113647461):ke(r,6,Fe,Te,.9836282730102539)))}function Ve(t,e={}){return function(t,e={}){const{magnitudeMode:r=!1}=e,o=new Float64Array(t.length);if(r)for(let e=0;e<o.length;e++)o[e]=-Math.sqrt(-2*Math.log(1-t[e]));else for(let e=0;e<o.length;e++)o[e]=-1*Math.SQRT2*Ce(2*t[e]);return o}([t],e)[0]}function qe(t,e={}){const{mask:o,cutOff:n,refine:s=!0,magnitudeMode:i=!1,scaleFactor:l=1,factorStd:h=5,fixOffset:a=!0}=e,u=function(t,e){const{scaleFactor:o,mask:n}=e,s=Et(r(n)&&n.length===t.length?t.filter((t,e)=>!n[e]):t);if(o>1)for(let t=0;t<s.length;t++)s[t]*=o;return s.sort().reverse(),s}(t,{scaleFactor:l,mask:o});if(a&&!i){const t=Math.floor(u.length/2),e=u.length%2==0?.5*(u[t-1]+u[t]):u[t];for(let t=0;t<u.length;t++)u[t]-=e}const f=u.at(-1)>=0?u.length:u.findIndex(t=>t<0);let c=f-1;for(let t=c;t>=0;t--)if(u[t]>0){c=t;break}const g=u.slice(0,c+1),m=u.slice(f),w=n||function(t,e={}){const{magnitudeMode:r=!1,considerList:o={from:.5,step:.1,to:.9}}=e,n=[],s=t.length-1;for(let e=.01;e<=.99;e+=.01){const o=-t[Math.round(s*e)]/Ve(e/2,{magnitudeMode:r});n.push([e,o])}let i=Number.MAX_SAFE_INTEGER;const{from:l,to:h,step:a}=o,u=a/2;let f=.5;for(let t=l;t<=h;t+=a){const e=t-u,r=t+u,o=n.filter(t=>t[0]<r&&t[0]>e);let s=0;for(const t of o)s+=Math.abs(t[1]);let l=0;for(const t of o)l+=(t[1]-s)**2;l<i&&(i=l,f=t)}return f}(g,{magnitudeMode:i}),y=g[Math.floor(g.length*w)],p=g[0];let d;if(m.length>0){d=-1*m[Math.floor(m.length*(1-w))]}else d=0;let x=y,b=d,M=g.slice(),v=m.slice(),A=0,E=2;if(s){let t=x*h;A=g.findIndex(e=>e<t),A>-1&&(M=g.slice(A),x=M[Math.floor(M.length*w)]),t=b*h,E=m.findIndex(e=>e<t),E>-1&&(v=m.slice(E),b=M[Math.floor(v.length*(1-w))])}const I=-Ve(w/2,{magnitudeMode:i});let S,R;return s&&A>-1?(S=(w*M.length+A)/(M.length+A),R=-1*Ve(S/2,{magnitudeMode:i}),x/=R,E>-1&&(S=(w*v.length+E)/(v.length+E),R=-1*Ve(S/2,{magnitudeMode:i}),0!==b&&(b/=R))):(x/=I,b/=I),{positive:x,negative:b,snr:p/x,sanplot:ze(u,{fromTo:{positive:{from:0,to:c},negative:{from:f,to:u.length}}})}}function ze(t,e={}){const{fromTo:r,logBaseY:o=2}=e,n={};for(const e in r){const{from:s,to:i}=r[e];n[e]=s!==i?Pe(t.slice(s,i),{logBaseY:o}):{x:[],y:[]},"negative"===e&&n[e].y.reverse()}return n}function Pe(t,e={}){const{log10:r,abs:o}=Math,{logBaseY:n}=e;if(n){t=t.slice(0);const e=r(n);for(let n=0;n<t.length;n++)t[n]=r(o(t[n]))/e}return{x:_t({from:0,to:t.length-1,length:t.length}),y:t}}function je(t){const{mad:e,median:r}=ye(t);return{sd:e/.6744897501960817,mad:e,median:r}}function $e(t){let e=0;for(const r of t)e+=r**2;return Math.sqrt(e)}function De(t,e={}){u(t);const{fromIndex:r,toIndex:o}=c(t,e);let n=t[r];for(let e=r+1;e<=o;e++)n+=t[e];return n}function Oe(t,e={}){const{algorithm:r="absolute",value:n=1}=e;u(t);const s=o(e.output,t.length);if(0===t.length)throw new Error("input must not be empty");switch(r){case"absolute":{const e=function(t){let e=0;for(const r of t)e+=Math.abs(r);return e}(t)/n;if(0===e)throw new Error("trying to divide by 0");for(let r=0;r<t.length;r++)s[r]=t[r]/e;return s}case"max":{const e=oe(t);if(0===e)throw new Error("trying to divide by 0");const r=n/e;for(let e=0;e<t.length;e++)s[e]=t[e]*r;return s}case"sum":{const e=De(t)/n;if(0===e)throw new Error("trying to divide by 0");for(let r=0;r<t.length;r++)s[r]=t[r]/e;return s}default:throw new Error(`unknown algorithm: ${String(r)}`)}}function Le(t,e={}){const{size:r=0,value:o=0,algorithm:n}=e;if(u(t),!n)return Et(t);const s=new Float64Array(t.length+2*r);for(let e=0;e<t.length;e++)s[e+r]=t[e];const i=r+t.length,l=2*r+t.length;switch(n){case"value":for(let t=0;t<r;t++)s[t]=o;for(let t=i;t<l;t++)s[t]=o;break;case"duplicate":for(let e=0;e<r;e++)s[e]=t[0];for(let e=i;e<l;e++)s[e]=t.at(-1);break;case"circular":for(let e=0;e<r;e++)s[e]=t[(t.length-r%t.length+e)%t.length];for(let e=0;e<r;e++)s[e+i]=t[e%t.length];break;default:throw new Error(`unknown algorithm ${String(n)}`)}return s}function Ye(t){u(t);const e=new Float64Array(t.length),r=Math.sqrt(Mt(t));for(let o=0;o<t.length;o++)e[o]=t[o]/r;return e}function Ue(t){const e=M(t);let r;if(0===e.outliers.length)r=t;else{r=new Float64Array(t.length-e.outliers.length);let o=0;for(const n of t)n>=e.min&&n<=e.max&&(r[o++]=n)}return{...e,mean:xt(r),sd:Mt(r),nb:r.length}}function Xe(t){if(!r(t))throw new TypeError("input must be an array");if(0===t.length)return t;const e=b(t),o=e.q3-e.q1,n=e.q1-1.5*o,s=e.q3+1.5*o;if(e.min>=n&&e.max<=s)return t;const i=[];for(const e of t)e>=n&&e<=s&&i.push(e);return i}function Ge(t,e={}){u(t);const r=o(e.output,t.length),n=ne(t),s=oe(t);if(n===s)throw new RangeError("minimum and maximum input values are equal. Cannot rescale a constant array");const{min:i=0,max:l=1}=e;if(i>=l)throw new RangeError("min option must be smaller than max option");const h=(l-i)/(s-n);for(let e=0;e<t.length;e++)r[e]=(t[e]-n)*h+i;return r}function Be(t,e,r={}){if(u(t),"function"!=typeof e)throw new TypeError("fct must be a function");const{window:o=5,padding:n={}}=r,{size:s=o-1,algorithm:i,value:l}=n,h=Le(t,{size:s,algorithm:i,value:l}),a=[];for(let t=0;t<h.length-o+1;t++)a.push(e(h.subarray(t,t+o)));return a}function We(t,e={}){return Be(t,xt,e)}function Qe(t,e={}){return Be(t,oe,e)}function Je(t,e={}){return Be(t,s,e)}function He(t,e={}){return Be(t,ne,e)}function Ze(t,e){(e%=t.length)<0&&(e+=t.length);const r=new Float64Array(t.length);return r.set(t.slice(t.length-e)),r.set(t.slice(0,t.length-e),e),r}function Ke(t,e={}){const{length:r=10}=e;if(u(t),r===t.length)return Float64Array.from(t);if(r>t.length)throw new RangeError("length must be smaller than the array length");return function(t,e){const r=new Float64Array(e),o=(t.length-1)/(e-1);for(let n=0;n<e;n++)r[n]=t[Math.round(n*o)];return r}(t,r)}function tr(t,e={}){const{from:r,step:o,size:n}=t,{ArrayConstructor:s=Float64Array}=e,i=Ft(s,n);for(let t=0;t<n;t++)i[t]=r+t*o;return i}function er(t,e={}){const{from:r,to:o,size:n}=t;return tr({from:r,step:(o-r)/(n-1),size:n},e)}function rr(t){if(ArrayBuffer.isView(t))return t.sort();if(Array.isArray(t))return t.sort((t,e)=>t-e);throw new Error("trying to sort non array")}function or(t){if(ArrayBuffer.isView(t))return t.sort().reverse(),t;if(Array.isArray(t))return t.sort((t,e)=>e-t),t;throw new Error("trying to sort non array")}function nr(t){return Float64Array.from(new Set(t)).sort()}function sr(t){const e=t[0].length,r=new Float64Array(t.length*e);for(let o=0;o<t.length;o++){const n=o*e;for(let s=0;s<e;s++){const e=t[o][s];r[n+s]=Math.abs(e)}}return s(r)}function ir(t){const{matrix:e,nbRows:r=e?.length||1,nbColumns:o=e?.[0].length||1,ArrayConstructor:n=Float64Array}=t,s=[];for(let t=0;t<r;t++)s.push(Ft(n,o));return s}function lr(t,e){const r=ir({nbRows:t.length,nbColumns:t[0].length,ArrayConstructor:Array}),o=[];for(const t in e)o.push(e[t]);let n=oe(o);for(const t of r)for(let o=0;o<r[0].length;o++)"string"==typeof t[o]&&(t[o]in e?t[o]=e[t[o]]:(n++,e[t[o]]=n,t[o]=n));return r}function hr(t,e=0){const r=t.length,o=t[0].length;if(r<2)throw new Error("can not calculate info if matrix contains less than 2 rows");const n=new Float64Array(r),s=new Float64Array(r),i=new Float64Array(o);for(let o=0;o<r;o++)n[o]=t[o][e];for(let e=0;e<o;e++){for(let o=0;o<r;o++)s[o]=t[o][e];i[e]=A(n,s)}return i}function ar(t){const e=t.length,r=t[0].length;if(e<5)throw new Error("can not calculate info if matrix contains less than 5 rows");const o={q1:new Float64Array(r),median:new Float64Array(r),q3:new Float64Array(r),min:Float64Array.from(t[0]),max:Float64Array.from(t.at(-1))},n=new Float64Array(t.length);for(let s=0;s<r;s++){for(let r=0;r<e;r++)n[r]=t[r][s];let r=0,i=0;if(e%2==1){const t=(e-1)/2;o.median[s]=n[t],r=t-1,i=t+1}else i=e/2,r=i-1,o.median[s]=(n[r]+n[i])/2;if(r%2==0)o.q1[s]=n[r/2],o.q3[s]=n[(e+i-1)/2];else{o.q1[s]=(n[(r+1)/2]+n[(r-1)/2])/2;const t=(n.length+i)/2;o.q3[s]=(n[t]+n[t-1])/2}}return o}function ur(t){const e=t[0].length,r=t.length,o=ir({nbColumns:e,nbRows:r});for(let n=0;n<e;n++){let e=0;for(let o=0;o<r;o++)e+=t[o][n];e/=r;for(let s=0;s<r;s++)o[s][n]=t[s][n]-e}return o}function fr(t){if(0===t.length||0===t[0].length)throw new RangeError("matrix must contain data");const e=t[0].length;for(let r=1;r<t.length;r++)if(t[r].length!==e)throw new RangeError("all rows must has the same length")}function cr(t,e,r){if(r){const o=new Array(e);for(let t=0;t<e;t++)o[r[t]]=t;const n=new Array(t.length);for(let e=0;e<t.length;++e){const[r,s,i]=t[e],[l,h]=[o[r],o[s]];n[e]=h<l?[h,l,i]:[l,h,i]}t=n}else{r=[];for(let t=0;t<e;++t)r[t]=t}const o=new Array(e+1),n=new Array(t.length),s=new Array(t.length),i=[];for(let t=0;t<e;++t)i[t]=0;for(const e of t)i[e[1]]++;o[0]=0;for(let t=0;t<e;++t)o[t+1]=o[t]+i[t];const l=[];for(let t=0;t<e;++t)l[t]=0;for(const e of t){const t=e[1],r=o[t]+l[t];n[r]=e[0],s[r]=e[2],l[t]++}const h=new Array(e),a=new Array(e),u=new Array(e+1),f=new Array(e),c=new Array(e),g=new Array(e),m=new Array(e),w=new Array(e),y=new Array(e);!function(t,e,r,o,n,s,i){for(let o=0;o<t;o++){n[o]=-1,i[o]=o,s[o]=0;const t=o,l=e[t+1];for(let h=e[t];h<l;h++){let t=r[h];if(t<o)for(;i[t]!==o;t=n[t])-1===n[t]&&(n[t]=o),s[t]++,i[t]=o}}o[0]=0;for(let e=0;e<t;e++)o[e+1]=o[e]+s[e]}(e,o,n,u,f,c,g);const p=new Array(u[e]),d=new Array(u[e]),x=function(t,e,r,o,n,s,i,l,h,a,u,f,c){let g,m,w,y,p,d,x,b,M;for(y=0;y<t;y++){for(u[y]=0,M=t,c[y]=y,i[y]=0,d=y,x=e[d+1],p=e[d];p<x;p++)if(w=r[p],w<=y){for(u[w]+=o[p],b=0;c[w]!==y;w=s[w])f[b++]=w,c[w]=y;for(;b>0;)f[--M]=f[--b]}for(a[y]=u[y],u[y]=0;M<t;M++){for(w=f[M],g=u[w],u[w]=0,x=n[w]+i[w],p=n[w];p<x;p++)u[l[p]]-=h[p]*g;m=g/a[w],a[y]-=m*g,l[p]=y,h[p]=m,i[w]++}if(0===a[y])return y}return t}(e,o,n,s,u,f,c,d,p,h,a,m,g);return x===e?t=>(function(t,e,r,o){let n;for(n=0;n<t;n++)e[n]=r[o[n]]}(e,w,t,r),function(t,e,r,o,n){let s,i,l;for(s=0;s<t;s++)for(l=r[s+1],i=r[s];i<l;i++)e[o[i]]-=n[i]*e[s]}(e,w,u,d,p),function(t,e,r){for(let o=0;o<t;o++)e[o]/=r[o]}(e,w,h),function(t,e,r,o,n){let s,i,l;for(s=t-1;s>=0;s--)for(l=r[s+1],i=r[s];i<l;i++)e[s]-=n[i]*e[o[i]]}(e,w,u,d,p),function(t,e,r,o){let n;for(n=0;n<t;n++)e[o[n]]=r[n]}(e,y,w,r),y):null}function gr(t){return t.map(t=>t.slice(0))}function mr(t){const e=new wt(t).transpose(),r=[];for(let t=0;t<e.rows;t++)r.push(new Float64Array(e.rows));for(let t=0;t<e.rows;t++)for(let o=t;o<e.rows;o++){const n=A(e.getRow(t),e.getRow(o));r[t][o]=n,r[o][t]=n}return r}function wr(t,e){const r=new Array(e),o=new Array(e).fill(!1);for(let t=0;t<e;++t)r[t]=[];for(const e of t)r[e[0]].push(e[1]);const n=new Float64Array(e);let s=0,i=0;for(let t=0;t<e;++t)if(!o[t])for(n[s++]=t,o[t]=!0;i<s;){const t=n[i++],e=Float64Array.from(r[t]).sort();for(const t of e)o[t]||(o[t]=!0,n[s++]=t)}const l=new Float64Array(e);for(let t=0;t<e;++t)l[n[t]]=t;return l}function yr(t,e){const{startRow:r,endRow:o,startColumn:n,endColumn:s}=e;if(r>o||n>s||r<0||r>=t.length||o<0||o>=t.length||n<0||n>=t[0].length||s<0||s>=t[0].length)throw new RangeError("submatrix indices are out of range")}function pr(t,e){const{startRow:r=0,endRow:o=t.length-1,startColumn:n=0,endColumn:s=t[0].length-1,duplicate:i=!0}=e;yr(t,{startColumn:n,startRow:r,endColumn:s,endRow:o});const l=o-r+1,h=[];if(i)for(let e=0;e<l;e++)h.push(t[r+e].slice(n,s+1));else for(let e=0;e<l;e++)h.push(t[r+e].subarray(n,s+1));return h}function dr(t){if(0===t.length||0===t[0].length)throw new Error("matrixMinMaxAbsoluteZ requires at least 1 row and 1 column");const e=t.length,r=t[0].length;let o=Number.POSITIVE_INFINITY,n=Number.NEGATIVE_INFINITY;for(let s=0;s<r;s++)for(let r=0;r<e;r++){let e=t[r][s];e<0&&(e*=-1),e<o&&(o=e),e>n&&(n=e)}return{min:o,max:n}}function xr(t){fr(t);const e=t.length,r=t[0].length;let o=t[0][0],n=t[0][0];for(let s=0;s<r;s++)for(let r=0;r<e;r++)t[r][s]<o&&(o=t[r][s]),t[r][s]>n&&(n=t[r][s]);return{min:o,max:n}}function br(t,e={}){let{min:r,max:o}=e;const{absolute:n,logBaseX:s,logBaseY:i,histogram:l,nbSlots:h,centerX:a}=e;if(0===t.length||0===t[0].length)throw new Error("matrix must have at least one column and one row");if(void 0===r||void 0===o){const e=n?dr(t):xr(t);void 0===r&&(r=s&&e.min?Math.log(e.min)/Math.log(s):e.min),void 0===o&&(o=s&&e.max?Math.log(e.max)/Math.log(s):e.max)}const u={histogram:l,nbSlots:h,centerX:a,absolute:n,logBaseX:s,min:r,max:o},f=se(t[0],u);u.histogram=f;const c=t.length;for(let e=1;e<c;e++)se(t[e],u);const g=f.y;if(i){const t=Math.log10(i);for(let e=0;e<g.length;e++)g[e]=Math.log10(g[e]+1)/t}return f}function Mr(t){if(0===t.length||0===t[0].length)throw new Error("matrix must have at least 1 row and 1 column");const e=t.length,r=t[0].length;let o=Number.NEGATIVE_INFINITY;for(let n=0;n<r;n++)for(let r=0;r<e;r++){const e=Math.abs(t[r][n]);e>o&&(o=e)}return o}function vr(t){fr(t);const e=t[0].length,r=new Float64Array(t.length*e);for(let o=0;o<t.length;o++){const n=o*e;for(let s=0;s<e;s++)r[n+s]=t[o][s]}return r}function Ar(t){return s(vr(t))}function Er(t){return je(vr(t))}function Ir(t,e){const r=gr(t),o=function(t){const e={};for(const r in t)e[t[r]]=r;return e}(e);for(const t of r)for(let e=0;e<r[0].length;e++){const r=t[e];"number"==typeof r&&r in o&&(t[e]=o[r])}return r}function Sr(t){const e=gr(t),r=e.length,o=e[0].length;let n=0;for(let t=0;t<r;t++)for(let r=0;r<o;r++){const o=e[t][r];"number"==typeof o&&o>n&&(n=o)}const s={};for(let t=0;t<r;t++)for(let r=0;r<o;r++){const o=e[t][r];"string"==typeof o&&(o in s?e[t][r]=s[o]:(n++,s[o]=n,e[t][r]=n))}return{matrix:e,dictCategoricalToNumerical:s}}function Rr(t,e={}){const{max:r=100}=e,o=new wt(t);for(let t=0;t<o.rows;t++){const e=o.getRowVector(t).norm("frobenius")/r,n=o.getRowVector(t).div(e);o.setRow(t,n)}const n=[];for(let t=0;t<o.columns;t++){const e=o.getColumn(t);n.push(s(e))}const i=[];for(let t=0;t<o.columns;t++){const e=o.getColumnVector(t).div(n[t]);i.push(s(e.getColumn(0)))}for(let t=0;t<o.rows;t++)o.mulRow(t,1/i[t]);return{data:o.to2DArray(),medianOfQuotients:i}}function Nr(t,e,r,o){yr(t,{startRow:r,endRow:r+e.length-1,startColumn:o,endColumn:o+e[0].length-1});for(let n=0;n<e.length;n++)for(let s=0;s<e[0].length;s++)t[r+n][o+s]=e[n][s];return t}function Fr(t,e={}){const{max:r=1,ArrayConstructor:o}=e,n=t[0].length,s=t.length,i=ir({nbColumns:n,nbRows:s,ArrayConstructor:o}),l=Mr(t);for(let e=0;e<n;e++){const o=r/l;for(let r=0;r<s;r++)i[r][e]=t[r][e]*o}return i}function Tr(t,e={}){const{min:r=0,max:o=1,ArrayConstructor:n}=e,s=t[0].length,i=t.length,l=ir({nbColumns:s,nbRows:i,ArrayConstructor:n}),{min:h,max:a}=xr(t),u=(o-r)/(a-h);for(let e=0;e<s;e++)for(let o=0;o<i;o++)l[o][e]=(t[o][e]-h)*u+r;return l}function _r(t,e={}){const{min:r=0,max:o=1}=e,n=t[0].length,s=t.length,i=ir({nbColumns:n,nbRows:s});for(let e=0;e<n;e++){let n=t[0][e],l=t[0][e];for(let r=1;r<s;r++)t[r][e]<n&&(n=t[r][e]),t[r][e]>l&&(l=t[r][e]);const h=(o-r)/(l-n);for(let o=0;o<s;o++)i[o][e]=(t[o][e]-n)*h+r}return i}function kr(t,e={}){fr(t);const{ArrayConstructor:r}=e,o=t.length,n=t[0].length,s=ir({nbColumns:o,nbRows:n,ArrayConstructor:r});for(let e=0;e<o;e++)for(let r=0;r<n;r++)s[r][e]=t[e][r];return s}function Cr(t,e,r){const o=e.length,n=o-1,s=new Array(t.length),i=new Float64Array(o);for(let o=0;o<n;o++){const n=r[o],l=2*o,h=l+1;s[l]=t[l].slice(),s[h]=t[h].slice(),i[o]=e[o]*n,s[l][2]+=n}return i[n]=e[n]*r[n],s[2*n]=t[2*n].slice(),s[2*n][2]+=r[n],{leftHandSide:s,rightHandSide:i}}function Vr(t,e={}){const{lambda:r=100,maxIterations:o=100,tolerance:n=1e-6,factorStd:s=3,learningRate:i=.5,minWeight:l=.01}=e,h=t.length;let{controlPoints:a,weights:u}=function(t,e={}){const{length:r}=t,{controlPoints:o}=e,{weights:n=Float64Array.from({length:r}).fill(1)}=e;if(o&&o.length!==t.length)throw new RangeError("controlPoints should match the length with X");if(n.length!==t.length)throw new RangeError("weights should match the length with X");return{weights:o?y(n,o):n,controlPoints:o}}(t,e);const f=new Float64Array(h);let c=0,g=1/0,m=Et(t);const w=function(t,e){const r=[],o=t-1;for(let t=0;t<o;t++)r.push([t,t,2*e],[t,t+1,-1*e]);return r[0][2]=e,r.push([o,o,e]),r}(h,r);for(;c<o&&g>n;){const{leftHandSide:e,rightHandSide:r}=Cr(w,t,u),o=cr(e,h);if(!o)return m;const n=o(r);u=Bt(t,n,u,{controlPoints:a,minWeight:l,learningRate:i,factorStd:s}),g=qr(n,f,h),f.set(n),m=Et(n),c++}return m}function qr(t,e,r){let o=0;for(let n=0;n<r;n++)o+=(t[n]-e[n])**2;return Math.sqrt(o/r)}const zr=Vr;function Pr(t,e=0,r=0,o={}){const{reverse:n=!1}=o;e=Number.isFinite(e)?e:0,r=Number.isFinite(r)?r:0;const s=t.re,i=t.im,l=t.re.length;let h=e,a=r/l;n&&(a*=-1,h+=r);const u=2*Math.sin(a/2)**2,f=Math.sin(a);let c=Math.cos(h),g=Math.sin(h);const m=new Float64Array(l),w=new Float64Array(l);for(let t=0;t<l;t++){m[t]=s[t]*c-i[t]*g,w[t]=i[t]*c+s[t]*g;const e=g-(u*g-f*c);c=c-(u*c+f*g),g=e}return{re:m,im:w}}function jr(e,r={}){const{magnitudeMode:o=!0,minRegSize:n=30,factorNoise:s=3,maxDistanceToJoin:i=256,reverse:l=!1}=r,h=function(e,r){const o=r.magnitudeMode?t(e):e.re,n=Or(function(t){const e=new Float64Array(t.length);for(let r=5;r<t.length-5;r++)e[r]=(42*(t[r+1]-t[r-1])+48*(t[r+2]-t[r-2])+27*(t[r+3]+t[r-3])+8*(t[r+4]-t[r-4])+t[r+5]-t[r-5])/512;for(let r=0;r<5;r++)e[r]=e[5],e[t.length-r-1]=e[t.length-6];return e}(o),r),s=Or(o,r);return s.map((t,e)=>t&&n[e])}(e,{maxDistanceToJoin:i,magnitudeMode:o,factorNoise:s}),{re:a,im:u}=e,f=a.length,c=l?t=>f-1-t:t=>t;let g=0,m=-1;const w=[];for(;m<f;){const t=[],e=[];for(;!h[c(++m)]&&m<f;)g=m;for(;h[c(m)]&&m<f;m+=2)t.push(a[c(m)]),e.push(u[c(m)]);t.length>n&&w.push(Dr(t,e,g))}const{ph1:y,ph0:p}=$r(w.map(t=>t.x0/f),w.map(t=>t.ph0),w.map(t=>t.area/1e11));return{data:Pr({re:a,im:u},Lr(p),Lr(y),{reverse:l}),ph0:p,ph1:y}}function $r(t,e,r){if(0===t.length)return{ph0:0,ph1:0};if(1===t.length)return{ph0:e[0],ph1:0};const[o,n]=function(t,e,r){let o=0,n=0,s=0,i=0,l=0;for(let h=0;h<t.length;h++)o+=t[h]*t[h]*r[h],n+=t[h]*r[h],s+=r[h],i+=t[h]*r[h]*e[h],l+=r[h]*e[h];const h=o*s-n*n,a=[[s/h,-n/h],[-n/h,o/h]];return[a[0][0]*i+a[0][1]*l,a[1][0]*i+a[1][1]*l]}(t,e,r);let s=-1,i=Number.MIN_SAFE_INTEGER;for(let r=0;r<t.length;r++){const l=t[r]*o+n,h=Math.abs(e[r]-l);h>34&&i<h&&(s=r,i=h)}return s>-1?(t.splice(s,1),e.splice(s,1),r.splice(s,1),$r(t,e,r)):{ph0:n,ph1:o}}function Dr(t,e,r){let o=-180,n=180;let s=10,i=0,l=Number.MAX_SAFE_INTEGER;for(;s>0;){const r=(n-o)/7;for(let s=o;s<=n;s+=r){const r=Yr(Pr({re:t,im:e},Lr(s),0).re);r<l&&([l,i]=[r,s])}o=i-r,n=i+r,s--}const h=Pr({re:t,im:e},Lr(i),0);let a=0,u=0;for(let e=0;e<t.length;e++)a+=h.re[e],u+=h.re[e]*(e+r);return{ph0:i,area:a,x0:u/a}}function Or(t,e){const{maxDistanceToJoin:r,magnitudeMode:o,factorNoise:n}=e,s=new Uint8Array(t.length);for(let e=0;e<t.length;e++)s[e]=0;let i=!0;for(;i;){const e=n*qe(t,{magnitudeMode:o}).positive;i=!1;for(let r=0;r<t.length;r++)Math.abs(t[r])>e&&!s[r]&&(i=!0,s[r]=1)}let l=0,h=0;for(let e=0;e<t.length;e++)if(s[e]){if(l<r)for(let t=0;t<=l;t++)s[h+t]=1;for(;s[++e]&&e<t.length;);h=e,l=0}else l++;return s}function Lr(t){return t*Math.PI/180}function Yr(t){let e=0;for(const r of t)r<0&&(e-=r);return e}function Ur(t,e={}){const{inverse:r=!1,applyZeroShift:o=!1}=e,{re:n,im:s}=t,i=n.length,l=i<<1;let h=new Float64Array(l);for(let t=0;t<l;t+=2)h[t]=n[t>>>1],h[t+1]=s[t>>>1];const a=new Nt(i);let u=new Float64Array(l);r?(o&&(h=Xr(h,!0)),a.inverseTransform(u,h)):(a.transform(u,h),o&&(u=Xr(u)));const f=new Float64Array(i),c=new Float64Array(i);for(let t=0;t<l;t+=2)f[t>>>1]=u[t],c[t>>>1]=u[t+1];return{re:f,im:c}}function Xr(t,e){return Ze(t,e?Math.ceil(t.length/2):Math.floor(t.length/2))}function Gr(t,e){if(!Number.isInteger(e)||e<0)throw new RangeError("totalLength must be a non-negative integer");const{re:r,im:o}=t,n=r.length;if(0===e||n===e)return t;if(n>e)return{re:r.slice(0,e),im:o.slice(0,e)};const s=new Float64Array(e),i=new Float64Array(e);return s.set(r),i.set(o),{re:s,im:i}}function Br(t,e,r={}){const{delta:o=1,common:n=!0,x:s="x1"}=r,i={x:[],y1:[],y2:[]};let l=0,h=0;const a=t.x.length,u=e.x.length;for(;l<a&&h<u;){let r=0;if("function"==typeof o){r=o((t.x[l]+e.x[h])/2)}else r=o;const f=t.x[l]-e.x[h];if(Math.abs(f)>r)if(f>0){if(!n&&(i.x.push(e.x[h]),i.y1.push(0),i.y2.push(e.y[h]),h===u-1))for(;l<a;)i.x.push(t.x[l]),i.y1.push(t.y[l]),i.y2.push(0),l++;h++}else{if(!n&&(i.x.push(t.x[l]),i.y1.push(t.y[l]),i.y2.push(0),l===a-1))for(;h<u;)i.x.push(e.x[h]),i.y1.push(0),i.y2.push(e.y[h]),h++;l++}else{const r=(t.x[l]*t.y[l]+e.x[h]*e.y[h])/(t.y[l]+e.y[h]);switch(s){case"x1":i.x.push(t.x[l]);break;case"x2":i.x.push(e.x[h]);break;case"weighted":i.x.push(r);break;default:throw new Error(`unknown x option value: ${String(s)}`)}i.y1.push(t.y[l]),i.y2.push(e.y[h]),l++,h++}}return i}function Wr(t,e={}){const{minLength:o}=e;if(null===t||"object"!=typeof t||!r(t.x)||!r(t.y))throw new Error("data must be an object of x and y arrays");if(t.x.length!==t.y.length)throw new Error("the x and y arrays must have the same length");if(o&&t.x.length<o)throw new Error(`data.x must have a length of at least ${o}`)}function Qr(t,e={}){const{x:r,y:o}=t,{unbiased:n=!0}=e,s=xt(r),i=xt(o);let l=0;for(let t=0;t<r.length;t++)l+=(r[t]-s)*(o[t]-i);return n?l/(r.length-1):l/r.length}function Jr(t,e={}){Wr(t,{minLength:1});const{x:r,y:o}=t;if(1===r.length)return{x:r[0],y:o[0],index:0};const{fromIndex:n,toIndex:s}=c(r,e);let i={x:r[n],y:o[n],index:n};for(let t=n;t<=s;t++)o[t]>i.y&&(i={x:r[t],y:o[t],index:t});return i}const Hr=[.25,.5,.75];function Zr(t){Wr(t,{minLength:1});const{x:e,y:r}=t,o=dt(r),n=oe(o);for(let t=0;t<o.length;t++)o[t]/=n;const s={x0:0,x25:0,x50:0,x75:0,x100:0,xMode:0,xMean:0};s.x0=e[0],s.x100=e.at(-1);let i=0;t:for(let t=1;t<o.length;t++)for(;Hr[i]<o[t];){if(s["x"+100*Hr[i]]=e[t-1]+(e[t]-e[t-1])*((Hr[i]-o[t-1])/(o[t]-o[t-1])),i++,i===Hr.length)break t}s.xMode=Jr(t).x;let l=0,h=0;for(let t=0;t<e.length;t++)l+=e[t]*r[t],h+=r[t];return s.xMean=l/h,s}function Kr(t){return{x:Et(t.x),y:Et(t.y)}}function to(t){if(Wr(t),1===le(t.x))return t;const e=Array.from(t.x),r=Array.from(t.y);let o=Number.NEGATIVE_INFINITY,n=0;for(let t=0;t<e.length;t++)o<e[t]&&(n<t&&(e[n]=e[t],r[n]=r[t]),n++,o=e[t]);return e.length=n,r.length=n,{x:e,y:r}}function eo(t=[],e={}){const{exclusions:r=[]}=e;let{from:o=Number.NEGATIVE_INFINITY,to:n=Number.POSITIVE_INFINITY}=e;o>n&&([o,n]=[n,o]),0===(t=t.map(t=>t.from>t.to?{from:t.to,to:t.from}:{...t}).sort((t,e)=>t.from!==e.from?t.from-e.from:t.to-e.to)).length&&t.push({from:o,to:n});for(const e of t)o>e.from&&(e.from=o),n<e.to&&(e.to=n);if(0===(t=t.filter(t=>t.from<=t.to)).length)return[];let s=t[0];const i=[s];for(let e=1;e<t.length;e++){const r=t[e];r.from<=s.to?s.to<r.to&&(s.to=r.to):(s=r,i.push(s))}if(0===r.length)return i;const l=eo(r);let h=0;const a=[];for(let t=0;t<i.length;t++){const e=i[t];if(h!==l.length){for(;h<l.length&&l[h].to<=e.from;)h++;if(h!==l.length)if(e.to<l[h].from)a.push(e);else{if(l[h].to>=e.to){if(l[h].from<=e.from)continue;a.push({from:l[h].to,to:e.to})}l[h].from>e.from&&a.push({from:e.from,to:l[h].from}),e.from=l[h].to,t--}else a.push(e)}else a.push(e)}return a}function ro(t=[],e=10,r={}){if(0===t.length)return[];const o=eo(t,r),n=[],s=o.reduce((t,e)=>t+(e.to-e.from),0)/e;let i=0;for(let t=0;t<o.length-1;t++){const r=o[t],l=Math.min(Math.round((r.to-r.from)/s),e-i);n.push({...r,numberOfPoints:l}),i+=l}return n.push({...o.at(-1),numberOfPoints:e-i}),n}function oo(t,e,r,o){return.5*r*e*e+o*e-(.5*r*t*t+o*t)}function no(t,e,r,o){return(o-e)/(r-t)}function so(t,e={}){const{x:r,y:o}=t,n=r.length,{from:s=r[0],to:i=r[n-1],variant:l="smooth",numberOfPoints:h=100,exclusions:a=[],zones:u=[{from:s,to:i}]}=e;if(s>i)throw new RangeError("from should be larger than to");if(Wr(t),h<2)throw new RangeError("'numberOfPoints' option must be greater than 1");const f=ro(eo(u,{from:s,to:i,exclusions:a}),h,{from:s,to:i}).filter(t=>t.numberOfPoints);let c=[],g=[];for(const t of f){t.numberOfPoints||(t.numberOfPoints=0);const e=io(Array.from(r),Array.from(o),t.from,t.to,t.numberOfPoints,l);c=c.concat(e.x),g=g.concat(e.y)}return{x:c,y:g}}function io(t,e,r,o,n,s){if(n<1)throw new RangeError("the number of points must be at least 1");const i="slot"===s?Array.from(function(t,e,r,o,n){const s=t.length;if(s<2)return Float64Array.from(t);const i=(o-r)/(n>1?n-1:1),l=i/2,h=t.at(-1)-t.at(-2),a=r-l,u=new Float64Array(n);let f=a,c=a+i,g=-Number.MAX_VALUE,m=0,w=t[0],y=e[0],p=0,d=!0,x=0,b=0,M=1,v=0;t:for(;;){if(g>=w)throw new Error("x must be a growing series");for(;g-c>0;){if(d&&(b++,d=!1),u[v]=b<=0?0:x/b,v++,v===n)break t;f=c,c+=i,x=0,b=0}g>f&&(x+=m,b++),(g===-Number.MAX_VALUE||p>1)&&b--,g=w,m=y,M<s?(w=t[M],y=e[M],M++):(w+=h,y=0,p++)}return u}(t,e,r,o,n)):Array.from(function(t,e,r,o,n){const s=t.length,i=(o-r)/(n>1?n-1:1),l=i/2,h=new Float64Array(n),a=t[1]-t[0],u=t[s-1]-t[s-2];let f=r-l,c=r+l,g=Number.MIN_SAFE_INTEGER,m=0,w=t[0]-a,y=0,p=0,d=0,x=0,b=0,M=0,v=0,A=0,E=0;t:for(;;){if(g>=w)throw new Error("x must be a growing series");for(g<=f&&f<=w&&(E=oo(0,f-g,d,m),b=p+E);w-c>=0;){if(E=oo(0,c-g,d,m),M=p+E,h[A++]=(M-b)/i,A===n)break t;f=c,c+=i,b=M}p+=oo(g,w,d,x),g=w,m=y,v<s?(w=t[v],y=e[v],v++):v===s&&(w+=u,y=0),d=no(g,m,w,y),x=-d*g+m}return h}(t,e,r,o,n));return{x:Array.from(_t({from:r,to:o,length:n})),y:i}}function lo(t,e={}){Wr(t);const{x:r,y:o}=t;let{zones:n}=e;if(n=eo(n),void 0===r||void 0===o||!Array.isArray(n)||0===n.length)return t;const s=[],i=[];let l=n[0],h=0;t:for(let t=0;t<r.length;t++){for(;l.to<r[t];)if(h++,l=n[h],!l){t=r.length;break t}r[t]>=l.from&&(s.push(r[t]),i.push(o[t]))}return{x:s,y:i}}function ho(t,e={}){const{x:r,y:o}=t,{filter:n}=e,s=[],i=[];for(let t=0;t<r.length;t++)n&&!n(r[t],o[t])||(s.push(r[t]),i.push(o[t]));return{x:s,y:i}}function ao(t,e){if(void 0===e)return t;const{x:r,y:o}=t,{min:n,max:s}=xe(o),i=s*e;if(n>=i)return t;const l=[],h=[];for(let t=0;t<r.length;t++)o[t]>=i&&(l.push(r[t]),h.push(o[t]));return{x:l,y:h}}function uo(t,e){if(void 0===e)return t;if(e>t.x.length)return t;const{x:r,y:o}=t,n=[],s=[],i=or(o.slice()),l=i[e-1];let h=0;for(let t=0;t<e;t++)i[t]===l&&h++;for(let t=0;t<r.length;t++)o[t]>l?(n.push(r[t]),s.push(o[t])):o[t]===l&&(h--,h>=0&&(n.push(r[t]),s.push(o[t])));return{x:n,y:s}}function fo(t,e={}){const{x:r,y:o}=t;if(0===r.length)return{x:Array.from(r),y:Array.from(o)};const{from:n=r[0],to:s=r.at(-1),zones:i=[{from:n,to:s}],exclusions:l=[]}=e,h=eo(i,{from:n,to:s,exclusions:l});let a=0;const u=[],f=[];let c=0;for(;c<r.length;){if(r[c]<=h[a].to&&r[c]>=h[a].from)u.push(r[c]),f.push(o[c]);else if(r[c]>h[a].to&&(a++,!h[a]))break;c++}return{x:u,y:f}}function co(t){Wr(t);const{x:e,y:r}=t,o=[],n=[];if(void 0===e||void 0===r)return{x:o,y:n};for(let t=0;t<e.length;t++)e[t]>0&&(o.push(e[t]),n.push(r[t]));return{x:o,y:n}}function go(t,e){const{x:r,y:o}=t,n=f(r,e);return{x:r[n],y:o[n]}}function mo(t,e){if(Wr(t),t.x.length<=e)return t;{const r=new Float64Array(e),o=new Float64Array(e),n=Float64Array.from(t.y);n.sort().reverse();const s=n[e-1];let i=0;for(let n=0;n<t.x.length;n++)if(t.y[n]>=s&&(r[i]=t.x[n],o[i]=t.y[n],i++),i===e)return{x:r,y:o};return t}}function wo(t){const{x:e,y:r}=t;if(e.length!==r.length)throw new TypeError("length of x and y must be identical");return e.length<2||e[0]<e.at(-1)?t:{x:e.toReversed(),y:r.toReversed()}}function yo(t,e={}){const{reverse:r=!1}=e;Wr(t,{minLength:1});const{x:o,y:n}=t,{fromIndex:s,toIndex:i}=c(o,e);let l=0;const h={x:new Float64Array(i-s+1),y:new Float64Array(i-s+1)};let a=0;if(r){h.y[a]=0,h.x[a++]=o[i];for(let t=i;t>s;t--)l+=(o[t]-o[t-1])*(n[t-1]+n[t])/2,h.x[a]=o[t-1],h.y[a++]=l;h.x.reverse(),h.y.reverse()}else{h.y[a]=0,h.x[a++]=o[s];for(let t=s;t<i;t++)l+=(o[t+1]-o[t])*(n[t+1]+n[t])/2,h.x[a]=o[t+1],h.y[a++]=l}return h}function po(t,e={}){Wr(t,{minLength:1});const{x:r,y:o}=t;if(1===r.length)return 0;const{fromIndex:n,toIndex:s}=c(r,e);let i=0;for(let t=n;t<s;t++)i+=(r[t+1]-r[t])*(o[t+1]+o[t])/2;return i}function xo(t,e={}){Wr(t);const{delta:r=1}=e,o="function"==typeof r,n=Array.from(t.x),s=Array.from(t.y);if(n.length<2)return{x:n,y:s};let i=0;for(let t=1;t<n.length;t++){n[t]-n[t-1]<=(o?r((n[t]+n[t-1])/2):r)?0===s[i]&&0===s[t]||(n[i]=(n[i]*s[i]+n[t]*s[t])/(s[i]+s[t]),s[i]+=s[t]):(i++,n[i]=n[t],s[i]=s[t])}return n.length=i+1,s.length=i+1,{x:n,y:s}}function bo(t,e={}){Wr(t,{minLength:1});const{x:r,y:o}=t,{fromIndex:n,toIndex:s}=c(r,e);let i=0,l=0;for(let t=n;t<=s;t++)l+=r[t]*o[t],i+=o[t];if(0===i)throw new Error("Sum of Ys can not be zero.");return l/i}function Mo(t,e={}){Wr(t,{minLength:2});const{depth:r=5}=e,{weightedIntegral:o,integral:n}=function(t){const{x:e,y:r}=t,o=new Float64Array(e.length),n=new Float64Array(e.length),s=(e[1]-e[0])*r[0];let i=s;n[0]=i;let l=s*e[0];o[0]=l;for(let t=1;t<e.length-1;t++){const s=(e[t+1]-e[t-1])*r[t]/2,h=e[t];i+=s,n[t]=i,l+=s*h,o[t]=l}const h=(e.at(-1)-e.at(-2))*r.at(-1);return i+=h,n[e.length-1]=i,l+=h*e.at(-1),o[e.length-1]=l,{integral:n,weightedIntegral:o}}(t),s=new Float64Array((1<<r)-1),i=new Int32Array((1<<r)-1);i[0]=t.x.length-1;const l=new Int32Array((1<<r)-1);l[0]=-1;let h=0;for(let e=0;e<r;e++)for(let a=0;a<1<<e;a++){const u=l[h],c=i[h],g=-1===u?n[c]:n[c]-n[u];let m=0;if(m=0!==g?-1===u?o[c]/g:(o[c]-o[u])/g:(t.x[c]+t.x[u])/2,s[h++]=m,e<r-1){const r=(1<<e+1)+2*a-1;let o=f(t.x,m);o===u&&o++,l[r]=u,i[r]=o,o===c&&o--,l[r+1]=o,i[r+1]=c}}return s}function vo(t,e={}){Wr(t);const{x:r,y:o}=t,{target:n}=e;let{targetIndex:s}=e;void 0===s&&(s=void 0!==n?f(r,n):0);let i=Number.MIN_SAFE_INTEGER,l=s,h=o[s];for(;l!==i;)i=l,l>0&&o[l-1]>h?l--:l<r.length-1&&o[l+1]>h&&l++,h=o[l];return{x:r[l],y:o[l],index:l}}function Ao(t,e={}){Wr(t,{minLength:2});const{x:r,y:o}=t,{fromIndex:n,toIndex:s}=c(r,e),i=[];let l=-1;for(let t=n+1;t<s;t++)if(o[t-1]<o[t]&&o[t+1]<o[t])i.push({x:r[t],y:o[t],index:t});else if(o[t-1]<o[t]&&o[t+1]===o[t])l=t;else if(o[t-1]===o[t]&&o[t+1]<o[t]){const e=Math.floor((t+l)/2);i.push({x:r[e],y:o[e],index:e})}return i}function Eo(t,e={}){const{x:r,y:o}=t,{groupWidth:n=.001}=e,s={x:[],y:[]},i={x:[],y:[]};let l=0,h=0;for(;h<r.length;)0===l||r[h]-s.x[l-1]>n?(i.x.push(r[h]),i.y.push(o[h]),s.x.push(r[h]),s.y.push(o[h]),h++,l++):(o[h]>i.y[l-1]&&(i.x[l-1]=r[h],i.y[l-1]=o[h]),s.x[l-1]=r[h],s.y[l-1]+=o[h],h++);return s.x=i.x.slice(),s}function Io(t,e={}){Wr(t);const{x:r,y:o}=t,{fromIndex:n,toIndex:s}=c(r,e);let i=o[n];for(let t=n;t<=s;t++)o[t]>i&&(i=o[t]);return i}function So(t){const{x:e,y:r}=t;let o,n=0,s=0;if(0===e.length)return Number.NaN;if(1===e.length)return e[0];for(o=0;o<r.length;o++)n+=r[o];for(o=0;o<r.length;o++){if(s+=r[o],s>n/2)return e[o];if(s===n/2)return.5*(e[o]+e[o+1])}return Number.NaN}function Ro(t,e,r={}){const{window:o=.01}=r,n={x:Float64Array.from(e),y:new Float64Array(e.length).fill(0)};let s=0,i=0;for(;s<t.x.length&&i<e.length;){const r=t.x[s]-e[i];Math.abs(r)<o?n.y[i]+=t.y[s++]:r<0?s++:i++}return n}function No(t,e={}){Wr(t);const{x:r,y:o}=t,{target:n}=e;let{targetIndex:s}=e;void 0===s&&(s=void 0!==n?f(r,n):0);let i=Number.MIN_SAFE_INTEGER,l=s,h=o[s];for(;l!==i;)i=l,l>0&&o[l-1]<h?l--:l<r.length-1&&o[l+1]<h&&l++,h=o[l];return{x:r[l],y:o[l],index:l}}function Fo(t,e={}){Wr(t,{minLength:2});const{x:r,y:o}=t,{fromIndex:n,toIndex:s}=c(r,e),i=[];let l=-1;for(let t=n+1;t<s;t++)if(o[t-1]>o[t]&&o[t+1]>o[t])i.push({x:r[t],y:o[t],index:t});else if(o[t-1]>o[t]&&o[t+1]===o[t])l=t;else if(o[t-1]===o[t]&&o[t+1]>o[t]){const e=Math.floor((t+l)/2);i.push({x:r[e],y:o[e],index:e})}return i}function To(t,e={}){Wr(t,{minLength:1});const{x:r,y:o}=t;if(1===r.length)return{x:r[0],y:o[0],index:0};const{fromIndex:n,toIndex:s}=c(r,e);let i={x:r[n],y:o[n],index:n};for(let t=n;t<=s;t++)o[t]<i.y&&(i={x:r[t],y:o[t],index:t});return i}function _o(t,e={}){Wr(t);const{x:r,y:o}=t;if(void 0===r||void 0===o||r.length<3)return;const{target:n}=e;let{targetIndex:s}=e;if(void 0===s&&void 0!==n&&(s=f(r,n)),void 0===s)throw new Error("must specify target or targetIndex");let i=s,l=o[i]-o[i+1];const h=l<0?-1:1;for(l*=h;i<r.length-1;){i++;const t=(o[i]-o[i+1])*h;if(t<l)break;l=t}const a={x:r[i],y:o[i]};for(i=s,l=(o[i]-o[i-1])*h;i>1;){i--;const t=(o[i]-o[i-1])*h;if(t<l)break;l=t}const u={x:r[i],y:o[i]};return{inflectionBefore:u,inflectionAfter:a,extrema:{x:r[s],y:o[s]},inflectionMiddle:{x:(u.x+a.x)/2,y:(u.y+a.y)/2},width:Math.abs(u.x-a.x)}}function ko(t,e={}){Wr(t);const{x:r,y:o}=t,n=It(r,e);if(o[n-1]>0&&o[n+1]>0&&o[n]>=o[n-1]&&o[n]>=o[n+1]){const t=20*Math.log10(o[n-1]),e=20*Math.log10(o[n]),s=20*Math.log10(o[n+1]),i=.5*(t-s)/(t-2*e+s);return{x:r[n]+(r[n]-r[n-1])*i,y:o[n]-.25*(o[n-1]-o[n+1])*i,index:n}}return{x:r[n],y:o[n],index:n}}function Co(t,e={}){Wr(t);const{x:r,y:o}=t,n=It(r,e);if(o[n-1]<0&&o[n+1]<0&&o[n]<=o[n-1]&&o[n]<=o[n+1]){const t=20*Math.log10(-o[n-1]),e=20*Math.log10(-o[n]),s=20*Math.log10(-o[n+1]),i=.5*(t-s)/(t-2*e+s);return{x:r[n]+(r[n]-r[n-1])*i,y:o[n]-.25*(o[n-1]-o[n+1])*i,index:n}}return{x:r[n],y:o[n],index:n}}function Vo(t,e={}){if(Wr(t),t.x.length<2)return{x:Float64Array.from(t.x),y:Float64Array.from(t.y)};const{x:r,y:o}=t,{from:n=r[0],to:s=r.at(-1),nbPoints:i=4001,optimize:l=!1}=e;let{zones:h=[]}=e;h=eo(h,{from:n,to:s}),0===h.length&&(h=[{from:n,to:s}]);const{internalZones:a,totalPoints:u}=zo(h,r);if(u<=i)return qo(r,o,a,u);const f=i/u;let c=0;for(let t=0;t<a.length-1;t++){const e=a[t];e.nbPoints=Math.round(e.nbPoints*f),c+=e.nbPoints}a.at(-1).nbPoints=i-c;const g=[],m=[];for(const t of a)t.nbPoints&&w(t.fromIndex,t.toIndex,t.nbPoints);return{x:g,y:m};function w(t,e,n){if(1===n)return g.push(r[Math.round((e-t)/2)]),void m.push(o[Math.round((e-t)/2)]);if(2===n)return g.push(r[t],r[e]),void m.push(o[t],o[e]);g.push(r[t]),m.push(o[t]),n=n%2==0?n/2+1:(n-1)/2+1;const s=(r[e]-r[t])/(n-1);let i=r[t]+s,h=!0,a=Number.POSITIVE_INFINITY,u=Number.NEGATIVE_INFINITY;for(let n=t+1;n<=e;n++)h?(a=o[n],u=o[n],h=!1):(o[n]<a&&(a=o[n]),o[n]>u&&(u=o[n])),(r[n]>=i||n===e)&&(l?a>m[g.length-1]||(u<m[g.length-1]?u=a:(g.push(i-s/2),m.push(a))):(g.push(i-s/2),m.push(a)),g.push(i),m.push(u),i+=s,h=!0)}}function qo(t,e,r,o){const n=new Float64Array(o),s=new Float64Array(o);let i=0;for(const o of r)for(let r=o.fromIndex;r<o.toIndex+1;r++)n[i]=t[r],s[i]=e[r],i++;return{x:n,y:s}}function zo(t,e){const r=[];let o=0;for(const n of t){let t=f(e,n.from),s=f(e,n.to);t>0&&e[t]>n.from&&t--,s<e.length-1&&e[s]<n.to&&s++;const i=s-t+1;r.push({from:n.from,to:n.to,fromIndex:t,toIndex:s,nbPoints:i}),o+=i}return{internalZones:r,totalPoints:o}}function Po(t,e={}){if(Wr(t),t.x.length<2)return{x:Float64Array.from(t.x),y:Float64Array.from(t.y)};const{x:r,y:o}=t,{from:n=r[0],to:s=r.at(-1),maxApproximateNbPoints:i=4001}=e;let{zones:l=[]}=e;l=eo(l,{from:n,to:s}),0===l.length&&(l=[{from:n,to:s}]);const{internalZones:h,totalPoints:a}=zo(l,r);if(a<=i)return qo(r,o,h,a);const u=(s-n)/(i-1),f=[],c=[];for(const t of h){const e=Math.ceil((t.to-t.from)/u)+1,n=t.fromIndex,s=t.toIndex;if(s-n+1<=e)for(let t=n;t<=s;t++)f.push(r[t]),c.push(o[t]);else{let t=r[n],e=o[n],i=t+u;f.push(t),c.push(e);for(let l=n;l<=s;l++)r[l]>i&&(t=r[l],e=o[l],f.push(t),c.push(e),i+=u),o[l]>e&&(e=o[l],c[c.length-1]=e)}}return{x:f,y:c}}function jo(t,e,r={}){let{x:o,y:n}=t;return n=Be(n,e,r),o.length!==n.length&&(o=We(o,r)),{x:o,y:n}}function $o(t,e={}){Wr(t);const{x:r,y:o}=t,{value:n=0}=e;let{zones:s}=e;if(!Array.isArray(s)||0===s.length)return t;s=eo(s);const i=r.slice(),l=o.slice();let h=s[0],a=0;t:for(let t=0;t<r.length;t++){for(;h.to<r[t];)if(a++,h=s[a],!h){t=r.length;break t}r[t]>=h.from&&(l[t]=n)}return{x:i,y:l}}function Do(t){const{x:e,y:r}=t;if(le(e)&&e.length>1){const t=Float64Array.from(e),o=Float64Array.from(r);return t.at(-1)<t[0]&&(t.reverse(),o.reverse()),{x:t,y:o}}const o=Array.from(e,(t,e)=>({x:t,y:r[e]})).sort((t,e)=>t.x-e.x),n={x:new Float64Array(e.length),y:new Float64Array(r.length)};for(let t=0;t<e.length;t++)n.x[t]=o[t].x,n.y[t]=o[t].y;return n}function Oo(t){Wr(t);const{x:e,y:r}=t,o=[];for(let t=0;t<e.length;t++)o.push([e[t],r[t]]);return o}function Lo(t){Wr(t);const{x:e,y:r}=t,o=[];for(let t=0;t<e.length;t++)o.push({x:e[t],y:r[t]});return o}function Yo(t,e={}){if(Wr(t),0===t.x.length)return{x:[],y:[]};const{algorithm:r="average",isSorted:o=!0}=e;switch(o||(t=Do(t)),r){case"average":return function(t){const e=[],r=[];let o=t.y[0],n=1;for(let s=1;s<t.x.length;s++)t.x[s]!==t.x[s-1]&&(e.push(t.x[s-1]),r.push(o/n),o=0,n=0),o+=t.y[s],n++;return e.push(t.x.at(-1)),r.push(o/n),{x:e,y:r}}(t);case"sum":return function(t){const e=[],r=[];let o=t.y[0];for(let n=1;n<t.x.length;n++)t.x[n]!==t.x[n-1]&&(e.push(t.x[n-1]),r.push(o),o=0),o+=t.y[n];return e.push(t.x.at(-1)),r.push(o),{x:e,y:r}}(t);default:throw new Error(`unknown algorithm: ${String(r)}`)}}function Uo(t,e={}){const{x:r,y:o}=t,{groupWidth:n=.001}=e,s={x:[],y:[]},i={x:[],y:[]};let l=0,h=0;for(;h<r.length;)0===l||r[h]-s.x[l-1]>n?(i.x.push(r[h]*o[h]),i.y.push(o[h]),s.x.push(r[h]),s.y.push(o[h]),h++,l++):(i.x[l-1]+=r[h]*o[h],i.y[l-1]+=o[h],s.x[l-1]=r[h],s.y[l-1]+=o[h],h++);for(let t=0;t<s.x.length;t++)s.x[t]=i.x[t]/i.y[t];return s}function Xo(t){const e={x:[],y:[]};for(const r of t)e.x.push(r[0]),e.y.push(r[1]);return e}function Go(t){const{x:e,re:r,im:o}=t;if(e.length!==r.length||e.length!==o.length)throw new TypeError("length of x, re and im must be identical");return e.length<2||e[0]<e[1]?t:{x:e.toReversed(),re:r.toReversed(),im:o.toReversed()}}function Bo(t,e){const{x:r,re:o,im:n}=t,s=r.length;if(0===e||s===e)return t;if(s>e)return{x:r.slice(0,e),re:o.slice(0,e),im:n.slice(0,e)};const i=new Float64Array(e);i.set(r);const l=(r.at(-1)-r[0])/(s-1);for(let t=s;t<e;t++)i[t]=i[t-1]+l;return{x:i,...Gr({re:o,im:n},e)}}function Wo(t,e={}){const{delta:r=1}=e,o="function"==typeof r,n=Float64Array.from(t.flatMap(t=>t.x)).sort();if(0===n.length)throw new Error("can not process empty arrays");let s={from:n[0],to:n[0],average:n[0],sum:n[0],number:1};const i=[s];for(let t=1;t<n.length;t++){const e=o?r(n[t]):r;n[t]-s.to<=e?(s.to=n[t],s.number++,s.sum+=n[t],s.average=s.sum/s.number):(s={from:n[t],to:n[t],average:n[t],sum:n[t],number:1},i.push(s))}return i}function Qo(t,e={}){const{delta:r=1,requiredY:o=!1}=e,n=Wo(t=t.map(t=>xo(t,{delta:r})),{delta:r}),s=Float64Array.from(n.map(t=>t.average)),i=Array.from(t,()=>new Float64Array(s.length)),l=new Uint32Array(t.length);for(let e=0;e<n.length;e++){const r=n[e];for(let o=0;o<t.length;o++){const n=t[o];for(;l[o]<n.x.length&&n.x[l[o]]<=r.to;)i[o][e]+=n.y[l[o]],l[o]++}}return o?function(t,e){const r=[],o=Array.from(e,()=>[]);for(let n=0;n<t.length;n++)if(e.every(t=>0!==t[n])){r.push(t[n]);for(let t=0;t<e.length;t++)o[t].push(e[t][n])}return{x:r,ys:o}}(s,i):{x:s,ys:i}}function Jo(t,e={}){let{delta:r=1}=e;if("number"==typeof r){const t=r;r=()=>t}if(0===(t=t.filter(t=>t.x.length>0)).length)return{x:[],y:[]};const o=[],n=[],s=new Array(t.length).fill(0),i={x:0,y:0};Ho(t,s,i);const l={maxX:i.x+r(i.x),sumY:i.y,sumXY:i.y*i.x};for(;t.length>0;){Ho(t,s,i);i.x<=l.maxX||(l.sumY>0&&(o.push(l.sumXY/l.sumY),n.push(l.sumY)),l.sumY=0,l.sumXY=0),l.sumY+=i.y,l.sumXY+=i.x*i.y,l.maxX=i.x+r(i.x),0===t.length&&l.sumY>0&&(o.push(l.sumXY/l.sumY),n.push(l.sumY))}return{x:o,y:n}}function Ho(t,e,r){let o=0,n=t[0].x[e[0]];for(let r=1;r<t.length;r++){const s=t[r].x[e[r]];s<n&&(n=s,o=r)}r.x=n,r.y=t[o].y[e[o]],e[o]++,e[o]===t[o].x.length&&(e.splice(o,1),t.splice(o,1))}function Zo(t,e={}){const{delta:r=1}=e,o=function(t,e={}){const{delta:r=1}=e,o="function"==typeof r,n=t[0].x,s=[];for(const t of n){const e=o?r(t):r;s.push({from:t-e,to:t+e,value:t})}const i=Jo(t.slice(1),e).x;let l=0;for(const t of s)for(;i[l]<t.to&&l<i.length;){if(i[l]<t.from){const t=o?r(i[l]):r;s.push({from:i[l]-t,to:i[l]+t,value:i[l]})}l++}for(let t=l;t<i.length;t++){const e=o?r(i[t]):r;s.push({from:i[t]-e,to:i[t]+e,value:i[t]})}s.sort((t,e)=>t.value-e.value);for(let t=0;t<s.length-1;t++)if(s[t].to>s[t+1].from){const e=(s[t].value+s[t+1].value)/2;s[t].to=e,s[t+1].from=e}return s}(t,{delta:r}),n=Float64Array.from(o.map(t=>t.value)),s=Array.from(t,()=>new Float64Array(n.length)),i=new Uint32Array(t.length);for(let e=0;e<o.length;e++){const r=o[e];for(let o=0;o<t.length;o++){const n=t[o];for(;i[o]<n.x.length&&n.x[i[o]]<r.to;)s[o][e]+=n.y[i[o]],i[o]++}}return{x:n,ys:s}}function Ko(t,e={}){const{delta:r=1}=e,o=Wo(t=t.map(t=>xo(t,{delta:r})),{delta:r}),n=Float64Array.from(o.map(t=>t.average)),s=new Float64Array(n.length),i=new Uint32Array(t.length);for(let e=0;e<o.length;e++){const r=o[e];for(let o=0;o<t.length;o++){const n=t[o];for(;i[o]<n.x.length&&n.x[i[o]]<=r.to;)s[e]+=n.y[i[o]],i[o]++}}return{x:n,y:s}}function tn(t,e={}){const{minLength:r=0}=e;if(!Array.isArray(t))throw new Error("points must be an array of {x,y} objects");if(t.length>0&&("number"!=typeof t[0].x||"number"!=typeof t[0].y))throw new Error("points must be an array of {x,y} objects");if(r&&t.length<r)throw new Error(`points must have a length of at least ${r}`)}function en(t=[]){if(tn(t),0===t.length)return{x:0,y:0};let e={x:t[0].x,y:t[0].y,index:0};for(let r=1;r<t.length;r++)t[r].x>e.x&&(e={x:t[r].x,y:t[r].y,index:r});return e}function rn(t=[]){if(tn(t),0===t.length)return{x:0,y:0};let e={x:t[0].x,y:t[0].y,index:0};for(let r=1;r<t.length;r++)t[r].x<e.x&&(e={x:t[r].x,y:t[r].y,index:r});return e}function on(t,e={}){const{from:r=rn(t).x,to:o=en(t).x,limit:n=20,threshold:s=.01,numberCloseSlots:i=50,numberSlots:l=10}=e,h=(o-r)/l,a=(o-r)/i;let u=t.filter(t=>t.x>=r&&t.x<=o).map(t=>({point:t,monoisotopic:!1}));u=u.sort((t,e)=>t.monoisotopic&&!e.monoisotopic?-1:e.monoisotopic&&!t.monoisotopic?1:e.point.y-t.point.y);const f=[];if(0===u.length)return[];const c=u[0].point.y*s;t:for(const t of u){if(t.point.y<c){if(t.monoisotopic)continue;break}let e=!1;for(const r of f){if(Math.abs(r.x-t.point.x)<a)continue t;Math.abs(r.x-t.point.x)<h&&(e=!0)}const r={...t.point,close:e};if(f.push(r),f.length===n)break}return f.sort((t,e)=>t.x-e.x)}function nn(t,e={}){const{xError:r=Number.EPSILON}=e,o=[];let n={x:Number.MIN_SAFE_INTEGER,y:0};for(const e of t)e.x-n.x<=r?0===n.y&&0===e.y||(n.x=e.y/(n.y+e.y)*(e.x-n.x)+n.x,n.y+=e.y):(n={x:e.x,y:e.y},o.push(n));return o}function sn(t=[]){if(tn(t),0===t.length)return{x:0,y:0};let e={x:t[0].x,y:t[0].y,index:0};for(let r=1;r<t.length;r++)t[r].y>e.y&&(e={x:t[r].x,y:t[r].y,index:r});return e}function ln(t){tn(t,{minLength:1});let e=t[0].x,r=e,o=t[0].y,n=o;for(const s of t)s.x<e&&(e=s.x),s.x>r&&(r=s.x),s.y<o&&(o=s.y),s.y>n&&(n=s.y);return{minX:e,maxX:r,minY:o,maxY:n}}function hn(t=[]){if(tn(t),0===t.length)return{x:0,y:0};let e={x:t[0].x,y:t[0].y,index:0};for(let r=1;r<t.length;r++)t[r].y<e.y&&(e={x:t[r].x,y:t[r].y,index:r});return e}function an(t,e){const r=Oe((t=structuredClone(t)).map(t=>t.y),e);for(let e=0;e<t.length;e++)t[e].y=r[e];return t}function un(t,e={}){const{slotWidth:r=1}=e,o=r/2,n=[];let s={x:Number.NEGATIVE_INFINITY,y:0};for(const e of t){const t=e.x-(e.x+o)%r+o;Math.abs(s.x-t)>Number.EPSILON&&(s={x:t,y:0},n.push(s)),s.y+=e.y}return n}function fn(t){return t.sort((t,e)=>t.x-e.x)}function cn(t=[]){tn(t);let e=0;for(const r of t)e+=r.y;return e}function gn(t){return{x:t.map(t=>t.x),y:t.map(t=>t.y)}}export{Bt as calculateAdaptiveWeights,Tt as createDoubleArray,_t as createFromToArray,Ft as createNumberArray,qt as createRandomArray,Pt as createStepArray,o as getOutputArray,jt as getRescaler,$t as isPowerOfTwo,sr as matrixAbsoluteMedian,lr as matrixApplyNumericalEncoding,hr as matrixAutoCorrelation,ar as matrixBoxPlot,ur as matrixCenterZMean,fr as matrixCheck,cr as matrixCholeskySolver,gr as matrixClone,mr as matrixColumnsCorrelation,ir as matrixCreateEmpty,wr as matrixCuthillMckee,pr as matrixGetSubMatrix,br as matrixHistogram,Mr as matrixMaxAbsoluteZ,Ar as matrixMedian,dr as matrixMinMaxAbsoluteZ,xr as matrixMinMaxZ,Er as matrixNoiseStandardDeviation,Ir as matrixNumericalDecoding,Sr as matrixNumericalEncoding,Rr as matrixPQN,Nr as matrixSetSubMatrix,vr as matrixToArray,kr as matrixTranspose,Fr as matrixZPivotRescale,Tr as matrixZRescale,_r as matrixZRescalePerColumn,Dt as nextPowerOfTwo,Wt as recursiveRemoveEmptyAndNull,Ot as recursiveResolve,Yt as recursiveUntypeArrays,t as reimAbsolute,jr as reimAutoPhaseCorrection,Ur as reimFFT,Pr as reimPhaseCorrection,Gr as reimZeroFilling,Xt as stringify,n as xAbsolute,a as xAbsoluteMedian,g as xAbsoluteSum,m as xAdd,w as xApplyFunctionStr,x as xAutoCorrelation,b as xBoxPlot,M as xBoxPlotWithOutliers,u as xCheck,v as xCheckLengths,A as xCorrelation,pt as xCostMatrix,d as xCrossCorrelation,dt as xCumulative,vt as xDistributionStats,At as xDivide,p as xDotProduct,Et as xEnsureFloat64,f as xFindClosestIndex,c as xGetFromToIndex,It as xGetTargetIndex,te as xHilbertTransform,se as xHistogram,ie as xIsEquallySpaced,le as xIsMonotonic,he as xMassCenterVectorSimilarity,fe as xMaxAbsoluteValue,ce as xMaxIndex,oe as xMaxValue,xt as xMean,ge as xMeanAbsoluteError,me as xMeanSquaredError,we as xMeanWeighted,s as xMedian,ye as xMedianAbsoluteDeviation,pe as xMinIndex,de as xMinMaxDelta,xe as xMinMaxValues,ne as xMinValue,be as xMode,y as xMultiply,qe as xNoiseSanPlot,je as xNoiseStandardDeviation,$e as xNorm,Oe as xNormed,Le as xPadding,Ye as xParetoNormalization,Xe as xRemoveOutliersIQR,Ge as xRescale,Ue as xRobustDistributionStats,Be as xRolling,We as xRollingAverage,Qe as xRollingMax,Je as xRollingMedian,He as xRollingMin,Ze as xRotate,Ke as xSampling,tr as xSequentialFillFromStep,er as xSequentialFillFromTo,rr as xSortAscending,or as xSortDescending,Mt as xStandardDeviation,Gt as xSubtract,De as xSum,nr as xUniqueSorted,bt as xVariance,zr as xWhitakerSmoother,Vr as xWhittakerSmoother,Go as xreimSortX,Bo as xreimZeroFilling,Xo as xy2ToXY,Br as xyAlign,Qo as xyArrayAlign,Zo as xyArrayAlignToFirst,Ko as xyArrayMerge,Jo as xyArrayWeightedMerge,Wr as xyCheck,Qr as xyCovariance,Zr as xyCumulativeDistributionStatistics,Kr as xyEnsureFloat64,to as xyEnsureGrowingX,so as xyEquallySpaced,lo as xyExtract,ho as xyFilter,ao as xyFilterMinYValue,uo as xyFilterTopYValues,fo as xyFilterX,co as xyFilterXPositive,go as xyFindClosestPoint,mo as xyGetNMaxY,wo as xyGrowingX,yo as xyIntegral,po as xyIntegration,xo as xyJoinX,bo as xyMassCenter,Mo as xyMassCenterVector,vo as xyMaxClosestYPoint,Eo as xyMaxMerge,Io as xyMaxY,Jr as xyMaxYPoint,Ao as xyMaximaY,So as xyMedian,Ro as xyMergeByCentroids,No as xyMinClosestYPoint,To as xyMinYPoint,Fo as xyMinimaY,on as xyObjectBestPoints,tn as xyObjectCheck,nn as xyObjectJoinX,en as xyObjectMaxXPoint,sn as xyObjectMaxYPoint,ln as xyObjectMinMaxValues,rn as xyObjectMinXPoint,hn as xyObjectMinYPoint,an as xyObjectNormedY,un as xyObjectSlotX,fn as xyObjectSortX,cn as xyObjectSumY,gn as xyObjectToXY,_o as xyPeakInfo,ko as xyRealMaxYPoint,Co as xyRealMinYPoint,Vo as xyReduce,Po as xyReduceNonContinuous,jo as xyRolling,$o as xySetYValue,Do as xySortX,Oo as xyToXYArray,Lo as xyToXYObject,Yo as xyUniqueX,Uo as xyWeightedMerge,eo as zonesNormalize,ro as zonesWithPoints};
//# sourceMappingURL=ml-spectra-processing.esm.min.js.map
