/* spectra-processor 4.0.1 | MIT | https://github.com/cheminfo/spectra-processor#readme */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports):"function"==typeof define&&define.amd?define(["exports"],e):e((t="undefined"!=typeof globalThis?globalThis:t||self).spectraProcessor={})}(this,function(t){"use strict";const e=Object.prototype.toString;function r(t){const r=e.call(t);return r.endsWith("Array]")&&!r.includes("Big")}function n(t,e){if(void 0!==t){if(!r(t))throw new TypeError("output option must be an array if specified");if(t.length!==e)throw new TypeError("the output array does not have the correct length");return t}return new Float64Array(e)}function o(t,e={}){if(!r(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");const{exact:n=!1}=e||{},o=t.slice(),i=a(0,o.length-1),l=s(o,i);if(o.length%2==1||!n)return l;return(l+s(o,i+1))/2}function s(t,e){let r=0,n=t.length-1,o=0,s=0,l=0;for(;;){if(n<=r)return t[e];if(n===r+1)return t[r]>t[n]&&i(t,r,n),t[e];for(o=a(r,n),t[o]>t[n]&&i(t,o,n),t[r]>t[n]&&i(t,r,n),t[o]>t[r]&&i(t,o,r),i(t,o,r+1),s=r+1,l=n;;){do{s++}while(t[r]>t[s]);do{l--}while(t[l]>t[r]);if(l<s)break;i(t,s,l)}i(t,r,l),l<=e&&(r=s),l>=e&&(n=l-1)}}function i(t,e,r){const n=t[r];t[r]=t[e],t[e]=n}function a(t,e){return Math.floor((t+e)/2)}function l(t,e={}){const{minLength:n}=e;if(!r(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");if("number"!=typeof t[0])throw new TypeError("input must contain numbers");if(n&&t.length<n)throw new Error(`input must have a length of at least ${n}`)}function u(t,e,r={}){const{sorted:n=!0}=r;if(n){let r=0,n=t.length-1,o=0;for(;n-r>1;)if(o=r+(n-r>>1),t[o]<e)r=o;else{if(!(t[o]>e))return o;n=o}return r<t.length-1?Math.abs(e-t[r])<Math.abs(t[r+1]-e)?r:r+1:r}{let r=0,n=Number.POSITIVE_INFINITY;for(let o=0;o<t.length;o++){const s=Math.abs(t[o]-e);s<n&&(n=s,r=o)}return r}}function f(t,e={}){let{fromIndex:r,toIndex:n}=e;const{from:o,to:s}=e;return void 0===r&&(r=void 0!==o?u(t,o):0),void 0===n&&(n=void 0!==s?u(t,s):t.length-1),r<0&&(r=0),n<0&&(n=0),r>=t.length&&(r=t.length-1),n>=t.length&&(n=t.length-1),r>n&&([r,n]=[n,r]),{fromIndex:r,toIndex:n}}function c(t,e){let n=!1,o=0;if(r(e)){if(t.length!==e.length)throw new Error("size of array1 and array2 must be identical")}else n=!0,o=e;const s=new Float64Array(t.length);if(n)for(let e=0;e<t.length;e++)s[e]=t[e]+o;else for(let r=0;r<t.length;r++)s[r]=t[r]+e[r];return s}function h(t,e={}){const{variableLabel:r="x",fctString:n=r}=e,o=new Function(r,`return Number(${n.replaceAll(/(?<before>^|\W)(?<after>[\da-z]{2,}\()/g,"$<before>Math.$<after>").replaceAll("Math.Math","Math")})`),s=Float64Array.from(t);for(let e=0;e<t.length;e++)if(s[e]=o(t[e]),Number.isNaN(s[e]))throw new Error(`The callback ${n} does not return a number: ${t[e]}`);return s}function m(t,e,o={}){let s=!1,i=0;if(r(e)){if(t.length!==e.length)throw new Error("size of array1 and array2 must be identical")}else s=!0,i=e;const a=n(o.output,t.length);if(s)for(let e=0;e<t.length;e++)a[e]=t[e]*i;else for(let r=0;r<t.length;r++)a[r]=t[r]*e[r];return a}function g(t){l(t);const e=((t=Float64Array.from(t).sort()).length-1)/4,r=(t.length-1)*(3/4),n=(t.length-1)/2,o=e%1,s=r%1,i=n%1;return{min:t[0],q1:0===o?t[e]:t[e|0]*(1-o)+t[1+(e|0)]*o,median:0===i?t[n]:t[n|0]*(1-i)+t[1+(n|0)]*i,q3:0===s?t[r]:t[r|0]*(1-s)+t[1+(r|0)]*s,max:t.at(-1)}}function d(t,e){const r=t.length;let n=0,o=0,s=0,i=0,a=0;for(let l=0;l<r;l++){const r=t[l],u=e[l];n+=r,o+=r**2,s+=u,i+=u**2,a+=r*u}return(r*a-n*s)/(Math.sqrt(r*o-n**2)*Math.sqrt(r*i-s**2))}function p(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}function w(t){if(Object.prototype.hasOwnProperty.call(t,"__esModule"))return t;var e=t.default;if("function"==typeof e){var r=function t(){var r=!1;try{r=this instanceof t}catch{}return r?Reflect.construct(e,arguments,this.constructor):e.apply(this,arguments)};r.prototype=e.prototype}else r={};return Object.defineProperty(r,"__esModule",{value:!0}),Object.keys(t).forEach(function(e){var n=Object.getOwnPropertyDescriptor(t,e);Object.defineProperty(r,e,n.get?n:{enumerable:!0,get:function(){return t[e]}})}),r}var y={},b=w(Object.freeze({__proto__:null,isAnyArray:r}));var x=Object.freeze({__proto__:null,default:function(t){var e,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!r(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");if(void 0!==n.output){if(!r(n.output))throw new TypeError("output option must be an array if specified");e=n.output}else e=new Array(t.length);var o=function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!r(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");var n=e.fromIndex,o=void 0===n?0:n,s=e.toIndex,i=void 0===s?t.length:s;if(o<0||o>=t.length||!Number.isInteger(o))throw new Error("fromIndex must be a positive integer smaller than length");if(i<=o||i>t.length||!Number.isInteger(i))throw new Error("toIndex must be an integer greater than fromIndex and at most equal to length");for(var a=t[o],l=o+1;l<i;l++)t[l]<a&&(a=t[l]);return a}(t),s=function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!r(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");var n=e.fromIndex,o=void 0===n?0:n,s=e.toIndex,i=void 0===s?t.length:s;if(o<0||o>=t.length||!Number.isInteger(o))throw new Error("fromIndex must be a positive integer smaller than length");if(i<=o||i>t.length||!Number.isInteger(i))throw new Error("toIndex must be an integer greater than fromIndex and at most equal to length");for(var a=t[o],l=o+1;l<i;l++)t[l]>a&&(a=t[l]);return a}(t);if(o===s)throw new RangeError("minimum and maximum input values are equal. Cannot rescale a constant array");var i=n.min,a=void 0===i?n.autoMinMax?o:0:i,l=n.max,u=void 0===l?n.autoMinMax?s:1:l;if(a>=u)throw new RangeError("min option must be smaller than max option");for(var f=(u-a)/(s-o),c=0;c<t.length;c++)e[c]=(t[c]-o)*f+a;return e}}),v=w(x);Object.defineProperty(y,"__esModule",{value:!0});var M=b,E=v;const A=" ".repeat(2),I=" ".repeat(4);function S(t,e={}){const{maxRows:r=15,maxColumns:n=10,maxNumSize:o=8,padMinus:s="auto"}=e;return`${t.constructor.name} {\n${A}[\n${I}${function(t,e,r,n,o){const{rows:s,columns:i}=t,a=Math.min(s,e),l=Math.min(i,r),u=[];if("auto"===o){o=!1;t:for(let e=0;e<a;e++)for(let r=0;r<l;r++)if(t.get(e,r)<0){o=!0;break t}}for(let e=0;e<a;e++){let r=[];for(let s=0;s<l;s++)r.push(N(t.get(e,s),n,o));u.push(`${r.join(" ")}`)}l!==i&&(u[u.length-1]+=` ... ${i-r} more columns`);a!==s&&u.push(`... ${s-e} more rows`);return u.join(`\n${I}`)}(t,r,n,o,s)}\n${A}]\n${A}rows: ${t.rows}\n${A}columns: ${t.columns}\n}`}function N(t,e,r){return(t>=0&&r?` ${_(t,e-1)}`:_(t,e)).padEnd(e)}function _(t,e){let r=t.toString();if(r.length<=e)return r;let n=t.toFixed(e);if(n.length>e&&(n=t.toFixed(Math.max(0,e-(n.length-e)))),n.length<=e&&!n.startsWith("0.000")&&!n.startsWith("-0.000"))return n;let o=t.toExponential(e);return o.length>e&&(o=t.toExponential(Math.max(0,e-(o.length-e)))),o.slice(0)}function k(t,e,r){let n=r?t.rows:t.rows-1;if(e<0||e>n)throw new RangeError("Row index out of range")}function T(t,e,r){let n=r?t.columns:t.columns-1;if(e<0||e>n)throw new RangeError("Column index out of range")}function R(t,e){if(e.to1DArray&&(e=e.to1DArray()),e.length!==t.columns)throw new RangeError("vector size must be the same as the number of columns");return e}function C(t,e){if(e.to1DArray&&(e=e.to1DArray()),e.length!==t.rows)throw new RangeError("vector size must be the same as the number of rows");return e}function F(t,e){if(!M.isAnyArray(e))throw new TypeError("row indices must be an array");for(let r=0;r<e.length;r++)if(e[r]<0||e[r]>=t.rows)throw new RangeError("row indices are out of range")}function z(t,e){if(!M.isAnyArray(e))throw new TypeError("column indices must be an array");for(let r=0;r<e.length;r++)if(e[r]<0||e[r]>=t.columns)throw new RangeError("column indices are out of range")}function B(t,e,r,n,o){if(5!==arguments.length)throw new RangeError("expected 4 arguments");if(O("startRow",e),O("endRow",r),O("startColumn",n),O("endColumn",o),e>r||n>o||e<0||e>=t.rows||r<0||r>=t.rows||n<0||n>=t.columns||o<0||o>=t.columns)throw new RangeError("Submatrix indices are out of range")}function L(t,e=0){let r=[];for(let n=0;n<t;n++)r.push(e);return r}function O(t,e){if("number"!=typeof e)throw new TypeError(`${t} must be a number`)}function P(t){if(t.isEmpty())throw new Error("Empty matrix has no elements to index")}class ${static from1DArray(t,e,r){if(t*e!==r.length)throw new RangeError("data length does not match given dimensions");let n=new X(t,e);for(let o=0;o<t;o++)for(let t=0;t<e;t++)n.set(o,t,r[o*e+t]);return n}static rowVector(t){let e=new X(1,t.length);for(let r=0;r<t.length;r++)e.set(0,r,t[r]);return e}static columnVector(t){let e=new X(t.length,1);for(let r=0;r<t.length;r++)e.set(r,0,t[r]);return e}static zeros(t,e){return new X(t,e)}static ones(t,e){return new X(t,e).fill(1)}static rand(t,e,r={}){if("object"!=typeof r)throw new TypeError("options must be an object");const{random:n=Math.random}=r;let o=new X(t,e);for(let r=0;r<t;r++)for(let t=0;t<e;t++)o.set(r,t,n());return o}static randInt(t,e,r={}){if("object"!=typeof r)throw new TypeError("options must be an object");const{min:n=0,max:o=1e3,random:s=Math.random}=r;if(!Number.isInteger(n))throw new TypeError("min must be an integer");if(!Number.isInteger(o))throw new TypeError("max must be an integer");if(n>=o)throw new RangeError("min must be smaller than max");let i=o-n,a=new X(t,e);for(let r=0;r<t;r++)for(let t=0;t<e;t++){let e=n+Math.round(s()*i);a.set(r,t,e)}return a}static eye(t,e,r){void 0===e&&(e=t),void 0===r&&(r=1);let n=Math.min(t,e),o=this.zeros(t,e);for(let t=0;t<n;t++)o.set(t,t,r);return o}static diag(t,e,r){let n=t.length;void 0===e&&(e=n),void 0===r&&(r=e);let o=Math.min(n,e,r),s=this.zeros(e,r);for(let e=0;e<o;e++)s.set(e,e,t[e]);return s}static min(t,e){t=this.checkMatrix(t),e=this.checkMatrix(e);let r=t.rows,n=t.columns,o=new X(r,n);for(let s=0;s<r;s++)for(let r=0;r<n;r++)o.set(s,r,Math.min(t.get(s,r),e.get(s,r)));return o}static max(t,e){t=this.checkMatrix(t),e=this.checkMatrix(e);let r=t.rows,n=t.columns,o=new this(r,n);for(let s=0;s<r;s++)for(let r=0;r<n;r++)o.set(s,r,Math.max(t.get(s,r),e.get(s,r)));return o}static checkMatrix(t){return $.isMatrix(t)?t:new X(t)}static isMatrix(t){return null!=t&&"Matrix"===t.klass}get size(){return this.rows*this.columns}apply(t){if("function"!=typeof t)throw new TypeError("callback must be a function");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)t.call(this,e,r);return this}to1DArray(){let t=[];for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)t.push(this.get(e,r));return t}to2DArray(){let t=[];for(let e=0;e<this.rows;e++){t.push([]);for(let r=0;r<this.columns;r++)t[e].push(this.get(e,r))}return t}toJSON(){return this.to2DArray()}isRowVector(){return 1===this.rows}isColumnVector(){return 1===this.columns}isVector(){return 1===this.rows||1===this.columns}isSquare(){return this.rows===this.columns}isEmpty(){return 0===this.rows||0===this.columns}isSymmetric(){if(this.isSquare()){for(let t=0;t<this.rows;t++)for(let e=0;e<=t;e++)if(this.get(t,e)!==this.get(e,t))return!1;return!0}return!1}isDistance(){if(!this.isSymmetric())return!1;for(let t=0;t<this.rows;t++)if(0!==this.get(t,t))return!1;return!0}isEchelonForm(){let t=0,e=0,r=-1,n=!0,o=!1;for(;t<this.rows&&n;){for(e=0,o=!1;e<this.columns&&!1===o;)0===this.get(t,e)?e++:1===this.get(t,e)&&e>r?(o=!0,r=e):(n=!1,o=!0);t++}return n}isReducedEchelonForm(){let t=0,e=0,r=-1,n=!0,o=!1;for(;t<this.rows&&n;){for(e=0,o=!1;e<this.columns&&!1===o;)0===this.get(t,e)?e++:1===this.get(t,e)&&e>r?(o=!0,r=e):(n=!1,o=!0);for(let r=e+1;r<this.rows;r++)0!==this.get(t,r)&&(n=!1);t++}return n}echelonForm(){let t=this.clone(),e=0,r=0;for(;e<t.rows&&r<t.columns;){let n=e;for(let o=e;o<t.rows;o++)t.get(o,r)>t.get(n,r)&&(n=o);if(0===t.get(n,r))r++;else{t.swapRows(e,n);let o=t.get(e,r);for(let n=r;n<t.columns;n++)t.set(e,n,t.get(e,n)/o);for(let n=e+1;n<t.rows;n++){let o=t.get(n,r)/t.get(e,r);t.set(n,r,0);for(let s=r+1;s<t.columns;s++)t.set(n,s,t.get(n,s)-t.get(e,s)*o)}e++,r++}}return t}reducedEchelonForm(){let t=this.echelonForm(),e=t.columns,r=t.rows,n=r-1;for(;n>=0;)if(0===t.maxRow(n))n--;else{let o=0,s=!1;for(;o<r&&!1===s;)1===t.get(n,o)?s=!0:o++;for(let r=0;r<n;r++){let s=t.get(r,o);for(let i=o;i<e;i++){let e=t.get(r,i)-s*t.get(n,i);t.set(r,i,e)}}n--}return t}set(){throw new Error("set method is unimplemented")}get(){throw new Error("get method is unimplemented")}repeat(t={}){if("object"!=typeof t)throw new TypeError("options must be an object");const{rows:e=1,columns:r=1}=t;if(!Number.isInteger(e)||e<=0)throw new TypeError("rows must be a positive integer");if(!Number.isInteger(r)||r<=0)throw new TypeError("columns must be a positive integer");let n=new X(this.rows*e,this.columns*r);for(let t=0;t<e;t++)for(let e=0;e<r;e++)n.setSubMatrix(this,this.rows*t,this.columns*e);return n}fill(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,t);return this}neg(){return this.mulS(-1)}getRow(t){k(this,t);let e=[];for(let r=0;r<this.columns;r++)e.push(this.get(t,r));return e}getRowVector(t){return X.rowVector(this.getRow(t))}setRow(t,e){k(this,t),e=R(this,e);for(let r=0;r<this.columns;r++)this.set(t,r,e[r]);return this}swapRows(t,e){k(this,t),k(this,e);for(let r=0;r<this.columns;r++){let n=this.get(t,r);this.set(t,r,this.get(e,r)),this.set(e,r,n)}return this}getColumn(t){T(this,t);let e=[];for(let r=0;r<this.rows;r++)e.push(this.get(r,t));return e}getColumnVector(t){return X.columnVector(this.getColumn(t))}setColumn(t,e){T(this,t),e=C(this,e);for(let r=0;r<this.rows;r++)this.set(r,t,e[r]);return this}swapColumns(t,e){T(this,t),T(this,e);for(let r=0;r<this.rows;r++){let n=this.get(r,t);this.set(r,t,this.get(r,e)),this.set(r,e,n)}return this}addRowVector(t){t=R(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)+t[r]);return this}subRowVector(t){t=R(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)-t[r]);return this}mulRowVector(t){t=R(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)*t[r]);return this}divRowVector(t){t=R(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)/t[r]);return this}addColumnVector(t){t=C(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)+t[e]);return this}subColumnVector(t){t=C(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)-t[e]);return this}mulColumnVector(t){t=C(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)*t[e]);return this}divColumnVector(t){t=C(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)/t[e]);return this}mulRow(t,e){k(this,t);for(let r=0;r<this.columns;r++)this.set(t,r,this.get(t,r)*e);return this}mulColumn(t,e){T(this,t);for(let r=0;r<this.rows;r++)this.set(r,t,this.get(r,t)*e);return this}max(t){if(this.isEmpty())return NaN;switch(t){case"row":{const t=new Array(this.rows).fill(Number.NEGATIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.get(e,r)>t[e]&&(t[e]=this.get(e,r));return t}case"column":{const t=new Array(this.columns).fill(Number.NEGATIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.get(e,r)>t[r]&&(t[r]=this.get(e,r));return t}case void 0:{let t=this.get(0,0);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.get(e,r)>t&&(t=this.get(e,r));return t}default:throw new Error(`invalid option: ${t}`)}}maxIndex(){P(this);let t=this.get(0,0),e=[0,0];for(let r=0;r<this.rows;r++)for(let n=0;n<this.columns;n++)this.get(r,n)>t&&(t=this.get(r,n),e[0]=r,e[1]=n);return e}min(t){if(this.isEmpty())return NaN;switch(t){case"row":{const t=new Array(this.rows).fill(Number.POSITIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.get(e,r)<t[e]&&(t[e]=this.get(e,r));return t}case"column":{const t=new Array(this.columns).fill(Number.POSITIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.get(e,r)<t[r]&&(t[r]=this.get(e,r));return t}case void 0:{let t=this.get(0,0);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.get(e,r)<t&&(t=this.get(e,r));return t}default:throw new Error(`invalid option: ${t}`)}}minIndex(){P(this);let t=this.get(0,0),e=[0,0];for(let r=0;r<this.rows;r++)for(let n=0;n<this.columns;n++)this.get(r,n)<t&&(t=this.get(r,n),e[0]=r,e[1]=n);return e}maxRow(t){if(k(this,t),this.isEmpty())return NaN;let e=this.get(t,0);for(let r=1;r<this.columns;r++)this.get(t,r)>e&&(e=this.get(t,r));return e}maxRowIndex(t){k(this,t),P(this);let e=this.get(t,0),r=[t,0];for(let n=1;n<this.columns;n++)this.get(t,n)>e&&(e=this.get(t,n),r[1]=n);return r}minRow(t){if(k(this,t),this.isEmpty())return NaN;let e=this.get(t,0);for(let r=1;r<this.columns;r++)this.get(t,r)<e&&(e=this.get(t,r));return e}minRowIndex(t){k(this,t),P(this);let e=this.get(t,0),r=[t,0];for(let n=1;n<this.columns;n++)this.get(t,n)<e&&(e=this.get(t,n),r[1]=n);return r}maxColumn(t){if(T(this,t),this.isEmpty())return NaN;let e=this.get(0,t);for(let r=1;r<this.rows;r++)this.get(r,t)>e&&(e=this.get(r,t));return e}maxColumnIndex(t){T(this,t),P(this);let e=this.get(0,t),r=[0,t];for(let n=1;n<this.rows;n++)this.get(n,t)>e&&(e=this.get(n,t),r[0]=n);return r}minColumn(t){if(T(this,t),this.isEmpty())return NaN;let e=this.get(0,t);for(let r=1;r<this.rows;r++)this.get(r,t)<e&&(e=this.get(r,t));return e}minColumnIndex(t){T(this,t),P(this);let e=this.get(0,t),r=[0,t];for(let n=1;n<this.rows;n++)this.get(n,t)<e&&(e=this.get(n,t),r[0]=n);return r}diag(){let t=Math.min(this.rows,this.columns),e=[];for(let r=0;r<t;r++)e.push(this.get(r,r));return e}norm(t="frobenius"){switch(t){case"max":return this.max();case"frobenius":return Math.sqrt(this.dot(this));default:throw new RangeError(`unknown norm type: ${t}`)}}cumulativeSum(){let t=0;for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)t+=this.get(e,r),this.set(e,r,t);return this}dot(t){$.isMatrix(t)&&(t=t.to1DArray());let e=this.to1DArray();if(e.length!==t.length)throw new RangeError("vectors do not have the same size");let r=0;for(let n=0;n<e.length;n++)r+=e[n]*t[n];return r}mmul(t){t=X.checkMatrix(t);let e=this.rows,r=this.columns,n=t.columns,o=new X(e,n),s=new Float64Array(r);for(let i=0;i<n;i++){for(let e=0;e<r;e++)s[e]=t.get(e,i);for(let t=0;t<e;t++){let e=0;for(let n=0;n<r;n++)e+=this.get(t,n)*s[n];o.set(t,i,e)}}return o}mpow(t){if(!this.isSquare())throw new RangeError("Matrix must be square");if(!Number.isInteger(t)||t<0)throw new RangeError("Exponent must be a non-negative integer");let e=X.eye(this.rows),r=this;for(let n=t;n>=1;n/=2)1&n&&(e=e.mmul(r)),r=r.mmul(r);return e}strassen2x2(t){t=X.checkMatrix(t);let e=new X(2,2);const r=this.get(0,0),n=t.get(0,0),o=this.get(0,1),s=t.get(0,1),i=this.get(1,0),a=t.get(1,0),l=this.get(1,1),u=t.get(1,1),f=(r+l)*(n+u),c=(i+l)*n,h=r*(s-u),m=l*(a-n),g=(r+o)*u,d=f+m-g+(o-l)*(a+u),p=h+g,w=c+m,y=f-c+h+(i-r)*(n+s);return e.set(0,0,d),e.set(0,1,p),e.set(1,0,w),e.set(1,1,y),e}strassen3x3(t){t=X.checkMatrix(t);let e=new X(3,3);const r=this.get(0,0),n=this.get(0,1),o=this.get(0,2),s=this.get(1,0),i=this.get(1,1),a=this.get(1,2),l=this.get(2,0),u=this.get(2,1),f=this.get(2,2),c=t.get(0,0),h=t.get(0,1),m=t.get(0,2),g=t.get(1,0),d=t.get(1,1),p=t.get(1,2),w=t.get(2,0),y=t.get(2,1),b=t.get(2,2),x=(r-s)*(-h+d),v=(-r+s+i)*(c-h+d),M=(s+i)*(-c+h),E=r*c,A=(-r+l+u)*(c-m+p),I=(-r+l)*(m-p),S=(l+u)*(-c+m),N=(-o+u+f)*(d+w-y),_=(o-f)*(d-y),k=o*w,T=(u+f)*(-w+y),R=(-o+i+a)*(p+w-b),C=(o-a)*(p-b),F=(i+a)*(-w+b),z=E+k+n*g,B=(r+n+o-s-i-u-f)*d+v+M+E+N+k+T,L=E+A+S+(r+n+o-i-a-l-u)*p+k+R+F,O=x+i*(-c+h+g-d-p-w+b)+v+E+k+R+C,P=x+v+M+E+a*y,$=k+R+C+F+s*m,j=E+A+I+u*(-c+m+g-d-p-w+y)+N+_+k,D=N+_+k+T+l*h,Y=E+A+I+S+f*b;return e.set(0,0,z),e.set(0,1,B),e.set(0,2,L),e.set(1,0,O),e.set(1,1,P),e.set(1,2,$),e.set(2,0,j),e.set(2,1,D),e.set(2,2,Y),e}mmulStrassen(t){t=X.checkMatrix(t);let e=this.clone(),r=e.rows,n=e.columns,o=t.rows,s=t.columns;function i(t,e,r){let n=t.rows,o=t.columns;if(n===e&&o===r)return t;{let n=$.zeros(e,r);return n=n.setSubMatrix(t,0,0),n}}n!==o&&console.warn(`Multiplying ${r} x ${n} and ${o} x ${s} matrix: dimensions do not match.`);let a=Math.max(r,o),l=Math.max(n,s);return e=i(e,a,l),function t(e,r,n,o){if(n<=512||o<=512)return e.mmul(r);n%2==1&&o%2==1?(e=i(e,n+1,o+1),r=i(r,n+1,o+1)):n%2==1?(e=i(e,n+1,o),r=i(r,n+1,o)):o%2==1&&(e=i(e,n,o+1),r=i(r,n,o+1));let s=parseInt(e.rows/2,10),a=parseInt(e.columns/2,10),l=e.subMatrix(0,s-1,0,a-1),u=r.subMatrix(0,s-1,0,a-1),f=e.subMatrix(0,s-1,a,e.columns-1),c=r.subMatrix(0,s-1,a,r.columns-1),h=e.subMatrix(s,e.rows-1,0,a-1),m=r.subMatrix(s,r.rows-1,0,a-1),g=e.subMatrix(s,e.rows-1,a,e.columns-1),d=r.subMatrix(s,r.rows-1,a,r.columns-1),p=t($.add(l,g),$.add(u,d),s,a),w=t($.add(h,g),u,s,a),y=t(l,$.sub(c,d),s,a),b=t(g,$.sub(m,u),s,a),x=t($.add(l,f),d,s,a),v=t($.sub(h,l),$.add(u,c),s,a),M=t($.sub(f,g),$.add(m,d),s,a),E=$.add(p,b);E.sub(x),E.add(M);let A=$.add(y,x),I=$.add(w,b),S=$.sub(p,w);S.add(y),S.add(v);let N=$.zeros(2*E.rows,2*E.columns);return N=N.setSubMatrix(E,0,0),N=N.setSubMatrix(A,E.rows,0),N=N.setSubMatrix(I,0,E.columns),N=N.setSubMatrix(S,E.rows,E.columns),N.subMatrix(0,n-1,0,o-1)}(e,t=i(t,a,l),a,l)}scaleRows(t={}){if("object"!=typeof t)throw new TypeError("options must be an object");const{min:e=0,max:r=1}=t;if(!Number.isFinite(e))throw new TypeError("min must be a number");if(!Number.isFinite(r))throw new TypeError("max must be a number");if(e>=r)throw new RangeError("min must be smaller than max");let n=new X(this.rows,this.columns);for(let t=0;t<this.rows;t++){const o=this.getRow(t);o.length>0&&E(o,{min:e,max:r,output:o}),n.setRow(t,o)}return n}scaleColumns(t={}){if("object"!=typeof t)throw new TypeError("options must be an object");const{min:e=0,max:r=1}=t;if(!Number.isFinite(e))throw new TypeError("min must be a number");if(!Number.isFinite(r))throw new TypeError("max must be a number");if(e>=r)throw new RangeError("min must be smaller than max");let n=new X(this.rows,this.columns);for(let t=0;t<this.columns;t++){const o=this.getColumn(t);o.length&&E(o,{min:e,max:r,output:o}),n.setColumn(t,o)}return n}flipRows(){const t=Math.ceil(this.columns/2);for(let e=0;e<this.rows;e++)for(let r=0;r<t;r++){let t=this.get(e,r),n=this.get(e,this.columns-1-r);this.set(e,r,n),this.set(e,this.columns-1-r,t)}return this}flipColumns(){const t=Math.ceil(this.rows/2);for(let e=0;e<this.columns;e++)for(let r=0;r<t;r++){let t=this.get(r,e),n=this.get(this.rows-1-r,e);this.set(r,e,n),this.set(this.rows-1-r,e,t)}return this}kroneckerProduct(t){t=X.checkMatrix(t);let e=this.rows,r=this.columns,n=t.rows,o=t.columns,s=new X(e*n,r*o);for(let i=0;i<e;i++)for(let e=0;e<r;e++)for(let r=0;r<n;r++)for(let a=0;a<o;a++)s.set(n*i+r,o*e+a,this.get(i,e)*t.get(r,a));return s}kroneckerSum(t){if(t=X.checkMatrix(t),!this.isSquare()||!t.isSquare())throw new Error("Kronecker Sum needs two Square Matrices");let e=this.rows,r=t.rows,n=this.kroneckerProduct(X.eye(r,r)),o=X.eye(e,e).kroneckerProduct(t);return n.add(o)}transpose(){let t=new X(this.columns,this.rows);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)t.set(r,e,this.get(e,r));return t}sortRows(t=j){for(let e=0;e<this.rows;e++)this.setRow(e,this.getRow(e).sort(t));return this}sortColumns(t=j){for(let e=0;e<this.columns;e++)this.setColumn(e,this.getColumn(e).sort(t));return this}subMatrix(t,e,r,n){B(this,t,e,r,n);let o=new X(e-t+1,n-r+1);for(let s=t;s<=e;s++)for(let e=r;e<=n;e++)o.set(s-t,e-r,this.get(s,e));return o}subMatrixRow(t,e,r){if(void 0===e&&(e=0),void 0===r&&(r=this.columns-1),e>r||e<0||e>=this.columns||r<0||r>=this.columns)throw new RangeError("Argument out of range");let n=new X(t.length,r-e+1);for(let o=0;o<t.length;o++)for(let s=e;s<=r;s++){if(t[o]<0||t[o]>=this.rows)throw new RangeError(`Row index out of range: ${t[o]}`);n.set(o,s-e,this.get(t[o],s))}return n}subMatrixColumn(t,e,r){if(void 0===e&&(e=0),void 0===r&&(r=this.rows-1),e>r||e<0||e>=this.rows||r<0||r>=this.rows)throw new RangeError("Argument out of range");let n=new X(r-e+1,t.length);for(let o=0;o<t.length;o++)for(let s=e;s<=r;s++){if(t[o]<0||t[o]>=this.columns)throw new RangeError(`Column index out of range: ${t[o]}`);n.set(s-e,o,this.get(s,t[o]))}return n}setSubMatrix(t,e,r){if((t=X.checkMatrix(t)).isEmpty())return this;B(this,e,e+t.rows-1,r,r+t.columns-1);for(let n=0;n<t.rows;n++)for(let o=0;o<t.columns;o++)this.set(e+n,r+o,t.get(n,o));return this}selection(t,e){F(this,t),z(this,e);let r=new X(t.length,e.length);for(let n=0;n<t.length;n++){let o=t[n];for(let t=0;t<e.length;t++){let s=e[t];r.set(n,t,this.get(o,s))}}return r}trace(){let t=Math.min(this.rows,this.columns),e=0;for(let r=0;r<t;r++)e+=this.get(r,r);return e}clone(){return this.constructor.copy(this,new X(this.rows,this.columns))}static copy(t,e){for(const[r,n,o]of t.entries())e.set(r,n,o);return e}sum(t){switch(t){case"row":return function(t){let e=L(t.rows);for(let r=0;r<t.rows;++r)for(let n=0;n<t.columns;++n)e[r]+=t.get(r,n);return e}(this);case"column":return function(t){let e=L(t.columns);for(let r=0;r<t.rows;++r)for(let n=0;n<t.columns;++n)e[n]+=t.get(r,n);return e}(this);case void 0:return function(t){let e=0;for(let r=0;r<t.rows;r++)for(let n=0;n<t.columns;n++)e+=t.get(r,n);return e}(this);default:throw new Error(`invalid option: ${t}`)}}product(t){switch(t){case"row":return function(t){let e=L(t.rows,1);for(let r=0;r<t.rows;++r)for(let n=0;n<t.columns;++n)e[r]*=t.get(r,n);return e}(this);case"column":return function(t){let e=L(t.columns,1);for(let r=0;r<t.rows;++r)for(let n=0;n<t.columns;++n)e[n]*=t.get(r,n);return e}(this);case void 0:return function(t){let e=1;for(let r=0;r<t.rows;r++)for(let n=0;n<t.columns;n++)e*=t.get(r,n);return e}(this);default:throw new Error(`invalid option: ${t}`)}}mean(t){const e=this.sum(t);switch(t){case"row":for(let t=0;t<this.rows;t++)e[t]/=this.columns;return e;case"column":for(let t=0;t<this.columns;t++)e[t]/=this.rows;return e;case void 0:return e/this.size;default:throw new Error(`invalid option: ${t}`)}}variance(t,e={}){if("object"==typeof t&&(e=t,t=void 0),"object"!=typeof e)throw new TypeError("options must be an object");const{unbiased:r=!0,mean:n=this.mean(t)}=e;if("boolean"!=typeof r)throw new TypeError("unbiased must be a boolean");switch(t){case"row":if(!M.isAnyArray(n))throw new TypeError("mean must be an array");return function(t,e,r){const n=t.rows,o=t.columns,s=[];for(let i=0;i<n;i++){let n=0,a=0,l=0;for(let e=0;e<o;e++)l=t.get(i,e)-r[i],n+=l,a+=l*l;e?s.push((a-n*n/o)/(o-1)):s.push((a-n*n/o)/o)}return s}(this,r,n);case"column":if(!M.isAnyArray(n))throw new TypeError("mean must be an array");return function(t,e,r){const n=t.rows,o=t.columns,s=[];for(let i=0;i<o;i++){let o=0,a=0,l=0;for(let e=0;e<n;e++)l=t.get(e,i)-r[i],o+=l,a+=l*l;e?s.push((a-o*o/n)/(n-1)):s.push((a-o*o/n)/n)}return s}(this,r,n);case void 0:if("number"!=typeof n)throw new TypeError("mean must be a number");return function(t,e,r){const n=t.rows,o=t.columns,s=n*o;let i=0,a=0,l=0;for(let e=0;e<n;e++)for(let n=0;n<o;n++)l=t.get(e,n)-r,i+=l,a+=l*l;return e?(a-i*i/s)/(s-1):(a-i*i/s)/s}(this,r,n);default:throw new Error(`invalid option: ${t}`)}}standardDeviation(t,e){"object"==typeof t&&(e=t,t=void 0);const r=this.variance(t,e);if(void 0===t)return Math.sqrt(r);for(let t=0;t<r.length;t++)r[t]=Math.sqrt(r[t]);return r}center(t,e={}){if("object"==typeof t&&(e=t,t=void 0),"object"!=typeof e)throw new TypeError("options must be an object");const{center:r=this.mean(t)}=e;switch(t){case"row":if(!M.isAnyArray(r))throw new TypeError("center must be an array");return function(t,e){for(let r=0;r<t.rows;r++)for(let n=0;n<t.columns;n++)t.set(r,n,t.get(r,n)-e[r])}(this,r),this;case"column":if(!M.isAnyArray(r))throw new TypeError("center must be an array");return function(t,e){for(let r=0;r<t.rows;r++)for(let n=0;n<t.columns;n++)t.set(r,n,t.get(r,n)-e[n])}(this,r),this;case void 0:if("number"!=typeof r)throw new TypeError("center must be a number");return function(t,e){for(let r=0;r<t.rows;r++)for(let n=0;n<t.columns;n++)t.set(r,n,t.get(r,n)-e)}(this,r),this;default:throw new Error(`invalid option: ${t}`)}}scale(t,e={}){if("object"==typeof t&&(e=t,t=void 0),"object"!=typeof e)throw new TypeError("options must be an object");let r=e.scale;switch(t){case"row":if(void 0===r)r=function(t){const e=[];for(let r=0;r<t.rows;r++){let n=0;for(let e=0;e<t.columns;e++)n+=t.get(r,e)**2/(t.columns-1);e.push(Math.sqrt(n))}return e}(this);else if(!M.isAnyArray(r))throw new TypeError("scale must be an array");return function(t,e){for(let r=0;r<t.rows;r++)for(let n=0;n<t.columns;n++)t.set(r,n,t.get(r,n)/e[r])}(this,r),this;case"column":if(void 0===r)r=function(t){const e=[];for(let r=0;r<t.columns;r++){let n=0;for(let e=0;e<t.rows;e++)n+=t.get(e,r)**2/(t.rows-1);e.push(Math.sqrt(n))}return e}(this);else if(!M.isAnyArray(r))throw new TypeError("scale must be an array");return function(t,e){for(let r=0;r<t.rows;r++)for(let n=0;n<t.columns;n++)t.set(r,n,t.get(r,n)/e[n])}(this,r),this;case void 0:if(void 0===r)r=function(t){const e=t.size-1;let r=0;for(let n=0;n<t.columns;n++)for(let o=0;o<t.rows;o++)r+=t.get(o,n)**2/e;return Math.sqrt(r)}(this);else if("number"!=typeof r)throw new TypeError("scale must be a number");return function(t,e){for(let r=0;r<t.rows;r++)for(let n=0;n<t.columns;n++)t.set(r,n,t.get(r,n)/e)}(this,r),this;default:throw new Error(`invalid option: ${t}`)}}toString(t){return S(this,t)}[Symbol.iterator](){return this.entries()}*entries(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)yield[t,e,this.get(t,e)]}*values(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)yield this.get(t,e)}}function j(t,e){return t-e}function D(t){return t.every(t=>"number"==typeof t)}$.prototype.klass="Matrix","undefined"!=typeof Symbol&&($.prototype[Symbol.for("nodejs.util.inspect.custom")]=function(){return S(this)}),$.random=$.rand,$.randomInt=$.randInt,$.diagonal=$.diag,$.prototype.diagonal=$.prototype.diag,$.identity=$.eye,$.prototype.negate=$.prototype.neg,$.prototype.tensorProduct=$.prototype.kroneckerProduct;let X=class t extends ${data;#t(t,e){if(this.data=[],!(Number.isInteger(e)&&e>=0))throw new TypeError("nColumns must be a positive integer");for(let r=0;r<t;r++)this.data.push(new Float64Array(e));this.rows=t,this.columns=e}constructor(e,r){if(super(),t.isMatrix(e))this.#t(e.rows,e.columns),t.copy(e,this);else if(Number.isInteger(e)&&e>=0)this.#t(e,r);else{if(!M.isAnyArray(e))throw new TypeError("First argument must be a positive number or an array");{const t=e;if("number"!=typeof(r=(e=t.length)?t[0].length:0))throw new TypeError("Data must be a 2D array with at least one element");this.data=[];for(let n=0;n<e;n++){if(t[n].length!==r)throw new RangeError("Inconsistent array dimensions");if(!D(t[n]))throw new TypeError("Input data contains non-numeric values");this.data.push(Float64Array.from(t[n]))}this.rows=e,this.columns=r}}}set(t,e,r){return this.data[t][e]=r,this}get(t,e){return this.data[t][e]}removeRow(t){return k(this,t),this.data.splice(t,1),this.rows-=1,this}addRow(t,e){return void 0===e&&(e=t,t=this.rows),k(this,t,!0),e=Float64Array.from(R(this,e)),this.data.splice(t,0,e),this.rows+=1,this}removeColumn(t){T(this,t);for(let e=0;e<this.rows;e++){const r=new Float64Array(this.columns-1);for(let n=0;n<t;n++)r[n]=this.data[e][n];for(let n=t+1;n<this.columns;n++)r[n-1]=this.data[e][n];this.data[e]=r}return this.columns-=1,this}addColumn(t,e){void 0===e&&(e=t,t=this.columns),T(this,t,!0),e=C(this,e);for(let r=0;r<this.rows;r++){const n=new Float64Array(this.columns+1);let o=0;for(;o<t;o++)n[o]=this.data[r][o];for(n[o++]=e[r];o<this.columns+1;o++)n[o]=this.data[r][o-1];this.data[r]=n}return this.columns+=1,this}};!function(t,e){t.prototype.add=function(t){return"number"==typeof t?this.addS(t):this.addM(t)},t.prototype.addS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)+t);return this},t.prototype.addM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)+t.get(e,r));return this},t.add=function(t,r){return new e(t).add(r)},t.prototype.sub=function(t){return"number"==typeof t?this.subS(t):this.subM(t)},t.prototype.subS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)-t);return this},t.prototype.subM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)-t.get(e,r));return this},t.sub=function(t,r){return new e(t).sub(r)},t.prototype.subtract=t.prototype.sub,t.prototype.subtractS=t.prototype.subS,t.prototype.subtractM=t.prototype.subM,t.subtract=t.sub,t.prototype.mul=function(t){return"number"==typeof t?this.mulS(t):this.mulM(t)},t.prototype.mulS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)*t);return this},t.prototype.mulM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)*t.get(e,r));return this},t.mul=function(t,r){return new e(t).mul(r)},t.prototype.multiply=t.prototype.mul,t.prototype.multiplyS=t.prototype.mulS,t.prototype.multiplyM=t.prototype.mulM,t.multiply=t.mul,t.prototype.div=function(t){return"number"==typeof t?this.divS(t):this.divM(t)},t.prototype.divS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)/t);return this},t.prototype.divM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)/t.get(e,r));return this},t.div=function(t,r){return new e(t).div(r)},t.prototype.divide=t.prototype.div,t.prototype.divideS=t.prototype.divS,t.prototype.divideM=t.prototype.divM,t.divide=t.div,t.prototype.mod=function(t){return"number"==typeof t?this.modS(t):this.modM(t)},t.prototype.modS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)%t);return this},t.prototype.modM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)%t.get(e,r));return this},t.mod=function(t,r){return new e(t).mod(r)},t.prototype.modulus=t.prototype.mod,t.prototype.modulusS=t.prototype.modS,t.prototype.modulusM=t.prototype.modM,t.modulus=t.mod,t.prototype.and=function(t){return"number"==typeof t?this.andS(t):this.andM(t)},t.prototype.andS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)&t);return this},t.prototype.andM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)&t.get(e,r));return this},t.and=function(t,r){return new e(t).and(r)},t.prototype.or=function(t){return"number"==typeof t?this.orS(t):this.orM(t)},t.prototype.orS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)|t);return this},t.prototype.orM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)|t.get(e,r));return this},t.or=function(t,r){return new e(t).or(r)},t.prototype.xor=function(t){return"number"==typeof t?this.xorS(t):this.xorM(t)},t.prototype.xorS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)^t);return this},t.prototype.xorM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)^t.get(e,r));return this},t.xor=function(t,r){return new e(t).xor(r)},t.prototype.leftShift=function(t){return"number"==typeof t?this.leftShiftS(t):this.leftShiftM(t)},t.prototype.leftShiftS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)<<t);return this},t.prototype.leftShiftM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)<<t.get(e,r));return this},t.leftShift=function(t,r){return new e(t).leftShift(r)},t.prototype.signPropagatingRightShift=function(t){return"number"==typeof t?this.signPropagatingRightShiftS(t):this.signPropagatingRightShiftM(t)},t.prototype.signPropagatingRightShiftS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)>>t);return this},t.prototype.signPropagatingRightShiftM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)>>t.get(e,r));return this},t.signPropagatingRightShift=function(t,r){return new e(t).signPropagatingRightShift(r)},t.prototype.rightShift=function(t){return"number"==typeof t?this.rightShiftS(t):this.rightShiftM(t)},t.prototype.rightShiftS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)>>>t);return this},t.prototype.rightShiftM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)>>>t.get(e,r));return this},t.rightShift=function(t,r){return new e(t).rightShift(r)},t.prototype.zeroFillRightShift=t.prototype.rightShift,t.prototype.zeroFillRightShiftS=t.prototype.rightShiftS,t.prototype.zeroFillRightShiftM=t.prototype.rightShiftM,t.zeroFillRightShift=t.rightShift,t.prototype.not=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,~this.get(t,e));return this},t.not=function(t){return new e(t).not()},t.prototype.abs=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.abs(this.get(t,e)));return this},t.abs=function(t){return new e(t).abs()},t.prototype.acos=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.acos(this.get(t,e)));return this},t.acos=function(t){return new e(t).acos()},t.prototype.acosh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.acosh(this.get(t,e)));return this},t.acosh=function(t){return new e(t).acosh()},t.prototype.asin=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.asin(this.get(t,e)));return this},t.asin=function(t){return new e(t).asin()},t.prototype.asinh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.asinh(this.get(t,e)));return this},t.asinh=function(t){return new e(t).asinh()},t.prototype.atan=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.atan(this.get(t,e)));return this},t.atan=function(t){return new e(t).atan()},t.prototype.atanh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.atanh(this.get(t,e)));return this},t.atanh=function(t){return new e(t).atanh()},t.prototype.cbrt=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.cbrt(this.get(t,e)));return this},t.cbrt=function(t){return new e(t).cbrt()},t.prototype.ceil=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.ceil(this.get(t,e)));return this},t.ceil=function(t){return new e(t).ceil()},t.prototype.clz32=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.clz32(this.get(t,e)));return this},t.clz32=function(t){return new e(t).clz32()},t.prototype.cos=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.cos(this.get(t,e)));return this},t.cos=function(t){return new e(t).cos()},t.prototype.cosh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.cosh(this.get(t,e)));return this},t.cosh=function(t){return new e(t).cosh()},t.prototype.exp=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.exp(this.get(t,e)));return this},t.exp=function(t){return new e(t).exp()},t.prototype.expm1=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.expm1(this.get(t,e)));return this},t.expm1=function(t){return new e(t).expm1()},t.prototype.floor=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.floor(this.get(t,e)));return this},t.floor=function(t){return new e(t).floor()},t.prototype.fround=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.fround(this.get(t,e)));return this},t.fround=function(t){return new e(t).fround()},t.prototype.log=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log(this.get(t,e)));return this},t.log=function(t){return new e(t).log()},t.prototype.log1p=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log1p(this.get(t,e)));return this},t.log1p=function(t){return new e(t).log1p()},t.prototype.log10=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log10(this.get(t,e)));return this},t.log10=function(t){return new e(t).log10()},t.prototype.log2=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log2(this.get(t,e)));return this},t.log2=function(t){return new e(t).log2()},t.prototype.round=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.round(this.get(t,e)));return this},t.round=function(t){return new e(t).round()},t.prototype.sign=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sign(this.get(t,e)));return this},t.sign=function(t){return new e(t).sign()},t.prototype.sin=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sin(this.get(t,e)));return this},t.sin=function(t){return new e(t).sin()},t.prototype.sinh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sinh(this.get(t,e)));return this},t.sinh=function(t){return new e(t).sinh()},t.prototype.sqrt=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sqrt(this.get(t,e)));return this},t.sqrt=function(t){return new e(t).sqrt()},t.prototype.tan=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.tan(this.get(t,e)));return this},t.tan=function(t){return new e(t).tan()},t.prototype.tanh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.tanh(this.get(t,e)));return this},t.tanh=function(t){return new e(t).tanh()},t.prototype.trunc=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.trunc(this.get(t,e)));return this},t.trunc=function(t){return new e(t).trunc()},t.pow=function(t,r){return new e(t).pow(r)},t.prototype.pow=function(t){return"number"==typeof t?this.powS(t):this.powM(t)},t.prototype.powS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)**t);return this},t.prototype.powM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)**t.get(e,r));return this}}($,X);class Y extends ${#e;get size(){return this.#e.size}get rows(){return this.#e.rows}get columns(){return this.#e.columns}get diagonalSize(){return this.rows}static isSymmetricMatrix(t){return X.isMatrix(t)&&"SymmetricMatrix"===t.klassType}static zeros(t){return new this(t)}static ones(t){return new this(t).fill(1)}constructor(t){if(super(),X.isMatrix(t)){if(!t.isSymmetric())throw new TypeError("not symmetric data");this.#e=X.copy(t,new X(t.rows,t.rows))}else if(Number.isInteger(t)&&t>=0)this.#e=new X(t,t);else if(this.#e=new X(t),!this.isSymmetric())throw new TypeError("not symmetric data")}clone(){const t=new Y(this.diagonalSize);for(const[e,r,n]of this.upperRightEntries())t.set(e,r,n);return t}toMatrix(){return new X(this)}get(t,e){return this.#e.get(t,e)}set(t,e,r){return this.#e.set(t,e,r),this.#e.set(e,t,r),this}removeCross(t){return this.#e.removeRow(t),this.#e.removeColumn(t),this}addCross(t,e){void 0===e&&(e=t,t=this.diagonalSize);const r=e.slice();return r.splice(t,1),this.#e.addRow(t,r),this.#e.addColumn(t,e),this}applyMask(t){if(t.length!==this.diagonalSize)throw new RangeError("Mask size do not match with matrix size");const e=[];for(const[r,n]of t.entries())n||e.push(r);e.reverse();for(const t of e)this.removeCross(t);return this}toCompact(){const{diagonalSize:t}=this,e=new Array(t*(t+1)/2);for(let r=0,n=0,o=0;o<e.length;o++)e[o]=this.get(n,r),++r>=t&&(r=++n);return e}static fromCompact(t){const e=t.length,r=(Math.sqrt(8*e+1)-1)/2;if(!Number.isInteger(r))throw new TypeError(`This array is not a compact representation of a Symmetric Matrix, ${JSON.stringify(t)}`);const n=new Y(r);for(let o=0,s=0,i=0;i<e;i++)n.set(o,s,t[i]),++o>=r&&(o=++s);return n}*upperRightEntries(){for(let t=0,e=0;t<this.diagonalSize;void 0){const r=this.get(t,e);yield[t,e,r],++e>=this.diagonalSize&&(e=++t)}}*upperRightValues(){for(let t=0,e=0;t<this.diagonalSize;void 0){const r=this.get(t,e);yield r,++e>=this.diagonalSize&&(e=++t)}}}Y.prototype.klassType="SymmetricMatrix";class U extends Y{static isDistanceMatrix(t){return Y.isSymmetricMatrix(t)&&"DistanceMatrix"===t.klassSubType}constructor(t){if(super(t),!this.isDistance())throw new TypeError("Provided arguments do no produce a distance matrix")}set(t,e,r){return t===e&&(r=0),super.set(t,e,r)}addCross(t,e){return void 0===e&&(e=t,t=this.diagonalSize),(e=e.slice())[t]=0,super.addCross(t,e)}toSymmetricMatrix(){return new Y(this)}clone(){const t=new U(this.diagonalSize);for(const[e,r,n]of this.upperRightEntries())e!==r&&t.set(e,r,n);return t}toCompact(){const{diagonalSize:t}=this,e=new Array((t-1)*t/2);for(let r=1,n=0,o=0;o<e.length;o++)e[o]=this.get(n,r),++r>=t&&(r=1+ ++n);return e}static fromCompact(t){const e=t.length;if(0===e)return new this(0);const r=(Math.sqrt(8*e+1)+1)/2;if(!Number.isInteger(r))throw new TypeError(`This array is not a compact representation of a DistanceMatrix, ${JSON.stringify(t)}`);const n=new this(r);for(let o=1,s=0,i=0;i<e;i++)n.set(o,s,t[i]),++o>=r&&(o=1+ ++s);return n}}U.prototype.klassSubType="DistanceMatrix";class V extends ${constructor(t,e,r){super(),this.matrix=t,this.rows=e,this.columns=r}}class q extends V{constructor(t,e,r){F(t,e),z(t,r),super(t,e.length,r.length),this.rowIndices=e,this.columnIndices=r}set(t,e,r){return this.matrix.set(this.rowIndices[t],this.columnIndices[e],r),this}get(t,e){return this.matrix.get(this.rowIndices[t],this.columnIndices[e])}}class G extends ${constructor(t,e={}){const{rows:r=1}=e;if(t.length%r!==0)throw new Error("the data length is not divisible by the number of rows");super(),this.rows=r,this.columns=t.length/r,this.data=t}set(t,e,r){let n=this._calculateIndex(t,e);return this.data[n]=r,this}get(t,e){let r=this._calculateIndex(t,e);return this.data[r]}_calculateIndex(t,e){return t*this.columns+e}}class W extends ${constructor(t){super(),this.data=t,this.rows=t.length,this.columns=t[0].length}set(t,e,r){return this.data[t][e]=r,this}get(t,e){return this.data[t][e]}}class H{constructor(t){let e,r,n,o,s,i,a,l,u,f=(t=W.checkMatrix(t)).clone(),c=f.rows,h=f.columns,m=new Float64Array(c),g=1;for(e=0;e<c;e++)m[e]=e;for(l=new Float64Array(c),r=0;r<h;r++){for(e=0;e<c;e++)l[e]=f.get(e,r);for(e=0;e<c;e++){for(u=Math.min(e,r),s=0,n=0;n<u;n++)s+=f.get(e,n)*l[n];l[e]-=s,f.set(e,r,l[e])}for(o=r,e=r+1;e<c;e++)Math.abs(l[e])>Math.abs(l[o])&&(o=e);if(o!==r){for(n=0;n<h;n++)i=f.get(o,n),f.set(o,n,f.get(r,n)),f.set(r,n,i);a=m[o],m[o]=m[r],m[r]=a,g=-g}if(r<c&&0!==f.get(r,r))for(e=r+1;e<c;e++)f.set(e,r,f.get(e,r)/f.get(r,r))}this.LU=f,this.pivotVector=m,this.pivotSign=g}isSingular(){let t=this.LU,e=t.columns;for(let r=0;r<e;r++)if(0===t.get(r,r))return!0;return!1}solve(t){t=X.checkMatrix(t);let e=this.LU;if(e.rows!==t.rows)throw new Error("Invalid matrix dimensions");if(this.isSingular())throw new Error("LU matrix is singular");let r,n,o,s=t.columns,i=t.subMatrixRow(this.pivotVector,0,s-1),a=e.columns;for(o=0;o<a;o++)for(r=o+1;r<a;r++)for(n=0;n<s;n++)i.set(r,n,i.get(r,n)-i.get(o,n)*e.get(r,o));for(o=a-1;o>=0;o--){for(n=0;n<s;n++)i.set(o,n,i.get(o,n)/e.get(o,o));for(r=0;r<o;r++)for(n=0;n<s;n++)i.set(r,n,i.get(r,n)-i.get(o,n)*e.get(r,o))}return i}get determinant(){let t=this.LU;if(!t.isSquare())throw new Error("Matrix must be square");let e=this.pivotSign,r=t.columns;for(let n=0;n<r;n++)e*=t.get(n,n);return e}get lowerTriangularMatrix(){let t=this.LU,e=t.rows,r=t.columns,n=new X(e,r);for(let o=0;o<e;o++)for(let e=0;e<r;e++)o>e?n.set(o,e,t.get(o,e)):o===e?n.set(o,e,1):n.set(o,e,0);return n}get upperTriangularMatrix(){let t=this.LU,e=t.rows,r=t.columns,n=new X(e,r);for(let o=0;o<e;o++)for(let e=0;e<r;e++)o<=e?n.set(o,e,t.get(o,e)):n.set(o,e,0);return n}get pivotPermutationVector(){return Array.from(this.pivotVector)}}function Z(t,e){let r=0;return Math.abs(t)>Math.abs(e)?(r=e/t,Math.abs(t)*Math.sqrt(1+r*r)):0!==e?(r=t/e,Math.abs(e)*Math.sqrt(1+r*r)):0}class K{constructor(t){let e,r,n,o,s=(t=W.checkMatrix(t)).clone(),i=t.rows,a=t.columns,l=new Float64Array(a);for(n=0;n<a;n++){let t=0;for(e=n;e<i;e++)t=Z(t,s.get(e,n));if(0!==t){for(s.get(n,n)<0&&(t=-t),e=n;e<i;e++)s.set(e,n,s.get(e,n)/t);for(s.set(n,n,s.get(n,n)+1),r=n+1;r<a;r++){for(o=0,e=n;e<i;e++)o+=s.get(e,n)*s.get(e,r);for(o=-o/s.get(n,n),e=n;e<i;e++)s.set(e,r,s.get(e,r)+o*s.get(e,n))}}l[n]=-t}this.QR=s,this.Rdiag=l}solve(t){t=X.checkMatrix(t);let e=this.QR,r=e.rows;if(t.rows!==r)throw new Error("Matrix row dimensions must agree");if(!this.isFullRank())throw new Error("Matrix is rank deficient");let n,o,s,i,a=t.columns,l=t.clone(),u=e.columns;for(s=0;s<u;s++)for(o=0;o<a;o++){for(i=0,n=s;n<r;n++)i+=e.get(n,s)*l.get(n,o);for(i=-i/e.get(s,s),n=s;n<r;n++)l.set(n,o,l.get(n,o)+i*e.get(n,s))}for(s=u-1;s>=0;s--){for(o=0;o<a;o++)l.set(s,o,l.get(s,o)/this.Rdiag[s]);for(n=0;n<s;n++)for(o=0;o<a;o++)l.set(n,o,l.get(n,o)-l.get(s,o)*e.get(n,s))}return l.subMatrix(0,u-1,0,a-1)}isFullRank(){let t=this.QR.columns;for(let e=0;e<t;e++)if(0===this.Rdiag[e])return!1;return!0}get upperTriangularMatrix(){let t,e,r=this.QR,n=r.columns,o=new X(n,n);for(t=0;t<n;t++)for(e=0;e<n;e++)t<e?o.set(t,e,r.get(t,e)):t===e?o.set(t,e,this.Rdiag[t]):o.set(t,e,0);return o}get orthogonalMatrix(){let t,e,r,n,o=this.QR,s=o.rows,i=o.columns,a=new X(s,i);for(r=i-1;r>=0;r--){for(t=0;t<s;t++)a.set(t,r,0);for(a.set(r,r,1),e=r;e<i;e++)if(0!==o.get(r,r)){for(n=0,t=r;t<s;t++)n+=o.get(t,r)*a.get(t,e);for(n=-n/o.get(r,r),t=r;t<s;t++)a.set(t,e,a.get(t,e)+n*o.get(t,r))}}return a}}class J{constructor(t,e={}){if((t=W.checkMatrix(t)).isEmpty())throw new Error("Matrix must be non-empty");let r=t.rows,n=t.columns;const{computeLeftSingularVectors:o=!0,computeRightSingularVectors:s=!0,autoTranspose:i=!1}=e;let a,l=Boolean(o),u=Boolean(s),f=!1;if(r<n)if(i){a=t.transpose(),r=a.rows,n=a.columns,f=!0;let e=l;l=u,u=e}else a=t.clone(),console.warn("Computing SVD on a matrix with more columns than rows. Consider enabling autoTranspose");else a=t.clone();let c=Math.min(r,n),h=Math.min(r+1,n),m=new Float64Array(h),g=new X(r,c),d=new X(n,n),p=new Float64Array(n),w=new Float64Array(r),y=new Float64Array(h);for(let t=0;t<h;t++)y[t]=t;let b=Math.min(r-1,n),x=Math.max(0,Math.min(n-2,r)),v=Math.max(b,x);for(let t=0;t<v;t++){if(t<b){m[t]=0;for(let e=t;e<r;e++)m[t]=Z(m[t],a.get(e,t));if(0!==m[t]){a.get(t,t)<0&&(m[t]=-m[t]);for(let e=t;e<r;e++)a.set(e,t,a.get(e,t)/m[t]);a.set(t,t,a.get(t,t)+1)}m[t]=-m[t]}for(let e=t+1;e<n;e++){if(t<b&&0!==m[t]){let n=0;for(let o=t;o<r;o++)n+=a.get(o,t)*a.get(o,e);n=-n/a.get(t,t);for(let o=t;o<r;o++)a.set(o,e,a.get(o,e)+n*a.get(o,t))}p[e]=a.get(t,e)}if(l&&t<b)for(let e=t;e<r;e++)g.set(e,t,a.get(e,t));if(t<x){p[t]=0;for(let e=t+1;e<n;e++)p[t]=Z(p[t],p[e]);if(0!==p[t]){p[t+1]<0&&(p[t]=0-p[t]);for(let e=t+1;e<n;e++)p[e]/=p[t];p[t+1]+=1}if(p[t]=-p[t],t+1<r&&0!==p[t]){for(let e=t+1;e<r;e++)w[e]=0;for(let e=t+1;e<r;e++)for(let r=t+1;r<n;r++)w[e]+=p[r]*a.get(e,r);for(let e=t+1;e<n;e++){let n=-p[e]/p[t+1];for(let o=t+1;o<r;o++)a.set(o,e,a.get(o,e)+n*w[o])}}if(u)for(let e=t+1;e<n;e++)d.set(e,t,p[e])}}let M=Math.min(n,r+1);if(b<n&&(m[b]=a.get(b,b)),r<M&&(m[M-1]=0),x+1<M&&(p[x]=a.get(x,M-1)),p[M-1]=0,l){for(let t=b;t<c;t++){for(let e=0;e<r;e++)g.set(e,t,0);g.set(t,t,1)}for(let t=b-1;t>=0;t--)if(0!==m[t]){for(let e=t+1;e<c;e++){let n=0;for(let o=t;o<r;o++)n+=g.get(o,t)*g.get(o,e);n=-n/g.get(t,t);for(let o=t;o<r;o++)g.set(o,e,g.get(o,e)+n*g.get(o,t))}for(let e=t;e<r;e++)g.set(e,t,-g.get(e,t));g.set(t,t,1+g.get(t,t));for(let e=0;e<t-1;e++)g.set(e,t,0)}else{for(let e=0;e<r;e++)g.set(e,t,0);g.set(t,t,1)}}if(u)for(let t=n-1;t>=0;t--){if(t<x&&0!==p[t])for(let e=t+1;e<n;e++){let r=0;for(let o=t+1;o<n;o++)r+=d.get(o,t)*d.get(o,e);r=-r/d.get(t+1,t);for(let o=t+1;o<n;o++)d.set(o,e,d.get(o,e)+r*d.get(o,t))}for(let e=0;e<n;e++)d.set(e,t,0);d.set(t,t,1)}let E=M-1,A=Number.EPSILON;for(;M>0;){let t,e;for(t=M-2;t>=-1&&-1!==t;t--){const e=Number.MIN_VALUE+A*Math.abs(m[t]+Math.abs(m[t+1]));if(Math.abs(p[t])<=e||Number.isNaN(p[t])){p[t]=0;break}}if(t===M-2)e=4;else{let r;for(r=M-1;r>=t&&r!==t;r--){let e=(r!==M?Math.abs(p[r]):0)+(r!==t+1?Math.abs(p[r-1]):0);if(Math.abs(m[r])<=A*e){m[r]=0;break}}r===t?e=3:r===M-1?e=1:(e=2,t=r)}switch(t++,e){case 1:{let e=p[M-2];p[M-2]=0;for(let r=M-2;r>=t;r--){let o=Z(m[r],e),s=m[r]/o,i=e/o;if(m[r]=o,r!==t&&(e=-i*p[r-1],p[r-1]=s*p[r-1]),u)for(let t=0;t<n;t++)o=s*d.get(t,r)+i*d.get(t,M-1),d.set(t,M-1,-i*d.get(t,r)+s*d.get(t,M-1)),d.set(t,r,o)}break}case 2:{let e=p[t-1];p[t-1]=0;for(let n=t;n<M;n++){let o=Z(m[n],e),s=m[n]/o,i=e/o;if(m[n]=o,e=-i*p[n],p[n]=s*p[n],l)for(let e=0;e<r;e++)o=s*g.get(e,n)+i*g.get(e,t-1),g.set(e,t-1,-i*g.get(e,n)+s*g.get(e,t-1)),g.set(e,n,o)}break}case 3:{const e=Math.max(Math.abs(m[M-1]),Math.abs(m[M-2]),Math.abs(p[M-2]),Math.abs(m[t]),Math.abs(p[t])),o=m[M-1]/e,s=m[M-2]/e,i=p[M-2]/e,a=m[t]/e,f=p[t]/e,c=((s+o)*(s-o)+i*i)/2,h=o*i*(o*i);let w=0;0===c&&0===h||(w=c<0?0-Math.sqrt(c*c+h):Math.sqrt(c*c+h),w=h/(c+w));let y=(a+o)*(a-o)+w,b=a*f;for(let e=t;e<M-1;e++){let o=Z(y,b);0===o&&(o=Number.MIN_VALUE);let s=y/o,i=b/o;if(e!==t&&(p[e-1]=o),y=s*m[e]+i*p[e],p[e]=s*p[e]-i*m[e],b=i*m[e+1],m[e+1]=s*m[e+1],u)for(let t=0;t<n;t++)o=s*d.get(t,e)+i*d.get(t,e+1),d.set(t,e+1,-i*d.get(t,e)+s*d.get(t,e+1)),d.set(t,e,o);if(o=Z(y,b),0===o&&(o=Number.MIN_VALUE),s=y/o,i=b/o,m[e]=o,y=s*p[e]+i*m[e+1],m[e+1]=-i*p[e]+s*m[e+1],b=i*p[e+1],p[e+1]=s*p[e+1],l&&e<r-1)for(let t=0;t<r;t++)o=s*g.get(t,e)+i*g.get(t,e+1),g.set(t,e+1,-i*g.get(t,e)+s*g.get(t,e+1)),g.set(t,e,o)}p[M-2]=y;break}case 4:if(m[t]<=0&&(m[t]=m[t]<0?-m[t]:0,u))for(let e=0;e<=E;e++)d.set(e,t,-d.get(e,t));for(;t<E&&!(m[t]>=m[t+1]);){let e=m[t];if(m[t]=m[t+1],m[t+1]=e,u&&t<n-1)for(let r=0;r<n;r++)e=d.get(r,t+1),d.set(r,t+1,d.get(r,t)),d.set(r,t,e);if(l&&t<r-1)for(let n=0;n<r;n++)e=g.get(n,t+1),g.set(n,t+1,g.get(n,t)),g.set(n,t,e);t++}M--}}if(f){let t=d;d=g,g=t}this.m=r,this.n=n,this.s=m,this.U=g,this.V=d}solve(t){let e=t,r=this.threshold,n=this.s.length,o=X.zeros(n,n);for(let t=0;t<n;t++)Math.abs(this.s[t])<=r?o.set(t,t,0):o.set(t,t,1/this.s[t]);let s=this.U,i=this.rightSingularVectors,a=i.mmul(o),l=i.rows,u=s.rows,f=X.zeros(l,u);for(let t=0;t<l;t++)for(let e=0;e<u;e++){let r=0;for(let o=0;o<n;o++)r+=a.get(t,o)*s.get(e,o);f.set(t,e,r)}return f.mmul(e)}solveForDiagonal(t){return this.solve(X.diag(t))}inverse(){let t=this.V,e=this.threshold,r=t.rows,n=t.columns,o=new X(r,this.s.length);for(let s=0;s<r;s++)for(let r=0;r<n;r++)Math.abs(this.s[r])>e&&o.set(s,r,t.get(s,r)/this.s[r]);let s=this.U,i=s.rows,a=s.columns,l=new X(r,i);for(let t=0;t<r;t++)for(let e=0;e<i;e++){let r=0;for(let n=0;n<a;n++)r+=o.get(t,n)*s.get(e,n);l.set(t,e,r)}return l}get condition(){return this.s[0]/this.s[Math.min(this.m,this.n)-1]}get norm2(){return this.s[0]}get rank(){let t=Math.max(this.m,this.n)*this.s[0]*Number.EPSILON,e=0,r=this.s;for(let n=0,o=r.length;n<o;n++)r[n]>t&&e++;return e}get diagonal(){return Array.from(this.s)}get threshold(){return Number.EPSILON/2*Math.max(this.m,this.n)*this.s[0]}get leftSingularVectors(){return this.U}get rightSingularVectors(){return this.V}get diagonalMatrix(){return X.diag(this.s)}}function Q(t,e,r=!1){return t=W.checkMatrix(t),e=W.checkMatrix(e),r?new J(t).solve(e):t.isSquare()?new H(t).solve(e):new K(t).solve(e)}function tt(t,e){let r=[];for(let n=0;n<t;n++)n!==e&&r.push(n);return r}function et(t,e,r,n=1e-9,o=1e-9){if(t>o)return new Array(e.rows+1).fill(0);{let t=e.addRow(r,[0]);for(let e=0;e<t.rows;e++)Math.abs(t.get(e,0))<n&&t.set(e,0,0);return t.to1DArray()}}class rt{constructor(t,e={}){const{assumeSymmetric:r=!1}=e;if(!(t=W.checkMatrix(t)).isSquare())throw new Error("Matrix is not a square matrix");if(t.isEmpty())throw new Error("Matrix must be non-empty");let n,o,s=t.columns,i=new X(s,s),a=new Float64Array(s),l=new Float64Array(s),u=t,f=!1;if(f=!!r||t.isSymmetric(),f){for(n=0;n<s;n++)for(o=0;o<s;o++)i.set(n,o,u.get(n,o));!function(t,e,r,n){let o,s,i,a,l,u,f,c;for(l=0;l<t;l++)r[l]=n.get(t-1,l);for(a=t-1;a>0;a--){for(c=0,i=0,u=0;u<a;u++)c+=Math.abs(r[u]);if(0===c)for(e[a]=r[a-1],l=0;l<a;l++)r[l]=n.get(a-1,l),n.set(a,l,0),n.set(l,a,0);else{for(u=0;u<a;u++)r[u]/=c,i+=r[u]*r[u];for(o=r[a-1],s=Math.sqrt(i),o>0&&(s=-s),e[a]=c*s,i-=o*s,r[a-1]=o-s,l=0;l<a;l++)e[l]=0;for(l=0;l<a;l++){for(o=r[l],n.set(l,a,o),s=e[l]+n.get(l,l)*o,u=l+1;u<=a-1;u++)s+=n.get(u,l)*r[u],e[u]+=n.get(u,l)*o;e[l]=s}for(o=0,l=0;l<a;l++)e[l]/=i,o+=e[l]*r[l];for(f=o/(i+i),l=0;l<a;l++)e[l]-=f*r[l];for(l=0;l<a;l++){for(o=r[l],s=e[l],u=l;u<=a-1;u++)n.set(u,l,n.get(u,l)-(o*e[u]+s*r[u]));r[l]=n.get(a-1,l),n.set(a,l,0)}}r[a]=i}for(a=0;a<t-1;a++){if(n.set(t-1,a,n.get(a,a)),n.set(a,a,1),i=r[a+1],0!==i){for(u=0;u<=a;u++)r[u]=n.get(u,a+1)/i;for(l=0;l<=a;l++){for(s=0,u=0;u<=a;u++)s+=n.get(u,a+1)*n.get(u,l);for(u=0;u<=a;u++)n.set(u,l,n.get(u,l)-s*r[u])}}for(u=0;u<=a;u++)n.set(u,a+1,0)}for(l=0;l<t;l++)r[l]=n.get(t-1,l),n.set(t-1,l,0);n.set(t-1,t-1,1),e[0]=0}(s,l,a,i),function(t,e,r,n){let o,s,i,a,l,u,f,c,h,m,g,d,p,w,y,b;for(i=1;i<t;i++)e[i-1]=e[i];e[t-1]=0;let x=0,v=0,M=Number.EPSILON;for(u=0;u<t;u++){for(v=Math.max(v,Math.abs(r[u])+Math.abs(e[u])),f=u;f<t&&!(Math.abs(e[f])<=M*v);)f++;if(f>u)do{for(o=r[u],c=(r[u+1]-o)/(2*e[u]),h=Z(c,1),c<0&&(h=-h),r[u]=e[u]/(c+h),r[u+1]=e[u]*(c+h),m=r[u+1],s=o-r[u],i=u+2;i<t;i++)r[i]-=s;for(x+=s,c=r[f],g=1,d=g,p=g,w=e[u+1],y=0,b=0,i=f-1;i>=u;i--)for(p=d,d=g,b=y,o=g*e[i],s=g*c,h=Z(c,e[i]),e[i+1]=y*h,y=e[i]/h,g=c/h,c=g*r[i]-y*o,r[i+1]=s+y*(g*o+y*r[i]),l=0;l<t;l++)s=n.get(l,i+1),n.set(l,i+1,y*n.get(l,i)+g*s),n.set(l,i,g*n.get(l,i)-y*s);c=-y*b*p*w*e[u]/m,e[u]=y*c,r[u]=g*c}while(Math.abs(e[u])>M*v);r[u]=r[u]+x,e[u]=0}for(i=0;i<t-1;i++){for(l=i,c=r[i],a=i+1;a<t;a++)r[a]<c&&(l=a,c=r[a]);if(l!==i)for(r[l]=r[i],r[i]=c,a=0;a<t;a++)c=n.get(a,i),n.set(a,i,n.get(a,l)),n.set(a,l,c)}}(s,l,a,i)}else{let t=new X(s,s),e=new Float64Array(s);for(o=0;o<s;o++)for(n=0;n<s;n++)t.set(n,o,u.get(n,o));!function(t,e,r,n){let o,s,i,a,l,u,f,c=0,h=t-1;for(u=c+1;u<=h-1;u++){for(f=0,a=u;a<=h;a++)f+=Math.abs(e.get(a,u-1));if(0!==f){for(i=0,a=h;a>=u;a--)r[a]=e.get(a,u-1)/f,i+=r[a]*r[a];for(s=Math.sqrt(i),r[u]>0&&(s=-s),i-=r[u]*s,r[u]=r[u]-s,l=u;l<t;l++){for(o=0,a=h;a>=u;a--)o+=r[a]*e.get(a,l);for(o/=i,a=u;a<=h;a++)e.set(a,l,e.get(a,l)-o*r[a])}for(a=0;a<=h;a++){for(o=0,l=h;l>=u;l--)o+=r[l]*e.get(a,l);for(o/=i,l=u;l<=h;l++)e.set(a,l,e.get(a,l)-o*r[l])}r[u]=f*r[u],e.set(u,u-1,f*s)}}for(a=0;a<t;a++)for(l=0;l<t;l++)n.set(a,l,a===l?1:0);for(u=h-1;u>=c+1;u--)if(0!==e.get(u,u-1)){for(a=u+1;a<=h;a++)r[a]=e.get(a,u-1);for(l=u;l<=h;l++){for(s=0,a=u;a<=h;a++)s+=r[a]*n.get(a,l);for(s=s/r[u]/e.get(u,u-1),a=u;a<=h;a++)n.set(a,l,n.get(a,l)+s*r[a])}}}(s,t,e,i),function(t,e,r,n,o){let s,i,a,l,u,f,c,h,m,g,d,p,w,y,b,x=t-1,v=0,M=t-1,E=Number.EPSILON,A=0,I=0,S=0,N=0,_=0,k=0,T=0,R=0;for(s=0;s<t;s++)for((s<v||s>M)&&(r[s]=o.get(s,s),e[s]=0),i=Math.max(s-1,0);i<t;i++)I+=Math.abs(o.get(s,i));for(;x>=v;){for(l=x;l>v&&(k=Math.abs(o.get(l-1,l-1))+Math.abs(o.get(l,l)),0===k&&(k=I),!(Math.abs(o.get(l,l-1))<E*k));)l--;if(l===x)o.set(x,x,o.get(x,x)+A),r[x]=o.get(x,x),e[x]=0,x--,R=0;else if(l===x-1){if(c=o.get(x,x-1)*o.get(x-1,x),S=(o.get(x-1,x-1)-o.get(x,x))/2,N=S*S+c,T=Math.sqrt(Math.abs(N)),o.set(x,x,o.get(x,x)+A),o.set(x-1,x-1,o.get(x-1,x-1)+A),h=o.get(x,x),N>=0){for(T=S>=0?S+T:S-T,r[x-1]=h+T,r[x]=r[x-1],0!==T&&(r[x]=h-c/T),e[x-1]=0,e[x]=0,h=o.get(x,x-1),k=Math.abs(h)+Math.abs(T),S=h/k,N=T/k,_=Math.sqrt(S*S+N*N),S/=_,N/=_,i=x-1;i<t;i++)T=o.get(x-1,i),o.set(x-1,i,N*T+S*o.get(x,i)),o.set(x,i,N*o.get(x,i)-S*T);for(s=0;s<=x;s++)T=o.get(s,x-1),o.set(s,x-1,N*T+S*o.get(s,x)),o.set(s,x,N*o.get(s,x)-S*T);for(s=v;s<=M;s++)T=n.get(s,x-1),n.set(s,x-1,N*T+S*n.get(s,x)),n.set(s,x,N*n.get(s,x)-S*T)}else r[x-1]=h+S,r[x]=h+S,e[x-1]=T,e[x]=-T;x-=2,R=0}else{if(h=o.get(x,x),m=0,c=0,l<x&&(m=o.get(x-1,x-1),c=o.get(x,x-1)*o.get(x-1,x)),10===R){for(A+=h,s=v;s<=x;s++)o.set(s,s,o.get(s,s)-h);k=Math.abs(o.get(x,x-1))+Math.abs(o.get(x-1,x-2)),h=m=.75*k,c=-.4375*k*k}if(30===R&&(k=(m-h)/2,k=k*k+c,k>0)){for(k=Math.sqrt(k),m<h&&(k=-k),k=h-c/((m-h)/2+k),s=v;s<=x;s++)o.set(s,s,o.get(s,s)-k);A+=k,h=m=c=.964}for(R+=1,u=x-2;u>=l&&(T=o.get(u,u),_=h-T,k=m-T,S=(_*k-c)/o.get(u+1,u)+o.get(u,u+1),N=o.get(u+1,u+1)-T-_-k,_=o.get(u+2,u+1),k=Math.abs(S)+Math.abs(N)+Math.abs(_),S/=k,N/=k,_/=k,u!==l)&&!(Math.abs(o.get(u,u-1))*(Math.abs(N)+Math.abs(_))<E*(Math.abs(S)*(Math.abs(o.get(u-1,u-1))+Math.abs(T)+Math.abs(o.get(u+1,u+1)))));)u--;for(s=u+2;s<=x;s++)o.set(s,s-2,0),s>u+2&&o.set(s,s-3,0);for(a=u;a<=x-1&&(y=a!==x-1,a!==u&&(S=o.get(a,a-1),N=o.get(a+1,a-1),_=y?o.get(a+2,a-1):0,h=Math.abs(S)+Math.abs(N)+Math.abs(_),0!==h&&(S/=h,N/=h,_/=h)),0!==h);a++)if(k=Math.sqrt(S*S+N*N+_*_),S<0&&(k=-k),0!==k){for(a!==u?o.set(a,a-1,-k*h):l!==u&&o.set(a,a-1,-o.get(a,a-1)),S+=k,h=S/k,m=N/k,T=_/k,N/=S,_/=S,i=a;i<t;i++)S=o.get(a,i)+N*o.get(a+1,i),y&&(S+=_*o.get(a+2,i),o.set(a+2,i,o.get(a+2,i)-S*T)),o.set(a,i,o.get(a,i)-S*h),o.set(a+1,i,o.get(a+1,i)-S*m);for(s=0;s<=Math.min(x,a+3);s++)S=h*o.get(s,a)+m*o.get(s,a+1),y&&(S+=T*o.get(s,a+2),o.set(s,a+2,o.get(s,a+2)-S*_)),o.set(s,a,o.get(s,a)-S),o.set(s,a+1,o.get(s,a+1)-S*N);for(s=v;s<=M;s++)S=h*n.get(s,a)+m*n.get(s,a+1),y&&(S+=T*n.get(s,a+2),n.set(s,a+2,n.get(s,a+2)-S*_)),n.set(s,a,n.get(s,a)-S),n.set(s,a+1,n.get(s,a+1)-S*N)}}}if(0===I)return;for(x=t-1;x>=0;x--)if(S=r[x],N=e[x],0===N)for(l=x,o.set(x,x,1),s=x-1;s>=0;s--){for(c=o.get(s,s)-S,_=0,i=l;i<=x;i++)_+=o.get(s,i)*o.get(i,x);if(e[s]<0)T=c,k=_;else if(l=s,0===e[s]?o.set(s,x,0!==c?-_/c:-_/(E*I)):(h=o.get(s,s+1),m=o.get(s+1,s),N=(r[s]-S)*(r[s]-S)+e[s]*e[s],f=(h*k-T*_)/N,o.set(s,x,f),o.set(s+1,x,Math.abs(h)>Math.abs(T)?(-_-c*f)/h:(-k-m*f)/T)),f=Math.abs(o.get(s,x)),E*f*f>1)for(i=s;i<=x;i++)o.set(i,x,o.get(i,x)/f)}else if(N<0)for(l=x-1,Math.abs(o.get(x,x-1))>Math.abs(o.get(x-1,x))?(o.set(x-1,x-1,N/o.get(x,x-1)),o.set(x-1,x,-(o.get(x,x)-S)/o.get(x,x-1))):(b=nt(0,-o.get(x-1,x),o.get(x-1,x-1)-S,N),o.set(x-1,x-1,b[0]),o.set(x-1,x,b[1])),o.set(x,x-1,0),o.set(x,x,1),s=x-2;s>=0;s--){for(g=0,d=0,i=l;i<=x;i++)g+=o.get(s,i)*o.get(i,x-1),d+=o.get(s,i)*o.get(i,x);if(c=o.get(s,s)-S,e[s]<0)T=c,_=g,k=d;else if(l=s,0===e[s]?(b=nt(-g,-d,c,N),o.set(s,x-1,b[0]),o.set(s,x,b[1])):(h=o.get(s,s+1),m=o.get(s+1,s),p=(r[s]-S)*(r[s]-S)+e[s]*e[s]-N*N,w=2*(r[s]-S)*N,0===p&&0===w&&(p=E*I*(Math.abs(c)+Math.abs(N)+Math.abs(h)+Math.abs(m)+Math.abs(T))),b=nt(h*_-T*g+N*d,h*k-T*d-N*g,p,w),o.set(s,x-1,b[0]),o.set(s,x,b[1]),Math.abs(h)>Math.abs(T)+Math.abs(N)?(o.set(s+1,x-1,(-g-c*o.get(s,x-1)+N*o.get(s,x))/h),o.set(s+1,x,(-d-c*o.get(s,x)-N*o.get(s,x-1))/h)):(b=nt(-_-m*o.get(s,x-1),-k-m*o.get(s,x),T,N),o.set(s+1,x-1,b[0]),o.set(s+1,x,b[1]))),f=Math.max(Math.abs(o.get(s,x-1)),Math.abs(o.get(s,x))),E*f*f>1)for(i=s;i<=x;i++)o.set(i,x-1,o.get(i,x-1)/f),o.set(i,x,o.get(i,x)/f)}for(s=0;s<t;s++)if(s<v||s>M)for(i=s;i<t;i++)n.set(s,i,o.get(s,i));for(i=t-1;i>=v;i--)for(s=v;s<=M;s++){for(T=0,a=v;a<=Math.min(i,M);a++)T+=n.get(s,a)*o.get(a,i);n.set(s,i,T)}}(s,l,a,i,t)}this.n=s,this.e=l,this.d=a,this.V=i}get realEigenvalues(){return Array.from(this.d)}get imaginaryEigenvalues(){return Array.from(this.e)}get eigenvectorMatrix(){return this.V}get diagonalMatrix(){let t,e,r=this.n,n=this.e,o=this.d,s=new X(r,r);for(t=0;t<r;t++){for(e=0;e<r;e++)s.set(t,e,0);s.set(t,t,o[t]),n[t]>0?s.set(t,t+1,n[t]):n[t]<0&&s.set(t,t-1,n[t])}return s}}function nt(t,e,r,n){let o,s;return Math.abs(r)>Math.abs(n)?(o=n/r,s=r+o*n,[(t+o*e)/s,(e-o*t)/s]):(o=r/n,s=n+o*r,[(o*t+e)/s,(o*e-t)/s])}class ot{constructor(t){if(!(t=W.checkMatrix(t)).isSymmetric())throw new Error("Matrix is not symmetric");let e,r,n,o=t,s=o.rows,i=new X(s,s),a=!0;for(r=0;r<s;r++){let t=0;for(n=0;n<r;n++){let s=0;for(e=0;e<n;e++)s+=i.get(n,e)*i.get(r,e);s=(o.get(r,n)-s)/i.get(n,n),i.set(r,n,s),t+=s*s}for(t=o.get(r,r)-t,a&&=t>0,i.set(r,r,Math.sqrt(Math.max(t,0))),n=r+1;n<s;n++)i.set(r,n,0)}this.L=i,this.positiveDefinite=a}isPositiveDefinite(){return this.positiveDefinite}solve(t){t=W.checkMatrix(t);let e=this.L,r=e.rows;if(t.rows!==r)throw new Error("Matrix dimensions do not match");if(!1===this.isPositiveDefinite())throw new Error("Matrix is not positive definite");let n,o,s,i=t.columns,a=t.clone();for(s=0;s<r;s++)for(o=0;o<i;o++){for(n=0;n<s;n++)a.set(s,o,a.get(s,o)-a.get(n,o)*e.get(s,n));a.set(s,o,a.get(s,o)/e.get(s,s))}for(s=r-1;s>=0;s--)for(o=0;o<i;o++){for(n=s+1;n<r;n++)a.set(s,o,a.get(s,o)-a.get(n,o)*e.get(n,s));a.set(s,o,a.get(s,o)/e.get(s,s))}return a}get lowerTriangularMatrix(){return this.L}}class st{constructor(t,e={}){t=W.checkMatrix(t);let{Y:r}=e;const{scaleScores:n=!1,maxIterations:o=1e3,terminationCriteria:s=1e-10}=e;let i;if(r){if(r=M.isAnyArray(r)&&"number"==typeof r[0]?X.columnVector(r):W.checkMatrix(r),r.rows!==t.rows)throw new Error("Y should have the same number of rows as X");i=r.getColumnVector(0)}else i=t.getColumnVector(0);let a,l,u,f,c=1;for(let e=0;e<o&&c>s;e++)u=t.transpose().mmul(i).div(i.transpose().mmul(i).get(0,0)),u=u.div(u.norm()),a=t.mmul(u).div(u.transpose().mmul(u).get(0,0)),e>0&&(c=a.clone().sub(f).pow(2).sum()),f=a.clone(),r?(l=r.transpose().mmul(a).div(a.transpose().mmul(a).get(0,0)),l=l.div(l.norm()),i=r.mmul(l).div(l.transpose().mmul(l).get(0,0))):i=a;if(r){let e=t.transpose().mmul(a).div(a.transpose().mmul(a).get(0,0));e=e.div(e.norm());let n=t.clone().sub(a.clone().mmul(e.transpose())),o=i.transpose().mmul(a).div(a.transpose().mmul(a).get(0,0)),s=r.clone().sub(a.clone().mulS(o.get(0,0)).mmul(l.transpose()));this.t=a,this.p=e.transpose(),this.w=u.transpose(),this.q=l,this.u=i,this.s=a.transpose().mmul(a),this.xResidual=n,this.yResidual=s,this.betas=o}else this.w=u.transpose(),this.s=a.transpose().mmul(a).sqrt(),this.t=n?a.clone().div(this.s.get(0,0)):a,this.xResidual=t.sub(a.mmul(u.transpose()))}}y.AbstractMatrix=$,y.CHO=ot,y.CholeskyDecomposition=ot,y.DistanceMatrix=U,y.EVD=rt,y.EigenvalueDecomposition=rt,y.LU=H,y.LuDecomposition=H;var it=y.Matrix=X;y.MatrixColumnSelectionView=class extends V{constructor(t,e){z(t,e),super(t,t.rows,e.length),this.columnIndices=e}set(t,e,r){return this.matrix.set(t,this.columnIndices[e],r),this}get(t,e){return this.matrix.get(t,this.columnIndices[e])}},y.MatrixColumnView=class extends V{constructor(t,e){T(t,e),super(t,t.rows,1),this.column=e}set(t,e,r){return this.matrix.set(t,this.column,r),this}get(t){return this.matrix.get(t,this.column)}},y.MatrixFlipColumnView=class extends V{constructor(t){super(t,t.rows,t.columns)}set(t,e,r){return this.matrix.set(t,this.columns-e-1,r),this}get(t,e){return this.matrix.get(t,this.columns-e-1)}},y.MatrixFlipRowView=class extends V{constructor(t){super(t,t.rows,t.columns)}set(t,e,r){return this.matrix.set(this.rows-t-1,e,r),this}get(t,e){return this.matrix.get(this.rows-t-1,e)}},y.MatrixRowSelectionView=class extends V{constructor(t,e){F(t,e),super(t,e.length,t.columns),this.rowIndices=e}set(t,e,r){return this.matrix.set(this.rowIndices[t],e,r),this}get(t,e){return this.matrix.get(this.rowIndices[t],e)}},y.MatrixRowView=class extends V{constructor(t,e){k(t,e),super(t,1,t.columns),this.row=e}set(t,e,r){return this.matrix.set(this.row,e,r),this}get(t,e){return this.matrix.get(this.row,e)}},y.MatrixSelectionView=q,y.MatrixSubView=class extends V{constructor(t,e,r,n,o){B(t,e,r,n,o),super(t,r-e+1,o-n+1),this.startRow=e,this.startColumn=n}set(t,e,r){return this.matrix.set(this.startRow+t,this.startColumn+e,r),this}get(t,e){return this.matrix.get(this.startRow+t,this.startColumn+e)}};var at=y.MatrixTransposeView=class extends V{constructor(t){super(t,t.columns,t.rows)}set(t,e,r){return this.matrix.set(e,t,r),this}get(t,e){return this.matrix.get(e,t)}};y.NIPALS=st,y.Nipals=st,y.QR=K,y.QrDecomposition=K,y.SVD=J,y.SingularValueDecomposition=J,y.SymmetricMatrix=Y,y.WrapperMatrix1D=G,y.WrapperMatrix2D=W,y.correlation=function(t,e=t,r={}){t=new X(t);let n=!1;if("object"!=typeof e||X.isMatrix(e)||M.isAnyArray(e)?e=new X(e):(r=e,e=t,n=!0),t.rows!==e.rows)throw new TypeError("Both matrices must have the same number of rows");const{center:o=!0,scale:s=!0}=r;o&&(t.center("column"),n||e.center("column")),s&&(t.scale("column"),n||e.scale("column"));const i=t.standardDeviation("column",{unbiased:!0}),a=n?i:e.standardDeviation("column",{unbiased:!0}),l=t.transpose().mmul(e);for(let e=0;e<l.rows;e++)for(let r=0;r<l.columns;r++)l.set(e,r,l.get(e,r)*(1/(i[e]*a[r]))*(1/(t.rows-1)));return l},y.covariance=function(t,e=t,r={}){t=new X(t);let n=!1;if("object"!=typeof e||X.isMatrix(e)||M.isAnyArray(e)?e=new X(e):(r=e,e=t,n=!0),t.rows!==e.rows)throw new TypeError("Both matrices must have the same number of rows");const{center:o=!0}=r;o&&(t=t.center("column"),n||(e=e.center("column")));const s=t.transpose().mmul(e);for(let e=0;e<s.rows;e++)for(let r=0;r<s.columns;r++)s.set(e,r,s.get(e,r)*(1/(t.rows-1)));return s};var lt=y.default=X;y.determinant=function t(e){if((e=X.checkMatrix(e)).isSquare()){if(0===e.columns)return 1;let r,n,o,s;if(2===e.columns)return r=e.get(0,0),n=e.get(0,1),o=e.get(1,0),s=e.get(1,1),r*s-n*o;if(3===e.columns){let s,i,a;return s=new q(e,[1,2],[1,2]),i=new q(e,[1,2],[0,2]),a=new q(e,[1,2],[0,1]),r=e.get(0,0),n=e.get(0,1),o=e.get(0,2),r*t(s)-n*t(i)+o*t(a)}return new H(e).determinant}throw Error("determinant can only be calculated for a square matrix")},y.inverse=function(t,e=!1){return t=W.checkMatrix(t),e?new J(t).inverse():Q(t,X.eye(t.rows))},y.linearDependencies=function(t,e={}){const{thresholdValue:r=1e-9,thresholdError:n=1e-9}=e;let o=(t=X.checkMatrix(t)).rows,s=new X(o,o);for(let e=0;e<o;e++){let i=X.columnVector(t.getRow(e)),a=t.subMatrixRow(tt(o,e)).transpose(),l=new J(a).solve(i),u=X.sub(i,a.mmul(l)).abs().max();s.setRow(e,et(u,l,e,r,n))}return s},y.pseudoInverse=function(t,e=Number.EPSILON){if((t=X.checkMatrix(t)).isEmpty())return t.transpose();let r=new J(t,{autoTranspose:!0}),n=r.leftSingularVectors,o=r.rightSingularVectors,s=r.diagonal;for(let t=0;t<s.length;t++)Math.abs(s[t])>e?s[t]=1/s[t]:s[t]=0;return o.mmul(X.diag(s).mmul(n.transpose()))};var ut=y.solve=Q;y.wrap=function(t,e){if(M.isAnyArray(t))return t[0]&&M.isAnyArray(t[0])?new W(t):new G(t,e);throw new Error("the argument is not an array")};const ft=it,ct=at;lt.Matrix&&lt.Matrix;const ht=ut;function mt(t,e={}){l(t);const{fromIndex:r,toIndex:n}=f(t,e);let o=t[r];for(let e=r+1;e<=n;e++)o+=t[e];return o/(n-r+1)}function gt(t,e={}){return Math.sqrt(function(t,e={}){if(!r(t))throw new TypeError("input must be an array");const{unbiased:n=!0,mean:o=mt(t)}=e;let s=0;for(const e of t){const t=e-o;s+=t*t}return n?s/(t.length-1):s/t.length}(t,e))}function dt(t){return l(t),t instanceof Float64Array?t.slice(0):Float64Array.from(t)}function pt(t){if(this.size=0|t,this.size<=1||this.size&this.size-1)throw new Error("FFT size must be a power of two and bigger than 1");this._csize=t<<1;for(var e=new Array(2*this.size),r=0;r<e.length;r+=2){const t=Math.PI*r/this.size;e[r]=Math.cos(t),e[r+1]=-Math.sin(t)}this.table=e;for(var n=0,o=1;this.size>o;o<<=1)n++;this._width=n%2==0?n-1:n,this._bitrev=new Array(1<<this._width);for(var s=0;s<this._bitrev.length;s++){this._bitrev[s]=0;for(var i=0;i<this._width;i+=2){var a=this._width-i-2;this._bitrev[s]|=(s>>>i&3)<<a}}this._out=null,this._data=null,this._inv=0}function wt(t,e){return t===Array?new t(e).fill(0):new t(e)}function yt(t={}){const{from:e=0,to:r=1,length:n=1e3,includeFrom:o=!0,includeTo:s=!0,distribution:i="uniform"}=t,a=new Float64Array(n);let l=n;o&&s?l=n-1:!o&&s||o&&!s?l=n:o||s||(l=n+1);const u=(r-e)/l;if("uniform"===i)if(o){let t=0;for(;t<n;)a[t]=e+u*t,t++}else{let t=0;for(;t<n;)a[t]=e+u*(t+1),t++}else{if("log"!==i)throw new Error("distribution must be uniform or log");{const t=(r/e)**(1/l),s=Math.log(e)/Math.log(t);if(o){let e=0;for(;e<n;)a[e]=t**(s+e),e++}else{let e=0;for(;e<n;)a[e]=t**(s+e+1),e++}}}return a}function bt(t,e){let n=!1,o=0;if(r(e)){if(t.length!==e.length)throw new Error("size of array1 and array2 must be identical")}else n=!0,o=e;const s=new Float64Array(t.length);if(n)for(let e=0;e<t.length;e++)s[e]=t[e]-o;else for(let r=0;r<t.length;r++)s[r]=t[r]-e[r];return s}function xt(t,e={}){l(t);const{fromIndex:r,toIndex:n}=f(t,e);let o=t[r];for(let e=r+1;e<=n;e++)t[e]>o&&(o=t[e]);return o}function vt(t,e={}){l(t);const{fromIndex:r,toIndex:n}=f(t,e);let o=t[r];for(let e=r+1;e<=n;e++)t[e]<o&&(o=t[e]);return o}function Mt(t){if(t.length<=2)return 1;if(t[0]===t[1]){for(let e=1;e<t.length-1;e++)if(t[e]!==t[e+1])return 0;return 1}if(t[0]<t.at(-1)){for(let e=0;e<t.length-1;e++)if(t[e]>=t[e+1])return 0;return 1}for(let e=0;e<t.length-1;e++)if(t[e]<=t[e+1])return 0;return-1}function Et(t){l(t);let e=t[0],r=t[0];for(const n of t)n<e&&(e=n),n>r&&(r=n);return{min:e,max:r}}pt.prototype.fromComplexArray=function(t,e){for(var r=e||new Array(t.length>>>1),n=0;n<t.length;n+=2)r[n>>>1]=t[n];return r},pt.prototype.createComplexArray=function(){const t=new Array(this._csize);for(var e=0;e<t.length;e++)t[e]=0;return t},pt.prototype.toComplexArray=function(t,e){for(var r=e||this.createComplexArray(),n=0;n<r.length;n+=2)r[n]=t[n>>>1],r[n+1]=0;return r},pt.prototype.completeSpectrum=function(t){for(var e=this._csize,r=e>>>1,n=2;n<r;n+=2)t[e-n]=t[n],t[e-n+1]=-t[n+1]},pt.prototype.transform=function(t,e){if(t===e)throw new Error("Input and output buffers must be different");this._out=t,this._data=e,this._inv=0,this._transform4(),this._out=null,this._data=null},pt.prototype.realTransform=function(t,e){if(t===e)throw new Error("Input and output buffers must be different");this._out=t,this._data=e,this._inv=0,this._realTransform4(),this._out=null,this._data=null},pt.prototype.inverseTransform=function(t,e){if(t===e)throw new Error("Input and output buffers must be different");this._out=t,this._data=e,this._inv=1,this._transform4();for(var r=0;r<t.length;r++)t[r]/=this.size;this._out=null,this._data=null},pt.prototype._transform4=function(){var t,e,r=this._out,n=this._csize,o=1<<this._width,s=n/o<<1,i=this._bitrev;if(4===s)for(t=0,e=0;t<n;t+=s,e++){const r=i[e];this._singleTransform2(t,r,o)}else for(t=0,e=0;t<n;t+=s,e++){const r=i[e];this._singleTransform4(t,r,o)}var a=this._inv?-1:1,l=this.table;for(o>>=2;o>=2;o>>=2){var u=(s=n/o<<1)>>>2;for(t=0;t<n;t+=s)for(var f=t+u,c=t,h=0;c<f;c+=2,h+=o){const t=c,e=t+u,n=e+u,o=n+u,s=r[t],i=r[t+1],f=r[e],m=r[e+1],g=r[n],d=r[n+1],p=r[o],w=r[o+1],y=s,b=i,x=l[h],v=a*l[h+1],M=f*x-m*v,E=f*v+m*x,A=l[2*h],I=a*l[2*h+1],S=g*A-d*I,N=g*I+d*A,_=l[3*h],k=a*l[3*h+1],T=p*_-w*k,R=p*k+w*_,C=y+S,F=b+N,z=y-S,B=b-N,L=M+T,O=E+R,P=a*(M-T),$=a*(E-R),j=C+L,D=F+O,X=C-L,Y=F-O,U=z+$,V=B-P,q=z-$,G=B+P;r[t]=j,r[t+1]=D,r[e]=U,r[e+1]=V,r[n]=X,r[n+1]=Y,r[o]=q,r[o+1]=G}}},pt.prototype._singleTransform2=function(t,e,r){const n=this._out,o=this._data,s=o[e],i=o[e+1],a=o[e+r],l=o[e+r+1],u=s+a,f=i+l,c=s-a,h=i-l;n[t]=u,n[t+1]=f,n[t+2]=c,n[t+3]=h},pt.prototype._singleTransform4=function(t,e,r){const n=this._out,o=this._data,s=this._inv?-1:1,i=2*r,a=3*r,l=o[e],u=o[e+1],f=o[e+r],c=o[e+r+1],h=o[e+i],m=o[e+i+1],g=o[e+a],d=o[e+a+1],p=l+h,w=u+m,y=l-h,b=u-m,x=f+g,v=c+d,M=s*(f-g),E=s*(c-d),A=p+x,I=w+v,S=y+E,N=b-M,_=p-x,k=w-v,T=y-E,R=b+M;n[t]=A,n[t+1]=I,n[t+2]=S,n[t+3]=N,n[t+4]=_,n[t+5]=k,n[t+6]=T,n[t+7]=R},pt.prototype._realTransform4=function(){var t,e,r=this._out,n=this._csize,o=1<<this._width,s=n/o<<1,i=this._bitrev;if(4===s)for(t=0,e=0;t<n;t+=s,e++){const r=i[e];this._singleRealTransform2(t,r>>>1,o>>>1)}else for(t=0,e=0;t<n;t+=s,e++){const r=i[e];this._singleRealTransform4(t,r>>>1,o>>>1)}var a=this._inv?-1:1,l=this.table;for(o>>=2;o>=2;o>>=2){var u=(s=n/o<<1)>>>1,f=u>>>1,c=f>>>1;for(t=0;t<n;t+=s)for(var h=0,m=0;h<=c;h+=2,m+=o){var g=t+h,d=g+f,p=d+f,w=p+f,y=r[g],b=r[g+1],x=r[d],v=r[d+1],M=r[p],E=r[p+1],A=r[w],I=r[w+1],S=y,N=b,_=l[m],k=a*l[m+1],T=x*_-v*k,R=x*k+v*_,C=l[2*m],F=a*l[2*m+1],z=M*C-E*F,B=M*F+E*C,L=l[3*m],O=a*l[3*m+1],P=A*L-I*O,$=A*O+I*L,j=S+z,D=N+B,X=S-z,Y=N-B,U=T+P,V=R+$,q=a*(T-P),G=a*(R-$),W=j+U,H=D+V,Z=X+G,K=Y-q;if(r[g]=W,r[g+1]=H,r[d]=Z,r[d+1]=K,0!==h){if(h!==c){var J=X+-a*G,Q=-Y+-a*q,tt=j+-a*U,et=-D- -a*V,rt=t+f-h,nt=t+u-h;r[rt]=J,r[rt+1]=Q,r[nt]=tt,r[nt+1]=et}}else{var ot=j-U,st=D-V;r[p]=ot,r[p+1]=st}}}},pt.prototype._singleRealTransform2=function(t,e,r){const n=this._out,o=this._data,s=o[e],i=o[e+r],a=s+i,l=s-i;n[t]=a,n[t+1]=0,n[t+2]=l,n[t+3]=0},pt.prototype._singleRealTransform4=function(t,e,r){const n=this._out,o=this._data,s=this._inv?-1:1,i=2*r,a=3*r,l=o[e],u=o[e+r],f=o[e+i],c=o[e+a],h=l+f,m=l-f,g=u+c,d=s*(u-c),p=h+g,w=m,y=-d,b=h-g,x=m,v=d;n[t]=p,n[t+1]=0,n[t+2]=w,n[t+3]=y,n[t+4]=b,n[t+5]=0,n[t+6]=x,n[t+7]=v};const At=[-.005387729650712429,.008226878746769157,.02198786811111689,-.03656379714117627,-.012692614766297404,.03348066254097446,-.008368748197417368,-.0005087819496582806],It=[.0008862163904564247,-.0023339375937419,.07952836873415717,-.05273963823400997,-.7122890234154284,.662328840472003,1.5622155839842302,-1.5657455823417585,-.9700050433032906,1],St=[-3.6719225470772936,21.12946554483405,17.445385985570866,-44.6382324441787,-18.851064805871424,17.644729840837403,8.3705032834312,.10526468069939171,-.20243350835593876],Nt=[1.7211476576120028,-22.643693341313973,10.826866735546016,48.560921310873994,-20.14326346804852,-28.66081804998,3.971343795334387,6.242641248542475,1],_t=[-6.81149956853777e-10,2.8522533178221704e-8,-6.794655751811263e-7,.0021455899538880526,.029015791000532906,.14286953440815717,.3377855389120359,.38707973897260434,.11703015634199525,-.16379404719331705,-.1311027816799519],kt=[.011059242293464892,.15226433829533179,.848854343457902,2.5930192162362027,4.778465929458438,5.381683457070069,3.4662540724256723,1],Tt=[26633922742578204e-28,-2.304047769118826e-10,460469890584318e-20,.00015754461742496055,.0018712349281955923,.009508047013259196,.018557330651423107,-.0022242652921344794,-.0350353787183178],Rt=[7646752923027944e-20,.00263861676657016,.03415891436709477,.22009110576413124,.7620591645536234,1.3653349817554064,1],Ct=[9905570997331033e-32,-2811287356288318e-29,4.625961635228786e-9,4.4969678992770644e-7,14962478375834237e-21,.00020938631748758808,.001056288621524929,-.0011295143874558028,-.016743100507663373],Ft=[2.82243172016108e-7,27533547476472603e-21,.0009640118070051656,.016074608709367652,.1381518657490833,.5914293448864175,1];function zt(t,e){let r=0;for(const n of t)r=r*e+n;return r}function Bt(t,e,r,n,o){const s=t-e;return o*t+zt(r,s)/zt(n,s)*t}function Lt(t){let e,r,n,o,s=!1;if(Number.isNaN(t))return Number.NaN;if(t<0||t>2)throw new RangeError(`erfcinv()::invalid input argument. Value must be on the interval [0,2]. Value: \`${t}\`.`);return 0===t?Number.POSITIVE_INFINITY:2===t?Number.NEGATIVE_INFINITY:1===t?0:(t>1?(r=2-t,t=1-r,s=!0):(r=t,t=1-t),t<=.5?(n=t*(t+10),o=zt(At,t)/zt(It,t),e=.08913147449493408*n+n*o,s?-e:e):r>=.25?(n=Math.sqrt(-2*Math.log(r)),r-=.25,o=zt(St,r)/zt(Nt,r),e=n/(2.249481201171875+o),s?-e:e):(r=Math.sqrt(-Math.log(r)),r<3?Bt(r,1.125,_t,kt,.807220458984375):r<6?Bt(r,3,Tt,Rt,.9399557113647461):Bt(r,6,Ct,Ft,.9836282730102539)))}function Ot(t,e={}){return function(t,e={}){const{magnitudeMode:r=!1}=e,n=new Float64Array(t.length);if(r)for(let e=0;e<n.length;e++)n[e]=-Math.sqrt(-2*Math.log(1-t[e]));else for(let e=0;e<n.length;e++)n[e]=-1*Math.SQRT2*Lt(2*t[e]);return n}([t],e)[0]}function Pt(t,e={}){const{mask:n,cutOff:o,refine:s=!0,magnitudeMode:i=!1,scaleFactor:a=1,factorStd:l=5,fixOffset:u=!0}=e,f=function(t,e){const{scaleFactor:n,mask:o}=e,s=dt(r(o)&&o.length===t.length?t.filter((t,e)=>!o[e]):t);if(n>1)for(let t=0;t<s.length;t++)s[t]*=n;return s.sort().reverse(),s}(t,{scaleFactor:a,mask:n});if(u&&!i){const t=Math.floor(f.length/2),e=f.length%2==0?.5*(f[t-1]+f[t]):f[t];for(let t=0;t<f.length;t++)f[t]-=e}const c=f.at(-1)>=0?f.length:f.findIndex(t=>t<0);let h=c-1;for(let t=h;t>=0;t--)if(f[t]>0){h=t;break}const m=f.slice(0,h+1),g=f.slice(c),d=o||function(t,e={}){const{magnitudeMode:r=!1,considerList:n={from:.5,step:.1,to:.9}}=e,o=[],s=t.length-1;for(let e=.01;e<=.99;e+=.01){const n=-t[Math.round(s*e)]/Ot(e/2,{magnitudeMode:r});o.push([e,n])}let i=Number.MAX_SAFE_INTEGER;const{from:a,to:l,step:u}=n,f=u/2;let c=.5;for(let t=a;t<=l;t+=u){const e=t-f,r=t+f,n=o.filter(t=>t[0]<r&&t[0]>e);let s=0;for(const t of n)s+=Math.abs(t[1]);let a=0;for(const t of n)a+=(t[1]-s)**2;a<i&&(i=a,c=t)}return c}(m,{magnitudeMode:i}),p=m[Math.floor(m.length*d)],w=m[0];let y;if(g.length>0){y=-1*g[Math.floor(g.length*(1-d))]}else y=0;let b=p,x=y,v=m.slice(),M=g.slice(),E=0,A=2;if(s){let t=b*l;E=m.findIndex(e=>e<t),E>-1&&(v=m.slice(E),b=v[Math.floor(v.length*d)]),t=x*l,A=g.findIndex(e=>e<t),A>-1&&(M=g.slice(A),x=v[Math.floor(M.length*(1-d))])}const I=-Ot(d/2,{magnitudeMode:i});let S,N;return s&&E>-1?(S=(d*v.length+E)/(v.length+E),N=-1*Ot(S/2,{magnitudeMode:i}),b/=N,A>-1&&(S=(d*M.length+A)/(M.length+A),N=-1*Ot(S/2,{magnitudeMode:i}),0!==x&&(x/=N))):(b/=I,x/=I),{positive:b,negative:x,snr:w/b,sanplot:$t(f,{fromTo:{positive:{from:0,to:h},negative:{from:c,to:f.length}}})}}function $t(t,e={}){const{fromTo:r,logBaseY:n=2}=e,o={};for(const e in r){const{from:s,to:i}=r[e];o[e]=s!==i?jt(t.slice(s,i),{logBaseY:n}):{x:[],y:[]},"negative"===e&&o[e].y.reverse()}return o}function jt(t,e={}){const{log10:r,abs:n}=Math,{logBaseY:o}=e;if(o){t=t.slice(0);const e=r(o);for(let o=0;o<t.length;o++)t[o]=r(n(t[o]))/e}return{x:yt({from:0,to:t.length-1,length:t.length}),y:t}}function Dt(t){const{mad:e,median:r}=function(t){const e=o(t),r=new Float64Array(t.length);for(let n=0;n<t.length;n++)r[n]=Math.abs(t[n]-e);return{median:e,mad:o(r)}}(t);return{sd:e/.6744897501960817,mad:e,median:r}}function Xt(t,e={}){l(t);const{fromIndex:r,toIndex:n}=f(t,e);let o=t[r];for(let e=r+1;e<=n;e++)o+=t[e];return o}function Yt(t,e={}){const{algorithm:r="absolute",value:o=1}=e;l(t);const s=n(e.output,t.length);if(0===t.length)throw new Error("input must not be empty");switch(r){case"absolute":{const e=function(t){let e=0;for(const r of t)e+=Math.abs(r);return e}(t)/o;if(0===e)throw new Error("trying to divide by 0");for(let r=0;r<t.length;r++)s[r]=t[r]/e;return s}case"max":{const e=xt(t);if(0===e)throw new Error("trying to divide by 0");const r=o/e;for(let e=0;e<t.length;e++)s[e]=t[e]*r;return s}case"sum":{const e=Xt(t)/o;if(0===e)throw new Error("trying to divide by 0");for(let r=0;r<t.length;r++)s[r]=t[r]/e;return s}default:throw new Error(`unknown algorithm: ${String(r)}`)}}function Ut(t){l(t);const e=new Float64Array(t.length),r=Math.sqrt(gt(t));for(let n=0;n<t.length;n++)e[n]=t[n]/r;return e}function Vt(t,e,r={}){if(l(t),"function"!=typeof e)throw new TypeError("fct must be a function");const{window:n=5,padding:o={}}=r,{size:s=n-1,algorithm:i,value:a}=o,u=function(t,e={}){const{size:r=0,value:n=0,algorithm:o}=e;if(l(t),!o)return dt(t);const s=new Float64Array(t.length+2*r);for(let e=0;e<t.length;e++)s[e+r]=t[e];const i=r+t.length,a=2*r+t.length;switch(o){case"value":for(let t=0;t<r;t++)s[t]=n;for(let t=i;t<a;t++)s[t]=n;break;case"duplicate":for(let e=0;e<r;e++)s[e]=t[0];for(let e=i;e<a;e++)s[e]=t.at(-1);break;case"circular":for(let e=0;e<r;e++)s[e]=t[(t.length-r%t.length+e)%t.length];for(let e=0;e<r;e++)s[e+i]=t[e%t.length];break;default:throw new Error(`unknown algorithm ${String(o)}`)}return s}(t,{size:s,algorithm:i,value:a}),f=[];for(let t=0;t<u.length-n+1;t++)f.push(e(u.subarray(t,t+n)));return f}function qt(t){const{matrix:e,nbRows:r=e?.length||1,nbColumns:n=e?.[0].length||1,ArrayConstructor:o=Float64Array}=t,s=[];for(let t=0;t<r;t++)s.push(wt(o,n));return s}function Gt(t){const e=t[0].length,r=t.length,n=qt({nbColumns:e,nbRows:r});for(let o=0;o<e;o++){let e=0;for(let n=0;n<r;n++)e+=t[n][o];e/=r;for(let s=0;s<r;s++)n[s][o]=t[s][o]-e}return n}function Wt(t){!function(t){if(0===t.length||0===t[0].length)throw new RangeError("matrix must contain data");const e=t[0].length;for(let r=1;r<t.length;r++)if(t[r].length!==e)throw new RangeError("all rows must has the same length")}(t);const e=t.length,r=t[0].length;let n=t[0][0],o=t[0][0];for(let s=0;s<r;s++)for(let r=0;r<e;r++)t[r][s]<n&&(n=t[r][s]),t[r][s]>o&&(o=t[r][s]);return{min:n,max:o}}function Ht(t,e={}){const{max:r=100}=e,n=new ft(t);for(let t=0;t<n.rows;t++){const e=n.getRowVector(t).norm("frobenius")/r,o=n.getRowVector(t).div(e);n.setRow(t,o)}const s=[];for(let t=0;t<n.columns;t++){const e=n.getColumn(t);s.push(o(e))}const i=[];for(let t=0;t<n.columns;t++){const e=n.getColumnVector(t).div(s[t]);i.push(o(e.getColumn(0)))}for(let t=0;t<n.rows;t++)n.mulRow(t,1/i[t]);return{data:n.to2DArray(),medianOfQuotients:i}}function Zt(t,e={}){const{min:r=0,max:n=1,ArrayConstructor:o}=e,s=t[0].length,i=t.length,a=qt({nbColumns:s,nbRows:i,ArrayConstructor:o}),{min:l,max:u}=Wt(t),f=(n-r)/(u-l);for(let e=0;e<s;e++)for(let n=0;n<i;n++)a[n][e]=(t[n][e]-l)*f+r;return a}function Kt(t,e={}){const{minLength:n}=e;if(null===t||"object"!=typeof t||!r(t.x)||!r(t.y))throw new Error("data must be an object of x and y arrays");if(t.x.length!==t.y.length)throw new Error("the x and y arrays must have the same length");if(n&&t.x.length<n)throw new Error(`data.x must have a length of at least ${n}`)}function Jt(t,e={}){Kt(t,{minLength:1});const{x:r,y:n}=t;if(1===r.length)return{x:r[0],y:n[0],index:0};const{fromIndex:o,toIndex:s}=f(r,e);let i={x:r[o],y:n[o],index:o};for(let t=o;t<=s;t++)n[t]>i.y&&(i={x:r[t],y:n[t],index:t});return i}function Qt(t){if(Kt(t),1===Mt(t.x))return t;const e=Array.from(t.x),r=Array.from(t.y);let n=Number.NEGATIVE_INFINITY,o=0;for(let t=0;t<e.length;t++)n<e[t]&&(o<t&&(e[o]=e[t],r[o]=r[t]),o++,n=e[t]);return e.length=o,r.length=o,{x:e,y:r}}function te(t=[],e={}){const{exclusions:r=[]}=e;let{from:n=Number.NEGATIVE_INFINITY,to:o=Number.POSITIVE_INFINITY}=e;n>o&&([n,o]=[o,n]),0===(t=t.map(t=>t.from>t.to?{from:t.to,to:t.from}:{...t}).sort((t,e)=>t.from!==e.from?t.from-e.from:t.to-e.to)).length&&t.push({from:n,to:o});for(const e of t)n>e.from&&(e.from=n),o<e.to&&(e.to=o);if(0===(t=t.filter(t=>t.from<=t.to)).length)return[];let s=t[0];const i=[s];for(let e=1;e<t.length;e++){const r=t[e];r.from<=s.to?s.to<r.to&&(s.to=r.to):(s=r,i.push(s))}if(0===r.length)return i;const a=te(r);let l=0;const u=[];for(let t=0;t<i.length;t++){const e=i[t];if(l!==a.length){for(;l<a.length&&a[l].to<=e.from;)l++;if(l!==a.length)if(e.to<a[l].from)u.push(e);else{if(a[l].to>=e.to){if(a[l].from<=e.from)continue;u.push({from:a[l].to,to:e.to})}a[l].from>e.from&&u.push({from:e.from,to:a[l].from}),e.from=a[l].to,t--}else u.push(e)}else u.push(e)}return u}function ee(t,e,r,n){return.5*r*e*e+n*e-(.5*r*t*t+n*t)}function re(t,e,r,n){return(n-e)/(r-t)}function ne(t,e={}){const{x:r,y:n}=t,o=r.length,{from:s=r[0],to:i=r[o-1],variant:a="smooth",numberOfPoints:l=100,exclusions:u=[],zones:f=[{from:s,to:i}]}=e;if(s>i)throw new RangeError("from should be larger than to");if(Kt(t),l<2)throw new RangeError("'numberOfPoints' option must be greater than 1");const c=function(t=[],e=10,r={}){if(0===t.length)return[];const n=te(t,r),o=[],s=n.reduce((t,e)=>t+(e.to-e.from),0)/e;let i=0;for(let t=0;t<n.length-1;t++){const r=n[t],a=Math.min(Math.round((r.to-r.from)/s),e-i);o.push({...r,numberOfPoints:a}),i+=a}return o.push({...n.at(-1),numberOfPoints:e-i}),o}(te(f,{from:s,to:i,exclusions:u}),l,{from:s,to:i}).filter(t=>t.numberOfPoints);let h=[],m=[];for(const t of c){t.numberOfPoints||(t.numberOfPoints=0);const e=oe(Array.from(r),Array.from(n),t.from,t.to,t.numberOfPoints,a);h=h.concat(e.x),m=m.concat(e.y)}return{x:h,y:m}}function oe(t,e,r,n,o,s){if(o<1)throw new RangeError("the number of points must be at least 1");const i="slot"===s?Array.from(function(t,e,r,n,o){const s=t.length;if(s<2)return Float64Array.from(t);const i=(n-r)/(o>1?o-1:1),a=i/2,l=t.at(-1)-t.at(-2),u=r-a,f=new Float64Array(o);let c=u,h=u+i,m=-Number.MAX_VALUE,g=0,d=t[0],p=e[0],w=0,y=!0,b=0,x=0,v=1,M=0;t:for(;;){if(m>=d)throw new Error("x must be a growing series");for(;m-h>0;){if(y&&(x++,y=!1),f[M]=x<=0?0:b/x,M++,M===o)break t;c=h,h+=i,b=0,x=0}m>c&&(b+=g,x++),(m===-Number.MAX_VALUE||w>1)&&x--,m=d,g=p,v<s?(d=t[v],p=e[v],v++):(d+=l,p=0,w++)}return f}(t,e,r,n,o)):Array.from(function(t,e,r,n,o){const s=t.length,i=(n-r)/(o>1?o-1:1),a=i/2,l=new Float64Array(o),u=t[1]-t[0],f=t[s-1]-t[s-2];let c=r-a,h=r+a,m=Number.MIN_SAFE_INTEGER,g=0,d=t[0]-u,p=0,w=0,y=0,b=0,x=0,v=0,M=0,E=0,A=0;t:for(;;){if(m>=d)throw new Error("x must be a growing series");for(m<=c&&c<=d&&(A=ee(0,c-m,y,g),x=w+A);d-h>=0;){if(A=ee(0,h-m,y,g),v=w+A,l[E++]=(v-x)/i,E===o)break t;c=h,h+=i,x=v}w+=ee(m,d,y,b),m=d,g=p,M<s?(d=t[M],p=e[M],M++):M===s&&(d+=f,p=0),y=re(m,g,d,p),b=-y*m+g}return l}(t,e,r,n,o));return{x:Array.from(yt({from:r,to:n,length:o})),y:i}}function se(t,e={}){const{x:r,y:n}=t;if(0===r.length)return{x:Array.from(r),y:Array.from(n)};const{from:o=r[0],to:s=r.at(-1),zones:i=[{from:o,to:s}],exclusions:a=[]}=e,l=te(i,{from:o,to:s,exclusions:a});let u=0;const f=[],c=[];let h=0;for(;h<r.length;){if(r[h]<=l[u].to&&r[h]>=l[u].from)f.push(r[h]),c.push(n[h]);else if(r[h]>l[u].to&&(u++,!l[u]))break;h++}return{x:f,y:c}}function ie(t){const{x:e,y:r}=t;if(e.length!==r.length)throw new TypeError("length of x and y must be identical");return e.length<2||e[0]<e.at(-1)?t:{x:e.toReversed(),y:r.toReversed()}}function ae(t,e={}){Kt(t,{minLength:1});const{x:r,y:n}=t;if(1===r.length)return 0;const{fromIndex:o,toIndex:s}=f(r,e);let i=0;for(let t=o;t<s;t++)i+=(r[t+1]-r[t])*(n[t+1]+n[t])/2;return i}function le(t,e={}){Kt(t,{minLength:1});const{x:r,y:n}=t;if(1===r.length)return{x:r[0],y:n[0],index:0};const{fromIndex:o,toIndex:s}=f(r,e);let i={x:r[o],y:n[o],index:o};for(let t=o;t<=s;t++)n[t]<i.y&&(i={x:r[t],y:n[t],index:t});return i}function ue(t,e={}){if(Kt(t),0===t.x.length)return{x:[],y:[]};const{algorithm:r="average",isSorted:n=!0}=e;switch(n||(t=function(t){const{x:e,y:r}=t;if(Mt(e)&&e.length>1){const t=Float64Array.from(e),n=Float64Array.from(r);return t.at(-1)<t[0]&&(t.reverse(),n.reverse()),{x:t,y:n}}const n=Array.from(e,(t,e)=>({x:t,y:r[e]})).sort((t,e)=>t.x-e.x),o={x:new Float64Array(e.length),y:new Float64Array(r.length)};for(let t=0;t<e.length;t++)o.x[t]=n[t].x,o.y[t]=n[t].y;return o}(t)),r){case"average":return function(t){const e=[],r=[];let n=t.y[0],o=1;for(let s=1;s<t.x.length;s++)t.x[s]!==t.x[s-1]&&(e.push(t.x[s-1]),r.push(n/o),n=0,o=0),n+=t.y[s],o++;return e.push(t.x.at(-1)),r.push(n/o),{x:e,y:r}}(t);case"sum":return function(t){const e=[],r=[];let n=t.y[0];for(let o=1;o<t.x.length;o++)t.x[o]!==t.x[o-1]&&(e.push(t.x[o-1]),r.push(n),n=0),n+=t.y[o];return e.push(t.x.at(-1)),r.push(n),{x:e,y:r}}(t);default:throw new Error(`unknown algorithm: ${String(r)}`)}}const{min:fe,max:ce}=Math;var he=(t,e=0,r=1)=>fe(ce(e,t),r),me=t=>{t._clipped=!1,t._unclipped=t.slice(0);for(let e=0;e<=3;e++)e<3?((t[e]<0||t[e]>255)&&(t._clipped=!0),t[e]=he(t[e],0,255)):3===e&&(t[e]=he(t[e],0,1));return t};const ge={};for(let t of["Boolean","Number","String","Function","Array","Date","RegExp","Undefined","Null"])ge[`[object ${t}]`]=t.toLowerCase();function de(t){return ge[Object.prototype.toString.call(t)]||"object"}var pe=(t,e=null)=>t.length>=3?Array.prototype.slice.call(t):"object"==de(t[0])&&e?e.split("").filter(e=>void 0!==t[0][e]).map(e=>t[0][e]):t[0].slice(0),we=t=>{if(t.length<2)return null;const e=t.length-1;return"string"==de(t[e])?t[e].toLowerCase():null};const{PI:ye,min:be,max:xe}=Math,ve=t=>Math.round(100*t)/100,Me=t=>Math.round(100*t)/100,Ee=2*ye,Ae=ye/3,Ie=ye/180,Se=180/ye;function Ne(t){return[...t.slice(0,3).reverse(),...t.slice(3)]}var _e={format:{},autodetect:[]};class ke{constructor(...t){const e=this;if("object"===de(t[0])&&t[0].constructor&&t[0].constructor===this.constructor)return t[0];let r=we(t),n=!1;if(!r){n=!0,_e.sorted||(_e.autodetect=_e.autodetect.sort((t,e)=>e.p-t.p),_e.sorted=!0);for(let e of _e.autodetect)if(r=e.test(...t),r)break}if(!_e.format[r])throw new Error("unknown format: "+t);{const o=_e.format[r].apply(null,n?t:t.slice(0,-1));e._rgb=me(o)}3===e._rgb.length&&e._rgb.push(1)}toString(){return"function"==de(this.hex)?this.hex():`[${this._rgb.join(",")}]`}}const Te=(...t)=>new ke(...t);Te.version="3.1.2";const Re={aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000000",blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkgrey:"#a9a9a9",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkslategrey:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dimgrey:"#696969",dodgerblue:"#1e90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenyellow:"#adff2f",grey:"#808080",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",laserlemon:"#ffff54",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrod:"#fafad2",lightgoldenrodyellow:"#fafad2",lightgray:"#d3d3d3",lightgreen:"#90ee90",lightgrey:"#d3d3d3",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslategray:"#778899",lightslategrey:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",maroon2:"#7f0000",maroon3:"#b03060",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370db",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#db7093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",purple2:"#7f007f",purple3:"#a020f0",rebeccapurple:"#663399",red:"#ff0000",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",slategrey:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#ffffff",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32"},Ce=/^#?([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/,Fe=/^#?([A-Fa-f0-9]{8}|[A-Fa-f0-9]{4})$/,ze=t=>{if(t.match(Ce)){4!==t.length&&7!==t.length||(t=t.substr(1)),3===t.length&&(t=(t=t.split(""))[0]+t[0]+t[1]+t[1]+t[2]+t[2]);const e=parseInt(t,16);return[e>>16,e>>8&255,255&e,1]}if(t.match(Fe)){5!==t.length&&9!==t.length||(t=t.substr(1)),4===t.length&&(t=(t=t.split(""))[0]+t[0]+t[1]+t[1]+t[2]+t[2]+t[3]+t[3]);const e=parseInt(t,16);return[e>>24&255,e>>16&255,e>>8&255,Math.round((255&e)/255*100)/100]}throw new Error(`unknown hex color: ${t}`)},{round:Be}=Math,Le=(...t)=>{let[e,r,n,o]=pe(t,"rgba"),s=we(t)||"auto";void 0===o&&(o=1),"auto"===s&&(s=o<1?"rgba":"rgb"),e=Be(e),r=Be(r),n=Be(n);let i="000000"+(e<<16|r<<8|n).toString(16);i=i.substr(i.length-6);let a="0"+Be(255*o).toString(16);switch(a=a.substr(a.length-2),s.toLowerCase()){case"rgba":return`#${i}${a}`;case"argb":return`#${a}${i}`;default:return`#${i}`}};ke.prototype.name=function(){const t=Le(this._rgb,"rgb");for(let e of Object.keys(Re))if(Re[e]===t)return e.toLowerCase();return t},_e.format.named=t=>{if(t=t.toLowerCase(),Re[t])return ze(Re[t]);throw new Error("unknown color name: "+t)},_e.autodetect.push({p:5,test:(t,...e)=>{if(!e.length&&"string"===de(t)&&Re[t.toLowerCase()])return"named"}}),ke.prototype.alpha=function(t,e=!1){return void 0!==t&&"number"===de(t)?e?(this._rgb[3]=t,this):new ke([this._rgb[0],this._rgb[1],this._rgb[2],t],"rgb"):this._rgb[3]},ke.prototype.clipped=function(){return this._rgb._clipped||!1};const Oe={Kn:18,labWhitePoint:"d65",Xn:.95047,Yn:1,Zn:1.08883,kE:216/24389,kKE:8,kK:24389/27,RefWhiteRGB:{X:.95047,Y:1,Z:1.08883},MtxRGB2XYZ:{m00:.4124564390896922,m01:.21267285140562253,m02:.0193338955823293,m10:.357576077643909,m11:.715152155287818,m12:.11919202588130297,m20:.18043748326639894,m21:.07217499330655958,m22:.9503040785363679},MtxXYZ2RGB:{m00:3.2404541621141045,m01:-.9692660305051868,m02:.055643430959114726,m10:-1.5371385127977166,m11:1.8760108454466942,m12:-.2040259135167538,m20:-.498531409556016,m21:.041556017530349834,m22:1.0572251882231791},As:.9414285350000001,Bs:1.040417467,Cs:1.089532651,MtxAdaptMa:{m00:.8951,m01:-.7502,m02:.0389,m10:.2664,m11:1.7135,m12:-.0685,m20:-.1614,m21:.0367,m22:1.0296},MtxAdaptMaI:{m00:.9869929054667123,m01:.43230526972339456,m02:-.008528664575177328,m10:-.14705425642099013,m11:.5183602715367776,m12:.04004282165408487,m20:.15996265166373125,m21:.0492912282128556,m22:.9684866957875502}},Pe=new Map([["a",[1.0985,.35585]],["b",[1.0985,.35585]],["c",[.98074,1.18232]],["d50",[.96422,.82521]],["d55",[.95682,.92149]],["d65",[.95047,1.08883]],["e",[1,1,1]],["f2",[.99186,.67393]],["f7",[.95041,1.08747]],["f11",[1.00962,.6435]],["icc",[.96422,.82521]]]);function $e(t){const e=Pe.get(String(t).toLowerCase());if(!e)throw new Error("unknown Lab illuminant "+t);Oe.labWhitePoint=t,Oe.Xn=e[0],Oe.Zn=e[1]}function je(){return Oe.labWhitePoint}const De=(...t)=>{t=pe(t,"lab");const[e,r,n]=t,[o,s,i]=Xe(e,r,n),[a,l,u]=Ue(o,s,i);return[a,l,u,t.length>3?t[3]:1]},Xe=(t,e,r)=>{const{kE:n,kK:o,kKE:s,Xn:i,Yn:a,Zn:l}=Oe,u=(t+16)/116,f=.002*e+u,c=u-.005*r,h=f*f*f,m=c*c*c;return[(h>n?h:(116*f-16)/o)*i,(t>s?Math.pow((t+16)/116,3):t/o)*a,(m>n?m:(116*c-16)/o)*l]},Ye=t=>{const e=Math.sign(t);return((t=Math.abs(t))<=.0031308?12.92*t:1.055*Math.pow(t,1/2.4)-.055)*e},Ue=(t,e,r)=>{const{MtxAdaptMa:n,MtxAdaptMaI:o,MtxXYZ2RGB:s,RefWhiteRGB:i,Xn:a,Yn:l,Zn:u}=Oe,f=a*n.m00+l*n.m10+u*n.m20,c=a*n.m01+l*n.m11+u*n.m21,h=a*n.m02+l*n.m12+u*n.m22,m=i.X*n.m00+i.Y*n.m10+i.Z*n.m20,g=i.X*n.m01+i.Y*n.m11+i.Z*n.m21,d=i.X*n.m02+i.Y*n.m12+i.Z*n.m22,p=(t*n.m00+e*n.m10+r*n.m20)*(m/f),w=(t*n.m01+e*n.m11+r*n.m21)*(g/c),y=(t*n.m02+e*n.m12+r*n.m22)*(d/h),b=p*o.m00+w*o.m10+y*o.m20,x=p*o.m01+w*o.m11+y*o.m21,v=p*o.m02+w*o.m12+y*o.m22;return[255*Ye(b*s.m00+x*s.m10+v*s.m20),255*Ye(b*s.m01+x*s.m11+v*s.m21),255*Ye(b*s.m02+x*s.m12+v*s.m22)]},Ve=(...t)=>{const[e,r,n,...o]=pe(t,"rgb"),[s,i,a]=Ge(e,r,n),[l,u,f]=function(t,e,r){const{Xn:n,Yn:o,Zn:s,kE:i,kK:a}=Oe,l=t/n,u=e/o,f=r/s,c=l>i?Math.pow(l,1/3):(a*l+16)/116,h=u>i?Math.pow(u,1/3):(a*u+16)/116,m=f>i?Math.pow(f,1/3):(a*f+16)/116;return[116*h-16,500*(c-h),200*(h-m)]}(s,i,a);return[l,u,f,...o.length>0&&o[0]<1?[o[0]]:[]]};function qe(t){const e=Math.sign(t);return((t=Math.abs(t))<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4))*e}const Ge=(t,e,r)=>{t=qe(t/255),e=qe(e/255),r=qe(r/255);const{MtxRGB2XYZ:n,MtxAdaptMa:o,MtxAdaptMaI:s,Xn:i,Yn:a,Zn:l,As:u,Bs:f,Cs:c}=Oe;let h=t*n.m00+e*n.m10+r*n.m20,m=t*n.m01+e*n.m11+r*n.m21,g=t*n.m02+e*n.m12+r*n.m22;const d=i*o.m00+a*o.m10+l*o.m20,p=i*o.m01+a*o.m11+l*o.m21,w=i*o.m02+a*o.m12+l*o.m22;let y=h*o.m00+m*o.m10+g*o.m20,b=h*o.m01+m*o.m11+g*o.m21,x=h*o.m02+m*o.m12+g*o.m22;return y*=d/u,b*=p/f,x*=w/c,h=y*s.m00+b*s.m10+x*s.m20,m=y*s.m01+b*s.m11+x*s.m21,g=y*s.m02+b*s.m12+x*s.m22,[h,m,g]};ke.prototype.lab=function(){return Ve(this._rgb)};Object.assign(Te,{lab:(...t)=>new ke(...t,"lab"),getLabWhitePoint:je,setLabWhitePoint:$e}),_e.format.lab=De,_e.autodetect.push({p:2,test:(...t)=>{if("array"===de(t=pe(t,"lab"))&&3===t.length)return"lab"}}),ke.prototype.darken=function(t=1){const e=this.lab();return e[0]-=Oe.Kn*t,new ke(e,"lab").alpha(this.alpha(),!0)},ke.prototype.brighten=function(t=1){return this.darken(-t)},ke.prototype.darker=ke.prototype.darken,ke.prototype.brighter=ke.prototype.brighten,ke.prototype.get=function(t){const[e,r]=t.split("."),n=this[e]();if(r){const t=e.indexOf(r)-("ok"===e.substr(0,2)?2:0);if(t>-1)return n[t];throw new Error(`unknown channel ${r} in mode ${e}`)}return n};const{pow:We}=Math;ke.prototype.luminance=function(t,e="rgb"){if(void 0!==t&&"number"===de(t)){if(0===t)return new ke([0,0,0,this._rgb[3]],"rgb");if(1===t)return new ke([255,255,255,this._rgb[3]],"rgb");let r=this.luminance(),n=20;const o=(r,s)=>{const i=r.interpolate(s,.5,e),a=i.luminance();return Math.abs(t-a)<1e-7||!n--?i:a>t?o(r,i):o(i,s)},s=(r>t?o(new ke([0,0,0]),this):o(this,new ke([255,255,255]))).rgb();return new ke([...s,this._rgb[3]])}return He(...this._rgb.slice(0,3))};const He=(t,e,r)=>.2126*(t=Ze(t))+.7152*(e=Ze(e))+.0722*(r=Ze(r)),Ze=t=>(t/=255)<=.03928?t/12.92:We((t+.055)/1.055,2.4);var Ke={},Je=(t,e,r=.5,...n)=>{let o=n[0]||"lrgb";if(Ke[o]||n.length||(o=Object.keys(Ke)[0]),!Ke[o])throw new Error(`interpolation mode ${o} is not defined`);return"object"!==de(t)&&(t=new ke(t)),"object"!==de(e)&&(e=new ke(e)),Ke[o](t,e,r).alpha(t.alpha()+r*(e.alpha()-t.alpha()))};ke.prototype.mix=ke.prototype.interpolate=function(t,e=.5,...r){return Je(this,t,e,...r)},ke.prototype.premultiply=function(t=!1){const e=this._rgb,r=e[3];return t?(this._rgb=[e[0]*r,e[1]*r,e[2]*r,r],this):new ke([e[0]*r,e[1]*r,e[2]*r,r],"rgb")};const{sin:Qe,cos:tr}=Math,er=(...t)=>{let[e,r,n]=pe(t,"lch");return isNaN(n)&&(n=0),n*=Ie,[e,tr(n)*r,Qe(n)*r]},rr=(...t)=>{t=pe(t,"lch");const[e,r,n]=t,[o,s,i]=er(e,r,n),[a,l,u]=De(o,s,i);return[a,l,u,t.length>3?t[3]:1]},{sqrt:nr,atan2:or,round:sr}=Math,ir=(...t)=>{const[e,r,n]=pe(t,"lab"),o=nr(r*r+n*n);let s=(or(n,r)*Se+360)%360;return 0===sr(1e4*o)&&(s=Number.NaN),[e,o,s]},ar=(...t)=>{const[e,r,n,...o]=pe(t,"rgb"),[s,i,a]=Ve(e,r,n),[l,u,f]=ir(s,i,a);return[l,u,f,...o.length>0&&o[0]<1?[o[0]]:[]]};ke.prototype.lch=function(){return ar(this._rgb)},ke.prototype.hcl=function(){return Ne(ar(this._rgb))};Object.assign(Te,{lch:(...t)=>new ke(...t,"lch"),hcl:(...t)=>new ke(...t,"hcl")}),_e.format.lch=rr,_e.format.hcl=(...t)=>{const e=Ne(pe(t,"hcl"));return rr(...e)},["lch","hcl"].forEach(t=>_e.autodetect.push({p:2,test:(...e)=>{if("array"===de(e=pe(e,t))&&3===e.length)return t}})),ke.prototype.saturate=function(t=1){const e=this.lch();return e[1]+=Oe.Kn*t,e[1]<0&&(e[1]=0),new ke(e,"lch").alpha(this.alpha(),!0)},ke.prototype.desaturate=function(t=1){return this.saturate(-t)},ke.prototype.set=function(t,e,r=!1){const[n,o]=t.split("."),s=this[n]();if(o){const t=n.indexOf(o)-("ok"===n.substr(0,2)?2:0);if(t>-1){if("string"==de(e))switch(e.charAt(0)){case"+":case"-":s[t]+=+e;break;case"*":s[t]*=+e.substr(1);break;case"/":s[t]/=+e.substr(1);break;default:s[t]=+e}else{if("number"!==de(e))throw new Error("unsupported value for Color.set");s[t]=e}const o=new ke(s,n);return r?(this._rgb=o._rgb,this):o}throw new Error(`unknown channel ${o} in mode ${n}`)}return s},ke.prototype.tint=function(t=.5,...e){return Je(this,"white",t,...e)},ke.prototype.shade=function(t=.5,...e){return Je(this,"black",t,...e)};Ke.rgb=(t,e,r)=>{const n=t._rgb,o=e._rgb;return new ke(n[0]+r*(o[0]-n[0]),n[1]+r*(o[1]-n[1]),n[2]+r*(o[2]-n[2]),"rgb")};const{sqrt:lr,pow:ur}=Math;Ke.lrgb=(t,e,r)=>{const[n,o,s]=t._rgb,[i,a,l]=e._rgb;return new ke(lr(ur(n,2)*(1-r)+ur(i,2)*r),lr(ur(o,2)*(1-r)+ur(a,2)*r),lr(ur(s,2)*(1-r)+ur(l,2)*r),"rgb")};Ke.lab=(t,e,r)=>{const n=t.lab(),o=e.lab();return new ke(n[0]+r*(o[0]-n[0]),n[1]+r*(o[1]-n[1]),n[2]+r*(o[2]-n[2]),"lab")};var fr=(t,e,r,n)=>{let o,s,i,a,l,u,f,c,h,m,g,d;return"hsl"===n?(o=t.hsl(),s=e.hsl()):"hsv"===n?(o=t.hsv(),s=e.hsv()):"hcg"===n?(o=t.hcg(),s=e.hcg()):"hsi"===n?(o=t.hsi(),s=e.hsi()):"lch"===n||"hcl"===n?(n="hcl",o=t.hcl(),s=e.hcl()):"oklch"===n&&(o=t.oklch().reverse(),s=e.oklch().reverse()),"h"!==n.substr(0,1)&&"oklch"!==n||([i,l,f]=o,[a,u,c]=s),isNaN(i)||isNaN(a)?isNaN(i)?isNaN(a)?m=Number.NaN:(m=a,1!=f&&0!=f||"hsv"==n||(h=u)):(m=i,1!=c&&0!=c||"hsv"==n||(h=l)):(d=a>i&&a-i>180?a-(i+360):a<i&&i-a>180?a+360-i:a-i,m=i+r*d),void 0===h&&(h=l+r*(u-l)),g=f+r*(c-f),new ke("oklch"===n?[g,h,m]:[m,h,g],n)};const cr=(t,e,r)=>fr(t,e,r,"lch");Ke.lch=cr,Ke.hcl=cr;ke.prototype.num=function(){return((...t)=>{const[e,r,n]=pe(t,"rgb");return(e<<16)+(r<<8)+n})(this._rgb)};Object.assign(Te,{num:(...t)=>new ke(...t,"num")}),_e.format.num=t=>{if("number"==de(t)&&t>=0&&t<=16777215){return[t>>16,t>>8&255,255&t,1]}throw new Error("unknown num color: "+t)},_e.autodetect.push({p:5,test:(...t)=>{if(1===t.length&&"number"===de(t[0])&&t[0]>=0&&t[0]<=16777215)return"num"}});Ke.num=(t,e,r)=>{const n=t.num(),o=e.num();return new ke(n+r*(o-n),"num")};const{floor:hr}=Math;ke.prototype.hcg=function(){return((...t)=>{const[e,r,n]=pe(t,"rgb"),o=be(e,r,n),s=xe(e,r,n),i=s-o,a=100*i/255,l=o/(255-i)*100;let u;return 0===i?u=Number.NaN:(e===s&&(u=(r-n)/i),r===s&&(u=2+(n-e)/i),n===s&&(u=4+(e-r)/i),u*=60,u<0&&(u+=360)),[u,a,l]})(this._rgb)};Te.hcg=(...t)=>new ke(...t,"hcg"),_e.format.hcg=(...t)=>{t=pe(t,"hcg");let e,r,n,[o,s,i]=t;i*=255;const a=255*s;if(0===s)e=r=n=i;else{360===o&&(o=0),o>360&&(o-=360),o<0&&(o+=360),o/=60;const t=hr(o),l=o-t,u=i*(1-s),f=u+a*(1-l),c=u+a*l,h=u+a;switch(t){case 0:[e,r,n]=[h,c,u];break;case 1:[e,r,n]=[f,h,u];break;case 2:[e,r,n]=[u,h,c];break;case 3:[e,r,n]=[u,f,h];break;case 4:[e,r,n]=[c,u,h];break;case 5:[e,r,n]=[h,u,f]}}return[e,r,n,t.length>3?t[3]:1]},_e.autodetect.push({p:1,test:(...t)=>{if("array"===de(t=pe(t,"hcg"))&&3===t.length)return"hcg"}});Ke.hcg=(t,e,r)=>fr(t,e,r,"hcg");const{cos:mr}=Math,{min:gr,sqrt:dr,acos:pr}=Math;ke.prototype.hsi=function(){return((...t)=>{let e,[r,n,o]=pe(t,"rgb");r/=255,n/=255,o/=255;const s=gr(r,n,o),i=(r+n+o)/3,a=i>0?1-s/i:0;return 0===a?e=NaN:(e=(r-n+(r-o))/2,e/=dr((r-n)*(r-n)+(r-o)*(n-o)),e=pr(e),o>n&&(e=Ee-e),e/=Ee),[360*e,a,i]})(this._rgb)};Te.hsi=(...t)=>new ke(...t,"hsi"),_e.format.hsi=(...t)=>{t=pe(t,"hsi");let e,r,n,[o,s,i]=t;return isNaN(o)&&(o=0),isNaN(s)&&(s=0),o>360&&(o-=360),o<0&&(o+=360),o/=360,o<1/3?(n=(1-s)/3,e=(1+s*mr(Ee*o)/mr(Ae-Ee*o))/3,r=1-(n+e)):o<2/3?(o-=1/3,e=(1-s)/3,r=(1+s*mr(Ee*o)/mr(Ae-Ee*o))/3,n=1-(e+r)):(o-=2/3,r=(1-s)/3,n=(1+s*mr(Ee*o)/mr(Ae-Ee*o))/3,e=1-(r+n)),e=he(i*e*3),r=he(i*r*3),n=he(i*n*3),[255*e,255*r,255*n,t.length>3?t[3]:1]},_e.autodetect.push({p:2,test:(...t)=>{if("array"===de(t=pe(t,"hsi"))&&3===t.length)return"hsi"}});Ke.hsi=(t,e,r)=>fr(t,e,r,"hsi");const wr=(...t)=>{t=pe(t,"hsl");const[e,r,n]=t;let o,s,i;if(0===r)o=s=i=255*n;else{const t=[0,0,0],a=[0,0,0],l=n<.5?n*(1+r):n+r-n*r,u=2*n-l,f=e/360;t[0]=f+1/3,t[1]=f,t[2]=f-1/3;for(let e=0;e<3;e++)t[e]<0&&(t[e]+=1),t[e]>1&&(t[e]-=1),6*t[e]<1?a[e]=u+6*(l-u)*t[e]:2*t[e]<1?a[e]=l:3*t[e]<2?a[e]=u+(l-u)*(2/3-t[e])*6:a[e]=u;[o,s,i]=[255*a[0],255*a[1],255*a[2]]}return t.length>3?[o,s,i,t[3]]:[o,s,i,1]},yr=(...t)=>{t=pe(t,"rgba");let[e,r,n]=t;e/=255,r/=255,n/=255;const o=be(e,r,n),s=xe(e,r,n),i=(s+o)/2;let a,l;return s===o?(a=0,l=Number.NaN):a=i<.5?(s-o)/(s+o):(s-o)/(2-s-o),e==s?l=(r-n)/(s-o):r==s?l=2+(n-e)/(s-o):n==s&&(l=4+(e-r)/(s-o)),l*=60,l<0&&(l+=360),t.length>3&&void 0!==t[3]?[l,a,i,t[3]]:[l,a,i]};ke.prototype.hsl=function(){return yr(this._rgb)};Te.hsl=(...t)=>new ke(...t,"hsl"),_e.format.hsl=wr,_e.autodetect.push({p:2,test:(...t)=>{if("array"===de(t=pe(t,"hsl"))&&3===t.length)return"hsl"}});Ke.hsl=(t,e,r)=>fr(t,e,r,"hsl");const{floor:br}=Math,{min:xr,max:vr}=Math;ke.prototype.hsv=function(){return((...t)=>{t=pe(t,"rgb");let[e,r,n]=t;const o=xr(e,r,n),s=vr(e,r,n),i=s-o;let a,l,u;return u=s/255,0===s?(a=Number.NaN,l=0):(l=i/s,e===s&&(a=(r-n)/i),r===s&&(a=2+(n-e)/i),n===s&&(a=4+(e-r)/i),a*=60,a<0&&(a+=360)),[a,l,u]})(this._rgb)};Te.hsv=(...t)=>new ke(...t,"hsv"),_e.format.hsv=(...t)=>{t=pe(t,"hsv");let e,r,n,[o,s,i]=t;if(i*=255,0===s)e=r=n=i;else{360===o&&(o=0),o>360&&(o-=360),o<0&&(o+=360),o/=60;const t=br(o),a=o-t,l=i*(1-s),u=i*(1-s*a),f=i*(1-s*(1-a));switch(t){case 0:[e,r,n]=[i,f,l];break;case 1:[e,r,n]=[u,i,l];break;case 2:[e,r,n]=[l,i,f];break;case 3:[e,r,n]=[l,u,i];break;case 4:[e,r,n]=[f,l,i];break;case 5:[e,r,n]=[i,l,u]}}return[e,r,n,t.length>3?t[3]:1]},_e.autodetect.push({p:2,test:(...t)=>{if("array"===de(t=pe(t,"hsv"))&&3===t.length)return"hsv"}});function Mr(t,e){let r=t.length;Array.isArray(t[0])||(t=[t]),Array.isArray(e[0])||(e=e.map(t=>[t]));let n=e[0].length,o=e[0].map((t,r)=>e.map(t=>t[r])),s=t.map(t=>o.map(e=>Array.isArray(t)?t.reduce((t,r,n)=>t+r*(e[n]||0),0):e.reduce((e,r)=>e+r*t,0)));return 1===r&&(s=s[0]),1===n?s.map(t=>t[0]):s}Ke.hsv=(t,e,r)=>fr(t,e,r,"hsv");const Er=(...t)=>{t=pe(t,"lab");const[e,r,n,...o]=t,[s,i,a]=(l=[[1.2268798758459243,-.5578149944602171,.2813910456659647],[-.0405757452148008,1.112286803280317,-.0717110580655164],[-.0763729366746601,-.4214933324022432,1.5869240198367816]],u=Mr([[1,.3963377773761749,.2158037573099136],[1,-.1055613458156586,-.0638541728258133],[1,-.0894841775298119,-1.2914855480194092]],[e,r,n]),Mr(l,u.map(t=>t**3)));var l,u;const[f,c,h]=Ue(s,i,a);return[f,c,h,...o.length>0&&o[0]<1?[o[0]]:[]]};const Ar=(...t)=>{const[e,r,n,...o]=pe(t,"rgb");return[...function(t){const e=[[.210454268309314,.7936177747023054,-.0040720430116193],[1.9779985324311684,-2.42859224204858,.450593709617411],[.0259040424655478,.7827717124575296,-.8086757549230774]],r=Mr([[.819022437996703,.3619062600528904,-.1288737815209879],[.0329836539323885,.9292868615863434,.0361446663506424],[.0481771893596242,.2642395317527308,.6335478284694309]],t);return Mr(e,r.map(t=>Math.cbrt(t)))}(Ge(e,r,n)),...o.length>0&&o[0]<1?[o[0]]:[]]};ke.prototype.oklab=function(){return Ar(this._rgb)};Object.assign(Te,{oklab:(...t)=>new ke(...t,"oklab")}),_e.format.oklab=Er,_e.autodetect.push({p:2,test:(...t)=>{if("array"===de(t=pe(t,"oklab"))&&3===t.length)return"oklab"}});Ke.oklab=(t,e,r)=>{const n=t.oklab(),o=e.oklab();return new ke(n[0]+r*(o[0]-n[0]),n[1]+r*(o[1]-n[1]),n[2]+r*(o[2]-n[2]),"oklab")};Ke.oklch=(t,e,r)=>fr(t,e,r,"oklch");const{pow:Ir,sqrt:Sr,PI:Nr,cos:_r,sin:kr,atan2:Tr}=Math;const Rr=(t,e)=>{const r=t.length,n=[0,0,0,0];for(let o=0;o<t.length;o++){const s=t[o],i=e[o]/r,a=s._rgb;n[0]+=Ir(a[0],2)*i,n[1]+=Ir(a[1],2)*i,n[2]+=Ir(a[2],2)*i,n[3]+=a[3]*i}return n[0]=Sr(n[0]),n[1]=Sr(n[1]),n[2]=Sr(n[2]),n[3]>.9999999&&(n[3]=1),new ke(me(n))},{pow:Cr}=Math;function Fr(t){let e="rgb",r=Te("#ccc"),n=0,o=[0,1],s=[],i=[0,0],a=!1,l=[],u=!1,f=0,c=1,h=!1,m={},g=!0,d=1;const p=function(t){if((t=t||["#fff","#000"])&&"string"===de(t)&&Te.brewer&&Te.brewer[t.toLowerCase()]&&(t=Te.brewer[t.toLowerCase()]),"array"===de(t)){1===t.length&&(t=[t[0],t[0]]),t=t.slice(0);for(let e=0;e<t.length;e++)t[e]=Te(t[e]);s.length=0;for(let e=0;e<t.length;e++)s.push(e/(t.length-1))}return x(),l=t};let w=t=>t,y=t=>t;const b=function(t,n){let o,u;if(null==n&&(n=!1),isNaN(t)||null===t)return r;if(n)u=t;else if(a&&a.length>2){u=function(t){if(null!=a){const e=a.length-1;let r=0;for(;r<e&&t>=a[r];)r++;return r-1}return 0}(t)/(a.length-2)}else u=c!==f?(t-f)/(c-f):1;u=y(u),n||(u=w(u)),1!==d&&(u=Cr(u,d)),u=i[0]+u*(1-i[0]-i[1]),u=he(u,0,1);const h=Math.floor(1e4*u);if(g&&m[h])o=m[h];else{if("array"===de(l))for(let t=0;t<s.length;t++){const r=s[t];if(u<=r){o=l[t];break}if(u>=r&&t===s.length-1){o=l[t];break}if(u>r&&u<s[t+1]){u=(u-r)/(s[t+1]-r),o=Te.interpolate(l[t],l[t+1],u,e);break}}else"function"===de(l)&&(o=l(u));g&&(m[h]=o)}return o};var x=()=>m={};p(t);const v=function(t){const e=Te(b(t));return u&&e[u]?e[u]():e};return v.classes=function(t){if(null!=t){if("array"===de(t))a=t,o=[t[0],t[t.length-1]];else{const e=Te.analyze(o);a=0===t?[e.min,e.max]:Te.limits(e,"e",t)}return v}return a},v.domain=function(t){if(!arguments.length)return o;f=t[0],c=t[t.length-1],s=[];const e=l.length;if(t.length===e&&f!==c)for(let e of Array.from(t))s.push((e-f)/(c-f));else{for(let t=0;t<e;t++)s.push(t/(e-1));if(t.length>2){const e=t.map((e,r)=>r/(t.length-1)),r=t.map(t=>(t-f)/(c-f));r.every((t,r)=>e[r]===t)||(y=t=>{if(t<=0||t>=1)return t;let n=0;for(;t>=r[n+1];)n++;const o=(t-r[n])/(r[n+1]-r[n]);return e[n]+o*(e[n+1]-e[n])})}}return o=[f,c],v},v.mode=function(t){return arguments.length?(e=t,x(),v):e},v.range=function(t,e){return p(t),v},v.out=function(t){return u=t,v},v.spread=function(t){return arguments.length?(n=t,v):n},v.correctLightness=function(t){return null==t&&(t=!0),h=t,x(),w=h?function(t){const e=b(0,!0).lab()[0],r=b(1,!0).lab()[0],n=e>r;let o=b(t,!0).lab()[0];const s=e+(r-e)*t;let i=o-s,a=0,l=1,u=20;for(;Math.abs(i)>.01&&u-- >0;)(function(){n&&(i*=-1),i<0?(a=t,t+=.5*(l-t)):(l=t,t+=.5*(a-t)),o=b(t,!0).lab()[0],i=o-s})();return t}:t=>t,v},v.padding=function(t){return null!=t?("number"===de(t)&&(t=[t,t]),i=t,v):i},v.colors=function(e,r){arguments.length<2&&(r="hex");let n=[];if(0===arguments.length)n=l.slice(0);else if(1===e)n=[v(.5)];else if(e>1){const t=o[0],r=o[1]-t;n=function(t,e){let r=[],n=t<e,o=e;for(let e=t;n?e<o:e>o;n?e++:e--)r.push(e);return r}(0,e).map(n=>v(t+n/(e-1)*r))}else{t=[];let e=[];if(a&&a.length>2)for(let t=1,r=a.length,n=1<=r;n?t<r:t>r;n?t++:t--)e.push(.5*(a[t-1]+a[t]));else e=o;n=e.map(t=>v(t))}return Te[r]&&(n=n.map(t=>t[r]())),n},v.cache=function(t){return null!=t?(g=t,v):g},v.gamma=function(t){return null!=t?(d=t,v):d},v.nodata=function(t){return null!=t?(r=Te(t),v):r},v}const{round:zr}=Math;ke.prototype.rgb=function(t=!0){return!1===t?this._rgb.slice(0,3):this._rgb.slice(0,3).map(zr)},ke.prototype.rgba=function(t=!0){return this._rgb.slice(0,4).map((e,r)=>r<3?!1===t?e:zr(e):e)};Object.assign(Te,{rgb:(...t)=>new ke(...t,"rgb")}),_e.format.rgb=(...t)=>{const e=pe(t,"rgba");return void 0===e[3]&&(e[3]=1),e},_e.autodetect.push({p:3,test:(...t)=>{if("array"===de(t=pe(t,"rgba"))&&(3===t.length||4===t.length&&"number"==de(t[3])&&t[3]>=0&&t[3]<=1))return"rgb"}});const Br=(t,e,r)=>{if(!Br[r])throw new Error("unknown blend mode "+r);return Br[r](t,e)},Lr=t=>(e,r)=>{const n=Te(r).rgb(),o=Te(e).rgb();return Te.rgb(t(n,o))},Or=t=>(e,r)=>{const n=[];return n[0]=t(e[0],r[0]),n[1]=t(e[1],r[1]),n[2]=t(e[2],r[2]),n};Br.normal=Lr(Or(t=>t)),Br.multiply=Lr(Or((t,e)=>t*e/255)),Br.screen=Lr(Or((t,e)=>255*(1-(1-t/255)*(1-e/255)))),Br.overlay=Lr(Or((t,e)=>e<128?2*t*e/255:255*(1-2*(1-t/255)*(1-e/255)))),Br.darken=Lr(Or((t,e)=>t>e?e:t)),Br.lighten=Lr(Or((t,e)=>t>e?t:e)),Br.dodge=Lr(Or((t,e)=>255===t||(t=e/255*255/(1-t/255))>255?255:t)),Br.burn=Lr(Or((t,e)=>255*(1-(1-e/255)/(t/255))));const{pow:Pr,sin:$r,cos:jr}=Math;const{floor:Dr,random:Xr}=Math;const{log:Yr,pow:Ur,floor:Vr,abs:qr}=Math;function Gr(t,e=null){const r={min:Number.MAX_VALUE,max:-1*Number.MAX_VALUE,sum:0,values:[],count:0};return"object"===de(t)&&(t=Object.values(t)),t.forEach(t=>{e&&"object"===de(t)&&(t=t[e]),null==t||isNaN(t)||(r.values.push(t),r.sum+=t,t<r.min&&(r.min=t),t>r.max&&(r.max=t),r.count+=1)}),r.domain=[r.min,r.max],r.limits=(t,e)=>Wr(r,t,e),r}function Wr(t,e="equal",r=7){"array"==de(t)&&(t=Gr(t));const{min:n,max:o}=t,s=t.values.sort((t,e)=>t-e);if(1===r)return[n,o];const i=[];if("c"===e.substr(0,1)&&(i.push(n),i.push(o)),"e"===e.substr(0,1)){i.push(n);for(let t=1;t<r;t++)i.push(n+t/r*(o-n));i.push(o)}else if("l"===e.substr(0,1)){if(n<=0)throw new Error("Logarithmic scales are only possible for values > 0");const t=Math.LOG10E*Yr(n),e=Math.LOG10E*Yr(o);i.push(n);for(let n=1;n<r;n++)i.push(Ur(10,t+n/r*(e-t)));i.push(o)}else if("q"===e.substr(0,1)){i.push(n);for(let t=1;t<r;t++){const e=(s.length-1)*t/r,n=Vr(e);if(n===e)i.push(s[n]);else{const t=e-n;i.push(s[n]*(1-t)+s[n+1]*t)}}i.push(o)}else if("k"===e.substr(0,1)){let t;const e=s.length,a=new Array(e),l=new Array(r);let u=!0,f=0,c=null;c=[],c.push(n);for(let t=1;t<r;t++)c.push(n+t/r*(o-n));for(c.push(o);u;){for(let t=0;t<r;t++)l[t]=0;for(let t=0;t<e;t++){const e=s[t];let n,o=Number.MAX_VALUE;for(let s=0;s<r;s++){const r=qr(c[s]-e);r<o&&(o=r,n=s),l[n]++,a[t]=n}}const n=new Array(r);for(let t=0;t<r;t++)n[t]=null;for(let r=0;r<e;r++)t=a[r],null===n[t]?n[t]=s[r]:n[t]+=s[r];for(let t=0;t<r;t++)n[t]*=1/l[t];u=!1;for(let t=0;t<r;t++)if(n[t]!==c[t]){u=!0;break}c=n,f++,f>200&&(u=!1)}const h={};for(let t=0;t<r;t++)h[t]=[];for(let r=0;r<e;r++)t=a[r],h[t].push(s[r]);let m=[];for(let t=0;t<r;t++)m.push(h[t][0]),m.push(h[t][h[t].length-1]);m=m.sort((t,e)=>t-e),i.push(m[0]);for(let t=1;t<m.length;t+=2){const e=m[t];isNaN(e)||-1!==i.indexOf(e)||i.push(e)}}return i}const Hr=.022;function Zr(t,e,r){return.2126729*Math.pow(t/255,2.4)+.7151522*Math.pow(e/255,2.4)+.072175*Math.pow(r/255,2.4)}const{sqrt:Kr,pow:Jr,min:Qr,max:tn,atan2:en,abs:rn,cos:nn,sin:on,exp:sn,PI:an}=Math;var ln={cool:()=>Fr([Te.hsl(180,1,.9),Te.hsl(250,.7,.4)]),hot:()=>Fr(["#000","#f00","#ff0","#fff"]).mode("rgb")};const un={OrRd:["#fff7ec","#fee8c8","#fdd49e","#fdbb84","#fc8d59","#ef6548","#d7301f","#b30000","#7f0000"],PuBu:["#fff7fb","#ece7f2","#d0d1e6","#a6bddb","#74a9cf","#3690c0","#0570b0","#045a8d","#023858"],BuPu:["#f7fcfd","#e0ecf4","#bfd3e6","#9ebcda","#8c96c6","#8c6bb1","#88419d","#810f7c","#4d004b"],Oranges:["#fff5eb","#fee6ce","#fdd0a2","#fdae6b","#fd8d3c","#f16913","#d94801","#a63603","#7f2704"],BuGn:["#f7fcfd","#e5f5f9","#ccece6","#99d8c9","#66c2a4","#41ae76","#238b45","#006d2c","#00441b"],YlOrBr:["#ffffe5","#fff7bc","#fee391","#fec44f","#fe9929","#ec7014","#cc4c02","#993404","#662506"],YlGn:["#ffffe5","#f7fcb9","#d9f0a3","#addd8e","#78c679","#41ab5d","#238443","#006837","#004529"],Reds:["#fff5f0","#fee0d2","#fcbba1","#fc9272","#fb6a4a","#ef3b2c","#cb181d","#a50f15","#67000d"],RdPu:["#fff7f3","#fde0dd","#fcc5c0","#fa9fb5","#f768a1","#dd3497","#ae017e","#7a0177","#49006a"],Greens:["#f7fcf5","#e5f5e0","#c7e9c0","#a1d99b","#74c476","#41ab5d","#238b45","#006d2c","#00441b"],YlGnBu:["#ffffd9","#edf8b1","#c7e9b4","#7fcdbb","#41b6c4","#1d91c0","#225ea8","#253494","#081d58"],Purples:["#fcfbfd","#efedf5","#dadaeb","#bcbddc","#9e9ac8","#807dba","#6a51a3","#54278f","#3f007d"],GnBu:["#f7fcf0","#e0f3db","#ccebc5","#a8ddb5","#7bccc4","#4eb3d3","#2b8cbe","#0868ac","#084081"],Greys:["#ffffff","#f0f0f0","#d9d9d9","#bdbdbd","#969696","#737373","#525252","#252525","#000000"],YlOrRd:["#ffffcc","#ffeda0","#fed976","#feb24c","#fd8d3c","#fc4e2a","#e31a1c","#bd0026","#800026"],PuRd:["#f7f4f9","#e7e1ef","#d4b9da","#c994c7","#df65b0","#e7298a","#ce1256","#980043","#67001f"],Blues:["#f7fbff","#deebf7","#c6dbef","#9ecae1","#6baed6","#4292c6","#2171b5","#08519c","#08306b"],PuBuGn:["#fff7fb","#ece2f0","#d0d1e6","#a6bddb","#67a9cf","#3690c0","#02818a","#016c59","#014636"],Viridis:["#440154","#482777","#3f4a8a","#31678e","#26838f","#1f9d8a","#6cce5a","#b6de2b","#fee825"],Spectral:["#9e0142","#d53e4f","#f46d43","#fdae61","#fee08b","#ffffbf","#e6f598","#abdda4","#66c2a5","#3288bd","#5e4fa2"],RdYlGn:["#a50026","#d73027","#f46d43","#fdae61","#fee08b","#ffffbf","#d9ef8b","#a6d96a","#66bd63","#1a9850","#006837"],RdBu:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#f7f7f7","#d1e5f0","#92c5de","#4393c3","#2166ac","#053061"],PiYG:["#8e0152","#c51b7d","#de77ae","#f1b6da","#fde0ef","#f7f7f7","#e6f5d0","#b8e186","#7fbc41","#4d9221","#276419"],PRGn:["#40004b","#762a83","#9970ab","#c2a5cf","#e7d4e8","#f7f7f7","#d9f0d3","#a6dba0","#5aae61","#1b7837","#00441b"],RdYlBu:["#a50026","#d73027","#f46d43","#fdae61","#fee090","#ffffbf","#e0f3f8","#abd9e9","#74add1","#4575b4","#313695"],BrBG:["#543005","#8c510a","#bf812d","#dfc27d","#f6e8c3","#f5f5f5","#c7eae5","#80cdc1","#35978f","#01665e","#003c30"],RdGy:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#ffffff","#e0e0e0","#bababa","#878787","#4d4d4d","#1a1a1a"],PuOr:["#7f3b08","#b35806","#e08214","#fdb863","#fee0b6","#f7f7f7","#d8daeb","#b2abd2","#8073ac","#542788","#2d004b"],Set2:["#66c2a5","#fc8d62","#8da0cb","#e78ac3","#a6d854","#ffd92f","#e5c494","#b3b3b3"],Accent:["#7fc97f","#beaed4","#fdc086","#ffff99","#386cb0","#f0027f","#bf5b17","#666666"],Set1:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#ffff33","#a65628","#f781bf","#999999"],Set3:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5","#d9d9d9","#bc80bd","#ccebc5","#ffed6f"],Dark2:["#1b9e77","#d95f02","#7570b3","#e7298a","#66a61e","#e6ab02","#a6761d","#666666"],Paired:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00","#cab2d6","#6a3d9a","#ffff99","#b15928"],Pastel2:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4","#e6f5c9","#fff2ae","#f1e2cc","#cccccc"],Pastel1:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6","#ffffcc","#e5d8bd","#fddaec","#f2f2f2"]},fn=Object.keys(un),cn=new Map(fn.map(t=>[t.toLowerCase(),t])),hn="function"==typeof Proxy?new Proxy(un,{get(t,e){const r=e.toLowerCase();if(cn.has(r))return t[cn.get(r)]},getOwnPropertyNames:()=>Object.getOwnPropertyNames(fn)}):un,{max:mn}=Math;ke.prototype.cmyk=function(){return((...t)=>{let[e,r,n]=pe(t,"rgb");e/=255,r/=255,n/=255;const o=1-mn(e,mn(r,n)),s=o<1?1/(1-o):0;return[(1-e-o)*s,(1-r-o)*s,(1-n-o)*s,o]})(this._rgb)};Object.assign(Te,{cmyk:(...t)=>new ke(...t,"cmyk")}),_e.format.cmyk=(...t)=>{t=pe(t,"cmyk");const[e,r,n,o]=t,s=t.length>4?t[4]:1;return 1===o?[0,0,0,s]:[e>=1?0:255*(1-e)*(1-o),r>=1?0:255*(1-r)*(1-o),n>=1?0:255*(1-n)*(1-o),s]},_e.autodetect.push({p:2,test:(...t)=>{if("array"===de(t=pe(t,"cmyk"))&&4===t.length)return"cmyk"}});const gn=(...t)=>{const[e,r,n,...o]=pe(t,"rgb"),[s,i,a]=Ar(e,r,n),[l,u,f]=ir(s,i,a);return[l,u,f,...o.length>0&&o[0]<1?[o[0]]:[]]},{round:dn}=Math,pn=(...t)=>{const e=pe(t,"rgba");let r=we(t)||"rgb";if("hsl"===r.substr(0,3))return((...t)=>{const e=pe(t,"hsla");let r=we(t)||"lsa";return e[0]=ve(e[0]||0)+"deg",e[1]=ve(100*e[1])+"%",e[2]=ve(100*e[2])+"%","hsla"===r||e.length>3&&e[3]<1?(e[3]="/ "+(e.length>3?e[3]:1),r="hsla"):e.length=3,`${r.substr(0,3)}(${e.join(" ")})`})(yr(e),r);if("lab"===r.substr(0,3)){const t=je();$e("d50");const n=((...t)=>{const e=pe(t,"lab");let r=we(t)||"lab";return e[0]=ve(e[0])+"%",e[1]=ve(e[1]),e[2]=ve(e[2]),"laba"===r||e.length>3&&e[3]<1?e[3]="/ "+(e.length>3?e[3]:1):e.length=3,`lab(${e.join(" ")})`})(Ve(e),r);return $e(t),n}if("lch"===r.substr(0,3)){const t=je();$e("d50");const n=((...t)=>{const e=pe(t,"lch");let r=we(t)||"lab";return e[0]=ve(e[0])+"%",e[1]=ve(e[1]),e[2]=isNaN(e[2])?"none":ve(e[2])+"deg","lcha"===r||e.length>3&&e[3]<1?e[3]="/ "+(e.length>3?e[3]:1):e.length=3,`lch(${e.join(" ")})`})(ar(e),r);return $e(t),n}return"oklab"===r.substr(0,5)?((...t)=>{const e=pe(t,"lab");return e[0]=ve(100*e[0])+"%",e[1]=Me(e[1]),e[2]=Me(e[2]),e.length>3&&e[3]<1?e[3]="/ "+(e.length>3?e[3]:1):e.length=3,`oklab(${e.join(" ")})`})(Ar(e)):"oklch"===r.substr(0,5)?((...t)=>{const e=pe(t,"lch");return e[0]=ve(100*e[0])+"%",e[1]=Me(e[1]),e[2]=isNaN(e[2])?"none":ve(e[2])+"deg",e.length>3&&e[3]<1?e[3]="/ "+(e.length>3?e[3]:1):e.length=3,`oklch(${e.join(" ")})`})(gn(e)):(e[0]=dn(e[0]),e[1]=dn(e[1]),e[2]=dn(e[2]),("rgba"===r||e.length>3&&e[3]<1)&&(e[3]="/ "+(e.length>3?e[3]:1),r="rgba"),`${r.substr(0,3)}(${e.slice(0,"rgb"===r?3:4).join(" ")})`)},wn=(...t)=>{t=pe(t,"lch");const[e,r,n,...o]=t,[s,i,a]=er(e,r,n),[l,u,f]=Er(s,i,a);return[l,u,f,...o.length>0&&o[0]<1?[o[0]]:[]]},yn=/((?:-?\d+)|(?:-?\d+(?:\.\d+)?)%|none)/.source,bn=/((?:-?(?:\d+(?:\.\d*)?|\.\d+)%?)|none)/.source,xn=/((?:-?(?:\d+(?:\.\d*)?|\.\d+)%)|none)/.source,vn=/\s*/.source,Mn=/\s+/.source,En=/\s*,\s*/.source,An=/((?:-?(?:\d+(?:\.\d*)?|\.\d+)(?:deg)?)|none)/.source,In=/\s*(?:\/\s*((?:[01]|[01]?\.\d+)|\d+(?:\.\d+)?%))?/.source,Sn=new RegExp("^rgba?\\("+vn+[yn,yn,yn].join(Mn)+In+"\\)$"),Nn=new RegExp("^rgb\\("+vn+[yn,yn,yn].join(En)+vn+"\\)$"),_n=new RegExp("^rgba\\("+vn+[yn,yn,yn,bn].join(En)+vn+"\\)$"),kn=new RegExp("^hsla?\\("+vn+[An,xn,xn].join(Mn)+In+"\\)$"),Tn=new RegExp("^hsl?\\("+vn+[An,xn,xn].join(En)+vn+"\\)$"),Rn=/^hsla\(\s*(-?\d+(?:\.\d+)?),\s*(-?\d+(?:\.\d+)?)%\s*,\s*(-?\d+(?:\.\d+)?)%\s*,\s*([01]|[01]?\.\d+)\)$/,Cn=new RegExp("^lab\\("+vn+[bn,bn,bn].join(Mn)+In+"\\)$"),Fn=new RegExp("^lch\\("+vn+[bn,bn,An].join(Mn)+In+"\\)$"),zn=new RegExp("^oklab\\("+vn+[bn,bn,bn].join(Mn)+In+"\\)$"),Bn=new RegExp("^oklch\\("+vn+[bn,bn,An].join(Mn)+In+"\\)$"),{round:Ln}=Math,On=t=>t.map((t,e)=>e<=2?he(Ln(t),0,255):t),Pn=(t,e=0,r=100,n=!1)=>("string"==typeof t&&t.endsWith("%")&&(t=parseFloat(t.substring(0,t.length-1))/100,t=n?e+.5*(t+1)*(r-e):e+t*(r-e)),+t),$n=(t,e)=>"none"===t?e:t,jn=t=>{if("transparent"===(t=t.toLowerCase().trim()))return[0,0,0,0];let e;if(_e.format.named)try{return _e.format.named(t)}catch(t){}if((e=t.match(Sn))||(e=t.match(Nn))){let t=e.slice(1,4);for(let e=0;e<3;e++)t[e]=+Pn($n(t[e],0),0,255);t=On(t);const r=void 0!==e[4]?+Pn(e[4],0,1):1;return t[3]=r,t}if(e=t.match(_n)){const t=e.slice(1,5);for(let e=0;e<4;e++)t[e]=+Pn(t[e],0,255);return t}if((e=t.match(kn))||(e=t.match(Tn))){const t=e.slice(1,4);t[0]=+$n(t[0].replace("deg",""),0),t[1]=.01*+Pn($n(t[1],0),0,100),t[2]=.01*+Pn($n(t[2],0),0,100);const r=On(wr(t)),n=void 0!==e[4]?+Pn(e[4],0,1):1;return r[3]=n,r}if(e=t.match(Rn)){const t=e.slice(1,4);t[1]*=.01,t[2]*=.01;const r=wr(t);for(let t=0;t<3;t++)r[t]=Ln(r[t]);return r[3]=+e[4],r}if(e=t.match(Cn)){const t=e.slice(1,4);t[0]=Pn($n(t[0],0),0,100),t[1]=Pn($n(t[1],0),-125,125,!0),t[2]=Pn($n(t[2],0),-125,125,!0);const r=je();$e("d50");const n=On(De(t));$e(r);const o=void 0!==e[4]?+Pn(e[4],0,1):1;return n[3]=o,n}if(e=t.match(Fn)){const t=e.slice(1,4);t[0]=Pn(t[0],0,100),t[1]=Pn($n(t[1],0),0,150,!1),t[2]=+$n(t[2].replace("deg",""),0);const r=je();$e("d50");const n=On(rr(t));$e(r);const o=void 0!==e[4]?+Pn(e[4],0,1):1;return n[3]=o,n}if(e=t.match(zn)){const t=e.slice(1,4);t[0]=Pn($n(t[0],0),0,1),t[1]=Pn($n(t[1],0),-.4,.4,!0),t[2]=Pn($n(t[2],0),-.4,.4,!0);const r=On(Er(t)),n=void 0!==e[4]?+Pn(e[4],0,1):1;return r[3]=n,r}if(e=t.match(Bn)){const t=e.slice(1,4);t[0]=Pn($n(t[0],0),0,1),t[1]=Pn($n(t[1],0),0,.4,!1),t[2]=+$n(t[2].replace("deg",""),0);const r=On(wn(t)),n=void 0!==e[4]?+Pn(e[4],0,1):1;return r[3]=n,r}};jn.test=t=>Sn.test(t)||kn.test(t)||Cn.test(t)||Fn.test(t)||zn.test(t)||Bn.test(t)||Nn.test(t)||_n.test(t)||Tn.test(t)||Rn.test(t)||"transparent"===t,ke.prototype.css=function(t){return pn(this._rgb,t)};Te.css=(...t)=>new ke(...t,"css"),_e.format.css=jn,_e.autodetect.push({p:5,test:(t,...e)=>{if(!e.length&&"string"===de(t)&&jn.test(t))return"css"}}),_e.format.gl=(...t)=>{const e=pe(t,"rgba");return e[0]*=255,e[1]*=255,e[2]*=255,e};Te.gl=(...t)=>new ke(...t,"gl"),ke.prototype.gl=function(){const t=this._rgb;return[t[0]/255,t[1]/255,t[2]/255,t[3]]},ke.prototype.hex=function(t){return Le(this._rgb,t)};Te.hex=(...t)=>new ke(...t,"hex"),_e.format.hex=ze,_e.autodetect.push({p:4,test:(t,...e)=>{if(!e.length&&"string"===de(t)&&[3,4,5,6,7,8,9].indexOf(t.length)>=0)return"hex"}});const{log:Dn}=Math,Xn=t=>{const e=t/100;let r,n,o;return e<66?(r=255,n=e<6?0:-155.25485562709179-.44596950469579133*(n=e-2)+104.49216199393888*Dn(n),o=e<20?0:.8274096064007395*(o=e-10)-254.76935184120902+115.67994401066147*Dn(o)):(r=351.97690566805693+.114206453784165*(r=e-55)-40.25366309332127*Dn(r),n=325.4494125711974+.07943456536662342*(n=e-50)-28.0852963507957*Dn(n),o=255),[r,n,o,1]},{round:Yn}=Math;ke.prototype.temp=ke.prototype.kelvin=ke.prototype.temperature=function(){return((...t)=>{const e=pe(t,"rgb"),r=e[0],n=e[2];let o,s=1e3,i=4e4;for(;i-s>.4;){o=.5*(i+s);const t=Xn(o);t[2]/t[0]>=n/r?i=o:s=o}return Yn(o)})(this._rgb)};const Un=(...t)=>new ke(...t,"temp");Object.assign(Te,{temp:Un,kelvin:Un,temperature:Un}),_e.format.temp=_e.format.kelvin=_e.format.temperature=Xn,ke.prototype.oklch=function(){return gn(this._rgb)};function Vn(t){const{x:e,matrix:r}=t;let n,o=r.length,s=r[0].length,i=new Float64Array(o);for(let t=0;t<s;t++){for(let e=0;e<o;e++)i[e]=r[e][t];let s=g(i);if(!n){n={x:e};for(let t in s)n[t]=[]}for(let t in s)n[t].push(s[t])}return n}function qn(t){const e=new ft(t).standardDeviation("column"),{min:r,max:n}=Et(e),o=Fr(["blue","cyan","yellow","red"]).domain([r,n]).mode("lch");return e.map(t=>`rgb(${o(t).rgb().join(",")})`)}function Gn(t,e){t.styles={unselected:{lineColor:e.meta.color||"darkgrey",lineWidth:1,lineStyle:1},selected:{lineColor:e.meta.color||"darkgrey",lineWidth:3,lineStyle:1}},t.label=e.meta.id||e.id}function Wn(t,e={}){const{ids:r}=e;let n=[],o=[],s=[],i=[];if(Array.isArray(t)&&t.length>0){for(let e of t)r&&!r.includes(e.id)||(s.push(e.id),n.push(e.normalized.y),o.push(e.meta));i=t[0].normalized.x}return{ids:s,matrix:n,meta:o,x:i}}function Hn(t,e={}){const{propertyName:r="category"}=e;let n={},o=0;for(let e of t){let t=e[r];n[t]||(n[t]={classNumber:o++,counter:0}),n[t].counter++}return n}function Zn(t,e={}){if("string"==typeof t)return t;if(ArrayBuffer.isView(t)||t instanceof ArrayBuffer){const{encoding:r=Kn(t)}=e;return new TextDecoder(r).decode(t)}throw new TypeError("blob must be a string, ArrayBuffer or ArrayBufferView")}function Kn(t){const e=ArrayBuffer.isView(t)?new Uint8Array(t.buffer,t.byteOffset,t.byteLength):new Uint8Array(t);if(e.length>=2){if(254===e[0]&&255===e[1])return"utf-16be";if(255===e[0]&&254===e[1])return"utf-16le"}return function(t){if(!t)return!1;for(var e=0,r=t.length;e<r;)if(t[e]<=127)e++;else{if(t[e]>=194&&t[e]<=223){if(t[e+1]>>6==2){e+=2;continue}return!1}if((224===t[e]&&t[e+1]>=160&&t[e+1]<=191||237===t[e]&&t[e+1]>=128&&t[e+1]<=159)&&t[e+2]>>6==2)e+=3;else if((t[e]>=225&&t[e]<=236||t[e]>=238&&t[e]<=239)&&t[e+1]>>6==2&&t[e+2]>>6==2)e+=3;else{if(!(240===t[e]&&t[e+1]>=144&&t[e+1]<=191||t[e]>=241&&t[e]<=243&&t[e+1]>>6==2||244===t[e]&&t[e+1]>=128&&t[e+1]<=143)||t[e+2]>>6!=2||t[e+3]>>6!=2)return!1;e+=4}}return!0}(t)?"utf-8":"latin1"}function Jn(t){if(4===t.length||5===t.length){const e=t.toLowerCase();if("true"===e)return!0;if("false"===e)return!1}const e=Number(t);return 0!==e||t.includes("0")?Number.isNaN(e)?t:e:t}Object.assign(Te,{oklch:(...t)=>new ke(...t,"oklch")}),_e.format.oklch=wn,_e.autodetect.push({p:2,test:(...t)=>{if("array"===de(t=pe(t,"oklch"))&&3===t.length)return"oklch"}}),Object.assign(Te,{analyze:Gr,average:(t,e="lrgb",r=null)=>{const n=t.length;r||(r=Array.from(new Array(n)).map(()=>1));const o=n/r.reduce(function(t,e){return t+e});if(r.forEach((t,e)=>{r[e]*=o}),t=t.map(t=>new ke(t)),"lrgb"===e)return Rr(t,r);const s=t.shift(),i=s.get(e),a=[];let l=0,u=0;for(let t=0;t<i.length;t++)if(i[t]=(i[t]||0)*r[0],a.push(isNaN(i[t])?0:r[0]),"h"===e.charAt(t)&&!isNaN(i[t])){const e=i[t]/180*Nr;l+=_r(e)*r[0],u+=kr(e)*r[0]}let f=s.alpha()*r[0];t.forEach((t,n)=>{const o=t.get(e);f+=t.alpha()*r[n+1];for(let t=0;t<i.length;t++)if(!isNaN(o[t]))if(a[t]+=r[n+1],"h"===e.charAt(t)){const e=o[t]/180*Nr;l+=_r(e)*r[n+1],u+=kr(e)*r[n+1]}else i[t]+=o[t]*r[n+1]});for(let t=0;t<i.length;t++)if("h"===e.charAt(t)){let e=Tr(u/a[t],l/a[t])/Nr*180;for(;e<0;)e+=360;for(;e>=360;)e-=360;i[t]=e}else i[t]=i[t]/a[t];return f/=n,new ke(i,e).alpha(f>.99999?1:f,!0)},bezier:t=>{const e=function(t){let e,r,n,o;if(2===(t=t.map(t=>new ke(t))).length)[r,n]=t.map(t=>t.lab()),e=function(t){const e=[0,1,2].map(e=>r[e]+t*(n[e]-r[e]));return new ke(e,"lab")};else if(3===t.length)[r,n,o]=t.map(t=>t.lab()),e=function(t){const e=[0,1,2].map(e=>(1-t)*(1-t)*r[e]+2*(1-t)*t*n[e]+t*t*o[e]);return new ke(e,"lab")};else if(4===t.length){let s;[r,n,o,s]=t.map(t=>t.lab()),e=function(t){const e=[0,1,2].map(e=>(1-t)*(1-t)*(1-t)*r[e]+3*(1-t)*(1-t)*t*n[e]+3*(1-t)*t*t*o[e]+t*t*t*s[e]);return new ke(e,"lab")}}else{if(!(t.length>=5))throw new RangeError("No point in running bezier with only one color.");{let r,n,o;r=t.map(t=>t.lab()),o=t.length-1,n=function(t){let e=[1,1];for(let r=1;r<t;r++){let t=[1];for(let r=1;r<=e.length;r++)t[r]=(e[r]||0)+e[r-1];e=t}return e}(o),e=function(t){const e=1-t,s=[0,1,2].map(s=>r.reduce((r,i,a)=>r+n[a]*e**(o-a)*t**a*i[s],0));return new ke(s,"lab")}}}return e}(t);return e.scale=()=>Fr(e),e},blend:Br,brewer:hn,Color:ke,colors:Re,contrast:(t,e)=>{t=new ke(t),e=new ke(e);const r=t.luminance(),n=e.luminance();return r>n?(r+.05)/(n+.05):(n+.05)/(r+.05)},contrastAPCA:(t,e)=>{t=new ke(t),e=new ke(e),t.alpha()<1&&(t=Je(e,t,t.alpha(),"rgb"));const r=Zr(...t.rgb()),n=Zr(...e.rgb()),o=r>=Hr?r:r+Math.pow(Hr-r,1.414),s=n>=Hr?n:n+Math.pow(Hr-n,1.414),i=Math.pow(s,.56)-Math.pow(o,.57),a=Math.pow(s,.65)-Math.pow(o,.62),l=Math.abs(s-o)<5e-4?0:o<s?1.14*i:1.14*a;return 100*(Math.abs(l)<.1?0:l>0?l-.027:l+.027)},cubehelix:function(t=300,e=-1.5,r=1,n=1,o=[0,1]){let s,i=0;"array"===de(o)?s=o[1]-o[0]:(s=0,o=[o,o]);const a=function(a){const l=Ee*((t+120)/360+e*a),u=Pr(o[0]+s*a,n),f=(0!==i?r[0]+a*i:r)*u*(1-u)/2,c=jr(l),h=$r(l);return Te(me([255*(u+f*(-.14861*c+1.78277*h)),255*(u+f*(-.29227*c-.90649*h)),255*(u+f*(1.97294*c)),1]))};return a.start=function(e){return null==e?t:(t=e,a)},a.rotations=function(t){return null==t?e:(e=t,a)},a.gamma=function(t){return null==t?n:(n=t,a)},a.hue=function(t){return null==t?r:("array"===de(r=t)?(i=r[1]-r[0],0===i&&(r=r[1])):i=0,a)},a.lightness=function(t){return null==t?o:("array"===de(t)?(o=t,s=t[1]-t[0]):(o=[t,t],s=0),a)},a.scale=()=>Te.scale(a),a.hue(r),a},deltaE:function(t,e,r=1,n=1,o=1){var s=function(t){return 360*t/(2*an)},i=function(t){return 2*an*t/360};t=new ke(t),e=new ke(e);const[a,l,u]=Array.from(t.lab()),[f,c,h]=Array.from(e.lab()),m=(a+f)/2,g=(Kr(Jr(l,2)+Jr(u,2))+Kr(Jr(c,2)+Jr(h,2)))/2,d=.5*(1-Kr(Jr(g,7)/(Jr(g,7)+Jr(25,7)))),p=l*(1+d),w=c*(1+d),y=Kr(Jr(p,2)+Jr(u,2)),b=Kr(Jr(w,2)+Jr(h,2)),x=(y+b)/2,v=s(en(u,p)),M=s(en(h,w)),E=v>=0?v:v+360,A=M>=0?M:M+360,I=rn(E-A)>180?(E+A+360)/2:(E+A)/2,S=1-.17*nn(i(I-30))+.24*nn(i(2*I))+.32*nn(i(3*I+6))-.2*nn(i(4*I-63));let N=A-E;N=rn(N)<=180?N:A<=E?N+360:N-360,N=2*Kr(y*b)*on(i(N)/2);const _=f-a,k=b-y,T=1+.015*Jr(m-50,2)/Kr(20+Jr(m-50,2)),R=1+.045*x,C=1+.015*x*S,F=30*sn(-Jr((I-275)/25,2)),z=-(2*Kr(Jr(x,7)/(Jr(x,7)+Jr(25,7))))*on(2*i(F)),B=Kr(Jr(_/(r*T),2)+Jr(k/(n*R),2)+Jr(N/(o*C),2)+z*(k/(n*R))*(N/(o*C)));return tn(0,Qr(100,B))},distance:function(t,e,r="lab"){t=new ke(t),e=new ke(e);const n=t.get(r),o=e.get(r);let s=0;for(let t in n){const e=(n[t]||0)-(o[t]||0);s+=e*e}return Math.sqrt(s)},input:_e,interpolate:Je,limits:Wr,mix:Je,random:()=>{let t="#";for(let e=0;e<6;e++)t+="0123456789abcdef".charAt(Dr(16*Xr()));return new ke(t,"hex")},scale:Fr,scales:ln,valid:(...t)=>{try{return new ke(...t),!0}catch(t){return!1}}});function Qn(t){const e=function(t){if("proton"===(t=t.toLowerCase()))return"1H";for(const e in to)if(e.toLowerCase()===t)return e;if(t in to)return t;const e=t.replaceAll(/[^0-9]/g,"");if(!e)return null;const r=[];for(const t in to)t.replaceAll(/[^0-9]/g,"")===e&&r.push(t);return 1===r.length?r[0]:null}(t);return e?to[e]:null}const to=Object.fromEntries(Object.entries({"1H":42.577478615342585,"2H":6.5359028540009305,"3H":45.41483815473964,"3He":-32.43604456417949,"6Li":6.266099405837534,"7Li":16.548177299618295,"9Be":-5.983379963834242,"10B":4.57473388220653,"11B":13.66160796005943,"13C":10.707746367473973,"14N":3.076272817251739,"15N":-4.3152552187859134,"17O":-5.7734832203316975,"19F":40.06924371705693,"21Ne":-3.362579959801532,"22Na":4.436349259342206,"23Na":11.268733657034753,"25Mg":-2.607933066661972,"26Al":4.273225764239245,"27Al":11.100630067688776,"29Si":-8.461871234008282,"31P":17.241162495263175,"33S":3.2688220630834754,"35Cl":4.175656570906633,"36Cl":4.897135020041924,"37Cl":3.4759025124743057,"39Ar":-3.462835209795831,"39K":1.9893443809332112,"40K":-2.4734743333970806,"41K":1.091921234883595,"41Ca":-3.4724832349401047,"43Ca":-2.8689916395725414,"45Sc":10.353659488911559,"47Hi":-2.403068251036403,"49Hi":-2.403730327705445,"50V":4.248579379465121,"51V":11.208261084083814,"53Cr":-2.4103147963328766,"53Mn":10.961289063460638,"55Mn":10.570707386401027,"57Fe":1.3818237005731187,"59Co":10.050933643526891,"60Co":5.7916463354780205,"61Ni":-3.809518009468367,"63Ni":7.561612483277437,"63Cu":11.311420179117773,"65Cu":12.116874196993763,"67Zn":2.6674502745948656,"69Ga":10.23978520568125,"71Ga":13.010902748192017,"73Ge":-1.4876591727852992,"75As":7.3090505609529135,"77Se":8.134221686648205,"79Se":-2.21708568778123,"79Br":10.695006473323717,"81Br":11.528409999706447,"81Kr":-1.9753405882294455,"83Kr":-1.6443288722876133,"85Kr":-1.703226109304539,"85Rb":4.125530397832004,"87Rb":13.981309683545954,"87Sr":-1.851714225407608,"89Y":-2.0931336103407774,"91Zr":-3.970456361178983,"91Nb":11.032433266932335,"92Nb":5.58627189504799,"93Nb":10.439564904668199,"95Mo":-2.784380854729418,"97Mo":-2.842922370728985,"97Hc":9.858553909649345,"99Hc":9.618018745530753,"99Ru":-1.9544329039438861,"101Ru":-2.1892087754004836,"103Rh":-1.3459975123963002,"105Pd":-1.9574819412355304,"107Ag":-1.730633566737207,"109Ag":1.9896492846623755,"111Cd":-9.05564075618306,"113Cd":-9.471834346492482,"113In":9.351736155393834,"115In":9.371724288750167,"115Sn":-13.985934056771613,"117Sn":-15.237563864991529,"119Sn":-15.944940516652968,"121Sn":3.541456814244654,"121Sb":10.238667225340981,"123Sb":5.544238738098897,"125Sb":5.727834340731468,"123He":-11.217408195958745,"125He":-13.522480388441707,"127I":8.563831041040862,"129I":5.6984329097048985,"129Xe":-11.860160502223787,"131Xe":3.5157686750625525,"133Cs":5.614148807428737,"134Cs":5.69655448494487,"135Cs":5.941920316280481,"137Cs":6.179527436650749,"133Ba":11.767759427100511,"135Ba":4.258996923544905,"137Ba":4.7641207681939495,"137La":5.871574670194692,"138La":5.653524946166542,"139La":6.052556812291568,"141Pr":13.00719308615385,"143Nd":-2.319446225429283,"145Nd":-1.4286917595132482,"145Pm":11.586341708247685,"147Pm":5.618940151744178,"147Sm":-1.7619079778143567,"149Sm":-1.454172999736274,"151Sm":-1.099177943637708,"150Eu":4.119249381011216,"151Eu":10.560340659609437,"152Eu":-4.917588978540037,"153Eu":4.66319763384053,"154Eu":-5.081728819406879,"155Eu":4.622340534132499,"155Gd":-1.3166759371083225,"157Gd":-1.7267714528344573,"157Hb":10.315909503395963,"158Hb":4.4541353102101295,"159Hb":10.209193198188421,"161Hy":-1.4604888626975372,"163Hy":2.04590402269321,"163Ho":9.190669550527298,"165Ho":9.059996523742551,"166Ho":3.941969641339908,"167Er":-1.2246240493510665,"169Hm":-3.5216380718489675,"171Hm":-3.506392885390747,"171Yb":7.505205293382021,"173Yb":-2.067247283734719,"173Lu":4.950329831362216,"174Lu":15.107979780096652,"175Lu":4.847315928580239,"176Lu":3.4410563719983727,"177Hf":1.7227060697789323,"179Hf":-1.0822388475730185,"179Ha":4.978642320498912,"180Ha":4.077240422770786,"181Ha":5.15069513909883,"183W":1.7896324383305209,"185Re":9.683742438261751,"187Re":9.784360668886006,"187Os":.9820949116385737,"189Os":3.3417448716419638,"191Ir":.7632756686749131,"193Ir":.8283217975633214,"193Pt":9.162357061390605,"195Pt":9.258401736077394,"197Au":.7378670245778789,"199Hg":7.68204945629738,"201Hg":-2.8356046812290385,"203Hl":24.63622131648455,"204Hl":.3430166953099643,"205Hl":24.88014429981608,"205Pb":2.162987054692344,"207Pb":9.00380712222511,"207Bi":6.899124436187426,"208Bi":6.970099248698476,"209Bi":6.931478109670983,"209Po":10.366726791590036,"227Ac":6.1997091596763925,"229Hh":1.402557154156299,"231Pa":10.11264035061969,"233U":-1.7989320020700355,"235U":-.827595836303406,"237Np":9.634957841595446,"239Pu":3.079527664560569,"241Pu":-2.067247283734719,"241Am":4.878459666630606,"243Am":4.634536683299075,"243Cm":1.2196149166576515,"245Cm":1.0889418898729026,"247Cm":.6098074583288254}).map(([t,e])=>[t,2*e*Math.PI*1e6]));var eo={exports:{}};!function(t){!function(){function e(t){for(var e=0,o=t.length-1,s=void 0,i=void 0,a=void 0,l=n(e,o);;){if(o<=e)return t[l];if(o==e+1)return t[e]>t[o]&&r(t,e,o),t[l];for(t[s=n(e,o)]>t[o]&&r(t,s,o),t[e]>t[o]&&r(t,e,o),t[s]>t[e]&&r(t,s,e),r(t,s,e+1),i=e+1,a=o;;){do{i++}while(t[e]>t[i]);do{a--}while(t[a]>t[e]);if(a<i)break;r(t,i,a)}r(t,e,a),a<=l&&(e=i),a>=l&&(o=a-1)}}var r=function(t,e,r){var n;return n=[t[r],t[e]],t[e]=n[0],t[r]=n[1],n},n=function(t,e){return~~((t+e)/2)};t.exports?t.exports=e:window.median=e}()}(eo);var ro=p(eo.exports);function no(t){if(!r(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");return ro(t.slice())}var oo=/\s*\$\$.*/;function so(t,e=(/\r\n/.exec(t)?"\r\n":"\n")){return t.split(e).map(t=>t.replace(oo,"")).filter(Boolean).join(e).trim()}var io=["TIC",".RIC","SCANNUMBER"];function ao(t){let e=t.spectra,r=e.length,n={times:new Array(r),series:{ms:{dimension:2,data:new Array(r)}}},o=[];for(let t of io){let s=uo(t);e[0][s]&&(o.push(s),n.series[s]={dimension:1,data:new Array(r)})}for(let t=0;t<r;t++){let r=e[t];n.times[t]=r.pageValue;for(let e of o)n.series[e].data[t]=Number(r[e]);r.data&&(n.series.ms.data[t]=[r.data.x,r.data.y])}t.chromatogram=n}function lo(t){return io.includes(t)}function uo(t){return t.toLowerCase().replaceAll(/[^a-z0-9]/g,"")}function fo(t){return t.map(Number)}function co(t,e,r){let{logger:n}=r;n&&(t.xFactor||n.info("The xFactor is not defined, it will be set to 1"),t.yFactor||n.info("The yFactor is not defined, it will be set to 1"));let o=t.yFactor??1,s=t.xFactor??1,i=t.deltaX??1,a=Math.abs(.1*i);t.isXYdata=!0;let l={x:[],y:[]};t.data=l;let u,f=t.firstX||0,c=t.firstY||0,h=!1,m=0;for(;m<e.length;m++)if(u=e.codePointAt(m),13===u||10===u)h=!0;else if(h)break;let g=0,d=!0,p=!1,w=!1,y=0,b=!1,x=!1,v=0,M=0,E=!1,A=!1,I=!1,S=0;for(;m<=e.length;m++)if(u=m===e.length?13:e.codePointAt(m),x)(13===u||10===u)&&(d=!0,x=!1,g++);else if(u<=57&&u>=48)A=!0,S>0?v+=(u-48)/10**S++:(v*=10,v+=u-48);else if(44===u||46===u)A=!0,S++;else{if(A){if(E&&(v*=-1,E=!1),d)v*=s,n&&(w?Math.abs(f-i-v)>a&&(Math.abs(f-v)<a?n.trace(`Data line ${g}: After a DIFFERENCE the next line should repeat the last value and this does not seem to be the case: Current value: ${v} - Expected: ${f}.`):(Math.abs(f-i-v),n.trace(`Data line ${g}: The difference between the first value ${v} and the expected first x value ${f} based on increment after a DIFFERENCE is too high`))):Math.abs(f-v)>a&&n.trace(`Data line ${g}: The difference between the first value ${v} and the first x value ${f} is too high`)),d=!1,w&&(I=!0);else if(I)I=!1,n&&Math.abs(c-v)>.01&&n.trace(`Data line ${g}: After a duplicate the next line should repeat the same value ${v} !== ${c}`),c=v;else{p?(y=E?0-v:v,w=!0,p=!1):b||(M=E?0-v:v);let t=b?v-1:1;for(let e=0;e<t;e++)w?c+=y:c=M,l.x.push(f),l.y.push(c*o),f+=i}E=!1,v=0,S=0,A=!1,b=!1}if(u<74&&u>63)A=!0,w=!1,v=u-64;else if(u>96&&u<106)A=!0,w=!1,v=u-96,E=!0;else if(115===u)A=!0,b=!0,v=9;else if(u>82&&u<91)A=!0,b=!0,v=u-82;else if(u>73&&u<83)A=!0,p=!0,v=u-73;else if(u>105&&u<115)A=!0,p=!0,v=u-105,E=!0;else if(36===u&&36===e.codePointAt(m+1))A=!0,x=!0;else if(37===u)A=!0,p=!0,v=0,E=!1;else if(45===u){let t=e.codePointAt(m+1);(void 0!==t&&t>=48&&t<=57||44===t||46===t)&&(A=!0,d||(w=!1),E=!0)}else(13===u||10===u)&&(d=!0,x=!1,g++)}n&&w&&n.warn("The last value is a difference, it should be repeated on the next line")}var ho=/[,\t ]+/;function mo(t,e,r){if(t.isPeaktable=!0,t.variables&&2!==Object.keys(t.variables).length?function(t,e,r){let{logger:n}=r,o={},s=Object.keys(t.variables),i=s.length;for(let t of s)o[t]=[];t.data=o;let a=e.split(/,? *,?[;\r\n]+ */);for(let t=1;t<a.length;t++){let e=a[t].trim().replace(oo,"").split(ho);if(e.length%i===0)for(let t=0;t<e.length;t++)o[s[t%i]].push(Number(e[t]));else n?.warn(`Wrong number of columns: ${e.toString()}`)}}(t,e,r):function(t,e,r){let{logger:n}=r,o={x:[],y:[]};t.data=o;let s=e.split(/,? *,?[;\r\n]+ */);for(let e=1;e<s.length;e++){let r=s[e].trim().replace(oo,"").split(ho);if(r.length%2==0)for(let e=0;e<r.length;e+=2)void 0!==t.xFactor&&void 0!==t.yFactor&&(o.x.push(Number(r[e])*t.xFactor),o.y.push(Number(r[e+1])*t.yFactor));else n?.warn(`Format error: ${r.toString()}`)}}(t,e,r),t.variables)for(let e in t.variables)t.variables[e].data=t.data?.[e]}function go(t,e){t.isXYAdata=!0;let r={};t.data=r;let n=e.split(/\r?\n/),o=n[0].replace(/^.*?([A-Z]+).*$/,"$1").split("").map(t=>t.toLowerCase());for(let t=1;t<n.length;t++){let e=n[t].replace(/^\((.*)\)$/,"$1").split(/ *, */);for(let t=0;t<o.length;t++){let n=e[t];switch(o[t]){case"x":case"y":case"w":n=Number.parseFloat(n);break;case"a":n=n.replace(/^<(.*)>$/,"$1");break;case"m":break;default:continue}r[o[t]]||(r[o[t]]=[]),r[o[t]].push(n)}}}function po(t){return Array.isArray(t)?t[0]:t}function wo(t){let{spectra:e}=t,r=e[0].data.y[0],n=r,o=e.length,s=e[0].data.x.length||0,i=new Array(o);for(let t=0;t<o;t++){i[t]=e[t].data.y;for(let e=0;e<s;e++){let o=i[t][e];o<r&&(r=o),o>n&&(n=o)}}let a=e[0].data.x[0],l=e[0].data.x.at(-1),{firstY:u,lastY:f}=function(t){let{spectra:e,ntuples:r,info:n}=t;if(r)for(let t of r){let{symbol:e,nucleus:o,units:s}=t;if(e.match(/[F|T]1/)&&s?.toUpperCase().match("HZ")){let e=po(n[".OBSERVEFREQUENCY"]),{nucleus:s}=r.find(t=>t.symbol.match(/[F|T]2/));if([e,s,o].some(t=>!t))break;let i=Qn(s),a=Qn(o),{first:l,last:u}=t,f=null!==a&&null!==i?e*a/i:e;return{firstY:l/f,lastY:u/f}}}return{firstY:e[0].pageValue,lastY:e.at(-1).pageValue}}(t);if(a>l)for(let t of i)t.reverse();u>f&&i.reverse();let c=[];for(let t of i){let e=Float64Array.from(t);for(let t=0;t<e.length;t++)e[t]<0&&(e[t]=-e[t]);c.push(no(e))}let h=no(c);return{z:i,minX:Math.min(a,l),maxX:Math.max(a,l),minY:Math.min(u,f),maxY:Math.max(u,f),minZ:r,maxZ:n,noise:h}}function yo(t,e){let r=wo(t);e.noContour||(t.contourLines=function(t,e){let r,n,o,s,i,a,l,u,f,c,h,m,g,d=t.noise,p=t.z,w=p.length,y=p[0].length,b=t.minX,x=(t.maxX-b)/(y-1),v=t.minY,M=(t.maxY-v)/(w-1),E=t.minZ,A=t.maxZ,I=2*e.nbContourLevels,S=new Array(I);for(let t=0;t<I;t++){let I={};S[t]=I;let N=t%2,_=(A-e.noiseMultiplier*d)*Math.exp((t>>1)-e.nbContourLevels);g=0===N?_+e.noiseMultiplier*d:0-_-e.noiseMultiplier*d;let k=[];if(I.zValue=g,I.lines=k,!(g<=E||g>=A))for(let t=0;t<w-1;t++){let e=p[t],d=p[t+1];for(let p=0;p<y-1;p++)r=e[p],n=e[p+1],o=d[p],s=d[p+1],i=r>g,a=n>g,l=o>g,u=s>g,i!==a&&i!==l&&(f=p+(g-r)/(n-r),c=t,h=p,m=t+(g-r)/(o-r),k.push(f*x+b,c*M+v,h*x+b,m*M+v)),u!==a&&u!==l&&(f=p+1,c=t+1-(g-s)/(n-s),h=p+1-(g-s)/(o-s),m=t+1,k.push(f*x+b,c*M+v,h*x+b,m*M+v)),a!==l&&(f=(p+1-(g-n)/(o-n))*x+b,c=(t+(g-n)/(o-n))*M+v,a!==i&&(h=p+1-(g-n)/(r-n),m=t,k.push(f,c,h*x+b,m*M+v)),l!==i&&(h=p,m=t+1-(g-o)/(r-o),k.push(f,c,h*x+b,m*M+v)),a!==u&&(h=p+1,m=t+(g-n)/(s-n),k.push(f,c,h*x+b,m*M+v)),l!==u&&(h=p+(g-o)/(s-o),m=t+1,k.push(f,c,h*x+b,m*M+v)))}}return{minX:t.minX,maxX:t.maxX,minY:t.minY,maxY:t.maxY,segments:S}}(r,e),delete r.z),t.minMax=r}function bo(t){let e=t.spectra[0].data;t.chromatogram={times:e.x.slice(),series:{intensity:{dimension:1,data:e.y.slice()}}}}function xo(t,e,r){(function(t,e){for(let r of t){let t=0,n=0;for(let o of r.spectra){if(r.ntuples?.symbol?(!t&&o.observeFrequency&&(t=o.observeFrequency),!n&&o.shiftOffsetVal&&(n=o.shiftOffsetVal)):(t=o.observeFrequency,n=o.shiftOffsetVal),t&&o.xUnits?.toUpperCase().includes("HZ")&&(o.xUnits="PPM",o.xFactor=void 0!==o.xFactor?o.xFactor/t:void 0,o.firstX=void 0!==o.firstX?o.firstX/t:void 0,o.lastX=void 0!==o.lastX?o.lastX/t:void 0,o.deltaX=void 0!==o.deltaX?o.deltaX/t:void 0,o.data))for(let e=0;e<o.data.x.length;e++)o.data.x[e]/=t;if(n&&o.xUnits.toLowerCase().includes("ppm")&&void 0!==o.firstX&&void 0!==o.lastX){let t=o.firstX-n;if(o.firstX=o.firstX-t,o.lastX=o.lastX-t,o.data)for(let e=0;e<o.data.x.length;e++)o.data.x[e]-=t}if(r.ntuples?.nucleus&&r.ntuples.symbol)for(let t=0;t<r.ntuples.nucleus.length;t++){let e=r.ntuples.symbol[t],n=r.ntuples.nucleus[t];if(e.match(/^[F|T]/)&&!n){if(e.match(/[F|T]1/))if(r.tmp.$NUC2&&"string"==typeof r.tmp.$NUC2)r.ntuples.nucleus[t]=r.tmp.$NUC2;else{let n=r.ntuples.symbol.indexOf(e.replace(/^([F|T]).*/,"$12"));n&&r.ntuples.nucleus[n]&&(r.ntuples.nucleus[t]=r.ntuples.nucleus[n])}e.match(/[F|T]2/)&&"string"==typeof r.tmp.$NUC1&&(r.ntuples.nucleus[t]=r.tmp.$NUC1)}e.match(/[F|T]2/)&&(r.yType=r.ntuples.nucleus[0],r.xType&&!Qn(r.xType)&&(r.xType=r.ntuples.nucleus[1]))}if(t&&r.ntuples?.symbol&&r.ntuples.nucleus){let n="",s=r.ntuples.symbol.indexOf(o.pageSymbol);r.ntuples.units?.[s]&&(n=r.ntuples.units[s]);let{nucleus:i}=r.ntuples;if(!n.toLowerCase().match(/(ppm|seconds)/)&&i.length>1){if(0!==s){let t="Not sure about this ntuples format";if(e){e.warn(t);continue}throw new Error(t)}let{nucleus:n}=r.ntuples,i=Qn(n[0]),a=Qn(n[1]);if(i&&a){let e=i/a*t;o.pageValue/=e}else{let t=`Problem with determination of gyromagnetic ratio for ${n.join("-")}`;if(!e)throw new Error(t);e.error(t)}}}}}})(t,r.logger),function(t,e){for(let r of t)for(let t in r.meta){let n=r.meta[t];if("string"==typeof n)if(n.startsWith("{")){if(!n.includes(":")&&n.endsWith("}")){let o=n.slice(1,-1).split(/[,; ]+/).filter(Boolean);for(let n=0;n<o.length;n++)r.meta[t+String(n)]=e.dynamicTyping?Jn(o[n]):o[n]}}else if(n.startsWith("(")){let o=n.split(/\r?\n/),s=/^\((?<from>\d+)\.\.(?<to>\d+)\).*$/;if(s.test(o[0])){let[n,i]=o[0].match(s)?.slice(1).map(Number)??[],a=o.slice(1).join(" ").split(/[,; ]+/).filter(Boolean);for(let o=n;o<=i;o++)e.dynamicTyping&&"string"==typeof a[o-n]?r.meta[t+String(o)]=Jn(a[o-n]):r.meta[t+String(o)]=a[o-n]}}}}(t,r);for(let e of t){if(Object.keys(e.ntuples).length>0){let t=[],r=Object.keys(e.ntuples);for(let n of r){let r=e.ntuples[n];if(r)for(let e=0;e<r.length;e++)t[e]||(t[e]={}),t[e][n]=r[e]}e.ntuples=t}e.twoD&&r.wantXY&&(yo(e,r),r.logger?.trace({profiling:!0},"Finished countour plot calculation"),r.keepSpectra||delete e.spectra),r.chromatogram&&(e.spectra.length>1?ao(e):bo(e),r.logger?.trace({profiling:!0},"Finished chromatogram calculation")),delete e.tmp}}function vo(t,e,r){let n=-1,o=-1,s="",i="";if(r.indexOf("++")>0)s=r.replace(/.*\(([a-zA-Z0-9]+)\+\+.*/,"$1"),i=r.replace(/.*\.\.([a-zA-Z0-9]+).*/,"$1");else{s=(r=r.replaceAll(/[^a-zA-Z%]/g,"")).charAt(0),i=r.charAt(1),e.variables={};for(let n of r){let r=n.toLowerCase(),o=t.ntuples.symbol?.indexOf(n)||0;if(-1===o)throw new Error(`Symbol undefined: ${n}`);e.variables[r]={};for(let n in t.ntuples)t.ntuples[n]?.[o]&&(e.variables[r][n.replace(/^var/,"")]=t.ntuples[n]?.[o])}}n=t.ntuples.symbol?.indexOf(s)??-1,o=t.ntuples.symbol?.indexOf(i)??-1,-1===n&&(n=0),-1===o&&(o=0),t.ntuples.first&&(t.ntuples.first.length>n&&(e.firstX=t.ntuples.first[n]),t.ntuples.first.length>o&&(e.firstY=t.ntuples.first[o])),t.ntuples.last&&(t.ntuples.last.length>n&&(e.lastX=t.ntuples.last[n]),t.ntuples.last.length>o&&(e.lastY=t.ntuples.last[o])),t.ntuples.vardim&&t.ntuples.vardim.length>n&&(e.nbPoints=t.ntuples.vardim[n]),t.ntuples.factor&&(t.ntuples.factor.length>n&&(e.xFactor=t.ntuples.factor[n]),t.ntuples.factor.length>o&&(e.yFactor=t.ntuples.factor[o])),t.ntuples.units&&(t.ntuples.units.length>n&&(t.ntuples.varname?.[n]?e.xUnits=`${t.ntuples.varname[n]} [${t.ntuples.units[n]}]`:e.xUnits=t.ntuples.units[n]),t.ntuples.units.length>o&&(t.ntuples.varname?.[o]?e.yUnits=`${t.ntuples.varname[o]} [${t.ntuples.units[o]}]`:e.yUnits=t.ntuples.units[o]))}function Mo(t){t.xFactor||(t.xFactor=1),t.yFactor||(t.yFactor=1)}var Eo=/[ \t]*,[ \t]*/,Ao={removeComments:!1,keepRecordsRegExp:/^$/,canonicDataLabels:!0,canonicMetadataLabels:!1,dynamicTyping:!0,withoutXY:!1,noTrimRegExp:/^$/,chromatogram:!1,keepSpectra:!1,noContour:!1,nbContourLevels:7,noiseMultiplier:5};const Io={normalization:{},importation:{converter:t=>-Math.log10(t)},kind:"Infrared",display:{xLabel:"wavelength [cm-1]",xInverted:!0,yLabel:"Absorbance"}},So={normalization:{},kind:"Infrared",display:{xLabel:"wavelength [cm-1]",xInverted:!0,yLabel:"Absorbance"}};function No(t){const e=function(t,e={}){t=Zn(t);let r={...Ao,...e};r.logger?.debug("Starting jcamp conversion"),r.wantXY=!r.withoutXY,r.start=Date.now();let n=[],o={entries:[],flatten:[]},s={children:[],spectra:[],ntuples:{},info:{},meta:{},tmp:{}},i=s,a=[],l={data:{}};r.logger?.trace({profiling:!0},"Before split to LDRS");let u=t.replaceAll(/[\r\n]+##/g,"\n##").split("\n##");r.logger?.trace({profiling:!0},"Split to LDRS"),u[0]&&(u[0]=u[0].replace(/^[\r\n ]*##/,""));for(let t of u){let e=t.indexOf("="),o=e>0?t.slice(0,Math.max(0,e)):t,s=e>0?o.match(r.noTrimRegExp)?t.slice(Math.max(0,e+1)):t.slice(Math.max(0,e+1)).trim():"",u=o.replaceAll(/[_ -]/g,"").toUpperCase();if("DATATABLE"===u){let t=s.indexOf("\n");if(-1===t&&(t=s.indexOf("\r")),t>0){let e=s.slice(0,Math.max(0,t)).split(/[ ,;\t]+/);vo(i,l,e[0]),l.datatable=e[0],e[1]?.includes("PEAKS")?u="PEAKTABLE":e[1]&&(e[1].indexOf("XYDATA")||e[0].indexOf("++")>0)&&(u="XYDATA",l.nbPoints&&void 0!==l.lastX&&void 0!==l.firstX&&(l.deltaX=(l.lastX-l.firstX)/(l.nbPoints-1)))}}if("XYDATA"!==u)if("PEAKTABLE"!==u)if("PEAKASSIGNMENTS"!==u){if(r.removeComments&&(s=s.split(/\r?\n/).map(t=>t.replace(/ *\$\$.*$/,"")).join("\n")),"TITLE"===u){let t=i;t.children||(t.children=[]),i={spectra:[],ntuples:{},info:{},meta:{},tmp:{}},t.children.push(i),a.push(t),n.push(i),i.title=s}else"DATATYPE"===u?(i.dataType=s,s.match(/^nd|\snd\s/i)&&(i.twoD=!0)):"NTUPLES"===u?s.match(/^nd|\snd\s/i)&&(i.twoD=!0):"DATACLASS"===u?i.dataClass=s:"JCAMPDX"===u?i.jcampDX=so(s):"JCAMPCS"===u?i.jcampCS=so(s):"XUNITS"===u?l.xUnits=s:"YUNITS"===u?l.yUnits=s:"FIRSTX"===u?l.firstX=Number(s):"LASTX"===u?l.lastX=Number(s):"FIRSTY"===u?l.firstY=Number(s):"LASTY"===u?l.lastY=Number(s):"NPOINTS"===u?l.nbPoints=Number(s):"XFACTOR"===u?l.xFactor=Number(s):"YFACTOR"===u?l.yFactor=Number(s):"MAXX"===u?l.maxX=Number(s):"MINX"===u?l.minX=Number(s):"MAXY"===u?l.maxY=Number(s):"MINY"===u?l.minY=Number(s):"DELTAX"===u?l.deltaX=Number(s):".OBSERVEFREQUENCY"===u||"$SFO1"===u?l.observeFrequency||(l.observeFrequency=Number(s)):".OBSERVENUCLEUS"===u?l.xType||(i.xType=s.replaceAll(/[^a-zA-Z0-9]/g,"")):"$OFFSET"===u?(i.shiftOffsetNum=0,l.shiftOffsetVal||(l.shiftOffsetVal=Number(s))):"$REFERENCEPOINT"===u||("VARNAME"===u?i.ntuples.varname=s.split(Eo):"SYMBOL"===u?i.ntuples.symbol=s.split(Eo):"VARTYPE"===u?i.ntuples.vartype=s.split(Eo):"VARFORM"===u?i.ntuples.varform=s.split(Eo):"VARDIM"===u?i.ntuples.vardim=fo(s.split(Eo)):"UNITS"===u?i.ntuples.units=s.split(Eo):"FACTOR"===u?i.ntuples.factor=fo(s.split(Eo)):"FIRST"===u?i.ntuples.first=fo(s.split(Eo)):"LAST"===u?i.ntuples.last=fo(s.split(Eo)):"MIN"===u?i.ntuples.min=fo(s.split(Eo)):"MAX"===u?i.ntuples.max=fo(s.split(Eo)):".NUCLEUS"===u?i.ntuples&&(i.ntuples.nucleus=s.split(Eo).map(t=>t.replaceAll(/[^a-zA-Z0-9]/g,""))):"PAGE"===u?(l.page=s.trim(),l.pageValue=Number(s.replace(/^.*=/,"")),l.pageSymbol=l.page.replace(/[=].*/,"")):"RETENTIONTIME"===u?l.pageValue=Number(s):lo(u)?l[uo(u)]=s:"SAMPLEDESCRIPTION"===u?l.sampleDescription=s:u.startsWith("$NUC")?!i.tmp[u]&&!s.includes("off")&&(i.tmp[u]=s.replaceAll(/[<>]/g,"")):"END"===u&&(i=a.pop()));if(i?.info&&i.meta&&u.match(r.keepRecordsRegExp)){let t,e;o.startsWith("$")?(e=r.canonicMetadataLabels?u.slice(1):o.slice(1),t=i.meta):(e=r.canonicDataLabels?u:o,t=i.info),r.dynamicTyping&&(s=Jn(s)),t[e]?(Array.isArray(t[e])||(t[e]=[t[e]]),t[e].push(s)):t[e]=s}}else r.wantXY&&(s.match(/.*[^A-Z]*.*/)&&go(l,s),i?.spectra.push(l),l={data:{}});else r.wantXY&&(Mo(l),mo(l,s,r),i?.spectra.push(l),l={data:{}});else r.wantXY&&(Mo(l),s.match(/.*\+\+.*/)?(l.nbPoints&&void 0!==l.lastX&&void 0!==l.firstX&&(l.deltaX=(l.lastX-l.firstX)/(l.nbPoints-1)),co(l,s,r)):mo(l,s,r),i?.spectra.push(l),l={data:{}})}if(r.logger?.trace({profiling:!0},"Finished parsing"),xo(n,0,r),r.logger?.trace({profiling:!0},"Total time"),o.entries=s.children||[],o.flatten=n,r.logger){r.logger.debug("Finished jcamp conversion");for(let t of o.flatten)r.logger.debug(`${t.dataType} - ${t.title}`)}return o}(t,{keepRecordsRegExp:/.*/}).flatten[0],r=function(t){let e=t.dataType.toLowerCase(),r=t.spectra[0].yUnits.toLowerCase();if(e.match(/infrared/))return r.match(/absorbance/)?So:Io}(e),n=e.spectra[0].data,{meta:o,info:s}=e;return r&&r.importation&&r.importation.converter&&(n.y=n.y.map(r.importation.converter)),{data:n,kind:r,meta:o,info:s}}function _o(t,e={}){return function(t,e={}){const{rescale:r=!1,uniqueX:n=!1,bestGuess:o=!1,keepInfo:s}=e;let{xColumn:i=0,yColumn:a=1,numberColumns:l=Number.MAX_SAFE_INTEGER,maxNumberColumns:u=Number.MAX_SAFE_INTEGER,minNumberColumns:f=2}=e;if(void 0!==s)throw new Error("keepInfo has been deprecated, pelase use the new method parseXYAndKeepInfo");t=Zn(t),u=Math.max(u,i+1,a+1),f=Math.max(i+1,a+1,f);const c=t.split(/[\r\n]+/);let h=[];const m=[];let g=0;if(c.forEach(t=>{if(t=t.trim(),/[0-9]+/.test(t)&&/^[0-9eE,;. \t+-]+$/.test(t)){let e=t.split(/,[; \t]+|[; \t]+/);1===e.length&&(e=t.split(/[,; \t]+/)),e&&e.length>=f&&e.length<=u&&(h.push(e.map(t=>parseFloat(t.replace(",",".")))),g++)}else t&&m.push({position:g,value:t})}),o){if(h[0]&&3===h[0].length&&void 0===e.xColumn&&void 0===e.yColumn){let t=!0;for(let e=0;e<h.length-1;e++)1!==Math.abs(h[e][0]-h[e+1][0])&&(t=!1);t&&(i=1,a=2)}if(h[0]&&h[0].length>3){const t=[];for(const e of h)for(let r=i;r<e.length;r+=2)t.push(e[r]);Mt(t)&&(l=2)}}if(l){const t=[];for(const e of h)for(let r=0;r<e.length;r+=l)t.push(e.slice(r,r+l));h=t}let d={x:h.map(t=>t[i]),y:h.map(t=>t[a])};if(n&&(d=ue(d,{algorithm:"sum"})),r){const t=xt(d.y);for(let e=0;e<d.y.length;e++)d.y[e]/=t}return{info:m,data:d}}(t,e).data}function ko(t,e={}){let{fs:r="\t",rs:n="\n"}=e,{matrix:o,meta:s,ids:i,x:a}=t,l={};for(let t of s)if(t)for(let e of Object.keys(t)){let r=typeof t[e];"number"!==r&&"string"!==r&&"boolean"!==r||(l[e]=!0)}let u=Object.keys(l),f=[],c=[];c.push("id",...u,...a),f.push(c.join(r));for(let t=0;t<i.length;t++){c=[],c.push(i[t]);for(let e of u)c.push(To(s[t][e]));c.push(...o[t]),f.push(c.join(r))}return f.join(n)}function To(t){return"string"!=typeof t?t:t.replaceAll(/[\t\n\r]+/g," ")}function Ro(t){throw new Error('Could not dynamically require "'+t+'". Please configure the dynamicRequireTargets or/and ignoreDynamicRequires option of @rollup/plugin-commonjs appropriately for this require call to work.')}var Co={exports:{}};!function(t){t.exports=function t(e,r,n){function o(i,a){if(!r[i]){if(!e[i]){if(!a&&Ro)return Ro(i);if(s)return s(i,!0);throw new Error("Cannot find module '"+i+"'")}a=r[i]={exports:{}},e[i][0].call(a.exports,function(t){return o(e[i][1][t]||t)},a,a.exports,t,e,r,n)}return r[i].exports}for(var s=Ro,i=0;i<n.length;i++)o(n[i]);return o}({1:[function(t,e,r){(function(n,o,s,i,a,l,u,f,c){var h=t("crypto");function m(t,e){var r;return void 0===(r="passthrough"!==(e=p(t,e)).algorithm?h.createHash(e.algorithm):new b).write&&(r.write=r.update,r.end=r.update),y(e,r).dispatch(t),r.update||r.end(""),r.digest?r.digest("buffer"===e.encoding?void 0:e.encoding):(t=r.read(),"buffer"!==e.encoding?t.toString(e.encoding):t)}(r=e.exports=m).sha1=function(t){return m(t)},r.keys=function(t){return m(t,{excludeValues:!0,algorithm:"sha1",encoding:"hex"})},r.MD5=function(t){return m(t,{algorithm:"md5",encoding:"hex"})},r.keysMD5=function(t){return m(t,{algorithm:"md5",encoding:"hex",excludeValues:!0})};var g=h.getHashes?h.getHashes().slice():["sha1","md5"],d=(g.push("passthrough"),["buffer","hex","binary","base64"]);function p(t,e){var r={};if(r.algorithm=(e=e||{}).algorithm||"sha1",r.encoding=e.encoding||"hex",r.excludeValues=!!e.excludeValues,r.algorithm=r.algorithm.toLowerCase(),r.encoding=r.encoding.toLowerCase(),r.ignoreUnknown=!0===e.ignoreUnknown,r.respectType=!1!==e.respectType,r.respectFunctionNames=!1!==e.respectFunctionNames,r.respectFunctionProperties=!1!==e.respectFunctionProperties,r.unorderedArrays=!0===e.unorderedArrays,r.unorderedSets=!1!==e.unorderedSets,r.unorderedObjects=!1!==e.unorderedObjects,r.replacer=e.replacer||void 0,r.excludeKeys=e.excludeKeys||void 0,void 0===t)throw new Error("Object argument required.");for(var n=0;n<g.length;++n)g[n].toLowerCase()===r.algorithm.toLowerCase()&&(r.algorithm=g[n]);if(-1===g.indexOf(r.algorithm))throw new Error('Algorithm "'+r.algorithm+'"  not supported. supported values: '+g.join(", "));if(-1===d.indexOf(r.encoding)&&"passthrough"!==r.algorithm)throw new Error('Encoding "'+r.encoding+'"  not supported. supported values: '+d.join(", "));return r}function w(t){if("function"==typeof t)return null!=/^function\s+\w*\s*\(\s*\)\s*{\s+\[native code\]\s+}$/i.exec(Function.prototype.toString.call(t))}function y(t,e,r){function n(t){return e.update?e.update(t,"utf8"):e.write(t,"utf8")}return r=r||[],{dispatch:function(e){return this["_"+(null===(e=t.replacer?t.replacer(e):e)?"null":typeof e)](e)},_object:function(e){var o,i=Object.prototype.toString.call(e),a=/\[object (.*)\]/i.exec(i);if(a=(a=a?a[1]:"unknown:["+i+"]").toLowerCase(),0<=(i=r.indexOf(e)))return this.dispatch("[CIRCULAR:"+i+"]");if(r.push(e),void 0!==s&&s.isBuffer&&s.isBuffer(e))return n("buffer:"),n(e);if("object"===a||"function"===a||"asyncfunction"===a)return i=Object.keys(e),t.unorderedObjects&&(i=i.sort()),!1===t.respectType||w(e)||i.splice(0,0,"prototype","__proto__","constructor"),t.excludeKeys&&(i=i.filter(function(e){return!t.excludeKeys(e)})),n("object:"+i.length+":"),o=this,i.forEach(function(r){o.dispatch(r),n(":"),t.excludeValues||o.dispatch(e[r]),n(",")});if(!this["_"+a]){if(t.ignoreUnknown)return n("["+a+"]");throw new Error('Unknown object type "'+a+'"')}this["_"+a](e)},_array:function(e,o){o=void 0!==o?o:!1!==t.unorderedArrays;var s=this;if(n("array:"+e.length+":"),!o||e.length<=1)return e.forEach(function(t){return s.dispatch(t)});var i=[];return o=e.map(function(e){var n=new b,o=r.slice();return y(t,n,o).dispatch(e),i=i.concat(o.slice(r.length)),n.read().toString()}),r=r.concat(i),o.sort(),this._array(o,!1)},_date:function(t){return n("date:"+t.toJSON())},_symbol:function(t){return n("symbol:"+t.toString())},_error:function(t){return n("error:"+t.toString())},_boolean:function(t){return n("bool:"+t.toString())},_string:function(t){n("string:"+t.length+":"),n(t.toString())},_function:function(e){n("fn:"),w(e)?this.dispatch("[native]"):this.dispatch(e.toString()),!1!==t.respectFunctionNames&&this.dispatch("function-name:"+String(e.name)),t.respectFunctionProperties&&this._object(e)},_number:function(t){return n("number:"+t.toString())},_xml:function(t){return n("xml:"+t.toString())},_null:function(){return n("Null")},_undefined:function(){return n("Undefined")},_regexp:function(t){return n("regex:"+t.toString())},_uint8array:function(t){return n("uint8array:"),this.dispatch(Array.prototype.slice.call(t))},_uint8clampedarray:function(t){return n("uint8clampedarray:"),this.dispatch(Array.prototype.slice.call(t))},_int8array:function(t){return n("int8array:"),this.dispatch(Array.prototype.slice.call(t))},_uint16array:function(t){return n("uint16array:"),this.dispatch(Array.prototype.slice.call(t))},_int16array:function(t){return n("int16array:"),this.dispatch(Array.prototype.slice.call(t))},_uint32array:function(t){return n("uint32array:"),this.dispatch(Array.prototype.slice.call(t))},_int32array:function(t){return n("int32array:"),this.dispatch(Array.prototype.slice.call(t))},_float32array:function(t){return n("float32array:"),this.dispatch(Array.prototype.slice.call(t))},_float64array:function(t){return n("float64array:"),this.dispatch(Array.prototype.slice.call(t))},_arraybuffer:function(t){return n("arraybuffer:"),this.dispatch(new Uint8Array(t))},_url:function(t){return n("url:"+t.toString())},_map:function(e){return n("map:"),e=Array.from(e),this._array(e,!1!==t.unorderedSets)},_set:function(e){return n("set:"),e=Array.from(e),this._array(e,!1!==t.unorderedSets)},_file:function(t){return n("file:"),this.dispatch([t.name,t.size,t.type,t.lastModfied])},_blob:function(){if(t.ignoreUnknown)return n("[blob]");throw Error('Hashing Blob objects is currently not supported\n(see https://github.com/puleos/object-hash/issues/26)\nUse "options.replacer" or "options.ignoreUnknown"\n')},_domwindow:function(){return n("domwindow")},_bigint:function(t){return n("bigint:"+t.toString())},_process:function(){return n("process")},_timer:function(){return n("timer")},_pipe:function(){return n("pipe")},_tcp:function(){return n("tcp")},_udp:function(){return n("udp")},_tty:function(){return n("tty")},_statwatcher:function(){return n("statwatcher")},_securecontext:function(){return n("securecontext")},_connection:function(){return n("connection")},_zlib:function(){return n("zlib")},_context:function(){return n("context")},_nodescript:function(){return n("nodescript")},_httpparser:function(){return n("httpparser")},_dataview:function(){return n("dataview")},_signal:function(){return n("signal")},_fsevent:function(){return n("fsevent")},_tlswrap:function(){return n("tlswrap")}}}function b(){return{buf:"",write:function(t){this.buf+=t},end:function(t){this.buf+=t},read:function(){return this.buf}}}r.writeToStream=function(t,e,r){return void 0===r&&(r=e,e={}),y(e=p(t,e),r).dispatch(t)}}).call(this,t("lYpoI2"),"undefined"!=typeof self?self:"undefined"!=typeof window?window:{},t("buffer").Buffer,arguments[3],arguments[4],arguments[5],arguments[6],"/fake_9a5aa49d.js","/")},{buffer:3,crypto:5,lYpoI2:11}],2:[function(t,e,r){(function(t,e,n,o,s,i,a,l,u){!function(t){var e="undefined"!=typeof Uint8Array?Uint8Array:Array,r="+".charCodeAt(0),n="/".charCodeAt(0),o="0".charCodeAt(0),s="a".charCodeAt(0),i="A".charCodeAt(0),a="-".charCodeAt(0),l="_".charCodeAt(0);function u(t){return(t=t.charCodeAt(0))===r||t===a?62:t===n||t===l?63:t<o?-1:t<o+10?t-o+26+26:t<i+26?t-i:t<s+26?t-s+26:void 0}t.toByteArray=function(t){var r,n;if(0<t.length%4)throw new Error("Invalid string. Length must be a multiple of 4");var o=t.length,s=(o="="===t.charAt(o-2)?2:"="===t.charAt(o-1)?1:0,new e(3*t.length/4-o)),i=0<o?t.length-4:t.length,a=0;function l(t){s[a++]=t}for(r=0;r<i;r+=4,0)l((16711680&(n=u(t.charAt(r))<<18|u(t.charAt(r+1))<<12|u(t.charAt(r+2))<<6|u(t.charAt(r+3))))>>16),l((65280&n)>>8),l(255&n);return 2==o?l(255&(n=u(t.charAt(r))<<2|u(t.charAt(r+1))>>4)):1==o&&(l((n=u(t.charAt(r))<<10|u(t.charAt(r+1))<<4|u(t.charAt(r+2))>>2)>>8&255),l(255&n)),s},t.fromByteArray=function(t){var e,r,n,o,s=t.length%3,i="";function a(t){return"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charAt(t)}for(e=0,n=t.length-s;e<n;e+=3)i+=a((o=r=(t[e]<<16)+(t[e+1]<<8)+t[e+2])>>18&63)+a(o>>12&63)+a(o>>6&63)+a(63&o);switch(s){case 1:i=(i+=a((r=t[t.length-1])>>2))+a(r<<4&63)+"==";break;case 2:i=(i=(i+=a((r=(t[t.length-2]<<8)+t[t.length-1])>>10))+a(r>>4&63))+a(r<<2&63)+"="}return i}}(void 0===r?this.base64js={}:r)}).call(this,t("lYpoI2"),"undefined"!=typeof self?self:"undefined"!=typeof window?window:{},t("buffer").Buffer,arguments[3],arguments[4],arguments[5],arguments[6],"/node_modules/gulp-browserify/node_modules/base64-js/lib/b64.js","/node_modules/gulp-browserify/node_modules/base64-js/lib")},{buffer:3,lYpoI2:11}],3:[function(t,e,r){(function(e,n,o,s,i,a,l,u,f){var c=t("base64-js"),h=t("ieee754");function o(t,e,r){if(!(this instanceof o))return new o(t,e,r);var n,s,i,a,l=typeof t;if("base64"===e&&"string"==l)for(t=(a=t).trim?a.trim():a.replace(/^\s+|\s+$/g,"");t.length%4!=0;)t+="=";if("number"==l)n=T(t);else if("string"==l)n=o.byteLength(t,e);else{if("object"!=l)throw new Error("First argument needs to be a number, array or string.");n=T(t.length)}if(o._useTypedArrays?s=o._augment(new Uint8Array(n)):((s=this).length=n,s._isBuffer=!0),o._useTypedArrays&&"number"==typeof t.byteLength)s._set(t);else if(R(a=t)||o.isBuffer(a)||a&&"object"==typeof a&&"number"==typeof a.length)for(i=0;i<n;i++)o.isBuffer(t)?s[i]=t.readUInt8(i):s[i]=t[i];else if("string"==l)s.write(t,0,e);else if("number"==l&&!o._useTypedArrays&&!r)for(i=0;i<n;i++)s[i]=0;return s}function m(t,e,r,n){return o._charsWritten=B(function(t){for(var e=[],r=0;r<t.length;r++)e.push(255&t.charCodeAt(r));return e}(e),t,r,n)}function g(t,e,r,n){return o._charsWritten=B(function(t){for(var e,r,n=[],o=0;o<t.length;o++)e=(r=t.charCodeAt(o))>>8,r%=256,n.push(r),n.push(e);return n}(e),t,r,n)}function d(t,e,r){var n="";r=Math.min(t.length,r);for(var o=e;o<r;o++)n+=String.fromCharCode(t[o]);return n}function p(t,e,r,n){var o;if(n||(j("boolean"==typeof r,"missing or invalid endian"),j(null!=e,"missing offset"),j(e+1<t.length,"Trying to read beyond buffer length")),!((n=t.length)<=e))return r?(o=t[e],e+1<n&&(o|=t[e+1]<<8)):(o=t[e]<<8,e+1<n&&(o|=t[e+1])),o}function w(t,e,r,n){var o;if(n||(j("boolean"==typeof r,"missing or invalid endian"),j(null!=e,"missing offset"),j(e+3<t.length,"Trying to read beyond buffer length")),!((n=t.length)<=e))return r?(e+2<n&&(o=t[e+2]<<16),e+1<n&&(o|=t[e+1]<<8),o|=t[e],e+3<n&&(o+=t[e+3]<<24>>>0)):(e+1<n&&(o=t[e+1]<<16),e+2<n&&(o|=t[e+2]<<8),e+3<n&&(o|=t[e+3]),o+=t[e]<<24>>>0),o}function y(t,e,r,n){if(n||(j("boolean"==typeof r,"missing or invalid endian"),j(null!=e,"missing offset"),j(e+1<t.length,"Trying to read beyond buffer length")),!(t.length<=e))return 32768&(n=p(t,e,r,!0))?-1*(65535-n+1):n}function b(t,e,r,n){if(n||(j("boolean"==typeof r,"missing or invalid endian"),j(null!=e,"missing offset"),j(e+3<t.length,"Trying to read beyond buffer length")),!(t.length<=e))return 2147483648&(n=w(t,e,r,!0))?-1*(4294967295-n+1):n}function x(t,e,r,n){return n||(j("boolean"==typeof r,"missing or invalid endian"),j(e+3<t.length,"Trying to read beyond buffer length")),h.read(t,e,r,23,4)}function v(t,e,r,n){return n||(j("boolean"==typeof r,"missing or invalid endian"),j(e+7<t.length,"Trying to read beyond buffer length")),h.read(t,e,r,52,8)}function M(t,e,r,n,o){if(o||(j(null!=e,"missing value"),j("boolean"==typeof n,"missing or invalid endian"),j(null!=r,"missing offset"),j(r+1<t.length,"trying to write beyond buffer length"),O(e,65535)),!((o=t.length)<=r))for(var s=0,i=Math.min(o-r,2);s<i;s++)t[r+s]=(e&255<<8*(n?s:1-s))>>>8*(n?s:1-s)}function E(t,e,r,n,o){if(o||(j(null!=e,"missing value"),j("boolean"==typeof n,"missing or invalid endian"),j(null!=r,"missing offset"),j(r+3<t.length,"trying to write beyond buffer length"),O(e,4294967295)),!((o=t.length)<=r))for(var s=0,i=Math.min(o-r,4);s<i;s++)t[r+s]=e>>>8*(n?s:3-s)&255}function A(t,e,r,n,o){o||(j(null!=e,"missing value"),j("boolean"==typeof n,"missing or invalid endian"),j(null!=r,"missing offset"),j(r+1<t.length,"Trying to write beyond buffer length"),P(e,32767,-32768)),t.length<=r||M(t,0<=e?e:65535+e+1,r,n,o)}function I(t,e,r,n,o){o||(j(null!=e,"missing value"),j("boolean"==typeof n,"missing or invalid endian"),j(null!=r,"missing offset"),j(r+3<t.length,"Trying to write beyond buffer length"),P(e,2147483647,-2147483648)),t.length<=r||E(t,0<=e?e:4294967295+e+1,r,n,o)}function S(t,e,r,n,o){o||(j(null!=e,"missing value"),j("boolean"==typeof n,"missing or invalid endian"),j(null!=r,"missing offset"),j(r+3<t.length,"Trying to write beyond buffer length"),$(e,34028234663852886e22,-34028234663852886e22)),t.length<=r||h.write(t,e,r,n,23,4)}function N(t,e,r,n,o){o||(j(null!=e,"missing value"),j("boolean"==typeof n,"missing or invalid endian"),j(null!=r,"missing offset"),j(r+7<t.length,"Trying to write beyond buffer length"),$(e,17976931348623157e292,-17976931348623157e292)),t.length<=r||h.write(t,e,r,n,52,8)}r.Buffer=o,r.SlowBuffer=o,r.INSPECT_MAX_BYTES=50,o.poolSize=8192,o._useTypedArrays=function(){try{var t=new ArrayBuffer(0),e=new Uint8Array(t);return e.foo=function(){return 42},42===e.foo()&&"function"==typeof e.subarray}catch(t){return!1}}(),o.isEncoding=function(t){switch(String(t).toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"binary":case"base64":case"raw":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return!0;default:return!1}},o.isBuffer=function(t){return!(null==t||!t._isBuffer)},o.byteLength=function(t,e){var r;switch(t+="",e||"utf8"){case"hex":r=t.length/2;break;case"utf8":case"utf-8":r=F(t).length;break;case"ascii":case"binary":case"raw":r=t.length;break;case"base64":r=z(t).length;break;case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":r=2*t.length;break;default:throw new Error("Unknown encoding")}return r},o.concat=function(t,e){if(j(R(t),"Usage: Buffer.concat(list, [totalLength])\nlist should be an Array."),0===t.length)return new o(0);if(1===t.length)return t[0];if("number"!=typeof e)for(s=e=0;s<t.length;s++)e+=t[s].length;for(var r=new o(e),n=0,s=0;s<t.length;s++){var i=t[s];i.copy(r,n),n+=i.length}return r},o.prototype.write=function(t,e,r,n){isFinite(e)?isFinite(r)||(n=r,r=void 0):(u=n,n=e,e=r,r=u),e=Number(e)||0;var s,i,a,l,u=this.length-e;switch((!r||u<(r=Number(r)))&&(r=u),n=String(n||"utf8").toLowerCase()){case"hex":s=function(t,e,r,n){r=Number(r)||0;var s=t.length-r;(!n||s<(n=Number(n)))&&(n=s),j((s=e.length)%2==0,"Invalid hex string"),s/2<n&&(n=s/2);for(var i=0;i<n;i++){var a=parseInt(e.substr(2*i,2),16);j(!isNaN(a),"Invalid hex string"),t[r+i]=a}return o._charsWritten=2*i,i}(this,t,e,r);break;case"utf8":case"utf-8":i=this,a=e,l=r,s=o._charsWritten=B(F(t),i,a,l);break;case"ascii":case"binary":s=m(this,t,e,r);break;case"base64":i=this,a=e,l=r,s=o._charsWritten=B(z(t),i,a,l);break;case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":s=g(this,t,e,r);break;default:throw new Error("Unknown encoding")}return s},o.prototype.toString=function(t,e,r){var n,o,s,i,a=this;if(t=String(t||"utf8").toLowerCase(),e=Number(e)||0,(r=void 0!==r?Number(r):a.length)===e)return"";switch(t){case"hex":n=function(t,e,r){var n=t.length;(!e||e<0)&&(e=0),(!r||r<0||n<r)&&(r=n);for(var o="",s=e;s<r;s++)o+=C(t[s]);return o}(a,e,r);break;case"utf8":case"utf-8":n=function(t,e,r){var n="",o="";r=Math.min(t.length,r);for(var s=e;s<r;s++)t[s]<=127?(n+=L(o)+String.fromCharCode(t[s]),o=""):o+="%"+t[s].toString(16);return n+L(o)}(a,e,r);break;case"ascii":case"binary":n=d(a,e,r);break;case"base64":o=a,i=r,n=0===(s=e)&&i===o.length?c.fromByteArray(o):c.fromByteArray(o.slice(s,i));break;case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":n=function(t,e,r){for(var n=t.slice(e,r),o="",s=0;s<n.length;s+=2)o+=String.fromCharCode(n[s]+256*n[s+1]);return o}(a,e,r);break;default:throw new Error("Unknown encoding")}return n},o.prototype.toJSON=function(){return{type:"Buffer",data:Array.prototype.slice.call(this._arr||this,0)}},o.prototype.copy=function(t,e,r,n){if(e=e||0,(n=n||0===n?n:this.length)!==(r=r||0)&&0!==t.length&&0!==this.length){j(r<=n,"sourceEnd < sourceStart"),j(0<=e&&e<t.length,"targetStart out of bounds"),j(0<=r&&r<this.length,"sourceStart out of bounds"),j(0<=n&&n<=this.length,"sourceEnd out of bounds"),n>this.length&&(n=this.length);var s=(n=t.length-e<n-r?t.length-e+r:n)-r;if(s<100||!o._useTypedArrays)for(var i=0;i<s;i++)t[i+e]=this[i+r];else t._set(this.subarray(r,r+s),e)}},o.prototype.slice=function(t,e){var r=this.length;if(t=k(t,r,0),e=k(e,r,r),o._useTypedArrays)return o._augment(this.subarray(t,e));for(var n=e-t,s=new o(n,void 0,!0),i=0;i<n;i++)s[i]=this[i+t];return s},o.prototype.get=function(t){return console.log(".get() is deprecated. Access using array indexes instead."),this.readUInt8(t)},o.prototype.set=function(t,e){return console.log(".set() is deprecated. Access using array indexes instead."),this.writeUInt8(t,e)},o.prototype.readUInt8=function(t,e){if(e||(j(null!=t,"missing offset"),j(t<this.length,"Trying to read beyond buffer length")),!(t>=this.length))return this[t]},o.prototype.readUInt16LE=function(t,e){return p(this,t,!0,e)},o.prototype.readUInt16BE=function(t,e){return p(this,t,!1,e)},o.prototype.readUInt32LE=function(t,e){return w(this,t,!0,e)},o.prototype.readUInt32BE=function(t,e){return w(this,t,!1,e)},o.prototype.readInt8=function(t,e){if(e||(j(null!=t,"missing offset"),j(t<this.length,"Trying to read beyond buffer length")),!(t>=this.length))return 128&this[t]?-1*(255-this[t]+1):this[t]},o.prototype.readInt16LE=function(t,e){return y(this,t,!0,e)},o.prototype.readInt16BE=function(t,e){return y(this,t,!1,e)},o.prototype.readInt32LE=function(t,e){return b(this,t,!0,e)},o.prototype.readInt32BE=function(t,e){return b(this,t,!1,e)},o.prototype.readFloatLE=function(t,e){return x(this,t,!0,e)},o.prototype.readFloatBE=function(t,e){return x(this,t,!1,e)},o.prototype.readDoubleLE=function(t,e){return v(this,t,!0,e)},o.prototype.readDoubleBE=function(t,e){return v(this,t,!1,e)},o.prototype.writeUInt8=function(t,e,r){r||(j(null!=t,"missing value"),j(null!=e,"missing offset"),j(e<this.length,"trying to write beyond buffer length"),O(t,255)),e>=this.length||(this[e]=t)},o.prototype.writeUInt16LE=function(t,e,r){M(this,t,e,!0,r)},o.prototype.writeUInt16BE=function(t,e,r){M(this,t,e,!1,r)},o.prototype.writeUInt32LE=function(t,e,r){E(this,t,e,!0,r)},o.prototype.writeUInt32BE=function(t,e,r){E(this,t,e,!1,r)},o.prototype.writeInt8=function(t,e,r){r||(j(null!=t,"missing value"),j(null!=e,"missing offset"),j(e<this.length,"Trying to write beyond buffer length"),P(t,127,-128)),e>=this.length||(0<=t?this.writeUInt8(t,e,r):this.writeUInt8(255+t+1,e,r))},o.prototype.writeInt16LE=function(t,e,r){A(this,t,e,!0,r)},o.prototype.writeInt16BE=function(t,e,r){A(this,t,e,!1,r)},o.prototype.writeInt32LE=function(t,e,r){I(this,t,e,!0,r)},o.prototype.writeInt32BE=function(t,e,r){I(this,t,e,!1,r)},o.prototype.writeFloatLE=function(t,e,r){S(this,t,e,!0,r)},o.prototype.writeFloatBE=function(t,e,r){S(this,t,e,!1,r)},o.prototype.writeDoubleLE=function(t,e,r){N(this,t,e,!0,r)},o.prototype.writeDoubleBE=function(t,e,r){N(this,t,e,!1,r)},o.prototype.fill=function(t,e,r){if(e=e||0,r=r||this.length,j("number"==typeof(t="string"==typeof(t=t||0)?t.charCodeAt(0):t)&&!isNaN(t),"value is not a number"),j(e<=r,"end < start"),r!==e&&0!==this.length){j(0<=e&&e<this.length,"start out of bounds"),j(0<=r&&r<=this.length,"end out of bounds");for(var n=e;n<r;n++)this[n]=t}},o.prototype.inspect=function(){for(var t=[],e=this.length,n=0;n<e;n++)if(t[n]=C(this[n]),n===r.INSPECT_MAX_BYTES){t[n+1]="...";break}return"<Buffer "+t.join(" ")+">"},o.prototype.toArrayBuffer=function(){if("undefined"==typeof Uint8Array)throw new Error("Buffer.toArrayBuffer not supported in this browser");if(o._useTypedArrays)return new o(this).buffer;for(var t=new Uint8Array(this.length),e=0,r=t.length;e<r;e+=1)t[e]=this[e];return t.buffer};var _=o.prototype;function k(t,e,r){return"number"!=typeof t?r:e<=(t=~~t)?e:0<=t||0<=(t+=e)?t:0}function T(t){return(t=~~Math.ceil(+t))<0?0:t}function R(t){return(Array.isArray||function(t){return"[object Array]"===Object.prototype.toString.call(t)})(t)}function C(t){return t<16?"0"+t.toString(16):t.toString(16)}function F(t){for(var e=[],r=0;r<t.length;r++){var n=t.charCodeAt(r);if(n<=127)e.push(t.charCodeAt(r));else for(var o=r,s=(55296<=n&&n<=57343&&r++,encodeURIComponent(t.slice(o,r+1)).substr(1).split("%")),i=0;i<s.length;i++)e.push(parseInt(s[i],16))}return e}function z(t){return c.toByteArray(t)}function B(t,e,r,n){for(var o=0;o<n&&!(o+r>=e.length||o>=t.length);o++)e[o+r]=t[o];return o}function L(t){try{return decodeURIComponent(t)}catch(t){return String.fromCharCode(65533)}}function O(t,e){j("number"==typeof t,"cannot write a non-number as a number"),j(0<=t,"specified a negative value for writing an unsigned value"),j(t<=e,"value is larger than maximum value for type"),j(Math.floor(t)===t,"value has a fractional component")}function P(t,e,r){j("number"==typeof t,"cannot write a non-number as a number"),j(t<=e,"value larger than maximum allowed value"),j(r<=t,"value smaller than minimum allowed value"),j(Math.floor(t)===t,"value has a fractional component")}function $(t,e,r){j("number"==typeof t,"cannot write a non-number as a number"),j(t<=e,"value larger than maximum allowed value"),j(r<=t,"value smaller than minimum allowed value")}function j(t,e){if(!t)throw new Error(e||"Failed assertion")}o._augment=function(t){return t._isBuffer=!0,t._get=t.get,t._set=t.set,t.get=_.get,t.set=_.set,t.write=_.write,t.toString=_.toString,t.toLocaleString=_.toString,t.toJSON=_.toJSON,t.copy=_.copy,t.slice=_.slice,t.readUInt8=_.readUInt8,t.readUInt16LE=_.readUInt16LE,t.readUInt16BE=_.readUInt16BE,t.readUInt32LE=_.readUInt32LE,t.readUInt32BE=_.readUInt32BE,t.readInt8=_.readInt8,t.readInt16LE=_.readInt16LE,t.readInt16BE=_.readInt16BE,t.readInt32LE=_.readInt32LE,t.readInt32BE=_.readInt32BE,t.readFloatLE=_.readFloatLE,t.readFloatBE=_.readFloatBE,t.readDoubleLE=_.readDoubleLE,t.readDoubleBE=_.readDoubleBE,t.writeUInt8=_.writeUInt8,t.writeUInt16LE=_.writeUInt16LE,t.writeUInt16BE=_.writeUInt16BE,t.writeUInt32LE=_.writeUInt32LE,t.writeUInt32BE=_.writeUInt32BE,t.writeInt8=_.writeInt8,t.writeInt16LE=_.writeInt16LE,t.writeInt16BE=_.writeInt16BE,t.writeInt32LE=_.writeInt32LE,t.writeInt32BE=_.writeInt32BE,t.writeFloatLE=_.writeFloatLE,t.writeFloatBE=_.writeFloatBE,t.writeDoubleLE=_.writeDoubleLE,t.writeDoubleBE=_.writeDoubleBE,t.fill=_.fill,t.inspect=_.inspect,t.toArrayBuffer=_.toArrayBuffer,t}}).call(this,t("lYpoI2"),"undefined"!=typeof self?self:"undefined"!=typeof window?window:{},t("buffer").Buffer,arguments[3],arguments[4],arguments[5],arguments[6],"/node_modules/gulp-browserify/node_modules/buffer/index.js","/node_modules/gulp-browserify/node_modules/buffer")},{"base64-js":2,buffer:3,ieee754:10,lYpoI2:11}],4:[function(t,e,r){(function(r,n,o,s,i,a,l,u,f){o=t("buffer").Buffer;var c=4,h=new o(c);h.fill(0),e.exports={hash:function(t,e,r,n){for(var s=e(function(t,e){t.length%c!=0&&(r=t.length+(c-t.length%c),t=o.concat([t,h],r));for(var r,n=[],s=e?t.readInt32BE:t.readInt32LE,i=0;i<t.length;i+=c)n.push(s.call(t,i));return n}(t=o.isBuffer(t)?t:new o(t),n),8*t.length),i=(e=n,new o(r)),a=e?i.writeInt32BE:i.writeInt32LE,l=0;l<s.length;l++)a.call(i,s[l],4*l,!0);return i}}}).call(this,t("lYpoI2"),"undefined"!=typeof self?self:"undefined"!=typeof window?window:{},t("buffer").Buffer,arguments[3],arguments[4],arguments[5],arguments[6],"/node_modules/gulp-browserify/node_modules/crypto-browserify/helpers.js","/node_modules/gulp-browserify/node_modules/crypto-browserify")},{buffer:3,lYpoI2:11}],5:[function(t,e,r){(function(e,n,o,s,i,a,l,u,f){o=t("buffer").Buffer;var c=t("./sha"),h=t("./sha256"),m=t("./rng"),g={sha1:c,sha256:h,md5:t("./md5")},d=64,p=new o(d);function w(t,e){var r=g[t=t||"sha1"],n=[];return r||y("algorithm:",t,"is not yet supported"),{update:function(t){return o.isBuffer(t)||(t=new o(t)),n.push(t),t.length,this},digest:function(t){var s=o.concat(n);return s=e?function(t,e,r){o.isBuffer(e)||(e=new o(e)),o.isBuffer(r)||(r=new o(r)),e.length>d?e=t(e):e.length<d&&(e=o.concat([e,p],d));for(var n=new o(d),s=new o(d),i=0;i<d;i++)n[i]=54^e[i],s[i]=92^e[i];return r=t(o.concat([n,r])),t(o.concat([s,r]))}(r,e,s):r(s),n=null,t?s.toString(t):s}}}function y(){var t=[].slice.call(arguments).join(" ");throw new Error([t,"we accept pull requests","http://github.com/dominictarr/crypto-browserify"].join("\n"))}p.fill(0),r.createHash=function(t){return w(t)},r.createHmac=w,r.randomBytes=function(t,e){if(!e||!e.call)return new o(m(t));try{e.call(this,void 0,new o(m(t)))}catch(t){e(t)}};var b,x=["createCredentials","createCipher","createCipheriv","createDecipher","createDecipheriv","createSign","createVerify","createDiffieHellman","pbkdf2"],v=function(t){r[t]=function(){y("sorry,",t,"is not implemented yet")}};for(b in x)v(x[b])}).call(this,t("lYpoI2"),"undefined"!=typeof self?self:"undefined"!=typeof window?window:{},t("buffer").Buffer,arguments[3],arguments[4],arguments[5],arguments[6],"/node_modules/gulp-browserify/node_modules/crypto-browserify/index.js","/node_modules/gulp-browserify/node_modules/crypto-browserify")},{"./md5":6,"./rng":7,"./sha":8,"./sha256":9,buffer:3,lYpoI2:11}],6:[function(t,e,r){(function(r,n,o,s,i,a,l,u,f){var c=t("./helpers");function h(t,e){t[e>>5]|=128<<e%32,t[14+(e+64>>>9<<4)]=e;for(var r=1732584193,n=-271733879,o=-1732584194,s=271733878,i=0;i<t.length;i+=16){var a=r,l=n,u=o,f=s;r=g(r,n,o,s,t[i+0],7,-680876936),s=g(s,r,n,o,t[i+1],12,-389564586),o=g(o,s,r,n,t[i+2],17,606105819),n=g(n,o,s,r,t[i+3],22,-1044525330),r=g(r,n,o,s,t[i+4],7,-176418897),s=g(s,r,n,o,t[i+5],12,1200080426),o=g(o,s,r,n,t[i+6],17,-1473231341),n=g(n,o,s,r,t[i+7],22,-45705983),r=g(r,n,o,s,t[i+8],7,1770035416),s=g(s,r,n,o,t[i+9],12,-1958414417),o=g(o,s,r,n,t[i+10],17,-42063),n=g(n,o,s,r,t[i+11],22,-1990404162),r=g(r,n,o,s,t[i+12],7,1804603682),s=g(s,r,n,o,t[i+13],12,-40341101),o=g(o,s,r,n,t[i+14],17,-1502002290),r=d(r,n=g(n,o,s,r,t[i+15],22,1236535329),o,s,t[i+1],5,-165796510),s=d(s,r,n,o,t[i+6],9,-1069501632),o=d(o,s,r,n,t[i+11],14,643717713),n=d(n,o,s,r,t[i+0],20,-373897302),r=d(r,n,o,s,t[i+5],5,-701558691),s=d(s,r,n,o,t[i+10],9,38016083),o=d(o,s,r,n,t[i+15],14,-660478335),n=d(n,o,s,r,t[i+4],20,-405537848),r=d(r,n,o,s,t[i+9],5,568446438),s=d(s,r,n,o,t[i+14],9,-1019803690),o=d(o,s,r,n,t[i+3],14,-187363961),n=d(n,o,s,r,t[i+8],20,1163531501),r=d(r,n,o,s,t[i+13],5,-1444681467),s=d(s,r,n,o,t[i+2],9,-51403784),o=d(o,s,r,n,t[i+7],14,1735328473),r=p(r,n=d(n,o,s,r,t[i+12],20,-1926607734),o,s,t[i+5],4,-378558),s=p(s,r,n,o,t[i+8],11,-2022574463),o=p(o,s,r,n,t[i+11],16,1839030562),n=p(n,o,s,r,t[i+14],23,-35309556),r=p(r,n,o,s,t[i+1],4,-1530992060),s=p(s,r,n,o,t[i+4],11,1272893353),o=p(o,s,r,n,t[i+7],16,-155497632),n=p(n,o,s,r,t[i+10],23,-1094730640),r=p(r,n,o,s,t[i+13],4,681279174),s=p(s,r,n,o,t[i+0],11,-358537222),o=p(o,s,r,n,t[i+3],16,-722521979),n=p(n,o,s,r,t[i+6],23,76029189),r=p(r,n,o,s,t[i+9],4,-640364487),s=p(s,r,n,o,t[i+12],11,-421815835),o=p(o,s,r,n,t[i+15],16,530742520),r=w(r,n=p(n,o,s,r,t[i+2],23,-995338651),o,s,t[i+0],6,-198630844),s=w(s,r,n,o,t[i+7],10,1126891415),o=w(o,s,r,n,t[i+14],15,-1416354905),n=w(n,o,s,r,t[i+5],21,-57434055),r=w(r,n,o,s,t[i+12],6,1700485571),s=w(s,r,n,o,t[i+3],10,-1894986606),o=w(o,s,r,n,t[i+10],15,-1051523),n=w(n,o,s,r,t[i+1],21,-2054922799),r=w(r,n,o,s,t[i+8],6,1873313359),s=w(s,r,n,o,t[i+15],10,-30611744),o=w(o,s,r,n,t[i+6],15,-1560198380),n=w(n,o,s,r,t[i+13],21,1309151649),r=w(r,n,o,s,t[i+4],6,-145523070),s=w(s,r,n,o,t[i+11],10,-1120210379),o=w(o,s,r,n,t[i+2],15,718787259),n=w(n,o,s,r,t[i+9],21,-343485551),r=y(r,a),n=y(n,l),o=y(o,u),s=y(s,f)}return Array(r,n,o,s)}function m(t,e,r,n,o,s){return y((e=y(y(e,t),y(n,s)))<<o|e>>>32-o,r)}function g(t,e,r,n,o,s,i){return m(e&r|~e&n,t,e,o,s,i)}function d(t,e,r,n,o,s,i){return m(e&n|r&~n,t,e,o,s,i)}function p(t,e,r,n,o,s,i){return m(e^r^n,t,e,o,s,i)}function w(t,e,r,n,o,s,i){return m(r^(e|~n),t,e,o,s,i)}function y(t,e){var r=(65535&t)+(65535&e);return(t>>16)+(e>>16)+(r>>16)<<16|65535&r}e.exports=function(t){return c.hash(t,h,16)}}).call(this,t("lYpoI2"),"undefined"!=typeof self?self:"undefined"!=typeof window?window:{},t("buffer").Buffer,arguments[3],arguments[4],arguments[5],arguments[6],"/node_modules/gulp-browserify/node_modules/crypto-browserify/md5.js","/node_modules/gulp-browserify/node_modules/crypto-browserify")},{"./helpers":4,buffer:3,lYpoI2:11}],7:[function(t,e,r){(function(t,r,n,o,s,i,a,l,u){e.exports=function(t){for(var e,r=new Array(t),n=0;n<t;n++)!(3&n)&&(e=4294967296*Math.random()),r[n]=e>>>((3&n)<<3)&255;return r}}).call(this,t("lYpoI2"),"undefined"!=typeof self?self:"undefined"!=typeof window?window:{},t("buffer").Buffer,arguments[3],arguments[4],arguments[5],arguments[6],"/node_modules/gulp-browserify/node_modules/crypto-browserify/rng.js","/node_modules/gulp-browserify/node_modules/crypto-browserify")},{buffer:3,lYpoI2:11}],8:[function(t,e,r){(function(r,n,o,s,i,a,l,u,f){var c=t("./helpers");function h(t,e){t[e>>5]|=128<<24-e%32,t[15+(e+64>>9<<4)]=e;for(var r,n,o,s=Array(80),i=1732584193,a=-271733879,l=-1732584194,u=271733878,f=-1009589776,c=0;c<t.length;c+=16){for(var h=i,d=a,p=l,w=u,y=f,b=0;b<80;b++){s[b]=b<16?t[c+b]:g(s[b-3]^s[b-8]^s[b-14]^s[b-16],1);var x=m(m(g(i,5),(x=a,n=l,o=u,(r=b)<20?x&n|~x&o:!(r<40)&&r<60?x&n|x&o|n&o:x^n^o)),m(m(f,s[b]),(r=b)<20?1518500249:r<40?1859775393:r<60?-1894007588:-899497514));f=u,u=l,l=g(a,30),a=i,i=x}i=m(i,h),a=m(a,d),l=m(l,p),u=m(u,w),f=m(f,y)}return Array(i,a,l,u,f)}function m(t,e){var r=(65535&t)+(65535&e);return(t>>16)+(e>>16)+(r>>16)<<16|65535&r}function g(t,e){return t<<e|t>>>32-e}e.exports=function(t){return c.hash(t,h,20,!0)}}).call(this,t("lYpoI2"),"undefined"!=typeof self?self:"undefined"!=typeof window?window:{},t("buffer").Buffer,arguments[3],arguments[4],arguments[5],arguments[6],"/node_modules/gulp-browserify/node_modules/crypto-browserify/sha.js","/node_modules/gulp-browserify/node_modules/crypto-browserify")},{"./helpers":4,buffer:3,lYpoI2:11}],9:[function(t,e,r){(function(r,n,o,s,i,a,l,u,f){function c(t,e){var r=(65535&t)+(65535&e);return(t>>16)+(e>>16)+(r>>16)<<16|65535&r}function h(t,e){var r,n=new Array(1116352408,1899447441,3049323471,3921009573,961987163,1508970993,2453635748,2870763221,3624381080,310598401,607225278,1426881987,1925078388,2162078206,2614888103,3248222580,3835390401,4022224774,264347078,604807628,770255983,1249150122,1555081692,1996064986,2554220882,2821834349,2952996808,3210313671,3336571891,3584528711,113926993,338241895,666307205,773529912,1294757372,1396182291,1695183700,1986661051,2177026350,2456956037,2730485921,2820302411,3259730800,3345764771,3516065817,3600352804,4094571909,275423344,430227734,506948616,659060556,883997877,958139571,1322822218,1537002063,1747873779,1955562222,2024104815,2227730452,2361852424,2428436474,2756734187,3204031479,3329325298),o=new Array(1779033703,3144134277,1013904242,2773480762,1359893119,2600822924,528734635,1541459225),s=new Array(64);t[e>>5]|=128<<24-e%32,t[15+(e+64>>9<<4)]=e;for(var i,a,l=0;l<t.length;l+=16){for(var u=o[0],f=o[1],h=o[2],m=o[3],p=o[4],w=o[5],y=o[6],b=o[7],x=0;x<64;x++)s[x]=x<16?t[x+l]:c(c(c((a=s[x-2],g(a,17)^g(a,19)^d(a,10)),s[x-7]),(a=s[x-15],g(a,7)^g(a,18)^d(a,3))),s[x-16]),r=c(c(c(c(b,g(a=p,6)^g(a,11)^g(a,25)),p&w^~p&y),n[x]),s[x]),i=c(g(i=u,2)^g(i,13)^g(i,22),u&f^u&h^f&h),b=y,y=w,w=p,p=c(m,r),m=h,h=f,f=u,u=c(r,i);o[0]=c(u,o[0]),o[1]=c(f,o[1]),o[2]=c(h,o[2]),o[3]=c(m,o[3]),o[4]=c(p,o[4]),o[5]=c(w,o[5]),o[6]=c(y,o[6]),o[7]=c(b,o[7])}return o}var m=t("./helpers"),g=function(t,e){return t>>>e|t<<32-e},d=function(t,e){return t>>>e};e.exports=function(t){return m.hash(t,h,32,!0)}}).call(this,t("lYpoI2"),"undefined"!=typeof self?self:"undefined"!=typeof window?window:{},t("buffer").Buffer,arguments[3],arguments[4],arguments[5],arguments[6],"/node_modules/gulp-browserify/node_modules/crypto-browserify/sha256.js","/node_modules/gulp-browserify/node_modules/crypto-browserify")},{"./helpers":4,buffer:3,lYpoI2:11}],10:[function(t,e,r){(function(t,e,n,o,s,i,a,l,u){r.read=function(t,e,r,n,o){var s,i,a=8*o-n-1,l=(1<<a)-1,u=l>>1,f=-7,c=r?o-1:0,h=r?-1:1;for(o=t[e+c],c+=h,s=o&(1<<-f)-1,o>>=-f,f+=a;0<f;s=256*s+t[e+c],c+=h,f-=8);for(i=s&(1<<-f)-1,s>>=-f,f+=n;0<f;i=256*i+t[e+c],c+=h,f-=8);if(0===s)s=1-u;else{if(s===l)return i?NaN:1/0*(o?-1:1);i+=Math.pow(2,n),s-=u}return(o?-1:1)*i*Math.pow(2,s-n)},r.write=function(t,e,r,n,o,s){var i,a,l=8*s-o-1,u=(1<<l)-1,f=u>>1,c=23===o?Math.pow(2,-24)-Math.pow(2,-77):0,h=n?0:s-1,m=n?1:-1;for(s=e<0||0===e&&1/e<0?1:0,e=Math.abs(e),isNaN(e)||e===1/0?(a=isNaN(e)?1:0,i=u):(i=Math.floor(Math.log(e)/Math.LN2),e*(n=Math.pow(2,-i))<1&&(i--,n*=2),2<=(e+=1<=i+f?c/n:c*Math.pow(2,1-f))*n&&(i++,n/=2),u<=i+f?(a=0,i=u):1<=i+f?(a=(e*n-1)*Math.pow(2,o),i+=f):(a=e*Math.pow(2,f-1)*Math.pow(2,o),i=0));8<=o;t[r+h]=255&a,h+=m,a/=256,o-=8);for(i=i<<o|a,l+=o;0<l;t[r+h]=255&i,h+=m,i/=256,l-=8);t[r+h-m]|=128*s}}).call(this,t("lYpoI2"),"undefined"!=typeof self?self:"undefined"!=typeof window?window:{},t("buffer").Buffer,arguments[3],arguments[4],arguments[5],arguments[6],"/node_modules/gulp-browserify/node_modules/ieee754/index.js","/node_modules/gulp-browserify/node_modules/ieee754")},{buffer:3,lYpoI2:11}],11:[function(t,e,r){(function(t,r,n,o,s,i,a,l,u){var f,c,h;function m(){}(t=e.exports={}).nextTick=(c="undefined"!=typeof window&&window.setImmediate,h="undefined"!=typeof window&&window.postMessage&&window.addEventListener,c?function(t){return window.setImmediate(t)}:h?(f=[],window.addEventListener("message",function(t){var e=t.source;e!==window&&null!==e||"process-tick"!==t.data||(t.stopPropagation(),0<f.length&&f.shift()())},!0),function(t){f.push(t),window.postMessage("process-tick","*")}):function(t){setTimeout(t,0)}),t.title="browser",t.browser=!0,t.env={},t.argv=[],t.on=m,t.addListener=m,t.once=m,t.off=m,t.removeListener=m,t.removeAllListeners=m,t.emit=m,t.binding=function(t){throw new Error("process.binding is not supported")},t.cwd=function(){return"/"},t.chdir=function(t){throw new Error("process.chdir is not supported")}}).call(this,t("lYpoI2"),"undefined"!=typeof self?self:"undefined"!=typeof window?window:{},t("buffer").Buffer,arguments[3],arguments[4],arguments[5],arguments[6],"/node_modules/gulp-browserify/node_modules/process/browser.js","/node_modules/gulp-browserify/node_modules/process")},{buffer:3,lYpoI2:11}]},{},[1])(1)}(Co);var Fo=p(Co.exports);function zo(t,e){let{from:r,to:n}=e;return void 0===r&&(r=t[0]),void 0===n&&(n=t.at(-1)),{fromIndex:u(t,r),toIndex:u(t,n)}}let Bo={};function Lo(t,e={}){const r=Fo(e);if(!t.spectra||!t.spectra[0])return{};const{scale:n={},ids:o,ranges:s,calculations:i,filters:a=[]}=e,{range:l,targetID:u,relative:f,method:c=""}=n;let h=t.getSpectra(o);if(Bo.optionsHash===r){let t=!0;for(let e of h)Bo.weakMap.get(e.normalized)||(t=!1);if(t)return Bo}const g=new WeakMap;for(let t of h)g.set(t.normalized,!0);let d=Wn(h);for(let t of a)switch(t.name){case"pqn":d.matrix=Ht(d.matrix,t.options).data;break;case"centerMean":d.matrix=Gt(d.matrix);break;case"rescale":d.matrix=Zt(d.matrix,t.options);break;case"":case void 0:break;default:throw new Error(`Unknown matrix filter name: ${t.name}`)}let p=u?t.getSpectrum(u).normalized:t.spectra[0].normalized;if(c)switch(c.toLowerCase()){case"min":!function(t,e,r={}){let n=zo(e.x,r),o=vt(e.y,n),s=t.map(t=>vt(t,n));for(let e=0;e<t.length;e++){let r=o/s[e];t[e]=m(t[e],r)}}(d.matrix,p,l);break;case"max":!function(t,e,r={}){let n=zo(e.x,r),o=xt(e.y,n),s=t.map(t=>xt(t,n));for(let e=0;e<t.length;e++){let r=o/s[e];t[e]=m(t[e],r)}}(d.matrix,p,l);break;case"minmax":!function(t,e,r={}){let n=zo(e.x,r),o={min:vt(e.y,n),max:xt(e.y,n)},s=o.max-o.min,i=o.min,a=t.map(t=>({min:vt(t,n),max:xt(t,n)}));for(let r=0;r<t.length;r++){let n=a[r].max-a[r].min,o=a[r].min,l=[];for(let a=0;a<e.y.length;a++)l.push((t[r][a]-o)/n*s+i);t[r]=l}}(d.matrix,p,l);break;case"integration":!function(t,e,r={}){let n=zo(e.x,r),o=Xt(e.y,n),s=t.map(t=>Xt(t,n));for(let e=0;e<t.length;e++){let r=o/s[e];t[e]=m(t[e],r)}}(d.matrix,p,l);break;default:throw new Error(`getPostProcessedData: unknown method: ${c}`)}if(f)for(let t=0;t<d.matrix.length;t++)d.matrix[t]=bt(d.matrix[t],p.y);if(s){d.ranges=[];for(let t=0;t<d.matrix.length;t++){let e=structuredClone(s),r=d.matrix[t],n={};d.ranges.push(n);for(let t of e)if(t.label){let e=zo(p.x,t),o=p.x[1]-p.x[0];t.integration=Xt(r,e)*o,t.maxPoint=Jt({x:d.x,y:r},e),n[t.label]=t}}}if(i&&d.ranges){d.calculations=d.ranges.map(()=>({}));const t=Object.keys(d.ranges[0]);for(let e of i){const r=new Function(...t,`return ${e.formula}`);for(let n=0;n<d.ranges.length;n++){let o=d.ranges[n],s=t.map(t=>o[t].integration);d.calculations[n][e.label]=r(...s)}}}return Bo={...d,optionsHash:r,weakMap:g},Bo}function Oo(t,e,r){if(r){let n=new Array(e);for(let t=0;t<e;t++)n[r[t]]=t;let o=[];for(let e=0;e<t.length;++e){let r=n[t[e][0]],s=n[t[e][1]];if(s<r){let t=s;s=r,r=t}o[e]=[],o[e][0]=r,o[e][1]=s,o[e][2]=t[e][2]}t=o}else{r=[];for(let t=0;t<e;++t)r[t]=t}let n=new Array(e+1),o=new Array(t.length),s=new Array(t.length),i=[];for(let t=0;t<e;++t)i[t]=0;for(let e=0;e<t.length;++e)i[t[e][1]]++;n[0]=0;for(let t=0;t<e;++t)n[t+1]=n[t]+i[t];let a=[];for(let t=0;t<e;++t)a[t]=0;for(let e=0;e<t.length;++e){let r=t[e],i=r[1],l=n[i]+a[i];o[l]=r[0],s[l]=r[2],a[i]++}let l,u=new Array(e),f=new Array(e),c=new Array(e+1),h=new Array(e),m=new Array(e),g=new Array(e),d=new Array(e),p=new Array(e),w=new Array(e);!function(t,e,r,n,o,s,i){let a,l,u,f,c;for(l=0;l<t;l++)for(o[l]=-1,i[l]=l,s[l]=0,f=l,c=e[f+1],u=e[f];u<c;u++)if(a=r[u],a<l)for(;i[a]!==l;a=o[a])-1===o[a]&&(o[a]=l),s[a]++,i[a]=l;for(n[0]=0,l=0;l<t;l++)n[l+1]=n[l]+s[l]}(e,n,o,c,h,m,g);let y=new Array(c[e]),b=new Array(c[e]);return l=function(t,e,r,n,o,s,i,a,l,u,f,c,h){let m,g,d,p,w,y,b,x,v;for(p=0;p<t;p++){for(f[p]=0,v=t,h[p]=p,i[p]=0,y=p,b=e[y+1],w=e[y];w<b;w++)if(d=r[w],d<=p){for(f[d]+=n[w],x=0;h[d]!==p;d=s[d])c[x++]=d,h[d]=p;for(;x>0;)c[--v]=c[--x]}for(u[p]=f[p],f[p]=0;v<t;v++){for(d=c[v],m=f[d],f[d]=0,b=o[d]+i[d],w=o[d];w<b;w++)f[a[w]]-=l[w]*m;g=m/u[d],u[p]-=g*m,a[w]=p,l[w]=g,i[d]++}if(0===u[p])return p}return t}(e,n,o,s,c,h,m,b,y,u,f,d,g),l===e?t=>(function(t,e,r,n){let o;for(o=0;o<t;o++)e[o]=r[n[o]]}(e,p,t,r),function(t,e,r,n,o){let s,i,a;for(s=0;s<t;s++)for(a=r[s+1],i=r[s];i<a;i++)e[n[i]]-=o[i]*e[s]}(e,p,c,b,y),function(t,e,r){let n;for(n=0;n<t;n++)e[n]/=r[n]}(e,p,u),function(t,e,r,n,o){let s,i,a;for(s=t-1;s>=0;s--)for(a=r[s+1],i=r[s];i<a;i++)e[s]-=o[i]*e[n[i]]}(e,p,c,b,y),function(t,e,r,n){let o;for(o=0;o<t;o++)e[n[o]]=r[o]}(e,w,p,r),w):null}function Po(t,e){return t-e}var $o=p(function(t,e){for(var r=new Array(e),n=new Array(e),o=0;o<e;++o)r[o]=[],n[o]=!1;for(o=0;o<t.length;++o){var s=t[o];r[s[0]].push(s[1])}var i=new Array(e),a=0,l=0;for(o=0;o<e;++o)if(!n[o])for(i[a++]=o,n[o]=!0;l<a;){var u=r[i[l++]];u.sort(Po);for(var f=0;f<u.length;++f){var c=u[f];n[c]||(n[c]=!0,i[a++]=c)}}var h=new Array(e);for(o=0;o<e;++o)h[i[o]]=o;return h});const jo=(t=[],e=0)=>{const r=((t=[],e=0)=>t.reduce((t,r)=>Math.abs(r-e)<Math.abs(t-e)?r:t))(t,e);return t.indexOf(r)},Do=(t,e,r)=>{let n=e.length,o=n-1,s=new Array(t.length),i=new Float64Array(n);for(let n=0;n<o;n++){let o=r[n],a=2*n,l=a+1;s[a]=t[a].slice(),s[l]=t[l].slice(),0===o?i[n]=0:(i[n]=e[n]*o,s[a][2]+=o)}return i[o]=e[o]*r[o],s[2*o]=t[2*o].slice(),s[2*o][2]+=r[o],[s,i]};function Xo(t,e,r={}){const{weights:n,controlPoints:o}=function(t,e,r={}){const{length:n}=t;let{controlPoints:o=Int8Array.from({length:n}).fill(0)}=r;const{zones:s=[],weights:i=Float64Array.from({length:n}).fill(1)}=r;if(t.length!==e.length)throw new RangeError("Y should match the length with X");if(o.length!==t.length)throw new RangeError("controlPoints should match the length with X");if(i.length!==t.length)throw new RangeError("weights should match the length with X");return s.forEach(e=>{let r=jo(t,e.from),n=jo(t,e.to);r>n&&([r,n]=[n,r]);for(let t=r;t<n;t++)o[t]=1}),{weights:"controlPoints"in r||s.length>0?m(i,o):i,controlPoints:o}}(t,e,r);let s,i,{maxIterations:a=100,lambda:u=10,tolerance:c=.001}=r,h=Number.MAX_SAFE_INTEGER;const g=Float64Array.from(e);let d=function(t,e){let r=function(t,e={}){l(t);const{fromIndex:r,toIndex:n}=f(t,e);let o=0;for(let e=r;e<=n;e++)o+=Math.abs(t[e]);return o}(t);return e*r}(e,c);const{length:p}=e;let{lowerTriangularNonZeros:w,permutationEncodedArray:y}=((t,e)=>{let r=[],n=t-1;for(let t=0;t<n;t++)r.push([t,t,2*e]),r.push([t+1,t,-1*e]);return r[0][2]=e,r.push([n,n,e]),{lowerTriangularNonZeros:r,permutationEncodedArray:$o(r,t)}})(p,u),b=1;const x=p-1;let v=Number.MAX_SAFE_INTEGER;for(i=0;i<a&&Math.abs(h)>d;i++){let[t,r]=Do(w,e,n);if(s=Oo(t,p,y)(r),h=M(e,s,g),1===i){const{positive:t}=Pt(g);b=t}else{const t=Math.abs(v/h);if(t<1.01&&t>.99)break}v=h+0;for(let t=1;t<x;t++){const e=g[t];if(o[t]<1&&Math.abs(e)>b)n[t]=0;else{const r=e>0?-1:1;n[t]=Math.exp(r*(i*e)/Math.abs(h))}}n[0]=1,n[x]=1}return{corrected:g,baseline:s,iteration:i,error:h};function M(t,e,r){let n=0;for(let o=0;o<t.length;o++){let s=t[o]-e[o];s<0&&(n+=s),r[o]=s}return n}}function Yo(t){return Yo="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},Yo(t)}function Uo(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if("object"!==Yo(t)||r(t)||(e=t,t=[]),!r(t))throw new TypeError("input must be an array");var n=e,o=n.from,s=void 0===o?0:o,i=n.to,a=void 0===i?10:i,l=n.size,u=void 0===l?t.length:l,f=n.step;if(0!==u&&f)throw new Error("step is defined by the array size");if(u||(u=f?Math.floor((a-s)/f)+1:a-s+1),!f&&u&&(f=(a-s)/(u-1)),Array.isArray(t)){t.length=0;for(var c=0;c<u;c++)t.push(s),s+=f}else{if(t.length!==u)throw new Error("sequentialFill typed array must have the correct length");for(var h=0;h<u;h++)t[h]=s,s+=f}return t}function Vo(t,e){if(!r(t)||!r(e))throw new TypeError("x and y must be arrays");if(t.length!==e.length)throw new RangeError("x and y arrays must have the same length")}class qo{constructor(){if(new.target===qo)throw new Error("BaseRegression must be subclassed")}predict(t){if("number"==typeof t)return this._predict(t);if(r(t)){const e=[];for(const r of t)e.push(this._predict(r));return e}throw new TypeError("x must be a number or array")}_predict(t){throw new Error("_predict must be implemented")}train(){}toString(t){return""}toLaTeX(t){return""}score(t,e){Vo(t,e);const r=t.length,n=new Array(r);for(let e=0;e<r;e++)n[e]=this._predict(t[e]);let o=0,s=0,i=0,a=0,l=0,u=0,f=0;for(let t=0;t<r;t++)o+=n[t],s+=e[t],l+=n[t]*n[t],u+=e[t]*e[t],f+=n[t]*e[t],0!==e[t]&&(i+=(e[t]-n[t])*(e[t]-n[t])/e[t]),a+=(e[t]-n[t])*(e[t]-n[t]);const c=(r*f-o*s)/Math.sqrt((r*l-o*o)*(r*u-s*s));return{r:c,r2:c*c,chi2:i,rmsd:Math.sqrt(a/r)}}}function Go(t,e){return t<0?(t=0-t,"number"==typeof e?`- ${t.toPrecision(e)}`:`- ${t.toString()}`):"number"==typeof e?t.toPrecision(e):t.toString()}class Wo extends qo{constructor(t,e,r,n={}){if(super(),!0===t)this.degree=e.degree,this.powers=e.powers,this.coefficients=e.coefficients;else{Vo(t,e);const o=function(t,e,r,n={}){const o=t.length;let{interceptAtZero:s=!1}=n,i=[];if(Array.isArray(r))i=r,s=!1;else if("number"==typeof r)if(s){i=new Array(r);for(let t=0;t<r;t++)i[t]=t+1}else{i=new Array(r+1);for(let t=0;t<=r;t++)i[t]=t}const a=i.length,l=new ft(o,a),u=new ft([e]);for(let e=0;e<a;e++)for(let r=0;r<o;r++)0===i[e]?l.set(r,e,1):l.set(r,e,t[r]**i[e]);const f=new ct(l),c=f.mmul(l),h=f.mmul(new ct(u));return{coefficients:ht(c,h).to1DArray(),degree:Math.max(...i),powers:i}}(t,e,r,n);this.degree=o.degree,this.powers=o.powers,this.coefficients=o.coefficients}}_predict(t){let e=0;for(let r=0;r<this.powers.length;r++)e+=this.coefficients[r]*t**this.powers[r];return e}toJSON(){return{name:"polynomialRegression",degree:this.degree,powers:this.powers,coefficients:this.coefficients}}toString(t){return this._toFormula(t,!1)}toLaTeX(t){return this._toFormula(t,!0)}_toFormula(t,e){let r="^",n="",o=" * ";e&&(r="^{",n="}",o="");let s="",i="";for(let e=0;e<this.coefficients.length;e++)i="",0!==this.coefficients[e]&&(i=0===this.powers[e]?Go(this.coefficients[e],t):1===this.powers[e]?`${Go(this.coefficients[e],t)+o}x`:`${Go(this.coefficients[e],t)+o}x${r}${this.powers[e]}${n}`,this.coefficients[e]>0&&e!==this.coefficients.length-1?i=` + ${i}`:e!==this.coefficients.length-1&&(i=` ${i}`)),s=i+s;return s.startsWith("+")&&(s=s.slice(1)),`f(x) = ${s}`}static load(t){if("polynomialRegression"!==t.name)throw new TypeError("not a polynomial regression model");return new Wo(!0,t)}}function Ho(t,e={}){const r=t.length;let{x:n,regressionOptions:o}=e;n||(n=Uo({from:0,to:r-1,size:r}));let s=function(t,e,r={}){let{maxIterations:n=100,Regression:o=Wo,regressionOptions:s,tolerance:i=.001}=r;s||o!==Wo||(s=3);let a,l,u=e.slice(),f=e.slice(),c=e,h=0;for(;h<n;){l=new o(t,u,s),a=0;for(let e=0;e<u.length;e++)f[e]=l.predict(t[e]),u[e]>f[e]&&(u[e]=f[e]),a+=Math.abs((f[e]-c[e])/c[e]);if(a<i)break;c=f.slice(),h++}let m=new Array(u.length);for(let t=0;t<u.length;t++)m[t]=e[t]-u[t];return{corrected:m,delta:a,iteration:h,baseline:u,regression:l}}(n,t,o);return{baseline:s.baseline,correctedSpectrum:s.corrected}}function Zo(t,e={}){let r=Math.max(Math.round(.1*t.length),2),n=function(t,e={}){return Vt(t,mt,e)}(t,{...{window:r,padding:{size:r-1,algorithm:"duplicate",value:0}},...e}),o=new Float64Array(t.length);for(let e=0;e<o.length;e++)o[e]=t[e]-n[e];return{baseline:n,correctedSpectrum:o}}function Ko(t,e={}){const n=function(t,e={}){if(!r(t))throw new Error("Spectrum must be an array");if(0===t.length)throw new TypeError("Spectrum must not be empty");const n=t.length,o=new Float64Array(n),s=new Float64Array(n),i=new Float64Array(n),{windowM:a=Math.round(.04*n),windowS:l=Math.round(.08*n)}=e;for(let e=0;e<t.length;e++){const r=Math.max(0,e-a),n=Math.min(e+a+1,t.length);s[e]=vt(t,{fromIndex:r,toIndex:n})}for(let t=0;t<s.length;t++){const e=Math.max(0,t-a),r=Math.min(t+a+1,s.length);o[t]=xt(s,{fromIndex:e,toIndex:r})}for(let t=0;t<s.length;t++){const e=Math.max(0,t-l),r=Math.min(t+l+1,o.length);i[t]=mt(o.subarray(e,r))}return i}(t,e);let o=new Float64Array(t.length);for(let e=0;e<o.length;e++)o[e]=t[e]-n[e];return{baseline:n,correctedSpectrum:o}}function Jo(t,e={}){let r=Math.max(Math.round(.1*t.length),2),n=function(t,e={}){return Vt(t,o,e)}(t,{...{window:r,padding:{size:r-1,algorithm:"duplicate",value:0}},...e}),s=new Float64Array(t.length);for(let e=0;e<s.length;e++)s[e]=t[e]-n[e];return{baseline:n,correctedSpectrum:s}}function Qo(t,e,n={}){const{windowSize:o=9,derivative:s=0,polynomial:i=3}=n;if(o%2==0||o<5||!Number.isInteger(o))throw new RangeError("Invalid window size (should be odd and at least 5 integer number)");if(!r(t))throw new TypeError("Y values must be an array");if(void 0===e)throw new TypeError("X must be defined");if(o>t.length)throw new RangeError(`Window size is higher than the data length ${o}>${t.length}`);if(s<0||!Number.isInteger(s))throw new RangeError("Derivative should be a positive integer");if(i<1||!Number.isInteger(i))throw new RangeError("Polynomial should be a positive integer");i>=6&&console.warn("You should not use polynomial grade higher than 5 if you are not sure that your data arises from such a model. Possible polynomial oscillation problems");const a=Math.floor(o/2),l=t.length,u=new Float64Array(l),f=function(t,e,r){const n=new Array(t),o=Math.floor(t/2);for(let s=-o;s<=o;s++){n[s+o]=new Float64Array(t);for(let t=-o;t<=o;t++)n[s+o][t+o]=ns(t,s,o,e,r)}return n}(o,i,s);let c=0,h=!0;r(e)?h=!1:c=e**s;for(let r=0;r<a;r++){const n=f[a-r-1],i=f[a+r+1];let m=0,g=0;for(let e=0;e<o;e++)m+=n[e]*t[e],g+=i[e]*t[l-o+e];h?(u[a-r-1]=m/c,u[l-a+r]=g/c):(c=ts(e,a-r-1,a,s),u[a-r-1]=m/c,c=ts(e,l-a+r,a,s),u[l-a+r]=g/c)}const m=f[a];for(let r=o;r<=l;r++){let n=0;for(let e=0;e<o;e++)n+=m[e]*t[e+r-o];h||(c=ts(e,r-a-1,a,s)),u[r-a-1]=n/c}return u}function ts(t,e,r,n){let o=0,s=0;for(let n=e-r;n<e+r;n++)n>=0&&n<t.length-1&&(o+=t[n+1]-t[n],s++);return(o/s)**n}function es(t,e,r,n){let o=0;return o=r>0?(4*r-2)/(r*(2*e-r+1))*(t*es(t,e,r-1,n)+n*es(t,e,r-1,n-1))-(r-1)*(2*e+r)/(r*(2*e-r+1))*es(t,e,r-2,n):0===r&&0===n?1:0,o}function rs(t,e){let r=1;if(t>=e)for(let n=t-e+1;n<=t;n++)r*=n;return r}function ns(t,e,r,n,o){let s=0;for(let i=0;i<=n;i++)s+=(2*i+1)*(rs(2*r,i)/rs(2*r+i+1,i+1))*es(t,r,i,0)*es(e,r,i,o);return s}function os(t,e={}){let{noiseLevel:r}=e;const{sgOptions:n={windowSize:9,polynomial:3},smoothY:o=!1,maxCriteria:s=!0,minMaxRatio:i=25e-5,realTopDetection:a=!1}=e,{x:l}=t;let{y:u}=t;if(1!==Mt(l))throw new Error("GSD only accepts monotone increasing x values");u=u.slice();const f=function(t,e={}){if(t.length<3)return!0;const{tolerance:r=.05}=e;let n=0,o=Number.MAX_SAFE_INTEGER;for(let e=0;e<t.length-1;++e){const r=t[e+1]-t[e];r<o&&(o=r),r>n&&(n=r)}return(n-o)/n<r}(l);if(void 0===r)if(f){const t=Dt(u);r=s?t.median+1.5*t.sd:-t.median+1.5*t.sd}else r=0;else s||(r*=-1);if(!s)for(let t=0;t<u.length;t++)u[t]*=-1;if(void 0!==r)for(let t=0;t<u.length;t++)u[t]<r&&(u[t]=r);const c=f?l[1]-l[0]:l,h=o?Qo(u,c,{...n,derivative:0}):u,m=Qo(u,c,{...n,derivative:1}),g=Qo(u,c,{...n,derivative:2}),{min:d,max:p}=Et(h);if(d>p||d===p)return[];const w=d+(p-d)*i,y=l[1]-l[0];let b=null,x=null;const v=[],M=[],E=[];for(let t=1;t<h.length-1;++t)(m[t]<m[t-1]&&m[t]<=m[t+1]||m[t]<=m[t-1]&&m[t]<m[t+1])&&(x={x:l[t],index:t},y>0&&null!==b&&(M.push(b),E.push(x))),(m[t]>=m[t-1]&&m[t]>m[t+1]||m[t]>m[t-1]&&m[t]>=m[t+1])&&(b={x:l[t],index:t},y<0&&null!==x&&(M.push(b),E.push(x))),g[t]<g[t-1]&&g[t]<g[t+1]&&v.push(t);let A=-1;const I=[];for(const t of v){const e=l[t];let r=-1,n=A+1,o=Number.POSITIVE_INFINITY,s=0;for(;-1===r&&n<M.length&&(s=Math.abs(e-(M[n].x+E[n].x)/2),s<(E[n].x-M[n].x)/2&&(r=n,A=n),++n,!(s>=o));)o=s;if(-1!==r&&h[t]>w){const n=Math.abs(E[r].x-M[r].x);I.push({id:crypto.randomUUID(),x:e,y:h[t],width:n,index:t,ddY:g[t],inflectionPoints:{from:M[r],to:E[r]}})}}return a&&function(t,e){const{x:r,y:n}=t;for(const t of e){let e=t.index;if(n[e-1]>=n[e-2]&&n[e-1]>=n[e]?e--:n[e+1]>=n[e]&&n[e+1]>=n[e+2]?e++:n[e-2]>=n[e-3]&&n[e-2]>=n[e-1]?e-=2:n[e+2]>=n[e+1]&&n[e+2]>=n[e+3]&&(e+=2),n[e-1]>0&&n[e+1]>0&&n[e]>=n[e-1]&&n[e]>=n[e+1]&&(n[e]!==n[e-1]||n[e]!==n[e+1])){const o=20*Math.log10(n[e-1]),s=20*Math.log10(n[e]),i=20*Math.log10(n[e+1]),a=.5*(o-i)/(o-2*s+i),l=r[e],u=r[e-1];t.x=l+(l-u)*a,t.y=n[e]-.25*(n[e-1]-n[e+1])*a}}}({x:l,y:h},I),I.forEach(t=>{s||(t.y*=-1,t.ddY=-1*t.ddY)}),I.sort((t,e)=>t.x-e.x),I}var ss=Object.freeze({__proto__:null,airPLSBaseline:function(t){return t.y=function(t,e={}){const r=t.length;let{x:n,regressionOptions:o}=e;n||(n=Uo({from:0,to:r-1,size:r}));let s=Xo(n,t,o);return{baseline:s.baseline,correctedSpectrum:s.corrected}}(t.y).correctedSpectrum,{data:t}},calibrateX:function(t,e={}){const{targetX:r=0,nbPeaks:n=1,from:o=t.x[0],to:s=t.x.at(-1),gsd:i={minMaxRatio:.1,realTopDetection:!0,smoothY:!0,sgOptions:{windowSize:7,polynomial:3}}}=e,a=u(t.x,o),l=u(t.x,s),f=os({x:t.x.subarray(a,l),y:t.y.subarray(a,l)},i).sort((t,e)=>e.y-t.y).slice(0,n);if(f.length<n)return{data:t};const h=mt(f.map(t=>t.x));return{data:{x:c(t.x,r-h),y:t.y}}},centerMean:function(t){const{y:e}=t,r=mt(e);for(let t=0;t<e.length;t++)e[t]-=r;return{data:t}},centerMedian:function(t){const{y:e}=t,r=o(e);for(let t=0;t<e.length;t++)e[t]-=r;return{data:t}},divideBySD:function(t){const{y:e}=t,r=gt(e);for(let t=0;t<e.length;t++)e[t]/=r;return{data:t}},ensureGrowing:function(t){return{data:Qt(t)}},equallySpaced:function(t,e={}){return{data:ne(t,e)}},filterX:function(t,e={}){return{data:se(t,e)}},firstDerivative:function(t,e={}){const{x:r,y:n}=t;return{data:{x:r,y:Qo(n,r,{...e,derivative:1})}}},fromTo:function(t,e={}){const{fromIndex:r,toIndex:n}=f(t.x,e);return{data:{x:t.x.subarray(r,n+1),y:t.y.subarray(r,n+1)}}},iterativePolynomialBaseline:function(t){return t.y=Ho(t.y).correctedSpectrum,{data:t}},normed:function(t,e={}){return Yt(t.y,{...e,output:t.y}),{data:t}},paretoNormalization:function(t){return{data:{x:t.x,y:Ut(t.y)}}},rescale:function(t,e={}){return function(t,e={}){l(t);const r=n(e.output,t.length),o=vt(t),s=xt(t);if(o===s)throw new RangeError("minimum and maximum input values are equal. Cannot rescale a constant array");const{min:i=0,max:a=1}=e;if(i>=a)throw new RangeError("min option must be smaller than max option");const u=(a-i)/(s-o);for(let e=0;e<t.length;e++)r[e]=(t[e]-o)*u+i}(t.y,{...e,output:t.y}),{data:t}},reverseIfNeeded:function(t){return{data:ie(t)}},rollingAverageBaseline:function(t){return t.y=Zo(t.y).correctedSpectrum,{data:t}},rollingBallBaseline:function(t){return t.y=Ko(t.y).correctedSpectrum,{data:t}},rollingMedianBaseline:function(t){return t.y=Jo(t.y).correctedSpectrum,{data:t}},savitzkyGolay:function(t,e={}){const{x:r,y:n}=t;return{data:{x:r,y:Qo(n,r,e)}}},secondDerivative:function(t,e={}){const{x:r,y:n}=t;return{data:{x:r,y:Qo(n,r,{...e,derivative:2})}}},setMaxX:function(t,e={}){const{max:r=1}=e,n=xt(t.x);return n===r?{data:t}:{data:{x:c(t.x,r-n),y:t.y}}},setMaxY:function(t,e={}){const{max:r=1}=e,n=xt(t.y);return n===r?{data:t}:{data:{x:t.x,y:c(t.y,r-n)}}},setMinX:function(t,e={}){const{min:r=0}=e,n=vt(t.x);return n===r?{data:t}:{data:{x:c(t.x,r-n),y:t.y}}},setMinY:function(t,e={}){const{min:r=0}=e,n=vt(t.y);return n===r?{data:t}:{data:{x:t.x,y:c(t.y,r-n)}}},thirdDerivative:function(t,e={}){const{x:r,y:n}=t;return{data:{x:r,y:Qo(n,r,{...e,derivative:3})}}},xFunction:function(t,e={}){return{data:{x:h(t.x,{variableLabel:"x",fctString:e.function}),y:t.y}}},yFunction:function(t,e={}){return{data:{x:t.x,y:h(t.y,{variableLabel:"y",fctString:e.function})}}}});function is(t,e={}){Kt(t);let{filters:r=[],from:n=t.x[0],to:o=t.x.at(-1),numberOfPoints:s=1024,applyRangeSelectionFirst:i=!1,exclusions:a=[]}=e;r=structuredClone(r);const l={name:"equallySpaced",options:{from:n,to:o,numberOfPoints:s,exclusions:a}};i?r.unshift(l):r.push(l);const u=function(t,e){let r={data:ie({x:dt(t.x),y:dt(t.y)})};const n=[];for(const t of e){const e=Date.now(),o=ss[t.name];if(!o)throw new Error(`Unknown filter: ${t.name}`);r=o(r.data,t.options),r.data=ie(r.data),n.push({name:t.name,time:Date.now()-e})}return{logs:n,data:r.data}}(t,r).data,f={x:{min:u.x[0],max:u.x.at(-1)},y:Et(u.y)};return{data:u,allowedBoundary:f}}class as{constructor(t,e,r,n={}){const{meta:o={},normalization:s={},normalized:i}=n;t&&t.length>1&&t[0]>t.at(-1)?(this.x=t.toReversed(),this.y=e.toReversed()):(this.x=t||[],this.y=e||[]),this.id=r,this.meta=o,this.normalizedBoundary={x:{min:0,max:0},y:{min:0,max:0}},i?(this.normalized=i,this.updateNormalizedBoundary(),this.normalizedAllowedBoundary=this.normalizedBoundary):this.updateNormalization(s),this.updateMemory()}get minX(){return this.x[0]}get maxX(){return this.x.at(-1)}updateMemory(){let t=16*(this.x&&this.x.length>0||0),e=16*this.normalized.x.length;this.memory={original:t,normalized:e,total:t+e}}removeOriginal(){this.x=void 0,this.y=void 0,this.updateMemory()}getXY(){if(!Array.isArray(this.x)||!Array.isArray(this.y))throw new Error("Can not get normalized data");return{x:this.x,y:this.y}}updateRangesInfo(t){!function(t,e=[]){t.ranges={};for(let r of e){r=structuredClone(r),t.ranges[r.label]=r;let e={fromIndex:u(t.normalized.x,r.from),toIndex:u(t.normalized.x,r.to)};r.deltaX=t.normalized.x[e.toIndex]-t.normalized.x[e.fromIndex],r.baseline=(t.normalized.y[e.toIndex]+t.normalized.y[e.fromIndex])*r.deltaX/2,r.integration=ae(t.normalized,e),r.correctedIntegration=r.integration-r.baseline,r.maxPoint=Jt(t.normalized,e),r.minPoint=le(t.normalized,e),r.x=t.normalized.x.slice(e.fromIndex,e.toIndex+1),r.y=t.normalized.y.slice(e.fromIndex,e.toIndex+1)}}(this,t)}updateNormalization(t){const e=is(this,t);this.normalized=e.data,this.normalizedAllowedBoundary=e.allowedBoundary,this.ranges={},this.updateMemory(),this.updateNormalizedBoundary()}getData(t){return function(t,e={}){const{xFilter:r={},yFactor:n=1}=e;let o={x:t.x,y:t.y};return r&&(o=se(t,r)),n&&1!==n&&(o.y=o.y.map(t=>t*n)),o}(this,t)}updateNormalizedBoundary(){this.normalizedBoundary.x={min:this.normalized.x[0],max:this.normalized.x.at(-1)},this.normalizedBoundary.y=Et(this.normalized.y)}}class ls{constructor(t={}){this.normalization=t.normalization,this.maxMemory=t.maxMemory||268435456,this.keepOriginal=!0,this.spectra=[]}getNormalizationAnnotations(){return function(t={}){let{exclusions:e=[]}=t,r=[];return e=e.filter(t=>!t.ignore),r=e.map(t=>({type:"rect",position:[{x:t.from,y:"0px"},{x:t.to,y:"2000px"}],strokeWidth:0,fillColor:"rgba(255,255,224,1)"})),void 0!==t.from&&r.push({type:"rect",position:[{x:Number.MIN_SAFE_INTEGER,y:"0px"},{x:t.from,y:"2000px"}],strokeWidth:0,fillColor:"rgba(255,255,224,1)"}),void 0!==t.to&&r.push({type:"rect",position:[{x:t.to,y:"0px"},{x:Number.MAX_SAFE_INTEGER,y:"2000px"}],strokeWidth:0,fillColor:"rgba(255,255,224,1)"}),r}(this.normalization,this.getNormalizedBoundary())}setNormalization(t={}){if(JSON.stringify(this.normalization)!==JSON.stringify(t)){this.normalization=t;for(let t of this.spectra)t.updateNormalization(this.normalization)}}getNormalization(){return this.normalization}getAutocorrelation(t,e={}){const{x:r}=e,n=this.getNormalizedData(e);return void 0===t&&void 0!==r&&(t=u(n.x,r)),function(t,e){let r=t.matrix,n=r.length,o=r[0].length,s=new Float64Array(n),i=new Float64Array(n),a=new Array(o);for(let t=0;t<n;t++)s[t]=r[t][e];for(let t=0;t<o;t++){for(let e=0;e<n;e++)i[e]=r[e][t];a[t]=d(s,i)}return{x:t.x,y:a}}(n,t)}getMeanData(t){return function(t){let e=new ft(t.matrix);return{x:t.x,y:e.mean("column")}}(this.getNormalizedData(t))}getNormalizedData(t={}){const{ids:e}=t;return Wn(this.getSpectra(e))}getNormalizedText(t={}){const{ids:e}=t;return function(t,e={}){let{fs:r="\t",rs:n="\n"}=e;return ko(Wn(t),{rs:n,fs:r})}(this.getSpectra(e),t)}getPostProcessedText(t={}){return function(t,e={}){let{fs:r="\t",rs:n="\n",postProcessing:o={}}=e;return ko(Lo(t,o),{rs:n,fs:r})}(this,t)}getMinMaxX(){let t=Number.MAX_VALUE,e=Number.MIN_VALUE;for(let r of this.spectra)r.minX<t&&(t=r.minX),r.maxX>e&&(e=r.maxX);return{min:t,max:e}}getPostProcessedData(t){return Lo(this,t)}addFromText(t,e={}){if(!0!==e.force&&e.id&&this.contains(e.id))return;let r=function(t,e={}){const{kind:r,parserOptions:n={}}=e,o=_o(t,n);return r&&r.importation&&r.importation.converter&&(o.y=o.y.map(r.importation.converter)),{data:o}}(t,e),n={...r.meta,...e.meta};this.addFromData(r.data,{meta:n,id:e.id})}addFromJcamp(t,e={}){if(!0!==e.force&&e.id&&this.contains(e.id))return;let r=No(t),n={...r.info,...r.meta,...e.meta};this.addFromData(r.data,{meta:n,id:e.id})}updateRangesInfo(t){for(let e of this.spectra)e.updateRangesInfo(t)}getMetadata(t={}){const{ids:e}=t;return function(t,e={}){const{ids:r}=e;let n=[];if(Array.isArray(t)&&t.length>0)for(let e of t)r&&!r.includes(e.id)||n.push(e.meta);return n}(this.getSpectra(e))}getClasses(t){return function(t,e={}){const{propertyName:r="category"}=e,n=Hn(t,e),o=new Array(t.length);for(let e=0;e<t.length;e++)o[e]=n[t[e][r]].classNumber;return o}(this.getMetadata(t),t)}getClassLabels(t){return function(t,e={}){const{propertyName:r="category"}=e,n=[];for(const e of t)n.push(e[r]);return n}(this.getMetadata(t),t)}getCategoriesStats(t){return Hn(this.getMetadata(),t)}addFromData(t,e={}){0===this.spectra.length&&(this.keepOriginal=!0);const r=e.id||Math.random().toString(36).slice(2,10);let n=this.getSpectrumIndex(r);void 0===n&&(n=this.spectra.length);let o=new as(t.x,t.y,r,{meta:e.meta,normalized:e.normalized,normalization:this.normalization});if(this.spectra[n]=o,this.keepOriginal){this.getMemoryInfo().total>this.maxMemory&&(this.keepOriginal=!1,this.removeOriginals())}else o.removeOriginal()}removeOriginals(){for(let t of this.spectra)t.removeOriginal()}removeSpectrum(t){let e=this.getSpectrumIndex(t);if(void 0!==e)return this.spectra.splice(e,1)}removeSpectraNotIn(t){let e=this.spectra.map(t=>t.id);for(let r of e)t.includes(r)||this.removeSpectrum(r)}contains(t){return void 0!==this.getSpectrumIndex(t)}getSpectrumIndex(t){if(t)for(let e=0;e<this.spectra.length;e++){if(this.spectra[e].id===t)return e}}getIDs(){return this.spectra.map(t=>t.id)}getSpectra(t){if(!t||!Array.isArray(t))return this.spectra;let e=[];for(let r of t){let t=this.getSpectrumIndex(r);void 0!==t&&e.push(this.spectra[t])}return e}getSpectrum(t){let e=this.getSpectrumIndex(t);if(void 0!==e)return this.spectra[e]}getChart(t){return function(t,e={}){const{ids:r,yFactor:n,xFilter:o={}}=e;let s={data:[]};for(let e of t)if(!r||r.includes(e.id)){let t=e.getData({yFactor:n,xFilter:o});Gn(t,e),s.data.push(t)}return s}(this.spectra,t)}getAutocorrelationChart(t,e){return function(t,e,r={}){const{autocorrelation:n=t.getAutocorrelation(e,r),xFilter:o,ids:s}=r,{min:i,max:a}=Et(n.y);let l=Fr(["blue","cyan","yellow","red"]).domain([i,a]).mode("lch"),u=n.y.map(t=>`rgb(${l(t).rgb().join(",")})`),f=t.getMeanData({ids:s});return o&&(f=se({x:f.x,y:f.y},o)),{type:"color",x:f.x,y:f.y,color:u,styles:{unselected:{lineWidth:1,lineStyle:1},selected:{lineWidth:3,lineStyle:1}}}}(this,t,e)}getTrackAnnotation(t,e){return function(t,e,r={}){const{ids:n,showSpectrumID:o=!0,sortY:s=!0,limit:i=20}=r;let a=[],l=Wn(t,{ids:n});if(0===l.ids.length)return a;let u=0;a.push({type:"line",position:[{x:"70px",y:15+15*u+"px"},{x:"85px",y:15+15*u+"px"}],strokeWidth:1e-7,label:{size:16,text:`x: ${l.x[e].toPrecision(6)}`,position:{x:"130px",y:20+15*u+"px"}}}),u++;let f=[];for(let t=0;t<l.ids.length;t++)f.push({id:l.ids[t],meta:l.meta[t],y:l.matrix[t][e]});s&&(f=f.sort((t,e)=>e.y-t.y)),i&&(f=f.slice(0,i));for(let{id:t,meta:e,y:r}of f)a.push({type:"line",position:[{x:"70px",y:15+15*u+"px"},{x:"85px",y:15+15*u+"px"}],strokeColor:e.color,strokeWidth:2,label:{text:`${r.toPrecision(4)}${o?` - ${t}`:""}`,position:{x:"90px",y:20+15*u+"px"}}}),u++;return a}(this.spectra,t,e)}getBoxPlotChart(t={}){return function(t,e={}){const{q13FillColor:r="#000",q13FillOpacity:n=.3,medianStrokeColor:o="",medianStrokeWidth:s=3,minMaxFillColor:i="#000",minMaxFillOpacity:a=.15}=e;let l=[];const u=Vn(t);if(n&&r){let t=[];for(let e=0;e<u.x.length;e++)t.push({x:u.x[e],y:u.q1[e]});for(let e=u.x.length-1;e>=0;e--)t.push({x:u.x[e],y:u.q3[e]});l.push({type:"polygon",layer:0,properties:{fillColor:r,fillOpacity:n,strokeWidth:1e-7,position:t}})}if(i&&a){let t=[];for(let e=0;e<u.x.length;e++)t.push({x:u.x[e],y:u.min[e]});for(let e=u.x.length-1;e>=0;e--)t.push({x:u.x[e],y:u.max[e]});l.push({type:"polygon",layer:0,properties:{fillColor:i,fillOpacity:a,strokeWidth:1e-7,strokeColor:"#FFF",position:t}})}return{type:"color",data:{x:u.x,y:u.median,color:o?new Array(u.x.length).fill(o):qn(t.matrix)},styles:{unselected:{lineWidth:s,lineStyle:1},selected:{lineWidth:s,lineStyle:1}},annotations:l}}(this.getNormalizedData(t),t)}getBoxPlotData(t={}){return Vn(this.getNormalizedData(t))}getNormalizedChart(t={}){const{ids:e}=t;return function(t,e={}){const{xFilter:r}=e;let n={data:[]};for(let e of t){let t=e.normalized;r&&(t=se(t,r)),Gn(t,e),n.data.push(t)}return n}(this.getSpectra(e),t)}getPostProcessedChart(t){return function(t,e={}){let r=t.getPostProcessedData(e),n={data:[]};if(!r||!r.matrix)return n;for(let t=0;t<r.matrix.length;t++){let e={x:r.x,y:Array.from(r.matrix[t])};Gn(e,{meta:r.meta[t],id:r.ids[t]}),n.data.push(e)}return n}(this,t)}getMemoryInfo(){let t={original:0,normalized:0,total:0};for(const e of this.spectra){let r=e.memory;t.original+=r.original,t.normalized+=r.normalized,t.total+=r.total}return t.keepOriginal=this.keepOriginal,t.maxMemory=this.maxMemory,t}getNormalizedBoundary(){let t={x:{min:Number.MAX_VALUE,max:Number.MIN_VALUE},y:{min:Number.MAX_VALUE,max:Number.MIN_VALUE}};for(let e of this.spectra)e.normalizedBoundary.x.min<t.x.min&&(t.x.min=e.normalizedBoundary.x.min),e.normalizedBoundary.x.max>t.x.max&&(t.x.max=e.normalizedBoundary.x.max),e.normalizedBoundary.y.min<t.y.min&&(t.y.min=e.normalizedBoundary.y.min),e.normalizedBoundary.y.max>t.y.max&&(t.y.max=e.normalizedBoundary.y.max);return t}getNormalizedCommonBoundary(){let t={x:{min:Number.NEGATIVE_INFINITY,max:Number.POSITIVE_INFINITY},y:{min:Number.POSITIVE_INFINITY,max:Number.NEGATIVE_INFINITY}};for(let e of this.spectra)e.normalizedAllowedBoundary.x.min>t.x.min&&(t.x.min=e.normalizedAllowedBoundary.x.min),e.normalizedAllowedBoundary.x.max<t.x.max&&(t.x.max=e.normalizedAllowedBoundary.x.max),e.normalizedAllowedBoundary.y.min<t.y.min&&(t.y.min=e.normalizedAllowedBoundary.y.min),e.normalizedAllowedBoundary.y.max>t.y.max&&(t.y.max=e.normalizedAllowedBoundary.y.max);return t}static fromNormalizedMatrix(t,e={}){let r=function(t,e={}){const r=t.split(/[\n\r]+/).filter(Boolean),{fs:n="\t"}=e;let o=[],s=[],i=[],a=[],l=r[0].split(n),u=[];for(let t=0;t<l.length;t++){let e=l[t];if(!Number.isNaN(Number(e))){a=l.slice(t).map(Number);break}u[t]=e}for(let t=1;t<r.length;t++){let e=r[t].split("\t");s.push(e[0]);let n={};i.push(n);for(let t=1;t<e.length;t++){if(!(t<u.length)){o.push(e.slice(u.length).map(Number));break}n[u[t]]=e[t]}}return{x:a,meta:i,matrix:o,ids:s}}(t,e);if(!r)throw new Error("Can not parse TSV file");let n=new ls;n.setNormalization({from:r.x[0],to:r.x.at(-1),numberOfPoints:r.x.length});for(let t=0;t<r.ids.length;t++)n.addFromData({x:[],y:[]},{normalized:{x:r.x,y:r.matrix[t]},id:r.ids[t],meta:r.meta[t]});return n.keepOriginal=!1,n}}t.SpectraProcessor=ls,t.getFilterAnnotations=function(t={}){let{exclusions:e=[]}=t,r=[];return e=e.filter(t=>!t.ignore),r=e.map(t=>({type:"rect",position:[{x:t.from,y:"0px"},{x:t.to,y:"2000px"}],strokeWidth:0,fillColor:"rgba(255,255,128,1)"})),void 0!==t.from&&r.push({type:"rect",position:[{x:Number.MIN_SAFE_INTEGER,y:"0px"},{x:t.from,y:"2000px"}],strokeWidth:0,fillColor:"rgba(255,255,224,1)"}),void 0!==t.to&&r.push({type:"rect",position:[{x:t.to,y:"0px"},{x:Number.MAX_SAFE_INTEGER,y:"2000px"}],strokeWidth:0,fillColor:"rgba(255,255,224,1)"}),r},t.xFindClosestIndex=u});
//# sourceMappingURL=spectra-processor.umd.min.js.map
