/**
 * ghs-hazard - Generation information about GHS hazards
 * @version v0.0.1
 * @link https://github.com/cheminfo/ghs-hazard#readme
 * @license MIT
 */
(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
    typeof define === 'function' && define.amd ? define(['exports'], factory) :
    (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.GHS = {}));
})(this, (function (exports) { 'use strict';

    const ghs = {
      "hStatements": [{
        "hCode": "H200",
        "hStatement": "(Deleted) Unstable Explosive"
      }, {
        "hCode": "H201",
        "hStatement": "(Deleted) Explosive; mass explosion hazard"
      }, {
        "hCode": "H202",
        "hStatement": "(Deleted) Explosive; severe projection hazard"
      }, {
        "hCode": "H203",
        "hStatement": "(Deleted) Explosive; fire, blast or projection hazard"
      }, {
        "hCode": "H204",
        "hStatement": "Fire or projection hazard"
      }, {
        "hCode": "H205",
        "hStatement": "(Deleted) May mass explode in fire"
      }, {
        "hCode": "H206",
        "hStatement": "Fire, blast or projection hazard; increased risk of explosion if desensitizing agent is reduced"
      }, {
        "hCode": "H207",
        "hStatement": "Fire or projection hazard; increased risk of explosion if desensitizing agent is reduced"
      }, {
        "hCode": "H208",
        "hStatement": "Fire hazard; increased risk of explosion if desensitizing agent is reduced"
      }, {
        "hCode": "H209",
        "hStatement": "Explosive"
      }, {
        "hCode": "H210",
        "hStatement": "Very sensitive"
      }, {
        "hCode": "H211",
        "hStatement": "Maybe sensitive"
      }, {
        "hCode": "H220",
        "hStatement": "Extremely flammable gas"
      }, {
        "hCode": "H221",
        "hStatement": "Flammable gas"
      }, {
        "hCode": "H222",
        "hStatement": "Extremely flammable aerosol"
      }, {
        "hCode": "H223",
        "hStatement": "Flammable aerosol"
      }, {
        "hCode": "H224",
        "hStatement": "Extremely flammable liquid and vapor"
      }, {
        "hCode": "H225",
        "hStatement": "Highly Flammable liquid and vapor"
      }, {
        "hCode": "H226",
        "hStatement": "Flammable liquid and vapor"
      }, {
        "hCode": "H227",
        "hStatement": "Combustible liquid"
      }, {
        "hCode": "H228",
        "hStatement": "Flammable solid"
      }, {
        "hCode": "H229",
        "hStatement": "Pressurized container: may burst if heated"
      }, {
        "hCode": "H230",
        "hStatement": "May react explosively even in the absence of air"
      }, {
        "hCode": "H231",
        "hStatement": "May react explosively even in the absence of air at elevated pressure and/or temperature"
      }, {
        "hCode": "H232",
        "hStatement": "May ignite spontaneously if exposed to air"
      }, {
        "hCode": "H240",
        "hStatement": "Heating may cause an explosion"
      }, {
        "hCode": "H241",
        "hStatement": "Heating may cause a fire or explosion"
      }, {
        "hCode": "H242",
        "hStatement": "Heating may cause a fire"
      }, {
        "hCode": "H250",
        "hStatement": "Catches fire spontaneously if exposed to air"
      }, {
        "hCode": "H251",
        "hStatement": "Self-heating; may catch fire"
      }, {
        "hCode": "H252",
        "hStatement": "Self-heating in large quantities; may catch fire"
      }, {
        "hCode": "H260",
        "hStatement": "In contact with water releases flammable gases which may ignite spontaneously"
      }, {
        "hCode": "H261",
        "hStatement": "In contact with water releases flammable gas"
      }, {
        "hCode": "H270",
        "hStatement": "May cause or intensify fire; oxidizer"
      }, {
        "hCode": "H271",
        "hStatement": "May cause fire or explosion; strong Oxidizer"
      }, {
        "hCode": "H272",
        "hStatement": "May intensify fire; oxidizer"
      }, {
        "hCode": "H280",
        "hStatement": "Contains gas under pressure; may explode if heated"
      }, {
        "hCode": "H281",
        "hStatement": "Contains refrigerated gas; may cause cryogenic burns or injury"
      }, {
        "hCode": "H282",
        "hStatement": "Extremely flammable chemical under pressure: may explode if heated"
      }, {
        "hCode": "H283",
        "hStatement": "Flammable chemical under pressure: may explode if heated"
      }, {
        "hCode": "H284",
        "hStatement": "Chemical under pressure: may explode if heated"
      }, {
        "hCode": "H290",
        "hStatement": "May be corrosive to metals"
      }, {
        "hCode": "H300",
        "hStatement": "Fatal if swallowed"
      }, {
        "hCode": "H301",
        "hStatement": "Toxic if swallowed"
      }, {
        "hCode": "H302",
        "hStatement": "Harmful if swallowed"
      }, {
        "hCode": "H303",
        "hStatement": "May be harmful if swallowed"
      }, {
        "hCode": "H304",
        "hStatement": "May be fatal if swallowed and enters airways"
      }, {
        "hCode": "H305",
        "hStatement": "May be harmful if swallowed and enters airways"
      }, {
        "hCode": "H310",
        "hStatement": "Fatal in contact with skin"
      }, {
        "hCode": "H311",
        "hStatement": "Toxic in contact with skin"
      }, {
        "hCode": "H312",
        "hStatement": "Harmful in contact with skin"
      }, {
        "hCode": "H313",
        "hStatement": "May be harmful in contact with skin"
      }, {
        "hCode": "H314",
        "hStatement": "Causes severe skin burns and eye damage"
      }, {
        "hCode": "H315",
        "hStatement": "Causes skin irritation"
      }, {
        "hCode": "H316",
        "hStatement": "Causes mild skin irritation"
      }, {
        "hCode": "H317",
        "hStatement": "May cause an allergic skin reaction"
      }, {
        "hCode": "H318",
        "hStatement": "Causes serious eye damage"
      }, {
        "hCode": "H319",
        "hStatement": "Causes serious eye irritation"
      }, {
        "hCode": "H320",
        "hStatement": "Causes eye irritation"
      }, {
        "hCode": "H330",
        "hStatement": "Fatal if inhaled"
      }, {
        "hCode": "H331",
        "hStatement": "Toxic if inhaled"
      }, {
        "hCode": "H332",
        "hStatement": "Harmful if inhaled"
      }, {
        "hCode": "H333",
        "hStatement": "May be harmful if inhaled"
      }, {
        "hCode": "H334",
        "hStatement": "May cause allergy or asthma symptoms or breathing difficulties if inhaled"
      }, {
        "hCode": "H335",
        "hStatement": "May cause respiratory irritation"
      }, {
        "hCode": "H336",
        "hStatement": "May cause drowsiness or dizziness"
      }, {
        "hCode": "H340",
        "hStatement": "May cause genetic defects"
      }, {
        "hCode": "H341",
        "hStatement": "Suspected of causing genetic defects"
      }, {
        "hCode": "H350",
        "hStatement": "May cause cancer"
      }, {
        "hCode": "H350i",
        "hStatement": "May cause cancer by inhalation"
      }, {
        "hCode": "H351",
        "hStatement": "Suspected of causing cancer"
      }, {
        "hCode": "H360",
        "hStatement": "May damage fertility or the unborn child"
      }, {
        "hCode": "H360F",
        "hStatement": "May damage fertility"
      }, {
        "hCode": "H360D",
        "hStatement": "May damage the unborn child"
      }, {
        "hCode": "H360FD",
        "hStatement": "May damage fertility; May damage the unborn child"
      }, {
        "hCode": "H360Fd",
        "hStatement": "May damage fertility; Suspected of damaging the unborn child"
      }, {
        "hCode": "H360Df",
        "hStatement": "May damage the unborn child; Suspected of damaging fertility"
      }, {
        "hCode": "H361",
        "hStatement": "Suspected of damaging fertility or the unborn child"
      }, {
        "hCode": "H361f",
        "hStatement": "Suspected of damaging fertility"
      }, {
        "hCode": "H361d",
        "hStatement": "Suspected of damaging the unborn child"
      }, {
        "hCode": "H361fd",
        "hStatement": "Suspected of damaging fertility; Suspected of damaging the unborn child"
      }, {
        "hCode": "H362",
        "hStatement": "May cause harm to breast-fed children"
      }, {
        "hCode": "H370",
        "hStatement": "Causes damage to organs"
      }, {
        "hCode": "H371",
        "hStatement": "May cause damage to organs"
      }, {
        "hCode": "H372",
        "hStatement": "Causes damage to organs through prolonged or repeated exposure"
      }, {
        "hCode": "H373",
        "hStatement": "May causes damage to organs through prolonged or repeated exposure"
      }, {
        "hCode": "H400",
        "hStatement": "Very toxic to aquatic life"
      }, {
        "hCode": "H401",
        "hStatement": "Toxic to aquatic life"
      }, {
        "hCode": "H402",
        "hStatement": "Harmful to aquatic life"
      }, {
        "hCode": "H410",
        "hStatement": "Very toxic to aquatic life with long lasting effects"
      }, {
        "hCode": "H411",
        "hStatement": "Toxic to aquatic life with long lasting effects"
      }, {
        "hCode": "H412",
        "hStatement": "Harmful to aquatic life with long lasting effects"
      }, {
        "hCode": "H413",
        "hStatement": "May cause long lasting harmful effects to aquatic life"
      }, {
        "hCode": "H420",
        "hStatement": "Harms public health and the environment by destroying ozone in the upper atmosphere"
      }, {
        "hCode": "H300+H310",
        "hStatement": "Fatal if swallowed or in contact with skin"
      }, {
        "hCode": "H300+H330",
        "hStatement": "Fatal if swallowed or if inhaled"
      }, {
        "hCode": "H310+H330",
        "hStatement": "Fatal in contact with skin or if inhaled"
      }, {
        "hCode": "H300+H310+H330",
        "hStatement": "Fatal if swallowed, in contact with skin or if inhaled"
      }, {
        "hCode": "H301+H311",
        "hStatement": "Toxic if swallowed or in contact with skin"
      }, {
        "hCode": "H301+H331",
        "hStatement": "Toxic if swallowed or if inhaled"
      }, {
        "hCode": "H311+H331",
        "hStatement": "Toxic in contact with skin or if inhaled."
      }, {
        "hCode": "H301+H311+H331",
        "hStatement": "Toxic if swallowed, in contact with skin or if inhaled"
      }, {
        "hCode": "H302+H312",
        "hStatement": "Harmful if swallowed or in contact with skin"
      }, {
        "hCode": "H302+H332",
        "hStatement": "Harmful if swallowed or if inhaled"
      }, {
        "hCode": "H312+H332",
        "hStatement": "Harmful in contact with skin or if inhaled"
      }, {
        "hCode": "H302+H312+H332",
        "hStatement": "Harmful if swallowed, in contact with skin or if inhaled"
      }, {
        "hCode": "H303+H313",
        "hStatement": "May be harmful if swallowed or in contact with skin"
      }, {
        "hCode": "H303+H333",
        "hStatement": "May be harmful if swallowed or if inhaled"
      }, {
        "hCode": "H313+H333",
        "hStatement": "May be harmful in contact with skin or if inhaled"
      }, {
        "hCode": "H303+H313+H333",
        "hStatement": "May be harmful if swallowed, in contact with skin or if inhaled"
      }, {
        "hCode": "H315+H320",
        "hStatement": "Cause skin and eye irritation"
      }, {
        "hCode": "EUH001",
        "hStatement": "Explosive when dry"
      }, {
        "hCode": "EUH006",
        "hStatement": "Explosive with or without contact with air"
      }, {
        "hCode": "EUH014",
        "hStatement": "Reacts violently with water"
      }, {
        "hCode": "EUH018",
        "hStatement": "In use may form flammable/explosive vapour-air mixture"
      }, {
        "hCode": "EUH019",
        "hStatement": "May form explosive peroxides"
      }, {
        "hCode": "EUH044",
        "hStatement": "Risk of explosion if heated under confinement"
      }, {
        "hCode": "EUH029",
        "hStatement": "Contact with water liberates toxic gas"
      }, {
        "hCode": "EUH031",
        "hStatement": "Contact with acids liberates toxic gas"
      }, {
        "hCode": "EUH032",
        "hStatement": "Contact with acids liberates very toxic gas"
      }, {
        "hCode": "EUH066",
        "hStatement": "Repeated exposure may cause skin dryness or cracking"
      }, {
        "hCode": "EUH070",
        "hStatement": "Toxic by eye contact"
      }, {
        "hCode": "EUH071",
        "hStatement": "Corrosive to the respiratory tract"
      }, {
        "hCode": "EUH059",
        "hStatement": "Hazardous to the ozone layer, superseded by GHS Class 5.1 in the second adaptation to technical progress of CLP."
      }, {
        "hCode": "EUH201",
        "hStatement": "Contains lead. Should not be used on surfaces liable to be chewed or sucked by children."
      }, {
        "hCode": "EUH201A",
        "hStatement": "Warning! Contains lead."
      }, {
        "hCode": "EUH202",
        "hStatement": "Cyanoacrylate. Danger. Bonds skin and eyes in seconds. Keep out of the reach of children."
      }, {
        "hCode": "EUH203",
        "hStatement": "Contains chromium(VI). May produce an allergic reaction."
      }, {
        "hCode": "EUH204",
        "hStatement": "Contains isocyanates. May produce an allergic reaction."
      }, {
        "hCode": "EUH205",
        "hStatement": "Contains epoxy constituents. May produce an allergic reaction."
      }, {
        "hCode": "EUH206",
        "hStatement": "Warning! Do not use together with other products. May release dangerous gases (chlorine)."
      }, {
        "hCode": "EUH207",
        "hStatement": "Warning! Contains cadmium. Dangerous fumes are formed during use. See information supplied by the manufacturer. Comply with the safety instructions."
      }, {
        "hCode": "EUH208",
        "hStatement": "Contains <name of sensitising substance>. May produce an allergic reaction."
      }, {
        "hCode": "EUH209",
        "hStatement": "Can become highly flammable in use."
      }, {
        "hCode": "EUH209A",
        "hStatement": "Can become flammable in use."
      }, {
        "hCode": "EUH210",
        "hStatement": "Safety data sheet available on request."
      }, {
        "hCode": "EUH401",
        "hStatement": "To avoid risks to human health and the environment, comply with the instructions for use."
      }],
      "pStatements": [{
        "pCode": "P101",
        "pStatement": "If medical advice is needed, have product container or label at hand."
      }, {
        "pCode": "P102",
        "pStatement": "Keep out of reach of children."
      }, {
        "pCode": "P103",
        "pStatement": "Read carefully and follow all instructions."
      }, {
        "pCode": "P201",
        "pStatement": "(Deleted) Obtain special instructions before use."
      }, {
        "pCode": "P202",
        "pStatement": "(Deleted) Do not handle until all safety precautions have been read and understood."
      }, {
        "pCode": "P203",
        "pStatement": "Obtain, read and follow all safety instructions before use."
      }, {
        "pCode": "P210",
        "pStatement": "Keep away from heat, hot surface, sparks, open flames and other ignition sources. No smoking."
      }, {
        "pCode": "P211",
        "pStatement": "Do not spray on an open flame or other ignition source."
      }, {
        "pCode": "P212",
        "pStatement": "Avoid heating under confinement or reduction of the desensitized agent."
      }, {
        "pCode": "P220",
        "pStatement": "Keep away from clothing and other combustible materials."
      }, {
        "pCode": "P221",
        "pStatement": "(Deleted) Take any precaution to avoid mixing with combustibles/..."
      }, {
        "pCode": "P222",
        "pStatement": "Do not allow contact with air."
      }, {
        "pCode": "P223",
        "pStatement": "Do not allow contact with water."
      }, {
        "pCode": "P230",
        "pStatement": "Keep wetted with ..."
      }, {
        "pCode": "P231",
        "pStatement": "Handle and store contents under inert gas/..."
      }, {
        "pCode": "P232",
        "pStatement": "Protect from moisture."
      }, {
        "pCode": "P233",
        "pStatement": "Keep container tightly closed."
      }, {
        "pCode": "P234",
        "pStatement": "Keep only in original container."
      }, {
        "pCode": "P235",
        "pStatement": "Keep cool."
      }, {
        "pCode": "P236",
        "pStatement": "Keep only in original packaging; Division .. in the transport configuraion."
      }, {
        "pCode": "P240",
        "pStatement": "Ground/bond container and receiving equipment."
      }, {
        "pCode": "P241",
        "pStatement": "Use explosion-proof [electrical/ventilating/lighting/.../] equipment."
      }, {
        "pCode": "P242",
        "pStatement": "Use only non-sparking tools."
      }, {
        "pCode": "P243",
        "pStatement": "Take precautionary measures against static discharge."
      }, {
        "pCode": "P244",
        "pStatement": "Keep valves and fittings free from oil and grease."
      }, {
        "pCode": "P250",
        "pStatement": "Do not subject to grinding/shock/friction/..."
      }, {
        "pCode": "P251",
        "pStatement": "Do not pierce or burn, even after use."
      }, {
        "pCode": "P260",
        "pStatement": "Do not breathe dust/fume/gas/mist/vapors/spray."
      }, {
        "pCode": "P261",
        "pStatement": "Avoid breathing dust/fume/gas/mist/vapors/spray."
      }, {
        "pCode": "P262",
        "pStatement": "Do not get in eyes, on skin, or on clothing."
      }, {
        "pCode": "P263",
        "pStatement": "Avoid contact during pregnancy/while nursing."
      }, {
        "pCode": "P264",
        "pStatement": "Wash hands [and ...] thoroughly after handling."
      }, {
        "pCode": "P265",
        "pStatement": "Do not touch eyes."
      }, {
        "pCode": "P270",
        "pStatement": "Do not eat, drink or smoke when using this product."
      }, {
        "pCode": "P271",
        "pStatement": "Use only outdoors or in a well-ventilated area."
      }, {
        "pCode": "P272",
        "pStatement": "Contaminated work clothing should not be allowed out of the workplace."
      }, {
        "pCode": "P273",
        "pStatement": "Avoid release to the environment."
      }, {
        "pCode": "P280",
        "pStatement": "Wear protective gloves/protective clothing/eye protection/face protection/hearing protection/..."
      }, {
        "pCode": "P281",
        "pStatement": "(Deleted)Use personal protective equipment as required."
      }, {
        "pCode": "P282",
        "pStatement": "Wear cold insulating glovesand either face shield or eye protection."
      }, {
        "pCode": "P283",
        "pStatement": "Wear fire resistant or flame retardant clothing."
      }, {
        "pCode": "P284",
        "pStatement": "[In case of inadequate ventilation] Wear respiratory protection."
      }, {
        "pCode": "P285",
        "pStatement": "(Deleted) In case of inadequate ventilation wear respiratory protection."
      }, {
        "pCode": "P231+P232",
        "pStatement": "Handle and store contents under inert gas/... Protect from moisture."
      }, {
        "pCode": "P264+P265",
        "pStatement": "Wash hands [and ...] thoroughly after handling. Do not touch eyes."
      }, {
        "pCode": "P235+P410",
        "pStatement": "(Deleted) Keep cool. Protect from sunlight."
      }, {
        "pCode": "P301",
        "pStatement": "IF SWALLOWED:"
      }, {
        "pCode": "P302",
        "pStatement": "IF ON SKIN:"
      }, {
        "pCode": "P303",
        "pStatement": "IF ON SKIN (or hair):"
      }, {
        "pCode": "P304",
        "pStatement": "IF INHALED:"
      }, {
        "pCode": "P305",
        "pStatement": "IF IN EYES:"
      }, {
        "pCode": "P306",
        "pStatement": "IF ON CLOTHING:"
      }, {
        "pCode": "P307",
        "pStatement": "(Deleted) IF exposed:"
      }, {
        "pCode": "P308",
        "pStatement": "IF exposed or concerned:"
      }, {
        "pCode": "P309",
        "pStatement": "(Deleted) IF exposed or if you feel unwell"
      }, {
        "pCode": "P310",
        "pStatement": "(Deleted) Immediately call a POISON CENTER or doctor/physician."
      }, {
        "pCode": "P311",
        "pStatement": "(Deleted) Call a POISON CENTER or doctor/..."
      }, {
        "pCode": "P312",
        "pStatement": "(Deleted) Call a POISON CENTER or doctor/... if you feel unwell."
      }, {
        "pCode": "P313",
        "pStatement": "(Deleted) Get medical advice/attention."
      }, {
        "pCode": "P314",
        "pStatement": "(Deleted) Get medical advice/attention if you feel unwell."
      }, {
        "pCode": "P315",
        "pStatement": "(Deleted) Get immediate medical advice/attention."
      }, {
        "pCode": "P316",
        "pStatement": "Get emergency medical help immediately."
      }, {
        "pCode": "P317",
        "pStatement": "Get emergency medical help."
      }, {
        "pCode": "P318",
        "pStatement": "if exposed or concerned, get medical advice."
      }, {
        "pCode": "P319",
        "pStatement": "Get medical help if you feel unwell."
      }, {
        "pCode": "P320",
        "pStatement": "Specific treatment is urgent (see ... on this label)."
      }, {
        "pCode": "P321",
        "pStatement": "Specific treatment (see ... on this label)."
      }, {
        "pCode": "P322",
        "pStatement": "(Deleted) Specific measures (see ...on this label)."
      }, {
        "pCode": "P330",
        "pStatement": "Rinse mouth."
      }, {
        "pCode": "P331",
        "pStatement": "Do NOT induce vomiting."
      }, {
        "pCode": "P332",
        "pStatement": "IF SKIN irritation occurs:"
      }, {
        "pCode": "P333",
        "pStatement": "If skin irritation or rash occurs:"
      }, {
        "pCode": "P334",
        "pStatement": "Immerse in cool water [or wrap in wet bandages]."
      }, {
        "pCode": "P335",
        "pStatement": "Brush off loose particles from skin."
      }, {
        "pCode": "P336",
        "pStatement": "Thaw frosted parts with lukewarm water. Do not rub affected area."
      }, {
        "pCode": "P337",
        "pStatement": "If eye irritation persists:"
      }, {
        "pCode": "P338",
        "pStatement": "Remove contact lenses, if present and easy to do. Continue rinsing."
      }, {
        "pCode": "P340",
        "pStatement": "Remove person to fresh air and keep comfortable for breathing."
      }, {
        "pCode": "P341",
        "pStatement": "(Deleted) If breathing is difficult, remove victim to fresh air and keep at rest in a position comfortable for breathing."
      }, {
        "pCode": "P342",
        "pStatement": "If experiencing respiratory symptoms:"
      }, {
        "pCode": "P350",
        "pStatement": "(Deleted) Gently wash with plenty of soap and water."
      }, {
        "pCode": "P351",
        "pStatement": "Rinse cautiously with water for several minutes."
      }, {
        "pCode": "P352",
        "pStatement": "Wash with plenty of water/..."
      }, {
        "pCode": "P353",
        "pStatement": "Rinse skin with water [or shower]."
      }, {
        "pCode": "P354",
        "pStatement": "Immediately rinse with water for several minutes."
      }, {
        "pCode": "P360",
        "pStatement": "Rinse immediately contaminated clothing and skin with plenty of water before removing clothes."
      }, {
        "pCode": "P361",
        "pStatement": "Take off immediately all contaminated clothing."
      }, {
        "pCode": "P362",
        "pStatement": "Take off contaminated clothing."
      }, {
        "pCode": "P363",
        "pStatement": "Wash contaminated clothing before reuse."
      }, {
        "pCode": "P364",
        "pStatement": "And wash it before reuse."
      }, {
        "pCode": "P370",
        "pStatement": "In case of fire:"
      }, {
        "pCode": "P371",
        "pStatement": "In case of major fire and large quantities:"
      }, {
        "pCode": "P372",
        "pStatement": "Explosion risk."
      }, {
        "pCode": "P373",
        "pStatement": "DO NOT fight fire when fire reaches explosives."
      }, {
        "pCode": "P374",
        "pStatement": "(Deleted) Fight fire with normal precautions from a reasonable distance."
      }, {
        "pCode": "P375",
        "pStatement": "Fight fire remotely due to the risk of explorsion."
      }, {
        "pCode": "P376",
        "pStatement": "Stop leak if safe to do so."
      }, {
        "pCode": "P377",
        "pStatement": "Leaking gas fire: Do not extinguish, unless leak can be stopped safely."
      }, {
        "pCode": "P378",
        "pStatement": "Use ... to extinguish."
      }, {
        "pCode": "P380",
        "pStatement": "Evacuate area."
      }, {
        "pCode": "P381",
        "pStatement": "In case of leakage, eliminate all ignition sources."
      }, {
        "pCode": "P390",
        "pStatement": "Absorb spillage to prevent material damage."
      }, {
        "pCode": "P391",
        "pStatement": "Collect spillage."
      }, {
        "pCode": "P301+P310",
        "pStatement": "(Deleted) IF SWALLOWED: Immediately call a POISON CENTER/doctor/..."
      }, {
        "pCode": "P301+P312",
        "pStatement": "(Deleted) IF SWALLOWED: call a POISON CENTER/doctor/... IF you feel unwell."
      }, {
        "pCode": "P301+P316",
        "pStatement": "IF SWALLOWED: Get emergency medical help immediately."
      }, {
        "pCode": "P301+P317",
        "pStatement": "IF SWALLOWED: Get medical help."
      }, {
        "pCode": "P301+P330+P331",
        "pStatement": "IF SWALLOWED: Rinse mouth. Do NOT induce vomiting."
      }, {
        "pCode": "P302+P317",
        "pStatement": "IF ON SKIN: Get medical help."
      }, {
        "pCode": "P302+P334",
        "pStatement": "IF ON SKIN: Immerse in cool water or wrap in wet bandages."
      }, {
        "pCode": "P302+P335+P334",
        "pStatement": "Brush off loose particles from skin. Immerse in cool water [or wrap in wet bandages]."
      }, {
        "pCode": "P302+P350",
        "pStatement": "(Deleted) IF ON SKIN: Gently wash with plenty of soap and water."
      }, {
        "pCode": "P302+P352",
        "pStatement": "IF ON SKIN: wash with plenty of water/..."
      }, {
        "pCode": "P302+P361+P354",
        "pStatement": "IF ON SKIN: Take off Immediately all contaminated clothing. Immediately rinse with water for several minutes."
      }, {
        "pCode": "P303+P361+P353",
        "pStatement": "IF ON SKIN (or hair): Take off Immediately all contaminated clothing. Rinse SKIN with water [or shower]."
      }, {
        "pCode": "P304+P312",
        "pStatement": "(Deleted) IF INHALED: Call a POISON CENTER/doctor/... if you feel unwell."
      }, {
        "pCode": "P304+P317",
        "pStatement": "IF INHALED: Get medical help."
      }, {
        "pCode": "P304+P340",
        "pStatement": "IF INHALED: Remove person to fresh air and keep comfortable for breathing."
      }, {
        "pCode": "P304+P341",
        "pStatement": "(Deleted) IF INHALED: If breathing is difficult, remove victim to fresh air and keep at rest in a position comfortable for breathing."
      }, {
        "pCode": "P305+P351+P338",
        "pStatement": "IF IN EYES: Rinse cautiously with water for several minutes. Remove contact lenses if present and easy to do - continue rinsing."
      }, {
        "pCode": "P305+P354+P338",
        "pStatement": "IF IN EYES: Immediately rinse with water for several minutes. Remove contact lenses if present and easy to do. Continue rinsing."
      }, {
        "pCode": "P306+P360",
        "pStatement": "IF ON CLOTHING: Rinse Immediately contaminated CLOTHING and SKIN with plenty of water before removing clothes."
      }, {
        "pCode": "P308+P316",
        "pStatement": "IF exposed or concerned: Get emergency medical help immediately."
      }, {
        "pCode": "P307+P311",
        "pStatement": "(Deleted) IF exposed: call a POISON CENTER or doctor/physician."
      }, {
        "pCode": "P308+P311",
        "pStatement": "(Deleted) IF exposed or concerned: Call a POISON CENTER/doctor/..."
      }, {
        "pCode": "P308+P313",
        "pStatement": "(Deleted) IF exposed or concerned: Get medical advice/attention."
      }, {
        "pCode": "P309+P311",
        "pStatement": "(Deleted) IF exposed or if you feel unwell: call a POISON CENTER or doctor/physician."
      }, {
        "pCode": "P332+P313",
        "pStatement": "(Deleted) IF SKIN irritation occurs: Get medical advice/attention."
      }, {
        "pCode": "P332+P317",
        "pStatement": "If skin irritation occurs: Get medical help."
      }, {
        "pCode": "P333+P317",
        "pStatement": "If skin irritation or rash occurs: Get medical help."
      }, {
        "pCode": "P336+P317",
        "pStatement": "Immediately thaw frosted parts with lukewarm water. Do not rub affected area. Get medical help."
      }, {
        "pCode": "P337+P317",
        "pStatement": "If eye irritation persists: Get medical help."
      }, {
        "pCode": "P342+P316",
        "pStatement": "If experiencing respiratory symptoms: Get emergence medical help immediately."
      }, {
        "pCode": "P333+P313",
        "pStatement": "(Deleted) IF SKIN irritation or rash occurs: Get medical advice/attention."
      }, {
        "pCode": "P335+P334",
        "pStatement": "(Deleted) Brush off loose particles from skin. Immerse in cool water/wrap in wet bandages."
      }, {
        "pCode": "P337+P313",
        "pStatement": "(Deleted) IF eye irritation persists: Get medical advice/attention."
      }, {
        "pCode": "P342+P311",
        "pStatement": "(Deleted) IF experiencing respiratory symptoms: Call a POISON CENTER/doctor/..."
      }, {
        "pCode": "P361+P364",
        "pStatement": "Take off immediately all contaminated clothing and wash it before reuse."
      }, {
        "pCode": "P362+P364",
        "pStatement": "Take off contaminated clothing and wash it before reuse."
      }, {
        "pCode": "P370+P376",
        "pStatement": "in case of fire: Stop leak if safe to do so."
      }, {
        "pCode": "P370+P378",
        "pStatement": "In case of fire: Use ... to extinguish."
      }, {
        "pCode": "P370+P380",
        "pStatement": "(Deleted) In case of fire: Evacuate area."
      }, {
        "pCode": "P370+P380+P375",
        "pStatement": "In case of fire: Evacuate area. Fight fire remotely due to the risk of explosion."
      }, {
        "pCode": "P371+P380+P375",
        "pStatement": "In case of major fire and large quantities: Evacuate area. Fight fire remotely due to the risk of explosion."
      }, {
        "pCode": "P370+P372+P380+P373",
        "pStatement": "In case of fire: Explosion risk. Evacuate area. DO NOT fight fire when fire reaches explosives."
      }, {
        "pCode": "P370+P380+P375[+P378]",
        "pStatement": "In case of fire: Evacuate area. Fight fire remotely due to the risk of explosion. [Use...to extinguish].]"
      }, {
        "pCode": "P401",
        "pStatement": "Store in accordance with ..."
      }, {
        "pCode": "P402",
        "pStatement": "Store in a dry place."
      }, {
        "pCode": "P403",
        "pStatement": "Store in a well-ventilated place."
      }, {
        "pCode": "P404",
        "pStatement": "Store in a closed container."
      }, {
        "pCode": "P405",
        "pStatement": "Store locked up."
      }, {
        "pCode": "P406",
        "pStatement": "Store in corrosive resistant/... container with a resistant inner liner."
      }, {
        "pCode": "P407",
        "pStatement": "Maintain air gap between stacks or pallets."
      }, {
        "pCode": "P410",
        "pStatement": "Protect from sunlight."
      }, {
        "pCode": "P411",
        "pStatement": "Store at temperatures not exceeding ... �C/...�F."
      }, {
        "pCode": "P412",
        "pStatement": "Do not expose to temperatures exceeding 50 �C/ 122 �F."
      }, {
        "pCode": "P413",
        "pStatement": "Store bulk masses greater than ... kg/...lbs at temperatures not exceeding ... �C/...�F."
      }, {
        "pCode": "P420",
        "pStatement": "Store separately."
      }, {
        "pCode": "P422",
        "pStatement": "(Deleted) Store contents under ..."
      }, {
        "pCode": "P402+P404",
        "pStatement": "Store in a dry place. Store in a closed container."
      }, {
        "pCode": "P403+P233",
        "pStatement": "Store in a well-ventilated place. Keep container tightly closed."
      }, {
        "pCode": "P403+P235",
        "pStatement": "Store in a well-ventilated place. Keep cool."
      }, {
        "pCode": "P410+P403",
        "pStatement": "Protect from sunlight. Store in a well-ventilated place."
      }, {
        "pCode": "P410+P412",
        "pStatement": "Protect from sunlight. Do not expose to temperatures exceeding 50 �C/122�F."
      }, {
        "pCode": "P411+P235",
        "pStatement": "(Deleted) Store at temperatures not exceeding ... �C/...�F. Keep cool."
      }, {
        "pCode": "P501",
        "pStatement": "Dispose of contents/container to ..."
      }, {
        "pCode": "P502",
        "pStatement": "Refer to manufacturer or supplier for information on recovery or recycling"
      }, {
        "pCode": "P503",
        "pStatement": "Refer to manufacturer/supplier... for information on disposal/recovery/recycling."
      }],
      "ghsPictograms": [{
        "ghsCode": "GHS01",
        "ghsPictogramText": "Explosive",
        "ghsPictogramSVG": "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<!-- Created with Inkscape (http://www.inkscape.org/) -->\n<svg\n   xmlns:svg=\"http://www.w3.org/2000/svg\"\n   xmlns=\"http://www.w3.org/2000/svg\"\n   version=\"1.0\"\n   width=\"579pt\"\n   height=\"579pt\"\n   viewBox=\"0 0 579 579\">\n  <path\n     d=\"M 25.301165,289.67172 289.32987,553.70044 553.40261,289.6277 C 465.35022,201.6757 377.47182,113.54942 289.3739,25.643024 L 25.301165,289.67172 z\"\n     style=\"fill:#ffffff;stroke:none\" />\n  <path\n     d=\"M 147.65941,148.01233 6,289.67173 147.66886,431.34059 289.32827,573 431.01602,431.31224 572.70378,289.62449 431.06327,147.98398 C 353.16571,70.086424 289.40386,6.34347 289.37551,6.34347 c -0.0284,0 -63.79965,63.752403 -141.7161,141.66886 z M 408.62189,170.42535 527.82103,289.62449 408.5652,408.88032 289.31882,528.1267 170.12913,408.87087 50.939444,289.61504 170.13858,170.41591 C 235.69574,104.85874 289.34716,51.22622 289.37551,51.22622 c 0.0283,0 53.68922,53.64197 119.24638,119.19913 z\"\n     style=\"fill:#ff0000;stroke:none\" />\n  <path\n     d=\"m 393.5,171.5625 c -0.0875,0.0111 -0.14788,0.10408 -0.21875,0.28125 -0.0591,0.17718 -11.33782,32.32626 -25.0625,71.46875 -13.72467,39.14249 -24.984,71.22219 -25.03125,71.28125 -0.14174,0.14173 -1.1368,-0.21728 -1.125,-0.40625 0.0118,-0.12993 29.32971,-91.35309 29.625,-92.15625 0.0354,-0.0945 -0.8415,-0.68699 -2.625,-1.75 -2.65754,-1.58271 -2.96875,-1.75148 -2.96875,-1.5625 0,0.16536 -24.4215,95.359 -24.46875,95.40625 -0.0236,0.0354 -0.68921,-0.11934 -1.46875,-0.34375 -1.86619,-0.53151 -5.0386,-1.17766 -7.09375,-1.4375 -2.3032,-0.28348 -7.54622,-0.29529 -9.625,0 -9.70885,1.35829 -17.57516,5.37438 -24.4375,12.4375 -4.81899,4.96073 -8.65598,11.39408 -10.6875,17.9375 -0.24804,0.77955 -0.484,1.45275 -0.53125,1.5 -0.0473,0.0472 -3.77699,-2.68029 -8.3125,-6.09375 -4.53553,-3.41345 -8.28888,-6.19169 -8.3125,-6.15625 -0.0236,0.0236 0.43306,0.95986 1,2.09375 l 1.03125,2.0625 7.125,4.78125 c 6.88596,4.6182 7.0903,4.78665 7.03125,5.09375 -0.0591,0.29528 0.17196,0.58091 2.15625,2.71875 1.21656,1.32286 2.55536,2.75047 2.96875,3.1875 l 0.78125,0.78125 2.09375,-0.125 2.09375,-0.125 3.9375,2.625 c 2.16146,1.42916 3.79454,2.47786 3.59375,2.3125 -0.18899,-0.16535 -1.75612,-1.36883 -3.46875,-2.65625 -1.70082,-1.27561 -3.02017,-2.33194 -2.9375,-2.34375 0.0827,-0.0118 2.8144,-0.16659 6.0625,-0.34375 l 5.90625,-0.3125 8.5,4.28125 c 4.70089,2.33863 8.58956,4.25 8.625,4.25 0.0354,0 2.17096,-2.5457 4.78125,-5.6875 2.61029,-3.12997 4.82358,-5.78051 4.90625,-5.875 0.12993,-0.15355 -0.21233,-1.04715 -2.03125,-5.5 -1.19294,-2.91737 -2.14863,-5.32013 -2.125,-5.34375 0.0236,-0.0118 2.99894,0.29773 6.625,0.6875 3.62605,0.38977 6.60901,0.69169 6.65625,0.65625 0.0354,-0.0472 0.51156,-1.85035 1.03125,-4 l 0.96875,-3.9375 2.9375,-0.0312 c 1.61815,-0.0118 3.39,0.0153 3.96875,0.0625 l 1.0625,0.0937 -10.0625,11 c -5.55129,6.03555 -10.18257,11.11589 -10.3125,11.28125 -0.44882,0.5315 3.55174,-3.47669 12.90625,-12.9375 l 9.21875,-9.34375 3.4375,-0.0625 3.40625,-0.0625 -0.59375,-0.875 c -0.34253,-0.48426 -0.98868,-1.33169 -1.4375,-1.875 -0.44882,-0.54331 -0.79306,-1.01525 -0.78125,-1.0625 0.0236,-0.0473 1.30829,-1.38604 2.84375,-2.96875 l 2.78125,-2.84375 0.3125,0.65625 c 0.16535,0.37796 0.28125,0.72219 0.28125,0.78125 0,0.18897 0.15469,0.13021 4.84375,-2.03125 2.42131,-1.11026 4.45275,-1.9653 4.5,-1.90625 0.0473,0.0473 0.49213,1.56025 1,3.34375 0.49608,1.7835 0.95275,3.2965 1,3.34375 0.0827,0.0945 14.36785,-11.44144 14.78125,-11.9375 0.0945,-0.12992 1.87052,-3.36065 3.9375,-7.1875 2.06696,-3.83865 3.89715,-7.18529 4.0625,-7.46875 0.16536,-0.28348 0.23892,-0.52362 0.15625,-0.5 -0.0709,0.0236 -3.0115,2.45761 -6.53125,5.375 l -6.40625,5.28125 -4.59375,0.125 c -2.53941,0.0591 -4.79921,0.0861 -5,0.0625 -0.34252,-0.0354 2.19631,-2.61905 42.96875,-43.78125 23.82329,-24.04771 43.34375,-43.76526 43.34375,-43.8125 0,-0.0472 -1.1299,-1.2042 -2.5,-2.5625 -2.33862,-2.33862 -2.49852,-2.4508 -2.6875,-2.25 -0.1063,0.1063 -19.9245,21.68109 -44.03125,47.9375 l -43.8125,47.75 -3.46875,2.4375 c -1.90161,1.33466 -3.52287,2.49164 -3.59375,2.5625 -0.0827,0.0827 0.01,0.38581 0.28125,1 0.33071,0.77954 0.36049,0.91659 0.21875,1.09375 -0.12992,0.16536 -4.68846,5.19191 -5.5625,6.125 -0.2126,0.22442 -0.22242,0.2109 -1.25,-0.78125 -1.9961,-1.97248 -3.8843,-3.4916 -6.1875,-5.0625 l -1.125,-0.78125 L 374.5,282.125 c 17.12631,-29.42181 21.68061,-37.3312 21.5625,-37.4375 -0.0709,-0.0827 -1.19314,-0.78296 -2.46875,-1.5625 l -2.34375,-1.4375 -0.40625,0.71875 c -0.2126,0.40157 -9.01505,17.78995 -19.5625,38.625 -10.87816,21.5201 -19.21801,37.875 -19.3125,37.875 -0.11811,0 -0.10285,-0.14074 0.0625,-0.625 0.12992,-0.33071 11.65229,-32.46456 25.625,-71.40625 13.98452,-38.94169 25.39863,-70.83537 25.375,-70.90625 -0.0472,-0.1063 -8.53984,-4.07552 -9.4375,-4.40625 -0.0354,-0.0118 -0.0646,-0.004 -0.0937,0 z m -43.09375,54.53125 -1.21875,3.03125 -1.1875,3.0625 -2.3125,-0.90625 c -1.28743,-0.50789 -2.37081,-0.89099 -2.40625,-0.84375 -0.0354,0.0472 -0.58094,2.60476 -1.21875,5.6875 -0.62599,3.08274 -1.15207,5.7062 -1.1875,5.8125 -0.0354,0.14174 0.4852,0.42665 2.375,1.3125 1.3583,0.6378 2.50344,1.20275 2.5625,1.25 0.0472,0.0472 0.62744,2.13282 1.3125,4.625 0.67324,2.48036 1.25762,4.53889 1.28125,4.5625 0.0236,0.0236 0.98694,-1.34986 2.15625,-3.0625 2.22053,-3.24809 2.21467,-3.2373 9.21875,-10.84375 l 0.375,-0.40625 -2.03125,-6.5625 -2.03125,-6.5625 -0.875,-0.0625 c -0.48426,-0.0472 -1.75711,-0.0819 -2.84375,-0.0937 l -1.96875,0 z M 511.46875,255.25 c -0.0472,0 -0.12082,0.13951 -0.15625,0.28125 -0.36615,1.21655 -4.10901,12.7965 -4.15625,12.84375 -0.0236,0.0354 -2.55407,0.17077 -5.625,0.3125 l -5.59375,0.25 -1.59375,1.1875 c -0.87403,0.67324 -1.60138,1.2382 -1.625,1.25 -0.0354,0.0354 -1.52362,9.55832 -1.5,9.59375 0.0472,0.0354 8.71456,5 8.75,5 0.0236,0 1.59839,-1.6754 3.5,-3.71875 1.91342,-2.04334 3.49581,-3.73056 3.53125,-3.71875 0.0354,0 3.16553,2.13209 6.96875,4.71875 l 6.90625,4.6875 0.0312,-1.71875 c 0.0118,-0.9449 0.008,-4.7989 -0.0625,-8.53125 l -0.125,-6.78125 -4.59375,-7.84375 c -2.52761,-4.2993 -4.609,-7.8125 -4.65625,-7.8125 z m -117.53125,4.78125 -0.21875,0.28125 c -0.11811,0.15355 -0.82603,1.17517 -1.59375,2.25 l -1.375,1.9375 -0.875,4.375 c -0.47245,2.40949 -0.875,4.49509 -0.875,4.625 0.0118,0.16536 1.00316,1.09913 3.09375,2.90625 1.70083,1.4646 3.11662,2.65625 3.1875,2.65625 0.0591,0 1.12719,-1.21109 2.34375,-2.6875 l 2.21875,-2.71875 0.5,-2.4375 c 0.27166,-1.33468 0.55413,-2.73523 0.625,-3.125 l 0.125,-0.71875 -1.34375,-3.625 c -0.7323,-1.98429 -1.37081,-3.64025 -1.40625,-3.6875 -0.0473,-0.0472 -0.54624,0.44832 -1.125,1.0625 l -1.03125,1.125 -1.125,-1.125 -1.125,-1.09375 z M 466.15625,266.5 c -0.0591,0 -26.09855,18.33224 -57.90625,40.75 -31.8077,22.42956 -57.83612,40.78888 -57.8125,40.8125 0.0118,0.0236 26.09438,-16.11477 57.9375,-35.875 l 57.875,-35.9375 0,-4.90625 c 0,-2.68116 -0.0465,-4.85556 -0.0937,-4.84375 z M 454.71875,298.375 452.375,301 450,303.59375 448.875,306.625 c -0.62599,1.66539 -1.13681,3.03888 -1.125,3.0625 0.0472,0.0473 20.64026,2.516 20.6875,2.46875 0.0236,-0.0118 -3.06415,-3.13846 -6.84375,-6.90625 l -6.875,-6.875 z m 94.96875,1.8125 c -0.0591,-0.0118 -45.92855,11.84716 -101.9375,26.375 -56.00895,14.52784 -101.83612,26.44512 -101.8125,26.46875 0.0354,0.0354 206.54233,-46.74164 206.625,-46.8125 0.0709,-0.0473 -2.78051,-6.00764 -2.875,-6.03125 z m -120,14 c -0.0591,0.0118 -15.32297,7.20063 -33.9375,16 -18.61453,8.79939 -33.93676,16.05414 -34.03125,16.125 -0.12993,0.0945 -0.0876,0.10211 0.125,0.0312 0.4134,-0.14174 68.4257,-26.38263 68.4375,-26.40625 0.0118,0 -0.077,-1.2923 -0.21875,-2.875 -0.14172,-1.73626 -0.29232,-2.875 -0.375,-2.875 z m 147.5625,7.09375 c -0.15354,0.0118 -50.48012,8.55124 -111.875,18.96875 -61.38307,10.40571 -111.77214,18.9375 -111.9375,18.9375 -0.20079,0.0118 -0.71554,-0.34201 -1.625,-1.0625 l -1.375,-1.09375 -0.0625,4.53125 -0.0625,4.53125 -3.53125,2.40625 c -1.94886,1.31105 -3.60482,2.36319 -3.6875,2.375 -0.0827,0 -1.57625,-0.998 -3.3125,-2.25 -4.60639,-3.33078 -4.67504,-3.3197 -0.28125,0.0937 1.65358,1.28744 3.07775,2.359 3.125,2.40625 0.11811,0.1063 -5.55339,3.93406 -5.71875,3.875 -0.0827,-0.0236 -14.01986,-11.89856 -17.46875,-14.875 l -0.78125,-0.6875 -6.46875,5.59375 c -3.55517,3.08274 -6.51525,5.625 -6.5625,5.625 -0.0591,0 -3.71941,-0.95569 -8.125,-2.125 l -8,-2.125 2.25,0.0625 c 1.24018,0.0354 3.11267,0.0583 4.1875,0.0937 1.85436,0.0473 -3.43099,-0.34841 -9.75,-0.75 -1.16931,-0.0827 -7.50726,-0.5123 -14.0625,-0.9375 l -11.9375,-0.78125 -0.0312,-0.34375 c -0.0709,-0.40157 -0.0231,-0.38559 -1.0625,-0.0312 -0.74411,0.24804 -0.85306,0.23549 -3.15625,0.0937 -1.29924,-0.0709 -2.64566,-0.15208 -3,-0.1875 l -0.65625,-0.0937 -0.5625,-1.03125 -0.5625,-1 -4.03125,-0.21875 c -2.22051,-0.11811 -4.32554,-0.1875 -4.65625,-0.1875 l -0.59375,0 -0.53125,0.84375 -0.5,0.875 L 240.25,362.75 c -0.33073,-0.0118 -12.69288,-0.80091 -27.46875,-1.78125 -14.77588,-0.96853 -27.06446,-1.76181 -27.3125,-1.75 l -0.4375,0.0312 1.375,1.46875 c 1.19294,1.29924 1.4151,1.49581 1.78125,1.53125 0.23623,0.0236 11.92518,0.49556 25.96875,1.0625 14.04358,0.56694 25.58956,1.05831 25.625,1.09375 0.0354,0.0354 -0.52951,1.02581 -1.25,2.21875 -0.70868,1.18113 -1.2778,2.22219 -1.21875,2.28125 0.0472,0.0472 1.76154,1.26596 3.78125,2.71875 l 3.65625,2.65625 4.03125,0.65625 c 2.2087,0.37795 4.10481,0.66044 4.1875,0.625 0.0827,-0.0236 0.68995,-0.95225 1.375,-2.0625 l 1.25,-2.03125 2.5625,0 2.5625,0 0,-0.4375 c 0,-0.24804 -0.0888,-1.65277 -0.21875,-3.09375 -0.12993,-1.45279 -0.22294,-2.65207 -0.1875,-2.6875 0.0709,-0.0709 25.50664,0.90551 26.15625,1 0.3071,0.0473 0.375,0.0839 0.375,0.34375 0,0.43703 0.6213,3.18254 1.09375,4.8125 0.40158,1.3701 0.40429,1.37845 0.15625,1.4375 -0.12991,0.0236 -31.42816,3.6104 -69.53125,7.96875 -38.10309,4.37016 -69.26944,7.96875 -69.28125,7.96875 -0.0354,0.0236 -0.28544,3.05833 -0.25,3.09375 0.0236,0.0118 31.31005,-4.21349 69.53125,-9.375 38.2212,-5.16152 69.5812,-9.375 69.6875,-9.375 0.12993,0 0.29159,0.25392 0.46875,0.75 0.15355,0.41339 0.50196,1.25663 0.75,1.90625 0.24804,0.6378 0.42988,1.1757 0.40625,1.1875 -0.0236,0.0118 -23.41678,5.19279 -52,11.5 -28.58322,6.30721 -52.05759,11.5347 -52.1875,11.59375 -0.2008,0.0827 -0.32209,0.38753 -0.59375,1.78125 -0.18897,0.92127 -0.28544,1.71456 -0.25,1.75 0.0591,0.0473 104.77755,-25.74853 105.25,-25.9375 0.0709,-0.0236 0.29921,0.30535 0.5,0.71875 0.25985,0.51969 0.31325,0.77706 0.21875,0.8125 -0.0827,0.0236 -7.97176,2.15571 -17.5625,4.71875 l -17.46875,4.625 -0.21875,1.78125 c -0.12992,0.98032 -0.23056,1.80069 -0.21875,1.8125 0.0118,0.0118 8.16049,-2.65397 18.09375,-5.9375 18.11845,-5.9765 18.23819,-6.01551 18.25,-5.53125 0,0.0709 -12.72584,6.99664 -28.28125,15.40625 l -28.3125,15.28125 0.0937,1.125 c 0.0472,0.61419 0.0778,1.31446 0.125,1.5625 l 0.0937,0.4375 L 263.5,397.9375 c 15.46092,-9.09466 28.2062,-16.609 28.3125,-16.65625 0.15355,-0.0945 0.37671,0.19313 1.15625,1.46875 0.88585,1.46459 2.08413,3.17149 3.3125,4.71875 0.47245,0.61419 0.50149,0.70202 0.3125,0.84375 -0.1063,0.0709 -14.99892,11.96109 -33.09375,26.40625 L 230.625,441 l 2.3125,2.28125 c 1.28743,1.252 2.43676,2.31595 2.53125,2.375 0.14174,0.0827 4.53785,-3.92665 19.65625,-17.78125 10.72461,-9.83876 19.50763,-17.85555 19.53125,-17.84375 0.0236,0.0236 -0.14296,0.37966 -0.34375,0.78125 -0.20079,0.38978 -0.34375,0.75345 -0.34375,0.8125 0,0.0827 3.24409,3.7517 4,4.53125 0.20079,0.20079 0.30656,0.17201 2.5625,-0.84375 l 2.34375,-1.0625 1.1875,1.1875 1.1875,1.15625 2.34375,-1.40625 2.375,-1.4375 0.90625,-3.03125 c 0.50789,-1.6772 0.89444,-3.12426 0.90625,-3.21875 0,-0.1063 -0.89244,-0.7399 -2.15625,-1.53125 l -2.125,-1.34375 -3.4375,-0.0625 -3.40625,-0.0625 8.40625,-7.71875 c 4.6182,-4.22843 8.41388,-7.6875 8.4375,-7.6875 0.0118,0 0.95988,0.90918 2.09375,2.03125 1.13388,1.12206 2.60037,2.48031 3.25,3 7.8781,6.30721 16.83076,9.36541 26.46875,9.09375 7.571,-0.2126 14.30524,-2.35006 20.71875,-6.53125 2.64573,-1.72444 4.30925,-3.07525 6.71875,-5.4375 l 1.5,-1.4375 22.46875,18.09375 c 12.37819,9.9687 22.50764,18.10556 22.53125,18.09375 0.0118,-0.0236 -0.57602,-1.42419 -1.34375,-3.125 l -1.375,-3.09375 -20.875,-15.3125 -20.875,-15.28125 0.40625,-0.5 c 0.22442,-0.25984 0.82824,-1.01844 1.3125,-1.65625 0.49608,-0.62599 0.95275,-1.13681 1,-1.125 0.0591,0.0236 12.65719,9.85533 28,21.84375 15.34281,11.98841 28.0839,21.93601 28.34375,22.125 l 0.46875,0.34375 1.34375,-1.34375 c 0.74411,-0.74411 1.35556,-1.39025 1.34375,-1.4375 -0.0236,-0.0354 -13.16726,-9.57704 -29.21875,-21.1875 -16.03969,-11.61045 -29.2687,-21.17495 -29.375,-21.28125 -0.18897,-0.17717 -0.1538,-0.26893 0.53125,-1.34375 0.46064,-0.72049 0.78051,-1.12919 0.875,-1.09375 0.0827,0.0354 12.0076,7.30545 26.5,16.1875 14.48059,8.87025 26.37082,16.08613 26.40625,16.0625 0.0236,-0.0354 -0.60307,-1.38186 -1.40625,-3 l -1.46875,-2.9375 -24.8125,-13.625 -24.8125,-13.625 0.84375,-1.65625 c 0.47245,-0.90946 1.05684,-2.06643 1.28125,-2.5625 l 0.40625,-0.90625 15.375,3.96875 c 8.45686,2.18509 15.39025,4.01525 15.4375,4.0625 0.0945,0.0945 -1.08464,1.75 -1.25,1.75 -0.0591,0 -2.14883,-0.39493 -4.59375,-0.84375 -2.45674,-0.46064 -4.53051,-0.8125 -4.625,-0.8125 -0.12993,0 -0.64959,0.82772 -1.5,2.375 l -1.3125,2.40625 3.09375,2.28125 c 1.70081,1.2638 3.84816,2.8462 4.78125,3.53125 l 1.6875,1.25 12.5625,2.15625 c 6.89776,1.18113 12.57012,2.11736 12.59375,2.09375 0.0354,-0.0354 0.25689,-3.23372 0.375,-5.3125 l 0.0312,-0.71875 -2.0625,-2.375 -2.0625,-2.34375 -2.5625,-1.09375 c -1.41735,-0.60237 -2.54306,-1.1132 -2.53125,-1.125 0.0118,-0.0118 8.04041,2.03489 17.84375,4.5625 9.80334,2.5276 17.90551,4.59375 18,4.59375 0.0827,0 0.125,-0.0347 0.125,-0.0937 0,-0.0473 0.35604,-2.4618 0.78125,-5.34375 0.4252,-2.88195 0.76181,-5.22639 0.75,-5.25 -0.0236,-0.0118 -18.0734,-2.57351 -40.125,-5.65625 -22.03979,-3.08274 -40.10139,-5.63263 -40.125,-5.65625 -0.0236,-0.0236 0.21235,-0.84397 0.53125,-1.8125 0.33071,-0.96851 0.59375,-1.8312 0.59375,-1.9375 0,-0.12992 -0.86142,-0.47809 -3.09375,-1.28125 L 362.375,368.75 361.75,367.65625 c -0.34252,-0.57875 -0.59794,-1.08958 -0.5625,-1.125 0.0236,-0.0354 17.3655,0.77729 38.53125,1.78125 l 38.46875,1.8125 0.3125,0.3125 0.3125,0.34375 6.96875,0.46875 6.9375,0.46875 0.40625,-0.4375 0.40625,-0.4375 49.1875,2.34375 c 27.05957,1.27561 49.20694,2.29306 49.21875,2.28125 0.0236,-0.0236 -0.90919,-0.73154 -2.03125,-1.59375 l -2.03125,-1.59375 -46.34375,-1.4375 c -25.48868,-0.81498 -46.40551,-1.48819 -46.5,-1.5 -0.0945,-0.0236 1.3004,-1.70443 3.34375,-4.03125 1.93704,-2.19689 3.49238,-4.01944 3.46875,-4.03125 -0.0118,-0.0236 -5.58352,-2.49994 -12.375,-5.5 -6.79146,-3.00006 -12.359,-5.49583 -12.40625,-5.53125 -0.0472,-0.0236 -1.58731,1.38875 -3.40625,3.125 l -3.3125,3.15625 -4.6875,1.5625 c -2.56305,0.86223 -4.69513,1.58956 -4.71875,1.625 -0.0354,0.0236 0.42888,1.935 1.03125,4.25 0.60237,2.31501 1.03544,4.26526 1,4.3125 -0.0472,0.0354 -13.96472,-0.39419 -30.9375,-0.9375 -16.96095,-0.53151 -30.89025,-0.94931 -30.9375,-0.9375 -0.0472,0 -0.31791,-0.42963 -0.625,-0.9375 -0.53151,-0.87404 -0.65471,-1.00365 -3.84375,-3.53125 l -3.3125,-2.59375 0.625,-0.0937 c 0.34253,-0.0473 50.77393,-6.89181 112.0625,-15.21875 l 111.4375,-15.125 0.0625,-3.8125 0,-3.8125 -0.25,0 z m -314.375,18.375 c -0.004,0.0253 0.0135,0.0689 0.0312,0.125 0.0472,0.12993 0.25614,0.70669 0.46875,1.25 L 263.78125,342 282.25,350.90625 c 10.14586,4.88986 18.47639,8.85556 18.5,8.84375 0.0118,-0.0236 -8.22569,-4.43075 -18.3125,-9.78125 -10.07499,-5.3505 -18.61441,-9.87351 -18.96875,-10.0625 -0.43406,-0.24803 -0.58323,-0.32585 -0.59375,-0.25 z m -16.21875,10.8125 c -0.0354,0 -0.82454,0.67321 -1.78125,1.5 -0.95671,0.82679 -1.70349,1.52706 -1.65625,1.5625 0.11811,0.0945 55.05412,8.66462 55.125,8.59375 0.0472,-0.0354 -51.48671,-11.66806 -51.6875,-11.65625 z m 52.0625,11.6875 c -0.12991,-0.0118 -0.2035,0.0271 -0.15625,0.0625 0.0354,0.0354 0.13608,0.0354 0.21875,0 0.0945,-0.0354 0.0674,-0.0625 -0.0625,-0.0625 z m -45.6875,2.6875 0.8125,0.0625 c 0.43703,0.0472 0.96726,0.0819 1.15625,0.0937 0.29527,0 0.25861,0.0568 -0.34375,0.28125 -1.22837,0.47245 -1.17003,0.47245 -1.40625,0 l -0.21875,-0.4375 z m 181.625,1.5625 c 0.0709,0 0.63581,0.52606 1.25,1.1875 L 437,368.8125 l -2,-0.0937 c -1.11026,-0.0472 -3.28467,-0.10901 -4.84375,-0.15625 -1.55909,-0.0354 -2.75074,-0.12081 -2.65625,-0.15625 0.30709,-0.1063 7.03814,-1.98819 7.15625,-2 z m -136.3125,0.25 c -0.0281,0.0118 -0.0236,0.0448 0,0.0625 0.0354,0.0354 0.13608,0.0354 0.21875,0 0.0945,-0.0354 0.0362,-0.0625 -0.0937,-0.0625 -0.065,-0.006 -0.0969,-0.0118 -0.125,0 z m -90.03125,3.5625 c -0.0472,-0.0118 -1.70321,1.19929 -3.6875,2.6875 L 201.03125,375.5625 201,377 c -0.0354,1.40554 -0.0411,1.45275 0.21875,1.5 0.43701,0.0945 19.70964,1.84794 19.875,1.8125 0.11811,-0.0354 -12.54503,-10.0347 -12.78125,-10.09375 z M 232.28125,393.25 c 0,0.1063 7.22564,7.0625 7.34375,7.0625 0.0709,0 1.27434,-0.47613 2.65625,-1.03125 l 2.5,-1 0,-2.1875 0,-2.1875 -0.3125,0 c -0.4134,0 -10.53566,-0.55412 -11.46875,-0.625 -0.4134,-0.0354 -0.71875,-0.0549 -0.71875,-0.0312 z M 205.75,411.625 c -0.0354,0 -0.10139,0.0854 -0.125,0.15625 -0.0354,0.0827 -0.5962,1.97461 -1.28125,4.21875 l -1.25,4.09375 0.375,0.53125 c 2.04335,2.84651 7.11664,9.75763 7.1875,9.78125 0.0472,0.0118 0.28321,-0.55314 0.53125,-1.25 0.24804,-0.70867 0.76647,-2.16336 1.15625,-3.25 l 0.6875,-1.96875 0.4375,-0.0625 c 0.24804,-0.0354 1.25786,-0.10901 2.25,-0.15625 l 1.78125,-0.0625 1.40625,-1.53125 1.40625,-1.5 0.75,-2.28125 c 0.40159,-1.24018 0.67987,-2.25762 0.65625,-2.28125 -0.0709,-0.0709 -6.65133,-2.53125 -6.78125,-2.53125 -0.0709,0 -0.55043,0.5455 -1.09375,1.21875 -0.54331,0.68505 -1.07357,1.21113 -1.15625,1.1875 -0.0709,-0.0236 -1.64563,-0.98694 -3.5,-2.15625 -1.85436,-1.18112 -3.40208,-2.15625 -3.4375,-2.15625 z\"\n     transform=\"scale(0.8,0.8)\"\n     style=\"fill:#000000;stroke:none\" />\n</svg>\n"
      }, {
        "ghsCode": "GHS02",
        "ghsPictogramText": "Flammable",
        "ghsPictogramSVG": "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<!-- Created with Inkscape (http://www.inkscape.org/) -->\n<svg\n   xmlns:svg=\"http://www.w3.org/2000/svg\"\n   xmlns=\"http://www.w3.org/2000/svg\"\n   version=\"1.0\"\n   width=\"579pt\"\n   height=\"579pt\"\n   viewBox=\"0 0 579 579\">\n  <path\n     d=\"M 25.301165,289.67172 289.32987,553.70044 553.40261,289.6277 C 465.35022,201.6757 377.47182,113.54942 289.3739,25.643024 L 25.301165,289.67172 z\"\n     style=\"fill:#ffffff;stroke:none\" />\n  <path\n     d=\"M 147.65941,148.01233 6,289.67173 147.66886,431.34059 289.32827,573 431.01602,431.31224 572.70378,289.62449 431.06327,147.98398 C 353.16571,70.086424 289.40386,6.34347 289.37551,6.34347 c -0.0284,0 -63.79965,63.752403 -141.7161,141.66886 z M 408.62189,170.42535 527.82103,289.62449 408.57465,408.87087 289.31882,528.1267 170.12913,408.87087 50.939444,289.61504 170.13858,170.41591 C 235.69574,104.85874 289.34716,51.22622 289.37551,51.22622 c 0.0283,0 53.68922,53.64197 119.24638,119.19913 z\"\n     style=\"fill:#ff0000;stroke:none\" />\n  <path\n     d=\"m 361.90625,151.71875 c -21.97671,41.97446 4.80086,65.66838 -24.71875,127.5 -15.66202,-12.51358 -6.58224,-59.27877 -37.6875,-60.0625 4.78696,14.36089 1.20407,19.93912 0.40625,25.125 -3.09414,20.11189 -10.27447,38.08529 3.6875,64.8125 -21.44769,-10.42044 -21.80367,-29.54028 -39.9375,-41.53125 3.59022,20.3446 -5.05551,61.59867 19.03125,101.125 -21.4634,-2.11113 -28.5816,-10.36205 -51.8125,-32.625 24.24474,125.59567 42.28191,129.12387 131.1875,136.25 -6.69856,-0.78528 -51.49428,-7.93919 -67.71875,-59.5625 -0.92088,-12.78254 -1.42642,11.23343 41.65625,12.03125 -27.27922,-43.20279 -19.84756,-35.02469 -16.65625,-60.15625 11.29265,17.19944 1.3994,18.70351 33.3125,31.46875 -10.11823,-32.14696 15.61604,-54.14369 10.03125,-90.84375 7.05157,16.11791 32.13424,13.57949 30.9375,90.96875 20.76835,-23.17028 23.2459,-7.1331 33.21875,-33.0625 0.57762,14.43551 6.91343,32.40954 -21.3125,62 7.18045,1.99457 19.20322,3.53915 38.75,-9.625 -19.03226,21.56989 -1.83119,22.07856 -49.96875,57.375 60.63489,0.79782 100.45931,-37.37162 99.03125,-121.25 -1.59565,7.18045 -3.38283,21.5182 -36.09375,25.90625 20.48991,-20.36032 31.16796,-60.8975 14.8125,-94.40625 -5.75854,5.35573 -14.70866,30.25705 -36.25,37.4375 10.92635,-17.92607 8.46875,-41.125 8.46875,-41.125 0,0 2.78752,-31.33249 -15.71875,-55.53125 -5.18588,37.8968 -4.75267,56.9538 -28.6875,62.9375 3.8518,-22.36642 4.56116,-32.78203 -7.40625,-58.3125 -12.49935,-26.66526 -26.97228,-52.90893 -30.5625,-76.84375 z m -100.125,342.25 0,10.96875 0,11 106.71875,0 106.71875,0 -0.0312,-10.96875 -0.0312,-10.9375 L 368.5,494 261.78125,493.96875 z\"\n     transform=\"scale(0.8,0.8)\"\n     style=\"fill:#000000;stroke:none\" />\n</svg>\n"
      }, {
        "ghsCode": "GHS03",
        "ghsPictogramText": "Oxidizing",
        "ghsPictogramSVG": "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<!-- Created with Inkscape (http://www.inkscape.org/) -->\n<svg\n   xmlns:svg=\"http://www.w3.org/2000/svg\"\n   xmlns=\"http://www.w3.org/2000/svg\"\n   version=\"1.0\"\n   width=\"579pt\"\n   height=\"579pt\"\n   viewBox=\"0 0 579 579\">\n  <path\n     d=\"M 25.301165,289.67172 289.32987,553.70044 553.40261,289.6277 C 465.35022,201.6757 377.47182,113.54942 289.3739,25.643024 L 25.301165,289.67172 z\"\n     style=\"fill:#ffffff;stroke:none\" />\n  <path\n     d=\"M 147.65941,148.01233 6,289.67173 147.66886,431.34059 289.32827,573 431.01602,431.31224 572.70378,289.62449 431.06327,147.98398 C 353.16571,70.086424 289.40386,6.34347 289.37551,6.34347 c -0.0284,0 -63.79965,63.752403 -141.7161,141.66886 z M 408.62189,170.42535 527.82103,289.62449 408.5652,408.88032 289.31882,528.1267 170.12913,408.87087 50.939444,289.61504 170.13858,170.41591 C 235.69574,104.85874 289.34716,51.22622 289.37551,51.22622 c 0.0283,0 53.68922,53.64197 119.24638,119.19913 z\"\n     style=\"fill:#ff0000;stroke:none\" />\n  <path\n     d=\"m 358.6875,105.6875 c -11.0423,11.95104 -0.0346,61.12295 -22.84375,107.21875 -11.82513,-12.61346 -16.56692,-36.26863 -29.96875,-48.09375 7.07046,18.13186 -12.62633,16.55766 -5.53125,79.625 -10.70725,-2.67681 -11.03725,-7.08846 -34.6875,-35.46875 4.40353,27.52204 1.60663,44.94217 7.125,75.6875 0,0 -5.70036,-1.20109 -33.125,-21.3125 8.90084,29.98175 -6.64874,93.11169 28.78125,137.75 L 268.3125,401 c 2.72662,40.394 31.19994,73.76178 69.125,83.84375 l -68.53125,0 0,29.03125 191.125,0 0,-29.03125 -74.53125,0 c 34.31242,-9.12298 60.86623,-37.31555 67.625,-72.53125 l 0,-0.0312 c 9.39301,-15.01304 51.40412,-63.61206 19.09375,-141.8125 0,0 -9.4793,17.37784 -26.8125,22.0625 0,0 22.20763,-37.01824 3.9375,-67 0,0 -5.35488,21.90682 -23.625,22.84375 0,0 8.89287,-46.72414 -15,-76.46875 -8.67176,19.70855 5.19251,27.87556 -23.65625,44.15625 -3.94686,-60.72292 -16.54987,-70.95791 -28.375,-110.375 z M 352.375,238.125 c 11.01517,6.77856 18.93899,18.4373 21.34375,40.3125 1.05774,9.62189 4.65443,15.13583 7.28125,24.90625 -6.29922,-1.34256 -12.83332,-2.0625 -19.53125,-2.0625 -8.18497,0 -16.11998,1.04974 -23.6875,3.03125 -1.67751,-31.86822 15.00282,-24.87128 14.59375,-66.1875 z M 312.1875,261 c 0,0 4.40898,27.77921 15.65625,46.53125 -7.92479,3.0634 -15.31997,7.1944 -22.03125,12.1875 -3.69493,-28.7985 4.67257,-35.31053 6.375,-58.71875 z m 97.75,14.1875 c 0,0 4.12977,27.81515 9.75,46.46875 -8.90612,-7.11682 -19.14913,-12.63435 -30.28125,-16.125 4.69142,-9.60066 11.90829,-22.24339 20.53125,-30.34375 z m -141.125,30.75 c 0,0 8.37007,8.44267 30.25,19.28125 -7.67749,6.90282 -14.19535,15.07005 -19.25,24.15625 -3.41197,-11.17507 -8.20021,-28.03871 -11,-43.4375 z m 185.28125,10.25 c 0.73429,10.28004 0.74714,35.28952 -3.9375,48.875 l 0.0312,0.46875 c -4.13898,-12.61932 -10.89159,-24.04796 -19.625,-33.65625 5.63339,-4.50221 15.21199,-11.68192 23.53125,-15.6875 z m -93.4375,10.90625 c 36.83069,10e-6 66.71875,29.91931 66.71875,66.75 0,36.83069 -29.88806,66.71875 -66.71875,66.71875 -36.83068,0 -66.71875,-29.88806 -66.71875,-66.71875 0,-36.83068 29.88806,-66.75 66.71875,-66.75 z\"\n     transform=\"scale(0.8,0.8)\"\n     style=\"fill:#000000;stroke:none\" />\n</svg>\n"
      }, {
        "ghsCode": "GHS04",
        "ghsPictogramText": "Compressed Gas",
        "ghsPictogramSVG": "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<!-- Created with Inkscape (http://www.inkscape.org/) -->\n<svg\n   xmlns:svg=\"http://www.w3.org/2000/svg\"\n   xmlns=\"http://www.w3.org/2000/svg\"\n   version=\"1.0\"\n   width=\"579pt\"\n   height=\"579pt\"\n   viewBox=\"0 0 579 579\">\n  <path\n     d=\"M 25.301165,289.67172 289.32987,553.70044 553.40261,289.6277 C 465.35022,201.6757 377.47182,113.54942 289.3739,25.643024 L 25.301165,289.67172 z\"\n     style=\"fill:#ffffff;stroke:none\" />\n  <path\n     d=\"M 147.65941,148.01233 6,289.67173 147.66886,431.34059 289.32827,573 431.01602,431.31224 572.70378,289.62449 431.06327,147.98398 C 353.16571,70.086424 289.40386,6.34347 289.37551,6.34347 c -0.0284,0 -63.79965,63.752403 -141.7161,141.66886 z M 408.62189,170.42535 527.82103,289.62449 408.57465,408.87087 289.31882,528.1267 170.12913,408.87087 50.948893,289.60559 170.13858,170.41591 C 235.69574,104.85874 289.34716,51.22622 289.37551,51.22622 c 0.0283,0 53.68922,53.64197 119.24638,119.19913 z\"\n     style=\"fill:#ff0000;stroke:none\" />\n  <path\n     d=\"m 437.625,288 c -0.96852,-0.003 -1.94831,0.044 -2.5625,0.15625 -1.19294,0.22442 -231.26696,61.9936 -232.09375,62.3125 -6.51981,2.56304 -10.8959,9.67009 -12.21875,19.875 -0.27166,2.06698 -0.39936,5.8405 -0.28125,8.25 0.18898,3.90952 0.69954,7.2391 1.65625,11.125 3.89771,15.82707 13.74562,28.26275 24.28125,30.625 1.22837,0.27166 4.11537,0.34941 5.34375,0.125 1.03939,-0.17716 229.02875,-61.31076 231.34375,-62.03125 4.4056,-1.3701 7.72314,-4.44552 10.15625,-9.40625 1.3583,-2.75203 2.17814,-5.41479 2.875,-9.3125 0.55513,-3.07092 1.0327,-4.39071 2.34375,-6.375 1.59453,-2.42131 4.35697,-4.48571 7.15625,-5.3125 0.46064,-0.12992 11.84004,-3.17881 25.28125,-6.78125 13.4412,-3.61424 24.7276,-6.70964 25.09375,-6.875 5.43318,-2.49216 7.41122,-10.42801 4.28125,-17.125 -1.72444,-3.67329 -4.8491,-6.38508 -8.15625,-7.09375 -1.12207,-0.23623 -2.83488,-0.20916 -3.96875,0.0625 -0.5197,0.12992 -11.71309,3.12469 -24.90625,6.65625 -13.18136,3.54337 -24.27066,6.51108 -24.625,6.59375 -0.4252,0.1063 -1.36045,0.15625 -2.71875,0.15625 -2.26776,-0.0118 -3.138,-0.16214 -4.96875,-0.90625 -2.29139,-0.9449 -3.73567,-2.09591 -6.0625,-4.8125 -3.48431,-4.06308 -6.62887,-6.62768 -10.125,-8.28125 -1.50002,-0.69686 -3.1139,-1.22071 -4.53125,-1.46875 -0.64962,-0.11221 -1.62523,-0.1533 -2.59375,-0.15625 z\"\n     transform=\"scale(0.8,0.8)\"\n     style=\"fill:#000000;stroke:none\" />\n</svg>\n"
      }, {
        "ghsCode": "GHS05",
        "ghsPictogramText": "Corrosive",
        "ghsPictogramSVG": "<?xml version=\"1.0\"?>\n<svg xmlns=\"http://www.w3.org/2000/svg\" height=\"724\" width=\"724\" viewBox=\"0 0 735 735\">\n<path d=\"m367.5 727.4l360-360-360-360-360 360z\" fill=\"#f00\"/>\n<path d=\"m367.5 670.3-302.8-302.8l302.8-302.8 302.8 302.8z\" fill=\"#fff\"/>\n<path d=\"m233.3 384.1c-11.1 0-17.9-3.85-21.1-10.13h-79.98v36.56h199.3v-36.56h-72.5c-4.93 6.32-14.54 10.13-25.76 10.13\"/><path d=\"m251.7 370.5c3.25 0 7.91-1.57 11.67-9.1.86-1.71 1.03-3.89 1.22-6.2.1-1.2.26-3.13.54-3.87.36-.25 1.19-.61 1.78-.87 2.21-.97 5.24-2.29 6.83-5.47.89-1.78 1.15-3.54 1.15-5.22 0-1.26-.15-2.47-.29-3.62-.15-1.21-.28-2.37-.28-3.57 0-.41.001-.82.05-1.24.18-2.1 3.87-6.65 7.19-9.58l-5.07-5.77c-1.54 1.35-9.23 8.4-9.78 14.69-.21 2.47.04 4.56.26 6.4.26 2.19.39 3.48-.11 4.48-.35.69-1.77 1.32-3.04 1.87-1.96.86-4.17 1.82-5.4 4.07-1.08 1.99-1.29 4.58-1.5 7.09-.09 1.15-.23 2.9-.45 3.42-.66 1.31-1.35 2.37-2.06 3.16-.48 1.32-1.31 3.21-2.73 5.25v4.08\"/><path d=\"m241.7 365.7l4.39 6.3c2.51-1.75 4.31-3.73 5.61-5.59 1.42-2.03 2.24-3.92 2.73-5.25.18-.5.32-.92.42-1.23.69-2.15.18-4.19-.27-5.98-.47-1.88-.74-3.09-.22-4.23.6-1.34 1.62-2.14 2.91-3.15 1.47-1.15 3.3-2.59 4.44-5 1.42-2.98.59-6.27-.21-9.44-.56-2.23-1.14-4.54-.83-6.3l-7.56-1.34c-.15.82-.21 1.63-.21 2.44 0 2.51.6 4.91 1.16 7.09.31 1.23.76 3 .76 3.9 0 .16-.001.29-.04.39-.34.72-1.04 1.29-2.24 2.24-1.69 1.33-3.79 2.98-5.16 6-.71 1.58-.95 3.11-.95 4.51 0 1.84.41 3.47.73 4.74.15.6.37 1.48.38 1.84-.79 2.42-2.17 5.5-5.81 8\"/><path d=\"m208 350c.51.95.84 1.84 1.06 2.68.76.49 1.88 1.22 2.1 1.58.34.9.02 3.43-.2 5.11-.07.55-.14 1.08-.19 1.6 1.83 1.83 4.71 3.95 6.26 4.73l-2.89 5.79c1.43 2.04 3.1 4.08 4.62 5.75l5.68-5.17c-3.27-3.6-5.57-7.1-6.12-8.64-.001-.07-.001-.14-.001-.24 0-.67.16-1.95.28-2.84.19-1.51.4-3.12.4-4.71 0-1.44-.17-2.87-.67-4.18-1.01-2.64-3.38-4.15-5.27-5.36-1.12-.71-2.65-1.69-2.73-2.31-.02-.16-.03-.31-.03-.47 0-.77.24-1.56.67-2.9.63-1.95 1.46-4.53 1.46-8.3 0-.51-.02-1.04-.05-1.59l-7.67.46c.19 3.2-.42 5.08-1.06 7.1-.6 1.87-1.29 4-.96 6.67.02.13.04.25.06.38 1.78.94 3.86 2.29 5.25 4.87\"/><path d=\"m191.8 334.1c.13 1.5-.11 2.56-.38 3.8-.47 2.11-1.05 4.73.69 8.19 1.55 3.09 4.21 4.42 6.15 5.38 1.57.78 2.48 1.27 2.99 2.19.63 1.16.56 1.96.44 3.29-.14 1.62-.34 3.85 1.07 6.25 2.3 3.92 8.29 8.11 10.84 9.38l.54-1.08 2.89-5.79c-1.56-.78-4.44-2.89-6.26-4.73-.61-.61-1.1-1.19-1.39-1.68-.14-.23-.15-.52-.04-1.67.11-1.24.25-2.94-.28-4.94-.22-.84-.55-1.74-1.06-2.68-1.4-2.58-3.47-3.93-5.26-4.87-.37-.19-.73-.38-1.07-.55-1.64-.81-2.34-1.21-2.7-1.94-.5-1-.44-1.39-.06-3.1.32-1.46.77-3.45.54-6.12-.44-5.07-4.36-9.32-7.52-12.73l-2.33-2.61-5.94 4.86 2.63 2.96c2.36 2.55 5.29 5.73 5.51 8.18\"/><path d=\"m225.8 339.3c0 5.9 1.42 13.83 8.34 13.83 6.91 0 8.74-8.94 8.74-12.6 0-3.23-4.91-16.91-6.1-29.3-1.53-.02-2.81-.46-3.88-1.16-1.07 13.9-7.15 23.86-7.15 29.2\"/><path d=\"m334.1 227.5c-15.1 2.4-84.1 14.8-90.7 16.1-9.81 1.88-12.1-7-16.56-9.12 0 0 6.61 38.83 7 41.72 1.38 10.38-5.72 15.72-5.72 23.48 0 2.81 1.22 8 4.79 10.35 1.07.7 2.35 1.13 3.88 1.16.05 0 .09 0 .14 0 6.72 0 8.16-6.72 8.16-11.84 0-7.92-3.84-12.48-3.84-14.4s1.6-4.16 7.68-5.12c6.08-.96 82.1-14.16 94.1-16.1s20.88-11.76 18.96-21.84c-1.92-10.1-12.72-16.8-27.84-14.4m5.2 28.32c-10.24.64-99.7 9.28-99.7 9.28l-1.92-12.64s88.5-15.36 98.9-17.1c10.4-1.76 17.76 2.4 17.76 8.96 0 6.56-4.8 10.88-15 11.52\"/><path d=\"m498.8 306.2c-2.07 10.68-6.52 20.93-6.52 23.74 0 3.66 1.09 12.8 8 12.8s9.1-8.13 9.1-14c0-4.66-4.08-12.2-5.79-23.1-1 .44-2.14.7-3.45.7-.47 0-.9-.05-1.32-.13\"/><path d=\"m387.7 261.5c12 1.92 96.1 15.93 102.2 16.9 3.47.55 6.31 2.84 6.31 3.79s-3.71 4.5-3.71 10.73c0 4.76.74 12.26 6.26 13.29.41.08.85.13 1.32.13 1.31 0 2.45-.25 3.45-.7 4.14-1.83 5.78-6.99 5.78-11.69 0-10.97-5.7-8.81-4.33-19.2.38-2.88 5.92-40.54 5.92-40.54-4.48 2.08-5.67 9.82-15.48 7.94-6.67-1.28-83.8-15.51-98.9-17.91s-25.36 5.46-27.3 15.54 6.48 19.79 18.48 21.71m9-29.75c10.41 1.71 104.1 18.1 104.1 18.1l-1.92 12.64s-96.9-8.48-107.1-9.12c-10.24-.64-14.88-4.16-14.88-10.72s8.16-12.8 19.84-10.88\"/><path d=\"m532.7 318.2c.05 1.08.08 1.67-.51 3-1.12 2.48-3.07 5.57-6 6.27l1.75 7.48c3.33-.78 7.99-3.25 11.3-10.6 1.36-3 1.25-5.1 1.18-6.54-.06-1.2-.09-1.7.93-3.31.73-1.14.93-1.19 1.8-1.42 1.97-.52 4.23-1.37 6.18-5 2.22-4.14 1.5-7.58.98-10.1-.28-1.38-.51-2.46-.33-3.59.27-1.72 1.48-3.04 3.79-5.41 1.25-1.29 2.67-2.75 4.11-4.58l-6-4.75c-1.18 1.51-2.4 2.76-3.58 3.97-2.56 2.63-5.2 5.35-5.87 9.56-.4 2.51.04 4.64.4 6.35.46 2.24.63 3.29-.23 4.9-.52.98-.54.98-1.36 1.2-1.93.51-4.18 1.33-6.34 4.74-2.15 3.39-2.23 5.63-2.12 7.81\"/><path d=\"m519.6 331.2c3.68-3.24 4.82-4.41 6.5-9.81 1.09-3.51.84-5.83.64-7.69-.16-1.48-.27-2.55.23-4.46.26-.98.35-1.02 1.42-1.6 1.64-.88 4.38-2.35 5.59-7.11 1.11-4.37-.15-7.12-1.07-9.13-.72-1.56-1.15-2.51-.77-4.56l-7.56-1.38c-.8 4.43.44 7.15 1.35 9.13.72 1.57 1.05 2.29.61 4-.38 1.49-.65 1.63-1.78 2.24-1.53.82-4.1 2.2-5.22 6.39-.88 3.29-.64 5.49-.45 7.26.17 1.56.28 2.6-.34 4.58-1.11 3.57-1.23 3.68-4.24 6.32l-1.79 1.59 5.14 5.71 1.72-1.53\"/><path d=\"m462.7 305.6c.87 3.85 3.61 5.54 5.61 6.78 1.82 1.13 2.44 1.59 2.69 2.8.4 1.88.22 2.42-.05 3.22-.54 1.6-.95 3.28-.13 6.18 1.44 5.1 2.98 6.76 8.1 11.87l5.43-5.43c-4.85-4.85-5.25-5.41-6.15-8.55-.24-.84-.22-.9.02-1.63.56-1.68 1.05-3.63.28-7.26-.96-4.52-4.1-6.45-6.17-7.73-1.57-.97-2-1.32-2.15-1.93-.27-1.22.02-2.15.67-3.98.78-2.22 1.76-4.98 1.3-8.93l-7.63.9c.26 2.17-.26 3.63-.91 5.47-.75 2.13-1.69 4.8-.92 8.23\"/><path d=\"m457.5 303.6c0-1.37-.21-2.96-.85-4.86-1.78-5.23-3.63-7.25-5.77-9.58l-2.15-2.44-5.91 4.9 2.41 2.73c1.93 2.1 2.9 3.16 4.16 6.86.66 1.95.46 2.97.17 4.51-.38 1.98-.91 4.69.79 8.52 1.88 4.22 4.69 5.26 6.56 5.95 1.24.46 1.46.54 1.9 1.47.74 1.6.65 2.06.47 2.89-.23 1.1-.62 2.94.45 5.35 1.37 3.12 5.24 10.48 11.51 11.4l1.12-7.6c-1.54-.23-4-3.25-5.6-6.89l-.06-.18.1-.51c.16-.76.3-1.57.3-2.49 0-1.39-.31-3.04-1.31-5.21-1.77-3.81-4.44-4.8-6.21-5.45-1.32-.49-1.63-.6-2.19-1.86-.38-.86-.52-1.47-.52-2.09 0-.55.11-1.1.25-1.85.19-.99.42-2.16.42-3.58\"/><path d=\"m507.7 348.4c-7.53 6.09-24.39 6.56-33.3-1.56l-1.88-1.71-2.31 1.07c-3.43 1.59-8 1.72-11.67 1.82-4.67.13-8.36.24-10.25 3.19-1.37 2.14-1.24 5.1.37 7.99.26.48.57.96.91 1.44h16.75c-6.23 0-9.5-2.94-10.71-4.8.98-.07 2.15-.12 3.15-.14 3.68-.11 8.11-.31 12.31-1.69 4.58 3.49 10.17 5.49 15.87 6.25 4.13-4.86 11.1-6.64 15.18-6.64v5.75c3.18-.83 6.11-2.06 8.56-3.65 4.08 1.76 9.8 5.23 13.78 7.64 3.46 2.1 5.17 3.13 6.31 3.56 3.48 1.34 18 2.53 26.99 2.53v-7.68c-10.16 0-22.32-1.34-24.2-2.02-.61-.25-3.09-1.75-5.07-2.96-5.17-3.14-12.25-7.44-17.1-9.1l-1.99-.66-1.63 1.32\"/><path d=\"m466.3 360.6h-28.65c-12.9 0-14.28 7.9-14.28 10.67 0 .77.09 1.75.36 2.8h11.64c-3.42 0-4.51-1.34-4.51-2.77s1.31-3 6.79-3h45.99c.25-3.12 1.36-5.66 2.96-7.68h-20.3\"/><path d=\"m491.4 368.3h1.1l22.96-5.36-13.1-2.32h-.24v.66c-.1 0-9.61.43-10.73 7\"/><path d=\"m419.3 374.1c-7.4 0-12.38 5.81-12.38 11.24 0 5.18 4.6 11.43 12.76 11.43h2.39c.55-2.95 2.9-7.15 11.65-7.63v-.05h-14c-2.88 0-5-2.82-5.08-3.76 0-1 1.4-3.55 4.7-3.55h49.89v-7.68h-49.89\"/><path d=\"m422 396.7c-.12.63-.15 1.19-.15 1.66 0 6.3 5.55 11.43 15 11.43h.18c1.44-4.26 6.69-7.26 13.67-7.64v-.05h-13.85c-4.76 0-7.36-2.48-7.36-3.75 0-1.09 2.94-1.66 5.84-1.66h33.77v-7.68h-33.77c-.6 0-1.16.02-1.71.05-8.75.48-11.1 4.68-11.65 7.63\"/><path d=\"m437.1 409.8c-.26.77-.41 1.58-.41 2.42 0 4.82 4.32 10 13.96 10.85 6.98.58 37.1 1.53 42.62 1.53 4.5 0 23.36-.61 33.52-3.57 3-.88 5.55-2.06 8-3.2 5.28-2.46 10.74-5 22.6-5v-7.68c-13.57 0-20.1 3.04-25.84 5.71-2.29 1.06-4.45 2.07-6.91 2.79-8.53 2.49-25.98 3.26-31.37 3.26-5.1 0-35.2-.94-41.99-1.5-4.88-.41-6.91-2.28-6.91-3.19.17-.47 2.52-2.42 7.92-2.42h30.92l-7.4-7.68h-23.52c-.51 0-1.02.02-1.52.05-6.99.38-12.23 3.37-13.67 7.63\"/><path d=\"m486.9 360.2c-.11.13-.22.25-.32.38-1.6 2.02-2.71 4.56-2.96 7.68-.03.43-.06.86-.06 1.31 0 7.14 3.76 19.6 28.96 22.79l.96-7.62c-8.31-1.05-22.2-4.42-22.2-15.17 0-.46.04-.9.11-1.31 1.13-6.59 10.63-7 10.73-7v-7.68c-4.07 0-11.1 1.78-15.18 6.63\"/></svg>"
      }, {
        "ghsCode": "GHS06",
        "ghsPictogramText": "Toxic",
        "ghsPictogramSVG": "<?xml version=\"1.0\"?>\n<svg xmlns=\"http://www.w3.org/2000/svg\" height=\"724\" width=\"724\" viewBox=\"0 0 735 735\">\n<path d=\"m367.5 727.4l360-360-360-360-360 360z\" fill=\"#f00\"/>\n<path d=\"m367.5 670.3-302.8-302.8l302.8-302.8 302.8 302.8z\" fill=\"#fff\"/>\n<path d=\"m361.6 364.2c8.23 0 5.45-3.33 12.48-3.33 5.73 0 3.79 3.24 11.56 3.24 7.21 0 8.97-5.45 8.97-7.67 0-3.42-3.88-5.62-5.64-10.26-1.76-4.62-5.18-21.72-15.62-21.72-3.84 0-6.1 1.57-8.97 4.99-4.71 5.55-5.09 14.87-8 18.49-2.87 3.51-3.98 7.28-3.98 9.25 0 2.13 1.02 7 9.25 7m-80.55 58.51-7.9 3.74c-7.91 3.81-17.78 11.77-19.83 28.1-.34 2.68-6.39 9.79-12.59 9.79-3.81 0-8.32-2.52-8.94-6.27-1.08-6.44-5.95-29.55-6.16-30.53-.6-2.85-3.4-4.68-6.26-4.07s-4.68 3.4-4.07 6.26c.001.06.76 3.65.76 3.65-9.18-4.38-9.56-5.17-9.56-8.33 0-3.9 9-8.87 16.1-8.87 5.97 0 10.54 1.71 14.97 3.36 4 1.5 8.13 3.04 12.8 3.04 6.72 0 8.64-.68 11.73-2.35l2.6-1.27c4.07-1.71 35.64-16.78 49.55-23.43 1.94 2.78 4.26 5.57 6.94 8.25m-3.3-52c12.29 7.63 12.1 7.29 12.16 12.1-.15 1.3-.2 3.44-.2 7.41 0 13.1 25.5 24.1 41.52 24.1 17.77 0 41.3-12 41.3-24.49v-6.74c0-5.32.56-5.81 10.83-11.84v24.99c0 6.99-9.58 21.91-26.89 30.62l-.56.28c-8.38 4.21-18.8 9-23.1 9-3.97 0-17.41-3.92-28.1-9.31-17.32-8.7-26.89-23.63-26.89-30.62zm-108-40.9c-.02.0010-.04.03-.07.04.02-.0010.04-.03.07-.04m310.9-9.9c2.33 0 3.34.76 3.9 1.34 3.4 3.51 3.07 13.78 2.84 21.28l-.13 5.95c-.06 2.92 2.25 5.21 5.16 5.28 2.91.06 5.33-2.36 5.4-5.28l.05-2.13c.3.81.44 1.5.44 1.95v10.16c0 2.88-.84 6.32-4.82 6.32-3.27 0-7.46-2.04-11.5-4-4.66-2.27-9.1-4.42-13.57-4.42l-.76-.03c-2.63-.13-8.11-.38-15.83 3.23l-.15.07-57.75 29.3v-14.68c8.54-3.9 41.3-18.92 49.4-23.1 9.13-4.7 16.1-14.75 20.2-20.76l1.59-2.27c2.75-3.78 8.47-8.19 15.56-8.19zm-266.4 39.7-.08-.03c-7.72-3.62-13.2-3.36-15.83-3.23l-.76.03c-4.5 0-8.91 2.15-13.57 4.42-4 1.97-8.22 4-11.5 4-3.99 0-4.82-3.43-4.82-6.32v-10.16c0-.45.14-1.14.44-1.95l.05 2.12c.06 2.92 2.48 5.34 5.4 5.28 2.91-.06 5.23-2.36 5.16-5.28l-.13-5.95c-.24-7.5-.56-17.77 2.83-21.28.56-.57 1.57-1.34 3.9-1.34 7.09 0 12.82 4.41 15.57 8.19l1.59 2.27c4.14 6 11.1 16.1 20.2 20.76 7.08 3.65 32.3 15.23 44.58 20.87v14.45zm117.1-164.8c29.36 0 43.62 12.25 61.7 28.68l9.58 8.59 3.57 3.1c11.48 9.95 22.33 19.35 22.33 24.92 0 6.9-2.41 13.78-5.68 20.2.38-2.35.4-3.9.4-6.89 0-11.37-3.14-16.27-14.75-28.41l-7.63 7.3c10.88 11.37 11.82 13.79 11.82 21.1 0 4.55 0 4.55-2.31 14.8l-3.06 13.74.35 1.25c.04.13 3.59 13.18 3.59 25.7 0 13.1-8 17.98-18.1 24.2l-3.18 1.96-10.89 6.56c-11.5 6.75-17.23 9.73-17.23 21.52v6.74c0 3.91-14.78 13.93-30.53 13.93-14.46 0-30.38-10-30.96-13.64 0-4.83.21-6.92.21-6.92 0-11.56-5.6-14.81-16.77-21.29-3.11-1.8-6.97-4.05-11.52-6.9l-3.18-1.96c-10.14-6.2-17.38-9.72-17.38-24.2 0-15.23 3.63-20.67 3.63-25.37s-5.07-23-5.07-25.87c0-.37.04-3.46.04-3.46 0-6.85.87-12.57 11.46-21.98.86-.76 2.17-3.09 1.12-4.38s-1.47-1.83-2.69-3.27c-.61-.72-1.72-1-2.79-1.01-1.07 0-2.11.28-2.58.7-12.53 11.13-15.1 19.56-15.1 29.94 0 0-.04 3.09-.04 3.55 0 2.82-.12 1.4 1.33 7.33-4.52-7.66-8.32-16.28-8.32-24.95 0-5.39 10.33-14.75 21.27-24.65l4.78-4.34c3.78-3.45 7.1-6.67 10.24-9.79 7.24-7.11 12.95-12.72 19.6-16.1 14.99-7.6 28.6-10.4 42.82-10.4m-62.3 210.5c-18.32 8.76-45.1 21.53-48.57 22.98l-3.52 1.71c-1.53.83-2 1.07-6.71 1.07-2.75 0-5.69-1.1-9.1-2.37-4.81-1.8-10.79-4-18.67-4-10.86 0-26.64 7.57-26.64 19.43 0 10.56 6.77 13.73 17.98 19l4.82 2.29c1.13 5.54 2.21 10.95 2.63 13.48 1.57 9.44 11.1 15.1 19.36 15.1 11.8 0 22.1-11.55 23.1-19 1.19-9.47 5.74-15.99 13.92-19.92l7.79-3.69 44.5-20.95c3.05 2.19 6.36 4.23 9.92 6 8.71 4.38 25.2 10.86 32.88 10.86 6.82 0 17-5.14 28.1-10.72 4.76-2.39 8.84-5 12.49-7.87l54.78 26.35c8.18 3.94 12.73 10.45 13.92 19.92.94 7.49 11.27 19 23.1 19 8.28 0 17.78-5.64 19.36-15.1.42-2.53 1.5-7.94 2.63-13.48l-.47.22.47-.22 4.83-2.29c11.21-5.27 17.98-8.45 17.98-19 0-11.86-15.77-19.43-26.64-19.43-7.88 0-13.86 2.24-18.67 4-3.4 1.27-6.34 2.37-9.1 2.37-4.71 0-5.18-.25-6.71-1.07l-3.52-1.71c-3.71-1.56-34.54-16.26-52.66-24.93.25-.76.46-1.51.63-2.25 12.41-6.28 62.8-31.81 63-31.91 5.34-2.49 8.64-2.34 10.83-2.24l1.26.04c2.06 0 5.56 1.7 8.94 3.35 4.88 2.38 10.42 5.08 16.1 5.08 9.1 0 15.38-6.94 15.38-16.88v-10.16c0-5.52-3.81-13.21-10.9-17.51-.39-6.56-1.77-12.71-5.82-16.89-2.93-3-6.79-4.55-11.48-4.55-11.1 0-19.69 6.48-24.1 12.54l-1.74 2.49c-3.35 4.85-9.57 13.88-16.34 17.36-4.87 2.51-19.21 9.18-31.45 14.82 7.95-5.8 14.75-13.59 14.75-27.7 0-8.82-1.51-17.6-2.67-23l1.9-2.82c7.61-10.99 18-26 18-42.93 0-10.39-10.9-19.83-25.98-32.9l-3.55-3.08-9.4-8.43c-18.2-16.54-35.3-32.2-68.78-32.2-15.72 0-31.3 4-47.59 12.28-8.11 4.11-14.65 10.54-22.2 17.98-3.11 3.05-6.32 6.21-9.96 9.53l-4.75 4.32c-14.36 13-24.74 22.4-24.74 32.48 0 16.89 10.42 31.94 18 42.93l1.35 2c-1.08 7.73-2.2 17.94-2.2 25.1 0 9.85 4.54 16.79 10.47 22.2-9.49-4.41-18.58-8.68-22.28-10.58-6.77-3.48-12.99-12.51-16.34-17.36l-1.74-2.49c-4.41-6.1-13.1-12.54-24.1-12.54-4.69 0-8.56 1.53-11.48 4.55-4.05 4.18-5.44 10.33-5.82 16.9.02-.0010.04-.02.07-.04-.02.0010-.04.02-.07.04-7.09 4.3-10.91 11.99-10.91 17.51v10.16c0 9.94 6.33 16.88 15.39 16.88 5.71 0 11.24-2.7 16.1-5.08 3.38-1.65 6.87-3.35 8.94-3.35l1.26-.04c2.19-.1 5.49-.26 10.83 2.24.19.09 40.2 20.38 57.73 29.2m120.8 14.4c10.77 5.15 48.79 23.32 53.2 25.2l2.6 1.27c3.08 1.67 5 2.35 11.73 2.35 4.66 0 8.8-1.55 12.8-3.04 4.42-1.65 9-3.36 14.97-3.36 7.1 0 16.1 4.97 16.1 8.87 0 3.16-.38 3.95-9.56 8.33.46-2.18.75-3.59.77-3.64.6-2.85-1.22-5.65-4.08-6.26-2.85-.6-5.65 1.22-6.25 4.07-.21.98-5.08 24.1-6.16 30.53-.63 3.75-5.13 6.26-8.94 6.26-6.2 0-12.25-7.11-12.59-9.79-2.05-16.36-11.91-24.32-19.82-28.1l-51-24.53c2.45-2.66 4.55-5.4 6.29-8.1m-13.8-73.1c17.6 0 25-22.1 25-27.79s-4.5-8.1-7.15-8.1h-33.48c-3.57 0-12.17 2.91-12.17 8.47 0 2.08 1.56 6.66 4.92 11.1 5.8 7.68 10.83 16.28 22.87 16.28m-87.49.04c12 0 17.1-8.6 22.87-16.28 3.36-4.45 4.92-9 4.92-11.1 0-5.56-8.6-8.47-12.17-8.47h-33.48c-2.65 0-7.14 2.38-7.14 8.1 0 5.69 7.41 27.79 25 27.79m-9.1 21.76h-7.84c3.76 1.73 6.61 3 7.84 3.59v-3.59m-10.4 36.7c.25 2.14.86 4.46 1.81 6.88z\"/>\n</svg>\n"
      }, {
        "ghsCode": "GHS07",
        "ghsPictogramText": "Harmful Irritant",
        "ghsPictogramSVG": "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \n  \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n<svg\n   xmlns=\"http://www.w3.org/2000/svg\"\n   version=\"1.1\"\n   width=\"579pt\"\n   height=\"579pt\"\n   viewBox=\"0 0 579 579\">\n  <path\n     d=\"M 25.301165,289.67172 289.32987,553.70044 553.40261,289.6277 C 465.35022,201.6757 377.47182,113.54942 289.3739,25.643024 L 25.301165,289.67172 z\"\n     style=\"fill:White;stroke:none\" />\n  <path\n     d=\"M 6,289.67173 289.32827,573 572.70378,289.62449 289.37551,6.34347 6,289.67173 z M 527.82103,289.62449 289.32827,528.1078 50.948893,289.60559 289.37551,51.22622 527.82103,289.62449 z\"\n     style=\"fill:Red;stroke:none\" />\n  <path\n     d=\"m 289.175,142.825 c -0.872848,0.00944 -1.58484,0.03112 -1.925,0.05 -12.359296,0.850408 -23.290032,5.218384 -30.15,12.05 -2.18272,2.173272 -3.565528,4.058816 -4.775,6.525 -0.850408,1.729168 -1.281488,3.03028 -1.65,4.75 -0.236232,1.124432 -0.275,1.370632 -0.275,3.525 0.0,2.088232 0.0232,2.437184 0.25,3.675 0.245672,1.379552 19.500968,131.43008 19.775,133.575 0.188976,1.492936 0.70196,3.461 1.25,4.85 2.863048,7.22848 9.184696,12.28836 16.725,13.375 1.417352,0.207872 4.507648,0.207872 5.925,0.0 9.32616,-1.34176 16.756072,-8.88604 17.975,-18.25 0.34016,-2.617376 19.529328,-132.364936 19.775,-133.65 0.217328,-1.228368 0.225,-1.578504 0.225,-3.525 0.0,-2.2772 -0.06536,-3.093672 -0.5,-4.7 -0.737024,-2.702408 -2.197408,-5.506064 -4.125,-7.925 -1.530744,-1.9276 -4.031056,-4.199176 -6.45,-5.9 -5.442616,-3.817392 -13.012448,-6.694472 -20.6,-7.8 -3.40164,-0.491352 -4.619216,-0.5872 -8.55,-0.625 -0.987424,-0.00944 -2.027152,-0.00944 -2.9,0.0 z m 2.1,201.125 c -0.496664,-0.0016 -0.969088,0.0064 -1.425,0.02496 -7.502512,0.321256 -14.609544,3.515648 -20.175,9.1 -1.681928,1.681928 -2.752144,2.965712 -4.075,4.95 -3.070928,4.62056 -4.702928,9.105992 -5.525,15.125 -0.160632,1.209472 -0.17008,6.68324 0.0,8.025 0.812616,6.614304 3.234184,12.48868 7.25,17.525 0.973248,1.228368 2.949968,3.270056 4.15,4.3 3.628408,3.10872 8.006216,5.42892 12.4,6.525 2.872496,0.71812 4.36628,0.9 7.475,0.9 3.06148,0.0 4.613128,-0.19468 7.325,-0.875 7.389112,-1.84256 14.03732,-6.601248 18.45,-13.225 3.250456,-4.894592 5.1242,-10.315432 5.625,-16.325 0.132288,-1.615768 0.0484,-5.707648 -0.15,-7.125 -0.557488,-4.11032 -1.552528,-7.451112 -3.225,-10.9 -4.715056,-9.685224 -13.704528,-16.392096 -23.9,-17.8 -1.112624,-0.148824 -2.710008,-0.221016 -4.2,-0.225 z\"\n     style=\"fill:Black;stroke:none\" />\n</svg>\n"
      }, {
        "ghsCode": "GHS08",
        "ghsPictogramText": "Health Hazard",
        "ghsPictogramSVG": "<?xml version=\"1.0\"?><svg xmlns=\"http://www.w3.org/2000/svg\" height=\"724\" width=\"724\" viewBox=\"0 0 919 919\"><path fill=\"#f00\" d=\"m459.5 909.3l449.8-449.8-449.8-449.8-449.8 449.8z\"/><path fill=\"#fff\" d=\"m459.5 838-378.5-378.5 378.5-378.6 378.5 378.6z\"/><path d=\"m461.6 170.1c-53 0-96 46.3-96 103.4 0 37.1 13.88 89.2 40.94 121.1l-3.31 33.86-72.6 26.3c1.16 5.67 6.18 9.93 12.18 9.93 1.06 0 2.09-.15 3.07-.4 1.38 5.36 6.23 9.31 12 9.31.61 0 1.21-.05 1.8-.14 1.42 5.3 6.24 9.21 12 9.21 1.69 0 3.3-.34 4.77-.95.39 3.98 3.76 7.1 7.85 7.1.8 0 1.58-.12 2.31-.35 1 5.85 6.1 10.31 12.24 10.31 4.78 0 8.93-2.7 11-6.65 2.09 1.59 4.69 2.54 7.51 2.54 1.83 0 3.57-.41 5.13-1.12 1.62 3.44 4.63 6.09 8.29 7.23-.14.45-.25.93-.25 1.43 0 2.53 2.05 4.57 4.57 4.57s4.57-2.04 4.57-4.57c0-.56-.11-1.09-.3-1.59 5.33-1.87 9.16-6.93 9.16-12.9 0-2.73-.81-5.27-2.19-7.4 2.24-.3 3.96-2.19 3.96-4.51 0-1.97-1.25-3.64-3-4.27 1.9-2.19 3.07-5 3.07-8.17 0-.59-.06-1.18-.14-1.75 4.69-1.78 8-6.31 8-11.62 0-3.32-1.32-6.32-3.44-8.55.39.11.79.19 1.21.19 2.52 0 4.56-2.05 4.56-4.57 0-2.53-2.04-4.57-4.56-4.57-1 0-1.92.33-2.68.88-.91-1.7-2.56-2.93-4.52-3.25 1.54-2.52 2.44-5.46 2.44-8.63 0-2.05-.39-4-1.07-5.82 4.71-1.76 8.1-6.3 8.1-11.62 0-3.11-1.14-5.94-3-8.12 3.45-1.14 5.94-4.39 5.94-8.23 0-3.15-1.69-5.9-4.2-7.42 1.18-1.48 1.88-3.34 1.88-5.38 0-.52-.05-1.03-.14-1.52 1.8-.09 3.46-.7 4.82-1.72-.11.54-.16 1.08-.16 1.64 0 3.08 1.6 5.78 4 7.32-.48 1.32-.75 2.74-.75 4.22 0 5.07 3 9.41 7.36 11.35-.4 1.42-.63 2.92-.63 4.46 0 5.26 2.48 9.94 6.33 12.94-3.37 1.47-5.73 4.83-5.73 8.74s2.35 7.26 5.71 8.74c-.67 1.16-1.06 2.51-1.06 3.95 0 3.16 1.85 5.87 4.53 7.13-.77 1.91-1.2 3.99-1.2 6.17 0 2.62.63 5.1 1.73 7.3-.53.6-1 1.22-1.45 1.89-.83-.84-1.98-1.36-3.25-1.36-2.52 0-4.57 2.04-4.57 4.57 0 2.52 2.05 4.56 4.57 4.56.22 0 .42-.03.63-.06-.03.42-.06.84-.06 1.27 0 3.17.91 6.11 2.46 8.62-1.33 2.52-2.09 5.39-2.09 8.44 0 4.68 1.78 8.92 4.67 12.14-.8 1.3-1.27 2.82-1.27 4.46 0 4.67 3.78 8.46 8.46 8.46 4.16 0 7.61-3 8.32-6.96 2.29-.25 4.44-.92 6.39-1.93 1 2.17 3.2 3.69 5.75 3.69 3.51 0 6.35-2.84 6.35-6.35 0-2.65-1.64-4.92-3.95-5.87.64-1.38 1.1-2.87 1.38-4.41 1.37.37 2.8.58 4.29.58.18 0 .37-.02.56-.02 1.11 2.86 3.89 4.88 7.15 4.88 2.5 0 4.72-1.2 6.12-3.06.79 2.88 3.42 5 6.56 5 2.37 0 4.46-1.22 5.68-3.07 1.32.81 2.86 1.29 4.53 1.29 4.79 0 8.67-3.89 8.67-8.68 0-1.6-.44-3.09-1.2-4.38.66.22 1.37.33 2.09.33 3.76 0 6.81-3.04 6.81-6.8 0-.32-.03-.63-.08-.94 1.45 2.79 4.35 4.69 7.71 4.69 4.73 0 8.57-3.78 8.66-8.49 2.26-1.4 3.84-3.81 4.09-6.6.44.15.9.24 1.39.24 2.52 0 4.57-2.04 4.57-4.57 0-.52-.09-1.03-.26-1.5l-6.94-2.23-72.5-23.34-.29-30.95c11-11.84 19.59-27.1 25.81-43.69 11.78-31.4 18.1-64.6 18.1-81.98 0-45-43-103.4-96-103.4zm-148.6 291.9c-1.25 0-2.42.36-3.41.97-17.25 6.61-31.57 12.1-37 14.3-12.17 4.86-21.2 17.87-21.2 30.76v41.54l67.3 68.3c.68.15 1.4.22 2.13.22 3.73 0 6.99-2.03 8.73-5 1.35.51 2.82.8 4.35.8 6.87 0 12.44-5.57 12.44-12.44 0-.49-.04-.98-.09-1.45 1.84 2.28 4.66 3.74 7.83 3.74 5.56 0 10.1-4.51 10.1-10.1 0-1.51-.34-2.93-.93-4.21 2-.71 3.74-2.04 4.94-3.76 1.28 1.31 3.06 2.12 5 2.12 3.89 0 7.1-3.16 7.1-7 0-2.03-.86-3.85-2.23-5.14 2.58-1.25 4.54-3.57 5.31-6.39 1.62 1.78 3.87 2.98 6.39 3.24-1 1.23-1.63 2.8-1.63 4.52 0 3.89 3.16 7 7.1 7s7.1-3.16 7.1-7c0-3.19-2.12-5.88-5-6.75 2.24-1.85 3.67-4.65 3.67-7.78 0-.93-.13-1.81-.37-2.66.31.02.62.04.93.04 1.42 0 2.77-.29 3.99-.82.11 2.71 2.32 4.88 5.06 4.88 2.8 0 5.08-2.28 5.08-5.08 0-2.74-2.17-4.95-4.89-5.06.53-1.22.83-2.57.83-3.99 0-.87-.13-1.7-.34-2.5 2.53 0 4.58-2.04 4.58-4.57 0-2.52-2.05-4.56-4.58-4.56-.13 0-.25.02-.38.03-.26-3.8-2.22-7.13-5.13-9.23.001-.29.04-.58.04-.88 0-6.87-5.57-12.43-12.44-12.43-2.39 0-4.62.68-6.51 1.86.27-.72.42-1.5.42-2.31 0-3.6-2.91-6.52-6.51-6.52-.65 0-1.26.1-1.85.27.09-.58.14-1.18.14-1.78 0-6.87-5.56-12.44-12.43-12.44-2.13 0-4.13.53-5.88 1.47-1.57-2.56-4-4.5-6.97-5.39.37-.82.59-1.74.59-2.7 0-3.6-2.92-6.52-6.52-6.52-.85 0-1.65.17-2.39.46-.05-6.83-5.59-12.35-12.43-12.35-1.11 0-2.17.16-3.19.43-.99-2.33-3.3-3.97-6-3.97-1.59 0-3.04.57-4.17 1.52-.44-3.18-3.15-5.63-6.45-5.63m304.3 1.46c-3.06.24-5.55 2.49-6.14 5.44-.93-.48-1.98-.75-3.1-.75-3.76 0-6.8 3.04-6.8 6.8 0 .37.03.73.09 1.08-2.07-1.54-4.63-2.46-7.41-2.46-6.87 0-12.44 5.56-12.44 12.43v.06c-1.26-.3-2.57-.49-3.93-.49-9.1 0-16.41 7.35-16.41 16.42 0 .85.08 1.68.21 2.5-.97-.43-2.04-.67-3.16-.67-2.59 0-4.88 1.26-6.32 3.18-1.49-.49-3.07-.76-4.72-.76-8.09 0-14.67 6.39-15 14.4-.52-.11-1.05-.16-1.6-.16-4.35 0-7.88 3.53-7.88 7.88 0 1.33.33 2.57.9 3.67-1.25-.71-2.7-1.12-4.24-1.12-4.79 0-8.68 3.89-8.68 8.68 0 2.5 1.07 4.75 2.76 6.33v.08c-2 .2-3.68 1.55-4.32 3.39-.26.57-.4 1.2-.4 1.86 0 1.6.83 3 2.08 3.83.87.67 1.94 1.08 3.12 1.08 2.18 0 4-1.37 4.76-3.29 1.18.64 2.53 1 3.97 1 .65 0 1.28-.08 1.89-.22-.05.52-.08 1.05-.08 1.59 0 1.98.39 3.87 1.09 5.61-2.8.66-4.89 3.16-4.89 6.16 0 .93.2 1.8.56 2.59.9 2.29 3.12 3.92 5.73 3.92 2.17 0 4.06-1.12 5.16-2.8.41-.58.74-1.21.95-1.9 1.95.93 4.13 1.46 6.44 1.46.72 0 1.41-.07 2.1-.16-.41 1.09-.64 2.27-.64 3.51 0 1.63.4 3.16 1.09 4.52-.32-.06-.65-.1-.99-.1-2.8 0-5.08 2.27-5.08 5.08 0 2.8 2.28 5.08 5.08 5.08 2.53 0 4.61-1.86 4.99-4.28 1.37 5.38 6.24 9.36 12 9.36 2.61 0 5-.8 7-2.17.6 4.99 4.85 8.86 10 8.86 2.62 0 5-1 6.8-2.66-.02.3-.05.61-.05.92 0 6.86 5.57 12.43 12.44 12.43 2.35 0 4.54-.66 6.42-1.8-.94 1.28-1.5 2.86-1.5 4.57 0 4.29 3.47 7.76 7.75 7.76 2.59 0 4.88-1.28 6.29-3.22l67.3-61.99v-45.4c0-13.77-14.82-30.98-32.74-37.1-4-1.37-30.56-10-30.56-10m-153.4 6c-3.51 0-6.35 2.84-6.35 6.35 0 2.42 1.37 4.5 3.37 5.57-1.91.55-3.31 2.29-3.31 4.37 0 2.53 2.05 4.57 4.57 4.57s4.57-2.04 4.57-4.57c0-1.52-.75-2.86-1.9-3.69 3.05-.46 5.39-3.07 5.39-6.25 0-3.51-2.84-6.35-6.34-6.35m-22.7 5.89l-.03.27-.32-.17c.12-.03.24-.07.35-.1m13.78 21.61c-2.53 0-4.57 2.05-4.57 4.57s2.04 4.57 4.57 4.57c2.52 0 4.57-2.05 4.57-4.57s-2.05-4.57-4.57-4.57m-42.1 4.86c-3.6 0-6.52 2.92-6.52 6.52s2.92 6.51 6.52 6.51 6.52-2.91 6.52-6.51-2.92-6.52-6.52-6.52m73.86 11.58c-2.81 0-5.1 2.29-5.1 5.1 0 2.82 2.29 5.11 5.1 5.11.41 0 .81-.06 1.18-.16.19 3.6 3.15 6.46 6.79 6.46.5 0 .98-.06 1.45-.16 3.16-.36 5.62-3 5.62-6.27 0-1.16-.33-2.23-.87-3.17-1.07-2.36-3.44-4-6.2-4-1.12 0-2.17.27-3.1.75-.63-2.1-2.56-3.65-4.87-3.65m-70.85 11.67c-2.53 0-4.57 2.05-4.57 4.57 0 2.53 2.04 4.57 4.57 4.57.96 0 1.86-.3 2.6-.82.17 3.36 2.91 6 6.31 6 3.51 0 6.35-2.84 6.35-6.35 0-3.5-2.84-6.34-6.35-6.34-1.75 0-3.33.71-4.48 1.85-.48-2-2.28-3.51-4.43-3.51m89 32.51c-3.76 0-6.8 3.04-6.8 6.8 0 .86.16 1.68.45 2.44-2.46.34-4.37 2.44-4.37 5 0 .72.16 1.4.43 2 .71 1.79 2.45 3.07 4.5 3.07h.13c2.82 0 5.1-2.28 5.1-5.08 0-.23-.04-.45-.07-.67.21.02.42.03.63.03 3.76 0 6.8-3.04 6.8-6.8s-3.04-6.8-6.8-6.8m-53.3 8.58c-3.51 0-6.35 2.85-6.35 6.35 0 3.51 2.84 6.35 6.35 6.35 3.5 0 6.34-2.84 6.34-6.35 0-3.5-2.84-6.35-6.34-6.35m-37 .93c-2.8 0-5.08 2.27-5.08 5.08 0 2.8 2.28 5.07 5.08 5.07s5.07-2.27 5.07-5.07c0-2.81-2.27-5.08-5.07-5.08m7.44 13.78c-3.89 0-7.1 3.16-7.1 7 0 3.54 2.61 6.46 6 6.97-.02.26-.05.52-.05.79-2.16-1.78-4.92-2.86-7.94-2.86-4.52 0-8.47 2.43-10.65 6-1.84-2.03-4.49-3.31-7.45-3.31-4.7 0-8.64 3.22-9.75 7.58-1.62-1.11-3.57-1.75-5.68-1.75-5.56 0-10.1 4.5-10.1 10.1 0 .78.09 1.53.26 2.26-2.67-2.43-6.21-3.93-10.1-3.93-6.21 0-11.53 3.76-13.83 9.12-1.62-1.1-3.57-1.75-5.68-1.75-5.56 0-10.1 4.5-10.1 10.1 0 .81.1 1.6.28 2.35l122.2 124.1c1.6-.67 2.72-2.25 2.72-4.09 0-1.74-1.02-3.23-2.48-3.96 1.73-.61 2.98-2.23 2.98-4.17 0-1.83-1.11-3.4-2.69-4.08 1.57-1.03 2.6-2.8 2.6-4.81 0-2.75-1.92-5-4.49-5.62 5.11-3.53 8.47-9.42 8.47-16.1 0-4.13-1.28-7.95-3.46-11.1 3.52-2.2 5.86-6.1 5.86-10.55 0-5-2.98-9.35-7.27-11.31 1.69-1.29 2.78-3.31 2.78-5.6 0-2.39-1.19-4.5-3-5.78 1.03-1.22 1.64-2.79 1.64-4.51 0-3.89-3.16-7-7.1-7-.59 0-1.15.08-1.7.21.79-1.63 1.25-3.46 1.25-5.4 0-1.81-.4-3.53-1.1-5.08 3.66-.26 6.54-3.3 6.54-7 0-3-1.92-5.61-4.61-6.6 2.63-2.28 4.31-5.64 4.31-9.4 0-4.3-2.18-8.09-5.5-10.32 1.92-2.19 3.1-5.06 3.1-8.2 0-2.75-.9-5.28-2.42-7.34 1.96-.7 3.37-2.56 3.37-4.76 0-2.8-2.27-5.08-5.08-5.08-1.71 0-3.22.86-4.14 2.16-2.27-2.81-5.75-4.61-9.65-4.61-1.83 0-3.55.4-5.11 1.1-1.19-2.21-3.53-3.72-6.22-3.72zm69.1 2.03c-4.67 0-8.46 3.79-8.46 8.46 0 1.44.37 2.8 1 3.98-1.22-1-2.78-1.61-4.48-1.61-3.9 0-7.1 3.15-7.1 7 0 3.35 2.34 6.15 5.48 6.86-.92 1.74-1.45 3.71-1.45 5.81 0 4 1.93 7.61 4.91 9.88-1.14 2.12-1.79 4.54-1.79 7.11 0 3.99 1.56 7.61 4.1 10.3-.83 1.87-1.3 3.93-1.3 6.1 0 .84.09 1.66.22 2.46-1.02-.7-2.23-1.16-3.54-1.25.86-1.17 1.38-2.61 1.38-4.17 0-3.9-3.16-7-7.1-7-3.9 0-7.1 3.15-7.1 7 0 1.87.72 3.56 1.91 4.82-2.95.84-5.12 3.56-5.12 6.78 0 3.89 3.16 7 7.1 7 .22 0 .43-.04.65-.06-1.3 2.22-2.06 4.81-2.06 7.57 0 5.25 2.69 9.86 6.76 12.55-5.38 2.29-9.16 7.63-9.16 13.85 0 4.51 1.99 8.55 5.14 11.31-3.26 2.24-5.4 5.99-5.4 10.24 0 1.74.36 3.39 1 4.89-.91 1.51-1.44 3.27-1.44 5.16 0 2.18.71 4.2 1.89 5.85-1.02.81-1.69 2.05-1.69 3.46 0 1.52.77 2.87 1.94 3.67-1.22.79-2 2.15-2 3.71 0 .28.03.56.08.83-1 .81-1.68 2.04-1.68 3.45 0 1.84 1.12 3.41 2.71 4.09l131.7-121.6c.26-.74.41-1.53.41-2.36 0-3.9-3.16-7-7-7-1.21 0-2.35.31-3.34.84-1.22-4.19-5.09-7.25-9.67-7.25-1.98 0-3.81.58-5.37 1.56.02-.26.04-.51.04-.77 0-6.87-5.57-12.44-12.44-12.44-1.61 0-3.14.32-4.55.88-.18-3.74-3.25-6.72-7-6.72-3.9 0-7 3.16-7 7.1 0 .3.02.6.06.89-1.77-2.88-4.95-4.81-8.58-4.81-.58 0-1.14.06-1.69.15-.08-6.8-5.61-12.29-12.43-12.29-.7 0-1.37.07-2.04.18-.33-3.58-3.35-6.38-7-6.38-3.04 0-5.62 1.92-6.62 4.61-.31-.02-.62-.04-.94-.04-1.42 0-2.79.21-4.09.57-1.21-3.19-4.29-5.47-7.91-5.47zm-28.2 27.73c-2.81 0-5.08 2.28-5.08 5.08 0 1.52.68 2.86 1.73 3.79-1.36 1.28-2.21 3.1-2.21 5.12 0 3.89 3.16 7 7.1 7 3.9 0 7.1-3.16 7.1-7 0-2.86-1.7-5.31-4.15-6.42.42-.74.68-1.58.68-2.49 0-2.8-2.27-5.08-5.07-5.08\"/></svg>"
      }, {
        "ghsCode": "GHS09",
        "ghsPictogramText": "Environmental Hazard",
        "ghsPictogramSVG": "<?xml version=\"1.0\"?>\n<svg xmlns=\"http://www.w3.org/2000/svg\" height=\"724\" width=\"724\" viewBox=\"0 0 735 735\">\n<path d=\"m367.5 727.4l360-360-360-360-360 360z\" fill=\"#f00\"/>\n<path d=\"m367.5 670.3-302.8-302.8l302.8-302.8 302.8 302.8z\" fill=\"#fff\"/>\n<g stroke=\"#000\" stroke-width=\"5\">\n<path d=\"m223.7 367.2h281.2\"/>\n<path stroke-width=\"4\" d=\"m462.7 418 32.98 23.79-31.36 15.1 42.2 3.79-11.36 15.1h23.3l.54 16.76-294.2-1.605s49.2-14.58 57.3-8.635c10.82-4.87 89.8-38.4 89.8-36.2m-75.72-25.98 1.62-85.4-42.72-23.2s-6.49-4.33-15.68-1.62c-3.25 1.08-7.57 2.16-7.57 2.16s23.3-19.47 27.58-17.84c4.33 1.62 34.61 16.22 34.61 16.22s-3.25-22.71-11.36-29.2-39.47-31.36-39.47-31.36v-5.95l42.72 25.96s1.62-24.87-7-39.47c-8.65-14.6-15.1-27.58-15.1-27.58l2.7-2.16 21.1 32.44 7-22.2 4.33-1.08s-5.41 31.36-1.62 41.1c3.79 9.73 17.84 62.73 17.84 62.73l21.1-30.3s.54-12.44-.54-21.1c-1.08-8.65-2.7-48.67-2.7-48.67h3.79l5.95 43.8 34.1-39.47v4.33s-33.51 42.2-31.89 51.4c1.62 9.19 3.24 14.6-2.7 27.58s-9.73 22.2-9.73 22.2 17.84-21.1 25.96-22.71c8.11-.54 18.91.54 26.48-5.95s25.96-27 25.96-27l-28.66 44.3s-13.51.54-18.91 6.49c-5.41 5.95-27.58 31.36-27.58 31.36v58.4l36.76 18.38-44.87 6.49-10.82 15.68-14.6-12.44-40.62 3.735z\"/>\n<path fill=\"#fff\" d=\"m355.2 445.1c10.29-4.29 27-11.36 36.76-25.42 10.1-14.54 45.96-75.7 95.2-70.8-2.7 6.49-11.36 20.55-11.36 20.55l35.1-10.82s.54 46.5-65.97 76.2c-30.82 10.82-37.3 11.36-40 15.1-2.7 3.79-15.1 22.71-15.1 22.71l-55.14-24.3s14.06-.515 20.51-3.215z\"/>\n</g>\n<ellipse cy=\"385.8\" cx=\"484.3\" rx=\"5.95\" ry=\"5.13\"/>\n</svg>\n"
      }]
    };

    function getHStatements() {
      return ghs.hStatements;
    }
    function getHStatementsObject() {
      const result = {};
      ghs.hStatements.forEach(h => {
        if (result[h.hCode]) {
          throw new Error(`This should never happen, duplice hCode: ${h.hCode}`);
        }
        result[h.hCode] = h;
      });
      return result;
    }
    function getPStatements() {
      return ghs.pStatements;
    }
    function getPStatementsObject() {
      const result = {};
      ghs.pStatements.forEach(p => {
        if (result[p.pCode]) {
          throw new Error(`This should never happen, duplice pCode: ${p.pCode}`);
        }
        result[p.pCode] = p;
      });
      return result;
    }
    function getGHS() {
      return ghs.ghsPictograms;
    }
    function getGHSObject() {
      const result = {};
      ghs.ghsPictograms.forEach(g => {
        if (result[g.ghsCode]) {
          throw new Error(`This should never happen, duplice code: ${g.ghsCode}`);
        }
        result[g.ghsCode] = g;
      });
      return result;
    }

    exports.getGHS = getGHS;
    exports.getGHSObject = getGHSObject;
    exports.getHStatements = getHStatements;
    exports.getHStatementsObject = getHStatementsObject;
    exports.getPStatements = getPStatements;
    exports.getPStatementsObject = getPStatementsObject;

    Object.defineProperty(exports, '__esModule', { value: true });

}));
//# sourceMappingURL=ghs-hazard.js.map
