!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports):"function"==typeof define&&define.amd?define(["exports"],e):e((t="undefined"!=typeof globalThis?globalThis:t||self).nmrProcessing={})}(this,(function(exports){"use strict";const gyromagneticRatio={"1H":267522187.44,"2H":41065e3,"3H":285350800,"3He":-203789e3,"7Li":103962e3,"13C":67282840,"14N":19331e3,"15N":-27116e3,"17O":-36264e3,"19F":251662e3,"23Na":70761e3,"27Al":69763e3,"29Si":-5319e4,"31P":108291e3,"57Fe":8681e3,"63Cu":71118e3,"67Zn":16767e3,"129Xe":-73997e3},impuritiesContent={cdcl3:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"ds",shift:7.26}],h2o:[{proton:"H2O",coupling:0,multiplicity:"bs",shift:1.56}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.1}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.17}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.1}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.36}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.28}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.19},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.22}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.98},{proton:"OHc",coupling:0,multiplicity:"s",shift:5.01},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.27},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.43}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.26}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.43}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.73}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.3}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.21},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.48}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.65},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.57},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.39}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.4},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.55}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.09},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3.02},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.94}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:8.02},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.96},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.88}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.62}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.71}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.25},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.72},{proton:"OH",coupling:5,multiplicity:"s,t",shift:1.32}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.05},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.12},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.26}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.14},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.46},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.06}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.76}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.86},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.26}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.26}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.65}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.49},{proton:"OH",coupling:0,multiplicity:"s",shift:1.09}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.33}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:7},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.27}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.22},{proton:"CH",coupling:6,multiplicity:"sep",shift:4.04}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.62},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.29},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.68}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.07}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.85},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.76}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.36},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.17},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.25}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.03},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.53}]},"(cd3)2co":{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:2.05}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:2.84}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.96}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.09}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.05}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.36}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.18}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.13},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.13}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.96},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.22},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.41}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:8.02}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.43}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.87}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.63}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.11},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.41}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.56},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.47},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.28}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.28},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.46}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.83}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.96},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.94},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.78}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.52}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.59}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.12},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.57},{proton:"OH",coupling:5,multiplicity:"s,t",shift:3.39}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.05},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.2}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.45},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.96}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.28}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.87},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.29}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.28}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.59}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.31},{proton:"OH",coupling:0,multiplicity:"s",shift:3.12}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.43}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.27}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.1},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.9}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.58},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.35},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.76}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.13}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.79},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.63}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.32},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.5},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.5}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.45}]},dmso:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"quint",shift:2.5}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:3.33}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.91}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.09}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.07}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.37}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.11},{proton:"OHc",coupling:0,multiplicity:"s",shift:4.19}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.11},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.08}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.87},{proton:"OHc",coupling:0,multiplicity:"s",shift:6.65},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.18},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.36}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:8.32}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.4}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.9}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.76}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.09},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.38}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.51},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.38},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.24}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.24},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.43}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.96},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.94},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.78}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.95},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.89},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.73}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.54}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.57}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.06},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.44},{proton:"OH",coupling:5,multiplicity:"s,t",shift:4.63}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.99},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.03},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.17}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.43},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.91}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.34}],"grease^f":[],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.86},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.25}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.53}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.16},{proton:"OH",coupling:0,multiplicity:"s",shift:4.01}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.42}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.27}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.04},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.78}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.58},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.39},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.79}],silicone_greasei:[],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.76},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.6}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.3},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.18},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.25}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.93},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.43}]},c6d6:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:7.16}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:.4}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.55}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.55}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.55}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.15}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.05},{proton:"OHc",coupling:0,multiplicity:"s",shift:1.55}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.07},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.04}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:7.05},{proton:"OHc",coupling:0,multiplicity:"s",shift:4.79},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.24},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.38}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:6.15}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.4}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:2.9}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:4.27}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.11},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.26}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.46},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.34},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.11}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.12},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.33}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.6},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.57},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.05}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.63},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.36},{proton:"CH3",coupling:0,multiplicity:"s",shift:1.86}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.68}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.35}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.34}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.65},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:3.89},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.92}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.58},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:1.81},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.85}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.41}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.92},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.36}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.89},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.24}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.4}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.07}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.94}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.86},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.23}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:.95},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.67}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.53},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:6.66},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:6.98}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.29}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.4},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.57}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.11},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.02},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.13}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.4}]},cd3cn:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:1.94}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:2.13}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.96}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.08}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.96}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.37}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.16},{proton:"OHc",coupling:0,multiplicity:"s",shift:2.18}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.14},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.13}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.97},{proton:"OHc",coupling:0,multiplicity:"s",shift:5.2},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.22},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.39}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.58}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.44}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.81}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.44}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.12},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.42}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.53},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.45},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.29}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.28},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.45}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.96},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.83}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.92},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.89},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.77}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.5}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.6}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.12},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.54},{proton:"OH",coupling:5,multiplicity:"s,t",shift:2.47}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.06},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.2}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.06},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.43},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.96}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.51}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.86},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.27}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.89},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.28}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.57}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.28},{proton:"OH",coupling:0,multiplicity:"s",shift:2.16}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.31}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.87},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.29}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.09},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.87}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.57},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.33},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.73}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.08}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.8},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.64}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.33},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.2},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.2}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.45}]},cd3od:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:3.31}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:4.87}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.99}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.15}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.03}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.33}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.4}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.15},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.2}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.92},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.21},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.4}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.9}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.45}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.78}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.49}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.18},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.49}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.61},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.58},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.35}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.35},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.52}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3.31},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.92}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.97},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.99},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.86}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.65}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.66}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.19},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.6}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.01},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.09},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.24}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.12},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.5},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.01}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.59}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.88},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.29}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.9},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.29}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.64}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.34}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.34}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.89},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.29}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.5},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.92}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.53},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.44},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.85}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.1}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.87},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.71}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.32},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.16},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.16}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.05},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.58}]},d2o:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:4.79}],h2o:[],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.08}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.22}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.06}],benzene:[],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.24}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.21},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.22}],bhtb:[],chloroform:[],cyclohexane:[],"1,2-dichloroethane":[],dichloromethane:[],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.17},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.56}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.67},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.61},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.37}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.37},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.6}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.08},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3.06},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.9}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.92},{proton:"CH3",coupling:0,multiplicity:"s",shift:3.01},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.85}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.71}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.75}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.17},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.65}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.14},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.24}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.19},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:3.18},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.26}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.65}],"grease^f":[],"n-hexane":[],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.61}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.34}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.4}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.9}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.17},{proton:"CH",coupling:6,multiplicity:"sep",shift:4.02}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.52},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.45},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.87}],silicone_greasei:[],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.88},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.74}],toluene:[],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.99},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.57}]}},impurities=impuritiesContent,SignalKinds=[{label:"Signal",value:"signal"},{label:"Reference",value:"reference"},{label:"Solvent",value:"solvent"},{label:"Impurity",value:"impurity"},{label:"Standard",value:"standard"},{label:"P1",value:"p1"},{label:"P2",value:"p2"},{label:"P3",value:"p3"}],SignalKindsToInclude=["signal"],DatumKind={signal:"signal",mixed:"mixed"},MultiplicityPatterns=[{label:"singlet",value:"s",multiplicity:1,names:["br s","br. s"]},{label:"triplet",value:"t",multiplicity:3,names:[]},{label:"doublet",value:"d",multiplicity:2,names:[]},{label:"quartet",value:"q",multiplicity:4,names:[]},{label:"quintet",value:"i",acs:"quint",multiplicity:5,names:["quint","qui","qnt","pentet","pnt","pent"]},{label:"sextet",value:"h",multiplicity:6,names:["x","sxt","sext","hexuplet"]},{label:"septet",value:"p",acs:"sept",multiplicity:7,names:["sept","spt","heptet","hpt","hept"]},{label:"octet",value:"o",multiplicity:8,names:["oct"]},{label:"nonet",value:"n",multiplicity:9,names:["non"]},{label:"massive",value:"m",multiplicity:null,names:[]}];MultiplicityPatterns.sort(((t,e)=>null!==t.multiplicity&&null!==e.multiplicity?t.multiplicity-e.multiplicity:Number.MAX_SAFE_INTEGER));const couplingPatterns=MultiplicityPatterns.map((t=>t.value)),couplingACSPatterns=MultiplicityPatterns.map((t=>t.acs||t.value)),toCheck=["solvent","h2o","tms"];function peaksFilterImpurities(t,e={}){const{error:n=.025,remove:s=!1}=e;if(e.solvent){let{solvent:i}=e;"(cd3)2so"===i&&(i="dmso"),"meod"===i&&(i="cd3od");const o=impurities[i];for(const e of toCheck){checkImpurity(t,o[e],{error:n,remove:s,name:e})}}return t}function checkImpurity(t,e,n){const{name:s,error:i,remove:o}=n;let a,r,l,m=e.length;for(;m--;)for(a=t.length;a--;)r=i+t[a].width,l=Math.abs(e[m].shift-t[a].x),l<r&&(o?t.splice(a,1):t[a].kind=s)}const GAUSSIAN_EXP_FACTOR=-4*Math.LN2,ROOT_PI_OVER_LN2=Math.sqrt(Math.PI/Math.LN2),ROOT_THREE=Math.sqrt(3),ROOT_2LN2=Math.sqrt(2*Math.LN2),ROOT_2LN2_MINUS_ONE=Math.sqrt(2*Math.LN2)-1;function erfinv(t){if(0===t)return 0;let e=Math.log(1-t*t),n=e/2+2/(.147*Math.PI),s=Math.sqrt(n**2-e/.147);return Math.sqrt(s-n)*(t>0?1:-1)}class Gaussian{constructor(t={}){const{fwhm:e=500,sd:n}=t;this.fwhm=n?gaussianWidthToFWHM(2*n):e}fwhmToWidth(t=this.fwhm){return gaussianFwhmToWidth(t)}widthToFWHM(t){return gaussianWidthToFWHM(t)}fct(t){return gaussianFct(t,this.fwhm)}getArea(t=calculateGaussianHeight({fwhm:this.fwhm})){return getGaussianArea({fwhm:this.fwhm,height:t})}getFactor(t){return getGaussianFactor(t)}getData(t={}){return getGaussianData(this,t)}calculateHeight(t=1){return calculateGaussianHeight({fwhm:this.fwhm,area:t})}getParameters(){return["fwhm"]}}function calculateGaussianHeight(t){let{fwhm:e=500,area:n=1,sd:s}=t;return s&&(e=gaussianWidthToFWHM(2*s)),2*n/ROOT_PI_OVER_LN2/e}function gaussianFct(t,e){return Math.exp(GAUSSIAN_EXP_FACTOR*Math.pow(t/e,2))}function gaussianWidthToFWHM(t){return t*ROOT_2LN2}function gaussianFwhmToWidth(t){return t/ROOT_2LN2}function getGaussianArea(t){let{fwhm:e=500,sd:n,height:s=1}=t;return n&&(e=gaussianWidthToFWHM(2*n)),s*ROOT_PI_OVER_LN2*e/2}function getGaussianFactor(t=.9999){return Math.sqrt(2)*erfinv(t)}function getGaussianData(t={},e={}){let{fwhm:n=500,sd:s}=t;s&&(n=gaussianWidthToFWHM(2*s));let{length:i,factor:o=getGaussianFactor(),height:a=calculateGaussianHeight({fwhm:n})}=e;i||(i=Math.min(Math.ceil(n*o),Math.pow(2,25)-1),i%2==0&&i++);const r=(i-1)/2,l=new Float64Array(i);for(let t=0;t<=r;t++)l[t]=gaussianFct(t-r,n)*a,l[i-1-t]=l[t];return l}class Lorentzian{constructor(t={}){const{fwhm:e=500}=t;this.fwhm=e}fwhmToWidth(t=this.fwhm){return lorentzianFwhmToWidth(t)}widthToFWHM(t){return lorentzianWidthToFWHM(t)}fct(t){return lorentzianFct(t,this.fwhm)}getArea(t=1){return getLorentzianArea({fwhm:this.fwhm,height:t})}getFactor(t){return getLorentzianFactor(t)}getData(t={}){return getLorentzianData(this,t)}calculateHeight(t=1){return calculateLorentzianHeight({fwhm:this.fwhm,area:t})}getParameters(){return["fwhm"]}}const calculateLorentzianHeight=({fwhm:t=1,area:e=1})=>2*e/Math.PI/t,getLorentzianArea=t=>{const{fwhm:e=500,height:n=1}=t;return n*Math.PI*e/2},lorentzianFct=(t,e)=>e**2/(4*t**2+e**2),lorentzianWidthToFWHM=t=>t*ROOT_THREE,lorentzianFwhmToWidth=t=>t/ROOT_THREE,getLorentzianFactor=(t=.9999)=>{if(t>=1)throw new Error("area should be (0 - 1)");const e=.5*(1-t),n=t=>Math.tan(Math.PI*(t-.5));return(n(1-e)-n(e))/2},getLorentzianData=(t={},e={})=>{let{fwhm:n=500}=t,{length:s,factor:i=getLorentzianFactor(),height:o=calculateLorentzianHeight({fwhm:n,area:1})}=e;s||(s=Math.min(Math.ceil(n*i),Math.pow(2,25)-1),s%2==0&&s++);const a=(s-1)/2,r=new Float64Array(s);for(let t=0;t<=a;t++)r[t]=lorentzianFct(t-a,n)*o,r[s-1-t]=r[t];return r};class PseudoVoigt{constructor(t={}){const{fwhm:e=500,mu:n=.5}=t;this.mu=n,this.fwhm=e}fwhmToWidth(t=this.fwhm,e=this.mu){return pseudoVoigtFwhmToWidth(t,e)}widthToFWHM(t,e=this.mu){return pseudoVoigtWidthToFWHM(t,e)}fct(t){return pseudoVoigtFct(t,this.fwhm,this.mu)}getArea(t=1){return getPseudoVoigtArea({fwhm:this.fwhm,height:t,mu:this.mu})}getFactor(t){return getPseudoVoigtFactor(t)}getData(t={}){const{length:e,factor:n,height:s=calculatePseudoVoigtHeight({fwhm:this.fwhm,mu:this.mu,area:1})}=t;return getPseudoVoigtData(this,{factor:n,length:e,height:s})}calculateHeight(t=1){return calculatePseudoVoigtHeight({fwhm:this.fwhm,mu:this.mu,area:t})}getParameters(){return["fwhm","mu"]}}const calculatePseudoVoigtHeight=(t={})=>{let{fwhm:e=1,mu:n=.5,area:s=1}=t;return 2*s/(e*(n*ROOT_PI_OVER_LN2+(1-n)*Math.PI))},pseudoVoigtFct=(t,e,n)=>(1-n)*lorentzianFct(t,e)+n*gaussianFct(t,e),pseudoVoigtWidthToFWHM=(t,e=.5)=>t*(e*ROOT_2LN2_MINUS_ONE+1),pseudoVoigtFwhmToWidth=(t,e=.5)=>t/(e*ROOT_2LN2_MINUS_ONE+1),getPseudoVoigtArea=t=>{const{fwhm:e=500,height:n=1,mu:s=.5}=t;return e*n*(s*ROOT_PI_OVER_LN2+(1-s)*Math.PI)/2},getPseudoVoigtFactor=(t=.9999,e=.5)=>e<1?getLorentzianFactor(t):getGaussianFactor(t),getPseudoVoigtData=(t={},e={})=>{let{fwhm:n=500,mu:s=.5}=t,{length:i,factor:o=getPseudoVoigtFactor(.999,s),height:a=calculatePseudoVoigtHeight({fwhm:n,mu:s,area:1})}=e;a||(a=1/(s/Math.sqrt(-GAUSSIAN_EXP_FACTOR/Math.PI)*n+(1-s)*n*Math.PI/2)),i||(i=Math.min(Math.ceil(n*o),Math.pow(2,25)-1),i%2==0&&i++);const r=(i-1)/2,l=new Float64Array(i);for(let t=0;t<=r;t++)l[t]=pseudoVoigtFct(t-r,n,s)*a,l[i-1-t]=l[t];return l};class Gaussian2D{constructor(t={}){let{fwhm:e=20,sd:n}=t;e=ensureFWHM2D(e,n),this.fwhmX=e.x,this.fwhmY=e.y}fct(t,e){return gaussian2DFct(t,e,this.fwhmX,this.fwhmY)}getData(t={}){return getGaussian2DData({fwhm:{x:this.fwhmX,y:this.fwhmY}},t)}getFactor(t=1){return getGaussianFactor(t)}getVolume(t=calculateGaussian2DHeight({fwhm:{x:this.fwhmX,y:this.fwhmY},volume:1})){return getGaussian2DVolume({fwhm:{x:this.fwhmX,y:this.fwhmY},height:t})}widthToFWHM(t){return gaussianWidthToFWHM(t)}fwhmToWidth(t){return gaussianFwhmToWidth(t)}calculateHeight(t=1){return calculateGaussian2DHeight({volume:t,fwhm:{x:this.fwhmX,y:this.fwhmY}})}set fwhm(t){t=ensureXYNumber$2(t),this.fwhmX=t.x,this.fwhmY=t.y}}const gaussian2DFct=(t,e,n,s)=>Math.exp(GAUSSIAN_EXP_FACTOR*(Math.pow(t/n,2)+Math.pow(e/s,2))),getGaussian2DData=(t,e={})=>{let{fwhm:n=50,sd:s}=t;n=ensureFWHM2D(n,s);let{factor:i=getGaussianFactor(),length:o={x:0,y:0},height:a=calculateGaussian2DHeight({fwhm:n,volume:1})}=e;i=ensureXYNumber$2(i),o=ensureXYNumber$2(o);for(const t of["x","y"])o[t]||(o[t]=Math.min(Math.ceil(n[t]*i[t]),Math.pow(2,25)-1),o[t]%2==0&&o[t]++);const r=(o.x-1)/2,l=(o.y-1)/2,m=new Array(o.x);for(let t=0;t<o.x;t++)m[t]=new Float64Array(o.y);for(let t=0;t<o.x;t++)for(let e=0;e<o.y;e++)m[t][e]=gaussian2DFct(t-r,e-l,n.x,n.y)*a;return m},calculateGaussian2DHeight=(t={})=>{let{volume:e=1,fwhm:n=50,sd:s}=t;return n=ensureFWHM2D(n,s),e*Math.LN2*4/(Math.PI*n.y*n.x)},getGaussian2DVolume=(t={})=>{let{fwhm:e=50,height:n=1,sd:s}=t;return e=ensureFWHM2D(e,s),n*Math.PI*e.y*e.x/Math.LN2/4};function ensureXYNumber$2(t){return"object"!=typeof t?{x:t,y:t}:{...t}}function ensureFWHM2D(t,e){if(void 0!==e){let t=ensureXYNumber$2(e);return{x:gaussianWidthToFWHM(2*t.x),y:gaussianWidthToFWHM(2*t.y)}}if(void 0!==t)return ensureXYNumber$2(t);throw new Error("ensureFWHM2D must have either fwhm or sd defined")}function getShape1D(t){const{kind:e}=t;switch(e){case"gaussian":return new Gaussian(t);case"lorentzian":return new Lorentzian(t);case"pseudoVoigt":return new PseudoVoigt(t);default:throw Error(`Unknown distribution ${e}`)}}function getShape2D(t){const{kind:e}=t;if("gaussian"===e)return new Gaussian2D(t);throw Error(`Unknown distribution ${e}`)}function addBaseline(t,e){if(!e)return t;let n=t.x,s=t.y;for(let t=0;t<n.length;t++)s[t]+=e(n[t]);return t}function reimAbsolute(t){const e=t.re.length,n=t.re,s=t.im,i=new Float64Array(e);for(let t=0;t<e;t++)i[t]=Math.sqrt(n[t]**2+s[t]**2);return i}var commonjsGlobal="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{},d3Array={exports:{}};!function(t,e){!function(t){function e(t,e){return t<e?-1:t>e?1:t>=e?0:NaN}function n(t){return 1===t.length&&(t=s(t)),{left:function(e,n,s,i){for(null==s&&(s=0),null==i&&(i=e.length);s<i;){var o=s+i>>>1;t(e[o],n)<0?s=o+1:i=o}return s},right:function(e,n,s,i){for(null==s&&(s=0),null==i&&(i=e.length);s<i;){var o=s+i>>>1;t(e[o],n)>0?i=o:s=o+1}return s}}}function s(t){return function(n,s){return e(t(n),s)}}var i=n(e),o=i.right,a=i.left;function r(t,e){return e<t?-1:e>t?1:e>=t?0:NaN}function l(t){return null===t?NaN:+t}function m(t,e){var n,s,i=t.length,o=0,a=0,r=-1,m=0;if(null==e)for(;++r<i;)isNaN(n=l(t[r]))||(a+=(s=n-o)*(n-(o+=s/++m)));else for(;++r<i;)isNaN(n=l(e(t[r],r,t)))||(a+=(s=n-o)*(n-(o+=s/++m)));if(m>1)return a/(m-1)}function c(t,e){var n=m(t,e);return n?Math.sqrt(n):n}function u(t,e){var n,s,i,o=-1,a=t.length;if(null==e){for(;++o<a;)if(null!=(s=t[o])&&s>=s){n=i=s;break}for(;++o<a;)null!=(s=t[o])&&(n>s&&(n=s),i<s&&(i=s))}else{for(;++o<a;)if(null!=(s=e(t[o],o,t))&&s>=s){n=i=s;break}for(;++o<a;)null!=(s=e(t[o],o,t))&&(n>s&&(n=s),i<s&&(i=s))}return[n,i]}function g(t){return function(){return t}}function C(t){return t}function f(t,e,n){t=+t,e=+e,n=(i=arguments.length)<2?(e=t,t=0,1):i<3?1:+n;for(var s=-1,i=0|Math.max(0,Math.ceil((e-t)/n)),o=new Array(i);++s<i;)o[s]=t+s*n;return o}var p=Math.sqrt(50),h=Math.sqrt(10),d=Math.sqrt(2);function y(t,e,n){var s=H(t,e,n);return f(Math.ceil(t/s)*s,Math.floor(e/s)*s+s/2,s)}function H(t,e,n){var s=Math.abs(e-t)/Math.max(0,n),i=Math.pow(10,Math.floor(Math.log(s)/Math.LN10)),o=s/i;return o>=p?i*=10:o>=h?i*=5:o>=d&&(i*=2),e<t?-i:i}function b(t){return Math.ceil(Math.log(t.length)/Math.LN2)+1}function v(t){return+t}function w(){var t=C,e=u,n=b;function s(s){var i,a,r=s.length,l=new Array(r);for(i=0;i<r;++i)l[i]=+t(s[i],i,s);var m=e(l),c=+m[0],u=+m[1],g=n(l,c,u);Array.isArray(g)||(g=y(c,u,+g));var C=g.length;for(i=0;i<C;++i)g[i]=+g[i];for(;g[0]<=c;)g.shift(),--C;for(;g[C-1]>=u;)g.pop(),--C;var f,p=new Array(C+1);for(i=0;i<=C;++i)(f=p[i]=[]).x0=i>0?g[i-1]:c,f.x1=i<C?g[i]:u;for(i=0;i<r;++i)c<=(a=l[i])&&a<=u&&p[o(g,a,0,C)].push(s[i]);return p}return s.value=function(e){return arguments.length?(t="function"==typeof e?e:g(+e),s):t},s.domain=function(t){return arguments.length?(e="function"==typeof t?t:g([+t[0],+t[1]]),s):e},s.thresholds=function(t){return arguments.length?(n="function"==typeof t?t:Array.isArray(t)?g(Array.prototype.map.call(t,v)):g(+t),s):n},s}function x(t,e,n){if(null==n&&(n=l),s=t.length){if((e=+e)<=0||s<2)return+n(t[0],0,t);if(e>=1)return+n(t[s-1],s-1,t);var s,i=(s-1)*e,o=Math.floor(i),a=+n(t[o],o,t);return a+(+n(t[o+1],o+1,t)-a)*(i-o)}}function O(t,n,s){return t.sort(e),Math.ceil((s-n)/(2*(x(t,.75)-x(t,.25))*Math.pow(t.length,-1/3)))}function D(t,e,n){return Math.ceil((n-e)/(3.5*c(t)*Math.pow(t.length,-1/3)))}function A(t,e){var n,s,i=-1,o=t.length;if(null==e){for(;++i<o;)if(null!=(s=t[i])&&s>=s){n=s;break}for(;++i<o;)null!=(s=t[i])&&s>n&&(n=s)}else{for(;++i<o;)if(null!=(s=e(t[i],i,t))&&s>=s){n=s;break}for(;++i<o;)null!=(s=e(t[i],i,t))&&s>n&&(n=s)}return n}function S(t,e){var n,s=0,i=t.length,o=-1,a=i;if(null==e)for(;++o<i;)isNaN(n=l(t[o]))?--a:s+=n;else for(;++o<i;)isNaN(n=l(e(t[o],o,t)))?--a:s+=n;if(a)return s/a}function M(t,n){var s,i=[],o=t.length,a=-1;if(null==n)for(;++a<o;)isNaN(s=l(t[a]))||i.push(s);else for(;++a<o;)isNaN(s=l(n(t[a],a,t)))||i.push(s);return x(i.sort(e),.5)}function $(t){for(var e,n,s,i=t.length,o=-1,a=0;++o<i;)a+=t[o].length;for(n=new Array(a);--i>=0;)for(e=(s=t[i]).length;--e>=0;)n[--a]=s[e];return n}function j(t,e){var n,s,i=-1,o=t.length;if(null==e){for(;++i<o;)if(null!=(s=t[i])&&s>=s){n=s;break}for(;++i<o;)null!=(s=t[i])&&n>s&&(n=s)}else{for(;++i<o;)if(null!=(s=e(t[i],i,t))&&s>=s){n=s;break}for(;++i<o;)null!=(s=e(t[i],i,t))&&n>s&&(n=s)}return n}function T(t){for(var e=0,n=t.length-1,s=t[0],i=new Array(n<0?0:n);e<n;)i[e]=[s,s=t[++e]];return i}function _(t,e){for(var n=e.length,s=new Array(n);n--;)s[n]=t[e[n]];return s}function N(t,n){if(s=t.length){var s,i,o=0,a=0,r=t[a];for(n||(n=e);++o<s;)(n(i=t[o],r)<0||0!==n(r,r))&&(r=i,a=o);return 0===n(r,r)?a:void 0}}function F(t,e,n){for(var s,i,o=(null==n?t.length:n)-(e=null==e?0:+e);o;)i=Math.random()*o--|0,s=t[o+e],t[o+e]=t[i+e],t[i+e]=s;return t}function E(t,e){var n,s=0,i=t.length,o=-1;if(null==e)for(;++o<i;)(n=+t[o])&&(s+=n);else for(;++o<i;)(n=+e(t[o],o,t))&&(s+=n);return s}function k(t){if(!(i=t.length))return[];for(var e=-1,n=j(t,I),s=new Array(n);++e<n;)for(var i,o=-1,a=s[e]=new Array(i);++o<i;)a[o]=t[o][e];return s}function I(t){return t.length}function P(){return k(arguments)}var z="0.7.1";t.version=z,t.bisect=o,t.bisectRight=o,t.bisectLeft=a,t.ascending=e,t.bisector=n,t.descending=r,t.deviation=c,t.extent=u,t.histogram=w,t.thresholdFreedmanDiaconis=O,t.thresholdScott=D,t.thresholdSturges=b,t.max=A,t.mean=S,t.median=M,t.merge=$,t.min=j,t.pairs=T,t.permute=_,t.quantile=x,t.range=f,t.scan=N,t.shuffle=F,t.sum=E,t.ticks=y,t.tickStep=H,t.transpose=k,t.variance=m,t.zip=P}(e)}(0,d3Array.exports);const{bisectRight:bisectRight}=d3Array.exports,quincunx=(t,e,n,s)=>{const i=t.length-1;t[0]=0,e[0]=0,n[0]=0,e[1]=e[1]/t[1],n[1]=n[1]/t[1];for(let s=2;s<i;++s)t[s]=t[s]-t[s-2]*n[s-2]*n[s-2]-t[s-1]*e[s-1]*e[s-1],e[s]=(e[s]-t[s-1]*e[s-1]*n[s-1])/t[s],n[s]=n[s]/t[s];for(let t=2;t<i;++t)s[t]=s[t]-e[t-1]*s[t-1]-n[t-2]*s[t-2];for(let e=1;e<i;++e)s[e]=s[e]/t[e];s[i-2]=s[i-2]-e[i-2]*s[i-1];for(let t=i-3;t>0;--t)s[t]=s[t]-e[t]*s[t+1]-n[t]*s[t+2]},smoothingSpline=(t,e,n,s)=>{const i=t.length-1,o=new Array(i+1),a=new Array(i+1),r=new Array(i+1),l=new Array(i+1),m=new Array(i+1),c=new Array(i+1),u=new Array(i+1),g=new Array(i+1),C=t.map((()=>[0,0,0,0]));C.pop();const f=2*(1-s)/(3*s);for(let e=0;e<i;++e)o[e]=t[e+1]-t[e],a[e]=3/o[e];m[0]=0;for(let n=1;n<i;++n)r[n]=-(a[n-1]+a[n]),l[n]=2*(t[n+1]-t[n-1]),m[n]=3*(e[n+1]-e[n])/o[n]-3*(e[n]-e[n-1])/o[n-1];m[i]=0;for(let t=1;t<i;++t)c[t]=a[t-1]*a[t-1]*n[t-1]+r[t]*r[t]*n[t]+a[t]*a[t]*n[t+1],c[t]=f*c[t]+l[t];for(let t=1;t<i-1;++t)u[t]=r[t]*a[t]*n[t]+a[t]*r[t+1]*n[t+1],u[t]=f*u[t]+o[t];for(let t=1;t<i-2;++t)g[t]=f*a[t]*a[t+1]*n[t+1];quincunx(c,u,g,m),C[0][3]=e[0]-f*a[0]*m[1]*n[0],C[1][3]=e[1]-f*(r[1]*m[1]+a[1]*m[2])*n[0],C[0][0]=m[1]/(3*o[0]),C[0][1]=0,C[0][2]=(C[1][3]-C[0][3])/o[0]-m[1]*o[0]/3,a[0]=0;for(let t=1;t<i;++t)C[t][0]=(m[t+1]-m[t])/(3*o[t]),C[t][1]=m[t],C[t][2]=(m[t]+m[t-1])*o[t-1]+C[t-1][2],C[t][3]=a[t-1]*m[t-1]+r[t]*m[t]+a[t]*m[t+1],C[t][3]=e[t]-f*C[t][3]*n[t];return C};class SplineInterpolator{constructor(t,e,n=1){const s=t.map(((t,e)=>e));s.sort(((e,n)=>t[e]-t[n]));const i=s.map((e=>t[e])),o=s.map((t=>e[t])),a=s.length,r=s.map((()=>1));this.n=a,this.x=i,this.y=o,this.params=smoothingSpline(i,o,r,n)}interpolate(t){if(t===this.x[this.n-1])return this.y[this.n-1];const e=Math.min(Math.max(0,bisectRight(this.x,t)-1),this.n-2),[n,s,i,o]=this.params[e];return n*(t-=this.x[e])*t*t+s*t*t+i*t+o}max(t=100){const e=this.x[0],n=(this.x[this.n-1]-e)/t;let s=-1/0;for(let i=0,o=e;i<t;++i,o+=n){const t=this.interpolate(o);t>s&&(s=t)}return s}min(t=100){const e=this.x[0],n=(this.x[this.n-1]-e)/t;let s=1/0;for(let i=0,o=e;i<t;++i,o+=n){const t=this.interpolate(o);t<s&&(s=t)}return s}domain(){return[this.x[0],this.x[this.x.length-1]]}range(){return[this.min(),this.max()]}curve(t,e=null){const n=((e=e||this.domain())[1]-e[0])/(t-1),s=new Array(t);for(let i=0;i<t;++i){const t=n*i+e[0];s[i]=[t,this.interpolate(t)]}return s}}var splineInterpolator=SplineInterpolator,SplineInterpolator$1=splineInterpolator;function createFromToArray(t={}){let{from:e=0,to:n=1,length:s=1e3,includeFrom:i=!0,includeTo:o=!0,distribution:a="uniform"}=t;const r=new Float64Array(s);let l=s;i&&o?l=s-1:!i&&o||i&&!o?l=s:i||o||(l=s+1);let m=(n-e)/l;if("uniform"===a)if(i){let t=0;for(;t<s;)r[t]=e+m*t,t++}else{let t=0;for(;t<s;)r[t]=e+m*(t+1),t++}else{if("log"!==a)throw new Error("Please choose for the distribution either uniform or log. By default the distribution chosen is uniform.");{let t=(n/e)**(1/l),o=Math.log(e)/Math.log(t);if(i){let e=0;for(;e<s;)r[e]=t**(o+e),e++}else{let e=0;for(;e<s;)r[e]=t**(o+e+1),e++}}}return r}const Y1=.08913147449493408,P1=[-.005387729650712429,.008226878746769157,.02198786811111689,-.03656379714117627,-.012692614766297404,.03348066254097446,-.008368748197417368,-.0005087819496582806],Q1=[.0008862163904564247,-.0023339375937419,.07952836873415717,-.05273963823400997,-.7122890234154284,.662328840472003,1.5622155839842302,-1.5657455823417585,-.9700050433032906,1],Y2=2.249481201171875,P2=[-3.6719225470772936,21.12946554483405,17.445385985570866,-44.6382324441787,-18.851064805871424,17.644729840837403,8.3705032834312,.10526468069939171,-.20243350835593876],Q2=[1.7211476576120028,-22.643693341313973,10.826866735546016,48.560921310873994,-20.14326346804852,-28.66081804998,3.971343795334387,6.242641248542475,1],Y3=.807220458984375,P3=[-6.81149956853777e-10,2.8522533178221704e-8,-6.794655751811263e-7,.0021455899538880526,.029015791000532906,.14286953440815717,.3377855389120359,.38707973897260434,.11703015634199525,-.16379404719331705,-.1311027816799519],Q3=[.011059242293464892,.15226433829533179,.848854343457902,2.5930192162362027,4.778465929458438,5.381683457070069,3.4662540724256723,1],Y4=.9399557113647461,P4=[26633922742578204e-28,-2.304047769118826e-10,460469890584318e-20,.00015754461742496055,.0018712349281955923,.009508047013259196,.018557330651423107,-.0022242652921344794,-.0350353787183178],Q4=[7646752923027944e-20,.00263861676657016,.03415891436709477,.22009110576413124,.7620591645536234,1.3653349817554064,1],Y5=.9836282730102539,P5=[9905570997331033e-32,-2811287356288318e-29,4.625961635228786e-9,4.4969678992770644e-7,14962478375834237e-21,.00020938631748758808,.001056288621524929,-.0011295143874558028,-.016743100507663373],Q5=[2.82243172016108e-7,27533547476472603e-21,.0009640118070051656,.016074608709367652,.1381518657490833,.5914293448864175,1];function polyval(t,e){let n=0;for(const s of t)n=n*e+s;return n}function calc(t,e,n,s,i){const o=t-e;return i*t+polyval(n,o)/polyval(s,o)*t}function erfcinv(t){let e,n,s,i,o=!1;if(Number.isNaN(t))return Number.NaN;if(t<0||t>2)throw new RangeError(`erfcinv()::invalid input argument. Value must be on the interval [0,2]. Value: \`${t}\`.`);return 0===t?Number.POSITIVE_INFINITY:2===t?Number.NEGATIVE_INFINITY:1===t?0:(t>1?(n=2-t,t=1-n,o=!0):(n=t,t=1-t),t<=.5?(s=t*(t+10),i=polyval(P1,t)/polyval(Q1,t),e=s*Y1+s*i,o?-e:e):n>=.25?(s=Math.sqrt(-2*Math.log(n)),n-=.25,i=polyval(P2,n)/polyval(Q2,n),e=s/(Y2+i),o?-e:e):(n=Math.sqrt(-Math.log(n)),n<3?calc(n,1.125,P3,Q3,Y3):n<6?calc(n,3,P4,Q4,Y4):calc(n,6,P5,Q5,Y5)))}function rayleighCdf(t,e=1){return t<0?0:-Math.expm1(-Math.pow(t,2)/(2*Math.pow(e,2)))}function xNoiseSanPlot(t,e={}){const{mask:n,cutOff:s,refine:i=!0,magnitudeMode:o=!1,scaleFactor:a=1,factorStd:r=5,fixOffset:l=!0}=e;let m;if(m=Array.isArray(n)&&n.length===t.length?new Float64Array(t.filter(((t,e)=>!n[e]))):new Float64Array(t),a>1)for(let t=0;t<m.length;t++)m[t]*=a;if(m=m.sort().reverse(),l&&!o){let t=Math.floor(m.length/2),e=.5*(m[t]+m[t+1]);for(let t=0;t<m.length;t++)m[t]-=e}let c=m[m.length-1]>=0?m.length:m.findIndex((t=>t<0)),u=c-1;for(let t=u;t>=0;t--)if(m[t]>0){u=t;break}let g,C=m.slice(0,u+1),f=m.slice(c),p=s||determineCutOff(C,{magnitudeMode:o}),h=C[Math.floor(C.length*p)],d=C[0];if(f.length>0){g=-1*f[Math.floor(f.length*(1-p))]}else g=0;let y=h,H=g,b=C.slice(),v=f.slice(),w=0,x=2;if(i){let t=y*r;w=C.findIndex((e=>e<t)),w>-1&&(b=C.slice(w),y=b[Math.floor(b.length*p)]),t=H*r,x=f.findIndex((e=>e<t)),x>-1&&(v=f.slice(x),H=b[Math.floor(v.length*(1-p))])}let O,D,A=-simpleNormInv(p/2,{magnitudeMode:o});return h/=A,g/=A,i&&w>-1?(O=(p*b.length+w)/(b.length+w),D=-1*simpleNormInv(O/2,{magnitudeMode:o}),y/=D,x>-1&&(O=(p*v.length+x)/(v.length+x),D=-1*simpleNormInv(O/2,{magnitudeMode:o}),0!==H&&(H/=D))):(y/=A,H/=A),{positive:y,negative:H,snr:d/y,sanplot:generateSanPlot(m,{fromTo:{positive:{from:0,to:u},negative:{from:c,to:m.length}}})}}function determineCutOff(t,e={}){let{magnitudeMode:n=!1,considerList:s={from:.5,step:.1,to:.9}}=e,i=[],o=t.length-1;for(let e=.01;e<=.99;e+=.01){let s=-t[Math.round(o*e)]/simpleNormInv([e/2],{magnitudeMode:n});i.push([e,s])}let a=Number.MAX_SAFE_INTEGER,{from:r,to:l,step:m}=s,c=m/2,u=.5;for(let t=r;t<=l;t+=m){let e=t-c,n=t+c,s=i.filter((t=>t[0]<n&&t[0]>e)),o=s.reduce(((t,e)=>t+Math.abs(e[1])),0),r=0;for(const t of s)r+=Math.pow(t[1]-o,2);r<a&&(a=r,u=t)}return u}function simpleNormInv(t,e={}){const{magnitudeMode:n=!1}=e;Array.isArray(t)||(t=[t]);let s=Array.from(createArray(0,2,.01)),i=new Float64Array(t.length),o=new Float64Array(s.length);if(n){let e=1;for(let t=0;t<o.length;t++){let n=s[t]*e;o[t]=1-rayleighCdf(n)}let n=new SplineInterpolator$1(s,o);for(let e=0;e<i.length;e++){let s=2*t[e];i[e]=-1*n.interpolate(s)}}else for(let e=0;e<i.length;e++)i[e]=-1*Math.SQRT2*erfcinv(2*t[e]);return 1===i.length?i[0]:i}function createArray(t,e,n){let s=new Float64Array(Math.abs((t-e)/n+1));for(let e=0;e<s.length;e++)s[e]=t+e*n;return s}function generateSanPlot(t,e={}){const{fromTo:n,logBaseY:s=2}=e;let i={};for(let e in n){let{from:o,to:a}=n[e];i[e]=o!==a?scale(t.slice(o,a),{logBaseY:s}):{x:[],y:[]},"negative"===e&&i[e].y.reverse()}return i}function scale(t,e={}){const{log10:n,abs:s}=Math,{logBaseY:i}=e;if(i){t=t.slice();const e=n(i);for(let i=0;i<t.length;i++)t[i]=n(s(t[i]))/e}return{x:createFromToArray({from:0,to:t.length-1,length:t.length}),y:t}}function reimPhaseCorrection(t,e=0,n=0,s={}){const{reverse:i=!1}=s;e=Number.isFinite(e)?e:0,n=Number.isFinite(n)?n:0;const o=t.re,a=t.im,r=t.re.length;let l=e,m=n/r;i&&(m*=-1,l+=n);const c=2*Math.pow(Math.sin(m/2),2),u=Math.sin(m);let g=Math.cos(l),C=Math.sin(l);const f=new Float64Array(r),p=new Float64Array(r);for(let t=0;t<r;t++){f[t]=o[t]*g-a[t]*C,p[t]=a[t]*g+o[t]*C;let e=C-(c*C-u*g);g=g-(c*g+u*C),C=e}return{re:f,im:p}}function reimAutoPhaseCorrection(t,e={}){const{re:n,im:s}=t,i=n.length,{magnitudeMode:o=!0,minRegSize:a=30,factorNoise:r=3,maxDistanceToJoin:l=256,reverse:m=!1}=e;let c=o?reimAbsolute(t):n,u=robustBaseLineRegionsDetection(holoborodko(c),{maxDistanceToJoin:l,magnitudeMode:o,factorNoise:r}),g=robustBaseLineRegionsDetection(c,{maxDistanceToJoin:l,magnitudeMode:o,factorNoise:r}),C=new Uint8Array(i);for(let t=0;t<i;t++)C[t]=g[t]&&u[t];const f=m?t=>i-t:t=>t;let p=-1,h=0,d=[];for(;p<i;){let t=[],e=[];for(;!C[++p]&&p<i;)h=f(p);for(;C[p]&&p<i;p++)t.push(n[p]),e.push(s[p]),p++;t.length>a&&d.push(autoPhaseRegion(t,e,h))}let[y,H]=weightedLinearRegression(d.map((t=>t.x0/i)),d.map((t=>t.ph0)),d.map((t=>t.area/1e11)));return{data:reimPhaseCorrection({re:n,im:s},H*Math.PI/180,y*Math.PI/180,{reverse:m}),ph0:H,ph1:y}}function autoPhaseRegion(t,e,n){let s=-180,i=180,o=5,a=0,r=Number.MAX_SAFE_INTEGER;for(;o>0;){let n=(i-s)/7;for(let o=s;o<=i;o+=n){let n=reimPhaseCorrection({re:t,im:e},toRadians(o),0),s=getNegArea(n.re);s<r&&([r,a]=[s,o])}s=a-n,i=a+n,o--}let l=reimPhaseCorrection({re:t,im:e},toRadians(a),0),m=0,c=0;for(let e=0;e<t.length;e++)m+=l.re[e],c+=l.re[e]*(e+n);return{ph0:a,area:m,x0:c/m}}function holoborodko(t){let e=new Float64Array(t.length);for(let n=5;n<t.length-5;n++)e[n]=(42*(t[n+1]-t[n-1])+48*(t[n+2]-t[n-2])+27*(t[n+3]+t[n-3])+8*(t[n+4]-t[n-4])+t[n+5]-t[n-5])/512;for(let n=0;n<5;n++)e[n]=e[5],e[t.length-n-1]=e[t.length-6];return e}function robustBaseLineRegionsDetection(t,e){const{maxDistanceToJoin:n,magnitudeMode:s,factorNoise:i}=e;let o=new Uint8Array(t.length);for(let e=0;e<t.length;e++)o[e]=0;let a=!0;for(;a;){let e=i*xNoiseSanPlot(t,{magnitudeMode:s}).positive;a=!1;for(let n=0;n<t.length;n++)Math.abs(t[n])>e&&!o[n]&&(a=!0,o[n]=1)}let r=0,l=0;for(let e=0;e<t.length;e++)if(o[e]){if(r<n)for(let t=0;t<=r;t++)o[l+t]=1;for(;o[++e]&&e<t.length;);l=e,r=0}else r++;return o}function weightedLinearRegression(t,e,n){let s=0,i=0,o=0,a=0,r=0;for(let l=0;l<t.length;l++)s+=t[l]*t[l]*n[l],i+=t[l]*n[l],o+=n[l],a+=t[l]*n[l]*e[l],r+=n[l]*e[l];let l=s*o-i*i,m=[[o/l,-i/l],[-i/l,s/l]];return[m[0][0]*a+m[0][1]*r,m[1][0]*a+m[1][1]*r]}const toRadians=t=>t*Math.PI/180,getNegArea=t=>{let e=0;for(let n of t)n<0&&(e-=n);return e};function FFT$1(t){if(this.size=0|t,this.size<=1||0!=(this.size&this.size-1))throw new Error("FFT size must be a power of two and bigger than 1");this._csize=t<<1;for(var e=new Array(2*this.size),n=0;n<e.length;n+=2){const t=Math.PI*n/this.size;e[n]=Math.cos(t),e[n+1]=-Math.sin(t)}this.table=e;for(var s=0,i=1;this.size>i;i<<=1)s++;this._width=s%2==0?s-1:s,this._bitrev=new Array(1<<this._width);for(var o=0;o<this._bitrev.length;o++){this._bitrev[o]=0;for(var a=0;a<this._width;a+=2){var r=this._width-a-2;this._bitrev[o]|=(o>>>a&3)<<r}}this._out=null,this._data=null,this._inv=0}var fft$1=FFT$1;FFT$1.prototype.fromComplexArray=function(t,e){for(var n=e||new Array(t.length>>>1),s=0;s<t.length;s+=2)n[s>>>1]=t[s];return n},FFT$1.prototype.createComplexArray=function(){const t=new Array(this._csize);for(var e=0;e<t.length;e++)t[e]=0;return t},FFT$1.prototype.toComplexArray=function(t,e){for(var n=e||this.createComplexArray(),s=0;s<n.length;s+=2)n[s]=t[s>>>1],n[s+1]=0;return n},FFT$1.prototype.completeSpectrum=function(t){for(var e=this._csize,n=e>>>1,s=2;s<n;s+=2)t[e-s]=t[s],t[e-s+1]=-t[s+1]},FFT$1.prototype.transform=function(t,e){if(t===e)throw new Error("Input and output buffers must be different");this._out=t,this._data=e,this._inv=0,this._transform4(),this._out=null,this._data=null},FFT$1.prototype.realTransform=function(t,e){if(t===e)throw new Error("Input and output buffers must be different");this._out=t,this._data=e,this._inv=0,this._realTransform4(),this._out=null,this._data=null},FFT$1.prototype.inverseTransform=function(t,e){if(t===e)throw new Error("Input and output buffers must be different");this._out=t,this._data=e,this._inv=1,this._transform4();for(var n=0;n<t.length;n++)t[n]/=this.size;this._out=null,this._data=null},FFT$1.prototype._transform4=function(){var t,e,n=this._out,s=this._csize,i=1<<this._width,o=s/i<<1,a=this._bitrev;if(4===o)for(t=0,e=0;t<s;t+=o,e++){const n=a[e];this._singleTransform2(t,n,i)}else for(t=0,e=0;t<s;t+=o,e++){const n=a[e];this._singleTransform4(t,n,i)}var r=this._inv?-1:1,l=this.table;for(i>>=2;i>=2;i>>=2){var m=(o=s/i<<1)>>>2;for(t=0;t<s;t+=o)for(var c=t+m,u=t,g=0;u<c;u+=2,g+=i){const t=u,e=t+m,s=e+m,i=s+m,o=n[t],a=n[t+1],c=n[e],C=n[e+1],f=n[s],p=n[s+1],h=n[i],d=n[i+1],y=o,H=a,b=l[g],v=r*l[g+1],w=c*b-C*v,x=c*v+C*b,O=l[2*g],D=r*l[2*g+1],A=f*O-p*D,S=f*D+p*O,M=l[3*g],$=r*l[3*g+1],j=h*M-d*$,T=h*$+d*M,_=y+A,N=H+S,F=y-A,E=H-S,k=w+j,I=x+T,P=r*(w-j),z=r*(x-T),R=_+k,L=N+I,q=_-k,B=N-I,V=F+z,U=E-P,X=F-z,G=E+P;n[t]=R,n[t+1]=L,n[e]=V,n[e+1]=U,n[s]=q,n[s+1]=B,n[i]=X,n[i+1]=G}}},FFT$1.prototype._singleTransform2=function(t,e,n){const s=this._out,i=this._data,o=i[e],a=i[e+1],r=i[e+n],l=i[e+n+1],m=o+r,c=a+l,u=o-r,g=a-l;s[t]=m,s[t+1]=c,s[t+2]=u,s[t+3]=g},FFT$1.prototype._singleTransform4=function(t,e,n){const s=this._out,i=this._data,o=this._inv?-1:1,a=2*n,r=3*n,l=i[e],m=i[e+1],c=i[e+n],u=i[e+n+1],g=i[e+a],C=i[e+a+1],f=i[e+r],p=i[e+r+1],h=l+g,d=m+C,y=l-g,H=m-C,b=c+f,v=u+p,w=o*(c-f),x=o*(u-p),O=h+b,D=d+v,A=y+x,S=H-w,M=h-b,$=d-v,j=y-x,T=H+w;s[t]=O,s[t+1]=D,s[t+2]=A,s[t+3]=S,s[t+4]=M,s[t+5]=$,s[t+6]=j,s[t+7]=T},FFT$1.prototype._realTransform4=function(){var t,e,n=this._out,s=this._csize,i=1<<this._width,o=s/i<<1,a=this._bitrev;if(4===o)for(t=0,e=0;t<s;t+=o,e++){const n=a[e];this._singleRealTransform2(t,n>>>1,i>>>1)}else for(t=0,e=0;t<s;t+=o,e++){const n=a[e];this._singleRealTransform4(t,n>>>1,i>>>1)}var r=this._inv?-1:1,l=this.table;for(i>>=2;i>=2;i>>=2){var m=(o=s/i<<1)>>>1,c=m>>>1,u=c>>>1;for(t=0;t<s;t+=o)for(var g=0,C=0;g<=u;g+=2,C+=i){var f=t+g,p=f+c,h=p+c,d=h+c,y=n[f],H=n[f+1],b=n[p],v=n[p+1],w=n[h],x=n[h+1],O=n[d],D=n[d+1],A=y,S=H,M=l[C],$=r*l[C+1],j=b*M-v*$,T=b*$+v*M,_=l[2*C],N=r*l[2*C+1],F=w*_-x*N,E=w*N+x*_,k=l[3*C],I=r*l[3*C+1],P=O*k-D*I,z=O*I+D*k,R=A+F,L=S+E,q=A-F,B=S-E,V=j+P,U=T+z,X=r*(j-P),G=r*(T-z),Y=R+V,W=L+U,K=q+G,J=B-X;if(n[f]=Y,n[f+1]=W,n[p]=K,n[p+1]=J,0!==g){if(g!==u){var Z=q+-r*G,Q=-B+-r*X,tt=R+-r*V,et=-L- -r*U,nt=t+c-g,st=t+m-g;n[nt]=Z,n[nt+1]=Q,n[st]=tt,n[st+1]=et}}else{var it=R-V,ot=L-U;n[h]=it,n[h+1]=ot}}}},FFT$1.prototype._singleRealTransform2=function(t,e,n){const s=this._out,i=this._data,o=i[e],a=i[e+n],r=o+a,l=o-a;s[t]=r,s[t+1]=0,s[t+2]=l,s[t+3]=0},FFT$1.prototype._singleRealTransform4=function(t,e,n){const s=this._out,i=this._data,o=this._inv?-1:1,a=2*n,r=3*n,l=i[e],m=i[e+n],c=i[e+a],u=i[e+r],g=l+c,C=l-c,f=m+u,p=o*(m-u),h=g+f,d=C,y=-p,H=g-f,b=C,v=p;s[t]=h,s[t+1]=0,s[t+2]=d,s[t+3]=y,s[t+4]=H,s[t+5]=0,s[t+6]=b,s[t+7]=v};var FFT$2=fft$1;function xRotate(t,e){(e%=t.length)<0&&(e+=t.length);let n=new Float64Array(t.length);return n.set(t.slice(t.length-e)),n.set(t.slice(0,t.length-e),e),n}function reimFFT(t,e={}){const{inverse:n=!1,applyZeroShift:s=!1}=e;let{re:i,im:o}=t;const a=i.length,r=a<<1;let l=new Float64Array(r);for(let t=0;t<r;t+=2)l[t]=i[t>>>1],l[t+1]=o[t>>>1];let m=new FFT$2(a),c=new Float64Array(r);n?(s&&(l=zeroShift(l,!0)),m.inverseTransform(c,l)):(m.transform(c,l),s&&(c=zeroShift(c)));let u=new Float64Array(a),g=new Float64Array(a);for(let t=0;t<r;t+=2)u[t>>>1]=c[t],g[t>>>1]=c[t+1];return{re:u,im:g}}const zeroShift=(t,e)=>xRotate(t,e?Math.ceil(t.length/2):Math.floor(t.length/2));function xAbsolute(t){let e=t.slice();for(let t=0;t<e.length;t++)e[t]<0&&(e[t]*=-1);return e}const toString$2=Object.prototype.toString;function isAnyArray(t){const e=toString$2.call(t);return e.endsWith("Array]")&&!e.includes("Big")}function xMedian(t){if(!isAnyArray(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");const e=t.slice();let n=0,s=e.length-1,i=0,o=0,a=0,r=calcMiddle(n,s);for(;;){if(s<=n)return e[r];if(s===n+1)return e[n]>e[s]&&swap(e,n,s),e[r];for(i=calcMiddle(n,s),e[i]>e[s]&&swap(e,i,s),e[n]>e[s]&&swap(e,n,s),e[i]>e[n]&&swap(e,i,n),swap(e,i,n+1),o=n+1,a=s;;){do{o++}while(e[n]>e[o]);do{a--}while(e[a]>e[n]);if(a<o)break;swap(e,o,a)}swap(e,n,a),a<=r&&(n=o),a>=r&&(s=a-1)}}function swap(t,e,n){const s=t[n];t[n]=t[e],t[e]=s}function calcMiddle(t,e){return Math.floor((t+e)/2)}function xAbsoluteMedian(t){return xMedian(xAbsolute(t))}function xAdd(t,e){let n=!1,s=0;if(isAnyArray(e)){if(t.length!==e.length)throw new Error("xAdd: size of array1 and array2 must be identical")}else n=!0,s=e;let i=new Float64Array(t.length);if(n)for(let e=0;e<t.length;e++)i[e]=t[e]+s;else for(let n=0;n<t.length;n++)i[n]=t[n]+e[n];return i}function xApplyFunctionStr(t,e={}){const{variableLabel:n="x",fctString:s=n}=e,i=new Function(n,`return Number(${s.replace(/(?<before>^|\W)(?<after>[\da-z]{2,}\()/g,"$<before>Math.$<after>").replace(/Math\.Math/g,"Math")})`),o=Float64Array.from(t);for(let e=0;e<t.length;e++)if(o[e]=i(t[e]),Number.isNaN(o[e]))throw new Error(`The callback ${s} does not return a number: ${t[e]}`);return o}function getOutputArray(t,e){if(void 0!==t){if(!isAnyArray(t))throw new TypeError("output option must be an array if specified");if(t.length!==e)throw new TypeError("the output array does not have the correct length");return t}return new Float64Array(e)}function xMultiply(t,e,n={}){let s=!1,i=0;if(isAnyArray(e)){if(t.length!==e.length)throw new Error("xMultiply: size of array1 and array2 must be identical")}else s=!0,i=Number(e);let o=getOutputArray(n.output,t.length);if(s)for(let e=0;e<t.length;e++)o[e]=t[e]*i;else for(let n=0;n<t.length;n++)o[n]=t[n]*e[n];return o}function xCheck(t,e={}){const{minLength:n}=e;if(!isAnyArray(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");if(n&&t.length<n)throw new Error(`input must have a length of at least ${n}`)}function max(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isAnyArray(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");var n=e.fromIndex,s=void 0===n?0:n,i=e.toIndex,o=void 0===i?t.length:i;if(s<0||s>=t.length||!Number.isInteger(s))throw new Error("fromIndex must be a positive integer smaller than length");if(o<=s||o>t.length||!Number.isInteger(o))throw new Error("toIndex must be an integer greater than fromIndex and at most equal to length");for(var a=t[s],r=s+1;r<o;r++)t[r]>a&&(a=t[r]);return a}function min(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isAnyArray(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");var n=e.fromIndex,s=void 0===n?0:n,i=e.toIndex,o=void 0===i?t.length:i;if(s<0||s>=t.length||!Number.isInteger(s))throw new Error("fromIndex must be a positive integer smaller than length");if(o<=s||o>t.length||!Number.isInteger(o))throw new Error("toIndex must be an integer greater than fromIndex and at most equal to length");for(var a=t[s],r=s+1;r<o;r++)t[r]<a&&(a=t[r]);return a}function rescale$1(t){var e,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isAnyArray(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");if(void 0!==n.output){if(!isAnyArray(n.output))throw new TypeError("output option must be an array if specified");e=n.output}else e=new Array(t.length);var s=min(t),i=max(t);if(s===i)throw new RangeError("minimum and maximum input values are equal. Cannot rescale a constant array");var o=n.min,a=void 0===o?n.autoMinMax?s:0:o,r=n.max,l=void 0===r?n.autoMinMax?i:1:r;if(a>=l)throw new RangeError("min option must be smaller than max option");for(var m=(l-a)/(i-s),c=0;c<t.length;c++)e[c]=(t[c]-s)*m+a;return e}const indent=" ".repeat(2),indentData=" ".repeat(4);function inspectMatrix(){return inspectMatrixWithOptions(this)}function inspectMatrixWithOptions(t,e={}){const{maxRows:n=15,maxColumns:s=10,maxNumSize:i=8,padMinus:o="auto"}=e;return`${t.constructor.name} {\n${indent}[\n${indentData}${inspectData(t,n,s,i,o)}\n${indent}]\n${indent}rows: ${t.rows}\n${indent}columns: ${t.columns}\n}`}function inspectData(t,e,n,s,i){const{rows:o,columns:a}=t,r=Math.min(o,e),l=Math.min(a,n),m=[];if("auto"===i){i=!1;t:for(let e=0;e<r;e++)for(let n=0;n<l;n++)if(t.get(e,n)<0){i=!0;break t}}for(let e=0;e<r;e++){let n=[];for(let o=0;o<l;o++)n.push(formatNumber(t.get(e,o),s,i));m.push(`${n.join(" ")}`)}return l!==a&&(m[m.length-1]+=` ... ${a-n} more columns`),r!==o&&m.push(`... ${o-e} more rows`),m.join(`\n${indentData}`)}function formatNumber(t,e,n){return(t>=0&&n?` ${formatNumber2(t,e-1)}`:formatNumber2(t,e)).padEnd(e)}function formatNumber2(t,e){let n=t.toString();if(n.length<=e)return n;let s=t.toFixed(e);if(s.length>e&&(s=t.toFixed(Math.max(0,e-(s.length-e)))),s.length<=e&&!s.startsWith("0.000")&&!s.startsWith("-0.000"))return s;let i=t.toExponential(e);return i.length>e&&(i=t.toExponential(Math.max(0,e-(i.length-e)))),i.slice(0)}function installMathOperations(t,e){t.prototype.add=function(t){return"number"==typeof t?this.addS(t):this.addM(t)},t.prototype.addS=function(t){for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)+t);return this},t.prototype.addM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)+t.get(e,n));return this},t.add=function(t,n){return new e(t).add(n)},t.prototype.sub=function(t){return"number"==typeof t?this.subS(t):this.subM(t)},t.prototype.subS=function(t){for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)-t);return this},t.prototype.subM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)-t.get(e,n));return this},t.sub=function(t,n){return new e(t).sub(n)},t.prototype.subtract=t.prototype.sub,t.prototype.subtractS=t.prototype.subS,t.prototype.subtractM=t.prototype.subM,t.subtract=t.sub,t.prototype.mul=function(t){return"number"==typeof t?this.mulS(t):this.mulM(t)},t.prototype.mulS=function(t){for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)*t);return this},t.prototype.mulM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)*t.get(e,n));return this},t.mul=function(t,n){return new e(t).mul(n)},t.prototype.multiply=t.prototype.mul,t.prototype.multiplyS=t.prototype.mulS,t.prototype.multiplyM=t.prototype.mulM,t.multiply=t.mul,t.prototype.div=function(t){return"number"==typeof t?this.divS(t):this.divM(t)},t.prototype.divS=function(t){for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)/t);return this},t.prototype.divM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)/t.get(e,n));return this},t.div=function(t,n){return new e(t).div(n)},t.prototype.divide=t.prototype.div,t.prototype.divideS=t.prototype.divS,t.prototype.divideM=t.prototype.divM,t.divide=t.div,t.prototype.mod=function(t){return"number"==typeof t?this.modS(t):this.modM(t)},t.prototype.modS=function(t){for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)%t);return this},t.prototype.modM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)%t.get(e,n));return this},t.mod=function(t,n){return new e(t).mod(n)},t.prototype.modulus=t.prototype.mod,t.prototype.modulusS=t.prototype.modS,t.prototype.modulusM=t.prototype.modM,t.modulus=t.mod,t.prototype.and=function(t){return"number"==typeof t?this.andS(t):this.andM(t)},t.prototype.andS=function(t){for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)&t);return this},t.prototype.andM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)&t.get(e,n));return this},t.and=function(t,n){return new e(t).and(n)},t.prototype.or=function(t){return"number"==typeof t?this.orS(t):this.orM(t)},t.prototype.orS=function(t){for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)|t);return this},t.prototype.orM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)|t.get(e,n));return this},t.or=function(t,n){return new e(t).or(n)},t.prototype.xor=function(t){return"number"==typeof t?this.xorS(t):this.xorM(t)},t.prototype.xorS=function(t){for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)^t);return this},t.prototype.xorM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)^t.get(e,n));return this},t.xor=function(t,n){return new e(t).xor(n)},t.prototype.leftShift=function(t){return"number"==typeof t?this.leftShiftS(t):this.leftShiftM(t)},t.prototype.leftShiftS=function(t){for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)<<t);return this},t.prototype.leftShiftM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)<<t.get(e,n));return this},t.leftShift=function(t,n){return new e(t).leftShift(n)},t.prototype.signPropagatingRightShift=function(t){return"number"==typeof t?this.signPropagatingRightShiftS(t):this.signPropagatingRightShiftM(t)},t.prototype.signPropagatingRightShiftS=function(t){for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)>>t);return this},t.prototype.signPropagatingRightShiftM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)>>t.get(e,n));return this},t.signPropagatingRightShift=function(t,n){return new e(t).signPropagatingRightShift(n)},t.prototype.rightShift=function(t){return"number"==typeof t?this.rightShiftS(t):this.rightShiftM(t)},t.prototype.rightShiftS=function(t){for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)>>>t);return this},t.prototype.rightShiftM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)>>>t.get(e,n));return this},t.rightShift=function(t,n){return new e(t).rightShift(n)},t.prototype.zeroFillRightShift=t.prototype.rightShift,t.prototype.zeroFillRightShiftS=t.prototype.rightShiftS,t.prototype.zeroFillRightShiftM=t.prototype.rightShiftM,t.zeroFillRightShift=t.rightShift,t.prototype.not=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,~this.get(t,e));return this},t.not=function(t){return new e(t).not()},t.prototype.abs=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.abs(this.get(t,e)));return this},t.abs=function(t){return new e(t).abs()},t.prototype.acos=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.acos(this.get(t,e)));return this},t.acos=function(t){return new e(t).acos()},t.prototype.acosh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.acosh(this.get(t,e)));return this},t.acosh=function(t){return new e(t).acosh()},t.prototype.asin=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.asin(this.get(t,e)));return this},t.asin=function(t){return new e(t).asin()},t.prototype.asinh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.asinh(this.get(t,e)));return this},t.asinh=function(t){return new e(t).asinh()},t.prototype.atan=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.atan(this.get(t,e)));return this},t.atan=function(t){return new e(t).atan()},t.prototype.atanh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.atanh(this.get(t,e)));return this},t.atanh=function(t){return new e(t).atanh()},t.prototype.cbrt=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.cbrt(this.get(t,e)));return this},t.cbrt=function(t){return new e(t).cbrt()},t.prototype.ceil=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.ceil(this.get(t,e)));return this},t.ceil=function(t){return new e(t).ceil()},t.prototype.clz32=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.clz32(this.get(t,e)));return this},t.clz32=function(t){return new e(t).clz32()},t.prototype.cos=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.cos(this.get(t,e)));return this},t.cos=function(t){return new e(t).cos()},t.prototype.cosh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.cosh(this.get(t,e)));return this},t.cosh=function(t){return new e(t).cosh()},t.prototype.exp=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.exp(this.get(t,e)));return this},t.exp=function(t){return new e(t).exp()},t.prototype.expm1=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.expm1(this.get(t,e)));return this},t.expm1=function(t){return new e(t).expm1()},t.prototype.floor=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.floor(this.get(t,e)));return this},t.floor=function(t){return new e(t).floor()},t.prototype.fround=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.fround(this.get(t,e)));return this},t.fround=function(t){return new e(t).fround()},t.prototype.log=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log(this.get(t,e)));return this},t.log=function(t){return new e(t).log()},t.prototype.log1p=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log1p(this.get(t,e)));return this},t.log1p=function(t){return new e(t).log1p()},t.prototype.log10=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log10(this.get(t,e)));return this},t.log10=function(t){return new e(t).log10()},t.prototype.log2=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log2(this.get(t,e)));return this},t.log2=function(t){return new e(t).log2()},t.prototype.round=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.round(this.get(t,e)));return this},t.round=function(t){return new e(t).round()},t.prototype.sign=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sign(this.get(t,e)));return this},t.sign=function(t){return new e(t).sign()},t.prototype.sin=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sin(this.get(t,e)));return this},t.sin=function(t){return new e(t).sin()},t.prototype.sinh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sinh(this.get(t,e)));return this},t.sinh=function(t){return new e(t).sinh()},t.prototype.sqrt=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sqrt(this.get(t,e)));return this},t.sqrt=function(t){return new e(t).sqrt()},t.prototype.tan=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.tan(this.get(t,e)));return this},t.tan=function(t){return new e(t).tan()},t.prototype.tanh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.tanh(this.get(t,e)));return this},t.tanh=function(t){return new e(t).tanh()},t.prototype.trunc=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.trunc(this.get(t,e)));return this},t.trunc=function(t){return new e(t).trunc()},t.pow=function(t,n){return new e(t).pow(n)},t.prototype.pow=function(t){return"number"==typeof t?this.powS(t):this.powM(t)},t.prototype.powS=function(t){for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,Math.pow(this.get(e,n),t));return this},t.prototype.powM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,Math.pow(this.get(e,n),t.get(e,n)));return this}}function checkRowIndex(t,e,n){let s=n?t.rows:t.rows-1;if(e<0||e>s)throw new RangeError("Row index out of range")}function checkColumnIndex(t,e,n){let s=n?t.columns:t.columns-1;if(e<0||e>s)throw new RangeError("Column index out of range")}function checkRowVector(t,e){if(e.to1DArray&&(e=e.to1DArray()),e.length!==t.columns)throw new RangeError("vector size must be the same as the number of columns");return e}function checkColumnVector(t,e){if(e.to1DArray&&(e=e.to1DArray()),e.length!==t.rows)throw new RangeError("vector size must be the same as the number of rows");return e}function checkRowIndices(t,e){if(!isAnyArray(e))throw new TypeError("row indices must be an array");for(let n=0;n<e.length;n++)if(e[n]<0||e[n]>=t.rows)throw new RangeError("row indices are out of range")}function checkColumnIndices(t,e){if(!isAnyArray(e))throw new TypeError("column indices must be an array");for(let n=0;n<e.length;n++)if(e[n]<0||e[n]>=t.columns)throw new RangeError("column indices are out of range")}function checkRange$1(t,e,n,s,i){if(5!==arguments.length)throw new RangeError("expected 4 arguments");if(checkNumber("startRow",e),checkNumber("endRow",n),checkNumber("startColumn",s),checkNumber("endColumn",i),e>n||s>i||e<0||e>=t.rows||n<0||n>=t.rows||s<0||s>=t.columns||i<0||i>=t.columns)throw new RangeError("Submatrix indices are out of range")}function newArray$1(t,e=0){let n=[];for(let s=0;s<t;s++)n.push(e);return n}function checkNumber(t,e){if("number"!=typeof e)throw new TypeError(`${t} must be a number`)}function checkNonEmpty(t){if(t.isEmpty())throw new Error("Empty matrix has no elements to index")}function sumByRow(t){let e=newArray$1(t.rows);for(let n=0;n<t.rows;++n)for(let s=0;s<t.columns;++s)e[n]+=t.get(n,s);return e}function sumByColumn(t){let e=newArray$1(t.columns);for(let n=0;n<t.rows;++n)for(let s=0;s<t.columns;++s)e[s]+=t.get(n,s);return e}function sumAll(t){let e=0;for(let n=0;n<t.rows;n++)for(let s=0;s<t.columns;s++)e+=t.get(n,s);return e}function productByRow(t){let e=newArray$1(t.rows,1);for(let n=0;n<t.rows;++n)for(let s=0;s<t.columns;++s)e[n]*=t.get(n,s);return e}function productByColumn(t){let e=newArray$1(t.columns,1);for(let n=0;n<t.rows;++n)for(let s=0;s<t.columns;++s)e[s]*=t.get(n,s);return e}function productAll(t){let e=1;for(let n=0;n<t.rows;n++)for(let s=0;s<t.columns;s++)e*=t.get(n,s);return e}function varianceByRow(t,e,n){const s=t.rows,i=t.columns,o=[];for(let a=0;a<s;a++){let s=0,r=0,l=0;for(let e=0;e<i;e++)l=t.get(a,e)-n[a],s+=l,r+=l*l;e?o.push((r-s*s/i)/(i-1)):o.push((r-s*s/i)/i)}return o}function varianceByColumn(t,e,n){const s=t.rows,i=t.columns,o=[];for(let a=0;a<i;a++){let i=0,r=0,l=0;for(let e=0;e<s;e++)l=t.get(e,a)-n[a],i+=l,r+=l*l;e?o.push((r-i*i/s)/(s-1)):o.push((r-i*i/s)/s)}return o}function varianceAll(t,e,n){const s=t.rows,i=t.columns,o=s*i;let a=0,r=0,l=0;for(let e=0;e<s;e++)for(let s=0;s<i;s++)l=t.get(e,s)-n,a+=l,r+=l*l;return e?(r-a*a/o)/(o-1):(r-a*a/o)/o}function centerByRow(t,e){for(let n=0;n<t.rows;n++)for(let s=0;s<t.columns;s++)t.set(n,s,t.get(n,s)-e[n])}function centerByColumn(t,e){for(let n=0;n<t.rows;n++)for(let s=0;s<t.columns;s++)t.set(n,s,t.get(n,s)-e[s])}function centerAll(t,e){for(let n=0;n<t.rows;n++)for(let s=0;s<t.columns;s++)t.set(n,s,t.get(n,s)-e)}function getScaleByRow(t){const e=[];for(let n=0;n<t.rows;n++){let s=0;for(let e=0;e<t.columns;e++)s+=Math.pow(t.get(n,e),2)/(t.columns-1);e.push(Math.sqrt(s))}return e}function scaleByRow(t,e){for(let n=0;n<t.rows;n++)for(let s=0;s<t.columns;s++)t.set(n,s,t.get(n,s)/e[n])}function getScaleByColumn(t){const e=[];for(let n=0;n<t.columns;n++){let s=0;for(let e=0;e<t.rows;e++)s+=Math.pow(t.get(e,n),2)/(t.rows-1);e.push(Math.sqrt(s))}return e}function scaleByColumn(t,e){for(let n=0;n<t.rows;n++)for(let s=0;s<t.columns;s++)t.set(n,s,t.get(n,s)/e[s])}function getScaleAll(t){const e=t.size-1;let n=0;for(let s=0;s<t.columns;s++)for(let i=0;i<t.rows;i++)n+=Math.pow(t.get(i,s),2)/e;return Math.sqrt(n)}function scaleAll(t,e){for(let n=0;n<t.rows;n++)for(let s=0;s<t.columns;s++)t.set(n,s,t.get(n,s)/e)}class AbstractMatrix{static from1DArray(t,e,n){if(t*e!==n.length)throw new RangeError("data length does not match given dimensions");let s=new Matrix(t,e);for(let i=0;i<t;i++)for(let t=0;t<e;t++)s.set(i,t,n[i*e+t]);return s}static rowVector(t){let e=new Matrix(1,t.length);for(let n=0;n<t.length;n++)e.set(0,n,t[n]);return e}static columnVector(t){let e=new Matrix(t.length,1);for(let n=0;n<t.length;n++)e.set(n,0,t[n]);return e}static zeros(t,e){return new Matrix(t,e)}static ones(t,e){return new Matrix(t,e).fill(1)}static rand(t,e,n={}){if("object"!=typeof n)throw new TypeError("options must be an object");const{random:s=Math.random}=n;let i=new Matrix(t,e);for(let n=0;n<t;n++)for(let t=0;t<e;t++)i.set(n,t,s());return i}static randInt(t,e,n={}){if("object"!=typeof n)throw new TypeError("options must be an object");const{min:s=0,max:i=1e3,random:o=Math.random}=n;if(!Number.isInteger(s))throw new TypeError("min must be an integer");if(!Number.isInteger(i))throw new TypeError("max must be an integer");if(s>=i)throw new RangeError("min must be smaller than max");let a=i-s,r=new Matrix(t,e);for(let n=0;n<t;n++)for(let t=0;t<e;t++){let e=s+Math.round(o()*a);r.set(n,t,e)}return r}static eye(t,e,n){void 0===e&&(e=t),void 0===n&&(n=1);let s=Math.min(t,e),i=this.zeros(t,e);for(let t=0;t<s;t++)i.set(t,t,n);return i}static diag(t,e,n){let s=t.length;void 0===e&&(e=s),void 0===n&&(n=e);let i=Math.min(s,e,n),o=this.zeros(e,n);for(let e=0;e<i;e++)o.set(e,e,t[e]);return o}static min(t,e){t=this.checkMatrix(t),e=this.checkMatrix(e);let n=t.rows,s=t.columns,i=new Matrix(n,s);for(let o=0;o<n;o++)for(let n=0;n<s;n++)i.set(o,n,Math.min(t.get(o,n),e.get(o,n)));return i}static max(t,e){t=this.checkMatrix(t),e=this.checkMatrix(e);let n=t.rows,s=t.columns,i=new this(n,s);for(let o=0;o<n;o++)for(let n=0;n<s;n++)i.set(o,n,Math.max(t.get(o,n),e.get(o,n)));return i}static checkMatrix(t){return AbstractMatrix.isMatrix(t)?t:new Matrix(t)}static isMatrix(t){return null!=t&&"Matrix"===t.klass}get size(){return this.rows*this.columns}apply(t){if("function"!=typeof t)throw new TypeError("callback must be a function");for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)t.call(this,e,n);return this}to1DArray(){let t=[];for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)t.push(this.get(e,n));return t}to2DArray(){let t=[];for(let e=0;e<this.rows;e++){t.push([]);for(let n=0;n<this.columns;n++)t[e].push(this.get(e,n))}return t}toJSON(){return this.to2DArray()}isRowVector(){return 1===this.rows}isColumnVector(){return 1===this.columns}isVector(){return 1===this.rows||1===this.columns}isSquare(){return this.rows===this.columns}isEmpty(){return 0===this.rows||0===this.columns}isSymmetric(){if(this.isSquare()){for(let t=0;t<this.rows;t++)for(let e=0;e<=t;e++)if(this.get(t,e)!==this.get(e,t))return!1;return!0}return!1}isEchelonForm(){let t=0,e=0,n=-1,s=!0,i=!1;for(;t<this.rows&&s;){for(e=0,i=!1;e<this.columns&&!1===i;)0===this.get(t,e)?e++:1===this.get(t,e)&&e>n?(i=!0,n=e):(s=!1,i=!0);t++}return s}isReducedEchelonForm(){let t=0,e=0,n=-1,s=!0,i=!1;for(;t<this.rows&&s;){for(e=0,i=!1;e<this.columns&&!1===i;)0===this.get(t,e)?e++:1===this.get(t,e)&&e>n?(i=!0,n=e):(s=!1,i=!0);for(let n=e+1;n<this.rows;n++)0!==this.get(t,n)&&(s=!1);t++}return s}echelonForm(){let t=this.clone(),e=0,n=0;for(;e<t.rows&&n<t.columns;){let s=e;for(let i=e;i<t.rows;i++)t.get(i,n)>t.get(s,n)&&(s=i);if(0===t.get(s,n))n++;else{t.swapRows(e,s);let i=t.get(e,n);for(let s=n;s<t.columns;s++)t.set(e,s,t.get(e,s)/i);for(let s=e+1;s<t.rows;s++){let i=t.get(s,n)/t.get(e,n);t.set(s,n,0);for(let o=n+1;o<t.columns;o++)t.set(s,o,t.get(s,o)-t.get(e,o)*i)}e++,n++}}return t}reducedEchelonForm(){let t=this.echelonForm(),e=t.columns,n=t.rows,s=n-1;for(;s>=0;)if(0===t.maxRow(s))s--;else{let i=0,o=!1;for(;i<n&&!1===o;)1===t.get(s,i)?o=!0:i++;for(let n=0;n<s;n++){let o=t.get(n,i);for(let a=i;a<e;a++){let e=t.get(n,a)-o*t.get(s,a);t.set(n,a,e)}}s--}return t}set(){throw new Error("set method is unimplemented")}get(){throw new Error("get method is unimplemented")}repeat(t={}){if("object"!=typeof t)throw new TypeError("options must be an object");const{rows:e=1,columns:n=1}=t;if(!Number.isInteger(e)||e<=0)throw new TypeError("rows must be a positive integer");if(!Number.isInteger(n)||n<=0)throw new TypeError("columns must be a positive integer");let s=new Matrix(this.rows*e,this.columns*n);for(let t=0;t<e;t++)for(let e=0;e<n;e++)s.setSubMatrix(this,this.rows*t,this.columns*e);return s}fill(t){for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,t);return this}neg(){return this.mulS(-1)}getRow(t){checkRowIndex(this,t);let e=[];for(let n=0;n<this.columns;n++)e.push(this.get(t,n));return e}getRowVector(t){return Matrix.rowVector(this.getRow(t))}setRow(t,e){checkRowIndex(this,t),e=checkRowVector(this,e);for(let n=0;n<this.columns;n++)this.set(t,n,e[n]);return this}swapRows(t,e){checkRowIndex(this,t),checkRowIndex(this,e);for(let n=0;n<this.columns;n++){let s=this.get(t,n);this.set(t,n,this.get(e,n)),this.set(e,n,s)}return this}getColumn(t){checkColumnIndex(this,t);let e=[];for(let n=0;n<this.rows;n++)e.push(this.get(n,t));return e}getColumnVector(t){return Matrix.columnVector(this.getColumn(t))}setColumn(t,e){checkColumnIndex(this,t),e=checkColumnVector(this,e);for(let n=0;n<this.rows;n++)this.set(n,t,e[n]);return this}swapColumns(t,e){checkColumnIndex(this,t),checkColumnIndex(this,e);for(let n=0;n<this.rows;n++){let s=this.get(n,t);this.set(n,t,this.get(n,e)),this.set(n,e,s)}return this}addRowVector(t){t=checkRowVector(this,t);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)+t[n]);return this}subRowVector(t){t=checkRowVector(this,t);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)-t[n]);return this}mulRowVector(t){t=checkRowVector(this,t);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)*t[n]);return this}divRowVector(t){t=checkRowVector(this,t);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)/t[n]);return this}addColumnVector(t){t=checkColumnVector(this,t);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)+t[e]);return this}subColumnVector(t){t=checkColumnVector(this,t);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)-t[e]);return this}mulColumnVector(t){t=checkColumnVector(this,t);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)*t[e]);return this}divColumnVector(t){t=checkColumnVector(this,t);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.set(e,n,this.get(e,n)/t[e]);return this}mulRow(t,e){checkRowIndex(this,t);for(let n=0;n<this.columns;n++)this.set(t,n,this.get(t,n)*e);return this}mulColumn(t,e){checkColumnIndex(this,t);for(let n=0;n<this.rows;n++)this.set(n,t,this.get(n,t)*e);return this}max(t){if(this.isEmpty())return NaN;switch(t){case"row":{const t=new Array(this.rows).fill(Number.NEGATIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.get(e,n)>t[e]&&(t[e]=this.get(e,n));return t}case"column":{const t=new Array(this.columns).fill(Number.NEGATIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.get(e,n)>t[n]&&(t[n]=this.get(e,n));return t}case void 0:{let t=this.get(0,0);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.get(e,n)>t&&(t=this.get(e,n));return t}default:throw new Error(`invalid option: ${t}`)}}maxIndex(){checkNonEmpty(this);let t=this.get(0,0),e=[0,0];for(let n=0;n<this.rows;n++)for(let s=0;s<this.columns;s++)this.get(n,s)>t&&(t=this.get(n,s),e[0]=n,e[1]=s);return e}min(t){if(this.isEmpty())return NaN;switch(t){case"row":{const t=new Array(this.rows).fill(Number.POSITIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.get(e,n)<t[e]&&(t[e]=this.get(e,n));return t}case"column":{const t=new Array(this.columns).fill(Number.POSITIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.get(e,n)<t[n]&&(t[n]=this.get(e,n));return t}case void 0:{let t=this.get(0,0);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)this.get(e,n)<t&&(t=this.get(e,n));return t}default:throw new Error(`invalid option: ${t}`)}}minIndex(){checkNonEmpty(this);let t=this.get(0,0),e=[0,0];for(let n=0;n<this.rows;n++)for(let s=0;s<this.columns;s++)this.get(n,s)<t&&(t=this.get(n,s),e[0]=n,e[1]=s);return e}maxRow(t){if(checkRowIndex(this,t),this.isEmpty())return NaN;let e=this.get(t,0);for(let n=1;n<this.columns;n++)this.get(t,n)>e&&(e=this.get(t,n));return e}maxRowIndex(t){checkRowIndex(this,t),checkNonEmpty(this);let e=this.get(t,0),n=[t,0];for(let s=1;s<this.columns;s++)this.get(t,s)>e&&(e=this.get(t,s),n[1]=s);return n}minRow(t){if(checkRowIndex(this,t),this.isEmpty())return NaN;let e=this.get(t,0);for(let n=1;n<this.columns;n++)this.get(t,n)<e&&(e=this.get(t,n));return e}minRowIndex(t){checkRowIndex(this,t),checkNonEmpty(this);let e=this.get(t,0),n=[t,0];for(let s=1;s<this.columns;s++)this.get(t,s)<e&&(e=this.get(t,s),n[1]=s);return n}maxColumn(t){if(checkColumnIndex(this,t),this.isEmpty())return NaN;let e=this.get(0,t);for(let n=1;n<this.rows;n++)this.get(n,t)>e&&(e=this.get(n,t));return e}maxColumnIndex(t){checkColumnIndex(this,t),checkNonEmpty(this);let e=this.get(0,t),n=[0,t];for(let s=1;s<this.rows;s++)this.get(s,t)>e&&(e=this.get(s,t),n[0]=s);return n}minColumn(t){if(checkColumnIndex(this,t),this.isEmpty())return NaN;let e=this.get(0,t);for(let n=1;n<this.rows;n++)this.get(n,t)<e&&(e=this.get(n,t));return e}minColumnIndex(t){checkColumnIndex(this,t),checkNonEmpty(this);let e=this.get(0,t),n=[0,t];for(let s=1;s<this.rows;s++)this.get(s,t)<e&&(e=this.get(s,t),n[0]=s);return n}diag(){let t=Math.min(this.rows,this.columns),e=[];for(let n=0;n<t;n++)e.push(this.get(n,n));return e}norm(t="frobenius"){let e=0;if("max"===t)return this.max();if("frobenius"===t){for(let t=0;t<this.rows;t++)for(let n=0;n<this.columns;n++)e+=this.get(t,n)*this.get(t,n);return Math.sqrt(e)}throw new RangeError(`unknown norm type: ${t}`)}cumulativeSum(){let t=0;for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)t+=this.get(e,n),this.set(e,n,t);return this}dot(t){AbstractMatrix.isMatrix(t)&&(t=t.to1DArray());let e=this.to1DArray();if(e.length!==t.length)throw new RangeError("vectors do not have the same size");let n=0;for(let s=0;s<e.length;s++)n+=e[s]*t[s];return n}mmul(t){t=Matrix.checkMatrix(t);let e=this.rows,n=this.columns,s=t.columns,i=new Matrix(e,s),o=new Float64Array(n);for(let a=0;a<s;a++){for(let e=0;e<n;e++)o[e]=t.get(e,a);for(let t=0;t<e;t++){let e=0;for(let s=0;s<n;s++)e+=this.get(t,s)*o[s];i.set(t,a,e)}}return i}strassen2x2(t){t=Matrix.checkMatrix(t);let e=new Matrix(2,2);const n=this.get(0,0),s=t.get(0,0),i=this.get(0,1),o=t.get(0,1),a=this.get(1,0),r=t.get(1,0),l=this.get(1,1),m=t.get(1,1),c=(n+l)*(s+m),u=(a+l)*s,g=n*(o-m),C=l*(r-s),f=(n+i)*m,p=c+C-f+(i-l)*(r+m),h=g+f,d=u+C,y=c-u+g+(a-n)*(s+o);return e.set(0,0,p),e.set(0,1,h),e.set(1,0,d),e.set(1,1,y),e}strassen3x3(t){t=Matrix.checkMatrix(t);let e=new Matrix(3,3);const n=this.get(0,0),s=this.get(0,1),i=this.get(0,2),o=this.get(1,0),a=this.get(1,1),r=this.get(1,2),l=this.get(2,0),m=this.get(2,1),c=this.get(2,2),u=t.get(0,0),g=t.get(0,1),C=t.get(0,2),f=t.get(1,0),p=t.get(1,1),h=t.get(1,2),d=t.get(2,0),y=t.get(2,1),H=t.get(2,2),b=(n-o)*(-g+p),v=(-n+o+a)*(u-g+p),w=(o+a)*(-u+g),x=n*u,O=(-n+l+m)*(u-C+h),D=(-n+l)*(C-h),A=(l+m)*(-u+C),S=(-i+m+c)*(p+d-y),M=(i-c)*(p-y),$=i*d,j=(m+c)*(-d+y),T=(-i+a+r)*(h+d-H),_=(i-r)*(h-H),N=(a+r)*(-d+H),F=x+$+s*f,E=(n+s+i-o-a-m-c)*p+v+w+x+S+$+j,k=x+O+A+(n+s+i-a-r-l-m)*h+$+T+N,I=b+a*(-u+g+f-p-h-d+H)+v+x+$+T+_,P=b+v+w+x+r*y,z=$+T+_+N+o*C,R=x+O+D+m*(-u+C+f-p-h-d+y)+S+M+$,L=S+M+$+j+l*g,q=x+O+D+A+c*H;return e.set(0,0,F),e.set(0,1,E),e.set(0,2,k),e.set(1,0,I),e.set(1,1,P),e.set(1,2,z),e.set(2,0,R),e.set(2,1,L),e.set(2,2,q),e}mmulStrassen(t){t=Matrix.checkMatrix(t);let e=this.clone(),n=e.rows,s=e.columns,i=t.rows,o=t.columns;function a(t,e,n){let s=t.rows,i=t.columns;if(s===e&&i===n)return t;{let s=AbstractMatrix.zeros(e,n);return s=s.setSubMatrix(t,0,0),s}}s!==i&&console.warn(`Multiplying ${n} x ${s} and ${i} x ${o} matrix: dimensions do not match.`);let r=Math.max(n,i),l=Math.max(s,o);return e=a(e,r,l),function t(e,n,s,i){if(s<=512||i<=512)return e.mmul(n);s%2==1&&i%2==1?(e=a(e,s+1,i+1),n=a(n,s+1,i+1)):s%2==1?(e=a(e,s+1,i),n=a(n,s+1,i)):i%2==1&&(e=a(e,s,i+1),n=a(n,s,i+1));let o=parseInt(e.rows/2,10),r=parseInt(e.columns/2,10),l=e.subMatrix(0,o-1,0,r-1),m=n.subMatrix(0,o-1,0,r-1),c=e.subMatrix(0,o-1,r,e.columns-1),u=n.subMatrix(0,o-1,r,n.columns-1),g=e.subMatrix(o,e.rows-1,0,r-1),C=n.subMatrix(o,n.rows-1,0,r-1),f=e.subMatrix(o,e.rows-1,r,e.columns-1),p=n.subMatrix(o,n.rows-1,r,n.columns-1),h=t(AbstractMatrix.add(l,f),AbstractMatrix.add(m,p),o,r),d=t(AbstractMatrix.add(g,f),m,o,r),y=t(l,AbstractMatrix.sub(u,p),o,r),H=t(f,AbstractMatrix.sub(C,m),o,r),b=t(AbstractMatrix.add(l,c),p,o,r),v=t(AbstractMatrix.sub(g,l),AbstractMatrix.add(m,u),o,r),w=t(AbstractMatrix.sub(c,f),AbstractMatrix.add(C,p),o,r),x=AbstractMatrix.add(h,H);x.sub(b),x.add(w);let O=AbstractMatrix.add(y,b),D=AbstractMatrix.add(d,H),A=AbstractMatrix.sub(h,d);A.add(y),A.add(v);let S=AbstractMatrix.zeros(2*x.rows,2*x.columns);return S=S.setSubMatrix(x,0,0),S=S.setSubMatrix(O,x.rows,0),S=S.setSubMatrix(D,0,x.columns),S=S.setSubMatrix(A,x.rows,x.columns),S.subMatrix(0,s-1,0,i-1)}(e,t=a(t,r,l),r,l)}scaleRows(t={}){if("object"!=typeof t)throw new TypeError("options must be an object");const{min:e=0,max:n=1}=t;if(!Number.isFinite(e))throw new TypeError("min must be a number");if(!Number.isFinite(n))throw new TypeError("max must be a number");if(e>=n)throw new RangeError("min must be smaller than max");let s=new Matrix(this.rows,this.columns);for(let t=0;t<this.rows;t++){const i=this.getRow(t);i.length>0&&rescale$1(i,{min:e,max:n,output:i}),s.setRow(t,i)}return s}scaleColumns(t={}){if("object"!=typeof t)throw new TypeError("options must be an object");const{min:e=0,max:n=1}=t;if(!Number.isFinite(e))throw new TypeError("min must be a number");if(!Number.isFinite(n))throw new TypeError("max must be a number");if(e>=n)throw new RangeError("min must be smaller than max");let s=new Matrix(this.rows,this.columns);for(let t=0;t<this.columns;t++){const i=this.getColumn(t);i.length&&rescale$1(i,{min:e,max:n,output:i}),s.setColumn(t,i)}return s}flipRows(){const t=Math.ceil(this.columns/2);for(let e=0;e<this.rows;e++)for(let n=0;n<t;n++){let t=this.get(e,n),s=this.get(e,this.columns-1-n);this.set(e,n,s),this.set(e,this.columns-1-n,t)}return this}flipColumns(){const t=Math.ceil(this.rows/2);for(let e=0;e<this.columns;e++)for(let n=0;n<t;n++){let t=this.get(n,e),s=this.get(this.rows-1-n,e);this.set(n,e,s),this.set(this.rows-1-n,e,t)}return this}kroneckerProduct(t){t=Matrix.checkMatrix(t);let e=this.rows,n=this.columns,s=t.rows,i=t.columns,o=new Matrix(e*s,n*i);for(let a=0;a<e;a++)for(let e=0;e<n;e++)for(let n=0;n<s;n++)for(let r=0;r<i;r++)o.set(s*a+n,i*e+r,this.get(a,e)*t.get(n,r));return o}kroneckerSum(t){if(t=Matrix.checkMatrix(t),!this.isSquare()||!t.isSquare())throw new Error("Kronecker Sum needs two Square Matrices");let e=this.rows,n=t.rows,s=this.kroneckerProduct(Matrix.eye(n,n)),i=Matrix.eye(e,e).kroneckerProduct(t);return s.add(i)}transpose(){let t=new Matrix(this.columns,this.rows);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)t.set(n,e,this.get(e,n));return t}sortRows(t=compareNumbers){for(let e=0;e<this.rows;e++)this.setRow(e,this.getRow(e).sort(t));return this}sortColumns(t=compareNumbers){for(let e=0;e<this.columns;e++)this.setColumn(e,this.getColumn(e).sort(t));return this}subMatrix(t,e,n,s){checkRange$1(this,t,e,n,s);let i=new Matrix(e-t+1,s-n+1);for(let o=t;o<=e;o++)for(let e=n;e<=s;e++)i.set(o-t,e-n,this.get(o,e));return i}subMatrixRow(t,e,n){if(void 0===e&&(e=0),void 0===n&&(n=this.columns-1),e>n||e<0||e>=this.columns||n<0||n>=this.columns)throw new RangeError("Argument out of range");let s=new Matrix(t.length,n-e+1);for(let i=0;i<t.length;i++)for(let o=e;o<=n;o++){if(t[i]<0||t[i]>=this.rows)throw new RangeError(`Row index out of range: ${t[i]}`);s.set(i,o-e,this.get(t[i],o))}return s}subMatrixColumn(t,e,n){if(void 0===e&&(e=0),void 0===n&&(n=this.rows-1),e>n||e<0||e>=this.rows||n<0||n>=this.rows)throw new RangeError("Argument out of range");let s=new Matrix(n-e+1,t.length);for(let i=0;i<t.length;i++)for(let o=e;o<=n;o++){if(t[i]<0||t[i]>=this.columns)throw new RangeError(`Column index out of range: ${t[i]}`);s.set(o-e,i,this.get(o,t[i]))}return s}setSubMatrix(t,e,n){if((t=Matrix.checkMatrix(t)).isEmpty())return this;checkRange$1(this,e,e+t.rows-1,n,n+t.columns-1);for(let s=0;s<t.rows;s++)for(let i=0;i<t.columns;i++)this.set(e+s,n+i,t.get(s,i));return this}selection(t,e){checkRowIndices(this,t),checkColumnIndices(this,e);let n=new Matrix(t.length,e.length);for(let s=0;s<t.length;s++){let i=t[s];for(let t=0;t<e.length;t++){let o=e[t];n.set(s,t,this.get(i,o))}}return n}trace(){let t=Math.min(this.rows,this.columns),e=0;for(let n=0;n<t;n++)e+=this.get(n,n);return e}clone(){let t=new Matrix(this.rows,this.columns);for(let e=0;e<this.rows;e++)for(let n=0;n<this.columns;n++)t.set(e,n,this.get(e,n));return t}sum(t){switch(t){case"row":return sumByRow(this);case"column":return sumByColumn(this);case void 0:return sumAll(this);default:throw new Error(`invalid option: ${t}`)}}product(t){switch(t){case"row":return productByRow(this);case"column":return productByColumn(this);case void 0:return productAll(this);default:throw new Error(`invalid option: ${t}`)}}mean(t){const e=this.sum(t);switch(t){case"row":for(let t=0;t<this.rows;t++)e[t]/=this.columns;return e;case"column":for(let t=0;t<this.columns;t++)e[t]/=this.rows;return e;case void 0:return e/this.size;default:throw new Error(`invalid option: ${t}`)}}variance(t,e={}){if("object"==typeof t&&(e=t,t=void 0),"object"!=typeof e)throw new TypeError("options must be an object");const{unbiased:n=!0,mean:s=this.mean(t)}=e;if("boolean"!=typeof n)throw new TypeError("unbiased must be a boolean");switch(t){case"row":if(!isAnyArray(s))throw new TypeError("mean must be an array");return varianceByRow(this,n,s);case"column":if(!isAnyArray(s))throw new TypeError("mean must be an array");return varianceByColumn(this,n,s);case void 0:if("number"!=typeof s)throw new TypeError("mean must be a number");return varianceAll(this,n,s);default:throw new Error(`invalid option: ${t}`)}}standardDeviation(t,e){"object"==typeof t&&(e=t,t=void 0);const n=this.variance(t,e);if(void 0===t)return Math.sqrt(n);for(let t=0;t<n.length;t++)n[t]=Math.sqrt(n[t]);return n}center(t,e={}){if("object"==typeof t&&(e=t,t=void 0),"object"!=typeof e)throw new TypeError("options must be an object");const{center:n=this.mean(t)}=e;switch(t){case"row":if(!isAnyArray(n))throw new TypeError("center must be an array");return centerByRow(this,n),this;case"column":if(!isAnyArray(n))throw new TypeError("center must be an array");return centerByColumn(this,n),this;case void 0:if("number"!=typeof n)throw new TypeError("center must be a number");return centerAll(this,n),this;default:throw new Error(`invalid option: ${t}`)}}scale(t,e={}){if("object"==typeof t&&(e=t,t=void 0),"object"!=typeof e)throw new TypeError("options must be an object");let n=e.scale;switch(t){case"row":if(void 0===n)n=getScaleByRow(this);else if(!isAnyArray(n))throw new TypeError("scale must be an array");return scaleByRow(this,n),this;case"column":if(void 0===n)n=getScaleByColumn(this);else if(!isAnyArray(n))throw new TypeError("scale must be an array");return scaleByColumn(this,n),this;case void 0:if(void 0===n)n=getScaleAll(this);else if("number"!=typeof n)throw new TypeError("scale must be a number");return scaleAll(this,n),this;default:throw new Error(`invalid option: ${t}`)}}toString(t){return inspectMatrixWithOptions(this,t)}}function compareNumbers(t,e){return t-e}function isArrayOfNumbers(t){return t.every((t=>"number"==typeof t))}AbstractMatrix.prototype.klass="Matrix","undefined"!=typeof Symbol&&(AbstractMatrix.prototype[Symbol.for("nodejs.util.inspect.custom")]=inspectMatrix),AbstractMatrix.random=AbstractMatrix.rand,AbstractMatrix.randomInt=AbstractMatrix.randInt,AbstractMatrix.diagonal=AbstractMatrix.diag,AbstractMatrix.prototype.diagonal=AbstractMatrix.prototype.diag,AbstractMatrix.identity=AbstractMatrix.eye,AbstractMatrix.prototype.negate=AbstractMatrix.prototype.neg,AbstractMatrix.prototype.tensorProduct=AbstractMatrix.prototype.kroneckerProduct;class Matrix extends AbstractMatrix{constructor(t,e){if(super(),Matrix.isMatrix(t))return t.clone();if(Number.isInteger(t)&&t>=0){if(this.data=[],!(Number.isInteger(e)&&e>=0))throw new TypeError("nColumns must be a positive integer");for(let n=0;n<t;n++)this.data.push(new Float64Array(e))}else{if(!isAnyArray(t))throw new TypeError("First argument must be a positive number or an array");{const n=t;if("number"!=typeof(e=(t=n.length)?n[0].length:0))throw new TypeError("Data must be a 2D array with at least one element");this.data=[];for(let s=0;s<t;s++){if(n[s].length!==e)throw new RangeError("Inconsistent array dimensions");if(!isArrayOfNumbers(n[s]))throw new TypeError("Input data contains non-numeric values");this.data.push(Float64Array.from(n[s]))}}}this.rows=t,this.columns=e}set(t,e,n){return this.data[t][e]=n,this}get(t,e){return this.data[t][e]}removeRow(t){return checkRowIndex(this,t),this.data.splice(t,1),this.rows-=1,this}addRow(t,e){return void 0===e&&(e=t,t=this.rows),checkRowIndex(this,t,!0),e=Float64Array.from(checkRowVector(this,e)),this.data.splice(t,0,e),this.rows+=1,this}removeColumn(t){checkColumnIndex(this,t);for(let e=0;e<this.rows;e++){const n=new Float64Array(this.columns-1);for(let s=0;s<t;s++)n[s]=this.data[e][s];for(let s=t+1;s<this.columns;s++)n[s-1]=this.data[e][s];this.data[e]=n}return this.columns-=1,this}addColumn(t,e){void 0===e&&(e=t,t=this.columns),checkColumnIndex(this,t,!0),e=checkColumnVector(this,e);for(let n=0;n<this.rows;n++){const s=new Float64Array(this.columns+1);let i=0;for(;i<t;i++)s[i]=this.data[n][i];for(s[i++]=e[n];i<this.columns+1;i++)s[i]=this.data[n][i-1];this.data[n]=s}return this.columns+=1,this}}installMathOperations(AbstractMatrix,Matrix);class BaseView extends AbstractMatrix{constructor(t,e,n){super(),this.matrix=t,this.rows=e,this.columns=n}}class MatrixTransposeView extends BaseView{constructor(t){super(t,t.columns,t.rows)}set(t,e,n){return this.matrix.set(e,t,n),this}get(t,e){return this.matrix.get(e,t)}}class WrapperMatrix2D extends AbstractMatrix{constructor(t){super(),this.data=t,this.rows=t.length,this.columns=t[0].length}set(t,e,n){return this.data[t][e]=n,this}get(t,e){return this.data[t][e]}}class LuDecomposition{constructor(t){let e,n,s,i,o,a,r,l,m,c=(t=WrapperMatrix2D.checkMatrix(t)).clone(),u=c.rows,g=c.columns,C=new Float64Array(u),f=1;for(e=0;e<u;e++)C[e]=e;for(l=new Float64Array(u),n=0;n<g;n++){for(e=0;e<u;e++)l[e]=c.get(e,n);for(e=0;e<u;e++){for(m=Math.min(e,n),o=0,s=0;s<m;s++)o+=c.get(e,s)*l[s];l[e]-=o,c.set(e,n,l[e])}for(i=n,e=n+1;e<u;e++)Math.abs(l[e])>Math.abs(l[i])&&(i=e);if(i!==n){for(s=0;s<g;s++)a=c.get(i,s),c.set(i,s,c.get(n,s)),c.set(n,s,a);r=C[i],C[i]=C[n],C[n]=r,f=-f}if(n<u&&0!==c.get(n,n))for(e=n+1;e<u;e++)c.set(e,n,c.get(e,n)/c.get(n,n))}this.LU=c,this.pivotVector=C,this.pivotSign=f}isSingular(){let t=this.LU,e=t.columns;for(let n=0;n<e;n++)if(0===t.get(n,n))return!0;return!1}solve(t){t=Matrix.checkMatrix(t);let e=this.LU;if(e.rows!==t.rows)throw new Error("Invalid matrix dimensions");if(this.isSingular())throw new Error("LU matrix is singular");let n,s,i,o=t.columns,a=t.subMatrixRow(this.pivotVector,0,o-1),r=e.columns;for(i=0;i<r;i++)for(n=i+1;n<r;n++)for(s=0;s<o;s++)a.set(n,s,a.get(n,s)-a.get(i,s)*e.get(n,i));for(i=r-1;i>=0;i--){for(s=0;s<o;s++)a.set(i,s,a.get(i,s)/e.get(i,i));for(n=0;n<i;n++)for(s=0;s<o;s++)a.set(n,s,a.get(n,s)-a.get(i,s)*e.get(n,i))}return a}get determinant(){let t=this.LU;if(!t.isSquare())throw new Error("Matrix must be square");let e=this.pivotSign,n=t.columns;for(let s=0;s<n;s++)e*=t.get(s,s);return e}get lowerTriangularMatrix(){let t=this.LU,e=t.rows,n=t.columns,s=new Matrix(e,n);for(let i=0;i<e;i++)for(let e=0;e<n;e++)i>e?s.set(i,e,t.get(i,e)):i===e?s.set(i,e,1):s.set(i,e,0);return s}get upperTriangularMatrix(){let t=this.LU,e=t.rows,n=t.columns,s=new Matrix(e,n);for(let i=0;i<e;i++)for(let e=0;e<n;e++)i<=e?s.set(i,e,t.get(i,e)):s.set(i,e,0);return s}get pivotPermutationVector(){return Array.from(this.pivotVector)}}function hypotenuse(t,e){let n=0;return Math.abs(t)>Math.abs(e)?(n=e/t,Math.abs(t)*Math.sqrt(1+n*n)):0!==e?(n=t/e,Math.abs(e)*Math.sqrt(1+n*n)):0}class QrDecomposition{constructor(t){let e,n,s,i,o=(t=WrapperMatrix2D.checkMatrix(t)).clone(),a=t.rows,r=t.columns,l=new Float64Array(r);for(s=0;s<r;s++){let t=0;for(e=s;e<a;e++)t=hypotenuse(t,o.get(e,s));if(0!==t){for(o.get(s,s)<0&&(t=-t),e=s;e<a;e++)o.set(e,s,o.get(e,s)/t);for(o.set(s,s,o.get(s,s)+1),n=s+1;n<r;n++){for(i=0,e=s;e<a;e++)i+=o.get(e,s)*o.get(e,n);for(i=-i/o.get(s,s),e=s;e<a;e++)o.set(e,n,o.get(e,n)+i*o.get(e,s))}}l[s]=-t}this.QR=o,this.Rdiag=l}solve(t){t=Matrix.checkMatrix(t);let e=this.QR,n=e.rows;if(t.rows!==n)throw new Error("Matrix row dimensions must agree");if(!this.isFullRank())throw new Error("Matrix is rank deficient");let s,i,o,a,r=t.columns,l=t.clone(),m=e.columns;for(o=0;o<m;o++)for(i=0;i<r;i++){for(a=0,s=o;s<n;s++)a+=e.get(s,o)*l.get(s,i);for(a=-a/e.get(o,o),s=o;s<n;s++)l.set(s,i,l.get(s,i)+a*e.get(s,o))}for(o=m-1;o>=0;o--){for(i=0;i<r;i++)l.set(o,i,l.get(o,i)/this.Rdiag[o]);for(s=0;s<o;s++)for(i=0;i<r;i++)l.set(s,i,l.get(s,i)-l.get(o,i)*e.get(s,o))}return l.subMatrix(0,m-1,0,r-1)}isFullRank(){let t=this.QR.columns;for(let e=0;e<t;e++)if(0===this.Rdiag[e])return!1;return!0}get upperTriangularMatrix(){let t,e,n=this.QR,s=n.columns,i=new Matrix(s,s);for(t=0;t<s;t++)for(e=0;e<s;e++)t<e?i.set(t,e,n.get(t,e)):t===e?i.set(t,e,this.Rdiag[t]):i.set(t,e,0);return i}get orthogonalMatrix(){let t,e,n,s,i=this.QR,o=i.rows,a=i.columns,r=new Matrix(o,a);for(n=a-1;n>=0;n--){for(t=0;t<o;t++)r.set(t,n,0);for(r.set(n,n,1),e=n;e<a;e++)if(0!==i.get(n,n)){for(s=0,t=n;t<o;t++)s+=i.get(t,n)*r.get(t,e);for(s=-s/i.get(n,n),t=n;t<o;t++)r.set(t,e,r.get(t,e)+s*i.get(t,n))}}return r}}class SingularValueDecomposition{constructor(t,e={}){if((t=WrapperMatrix2D.checkMatrix(t)).isEmpty())throw new Error("Matrix must be non-empty");let n=t.rows,s=t.columns;const{computeLeftSingularVectors:i=!0,computeRightSingularVectors:o=!0,autoTranspose:a=!1}=e;let r,l=Boolean(i),m=Boolean(o),c=!1;if(n<s)if(a){r=t.transpose(),n=r.rows,s=r.columns,c=!0;let e=l;l=m,m=e}else r=t.clone(),console.warn("Computing SVD on a matrix with more columns than rows. Consider enabling autoTranspose");else r=t.clone();let u=Math.min(n,s),g=Math.min(n+1,s),C=new Float64Array(g),f=new Matrix(n,u),p=new Matrix(s,s),h=new Float64Array(s),d=new Float64Array(n),y=new Float64Array(g);for(let t=0;t<g;t++)y[t]=t;let H=Math.min(n-1,s),b=Math.max(0,Math.min(s-2,n)),v=Math.max(H,b);for(let t=0;t<v;t++){if(t<H){C[t]=0;for(let e=t;e<n;e++)C[t]=hypotenuse(C[t],r.get(e,t));if(0!==C[t]){r.get(t,t)<0&&(C[t]=-C[t]);for(let e=t;e<n;e++)r.set(e,t,r.get(e,t)/C[t]);r.set(t,t,r.get(t,t)+1)}C[t]=-C[t]}for(let e=t+1;e<s;e++){if(t<H&&0!==C[t]){let s=0;for(let i=t;i<n;i++)s+=r.get(i,t)*r.get(i,e);s=-s/r.get(t,t);for(let i=t;i<n;i++)r.set(i,e,r.get(i,e)+s*r.get(i,t))}h[e]=r.get(t,e)}if(l&&t<H)for(let e=t;e<n;e++)f.set(e,t,r.get(e,t));if(t<b){h[t]=0;for(let e=t+1;e<s;e++)h[t]=hypotenuse(h[t],h[e]);if(0!==h[t]){h[t+1]<0&&(h[t]=0-h[t]);for(let e=t+1;e<s;e++)h[e]/=h[t];h[t+1]+=1}if(h[t]=-h[t],t+1<n&&0!==h[t]){for(let e=t+1;e<n;e++)d[e]=0;for(let e=t+1;e<n;e++)for(let n=t+1;n<s;n++)d[e]+=h[n]*r.get(e,n);for(let e=t+1;e<s;e++){let s=-h[e]/h[t+1];for(let i=t+1;i<n;i++)r.set(i,e,r.get(i,e)+s*d[i])}}if(m)for(let e=t+1;e<s;e++)p.set(e,t,h[e])}}let w=Math.min(s,n+1);if(H<s&&(C[H]=r.get(H,H)),n<w&&(C[w-1]=0),b+1<w&&(h[b]=r.get(b,w-1)),h[w-1]=0,l){for(let t=H;t<u;t++){for(let e=0;e<n;e++)f.set(e,t,0);f.set(t,t,1)}for(let t=H-1;t>=0;t--)if(0!==C[t]){for(let e=t+1;e<u;e++){let s=0;for(let i=t;i<n;i++)s+=f.get(i,t)*f.get(i,e);s=-s/f.get(t,t);for(let i=t;i<n;i++)f.set(i,e,f.get(i,e)+s*f.get(i,t))}for(let e=t;e<n;e++)f.set(e,t,-f.get(e,t));f.set(t,t,1+f.get(t,t));for(let e=0;e<t-1;e++)f.set(e,t,0)}else{for(let e=0;e<n;e++)f.set(e,t,0);f.set(t,t,1)}}if(m)for(let t=s-1;t>=0;t--){if(t<b&&0!==h[t])for(let e=t+1;e<s;e++){let n=0;for(let i=t+1;i<s;i++)n+=p.get(i,t)*p.get(i,e);n=-n/p.get(t+1,t);for(let i=t+1;i<s;i++)p.set(i,e,p.get(i,e)+n*p.get(i,t))}for(let e=0;e<s;e++)p.set(e,t,0);p.set(t,t,1)}let x=w-1,O=Number.EPSILON;for(;w>0;){let t,e;for(t=w-2;t>=-1&&-1!==t;t--){const e=Number.MIN_VALUE+O*Math.abs(C[t]+Math.abs(C[t+1]));if(Math.abs(h[t])<=e||Number.isNaN(h[t])){h[t]=0;break}}if(t===w-2)e=4;else{let n;for(n=w-1;n>=t&&n!==t;n--){let e=(n!==w?Math.abs(h[n]):0)+(n!==t+1?Math.abs(h[n-1]):0);if(Math.abs(C[n])<=O*e){C[n]=0;break}}n===t?e=3:n===w-1?e=1:(e=2,t=n)}switch(t++,e){case 1:{let e=h[w-2];h[w-2]=0;for(let n=w-2;n>=t;n--){let i=hypotenuse(C[n],e),o=C[n]/i,a=e/i;if(C[n]=i,n!==t&&(e=-a*h[n-1],h[n-1]=o*h[n-1]),m)for(let t=0;t<s;t++)i=o*p.get(t,n)+a*p.get(t,w-1),p.set(t,w-1,-a*p.get(t,n)+o*p.get(t,w-1)),p.set(t,n,i)}break}case 2:{let e=h[t-1];h[t-1]=0;for(let s=t;s<w;s++){let i=hypotenuse(C[s],e),o=C[s]/i,a=e/i;if(C[s]=i,e=-a*h[s],h[s]=o*h[s],l)for(let e=0;e<n;e++)i=o*f.get(e,s)+a*f.get(e,t-1),f.set(e,t-1,-a*f.get(e,s)+o*f.get(e,t-1)),f.set(e,s,i)}break}case 3:{const e=Math.max(Math.abs(C[w-1]),Math.abs(C[w-2]),Math.abs(h[w-2]),Math.abs(C[t]),Math.abs(h[t])),i=C[w-1]/e,o=C[w-2]/e,a=h[w-2]/e,r=C[t]/e,c=h[t]/e,u=((o+i)*(o-i)+a*a)/2,g=i*a*(i*a);let d=0;0===u&&0===g||(d=u<0?0-Math.sqrt(u*u+g):Math.sqrt(u*u+g),d=g/(u+d));let y=(r+i)*(r-i)+d,H=r*c;for(let e=t;e<w-1;e++){let i=hypotenuse(y,H);0===i&&(i=Number.MIN_VALUE);let o=y/i,a=H/i;if(e!==t&&(h[e-1]=i),y=o*C[e]+a*h[e],h[e]=o*h[e]-a*C[e],H=a*C[e+1],C[e+1]=o*C[e+1],m)for(let t=0;t<s;t++)i=o*p.get(t,e)+a*p.get(t,e+1),p.set(t,e+1,-a*p.get(t,e)+o*p.get(t,e+1)),p.set(t,e,i);if(i=hypotenuse(y,H),0===i&&(i=Number.MIN_VALUE),o=y/i,a=H/i,C[e]=i,y=o*h[e]+a*C[e+1],C[e+1]=-a*h[e]+o*C[e+1],H=a*h[e+1],h[e+1]=o*h[e+1],l&&e<n-1)for(let t=0;t<n;t++)i=o*f.get(t,e)+a*f.get(t,e+1),f.set(t,e+1,-a*f.get(t,e)+o*f.get(t,e+1)),f.set(t,e,i)}h[w-2]=y;break}case 4:if(C[t]<=0&&(C[t]=C[t]<0?-C[t]:0,m))for(let e=0;e<=x;e++)p.set(e,t,-p.get(e,t));for(;t<x&&!(C[t]>=C[t+1]);){let e=C[t];if(C[t]=C[t+1],C[t+1]=e,m&&t<s-1)for(let n=0;n<s;n++)e=p.get(n,t+1),p.set(n,t+1,p.get(n,t)),p.set(n,t,e);if(l&&t<n-1)for(let s=0;s<n;s++)e=f.get(s,t+1),f.set(s,t+1,f.get(s,t)),f.set(s,t,e);t++}w--}}if(c){let t=p;p=f,f=t}this.m=n,this.n=s,this.s=C,this.U=f,this.V=p}solve(t){let e=t,n=this.threshold,s=this.s.length,i=Matrix.zeros(s,s);for(let t=0;t<s;t++)Math.abs(this.s[t])<=n?i.set(t,t,0):i.set(t,t,1/this.s[t]);let o=this.U,a=this.rightSingularVectors,r=a.mmul(i),l=a.rows,m=o.rows,c=Matrix.zeros(l,m);for(let t=0;t<l;t++)for(let e=0;e<m;e++){let n=0;for(let i=0;i<s;i++)n+=r.get(t,i)*o.get(e,i);c.set(t,e,n)}return c.mmul(e)}solveForDiagonal(t){return this.solve(Matrix.diag(t))}inverse(){let t=this.V,e=this.threshold,n=t.rows,s=t.columns,i=new Matrix(n,this.s.length);for(let o=0;o<n;o++)for(let n=0;n<s;n++)Math.abs(this.s[n])>e&&i.set(o,n,t.get(o,n)/this.s[n]);let o=this.U,a=o.rows,r=o.columns,l=new Matrix(n,a);for(let t=0;t<n;t++)for(let e=0;e<a;e++){let n=0;for(let s=0;s<r;s++)n+=i.get(t,s)*o.get(e,s);l.set(t,e,n)}return l}get condition(){return this.s[0]/this.s[Math.min(this.m,this.n)-1]}get norm2(){return this.s[0]}get rank(){let t=Math.max(this.m,this.n)*this.s[0]*Number.EPSILON,e=0,n=this.s;for(let s=0,i=n.length;s<i;s++)n[s]>t&&e++;return e}get diagonal(){return Array.from(this.s)}get threshold(){return Number.EPSILON/2*Math.max(this.m,this.n)*this.s[0]}get leftSingularVectors(){return this.U}get rightSingularVectors(){return this.V}get diagonalMatrix(){return Matrix.diag(this.s)}}function inverse(t,e=!1){return t=WrapperMatrix2D.checkMatrix(t),e?new SingularValueDecomposition(t).inverse():solve(t,Matrix.eye(t.rows))}function solve(t,e,n=!1){return t=WrapperMatrix2D.checkMatrix(t),e=WrapperMatrix2D.checkMatrix(e),n?new SingularValueDecomposition(t).solve(e):t.isSquare()?new LuDecomposition(t).solve(e):new QrDecomposition(t).solve(e)}class EigenvalueDecomposition{constructor(t,e={}){const{assumeSymmetric:n=!1}=e;if(!(t=WrapperMatrix2D.checkMatrix(t)).isSquare())throw new Error("Matrix is not a square matrix");if(t.isEmpty())throw new Error("Matrix must be non-empty");let s,i,o=t.columns,a=new Matrix(o,o),r=new Float64Array(o),l=new Float64Array(o),m=t,c=!1;if(c=!!n||t.isSymmetric(),c){for(s=0;s<o;s++)for(i=0;i<o;i++)a.set(s,i,m.get(s,i));tred2(o,l,r,a),tql2(o,l,r,a)}else{let t=new Matrix(o,o),e=new Float64Array(o);for(i=0;i<o;i++)for(s=0;s<o;s++)t.set(s,i,m.get(s,i));orthes(o,t,e,a),hqr2(o,l,r,a,t)}this.n=o,this.e=l,this.d=r,this.V=a}get realEigenvalues(){return Array.from(this.d)}get imaginaryEigenvalues(){return Array.from(this.e)}get eigenvectorMatrix(){return this.V}get diagonalMatrix(){let t,e,n=this.n,s=this.e,i=this.d,o=new Matrix(n,n);for(t=0;t<n;t++){for(e=0;e<n;e++)o.set(t,e,0);o.set(t,t,i[t]),s[t]>0?o.set(t,t+1,s[t]):s[t]<0&&o.set(t,t-1,s[t])}return o}}function tred2(t,e,n,s){let i,o,a,r,l,m,c,u;for(l=0;l<t;l++)n[l]=s.get(t-1,l);for(r=t-1;r>0;r--){for(u=0,a=0,m=0;m<r;m++)u+=Math.abs(n[m]);if(0===u)for(e[r]=n[r-1],l=0;l<r;l++)n[l]=s.get(r-1,l),s.set(r,l,0),s.set(l,r,0);else{for(m=0;m<r;m++)n[m]/=u,a+=n[m]*n[m];for(i=n[r-1],o=Math.sqrt(a),i>0&&(o=-o),e[r]=u*o,a-=i*o,n[r-1]=i-o,l=0;l<r;l++)e[l]=0;for(l=0;l<r;l++){for(i=n[l],s.set(l,r,i),o=e[l]+s.get(l,l)*i,m=l+1;m<=r-1;m++)o+=s.get(m,l)*n[m],e[m]+=s.get(m,l)*i;e[l]=o}for(i=0,l=0;l<r;l++)e[l]/=a,i+=e[l]*n[l];for(c=i/(a+a),l=0;l<r;l++)e[l]-=c*n[l];for(l=0;l<r;l++){for(i=n[l],o=e[l],m=l;m<=r-1;m++)s.set(m,l,s.get(m,l)-(i*e[m]+o*n[m]));n[l]=s.get(r-1,l),s.set(r,l,0)}}n[r]=a}for(r=0;r<t-1;r++){if(s.set(t-1,r,s.get(r,r)),s.set(r,r,1),a=n[r+1],0!==a){for(m=0;m<=r;m++)n[m]=s.get(m,r+1)/a;for(l=0;l<=r;l++){for(o=0,m=0;m<=r;m++)o+=s.get(m,r+1)*s.get(m,l);for(m=0;m<=r;m++)s.set(m,l,s.get(m,l)-o*n[m])}}for(m=0;m<=r;m++)s.set(m,r+1,0)}for(l=0;l<t;l++)n[l]=s.get(t-1,l),s.set(t-1,l,0);s.set(t-1,t-1,1),e[0]=0}function tql2(t,e,n,s){let i,o,a,r,l,m,c,u,g,C,f,p,h,d,y,H;for(a=1;a<t;a++)e[a-1]=e[a];e[t-1]=0;let b=0,v=0,w=Number.EPSILON;for(m=0;m<t;m++){for(v=Math.max(v,Math.abs(n[m])+Math.abs(e[m])),c=m;c<t&&!(Math.abs(e[c])<=w*v);)c++;if(c>m)do{for(i=n[m],u=(n[m+1]-i)/(2*e[m]),g=hypotenuse(u,1),u<0&&(g=-g),n[m]=e[m]/(u+g),n[m+1]=e[m]*(u+g),C=n[m+1],o=i-n[m],a=m+2;a<t;a++)n[a]-=o;for(b+=o,u=n[c],f=1,p=f,h=f,d=e[m+1],y=0,H=0,a=c-1;a>=m;a--)for(h=p,p=f,H=y,i=f*e[a],o=f*u,g=hypotenuse(u,e[a]),e[a+1]=y*g,y=e[a]/g,f=u/g,u=f*n[a]-y*i,n[a+1]=o+y*(f*i+y*n[a]),l=0;l<t;l++)o=s.get(l,a+1),s.set(l,a+1,y*s.get(l,a)+f*o),s.set(l,a,f*s.get(l,a)-y*o);u=-y*H*h*d*e[m]/C,e[m]=y*u,n[m]=f*u}while(Math.abs(e[m])>w*v);n[m]=n[m]+b,e[m]=0}for(a=0;a<t-1;a++){for(l=a,u=n[a],r=a+1;r<t;r++)n[r]<u&&(l=r,u=n[r]);if(l!==a)for(n[l]=n[a],n[a]=u,r=0;r<t;r++)u=s.get(r,a),s.set(r,a,s.get(r,l)),s.set(r,l,u)}}function orthes(t,e,n,s){let i,o,a,r,l,m,c,u=t-1;for(m=1;m<=u-1;m++){for(c=0,r=m;r<=u;r++)c+=Math.abs(e.get(r,m-1));if(0!==c){for(a=0,r=u;r>=m;r--)n[r]=e.get(r,m-1)/c,a+=n[r]*n[r];for(o=Math.sqrt(a),n[m]>0&&(o=-o),a-=n[m]*o,n[m]=n[m]-o,l=m;l<t;l++){for(i=0,r=u;r>=m;r--)i+=n[r]*e.get(r,l);for(i/=a,r=m;r<=u;r++)e.set(r,l,e.get(r,l)-i*n[r])}for(r=0;r<=u;r++){for(i=0,l=u;l>=m;l--)i+=n[l]*e.get(r,l);for(i/=a,l=m;l<=u;l++)e.set(r,l,e.get(r,l)-i*n[l])}n[m]=c*n[m],e.set(m,m-1,c*o)}}for(r=0;r<t;r++)for(l=0;l<t;l++)s.set(r,l,r===l?1:0);for(m=u-1;m>=1;m--)if(0!==e.get(m,m-1)){for(r=m+1;r<=u;r++)n[r]=e.get(r,m-1);for(l=m;l<=u;l++){for(o=0,r=m;r<=u;r++)o+=n[r]*s.get(r,l);for(o=o/n[m]/e.get(m,m-1),r=m;r<=u;r++)s.set(r,l,s.get(r,l)+o*n[r])}}}function hqr2(t,e,n,s,i){let o,a,r,l,m,c,u,g,C,f,p,h,d,y,H,b=t-1,v=t-1,w=Number.EPSILON,x=0,O=0,D=0,A=0,S=0,M=0,$=0,j=0;for(o=0;o<t;o++)for((o<0||o>v)&&(n[o]=i.get(o,o),e[o]=0),a=Math.max(o-1,0);a<t;a++)O+=Math.abs(i.get(o,a));for(;b>=0;){for(l=b;l>0&&(M=Math.abs(i.get(l-1,l-1))+Math.abs(i.get(l,l)),0===M&&(M=O),!(Math.abs(i.get(l,l-1))<w*M));)l--;if(l===b)i.set(b,b,i.get(b,b)+x),n[b]=i.get(b,b),e[b]=0,b--,j=0;else if(l===b-1){if(u=i.get(b,b-1)*i.get(b-1,b),D=(i.get(b-1,b-1)-i.get(b,b))/2,A=D*D+u,$=Math.sqrt(Math.abs(A)),i.set(b,b,i.get(b,b)+x),i.set(b-1,b-1,i.get(b-1,b-1)+x),g=i.get(b,b),A>=0){for($=D>=0?D+$:D-$,n[b-1]=g+$,n[b]=n[b-1],0!==$&&(n[b]=g-u/$),e[b-1]=0,e[b]=0,g=i.get(b,b-1),M=Math.abs(g)+Math.abs($),D=g/M,A=$/M,S=Math.sqrt(D*D+A*A),D/=S,A/=S,a=b-1;a<t;a++)$=i.get(b-1,a),i.set(b-1,a,A*$+D*i.get(b,a)),i.set(b,a,A*i.get(b,a)-D*$);for(o=0;o<=b;o++)$=i.get(o,b-1),i.set(o,b-1,A*$+D*i.get(o,b)),i.set(o,b,A*i.get(o,b)-D*$);for(o=0;o<=v;o++)$=s.get(o,b-1),s.set(o,b-1,A*$+D*s.get(o,b)),s.set(o,b,A*s.get(o,b)-D*$)}else n[b-1]=g+D,n[b]=g+D,e[b-1]=$,e[b]=-$;b-=2,j=0}else{if(g=i.get(b,b),C=0,u=0,l<b&&(C=i.get(b-1,b-1),u=i.get(b,b-1)*i.get(b-1,b)),10===j){for(x+=g,o=0;o<=b;o++)i.set(o,o,i.get(o,o)-g);M=Math.abs(i.get(b,b-1))+Math.abs(i.get(b-1,b-2)),g=C=.75*M,u=-.4375*M*M}if(30===j&&(M=(C-g)/2,M=M*M+u,M>0)){for(M=Math.sqrt(M),C<g&&(M=-M),M=g-u/((C-g)/2+M),o=0;o<=b;o++)i.set(o,o,i.get(o,o)-M);x+=M,g=C=u=.964}for(j+=1,m=b-2;m>=l&&($=i.get(m,m),S=g-$,M=C-$,D=(S*M-u)/i.get(m+1,m)+i.get(m,m+1),A=i.get(m+1,m+1)-$-S-M,S=i.get(m+2,m+1),M=Math.abs(D)+Math.abs(A)+Math.abs(S),D/=M,A/=M,S/=M,m!==l)&&!(Math.abs(i.get(m,m-1))*(Math.abs(A)+Math.abs(S))<w*(Math.abs(D)*(Math.abs(i.get(m-1,m-1))+Math.abs($)+Math.abs(i.get(m+1,m+1)))));)m--;for(o=m+2;o<=b;o++)i.set(o,o-2,0),o>m+2&&i.set(o,o-3,0);for(r=m;r<=b-1&&(y=r!==b-1,r!==m&&(D=i.get(r,r-1),A=i.get(r+1,r-1),S=y?i.get(r+2,r-1):0,g=Math.abs(D)+Math.abs(A)+Math.abs(S),0!==g&&(D/=g,A/=g,S/=g)),0!==g);r++)if(M=Math.sqrt(D*D+A*A+S*S),D<0&&(M=-M),0!==M){for(r!==m?i.set(r,r-1,-M*g):l!==m&&i.set(r,r-1,-i.get(r,r-1)),D+=M,g=D/M,C=A/M,$=S/M,A/=D,S/=D,a=r;a<t;a++)D=i.get(r,a)+A*i.get(r+1,a),y&&(D+=S*i.get(r+2,a),i.set(r+2,a,i.get(r+2,a)-D*$)),i.set(r,a,i.get(r,a)-D*g),i.set(r+1,a,i.get(r+1,a)-D*C);for(o=0;o<=Math.min(b,r+3);o++)D=g*i.get(o,r)+C*i.get(o,r+1),y&&(D+=$*i.get(o,r+2),i.set(o,r+2,i.get(o,r+2)-D*S)),i.set(o,r,i.get(o,r)-D),i.set(o,r+1,i.get(o,r+1)-D*A);for(o=0;o<=v;o++)D=g*s.get(o,r)+C*s.get(o,r+1),y&&(D+=$*s.get(o,r+2),s.set(o,r+2,s.get(o,r+2)-D*S)),s.set(o,r,s.get(o,r)-D),s.set(o,r+1,s.get(o,r+1)-D*A)}}}if(0!==O){for(b=t-1;b>=0;b--)if(D=n[b],A=e[b],0===A)for(l=b,i.set(b,b,1),o=b-1;o>=0;o--){for(u=i.get(o,o)-D,S=0,a=l;a<=b;a++)S+=i.get(o,a)*i.get(a,b);if(e[o]<0)$=u,M=S;else if(l=o,0===e[o]?i.set(o,b,0!==u?-S/u:-S/(w*O)):(g=i.get(o,o+1),C=i.get(o+1,o),A=(n[o]-D)*(n[o]-D)+e[o]*e[o],c=(g*M-$*S)/A,i.set(o,b,c),i.set(o+1,b,Math.abs(g)>Math.abs($)?(-S-u*c)/g:(-M-C*c)/$)),c=Math.abs(i.get(o,b)),w*c*c>1)for(a=o;a<=b;a++)i.set(a,b,i.get(a,b)/c)}else if(A<0)for(l=b-1,Math.abs(i.get(b,b-1))>Math.abs(i.get(b-1,b))?(i.set(b-1,b-1,A/i.get(b,b-1)),i.set(b-1,b,-(i.get(b,b)-D)/i.get(b,b-1))):(H=cdiv(0,-i.get(b-1,b),i.get(b-1,b-1)-D,A),i.set(b-1,b-1,H[0]),i.set(b-1,b,H[1])),i.set(b,b-1,0),i.set(b,b,1),o=b-2;o>=0;o--){for(f=0,p=0,a=l;a<=b;a++)f+=i.get(o,a)*i.get(a,b-1),p+=i.get(o,a)*i.get(a,b);if(u=i.get(o,o)-D,e[o]<0)$=u,S=f,M=p;else if(l=o,0===e[o]?(H=cdiv(-f,-p,u,A),i.set(o,b-1,H[0]),i.set(o,b,H[1])):(g=i.get(o,o+1),C=i.get(o+1,o),h=(n[o]-D)*(n[o]-D)+e[o]*e[o]-A*A,d=2*(n[o]-D)*A,0===h&&0===d&&(h=w*O*(Math.abs(u)+Math.abs(A)+Math.abs(g)+Math.abs(C)+Math.abs($))),H=cdiv(g*S-$*f+A*p,g*M-$*p-A*f,h,d),i.set(o,b-1,H[0]),i.set(o,b,H[1]),Math.abs(g)>Math.abs($)+Math.abs(A)?(i.set(o+1,b-1,(-f-u*i.get(o,b-1)+A*i.get(o,b))/g),i.set(o+1,b,(-p-u*i.get(o,b)-A*i.get(o,b-1))/g)):(H=cdiv(-S-C*i.get(o,b-1),-M-C*i.get(o,b),$,A),i.set(o+1,b-1,H[0]),i.set(o+1,b,H[1]))),c=Math.max(Math.abs(i.get(o,b-1)),Math.abs(i.get(o,b))),w*c*c>1)for(a=o;a<=b;a++)i.set(a,b-1,i.get(a,b-1)/c),i.set(a,b,i.get(a,b)/c)}for(o=0;o<t;o++)if(o<0||o>v)for(a=o;a<t;a++)s.set(o,a,i.get(o,a));for(a=t-1;a>=0;a--)for(o=0;o<=v;o++){for($=0,r=0;r<=Math.min(a,v);r++)$+=s.get(o,r)*i.get(r,a);s.set(o,a,$)}}}function cdiv(t,e,n,s){let i,o;return Math.abs(n)>Math.abs(s)?(i=s/n,o=n+i*s,[(t+i*e)/o,(e-i*t)/o]):(i=n/s,o=s+i*n,[(i*t+e)/o,(i*e-t)/o])}function xEnsureFloat64(t){return xCheck(t),t instanceof Float64Array?t.slice(0):Float64Array.from(t)}function xFindClosestIndex(t,e,n={}){const{sorted:s=!0}=n;if(s){let n=0,s=t.length-1,i=0;for(;s-n>1;)if(i=n+(s-n>>1),t[i]<e)n=i;else{if(!(t[i]>e))return i;s=i}return n<t.length-1?Math.abs(e-t[n])<Math.abs(t[n+1]-e)?n:n+1:n}{let n=0,s=Number.POSITIVE_INFINITY;for(let i=0;i<t.length;i++){const o=Math.abs(t[i]-e);o<s&&(s=o,n=i)}return n}}function xGetFromToIndex(t,e={}){let{fromIndex:n,toIndex:s,from:i,to:o}=e;return void 0===n&&(n=void 0!==i?xFindClosestIndex(t,i):0),void 0===s&&(s=void 0!==o?xFindClosestIndex(t,o):t.length-1),n<0&&(n=0),s<0&&(s=0),n>=t.length&&(n=t.length-1),s>=t.length&&(s=t.length-1),n>s&&([n,s]=[s,n]),{fromIndex:n,toIndex:s}}function xMaxValue(t,e={}){xCheck(t);const{fromIndex:n,toIndex:s}=xGetFromToIndex(t,e);let i=t[n];for(let e=n+1;e<=s;e++)t[e]>i&&(i=t[e]);return i}function xMinValue(t,e={}){xCheck(t);const{fromIndex:n,toIndex:s}=xGetFromToIndex(t,e);let i=t[n];for(let e=n+1;e<=s;e++)t[e]<i&&(i=t[e]);return i}function xIsEquallySpaced(t,e={}){if(t.length<3)return!0;const{tolerance:n=.05}=e;let s=0,i=Number.MAX_SAFE_INTEGER;for(let e=0;e<t.length-1;++e){let n=t[e+1]-t[e];n<i&&(i=n),n>s&&(s=n)}return(s-i)/s<n}function xIsMonotonic(t){if(t.length<=2)return 1;if(t[0]===t[1]){for(let e=1;e<t.length-1;e++)if(t[e]!==t[e+1])return 0;return 1}if(t[0]<t[t.length-1]){for(let e=0;e<t.length-1;e++)if(t[e]>=t[e+1])return 0;return 1}for(let e=0;e<t.length-1;e++)if(t[e]<=t[e+1])return 0;return-1}function xMean(t,e={}){xCheck(t);const{fromIndex:n,toIndex:s}=xGetFromToIndex(t,e);let i=t[n];for(let e=n+1;e<=s;e++)i+=t[e];return i/(s-n+1)}function xMedianAbsoluteDeviation(t){const e=xMedian(t),n=new Float64Array(t.length);for(let s=0;s<t.length;s++)n[s]=Math.abs(t[s]-e);return{median:e,mad:xMedian(n)}}function xMinMaxValues(t){xCheck(t);let e=t[0],n=t[0];for(let s of t)s<e&&(e=s),s>n&&(n=s);return{min:e,max:n}}function xNoiseStandardDeviation(t){const{mad:e,median:n}=xMedianAbsoluteDeviation(t);return{sd:e/.6744897501960817,mad:e,median:n}}function xNorm(t){let e=0;for(const n of t)e+=n**2;return Math.sqrt(e)}function xSum(t,e={}){xCheck(t);const{fromIndex:n,toIndex:s}=xGetFromToIndex(t,e);let i=t[n];for(let e=n+1;e<=s;e++)i+=t[e];return i}function xNormed(t,e={}){const{algorithm:n="absolute",value:s=1}=e;xCheck(t);const i=getOutputArray(e.output,t.length);if(0===t.length)throw new Error("input must not be empty");switch(n.toLowerCase()){case"absolute":{let e=absoluteSum(t)/s;if(0===e)throw new Error("xNormed: trying to divide by 0");for(let n=0;n<t.length;n++)i[n]=t[n]/e;return i}case"max":{let e=xMaxValue(t);if(0===e)throw new Error("xNormed: trying to divide by 0");const n=s/e;for(let e=0;e<t.length;e++)i[e]=t[e]*n;return i}case"sum":{let e=xSum(t)/s;if(0===e)throw new Error("xNormed: trying to divide by 0");for(let n=0;n<t.length;n++)i[n]=t[n]/e;return i}default:throw new Error(`norm: unknown algorithm: ${n}`)}}function absoluteSum(t){let e=0;for(let n=0;n<t.length;n++)e+=Math.abs(t[n]);return e}function xPadding(t,e={}){const{size:n=0,value:s=0,algorithm:i=""}=e;if(xCheck(t),!i)return t instanceof Float64Array?t.slice():Float64Array.from(t);let o=new Float64Array(t.length+2*n);for(let e=0;e<t.length;e++)o[e+n]=t[e];let a=n+t.length,r=2*n+t.length;switch(i.toLowerCase()){case"value":for(let t=0;t<n;t++)o[t]=s;for(let t=a;t<r;t++)o[t]=s;break;case"duplicate":for(let e=0;e<n;e++)o[e]=t[0];for(let e=a;e<r;e++)o[e]=t[t.length-1];break;case"circular":for(let e=0;e<n;e++)o[e]=t[(t.length-n%t.length+e)%t.length];for(let e=0;e<n;e++)o[e+a]=t[e%t.length];break;default:throw new Error("xPadding: unknown algorithm")}return o}function xVariance(t,e={}){if(!isAnyArray(t))throw new TypeError("input must be an array");const{unbiased:n=!0,mean:s=xMean(t)}=e;let i=0;for(let e=0;e<t.length;e++){let n=t[e]-s;i+=n*n}return n?i/(t.length-1):i/t.length}function xStandardDeviation(t,e={}){return Math.sqrt(xVariance(t,e))}function xParetoNormalization(t){xCheck(t);let e=[];const n=Math.sqrt(xStandardDeviation(t));for(let s of t)e.push(s/n);return e}function xRescale(t,e={}){xCheck(t);const n=getOutputArray(e.output,t.length),s=xMinValue(t),i=xMaxValue(t);if(s===i)throw new RangeError("minimum and maximum input values are equal. Cannot rescale a constant array");const{min:o=0,max:a=1}=e;if(o>=a)throw new RangeError("min option must be smaller than max option");const r=(a-o)/(i-s);for(let e=0;e<t.length;e++)n[e]=(t[e]-s)*r+o;return n}function xRolling(t,e,n={}){if(xCheck(t),"function"!=typeof e)throw new Error("fct has to be a function");const{window:s=5,padding:i={}}=n,{size:o=s-1,algorithm:a,value:r}=i;t=xPadding(t,{size:o,algorithm:a,value:r});const l=[];for(let n=0;n<t.length-s+1;n++)l.push(e(t.subarray(n,n+s)));return l}function xRollingAverage(t,e={}){return xRolling(t,xMean,e)}function xRollingMedian(t,e={}){return xRolling(t,xMedian,e)}function xSequentialFill(t=[],e={}){if("object"!=typeof t||isAnyArray(t)||(e=t,t=[]),!isAnyArray(t))throw new TypeError("input must be an array");let{from:n=0,to:s=10,size:i=(Array.isArray(t)||t.constructor===Float64Array||t.constructor===Uint16Array?t.length:0),step:o=null}=e;if(i||(i=o?Math.floor((s-n)/o)+1:s-n+1),!o&&i&&(o=(s-n)/(i-1)),Array.isArray(t)){t.length=0;for(let e=0;e<i;e++)t.push(n),o&&(n+=o)}else{if(Array.isArray(t)||t.constructor===Float64Array||t.constructor===Uint16Array&&t.length!==i)throw new Error("sequentialFill typed array must have the correct length");for(let e=0;e<i;e++)(Array.isArray(t)||t.constructor===Float64Array||t.constructor===Uint16Array)&&(t[e]=n),o&&(n+=o)}return Array.isArray(t)||t.constructor===Float64Array||t.constructor===Uint16Array?Array.from(t):[]}function xSubtract(t,e){let n=!1,s=0;if(isAnyArray(e)){if(t.length!==e.length)throw new Error("xSubtract: size of array1 and array2 must be identical")}else n=!0,s=Number(e);let i=new Float64Array(t.length);if(n)for(let e=0;e<t.length;e++)i[e]=t[e]-s;else for(let n=0;n<t.length;n++)i[n]=t[n]-e[n];return i}function xyCheck(t,e={}){const{minLength:n}=e;if("object"!=typeof t||!isAnyArray(t.x)||!isAnyArray(t.y))throw new Error("Data must be an object of x and y arrays");if(t.x.length!==t.y.length)throw new Error("The x and y arrays must have the same length");if(n&&t.x.length<n)throw new Error(`data.x must have a length of at least ${n}`)}function xyFindClosestPoint(t,e){const{x:n,y:s}=t,i=xFindClosestIndex(n,e);return{x:n[i],y:s[i]}}function xyEnsureGrowingX(t){if(xyCheck(t),1===xIsMonotonic(t.x))return t;const e=Array.from(t.x),n=Array.from(t.y);let s=Number.NEGATIVE_INFINITY,i=0;for(let t=0;t<e.length;t++)s<e[t]&&(i<t&&(e[i]=e[t],n[i]=n[t]),i++,s=e[t]);return e.length=i,n.length=i,{x:e,y:n}}function zonesNormalize(t=[],e={}){let{from:n=Number.NEGATIVE_INFINITY,to:s=Number.POSITIVE_INFINITY,exclusions:i=[]}=e;n>s&&([n,s]=[s,n]),0===(t=(t=JSON.parse(JSON.stringify(t)).map((t=>t.from>t.to?{from:t.to,to:t.from}:t))).sort(((t,e)=>t.from!==e.from?t.from-e.from:t.to-e.to))).length&&t.push({from:n,to:s});for(const e of t)n>e.from&&(e.from=n),s<e.to&&(e.to=s);if(0===(t=t.filter((t=>t.from<=t.to))).length)return[];let o=t[0],a=[o];for(let e=1;e<t.length;e++){let n=t[e];n.from<=o.to?o.to<n.to&&(o.to=n.to):(o=n,a.push(o))}if(0===i.length)return a;const r=zonesNormalize(i);let l=0;const m=[];let c=0;for(let t=0;t<a.length&&!(c++>5);t++){const e=a[t];if(l!==r.length){for(;l<r.length&&r[l].to<=e.from;)l++;if(l!==r.length)if(e.to<r[l].from)m.push(e);else{if(r[l].to>=e.to){if(r[l].from<=e.from)continue;m.push({from:r[l].to,to:e.to})}r[l].from>e.from&&m.push({from:e.from,to:r[l].from}),e.from=r[l].to,t--}else m.push(e)}else m.push(e)}return m}function zonesWithPoints(t=[],e=10,n={}){if(0===t.length)return t;let s=zonesNormalize(t,n);let i=s.reduce(((t,e)=>t+(e.to-e.from)),0)/e,o=0;for(let t=0;t<s.length-1;t++){let n=s[t];n.numberOfPoints=Math.min(Math.round((n.to-n.from)/i),e-o),o+=n.numberOfPoints}return s[s.length-1].numberOfPoints=e-o,s}function equallySpacedSlot(t,e,n,s,i){let o=t.length,a=(s-n)/(i>1?i-1:1),r=a/2,l=t[t.length-1]-t[t.length-2],m=n-r,c=new Float64Array(i),u=m,g=m+a,C=-Number.MAX_VALUE,f=0,p=t[0],h=e[0],d=0,y=!0,H=0,b=0,v=1,w=0;t:for(;;){if(C>=p)throw new Error("x must be a growing series");for(;C-g>0;){if(y&&(b++,y=!1),c[w]=b<=0?0:H/b,w++,w===i)break t;u=g,g+=a,H=0,b=0}C>u&&(H+=f,b++),(C===-Number.MAX_VALUE||d>1)&&b--,C=p,f=h,v<o?(p=t[v],h=e[v],v++):(p+=l,h=0,d++)}return c}function integral(t,e,n,s){return.5*n*e*e+s*e-(.5*n*t*t+s*t)}function equallySpacedSmooth(t,e,n,s,i){let o=t.length,a=(s-n)/(i>1?i-1:1),r=a/2,l=new Float64Array(i),m=t[1]-t[0],c=t[o-1]-t[o-2],u=n-r,g=n+r,C=Number.MIN_SAFE_INTEGER,f=0,p=t[0]-m,h=0,d=0,y=0,H=0,b=0,v=0,w=0,x=0,O=0;t:for(;;){if(C>=p)throw new Error("x must be a growing series");for(C<=u&&u<=p&&(O=integral(0,u-C,y,f),b=d+O);p-g>=0;){if(O=integral(0,g-C,y,f),v=d+O,l[x++]=(v-b)/a,x===i)break t;u=g,g+=a,b=v}d+=integral(C,p,y,H),C=p,f=h,w<o?(p=t[w],h=e[w],w++):w===o&&(p+=c,h=0),y=getSlope(C,f,p,h),H=-y*C+f}return l}function getSlope(t,e,n,s){return(s-e)/(n-t)}function xyEquallySpaced(t,e={}){let{x:n,y:s}=t,i=n.length;const{from:o=n[0],to:a=n[i-1],variant:r="smooth",numberOfPoints:l=100,exclusions:m=[],zones:c=[{from:o,to:a}]}=e;if(o>a)throw new RangeError("from should be larger than to");if(xyCheck(t),l<2)throw new RangeError("'numberOfPoints' option must be greater than 1");const u=zonesWithPoints(zonesNormalize(c,{from:o,to:a,exclusions:m}),l,{from:o,to:a});let g=[],C=[];for(let t of u){t.numberOfPoints||(t.numberOfPoints=0);let e=processZone(Array.from(n),Array.from(s),t.from,t.to,t.numberOfPoints,r);g=g.concat(e.x),C=C.concat(e.y)}return{x:g,y:C}}function processZone(t,e,n,s,i,o){if(i<1)throw new RangeError("the number of points must be at least 1");let a="slot"===o?Array.from(equallySpacedSlot(t,e,n,s,i)):Array.from(equallySpacedSmooth(t,e,n,s,i));return{x:Array.from(createFromToArray({from:n,to:s,length:i})),y:a}}function xyExtract(t,e={}){xyCheck(t);const{x:n,y:s}=t;let{zones:i}=e;if(i=zonesNormalize(i),void 0===n||void 0===s||!Array.isArray(i)||0===i.length)return t;let o=[],a=[],r=i[0],l=0;t:for(let t=0;t<n.length;t++){for(;r.to<n[t];)if(l++,r=i[l],!r){t=n.length;break t}n[t]>=r.from&&(o.push(n[t]),a.push(s[t]))}return{x:o,y:a}}function xyFilterX(t,e={}){const{x:n,y:s}=t,{from:i=n[0],to:o=n[n.length-1],zones:a=[{from:i,to:o}],exclusions:r=[]}=e;let l=zonesNormalize(a,{from:i,to:o,exclusions:r}),m=0,c=[],u=[],g=0;for(;g<n.length;){if(n[g]<=l[m].to&&n[g]>=l[m].from)c.push(n[g]),u.push(s[g]);else if(n[g]>l[m].to&&(m++,!l[m]))break;g++}return{x:c,y:u}}function xyIntegration(t,e={}){xyCheck(t,{minLength:1});const{x:n,y:s}=t;if(1===n.length)return 0;const{fromIndex:i,toIndex:o}=xGetFromToIndex(n,e);let a=0;for(let t=i;t<o;t++)a+=(n[t+1]-n[t])*(s[t+1]+s[t])/2;return a}function xySetYValue(t,e={}){xyCheck(t);const{x:n,y:s}=t;let{zones:i,value:o=0}=e;if(!Array.isArray(i)||0===i.length)return t;i=zonesNormalize(i);const a=n.slice(),r=s.slice();let l=i[0],m=0;t:for(let t=0;t<n.length;t++){for(;l.to<n[t];)if(m++,l=i[m],!l){t=n.length;break t}n[t]>=l.from&&(r[t]=o)}return{x:a,y:r}}function matrixCheck(t){if(0===t.length||0===t[0].length)throw new RangeError("matrix should contain data");const e=t[0].length;for(let n=1;n<t.length;n++)if(t[n].length!==e)throw new RangeError("All rows should has the same length")}function matrixMinMaxZ(t){matrixCheck(t);const e=t.length,n=t[0].length;let s=t[0][0],i=t[0][0];for(let o=0;o<n;o++)for(let n=0;n<e;n++)t[n][o]<s&&(s=t[n][o]),t[n][o]>i&&(i=t[n][o]);return{min:s,max:i}}const LOOP=8,FLOAT_MUL=1/16777216,sh1=15,sh2=18,sh3=11;function multiply_uint32(t,e){const n=65535&(t>>>=0);return((t-n)*(e>>>=0)>>>0)+n*e>>>0}class XSadd{constructor(t=Date.now()){this.state=new Uint32Array(4),this.init(t),this.random=this.getFloat.bind(this)}getUint32(){return this.nextState(),this.state[3]+this.state[2]>>>0}getFloat(){return(this.getUint32()>>>8)*FLOAT_MUL}init(t){if(!Number.isInteger(t))throw new TypeError("seed must be an integer");this.state[0]=t,this.state[1]=0,this.state[2]=0,this.state[3]=0;for(let t=1;t<LOOP;t++)this.state[3&t]^=t+multiply_uint32(1812433253,this.state[t-1&3]^this.state[t-1&3]>>>30>>>0)>>>0;this.periodCertification();for(let t=0;t<LOOP;t++)this.nextState()}periodCertification(){0===this.state[0]&&0===this.state[1]&&0===this.state[2]&&0===this.state[3]&&(this.state[0]=88,this.state[1]=83,this.state[2]=65,this.state[3]=68)}nextState(){let t=this.state[0];t^=t<<sh1,t^=t>>>sh2,t^=this.state[3]<<sh3,this.state[0]=this.state[1],this.state[1]=this.state[2],this.state[2]=this.state[3],this.state[3]=t}}let spare,hasSpare=!1;function createRandomArray(t={}){const{mean:e=0,standardDeviation:n=1,length:s=1e3,range:i=1,seed:o,distribution:a="normal"}=t,r=new XSadd(o);let l=new Float64Array(s);switch(a){case"normal":for(let t=0;t<s;t++)l[t]=generateGaussian(e,n,r);break;case"uniform":for(let t=0;t<s;t++)l[t]=(r.random()-.5)*i+e;break;default:throw new Error(`unknown distribution: ${a}`)}return l}function generateGaussian(t,e,n){let s,i,o,a;if(hasSpare)hasSpare=!1,s=spare*e+t;else{do{i=2*n.random()-1,o=2*n.random()-1,a=i*i+o*o}while(a>=1||0===a);a=Math.sqrt(-2*Math.log(a)/a),spare=o*a,hasSpare=!0,s=t+e*i*a}return s}function addNoise(t,e={}){const{seed:n=0,distribution:s="normal",percent:i=1}=e,o=xMaxValue(t.y)*i/100,a=createRandomArray({distribution:s,seed:n,mean:0,standardDeviation:o,range:o,length:t.x.length});return t.y=xAdd(t.y,a),t}class SpectrumGenerator{constructor(t={}){const{from:e=0,to:n=1e3,nbPoints:s=10001,peakWidthFct:i,shape:o={kind:"gaussian",fwhm:5}}=t;this.from=e,this.to=n,this.nbPoints=s,this.interval=(this.to-this.from)/(this.nbPoints-1),this.peakWidthFct=i,this.maxPeakHeight=Number.MIN_SAFE_INTEGER,this.data={x:new Float64Array(this.nbPoints),y:new Float64Array(this.nbPoints)};let a=getShape1D(o);if(this.shape=a,assertNumber$2(this.from,"from"),assertNumber$2(this.to,"to"),assertInteger$1(this.nbPoints,"nbPoints"),this.to<=this.from)throw new RangeError("to option must be larger than from");if(this.peakWidthFct&&"function"!=typeof this.peakWidthFct)throw new TypeError("peakWidthFct option must be a function");this.reset()}addPeaks(t,e){if(!(Array.isArray(t)||"object"==typeof t&&void 0!==t.x&&void 0!==t.y&&Array.isArray(t.x)&&Array.isArray(t.y)&&t.x.length===t.y.length))throw new TypeError("peaks must be an array or an object containing x[] and y[]");if(Array.isArray(t))for(const n of t)this.addPeak(n,e);else for(let n=0;n<t.x.length;n++)this.addPeak([t.x[n],t.y[n]],e)}addPeak(t,e={}){if(Array.isArray(t)&&t.length<2)throw new Error("peak must be an array with two (or three) values or an object with {x,y,width?}");if(!Array.isArray(t)&&(void 0===t.x||void 0===t.y))throw new Error("peak must be an array with two (or three) values or an object with {x,y,width?}");let n,s,i,o,a;Array.isArray(t)?[n,s,i,a]=t:(n=t.x,s=t.y,o=t.width,a=t.shape),s>this.maxPeakHeight&&(this.maxPeakHeight=s);let{shape:r}=e;a&&(r=r?{...r,...a}:a);const l=r?getShape1D(r):Object.assign(Object.create(Object.getPrototypeOf(this.shape)),this.shape);let{width:m,widthLeft:c,widthRight:u}=e;const g=void 0!==i?i:o?l.widthToFWHM(o):this.peakWidthFct?this.peakWidthFct(n):void 0!==m?m:l.fwhm;if(c||(c=g),u||(u=g),!c||!u)throw new Error("Width left or right is undefined or zero");let C=void 0===e.factor?l.getFactor():e.factor;const f=n-c/2*C,p=n+u/2*C,h=Math.max(0,Math.floor((f-this.from)/this.interval)),d=Math.min(this.nbPoints-1,Math.ceil((p-this.from)/this.interval)),y=Math.round((n-this.from)/this.interval);l.fwhm=c;for(let t=h;t<Math.max(y,0);t++)this.data.y[t]+=s*l.fct(this.data.x[t]-n);l.fwhm=u;for(let t=Math.min(y,d);t<=d;t++)this.data.y[t]+=s*l.fct(this.data.x[t]-n)}addBaseline(t){return addBaseline(this.data,t),this}addNoise(t){return addNoise(this.data,t),this}getSpectrum(t={}){"boolean"==typeof t&&(t={copy:t});const{copy:e=!0,threshold:n=0}=t;if(n){let t=this.maxPeakHeight*n,e=[],s=[];for(let n=0;n<this.data.x.length;n++)this.data.y[n]>=t&&(e.push(this.data.x[n]),s.push(this.data.y[n]));return{x:Float64Array.from(e),y:Float64Array.from(s)}}return e?{x:this.data.x.slice(),y:this.data.y.slice()}:this.data}reset(){const t=this.data;for(let e=0;e<this.nbPoints;e++)t.x[e]=this.from+e*this.interval;return this}}function assertInteger$1(t,e){if(!Number.isInteger(t))throw new TypeError(`${e} option must be an integer`)}function assertNumber$2(t,e){if(!Number.isFinite(t))throw new TypeError(`${e} option must be a number`)}function generateSpectrum(t,e={}){const{generator:n,noise:s,baseline:i,threshold:o,peakOptions:a}=e,r=new SpectrumGenerator(n);return r.addPeaks(t,a),i&&r.addBaseline(i),s&&r.addNoise(s),r.getSpectrum({threshold:o})}const axis2D=["x","y"],peakCoordinates=["x","y","z"],convertWidthToFWHM=(t,e)=>{const n=ensureXYNumber$1(e);for(let e of axis2D)n[e]=t.widthToFWHM(n[e]);return n};class Spectrum2DGenerator{constructor(t={}){let{from:e=0,to:n=100,nbPoints:s=1001,peakWidthFct:i=(()=>5),shape:o={kind:"gaussian"}}=t;e=ensureXYNumber$1(e),n=ensureXYNumber$1(n),s=ensureXYNumber$1(s);for(const t of axis2D)assertNumber$1(e[t],`from-${t}`),assertNumber$1(n[t],`to-${t}`),assertInteger(s[t],`nbPoints-${t}`);this.from=e,this.to=n,this.nbPoints=s,this.interval=calculeIntervals(e,n,s),this.peakWidthFct=i,this.maxPeakHeight=Number.MIN_SAFE_INTEGER;let a=getShape2D(o);this.shape=a,this.data={x:new Float64Array(s.x),y:new Float64Array(s.y),z:createMatrix(this.nbPoints)};for(const t of axis2D)if(this.to[t]<=this.from[t])throw new RangeError("to option must be larger than from");if("function"!=typeof this.peakWidthFct)throw new TypeError("peakWidthFct option must be a function");this.reset()}addPeaks(t,e){if(!(Array.isArray(t)||"object"==typeof t&&void 0!==t.x&&void 0!==t.y&&Array.isArray(t.x)&&Array.isArray(t.y)&&t.x.length===t.y.length))throw new TypeError("peaks must be an array or an object containing x[] and y[]");if(Array.isArray(t))for(const n of t)this.addPeak(n,e);else{let n=t.x.length;for(const e of peakCoordinates)if(t[e]&&Array.isArray(t[e])&&n!==t[e].length)throw new Error("x, y, z should have the same length");for(let n=0;n<t.x.length;n++)this.addPeak([t.x[n],t.y[n],t.z[n]],e)}return this}addPeak(t,e={}){if(Array.isArray(t)&&t.length<3)throw new Error("peak must be an array with three (or four) values or an object with {x,y,z,width?}");if(!Array.isArray(t)&&peakCoordinates.some((e=>void 0===t[e])))throw new Error("peak must be an array with three (or four) values or an object with {x,y,z,width?}");let n,s,i,o,a,r;Array.isArray(t)?[n,s,i,o,r]=t:(n=t.x,s=t.y,i=t.z,o=t.fwhm,a=t.width,r=t.shape);const l={x:n,y:s};i>this.maxPeakHeight&&(this.maxPeakHeight=i);let{shape:m,width:c}=e;r&&(m=m?{...m,...r}:r);const u=m?getShape2D(m):Object.assign(Object.create(Object.getPrototypeOf(this.shape)),JSON.parse(JSON.stringify(this.shape)));let{fwhm:g=(void 0!==o?o:a?convertWidthToFWHM(u,a):c?convertWidthToFWHM(u,c):this.peakWidthFct(n,s))}=e;g=ensureXYNumber$1(g);let C=void 0===e.factor?u.getFactor():e.factor;C=ensureXYNumber$1(C);const f={x:0,y:0},p={x:0,y:0};for(const t of axis2D){const e=l[t]-g[t]/2*C[t],n=l[t]+g[t]/2*C[t];f[t]=Math.max(0,Math.floor((e-this.from[t])/this.interval[t])),p[t]=Math.min(this.nbPoints[t],Math.ceil((n-this.from[t])/this.interval[t]))}u.fwhm=g;for(let t=f.x;t<p.x;t++)for(let e=f.y;e<p.y;e++){const n=i*u.fct(this.data.x[t]-l.x,this.data.y[e]-l.y);n>1e-6&&(this.data.z[e][t]+=n)}return this}getSpectrum(t={}){"boolean"==typeof t&&(t={copy:t});const{copy:e=!0}=t;let n=matrixMinMaxZ(this.data.z);return{minX:this.from.x,maxX:this.to.x,maxY:this.to.y,minY:this.from.y,minZ:n.min,maxZ:n.max,z:e?this.data.z.slice():this.data.z}}reset(){const t=this.data;for(const e of axis2D)for(let n=0;n<this.nbPoints[e];n++)t[e][n]=this.from[e]+n*this.interval[e];for(let e of t.z)for(let t=0;t<e.length;t++)e[t]=0;return this}}function generateSpectrum2D(t,e={}){const{generator:n,peaks:s}=e,i=new Spectrum2DGenerator(n);return i.addPeaks(t,s),i.getSpectrum()}function ensureXYNumber$1(t){return"object"!=typeof t?{x:t,y:t}:{...t}}function calculeIntervals(t,e,n){return{x:(e.x-t.x)/(n.x-1),y:(e.y-t.y)/(n.y-1)}}function assertInteger(t,e){if(!Number.isInteger(t))throw new TypeError(`${e} option must be an integer`)}function assertNumber$1(t,e){if(!Number.isFinite(t))throw new TypeError(`${e} option must be a number`)}function createMatrix(t){const e=new Array(t.y);for(let n=0;n<t.y;n++)e[n]=new Float64Array(t.x);return e}function hasProperty(t,e){return e in t}const{parse:parse$7,stringify:stringify$7}=JSON;function convertWidth(t,e){const{frequency:n,convertTo:s,output:i=parse$7(stringify$7(t))}=e,o=getConverter(s,n);for(const t of i)if(t.width=o(t.width),hasProperty(t,"shape")){const e=t.shape;e.fwhm&&(e.fwhm=o(e.fwhm))}return i}function getConverter(t,e){switch(t){case"ppm":return t=>t/e;case"hz":return t=>t*e;default:throw new Error(`Does not support convert to ${t}`)}}function convertWidthToPPM(t,e){return convertWidth(t,{...e,convertTo:"ppm"})}function peaksToXY(t,e){const{frequency:n,nbPoints:s=1024,shape:i}=e;if(!n)throw new Error("frequency is mandatory");const o=convertWidthToPPM(t,{frequency:n});return generateSpectrum(o,{generator:{...getFromTo$1(o,e),nbPoints:s,shape:i}})}function getFromTo$1(t,e){if("to"in e&&"from"in e)return{from:e.from,to:e.to};t.sort(((t,e)=>t.x-e.x));const n=t[0],s=t[t.length-1],{from:i=n.x-2*n.width/e.frequency,to:o=s.x+2*s.width/e.frequency}=e;return{from:i,to:o}}for(var IDX=256,HEX=[],BUFFER;IDX--;)HEX[IDX]=(IDX+256).toString(16).substring(1);function v4(){var t,e=0,n="";if(!BUFFER||IDX+16>256){for(BUFFER=Array(e=256);e--;)BUFFER[e]=256*Math.random()|0;e=IDX=0}for(;e<16;e++)t=BUFFER[IDX+e],n+=6==e?HEX[15&t|64]:8==e?HEX[63&t|128]:HEX[t],1&e&&e>1&&e<11&&(n+="-");return IDX++,n}function sgg(t,e,n={}){let{windowSize:s=9,derivative:i=0,polynomial:o=3}=n;if(s%2==0||s<5||!Number.isInteger(s))throw new RangeError("Invalid window size (should be odd and at least 5 integer number)");if(!isAnyArray(t))throw new TypeError("Y values must be an array");if(void 0===e)throw new TypeError("X must be defined");if(s>t.length)throw new RangeError(`Window size is higher than the data length ${s}>${t.length}`);if(i<0||!Number.isInteger(i))throw new RangeError("Derivative should be a positive integer");if(o<1||!Number.isInteger(o))throw new RangeError("Polynomial should be a positive integer");o>=6&&console.warn("You should not use polynomial grade higher than 5 if you are not sure that your data arises from such a model. Possible polynomial oscillation problems");let a=Math.floor(s/2),r=t.length,l=new Float64Array(r),m=fullWeights(s,o,i),c=0,u=!0;isAnyArray(e)?u=!1:c=Math.pow(e,i);for(let n=0;n<a;n++){let o=m[a-n-1],g=m[a+n+1],C=0,f=0;for(let e=0;e<s;e++)C+=o[e]*t[e],f+=g[e]*t[r-s+e];u?(l[a-n-1]=C/c,l[r-a+n]=f/c):(c=getHs(e,a-n-1,a,i),l[a-n-1]=C/c,c=getHs(e,r-a+n,a,i),l[r-a+n]=f/c)}let g=m[a];for(let n=s;n<=r;n++){let o=0;for(let e=0;e<s;e++)o+=g[e]*t[e+n-s];u||(c=getHs(e,n-a-1,a,i)),l[n-a-1]=o/c}return l}function getHs(t,e,n,s){let i=0,o=0;for(let s=e-n;s<e+n;s++)s>=0&&s<t.length-1&&(i+=t[s+1]-t[s],o++);return Math.pow(i/o,s)}function gramPoly(t,e,n,s){let i=0;return i=n>0?(4*n-2)/(n*(2*e-n+1))*(t*gramPoly(t,e,n-1,s)+s*gramPoly(t,e,n-1,s-1))-(n-1)*(2*e+n)/(n*(2*e-n+1))*gramPoly(t,e,n-2,s):0===n&&0===s?1:0,i}function genFact(t,e){let n=1;if(t>=e)for(let s=t-e+1;s<=t;s++)n*=s;return n}function weight(t,e,n,s,i){let o=0;for(let a=0;a<=s;a++)o+=(2*a+1)*(genFact(2*n,a)/genFact(2*n+a+1,a+1))*gramPoly(t,n,a,0)*gramPoly(e,n,a,i);return o}function fullWeights(t,e,n){let s=new Array(t),i=Math.floor(t/2);for(let o=-i;o<=i;o++){s[o+i]=new Float64Array(t);for(let t=-i;t<=i;t++)s[o+i][t+i]=weight(t,o,i,e,n)}return s}function optimizeTop(t,e){const{x:n,y:s}=t;for(const t of e){let e=t.index;if(s[e-1]>=s[e-2]&&s[e-1]>=s[e]?e--:s[e+1]>=s[e]&&s[e+1]>=s[e+2]?e++:s[e-2]>=s[e-3]&&s[e-2]>=s[e-1]?e-=2:s[e+2]>=s[e+1]&&s[e+2]>=s[e+3]&&(e+=2),s[e-1]>0&&s[e+1]>0&&s[e]>=s[e-1]&&s[e]>=s[e+1]&&(s[e]!==s[e-1]||s[e]!==s[e+1])){let i=20*Math.log10(s[e-1]),o=20*Math.log10(s[e]),a=20*Math.log10(s[e+1]),r=.5*(i-a)/(i-2*o+a);t.x=n[e]+(n[e]-n[e-1])*r,t.y=s[e]-.25*(s[e-1]-s[e+1])*r}}}function gsd(t,e={}){let{sgOptions:n={windowSize:9,polynomial:3},noiseLevel:s,smoothY:i=!1,maxCriteria:o=!0,minMaxRatio:a=25e-5,realTopDetection:r=!1}=e,{x:l,y:m}=t;if(1!==xIsMonotonic(l))throw new Error("GSD only accepts monotone increasing x values");m=m.slice();let c=xIsEquallySpaced(l);if(void 0===s)if(c){const t=xNoiseStandardDeviation(m);s=o?t.median+1.5*t.sd:-t.median+1.5*t.sd}else s=0;else o||(s*=-1);if(!o)for(let t=0;t<m.length;t++)m[t]*=-1;if(void 0!==s)for(let t=0;t<m.length;t++)m[t]<s&&(m[t]=s);let u,g,C=m;const{windowSize:f,polynomial:p}=n;c?(i&&(C=sgg(m,l[1]-l[0],{windowSize:f,polynomial:p,derivative:0})),u=sgg(m,l[1]-l[0],{windowSize:f,polynomial:p,derivative:1}),g=sgg(m,l[1]-l[0],{windowSize:f,polynomial:p,derivative:2})):(i&&(C=sgg(m,l,{windowSize:f,polynomial:p,derivative:0})),u=sgg(m,l,{windowSize:f,polynomial:p,derivative:1}),g=sgg(m,l,{windowSize:f,polynomial:p,derivative:2}));const h=xMinValue(C),d=xMaxValue(C);if(h>d||h===d)return[];const y=h+(d-h)*a,H=l[1]-l[0];let b=null,v=null,w=[],x=[],O=[];for(let t=1;t<C.length-1;++t)(u[t]<u[t-1]&&u[t]<=u[t+1]||u[t]<=u[t-1]&&u[t]<u[t+1])&&(v={x:l[t],index:t},H>0&&null!==b&&(x.push(b),O.push(v))),(u[t]>=u[t-1]&&u[t]>u[t+1]||u[t]>u[t-1]&&u[t]>=u[t+1])&&(b={x:l[t],index:t},H<0&&null!==v&&(x.push(b),O.push(v))),g[t]<g[t-1]&&g[t]<g[t+1]&&w.push(t);let D=-1;const A=[];for(const t of w){let e=l[t],n=-1,s=D+1,i=Number.POSITIVE_INFINITY,o=0;for(;-1===n&&s<x.length&&(o=Math.abs(e-(x[s].x+O[s].x)/2),o<(O[s].x-x[s].x)/2&&(n=s,D=s),++s,!(o>=i));)i=o;if(-1!==n&&C[t]>y){let s=Math.abs(O[n].x-x[n].x);A.push({id:v4(),x:e,y:C[t],width:s,index:t,ddY:g[t],inflectionPoints:{from:x[n],to:O[n]}})}}return r&&optimizeTop({x:l,y:C},A),A.forEach((t=>{o||(t.y*=-1,t.ddY=-1*t.ddY)})),A.sort(((t,e)=>t.x-e.x)),A}function getSumOfShapes$1(t){return function(e){return n=>{let s=0;for(const i of t){const t=e[i.fromIndex],o=e[i.fromIndex+1];for(let t=2;t<e.length;t++)i.shapeFct[i.parameters[t]]=e[i.fromIndex+t];s+=o*i.shapeFct.fct(n-t)}return s}}}function assert(t,e){if(!t)throw new Error(e||"unreachable")}const DefaultParameters={x:{init:t=>t.x,min:(t,e)=>t.x-2*e.fwhm,max:(t,e)=>t.x+2*e.fwhm,gradientDifference:(t,e)=>.002*e.fwhm},y:{init:t=>t.y,min:t=>t.y<0?-1.1:0,max:t=>t.y<0?0:1.1,gradientDifference:()=>.001},fwhm:{init:(t,e)=>e.fwhm,min:(t,e)=>.25*e.fwhm,max:(t,e)=>4*e.fwhm,gradientDifference:(t,e)=>.002*e.fwhm},mu:{init:(t,e)=>e.mu,min:()=>0,max:()=>1,gradientDifference:()=>.01}},properties$1=["init","min","max","gradientDifference"];function getInternalPeaks(t,e,n={}){let s=0,i=[];const{baseline:o=e.min}=n,a=t.map((t=>({...t,y:(t.y-o)/e.range})));for(const t of a){const{id:o,shape:a=(n.shape?n.shape:{kind:"gaussian"})}=t,r=getShape1D(a),l=["x","y",...r.getParameters()],m={min:[],max:[],init:[],gradientDifference:[]};for(let s of l)for(let i of properties$1){let o=t?.parameters?.[s]?.[i];if(o){o=getNormalizedValue$1(o,s,i,e,n.baseline),m[i].push(o);continue}let a=n?.parameters?.[s]?.[i];if(a){if("number"==typeof a){a=getNormalizedValue$1(a,s,i,e,n.baseline),m[i].push(a);continue}{let o=a(t);o=getNormalizedValue$1(o,s,i,e,n.baseline),m[i].push(o);continue}}assert(DefaultParameters[s],`No default parameter for ${s}`);const l=DefaultParameters[s][i];m[i].push(l(t,r))}const c=s,u=c+l.length-1;s+=u-c+1,i.push({id:o,shape:a,shapeFct:r,parameters:l,propertiesValues:m,fromIndex:c,toIndex:u})}return i}function getNormalizedValue$1(t,e,n,s,i){return"y"===e?"gradientDifference"===n?t:void 0!==i?(t-i)/s.range:(t-s.min)/s.range:t}function checkOptions(t,e,n){let{timeout:s,minValues:i,maxValues:o,initialValues:a,weights:r=1,damping:l=.01,dampingStepUp:m=11,dampingStepDown:c=9,maxIterations:u=100,errorTolerance:g=1e-7,centralDifference:C=!1,gradientDifference:f=.1,improvementThreshold:p=.001}=n;if(l<=0)throw new Error("The damping option must be a positive number");if(!t.x||!t.y)throw new Error("The data parameter must have x and y elements");if(!isAnyArray(t.x)||t.x.length<2||!isAnyArray(t.y)||t.y.length<2)throw new Error("The data parameter elements must be an array with more than 2 points");if(t.x.length!==t.y.length)throw new Error("The data parameter elements must have the same size");if(!(a&&a.length>0))throw new Error("The initialValues option is mandatory and must be an array");let h,d,y=a,H=t.y.length,b=y.length;if(o=o||new Array(b).fill(Number.MAX_SAFE_INTEGER),i=i||new Array(b).fill(Number.MIN_SAFE_INTEGER),o.length!==i.length)throw new Error("minValues and maxValues must be the same size");if("number"==typeof f)f=new Array(y.length).fill(f);else{if(!isAnyArray(f))throw new Error("gradientDifference should be a number or array with length equal to the number of parameters");f.length!==b&&(f=new Array(b).fill(f[0]))}if("number"==typeof r){let t=1/r**2;h=()=>t}else{if(!isAnyArray(r))throw new Error("weights should be a number or array with length equal to the number of data points");if(r.length<t.x.length){let t=1/r[0]**2;h=()=>t}else h=t=>1/r[t]**2}if(void 0!==s){if("number"!=typeof s)throw new Error("timeout should be a number");let t=Date.now()+1e3*s;d=()=>Date.now()>t}else d=()=>!1;let v=new Array(t.x.length);for(let t=0;t<H;t++)v[t]=h(t);return{checkTimeout:d,minValues:i,maxValues:o,parameters:y,weightSquare:v,damping:l,dampingStepUp:m,dampingStepDown:c,maxIterations:u,errorTolerance:g,centralDifference:C,gradientDifference:f,improvementThreshold:p}}function errorCalculation(t,e,n,s){let i=0;const o=n(e);for(let e=0;e<t.x.length;e++)i+=Math.pow(t.y[e]-o(t.x[e]),2)/s[e];return i}function gradientFunction(t,e,n,s,i,o){const a=n.length,r=t.x.length;let l=Matrix.zeros(a,r),m=0;for(let c=0;c<a;c++){if(0===s[c])continue;let a=s[c],u=n.slice();u[c]+=a;let g=i(u);if(o){u=n.slice(),u[c]-=a,a*=2;let e=i(u);for(let n=0;n<r;n++)l.set(m,n,(e(t.x[n])-g(t.x[n]))/a)}else for(let n=0;n<r;n++)l.set(m,n,(e[n]-g(t.x[n]))/a);m++}return l}function matrixFunction(t,e){const n=t.x.length;let s=new Matrix(n,1);for(let i=0;i<n;i++)s.set(i,0,t.y[i]-e[i]);return s}function step(t,e,n,s,i,o,a){let r=n,l=Matrix.eye(e.length,e.length,r);const m=i(e);let c=new Float64Array(t.x.length);for(let e=0;e<t.x.length;e++)c[e]=m(t.x[e]);let u=gradientFunction(t,c,e,s,i,o),g=matrixFunction(t,c),C=inverse(l.add(u.mmul(u.transpose().scale("row",{scale:a})))),f=u.mmul(g.scale("row",{scale:a}));return{perturbations:C.mmul(f),jacobianWeightResidualError:f}}function levenbergMarquardt(t,e,n){let{checkTimeout:s,minValues:i,maxValues:o,parameters:a,weightSquare:r,damping:l,dampingStepUp:m,dampingStepDown:c,maxIterations:u,errorTolerance:g,centralDifference:C,gradientDifference:f,improvementThreshold:p}=checkOptions(t,e,n),h=errorCalculation(t,a,e,r),d=h,y=a.slice(),H=h<=g,b=0;for(;b<u&&!H;b++){let u=h,{perturbations:b,jacobianWeightResidualError:v}=step(t,a,l,f,e,C,r);for(let t=0;t<a.length;t++)a[t]=Math.min(Math.max(i[t],a[t]-b.get(t,0)),o[t]);if(h=errorCalculation(t,a,e,r),isNaN(h))break;if(h<d-g&&(d=h,y=a.slice()),l=(u-h)/b.transpose().mmul(b.mul(l).add(v)).get(0,0)>p?Math.max(l/c,1e-7):Math.min(l*m,1e7),s())throw new Error(`The execution time is over to ${n.timeout} seconds`);H=h<=g}return{parameterValues:y,parameterError:d,iterations:b}}function antiLowerConvexHull(t,e){if(t.length!==e.length)throw new RangeError("X and Y vectors has different dimensions");const n=t.length-1;if(0===n)return[0];if(1===n)return[0,1];let s=0,i=new Array(t.length).fill(!0);for(;;){const o=s,a=moveOn(s,n,i),r=moveOn(moveOn(s,n,i),n,i);if(t[r]*(e[o]-e[a])+t[o]*(e[a]-e[r])+t[a]*(e[r]-e[o])>=0?s=a:(i[a]=!1,s=moveBack(s,n,i)),r===n)break}return i.map(((t,e)=>!1!==t&&e)).filter((t=>!1!==t))}function moveBack(t,e,n){let s=t-1;for(;!1===n[s];)s--;return 0===t?e:s}function moveOn(t,e,n){let s=t+1;for(;!1===n[s];)s++;return t===e?0:s}function direct(t,e,n,s={}){const{iterations:i=50,epsilon:o=1e-4,tolerance:a=1e-16,tolerance2:r=1e-12,initialState:l={}}=s;if(void 0===t||void 0===e||void 0===n)throw new RangeError("There is something undefined");if(e=new Float64Array(e),n=new Float64Array(n),e.length!==n.length)throw new Error("Lower bounds and Upper bounds for x are not of the same length");let m=e.length,c=n.map(((t,n)=>t-e[n])),{numberOfRectangles:u=0,totalIterations:g=0,unitaryCoordinates:C=[new Float64Array(m).fill(.5)],middlePoint:f=new Float64Array(m).map(((t,n)=>e[n]+C[0][n]*c[n])),bestCurrentValue:p=t(f),fCalls:h=1,smallerDistance:d=0,edgeSizes:y=[new Float64Array(m).fill(.5)],diagonalDistances:H=[Math.sqrt(m*Math.pow(.5,2))],functionValues:b=[p],differentDistances:v=H,smallerValuesByDistance:w=[p],choiceLimit:x}=l;if(l.originalCoordinates&&l.originalCoordinates.length>0){p=xMinValue(b),x=o*Math.abs(p)>1e-8?o*Math.abs(p):1e-8,d=getMinIndex(b,H,x,p),C=l.originalCoordinates.slice();for(let t=0;t<C.length;t++)for(let n=0;n<e.length;n++)C[t][n]=(C[t][n]-e[n])/c[n]}let O=0;for(;O<i;){let n,s,i=[],l=v.findIndex((t=>t===H[d])),m=0;for(let t=l;t<v.length;t++)for(let e=0;e<b.length;e++)b[e]===w[t]&H[e]===v[t]&&(i[m++]=e);if(v.length-l>1){let t=H[d],e=b[d],n=v[v.length-1],o=(w[v.length-1]-e)/(n-t),a=e-o*t,l=new Uint32Array(m);m=0;for(let t=0;t<l.length;t++){let e=i[t];b[e]<=o*H[e]+a+r&&(l[m++]=e)}let c=[],u=[];for(let t=0;t<m;t++)c.push(H[l[t]]),u.push(b[l[t]]);let g=antiLowerConvexHull(c,u);s=[];for(let t=0;t<g.length;t++)s.push(l[g[t]])}else s=i.slice(0,m);n=s;for(let s=0;s<n.length;s++){let i=n[s],o=xMaxValue(y[i]),r=new Uint32Array(y[i].length);m=0;for(let t=0;t<y[i].length;t++)Math.abs(y[i][t]-o)<a&&(r[m++]=t);let l=2*o/3,g=[];for(let n=0;n<m;n++){let s=r[n],o=C[i].slice(),a=C[i].slice();o[s]+=l,a[s]-=l;let m=new Float64Array(o.length),u=new Float64Array(a.length);for(let t=0;t<o.length;t++)m[t]=e[t]+o[t]*c[t],u[t]=e[t]+a[t]*c[t];let f=t(m),p=t(u);h+=2,g.push({minValue:Math.min(f,p),index:n}),C.push(o,a),b.push(f,p)}let f=g.sort(((t,e)=>t.minValue-e.minValue));for(let t=0;t<m;t++){let e=r[f[t].index],n=u+2*(f[t].index+1)-1,s=u+2*(f[t].index+1);y[i][e]=l/2,y[n]=y[i].slice(),y[s]=y[i].slice(),H[i]=xNorm(y[i]),H[n]=H[i],H[s]=H[i]}u+=2*m}p=xMinValue(b),x=o*Math.abs(p)>1e-8?o*Math.abs(p):1e-8,d=getMinIndex(b,H,x,p),v=Array.from(new Set(H)),v=v.sort(((t,e)=>t-e)),w=[];for(let t=0;t<v.length;t++){let e,n=Number.POSITIVE_INFINITY;for(let s=0;s<H.length;s++)H[s]===v[t]&&b[s]<n&&(n=b[s],e=s);w.push(b[e])}for(let t=0;t<b.length;t++)if(b[t]===p){let n=[];for(let s=0;s<e.length;s++)n.push(e[s]+C[t][s]*c[s])}O+=1}let D={};D.minFunctionValue=p,D.iterations=O;let A=[];for(let t=0;t<u+1;t++){let n=[];for(let s=0;s<e.length;s++)n.push(e[s]+C[t][s]*c[s]);A.push(n)}D.finalState={numberOfRectangles:u,totalIterations:g+=i,originalCoordinates:A,middlePoint:f,fCalls:h,smallerDistance:d,edgeSizes:y,diagonalDistances:H,functionValues:b,differentDistances:v,smallerValuesByDistance:w,choiceLimit:x};let S=[];for(let t=0;t<b.length;t++)b[t]===p&&S.push(A[t]);return D.optima=S,D}function getMinIndex(t,e,n,s){let i=[];for(let o=0;o<t.length;o++)i[o]=Math.abs(t[o]-(s+n))/e[o];const o=xMinValue(i);return i.findIndex((t=>t===o))}function directOptimization$1(t,e,n){const{minValues:s,maxValues:i,maxIterations:o,epsilon:a,tolerance:r,tolerance2:l,initialState:m}=n,c=direct(getObjectiveFunction$1(t,e),s,i,{iterations:o,epsilon:a,tolerance:r,tolerance2:l,initialState:m}),{optima:u}=c;return{parameterError:c.minFunctionValue,iterations:c.iterations,parameterValues:u[0]}}function getObjectiveFunction$1(t,e){const{x:n,y:s}=t,i=n.length;return t=>{const o=e(t);let a=0;for(let t=0;t<i;t++)a+=Math.pow(s[t]-o(n[t]),2);return a}}function selectMethod(t={}){let{kind:e="lm",options:n}=t;switch(e){case"lm":case"levenbergMarquardt":return{algorithm:levenbergMarquardt,optimizationOptions:{damping:1.5,maxIterations:100,errorTolerance:1e-8,...n}};case"direct":return{algorithm:directOptimization$1,optimizationOptions:{iterations:20,epsilon:1e-4,tolerance:1e-16,tolerance2:1e-12,initialState:{},...n}};default:throw new Error("Unknown fitting algorithm")}}function optimize(t,e,n={}){let s=xMinMaxValues(t.y);const i={...s,range:s.max-s.min},o=getInternalPeaks(e,i,n),{baseline:a=i.min}=n;let r=new Float64Array(t.y.length);for(let e=0;e<t.y.length;e++)r[e]=(t.y[e]-a)/i.range;const l=o[o.length-1].toIndex+1,m=new Float64Array(l),c=new Float64Array(l),u=new Float64Array(l),g=new Float64Array(l);let C=0;for(const t of o)for(let e=0;e<t.parameters.length;e++)m[C]=t.propertiesValues.min[e],c[C]=t.propertiesValues.max[e],u[C]=t.propertiesValues.init[e],g[C]=t.propertiesValues.gradientDifference[e],C++;let{algorithm:f,optimizationOptions:p}=selectMethod(n.optimization),h=getSumOfShapes$1(o),d=f({x:t.x,y:r},h,{minValues:m,maxValues:c,initialValues:u,gradientDifference:g,...p});const y=d.parameterValues;let H=[];for(let t of o){const{id:e,shape:n,parameters:s,fromIndex:o}=t;let r={x:0,y:0,shape:n};e&&(r={...r,id:e}),r.x=y[o],r.y=y[o+1]*i.range+a;for(let t=2;t<s.length;t++)r.shape[s[t]]=y[o+t];H.push(r)}return{error:d.parameterError,iterations:d.iterations,peaks:H}}const{parse:parse$6,stringify:stringify$6}=JSON;function addMissingShape(t,e={}){const{shape:n={kind:"gaussian"},output:s=parse$6(stringify$6(t))}=e;let i=getShape1D(n);return s.map((t=>{if(hasShape(t)){if(!("fwhm"in t.shape)){const e=getShape1D(t.shape);t.shape.fwhm=e.widthToFWHM(t.width)}return t}return{...t,shape:{fwhm:i.widthToFWHM(t.width),...n}}}))}function hasShape(t){return"shape"in t}function groupPeaks(t,e={}){if(t&&0===t.length)return[];const{factor:n=1}=e;(t=JSON.parse(JSON.stringify(t))).sort(((t,e)=>t.x-e.x));let s=t[0],i=[s],o=[i];for(let e=1;e<t.length;e++){const a=t[e];(a.x-s.x)/((a.width+s.width)/2)<=n?i.push(a):(i=[a],o.push(i)),s=a}return o}function optimizePeaksWithLogs(t,e,n={}){const{fromTo:s={},baseline:i,shape:o={kind:"gaussian"},groupingFactor:a=1,factorLimits:r=2,optimization:l={kind:"lm",options:{timeout:10}}}=n;let m=groupPeaks(e,{factor:a}),c=[],u=[];return m.forEach((e=>{const n=Date.now(),a=addMissingShape(e,{shape:o}),m=a[0],g=a[a.length-1],{from:C=m.x-m.width*r,to:f=g.x+g.width*r}=s,{fromIndex:p,toIndex:h}=xGetFromToIndex(t.x,{from:C,to:f}),d=t.x instanceof Float64Array?t.x.subarray(p,h):t.x.slice(p,h),y=t.y instanceof Float64Array?t.y.subarray(p,h):t.y.slice(p,h),H={range:{from:C,to:f},parameters:l,groupSize:e.length,time:Date.now()-n};if(d.length>5){const{iterations:t,error:e,peaks:n}=optimize({x:d,y:y},a,{shape:o,baseline:i,optimization:l});for(let t=0;t<a.length;t++)u.push({...n[t],width:getShape1D(a[t].shape).fwhmToWidth(n[t].shape.fwhm)});c.push({...H,iterations:t,error:e,message:"optimization successful"})}else u.push(...a),c.push({...H,iterations:0,message:"x length too small for optimization"})})),{logs:c,optimizedPeaks:u}}function optimizePeaks(t,e,n={}){return optimizePeaksWithLogs(t,e,n).optimizedPeaks}const{parse:parse$5,stringify:stringify$5}=JSON;function addMissingIDs$1(t,e={}){const{output:n=parse$5(stringify$5(t))}=e;for(const t of n)"id"in t||(t.id=v4());return n}function joinBroadPeaks(t,e={}){let{shape:n={kind:"gaussian"},optimization:s={kind:"lm",options:{timeout:10}},broadWidth:i=.25,broadRatio:o=.0025}=e,a=0,r=0,l=1;const m=[];if(t.length<2)return addMissingIDs$1(addMissingShape(t.map(getGSDPeakOptimizedStructure),{shape:n}));let c=t[0].ddY;for(let e=1;e<t.length;e++)Math.abs(t[e].ddY)>c&&(c=Math.abs(t[e].ddY));const u=[];for(const e of t)Math.abs(e.ddY)<=o*c?m.push(e):u.push(getGSDPeakOptimizedStructure(e));m.push({x:Number.MAX_VALUE,y:0});let g={x:[m[0].x],y:[m[0].y]},C=[0];for(let t=1;t<m.length;t++)if(Math.abs(m[t-1].x-m[t].x)<i)g.x.push(m[t].x),g.y.push(m[t].y),m[t].y>a&&(a=m[t].y,r=t),C.push(t),l++;else{if(l>2){let t=optimizePeaks(g,[{id:v4(),x:m[r].x,y:a,width:g.x[0]-g.x[g.x.length-1]}],{shape:n,optimization:s});u.push(t[0])}else for(const t of C)u.push(getGSDPeakOptimizedStructure(m[t]));g={x:[m[t].x],y:[m[t].y]},C=[t],a=m[t].y,r=t,l=1}return u.sort(((t,e)=>t.x-e.x)),addMissingIDs$1(u,{output:u})}function getGSDPeakOptimizedStructure(t){const{id:e,shape:n,x:s,y:i,width:o}=t;let a={x:s,y:i,width:o,shape:n};return e&&(a.id=e),a}const{parse:parse$4,stringify:stringify$4}=JSON;function setShape(t,e={}){let{shape:n={kind:"gaussian"},output:s=parse$4(stringify$4(t))}=e,i=getShape1D(n);return s.map((t=>({...t,shape:{fwhm:i.widthToFWHM(t.width),...n}})))}function peakToXY(t,e){const n=addMissingShape([t])[0],s=getShape1D(n.shape).getFactor(),{from:i=n.x-t.width*s/e.frequency,to:o=n.x+t.width*s/e.frequency}=e;return peaksToXY([t],{...e,from:i,to:o})}var browserPonyfill={exports:{}};!function(t,e){var n="undefined"!=typeof globalThis&&globalThis||"undefined"!=typeof self&&self||void 0!==commonjsGlobal&&commonjsGlobal,s=function(){function t(){this.fetch=!1,this.DOMException=n.DOMException}return t.prototype=n,new t}();!function(t){!function(e){var n=void 0!==t&&t||"undefined"!=typeof self&&self||void 0!==n&&n,s="URLSearchParams"in n,i="Symbol"in n&&"iterator"in Symbol,o="FileReader"in n&&"Blob"in n&&function(){try{return new Blob,!0}catch(t){return!1}}(),a="FormData"in n,r="ArrayBuffer"in n;if(r)var l=["[object Int8Array]","[object Uint8Array]","[object Uint8ClampedArray]","[object Int16Array]","[object Uint16Array]","[object Int32Array]","[object Uint32Array]","[object Float32Array]","[object Float64Array]"],m=ArrayBuffer.isView||function(t){return t&&l.indexOf(Object.prototype.toString.call(t))>-1};function c(t){if("string"!=typeof t&&(t=String(t)),/[^a-z0-9\-#$%&'*+.^_`|~!]/i.test(t)||""===t)throw new TypeError('Invalid character in header field name: "'+t+'"');return t.toLowerCase()}function u(t){return"string"!=typeof t&&(t=String(t)),t}function g(t){var e={next:function(){var e=t.shift();return{done:void 0===e,value:e}}};return i&&(e[Symbol.iterator]=function(){return e}),e}function C(t){this.map={},t instanceof C?t.forEach((function(t,e){this.append(e,t)}),this):Array.isArray(t)?t.forEach((function(t){this.append(t[0],t[1])}),this):t&&Object.getOwnPropertyNames(t).forEach((function(e){this.append(e,t[e])}),this)}function f(t){if(t.bodyUsed)return Promise.reject(new TypeError("Already read"));t.bodyUsed=!0}function p(t){return new Promise((function(e,n){t.onload=function(){e(t.result)},t.onerror=function(){n(t.error)}}))}function h(t){var e=new FileReader,n=p(e);return e.readAsArrayBuffer(t),n}function d(t){if(t.slice)return t.slice(0);var e=new Uint8Array(t.byteLength);return e.set(new Uint8Array(t)),e.buffer}function y(){return this.bodyUsed=!1,this._initBody=function(t){var e;this.bodyUsed=this.bodyUsed,this._bodyInit=t,t?"string"==typeof t?this._bodyText=t:o&&Blob.prototype.isPrototypeOf(t)?this._bodyBlob=t:a&&FormData.prototype.isPrototypeOf(t)?this._bodyFormData=t:s&&URLSearchParams.prototype.isPrototypeOf(t)?this._bodyText=t.toString():r&&o&&((e=t)&&DataView.prototype.isPrototypeOf(e))?(this._bodyArrayBuffer=d(t.buffer),this._bodyInit=new Blob([this._bodyArrayBuffer])):r&&(ArrayBuffer.prototype.isPrototypeOf(t)||m(t))?this._bodyArrayBuffer=d(t):this._bodyText=t=Object.prototype.toString.call(t):this._bodyText="",this.headers.get("content-type")||("string"==typeof t?this.headers.set("content-type","text/plain;charset=UTF-8"):this._bodyBlob&&this._bodyBlob.type?this.headers.set("content-type",this._bodyBlob.type):s&&URLSearchParams.prototype.isPrototypeOf(t)&&this.headers.set("content-type","application/x-www-form-urlencoded;charset=UTF-8"))},o&&(this.blob=function(){var t=f(this);if(t)return t;if(this._bodyBlob)return Promise.resolve(this._bodyBlob);if(this._bodyArrayBuffer)return Promise.resolve(new Blob([this._bodyArrayBuffer]));if(this._bodyFormData)throw new Error("could not read FormData body as blob");return Promise.resolve(new Blob([this._bodyText]))},this.arrayBuffer=function(){if(this._bodyArrayBuffer){var t=f(this);return t||(ArrayBuffer.isView(this._bodyArrayBuffer)?Promise.resolve(this._bodyArrayBuffer.buffer.slice(this._bodyArrayBuffer.byteOffset,this._bodyArrayBuffer.byteOffset+this._bodyArrayBuffer.byteLength)):Promise.resolve(this._bodyArrayBuffer))}return this.blob().then(h)}),this.text=function(){var t,e,n,s=f(this);if(s)return s;if(this._bodyBlob)return t=this._bodyBlob,e=new FileReader,n=p(e),e.readAsText(t),n;if(this._bodyArrayBuffer)return Promise.resolve(function(t){for(var e=new Uint8Array(t),n=new Array(e.length),s=0;s<e.length;s++)n[s]=String.fromCharCode(e[s]);return n.join("")}(this._bodyArrayBuffer));if(this._bodyFormData)throw new Error("could not read FormData body as text");return Promise.resolve(this._bodyText)},a&&(this.formData=function(){return this.text().then(v)}),this.json=function(){return this.text().then(JSON.parse)},this}C.prototype.append=function(t,e){t=c(t),e=u(e);var n=this.map[t];this.map[t]=n?n+", "+e:e},C.prototype.delete=function(t){delete this.map[c(t)]},C.prototype.get=function(t){return t=c(t),this.has(t)?this.map[t]:null},C.prototype.has=function(t){return this.map.hasOwnProperty(c(t))},C.prototype.set=function(t,e){this.map[c(t)]=u(e)},C.prototype.forEach=function(t,e){for(var n in this.map)this.map.hasOwnProperty(n)&&t.call(e,this.map[n],n,this)},C.prototype.keys=function(){var t=[];return this.forEach((function(e,n){t.push(n)})),g(t)},C.prototype.values=function(){var t=[];return this.forEach((function(e){t.push(e)})),g(t)},C.prototype.entries=function(){var t=[];return this.forEach((function(e,n){t.push([n,e])})),g(t)},i&&(C.prototype[Symbol.iterator]=C.prototype.entries);var H=["DELETE","GET","HEAD","OPTIONS","POST","PUT"];function b(t,e){if(!(this instanceof b))throw new TypeError('Please use the "new" operator, this DOM object constructor cannot be called as a function.');var n,s,i=(e=e||{}).body;if(t instanceof b){if(t.bodyUsed)throw new TypeError("Already read");this.url=t.url,this.credentials=t.credentials,e.headers||(this.headers=new C(t.headers)),this.method=t.method,this.mode=t.mode,this.signal=t.signal,i||null==t._bodyInit||(i=t._bodyInit,t.bodyUsed=!0)}else this.url=String(t);if(this.credentials=e.credentials||this.credentials||"same-origin",!e.headers&&this.headers||(this.headers=new C(e.headers)),this.method=(n=e.method||this.method||"GET",s=n.toUpperCase(),H.indexOf(s)>-1?s:n),this.mode=e.mode||this.mode||null,this.signal=e.signal||this.signal,this.referrer=null,("GET"===this.method||"HEAD"===this.method)&&i)throw new TypeError("Body not allowed for GET or HEAD requests");if(this._initBody(i),!("GET"!==this.method&&"HEAD"!==this.method||"no-store"!==e.cache&&"no-cache"!==e.cache)){var o=/([?&])_=[^&]*/;if(o.test(this.url))this.url=this.url.replace(o,"$1_="+(new Date).getTime());else{this.url+=(/\?/.test(this.url)?"&":"?")+"_="+(new Date).getTime()}}}function v(t){var e=new FormData;return t.trim().split("&").forEach((function(t){if(t){var n=t.split("="),s=n.shift().replace(/\+/g," "),i=n.join("=").replace(/\+/g," ");e.append(decodeURIComponent(s),decodeURIComponent(i))}})),e}function w(t,e){if(!(this instanceof w))throw new TypeError('Please use the "new" operator, this DOM object constructor cannot be called as a function.');e||(e={}),this.type="default",this.status=void 0===e.status?200:e.status,this.ok=this.status>=200&&this.status<300,this.statusText=void 0===e.statusText?"":""+e.statusText,this.headers=new C(e.headers),this.url=e.url||"",this._initBody(t)}b.prototype.clone=function(){return new b(this,{body:this._bodyInit})},y.call(b.prototype),y.call(w.prototype),w.prototype.clone=function(){return new w(this._bodyInit,{status:this.status,statusText:this.statusText,headers:new C(this.headers),url:this.url})},w.error=function(){var t=new w(null,{status:0,statusText:""});return t.type="error",t};var x=[301,302,303,307,308];w.redirect=function(t,e){if(-1===x.indexOf(e))throw new RangeError("Invalid status code");return new w(null,{status:e,headers:{location:t}})},e.DOMException=n.DOMException;try{new e.DOMException}catch(t){e.DOMException=function(t,e){this.message=t,this.name=e;var n=Error(t);this.stack=n.stack},e.DOMException.prototype=Object.create(Error.prototype),e.DOMException.prototype.constructor=e.DOMException}function O(t,s){return new Promise((function(i,a){var l=new b(t,s);if(l.signal&&l.signal.aborted)return a(new e.DOMException("Aborted","AbortError"));var m=new XMLHttpRequest;function c(){m.abort()}m.onload=function(){var t,e,n={status:m.status,statusText:m.statusText,headers:(t=m.getAllResponseHeaders()||"",e=new C,t.replace(/\r?\n[\t ]+/g," ").split("\r").map((function(t){return 0===t.indexOf("\n")?t.substr(1,t.length):t})).forEach((function(t){var n=t.split(":"),s=n.shift().trim();if(s){var i=n.join(":").trim();e.append(s,i)}})),e)};n.url="responseURL"in m?m.responseURL:n.headers.get("X-Request-URL");var s="response"in m?m.response:m.responseText;setTimeout((function(){i(new w(s,n))}),0)},m.onerror=function(){setTimeout((function(){a(new TypeError("Network request failed"))}),0)},m.ontimeout=function(){setTimeout((function(){a(new TypeError("Network request failed"))}),0)},m.onabort=function(){setTimeout((function(){a(new e.DOMException("Aborted","AbortError"))}),0)},m.open(l.method,function(t){try{return""===t&&n.location.href?n.location.href:t}catch(e){return t}}(l.url),!0),"include"===l.credentials?m.withCredentials=!0:"omit"===l.credentials&&(m.withCredentials=!1),"responseType"in m&&(o?m.responseType="blob":r&&l.headers.get("Content-Type")&&-1!==l.headers.get("Content-Type").indexOf("application/octet-stream")&&(m.responseType="arraybuffer")),!s||"object"!=typeof s.headers||s.headers instanceof C?l.headers.forEach((function(t,e){m.setRequestHeader(e,t)})):Object.getOwnPropertyNames(s.headers).forEach((function(t){m.setRequestHeader(t,u(s.headers[t]))})),l.signal&&(l.signal.addEventListener("abort",c),m.onreadystatechange=function(){4===m.readyState&&l.signal.removeEventListener("abort",c)}),m.send(void 0===l._bodyInit?null:l._bodyInit)}))}O.polyfill=!0,n.fetch||(n.fetch=O,n.Headers=C,n.Request=b,n.Response=w),e.Headers=C,e.Request=b,e.Response=w,e.fetch=O}({})}(s),s.fetch.ponyfill=!0,delete s.fetch.polyfill;var i=n.fetch?n:s;(e=i.fetch).default=i.fetch,e.fetch=i.fetch,e.Headers=i.Headers,e.Request=i.Request,e.Response=i.Response,t.exports=e}(browserPonyfill,browserPonyfill.exports);var fetch=browserPonyfill.exports,browser="object"==typeof self?self.FormData:window.FormData,FormData$1=browser;let xAtomicNumber=0;function getXAtomicNumber(t){if(!xAtomicNumber){const e=t.getOCL();xAtomicNumber=e.Molecule.getAtomicNoFromLabel("X",e.Molecule.cPseudoAtomX)}return xAtomicNumber}function getChiralOrHeterotopicCarbons(t){const{Molecule:e}=t.getOCL(),n=getXAtomicNumber(t),s=t.getCompactCopy();s.addImplicitHydrogens();for(let t=0;t<s.getAllAtoms();t++)1===s.getAtomicNo(t)&&s.setAtomicNo(t,n);addPossibleChiralBonds(s),s.ensureHelperArrays(e.cHelperSymmetryStereoHeterotopicity);const i=[];for(let e=0;e<t.getAllAtoms();e++){if(s.getAtomicNo(e)===n)continue;if(t.getAtomicNo(e)!==s.getAtomicNo(e))throw new Error("getChiralOrHeterotopicCarbons: mismatching atomic numbers");if(6!==s.getAtomicNo(e))continue;4===getNeighbourSymmetries(s,e).length&&i.push(e)}return i}function addPossibleChiralBonds(t){const{Molecule:e}=t.getOCL();t.ensureHelperArrays(e.cHelperSymmetryStereoHeterotopicity);for(let n=0;n<t.getAtoms();n++){if(6!==t.getAtomicNo(n))continue;if(t.getStereoBond(n)>=0)continue;if(getNeighbourSymmetries(t,n).length<=2)continue;const s=t.getAtomPreferredStereoBond(n);if(-1!==s){if(t.setBondType(s,e.cBondTypeUp),t.getBondAtom(1,s)===n){const e=t.getBondAtom(0,s);t.setBondAtom(0,s,n),t.setBondAtom(1,s,e)}t.setAtomESR(n,e.cESRTypeAnd,0)}}}function getNeighbourSymmetries(t,e){const n=[];for(let s=0;s<t.getAllConnAtoms(e);s++){const i=t.getConnAtom(e,s),o=t.getSymmetryRank(i);n.includes(o)||n.push(t.getSymmetryRank(i))}return n}function ensureHeterotopicChiralBonds(t,e={}){const{Molecule:n}=t.getOCL(),{esrType:s=n.cESRTypeAnd,atLeastThreeAtoms:i=!0}=e;t.ensureHelperArrays(n.cHelperBitNeighbours);const o=getChiralOrHeterotopicCarbons(t);for(const e of o)if(!(i&&t.getAllConnAtoms(e)<3)&&-1===t.getStereoBond(e)){const i=t.getAtomPreferredStereoBond(e);if(-1!==i){if(t.setBondType(i,n.cBondTypeUp),t.getBondAtom(1,i)===e){const n=t.getBondAtom(0,i);t.setBondAtom(0,i,e),t.setBondAtom(1,i,n)}t.setAtomESR(e,s,0)}}}function getSymmetryRanks(t){const{Molecule:e}=t.getOCL(),n=getXAtomicNumber(t),s=t.getCompactCopy();for(let t=0;t<s.getAllAtoms();t++)1===s.getAtomicNo(t)&&s.setAtomicNo(t,n);s.ensureHelperArrays(e.cHelperSymmetryStereoHeterotopicity);const i=[];for(let e=0;e<t.getAllAtoms();e++)i.push(s.getSymmetryRank(e));return i}function makeRacemic(t){const{Molecule:e}=t.getOCL();t.ensureHelperArrays(e.cHelperCIP);for(let n=0;n<t.getAllAtoms();n++)t.getAtomParity(n)!==e.cAtomParityNone&&t.setAtomESR(n,e.cESRTypeAnd,0);t.ensureHelperArrays(e.cHelperCIP)}function tagAtom(t,e){const n=`${t.getAtomLabel(e)}*`;return t.setAtomCustomLabel(e,n),1===t.getAtomicNo(e)?t.setAtomicNo(e,getXAtomicNumber(t)):t.setAtomMass(e,t.getAtomMass(e)+5),n}function getDiastereotopicAtomIDs(t){const{Molecule:e}=t.getOCL();ensureHeterotopicChiralBonds(t);const n=getSymmetryRanks(t),s=t.getAllAtoms(),i=[],o={};for(let a=0;a<s;a++){const s=n[a];if(s&&o[s]){i[a]=o[s];continue}const r=t.getCompactCopy();tagAtom(r,a),makeRacemic(r),i[a]=r.getCanonizedIDCode(e.CANONIZER_ENCODE_ATOM_CUSTOM_LABELS),o[s]=i[a]}return i}function groupDiastereotopicAtomIDs(t,e,n={}){const{atomLabel:s}=n,i={};for(let n=0;n<t.length;n++)if(!s||e.getAtomLabel(n)===s){const s=t[n];i[s]||(i[s]={counter:0,atoms:[],oclID:s,atomLabel:e.getAtomLabel(n)}),i[s].counter++,i[s].atoms.push(n)}return Object.keys(i).map((t=>i[t]))}function getGroupedDiastereotopicAtomIDs(t,e={}){return groupDiastereotopicAtomIDs(getDiastereotopicAtomIDs(t),t,e)}function isCsp3(t,e){return 6===t.getAtomicNo(e)&&(0===t.getAtomCharge(e)&&t.getImplicitHydrogens(e)+t.getConnAtoms(e)===4)}const FULL_HOSE_CODE=1,HOSE_CODE_CUT_C_SP3_SP3=2;function getHoseCodesForAtomsInternal(t,e={}){const n=t.getOCL(),{allowedCustomLabels:s,minSphereSize:i=0,maxSphereSize:o=4,kind:a=FULL_HOSE_CODE}=e;t.ensureHelperArrays(n.Molecule.cHelperNeighbours);const r=[];for(let e=0;e<t.getAllAtoms();e++)(s?.includes(t.getAtomCustomLabel(e))||t.getAtomCustomLabel(e))&&r.push(e);const l=new n.Molecule(0,0),m=[];let c=0,u=0;const g=new Array(t.getAllAtoms()),C=new Array(t.getAllAtoms());for(let e=0;e<=o;e++){if(0===u)for(const t of r)C[u]=t,g[t]=!0,u++;else{let e=u;for(let n=c;n<u;n++){const s=C[n];for(let n=0;n<t.getAllConnAtoms(s);n++){const i=t.getConnAtom(s,n);if(!g[i])switch(a){case FULL_HOSE_CODE:g[i]=!0,C[e++]=i;break;case HOSE_CODE_CUT_C_SP3_SP3:isCsp3(t,s)&&isCsp3(t,i)||(g[i]=!0,C[e++]=i);break;default:throw new Error("getHoseCoesForAtom unknown kind")}}}c=u,u=e}t.copyMoleculeByAtoms(l,g,!0,null),e>=i&&(makeRacemic(l),m.push(l.getCanonizedIDCode(n.Molecule.CANONIZER_ENCODE_ATOM_CUSTOM_LABELS)))}return m}function floydWarshall(t){if(Matrix.isMatrix(t)&&t.columns!==t.rows)throw new TypeError("The adjacency matrix should be squared");const e=t.columns;let n=new Matrix(e,e);n.apply(((e,s)=>{if(e===s)n.set(e,s,0);else{let i=t.get(e,s);i||Object.is(i,-0)?n.set(e,s,i):n.set(e,s,Number.POSITIVE_INFINITY)}}));for(let t=0;t<e;++t)for(let s=0;s<e;++s)for(let i=0;i<e;++i){let e=n.get(s,t)+n.get(t,i);n.get(s,i)>e&&n.set(s,i,e)}return n.apply(((t,e)=>{n.get(t,e)===Number.POSITIVE_INFINITY&&n.set(t,e,-1)})),n}function getConnectivityMatrix(t,e={}){const n=t.getOCL();t.ensureHelperArrays(n.Molecule.cHelperNeighbours);const s=t.getAllAtoms();let i=new Array(s).fill();if(i=i.map((()=>new Array(s).fill(0))),!e.pathLength)if(e.atomicNo)for(let e=0;e<s;e++)i[e][e]=t.getAtomicNo(e);else if(e.negativeAtomicNo)for(let e=0;e<s;e++)i[e][e]=-t.getAtomicNo(e);else if(e.mass)for(let e=0;e<s;e++)i[e][e]=n.Molecule.cRoundedMass[t.getAtomicNo(e)];else for(let t=0;t<s;t++)i[t][t]=1;if(e.sdt)for(let e=0;e<s;e++){const n=t.getAllConnAtoms(e);for(let s=0;s<n;s++)i[e][t.getConnAtom(e,s)]=t.getConnBondOrder(e,s)}else if(e.sdta)for(let e=0;e<s;e++){const n=t.getAllConnAtoms(e);for(let s=0;s<n;s++){const n=t.getConnBond(e,s);t.isAromaticBond(n)?i[e][t.getConnAtom(e,s)]=4:i[e][t.getConnAtom(e,s)]=t.getConnBondOrder(e,s)}}else for(let e=0;e<s;e++){const n=t.getAllConnAtoms(e);for(let s=0;s<n;s++)i[e][t.getConnAtom(e,s)]=1}return e.pathLength&&(i=floydWarshall(new Matrix(i)).to2DArray()),i}function getHoseCodesFromDiastereotopicID(t,e={}){return t.addImplicitHydrogens(),ensureHeterotopicChiralBonds(t),getHoseCodesForAtomsInternal(t,e)}let fragment$1,fragment;function getHoseCodesForPath(t,e,n,s){const i=t.getOCL(),o=e,a=n,r=[];let l;(t=t.getCompactCopy()).getPath(r,e,n,s+1),4===r.length&&(l=t.calculateTorsion(r));const m=tagAtom(t,e),c=tagAtom(t,n);t.addImplicitHydrogens(),ensureHeterotopicChiralBonds(t),t.ensureHelperArrays(i.Molecule.cHelperNeighbours),e=-1,n=-1;for(let s=0;s<t.getAllAtoms();s++)m===c?t.getAtomCustomLabel(s)===m&&(-1===e?e=s:n=s):(m===t.getAtomCustomLabel(s)&&(e=s),c===t.getAtomCustomLabel(s)&&(n=s));fragment$1||(fragment$1=new i.Molecule(0,0));const u=[];t.getPath(u,e,n,s+1);let g=0,C=0;const f=new Array(t.getAllAtoms()).fill(!1),p=new Array(t.getAllAtoms()).fill(-1),h=[];for(let e=0;e<=2;e++){if(0===C)for(const t of u)f[t]=!0,p[C++]=t;else{let e=C;for(let n=g;n<C;n++){const s=p[n];for(let n=0;n<t.getAllConnAtoms(s);n++){const i=t.getConnAtom(s,n);f[i]||(f[i]=!0,p[e++]=i)}}g=C,C=e}const n=[];t.copyMoleculeByAtoms(fragment$1,f,!0,n),makeRacemic(fragment$1);const s=fragment$1.getCanonizedIDCode(i.Molecule.CANONIZER_ENCODE_ATOM_CUSTOM_LABELS);h.push({sphere:e,oclID:s})}return{atoms:r,from:o,to:a,torsion:l,hoses:h,length:r.length-1}}function getAtomsInfo(t){const e=t.getOCL();t.ensureHelperArrays(e.Molecule.cHelperRings);const n=getDiastereotopicAtomIDs(t),s=[];for(let e=0;e<n.length;e++){const i={oclID:n[e],extra:{singleBonds:0,doubleBonds:0,tripleBonds:0,aromaticBonds:0,cnoHybridation:0}},o=i.extra;s.push(i),i.abnormalValence=t.getAtomAbnormalValence(e),i.charge=t.getAtomCharge(e),i.cipParity=t.getAtomCIPParity(e),i.color=t.getAtomColor(e),i.customLabel=t.getAtomCustomLabel(e),i.atomicNo=t.getAtomicNo(e),i.label=t.getAtomLabel(e),i.mass=t.getAtomMass(e),i.radical=t.getAtomRadical(e),i.ringBondCount=t.getAtomRingBondCount(e),i.ringSize=t.getAtomRingSize(e),i.x=t.getAtomX(e),i.y=t.getAtomY(e),i.z=t.getAtomZ(e),i.allHydrogens=t.getAllHydrogens(e),i.connAtoms=t.getConnAtoms(e),i.allConnAtoms=t.getAllConnAtoms(e),i.implicitHydrogens=i.allHydrogens+i.connAtoms-i.allConnAtoms,i.isAromatic=t.isAromaticAtom(e),i.isAllylic=t.isAllylicAtom(e),i.isStereoCenter=t.isAtomStereoCenter(e),i.isRing=t.isRingAtom(e),i.isSmallRing=t.isSmallRingAtom(e),i.isStabilized=t.isStabilizedAtom(e),i.extra.singleBonds=1===i.atomicNo?0:i.implicitHydrogens;for(let n=0;n<t.getAllConnAtoms(e);n++){const s=t.getConnBond(e,n),i=t.getBondOrder(s);t.isAromaticBond(s)?o.aromaticBonds++:1===i?o.singleBonds++:2===i?o.doubleBonds++:3===i&&o.tripleBonds++}if(i.extra.totalBonds=i.extra.singleBonds+i.extra.doubleBonds+i.extra.tripleBonds+i.extra.aromaticBonds,6===i.atomicNo)i.extra.cnoHybridation=i.extra.totalBonds-1;else if(7===i.atomicNo)i.extra.cnoHybridation=i.extra.totalBonds;else if(8===i.atomicNo)i.extra.cnoHybridation=i.extra.totalBonds+1;else if(1===i.atomicNo){const n=0===t.getAllConnAtoms(e)?0:t.getAtomicNo(t.getConnAtom(e,0));i.extra.hydrogenOnAtomicNo=n,7!==n&&8!==n||(i.extra.labileHydrogen=!0)}}return s}function getPathAndTorsion(t,e,n,s){const i=[];let o;return t.getPath(i,e,n,s+1),4===i.length&&(o=t.calculateTorsion(i)),{atoms:i,from:e,to:n,torsion:o,length:i.length-1}}function getPathsInfo(t,e={}){const{fromLabel:n="H",toLabel:s="H",minLength:i=1,maxLength:o=4,withHOSES:a=!1}=e,r=t.getOCL();fragment||(fragment=new r.Molecule(0,0));const l=r.Molecule.getAtomicNoFromLabel(n),m=r.Molecule.getAtomicNoFromLabel(s),c=getAtomsInfo(t),u=getConnectivityMatrix(t,{pathLength:!0});for(let e=0;e<t.getAllAtoms();e++){c[e].paths=[];for(let n=0;n<t.getAllAtoms();n++)if(e!==n&&t.getAtomicNo(e)===l&&t.getAtomicNo(n)===m){const s=u[e][n];s>=i&&s<=o&&(a?c[e].paths.push(getHoseCodesForPath(t,e,n,s)):c[e].paths.push(getPathAndTorsion(t,e,n,s)))}}return c}const result={};for(const{value:t,multiplicity:e,names:n}of MultiplicityPatterns){e&&(result[t]=e-1);for(const t of n)e&&(result[t]=e-1)}const couplingValues=result;function joinPatterns(t,e){const n=t.reduce(((t,e)=>{if(isNaN(couplingValues[e]))throw new Error(`pattern ${e} is not in ${Object.keys(couplingValues).join(" ")}`);return t+couplingValues[e]}),0);if(!couplingPatterns[n])throw new Error(`The joined pattern from ${t.join(",")} doesn't exist`);return e?.acsFormat?couplingACSPatterns[n]:couplingPatterns[n]}const localeCompare$1=(t,e)=>t.localeCompare(e),localeCompareJcouplingKeys$1=(t,e)=>{const n=`${t.diaIDs.sort(localeCompare$1).join(" ")}`,s=`${e.diaIDs.sort(localeCompare$1).join(" ")}`;return localeCompare$1(n,s)},areThanClose=(t,e,n)=>Math.abs(t.coupling-e.coupling)<n,takeCareDiaIDs=(t,e,n)=>0===localeCompareJcouplingKeys$1(t,e)&&areThanClose(t,e,n);function signalJoinCouplings(t,e={}){const{tolerance:n=.05,ignoreDiaIDs:s=!1,acsFormat:i=!1}=e;return!t.js||t.js.length<2?t:s?(checkJs(t),groupJCouplings(t,areThanClose,{tolerance:n,acsFormat:i})):(checkJsAndDiaID(t),groupJCouplings(t,takeCareDiaIDs,{tolerance:n,acsFormat:i}))}function groupJCouplings(t,e,n){const{tolerance:s,acsFormat:i}=n;t.js.sort(((t,e)=>e.coupling-t.coupling));let o=[t.js[0]];const a=[o];for(let n=1;n<t.js.length;n++){const i=t.js[n];e(o[o.length-1],i,s)?o.push(i):(o=[i],a.push(o))}t.js=[];for(const e of a){let n="";try{n=joinPatterns(e.filter((t=>t.multiplicity)).map((t=>t.multiplicity)),{acsFormat:i})}catch{t.js.push(...e);continue}const s=xSum(e.map((t=>t.coupling)))/e.length,o=distinctValues(e.filter((t=>t.atoms)).map((t=>t.atoms)).flat()),a=distinctValues(e.filter((t=>t.assignment)).map((t=>t.assignment)).flat()).join(" "),r=distinctValues(e.filter((t=>t.diaIDs)).map((t=>t.diaIDs)).flat()),l=distinctValues(e.map((t=>t.pathLength))),m={coupling:s,multiplicity:n};1===r.length&&(m.diaIDs=r),1===l.length&&l[0]&&(m.pathLength=l[0]),a.length>0&&(m.assignment=a),o.length>0&&(m.atoms=o),t.js.push(m)}return t}function distinctValues(t){const e=new Set;for(const n of t)e.add(n);return Array.from(e)}function checkJsAndDiaID(t){if(!t.js)throw new Error("there is not js");for(const e of t.js)if(!e.diaIDs)throw new Error("there is not diaIDs")}function checkJs(t){if(!t.js)throw new Error("there is not js")}const localeCompare=(t,e)=>t.localeCompare(e),localeCompareJcouplingKeys=(t,e)=>{const n=`${t.diaIDs.join(" ")}${t.pathLength}`,s=`${e.diaIDs.join(" ")}${e.pathLength}`;return localeCompare(n,s)};function checkForMandatory$2(t){for(const e of t){if(!e.js)throw new Error("there is not js");if(!e.diaIDs)throw new Error("there is not diaIDs");for(const t of e.js){if(!t.diaIDs)throw new Error("there is not diaIDs");if(!t.pathLength)throw new Error("there is not pathLength")}}}function signalsJoin(t,e={}){checkForMandatory$2(t);const{joinCouplings:n={}}=e,{tolerance:s,ignoreDiaIDs:i}=n,o=JSON.parse(JSON.stringify(t)),a={};for(const t of o){t.js=t.js.sort(localeCompareJcouplingKeys);const e=`${t.diaIDs.join(" ")} ${t.js.map((t=>`${t.diaIDs.join(" ")} ${t.pathLength}`)).sort(localeCompare).join(" ")}`;a[e]||(a[e]=[]),a[e].push(t)}let r=[];return Object.values(a).forEach((t=>{const e=[];for(let n=0;n<t[0].js.length;n++){const s=t[0].js[n];e.push({diaIDs:s.diaIDs,pathLength:s.pathLength,multiplicity:s.multiplicity,coupling:xMean(t.map((t=>t.js[n].coupling)))})}const n={id:v4(),nbAtoms:xSum(t.map((t=>t.nbAtoms||0))),delta:xMean(t.map((t=>t.delta))),diaIDs:t[0].diaIDs,atoms:t.map((t=>t.atoms||[])).flat(),js:e},s=t.map((t=>t.assignment)).filter((t=>t)).join(" ");s.length>0&&(n.assignment=s),r.push(n)})),r=r.map((t=>{const e=signalJoinCouplings(t,{tolerance:s,ignoreDiaIDs:i});return e.js&&(e.multiplicity=e.js.length>0?e.js.map((t=>t.multiplicity)).join(""):"s"),e})).sort(((t,e)=>t.delta-e.delta)),r}function rangeFromSignal(t,e={}){const{nucleus:n="1h",frequency:s=400}=e,{tolerance:i=getTolerance(n)/s}=e;let o=0;const{js:a=[],multiplicity:r}=t;if(a.length>0)for(const t of a){const{coupling:e,multiplicity:n="d"}=t;o+=couplingValues[n]*e/s}else"m"===r?o=16/s:"b"!==r&&"br s"!==r||(o=7/s);return o=i+o/2,{from:t.delta-o,to:t.delta+o}}function getTolerance(t){switch(t.toLocaleLowerCase()){case"1h":return 1.5;case"13C":return 3;default:return 2}}function checkNbAtoms(t){for(const e of t)if(!e.nbAtoms)throw new Error("nbAtoms is mandatory")}function signalsToRanges(t,e={}){checkNbAtoms(t);const{tolerance:n=.05,frequency:s=400}=e;let i=t.map((t=>({original:t})));i.forEach((t=>{const e=rangeFromSignal(t.original,{frequency:s,tolerance:n});t.from=e.from,t.to=e.to})),i=i.sort(((t,e)=>t.from-e.from));const o=[];let a={};for(const t of i)void 0===a.from||t.from>a.to?(a={id:v4(),from:t.from,to:t.to,integration:t.original.nbAtoms,signals:[t.original]},o.push(a)):(a.integration+=t.original.nbAtoms,t.to>a.to&&(a.to=t.to),a.signals.push(t.original));return o}function isEmptyMolecule(t){return t.getAllAtoms()<1}async function predictProton(t,e={}){if(isEmptyMolecule(t))return{molfile:t.toMolfile(),nucleus:"13C",diaIDs:[],joinedSignals:[],signals:[],ranges:[],molecule:t};const{cache:n}=e;(t=t.getCompactCopy()).addImplicitHydrogens(),ensureHeterotopicChiralBonds(t);const s=t.toMolfile();let i;if(n&&(i=n(s)),void 0===i){const t=new FormData$1;t.append("molfile",s);const e=await fetch("https://www.nmrdb.org/service/predictor",{method:"POST",body:t});i=await e.text(),n&&n(s,i)}const{diaIDs:o=getDiastereotopicAtomIDs(t)}=e,a=protonParser(i,t,o),r=signalsJoin(a);return{molfile:s,diaIDs:o,nucleus:"1H",joinedSignals:r,signals:a,ranges:signalsToRanges(r),molecule:t}}function protonParser(t,e,n){if(0===e.getAllAtoms())return[];if(t.includes("ERR"))throw Error(`Spinus optimization: ${t}`);const s=getConnectivityMatrix(e,{pathLength:!0}),i=t.split("\n").filter((t=>t)),o=[];for(const t of i){const e=t.split("\t"),i=e.slice(4),a=Number(e[0])-1,r={id:v4(),atoms:[a],diaIDs:[n[a]],nbAtoms:1,delta:Number(e[2]),js:[]};if(!r.js)throw new Error("For atom js property was not added");for(let t=0;t<i.length;t+=3){const e=Number(i[t])-1;r.js.push({coupling:Number(i[t+2]),atoms:[e],diaIDs:[n[e]],multiplicity:"d",pathLength:s[a][e]}),r.js.sort(((t,e)=>e.coupling-t.coupling))}o.push(r)}return o}const{parse:parse$3,stringify:stringify$3}=JSON;function setIDs(t,e={}){const n=e.output||parse$3(stringify$3(t));for(const t of n)t.id=v4();return n}async function fetchPrediction(t,e){const{webserviceURL:n}=e,s=await fetch(n,{headers:{accept:"application/json","content-type":"application/json"},body:JSON.stringify({molfile:t.toMolfile()}),method:"POST"});if(s.status>=400)throw new Error(s.statusText);const i=(await s.json()).data;return i.molecule=t.getOCL().Molecule.fromMolfile(i.molfile),i}function getFilteredIDiaIDs(t,e){const{maxSphereSize:n,diaIDs:s}=e;t.addImplicitHydrogens(),t.addMissingChirality(),ensureHeterotopicChiralBonds(t);const i=t.toMolfile(),o=groupDiastereotopicAtomIDs(s,t,{atomLabel:"C"}).sort(((t,e)=>t.atomLabel===e.atomLabel?e.counter-t.counter:t.atomLabel<e.atomLabel?1:-1)),a=t.getOCL();for(const t of o)t.hose=getHoseCodesFromDiastereotopicID(a.Molecule.fromIDCode(t.oclID),{maxSphereSize:n});return{molfile:i,carbonDiaIDs:o}}function queryByHose(t,e,n){const{maxSphereSize:s}=n,i=[];for(const n of t){let t,o=null;for(let i=s;!t&&i>=0;i--)e[i]&&(t=e[i][n.hose[i]],o=i);for(const e of n.atoms){const s={diaIDs:[n.oclID],delta:t?t[0]:null,atoms:[e],nbAtoms:1,level:o,statistic:t&&t.length>1?{mean:t[1],sd:t[2],min:t[3],max:t[4],nb:t[5]}:void 0};i.push(s)}}return i}function checkFromPrediction(t){if(!t.atoms)throw new Error("There is not atoms");if(!t.diaIDs)throw new Error("There is not diaIDs");if(!t.nbAtoms)throw new Error("There is not nbAtoms")}async function predictCarbon(t,e={}){if(isEmptyMolecule(t))return{molfile:t.toMolfile(),nucleus:"13C",diaIDs:[],joinedSignals:[],signals:[],ranges:[],molecule:t};const{database:n,webserviceURL:s="https://nmr-prediction.service.zakodium.com/v1/predict/carbon",diaIDs:i=getDiastereotopicAtomIDs(t)}=e;if(!n)return fetchPrediction(t,{webserviceURL:s});if(!n)throw new Error("There is not a database");const o=n.length-1;let{maxSphereSize:a=o}=e;a>o&&(a=o);const{carbonDiaIDs:r,molfile:l}=getFilteredIDiaIDs(t,{maxSphereSize:a,diaIDs:i}),m=formatSignals(queryByHose(r,n,{maxSphereSize:a})),c=joinSignalByDiaID(m);return{molfile:l,nucleus:"13C",diaIDs:i,joinedSignals:c,signals:m,ranges:signalsToRanges(c),molecule:t}}function formatSignals(t){const e=[];for(const n of t){const{atoms:t,nbAtoms:s,delta:i,diaIDs:o,statistic:a}=n,r={id:v4(),delta:i||NaN,atoms:t,diaIDs:o,multiplicity:"s",nbAtoms:s,statistic:a,js:[]};e.push(r)}return e}function joinSignalByDiaID(t){const e={};for(const n of t){checkFromPrediction(n);const t=n.diaIDs[0];e[t]?(e[t].nbAtoms+=n.nbAtoms,e[t].atoms.push(...n.atoms)):e[t]=JSON.parse(JSON.stringify(n))}return setIDs(Object.values(e))}function squaredEuclidean(t,e){let n=0;for(let s=0;s<t.length;s++)n+=(t[s]-e[s])*(t[s]-e[s]);return n}function euclidean(t,e){return Math.sqrt(squaredEuclidean(t,e))}function distanceMatrix(t,e){const n=getMatrix(t.length);for(let s=0;s<t.length;s++)for(let i=0;i<=s;i++)n[s][i]=e(t[s],t[i]),n[i][s]=n[s][i];return n}function getMatrix(t){const e=[];for(let n=0;n<t;n++){const n=[];e.push(n);for(let e=0;e<t;e++)n.push(0)}return e}var heap$1={exports:{}};!function(t,e){(function(){var e,n,s,i,o,a,r,l,m,c,u,g,C,f,p;s=Math.floor,c=Math.min,n=function(t,e){return t<e?-1:t>e?1:0},m=function(t,e,i,o,a){var r;if(null==i&&(i=0),null==a&&(a=n),i<0)throw new Error("lo must be non-negative");for(null==o&&(o=t.length);i<o;)a(e,t[r=s((i+o)/2)])<0?o=r:i=r+1;return[].splice.apply(t,[i,i-i].concat(e)),e},a=function(t,e,s){return null==s&&(s=n),t.push(e),f(t,0,t.length-1,s)},o=function(t,e){var s,i;return null==e&&(e=n),s=t.pop(),t.length?(i=t[0],t[0]=s,p(t,0,e)):i=s,i},l=function(t,e,s){var i;return null==s&&(s=n),i=t[0],t[0]=e,p(t,0,s),i},r=function(t,e,s){var i;return null==s&&(s=n),t.length&&s(t[0],e)<0&&(e=(i=[t[0],e])[0],t[0]=i[1],p(t,0,s)),e},i=function(t,e){var i,o,a,r,l,m;for(null==e&&(e=n),l=[],o=0,a=(r=function(){m=[];for(var e=0,n=s(t.length/2);0<=n?e<n:e>n;0<=n?e++:e--)m.push(e);return m}.apply(this).reverse()).length;o<a;o++)i=r[o],l.push(p(t,i,e));return l},C=function(t,e,s){var i;if(null==s&&(s=n),-1!==(i=t.indexOf(e)))return f(t,0,i,s),p(t,i,s)},u=function(t,e,s){var o,a,l,m,c;if(null==s&&(s=n),!(a=t.slice(0,e)).length)return a;for(i(a,s),l=0,m=(c=t.slice(e)).length;l<m;l++)o=c[l],r(a,o,s);return a.sort(s).reverse()},g=function(t,e,s){var a,r,l,u,g,C,f,p,h;if(null==s&&(s=n),10*e<=t.length){if(!(l=t.slice(0,e).sort(s)).length)return l;for(r=l[l.length-1],u=0,C=(f=t.slice(e)).length;u<C;u++)s(a=f[u],r)<0&&(m(l,a,0,null,s),l.pop(),r=l[l.length-1]);return l}for(i(t,s),h=[],g=0,p=c(e,t.length);0<=p?g<p:g>p;0<=p?++g:--g)h.push(o(t,s));return h},f=function(t,e,s,i){var o,a,r;for(null==i&&(i=n),o=t[s];s>e&&i(o,a=t[r=s-1>>1])<0;)t[s]=a,s=r;return t[s]=o},p=function(t,e,s){var i,o,a,r,l;for(null==s&&(s=n),o=t.length,l=e,a=t[e],i=2*e+1;i<o;)(r=i+1)<o&&!(s(t[i],t[r])<0)&&(i=r),t[e]=t[i],i=2*(e=i)+1;return t[e]=a,f(t,l,e,s)},e=function(){function t(t){this.cmp=null!=t?t:n,this.nodes=[]}return t.push=a,t.pop=o,t.replace=l,t.pushpop=r,t.heapify=i,t.updateItem=C,t.nlargest=u,t.nsmallest=g,t.prototype.push=function(t){return a(this.nodes,t,this.cmp)},t.prototype.pop=function(){return o(this.nodes,this.cmp)},t.prototype.peek=function(){return this.nodes[0]},t.prototype.contains=function(t){return-1!==this.nodes.indexOf(t)},t.prototype.replace=function(t){return l(this.nodes,t,this.cmp)},t.prototype.pushpop=function(t){return r(this.nodes,t,this.cmp)},t.prototype.heapify=function(){return i(this.nodes,this.cmp)},t.prototype.updateItem=function(t){return C(this.nodes,t,this.cmp)},t.prototype.clear=function(){return this.nodes=[]},t.prototype.empty=function(){return 0===this.nodes.length},t.prototype.size=function(){return this.nodes.length},t.prototype.clone=function(){var e;return(e=new t).nodes=this.nodes.slice(0),e},t.prototype.toArray=function(){return this.nodes.slice(0)},t.prototype.insert=t.prototype.push,t.prototype.top=t.prototype.peek,t.prototype.front=t.prototype.peek,t.prototype.has=t.prototype.contains,t.prototype.copy=t.prototype.clone,t}(),t.exports=e}).call(commonjsGlobal)}(heap$1);var heap=heap$1.exports,Heap=heap;class Cluster{constructor(){this.children=[],this.height=0,this.size=1,this.index=-1,this.isLeaf=!1}cut(t){if("number"!=typeof t)throw new TypeError("threshold must be a number");if(t<0)throw new RangeError("threshold must be a positive number");let e=[this];const n=[];for(;e.length>0;){const s=e.shift();t>=s.height?n.push(s):e=e.concat(s.children)}return n}group(t){if(!Number.isInteger(t)||t<1)throw new RangeError("groups must be a positive integer");const e=new Heap(((t,e)=>e.height-t.height));for(e.push(this);e.size()<t;){const t=e.pop();if(0===t.children.length)break;t.children.forEach((t=>e.push(t)))}const n=new Cluster;return n.children=e.toArray(),n.height=this.height,n}traverse(t){!function t(e,n){if(n(e),e.children)for(const s of e.children)t(s,n)}(this,t)}indices(){const t=[];return this.traverse((e=>{e.isLeaf&&t.push(e.index)})),t}}function singleLink(t,e){return Math.min(t,e)}function completeLink(t,e){return Math.max(t,e)}function averageLink(t,e,n,s,i){return s/(s+i)*t+i/(s+i)*e}function weightedAverageLink(t,e){return(t+e)/2}function centroidLink(t,e,n,s,i){return s/(s+i)*t+i/(s+i)*e+-s*i/(s+i)**2*n}function medianLink(t,e,n){return t/2+e/2-n/4}function wardLink(t,e,n,s,i,o){return(s+o)/(s+i+o)*t+(i+o)/(s+i+o)*e+-o/(s+i+o)*n}function wardLink2(t,e,n,s,i,o){const a=(s+o)/(s+i+o),r=(i+o)/(s+i+o),l=-o/(s+i+o);return Math.sqrt(a*t*t+r*e*e+l*n*n)}function agnes(t,e={}){const{distanceFunction:n=euclidean,method:s="complete",isDistanceMatrix:i=!1}=e;let o;i||(t=distanceMatrix(t,n));let a=new Matrix(t);const r=a.rows;if("string"==typeof s)switch(s.toLowerCase()){case"single":o=singleLink;break;case"complete":o=completeLink;break;case"average":case"upgma":o=averageLink;break;case"wpgma":o=weightedAverageLink;break;case"centroid":case"upgmc":o=centroidLink;break;case"median":case"wpgmc":o=medianLink;break;case"ward":o=wardLink;break;case"ward2":o=wardLink2;break;default:throw new RangeError(`unknown clustering method: ${s}`)}else if("function"!=typeof s)throw new TypeError("method must be a string or function");let l=[];for(let t=0;t<r;t++){const e=new Cluster;e.isLeaf=!0,e.index=t,l.push(e)}for(let t=0;t<r-1;t++){const[t,e,n]=getSmallestDistance(a),s=l[t],i=l[e],r=new Cluster;r.size=s.size+i.size,r.children.push(s,i),r.height=n;const m=[r],c=new Matrix(a.rows-1,a.rows-1),u=n=>getPreviousIndex(n,Math.min(t,e),Math.max(t,e));for(let r=1;r<c.rows;r++){const g=u(r),C=l[g];m.push(C);for(let l=0;l<r;l++)if(0===l){const m=o(a.get(t,g),a.get(g,e),n,s.size,i.size,C.size);c.set(r,l,m),c.set(l,r,m)}else{const t=a.get(g,u(l));c.set(r,l,t),c.set(l,r,t)}}l=m,a=c}return l[0]}function getSmallestDistance(t){let e=1/0,n=0,s=0;for(let i=1;i<t.rows;i++)for(let o=0;o<i;o++)t.get(i,o)<e&&(e=t.get(i,o),n=i,s=o);return[n,s,e]}function getPreviousIndex(t,e,n){return(t-=1)>=e&&t++,t>=n&&t++,t}const nucleusMap={h:"1H",c:"13C"};function getNuclei(t){return Object.values(t).map((t=>nucleusMap[t.toLowerCase()]))}async function getPredictions(t,e,n,s,i){let o;if(i?.[t])o=i[t];else if(s){const i=s[t];o=i?await i(e,n[t]):void 0}return o}function checkFromTo(t){if(!t.from||!t.to)throw new Error("options from and to are mandatory")}async function predict2D(t,e={}){checkFromTo(e),t.addImplicitHydrogens();const{from:n,to:s,diaIDs:i,minLength:o=0,maxLength:a,predictOptions:r={},predictions:l,predictor:m,joinDistance:c={H:.05,C:.5},includeDiagonal:u=!1}=e,g=getPathsInfo(t,{fromLabel:n,toLabel:s,minLength:o,maxLength:a}),C=i?groupDiastereotopicAtomIDs(i,t):getGroupedDiastereotopicAtomIDs(t),f=[];for(const t of C)f.push({...t,pathInfo:JSON.parse(JSON.stringify(g[t.atoms[0]]))});const p=await getPredictions(n,t,r,m,l),h=n===s?p:await getPredictions(s,t,r,m,l);if(!p||!h)throw new Error("predictions are not availaible");const d={x:p,y:h},y={x:{},y:{}};for(const t in y)for(const e of d[t].joinedSignals){if(!e.diaIDs)throw new Error("Signal has not diaIDs");y[t][e.diaIDs[0]]=e}const H={};for(const t of f){const e=t.pathInfo;if(e.paths.length<1)continue;if(!y.x[e.oclID])continue;const n=e.paths;for(const t of n){if(!y.y[g[t.to].oclID])continue;const n={x:e,y:g[t.to]},s=`${n.x.oclID}-${n.y.oclID}`;if(s===`${e.oclID}-${e.oclID}`||H[s])continue;const i={id:v4(),z:100},o={id:v4(),x:{},y:{}};for(const t in n){const e=n[t].oclID;i[t]=y[t][e].delta,o[t].delta=y[t][e].delta,o[t].diaIDs=[e],o[t].atoms=y[t][e].atoms}o.peaks=[i],H[s]=o}}u&&addSelftCorrelation(H,{paths:g,signalsByDiaID:y});const b=Object.values(H),v=createZones(b,{joinDistance:c,from:n,to:s});return{molfile:t.toMolfile(),diaIDs:d.x.diaIDs,nuclei:getNuclei({from:n,to:s}),joinedSignals:b,signals:splitSignals(b),zones:v,molecule:t}}function splitSignals(t){const e=[];for(const n of t)for(const t of n.x.atoms||[])for(const s of n.y.atoms||[]){const i=JSON.parse(JSON.stringify(n));i.x.atoms=[t],i.y.atoms=[s],e.push(i)}return setIDs(e)}function addSelftCorrelation(t,e){const{paths:n=[],signalsByDiaID:s}=e;for(const e of n){if(e.paths.length<1)continue;const n=e.oclID;if(!s.x[n])continue;if(t[`${n}-${n}`])continue;const i={x:{},y:{}},o={z:1};for(const t of["x","y"])o[t]=s[t][n].delta,i[t].delta=s[t][n].delta,i[t].diaIDs=[n],i[t].atoms=s[t][n].atoms;i.peaks=[o],t[`${e.oclID}-${e.oclID}`]=i}}function createZones(t,e){if(t.length<1)return[];const{joinDistance:n,from:s,to:i}=e,o=new Matrix(t.map((t=>[t.x.delta,t.y.delta]))),a=o.minColumn(0),r=o.maxColumn(0),l=o.minColumn(1),m=o.maxColumn(1);o.mulColumn(0,1/(r-a)),o.mulColumn(1,1/(m-l));const c=Math.sqrt(Math.pow(n[s]/(r-a),2)+Math.pow(n[i]/(m-l),2)),u=splitClusters([agnes(o.to2DArray(),{method:"centroid"})],c),g=[];for(const e of u){const o=[];e.isLeaf&&o.push(t[e.index]);for(const n of e.children)for(const e of n.indices())o.push(t[e]);g.push({id:v4(),...fromTo$1(o,{joinDistance:n,from:s,to:i}),signals:o})}return g}function fromTo$1(t,e){const{joinDistance:n,from:s,to:i}=e;let o=Number.MAX_SAFE_INTEGER,a=Number.MAX_SAFE_INTEGER,r=Number.MIN_SAFE_INTEGER,l=Number.MIN_SAFE_INTEGER;for(const e of t)e.x.delta<o&&(o=e.x.delta),e.x.delta>r&&(r=e.x.delta),e.y.delta<a&&(a=e.y.delta),e.y.delta>l&&(l=e.y.delta);return{x:{from:o-n[s],to:r+n[s]},y:{from:a-n[i],to:l+n[i]}}}function splitClusters(t,e){const n=t.length;for(let n=0;n<t.length;n++){const s=t[n];s.height>e&&(t.push(...s.children),t.splice(n--,1))}return t.length<n?splitClusters(t,e):t}async function predictCOSY(t,e={}){const{minLength:n=2,maxLength:s=3,predictions:i,predictor:o={H:predictProton},predictOptions:a,joinDistance:r={H:.05,C:.5},includeDiagonal:l=!0}=e;return predict2D(t,{from:"H",to:"H",predictor:o,minLength:n,maxLength:s,joinDistance:r,predictions:i,includeDiagonal:l,predictOptions:a})}async function predictHSQC(t,e={}){const{minLength:n=1,maxLength:s=1,predictor:i={H:predictProton,C:predictCarbon},predictions:o,joinDistance:a={H:.05,C:.5},predictOptions:r}=e;return predict2D(t,{from:"H",to:"C",predictor:i,minLength:n,maxLength:s,predictions:o,predictOptions:r,joinDistance:a})}async function predictHMBC(t,e={}){const{minLength:n=2,maxLength:s=3,predictor:i={H:predictProton,C:predictCarbon},predictOptions:o,predictions:a,joinDistance:r={H:.05,C:.5}}=e;return predict2D(t,{from:"H",to:"C",predictor:i,minLength:n,maxLength:s,predictions:a,predictOptions:o,joinDistance:r})}async function predictAll(t,e={}){const{logger:n,predictor:s={H:predictProton,C:predictCarbon},joinDistance:i={H:.05,C:.5},predictOptions:o={}}=e,a=getDiastereotopicAtomIDs(t);let{predictions:r}=e;const l=await getPredictions("H",t,o,s,r),m=await getPredictions("C",t,o,s,r);if(!l||!m)throw new Error("predictions are not availaible");const c={};check1DPrediction(l)&&(c.proton=l),check1DPrediction(m)&&(c.carbon=m);const{molfile:u}=l;r={H:l,C:m},c.proton?c.cosy=await predictCOSY(t,{predictions:r,joinDistance:i}):n&&n.warn("Proton prediction is missing so COSY could not be generated."),c.carbon&&c.proton?(c.hsqc=await predictHSQC(t,{predictions:r,joinDistance:i}),c.hmbc=await predictHMBC(t,{predictions:r,joinDistance:i})):n&&n.warn("Carbon and / or proton prediction is missing so HSQC and HMBC could not be generated.");for(const t in c)delete c[t].molfile,delete c[t].diaIDs;return{molfile:u,diaIDs:a,spectra:c}}function check1DPrediction(t){if(!t)return!1;if(0===t.ranges.length)return!1;const{signals:e,diaIDs:n}=t;for(const t of e){const e=t.diaIDs?.every((t=>n.includes(t)));if(!e)return!1}return!0}function signals2DToZ(t,e={}){const{from:n=-1,to:s=12,nbPoints:i=512,factor:o=3}=e;let{width:a=.02}=e;const r=t.reduce(((t,{x:e,y:n})=>(t.x.push(e.delta),t.y.push(n.delta),t.z.push(1e6),t)),{x:[],y:[],z:[]});return a=ensureXYNumber(a),generateSpectrum2D(mergeClosePeaks(r),{generator:{from:ensureXYNumber(n),to:ensureXYNumber(s),nbPoints:ensureXYNumber(i)},peaks:{width:a,factor:o}})}function ensureXYNumber(t){return"object"!=typeof t?{x:t,y:t}:{...t}}function mergeClosePeaks(t){const e=JSON.parse(JSON.stringify(t));for(let t=0;t<e.x.length;t++)for(let n=t+1;n<e.x.length;n++)e.x[t]===e.x[n]&&e.y[t]===e.y[n]&&(e.z[t]+=e.z[n],e.x.splice(n,1),e.y.splice(n,1),e.z.splice(n,1),n--);return e}const defOptions={threshold:0,out:"assignment"};var src$2=function(t,e){const n=Object.assign({},defOptions,e);var s,i;if("number"==typeof t[0])s=fullClusterGeneratorVector(t);else if("object"==typeof t[0]){for(var o=t.length,a=new Array(o*(o+1)/2),r=0,l=0;l<o;l++)for(var m=l;m<o;m++)t[l][m]>n.threshold?a[r++]=1:a[r++]=0;s=fullClusterGeneratorVector(a)}if("indexes"===n.out||"values"===n.out){var c=new Array(s.length);for(l=0;l<s.length;l++)for(c[l]=[],m=0;m<s[l].length;m++)0!=s[l][m]&&c[l].push(m);if("values"===n.out){var u=new Array(c.length);for(l=0;l<c.length;l++)for(u[l]=new Array(c[l].length),m=0;m<c[l].length;m++)for(u[l][m]=new Array(c[l].length),i=0;i<c[l].length;i++)u[l][m][i]=t[c[l][m]][c[l][i]];return u}return c}return s};function fullClusterGeneratorVector(t){var e=Math.sqrt(2*t.length+.25)-.5,n=[],s=new Array(e),i=e,o=0,a=[];for(o=e-1;o>=0;o--)s[o]=1;for(var r=-1,l=[];i>0;){if(0===l.length){for(a=new Array(e),o=0;o<e;o++)a[o]=0;for(n.push(a),r=0;0==s[r];r++);}else r=l.splice(0,1);a[r]=1,s[r]=0,i--;var m=new Array(e);for(o=0;o<e;o++){var c=Math.max(r,o),u=Math.min(r,o);m[o]=t[u*(2*e-u-1)/2+c],1==m[o]&&1==s[o]&&0==a[o]&&(l.push(o),a[o]=1)}}return n}var simpleClustering=src$2;function ensureSpinSystemProps(t){const{couplingConstants:e,connectivity:n}=t,s=Matrix.checkMatrix(e),i=n?Matrix.checkMatrix(n):connectivityMatrixFromCouplingMatrix(s),{levels:o=new Array(i.rows).fill(2),clusters:a=simpleClustering(i.to2DArray(),{out:"indexes"})}=t;return{...t,levels:o,clusters:a,connectivity:i,couplingConstants:s}}function connectivityMatrixFromCouplingMatrix(t){const e=Matrix.ones(t.rows,t.rows);for(let n=0;n<t.rows;n++)for(let s=n;s<t.columns;s++)0===t.get(n,s)&&(e.set(n,s,0),e.set(s,n,0));return e}function checkForMandatory$1(t){for(const e of t){if(!e.js)throw new Error("there is not js");if(!e.atoms)throw new Error("there is not atoms");for(const t of e.js)if(!t.atoms)throw new Error("there is not atoms")}}function signalsToSpinSystem(t){checkForMandatory$1(t);const e=t.length,n=new Array(e),s=Matrix.zeros(e,e),i={};for(let s=0;s<e;s++){n[s]=t[s].delta;i[t[s].atoms[0]]=s}for(let n=0;n<e;n++){const{atoms:e,js:o}=t[n],a=e[0];for(const t of o){const{coupling:e,atoms:n}=t,o=n[0];s.set(i[a],i[o],e),s.set(i[o],i[a],e)}}return ensureSpinSystemProps({couplingConstants:s,chemicalShifts:n})}var binarySearch=function(t,e,n,s,i){var o,a;if(void 0===s)s=0;else if((s|=0)<0||s>=t.length)throw new RangeError("invalid lower bound");if(void 0===i)i=t.length-1;else if((i|=0)<s||i>=t.length)throw new RangeError("invalid upper bound");for(;s<=i;)if((a=+n(t[o=s+(i-s>>>1)],e,o,t))<0)s=o+1;else{if(!(a>0))return o;i=o-1}return~s},binarySearch$1=binarySearch,numSort={};function assertNumber(t){if("number"!=typeof t)throw new TypeError("Expected a number")}var ascending=numSort.ascending=(t,e)=>(assertNumber(t),assertNumber(e),Number.isNaN(t)?-1:Number.isNaN(e)?1:t-e);numSort.descending=(t,e)=>(assertNumber(t),assertNumber(e),Number.isNaN(t)?1:Number.isNaN(e)?-1:e-t);const largestPrime=2147483647,primeNumbers=[largestPrime,5,11,23,47,97,197,397,797,1597,3203,6421,12853,25717,51437,102877,205759,411527,823117,1646237,3292489,6584983,13169977,26339969,52679969,105359939,210719881,421439783,842879579,1685759167,433,877,1759,3527,7057,14143,28289,56591,113189,226379,452759,905551,1811107,3622219,7244441,14488931,28977863,57955739,115911563,231823147,463646329,927292699,1854585413,953,1907,3821,7643,15287,30577,61169,122347,244703,489407,978821,1957651,3915341,7830701,15661423,31322867,62645741,125291483,250582987,501165979,1002331963,2004663929,1039,2081,4177,8363,16729,33461,66923,133853,267713,535481,1070981,2141977,4283963,8567929,17135863,34271747,68543509,137087021,274174111,548348231,1096696463,31,67,137,277,557,1117,2237,4481,8963,17929,35863,71741,143483,286973,573953,1147921,2295859,4591721,9183457,18366923,36733847,73467739,146935499,293871013,587742049,1175484103,599,1201,2411,4831,9677,19373,38747,77509,155027,310081,620171,1240361,2480729,4961459,9922933,19845871,39691759,79383533,158767069,317534141,635068283,1270136683,311,631,1277,2557,5119,10243,20507,41017,82037,164089,328213,656429,1312867,2625761,5251529,10503061,21006137,42012281,84024581,168049163,336098327,672196673,1344393353,3,7,17,37,79,163,331,673,1361,2729,5471,10949,21911,43853,87719,175447,350899,701819,1403641,2807303,5614657,11229331,22458671,44917381,89834777,179669557,359339171,718678369,1437356741,43,89,179,359,719,1439,2879,5779,11579,23159,46327,92657,185323,370661,741337,1482707,2965421,5930887,11861791,23723597,47447201,94894427,189788857,379577741,759155483,1518310967,379,761,1523,3049,6101,12203,24407,48817,97649,195311,390647,781301,1562611,3125257,6250537,12501169,25002389,50004791,100009607,200019221,400038451,800076929,1600153859,13,29,59,127,257,521,1049,2099,4201,8419,16843,33703,67409,134837,269683,539389,1078787,2157587,4315183,8630387,17260781,34521589,69043189,138086407,276172823,552345671,1104691373,19,41,83,167,337,677,1361,2729,5471,10949,21911,43853,87719,175447,350899,701819,1403641,2807303,5614657,11229331,22458671,44917381,89834777,179669557,359339171,718678369,1437356741,53,107,223,449,907,1823,3659,7321,14653,29311,58631,117269,234539,469099,938207,1876417,3752839,7505681,15011389,30022781,60045577,120091177,240182359,480364727,960729461,1921458943];function nextPrime(t){let e=binarySearch$1(primeNumbers,t,ascending);return e<0&&(e=~e),primeNumbers[e]}primeNumbers.sort(ascending);const FREE=0,FULL=1,REMOVED=2,defaultInitialCapacity=150,defaultMinLoadFactor=1/6,defaultMaxLoadFactor=2/3;class HashTable{constructor(t={}){if(t instanceof HashTable)return this.table=t.table.slice(),this.values=t.values.slice(),this.state=t.state.slice(),this.minLoadFactor=t.minLoadFactor,this.maxLoadFactor=t.maxLoadFactor,this.distinct=t.distinct,this.freeEntries=t.freeEntries,this.lowWaterMark=t.lowWaterMark,void(this.highWaterMark=t.maxLoadFactor);const e=void 0===t.initialCapacity?defaultInitialCapacity:t.initialCapacity;if(e<0)throw new RangeError(`initial capacity must not be less than zero: ${e}`);const n=void 0===t.minLoadFactor?defaultMinLoadFactor:t.minLoadFactor,s=void 0===t.maxLoadFactor?defaultMaxLoadFactor:t.maxLoadFactor;if(n<0||n>=1)throw new RangeError(`invalid minLoadFactor: ${n}`);if(s<=0||s>=1)throw new RangeError(`invalid maxLoadFactor: ${s}`);if(n>=s)throw new RangeError(`minLoadFactor (${n}) must be smaller than maxLoadFactor (${s})`);let i=e;i=i/s|0,i=nextPrime(i),0===i&&(i=1),this.table=newArray(i),this.values=newArray(i),this.state=newArray(i),this.minLoadFactor=n,this.maxLoadFactor=i===largestPrime?1:s,this.distinct=0,this.freeEntries=i,this.lowWaterMark=0,this.highWaterMark=chooseHighWaterMark(i,this.maxLoadFactor)}clone(){return new HashTable(this)}get size(){return this.distinct}get(t){const e=this.indexOfKey(t);return e<0?0:this.values[e]}set(t,e){let n=this.indexOfInsertion(t);if(n<0)return n=-n-1,this.values[n]=e,!1;if(this.distinct>this.highWaterMark){const n=chooseGrowCapacity(this.distinct+1,this.minLoadFactor,this.maxLoadFactor);return this.rehash(n),this.set(t,e)}if(this.table[n]=t,this.values[n]=e,this.state[n]===FREE&&this.freeEntries--,this.state[n]=FULL,this.distinct++,this.freeEntries<1){const t=chooseGrowCapacity(this.distinct+1,this.minLoadFactor,this.maxLoadFactor);this.rehash(t)}return!0}remove(t,e){const n=this.indexOfKey(t);return!(n<0)&&(this.state[n]=REMOVED,this.distinct--,e||this.maybeShrinkCapacity(),!0)}delete(t,e){const n=this.indexOfKey(t);return!(n<0)&&(this.state[n]=FREE,this.distinct--,e||this.maybeShrinkCapacity(),!0)}maybeShrinkCapacity(){if(this.distinct<this.lowWaterMark){const t=chooseShrinkCapacity(this.distinct,this.minLoadFactor,this.maxLoadFactor);this.rehash(t)}}containsKey(t){return this.indexOfKey(t)>=0}indexOfKey(t){const e=this.table,n=this.state,s=this.table.length,i=2147483647&t;let o=i%s,a=i%(s-2);for(0===a&&(a=1);n[o]!==FREE&&(n[o]===REMOVED||e[o]!==t);)o-=a,o<0&&(o+=s);return n[o]===FREE?-1:o}containsValue(t){return this.indexOfValue(t)>=0}indexOfValue(t){const e=this.values,n=this.state;for(var s=0;s<n.length;s++)if(n[s]===FULL&&e[s]===t)return s;return-1}indexOfInsertion(t){const e=this.table,n=this.state,s=e.length,i=2147483647&t;let o=i%s,a=i%(s-2);for(0===a&&(a=1);n[o]===FULL&&e[o]!==t;)o-=a,o<0&&(o+=s);if(n[o]===REMOVED){const i=o;for(;n[o]!==FREE&&(n[o]===REMOVED||e[o]!==t);)o-=a,o<0&&(o+=s);n[o]===FREE&&(o=i)}return n[o]===FULL?-o-1:o}ensureCapacity(t){if(this.table.length<t){const e=nextPrime(t);this.rehash(e)}}rehash(t){const e=this.table.length;if(t<=this.distinct)throw new Error("Unexpected");const n=this.table,s=this.values,i=this.state,o=newArray(t),a=newArray(t),r=newArray(t);this.lowWaterMark=chooseLowWaterMark(t,this.minLoadFactor),this.highWaterMark=chooseHighWaterMark(t,this.maxLoadFactor),this.table=o,this.values=a,this.state=r,this.freeEntries=t-this.distinct;for(var l=0;l<e;l++)if(i[l]===FULL){var m=n[l],c=this.indexOfInsertion(m);o[c]=m,a[c]=s[l],r[c]=FULL}}forEachKey(t){for(var e=0;e<this.state.length;e++)if(this.state[e]===FULL&&!t(this.table[e]))return!1;return!0}forEachValue(t){for(var e=0;e<this.state.length;e++)if(this.state[e]===FULL&&!t(this.values[e]))return!1;return!0}forEachPair(t){for(var e=0;e<this.state.length;e++)if(this.state[e]===FULL&&!t(this.table[e],this.values[e]))return!1;return!0}}function chooseLowWaterMark(t,e){return t*e|0}function chooseHighWaterMark(t,e){return Math.min(t-2,t*e|0)}function chooseGrowCapacity(t,e,n){return nextPrime(Math.max(t+1,4*t/(3*e+n)|0))}function chooseShrinkCapacity(t,e,n){return nextPrime(Math.max(t+1,4*t/(e+3*n)|0))}function newArray(t){return Array(t).fill(0)}class SparseMatrix{constructor(t,e,n={}){if(t instanceof SparseMatrix){const e=t;this._init(e.rows,e.columns,e.elements.clone(),e.threshold)}else if(Array.isArray(t)){const s=t;t=s.length,n=e||{},e=s[0].length,this._init(t,e,new HashTable(n),n.threshold);for(let n=0;n<t;n++)for(let t=0;t<e;t++){let i=s[n][t];this.threshold&&Math.abs(i)<this.threshold&&(i=0),0!==i&&this.elements.set(n*e+t,s[n][t])}}else this._init(t,e,new HashTable(n),n.threshold)}_init(t,e,n,s){this.rows=t,this.columns=e,this.elements=n,this.threshold=s||0}static eye(t=1,e=t){const n=Math.min(t,e),s=new SparseMatrix(t,e,{initialCapacity:n});for(let t=0;t<n;t++)s.set(t,t,1);return s}clone(){return new SparseMatrix(this)}to2DArray(){const t=new Array(this.rows);for(let e=0;e<this.rows;e++){t[e]=new Array(this.columns);for(let n=0;n<this.columns;n++)t[e][n]=this.get(e,n)}return t}isSquare(){return this.rows===this.columns}isSymmetric(){if(!this.isSquare())return!1;let t=!0;return this.forEachNonZero(((e,n,s)=>this.get(n,e)!==s?(t=!1,!1):s)),t}bandWidth(){let t=this.columns,e=-1;return this.forEachNonZero(((n,s,i)=>{let o=n-s;return t=Math.min(t,o),e=Math.max(e,o),i})),e-t}isBanded(t){return this.bandWidth()<=t}get cardinality(){return this.elements.size}get size(){return this.rows*this.columns}get(t,e){return this.elements.get(t*this.columns+e)}set(t,e,n){return this.threshold&&Math.abs(n)<this.threshold&&(n=0),0===n?this.elements.remove(t*this.columns+e):this.elements.set(t*this.columns+e,n),this}mmul(t){this.columns!==t.rows&&console.warn("Number of columns of left matrix are not equal to number of rows of right matrix.");const e=this.rows,n=t.columns,s=new SparseMatrix(e,n);return this.forEachNonZero(((e,n,i)=>(t.forEachNonZero(((t,o,a)=>(n===t&&s.set(e,o,s.get(e,o)+i*a),a))),i))),s}kroneckerProduct(t){const e=this.rows,n=this.columns,s=t.rows,i=t.columns,o=new SparseMatrix(e*s,n*i,{initialCapacity:this.cardinality*t.cardinality});return this.forEachNonZero(((e,n,a)=>(t.forEachNonZero(((t,r,l)=>(o.set(s*e+t,i*n+r,a*l),l))),a))),o}forEachNonZero(t){return this.elements.forEachPair(((e,n)=>{const s=e/this.columns|0,i=e%this.columns;let o=t(s,i,n);return!1!==o&&(this.threshold&&Math.abs(o)<this.threshold&&(o=0),o!==n&&(0===o?this.elements.remove(e,!0):this.elements.set(e,o)),!0)})),this.elements.maybeShrinkCapacity(),this}getNonZeros(){const t=this.cardinality,e=new Array(t),n=new Array(t),s=new Array(t);let i=0;return this.forEachNonZero(((t,o,a)=>(e[i]=t,n[i]=o,s[i]=a,i++,a))),{rows:e,columns:n,values:s}}setThreshold(t){return 0!==t&&t!==this.threshold&&(this.threshold=t,this.forEachNonZero(((t,e,n)=>n))),this}transpose(){let t=new SparseMatrix(this.columns,this.rows,{initialCapacity:this.cardinality});return this.forEachNonZero(((e,n,s)=>(t.set(n,e,s),s))),t}isEmpty(){return 0===this.rows||0===this.columns}}SparseMatrix.prototype.klass="Matrix",SparseMatrix.identity=SparseMatrix.eye,SparseMatrix.prototype.tensorProduct=SparseMatrix.prototype.kroneckerProduct;let inplaceOperator="\n(function %name%(value) {\n    if (typeof value === 'number') return this.%name%S(value);\n    return this.%name%M(value);\n})\n",inplaceOperatorScalar="\n(function %name%S(value) {\n    this.forEachNonZero((i, j, v) => v %op% value);\n    return this;\n})\n",inplaceOperatorMatrix="\n(function %name%M(matrix) {\n    matrix.forEachNonZero((i, j, v) => {\n        this.set(i, j, this.get(i, j) %op% v);\n        return v;\n    });\n    return this;\n})\n",staticOperator="\n(function %name%(matrix, value) {\n    var newMatrix = new SparseMatrix(matrix);\n    return newMatrix.%name%(value);\n})\n",inplaceMethod="\n(function %name%() {\n    this.forEachNonZero((i, j, v) => %method%(v));\n    return this;\n})\n",staticMethod="\n(function %name%(matrix) {\n    var newMatrix = new SparseMatrix(matrix);\n    return newMatrix.%name%();\n})\n";const operators=[["+","add"],["-","sub","subtract"],["*","mul","multiply"],["/","div","divide"],["%","mod","modulus"],["&","and"],["|","or"],["^","xor"],["<<","leftShift"],[">>","signPropagatingRightShift"],[">>>","rightShift","zeroFillRightShift"]];for(const operator of operators)for(let i=1;i<operator.length;i++)SparseMatrix.prototype[operator[i]]=eval(fillTemplateFunction(inplaceOperator,{name:operator[i],op:operator[0]})),SparseMatrix.prototype[`${operator[i]}S`]=eval(fillTemplateFunction(inplaceOperatorScalar,{name:`${operator[i]}S`,op:operator[0]})),SparseMatrix.prototype[`${operator[i]}M`]=eval(fillTemplateFunction(inplaceOperatorMatrix,{name:`${operator[i]}M`,op:operator[0]})),SparseMatrix[operator[i]]=eval(fillTemplateFunction(staticOperator,{name:operator[i]}));let methods=[["~","not"]];["abs","acos","acosh","asin","asinh","atan","atanh","cbrt","ceil","clz32","cos","cosh","exp","expm1","floor","fround","log","log1p","log10","log2","round","sign","sin","sinh","sqrt","tan","tanh","trunc"].forEach((function(t){methods.push([`Math.${t}`,t])}));for(const method of methods)for(let i=1;i<method.length;i++)SparseMatrix.prototype[method[i]]=eval(fillTemplateFunction(inplaceMethod,{name:method[i],method:method[0]})),SparseMatrix[method[i]]=eval(fillTemplateFunction(staticMethod,{name:method[i]}));function fillTemplateFunction(t,e){for(const n in e)t=t.replace(new RegExp(`%${n}%`,"g"),e[n]);return t}function createPauli(t){const e=(t-1)/2,n=new Array(t),s=new Array(t);for(let i=0;i<t;i++)n[i]=t-1-i-e,s[i]=Math.sqrt(e*(e+1)-n[i]*(n[i]+1));const i=diag(s,1,t,t);for(let i=0;i<t;i++)s[i]=Math.sqrt(e*(e+1)-n[i]*(n[i]-1));const o=diag(s,-1,t,t);return{x:i.clone().add(o).mul(.5),y:o.clone().mul(-1).add(i).mul(-.5),z:diag(n,0,t,t),m:o,p:i}}function diag(t,e,n,s){const i=new SparseMatrix(n,s,{initialCapacity:20});for(let o=0;o<t.length;o++)o-e>=0&&o-e<n&&o<s&&i.set(o-e,o,t[o]);return i}const pauli2=createPauli(2);function getPauliMatrix(t){return 2===t?pauli2:createPauli(t)}const smallValue=.01;function simulateXYPeaks(t,e={}){const{lineWidth:n=1,maxClusterSize:s=8,frequency:i=400}=e,o=ensureSpinSystemProps(t),a=o.chemicalShifts.slice();for(let t=0;t<a.length;t++)a[t]=a[t]*i;const r=o.levels,l=[];for(const t of o.clusters){const e=t.map((t=>t<0?-t-1:t));let m=1,c=0;const u=[],g=[];if(t.length>s){let n=0;for(;t[n++]<0;);n=t[n-1],u.push(-a[n]);for(let s=0;s<t.length;s++)if(t[s]<0){const t=o.couplingConstants.get(n,e[s])/2,i=u.length;for(let e=0;e<i;e++)u.push(u[e]+t),u[e]-=t}u.sort(((t,e)=>t-e)),c=u.length,m=1;for(let t=0;t<c;t++)g.push(1)}else{const n=getHamiltonian(a,o.couplingConstants,r,o.connectivity,e),s=n.rows,i=new EigenvalueDecomposition(n),l=i.eigenvectorMatrix,C=i.realEigenvalues,f=new SparseMatrix(s,s),p=t.length;m=0;for(let n=0;n<p;n++){const s=getPauliMatrix(r[e[n]]);let i=1;for(let t=0;t<n;t++)i*=r[e[t]];const o=SparseMatrix.eye(i);i=1;for(let t=n+1;t<p;t++)i*=r[e[t]];const a=SparseMatrix.eye(i),l=o.kroneckerProduct(s.m).kroneckerProduct(a);t[n]>=0?(f.add(l.mul(t[n]+1)),m++):f.add(l.mul(t[n]))}let h=Matrix.zeros(s,s);f.forEachNonZero(((t,e,n)=>{if(n>0)for(let n=0;n<l.columns;n++){const s=l.get(e,n);0!==s&&h.set(t,n,h.get(t,n)+s)}return n}));let d=h.clone();f.forEachNonZero(((t,e,n)=>{if(n<0)for(let n=0;n<l.columns;n++){const s=l.get(e,n);0!==s&&d.set(t,n,d.get(t,n)+s)}return n}));const y=l.transpose();h=y.mmul(h);triuTimesAbs(new SparseMatrix(h.to2DArray(),{threshold:smallValue}),smallValue),d=y.mmul(d);const H=new SparseMatrix(d.to2DArray(),{threshold:smallValue});H.forEachNonZero(((t,e,n)=>n)),triuTimesAbs(H,smallValue),H.forEachNonZero(((t,e,n)=>{let s=h.get(t,e);s=Math.min(Math.abs(s),Math.abs(n)),s*=s,c+=s;const i=C[t]-C[e],o=binarySearch$1(u,i,((t,e)=>t-e));o<0?(u.splice(-1-o,0,i),g.splice(-1-o,0,s)):g[o]+=s}))}const C=u.length;if(C>0){m/=c;const t=n/64;let e=u[0],s=g[0],o=1;for(let n=1;n<C;n++)Math.abs(u[n]-e/o)<t?(s+=g[n],e+=u[n],o++):(l.push({x:-e/o/i,y:s*m}),e=u[n],s=g[n],o=1);l.push({x:-e/o/i,y:s*m})}}return l.filter((t=>t.x<1e3))}function triuTimesAbs(t,e){t.forEachNonZero(((t,n,s)=>Math.abs(s)<=e?0:s))}function getHamiltonian(t,e,n,s,i){let o=1;for(const t of i)o*=n[t];const a=new SparseMatrix(o,o);for(let o=0;o<i.length;o++){const r=i[o],l=getPauliMatrix(n[r]);let m=1;for(let t=0;t<o;t++)m*=n[i[t]];const c=SparseMatrix.eye(m);m=1;for(let t=o+1;t<i.length;t++)m*=n[i[t]];const u=SparseMatrix.eye(m),g=t[r],C=c.kroneckerProduct(l.z).kroneckerProduct(u);a.add(C.mul(g));for(let t=0;t<i.length;t++){const o=i[t];if(1===s.get(r,o)){const s=getPauliMatrix(n[o]);let m=1;for(let e=0;e<t;e++)m*=n[i[e]];const g=SparseMatrix.eye(m);m=1;for(let e=t+1;e<i.length;e++)m*=n[i[e]];const C=SparseMatrix.eye(m),f=c.kroneckerProduct(l.x).kroneckerProduct(u).mmul(g.kroneckerProduct(s.x).kroneckerProduct(C));f.add(c.kroneckerProduct(l.y).kroneckerProduct(u).mul(-1).mmul(g.kroneckerProduct(s.y).kroneckerProduct(C))),f.add(c.kroneckerProduct(l.z).kroneckerProduct(u).mmul(g.kroneckerProduct(s.z).kroneckerProduct(C))),a.add(f.mul(e.get(r,o)/2))}}}return a}function simulate1D(t,e={}){const{lineWidth:n=1,frequency:s=400,from:i=0,to:o=10,nbPoints:a=1024,shape:r={kind:"gaussian"}}=e,l=n/s;return generateSpectrum(simulateXYPeaks(ensureSpinSystemProps(t),e),{generator:{from:i,to:o,nbPoints:a},peakOptions:{shape:r,width:l}})}function splitSpinSystem(t,e={}){const n=ensureSpinSystemProps(t),{chemicalShifts:s,couplingConstants:i,connectivity:o}=n,{frequency:a=400,maxClusterSize:r=8}=e,l=agnes(calculateBetas(s,i,a),{method:"single",isDistanceMatrix:!0}),m=[],c=s.length;splitCluster(l,m,{maxClusterSize:r,force:!1,nSpins:c,connectivity:o});const u=mergeClusters(m,r),g=u.length,C=new Array(g);for(let t=0;t<g;t++){C[t]=[];for(let e=0;e<c;e++){const n=u[t][e];0!==n&&C[t].push(n<0?-(e+1):e)}}return C}function splitCluster(t,e,n){const{maxClusterSize:s,force:i,nSpins:o,connectivity:a}=n;if(!i&&t.size<=s)e.push(getMembers(t.indices(),o));else for(const n of t.children)if(n.size<=s){const t=getMembers(n.indices(),o);let i=0;for(let e=0;e<o;e++)if(1===t[e]){for(let n=0;n<o;n++)1===a.get(e,n)&&0===t[n]&&(t[n]=-1,i++);i++}i<=s?e.push(t):n.index<0?splitCluster(n,e,{maxClusterSize:s,force:!0,nSpins:o,connectivity:a}):(t[n.index]=2,e.push(t))}else splitCluster(n,e,{maxClusterSize:s,force:!1,nSpins:o,connectivity:a})}function calculateBetas(t,e,n){const s=e.rows,i=e.columns,o=Matrix.zeros(s,s);for(let a=0;a<s;a++)for(let s=a;s<i;s++){const i=e.get(a,s);if(t[a]-t[s]!=0){const e=1-Math.abs(i/((t[a]-t[s])*n));o.set(a,s,e),o.set(s,a,e)}else a!==s&&0===i&&(o.set(a,s,1),o.set(s,a,1))}return o.to2DArray()}function mergeClusters(t,e){for(let n=t.length-1;n>=0;n--){const s=t[n],i=s.length;let o=0;for(;o<i&&-1!==s[o++];);if(!(o>=i))for(let o=t.length-1;o>=n+1;o--){const n=t[o];let a=0,r=0;for(let t=0;t<i;t++)s[t]*n[t]==-1&&r++,0===s[t]&&0===n[t]||a++;if(r>0&&a<=e){for(let t=0;t<i;t++)1===n[t]?s[t]=1:-1===n[t]&&1!==s[t]&&(s[t]=-1);t.splice(o,1)}}}return t}function getMembers(t,e){const n=new Int16Array(e);for(const e of t)n[e]=1;return n}function checkForMandatory(t){for(const e of t){if(!e.js)throw new Error("There is not js");if(!e.atoms)throw new Error("There is not atoms");for(const t of e.js)if(!t.atoms)throw new Error("There is not atoms")}}function signalsToXY(t,e={}){checkForMandatory(t);const{frequency:n=400,shape:s={kind:"gaussian"},from:i=0,to:o=10,lineWidth:a=1,nbPoints:r=16384,maxValue:l=1e8,maxClusterSize:m=8}=e;if(0===t.length)return{x:xSequentialFill({from:i,to:o,size:r}),y:Array.from(new Float64Array(r))};const c=signalsToSpinSystem(t);c.clusters=splitSpinSystem(c,{frequency:n,maxClusterSize:m});const u=simulate1D(c,{frequency:n,from:i,to:o,nbPoints:r,lineWidth:a,maxClusterSize:m,shape:s});return l&&0===xIsMonotonic(u.y)&&(u.y=xRescale(u.y,{max:l})),u}function getFrequency(t,e){const{nucleus:n,frequency:s}=e;return checkExistence$1(t,n),s*gyromagneticRatio[t]/gyromagneticRatio[n]}function checkExistence$1(...t){const e=[];for(const n of t)n in gyromagneticRatio||e.push(n);if(0!==e.length)throw new Error(`${e.join(" , ")} is not supported`)}async function predictAllSpectra(t,e={}){const{simulation:n={oneD:{},twoD:{}},prediction:s={}}=e,i=await predictAll(t,s),{molfile:o,spectra:a}=i,r={proton:{from:0,to:14},carbon:{from:0,to:200},nbPoints:65536,lineWidth:1,...n.oneD||{}},l={from:{x:r.proton.from,y:r.carbon.from},to:{x:r.proton.to,y:r.carbon.to},nbPoints:{x:1024,y:1024},...n.twoD||{}},m=[];for(const t in a)switch(t){case"carbon":case"proton":m.push(get1DSpectrum(a[t],{nbPoints:r.nbPoints,lineWidth:r.lineWidth,...r[t],experiment:t,frequency:n.frequency}));break;case"cosy":case"hsqc":case"hmbc":m.push(get2DSpectrum(a[t],{...l,experiment:t,frequency:n.frequency}))}return{spectra:m,molecules:[{molfile:o}]}}function get2DSpectrum(t,e){const{signals:n,zones:s,nuclei:i}=t,{frequency:o,experiment:a}=e,r=get2DWidth(i),l=calculateFrequency(i,o);return{data:{rr:{...signals2DToZ(n,{...e,width:r,factor:3}),noise:.01}},info:{nucleus:i,originFrequency:l,baseFrequency:l,pulseSequence:a,experiment:"2d"},zones:{values:s}}}function get2DWidth(t){return t[0]===t[1]?.02:{x:.02,y:.2133}}function get1DSpectrum(t,e){const{frequency:n=400,experiment:s}=e,{signals:i,nucleus:o}=t,a=calculateFrequency(o,n),{x:r,y:l}=signalsToXY(i,{...e,frequency:a});return{data:{x:Array.from(r),re:Array.from(l),im:null},info:{nucleus:t.nucleus,dimension:1,isComplex:!1,originFrequency:a,baseFrequency:a,pulseSequence:"prediction",experiment:s,isFt:!0},ranges:{values:t.ranges}}}function calculateFrequency(t,e){return"string"==typeof t?getFrequency(t,{nucleus:"1H",frequency:e}):t[0]===t[1]?`${e},${e}`:`${e},${getFrequency(t[1],{nucleus:t[0],frequency:e})}`}class TreeSet{constructor(t){this.length=0,this.elements=[],this.compatator=t||function(t,e){return t-e}}size(){return this.elements.length}last(){return this.elements[this.length-1]}first(){return this.elements[0]}isEmpty(){return 0===this.size()}pollLast(){return this.length>0?(this.length--,this.elements.splice(this.length,1)):null}pollFirst(){return this.length>0?(this.length--,this.elements.splice(0,1)):null}add(t){let e=this.binarySearch(t);e<0&&(e=-e-1),this.elements.splice(e,0,t),this.length++}binarySearch(t){for(var e=0,n=this.elements.length-1;e<=n;){var s=e+n>>>1,i=this.elements[s],o=this.compatator(i,t);if(o<0)e=s+1;else{if(!(o>0))return s;n=s-1}}return-(e+1)}}var src$1=TreeSet,TreeSet$1=src$1;function createMapPossibleAssignments(t){const{restrictionByCS:e,predictions:n,targets:s,useIntegrationRestriction:i}=t,{tolerance:o,chemicalShiftRestriction:a}=e,r=Math.abs(o),l={};for(const t in n){const e=n[t];if(e.error&&(e.error=Math.abs(e.error)),l[t]=[],s)for(const n in s){const o=s[n],{nbAtoms:m}=e,{integration:c}=o;if(!i||(!(c>0)||m-c<1))if(a&&void 0!==e.delta){let s=r;e.error&&(s=Math.max(s,e.error));const i=o.signals&&o.signals.length>0?o.signals[0].delta:(o.to+o.from)/2;Math.abs(e.delta-i-r)<4*r&&l[t].push(n)}else l[t].push(n)}l[t].push("*")}return l}function partialScore$1(t,e){const{useIntegrationRestriction:n,diaIDPeerPossibleAssignment:s,nbAllowedUnAssigned:i,restrictionByCS:o,predictions:a,targets:r}=e,{useChemicalShiftScore:l}=o;let m=0;const c=t.length,u={};for(let e=0;e<t.length;e++){const n=t[e];n&&"*"!==n&&(u[n]||(u[n]=[]),u[n].push(s[e])),"*"===n&&m++}if(m>i)return 0;const g=Object.keys(u);if(0===g.length)return 0;if(n)for(const t of g){const e=u[t];let n=0;for(const t of e){n+=a[t].allHydrogens}const{integration:s}=r[t];if(n-s>=.5)return 0}return(l?chemicalShiftScoring(t,e):1)-m/c}function chemicalShiftScoring(t,e){const{tolerance:n}=e.restrictionByCS,{diaIDPeerPossibleAssignment:s,predictions:i,targets:o}=e;let a=0,r=0;for(let e=0;e<t.length;e++){const l=t[e];if(l&&"*"!==l){r++;const t=i[s[e]],m=o[l];let c=n;if(t.error&&(c=Math.max(t.error,n)),void 0===t.delta)a+=1;else{const e=m.signals&&m.signals.length>0?m.signals[0].delta:(m.to+m.from)/2;let n=Math.abs(t.delta-e);n<c?a+=1:(n=Math.abs(n-c),a+=-.25/c*n+1)}}}return r>0&&(a/=r),a}function exploreTreeRec(t,e,n,s){const{nSources:i,restrictionByCS:o,timeout:a,timeStart:r,maxSolutions:l,targets:m,predictions:c,lowerBoundScore:u,nbAllowedUnAssigned:g,possibleAssignmentMap:C,useIntegrationRestriction:f,diaIDPeerPossibleAssignment:p}=t;if(Date.now()-r>a)return s;const h=C[p[e]];for(const t of h){n[e]=t;const h=partialScore$1(n,{useIntegrationRestriction:f,diaIDPeerPossibleAssignment:p,nbAllowedUnAssigned:g,restrictionByCS:o,predictions:c,targets:m});0!==h?e===i-1&&h>=u?addSolution$1(s,{predictions:c,partial:n,score:h,maxSolutions:l}):e<i-1&&exploreTreeRec({nSources:i,restrictionByCS:o,timeout:a,timeStart:r,maxSolutions:l,targets:m,predictions:c,lowerBoundScore:u,nbAllowedUnAssigned:g,possibleAssignmentMap:C,useIntegrationRestriction:f,diaIDPeerPossibleAssignment:p},e+1,JSON.parse(JSON.stringify(n)),s):"*"===t&&(n[e]=null)}}function addSolution$1(t,e){const{score:n,maxSolutions:s,partial:i,predictions:o}=e;t.nSolutions++;const a={assignment:JSON.parse(JSON.stringify(i)),score:n/doubleAssignmentPenalty$1(i,o)};t.nSolutions>=s?a.score>t.solutions.last().score&&(t.solutions.pollLast(),t.solutions.add(a)):(t.solutions.add(a),t.nSolutions++)}function doubleAssignmentPenalty$1(t,e){const n=Object.keys(e).length-new Set(t).size;return n>0?2*n:1}const comparator$1=(t,e)=>e.score-t.score;async function buildAssignments$1(t){const{restrictionByCS:e={},useIntegrationRestriction:n,timeout:s,minScore:i,nbAllowedUnAssigned:o,maxSolutions:a,targets:r,joinedSignals:l}=t,{tolerance:m=1,useChemicalShiftScore:c=!1,chemicalShiftRestriction:u=!0}=e;let g={solutions:new TreeSet$1(comparator$1),nSolutions:0};const C=l.length,f={};for(const t of l){const e=t.diaIDs[0],n=t.atoms[0];f[e]={...t,diaIDIndex:n,allHydrogens:t.nbAtoms}}const p=createMapPossibleAssignments({restrictionByCS:{tolerance:m,useChemicalShiftScore:c,chemicalShiftRestriction:u},useIntegrationRestriction:n,predictions:f,targets:r}),h=Object.keys(p),d=fillPartial$1(C);g={solutions:new TreeSet$1(comparator$1),nSolutions:0};exploreTreeRec({nSources:C,restrictionByCS:{tolerance:m,useChemicalShiftScore:c,chemicalShiftRestriction:u},timeout:s,timeStart:Date.now(),targets:r,predictions:f,maxSolutions:a,lowerBoundScore:i,nbAllowedUnAssigned:o,possibleAssignmentMap:p,diaIDPeerPossibleAssignment:h,useIntegrationRestriction:n},0,d,g);const y=[];for(const t of g.solutions.elements){const{assignment:e,score:n}=t,s=JSON.parse(JSON.stringify(r));for(let t=0;t<e.length;t++){const n=s[e[t]];n.diaIDs||(n.diaIDs=[]),e[t]&&n.diaIDs.push(h[t])}y.push({score:n,assignment:Object.values(s)})}return y}function fillPartial$1(t,e=null){const n=new Array(t);for(let s=0;s<t;s++)n[s]=e;return n}function checkAtomsAndDiaIDs$1(t){for(const e of t){if(!e.atoms)throw new Error("signal has not atoms property");if(!e.diaIDs)throw new Error("signal has not diaIDs property");if(!e.nbAtoms)throw new Error("signal has not nbAtoms property")}}function checkForIntegration(t){for(const e of t)if(void 0===e.integration)throw new Error("ranges has not integration property")}async function get1HAssignments(t,e,n={}){const{restrictionByCS:s,minScore:i=1,maxSolutions:o=10,nbAllowedUnAssigned:a=0,timeout:r=6e3,predictionOptions:l={}}=n;if(!e)throw new Error("It is needed a OCL molecule instance to assign");e.addImplicitHydrogens(),ensureHeterotopicChiralBonds(e);const{joinedSignals:m}=await predictProton(e,l);checkForIntegration(t),checkAtomsAndDiaIDs$1(m);const c={};for(const e of t){const{id:t=v4()}=e;c[t]=JSON.parse(JSON.stringify(e))}return buildAssignments$1({restrictionByCS:s,timeout:r,minScore:i,nbAllowedUnAssigned:a,maxSolutions:o,targets:c,joinedSignals:m,useIntegrationRestriction:!0})}function checkAtomsAndDiaIDs(t){for(const e of t){if(!e.atoms)throw new Error("signal has not atoms property");if(!e.diaIDs)throw new Error("signal has not diaIDs property");if(!e.nbAtoms)throw new Error("signal has not nbAtoms property")}}function checkIntegration(t){for(const e of t)void 0===e.integration&&(e.integration=0);return t}async function get13CAssignments(t,e,n={}){const{restrictionByCS:s={},minScore:i=1,maxSolutions:o=10,nbAllowedUnAssigned:a=0,timeout:r=6e3,predictionOptions:l={}}=n;if(!e)throw new Error("It is needed a OCL molecule instance to assign");ensureHeterotopicChiralBonds(e);const{joinedSignals:m}=await predictCarbon(e,l);checkAtomsAndDiaIDs(m);const c=checkIntegration(t),u={};for(const t of c){const{id:e=v4()}=t;u[e]=JSON.parse(JSON.stringify(t))}return buildAssignments$1({restrictionByCS:s,timeout:r,minScore:i,nbAllowedUnAssigned:a,maxSolutions:o,targets:u,joinedSignals:m,useIntegrationRestriction:!1})}function getAtomCounts(t){const e=t?t.match(/[A-Z][a-z]{0,1}/g):[],n={};return e&&e.forEach((e=>{const s=new RegExp(`(${e}\\d+)`,"g").exec(t);let i=1;s&&(i=Number(s[0].split(e)[1])),n[e]=i})),n}function getCorrelationIndex(t,e){return t.findIndex((t=>t.id===e.id))}function getCorrelationsByAtomType(t,e){return t?t.filter((t=>t.atomType===e)):[]}function buildState(t,e){const n={},s=getAtomCounts(e);return t.reduce(((t,e)=>t.includes(e.atomType)?t:t.concat(e.atomType)),[]).forEach((e=>{const i=getCorrelationsByAtomType(t,e);if(i.some((t=>!t.pseudo))){const o={},a=s[e];let r=i.reduce(((t,e)=>e.pseudo?t:t+e.equivalence),0);if("H"===e){t.forEach((t=>{t.pseudo&&"H"!==t.atomType&&1===t.protonsCount.length&&!t.link.some((t=>"hsqc"===t.experimentType))&&(r+=t.protonsCount[0])}));const e=i.reduce(((t,e)=>e.pseudo?t+1:t),0),n=i.reduce(((e,n)=>0===Object.keys(n.attachment).length?e.concat(getCorrelationIndex(t,n)):e),[]);n.length>0&&(o.notAttached=n),r-=n.length-e,r<0&&(r=0);const s=i.reduce(((e,n)=>Object.keys(n.attachment).length>1||Object.keys(n.attachment).some((t=>n.attachment[t].length>1))?e.concat(getCorrelationIndex(t,n)):e),[]);s.length>0&&(o.ambiguousAttachment=s)}if(void 0!==a){i.some(((t,n)=>!t.pseudo&&t.atomType===e&&n>=a))&&(o.outOfLimit=!0)}const l=void 0===a?void 0:r===a;!1===l&&(o.incomplete=!0),n[e]={current:r,total:a,complete:l,error:o}}})),n}var isArray$8=Array.isArray,isArray_1=isArray$8,freeGlobal$1="object"==typeof commonjsGlobal&&commonjsGlobal&&commonjsGlobal.Object===Object&&commonjsGlobal,_freeGlobal=freeGlobal$1,freeGlobal=_freeGlobal,freeSelf="object"==typeof self&&self&&self.Object===Object&&self,root$8=freeGlobal||freeSelf||Function("return this")(),_root=root$8,root$7=_root,Symbol$7=root$7.Symbol,_Symbol=Symbol$7,Symbol$6=_Symbol,objectProto$f=Object.prototype,hasOwnProperty$c=objectProto$f.hasOwnProperty,nativeObjectToString$1=objectProto$f.toString,symToStringTag$1=Symbol$6?Symbol$6.toStringTag:void 0;function getRawTag$1(t){var e=hasOwnProperty$c.call(t,symToStringTag$1),n=t[symToStringTag$1];try{t[symToStringTag$1]=void 0;var s=!0}catch(t){}var i=nativeObjectToString$1.call(t);return s&&(e?t[symToStringTag$1]=n:delete t[symToStringTag$1]),i}var _getRawTag=getRawTag$1,objectProto$e=Object.prototype,nativeObjectToString=objectProto$e.toString;function objectToString$1(t){return nativeObjectToString.call(t)}var _objectToString=objectToString$1,Symbol$5=_Symbol,getRawTag=_getRawTag,objectToString=_objectToString,nullTag="[object Null]",undefinedTag="[object Undefined]",symToStringTag=Symbol$5?Symbol$5.toStringTag:void 0;function baseGetTag$6(t){return null==t?void 0===t?undefinedTag:nullTag:symToStringTag&&symToStringTag in Object(t)?getRawTag(t):objectToString(t)}var _baseGetTag=baseGetTag$6;function isObjectLike$8(t){return null!=t&&"object"==typeof t}var isObjectLike_1=isObjectLike$8,baseGetTag$5=_baseGetTag,isObjectLike$7=isObjectLike_1,symbolTag$3="[object Symbol]";function isSymbol$3(t){return"symbol"==typeof t||isObjectLike$7(t)&&baseGetTag$5(t)==symbolTag$3}var isSymbol_1=isSymbol$3,isArray$7=isArray_1,isSymbol$2=isSymbol_1,reIsDeepProp=/\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,reIsPlainProp=/^\w*$/;function isKey$1(t,e){if(isArray$7(t))return!1;var n=typeof t;return!("number"!=n&&"symbol"!=n&&"boolean"!=n&&null!=t&&!isSymbol$2(t))||(reIsPlainProp.test(t)||!reIsDeepProp.test(t)||null!=e&&t in Object(e))}var _isKey=isKey$1;function isObject$5(t){var e=typeof t;return null!=t&&("object"==e||"function"==e)}var isObject_1=isObject$5,baseGetTag$4=_baseGetTag,isObject$4=isObject_1,asyncTag="[object AsyncFunction]",funcTag$2="[object Function]",genTag$1="[object GeneratorFunction]",proxyTag="[object Proxy]";function isFunction$2(t){if(!isObject$4(t))return!1;var e=baseGetTag$4(t);return e==funcTag$2||e==genTag$1||e==asyncTag||e==proxyTag}var isFunction_1=isFunction$2,root$6=_root,coreJsData$1=root$6["__core-js_shared__"],_coreJsData=coreJsData$1,coreJsData=_coreJsData,maskSrcKey=(uid=/[^.]+$/.exec(coreJsData&&coreJsData.keys&&coreJsData.keys.IE_PROTO||""),uid?"Symbol(src)_1."+uid:""),uid;function isMasked$1(t){return!!maskSrcKey&&maskSrcKey in t}var _isMasked=isMasked$1,funcProto$2=Function.prototype,funcToString$2=funcProto$2.toString;function toSource$2(t){if(null!=t){try{return funcToString$2.call(t)}catch(t){}try{return t+""}catch(t){}}return""}var _toSource=toSource$2,isFunction$1=isFunction_1,isMasked=_isMasked,isObject$3=isObject_1,toSource$1=_toSource,reRegExpChar=/[\\^$.*+?()[\]{}|]/g,reIsHostCtor=/^\[object .+?Constructor\]$/,funcProto$1=Function.prototype,objectProto$d=Object.prototype,funcToString$1=funcProto$1.toString,hasOwnProperty$b=objectProto$d.hasOwnProperty,reIsNative=RegExp("^"+funcToString$1.call(hasOwnProperty$b).replace(reRegExpChar,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$");function baseIsNative$1(t){return!(!isObject$3(t)||isMasked(t))&&(isFunction$1(t)?reIsNative:reIsHostCtor).test(toSource$1(t))}var _baseIsNative=baseIsNative$1;function getValue$1(t,e){return null==t?void 0:t[e]}var _getValue=getValue$1,baseIsNative=_baseIsNative,getValue=_getValue;function getNative$7(t,e){var n=getValue(t,e);return baseIsNative(n)?n:void 0}var _getNative=getNative$7,getNative$6=_getNative,nativeCreate$4=getNative$6(Object,"create"),_nativeCreate=nativeCreate$4,nativeCreate$3=_nativeCreate;function hashClear$1(){this.__data__=nativeCreate$3?nativeCreate$3(null):{},this.size=0}var _hashClear=hashClear$1;function hashDelete$1(t){var e=this.has(t)&&delete this.__data__[t];return this.size-=e?1:0,e}var _hashDelete=hashDelete$1,nativeCreate$2=_nativeCreate,HASH_UNDEFINED$2="__lodash_hash_undefined__",objectProto$c=Object.prototype,hasOwnProperty$a=objectProto$c.hasOwnProperty;function hashGet$1(t){var e=this.__data__;if(nativeCreate$2){var n=e[t];return n===HASH_UNDEFINED$2?void 0:n}return hasOwnProperty$a.call(e,t)?e[t]:void 0}var _hashGet=hashGet$1,nativeCreate$1=_nativeCreate,objectProto$b=Object.prototype,hasOwnProperty$9=objectProto$b.hasOwnProperty;function hashHas$1(t){var e=this.__data__;return nativeCreate$1?void 0!==e[t]:hasOwnProperty$9.call(e,t)}var _hashHas=hashHas$1,nativeCreate=_nativeCreate,HASH_UNDEFINED$1="__lodash_hash_undefined__";function hashSet$1(t,e){var n=this.__data__;return this.size+=this.has(t)?0:1,n[t]=nativeCreate&&void 0===e?HASH_UNDEFINED$1:e,this}var _hashSet=hashSet$1,hashClear=_hashClear,hashDelete=_hashDelete,hashGet=_hashGet,hashHas=_hashHas,hashSet=_hashSet;function Hash$1(t){var e=-1,n=null==t?0:t.length;for(this.clear();++e<n;){var s=t[e];this.set(s[0],s[1])}}Hash$1.prototype.clear=hashClear,Hash$1.prototype.delete=hashDelete,Hash$1.prototype.get=hashGet,Hash$1.prototype.has=hashHas,Hash$1.prototype.set=hashSet;var _Hash=Hash$1;function listCacheClear$1(){this.__data__=[],this.size=0}var _listCacheClear=listCacheClear$1;function eq$3(t,e){return t===e||t!=t&&e!=e}var eq_1=eq$3,eq$2=eq_1;function assocIndexOf$4(t,e){for(var n=t.length;n--;)if(eq$2(t[n][0],e))return n;return-1}var _assocIndexOf=assocIndexOf$4,assocIndexOf$3=_assocIndexOf,arrayProto=Array.prototype,splice=arrayProto.splice;function listCacheDelete$1(t){var e=this.__data__,n=assocIndexOf$3(e,t);return!(n<0)&&(n==e.length-1?e.pop():splice.call(e,n,1),--this.size,!0)}var _listCacheDelete=listCacheDelete$1,assocIndexOf$2=_assocIndexOf;function listCacheGet$1(t){var e=this.__data__,n=assocIndexOf$2(e,t);return n<0?void 0:e[n][1]}var _listCacheGet=listCacheGet$1,assocIndexOf$1=_assocIndexOf;function listCacheHas$1(t){return assocIndexOf$1(this.__data__,t)>-1}var _listCacheHas=listCacheHas$1,assocIndexOf=_assocIndexOf;function listCacheSet$1(t,e){var n=this.__data__,s=assocIndexOf(n,t);return s<0?(++this.size,n.push([t,e])):n[s][1]=e,this}var _listCacheSet=listCacheSet$1,listCacheClear=_listCacheClear,listCacheDelete=_listCacheDelete,listCacheGet=_listCacheGet,listCacheHas=_listCacheHas,listCacheSet=_listCacheSet;function ListCache$4(t){var e=-1,n=null==t?0:t.length;for(this.clear();++e<n;){var s=t[e];this.set(s[0],s[1])}}ListCache$4.prototype.clear=listCacheClear,ListCache$4.prototype.delete=listCacheDelete,ListCache$4.prototype.get=listCacheGet,ListCache$4.prototype.has=listCacheHas,ListCache$4.prototype.set=listCacheSet;var _ListCache=ListCache$4,getNative$5=_getNative,root$5=_root,Map$4=getNative$5(root$5,"Map"),_Map=Map$4,Hash=_Hash,ListCache$3=_ListCache,Map$3=_Map;function mapCacheClear$1(){this.size=0,this.__data__={hash:new Hash,map:new(Map$3||ListCache$3),string:new Hash}}var _mapCacheClear=mapCacheClear$1;function isKeyable$1(t){var e=typeof t;return"string"==e||"number"==e||"symbol"==e||"boolean"==e?"__proto__"!==t:null===t}var _isKeyable=isKeyable$1,isKeyable=_isKeyable;function getMapData$4(t,e){var n=t.__data__;return isKeyable(e)?n["string"==typeof e?"string":"hash"]:n.map}var _getMapData=getMapData$4,getMapData$3=_getMapData;function mapCacheDelete$1(t){var e=getMapData$3(this,t).delete(t);return this.size-=e?1:0,e}var _mapCacheDelete=mapCacheDelete$1,getMapData$2=_getMapData;function mapCacheGet$1(t){return getMapData$2(this,t).get(t)}var _mapCacheGet=mapCacheGet$1,getMapData$1=_getMapData;function mapCacheHas$1(t){return getMapData$1(this,t).has(t)}var _mapCacheHas=mapCacheHas$1,getMapData=_getMapData;function mapCacheSet$1(t,e){var n=getMapData(this,t),s=n.size;return n.set(t,e),this.size+=n.size==s?0:1,this}var _mapCacheSet=mapCacheSet$1,mapCacheClear=_mapCacheClear,mapCacheDelete=_mapCacheDelete,mapCacheGet=_mapCacheGet,mapCacheHas=_mapCacheHas,mapCacheSet=_mapCacheSet;function MapCache$3(t){var e=-1,n=null==t?0:t.length;for(this.clear();++e<n;){var s=t[e];this.set(s[0],s[1])}}MapCache$3.prototype.clear=mapCacheClear,MapCache$3.prototype.delete=mapCacheDelete,MapCache$3.prototype.get=mapCacheGet,MapCache$3.prototype.has=mapCacheHas,MapCache$3.prototype.set=mapCacheSet;var _MapCache=MapCache$3,MapCache$2=_MapCache,FUNC_ERROR_TEXT="Expected a function";function memoize$1(t,e){if("function"!=typeof t||null!=e&&"function"!=typeof e)throw new TypeError(FUNC_ERROR_TEXT);var n=function(){var s=arguments,i=e?e.apply(this,s):s[0],o=n.cache;if(o.has(i))return o.get(i);var a=t.apply(this,s);return n.cache=o.set(i,a)||o,a};return n.cache=new(memoize$1.Cache||MapCache$2),n}memoize$1.Cache=MapCache$2;var memoize_1=memoize$1,memoize=memoize_1,MAX_MEMOIZE_SIZE=500;function memoizeCapped$1(t){var e=memoize(t,(function(t){return n.size===MAX_MEMOIZE_SIZE&&n.clear(),t})),n=e.cache;return e}var _memoizeCapped=memoizeCapped$1,memoizeCapped=_memoizeCapped,rePropName=/[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g,reEscapeChar=/\\(\\)?/g,stringToPath$1=memoizeCapped((function(t){var e=[];return 46===t.charCodeAt(0)&&e.push(""),t.replace(rePropName,(function(t,n,s,i){e.push(s?i.replace(reEscapeChar,"$1"):n||t)})),e})),_stringToPath=stringToPath$1;function arrayMap$2(t,e){for(var n=-1,s=null==t?0:t.length,i=Array(s);++n<s;)i[n]=e(t[n],n,t);return i}var _arrayMap=arrayMap$2,Symbol$4=_Symbol,arrayMap$1=_arrayMap,isArray$6=isArray_1,isSymbol$1=isSymbol_1,INFINITY$1=1/0,symbolProto$2=Symbol$4?Symbol$4.prototype:void 0,symbolToString=symbolProto$2?symbolProto$2.toString:void 0;function baseToString$1(t){if("string"==typeof t)return t;if(isArray$6(t))return arrayMap$1(t,baseToString$1)+"";if(isSymbol$1(t))return symbolToString?symbolToString.call(t):"";var e=t+"";return"0"==e&&1/t==-INFINITY$1?"-0":e}var _baseToString=baseToString$1,baseToString=_baseToString;function toString$1(t){return null==t?"":baseToString(t)}var toString_1=toString$1,isArray$5=isArray_1,isKey=_isKey,stringToPath=_stringToPath,toString=toString_1;function castPath$3(t,e){return isArray$5(t)?t:isKey(t,e)?[t]:stringToPath(toString(t))}var _castPath=castPath$3,isSymbol=isSymbol_1,INFINITY=1/0;function toKey$2(t){if("string"==typeof t||isSymbol(t))return t;var e=t+"";return"0"==e&&1/t==-INFINITY?"-0":e}var _toKey=toKey$2,castPath$2=_castPath,toKey$1=_toKey;function baseGet$2(t,e){for(var n=0,s=(e=castPath$2(e,t)).length;null!=t&&n<s;)t=t[toKey$1(e[n++])];return n&&n==s?t:void 0}var _baseGet=baseGet$2,baseGet$1=_baseGet;function get(t,e,n){var s=null==t?void 0:baseGet$1(t,e);return void 0===s?n:s}var get_1=get,lodashGet=get_1;function checkMatch(t,e,n){return t-n<=e&&e<=t+n}function getLinkDim(t){return"1d"===t.experimentType?1:2}function getLinkDelta(t){if(!t.pseudo)return 1===getLinkDim(t)?t.signal.delta:"x"===t.axis?t.signal.x.delta:t.signal.y.delta}function getCorrelationDelta(t){if(t.link.length>0)return getLinkDelta(t.link[0])}function setProtonsCount(t,e,n,s){for(let i=0;i<t.length;i++){const o=t[i];if(o.edited.protonsCount)continue;const a=getCorrelationDelta(o),r=[-1,-1];for(let t=0;t<e.length;t++)if(void 0!==a&&checkMatch(a,e[t].delta,s)){r[0]=t;break}for(let t=0;t<n.length;t++)if(void 0!==a&&checkMatch(a,n[t].delta,s)){r[1]=t;break}r[0]>=0?o.protonsCount=[1]:r[1]>=0?1===n[r[1]].sign?e.length>0?o.protonsCount=[3]:o.protonsCount=[1,3]:o.protonsCount=[2]:n.length>0?o.protonsCount=[0]:o.protonsCount=[]}return t}function setProtonsCountFromDEPT(t,e,n,s){return setProtonsCount(getCorrelationsByAtomType(t,s).filter((t=>!t.pseudo)),lodashGet(e,"90",[]).filter((t=>t.atomType===s)).map((t=>t.signal)),lodashGet(e,"135",[]).filter((t=>t.atomType===s)).map((t=>t.signal)),n[s]),t}function setProtonsCountFromEditedHSQC(t,e,n,s){return setProtonsCount(t.filter((t=>!t.pseudo&&t.atomType===s)),[],lodashGet(e,"hsqc",[]).filter((t=>t.atomType[1]===s&&0!==t.signal.sign)).map((t=>({delta:t.signal.y.delta,sign:t.signal.sign}))),n[s]),t}function setProtonsCountFromData(t,e,n,s){const i=[];return t.forEach((o=>{o.pseudo||"H"===o.atomType||i.includes(o.atomType)||(i.push(o.atomType),Object.keys(e).length>0?setProtonsCountFromDEPT(t,e,s,o.atomType):setProtonsCountFromEditedHSQC(t,n,s,o.atomType))})),t}function getExperiments(t){if(!t)return{};const e={};for(const n of t){if(n.info.isFid)continue;e[`${n.info.dimension}D`]||(e[`${n.info.dimension}D`]={});const t=n.info.experiment;e[`${n.info.dimension}D`][`${t}`]||(e[`${n.info.dimension}D`][`${t}`]=[]),e[`${n.info.dimension}D`][`${t}`].push(n)}return e}function getAtomTypeFromNucleus(t){return t.length>0?t.split(/\d+/)[1]:""}function addToExperiments(t,e,n,s,i){const o=lodashGet(t,`${n}`,[]).filter((t=>{const e=lodashGet(t,n.includes("1D")?"ranges.values":"zones.values",[]).length>0;return s?getAtomTypeFromNucleus(t.info.nucleus)===i&&e:e}));o.length>0&&(e[i]=o)}function getExperiments1D(t){const e={};return lodashGet(t,"1D.1d",[]).map((t=>getAtomTypeFromNucleus(t.info.nucleus))).forEach((n=>{addToExperiments(t,e,"1D.1d",!0,n)})),e}function getExperiments1DExtra(t){const e={};return Object.keys(lodashGet(t,"1D",{})).filter((t=>"1d"!==t)).forEach((n=>{addToExperiments(t,e,`1D.${n}`,!1,n)})),e}function getExperiments2D(t){const e={};return Object.keys(lodashGet(t,"2D",{})).forEach((n=>{addToExperiments(t,e,`2D.${n}`,!1,n)})),e}const allowedSignalKinds=["signal"];function getSignals1D(t){const e={};for(const n in t){const s=[],i=t[`${n}`]||[];if(0===i.length)continue;const o=i[0];for(const t of o.ranges.values)for(const e of t.signals)e.kind&&allowedSignalKinds.includes(e.kind)&&(checkExistence(e,s)||s.push({experimentType:"1d",experimentID:o.id,integration:e.integration?e.integration:t.integration,atomType:n,signal:{...e}}));e[n]=s}return e}function checkExistence(t,e){for(const n of e)if(checkMatch(n.signal.delta,t.delta,0))return!0;return!1}var ListCache$2=_ListCache;function stackClear$1(){this.__data__=new ListCache$2,this.size=0}var _stackClear=stackClear$1;function stackDelete$1(t){var e=this.__data__,n=e.delete(t);return this.size=e.size,n}var _stackDelete=stackDelete$1;function stackGet$1(t){return this.__data__.get(t)}var _stackGet=stackGet$1;function stackHas$1(t){return this.__data__.has(t)}var _stackHas=stackHas$1,ListCache$1=_ListCache,Map$2=_Map,MapCache$1=_MapCache,LARGE_ARRAY_SIZE=200;function stackSet$1(t,e){var n=this.__data__;if(n instanceof ListCache$1){var s=n.__data__;if(!Map$2||s.length<LARGE_ARRAY_SIZE-1)return s.push([t,e]),this.size=++n.size,this;n=this.__data__=new MapCache$1(s)}return n.set(t,e),this.size=n.size,this}var _stackSet=stackSet$1,ListCache=_ListCache,stackClear=_stackClear,stackDelete=_stackDelete,stackGet=_stackGet,stackHas=_stackHas,stackSet=_stackSet;function Stack$2(t){var e=this.__data__=new ListCache(t);this.size=e.size}Stack$2.prototype.clear=stackClear,Stack$2.prototype.delete=stackDelete,Stack$2.prototype.get=stackGet,Stack$2.prototype.has=stackHas,Stack$2.prototype.set=stackSet;var _Stack=Stack$2;function arrayEach$1(t,e){for(var n=-1,s=null==t?0:t.length;++n<s&&!1!==e(t[n],n,t););return t}var _arrayEach=arrayEach$1,getNative$4=_getNative,defineProperty$2=function(){try{var t=getNative$4(Object,"defineProperty");return t({},"",{}),t}catch(t){}}(),_defineProperty=defineProperty$2,defineProperty$1=_defineProperty;function baseAssignValue$2(t,e,n){"__proto__"==e&&defineProperty$1?defineProperty$1(t,e,{configurable:!0,enumerable:!0,value:n,writable:!0}):t[e]=n}var _baseAssignValue=baseAssignValue$2,baseAssignValue$1=_baseAssignValue,eq$1=eq_1,objectProto$a=Object.prototype,hasOwnProperty$8=objectProto$a.hasOwnProperty;function assignValue$2(t,e,n){var s=t[e];hasOwnProperty$8.call(t,e)&&eq$1(s,n)&&(void 0!==n||e in t)||baseAssignValue$1(t,e,n)}var _assignValue=assignValue$2,assignValue$1=_assignValue,baseAssignValue=_baseAssignValue;function copyObject$5(t,e,n,s){var i=!n;n||(n={});for(var o=-1,a=e.length;++o<a;){var r=e[o],l=s?s(n[r],t[r],r,n,t):void 0;void 0===l&&(l=t[r]),i?baseAssignValue(n,r,l):assignValue$1(n,r,l)}return n}var _copyObject=copyObject$5;function baseTimes$1(t,e){for(var n=-1,s=Array(t);++n<t;)s[n]=e(n);return s}var _baseTimes=baseTimes$1,baseGetTag$3=_baseGetTag,isObjectLike$6=isObjectLike_1,argsTag$3="[object Arguments]";function baseIsArguments$1(t){return isObjectLike$6(t)&&baseGetTag$3(t)==argsTag$3}var _baseIsArguments=baseIsArguments$1,baseIsArguments=_baseIsArguments,isObjectLike$5=isObjectLike_1,objectProto$9=Object.prototype,hasOwnProperty$7=objectProto$9.hasOwnProperty,propertyIsEnumerable$1=objectProto$9.propertyIsEnumerable,isArguments$2=baseIsArguments(function(){return arguments}())?baseIsArguments:function(t){return isObjectLike$5(t)&&hasOwnProperty$7.call(t,"callee")&&!propertyIsEnumerable$1.call(t,"callee")},isArguments_1=isArguments$2,isBuffer$3={exports:{}};function stubFalse(){return!1}var stubFalse_1=stubFalse;!function(t,e){var n=_root,s=stubFalse_1,i=e&&!e.nodeType&&e,o=i&&t&&!t.nodeType&&t,a=o&&o.exports===i?n.Buffer:void 0,r=(a?a.isBuffer:void 0)||s;t.exports=r}(isBuffer$3,isBuffer$3.exports);var MAX_SAFE_INTEGER$1=9007199254740991,reIsUint=/^(?:0|[1-9]\d*)$/;function isIndex$1(t,e){var n=typeof t;return!!(e=null==e?MAX_SAFE_INTEGER$1:e)&&("number"==n||"symbol"!=n&&reIsUint.test(t))&&t>-1&&t%1==0&&t<e}var _isIndex=isIndex$1,MAX_SAFE_INTEGER=9007199254740991;function isLength$2(t){return"number"==typeof t&&t>-1&&t%1==0&&t<=MAX_SAFE_INTEGER}var isLength_1=isLength$2,baseGetTag$2=_baseGetTag,isLength$1=isLength_1,isObjectLike$4=isObjectLike_1,argsTag$2="[object Arguments]",arrayTag$2="[object Array]",boolTag$3="[object Boolean]",dateTag$3="[object Date]",errorTag$2="[object Error]",funcTag$1="[object Function]",mapTag$5="[object Map]",numberTag$3="[object Number]",objectTag$4="[object Object]",regexpTag$3="[object RegExp]",setTag$5="[object Set]",stringTag$3="[object String]",weakMapTag$2="[object WeakMap]",arrayBufferTag$3="[object ArrayBuffer]",dataViewTag$4="[object DataView]",float32Tag$2="[object Float32Array]",float64Tag$2="[object Float64Array]",int8Tag$2="[object Int8Array]",int16Tag$2="[object Int16Array]",int32Tag$2="[object Int32Array]",uint8Tag$2="[object Uint8Array]",uint8ClampedTag$2="[object Uint8ClampedArray]",uint16Tag$2="[object Uint16Array]",uint32Tag$2="[object Uint32Array]",typedArrayTags={};function baseIsTypedArray$1(t){return isObjectLike$4(t)&&isLength$1(t.length)&&!!typedArrayTags[baseGetTag$2(t)]}typedArrayTags[float32Tag$2]=typedArrayTags[float64Tag$2]=typedArrayTags[int8Tag$2]=typedArrayTags[int16Tag$2]=typedArrayTags[int32Tag$2]=typedArrayTags[uint8Tag$2]=typedArrayTags[uint8ClampedTag$2]=typedArrayTags[uint16Tag$2]=typedArrayTags[uint32Tag$2]=!0,typedArrayTags[argsTag$2]=typedArrayTags[arrayTag$2]=typedArrayTags[arrayBufferTag$3]=typedArrayTags[boolTag$3]=typedArrayTags[dataViewTag$4]=typedArrayTags[dateTag$3]=typedArrayTags[errorTag$2]=typedArrayTags[funcTag$1]=typedArrayTags[mapTag$5]=typedArrayTags[numberTag$3]=typedArrayTags[objectTag$4]=typedArrayTags[regexpTag$3]=typedArrayTags[setTag$5]=typedArrayTags[stringTag$3]=typedArrayTags[weakMapTag$2]=!1;var _baseIsTypedArray=baseIsTypedArray$1;function baseUnary$3(t){return function(e){return t(e)}}var _baseUnary=baseUnary$3,_nodeUtil={exports:{}};!function(t,e){var n=_freeGlobal,s=e&&!e.nodeType&&e,i=s&&t&&!t.nodeType&&t,o=i&&i.exports===s&&n.process,a=function(){try{var t=i&&i.require&&i.require("util").types;return t||o&&o.binding&&o.binding("util")}catch(t){}}();t.exports=a}(_nodeUtil,_nodeUtil.exports);var baseIsTypedArray=_baseIsTypedArray,baseUnary$2=_baseUnary,nodeUtil$2=_nodeUtil.exports,nodeIsTypedArray=nodeUtil$2&&nodeUtil$2.isTypedArray,isTypedArray$2=nodeIsTypedArray?baseUnary$2(nodeIsTypedArray):baseIsTypedArray,isTypedArray_1=isTypedArray$2,baseTimes=_baseTimes,isArguments$1=isArguments_1,isArray$4=isArray_1,isBuffer$2=isBuffer$3.exports,isIndex=_isIndex,isTypedArray$1=isTypedArray_1,objectProto$8=Object.prototype,hasOwnProperty$6=objectProto$8.hasOwnProperty;function arrayLikeKeys$2(t,e){var n=isArray$4(t),s=!n&&isArguments$1(t),i=!n&&!s&&isBuffer$2(t),o=!n&&!s&&!i&&isTypedArray$1(t),a=n||s||i||o,r=a?baseTimes(t.length,String):[],l=r.length;for(var m in t)!e&&!hasOwnProperty$6.call(t,m)||a&&("length"==m||i&&("offset"==m||"parent"==m)||o&&("buffer"==m||"byteLength"==m||"byteOffset"==m)||isIndex(m,l))||r.push(m);return r}var _arrayLikeKeys=arrayLikeKeys$2,objectProto$7=Object.prototype;function isPrototype$3(t){var e=t&&t.constructor;return t===("function"==typeof e&&e.prototype||objectProto$7)}var _isPrototype=isPrototype$3;function overArg$2(t,e){return function(n){return t(e(n))}}var _overArg=overArg$2,overArg$1=_overArg,nativeKeys$1=overArg$1(Object.keys,Object),_nativeKeys=nativeKeys$1,isPrototype$2=_isPrototype,nativeKeys=_nativeKeys,objectProto$6=Object.prototype,hasOwnProperty$5=objectProto$6.hasOwnProperty;function baseKeys$1(t){if(!isPrototype$2(t))return nativeKeys(t);var e=[];for(var n in Object(t))hasOwnProperty$5.call(t,n)&&"constructor"!=n&&e.push(n);return e}var _baseKeys=baseKeys$1,isFunction=isFunction_1,isLength=isLength_1;function isArrayLike$2(t){return null!=t&&isLength(t.length)&&!isFunction(t)}var isArrayLike_1=isArrayLike$2,arrayLikeKeys$1=_arrayLikeKeys,baseKeys=_baseKeys,isArrayLike$1=isArrayLike_1;function keys$3(t){return isArrayLike$1(t)?arrayLikeKeys$1(t):baseKeys(t)}var keys_1=keys$3,copyObject$4=_copyObject,keys$2=keys_1;function baseAssign$1(t,e){return t&&copyObject$4(e,keys$2(e),t)}var _baseAssign=baseAssign$1;function nativeKeysIn$1(t){var e=[];if(null!=t)for(var n in Object(t))e.push(n);return e}var _nativeKeysIn=nativeKeysIn$1,isObject$2=isObject_1,isPrototype$1=_isPrototype,nativeKeysIn=_nativeKeysIn,objectProto$5=Object.prototype,hasOwnProperty$4=objectProto$5.hasOwnProperty;function baseKeysIn$1(t){if(!isObject$2(t))return nativeKeysIn(t);var e=isPrototype$1(t),n=[];for(var s in t)("constructor"!=s||!e&&hasOwnProperty$4.call(t,s))&&n.push(s);return n}var _baseKeysIn=baseKeysIn$1,arrayLikeKeys=_arrayLikeKeys,baseKeysIn=_baseKeysIn,isArrayLike=isArrayLike_1;function keysIn$3(t){return isArrayLike(t)?arrayLikeKeys(t,!0):baseKeysIn(t)}var keysIn_1=keysIn$3,copyObject$3=_copyObject,keysIn$2=keysIn_1;function baseAssignIn$1(t,e){return t&&copyObject$3(e,keysIn$2(e),t)}var _baseAssignIn=baseAssignIn$1,_cloneBuffer={exports:{}};function copyArray$1(t,e){var n=-1,s=t.length;for(e||(e=Array(s));++n<s;)e[n]=t[n];return e}!function(t,e){var n=_root,s=e&&!e.nodeType&&e,i=s&&t&&!t.nodeType&&t,o=i&&i.exports===s?n.Buffer:void 0,a=o?o.allocUnsafe:void 0;t.exports=function(t,e){if(e)return t.slice();var n=t.length,s=a?a(n):new t.constructor(n);return t.copy(s),s}}(_cloneBuffer,_cloneBuffer.exports);var _copyArray=copyArray$1;function arrayFilter$1(t,e){for(var n=-1,s=null==t?0:t.length,i=0,o=[];++n<s;){var a=t[n];e(a,n,t)&&(o[i++]=a)}return o}var _arrayFilter=arrayFilter$1;function stubArray$2(){return[]}var stubArray_1=stubArray$2,arrayFilter=_arrayFilter,stubArray$1=stubArray_1,objectProto$4=Object.prototype,propertyIsEnumerable=objectProto$4.propertyIsEnumerable,nativeGetSymbols$1=Object.getOwnPropertySymbols,getSymbols$3=nativeGetSymbols$1?function(t){return null==t?[]:(t=Object(t),arrayFilter(nativeGetSymbols$1(t),(function(e){return propertyIsEnumerable.call(t,e)})))}:stubArray$1,_getSymbols=getSymbols$3,copyObject$2=_copyObject,getSymbols$2=_getSymbols;function copySymbols$1(t,e){return copyObject$2(t,getSymbols$2(t),e)}var _copySymbols=copySymbols$1;function arrayPush$3(t,e){for(var n=-1,s=e.length,i=t.length;++n<s;)t[i+n]=e[n];return t}var _arrayPush=arrayPush$3,overArg=_overArg,getPrototype$3=overArg(Object.getPrototypeOf,Object),_getPrototype=getPrototype$3,arrayPush$2=_arrayPush,getPrototype$2=_getPrototype,getSymbols$1=_getSymbols,stubArray=stubArray_1,nativeGetSymbols=Object.getOwnPropertySymbols,getSymbolsIn$2=nativeGetSymbols?function(t){for(var e=[];t;)arrayPush$2(e,getSymbols$1(t)),t=getPrototype$2(t);return e}:stubArray,_getSymbolsIn=getSymbolsIn$2,copyObject$1=_copyObject,getSymbolsIn$1=_getSymbolsIn;function copySymbolsIn$1(t,e){return copyObject$1(t,getSymbolsIn$1(t),e)}var _copySymbolsIn=copySymbolsIn$1,arrayPush$1=_arrayPush,isArray$3=isArray_1;function baseGetAllKeys$2(t,e,n){var s=e(t);return isArray$3(t)?s:arrayPush$1(s,n(t))}var _baseGetAllKeys=baseGetAllKeys$2,baseGetAllKeys$1=_baseGetAllKeys,getSymbols=_getSymbols,keys$1=keys_1;function getAllKeys$2(t){return baseGetAllKeys$1(t,keys$1,getSymbols)}var _getAllKeys=getAllKeys$2,baseGetAllKeys=_baseGetAllKeys,getSymbolsIn=_getSymbolsIn,keysIn$1=keysIn_1;function getAllKeysIn$2(t){return baseGetAllKeys(t,keysIn$1,getSymbolsIn)}var _getAllKeysIn=getAllKeysIn$2,getNative$3=_getNative,root$4=_root,DataView$2=getNative$3(root$4,"DataView"),_DataView=DataView$2,getNative$2=_getNative,root$3=_root,Promise$2=getNative$2(root$3,"Promise"),_Promise=Promise$2,getNative$1=_getNative,root$2=_root,Set$2=getNative$1(root$2,"Set"),_Set=Set$2,getNative=_getNative,root$1=_root,WeakMap$1=getNative(root$1,"WeakMap"),_WeakMap=WeakMap$1,DataView$1=_DataView,Map$1=_Map,Promise$1=_Promise,Set$1=_Set,WeakMap=_WeakMap,baseGetTag$1=_baseGetTag,toSource=_toSource,mapTag$4="[object Map]",objectTag$3="[object Object]",promiseTag="[object Promise]",setTag$4="[object Set]",weakMapTag$1="[object WeakMap]",dataViewTag$3="[object DataView]",dataViewCtorString=toSource(DataView$1),mapCtorString=toSource(Map$1),promiseCtorString=toSource(Promise$1),setCtorString=toSource(Set$1),weakMapCtorString=toSource(WeakMap),getTag$4=baseGetTag$1;(DataView$1&&getTag$4(new DataView$1(new ArrayBuffer(1)))!=dataViewTag$3||Map$1&&getTag$4(new Map$1)!=mapTag$4||Promise$1&&getTag$4(Promise$1.resolve())!=promiseTag||Set$1&&getTag$4(new Set$1)!=setTag$4||WeakMap&&getTag$4(new WeakMap)!=weakMapTag$1)&&(getTag$4=function(t){var e=baseGetTag$1(t),n=e==objectTag$3?t.constructor:void 0,s=n?toSource(n):"";if(s)switch(s){case dataViewCtorString:return dataViewTag$3;case mapCtorString:return mapTag$4;case promiseCtorString:return promiseTag;case setCtorString:return setTag$4;case weakMapCtorString:return weakMapTag$1}return e});var _getTag=getTag$4,objectProto$3=Object.prototype,hasOwnProperty$3=objectProto$3.hasOwnProperty;function initCloneArray$1(t){var e=t.length,n=new t.constructor(e);return e&&"string"==typeof t[0]&&hasOwnProperty$3.call(t,"index")&&(n.index=t.index,n.input=t.input),n}var _initCloneArray=initCloneArray$1,root=_root,Uint8Array$3=root.Uint8Array,_Uint8Array=Uint8Array$3,Uint8Array$2=_Uint8Array;function cloneArrayBuffer$3(t){var e=new t.constructor(t.byteLength);return new Uint8Array$2(e).set(new Uint8Array$2(t)),e}var _cloneArrayBuffer=cloneArrayBuffer$3,cloneArrayBuffer$2=_cloneArrayBuffer;function cloneDataView$1(t,e){var n=e?cloneArrayBuffer$2(t.buffer):t.buffer;return new t.constructor(n,t.byteOffset,t.byteLength)}var _cloneDataView=cloneDataView$1,reFlags=/\w*$/;function cloneRegExp$1(t){var e=new t.constructor(t.source,reFlags.exec(t));return e.lastIndex=t.lastIndex,e}var _cloneRegExp=cloneRegExp$1,Symbol$3=_Symbol,symbolProto$1=Symbol$3?Symbol$3.prototype:void 0,symbolValueOf$1=symbolProto$1?symbolProto$1.valueOf:void 0;function cloneSymbol$1(t){return symbolValueOf$1?Object(symbolValueOf$1.call(t)):{}}var _cloneSymbol=cloneSymbol$1,cloneArrayBuffer$1=_cloneArrayBuffer;function cloneTypedArray$1(t,e){var n=e?cloneArrayBuffer$1(t.buffer):t.buffer;return new t.constructor(n,t.byteOffset,t.length)}var _cloneTypedArray=cloneTypedArray$1,cloneArrayBuffer=_cloneArrayBuffer,cloneDataView=_cloneDataView,cloneRegExp=_cloneRegExp,cloneSymbol=_cloneSymbol,cloneTypedArray=_cloneTypedArray,boolTag$2="[object Boolean]",dateTag$2="[object Date]",mapTag$3="[object Map]",numberTag$2="[object Number]",regexpTag$2="[object RegExp]",setTag$3="[object Set]",stringTag$2="[object String]",symbolTag$2="[object Symbol]",arrayBufferTag$2="[object ArrayBuffer]",dataViewTag$2="[object DataView]",float32Tag$1="[object Float32Array]",float64Tag$1="[object Float64Array]",int8Tag$1="[object Int8Array]",int16Tag$1="[object Int16Array]",int32Tag$1="[object Int32Array]",uint8Tag$1="[object Uint8Array]",uint8ClampedTag$1="[object Uint8ClampedArray]",uint16Tag$1="[object Uint16Array]",uint32Tag$1="[object Uint32Array]";function initCloneByTag$1(t,e,n){var s=t.constructor;switch(e){case arrayBufferTag$2:return cloneArrayBuffer(t);case boolTag$2:case dateTag$2:return new s(+t);case dataViewTag$2:return cloneDataView(t,n);case float32Tag$1:case float64Tag$1:case int8Tag$1:case int16Tag$1:case int32Tag$1:case uint8Tag$1:case uint8ClampedTag$1:case uint16Tag$1:case uint32Tag$1:return cloneTypedArray(t,n);case mapTag$3:return new s;case numberTag$2:case stringTag$2:return new s(t);case regexpTag$2:return cloneRegExp(t);case setTag$3:return new s;case symbolTag$2:return cloneSymbol(t)}}var _initCloneByTag=initCloneByTag$1,isObject$1=isObject_1,objectCreate=Object.create,baseCreate$1=function(){function t(){}return function(e){if(!isObject$1(e))return{};if(objectCreate)return objectCreate(e);t.prototype=e;var n=new t;return t.prototype=void 0,n}}(),_baseCreate=baseCreate$1,baseCreate=_baseCreate,getPrototype$1=_getPrototype,isPrototype=_isPrototype;function initCloneObject$1(t){return"function"!=typeof t.constructor||isPrototype(t)?{}:baseCreate(getPrototype$1(t))}var _initCloneObject=initCloneObject$1,getTag$3=_getTag,isObjectLike$3=isObjectLike_1,mapTag$2="[object Map]";function baseIsMap$1(t){return isObjectLike$3(t)&&getTag$3(t)==mapTag$2}var _baseIsMap=baseIsMap$1,baseIsMap=_baseIsMap,baseUnary$1=_baseUnary,nodeUtil$1=_nodeUtil.exports,nodeIsMap=nodeUtil$1&&nodeUtil$1.isMap,isMap$1=nodeIsMap?baseUnary$1(nodeIsMap):baseIsMap,isMap_1=isMap$1,getTag$2=_getTag,isObjectLike$2=isObjectLike_1,setTag$2="[object Set]";function baseIsSet$1(t){return isObjectLike$2(t)&&getTag$2(t)==setTag$2}var _baseIsSet=baseIsSet$1,baseIsSet=_baseIsSet,baseUnary=_baseUnary,nodeUtil=_nodeUtil.exports,nodeIsSet=nodeUtil&&nodeUtil.isSet,isSet$1=nodeIsSet?baseUnary(nodeIsSet):baseIsSet,isSet_1=isSet$1,Stack$1=_Stack,arrayEach=_arrayEach,assignValue=_assignValue,baseAssign=_baseAssign,baseAssignIn=_baseAssignIn,cloneBuffer=_cloneBuffer.exports,copyArray=_copyArray,copySymbols=_copySymbols,copySymbolsIn=_copySymbolsIn,getAllKeys$1=_getAllKeys,getAllKeysIn$1=_getAllKeysIn,getTag$1=_getTag,initCloneArray=_initCloneArray,initCloneByTag=_initCloneByTag,initCloneObject=_initCloneObject,isArray$2=isArray_1,isBuffer$1=isBuffer$3.exports,isMap=isMap_1,isObject=isObject_1,isSet=isSet_1,keys=keys_1,keysIn=keysIn_1,CLONE_DEEP_FLAG$2=1,CLONE_FLAT_FLAG$1=2,CLONE_SYMBOLS_FLAG$2=4,argsTag$1="[object Arguments]",arrayTag$1="[object Array]",boolTag$1="[object Boolean]",dateTag$1="[object Date]",errorTag$1="[object Error]",funcTag="[object Function]",genTag="[object GeneratorFunction]",mapTag$1="[object Map]",numberTag$1="[object Number]",objectTag$2="[object Object]",regexpTag$1="[object RegExp]",setTag$1="[object Set]",stringTag$1="[object String]",symbolTag$1="[object Symbol]",weakMapTag="[object WeakMap]",arrayBufferTag$1="[object ArrayBuffer]",dataViewTag$1="[object DataView]",float32Tag="[object Float32Array]",float64Tag="[object Float64Array]",int8Tag="[object Int8Array]",int16Tag="[object Int16Array]",int32Tag="[object Int32Array]",uint8Tag="[object Uint8Array]",uint8ClampedTag="[object Uint8ClampedArray]",uint16Tag="[object Uint16Array]",uint32Tag="[object Uint32Array]",cloneableTags={};function baseClone$2(t,e,n,s,i,o){var a,r=e&CLONE_DEEP_FLAG$2,l=e&CLONE_FLAT_FLAG$1,m=e&CLONE_SYMBOLS_FLAG$2;if(n&&(a=i?n(t,s,i,o):n(t)),void 0!==a)return a;if(!isObject(t))return t;var c=isArray$2(t);if(c){if(a=initCloneArray(t),!r)return copyArray(t,a)}else{var u=getTag$1(t),g=u==funcTag||u==genTag;if(isBuffer$1(t))return cloneBuffer(t,r);if(u==objectTag$2||u==argsTag$1||g&&!i){if(a=l||g?{}:initCloneObject(t),!r)return l?copySymbolsIn(t,baseAssignIn(a,t)):copySymbols(t,baseAssign(a,t))}else{if(!cloneableTags[u])return i?t:{};a=initCloneByTag(t,u,r)}}o||(o=new Stack$1);var C=o.get(t);if(C)return C;o.set(t,a),isSet(t)?t.forEach((function(s){a.add(baseClone$2(s,e,n,s,t,o))})):isMap(t)&&t.forEach((function(s,i){a.set(i,baseClone$2(s,e,n,i,t,o))}));var f=c?void 0:(m?l?getAllKeysIn$1:getAllKeys$1:l?keysIn:keys)(t);return arrayEach(f||t,(function(s,i){f&&(s=t[i=s]),assignValue(a,i,baseClone$2(s,e,n,i,t,o))})),a}cloneableTags[argsTag$1]=cloneableTags[arrayTag$1]=cloneableTags[arrayBufferTag$1]=cloneableTags[dataViewTag$1]=cloneableTags[boolTag$1]=cloneableTags[dateTag$1]=cloneableTags[float32Tag]=cloneableTags[float64Tag]=cloneableTags[int8Tag]=cloneableTags[int16Tag]=cloneableTags[int32Tag]=cloneableTags[mapTag$1]=cloneableTags[numberTag$1]=cloneableTags[objectTag$2]=cloneableTags[regexpTag$1]=cloneableTags[setTag$1]=cloneableTags[stringTag$1]=cloneableTags[symbolTag$1]=cloneableTags[uint8Tag]=cloneableTags[uint8ClampedTag]=cloneableTags[uint16Tag]=cloneableTags[uint32Tag]=!0,cloneableTags[errorTag$1]=cloneableTags[funcTag]=cloneableTags[weakMapTag]=!1;var _baseClone=baseClone$2,baseClone$1=_baseClone,CLONE_DEEP_FLAG$1=1,CLONE_SYMBOLS_FLAG$1=4;function cloneDeep(t){return baseClone$1(t,CLONE_DEEP_FLAG$1|CLONE_SYMBOLS_FLAG$1)}var cloneDeep_1=cloneDeep,lodashCloneDeep=cloneDeep_1,HASH_UNDEFINED="__lodash_hash_undefined__";function setCacheAdd$1(t){return this.__data__.set(t,HASH_UNDEFINED),this}var _setCacheAdd=setCacheAdd$1;function setCacheHas$1(t){return this.__data__.has(t)}var _setCacheHas=setCacheHas$1,MapCache=_MapCache,setCacheAdd=_setCacheAdd,setCacheHas=_setCacheHas;function SetCache$1(t){var e=-1,n=null==t?0:t.length;for(this.__data__=new MapCache;++e<n;)this.add(t[e])}SetCache$1.prototype.add=SetCache$1.prototype.push=setCacheAdd,SetCache$1.prototype.has=setCacheHas;var _SetCache=SetCache$1;function arraySome$1(t,e){for(var n=-1,s=null==t?0:t.length;++n<s;)if(e(t[n],n,t))return!0;return!1}var _arraySome=arraySome$1;function cacheHas$1(t,e){return t.has(e)}var _cacheHas=cacheHas$1,SetCache=_SetCache,arraySome=_arraySome,cacheHas=_cacheHas,COMPARE_PARTIAL_FLAG$3=1,COMPARE_UNORDERED_FLAG$1=2;function equalArrays$2(t,e,n,s,i,o){var a=n&COMPARE_PARTIAL_FLAG$3,r=t.length,l=e.length;if(r!=l&&!(a&&l>r))return!1;var m=o.get(t),c=o.get(e);if(m&&c)return m==e&&c==t;var u=-1,g=!0,C=n&COMPARE_UNORDERED_FLAG$1?new SetCache:void 0;for(o.set(t,e),o.set(e,t);++u<r;){var f=t[u],p=e[u];if(s)var h=a?s(p,f,u,e,t,o):s(f,p,u,t,e,o);if(void 0!==h){if(h)continue;g=!1;break}if(C){if(!arraySome(e,(function(t,e){if(!cacheHas(C,e)&&(f===t||i(f,t,n,s,o)))return C.push(e)}))){g=!1;break}}else if(f!==p&&!i(f,p,n,s,o)){g=!1;break}}return o.delete(t),o.delete(e),g}var _equalArrays=equalArrays$2;function mapToArray$1(t){var e=-1,n=Array(t.size);return t.forEach((function(t,s){n[++e]=[s,t]})),n}var _mapToArray=mapToArray$1;function setToArray$1(t){var e=-1,n=Array(t.size);return t.forEach((function(t){n[++e]=t})),n}var _setToArray=setToArray$1,Symbol$2=_Symbol,Uint8Array$1=_Uint8Array,eq=eq_1,equalArrays$1=_equalArrays,mapToArray=_mapToArray,setToArray=_setToArray,COMPARE_PARTIAL_FLAG$2=1,COMPARE_UNORDERED_FLAG=2,boolTag="[object Boolean]",dateTag="[object Date]",errorTag="[object Error]",mapTag="[object Map]",numberTag="[object Number]",regexpTag="[object RegExp]",setTag="[object Set]",stringTag="[object String]",symbolTag="[object Symbol]",arrayBufferTag="[object ArrayBuffer]",dataViewTag="[object DataView]",symbolProto=Symbol$2?Symbol$2.prototype:void 0,symbolValueOf=symbolProto?symbolProto.valueOf:void 0;function equalByTag$1(t,e,n,s,i,o,a){switch(n){case dataViewTag:if(t.byteLength!=e.byteLength||t.byteOffset!=e.byteOffset)return!1;t=t.buffer,e=e.buffer;case arrayBufferTag:return!(t.byteLength!=e.byteLength||!o(new Uint8Array$1(t),new Uint8Array$1(e)));case boolTag:case dateTag:case numberTag:return eq(+t,+e);case errorTag:return t.name==e.name&&t.message==e.message;case regexpTag:case stringTag:return t==e+"";case mapTag:var r=mapToArray;case setTag:var l=s&COMPARE_PARTIAL_FLAG$2;if(r||(r=setToArray),t.size!=e.size&&!l)return!1;var m=a.get(t);if(m)return m==e;s|=COMPARE_UNORDERED_FLAG,a.set(t,e);var c=equalArrays$1(r(t),r(e),s,i,o,a);return a.delete(t),c;case symbolTag:if(symbolValueOf)return symbolValueOf.call(t)==symbolValueOf.call(e)}return!1}var _equalByTag=equalByTag$1,getAllKeys=_getAllKeys,COMPARE_PARTIAL_FLAG$1=1,objectProto$2=Object.prototype,hasOwnProperty$2=objectProto$2.hasOwnProperty;function equalObjects$1(t,e,n,s,i,o){var a=n&COMPARE_PARTIAL_FLAG$1,r=getAllKeys(t),l=r.length;if(l!=getAllKeys(e).length&&!a)return!1;for(var m=l;m--;){var c=r[m];if(!(a?c in e:hasOwnProperty$2.call(e,c)))return!1}var u=o.get(t),g=o.get(e);if(u&&g)return u==e&&g==t;var C=!0;o.set(t,e),o.set(e,t);for(var f=a;++m<l;){var p=t[c=r[m]],h=e[c];if(s)var d=a?s(h,p,c,e,t,o):s(p,h,c,t,e,o);if(!(void 0===d?p===h||i(p,h,n,s,o):d)){C=!1;break}f||(f="constructor"==c)}if(C&&!f){var y=t.constructor,H=e.constructor;y==H||!("constructor"in t)||!("constructor"in e)||"function"==typeof y&&y instanceof y&&"function"==typeof H&&H instanceof H||(C=!1)}return o.delete(t),o.delete(e),C}var _equalObjects=equalObjects$1,Stack=_Stack,equalArrays=_equalArrays,equalByTag=_equalByTag,equalObjects=_equalObjects,getTag=_getTag,isArray$1=isArray_1,isBuffer=isBuffer$3.exports,isTypedArray=isTypedArray_1,COMPARE_PARTIAL_FLAG=1,argsTag="[object Arguments]",arrayTag="[object Array]",objectTag$1="[object Object]",objectProto$1=Object.prototype,hasOwnProperty$1=objectProto$1.hasOwnProperty;function baseIsEqualDeep$1(t,e,n,s,i,o){var a=isArray$1(t),r=isArray$1(e),l=a?arrayTag:getTag(t),m=r?arrayTag:getTag(e),c=(l=l==argsTag?objectTag$1:l)==objectTag$1,u=(m=m==argsTag?objectTag$1:m)==objectTag$1,g=l==m;if(g&&isBuffer(t)){if(!isBuffer(e))return!1;a=!0,c=!1}if(g&&!c)return o||(o=new Stack),a||isTypedArray(t)?equalArrays(t,e,n,s,i,o):equalByTag(t,e,l,n,s,i,o);if(!(n&COMPARE_PARTIAL_FLAG)){var C=c&&hasOwnProperty$1.call(t,"__wrapped__"),f=u&&hasOwnProperty$1.call(e,"__wrapped__");if(C||f){var p=C?t.value():t,h=f?e.value():e;return o||(o=new Stack),i(p,h,n,s,o)}}return!!g&&(o||(o=new Stack),equalObjects(t,e,n,s,i,o))}var _baseIsEqualDeep=baseIsEqualDeep$1,baseIsEqualDeep=_baseIsEqualDeep,isObjectLike$1=isObjectLike_1;function baseIsEqual$1(t,e,n,s,i){return t===e||(null==t||null==e||!isObjectLike$1(t)&&!isObjectLike$1(e)?t!=t&&e!=e:baseIsEqualDeep(t,e,n,s,baseIsEqual$1,i))}var _baseIsEqual=baseIsEqual$1,baseIsEqual=_baseIsEqual;function isEqual(t,e){return baseIsEqual(t,e)}var isEqual_1=isEqual,lodashIsEqual=isEqual_1;function isEditedHSQC(t){return t.info.pulseSequence.includes("hsqced")}function getSignals2D(t){const e={};return Object.keys(t).forEach((n=>{const s=[],i=[],o=[];t[n].forEach(((t,e)=>{const n=t;o.some((t=>lodashIsEqual(t,n.info.nucleus)))||(o.push(n.info.nucleus),i.push(e))})),i.forEach((e=>{const i=t[n][e],o=i.info.nucleus.map((t=>getAtomTypeFromNucleus(t)));i.zones.values.map((t=>t.signals.filter((t=>t.kind&&allowedSignalKinds.includes(t.kind))))).flat().forEach((t=>{s.some((e=>checkMatch(e.signal.x.delta,t.x.delta,0)&&checkMatch(e.signal.y.delta,t.y.delta,0)))||s.push({experimentType:n,experimentID:i.id,atomType:o,signal:{...lodashCloneDeep(t),sign:isEditedHSQC(i)&&t.peaks?t.peaks[0].z>=0?1:-1:0}})}))})),e[n]=s})),e}function getSignalsDEPT(t){const e={};return Object.keys(t).filter((t=>"dept"===t)).forEach((n=>t[n].forEach((t=>{const s=t,i=[],o=s.info.pulseSequence.match(/\d/g);if(o){const t=o.reduce(((t,e)=>t+e)),a=getAtomTypeFromNucleus(s.info.nucleus);s.ranges.values.map((t=>t.signals.filter((t=>t.kind&&allowedSignalKinds.includes(t.kind))).map((e=>({...e,sign:t.absolute>0?1:-1}))))).flat().forEach((e=>{i.some((t=>checkMatch(t.signal.delta,e.delta,0)))||i.push({experimentType:n,experimentID:s.id,mode:t,atomType:a,signal:lodashCloneDeep(e)})})),e[t]=i}})))),e}function getSignals(t){const e=getExperiments(t),n=getExperiments1D(e),s=getExperiments1DExtra(e),i=getExperiments2D(e);return{signals1D:getSignals1D(n),signals2D:getSignals2D(i),signalsDEPT:getSignalsDEPT(s)}}const BASE62="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ",LENGTH=8;function generateID(){let t="";for(let e=0;e<LENGTH;e++)t+=BASE62.charAt(Math.floor(62*Math.random()));return t}function buildLink(t){return{id:t.id||generateID(),experimentType:t.experimentType,experimentID:t.experimentID,atomType:t.atomType,signal:t.signal,axis:t.axis,match:t.match||[],experimentLabel:t.experimentLabel||"",pseudo:t.pseudo||!1,edited:t.edited||{}}}function findLinkedCorrelationsBySignalID(t,e){return t.filter((t=>t.link.some((t=>t.signal.id===e))))}function containsLink(t,e){return t.link.some((t=>t.experimentType===e.experimentType&&t.experimentID===e.experimentID&&lodashIsEqual(t.atomType,e.atomType)&&t.signal.id===e.signal.id&&t.axis===e.axis))}function hasLinks(t){return t.link.length>0}function addSignal(t,e,n,s){if(0===t.length){const t=buildCorrelation({atomType:e});addLink(t,n);const i=s.findIndex((t=>t.atomType===e&&t.pseudo&&!hasLinks(t)));i>=0?s[i]=t:s.push(t)}else containsLink(s[t[0]],n)||addLink(s[t[0]],n)}function addFromData(t,e,n,s){return t=t.filter((t=>t.link.length>0||t.pseudo)),Object.keys(e).forEach((n=>{e[n].forEach((e=>{if(0===findLinkedCorrelationsBySignalID(t,e.signal.id||"").length){const i=t.map(((t,i)=>{const o=getCorrelationDelta(t);return!t.pseudo&&t.atomType===n&&void 0!==o&&checkMatch(o,e.signal.delta,s[n])?i:-1})).filter((t=>t>=0)).filter(((t,e,n)=>n.indexOf(t)===e)),o=buildLink({experimentType:e.experimentType,experimentID:e.experimentID,signal:e.signal,atomType:[n]});addSignal(i,n,o,t)}}))})),Object.keys(n).forEach((e=>n[e].forEach((e=>{0===findLinkedCorrelationsBySignalID(t,e.signal.id||"").length&&e.atomType.forEach(((n,i)=>{const o=0===i?"x":"y",a=t.map(((t,i)=>{const a=getCorrelationDelta(t);return!t.pseudo&&t.atomType===n&&void 0!==a&&checkMatch(a,e.signal[o].delta,s[n])?i:-1})).filter((t=>t>=0)).filter(((t,e,n)=>n.indexOf(t)===e)),r=buildLink({experimentType:e.experimentType,experimentID:e.experimentID,signal:e.signal,axis:o,atomType:e.atomType});addSignal(a,n,r,t)}))})))),t}function buildCorrelation(t){return{id:t.id||generateID(),atomType:t.atomType,label:t.label||{},link:t.link||[],equivalence:t.equivalence||1,attachment:t.attachment||{},protonsCount:t.protonsCount||[],hybridization:t.hybridization||[],pseudo:t.pseudo||!1,edited:t.edited||{}}}function addPseudoCorrelations(t,e){for(const n in e){for(let s=getCorrelationsByAtomType(t,n).reduce(((t,e)=>t+e.equivalence),0);s<e[n];s++)t.push(buildCorrelation({atomType:n,pseudo:!0}))}return t}function removeLink(t,e){return t.link=t.link.filter((t=>t.id!==e)),t}function removeMatch(t,e){const n=t.match.indexOf(e);return n>=0&&t.match.splice(n,1),t}function checkPseudoCorrelations(t,e){for(const n in e){const s=getCorrelationsByAtomType(t,n);if(s.length>e[n]){const i=s.filter((t=>t.pseudo&&1===t.equivalence&&!hasLinks(t)));for(let o=s.length-1;o>=e[n]&&0!==i.length;o--){const e=i.pop();e&&t.splice(t.indexOf(e),1)}}}for(const e of t){if(!e.pseudo||e.equivalence>1||hasLinks(e))continue;const n=[],s=getCorrelationIndex(t,e);for(const i of e.link){for(const e of i.match)t[e]&&t[e].link.some((t=>t.match.includes(s)))||removeMatch(i,e);0===i.match.length&&n.push(i)}for(const t of n)removeLink(e,t.id);e.edited.protonsCount||e.link.some((t=>"hsqc"===t.experimentType))||(e.protonsCount=[])}return Object.keys(e).length>0?t.filter((t=>Object.keys(e).includes(t.atomType))):t}function replacePseudoCorrelationsByEquivalences(t,e){for(const n in e){const s=getCorrelationsByAtomType(t,n),i=s.filter((t=>!t.pseudo||t.equivalence>1||hasLinks(t))),o=i.reduce(((t,e)=>t+(e.equivalence-1)),0),a=s.filter((t=>t.pseudo&&!i.some((e=>e.id===t.id))));for(let i=0;i<s.length-(e[n]-o)&&0!==a.length;i++){const e=a.pop();e&&t.splice(t.indexOf(e),1)}}return t}function updatePseudoCorrelations(t,e){const n=getAtomCounts(e);return 0===Object.keys(n).length&&(t=t.filter((t=>!t.pseudo))),t=checkPseudoCorrelations(t=replacePseudoCorrelationsByEquivalences(t=addPseudoCorrelations(t,n),n),n)}function removeObsoleteLinksAndNotLinkedCorrelations(t,e,n){const s=t.filter((t=>!t.pseudo)),i=s.slice();return s.forEach((t=>{for(const s of t.link)if("1d"===s.experimentType)if(lodashGet(e,s.atomType[0],[]).some((t=>t.signal.id===s.signal.id))){const e=i.indexOf(t);e>=0&&i.splice(e,1)}else s.pseudo||removeLink(t,s.id);else if(lodashGet(n,`${s.experimentType}`,[]).some((t=>t.signal.id===s.signal.id))){const e=i.indexOf(t);e>=0&&i.splice(e,1)}else s.pseudo||removeLink(t,s.id)})),i.forEach((e=>{const n=t.indexOf(e);n>=0&&t.splice(n,1)})),t}function hasAttachmentAtomType(t,e){return Boolean(t.attachment[e]&&t.attachment[e].length>0)}function addAttachmentAtomType(t,e){return hasAttachmentAtomType(t,e)||(t.attachment[e]=[]),t}function addAttachment(t,e,n){return addAttachmentAtomType(t,e),t.attachment[e].includes(n)||t.attachment[e].push(n),t}function removeAttachments(t){return t.attachment={},t}function setAttachmentsAndProtonEquivalences(t){for(const e of t){removeAttachments(e);const t=e.link.filter((t=>"hsqc"===t.experimentType||"hmqc"===t.experimentType));for(const n of t){const t=n.atomType["x"===n.axis?1:0];for(let s of n.match)addAttachment(e,t,s)}}for(const e of t)"H"===e.atomType&&(e.equivalence=0);for(const e of t)if("H"!==e.atomType&&1===e.protonsCount.length&&hasAttachmentAtomType(e,"H")){const{equivalence:n,protonsCount:s}=e;let i=1;3===s[0]?i=3:2===s[0]&&(i=2);const o=n*i/e.attachment.H.length;for(const n of e.attachment.H)t[n].equivalence+=o}for(const e of t)"H"===e.atomType&&0===e.equivalence&&(e.equivalence=1);return t}function setLabels(t){const e={};return t.forEach((t=>{lodashGet(e,t.atomType,!1)||(e[t.atomType]=0),e[t.atomType]++,t.label.origin=`${t.atomType}${e[t.atomType]}`})),t}function addMatch(t,e){return t.match.includes(e)||t.match.push(e),t}function removeMatches(t){return t.match=[],t}function setMatches(t){return t.forEach((e=>{e.link.forEach((n=>{removeMatches(n);const s="x"===n.axis?n.atomType[1]:n.atomType[0];getCorrelationsByAtomType(t,s).forEach((s=>{if(e.id!==s.id){const e=getCorrelationIndex(t,s);s.link.forEach((t=>{t.experimentType===n.experimentType&&t.experimentID===n.experimentID&&lodashIsEqual(t.atomType,n.atomType)&&t.signal.id===n.signal.id&&t.axis!==n.axis&&addMatch(n,e)}))}}))}))})),t.forEach((t=>{t.link.filter((t=>{var e;return 0===t.match.length&&"1d"!==t.experimentType&&!(null===(e=t.edited)||void 0===e?void 0:e.moved)})).forEach((e=>removeLink(t,e.id)))})),t}function sortCorrelations(t){const e=(t,e)=>{if(!t.pseudo&&!e.pseudo&&t.link.length>0&&e.link.length>0){const n=getCorrelationDelta(t),s=getCorrelationDelta(e);if(void 0!==n&&void 0!==s){if(n<s)return-1;if(n>s)return 1}}return!t.pseudo&&e.pseudo?-1:t.pseudo&&!e.pseudo?1:t.label.origin<e.label.origin?-1:t.label.origin>e.label.origin?1:0};let n=[];const s=t.map((t=>t.atomType)).filter(((t,e,n)=>n.indexOf(t)===e));return s.sort(((t,e)=>"C"===t?-1:"C"===e?1:"H"===t?-1:"H"===e?1:t<e?-1:t>e?1:0)),s.forEach((s=>{const i=getCorrelationsByAtomType(t,s);i.sort(e),n=n.concat(i)})),n}function buildValues(t,e){const{tolerance:n={},mf:s="",values:i=[]}=e,o=getSignals(t);let a=i?i.slice():[];return!0!==e.skipDataUpdate?(a=removeObsoleteLinksAndNotLinkedCorrelations(a,o.signals1D,o.signals2D),a=addFromData(a,o.signals1D,o.signals2D,n)):a=a.filter((t=>t.link.length>0||t.pseudo)),a=setProtonsCountFromData(a,o.signalsDEPT,o.signals2D,n),a=sortCorrelations(a),setMatches(a),setAttachmentsAndProtonEquivalences(a),a=updatePseudoCorrelations(a,s),setLabels(a),a}function buildCorrelationData(t,e){const n=t?buildValues(t,e):[];return delete e.values,delete e.skipDataUpdate,{values:n,options:e,state:buildState(n,e.mf||"")}}function addLink(t,e){return t.link.push(e),t}function createMapPossibleAssignment(t,e){const{restrictionByCS:n,predictions:s,targets:i}=e,{tolerance:o,chemicalShiftRestriction:a}=n,r=Object.keys(s);for(const e of r){const n=o[e],r=s[e],l=i[e];t[e]||(t[e]={});for(const s in r){const i=r[s];if(t[e][s]=[],l)for(const o in l){const r=l[o],{nbAtoms:m,protonsCount:c}=i,{integration:u,protonsCount:g}=r;if(!u||("H"===e?m-u<1:!(g.length>0)||g.some((t=>c===t))))if(a&&void 0!==i.delta){const a=getCorrelationDelta(r);if(void 0===a)throw new Error("Correlation has not delta");Math.abs(i.delta-a-n)<4*n&&t[e][s].push(o)}else t[e][s].push(o)}t[e][s].push("*")}}return t}function groupCarbonTargetByIntegrationZone(t,e,n){const s=t[0],{H:i=[]}=e[s].attachment,o=[{targetIDs:[s],attachments:new Set(i)}];for(let n=1;n<t.length;n++){const s=t[n],i=e[s],{H:a=[]}=i.attachment;let r=!0;for(const t of o){if(a.some((e=>t.attachments.has(e)))){r=!1,t.targetIDs.push(s);for(const e of a)t.attachments.add(e);break}}r&&o.push({targetIDs:[s],attachments:new Set(a)})}return o.map((t=>({atomType:"C",targetIDs:t.targetIDs,integration:n?Array.from(t.attachments).reduce(((t,e)=>n[e].integration+t),0):0})))}function partialScore(t,e){const{diaIDPeerPossibleAssignment:n,infoByAtomTypes:s,restrictionByCS:i,predictions:o,targets:a,correlations:r}=e,{tolerance:l,useChemicalShiftScore:m}=i;let c=0,u=0;const g={},C={},f=Object.keys(t);for(const e of f){let i=0;const{nbAllowedUnAssigned:o}=s[e],a={},r=t[e]||[];g[e]=a,C[e]=[],u+=r.length;for(let t=0;t<r.length;t++){const s=r[t];s&&"*"!==s&&(C[e].push(t),a[s]||(a[s]=[]),a[s].push(n[e][t])),"*"===s&&i++}if(i>o)return 0;c+=i}const p={};for(const t in g)p[t]=Object.keys(g[t]);const h=Object.values(p);if(h.reduce(((t,e)=>0===e.length?t+1:t),0)===h.length)return 0;const d=getPrediction.bind({},o),y=[];for(const e in t)if("C"===e&&p[e].length>0)y.push(...groupCarbonTargetByIntegrationZone(p[e],a[e],r));else for(const t of p[e])y.push({atomType:e,targetIDs:[t],integration:a.H[t].integration});for(const t of y){const{integration:e,atomType:n}=t;if(void 0===e||isNaN(e))continue;let s=0;for(const e of t.targetIDs){const t=g[n][e];for(const e of t){const{prediction:t,atomType:i}=d(e);n===i&&(s+=t.allHydrogens)}}if(s-e>=5)return 0}let H=1,b=1;if(m){b=0,H=0;for(const e of Object.keys(t)){const s=t[e],i=a[e];for(let t=0;t<s.length;t++){const a=s[t];if(a&&"*"!==a){H++;const s=n[e][t],r=o[e][s],m=i[a],c=l[e];if(void 0===r.delta)b+=1;else{const t=getCorrelationDelta(m);if(void 0===t)throw new Error("correlation has not delta");let e=Math.abs(r.delta-t);e<c?b+=1:(e=Math.abs(e-c),b+=-.25/c*e+1)}}}}H>0&&(b/=H)}let v=0;if(howManyActived(p)>1){const e={};let s=[];for(const t of Object.keys(C))s=s.concat(C[t].map((e=>({index:e,atomType:t}))));for(let i=0;i<s.length;i++){const{atomType:r,index:l}=s[i],m=o[r][n[r][l]];for(let c=i+1;c<s.length;c++){const{atomType:i,index:u}=s[c],g=o[i][n[i][u]],C=m.pathLength[g.diaIDIndex]<5,f=t[r][l],p=t[i][u];if(!f||!p)continue;const h=f>p?`${p} ${f}`:`${f} ${p}`,d=checkLinking({from:{targetID:f,atomType:r},to:{targetID:p,atomType:i}},a),y=C?d?1:0:d?0:1;e[h]=e[h]?Math.max(e[h],y):y}}let i=0;for(const t in e)i+=e[t];v=i/(s.length*(s.length-1)/2)}const w=c/u;return 0===b?v-w:0===v?b-w:(b+v)/2-w}function checkLinking(t,e){const{from:n,to:s}=t;if(n.targetID===s.targetID)return!0;const i=e[n.atomType][n.targetID],o=e[s.atomType][s.targetID];for(const t of o.link)for(const e of i.link)if(e.signal.id===t.signal.id)return!0;return!1}function getPrediction(t,e){const n=Object.keys(t);for(const s of n){const n=t[s];if(!n)throw new Error(`prediction by ${s}`);if(n[e])return{atomType:s,prediction:n[e]}}throw new Error(`There is not prediction for ${e}`)}function howManyActived(t){let e=0;for(const n in t)e+=t[n].length;return e}function exploreTree(t,e,n,s){const{currentAtomTypes:i,restrictionByCS:o,timeout:a,timeStart:r,maxSolutions:l,targets:m,predictions:c,correlations:u,lowerBoundScore:g,possibleAssignmentMap:C,diaIDPeerPossibleAssignment:f}=t;if(Date.now()-r>a)return s;for(const t of i){const{currentIndex:p,nSources:h}=e[t];if(p>=h-1&&null!==n[t][p])continue;const d=f[t][p],y=C[t][d];for(const h of y){n[t][p]=h;const d=partialScore(n,{diaIDPeerPossibleAssignment:f,infoByAtomTypes:e,restrictionByCS:o,predictions:c,correlations:u,targets:m});if(0!==d)if(isLastOne(i,e)&&d>=g)addSolution(s,{predictions:c,partial:n,score:d,maxSolutions:l});else{const p=JSON.parse(JSON.stringify(e));p[t].currentIndex+=1,exploreTree({currentAtomTypes:i,restrictionByCS:o,timeout:a,timeStart:r,maxSolutions:l,targets:m,predictions:c,correlations:u,lowerBoundScore:g,possibleAssignmentMap:C,diaIDPeerPossibleAssignment:f},p,JSON.parse(JSON.stringify(n)),s)}}}}function addSolution(t,e){const{score:n,maxSolutions:s,partial:i,predictions:o}=e,a={assignment:JSON.parse(JSON.stringify(i)),score:n/doubleAssignmentPenalty(i,o)};t.nSolutions>=s?a.score>t.solutions.last().score&&(t.solutions.pollLast(),t.solutions.add(a)):(t.solutions.add(a),t.nSolutions++)}function isLastOne(t,e){let n=!0;for(const s of t){const{currentIndex:t,nSources:i}=e[s];n=n&&t>=i-1}return n}function doubleAssignmentPenalty(t,e){let n=0;for(const s in e){n+=Object.keys(e[s]).length-new Set(t[s]).size}return n>0?2*n:1}function isSpectraData1D(t){return"ranges"in t}function searchIndices(t,e){for(let n=0;n<e.length;n++){const s=e[n],i=isSpectraData1D(s)?s.ranges:s.zones;for(let e=0;e<i.length;e++){const s=i[e].signals||[];for(let i=0;i<s.length;i++)if(t===s[i].id)return{spectrumIndex:n,signalIndex:i,elementIndex:e}}}throw new Error(`There is not a signal with ${t} ID`)}const comparator=(t,e)=>e.score-t.score,predictor={H:predictProton,C:predictCarbon};function checkNMRSignal1D(t){const e=["nbAtoms","diaIDs","atoms"];for(const n of t)for(const t of e)if(!n[t])throw new Error(`property ${t} does not exist`)}const getAllHydrogens={C:(t,e)=>t.getAllHydrogens(e),H:()=>1};async function buildAssignments(t){const{spectra:e,molecule:n,restrictionByCS:s,timeout:i,minScore:o,nbAllowedUnAssigned:a={},maxSolutions:r,correlations:l,assignmentOrder:m,predictionOptions:c,predictions:u={},targets:g}=t,C=o;let f={solutions:new TreeSet$1(comparator),nSolutions:0};const p=getConnectivityMatrix(n,{pathLength:!0}),h={},d={};let y={},H={};for(const t of m){for(const e of t){const t=c[e],s=u[e],{joinedSignals:i}=s?{joinedSignals:s}:await predictor[e](n,t);checkNMRSignal1D(i),d[e]||(d[e]={});let o=0;for(const t of i){const s=t.diaIDs[0],i=t.atoms[0],a=getAllHydrogens[e](n,i);o+=t.nbAtoms*a,d[e][s]={...t,diaIDIndex:i,allHydrogens:t.nbAtoms*a,protonsCount:a,pathLength:p[i]}}for(const t in d[e])d[e][t].allHydrogens*=100/o;h[e]={nSources:i.length,currentIndex:0,nbAllowedUnAssigned:a[e]||0}}y=createMapPossibleAssignment(y,{restrictionByCS:s,predictions:d,targets:g}),H={};for(const t in y)H[t]=Object.keys(y[t]);const e=getSourceOfPartials(f,h,t);f={solutions:new TreeSet$1(comparator),nSolutions:0};const o=Date.now();for(const n of e)exploreTree({currentAtomTypes:t,restrictionByCS:s,timeout:i,timeStart:o,targets:g,predictions:d,correlations:l,maxSolutions:r,lowerBoundScore:C,possibleAssignmentMap:y,diaIDPeerPossibleAssignment:H},h,n,f)}return annotateSpectraData({store:f,spectra:e,diaIDPeerPossibleAssignment:H,targets:g})}function annotateSpectraData(t){const{store:e,spectra:n,diaIDPeerPossibleAssignment:s,targets:i}=t,{solutions:o}=e,a={},r=Object.keys(i);for(const t of r){const e=i[t];for(const t in e){const s=e[t];for(const t of s.link){const e=t.signal.id;a[e]||(a[t.signal.id]=searchIndices(e,n))}}}const l=[];for(const t of o.elements){const e=JSON.parse(JSON.stringify(n)),{assignment:o,score:r}=t,m=Object.keys(o);for(const t of m){const n=i[t],r=o[t];for(let i=0;i<r.length;i++){const o=r[i];if("*"===o||!o)continue;const l=n[o],m=s[t][i];for(const t of l.link){const{spectrumIndex:n,elementIndex:s,signalIndex:i}=a[t.signal.id],o=e[n];if(isSpectraData1D(o)){const{ranges:t}=o,e=t[s].signals[i];if(e.diaIDs||(e.diaIDs=[]),e.diaIDs.includes(m))continue;e.diaIDs.push(m)}else{const e=t.axis,n=o.zones[s].signals[i];if(n[e].diaIDs||(n[e].diaIDs=[]),n[e].diaIDs?.includes(m))continue;n[e].diaIDs?.push(m)}}}}l.push({score:r,assignment:e})}return l}function getSourceOfPartials(t,e,n){return t.nSolutions>0?t.solutions.elements.map((t=>{const s=t.assignment;for(const t of n)s[t]=fillPartial(e[t].nSources);return s})):initializePartials(e,n)}function initializePartials(t,e){const n={},s=Object.keys(t);for(const i of s){const s=e.includes(i)?null:"*";n[i]=fillPartial(t[i].nSources,s)}return[n]}function fillPartial(t,e=null){const n=new Array(t);for(let s=0;s<t;s++)n[s]=e;return n}function checkIDs(t=[]){const e=JSON.parse(JSON.stringify(t)),n=[];for(const t of e){if(!("info"in t))throw new Error("each spectrum should contain info properties with nucleus information");const{info:e,id:s}=t;if(isSpectraData1D(t)){const i=addIDs(t.ranges);n.push({id:s,info:e,ranges:i})}else{const i=addIDs(t.zones);n.push({id:s,info:e,zones:i})}}return n}function hasIDs(t){for(const e of t){if(!e.id)throw new Error("A range/zone has not an ID");for(const t of e.signals||[])if(!t.id)throw new Error("A signal has not an ID")}}function addIDs(t){for(const e of t){e.id||(e.id=v4());for(const t of e.signals||[])t.id||(t.id=v4())}return hasIDs(t),t}function formatData(t=[]){const e=JSON.parse(JSON.stringify(t)),n=[];for(const t of e){const{id:e,info:s}=t;if(isSpectraData1D(t)){const i=rescaleIntegration({id:e,info:s,ranges:t.ranges});n.push({id:e,info:s,ranges:{values:i}})}else n.push({id:e,info:s,zones:{values:t.zones}})}return n}function rescaleIntegration(t){if("1H"!==t.info.nucleus)return t.ranges;const e=t.ranges.reduce(((t,e)=>e.integration?t+e.integration:t),0);for(const n of t.ranges)if(n.integration&&(n.integration*=100/e,n.signals)){const t=n.signals.reduce(((t,e)=>e.integration?t+e.integration:t),0);for(const e of n.signals)e.integration?e.integration*=n.integration/t:e.integration=n.integration}return t.ranges}function getIntegrationOfAttachedProtons(t,e){const{H:n=[]}=t.attachment;let s=0;for(const t of n){const n=e[t];s+=Number(n.link[0].signal.integration)}return s}function getTargetsAndCorrelations(t,e={}){const{tolerance:n={C:.25,H:.05}}=e,s=formatData(t),{values:i}=buildCorrelationData(s,{tolerance:n}),o={};for(const t of i){if(t.pseudo)continue;const{id:e,atomType:n}=t;o[n]||(o[n]={}),o[n][e]=t,o[n][e].integration="H"===n?t.link[0].signal.integration:getIntegrationOfAttachedProtons(t,i)}return{targets:o,correlations:i}}function getWorkFlow(t,e=[]){const n=extractExperimentType(t),{hasHSQC:s,types:i}=n;if(e.length>0)return{assignmentOrder:e,experimentTypes:n};const o=[];return s?o.push(["C"],["H"]):o.push(i.filter((t=>"H"===t||"C"===t))),{assignmentOrder:o,experimentTypes:n}}function extractExperimentType(t){const e=[];for(const n of t){let t=n.experimentType;"1d"===t&&(t=`${n.atomType.toUpperCase()}`),e.includes(t)||e.push(t);for(const s of n.link)t=s.experimentType,"1d"===t&&(t=`${s.atomType[0].toUpperCase()}`),e.includes(t)||e.push(t)}return{types:e,hasProton:e.includes("H"),hasCarbon:e.includes("C"),hasHSQC:e.includes("hsqc")}}async function getAssignments(t,e={}){const{restrictionByCS:n={},justAssign:s,minScore:i=.01,maxSolutions:o=10,nbAllowedUnAssigned:a,timeout:r=6e3,predictionOptions:l={},predictions:m={},correlation:c={}}=e,{tolerance:u={H:.2,C:1},useChemicalShiftScore:g=!1,chemicalShiftRestriction:C=!0}=n,f=t.molecule;if(!f)throw new Error("It is needed a molecule to assign");f.addImplicitHydrogens(),ensureHeterotopicChiralBonds(f);const p=checkIDs(t.spectra),{targets:h,correlations:d}=getTargetsAndCorrelations(p,c),{assignmentOrder:y}=getWorkFlow(d,s);return await buildAssignments({restrictionByCS:{tolerance:u,useChemicalShiftScore:g,chemicalShiftRestriction:C},spectra:p,molecule:f,timeout:r,minScore:i,maxSolutions:o,assignmentOrder:y,nbAllowedUnAssigned:a,correlations:d,targets:h,predictionOptions:l,predictions:m})}function selectACSPattern(t){const e=couplingValues[t];if(!e)throw new Error(`multiplicity pattern ${t} is not supported`);return couplingACSPatterns[e]}function signalMultiplicityPattern(t,e){const n=t.js;let s="";if(n&&n.length>0)for(const t of n){const{multiplicity:n=""}=t;s+=e?.acsFormat?selectACSPattern(n):n}else s=t.delta?"":"m";return s}const globalOptions={h:{nucleus:"1H",nbDecimalDelta:2,nbDecimalJ:1,observedFrequency:400},c:{nucleus:"13C",nbDecimalDelta:1,nbDecimalJ:1,observedFrequency:100},f:{nucleus:"19F",nbDecimalDelta:2,nbDecimalJ:1,observedFrequency:400}};function rangesToACS(t,e={}){e.nucleus||(e.nucleus="1H");const n=e.nucleus.toLowerCase().replace(/[0-9]/g,"");e={...globalOptions[n],ascending:!1,format:"IMJA",...e},t=JSON.parse(JSON.stringify(t)),!0===e.ascending&&t.sort(((t,e)=>Math.min(t.from,t.to)-Math.min(e.from,e.to)));let s=formatAcs(t,e);return s.length>0&&(s+="."),s}function formatAcs(t,e){let n=spectroInformation(e);0===n.length&&(n="δ ");const s=[];for(const n of t)uselessKind(n.kind,e.filter)||pushDelta(n,s,e);return s.length>0?n+s.join(", "):""}function spectroInformation(t){const e=[];let n=`${formatNucleus(t.nucleus)} NMR`;return t.solvent&&e.push(formatMF(t.solvent)),t.observedFrequency&&e.push(`${(1*t.observedFrequency).toFixed(0)} MHz`),e.length>0?n+=` (${e.join(", ")}): δ `:n+=": δ ",n}function pushDelta(t,e,n){let s="",i=[];const o=[t.from,t.to];if(t.signals&&(t.signals=t.signals.filter((t=>!uselessKind(t.kind,n.filter)))),t.signals&&t.signals.length>0){const e=t.signals;if(e.length>1){if(!0===n.ascending&&e.sort(((t,e)=>t.delta-e.delta)),s+=`${Math.min(...o).toFixed(n.nbDecimalDelta)}-${Math.max(...o).toFixed(n.nbDecimalDelta)}`,s+=` (${getIntegral(t,n)}`,e.some((t=>t.multiplicity||t.js&&t.js.length>0)))for(const t of e){i=[],void 0!==t.delta&&(s=appendSeparator(s),s+=t.delta.toFixed(n.nbDecimalDelta));switchFormat({from:Number.MIN_SAFE_INTEGER,to:Number.MAX_SAFE_INTEGER},t,i,n),i.length>0&&(s+=` (${i.join(", ")})`)}s+=")"}else i=[],void 0!==e[0].delta?(s+=e[0].delta.toFixed(n.nbDecimalDelta),switchFormat(t,e[0],i,n),i.length>0&&(s+=` (${i.join(", ")})`)):(s+=`${Math.min(...o).toFixed(n.nbDecimalDelta)}-${Math.max(...o).toFixed(n.nbDecimalDelta)}`,switchFormat(t,e[0],i,n),i.length>0&&(s+=` (${i})`))}else{s+=`${Math.min(...o).toFixed(n.nbDecimalDelta)}-${Math.max(...o).toFixed(n.nbDecimalDelta)}`;switchFormat(t,{},i,n),i.length>0&&(s+=` (${i.join(", ")})`)}e.push(s)}function getIntegral(t,e){let n="";if(t.pubIntegral)n=String(t.pubIntegral);else if(t.integration){const{nucleus:s}=e;n=t.integration.toFixed(0)+s[s.length-1]}return n}function pushIntegral(t,e,n){const s=getIntegral(t,n);s.length>0&&e.push(s)}function pushmultiplicityFromSignal(t,e){let n=t.multiplicity;if(!n){n=signalMultiplicityPattern(signalJoinCouplings(t,{acsFormat:!0,tolerance:.05,ignoreDiaIDs:!0}))}n.length>0&&e.push(n)}function switchFormat(t,e,n,s){for(const i of s.format)switch(i.toUpperCase()){case"I":pushIntegral(t,n,s);break;case"M":pushmultiplicityFromSignal(e,n);break;case"A":pushAssignment(e,n);break;case"J":pushCoupling(e,n,s);break;default:throw new Error(`Unknow format letter: ${i}`)}}function formatMF(t){return t.replace(/(?<num>[0-9]+)/g,"<sub>$<num></sub>")}function formatNucleus(t){return t.replace(/(?<num>[0-9]+)/g,"<sup>$<num></sup>")}function appendSeparator(t){return t.length>0&&!/ $/.exec(t)&&!/\($/.exec(t)&&(t+=", "),t}function formatAssignment(t){return t=(t=t.replace(/(?<num>[0-9]+)/g,"<sub>$<num></sub>")).replace(/"(?<i>[^"]*)"/g,"<i>$<i></i>")}function pushCoupling(t,e,n){if(Array.isArray(t.js)&&t.js.length>0){t.js.sort(((t,e)=>e.coupling-t.coupling));const s=[];for(const e of t.js)void 0!==e.coupling&&s.push(e.coupling.toFixed(n.nbDecimalJ));s.length>0&&e.push(`<i>J</i> = ${s.join(", ")} Hz`)}}function pushAssignment(t,e){t.assignment&&e.push(formatAssignment(t.assignment))}function uselessKind(t="",e=!0){return t=t.toLowerCase(),!(!e||"impurity"!==t&&"solvent"!==t)}function addDummySignals(t){const e=JSON.parse(JSON.stringify(t));let n=t.reduce(((t,e)=>{const{atoms:n=[]}=e;return Math.max(...n)>t?Math.max(...n):t}),0)+1;return t.forEach(((s,i)=>{const{js:o=[],atoms:a=[n++]}=s,{newCouplings:r,tempSignals:l}=checkCouplings(o,a,n+t.length);l.length>0&&e.push(...l),e[i].js=r,e[i].atoms=a})),e.sort(((t,e)=>t.delta-e.delta))}function checkCouplings(t,e,n){const s=[];return{newCouplings:t.reduce(((t,i)=>{const{atoms:o=[],multiplicity:a,coupling:r}=i;if(0===o.length)if(r&&a){const i=[],o=couplingPatterns.indexOf(a);for(let t=0;t<o;t++)n++,i.push({coupling:r,atoms:[n]}),s.push(formatSignal(r,[n],e));t.push(...i)}else t.push(i);return t}),[]),tempSignals:s}}function formatSignal(t,e,n){return{delta:1e5,atoms:e,js:[{coupling:t,atoms:n}]}}function hackSignalsToXY(t,e={}){return signalsToXY(addDummySignals(t),e)}function checkForSignals(t){for(const e of t)if(!e.signals)throw new Error("range has not signals")}const defaultFromTo=(t="")=>"13C"===t.toUpperCase()?{from:-5,to:206}:{from:-.5,to:10.5};function rangesToXY(t,e={}){checkForSignals(t);const{frequency:n=400,lineWidth:s=1,nbPoints:i=16384,shape:o={kind:"gaussian"}}=e,a=(t,e)=>{for(let n=0;n<i;n++)t[n]+=e[n]},{from:r,to:l}=getFromTo(t,e),m={to:l,from:r,nbPoints:i,shape:o,lineWidth:s,frequency:n},c=new Float64Array(i);for(const e of t){const{integration:t,signals:n=[]}=e,{multiplicity:s=""}=e;if("m"===s&&n.length<1){const{from:t,to:s}=e;n.push({delta:(t+s)/2,multiplicity:"m"})}const o=new Float64Array(i);for(const t of n){const{multiplicity:e}=t,n="m"===e||"b"===e||"br s"===e?broadPeakOrMultipletSpectrum([t],m).y:hackSignalsToXY([t],m).y;normalizeSpectrum(n,[t]),a(o,n)}e.integration&&normalizeSpectrum(o,n,{integration:t}),a(c,o)}return{x:xSequentialFill({from:r,to:l,size:i}),y:c}}function broadPeakOrMultipletSpectrum(t,e={}){const{lineWidth:n,frequency:s}=e,i=new SpectrumGenerator(e),o=3*n/s;for(const e of t){const{multiplicity:t,delta:a,integration:r=1}=e;if("b"===t||"br s"===t)i.addPeak({x:a,y:r,width:o});else{const t=peaksOfMultiplet(a,{lineWidth:n,frequency:s});i.addPeaks(t)}}return i.getSpectrum()}function peaksOfMultiplet(t,e){const{frequency:n,lineWidth:s,intensities:i=[1,2,5,4,5,7,5,4,5,2,1]}=e,o=s/n,a=1.5*o,r=[],l=t-a*i.length/2;for(let t=0;t<i.length;t++)r.push({x:l+a*t,y:i[t],width:o});return r}function normalizeSpectrum(t,e,n={}){const{integration:s=e.reduce(((t,e)=>{const{integration:n=1}=e;return t+n}),0)}=n,i=t.reduce(((t,e)=>t+e),0);if(0!==i){const e=s/i*1e6;for(let n=0;n<t.length;n++)t[n]*=e}}function getFromTo(t,e){const{from:n,to:s}=defaultFromTo(e.nucleus);let i=Number.MAX_SAFE_INTEGER,o=Number.MIN_SAFE_INTEGER;for(const e of t)for(const t of e.signals||[])i>t.delta&&(i=t.delta),o<t.delta&&(o=t.delta);const{from:a=Math.min(i-.5,n),to:r=Math.max(o+.5,s)}=e;return{from:a,to:r}}function directOptimization(t,e,n){const{minValues:s,maxValues:i,directOptions:o={}}=n,a=direct(getObjectiveFunction(t,e),s,i,o),{optima:r}=a;return{error:a.minFunctionValue,iterations:a.iterations,parameterValues:r[0]}}function getObjectiveFunction(t,e){const{x:n,y:s}=t,i=n.length;return t=>{const o=e(t);let a=0;for(let t=0;t<i;t++)a+=Math.pow(s[t]-o(n[t]),2);return a}}const defaultParameters={delta:{init:t=>t.signal.delta,min:t=>t.signal.delta-2*t.shape.fwhm,max:t=>t.signal.delta+2*t.shape.fwhm,gradientDifference:()=>.002},intensity:{init:t=>t.signal.intensity||1,min:()=>0,max:()=>1.5,gradientDifference:()=>.001},fwhm:{init:t=>t.shape.fwhm,min:t=>.25*t.shape.fwhm,max:t=>4*t.shape.fwhm,gradientDifference:t=>.002*t.shape.fwhm},mu:{init:t=>t.shape.mu||.5,min:()=>0,max:()=>1,gradientDifference:()=>.01},coupling:{init:t=>t.jCoupling.coupling,min:t=>.8*t.jCoupling.coupling,max:t=>1.2*t.jCoupling.coupling,gradientDifference:()=>.01}};function signalsToPointXY(t,e){const{frequency:n,maxClusterSize:s=1}=e,i=signalsToSpinSystem(addDummySignals(t));i.clusters=splitSpinSystem(i,{frequency:n,maxClusterSize:s});const o=simulateXYPeaks(i,e).filter((t=>t.x<1e3)),a=o.reduce(((t,e)=>e.y>t?e.y:t),Number.MIN_SAFE_INTEGER);for(const t of o)t.y/=a;return o}const properties=["init","min","max","gradientDifference"];function getInternalSignals(t,e,n,s){let i=0;const o=[],{shape:a={kind:"gaussian"},baseline:r=n.min,lineWidth:l=1,frequency:m}=s,c=normalizeSignals({signals:e,data:t,shiftValue:r,frequency:m,range:n.range});for(const t of c){const{shape:e={...a}}=t;e.fwhm||(e.fwhm=l),e.fwhm/=m;const r=getShape1D(e),c=["delta","intensity",...r.getParameters()],u={min:[],max:[],init:[],gradientDifference:[]};for(const e of c)for(const s of properties)u[s].push(getPropertyValue({signal:t,frequency:m,parameter:e,property:s,minMaxY:n,shapeFct:r}));for(const e of t.js||[])for(const t of properties){const i="coupling",o=s?.parameters?.[i]?.[t];if(o)if("number"==typeof o)u[t].push(getNormalizedValue(o,i,t,n,m,s.baseline));else{const a=o({jCoupling:e});u[t].push(getNormalizedValue(a,i,t,n,m,s.baseline))}if(!defaultParameters[i])throw new Error(`No default parameter for ${i}`);const a=defaultParameters[i][t];u[t].push(a({jCoupling:e}))}const g=i,C=g+c.length-1,f=C+1,p=f+t.js.length-1;i+=p-g+1,o.push({shape:e,shapeFct:r,signal:t,parameters:c,propertiesValues:u,fromIndex:g,toIndex:C,fromIndexCoupling:f,toIndexCoupling:p})}return o}function normalizeSignals(t){const{signals:e,data:n,frequency:s,shiftValue:i,range:o}=t,a=t=>{const e=signalsToPointXY([t],{frequency:s,maxClusterSize:1}),i=e.reduce(((t,e)=>e.y>t.y?e:t),e[0]),{y:o}=xyFindClosestPoint(n,i.x);return o};return e.map((t=>{const{intensity:e=a(t)}=t;return{...t,js:t.js||[],intensity:(e-i)/o}}))}function getPropertyValue(t){const{signal:e,frequency:n,parameter:s,property:i,minMaxY:o,shapeFct:a}=t,r=e?.parameters?.[s]?.[i];if(r)return getNormalizedValue(r,s,i,o,n,t.baseline);const l=t?.parameters?.[s]?.[i];if(l){if("number"==typeof l)return getNormalizedValue(l,s,i,o,n,t.baseline);return getNormalizedValue(l(e),s,i,o,n,t.baseline)}if(!defaultParameters[s])throw new Error(`No default parameter for ${s}`);return(0,defaultParameters[s][i])({signal:e,shape:a})}function getNormalizedValue(t,e,n,s,i,o){return"intensity"===e?"gradientDifference"===n?t:void 0!==o?(t-o)/s.range:(t-s.min)/s.range:"fwhm"===e?t/i:t}const defaultSimulationOptions={maxClusterSize:1};function getSumOfShapes(t,e){const n={...defaultSimulationOptions,...e};return function(e){const s=[];for(const i of t){const t=e[i.fromIndex],o=e[i.fromIndex+1];for(let t=2;t<i.parameters.length;t++)i.shapeFct[i.parameters[t]]=e[i.fromIndex+t];const a=i.signal.js;for(let t=0;t<a.length;t++)a[t].coupling=e[i.fromIndexCoupling+t];const r=signalsToPointXY([{delta:t,js:a}],n);s.push(...r.map((t=>({intensity:o,shape:i.shapeFct,...t}))))}return t=>{let e=0;for(const n of s){const{x:s,y:i,intensity:o,shape:a}=n;e+=i*o*a.fct(t-s)}return e}}}const defaultLMOptimizationOptions={damping:1.5,maxIterations:100,errorTolerance:1e-8},defaultDirectOptimizationOptions={iterations:25};function optimizeSignals(t,e,n){const{optimization:s={},simulation:i,...o}=n,a=xMinMaxValues(t.y),r={...a,range:a.max-a.min},l=getInternalSignals(t,e,r,{frequency:i.frequency,...o}),{baseline:m=r.min}=n,c=new Float64Array(t.y.length);for(let e=0;e<t.y.length;e++)c[e]=(t.y[e]-m)/r.range;const u=l[l.length-1].toIndexCoupling+1,g=new Float64Array(u),C=new Float64Array(u),f=new Float64Array(u),p=new Float64Array(u);let h=0;for(const t of l){for(let e=0;e<t.parameters.length;e++)g[h]=t.propertiesValues.min[e],C[h]=t.propertiesValues.max[e],f[h]=t.propertiesValues.init[e],p[h++]=t.propertiesValues.gradientDifference[e];for(let e=t.parameters.length;e<t.parameters.length+t.signal.js.length;e++)g[h]=t.propertiesValues.min[e],C[h]=t.propertiesValues.max[e],f[h]=t.propertiesValues.init[e],p[h++]=t.propertiesValues.gradientDifference[e]}const d=getSumOfShapes(l,i),{kind:y,options:H}=s,[b,v]="direct"===y?[directOptimization,defaultDirectOptimizationOptions]:[levenbergMarquardt,defaultLMOptimizationOptions],w=b({x:t.x,y:c},d,{minValues:g,maxValues:C,initialValues:f,gradientDifference:p,...v,...H}).parameterValues,x=[];for(const t of l){const{fromIndexCoupling:e}=t,n=t.signal.js.map(((t,n)=>(t.coupling=w[e+n],t))),s=w[t.fromIndex],o=signalsToPointXY([{delta:s,js:n}],i),a=w[t.fromIndex+1]*r.range+m,l=[];for(const{x:e,y:n}of o){const s={id:v4(),x:e,y:a*n,width:0,shape:{...t.shape}};for(let e=2;e<t.parameters.length;e++)s.shape[t.parameters[e]]=w[t.fromIndex+e];s.shape.fwhm*=i.frequency,s.width=getShape1D(s.shape).fwhmToWidth(s.shape.fwhm),l.push(s)}x.push({delta:s,js:n,shape:{...l[0].shape},intensity:a,peaks:l})}return x}function applyWindow(t,e){const n=t.length,{windowData:s,start:i=0,length:o=n,pointsToShift:a=0,output:r=new Float64Array(t)}=e,l=Math.min(i+o,n-a);for(let t=i,e=0;t<l;t++)r[t]*=s[e++];for(let t=n-1,e=0;t>n-a-1;t--)r[t]*=s[e++];return r}function exponential(t){const{lb:e,dw:n}=t,s=-e*Math.PI*n;return t=>Math.exp(s*t)}function lorentzToGauss(t){const{dw:e,length:n,gaussianHz:s=0,exponentialHz:i=0,center:o=0}=t;if(o>1||o<0)throw new Error("The center of gaussian shape should be inside of the window function: 0 - 1");const a=Math.pow(.6*Math.PI*s*e,2),r=o*(n-1),l=Math.PI*e*i;return t=>Math.exp(t*l-Math.pow(r-t,2)*a)}function sineBell(t){const{exponent:e=1,offset:n=0,end:s=1,length:i}=t;if(void 0===i)throw new Error("length options should exists for sineBell shape");if(s<0||s>1)throw new Error("the end parameter should be [0-1]");const o=Math.PI*n,a=Math.PI*(s-n)/(i-1);return t=>Math.pow(Math.sin(o+a*t),e)}function getFunction(t){const{kind:e,options:n}=t;switch(e){case"exponential":return exponential(n);case"lorentzToGauss":return lorentzToGauss(n);case"sineBell":return sineBell(n);default:throw Error(`Unknown distribution ${e}`)}}function getData(t,e){const n=new Float64Array(e);let s=Number.MIN_SAFE_INTEGER;for(let i=0;i<e;i++){const e=t(i);n[i]=e,e>s&&(s=e)}for(let t=0;t<e;t++)n[t]/=s;return n}function compose(t){const{length:e,shapes:n=[]}=t,s=new Float64Array(e).fill(1);return n.forEach((t=>{const{shape:n,start:i=0}=t,{options:o}=n,a="length"in o?o.length:e-i,r=getData(getFunction(n),a);applyWindow(s,{windowData:r,length:a,start:i,output:s})})),s}function apodization$1(t,e={}){const{compose:n,pointsToShift:s,apply:i=!0}=e;if(!n)return{...t,windowData:new Float64Array(t.re.length).fill(1)};const o=compose(n),a={windowData:o,pointsToShift:s};return{re:i?applyWindow(t.re,a):t.re,im:i?applyWindow(t.im,a):t.im,windowData:o}}const twoPi=2*Math.PI;function signalsToFID(t,e){const{lb:n=1,from:s=0,to:i=10,nbPoints:o=1024,frequency:a=400,maxClusterSize:r=8}=e,l=signalsToSpinSystem(t);l.clusters=splitSpinSystem(l,{frequency:a,maxClusterSize:r});const m=simulateXYPeaks(l,{frequency:a}),c=new Float64Array(o),u=new Float64Array(o),g=o/(Math.abs(i-s)*a),C=xSequentialFill({size:o,from:0,to:g});for(const t of m){const{x:e,y:n}=t,s=e*a*twoPi;for(let t=0;t<o;t++)c[t]+=n*Math.cos(s*C[t]),u[t]+=n*Math.sin(s*C[t])}const{windowData:f,...p}=apodization$1({re:c,im:u},{pointsToShift:0,compose:{length:o,shapes:[{start:0,shape:{kind:"exponential",options:{dw:g/(o-1),lb:n}}}]}});return p}let possiblePatterns=[];for(const{label:t,value:e,names:n}of MultiplicityPatterns)possiblePatterns.push(t,e,...n);function splitPatterns(t){if(/^\s*$/.exec(t))return[];const e=new RegExp(possiblePatterns.join("|"),"g"),n=t.match(e);return n?n.map((t=>t.trim())):[t]}function splitParenthesis(t){const e=/ *(?<before>[^(]*?) *\( *(?<inside>.*?) *\) *(?<after>.*?) */.exec(t);return e?e.groups:{before:t,inside:"",after:""}}function resurrectRange(t,e={}){const{nucleus:n="1h",frequency:s=400}=e,i=splitParenthesis(t);if(!i.before)return;const o=/.*?(?<from>-?[0-9.]+)-?(?<to>-?[0-9.]*).*/.exec(i.before);if(!o?.groups)return;const a=""!==o.groups.to,r=Number(o.groups.from),l=a?Number(o.groups.to):r,m=i.inside.split(/ *, */),c={delta:NaN,js:[]};let u={from:r,to:l,signals:[c]};const g=m.filter((t=>t.match(/^[0-9]+\s*H$/)));1===g.length&&(u.integration=Number(g[0].replace("H","")));const C=m.filter((t=>t.match(/^([br ]*)\.*\s*[a-zA-Z]+\.*$/)));if(1===C.length){const t=C[0];"m"===t?a?(c.delta=(r+l)/2,c.multiplicity=t):(c.delta=r,c.multiplicity=t):a||(c.delta=r,c.multiplicity=t)}const f=m.filter((t=>t.match(/(Hz|J|^[0-9.]+$)/))).map((t=>Number(t.replace(/J[0-9.]*\s*=/,"J =").replace(/[^0-9.]/g,"")))),p=splitPatterns(c.multiplicity||"");if(p.length===f.length)for(let t=0;t<p.length;t++){if(!c.js)throw new Error("signal has not js");c.js.push({coupling:f[t],multiplicity:p[t]})}return u.from===u.to&&(u={...u,...rangeFromSignal(c,{nucleus:n,frequency:s})}),u}function resurrect(t){const e={experiment:{},ranges:[],acsString:t,normalized:t.replace(/\.\s*$/,"").replace(/[\r\n\t]/g," ").replace(/[;:]/g,",").replace(/\}/g,")").replace(/\{/g,"(").replace(/[\u2011\u2012\u2013\u2014\u2015\u2212]/g,"-")};return createParts(e),parseParts(e),e}function parseParts(t){for(const e of t.parts)if(e.toLowerCase().includes("nmr"))processExperiment(t,e);else{const{frequency:n,nucleus:s}=t.experiment,i=resurrectRange(e,{frequency:n,nucleus:s});i&&t.ranges.push(i)}}function processExperiment(t,e){const n=splitParenthesis(e),s=n.before.replace(/[ -]*nmr[ -]*/i,"").replace(/[ -]/g,"");if(/^[0-9]+[A-Z][a-z]?$/.exec(s)&&(t.experiment.nucleus=s),/^[A-Z][a-z]?[0-9]+$/.exec(s)&&(t.experiment.nucleus=s.replace(/^([A-Z][a-z]?)([0-9]+)$/,"$2$1")),n.inside){const e=n.inside.split(/[,]/),s=e.filter((t=>/[0-9]{2}/.exec(t)));if(s.length){const e=s[0].replace(/[^0-9]/g,"");e.length>1&&(t.experiment.frequency=Number(e))}const i=e.filter((t=>!t.match(/[0-9]{2}/)));i.length&&(t.experiment.solvent=i[0])}}function createParts(t){const e=t.normalized.split(/\)(?![^()]*\))/).map((t=>t.replace(/^\s*(.*?)\s*$/,"$1"))).filter((t=>t)).map((t=>`${t})`)).map((t=>t.replace(/\(([^()]+)\)(?!$)/g,"[$1]"))).map((t=>t.split(/[,;](?![^()]*\))/))).flat().map((t=>t.replace(/^\s*(.*?)\s*$/,"$1"))).filter((t=>t));t.parts=e}possiblePatterns=possiblePatterns.sort(((t,e)=>e.length-t.length));const nucleusSymbolMap={proton:"1H",hydrogen:"H",helium:"He",lithium:"Li",carbon:"C",nitrogen:"N",oxigen:"O",fluorine:"F",sodium:"Na",aluminum:"Al",silicon:"Si",phosphorus:"P",iron:"Fe",copper:"Cu",zinc:"Zn",xenon:"Xe"};function normalizeNucleus(t){if(gyromagneticRatio[t])return t;const e=t.replace(/\D/g,""),n=t.replace(/\d*\W*/g,"").toLowerCase(),s=`${e}${n.length>1?nucleusSymbolMap[n]:n.toUpperCase()}`;return gyromagneticRatio[s]?s:t}function convertWidthToHz(t,e){return convertWidth(t,{...e,convertTo:"hz"})}function xyAutoPeaksPicking(t,e){const{from:n,to:s,frequency:i,noiseLevel:o,thresholdFactor:a=3,minMaxRatio:r=.05,broadRatio:l=25e-5,useSanPlot:m=!1,smoothY:c=!0,optimize:u=!1,factorLimits:g=4,realTopDetection:C=!0,shape:f={kind:"gaussian"},optimization:p={kind:"lm"},broadWidth:h=.25,sgOptions:d={},direction:y="positive"}=e,H=1/i/(t.x[1]-t.x[0]),b=Math.max(Math.round(H/2),5),{windowSize:v=b-b%2+1,polynomial:w=3}=d;if(!v)throw new XYAutoPeaksPickingWindowSizeError({windowSize:v,ws:b,pointsPerHz:H,frequency:i,x:t.x.slice(0,2),sgOptions:d,autoWindowSizeFormula:"ws - (ws % 2) + 1",pointsPerHzFormula:"1 / frequency / (x[1] - x[0])"});if(t.x.length<v)return[];void 0!==n&&void 0!==s&&(t=xyExtract(t,{zones:[{from:n,to:s}]}));const x=getCutOff(t.y,{noiseLevel:o,useSanPlot:m,thresholdFactor:a}),O={shape:f,frequency:i,broadWidth:h,optimize:u,factorLimits:g,maxCriteria:!0,sgOptions:{windowSize:v,polynomial:w},minMaxRatio:r,broadRatio:l,noiseLevel:x.positive,smoothY:c,optimization:p,realTopDetection:C};switch(y){case"positive":return getPeakList(t,O);case"negative":return getNegativePeaks(t,x,O);case"both":return[...getPeakList(t,O),...getNegativePeaks(t,x,O)];default:throw Error(`Unknown distribution ${y}`)}}function getNegativePeaks(t,e,n){return n.noiseLevel=e.negative,n.maxCriteria=!1,getPeakList(t,n)}function getPeakList(t,e){const{shape:n,frequency:s,broadWidth:i,optimize:o,maxCriteria:a,factorLimits:r,sgOptions:l,minMaxRatio:m,broadRatio:c,noiseLevel:u,smoothY:g,optimization:C,realTopDetection:f}=e,p=gsd(t,{sgOptions:l,maxCriteria:a,minMaxRatio:m,noiseLevel:u,smoothY:g,realTopDetection:f}),h=setShape(p,{output:p,shape:n}),d=i?joinBroadPeaks(h,{broadRatio:c,broadWidth:i,shape:n,optimization:C}).map(toNMRPeak1DStructure):h.map(toNMRPeak1DStructure);return convertWidthToHz(o?optimizePeaks(t,d,{shape:n,factorLimits:r,optimization:C}).map(toNMRPeak1DStructure):d,{frequency:s})}function getCutOff(t,e){const{noiseLevel:n,useSanPlot:s,thresholdFactor:i}=e,o=t=>"number"==typeof t?{positive:t,negative:-t}:t;return n?o(n):s?xNoiseSanPlot(t,{factorStd:i}):o(xAbsoluteMedian(t)*i)}function toNMRPeak1DStructure(t){const{id:e,shape:n,x:s,y:i,width:o}=t;return{id:e,x:s,y:i,width:o,shape:n}}class XYAutoPeaksPickingWindowSizeError extends Error{constructor(t){super("windowSize must be an odd integer >= 5, check data property of this error for contextual information"),this.data=t}}function joinRanges(t){t.sort(((t,e)=>t.from-e.from));for(let e=0;e<t.length-1;e++){const n=t[e],s=t[e+1];n.to>s.from&&(n.id=v4(),n.to=Math.max(s.to,n.to),n.signals&&s.signals&&(n.signals=n.signals.concat(s.signals)),void 0!==n.integration&&(n.integration+=s.integration||0),t.splice(e+1,1),e--)}return t}const patterns=["s","d","t","q","quint","h","sept","o","n"],symRatio=1.5,maxErrorIter1=2.5,maxErrorIter2=1,jAxisKeys={jAxis:"x",intensity:"intensity"};function checkSignalForCompilePattern(t){if(!("symRank"in t))throw new Error("Internal error, symRank was not calculated");if(!("mask"in t))throw new Error("Internal Error, mask was not added")}var jAnalyzer={compilePattern:(t,e={})=>{const{jAxisKey:n=jAxisKeys}=e,s=symmetrizeChoiseBest(t,{maxError:maxErrorIter1,iteration:1,jAxisKey:n});if(s.multiplicity="m",s.asymmetric=!0,checkSignalForCompilePattern(s),s.symRank>=.95&&s.peaksComp.length<32){let t,e,n;s.asymmetric=!1;let i=1,o=[];for(let a=0;a<9;a++){const r=normalize(s,a);let l=!1;if(1===r.length&&0===a)l=!0;else if(r.length<=1)continue;const m=getRanges(r);e=Math.pow(2,a);let c=null,u=1;for(;!l&&null!==(c=getNextCombination(m,e))&&u<400;){const e=new Array(c.length);i=1;for(let t=0;t<c.length;t++){e[t]=new Array(c[t]);for(let n=0;n<c[t];n++)e[t][n]=i++}o=[];let s=1;o.push(r[1].x-r[0].x),t=r[0].x,e[0].splice(0,1),e[1].splice(0,1),i=1;let m=2;for(n=Math.pow(2,a)-1;o.length<a&&m<n&&i<r.length;){for(u+=1,s++;i<r.length&&0===e[i].length;)i++;if(i<r.length){o.push(r[i].x-r[0].x),e[i].splice(0,1),m++;for(let n=2;n<=s;n++){let s=0;for(let t=0;t<n;t++)s+=o[t];for(let n=1;n<e.length;n++)if(Math.abs(r[n].x-(t+s))<.25){e[n].splice(0,1),m++;break}}}}const g=idealPattern(o);l=!0;for(let t=0;t<g.length;t++)g[t].intensity!==c[t]&&(l=!1)}l&&updateSignal(s,o)}}for(const t of s.peaksComp)t.x/=s.observe,t.width*=s.observe;return s}};function updateSignal(t,e){const n=t.peaksComp,s=n.length;t.startX=n[0].x/t.observe-n[0].width,t.stopX=n[s-1].x/t.observe+n[s-1].width,t.integralData.from=n[0].x/t.observe-3*n[0].width,t.integralData.to=n[s-1].x/t.observe+3*n[s-1].width,t.maskPattern=t.mask2,t.multiplicity=abstractPattern(t,e),t.pattern=t.multiplicity}function abstractPattern(t,e){let n="",s=1;const i=[];if(e&&e.length>0){e.sort(((t,e)=>e-t));for(let t=0;t<e.length-1;t++)Math.abs(e[t]-e[t+1])<.05?s++:(i.push({coupling:Math.abs(e[t]),multiplicity:patterns[s]}),n+=patterns[s],s=1);const o=e.length-1;i.push({coupling:Math.abs(e[o]),multiplicity:patterns[s]}),n+=patterns[s],t.nmrJs=i}else n="s",Math.abs(t.startX-t.stopX)*t.observe>16&&(n="br s");return n}function idealPattern(t){const e=[{x:0,intensity:Math.pow(2,t.length)}];for(const n of t)for(let t=e.length-1;t>=0;t--)e.push({x:e[t].x+n/2,intensity:e[t].intensity/2}),e[t].x=e[t].x-n/2,e[t].intensity=e[t].intensity/2;e.sort(((t,e)=>t.x-e.x));for(let t=e.length-2;t>=0;t--)Math.abs(e[t].x-e[t+1].x)<.1&&(e[t].intensity+=e[t+1].intensity,e.splice(t+1,1));return e}function getNextCombination(t,e){const n=Math.ceil(.5*t.values.length),s=t.values.length;let i,o=0;for(;o!==e;){for(i=!1;!i;)if(i=!0,t.currentIndex[t.active]++,t.currentIndex[t.active]>=t.values[t.active].length){if(t.active+1===n)return null;t.currentIndex[t.active]=0,i=!1,t.active++}else t.active=0;o=0;for(let e=0;e<n;e++)o+=2*t.values[e][t.currentIndex[e]];t.values.length%2!=0&&(o-=t.values[n-1][t.currentIndex[n-1]])}if(o===e){const e=new Array(s);for(let i=0;i<n;i++)e[i]=t.values[i][t.currentIndex[i]],e[s-i-1]=t.values[i][t.currentIndex[i]];return e}return null}function getRanges(t){const e=new Array(t.length),n=new Array(t.length);let s,i;e[0]=[1],e[t.length-1]=[1],n[0]=-1,n[t.length-1]=0;for(let o=1;o<t.length-1;o++){s=Math.round(.85*t[o].intensity),i=Math.round(1.15*t[o].intensity),e[o]=[];for(let t=s;t<=i;t++)e[o].push(t);n[o]=0}return{values:e,currentIndex:n,active:0}}function symmetrizeChoiseBest(t,e){const{maxError:n,iteration:s,jAxisKey:i=jAxisKeys}=e,o=symmetrize(t,n,s,i);if(!o.peaksComp)throw new Error("internal peaksComp was not created");const a=o.peaksComp,r=o.mask,l=t.delta;t.delta=(t.peaks[0].x+t.peaks[t.peaks.length-1].x)/2;const m=symmetrize(t,n,s,i);if(!m.peaksComp)throw new Error("internal peaksComp was not created");return m.peaksComp.length>a.length?m:(t.delta=l,t.peaksComp=a,t.mask=r,o)}function symmetrize(t,e,n,s){const{jAxis:i,intensity:o}=s,a=JSON.parse(JSON.stringify(t));let r,l,m,c,u;const g=new Array(a.peaks.length);for(let t=0;t<g.length;t++){const e=a.peaks[t];g[t]={x:e[i]*a.observe,intensity:e[o],width:e.width/a.observe}}for(let t=g.length-2;t>=0;t--)Math.abs(g[t].x-g[t+1].x)<.25&&(g[t].x=g[t].x*g[t].intensity+g[t+1].x*g[t+1].intensity,g[t].intensity=g[t].intensity+g[t+1].intensity,g[t].x/=g[t].intensity,g[t].intensity/=2,g[t].width+=g[t+1].width,g.splice(t+1,1));a.peaksComp=g;const C=g.length,f=new Array(C);a.mask=f;let p=0,h=g.length-1,d=a.delta*a.observe,y=[(g[0].x+g[C-1].x)/2,1];e=error(Math.abs(d-y[0]));let H=0;for(let t=0;t<C;t++)f[t]=!0,H+=g[t].intensity;for(;p<=h;){if(f[p]=!0,f[h]=!0,p===h)C>2&&Math.abs(g[p].x-d)>e&&(f[p]=!1);else if(r=Math.max(g[p].intensity,g[h].intensity),l=Math.min(g[p].intensity,g[h].intensity),c=r/l,c>symRatio)g[p].intensity===l?(f[p]=!1,h++):(f[h]=!1,p--);else{const t=Math.abs(g[p].x-d),n=Math.abs(g[h].x-d);Math.abs(t-n)<e?(m=Math.min(g[p].intensity,g[h].intensity),u=Math.min(g[p].width,g[h].width),g[p].intensity=m,g[h].intensity=m,g[p].width=u,g[h].width=u,y=[y[0]+(g[h].x+g[p].x)/2,y[1]+1]):Math.max(t,n)===n?(f[h]=!1,p--):(f[p]=!1,h++)}if(p++,h--,1===n&&(d=chemicalShift(g,f),isNaN(d)))return a.symRank=0,a;e=error(Math.abs(d-y[0]/y[1]))}for(let t=C-1;t>=0;t--)!1===f[t]&&g.splice(t,1);if(d=chemicalShift(g),isNaN(d))return a.symRank=0,a;a.delta=d/a.observe;let b=0,v=0;if(g.length>1){for(let t=Math.ceil(g.length/2)-1;t>=0;t--)b+=(3+Math.min(Math.abs(g[t].x-d),Math.abs(g[g.length-1-t].x-d)))/(3+Math.max(Math.abs(g[t].x-d),Math.abs(g[g.length-1-t].x-d)))*g[t].intensity,v+=g[t].intensity;b/=v}else 1===g.length&&(b=1);let w=0;for(const t of g)w+=t.intensity;if(b-=(H-w)/H*.12,b>.8&&b<.97&&n<2)return symmetrize(a,maxErrorIter2,2,s);if(g.length>1){let t;for(let e=Math.ceil(g.length/2)-1;e>=0;e--)t=(g[e].x-g[g.length-1-e].x)/2,g[e].x=d+t,g[g.length-1-e].x=d-t}return a.symRank=b,a}function error(t){let e=2.5*t;return e<.75&&(e=.75),e>3&&(e=3),e}function normalize(t,e){const n=JSON.parse(JSON.stringify(t.peaksComp));let s=0,i=0;for(const t of n)s+=t.intensity;s=Math.pow(2,e)/s,t.mask2=t.mask.slice();let o=t.mask2.length-1;for(let e=n.length-1;e>=0;e--){for(n[e].intensity*=s;o>=0&&!t.mask2[o];)o--;n[e].intensity<.75?(n.splice(e,1),t.mask2[o]=!1):i+=n[e].intensity,o--}i=Math.pow(2,e)/i;for(let t=n.length-1;t>=0;t--)n[t].intensity*=i;return n}function chemicalShift(t,e=[]){let n,s=0,i=0;if(e.length>0)for(let o=0;o<t.length;o++)e[o]&&(n=getArea(t[o]),s+=n,i+=n*t[o].x);else for(const e of t)n=getArea(e),s+=n,i+=n*e.x;return i/s}function getArea(t){return Math.abs(t.intensity*t.width*1.57)}function checkSignalAfterCompilePattern(t){if(!t.mask)throw new Error("Internal Error, mask was not added");if(!t.mask2)throw new Error("Internal Error, mask2 was not added");if(!t.maskPattern)throw new Error("Internal Error, maskPattern was not added")}const assignSignal=(t,e,n)=>({id:v4(),delta:NaN,nbPeaks:1,kind:"signal",startX:t.x-t.width/e,stopX:t.x+t.width/e,observe:e,nucleus:n,integralData:{from:t.x-3*t.width/e,to:t.x+3*t.width/e,value:0},peaks:[{x:t.x,intensity:t.y,width:t.width}]});function peaksToRanges(t,e,n={}){const{integrationSum:s=100,joinOverlapRanges:i=!0,clean:o=.4,compile:a=!0,integralType:r="sum",frequency:l=400,frequencyCluster:m=16,keepPeaks:c=!1,nucleus:u="1H"}=n,g={integrationSum:s,integralType:r,frequencyCluster:m,frequency:l,nucleus:u};if(0===e.length)return[];t.x[0]>t.x[1]&&(t.x=t.x.reverse(),t.y=t.y.reverse());const C=detectSignals(t,e,g);if(o)for(let t=0;t<C.length;t++)Math.abs(C[t].integralData.value)<o&&C.splice(t,1);if(a){let e,n;for(let s=0;s<C.length;s++){C[s]=jAnalyzer.compilePattern(C[s]);const i=C[s];if(i.maskPattern&&"m"!==i.multiplicity&&""!==i.multiplicity){checkSignalAfterCompilePattern(i),e=0,n=0;const s=[];for(let t=i.maskPattern.length-1;t>=0;t--)if(n+=computeArea(i.peaks[t],l),!i.maskPattern[t]){const n=i.peaks.splice(t,1)[0];s.push({x:n.x,y:n.intensity,width:n.width}),i.mask.splice(t,1),i.mask2.splice(t,1),i.maskPattern.splice(t,1),i.nbPeaks--,e+=computeArea(n,l)}if(s.length>0){e=e*i.integralData.value/n,i.integralData.value-=e;const o=[];for(let t=s.length-1;t>=0;t--)o.push(s[t]);g.integrationSum=Math.abs(e);const a=detectSignals(t,o,g);for(const t of a)C.push(t)}}}updateIntegration(C,s)}if(C.sort(((t,e)=>e.delta-t.delta)),o)for(let t=C.length-1;t>=0;t--)Math.abs(C[t].integralData.value)<o&&C.splice(t,1);let f=[];for(let t=0;t<C.length;t++){const e=C[t],n={id:v4(),from:e.integralData.from,to:e.integralData.to,integration:e.integralData.value},s={delta:e.delta,kind:e.kind||"signal",multiplicity:e.multiplicity};c&&(s.peaks=e.peaks.map((t=>{const e={y:t.intensity,...t};return delete e.intensity,e}))),e.nmrJs&&(s.js=e.nmrJs),n.signals=[s],f[t]=n}return i&&(f=joinRanges(f)),f}function detectSignals(t,e,n={}){const{frequencyCluster:s=16,integrationSum:i=100,integralType:o="sum",frequency:a=400,nucleus:r="1H"}=n;let l,m=assignSignal(e[0],a,r);const c=[];let u={x:Number.MIN_SAFE_INTEGER};const g=s/a;for(const t of e){if(Math.abs(t.x-u.x)>g)m=assignSignal(t,a,r),t.kind&&(m.kind=t.kind),c.push(m);else{const e=t.x+t.width/a;m.stopX=Math.max(m.stopX,e),m.startX=Math.min(m.startX,e),m.nbPeaks++,m.peaks.push({x:t.x,intensity:t.y,width:t.width}),m.integralData.from=Math.min(m.integralData.from,t.x-3*t.width/a),m.integralData.to=Math.max(m.integralData.to,t.x+3*t.width/a),t.kind&&(m.kind=t.kind)}u=t}for(const e of c){l=e.peaks;const n=e.integralData;let s=0,i=0;for(const t of l){const e=computeArea(t,a);s+=t.x*e,i+=e}e.delta=s/i,n.value="sum"===o?xyIntegration(t,{from:n.from,to:n.to}):i}return i>0&&updateIntegration(c,i),c}function computeArea(t,e){return Math.abs(t.intensity*t.width/e*1.57)}function updateIntegration(t,e){let n=0,s=0;for(const e of t)s+=Math.abs(Math.round(e.integralData.value));if(s!==e){n=e/s;for(const e of t)e.integralData.value*=n}}function xyAutoRangesPicking(t,e){let n=xyAutoPeaksPicking(t,e.peakPicking);return n=peaksFilterImpurities(n,e.impurities),peaksToRanges(t,n,e.ranges)}function xyPeaksOptimization(t,e,n){const{frequency:s}=n,i=optimizePeaks(t,convertWidthToPPM(e,{frequency:s}),n);return convertWidthToHz(i,{frequency:s,output:i})}function formatZones(t){const e=[];for(const n of t){const t=[Number.MAX_VALUE,0],s=[Number.MAX_VALUE,0];for(const e of n.peaks||[])e.minX<t[0]&&(t[0]=e.minX),e.maxX>t[1]&&(t[1]=e.maxX),e.minY<s[0]&&(s[0]=e.minY),e.maxY>s[1]&&(s[1]=e.maxY);e.push({id:v4(),x:{from:t[0],to:t[1]},y:{from:s[0],to:s[1]},signals:[n]})}return e}function xyzAutoZonesPicking(t,e){return formatZones(xyzAutoSignalsPicking(t,e))}var src={},fftlib={};!function(t){(function(){var e,n="0.3.0",s="2013-03";(e=t).toString=function(){return"version "+n+", released "+s};for(var i=0,o=null,a=null,r={init:function(t){if(0===t||0!=(t&t-1))throw new Error("init: radix-2 required");i=t,r._initArray(),r._makeBitReversalTable(),r._makeCosSinTable()},fft1d:function(t,e){r.fft(t,e,1)},ifft1d:function(t,e){var n=1/i;r.fft(t,e,-1);for(var s=0;s<i;s++)t[s]*=n,e[s]*=n},bt1d:function(t,e){r.fft(t,e,-1)},fft2d:function(t,e){for(var n=[],s=[],o=0,a=0;a<i;a++){o=a*i;for(var l=0;l<i;l++)n[l]=t[l+o],s[l]=e[l+o];r.fft1d(n,s);for(var m=0;m<i;m++)t[m+o]=n[m],e[m+o]=s[m]}for(var c=0;c<i;c++){for(var u=0;u<i;u++)o=c+u*i,n[u]=t[o],s[u]=e[o];r.fft1d(n,s);for(var g=0;g<i;g++)t[o=c+g*i]=n[g],e[o]=s[g]}},ifft2d:function(t,e){for(var n=[],s=[],o=0,a=0;a<i;a++){o=a*i;for(var l=0;l<i;l++)n[l]=t[l+o],s[l]=e[l+o];r.ifft1d(n,s);for(var m=0;m<i;m++)t[m+o]=n[m],e[m+o]=s[m]}for(var c=0;c<i;c++){for(var u=0;u<i;u++)o=c+u*i,n[u]=t[o],s[u]=e[o];r.ifft1d(n,s);for(var g=0;g<i;g++)t[o=c+g*i]=n[g],e[o]=s[g]}},fft:function(t,e,n){for(var s,r,l,m,c,u,g,C,f,p=i>>2,h=0;h<i;h++)h<(m=o[h])&&(c=t[h],t[h]=t[m],t[m]=c,c=e[h],e[h]=e[m],e[m]=c);for(var d=1;d<i;d<<=1){r=0,s=i/(d<<1);for(var y=0;y<d;y++){u=a[r+p],g=n*a[r];for(var H=y;H<i;H+=d<<1)C=u*t[l=H+d]+g*e[l],f=u*e[l]-g*t[l],t[l]=t[H]-C,t[H]+=C,e[l]=e[H]-f,e[H]+=f;r+=s}}},_initArray:function(){o="undefined"!=typeof Uint32Array?new Uint32Array(i):[],a="undefined"!=typeof Float64Array?new Float64Array(1.25*i):[]},_paddingZero:function(){},_makeBitReversalTable:function(){var t=0,e=0,n=0;for(o[0]=0;++t<i;){for(n=i>>1;n<=e;)e-=n,n>>=1;e+=n,o[t]=e}},_makeCosSinTable:function(){var t=i>>1,e=i>>2,n=i>>3,s=t+e,o=Math.sin(Math.PI/i),r=2*o*o,l=Math.sqrt(r*(2-r)),m=a[e]=1,c=a[0]=0;o=2*r;for(var u=1;u<n;u++)r+=o*(m-=r),l-=o*(c+=l),a[u]=c,a[e-u]=m;0!==n&&(a[n]=Math.sqrt(.5));for(var g=0;g<e;g++)a[t-g]=a[g];for(var C=0;C<s;C++)a[C+t]=-a[C]}},l=["init","fft1d","ifft1d","fft2d","ifft2d"],m=0;m<l.length;m++)e[l[m]]=r[l[m]];return e.bt=r.bt1d,e.fft=r.fft1d,e.ifft=r.ifft1d,e}).call(commonjsGlobal)}(fftlib);var FFT=fftlib,FFTUtils$1={DEBUG:!1,ifft2DArray:function(t,e,n){var s=new Array(e*n),i=e/2,o=2*(n-1);FFT.init(i);for(var a={re:new Array(i),im:new Array(i)},r=0;r<n;r++){for(var l=i-1;l>=0;l--)a.re[l]=t[2*l*n+r],a.im[l]=t[(2*l+1)*n+r];FFT.bt(a.re,a.im);for(l=i-1;l>=0;l--)s[2*l*n+r]=a.re[l],s[(2*l+1)*n+r]=a.im[l]}var m=new Array(i*o);FFT.init(o);var c={re:new Array(o),im:new Array(o)},u=o*i;for(l=0;l<e;l+=2){c.re[0]=s[l*n],c.im[0]=s[(l+1)*n];for(r=1;r<n;r++)c.re[r]=s[l*n+r],c.im[r]=s[(l+1)*n+r],c.re[o-r]=s[l*n+r],c.im[o-r]=-s[(l+1)*n+r];FFT.bt(c.re,c.im);var g=l/2*o;for(r=o-1;r>=0;r--)m[g+r]=c.re[r]/u}return m},fft2DArray:function(t,e,n,s){Object.assign({},{inplace:!0});var i=n/2+1,o=2*e,a=new Array(o*i);FFT.init(n);for(var r,l,m,c,u,g={re:new Array(n),im:new Array(n)},C={re:new Array(n),im:new Array(n)},f={re:new Array(n),im:new Array(n)},p=0;p<e/2;p++){r=2*p*n,g.re=t.slice(r,r+n),r=(2*p+1)*n,g.im=t.slice(r,r+n),FFT.fft1d(g.re,g.im),this.reconstructTwoRealFFT(g,C,f),l=4*p*i,m=(4*p+1)*i,c=(4*p+2)*i,u=(4*p+3)*i;for(var h=i-1;h>=0;h--)a[l+h]=C.re[h],a[m+h]=C.im[h],a[c+h]=f.re[h],a[u+h]=f.im[h]}C=null,f=null;var d=new Array(o*i);FFT.init(e);for(var y={re:new Array(e),im:new Array(e)},H=i-1;H>=0;H--){for(p=e-1;p>=0;p--)y.re[p]=a[2*p*i+H],y.im[p]=a[(2*p+1)*i+H],isNaN(y.re[p])&&(y.re[p]=0),isNaN(y.im[p])&&(y.im[p]=0);FFT.fft1d(y.re,y.im);for(p=e-1;p>=0;p--)d[2*p*i+H]=y.re[p],d[(2*p+1)*i+H]=y.im[p]}return d},reconstructTwoRealFFT:function(t,e,n){var s,i,o,a,r,l=t.re.length;e.re[0]=t.re[0],e.im[0]=0,n.re[0]=t.im[0],n.im[0]=0;for(var m=l/2;m>0;m--)r=l-m,s=.5*(t.re[m]-t.re[r]),i=.5*(t.re[m]+t.re[r]),o=.5*(t.im[m]-t.im[r]),a=.5*(t.im[m]+t.im[r]),e.re[m]=i,e.im[m]=o,e.re[r]=i,e.im[r]=-o,n.re[m]=a,n.im[m]=-s,n.re[r]=a,n.im[r]=s},convolute2DI:function(t,e,n,s){for(var i,o,a=0;a<n/2;a++)for(var r=0;r<s;r++)i=t[2*a*s+r]*e[2*a*s+r]-t[(2*a+1)*s+r]*e[(2*a+1)*s+r],o=t[2*a*s+r]*e[(2*a+1)*s+r]+t[(2*a+1)*s+r]*e[2*a*s+r],t[2*a*s+r]=i,t[(2*a+1)*s+r]=o},convolute:function(t,e,n,s,i){for(var o=new Array(s*n),a=0;a<n*s;a++)o[a]=t[a];o=this.fft2DArray(o,n,s);var r,l=e.length,m=e[0].length,c=new Array(s*n);for(a=0;a<s*n;a++)c[a]=0;for(var u=Math.floor((l-1)/2),g=Math.floor((m-1)/2),C=0;C<l;C++){r=(C-u+n)%n;for(var f=0;f<m;f++)c[r*s+(f-g+s)%s]=e[C][f]}c=this.fft2DArray(c,n,s);var p=2*n,h=s/2+1;return this.convolute2DI(o,c,p,h),this.ifft2DArray(o,p,h)},toRadix2:function(t,e,n){var s,i,o,a,r=n,l=e;if(0===n||0!=(n&n-1)){for(r=0;n>>++r!=0;);r=1<<r}if(0===e||0!=(e&e-1)){for(l=0;e>>++l!=0;);l=1<<l}if(l==e&&r==n)return{data:t,rows:e,cols:n};var m=new Array(l*r),c=Math.floor((l-e)/2)-e,u=Math.floor((r-n)/2)-n;for(s=0;s<l;s++)for(o=s*r,a=(s-c)%e*n,i=0;i<r;i++)m[o+i]=t[a+(i-u)%n];return{data:m,rows:l,cols:r}},crop:function(t,e,n,s,i,o){if(e==s&&n==i)return t;Object.assign({},o);var a,r,l,m,c=new Array(i*s),u=Math.floor((e-s)/2),g=Math.floor((n-i)/2);for(l=0;l<s;l++)for(a=l*i,r=(l+u)*n,m=0;m<i;m++)c[a+m]=t[r+(m+g)];return c}},FFTUtils_1=FFTUtils$1,FFTUtils=src.FFTUtils=FFTUtils_1;function matrix2Array(t){let e,n,s=t;if("number"!=typeof t[0]){e=t.length,n=t[0].length,s=new Array(e*n);for(let i=0;i<e;i++)for(let e=0;e<n;e++)s[i*n+e]=t[i][e]}else{let s=Math.sqrt(t.length);Number.isInteger(s)&&(e=s,n=s)}return{data:s,rows:e,cols:n}}function convolutionFFT(t,e,n){let s,i,o=matrix2Array(t),a=o.data,r=Object.assign({normalize:!1,divisor:1,rows:o.rows,cols:o.cols},n);if(!r.rows||!r.cols)throw new Error(`Invalid number of rows or columns ${s} ${i}`);s=r.rows,i=r.cols;let l=r.divisor,m=e.length,c=e[0].length;if(r.normalize){l=0;for(let t=0;t<m;t++)for(let n=0;n<c;n++)l+=e[t][n]}if(0===l)throw new RangeError("convolution: The divisor is equal to zero");let u=FFTUtils.toRadix2(a,s,i),g=FFTUtils.convolute(u.data,e,u.rows,u.cols);if(g=FFTUtils.crop(g,u.rows,u.cols,s,i),0!==l&&1!==l)for(let t=0;t<g.length;t++)g[t]/=l;return g}function convolutionDirect(t,e,n){let s,i,o=matrix2Array(t),a=o.data,r=Object.assign({normalize:!1,divisor:1,rows:o.rows,cols:o.cols},n);if(!r.rows||!r.cols)throw new Error(`Invalid number of rows or columns ${s} ${i}`);s=r.rows,i=r.cols;let l,m,c,u,g,C=r.divisor,f=e.length,p=e[0].length;if(r.normalize){C=0;for(let t=0;t<f;t++)for(let n=0;n<p;n++)C+=e[t][n]}if(0===C)throw new RangeError("convolution: The divisor is equal to zero");let h=new Array(s*i),d=Math.floor(f/2),y=Math.floor(p/2);for(let t=0;t<s;t++)for(let n=0;n<i;n++){m=0;for(let o=0;o<f;o++)for(let r=0;r<p;r++)c=e[f-o-1][p-r-1],u=(t+o-d+s)%s,g=(n+r-y+i)%i,l=u*i+g,m+=a[l]*c;l=t*i+n,h[l]=m/C}return h}src.FFT=fftlib;class DisjointSet{constructor(){this.nodes=new Map}add(t){var e=this.nodes.get(t);return e||(e=new DisjointSetNode(t),this.nodes.set(t,e)),e}union(t,e){const n=this.find(t),s=this.find(e);n!==s&&(n.rank<s.rank?n.parent=s:n.rank>s.rank?s.parent=n:(s.parent=n,n.rank++))}find(t){for(var e=t;null!==e.parent;)e=e.parent;for(var n=t;null!==n.parent;){var s=n;n=n.parent,s.parent=e}return e}connected(t,e){return this.find(t)===this.find(e)}}var DisjointSet_1=DisjointSet;function DisjointSetNode(t){this.value=t,this.parent=null,this.rank=0}var DisjointSet$1=DisjointSet_1;const direction8X$2=[-1,-1,0,1,-1,0,1,1],direction8Y$2=[0,-1,-1,-1,1,1,1,0],neighbours8$1=[null,null,null,null,null,null,null,null],direction4X$1=[-1,0,1,0],direction4Y$1=[0,-1,0,1],neighbours4$1=[null,null,null,null];function drainLabelling(t,e,n={}){const{neighbours:s=8,width:i,height:o}=n;let a,r,l;if(8===s)a=direction8X$2,r=direction8Y$2,l=neighbours8$1;else{if(4!==s)throw new RangeError(`unsupported neighbours count: ${s}`);a=direction4X$1,r=direction4Y$1,l=neighbours4$1}let m=new Array(o*i);for(let n=0,s=0;n<o;n++)for(let o=0;o<i;o++,s++)m[s]={value:t[s],row:n,col:o,mask:e[s]};m.sort(((t,e)=>t.value-e.value));const c=e.length,u=new Array(c),g=new Int16Array(c),C=new DisjointSet$1;for(let n=0,s=1;n<e.length;n++){let e=m[n];if(!e.mask)continue;let{row:c,col:g,value:f}=e,p=g+c*i;u[p]||(u[p]=C.add(s++));for(let e=0;e<l.length;e++){let n=g+a[e],s=c+r[e];if(n>=0&&s>=0&&n<i&&s<o){if(!u[n+s*i]){f<t[n+s*i]&&(u[n+s*i]=u[p])}}}}for(let t=0;t<o;t++)for(let n=0;n<i;n++){let s=n+t*i;e[s]&&(g[s]=C.find(u[s]).value)}return g}const direction4X=[-1,0],direction4Y=[0,-1],neighbours4=[null,null],direction8X$1=[-1,-1,0,1],direction8Y$1=[0,-1,-1,-1],neighbours8=[null,null,null,null];function floodFillLabelling(t,e,n,s){const i=(s=s||{}).neighbours||8;let o,a,r;if(8===i)o=direction8X$1,a=direction8Y$1,r=neighbours8;else{if(4!==i)throw new RangeError(`unsupported neighbours count: ${i}`);o=direction4X,a=direction4Y,r=neighbours4}const l=t.length,m=new Array(l),c=new Int16Array(l),u=new DisjointSet$1;let g,C=1;for(let s=0;s<n;s++)for(let i=0;i<e;i++){let l=null;if(g=i+s*e,t[g]){for(let t=0;t<r.length;t++){let c=i+o[t],u=s+a[t];if(c>=0&&u>=0&&c<e&&u<n){let n=m[c+u*e];n?(r[t]=n,(!l||r[t].value<l.value)&&(l=r[t])):r[t]=null}}if(l){m[g]=l;for(let t=0;t<r.length;t++)r[t]&&r[t]!==l&&u.union(l,r[t])}else m[g]=u.add(C++)}}for(let s=0;s<n;s++)for(let n=0;n<e;n++)g=n+s*e,t[g]&&(c[g]=u.find(m[g]).value);return c}const smallFilter$1=[[0,0,1,2,2,2,1,0,0],[0,1,4,7,7,7,4,1,0],[1,4,5,3,0,3,5,4,1],[2,7,3,-12,-23,-12,3,7,2],[2,7,0,-23,-40,-23,0,7,2],[2,7,3,-12,-23,-12,3,7,2],[1,4,5,3,0,3,5,4,1],[0,1,3,7,7,7,3,1,0],[0,0,1,2,2,2,1,0,0]];function findPeaks2DRegion(t,e={}){let{nStdDev:n=3,kernel:s=smallFilter$1,originalData:i=matrix2Array(t).data,filteredData:o,rows:a,cols:r,labelling:l="drain"}=e,m=matrix2Array(t),c=m.data;if(a&&r||(a=m.rows,r=m.cols),!a||!r)throw new Error(`Invalid number of rows or columns ${a} ${r}`);let u=o;u||(u=convolutionFFT(c,s,e));let g=0;for(let t=r*a-2;t>=0;t--)g+=Math.pow(u[t]-u[t+1],2);g=-Math.sqrt(g)*n/a;let C,f=new Uint16Array(r*a);for(let t=u.length-1;t>=0;t--)u[t]<g&&(f[t]=1);switch(l.toLowerCase()){case"drain":C=drainLabelling(u,f,{neighbours:8,width:r,height:a});break;case"floodfill":C=floodFillLabelling(f,r,a,{neighbours:8});break;default:throw new Error(`labelling ${l} does not support`)}return extractPeaks(C,{data:c,nCols:r,originalData:i})}function extractPeaks(t,e){const{data:n,nCols:s,originalData:i}=e;let o,a,r,l={};for(let e=0;e<t.length;e++)0!==t[e]&&(a=e%s,o=(e-a)/s,l[t[e]]?(r=l[t[e]],r.x+=a*n[e],r.y+=o*n[e],r.z+=i[e],a<r.minX&&(r.minX=a),a>r.maxX&&(r.maxX=a),o<r.minY&&(r.minY=o),o>r.maxY&&(r.maxY=o)):l[t[e]]={x:a*n[e],y:o*n[e],z:i[e],minX:a,maxX:a,minY:o,maxY:o});let m=Object.keys(l),c=new Array(m.length);for(let t=0;t<m.length;t++){c[t]=l[m[t]];let e=Math.abs(c[t].z);c[t].x/=e,c[t].y/=e}return c}const{parse:parse$2,stringify:stringify$2}=JSON;function addMissingIDs(t,e={}){const{output:n=parse$2(stringify$2(t))}=e;for(const t of n)"id"in t||(t.id=v4());return n}const direction8X=[-1,-1,-1,0,0,1,1,1],direction8Y=[-1,0,1,-1,1,-1,0,1],direction16X=[-2,-2,-2,-2,-2,-1,-1,0,0,1,1,2,2,2,2,2],direction16Y=[-2,-1,0,1,2,-2,2,-2,2,-2,2,-2,-1,0,1,2];function determineRealTop(t,e){const{nCols:n,absoluteData:s,originalData:i,minX:o,maxX:a,minY:r,maxY:l}=e;for(let e=0;e<t.length;e++){const m=Math.round(t[e].x),c=Math.round(t[e].y);let u=m+c*n;const{index:g,isMax:C}=determineMax(s,{xIndex:m,yIndex:c,nCols:n,shell:1});u=C?g:determineMax(s,{xIndex:m,yIndex:c,nCols:n,shell:2}).index;const f=fitGaussian(i,{nCols:n,index:u,minY:r,maxY:l,minX:o,maxX:a});t[e]=Object.assign(t[e],f)}return t}function determineMax(t,e){const{xIndex:n,yIndex:s,shell:i,nCols:o}=e;let a=n+s*o;const[r,l]=i>1?[direction16X,direction16Y]:[direction8X,direction8Y];let m=!1;for(let e=0;e<r.length;e++){const i=n+r[e],c=s+l[e];if(t[i+c*o]>=t[a]){m=!0;const e=i+c*o;for(let n=0;n<direction8Y.length;n++){if(t[i+direction8X[n]+(c+direction8Y[n])*o]>t[e]){m=!1;break}}m&&(a=e)}}return{index:a,isMax:m}}function fitGaussian(t,e){const{nCols:n,index:s,minY:i,maxY:o,minX:a,maxX:r}=e,l=(r-a)/(n-1),m=(o-i)/(t.length/n-1),c=s%n,u=(s-c)/n;let g=Number.MIN_SAFE_INTEGER;const C=new Array(direction8X.length+1),f=new Array(direction8X.length+1);for(let e=-1,s=0;e<2;e++)for(let i=-1;i<2;i++,f[s]=s++){const s=t[c+i+(u+e)*n];g<s&&(g=s),C[1+i+3*(1+e)]=s}for(let t=0;t<C.length;t++)C[t]/=g;const p=[2,2,1.5,1,1],h=[0,0,-1.5,.001,.001],d=[1,1,C[4],.2,.2],y=levenbergMarquardt({x:f,y:C},paramGaussian2D(l,m,3),{damping:1.5,maxIterations:100,errorTolerance:1e-8,initialValues:d,gradientDifference:[1e-4,1e-4,.001,.001,.001],maxValues:p,minValues:h}).parameterValues;return{x:y[0]+c-1,y:y[1]+u-1,z:y[2]*g}}function paramGaussian2D(t,e,n){const s=new Gaussian2D;return i=>o=>{const a=i.length/5;let r=0;const l=o%n,m=(o-l)/n;for(let n=0;n<a;n++)s.fwhm={x:i[n+3*a],y:i[n+4*a]},r+=i[n+2*a]*s.fct((l-i[n])*t,(m-i[n+a])*e);return r}}function getKernel(t={}){const{sigma:e=1.4,xLength:n=9,yLength:s=9}=t,i=-40/laplacianOfGaussian(0,0,e),o=(n-1)/2,a=(s-1)/2,r=new Array(n);for(let t=0;t<n;t++){r[t]=new Array(s);for(let n=0;n<s;n++)r[t][n]=laplacianOfGaussian(t-o,n-a,e)*i}return r}const laplacianOfGaussian=(t,e,n)=>{const s=-(Math.pow(t,2)+Math.pow(e,2))/2/Math.pow(n,2);return-1/Math.PI/Math.pow(n,4)*(1+s)*Math.exp(s)},diagonalError=.05,tolerance=.05;function clean(t,e){let n=Number.NEGATIVE_INFINITY;for(let e=t.length-1;e>=0;e--)Math.abs(t[e].z)>n&&(n=Math.abs(t[e].z));n*=e;for(let e=t.length-1;e>=0;e--)Math.abs(t[e].z)<n&&t.splice(e,1);return t}function enhanceSymmetry(t){const e=initializeProperties(t),n=t.slice();let s;for(let t=n.length-1;t>=0;t--){const s=n[t];if(s.peaks&&s.peaks.length>1&&e[t][1]++,1===e[t][0]){const i=exist(n,e,s,-1,!0);i>=0&&(e[t][1]+=2,e[i][1]+=2)}}for(let t=n.length-1;t>=0;t--){const i=n[t];0===e[t][0]&&(s=checkCrossPeaks(n,e,i,!0),e[t][1]+=s)}let i=0;for(let t=n.length-1;t>=0;t--)0!==e[t][0]&&e[t][1]>2&&(i++,i+=completeMissingIfNeeded(n,e,n[t],e[t])),e[t][1]>=2&&0===e[t][0]&&i++;const o=new Array(i);i--;for(let t=n.length-1;t>=0;t--)(0!==e[t][0]&&e[t][1]>2||0===e[t][0]&&e[t][1]>1)&&(o[i--]=n[t]);return o}function completeMissingIfNeeded(t,e,n,s){let i,o,a=0,r=null;exist(t,e,n,-s[0],!0)<0&&(i={x:{nucleus:n.x.nucleus,resolution:n.x.resolution,delta:n.y.delta},y:{nucleus:n.y.nucleus,resolution:n.y.resolution,delta:n.x.delta},peaks:[{x:n.y.delta,y:n.x.delta,z:1}]},t.push(i),r=[-s[0],s[1]],e.push(r),a++);let l=!1,m=!1;for(let s=t.length-1;s>=0;s--)o=t[s],0===e[s][0]&&(Math.abs(o.x.delta-n.x.delta)<diagonalError&&(l=!0),Math.abs(o.y.delta-n.y.delta)<diagonalError&&(m=!0));return l||(i={x:{delta:n.y.delta,nucleus:n.x.nucleus,resolution:n.x.resolution},y:{delta:n.x.delta,nucleus:n.y.nucleus,resolution:n.y.resolution},peaks:[{x:n.x.delta,y:n.x.delta,z:1}]},i.peaks=[{x:n.x.delta,y:n.x.delta,z:1}],t.push(i),r=[0,s[1]],e.push(r),a++),m||(i={x:{delta:n.y.delta,nucleus:n.x.nucleus,resolution:n.x.resolution},y:{delta:n.y.delta,nucleus:n.y.nucleus,resolution:n.y.resolution},peaks:[{x:n.y.delta,y:n.y.delta,z:1}]},t.push(i),r=[0,s[1]],e.push(r),a++),a}function checkCrossPeaks(t,e,n,s){let i=0,o=4*n.x.delta;const a=[],r=[];let l;for(let m=t.length-1;m>=0;m--)l=t[m],0!==e[m][0]&&(Math.abs(l.x.delta-n.x.delta)<diagonalError?(i++,s&&e[m][1]++,a.push(m),o+=l.x.delta):Math.abs(l.y.delta-n.y.delta)<diagonalError&&(i++,s&&e[m][1]++,r.push(m),o+=l.y.delta));if(o/=a.length+r.length+4,a.length>0)for(let e=a.length-1;e>=0;e--)t[a[e]].x.delta=o;if(r.length>0)for(let e=r.length-1;e>=0;e--)t[r[e]].y.delta=o;return n.x.delta=o,n.y.delta=o,i}function exist(t,e,n,s,i){for(let o=t.length-1;o>=0;o--)if(e[o][0]===s&&distanceTo(n,t[o],i)<tolerance){if(i){const e=n.x.delta,s=t[o].x.delta;t[o].y.delta=e,n.y.delta=s}else{const e=(t[o].x.delta+n.x.delta)/2,s=(t[o].y.delta+n.y.delta)/2;t[o].x.delta=e,t[o].y.delta=s,n.x.delta=e,n.y.delta=s}return o}return-1}function initializeProperties(t){const e=new Array(t.length);for(let n=t.length-1;n>=0;n--)if(e[n]=[0,0],Math.abs(t[n].x.delta-t[n].y.delta)<=diagonalError){e[n][1]=1;const s=(2*t[n].x.delta+t[n].y.delta)/3;t[n].x.delta=s,t[n].y.delta=s}else t[n].x.delta-t[n].y.delta>0?e[n][0]=1:e[n][0]=-1;return e}function distanceTo(t,e,n){return n?Math.sqrt(Math.pow(t.x.delta-e.y.delta,2)+Math.pow(t.y.delta-e.x.delta,2)):Math.sqrt(Math.pow(t.x.delta-e.x.delta,2)+Math.pow(t.y.delta-e.y.delta,2))}function padData(t,e){const{minX:n,maxX:s,minY:i,maxY:o}=t,a=e.width,r=t.z[0].length,l=t.z.length,m=(o-i)/(l-1),c=(s-n)/(r-1);let u=a-l,g=Math.max(a-r,0);g%2&&g++,u%2&&u++;const C=g/2,f=u/2,p=[];for(let t=0;t<l+u;t++)p.push(new Float64Array(r+g));for(let e=0;e<l;e++)for(let n=0;n<r;n++)p[e+f].set(t.z[e],C);return{...t,z:p,minX:n-C*c,maxX:s+C*c,minY:i-f*m,maxY:o+f*m}}const smallFilter=[[0,0,1,2,2,2,1,0,0],[0,1,4,7,7,7,4,1,0],[1,4,5,3,0,3,5,4,1],[2,7,3,-12,-23,-12,3,7,2],[2,7,0,-23,-40,-23,0,7,2],[2,7,3,-12,-23,-12,3,7,2],[1,4,5,3,0,3,5,4,1],[0,1,3,7,7,7,3,1,0],[0,0,1,2,2,2,1,0,0]];function xyzAutoSignalsPicking(t,e){const{sizeToPad:n=14,realTopDetection:s=!0,nuclei:i=["1H","1H"],observedFrequencies:o,enhanceSymmetry:a=!1,clean:r=!0,maxPercentCutOff:l=.03,tolerances:m=[24,24],convolutionByFFT:c=!0,kernel:u}=e;let{thresholdFactor:g=.5}=e;if(!Array.isArray(o)&&!ArrayBuffer.isView(o))throw new Error("observedFrequencies is mandatory");g=0===g?1:Math.abs(g);let C=t.z[0].length,f=t.z.length;f<n&&(C=(t=padData(t,{width:n})).z[0].length,f=t.z.length);const p=new Float64Array(C*f),h=new Float64Array(C*f);for(let e=0;e<f;e++){const n=t.z[e];for(let t=0;t<C;t++){const s=e*C+t;p[s]=Math.abs(n[t]),h[s]=n[t]}}const d=u?getKernel(u):smallFilter;let y=findPeaks2DRegion(p,{originalData:h,filteredData:c?convolutionFFT(p,d,{rows:f,cols:C}):convolutionDirect(p,d,{rows:f,cols:C}),rows:f,cols:C,nStdDev:g});r&&(y=clean(y,l));let H=createSignals2D$1(addMissingIDs(y),{nRows:f,nCols:C,minX:t.minX,maxX:t.maxX,minY:t.minY,maxY:t.maxY,absoluteData:p,originalData:h,tolerances:m,nuclei:i,observedFrequencies:o,realTopDetection:s});return a&&(H=enhanceSymmetry(H)),H}function createSignals2D$1(t,e){const{nCols:n,nRows:s,absoluteData:i,originalData:o,observedFrequencies:a,tolerances:r,nuclei:l,realTopDetection:m,minY:c,maxY:u,minX:g,maxX:C}=e,[f,p]=l,[h,d]=r,[y,H]=a,b=(u-c)/(s-1),v=(C-g)/(n-1);m&&(t=determineRealTop(t,{nCols:n,absoluteData:i,originalData:o,minX:g,maxX:C,minY:c,maxY:u}));for(let e=t.length-1;e>=0;e--){const{x:n,y:s}=t[e];t[e].x=g+v*n,t[e].y=c+b*s,t[e].minX=g+v*t[e].minX,t[e].minY=c+b*t[e].minY,t[e].maxX=g+v*t[e].maxX,t[e].maxY=c+b*t[e].maxY}const w=[];for(let e=0;e<t.length;e++)for(let n=e;n<t.length;n++)Math.abs(t[e].x-t[n].x)*y<h&&Math.abs(t[e].y-t[n].y)*H<d?w.push(1):w.push(0);const x=simpleClustering(w),O=[];if(x)for(const e of x){const n={id:v4(),x:{delta:0,nucleus:f,resolution:v},y:{delta:0,nucleus:p,resolution:b}},s=[];let i=0;for(let o=0;o<e.length;o++)1===e[o]&&(s.push(t[o]),n.x.delta+=t[o].x*t[o].z,n.y.delta+=t[o].y*t[o].z,i+=t[o].z);n.x.delta/=i,n.y.delta/=i,n.peaks=s,O.push(n)}return O}const{parse:parse$1,stringify:stringify$1}=JSON;function xyzJResAnalyzer(t,e={}){const{reference:n=0,getZones:s=!1,referenceMaxShiftError:i=.08,tolerances:o=[10,100],nuclei:a=["1H","1H"],observedFrequencies:r=[400,400],jAnalyzer:l={jAxisKey:{jAxis:"y",intensity:"z"}}}=e,m=compilePattern(t,{observedFrequencies:r,tolerances:o,nuclei:a,jAnalyzer:l});let c=[];for(const t of m){const e=t.y.delta;Math.abs(e-n)>i||c.push(t)}return c=addMissingIDs(c),s?formatZones(c):c}function compilePattern(t,e){const{observedFrequencies:n,tolerances:s,nuclei:i,jAnalyzer:o}=e,a={observedFrequencies:n,tolerances:s,nuclei:i,dx:t[0].x.resolution,dy:t[0].y.resolution},r=.02*n[0],l=[];for(const e of t){const t=[];for(const n of e.peaks||[])t.push({...n,width:r});t.sort(((t,e)=>t.y-e.y)),l.push({nbPeaks:t.length,multiplicity:"",pattern:"",startX:t[0].y-r,stopX:t[t.length-1].y+r,delta:e.y.delta,observe:n[1],integralData:{value:-1,from:Number.MAX_SAFE_INTEGER,to:Number.MIN_SAFE_INTEGER},peaks:t})}for(let e=0;e<t.length;e++){const t=jAnalyzer.compilePattern(l[e],o);if(t.maskPattern&&"m"!==t.multiplicity&&""!==t.multiplicity){const e=[];for(let n=t.maskPattern.length-1;n>=0;n--)if(!t.maskPattern[n]){const s=t.peaks.splice(n,1)[0];e.push(s),t.mask.splice(n,1),t.mask2?.splice(n,1),t.maskPattern.splice(n,1),t.nbPeaks--}if(e.length>0){e.reverse();const t=createSignals2D(e,a);for(const e of t)l.push(e)}}}return t.sort(((t,e)=>e.x.delta-t.x.delta)),t}function createSignals2D(t,e){const{observedFrequencies:n,tolerances:s,nuclei:i,dx:o,dy:a}=e,r=parse$1(stringify$1(t)),[l,m]=i,[c,u]=s,[g,C]=n,f=[];for(let t=0;t<r.length;t++)for(let e=t;e<r.length;e++)Math.abs(r[t].x-r[e].x)*g<c&&Math.abs(r[t].y-r[e].y)*C<u?f.push(1):f.push(0);const p=simpleClustering(f),h=[];if(p)for(const t of p){const e={id:v4(),nucleusX:l,nucleusY:m,integralData:{from:Number.MAX_SAFE_INTEGER,to:Number.MIN_SAFE_INTEGER},nbPeaks:0,multiplicity:"",pattern:"",observe:C,resolutionX:o,resolutionY:a,shiftX:0,shiftY:0},n=[],s=[Number.MAX_VALUE,0],i=[Number.MAX_VALUE,0];let c=0;for(let o=t.length-1;o>=0;o--)1===t[o]&&(e.nbPeaks++,r[o].width||(r[o].width=.02),n.push(r[o]),e.shiftX+=r[o].x*r[o].z,e.shiftY+=r[o].y*r[o].z,c+=r[o].z,r[o].minX<s[0]&&(s[0]=r[o].minX),r[o].maxX>s[1]&&(s[1]=r[o].maxX),r[o].minY<i[0]&&(i[0]=r[o].minY),r[o].maxY>i[1]&&(i[1]=r[o].maxY));e.fromTo=[{from:s[0],to:s[1]},{from:i[0],to:i[1]}],e.shiftX/=c,e.shiftY/=c,e.delta1=e.shiftY,e.peaks=n,h.push(e)}return h}function checkData2DFid(t){if(!("re"in t)||!("im"in t))throw new Error("imaginary (im) data should exists")}function quadrature(t,e){checkData2DFid(t);const{fnMode:n}=e;switch(n.toLowerCase()){case"ttpi":return ttpiQuadrature(t);case"states":return shrQuadrature(t);default:return{re:t.re.z,im:t.im.z}}}function shrQuadrature(t){const{re:e,im:n}=t;return{re:e.z,im:n.z}}function ttpiQuadrature(t){const e=[],n=[],{re:{z:s},im:{z:i}}=t;for(let t=0;t<s.length;t++)e.push(t%2?s[t].slice():xMultiply(s[t],-1)),n.push(t%2?i[t].slice():xMultiply(i[t],-1));return{re:e,im:n}}function digitalFilter$1(t,e){const{digitalFilterValue:n=0}=e,s=new Float64Array(t.re),i=new Float64Array(t.im);let o=Math.floor(n);o+=0;const a=new Float64Array(s.length),r=new Float64Array(i.length);return a.set(s.slice(o)),a.set(s.slice(0,o),s.length-o),r.set(i.slice(o)),r.set(i.slice(0,o),i.length-o),{re:a,im:r}}function removeDCOffset$1(t,e){const{digitalFilterValue:n=0}=e,s=t.re.length,i=new Float64Array(t.re),o=new Float64Array(t.im),a=xMean(t.re.slice(.75*s>>0,s-n)),r=xMean(t.im.slice(.75*s>>0,s-n));for(let t=n;t<s-n;t++)i[t]-=a,o[t]-=r;return{re:i,im:o}}function zeroFilling$1(t,e){const{factor:n=2,digitalFilterValue:s=0}=e,i=e.nbPoints||2**Math.round(Math.log2(t.re.length*n));let o;o=s>0?Math.floor(s):0;const{re:a,im:r}=t,l=new Float64Array(i),m=new Float64Array(i),c=Math.min(i,a.length);return l.set(a.slice(0,c-o)),m.set(r.slice(0,c-o)),o>0&&o<i&&(l.set(a.slice(a.length-o),i-o),m.set(r.slice(a.length-o),i-o)),{re:l,im:m}}function fftDirectDimension(t,e={}){const{re:n,im:s}=t,i=n.length,o=n[0].length,{zeroFilling:a,digitalFilterValue:r=0}=e,{factor:l=2}=a||{},m=a?.nbPoints||2**Math.round(Math.log2(o*l)),c=new Matrix(i,m),u=new Matrix(i,m),{apodization:g,phaseCorrection:C={}}=e,{ph0:f,ph1:p,mode:h="no"}=C;for(let t=0;t<i;t++){const e=digitalFilter$1({re:n[t],im:s[t]},{digitalFilterValue:r});if(Object.assign(e,removeDCOffset$1(e,{digitalFilterValue:r})),g){const{re:t,im:n}=apodization$1(e,g);Object.assign(e,{re:t,im:n})}Object.assign(e,zeroFilling$1(e,{digitalFilterValue:r,nbPoints:m})),Object.assign(e,reimFFT(e,{applyZeroShift:!0}));const i=(r-Math.round(r))*Math.PI*2;i>0&&Object.assign(e,reimPhaseCorrection(e,0,-i)),"pk"===h&&void 0!==f&&void 0!==p&&Object.assign(e,reimPhaseCorrection(e,f*Math.PI/180,p*Math.PI/180)),c.setRow(t,e.re),u.setRow(t,e.im)}return{re:c,im:u}}function fftIndirectDimension(t,e){const n={re:Matrix.checkMatrix(t.re),im:Matrix.checkMatrix(t.im)},s=n.re.rows,i=n.re.columns,{zeroFilling:o,reverse:a}=e,{factor:r=2}=o||{},l=o?.nbPoints||2**Math.round(Math.log2(s*r)),{fnMode:m}=e,c={...e,zeroFilling:{...o,nbPoints:l}},u={};if("QF"===m){const t=new Matrix(l,i),e=new Matrix(l,i);for(let s=0;s<i;s++){const i={re:n.re.getColumn(s),im:a?n.im.getColumn(s):xMultiply(n.im.getColumn(s),-1)},{re:o,im:r}=applyFFT(i,c);t.setColumn(s,o),e.setColumn(s,r)}u.rr=t,u.ir=e}else for(const t in n){const e=new Matrix(l,i),s=new Matrix(l,i);for(let o=0;o<i;o++){const i=getColumnFrom(n[t],{fnMode:m,index:o}),{re:a,im:r}=applyFFT(i,c);e.setColumn(o,a),s.setColumn(o,r)}"re"===t?(u.rr=e,u.ir=s):(u.ri=e,u.ii=s)}return u}function applyFFT(t,e){const{fnMode:n,apodization:s,zeroFilling:i={},phaseCorrection:o={}}=e,{re:a,im:r}=apodization$1(t,s),{nbPoints:l=0}=i,m=reimFFT(zeroFilling$1({re:a,im:r},{nbPoints:l}),{applyZeroShift:!["SEQ","TPPI"].some((t=>n===t))});"mc"===e.phaseCorrection?.mode&&Object.assign(m,{re:reimAbsolute(m),im:new Float64Array(l)});const{mode:c,ph0:u,ph1:g}=o;return"pk"===c&&void 0!==u&&void 0!==g&&Object.assign(m,reimPhaseCorrection(m,u*Math.PI/180,g*Math.PI/180)),m}function getColumnFrom(t,e){const{fnMode:n,index:s}=e,i=e.reverse||"QF"===n,o=t.rows/2,a=new Float64Array(o),r=new Float64Array(o);switch(n?.toLocaleLowerCase()){case"seq":case"tppi":return{re:t.getColumn(s),im:new Float64Array(t.rows)};default:if(i)for(let e=0;e<o;e++)a[e]=t.get(2*e,s),r[e]=-t.get(2*e+1,s);else for(let e=0;e<o;e++)a[e]=t.get(2*e,s),r[e]=t.get(2*e+1,s)}if("states-ttpi"===n)for(let t=0;t<o;t+=2)a[t]*=-1,r[t]*=-1;return{re:a,im:r}}function getMinMaxXY(t){const e=[],n=[];for(let s=0;s<t.baseFrequency.length;s++){const i=t.baseFrequency[s],o=t.frequencyOffset[s],a=t.spectralWidth[s],r=o/i;e.push(r-.5*a),n.push(r+.5*a)}return{minX:e[0],maxX:n[0],minY:e[1],maxY:n[1]}}function xyzBidimensionalFFT(t,e){ensureData2DFid(t);const{info:n,fnMode:s,digitalFilterValue:i=0,zeroFilling:o}=e,a=quadrature(t,{fnMode:s}),{re:r}=a,l=r.length,m=r[0].length,{direct:c={},indirect:u={}}=e,{zeroFilling:g=o}=c,{factor:C=2}=g||{},f=g?.nbPoints||2**Math.round(Math.log2(m*C)),p=fftDirectDimension(a,{...c,fnMode:s,digitalFilterValue:i,zeroFilling:{nbPoints:f}}),{zeroFilling:h}=e,{factor:d=2}=h||{},y=h?.nbPoints||2**Math.round(Math.log2(l*d)),{re:H,im:b}=fftIndirectDimension(p,{...u,fnMode:s,zeroFilling:{nbPoints:y}}),v=getMinMaxXY(n);return{re:{z:convertToDoubleArray(H),maxZ:H.max(),minZ:H.min(),...v},im:{z:convertToDoubleArray(b),maxZ:b.max(),minZ:b.min(),...v}}}function ensureData2DFid(t){if(!("re"in t))throw new Error("bidimensional FFT only can be applied to raw data")}function convertToDoubleArray(t){const e=new Array(t.rows);for(let n=0;n<t.rows;n++)e[n]=new Float64Array(t.getRow(n));return e}async function getDatabase(t="https://docs.google.com/spreadsheets/d/1uwyq_L38PMRWCcT4If_EhPbHKyY3q_2tpjV8vr5_zh0/edit?usp=sharing",e={}){const{format:n="tsv"}=e;let s;t.includes("google.com")&&(t=`https://googledocs.cheminfo.org/spreadsheets/d/${extractGoogleUUID(t)}/export?format=tsv`);const i=await fetch(t);switch(n){case"tsv":s=parseData(await i.text());break;case"json":s=await i.json();break;default:throw new Error("unknown database format")}const o=[];for(const t of s.data){const e={smiles:"",solvent:"",nucleus:"",jcampURL:"",names:[],meta:{},ranges:[]};for(let n=0;n<t.length;n++)switch(s.kinds[n]){case"smiles":e.smiles=t[n];break;case"solvent":e.solvent=t[n];break;case"nucleus":e.nucleus=t[n];break;case"jcampURL":e.jcampURL=t[n];break;case"name":e.names&&e.names.push(t[n]);break;case"meta":e.meta&&(e.meta[s.labels[n]]=t[n]);break;case"signal":{const s=resurrectRange(t[n]);s&&e.ranges.push(s);break}default:throw new Error(`Unknown column kind: ${s.kinds[n]}`)}o.push(e)}return o}function extractGoogleUUID(t){return t.replace(/.*\/(?<uuid>[^/]{20,50}).*/,"$<uuid>")}function parseData(t){const e=t.split(/\r?\n/).filter((t=>!/^\s*$/.exec(t))).map((t=>t.split("\t").map((t=>t.trim()))));return{labels:e[0],kinds:e[1],data:e.slice(2)}}const carbonImpurities=[{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:171.69,assignment:"CO"}],from:171.685,to:171.695},{signals:[{delta:20.13,assignment:"CH₃"}],from:20.125,to:20.134999999999998}],nucleus:"13C",solvent:"THF-d₈"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:204.19,assignment:"CO"}],from:204.185,to:204.195},{signals:[{delta:30.17,assignment:"CH₃"}],from:30.165000000000003,to:30.175}],nucleus:"13C",solvent:"THF-d₈"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:116.79,assignment:"CN"}],from:116.78500000000001,to:116.795},{signals:[{delta:.45,assignment:"CH₃"}],from:.445,to:.455}],nucleus:"13C",solvent:"THF-d₈"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:128.84,assignment:"CH"}],from:128.835,to:128.845}],nucleus:"13C",solvent:"THF-d₈"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:67.5,assignment:"(CH₃)₃C"}],from:67.495,to:67.505},{signals:[{delta:30.57,assignment:"(CH₃)₃C"}],from:30.565,to:30.575}],nucleus:"13C",solvent:"THF-d₈"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:125.69,assignment:"CO₂"}],from:125.685,to:125.695}],nucleus:"13C",solvent:"THF-d₈"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:193.37,assignment:"CS₂"}],from:193.365,to:193.375}],nucleus:"13C",solvent:"THF-d₈"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:96.89,assignment:"CCl₄"}],from:96.885,to:96.895}],nucleus:"13C",solvent:"THF-d₈"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:79.24,assignment:"CH"}],from:79.235,to:79.24499999999999}],nucleus:"13C",solvent:"THF-d₈"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:71.34,assignment:"CH₂"}],from:71.33500000000001,to:71.345}],nucleus:"13C",solvent:"THF-d₈"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:27.58,assignment:"CH₂"}],from:27.575,to:27.584999999999997}],nucleus:"13C",solvent:"THF-d₈"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:44.64,assignment:"CH₂"}],from:44.635,to:44.645}],nucleus:"13C",solvent:"THF-d₈"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:54.67,assignment:"CH₂"}],from:54.665,to:54.675000000000004}],nucleus:"13C",solvent:"THF-d₈"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.49,assignment:"CH₃"}],from:15.485,to:15.495000000000001},{signals:[{delta:66.14,assignment:"CH₂"}],from:66.135,to:66.145}],nucleus:"13C",solvent:"THF-d₈"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:58.72,assignment:"CH₃"}],from:58.714999999999996,to:58.725},{signals:[{delta:71.17,assignment:"CH₂"}],from:71.165,to:71.175},{signals:[{delta:72.72,assignment:"CH₂"}],from:72.715,to:72.725}],nucleus:"13C",solvent:"THF-d₈"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:161.96,assignment:"CH"}],from:161.955,to:161.965},{signals:[{delta:35.65,assignment:"CH₃"}],from:35.644999999999996,to:35.655},{signals:[{delta:30.7,assignment:"CH₃"}],from:30.695,to:30.705}],nucleus:"13C",solvent:"THF-d₈"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:67.65,assignment:"CH₂"}],from:67.64500000000001,to:67.655}],nucleus:"13C",solvent:"THF-d₈"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:58.72,assignment:"CH₃"}],from:58.714999999999996,to:58.725},{signals:[{delta:72.58,assignment:"CH₂"}],from:72.575,to:72.585}],nucleus:"13C",solvent:"THF-d₈"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:6.79,assignment:"CH₃"}],from:6.785,to:6.795}],nucleus:"13C",solvent:"THF-d₈"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.9,assignment:"CH₃"}],from:18.895,to:18.904999999999998},{signals:[{delta:57.6,assignment:"CH₂"}],from:57.595,to:57.605000000000004}],nucleus:"13C",solvent:"THF-d₈"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:20.45,assignment:"CH₃CO"}],from:20.445,to:20.455},{signals:[{delta:170.32,assignment:"CO"}],from:170.315,to:170.325},{signals:[{delta:60.3,assignment:"CH₂"}],from:60.294999999999995,to:60.305},{signals:[{delta:14.37,assignment:"CH₃"}],from:14.364999999999998,to:14.375}],nucleus:"13C",solvent:"THF-d₈"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:123.09,assignment:"CH₂"}],from:123.08500000000001,to:123.095}],nucleus:"13C",solvent:"THF-d₈"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:64.35,assignment:"CH₂"}],from:64.345,to:64.35499999999999}],nucleus:"13C",solvent:"THF-d₈"},{names:["H grease"],smiles:"",ranges:[{signals:[{delta:30.45,assignment:"CH₂"}],from:30.445,to:30.455}],nucleus:"13C",solvent:"THF-d₈"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:131.88,assignment:"C"}],from:131.875,to:131.885},{signals:[{delta:16.71,assignment:"CH₃"}],from:16.705000000000002,to:16.715}],nucleus:"13C",solvent:"THF-d₈"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:14.22,assignment:"CH₃"}],from:14.215,to:14.225000000000001},{signals:[{delta:23.33,assignment:"CH₂(2,5)"}],from:23.325,to:23.334999999999997},{signals:[{delta:32.34,assignment:"CH₂(3,4)"}],from:32.335,to:32.345000000000006}],nucleus:"13C",solvent:"THF-d₈"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:1.83,assignment:"CH₃"}],from:1.8250000000000002,to:1.835}],nucleus:"13C",solvent:"THF-d₈"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:36.89,assignment:"CH₃"}],from:36.885,to:36.895}],nucleus:"13C",solvent:"THF-d₈"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:135.72,assignment:"CH(2)"}],from:135.715,to:135.725},{signals:[{delta:122.2,assignment:"CH(4,5)"}],from:122.19500000000001,to:122.205}],nucleus:"13C",solvent:"THF-d₈"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-4.9,assignment:"CH₄"}],from:-4.905,to:-4.8950000000000005}],nucleus:"13C",solvent:"THF-d₈"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:49.64,assignment:"CH₃"}],from:49.635,to:49.645}],nucleus:"13C",solvent:"THF-d₈"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:62.49,assignment:"CH₃"}],from:62.485,to:62.495000000000005}],nucleus:"13C",solvent:"THF-d₈"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:14.18,assignment:"CH₃"}],from:14.174999999999999,to:14.185},{signals:[{delta:23,assignment:"CH₂(2,4)"}],from:22.995,to:23.005},{signals:[{delta:34.87,assignment:"CH₂(3)"}],from:34.864999999999995,to:34.875}],nucleus:"13C",solvent:"THF-d₈"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.6,assignment:"CH₃"}],from:16.595000000000002,to:16.605},{signals:[{delta:16.82,assignment:"CH₂"}],from:16.815,to:16.825}],nucleus:"13C",solvent:"THF-d₈"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.7,assignment:"CH₃"}],from:25.695,to:25.705},{signals:[{delta:66.14,assignment:"CH"}],from:66.135,to:66.145}],nucleus:"13C",solvent:"THF-d₈"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.27,assignment:"CH₃"}],from:19.265,to:19.275},{signals:[{delta:115.74,assignment:"CH₂"}],from:115.735,to:115.74499999999999},{signals:[{delta:134.02,assignment:"CH"}],from:134.01500000000001,to:134.025}],nucleus:"13C",solvent:"THF-d₈"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:150.57,assignment:"CH(2,6)"}],from:150.565,to:150.575},{signals:[{delta:124.08,assignment:"CH(3,5)"}],from:124.075,to:124.085},{signals:[{delta:135.99,assignment:"CH(4)"}],from:135.985,to:135.995}],nucleus:"13C",solvent:"THF-d₈"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:118.03,assignment:"CH(2,5)"}],from:118.025,to:118.035},{signals:[{delta:107.74,assignment:"CH(3,4)"}],from:107.735,to:107.74499999999999}],nucleus:"13C",solvent:"THF-d₈"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:45.82,assignment:"CH₂(2,5)"}],from:45.815,to:45.825},{signals:[{delta:26.17,assignment:"CH₂(3,4)"}],from:26.165000000000003,to:26.175}],nucleus:"13C",solvent:"THF-d₈"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{delta:1.2,assignment:"CH₃"}],from:1.195,to:1.2049999999999998}],nucleus:"13C",solvent:"THF-d₈"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:68.03,assignment:"CH₂(2,5)"}],from:68.025,to:68.035},{signals:[{delta:26.19,assignment:"CH₂(3,4)"}],from:26.185000000000002,to:26.195}],nucleus:"13C",solvent:"THF-d₈"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:21.29,assignment:"CH₃"}],from:21.285,to:21.294999999999998},{signals:[{delta:138.24,assignment:"C(1)"}],from:138.235,to:138.245},{signals:[{delta:129.47,assignment:"CH(2,6)"}],from:129.465,to:129.475},{signals:[{delta:128.71,assignment:"CH(3,5)"}],from:128.705,to:128.715},{signals:[{delta:125.84,assignment:"CH(4)"}],from:125.83500000000001,to:125.845}],nucleus:"13C",solvent:"THF-d₈"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:12.51,assignment:"CH₃"}],from:12.504999999999999,to:12.515},{signals:[{delta:47.18,assignment:"CH₂"}],from:47.175,to:47.185}],nucleus:"13C",solvent:"THF-d₈"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:175.85,assignment:"CO"}],from:175.845,to:175.855},{signals:[{delta:20.91,assignment:"CH₃"}],from:20.905,to:20.915}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:206.78,assignment:"CO"}],from:206.775,to:206.785},{signals:[{delta:31,assignment:"CH₃"}],from:30.995,to:31.005}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:116.92,assignment:"CN"}],from:116.915,to:116.925},{signals:[{delta:2.03,assignment:"CH₃"}],from:2.025,to:2.0349999999999997}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:128.68,assignment:"CH"}],from:128.675,to:128.685}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:69.11,assignment:"(CH₃)₃C"}],from:69.105,to:69.115},{signals:[{delta:31.46,assignment:"(CH₃)₃C"}],from:31.455000000000002,to:31.465}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:125.26,assignment:"CO₂"}],from:125.25500000000001,to:125.265}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:192.95,assignment:"CS₂"}],from:192.945,to:192.95499999999998}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:96.52,assignment:"CCl₄"}],from:96.515,to:96.52499999999999}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:77.99,assignment:"CH"}],from:77.985,to:77.99499999999999}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:70.47,assignment:"CH₂"}],from:70.465,to:70.475}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:27.38,assignment:"CH₂"}],from:27.375,to:27.384999999999998}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:44.35,assignment:"CH₂"}],from:44.345,to:44.355000000000004}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:54.24,assignment:"CH₂"}],from:54.235,to:54.245000000000005}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.44,assignment:"CH₃"}],from:15.434999999999999,to:15.445},{signals:[{delta:66.11,assignment:"CH₂"}],from:66.105,to:66.115}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:58.95,assignment:"CH₃"}],from:58.945,to:58.955000000000005},{signals:[{delta:70.7,assignment:"CH₂"}],from:70.69500000000001,to:70.705},{signals:[{delta:72.25,assignment:"CH₂"}],from:72.245,to:72.255}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:162.57,assignment:"CH"}],from:162.565,to:162.575},{signals:[{delta:36.56,assignment:"CH₃"}],from:36.555,to:36.565000000000005},{signals:[{delta:31.39,assignment:"CH₃"}],from:31.385,to:31.395}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:67.47,assignment:"CH₂"}],from:67.465,to:67.475}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:59.02,assignment:"CH₃"}],from:59.015,to:59.025000000000006},{signals:[{delta:72.24,assignment:"CH₂"}],from:72.235,to:72.24499999999999}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:6.91,assignment:"CH₃"}],from:6.905,to:6.915}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.69,assignment:"CH₃"}],from:18.685000000000002,to:18.695},{signals:[{delta:58.57,assignment:"CH₂"}],from:58.565,to:58.575}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:21.15,assignment:"CH₃CO"}],from:21.145,to:21.154999999999998},{signals:[{delta:171.24,assignment:"CO"}],from:171.235,to:171.245},{signals:[{delta:60.63,assignment:"CH₂"}],from:60.625,to:60.635000000000005},{signals:[{delta:14.37,assignment:"CH₃"}],from:14.364999999999998,to:14.375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:123.2,assignment:"CH₂"}],from:123.19500000000001,to:123.205}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:64.08,assignment:"CH₂"}],from:64.075,to:64.085}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["H grease"],smiles:"",ranges:[{signals:[{delta:30.14,assignment:"CH₂"}],from:30.135,to:30.145}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:132.09,assignment:"C"}],from:132.085,to:132.095},{signals:[{delta:16.93,assignment:"CH₃"}],from:16.925,to:16.935}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:14.28,assignment:"CH₃"}],from:14.274999999999999,to:14.285},{signals:[{delta:23.07,assignment:"CH₂(2,5)"}],from:23.065,to:23.075},{signals:[{delta:32.01,assignment:"CH₂(3,4)"}],from:32.004999999999995,to:32.015}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:1.96,assignment:"CH₃"}],from:1.955,to:1.9649999999999999}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:36.99,assignment:"CH₃"}],from:36.985,to:36.995000000000005}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:135.76,assignment:"CH(2)"}],from:135.755,to:135.765},{signals:[{delta:122.16,assignment:"CH(4,5)"}],from:122.155,to:122.16499999999999}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-4.33,assignment:"CH₄"}],from:-4.335,to:-4.325}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:50.45,assignment:"CH₃"}],from:50.445,to:50.455000000000005}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:63.03,assignment:"CH₃"}],from:63.025,to:63.035000000000004}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:14.24,assignment:"CH₃"}],from:14.235,to:14.245000000000001},{signals:[{delta:22.77,assignment:"CH₂(2,4)"}],from:22.765,to:22.775},{signals:[{delta:34.57,assignment:"CH₂(3)"}],from:34.565,to:34.575}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.63,assignment:"CH₃"}],from:16.625,to:16.634999999999998},{signals:[{delta:16.63,assignment:"CH₂"}],from:16.625,to:16.634999999999998}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.43,assignment:"CH₃"}],from:25.425,to:25.435},{signals:[{delta:64.67,assignment:"CH"}],from:64.665,to:64.675}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.47,assignment:"CH₃"}],from:19.465,to:19.474999999999998},{signals:[{delta:115.7,assignment:"CH₂"}],from:115.69500000000001,to:115.705},{signals:[{delta:134.21,assignment:"CH"}],from:134.205,to:134.215}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:150.27,assignment:"CH(2,6)"}],from:150.26500000000001,to:150.275},{signals:[{delta:124.06,assignment:"CH(3,5)"}],from:124.055,to:124.065},{signals:[{delta:136.16,assignment:"CH(4)"}],from:136.155,to:136.165}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:117.93,assignment:"CH(2,5)"}],from:117.92500000000001,to:117.935},{signals:[{delta:108.02,assignment:"CH(3,4)"}],from:108.015,to:108.02499999999999}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:47.02,assignment:"CH₂(2,5)"}],from:47.015,to:47.025000000000006},{signals:[{delta:25.83,assignment:"CH₂(3,4)"}],from:25.825,to:25.834999999999997}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{delta:1.22,assignment:"CH₃"}],from:1.215,to:1.2249999999999999}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:68.16,assignment:"CH₂(2,5)"}],from:68.155,to:68.16499999999999},{signals:[{delta:25.98,assignment:"CH₂(3,4)"}],from:25.975,to:25.985}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:21.53,assignment:"CH₃"}],from:21.525000000000002,to:21.535},{signals:[{delta:138.36,assignment:"C(1)"}],from:138.35500000000002,to:138.365},{signals:[{delta:129.35,assignment:"CH(2,6)"}],from:129.345,to:129.355},{signals:[{delta:128.54,assignment:"CH(3,5)"}],from:128.535,to:128.545},{signals:[{delta:125.62,assignment:"CH(4)"}],from:125.61500000000001,to:125.625}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:12.12,assignment:"CH₃"}],from:12.114999999999998,to:12.125},{signals:[{delta:46.75,assignment:"CH₂"}],from:46.745,to:46.755}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:175.99,assignment:"CO"}],from:175.985,to:175.995},{signals:[{delta:20.81,assignment:"CH₃"}],from:20.805,to:20.814999999999998}],nucleus:"13C",solvent:"CDCl₃"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:207.07,assignment:"CO"}],from:207.065,to:207.075},{signals:[{delta:30.92,assignment:"CH₃"}],from:30.915000000000003,to:30.925}],nucleus:"13C",solvent:"CDCl₃"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:116.43,assignment:"CN"}],from:116.42500000000001,to:116.435},{signals:[{delta:1.89,assignment:"CH₃"}],from:1.885,to:1.8949999999999998}],nucleus:"13C",solvent:"CDCl₃"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:128.37,assignment:"CH"}],from:128.365,to:128.375}],nucleus:"13C",solvent:"CDCl₃"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:69.15,assignment:"(CH₃)₃C"}],from:69.14500000000001,to:69.155},{signals:[{delta:31.25,assignment:"(CH₃)₃C"}],from:31.245,to:31.255}],nucleus:"13C",solvent:"CDCl₃"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:124.99,assignment:"CO₂"}],from:124.985,to:124.99499999999999}],nucleus:"13C",solvent:"CDCl₃"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:192.83,assignment:"CS₂"}],from:192.82500000000002,to:192.835}],nucleus:"13C",solvent:"CDCl₃"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:96.34,assignment:"CCl₄"}],from:96.33500000000001,to:96.345}],nucleus:"13C",solvent:"CDCl₃"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:77.36,assignment:"CH"}],from:77.355,to:77.365}],nucleus:"13C",solvent:"CDCl₃"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:70.55,assignment:"CH₂"}],from:70.545,to:70.55499999999999}],nucleus:"13C",solvent:"CDCl₃"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:26.94,assignment:"CH₂"}],from:26.935000000000002,to:26.945}],nucleus:"13C",solvent:"CDCl₃"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:43.5,assignment:"CH₂"}],from:43.495,to:43.505}],nucleus:"13C",solvent:"CDCl₃"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:53.52,assignment:"CH₂"}],from:53.515,to:53.525000000000006}],nucleus:"13C",solvent:"CDCl₃"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.2,assignment:"CH₃"}],from:15.194999999999999,to:15.205},{signals:[{delta:65.91,assignment:"CH₂"}],from:65.905,to:65.91499999999999}],nucleus:"13C",solvent:"CDCl₃"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:59.01,assignment:"CH₃"}],from:59.004999999999995,to:59.015},{signals:[{delta:70.51,assignment:"CH₂"}],from:70.50500000000001,to:70.515},{signals:[{delta:71.9,assignment:"CH₂"}],from:71.89500000000001,to:71.905}],nucleus:"13C",solvent:"CDCl₃"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:162.62,assignment:"CH"}],from:162.615,to:162.625},{signals:[{delta:36.5,assignment:"CH₃"}],from:36.495,to:36.505},{signals:[{delta:31.45,assignment:"CH₃"}],from:31.445,to:31.455}],nucleus:"13C",solvent:"CDCl₃"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:67.14,assignment:"CH₂"}],from:67.135,to:67.145}],nucleus:"13C",solvent:"CDCl₃"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:59.08,assignment:"CH₃"}],from:59.074999999999996,to:59.085},{signals:[{delta:71.84,assignment:"CH₂"}],from:71.83500000000001,to:71.845}],nucleus:"13C",solvent:"CDCl₃"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:6.89,assignment:"CH₃"}],from:6.885,to:6.895}],nucleus:"13C",solvent:"CDCl₃"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.41,assignment:"CH₃"}],from:18.405,to:18.415},{signals:[{delta:58.28,assignment:"CH₂"}],from:58.275,to:58.285000000000004}],nucleus:"13C",solvent:"CDCl₃"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:21.04,assignment:"CH₃CO"}],from:21.035,to:21.044999999999998},{signals:[{delta:171.36,assignment:"CO"}],from:171.35500000000002,to:171.365},{signals:[{delta:60.49,assignment:"CH₂"}],from:60.485,to:60.495000000000005},{signals:[{delta:14.19,assignment:"CH₃"}],from:14.184999999999999,to:14.195}],nucleus:"13C",solvent:"CDCl₃"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:123.13,assignment:"CH₂"}],from:123.125,to:123.13499999999999}],nucleus:"13C",solvent:"CDCl₃"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:63.79,assignment:"CH₂"}],from:63.785,to:63.795}],nucleus:"13C",solvent:"CDCl₃"},{names:["H grease"],smiles:"",ranges:[{signals:[{delta:29.71,assignment:"CH₂"}],from:29.705000000000002,to:29.715}],nucleus:"13C",solvent:"CDCl₃"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:132.21,assignment:"C"}],from:132.205,to:132.215},{signals:[{delta:16.98,assignment:"CH₃"}],from:16.975,to:16.985}],nucleus:"13C",solvent:"CDCl₃"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:14.14,assignment:"CH₃"}],from:14.135,to:14.145000000000001},{signals:[{delta:22.7,assignment:"CH₂(2,5)"}],from:22.695,to:22.705},{signals:[{delta:31.64,assignment:"CH₂(3,4)"}],from:31.635,to:31.645}],nucleus:"13C",solvent:"CDCl₃"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:1.97,assignment:"CH₃"}],from:1.965,to:1.9749999999999999}],nucleus:"13C",solvent:"CDCl₃"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:36.87,assignment:"CH₃"}],from:36.864999999999995,to:36.875}],nucleus:"13C",solvent:"CDCl₃"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:135.38,assignment:"CH(2)"}],from:135.375,to:135.385},{signals:[{delta:122,assignment:"CH(4,5)"}],from:121.995,to:122.005}],nucleus:"13C",solvent:"CDCl₃"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-4.63,assignment:"CH₄"}],from:-4.635,to:-4.625}],nucleus:"13C",solvent:"CDCl₃"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:50.41,assignment:"CH₃"}],from:50.404999999999994,to:50.415}],nucleus:"13C",solvent:"CDCl₃"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:62.5,assignment:"CH₃"}],from:62.495,to:62.505}],nucleus:"13C",solvent:"CDCl₃"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:14.08,assignment:"CH₃"}],from:14.075,to:14.085},{signals:[{delta:22.38,assignment:"CH₂(2,4)"}],from:22.375,to:22.384999999999998},{signals:[{delta:34.16,assignment:"CH₂(3)"}],from:34.154999999999994,to:34.165}],nucleus:"13C",solvent:"CDCl₃"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.63,assignment:"CH₃"}],from:16.625,to:16.634999999999998},{signals:[{delta:16.37,assignment:"CH₂"}],from:16.365000000000002,to:16.375}],nucleus:"13C",solvent:"CDCl₃"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.14,assignment:"CH₃"}],from:25.135,to:25.145},{signals:[{delta:64.5,assignment:"CH"}],from:64.495,to:64.505}],nucleus:"13C",solvent:"CDCl₃"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.5,assignment:"CH₃"}],from:19.495,to:19.505},{signals:[{delta:115.74,assignment:"CH₂"}],from:115.735,to:115.74499999999999},{signals:[{delta:133.91,assignment:"CH"}],from:133.905,to:133.915}],nucleus:"13C",solvent:"CDCl₃"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:149.9,assignment:"CH(2,6)"}],from:149.895,to:149.905},{signals:[{delta:123.75,assignment:"CH(3,5)"}],from:123.745,to:123.755},{signals:[{delta:135.96,assignment:"CH(4)"}],from:135.955,to:135.965}],nucleus:"13C",solvent:"CDCl₃"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:117.77,assignment:"CH(2,5)"}],from:117.765,to:117.77499999999999},{signals:[{delta:107.98,assignment:"CH(3,4)"}],from:107.97500000000001,to:107.985}],nucleus:"13C",solvent:"CDCl₃"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:46.93,assignment:"CH₂(2,5)"}],from:46.925,to:46.935},{signals:[{delta:25.56,assignment:"CH₂(3,4)"}],from:25.555,to:25.564999999999998}],nucleus:"13C",solvent:"CDCl₃"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{delta:1.19,assignment:"CH₃"}],from:1.185,to:1.1949999999999998}],nucleus:"13C",solvent:"CDCl₃"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:67.97,assignment:"CH₂(2,5)"}],from:67.965,to:67.975},{signals:[{delta:25.62,assignment:"CH₂(3,4)"}],from:25.615000000000002,to:25.625}],nucleus:"13C",solvent:"CDCl₃"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:21.46,assignment:"CH₃"}],from:21.455000000000002,to:21.465},{signals:[{delta:137.89,assignment:"C(1)"}],from:137.885,to:137.89499999999998},{signals:[{delta:129.07,assignment:"CH(2,6)"}],from:129.065,to:129.075},{signals:[{delta:128.26,assignment:"CH(3,5)"}],from:128.255,to:128.265},{signals:[{delta:125.33,assignment:"CH(4)"}],from:125.325,to:125.335}],nucleus:"13C",solvent:"CDCl₃"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:11.61,assignment:"CH₃"}],from:11.604999999999999,to:11.615},{signals:[{delta:46.25,assignment:"CH₂"}],from:46.245,to:46.255}],nucleus:"13C",solvent:"CDCl₃"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:175.3,assignment:"CO"}],from:175.29500000000002,to:175.305},{signals:[{delta:20.27,assignment:"CH₃"}],from:20.265,to:20.275}],nucleus:"13C",solvent:"toluene- d₈"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:204,assignment:"CO"}],from:203.995,to:204.005},{signals:[{delta:30.03,assignment:"CH₃"}],from:30.025000000000002,to:30.035}],nucleus:"13C",solvent:"toluene- d₈"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:115.76,assignment:"CN"}],from:115.75500000000001,to:115.765},{signals:[{delta:.03,assignment:"CH₃"}],from:.024999999999999998,to:.034999999999999996}],nucleus:"13C",solvent:"toluene- d₈"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:128.57,assignment:"CH"}],from:128.565,to:128.575}],nucleus:"13C",solvent:"toluene- d₈"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:68.12,assignment:"(CH₃)₃C"}],from:68.11500000000001,to:68.125},{signals:[{delta:30.49,assignment:"(CH₃)₃C"}],from:30.485,to:30.494999999999997}],nucleus:"13C",solvent:"toluene- d₈"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:124.86,assignment:"CO₂"}],from:124.855,to:124.865}],nucleus:"13C",solvent:"toluene- d₈"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:192.71,assignment:"CS₂"}],from:192.705,to:192.715}],nucleus:"13C",solvent:"toluene- d₈"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:96.57,assignment:"CCl₄"}],from:96.565,to:96.57499999999999}],nucleus:"13C",solvent:"toluene- d₈"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:77.89,assignment:"CH"}],from:77.885,to:77.895}],nucleus:"13C",solvent:"toluene- d₈"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:70.86,assignment:"CH₂"}],from:70.855,to:70.865}],nucleus:"13C",solvent:"toluene- d₈"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:27.31,assignment:"CH₂"}],from:27.305,to:27.314999999999998}],nucleus:"13C",solvent:"toluene- d₈"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:43.4,assignment:"CH₂"}],from:43.394999999999996,to:43.405}],nucleus:"13C",solvent:"toluene- d₈"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:53.47,assignment:"CH₂"}],from:53.464999999999996,to:53.475}],nucleus:"13C",solvent:"toluene- d₈"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.47,assignment:"CH₃"}],from:15.465,to:15.475000000000001},{signals:[{delta:65.94,assignment:"CH₂"}],from:65.935,to:65.945}],nucleus:"13C",solvent:"toluene- d₈"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:58.62,assignment:"CH₃"}],from:58.614999999999995,to:58.625},{signals:[{delta:70.92,assignment:"CH₂"}],from:70.915,to:70.925},{signals:[{delta:72.39,assignment:"CH₂"}],from:72.385,to:72.395}],nucleus:"13C",solvent:"toluene- d₈"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:161.93,assignment:"CH"}],from:161.925,to:161.935},{signals:[{delta:35.22,assignment:"CH₃"}],from:35.214999999999996,to:35.225},{signals:[{delta:30.64,assignment:"CH₃"}],from:30.635,to:30.645}],nucleus:"13C",solvent:"toluene- d₈"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:67.17,assignment:"CH₂"}],from:67.165,to:67.175}],nucleus:"13C",solvent:"toluene- d₈"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:58.63,assignment:"CH₃"}],from:58.625,to:58.635000000000005},{signals:[{delta:72.25,assignment:"CH₂"}],from:72.245,to:72.255}],nucleus:"13C",solvent:"toluene- d₈"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:6.94,assignment:"CH₃"}],from:6.9350000000000005,to:6.945}],nucleus:"13C",solvent:"toluene- d₈"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.78,assignment:"CH₃"}],from:18.775000000000002,to:18.785},{signals:[{delta:57.81,assignment:"CH₂"}],from:57.805,to:57.815000000000005}],nucleus:"13C",solvent:"toluene- d₈"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:20.46,assignment:"CH₃CO"}],from:20.455000000000002,to:20.465},{signals:[{delta:170.02,assignment:"CO"}],from:170.01500000000001,to:170.025},{signals:[{delta:60.08,assignment:"CH₂"}],from:60.074999999999996,to:60.085},{signals:[{delta:14.23,assignment:"CH₃"}],from:14.225,to:14.235000000000001}],nucleus:"13C",solvent:"toluene- d₈"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:122.92,assignment:"CH₂"}],from:122.915,to:122.925}],nucleus:"13C",solvent:"toluene- d₈"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:64.29,assignment:"CH₂"}],from:64.28500000000001,to:64.295}],nucleus:"13C",solvent:"toluene- d₈"},{names:["H grease"],smiles:"",ranges:[{signals:[{delta:30.31,assignment:"CH₂"}],from:30.305,to:30.314999999999998}],nucleus:"13C",solvent:"toluene- d₈"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:131.72,assignment:"C"}],from:131.715,to:131.725},{signals:[{delta:16.84,assignment:"CH₃"}],from:16.835,to:16.845}],nucleus:"13C",solvent:"toluene- d₈"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:14.34,assignment:"CH₃"}],from:14.334999999999999,to:14.345},{signals:[{delta:23.12,assignment:"CH₂(2,5)"}],from:23.115000000000002,to:23.125},{signals:[{delta:32.06,assignment:"CH₂(3,4)"}],from:32.055,to:32.065000000000005}],nucleus:"13C",solvent:"toluene- d₈"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:1.99,assignment:"CH₃"}],from:1.985,to:1.9949999999999999}],nucleus:"13C",solvent:"toluene- d₈"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:36.8,assignment:"CH₃"}],from:36.794999999999995,to:36.805}],nucleus:"13C",solvent:"toluene- d₈"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:135.57,assignment:"CH(2)"}],from:135.565,to:135.575},{signals:[{delta:122.13,assignment:"CH(4,5)"}],from:122.125,to:122.13499999999999}],nucleus:"13C",solvent:"toluene- d₈"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-4.34,assignment:"CH₄"}],from:-4.345,to:-4.335}],nucleus:"13C",solvent:"toluene- d₈"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:49.9,assignment:"CH₃"}],from:49.894999999999996,to:49.905}],nucleus:"13C",solvent:"toluene- d₈"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:61.14,assignment:"CH₃"}],from:61.135,to:61.145}],nucleus:"13C",solvent:"toluene- d₈"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:14.27,assignment:"CH₃"}],from:14.264999999999999,to:14.275},{signals:[{delta:22.79,assignment:"CH₂(2,4)"}],from:22.785,to:22.794999999999998},{signals:[{delta:34.54,assignment:"CH₂(3)"}],from:34.535,to:34.545}],nucleus:"13C",solvent:"toluene- d₈"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.65,assignment:"CH₃"}],from:16.645,to:16.654999999999998},{signals:[{delta:16.63,assignment:"CH₂"}],from:16.625,to:16.634999999999998}],nucleus:"13C",solvent:"toluene- d₈"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.24,assignment:"CH₃"}],from:25.235,to:25.244999999999997},{signals:[{delta:64.12,assignment:"CH"}],from:64.11500000000001,to:64.125}],nucleus:"13C",solvent:"toluene- d₈"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.32,assignment:"CH₃"}],from:19.315,to:19.325},{signals:[{delta:115.89,assignment:"CH₂"}],from:115.885,to:115.895},{signals:[{delta:133.61,assignment:"CH"}],from:133.60500000000002,to:133.615}],nucleus:"13C",solvent:"toluene- d₈"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:150.25,assignment:"CH(2,6)"}],from:150.245,to:150.255},{signals:[{delta:123.46,assignment:"CH(3,5)"}],from:123.455,to:123.46499999999999},{signals:[{delta:135.17,assignment:"CH(4)"}],from:135.165,to:135.17499999999998}],nucleus:"13C",solvent:"toluene- d₈"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:117.61,assignment:"CH(2,5)"}],from:117.605,to:117.615},{signals:[{delta:108.15,assignment:"CH(3,4)"}],from:108.14500000000001,to:108.155}],nucleus:"13C",solvent:"toluene- d₈"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:47.12,assignment:"CH₂(2,5)"}],from:47.114999999999995,to:47.125},{signals:[{delta:25.75,assignment:"CH₂(3,4)"}],from:25.745,to:25.755}],nucleus:"13C",solvent:"toluene- d₈"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{delta:1.37,assignment:"CH₃"}],from:1.3650000000000002,to:1.375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:67.75,assignment:"CH₂(2,5)"}],from:67.745,to:67.755},{signals:[{delta:25.79,assignment:"CH₂(3,4)"}],from:25.785,to:25.794999999999998}],nucleus:"13C",solvent:"toluene- d₈"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:21.37,assignment:"CH₃"}],from:21.365000000000002,to:21.375},{signals:[{delta:137.84,assignment:"C(1)"}],from:137.835,to:137.845},{signals:[{delta:129.33,assignment:"CH(2,6)"}],from:129.32500000000002,to:129.335},{signals:[{delta:128.51,assignment:"CH(3,5)"}],from:128.505,to:128.515},{signals:[{delta:125.66,assignment:"CH(4)"}],from:125.655,to:125.66499999999999}],nucleus:"13C",solvent:"toluene- d₈"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:12.39,assignment:"CH₃"}],from:12.385,to:12.395000000000001},{signals:[{delta:46.82,assignment:"CH₂"}],from:46.815,to:46.825}],nucleus:"13C",solvent:"toluene- d₈"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:175.82,assignment:"CO"}],from:175.815,to:175.825},{signals:[{delta:20.37,assignment:"CH₃"}],from:20.365000000000002,to:20.375}],nucleus:"13C",solvent:"C₆D₆"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:204.43,assignment:"CO"}],from:204.425,to:204.435},{signals:[{delta:30.14,assignment:"CH₃"}],from:30.135,to:30.145}],nucleus:"13C",solvent:"C₆D₆"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:116.02,assignment:"CN"}],from:116.015,to:116.02499999999999},{signals:[{delta:.2,assignment:"CH₃"}],from:.195,to:.20500000000000002}],nucleus:"13C",solvent:"C₆D₆"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:128.62,assignment:"CH"}],from:128.615,to:128.625}],nucleus:"13C",solvent:"C₆D₆"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:68.19,assignment:"(CH₃)₃C"}],from:68.185,to:68.195},{signals:[{delta:30.47,assignment:"(CH₃)₃C"}],from:30.465,to:30.474999999999998}],nucleus:"13C",solvent:"C₆D₆"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:124.76,assignment:"CO₂"}],from:124.75500000000001,to:124.765}],nucleus:"13C",solvent:"C₆D₆"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:192.69,assignment:"CS₂"}],from:192.685,to:192.695}],nucleus:"13C",solvent:"C₆D₆"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:96.44,assignment:"CCl₄"}],from:96.435,to:96.445}],nucleus:"13C",solvent:"C₆D₆"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:77.79,assignment:"CH"}],from:77.78500000000001,to:77.795}],nucleus:"13C",solvent:"C₆D₆"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:70.59,assignment:"CH₂"}],from:70.58500000000001,to:70.595}],nucleus:"13C",solvent:"C₆D₆"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:27.23,assignment:"CH₂"}],from:27.225,to:27.235}],nucleus:"13C",solvent:"C₆D₆"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:43.59,assignment:"CH₂"}],from:43.585,to:43.595000000000006}],nucleus:"13C",solvent:"C₆D₆"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:53.46,assignment:"CH₂"}],from:53.455,to:53.465}],nucleus:"13C",solvent:"C₆D₆"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.46,assignment:"CH₃"}],from:15.455,to:15.465000000000002},{signals:[{delta:65.94,assignment:"CH₂"}],from:65.935,to:65.945}],nucleus:"13C",solvent:"C₆D₆"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:58.66,assignment:"CH₃"}],from:58.654999999999994,to:58.665},{signals:[{delta:70.87,assignment:"CH₂"}],from:70.86500000000001,to:70.875},{signals:[{delta:72.35,assignment:"CH₂"}],from:72.345,to:72.35499999999999}],nucleus:"13C",solvent:"C₆D₆"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:162.13,assignment:"CH"}],from:162.125,to:162.135},{signals:[{delta:35.25,assignment:"CH₃"}],from:35.245,to:35.255},{signals:[{delta:30.72,assignment:"CH₃"}],from:30.715,to:30.724999999999998}],nucleus:"13C",solvent:"C₆D₆"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:67.16,assignment:"CH₂"}],from:67.155,to:67.16499999999999}],nucleus:"13C",solvent:"C₆D₆"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:58.68,assignment:"CH₃"}],from:58.675,to:58.685},{signals:[{delta:72.21,assignment:"CH₂"}],from:72.205,to:72.21499999999999}],nucleus:"13C",solvent:"C₆D₆"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:6.96,assignment:"CH₃"}],from:6.955,to:6.965}],nucleus:"13C",solvent:"C₆D₆"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.72,assignment:"CH₃"}],from:18.715,to:18.724999999999998},{signals:[{delta:57.86,assignment:"CH₂"}],from:57.855,to:57.865}],nucleus:"13C",solvent:"C₆D₆"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:20.56,assignment:"CH₃CO"}],from:20.555,to:20.564999999999998},{signals:[{delta:170.44,assignment:"CO"}],from:170.435,to:170.445},{signals:[{delta:60.21,assignment:"CH₂"}],from:60.205,to:60.215},{signals:[{delta:14.19,assignment:"CH₃"}],from:14.184999999999999,to:14.195}],nucleus:"13C",solvent:"C₆D₆"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:122.96,assignment:"CH₂"}],from:122.955,to:122.96499999999999}],nucleus:"13C",solvent:"C₆D₆"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:64.34,assignment:"CH₂"}],from:64.33500000000001,to:64.345}],nucleus:"13C",solvent:"C₆D₆"},{names:["H grease"],smiles:"",ranges:[{signals:[{delta:30.22,assignment:"CH₂"}],from:30.215,to:30.224999999999998}],nucleus:"13C",solvent:"C₆D₆"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:131.79,assignment:"C"}],from:131.785,to:131.795},{signals:[{delta:16.95,assignment:"CH₃"}],from:16.945,to:16.955}],nucleus:"13C",solvent:"C₆D₆"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:14.32,assignment:"CH₃"}],from:14.315,to:14.325000000000001},{signals:[{delta:23.04,assignment:"CH₂(2,5)"}],from:23.035,to:23.044999999999998},{signals:[{delta:31.96,assignment:"CH₂(3,4)"}],from:31.955000000000002,to:31.965}],nucleus:"13C",solvent:"C₆D₆"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:2.05,assignment:"CH₃"}],from:2.045,to:2.0549999999999997}],nucleus:"13C",solvent:"C₆D₆"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:36.88,assignment:"CH₃"}],from:36.875,to:36.885000000000005}],nucleus:"13C",solvent:"C₆D₆"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:135.76,assignment:"CH(2)"}],from:135.755,to:135.765},{signals:[{delta:122.16,assignment:"CH(4,5)"}],from:122.155,to:122.16499999999999}],nucleus:"13C",solvent:"C₆D₆"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-4.29,assignment:"CH₄"}],from:-4.295,to:-4.285}],nucleus:"13C",solvent:"C₆D₆"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:49.97,assignment:"CH₃"}],from:49.964999999999996,to:49.975}],nucleus:"13C",solvent:"C₆D₆"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:61.16,assignment:"CH₃"}],from:61.154999999999994,to:61.165}],nucleus:"13C",solvent:"C₆D₆"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:14.25,assignment:"CH₃"}],from:14.245,to:14.255},{signals:[{delta:22.72,assignment:"CH₂(2,4)"}],from:22.715,to:22.724999999999998},{signals:[{delta:34.45,assignment:"CH₂(3)"}],from:34.445,to:34.455000000000005}],nucleus:"13C",solvent:"C₆D₆"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.66,assignment:"CH₃"}],from:16.655,to:16.665},{signals:[{delta:16.6,assignment:"CH₂"}],from:16.595000000000002,to:16.605}],nucleus:"13C",solvent:"C₆D₆"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.18,assignment:"CH₃"}],from:25.175,to:25.185},{signals:[{delta:64.23,assignment:"CH"}],from:64.22500000000001,to:64.235}],nucleus:"13C",solvent:"C₆D₆"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.38,assignment:"CH₃"}],from:19.375,to:19.384999999999998},{signals:[{delta:115.92,assignment:"CH₂"}],from:115.915,to:115.925},{signals:[{delta:133.69,assignment:"CH"}],from:133.685,to:133.695}],nucleus:"13C",solvent:"C₆D₆"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:150.27,assignment:"CH(2,6)"}],from:150.26500000000001,to:150.275},{signals:[{delta:123.58,assignment:"CH(3,5)"}],from:123.575,to:123.585},{signals:[{delta:135.28,assignment:"CH(4)"}],from:135.275,to:135.285}],nucleus:"13C",solvent:"C₆D₆"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:117.78,assignment:"CH(2,5)"}],from:117.775,to:117.785},{signals:[{delta:108.21,assignment:"CH(3,4)"}],from:108.205,to:108.21499999999999}],nucleus:"13C",solvent:"C₆D₆"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:46.86,assignment:"CH₂(2,5)"}],from:46.855,to:46.865},{signals:[{delta:25.65,assignment:"CH₂(3,4)"}],from:25.645,to:25.654999999999998}],nucleus:"13C",solvent:"C₆D₆"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{delta:1.38,assignment:"CH₃"}],from:1.375,to:1.3849999999999998}],nucleus:"13C",solvent:"C₆D₆"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:67.8,assignment:"CH₂(2,5)"}],from:67.795,to:67.80499999999999},{signals:[{delta:25.72,assignment:"CH₂(3,4)"}],from:25.715,to:25.724999999999998}],nucleus:"13C",solvent:"C₆D₆"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:21.1,assignment:"CH₃"}],from:21.095000000000002,to:21.105},{signals:[{delta:137.91,assignment:"C(1)"}],from:137.905,to:137.915},{signals:[{delta:129.33,assignment:"CH(2,6)"}],from:129.32500000000002,to:129.335},{signals:[{delta:128.56,assignment:"CH(3,5)"}],from:128.555,to:128.565},{signals:[{delta:125.68,assignment:"CH(4)"}],from:125.67500000000001,to:125.685}],nucleus:"13C",solvent:"C₆D₆"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:12.35,assignment:"CH₃"}],from:12.344999999999999,to:12.355},{signals:[{delta:46.77,assignment:"CH₂"}],from:46.765,to:46.775000000000006}],nucleus:"13C",solvent:"C₆D₆"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:175.67,assignment:"CO"}],from:175.665,to:175.67499999999998},{signals:[{delta:20.4,assignment:"CH₃"}],from:20.395,to:20.404999999999998}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:204.83,assignment:"CO"}],from:204.82500000000002,to:204.835},{signals:[{delta:30.12,assignment:"CH₃"}],from:30.115000000000002,to:30.125}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:115.93,assignment:"CN"}],from:115.92500000000001,to:115.935},{signals:[{delta:.63,assignment:"CH₃"}],from:.625,to:.635}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:128.38,assignment:"CH"}],from:128.375,to:128.385}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:68.19,assignment:"(CH₃)₃C"}],from:68.185,to:68.195},{signals:[{delta:31.13,assignment:"(CH₃)₃C"}],from:31.125,to:31.134999999999998}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:126.08,assignment:"CO₂"}],from:126.075,to:126.085}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:192.49,assignment:"CS₂"}],from:192.485,to:192.495}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:96.38,assignment:"CCl₄"}],from:96.375,to:96.38499999999999}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:77.67,assignment:"CH"}],from:77.665,to:77.675}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:70.55,assignment:"CH₂"}],from:70.545,to:70.55499999999999}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:26.99,assignment:"CH₂"}],from:26.985,to:26.994999999999997}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:43.6,assignment:"CH₂"}],from:43.595,to:43.605000000000004}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:53.54,assignment:"CH₂"}],from:53.535,to:53.545}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.35,assignment:"CH₃"}],from:15.344999999999999,to:15.355},{signals:[{delta:65.79,assignment:"CH₂"}],from:65.78500000000001,to:65.795}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:58.42,assignment:"CH₃"}],from:58.415,to:58.425000000000004},{signals:[{delta:70.56,assignment:"CH₂"}],from:70.555,to:70.565},{signals:[{delta:72.07,assignment:"CH₂"}],from:72.065,to:72.07499999999999}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:162.01,assignment:"CH"}],from:162.005,to:162.015},{signals:[{delta:35.45,assignment:"CH₃"}],from:35.445,to:35.455000000000005},{signals:[{delta:30.71,assignment:"CH₃"}],from:30.705000000000002,to:30.715}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:66.95,assignment:"CH₂"}],from:66.94500000000001,to:66.955}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:58.31,assignment:"CH₃"}],from:58.305,to:58.315000000000005},{signals:[{delta:71.81,assignment:"CH₂"}],from:71.805,to:71.815}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:6.91,assignment:"CH₃"}],from:6.905,to:6.915}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.55,assignment:"CH₃"}],from:18.545,to:18.555},{signals:[{delta:57.63,assignment:"CH₂"}],from:57.625,to:57.635000000000005}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:20.5,assignment:"CH₃CO"}],from:20.495,to:20.505},{signals:[{delta:170.2,assignment:"CO"}],from:170.195,to:170.20499999999998},{signals:[{delta:60.06,assignment:"CH₂"}],from:60.055,to:60.065000000000005},{signals:[{delta:14.07,assignment:"CH₃"}],from:14.065,to:14.075000000000001}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:122.95,assignment:"CH₂"}],from:122.94500000000001,to:122.955}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:64.03,assignment:"CH₂"}],from:64.025,to:64.035}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["H grease"],smiles:"",ranges:[{signals:[{delta:30.11,assignment:"CH₂"}],from:30.105,to:30.115}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:131.54,assignment:"C"}],from:131.535,to:131.545},{signals:[{delta:16.68,assignment:"CH₃"}],from:16.675,to:16.685}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:14.18,assignment:"CH₃"}],from:14.174999999999999,to:14.185},{signals:[{delta:22.86,assignment:"CH₂(2,5)"}],from:22.855,to:22.865},{signals:[{delta:31.77,assignment:"CH₂(3,4)"}],from:31.765,to:31.775}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:1.92,assignment:"CH₃"}],from:1.915,to:1.9249999999999998}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:36.64,assignment:"CH₃"}],from:36.635,to:36.645}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:135.5,assignment:"CH(2)"}],from:135.495,to:135.505},{signals:[{delta:121.96,assignment:"CH(4,5)"}],from:121.955,to:121.96499999999999}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-4.33,assignment:"CH₄"}],from:-4.335,to:-4.325}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:49.66,assignment:"CH₃"}],from:49.654999999999994,to:49.665}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:61.68,assignment:"CH₃"}],from:61.675,to:61.685}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:14.1,assignment:"CH₃"}],from:14.094999999999999,to:14.105},{signals:[{delta:22.54,assignment:"CH₂(2,4)"}],from:22.535,to:22.544999999999998},{signals:[{delta:34.26,assignment:"CH₂(3)"}],from:34.254999999999995,to:34.265}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.56,assignment:"CH₃"}],from:16.555,to:16.564999999999998},{signals:[{delta:16.48,assignment:"CH₂"}],from:16.475,to:16.485}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.14,assignment:"CH₃"}],from:25.135,to:25.145},{signals:[{delta:64.18,assignment:"CH"}],from:64.17500000000001,to:64.185}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.32,assignment:"CH₃"}],from:19.315,to:19.325},{signals:[{delta:115.86,assignment:"CH₂"}],from:115.855,to:115.865},{signals:[{delta:133.57,assignment:"CH"}],from:133.565,to:133.575}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:149.93,assignment:"CH(2,6)"}],from:149.925,to:149.935},{signals:[{delta:123.49,assignment:"CH(3,5)"}],from:123.485,to:123.49499999999999},{signals:[{delta:135.32,assignment:"CH(4)"}],from:135.315,to:135.325}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:117.65,assignment:"CH(2,5)"}],from:117.64500000000001,to:117.655},{signals:[{delta:108.03,assignment:"CH(3,4)"}],from:108.025,to:108.035}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:46.75,assignment:"CH₂(2,5)"}],from:46.745,to:46.755},{signals:[{delta:25.59,assignment:"CH₂(3,4)"}],from:25.585,to:25.595}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{delta:1.09,assignment:"CH₃"}],from:1.0850000000000002,to:1.095}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:67.64,assignment:"CH₂(2,5)"}],from:67.635,to:67.645},{signals:[{delta:25.68,assignment:"CH₂(3,4)"}],from:25.675,to:25.685}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:21.23,assignment:"CH₃"}],from:21.225,to:21.235},{signals:[{delta:137.65,assignment:"C(1)"}],from:137.645,to:137.655},{signals:[{delta:129.12,assignment:"CH(2,6)"}],from:129.115,to:129.125},{signals:[{delta:128.31,assignment:"CH(3,5)"}],from:128.305,to:128.315},{signals:[{delta:125.43,assignment:"CH(4)"}],from:125.42500000000001,to:125.435}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:11.87,assignment:"CH₃"}],from:11.864999999999998,to:11.875},{signals:[{delta:46.36,assignment:"CH₂"}],from:46.355,to:46.365}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:172.31,assignment:"CO"}],from:172.305,to:172.315},{signals:[{delta:20.51,assignment:"CH₃"}],from:20.505000000000003,to:20.515}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:205.87,assignment:"CO"}],from:205.865,to:205.875},{signals:[{delta:30.6,assignment:"CH₃"}],from:30.595000000000002,to:30.605}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:117.6,assignment:"CN"}],from:117.595,to:117.60499999999999},{signals:[{delta:1.12,assignment:"CH₃"}],from:1.1150000000000002,to:1.125}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:129.15,assignment:"CH"}],from:129.145,to:129.155}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:68.13,assignment:"(CH₃)₃C"}],from:68.125,to:68.13499999999999},{signals:[{delta:30.72,assignment:"(CH₃)₃C"}],from:30.715,to:30.724999999999998}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:125.81,assignment:"CO₂"}],from:125.805,to:125.815}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:193.58,assignment:"CS₂"}],from:193.57500000000002,to:193.585}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:96.65,assignment:"CCl₄"}],from:96.64500000000001,to:96.655}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:79.19,assignment:"CH"}],from:79.185,to:79.195}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:71.25,assignment:"CH₂"}],from:71.245,to:71.255}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:27.51,assignment:"CH₂"}],from:27.505000000000003,to:27.515}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:45.25,assignment:"CH₂"}],from:45.245,to:45.255}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:54.95,assignment:"CH₂"}],from:54.945,to:54.955000000000005}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.78,assignment:"CH₃"}],from:15.774999999999999,to:15.785},{signals:[{delta:66.12,assignment:"CH₂"}],from:66.11500000000001,to:66.125}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:58.77,assignment:"CH₃"}],from:58.765,to:58.775000000000006},{signals:[{delta:71.03,assignment:"CH₂"}],from:71.025,to:71.035},{signals:[{delta:72.63,assignment:"CH₂"}],from:72.625,to:72.63499999999999}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:162.79,assignment:"CH"}],from:162.785,to:162.795},{signals:[{delta:36.15,assignment:"CH₃"}],from:36.144999999999996,to:36.155},{signals:[{delta:31.03,assignment:"CH₃"}],from:31.025000000000002,to:31.035}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:67.6,assignment:"CH₂"}],from:67.595,to:67.60499999999999}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:58.45,assignment:"CH₃"}],from:58.445,to:58.455000000000005},{signals:[{delta:72.47,assignment:"CH₂"}],from:72.465,to:72.475}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:6.88,assignment:"CH₃"}],from:6.875,to:6.885}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.89,assignment:"CH₃"}],from:18.885,to:18.895},{signals:[{delta:57.72,assignment:"CH₂"}],from:57.714999999999996,to:57.725}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:20.83,assignment:"CH₃CO"}],from:20.825,to:20.834999999999997},{signals:[{delta:170.96,assignment:"CO"}],from:170.955,to:170.965},{signals:[{delta:60.56,assignment:"CH₂"}],from:60.555,to:60.565000000000005},{signals:[{delta:14.5,assignment:"CH₃"}],from:14.495,to:14.505}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:123.47,assignment:"CH₂"}],from:123.465,to:123.475}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:64.26,assignment:"CH₂"}],from:64.25500000000001,to:64.265}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["H grease"],smiles:"",ranges:[],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:132.22,assignment:"C"}],from:132.215,to:132.225},{signals:[{delta:16.86,assignment:"CH₃"}],from:16.855,to:16.865}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:14.34,assignment:"CH₃"}],from:14.334999999999999,to:14.345},{signals:[{delta:23.28,assignment:"CH₂(2,5)"}],from:23.275000000000002,to:23.285},{signals:[{delta:32.3,assignment:"CH₂(3,4)"}],from:32.294999999999995,to:32.305}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:2.01,assignment:"CH₃"}],from:2.005,to:2.0149999999999997}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:37.04,assignment:"CH₃"}],from:37.035,to:37.045}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:135.89,assignment:"CH(2)"}],from:135.885,to:135.89499999999998},{signals:[{delta:122.31,assignment:"CH(4,5)"}],from:122.305,to:122.315}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-5.33,assignment:"CH₄"}],from:-5.335,to:-5.325}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:49.77,assignment:"CH₃"}],from:49.765,to:49.775000000000006}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:63.21,assignment:"CH₃"}],from:63.205,to:63.215}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:14.29,assignment:"CH₃"}],from:14.284999999999998,to:14.295},{signals:[{delta:22.98,assignment:"CH₂(2,4)"}],from:22.975,to:22.985},{signals:[{delta:34.83,assignment:"CH₂(3)"}],from:34.824999999999996,to:34.835}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.68,assignment:"CH₃"}],from:16.675,to:16.685},{signals:[{delta:16.78,assignment:"CH₂"}],from:16.775000000000002,to:16.785}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.67,assignment:"CH₃"}],from:25.665000000000003,to:25.675},{signals:[{delta:63.85,assignment:"CH"}],from:63.845,to:63.855000000000004}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.42,assignment:"CH₃"}],from:19.415000000000003,to:19.425},{signals:[{delta:116.03,assignment:"CH₂"}],from:116.025,to:116.035},{signals:[{delta:134.34,assignment:"CH"}],from:134.335,to:134.345}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:150.67,assignment:"CH(2,6)"}],from:150.665,to:150.67499999999998},{signals:[{delta:124.57,assignment:"CH(3,5)"}],from:124.565,to:124.57499999999999},{signals:[{delta:136.56,assignment:"CH(4)"}],from:136.555,to:136.565}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:117.98,assignment:"CH(2,5)"}],from:117.97500000000001,to:117.985},{signals:[{delta:108.04,assignment:"CH(3,4)"}],from:108.03500000000001,to:108.045}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{delta:1.4,assignment:"CH₃"}],from:1.395,to:1.4049999999999998}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:68.07,assignment:"CH₂(2,5)"}],from:68.065,to:68.07499999999999},{signals:[{delta:26.15,assignment:"CH₂(3,4)"}],from:26.145,to:26.154999999999998}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:21.46,assignment:"CH₃"}],from:21.455000000000002,to:21.465},{signals:[{delta:138.48,assignment:"C(1)"}],from:138.475,to:138.48499999999999},{signals:[{delta:129.76,assignment:"CH(2,6)"}],from:129.755,to:129.765},{signals:[{delta:129.03,assignment:"CH(3,5)"}],from:129.025,to:129.035},{signals:[{delta:126.12,assignment:"CH(4)"}],from:126.11500000000001,to:126.125}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:12.49,assignment:"CH₃"}],from:12.485,to:12.495000000000001},{signals:[{delta:47.07,assignment:"CH₂"}],from:47.065,to:47.075}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:171.93,assignment:"CO"}],from:171.925,to:171.935},{signals:[{delta:20.95,assignment:"CH₃"}],from:20.945,to:20.955}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:206.31,assignment:"CO"}],from:206.305,to:206.315},{signals:[{delta:30.56,assignment:"CH₃"}],from:30.555,to:30.564999999999998}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:117.91,assignment:"CN"}],from:117.905,to:117.91499999999999},{signals:[{delta:1.03,assignment:"CH₃"}],from:1.0250000000000001,to:1.035}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:128.3,assignment:"CH"}],from:128.29500000000002,to:128.305}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:66.88,assignment:"(CH₃)₃C"}],from:66.875,to:66.88499999999999},{signals:[{delta:30.38,assignment:"(CH₃)₃C"}],from:30.375,to:30.384999999999998}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:124.21,assignment:"CO₂"}],from:124.205,to:124.21499999999999}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:192.63,assignment:"CS₂"}],from:192.625,to:192.635}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:95.44,assignment:"CCl₄"}],from:95.435,to:95.445}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:79.16,assignment:"CH"}],from:79.155,to:79.16499999999999}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:69.85,assignment:"CH₂"}],from:69.845,to:69.85499999999999}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:26.33,assignment:"CH₂"}],from:26.325,to:26.334999999999997}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:45.02,assignment:"CH₂"}],from:45.015,to:45.025000000000006}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:54.84,assignment:"CH₂"}],from:54.835,to:54.845000000000006}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.12,assignment:"CH₃"}],from:15.114999999999998,to:15.125},{signals:[{delta:62.05,assignment:"CH₂"}],from:62.044999999999995,to:62.055}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:57.98,assignment:"CH₃"}],from:57.974999999999994,to:57.985},{signals:[{delta:69.54,assignment:"CH₂"}],from:69.53500000000001,to:69.545},{signals:[{delta:71.25,assignment:"CH₂"}],from:71.245,to:71.255}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:162.29,assignment:"CH"}],from:162.285,to:162.295},{signals:[{delta:35.73,assignment:"CH₃"}],from:35.724999999999994,to:35.735},{signals:[{delta:30.73,assignment:"CH₃"}],from:30.725,to:30.735}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:66.36,assignment:"CH₂"}],from:66.355,to:66.365}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:58.03,assignment:"CH₃"}],from:58.025,to:58.035000000000004},{signals:[{delta:71.17,assignment:"CH₂"}],from:71.165,to:71.175}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:6.61,assignment:"CH₃"}],from:6.605,to:6.615}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.51,assignment:"CH₃"}],from:18.505000000000003,to:18.515},{signals:[{delta:56.07,assignment:"CH₂"}],from:56.065,to:56.075}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:20.68,assignment:"CH₃CO"}],from:20.675,to:20.685},{signals:[{delta:170.31,assignment:"CO"}],from:170.305,to:170.315},{signals:[{delta:59.74,assignment:"CH₂"}],from:59.735,to:59.745000000000005},{signals:[{delta:14.4,assignment:"CH₃"}],from:14.395,to:14.405000000000001}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:123.52,assignment:"CH₂"}],from:123.515,to:123.52499999999999}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:62.76,assignment:"CH₂"}],from:62.754999999999995,to:62.765}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["H grease"],smiles:"",ranges:[],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:131.1,assignment:"C"}],from:131.095,to:131.105},{signals:[{delta:16.6,assignment:"CH₃"}],from:16.595000000000002,to:16.605}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:13.88,assignment:"CH₃"}],from:13.875,to:13.885000000000002},{signals:[{delta:22.05,assignment:"CH₂(2,5)"}],from:22.045,to:22.055},{signals:[{delta:30.95,assignment:"CH₂(3,4)"}],from:30.945,to:30.955}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:1.96,assignment:"CH₃"}],from:1.955,to:1.9649999999999999}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:36.42,assignment:"CH₃"}],from:36.415,to:36.425000000000004}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:135.15,assignment:"CH(2)"}],from:135.145,to:135.155},{signals:[{delta:121.55,assignment:"CH(4,5)"}],from:121.545,to:121.55499999999999}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-4.01,assignment:"CH₄"}],from:-4.015,to:-4.005}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:48.59,assignment:"CH₃"}],from:48.585,to:48.595000000000006}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:63.28,assignment:"CH₃"}],from:63.275,to:63.285000000000004}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:13.28,assignment:"CH₃"}],from:13.274999999999999,to:13.285},{signals:[{delta:21.7,assignment:"CH₂(2,4)"}],from:21.695,to:21.705},{signals:[{delta:33.48,assignment:"CH₂(3)"}],from:33.474999999999994,to:33.485}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.34,assignment:"CH₃"}],from:16.335,to:16.345},{signals:[{delta:15.67,assignment:"CH₂"}],from:15.665,to:15.675}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.43,assignment:"CH₃"}],from:25.425,to:25.435},{signals:[{delta:64.92,assignment:"CH"}],from:64.915,to:64.925}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.2,assignment:"CH₃"}],from:19.195,to:19.205},{signals:[{delta:116.07,assignment:"CH₂"}],from:116.065,to:116.07499999999999},{signals:[{delta:133.55,assignment:"CH"}],from:133.54500000000002,to:133.555}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:149.58,assignment:"CH(2,6)"}],from:149.57500000000002,to:149.585},{signals:[{delta:123.84,assignment:"CH(3,5)"}],from:123.83500000000001,to:123.845},{signals:[{delta:136.05,assignment:"CH(4)"}],from:136.04500000000002,to:136.055}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:117.32,assignment:"CH(2,5)"}],from:117.315,to:117.32499999999999},{signals:[{delta:107.07,assignment:"CH(3,4)"}],from:107.065,to:107.07499999999999}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:46.51,assignment:"CH₂(2,5)"}],from:46.504999999999995,to:46.515},{signals:[{delta:25.26,assignment:"CH₂(3,4)"}],from:25.255000000000003,to:25.265}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["silicone grease"],smiles:"",ranges:[],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:67.03,assignment:"CH₂(2,5)"}],from:67.025,to:67.035},{signals:[{delta:25.14,assignment:"CH₂(3,4)"}],from:25.135,to:25.145}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:20.99,assignment:"CH₃"}],from:20.985,to:20.994999999999997},{signals:[{delta:137.35,assignment:"C(1)"}],from:137.345,to:137.355},{signals:[{delta:128.88,assignment:"CH(2,6)"}],from:128.875,to:128.885},{signals:[{delta:128.18,assignment:"CH(3,5)"}],from:128.175,to:128.185},{signals:[{delta:125.29,assignment:"CH(4)"}],from:125.28500000000001,to:125.295}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:11.74,assignment:"CH₃"}],from:11.735,to:11.745000000000001},{signals:[{delta:45.74,assignment:"CH₂"}],from:45.735,to:45.745000000000005}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:173.21,assignment:"CO"}],from:173.205,to:173.215},{signals:[{delta:20.73,assignment:"CH₃"}],from:20.725,to:20.735}],nucleus:"13C",solvent:"CD₃CN"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:207.43,assignment:"CO"}],from:207.425,to:207.435},{signals:[{delta:30.91,assignment:"CH₃"}],from:30.905,to:30.915}],nucleus:"13C",solvent:"CD₃CN"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:118.26,assignment:"CN"}],from:118.25500000000001,to:118.265},{signals:[{delta:1.79,assignment:"CH₃"}],from:1.7850000000000001,to:1.795}],nucleus:"13C",solvent:"CD₃CN"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:129.32,assignment:"CH"}],from:129.315,to:129.325}],nucleus:"13C",solvent:"CD₃CN"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:68.74,assignment:"(CH₃)₃C"}],from:68.735,to:68.74499999999999},{signals:[{delta:30.68,assignment:"(CH₃)₃C"}],from:30.675,to:30.685}],nucleus:"13C",solvent:"CD₃CN"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:125.89,assignment:"CO₂"}],from:125.885,to:125.895}],nucleus:"13C",solvent:"CD₃CN"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:193.6,assignment:"CS₂"}],from:193.595,to:193.605}],nucleus:"13C",solvent:"CD₃CN"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:96.68,assignment:"CCl₄"}],from:96.67500000000001,to:96.685}],nucleus:"13C",solvent:"CD₃CN"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:79.17,assignment:"CH"}],from:79.165,to:79.175}],nucleus:"13C",solvent:"CD₃CN"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:71.22,assignment:"CH₂"}],from:71.215,to:71.225}],nucleus:"13C",solvent:"CD₃CN"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:27.63,assignment:"CH₂"}],from:27.625,to:27.634999999999998}],nucleus:"13C",solvent:"CD₃CN"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:45.54,assignment:"CH₂"}],from:45.535,to:45.545}],nucleus:"13C",solvent:"CD₃CN"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:55.32,assignment:"CH₂"}],from:55.315,to:55.325}],nucleus:"13C",solvent:"CD₃CN"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.63,assignment:"CH₃"}],from:15.625,to:15.635000000000002},{signals:[{delta:66.32,assignment:"CH₂"}],from:66.315,to:66.32499999999999}],nucleus:"13C",solvent:"CD₃CN"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:58.9,assignment:"CH₃"}],from:58.894999999999996,to:58.905},{signals:[{delta:70.99,assignment:"CH₂"}],from:70.985,to:70.99499999999999},{signals:[{delta:72.63,assignment:"CH₂"}],from:72.625,to:72.63499999999999}],nucleus:"13C",solvent:"CD₃CN"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:163.31,assignment:"CH"}],from:163.305,to:163.315},{signals:[{delta:36.57,assignment:"CH₃"}],from:36.565,to:36.575},{signals:[{delta:31.32,assignment:"CH₃"}],from:31.315,to:31.325}],nucleus:"13C",solvent:"CD₃CN"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:67.72,assignment:"CH₂"}],from:67.715,to:67.725}],nucleus:"13C",solvent:"CD₃CN"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:58.89,assignment:"CH₃"}],from:58.885,to:58.895},{signals:[{delta:72.47,assignment:"CH₂"}],from:72.465,to:72.475}],nucleus:"13C",solvent:"CD₃CN"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:6.99,assignment:"CH₃"}],from:6.985,to:6.995}],nucleus:"13C",solvent:"CD₃CN"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.8,assignment:"CH₃"}],from:18.795,to:18.805},{signals:[{delta:57.96,assignment:"CH₂"}],from:57.955,to:57.965}],nucleus:"13C",solvent:"CD₃CN"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:21.16,assignment:"CH₃CO"}],from:21.155,to:21.165},{signals:[{delta:171.68,assignment:"CO"}],from:171.675,to:171.685},{signals:[{delta:60.98,assignment:"CH₂"}],from:60.974999999999994,to:60.985},{signals:[{delta:14.54,assignment:"CH₃"}],from:14.534999999999998,to:14.545}],nucleus:"13C",solvent:"CD₃CN"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:123.69,assignment:"CH₂"}],from:123.685,to:123.695}],nucleus:"13C",solvent:"CD₃CN"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:64.22,assignment:"CH₂"}],from:64.215,to:64.225}],nucleus:"13C",solvent:"CD₃CN"},{names:["H grease"],smiles:"",ranges:[],nucleus:"13C",solvent:"CD₃CN"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:132.61,assignment:"C"}],from:132.60500000000002,to:132.615},{signals:[{delta:16.94,assignment:"CH₃"}],from:16.935000000000002,to:16.945}],nucleus:"13C",solvent:"CD₃CN"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:14.43,assignment:"CH₃"}],from:14.424999999999999,to:14.435},{signals:[{delta:23.4,assignment:"CH₂(2,5)"}],from:23.395,to:23.404999999999998},{signals:[{delta:32.36,assignment:"CH₂(3,4)"}],from:32.355,to:32.365}],nucleus:"13C",solvent:"CD₃CN"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:2.07,assignment:"CH₃"}],from:2.065,to:2.0749999999999997}],nucleus:"13C",solvent:"CD₃CN"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:37.1,assignment:"CH₃"}],from:37.095,to:37.105000000000004}],nucleus:"13C",solvent:"CD₃CN"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:136.33,assignment:"CH(2)"}],from:136.32500000000002,to:136.335},{signals:[{delta:122.78,assignment:"CH(4,5)"}],from:122.775,to:122.785}],nucleus:"13C",solvent:"CD₃CN"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-4.61,assignment:"CH₄"}],from:-4.615,to:-4.605}],nucleus:"13C",solvent:"CD₃CN"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:49.9,assignment:"CH₃"}],from:49.894999999999996,to:49.905}],nucleus:"13C",solvent:"CD₃CN"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:63.66,assignment:"CH₃"}],from:63.654999999999994,to:63.665}],nucleus:"13C",solvent:"CD₃CN"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:14.37,assignment:"CH₃"}],from:14.364999999999998,to:14.375},{signals:[{delta:23.08,assignment:"CH₂(2,4)"}],from:23.075,to:23.084999999999997},{signals:[{delta:34.89,assignment:"CH₂(3)"}],from:34.885,to:34.895}],nucleus:"13C",solvent:"CD₃CN"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.73,assignment:"CH₃"}],from:16.725,to:16.735},{signals:[{delta:16.91,assignment:"CH₂"}],from:16.905,to:16.915}],nucleus:"13C",solvent:"CD₃CN"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.55,assignment:"CH₃"}],from:25.545,to:25.555},{signals:[{delta:64.3,assignment:"CH"}],from:64.295,to:64.30499999999999}],nucleus:"13C",solvent:"CD₃CN"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.48,assignment:"CH₃"}],from:19.475,to:19.485},{signals:[{delta:116.12,assignment:"CH₂"}],from:116.11500000000001,to:116.125},{signals:[{delta:134.78,assignment:"CH"}],from:134.775,to:134.785}],nucleus:"13C",solvent:"CD₃CN"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:150.76,assignment:"CH(2,6)"}],from:150.755,to:150.765},{signals:[{delta:127.76,assignment:"CH(3,5)"}],from:127.75500000000001,to:127.765},{signals:[{delta:136.89,assignment:"CH(4)"}],from:136.885,to:136.89499999999998}],nucleus:"13C",solvent:"CD₃CN"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:118.47,assignment:"CH(2,5)"}],from:118.465,to:118.475},{signals:[{delta:108.31,assignment:"CH(3,4)"}],from:108.305,to:108.315}],nucleus:"13C",solvent:"CD₃CN"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:47.57,assignment:"CH₂(2,5)"}],from:47.565,to:47.575},{signals:[{delta:26.34,assignment:"CH₂(3,4)"}],from:26.335,to:26.345}],nucleus:"13C",solvent:"CD₃CN"},{names:["silicone grease"],smiles:"",ranges:[],nucleus:"13C",solvent:"CD₃CN"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:68.33,assignment:"CH₂(2,5)"}],from:68.325,to:68.335},{signals:[{delta:26.27,assignment:"CH₂(3,4)"}],from:26.265,to:26.275}],nucleus:"13C",solvent:"CD₃CN"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:21.5,assignment:"CH₃"}],from:21.495,to:21.505},{signals:[{delta:138.9,assignment:"C(1)"}],from:138.895,to:138.905},{signals:[{delta:129.94,assignment:"CH(2,6)"}],from:129.935,to:129.945},{signals:[{delta:129.23,assignment:"CH(3,5)"}],from:129.225,to:129.23499999999999},{signals:[{delta:126.28,assignment:"CH(4)"}],from:126.275,to:126.285}],nucleus:"13C",solvent:"CD₃CN"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:12.38,assignment:"CH₃"}],from:12.375,to:12.385000000000002},{signals:[{delta:47.1,assignment:"CH₂"}],from:47.095,to:47.105000000000004}],nucleus:"13C",solvent:"CD₃CN"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:177.96,assignment:"CO"}],from:177.955,to:177.965},{signals:[{delta:20.91,assignment:"CH₃"}],from:20.905,to:20.915}],nucleus:"13C",solvent:"TFE-d₃"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:32.35,assignment:"CO"}],from:32.345,to:32.355000000000004},{signals:[{delta:214.98,assignment:"CH₃"}],from:214.975,to:214.98499999999999}],nucleus:"13C",solvent:"TFE-d₃"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:118.95,assignment:"CN"}],from:118.94500000000001,to:118.955},{signals:[{delta:1,assignment:"CH₃"}],from:.995,to:1.005}],nucleus:"13C",solvent:"TFE-d₃"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:129.84,assignment:"CH"}],from:129.835,to:129.845}],nucleus:"13C",solvent:"TFE-d₃"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:72.35,assignment:"(CH₃)₃C"}],from:72.345,to:72.35499999999999},{signals:[{delta:31.07,assignment:"(CH₃)₃C"}],from:31.065,to:31.075}],nucleus:"13C",solvent:"TFE-d₃"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:126.92,assignment:"CO₂"}],from:126.915,to:126.925}],nucleus:"13C",solvent:"TFE-d₃"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:196.26,assignment:"CS₂"}],from:196.255,to:196.265}],nucleus:"13C",solvent:"TFE-d₃"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:97.74,assignment:"CCl₄"}],from:97.735,to:97.74499999999999}],nucleus:"13C",solvent:"TFE-d₃"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:78.83,assignment:"CH"}],from:78.825,to:78.835}],nucleus:"13C",solvent:"TFE-d₃"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:70.8,assignment:"CH₂"}],from:70.795,to:70.80499999999999}],nucleus:"13C",solvent:"TFE-d₃"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:28.34,assignment:"CH₂"}],from:28.335,to:28.345}],nucleus:"13C",solvent:"TFE-d₃"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:45.28,assignment:"CH₂"}],from:45.275,to:45.285000000000004}],nucleus:"13C",solvent:"TFE-d₃"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:54.46,assignment:"CH₂"}],from:54.455,to:54.465}],nucleus:"13C",solvent:"TFE-d₃"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.33,assignment:"CH₃"}],from:15.325,to:15.335},{signals:[{delta:67.55,assignment:"CH₂"}],from:67.545,to:67.55499999999999}],nucleus:"13C",solvent:"TFE-d₃"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:59.4,assignment:"CH₃"}],from:59.394999999999996,to:59.405},{signals:[{delta:73.05,assignment:"CH₂"}],from:73.045,to:73.05499999999999},{signals:[{delta:71.33,assignment:"CH₂"}],from:71.325,to:71.335}],nucleus:"13C",solvent:"TFE-d₃"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:166.01,assignment:"CH"}],from:166.005,to:166.015},{signals:[{delta:37.76,assignment:"CH₃"}],from:37.754999999999995,to:37.765},{signals:[{delta:30.96,assignment:"CH₃"}],from:30.955000000000002,to:30.965}],nucleus:"13C",solvent:"TFE-d₃"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:68.52,assignment:"CH₂"}],from:68.515,to:68.52499999999999}],nucleus:"13C",solvent:"TFE-d₃"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:59.52,assignment:"CH₃"}],from:59.515,to:59.525000000000006},{signals:[{delta:72.87,assignment:"CH₂"}],from:72.86500000000001,to:72.875}],nucleus:"13C",solvent:"TFE-d₃"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:7.01,assignment:"CH₃"}],from:7.005,to:7.015}],nucleus:"13C",solvent:"TFE-d₃"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.11,assignment:"CH₃"}],from:18.105,to:18.115},{signals:[{delta:59.68,assignment:"CH₂"}],from:59.675,to:59.685}],nucleus:"13C",solvent:"TFE-d₃"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:21.18,assignment:"CH₃CO"}],from:21.175,to:21.185},{signals:[{delta:175.55,assignment:"CO"}],from:175.54500000000002,to:175.555},{signals:[{delta:62.7,assignment:"CH₂"}],from:62.695,to:62.705000000000005},{signals:[{delta:14.36,assignment:"CH₃"}],from:14.354999999999999,to:14.365}],nucleus:"13C",solvent:"TFE-d₃"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:124.08,assignment:"CH₂"}],from:124.075,to:124.085}],nucleus:"13C",solvent:"TFE-d₃"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:64.87,assignment:"CH₂"}],from:64.86500000000001,to:64.875}],nucleus:"13C",solvent:"TFE-d₃"},{names:["H grease"],smiles:"",ranges:[],nucleus:"13C",solvent:"TFE-d₃"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:134.04,assignment:"C"}],from:134.035,to:134.045},{signals:[{delta:17.04,assignment:"CH₃"}],from:17.035,to:17.044999999999998}],nucleus:"13C",solvent:"TFE-d₃"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:14.63,assignment:"CH₃"}],from:14.625,to:14.635000000000002},{signals:[{delta:24.06,assignment:"CH₂(2,5)"}],from:24.055,to:24.064999999999998},{signals:[{delta:33.17,assignment:"CH₂(3,4)"}],from:33.165,to:33.175000000000004}],nucleus:"13C",solvent:"TFE-d₃"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:2.09,assignment:"CH₃"}],from:2.085,to:2.0949999999999998}],nucleus:"13C",solvent:"TFE-d₃"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:37.21,assignment:"CH₃"}],from:37.205,to:37.215}],nucleus:"13C",solvent:"TFE-d₃"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:136.58,assignment:"CH(2)"}],from:136.57500000000002,to:136.585},{signals:[{delta:122.93,assignment:"CH(4,5)"}],from:122.92500000000001,to:122.935}],nucleus:"13C",solvent:"TFE-d₃"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-5.88,assignment:"CH₄"}],from:-5.885,to:-5.875}],nucleus:"13C",solvent:"TFE-d₃"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:50.67,assignment:"CH₃"}],from:50.665,to:50.675000000000004}],nucleus:"13C",solvent:"TFE-d₃"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:63.17,assignment:"CH₃"}],from:63.165,to:63.175000000000004}],nucleus:"13C",solvent:"TFE-d₃"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:14.54,assignment:"CH₃"}],from:14.534999999999998,to:14.545},{signals:[{delta:23.75,assignment:"CH₂(2,4)"}],from:23.745,to:23.755},{signals:[{delta:35.76,assignment:"CH₂(3)"}],from:35.754999999999995,to:35.765}],nucleus:"13C",solvent:"TFE-d₃"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.93,assignment:"CH₃"}],from:16.925,to:16.935},{signals:[{delta:17.46,assignment:"CH₂"}],from:17.455000000000002,to:17.465}],nucleus:"13C",solvent:"TFE-d₃"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.21,assignment:"CH₃"}],from:25.205000000000002,to:25.215},{signals:[{delta:66.69,assignment:"CH"}],from:66.685,to:66.695}],nucleus:"13C",solvent:"TFE-d₃"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.63,assignment:"CH₃"}],from:19.625,to:19.634999999999998},{signals:[{delta:116.38,assignment:"CH₂"}],from:116.375,to:116.38499999999999},{signals:[{delta:136,assignment:"CH"}],from:135.995,to:136.005}],nucleus:"13C",solvent:"TFE-d₃"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:149.76,assignment:"CH(2,6)"}],from:149.755,to:149.765},{signals:[{delta:126.27,assignment:"CH(3,5)"}],from:126.265,to:126.27499999999999},{signals:[{delta:139.62,assignment:"CH(4)"}],from:139.615,to:139.625}],nucleus:"13C",solvent:"TFE-d₃"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:119.61,assignment:"CH(2,5)"}],from:119.605,to:119.615},{signals:[{delta:108.85,assignment:"CH(3,4)"}],from:108.845,to:108.85499999999999}],nucleus:"13C",solvent:"TFE-d₃"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:47.43,assignment:"CH₂(2,5)"}],from:47.425,to:47.435},{signals:[{delta:25.73,assignment:"CH₂(3,4)"}],from:25.725,to:25.735}],nucleus:"13C",solvent:"TFE-d₃"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{delta:2.87,assignment:"CH₃"}],from:2.865,to:2.875}],nucleus:"13C",solvent:"TFE-d₃"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:69.53,assignment:"CH₂(2,5)"}],from:69.525,to:69.535},{signals:[{delta:26.69,assignment:"CH₂(3,4)"}],from:26.685000000000002,to:26.695}],nucleus:"13C",solvent:"TFE-d₃"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:21.62,assignment:"CH₃"}],from:21.615000000000002,to:21.625},{signals:[{delta:139.92,assignment:"C(1)"}],from:139.915,to:139.92499999999998},{signals:[{delta:130.58,assignment:"CH(2,6)"}],from:130.57500000000002,to:130.585},{signals:[{delta:129.79,assignment:"CH(3,5)"}],from:129.785,to:129.795},{signals:[{delta:126.82,assignment:"CH(4)"}],from:126.815,to:126.82499999999999}],nucleus:"13C",solvent:"TFE-d₃"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:9.51,assignment:"CH₃"}],from:9.504999999999999,to:9.515},{signals:[{delta:48.45,assignment:"CH₂"}],from:48.445,to:48.455000000000005}],nucleus:"13C",solvent:"TFE-d₃"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:175.11,assignment:"CO"}],from:175.10500000000002,to:175.115},{signals:[{delta:20.56,assignment:"CH₃"}],from:20.555,to:20.564999999999998}],nucleus:"13C",solvent:"CD₃OD"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:209.67,assignment:"CO"}],from:209.665,to:209.67499999999998},{signals:[{delta:30.67,assignment:"CH₃"}],from:30.665000000000003,to:30.675}],nucleus:"13C",solvent:"CD₃OD"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:118.06,assignment:"CN"}],from:118.055,to:118.065},{signals:[{delta:.85,assignment:"CH₃"}],from:.845,to:.855}],nucleus:"13C",solvent:"CD₃OD"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:129.34,assignment:"CH"}],from:129.335,to:129.345}],nucleus:"13C",solvent:"CD₃OD"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:69.4,assignment:"(CH₃)₃C"}],from:69.39500000000001,to:69.405},{signals:[{delta:30.91,assignment:"(CH₃)₃C"}],from:30.905,to:30.915}],nucleus:"13C",solvent:"CD₃OD"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:126.31,assignment:"CO₂"}],from:126.305,to:126.315}],nucleus:"13C",solvent:"CD₃OD"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:193.82,assignment:"CS₂"}],from:193.815,to:193.825}],nucleus:"13C",solvent:"CD₃OD"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:97.21,assignment:"CCl₄"}],from:97.205,to:97.21499999999999}],nucleus:"13C",solvent:"CD₃OD"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:79.44,assignment:"CH"}],from:79.435,to:79.445}],nucleus:"13C",solvent:"CD₃OD"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:71.47,assignment:"CH₂"}],from:71.465,to:71.475}],nucleus:"13C",solvent:"CD₃OD"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:27.96,assignment:"CH₂"}],from:27.955000000000002,to:27.965}],nucleus:"13C",solvent:"CD₃OD"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:45.11,assignment:"CH₂"}],from:45.105,to:45.115}],nucleus:"13C",solvent:"CD₃OD"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:54.78,assignment:"CH₂"}],from:54.775,to:54.785000000000004}],nucleus:"13C",solvent:"CD₃OD"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.46,assignment:"CH₃"}],from:15.455,to:15.465000000000002},{signals:[{delta:66.88,assignment:"CH₂"}],from:66.875,to:66.88499999999999}],nucleus:"13C",solvent:"CD₃OD"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:59.06,assignment:"CH₃"}],from:59.055,to:59.065000000000005},{signals:[{delta:71.33,assignment:"CH₂"}],from:71.325,to:71.335},{signals:[{delta:72.92,assignment:"CH₂"}],from:72.915,to:72.925}],nucleus:"13C",solvent:"CD₃OD"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:164.73,assignment:"CH"}],from:164.725,to:164.73499999999999},{signals:[{delta:36.89,assignment:"CH₃"}],from:36.885,to:36.895},{signals:[{delta:31.61,assignment:"CH₃"}],from:31.605,to:31.615}],nucleus:"13C",solvent:"CD₃OD"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:68.11,assignment:"CH₂"}],from:68.105,to:68.115}],nucleus:"13C",solvent:"CD₃OD"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:59.06,assignment:"CH₃"}],from:59.055,to:59.065000000000005},{signals:[{delta:72.72,assignment:"CH₂"}],from:72.715,to:72.725}],nucleus:"13C",solvent:"CD₃OD"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:6.98,assignment:"CH₃"}],from:6.9750000000000005,to:6.985}],nucleus:"13C",solvent:"CD₃OD"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.4,assignment:"CH₃"}],from:18.395,to:18.404999999999998},{signals:[{delta:58.26,assignment:"CH₂"}],from:58.254999999999995,to:58.265}],nucleus:"13C",solvent:"CD₃OD"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:20.88,assignment:"CH₃CO"}],from:20.875,to:20.884999999999998},{signals:[{delta:172.89,assignment:"CO"}],from:172.885,to:172.89499999999998},{signals:[{delta:61.5,assignment:"CH₂"}],from:61.495,to:61.505},{signals:[{delta:14.49,assignment:"CH₃"}],from:14.485,to:14.495000000000001}],nucleus:"13C",solvent:"CD₃OD"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:123.46,assignment:"CH₂"}],from:123.455,to:123.46499999999999}],nucleus:"13C",solvent:"CD₃OD"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:64.3,assignment:"CH₂"}],from:64.295,to:64.30499999999999}],nucleus:"13C",solvent:"CD₃OD"},{names:["H grease"],smiles:"",ranges:[],nucleus:"13C",solvent:"CD₃OD"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:132.53,assignment:"C"}],from:132.525,to:132.535},{signals:[{delta:16.9,assignment:"CH₃"}],from:16.895,to:16.904999999999998}],nucleus:"13C",solvent:"CD₃OD"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:14.45,assignment:"CH₃"}],from:14.444999999999999,to:14.455},{signals:[{delta:23.68,assignment:"CH₂(2,5)"}],from:23.675,to:23.685},{signals:[{delta:32.73,assignment:"CH₂(3,4)"}],from:32.724999999999994,to:32.735}],nucleus:"13C",solvent:"CD₃OD"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:1.99,assignment:"CH₃"}],from:1.985,to:1.9949999999999999}],nucleus:"13C",solvent:"CD₃OD"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:37,assignment:"CH₃"}],from:36.995,to:37.005}],nucleus:"13C",solvent:"CD₃OD"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:136.31,assignment:"CH(2)"}],from:136.305,to:136.315},{signals:[{delta:122.6,assignment:"CH(4,5)"}],from:122.595,to:122.60499999999999}],nucleus:"13C",solvent:"CD₃OD"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-4.9,assignment:"CH₄"}],from:-4.905,to:-4.8950000000000005}],nucleus:"13C",solvent:"CD₃OD"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:49.86,assignment:"CH₃"}],from:49.855,to:49.865}],nucleus:"13C",solvent:"CD₃OD"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:63.08,assignment:"CH₃"}],from:63.074999999999996,to:63.085}],nucleus:"13C",solvent:"CD₃OD"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:14.39,assignment:"CH₃"}],from:14.385,to:14.395000000000001},{signals:[{delta:23.38,assignment:"CH₂(2,4)"}],from:23.375,to:23.384999999999998},{signals:[{delta:35.3,assignment:"CH₂(3)"}],from:35.294999999999995,to:35.305}],nucleus:"13C",solvent:"CD₃OD"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.8,assignment:"CH₃"}],from:16.795,to:16.805},{signals:[{delta:17.19,assignment:"CH₂"}],from:17.185000000000002,to:17.195}],nucleus:"13C",solvent:"CD₃OD"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.27,assignment:"CH₃"}],from:25.265,to:25.275},{signals:[{delta:64.71,assignment:"CH"}],from:64.705,to:64.71499999999999}],nucleus:"13C",solvent:"CD₃OD"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.5,assignment:"CH₃"}],from:19.495,to:19.505},{signals:[{delta:116.04,assignment:"CH₂"}],from:116.03500000000001,to:116.045},{signals:[{delta:134.61,assignment:"CH"}],from:134.60500000000002,to:134.615}],nucleus:"13C",solvent:"CD₃OD"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:150.07,assignment:"CH(2,6)"}],from:150.065,to:150.075},{signals:[{delta:125.53,assignment:"CH(3,5)"}],from:125.525,to:125.535},{signals:[{delta:138.35,assignment:"CH(4)"}],from:138.345,to:138.355}],nucleus:"13C",solvent:"CD₃OD"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:118.28,assignment:"CH(2,5)"}],from:118.275,to:118.285},{signals:[{delta:108.11,assignment:"CH(3,4)"}],from:108.105,to:108.115}],nucleus:"13C",solvent:"CD₃OD"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:47.23,assignment:"CH₂(2,5)"}],from:47.224999999999994,to:47.235},{signals:[{delta:26.29,assignment:"CH₂(3,4)"}],from:26.285,to:26.294999999999998}],nucleus:"13C",solvent:"CD₃OD"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{delta:2.1,assignment:"CH₃"}],from:2.095,to:2.105}],nucleus:"13C",solvent:"CD₃OD"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:68.83,assignment:"CH₂(2,5)"}],from:68.825,to:68.835},{signals:[{delta:26.48,assignment:"CH₂(3,4)"}],from:26.475,to:26.485}],nucleus:"13C",solvent:"CD₃OD"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:21.5,assignment:"CH₃"}],from:21.495,to:21.505},{signals:[{delta:138.85,assignment:"C(1)"}],from:138.845,to:138.855},{signals:[{delta:129.91,assignment:"CH(2,6)"}],from:129.905,to:129.915},{signals:[{delta:129.2,assignment:"CH(3,5)"}],from:129.195,to:129.20499999999998},{signals:[{delta:126.29,assignment:"CH(4)"}],from:126.28500000000001,to:126.295}],nucleus:"13C",solvent:"CD₃OD"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:11.09,assignment:"CH₃"}],from:11.084999999999999,to:11.095},{signals:[{delta:46.96,assignment:"CH₂"}],from:46.955,to:46.965}],nucleus:"13C",solvent:"CD₃OD"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:177.21,assignment:"CO"}],from:177.205,to:177.215},{signals:[{delta:21.03,assignment:"CH₃"}],from:21.025000000000002,to:21.035}],nucleus:"13C",solvent:"D₂O"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:215.94,assignment:"CO"}],from:215.935,to:215.945},{signals:[{delta:30.89,assignment:"CH₃"}],from:30.885,to:30.895}],nucleus:"13C",solvent:"D₂O"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:119.68,assignment:"CN"}],from:119.67500000000001,to:119.685},{signals:[{delta:1.47,assignment:"CH₃"}],from:1.465,to:1.4749999999999999}],nucleus:"13C",solvent:"D₂O"},{names:["benzene"],smiles:"c1ccccc1",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:70.36,assignment:"(CH₃)₃C"}],from:70.355,to:70.365},{signals:[{delta:30.29,assignment:"(CH₃)₃C"}],from:30.285,to:30.294999999999998}],nucleus:"13C",solvent:"D₂O"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:197.25,assignment:"CS₂"}],from:197.245,to:197.255}],nucleus:"13C",solvent:"D₂O"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:96.73,assignment:"CCl₄"}],from:96.72500000000001,to:96.735}],nucleus:"13C",solvent:"D₂O"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:70.14,assignment:"CH₂"}],from:70.135,to:70.145}],nucleus:"13C",solvent:"D₂O"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:14.77,assignment:"CH₃"}],from:14.764999999999999,to:14.775},{signals:[{delta:66.42,assignment:"CH₂"}],from:66.415,to:66.425}],nucleus:"13C",solvent:"D₂O"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:58.67,assignment:"CH₃"}],from:58.665,to:58.675000000000004},{signals:[{delta:70.05,assignment:"CH₂"}],from:70.045,to:70.05499999999999},{signals:[{delta:71.63,assignment:"CH₂"}],from:71.625,to:71.63499999999999}],nucleus:"13C",solvent:"D₂O"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:165.53,assignment:"CH"}],from:165.525,to:165.535},{signals:[{delta:37.54,assignment:"CH₃"}],from:37.535,to:37.545},{signals:[{delta:32.03,assignment:"CH₃"}],from:32.025,to:32.035000000000004}],nucleus:"13C",solvent:"D₂O"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:67.19,assignment:"CH₂"}],from:67.185,to:67.195}],nucleus:"13C",solvent:"D₂O"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:58.67,assignment:"CH₃"}],from:58.665,to:58.675000000000004},{signals:[{delta:71.49,assignment:"CH₂"}],from:71.485,to:71.49499999999999}],nucleus:"13C",solvent:"D₂O"},{names:["ethane"],smiles:"CC",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:17.47,assignment:"CH₃"}],from:17.465,to:17.474999999999998},{signals:[{delta:58.05,assignment:"CH₂"}],from:58.044999999999995,to:58.055}],nucleus:"13C",solvent:"D₂O"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:21.15,assignment:"CH₃CO"}],from:21.145,to:21.154999999999998},{signals:[{delta:175.26,assignment:"CO"}],from:175.255,to:175.265},{signals:[{delta:62.32,assignment:"CH₂"}],from:62.315,to:62.325},{signals:[{delta:13.92,assignment:"CH₃"}],from:13.915,to:13.925}],nucleus:"13C",solvent:"D₂O"},{names:["ethylene"],smiles:"C=C",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:63.17,assignment:"CH₂"}],from:63.165,to:63.175000000000004}],nucleus:"13C",solvent:"D₂O"},{names:["H grease"],smiles:"",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:2.31,assignment:"CH₃"}],from:2.305,to:2.315}],nucleus:"13C",solvent:"D₂O"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:36.46,assignment:"CH₃"}],from:36.455,to:36.465}],nucleus:"13C",solvent:"D₂O"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:136.65,assignment:"CH(2)"}],from:136.645,to:136.655},{signals:[{delta:122.43,assignment:"CH(4,5)"}],from:122.42500000000001,to:122.435}],nucleus:"13C",solvent:"D₂O"},{names:["methane"],smiles:"C",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:49.5,assignment:"CH₃"}],from:49.495,to:49.505}],nucleus:"13C",solvent:"D₂O"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:63.22,assignment:"CH₃"}],from:63.214999999999996,to:63.225}],nucleus:"13C",solvent:"D₂O"},{names:["n-pentane"],smiles:"CCCCC",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["propane"],smiles:"CCC",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:24.38,assignment:"CH₃"}],from:24.375,to:24.384999999999998},{signals:[{delta:64.88,assignment:"CH"}],from:64.875,to:64.88499999999999}],nucleus:"13C",solvent:"D₂O"},{names:["propylene"],smiles:"CC=C",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:149.18,assignment:"CH(2,6)"}],from:149.175,to:149.185},{signals:[{delta:125.12,assignment:"CH(3,5)"}],from:125.11500000000001,to:125.125},{signals:[{delta:138.27,assignment:"CH(4)"}],from:138.26500000000001,to:138.275}],nucleus:"13C",solvent:"D₂O"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:119.06,assignment:"CH(2,5)"}],from:119.055,to:119.065},{signals:[{delta:107.83,assignment:"CH(3,4)"}],from:107.825,to:107.835}],nucleus:"13C",solvent:"D₂O"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:46.83,assignment:"CH₂(2,5)"}],from:46.824999999999996,to:46.835},{signals:[{delta:25.86,assignment:"CH₂(3,4)"}],from:25.855,to:25.865}],nucleus:"13C",solvent:"D₂O"},{names:["silicone grease"],smiles:"",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:68.68,assignment:"CH₂(2,5)"}],from:68.67500000000001,to:68.685},{signals:[{delta:25.67,assignment:"CH₂(3,4)"}],from:25.665000000000003,to:25.675}],nucleus:"13C",solvent:"D₂O"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:9.07,assignment:"CH₃"}],from:9.065,to:9.075000000000001},{signals:[{delta:47.19,assignment:"CH₂"}],from:47.184999999999995,to:47.195}],nucleus:"13C",solvent:"D₂O"}],protonImpurities=[{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:2.46,multiplicity:"s",assignment:"OH"}],integration:2,from:2.455,to:2.465}],nucleus:"1H",solvent:"THF-d₈"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:1.89,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.885,to:1.8949999999999998}],nucleus:"1H",solvent:"THF-d₈"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:2.05,multiplicity:"s",assignment:"CH₃"}],integration:6,from:2.045,to:2.0549999999999997}],nucleus:"1H",solvent:"THF-d₈"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:1.95,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.945,to:1.9549999999999998}],nucleus:"1H",solvent:"THF-d₈"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.31,multiplicity:"s",assignment:"CH"}],integration:6,from:7.305,to:7.3149999999999995}],nucleus:"1H",solvent:"THF-d₈"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.15,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.145,to:1.1549999999999998},{signals:[{js:[],delta:3.16,multiplicity:"s",assignment:"OH"}],integration:1,from:3.1550000000000002,to:3.165}],nucleus:"1H",solvent:"THF-d₈"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:7.89,multiplicity:"s",assignment:"CH"}],integration:1,from:7.885,to:7.895}],nucleus:"1H",solvent:"THF-d₈"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.57,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.565,to:3.5749999999999997}],nucleus:"1H",solvent:"THF-d₈"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.44,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.435,to:1.4449999999999998}],nucleus:"1H",solvent:"THF-d₈"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:3.77,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.765,to:3.775}],nucleus:"1H",solvent:"THF-d₈"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:5.51,multiplicity:"s",assignment:"CH₂"}],integration:2,from:5.505,to:5.515}],nucleus:"1H",solvent:"THF-d₈"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.12,assignment:"CH₃"}],integration:6,from:1.0975000000000001,to:1.1425},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.38,assignment:"CH₂"}],integration:4,from:3.34875,to:3.41125}],nucleus:"1H",solvent:"THF-d₈"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.43,assignment:"CH₂",multiplicity:"m"}],integration:4,from:3.4050000000000002,to:3.455},{signals:[{js:[],delta:3.53,assignment:"CH₂",multiplicity:"m"}],integration:4,from:3.505,to:3.5549999999999997},{signals:[{js:[],delta:3.28,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.275,to:3.2849999999999997}],nucleus:"1H",solvent:"THF-d₈"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.91,multiplicity:"s",assignment:"CH"}],integration:1,from:7.905,to:7.915},{signals:[{js:[],delta:2.88,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.875,to:2.885},{signals:[{js:[],delta:2.76,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.755,to:2.7649999999999997}],nucleus:"1H",solvent:"THF-d₈"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.56,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.555,to:3.565}],nucleus:"1H",solvent:"THF-d₈"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.28,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.275,to:3.2849999999999997},{signals:[{js:[],delta:3.43,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.4250000000000003,to:3.435}],nucleus:"1H",solvent:"THF-d₈"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.85,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.845,to:.855}],nucleus:"1H",solvent:"THF-d₈"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.1,assignment:"CH₃"}],integration:3,from:1.0775000000000001,to:1.1225},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.51,assignment:"CH₂"}],integration:2,from:3.47875,to:3.54125},{signals:[{js:[],delta:3.3,multiplicity:"s",assignment:"OH"}],integration:1,from:3.295,to:3.3049999999999997}],nucleus:"1H",solvent:"THF-d₈"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:1.94,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:1.935,to:1.9449999999999998},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:4.04,assignment:"CH₂CH₃"}],integration:2,from:4.00875,to:4.07125},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.19,assignment:"CH₂CH₃"}],integration:3,from:1.1675,to:1.2125}],nucleus:"1H",solvent:"THF-d₈"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.36,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.355,to:5.365}],nucleus:"1H",solvent:"THF-d₈"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.48,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.475,to:3.485}],nucleus:"1H",solvent:"THF-d₈"},{names:["H greaseᶠ"],smiles:"",ranges:[{signals:[],integration:6,from:.85,to:.91,multiplicity:"m"},{signals:[{js:[],delta:1.29,multiplicity:"br s",assignment:"CH₂"}],integration:10,from:1.27625,to:1.30375}],nucleus:"1H",solvent:"THF-d₈"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.18,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.1750000000000003,to:2.185}],nucleus:"1H",solvent:"THF-d₈"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.89,assignment:"CH₃"}],integration:6,from:.8675,to:.9125},{signals:[{js:[],delta:1.29,assignment:"CH₂",multiplicity:"m"}],integration:8,from:1.2650000000000001,to:1.315}],nucleus:"1H",solvent:"THF-d₈"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.07,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.065,to:.07500000000000001}],nucleus:"1H",solvent:"THF-d₈"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.58,assignment:"CH₃"}],integration:18,from:2.563125,to:2.5968750000000003}],nucleus:"1H",solvent:"THF-d₈"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.55,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.545,to:4.555}],nucleus:"1H",solvent:"THF-d₈"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.48,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.4750000000000005,to:7.485},{signals:[{js:[],delta:6.94,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:6.9350000000000005,to:6.945}],nucleus:"1H",solvent:"THF-d₈"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.19,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.185,to:.195}],nucleus:"1H",solvent:"THF-d₈"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.27,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.265,to:3.275},{signals:[{js:[],delta:3.02,multiplicity:"s",assignment:"OH"}],integration:1,from:3.015,to:3.025}],nucleus:"1H",solvent:"THF-d₈"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:4.31,multiplicity:"s",assignment:"CH₃"}],integration:3,from:4.305,to:4.3149999999999995}],nucleus:"1H",solvent:"THF-d₈"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.89,assignment:"CH₃"}],integration:6,from:.8675,to:.9125},{signals:[{js:[],delta:1.31,assignment:"CH₂",multiplicity:"m"}],integration:6,from:1.2850000000000001,to:1.335}],nucleus:"1H",solvent:"THF-d₈"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.9,assignment:"CH₃"}],integration:6,from:.87675,to:.92325},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.33,assignment:"CH₂"}],integration:2,from:1.27025,to:1.38975}],nucleus:"1H",solvent:"THF-d₈"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:1.08,assignment:"CH₃"}],integration:6,from:1.0675000000000001,to:1.0925},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:3.82,assignment:"CH"}],integration:1,from:3.77,to:3.8699999999999997}],nucleus:"1H",solvent:"THF-d₈"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.69,assignment:"CH₃"}],integration:3,from:1.67325,to:1.70675},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.89,assignment:"CH₂(1)"}],integration:1,from:4.8725,to:4.9075},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:4.99,assignment:"CH₂(2)"}],integration:1,from:4.96375,to:5.01625},{signals:[{js:[],delta:5.79,assignment:"CH",multiplicity:"m"}],integration:1,from:5.765,to:5.815}],nucleus:"1H",solvent:"THF-d₈"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.54,assignment:"CH(2,6)",multiplicity:"m"}],integration:2,from:8.514999999999999,to:8.565},{signals:[{js:[],delta:7.25,assignment:"CH(3,5)",multiplicity:"m"}],integration:2,from:7.225,to:7.275},{signals:[{js:[],delta:7.65,assignment:"CH(4)",multiplicity:"m"}],integration:1,from:7.625,to:7.675000000000001}],nucleus:"1H",solvent:"THF-d₈"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:9.96,assignment:"NH",multiplicity:"br t"}],integration:1,from:9.955,to:9.965000000000002},{signals:[{js:[],delta:6.66,assignment:"CH(2,5)",multiplicity:"m"}],integration:2,from:6.635,to:6.6850000000000005},{signals:[{js:[],delta:6.02,assignment:"CH(3,4)",multiplicity:"m"}],integration:2,from:5.994999999999999,to:6.045}],nucleus:"1H",solvent:"THF-d₈"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:2.75,assignment:"CH₂(2,5)",multiplicity:"m"}],integration:4,from:2.725,to:2.775},{signals:[{js:[],delta:1.59,assignment:"CH₂(3,4)",multiplicity:"m"}],integration:4,from:1.5650000000000002,to:1.615}],nucleus:"1H",solvent:"THF-d₈"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:.11,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.105,to:.115}],nucleus:"1H",solvent:"THF-d₈"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.62,assignment:"CH₂(2,5)",multiplicity:"m"}],integration:4,from:3.595,to:3.645},{signals:[{js:[],delta:1.79,assignment:"CH₂(3,4)",multiplicity:"m"}],integration:4,from:1.7650000000000001,to:1.815}],nucleus:"1H",solvent:"THF-d₈"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.31,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.305,to:2.315},{signals:[{js:[],delta:7.1,assignment:"CH(2,4,6)",multiplicity:"m"}],integration:3,from:7.074999999999999,to:7.125},{signals:[{js:[],delta:7.19,assignment:"CH(3,5)",multiplicity:"m"}],integration:2,from:7.165,to:7.215000000000001}],nucleus:"1H",solvent:"THF-d₈"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.97,assignment:"CH₃"}],integration:6,from:.9475,to:.9924999999999999},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.46,assignment:"CH₂"}],integration:4,from:2.42875,to:2.49125}],nucleus:"1H",solvent:"THF-d₈"},{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:1.52,multiplicity:"s",assignment:"OH"}],integration:2,from:1.5150000000000001,to:1.525}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:2.06,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.055,to:2.065}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:2.12,multiplicity:"s",assignment:"CH₃"}],integration:6,from:2.115,to:2.125}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:1.97,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.965,to:1.9749999999999999}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.35,multiplicity:"s",assignment:"CH"}],integration:6,from:7.345,to:7.3549999999999995}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.24,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.235,to:1.2449999999999999}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:7.32,multiplicity:"s",assignment:"CH"}],integration:1,from:7.315,to:7.325}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.59,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.585,to:3.5949999999999998}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.44,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.435,to:1.4449999999999998}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:3.76,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.755,to:3.7649999999999997}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:5.33,multiplicity:"s",assignment:"CH₂"}],integration:2,from:5.325,to:5.335}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.15,assignment:"CH₃"}],integration:6,from:1.1275,to:1.1724999999999999},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.43,assignment:"CH₂"}],integration:4,from:3.39875,to:3.46125}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.57,assignment:"CH₂",multiplicity:"m"}],integration:4,from:3.545,to:3.5949999999999998},{signals:[{js:[],delta:3.5,assignment:"CH₂",multiplicity:"m"}],integration:4,from:3.475,to:3.525},{signals:[{js:[],delta:3.33,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.325,to:3.335}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.96,multiplicity:"s",assignment:"CH"}],integration:1,from:7.955,to:7.965},{signals:[{js:[],delta:2.91,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.9050000000000002,to:2.915},{signals:[{js:[],delta:2.82,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.815,to:2.8249999999999997}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.65,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.645,to:3.655}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.34,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.335,to:3.3449999999999998},{signals:[{js:[],delta:3.49,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.4850000000000003,to:3.495}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.85,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.845,to:.855}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.19,assignment:"CH₃"}],integration:3,from:1.1675,to:1.2125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.66,assignment:"CH₂"}],integration:2,from:3.62875,to:3.69125},{signals:[{js:[],delta:1.33,multiplicity:"s",assignment:"OH"}],integration:1,from:1.3250000000000002,to:1.335}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:2,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:1.995,to:2.005},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:4.08,assignment:"CH₂CH₃"}],integration:2,from:4.04875,to:4.11125},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.23,assignment:"CH₂CH₃"}],integration:3,from:1.2075,to:1.2525}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.4,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.3950000000000005,to:5.405}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.66,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.6550000000000002,to:3.665}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["H greaseᶠ"],smiles:"",ranges:[{signals:[],integration:6,from:.84,to:.9,multiplicity:"m"},{signals:[{js:[],delta:1.27,multiplicity:"br s",assignment:"CH₂"}],integration:10,from:1.25625,to:1.28375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.2,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.1950000000000003,to:2.205}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.89,assignment:"CH₃"}],integration:6,from:.8675,to:.9125},{signals:[{js:[],delta:1.27,assignment:"CH₂",multiplicity:"m"}],integration:8,from:1.245,to:1.295}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.07,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.065,to:.07500000000000001}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.6,assignment:"CH₃"}],integration:18,from:2.583125,to:2.6168750000000003}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.59,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.585,to:4.595}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.63,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.625,to:7.635},{signals:[{js:[],delta:7.07,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:7.065,to:7.075}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.21,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.205,to:.215}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.42,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.415,to:3.425},{signals:[{js:[],delta:1.09,multiplicity:"s",assignment:"OH"}],integration:1,from:1.0850000000000002,to:1.095}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:4.31,multiplicity:"s",assignment:"CH₃"}],integration:3,from:4.305,to:4.3149999999999995}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.89,assignment:"CH₃"}],integration:6,from:.8675,to:.9125},{signals:[{js:[],delta:1.3,assignment:"CH₂",multiplicity:"m"}],integration:6,from:1.2750000000000001,to:1.325}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.9,assignment:"CH₃"}],integration:6,from:.87675,to:.92325},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.32,assignment:"CH₂"}],integration:2,from:1.26025,to:1.37975}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:1.17,assignment:"CH₃"}],integration:6,from:1.1575,to:1.1824999999999999},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:3.97,assignment:"CH"}],integration:1,from:3.9200000000000004,to:4.0200000000000005}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.71,assignment:"CH₃"}],integration:3,from:1.69325,to:1.72675},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.93,assignment:"CH₂(1)"}],integration:1,from:4.9125,to:4.9475},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:5.03,assignment:"CH₂(2)"}],integration:1,from:5.00375,to:5.05625},{signals:[{js:[],delta:5.84,assignment:"CH",multiplicity:"m"}],integration:1,from:5.8149999999999995,to:5.865}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.59,assignment:"CH(2,6)",multiplicity:"m"}],integration:2,from:8.565,to:8.615},{signals:[{js:[],delta:7.28,assignment:"CH(3,5)",multiplicity:"m"}],integration:2,from:7.255,to:7.305000000000001},{signals:[{js:[],delta:7.68,assignment:"CH(4)",multiplicity:"m"}],integration:1,from:7.654999999999999,to:7.705}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:8.69,assignment:"NH",multiplicity:"br t"}],integration:1,from:8.684999999999999,to:8.695},{signals:[{js:[],delta:6.79,assignment:"CH(2,5)",multiplicity:"m"}],integration:2,from:6.765,to:6.815},{signals:[{js:[],delta:6.19,assignment:"CH(3,4)",multiplicity:"m"}],integration:2,from:6.165,to:6.215000000000001}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:2.82,assignment:"CH₂(2,5)",multiplicity:"m"}],integration:4,from:2.795,to:2.8449999999999998},{signals:[{js:[],delta:1.67,assignment:"CH₂(3,4)",multiplicity:"m"}],integration:4,from:1.645,to:1.6949999999999998}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:.09,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.08499999999999999,to:.095}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.69,assignment:"CH₂(2,5)",multiplicity:"m"}],integration:4,from:3.665,to:3.715},{signals:[{js:[],delta:1.82,assignment:"CH₂(3,4)",multiplicity:"m"}],integration:4,from:1.7950000000000002,to:1.845}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.34,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.335,to:2.3449999999999998},{signals:[{js:[],delta:7.15,assignment:"CH(2,4,6)",multiplicity:"m"}],integration:3,from:7.125,to:7.175000000000001},{signals:[{js:[],delta:7.24,assignment:"CH(3,5)",multiplicity:"m"}],integration:2,from:7.215,to:7.265000000000001}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.99,assignment:"CH₃"}],integration:6,from:.9675,to:1.0125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.48,assignment:"CH₂"}],integration:4,from:2.44875,to:2.51125}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:1.56,multiplicity:"s",assignment:"OH"}],integration:2,from:1.5550000000000002,to:1.565}],nucleus:"1H",solvent:"CDCl₃"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:2.1,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.095,to:2.105}],nucleus:"1H",solvent:"CDCl₃"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:2.17,multiplicity:"s",assignment:"CH₃"}],integration:6,from:2.165,to:2.175}],nucleus:"1H",solvent:"CDCl₃"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:2.1,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.095,to:2.105}],nucleus:"1H",solvent:"CDCl₃"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.36,multiplicity:"s",assignment:"CH"}],integration:6,from:7.355,to:7.365}],nucleus:"1H",solvent:"CDCl₃"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.28,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.2750000000000001,to:1.285}],nucleus:"1H",solvent:"CDCl₃"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:7.26,multiplicity:"s",assignment:"CH"}],integration:1,from:7.255,to:7.265}],nucleus:"1H",solvent:"CDCl₃"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.67,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.665,to:3.675}],nucleus:"1H",solvent:"CDCl₃"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.43,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.425,to:1.4349999999999998}],nucleus:"1H",solvent:"CDCl₃"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:3.73,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.725,to:3.735}],nucleus:"1H",solvent:"CDCl₃"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:5.3,multiplicity:"s",assignment:"CH₂"}],integration:2,from:5.295,to:5.305}],nucleus:"1H",solvent:"CDCl₃"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.21,assignment:"CH₃"}],integration:6,from:1.1875,to:1.2325},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.48,assignment:"CH₂"}],integration:4,from:3.44875,to:3.51125}],nucleus:"1H",solvent:"CDCl₃"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.65,assignment:"CH₂",multiplicity:"m"}],integration:4,from:3.625,to:3.675},{signals:[{js:[],delta:3.57,assignment:"CH₂",multiplicity:"m"}],integration:4,from:3.545,to:3.5949999999999998},{signals:[{js:[],delta:3.39,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.3850000000000002,to:3.395}],nucleus:"1H",solvent:"CDCl₃"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:8.02,multiplicity:"s",assignment:"CH"}],integration:1,from:8.014999999999999,to:8.025},{signals:[{js:[],delta:2.96,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.955,to:2.965},{signals:[{js:[],delta:2.88,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.875,to:2.885}],nucleus:"1H",solvent:"CDCl₃"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.71,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.705,to:3.715}],nucleus:"1H",solvent:"CDCl₃"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.4,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.395,to:3.405},{signals:[{js:[],delta:3.55,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.545,to:3.5549999999999997}],nucleus:"1H",solvent:"CDCl₃"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.87,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.865,to:.875}],nucleus:"1H",solvent:"CDCl₃"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.25,assignment:"CH₃"}],integration:3,from:1.2275,to:1.2725},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.72,assignment:"CH₂"}],integration:2,from:3.68875,to:3.75125},{signals:[{js:[],delta:1.32,multiplicity:"s",assignment:"OH"}],integration:1,from:1.3150000000000002,to:1.325}],nucleus:"1H",solvent:"CDCl₃"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:2.05,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:2.045,to:2.0549999999999997},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:4.12,assignment:"CH₂CH₃"}],integration:2,from:4.08875,to:4.15125},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.26,assignment:"CH₂CH₃"}],integration:3,from:1.2375,to:1.2825}],nucleus:"1H",solvent:"CDCl₃"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.4,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.3950000000000005,to:5.405}],nucleus:"1H",solvent:"CDCl₃"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.76,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.755,to:3.7649999999999997}],nucleus:"1H",solvent:"CDCl₃"},{names:["H greaseᶠ"],smiles:"",ranges:[{signals:[],integration:6,from:.84,to:.87,multiplicity:"m"},{signals:[{js:[],delta:1.25,multiplicity:"br s",assignment:"CH₂"}],integration:10,from:1.23625,to:1.26375}],nucleus:"1H",solvent:"CDCl₃"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.24,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.2350000000000003,to:2.245}],nucleus:"1H",solvent:"CDCl₃"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.88,assignment:"CH₃"}],integration:6,from:.8575,to:.9025},{signals:[{js:[],delta:1.26,assignment:"CH₂",multiplicity:"m"}],integration:8,from:1.235,to:1.285}],nucleus:"1H",solvent:"CDCl₃"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.07,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.065,to:.07500000000000001}],nucleus:"1H",solvent:"CDCl₃"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.65,assignment:"CH₃"}],integration:18,from:2.6331249999999997,to:2.666875}],nucleus:"1H",solvent:"CDCl₃"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.62,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.615,to:4.625}],nucleus:"1H",solvent:"CDCl₃"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.67,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.665,to:7.675},{signals:[{js:[],delta:7.1,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:7.095,to:7.1049999999999995}],nucleus:"1H",solvent:"CDCl₃"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.22,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.215,to:.225}],nucleus:"1H",solvent:"CDCl₃"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.49,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.4850000000000003,to:3.495},{signals:[{js:[],delta:1.09,multiplicity:"s",assignment:"OH"}],integration:1,from:1.0850000000000002,to:1.095}],nucleus:"1H",solvent:"CDCl₃"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:4.33,multiplicity:"s",assignment:"CH₃"}],integration:3,from:4.325,to:4.335}],nucleus:"1H",solvent:"CDCl₃"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.88,assignment:"CH₃"}],integration:6,from:.8575,to:.9025},{signals:[{js:[],delta:1.27,assignment:"CH₂",multiplicity:"m"}],integration:6,from:1.245,to:1.295}],nucleus:"1H",solvent:"CDCl₃"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.9,assignment:"CH₃"}],integration:6,from:.87675,to:.92325},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.32,assignment:"CH₂"}],integration:2,from:1.26025,to:1.37975}],nucleus:"1H",solvent:"CDCl₃"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:1.22,assignment:"CH₃"}],integration:6,from:1.2075,to:1.2325},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:4.04,assignment:"CH"}],integration:1,from:3.99,to:4.09}],nucleus:"1H",solvent:"CDCl₃"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.73,assignment:"CH₃"}],integration:3,from:1.71325,to:1.74675},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.94,assignment:"CH₂(1)"}],integration:1,from:4.9225,to:4.9575000000000005},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:5.03,assignment:"CH₂(2)"}],integration:1,from:5.00375,to:5.05625},{signals:[{js:[],delta:5.83,assignment:"CH",multiplicity:"m"}],integration:1,from:5.805,to:5.855}],nucleus:"1H",solvent:"CDCl₃"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.62,assignment:"CH(2,6)",multiplicity:"m"}],integration:2,from:8.594999999999999,to:8.645},{signals:[{js:[],delta:7.29,assignment:"CH(3,5)",multiplicity:"m"}],integration:2,from:7.265,to:7.315},{signals:[{js:[],delta:7.68,assignment:"CH(4)",multiplicity:"m"}],integration:1,from:7.654999999999999,to:7.705}],nucleus:"1H",solvent:"CDCl₃"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:8.4,assignment:"NH",multiplicity:"br t"}],integration:1,from:8.395,to:8.405000000000001},{signals:[{js:[],delta:6.83,assignment:"CH(2,5)",multiplicity:"m"}],integration:2,from:6.805,to:6.855},{signals:[{js:[],delta:6.26,assignment:"CH(3,4)",multiplicity:"m"}],integration:2,from:6.234999999999999,to:6.285}],nucleus:"1H",solvent:"CDCl₃"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:2.87,assignment:"CH₂(2,5)",multiplicity:"m"}],integration:4,from:2.845,to:2.895},{signals:[{js:[],delta:1.68,assignment:"CH₂(3,4)",multiplicity:"m"}],integration:4,from:1.655,to:1.7049999999999998}],nucleus:"1H",solvent:"CDCl₃"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:.07,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.065,to:.07500000000000001}],nucleus:"1H",solvent:"CDCl₃"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.76,assignment:"CH₂(2,5)",multiplicity:"m"}],integration:4,from:3.735,to:3.7849999999999997},{signals:[{js:[],delta:1.85,assignment:"CH₂(3,4)",multiplicity:"m"}],integration:4,from:1.8250000000000002,to:1.875}],nucleus:"1H",solvent:"CDCl₃"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.36,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.355,to:2.3649999999999998},{signals:[{js:[],delta:7.17,assignment:"CH(2,4,6)",multiplicity:"m"}],integration:3,from:7.145,to:7.195},{signals:[{js:[],delta:7.25,assignment:"CH(3,5)",multiplicity:"m"}],integration:2,from:7.225,to:7.275}],nucleus:"1H",solvent:"CDCl₃"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.03,assignment:"CH₃"}],integration:6,from:1.0075,to:1.0525},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.53,assignment:"CH₂"}],integration:4,from:2.49875,to:2.56125}],nucleus:"1H",solvent:"CDCl₃"},{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:.43,multiplicity:"s",assignment:"OH"}],integration:2,from:.425,to:.435}],nucleus:"1H",solvent:"toluene-d₈"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:1.57,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.5650000000000002,to:1.575}],nucleus:"1H",solvent:"toluene-d₈"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:1.57,multiplicity:"s",assignment:"CH₃"}],integration:6,from:1.5650000000000002,to:1.575}],nucleus:"1H",solvent:"toluene-d₈"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:.69,multiplicity:"s",assignment:"CH₃"}],integration:3,from:.6849999999999999,to:.695}],nucleus:"1H",solvent:"toluene-d₈"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.12,multiplicity:"s",assignment:"CH"}],integration:6,from:7.115,to:7.125}],nucleus:"1H",solvent:"toluene-d₈"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.03,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.0250000000000001,to:1.035},{signals:[{js:[],delta:.58,multiplicity:"s",assignment:"OH"}],integration:1,from:.575,to:.585}],nucleus:"1H",solvent:"toluene-d₈"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:6.1,multiplicity:"s",assignment:"CH"}],integration:1,from:6.095,to:6.1049999999999995}],nucleus:"1H",solvent:"toluene-d₈"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.36,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.355,to:3.3649999999999998}],nucleus:"1H",solvent:"toluene-d₈"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.4,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.395,to:1.4049999999999998}],nucleus:"1H",solvent:"toluene-d₈"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:2.91,multiplicity:"s",assignment:"CH₂"}],integration:4,from:2.9050000000000002,to:2.915}],nucleus:"1H",solvent:"toluene-d₈"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:4.32,multiplicity:"s",assignment:"CH₂"}],integration:2,from:4.315,to:4.325}],nucleus:"1H",solvent:"toluene-d₈"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.1,assignment:"CH₃"}],integration:6,from:1.0775000000000001,to:1.1225},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.25,assignment:"CH₂"}],integration:4,from:3.21875,to:3.28125}],nucleus:"1H",solvent:"toluene-d₈"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.43,assignment:"CH₂",multiplicity:"m"}],integration:4,from:3.4050000000000002,to:3.455},{signals:[{js:[],delta:3.31,assignment:"CH₂",multiplicity:"m"}],integration:4,from:3.285,to:3.335},{signals:[{js:[],delta:3.12,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.115,to:3.125}],nucleus:"1H",solvent:"toluene-d₈"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.57,multiplicity:"s",assignment:"CH"}],integration:1,from:7.565,to:7.575},{signals:[{js:[],delta:2.37,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.365,to:2.375},{signals:[{js:[],delta:1.96,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.955,to:1.9649999999999999}],nucleus:"1H",solvent:"toluene-d₈"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.33,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.325,to:3.335}],nucleus:"1H",solvent:"toluene-d₈"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.12,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.115,to:3.125},{signals:[{js:[],delta:3.31,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.305,to:3.315}],nucleus:"1H",solvent:"toluene-d₈"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.81,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.805,to:.8150000000000001}],nucleus:"1H",solvent:"toluene-d₈"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.97,assignment:"CH₃"}],integration:3,from:.9475,to:.9924999999999999},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.36,assignment:"CH₂"}],integration:2,from:3.32875,to:3.39125},{signals:[{js:[],delta:.83,multiplicity:"s",assignment:"OH"}],integration:1,from:.825,to:.835}],nucleus:"1H",solvent:"toluene-d₈"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:1.69,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:1.685,to:1.6949999999999998},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.87,assignment:"CH₂CH₃"}],integration:2,from:3.83875,to:3.90125},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.94,assignment:"CH₂CH₃"}],integration:3,from:.9175,to:.9624999999999999}],nucleus:"1H",solvent:"toluene-d₈"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.25,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.245,to:5.255}],nucleus:"1H",solvent:"toluene-d₈"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.36,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.355,to:3.3649999999999998}],nucleus:"1H",solvent:"toluene-d₈"},{names:["H greaseᶠ"],smiles:"",ranges:[{signals:[],integration:6,from:.89,to:.96,multiplicity:"m"},{signals:[{js:[],delta:1.33,multiplicity:"br s",assignment:"CH₂"}],integration:10,from:1.3162500000000001,to:1.34375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.1,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.095,to:2.105}],nucleus:"1H",solvent:"toluene-d₈"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.88,assignment:"CH₃"}],integration:6,from:.8575,to:.9025},{signals:[{js:[],delta:1.22,assignment:"CH₂",multiplicity:"m"}],integration:8,from:1.195,to:1.2449999999999999}],nucleus:"1H",solvent:"toluene-d₈"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.1,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.095,to:.10500000000000001}],nucleus:"1H",solvent:"toluene-d₈"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.42,assignment:"CH₃"}],integration:18,from:2.4031249999999997,to:2.436875}],nucleus:"1H",solvent:"toluene-d₈"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.5,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.495,to:4.505}],nucleus:"1H",solvent:"toluene-d₈"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.3,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.295,to:7.305},{signals:[{js:[],delta:6.86,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:6.855,to:6.865}],nucleus:"1H",solvent:"toluene-d₈"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.17,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.165,to:.17500000000000002}],nucleus:"1H",solvent:"toluene-d₈"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.03,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.025,to:3.0349999999999997}],nucleus:"1H",solvent:"toluene-d₈"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:3.01,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.005,to:3.0149999999999997}],nucleus:"1H",solvent:"toluene-d₈"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.87,assignment:"CH₃"}],integration:6,from:.8475,to:.8925},{signals:[{js:[],delta:1.25,assignment:"CH₂",multiplicity:"m"}],integration:6,from:1.225,to:1.275}],nucleus:"1H",solvent:"toluene-d₈"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.89,assignment:"CH₃"}],integration:6,from:.86675,to:.91325},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.32,assignment:"CH₂"}],integration:2,from:1.26025,to:1.37975}],nucleus:"1H",solvent:"toluene-d₈"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:.95,assignment:"CH₃"}],integration:6,from:.9375,to:.9624999999999999},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:3.65,assignment:"CH"}],integration:1,from:3.6,to:3.6999999999999997}],nucleus:"1H",solvent:"toluene-d₈"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.55,assignment:"CH₃"}],integration:3,from:1.53325,to:1.56675},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.92,assignment:"CH₂(1)"}],integration:1,from:4.9025,to:4.9375},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:4.98,assignment:"CH₂(2)"}],integration:1,from:4.95375,to:5.0062500000000005},{signals:[{js:[],delta:5.7,assignment:"CH",multiplicity:"m"}],integration:1,from:5.675,to:5.7250000000000005}],nucleus:"1H",solvent:"toluene-d₈"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.47,assignment:"CH(2,6)",multiplicity:"m"}],integration:2,from:8.445,to:8.495000000000001},{signals:[{js:[],delta:6.67,assignment:"CH(3,5)",multiplicity:"m"}],integration:2,from:6.645,to:6.695},{signals:[{js:[],delta:6.99,assignment:"CH(4)",multiplicity:"m"}],integration:1,from:6.965,to:7.015000000000001}],nucleus:"1H",solvent:"toluene-d₈"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:7.71,assignment:"NH",multiplicity:"br t"}],integration:1,from:7.705,to:7.715},{signals:[{js:[],delta:6.43,assignment:"CH(2,5)",multiplicity:"m"}],integration:2,from:6.404999999999999,to:6.455},{signals:[{js:[],delta:6.27,assignment:"CH(3,4)",multiplicity:"m"}],integration:2,from:6.244999999999999,to:6.295}],nucleus:"1H",solvent:"toluene-d₈"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:2.54,assignment:"CH₂(2,5)",multiplicity:"m"}],integration:4,from:2.515,to:2.565},{signals:[{js:[],delta:1.36,assignment:"CH₂(3,4)",multiplicity:"m"}],integration:4,from:1.3350000000000002,to:1.385}],nucleus:"1H",solvent:"toluene-d₈"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:.26,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.255,to:.265}],nucleus:"1H",solvent:"toluene-d₈"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.54,assignment:"CH₂(2,5)",multiplicity:"m"}],integration:4,from:3.515,to:3.565},{signals:[{js:[],delta:1.43,assignment:"CH₂(3,4)",multiplicity:"m"}],integration:4,from:1.405,to:1.4549999999999998}],nucleus:"1H",solvent:"toluene-d₈"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.11,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.105,to:2.1149999999999998},{signals:[],integration:3,from:6.96,to:7.01,multiplicity:"m"},{signals:[{js:[],delta:7.09,assignment:"CH(3,5)",multiplicity:"m"}],integration:2,from:7.0649999999999995,to:7.115}],nucleus:"1H",solvent:"toluene-d₈"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.95,assignment:"CH₃"}],integration:6,from:.9275,to:.9724999999999999},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.39,assignment:"CH₂"}],integration:4,from:2.35875,to:2.42125}],nucleus:"1H",solvent:"toluene-d₈"},{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:.4,multiplicity:"s",assignment:"OH"}],integration:2,from:.395,to:.405}],nucleus:"1H",solvent:"C₆D₆"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:1.52,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.5150000000000001,to:1.525}],nucleus:"1H",solvent:"C₆D₆"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:1.55,multiplicity:"s",assignment:"CH₃"}],integration:6,from:1.5450000000000002,to:1.555}],nucleus:"1H",solvent:"C₆D₆"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:.58,multiplicity:"s",assignment:"CH₃"}],integration:3,from:.575,to:.585}],nucleus:"1H",solvent:"C₆D₆"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.15,multiplicity:"s",assignment:"CH"}],integration:6,from:7.1450000000000005,to:7.155}],nucleus:"1H",solvent:"C₆D₆"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.05,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.0450000000000002,to:1.055},{signals:[{js:[],delta:.63,multiplicity:"s",assignment:"OH"}],integration:1,from:.625,to:.635}],nucleus:"1H",solvent:"C₆D₆"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:6.15,multiplicity:"s",assignment:"CH"}],integration:1,from:6.1450000000000005,to:6.155}],nucleus:"1H",solvent:"C₆D₆"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.39,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.3850000000000002,to:3.395}],nucleus:"1H",solvent:"C₆D₆"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.4,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.395,to:1.4049999999999998}],nucleus:"1H",solvent:"C₆D₆"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:2.9,multiplicity:"s",assignment:"CH₂"}],integration:4,from:2.895,to:2.905}],nucleus:"1H",solvent:"C₆D₆"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:4.27,multiplicity:"s",assignment:"CH₂"}],integration:2,from:4.265,to:4.2749999999999995}],nucleus:"1H",solvent:"C₆D₆"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.11,assignment:"CH₃"}],integration:6,from:1.0875000000000001,to:1.1325},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.26,assignment:"CH₂"}],integration:4,from:3.22875,to:3.29125}],nucleus:"1H",solvent:"C₆D₆"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.46,assignment:"CH₂",multiplicity:"m"}],integration:4,from:3.435,to:3.485},{signals:[{js:[],delta:3.34,assignment:"CH₂",multiplicity:"m"}],integration:4,from:3.315,to:3.3649999999999998},{signals:[{js:[],delta:3.11,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.105,to:3.1149999999999998}],nucleus:"1H",solvent:"C₆D₆"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.63,multiplicity:"s",assignment:"CH"}],integration:1,from:7.625,to:7.635},{signals:[{js:[],delta:2.36,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.355,to:2.3649999999999998},{signals:[{js:[],delta:1.86,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.8550000000000002,to:1.865}],nucleus:"1H",solvent:"C₆D₆"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.35,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.345,to:3.355}],nucleus:"1H",solvent:"C₆D₆"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.12,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.115,to:3.125},{signals:[{js:[],delta:3.33,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.325,to:3.335}],nucleus:"1H",solvent:"C₆D₆"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.8,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.795,to:.805}],nucleus:"1H",solvent:"C₆D₆"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.96,assignment:"CH₃"}],integration:3,from:.9375,to:.9824999999999999},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.34,assignment:"CH₂"}],integration:2,from:3.30875,to:3.37125},{signals:[{js:[],delta:.5,multiplicity:"s",assignment:"OH"}],integration:1,from:.495,to:.505}],nucleus:"1H",solvent:"C₆D₆"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:1.65,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:1.645,to:1.6549999999999998},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.89,assignment:"CH₂CH₃"}],integration:2,from:3.85875,to:3.92125},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.92,assignment:"CH₂CH₃"}],integration:3,from:.8975000000000001,to:.9425}],nucleus:"1H",solvent:"C₆D₆"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.25,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.245,to:5.255}],nucleus:"1H",solvent:"C₆D₆"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.41,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.4050000000000002,to:3.415}],nucleus:"1H",solvent:"C₆D₆"},{names:["H greaseᶠ"],smiles:"",ranges:[{signals:[],integration:6,from:.9,to:.98,multiplicity:"m"},{signals:[{js:[],delta:1.32,multiplicity:"br s",assignment:"CH₂"}],integration:10,from:1.3062500000000001,to:1.33375}],nucleus:"1H",solvent:"C₆D₆"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.13,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.125,to:2.135}],nucleus:"1H",solvent:"C₆D₆"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.89,assignment:"CH₃"}],integration:6,from:.8675,to:.9125},{signals:[{js:[],delta:1.24,assignment:"CH₂",multiplicity:"m"}],integration:8,from:1.215,to:1.265}],nucleus:"1H",solvent:"C₆D₆"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.12,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.11499999999999999,to:.125}],nucleus:"1H",solvent:"C₆D₆"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.4,assignment:"CH₃"}],integration:18,from:2.3831249999999997,to:2.416875}],nucleus:"1H",solvent:"C₆D₆"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.47,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.465,to:4.475}],nucleus:"1H",solvent:"C₆D₆"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.33,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.325,to:7.335},{signals:[{js:[],delta:6.9,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:6.8950000000000005,to:6.905}],nucleus:"1H",solvent:"C₆D₆"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.16,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.155,to:.165}],nucleus:"1H",solvent:"C₆D₆"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.07,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.065,to:3.0749999999999997}],nucleus:"1H",solvent:"C₆D₆"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:2.94,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.935,to:2.945}],nucleus:"1H",solvent:"C₆D₆"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.87,assignment:"CH₃"}],integration:6,from:.8475,to:.8925},{signals:[{js:[],delta:1.23,assignment:"CH₂",multiplicity:"m"}],integration:6,from:1.205,to:1.255}],nucleus:"1H",solvent:"C₆D₆"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.86,assignment:"CH₃"}],integration:6,from:.83675,to:.88325},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.26,assignment:"CH₂"}],integration:2,from:1.20025,to:1.31975}],nucleus:"1H",solvent:"C₆D₆"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:.95,assignment:"CH₃"}],integration:6,from:.9375,to:.9624999999999999},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:3.67,assignment:"CH"}],integration:1,from:3.62,to:3.7199999999999998}],nucleus:"1H",solvent:"C₆D₆"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.55,assignment:"CH₃"}],integration:3,from:1.53325,to:1.56675},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.95,assignment:"CH₂(1)"}],integration:1,from:4.9325,to:4.9675},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:5.01,assignment:"CH₂(2)"}],integration:1,from:4.98375,to:5.03625},{signals:[{js:[],delta:5.72,assignment:"CH",multiplicity:"m"}],integration:1,from:5.694999999999999,to:5.745}],nucleus:"1H",solvent:"C₆D₆"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.53,assignment:"CH(2,6)",multiplicity:"m"}],integration:2,from:8.504999999999999,to:8.555},{signals:[{js:[],delta:6.66,assignment:"CH(3,5)",multiplicity:"m"}],integration:2,from:6.635,to:6.6850000000000005},{signals:[{js:[],delta:6.98,assignment:"CH(4)",multiplicity:"m"}],integration:1,from:6.955,to:7.005000000000001}],nucleus:"1H",solvent:"C₆D₆"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:7.8,assignment:"NH",multiplicity:"br t"}],integration:1,from:7.795,to:7.805},{signals:[{js:[],delta:6.48,assignment:"CH(2,5)",multiplicity:"m"}],integration:2,from:6.455,to:6.505000000000001},{signals:[{js:[],delta:6.37,assignment:"CH(3,4)",multiplicity:"m"}],integration:2,from:6.345,to:6.3950000000000005}],nucleus:"1H",solvent:"C₆D₆"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:2.54,assignment:"CH₂(2,5)",multiplicity:"m"}],integration:4,from:2.515,to:2.565},{signals:[{js:[],delta:1.33,assignment:"CH₂(3,4)",multiplicity:"m"}],integration:4,from:1.3050000000000002,to:1.355}],nucleus:"1H",solvent:"C₆D₆"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:.29,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.285,to:.295}],nucleus:"1H",solvent:"C₆D₆"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.57,assignment:"CH₂(2,5)",multiplicity:"m"}],integration:4,from:3.545,to:3.5949999999999998},{signals:[{js:[],delta:1.4,assignment:"CH₂(3,4)",multiplicity:"m"}],integration:4,from:1.375,to:1.4249999999999998}],nucleus:"1H",solvent:"C₆D₆"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.11,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.105,to:2.1149999999999998},{signals:[{js:[],delta:7.02,assignment:"CH(2,4,6)",multiplicity:"m"}],integration:3,from:6.994999999999999,to:7.045},{signals:[{js:[],delta:7.13,assignment:"CH(3,5)",multiplicity:"m"}],integration:2,from:7.1049999999999995,to:7.155}],nucleus:"1H",solvent:"C₆D₆"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.96,assignment:"CH₃"}],integration:6,from:.9375,to:.9824999999999999},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.4,assignment:"CH₂"}],integration:4,from:2.36875,to:2.43125}],nucleus:"1H",solvent:"C₆D₆"},{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:1.03,multiplicity:"s",assignment:"OH"}],integration:2,from:1.0250000000000001,to:1.035}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:1.76,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.7550000000000001,to:1.765}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:1.77,multiplicity:"s",assignment:"CH₃"}],integration:6,from:1.7650000000000001,to:1.775}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:1.21,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.205,to:1.2149999999999999}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.2,multiplicity:"s",assignment:"CH"}],integration:6,from:7.195,to:7.205}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.12,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.1150000000000002,to:1.125},{signals:[{js:[],delta:1.3,multiplicity:"s",assignment:"OH"}],integration:1,from:1.2950000000000002,to:1.305}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:6.74,multiplicity:"s",assignment:"CH"}],integration:1,from:6.735,to:6.745}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.41,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.4050000000000002,to:3.415}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.37,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.3650000000000002,to:1.375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:3.26,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.255,to:3.2649999999999997}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:4.77,multiplicity:"s",assignment:"CH₂"}],integration:2,from:4.765,to:4.7749999999999995}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.1,assignment:"CH₃"}],integration:6,from:1.0775000000000001,to:1.1225},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.31,assignment:"CH₂"}],integration:4,from:3.27875,to:3.34125}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.49,assignment:"CH₂",multiplicity:"m"}],integration:4,from:3.4650000000000003,to:3.515},{signals:[{js:[],delta:3.37,assignment:"CH₂",multiplicity:"m"}],integration:4,from:3.345,to:3.395},{signals:[{js:[],delta:3.16,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.1550000000000002,to:3.165}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.73,multiplicity:"s",assignment:"CH"}],integration:1,from:7.7250000000000005,to:7.735},{signals:[{js:[],delta:2.51,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.505,to:2.5149999999999997},{signals:[{js:[],delta:2.3,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.295,to:2.3049999999999997}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.45,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.4450000000000003,to:3.455}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.17,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.165,to:3.175},{signals:[{js:[],delta:3.37,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.365,to:3.375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.79,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.785,to:.795}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.06,assignment:"CH₃"}],integration:3,from:1.0375,to:1.0825},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.51,assignment:"CH₂"}],integration:2,from:3.47875,to:3.54125},{signals:[{js:[],delta:1.39,multiplicity:"s",assignment:"OH"}],integration:1,from:1.385,to:1.3949999999999998}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:1.78,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:1.7750000000000001,to:1.785},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.96,assignment:"CH₂CH₃"}],integration:2,from:3.92875,to:3.99125},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.04,assignment:"CH₂CH₃"}],integration:3,from:1.0175,to:1.0625}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.29,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.285,to:5.295}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.58,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.575,to:3.585}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["H greaseᶠ"],smiles:"",ranges:[{signals:[],integration:6,from:.86,to:.92,multiplicity:"m"},{signals:[{js:[],delta:1.3,multiplicity:"br s",assignment:"CH₂"}],integration:10,from:1.2862500000000001,to:1.31375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.1,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.095,to:2.105}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.85,assignment:"CH₃"}],integration:6,from:.8275,to:.8724999999999999},{signals:[{js:[],delta:1.19,assignment:"CH₂",multiplicity:"m"}],integration:8,from:1.165,to:1.2149999999999999}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.1,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.095,to:.10500000000000001}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.47,assignment:"CH₃"}],integration:18,from:2.453125,to:2.4868750000000004}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.49,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.485,to:4.495}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.53,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.525,to:7.535},{signals:[{js:[],delta:7.01,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:7.005,to:7.015}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.15,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.145,to:.155}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.25,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.245,to:3.255},{signals:[{js:[],delta:1.3,multiplicity:"s",assignment:"OH"}],integration:1,from:1.2950000000000002,to:1.305}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:3.59,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.585,to:3.5949999999999998}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.84,assignment:"CH₃"}],integration:6,from:.8175,to:.8624999999999999},{signals:[{js:[],delta:1.23,assignment:"CH₂",multiplicity:"m"}],integration:6,from:1.205,to:1.255}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.84,assignment:"CH₃"}],integration:6,from:.81675,to:.86325},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.26,assignment:"CH₂"}],integration:2,from:1.20025,to:1.31975}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:1.04,assignment:"CH₃"}],integration:6,from:1.0275,to:1.0525},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:3.82,assignment:"CH"}],integration:1,from:3.77,to:3.8699999999999997}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.58,assignment:"CH₃"}],integration:3,from:1.56325,to:1.5967500000000001},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.91,assignment:"CH₂(1)"}],integration:1,from:4.8925,to:4.9275},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:4.98,assignment:"CH₂(2)"}],integration:1,from:4.95375,to:5.0062500000000005},{signals:[{js:[],delta:5.72,assignment:"CH",multiplicity:"m"}],integration:1,from:5.694999999999999,to:5.745}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.51,assignment:"CH(2,6)",multiplicity:"m"}],integration:2,from:8.485,to:8.535},{signals:[{js:[],delta:6.9,assignment:"CH(3,5)",multiplicity:"m"}],integration:2,from:6.875,to:6.925000000000001},{signals:[{js:[],delta:7.25,assignment:"CH(4)",multiplicity:"m"}],integration:1,from:7.225,to:7.275}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:8.61,assignment:"NH",multiplicity:"br t"}],integration:1,from:8.604999999999999,to:8.615},{signals:[{js:[],delta:6.62,assignment:"CH(2,5)",multiplicity:"m"}],integration:2,from:6.595,to:6.6450000000000005},{signals:[{js:[],delta:6.27,assignment:"CH(3,4)",multiplicity:"m"}],integration:2,from:6.244999999999999,to:6.295}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:2.64,assignment:"CH₂(2,5)",multiplicity:"m"}],integration:4,from:2.615,to:2.665},{signals:[{js:[],delta:1.43,assignment:"CH₂(3,4)",multiplicity:"m"}],integration:4,from:1.405,to:1.4549999999999998}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:.14,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.135,to:.14500000000000002}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.59,assignment:"CH₂(2,5)",multiplicity:"m"}],integration:4,from:3.565,to:3.6149999999999998},{signals:[{js:[],delta:1.55,assignment:"CH₂(3,4)",multiplicity:"m"}],integration:4,from:1.5250000000000001,to:1.575}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.16,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.1550000000000002,to:2.165},{signals:[],integration:3,from:7.01,to:7.08,multiplicity:"m"},{signals:[],integration:2,from:7.1,to:7.17,multiplicity:"m"}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.93,assignment:"CH₃"}],integration:6,from:.9075000000000001,to:.9525},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.39,assignment:"CH₂"}],integration:4,from:2.35875,to:2.42125}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:2.84,multiplicity:"s",assignment:"OH"}],integration:2,from:2.835,to:2.8449999999999998}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:1.96,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.955,to:1.9649999999999999}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:2.09,multiplicity:"s",assignment:"CH₃"}],integration:6,from:2.085,to:2.0949999999999998}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:2.05,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.045,to:2.0549999999999997}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.36,multiplicity:"s",assignment:"CH"}],integration:6,from:7.355,to:7.365}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.18,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.175,to:1.1849999999999998}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:8.02,multiplicity:"s",assignment:"CH"}],integration:1,from:8.014999999999999,to:8.025}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.59,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.585,to:3.5949999999999998}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.43,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.425,to:1.4349999999999998}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:3.87,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.865,to:3.875}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:5.63,multiplicity:"s",assignment:"CH₂"}],integration:2,from:5.625,to:5.635}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.11,assignment:"CH₃"}],integration:6,from:1.0875000000000001,to:1.1325},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.41,assignment:"CH₂"}],integration:4,from:3.37875,to:3.44125}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.56,assignment:"CH₂",multiplicity:"m"}],integration:4,from:3.535,to:3.585},{signals:[{js:[],delta:3.47,assignment:"CH₂",multiplicity:"m"}],integration:4,from:3.4450000000000003,to:3.495},{signals:[{js:[],delta:3.28,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.275,to:3.2849999999999997}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.96,multiplicity:"s",assignment:"CH"}],integration:1,from:7.955,to:7.965},{signals:[{js:[],delta:2.94,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.935,to:2.945},{signals:[{js:[],delta:2.78,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.775,to:2.7849999999999997}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.59,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.585,to:3.5949999999999998}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.28,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.275,to:3.2849999999999997},{signals:[{js:[],delta:3.46,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.455,to:3.465}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.83,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.825,to:.835}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.12,assignment:"CH₃"}],integration:3,from:1.0975000000000001,to:1.1425},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.57,assignment:"CH₂"}],integration:2,from:3.53875,to:3.60125},{signals:[{js:[],delta:3.39,multiplicity:"s",assignment:"OH"}],integration:1,from:3.3850000000000002,to:3.395}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:1.97,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:1.965,to:1.9749999999999999},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:4.05,assignment:"CH₂CH₃"}],integration:2,from:4.01875,to:4.08125},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.2,assignment:"CH₂CH₃"}],integration:3,from:1.1775,to:1.2225}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.38,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.375,to:5.385}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.28,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.275,to:3.2849999999999997}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["H greaseᶠ"],smiles:"",ranges:[{signals:[{js:[],delta:.9,assignment:"CH₃",multiplicity:"m"}],integration:6,from:.875,to:.925},{signals:[{js:[],delta:1.29,multiplicity:"br s",assignment:"CH₂"}],integration:10,from:1.27625,to:1.30375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.17,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.165,to:2.175}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.88,assignment:"CH₃"}],integration:6,from:.8575,to:.9025},{signals:[{js:[],delta:1.28,assignment:"CH₂",multiplicity:"m"}],integration:8,from:1.2550000000000001,to:1.305}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.07,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.065,to:.07500000000000001}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.59,assignment:"CH₃"}],integration:18,from:2.5731249999999997,to:2.606875}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.54,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.535,to:4.545}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.62,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.615,to:7.625},{signals:[{js:[],delta:7.04,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:7.035,to:7.045}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.17,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.165,to:.17500000000000002}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.31,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.305,to:3.315},{signals:[{js:[],delta:3.12,multiplicity:"s",assignment:"OH"}],integration:1,from:3.115,to:3.125}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:4.43,multiplicity:"s",assignment:"CH₃"}],integration:3,from:4.425,to:4.435}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.88,assignment:"CH₃"}],integration:6,from:.8575,to:.9025},{signals:[{js:[],delta:1.27,assignment:"CH₂",multiplicity:"m"}],integration:6,from:1.245,to:1.295}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.88,assignment:"CH₃"}],integration:6,from:.85675,to:.90325},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.31,assignment:"CH₂"}],integration:2,from:1.25025,to:1.36975}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:1.1,assignment:"CH₃"}],integration:6,from:1.0875000000000001,to:1.1125},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:3.9,assignment:"CH"}],integration:1,from:3.85,to:3.9499999999999997}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.68,assignment:"CH₃"}],integration:3,from:1.66325,to:1.69675},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.9,assignment:"CH₂(1)"}],integration:1,from:4.8825,to:4.9175},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:5,assignment:"CH₂(2)"}],integration:1,from:4.97375,to:5.02625},{signals:[{js:[],delta:5.81,assignment:"CH",multiplicity:"m"}],integration:1,from:5.784999999999999,to:5.835}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.58,assignment:"CH(2,6)",multiplicity:"m"}],integration:2,from:8.555,to:8.605},{signals:[{js:[],delta:7.35,assignment:"CH(3,5)",multiplicity:"m"}],integration:2,from:7.324999999999999,to:7.375},{signals:[{js:[],delta:7.76,assignment:"CH(4)",multiplicity:"m"}],integration:1,from:7.734999999999999,to:7.785}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:10.02,assignment:"NH",multiplicity:"br t"}],integration:1,from:10.014999999999999,to:10.025},{signals:[{js:[],delta:6.77,assignment:"CH(2,5)",multiplicity:"m"}],integration:2,from:6.744999999999999,to:6.795},{signals:[{js:[],delta:6.07,assignment:"CH(3,4)",multiplicity:"m"}],integration:2,from:6.045,to:6.095000000000001}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:.13,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.125,to:.135}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.63,assignment:"CH₂(2,5)",multiplicity:"m"}],integration:4,from:3.605,to:3.655},{signals:[{js:[],delta:1.79,assignment:"CH₂(3,4)",multiplicity:"m"}],integration:4,from:1.7650000000000001,to:1.815}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.32,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.315,to:2.3249999999999997},{signals:[],integration:3,from:7.1,to:7.2,multiplicity:"m"},{signals:[],integration:2,from:7.1,to:7.2,multiplicity:"m"}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.96,assignment:"CH₃"}],integration:6,from:.9375,to:.9824999999999999},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.45,assignment:"CH₂"}],integration:4,from:2.41875,to:2.48125}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:3.33,multiplicity:"s",assignment:"OH"}],integration:2,from:3.325,to:3.335}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:1.91,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.905,to:1.9149999999999998}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:2.09,multiplicity:"s",assignment:"CH₃"}],integration:6,from:2.085,to:2.0949999999999998}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:2.07,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.065,to:2.0749999999999997}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.37,multiplicity:"s",assignment:"CH"}],integration:6,from:7.365,to:7.375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.11,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.1050000000000002,to:1.115},{signals:[{js:[],delta:4.19,multiplicity:"s",assignment:"OH"}],integration:1,from:4.1850000000000005,to:4.195}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:8.32,multiplicity:"s",assignment:"CH"}],integration:1,from:8.315,to:8.325000000000001}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.51,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.505,to:3.5149999999999997}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.4,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.395,to:1.4049999999999998}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:3.9,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.895,to:3.905}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:5.76,multiplicity:"s",assignment:"CH₂"}],integration:2,from:5.755,to:5.765}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.09,assignment:"CH₃"}],integration:6,from:1.0675000000000001,to:1.1125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.38,assignment:"CH₂"}],integration:4,from:3.34875,to:3.41125}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.51,assignment:"CH₂",multiplicity:"m"}],integration:4,from:3.485,to:3.5349999999999997},{signals:[{js:[],delta:3.38,assignment:"CH₂",multiplicity:"m"}],integration:4,from:3.355,to:3.405},{signals:[{js:[],delta:3.24,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.2350000000000003,to:3.245}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.95,multiplicity:"s",assignment:"CH"}],integration:1,from:7.945,to:7.955},{signals:[{js:[],delta:2.89,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.8850000000000002,to:2.895},{signals:[{js:[],delta:2.73,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.725,to:2.735}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.57,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.565,to:3.5749999999999997}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.24,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.2350000000000003,to:3.245},{signals:[{js:[],delta:3.43,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.4250000000000003,to:3.435}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.82,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.815,to:.825}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.06,assignment:"CH₃"}],integration:3,from:1.0375,to:1.0825},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.44,assignment:"CH₂"}],integration:2,from:3.40875,to:3.47125},{signals:[{js:[],delta:4.63,multiplicity:"s",assignment:"OH"}],integration:1,from:4.625,to:4.635}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:1.99,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:1.985,to:1.9949999999999999},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:4.03,assignment:"CH₂CH₃"}],integration:2,from:3.9987500000000002,to:4.06125},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.17,assignment:"CH₂CH₃"}],integration:3,from:1.1475,to:1.1925}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.41,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.405,to:5.415}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.34,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.335,to:3.3449999999999998}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["H greaseᶠ"],smiles:"",ranges:[{signals:[],integration:6,from:.82,to:.88,multiplicity:"m"},{signals:[{js:[],delta:1.24,multiplicity:"br s",assignment:"CH₂"}],integration:10,from:1.22625,to:1.25375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.14,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.1350000000000002,to:2.145}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.86,assignment:"CH₃"}],integration:6,from:.8375,to:.8825},{signals:[{js:[],delta:1.25,assignment:"CH₂",multiplicity:"m"}],integration:8,from:1.225,to:1.275}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.06,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.055,to:.065}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.53,assignment:"CH₃"}],integration:18,from:2.5131249999999996,to:2.546875}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.61,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.605,to:4.615}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.63,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.625,to:7.635},{signals:[{js:[],delta:7.01,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:7.005,to:7.015}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.2,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.195,to:.20500000000000002}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.16,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.1550000000000002,to:3.165},{signals:[{js:[],delta:4.01,multiplicity:"s",assignment:"OH"}],integration:1,from:4.005,to:4.015}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:4.42,multiplicity:"s",assignment:"CH₃"}],integration:3,from:4.415,to:4.425}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.86,assignment:"CH₃"}],integration:6,from:.8375,to:.8825},{signals:[{js:[],delta:1.27,assignment:"CH₂",multiplicity:"m"}],integration:6,from:1.245,to:1.295}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.87,assignment:"CH₃"}],integration:6,from:.84675,to:.89325},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.29,assignment:"CH₂"}],integration:2,from:1.23025,to:1.34975}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:1.04,assignment:"CH₃"}],integration:6,from:1.0275,to:1.0525},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:3.78,assignment:"CH"}],integration:1,from:3.73,to:3.8299999999999996}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.68,assignment:"CH₃"}],integration:3,from:1.66325,to:1.69675},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.94,assignment:"CH₂(1)"}],integration:1,from:4.9225,to:4.9575000000000005},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:5.03,assignment:"CH₂(2)"}],integration:1,from:5.00375,to:5.05625},{signals:[{js:[],delta:5.8,assignment:"CH",multiplicity:"m"}],integration:1,from:5.7749999999999995,to:5.825}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.58,assignment:"CH(2,6)",multiplicity:"m"}],integration:2,from:8.555,to:8.605},{signals:[{js:[],delta:7.39,assignment:"CH(3,5)",multiplicity:"m"}],integration:2,from:7.364999999999999,to:7.415},{signals:[{js:[],delta:7.79,assignment:"CH(4)",multiplicity:"m"}],integration:1,from:7.765,to:7.815}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:10.75,assignment:"NH",multiplicity:"br t"}],integration:1,from:10.745,to:10.755},{signals:[{js:[],delta:6.73,assignment:"CH(2,5)",multiplicity:"m"}],integration:2,from:6.705,to:6.755000000000001},{signals:[{js:[],delta:6.01,assignment:"CH(3,4)",multiplicity:"m"}],integration:2,from:5.984999999999999,to:6.035}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:2.67,assignment:"CH₂(2,5)",multiplicity:"m"}],integration:4,from:2.645,to:2.695},{signals:[{js:[],delta:1.55,assignment:"CH₂(3,4)",multiplicity:"m"}],integration:4,from:1.5250000000000001,to:1.575}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:-.06,multiplicity:"s",assignment:"CH₃"}],integration:6,from:-.065,to:-.055}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.6,assignment:"CH₂(2,5)",multiplicity:"m"}],integration:4,from:3.575,to:3.625},{signals:[{js:[],delta:1.76,assignment:"CH₂(3,4)",multiplicity:"m"}],integration:4,from:1.735,to:1.785}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.3,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.295,to:2.3049999999999997},{signals:[{js:[],delta:7.18,assignment:"CH(2,4,6)",multiplicity:"m"}],integration:3,from:7.154999999999999,to:7.205},{signals:[{js:[],delta:7.25,assignment:"CH(3,5)",multiplicity:"m"}],integration:2,from:7.225,to:7.275}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.93,assignment:"CH₃"}],integration:6,from:.9075000000000001,to:.9525},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.43,assignment:"CH₂"}],integration:4,from:2.39875,to:2.46125}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:2.13,multiplicity:"s",assignment:"OH"}],integration:2,from:2.125,to:2.135}],nucleus:"1H",solvent:"CD₃CN"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:1.96,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.955,to:1.9649999999999999}],nucleus:"1H",solvent:"CD₃CN"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:2.08,multiplicity:"s",assignment:"CH₃"}],integration:6,from:2.075,to:2.085}],nucleus:"1H",solvent:"CD₃CN"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:1.96,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.955,to:1.9649999999999999}],nucleus:"1H",solvent:"CD₃CN"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.37,multiplicity:"s",assignment:"CH"}],integration:6,from:7.365,to:7.375}],nucleus:"1H",solvent:"CD₃CN"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.16,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.155,to:1.1649999999999998},{signals:[{js:[],delta:2.18,multiplicity:"s",assignment:"OH"}],integration:1,from:2.1750000000000003,to:2.185}],nucleus:"1H",solvent:"CD₃CN"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:7.58,multiplicity:"s",assignment:"CH"}],integration:1,from:7.575,to:7.585}],nucleus:"1H",solvent:"CD₃CN"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.51,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.505,to:3.5149999999999997}],nucleus:"1H",solvent:"CD₃CN"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.44,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.435,to:1.4449999999999998}],nucleus:"1H",solvent:"CD₃CN"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:3.81,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.805,to:3.815}],nucleus:"1H",solvent:"CD₃CN"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:5.44,multiplicity:"s",assignment:"CH₂"}],integration:2,from:5.4350000000000005,to:5.445}],nucleus:"1H",solvent:"CD₃CN"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.12,assignment:"CH₃"}],integration:6,from:1.0975000000000001,to:1.1425},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.42,assignment:"CH₂"}],integration:4,from:3.38875,to:3.45125}],nucleus:"1H",solvent:"CD₃CN"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.53,assignment:"CH₂",multiplicity:"m"}],integration:4,from:3.505,to:3.5549999999999997},{signals:[{js:[],delta:3.45,assignment:"CH₂",multiplicity:"m"}],integration:4,from:3.4250000000000003,to:3.475},{signals:[{js:[],delta:3.29,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.285,to:3.295}],nucleus:"1H",solvent:"CD₃CN"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.92,multiplicity:"s",assignment:"CH"}],integration:1,from:7.915,to:7.925},{signals:[{js:[],delta:2.89,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.8850000000000002,to:2.895},{signals:[{js:[],delta:2.77,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.765,to:2.775}],nucleus:"1H",solvent:"CD₃CN"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.6,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.595,to:3.605}],nucleus:"1H",solvent:"CD₃CN"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.28,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.275,to:3.2849999999999997},{signals:[{js:[],delta:3.45,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.4450000000000003,to:3.455}],nucleus:"1H",solvent:"CD₃CN"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.85,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.845,to:.855}],nucleus:"1H",solvent:"CD₃CN"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.12,assignment:"CH₃"}],integration:3,from:1.0975000000000001,to:1.1425},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.54,assignment:"CH₂"}],integration:2,from:3.50875,to:3.57125},{signals:[{js:[],delta:2.47,multiplicity:"s",assignment:"OH"}],integration:1,from:2.4650000000000003,to:2.475}],nucleus:"1H",solvent:"CD₃CN"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:1.97,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:1.965,to:1.9749999999999999},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:4.06,assignment:"CH₂CH₃"}],integration:2,from:4.02875,to:4.09125},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.2,assignment:"CH₂CH₃"}],integration:3,from:1.1775,to:1.2225}],nucleus:"1H",solvent:"CD₃CN"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.41,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.405,to:5.415}],nucleus:"1H",solvent:"CD₃CN"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.51,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.505,to:3.5149999999999997}],nucleus:"1H",solvent:"CD₃CN"},{names:["H greaseᶠ"],smiles:"",ranges:[],nucleus:"1H",solvent:"CD₃CN"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.19,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.185,to:2.195}],nucleus:"1H",solvent:"CD₃CN"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.89,assignment:"CH₃"}],integration:6,from:.8675,to:.9125},{signals:[{js:[],delta:1.28,assignment:"CH₂",multiplicity:"m"}],integration:8,from:1.2550000000000001,to:1.305}],nucleus:"1H",solvent:"CD₃CN"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.07,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.065,to:.07500000000000001}],nucleus:"1H",solvent:"CD₃CN"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.57,assignment:"CH₃"}],integration:18,from:2.5531249999999996,to:2.586875}],nucleus:"1H",solvent:"CD₃CN"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.57,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.565,to:4.575}],nucleus:"1H",solvent:"CD₃CN"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.57,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.565,to:7.575},{signals:[{js:[],delta:7.01,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:7.005,to:7.015}],nucleus:"1H",solvent:"CD₃CN"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.2,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.195,to:.20500000000000002}],nucleus:"1H",solvent:"CD₃CN"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.28,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.275,to:3.2849999999999997},{signals:[{js:[],delta:2.16,multiplicity:"s",assignment:"OH"}],integration:1,from:2.1550000000000002,to:2.165}],nucleus:"1H",solvent:"CD₃CN"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:4.31,multiplicity:"s",assignment:"CH₃"}],integration:3,from:4.305,to:4.3149999999999995}],nucleus:"1H",solvent:"CD₃CN"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.89,assignment:"CH₃"}],integration:6,from:.8675,to:.9125},{signals:[{js:[],delta:1.29,assignment:"CH₂",multiplicity:"m"}],integration:6,from:1.2650000000000001,to:1.315}],nucleus:"1H",solvent:"CD₃CN"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.9,assignment:"CH₃"}],integration:6,from:.87675,to:.92325},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.33,assignment:"CH₂"}],integration:2,from:1.27025,to:1.38975}],nucleus:"1H",solvent:"CD₃CN"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:1.09,assignment:"CH₃"}],integration:6,from:1.0775000000000001,to:1.1025},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:3.87,assignment:"CH"}],integration:1,from:3.8200000000000003,to:3.92}],nucleus:"1H",solvent:"CD₃CN"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.7,assignment:"CH₃"}],integration:3,from:1.68325,to:1.71675},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.93,assignment:"CH₂(1)"}],integration:1,from:4.9125,to:4.9475},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:5.04,assignment:"CH₂(2)"}],integration:1,from:5.01375,to:5.06625},{signals:[{js:[],delta:5.85,assignment:"CH",multiplicity:"m"}],integration:1,from:5.824999999999999,to:5.875}],nucleus:"1H",solvent:"CD₃CN"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.57,assignment:"CH(2,6)",multiplicity:"m"}],integration:2,from:8.545,to:8.595},{signals:[{js:[],delta:7.33,assignment:"CH(3,5)",multiplicity:"m"}],integration:2,from:7.305,to:7.355},{signals:[{js:[],delta:7.73,assignment:"CH(4)",multiplicity:"m"}],integration:1,from:7.705,to:7.755000000000001}],nucleus:"1H",solvent:"CD₃CN"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:9.27,assignment:"NH",multiplicity:"br t"}],integration:1,from:9.264999999999999,to:9.275},{signals:[{js:[],delta:6.75,assignment:"CH(2,5)",multiplicity:"m"}],integration:2,from:6.725,to:6.775},{signals:[{js:[],delta:6.1,assignment:"CH(3,4)",multiplicity:"m"}],integration:2,from:6.074999999999999,to:6.125}],nucleus:"1H",solvent:"CD₃CN"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:2.75,assignment:"CH₂(2,5)",multiplicity:"m"}],integration:4,from:2.725,to:2.775},{signals:[{js:[],delta:1.61,assignment:"CH₂(3,4)",multiplicity:"m"}],integration:4,from:1.5850000000000002,to:1.635}],nucleus:"1H",solvent:"CD₃CN"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:.08,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.075,to:.085}],nucleus:"1H",solvent:"CD₃CN"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.64,assignment:"CH₂(2,5)",multiplicity:"m"}],integration:4,from:3.615,to:3.665},{signals:[{js:[],delta:1.8,assignment:"CH₂(3,4)",multiplicity:"m"}],integration:4,from:1.7750000000000001,to:1.825}],nucleus:"1H",solvent:"CD₃CN"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.33,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.325,to:2.335},{signals:[],integration:3,from:7.1,to:7.3,multiplicity:"m"},{signals:[],integration:2,from:7.1,to:7.3,multiplicity:"m"}],nucleus:"1H",solvent:"CD₃CN"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.96,assignment:"CH₃"}],integration:6,from:.9375,to:.9824999999999999},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.45,assignment:"CH₂"}],integration:4,from:2.41875,to:2.48125}],nucleus:"1H",solvent:"CD₃CN"},{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:3.66,multiplicity:"s",assignment:"OH"}],integration:2,from:3.6550000000000002,to:3.665}],nucleus:"1H",solvent:"TFE-d₃"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:2.06,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.055,to:2.065}],nucleus:"1H",solvent:"TFE-d₃"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:2.19,multiplicity:"s",assignment:"CH₃"}],integration:6,from:2.185,to:2.195}],nucleus:"1H",solvent:"TFE-d₃"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:1.95,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.945,to:1.9549999999999998}],nucleus:"1H",solvent:"TFE-d₃"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.36,multiplicity:"s",assignment:"CH"}],integration:6,from:7.355,to:7.365}],nucleus:"1H",solvent:"TFE-d₃"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.28,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.2750000000000001,to:1.285},{signals:[{js:[],delta:2.2,multiplicity:"s",assignment:"OH"}],integration:1,from:2.1950000000000003,to:2.205}],nucleus:"1H",solvent:"TFE-d₃"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:7.33,multiplicity:"s",assignment:"CH"}],integration:1,from:7.325,to:7.335}],nucleus:"1H",solvent:"TFE-d₃"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.64,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.6350000000000002,to:3.645}],nucleus:"1H",solvent:"TFE-d₃"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.47,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.465,to:1.4749999999999999}],nucleus:"1H",solvent:"TFE-d₃"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:3.71,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.705,to:3.715}],nucleus:"1H",solvent:"TFE-d₃"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:5.24,multiplicity:"s",assignment:"CH₂"}],integration:2,from:5.235,to:5.245}],nucleus:"1H",solvent:"TFE-d₃"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.2,assignment:"CH₃"}],integration:6,from:1.1775,to:1.2225},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.58,assignment:"CH₂"}],integration:4,from:3.54875,to:3.61125}],nucleus:"1H",solvent:"TFE-d₃"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.67,assignment:"CH₂",multiplicity:"m"}],integration:4,from:3.645,to:3.695},{signals:[{js:[],delta:3.62,assignment:"CH₂",multiplicity:"m"}],integration:4,from:3.595,to:3.645},{signals:[{js:[],delta:3.41,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.4050000000000002,to:3.415}],nucleus:"1H",solvent:"TFE-d₃"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.86,multiplicity:"s",assignment:"CH"}],integration:1,from:7.855,to:7.865},{signals:[{js:[],delta:2.98,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.975,to:2.985},{signals:[{js:[],delta:2.88,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.875,to:2.885}],nucleus:"1H",solvent:"TFE-d₃"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.76,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.755,to:3.7649999999999997}],nucleus:"1H",solvent:"TFE-d₃"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.4,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.395,to:3.405},{signals:[{js:[],delta:3.61,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.605,to:3.6149999999999998}],nucleus:"1H",solvent:"TFE-d₃"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.85,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.845,to:.855}],nucleus:"1H",solvent:"TFE-d₃"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.22,assignment:"CH₃"}],integration:3,from:1.1975,to:1.2425},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.71,assignment:"CH₂"}],integration:2,from:3.67875,to:3.74125}],nucleus:"1H",solvent:"TFE-d₃"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:2.03,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:2.025,to:2.0349999999999997},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:4.14,assignment:"CH₂CH₃"}],integration:2,from:4.10875,to:4.17125},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.26,assignment:"CH₂CH₃"}],integration:3,from:1.2375,to:1.2825}],nucleus:"1H",solvent:"TFE-d₃"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.4,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.3950000000000005,to:5.405}],nucleus:"1H",solvent:"TFE-d₃"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.72,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.7150000000000003,to:3.725}],nucleus:"1H",solvent:"TFE-d₃"},{names:["H greaseᶠ"],smiles:"",ranges:[{signals:[],integration:6,from:.88,to:.94,multiplicity:"m"},{signals:[{js:[],delta:1.33,multiplicity:"br s",assignment:"CH₂"}],integration:10,from:1.3162500000000001,to:1.34375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.24,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.2350000000000003,to:2.245}],nucleus:"1H",solvent:"TFE-d₃"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.91,assignment:"CH₃"}],integration:6,from:.8875000000000001,to:.9325},{signals:[{js:[],delta:1.31,assignment:"CH₂",multiplicity:"m"}],integration:8,from:1.2850000000000001,to:1.335}],nucleus:"1H",solvent:"TFE-d₃"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.08,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.075,to:.085}],nucleus:"1H",solvent:"TFE-d₃"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.63,assignment:"CH₃"}],integration:18,from:2.6131249999999997,to:2.646875}],nucleus:"1H",solvent:"TFE-d₃"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.53,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.525,to:4.535}],nucleus:"1H",solvent:"TFE-d₃"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.61,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.605,to:7.615},{signals:[{js:[],delta:7.03,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:7.025,to:7.035}],nucleus:"1H",solvent:"TFE-d₃"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.18,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.175,to:.185}],nucleus:"1H",solvent:"TFE-d₃"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.44,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.435,to:3.445}],nucleus:"1H",solvent:"TFE-d₃"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:4.28,multiplicity:"s",assignment:"CH₃"}],integration:3,from:4.275,to:4.285}],nucleus:"1H",solvent:"TFE-d₃"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.9,assignment:"CH₃"}],integration:6,from:.8775000000000001,to:.9225},{signals:[{js:[],delta:1.33,assignment:"CH₂",multiplicity:"m"}],integration:6,from:1.3050000000000002,to:1.355}],nucleus:"1H",solvent:"TFE-d₃"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.9,assignment:"CH₃"}],integration:6,from:.87675,to:.92325},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.33,assignment:"CH₂"}],integration:2,from:1.27025,to:1.38975}],nucleus:"1H",solvent:"TFE-d₃"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:1.2,assignment:"CH₃"}],integration:6,from:1.1875,to:1.2125},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:4.05,assignment:"CH"}],integration:1,from:4,to:4.1}],nucleus:"1H",solvent:"TFE-d₃"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.7,assignment:"CH₃"}],integration:3,from:1.68325,to:1.71675},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.93,assignment:"CH₂(1)"}],integration:1,from:4.9125,to:4.9475},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:5.03,assignment:"CH₂(2)"}],integration:1,from:5.00375,to:5.05625},{signals:[{js:[],delta:5.87,assignment:"CH",multiplicity:"m"}],integration:1,from:5.845,to:5.8950000000000005}],nucleus:"1H",solvent:"TFE-d₃"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.45,assignment:"CH(2,6)",multiplicity:"m"}],integration:2,from:8.424999999999999,to:8.475},{signals:[{js:[],delta:7.4,assignment:"CH(3,5)",multiplicity:"m"}],integration:2,from:7.375,to:7.425000000000001},{signals:[{js:[],delta:7.82,assignment:"CH(4)",multiplicity:"m"}],integration:1,from:7.795,to:7.845000000000001}],nucleus:"1H",solvent:"TFE-d₃"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:6.84,assignment:"CH(2,5)",multiplicity:"m"}],integration:2,from:6.8149999999999995,to:6.865},{signals:[{js:[],delta:6.24,assignment:"CH(3,4)",multiplicity:"m"}],integration:2,from:6.215,to:6.265000000000001}],nucleus:"1H",solvent:"TFE-d₃"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:3.11,assignment:"CH₂(2,5)",multiplicity:"m"}],integration:4,from:3.085,to:3.135},{signals:[{js:[],delta:1.93,assignment:"CH₂(3,4)",multiplicity:"m"}],integration:4,from:1.905,to:1.9549999999999998}],nucleus:"1H",solvent:"TFE-d₃"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:.16,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.155,to:.165}],nucleus:"1H",solvent:"TFE-d₃"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.78,assignment:"CH₂(2,5)",multiplicity:"m"}],integration:4,from:3.755,to:3.8049999999999997},{signals:[{js:[],delta:1.91,assignment:"CH₂(3,4)",multiplicity:"m"}],integration:4,from:1.885,to:1.9349999999999998}],nucleus:"1H",solvent:"TFE-d₃"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.33,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.325,to:2.335},{signals:[],integration:3,from:7.1,to:7.3,multiplicity:"m"},{signals:[],integration:2,from:7.1,to:7.3,multiplicity:"m"}],nucleus:"1H",solvent:"TFE-d₃"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.31,assignment:"CH₃"}],integration:6,from:1.2875,to:1.3325},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.12,assignment:"CH₂"}],integration:4,from:3.08875,to:3.15125}],nucleus:"1H",solvent:"TFE-d₃"},{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:4.87,multiplicity:"s",assignment:"OH"}],integration:2,from:4.865,to:4.875}],nucleus:"1H",solvent:"CD₃OD"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:1.99,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.985,to:1.9949999999999999}],nucleus:"1H",solvent:"CD₃OD"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:2.15,multiplicity:"s",assignment:"CH₃"}],integration:6,from:2.145,to:2.155}],nucleus:"1H",solvent:"CD₃OD"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:2.03,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.025,to:2.0349999999999997}],nucleus:"1H",solvent:"CD₃OD"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.33,multiplicity:"s",assignment:"CH"}],integration:6,from:7.325,to:7.335}],nucleus:"1H",solvent:"CD₃OD"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.4,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.395,to:1.4049999999999998}],nucleus:"1H",solvent:"CD₃OD"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:7.9,multiplicity:"s",assignment:"CH"}],integration:1,from:7.8950000000000005,to:7.905}],nucleus:"1H",solvent:"CD₃OD"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.64,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.6350000000000002,to:3.645}],nucleus:"1H",solvent:"CD₃OD"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.45,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.445,to:1.4549999999999998}],nucleus:"1H",solvent:"CD₃OD"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:3.78,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.775,to:3.7849999999999997}],nucleus:"1H",solvent:"CD₃OD"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:5.49,multiplicity:"s",assignment:"CH₂"}],integration:2,from:5.485,to:5.495}],nucleus:"1H",solvent:"CD₃OD"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.18,assignment:"CH₃"}],integration:6,from:1.1575,to:1.2025},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.49,assignment:"CH₂"}],integration:4,from:3.45875,to:3.52125}],nucleus:"1H",solvent:"CD₃OD"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.61,assignment:"CH₂",multiplicity:"m"}],integration:4,from:3.585,to:3.635},{signals:[{js:[],delta:3.58,assignment:"CH₂",multiplicity:"m"}],integration:4,from:3.555,to:3.605},{signals:[{js:[],delta:3.35,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.345,to:3.355}],nucleus:"1H",solvent:"CD₃OD"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.97,multiplicity:"s",assignment:"CH"}],integration:1,from:7.965,to:7.975},{signals:[{js:[],delta:2.99,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.9850000000000003,to:2.995},{signals:[{js:[],delta:2.86,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.855,to:2.8649999999999998}],nucleus:"1H",solvent:"CD₃OD"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.66,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.6550000000000002,to:3.665}],nucleus:"1H",solvent:"CD₃OD"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.35,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.345,to:3.355},{signals:[{js:[],delta:3.52,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.515,to:3.525}],nucleus:"1H",solvent:"CD₃OD"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.85,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.845,to:.855}],nucleus:"1H",solvent:"CD₃OD"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.19,assignment:"CH₃"}],integration:3,from:1.1675,to:1.2125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.6,assignment:"CH₂"}],integration:2,from:3.56875,to:3.63125}],nucleus:"1H",solvent:"CD₃OD"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:2.01,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:2.005,to:2.0149999999999997},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:4.09,assignment:"CH₂CH₃"}],integration:2,from:4.05875,to:4.12125},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.24,assignment:"CH₂CH₃"}],integration:3,from:1.2175,to:1.2625}],nucleus:"1H",solvent:"CD₃OD"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.39,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.385,to:5.395}],nucleus:"1H",solvent:"CD₃OD"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.59,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.585,to:3.5949999999999998}],nucleus:"1H",solvent:"CD₃OD"},{names:["H greaseᶠ"],smiles:"",ranges:[{signals:[],integration:6,from:.86,to:.93,multiplicity:"m"},{signals:[{js:[],delta:1.29,multiplicity:"br s",assignment:"CH₂"}],integration:10,from:1.27625,to:1.30375}],nucleus:"1H",solvent:"CD₃OD"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.19,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.185,to:2.195}],nucleus:"1H",solvent:"CD₃OD"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.9,assignment:"CH₃"}],integration:6,from:.8775000000000001,to:.9225},{signals:[{js:[],delta:1.29,assignment:"CH₂",multiplicity:"m"}],integration:8,from:1.2650000000000001,to:1.315}],nucleus:"1H",solvent:"CD₃OD"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.07,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.065,to:.07500000000000001}],nucleus:"1H",solvent:"CD₃OD"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.64,assignment:"CH₃"}],integration:18,from:2.623125,to:2.6568750000000003}],nucleus:"1H",solvent:"CD₃OD"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.56,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.555,to:4.5649999999999995}],nucleus:"1H",solvent:"CD₃OD"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.67,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.665,to:7.675},{signals:[{js:[],delta:7.05,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:7.045,to:7.055}],nucleus:"1H",solvent:"CD₃OD"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.2,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.195,to:.20500000000000002}],nucleus:"1H",solvent:"CD₃OD"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.34,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.335,to:3.3449999999999998}],nucleus:"1H",solvent:"CD₃OD"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:4.34,multiplicity:"s",assignment:"CH₃"}],integration:3,from:4.335,to:4.345}],nucleus:"1H",solvent:"CD₃OD"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.9,assignment:"CH₃"}],integration:6,from:.8775000000000001,to:.9225},{signals:[{js:[],delta:1.29,assignment:"CH₂",multiplicity:"m"}],integration:6,from:1.2650000000000001,to:1.315}],nucleus:"1H",solvent:"CD₃OD"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.91,assignment:"CH₃"}],integration:6,from:.88675,to:.93325},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.34,assignment:"CH₂"}],integration:2,from:1.28025,to:1.39975}],nucleus:"1H",solvent:"CD₃OD"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:1.5,assignment:"CH₃"}],integration:6,from:1.4875,to:1.5125},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:3.92,assignment:"CH"}],integration:1,from:3.87,to:3.9699999999999998}],nucleus:"1H",solvent:"CD₃OD"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.7,assignment:"CH₃"}],integration:3,from:1.68325,to:1.71675},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.91,assignment:"CH₂(1)"}],integration:1,from:4.8925,to:4.9275},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:5.01,assignment:"CH₂(2)"}],integration:1,from:4.98375,to:5.03625},{signals:[{js:[],delta:5.82,assignment:"CH",multiplicity:"m"}],integration:1,from:5.795,to:5.845000000000001}],nucleus:"1H",solvent:"CD₃OD"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.53,assignment:"CH(2,6)",multiplicity:"m"}],integration:2,from:8.504999999999999,to:8.555},{signals:[{js:[],delta:7.44,assignment:"CH(3,5)",multiplicity:"m"}],integration:2,from:7.415,to:7.465000000000001},{signals:[{js:[],delta:7.85,assignment:"CH(4)",multiplicity:"m"}],integration:1,from:7.824999999999999,to:7.875}],nucleus:"1H",solvent:"CD₃OD"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:6.72,assignment:"CH(2,5)",multiplicity:"m"}],integration:2,from:6.694999999999999,to:6.745},{signals:[{js:[],delta:6.08,assignment:"CH(3,4)",multiplicity:"m"}],integration:2,from:6.055,to:6.105}],nucleus:"1H",solvent:"CD₃OD"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:2.8,assignment:"CH₂(2,5)",multiplicity:"m"}],integration:4,from:2.775,to:2.8249999999999997},{signals:[{js:[],delta:1.72,assignment:"CH₂(3,4)",multiplicity:"m"}],integration:4,from:1.695,to:1.7449999999999999}],nucleus:"1H",solvent:"CD₃OD"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:.1,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.095,to:.10500000000000001}],nucleus:"1H",solvent:"CD₃OD"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.71,assignment:"CH₂(2,5)",multiplicity:"m"}],integration:4,from:3.685,to:3.735},{signals:[{js:[],delta:1.87,assignment:"CH₂(3,4)",multiplicity:"m"}],integration:4,from:1.8450000000000002,to:1.895}],nucleus:"1H",solvent:"CD₃OD"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.32,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.315,to:2.3249999999999997},{signals:[{js:[],delta:7.16,assignment:"CH(2,4,6)",multiplicity:"m"}],integration:3,from:7.135,to:7.1850000000000005},{signals:[{js:[],delta:7.16,assignment:"CH(3,5)",multiplicity:"m"}],integration:2,from:7.135,to:7.1850000000000005}],nucleus:"1H",solvent:"CD₃OD"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.05,assignment:"CH₃"}],integration:6,from:1.0275,to:1.0725},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.58,assignment:"CH₂"}],integration:4,from:2.54875,to:2.61125}],nucleus:"1H",solvent:"CD₃OD"},{names:["water"],smiles:"O",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:2.08,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.075,to:2.085}],nucleus:"1H",solvent:"D₂O"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:2.22,multiplicity:"s",assignment:"CH₃"}],integration:6,from:2.2150000000000003,to:2.225}],nucleus:"1H",solvent:"D₂O"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:2.06,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.055,to:2.065}],nucleus:"1H",solvent:"D₂O"},{names:["benzene"],smiles:"c1ccccc1",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.24,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.235,to:1.2449999999999999}],nucleus:"1H",solvent:"D₂O"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.8,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.795,to:3.8049999999999997}],nucleus:"1H",solvent:"D₂O"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.17,assignment:"CH₃"}],integration:6,from:1.1475,to:1.1925},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.56,assignment:"CH₂"}],integration:4,from:3.52875,to:3.59125}],nucleus:"1H",solvent:"D₂O"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.67,assignment:"CH₂",multiplicity:"m"}],integration:4,from:3.645,to:3.695},{signals:[{js:[],delta:3.61,assignment:"CH₂",multiplicity:"m"}],integration:4,from:3.585,to:3.635},{signals:[{js:[],delta:3.37,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.365,to:3.375}],nucleus:"1H",solvent:"D₂O"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.92,multiplicity:"s",assignment:"CH"}],integration:1,from:7.915,to:7.925},{signals:[{js:[],delta:3.01,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.005,to:3.0149999999999997},{signals:[{js:[],delta:2.85,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.845,to:2.855}],nucleus:"1H",solvent:"D₂O"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.75,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.745,to:3.755}],nucleus:"1H",solvent:"D₂O"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.37,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.365,to:3.375},{signals:[{js:[],delta:3.6,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.595,to:3.605}],nucleus:"1H",solvent:"D₂O"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.82,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.815,to:.825}],nucleus:"1H",solvent:"D₂O"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.17,assignment:"CH₃"}],integration:3,from:1.1475,to:1.1925},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.65,assignment:"CH₂"}],integration:2,from:3.61875,to:3.68125}],nucleus:"1H",solvent:"D₂O"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:2.07,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:2.065,to:2.0749999999999997},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:4.14,assignment:"CH₂CH₃"}],integration:2,from:4.10875,to:4.17125},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.24,assignment:"CH₂CH₃"}],integration:3,from:1.2175,to:1.2625}],nucleus:"1H",solvent:"D₂O"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.44,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.4350000000000005,to:5.445}],nucleus:"1H",solvent:"D₂O"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.65,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.645,to:3.655}],nucleus:"1H",solvent:"D₂O"},{names:["H greaseᶠ"],smiles:"",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.28,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.275,to:.28500000000000003}],nucleus:"1H",solvent:"D₂O"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.61,assignment:"CH₃"}],integration:18,from:2.5931249999999997,to:2.626875}],nucleus:"1H",solvent:"D₂O"},{names:["hydrogen"],smiles:"",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.78,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.775,to:7.785},{signals:[{js:[],delta:7.14,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:7.135,to:7.145}],nucleus:"1H",solvent:"D₂O"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.18,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.175,to:.185}],nucleus:"1H",solvent:"D₂O"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.34,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.335,to:3.3449999999999998}],nucleus:"1H",solvent:"D₂O"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:4.4,multiplicity:"s",assignment:"CH₃"}],integration:3,from:4.3950000000000005,to:4.405}],nucleus:"1H",solvent:"D₂O"},{names:["n-pentane"],smiles:"CCCCC",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.88,assignment:"CH₃"}],integration:6,from:.85675,to:.90325},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.3,assignment:"CH₂"}],integration:2,from:1.24025,to:1.35975}],nucleus:"1H",solvent:"D₂O"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:1.17,assignment:"CH₃"}],integration:6,from:1.1575,to:1.1824999999999999},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:4.02,assignment:"CH"}],integration:1,from:3.9699999999999998,to:4.069999999999999}],nucleus:"1H",solvent:"D₂O"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.7,assignment:"CH₃"}],integration:3,from:1.68325,to:1.71675},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.95,assignment:"CH₂(1)"}],integration:1,from:4.9325,to:4.9675},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:5.06,assignment:"CH₂(2)"}],integration:1,from:5.0337499999999995,to:5.08625},{signals:[{js:[],delta:5.9,assignment:"CH",multiplicity:"m"}],integration:1,from:5.875,to:5.925000000000001}],nucleus:"1H",solvent:"D₂O"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.52,assignment:"CH(2,6)",multiplicity:"m"}],integration:2,from:8.495,to:8.545},{signals:[{js:[],delta:7.45,assignment:"CH(3,5)",multiplicity:"m"}],integration:2,from:7.425,to:7.4750000000000005},{signals:[{js:[],delta:7.87,assignment:"CH(4)",multiplicity:"m"}],integration:1,from:7.845,to:7.8950000000000005}],nucleus:"1H",solvent:"D₂O"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:6.93,assignment:"CH(2,5)",multiplicity:"m"}],integration:2,from:6.904999999999999,to:6.955},{signals:[{js:[],delta:6.26,assignment:"CH(3,4)",multiplicity:"m"}],integration:2,from:6.234999999999999,to:6.285}],nucleus:"1H",solvent:"D₂O"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:3.07,assignment:"CH₂(2,5)",multiplicity:"m"}],integration:4,from:3.045,to:3.0949999999999998},{signals:[{js:[],delta:1.87,assignment:"CH₂(3,4)",multiplicity:"m"}],integration:4,from:1.8450000000000002,to:1.895}],nucleus:"1H",solvent:"D₂O"},{names:["silicone grease"],smiles:"",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.74,assignment:"CH₂(2,5)",multiplicity:"m"}],integration:4,from:3.7150000000000003,to:3.765},{signals:[{js:[],delta:1.88,assignment:"CH₂(3,4)",multiplicity:"m"}],integration:4,from:1.855,to:1.9049999999999998}],nucleus:"1H",solvent:"D₂O"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.99,assignment:"CH₃"}],integration:6,from:.9675,to:1.0125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.57,assignment:"CH₂"}],integration:4,from:2.53875,to:2.60125}],nucleus:"1H",solvent:"D₂O"}];function getShortestPath(t){let{currUnAssCol:e,dualVariableForColumns:n,dualVariableForRows:s,rowAssignments:i,columnAssignments:o,matrix:a}=t,r=a.rows,l=a.columns,m=new Float64Array(r),c=new Float64Array(l),u=new Float64Array(r),g=Array.from(xSequentialFill({from:0,to:r-1})),C=r,f=-1,p=0,h=e,d=new Array(r).fill(Number.POSITIVE_INFINITY);for(;-1===f;){c[h]=1;let t=Number.POSITIVE_INFINITY,e=-1;for(let i=0;i<C;i++){let o=g[i],r=p+a.get(o,h)-n[h]-s[o];r<d[o]&&(m[o]=h,d[o]=r),d[o]<t&&(t=d[o],e=i)}if(!Number.isFinite(t))return{dualVariableForColumns:n,dualVariableForRows:s,sink:f,pred:m};let o=g[e];u[o]=1,C-=1,g.splice(e,1),p=d[o],-1===i[o]?f=o:h=i[o]}n[e]+=p;for(let t=0;t<l;t++)0!==c[t]&&t!==e&&(n[t]+=p-d[o[t]]);for(let t=0;t<r;t++)0!==u[t]&&(s[t]-=p-d[t]);return{sink:f,pred:m,dualVariableForColumns:n,dualVariableForRows:s}}function linearSumAssignment(t,e={}){const{maximaze:n=!0}=e;let s=Matrix.checkMatrix(t),i=!1;s.columns>s.rows&&(i=!0,s=s.transpose());let o=s.rows,a=s.columns,r=n?s.max():s.min();s=s.subtract(r),n&&(s=s.mul(-1));let l=new Float64Array(o).fill(-1),m=new Float64Array(a).fill(-1),c=new Float64Array(a),u=new Float64Array(o);for(let t=0;t<a;t++){let e=getShortestPath({matrix:s,currUnAssCol:t,dualVariableForColumns:c,dualVariableForRows:u,rowAssignments:l,columnAssignments:m}),{sink:n,pred:i}=e;if(-1===n)return{rowAssignments:l,columnAssignments:m,gain:-1,dualVariableForColumns:c,dualVariableForRows:u};c=e.dualVariableForColumns,u=e.dualVariableForRows;let o=n;for(let e=i[o];;e=i[o]){l[o]=e;let n=m[e];if(m[e]=o,o=n,e===t)break}}let g=0;for(let t=0;t<a;t++)g+=s.get(m[t],t);return g=(n?-1:1)*g+r*a,i&&([m,l]=[l,m],[c,u]=[u,c]),{rowAssignments:l,columnAssignments:m,gain:g,dualVariableForColumns:c,dualVariableForRows:u}}const{stringify:stringify,parse:parse}=JSON;function cloneArray(t){return parse(stringify(t))}function solventSuppression(t,e,n={}){const s=cloneArray(t).sort(((t,e)=>t.x-e.x)),i=s.map((t=>t.x)),{markSolventPeaks:o=!1,solventZoneExtension:a=1.2}=n;for(const t of e){const e=t.peaks?t.peaks:getSolventPeaks(t);e.sort(((t,e)=>t.x-e.x));const n=xFindClosestIndex(i,e[e.length-1].x+a),r=xFindClosestIndex(i,e[0].x-a),l=s.filter(((t,e)=>e>=r&&e<=n)),m=[],c=[],u=[];for(const n of l){const{peaks:s,delta:i}=getShiftedSolventPeaks(n,t,e),o=getClosestPeaks(s,l);let a=0,r=0,g=0;for(let t=0;t<o.length;t++)r+=Math.abs(s[t].y-o[t].y),a+=Math.abs(s[t].x-o[t].x);0===o.length?(a=Number.MAX_SAFE_INTEGER,r=Number.MAX_SAFE_INTEGER,g=Number.MAX_SAFE_INTEGER):g=gaussianFct(Math.abs(t.delta-i),.5),m.push(r),c.push(a),u.push(g)}const[g,C,f]=[m,c,u].map((t=>{const e=xMaxValue(t);return 0===e?1:e}));let p=-1,h=Number.MAX_SAFE_INTEGER;for(let t=0;t<c.length;t++){const e=(m[t]/g+c[t]/C+1-u[t]/f)/3;h>e&&(p=t,h=e)}if(h<0||p<0)return s;const{peaks:d}=getShiftedSolventPeaks(l[p],t,e),y=getDiffMatrix(d,l),{rowAssignments:H,gain:b}=linearSumAssignment(y,{maximaze:!1});if(b<0)return s;if(o)for(const t of H)s[t+r].kind="solvent";else{H.sort(((t,e)=>e-t));for(const t of H)s.splice(t+r,1)}}return s}function getSolventPeaks(t,e={}){const n=signalsToSpinSystem(addDummySignals([t])),{frequency:s=400,maxClusterSize:i=8}=e;n.clusters=splitSpinSystem(n,{frequency:s,maxClusterSize:i});return simulateXYPeaks(n).filter((t=>t.x<1e3))}function getShiftedSolventPeaks(t,e,n){const s=JSON.parse(JSON.stringify(n));let i=t.x-e.delta;n.length>1&&n.length%2==0&&(i+=n[0].x);const o=s.reduce(((t,e)=>e.y>t?e.y:t),s[0].y);let a=0;for(const t of s)t.x+=i,t.y/=o,a+=t.x;return{peaks:s,delta:a/s.length}}function getClosestPeaks(t,e){const n=getDiffMatrix(t,e),{rowAssignments:s,gain:i}=linearSumAssignment(n,{maximaze:!1});if(-1===i)return[];const o=[];let a=Number.MIN_SAFE_INTEGER;for(const t of s)a<e[t].y&&(a=e[t].y),o.push({...e[t]});return o.forEach(((t,e,n)=>n[e].y/=a)),o}function getDiffMatrix(t,e){const n=e.length,s=t.length,i=new Matrix(s,n);for(let o=0;o<s;o++)for(let s=0;s<n;s++)i.set(o,s,Math.abs(t[o].x-e[s].x));return i}function markSolventPeaks(t,e,n={}){const{frequency:s=400}=n,i=addIDs(cloneArray(t)),o=[];for(const t of i){const e=t.id;for(const n of t.signals||[]){const t=n.id;for(const s of n.peaks||[])o.push({...s,rangeID:e,signalID:t})}}const a=solventSuppression(o,e,{markSolventPeaks:!0}),r=getSignalIDsWithSolvent(a);for(const t of i)if(t.signals)for(const e of t.signals){if(!r.includes(e.id))continue;const n=[],i=[];for(const t of a)if(t.signalID===e.id){const{signalID:e,rangeID:s,...o}=t;"solvent"===t.kind?i.push(o):n.push(o)}const o=n.length>0?detectSignals({x:[],y:[]},n,{integralType:"peak",frequency:s}):[];i.sort(((t,e)=>t.x-e.x));const l=i[0].x,m=detectSignals({x:[],y:[]},i,{integralType:"peak",frequencyCluster:(i[i.length-1].x-l)*s,frequency:s});t.signals=[...adaptSignals(o),...adaptSignals(m),...t.signals.filter((t=>t.id!==e.id))]}return i}function getSignalIDsWithSolvent(t){const e=new Set;for(const n of t)"solvent"===n.kind&&e.add(n.signalID);return Array.from(e)}function adaptSignals(t){const e=[];for(const n of t){const t={id:v4(),delta:n.delta,kind:n.kind||"signal",multiplicity:n.multiplicity,integration:n.integralData.value};t.peaks=n.peaks.map((t=>{const e={y:t.intensity,...t};return delete e.intensity,e})),t.js=n.nmrJs||[],e.push(t)}return e}function findMultiplet(t){return MultiplicityPatterns.find((e=>{const{label:n,value:s,names:i}=e;return[n,s,...i].includes(t.replace(/\./,""))}))}function checkMultiplet(t,e=[]){const n=findMultiplet(t);return n&&!e.includes(n.label)&&!e.includes(n.value)&&!n.names.some((t=>e.includes(t)))}function checkMultiplicity(t,e=[]){if(void 0===t||0===t.length)return!1;const n=splitPatterns(t);return n.join("").length===t.length&&n.every((t=>checkMultiplet(t,e)))}function translateMultiplet(t){const e=findMultiplet(t);if(!e)throw new Error(`multiplet ${t} is not supported`);const{value:n,label:s}=e;return t===s?n:s}function apodizationFilter(t,e){const{lineBroadening:n,gaussBroadening:s,lineBroadeningCenter:i}=e,o=t.info?.digitalFilter||0,a=o>0?Math.floor(o):0,r=t.data.re,l=t.data.im,m=t.data.x,c=r.length;return apodization$1({re:r,im:l},{pointsToShift:a,compose:{length:c,shapes:[{start:0,shape:{kind:"lorentzToGauss",options:{length:c,dw:(m[c-1]-m[0])/(c-1),exponentialHz:s>0?n:-n,gaussianHz:s,center:i}}}]}})}const id$d="apodization",name$d="Apodization",DOMAIN_UPDATE_RULES$d={updateXDomain:!0,updateYDomain:!1};function apply$f(t,e){if(!isApplicable$d(t))throw new Error("apodization not applicable on this data");const{lineBroadening:n=1,gaussBroadening:s=0,lineBroadeningCenter:i=0}=e;if(0===Object.keys(e).length){const e=t.filters?.find((t=>t.name===id$d));e&&(e.value={lineBroadening:n,gaussBroadening:s,lineBroadeningCenter:i})}const o=apodizationFilter(t,{lineBroadening:n,gaussBroadening:s,lineBroadeningCenter:i});t.data={...t.data,re:o.re,im:o.im}}function isApplicable$d(t){return!(!t.info.isComplex||!t.info.isFid)}function reduce$d(t,e){return{once:!0,reduce:e}}var apodization=Object.freeze({__proto__:null,id:id$d,name:name$d,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$d,apply:apply$f,isApplicable:isApplicable$d,reduce:reduce$d});function ldlSymbolic(t,e,n,s,i,o,a){let r,l,m,c,u;for(l=0;l<t;l++)for(i[l]=-1,a[l]=l,o[l]=0,c=l,u=e[c+1],m=e[c];m<u;m++)if(r=n[m],r<l)for(;a[r]!==l;r=i[r])-1===i[r]&&(i[r]=l),o[r]++,a[r]=l;for(s[0]=0,l=0;l<t;l++)s[l+1]=s[l]+o[l]}function ldlNumeric(t,e,n,s,i,o,a,r,l,m,c,u,g){let C,f,p,h,d,y,H,b,v;for(h=0;h<t;h++){for(c[h]=0,v=t,g[h]=h,a[h]=0,y=h,H=e[y+1],d=e[y];d<H;d++)if(p=n[d],p<=h){for(c[p]+=s[d],b=0;g[p]!==h;p=o[p])u[b++]=p,g[p]=h;for(;b>0;)u[--v]=u[--b]}for(m[h]=c[h],c[h]=0;v<t;v++){for(p=u[v],C=c[p],c[p]=0,H=i[p]+a[p],d=i[p];d<H;d++)c[r[d]]-=l[d]*C;f=C/m[p],m[h]-=f*C,r[d]=h,l[d]=f,a[p]++}if(0===m[h])return h}return t}function ldlLsolve(t,e,n,s,i){let o,a,r;for(o=0;o<t;o++)for(r=n[o+1],a=n[o];a<r;a++)e[s[a]]-=i[a]*e[o]}function ldlDsolve(t,e,n){let s;for(s=0;s<t;s++)e[s]/=n[s]}function ldlLTsolve(t,e,n,s,i){let o,a,r;for(o=t-1;o>=0;o--)for(r=n[o+1],a=n[o];a<r;a++)e[o]-=i[a]*e[s[a]]}function ldlPerm(t,e,n,s){let i;for(i=0;i<t;i++)e[i]=n[s[i]]}function ldlPermt(t,e,n,s){let i;for(i=0;i<t;i++)e[s[i]]=n[i]}function prepare(t,e,n){if(n){let s=new Array(e);for(let t=0;t<e;t++)s[n[t]]=t;let i=[];for(let e=0;e<t.length;++e){let n=s[t[e][0]],o=s[t[e][1]];if(o<n){let t=o;o=n,n=t}i[e]=[],i[e][0]=n,i[e][1]=o,i[e][2]=t[e][2]}t=i}else{n=[];for(let t=0;t<e;++t)n[t]=t}let s=new Array(e+1),i=new Array(t.length),o=new Array(t.length),a=[];for(let t=0;t<e;++t)a[t]=0;for(let e=0;e<t.length;++e)a[t[e][1]]++;s[0]=0;for(let t=0;t<e;++t)s[t+1]=s[t]+a[t];let r=[];for(let t=0;t<e;++t)r[t]=0;for(let e=0;e<t.length;++e){let n=t[e],a=n[1],l=s[a]+r[a];i[l]=n[0],o[l]=n[2],r[a]++}let l,m=new Array(e),c=new Array(e),u=new Array(e+1),g=new Array(e),C=new Array(e),f=new Array(e),p=new Array(e),h=new Array(e),d=new Array(e);ldlSymbolic(e,s,i,u,g,C,f);let y=new Array(u[e]),H=new Array(u[e]);return l=ldlNumeric(e,s,i,o,u,g,C,H,y,m,c,p,f),l===e?t=>(ldlPerm(e,h,t,n),ldlLsolve(e,h,u,H,y),ldlDsolve(e,h,m),ldlLTsolve(e,h,u,H,y),ldlPermt(e,d,h,n),d):null}var cuthillMckee_1=cuthillMckee;function compareNum(t,e){return t-e}function cuthillMckee(t,e){for(var n=new Array(e),s=new Array(e),i=0;i<e;++i)n[i]=[],s[i]=!1;for(i=0;i<t.length;++i){var o=t[i];n[o[0]].push(o[1])}var a=new Array(e),r=0,l=0;for(i=0;i<e;++i)if(!s[i])for(a[r++]=i,s[i]=!0;l<r;){var m=n[a[l++]];m.sort(compareNum);for(var c=0;c<m.length;++c){var u=m[c];s[u]||(s[u]=!0,a[r++]=u)}}var g=new Array(e);for(i=0;i<e;++i)g[a[i]]=i;return g}var cuthillMckee$1=cuthillMckee_1;const getClosestNumber=(t=[],e=0)=>t.reduce(((t,n)=>Math.abs(n-e)<Math.abs(t-e)?n:t)),getCloseIndex=(t=[],e=0)=>{const n=getClosestNumber(t,e);return t.indexOf(n)},updateSystem=(t,e,n)=>{let s=e.length,i=s-1,o=new Array(t.length),a=new Float64Array(s);for(let s=0;s<i;s++){let i=n[s],r=2*s,l=r+1;o[r]=t[r].slice(),o[l]=t[l].slice(),0===i?a[s]=0:(a[s]=e[s]*i,o[r][2]+=i)}return a[i]=e[i]*n[i],o[2*i]=t[2*i].slice(),o[2*i][2]+=n[i],[o,a]},getDeltaMatrix=(t,e)=>{let n=[],s=t-1;for(let t=0;t<s;t++)n.push([t,t,2*e]),n.push([t+1,t,-1*e]);return n[0][2]=e,n.push([s,s,e]),{lowerTriangularNonZeros:n,permutationEncodedArray:cuthillMckee$1(n,t)}};function airPLS(t,e,n={}){let s,i,{maxIterations:o=100,lambda:a=100,factorCriterion:r=.001,weights:l=new Array(e.length).fill(1),controlPoints:m=[],baseLineZones:c=[]}=n;m.length>0&&m.forEach(((e,n,s)=>s[n]=getCloseIndex(t,e))),c.length>0&&c.forEach((e=>{let n=getCloseIndex(t,e.from),s=getCloseIndex(t,e.to);n>s&&([n,s]=[s,n]);for(let t=n;t<s;t++)m.push(t)}));let u=e.length,g=u-1,C=Number.MAX_SAFE_INTEGER,f=r*e.reduce(((t,e)=>Math.abs(e)+t),0),{lowerTriangularNonZeros:p,permutationEncodedArray:h}=getDeltaMatrix(u,a);for(i=0;i<o&&Math.abs(C)>f;i++){let[t,n]=updateSystem(p,e,l),o=prepare(t,u,h);s=o(n),C=0;let a=e.map(d),r=-1*Number.MAX_SAFE_INTEGER;for(let t=1;t<g;t++){let e=a[t];e>=0?l[t]=0:(l[t]=Math.exp(i*e/C),r<e&&(r=e))}let c=Math.exp(i*r/C);l[0]=c,l[g]=c,m.forEach((t=>l[t]=c))}return{corrected:e.map(((t,e)=>t-s[e])),baseline:s,iteration:i,error:C};function d(t,e){let n=t-s[e];return n<0&&(C+=n),n}}function maybeToPrecision(t,e){return t<0?(t=0-t,"number"==typeof e?`- ${t.toPrecision(e)}`:`- ${t.toString()}`):"number"==typeof e?t.toPrecision(e):t.toString()}function checkArraySize(t,e){if(!isAnyArray(t)||!isAnyArray(e))throw new TypeError("x and y must be arrays");if(t.length!==e.length)throw new RangeError("x and y arrays must have the same length")}class BaseRegression{constructor(){if(new.target===BaseRegression)throw new Error("BaseRegression must be subclassed")}predict(t){if("number"==typeof t)return this._predict(t);if(isAnyArray(t)){const e=[];for(let n=0;n<t.length;n++)e.push(this._predict(t[n]));return e}throw new TypeError("x must be a number or array")}_predict(){throw new Error("_predict must be implemented")}train(){}toString(){return""}toLaTeX(){return""}score(t,e){if(!isAnyArray(t)||!isAnyArray(e)||t.length!==e.length)throw new Error("x and y must be arrays of the same length");const n=t.length,s=new Array(n);for(let e=0;e<n;e++)s[e]=this._predict(t[e]);let i=0,o=0,a=0,r=0,l=0,m=0,c=0;for(let t=0;t<n;t++)i+=s[t],o+=e[t],l+=s[t]*s[t],m+=e[t]*e[t],c+=s[t]*e[t],0!==e[t]&&(a+=(e[t]-s[t])*(e[t]-s[t])/e[t]),r+=(e[t]-s[t])*(e[t]-s[t]);const u=(n*c-i*o)/Math.sqrt((n*l-i*i)*(n*m-o*o));return{r:u,r2:u*u,chi2:a,rmsd:Math.sqrt(r/n)}}}class PolynomialRegression extends BaseRegression{constructor(t,e,n){super(),!0===t?(this.degree=e.degree,this.powers=e.powers,this.coefficients=e.coefficients):(checkArraySize(t,e),regress(this,t,e,n))}_predict(t){let e=0;for(let n=0;n<this.powers.length;n++)e+=this.coefficients[n]*Math.pow(t,this.powers[n]);return e}toJSON(){return{name:"polynomialRegression",degree:this.degree,powers:this.powers,coefficients:this.coefficients}}toString(t){return this._toFormula(t,!1)}toLaTeX(t){return this._toFormula(t,!0)}_toFormula(t,e){let n="^",s="",i=" * ";e&&(n="^{",s="}",i="");let o="",a="";for(let e=0;e<this.coefficients.length;e++)a="",0!==this.coefficients[e]&&(a=0===this.powers[e]?maybeToPrecision(this.coefficients[e],t):1===this.powers[e]?`${maybeToPrecision(this.coefficients[e],t)+i}x`:`${maybeToPrecision(this.coefficients[e],t)+i}x${n}${this.powers[e]}${s}`,this.coefficients[e]>0&&e!==this.coefficients.length-1?a=` + ${a}`:e!==this.coefficients.length-1&&(a=` ${a}`)),o=a+o;return"+"===o.charAt(0)&&(o=o.slice(1)),`f(x) = ${o}`}static load(t){if("polynomialRegression"!==t.name)throw new TypeError("not a polynomial regression model");return new PolynomialRegression(!0,t)}}function regress(t,e,n,s){const i=e.length;let o;if(Array.isArray(s))o=s,s=o.length;else{s++,o=new Array(s);for(let t=0;t<s;t++)o[t]=t}const a=new Matrix(i,s),r=new Matrix([n]);for(let t=0;t<s;t++)for(let n=0;n<i;n++)0===o[t]?a.set(n,t,1):a.set(n,t,Math.pow(e[n],o[t]));const l=new MatrixTransposeView(a),m=l.mmul(a),c=l.mmul(new MatrixTransposeView(r));t.degree=s-1,t.powers=o,t.coefficients=solve(m,c).to1DArray()}function baselineCorrectionRegression(t,e,n={}){let{maxIterations:s=100,Regression:i=PolynomialRegression,regressionOptions:o,tolerance:a=.001}=n;o||i!==PolynomialRegression||(o=3);let r,l,m=e.slice(),c=e.slice(),u=e,g=0;for(;g<s;){l=new i(t,m,o),r=0;for(let e=0;e<m.length;e++)c[e]=l.predict(t[e]),m[e]>c[e]&&(m[e]=c[e]),r+=Math.abs((c[e]-u[e])/u[e]);if(r<a)break;u=c.slice(),g++}let C=new Array(m.length);for(let t=0;t<m.length;t++)C[t]=e[t]-m[t];return{corrected:C,delta:r,iteration:g,baseline:m,regression:l}}const id$c="baselineCorrection",name$c="Baseline correction",DOMAIN_UPDATE_RULES$c={updateXDomain:!1,updateYDomain:!0};function apply$e(t,e){if(!isApplicable$c(t))throw new Error("baselineCorrection not applicable on this data");const{algorithm:n}=e,{x:s,re:i}=t.data;let o;switch(n){case"airpls":o=airPLS(s,i,e).corrected;break;case"polynomial":{const{degree:t,zones:n}=e,a=xyEquallySpaced({x:s,y:i},{numberOfPoints:4096,zones:n}),r=baselineCorrectionRegression(a.x,a.y,{regressionOptions:t}),{regression:l}=r;o=new Float64Array(s.length);for(let t=0;t<i.length;t++)o[t]=i[t]-l.predict(s[t])}break;default:throw new Error(`baselineCorrection: algorithm unknown: ${n}`)}Object.assign(t.data,{re:o})}function isApplicable$c(t){return!t.info.isFid}function reduce$c(t,e){return{once:!0,reduce:e}}var baselineCorrection=Object.freeze({__proto__:null,id:id$c,name:name$c,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$c,apply:apply$e,isApplicable:isApplicable$c,reduce:reduce$c});const id$b="digitalFilter",name$b="Digital Filter",DOMAIN_UPDATE_RULES$b={updateXDomain:!0,updateYDomain:!0};function apply$d(t,e={}){if(!isApplicable$b(t))throw new Error("Digital Filter is not applicable on this data");let{digitalFilterValue:n}=e;if(!n){n=t.info.digitalFilter||0;const e=t.filters.find((t=>t.name===id$b));e&&(e.value={digitalFilterValue:n})}const s=new Float64Array(t.data.re),i=new Float64Array(t.data.im);let o=Math.floor(n);o+=0;const a=new Float64Array(s.length),r=new Float64Array(i.length);a.set(s.slice(o)),a.set(s.slice(0,o),s.length-o),r.set(i.slice(o)),r.set(i.slice(0,o),i.length-o),t.data.re=a,t.data.im=r}function isApplicable$b(t){return!(!t.info.isComplex||!t.info.isFid)}function reduce$b(){return{once:!0,reduce:void 0}}var digitalFilter=Object.freeze({__proto__:null,id:id$b,name:name$b,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$b,apply:apply$d,isApplicable:isApplicable$b,reduce:reduce$b});const id$a="equallySpaced",name$a="Equally spaced",DOMAIN_UPDATE_RULES$a={updateXDomain:!1,updateYDomain:!1};function apply$c(t,e={}){if(!isApplicable$a(t))throw new Error("Equally Spaced is not applicable on this data");const{from:n,to:s,numberOfPoints:i,exclusions:o}=e,{x:a,re:r,im:l}=t.data,m=xyEquallySpaced({x:a,y:r},{from:n,to:s,numberOfPoints:i,exclusions:o});if(t.data.x=xEnsureFloat64(m.x),t.data.re=xEnsureFloat64(m.y),l){const e=xyEquallySpaced({x:a,y:r},{from:n,to:s,numberOfPoints:i,exclusions:o});t.data.im=xEnsureFloat64(e.y)}}function isApplicable$a(t){return!(!t.info.isComplex||t.info.isFid)}function reduce$a(){return{once:!1,reduce:null}}var equallySpaced$1=Object.freeze({__proto__:null,id:id$a,name:name$a,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$a,apply:apply$c,isApplicable:isApplicable$a,reduce:reduce$a});const id$9="exclusionZones",name$9="Exclusion zones",DOMAIN_UPDATE_RULES$9={updateXDomain:!1,updateYDomain:!1};function apply$b(t,e=[]){if(!isApplicable$9(t))throw new Error("Exclusion Zones filter not applicable on this data");const{x:n,re:s,im:i}=t.data;t.data.re=Float64Array.from(xySetYValue({x:n,y:s},{zones:e}).y),t.data.im=i?Float64Array.from(xySetYValue({x:n,y:s},{zones:e}).y):i}function isApplicable$9(t){return!!t.info.isFt}function reduce$9(t,e){return{once:!0,reduce:zonesNormalize(t.concat(e))}}var exclusionZones=Object.freeze({__proto__:null,id:id$9,name:name$9,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$9,apply:apply$b,isApplicable:isApplicable$9,reduce:reduce$9});function padDataToNextPowerOfTwo(t,e){const{x:n,re:s,im:i}=t.data,o=nextPowerOfTwo(n.length),a=new Float64Array(o),r=new Float64Array(o),l=t.info?.digitalFilter||0,m=l>0?Math.floor(l):0;a.set(s.slice(0,o-m)),r.set(i.slice(0,o-m)),m>0&&e&&(a.set(s.slice(s.length-m),o-m),r.set(i.slice(s.length-m),o-m));const c=xSequentialFill({from:n[0],size:o,step:n[1]-n[0]});t.data={...t.data,re:a,im:r,x:c}}function nextPowerOfTwo(t){return 0===t?1:(t--,t|=t>>1,t|=t>>2,t|=t>>4,t|=t>>8,(t|=t>>16)+1)}const id$8="fft",name$8="FFT",DOMAIN_UPDATE_RULES$8={updateXDomain:!0,updateYDomain:!0};function apply$a(t){if(!isApplicable$8(t))throw new Error("fft not applicable on this data");checkSameLength(t);const e=t.filters.some((t=>"digitalFilter"===t.name&&t.flag)),{info:{aqMod:n}}=t;1===n&&removeDCOffset(t,e),isPowerOfTwo(t.data.x.length)||padDataToNextPowerOfTwo(t,e);const{data:s,info:i}=t;if(Object.assign(s,reimFFT({re:s.re,im:s.im},{applyZeroShift:!0})),e){const{digitalFilter:t=0}=i,e=(t-Math.floor(t))*Math.PI*2;Object.assign(s,reimPhaseCorrection(s,0,-e,{reverse:!0}))}t.data.x=generateXAxis(t),t.info={...t.info,isFid:!1,isFt:!0}}function isApplicable$8(t){return!(!t.info.isComplex||!t.info.isFid)}function reduce$8(){return{once:!0,reduce:void 0}}function generateXAxis(t){const e=t.info,n=Number(e.baseFrequency),s=Number(e.frequencyOffset),i=Number(e.spectralWidth),o=s/n,a=.5*i,r=t.data.x.length;let l=o-a;const m=i/(r-1),c=new Float64Array(r);for(let t=0;t<r;t++)c[t]=l,l+=m;return c}function isPowerOfTwo(t){return 0!==t&&0==(t&t-1)}function removeDCOffset(t,e){const{digitalFilter:n=0}=e&&t.info?t.info:{},s=t.data,i=s.re.length,o=new Float64Array(s.re),a=new Float64Array(s.im),r=xMean(s.re.slice(.75*i>>0,i-n)),l=xMean(s.im.slice(.75*i>>0,i-n));for(let t=e?0:n;t<i-n;t++)o[t]-=r,a[t]-=l;return Object.assign(t.data,{re:o,im:a}),t}function checkSameLength(t){const{data:e}=t;if(e.x.length!==e.re.length||e.x.length!==e.im.length)throw new Error("The length of data should be equal")}var fft=Object.freeze({__proto__:null,id:id$8,name:name$8,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$8,apply:apply$a,isApplicable:isApplicable$8,reduce:reduce$8});const id$7="phaseCorrection",name$7="Phase correction",DOMAIN_UPDATE_RULES$7={updateXDomain:!1,updateYDomain:!1};function apply$9(t,e={}){if(!isApplicable$7(t))throw new Error("phaseCorrection not applicable on this data");const{absolute:n=!1}=e,s=t.filters?.find((t=>t.name===id$7));if(n){const{re:e,im:i}=t.data;t.data.re=reimAbsolute({re:e,im:i}),t.data.im=new Float64Array(0),s&&(s.value={...s.value,ph0:0,ph1:0,absolute:n})}else if("ph0"in e&&"ph1"in e){const{ph0:i,ph1:o}=e;phaseCorrection(t,{ph0:i,ph1:o}),s&&(s.value={...s.value,absolute:n})}else{const{ph0:e,ph1:i}=autoPhaseCorrection(t);phaseCorrection(t,{ph0:e,ph1:i}),s&&(s.value={...s.value,absolute:n,ph0:e,ph1:i})}}function phaseCorrection(t,e){const{ph0:n,ph1:s}=e,{re:i,im:o}=t.data,a=reimPhaseCorrection({re:i,im:o},n*Math.PI/180,s*Math.PI/180,{reverse:!0});t.data={...t.data,re:xEnsureFloat64(a.re),im:xEnsureFloat64(a.im)}}function autoPhaseCorrection(t,e={}){const{minRegSize:n=5,maxDistanceToJoin:s=128,magnitudeMode:i=!0,factorNoise:o=5,reverse:a=!0}=e;return reimAutoPhaseCorrection(t.data,{minRegSize:n,maxDistanceToJoin:s,magnitudeMode:i,factorNoise:o,reverse:a})}function isApplicable$7(t){return!(!t.info.isComplex||t.info.isFid)}function reduce$7(t,e){return{once:!0,reduce:e}}var phaseCorrection$1=Object.freeze({__proto__:null,id:id$7,name:name$7,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$7,apply:apply$9,isApplicable:isApplicable$7,reduce:reduce$7});const id$6="shiftX",name$6="Shift X",DOMAIN_UPDATE_RULES$6={updateXDomain:!0,updateYDomain:!1};function apply$8(t,e={}){const{shift:n=0}=e;t.data.x=t.data.x.map((t=>t+n))}function isApplicable$6(){return!0}function reduce$6(t,e){const{shift:n=0}=t,{shift:s=0}=e;return{once:!0,reduce:{shift:n+s}}}var shiftX=Object.freeze({__proto__:null,id:id$6,name:name$6,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$6,apply:apply$8,isApplicable:isApplicable$6,reduce:reduce$6});function centerMean(t){const{y:e}=t,n=xMean(e);for(let t=0;t<e.length;t++)e[t]-=n;return{data:t}}function centerMedian(t){const{y:e}=t,n=xMedian(e);for(let t=0;t<e.length;t++)e[t]-=n;return{data:t}}function fromTo(t,e={}){const{fromIndex:n,toIndex:s}=xGetFromToIndex(t.x,e);return{data:{x:t.x.subarray(n,s+1),y:t.y.subarray(n,s+1)}}}function normed(t,e={}){return xNormed(t.y,{...e,output:t.y}),{data:t}}function divideBySD(t){const{y:e}=t,n=xStandardDeviation(e);for(let t=0;t<e.length;t++)e[t]/=n;return{data:t}}function rescale(t,e={}){return xRescale(t.y,{...e,output:t.y}),{data:t}}function paretoNormalization(t){return{data:{x:t.x,y:xParetoNormalization(t.y)}}}function _typeof(t){return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},_typeof(t)}function sequentialFill(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if("object"!==_typeof(t)||isAnyArray(t)||(e=t,t=[]),!isAnyArray(t))throw new TypeError("input must be an array");var n=e,s=n.from,i=void 0===s?0:s,o=n.to,a=void 0===o?10:o,r=n.size,l=void 0===r?t.length:r,m=n.step;if(0!==l&&m)throw new Error("step is defined by the array size");if(l||(l=m?Math.floor((a-i)/m)+1:a-i+1),!m&&l&&(m=(a-i)/(l-1)),Array.isArray(t)){t.length=0;for(var c=0;c<l;c++)t.push(i),i+=m}else{if(t.length!==l)throw new Error("sequentialFill typed array must have the correct length");for(var u=0;u<l;u++)t[u]=i,i+=m}return t}function airPLSBaseline$1(t,e={}){const n=t.length;let{x:s,regressionOptions:i}=e;s||(s=sequentialFill({from:0,to:n-1,size:n}));let o=airPLS(s,t,i);return{baseline:o.baseline,correctedSpectrum:o.corrected}}function iterativePolynomialBaseline$1(t,e={}){const n=t.length;let{x:s,regressionOptions:i}=e;s||(s=sequentialFill({from:0,to:n-1,size:n}));let o=baselineCorrectionRegression(s,t,i);return{baseline:o.baseline,correctedSpectrum:o.corrected}}function rollingAverageBaseline$1(t,e={}){let n=Math.max(Math.round(.1*t.length),2),s=xRollingAverage(t,{...{window:n,padding:{size:n-1,algorithm:"duplicate",value:0}},...e}),i=new Float64Array(t.length);for(let e=0;e<i.length;e++)i[e]=t[e]-s[e];return{baseline:s,correctedSpectrum:i}}function rollingBall(t,e={}){if(!isAnyArray(t))throw new Error("Spectrum must be an array");if(0===t.length)throw new TypeError("Spectrum must not be empty");const n=t.length,s=new Float64Array(n),i=new Float64Array(n),o=new Float64Array(n),{windowM:a=Math.round(.04*n),windowS:r=Math.round(.08*n)}=e;for(let e=0;e<t.length;e++){let n=Math.max(0,e-a),s=Math.min(e+a+1,t.length);i[e]=xMinValue(t,{fromIndex:n,toIndex:s})}for(let t=0;t<i.length;t++){let e=Math.max(0,t-a),n=Math.min(t+a+1,i.length);s[t]=xMaxValue(i,{fromIndex:e,toIndex:n})}for(let t=0;t<i.length;t++){let e=Math.max(0,t-r),n=Math.min(t+r+1,s.length);o[t]=xMean(s.subarray(e,n))}return o}function rollingBallBaseline$1(t,e={}){const n=rollingBall(t,e);let s=new Float64Array(t.length);for(let e=0;e<s.length;e++)s[e]=t[e]-n[e];return{baseline:n,correctedSpectrum:s}}function rollingMedianBaseline$1(t,e={}){let n=Math.max(Math.round(.1*t.length),2),s=xRollingMedian(t,{...{window:n,padding:{size:n-1,algorithm:"duplicate",value:0}},...e}),i=new Float64Array(t.length);for(let e=0;e<i.length;e++)i[e]=t[e]-s[e];return{baseline:s,correctedSpectrum:i}}function airPLSBaseline(t){return t.y=airPLSBaseline$1(t.y).correctedSpectrum,{data:t}}function iterativePolynomialBaseline(t){return t.y=iterativePolynomialBaseline$1(t.y).correctedSpectrum,{data:t}}function rollingAverageBaseline(t){return t.y=rollingAverageBaseline$1(t.y).correctedSpectrum,{data:t}}function rollingBallBaseline(t){return t.y=rollingBallBaseline$1(t.y).correctedSpectrum,{data:t}}function rollingMedianBaseline(t){return t.y=rollingMedianBaseline$1(t.y).correctedSpectrum,{data:t}}function firstDerivative(t,e={}){const{x:n,y:s}=t;return{data:{x:n,y:sgg(s,n,{...e,derivative:1})}}}function secondDerivative(t,e={}){const{x:n,y:s}=t;return{data:{x:n,y:sgg(s,n,{...e,derivative:2})}}}function thirdDerivative(t,e={}){const{x:n,y:s}=t;return{data:{x:n,y:sgg(s,n,{...e,derivative:3})}}}function savitzkyGolay(t,e={}){const{x:n,y:s}=t;return{data:{x:n,y:sgg(s,n,e)}}}function ensureGrowing(t){return{data:xyEnsureGrowingX(t)}}function equallySpaced(t,e={}){return{data:xyEquallySpaced(t,e)}}function filterX(t,e={}){return{data:xyFilterX(t,e)}}function calibrateX(t,e={}){const{targetX:n=0,nbPeaks:s=1,from:i=t.x[0],to:o=t.x[t.x.length-1],gsd:a={minMaxRatio:.1,realTopDetection:!0,smoothY:!0,sgOptions:{windowSize:7,polynomial:3}}}=e,r=xFindClosestIndex(t.x,i),l=xFindClosestIndex(t.x,o);let m=gsd({x:t.x.subarray(r,l),y:t.y.subarray(r,l)},a).sort(((t,e)=>e.y-t.y)).slice(0,s);if(m.length<s)return{data:t};const c=xMean(m.map((t=>t.x)));return{data:{x:xAdd(t.x,n-c),y:t.y}}}function xFunction(t,e={}){return{data:{x:xApplyFunctionStr(t.x,{variableLabel:"x",fctString:e.function}),y:t.y}}}function yFunction(t,e={}){return{data:{x:t.x,y:xApplyFunctionStr(t.y,{variableLabel:"y",fctString:e.function})}}}var Filters$2=Object.freeze({__proto__:null,centerMean:centerMean,centerMedian:centerMedian,fromTo:fromTo,normed:normed,divideBySD:divideBySD,rescale:rescale,paretoNormalization:paretoNormalization,airPLSBaseline:airPLSBaseline,iterativePolynomialBaseline:iterativePolynomialBaseline,rollingAverageBaseline:rollingAverageBaseline,rollingBallBaseline:rollingBallBaseline,rollingMedianBaseline:rollingMedianBaseline,firstDerivative:firstDerivative,secondDerivative:secondDerivative,thirdDerivative:thirdDerivative,savitzkyGolay:savitzkyGolay,ensureGrowing:ensureGrowing,equallySpaced:equallySpaced,filterX:filterX,calibrateX:calibrateX,xFunction:xFunction,yFunction:yFunction});function filterXY$1(t,e){let n={data:{x:xEnsureFloat64(t.x),y:xEnsureFloat64(t.y)}};const s=[];for(let t of e){const e=Date.now(),i=Filters$2[t.name];if(!i)throw new Error(`Unknown filter: ${t.name}`);n=i(n.data,t.options),s.push({name:t.name,time:Date.now()-e})}return{logs:s,data:n.data}}var Filters$1=Object.freeze({__proto__:null,filterXY:filterXY$1,centerMean:centerMean,centerMedian:centerMedian,fromTo:fromTo,normed:normed,divideBySD:divideBySD,rescale:rescale,paretoNormalization:paretoNormalization,airPLSBaseline:airPLSBaseline,iterativePolynomialBaseline:iterativePolynomialBaseline,rollingAverageBaseline:rollingAverageBaseline,rollingBallBaseline:rollingBallBaseline,rollingMedianBaseline:rollingMedianBaseline,firstDerivative:firstDerivative,secondDerivative:secondDerivative,thirdDerivative:thirdDerivative,savitzkyGolay:savitzkyGolay,ensureGrowing:ensureGrowing,equallySpaced:equallySpaced,filterX:filterX,calibrateX:calibrateX,xFunction:xFunction,yFunction:yFunction});const id$5="signalProcessing",name$5="Signal processing",DOMAIN_UPDATE_RULES$5={updateXDomain:!0,updateYDomain:!0};function apply$7(t,e){if(!isApplicable$5(t))throw new Error("Signal Processing is not applicable on this data");t.data=filterXY(t,e)}function isApplicable$5(t){return!!t.info.isFt}function reduce$5(t,e){return{once:!0,reduce:e}}function filterXY(t,e){let n=t.data.x.slice(0);const s=t.data.x.slice(0);let i=t.data.re.slice(0),o=t.data.im?.slice(0);const a=e.filters.slice(),{range:{from:r,to:l},numberOfPoints:m,exclusionsZones:c}=e;a.push({name:"equallySpaced",options:{from:r,to:l,numberOfPoints:m,exclusions:c},properties:{}});for(const t of a){const e=Filters$1[t.name];if(!e)throw new Error(`Unknown filter: ${t.name}`);const a=t?.options||{},r=e({x:n,y:i},a);if(n=r.data.x,i=r.data.y,o){o=e({x:s,y:o},a).data.y}}return{x:n,re:i,im:o}}var signalProcessing=Object.freeze({__proto__:null,id:id$5,name:name$5,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$5,apply:apply$7,isApplicable:isApplicable$5,reduce:reduce$5,filterXY:filterXY});const id$4="zeroFilling",name$4="Zero Filling",DOMAIN_UPDATE_RULES$4={updateXDomain:!0,updateYDomain:!1};function apply$6(t,e){if(!isApplicable$4(t))throw new Error("zeroFilling not applicable on this data");const{factor:n=2}=e,{nbPoints:s=2**Math.round(Math.log2(t.data.x.length*n))}=e;if(!e.nbPoints){const e=t.filters.find((t=>t.name===id$4));e&&(e.value={nbPoints:s})}const i=t.filters.some((t=>"digitalFilter"===t.name&&t.flag)),o=t.info?.digitalFilter||0,a=i&&o>0?Math.floor(o):0,{re:r,im:l,x:m}=t.data,c=new Float64Array(s),u=new Float64Array(s),g=new Float64Array(s),C=Math.min(s,r.length);c.set(r.slice(0,C-a)),u.set(l.slice(0,C-a)),g.set(m.slice(0,C-a));const f=m[1]-m[0];let p=m[C-a-1];for(let t=C-a;t<s;t++)p+=f,g[t]=p;a>0&&a<s&&(c.set(r.slice(r.length-a),s-a),u.set(l.slice(r.length-a),s-a)),t.data={...t.data,re:c,im:u,x:g}}function isApplicable$4(t){return!(!t.info?.isComplex||!t.info?.isFid)}function reduce$4(t,e){return delete e.factor,{once:!0,reduce:e}}var zeroFilling=Object.freeze({__proto__:null,id:id$4,name:name$4,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$4,apply:apply$6,isApplicable:isApplicable$4,reduce:reduce$4});const id$3="fftDimension1",name$3="FFT Dimension 1",DOMAIN_UPDATE_RULES$3={updateXDomain:!0,updateYDomain:!0};function apply$5(t,e){if(!isApplicable$3(t))throw new Error("fft dimension 1 not applicable on this data");const{data:n,info:s}=t,{digitalFilter:i=0}=s,o=s.fnMode[1].toLowerCase(),a="echo-antiecho"===o?echoQuadrature(n):{re:n.re.z,im:n.im.z},{zeroFilling:r={}}=e,l=a.re[0].length,{factor:m=1}=r,c=r?.nbPoints||2**Math.round(Math.log2(l*m)),u=fftDirectDimension(a,{fnMode:o,...e,digitalFilterValue:i,zeroFilling:{nbPoints:c}});t.data.re.z=u.re.to2DArray().map(xEnsureFloat64),t.data.im.z=u.im.to2DArray().map(xEnsureFloat64)}function isApplicable$3(t){return!(!t.info.isComplex||!t.info.isFid)}function reduce$3(){return{once:!0,reduce:void 0}}function echoQuadrature(t){const{re:{z:e},im:{z:n}}=t,s=[],i=[];for(let t=0;t<e.length;t+=2){const o=e[t],a=n[t],r=e[t+1],l=n[t+1];s.push(xSubtract(xMultiply(l,-1),a)),s.push(xSubtract(r,o)),i.push(xAdd(r,o)),i.push(xSubtract(l,a))}return{re:s,im:i}}var fftDimension1=Object.freeze({__proto__:null,id:id$3,name:name$3,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$3,apply:apply$5,isApplicable:isApplicable$3,reduce:reduce$3});const id$2="fftDimension2",name$2="FFT Dimension 2",DOMAIN_UPDATE_RULES$2={updateXDomain:!0,updateYDomain:!0};function apply$4(t,e){if(!isApplicable$2(t))throw new Error("fft dimension 2 not applicable on this data");const{data:n,info:s}=t,i=s.fnMode[1],o={re:n.re.z,im:n.im.z},{zeroFilling:a={}}=e,r=o.re.length,{factor:l=2}=a,m=a?.nbPoints||2**Math.round(Math.log2(r*l)),c=fftIndirectDimension({re:o.re,im:o.im},{fnMode:i,...e,zeroFilling:{nbPoints:m}});t.data={...getQuadrants(c,s)};const{isFid:u,isComplex:g,...C}=s;t.info={...C,isFt:!0}}function getQuadrants(t,e){const n={},{fnMode:s}=e,i=getMinMaxXY(e),o=e=>{for(const s of e)n[s]={z:t[s].to2DArray().map(xEnsureFloat64),maxZ:t[s].max(),minZ:t[s].min(),...i};return n};return"QF"===s[1]?o(["rr","ir"]):o(["rr","ir","ri","ii"])}function isApplicable$2(t){return!(!t.info.isComplex||!t.info.isFid)}function reduce$2(){return{once:!0,reduce:void 0}}var fftDimension2=Object.freeze({__proto__:null,id:id$2,name:name$2,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$2,apply:apply$4,isApplicable:isApplicable$2,reduce:reduce$2});const id$1="shift2DX",name$1="Shift 2D X",DOMAIN_UPDATE_RULES$1={updateXDomain:!0,updateYDomain:!1};function apply$3(t,e){const{shift:n}=e,s={...t.data};for(const t in s)s[t].minX+=n,s[t].maxX+=n}function isApplicable$1(){return!0}function reduce$1(t,e){const{shift:n=0}=t,{shift:s}=e;return{once:!0,reduce:{shift:n+s}}}var shift2DX=Object.freeze({__proto__:null,id:id$1,name:name$1,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$1,apply:apply$3,isApplicable:isApplicable$1,reduce:reduce$1});const id="shift2DY",name="Shift 2D Y",DOMAIN_UPDATE_RULES={updateXDomain:!1,updateYDomain:!0};function apply$2(t,e){const{shift:n}=e,s={...t.data};for(const t in s)s[t].minY+=n,s[t].maxY+=n}function isApplicable(){return!0}function reduce(t,e){const{shift:n=0}=t,{shift:s}=e;return{once:!0,reduce:{shift:n+s}}}var shift2DY=Object.freeze({__proto__:null,id:id,name:name,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES,apply:apply$2,isApplicable:isApplicable,reduce:reduce});const Filters={apodization:apodization,exclusionZones:exclusionZones,signalProcessing:signalProcessing,baselineCorrection:baselineCorrection,digitalFilter:digitalFilter,equallySpaced:equallySpaced$1,fft:fft,fftDimension1:fftDimension1,fftDimension2:fftDimension2,phaseCorrection:phaseCorrection$1,shiftX:shiftX,zeroFilling:zeroFilling,shift2DX:shift2DX,shift2DY:shift2DY};function cloneData1D(t){const{x:e,re:n,im:s}=t||{x:[],re:[],im:[]};return{x:e.slice(),re:n.slice(),im:s?.slice()||null}}function cloneData2D(t){const e={};if(isData2DFt(t))for(const n in t)addCloneData(e,n,t[n]);else for(const n in t)addCloneData(e,n,t[n]);return e}function isData2DFt(t){return"re"in t}function addCloneData(t,e,n){if(n){const{z:s,...i}=n;t[e]={z:s.slice(),...i}}}function getShiftX(t){const e=t?.filters?.find((t=>t.name===Filters.shiftX.id));return e?.flag?e.value.shift:0}function getRange$1(t,e,n){const{originFrom:s,originTo:i,from:o,to:a}=t;return"origin"===e?{originFrom:o-n,originTo:a-n,from:o,to:a}:{originFrom:s,originTo:i,from:s+n,to:i+n}}function mapIntegrals(t,e,n="origin"){const{x:s,re:i}=e.data,o=getShiftX(e);return t.map((t=>{const e=getRange$1(t,n,o),a=xyIntegration({x:s,y:i},{from:e.from,to:e.to,reverse:!0});return{...t,id:t.id||v4(),...e,absolute:a}}))}function getSum(t,e,n=null){let s=0;for(const i of t)if(n?.(i)){const t=i[e];if(!t||isNaN(t))continue;s+=Math.abs(t)}return s}function checkIntegralKind(t){return SignalKindsToInclude.includes(t.kind)}function mapValues(t,e,n,s){return t.map((t=>({...t,...s(t)&&{[e]:t.absolute*n}})))}function updateIntegralsRelativeValues(t,e=!1){const{values:n,options:s}=t.integrals,i=getSum(n,"absolute",checkIntegralKind);let o=0;if(s?.sum)if(s.isSumConstant||e)o=i>0?s.sum/i:0;else if(n?.[0]){const t=n[0];o=(t.integral||s.sum)/t.absolute}t.integrals.values=mapValues(n,"integral",o,checkIntegralKind),s.isSumConstant||e||(s.sum=getSum(n,"integral",checkIntegralKind))}function updateIntegrals(t){t.integrals.values=mapIntegrals(t.integrals.values,t,"current"),updateIntegralsRelativeValues(t,!0)}function getSpectrumErrorValue(t){const{x:e}=t.data;return(e[e.length-1]-e[0])/1e4}function isExists(t,e,n){for(const{x:s}of e.peaks?.values||[])if(Math.abs(t.x-s)<n)return!0;return!1}function getPeakDelta(t,e,n){const{originalX:s=0,x:i}=t;return"origin"===e?{originalX:i-n,x:i}:{originalX:s,x:s+n}}function mapPeaks(t,e,n={}){const{checkIsExisting:s=!0,shiftTarget:i="origin"}=n,o=getShiftX(e),a=getSpectrumErrorValue(e),r=[];for(const n of t){const t=getPeakDelta(n,i,o);(!s||s&&!isExists(n,e,a))&&r.push({...n,id:n?.id||v4(),...t})}return r}function updatePeaks(t){t.peaks.values=mapPeaks(t.peaks.values,t,{checkIsExisting:!1,shiftTarget:"current"})}function checkRange(t,e,n){for(const{from:s,to:i}of e.ranges?.values||[])if(Math.abs(t.from-s)<n&&Math.abs(t.to-i)<n)return!0}function getRange(t,e,n){const{originFrom:s,originTo:i,from:o,to:a}=t;return"origin"===e?{originFrom:o-n,originTo:a-n,from:o,to:a}:{originFrom:s,originTo:i,from:(s||0)+n,to:(i||0)+n}}function getSignalDelta(t,e,n){const{delta:s,originDelta:i}=t;return"origin"===e?{originDelta:s-n,delta:s}:{originDelta:i,delta:(i||0)+n}}function nmrRangeToRange(t){const{signals:e=[],integration:n=0,...s}=t,i=[];for(const t of e){const{multiplicity:e,...n}=t;i.push({id:v4(),js:[],multiplicity:e||signalMultiplicityPattern(t),...n})}return{id:v4(),integration:n,absolute:n||0,signals:i,...s}}function mapRanges(t,e,n={}){const{checkIsExisting:s=!0,shiftTarget:i="origin"}=n,{x:o,re:a}=e.data,r=getShiftX(e),l=getSpectrumErrorValue(e);let m=t.map(nmrRangeToRange);return s&&(m=m.filter((t=>s&&!checkRange(t,e,l)||"new"===t.id))),m.map((t=>{const e=getRange(t,i,r),n=xyIntegration({x:o,y:a},{from:e.from,to:e.to,reverse:!0}),s=t.signals.map((t=>{const{kind:e=null,id:n,...s}=t;return{kind:e||"signal",id:n||v4(),...s,...getSignalDelta(t,i,r)}}));return{...t,id:t.id||v4(),kind:s?.[0].kind||DatumKind.signal,...e,absolute:n,signals:s}}))}function last$1(t){var e=null==t?0:t.length;return e?t[e-1]:void 0}var last_1=last$1;function baseSlice$1(t,e,n){var s=-1,i=t.length;e<0&&(e=-e>i?0:i+e),(n=n>i?i:n)<0&&(n+=i),i=e>n?0:n-e>>>0,e>>>=0;for(var o=Array(i);++s<i;)o[s]=t[s+e];return o}var _baseSlice=baseSlice$1,baseGet=_baseGet,baseSlice=_baseSlice;function parent$1(t,e){return e.length<2?t:baseGet(t,baseSlice(e,0,-1))}var _parent=parent$1,castPath$1=_castPath,last=last_1,parent=_parent,toKey=_toKey;function baseUnset$1(t,e){return e=castPath$1(e,t),null==(t=parent(t,e))||delete t[toKey(last(e))]}var _baseUnset=baseUnset$1,baseGetTag=_baseGetTag,getPrototype=_getPrototype,isObjectLike=isObjectLike_1,objectTag="[object Object]",funcProto=Function.prototype,objectProto=Object.prototype,funcToString=funcProto.toString,hasOwnProperty=objectProto.hasOwnProperty,objectCtorString=funcToString.call(Object);function isPlainObject$1(t){if(!isObjectLike(t)||baseGetTag(t)!=objectTag)return!1;var e=getPrototype(t);if(null===e)return!0;var n=hasOwnProperty.call(e,"constructor")&&e.constructor;return"function"==typeof n&&n instanceof n&&funcToString.call(n)==objectCtorString}var isPlainObject_1=isPlainObject$1,isPlainObject=isPlainObject_1;function customOmitClone$1(t){return isPlainObject(t)?void 0:t}var _customOmitClone=customOmitClone$1,Symbol$1=_Symbol,isArguments=isArguments_1,isArray=isArray_1,spreadableSymbol=Symbol$1?Symbol$1.isConcatSpreadable:void 0;function isFlattenable$1(t){return isArray(t)||isArguments(t)||!!(spreadableSymbol&&t&&t[spreadableSymbol])}var _isFlattenable=isFlattenable$1,arrayPush=_arrayPush,isFlattenable=_isFlattenable;function baseFlatten$1(t,e,n,s,i){var o=-1,a=t.length;for(n||(n=isFlattenable),i||(i=[]);++o<a;){var r=t[o];e>0&&n(r)?e>1?baseFlatten$1(r,e-1,n,s,i):arrayPush(i,r):s||(i[i.length]=r)}return i}var _baseFlatten=baseFlatten$1,baseFlatten=_baseFlatten;function flatten$1(t){return(null==t?0:t.length)?baseFlatten(t,1):[]}var flatten_1=flatten$1;function apply$1(t,e,n){switch(n.length){case 0:return t.call(e);case 1:return t.call(e,n[0]);case 2:return t.call(e,n[0],n[1]);case 3:return t.call(e,n[0],n[1],n[2])}return t.apply(e,n)}var _apply=apply$1,apply=_apply,nativeMax=Math.max;function overRest$1(t,e,n){return e=nativeMax(void 0===e?t.length-1:e,0),function(){for(var s=arguments,i=-1,o=nativeMax(s.length-e,0),a=Array(o);++i<o;)a[i]=s[e+i];i=-1;for(var r=Array(e+1);++i<e;)r[i]=s[i];return r[e]=n(a),apply(t,this,r)}}var _overRest=overRest$1;function constant$1(t){return function(){return t}}var constant_1=constant$1;function identity$1(t){return t}var identity_1=identity$1,constant=constant_1,defineProperty=_defineProperty,identity=identity_1,baseSetToString$1=defineProperty?function(t,e){return defineProperty(t,"toString",{configurable:!0,enumerable:!1,value:constant(e),writable:!0})}:identity,_baseSetToString=baseSetToString$1,HOT_COUNT=800,HOT_SPAN=16,nativeNow=Date.now;function shortOut$1(t){var e=0,n=0;return function(){var s=nativeNow(),i=HOT_SPAN-(s-n);if(n=s,i>0){if(++e>=HOT_COUNT)return arguments[0]}else e=0;return t.apply(void 0,arguments)}}var _shortOut=shortOut$1,baseSetToString=_baseSetToString,shortOut=_shortOut,setToString$1=shortOut(baseSetToString),_setToString=setToString$1,flatten=flatten_1,overRest=_overRest,setToString=_setToString;function flatRest$1(t){return setToString(overRest(t,void 0,flatten),t+"")}var _flatRest=flatRest$1,arrayMap=_arrayMap,baseClone=_baseClone,baseUnset=_baseUnset,castPath=_castPath,copyObject=_copyObject,customOmitClone=_customOmitClone,flatRest=_flatRest,getAllKeysIn=_getAllKeysIn,CLONE_DEEP_FLAG=1,CLONE_FLAT_FLAG=2,CLONE_SYMBOLS_FLAG=4,omit=flatRest((function(t,e){var n={};if(null==t)return n;var s=!1;e=arrayMap(e,(function(e){return e=castPath(e,t),s||(s=e.length>1),e})),copyObject(t,getAllKeysIn(t),n),s&&(n=baseClone(n,CLONE_DEEP_FLAG|CLONE_FLAT_FLAG|CLONE_SYMBOLS_FLAG,customOmitClone));for(var i=e.length;i--;)baseUnset(n,e[i]);return n})),omit_1=omit,omit$1=omit_1;function getDiaIDs(t){return[].concat(t.diaIDs||[],t.signals?t.signals.flatMap((t=>t.diaIDs||[])):[])}function getNbAtoms(t,e){if(void 0===e){let e=0;if(t.signals)for(const n of t.signals)e+=n.nbAtoms||0;return e}return t.signals[e].nbAtoms||0}function setNbAtoms(t,e){t.nbAtoms=getNbAtoms(t,e),0===t.nbAtoms&&delete t.nbAtoms}function resetDiaIDs(t){const e=["diaIDs","nbAtoms"];(t=omit$1(t,e)).signals=t.signals.map((t=>omit$1(t,e)))}function unlink(t,e={}){const{unlinkType:n="both",signalIndex:s=-1}=e,i=["diaIDs","nbAtoms"];switch(n){case"both":resetDiaIDs(t);break;case"range":t=omit$1(t,i);break;case"signal":-1!==s&&(t.signals[s]=omit$1(t.signals[s],i))}return t}function addDefaultSignal(t){t.signals.push({id:v4(),multiplicity:"m",kind:"signal",js:[],delta:(t.to+t.from)/2})}function checkRangeKind$1(t){return t.kind===DatumKind.signal}function checkSignalKinds(t,e){return!t.signals.some((t=>void 0===t.kind||!e.includes(t.kind)))}var RangeUtilities=Object.freeze({__proto__:null,getDiaIDs:getDiaIDs,getNbAtoms:getNbAtoms,setNbAtoms:setNbAtoms,resetDiaIDs:resetDiaIDs,unlink:unlink,addDefaultSignal:addDefaultSignal,checkRangeKind:checkRangeKind$1,checkSignalKinds:checkSignalKinds});function checkRangeKind(t){return t.signals&&checkSignalKinds(t,SignalKindsToInclude)}function updateRangesRelativeValues(t,e=!1){const{values:n,options:s}=t.ranges,i=getSum(n,"absolute",checkRangeKind);let o=0;if(s?.sum)if(s.isSumConstant||e)o=i>0?s.sum/i:0;else if(n?.[0]){const t=n[0];o=(t.integration||s.sum)/t.absolute}t.ranges.values=mapValues(n,"integration",o,checkRangeKind),s.isSumConstant||e||(s.sum=getSum(n,"integration",checkRangeKind))}function updateRanges(t){t.ranges.values=mapRanges(t.ranges.values,t,{checkIsExisting:!1,shiftTarget:"current"}),updateRangesRelativeValues(t,!0)}function get2DSpectrumErrorValue(t){const{data:e,info:n}=t,{minX:s,maxX:i,minY:o,maxY:a}=n.isFid?e.re:e.rr;return{x:Math.abs(i-s)/1e4,y:Math.abs(a-o)/1e4}}function getShift(t){const e={x:0,y:0};if(t?.filters)for(const n of t.filters)n.name===Filters.shift2DX.id&&(e.x=n?.flag?n.value.shift:0),n.name===Filters.shift2DY.id&&(e.y=n?.flag?n.value.shift:0);return e}function isZoneExists(t,e,n){const s=t.x||{from:0,to:0},i=t.y||{from:0,to:0};if(!e.zones?.values)return!1;for(const{x:t,y:o}of e.zones.values)if(Math.abs(s.from-t.from)<n.x&&Math.abs(s.to-t.to)<n.x&&Math.abs(i.from-o.from)<n.y&&Math.abs(i.to-o.to)<n.y)return!0;return!1}function getSignal(t,e,n){const{x:s,y:i}=t;return"origin"===e?{...t,x:{...s,originDelta:s.delta-n.x},y:{...i,originDelta:i.delta-n.y}}:{...t,x:{...s,delta:s.originDelta+n.x},y:{...i,delta:i.originDelta+n.y}}}function mapZones(t,e,n={}){const{checkIsExisting:s=!0,shiftTarget:i="origin"}=n,o=getShift(e),a=get2DSpectrumErrorValue(e);let r=t;return s&&(r=t.filter((t=>!isZoneExists(t,e,a)))),r.map((t=>{const e=t.x||{from:0,to:0},n=t.y||{from:0,to:0},s=t.signals.map((t=>{const{id:e,kind:n}=t;return{...getSignal(t,i,o),id:e||v4(),kind:n||"signal"}}));return{...t,id:t.id||v4(),x:{from:e.from,to:e.to},y:{from:n.from,to:n.to},signals:s,kind:t.kind||DatumKind.signal}}))}function updateZones(t){t.zones.values=mapZones(t.zones.values,t,{checkIsExisting:!1,shiftTarget:"current"})}function resetDataToOrigin(t){t.data=1===t.info.dimension?cloneData1D(t.originalData):cloneData2D(t.originalData);const{originalInfo:e}=t;e&&(t.info={...e})}function updateData(t){1===t.info.dimension?(updatePeaks(t),updateRanges(t),updateIntegrals(t)):2===t.info.dimension&&updateZones(t)}function applyFilter(t,e=[],n={}){const{forceReapply:s=!1,filterIndex:i}=n;let o=!1;for(const n of e){const e={name:n.name,label:Filters[n.name].name,value:n.value},s=lookupForFilter(t,n.name),a=!("isDeleteAllow"in n)||n.isDeleteAllow;if(s){const r=Filters[n.name].reduce(s.value,e.value);r.once?(o||(o=!0),null!=r.reduce&&void 0!==r.reduce&&replaceFilter(t,s.id,r.reduce)):addFilter(t,e,{isDeleteAllow:a,filterIndex:i})}else addFilter(t,e,{isDeleteAllow:a,filterIndex:i})}if(s)reapplyFilters(t);else if(o)1===e.length&&isLastFilter(t,e[0].name)?Filters[e[0].name].apply(t,e[0].value):reapplyFilters(t);else for(const n of e)Filters[n.name].apply(t,n.value);updateData(t)}function isLastFilter(t,e){const n=t.filters.findIndex((t=>t.name===e));return t.filters.length===n+1}function lookupForFilter(t,e){return t.filters.find((t=>t.name===e))}function reapplyFilters(t,e){enableFilter(t,null,null,e||t.filters)}function enableFilter(t,e,n,s){t.filters=t.filters.slice(0),e&&(t.filters=t.filters.map((t=>({...t,flag:t.id===e?n:t.flag})))),resetDataToOrigin(t);const i=s||t.filters;for(let e=0;e<i.length;e++){const n=t.filters[e];if(t.filters[e]={...t.filters[e]},n.flag)try{Filters[n.name].apply(t,n.value)}catch(n){t.filters[e]={...t.filters[e],error:n.message}}}}function deleteFilter(t,e){t.filters=t.filters.slice(0).filter((t=>e?t.id!==e:!t.isDeleteAllow)),resetDataToOrigin(t);for(let e=0;e<t.filters.length;e++)if(t.filters[e]={...t.filters[e]},t.filters[e].flag){const{name:n,value:s}=t.filters[e];try{Filters[n].apply(t,s)}catch(n){t.filters[e]={...t.filters[e],error:n.message}}}updateData(t)}function addFilter(t,e,n={}){const{filterIndex:s,isDeleteAllow:i=!0}=n,o={...e,id:v4(),flag:!0,isDeleteAllow:i};"number"==typeof s&&-1!==s?t.filters=[...t.filters.slice(0,s+1),o,...t.filters.slice(s+1)]:t.filters.push(o)}function replaceFilter(t,e,n){const s=t.filters.findIndex((t=>t.id===e));t.filters[s]={...t.filters[s],value:n}}var FiltersManager=Object.freeze({__proto__:null,applyFilter:applyFilter,lookupForFilter:lookupForFilter,reapplyFilters:reapplyFilters,enableFilter:enableFilter,deleteFilter:deleteFilter,addFilter:addFilter});exports.DatumKind=DatumKind,exports.Filters=Filters,exports.FiltersManager=FiltersManager,exports.MultiplicityPatterns=MultiplicityPatterns,exports.RangeUtilities=RangeUtilities,exports.SignalKinds=SignalKinds,exports.SignalKindsToInclude=SignalKindsToInclude,exports.XYAutoPeaksPickingWindowSizeError=XYAutoPeaksPickingWindowSizeError,exports.apodization=apodization$1,exports.apodizationFilter=apodizationFilter,exports.carbonImpurities=carbonImpurities,exports.checkIntegralKind=checkIntegralKind,exports.checkMultiplet=checkMultiplet,exports.checkMultiplicity=checkMultiplicity,exports.couplingACSPatterns=couplingACSPatterns,exports.couplingPatterns=couplingPatterns,exports.findMultiplet=findMultiplet,exports.get13CAssignments=get13CAssignments,exports.get1HAssignments=get1HAssignments,exports.getAssignments=getAssignments,exports.getDatabase=getDatabase,exports.getFrequency=getFrequency,exports.getShiftX=getShiftX,exports.getSpectrumErrorValue=getSpectrumErrorValue,exports.gyromagneticRatio=gyromagneticRatio,exports.impurities=impurities,exports.mapIntegrals=mapIntegrals,exports.mapPeaks=mapPeaks,exports.mapRanges=mapRanges,exports.markSolventPeaks=markSolventPeaks,exports.normalizeNucleus=normalizeNucleus,exports.optimizeSignals=optimizeSignals,exports.peakToXY=peakToXY,exports.peaksFilterImpurities=peaksFilterImpurities,exports.peaksToXY=peaksToXY,exports.predictAll=predictAll,exports.predictAllSpectra=predictAllSpectra,exports.predictCOSY=predictCOSY,exports.predictCarbon=predictCarbon,exports.predictHMBC=predictHMBC,exports.predictHSQC=predictHSQC,exports.predictProton=predictProton,exports.protonImpurities=protonImpurities,exports.rangeFromSignal=rangeFromSignal,exports.rangesToACS=rangesToACS,exports.rangesToXY=rangesToXY,exports.resurrect=resurrect,exports.signalJoinCouplings=signalJoinCouplings,exports.signalMultiplicityPattern=signalMultiplicityPattern,exports.signals2DToZ=signals2DToZ,exports.signalsToFID=signalsToFID,exports.signalsToRanges=signalsToRanges,exports.signalsToXY=signalsToXY,exports.simulate1D=simulate1D,exports.solventSuppression=solventSuppression,exports.splitPatterns=splitPatterns,exports.translateMultiplet=translateMultiplet,exports.updateIntegralsRelativeValues=updateIntegralsRelativeValues,exports.updateRanges=updateRanges,exports.updateRangesRelativeValues=updateRangesRelativeValues,exports.xyAutoPeaksPicking=xyAutoPeaksPicking,exports.xyAutoRangesPicking=xyAutoRangesPicking,exports.xyPeaksOptimization=xyPeaksOptimization,exports.xyzAutoSignalsPicking=xyzAutoSignalsPicking,exports.xyzAutoZonesPicking=xyzAutoZonesPicking,exports.xyzBidimensionalFFT=xyzBidimensionalFFT,exports.xyzJResAnalyzer=xyzJResAnalyzer,Object.defineProperty(exports,"__esModule",{value:!0})}));
//# sourceMappingURL=nmr-processing.min.js.map
