/**
 * nmr-processing - Pure functions allowing to process NMR spectra.
 * @version v11.0.1
 * @link https://github.com/cheminfo/nmr-processing#readme
 * @license MIT
 */
(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
    typeof define === 'function' && define.amd ? define(['exports'], factory) :
    (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.nmrProcessing = {}));
})(this, (function (exports) { 'use strict';

    const gyromagneticRatio = {
      '1H': 267.52218744e6,
      '2H': 41.065e6,
      '3H': 285.3508e6,
      '3He': -203.789e6,
      '7Li': 103.962e6,
      '13C': 67.28284e6,
      '14N': 19.331e6,
      '15N': -27.116e6,
      '17O': -36.264e6,
      '19F': 251.662e6,
      '23Na': 70.761e6,
      '27Al': 69.763e6,
      '29Si': -53.19e6,
      '31P': 108.291e6,
      '57Fe': 8.681e6,
      '63Cu': 71.118e6,
      '67Zn': 16.767e6,
      '129Xe': -73.997e6
    };

    /* eslint-disable camelcase */
    const impuritiesContent = {
      cdcl3: {
        tms: [{
          proton: 'X',
          coupling: 0,
          multiplicity: '',
          shift: 0
        }],
        solvent: [{
          proton: 'X',
          coupling: 0,
          multiplicity: 'ds',
          shift: 7.26
        }],
        h2o: [{
          proton: 'H2O',
          coupling: 0,
          multiplicity: 'bs',
          shift: 1.56
        }],
        acetic_acid: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.1
        }],
        acetone: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.17
        }],
        acetonitrile: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.1
        }],
        benzene: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.36
        }],
        'tert-butyl_alcohol': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.28
        }],
        'tert-butyl_methyl_ether': [{
          proton: 'CCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.19
        }, {
          proton: 'OCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.22
        }],
        bhtb: [{
          proton: 'ArH',
          coupling: 0,
          multiplicity: 's',
          shift: 6.98
        }, {
          proton: 'OHc',
          coupling: 0,
          multiplicity: 's',
          shift: 5.01
        }, {
          proton: 'ArCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.27
        }, {
          proton: 'ArC(CH3)3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.43
        }],
        chloroform: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.26
        }],
        cyclohexane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 1.43
        }],
        '1,2-dichloroethane': [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.73
        }],
        dichloromethane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 5.3
        }],
        diethyl_ether: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.21
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.48
        }],
        diglyme: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.65
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.57
        }, {
          proton: 'OCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.39
        }],
        '1,2-dimethoxyethane': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.4
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.55
        }],
        dimethylacetamide: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 2.09
        }, {
          proton: 'NCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.02
        }, {
          proton: 'NCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.94
        }],
        dimethylformamide: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 8.02
        }, {
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.96
        }, {
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.88
        }],
        dimethyl_sulfoxide: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.62
        }],
        dioxane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.71
        }],
        ethanol: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.25
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.72
        }, {
          proton: 'OH',
          coupling: 5,
          multiplicity: 's,t',
          shift: 1.32
        }],
        ethyl_acetate: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 2.05
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 'q',
          shift: 4.12
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.26
        }],
        ethyl_methyl_ketone: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 2.14
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 'q',
          shift: 2.46
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.06
        }],
        ethylene_glycol: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 3.76
        }],
        'grease^f': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 'm',
          shift: 0.86
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'br_s',
          shift: 1.26
        }],
        'n-hexane': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 't',
          shift: 0.88
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.26
        }],
        hmpag: [{
          proton: 'CH3',
          coupling: 9.5,
          multiplicity: 'd',
          shift: 2.65
        }],
        methanol: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.49
        }, {
          proton: 'OH',
          coupling: 0,
          multiplicity: 's',
          shift: 1.09
        }],
        nitromethane: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 4.33
        }],
        'n-pentane': [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 7
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.27
        }],
        '2-propanol': [{
          proton: 'CH3',
          coupling: 6,
          multiplicity: 'd',
          shift: 1.22
        }, {
          proton: 'CH',
          coupling: 6,
          multiplicity: 'sep',
          shift: 4.04
        }],
        pyridine: [{
          proton: 'CH(2)',
          coupling: 0,
          multiplicity: 'm',
          shift: 8.62
        }, {
          proton: 'CH(3)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.29
        }, {
          proton: 'CH(4)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.68
        }],
        silicone_greasei: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 0.07
        }],
        tetrahydrofuran: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.85
        }, {
          proton: 'CH2O',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.76
        }],
        toluene: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.36
        }, {
          proton: 'CH(o/p)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.17
        }, {
          proton: 'CH(m)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.25
        }],
        triethylamine: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.03
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 2.53
        }]
      },
      '(cd3)2co': {
        tms: [{
          proton: 'X',
          coupling: 0,
          multiplicity: '',
          shift: 0
        }],
        solvent: [{
          proton: 'X',
          coupling: 0,
          multiplicity: '',
          shift: 2.05
        }],
        h2o: [{
          proton: 'H2O',
          coupling: 0,
          multiplicity: 's',
          shift: 2.84
        }],
        acetic_acid: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.96
        }],
        acetone: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.09
        }],
        acetonitrile: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.05
        }],
        benzene: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.36
        }],
        'tert-butyl_alcohol': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.18
        }],
        'tert-butyl_methyl_ether': [{
          proton: 'CCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.13
        }, {
          proton: 'OCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.13
        }],
        bhtb: [{
          proton: 'ArH',
          coupling: 0,
          multiplicity: 's',
          shift: 6.96
        }, {
          proton: 'ArCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.22
        }, {
          proton: 'ArC(CH3)3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.41
        }],
        chloroform: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 8.02
        }],
        cyclohexane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 1.43
        }],
        '1,2-dichloroethane': [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.87
        }],
        dichloromethane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 5.63
        }],
        diethyl_ether: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.11
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.41
        }],
        diglyme: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.56
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.47
        }, {
          proton: 'OCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.28
        }],
        '1,2-dimethoxyethane': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.28
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.46
        }],
        dimethylacetamide: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 1.97
        }, {
          proton: 'NCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3
        }, {
          proton: 'NCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.83
        }],
        dimethylformamide: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.96
        }, {
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.94
        }, {
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.78
        }],
        dimethyl_sulfoxide: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.52
        }],
        dioxane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.59
        }],
        ethanol: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.12
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.57
        }, {
          proton: 'OH',
          coupling: 5,
          multiplicity: 's,t',
          shift: 3.39
        }],
        ethyl_acetate: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 1.97
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 'q',
          shift: 4.05
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.2
        }],
        ethyl_methyl_ketone: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 2.07
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 'q',
          shift: 2.45
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.96
        }],
        ethylene_glycol: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 3.28
        }],
        'grease^f': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 'm',
          shift: 0.87
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'br_s',
          shift: 1.29
        }],
        'n-hexane': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 't',
          shift: 0.88
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.28
        }],
        hmpag: [{
          proton: 'CH3',
          coupling: 9.5,
          multiplicity: 'd',
          shift: 2.59
        }],
        methanol: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.31
        }, {
          proton: 'OH',
          coupling: 0,
          multiplicity: 's',
          shift: 3.12
        }],
        nitromethane: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 4.43
        }],
        'n-pentane': [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.88
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.27
        }],
        '2-propanol': [{
          proton: 'CH3',
          coupling: 6,
          multiplicity: 'd',
          shift: 1.1
        }, {
          proton: 'CH',
          coupling: 6,
          multiplicity: 'sep',
          shift: 3.9
        }],
        pyridine: [{
          proton: 'CH(2)',
          coupling: 0,
          multiplicity: 'm',
          shift: 8.58
        }, {
          proton: 'CH(3)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.35
        }, {
          proton: 'CH(4)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.76
        }],
        silicone_greasei: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 0.13
        }],
        tetrahydrofuran: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.79
        }, {
          proton: 'CH2O',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.63
        }],
        toluene: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.32
        }, {
          proton: 'CH(o/p)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.5
        }, {
          proton: 'CH(m)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.5
        }],
        triethylamine: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.96
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 2.45
        }]
      },
      dmso: {
        tms: [{
          proton: 'X',
          coupling: 0,
          multiplicity: '',
          shift: 0
        }],
        solvent: [{
          proton: 'X',
          coupling: 0,
          multiplicity: 'quint',
          shift: 2.5
        }],
        h2o: [{
          proton: 'H2O',
          coupling: 0,
          multiplicity: 's',
          shift: 3.33
        }],
        acetic_acid: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.91
        }],
        acetone: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.09
        }],
        acetonitrile: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.07
        }],
        benzene: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.37
        }],
        'tert-butyl_alcohol': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.11
        }, {
          proton: 'OHc',
          coupling: 0,
          multiplicity: 's',
          shift: 4.19
        }],
        'tert-butyl_methyl_ether': [{
          proton: 'CCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.11
        }, {
          proton: 'OCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.08
        }],
        bhtb: [{
          proton: 'ArH',
          coupling: 0,
          multiplicity: 's',
          shift: 6.87
        }, {
          proton: 'OHc',
          coupling: 0,
          multiplicity: 's',
          shift: 6.65
        }, {
          proton: 'ArCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.18
        }, {
          proton: 'ArC(CH3)3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.36
        }],
        chloroform: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 8.32
        }],
        cyclohexane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 1.4
        }],
        '1,2-dichloroethane': [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.9
        }],
        dichloromethane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 5.76
        }],
        diethyl_ether: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.09
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.38
        }],
        diglyme: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.51
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.38
        }, {
          proton: 'OCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.24
        }],
        '1,2-dimethoxyethane': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.24
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.43
        }],
        dimethylacetamide: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 1.96
        }, {
          proton: 'NCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.94
        }, {
          proton: 'NCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.78
        }],
        dimethylformamide: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.95
        }, {
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.89
        }, {
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.73
        }],
        dimethyl_sulfoxide: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.54
        }],
        dioxane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.57
        }],
        ethanol: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.06
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.44
        }, {
          proton: 'OH',
          coupling: 5,
          multiplicity: 's,t',
          shift: 4.63
        }],
        ethyl_acetate: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 1.99
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 'q',
          shift: 4.03
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.17
        }],
        ethyl_methyl_ketone: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 2.07
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 'q',
          shift: 2.43
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.91
        }],
        ethylene_glycol: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 3.34
        }],
        'grease^f': [],
        'n-hexane': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 't',
          shift: 0.86
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.25
        }],
        hmpag: [{
          proton: 'CH3',
          coupling: 9.5,
          multiplicity: 'd',
          shift: 2.53
        }],
        methanol: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.16
        }, {
          proton: 'OH',
          coupling: 0,
          multiplicity: 's',
          shift: 4.01
        }],
        nitromethane: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 4.42
        }],
        'n-pentane': [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.88
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.27
        }],
        '2-propanol': [{
          proton: 'CH3',
          coupling: 6,
          multiplicity: 'd',
          shift: 1.04
        }, {
          proton: 'CH',
          coupling: 6,
          multiplicity: 'sep',
          shift: 3.78
        }],
        pyridine: [{
          proton: 'CH(2)',
          coupling: 0,
          multiplicity: 'm',
          shift: 8.58
        }, {
          proton: 'CH(3)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.39
        }, {
          proton: 'CH(4)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.79
        }],
        silicone_greasei: [],
        tetrahydrofuran: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.76
        }, {
          proton: 'CH2O',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.6
        }],
        toluene: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.3
        }, {
          proton: 'CH(o/p)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.18
        }, {
          proton: 'CH(m)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.25
        }],
        triethylamine: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.93
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 2.43
        }]
      },
      c6d6: {
        tms: [{
          proton: 'X',
          coupling: 0,
          multiplicity: '',
          shift: 0
        }],
        solvent: [{
          proton: 'X',
          coupling: 0,
          multiplicity: '',
          shift: 7.16
        }],
        h2o: [{
          proton: 'H2O',
          coupling: 0,
          multiplicity: 's',
          shift: 0.4
        }],
        acetic_acid: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.55
        }],
        acetone: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.55
        }],
        acetonitrile: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.55
        }],
        benzene: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.15
        }],
        'tert-butyl_alcohol': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.05
        }, {
          proton: 'OHc',
          coupling: 0,
          multiplicity: 's',
          shift: 1.55
        }],
        'tert-butyl_methyl_ether': [{
          proton: 'CCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.07
        }, {
          proton: 'OCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.04
        }],
        bhtb: [{
          proton: 'ArH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.05
        }, {
          proton: 'OHc',
          coupling: 0,
          multiplicity: 's',
          shift: 4.79
        }, {
          proton: 'ArCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.24
        }, {
          proton: 'ArC(CH3)3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.38
        }],
        chloroform: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 6.15
        }],
        cyclohexane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 1.4
        }],
        '1,2-dichloroethane': [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 2.9
        }],
        dichloromethane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 4.27
        }],
        diethyl_ether: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.11
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.26
        }],
        diglyme: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.46
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.34
        }, {
          proton: 'OCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.11
        }],
        '1,2-dimethoxyethane': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.12
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.33
        }],
        dimethylacetamide: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 1.6
        }, {
          proton: 'NCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.57
        }, {
          proton: 'NCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.05
        }],
        dimethylformamide: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.63
        }, {
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.36
        }, {
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.86
        }],
        dimethyl_sulfoxide: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.68
        }],
        dioxane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.35
        }],
        ethanol: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.96
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.34
        }],
        ethyl_acetate: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 1.65
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.89
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.92
        }],
        ethyl_methyl_ketone: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 1.58
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 'q',
          shift: 1.81
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.85
        }],
        ethylene_glycol: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 3.41
        }],
        'grease^f': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 'm',
          shift: 0.92
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'br_s',
          shift: 1.36
        }],
        'n-hexane': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 't',
          shift: 0.89
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.24
        }],
        hmpag: [{
          proton: 'CH3',
          coupling: 9.5,
          multiplicity: 'd',
          shift: 2.4
        }],
        methanol: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.07
        }],
        nitromethane: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.94
        }],
        'n-pentane': [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.86
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.23
        }],
        '2-propanol': [{
          proton: 'CH3',
          coupling: 6,
          multiplicity: 'd',
          shift: 0.95
        }, {
          proton: 'CH',
          coupling: 6,
          multiplicity: 'sep',
          shift: 3.67
        }],
        pyridine: [{
          proton: 'CH(2)',
          coupling: 0,
          multiplicity: 'm',
          shift: 8.53
        }, {
          proton: 'CH(3)',
          coupling: 0,
          multiplicity: 'm',
          shift: 6.66
        }, {
          proton: 'CH(4)',
          coupling: 0,
          multiplicity: 'm',
          shift: 6.98
        }],
        silicone_greasei: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 0.29
        }],
        tetrahydrofuran: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.4
        }, {
          proton: 'CH2O',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.57
        }],
        toluene: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.11
        }, {
          proton: 'CH(o/p)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.02
        }, {
          proton: 'CH(m)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.13
        }],
        triethylamine: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.96
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 2.4
        }]
      },
      cd3cn: {
        tms: [{
          proton: 'X',
          coupling: 0,
          multiplicity: '',
          shift: 0
        }],
        solvent: [{
          proton: 'X',
          coupling: 0,
          multiplicity: '',
          shift: 1.94
        }],
        h2o: [{
          proton: 'H2O',
          coupling: 0,
          multiplicity: 's',
          shift: 2.13
        }],
        acetic_acid: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.96
        }],
        acetone: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.08
        }],
        acetonitrile: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.96
        }],
        benzene: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.37
        }],
        'tert-butyl_alcohol': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.16
        }, {
          proton: 'OHc',
          coupling: 0,
          multiplicity: 's',
          shift: 2.18
        }],
        'tert-butyl_methyl_ether': [{
          proton: 'CCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.14
        }, {
          proton: 'OCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.13
        }],
        bhtb: [{
          proton: 'ArH',
          coupling: 0,
          multiplicity: 's',
          shift: 6.97
        }, {
          proton: 'OHc',
          coupling: 0,
          multiplicity: 's',
          shift: 5.2
        }, {
          proton: 'ArCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.22
        }, {
          proton: 'ArC(CH3)3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.39
        }],
        chloroform: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.58
        }],
        cyclohexane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 1.44
        }],
        '1,2-dichloroethane': [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.81
        }],
        dichloromethane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 5.44
        }],
        diethyl_ether: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.12
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.42
        }],
        diglyme: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.53
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.45
        }, {
          proton: 'OCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.29
        }],
        '1,2-dimethoxyethane': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.28
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.45
        }],
        dimethylacetamide: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 1.97
        }, {
          proton: 'NCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.96
        }, {
          proton: 'NCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.83
        }],
        dimethylformamide: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.92
        }, {
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.89
        }, {
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.77
        }],
        dimethyl_sulfoxide: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.5
        }],
        dioxane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.6
        }],
        ethanol: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.12
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.54
        }, {
          proton: 'OH',
          coupling: 5,
          multiplicity: 's,t',
          shift: 2.47
        }],
        ethyl_acetate: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 1.97
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 'q',
          shift: 4.06
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.2
        }],
        ethyl_methyl_ketone: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 2.06
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 'q',
          shift: 2.43
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.96
        }],
        ethylene_glycol: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 3.51
        }],
        'grease^f': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 'm',
          shift: 0.86
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'br_s',
          shift: 1.27
        }],
        'n-hexane': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 't',
          shift: 0.89
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.28
        }],
        hmpag: [{
          proton: 'CH3',
          coupling: 9.5,
          multiplicity: 'd',
          shift: 2.57
        }],
        methanol: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.28
        }, {
          proton: 'OH',
          coupling: 0,
          multiplicity: 's',
          shift: 2.16
        }],
        nitromethane: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 4.31
        }],
        'n-pentane': [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.87
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.29
        }],
        '2-propanol': [{
          proton: 'CH3',
          coupling: 6,
          multiplicity: 'd',
          shift: 1.09
        }, {
          proton: 'CH',
          coupling: 6,
          multiplicity: 'sep',
          shift: 3.87
        }],
        pyridine: [{
          proton: 'CH(2)',
          coupling: 0,
          multiplicity: 'm',
          shift: 8.57
        }, {
          proton: 'CH(3)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.33
        }, {
          proton: 'CH(4)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.73
        }],
        silicone_greasei: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 0.08
        }],
        tetrahydrofuran: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.8
        }, {
          proton: 'CH2O',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.64
        }],
        toluene: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.33
        }, {
          proton: 'CH(o/p)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.2
        }, {
          proton: 'CH(m)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.2
        }],
        triethylamine: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.96
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 2.45
        }]
      },
      cd3od: {
        tms: [{
          proton: 'X',
          coupling: 0,
          multiplicity: '',
          shift: 0
        }],
        solvent: [{
          proton: 'X',
          coupling: 0,
          multiplicity: '',
          shift: 3.31
        }],
        h2o: [{
          proton: 'H2O',
          coupling: 0,
          multiplicity: 's',
          shift: 4.87
        }],
        acetic_acid: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.99
        }],
        acetone: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.15
        }],
        acetonitrile: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.03
        }],
        benzene: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.33
        }],
        'tert-butyl_alcohol': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.4
        }],
        'tert-butyl_methyl_ether': [{
          proton: 'CCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.15
        }, {
          proton: 'OCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.2
        }],
        bhtb: [{
          proton: 'ArH',
          coupling: 0,
          multiplicity: 's',
          shift: 6.92
        }, {
          proton: 'ArCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.21
        }, {
          proton: 'ArC(CH3)3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.4
        }],
        chloroform: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.9
        }],
        cyclohexane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 1.45
        }],
        '1,2-dichloroethane': [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.78
        }],
        dichloromethane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 5.49
        }],
        diethyl_ether: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.18
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.49
        }],
        diglyme: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.61
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.58
        }, {
          proton: 'OCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.35
        }],
        '1,2-dimethoxyethane': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.35
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.52
        }],
        dimethylacetamide: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 2.07
        }, {
          proton: 'NCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.31
        }, {
          proton: 'NCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.92
        }],
        dimethylformamide: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.97
        }, {
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.99
        }, {
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.86
        }],
        dimethyl_sulfoxide: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.65
        }],
        dioxane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.66
        }],
        ethanol: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.19
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.6
        }],
        ethyl_acetate: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 2.01
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 'q',
          shift: 4.09
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.24
        }],
        ethyl_methyl_ketone: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 2.12
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 'q',
          shift: 2.5
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.01
        }],
        ethylene_glycol: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 3.59
        }],
        'grease^f': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 'm',
          shift: 0.88
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'br_s',
          shift: 1.29
        }],
        'n-hexane': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 't',
          shift: 0.9
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.29
        }],
        hmpag: [{
          proton: 'CH3',
          coupling: 9.5,
          multiplicity: 'd',
          shift: 2.64
        }],
        methanol: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.34
        }],
        nitromethane: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 4.34
        }],
        'n-pentane': [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.89
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.29
        }],
        '2-propanol': [{
          proton: 'CH3',
          coupling: 6,
          multiplicity: 'd',
          shift: 1.5
        }, {
          proton: 'CH',
          coupling: 6,
          multiplicity: 'sep',
          shift: 3.92
        }],
        pyridine: [{
          proton: 'CH(2)',
          coupling: 0,
          multiplicity: 'm',
          shift: 8.53
        }, {
          proton: 'CH(3)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.44
        }, {
          proton: 'CH(4)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.85
        }],
        silicone_greasei: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 0.1
        }],
        tetrahydrofuran: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.87
        }, {
          proton: 'CH2O',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.71
        }],
        toluene: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.32
        }, {
          proton: 'CH(o/p)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.16
        }, {
          proton: 'CH(m)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.16
        }],
        triethylamine: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.05
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 2.58
        }]
      },
      d2o: {
        tms: [{
          proton: 'X',
          coupling: 0,
          multiplicity: '',
          shift: 0
        }],
        solvent: [{
          proton: 'X',
          coupling: 0,
          multiplicity: '',
          shift: 4.79
        }],
        h2o: [],
        acetic_acid: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.08
        }],
        acetone: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.22
        }],
        acetonitrile: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.06
        }],
        benzene: [],
        'tert-butyl_alcohol': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.24
        }],
        'tert-butyl_methyl_ether': [{
          proton: 'CCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 1.21
        }, {
          proton: 'OCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.22
        }],
        bhtb: [],
        chloroform: [],
        cyclohexane: [],
        '1,2-dichloroethane': [],
        dichloromethane: [],
        diethyl_ether: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.17
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.56
        }],
        diglyme: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.67
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.61
        }, {
          proton: 'OCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.37
        }],
        '1,2-dimethoxyethane': [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.37
        }, {
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.6
        }],
        dimethylacetamide: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 2.08
        }, {
          proton: 'NCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.06
        }, {
          proton: 'NCH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.9
        }],
        dimethylformamide: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 7.92
        }, {
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.01
        }, {
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.85
        }],
        dimethyl_sulfoxide: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 2.71
        }],
        dioxane: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 's',
          shift: 3.75
        }],
        ethanol: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.17
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.65
        }],
        ethyl_acetate: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 2.07
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 'q',
          shift: 4.14
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.24
        }],
        ethyl_methyl_ketone: [{
          proton: 'CH3CO',
          coupling: 0,
          multiplicity: 's',
          shift: 2.19
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 'q',
          shift: 3.18
        }, {
          proton: 'CH2CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 1.26
        }],
        ethylene_glycol: [{
          proton: 'CH',
          coupling: 0,
          multiplicity: 's',
          shift: 3.65
        }],
        'grease^f': [],
        'n-hexane': [],
        hmpag: [{
          proton: 'CH3',
          coupling: 9.5,
          multiplicity: 'd',
          shift: 2.61
        }],
        methanol: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 3.34
        }],
        nitromethane: [{
          proton: 'CH3',
          coupling: 0,
          multiplicity: 's',
          shift: 4.4
        }],
        'n-pentane': [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.9
        }],
        '2-propanol': [{
          proton: 'CH3',
          coupling: 6,
          multiplicity: 'd',
          shift: 1.17
        }, {
          proton: 'CH',
          coupling: 6,
          multiplicity: 'sep',
          shift: 4.02
        }],
        pyridine: [{
          proton: 'CH(2)',
          coupling: 0,
          multiplicity: 'm',
          shift: 8.52
        }, {
          proton: 'CH(3)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.45
        }, {
          proton: 'CH(4)',
          coupling: 0,
          multiplicity: 'm',
          shift: 7.87
        }],
        silicone_greasei: [],
        tetrahydrofuran: [{
          proton: 'CH2',
          coupling: 0,
          multiplicity: 'm',
          shift: 1.88
        }, {
          proton: 'CH2O',
          coupling: 0,
          multiplicity: 'm',
          shift: 3.74
        }],
        toluene: [],
        triethylamine: [{
          proton: 'CH3',
          coupling: 7,
          multiplicity: 't',
          shift: 0.99
        }, {
          proton: 'CH2',
          coupling: 7,
          multiplicity: 'q',
          shift: 2.57
        }]
      }
    };
    const impurities = impuritiesContent;

    const SignalKinds = [{
      label: 'Signal',
      value: 'signal'
    }, {
      label: 'Reference',
      value: 'reference'
    }, {
      label: 'Solvent',
      value: 'solvent'
    }, {
      label: 'Impurity',
      value: 'impurity'
    }, {
      label: 'Standard',
      value: 'standard'
    }, {
      label: 'P1',
      value: 'p1'
    }, {
      label: 'P2',
      value: 'p2'
    }, {
      label: 'P3',
      value: 'p3'
    }];
    const SignalKindsToInclude = ['signal'];
    const DatumKind = {
      signal: 'signal',
      mixed: 'mixed'
    };

    const MultiplicityPatterns = [{
      label: 'singlet',
      value: 's',
      multiplicity: 1,
      names: ['br s', 'br. s']
    }, {
      label: 'triplet',
      value: 't',
      multiplicity: 3,
      names: []
    }, {
      label: 'doublet',
      value: 'd',
      multiplicity: 2,
      names: []
    }, {
      label: 'quartet',
      value: 'q',
      multiplicity: 4,
      names: []
    }, {
      label: 'quintet',
      value: 'i',
      acs: 'quint',
      multiplicity: 5,
      names: ['quint', 'qui', 'qnt', 'pentet', 'pnt', 'pent']
    }, {
      label: 'sextet',
      value: 'h',
      multiplicity: 6,
      names: ['x', 'sxt', 'sext', 'hexuplet']
    }, {
      label: 'septet',
      value: 'p',
      acs: 'sept',
      multiplicity: 7,
      names: ['sept', 'spt', 'heptet', 'hpt', 'hept']
    }, {
      label: 'octet',
      value: 'o',
      multiplicity: 8,
      names: ['oct']
    }, {
      label: 'nonet',
      value: 'n',
      multiplicity: 9,
      names: ['non']
    }, {
      label: 'massive',
      value: 'm',
      multiplicity: null,
      names: []
    }];

    MultiplicityPatterns.sort((a, b) => a.multiplicity !== null && b.multiplicity !== null ? a.multiplicity - b.multiplicity : Number.MAX_SAFE_INTEGER);
    const couplingPatterns = MultiplicityPatterns.map(m => m.value);
    const couplingACSPatterns = MultiplicityPatterns.map(m => m.acs || m.value);

    const toCheck = ['solvent', 'h2o', 'tms'];
    /**
     * Try to remove peaks of impurities.
     */
    function peaksFilterImpurities(peakList, options = {}) {
      const {
        error = 0.025,
        remove = false
      } = options;
      if (options.solvent) {
        let {
          solvent
        } = options;
        if (solvent === '(cd3)2so') solvent = 'dmso';
        if (solvent === 'meod') solvent = 'cd3od';
        const solventImpurities = impurities[solvent];
        for (const impurity of toCheck) {
          const impurityShifts = solventImpurities[impurity];
          checkImpurity(peakList, impurityShifts, {
            error,
            remove,
            name: impurity
          });
        }
      }
      return peakList;
    }
    function checkImpurity(peakList, impurity, options) {
      const {
        name,
        error,
        remove
      } = options;
      let j, tolerance, difference;
      let i = impurity.length;
      while (i--) {
        j = peakList.length;
        while (j--) {
          tolerance = error + peakList[j].width;
          difference = Math.abs(impurity[i].shift - peakList[j].x);
          if (difference < tolerance) {
            // && (impurity[i].multiplicity === '' || (impurity[i].multiplicity.indexOf(peakList[j].multiplicity)) { // some impurities has multiplicities like 'bs' but at presents it is unsupported
            if (remove) {
              peakList.splice(j, 1);
            } else {
              peakList[j].kind = name;
            }
          }
        }
      }
    }

    const GAUSSIAN_EXP_FACTOR = -4 * Math.LN2;
    const ROOT_PI_OVER_LN2 = Math.sqrt(Math.PI / Math.LN2);
    const ROOT_THREE = Math.sqrt(3);
    const ROOT_2LN2 = Math.sqrt(2 * Math.LN2);
    const ROOT_2LN2_MINUS_ONE = Math.sqrt(2 * Math.LN2) - 1;

    // https://en.wikipedia.org/wiki/Error_function#Inverse_functions
    // This code yields to a good approximation
    // If needed a better implementation using polynomial can be found on https://en.wikipedia.org/wiki/Error_function#Inverse_functions
    function erfinv(x) {
      let a = 0.147;
      if (x === 0) return 0;
      let ln1MinusXSqrd = Math.log(1 - x * x);
      let lnEtcBy2Plus2 = ln1MinusXSqrd / 2 + 2 / (Math.PI * a);
      let firstSqrt = Math.sqrt(lnEtcBy2Plus2 ** 2 - ln1MinusXSqrd / a);
      let secondSqrt = Math.sqrt(firstSqrt - lnEtcBy2Plus2);
      return secondSqrt * (x > 0 ? 1 : -1);
    }

    class Gaussian {
      constructor(options = {}) {
        const {
          fwhm = 500,
          sd
        } = options;
        this.fwhm = sd ? gaussianWidthToFWHM(2 * sd) : fwhm;
      }
      fwhmToWidth(fwhm = this.fwhm) {
        return gaussianFwhmToWidth(fwhm);
      }
      widthToFWHM(width) {
        return gaussianWidthToFWHM(width);
      }
      fct(x) {
        return gaussianFct(x, this.fwhm);
      }
      getArea(height = calculateGaussianHeight({
        fwhm: this.fwhm
      })) {
        return getGaussianArea({
          fwhm: this.fwhm,
          height
        });
      }
      getFactor(area) {
        return getGaussianFactor(area);
      }
      getData(options = {}) {
        return getGaussianData(this, options);
      }
      calculateHeight(area = 1) {
        return calculateGaussianHeight({
          fwhm: this.fwhm,
          area
        });
      }
      getParameters() {
        return ['fwhm'];
      }
    }
    function calculateGaussianHeight(options) {
      let {
        fwhm = 500,
        area = 1,
        sd
      } = options;
      if (sd) fwhm = gaussianWidthToFWHM(2 * sd);
      return 2 * area / ROOT_PI_OVER_LN2 / fwhm;
    }
    /**
     * Calculate the height of the gaussian function of a specific width (fwhm) at a speicifc
     * x position (the gaussian is centered on x=0)
     * @param x
     * @param fwhm
     * @returns y
     */
    function gaussianFct(x, fwhm) {
      return Math.exp(GAUSSIAN_EXP_FACTOR * Math.pow(x / fwhm, 2));
    }
    function gaussianWidthToFWHM(width) {
      return width * ROOT_2LN2;
    }
    function gaussianFwhmToWidth(fwhm) {
      return fwhm / ROOT_2LN2;
    }
    function getGaussianArea(options) {
      let {
        fwhm = 500,
        sd,
        height = 1
      } = options;
      if (sd) fwhm = gaussianWidthToFWHM(2 * sd);
      return height * ROOT_PI_OVER_LN2 * fwhm / 2;
    }
    function getGaussianFactor(area = 0.9999) {
      return Math.sqrt(2) * erfinv(area);
    }
    function getGaussianData(shape = {}, options = {}) {
      let {
        fwhm = 500,
        sd
      } = shape;
      if (sd) fwhm = gaussianWidthToFWHM(2 * sd);
      let {
        length,
        factor = getGaussianFactor(),
        height = calculateGaussianHeight({
          fwhm
        })
      } = options;
      if (!length) {
        length = Math.min(Math.ceil(fwhm * factor), Math.pow(2, 25) - 1);
        if (length % 2 === 0) length++;
      }
      const center = (length - 1) / 2;
      const data = new Float64Array(length);
      for (let i = 0; i <= center; i++) {
        data[i] = gaussianFct(i - center, fwhm) * height;
        data[length - 1 - i] = data[i];
      }
      return data;
    }

    class Lorentzian {
      constructor(options = {}) {
        const {
          fwhm = 500
        } = options;
        this.fwhm = fwhm;
      }
      fwhmToWidth(fwhm = this.fwhm) {
        return lorentzianFwhmToWidth(fwhm);
      }
      widthToFWHM(width) {
        return lorentzianWidthToFWHM(width);
      }
      fct(x) {
        return lorentzianFct(x, this.fwhm);
      }
      getArea(height = 1) {
        return getLorentzianArea({
          fwhm: this.fwhm,
          height
        });
      }
      getFactor(area) {
        return getLorentzianFactor(area);
      }
      getData(options = {}) {
        return getLorentzianData(this, options);
      }
      calculateHeight(area = 1) {
        return calculateLorentzianHeight({
          fwhm: this.fwhm,
          area
        });
      }
      getParameters() {
        return ['fwhm'];
      }
    }
    const calculateLorentzianHeight = ({
      fwhm = 1,
      area = 1
    }) => {
      return 2 * area / Math.PI / fwhm;
    };
    const getLorentzianArea = options => {
      const {
        fwhm = 500,
        height = 1
      } = options;
      return height * Math.PI * fwhm / 2;
    };
    const lorentzianFct = (x, fwhm) => {
      return fwhm ** 2 / (4 * x ** 2 + fwhm ** 2);
    };
    const lorentzianWidthToFWHM = width => {
      return width * ROOT_THREE;
    };
    const lorentzianFwhmToWidth = fwhm => {
      return fwhm / ROOT_THREE;
    };
    const getLorentzianFactor = (area = 0.9999) => {
      if (area >= 1) {
        throw new Error('area should be (0 - 1)');
      }
      const halfResidual = (1 - area) * 0.5;
      const quantileFunction = p => Math.tan(Math.PI * (p - 0.5));
      return (quantileFunction(1 - halfResidual) - quantileFunction(halfResidual)) / 2;
    };
    const getLorentzianData = (shape = {}, options = {}) => {
      let {
        fwhm = 500
      } = shape;
      let {
        length,
        factor = getLorentzianFactor(),
        height = calculateLorentzianHeight({
          fwhm,
          area: 1
        })
      } = options;
      if (!length) {
        length = Math.min(Math.ceil(fwhm * factor), Math.pow(2, 25) - 1);
        if (length % 2 === 0) length++;
      }
      const center = (length - 1) / 2;
      const data = new Float64Array(length);
      for (let i = 0; i <= center; i++) {
        data[i] = lorentzianFct(i - center, fwhm) * height;
        data[length - 1 - i] = data[i];
      }
      return data;
    };

    class PseudoVoigt {
      constructor(options = {}) {
        const {
          fwhm = 500,
          mu = 0.5
        } = options;
        this.mu = mu;
        this.fwhm = fwhm;
      }
      fwhmToWidth(fwhm = this.fwhm, mu = this.mu) {
        return pseudoVoigtFwhmToWidth(fwhm, mu);
      }
      widthToFWHM(width, mu = this.mu) {
        return pseudoVoigtWidthToFWHM(width, mu);
      }
      fct(x) {
        return pseudoVoigtFct(x, this.fwhm, this.mu);
      }
      getArea(height = 1) {
        return getPseudoVoigtArea({
          fwhm: this.fwhm,
          height,
          mu: this.mu
        });
      }
      getFactor(area) {
        return getPseudoVoigtFactor(area);
      }
      getData(options = {}) {
        const {
          length,
          factor,
          height = calculatePseudoVoigtHeight({
            fwhm: this.fwhm,
            mu: this.mu,
            area: 1
          })
        } = options;
        return getPseudoVoigtData(this, {
          factor,
          length,
          height
        });
      }
      calculateHeight(area = 1) {
        return calculatePseudoVoigtHeight({
          fwhm: this.fwhm,
          mu: this.mu,
          area
        });
      }
      getParameters() {
        return ['fwhm', 'mu'];
      }
    }
    const calculatePseudoVoigtHeight = (options = {}) => {
      let {
        fwhm = 1,
        mu = 0.5,
        area = 1
      } = options;
      return 2 * area / (fwhm * (mu * ROOT_PI_OVER_LN2 + (1 - mu) * Math.PI));
    };
    const pseudoVoigtFct = (x, fwhm, mu) => {
      return (1 - mu) * lorentzianFct(x, fwhm) + mu * gaussianFct(x, fwhm);
    };
    const pseudoVoigtWidthToFWHM = (width, mu = 0.5) => {
      return width * (mu * ROOT_2LN2_MINUS_ONE + 1);
    };
    const pseudoVoigtFwhmToWidth = (fwhm, mu = 0.5) => {
      return fwhm / (mu * ROOT_2LN2_MINUS_ONE + 1);
    };
    const getPseudoVoigtArea = options => {
      const {
        fwhm = 500,
        height = 1,
        mu = 0.5
      } = options;
      return fwhm * height * (mu * ROOT_PI_OVER_LN2 + (1 - mu) * Math.PI) / 2;
    };
    const getPseudoVoigtFactor = (area = 0.9999, mu = 0.5) => {
      return mu < 1 ? getLorentzianFactor(area) : getGaussianFactor(area);
    };
    const getPseudoVoigtData = (shape = {}, options = {}) => {
      let {
        fwhm = 500,
        mu = 0.5
      } = shape;
      let {
        length,
        factor = getPseudoVoigtFactor(0.999, mu),
        height = calculatePseudoVoigtHeight({
          fwhm,
          mu,
          area: 1
        })
      } = options;
      if (!height) {
        height = 1 / (mu / Math.sqrt(-GAUSSIAN_EXP_FACTOR / Math.PI) * fwhm + (1 - mu) * fwhm * Math.PI / 2);
      }
      if (!length) {
        length = Math.min(Math.ceil(fwhm * factor), Math.pow(2, 25) - 1);
        if (length % 2 === 0) length++;
      }
      const center = (length - 1) / 2;
      const data = new Float64Array(length);
      for (let i = 0; i <= center; i++) {
        data[i] = pseudoVoigtFct(i - center, fwhm, mu) * height;
        data[length - 1 - i] = data[i];
      }
      return data;
    };

    class Gaussian2D {
      constructor(options = {}) {
        let {
          fwhm = 20,
          sd
        } = options;
        fwhm = ensureFWHM2D(fwhm, sd);
        this.fwhmX = fwhm.x;
        this.fwhmY = fwhm.y;
      }
      fct(x, y) {
        return gaussian2DFct(x, y, this.fwhmX, this.fwhmY);
      }
      getData(options = {}) {
        return getGaussian2DData({
          fwhm: {
            x: this.fwhmX,
            y: this.fwhmY
          }
        }, options);
      }
      getFactor(volume = 1) {
        return getGaussianFactor(volume);
      }
      getVolume(height = calculateGaussian2DHeight({
        fwhm: {
          x: this.fwhmX,
          y: this.fwhmY
        },
        volume: 1
      })) {
        return getGaussian2DVolume({
          fwhm: {
            x: this.fwhmX,
            y: this.fwhmY
          },
          height
        });
      }
      widthToFWHM(width) {
        return gaussianWidthToFWHM(width);
      }
      fwhmToWidth(fwhm) {
        return gaussianFwhmToWidth(fwhm);
      }
      calculateHeight(volume = 1) {
        return calculateGaussian2DHeight({
          volume,
          fwhm: {
            x: this.fwhmX,
            y: this.fwhmY
          }
        });
      }
      set fwhm(fwhm) {
        fwhm = ensureXYNumber$2(fwhm);
        this.fwhmX = fwhm.x;
        this.fwhmY = fwhm.y;
      }
    }
    const gaussian2DFct = (x, y, xFWHM, yFWHM) => {
      return Math.exp(GAUSSIAN_EXP_FACTOR * (Math.pow(x / xFWHM, 2) + Math.pow(y / yFWHM, 2)));
    };
    const getGaussian2DData = (shape, options = {}) => {
      let {
        fwhm = 50,
        sd
      } = shape;
      fwhm = ensureFWHM2D(fwhm, sd);
      let {
        factor = getGaussianFactor(),
        length = {
          x: 0,
          y: 0
        },
        height = calculateGaussian2DHeight({
          fwhm,
          volume: 1
        })
      } = options;
      factor = ensureXYNumber$2(factor);
      length = ensureXYNumber$2(length);
      for (const axis of ['x', 'y']) {
        if (!length[axis]) {
          length[axis] = Math.min(Math.ceil(fwhm[axis] * factor[axis]), Math.pow(2, 25) - 1);
          if (length[axis] % 2 === 0) length[axis]++;
        }
      }
      const xCenter = (length.x - 1) / 2;
      const yCenter = (length.y - 1) / 2;
      const data = new Array(length.x);
      for (let i = 0; i < length.x; i++) {
        data[i] = new Float64Array(length.y);
      }
      for (let i = 0; i < length.x; i++) {
        for (let j = 0; j < length.y; j++) {
          data[i][j] = gaussian2DFct(i - xCenter, j - yCenter, fwhm.x, fwhm.y) * height;
        }
      }
      return data;
    };
    const calculateGaussian2DHeight = (options = {}) => {
      let {
        volume = 1,
        fwhm = 50,
        sd
      } = options;
      fwhm = ensureFWHM2D(fwhm, sd);
      return volume * Math.LN2 * 4 / (Math.PI * fwhm.y * fwhm.x);
    };
    const getGaussian2DVolume = (options = {}) => {
      let {
        fwhm = 50,
        height = 1,
        sd
      } = options;
      fwhm = ensureFWHM2D(fwhm, sd);
      return height * Math.PI * fwhm.y * fwhm.x / Math.LN2 / 4;
    };
    function ensureXYNumber$2(input) {
      return typeof input !== 'object' ? {
        x: input,
        y: input
      } : {
        ...input
      };
    }
    function ensureFWHM2D(fwhm, sd) {
      if (sd !== undefined) {
        let sdObject = ensureXYNumber$2(sd);
        return {
          x: gaussianWidthToFWHM(2 * sdObject.x),
          y: gaussianWidthToFWHM(2 * sdObject.y)
        };
      } else if (fwhm !== undefined) {
        return ensureXYNumber$2(fwhm);
      } else {
        throw new Error('ensureFWHM2D must have either fwhm or sd defined');
      }
    }

    /**
     * Generate a instance of a specific kind of shape.
     */
    function getShape1D(shape) {
      const {
        kind
      } = shape;
      switch (kind) {
        case 'gaussian':
          return new Gaussian(shape);
        case 'lorentzian':
          return new Lorentzian(shape);
        case 'pseudoVoigt':
          return new PseudoVoigt(shape);
        default:
          {
            throw Error(`Unknown distribution ${kind}`);
          }
      }
    }

    /**
     * Generate a instance of a specific kind of shape.
     */
    function getShape2D(shape) {
      const {
        kind
      } = shape;
      switch (kind) {
        case 'gaussian':
          return new Gaussian2D(shape);
        default:
          {
            const unHandled = kind;
            // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
            throw Error(`Unknown distribution ${unHandled}`);
          }
      }
    }

    function addBaseline(data, baselineFct) {
      if (!baselineFct) return data;
      let xs = data.x;
      let ys = data.y;
      for (let i = 0; i < xs.length; i++) {
        ys[i] += baselineFct(xs[i]);
      }
      return data;
    }

    /**
     * Calculates reimAbsolute value of a complex spectrum
     *
     * @param data - complex spectrum
     * @returns - reimAbsolute value
     */
    function reimAbsolute(data) {
      const length = data.re.length;
      const re = data.re;
      const im = data.im;
      const newArray = new Float64Array(length);
      for (let i = 0; i < length; i++) {
        newArray[i] = Math.sqrt(re[i] ** 2 + im[i] ** 2);
      }
      return newArray;
    }

    var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

    var d3Array = {exports: {}};

    (function (module, exports) {
      (function (global, factory) {
        factory(exports) ;
      })(commonjsGlobal, function (exports) {

        function ascending(a, b) {
          return a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;
        }
        function bisector(compare) {
          if (compare.length === 1) compare = ascendingComparator(compare);
          return {
            left: function (a, x, lo, hi) {
              if (lo == null) lo = 0;
              if (hi == null) hi = a.length;
              while (lo < hi) {
                var mid = lo + hi >>> 1;
                if (compare(a[mid], x) < 0) lo = mid + 1;else hi = mid;
              }
              return lo;
            },
            right: function (a, x, lo, hi) {
              if (lo == null) lo = 0;
              if (hi == null) hi = a.length;
              while (lo < hi) {
                var mid = lo + hi >>> 1;
                if (compare(a[mid], x) > 0) hi = mid;else lo = mid + 1;
              }
              return lo;
            }
          };
        }
        function ascendingComparator(f) {
          return function (d, x) {
            return ascending(f(d), x);
          };
        }
        var ascendingBisect = bisector(ascending);
        var bisectRight = ascendingBisect.right;
        var bisectLeft = ascendingBisect.left;
        function descending(a, b) {
          return b < a ? -1 : b > a ? 1 : b >= a ? 0 : NaN;
        }
        function number$1(x) {
          return x === null ? NaN : +x;
        }
        function variance(array, f) {
          var n = array.length,
            m = 0,
            a,
            d,
            s = 0,
            i = -1,
            j = 0;
          if (f == null) {
            while (++i < n) {
              if (!isNaN(a = number$1(array[i]))) {
                d = a - m;
                m += d / ++j;
                s += d * (a - m);
              }
            }
          } else {
            while (++i < n) {
              if (!isNaN(a = number$1(f(array[i], i, array)))) {
                d = a - m;
                m += d / ++j;
                s += d * (a - m);
              }
            }
          }
          if (j > 1) return s / (j - 1);
        }
        function deviation(array, f) {
          var v = variance(array, f);
          return v ? Math.sqrt(v) : v;
        }
        function extent(array, f) {
          var i = -1,
            n = array.length,
            a,
            b,
            c;
          if (f == null) {
            while (++i < n) if ((b = array[i]) != null && b >= b) {
              a = c = b;
              break;
            }
            while (++i < n) if ((b = array[i]) != null) {
              if (a > b) a = b;
              if (c < b) c = b;
            }
          } else {
            while (++i < n) if ((b = f(array[i], i, array)) != null && b >= b) {
              a = c = b;
              break;
            }
            while (++i < n) if ((b = f(array[i], i, array)) != null) {
              if (a > b) a = b;
              if (c < b) c = b;
            }
          }
          return [a, c];
        }
        function constant(x) {
          return function () {
            return x;
          };
        }
        function identity(x) {
          return x;
        }
        function range(start, stop, step) {
          start = +start, stop = +stop, step = (n = arguments.length) < 2 ? (stop = start, start = 0, 1) : n < 3 ? 1 : +step;
          var i = -1,
            n = Math.max(0, Math.ceil((stop - start) / step)) | 0,
            range = new Array(n);
          while (++i < n) {
            range[i] = start + i * step;
          }
          return range;
        }
        var e10 = Math.sqrt(50);
        var e5 = Math.sqrt(10);
        var e2 = Math.sqrt(2);
        function ticks(start, stop, count) {
          var step = tickStep(start, stop, count);
          return range(Math.ceil(start / step) * step, Math.floor(stop / step) * step + step / 2,
          // inclusive
          step);
        }
        function tickStep(start, stop, count) {
          var step0 = Math.abs(stop - start) / Math.max(0, count),
            step1 = Math.pow(10, Math.floor(Math.log(step0) / Math.LN10)),
            error = step0 / step1;
          if (error >= e10) step1 *= 10;else if (error >= e5) step1 *= 5;else if (error >= e2) step1 *= 2;
          return stop < start ? -step1 : step1;
        }
        function sturges(values) {
          return Math.ceil(Math.log(values.length) / Math.LN2) + 1;
        }
        function number(x) {
          return +x;
        }
        function histogram() {
          var value = identity,
            domain = extent,
            threshold = sturges;
          function histogram(data) {
            var i,
              n = data.length,
              x,
              values = new Array(n);

            // Coerce values to numbers.
            for (i = 0; i < n; ++i) {
              values[i] = +value(data[i], i, data);
            }
            var xz = domain(values),
              x0 = +xz[0],
              x1 = +xz[1],
              tz = threshold(values, x0, x1);

            // Convert number of thresholds into uniform thresholds.
            if (!Array.isArray(tz)) tz = ticks(x0, x1, +tz);

            // Coerce thresholds to numbers, ignoring any outside the domain.
            var m = tz.length;
            for (i = 0; i < m; ++i) tz[i] = +tz[i];
            while (tz[0] <= x0) tz.shift(), --m;
            while (tz[m - 1] >= x1) tz.pop(), --m;
            var bins = new Array(m + 1),
              bin;

            // Initialize bins.
            for (i = 0; i <= m; ++i) {
              bin = bins[i] = [];
              bin.x0 = i > 0 ? tz[i - 1] : x0;
              bin.x1 = i < m ? tz[i] : x1;
            }

            // Assign data to bins by value, ignoring any outside the domain.
            for (i = 0; i < n; ++i) {
              x = values[i];
              if (x0 <= x && x <= x1) {
                bins[bisectRight(tz, x, 0, m)].push(data[i]);
              }
            }
            return bins;
          }
          histogram.value = function (_) {
            return arguments.length ? (value = typeof _ === "function" ? _ : constant(+_), histogram) : value;
          };
          histogram.domain = function (_) {
            return arguments.length ? (domain = typeof _ === "function" ? _ : constant([+_[0], +_[1]]), histogram) : domain;
          };
          histogram.thresholds = function (_) {
            if (!arguments.length) return threshold;
            threshold = typeof _ === "function" ? _ : Array.isArray(_) ? constant(Array.prototype.map.call(_, number)) : constant(+_);
            return histogram;
          };
          return histogram;
        }
        function quantile(array, p, f) {
          if (f == null) f = number$1;
          if (!(n = array.length)) return;
          if ((p = +p) <= 0 || n < 2) return +f(array[0], 0, array);
          if (p >= 1) return +f(array[n - 1], n - 1, array);
          var n,
            h = (n - 1) * p,
            i = Math.floor(h),
            a = +f(array[i], i, array),
            b = +f(array[i + 1], i + 1, array);
          return a + (b - a) * (h - i);
        }
        function freedmanDiaconis(values, min, max) {
          values.sort(ascending);
          return Math.ceil((max - min) / (2 * (quantile(values, 0.75) - quantile(values, 0.25)) * Math.pow(values.length, -1 / 3)));
        }
        function scott(values, min, max) {
          return Math.ceil((max - min) / (3.5 * deviation(values) * Math.pow(values.length, -1 / 3)));
        }
        function max(array, f) {
          var i = -1,
            n = array.length,
            a,
            b;
          if (f == null) {
            while (++i < n) if ((b = array[i]) != null && b >= b) {
              a = b;
              break;
            }
            while (++i < n) if ((b = array[i]) != null && b > a) a = b;
          } else {
            while (++i < n) if ((b = f(array[i], i, array)) != null && b >= b) {
              a = b;
              break;
            }
            while (++i < n) if ((b = f(array[i], i, array)) != null && b > a) a = b;
          }
          return a;
        }
        function mean(array, f) {
          var s = 0,
            n = array.length,
            a,
            i = -1,
            j = n;
          if (f == null) {
            while (++i < n) if (!isNaN(a = number$1(array[i]))) s += a;else --j;
          } else {
            while (++i < n) if (!isNaN(a = number$1(f(array[i], i, array)))) s += a;else --j;
          }
          if (j) return s / j;
        }
        function median(array, f) {
          var numbers = [],
            n = array.length,
            a,
            i = -1;
          if (f == null) {
            while (++i < n) if (!isNaN(a = number$1(array[i]))) numbers.push(a);
          } else {
            while (++i < n) if (!isNaN(a = number$1(f(array[i], i, array)))) numbers.push(a);
          }
          return quantile(numbers.sort(ascending), 0.5);
        }
        function merge(arrays) {
          var n = arrays.length,
            m,
            i = -1,
            j = 0,
            merged,
            array;
          while (++i < n) j += arrays[i].length;
          merged = new Array(j);
          while (--n >= 0) {
            array = arrays[n];
            m = array.length;
            while (--m >= 0) {
              merged[--j] = array[m];
            }
          }
          return merged;
        }
        function min(array, f) {
          var i = -1,
            n = array.length,
            a,
            b;
          if (f == null) {
            while (++i < n) if ((b = array[i]) != null && b >= b) {
              a = b;
              break;
            }
            while (++i < n) if ((b = array[i]) != null && a > b) a = b;
          } else {
            while (++i < n) if ((b = f(array[i], i, array)) != null && b >= b) {
              a = b;
              break;
            }
            while (++i < n) if ((b = f(array[i], i, array)) != null && a > b) a = b;
          }
          return a;
        }
        function pairs(array) {
          var i = 0,
            n = array.length - 1,
            p = array[0],
            pairs = new Array(n < 0 ? 0 : n);
          while (i < n) pairs[i] = [p, p = array[++i]];
          return pairs;
        }
        function permute(array, indexes) {
          var i = indexes.length,
            permutes = new Array(i);
          while (i--) permutes[i] = array[indexes[i]];
          return permutes;
        }
        function scan(array, compare) {
          if (!(n = array.length)) return;
          var i = 0,
            n,
            j = 0,
            xi,
            xj = array[j];
          if (!compare) compare = ascending;
          while (++i < n) if (compare(xi = array[i], xj) < 0 || compare(xj, xj) !== 0) xj = xi, j = i;
          if (compare(xj, xj) === 0) return j;
        }
        function shuffle(array, i0, i1) {
          var m = (i1 == null ? array.length : i1) - (i0 = i0 == null ? 0 : +i0),
            t,
            i;
          while (m) {
            i = Math.random() * m-- | 0;
            t = array[m + i0];
            array[m + i0] = array[i + i0];
            array[i + i0] = t;
          }
          return array;
        }
        function sum(array, f) {
          var s = 0,
            n = array.length,
            a,
            i = -1;
          if (f == null) {
            while (++i < n) if (a = +array[i]) s += a; // Note: zero and null are equivalent.
          } else {
            while (++i < n) if (a = +f(array[i], i, array)) s += a;
          }
          return s;
        }
        function transpose(matrix) {
          if (!(n = matrix.length)) return [];
          for (var i = -1, m = min(matrix, length), transpose = new Array(m); ++i < m;) {
            for (var j = -1, n, row = transpose[i] = new Array(n); ++j < n;) {
              row[j] = matrix[j][i];
            }
          }
          return transpose;
        }
        function length(d) {
          return d.length;
        }
        function zip() {
          return transpose(arguments);
        }
        var version = "0.7.1";
        exports.version = version;
        exports.bisect = bisectRight;
        exports.bisectRight = bisectRight;
        exports.bisectLeft = bisectLeft;
        exports.ascending = ascending;
        exports.bisector = bisector;
        exports.descending = descending;
        exports.deviation = deviation;
        exports.extent = extent;
        exports.histogram = histogram;
        exports.thresholdFreedmanDiaconis = freedmanDiaconis;
        exports.thresholdScott = scott;
        exports.thresholdSturges = sturges;
        exports.max = max;
        exports.mean = mean;
        exports.median = median;
        exports.merge = merge;
        exports.min = min;
        exports.pairs = pairs;
        exports.permute = permute;
        exports.quantile = quantile;
        exports.range = range;
        exports.scan = scan;
        exports.shuffle = shuffle;
        exports.sum = sum;
        exports.ticks = ticks;
        exports.tickStep = tickStep;
        exports.transpose = transpose;
        exports.variance = variance;
        exports.zip = zip;
      });
    })(d3Array, d3Array.exports);

    const {
      bisectRight
    } = d3Array.exports;
    const quincunx = (u, v, w, q) => {
      const n = u.length - 1;
      u[0] = 0;
      v[0] = 0;
      w[0] = 0;
      v[1] = v[1] / u[1];
      w[1] = w[1] / u[1];
      for (let i = 2; i < n; ++i) {
        u[i] = u[i] - u[i - 2] * w[i - 2] * w[i - 2] - u[i - 1] * v[i - 1] * v[i - 1];
        v[i] = (v[i] - u[i - 1] * v[i - 1] * w[i - 1]) / u[i];
        w[i] = w[i] / u[i];
      }
      for (let i = 2; i < n; ++i) {
        q[i] = q[i] - v[i - 1] * q[i - 1] - w[i - 2] * q[i - 2];
      }
      for (let i = 1; i < n; ++i) {
        q[i] = q[i] / u[i];
      }
      q[n - 2] = q[n - 2] - v[n - 2] * q[n - 1];
      for (let i = n - 3; i > 0; --i) {
        q[i] = q[i] - v[i] * q[i + 1] - w[i] * q[i + 2];
      }
    };
    const smoothingSpline = (x, y, sigma, lambda) => {
      const n = x.length - 1;
      const h = new Array(n + 1);
      const r = new Array(n + 1);
      const f = new Array(n + 1);
      const p = new Array(n + 1);
      const q = new Array(n + 1);
      const u = new Array(n + 1);
      const v = new Array(n + 1);
      const w = new Array(n + 1);
      const params = x.map(() => [0, 0, 0, 0]);
      params.pop();
      const mu = 2 * (1 - lambda) / (3 * lambda);
      for (let i = 0; i < n; ++i) {
        h[i] = x[i + 1] - x[i];
        r[i] = 3 / h[i];
      }
      q[0] = 0;
      for (let i = 1; i < n; ++i) {
        f[i] = -(r[i - 1] + r[i]);
        p[i] = 2 * (x[i + 1] - x[i - 1]);
        q[i] = 3 * (y[i + 1] - y[i]) / h[i] - 3 * (y[i] - y[i - 1]) / h[i - 1];
      }
      q[n] = 0;
      for (let i = 1; i < n; ++i) {
        u[i] = r[i - 1] * r[i - 1] * sigma[i - 1] + f[i] * f[i] * sigma[i] + r[i] * r[i] * sigma[i + 1];
        u[i] = mu * u[i] + p[i];
      }
      for (let i = 1; i < n - 1; ++i) {
        v[i] = f[i] * r[i] * sigma[i] + r[i] * f[i + 1] * sigma[i + 1];
        v[i] = mu * v[i] + h[i];
      }
      for (let i = 1; i < n - 2; ++i) {
        w[i] = mu * r[i] * r[i + 1] * sigma[i + 1];
      }
      quincunx(u, v, w, q);
      params[0][3] = y[0] - mu * r[0] * q[1] * sigma[0];
      params[1][3] = y[1] - mu * (f[1] * q[1] + r[1] * q[2]) * sigma[0];
      params[0][0] = q[1] / (3 * h[0]);
      params[0][1] = 0;
      params[0][2] = (params[1][3] - params[0][3]) / h[0] - q[1] * h[0] / 3;
      r[0] = 0;
      for (let i = 1; i < n; ++i) {
        params[i][0] = (q[i + 1] - q[i]) / (3 * h[i]);
        params[i][1] = q[i];
        params[i][2] = (q[i] + q[i - 1]) * h[i - 1] + params[i - 1][2];
        params[i][3] = r[i - 1] * q[i - 1] + f[i] * q[i] + r[i] * q[i + 1];
        params[i][3] = y[i] - mu * params[i][3] * sigma[i];
      }
      return params;
    };
    class SplineInterpolator {
      constructor(xIn, yIn, lambda = 1) {
        const indices = xIn.map((_, i) => i);
        indices.sort((i, j) => xIn[i] - xIn[j]);
        const x = indices.map(i => xIn[i]);
        const y = indices.map(i => yIn[i]);
        const n = indices.length;
        const sigma = indices.map(() => 1);
        this.n = n;
        this.x = x;
        this.y = y;
        this.params = smoothingSpline(x, y, sigma, lambda);
      }
      interpolate(v) {
        if (v === this.x[this.n - 1]) {
          return this.y[this.n - 1];
        }
        const i = Math.min(Math.max(0, bisectRight(this.x, v) - 1), this.n - 2);
        const [a, b, c, d] = this.params[i];
        v = v - this.x[i];
        return a * v * v * v + b * v * v + c * v + d;
      }
      max(step = 100) {
        const xStart = this.x[0];
        const xStop = this.x[this.n - 1];
        const delta = (xStop - xStart) / step;
        let maxValue = -Infinity;
        for (let i = 0, x = xStart; i < step; ++i, x += delta) {
          const y = this.interpolate(x);
          if (y > maxValue) {
            maxValue = y;
          }
        }
        return maxValue;
      }
      min(step = 100) {
        const xStart = this.x[0];
        const xStop = this.x[this.n - 1];
        const delta = (xStop - xStart) / step;
        let minValue = Infinity;
        for (let i = 0, x = xStart; i < step; ++i, x += delta) {
          const y = this.interpolate(x);
          if (y < minValue) {
            minValue = y;
          }
        }
        return minValue;
      }
      domain() {
        return [this.x[0], this.x[this.x.length - 1]];
      }
      range() {
        return [this.min(), this.max()];
      }
      curve(nInterval, domain = null) {
        domain = domain || this.domain();
        const delta = (domain[1] - domain[0]) / (nInterval - 1);
        const vals = new Array(nInterval);
        for (let i = 0; i < nInterval; ++i) {
          const x = delta * i + domain[0];
          vals[i] = [x, this.interpolate(x)];
        }
        return vals;
      }
    }
    var splineInterpolator = SplineInterpolator;
    var SplineInterpolator$1 = splineInterpolator;

    /**
     * Create an array with numbers between "from" and "to" of length "length"
     *
     * @param options - options
     * @return - array of distributed numbers between "from" and "to"
     */
    function createFromToArray(options = {}) {
      let {
        from = 0,
        to = 1,
        length = 1000,
        includeFrom = true,
        includeTo = true,
        distribution = 'uniform'
      } = options;
      const array = new Float64Array(length);
      let div = length;
      if (includeFrom && includeTo) {
        div = length - 1;
      } else if (!includeFrom && includeTo || includeFrom && !includeTo) {
        div = length;
      } else if (!includeFrom && !includeTo) {
        div = length + 1;
      }
      let delta = (to - from) / div;
      if (distribution === 'uniform') {
        if (includeFrom) {
          let index = 0;
          while (index < length) {
            array[index] = from + delta * index;
            index++;
          }
        } else {
          let index = 0;
          while (index < length) {
            array[index] = from + delta * (index + 1);
            index++;
          }
        }
      } else if (distribution === 'log') {
        let base = (to / from) ** (1 / div);
        let firstExponent = Math.log(from) / Math.log(base);
        if (includeFrom) {
          let index = 0;
          while (index < length) {
            array[index] = base ** (firstExponent + index);
            index++;
          }
        } else {
          let index = 0;
          while (index < length) {
            array[index] = base ** (firstExponent + index + 1);
            index++;
          }
        }
      } else {
        throw new Error('Please choose for the distribution either uniform or log. By default the distribution chosen is uniform.');
      }
      return array;
    }

    /* eslint-disable @typescript-eslint/no-loss-of-precision */
    /*
    Adapted from: https://github.com/compute-io/erfcinv/blob/aa116e23883839359e310ad41a7c42f72815fc1e/lib/number.js

    The MIT License (MIT)

    Copyright (c) 2014-2015 The Compute.io Authors. All rights reserved.

    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
    SOFTWARE.


    Boost Software License - Version 1.0 - August 17th, 2003

    Permission is hereby granted, free of charge, to any person or organization obtaining a copy of the software and accompanying documentation covered by this license (the "Software") to use, reproduce, display, distribute, execute, and transmit the Software, and to prepare derivative works of the Software, and to permit third-parties to whom the Software is furnished to do so, all subject to the following:

    The copyright notices in the Software and this entire statement, including the above license grant, this restriction and the following disclaimer, must be included in all copies of the Software, in whole or in part, and all derivative works of the Software, unless such copies or derivative works are solely in the form of machine-executable object code generated by a source language processor.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
    */
    // Coefficients for erfcinv on [0, 0.5]:
    const Y1 = 8.91314744949340820313e-2;
    const P1 = [-5.38772965071242932965e-3, 8.22687874676915743155e-3, 2.19878681111168899165e-2, -3.65637971411762664006e-2, -1.26926147662974029034e-2, 3.34806625409744615033e-2, -8.36874819741736770379e-3, -5.08781949658280665617e-4];
    const Q1 = [8.86216390456424707504e-4, -2.33393759374190016776e-3, 7.95283687341571680018e-2, -5.27396382340099713954e-2, -7.1228902341542847553e-1, 6.62328840472002992063e-1, 1.56221558398423026363, -1.56574558234175846809, -9.70005043303290640362e-1, 1];
    // Coefficients for erfcinv for 0.5 > 1-x >= 0:
    const Y2 = 2.249481201171875;
    const P2 = [-3.67192254707729348546, 2.11294655448340526258e1, 1.7445385985570866523e1, -4.46382324441786960818e1, -1.88510648058714251895e1, 1.76447298408374015486e1, 8.37050328343119927838, 1.05264680699391713268e-1, -2.02433508355938759655e-1];
    const Q2 = [1.72114765761200282724, -2.26436933413139721736e1, 1.08268667355460159008e1, 4.85609213108739935468e1, -2.01432634680485188801e1, -2.86608180499800029974e1, 3.9713437953343869095, 6.24264124854247537712, 1];
    // Coefficients for erfcinv for sqrt( -log(1-x)):
    const Y3 = 8.07220458984375e-1;
    const P3 = [-6.81149956853776992068e-10, 2.85225331782217055858e-8, -6.79465575181126350155e-7, 2.14558995388805277169e-3, 2.90157910005329060432e-2, 1.42869534408157156766e-1, 3.37785538912035898924e-1, 3.87079738972604337464e-1, 1.17030156341995252019e-1, -1.63794047193317060787e-1, -1.31102781679951906451e-1];
    const Q3 = [1.105924229346489121e-2, 1.52264338295331783612e-1, 8.48854343457902036425e-1, 2.59301921623620271374, 4.77846592945843778382, 5.38168345707006855425, 3.46625407242567245975, 1];
    const Y4 = 9.3995571136474609375e-1;
    const P4 = [2.66339227425782031962e-12, -2.30404776911882601748e-10, 4.60469890584317994083e-6, 1.57544617424960554631e-4, 1.87123492819559223345e-3, 9.50804701325919603619e-3, 1.85573306514231072324e-2, -2.22426529213447927281e-3, -3.50353787183177984712e-2];
    const Q4 = [7.64675292302794483503e-5, 2.63861676657015992959e-3, 3.41589143670947727934e-2, 2.20091105764131249824e-1, 7.62059164553623404043e-1, 1.3653349817554063097, 1];
    const Y5 = 9.8362827301025390625e-1;
    const P5 = [9.9055709973310326855e-17, -2.81128735628831791805e-14, 4.62596163522878599135e-9, 4.49696789927706453732e-7, 1.49624783758342370182e-5, 2.09386317487588078668e-4, 1.05628862152492910091e-3, -1.12951438745580278863e-3, -1.67431005076633737133e-2];
    const Q5 = [2.82243172016108031869e-7, 2.75335474764726041141e-5, 9.64011807005165528527e-4, 1.60746087093676504695e-2, 1.38151865749083321638e-1, 5.91429344886417493481e-1, 1];
    /**
     * Polyval.
     *
     * @param c - Array of Number.
     * @param x - Number.
     * @returns Number.
     */
    function polyval(c, x) {
      let p = 0;
      for (const coef of c) {
        p = p * x + coef;
      }
      return p;
    }
    /**
     * Calculates a rational approximation.
     *
     * @private
     * @param x - Number.
     * @param v - Number.
     * @param P - Array of polynomial coefficients.
     * @param Q - Array of polynomial coefficients.
     * @param Y - Number.
     * @returns Rational approximation.
     */
    function calc(x, v, P, Q, Y) {
      const s = x - v;
      const r = polyval(P, s) / polyval(Q, s);
      return Y * x + r * x;
    }
    /**
     * Evaluates the complementary inverse error function for an input value.
     *
     * @private
     * @param x - Input value.
     * @returns Evaluated complementary inverse error function.
     */
    function erfcinv(x) {
      let sign = false;
      let val;
      let q;
      let g;
      let r;
      // [1] Special cases...
      // NaN:
      if (Number.isNaN(x)) {
        return Number.NaN;
      }
      // x not on the interval: [0,2]
      if (x < 0 || x > 2) {
        throw new RangeError(`erfcinv()::invalid input argument. Value must be on the interval [0,2]. Value: \`${x}\`.`);
      }
      if (x === 0) {
        return Number.POSITIVE_INFINITY;
      }
      if (x === 2) {
        return Number.NEGATIVE_INFINITY;
      }
      if (x === 1) {
        return 0;
      }
      // [2] Get the sign and make use of `erfc` reflection formula: `erfc(-z)=2 - erfc(z)`...
      if (x > 1) {
        q = 2 - x;
        x = 1 - q;
        sign = true;
      } else {
        q = x;
        x = 1 - x;
      }
      // [3] |x| <= 0.5
      if (x <= 0.5) {
        g = x * (x + 10);
        r = polyval(P1, x) / polyval(Q1, x);
        val = g * Y1 + g * r;
        return sign ? -val : val;
      }
      // [4] 1-|x| >= 0.25
      if (q >= 0.25) {
        g = Math.sqrt(-2 * Math.log(q));
        q = q - 0.25;
        r = polyval(P2, q) / polyval(Q2, q);
        val = g / (Y2 + r);
        return sign ? -val : val;
      }
      q = Math.sqrt(-Math.log(q));
      // [5] q < 3
      if (q < 3) {
        return calc(q, 1.125, P3, Q3, Y3);
      }
      // [6] q < 6
      if (q < 6) {
        return calc(q, 3, P4, Q4, Y4);
      }
      // Note that the smallest number in JavaScript is 5e-324. Math.sqrt( -Math.log( 5e-324 ) ) ~27.2844
      return calc(q, 6, P5, Q5, Y5);
      // Note that in the boost library, they are able to go to much smaller values, as 128 bit long doubles support ~1e-5000; something which JavaScript does not natively support.
    }

    /**
     * RayleighCdf.
     *
     * @param x - data
     * @param sigma - standard deviation
     * @returns - rayleigh cdf
     */
    function rayleighCdf(x, sigma = 1) {
      if (x < 0) {
        return 0;
      }
      return -Math.expm1(-Math.pow(x, 2) / (2 * Math.pow(sigma, 2)));
    }

    /**
     * Determine noise level by san plot methodology (https://doi.org/10.1002/mrc.4882)
     *
     * @param array - real or magnitude spectra data.
     * @param options - options
     * @returns noise level
     */
    function xNoiseSanPlot(array, options = {}) {
      const {
        mask,
        cutOff,
        refine = true,
        magnitudeMode = false,
        scaleFactor = 1,
        factorStd = 5,
        fixOffset = true
      } = options;
      let input;
      if (Array.isArray(mask) && mask.length === array.length) {
        input = new Float64Array(array.filter((_e, i) => !mask[i]));
      } else {
        input = new Float64Array(array);
      }
      if (scaleFactor > 1) {
        for (let i = 0; i < input.length; i++) {
          input[i] *= scaleFactor;
        }
      }
      input = input.sort().reverse();
      if (fixOffset && !magnitudeMode) {
        let medianIndex = Math.floor(input.length / 2);
        let median = 0.5 * (input[medianIndex] + input[medianIndex + 1]);
        for (let i = 0; i < input.length; i++) {
          input[i] -= median;
        }
      }
      let firstNegativeValueIndex = input[input.length - 1] >= 0 ? input.length : input.findIndex(e => e < 0);
      let lastPositiveValueIndex = firstNegativeValueIndex - 1;
      for (let i = lastPositiveValueIndex; i >= 0; i--) {
        if (input[i] > 0) {
          lastPositiveValueIndex = i;
          break;
        }
      }
      let signPositive = input.slice(0, lastPositiveValueIndex + 1);
      let signNegative = input.slice(firstNegativeValueIndex);
      let cutOffDist = cutOff || determineCutOff(signPositive, {
        magnitudeMode
      });
      let pIndex = Math.floor(signPositive.length * cutOffDist);
      let initialNoiseLevelPositive = signPositive[pIndex];
      let skyPoint = signPositive[0];
      let initialNoiseLevelNegative;
      if (signNegative.length > 0) {
        let nIndex = Math.floor(signNegative.length * (1 - cutOffDist));
        initialNoiseLevelNegative = -1 * signNegative[nIndex];
      } else {
        initialNoiseLevelNegative = 0;
      }
      let noiseLevelPositive = initialNoiseLevelPositive;
      let noiseLevelNegative = initialNoiseLevelNegative;
      let cloneSignPositive = signPositive.slice();
      let cloneSignNegative = signNegative.slice();
      let cutOffSignalsIndexPlus = 0;
      let cutOffSignalsIndexNeg = 2;
      if (refine) {
        let cutOffSignals = noiseLevelPositive * factorStd;
        cutOffSignalsIndexPlus = signPositive.findIndex(e => e < cutOffSignals);
        if (cutOffSignalsIndexPlus > -1) {
          cloneSignPositive = signPositive.slice(cutOffSignalsIndexPlus);
          noiseLevelPositive = cloneSignPositive[Math.floor(cloneSignPositive.length * cutOffDist)];
        }
        cutOffSignals = noiseLevelNegative * factorStd;
        cutOffSignalsIndexNeg = signNegative.findIndex(e => e < cutOffSignals);
        if (cutOffSignalsIndexNeg > -1) {
          cloneSignNegative = signNegative.slice(cutOffSignalsIndexNeg);
          noiseLevelNegative = cloneSignPositive[Math.floor(cloneSignNegative.length * (1 - cutOffDist))];
        }
      }
      let correctionFactor = -simpleNormInv(cutOffDist / 2, {
        magnitudeMode
      });
      initialNoiseLevelPositive = initialNoiseLevelPositive / correctionFactor;
      initialNoiseLevelNegative = initialNoiseLevelNegative / correctionFactor;
      let effectiveCutOffDist, refinedCorrectionFactor;
      if (refine && cutOffSignalsIndexPlus > -1) {
        effectiveCutOffDist = (cutOffDist * cloneSignPositive.length + cutOffSignalsIndexPlus) / (cloneSignPositive.length + cutOffSignalsIndexPlus);
        refinedCorrectionFactor = -1 * simpleNormInv(effectiveCutOffDist / 2, {
          magnitudeMode
        });
        noiseLevelPositive /= refinedCorrectionFactor;
        if (cutOffSignalsIndexNeg > -1) {
          effectiveCutOffDist = (cutOffDist * cloneSignNegative.length + cutOffSignalsIndexNeg) / (cloneSignNegative.length + cutOffSignalsIndexNeg);
          refinedCorrectionFactor = -1 * simpleNormInv(effectiveCutOffDist / 2, {
            magnitudeMode
          });
          if (noiseLevelNegative !== 0) {
            noiseLevelNegative /= refinedCorrectionFactor;
          }
        }
      } else {
        noiseLevelPositive /= correctionFactor;
        noiseLevelNegative /= correctionFactor;
      }
      return {
        positive: noiseLevelPositive,
        negative: noiseLevelNegative,
        snr: skyPoint / noiseLevelPositive,
        sanplot: generateSanPlot(input, {
          fromTo: {
            positive: {
              from: 0,
              to: lastPositiveValueIndex
            },
            negative: {
              from: firstNegativeValueIndex,
              to: input.length
            }
          }
        })
      };
    }
    /**
     * DetermineCutOff.
     *
     * @param signPositive - Array of numbers.
     * @param [options = {}] - Options.
     * @param [options.mask] - Boolean array to filter data, if the i-th element is true then the i-th element of the distribution will be ignored.
     * @param [options.scaleFactor=1] - Factor to scale the data input[i]*=scaleFactor.
     * @param [options.cutOff] - Percent of positive signal distribution where the noise level will be determined, if it is not defined the program calculate it.
     * @param [options.factorStd=5] - Factor times std to determine what will be marked as signals.
     * @param [options.refine=true] - If true the noise level will be recalculated get out the signals using factorStd.
     * @param [options.fixOffset=true] - If the baseline is correct, the midpoint of distribution should be zero. If true, the distribution will be centered.
     * @param [options.logBaseY=2] - Log scale to apply in the intensity axis in order to avoid big numbers.
     * @param options.magnitudeMode -
     * @param options.considerList -
     * @param options.considerList.from -
     * @param options.considerList.step -
     * @param options.considerList.to -
     * @param options.fromTo -
     * @returns Result.
     */
    function determineCutOff(signPositive, options = {}) {
      let {
        magnitudeMode = false,
        considerList = {
          from: 0.5,
          step: 0.1,
          to: 0.9
        }
      } = options;
      //generate a list of values for
      let cutOff = [];
      let indexMax = signPositive.length - 1;
      for (let i = 0.01; i <= 0.99; i += 0.01) {
        let index = Math.round(indexMax * i);
        let value = -signPositive[index] / simpleNormInv([i / 2], {
          magnitudeMode
        });
        cutOff.push([i, value]);
      }
      let minKi = Number.MAX_SAFE_INTEGER;
      let {
        from,
        to,
        step
      } = considerList;
      let delta = step / 2;
      let whereToCutStat = 0.5;
      for (let i = from; i <= to; i += step) {
        let floor = i - delta;
        let top = i + delta;
        let elementsOfCutOff = cutOff.filter(e => e[0] < top && e[0] > floor);
        let averageValue = elementsOfCutOff.reduce((a, b) => a + Math.abs(b[1]), 0);
        let kiSqrt = 0;
        for (const element of elementsOfCutOff) {
          kiSqrt += Math.pow(element[1] - averageValue, 2);
        }
        if (kiSqrt < minKi) {
          minKi = kiSqrt;
          whereToCutStat = i;
        }
      }
      return whereToCutStat;
    }
    /**
     * SimpleNormInvs.
     *
     * @param data - Data array.
     * @param [options = {}] - Options.
     * @param [options.mask] - Boolean array to filter data, if the i-th element is true then the i-th element of the distribution will be ignored.
     * @param [options.scaleFactor=1] - Factor to scale the data input[i]*=scaleFactor.
     * @param [options.cutOff] - Percent of positive signal distribution where the noise level will be determined, if it is not defined the program calculate it.
     * @param [options.factorStd=5] - Factor times std to determine what will be marked as signals.
     * @param [options.refine=true] - If true the noise level will be recalculated get out the signals using factorStd.
     * @param [options.fixOffset=true] - If the baseline is correct, the midpoint of distribution should be zero. If true, the distribution will be centered.
     * @param [options.logBaseY=2] - Log scale to apply in the intensity axis in order to avoid big numbers.
     * @param options.magnitudeMode -
     * @param options.considerList -
     * @param options.considerList.from -
     * @param options.considerList.step -
     * @param options.considerList.to -
     * @param options.fromTo -
     * @returns Result.
     */
    function simpleNormInv(data, options = {}) {
      const {
        magnitudeMode = false
      } = options;
      if (!Array.isArray(data)) data = [data];
      let from = 0;
      let to = 2;
      let step = 0.01;
      let xTraining = Array.from(createArray(from, to, step));
      let result = new Float64Array(data.length);
      let yTraining = new Float64Array(xTraining.length);
      if (magnitudeMode) {
        let factor = 1;
        for (let i = 0; i < yTraining.length; i++) {
          let finalInput = xTraining[i] * factor;
          yTraining[i] = 1 - rayleighCdf(finalInput);
        }
        let interp = new SplineInterpolator$1(xTraining, yTraining);
        for (let i = 0; i < result.length; i++) {
          let yValue = 2 * data[i];
          result[i] = -1 * interp.interpolate(yValue);
        }
      } else {
        for (let i = 0; i < result.length; i++) {
          result[i] = -1 * Math.SQRT2 * erfcinv(2 * data[i]);
        }
      }
      return result.length === 1 ? result[0] : result;
    }
    /**
     * CreateArray.
     *
     * @param from - From.
     * @param to - To.
     * @param step - Step.
     * @returns Array of results.
     */
    function createArray(from, to, step) {
      // Changed Array to Float64Array
      let result = new Float64Array(Math.abs((from - to) / step + 1));
      for (let i = 0; i < result.length; i++) {
        result[i] = from + i * step;
      }
      return result;
    }
    /**
     * GenerateSanPlot.
     *
     * @param array - Array.
     * @param [options = {}] - Options.
     * @param [options.mask] - Boolean array to filter data, if the i-th element is true then the i-th element of the distribution will be ignored.
     * @param [options.scaleFactor=1] - Factor to scale the data input[i]*=scaleFactor.
     * @param [options.cutOff] - Percent of positive signal distribution where the noise level will be determined, if it is not defined the program calculate it.
     * @param [options.factorStd=5] - Factor times std to determine what will be marked as signals.
     * @param [options.refine=true] - If true the noise level will be recalculated get out the signals using factorStd.
     * @param [options.fixOffset=true] - If the baseline is correct, the midpoint of distribution should be zero. If true, the distribution will be centered.
     * @param [options.logBaseY=2] - Log scale to apply in the intensity axis in order to avoid big numbers.
     * @param options.magnitudeMode -
     * @param options.considerList -
     * @param options.considerList.from -
     * @param options.considerList.step -
     * @param options.considerList.to -
     * @param options.fromTo -
     * @returns Results.
     */
    function generateSanPlot(array, options = {}) {
      const {
        fromTo,
        logBaseY = 2
      } = options;
      let sanplot = {};
      for (let key in fromTo) {
        let {
          from,
          to
        } = fromTo[key];
        sanplot[key] = from !== to ? scale(array.slice(from, to), {
          logBaseY
        }) : {
          x: [],
          y: []
        };
        if (key === 'negative') {
          sanplot[key].y.reverse();
        }
      }
      return sanplot;
    }
    /**
     * Scale.
     *
     * @param array - Array.
     * @param [options = {}] - Options.
     * @param [options.mask] - Boolean array to filter data, if the i-th element is true then the i-th element of the distribution will be ignored.
     * @param [options.scaleFactor=1] - Factor to scale the data input[i]*=scaleFactor.
     * @param [options.cutOff] - Percent of positive signal distribution where the noise level will be determined, if it is not defined the program calculate it.
     * @param [options.factorStd=5] - Factor times std to determine what will be marked as signals.
     * @param [options.refine=true] - If true the noise level will be recalculated get out the signals using factorStd.
     * @param [options.fixOffset=true] - If the baseline is correct, the midpoint of distribution should be zero. If true, the distribution will be centered.
     * @param [options.logBaseY=2] - Log scale to apply in the intensity axis in order to avoid big numbers.
     * @param options.magnitudeMode -
     * @param options.considerList -
     * @param options.considerList.from -
     * @param options.considerList.step -
     * @param options.considerList.to -
     * @param options.fromTo -
     * @returns Results.
     */
    function scale(array, options = {}) {
      const {
        log10,
        abs
      } = Math;
      const {
        logBaseY
      } = options;
      if (logBaseY) {
        array = array.slice();
        const logOfBase = log10(logBaseY);
        for (let i = 0; i < array.length; i++) {
          array[i] = log10(abs(array[i])) / logOfBase;
        }
      }
      const xAxis = createFromToArray({
        from: 0,
        to: array.length - 1,
        length: array.length
      });
      return {
        x: xAxis,
        y: array
      };
    }

    /**
     * Phase correction filter
     *
     * @param data - complex spectrum
     * @param phi0 - Angle in radians for zero order phase correction
     * @param phi1 - Angle in radians for first order phase correction
     * @returns - returns a new object {re:[], im:[]}
     */
    function reimPhaseCorrection(data, phi0 = 0, phi1 = 0, options = {}) {
      const {
        reverse = false
      } = options;
      phi0 = Number.isFinite(phi0) ? phi0 : 0;
      phi1 = Number.isFinite(phi1) ? phi1 : 0;
      const re = data.re;
      const im = data.im;
      const length = data.re.length;
      let firstAngle = phi0;
      let delta = phi1 / length;
      if (reverse) {
        delta *= -1;
        firstAngle += phi1;
      }
      const alpha = 2 * Math.pow(Math.sin(delta / 2), 2);
      const beta = Math.sin(delta);
      let cosTheta = Math.cos(firstAngle);
      let sinTheta = Math.sin(firstAngle);
      const newRe = new Float64Array(length);
      const newIm = new Float64Array(length);
      for (let i = 0; i < length; i++) {
        newRe[i] = re[i] * cosTheta - im[i] * sinTheta;
        newIm[i] = im[i] * cosTheta + re[i] * sinTheta;
        // calculate angles i+1 from i
        let newCosTheta = cosTheta - (alpha * cosTheta + beta * sinTheta);
        let newSinTheta = sinTheta - (alpha * sinTheta - beta * cosTheta);
        cosTheta = newCosTheta;
        sinTheta = newSinTheta;
      }
      return {
        re: newRe,
        im: newIm
      };
    }

    /**
     * Implementation of the algorithm for automatic phase correction: A robust, general automatic phase
     * correction algorithm for high-resolution NMR data. 10.1002/mrc.4586
     *
     * @param data - complex spectrum
     * @param options - options
     */
    function reimAutoPhaseCorrection(data, options = {}) {
      const {
        re,
        im
      } = data;
      const length = re.length;
      const {
        magnitudeMode = true,
        minRegSize = 30,
        factorNoise = 3,
        maxDistanceToJoin = 256,
        reverse = false
      } = options;
      let magnitudeData = magnitudeMode ? reimAbsolute(data) : re;
      let ds = holoborodko(magnitudeData);
      let peaksDs = robustBaseLineRegionsDetection(ds, {
        maxDistanceToJoin,
        magnitudeMode,
        factorNoise
      });
      let peaksSp = robustBaseLineRegionsDetection(magnitudeData, {
        maxDistanceToJoin,
        magnitudeMode,
        factorNoise
      });
      let finalPeaks = new Uint8Array(length);
      for (let i = 0; i < length; i++) {
        finalPeaks[i] = peaksSp[i] && peaksDs[i];
      }
      // Once the regions are detected, we auto phase each of them separately.
      // This part can be put inside a function
      const indexMask = reverse ? i => length - i : i => i;
      let i = -1;
      let x0 = 0;
      let res = [];
      while (i < length) {
        //phase first region
        let reTmp = [];
        let imTmp = [];
        //Look for the first 1 in the array
        while (!finalPeaks[++i] && i < length) {
          //Add some extra points(0.1 ppm) at rigth and left sides of the region.
          x0 = indexMask(i);
        }
        for (; finalPeaks[i] && i < length; i++) {
          reTmp.push(re[i]);
          imTmp.push(im[i]);
          i++;
        }
        if (reTmp.length > minRegSize) {
          res.push(autoPhaseRegion(reTmp, imTmp, x0));
        }
      }
      // Still some corrections needed. In the paper they remove the outlayers interatively
      // until they can perform a regression witout bad points. Can someone help here?
      let [ph1, ph0] = weightedLinearRegression(res.map(r => r.x0 / length), res.map(r => r.ph0), res.map(r => r.area / 1e11));
      let phased = reimPhaseCorrection({
        re,
        im
      }, ph0 * Math.PI / 180, ph1 * Math.PI / 180, {
        reverse
      });
      return {
        data: phased,
        ph0,
        ph1
      };
    }
    /**
     * AutoPhaseRegion.
     *
     * @param re - Array of Number.
     * @param im - Array of Number.
     * @param x0 - Number.
     * @returns Region.
     */
    function autoPhaseRegion(re, im, x0) {
      let start = -180;
      let stop = 180;
      let nSteps = 6;
      let maxSteps = 5;
      let bestAng = 0;
      let minArea = Number.MAX_SAFE_INTEGER;
      while (maxSteps > 0) {
        let dAng = (stop - start) / (nSteps + 1);
        for (let i = start; i <= stop; i += dAng) {
          let phased = reimPhaseCorrection({
            re,
            im
          }, toRadians(i), 0);
          let negArea = getNegArea(phased.re);
          if (negArea < minArea) {
            [minArea, bestAng] = [negArea, i];
          }
        }
        start = bestAng - dAng;
        stop = bestAng + dAng;
        maxSteps--;
      }
      // Calculate the area for the best angle
      let phased = reimPhaseCorrection({
        re,
        im
      }, toRadians(bestAng), 0);
      let area = 0;
      let sumX = 0;
      for (let j = 0; j < re.length; j++) {
        area += phased.re[j];
        sumX += phased.re[j] * (j + x0);
      }
      return {
        ph0: bestAng,
        area,
        x0: sumX / area
      };
    }
    /**
     * Holoborodko.
     *
     * @param s - Array of float.
     * @returns Array of float.
     */
    function holoborodko(s) {
      let dk = new Float64Array(s.length);
      for (let i = 5; i < s.length - 5; i++) {
        dk[i] = (42 * (s[i + 1] - s[i - 1]) + 48 * (s[i + 2] - s[i - 2]) + 27 * (s[i + 3] + s[i - 3]) + 8 * (s[i + 4] - s[i - 4]) + s[i + 5] - s[i - 5]) / 512;
      }
      //Fill the borders
      for (let i = 0; i < 5; i++) {
        dk[i] = dk[5];
        dk[s.length - i - 1] = dk[s.length - 6];
      }
      return dk;
    }
    /**
     * RobustBaseLineRegionsDetection.
     *
     * @param s
     * @param options
     * @param options.magnitudeMode
     * @param options.maxDistanceToJoin
     * @param options.factorNoise
     */
    function robustBaseLineRegionsDetection(s, options) {
      const {
        maxDistanceToJoin,
        magnitudeMode,
        factorNoise
      } = options;
      let mask = new Uint8Array(s.length);
      for (let i = 0; i < s.length; i++) {
        mask[i] = 0;
      }
      let change = true;
      while (change) {
        let noiseLevel = xNoiseSanPlot(s, {
          magnitudeMode
        });
        let cutOff = factorNoise * noiseLevel.positive;
        change = false;
        for (let i = 0; i < s.length; i++) {
          if (Math.abs(s[i]) > cutOff && !mask[i]) {
            change = true;
            mask[i] = 1;
          }
        }
      }
      // Clean up mask by merging peaks blocks, separated by just a few points(4??).
      let count = 0;
      let prev = 0;
      for (let i = 0; i < s.length; i++) {
        if (!mask[i]) {
          count++;
        } else {
          if (count < maxDistanceToJoin) {
            for (let j = 0; j <= count; j++) {
              mask[prev + j] = 1;
            }
          }
          while (mask[++i] && i < s.length);
          prev = i;
          count = 0;
        }
      }
      return mask;
    }
    /**
     * WeightedLinearRegression.
     *
     * @param x
     * @param y
     * @param w
     */
    function weightedLinearRegression(x, y, w) {
      let sxtw = 0;
      let swx = 0;
      let sw = 0;
      let sxtwy = 0;
      let swy = 0;
      for (let i = 0; i < x.length; i++) {
        sxtw += x[i] * x[i] * w[i];
        swx += x[i] * w[i];
        sw += w[i];
        sxtwy += x[i] * w[i] * y[i];
        swy += w[i] * y[i];
      }
      /* Just to know what is the matrix system that we solve
       let Mx=[[sxtw, swx], [swx, sw]];
       let My=[[sxtwy], [swy]];
      */
      //Mx inverse
      let detMx = sxtw * sw - swx * swx;
      let inMx = [[sw / detMx, -swx / detMx], [-swx / detMx, sxtw / detMx]];
      return [inMx[0][0] * sxtwy + inMx[0][1] * swy, inMx[1][0] * sxtwy + inMx[1][1] * swy];
    }
    const toRadians = degree => degree * Math.PI / 180;
    const getNegArea = data => {
      let area = 0;
      for (let element of data) {
        if (element < 0) area -= element;
      }
      return area;
    };

    function FFT$1(size) {
      this.size = size | 0;
      if (this.size <= 1 || (this.size & this.size - 1) !== 0) throw new Error('FFT size must be a power of two and bigger than 1');
      this._csize = size << 1;

      // NOTE: Use of `var` is intentional for old V8 versions
      var table = new Array(this.size * 2);
      for (var i = 0; i < table.length; i += 2) {
        const angle = Math.PI * i / this.size;
        table[i] = Math.cos(angle);
        table[i + 1] = -Math.sin(angle);
      }
      this.table = table;

      // Find size's power of two
      var power = 0;
      for (var t = 1; this.size > t; t <<= 1) power++;

      // Calculate initial step's width:
      //   * If we are full radix-4 - it is 2x smaller to give inital len=8
      //   * Otherwise it is the same as `power` to give len=4
      this._width = power % 2 === 0 ? power - 1 : power;

      // Pre-compute bit-reversal patterns
      this._bitrev = new Array(1 << this._width);
      for (var j = 0; j < this._bitrev.length; j++) {
        this._bitrev[j] = 0;
        for (var shift = 0; shift < this._width; shift += 2) {
          var revShift = this._width - shift - 2;
          this._bitrev[j] |= (j >>> shift & 3) << revShift;
        }
      }
      this._out = null;
      this._data = null;
      this._inv = 0;
    }
    var fft$1 = FFT$1;
    FFT$1.prototype.fromComplexArray = function fromComplexArray(complex, storage) {
      var res = storage || new Array(complex.length >>> 1);
      for (var i = 0; i < complex.length; i += 2) res[i >>> 1] = complex[i];
      return res;
    };
    FFT$1.prototype.createComplexArray = function createComplexArray() {
      const res = new Array(this._csize);
      for (var i = 0; i < res.length; i++) res[i] = 0;
      return res;
    };
    FFT$1.prototype.toComplexArray = function toComplexArray(input, storage) {
      var res = storage || this.createComplexArray();
      for (var i = 0; i < res.length; i += 2) {
        res[i] = input[i >>> 1];
        res[i + 1] = 0;
      }
      return res;
    };
    FFT$1.prototype.completeSpectrum = function completeSpectrum(spectrum) {
      var size = this._csize;
      var half = size >>> 1;
      for (var i = 2; i < half; i += 2) {
        spectrum[size - i] = spectrum[i];
        spectrum[size - i + 1] = -spectrum[i + 1];
      }
    };
    FFT$1.prototype.transform = function transform(out, data) {
      if (out === data) throw new Error('Input and output buffers must be different');
      this._out = out;
      this._data = data;
      this._inv = 0;
      this._transform4();
      this._out = null;
      this._data = null;
    };
    FFT$1.prototype.realTransform = function realTransform(out, data) {
      if (out === data) throw new Error('Input and output buffers must be different');
      this._out = out;
      this._data = data;
      this._inv = 0;
      this._realTransform4();
      this._out = null;
      this._data = null;
    };
    FFT$1.prototype.inverseTransform = function inverseTransform(out, data) {
      if (out === data) throw new Error('Input and output buffers must be different');
      this._out = out;
      this._data = data;
      this._inv = 1;
      this._transform4();
      for (var i = 0; i < out.length; i++) out[i] /= this.size;
      this._out = null;
      this._data = null;
    };

    // radix-4 implementation
    //
    // NOTE: Uses of `var` are intentional for older V8 version that do not
    // support both `let compound assignments` and `const phi`
    FFT$1.prototype._transform4 = function _transform4() {
      var out = this._out;
      var size = this._csize;

      // Initial step (permute and transform)
      var width = this._width;
      var step = 1 << width;
      var len = size / step << 1;
      var outOff;
      var t;
      var bitrev = this._bitrev;
      if (len === 4) {
        for (outOff = 0, t = 0; outOff < size; outOff += len, t++) {
          const off = bitrev[t];
          this._singleTransform2(outOff, off, step);
        }
      } else {
        // len === 8
        for (outOff = 0, t = 0; outOff < size; outOff += len, t++) {
          const off = bitrev[t];
          this._singleTransform4(outOff, off, step);
        }
      }

      // Loop through steps in decreasing order
      var inv = this._inv ? -1 : 1;
      var table = this.table;
      for (step >>= 2; step >= 2; step >>= 2) {
        len = size / step << 1;
        var quarterLen = len >>> 2;

        // Loop through offsets in the data
        for (outOff = 0; outOff < size; outOff += len) {
          // Full case
          var limit = outOff + quarterLen;
          for (var i = outOff, k = 0; i < limit; i += 2, k += step) {
            const A = i;
            const B = A + quarterLen;
            const C = B + quarterLen;
            const D = C + quarterLen;

            // Original values
            const Ar = out[A];
            const Ai = out[A + 1];
            const Br = out[B];
            const Bi = out[B + 1];
            const Cr = out[C];
            const Ci = out[C + 1];
            const Dr = out[D];
            const Di = out[D + 1];

            // Middle values
            const MAr = Ar;
            const MAi = Ai;
            const tableBr = table[k];
            const tableBi = inv * table[k + 1];
            const MBr = Br * tableBr - Bi * tableBi;
            const MBi = Br * tableBi + Bi * tableBr;
            const tableCr = table[2 * k];
            const tableCi = inv * table[2 * k + 1];
            const MCr = Cr * tableCr - Ci * tableCi;
            const MCi = Cr * tableCi + Ci * tableCr;
            const tableDr = table[3 * k];
            const tableDi = inv * table[3 * k + 1];
            const MDr = Dr * tableDr - Di * tableDi;
            const MDi = Dr * tableDi + Di * tableDr;

            // Pre-Final values
            const T0r = MAr + MCr;
            const T0i = MAi + MCi;
            const T1r = MAr - MCr;
            const T1i = MAi - MCi;
            const T2r = MBr + MDr;
            const T2i = MBi + MDi;
            const T3r = inv * (MBr - MDr);
            const T3i = inv * (MBi - MDi);

            // Final values
            const FAr = T0r + T2r;
            const FAi = T0i + T2i;
            const FCr = T0r - T2r;
            const FCi = T0i - T2i;
            const FBr = T1r + T3i;
            const FBi = T1i - T3r;
            const FDr = T1r - T3i;
            const FDi = T1i + T3r;
            out[A] = FAr;
            out[A + 1] = FAi;
            out[B] = FBr;
            out[B + 1] = FBi;
            out[C] = FCr;
            out[C + 1] = FCi;
            out[D] = FDr;
            out[D + 1] = FDi;
          }
        }
      }
    };

    // radix-2 implementation
    //
    // NOTE: Only called for len=4
    FFT$1.prototype._singleTransform2 = function _singleTransform2(outOff, off, step) {
      const out = this._out;
      const data = this._data;
      const evenR = data[off];
      const evenI = data[off + 1];
      const oddR = data[off + step];
      const oddI = data[off + step + 1];
      const leftR = evenR + oddR;
      const leftI = evenI + oddI;
      const rightR = evenR - oddR;
      const rightI = evenI - oddI;
      out[outOff] = leftR;
      out[outOff + 1] = leftI;
      out[outOff + 2] = rightR;
      out[outOff + 3] = rightI;
    };

    // radix-4
    //
    // NOTE: Only called for len=8
    FFT$1.prototype._singleTransform4 = function _singleTransform4(outOff, off, step) {
      const out = this._out;
      const data = this._data;
      const inv = this._inv ? -1 : 1;
      const step2 = step * 2;
      const step3 = step * 3;

      // Original values
      const Ar = data[off];
      const Ai = data[off + 1];
      const Br = data[off + step];
      const Bi = data[off + step + 1];
      const Cr = data[off + step2];
      const Ci = data[off + step2 + 1];
      const Dr = data[off + step3];
      const Di = data[off + step3 + 1];

      // Pre-Final values
      const T0r = Ar + Cr;
      const T0i = Ai + Ci;
      const T1r = Ar - Cr;
      const T1i = Ai - Ci;
      const T2r = Br + Dr;
      const T2i = Bi + Di;
      const T3r = inv * (Br - Dr);
      const T3i = inv * (Bi - Di);

      // Final values
      const FAr = T0r + T2r;
      const FAi = T0i + T2i;
      const FBr = T1r + T3i;
      const FBi = T1i - T3r;
      const FCr = T0r - T2r;
      const FCi = T0i - T2i;
      const FDr = T1r - T3i;
      const FDi = T1i + T3r;
      out[outOff] = FAr;
      out[outOff + 1] = FAi;
      out[outOff + 2] = FBr;
      out[outOff + 3] = FBi;
      out[outOff + 4] = FCr;
      out[outOff + 5] = FCi;
      out[outOff + 6] = FDr;
      out[outOff + 7] = FDi;
    };

    // Real input radix-4 implementation
    FFT$1.prototype._realTransform4 = function _realTransform4() {
      var out = this._out;
      var size = this._csize;

      // Initial step (permute and transform)
      var width = this._width;
      var step = 1 << width;
      var len = size / step << 1;
      var outOff;
      var t;
      var bitrev = this._bitrev;
      if (len === 4) {
        for (outOff = 0, t = 0; outOff < size; outOff += len, t++) {
          const off = bitrev[t];
          this._singleRealTransform2(outOff, off >>> 1, step >>> 1);
        }
      } else {
        // len === 8
        for (outOff = 0, t = 0; outOff < size; outOff += len, t++) {
          const off = bitrev[t];
          this._singleRealTransform4(outOff, off >>> 1, step >>> 1);
        }
      }

      // Loop through steps in decreasing order
      var inv = this._inv ? -1 : 1;
      var table = this.table;
      for (step >>= 2; step >= 2; step >>= 2) {
        len = size / step << 1;
        var halfLen = len >>> 1;
        var quarterLen = halfLen >>> 1;
        var hquarterLen = quarterLen >>> 1;

        // Loop through offsets in the data
        for (outOff = 0; outOff < size; outOff += len) {
          for (var i = 0, k = 0; i <= hquarterLen; i += 2, k += step) {
            var A = outOff + i;
            var B = A + quarterLen;
            var C = B + quarterLen;
            var D = C + quarterLen;

            // Original values
            var Ar = out[A];
            var Ai = out[A + 1];
            var Br = out[B];
            var Bi = out[B + 1];
            var Cr = out[C];
            var Ci = out[C + 1];
            var Dr = out[D];
            var Di = out[D + 1];

            // Middle values
            var MAr = Ar;
            var MAi = Ai;
            var tableBr = table[k];
            var tableBi = inv * table[k + 1];
            var MBr = Br * tableBr - Bi * tableBi;
            var MBi = Br * tableBi + Bi * tableBr;
            var tableCr = table[2 * k];
            var tableCi = inv * table[2 * k + 1];
            var MCr = Cr * tableCr - Ci * tableCi;
            var MCi = Cr * tableCi + Ci * tableCr;
            var tableDr = table[3 * k];
            var tableDi = inv * table[3 * k + 1];
            var MDr = Dr * tableDr - Di * tableDi;
            var MDi = Dr * tableDi + Di * tableDr;

            // Pre-Final values
            var T0r = MAr + MCr;
            var T0i = MAi + MCi;
            var T1r = MAr - MCr;
            var T1i = MAi - MCi;
            var T2r = MBr + MDr;
            var T2i = MBi + MDi;
            var T3r = inv * (MBr - MDr);
            var T3i = inv * (MBi - MDi);

            // Final values
            var FAr = T0r + T2r;
            var FAi = T0i + T2i;
            var FBr = T1r + T3i;
            var FBi = T1i - T3r;
            out[A] = FAr;
            out[A + 1] = FAi;
            out[B] = FBr;
            out[B + 1] = FBi;

            // Output final middle point
            if (i === 0) {
              var FCr = T0r - T2r;
              var FCi = T0i - T2i;
              out[C] = FCr;
              out[C + 1] = FCi;
              continue;
            }

            // Do not overwrite ourselves
            if (i === hquarterLen) continue;

            // In the flipped case:
            // MAi = -MAi
            // MBr=-MBi, MBi=-MBr
            // MCr=-MCr
            // MDr=MDi, MDi=MDr
            var ST0r = T1r;
            var ST0i = -T1i;
            var ST1r = T0r;
            var ST1i = -T0i;
            var ST2r = -inv * T3i;
            var ST2i = -inv * T3r;
            var ST3r = -inv * T2i;
            var ST3i = -inv * T2r;
            var SFAr = ST0r + ST2r;
            var SFAi = ST0i + ST2i;
            var SFBr = ST1r + ST3i;
            var SFBi = ST1i - ST3r;
            var SA = outOff + quarterLen - i;
            var SB = outOff + halfLen - i;
            out[SA] = SFAr;
            out[SA + 1] = SFAi;
            out[SB] = SFBr;
            out[SB + 1] = SFBi;
          }
        }
      }
    };

    // radix-2 implementation
    //
    // NOTE: Only called for len=4
    FFT$1.prototype._singleRealTransform2 = function _singleRealTransform2(outOff, off, step) {
      const out = this._out;
      const data = this._data;
      const evenR = data[off];
      const oddR = data[off + step];
      const leftR = evenR + oddR;
      const rightR = evenR - oddR;
      out[outOff] = leftR;
      out[outOff + 1] = 0;
      out[outOff + 2] = rightR;
      out[outOff + 3] = 0;
    };

    // radix-4
    //
    // NOTE: Only called for len=8
    FFT$1.prototype._singleRealTransform4 = function _singleRealTransform4(outOff, off, step) {
      const out = this._out;
      const data = this._data;
      const inv = this._inv ? -1 : 1;
      const step2 = step * 2;
      const step3 = step * 3;

      // Original values
      const Ar = data[off];
      const Br = data[off + step];
      const Cr = data[off + step2];
      const Dr = data[off + step3];

      // Pre-Final values
      const T0r = Ar + Cr;
      const T1r = Ar - Cr;
      const T2r = Br + Dr;
      const T3r = inv * (Br - Dr);

      // Final values
      const FAr = T0r + T2r;
      const FBr = T1r;
      const FBi = -T3r;
      const FCr = T0r - T2r;
      const FDr = T1r;
      const FDi = T3r;
      out[outOff] = FAr;
      out[outOff + 1] = 0;
      out[outOff + 2] = FBr;
      out[outOff + 3] = FBi;
      out[outOff + 4] = FCr;
      out[outOff + 5] = 0;
      out[outOff + 6] = FDr;
      out[outOff + 7] = FDi;
    };
    var FFT$2 = fft$1;

    /**
     * This function performs a circular shift to an array
     * Positive values of shifts will shift to the right and negative values will do to the left
     *
     * @example xRotate([1,2,3,4],1) -> [4,1,2,3]
     * @example xRotate([1,2,3,4],-1) -> [2,3,4,1]
     * @param array - array
     * @param shift - shift
     * @returns - rotated array
     */
    function xRotate(array, shift) {
      shift = shift % array.length;
      if (shift < 0) shift += array.length;
      let result = new Float64Array(array.length);
      result.set(array.slice(array.length - shift));
      result.set(array.slice(0, array.length - shift), shift);
      return result;
    }

    /**
     * ReimFFT.
     *
     * @param data - complex spectrum
     * @param options - options.
     * @returns FFT of complex spectrum.
     */
    function reimFFT(data, options = {}) {
      const {
        inverse = false,
        applyZeroShift = false
      } = options;
      let {
        re,
        im
      } = data;
      const size = re.length;
      const csize = size << 1;
      let complexArray = new Float64Array(csize);
      for (let i = 0; i < csize; i += 2) {
        complexArray[i] = re[i >>> 1];
        complexArray[i + 1] = im[i >>> 1];
      }
      let fft = new FFT$2(size);
      let output = new Float64Array(csize);
      if (inverse) {
        if (applyZeroShift) complexArray = zeroShift(complexArray, true);
        fft.inverseTransform(output, complexArray);
      } else {
        fft.transform(output, complexArray);
        if (applyZeroShift) output = zeroShift(output);
      }
      let newRe = new Float64Array(size);
      let newIm = new Float64Array(size);
      for (let i = 0; i < csize; i += 2) {
        newRe[i >>> 1] = output[i];
        newIm[i >>> 1] = output[i + 1];
      }
      return {
        re: newRe,
        im: newIm
      };
    }
    const zeroShift = (data, inverse) => {
      let middle = inverse ? Math.ceil(data.length / 2) : Math.floor(data.length / 2);
      return xRotate(data, middle);
    };

    /**
     * This function returns an array with absolute values
     *
     * @param array - array of data
     * @returns - array with absolute values
     */
    function xAbsolute(array) {
      let tmpArray = array.slice();
      for (let i = 0; i < tmpArray.length; i++) {
        if (tmpArray[i] < 0) tmpArray[i] *= -1;
      }
      return tmpArray;
    }

    // eslint-disable-next-line @typescript-eslint/unbound-method
    const toString$2 = Object.prototype.toString;
    /**
     * Checks if an object is an instance of an Array (array or typed array, except those that contain bigint values).
     *
     * @param value - Object to check.
     * @returns True if the object is an array or a typed array.
     */
    function isAnyArray(value) {
      const tag = toString$2.call(value);
      return tag.endsWith('Array]') && !tag.includes('Big');
    }

    /**
     * Calculates the median of an array
     *
     * @param input - Array containing values
     * @returns - median
     */
    function xMedian(input) {
      if (!isAnyArray(input)) {
        throw new TypeError('input must be an array');
      }
      if (input.length === 0) {
        throw new TypeError('input must not be empty');
      }
      const array = input.slice();
      let low = 0;
      let high = array.length - 1;
      let middle = 0;
      let currentLow = 0;
      let currentHigh = 0;
      let median = calcMiddle(low, high);
      while (true) {
        if (high <= low) {
          return array[median];
        }
        if (high === low + 1) {
          if (array[low] > array[high]) {
            swap(array, low, high);
          }
          return array[median];
        }
        // Find median of low, middle and high items; swap into position low
        middle = calcMiddle(low, high);
        if (array[middle] > array[high]) swap(array, middle, high);
        if (array[low] > array[high]) swap(array, low, high);
        if (array[middle] > array[low]) swap(array, middle, low);
        // Swap low item (now in position middle) into position (low+1)
        swap(array, middle, low + 1);
        // Nibble from each end towards middle, swapping items when stuck
        currentLow = low + 1;
        currentHigh = high;
        while (true) {
          do currentLow++; while (array[low] > array[currentLow]);
          do currentHigh--; while (array[currentHigh] > array[low]);
          if (currentHigh < currentLow) {
            break;
          }
          swap(array, currentLow, currentHigh);
        }
        // Swap middle item (in position low) back into correct position
        swap(array, low, currentHigh);
        // Re-set active partition
        if (currentHigh <= median) {
          low = currentLow;
        }
        if (currentHigh >= median) {
          high = currentHigh - 1;
        }
      }
    }
    function swap(array, i, j) {
      const temp = array[j];
      array[j] = array[i];
      array[i] = temp;
    }
    function calcMiddle(i, j) {
      return Math.floor((i + j) / 2);
    }

    /**
     * This function calculates the median after taking the reimAbsolute values of the points
     *
     * @param array - the array for which we want to calculate the absolute value
     * @returns - median
     */
    function xAbsoluteMedian(array) {
      return xMedian(xAbsolute(array));
    }

    /**
     * This function xAdd the first array by the second array or a constant value to each element of the first array
     *
     * @param array1 - the first array
     * @param array2 - the second array or number
     */
    function xAdd(array1, array2) {
      let isConstant = false;
      let constant = 0;
      if (isAnyArray(array2)) {
        if (array1.length !== array2.length) {
          throw new Error('xAdd: size of array1 and array2 must be identical');
        }
      } else {
        isConstant = true;
        constant = array2;
      }
      let array3 = new Float64Array(array1.length);
      if (isConstant) {
        for (let i = 0; i < array1.length; i++) {
          array3[i] = array1[i] + constant;
        }
      } else {
        for (let i = 0; i < array1.length; i++) {
          array3[i] = array1[i] + array2[i];
        }
      }
      return array3;
    }

    /**
     * Will apply a function on each element of the array described as a string
     * By default we will use as variable 'x'
     * In front of sequence of lowercase we will add 'Math.'. This allows to write
     * `sin(x) + cos(x)` and it will be replace internally by (x) => (Math.sin(x) + Math.cos(x))
     * @param array
     * @param options
     * @returns
     */
    function xApplyFunctionStr(array, options = {}) {
      const {
        variableLabel = 'x',
        fctString = variableLabel
      } = options;
      const fct = new Function(variableLabel, `return Number(${fctString.replace(/(?<before>^|\W)(?<after>[\da-z]{2,}\()/g, '$<before>Math.$<after>').replace(/Math\.Math/g, 'Math')})`);
      const toReturn = Float64Array.from(array);
      for (let i = 0; i < array.length; i++) {
        toReturn[i] = fct(array[i]);
        if (Number.isNaN(toReturn[i])) {
          throw new Error(`The callback ${fctString} does not return a number: ${array[i]}`);
        }
      }
      return toReturn;
    }

    /**
     * This function
     * @param output - undefined or a new array
     * @param length - length of the output array
     * @returns
     */
    function getOutputArray(output, length) {
      if (output !== undefined) {
        if (!isAnyArray(output)) {
          throw new TypeError('output option must be an array if specified');
        }
        if (output.length !== length) {
          throw new TypeError('the output array does not have the correct length');
        }
        return output;
      } else {
        return new Float64Array(length);
      }
    }

    /**
     * This function xMultiply the first array by the second array or a constant value to each element of the first array
     *
     * @param array1 - first array
     * @param array2 - second array
     * @param options - options
     */
    function xMultiply(array1, array2, options = {}) {
      let isConstant = false;
      let constant = 0;
      if (isAnyArray(array2)) {
        if (array1.length !== array2.length) {
          throw new Error('xMultiply: size of array1 and array2 must be identical');
        }
      } else {
        isConstant = true;
        constant = Number(array2);
      }
      let array3 = getOutputArray(options.output, array1.length);
      if (isConstant) {
        for (let i = 0; i < array1.length; i++) {
          array3[i] = array1[i] * constant;
        }
      } else {
        for (let i = 0; i < array1.length; i++) {
          array3[i] = array1[i] * array2[i];
        }
      }
      return array3;
    }

    /**
     * Checks if input is of type array
     *
     * @param input - input
     */
    function xCheck(input, options = {}) {
      const {
        minLength
      } = options;
      if (!isAnyArray(input)) {
        throw new TypeError('input must be an array');
      }
      if (input.length === 0) {
        throw new TypeError('input must not be empty');
      }
      if (minLength && input.length < minLength) {
        throw new Error(`input must have a length of at least ${minLength}`);
      }
    }

    function max(input) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      if (!isAnyArray(input)) {
        throw new TypeError('input must be an array');
      }
      if (input.length === 0) {
        throw new TypeError('input must not be empty');
      }
      var _options$fromIndex = options.fromIndex,
        fromIndex = _options$fromIndex === void 0 ? 0 : _options$fromIndex,
        _options$toIndex = options.toIndex,
        toIndex = _options$toIndex === void 0 ? input.length : _options$toIndex;
      if (fromIndex < 0 || fromIndex >= input.length || !Number.isInteger(fromIndex)) {
        throw new Error('fromIndex must be a positive integer smaller than length');
      }
      if (toIndex <= fromIndex || toIndex > input.length || !Number.isInteger(toIndex)) {
        throw new Error('toIndex must be an integer greater than fromIndex and at most equal to length');
      }
      var maxValue = input[fromIndex];
      for (var i = fromIndex + 1; i < toIndex; i++) {
        if (input[i] > maxValue) maxValue = input[i];
      }
      return maxValue;
    }

    function min(input) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      if (!isAnyArray(input)) {
        throw new TypeError('input must be an array');
      }
      if (input.length === 0) {
        throw new TypeError('input must not be empty');
      }
      var _options$fromIndex = options.fromIndex,
        fromIndex = _options$fromIndex === void 0 ? 0 : _options$fromIndex,
        _options$toIndex = options.toIndex,
        toIndex = _options$toIndex === void 0 ? input.length : _options$toIndex;
      if (fromIndex < 0 || fromIndex >= input.length || !Number.isInteger(fromIndex)) {
        throw new Error('fromIndex must be a positive integer smaller than length');
      }
      if (toIndex <= fromIndex || toIndex > input.length || !Number.isInteger(toIndex)) {
        throw new Error('toIndex must be an integer greater than fromIndex and at most equal to length');
      }
      var minValue = input[fromIndex];
      for (var i = fromIndex + 1; i < toIndex; i++) {
        if (input[i] < minValue) minValue = input[i];
      }
      return minValue;
    }

    function rescale$1(input) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      if (!isAnyArray(input)) {
        throw new TypeError('input must be an array');
      } else if (input.length === 0) {
        throw new TypeError('input must not be empty');
      }
      var output;
      if (options.output !== undefined) {
        if (!isAnyArray(options.output)) {
          throw new TypeError('output option must be an array if specified');
        }
        output = options.output;
      } else {
        output = new Array(input.length);
      }
      var currentMin = min(input);
      var currentMax = max(input);
      if (currentMin === currentMax) {
        throw new RangeError('minimum and maximum input values are equal. Cannot rescale a constant array');
      }
      var _options$min = options.min,
        minValue = _options$min === void 0 ? options.autoMinMax ? currentMin : 0 : _options$min,
        _options$max = options.max,
        maxValue = _options$max === void 0 ? options.autoMinMax ? currentMax : 1 : _options$max;
      if (minValue >= maxValue) {
        throw new RangeError('min option must be smaller than max option');
      }
      var factor = (maxValue - minValue) / (currentMax - currentMin);
      for (var i = 0; i < input.length; i++) {
        output[i] = (input[i] - currentMin) * factor + minValue;
      }
      return output;
    }

    const indent = ' '.repeat(2);
    const indentData = ' '.repeat(4);
    function inspectMatrix() {
      return inspectMatrixWithOptions(this);
    }
    function inspectMatrixWithOptions(matrix, options = {}) {
      const {
        maxRows = 15,
        maxColumns = 10,
        maxNumSize = 8,
        padMinus = 'auto'
      } = options;
      return `${matrix.constructor.name} {
${indent}[
${indentData}${inspectData(matrix, maxRows, maxColumns, maxNumSize, padMinus)}
${indent}]
${indent}rows: ${matrix.rows}
${indent}columns: ${matrix.columns}
}`;
    }
    function inspectData(matrix, maxRows, maxColumns, maxNumSize, padMinus) {
      const {
        rows,
        columns
      } = matrix;
      const maxI = Math.min(rows, maxRows);
      const maxJ = Math.min(columns, maxColumns);
      const result = [];
      if (padMinus === 'auto') {
        padMinus = false;
        loop: for (let i = 0; i < maxI; i++) {
          for (let j = 0; j < maxJ; j++) {
            if (matrix.get(i, j) < 0) {
              padMinus = true;
              break loop;
            }
          }
        }
      }
      for (let i = 0; i < maxI; i++) {
        let line = [];
        for (let j = 0; j < maxJ; j++) {
          line.push(formatNumber(matrix.get(i, j), maxNumSize, padMinus));
        }
        result.push(`${line.join(' ')}`);
      }
      if (maxJ !== columns) {
        result[result.length - 1] += ` ... ${columns - maxColumns} more columns`;
      }
      if (maxI !== rows) {
        result.push(`... ${rows - maxRows} more rows`);
      }
      return result.join(`\n${indentData}`);
    }
    function formatNumber(num, maxNumSize, padMinus) {
      return (num >= 0 && padMinus ? ` ${formatNumber2(num, maxNumSize - 1)}` : formatNumber2(num, maxNumSize)).padEnd(maxNumSize);
    }
    function formatNumber2(num, len) {
      // small.length numbers should be as is
      let str = num.toString();
      if (str.length <= len) return str;

      // (7)'0.00123' is better then (7)'1.23e-2'
      // (8)'0.000123' is worse then (7)'1.23e-3',
      let fix = num.toFixed(len);
      if (fix.length > len) {
        fix = num.toFixed(Math.max(0, len - (fix.length - len)));
      }
      if (fix.length <= len && !fix.startsWith('0.000') && !fix.startsWith('-0.000')) {
        return fix;
      }

      // well, if it's still too long the user should've used longer numbers
      let exp = num.toExponential(len);
      if (exp.length > len) {
        exp = num.toExponential(Math.max(0, len - (exp.length - len)));
      }
      return exp.slice(0);
    }

    function installMathOperations(AbstractMatrix, Matrix) {
      AbstractMatrix.prototype.add = function add(value) {
        if (typeof value === 'number') return this.addS(value);
        return this.addM(value);
      };
      AbstractMatrix.prototype.addS = function addS(value) {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) + value);
          }
        }
        return this;
      };
      AbstractMatrix.prototype.addM = function addM(matrix) {
        matrix = Matrix.checkMatrix(matrix);
        if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
          throw new RangeError('Matrices dimensions must be equal');
        }
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) + matrix.get(i, j));
          }
        }
        return this;
      };
      AbstractMatrix.add = function add(matrix, value) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.add(value);
      };
      AbstractMatrix.prototype.sub = function sub(value) {
        if (typeof value === 'number') return this.subS(value);
        return this.subM(value);
      };
      AbstractMatrix.prototype.subS = function subS(value) {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) - value);
          }
        }
        return this;
      };
      AbstractMatrix.prototype.subM = function subM(matrix) {
        matrix = Matrix.checkMatrix(matrix);
        if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
          throw new RangeError('Matrices dimensions must be equal');
        }
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) - matrix.get(i, j));
          }
        }
        return this;
      };
      AbstractMatrix.sub = function sub(matrix, value) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.sub(value);
      };
      AbstractMatrix.prototype.subtract = AbstractMatrix.prototype.sub;
      AbstractMatrix.prototype.subtractS = AbstractMatrix.prototype.subS;
      AbstractMatrix.prototype.subtractM = AbstractMatrix.prototype.subM;
      AbstractMatrix.subtract = AbstractMatrix.sub;
      AbstractMatrix.prototype.mul = function mul(value) {
        if (typeof value === 'number') return this.mulS(value);
        return this.mulM(value);
      };
      AbstractMatrix.prototype.mulS = function mulS(value) {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) * value);
          }
        }
        return this;
      };
      AbstractMatrix.prototype.mulM = function mulM(matrix) {
        matrix = Matrix.checkMatrix(matrix);
        if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
          throw new RangeError('Matrices dimensions must be equal');
        }
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) * matrix.get(i, j));
          }
        }
        return this;
      };
      AbstractMatrix.mul = function mul(matrix, value) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.mul(value);
      };
      AbstractMatrix.prototype.multiply = AbstractMatrix.prototype.mul;
      AbstractMatrix.prototype.multiplyS = AbstractMatrix.prototype.mulS;
      AbstractMatrix.prototype.multiplyM = AbstractMatrix.prototype.mulM;
      AbstractMatrix.multiply = AbstractMatrix.mul;
      AbstractMatrix.prototype.div = function div(value) {
        if (typeof value === 'number') return this.divS(value);
        return this.divM(value);
      };
      AbstractMatrix.prototype.divS = function divS(value) {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) / value);
          }
        }
        return this;
      };
      AbstractMatrix.prototype.divM = function divM(matrix) {
        matrix = Matrix.checkMatrix(matrix);
        if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
          throw new RangeError('Matrices dimensions must be equal');
        }
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) / matrix.get(i, j));
          }
        }
        return this;
      };
      AbstractMatrix.div = function div(matrix, value) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.div(value);
      };
      AbstractMatrix.prototype.divide = AbstractMatrix.prototype.div;
      AbstractMatrix.prototype.divideS = AbstractMatrix.prototype.divS;
      AbstractMatrix.prototype.divideM = AbstractMatrix.prototype.divM;
      AbstractMatrix.divide = AbstractMatrix.div;
      AbstractMatrix.prototype.mod = function mod(value) {
        if (typeof value === 'number') return this.modS(value);
        return this.modM(value);
      };
      AbstractMatrix.prototype.modS = function modS(value) {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) % value);
          }
        }
        return this;
      };
      AbstractMatrix.prototype.modM = function modM(matrix) {
        matrix = Matrix.checkMatrix(matrix);
        if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
          throw new RangeError('Matrices dimensions must be equal');
        }
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) % matrix.get(i, j));
          }
        }
        return this;
      };
      AbstractMatrix.mod = function mod(matrix, value) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.mod(value);
      };
      AbstractMatrix.prototype.modulus = AbstractMatrix.prototype.mod;
      AbstractMatrix.prototype.modulusS = AbstractMatrix.prototype.modS;
      AbstractMatrix.prototype.modulusM = AbstractMatrix.prototype.modM;
      AbstractMatrix.modulus = AbstractMatrix.mod;
      AbstractMatrix.prototype.and = function and(value) {
        if (typeof value === 'number') return this.andS(value);
        return this.andM(value);
      };
      AbstractMatrix.prototype.andS = function andS(value) {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) & value);
          }
        }
        return this;
      };
      AbstractMatrix.prototype.andM = function andM(matrix) {
        matrix = Matrix.checkMatrix(matrix);
        if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
          throw new RangeError('Matrices dimensions must be equal');
        }
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) & matrix.get(i, j));
          }
        }
        return this;
      };
      AbstractMatrix.and = function and(matrix, value) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.and(value);
      };
      AbstractMatrix.prototype.or = function or(value) {
        if (typeof value === 'number') return this.orS(value);
        return this.orM(value);
      };
      AbstractMatrix.prototype.orS = function orS(value) {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) | value);
          }
        }
        return this;
      };
      AbstractMatrix.prototype.orM = function orM(matrix) {
        matrix = Matrix.checkMatrix(matrix);
        if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
          throw new RangeError('Matrices dimensions must be equal');
        }
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) | matrix.get(i, j));
          }
        }
        return this;
      };
      AbstractMatrix.or = function or(matrix, value) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.or(value);
      };
      AbstractMatrix.prototype.xor = function xor(value) {
        if (typeof value === 'number') return this.xorS(value);
        return this.xorM(value);
      };
      AbstractMatrix.prototype.xorS = function xorS(value) {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) ^ value);
          }
        }
        return this;
      };
      AbstractMatrix.prototype.xorM = function xorM(matrix) {
        matrix = Matrix.checkMatrix(matrix);
        if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
          throw new RangeError('Matrices dimensions must be equal');
        }
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) ^ matrix.get(i, j));
          }
        }
        return this;
      };
      AbstractMatrix.xor = function xor(matrix, value) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.xor(value);
      };
      AbstractMatrix.prototype.leftShift = function leftShift(value) {
        if (typeof value === 'number') return this.leftShiftS(value);
        return this.leftShiftM(value);
      };
      AbstractMatrix.prototype.leftShiftS = function leftShiftS(value) {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) << value);
          }
        }
        return this;
      };
      AbstractMatrix.prototype.leftShiftM = function leftShiftM(matrix) {
        matrix = Matrix.checkMatrix(matrix);
        if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
          throw new RangeError('Matrices dimensions must be equal');
        }
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) << matrix.get(i, j));
          }
        }
        return this;
      };
      AbstractMatrix.leftShift = function leftShift(matrix, value) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.leftShift(value);
      };
      AbstractMatrix.prototype.signPropagatingRightShift = function signPropagatingRightShift(value) {
        if (typeof value === 'number') return this.signPropagatingRightShiftS(value);
        return this.signPropagatingRightShiftM(value);
      };
      AbstractMatrix.prototype.signPropagatingRightShiftS = function signPropagatingRightShiftS(value) {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) >> value);
          }
        }
        return this;
      };
      AbstractMatrix.prototype.signPropagatingRightShiftM = function signPropagatingRightShiftM(matrix) {
        matrix = Matrix.checkMatrix(matrix);
        if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
          throw new RangeError('Matrices dimensions must be equal');
        }
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) >> matrix.get(i, j));
          }
        }
        return this;
      };
      AbstractMatrix.signPropagatingRightShift = function signPropagatingRightShift(matrix, value) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.signPropagatingRightShift(value);
      };
      AbstractMatrix.prototype.rightShift = function rightShift(value) {
        if (typeof value === 'number') return this.rightShiftS(value);
        return this.rightShiftM(value);
      };
      AbstractMatrix.prototype.rightShiftS = function rightShiftS(value) {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) >>> value);
          }
        }
        return this;
      };
      AbstractMatrix.prototype.rightShiftM = function rightShiftM(matrix) {
        matrix = Matrix.checkMatrix(matrix);
        if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
          throw new RangeError('Matrices dimensions must be equal');
        }
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) >>> matrix.get(i, j));
          }
        }
        return this;
      };
      AbstractMatrix.rightShift = function rightShift(matrix, value) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.rightShift(value);
      };
      AbstractMatrix.prototype.zeroFillRightShift = AbstractMatrix.prototype.rightShift;
      AbstractMatrix.prototype.zeroFillRightShiftS = AbstractMatrix.prototype.rightShiftS;
      AbstractMatrix.prototype.zeroFillRightShiftM = AbstractMatrix.prototype.rightShiftM;
      AbstractMatrix.zeroFillRightShift = AbstractMatrix.rightShift;
      AbstractMatrix.prototype.not = function not() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, ~this.get(i, j));
          }
        }
        return this;
      };
      AbstractMatrix.not = function not(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.not();
      };
      AbstractMatrix.prototype.abs = function abs() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.abs(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.abs = function abs(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.abs();
      };
      AbstractMatrix.prototype.acos = function acos() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.acos(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.acos = function acos(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.acos();
      };
      AbstractMatrix.prototype.acosh = function acosh() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.acosh(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.acosh = function acosh(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.acosh();
      };
      AbstractMatrix.prototype.asin = function asin() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.asin(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.asin = function asin(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.asin();
      };
      AbstractMatrix.prototype.asinh = function asinh() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.asinh(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.asinh = function asinh(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.asinh();
      };
      AbstractMatrix.prototype.atan = function atan() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.atan(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.atan = function atan(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.atan();
      };
      AbstractMatrix.prototype.atanh = function atanh() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.atanh(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.atanh = function atanh(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.atanh();
      };
      AbstractMatrix.prototype.cbrt = function cbrt() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.cbrt(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.cbrt = function cbrt(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.cbrt();
      };
      AbstractMatrix.prototype.ceil = function ceil() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.ceil(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.ceil = function ceil(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.ceil();
      };
      AbstractMatrix.prototype.clz32 = function clz32() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.clz32(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.clz32 = function clz32(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.clz32();
      };
      AbstractMatrix.prototype.cos = function cos() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.cos(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.cos = function cos(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.cos();
      };
      AbstractMatrix.prototype.cosh = function cosh() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.cosh(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.cosh = function cosh(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.cosh();
      };
      AbstractMatrix.prototype.exp = function exp() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.exp(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.exp = function exp(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.exp();
      };
      AbstractMatrix.prototype.expm1 = function expm1() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.expm1(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.expm1 = function expm1(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.expm1();
      };
      AbstractMatrix.prototype.floor = function floor() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.floor(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.floor = function floor(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.floor();
      };
      AbstractMatrix.prototype.fround = function fround() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.fround(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.fround = function fround(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.fround();
      };
      AbstractMatrix.prototype.log = function log() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.log(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.log = function log(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.log();
      };
      AbstractMatrix.prototype.log1p = function log1p() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.log1p(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.log1p = function log1p(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.log1p();
      };
      AbstractMatrix.prototype.log10 = function log10() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.log10(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.log10 = function log10(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.log10();
      };
      AbstractMatrix.prototype.log2 = function log2() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.log2(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.log2 = function log2(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.log2();
      };
      AbstractMatrix.prototype.round = function round() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.round(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.round = function round(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.round();
      };
      AbstractMatrix.prototype.sign = function sign() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.sign(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.sign = function sign(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.sign();
      };
      AbstractMatrix.prototype.sin = function sin() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.sin(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.sin = function sin(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.sin();
      };
      AbstractMatrix.prototype.sinh = function sinh() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.sinh(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.sinh = function sinh(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.sinh();
      };
      AbstractMatrix.prototype.sqrt = function sqrt() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.sqrt(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.sqrt = function sqrt(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.sqrt();
      };
      AbstractMatrix.prototype.tan = function tan() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.tan(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.tan = function tan(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.tan();
      };
      AbstractMatrix.prototype.tanh = function tanh() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.tanh(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.tanh = function tanh(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.tanh();
      };
      AbstractMatrix.prototype.trunc = function trunc() {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.trunc(this.get(i, j)));
          }
        }
        return this;
      };
      AbstractMatrix.trunc = function trunc(matrix) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.trunc();
      };
      AbstractMatrix.pow = function pow(matrix, arg0) {
        const newMatrix = new Matrix(matrix);
        return newMatrix.pow(arg0);
      };
      AbstractMatrix.prototype.pow = function pow(value) {
        if (typeof value === 'number') return this.powS(value);
        return this.powM(value);
      };
      AbstractMatrix.prototype.powS = function powS(value) {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.pow(this.get(i, j), value));
          }
        }
        return this;
      };
      AbstractMatrix.prototype.powM = function powM(matrix) {
        matrix = Matrix.checkMatrix(matrix);
        if (this.rows !== matrix.rows || this.columns !== matrix.columns) {
          throw new RangeError('Matrices dimensions must be equal');
        }
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, Math.pow(this.get(i, j), matrix.get(i, j)));
          }
        }
        return this;
      };
    }

    /**
     * @private
     * Check that a row index is not out of bounds
     * @param {Matrix} matrix
     * @param {number} index
     * @param {boolean} [outer]
     */
    function checkRowIndex(matrix, index, outer) {
      let max = outer ? matrix.rows : matrix.rows - 1;
      if (index < 0 || index > max) {
        throw new RangeError('Row index out of range');
      }
    }

    /**
     * @private
     * Check that a column index is not out of bounds
     * @param {Matrix} matrix
     * @param {number} index
     * @param {boolean} [outer]
     */
    function checkColumnIndex(matrix, index, outer) {
      let max = outer ? matrix.columns : matrix.columns - 1;
      if (index < 0 || index > max) {
        throw new RangeError('Column index out of range');
      }
    }

    /**
     * @private
     * Check that the provided vector is an array with the right length
     * @param {Matrix} matrix
     * @param {Array|Matrix} vector
     * @return {Array}
     * @throws {RangeError}
     */
    function checkRowVector(matrix, vector) {
      if (vector.to1DArray) {
        vector = vector.to1DArray();
      }
      if (vector.length !== matrix.columns) {
        throw new RangeError('vector size must be the same as the number of columns');
      }
      return vector;
    }

    /**
     * @private
     * Check that the provided vector is an array with the right length
     * @param {Matrix} matrix
     * @param {Array|Matrix} vector
     * @return {Array}
     * @throws {RangeError}
     */
    function checkColumnVector(matrix, vector) {
      if (vector.to1DArray) {
        vector = vector.to1DArray();
      }
      if (vector.length !== matrix.rows) {
        throw new RangeError('vector size must be the same as the number of rows');
      }
      return vector;
    }
    function checkRowIndices(matrix, rowIndices) {
      if (!isAnyArray(rowIndices)) {
        throw new TypeError('row indices must be an array');
      }
      for (let i = 0; i < rowIndices.length; i++) {
        if (rowIndices[i] < 0 || rowIndices[i] >= matrix.rows) {
          throw new RangeError('row indices are out of range');
        }
      }
    }
    function checkColumnIndices(matrix, columnIndices) {
      if (!isAnyArray(columnIndices)) {
        throw new TypeError('column indices must be an array');
      }
      for (let i = 0; i < columnIndices.length; i++) {
        if (columnIndices[i] < 0 || columnIndices[i] >= matrix.columns) {
          throw new RangeError('column indices are out of range');
        }
      }
    }
    function checkRange$1(matrix, startRow, endRow, startColumn, endColumn) {
      if (arguments.length !== 5) {
        throw new RangeError('expected 4 arguments');
      }
      checkNumber('startRow', startRow);
      checkNumber('endRow', endRow);
      checkNumber('startColumn', startColumn);
      checkNumber('endColumn', endColumn);
      if (startRow > endRow || startColumn > endColumn || startRow < 0 || startRow >= matrix.rows || endRow < 0 || endRow >= matrix.rows || startColumn < 0 || startColumn >= matrix.columns || endColumn < 0 || endColumn >= matrix.columns) {
        throw new RangeError('Submatrix indices are out of range');
      }
    }
    function newArray$1(length, value = 0) {
      let array = [];
      for (let i = 0; i < length; i++) {
        array.push(value);
      }
      return array;
    }
    function checkNumber(name, value) {
      if (typeof value !== 'number') {
        throw new TypeError(`${name} must be a number`);
      }
    }
    function checkNonEmpty(matrix) {
      if (matrix.isEmpty()) {
        throw new Error('Empty matrix has no elements to index');
      }
    }

    function sumByRow(matrix) {
      let sum = newArray$1(matrix.rows);
      for (let i = 0; i < matrix.rows; ++i) {
        for (let j = 0; j < matrix.columns; ++j) {
          sum[i] += matrix.get(i, j);
        }
      }
      return sum;
    }
    function sumByColumn(matrix) {
      let sum = newArray$1(matrix.columns);
      for (let i = 0; i < matrix.rows; ++i) {
        for (let j = 0; j < matrix.columns; ++j) {
          sum[j] += matrix.get(i, j);
        }
      }
      return sum;
    }
    function sumAll(matrix) {
      let v = 0;
      for (let i = 0; i < matrix.rows; i++) {
        for (let j = 0; j < matrix.columns; j++) {
          v += matrix.get(i, j);
        }
      }
      return v;
    }
    function productByRow(matrix) {
      let sum = newArray$1(matrix.rows, 1);
      for (let i = 0; i < matrix.rows; ++i) {
        for (let j = 0; j < matrix.columns; ++j) {
          sum[i] *= matrix.get(i, j);
        }
      }
      return sum;
    }
    function productByColumn(matrix) {
      let sum = newArray$1(matrix.columns, 1);
      for (let i = 0; i < matrix.rows; ++i) {
        for (let j = 0; j < matrix.columns; ++j) {
          sum[j] *= matrix.get(i, j);
        }
      }
      return sum;
    }
    function productAll(matrix) {
      let v = 1;
      for (let i = 0; i < matrix.rows; i++) {
        for (let j = 0; j < matrix.columns; j++) {
          v *= matrix.get(i, j);
        }
      }
      return v;
    }
    function varianceByRow(matrix, unbiased, mean) {
      const rows = matrix.rows;
      const cols = matrix.columns;
      const variance = [];
      for (let i = 0; i < rows; i++) {
        let sum1 = 0;
        let sum2 = 0;
        let x = 0;
        for (let j = 0; j < cols; j++) {
          x = matrix.get(i, j) - mean[i];
          sum1 += x;
          sum2 += x * x;
        }
        if (unbiased) {
          variance.push((sum2 - sum1 * sum1 / cols) / (cols - 1));
        } else {
          variance.push((sum2 - sum1 * sum1 / cols) / cols);
        }
      }
      return variance;
    }
    function varianceByColumn(matrix, unbiased, mean) {
      const rows = matrix.rows;
      const cols = matrix.columns;
      const variance = [];
      for (let j = 0; j < cols; j++) {
        let sum1 = 0;
        let sum2 = 0;
        let x = 0;
        for (let i = 0; i < rows; i++) {
          x = matrix.get(i, j) - mean[j];
          sum1 += x;
          sum2 += x * x;
        }
        if (unbiased) {
          variance.push((sum2 - sum1 * sum1 / rows) / (rows - 1));
        } else {
          variance.push((sum2 - sum1 * sum1 / rows) / rows);
        }
      }
      return variance;
    }
    function varianceAll(matrix, unbiased, mean) {
      const rows = matrix.rows;
      const cols = matrix.columns;
      const size = rows * cols;
      let sum1 = 0;
      let sum2 = 0;
      let x = 0;
      for (let i = 0; i < rows; i++) {
        for (let j = 0; j < cols; j++) {
          x = matrix.get(i, j) - mean;
          sum1 += x;
          sum2 += x * x;
        }
      }
      if (unbiased) {
        return (sum2 - sum1 * sum1 / size) / (size - 1);
      } else {
        return (sum2 - sum1 * sum1 / size) / size;
      }
    }
    function centerByRow(matrix, mean) {
      for (let i = 0; i < matrix.rows; i++) {
        for (let j = 0; j < matrix.columns; j++) {
          matrix.set(i, j, matrix.get(i, j) - mean[i]);
        }
      }
    }
    function centerByColumn(matrix, mean) {
      for (let i = 0; i < matrix.rows; i++) {
        for (let j = 0; j < matrix.columns; j++) {
          matrix.set(i, j, matrix.get(i, j) - mean[j]);
        }
      }
    }
    function centerAll(matrix, mean) {
      for (let i = 0; i < matrix.rows; i++) {
        for (let j = 0; j < matrix.columns; j++) {
          matrix.set(i, j, matrix.get(i, j) - mean);
        }
      }
    }
    function getScaleByRow(matrix) {
      const scale = [];
      for (let i = 0; i < matrix.rows; i++) {
        let sum = 0;
        for (let j = 0; j < matrix.columns; j++) {
          sum += Math.pow(matrix.get(i, j), 2) / (matrix.columns - 1);
        }
        scale.push(Math.sqrt(sum));
      }
      return scale;
    }
    function scaleByRow(matrix, scale) {
      for (let i = 0; i < matrix.rows; i++) {
        for (let j = 0; j < matrix.columns; j++) {
          matrix.set(i, j, matrix.get(i, j) / scale[i]);
        }
      }
    }
    function getScaleByColumn(matrix) {
      const scale = [];
      for (let j = 0; j < matrix.columns; j++) {
        let sum = 0;
        for (let i = 0; i < matrix.rows; i++) {
          sum += Math.pow(matrix.get(i, j), 2) / (matrix.rows - 1);
        }
        scale.push(Math.sqrt(sum));
      }
      return scale;
    }
    function scaleByColumn(matrix, scale) {
      for (let i = 0; i < matrix.rows; i++) {
        for (let j = 0; j < matrix.columns; j++) {
          matrix.set(i, j, matrix.get(i, j) / scale[j]);
        }
      }
    }
    function getScaleAll(matrix) {
      const divider = matrix.size - 1;
      let sum = 0;
      for (let j = 0; j < matrix.columns; j++) {
        for (let i = 0; i < matrix.rows; i++) {
          sum += Math.pow(matrix.get(i, j), 2) / divider;
        }
      }
      return Math.sqrt(sum);
    }
    function scaleAll(matrix, scale) {
      for (let i = 0; i < matrix.rows; i++) {
        for (let j = 0; j < matrix.columns; j++) {
          matrix.set(i, j, matrix.get(i, j) / scale);
        }
      }
    }

    class AbstractMatrix {
      static from1DArray(newRows, newColumns, newData) {
        let length = newRows * newColumns;
        if (length !== newData.length) {
          throw new RangeError('data length does not match given dimensions');
        }
        let newMatrix = new Matrix(newRows, newColumns);
        for (let row = 0; row < newRows; row++) {
          for (let column = 0; column < newColumns; column++) {
            newMatrix.set(row, column, newData[row * newColumns + column]);
          }
        }
        return newMatrix;
      }
      static rowVector(newData) {
        let vector = new Matrix(1, newData.length);
        for (let i = 0; i < newData.length; i++) {
          vector.set(0, i, newData[i]);
        }
        return vector;
      }
      static columnVector(newData) {
        let vector = new Matrix(newData.length, 1);
        for (let i = 0; i < newData.length; i++) {
          vector.set(i, 0, newData[i]);
        }
        return vector;
      }
      static zeros(rows, columns) {
        return new Matrix(rows, columns);
      }
      static ones(rows, columns) {
        return new Matrix(rows, columns).fill(1);
      }
      static rand(rows, columns, options = {}) {
        if (typeof options !== 'object') {
          throw new TypeError('options must be an object');
        }
        const {
          random = Math.random
        } = options;
        let matrix = new Matrix(rows, columns);
        for (let i = 0; i < rows; i++) {
          for (let j = 0; j < columns; j++) {
            matrix.set(i, j, random());
          }
        }
        return matrix;
      }
      static randInt(rows, columns, options = {}) {
        if (typeof options !== 'object') {
          throw new TypeError('options must be an object');
        }
        const {
          min = 0,
          max = 1000,
          random = Math.random
        } = options;
        if (!Number.isInteger(min)) throw new TypeError('min must be an integer');
        if (!Number.isInteger(max)) throw new TypeError('max must be an integer');
        if (min >= max) throw new RangeError('min must be smaller than max');
        let interval = max - min;
        let matrix = new Matrix(rows, columns);
        for (let i = 0; i < rows; i++) {
          for (let j = 0; j < columns; j++) {
            let value = min + Math.round(random() * interval);
            matrix.set(i, j, value);
          }
        }
        return matrix;
      }
      static eye(rows, columns, value) {
        if (columns === undefined) columns = rows;
        if (value === undefined) value = 1;
        let min = Math.min(rows, columns);
        let matrix = this.zeros(rows, columns);
        for (let i = 0; i < min; i++) {
          matrix.set(i, i, value);
        }
        return matrix;
      }
      static diag(data, rows, columns) {
        let l = data.length;
        if (rows === undefined) rows = l;
        if (columns === undefined) columns = rows;
        let min = Math.min(l, rows, columns);
        let matrix = this.zeros(rows, columns);
        for (let i = 0; i < min; i++) {
          matrix.set(i, i, data[i]);
        }
        return matrix;
      }
      static min(matrix1, matrix2) {
        matrix1 = this.checkMatrix(matrix1);
        matrix2 = this.checkMatrix(matrix2);
        let rows = matrix1.rows;
        let columns = matrix1.columns;
        let result = new Matrix(rows, columns);
        for (let i = 0; i < rows; i++) {
          for (let j = 0; j < columns; j++) {
            result.set(i, j, Math.min(matrix1.get(i, j), matrix2.get(i, j)));
          }
        }
        return result;
      }
      static max(matrix1, matrix2) {
        matrix1 = this.checkMatrix(matrix1);
        matrix2 = this.checkMatrix(matrix2);
        let rows = matrix1.rows;
        let columns = matrix1.columns;
        let result = new this(rows, columns);
        for (let i = 0; i < rows; i++) {
          for (let j = 0; j < columns; j++) {
            result.set(i, j, Math.max(matrix1.get(i, j), matrix2.get(i, j)));
          }
        }
        return result;
      }
      static checkMatrix(value) {
        return AbstractMatrix.isMatrix(value) ? value : new Matrix(value);
      }
      static isMatrix(value) {
        return value != null && value.klass === 'Matrix';
      }
      get size() {
        return this.rows * this.columns;
      }
      apply(callback) {
        if (typeof callback !== 'function') {
          throw new TypeError('callback must be a function');
        }
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            callback.call(this, i, j);
          }
        }
        return this;
      }
      to1DArray() {
        let array = [];
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            array.push(this.get(i, j));
          }
        }
        return array;
      }
      to2DArray() {
        let copy = [];
        for (let i = 0; i < this.rows; i++) {
          copy.push([]);
          for (let j = 0; j < this.columns; j++) {
            copy[i].push(this.get(i, j));
          }
        }
        return copy;
      }
      toJSON() {
        return this.to2DArray();
      }
      isRowVector() {
        return this.rows === 1;
      }
      isColumnVector() {
        return this.columns === 1;
      }
      isVector() {
        return this.rows === 1 || this.columns === 1;
      }
      isSquare() {
        return this.rows === this.columns;
      }
      isEmpty() {
        return this.rows === 0 || this.columns === 0;
      }
      isSymmetric() {
        if (this.isSquare()) {
          for (let i = 0; i < this.rows; i++) {
            for (let j = 0; j <= i; j++) {
              if (this.get(i, j) !== this.get(j, i)) {
                return false;
              }
            }
          }
          return true;
        }
        return false;
      }
      isEchelonForm() {
        let i = 0;
        let j = 0;
        let previousColumn = -1;
        let isEchelonForm = true;
        let checked = false;
        while (i < this.rows && isEchelonForm) {
          j = 0;
          checked = false;
          while (j < this.columns && checked === false) {
            if (this.get(i, j) === 0) {
              j++;
            } else if (this.get(i, j) === 1 && j > previousColumn) {
              checked = true;
              previousColumn = j;
            } else {
              isEchelonForm = false;
              checked = true;
            }
          }
          i++;
        }
        return isEchelonForm;
      }
      isReducedEchelonForm() {
        let i = 0;
        let j = 0;
        let previousColumn = -1;
        let isReducedEchelonForm = true;
        let checked = false;
        while (i < this.rows && isReducedEchelonForm) {
          j = 0;
          checked = false;
          while (j < this.columns && checked === false) {
            if (this.get(i, j) === 0) {
              j++;
            } else if (this.get(i, j) === 1 && j > previousColumn) {
              checked = true;
              previousColumn = j;
            } else {
              isReducedEchelonForm = false;
              checked = true;
            }
          }
          for (let k = j + 1; k < this.rows; k++) {
            if (this.get(i, k) !== 0) {
              isReducedEchelonForm = false;
            }
          }
          i++;
        }
        return isReducedEchelonForm;
      }
      echelonForm() {
        let result = this.clone();
        let h = 0;
        let k = 0;
        while (h < result.rows && k < result.columns) {
          let iMax = h;
          for (let i = h; i < result.rows; i++) {
            if (result.get(i, k) > result.get(iMax, k)) {
              iMax = i;
            }
          }
          if (result.get(iMax, k) === 0) {
            k++;
          } else {
            result.swapRows(h, iMax);
            let tmp = result.get(h, k);
            for (let j = k; j < result.columns; j++) {
              result.set(h, j, result.get(h, j) / tmp);
            }
            for (let i = h + 1; i < result.rows; i++) {
              let factor = result.get(i, k) / result.get(h, k);
              result.set(i, k, 0);
              for (let j = k + 1; j < result.columns; j++) {
                result.set(i, j, result.get(i, j) - result.get(h, j) * factor);
              }
            }
            h++;
            k++;
          }
        }
        return result;
      }
      reducedEchelonForm() {
        let result = this.echelonForm();
        let m = result.columns;
        let n = result.rows;
        let h = n - 1;
        while (h >= 0) {
          if (result.maxRow(h) === 0) {
            h--;
          } else {
            let p = 0;
            let pivot = false;
            while (p < n && pivot === false) {
              if (result.get(h, p) === 1) {
                pivot = true;
              } else {
                p++;
              }
            }
            for (let i = 0; i < h; i++) {
              let factor = result.get(i, p);
              for (let j = p; j < m; j++) {
                let tmp = result.get(i, j) - factor * result.get(h, j);
                result.set(i, j, tmp);
              }
            }
            h--;
          }
        }
        return result;
      }
      set() {
        throw new Error('set method is unimplemented');
      }
      get() {
        throw new Error('get method is unimplemented');
      }
      repeat(options = {}) {
        if (typeof options !== 'object') {
          throw new TypeError('options must be an object');
        }
        const {
          rows = 1,
          columns = 1
        } = options;
        if (!Number.isInteger(rows) || rows <= 0) {
          throw new TypeError('rows must be a positive integer');
        }
        if (!Number.isInteger(columns) || columns <= 0) {
          throw new TypeError('columns must be a positive integer');
        }
        let matrix = new Matrix(this.rows * rows, this.columns * columns);
        for (let i = 0; i < rows; i++) {
          for (let j = 0; j < columns; j++) {
            matrix.setSubMatrix(this, this.rows * i, this.columns * j);
          }
        }
        return matrix;
      }
      fill(value) {
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, value);
          }
        }
        return this;
      }
      neg() {
        return this.mulS(-1);
      }
      getRow(index) {
        checkRowIndex(this, index);
        let row = [];
        for (let i = 0; i < this.columns; i++) {
          row.push(this.get(index, i));
        }
        return row;
      }
      getRowVector(index) {
        return Matrix.rowVector(this.getRow(index));
      }
      setRow(index, array) {
        checkRowIndex(this, index);
        array = checkRowVector(this, array);
        for (let i = 0; i < this.columns; i++) {
          this.set(index, i, array[i]);
        }
        return this;
      }
      swapRows(row1, row2) {
        checkRowIndex(this, row1);
        checkRowIndex(this, row2);
        for (let i = 0; i < this.columns; i++) {
          let temp = this.get(row1, i);
          this.set(row1, i, this.get(row2, i));
          this.set(row2, i, temp);
        }
        return this;
      }
      getColumn(index) {
        checkColumnIndex(this, index);
        let column = [];
        for (let i = 0; i < this.rows; i++) {
          column.push(this.get(i, index));
        }
        return column;
      }
      getColumnVector(index) {
        return Matrix.columnVector(this.getColumn(index));
      }
      setColumn(index, array) {
        checkColumnIndex(this, index);
        array = checkColumnVector(this, array);
        for (let i = 0; i < this.rows; i++) {
          this.set(i, index, array[i]);
        }
        return this;
      }
      swapColumns(column1, column2) {
        checkColumnIndex(this, column1);
        checkColumnIndex(this, column2);
        for (let i = 0; i < this.rows; i++) {
          let temp = this.get(i, column1);
          this.set(i, column1, this.get(i, column2));
          this.set(i, column2, temp);
        }
        return this;
      }
      addRowVector(vector) {
        vector = checkRowVector(this, vector);
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) + vector[j]);
          }
        }
        return this;
      }
      subRowVector(vector) {
        vector = checkRowVector(this, vector);
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) - vector[j]);
          }
        }
        return this;
      }
      mulRowVector(vector) {
        vector = checkRowVector(this, vector);
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) * vector[j]);
          }
        }
        return this;
      }
      divRowVector(vector) {
        vector = checkRowVector(this, vector);
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) / vector[j]);
          }
        }
        return this;
      }
      addColumnVector(vector) {
        vector = checkColumnVector(this, vector);
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) + vector[i]);
          }
        }
        return this;
      }
      subColumnVector(vector) {
        vector = checkColumnVector(this, vector);
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) - vector[i]);
          }
        }
        return this;
      }
      mulColumnVector(vector) {
        vector = checkColumnVector(this, vector);
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) * vector[i]);
          }
        }
        return this;
      }
      divColumnVector(vector) {
        vector = checkColumnVector(this, vector);
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            this.set(i, j, this.get(i, j) / vector[i]);
          }
        }
        return this;
      }
      mulRow(index, value) {
        checkRowIndex(this, index);
        for (let i = 0; i < this.columns; i++) {
          this.set(index, i, this.get(index, i) * value);
        }
        return this;
      }
      mulColumn(index, value) {
        checkColumnIndex(this, index);
        for (let i = 0; i < this.rows; i++) {
          this.set(i, index, this.get(i, index) * value);
        }
        return this;
      }
      max(by) {
        if (this.isEmpty()) {
          return NaN;
        }
        switch (by) {
          case 'row':
            {
              const max = new Array(this.rows).fill(Number.NEGATIVE_INFINITY);
              for (let row = 0; row < this.rows; row++) {
                for (let column = 0; column < this.columns; column++) {
                  if (this.get(row, column) > max[row]) {
                    max[row] = this.get(row, column);
                  }
                }
              }
              return max;
            }
          case 'column':
            {
              const max = new Array(this.columns).fill(Number.NEGATIVE_INFINITY);
              for (let row = 0; row < this.rows; row++) {
                for (let column = 0; column < this.columns; column++) {
                  if (this.get(row, column) > max[column]) {
                    max[column] = this.get(row, column);
                  }
                }
              }
              return max;
            }
          case undefined:
            {
              let max = this.get(0, 0);
              for (let row = 0; row < this.rows; row++) {
                for (let column = 0; column < this.columns; column++) {
                  if (this.get(row, column) > max) {
                    max = this.get(row, column);
                  }
                }
              }
              return max;
            }
          default:
            throw new Error(`invalid option: ${by}`);
        }
      }
      maxIndex() {
        checkNonEmpty(this);
        let v = this.get(0, 0);
        let idx = [0, 0];
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            if (this.get(i, j) > v) {
              v = this.get(i, j);
              idx[0] = i;
              idx[1] = j;
            }
          }
        }
        return idx;
      }
      min(by) {
        if (this.isEmpty()) {
          return NaN;
        }
        switch (by) {
          case 'row':
            {
              const min = new Array(this.rows).fill(Number.POSITIVE_INFINITY);
              for (let row = 0; row < this.rows; row++) {
                for (let column = 0; column < this.columns; column++) {
                  if (this.get(row, column) < min[row]) {
                    min[row] = this.get(row, column);
                  }
                }
              }
              return min;
            }
          case 'column':
            {
              const min = new Array(this.columns).fill(Number.POSITIVE_INFINITY);
              for (let row = 0; row < this.rows; row++) {
                for (let column = 0; column < this.columns; column++) {
                  if (this.get(row, column) < min[column]) {
                    min[column] = this.get(row, column);
                  }
                }
              }
              return min;
            }
          case undefined:
            {
              let min = this.get(0, 0);
              for (let row = 0; row < this.rows; row++) {
                for (let column = 0; column < this.columns; column++) {
                  if (this.get(row, column) < min) {
                    min = this.get(row, column);
                  }
                }
              }
              return min;
            }
          default:
            throw new Error(`invalid option: ${by}`);
        }
      }
      minIndex() {
        checkNonEmpty(this);
        let v = this.get(0, 0);
        let idx = [0, 0];
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            if (this.get(i, j) < v) {
              v = this.get(i, j);
              idx[0] = i;
              idx[1] = j;
            }
          }
        }
        return idx;
      }
      maxRow(row) {
        checkRowIndex(this, row);
        if (this.isEmpty()) {
          return NaN;
        }
        let v = this.get(row, 0);
        for (let i = 1; i < this.columns; i++) {
          if (this.get(row, i) > v) {
            v = this.get(row, i);
          }
        }
        return v;
      }
      maxRowIndex(row) {
        checkRowIndex(this, row);
        checkNonEmpty(this);
        let v = this.get(row, 0);
        let idx = [row, 0];
        for (let i = 1; i < this.columns; i++) {
          if (this.get(row, i) > v) {
            v = this.get(row, i);
            idx[1] = i;
          }
        }
        return idx;
      }
      minRow(row) {
        checkRowIndex(this, row);
        if (this.isEmpty()) {
          return NaN;
        }
        let v = this.get(row, 0);
        for (let i = 1; i < this.columns; i++) {
          if (this.get(row, i) < v) {
            v = this.get(row, i);
          }
        }
        return v;
      }
      minRowIndex(row) {
        checkRowIndex(this, row);
        checkNonEmpty(this);
        let v = this.get(row, 0);
        let idx = [row, 0];
        for (let i = 1; i < this.columns; i++) {
          if (this.get(row, i) < v) {
            v = this.get(row, i);
            idx[1] = i;
          }
        }
        return idx;
      }
      maxColumn(column) {
        checkColumnIndex(this, column);
        if (this.isEmpty()) {
          return NaN;
        }
        let v = this.get(0, column);
        for (let i = 1; i < this.rows; i++) {
          if (this.get(i, column) > v) {
            v = this.get(i, column);
          }
        }
        return v;
      }
      maxColumnIndex(column) {
        checkColumnIndex(this, column);
        checkNonEmpty(this);
        let v = this.get(0, column);
        let idx = [0, column];
        for (let i = 1; i < this.rows; i++) {
          if (this.get(i, column) > v) {
            v = this.get(i, column);
            idx[0] = i;
          }
        }
        return idx;
      }
      minColumn(column) {
        checkColumnIndex(this, column);
        if (this.isEmpty()) {
          return NaN;
        }
        let v = this.get(0, column);
        for (let i = 1; i < this.rows; i++) {
          if (this.get(i, column) < v) {
            v = this.get(i, column);
          }
        }
        return v;
      }
      minColumnIndex(column) {
        checkColumnIndex(this, column);
        checkNonEmpty(this);
        let v = this.get(0, column);
        let idx = [0, column];
        for (let i = 1; i < this.rows; i++) {
          if (this.get(i, column) < v) {
            v = this.get(i, column);
            idx[0] = i;
          }
        }
        return idx;
      }
      diag() {
        let min = Math.min(this.rows, this.columns);
        let diag = [];
        for (let i = 0; i < min; i++) {
          diag.push(this.get(i, i));
        }
        return diag;
      }
      norm(type = 'frobenius') {
        let result = 0;
        if (type === 'max') {
          return this.max();
        } else if (type === 'frobenius') {
          for (let i = 0; i < this.rows; i++) {
            for (let j = 0; j < this.columns; j++) {
              result = result + this.get(i, j) * this.get(i, j);
            }
          }
          return Math.sqrt(result);
        } else {
          throw new RangeError(`unknown norm type: ${type}`);
        }
      }
      cumulativeSum() {
        let sum = 0;
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            sum += this.get(i, j);
            this.set(i, j, sum);
          }
        }
        return this;
      }
      dot(vector2) {
        if (AbstractMatrix.isMatrix(vector2)) vector2 = vector2.to1DArray();
        let vector1 = this.to1DArray();
        if (vector1.length !== vector2.length) {
          throw new RangeError('vectors do not have the same size');
        }
        let dot = 0;
        for (let i = 0; i < vector1.length; i++) {
          dot += vector1[i] * vector2[i];
        }
        return dot;
      }
      mmul(other) {
        other = Matrix.checkMatrix(other);
        let m = this.rows;
        let n = this.columns;
        let p = other.columns;
        let result = new Matrix(m, p);
        let Bcolj = new Float64Array(n);
        for (let j = 0; j < p; j++) {
          for (let k = 0; k < n; k++) {
            Bcolj[k] = other.get(k, j);
          }
          for (let i = 0; i < m; i++) {
            let s = 0;
            for (let k = 0; k < n; k++) {
              s += this.get(i, k) * Bcolj[k];
            }
            result.set(i, j, s);
          }
        }
        return result;
      }
      strassen2x2(other) {
        other = Matrix.checkMatrix(other);
        let result = new Matrix(2, 2);
        const a11 = this.get(0, 0);
        const b11 = other.get(0, 0);
        const a12 = this.get(0, 1);
        const b12 = other.get(0, 1);
        const a21 = this.get(1, 0);
        const b21 = other.get(1, 0);
        const a22 = this.get(1, 1);
        const b22 = other.get(1, 1);

        // Compute intermediate values.
        const m1 = (a11 + a22) * (b11 + b22);
        const m2 = (a21 + a22) * b11;
        const m3 = a11 * (b12 - b22);
        const m4 = a22 * (b21 - b11);
        const m5 = (a11 + a12) * b22;
        const m6 = (a21 - a11) * (b11 + b12);
        const m7 = (a12 - a22) * (b21 + b22);

        // Combine intermediate values into the output.
        const c00 = m1 + m4 - m5 + m7;
        const c01 = m3 + m5;
        const c10 = m2 + m4;
        const c11 = m1 - m2 + m3 + m6;
        result.set(0, 0, c00);
        result.set(0, 1, c01);
        result.set(1, 0, c10);
        result.set(1, 1, c11);
        return result;
      }
      strassen3x3(other) {
        other = Matrix.checkMatrix(other);
        let result = new Matrix(3, 3);
        const a00 = this.get(0, 0);
        const a01 = this.get(0, 1);
        const a02 = this.get(0, 2);
        const a10 = this.get(1, 0);
        const a11 = this.get(1, 1);
        const a12 = this.get(1, 2);
        const a20 = this.get(2, 0);
        const a21 = this.get(2, 1);
        const a22 = this.get(2, 2);
        const b00 = other.get(0, 0);
        const b01 = other.get(0, 1);
        const b02 = other.get(0, 2);
        const b10 = other.get(1, 0);
        const b11 = other.get(1, 1);
        const b12 = other.get(1, 2);
        const b20 = other.get(2, 0);
        const b21 = other.get(2, 1);
        const b22 = other.get(2, 2);
        const m1 = (a00 + a01 + a02 - a10 - a11 - a21 - a22) * b11;
        const m2 = (a00 - a10) * (-b01 + b11);
        const m3 = a11 * (-b00 + b01 + b10 - b11 - b12 - b20 + b22);
        const m4 = (-a00 + a10 + a11) * (b00 - b01 + b11);
        const m5 = (a10 + a11) * (-b00 + b01);
        const m6 = a00 * b00;
        const m7 = (-a00 + a20 + a21) * (b00 - b02 + b12);
        const m8 = (-a00 + a20) * (b02 - b12);
        const m9 = (a20 + a21) * (-b00 + b02);
        const m10 = (a00 + a01 + a02 - a11 - a12 - a20 - a21) * b12;
        const m11 = a21 * (-b00 + b02 + b10 - b11 - b12 - b20 + b21);
        const m12 = (-a02 + a21 + a22) * (b11 + b20 - b21);
        const m13 = (a02 - a22) * (b11 - b21);
        const m14 = a02 * b20;
        const m15 = (a21 + a22) * (-b20 + b21);
        const m16 = (-a02 + a11 + a12) * (b12 + b20 - b22);
        const m17 = (a02 - a12) * (b12 - b22);
        const m18 = (a11 + a12) * (-b20 + b22);
        const m19 = a01 * b10;
        const m20 = a12 * b21;
        const m21 = a10 * b02;
        const m22 = a20 * b01;
        const m23 = a22 * b22;
        const c00 = m6 + m14 + m19;
        const c01 = m1 + m4 + m5 + m6 + m12 + m14 + m15;
        const c02 = m6 + m7 + m9 + m10 + m14 + m16 + m18;
        const c10 = m2 + m3 + m4 + m6 + m14 + m16 + m17;
        const c11 = m2 + m4 + m5 + m6 + m20;
        const c12 = m14 + m16 + m17 + m18 + m21;
        const c20 = m6 + m7 + m8 + m11 + m12 + m13 + m14;
        const c21 = m12 + m13 + m14 + m15 + m22;
        const c22 = m6 + m7 + m8 + m9 + m23;
        result.set(0, 0, c00);
        result.set(0, 1, c01);
        result.set(0, 2, c02);
        result.set(1, 0, c10);
        result.set(1, 1, c11);
        result.set(1, 2, c12);
        result.set(2, 0, c20);
        result.set(2, 1, c21);
        result.set(2, 2, c22);
        return result;
      }
      mmulStrassen(y) {
        y = Matrix.checkMatrix(y);
        let x = this.clone();
        let r1 = x.rows;
        let c1 = x.columns;
        let r2 = y.rows;
        let c2 = y.columns;
        if (c1 !== r2) {
          // eslint-disable-next-line no-console
          console.warn(`Multiplying ${r1} x ${c1} and ${r2} x ${c2} matrix: dimensions do not match.`);
        }

        // Put a matrix into the top left of a matrix of zeros.
        // `rows` and `cols` are the dimensions of the output matrix.
        function embed(mat, rows, cols) {
          let r = mat.rows;
          let c = mat.columns;
          if (r === rows && c === cols) {
            return mat;
          } else {
            let resultat = AbstractMatrix.zeros(rows, cols);
            resultat = resultat.setSubMatrix(mat, 0, 0);
            return resultat;
          }
        }

        // Make sure both matrices are the same size.
        // This is exclusively for simplicity:
        // this algorithm can be implemented with matrices of different sizes.

        let r = Math.max(r1, r2);
        let c = Math.max(c1, c2);
        x = embed(x, r, c);
        y = embed(y, r, c);

        // Our recursive multiplication function.
        function blockMult(a, b, rows, cols) {
          // For small matrices, resort to naive multiplication.
          if (rows <= 512 || cols <= 512) {
            return a.mmul(b); // a is equivalent to this
          }

          // Apply dynamic padding.
          if (rows % 2 === 1 && cols % 2 === 1) {
            a = embed(a, rows + 1, cols + 1);
            b = embed(b, rows + 1, cols + 1);
          } else if (rows % 2 === 1) {
            a = embed(a, rows + 1, cols);
            b = embed(b, rows + 1, cols);
          } else if (cols % 2 === 1) {
            a = embed(a, rows, cols + 1);
            b = embed(b, rows, cols + 1);
          }
          let halfRows = parseInt(a.rows / 2, 10);
          let halfCols = parseInt(a.columns / 2, 10);
          // Subdivide input matrices.
          let a11 = a.subMatrix(0, halfRows - 1, 0, halfCols - 1);
          let b11 = b.subMatrix(0, halfRows - 1, 0, halfCols - 1);
          let a12 = a.subMatrix(0, halfRows - 1, halfCols, a.columns - 1);
          let b12 = b.subMatrix(0, halfRows - 1, halfCols, b.columns - 1);
          let a21 = a.subMatrix(halfRows, a.rows - 1, 0, halfCols - 1);
          let b21 = b.subMatrix(halfRows, b.rows - 1, 0, halfCols - 1);
          let a22 = a.subMatrix(halfRows, a.rows - 1, halfCols, a.columns - 1);
          let b22 = b.subMatrix(halfRows, b.rows - 1, halfCols, b.columns - 1);

          // Compute intermediate values.
          let m1 = blockMult(AbstractMatrix.add(a11, a22), AbstractMatrix.add(b11, b22), halfRows, halfCols);
          let m2 = blockMult(AbstractMatrix.add(a21, a22), b11, halfRows, halfCols);
          let m3 = blockMult(a11, AbstractMatrix.sub(b12, b22), halfRows, halfCols);
          let m4 = blockMult(a22, AbstractMatrix.sub(b21, b11), halfRows, halfCols);
          let m5 = blockMult(AbstractMatrix.add(a11, a12), b22, halfRows, halfCols);
          let m6 = blockMult(AbstractMatrix.sub(a21, a11), AbstractMatrix.add(b11, b12), halfRows, halfCols);
          let m7 = blockMult(AbstractMatrix.sub(a12, a22), AbstractMatrix.add(b21, b22), halfRows, halfCols);

          // Combine intermediate values into the output.
          let c11 = AbstractMatrix.add(m1, m4);
          c11.sub(m5);
          c11.add(m7);
          let c12 = AbstractMatrix.add(m3, m5);
          let c21 = AbstractMatrix.add(m2, m4);
          let c22 = AbstractMatrix.sub(m1, m2);
          c22.add(m3);
          c22.add(m6);

          // Crop output to the desired size (undo dynamic padding).
          let resultat = AbstractMatrix.zeros(2 * c11.rows, 2 * c11.columns);
          resultat = resultat.setSubMatrix(c11, 0, 0);
          resultat = resultat.setSubMatrix(c12, c11.rows, 0);
          resultat = resultat.setSubMatrix(c21, 0, c11.columns);
          resultat = resultat.setSubMatrix(c22, c11.rows, c11.columns);
          return resultat.subMatrix(0, rows - 1, 0, cols - 1);
        }
        return blockMult(x, y, r, c);
      }
      scaleRows(options = {}) {
        if (typeof options !== 'object') {
          throw new TypeError('options must be an object');
        }
        const {
          min = 0,
          max = 1
        } = options;
        if (!Number.isFinite(min)) throw new TypeError('min must be a number');
        if (!Number.isFinite(max)) throw new TypeError('max must be a number');
        if (min >= max) throw new RangeError('min must be smaller than max');
        let newMatrix = new Matrix(this.rows, this.columns);
        for (let i = 0; i < this.rows; i++) {
          const row = this.getRow(i);
          if (row.length > 0) {
            rescale$1(row, {
              min,
              max,
              output: row
            });
          }
          newMatrix.setRow(i, row);
        }
        return newMatrix;
      }
      scaleColumns(options = {}) {
        if (typeof options !== 'object') {
          throw new TypeError('options must be an object');
        }
        const {
          min = 0,
          max = 1
        } = options;
        if (!Number.isFinite(min)) throw new TypeError('min must be a number');
        if (!Number.isFinite(max)) throw new TypeError('max must be a number');
        if (min >= max) throw new RangeError('min must be smaller than max');
        let newMatrix = new Matrix(this.rows, this.columns);
        for (let i = 0; i < this.columns; i++) {
          const column = this.getColumn(i);
          if (column.length) {
            rescale$1(column, {
              min: min,
              max: max,
              output: column
            });
          }
          newMatrix.setColumn(i, column);
        }
        return newMatrix;
      }
      flipRows() {
        const middle = Math.ceil(this.columns / 2);
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < middle; j++) {
            let first = this.get(i, j);
            let last = this.get(i, this.columns - 1 - j);
            this.set(i, j, last);
            this.set(i, this.columns - 1 - j, first);
          }
        }
        return this;
      }
      flipColumns() {
        const middle = Math.ceil(this.rows / 2);
        for (let j = 0; j < this.columns; j++) {
          for (let i = 0; i < middle; i++) {
            let first = this.get(i, j);
            let last = this.get(this.rows - 1 - i, j);
            this.set(i, j, last);
            this.set(this.rows - 1 - i, j, first);
          }
        }
        return this;
      }
      kroneckerProduct(other) {
        other = Matrix.checkMatrix(other);
        let m = this.rows;
        let n = this.columns;
        let p = other.rows;
        let q = other.columns;
        let result = new Matrix(m * p, n * q);
        for (let i = 0; i < m; i++) {
          for (let j = 0; j < n; j++) {
            for (let k = 0; k < p; k++) {
              for (let l = 0; l < q; l++) {
                result.set(p * i + k, q * j + l, this.get(i, j) * other.get(k, l));
              }
            }
          }
        }
        return result;
      }
      kroneckerSum(other) {
        other = Matrix.checkMatrix(other);
        if (!this.isSquare() || !other.isSquare()) {
          throw new Error('Kronecker Sum needs two Square Matrices');
        }
        let m = this.rows;
        let n = other.rows;
        let AxI = this.kroneckerProduct(Matrix.eye(n, n));
        let IxB = Matrix.eye(m, m).kroneckerProduct(other);
        return AxI.add(IxB);
      }
      transpose() {
        let result = new Matrix(this.columns, this.rows);
        for (let i = 0; i < this.rows; i++) {
          for (let j = 0; j < this.columns; j++) {
            result.set(j, i, this.get(i, j));
          }
        }
        return result;
      }
      sortRows(compareFunction = compareNumbers) {
        for (let i = 0; i < this.rows; i++) {
          this.setRow(i, this.getRow(i).sort(compareFunction));
        }
        return this;
      }
      sortColumns(compareFunction = compareNumbers) {
        for (let i = 0; i < this.columns; i++) {
          this.setColumn(i, this.getColumn(i).sort(compareFunction));
        }
        return this;
      }
      subMatrix(startRow, endRow, startColumn, endColumn) {
        checkRange$1(this, startRow, endRow, startColumn, endColumn);
        let newMatrix = new Matrix(endRow - startRow + 1, endColumn - startColumn + 1);
        for (let i = startRow; i <= endRow; i++) {
          for (let j = startColumn; j <= endColumn; j++) {
            newMatrix.set(i - startRow, j - startColumn, this.get(i, j));
          }
        }
        return newMatrix;
      }
      subMatrixRow(indices, startColumn, endColumn) {
        if (startColumn === undefined) startColumn = 0;
        if (endColumn === undefined) endColumn = this.columns - 1;
        if (startColumn > endColumn || startColumn < 0 || startColumn >= this.columns || endColumn < 0 || endColumn >= this.columns) {
          throw new RangeError('Argument out of range');
        }
        let newMatrix = new Matrix(indices.length, endColumn - startColumn + 1);
        for (let i = 0; i < indices.length; i++) {
          for (let j = startColumn; j <= endColumn; j++) {
            if (indices[i] < 0 || indices[i] >= this.rows) {
              throw new RangeError(`Row index out of range: ${indices[i]}`);
            }
            newMatrix.set(i, j - startColumn, this.get(indices[i], j));
          }
        }
        return newMatrix;
      }
      subMatrixColumn(indices, startRow, endRow) {
        if (startRow === undefined) startRow = 0;
        if (endRow === undefined) endRow = this.rows - 1;
        if (startRow > endRow || startRow < 0 || startRow >= this.rows || endRow < 0 || endRow >= this.rows) {
          throw new RangeError('Argument out of range');
        }
        let newMatrix = new Matrix(endRow - startRow + 1, indices.length);
        for (let i = 0; i < indices.length; i++) {
          for (let j = startRow; j <= endRow; j++) {
            if (indices[i] < 0 || indices[i] >= this.columns) {
              throw new RangeError(`Column index out of range: ${indices[i]}`);
            }
            newMatrix.set(j - startRow, i, this.get(j, indices[i]));
          }
        }
        return newMatrix;
      }
      setSubMatrix(matrix, startRow, startColumn) {
        matrix = Matrix.checkMatrix(matrix);
        if (matrix.isEmpty()) {
          return this;
        }
        let endRow = startRow + matrix.rows - 1;
        let endColumn = startColumn + matrix.columns - 1;
        checkRange$1(this, startRow, endRow, startColumn, endColumn);
        for (let i = 0; i < matrix.rows; i++) {
          for (let j = 0; j < matrix.columns; j++) {
            this.set(startRow + i, startColumn + j, matrix.get(i, j));
          }
        }
        return this;
      }
      selection(rowIndices, columnIndices) {
        checkRowIndices(this, rowIndices);
        checkColumnIndices(this, columnIndices);
        let newMatrix = new Matrix(rowIndices.length, columnIndices.length);
        for (let i = 0; i < rowIndices.length; i++) {
          let rowIndex = rowIndices[i];
          for (let j = 0; j < columnIndices.length; j++) {
            let columnIndex = columnIndices[j];
            newMatrix.set(i, j, this.get(rowIndex, columnIndex));
          }
        }
        return newMatrix;
      }
      trace() {
        let min = Math.min(this.rows, this.columns);
        let trace = 0;
        for (let i = 0; i < min; i++) {
          trace += this.get(i, i);
        }
        return trace;
      }
      clone() {
        let newMatrix = new Matrix(this.rows, this.columns);
        for (let row = 0; row < this.rows; row++) {
          for (let column = 0; column < this.columns; column++) {
            newMatrix.set(row, column, this.get(row, column));
          }
        }
        return newMatrix;
      }
      sum(by) {
        switch (by) {
          case 'row':
            return sumByRow(this);
          case 'column':
            return sumByColumn(this);
          case undefined:
            return sumAll(this);
          default:
            throw new Error(`invalid option: ${by}`);
        }
      }
      product(by) {
        switch (by) {
          case 'row':
            return productByRow(this);
          case 'column':
            return productByColumn(this);
          case undefined:
            return productAll(this);
          default:
            throw new Error(`invalid option: ${by}`);
        }
      }
      mean(by) {
        const sum = this.sum(by);
        switch (by) {
          case 'row':
            {
              for (let i = 0; i < this.rows; i++) {
                sum[i] /= this.columns;
              }
              return sum;
            }
          case 'column':
            {
              for (let i = 0; i < this.columns; i++) {
                sum[i] /= this.rows;
              }
              return sum;
            }
          case undefined:
            return sum / this.size;
          default:
            throw new Error(`invalid option: ${by}`);
        }
      }
      variance(by, options = {}) {
        if (typeof by === 'object') {
          options = by;
          by = undefined;
        }
        if (typeof options !== 'object') {
          throw new TypeError('options must be an object');
        }
        const {
          unbiased = true,
          mean = this.mean(by)
        } = options;
        if (typeof unbiased !== 'boolean') {
          throw new TypeError('unbiased must be a boolean');
        }
        switch (by) {
          case 'row':
            {
              if (!isAnyArray(mean)) {
                throw new TypeError('mean must be an array');
              }
              return varianceByRow(this, unbiased, mean);
            }
          case 'column':
            {
              if (!isAnyArray(mean)) {
                throw new TypeError('mean must be an array');
              }
              return varianceByColumn(this, unbiased, mean);
            }
          case undefined:
            {
              if (typeof mean !== 'number') {
                throw new TypeError('mean must be a number');
              }
              return varianceAll(this, unbiased, mean);
            }
          default:
            throw new Error(`invalid option: ${by}`);
        }
      }
      standardDeviation(by, options) {
        if (typeof by === 'object') {
          options = by;
          by = undefined;
        }
        const variance = this.variance(by, options);
        if (by === undefined) {
          return Math.sqrt(variance);
        } else {
          for (let i = 0; i < variance.length; i++) {
            variance[i] = Math.sqrt(variance[i]);
          }
          return variance;
        }
      }
      center(by, options = {}) {
        if (typeof by === 'object') {
          options = by;
          by = undefined;
        }
        if (typeof options !== 'object') {
          throw new TypeError('options must be an object');
        }
        const {
          center = this.mean(by)
        } = options;
        switch (by) {
          case 'row':
            {
              if (!isAnyArray(center)) {
                throw new TypeError('center must be an array');
              }
              centerByRow(this, center);
              return this;
            }
          case 'column':
            {
              if (!isAnyArray(center)) {
                throw new TypeError('center must be an array');
              }
              centerByColumn(this, center);
              return this;
            }
          case undefined:
            {
              if (typeof center !== 'number') {
                throw new TypeError('center must be a number');
              }
              centerAll(this, center);
              return this;
            }
          default:
            throw new Error(`invalid option: ${by}`);
        }
      }
      scale(by, options = {}) {
        if (typeof by === 'object') {
          options = by;
          by = undefined;
        }
        if (typeof options !== 'object') {
          throw new TypeError('options must be an object');
        }
        let scale = options.scale;
        switch (by) {
          case 'row':
            {
              if (scale === undefined) {
                scale = getScaleByRow(this);
              } else if (!isAnyArray(scale)) {
                throw new TypeError('scale must be an array');
              }
              scaleByRow(this, scale);
              return this;
            }
          case 'column':
            {
              if (scale === undefined) {
                scale = getScaleByColumn(this);
              } else if (!isAnyArray(scale)) {
                throw new TypeError('scale must be an array');
              }
              scaleByColumn(this, scale);
              return this;
            }
          case undefined:
            {
              if (scale === undefined) {
                scale = getScaleAll(this);
              } else if (typeof scale !== 'number') {
                throw new TypeError('scale must be a number');
              }
              scaleAll(this, scale);
              return this;
            }
          default:
            throw new Error(`invalid option: ${by}`);
        }
      }
      toString(options) {
        return inspectMatrixWithOptions(this, options);
      }
    }
    AbstractMatrix.prototype.klass = 'Matrix';
    if (typeof Symbol !== 'undefined') {
      AbstractMatrix.prototype[Symbol.for('nodejs.util.inspect.custom')] = inspectMatrix;
    }
    function compareNumbers(a, b) {
      return a - b;
    }
    function isArrayOfNumbers(array) {
      return array.every(element => {
        return typeof element === 'number';
      });
    }

    // Synonyms
    AbstractMatrix.random = AbstractMatrix.rand;
    AbstractMatrix.randomInt = AbstractMatrix.randInt;
    AbstractMatrix.diagonal = AbstractMatrix.diag;
    AbstractMatrix.prototype.diagonal = AbstractMatrix.prototype.diag;
    AbstractMatrix.identity = AbstractMatrix.eye;
    AbstractMatrix.prototype.negate = AbstractMatrix.prototype.neg;
    AbstractMatrix.prototype.tensorProduct = AbstractMatrix.prototype.kroneckerProduct;
    class Matrix extends AbstractMatrix {
      constructor(nRows, nColumns) {
        super();
        if (Matrix.isMatrix(nRows)) {
          // eslint-disable-next-line no-constructor-return
          return nRows.clone();
        } else if (Number.isInteger(nRows) && nRows >= 0) {
          // Create an empty matrix
          this.data = [];
          if (Number.isInteger(nColumns) && nColumns >= 0) {
            for (let i = 0; i < nRows; i++) {
              this.data.push(new Float64Array(nColumns));
            }
          } else {
            throw new TypeError('nColumns must be a positive integer');
          }
        } else if (isAnyArray(nRows)) {
          // Copy the values from the 2D array
          const arrayData = nRows;
          nRows = arrayData.length;
          nColumns = nRows ? arrayData[0].length : 0;
          if (typeof nColumns !== 'number') {
            throw new TypeError('Data must be a 2D array with at least one element');
          }
          this.data = [];
          for (let i = 0; i < nRows; i++) {
            if (arrayData[i].length !== nColumns) {
              throw new RangeError('Inconsistent array dimensions');
            }
            if (!isArrayOfNumbers(arrayData[i])) {
              throw new TypeError('Input data contains non-numeric values');
            }
            this.data.push(Float64Array.from(arrayData[i]));
          }
        } else {
          throw new TypeError('First argument must be a positive number or an array');
        }
        this.rows = nRows;
        this.columns = nColumns;
      }
      set(rowIndex, columnIndex, value) {
        this.data[rowIndex][columnIndex] = value;
        return this;
      }
      get(rowIndex, columnIndex) {
        return this.data[rowIndex][columnIndex];
      }
      removeRow(index) {
        checkRowIndex(this, index);
        this.data.splice(index, 1);
        this.rows -= 1;
        return this;
      }
      addRow(index, array) {
        if (array === undefined) {
          array = index;
          index = this.rows;
        }
        checkRowIndex(this, index, true);
        array = Float64Array.from(checkRowVector(this, array));
        this.data.splice(index, 0, array);
        this.rows += 1;
        return this;
      }
      removeColumn(index) {
        checkColumnIndex(this, index);
        for (let i = 0; i < this.rows; i++) {
          const newRow = new Float64Array(this.columns - 1);
          for (let j = 0; j < index; j++) {
            newRow[j] = this.data[i][j];
          }
          for (let j = index + 1; j < this.columns; j++) {
            newRow[j - 1] = this.data[i][j];
          }
          this.data[i] = newRow;
        }
        this.columns -= 1;
        return this;
      }
      addColumn(index, array) {
        if (typeof array === 'undefined') {
          array = index;
          index = this.columns;
        }
        checkColumnIndex(this, index, true);
        array = checkColumnVector(this, array);
        for (let i = 0; i < this.rows; i++) {
          const newRow = new Float64Array(this.columns + 1);
          let j = 0;
          for (; j < index; j++) {
            newRow[j] = this.data[i][j];
          }
          newRow[j++] = array[i];
          for (; j < this.columns + 1; j++) {
            newRow[j] = this.data[i][j - 1];
          }
          this.data[i] = newRow;
        }
        this.columns += 1;
        return this;
      }
    }
    installMathOperations(AbstractMatrix, Matrix);

    class BaseView extends AbstractMatrix {
      constructor(matrix, rows, columns) {
        super();
        this.matrix = matrix;
        this.rows = rows;
        this.columns = columns;
      }
    }

    class MatrixTransposeView extends BaseView {
      constructor(matrix) {
        super(matrix, matrix.columns, matrix.rows);
      }
      set(rowIndex, columnIndex, value) {
        this.matrix.set(columnIndex, rowIndex, value);
        return this;
      }
      get(rowIndex, columnIndex) {
        return this.matrix.get(columnIndex, rowIndex);
      }
    }

    class WrapperMatrix2D extends AbstractMatrix {
      constructor(data) {
        super();
        this.data = data;
        this.rows = data.length;
        this.columns = data[0].length;
      }
      set(rowIndex, columnIndex, value) {
        this.data[rowIndex][columnIndex] = value;
        return this;
      }
      get(rowIndex, columnIndex) {
        return this.data[rowIndex][columnIndex];
      }
    }

    class LuDecomposition {
      constructor(matrix) {
        matrix = WrapperMatrix2D.checkMatrix(matrix);
        let lu = matrix.clone();
        let rows = lu.rows;
        let columns = lu.columns;
        let pivotVector = new Float64Array(rows);
        let pivotSign = 1;
        let i, j, k, p, s, t, v;
        let LUcolj, kmax;
        for (i = 0; i < rows; i++) {
          pivotVector[i] = i;
        }
        LUcolj = new Float64Array(rows);
        for (j = 0; j < columns; j++) {
          for (i = 0; i < rows; i++) {
            LUcolj[i] = lu.get(i, j);
          }
          for (i = 0; i < rows; i++) {
            kmax = Math.min(i, j);
            s = 0;
            for (k = 0; k < kmax; k++) {
              s += lu.get(i, k) * LUcolj[k];
            }
            LUcolj[i] -= s;
            lu.set(i, j, LUcolj[i]);
          }
          p = j;
          for (i = j + 1; i < rows; i++) {
            if (Math.abs(LUcolj[i]) > Math.abs(LUcolj[p])) {
              p = i;
            }
          }
          if (p !== j) {
            for (k = 0; k < columns; k++) {
              t = lu.get(p, k);
              lu.set(p, k, lu.get(j, k));
              lu.set(j, k, t);
            }
            v = pivotVector[p];
            pivotVector[p] = pivotVector[j];
            pivotVector[j] = v;
            pivotSign = -pivotSign;
          }
          if (j < rows && lu.get(j, j) !== 0) {
            for (i = j + 1; i < rows; i++) {
              lu.set(i, j, lu.get(i, j) / lu.get(j, j));
            }
          }
        }
        this.LU = lu;
        this.pivotVector = pivotVector;
        this.pivotSign = pivotSign;
      }
      isSingular() {
        let data = this.LU;
        let col = data.columns;
        for (let j = 0; j < col; j++) {
          if (data.get(j, j) === 0) {
            return true;
          }
        }
        return false;
      }
      solve(value) {
        value = Matrix.checkMatrix(value);
        let lu = this.LU;
        let rows = lu.rows;
        if (rows !== value.rows) {
          throw new Error('Invalid matrix dimensions');
        }
        if (this.isSingular()) {
          throw new Error('LU matrix is singular');
        }
        let count = value.columns;
        let X = value.subMatrixRow(this.pivotVector, 0, count - 1);
        let columns = lu.columns;
        let i, j, k;
        for (k = 0; k < columns; k++) {
          for (i = k + 1; i < columns; i++) {
            for (j = 0; j < count; j++) {
              X.set(i, j, X.get(i, j) - X.get(k, j) * lu.get(i, k));
            }
          }
        }
        for (k = columns - 1; k >= 0; k--) {
          for (j = 0; j < count; j++) {
            X.set(k, j, X.get(k, j) / lu.get(k, k));
          }
          for (i = 0; i < k; i++) {
            for (j = 0; j < count; j++) {
              X.set(i, j, X.get(i, j) - X.get(k, j) * lu.get(i, k));
            }
          }
        }
        return X;
      }
      get determinant() {
        let data = this.LU;
        if (!data.isSquare()) {
          throw new Error('Matrix must be square');
        }
        let determinant = this.pivotSign;
        let col = data.columns;
        for (let j = 0; j < col; j++) {
          determinant *= data.get(j, j);
        }
        return determinant;
      }
      get lowerTriangularMatrix() {
        let data = this.LU;
        let rows = data.rows;
        let columns = data.columns;
        let X = new Matrix(rows, columns);
        for (let i = 0; i < rows; i++) {
          for (let j = 0; j < columns; j++) {
            if (i > j) {
              X.set(i, j, data.get(i, j));
            } else if (i === j) {
              X.set(i, j, 1);
            } else {
              X.set(i, j, 0);
            }
          }
        }
        return X;
      }
      get upperTriangularMatrix() {
        let data = this.LU;
        let rows = data.rows;
        let columns = data.columns;
        let X = new Matrix(rows, columns);
        for (let i = 0; i < rows; i++) {
          for (let j = 0; j < columns; j++) {
            if (i <= j) {
              X.set(i, j, data.get(i, j));
            } else {
              X.set(i, j, 0);
            }
          }
        }
        return X;
      }
      get pivotPermutationVector() {
        return Array.from(this.pivotVector);
      }
    }

    function hypotenuse(a, b) {
      let r = 0;
      if (Math.abs(a) > Math.abs(b)) {
        r = b / a;
        return Math.abs(a) * Math.sqrt(1 + r * r);
      }
      if (b !== 0) {
        r = a / b;
        return Math.abs(b) * Math.sqrt(1 + r * r);
      }
      return 0;
    }

    class QrDecomposition {
      constructor(value) {
        value = WrapperMatrix2D.checkMatrix(value);
        let qr = value.clone();
        let m = value.rows;
        let n = value.columns;
        let rdiag = new Float64Array(n);
        let i, j, k, s;
        for (k = 0; k < n; k++) {
          let nrm = 0;
          for (i = k; i < m; i++) {
            nrm = hypotenuse(nrm, qr.get(i, k));
          }
          if (nrm !== 0) {
            if (qr.get(k, k) < 0) {
              nrm = -nrm;
            }
            for (i = k; i < m; i++) {
              qr.set(i, k, qr.get(i, k) / nrm);
            }
            qr.set(k, k, qr.get(k, k) + 1);
            for (j = k + 1; j < n; j++) {
              s = 0;
              for (i = k; i < m; i++) {
                s += qr.get(i, k) * qr.get(i, j);
              }
              s = -s / qr.get(k, k);
              for (i = k; i < m; i++) {
                qr.set(i, j, qr.get(i, j) + s * qr.get(i, k));
              }
            }
          }
          rdiag[k] = -nrm;
        }
        this.QR = qr;
        this.Rdiag = rdiag;
      }
      solve(value) {
        value = Matrix.checkMatrix(value);
        let qr = this.QR;
        let m = qr.rows;
        if (value.rows !== m) {
          throw new Error('Matrix row dimensions must agree');
        }
        if (!this.isFullRank()) {
          throw new Error('Matrix is rank deficient');
        }
        let count = value.columns;
        let X = value.clone();
        let n = qr.columns;
        let i, j, k, s;
        for (k = 0; k < n; k++) {
          for (j = 0; j < count; j++) {
            s = 0;
            for (i = k; i < m; i++) {
              s += qr.get(i, k) * X.get(i, j);
            }
            s = -s / qr.get(k, k);
            for (i = k; i < m; i++) {
              X.set(i, j, X.get(i, j) + s * qr.get(i, k));
            }
          }
        }
        for (k = n - 1; k >= 0; k--) {
          for (j = 0; j < count; j++) {
            X.set(k, j, X.get(k, j) / this.Rdiag[k]);
          }
          for (i = 0; i < k; i++) {
            for (j = 0; j < count; j++) {
              X.set(i, j, X.get(i, j) - X.get(k, j) * qr.get(i, k));
            }
          }
        }
        return X.subMatrix(0, n - 1, 0, count - 1);
      }
      isFullRank() {
        let columns = this.QR.columns;
        for (let i = 0; i < columns; i++) {
          if (this.Rdiag[i] === 0) {
            return false;
          }
        }
        return true;
      }
      get upperTriangularMatrix() {
        let qr = this.QR;
        let n = qr.columns;
        let X = new Matrix(n, n);
        let i, j;
        for (i = 0; i < n; i++) {
          for (j = 0; j < n; j++) {
            if (i < j) {
              X.set(i, j, qr.get(i, j));
            } else if (i === j) {
              X.set(i, j, this.Rdiag[i]);
            } else {
              X.set(i, j, 0);
            }
          }
        }
        return X;
      }
      get orthogonalMatrix() {
        let qr = this.QR;
        let rows = qr.rows;
        let columns = qr.columns;
        let X = new Matrix(rows, columns);
        let i, j, k, s;
        for (k = columns - 1; k >= 0; k--) {
          for (i = 0; i < rows; i++) {
            X.set(i, k, 0);
          }
          X.set(k, k, 1);
          for (j = k; j < columns; j++) {
            if (qr.get(k, k) !== 0) {
              s = 0;
              for (i = k; i < rows; i++) {
                s += qr.get(i, k) * X.get(i, j);
              }
              s = -s / qr.get(k, k);
              for (i = k; i < rows; i++) {
                X.set(i, j, X.get(i, j) + s * qr.get(i, k));
              }
            }
          }
        }
        return X;
      }
    }

    class SingularValueDecomposition {
      constructor(value, options = {}) {
        value = WrapperMatrix2D.checkMatrix(value);
        if (value.isEmpty()) {
          throw new Error('Matrix must be non-empty');
        }
        let m = value.rows;
        let n = value.columns;
        const {
          computeLeftSingularVectors = true,
          computeRightSingularVectors = true,
          autoTranspose = false
        } = options;
        let wantu = Boolean(computeLeftSingularVectors);
        let wantv = Boolean(computeRightSingularVectors);
        let swapped = false;
        let a;
        if (m < n) {
          if (!autoTranspose) {
            a = value.clone();
            // eslint-disable-next-line no-console
            console.warn('Computing SVD on a matrix with more columns than rows. Consider enabling autoTranspose');
          } else {
            a = value.transpose();
            m = a.rows;
            n = a.columns;
            swapped = true;
            let aux = wantu;
            wantu = wantv;
            wantv = aux;
          }
        } else {
          a = value.clone();
        }
        let nu = Math.min(m, n);
        let ni = Math.min(m + 1, n);
        let s = new Float64Array(ni);
        let U = new Matrix(m, nu);
        let V = new Matrix(n, n);
        let e = new Float64Array(n);
        let work = new Float64Array(m);
        let si = new Float64Array(ni);
        for (let i = 0; i < ni; i++) si[i] = i;
        let nct = Math.min(m - 1, n);
        let nrt = Math.max(0, Math.min(n - 2, m));
        let mrc = Math.max(nct, nrt);
        for (let k = 0; k < mrc; k++) {
          if (k < nct) {
            s[k] = 0;
            for (let i = k; i < m; i++) {
              s[k] = hypotenuse(s[k], a.get(i, k));
            }
            if (s[k] !== 0) {
              if (a.get(k, k) < 0) {
                s[k] = -s[k];
              }
              for (let i = k; i < m; i++) {
                a.set(i, k, a.get(i, k) / s[k]);
              }
              a.set(k, k, a.get(k, k) + 1);
            }
            s[k] = -s[k];
          }
          for (let j = k + 1; j < n; j++) {
            if (k < nct && s[k] !== 0) {
              let t = 0;
              for (let i = k; i < m; i++) {
                t += a.get(i, k) * a.get(i, j);
              }
              t = -t / a.get(k, k);
              for (let i = k; i < m; i++) {
                a.set(i, j, a.get(i, j) + t * a.get(i, k));
              }
            }
            e[j] = a.get(k, j);
          }
          if (wantu && k < nct) {
            for (let i = k; i < m; i++) {
              U.set(i, k, a.get(i, k));
            }
          }
          if (k < nrt) {
            e[k] = 0;
            for (let i = k + 1; i < n; i++) {
              e[k] = hypotenuse(e[k], e[i]);
            }
            if (e[k] !== 0) {
              if (e[k + 1] < 0) {
                e[k] = 0 - e[k];
              }
              for (let i = k + 1; i < n; i++) {
                e[i] /= e[k];
              }
              e[k + 1] += 1;
            }
            e[k] = -e[k];
            if (k + 1 < m && e[k] !== 0) {
              for (let i = k + 1; i < m; i++) {
                work[i] = 0;
              }
              for (let i = k + 1; i < m; i++) {
                for (let j = k + 1; j < n; j++) {
                  work[i] += e[j] * a.get(i, j);
                }
              }
              for (let j = k + 1; j < n; j++) {
                let t = -e[j] / e[k + 1];
                for (let i = k + 1; i < m; i++) {
                  a.set(i, j, a.get(i, j) + t * work[i]);
                }
              }
            }
            if (wantv) {
              for (let i = k + 1; i < n; i++) {
                V.set(i, k, e[i]);
              }
            }
          }
        }
        let p = Math.min(n, m + 1);
        if (nct < n) {
          s[nct] = a.get(nct, nct);
        }
        if (m < p) {
          s[p - 1] = 0;
        }
        if (nrt + 1 < p) {
          e[nrt] = a.get(nrt, p - 1);
        }
        e[p - 1] = 0;
        if (wantu) {
          for (let j = nct; j < nu; j++) {
            for (let i = 0; i < m; i++) {
              U.set(i, j, 0);
            }
            U.set(j, j, 1);
          }
          for (let k = nct - 1; k >= 0; k--) {
            if (s[k] !== 0) {
              for (let j = k + 1; j < nu; j++) {
                let t = 0;
                for (let i = k; i < m; i++) {
                  t += U.get(i, k) * U.get(i, j);
                }
                t = -t / U.get(k, k);
                for (let i = k; i < m; i++) {
                  U.set(i, j, U.get(i, j) + t * U.get(i, k));
                }
              }
              for (let i = k; i < m; i++) {
                U.set(i, k, -U.get(i, k));
              }
              U.set(k, k, 1 + U.get(k, k));
              for (let i = 0; i < k - 1; i++) {
                U.set(i, k, 0);
              }
            } else {
              for (let i = 0; i < m; i++) {
                U.set(i, k, 0);
              }
              U.set(k, k, 1);
            }
          }
        }
        if (wantv) {
          for (let k = n - 1; k >= 0; k--) {
            if (k < nrt && e[k] !== 0) {
              for (let j = k + 1; j < n; j++) {
                let t = 0;
                for (let i = k + 1; i < n; i++) {
                  t += V.get(i, k) * V.get(i, j);
                }
                t = -t / V.get(k + 1, k);
                for (let i = k + 1; i < n; i++) {
                  V.set(i, j, V.get(i, j) + t * V.get(i, k));
                }
              }
            }
            for (let i = 0; i < n; i++) {
              V.set(i, k, 0);
            }
            V.set(k, k, 1);
          }
        }
        let pp = p - 1;
        let eps = Number.EPSILON;
        while (p > 0) {
          let k, kase;
          for (k = p - 2; k >= -1; k--) {
            if (k === -1) {
              break;
            }
            const alpha = Number.MIN_VALUE + eps * Math.abs(s[k] + Math.abs(s[k + 1]));
            if (Math.abs(e[k]) <= alpha || Number.isNaN(e[k])) {
              e[k] = 0;
              break;
            }
          }
          if (k === p - 2) {
            kase = 4;
          } else {
            let ks;
            for (ks = p - 1; ks >= k; ks--) {
              if (ks === k) {
                break;
              }
              let t = (ks !== p ? Math.abs(e[ks]) : 0) + (ks !== k + 1 ? Math.abs(e[ks - 1]) : 0);
              if (Math.abs(s[ks]) <= eps * t) {
                s[ks] = 0;
                break;
              }
            }
            if (ks === k) {
              kase = 3;
            } else if (ks === p - 1) {
              kase = 1;
            } else {
              kase = 2;
              k = ks;
            }
          }
          k++;
          switch (kase) {
            case 1:
              {
                let f = e[p - 2];
                e[p - 2] = 0;
                for (let j = p - 2; j >= k; j--) {
                  let t = hypotenuse(s[j], f);
                  let cs = s[j] / t;
                  let sn = f / t;
                  s[j] = t;
                  if (j !== k) {
                    f = -sn * e[j - 1];
                    e[j - 1] = cs * e[j - 1];
                  }
                  if (wantv) {
                    for (let i = 0; i < n; i++) {
                      t = cs * V.get(i, j) + sn * V.get(i, p - 1);
                      V.set(i, p - 1, -sn * V.get(i, j) + cs * V.get(i, p - 1));
                      V.set(i, j, t);
                    }
                  }
                }
                break;
              }
            case 2:
              {
                let f = e[k - 1];
                e[k - 1] = 0;
                for (let j = k; j < p; j++) {
                  let t = hypotenuse(s[j], f);
                  let cs = s[j] / t;
                  let sn = f / t;
                  s[j] = t;
                  f = -sn * e[j];
                  e[j] = cs * e[j];
                  if (wantu) {
                    for (let i = 0; i < m; i++) {
                      t = cs * U.get(i, j) + sn * U.get(i, k - 1);
                      U.set(i, k - 1, -sn * U.get(i, j) + cs * U.get(i, k - 1));
                      U.set(i, j, t);
                    }
                  }
                }
                break;
              }
            case 3:
              {
                const scale = Math.max(Math.abs(s[p - 1]), Math.abs(s[p - 2]), Math.abs(e[p - 2]), Math.abs(s[k]), Math.abs(e[k]));
                const sp = s[p - 1] / scale;
                const spm1 = s[p - 2] / scale;
                const epm1 = e[p - 2] / scale;
                const sk = s[k] / scale;
                const ek = e[k] / scale;
                const b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2;
                const c = sp * epm1 * (sp * epm1);
                let shift = 0;
                if (b !== 0 || c !== 0) {
                  if (b < 0) {
                    shift = 0 - Math.sqrt(b * b + c);
                  } else {
                    shift = Math.sqrt(b * b + c);
                  }
                  shift = c / (b + shift);
                }
                let f = (sk + sp) * (sk - sp) + shift;
                let g = sk * ek;
                for (let j = k; j < p - 1; j++) {
                  let t = hypotenuse(f, g);
                  if (t === 0) t = Number.MIN_VALUE;
                  let cs = f / t;
                  let sn = g / t;
                  if (j !== k) {
                    e[j - 1] = t;
                  }
                  f = cs * s[j] + sn * e[j];
                  e[j] = cs * e[j] - sn * s[j];
                  g = sn * s[j + 1];
                  s[j + 1] = cs * s[j + 1];
                  if (wantv) {
                    for (let i = 0; i < n; i++) {
                      t = cs * V.get(i, j) + sn * V.get(i, j + 1);
                      V.set(i, j + 1, -sn * V.get(i, j) + cs * V.get(i, j + 1));
                      V.set(i, j, t);
                    }
                  }
                  t = hypotenuse(f, g);
                  if (t === 0) t = Number.MIN_VALUE;
                  cs = f / t;
                  sn = g / t;
                  s[j] = t;
                  f = cs * e[j] + sn * s[j + 1];
                  s[j + 1] = -sn * e[j] + cs * s[j + 1];
                  g = sn * e[j + 1];
                  e[j + 1] = cs * e[j + 1];
                  if (wantu && j < m - 1) {
                    for (let i = 0; i < m; i++) {
                      t = cs * U.get(i, j) + sn * U.get(i, j + 1);
                      U.set(i, j + 1, -sn * U.get(i, j) + cs * U.get(i, j + 1));
                      U.set(i, j, t);
                    }
                  }
                }
                e[p - 2] = f;
                break;
              }
            case 4:
              {
                if (s[k] <= 0) {
                  s[k] = s[k] < 0 ? -s[k] : 0;
                  if (wantv) {
                    for (let i = 0; i <= pp; i++) {
                      V.set(i, k, -V.get(i, k));
                    }
                  }
                }
                while (k < pp) {
                  if (s[k] >= s[k + 1]) {
                    break;
                  }
                  let t = s[k];
                  s[k] = s[k + 1];
                  s[k + 1] = t;
                  if (wantv && k < n - 1) {
                    for (let i = 0; i < n; i++) {
                      t = V.get(i, k + 1);
                      V.set(i, k + 1, V.get(i, k));
                      V.set(i, k, t);
                    }
                  }
                  if (wantu && k < m - 1) {
                    for (let i = 0; i < m; i++) {
                      t = U.get(i, k + 1);
                      U.set(i, k + 1, U.get(i, k));
                      U.set(i, k, t);
                    }
                  }
                  k++;
                }
                p--;
                break;
              }
            // no default
          }
        }

        if (swapped) {
          let tmp = V;
          V = U;
          U = tmp;
        }
        this.m = m;
        this.n = n;
        this.s = s;
        this.U = U;
        this.V = V;
      }
      solve(value) {
        let Y = value;
        let e = this.threshold;
        let scols = this.s.length;
        let Ls = Matrix.zeros(scols, scols);
        for (let i = 0; i < scols; i++) {
          if (Math.abs(this.s[i]) <= e) {
            Ls.set(i, i, 0);
          } else {
            Ls.set(i, i, 1 / this.s[i]);
          }
        }
        let U = this.U;
        let V = this.rightSingularVectors;
        let VL = V.mmul(Ls);
        let vrows = V.rows;
        let urows = U.rows;
        let VLU = Matrix.zeros(vrows, urows);
        for (let i = 0; i < vrows; i++) {
          for (let j = 0; j < urows; j++) {
            let sum = 0;
            for (let k = 0; k < scols; k++) {
              sum += VL.get(i, k) * U.get(j, k);
            }
            VLU.set(i, j, sum);
          }
        }
        return VLU.mmul(Y);
      }
      solveForDiagonal(value) {
        return this.solve(Matrix.diag(value));
      }
      inverse() {
        let V = this.V;
        let e = this.threshold;
        let vrows = V.rows;
        let vcols = V.columns;
        let X = new Matrix(vrows, this.s.length);
        for (let i = 0; i < vrows; i++) {
          for (let j = 0; j < vcols; j++) {
            if (Math.abs(this.s[j]) > e) {
              X.set(i, j, V.get(i, j) / this.s[j]);
            }
          }
        }
        let U = this.U;
        let urows = U.rows;
        let ucols = U.columns;
        let Y = new Matrix(vrows, urows);
        for (let i = 0; i < vrows; i++) {
          for (let j = 0; j < urows; j++) {
            let sum = 0;
            for (let k = 0; k < ucols; k++) {
              sum += X.get(i, k) * U.get(j, k);
            }
            Y.set(i, j, sum);
          }
        }
        return Y;
      }
      get condition() {
        return this.s[0] / this.s[Math.min(this.m, this.n) - 1];
      }
      get norm2() {
        return this.s[0];
      }
      get rank() {
        let tol = Math.max(this.m, this.n) * this.s[0] * Number.EPSILON;
        let r = 0;
        let s = this.s;
        for (let i = 0, ii = s.length; i < ii; i++) {
          if (s[i] > tol) {
            r++;
          }
        }
        return r;
      }
      get diagonal() {
        return Array.from(this.s);
      }
      get threshold() {
        return Number.EPSILON / 2 * Math.max(this.m, this.n) * this.s[0];
      }
      get leftSingularVectors() {
        return this.U;
      }
      get rightSingularVectors() {
        return this.V;
      }
      get diagonalMatrix() {
        return Matrix.diag(this.s);
      }
    }

    function inverse(matrix, useSVD = false) {
      matrix = WrapperMatrix2D.checkMatrix(matrix);
      if (useSVD) {
        return new SingularValueDecomposition(matrix).inverse();
      } else {
        return solve(matrix, Matrix.eye(matrix.rows));
      }
    }
    function solve(leftHandSide, rightHandSide, useSVD = false) {
      leftHandSide = WrapperMatrix2D.checkMatrix(leftHandSide);
      rightHandSide = WrapperMatrix2D.checkMatrix(rightHandSide);
      if (useSVD) {
        return new SingularValueDecomposition(leftHandSide).solve(rightHandSide);
      } else {
        return leftHandSide.isSquare() ? new LuDecomposition(leftHandSide).solve(rightHandSide) : new QrDecomposition(leftHandSide).solve(rightHandSide);
      }
    }

    class EigenvalueDecomposition {
      constructor(matrix, options = {}) {
        const {
          assumeSymmetric = false
        } = options;
        matrix = WrapperMatrix2D.checkMatrix(matrix);
        if (!matrix.isSquare()) {
          throw new Error('Matrix is not a square matrix');
        }
        if (matrix.isEmpty()) {
          throw new Error('Matrix must be non-empty');
        }
        let n = matrix.columns;
        let V = new Matrix(n, n);
        let d = new Float64Array(n);
        let e = new Float64Array(n);
        let value = matrix;
        let i, j;
        let isSymmetric = false;
        if (assumeSymmetric) {
          isSymmetric = true;
        } else {
          isSymmetric = matrix.isSymmetric();
        }
        if (isSymmetric) {
          for (i = 0; i < n; i++) {
            for (j = 0; j < n; j++) {
              V.set(i, j, value.get(i, j));
            }
          }
          tred2(n, e, d, V);
          tql2(n, e, d, V);
        } else {
          let H = new Matrix(n, n);
          let ort = new Float64Array(n);
          for (j = 0; j < n; j++) {
            for (i = 0; i < n; i++) {
              H.set(i, j, value.get(i, j));
            }
          }
          orthes(n, H, ort, V);
          hqr2(n, e, d, V, H);
        }
        this.n = n;
        this.e = e;
        this.d = d;
        this.V = V;
      }
      get realEigenvalues() {
        return Array.from(this.d);
      }
      get imaginaryEigenvalues() {
        return Array.from(this.e);
      }
      get eigenvectorMatrix() {
        return this.V;
      }
      get diagonalMatrix() {
        let n = this.n;
        let e = this.e;
        let d = this.d;
        let X = new Matrix(n, n);
        let i, j;
        for (i = 0; i < n; i++) {
          for (j = 0; j < n; j++) {
            X.set(i, j, 0);
          }
          X.set(i, i, d[i]);
          if (e[i] > 0) {
            X.set(i, i + 1, e[i]);
          } else if (e[i] < 0) {
            X.set(i, i - 1, e[i]);
          }
        }
        return X;
      }
    }
    function tred2(n, e, d, V) {
      let f, g, h, i, j, k, hh, scale;
      for (j = 0; j < n; j++) {
        d[j] = V.get(n - 1, j);
      }
      for (i = n - 1; i > 0; i--) {
        scale = 0;
        h = 0;
        for (k = 0; k < i; k++) {
          scale = scale + Math.abs(d[k]);
        }
        if (scale === 0) {
          e[i] = d[i - 1];
          for (j = 0; j < i; j++) {
            d[j] = V.get(i - 1, j);
            V.set(i, j, 0);
            V.set(j, i, 0);
          }
        } else {
          for (k = 0; k < i; k++) {
            d[k] /= scale;
            h += d[k] * d[k];
          }
          f = d[i - 1];
          g = Math.sqrt(h);
          if (f > 0) {
            g = -g;
          }
          e[i] = scale * g;
          h = h - f * g;
          d[i - 1] = f - g;
          for (j = 0; j < i; j++) {
            e[j] = 0;
          }
          for (j = 0; j < i; j++) {
            f = d[j];
            V.set(j, i, f);
            g = e[j] + V.get(j, j) * f;
            for (k = j + 1; k <= i - 1; k++) {
              g += V.get(k, j) * d[k];
              e[k] += V.get(k, j) * f;
            }
            e[j] = g;
          }
          f = 0;
          for (j = 0; j < i; j++) {
            e[j] /= h;
            f += e[j] * d[j];
          }
          hh = f / (h + h);
          for (j = 0; j < i; j++) {
            e[j] -= hh * d[j];
          }
          for (j = 0; j < i; j++) {
            f = d[j];
            g = e[j];
            for (k = j; k <= i - 1; k++) {
              V.set(k, j, V.get(k, j) - (f * e[k] + g * d[k]));
            }
            d[j] = V.get(i - 1, j);
            V.set(i, j, 0);
          }
        }
        d[i] = h;
      }
      for (i = 0; i < n - 1; i++) {
        V.set(n - 1, i, V.get(i, i));
        V.set(i, i, 1);
        h = d[i + 1];
        if (h !== 0) {
          for (k = 0; k <= i; k++) {
            d[k] = V.get(k, i + 1) / h;
          }
          for (j = 0; j <= i; j++) {
            g = 0;
            for (k = 0; k <= i; k++) {
              g += V.get(k, i + 1) * V.get(k, j);
            }
            for (k = 0; k <= i; k++) {
              V.set(k, j, V.get(k, j) - g * d[k]);
            }
          }
        }
        for (k = 0; k <= i; k++) {
          V.set(k, i + 1, 0);
        }
      }
      for (j = 0; j < n; j++) {
        d[j] = V.get(n - 1, j);
        V.set(n - 1, j, 0);
      }
      V.set(n - 1, n - 1, 1);
      e[0] = 0;
    }
    function tql2(n, e, d, V) {
      let g, h, i, j, k, l, m, p, r, dl1, c, c2, c3, el1, s, s2;
      for (i = 1; i < n; i++) {
        e[i - 1] = e[i];
      }
      e[n - 1] = 0;
      let f = 0;
      let tst1 = 0;
      let eps = Number.EPSILON;
      for (l = 0; l < n; l++) {
        tst1 = Math.max(tst1, Math.abs(d[l]) + Math.abs(e[l]));
        m = l;
        while (m < n) {
          if (Math.abs(e[m]) <= eps * tst1) {
            break;
          }
          m++;
        }
        if (m > l) {
          do {
            g = d[l];
            p = (d[l + 1] - g) / (2 * e[l]);
            r = hypotenuse(p, 1);
            if (p < 0) {
              r = -r;
            }
            d[l] = e[l] / (p + r);
            d[l + 1] = e[l] * (p + r);
            dl1 = d[l + 1];
            h = g - d[l];
            for (i = l + 2; i < n; i++) {
              d[i] -= h;
            }
            f = f + h;
            p = d[m];
            c = 1;
            c2 = c;
            c3 = c;
            el1 = e[l + 1];
            s = 0;
            s2 = 0;
            for (i = m - 1; i >= l; i--) {
              c3 = c2;
              c2 = c;
              s2 = s;
              g = c * e[i];
              h = c * p;
              r = hypotenuse(p, e[i]);
              e[i + 1] = s * r;
              s = e[i] / r;
              c = p / r;
              p = c * d[i] - s * g;
              d[i + 1] = h + s * (c * g + s * d[i]);
              for (k = 0; k < n; k++) {
                h = V.get(k, i + 1);
                V.set(k, i + 1, s * V.get(k, i) + c * h);
                V.set(k, i, c * V.get(k, i) - s * h);
              }
            }
            p = -s * s2 * c3 * el1 * e[l] / dl1;
            e[l] = s * p;
            d[l] = c * p;
          } while (Math.abs(e[l]) > eps * tst1);
        }
        d[l] = d[l] + f;
        e[l] = 0;
      }
      for (i = 0; i < n - 1; i++) {
        k = i;
        p = d[i];
        for (j = i + 1; j < n; j++) {
          if (d[j] < p) {
            k = j;
            p = d[j];
          }
        }
        if (k !== i) {
          d[k] = d[i];
          d[i] = p;
          for (j = 0; j < n; j++) {
            p = V.get(j, i);
            V.set(j, i, V.get(j, k));
            V.set(j, k, p);
          }
        }
      }
    }
    function orthes(n, H, ort, V) {
      let low = 0;
      let high = n - 1;
      let f, g, h, i, j, m;
      let scale;
      for (m = low + 1; m <= high - 1; m++) {
        scale = 0;
        for (i = m; i <= high; i++) {
          scale = scale + Math.abs(H.get(i, m - 1));
        }
        if (scale !== 0) {
          h = 0;
          for (i = high; i >= m; i--) {
            ort[i] = H.get(i, m - 1) / scale;
            h += ort[i] * ort[i];
          }
          g = Math.sqrt(h);
          if (ort[m] > 0) {
            g = -g;
          }
          h = h - ort[m] * g;
          ort[m] = ort[m] - g;
          for (j = m; j < n; j++) {
            f = 0;
            for (i = high; i >= m; i--) {
              f += ort[i] * H.get(i, j);
            }
            f = f / h;
            for (i = m; i <= high; i++) {
              H.set(i, j, H.get(i, j) - f * ort[i]);
            }
          }
          for (i = 0; i <= high; i++) {
            f = 0;
            for (j = high; j >= m; j--) {
              f += ort[j] * H.get(i, j);
            }
            f = f / h;
            for (j = m; j <= high; j++) {
              H.set(i, j, H.get(i, j) - f * ort[j]);
            }
          }
          ort[m] = scale * ort[m];
          H.set(m, m - 1, scale * g);
        }
      }
      for (i = 0; i < n; i++) {
        for (j = 0; j < n; j++) {
          V.set(i, j, i === j ? 1 : 0);
        }
      }
      for (m = high - 1; m >= low + 1; m--) {
        if (H.get(m, m - 1) !== 0) {
          for (i = m + 1; i <= high; i++) {
            ort[i] = H.get(i, m - 1);
          }
          for (j = m; j <= high; j++) {
            g = 0;
            for (i = m; i <= high; i++) {
              g += ort[i] * V.get(i, j);
            }
            g = g / ort[m] / H.get(m, m - 1);
            for (i = m; i <= high; i++) {
              V.set(i, j, V.get(i, j) + g * ort[i]);
            }
          }
        }
      }
    }
    function hqr2(nn, e, d, V, H) {
      let n = nn - 1;
      let low = 0;
      let high = nn - 1;
      let eps = Number.EPSILON;
      let exshift = 0;
      let norm = 0;
      let p = 0;
      let q = 0;
      let r = 0;
      let s = 0;
      let z = 0;
      let iter = 0;
      let i, j, k, l, m, t, w, x, y;
      let ra, sa, vr, vi;
      let notlast, cdivres;
      for (i = 0; i < nn; i++) {
        if (i < low || i > high) {
          d[i] = H.get(i, i);
          e[i] = 0;
        }
        for (j = Math.max(i - 1, 0); j < nn; j++) {
          norm = norm + Math.abs(H.get(i, j));
        }
      }
      while (n >= low) {
        l = n;
        while (l > low) {
          s = Math.abs(H.get(l - 1, l - 1)) + Math.abs(H.get(l, l));
          if (s === 0) {
            s = norm;
          }
          if (Math.abs(H.get(l, l - 1)) < eps * s) {
            break;
          }
          l--;
        }
        if (l === n) {
          H.set(n, n, H.get(n, n) + exshift);
          d[n] = H.get(n, n);
          e[n] = 0;
          n--;
          iter = 0;
        } else if (l === n - 1) {
          w = H.get(n, n - 1) * H.get(n - 1, n);
          p = (H.get(n - 1, n - 1) - H.get(n, n)) / 2;
          q = p * p + w;
          z = Math.sqrt(Math.abs(q));
          H.set(n, n, H.get(n, n) + exshift);
          H.set(n - 1, n - 1, H.get(n - 1, n - 1) + exshift);
          x = H.get(n, n);
          if (q >= 0) {
            z = p >= 0 ? p + z : p - z;
            d[n - 1] = x + z;
            d[n] = d[n - 1];
            if (z !== 0) {
              d[n] = x - w / z;
            }
            e[n - 1] = 0;
            e[n] = 0;
            x = H.get(n, n - 1);
            s = Math.abs(x) + Math.abs(z);
            p = x / s;
            q = z / s;
            r = Math.sqrt(p * p + q * q);
            p = p / r;
            q = q / r;
            for (j = n - 1; j < nn; j++) {
              z = H.get(n - 1, j);
              H.set(n - 1, j, q * z + p * H.get(n, j));
              H.set(n, j, q * H.get(n, j) - p * z);
            }
            for (i = 0; i <= n; i++) {
              z = H.get(i, n - 1);
              H.set(i, n - 1, q * z + p * H.get(i, n));
              H.set(i, n, q * H.get(i, n) - p * z);
            }
            for (i = low; i <= high; i++) {
              z = V.get(i, n - 1);
              V.set(i, n - 1, q * z + p * V.get(i, n));
              V.set(i, n, q * V.get(i, n) - p * z);
            }
          } else {
            d[n - 1] = x + p;
            d[n] = x + p;
            e[n - 1] = z;
            e[n] = -z;
          }
          n = n - 2;
          iter = 0;
        } else {
          x = H.get(n, n);
          y = 0;
          w = 0;
          if (l < n) {
            y = H.get(n - 1, n - 1);
            w = H.get(n, n - 1) * H.get(n - 1, n);
          }
          if (iter === 10) {
            exshift += x;
            for (i = low; i <= n; i++) {
              H.set(i, i, H.get(i, i) - x);
            }
            s = Math.abs(H.get(n, n - 1)) + Math.abs(H.get(n - 1, n - 2));
            x = y = 0.75 * s;
            w = -0.4375 * s * s;
          }
          if (iter === 30) {
            s = (y - x) / 2;
            s = s * s + w;
            if (s > 0) {
              s = Math.sqrt(s);
              if (y < x) {
                s = -s;
              }
              s = x - w / ((y - x) / 2 + s);
              for (i = low; i <= n; i++) {
                H.set(i, i, H.get(i, i) - s);
              }
              exshift += s;
              x = y = w = 0.964;
            }
          }
          iter = iter + 1;
          m = n - 2;
          while (m >= l) {
            z = H.get(m, m);
            r = x - z;
            s = y - z;
            p = (r * s - w) / H.get(m + 1, m) + H.get(m, m + 1);
            q = H.get(m + 1, m + 1) - z - r - s;
            r = H.get(m + 2, m + 1);
            s = Math.abs(p) + Math.abs(q) + Math.abs(r);
            p = p / s;
            q = q / s;
            r = r / s;
            if (m === l) {
              break;
            }
            if (Math.abs(H.get(m, m - 1)) * (Math.abs(q) + Math.abs(r)) < eps * (Math.abs(p) * (Math.abs(H.get(m - 1, m - 1)) + Math.abs(z) + Math.abs(H.get(m + 1, m + 1))))) {
              break;
            }
            m--;
          }
          for (i = m + 2; i <= n; i++) {
            H.set(i, i - 2, 0);
            if (i > m + 2) {
              H.set(i, i - 3, 0);
            }
          }
          for (k = m; k <= n - 1; k++) {
            notlast = k !== n - 1;
            if (k !== m) {
              p = H.get(k, k - 1);
              q = H.get(k + 1, k - 1);
              r = notlast ? H.get(k + 2, k - 1) : 0;
              x = Math.abs(p) + Math.abs(q) + Math.abs(r);
              if (x !== 0) {
                p = p / x;
                q = q / x;
                r = r / x;
              }
            }
            if (x === 0) {
              break;
            }
            s = Math.sqrt(p * p + q * q + r * r);
            if (p < 0) {
              s = -s;
            }
            if (s !== 0) {
              if (k !== m) {
                H.set(k, k - 1, -s * x);
              } else if (l !== m) {
                H.set(k, k - 1, -H.get(k, k - 1));
              }
              p = p + s;
              x = p / s;
              y = q / s;
              z = r / s;
              q = q / p;
              r = r / p;
              for (j = k; j < nn; j++) {
                p = H.get(k, j) + q * H.get(k + 1, j);
                if (notlast) {
                  p = p + r * H.get(k + 2, j);
                  H.set(k + 2, j, H.get(k + 2, j) - p * z);
                }
                H.set(k, j, H.get(k, j) - p * x);
                H.set(k + 1, j, H.get(k + 1, j) - p * y);
              }
              for (i = 0; i <= Math.min(n, k + 3); i++) {
                p = x * H.get(i, k) + y * H.get(i, k + 1);
                if (notlast) {
                  p = p + z * H.get(i, k + 2);
                  H.set(i, k + 2, H.get(i, k + 2) - p * r);
                }
                H.set(i, k, H.get(i, k) - p);
                H.set(i, k + 1, H.get(i, k + 1) - p * q);
              }
              for (i = low; i <= high; i++) {
                p = x * V.get(i, k) + y * V.get(i, k + 1);
                if (notlast) {
                  p = p + z * V.get(i, k + 2);
                  V.set(i, k + 2, V.get(i, k + 2) - p * r);
                }
                V.set(i, k, V.get(i, k) - p);
                V.set(i, k + 1, V.get(i, k + 1) - p * q);
              }
            }
          }
        }
      }
      if (norm === 0) {
        return;
      }
      for (n = nn - 1; n >= 0; n--) {
        p = d[n];
        q = e[n];
        if (q === 0) {
          l = n;
          H.set(n, n, 1);
          for (i = n - 1; i >= 0; i--) {
            w = H.get(i, i) - p;
            r = 0;
            for (j = l; j <= n; j++) {
              r = r + H.get(i, j) * H.get(j, n);
            }
            if (e[i] < 0) {
              z = w;
              s = r;
            } else {
              l = i;
              if (e[i] === 0) {
                H.set(i, n, w !== 0 ? -r / w : -r / (eps * norm));
              } else {
                x = H.get(i, i + 1);
                y = H.get(i + 1, i);
                q = (d[i] - p) * (d[i] - p) + e[i] * e[i];
                t = (x * s - z * r) / q;
                H.set(i, n, t);
                H.set(i + 1, n, Math.abs(x) > Math.abs(z) ? (-r - w * t) / x : (-s - y * t) / z);
              }
              t = Math.abs(H.get(i, n));
              if (eps * t * t > 1) {
                for (j = i; j <= n; j++) {
                  H.set(j, n, H.get(j, n) / t);
                }
              }
            }
          }
        } else if (q < 0) {
          l = n - 1;
          if (Math.abs(H.get(n, n - 1)) > Math.abs(H.get(n - 1, n))) {
            H.set(n - 1, n - 1, q / H.get(n, n - 1));
            H.set(n - 1, n, -(H.get(n, n) - p) / H.get(n, n - 1));
          } else {
            cdivres = cdiv(0, -H.get(n - 1, n), H.get(n - 1, n - 1) - p, q);
            H.set(n - 1, n - 1, cdivres[0]);
            H.set(n - 1, n, cdivres[1]);
          }
          H.set(n, n - 1, 0);
          H.set(n, n, 1);
          for (i = n - 2; i >= 0; i--) {
            ra = 0;
            sa = 0;
            for (j = l; j <= n; j++) {
              ra = ra + H.get(i, j) * H.get(j, n - 1);
              sa = sa + H.get(i, j) * H.get(j, n);
            }
            w = H.get(i, i) - p;
            if (e[i] < 0) {
              z = w;
              r = ra;
              s = sa;
            } else {
              l = i;
              if (e[i] === 0) {
                cdivres = cdiv(-ra, -sa, w, q);
                H.set(i, n - 1, cdivres[0]);
                H.set(i, n, cdivres[1]);
              } else {
                x = H.get(i, i + 1);
                y = H.get(i + 1, i);
                vr = (d[i] - p) * (d[i] - p) + e[i] * e[i] - q * q;
                vi = (d[i] - p) * 2 * q;
                if (vr === 0 && vi === 0) {
                  vr = eps * norm * (Math.abs(w) + Math.abs(q) + Math.abs(x) + Math.abs(y) + Math.abs(z));
                }
                cdivres = cdiv(x * r - z * ra + q * sa, x * s - z * sa - q * ra, vr, vi);
                H.set(i, n - 1, cdivres[0]);
                H.set(i, n, cdivres[1]);
                if (Math.abs(x) > Math.abs(z) + Math.abs(q)) {
                  H.set(i + 1, n - 1, (-ra - w * H.get(i, n - 1) + q * H.get(i, n)) / x);
                  H.set(i + 1, n, (-sa - w * H.get(i, n) - q * H.get(i, n - 1)) / x);
                } else {
                  cdivres = cdiv(-r - y * H.get(i, n - 1), -s - y * H.get(i, n), z, q);
                  H.set(i + 1, n - 1, cdivres[0]);
                  H.set(i + 1, n, cdivres[1]);
                }
              }
              t = Math.max(Math.abs(H.get(i, n - 1)), Math.abs(H.get(i, n)));
              if (eps * t * t > 1) {
                for (j = i; j <= n; j++) {
                  H.set(j, n - 1, H.get(j, n - 1) / t);
                  H.set(j, n, H.get(j, n) / t);
                }
              }
            }
          }
        }
      }
      for (i = 0; i < nn; i++) {
        if (i < low || i > high) {
          for (j = i; j < nn; j++) {
            V.set(i, j, H.get(i, j));
          }
        }
      }
      for (j = nn - 1; j >= low; j--) {
        for (i = low; i <= high; i++) {
          z = 0;
          for (k = low; k <= Math.min(j, high); k++) {
            z = z + V.get(i, k) * H.get(k, j);
          }
          V.set(i, j, z);
        }
      }
    }
    function cdiv(xr, xi, yr, yi) {
      let r, d;
      if (Math.abs(yr) > Math.abs(yi)) {
        r = yi / yr;
        d = yr + r * yi;
        return [(xr + r * xi) / d, (xi - r * xr) / d];
      } else {
        r = yr / yi;
        d = yi + r * yr;
        return [(r * xr + xi) / d, (r * xi - xr) / d];
      }
    }

    /**
     * Returns a copy of the data as Float64
     *
     * @param array - array of numbers
     */
    function xEnsureFloat64(array) {
      xCheck(array);
      if (array instanceof Float64Array) {
        return array.slice(0);
      }
      return Float64Array.from(array);
    }

    /**
     * Returns the closest index of a `target`
     *
     * @param array - array of numbers
     * @param target - target
     * @returns - closest index
     */
    function xFindClosestIndex(array, target, options = {}) {
      const {
        sorted = true
      } = options;
      if (sorted) {
        let low = 0;
        let high = array.length - 1;
        let middle = 0;
        while (high - low > 1) {
          middle = low + (high - low >> 1);
          if (array[middle] < target) {
            low = middle;
          } else if (array[middle] > target) {
            high = middle;
          } else {
            return middle;
          }
        }
        if (low < array.length - 1) {
          if (Math.abs(target - array[low]) < Math.abs(array[low + 1] - target)) {
            return low;
          } else {
            return low + 1;
          }
        } else {
          return low;
        }
      } else {
        let index = 0;
        let diff = Number.POSITIVE_INFINITY;
        for (let i = 0; i < array.length; i++) {
          const currentDiff = Math.abs(array[i] - target);
          if (currentDiff < diff) {
            diff = currentDiff;
            index = i;
          }
        }
        return index;
      }
    }

    /**
     * Returns an object with {fromIndex, toIndex} for a specific from / to
     *
     * @param x - array of numbers
     * @param options - Options
     */
    function xGetFromToIndex(x, options = {}) {
      let {
        fromIndex,
        toIndex,
        from,
        to
      } = options;
      if (fromIndex === undefined) {
        if (from !== undefined) {
          fromIndex = xFindClosestIndex(x, from);
        } else {
          fromIndex = 0;
        }
      }
      if (toIndex === undefined) {
        if (to !== undefined) {
          toIndex = xFindClosestIndex(x, to);
        } else {
          toIndex = x.length - 1;
        }
      }
      if (fromIndex < 0) fromIndex = 0;
      if (toIndex < 0) toIndex = 0;
      if (fromIndex >= x.length) fromIndex = x.length - 1;
      if (toIndex >= x.length) toIndex = x.length - 1;
      if (fromIndex > toIndex) [fromIndex, toIndex] = [toIndex, fromIndex];
      return {
        fromIndex,
        toIndex
      };
    }

    /**
     * Computes the maximal value of an array of values
     *
     * @param array - array of numbers
     * @param options - options
     */
    function xMaxValue(array, options = {}) {
      xCheck(array);
      const {
        fromIndex,
        toIndex
      } = xGetFromToIndex(array, options);
      let maxValue = array[fromIndex];
      for (let i = fromIndex + 1; i <= toIndex; i++) {
        if (array[i] > maxValue) {
          maxValue = array[i];
        }
      }
      return maxValue;
    }

    /**
     * Computes the minimal value of an array of values
     *
     * @param array - array of numbers
     * @param options - options
     */
    function xMinValue(array, options = {}) {
      xCheck(array);
      const {
        fromIndex,
        toIndex
      } = xGetFromToIndex(array, options);
      let minValue = array[fromIndex];
      for (let i = fromIndex + 1; i <= toIndex; i++) {
        if (array[i] < minValue) {
          minValue = array[i];
        }
      }
      return minValue;
    }

    /**
     * Check if the values are separated always by the same difference
     *
     * @param array - Monotone growing array of number
     */
    function xIsEquallySpaced(array, options = {}) {
      if (array.length < 3) return true;
      const {
        tolerance = 0.05
      } = options;
      let maxDx = 0;
      let minDx = Number.MAX_SAFE_INTEGER;
      for (let i = 0; i < array.length - 1; ++i) {
        let absoluteDifference = array[i + 1] - array[i];
        if (absoluteDifference < minDx) {
          minDx = absoluteDifference;
        }
        if (absoluteDifference > maxDx) {
          maxDx = absoluteDifference;
        }
      }
      return (maxDx - minDx) / maxDx < tolerance;
    }

    /**
     * Returns true if x is monotone
     *
     * @param array - array of numbers
     */
    function xIsMonotonic(array) {
      if (array.length <= 2) {
        return 1;
      }
      if (array[0] === array[1]) {
        // maybe a constant series
        for (let i = 1; i < array.length - 1; i++) {
          if (array[i] !== array[i + 1]) return 0;
        }
        return 1;
      }
      if (array[0] < array[array.length - 1]) {
        for (let i = 0; i < array.length - 1; i++) {
          if (array[i] >= array[i + 1]) return 0;
        }
        return 1;
      } else {
        for (let i = 0; i < array.length - 1; i++) {
          if (array[i] <= array[i + 1]) return 0;
        }
        return -1;
      }
    }

    /**
     * Computes the mean value of an array of values
     *
     * @param array - array of numbers
     * @param options - options
     */
    function xMean(array, options = {}) {
      xCheck(array);
      const {
        fromIndex,
        toIndex
      } = xGetFromToIndex(array, options);
      let sumValue = array[fromIndex];
      for (let i = fromIndex + 1; i <= toIndex; i++) {
        sumValue += array[i];
      }
      return sumValue / (toIndex - fromIndex + 1);
    }

    /**
     * This function calculates the median absolute deviation (MAD)
     * https://en.wikipedia.org/wiki/Median_absolute_deviation
     * @param array
     */
    function xMedianAbsoluteDeviation(array) {
      const median = xMedian(array);
      const averageDeviations = new Float64Array(array.length);
      for (let i = 0; i < array.length; i++) {
        averageDeviations[i] = Math.abs(array[i] - median);
      }
      return {
        median,
        mad: xMedian(averageDeviations)
      };
    }

    /**
     * Return min and max values of an array
     *
     * @param array - array of number
     * @returns - Object with 2 properties, min and max
     */
    function xMinMaxValues(array) {
      xCheck(array);
      let min = array[0];
      let max = array[0];
      for (let value of array) {
        if (value < min) min = value;
        if (value > max) max = value;
      }
      return {
        min,
        max
      };
    }

    /**
     * Determine noise level using MAD https://en.wikipedia.org/wiki/Median_absolute_deviation
     * Constant to convert mad to sd calculated using https://www.wolframalpha.com/input?i=sqrt%282%29+inverse+erf%280.5%29
     * This assumes a gaussian distribution of the noise
     * @param array
     * @returns noise level corresponding to one standard deviation
     */
    function xNoiseStandardDeviation(array) {
      const {
        mad,
        median
      } = xMedianAbsoluteDeviation(array);
      return {
        sd: mad / 0.6744897501960817,
        mad,
        median
      };
    }

    /**
     * This function calculate the norm of a vector
     *
     * @example xNorm([3, 4]) -> 5
     * @param array - array
     * @returns - calculated norm
     */
    function xNorm(array) {
      let result = 0;
      for (const element of array) {
        result += element ** 2;
      }
      return Math.sqrt(result);
    }

    /**
     * Calculate the sum of the values
     *
     * @param array - Object that contains property x (an ordered increasing array) and y (an array).
     * @param options - Options.
     * @returns XSum value on the specified range.
     */
    function xSum(array, options = {}) {
      xCheck(array);
      const {
        fromIndex,
        toIndex
      } = xGetFromToIndex(array, options);
      let sumValue = array[fromIndex];
      for (let i = fromIndex + 1; i <= toIndex; i++) {
        sumValue += array[i];
      }
      return sumValue;
    }

    /**
     * Divides the data with either the sum, the absolute sum or the maximum of the data
     * @param array - Array containing values
     * @param options - options
     * @returns - normalized data
     */
    function xNormed(input, options = {}) {
      const {
        algorithm = 'absolute',
        value = 1
      } = options;
      xCheck(input);
      const output = getOutputArray(options.output, input.length);
      if (input.length === 0) {
        throw new Error('input must not be empty');
      }
      switch (algorithm.toLowerCase()) {
        case 'absolute':
          {
            let absoluteSumValue = absoluteSum(input) / value;
            if (absoluteSumValue === 0) {
              throw new Error('xNormed: trying to divide by 0');
            }
            for (let i = 0; i < input.length; i++) {
              output[i] = input[i] / absoluteSumValue;
            }
            return output;
          }
        case 'max':
          {
            let currentMaxValue = xMaxValue(input);
            if (currentMaxValue === 0) {
              throw new Error('xNormed: trying to divide by 0');
            }
            const factor = value / currentMaxValue;
            for (let i = 0; i < input.length; i++) {
              output[i] = input[i] * factor;
            }
            return output;
          }
        case 'sum':
          {
            let sumFactor = xSum(input) / value;
            if (sumFactor === 0) {
              throw new Error('xNormed: trying to divide by 0');
            }
            for (let i = 0; i < input.length; i++) {
              output[i] = input[i] / sumFactor;
            }
            return output;
          }
        default:
          throw new Error(`norm: unknown algorithm: ${algorithm}`);
      }
    }
    function absoluteSum(input) {
      let sumValue = 0;
      for (let i = 0; i < input.length; i++) {
        sumValue += Math.abs(input[i]);
      }
      return sumValue;
    }

    /**
     * This function pads an array
     *s
     * @param array - the array that will be padded
     * @param options - options
     */
    function xPadding(array, options = {}) {
      const {
        size = 0,
        value = 0,
        algorithm = ''
      } = options;
      xCheck(array);
      if (!algorithm) {
        if (array instanceof Float64Array) {
          return array.slice();
        } else {
          return Float64Array.from(array);
        }
      }
      let result = new Float64Array(array.length + size * 2);
      for (let i = 0; i < array.length; i++) {
        result[i + size] = array[i];
      }
      let fromEnd = size + array.length;
      let toEnd = 2 * size + array.length;
      switch (algorithm.toLowerCase()) {
        case 'value':
          for (let i = 0; i < size; i++) {
            result[i] = value;
          }
          for (let i = fromEnd; i < toEnd; i++) {
            result[i] = value;
          }
          break;
        case 'duplicate':
          for (let i = 0; i < size; i++) {
            result[i] = array[0];
          }
          for (let i = fromEnd; i < toEnd; i++) {
            result[i] = array[array.length - 1];
          }
          break;
        case 'circular':
          for (let i = 0; i < size; i++) {
            result[i] = array[(array.length - size % array.length + i) % array.length];
          }
          for (let i = 0; i < size; i++) {
            result[i + fromEnd] = array[i % array.length];
          }
          break;
        default:
          throw new Error('xPadding: unknown algorithm');
      }
      return result;
    }

    /** Finds the variance of the data
     *
     * @param values - the values of the array
     * @param options - options
     * @returns variance
     */
    function xVariance(values, options = {}) {
      if (!isAnyArray(values)) {
        throw new TypeError('input must be an array');
      }
      const {
        unbiased = true,
        mean = xMean(values)
      } = options;
      let sqrError = 0;
      for (let i = 0; i < values.length; i++) {
        let x = values[i] - mean;
        sqrError += x * x;
      }
      if (unbiased) {
        return sqrError / (values.length - 1);
      } else {
        return sqrError / values.length;
      }
    }

    /** Finds the standard deviation for the data at hand
     *
     * @param values - values in the data
     * @param options - options
     * @returns standard deviation
     */
    function xStandardDeviation(values, options = {}) {
      return Math.sqrt(xVariance(values, options));
    }

    /**
     * Pareto scaling, which uses the square root of standard deviation as the scaling factor, circumvents the amplification of noise by retaining a small portion of magnitude information.
     * Noda, I. (2008). Scaling techniques to enhance two-dimensional correlation spectra. Journal of Molecular Structure, 883, 216-227.
     * DOI: 10.1016/j.molstruc.2007.12.026
     *
     * @param array - array of number
     */
    function xParetoNormalization(array) {
      xCheck(array);
      let result = [];
      const sqrtSD = Math.sqrt(xStandardDeviation(array));
      for (let item of array) {
        result.push(item / sqrtSD);
      }
      return result;
    }

    /** Function used to rescale data
     *
     * @param input - input for the rescale
     * @param options - options
     * @returns rescaled data
     */
    function xRescale(input, options = {}) {
      xCheck(input);
      const output = getOutputArray(options.output, input.length);
      const currentMin = xMinValue(input);
      const currentMax = xMaxValue(input);
      if (currentMin === currentMax) {
        throw new RangeError('minimum and maximum input values are equal. Cannot rescale a constant array');
      }
      const {
        min = 0,
        max = 1
      } = options;
      if (min >= max) {
        throw new RangeError('min option must be smaller than max option');
      }
      const factor = (max - min) / (currentMax - currentMin);
      for (let i = 0; i < input.length; i++) {
        output[i] = (input[i] - currentMin) * factor + min;
      }
      return output;
    }

    /**
     * This function calculates a rolling average
     *
     * @param array - array
     * @param fct - callback function that from an array returns a value
     * @param options - options
     */
    function xRolling(array, fct, options = {}) {
      xCheck(array);
      if (typeof fct !== 'function') throw new Error('fct has to be a function');
      const {
        window = 5,
        padding = {}
      } = options;
      const {
        size = window - 1,
        algorithm,
        value
      } = padding;
      array = xPadding(array, {
        size,
        algorithm,
        value
      }); // ensure we get a copy and it is float64
      const newArray = [];
      for (let i = 0; i < array.length - window + 1; i++) {
        // we will send a view to the original buffer
        newArray.push(fct(array.subarray(i, i + window)));
      }
      return newArray;
    }

    /**
     * This function calculates a rolling average
     *
     * @param array - array
     * @param options - option
     */
    function xRollingAverage(array, options = {}) {
      return xRolling(array, xMean, options);
    }

    /**
     * This function calculates a rolling average
     *
     * @param array - array
     * @param options - options
     */
    function xRollingMedian(array, options = {}) {
      return xRolling(array, xMedian, options);
    }

    /** Fill an array with sequential numbers
     *
     * @param input - optional destination array (if not provided a new array will be created)
     * @param options - options
     * @return array with sequential numbers
     */
    function xSequentialFill(input = [], options = {}) {
      if (typeof input === 'object' && !isAnyArray(input)) {
        options = input;
        input = [];
      }
      if (!isAnyArray(input)) {
        throw new TypeError('input must be an array');
      }
      // maybe should not specify default step and size
      let {
        from = 0,
        to = 10,
        size = Array.isArray(input) || input.constructor === Float64Array || input.constructor === Uint16Array ? input.length : 0,
        step = null
      } = options;
      if (!size) {
        if (step) {
          size = Math.floor((to - from) / step) + 1;
        } else {
          size = to - from + 1;
        }
      }
      if (!step && size) {
        step = (to - from) / (size - 1);
      }
      if (Array.isArray(input)) {
        // only works with normal array
        input.length = 0;
        for (let i = 0; i < size; i++) {
          input.push(from);
          if (step) from += step;
        }
      } else {
        if (Array.isArray(input) || input.constructor === Float64Array || input.constructor === Uint16Array && input.length !== size) {
          throw new Error('sequentialFill typed array must have the correct length');
        }
        for (let i = 0; i < size; i++) {
          if (Array.isArray(input) || input.constructor === Float64Array || input.constructor === Uint16Array) {
            input[i] = from;
          }
          if (step) {
            from += step;
          }
        }
      }
      return Array.isArray(input) || input.constructor === Float64Array || input.constructor === Uint16Array ? Array.from(input) : [];
    }

    /**
     * This function xSubtract the first array by the second array or a constant value from each element of the first array
     *
     * @param array1 - the array that will be rotated
     * @param array2 - second array or number
     * @returns array after subtraction
     */
    function xSubtract(array1, array2) {
      let isConstant = false;
      let constant = 0;
      if (isAnyArray(array2)) {
        if (array1.length !== array2.length) {
          throw new Error('xSubtract: size of array1 and array2 must be identical');
        }
      } else {
        isConstant = true;
        constant = Number(array2);
      }
      let array3 = new Float64Array(array1.length);
      if (isConstant) {
        for (let i = 0; i < array1.length; i++) {
          array3[i] = array1[i] - constant;
        }
      } else {
        for (let i = 0; i < array1.length; i++) {
          array3[i] = array1[i] - array2[i];
        }
      }
      return array3;
    }

    /**
     * Throw an error in no an object of x,y arrays
     *
     * @param data - array of points {x,y,z}
     */
    function xyCheck(data, options = {}) {
      const {
        minLength
      } = options;
      if (typeof data !== 'object' || !isAnyArray(data.x) || !isAnyArray(data.y)) {
        throw new Error('Data must be an object of x and y arrays');
      }
      if (data.x.length !== data.y.length) {
        throw new Error('The x and y arrays must have the same length');
      }
      if (minLength && data.x.length < minLength) {
        throw new Error(`data.x must have a length of at least ${minLength}`);
      }
    }

    /**
     * Finds the closest point
     *
     * @param data - x array should be sorted and ascending
     * @param target - target to search
     * @returns - closest point
     */
    function xyFindClosestPoint( /** points */
    data, target) {
      const {
        x,
        y
      } = data;
      const index = xFindClosestIndex(x, target);
      return {
        x: x[index],
        y: y[index]
      };
    }

    /**
     * Filters x,y values to allow strictly growing values in x axis.
     *
     * @param data - Object that contains property x (an ordered increasing array) and y (an array).
     */
    function xyEnsureGrowingX(data) {
      xyCheck(data);
      if (xIsMonotonic(data.x) === 1) return data;
      const x = Array.from(data.x);
      const y = Array.from(data.y);
      let prevX = Number.NEGATIVE_INFINITY;
      let currentIndex = 0;
      for (let index = 0; index < x.length; index++) {
        if (prevX < x[index]) {
          if (currentIndex < index) {
            x[currentIndex] = x[index];
            y[currentIndex] = y[index];
          }
          currentIndex++;
          prevX = x[index];
        }
      }
      x.length = currentIndex;
      y.length = currentIndex;
      return {
        x,
        y
      };
    }

    /**
     * Normalize an array of zones:
     * - ensure than from < to
     * - merge overlapping zones
     * - deal with exclusions zones
     * - if no zones is specified add one between -Infinity and +Infinity
     * @param zones - array of zones
     * @param options - options
     * @returns array of zones
     */
    function zonesNormalize(zones = [], options = {}) {
      let {
        from = Number.NEGATIVE_INFINITY,
        to = Number.POSITIVE_INFINITY,
        exclusions = []
      } = options;
      if (from > to) [from, to] = [to, from];
      zones = JSON.parse(JSON.stringify(zones)).map(zone => zone.from > zone.to ? {
        from: zone.to,
        to: zone.from
      } : zone);
      zones = zones.sort((a, b) => {
        if (a.from !== b.from) return a.from - b.from;
        return a.to - b.to;
      });
      if (zones.length === 0) {
        zones.push({
          from,
          to
        });
      }
      for (const zone of zones) {
        if (from > zone.from) zone.from = from;
        if (to < zone.to) zone.to = to;
      }
      zones = zones.filter(zone => zone.from <= zone.to);
      if (zones.length === 0) return [];
      let currentZone = zones[0];
      let beforeExclusionsZones = [currentZone];
      for (let i = 1; i < zones.length; i++) {
        let zone = zones[i];
        if (zone.from <= currentZone.to) {
          if (currentZone.to < zone.to) {
            currentZone.to = zone.to;
          }
        } else {
          currentZone = zone;
          beforeExclusionsZones.push(currentZone);
        }
      }
      if (exclusions.length === 0) return beforeExclusionsZones;
      const normalizedExclusions = zonesNormalize(exclusions);
      let currentExclusionIndex = 0;
      const results = [];
      let counter = 0;
      for (let zoneIndex = 0; zoneIndex < beforeExclusionsZones.length; zoneIndex++) {
        if (counter++ > 5) break;
        const zone = beforeExclusionsZones[zoneIndex];
        if (currentExclusionIndex === normalizedExclusions.length) {
          // we analysed all the exclusion zones
          results.push(zone);
          continue;
        }
        while (currentExclusionIndex < normalizedExclusions.length && normalizedExclusions[currentExclusionIndex].to <= zone.from) {
          currentExclusionIndex++;
        }
        if (currentExclusionIndex === normalizedExclusions.length) {
          // we analysed all the exclusion zones
          results.push(zone);
          continue;
        }
        if (zone.to < normalizedExclusions[currentExclusionIndex].from) {
          // no problems, not yet in exclusion
          results.push(zone);
          continue;
        }
        if (normalizedExclusions[currentExclusionIndex].to >= zone.to) {
          // could be totally excluded
          if (normalizedExclusions[currentExclusionIndex].from <= zone.from) {
            continue;
          }
          results.push({
            from: normalizedExclusions[currentExclusionIndex].to,
            to: zone.to
          });
        }
        // we cut in the middle, we need to create more zones, annoying !
        if (normalizedExclusions[currentExclusionIndex].from > zone.from) {
          results.push({
            from: zone.from,
            to: normalizedExclusions[currentExclusionIndex].from
          });
        }
        zone.from = normalizedExclusions[currentExclusionIndex].to;
        zoneIndex--;
      }
      return results;
    }

    /**
     * Add the number of points per zone to reach a specified total
     *
     * @param zones - array of zones
     * @param numberOfPoints - total number of points to distribute between zones
     * @param options - options
     * @returns array of zones with points
     */
    function zonesWithPoints(zones = [],
    /**
     * total number of points to distribute between zones
     * @default 10
     */
    numberOfPoints = 10, options = {}) {
      if (zones.length === 0) return zones;
      let returnZones = zonesNormalize(zones, options);
      const totalSize = returnZones.reduce((previous, current) => {
        return previous + (current.to - current.from);
      }, 0);
      let unitsPerPoint = totalSize / numberOfPoints;
      let currentTotal = 0;
      for (let i = 0; i < returnZones.length - 1; i++) {
        let zone = returnZones[i];
        zone.numberOfPoints = Math.min(Math.round((zone.to - zone.from) / unitsPerPoint), numberOfPoints - currentTotal);
        currentTotal += zone.numberOfPoints;
      }
      let zone = returnZones[returnZones.length - 1];
      zone.numberOfPoints = numberOfPoints - currentTotal;
      return returnZones;
    }

    /**
     * function that retrieves the getEquallySpacedData with the variant "slot"
     *
     * @param x
     * @param y
     * @param from
     * @param to
     * @param numberOfPoints
     * @return Array of y's equally spaced with the variant "slot"
     */
    function equallySpacedSlot( /** x coordinates */
    x, /** y coordinates */
    y, /** from value */
    from, /** to value */
    to, /** number of points */
    numberOfPoints) {
      let xLength = x.length;
      let step = (to - from) / (numberOfPoints > 1 ? numberOfPoints - 1 : 1);
      let halfStep = step / 2;
      let lastStep = x[x.length - 1] - x[x.length - 2];
      let start = from - halfStep;
      // Changed Array to Float64Array
      let output = new Float64Array(numberOfPoints);
      // Init main variables
      let min = start;
      let max = start + step;
      let previousX = -Number.MAX_VALUE;
      let previousY = 0;
      let nextX = x[0];
      let nextY = y[0];
      let frontOutsideSpectra = 0;
      let backOutsideSpectra = true;
      let currentValue = 0;
      // for slot algorithm
      let currentPoints = 0;
      let i = 1; // index of input
      let j = 0; // index of output
      main: while (true) {
        if (previousX >= nextX) throw new Error('x must be a growing series');
        while (previousX - max > 0) {
          // no overlap with original point, just consume current value
          if (backOutsideSpectra) {
            currentPoints++;
            backOutsideSpectra = false;
          }
          output[j] = currentPoints <= 0 ? 0 : currentValue / currentPoints;
          j++;
          if (j === numberOfPoints) {
            break main;
          }
          min = max;
          max += step;
          currentValue = 0;
          currentPoints = 0;
        }
        if (previousX > min) {
          currentValue += previousY;
          currentPoints++;
        }
        if (previousX === -Number.MAX_VALUE || frontOutsideSpectra > 1) {
          currentPoints--;
        }
        previousX = nextX;
        previousY = nextY;
        if (i < xLength) {
          nextX = x[i];
          nextY = y[i];
          i++;
        } else {
          nextX += lastStep;
          nextY = 0;
          frontOutsideSpectra++;
        }
      }
      return output;
    }

    /**
     * Function that calculates the integral of the line between two
     * x-coordinates, given the slope and intercept of the line.
     * @param x0
     * @param x1
     * @param slope
     * @param intercept
     * @return integral value.
     */
    function integral( /** first coordinate of point */
    x0, /** second coordinate of point */
    x1, /** slope of the line */
    slope, /** intercept of the line on the y axis */
    intercept) {
      return 0.5 * slope * x1 * x1 + intercept * x1 - (0.5 * slope * x0 * x0 + intercept * x0);
    }

    /**
     * function that retrieves the getEquallySpacedData with the variant "smooth"
     *
     * @param x
     * @param y
     * @param from
     * @param to
     * @param numberOfPoints
     * @return - Array of y's equally spaced with the variant "smooth"
     */
    function equallySpacedSmooth( /** x coordinates */
    x, /** y coordinates */
    y, /** from value */
    from, /** to value */
    to, /** number of points */
    numberOfPoints) {
      let xLength = x.length;
      let step = (to - from) / (numberOfPoints > 1 ? numberOfPoints - 1 : 1);
      let halfStep = step / 2;
      // Changed Array to Float64Array
      let output = new Float64Array(numberOfPoints);
      let initialOriginalStep = x[1] - x[0];
      let lastOriginalStep = x[xLength - 1] - x[xLength - 2];
      // Init main variables
      let min = from - halfStep;
      let max = from + halfStep;
      let previousX = Number.MIN_SAFE_INTEGER;
      let previousY = 0;
      let nextX = x[0] - initialOriginalStep;
      let nextY = 0;
      let currentValue = 0;
      let slope = 0;
      let intercept = 0;
      let sumAtMin = 0;
      let sumAtMax = 0;
      let i = 0; // index of input
      let j = 0; // index of output
      let add = 0;
      main: while (true) {
        if (previousX >= nextX) throw new Error('x must be a growing series');
        if (previousX <= min && min <= nextX) {
          add = integral(0, min - previousX, slope, previousY);
          sumAtMin = currentValue + add;
        }
        while (nextX - max >= 0) {
          // no overlap with original point, just consume current value
          add = integral(0, max - previousX, slope, previousY);
          sumAtMax = currentValue + add;
          output[j++] = (sumAtMax - sumAtMin) / step;
          if (j === numberOfPoints) {
            break main;
          }
          min = max;
          max += step;
          sumAtMin = sumAtMax;
        }
        currentValue += integral(previousX, nextX, slope, intercept);
        previousX = nextX;
        previousY = nextY;
        if (i < xLength) {
          nextX = x[i];
          nextY = y[i];
          i++;
        } else if (i === xLength) {
          nextX += lastOriginalStep;
          nextY = 0;
        }
        slope = getSlope(previousX, previousY, nextX, nextY);
        intercept = -slope * previousX + previousY;
      }
      return output;
    }
    function getSlope(x0, y0, x1, y1) {
      return (y1 - y0) / (x1 - x0);
    }

    /**
     * Function that returns a Number array of equally spaced numberOfPoints
     * containing a representation of intensities of the spectra arguments x
     * and y.
     *
     * The options parameter contains an object in the following form:
     * from: starting point
     * to: last point
     * numberOfPoints: number of points between from and to
     * variant: "slot" or "smooth" - smooth is the default option
     *
     * The slot variant consist that each point in an array is calculated
     * averaging the existing points between the slot that belongs to the current
     * value. The smooth variant is the same but takes the integral of the range
     * of the slot and divide by the step size between two points in an array.
     *
     * If exclusions zone are present, zones are ignored !
     *
     * @param data - object containing 2 properties x and y
     * @param options - options
     * @return new object with x / y array with the equally spaced data.
     */
    function xyEquallySpaced(data, options = {}) {
      let {
        x,
        y
      } = data;
      let xLength = x.length;
      const {
        from = x[0],
        to = x[xLength - 1],
        variant = 'smooth',
        numberOfPoints = 100,
        exclusions = [],
        zones = [{
          from,
          to
        }]
      } = options;
      if (from > to) {
        throw new RangeError('from should be larger than to');
      }
      xyCheck(data);
      if (numberOfPoints < 2) {
        throw new RangeError("'numberOfPoints' option must be greater than 1");
      }
      const normalizedZones = zonesNormalize(zones, {
        from,
        to,
        exclusions
      });
      const zonesWithPointsRes = zonesWithPoints(normalizedZones, numberOfPoints, {
        from,
        to
      });
      let xResult = [];
      let yResult = [];
      for (let zone of zonesWithPointsRes) {
        if (!zone.numberOfPoints) {
          zone.numberOfPoints = 0;
        }
        let zoneResult = processZone(Array.from(x), Array.from(y), zone.from, zone.to, zone.numberOfPoints, variant);
        xResult = xResult.concat(zoneResult.x);
        yResult = yResult.concat(zoneResult.y);
      }
      return {
        x: xResult,
        y: yResult
      };
    }
    function processZone(x, y, from, to, numberOfPoints, variant) {
      if (numberOfPoints < 1) {
        throw new RangeError('the number of points must be at least 1');
      }
      let output = variant === 'slot' ? Array.from(equallySpacedSlot(x, y, from, to, numberOfPoints)) : Array.from(equallySpacedSmooth(x, y, from, to, numberOfPoints));
      return {
        x: Array.from(createFromToArray({
          from,
          to,
          length: numberOfPoints
        })),
        y: output
      };
    }

    /**
     * XyExtract zones from a XY data
     *
     * @param data - Object that contains property x (an ordered increasing array) and y (an array)
     * @param options - options
     * @returns - Array of points
     */
    function xyExtract(data, options = {}) {
      xyCheck(data);
      const {
        x,
        y
      } = data;
      let {
        zones
      } = options;
      zones = zonesNormalize(zones);
      if (x === undefined || y === undefined || !Array.isArray(zones) || zones.length === 0) {
        return data;
      }
      let newX = [];
      let newY = [];
      let currentZone = zones[0];
      let position = 0;
      loop: for (let i = 0; i < x.length; i++) {
        while (currentZone.to < x[i]) {
          position++;
          currentZone = zones[position];
          if (!currentZone) {
            i = x.length;
            break loop;
          }
        }
        if (x[i] >= currentZone.from) {
          newX.push(x[i]);
          newY.push(y[i]);
        }
      }
      return {
        x: newX,
        y: newY
      };
    }

    /** Filter an array x/y based on various criteria x points are expected to be sorted
     *
     * @param data - object containing 2 properties x and y
     * @param options - options
     * @return filtered array
     */
    function xyFilterX(data, options = {}) {
      const {
        x,
        y
      } = data;
      const {
        from = x[0],
        to = x[x.length - 1],
        zones = [{
          from,
          to
        }],
        exclusions = []
      } = options;
      let normalizedZones = zonesNormalize(zones, {
        from,
        to,
        exclusions
      });
      let currentZoneIndex = 0;
      let newX = [];
      let newY = [];
      let position = 0;
      while (position < x.length) {
        if (x[position] <= normalizedZones[currentZoneIndex].to && x[position] >= normalizedZones[currentZoneIndex].from) {
          newX.push(x[position]);
          newY.push(y[position]);
        } else if (x[position] > normalizedZones[currentZoneIndex].to) {
          currentZoneIndex++;
          if (!normalizedZones[currentZoneIndex]) break;
        }
        position++;
      }
      return {
        x: newX,
        y: newY
      };
    }

    /**
     * Calculate integration
     *
     * @param data - Object that contains property x (an ordered increasing array) and y (an array)
     * @param options - Options
     * @returns - xyIntegration value on the specified range
     */
    function xyIntegration(data, options = {}) {
      xyCheck(data, {
        minLength: 1
      });
      const {
        x,
        y
      } = data;
      if (x.length === 1) return 0;
      const {
        fromIndex,
        toIndex
      } = xGetFromToIndex(x, options);
      let currentxyIntegration = 0;
      for (let i = fromIndex; i < toIndex; i++) {
        currentxyIntegration += (x[i + 1] - x[i]) * (y[i + 1] + y[i]) / 2;
      }
      return currentxyIntegration;
    }

    /**
     * Set a value (default 0) to specific zones.
     *
     * @param data - Object that contains property x (an ordered increasing array) and y (an array)
     * @param options - options
     * @returns - Array of points
     */
    function xySetYValue(data, options = {}) {
      xyCheck(data);
      const {
        x,
        y
      } = data;
      let {
        zones,
        value = 0
      } = options;
      if (!Array.isArray(zones) || zones.length === 0) {
        return data;
      }
      zones = zonesNormalize(zones);
      const newX = x.slice();
      const newY = y.slice();
      let currentZone = zones[0];
      let position = 0;
      loop: for (let i = 0; i < x.length; i++) {
        while (currentZone.to < x[i]) {
          position++;
          currentZone = zones[position];
          if (!currentZone) {
            i = x.length;
            break loop;
          }
        }
        if (x[i] >= currentZone.from) {
          newY[i] = value;
        }
      }
      return {
        x: newX,
        y: newY
      };
    }

    function matrixCheck(data) {
      if (data.length === 0 || data[0].length === 0) {
        throw new RangeError('matrix should contain data');
      }
      const firstLength = data[0].length;
      for (let i = 1; i < data.length; i++) {
        if (data[i].length !== firstLength) {
          throw new RangeError('All rows should has the same length');
        }
      }
    }

    /**
     * Get min and max Z
     *
     * @param matrix - matrix [rows][cols].
     */
    function matrixMinMaxZ(matrix) {
      matrixCheck(matrix);
      const nbRows = matrix.length;
      const nbColumns = matrix[0].length;
      let min = matrix[0][0];
      let max = matrix[0][0];
      for (let column = 0; column < nbColumns; column++) {
        for (let row = 0; row < nbRows; row++) {
          if (matrix[row][column] < min) min = matrix[row][column];
          if (matrix[row][column] > max) max = matrix[row][column];
        }
      }
      return {
        min,
        max
      };
    }

    const LOOP = 8;
    const FLOAT_MUL = 1 / 16777216;
    const sh1 = 15;
    const sh2 = 18;
    const sh3 = 11;
    function multiply_uint32(n, m) {
      n >>>= 0;
      m >>>= 0;
      const nlo = n & 0xffff;
      const nhi = n - nlo;
      return (nhi * m >>> 0) + nlo * m >>> 0;
    }
    class XSadd {
      constructor(seed = Date.now()) {
        this.state = new Uint32Array(4);
        this.init(seed);
        this.random = this.getFloat.bind(this);
      }
      /**
       * Returns a 32-bit integer r (0 <= r < 2^32)
       */
      getUint32() {
        this.nextState();
        return this.state[3] + this.state[2] >>> 0;
      }
      /**
       * Returns a floating point number r (0.0 <= r < 1.0)
       */
      getFloat() {
        return (this.getUint32() >>> 8) * FLOAT_MUL;
      }
      init(seed) {
        if (!Number.isInteger(seed)) {
          throw new TypeError('seed must be an integer');
        }
        this.state[0] = seed;
        this.state[1] = 0;
        this.state[2] = 0;
        this.state[3] = 0;
        for (let i = 1; i < LOOP; i++) {
          this.state[i & 3] ^= i + multiply_uint32(1812433253, this.state[i - 1 & 3] ^ this.state[i - 1 & 3] >>> 30 >>> 0) >>> 0;
        }
        this.periodCertification();
        for (let i = 0; i < LOOP; i++) {
          this.nextState();
        }
      }
      periodCertification() {
        if (this.state[0] === 0 && this.state[1] === 0 && this.state[2] === 0 && this.state[3] === 0) {
          this.state[0] = 88; // X
          this.state[1] = 83; // S
          this.state[2] = 65; // A
          this.state[3] = 68; // D
        }
      }

      nextState() {
        let t = this.state[0];
        t ^= t << sh1;
        t ^= t >>> sh2;
        t ^= this.state[3] << sh3;
        this.state[0] = this.state[1];
        this.state[1] = this.state[2];
        this.state[2] = this.state[3];
        this.state[3] = t;
      }
    }

    /**
     * Create a random array of numbers of a specific length
     *
     * @return - array of random floats normally distributed
     */
    let spare;
    let hasSpare = false;
    function createRandomArray(options = {}) {
      const {
        mean = 0,
        standardDeviation = 1,
        length = 1000,
        range = 1,
        seed,
        distribution = 'normal'
      } = options;
      const generator = new XSadd(seed);
      let returnArray = new Float64Array(length);
      switch (distribution) {
        case 'normal':
          for (let i = 0; i < length; i++) {
            returnArray[i] = generateGaussian(mean, standardDeviation, generator);
          }
          break;
        case 'uniform':
          for (let i = 0; i < length; i++) {
            returnArray[i] = (generator.random() - 0.5) * range + mean;
          }
          break;
        default:
          // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
          throw new Error(`unknown distribution: ${distribution}`);
      }
      return returnArray;
    }
    function generateGaussian(mean, standardDeviation, generator) {
      let val, u, v, s;
      if (hasSpare) {
        hasSpare = false;
        val = spare * standardDeviation + mean;
      } else {
        do {
          u = generator.random() * 2 - 1;
          v = generator.random() * 2 - 1;
          s = u * u + v * v;
        } while (s >= 1 || s === 0);
        s = Math.sqrt(-2 * Math.log(s) / s);
        spare = v * s;
        hasSpare = true;
        val = mean + standardDeviation * u * s;
      }
      return val;
    }

    function addNoise(data, options = {}) {
      const {
        seed = 0,
        distribution = 'normal',
        percent = 1
      } = options;
      const range = xMaxValue(data.y) * percent / 100;
      const noise = createRandomArray({
        distribution,
        seed,
        mean: 0,
        standardDeviation: range,
        range,
        length: data.x.length
      });
      data.y = xAdd(data.y, noise);
      return data;
    }

    class SpectrumGenerator {
      constructor(options = {}) {
        const {
          from = 0,
          to = 1000,
          nbPoints = 10001,
          peakWidthFct,
          shape = {
            kind: 'gaussian',
            fwhm: 5
          }
        } = options;
        this.from = from;
        this.to = to;
        this.nbPoints = nbPoints;
        this.interval = (this.to - this.from) / (this.nbPoints - 1);
        this.peakWidthFct = peakWidthFct;
        this.maxPeakHeight = Number.MIN_SAFE_INTEGER;
        this.data = {
          x: new Float64Array(this.nbPoints),
          y: new Float64Array(this.nbPoints)
        };
        let shapeGenerator = getShape1D(shape);
        this.shape = shapeGenerator;
        assertNumber$2(this.from, 'from');
        assertNumber$2(this.to, 'to');
        assertInteger$1(this.nbPoints, 'nbPoints');
        if (this.to <= this.from) {
          throw new RangeError('to option must be larger than from');
        }
        if (this.peakWidthFct && typeof this.peakWidthFct !== 'function') {
          throw new TypeError('peakWidthFct option must be a function');
        }
        this.reset();
      }
      /**
       * Add a series of peaks to the spectrum.
       * @param peaks - Peaks to add.
       */
      addPeaks(peaks, options) {
        if (!Array.isArray(peaks) && (typeof peaks !== 'object' || peaks.x === undefined || peaks.y === undefined || !Array.isArray(peaks.x) || !Array.isArray(peaks.y) || peaks.x.length !== peaks.y.length)) {
          throw new TypeError('peaks must be an array or an object containing x[] and y[]');
        }
        if (Array.isArray(peaks)) {
          for (const peak of peaks) {
            this.addPeak(peak, options);
          }
        } else {
          for (let i = 0; i < peaks.x.length; i++) {
            this.addPeak([peaks.x[i], peaks.y[i]], options);
          }
        }
      }
      /**
       * Add a single peak to the spectrum.
       * A peak may be either defined as [x,y,fwhm,...] or as {x, y, shape}
       * @param peak
       * @param options
       */
      addPeak(peak, options = {}) {
        if (Array.isArray(peak) && peak.length < 2) {
          throw new Error('peak must be an array with two (or three) values or an object with {x,y,width?}');
        }
        if (!Array.isArray(peak) && (peak.x === undefined || peak.y === undefined)) {
          throw new Error('peak must be an array with two (or three) values or an object with {x,y,width?}');
        }
        let xPosition;
        let intensity;
        let peakFWHM;
        let peakWidth;
        let peakShapeOptions;
        if (Array.isArray(peak)) {
          [xPosition, intensity, peakFWHM, peakShapeOptions] = peak;
        } else {
          xPosition = peak.x;
          intensity = peak.y;
          peakWidth = peak.width;
          peakShapeOptions = peak.shape;
        }
        if (intensity > this.maxPeakHeight) this.maxPeakHeight = intensity;
        let {
          shape: shapeOptions
        } = options;
        if (peakShapeOptions) {
          shapeOptions = shapeOptions ? {
            ...shapeOptions,
            ...peakShapeOptions
          } : peakShapeOptions;
        }
        const shape = shapeOptions ? getShape1D(shapeOptions) : Object.assign(Object.create(Object.getPrototypeOf(this.shape)), this.shape);
        let {
          width,
          widthLeft,
          widthRight
        } = options;
        /*
         if we don't force the fwhm we just take the one from the shape
         however we have many way to force it:
         - use [x,y,fwhm]
         - define `width` that will be converted to fwhm
         - define `widthLeft` and `widthRight` to define asymmetric peaks
         - have a callback `peakWidthFct`
         This should evolve in the future because we will not always have `fwhm`
         */
        const fwhm = peakFWHM !== undefined ? peakFWHM : peakWidth ? shape.widthToFWHM(peakWidth) : this.peakWidthFct ? this.peakWidthFct(xPosition) : width !== undefined ? width : shape.fwhm;
        if (!widthLeft) widthLeft = fwhm;
        if (!widthRight) widthRight = fwhm;
        if (!widthLeft || !widthRight) {
          throw new Error('Width left or right is undefined or zero');
        }
        let factor = options.factor === undefined ? shape.getFactor() : options.factor;
        const firstValue = xPosition - widthLeft / 2 * factor;
        const lastValue = xPosition + widthRight / 2 * factor;
        const firstPoint = Math.max(0, Math.floor((firstValue - this.from) / this.interval));
        const lastPoint = Math.min(this.nbPoints - 1, Math.ceil((lastValue - this.from) / this.interval));
        const middlePoint = Math.round((xPosition - this.from) / this.interval);
        // PEAK SHAPE MAY BE ASYMMETRC (widthLeft and widthRight) !
        // we calculate the left part of the shape
        shape.fwhm = widthLeft;
        for (let index = firstPoint; index < Math.max(middlePoint, 0); index++) {
          this.data.y[index] += intensity * shape.fct(this.data.x[index] - xPosition);
        }
        // we calculate the right part of the gaussian
        shape.fwhm = widthRight;
        for (let index = Math.min(middlePoint, lastPoint); index <= lastPoint; index++) {
          this.data.y[index] += intensity * shape.fct(this.data.x[index] - xPosition);
        }
      }
      /**
       * Add a baseline to the spectrum.
       * @param baselineFct - Mathematical function producing the baseline you want.
       */
      addBaseline(baselineFct) {
        addBaseline(this.data, baselineFct);
        return this;
      }
      /**
       * Add noise to the spectrum.
       *
       * @param percent - Noise's amplitude in percents of the spectrum max value. Default: 1.
       */
      addNoise(options) {
        addNoise(this.data, options);
        return this;
      }
      /**
       * Get the generated spectrum.
       */
      getSpectrum(options = {}) {
        if (typeof options === 'boolean') {
          options = {
            copy: options
          };
        }
        const {
          copy = true,
          threshold = 0
        } = options;
        if (threshold) {
          let minPeakHeight = this.maxPeakHeight * threshold;
          let x = [];
          let y = [];
          for (let i = 0; i < this.data.x.length; i++) {
            if (this.data.y[i] >= minPeakHeight) {
              x.push(this.data.x[i]);
              y.push(this.data.y[i]);
            }
          }
          return {
            x: Float64Array.from(x),
            y: Float64Array.from(y)
          };
        }
        if (copy) {
          return {
            x: this.data.x.slice(),
            y: this.data.y.slice()
          };
        } else {
          return this.data;
        }
      }
      /**
       * Resets the generator with an empty spectrum.
       */
      reset() {
        const spectrum = this.data;
        for (let i = 0; i < this.nbPoints; i++) {
          spectrum.x[i] = this.from + i * this.interval;
        }
        return this;
      }
    }
    function assertInteger$1(value, name) {
      if (!Number.isInteger(value)) {
        throw new TypeError(`${name} option must be an integer`);
      }
    }
    function assertNumber$2(value, name) {
      if (!Number.isFinite(value)) {
        throw new TypeError(`${name} option must be a number`);
      }
    }
    /**
     * Generates a spectrum and returns it.
     * @param peaks - List of peaks to put in the spectrum.
     * @param options
     */
    function generateSpectrum(peaks, options = {}) {
      const {
        generator: generatorOptions,
        noise,
        baseline,
        threshold,
        peakOptions
      } = options;
      const generator = new SpectrumGenerator(generatorOptions);
      generator.addPeaks(peaks, peakOptions);
      if (baseline) generator.addBaseline(baseline);
      if (noise) {
        generator.addNoise(noise);
      }
      return generator.getSpectrum({
        threshold
      });
    }

    const axis2D = ['x', 'y'];
    const peakCoordinates = ['x', 'y', 'z'];
    const convertWidthToFWHM = (shape, width) => {
      const widthData = ensureXYNumber$1(width);
      for (let key of axis2D) {
        widthData[key] = shape.widthToFWHM(widthData[key]);
      }
      return widthData;
    };
    class Spectrum2DGenerator {
      constructor(options = {}) {
        let {
          from = 0,
          to = 100,
          nbPoints = 1001,
          peakWidthFct = () => 5,
          shape = {
            kind: 'gaussian'
          }
        } = options;
        from = ensureXYNumber$1(from);
        to = ensureXYNumber$1(to);
        nbPoints = ensureXYNumber$1(nbPoints);
        for (const axis of axis2D) {
          assertNumber$1(from[axis], `from-${axis}`);
          assertNumber$1(to[axis], `to-${axis}`);
          assertInteger(nbPoints[axis], `nbPoints-${axis}`);
        }
        this.from = from;
        this.to = to;
        this.nbPoints = nbPoints;
        this.interval = calculeIntervals(from, to, nbPoints);
        this.peakWidthFct = peakWidthFct;
        this.maxPeakHeight = Number.MIN_SAFE_INTEGER;
        let shapeGenerator = getShape2D(shape);
        this.shape = shapeGenerator;
        this.data = {
          x: new Float64Array(nbPoints.x),
          y: new Float64Array(nbPoints.y),
          z: createMatrix(this.nbPoints)
        };
        for (const axis of axis2D) {
          if (this.to[axis] <= this.from[axis]) {
            throw new RangeError('to option must be larger than from');
          }
        }
        if (typeof this.peakWidthFct !== 'function') {
          throw new TypeError('peakWidthFct option must be a function');
        }
        this.reset();
      }
      addPeaks(peaks, options) {
        if (!Array.isArray(peaks) && (typeof peaks !== 'object' || peaks.x === undefined || peaks.y === undefined || !Array.isArray(peaks.x) || !Array.isArray(peaks.y) || peaks.x.length !== peaks.y.length)) {
          throw new TypeError('peaks must be an array or an object containing x[] and y[]');
        }
        if (Array.isArray(peaks)) {
          for (const peak of peaks) {
            this.addPeak(peak, options);
          }
        } else {
          let nbPeaks = peaks.x.length;
          for (const c of peakCoordinates) {
            if (peaks[c] && Array.isArray(peaks[c])) {
              if (nbPeaks !== peaks[c].length) {
                throw new Error('x, y, z should have the same length');
              }
            }
          }
          for (let i = 0; i < peaks.x.length; i++) {
            this.addPeak([peaks.x[i], peaks.y[i], peaks.z[i]], options);
          }
        }
        return this;
      }
      addPeak(peak, options = {}) {
        if (Array.isArray(peak) && peak.length < 3) {
          throw new Error('peak must be an array with three (or four) values or an object with {x,y,z,width?}');
        }
        if (!Array.isArray(peak) && peakCoordinates.some(e => peak[e] === undefined)) {
          throw new Error('peak must be an array with three (or four) values or an object with {x,y,z,width?}');
        }
        let xPosition;
        let yPosition;
        let intensity;
        let peakFWHM;
        let peakWidth;
        let peakShapeOptions;
        if (Array.isArray(peak)) {
          [xPosition, yPosition, intensity, peakFWHM, peakShapeOptions] = peak;
        } else {
          xPosition = peak.x;
          yPosition = peak.y;
          intensity = peak.z;
          peakFWHM = peak.fwhm;
          peakWidth = peak.width;
          peakShapeOptions = peak.shape;
        }
        const position = {
          x: xPosition,
          y: yPosition
        };
        if (intensity > this.maxPeakHeight) this.maxPeakHeight = intensity;
        let {
          shape: shapeOptions,
          width
        } = options;
        if (peakShapeOptions) {
          shapeOptions = shapeOptions ? {
            ...shapeOptions,
            ...peakShapeOptions
          } : peakShapeOptions;
        }
        const shape = shapeOptions ? getShape2D(shapeOptions) : Object.assign(Object.create(Object.getPrototypeOf(this.shape)), JSON.parse(JSON.stringify(this.shape)));
        let {
          fwhm = peakFWHM !== undefined ? peakFWHM : peakWidth ? convertWidthToFWHM(shape, peakWidth) : width ? convertWidthToFWHM(shape, width) : this.peakWidthFct(xPosition, yPosition)
        } = options;
        fwhm = ensureXYNumber$1(fwhm);
        let factor = options.factor === undefined ? shape.getFactor() : options.factor;
        factor = ensureXYNumber$1(factor);
        const firstPoint = {
          x: 0,
          y: 0
        };
        const lastPoint = {
          x: 0,
          y: 0
        };
        for (const axis of axis2D) {
          const first = position[axis] - fwhm[axis] / 2 * factor[axis];
          const last = position[axis] + fwhm[axis] / 2 * factor[axis];
          firstPoint[axis] = Math.max(0, Math.floor((first - this.from[axis]) / this.interval[axis]));
          lastPoint[axis] = Math.min(this.nbPoints[axis], Math.ceil((last - this.from[axis]) / this.interval[axis]));
        }
        shape.fwhm = fwhm;
        for (let xIndex = firstPoint.x; xIndex < lastPoint.x; xIndex++) {
          for (let yIndex = firstPoint.y; yIndex < lastPoint.y; yIndex++) {
            const value = intensity * shape.fct(this.data.x[xIndex] - position.x, this.data.y[yIndex] - position.y);
            if (value > 1e-6) {
              this.data.z[yIndex][xIndex] += value;
            }
          }
        }
        return this;
      }
      getSpectrum(options = {}) {
        if (typeof options === 'boolean') {
          options = {
            copy: options
          };
        }
        const {
          copy = true
        } = options;
        let minMaxZ = matrixMinMaxZ(this.data.z);
        return {
          minX: this.from.x,
          maxX: this.to.x,
          maxY: this.to.y,
          minY: this.from.y,
          minZ: minMaxZ.min,
          maxZ: minMaxZ.max,
          z: copy ? this.data.z.slice() : this.data.z
        };
      }
      reset() {
        const spectrum = this.data;
        for (const axis of axis2D) {
          for (let i = 0; i < this.nbPoints[axis]; i++) {
            spectrum[axis][i] = this.from[axis] + i * this.interval[axis];
          }
        }
        for (let row of spectrum.z) {
          for (let j = 0; j < row.length; j++) {
            row[j] = 0;
          }
        }
        return this;
      }
    }
    function generateSpectrum2D(peaks, options = {}) {
      const {
        generator: generatorOptions,
        peaks: addPeaksOptions
      } = options;
      const generator = new Spectrum2DGenerator(generatorOptions);
      generator.addPeaks(peaks, addPeaksOptions);
      return generator.getSpectrum();
    }
    function ensureXYNumber$1(input) {
      return typeof input !== 'object' ? {
        x: input,
        y: input
      } : {
        ...input
      };
    }
    function calculeIntervals(from, to, nbPoints) {
      return {
        x: (to.x - from.x) / (nbPoints.x - 1),
        y: (to.y - from.y) / (nbPoints.y - 1)
      };
    }
    function assertInteger(value, name) {
      if (!Number.isInteger(value)) {
        throw new TypeError(`${name} option must be an integer`);
      }
    }
    function assertNumber$1(value, name) {
      if (!Number.isFinite(value)) {
        throw new TypeError(`${name} option must be a number`);
      }
    }
    function createMatrix(nbPoints) {
      const zMatrix = new Array(nbPoints.y);
      for (let i = 0; i < nbPoints.y; i++) {
        zMatrix[i] = new Float64Array(nbPoints.x);
      }
      return zMatrix;
    }

    function hasProperty(data, key) {
      return key in data;
    }

    const {
      parse: parse$7,
      stringify: stringify$7
    } = JSON;
    /**
     * convert width and fwhm to ppm
     */
    function convertWidth(peaks, options) {
      const {
        frequency,
        convertTo,
        output = parse$7(stringify$7(peaks))
      } = options;
      const convert = getConverter(convertTo, frequency);
      for (const peak of output) {
        peak.width = convert(peak.width);
        if (hasProperty(peak, 'shape')) {
          const shape = peak.shape;
          if (shape.fwhm) {
            shape.fwhm = convert(shape.fwhm);
          }
        }
      }
      return output;
    }
    function getConverter(convertTo, frequency) {
      switch (convertTo) {
        case 'ppm':
          return x => x / frequency;
        case 'hz':
          return x => x * frequency;
        default:
          throw new Error(`Does not support convert to ${convertTo}`);
      }
    }

    function convertWidthToPPM(peaks, options) {
      return convertWidth(peaks, {
        ...options,
        convertTo: 'ppm'
      });
    }

    function peaksToXY(peaks, options) {
      const {
        frequency,
        nbPoints = 1024,
        shape
      } = options;
      if (!frequency) {
        throw new Error('frequency is mandatory');
      }
      const newPeaks = convertWidthToPPM(peaks, {
        frequency
      });
      return generateSpectrum(newPeaks, {
        generator: {
          ...getFromTo$1(newPeaks, options),
          nbPoints,
          shape
        }
      });
    }
    function getFromTo$1(newPeaks, options) {
      if ('to' in options && 'from' in options) {
        return {
          from: options.from,
          to: options.to
        };
      }
      newPeaks.sort((a, b) => a.x - b.x);
      const firstPeak = newPeaks[0];
      const lastPeak = newPeaks[newPeaks.length - 1];
      const {
        from = firstPeak.x - firstPeak.width * 2 / options.frequency,
        to = lastPeak.x + lastPeak.width * 2 / options.frequency
      } = options;
      return {
        from,
        to
      };
    }

    var IDX = 256,
      HEX = [],
      BUFFER;
    while (IDX--) HEX[IDX] = (IDX + 256).toString(16).substring(1);
    function v4() {
      var i = 0,
        num,
        out = '';
      if (!BUFFER || IDX + 16 > 256) {
        BUFFER = Array(i = 256);
        while (i--) BUFFER[i] = 256 * Math.random() | 0;
        i = IDX = 0;
      }
      for (; i < 16; i++) {
        num = BUFFER[IDX + i];
        if (i == 6) out += HEX[num & 15 | 64];else if (i == 8) out += HEX[num & 63 | 128];else out += HEX[num];
        if (i & 1 && i > 1 && i < 11) out += '-';
      }
      IDX++;
      return out;
    }

    /**
     * Apply Savitzky Golay algorithm
     * @param [ys] Array of y values
     * @param [xs] Array of X or deltaX
     * @return  Array containing the new ys (same length)
     */
    function sgg(ys, xs, options = {}) {
      let {
        windowSize = 9,
        derivative = 0,
        polynomial = 3
      } = options;
      if (windowSize % 2 === 0 || windowSize < 5 || !Number.isInteger(windowSize)) {
        throw new RangeError('Invalid window size (should be odd and at least 5 integer number)');
      }
      if (!isAnyArray(ys)) {
        throw new TypeError('Y values must be an array');
      }
      if (typeof xs === 'undefined') {
        throw new TypeError('X must be defined');
      }
      if (windowSize > ys.length) {
        throw new RangeError(`Window size is higher than the data length ${windowSize}>${ys.length}`);
      }
      if (derivative < 0 || !Number.isInteger(derivative)) {
        throw new RangeError('Derivative should be a positive integer');
      }
      if (polynomial < 1 || !Number.isInteger(polynomial)) {
        throw new RangeError('Polynomial should be a positive integer');
      }
      if (polynomial >= 6) {
        // eslint-disable-next-line no-console
        console.warn('You should not use polynomial grade higher than 5 if you are' + ' not sure that your data arises from such a model. Possible polynomial oscillation problems');
      }
      let half = Math.floor(windowSize / 2);
      let np = ys.length;
      let ans = new Float64Array(np);
      let weights = fullWeights(windowSize, polynomial, derivative);
      let hs = 0;
      let constantH = true;
      if (isAnyArray(xs)) {
        constantH = false;
      } else {
        hs = Math.pow(xs, derivative);
      }
      //For the borders
      for (let i = 0; i < half; i++) {
        let wg1 = weights[half - i - 1];
        let wg2 = weights[half + i + 1];
        let d1 = 0;
        let d2 = 0;
        for (let l = 0; l < windowSize; l++) {
          d1 += wg1[l] * ys[l];
          d2 += wg2[l] * ys[np - windowSize + l];
        }
        if (constantH) {
          ans[half - i - 1] = d1 / hs;
          ans[np - half + i] = d2 / hs;
        } else {
          hs = getHs(xs, half - i - 1, half, derivative);
          ans[half - i - 1] = d1 / hs;
          hs = getHs(xs, np - half + i, half, derivative);
          ans[np - half + i] = d2 / hs;
        }
      }
      //For the internal points
      let wg = weights[half];
      for (let i = windowSize; i <= np; i++) {
        let d = 0;
        for (let l = 0; l < windowSize; l++) d += wg[l] * ys[l + i - windowSize];
        if (!constantH) {
          hs = getHs(xs, i - half - 1, half, derivative);
        }
        ans[i - half - 1] = d / hs;
      }
      return ans;
    }
    function getHs(h, center, half, derivative) {
      let hs = 0;
      let count = 0;
      for (let i = center - half; i < center + half; i++) {
        if (i >= 0 && i < h.length - 1) {
          hs += h[i + 1] - h[i];
          count++;
        }
      }
      return Math.pow(hs / count, derivative);
    }
    function gramPoly(i, m, k, s) {
      let Grampoly = 0;
      if (k > 0) {
        Grampoly = (4 * k - 2) / (k * (2 * m - k + 1)) * (i * gramPoly(i, m, k - 1, s) + s * gramPoly(i, m, k - 1, s - 1)) - (k - 1) * (2 * m + k) / (k * (2 * m - k + 1)) * gramPoly(i, m, k - 2, s);
      } else {
        if (k === 0 && s === 0) {
          Grampoly = 1;
        } else {
          Grampoly = 0;
        }
      }
      return Grampoly;
    }
    function genFact(a, b) {
      let gf = 1;
      if (a >= b) {
        for (let j = a - b + 1; j <= a; j++) {
          gf *= j;
        }
      }
      return gf;
    }
    function weight(i, t, m, n, s) {
      let sum = 0;
      for (let k = 0; k <= n; k++) {
        sum += (2 * k + 1) * (genFact(2 * m, k) / genFact(2 * m + k + 1, k + 1)) * gramPoly(i, m, k, 0) * gramPoly(t, m, k, s);
      }
      return sum;
    }
    /**
     * @private
     * @param m  Number of points
     * @param n  Polynomial grade
     * @param s  Derivative
     */
    function fullWeights(m, n, s) {
      let weights = new Array(m);
      let np = Math.floor(m / 2);
      for (let t = -np; t <= np; t++) {
        weights[t + np] = new Float64Array(m);
        for (let j = -np; j <= np; j++) {
          weights[t + np][j + np] = weight(j, t, np, n, s);
        }
      }
      return weights;
    }

    /**
     * Correction of the x and y coordinates using a quadratic optimizations with the peak and its 3 closest neighbors to determine the true x,y values of the peak.
     * This process is done in place and is very fast.
     * @param data
     * @param peaks
     */
    function optimizeTop(data, peaks) {
      const {
        x,
        y
      } = data;
      for (const peak of peaks) {
        let currentIndex = peak.index;
        // The detected peak could be moved 1 or 2 units to left or right.
        if (y[currentIndex - 1] >= y[currentIndex - 2] && y[currentIndex - 1] >= y[currentIndex]) {
          currentIndex--;
        } else if (y[currentIndex + 1] >= y[currentIndex] && y[currentIndex + 1] >= y[currentIndex + 2]) {
          currentIndex++;
        } else if (y[currentIndex - 2] >= y[currentIndex - 3] && y[currentIndex - 2] >= y[currentIndex - 1]) {
          currentIndex -= 2;
        } else if (y[currentIndex + 2] >= y[currentIndex + 1] && y[currentIndex + 2] >= y[currentIndex + 3]) {
          currentIndex += 2;
        }
        // interpolation to a sin() function
        if (y[currentIndex - 1] > 0 && y[currentIndex + 1] > 0 && y[currentIndex] >= y[currentIndex - 1] && y[currentIndex] >= y[currentIndex + 1] && (y[currentIndex] !== y[currentIndex - 1] || y[currentIndex] !== y[currentIndex + 1])) {
          let alpha = 20 * Math.log10(y[currentIndex - 1]);
          let beta = 20 * Math.log10(y[currentIndex]);
          let gamma = 20 * Math.log10(y[currentIndex + 1]);
          let p = 0.5 * (alpha - gamma) / (alpha - 2 * beta + gamma);
          peak.x = x[currentIndex] + (x[currentIndex] - x[currentIndex - 1]) * p;
          peak.y = y[currentIndex] - 0.25 * (y[currentIndex - 1] - y[currentIndex + 1]) * p;
        }
      }
    }

    /**
     * Global spectra deconvolution
     * @param  data - Object data with x and y arrays. Values in x has to be growing
     * @param {number} [options.broadRatio = 0.00] - If `broadRatio` is higher than 0, then all the peaks which second derivative
     * smaller than `broadRatio * maxAbsSecondDerivative` will be marked with the soft mask equal to true.

     */
    function gsd(data, options = {}) {
      let {
        sgOptions = {
          windowSize: 9,
          polynomial: 3
        },
        noiseLevel,
        smoothY = false,
        maxCriteria = true,
        minMaxRatio = 0.00025,
        realTopDetection = false
      } = options;
      let {
        x,
        y
      } = data;
      if (xIsMonotonic(x) !== 1) {
        throw new Error('GSD only accepts monotone increasing x values');
      }
      //rescale;
      y = y.slice();
      // If the max difference between delta x is less than 5%, then,
      // we can assume it to be equally spaced variable
      let equallySpaced = xIsEquallySpaced(x);
      if (noiseLevel === undefined) {
        if (equallySpaced) {
          const noiseInfo = xNoiseStandardDeviation(y);
          if (maxCriteria) {
            noiseLevel = noiseInfo.median + 1.5 * noiseInfo.sd;
          } else {
            noiseLevel = -noiseInfo.median + 1.5 * noiseInfo.sd;
          }
        } else {
          noiseLevel = 0;
        }
      } else if (!maxCriteria) {
        noiseLevel *= -1;
      }
      if (!maxCriteria) {
        for (let i = 0; i < y.length; i++) {
          y[i] *= -1;
        }
      }
      if (noiseLevel !== undefined) {
        for (let i = 0; i < y.length; i++) {
          if (y[i] < noiseLevel) {
            y[i] = noiseLevel;
          }
        }
      }
      let yData = y;
      let dY, ddY;
      const {
        windowSize,
        polynomial
      } = sgOptions;
      if (equallySpaced) {
        if (smoothY) {
          yData = sgg(y, x[1] - x[0], {
            windowSize,
            polynomial,
            derivative: 0
          });
        }
        dY = sgg(y, x[1] - x[0], {
          windowSize,
          polynomial,
          derivative: 1
        });
        ddY = sgg(y, x[1] - x[0], {
          windowSize,
          polynomial,
          derivative: 2
        });
      } else {
        if (smoothY) {
          yData = sgg(y, x, {
            windowSize,
            polynomial,
            derivative: 0
          });
        }
        dY = sgg(y, x, {
          windowSize,
          polynomial,
          derivative: 1
        });
        ddY = sgg(y, x, {
          windowSize,
          polynomial,
          derivative: 2
        });
      }
      const minY = xMinValue(yData);
      const maxY = xMaxValue(yData);
      if (minY > maxY || minY === maxY) return [];
      const yThreshold = minY + (maxY - minY) * minMaxRatio;
      const dX = x[1] - x[0];
      let lastMax = null;
      let lastMin = null;
      let minddY = [];
      let intervalL = [];
      let intervalR = [];
      // By the intermediate value theorem We cannot find 2 consecutive maximum or minimum
      for (let i = 1; i < yData.length - 1; ++i) {
        if (dY[i] < dY[i - 1] && dY[i] <= dY[i + 1] || dY[i] <= dY[i - 1] && dY[i] < dY[i + 1]) {
          lastMin = {
            x: x[i],
            index: i
          };
          if (dX > 0 && lastMax !== null) {
            intervalL.push(lastMax);
            intervalR.push(lastMin);
          }
        }
        // Maximum in first derivative
        if (dY[i] >= dY[i - 1] && dY[i] > dY[i + 1] || dY[i] > dY[i - 1] && dY[i] >= dY[i + 1]) {
          lastMax = {
            x: x[i],
            index: i
          };
          if (dX < 0 && lastMin !== null) {
            intervalL.push(lastMax);
            intervalR.push(lastMin);
          }
        }
        // Minimum in second derivative
        if (ddY[i] < ddY[i - 1] && ddY[i] < ddY[i + 1]) {
          minddY.push(i);
        }
      }
      let lastK = -1;
      const peaks = [];
      for (const minddYIndex of minddY) {
        let deltaX = x[minddYIndex];
        let possible = -1;
        let k = lastK + 1;
        let minDistance = Number.POSITIVE_INFINITY;
        let currentDistance = 0;
        while (possible === -1 && k < intervalL.length) {
          currentDistance = Math.abs(deltaX - (intervalL[k].x + intervalR[k].x) / 2);
          if (currentDistance < (intervalR[k].x - intervalL[k].x) / 2) {
            possible = k;
            lastK = k;
          }
          ++k;
          // Not getting closer?
          if (currentDistance >= minDistance) {
            break;
          }
          minDistance = currentDistance;
        }
        if (possible !== -1) {
          if (yData[minddYIndex] > yThreshold) {
            let width = Math.abs(intervalR[possible].x - intervalL[possible].x);
            peaks.push({
              id: v4(),
              x: deltaX,
              y: yData[minddYIndex],
              width,
              index: minddYIndex,
              ddY: ddY[minddYIndex],
              inflectionPoints: {
                from: intervalL[possible],
                to: intervalR[possible]
              }
            });
          }
        }
      }
      if (realTopDetection) {
        optimizeTop({
          x,
          y: yData
        }, peaks);
      }
      peaks.forEach(peak => {
        if (!maxCriteria) {
          peak.y *= -1;
          peak.ddY = peak.ddY * -1;
        }
      });
      peaks.sort((a, b) => {
        return a.x - b.x;
      });
      return peaks;
    }

    /**
     * This function returns the sumOfShapes function
     * This function gives sumOfShapes access to the peak list and the associated data
     * @param parameters - parameters
     */
    function getSumOfShapes$1(internalPeaks) {
      return function sumOfShapes(parameters) {
        return x => {
          let totalY = 0;
          for (const peak of internalPeaks) {
            const peakX = parameters[peak.fromIndex];
            const y = parameters[peak.fromIndex + 1];
            for (let i = 2; i < parameters.length; i++) {
              //@ts-expect-error Not simply to solve the issue
              peak.shapeFct[peak.parameters[i]] = parameters[peak.fromIndex + i];
            }
            totalY += y * peak.shapeFct.fct(x - peakX);
          }
          return totalY;
        };
      };
    }

    /**
     * Asserts that value is truthy.
     *
     * @param value - Value to check.
     * @param message - Optional error message to throw.
     */
    function assert(value, message) {
      if (!value) {
        throw new Error(message ? message : 'unreachable');
      }
    }

    const DefaultParameters = {
      x: {
        init: peak => peak.x,
        min: (peak, peakShape) => peak.x - peakShape.fwhm * 2,
        max: (peak, peakShape) => peak.x + peakShape.fwhm * 2,
        gradientDifference: (peak, peakShape) => peakShape.fwhm * 2e-3
      },
      y: {
        init: peak => peak.y,
        min: peak => peak.y < 0 ? -1.1 : 0,
        max: peak => peak.y < 0 ? 0 : 1.1,
        gradientDifference: () => 1e-3
      },
      fwhm: {
        init: (peak, peakShape) => peakShape.fwhm,
        min: (peak, peakShape) => peakShape.fwhm * 0.25,
        max: (peak, peakShape) => peakShape.fwhm * 4,
        gradientDifference: (peak, peakShape) => peakShape.fwhm * 2e-3
      },
      mu: {
        init: (peak, peakShape) => peakShape.mu,
        min: () => 0,
        max: () => 1,
        gradientDifference: () => 0.01
      }
    };

    const properties$1 = ['init', 'min', 'max', 'gradientDifference'];
    /**
     * Return an array of internalPeaks that contains the exact init, min, max values based on the options
     * @param peaks
     * @param options
     * @returns
     */
    function getInternalPeaks(peaks, minMaxY, options = {}) {
      let index = 0;
      let internalPeaks = [];
      const {
        baseline: shiftValue = minMaxY.min
      } = options;
      const normalizedPeaks = peaks.map(peak => {
        return {
          ...peak,
          y: (peak.y - shiftValue) / minMaxY.range
        };
      });
      for (const peak of normalizedPeaks) {
        const {
          id,
          shape = options.shape ? options.shape : {
            kind: 'gaussian'
          }
        } = peak;
        const shapeFct = getShape1D(shape);
        const parameters = ['x', 'y', ...shapeFct.getParameters()];
        const propertiesValues = {
          min: [],
          max: [],
          init: [],
          gradientDifference: []
        };
        for (let parameter of parameters) {
          for (let property of properties$1) {
            // check if the property is specified in the peak
            let propertyValue = peak?.parameters?.[parameter]?.[property];
            if (propertyValue) {
              propertyValue = getNormalizedValue$1(propertyValue, parameter, property, minMaxY, options.baseline);
              propertiesValues[property].push(propertyValue);
              continue;
            }
            // check if there are some global option, it could be a number or a callback
            let generalParameterValue = options?.parameters?.[parameter]?.[property];
            if (generalParameterValue) {
              if (typeof generalParameterValue === 'number') {
                generalParameterValue = getNormalizedValue$1(generalParameterValue, parameter, property, minMaxY, options.baseline);
                propertiesValues[property].push(generalParameterValue);
                continue;
              } else {
                let value = generalParameterValue(peak);
                value = getNormalizedValue$1(value, parameter, property, minMaxY, options.baseline);
                propertiesValues[property].push(value);
                continue;
              }
            }
            // we just need to take the default parameters
            assert(DefaultParameters[parameter], `No default parameter for ${parameter}`);
            const defaultParameterValues = DefaultParameters[parameter][property];
            //@ts-expect-error should never happen
            propertiesValues[property].push(defaultParameterValues(peak, shapeFct));
          }
        }
        const fromIndex = index;
        const toIndex = fromIndex + parameters.length - 1;
        index += toIndex - fromIndex + 1;
        internalPeaks.push({
          id,
          shape,
          shapeFct,
          parameters,
          propertiesValues,
          fromIndex,
          toIndex
        });
      }
      return internalPeaks;
    }
    function getNormalizedValue$1(value, parameter, property, minMaxY, baseline) {
      if (parameter === 'y') {
        if (property === 'gradientDifference') {
          return value;
        } else {
          return baseline !== undefined ? (value - baseline) / minMaxY.range : (value - minMaxY.min) / minMaxY.range;
        }
      }
      return value;
    }

    function checkOptions(data, parameterizedFunction, options) {
      let {
        timeout,
        minValues,
        maxValues,
        initialValues,
        weights = 1,
        damping = 1e-2,
        dampingStepUp = 11,
        dampingStepDown = 9,
        maxIterations = 100,
        errorTolerance = 1e-7,
        centralDifference = false,
        gradientDifference = 10e-2,
        improvementThreshold = 1e-3
      } = options;
      if (damping <= 0) {
        throw new Error('The damping option must be a positive number');
      } else if (!data.x || !data.y) {
        throw new Error('The data parameter must have x and y elements');
      } else if (!isAnyArray(data.x) || data.x.length < 2 || !isAnyArray(data.y) || data.y.length < 2) {
        throw new Error('The data parameter elements must be an array with more than 2 points');
      } else if (data.x.length !== data.y.length) {
        throw new Error('The data parameter elements must have the same size');
      }
      if (!(initialValues && initialValues.length > 0)) {
        throw new Error('The initialValues option is mandatory and must be an array');
      }
      let parameters = initialValues;
      let nbPoints = data.y.length;
      let parLen = parameters.length;
      maxValues = maxValues || new Array(parLen).fill(Number.MAX_SAFE_INTEGER);
      minValues = minValues || new Array(parLen).fill(Number.MIN_SAFE_INTEGER);
      if (maxValues.length !== minValues.length) {
        throw new Error('minValues and maxValues must be the same size');
      }
      if (typeof gradientDifference === 'number') {
        gradientDifference = new Array(parameters.length).fill(gradientDifference);
      } else if (isAnyArray(gradientDifference)) {
        if (gradientDifference.length !== parLen) {
          gradientDifference = new Array(parLen).fill(gradientDifference[0]);
        }
      } else {
        throw new Error('gradientDifference should be a number or array with length equal to the number of parameters');
      }
      let filler;
      if (typeof weights === 'number') {
        let value = 1 / weights ** 2;
        filler = () => value;
      } else if (isAnyArray(weights)) {
        if (weights.length < data.x.length) {
          let value = 1 / weights[0] ** 2;
          filler = () => value;
        } else {
          filler = i => 1 / weights[i] ** 2;
        }
      } else {
        throw new Error('weights should be a number or array with length equal to the number of data points');
      }
      let checkTimeout;
      if (timeout !== undefined) {
        if (typeof timeout !== 'number') {
          throw new Error('timeout should be a number');
        }
        let endTime = Date.now() + timeout * 1000;
        checkTimeout = () => Date.now() > endTime;
      } else {
        checkTimeout = () => false;
      }
      let weightSquare = new Array(data.x.length);
      for (let i = 0; i < nbPoints; i++) {
        weightSquare[i] = filler(i);
      }
      return {
        checkTimeout,
        minValues,
        maxValues,
        parameters,
        weightSquare,
        damping,
        dampingStepUp,
        dampingStepDown,
        maxIterations,
        errorTolerance,
        centralDifference,
        gradientDifference,
        improvementThreshold
      };
    }

    /**
     * the sum of the weighted squares of the errors (or weighted residuals) between the data.y
     * and the curve-fit function.
     * @ignore
     * @param {{x:ArrayLike<number>, y:ArrayLike<number>}} data - Array of points to fit in the format [x1, x2, ... ], [y1, y2, ... ]
     * @param {ArrayLike<number>} parameters - Array of current parameter values
     * @param {function} parameterizedFunction - The parameters and returns a function with the independent variable as a parameter
     * @param {ArrayLike<number>} weightSquare - Square of weights
     * @return {number}
     */
    function errorCalculation(data, parameters, parameterizedFunction, weightSquare) {
      let error = 0;
      const func = parameterizedFunction(parameters);
      for (let i = 0; i < data.x.length; i++) {
        error += Math.pow(data.y[i] - func(data.x[i]), 2) / weightSquare[i];
      }
      return error;
    }

    /**
     * Difference of the matrix function over the parameters
     * @ignore
     * @param {{x:ArrayLike<number>, y:ArrayLike<number>}} data - Array of points to fit in the format [x1, x2, ... ], [y1, y2, ... ]
     * @param {ArrayLike<number>} evaluatedData - Array of previous evaluated function values
     * @param {Array<number>} params - Array of previous parameter values
     * @param {number|array} gradientDifference - The step size to approximate the jacobian matrix
     * @param {boolean} centralDifference - If true the jacobian matrix is approximated by central differences otherwise by forward differences
     * @param {function} paramFunction - The parameters and returns a function with the independent variable as a parameter
     * @return {Matrix}
     */
    function gradientFunction(data, evaluatedData, params, gradientDifference, paramFunction, centralDifference) {
      const nbParams = params.length;
      const nbPoints = data.x.length;
      let ans = Matrix.zeros(nbParams, nbPoints);
      let rowIndex = 0;
      for (let param = 0; param < nbParams; param++) {
        if (gradientDifference[param] === 0) continue;
        let delta = gradientDifference[param];
        let auxParams = params.slice();
        auxParams[param] += delta;
        let funcParam = paramFunction(auxParams);
        if (!centralDifference) {
          for (let point = 0; point < nbPoints; point++) {
            ans.set(rowIndex, point, (evaluatedData[point] - funcParam(data.x[point])) / delta);
          }
        } else {
          auxParams = params.slice();
          auxParams[param] -= delta;
          delta *= 2;
          let funcParam2 = paramFunction(auxParams);
          for (let point = 0; point < nbPoints; point++) {
            ans.set(rowIndex, point, (funcParam2(data.x[point]) - funcParam(data.x[point])) / delta);
          }
        }
        rowIndex++;
      }
      return ans;
    }

    /**
     * Matrix function over the samples
     * @ignore
     * @param {{x:ArrayLike<number>, y:ArrayLike<number>}} data - Array of points to fit in the format [x1, x2, ... ], [y1, y2, ... ]
     * @param {ArrayLike<number>} evaluatedData - Array of previous evaluated function values
     * @return {Matrix}
     */
    function matrixFunction(data, evaluatedData) {
      const m = data.x.length;
      let ans = new Matrix(m, 1);
      for (let point = 0; point < m; point++) {
        ans.set(point, 0, data.y[point] - evaluatedData[point]);
      }
      return ans;
    }
    /**
     * Iteration for Levenberg-Marquardt
     * @ignore
     * @param {{x:ArrayLike<number>, y:ArrayLike<number>}} data - Array of points to fit in the format [x1, x2, ... ], [y1, y2, ... ]
     * @param {Array<number>} params - Array of previous parameter values
     * @param {number} damping - Levenberg-Marquardt parameter
     * @param {number|array} gradientDifference - The step size to approximate the jacobian matrix
     * @param {boolean} centralDifference - If true the jacobian matrix is approximated by central differences otherwise by forward differences
     * @param {function} parameterizedFunction - The parameters and returns a function with the independent variable as a parameter
     */
    function step(data, params, damping, gradientDifference, parameterizedFunction, centralDifference, weights) {
      let value = damping;
      let identity = Matrix.eye(params.length, params.length, value);
      const func = parameterizedFunction(params);
      let evaluatedData = new Float64Array(data.x.length);
      for (let i = 0; i < data.x.length; i++) {
        evaluatedData[i] = func(data.x[i]);
      }
      let gradientFunc = gradientFunction(data, evaluatedData, params, gradientDifference, parameterizedFunction, centralDifference);
      let residualError = matrixFunction(data, evaluatedData);
      let inverseMatrix = inverse(identity.add(gradientFunc.mmul(gradientFunc.transpose().scale('row', {
        scale: weights
      }))));
      let jacobianWeightResidualError = gradientFunc.mmul(residualError.scale('row', {
        scale: weights
      }));
      let perturbations = inverseMatrix.mmul(jacobianWeightResidualError);
      return {
        perturbations,
        jacobianWeightResidualError
      };
    }

    /**
     * Curve fitting algorithm
     * @param {{x:ArrayLike<number>, y:ArrayLike<number>}} data - Array of points to fit in the format [x1, x2, ... ], [y1, y2, ... ]
     * @param {function} parameterizedFunction - Takes an array of parameters and returns a function with the independent variable as its sole argument
     * @param {object} options - Options object
     * @param {ArrayLike<number>} options.initialValues - Array of initial parameter values
     * @param {number|ArrayLike<number>} [options.weights = 1] - weighting vector, if the length does not match with the number of data points, the vector is reconstructed with first value.
     * @param {number} [options.damping = 1e-2] - Levenberg-Marquardt parameter, small values of the damping parameter λ result in a Gauss-Newton update and large
    values of λ result in a gradient descent update
     * @param {number} [options.dampingStepDown = 9] - factor to reduce the damping (Levenberg-Marquardt parameter) when there is not an improvement when updating parameters.
     * @param {number} [options.dampingStepUp = 11] - factor to increase the damping (Levenberg-Marquardt parameter) when there is an improvement when updating parameters.
     * @param {number} [options.improvementThreshold = 1e-3] - the threshold to define an improvement through an update of parameters
     * @param {number|ArrayLike<number>} [options.gradientDifference = 10e-2] - The step size to approximate the jacobian matrix
     * @param {boolean} [options.centralDifference = false] - If true the jacobian matrix is approximated by central differences otherwise by forward differences
     * @param {ArrayLike<number>} [options.minValues] - Minimum allowed values for parameters
     * @param {ArrayLike<number>} [options.maxValues] - Maximum allowed values for parameters
     * @param {number} [options.maxIterations = 100] - Maximum of allowed iterations
     * @param {number} [options.errorTolerance = 10e-3] - Minimum uncertainty allowed for each point.
     * @param {number} [options.timeout] - maximum time running before throw in seconds.
     * @return {{parameterValues: Array<number>, parameterError: number, iterations: number}}
     */
    function levenbergMarquardt(data, parameterizedFunction, options) {
      let {
        checkTimeout,
        minValues,
        maxValues,
        parameters,
        weightSquare,
        damping,
        dampingStepUp,
        dampingStepDown,
        maxIterations,
        errorTolerance,
        centralDifference,
        gradientDifference,
        improvementThreshold
      } = checkOptions(data, parameterizedFunction, options);
      let error = errorCalculation(data, parameters, parameterizedFunction, weightSquare);
      let optimalError = error;
      let optimalParameters = parameters.slice();
      let converged = error <= errorTolerance;
      let iteration = 0;
      for (; iteration < maxIterations && !converged; iteration++) {
        let previousError = error;
        let {
          perturbations,
          jacobianWeightResidualError
        } = step(data, parameters, damping, gradientDifference, parameterizedFunction, centralDifference, weightSquare);
        for (let k = 0; k < parameters.length; k++) {
          parameters[k] = Math.min(Math.max(minValues[k], parameters[k] - perturbations.get(k, 0)), maxValues[k]);
        }
        error = errorCalculation(data, parameters, parameterizedFunction, weightSquare);
        if (isNaN(error)) break;
        if (error < optimalError - errorTolerance) {
          optimalError = error;
          optimalParameters = parameters.slice();
        }
        let improvementMetric = (previousError - error) / perturbations.transpose().mmul(perturbations.mul(damping).add(jacobianWeightResidualError)).get(0, 0);
        if (improvementMetric > improvementThreshold) {
          damping = Math.max(damping / dampingStepDown, 1e-7);
        } else {
          damping = Math.min(damping * dampingStepUp, 1e7);
        }
        if (checkTimeout()) {
          throw new Error(`The execution time is over to ${options.timeout} seconds`);
        }
        converged = error <= errorTolerance;
      }
      return {
        parameterValues: optimalParameters,
        parameterError: optimalError,
        iterations: iteration
      };
    }

    /**
     * Preparata, F. P., & Shamos, M. I. (2012). Computational geometry: an introduction. Springer Science & Business Media.
     * @param {Array} x - The array with x coordinates of the points.
     * @param {Array} y - The array with y coordinates of the points.
     * @return {Array} The indices of the points of anticlockwise lower convex hull
     * @private
     */
    function antiLowerConvexHull(x, y) {
      if (x.length !== y.length) {
        throw new RangeError('X and Y vectors has different dimensions');
      }
      const nbPoints = x.length - 1;
      if (nbPoints === 0) return [0];
      if (nbPoints === 1) return [0, 1];
      let currentPoint = 0;
      let result = new Array(x.length).fill(true);
      while (true) {
        const a = currentPoint;
        const b = moveOn(currentPoint, nbPoints, result);
        const c = moveOn(moveOn(currentPoint, nbPoints, result), nbPoints, result);
        const det = x[c] * (y[a] - y[b]) + x[a] * (y[b] - y[c]) + x[b] * (y[c] - y[a]);
        const leftTurn = det >= 0;
        if (leftTurn) {
          currentPoint = b;
        } else {
          result[b] = false;
          currentPoint = moveBack(currentPoint, nbPoints, result);
        }
        if (c === nbPoints) break;
      }
      return result.map((item, index) => item === false ? false : index).filter(item => item !== false);
    }

    /**
     * @param {number} currentPoint - The index of the current point to make the move
     * @param {number} nbPoints - The total number of points in the array
     * @param {Array} vector - The array with the points
     * @return {number} the index of the point after the move
     * @private
     */

    function moveBack(currentPoint, nbPoints, vector) {
      let counter = currentPoint - 1;
      while (vector[counter] === false) counter--;
      return currentPoint === 0 ? nbPoints : counter;
    }
    function moveOn(currentPoint, nbPoints, vector) {
      let counter = currentPoint + 1;
      while (vector[counter] === false) counter++;
      return currentPoint === nbPoints ? 0 : counter;
    }

    /**
     * Performs a global optimization of required parameters
     * It will return an object containing:
     * - `minFunctionValue`: The minimum value found for the objetive function
     * - `optima`: Array of Array of values for all the variables where the function reach its minimum value
     * - `iterations`: Number of iterations performed in the process
     * - `finalState`: Internal state allowing to continue optimization (initialState)
     * @param {function} objectiveFunction Function to evaluate. It should accept an array of variables
     * @param {Array} lowerBoundaries Array containing for each variable the lower boundary
     * @param {Array} upperBoundaries Array containing for each variable the higher boundary
     * @param {Object} [options={}]
     * @param {number} [options.iterations] - Number of iterations.
     * @param {number} [options.epsilon] - Tolerance to choose best current value.
     * @param {number} [options.tolerance] - Minimum tollerance of the function.
     * @param {number} [options.tolerance2] - Minimum tollerance of the function.
     * @param {Object} [options.initialState={}}] - finalState of previous optimization.
     * @return {Object} {finalState, iterations, minFunctionValue}
     * */

    function direct(objectiveFunction, lowerBoundaries, upperBoundaries, options = {}) {
      const {
        iterations = 50,
        epsilon = 1e-4,
        tolerance = 1e-16,
        tolerance2 = 1e-12,
        initialState = {}
      } = options;
      if (objectiveFunction === undefined || lowerBoundaries === undefined || upperBoundaries === undefined) {
        throw new RangeError('There is something undefined');
      }
      lowerBoundaries = new Float64Array(lowerBoundaries);
      upperBoundaries = new Float64Array(upperBoundaries);
      if (lowerBoundaries.length !== upperBoundaries.length) {
        throw new Error('Lower bounds and Upper bounds for x are not of the same length');
      }

      //-------------------------------------------------------------------------
      //                        STEP 1. Initialization
      //-------------------------------------------------------------------------
      let n = lowerBoundaries.length;
      let diffBorders = upperBoundaries.map((x, i) => x - lowerBoundaries[i]);
      let {
        numberOfRectangles = 0,
        totalIterations = 0,
        unitaryCoordinates = [new Float64Array(n).fill(0.5)],
        middlePoint = new Float64Array(n).map((value, index) => {
          return lowerBoundaries[index] + unitaryCoordinates[0][index] * diffBorders[index];
        }),
        bestCurrentValue = objectiveFunction(middlePoint),
        fCalls = 1,
        smallerDistance = 0,
        edgeSizes = [new Float64Array(n).fill(0.5)],
        diagonalDistances = [Math.sqrt(n * Math.pow(0.5, 2))],
        functionValues = [bestCurrentValue],
        differentDistances = diagonalDistances,
        smallerValuesByDistance = [bestCurrentValue],
        choiceLimit = undefined
      } = initialState;
      if (initialState.originalCoordinates && initialState.originalCoordinates.length > 0) {
        bestCurrentValue = xMinValue(functionValues);
        choiceLimit = epsilon * Math.abs(bestCurrentValue) > 1e-8 ? epsilon * Math.abs(bestCurrentValue) : 1e-8;
        smallerDistance = getMinIndex(functionValues, diagonalDistances, choiceLimit, bestCurrentValue);
        unitaryCoordinates = initialState.originalCoordinates.slice();
        for (let j = 0; j < unitaryCoordinates.length; j++) {
          for (let i = 0; i < lowerBoundaries.length; i++) {
            unitaryCoordinates[j][i] = (unitaryCoordinates[j][i] - lowerBoundaries[i]) / diffBorders[i];
          }
        }
      }
      let iteration = 0;
      //-------------------------------------------------------------------------
      //                          Iteration loop
      //-------------------------------------------------------------------------

      while (iteration < iterations) {
        //----------------------------------------------------------------------
        //  STEP 2. Identify the set S of all potentially optimal rectangles
        //----------------------------------------------------------------------

        let S1 = [];
        let idx = differentDistances.findIndex(
        // eslint-disable-next-line no-loop-func
        e => e === diagonalDistances[smallerDistance]);
        let counter = 0;
        for (let i = idx; i < differentDistances.length; i++) {
          for (let f = 0; f < functionValues.length; f++) {
            if (functionValues[f] === smallerValuesByDistance[i] & diagonalDistances[f] === differentDistances[i]) {
              S1[counter++] = f;
            }
          }
        }
        let optimumValuesIndex, S3;
        if (differentDistances.length - idx > 1) {
          let a1 = diagonalDistances[smallerDistance];
          let b1 = functionValues[smallerDistance];
          let a2 = differentDistances[differentDistances.length - 1];
          let b2 = smallerValuesByDistance[differentDistances.length - 1];
          let slope = (b2 - b1) / (a2 - a1);
          let constant = b1 - slope * a1;
          let S2 = new Uint32Array(counter);
          counter = 0;
          for (let i = 0; i < S2.length; i++) {
            let j = S1[i];
            if (functionValues[j] <= slope * diagonalDistances[j] + constant + tolerance2) {
              S2[counter++] = j;
            }
          }
          let xHull = [];
          let yHull = [];
          for (let i = 0; i < counter; i++) {
            xHull.push(diagonalDistances[S2[i]]);
            yHull.push(functionValues[S2[i]]);
          }
          let lowerIndexHull = antiLowerConvexHull(xHull, yHull);
          S3 = [];
          for (let i = 0; i < lowerIndexHull.length; i++) {
            S3.push(S2[lowerIndexHull[i]]);
          }
        } else {
          S3 = S1.slice(0, counter);
        }
        optimumValuesIndex = S3;
        //--------------------------------------------------------------
        // STEPS 3,5: Select any rectangle j in S
        //--------------------------------------------------------------
        for (let k = 0; k < optimumValuesIndex.length; k++) {
          let j = optimumValuesIndex[k];
          let largerSide = xMaxValue(edgeSizes[j]);
          let largeSidesIndex = new Uint32Array(edgeSizes[j].length);
          counter = 0;
          for (let i = 0; i < edgeSizes[j].length; i++) {
            if (Math.abs(edgeSizes[j][i] - largerSide) < tolerance) {
              largeSidesIndex[counter++] = i;
            }
          }
          let delta = 2 * largerSide / 3;
          let bestFunctionValues = [];
          for (let r = 0; r < counter; r++) {
            let i = largeSidesIndex[r];
            let firstMiddleCenter = unitaryCoordinates[j].slice();
            let secondMiddleCenter = unitaryCoordinates[j].slice();
            firstMiddleCenter[i] += delta;
            secondMiddleCenter[i] -= delta;
            let firstMiddleValue = new Float64Array(firstMiddleCenter.length);
            let secondMiddleValue = new Float64Array(secondMiddleCenter.length);
            for (let i = 0; i < firstMiddleCenter.length; i++) {
              firstMiddleValue[i] = lowerBoundaries[i] + firstMiddleCenter[i] * diffBorders[i];
              secondMiddleValue[i] = lowerBoundaries[i] + secondMiddleCenter[i] * diffBorders[i];
            }
            let firstMinValue = objectiveFunction(firstMiddleValue);
            let secondMinValue = objectiveFunction(secondMiddleValue);
            fCalls += 2;
            bestFunctionValues.push({
              minValue: Math.min(firstMinValue, secondMinValue),
              index: r
            });
            // [Math.min(firstMinValue, secondMinValue), r];
            unitaryCoordinates.push(firstMiddleCenter, secondMiddleCenter);
            functionValues.push(firstMinValue, secondMinValue);
          }
          let b = bestFunctionValues.sort((a, b) => a.minValue - b.minValue);
          for (let r = 0; r < counter; r++) {
            let u = largeSidesIndex[b[r].index];
            let ix1 = numberOfRectangles + 2 * (b[r].index + 1) - 1;
            let ix2 = numberOfRectangles + 2 * (b[r].index + 1);
            edgeSizes[j][u] = delta / 2;
            edgeSizes[ix1] = edgeSizes[j].slice();
            edgeSizes[ix2] = edgeSizes[j].slice();
            diagonalDistances[j] = xNorm(edgeSizes[j]);
            diagonalDistances[ix1] = diagonalDistances[j];
            diagonalDistances[ix2] = diagonalDistances[j];
          }
          numberOfRectangles += 2 * counter;
        }

        //--------------------------------------------------------------
        //                  Update
        //--------------------------------------------------------------

        bestCurrentValue = xMinValue(functionValues);
        choiceLimit = epsilon * Math.abs(bestCurrentValue) > 1e-8 ? epsilon * Math.abs(bestCurrentValue) : 1e-8;
        smallerDistance = getMinIndex(functionValues, diagonalDistances, choiceLimit, bestCurrentValue);
        differentDistances = Array.from(new Set(diagonalDistances));
        differentDistances = differentDistances.sort((a, b) => a - b);
        smallerValuesByDistance = [];
        for (let i = 0; i < differentDistances.length; i++) {
          let minIndex;
          let minValue = Number.POSITIVE_INFINITY;
          for (let k = 0; k < diagonalDistances.length; k++) {
            if (diagonalDistances[k] === differentDistances[i]) {
              if (functionValues[k] < minValue) {
                minValue = functionValues[k];
                minIndex = k;
              }
            }
          }
          smallerValuesByDistance.push(functionValues[minIndex]);
        }
        for (let j = 0; j < functionValues.length; j++) {
          if (functionValues[j] === bestCurrentValue) {
            let temp = [];
            for (let i = 0; i < lowerBoundaries.length; i++) {
              temp.push(lowerBoundaries[i] + unitaryCoordinates[j][i] * diffBorders[i]);
            }
          }
        }
        iteration += 1;
      }
      //--------------------------------------------------------------
      //                  Saving results
      //--------------------------------------------------------------

      let result = {};
      result.minFunctionValue = bestCurrentValue;
      result.iterations = iteration;
      let originalCoordinates = [];
      for (let j = 0; j < numberOfRectangles + 1; j++) {
        let pair = [];
        for (let i = 0; i < lowerBoundaries.length; i++) {
          pair.push(lowerBoundaries[i] + unitaryCoordinates[j][i] * diffBorders[i]);
        }
        originalCoordinates.push(pair);
      }
      result.finalState = {
        numberOfRectangles,
        totalIterations: totalIterations += iterations,
        originalCoordinates,
        middlePoint,
        fCalls,
        smallerDistance,
        edgeSizes,
        diagonalDistances,
        functionValues,
        differentDistances,
        smallerValuesByDistance,
        choiceLimit
      };
      let minimizer = [];
      for (let i = 0; i < functionValues.length; i++) {
        if (functionValues[i] === bestCurrentValue) {
          minimizer.push(originalCoordinates[i]);
        }
      }
      result.optima = minimizer;
      return result;
    }
    function getMinIndex(functionValues, diagonalDistances, choiceLimit, bestCurrentValue) {
      let item = [];
      for (let i = 0; i < functionValues.length; i++) {
        item[i] = Math.abs(functionValues[i] - (bestCurrentValue + choiceLimit)) / diagonalDistances[i];
      }
      const min = xMinValue(item);
      let result = item.findIndex(x => x === min);
      return result;
    }

    function directOptimization$1(data, sumOfShapes, options) {
      const {
        minValues,
        maxValues,
        maxIterations,
        epsilon,
        tolerance,
        tolerance2,
        initialState
      } = options;
      const objectiveFunction = getObjectiveFunction$1(data, sumOfShapes);
      const result = direct(objectiveFunction, minValues, maxValues, {
        iterations: maxIterations,
        epsilon,
        tolerance,
        tolerance2,
        initialState
      });
      const {
        optima
      } = result;
      return {
        parameterError: result.minFunctionValue,
        iterations: result.iterations,
        parameterValues: optima[0]
      };
    }
    function getObjectiveFunction$1(data, sumOfShapes) {
      const {
        x,
        y
      } = data;
      const nbPoints = x.length;
      return parameters => {
        const fct = sumOfShapes(parameters);
        let error = 0;
        for (let i = 0; i < nbPoints; i++) {
          error += Math.pow(y[i] - fct(x[i]), 2);
        }
        return error;
      };
    }

    /** Algorithm to select the method.
     * @param optimizationOptions - Optimization options
     * @returns - The algorithm and optimization options
     */
    function selectMethod(optimizationOptions = {}) {
      let {
        kind = 'lm',
        options
      } = optimizationOptions;
      switch (kind) {
        case 'lm':
        case 'levenbergMarquardt':
          return {
            algorithm: levenbergMarquardt,
            optimizationOptions: {
              damping: 1.5,
              maxIterations: 100,
              errorTolerance: 1e-8,
              ...options
            }
          };
        case 'direct':
          {
            return {
              algorithm: directOptimization$1,
              optimizationOptions: {
                iterations: 20,
                epsilon: 1e-4,
                tolerance: 1e-16,
                tolerance2: 1e-12,
                initialState: {},
                ...options
              }
            };
          }
        default:
          throw new Error(`Unknown fitting algorithm`);
      }
    }

    /**
     * Fits a set of points to the sum of a set of bell functions.
     *
     * @param data - An object containing the x and y data to be fitted.
     * @param peaks - A list of initial parameters to be optimized. e.g. coming from a peak picking [{x, y, width}].
     * @param options - Options for optimize
     * @returns - An object with fitting error and the list of optimized parameters { parameters: [ {x, y, width} ], error } if the kind of shape is pseudoVoigt mu parameter is optimized.
     */
    function optimize(data, peaks, options = {}) {
      // rescale data
      let temp = xMinMaxValues(data.y);
      const minMaxY = {
        ...temp,
        range: temp.max - temp.min
      };
      const internalPeaks = getInternalPeaks(peaks, minMaxY, options);
      // need to rescale what is related to Y
      const {
        baseline: shiftValue = minMaxY.min
      } = options;
      let normalizedY = new Float64Array(data.y.length);
      for (let i = 0; i < data.y.length; i++) {
        normalizedY[i] = (data.y[i] - shiftValue) / minMaxY.range;
      }
      const nbParams = internalPeaks[internalPeaks.length - 1].toIndex + 1;
      const minValues = new Float64Array(nbParams);
      const maxValues = new Float64Array(nbParams);
      const initialValues = new Float64Array(nbParams);
      const gradientDifferences = new Float64Array(nbParams);
      let index = 0;
      for (const peak of internalPeaks) {
        for (let i = 0; i < peak.parameters.length; i++) {
          minValues[index] = peak.propertiesValues.min[i];
          maxValues[index] = peak.propertiesValues.max[i];
          initialValues[index] = peak.propertiesValues.init[i];
          gradientDifferences[index] = peak.propertiesValues.gradientDifference[i];
          index++;
        }
      }
      let {
        algorithm,
        optimizationOptions
      } = selectMethod(options.optimization);
      let sumOfShapes = getSumOfShapes$1(internalPeaks);
      let fitted = algorithm({
        x: data.x,
        y: normalizedY
      }, sumOfShapes, {
        minValues,
        maxValues,
        initialValues,
        gradientDifference: gradientDifferences,
        ...optimizationOptions
      });
      const fittedValues = fitted.parameterValues;
      let newPeaks = [];
      for (let peak of internalPeaks) {
        const {
          id,
          shape,
          parameters,
          fromIndex
        } = peak;
        let newPeak = {
          x: 0,
          y: 0,
          shape
        };
        if (id) {
          newPeak = {
            ...newPeak,
            id
          };
        }
        newPeak.x = fittedValues[fromIndex];
        newPeak.y = fittedValues[fromIndex + 1] * minMaxY.range + shiftValue;
        for (let i = 2; i < parameters.length; i++) {
          //@ts-expect-error should be fixed once
          newPeak.shape[parameters[i]] = fittedValues[fromIndex + i];
        }
        newPeaks.push(newPeak);
      }
      return {
        error: fitted.parameterError,
        iterations: fitted.iterations,
        peaks: newPeaks
      };
    }

    const {
      parse: parse$6,
      stringify: stringify$6
    } = JSON;
    /**
     * add missing property if it does not exist in the peak,
     * if shape exists but fwhm doesn't, it will be calculated from peak.width
     */
    function addMissingShape(peaks, options = {}) {
      const {
        shape = {
          kind: 'gaussian'
        },
        output = parse$6(stringify$6(peaks))
      } = options;
      let shapeInstance = getShape1D(shape);
      return output.map(peak => {
        if (hasShape(peak)) {
          if (!('fwhm' in peak.shape)) {
            const shapeInstance = getShape1D(peak.shape);
            peak.shape.fwhm = shapeInstance.widthToFWHM(peak.width);
          }
          return peak;
        }
        return {
          ...peak,
          shape: {
            fwhm: shapeInstance.widthToFWHM(peak.width),
            ...shape
          }
        };
      });
    }
    function hasShape(peak) {
      return 'shape' in peak;
    }

    /**
     * Group peaks based on factor
     * In order to group peaks we only need the x and width value. This means that
     * in the current implementation we don't take into account the asymmetry of peaks
     */
    function groupPeaks(peaks, options = {}) {
      if (peaks && peaks.length === 0) return [];
      const {
        factor = 1
      } = options;
      peaks = JSON.parse(JSON.stringify(peaks));
      peaks.sort((a, b) => a.x - b.x);
      let previousPeak = peaks[0];
      let currentGroup = [previousPeak];
      let groups = [currentGroup];
      for (let i = 1; i < peaks.length; i++) {
        const peak = peaks[i];
        if ((peak.x - previousPeak.x) / ((peak.width + previousPeak.width) / 2) <= factor) {
          currentGroup.push(peak);
        } else {
          currentGroup = [peak];
          groups.push(currentGroup);
        }
        previousPeak = peak;
      }
      return groups;
    }

    /**
     * Optimize the position (x), max intensity (y), full width at half maximum (fwhm)
     * and the ratio of gaussian contribution (mu) if it's required. It currently supports three kind of shapes: gaussian, lorentzian and pseudovoigt
     * @param data - An object containing the x and y data to be fitted.
     * @param peakList - A list of initial parameters to be optimized. e.g. coming from a peak picking [{x, y, width}].
     */
    function optimizePeaksWithLogs(data, peakList, options = {}) {
      const {
        fromTo = {},
        baseline,
        shape = {
          kind: 'gaussian'
        },
        groupingFactor = 1,
        factorLimits = 2,
        optimization = {
          kind: 'lm',
          options: {
            timeout: 10
          }
        }
      } = options;
      /*
      The optimization algorithm will take some group of peaks.
      We can not simply optimize everything because there would be too many variables to optimize
      and it would be too time consuming.
      */
      let groups = groupPeaks(peakList, {
        factor: groupingFactor
      });
      let logs = [];
      let results = [];
      groups.forEach(peakGroup => {
        const start = Date.now();
        // In order to make optimization we will add fwhm and shape on all the peaks
        const peaks = addMissingShape(peakGroup, {
          shape
        });
        const firstPeak = peaks[0];
        const lastPeak = peaks[peaks.length - 1];
        const {
          from = firstPeak.x - firstPeak.width * factorLimits,
          to = lastPeak.x + lastPeak.width * factorLimits
        } = fromTo;
        const {
          fromIndex,
          toIndex
        } = xGetFromToIndex(data.x, {
          from,
          to
        });
        const x = data.x instanceof Float64Array ? data.x.subarray(fromIndex, toIndex) : data.x.slice(fromIndex, toIndex);
        const y = data.y instanceof Float64Array ? data.y.subarray(fromIndex, toIndex) : data.y.slice(fromIndex, toIndex);
        const log = {
          range: {
            from,
            to
          },
          parameters: optimization,
          groupSize: peakGroup.length,
          time: Date.now() - start
        };
        if (x.length > 5) {
          const {
            iterations,
            error,
            peaks: optimizedPeaks
          } = optimize({
            x,
            y
          }, peaks, {
            shape,
            baseline,
            optimization
          });
          for (let i = 0; i < peaks.length; i++) {
            results.push({
              ...optimizedPeaks[i],
              width: getShape1D(peaks[i].shape).fwhmToWidth(optimizedPeaks[i].shape.fwhm)
            });
          }
          logs.push({
            ...log,
            iterations,
            error,
            message: 'optimization successful'
          });
        } else {
          results.push(...peaks);
          logs.push({
            ...log,
            iterations: 0,
            message: 'x length too small for optimization'
          });
        }
      });
      return {
        logs,
        optimizedPeaks: results
      };
    }

    /**
     * Optimize the position (x), max intensity (y), full width at half maximum (fwhm)
     * and the ratio of gaussian contribution (mu) if it's required. It currently supports three kind of shapes: gaussian, lorentzian and pseudovoigt
     * @param data - An object containing the x and y data to be fitted.
     * @param peakList - A list of initial parameters to be optimized. e.g. coming from a peak picking [{x, y, width}].
     */
    function optimizePeaks(data, peakList, options = {}) {
      return optimizePeaksWithLogs(data, peakList, options).optimizedPeaks;
    }

    const {
      parse: parse$5,
      stringify: stringify$5
    } = JSON;
    function addMissingIDs$1(peaks, options = {}) {
      const {
        output = parse$5(stringify$5(peaks))
      } = options;
      for (const peak of output) {
        if (!('id' in peak)) {
          peak.id = v4();
        }
      }
      return output;
    }

    function joinBroadPeaks(peakList, options = {}) {
      let {
        shape = {
          kind: 'gaussian'
        },
        optimization = {
          kind: 'lm',
          options: {
            timeout: 10
          }
        },
        broadWidth = 0.25,
        broadRatio = 0.0025
      } = options;
      let max = 0;
      let maxI = 0;
      let count = 1;
      const broadLines = [];
      if (peakList.length < 2) {
        return addMissingIDs$1(addMissingShape(peakList.map(getGSDPeakOptimizedStructure), {
          shape
        }));
      }
      let maxDdy = peakList[0].ddY;
      for (let i = 1; i < peakList.length; i++) {
        if (Math.abs(peakList[i].ddY) > maxDdy) maxDdy = Math.abs(peakList[i].ddY);
      }
      const newPeaks = [];
      for (const peak of peakList) {
        if (Math.abs(peak.ddY) <= broadRatio * maxDdy) {
          broadLines.push(peak);
        } else {
          newPeaks.push(getGSDPeakOptimizedStructure(peak));
        }
      }
      //@ts-expect-error Push a feke peak
      broadLines.push({
        x: Number.MAX_VALUE,
        y: 0
      });
      let candidates = {
        x: [broadLines[0].x],
        y: [broadLines[0].y]
      };
      let indexes = [0];
      for (let i = 1; i < broadLines.length; i++) {
        if (Math.abs(broadLines[i - 1].x - broadLines[i].x) < broadWidth) {
          candidates.x.push(broadLines[i].x);
          candidates.y.push(broadLines[i].y);
          if (broadLines[i].y > max) {
            max = broadLines[i].y;
            maxI = i;
          }
          indexes.push(i);
          count++;
        } else {
          if (count > 2) {
            let fitted = optimizePeaks(candidates, [{
              id: v4(),
              x: broadLines[maxI].x,
              y: max,
              width: candidates.x[0] - candidates.x[candidates.x.length - 1]
            }], {
              shape,
              optimization
            });
            newPeaks.push(fitted[0]);
          } else {
            // Put back the candidates to the peak list
            for (const index of indexes) {
              newPeaks.push(getGSDPeakOptimizedStructure(broadLines[index]));
            }
          }
          candidates = {
            x: [broadLines[i].x],
            y: [broadLines[i].y]
          };
          indexes = [i];
          max = broadLines[i].y;
          maxI = i;
          count = 1;
        }
      }
      newPeaks.sort((a, b) => {
        return a.x - b.x;
      });
      return addMissingIDs$1(newPeaks, {
        output: newPeaks
      });
    }
    function getGSDPeakOptimizedStructure(peak) {
      const {
        id,
        shape,
        x,
        y,
        width
      } = peak;
      let newPeak = {
        x,
        y,
        width,
        shape
      };
      if (id) newPeak.id = id;
      return newPeak;
    }

    const {
      parse: parse$4,
      stringify: stringify$4
    } = JSON;
    /**
     * Append 2 properties to the peaks, shape and fwhm
     */
    function setShape(peaks, options = {}) {
      let {
        shape = {
          kind: 'gaussian'
        },
        output = parse$4(stringify$4(peaks))
      } = options;
      let shapeInstance = getShape1D(shape);
      return output.map(peak => ({
        ...peak,
        shape: {
          fwhm: shapeInstance.widthToFWHM(peak.width),
          ...shape
        }
      }));
    }

    function peakToXY(peak, options) {
      const newPeak = addMissingShape([peak])[0];
      const factor = getShape1D(newPeak.shape).getFactor();
      const {
        from = newPeak.x - peak.width * factor / options.frequency,
        to = newPeak.x + peak.width * factor / options.frequency
      } = options;
      return peaksToXY([peak], {
        ...options,
        from,
        to
      });
    }

    /**
     * Created by acastillo on 9/3/16.
     */

    class TreeSet {
      constructor(compatator) {
        this.length = 0;
        this.elements = [];
        if (compatator) this.compatator = compatator;else this.compatator = function (a, b) {
          return a - b;
        };
      }
      size() {
        return this.elements.length;
      }
      last() {
        return this.elements[this.length - 1];
      }
      first() {
        return this.elements[0];
      }
      isEmpty() {
        return this.size() === 0;
      }
      pollLast() {
        if (this.length > 0) {
          this.length--;
          return this.elements.splice(this.length, 1);
        }
        return null;
      }
      pollFirst() {
        if (this.length > 0) {
          this.length--;
          return this.elements.splice(0, 1);
        }
        return null;
      }
      add(element) {
        let index = this.binarySearch(element);
        if (index < 0) {
          index = -index - 1;
        }
        this.elements.splice(index, 0, element);
        this.length++;
      }

      /**
       * Performs a binary search of value in array
       * @param {number[]} array - Array in which value will be searched. It must be sorted.
       * @param {number} value - Value to search in array
       * @return {number} If value is found, returns its index in array. Otherwise, returns a negative number indicating where the value should be inserted: -(index + 1)
       */
      binarySearch(value) {
        var low = 0;
        var high = this.elements.length - 1;
        while (low <= high) {
          var mid = low + high >>> 1;
          var midValue = this.elements[mid];
          var cmp = this.compatator(midValue, value);
          if (cmp < 0) {
            low = mid + 1;
          } else if (cmp > 0) {
            high = mid - 1;
          } else {
            return mid;
          }
        }
        return -(low + 1);
      }
    }
    var src$2 = TreeSet;
    var TreeSet$1 = src$2;

    function createMapPossibleAssignments(props) {
      const {
        restrictionByCS,
        predictions,
        targets,
        useIntegrationRestriction
      } = props;
      const {
        tolerance: toleranceCS,
        chemicalShiftRestriction
      } = restrictionByCS;
      const errorAbs = Math.abs(toleranceCS);
      const expandMap = {};
      for (const diaID in predictions) {
        const prediction = predictions[diaID];
        if (prediction.error) prediction.error = Math.abs(prediction.error);
        expandMap[diaID] = [];
        if (targets) {
          for (const targetID in targets) {
            const target = targets[targetID];
            const {
              nbAtoms
            } = prediction;
            const {
              integration
            } = target;
            const couldBeAssigned = useIntegrationRestriction ? integration > 0 ? nbAtoms - integration < 1 : true : true;
            if (couldBeAssigned) {
              if (!chemicalShiftRestriction || typeof prediction.delta === 'undefined') {
                // Chemical shift is not a restriction
                expandMap[diaID].push(targetID);
              } else {
                let error = errorAbs;
                if (prediction.error) {
                  error = Math.max(error, prediction.error);
                }
                const delta = target.signals && target.signals.length > 0 ? target.signals[0].delta : (target.to + target.from) / 2;
                const distAfterLimit = Math.abs(prediction.delta - delta - errorAbs);
                if (distAfterLimit < 4 * errorAbs) {
                  expandMap[diaID].push(targetID);
                }
              }
            }
          }
        }
        expandMap[diaID].push('*');
      }
      return expandMap;
    }

    function partialScore$1(partial, options) {
      const {
        useIntegrationRestriction,
        diaIDPeerPossibleAssignment,
        nbAllowedUnAssigned,
        restrictionByCS,
        predictions,
        targets
      } = options;
      const {
        useChemicalShiftScore
      } = restrictionByCS;
      let countStars = 0;
      const totalPartial = partial.length;
      const partialInverse = {};
      for (let i = 0; i < partial.length; i++) {
        const targetID = partial[i];
        if (targetID && targetID !== '*') {
          if (!partialInverse[targetID]) {
            partialInverse[targetID] = [];
          }
          partialInverse[targetID].push(diaIDPeerPossibleAssignment[i]);
        }
        if (targetID === '*') countStars++;
      }
      if (countStars > nbAllowedUnAssigned) return 0;
      const activeDomainOnTarget = Object.keys(partialInverse);
      if (activeDomainOnTarget.length === 0) {
        return 0;
      }
      if (useIntegrationRestriction) {
        for (const targetID of activeDomainOnTarget) {
          const targetToSource = partialInverse[targetID];
          let total = 0;
          for (const diaID of targetToSource) {
            const prediction = predictions[diaID];
            total += prediction.allHydrogens;
          }
          const {
            integration
          } = targets[targetID];
          if (total - integration >= 0.5) {
            return 0;
          }
        }
      }
      //chemical shift score
      const chemicalShiftScore = useChemicalShiftScore ? chemicalShiftScoring(partial, options) : 1;
      const penaltyByStarts = countStars / totalPartial;
      return chemicalShiftScore - penaltyByStarts;
    }
    function chemicalShiftScoring(partial, options) {
      const {
        tolerance
      } = options.restrictionByCS;
      const {
        diaIDPeerPossibleAssignment,
        predictions,
        targets
      } = options;
      let chemicalShiftScore = 0;
      let count = 0;
      for (let index = 0; index < partial.length; index++) {
        const targetID = partial[index];
        if (targetID && targetID !== '*') {
          count++;
          const diaID = diaIDPeerPossibleAssignment[index];
          const source = predictions[diaID];
          const target = targets[targetID];
          let error = tolerance;
          if (source.error) {
            error = Math.max(source.error, tolerance);
          }
          if (typeof source.delta === 'undefined') {
            // Chemical shift is not a restriction
            chemicalShiftScore += 1;
          } else {
            const delta = target.signals && target.signals.length > 0 ? target.signals[0].delta : (target.to + target.from) / 2;
            let diff = Math.abs(source.delta - delta);
            if (diff < error) {
              chemicalShiftScore += 1;
            } else {
              diff = Math.abs(diff - error);
              chemicalShiftScore += -0.25 / error * diff + 1;
            }
          }
        }
      }
      if (count > 0) {
        chemicalShiftScore /= count;
      }
      return chemicalShiftScore;
    }

    function exploreTreeRec(props, currentIndex, partial, store) {
      const {
        nSources,
        restrictionByCS,
        timeout,
        timeStart,
        maxSolutions,
        targets,
        predictions,
        lowerBoundScore,
        nbAllowedUnAssigned,
        possibleAssignmentMap,
        useIntegrationRestriction,
        diaIDPeerPossibleAssignment
      } = props;
      if (Date.now() - timeStart > timeout) {
        return store;
      }
      const diaID = diaIDPeerPossibleAssignment[currentIndex];
      const possibleAssignments = possibleAssignmentMap[diaID];
      for (const targetID of possibleAssignments) {
        partial[currentIndex] = targetID;
        const score = partialScore$1(partial, {
          useIntegrationRestriction,
          diaIDPeerPossibleAssignment,
          nbAllowedUnAssigned,
          restrictionByCS,
          predictions,
          targets
        });
        if (score === 0) {
          if (targetID === '*') {
            partial[currentIndex] = null;
          }
          continue;
        }
        if (currentIndex === nSources - 1 && score >= lowerBoundScore) {
          addSolution$1(store, {
            predictions,
            partial,
            score,
            maxSolutions
          });
        } else if (currentIndex < nSources - 1) {
          exploreTreeRec({
            nSources,
            restrictionByCS,
            timeout,
            timeStart,
            maxSolutions,
            targets,
            predictions,
            lowerBoundScore,
            nbAllowedUnAssigned,
            possibleAssignmentMap,
            useIntegrationRestriction,
            diaIDPeerPossibleAssignment
          }, currentIndex + 1, JSON.parse(JSON.stringify(partial)), store);
        }
      }
    }
    function addSolution$1(store, props) {
      const {
        score,
        maxSolutions,
        partial,
        predictions
      } = props;
      store.nSolutions++;
      const solution = {
        assignment: JSON.parse(JSON.stringify(partial)),
        score: score / doubleAssignmentPenalty$1(partial, predictions)
      };
      if (store.nSolutions >= maxSolutions) {
        if (solution.score > store.solutions.last().score) {
          store.solutions.pollLast();
          store.solutions.add(solution);
        }
      } else {
        store.solutions.add(solution);
        store.nSolutions++;
      }
    }
    function doubleAssignmentPenalty$1(partial, predictions) {
      const nbSources = Object.keys(predictions).length;
      const assignments = new Set(partial);
      const nbDoubleAssignment = nbSources - assignments.size;
      return nbDoubleAssignment > 0 ? 2 * nbDoubleAssignment : 1;
    }

    const comparator$1 = (a, b) => {
      return b.score - a.score;
    };
    async function buildAssignments$1(props) {
      const {
        restrictionByCS = {},
        useIntegrationRestriction,
        timeout,
        minScore,
        nbAllowedUnAssigned,
        maxSolutions,
        targets,
        joinedSignals
      } = props;
      const {
        tolerance = 1,
        useChemicalShiftScore = false,
        chemicalShiftRestriction = true
      } = restrictionByCS;
      let store = {
        solutions: new TreeSet$1(comparator$1),
        nSolutions: 0
      };
      const nSources = joinedSignals.length;
      const predictions = {};
      for (const prediction of joinedSignals) {
        const diaID = prediction.diaIDs[0];
        const index = prediction.atoms[0];
        predictions[diaID] = {
          ...prediction,
          diaIDIndex: index,
          allHydrogens: prediction.nbAtoms
        };
      }
      const possibleAssignmentMap = createMapPossibleAssignments({
        restrictionByCS: {
          tolerance,
          useChemicalShiftScore,
          chemicalShiftRestriction
        },
        useIntegrationRestriction,
        predictions,
        targets
      });
      const diaIDPeerPossibleAssignment = Object.keys(possibleAssignmentMap);
      const partial = fillPartial$1(nSources);
      store = {
        solutions: new TreeSet$1(comparator$1),
        nSolutions: 0
      };
      const timeStart = Date.now();
      exploreTreeRec({
        nSources,
        restrictionByCS: {
          tolerance,
          useChemicalShiftScore,
          chemicalShiftRestriction
        },
        timeout,
        timeStart,
        targets,
        predictions,
        maxSolutions,
        lowerBoundScore: minScore,
        nbAllowedUnAssigned,
        possibleAssignmentMap,
        diaIDPeerPossibleAssignment,
        useIntegrationRestriction
      }, 0, partial, store);
      const assignments = [];
      for (const solution of store.solutions.elements) {
        const {
          assignment,
          score
        } = solution;
        const currentAssignment = JSON.parse(JSON.stringify(targets));
        for (let i = 0; i < assignment.length; i++) {
          const range = currentAssignment[assignment[i]];
          if (!range.diaIDs) range.diaIDs = [];
          if (assignment[i]) range.diaIDs.push(diaIDPeerPossibleAssignment[i]);
        }
        assignments.push({
          score,
          assignment: Object.values(currentAssignment)
        });
      }
      return assignments;
    }
    function fillPartial$1(nSources, value = null) {
      const partial = new Array(nSources);
      for (let i = 0; i < nSources; i++) {
        partial[i] = value;
      }
      return partial;
    }

    function checkAtomsAndDiaIDs$1(signals) {
      for (const signal of signals) {
        if (!signal.atoms) throw new Error('signal has not atoms property');
        if (!signal.diaIDs) throw new Error('signal has not diaIDs property');
        if (!signal.nbAtoms) throw new Error('signal has not nbAtoms property');
      }
    }
    function checkForIntegration(ranges) {
      for (const range of ranges) {
        if (range.integration === undefined) {
          throw new Error('ranges has not integration property');
        }
      }
    }
    async function get1HAssignments(ranges, molecule, options = {}) {
      const {
        restrictionByCS,
        minScore = 1,
        maxSolutions = 10,
        nbAllowedUnAssigned = 0,
        timeout = 6000,
        predictionOptions = {}
      } = options;
      if (!molecule) {
        throw new Error('It is needed a OCL molecule instance to assign');
      }
      const {
        spectra
      } = await predict(molecule, {
        predictOptions: {
          H: predictionOptions
        }
      });
      const joinedSignals = spectra.proton?.joinedSignals || [];
      checkForIntegration(ranges);
      checkAtomsAndDiaIDs$1(joinedSignals);
      const targets = {};
      for (const range of ranges) {
        const {
          id = v4()
        } = range;
        targets[id] = JSON.parse(JSON.stringify(range));
      }
      return buildAssignments$1({
        restrictionByCS,
        timeout,
        minScore,
        nbAllowedUnAssigned,
        maxSolutions,
        targets,
        joinedSignals,
        useIntegrationRestriction: true
      });
    }

    function checkAtomsAndDiaIDs(signals) {
      for (const signal of signals) {
        if (!signal.atoms) throw new Error('signal has not atoms property');
        if (!signal.diaIDs) throw new Error('signal has not diaIDs property');
        if (!signal.nbAtoms) throw new Error('signal has not nbAtoms property');
      }
    }
    function checkIntegration(ranges) {
      for (const range of ranges) {
        if (range.integration === undefined) range.integration = 0;
      }
      return ranges;
    }
    async function get13CAssignments(ranges, molecule, options = {}) {
      const {
        restrictionByCS = {},
        minScore = 1,
        maxSolutions = 10,
        nbAllowedUnAssigned = 0,
        timeout = 6000,
        predictionOptions = {}
      } = options;
      if (!molecule) {
        throw new Error('It is needed a OCL molecule instance to assign');
      }
      const {
        spectra
      } = await predict(molecule, {
        predictOptions: {
          C: predictionOptions
        }
      });
      const joinedSignals = spectra.carbon?.joinedSignals || [];
      checkAtomsAndDiaIDs(joinedSignals);
      const copyRanges = checkIntegration(ranges);
      const targets = {};
      for (const range of copyRanges) {
        const {
          id = v4()
        } = range;
        targets[id] = JSON.parse(JSON.stringify(range));
      }
      return buildAssignments$1({
        restrictionByCS,
        timeout,
        minScore,
        nbAllowedUnAssigned,
        maxSolutions,
        targets,
        joinedSignals,
        useIntegrationRestriction: false
      });
    }

    /**
     * Algorithm that finds the shortest distance from one node to the other
     * @param {Matrix} adjMatrix - A squared adjacency matrix
     * @return {Matrix} - Distance from a node to the other, -1 if the node is unreachable
     */
    function floydWarshall(adjMatrix) {
      if (Matrix.isMatrix(adjMatrix) && adjMatrix.columns !== adjMatrix.rows) {
        throw new TypeError('The adjacency matrix should be squared');
      }
      const numVertices = adjMatrix.columns;
      let distMatrix = new Matrix(numVertices, numVertices);
      distMatrix.apply((row, column) => {
        // principal diagonal is 0
        if (row === column) {
          distMatrix.set(row, column, 0);
        } else {
          let val = adjMatrix.get(row, column);
          if (val || Object.is(val, -0)) {
            // edges values remain the same
            distMatrix.set(row, column, val);
          } else {
            // 0 values become infinity
            distMatrix.set(row, column, Number.POSITIVE_INFINITY);
          }
        }
      });
      for (let k = 0; k < numVertices; ++k) {
        for (let i = 0; i < numVertices; ++i) {
          for (let j = 0; j < numVertices; ++j) {
            let dist = distMatrix.get(i, k) + distMatrix.get(k, j);
            if (distMatrix.get(i, j) > dist) {
              distMatrix.set(i, j, dist);
            }
          }
        }
      }
      // When there's no connection the value is -1
      distMatrix.apply((row, column) => {
        if (distMatrix.get(row, column) === Number.POSITIVE_INFINITY) {
          distMatrix.set(row, column, -1);
        }
      });
      return distMatrix;
    }

    /**
     * Returns a connectivity matrix
     * @param {import('openchemlib').Molecule} molecule
     * @param {object} [options={}]
     * @param {boolean} [options.pathLength=false] get the path length between atoms
     * @param {boolean} [options.mass=false] set the nominal mass of the atoms on diagonal
     * @param {boolean} [options.atomicNo=false] set the atomic number of the atom on diagonal
     * @param {boolean} [options.negativeAtomicNo=false] set the atomic number * -1 of the atom on diagonal
     * @param {boolean} [options.sdt=false] set 1, 2 or 3 depending if single, double or triple bond
     * @param {boolean} [options.sdta=false] set 1, 2, 3 or 4 depending if single, double, triple or aromatic  bond
     */
    function getConnectivityMatrix(molecule, options = {}) {
      const OCL = molecule.getOCL();
      molecule.ensureHelperArrays(OCL.Molecule.cHelperNeighbours);
      const nbAtoms = molecule.getAllAtoms();
      let result = new Array(nbAtoms).fill();
      result = result.map(() => new Array(nbAtoms).fill(0));
      if (!options.pathLength) {
        if (options.atomicNo) {
          for (let i = 0; i < nbAtoms; i++) {
            result[i][i] = molecule.getAtomicNo(i);
          }
        } else if (options.negativeAtomicNo) {
          for (let i = 0; i < nbAtoms; i++) {
            result[i][i] = -molecule.getAtomicNo(i);
          }
        } else if (options.mass) {
          for (let i = 0; i < nbAtoms; i++) {
            result[i][i] = OCL.Molecule.cRoundedMass[molecule.getAtomicNo(i)];
          }
        } else {
          for (let i = 0; i < nbAtoms; i++) {
            result[i][i] = 1;
          }
        }
      }
      if (options.sdt) {
        for (let i = 0; i < nbAtoms; i++) {
          const l = molecule.getAllConnAtoms(i);
          for (let j = 0; j < l; j++) {
            result[i][molecule.getConnAtom(i, j)] = molecule.getConnBondOrder(i, j);
          }
        }
      } else if (options.sdta) {
        for (let i = 0; i < nbAtoms; i++) {
          const l = molecule.getAllConnAtoms(i);
          for (let j = 0; j < l; j++) {
            const bondNumber = molecule.getConnBond(i, j);
            if (molecule.isAromaticBond(bondNumber)) {
              result[i][molecule.getConnAtom(i, j)] = 4;
            } else {
              result[i][molecule.getConnAtom(i, j)] = molecule.getConnBondOrder(i, j);
            }
          }
        }
      } else {
        for (let i = 0; i < nbAtoms; i++) {
          const l = molecule.getAllConnAtoms(i);
          for (let j = 0; j < l; j++) {
            result[i][molecule.getConnAtom(i, j)] = 1;
          }
        }
      }
      if (options.pathLength) {
        result = floydWarshall(new Matrix(result)).to2DArray();
      }
      return result;
    }

    /**
     *
     * @param {import('openchemlib').Molecule} molecule An instance of a molecule
     * @param {object} [options={}]
     * @param {object} [options.OCL] openchemlib library
     */
    function makeRacemic(molecule) {
      const {
        Molecule
      } = molecule.getOCL();
      // if we don't calculate this we have 2 epimers
      molecule.ensureHelperArrays(Molecule.cHelperCIP);
      // we need to make one group "AND" for chiral (to force to racemic, this means diastereotopic and not enantiotopic)
      for (let i = 0; i < molecule.getAllAtoms(); i++) {
        if (molecule.getAtomParity(i) !== Molecule.cAtomParityNone) {
          molecule.setAtomESR(i, Molecule.cESRTypeAnd, 0); // changed to group 0; TLS 9.Nov.2015
        }
      }
      // after the change we need to recalculate the CIP
      molecule.ensureHelperArrays(Molecule.cHelperCIP);
    }

    let xAtomicNumber = 0;
    /**
     * Returns the atomic number of the X atom
     * @param {import('openchemlib').Molecule} molecule An instance of a molecule
     * @returns
     */
    function getXAtomicNumber(molecule) {
      if (!xAtomicNumber) {
        const OCL = molecule.getOCL();
        xAtomicNumber = OCL.Molecule.getAtomicNoFromLabel('X', OCL.Molecule.cPseudoAtomX);
      }
      return xAtomicNumber;
    }

    /**
     * Tag an atom to be able to visualize it
     */
    function tagAtom(molecule, iAtom) {
      const customLabel = `${molecule.getAtomLabel(iAtom)}*`;
      molecule.setAtomCustomLabel(iAtom, customLabel);
      if (molecule.getAtomicNo(iAtom) === 1) {
        molecule.setAtomicNo(iAtom, getXAtomicNumber(molecule));
      } else {
        // we can not use X because we would have problems with valencies if it is
        // expanded hydrogens or not
        // we can not only use a custom label because it does not count for the canonisation
        molecule.setAtomMass(iAtom, molecule.getAtomMass(iAtom) + 5);
      }
      return customLabel;
    }

    function getCanonizedDiaIDs(diaMol) {
      const heterotopicSymmetryRanks = diaMol.heterotopicSymmetryRanks;
      const moleculeWithH = diaMol.moleculeWithH;
      const finalRanks = diaMol.finalRanks;
      const canonizedDiaIDs = new Array(moleculeWithH.getAllAtoms());
      moleculeWithH.ensureHelperArrays(
      //@ts-expect-error TODO
      diaMol.Molecule.cHelperSymmetryStereoHeterotopicity);
      const cache = {};
      for (let i = 0; i < diaMol.moleculeWithH.getAllAtoms(); i++) {
        const rank = heterotopicSymmetryRanks[i];
        if (rank && cache[rank]) {
          canonizedDiaIDs[finalRanks[i]] = cache[rank].diaID;
          continue;
        }
        const tempMolecule = diaMol.moleculeWithH.getCompactCopy();
        tagAtom(tempMolecule, i);
        makeRacemic(tempMolecule);
        const diaID = tempMolecule.getCanonizedIDCode(
        //@ts-expect-error TODO
        diaMol.Molecule.CANONIZER_ENCODE_ATOM_CUSTOM_LABELS);
        canonizedDiaIDs[finalRanks[i]] = diaID;
      }
      return canonizedDiaIDs;
    }

    /**
     * Check if a specific atom is a sp3 carbon
     * @param {import('openchemlib').Molecule} molecule
     * @param {number} atomID
     */
    function isCsp3(molecule, atomID) {
      if (molecule.getAtomicNo(atomID) !== 6) return false;
      if (molecule.getAtomCharge(atomID) !== 0) return false;
      if (molecule.getImplicitHydrogens(atomID) + molecule.getConnAtoms(atomID) !== 4) {
        return false;
      }
      return true;
    }

    const FULL_HOSE_CODE = 1;
    const HOSE_CODE_CUT_C_SP3_SP3 = 2;
    /**
     * Returns the hose code for specific atom numbers
     * @param {import('openchemlib').Molecule} molecule - The OCL molecule with expandedImplicitHydrogens and ensureHeterotopicChiralBonds
     * @param {object} [options={}]
     * @param {string[]} [options.allowedCustomLabels] Array of the custom labels that are considered as root atoms. By default all atoms having a customLabel
     * @param {number} [options.minSphereSize=0] Smallest hose code sphere
     * @param {number} [options.maxSphereSize=4] Largest hose code sphere
     * @param {number} [options.kind=FULL_HOSE_CODE] Kind of hose code, default usual sphere
     */
    function getHoseCodesForAtomsInternal(molecule, options = {}) {
      const OCL = molecule.getOCL();
      const {
        allowedCustomLabels,
        minSphereSize = 0,
        maxSphereSize = 4,
        kind = FULL_HOSE_CODE
      } = options;
      // this force reordering of atoms in order to have hydrogens at the end
      molecule.ensureHelperArrays(OCL.Molecule.cHelperNeighbours);
      const rootAtoms = [];
      for (let j = 0; j < molecule.getAllAtoms(); j++) {
        if (allowedCustomLabels?.includes(molecule.getAtomCustomLabel(j)) || molecule.getAtomCustomLabel(j)) {
          rootAtoms.push(j);
        }
      }
      const fragment = new OCL.Molecule(0, 0);
      const results = [];
      let min = 0;
      let max = 0;
      const atomMask = new Array(molecule.getAllAtoms());
      const atomList = new Array(molecule.getAllAtoms());
      for (let sphere = 0; sphere <= maxSphereSize; sphere++) {
        if (max === 0) {
          for (const rootAtom of rootAtoms) {
            atomList[max] = rootAtom;
            atomMask[rootAtom] = true;
            max++;
          }
        } else {
          let newMax = max;
          for (let i = min; i < max; i++) {
            const atom = atomList[i];
            for (let j = 0; j < molecule.getAllConnAtoms(atom); j++) {
              const connAtom = molecule.getConnAtom(atom, j);
              if (!atomMask[connAtom]) {
                switch (kind) {
                  case FULL_HOSE_CODE:
                    atomMask[connAtom] = true;
                    atomList[newMax++] = connAtom;
                    break;
                  case HOSE_CODE_CUT_C_SP3_SP3:
                    if (!(isCsp3(molecule, atom) && isCsp3(molecule, connAtom))) {
                      atomMask[connAtom] = true;
                      atomList[newMax++] = connAtom;
                    }
                    break;
                  default:
                    throw new Error('getHoseCoesForAtom unknown kind');
                }
              }
            }
          }
          min = max;
          max = newMax;
        }
        molecule.copyMoleculeByAtoms(fragment, atomMask, true, null);
        if (sphere >= minSphereSize) {
          makeRacemic(fragment);
          results.push(fragment.getCanonizedIDCode(OCL.Molecule.CANONIZER_ENCODE_ATOM_CUSTOM_LABELS));
        }
      }
      return results;
    }

    function getCanonizedHoseCodes(diaMol, options = {}) {
      const heterotopicSymmetryRanks = diaMol.heterotopicSymmetryRanks;
      const moleculeWithH = diaMol.moleculeWithH;
      const finalRanks = diaMol.finalRanks;
      const canonizedHoseCodes = new Array(moleculeWithH.getAllAtoms());
      moleculeWithH.ensureHelperArrays(
      //@ts-expect-error TODO
      diaMol.Molecule.cHelperSymmetryStereoHeterotopicity);
      const cache = {};
      for (let i = 0; i < diaMol.moleculeWithH.getAllAtoms(); i++) {
        const rank = heterotopicSymmetryRanks[i];
        if (rank && cache[rank]) {
          canonizedHoseCodes[finalRanks[i]] = cache[rank].diaID;
          continue;
        }
        const tempMolecule = diaMol.moleculeWithH.getCompactCopy();
        tagAtom(tempMolecule, i);
        const hoses = getHoseCodesForAtomsInternal(tempMolecule, options);
        canonizedHoseCodes[finalRanks[i]] = hoses;
      }
      return canonizedHoseCodes;
    }

    function getDiaIDsAndInfo(diaMol, canonizedDiaIDs) {
      const newDiaIDs = [];
      const molecule = diaMol.moleculeWithH;
      const counts = {};
      for (const diaID of canonizedDiaIDs) {
        if (!counts[diaID]) {
          counts[diaID] = 0;
        }
        counts[diaID]++;
      }
      for (let i = 0; i < canonizedDiaIDs.length; i++) {
        const diaID = canonizedDiaIDs[diaMol.finalRanks[i]];
        const newDiaID = {
          idCode: diaID,
          attachedHydrogensIDCodes: [],
          nbAttachedHydrogens: 0,
          atomLabel: molecule.getAtomLabel(i),
          nbEquivalentAtoms: counts[diaID],
          heavyAtom: undefined,
          atomMapNo: molecule.getAtomMapNo(i)
        };
        if (molecule.getAtomicNo(i) === 1) {
          const atom = molecule.getConnAtom(i, 0);
          newDiaID.heavyAtom = canonizedDiaIDs[diaMol.finalRanks[atom]];
        }
        for (let j = 0; j < molecule.getAllConnAtoms(i); j++) {
          const atom = molecule.getConnAtom(i, j);
          if (molecule.getAtomicNo(atom) === 1) {
            newDiaID.nbAttachedHydrogens++;
            const hydrogenDiaID = canonizedDiaIDs[diaMol.finalRanks[atom]];
            if (!newDiaID.attachedHydrogensIDCodes.includes(hydrogenDiaID)) {
              newDiaID.attachedHydrogensIDCodes.push(hydrogenDiaID);
            }
          }
        }
        newDiaIDs.push(newDiaID);
      }
      return newDiaIDs;
    }

    /**
     * Get a unique atomic number for a X
     * @param xMolecule
     * @returns
     */
    function getHeterotopicSymmetryRanks(xMolecule) {
      xMolecule.ensureHelperArrays(xMolecule.getOCL().Molecule.cHelperSymmetryStereoHeterotopicity);
      const symmetryRanks = [];
      for (let i = 0; i < xMolecule.getAllAtoms(); i++) {
        symmetryRanks.push(xMolecule.getSymmetryRank(i));
      }
      return symmetryRanks;
    }
    function getFinalRanks(xMolecule) {
      xMolecule.ensureHelperArrays(xMolecule.getOCL().Molecule.cHelperSymmetryStereoHeterotopicity);
      return xMolecule.getFinalRanks(0).map(rank => rank - 1);
    }

    /**
     * Returns the atoms that are chiral or pseudo chiral.
     * There could be some issues if the original molecule lacks chiral bonds.
     * The function will add them and this could lead to some issues in the case of pseudochiral atoms.
     * @param {import('openchemlib').Molecule} molecule
     * @returns {number[]}
     */
    function getChiralOrHeterotopicCarbons(molecule) {
      const {
        Molecule
      } = molecule.getOCL();
      const xAtomicNumber = getXAtomicNumber(molecule);
      const internalMolecule = molecule.getCompactCopy();
      // hydrogens may be diastereotopic, we need to add them
      internalMolecule.addImplicitHydrogens();
      for (let i = 0; i < internalMolecule.getAllAtoms(); i++) {
        // hydrogens are not taken into account during canonization, we need to change them with an atom with a valence of 1
        if (internalMolecule.getAtomicNo(i) === 1) {
          internalMolecule.setAtomicNo(i, xAtomicNumber);
        }
      }
      addPossibleChiralBonds(internalMolecule);
      internalMolecule.ensureHelperArrays(Molecule.cHelperSymmetryStereoHeterotopicity);
      const atoms = [];
      for (let i = 0; i < molecule.getAllAtoms(); i++) {
        if (internalMolecule.getAtomicNo(i) === xAtomicNumber) {
          continue;
        }
        if (molecule.getAtomicNo(i) !== internalMolecule.getAtomicNo(i)) {
          throw new Error('getChiralOrHeterotopicCarbons: mismatching atomic numbers');
        }
        if (internalMolecule.getAtomicNo(i) !== 6) {
          continue;
        }
        const neighbourSymmetries = getNeighbourSymmetries(internalMolecule, i);
        if (neighbourSymmetries.length === 4) {
          atoms.push(i);
        }
      }
      return atoms;
    }
    function addPossibleChiralBonds(molecule) {
      const {
        Molecule
      } = molecule.getOCL();
      molecule.ensureHelperArrays(Molecule.cHelperSymmetryStereoHeterotopicity);
      for (let i = 0; i < molecule.getAtoms(); i++) {
        if (molecule.getAtomicNo(i) !== 6) continue;
        if (molecule.getStereoBond(i) >= 0) continue;
        const neighbourSymmetries = getNeighbourSymmetries(molecule, i);
        if (neighbourSymmetries.length <= 2) continue;
        const stereoBond = molecule.getAtomPreferredStereoBond(i);
        if (stereoBond !== -1) {
          molecule.setBondType(stereoBond, Molecule.cBondTypeUp);
          if (molecule.getBondAtom(1, stereoBond) === i) {
            const connAtom = molecule.getBondAtom(0, stereoBond);
            molecule.setBondAtom(0, stereoBond, i);
            molecule.setBondAtom(1, stereoBond, connAtom);
          }
          // To me it seems that we have to add all stereo centers into AND group 0. TLS 9.Nov.2015
          molecule.setAtomESR(i, Molecule.cESRTypeAnd, 0);
        }
      }
    }
    function getNeighbourSymmetries(molecule, iAtom) {
      const neighbourSymmetries = [];
      for (let j = 0; j < molecule.getAllConnAtoms(iAtom); j++) {
        const connAtom = molecule.getConnAtom(iAtom, j);
        const symmetryRank = molecule.getSymmetryRank(connAtom);
        if (!neighbourSymmetries.includes(symmetryRank)) {
          neighbourSymmetries.push(molecule.getSymmetryRank(connAtom));
        }
      }
      return neighbourSymmetries;
    }

    /**
     * This function will add missing chiral bonds on carbons ensure that all enantiotopic
     * or diastereotopic atoms can be identified uniquely
     * @param {import('openchemlib').Molecule} molecule
     * @param {object} [options={}]
     * @param {number} [options.esrType=Molecule.cESRTypeAnd]
     * @param {boolean} [options.atLeastThreeAtoms=true] - if true, only carbons with at least three atoms will be considered
     */
    function ensureHeterotopicChiralBonds(molecule, options = {}) {
      const {
        Molecule
      } = molecule.getOCL();
      const {
        esrType = Molecule.cESRTypeAnd,
        atLeastThreeAtoms = true
      } = options;
      molecule.ensureHelperArrays(Molecule.cHelperBitNeighbours);
      const heterotopicCarbons = getChiralOrHeterotopicCarbons(molecule);
      for (const i of heterotopicCarbons) {
        if (atLeastThreeAtoms && molecule.getAllConnAtoms(i) < 3) continue;
        if (molecule.getStereoBond(i) === -1) {
          const stereoBond = molecule.getAtomPreferredStereoBond(i);
          if (stereoBond !== -1) {
            molecule.setBondType(stereoBond, Molecule.cBondTypeUp);
            if (molecule.getBondAtom(1, stereoBond) === i) {
              const connAtom = molecule.getBondAtom(0, stereoBond);
              molecule.setBondAtom(0, stereoBond, i);
              molecule.setBondAtom(1, stereoBond, connAtom);
            }
            // To me it seems that we have to add all stereo centers into AND group 0. TLS 9.Nov.2015
            molecule.setAtomESR(i, esrType, 0);
          }
        }
      }
    }

    const MAX_NB_ATOMS = 250;
    /**
     * Expand all the implicit hydrogens and ensure that the heterotopic bonds
     * @param molecule
     * @returns
     */
    function getMoleculeWithH(molecule) {
      const moleculeWithH = molecule.getCompactCopy();
      moleculeWithH.addImplicitHydrogens();
      if (moleculeWithH.getAllAtoms() > MAX_NB_ATOMS) {
        throw new Error(`Too many atoms to add hydrogens: ${moleculeWithH.getAllAtoms()} > ${MAX_NB_ATOMS}`);
      }
      ensureHeterotopicChiralBonds(moleculeWithH);
      return moleculeWithH;
    }

    /**
     * In order to be able to give a unique ID to all the atoms we are replacing the H by X
     * @param moleculeWithH
     * @returns
     */
    function getXMolecule(moleculeWithH) {
      const xAtomNumber = getXAtomicNumber(moleculeWithH);
      const xMolecule = moleculeWithH.getCompactCopy();
      for (let i = 0; i < xMolecule.getAllAtoms(); i++) {
        // hydrogens are not taken into account during canonization, we need to change them with an atom with a valence of 1
        if (xMolecule.getAtomicNo(i) === 1) {
          xMolecule.setAtomicNo(i, xAtomNumber);
        }
      }
      return xMolecule;
    }

    /**
     * This class deals with topicity information and hose codes
     * It is optimized to avoid recalculation of the same information
     */
    class TopicMolecule {
      constructor(molecule) {
        this.originalMolecule = molecule;
        this.idCode = molecule.getIDCode();
        this.molecule = this.originalMolecule.getCompactCopy();
        this.molecule.ensureHelperArrays(molecule.getOCL().Molecule.cHelperNeighbours);
        this.Molecule = this.molecule.getOCL().Molecule;
        //@ts-expect-error TODO
        this.molecule.ensureHelperArrays(this.Molecule.cHelperNeighbours);
        this.cache = {};
      }
      toMolfile(options = {}) {
        const {
          version = 2
        } = options;
        if (version === 2) {
          return this.molecule.toMolfile();
        }
        return this.molecule.toMolfileV3();
      }
      getMolecule() {
        return this.molecule;
      }
      /**
       * Returns a new TopicMolecule but will copy precalculated information
       * if possible (same idCode). This is very practical when expanding hydrogens
       * for example.
       * @param molecule
       * @returns
       */
      fromMolecule(molecule) {
        const idCode = molecule.getIDCode();
        if (idCode !== this.idCode) {
          // no way for optimisation
          return new TopicMolecule(molecule);
        }
        const topicMolecule = new TopicMolecule(molecule);
        topicMolecule.cache = {
          canonizedDiaIDs: this.cache.canonizedDiaIDs,
          canonizedHoseCodes: this.cache.canonizedHoseCodes
        };
        return topicMolecule;
      }
      /**
       * Returns a molecule with all the hydrogens added. The order is NOT canonized
       */
      get moleculeWithH() {
        if (this.cache.moleculeWithH) return this.cache.moleculeWithH;
        this.cache.moleculeWithH = getMoleculeWithH(this.molecule);
        return this.cache.moleculeWithH;
      }
      get xMolecule() {
        if (this.cache.xMolecule) return this.cache.xMolecule;
        this.cache.xMolecule = getXMolecule(this.moleculeWithH);
        return this.cache.xMolecule;
      }
      /**
       * This is related to the current moleculeWithH. The order is NOT canonized
       */
      get diaIDs() {
        if (this.cache.diaIDs) return this.cache.diaIDs;
        const diaIDs = [];
        for (let i = 0; i < this.moleculeWithH.getAllAtoms(); i++) {
          diaIDs.push(this.canonizedDiaIDs[this.finalRanks[i]]);
        }
        this.cache.diaIDs = diaIDs;
        return diaIDs;
      }
      /**
       * This is related to the current moleculeWithH. The order is NOT canonized
       */
      get hoseCodes() {
        if (this.cache.hoseCodes) return this.cache.hoseCodes;
        const hoseCodes = [];
        for (let i = 0; i < this.moleculeWithH.getAllAtoms(); i++) {
          hoseCodes.push(this.canonizedHoseCodes[this.finalRanks[i]]);
        }
        this.cache.hoseCodes = hoseCodes;
        return hoseCodes;
      }
      get canonizedDiaIDs() {
        if (this.cache.canonizedDiaIDs) return this.cache.canonizedDiaIDs;
        this.cache.canonizedDiaIDs = getCanonizedDiaIDs(this);
        return this.cache.canonizedDiaIDs;
      }
      get canonizedHoseCodes() {
        if (this.cache.canonizedHoseCodes) {
          return this.cache.canonizedHoseCodes;
        }
        this.cache.canonizedHoseCodes = getCanonizedHoseCodes(this);
        return this.cache.canonizedHoseCodes;
      }
      /**
       * Returns the distance matrix for the current moleculeWithH
       */
      get distanceMatrix() {
        return getConnectivityMatrix(this.moleculeWithH, {
          pathLength: true
        });
      }
      get diaIDsAndInfo() {
        if (this.cache.diaIDsAndInfo) return this.cache.diaIDsAndInfo;
        this.cache.diaIDsAndInfo = getDiaIDsAndInfo(this, this.canonizedDiaIDs);
        return this.cache.diaIDsAndInfo;
      }
      /**
       * Returns symmetryRanks for all the atoms including hydrogens. Those ranks
       * deals with topicity and is related to the current moleculeWithH.
       * In order to calculate the ranks we replace all the
       * hydrogens with a X atom.
       */
      get heterotopicSymmetryRanks() {
        if (this.cache.heterotopicSymmetryRanks) {
          return this.cache.heterotopicSymmetryRanks;
        }
        this.cache.heterotopicSymmetryRanks = getHeterotopicSymmetryRanks(this.xMolecule);
        return [...this.cache.heterotopicSymmetryRanks];
      }
      /**
       * Returns finalRanks for all the atoms including hydrogens. Those ranks
       * deals with topicity and is related to the current moleculeWithH.
       * All the atoms have a unique identifier.j
       * In order to calculate the ranks we replace all the
       * hydrogens with a X atom.
       */
      get finalRanks() {
        if (this.cache.finalRanks) return this.cache.finalRanks;
        this.cache.finalRanks = getFinalRanks(this.xMolecule);
        return this.cache.finalRanks;
      }
      toMolfileWithH(options = {}) {
        const {
          version = 2
        } = options;
        if (version === 2) {
          return this.moleculeWithH.toMolfile();
        }
        return this.moleculeWithH.toMolfileV3();
      }
      /**
       * Returns an array of objects containing the oclID and the corresponding hydrogens and atoms
       * for the specified atomLabel (if any)
       * This always applied to the molecule with expanded hydrogens and chirality
       * @param options
       * @returns
       */
      getGroupedDiastereotopicAtomIDs(options = {}) {
        return groupDiastereotopicAtomIDs(this.diaIDs, this.moleculeWithH, options);
      }
    }
    function groupDiastereotopicAtomIDs(diaIDs, molecule, options = {}) {
      const {
        atomLabel
      } = options;
      const diaIDsObject = {};
      for (let i = 0; i < diaIDs.length; i++) {
        if (!atomLabel || molecule.getAtomLabel(i) === atomLabel) {
          const diaID = diaIDs[i];
          if (!diaIDsObject[diaID]) {
            diaIDsObject[diaID] = {
              counter: 0,
              atoms: [],
              oclID: diaID,
              atomLabel: molecule.getAtomLabel(i)
            };
          }
          diaIDsObject[diaID].counter++;
          diaIDsObject[diaID].atoms.push(i);
        }
      }
      return Object.keys(diaIDsObject).map(key => diaIDsObject[key]);
    }

    function squaredEuclidean(p, q) {
      let d = 0;
      for (let i = 0; i < p.length; i++) {
        d += (p[i] - q[i]) * (p[i] - q[i]);
      }
      return d;
    }
    function euclidean(p, q) {
      return Math.sqrt(squaredEuclidean(p, q));
    }

    /**
     * Computes a distance/similarity matrix given an array of data and a distance/similarity function.
     * @param {Array} data An array of data
     * @param {function} distanceFn  A function that accepts two arguments and computes a distance/similarity between them
     * @return {Array<Array>} The distance/similarity matrix. The matrix is square and has a size equal to the length of
     * the data array
     */
    function distanceMatrix(data, distanceFn) {
      const result = getMatrix(data.length);

      // Compute upper distance matrix
      for (let i = 0; i < data.length; i++) {
        for (let j = 0; j <= i; j++) {
          result[i][j] = distanceFn(data[i], data[j]);
          result[j][i] = result[i][j];
        }
      }
      return result;
    }
    function getMatrix(size) {
      const matrix = [];
      for (let i = 0; i < size; i++) {
        const row = [];
        matrix.push(row);
        for (let j = 0; j < size; j++) {
          row.push(0);
        }
      }
      return matrix;
    }

    var heap$1 = {exports: {}};

    (function (module, exports) {
      // Generated by CoffeeScript 1.8.0
      (function () {
        var Heap, defaultCmp, floor, heapify, heappop, heappush, heappushpop, heapreplace, insort, min, nlargest, nsmallest, updateItem, _siftdown, _siftup;
        floor = Math.floor, min = Math.min;

        /*
        Default comparison function to be used
         */

        defaultCmp = function (x, y) {
          if (x < y) {
            return -1;
          }
          if (x > y) {
            return 1;
          }
          return 0;
        };

        /*
        Insert item x in list a, and keep it sorted assuming a is sorted.
        
        If x is already in a, insert it to the right of the rightmost x.
        
        Optional args lo (default 0) and hi (default a.length) bound the slice
        of a to be searched.
         */

        insort = function (a, x, lo, hi, cmp) {
          var mid;
          if (lo == null) {
            lo = 0;
          }
          if (cmp == null) {
            cmp = defaultCmp;
          }
          if (lo < 0) {
            throw new Error('lo must be non-negative');
          }
          if (hi == null) {
            hi = a.length;
          }
          while (lo < hi) {
            mid = floor((lo + hi) / 2);
            if (cmp(x, a[mid]) < 0) {
              hi = mid;
            } else {
              lo = mid + 1;
            }
          }
          return [].splice.apply(a, [lo, lo - lo].concat(x)), x;
        };

        /*
        Push item onto heap, maintaining the heap invariant.
         */

        heappush = function (array, item, cmp) {
          if (cmp == null) {
            cmp = defaultCmp;
          }
          array.push(item);
          return _siftdown(array, 0, array.length - 1, cmp);
        };

        /*
        Pop the smallest item off the heap, maintaining the heap invariant.
         */

        heappop = function (array, cmp) {
          var lastelt, returnitem;
          if (cmp == null) {
            cmp = defaultCmp;
          }
          lastelt = array.pop();
          if (array.length) {
            returnitem = array[0];
            array[0] = lastelt;
            _siftup(array, 0, cmp);
          } else {
            returnitem = lastelt;
          }
          return returnitem;
        };

        /*
        Pop and return the current smallest value, and add the new item.
        
        This is more efficient than heappop() followed by heappush(), and can be
        more appropriate when using a fixed size heap. Note that the value
        returned may be larger than item! That constrains reasonable use of
        this routine unless written as part of a conditional replacement:
            if item > array[0]
              item = heapreplace(array, item)
         */

        heapreplace = function (array, item, cmp) {
          var returnitem;
          if (cmp == null) {
            cmp = defaultCmp;
          }
          returnitem = array[0];
          array[0] = item;
          _siftup(array, 0, cmp);
          return returnitem;
        };

        /*
        Fast version of a heappush followed by a heappop.
         */

        heappushpop = function (array, item, cmp) {
          var _ref;
          if (cmp == null) {
            cmp = defaultCmp;
          }
          if (array.length && cmp(array[0], item) < 0) {
            _ref = [array[0], item], item = _ref[0], array[0] = _ref[1];
            _siftup(array, 0, cmp);
          }
          return item;
        };

        /*
        Transform list into a heap, in-place, in O(array.length) time.
         */

        heapify = function (array, cmp) {
          var i, _i, _len, _ref1, _results, _results1;
          if (cmp == null) {
            cmp = defaultCmp;
          }
          _ref1 = function () {
            _results1 = [];
            for (var _j = 0, _ref = floor(array.length / 2); 0 <= _ref ? _j < _ref : _j > _ref; 0 <= _ref ? _j++ : _j--) {
              _results1.push(_j);
            }
            return _results1;
          }.apply(this).reverse();
          _results = [];
          for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
            i = _ref1[_i];
            _results.push(_siftup(array, i, cmp));
          }
          return _results;
        };

        /*
        Update the position of the given item in the heap.
        This function should be called every time the item is being modified.
         */

        updateItem = function (array, item, cmp) {
          var pos;
          if (cmp == null) {
            cmp = defaultCmp;
          }
          pos = array.indexOf(item);
          if (pos === -1) {
            return;
          }
          _siftdown(array, 0, pos, cmp);
          return _siftup(array, pos, cmp);
        };

        /*
        Find the n largest elements in a dataset.
         */

        nlargest = function (array, n, cmp) {
          var elem, result, _i, _len, _ref;
          if (cmp == null) {
            cmp = defaultCmp;
          }
          result = array.slice(0, n);
          if (!result.length) {
            return result;
          }
          heapify(result, cmp);
          _ref = array.slice(n);
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            elem = _ref[_i];
            heappushpop(result, elem, cmp);
          }
          return result.sort(cmp).reverse();
        };

        /*
        Find the n smallest elements in a dataset.
         */

        nsmallest = function (array, n, cmp) {
          var elem, los, result, _i, _j, _len, _ref, _ref1, _results;
          if (cmp == null) {
            cmp = defaultCmp;
          }
          if (n * 10 <= array.length) {
            result = array.slice(0, n).sort(cmp);
            if (!result.length) {
              return result;
            }
            los = result[result.length - 1];
            _ref = array.slice(n);
            for (_i = 0, _len = _ref.length; _i < _len; _i++) {
              elem = _ref[_i];
              if (cmp(elem, los) < 0) {
                insort(result, elem, 0, null, cmp);
                result.pop();
                los = result[result.length - 1];
              }
            }
            return result;
          }
          heapify(array, cmp);
          _results = [];
          for (_j = 0, _ref1 = min(n, array.length); 0 <= _ref1 ? _j < _ref1 : _j > _ref1; 0 <= _ref1 ? ++_j : --_j) {
            _results.push(heappop(array, cmp));
          }
          return _results;
        };
        _siftdown = function (array, startpos, pos, cmp) {
          var newitem, parent, parentpos;
          if (cmp == null) {
            cmp = defaultCmp;
          }
          newitem = array[pos];
          while (pos > startpos) {
            parentpos = pos - 1 >> 1;
            parent = array[parentpos];
            if (cmp(newitem, parent) < 0) {
              array[pos] = parent;
              pos = parentpos;
              continue;
            }
            break;
          }
          return array[pos] = newitem;
        };
        _siftup = function (array, pos, cmp) {
          var childpos, endpos, newitem, rightpos, startpos;
          if (cmp == null) {
            cmp = defaultCmp;
          }
          endpos = array.length;
          startpos = pos;
          newitem = array[pos];
          childpos = 2 * pos + 1;
          while (childpos < endpos) {
            rightpos = childpos + 1;
            if (rightpos < endpos && !(cmp(array[childpos], array[rightpos]) < 0)) {
              childpos = rightpos;
            }
            array[pos] = array[childpos];
            pos = childpos;
            childpos = 2 * pos + 1;
          }
          array[pos] = newitem;
          return _siftdown(array, startpos, pos, cmp);
        };
        Heap = function () {
          Heap.push = heappush;
          Heap.pop = heappop;
          Heap.replace = heapreplace;
          Heap.pushpop = heappushpop;
          Heap.heapify = heapify;
          Heap.updateItem = updateItem;
          Heap.nlargest = nlargest;
          Heap.nsmallest = nsmallest;
          function Heap(cmp) {
            this.cmp = cmp != null ? cmp : defaultCmp;
            this.nodes = [];
          }
          Heap.prototype.push = function (x) {
            return heappush(this.nodes, x, this.cmp);
          };
          Heap.prototype.pop = function () {
            return heappop(this.nodes, this.cmp);
          };
          Heap.prototype.peek = function () {
            return this.nodes[0];
          };
          Heap.prototype.contains = function (x) {
            return this.nodes.indexOf(x) !== -1;
          };
          Heap.prototype.replace = function (x) {
            return heapreplace(this.nodes, x, this.cmp);
          };
          Heap.prototype.pushpop = function (x) {
            return heappushpop(this.nodes, x, this.cmp);
          };
          Heap.prototype.heapify = function () {
            return heapify(this.nodes, this.cmp);
          };
          Heap.prototype.updateItem = function (x) {
            return updateItem(this.nodes, x, this.cmp);
          };
          Heap.prototype.clear = function () {
            return this.nodes = [];
          };
          Heap.prototype.empty = function () {
            return this.nodes.length === 0;
          };
          Heap.prototype.size = function () {
            return this.nodes.length;
          };
          Heap.prototype.clone = function () {
            var heap;
            heap = new Heap();
            heap.nodes = this.nodes.slice(0);
            return heap;
          };
          Heap.prototype.toArray = function () {
            return this.nodes.slice(0);
          };
          Heap.prototype.insert = Heap.prototype.push;
          Heap.prototype.top = Heap.prototype.peek;
          Heap.prototype.front = Heap.prototype.peek;
          Heap.prototype.has = Heap.prototype.contains;
          Heap.prototype.copy = Heap.prototype.clone;
          return Heap;
        }();
        (function (root, factory) {
          {
            return module.exports = factory();
          }
        })(this, function () {
          return Heap;
        });
      }).call(commonjsGlobal);
    })(heap$1);

    var heap = heap$1.exports;
    var Heap = heap;

    class Cluster {
      constructor() {
        this.children = [];
        this.height = 0;
        this.size = 1;
        this.index = -1;
        this.isLeaf = false;
      }

      /**
       * Creates an array of clusters where the maximum height is smaller than the threshold
       * @param {number} threshold
       * @return {Array<Cluster>}
       */
      cut(threshold) {
        if (typeof threshold !== 'number') {
          throw new TypeError('threshold must be a number');
        }
        if (threshold < 0) {
          throw new RangeError('threshold must be a positive number');
        }
        let list = [this];
        const ans = [];
        while (list.length > 0) {
          const aux = list.shift();
          if (threshold >= aux.height) {
            ans.push(aux);
          } else {
            list = list.concat(aux.children);
          }
        }
        return ans;
      }

      /**
       * Merge the leaves in the minimum way to have `groups` number of clusters.
       * @param {number} groups - Them number of children the first level of the tree should have.
       * @return {Cluster}
       */
      group(groups) {
        if (!Number.isInteger(groups) || groups < 1) {
          throw new RangeError('groups must be a positive integer');
        }
        const heap = new Heap((a, b) => {
          return b.height - a.height;
        });
        heap.push(this);
        while (heap.size() < groups) {
          const first = heap.pop();
          if (first.children.length === 0) {
            break;
          }
          first.children.forEach(child => heap.push(child));
        }
        const root = new Cluster();
        root.children = heap.toArray();
        root.height = this.height;
        return root;
      }

      /**
       * Traverses the tree depth-first and calls the provided callback with each individual node
       * @param {function} cb - The callback to be called on each node encounter
       */
      traverse(cb) {
        function visit(root, callback) {
          callback(root);
          if (root.children) {
            for (const child of root.children) {
              visit(child, callback);
            }
          }
        }
        visit(this, cb);
      }

      /**
       * Returns a list of indices for all the leaves of this cluster.
       * The list is ordered in such a way that a dendrogram could be drawn without crossing branches.
       * @returns {Array<number>}
       */
      indices() {
        const result = [];
        this.traverse(cluster => {
          if (cluster.isLeaf) {
            result.push(cluster.index);
          }
        });
        return result;
      }
    }

    function singleLink(dKI, dKJ) {
      return Math.min(dKI, dKJ);
    }
    function completeLink(dKI, dKJ) {
      return Math.max(dKI, dKJ);
    }
    function averageLink(dKI, dKJ, dIJ, ni, nj) {
      const ai = ni / (ni + nj);
      const aj = nj / (ni + nj);
      return ai * dKI + aj * dKJ;
    }
    function weightedAverageLink(dKI, dKJ) {
      return (dKI + dKJ) / 2;
    }
    function centroidLink(dKI, dKJ, dIJ, ni, nj) {
      const ai = ni / (ni + nj);
      const aj = nj / (ni + nj);
      const b = -(ni * nj) / (ni + nj) ** 2;
      return ai * dKI + aj * dKJ + b * dIJ;
    }
    function medianLink(dKI, dKJ, dIJ) {
      return dKI / 2 + dKJ / 2 - dIJ / 4;
    }
    function wardLink(dKI, dKJ, dIJ, ni, nj, nk) {
      const ai = (ni + nk) / (ni + nj + nk);
      const aj = (nj + nk) / (ni + nj + nk);
      const b = -nk / (ni + nj + nk);
      return ai * dKI + aj * dKJ + b * dIJ;
    }
    function wardLink2(dKI, dKJ, dIJ, ni, nj, nk) {
      const ai = (ni + nk) / (ni + nj + nk);
      const aj = (nj + nk) / (ni + nj + nk);
      const b = -nk / (ni + nj + nk);
      return Math.sqrt(ai * dKI * dKI + aj * dKJ * dKJ + b * dIJ * dIJ);
    }

    /**
     * Continuously merge nodes that have the least dissimilarity
     * @param {Array<Array<number>>} data - Array of points to be clustered
     * @param {object} [options]
     * @param {Function} [options.distanceFunction]
     * @param {string} [options.method] - Default: `'complete'`
     * @param {boolean} [options.isDistanceMatrix] - Is the input already a distance matrix?
     * @constructor
     */
    function agnes(data, options = {}) {
      const {
        distanceFunction = euclidean,
        method = 'complete',
        isDistanceMatrix = false
      } = options;
      let updateFunc;
      if (!isDistanceMatrix) {
        data = distanceMatrix(data, distanceFunction);
      }
      let distanceMatrix$1 = new Matrix(data);
      const numLeaves = distanceMatrix$1.rows;

      // allows to use a string or a given function
      if (typeof method === 'string') {
        switch (method.toLowerCase()) {
          case 'single':
            updateFunc = singleLink;
            break;
          case 'complete':
            updateFunc = completeLink;
            break;
          case 'average':
          case 'upgma':
            updateFunc = averageLink;
            break;
          case 'wpgma':
            updateFunc = weightedAverageLink;
            break;
          case 'centroid':
          case 'upgmc':
            updateFunc = centroidLink;
            break;
          case 'median':
          case 'wpgmc':
            updateFunc = medianLink;
            break;
          case 'ward':
            updateFunc = wardLink;
            break;
          case 'ward2':
            updateFunc = wardLink2;
            break;
          default:
            throw new RangeError(`unknown clustering method: ${method}`);
        }
      } else if (typeof method !== 'function') {
        throw new TypeError('method must be a string or function');
      }
      let clusters = [];
      for (let i = 0; i < numLeaves; i++) {
        const cluster = new Cluster();
        cluster.isLeaf = true;
        cluster.index = i;
        clusters.push(cluster);
      }
      for (let n = 0; n < numLeaves - 1; n++) {
        const [row, column, distance] = getSmallestDistance(distanceMatrix$1);
        const cluster1 = clusters[row];
        const cluster2 = clusters[column];
        const newCluster = new Cluster();
        newCluster.size = cluster1.size + cluster2.size;
        newCluster.children.push(cluster1, cluster2);
        newCluster.height = distance;
        const newClusters = [newCluster];
        const newDistanceMatrix = new Matrix(distanceMatrix$1.rows - 1, distanceMatrix$1.rows - 1);
        const previous = newIndex => getPreviousIndex(newIndex, Math.min(row, column), Math.max(row, column));
        for (let i = 1; i < newDistanceMatrix.rows; i++) {
          const prevI = previous(i);
          const prevICluster = clusters[prevI];
          newClusters.push(prevICluster);
          for (let j = 0; j < i; j++) {
            if (j === 0) {
              const dKI = distanceMatrix$1.get(row, prevI);
              const dKJ = distanceMatrix$1.get(prevI, column);
              const val = updateFunc(dKI, dKJ, distance, cluster1.size, cluster2.size, prevICluster.size);
              newDistanceMatrix.set(i, j, val);
              newDistanceMatrix.set(j, i, val);
            } else {
              // Just copy distance from previous matrix
              const val = distanceMatrix$1.get(prevI, previous(j));
              newDistanceMatrix.set(i, j, val);
              newDistanceMatrix.set(j, i, val);
            }
          }
        }
        clusters = newClusters;
        distanceMatrix$1 = newDistanceMatrix;
      }
      return clusters[0];
    }
    function getSmallestDistance(distance) {
      let smallest = Infinity;
      let smallestI = 0;
      let smallestJ = 0;
      for (let i = 1; i < distance.rows; i++) {
        for (let j = 0; j < i; j++) {
          if (distance.get(i, j) < smallest) {
            smallest = distance.get(i, j);
            smallestI = i;
            smallestJ = j;
          }
        }
      }
      return [smallestI, smallestJ, smallest];
    }
    function getPreviousIndex(newIndex, prev1, prev2) {
      newIndex -= 1;
      if (newIndex >= prev1) newIndex++;
      if (newIndex >= prev2) newIndex++;
      return newIndex;
    }

    var openchemlibFull = {};

    (function(exports){(function(root){function getExports($wnd){var $doc=$wnd.document;var $gwt={};var navigator={userAgent:'webkit'};function noop(){}var __gwtModuleFunction=noop;__gwtModuleFunction.__moduleStartupDone=noop;var YYb='object',ZYb='anonymous',$Yb='fnStack',_Yb='\n',aZb={4:1,9:1,5:1,7:1},bZb='Unknown',cZb='boolean',dZb='number',eZb='string',fZb='function',gZb=2147483647,hZb='For input string: "',iZb='null',jZb='__noinit__',kZb={4:1,5:1,7:1},lZb={4:1,19:1,28:1},mZb=' (copy)',nZb={4:1,9:1,15:1,5:1,11:1,7:1,14:1},oZb=65536,pZb=65535,qZb=10000,rZb=', length: ',sZb='Index: ',tZb=', Size: ',uZb='fromIndex: ',vZb=', toIndex: ',wZb={13:1,4:1,5:1},xZb={4:1},yZb={8:1,4:1,5:1},zZb=16777215,AZb=65280,BZb=0.30000001192092896,CZb=545460846592,DZb=4294967296,EZb=8589934592,FZb=17179869184,GZb=34359738368,HZb=68719476736,IZb=137438953472,JZb=274877906944,KZb={12:1,4:1,5:1},LZb=536870912,MZb=2.617993878,NZb=3.665191429,OZb=6.283185307179586,PZb=3.141592653589793,QZb=1.5707963267948966,RZb=16384,SZb=4096,TZb={l:0,m:0,h:1},UZb={l:0,m:0,h:2},VZb={l:0,m:0,h:4},WZb=1920,XZb=1024,YZb=234881024,ZZb=167772160,$Zb=100663296,_Zb=201326592,a$b=114688,b$b=4063232,c$b=3801088,d$b=3538944,e$b=3014656,f$b=3145728,g$b=2097152,h$b=393216,i$b=917504,j$b=1966080,k$b=17042430230528,l$b=16492674416640,m$b=15942918602752,n$b=14843406974976,o$b=12644383719424,p$b=8796093022208,q$b=549755813888,r$b=1649267441664,s$b=3848290697216,t$b=8246337208320,u$b=29360128,v$b=268435456,w$b=8192,x$b=2048,y$b=-1.5707963267948966,z$b=130560,A$b=6291456,B$b=-2.0943951023931953,C$b=1.0471975511965976,D$b=0.5235987755982988,E$b=786432,F$b=524288,G$b=262144,H$b=-16777216,I$b=-65536,J$b=-32768,K$b='<DrawingObject type="',L$b='><\/DrawingObject>',M$b={4:1,5:1,16:1},N$b={4:1,5:1},O$b='unsupported atomicNo:',P$b=2.8415926535897933,Q$b={41:1,4:1,9:1,5:1,7:1},R$b={4:1,5:1,11:1,7:1},S$b={10:1,4:1,5:1},T$b=131072,U$b=196608,V$b={l:6,m:0,h:4},W$b=1048576,X$b=3221225472,Y$b={l:0,m:0,h:3},Z$b=8388608,$$b=4.9E-324,_$b=1.7976931348623157E308,a_b={90:1,84:1,4:1,9:1,5:1,7:1},b_b='text',c_b={30:1,60:1,62:1},d_b={30:1,60:1,104:1,62:1,121:1},e_b={4:1,5:1,30:1,60:1,104:1,21:1,62:1,121:1,193:1},f_b='??',g_b=2013265920,h_b=32505856,i_b=31744,j_b={152:1,4:1,9:1,5:1,11:1,7:1},k_b=33554432,l_b=67108864,m_b=32768,n_b=-33554433,o_b=-33292289,p_b=-3.141592653589793,q_b=4194303,r_b=3072,s_b={59:1,4:1,5:1},t_b=0.7853981633974483,u_b=3.061592653589793,v_b=1073741824,w_b=541165879296,x_b={17:1,4:1,5:1,7:1},y_b=281.17,z_b=289.19,A_b=294.21,B_b='0.0000',C_b='M  END\n',D_b='ATOMS',E_b=-2147483648,F_b='M  END',G_b='$$$$',H_b='M  V30 ',I_b='M  V30 COUNTS ',J_b=')\n',K_b='M  V30 MDLV30/STEREL',L_b='M  V30 MDLV30/STERAC',M_b=3.4028234663852886E38,N_b={l:2,m:0,h:4},O_b=4194304,P_b={l:4179966,m:4063288,h:7},Q_b={l:4194302,m:4193343,h:7},R_b={90:1,84:1,98:1,4:1,9:1,5:1,7:1},S_b='" ',T_b='stroke="',U_b='stroke-width="',V_b='" />',W_b='class="event" ',X_b='opacity="0" />',Y_b=16711680,Z_b='Assignment of aromatic double bonds failed',$_b=1099511627776,__b=2199023255552,a0b=4398046511104,b0b={115:1,4:1},c0b='Members of ESR groups must only be stereo centers with known configuration.',d0b='Over- or under-specified stereo feature or more than one racemic type bond',e0b='Ambiguous configuration at stereo center because of 2 parallel bonds',f0b={97:1,113:1,24:1,4:1},g0b=100000,h0b='style',i0b=3.1415927410125732,j0b=1.5707963705062866,k0b=0.029999999329447746,l0b=6.2831854820251465,m0b=1.9106119871139526,n0b=2.2639999389648438,o0b=2.16759991645813,p0b=2.0662999153137207,q0b=2.3561999797821045,r0b=2.2844998836517334,s0b=1.9106120066311025,t0b=2.094395160675049,u0b=0.6000000238418579,v0b=1.7999999523162842,w0b=0.05000000074505806,x0b={4:1,9:1,5:1,7:1,48:1},y0b=0.2617993950843811,z0b=2.0943951023931953,A0b=1.2000000476837158,B0b=1.4299999475479126,C0b=1.659999966621399,D0b=1.4600000381469727,E0b=1.8200000524520874,F0b=2.4600000381469727,G0b=2.4200000762939453,H0b=2.450000047683716,I0b=2.440000057220459,J0b=2.4000000953674316,K0b=2.319999933242798,L0b=2.2899999618530273,M0b=1.8600000143051147,N0b=2.5299999713897705,O0b=2.490000009536743,P0b=2.4700000286102295,Q0b=2.880000114440918,R0b=2.9200000762939453,S0b=2.869999885559082,T0b=2.8299999237060547,U0b=2.7899999618530273,V0b=2.809999942779541,W0b=2.799999952316284,X0b=3.049999952316284,Y0b=0.3199999928474426,Z0b=1.3300000429153442,$0b=1.3899999856948853,_0b=1.159999966621399,a1b=1.1100000143051147,b1b=1.0700000524520874,c1b=1.9600000381469727,d1b=1.7100000381469727,e1b=1.3600000143051147,f1b=1.340000033378601,g1b=1.2200000286102295,h1b=1.2400000095367432,i1b=1.2100000381469727,j1b=1.850000023841858,k1b=1.6299999952316284,l1b=1.4700000286102295,m1b=1.2799999713897705,n1b=1.440000057220459,o1b=1.399999976158142,p1b=1.7599999904632568,q1b=1.7300000190734863,r1b=1.7200000286102295,s1b=1.6799999475479126,t1b=1.690000057220459,u1b=1.6699999570846558,v1b=1.649999976158142,w1b=1.7000000476837158,x1b=1.6200000047683716,y1b=1.3700000047683716,z1b=1.2899999618530273,A1b=1.4500000476837158,B1b=1.5700000524520874,C1b=-0.5235987755982988,D1b=-1.0471975511965976,E1b=-0.7853981633974483,F1b=0.017453292519943295,G1b=0.17453292519943295,H1b=1.0E-4,I1b={168:1},J1b=57.29577951308232,K1b=0.021922173386725217,L1b=1.0E-8,M1b=2.5120960256267386,N1b=1.0E-5,O1b='MMFF94s+',P1b='nonbonded cutoff',Q1b='dielectric constant',R1b='dielectric model',S1b='angle bend',T1b='bond stretch',U1b='electrostatic',V1b='out of plane',W1b='stretch bend',X1b='torsion angle',Y1b='van der waals',Z1b={4:1,9:1,5:1,11:1,7:1},$1b=0.07000000000000006,_1b=0.1200000000000001,a2b=-7.840000000000001,b2b='OCL_RXN_V1.0:',c2b="'$MOL' tag not found",d2b="'M  END' not found",e2b='\nActelion Java MolfileCreator 2.0\n\n  0  0  0  0  0  0              0 V3000\n',f2b='M  V30 END CTAB',g2b=2475109711874,h2b=2475109711875,i2b=2887426572290,j2b=2887426572291,k2b=2887627898882,l2b=2887627898883,m2b=2887627997186,n2b=3437182386178,o2b=3437182386179,p2b=3437383712770,q2b=3437383811074,r2b=3437652148226,s2b=3437652377602,t2b=4674132967426,u2b=4674334294018,v2b=4674334392322,w2b=4674602729474,x2b=4674602958850,y2b=5086449827842,z2b=5086449827848,A2b=5086651154434,B2b=5086651252738,C2b=5086651252743,D2b=5086919589890,E2b=5086919688194,F2b=5636406968322,G2b=5636407066626,H2b=5636675502082,I2b={l:589826,m:590112,h:4},J2b={l:589827,m:590112,h:4},K2b={l:589826,m:590160,h:4},L2b={l:589827,m:590160,h:4},M2b={l:688130,m:590160,h:4},N2b={l:589826,m:590224,h:4},O2b={l:589827,m:590224,h:4},P2b={l:819203,m:590224,h:4},Q2b={l:589826,m:590368,h:4},R2b={l:688130,m:590368,h:4},S2b={l:819202,m:590368,h:4},T2b={l:819208,m:590368,h:4},U2b={l:589826,m:590416,h:4},V2b={l:589832,m:590416,h:4},W2b={l:688130,m:590416,h:4},X2b={l:819202,m:590416,h:4},Y2b={l:589826,m:598304,h:4},Z2b={l:589827,m:598304,h:4},$2b={l:688130,m:598304,h:4},_2b={l:1114114,m:598304,h:4},a3b={l:1212418,m:598304,h:4},b3b={l:589826,m:598308,h:4},c3b={l:589826,m:688416,h:4},d3b={l:589826,m:688464,h:4},e3b={l:589826,m:688720,h:4},f3b={l:688130,m:688720,h:4},g3b={l:589826,m:590112,h:288},h3b={l:589826,m:590112,h:336},i3b={l:589826,m:688416,h:336},j3b={l:589826,m:688464,h:336},k3b={l:688130,m:688464,h:336},l3b={l:589826,m:590112,h:400},m3b={l:589826,m:688416,h:400},n3b={l:589826,m:688464,h:400},o3b={l:688130,m:688464,h:400},p3b={l:589826,m:819488,h:400},q3b={l:589826,m:819536,h:400},r3b={l:589826,m:819600,h:400},s3b={l:688130,m:819600,h:400},t3b={l:819202,m:819600,h:400},u3b={l:589831,m:688416,h:592},v3b={l:589831,m:688464,h:592},w3b={l:688135,m:688464,h:592},x3b={l:589831,m:819536,h:592},y3b={l:688135,m:819536,h:592},z3b={l:688135,m:819600,h:592},A3b={l:589832,m:1212704,h:592},B3b={l:589832,m:1212752,h:592},C3b={l:688136,m:1212752,h:592},D3b={l:589831,m:688464,h:656},E3b={l:589826,m:590112,h:8480},F3b={l:589826,m:688416,h:8480},G3b={l:589826,m:688464,h:8480},H3b={l:688130,m:688464,h:8480},I3b={l:819202,m:819600,h:8480},J3b={l:688135,m:1212752,h:8480},K3b={l:589832,m:1213008,h:8480},L3b={l:688136,m:1213008,h:8480},M3b={l:589826,m:590112,h:8484},N3b={l:589826,m:590160,h:8484},O3b={l:688130,m:598304,h:8484},P3b=0.6262000203132629,Q3b=-1.3825000524520874,R3b=0.33169999718666077,S3b=-1.4915000200271606,T3b=0.3540000021457672,U3b=0.38179999589920044,V3b=-0.6019999980926514,W3b=0.07999999821186066,X3b=-0.7379999756813049,Y3b='Atom-types are 64-bit numbers describing atoms and their near surrounding.',Z3b='Recognized atom types and their contributions are:',$3b='Druglikeness predictor not properly initialized.',_3b=3.009999990463257,a4b=-0.17000000178813934,b4b=-0.1809999942779541,c4b=-0.2029999941587448,d4b=2147483648,e4b='MMFF94',f4b='MMFF94s',g4b='117\nint,int,int,int,float\n0,2,0,0,0.020\n1,2,1,2,0.030\n1,2,2,2,0.027\n1,2,2,3,0.026\n1,2,2,5,0.013\n1,2,2,37,0.032\n2,2,2,5,0.013\n2,2,3,5,0.012\n2,2,5,5,0.006\n2,2,5,6,0.027\n2,2,5,37,0.017\n2,2,5,40,0.012\n2,2,5,41,0.008\n0,3,0,0,0.130\n1,3,1,7,0.146\n1,3,2,7,0.138\n1,3,3,7,0.134\n1,3,5,7,0.122\n1,3,6,7,0.141\n1,3,7,10,0.129\n1,3,7,37,0.138\n2,3,5,7,0.113\n2,3,5,9,0.081\n2,3,6,7,0.127\n2,3,7,10,0.116\n3,3,5,7,0.113\n3,3,6,7,0.127\n5,3,5,7,0.103\n5,3,5,9,0.074\n5,3,5,54,0.078\n5,3,6,7,0.119\n5,3,7,10,0.102\n5,3,9,40,0.067\n6,3,7,37,0.127\n7,3,10,10,0.113\n7,3,20,20,0.151\n9,3,40,40,0.057\n0,8,0,0,0.000\n0,10,0,0,0.015\n1,10,1,3,0.015\n1,10,3,6,0.015\n1,10,3,28,0.015\n3,10,3,28,0.015\n3,10,28,28,0.015\n0,17,0,0,0.000\n0,26,0,0,0.000\n0,30,0,0,0.010\n5,30,20,30,0.008\n0,37,0,0,0.035\n1,37,37,37,0.040\n2,37,37,37,0.031\n3,37,37,37,0.027\n5,37,37,37,0.015\n5,37,37,38,0.046\n5,37,37,63,0.008\n5,37,37,64,0.012\n5,37,37,69,0.016\n5,37,38,38,0.084\n6,37,37,37,0.048\n15,37,37,37,0.025\n37,37,37,40,0.046\n0,39,0,0,0.020\n1,39,63,63,0.012\n23,39,63,63,-0.014\n23,39,63,65,0.021\n23,39,65,65,0.062\n0,40,0,0,0.030\n1,40,28,37,0.030\n2,40,28,28,0.030\n3,40,28,28,0.030\n28,40,28,37,0.030\n0,41,0,0,0.180\n1,41,32,32,0.178\n2,41,32,32,0.161\n5,41,32,32,0.158\n0,43,0,0,0.000\n0,45,0,0,0.150\n0,49,0,0,0.000\n50,49,50,50,0.000\n0,54,0,0,0.020\n1,54,3,36,0.016\n3,54,36,36,0.018\n0,55,0,0,0.020\n1,55,36,57,0.020\n36,55,36,57,0.020\n0,56,0,0,0.020\n1,56,36,57,0.020\n36,56,36,57,0.020\n0,57,0,0,0.080\n5,57,55,55,0.038\n56,57,56,56,0.158\n0,58,0,0,0.025\n0,63,0,0,0.050\n5,63,39,64,0.019\n5,63,39,66,0.068\n5,63,44,64,0.014\n5,63,44,66,0.055\n5,63,59,64,0.033\n5,63,59,66,0.085\n37,63,39,64,0.010\n0,64,0,0,0.040\n5,64,63,64,0.006\n5,64,63,66,0.043\n5,64,64,65,0.052\n5,64,65,66,0.094\n37,64,63,64,-0.01\n0,67,0,0,0.070\n0,69,0,0,0.070\n32,69,37,37,0.067\n0,73,0,0,0.000\n0,78,0,0,0.045\n5,78,78,81,0.046\n0,80,0,0,0.080\n5,80,81,81,0.057\n0,81,0,0,0.025\n36,81,78,80,0.016\n0,82,0,0,0.000\n',h4b={330:1,4:1,5:1,7:1},i4b='div',j4b='position:absolute;left:',k4b='px;',l4b='rgba(',m4b=4278190080,n4b='px',o4b={202:1},p4b={378:1,27:1},q4b={379:1,27:1},r4b='position:absolute;width:',s4b='px;height:',t4b={46:1,4:1,5:1,7:1},u4b=22.5,v4b=21.176470588235293,w4b={204:1,27:1},x4b={205:1,27:1},y4b={250:1,27:1},z4b={365:1,27:1},A4b='true',B4b='data-idcode',C4b='MutationObserver',D4b='Parse exception ',E4b='error setting idcode data ',F4b={248:1,27:1},G4b={102:1,27:1},H4b='data:image/gif;base64,R0lGODlhHABGANUAAISChPLx8ubl5uDf4NLR0s/OzwAA//Hx8tHR0svLzMXFxuvs7OXm5t/g4MvMzAD/APf49+vs6+Xm5dfY18vMy/j49/Ly8enp6ODg38bGxdbTzv8AAPj39+zr68bFxcC/v/////39/fr6+vf39/T09PHx8e7u7uzs7Obm5uPj4+Dg4N3d3dra2tfX19TU1NHR0czMzMvLy8nJycbGxsPDw8DAwL29vbq6uqqqqiEhIQAAAAAAAAAAAAAAAAAAAAAAACwAAAAAHABGAAAG/0CQcEgsGo0AkGbJbDqfzqQGQK1ar1iqUgrIeb/gsFi33eZAp7R6zV6Tp+bTzfahzWSUAsLVYq02KQIXEThvXDknNjU0GTIxBS98fhuUFwsmhWVTiIsKjpCSf5SUJhaZcJsnNJ4OeqEqo6Mkp4cnHp+RE36wsaO0cTIwrn0rDb2jIr+pCQUEoQPHlCIhyl0nw34DKccc0yDViLl+GNu9I97fhnGv5bHdIUPgJ8Qq5To6GyTn8PHqqbspJFC6pw9dP03Wit27t2GhDngO0yFEVI9BQx0H7omIeBCVtRQoHJK4F+IeiIVC5Am4Z+IeBJMmhZiUd8Ghjo0oOco7YeIACf8IBo9I9IgIh9GjSJMi9ddFjFOnTM+0mdomqhw6dvBgW2Eg0CB5ihjhCmWgrCVMVjuNJVa2bSl5q2S02kOvbdtZVm89ErdChV278oJtbfC3bTKrzJwRG1C47DR5W7UVfje0Fl9yhfeltMpuskF59FL8Lchv88QTACXYJV1EXrFAq1GenGm1YlufJGGSqRwH5IWyAfTpnm2a6AlBHUyU+ImTeEyaPJdX8Cb7uVWePoGWFipPqXelUZ+K/xIVDdXzJ6zOqXMnD10/D7wSshq20d5QD/Kflaf2PrH8AL5lVVxzvQIggHidphcouvR14IGBCfNeMQ8CeNhpiT1TYX6PWRVvWQoVUibPZSA+qBlvqbAT4mdWhfbgSLKhaE1qB8JY0m4yIvKaADUCFWOOJ1QEoE/n/Aikb/kFVyQZNgGJnHLM3SiTdaddEB0J0/FjE22nYRelUB3V8t2YRjG15Zlo+gPmmkWgAsWbcMKRxZx0VhEEADs=',I4b='data:image/gif;base64,R0lGODlhHABGANUAAISChH59fnt6e3h3eHRzdMTDxLi3uJiXmAAAw3d3eLe3uKamp5eXmI+PkIaGh4ODhH1+fsPExLe4uJGSkgDDAM/Qz8DBwHh4d76+vZ6enZiYl4qKidbTzsMAANDPz8fGxqSjo5KRkYqJiYSDg////9LS0svLy76+vru7u7i4uLW1tbKysq+vr6ysrKmpqaOjo6GhoZubm5iYmJWVlZKSko+Pj4yMjImJiYSEhIODg4CAgHh4eG9vb19fXyEhIQAAACwAAAAAHABGAAAG/0CScEgsGo0AEmfJbDqfziQHQK1ar1iqUgrweb/gsPi33YrPaF956qXx3vC4PL7u+t4EQkIQ0AEcNzY1NB0HMRkwPXVePHk7fDojgIKEHR2IL4pTZncEAwIQOjkOIpSWpyALmlyMF5A4k4Mzp6cuq5w8kA+xNLO0p7dsd6GjgbK/pyzBdjyRvL7ILCvLjLvGEzMayC3SKtR3DhuCITMy290p3zzGvQznKyoKKOqU2ZY/Px0u3PAGKCfqGvSSEePej33d/J2woK4XPnwdHv6AJ7GAunIF8S3Ax0IiBgsFPqjTEEOiC3wr8KF4+MGEupI/XuBrgU8FvoUR8LlcdCeDxP8fHR9ikGjCgzoYLxYghCcBxceQJkxUKKGuh9WrWLNi5Zmmq5pNwtzMGSuHJx49kP6wQ2AIkTpHkCStRYAA09tHxEhRoss3lTpXfWCxm8GXry2zup4VLqwu7+DFfJWZdfYYMgJp6qwJwqYBMj9vZsONK+cZnbrBDErDk0dPVufCS1UoDDgwBuzPChmarQ37oYoUDy2axchXKUqV+EKOPERXKc0fNn+cwNfyJSbnQQ3gs6BzJ1hmiFLFfghSp1GzSLEzdQqypVSqZrXK18rVKxqeYsnqN9sIbR+1lFDQViJmwdWHXAFSQIFdBX6SVymDKCihX2YBpoNg9Ugo4WHfMZKO2GAaatiYKM+EKKFkHd5BWYYmUoCZWZrVwJmJn6kjWg3kyECjaWahtuNq85hVjwYhnvTQbGYJhJGGRqb0wz+6pchDbUxy8xB7wkm5pILYXfmUSGaRlAGXCOEDHFHWpbeUStN1p0546v32Ez7nSanmZ019GdVUy/xwx3yAWrXGEYQWChYUiCa6SRaMNlpFEAA7',J4b=21.333333333333332,K4b={237:1,27:1},L4b='width',M4b='height',N4b='offsetHeight',O4b='offsetWidth',P4b='Null widget handle. If you are creating a composite, ensure that initWidget() has been called.',Q4b='Style names cannot be empty',R4b='aria-hidden',S4b={43:1,37:1,40:1,39:1,44:1,35:1,34:1},T4b={43:1,37:1,40:1,39:1,44:1,35:1,34:1,30:1},U4b='left',V4b='visibility',W4b='hidden',X4b='visible',Y4b='popupContent',Z4b=1281818470,$4b={25:1},_4b={167:1,25:1},a5b=23.333333333333332,b5b=4294967295,c5b='font: 12px sans-serif',d5b='Atom Properties',e5b='cellPadding',f5b='Cancel',g5b='excluded atoms:',h5b='allowed atoms:',i5b='200px',j5b='any ring state',k5b={323:1,27:1},l5b='disabled',m5b='px Helvetica',n5b='Helvetica',o5b='canvas',p5b='undefined',q5b=0.08726646502812703,r5b=4278190335,s5b=0.003921568859368563,t5b='CENTER',u5b='position',v5b='absolute',w5b='CSS1Compat',x5b={38:1,31:1,4:1,18:1,20:1},y5b={36:1,31:1,4:1,18:1,20:1},z5b={31:1,85:1,4:1,18:1,20:1},A5b={58:1,4:1,18:1,20:1},B5b='load',C5b={146:1,4:1,19:1,28:1},D5b='Too many percent/per mille characters in pattern "',E5b=1048575,F5b=17592186044416,G5b=1000000000,H5b=-17592186044416,I5b=16777216,J5b='__gwtLastUnhandledEvent',K5b='__uiObjectID',L5b='cellSpacing',M5b='Column index: ',N5b=', Column size: ',O5b='Row index: ',P5b=', Row size: ',Q5b='overflow',R5b={43:1,37:1,40:1,39:1,44:1,182:1,35:1,34:1,30:1},S5b={88:1,4:1,18:1,20:1},T5b=5.56,U5b=11.12,V5b=13.34,W5b=14.44,X5b=0.3010299956639812,Y5b='BigInteger divide by zero',Z5b={l:0,m:0,h:524288},$5b={18:1,133:1},_5b={149:1},a6b={30:1,60:1,62:1,131:1},b6b='delete',c6b=15525485,d6b=5.9604644775390625E-8,e6b={4:1,149:1},f6b={4:1,18:1,20:1,93:1},g6b='Invalid UTF8 sequence',h6b=0.20000000298023224,i6b=' distance:',j6b='gGP`@dfyjidNcGI[WQCP`<',k6b={65:1};var UXb={};var VXb={};var WXb={};var XXb={};var YXb={};var ZXb={};var $Xb={};var _Xb={};var aYb={};var bYb={};var cYb={};var dYb={};var eYb={};var fYb={};var gYb={};var hYb={};var iYb={};var jYb={};var kYb={};var lYb={};var mYb={};var nYb={};var oYb={};var pYb={};var qYb={};var rYb={};var sYb={};var tYb={};var uYb={};var vYb={};var wYb={};var xYb={};var yYb={};var zYb={};var AYb={};var BYb={};var CYb={};var DYb={};var EYb={};var FYb={};var GYb={};var HYb={};var IYb={};var JYb={};var KYb={};var LYb={};var MYb={};var NYb={};var OYb={};var PYb={};var QYb={};var RYb={};var SYb={};var TYb={};var UYb={};var VYb={};var WYb={};var XYb={};var _;var uxb;var oxb;UXb.Ewb=function Ewb(){};function txb(a,b){typeof window===YYb&&typeof window['$gwt']===YYb&&(window['$gwt'][a]=b);}function sxb(b,c,d,e){UXb.rxb();var f=oxb;function g(){for(var a=0;a<f.length;a++){f[a]();}}if(b){try{TXb(g)();}catch(a){b(c,a);}}else {TXb(g)();}}UXb.rxb=function rxb(){oxb==null&&(oxb=[]);};function qxb(){UXb.rxb();var a=oxb;for(var b=0;b<arguments.length;b++){a.push(arguments[b]);}}UXb.pxb=function pxb(){};function Fxb(){}function Exb(a){if(Array.isArray(a)&&a.he===Fxb){return VXb.Mc(a);}return a.toString();}function Dxb(a,b){var c=$wnd;if(a===''){return c;}var d=a.split('.');!(d[0]in c)&&c.execScript&&c.execScript('var '+d[0]);if(b){var e=b.prototype.fe;e.e=b;}for(var f;d.length&&(f=d.shift());){c=c[f]=c[f]||!d.length&&b||{};}return c;}UXb.Cxb=function Cxb(a){function b(){}b.prototype=a||{};return new b();};UXb.Bxb=function Bxb(a){return a instanceof Array?a[0]:null;};function Axb(a,b,c){var d=function(){return a.apply(d,arguments);};b.apply(d,c);return d;}function zxb(){}function yxb(a,b){for(var c in b){b[c]['configurable']=true;}Object.defineProperties(a,b);}function xxb(a,b,c){var d=uxb;var e=d[a];var f=UXb.Bxb(e);if(e&&!f){_=e;}else {_=UXb.wxb(b);_.ge=c;!b&&(_.he=Fxb);d[a]=_;}for(var g=3;g<arguments.length;++g){arguments[g].prototype=_;}f&&(_.fe=f);}UXb.wxb=function wxb(a){var b=a&&a.prototype;!b&&(b=uxb[a]);return UXb.Cxb(b);};UXb.vxb=function vxb(){};$wnd.goog=$wnd.goog||{};$wnd.goog.global=$wnd.goog.global||$wnd;uxb={};VXb.Bc=function Bc(a,b){return flb(a)===flb(b);};VXb.Cc=function Cc(a){return a.fe;};VXb.Dc=function Dc(a){return YXb.sTb(a);};function Ec(){}VXb.Gc=function Gc(a,b){return clb(a)?VXb.DHb(a,b):_kb(a)?VXb.tGb(a,b):$kb(a)?VXb.mFb(a,b):Ykb(a)?a.ib(b):Ujb(a)?VXb.Bc(a,b):WXb.w7(a,b);};VXb.Ic=function Ic(a){return clb(a)?VXb.FHb():_kb(a)?VXb.uGb():$kb(a)?VXb.nFb():Ykb(a)?a.fe:Ujb(a)?VXb.Cc(a):WXb.x7(a);};VXb.Kc=function Kc(a){return clb(a)?VXb.GHb(a):_kb(a)?VXb.vGb(a):$kb(a)?VXb.oFb(a):Ykb(a)?a.kb():Ujb(a)?VXb.Dc(a):WXb.y7(a);};VXb.Mc=function Mc(a){var b;return VXb.PFb(VXb.Ic(a))+'@'+(b=YXb.LTb(YXb.KTb(VXb.Kc(a))),b.toString(16));};xxb(1,null,{},Ec);_.ib=function Fc(a){return VXb.Bc(this,a);};_.jb=function Hc(){return VXb.Cc(this);};_.kb=function Jc(){return VXb.Dc(this);};_.lb=function Lc(){var a;return VXb.PFb(VXb.Ic(this))+'@'+(a=YXb.LTb(YXb.KTb(VXb.Kc(this))),a.toString(16));};_.equals=function(a){return this.ib(a);};_.hashCode=function(){return this.kb();};_.toString=function(){return this.lb();};WXb.w7=function w7(a,b){return WXb.C7(a)?WXb.z7(a,b):flb(a)===flb(b);};WXb.x7=function x7(a){return a.fe||Array.isArray(a)&&Mjb(UXb.xqb,1)||UXb.xqb;};WXb.y7=function y7(a){return WXb.D7(a)?WXb.A7(a):YXb.sTb(a);};WXb.z7=function z7(a,b){return a.equals(b);};WXb.A7=function A7(a){return a.hashCode();};WXb.B7=function B7(){return [];};WXb.C7=function C7(a){return !!a&&!!a.equals;};WXb.D7=function D7(a){return !!a&&!!a.hashCode;};WXb.E7=function E7(a){return a.toString?a.toString():'[JavaScriptObject]';};XXb.R9=function R9(){XXb.R9=zxb;var a,b;b=!XXb.$9();a=new XXb.hab();XXb.Q9=b?new XXb._9():a;};XXb.S9=function S9(a){XXb.R9();XXb.Q9.td(a);};XXb.T9=function T9(a){XXb.R9();var b;b=XXb.Q9.ud(a);return XXb.U9(b);};XXb.U9=function U9(a){var b,c,d,e;b='S9';c='Xz';e=$wnd.Math.min(a.length,5);for(d=e-1;d>=0;d--){if(VXb.DHb(a[d].d,b)||VXb.DHb(a[d].d,c)){a.length>=d+1&&YXb.LTb(a).splice(0,d+1);break;}}return a;};XXb.V9=function V9(a){var b=/function(?:\s+([\w$]+))?\s*\(/;var c=b.exec(a);return c&&c[1]||ZYb;};XXb.W9=function W9(a){XXb.R9();return a&&a[$Yb]?a[$Yb]:[];};XXb.X9=function X9(a){XXb.R9();return a.name||(a.name=XXb.V9(a.toString()));};XXb.Y9=function Y9(a){XXb.R9();return parseInt(a)||-1;};XXb.Z9=function Z9(a){XXb.R9();var b=a.backingJsObject;if(b&&b.stack){var c=b.stack;var d=b+_Yb;c.substring(0,d.length)==d&&(c=c.substring(d.length));return c.split(_Yb);}return [];};XXb.$9=function $9(){if(Error.stackTraceLimit>0){$wnd.Error.stackTraceLimit=Error.stackTraceLimit=64;return true;}return 'stack'in new Error();};xxb(653,1,{});XXb._9=function _9(){};xxb(388,653,{},XXb._9);_.td=function aab(a){var b={};var c=[];a[$Yb]=c;var d=arguments.callee.caller;while(d){var e=XXb.X9(d);c.push(e);var f=':'+e;var g=b[f];if(g){var h,i;for(h=0,i=g.length;h<i;h++){if(g[h]===d){return;}}}(g||(b[f]=[])).push(d);d=d.caller;}};_.ud=function bab(a){var b,c,d,e;d=XXb.W9(a);c=WXb.e9(d);e=Sjb(UXb.Kub,aZb,96,c,0,1);for(b=0;b<c;b++){e[b]=new VXb.sHb(WXb.d9(d,b),null,-1);}return e;};XXb.cab=function cab(a,b){var c,d,e,f,g,h,i,j,k;j='';if(YXb.LTb(b).length==0){return a.vd(bZb,ZYb,-1,-1);}k=VXb.SHb(b);VXb.DHb(YXb.LTb(k).substr(0,3),'at ')&&(k=(YXb.GTb(3,YXb.LTb(k).length+1),YXb.LTb(k).substr(3)));k=XXb.dab(k);g=YXb.LTb(k).indexOf('(');if(g==-1){g=YXb.LTb(k).indexOf('@');if(g==-1){j=k;k='';}else {j=VXb.SHb((YXb.GTb(g+1,YXb.LTb(k).length+1),YXb.LTb(k).substr(g+1)));k=VXb.SHb((YXb.FTb(0,g,YXb.LTb(k).length),YXb.LTb(k).substr(0,g)));}}else {c=YXb.LTb(k).indexOf(')',g);j=(YXb.FTb(g+1,c,YXb.LTb(k).length),YXb.LTb(k).substr(g+1,c-(g+1)));k=VXb.SHb((YXb.FTb(0,g,YXb.LTb(k).length),YXb.LTb(k).substr(0,g)));}g=VXb.HHb(k,UHb(46));g!=-1&&(k=(YXb.GTb(g+1,YXb.LTb(k).length+1),YXb.LTb(k).substr(g+1)));(YXb.LTb(k).length==0||VXb.DHb(k,'Anonymous function'))&&(k=ZYb);h=VXb.KHb(j,UHb(58));e=VXb.LHb(j,UHb(58),h-1);i=-1;d=-1;f=bZb;if(h!=-1&&e!=-1){f=(YXb.FTb(0,e,YXb.LTb(j).length),YXb.LTb(j).substr(0,e));i=XXb.Y9((YXb.FTb(e+1,h,YXb.LTb(j).length),YXb.LTb(j).substr(e+1,h-(e+1))));d=XXb.Y9((YXb.GTb(h+1,YXb.LTb(j).length+1),YXb.LTb(j).substr(h+1)));}return a.vd(f,k,i,d);};XXb.dab=function dab(a){return a.replace(/\[.*?\]/g,'');};xxb(654,653,{});_.td=function eab(a){};_.vd=function fab(a,b,c,d){return new VXb.sHb(b,a+'@'+d,c<0?-1:c);};_.ud=function gab(a){var b,c,d,e,f,g;e=XXb.Z9(a);f=Sjb(UXb.Kub,aZb,96,0,0,1);b=0;d=WXb.e9(e);if(d==0){return f;}g=XXb.cab(this,WXb.d9(e,0));VXb.DHb(g.d,ZYb)||(f[b++]=g);for(c=1;c<d;c++){f[b++]=XXb.cab(this,WXb.d9(e,c));}return f;};XXb.hab=function hab(){};xxb(389,654,{},XXb.hab);_.vd=function iab(a,b,c,d){return new VXb.sHb(b,a,-1);};UXb.Ljb=function Ljb(a){return a;};function Mjb(a,b){return UXb.Njb(a,b);}UXb.Njb=function Njb(a,b){return VXb.$Fb(a,b);};UXb.Ojb=function Ojb(a){return a.__elementTypeCategory$==null?10:a.__elementTypeCategory$;};UXb.Pjb=function Pjb(a){return a.__elementTypeId$;};function Qjb(a,b,c,d,e,f){return UXb.Rjb(a,b,c,d,e,0,f);}UXb.Rjb=function Rjb(a,b,c,d,e,f,g){var h,i,j,k,l;k=e[f];j=f==g-1;h=j?d:0;l=UXb.Tjb(h,k);d!=10&&$jb(Mjb(a,g-f),b[f],c[f],h,l);if(!j){++f;for(i=0;i<k;++i){UXb.Vjb(l,i,UXb.Rjb(a,b,c,d,e,f,g));}}return l;};function Sjb(a,b,c,d,e,f){var g;g=UXb.Tjb(e,d);e!=10&&$jb(Mjb(a,f),b,c,e,g);return g;}UXb.Tjb=function Tjb(a,b){var c=new Array(b);var d;switch(a){case 14:case 15:d=0;break;case 16:d=false;break;default:return c;}for(var e=0;e<b;++e){c[e]=d;}return c;};function Ujb(a){return Array.isArray(a)&&a.he===Fxb;}UXb.Vjb=function Vjb(a,b,c){return a[b]=c;};function Wjb(a,b,c){return UXb.Vjb(a,b,c);}UXb.Xjb=function Xjb(a,b){a.fe=b;};UXb.Yjb=function Yjb(a,b){a.__elementTypeCategory$=b;};UXb.Zjb=function Zjb(a,b){a.__elementTypeId$=b;};function $jb(a,b,c,d,e){UXb.Xjb(e,a);e.ge=b;e.he=Fxb;UXb.Zjb(e,c);UXb.Yjb(e,d);return e;}UXb._jb=function _jb(a,b){UXb.Ojb(b)!=10&&$jb(VXb.Ic(b),b.ge,UXb.Pjb(b),UXb.Ojb(b),a);return UXb.Ljb(a);};function Wkb(a,b){if(clb(a)){return !!Vkb[b];}else if(a.ge){return !!a.ge[b];}else if(_kb(a)){return !!Ukb[b];}else if($kb(a)){return !!Tkb[b];}return false;}function Xkb(a){return String.fromCharCode(a);}function Ykb(a){return !Array.isArray(a)&&a.he===Fxb;}function Zkb(a,b){return a!=null&&Wkb(a,b);}function $kb(a){return typeof a===cZb;}function _kb(a){return typeof a===dZb;}function alb(a){return a!=null&&UXb.dlb(a)&&!(a.he===Fxb);}function blb(a,b){return UXb.elb(a,b);}function clb(a){return typeof a===eZb;}UXb.dlb=function dlb(a){return typeof a===YYb||typeof a===fZb;};UXb.elb=function elb(a,b){return a&&b&&a instanceof b;};function flb(a){return a==null?null:a;}function glb(a){return Math.max(Math.min(a,gZb),-2147483648)|0;}var Tkb;var Ukb;var Vkb;UXb.Fwb=function Fwb(a){return a&&a.__java$exception;};function Gwb(a){var b;if(Zkb(a,28)){return a;}b=UXb.Fwb(a);if(!b){b=new WXb.V8(a);XXb.S9(b);}return b;}function Hwb(a){return a.backingJsObject;}function REb(a){var b;if(a==null){return false;}b=typeof a;return VXb.DHb(b,cZb)||VXb.DHb(b,dZb)||VXb.DHb(b,eZb)||a.$implements__java_io_Serializable||Array.isArray(a);}function jGb(a){var b;b=typeof a;if(VXb.DHb(b,cZb)||VXb.DHb(b,dZb)||VXb.DHb(b,eZb)){return true;}return a!=null&&a.$implements__java_lang_Comparable;}VXb.iFb=function iFb(){VXb.iFb=zxb;hFb=YXb.LTb(false);YXb.LTb(true);};VXb.jFb=function jFb(a){return YXb.MTb((YXb.ATb(a),a));};VXb.kFb=function kFb(a,b){return qFb(YXb.MTb((YXb.ATb(a),a)),YXb.MTb((YXb.ATb(b),b)));};VXb.lFb=function lFb(a,b){return VXb.kFb(a,b);};VXb.mFb=function mFb(a,b){return YXb.ATb(a),a===b;};VXb.nFb=function nFb(){return UXb.rub;};VXb.oFb=function oFb(a){return YXb.MTb((YXb.ATb(a),a))?1231:1237;};function pFb(a){VXb.iFb();return VXb.DHb(cZb,typeof a);}function qFb(a,b){VXb.iFb();return a==b?0:a?1:-1;}VXb.rFb=function rFb(a,b){VXb.iFb();return clb(a)?VXb.xHb(a,b):_kb(a)?VXb.rGb(a,b):$kb(a)?VXb.lFb(a,b):a.Eb(b);};Tkb={4:1,380:1,18:1};var hFb;function sFb(a){if(VXb.DHb(typeof a,eZb)){return true;}return a!=null&&a.$implements__java_lang_CharSequence;}VXb.NFb=function NFb(a){a.i=MFb++;};VXb.OFb=function OFb(a){if(a.n!=null){return;}VXb.cGb(a);};VXb.PFb=function PFb(a){VXb.OFb(a);return a.n;};VXb.QFb=function QFb(a){return (a.f&4)!=0;};VXb.RFb=function RFb(a){return (a.f&1)!=0;};VXb.SFb=function SFb(){VXb.NFb(this);this.n=null;this.j=null;this.g=null;this.d=null;this.b=null;this.k=null;this.a=null;};VXb.UFb=function UFb(a){var b;b=new VXb.SFb();b.n='Class$'+(a?'S'+a:''+b.i);b.b=b.n;b.j=b.n;return b;};function VFb(a){var b;b=VXb.UFb(a);VXb.gGb(a,b);return b;}function WFb(a,b){var c;c=VXb.UFb(a);VXb.gGb(a,c);c.f=b?8:0;return c;}function XFb(){var a;a=VXb.UFb(null);a.f=2;return a;}function YFb(a){var b;b=VXb.UFb(a);b.k=a;b.f=1;return b;}VXb.$Fb=function $Fb(a,b){var c=a.a=a.a||[];return c[b]||(c[b]=a.Kd(b));};function aGb(a){if(a.Pd()){return null;}var b=a.k;return uxb[b];}VXb.cGb=function cGb(a){if(a.Od()){var b=a.c;b.Pd()?a.n='['+b.k:!b.Od()?a.n='[L'+b.Md()+';':a.n='['+b.Md();a.b=b.Ld()+'[]';a.j=b.Nd()+'[]';return;}var c=a.g;var d=a.d;d=d.split('/');a.n=VXb.fGb('.',[c,VXb.fGb('$',d)]);a.b=VXb.fGb('.',[c,VXb.fGb('.',d)]);a.j=d[d.length-1];};VXb.fGb=function fGb(a,b){var c=0;while(!b[c]||b[c]==''){c++;}var d=b[c++];for(;c<b.length;c++){if(!b[c]||b[c]==''){continue;}d+=a+b[c];}return d;};VXb.gGb=function gGb(a,b){if(!a){return;}b.k=a;var d=aGb(b);if(!d){uxb[a]=[b];return;}d.fe=b;};xxb(238,1,{},VXb.SFb);_.Kd=function TFb(a){var b;b=new VXb.SFb();b.f=4;a>1?b.c=VXb.$Fb(this,a-1):b.c=this;return b;};_.Ld=function ZFb(){VXb.OFb(this);return this.b;};_.Md=function _Fb(){return VXb.PFb(this);};_.Nd=function bGb(){VXb.OFb(this);return this.j;};_.Od=function dGb(){return VXb.QFb(this);};_.Pd=function eGb(){return VXb.RFb(this);};_.lb=function hGb(){return ((this.f&2)!=0?'interface ':(this.f&1)!=0?'':'class ')+(VXb.OFb(this),this.n);};_.f=0;_.i=0;var MFb=1;VXb.lGb=function lGb(a){return VXb.DHb(dZb,typeof a)||blb(a,$wnd.java.lang.Number$impl);};VXb.mGb=function mGb(a){VXb.kGb==null&&(VXb.kGb=new RegExp('^\\s*[+-]?(NaN|Infinity|((\\d+\\.?\\d*)|(\\.\\d+))([eE][+-]?\\d+)?[dDfF]?)\\s*$'));if(!VXb.kGb.test(a)){throw Hwb(new VXb.rHb(hZb+a+'"'));}return parseFloat(a);};VXb.nGb=function nGb(a,b,c){var d,e,f,g,h;if(a==null){throw Hwb(new VXb.rHb(iZb));}f=YXb.LTb(a).length;g=f>0&&(YXb.GTb(0,YXb.LTb(a).length),YXb.LTb(a).charCodeAt(0)==45||(YXb.GTb(0,YXb.LTb(a).length),YXb.LTb(a).charCodeAt(0)==43))?1:0;for(d=g;d<f;d++){if(yFb((YXb.GTb(d,YXb.LTb(a).length),YXb.LTb(a).charCodeAt(d)))==-1){throw Hwb(new VXb.rHb(hZb+a+'"'));}}h=parseInt(a,10);e=h<b;if(isNaN(h)){throw Hwb(new VXb.rHb(hZb+a+'"'));}else if(e||h>c){throw Hwb(new VXb.rHb(hZb+a+'"'));}return h;};VXb.oGb=function oGb(a){return _kb(a)?VXb.sGb(a):a.Qd();};VXb.pGb=function pGb(a){return _kb(a)?VXb.wGb(a):a.Rd();};xxb(142,1,{4:1,142:1});VXb.qGb=function qGb(a,b){return yGb(YXb.NTb((YXb.ATb(a),a)),YXb.NTb((YXb.ATb(b),b)));};VXb.rGb=function rGb(a,b){return VXb.qGb(a,b);};VXb.sGb=function sGb(a){return YXb.NTb((YXb.ATb(a),a));};VXb.tGb=function tGb(a,b){return YXb.ATb(a),flb(a)===flb(b);};VXb.uGb=function uGb(){return UXb.vub;};VXb.vGb=function vGb(a){return glb(YXb.NTb((YXb.ATb(a),a)));};VXb.wGb=function wGb(a){return glb(YXb.NTb((YXb.ATb(a),a)));};function xGb(a){return VXb.DHb(dZb,typeof a);}function yGb(a,b){if(a<b){return -1;}if(a>b){return 1;}if(a==b){return a==0?yGb(1/a,1/b):0;}return isNaN(a)?isNaN(b)?0:1:-1;}function zGb(a){if(isNaN(a)){return {l:0,m:0,h:524160};}return YXb.HTb(a);}Ukb={4:1,18:1,386:1,142:1};VXb.Cz=function Cz(a){a.i=Sjb(UXb.Kub,aZb,96,0,0,1);};VXb.Dz=function Dz(a,b){YXb.BTb(b,'Cannot suppress a null exception.');YXb.uTb(b!=a,'Exception can not suppress itself.');if(a.g){return;}a.j==null?a.j=$jb(Mjb(UXb.Pub,1),aZb,28,0,[b]):a.j[a.j.length]=b;};VXb.Ez=function Ez(a){XXb.S9(a);};VXb.Fz=function Fz(a){return XXb.T9(a);};VXb.Gz=function Gz(a){if(a.k){a.backingJsObject!==jZb&&a.Xb();a.i=null;}return a;};VXb.Hz=function Hz(a){return a.e;};VXb.Iz=function Iz(d,b){if(b instanceof Object){try{b.__java$exception=d;if(navigator.userAgent.toLowerCase().indexOf('msie')!=-1&&$doc.documentMode<9){return;}var c=d;Object.defineProperties(b,{cause:{get:function(){var a=c.Vb();return a&&a.Tb();}},suppressed:{get:function(){return c.Ub();}}});}catch(a){}}};VXb.Jz=function Jz(a,b,c){var d,e,f,g,h;VXb.Kz(a);for(e=(a.j==null&&(a.j=Sjb(UXb.Pub,aZb,28,0,0,1)),a.j),f=0,g=e.length;f<g;++f){d=e[f];VXb.Jz(d,b,'\t'+c);}h=a.e;!!h&&VXb.Jz(h,b,c);};VXb.Kz=function Kz(a){var b,c,d;for(b=(a.i==null&&(a.i=VXb.Fz(a)),a.i),c=0,d=b.length;c<d;++c){}};VXb.Lz=function Lz(a,b){a.backingJsObject=b;VXb.Iz(a,b);};VXb.Mz=function Mz(a){return VXb.Nz(a,a.Wb());};VXb.Nz=function Nz(a,b){var c;c=VXb.PFb(a.fe);return b==null?c:c+': '+b;};VXb.Oz=function Oz(){VXb.Cz(this);VXb.Gz(this);this.Xb();};VXb.Pz=function Pz(a){VXb.Cz(this);this.f=a;VXb.Gz(this);this.Xb();};VXb.Qz=function Qz(a,b){VXb.Cz(this);this.e=b;this.f=a;VXb.Gz(this);this.Xb();};VXb.Sz=function Sz(b){if(!('stack'in b)){try{throw b;}catch(a){}}return b;};function Yz(a){var b;if(a!=null){b=a.__java$exception;if(b){return b;}}return blb(a,TypeError)?new VXb.oHb(a):new VXb.N8(a);}xxb(28,1,{4:1,28:1});_.Sb=function Rz(a){return new Error(a);};_.Tb=function Tz(){return this.backingJsObject;};_.Ub=function Uz(){var a,b,c;c=(this.j==null&&(this.j=Sjb(UXb.Pub,aZb,28,0,0,1)),this.j);b=Sjb(UXb.Iub,kZb,1,c.length,5,1);for(a=0;a<c.length;a++){b[a]=c[a].backingJsObject;}return b;};_.Vb=function Vz(){return VXb.Hz(this);};_.Wb=function Wz(){return this.f;};_.Xb=function Xz(){VXb.Lz(this,VXb.Sz(this.Sb(VXb.Nz(this,this.f))));VXb.Ez(this);};_.lb=function Zz(){return VXb.Mz(this);};_.backingJsObject=jZb;_.g=false;_.k=true;VXb.$z=function $z(){VXb.Oz.call(this);};VXb._z=function _z(a){VXb.Cz(this);VXb.Gz(this);this.backingJsObject=a;VXb.Iz(this,a);this.f=a==null?iZb:Exb(a);};VXb.aA=function aA(a){VXb.Pz.call(this,a);};VXb.bA=function bA(a,b){VXb.Qz.call(this,a,b);};xxb(19,28,lZb,VXb.aA);VXb.cA=function cA(){VXb.$z.call(this);};VXb.dA=function dA(a){VXb._z.call(this,a);};VXb.eA=function eA(a){VXb.aA.call(this,a);};VXb.fA=function fA(a,b){VXb.bA.call(this,a,b);};xxb(55,19,lZb,VXb.eA);VXb.dFb=function dFb(){VXb.cA.call(this);};VXb.eFb=function eFb(a){VXb.eA.call(this,a);};xxb(56,55,lZb,VXb.dFb,VXb.eFb);VXb.M8=function M8(){VXb.cA.call(this);};VXb.N8=function N8(a){VXb.dA.call(this,a);};VXb.O8=function O8(a){VXb.eA.call(this,a);};xxb(150,55,lZb,VXb.N8);VXb.nHb=function nHb(){VXb.M8.call(this);};VXb.oHb=function oHb(a){VXb.N8.call(this,a);};VXb.pHb=function pHb(a){VXb.O8.call(this,a);};xxb(74,150,lZb,VXb.nHb,VXb.oHb,VXb.pHb);_.Sb=function qHb(a){return new TypeError(a);};VXb.wHb=function wHb(a,b){YXb.GTb(b,YXb.LTb(a).length);return YXb.LTb(a).charCodeAt(b);};VXb.xHb=function xHb(a,b){return VXb.yHb(a,b);};VXb.yHb=function yHb(a,b){var c,d;c=VXb.sGb(YXb.LTb(a));d=VXb.sGb(YXb.LTb(b));return c==d?0:c<d?-1:1;};VXb.zHb=function zHb(a,b){return VXb.yHb(YXb.LTb(a).toLowerCase(),YXb.LTb(b).toLowerCase());};VXb.AHb=function AHb(a,b){return YXb.ATb(a),a+(''+(YXb.ATb(b),b));};VXb.BHb=function BHb(a){var b;return VXb.WHb(YXb.kTb(a,0,(b=a.length,YXb.hTb(),b)));};VXb.CHb=function CHb(a){var b;b=YXb.LTb(mZb).length;return VXb.DHb(YXb.LTb(a).substr(YXb.LTb(a).length-b,b),mZb);};VXb.DHb=function DHb(a,b){return YXb.ATb(a),flb(a)===flb(b);};VXb.EHb=function EHb(a,b){YXb.ATb(a);if(b==null){return false;}if(VXb.DHb(a,b)){return true;}return YXb.LTb(a).length==YXb.LTb(b).length&&VXb.DHb(YXb.LTb(a).toLowerCase(),YXb.LTb(b).toLowerCase());};VXb.FHb=function FHb(){return UXb.Oub;};VXb.GHb=function GHb(a){var b,c;b=0;for(c=0;c<YXb.LTb(a).length;c++){b=(b<<5)-b+(YXb.GTb(c,YXb.LTb(a).length),YXb.LTb(a).charCodeAt(c))|0;}return b;};VXb.HHb=function HHb(a,b){return YXb.LTb(a).indexOf(b);};VXb.IHb=function IHb(a,b,c){return YXb.LTb(a).indexOf(b,c);};function JHb(a){return VXb.DHb(eZb,typeof a);}VXb.KHb=function KHb(a,b){return YXb.LTb(a).lastIndexOf(b);};VXb.LHb=function LHb(a,b,c){return YXb.LTb(a).lastIndexOf(b,c);};VXb.MHb=function MHb(a,b){var c;c=VXb.NHb(b,'([/\\\\\\.\\*\\+\\?\\|\\(\\)\\[\\]\\{\\}$^])','\\\\$1');return VXb.NHb(a,c,'');};VXb.NHb=function NHb(a,b,c){c=VXb.VHb(c);return YXb.LTb(a).replace(new RegExp(b,'g'),c);};VXb.OHb=function OHb(a,b){var c,d,e,f,g,h,i,j;c=new RegExp(b,'g');i=Sjb(UXb.Oub,nZb,2,0,6,1);d=0;j=a;f=null;while(true){h=c.exec(j);if(h==null||j==''){i[d]=j;break;}else {g=h.index;i[d]=(YXb.FTb(0,g,YXb.LTb(j).length),YXb.LTb(j).substr(0,g));j=VXb.RHb(j,g+YXb.LTb(YXb.LTb(h)[0]).length,YXb.LTb(j).length);c.lastIndex=0;if(f==j){i[d]=(YXb.FTb(0,1,YXb.LTb(j).length),YXb.LTb(j).substr(0,1));j=(YXb.GTb(1,YXb.LTb(j).length+1),YXb.LTb(j).substr(1));}f=j;++d;}}if(YXb.LTb(a).length>0){e=i.length;while(e>0&&i[e-1]==''){--e;}e<i.length&&(YXb.LTb(i).length=e);}return i;};VXb.PHb=function PHb(a,b){return VXb.DHb(YXb.LTb(a).substr(0,YXb.LTb(b).length),b);};VXb.QHb=function QHb(a,b){YXb.GTb(b,YXb.LTb(a).length+1);return YXb.LTb(a).substr(b);};VXb.RHb=function RHb(a,b,c){YXb.FTb(b,c,YXb.LTb(a).length);return YXb.LTb(a).substr(b,c-b);};VXb.SHb=function SHb(a){var b,c,d;c=YXb.LTb(a).length;d=0;while(d<c&&(YXb.GTb(d,YXb.LTb(a).length),YXb.LTb(a).charCodeAt(d)<=32)){++d;}b=c;while(b>d&&(YXb.GTb(b-1,YXb.LTb(a).length),YXb.LTb(a).charCodeAt(b-1)<=32)){--b;}return d>0||b<c?(YXb.FTb(d,b,YXb.LTb(a).length),YXb.LTb(a).substr(d,b-d)):a;};VXb.THb=function THb(a){return String.fromCharCode.apply(null,a);};function UHb(a){var b,c;if(a>=oZb){b=55296+(a-oZb>>10&1023)&pZb;c=56320+(a-oZb&1023)&pZb;return String.fromCharCode(b)+(''+String.fromCharCode(c));}else {return String.fromCharCode(a&pZb);}}VXb.VHb=function VHb(a){var b;b=0;while(0<=(b=YXb.LTb(a).indexOf('\\',b))){YXb.GTb(b+1,YXb.LTb(a).length);YXb.LTb(a).charCodeAt(b+1)==36?a=(YXb.FTb(0,b,YXb.LTb(a).length),YXb.LTb(a).substr(0,b)+'$'+VXb.QHb(a,++b)):a=(YXb.FTb(0,b,YXb.LTb(a).length),YXb.LTb(a).substr(0,b)+(''+VXb.QHb(a,++b)));}return a;};VXb.WHb=function WHb(a){return VXb.XHb(a,0,a.length);};VXb.XHb=function XHb(a,b,c){var d,e,f,g;f=b+c;YXb.FTb(b,f,a.length);g='';for(e=b;e<f;){d=$wnd.Math.min(e+qZb,f);g+=VXb.THb(YXb.LTb(a).slice(e,d));e=d;}return g;};Vkb={4:1,240:1,18:1,2:1};VXb.mIb=function mIb(a){VXb.eFb.call(this,a);};xxb(262,56,lZb,VXb.mIb);YXb.YSb=function YSb(a){var b;b=YXb.LTb(a).slice();return YXb.gTb(b,a);};YXb.ZSb=function ZSb(a,b,c,d,e,f){var g,h,i,j,k;if(e==0){return;}if(flb(a)===flb(c)){a=YXb.LTb(a).slice(b,b+e);b=0;}i=YXb.LTb(c);for(h=b,j=b+e;h<j;){g=$wnd.Math.min(h+qZb,j);e=g-h;k=YXb.LTb(a).slice(h,g);YXb.LTb(k).splice(0,0,YXb.LTb(d),YXb.LTb(f?e:0));Array.prototype.splice.apply(i,k);h=g;d+=e;}};YXb.$Sb=function $Sb(a,b){return YXb.gTb(new Array(b),a);};YXb._Sb=function _Sb(a,b,c){YXb.LTb(a).splice(b,0,c);};YXb.aTb=function aTb(a,b,c){YXb.ZSb(c,0,a,b,c.length,false);};YXb.bTb=function bTb(a,b){YXb.LTb(a).push(b);};YXb.cTb=function cTb(a,b){YXb.LTb(a).push(b);};YXb.dTb=function dTb(a,b,c){YXb.LTb(a).splice(b,c);};YXb.eTb=function eTb(a,b){YXb.LTb(a).length=b;};YXb.fTb=function fTb(a,b){YXb.LTb(a).sort(b);};xxb(741,1,{});YXb.pTb=function pTb(){};YXb.qTb=function qTb(a){switch(typeof a){case eZb:return VXb.GHb(YXb.LTb(a));case dZb:return VXb.vGb(YXb.LTb(a));case cZb:return VXb.oFb(YXb.LTb(a));default:return a==null?0:YXb.sTb(a);}};YXb.rTb=function rTb(){return ++YXb.oTb;};YXb.sTb=function sTb(a){return a.$H||(a.$H=YXb.rTb());};xxb(651,1,{},YXb.pTb);YXb.oTb=0;YXb.tTb=function tTb(a){if(!a){throw Hwb(new VXb.BGb());}};YXb.uTb=function uTb(a,b){if(!a){throw Hwb(new VXb.CGb(b));}};YXb.vTb=function vTb(a,b){if(0>a){throw Hwb(new VXb.CGb('fromIndex: 0 > toIndex: '+a));}if(a>b){throw Hwb(new VXb.gFb('fromIndex: 0, toIndex: '+a+rZb+b));}};YXb.wTb=function wTb(a){if(a<0){throw Hwb(new VXb.mHb('Negative array size: '+a));}};YXb.xTb=function xTb(a,b){if(a!=b){throw Hwb(new _Xb.BPb());}};YXb.yTb=function yTb(a){if(!a){throw Hwb(new _Xb.JQb());}};YXb.zTb=function zTb(a,b){if(a<0||a>=b){throw Hwb(new VXb.eFb(sZb+a+tZb+b));}};YXb.ATb=function ATb(a){if(a==null){throw Hwb(new VXb.nHb());}return a;};YXb.BTb=function BTb(a,b){if(a==null){throw Hwb(new VXb.pHb(b));}};YXb.CTb=function CTb(a,b){if(a<0||a>b){throw Hwb(new VXb.eFb(sZb+a+tZb+b));}};YXb.DTb=function DTb(a,b,c){if(a<0||b>c){throw Hwb(new VXb.eFb(uZb+a+vZb+b+', size: '+c));}if(a>b){throw Hwb(new VXb.CGb(uZb+a+' > toIndex: '+b));}};YXb.ETb=function ETb(a){if(!a){throw Hwb(new VXb.DGb());}};YXb.FTb=function FTb(a,b,c){if(a<0||b>c||b<a){throw Hwb(new VXb.mIb(uZb+a+vZb+b+rZb+c));}};YXb.GTb=function GTb(a,b){if(a<0||a>=b){throw Hwb(new VXb.mIb(sZb+a+tZb+b));}};YXb.HTb=function HTb(a){var b,c;b=new ArrayBuffer(8);YXb.LTb(new Float64Array(b))[0]=a;c=YXb.LTb(new Uint32Array(b));return YXb.OTb(c[0]|0,c[1]|0);};YXb.ITb=function ITb(a,b){return a[b];};YXb.JTb=function JTb(a){return a===undefined;};YXb.KTb=function KTb(a){return a>>>0;};YXb.LTb=function LTb(a){return a;};YXb.MTb=function MTb(a){return a;};YXb.NTb=function NTb(a){return a;};xxb(652,1,{});UXb.Iub=VFb(1);UXb.xqb=VFb(0);UXb.Gqb=VFb(653);UXb.Dqb=VFb(388);UXb.Fqb=VFb(654);UXb.Eqb=VFb(389);UXb.rub=VFb(380);UXb.uub=VFb(238);UXb.Hub=VFb(142);UXb.vub=VFb(386);UXb.Pub=VFb(28);UXb.xub=VFb(19);UXb.Jub=VFb(55);UXb.Aub=VFb(56);UXb.Cub=VFb(150);UXb.Fub=VFb(74);UXb.Oub=VFb(2);UXb.Nub=VFb(262);UXb.Yvb=VFb(651);UXb.Zvb=VFb(652);ZXb.Nc=function Nc(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P,Q;this.c=a.length;this.d=a[0].length;G=$wnd.Math.min(this.c,this.d);this.e=Sjb(UXb.jlb,wZb,6,$wnd.Math.min(this.c+1,this.d),15,1);this.a=Qjb(UXb.jlb,[aZb,wZb],[13,6],15,[this.c,G],2);this.b=Qjb(UXb.jlb,[aZb,wZb],[13,6],15,[this.d,this.d],2);e=Sjb(UXb.jlb,wZb,6,this.d,15,1);Q=Sjb(UXb.jlb,wZb,6,this.c,15,1);D=$wnd.Math.min(this.c-1,this.d);F=$wnd.Math.max(0,$wnd.Math.min(this.d-2,this.c));for(v=0;v<$wnd.Math.max(D,F);v++){if(v<D){this.e[v]=0;for(l=v;l<this.c;l++){this.e[v]=ZXb.Oc(this.e[v],a[l][v]);}if(this.e[v]!=0){a[v][v]<0&&(this.e[v]=-this.e[v]);for(k=v;k<this.c;k++){a[k][v]/=this.e[v];}a[v][v]+=1;}this.e[v]=-this.e[v];}for(q=v+1;q<this.d;q++){if(v<D&this.e[v]!=0){P=0;for(l=v;l<this.c;l++){P+=a[l][v]*a[l][q];}P=-P/a[v][v];for(k=v;k<this.c;k++){a[k][q]+=P*a[k][v];}}e[q]=a[v][q];}if(true&v<D){for(k=v;k<this.c;k++){this.a[k][v]=a[k][v];}}if(v<F){e[v]=0;for(l=v+1;l<this.d;l++){e[v]=ZXb.Oc(e[v],e[l]);}if(e[v]!=0){e[v+1]<0&&(e[v]=-e[v]);for(m=v+1;m<this.d;m++){e[m]/=e[v];}e[v+1]+=1;}e[v]=-e[v];if(v+1<this.c&e[v]!=0){for(m=v+1;m<this.c;m++){Q[m]=0;}for(r=v+1;r<this.d;r++){for(n=v+1;n<this.c;n++){Q[n]+=e[r]*a[n][r];}}for(s=v+1;s<this.d;s++){P=-e[s]/e[v+1];for(n=v+1;n<this.c;n++){a[n][s]+=P*Q[n];}}}for(k=v+1;k<this.d;k++){this.b[k][v]=e[k];}}}H=$wnd.Math.min(this.d,this.c+1);D<this.d&&(this.e[D]=a[D][D]);this.c<H&&(this.e[H-1]=0);F+1<H&&(e[F]=a[F][H-1]);e[H-1]=0;for(t=D;t<G;t++){for(k=0;k<this.c;k++){this.a[k][t]=0;}this.a[t][t]=1;}for(w=D-1;w>=0;w--){if(this.e[w]!=0){for(p=w+1;p<G;p++){P=0;for(l=w;l<this.c;l++){P+=this.a[l][w]*this.a[l][p];}P=-P/this.a[w][w];for(m=w;m<this.c;m++){this.a[m][p]+=P*this.a[m][w];}}for(n=w;n<this.c;n++){this.a[n][w]=-this.a[n][w];}this.a[w][w]=1+this.a[w][w];for(k=0;k<w-1;k++){this.a[k][w]=0;}}else {for(k=0;k<this.c;k++){this.a[k][w]=0;}this.a[w][w]=1;}}for(A=this.d-1;A>=0;A--){if(A<F&e[A]!=0){for(p=A+1;p<G;p++){P=0;for(l=A+1;l<this.d;l++){P+=this.b[l][A]*this.b[l][p];}P=-P/this.b[A+1][A];for(m=A+1;m<this.d;m++){this.b[m][p]+=P*this.b[m][A];}}}for(k=0;k<this.d;k++){this.b[k][A]=0;}this.b[A][A]=1;}I=H-1;h=$wnd.Math.pow(2,-52);while(H>0){for(u=H-2;u>=-1;u--){if(u==-1){break;}if($wnd.Math.abs(e[u])<=h*($wnd.Math.abs(this.e[u])+$wnd.Math.abs(this.e[u+1]))){e[u]=0;break;}}if(u==H-2){B=4;}else {for(C=H-1;C>=u;C--){if(C==u){break;}P=(C!=H?$wnd.Math.abs(e[C]):0)+(C!=u+1?$wnd.Math.abs(e[C-1]):0);if($wnd.Math.abs(this.e[C])<=h*P){this.e[C]=0;break;}}if(C==u){B=3;}else if(C==H-1){B=1;}else {B=2;u=C;}}++u;switch(B){case 1:{i=e[H-2];e[H-2]=0;for(p=H-2;p>=u;p--){P=ZXb.Oc(this.e[p],i);d=this.e[p]/P;M=i/P;this.e[p]=P;if(p!=u){i=-M*e[p-1];e[p-1]=d*e[p-1];}for(k=0;k<this.d;k++){P=d*this.b[k][p]+M*this.b[k][H-1];this.b[k][H-1]=-M*this.b[k][p]+d*this.b[k][H-1];this.b[k][p]=P;}}}break;case 2:{i=e[u-1];e[u-1]=0;for(p=u;p<H;p++){P=ZXb.Oc(this.e[p],i);d=this.e[p]/P;M=i/P;this.e[p]=P;i=-M*e[p];e[p]=d*e[p];for(k=0;k<this.c;k++){P=d*this.a[k][p]+M*this.a[k][u-1];this.a[k][u-1]=-M*this.a[k][p]+d*this.a[k][u-1];this.a[k][p]=P;}}}break;case 3:{J=$wnd.Math.max($wnd.Math.max($wnd.Math.max($wnd.Math.max($wnd.Math.abs(this.e[H-1]),$wnd.Math.abs(this.e[H-2])),$wnd.Math.abs(e[H-2])),$wnd.Math.abs(this.e[u])),$wnd.Math.abs(e[u]));N=this.e[H-1]/J;O=this.e[H-2]/J;g=e[H-2]/J;L=this.e[u]/J;f=e[u]/J;b=((O+N)*(O-N)+g*g)/2;c=N*g*(N*g);K=0;if(b!=0|c!=0){K=$wnd.Math.sqrt(b*b+c);b<0&&(K=-K);K=c/(b+K);}i=(L+N)*(L-N)+K;j=L*f;for(p=u;p<H-1;p++){P=ZXb.Oc(i,j);d=i/P;M=j/P;p!=u&&(e[p-1]=P);i=d*this.e[p]+M*e[p];e[p]=d*e[p]-M*this.e[p];j=M*this.e[p+1];this.e[p+1]=d*this.e[p+1];for(l=0;l<this.d;l++){P=d*this.b[l][p]+M*this.b[l][p+1];this.b[l][p+1]=-M*this.b[l][p]+d*this.b[l][p+1];this.b[l][p]=P;}P=ZXb.Oc(i,j);d=i/P;M=j/P;this.e[p]=P;i=d*e[p]+M*this.e[p+1];this.e[p+1]=-M*e[p]+d*this.e[p+1];j=M*e[p+1];e[p+1]=d*e[p+1];if(p<this.c-1){for(k=0;k<this.c;k++){P=d*this.a[k][p]+M*this.a[k][p+1];this.a[k][p+1]=-M*this.a[k][p]+d*this.a[k][p+1];this.a[k][p]=P;}}}e[H-2]=i;}break;case 4:{if(this.e[u]<=0){this.e[u]=this.e[u]<0?-this.e[u]:0;for(k=0;k<=I;k++){this.b[k][u]=-this.b[k][u];}}while(u<I){if(this.e[u]>=this.e[u+1]){break;}P=this.e[u];this.e[u]=this.e[u+1];this.e[u+1]=P;if(u<this.d-1){for(k=0;k<this.d;k++){P=this.b[k][u+1];this.b[k][u+1]=this.b[k][u];this.b[k][u]=P;}}if(u<this.c-1){for(k=0;k<this.c;k++){P=this.a[k][u+1];this.a[k][u+1]=this.a[k][u];this.a[k][u]=P;}}++u;}--H;}}}};ZXb.Oc=function Oc(a,b){var c;if($wnd.Math.abs(a)>$wnd.Math.abs(b)){c=b/a;c=$wnd.Math.abs(a)*$wnd.Math.sqrt(1+c*c);}else if(b!=0){c=a/b;c=$wnd.Math.abs(b)*$wnd.Math.sqrt(1+c*c);}else {c=0;}return c;};xxb(231,1,xZb,ZXb.Nc);_.c=0;_.d=0;UXb.nlb=VFb(231);$Xb.Qc=function Qc(){$Xb.Qc=zxb;$Xb.Pc=$jb(Mjb(UXb.llb,1),yZb,6,15,[0,zZb,14286847,13402367,12779264,16758197,9474192,3166456,16715021,9494608,11789301,11230450,9109248,12560038,15780000,16744448,16777008,2093087,8442339,9388244,4062976,15132390,12567239,10921643,9083335,10255047,14706227,15765664,5296208,13140019,8224944,12750735,6721423,12419299,16752896,10889513,6076625,7351984,AZb,9764863,9756896,7586505,5551541,3907230,2396047,687500,27013,12632256,16767375,10909043,6717568,10380213,13924864,9699476,4366000,5707663,51456,7394559,16777159,14286791,13107143,10747847,9437127,6422471,4587463,3211207,2097095,65436,58997,54354,48952,43812,5096191,5089023,2200790,2522539,2516630,1528967,13684960,16765219,12105936,10900557,5724513,10375093,11230208,7688005,4358806,4325478,32000,7384058,47871,41471,36863,33023,27647,5528818,7888099,9064419,10565332,11739092,11739066,11734438,12389767,13041766,13369433,13697103,14221381,14680120,15073326,15400998,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13158600,1334015,56540,15075850,15132160,56540,15075850,15461355,8553170,1016335,1016335,1334015,15132160,3289770,14456450,16422400,16422400,11819700,3289770,1016335]);};$Xb.Rc=function Rc(a){a.v=new lYb.JG();};$Xb.Sc=function Sc(a){var b,c;if((a.F&32)!=0)return;c=$Xb.qu(a.K);if(c!=null){if(a.w.a==0&&a.w.b==0){b=a.Q.c*$Xb.Rk(a.K);a.v=$Xb.Od(a);$Xb.cd(a,b);$Xb.Kd(a,null,b,0);}a.yb(glb(a.A));a.K.O!=1&&$Xb.Ld(a,448);a.pb(c,a.w.a,a.w.b+BZb*a.A);}};$Xb.Tc=function Tc(a,b){return a==null?b:b==null?a:a+','+b;};$Xb.Uc=function Uc(a,b){$Xb.Xh(b,a.Q);$Xb.$h(b,a.v);$Xb.Zh(b,a.w);};$Xb.Vc=function Vc(a){var b;b=a.Q.c*$Xb.Rk(a.K);a.X=b*0.06;a.S=b*0.15;a.R=b*0.38;a.V=b*0.47;a.W=glb(b*a.I*0.6+0.5);a.U=b*0.12;a.Y=b*0.4;a.A=b*0.5+0.5;};$Xb.Wc=function Wc(a){var b,c;a=Jwb(a,CZb);for(c=0;c<(kYb.yG(),kYb.xG).length;c++)if(Twb(a,kYb.xG[c]))return kYb.wG[c];b=new VXb.lIb('R');cxb(Jwb(a,DZb),0)&&(b.a+='0',b);cxb(Jwb(a,EZb),0)&&(b.a+='3',b);cxb(Jwb(a,FZb),0)&&(b.a+='4',b);cxb(Jwb(a,GZb),0)&&(b.a+='5',b);cxb(Jwb(a,HZb),0)&&(b.a+='6',b);cxb(Jwb(a,IZb),0)&&(b.a+='7',b);cxb(Jwb(a,JZb),0)&&(b.a+='8',b);return b.a;};$Xb.Xc=function Xc(a,b,c,d){var e,f;e=new $Xb.Zd();f=new $Xb.Zd();e.a=b.a;e.c=b.c;e.b=(b.a+b.b)/2;e.d=(b.c+b.d)/2;f.a=e.b;f.c=e.d;f.b=b.b;f.d=b.d;if($Xb.Hd(a,e)){$Xb.Ld(a,a.p[c]);a.mb(e);}if($Xb.Hd(a,f)){$Xb.Ld(a,a.p[d]);a.mb(f);}$Xb.Ld(a,a.P);};$Xb.Yc=function Yc(a,b,c,d){var e,f,g,h,i;h=(b.b-b.a)/10;i=(b.d-b.c)/10;e=new $Xb.Zd();if($Xb.yl(a.K,$Xb.Pn(a.K,c,d))){f=-3;g=-3;}else {f=a.p[c];g=a.p[d];}$Xb.Ld(a,f);e.a=b.a;e.c=b.c;e.b=b.a+h*2;e.d=b.c+i*2;a.mb(e);e.a=b.a+h*4;e.c=b.c+i*4;e.b=b.a+h*5;e.d=b.c+i*5;a.mb(e);$Xb.Ld(a,g);e.a=b.a+h*5;e.c=b.c+i*5;e.b=b.a+h*6;e.d=b.c+i*6;a.mb(e);e.a=b.a+h*8;e.c=b.c+i*8;e.b=b.b;e.d=b.d;a.mb(e);$Xb.Ld(a,a.P);};$Xb.Zc=function Zc(a,b,c){a.qb(b-a.U/2,c-a.U/2,a.U);};$Xb.$c=function $c(a,b,c,d){if($Xb.yl(a.K,$Xb.Pn(a.K,c,d))){$Xb.Ld(a,-3);a.mb(b);$Xb.Ld(a,a.P);}else if(a.p[c]!=a.p[d]){$Xb.Xc(a,b,c,d);}else if(a.p[c]!=0){$Xb.Ld(a,a.p[c]);a.mb(b);$Xb.Ld(a,a.P);}else {a.mb(b);}};$Xb._c=function _c(a,b,c,d,e,f,g){g.a=b.a+e;g.c=b.c+f;g.b=b.b+e;g.d=b.d+f;$Xb.$c(a,g,c,d);};$Xb.ad=function ad(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p;l=b.b-b.a;o=b.d-b.c;i=$wnd.Math.sqrt(l*l+o*o);j=2*lxb(Uwb($wnd.Math.round(i/(4*a.X))));m=l/(j-1);p=o/(j-1);if($Xb.yl(a.K,$Xb.Pn(a.K,c,d))){e=-3;f=-3;}else {e=a.p[c];f=a.p[d];}k=b.a-a.X/2;n=b.c-a.X/2;$Xb.Ld(a,e);for(h=0;h<(j/2|0);h++){a.qb(k,n,a.X);k+=m;n+=p;}$Xb.Ld(a,f);for(g=0;g<(j/2|0);g++){a.qb(k,n,a.X);k+=m;n+=p;}$Xb.Ld(a,a.P);};$Xb.bd=function bd(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p,q,r;i=(b.c-b.d)/9;n=(b.b-b.a)/9;j=b.b+i;o=b.d+n;k=b.b-i;p=b.d-n;l=(b.a+j)/2;q=(b.c+o)/2;m=(b.a+k)/2;r=(b.c+p)/2;g=new lYb.EG(3);h=new lYb.EG(4);lYb.DG(g,b.a,b.c);lYb.DG(g,l,q);lYb.DG(g,m,r);lYb.DG(h,m,r);lYb.DG(h,l,q);lYb.DG(h,j,o);lYb.DG(h,k,p);if($Xb.yl(a.K,$Xb.Pn(a.K,c,d))){e=-3;f=-3;}else {e=a.p[c];f=a.p[d];if(a.K.O!=1){f=$Xb.fd(a,c);e==$Xb.Ak(a.K,c)&&(e=f);}}$Xb.Ld(a,e);a.ob(g);$Xb.Ld(a,f);a.ob(h);$Xb.Ld(a,a.P);};$Xb.cd=function cd(a,b){var c,d;for(d=0;d<a.Z.a.length;d++)a.v=lYb.IG(a.v,_Xb.Xi(a.Z,d));$Xb.dd(a,b);c=0.1*b;a.v.c-=c;a.v.d-=c;a.v.b+=2*c;a.v.a+=2*c;};$Xb.dd=function dd(a,b){var c,d,e,f,g,h,i;e=Sjb(UXb.Cwb,KZb,6,a.K.q,16,1);for(d=0;d<a.K.r;d++){if($Xb.wl(a.K,d)){e[$Xb.Vk(a.K,0,d)]=true;e[$Xb.Vk(a.K,1,d)]=true;}}g=new lYb.JG();for(c=0;c<a.K.q;c++){f=cxb(Jwb($Xb.Lk(a.K,c),LZb),0)?b*0.47:e[c]?b*0.38:0;if(f!=0){h=$Xb.bi(a.Q,$Xb.Nk(a.K,c));i=$Xb.ci(a.Q,$Xb.Ok(a.K,c));lYb.HG(g,h-f,i-f,f*2,f*2);a.v=lYb.IG(a.v,g);}}};$Xb.ed=function ed(a,b){var c;c=a.L!=0?a.L:a.C!=0?a.C:-1;return yYb.o6(b,c);};$Xb.fd=function fd(a,b){var c,d;if((a.F&4224)!=0)return a.p[b];d=$Xb.gd(a,b);if(d==-1){c=$Xb.xn(a.K,b);if(c!=-1){b=c;d=$Xb.gd(a,b);}}if(d==-1)return a.p[b];switch(d&255){case 1:return 384;case 2:return 64;default:return 448;}};$Xb.gd=function gd(a,b){var c,d,e;e=-1;d=-1;if((a.F&128)!=0)return e;if($Xb.ul(a.K,b)){e=$Xb.Ek(a.K,b);d=$Xb.Dk(a.K,b);}c=$Xb.zn(a.K,b);if(c!=-1){e=$Xb.$k(a.K,c);d=$Xb.Zk(a.K,c);}e!=-1&&e!=0&&(e|=d<<8);return e;};$Xb.hd=function hd(a){var b,c,d,e;a.wb(2*a.R);e=new $Xb.Zd();for(d=0;d<a.K.r;d++){b=$Xb.Vk(a.K,0,d);c=$Xb.Vk(a.K,1,d);if($Xb.wl(a.K,d)){e.a=$Xb.bi(a.Q,$Xb.Nk(a.K,b));e.c=$Xb.ci(a.Q,$Xb.Ok(a.K,b));e.b=$Xb.bi(a.Q,$Xb.Nk(a.K,c));e.d=$Xb.ci(a.Q,$Xb.Ok(a.K,c));$Xb.Ld(a,-2);a.mb(e);}}};$Xb.jd=function jd(a){var b,c,d,e,f,g;if(a.K.K){g=a.V;$Xb.Ld(a,-7);for(b=0;b<a.K.f;b++)cxb(Jwb($Xb.Lk(a.K,b),LZb),0)&&a.qb($Xb.bi(a.Q,$Xb.Nk(a.K,b))-g,$Xb.ci(a.Q,$Xb.Ok(a.K,b))-g,2*g);a.wb(2*a.V);f=new $Xb.Zd();for(e=0;e<a.K.r;e++){c=$Xb.Vk(a.K,0,e);d=$Xb.Vk(a.K,1,e);if(cxb(Jwb(Jwb($Xb.Lk(a.K,c),$Xb.Lk(a.K,d)),LZb),0)){f.a=$Xb.bi(a.Q,$Xb.Nk(a.K,c));f.c=$Xb.ci(a.Q,$Xb.Ok(a.K,c));f.b=$Xb.bi(a.Q,$Xb.Nk(a.K,d));f.d=$Xb.ci(a.Q,$Xb.Ok(a.K,d));a.mb(f);}}}};$Xb.kd=function kd(a){var b,c,d,e;if(a.K.K){$Xb.Ld(a,320);if((a.F&8)!=0)for(b=0;b<a.K.f;b++)cxb(Jwb($Xb.Lk(a.K,b),-536870913),0)&&a.qb($Xb.bi(a.Q,$Xb.Nk(a.K,b))-a.Y/2,$Xb.ci(a.Q,$Xb.Ok(a.K,b))-a.Y/2,a.Y);for(e=0;e<a.K.g;e++){if($Xb.dl(a.K,e)!=0){c=$Xb.Vk(a.K,0,e);d=$Xb.Vk(a.K,1,e);a.qb(($Xb.bi(a.Q,$Xb.Nk(a.K,c))+$Xb.bi(a.Q,$Xb.Nk(a.K,d))-a.Y)/2,($Xb.ci(a.Q,$Xb.Ok(a.K,c))+$Xb.ci(a.Q,$Xb.Ok(a.K,d))-a.Y)/2,a.Y);}}}};$Xb.ld=function ld(a){a.I=1;a.Q=new $Xb.di();a.Z=new _Xb.kj();a.T=new _Xb.kj();a.r=Sjb(UXb.Cwb,KZb,6,a.K.q,16,1);a.w=new lYb.AG();a.P=0;a.B=-1;$Xb.Qd(a);};$Xb.md=function md(a,b){var c;if($Xb.Dn(a.K,b)==0)return false;for(c=0;c<$Xb.Dn(a.K,b);c++)if(!$Xb.yl(a.K,$Xb.Tn(a.K,b,c)))return false;return true;};$Xb.nd=function nd(a){var b;a.q=Sjb(UXb.Cwb,KZb,6,a.K.q,16,1);for(b=0;b<a.K.r;b++){a.q[$Xb.Vk(a.K,0,b)]=true;a.q[$Xb.Vk(a.K,1,b)]=true;}};$Xb.od=function od(a,b){var c;if($Xb.Sn(a.K,b)!=2)return false;for(c=0;c<2;c++)if($Xb.Un(a.K,b,c)!=2)return false;return true;};$Xb.pd=function pd(a,b,c,d,e){var f,g,h,i,j,k,l,m,n,o;m=false;e.a=0;e.b=0;d>0?f=MZb:f=NZb;o=$Xb.Uk(a.K,b,c);for(k=0;k<$Xb.Sn(a.K,b);k++){g=$Xb.Tn(a.K,b,k);h=o;$Xb.Vk(a.K,0,g)==b?l=$Xb.Vk(a.K,1,g):l=$Xb.Vk(a.K,0,g);if(l==c)continue;n=$Xb.Uk(a.K,b,l);h<n&&(h+=OZb);i=h-n;if(d>0){i<PZb&&(m=true);i>MZb&&(i=MZb);i<0.523598776&&(i=0.523598776);if(i<=f){f=i;j=a.S*$wnd.Math.tan(f-QZb)/2;e.a=-(j*$wnd.Math.sin(h));e.b=-(j*$wnd.Math.cos(h));}}else {i>=PZb&&(m=true);i<NZb&&(i=NZb);i>5.759586531&&(i=5.759586531);if(i>=f){f=i;j=a.S*$wnd.Math.tan(4.712388981-f)/2;e.a=-(j*$wnd.Math.sin(h));e.b=-(j*$wnd.Math.cos(h));}}}return m;};$Xb.qd=function qd(a,b,c,d){var e;if(b==0){c<0?d.a=a.S:d.a=-a.S;d.b=0;return;}e=$wnd.Math.atan(c/b);b<0&&(e+=PZb);d.a=-(a.S*$wnd.Math.sin(e));d.b=a.S*$wnd.Math.cos(e);};$Xb.rd=function rd(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p;e=new $Xb.Zd();i=new $Xb.Zd();k=new lYb.AG();j=new lYb.AG();g=$Xb.Vk(a.K,0,c);h=$Xb.Vk(a.K,1,c);if(d){m=b.a;b.a=b.b;b.b=m;m=b.c;b.c=b.d;b.d=m;n=g;g=h;h=n;}if(!$Xb.Hd(a,b))return;if($Xb.Vo(a.K,c)){e.a=b.a;e.c=b.c;e.b=b.b;e.d=b.d;l=d?-$Xb.ro(a.K,c):$Xb.ro(a.K,c);l==0&&(l=1);$Xb.qd(a,b.b-b.a,b.d-b.c,k);if(l>0){i.a=b.a+k.a;i.c=b.c+k.b;i.b=b.b+k.a;i.d=b.d+k.b;if($Xb.pd(a,g,h,1,j)||$Xb.Sn(a.K,g)>1){i.a+=j.a+k.b;i.c+=j.b-k.a;}}else {i.a=b.a-k.a;i.c=b.c-k.b;i.b=b.b-k.a;i.d=b.d-k.b;if($Xb.pd(a,g,h,-1,j)||$Xb.Sn(a.K,g)>1){i.a+=j.a+k.b;i.c+=j.b-k.a;}}$Xb.el(a.K,c)==386&&$Xb.Gd(e,i);$Xb.Hd(a,e)&&$Xb.$c(a,e,g,h);$Xb.el(a.K,c)==64?$Xb.Hd(a,i)&&$Xb.Yc(a,i,g,h):$Xb.Hd(a,i)&&$Xb.$c(a,i,g,h);}else {$Xb.qd(a,b.b-b.a,b.d-b.c,k);o=k.a/2;p=k.b/2;f=false;e.a=b.a+o;e.c=b.c+p;e.b=b.b+o;e.d=b.d+p;if($Xb.Sn(a.K,g)>1){if($Xb.pd(a,g,h,1,j)){e.a+=j.a;e.c+=j.b;if($Xb.Sn(a.K,g)==2){if(j.a!=0||j.b!=0){e.a+=k.b;e.c-=k.a;}}}else {a.o[g]=new lYb.BG(e.a,e.c);}}i.a=b.a-o;i.c=b.c-p;i.b=b.b-o;i.d=b.d-p;if($Xb.Sn(a.K,g)>1){if($Xb.pd(a,g,h,0,j)){i.a+=j.a;i.c+=j.b;if($Xb.Sn(a.K,g)==2){if(j.a!=0||j.b!=0){i.a+=k.b;i.c-=k.a;}}}else {a.o[g]=new lYb.BG(i.a,i.c);f=true;}}$Xb.el(a.K,c)==386&&$Xb.Gd(e,i);if($Xb.el(a.K,c)==64){if(f){$Xb.Yc(a,e,g,h);$Xb.$c(a,i,g,h);}else {$Xb.$c(a,e,g,h);$Xb.Yc(a,i,g,h);}}else {$Xb.$c(a,e,g,h);$Xb.$c(a,i,g,h);}}};$Xb.sd=function sd(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o;k=a.P;l=a.D;if((a.F&RZb)!=0){a.P=-6;a.D=-8355712;$Xb.Ld(a,1);}a.o=Sjb(UXb.Bnb,kZb,33,a.K.q,0,1);for(i=0;i<a.K.r;i++)($Xb.el(a.K,i)==2||$Xb.el(a.K,i)==386||$Xb.el(a.K,i)==64)&&$Xb.vd(a,i);for(j=0;j<a.K.r;j++)$Xb.el(a.K,j)!=2&&$Xb.el(a.K,j)!=386&&$Xb.el(a.K,j)!=64&&$Xb.vd(a,j);if((a.F&64)==0){for(h=0;h<a.K.r;h++){if($Xb.Yk(a.K,h)!=0){e=null;$Xb.Yk(a.K,h)==1||$Xb.Yk(a.K,h)==2?($Xb.bl(a.K,h)==2||$Xb.$k(a.K,h)==0||b[$Xb.$k(a.K,h)][$Xb.Zk(a.K,h)]>1)&&($Xb.Yk(a.K,h)==1?e=$Xb.bl(a.K,h)==2?'E':$Xb.Al(a.K,h)?'p':'P':e=$Xb.bl(a.K,h)==2?'Z':$Xb.Al(a.K,h)?'m':'M'):e='?';if(e!=null){a.yb((a.W*2+1)/3|0);$Xb.Ld(a,$Xb.yl(a.K,h)?-3:a.K.O==1||(a.F&SZb)!=0?a.P:448);c=$Xb.Vk(a.K,0,h);d=$Xb.Vk(a.K,1,h);n=($Xb.bi(a.Q,$Xb.Nk(a.K,c))+$Xb.bi(a.Q,$Xb.Nk(a.K,d)))/2;o=($Xb.ci(a.Q,$Xb.Ok(a.K,c))+$Xb.ci(a.Q,$Xb.Ok(a.K,d)))/2;f=($Xb.bi(a.Q,$Xb.Nk(a.K,c))-$Xb.bi(a.Q,$Xb.Nk(a.K,d)))/3;g=($Xb.ci(a.Q,$Xb.Ok(a.K,c))-$Xb.ci(a.Q,$Xb.Ok(a.K,d)))/3;$Xb.yd(a,n+g,o-f,e,true);$Xb.Ld(a,a.P);a.yb(a.W);}}}}if((a.F&4)!=0){a.yb((a.W*2+1)/3|0);$Xb.Ld(a,384);for(h=0;h<a.K.r;h++){c=$Xb.Vk(a.K,0,h);d=$Xb.Vk(a.K,1,h);m=$Xb.Mo(a.K,h)?'d':$Xb.Io(a.K,h)?'a':'';n=($Xb.bi(a.Q,$Xb.Nk(a.K,c))+$Xb.bi(a.Q,$Xb.Nk(a.K,d)))/2;o=($Xb.ci(a.Q,$Xb.Ok(a.K,c))+$Xb.ci(a.Q,$Xb.Ok(a.K,d)))/2;$Xb.yd(a,n,o,m+(''+h),true);}$Xb.Ld(a,a.P);a.yb(a.W);}if((a.F&RZb)!=0){a.P=k;a.D=l;}};$Xb.td=function td(a){var b,c;for(c=new _Xb.rOb(a.T);c.a<c.c.a.length;){b=_Xb.qOb(c);$Xb.Ld(a,b.a);$Xb.Zc(a,b.b,b.c);}$Xb.Ld(a,a.P);};$Xb.ud=function ud(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W;a.J||a.tb(b,$Xb.Fk(a.K,b),$Xb.bi(a.Q,$Xb.Nk(a.K,b)),$Xb.ci(a.Q,$Xb.Ok(a.K,b)));M=null;if($Xb.zk(a.K,b)!=0){S=$wnd.Math.abs($Xb.zk(a.K,b))==1?'':''+$wnd.Math.abs($Xb.zk(a.K,b));M=$Xb.zk(a.K,b)<0?S+'-':S+'+';}a.s!=null&&b<a.s.length&&a.s[b]!=null&&YXb.LTb(a.s[b]).length>0&&(M=$Xb.Tc(M,a.s[b]));D=null;N=$Xb.Lk(a.K,b);if(Owb(N,0)!=0){cxb(Jwb(N,TZb),0)&&(D=D==null?'*':D+','+'*');cxb(Jwb(N,UZb),0)&&(D=D==null?'!*':D+','+'!*');cxb(Jwb(N,VZb),0)?D=D==null?'ha':D+','+'ha':cxb(Jwb(N,2),0)?D=D==null?'a':D+','+'a':cxb(Jwb(N,4),0)&&(D=D==null?'!a':D+','+'!a');cxb(Jwb(N,SZb),0)&&(D=D==null?'s':D+','+'s');if(cxb(Jwb(N,WZb),0)){w=Jwb(N,WZb);Owb(w,1792)==0?D=D==null?'h0':D+','+'h0':Owb(w,1664)==0?D=D==null?'h1':D+','+'h1':Owb(w,1408)==0?D=D==null?'h2':D+','+'h2':Owb(w,128)==0?D=D==null?'h>0':D+','+'h>0':Owb(w,384)==0?D=D==null?'h>1':D+','+'h>1':Owb(w,896)==0?D=D==null?'h>2':D+','+'h>2':Owb(w,XZb)==0?D=D==null?'h<3':D+','+'h<3':Owb(w,1536)==0&&(D=D==null?'h<2':D+','+'h<2');}if(cxb(Jwb(N,YZb),0)){i=Jwb(N,YZb);Owb(i,ZZb)==0?D=D==null?'c0':D+','+'c0':Owb(i,$Zb)==0?D=D==null?'c+':D+','+'c+':Owb(i,_Zb)==0&&(D=D==null?'c-':D+','+'c-');}if(cxb(Jwb(N,a$b),0)){L=Jwb(N,a$b);Owb(L,98304)==0?D=D==null?'pi0':D+','+'pi0':Owb(L,81920)==0?D=D==null?'pi1':D+','+'pi1':Owb(L,49152)==0?D=D==null?'pi2':D+','+'pi2':Owb(L,RZb)==0&&(D=D==null?'pi>0':D+','+'pi>0');}if(cxb(Jwb(N,b$b),0)){K=Jwb(N,b$b);Owb(K,c$b)==0?D=D==null?'n1':D+','+'n1':Owb(K,d$b)==0?D=D==null?'n2':D+','+'n2':Owb(K,e$b)==0?D=D==null?'n3':D+','+'n3':Owb(K,f$b)==0?D=D==null?'n<3':D+','+'n<3':Owb(K,g$b)==0?D=D==null?'n<4':D+','+'n<4':Owb(K,h$b)==0?D=D==null?'n>1':D+','+'n>1':Owb(K,i$b)==0?D=D==null?'n>2':D+','+'n>2':Owb(K,j$b)==0&&(D=D==null?'n>3':D+','+'n>3');}if(cxb(Jwb(N,k$b),0)){o=Jwb(N,k$b);Owb(o,l$b)==0?D=D==null?'e0':D+','+'e0':Owb(o,m$b)==0?D=D==null?'e1':D+','+'e1':Owb(o,n$b)==0?D=D==null?'e2':D+','+'e2':Owb(o,o$b)==0?D=D==null?'e3':D+','+'e3':Owb(o,15393162788864)==0?D=D==null?'e<2':D+','+'e<2':Owb(o,13194139533312)==0?D=D==null?'e<3':D+','+'e<3':Owb(o,p$b)==0?D=D==null?'e<4':D+','+'e<4':Owb(o,q$b)==0?D=D==null?'e>0':D+','+'e>0':Owb(o,r$b)==0?D=D==null?'e>1':D+','+'e>1':Owb(o,s$b)==0?D=D==null?'e>2':D+','+'e>2':Owb(o,t$b)==0?D=D==null?'e>3':D+','+'e>3':Owb(o,4947802324992)==0?D=D==null?'e1-2':D+','+'e1-2':Owb(o,9345848836096)==0?D=D==null?'e1-3':D+','+'e1-3':Owb(o,10445360463872)==0&&(D=D==null?'e2-3':D+','+'e2-3');}if(cxb(Jwb(N,120),0)){O=Jwb(N,120);Owb(O,112)==0?D=D==null?'!r':D+','+'!r':Owb(O,8)==0?D=D==null?'r':D+','+'r':Owb(O,96)==0?D=D==null?'rb<3':D+','+'rb<3':Owb(O,104)==0?D=D==null?'rb2':D+','+'rb2':Owb(O,88)==0?D=D==null?'rb3':D+','+'rb3':Owb(O,56)==0&&(D=D==null?'rb4':D+','+'rb4');}cxb(Jwb(N,u$b),0)&&(D=D==null?'r'+mxb(gxb(Jwb(N,u$b),22)):D+','+('r'+mxb(gxb(Jwb(N,u$b),22))));cxb(Jwb(N,CZb),0)&&(D=$Xb.Tc(D,$Xb.Wc(N)));cxb(Jwb(N,v$b),0)&&(D=D==null?'f':D+','+'f');}$Xb.Jk(a.K,b)!=0&&(D=$Xb.Tc(D,''+$Xb.Jk(a.K,b)));R=0;if($Xb.Mk(a.K,b)!=0){switch($Xb.Mk(a.K,b)){case 16:M=M==null?'|':M+','+'|';break;case 32:R=1;break;case 48:R=2;}}l=null;if((a.F&64)==0){if($Xb.rl(a.K,b))l='?';else if($Xb.yk(a.K,b)!=0){if($Xb.Ek(a.K,b)==0||c==null||c[$Xb.Ek(a.K,b)][$Xb.Dk(a.K,b)]>1){if($Xb.Sn(a.K,b)==2){switch($Xb.yk(a.K,b)){case 2:l=$Xb.tl(a.K,b)?'p':'P';break;case 1:l=$Xb.tl(a.K,b)?'m':'M';break;default:l='*';}}else {switch($Xb.yk(a.K,b)){case 1:l=$Xb.tl(a.K,b)?'r':'R';break;case 2:l=$Xb.tl(a.K,b)?'s':'S';break;default:l='*';}}}}}(a.F&768)!=0&&(l=$Xb.Tc(l,''+$Xb.yu(a.K,b)));I=null;(a.F&16)!=0&&$Xb.Ik(a.K,b)!=0&&(I=''+$Xb.Ik(a.K,b));q=null;if($Xb.wo(a.K,b)!=-1){p=$Xb.gd(a,b);p!=-1&&(q=p==0?'abs':((p&255)==1?'&':'or')+(1+(p>>8)));}A=0;(a.F&w$b)==0&&(a.K.K?cxb(Jwb($Xb.Lk(a.K,b),x$b),0)&&(A=$Xb.fo(a.K,b)):($Xb.Qk(a.K,b)!=6||$Xb.Jk(a.K,b)!=0||!a.q[b]||$Xb.Mk(a.K,b)!=0)&&(A=$Xb.fo(a.K,b)));H=false;f=$Xb.Bk(a.K,b);if(f!=null&&VXb.DHb(YXb.LTb(f).substr(0,1),']')){D=$Xb.Tc((YXb.GTb(1,YXb.LTb(f).length+1),YXb.LTb(f).substr(1)),D);f=null;H=true;}if(f!=null){A=0;}else if($Xb.Gk(a.K,b)!=null){e=cxb(Jwb($Xb.Lk(a.K,b),1),0)?'[!':'[';f=e+$Xb.Hk(a.K,b)+']';YXb.LTb(f).length>5&&(f=e+$Xb.Gk(a.K,b).length+']');cxb(Jwb($Xb.Lk(a.K,b),x$b),0)&&(A=-1);}else if(cxb(Jwb($Xb.Lk(a.K,b),1),0)){f='?';cxb(Jwb($Xb.Lk(a.K,b),x$b),0)&&(A=-1);}else ($Xb.Qk(a.K,b)!=6||M!=null||D!=null||A>0||!a.q[b])&&(f=$Xb.Fk(a.K,b));G=0;!$Xb.Jl(a.K,b)&cxb(Jwb($Xb.Lk(a.K,b),LZb),0)&&$Xb.Ld(a,-8);if(f!=null){G=a.rb(f);$Xb.yd(a,$Xb.bi(a.Q,$Xb.Nk(a.K,b)),$Xb.ci(a.Q,$Xb.Ok(a.K,b)),f,true);a.r[b]=true;}else $Xb.od(a,b)&&$Xb.xd(a,$Xb.bi(a.Q,$Xb.Nk(a.K,b)),$Xb.ci(a.Q,$Xb.Ok(a.K,b)),b);if(M!=null){a.yb((a.W*2+1)/3|0);T=$Xb.bi(a.Q,$Xb.Nk(a.K,b))+((G+a.rb(M))/2+1);V=$Xb.ci(a.Q,$Xb.Ok(a.K,b))-((a.sb()*4-4)/8|0);$Xb.yd(a,T,V,M,true);a.yb(a.W);}(a.F&2)!=0&&(D=''+b);if(D!=null){H?a.yb((a.W*5+1)/6|0):a.yb((a.W*2+1)/3|0);T=$Xb.bi(a.Q,$Xb.Nk(a.K,b))-(G+a.rb(D))/2;V=$Xb.ci(a.Q,$Xb.Ok(a.K,b))-((a.sb()*4-4)/8|0);$Xb.yd(a,T,V,D,true);a.yb(a.W);}if(l!=null){a.yb((a.W*2+1)/3|0);T=$Xb.bi(a.Q,$Xb.Nk(a.K,b))-(G+a.rb(l))/2;V=$Xb.ci(a.Q,$Xb.Ok(a.K,b))+((a.sb()*4+4)/8|0);Q=a.B;a.K.O!=1&&(a.F&SZb)==0&&$Xb.Ld(a,448);$Xb.yd(a,T,V,l,false);$Xb.Ld(a,Q);a.yb(a.W);}if(I!=null){a.yb((a.W*2+1)/3|0);T=$Xb.bi(a.Q,$Xb.Nk(a.K,b))+((G+a.rb(I))/2+1);V=$Xb.ci(a.Q,$Xb.Ok(a.K,b))+((a.sb()*4+4)/8|0);Q=a.B;$Xb.Ld(a,$Xb.vl(a.K,b)?384:448);$Xb.yd(a,T,V,I,true);$Xb.Ld(a,Q);a.yb(a.W);}if(q!=null){d=$Xb.Cd(a,b);a.yb((a.W*2+1)/3|0);T=$Xb.bi(a.Q,$Xb.Nk(a.K,b))+0.7*a.sb()*$wnd.Math.sin(d);V=$Xb.ci(a.Q,$Xb.Ok(a.K,b))+0.7*a.sb()*$wnd.Math.cos(d);Q=a.B;!a.J&&a.K.O!=1&&$Xb.Ld(a,$Xb.fd(a,b));$Xb.yd(a,T,V,q,false);$Xb.Ld(a,Q);a.yb(a.W);}if(A==0&&R==0){a.B==-8&&$Xb.Ld(a,-9);return;}u=Sjb(UXb.jlb,wZb,6,4,15,1);for(C=0;C<$Xb.En(a.K,b);C++){h=$Xb.Tn(a.K,b,C);for(F=0;F<2;F++){if($Xb.Vk(a.K,F,h)==b){P=$Xb.Uk(a.K,$Xb.Vk(a.K,F,h),$Xb.Vk(a.K,1-F,h));if(P<y$b){u[0]-=P+QZb;u[3]+=P+PZb;}else if(P<0){u[2]+=P+QZb;u[3]-=P;}else if(P<QZb){u[1]+=P;u[2]+=QZb-P;}else {u[0]+=P-QZb;u[1]+=PZb-P;}}}}$Xb.Sn(a.K,b)==0?$Xb.Cl(a.K,b)?u[3]-=0.2:u[1]-=0.2:u[1]-=0.1;(M!=null||I!=null)&&(u[1]+=10);(D!=null||l!=null)&&(u[3]+=10);s='';if(A!=0){v=a.rb('H');t=0;r=a.sb();if(A==-1){s='n';a.yb((a.W*2+1)/3|0);t=a.rb(s);}else if(A>1){s=''+A;a.yb((a.W*2+1)/3|0);t=a.rb(s);}if(u[1]<0.6||u[3]<0.6){k=$Xb.ci(a.Q,$Xb.Ok(a.K,b));if(u[1]<=u[3]){u[1]+=10;j=$Xb.bi(a.Q,$Xb.Nk(a.K,b))+(G+v)/2;}else {u[3]+=10;j=$Xb.bi(a.Q,$Xb.Nk(a.K,b))-(G+v)/2-t;}}else {j=$Xb.bi(a.Q,$Xb.Nk(a.K,b));if(u[0]<u[2]){u[0]+=10;k=$Xb.ci(a.Q,$Xb.Ok(a.K,b))-r;}else {u[2]+=10;k=$Xb.ci(a.Q,$Xb.Ok(a.K,b))+r;}}if(t>0){T=j+(v+t)/2;V=k+((a.sb()*4+4)/8|0);$Xb.yd(a,T,V,s,true);a.yb(a.W);}$Xb.yd(a,j,k,'H',true);}g=0;if(R!=0){J=50;m=0;for(B=0;B<4;B++){n=B>1?B-2:B+2;if(u[B]<J){g=B;J=u[B];m=u[n];}else if(u[B]==J){if(u[n]>m){g=B;m=u[n];}}}switch(g){case 0:j=$Xb.bi(a.Q,$Xb.Nk(a.K,b));k=$Xb.ci(a.Q,$Xb.Ok(a.K,b))-a.U-G/2;break;case 1:j=$Xb.bi(a.Q,$Xb.Nk(a.K,b))+a.U+G/2;k=$Xb.ci(a.Q,$Xb.Ok(a.K,b));break;case 2:j=$Xb.bi(a.Q,$Xb.Nk(a.K,b));k=$Xb.ci(a.Q,$Xb.Ok(a.K,b))+a.U+G/2;break;default:j=$Xb.bi(a.Q,$Xb.Nk(a.K,b))-a.U-G/2;k=$Xb.ci(a.Q,$Xb.Ok(a.K,b));}if(R==1){_Xb.Si(a.Z,new lYb.KG(j-a.U,k-a.U,2*a.U,2*a.U));a.J||_Xb.Si(a.T,new $Xb.Yd(j,k,$Xb.md(a,b)?-3:a.p[b]));}else {switch(g){case 2:case 0:U=2*a.U;W=0;j-=a.U;break;case 1:U=0;W=2*a.U;k-=a.U;break;default:U=0;W=2*a.U;k-=a.U;}_Xb.Si(a.Z,new lYb.KG(j-a.U,k-a.U,2*a.U,2*a.U));a.J||_Xb.Si(a.T,new $Xb.Yd(j,k,$Xb.md(a,b)?-3:a.p[b]));_Xb.Si(a.Z,new lYb.KG(j+U-a.U,k+W-a.U,2*a.U,2*a.U));a.J||_Xb.Si(a.T,new $Xb.Yd(j+U,k+W,$Xb.md(a,b)?-3:a.p[b]));}}a.B==-8&&$Xb.Ld(a,-9);};$Xb.vd=function vd(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v;t=new $Xb.Zd();c=new $Xb.Zd();g=new $Xb.Zd();q=new lYb.AG();p=new lYb.AG();e=$Xb.Vk(a.K,0,b);f=$Xb.Vk(a.K,1,b);a.ub(b,$Xb.bi(a.Q,$Xb.Nk(a.K,e)),$Xb.ci(a.Q,$Xb.Ok(a.K,e)),$Xb.bi(a.Q,$Xb.Nk(a.K,f)),$Xb.ci(a.Q,$Xb.Ok(a.K,f)));!$Xb.Jl(a.K,e)&&!$Xb.Jl(a.K,f)&&cxb(Jwb(exb($Xb.Lk(a.K,e),$Xb.Lk(a.K,f)),LZb),0)&&$Xb.Ld(a,-8);if(!a.o[e]){t.a=$Xb.bi(a.Q,$Xb.Nk(a.K,e));t.c=$Xb.ci(a.Q,$Xb.Ok(a.K,e));}else {t.a=a.o[e].a;t.c=a.o[e].b;}if(!a.o[f]){t.b=$Xb.bi(a.Q,$Xb.Nk(a.K,f));t.d=$Xb.ci(a.Q,$Xb.Ok(a.K,f));}else {t.b=a.o[f].a;t.d=a.o[f].b;}if(($Xb.dl(a.K,b)&z$b)!=0){$Xb.Hd(a,t)&&a.nb(t);$Xb.Ld(a,-9);return;}h=$Xb.el(a.K,b)==64?0:$Xb.el(a.K,b)==32?1:$Xb.bl(a.K,b);switch(h){case 1:i=$Xb.el(a.K,b);if((a.F&128)!=0&&(i==257||i==129)){s=$Xb.Vk(a.K,0,b);n=$Xb.Ek(a.K,s);if(n!=0){m=$Xb.Dk(a.K,s);l=0;for(d=0;d<a.K.f;d++)$Xb.Ek(a.K,d)==n&&$Xb.Dk(a.K,d)==m&&++l;l==1&&(i=1);}}switch(i){case 1:$Xb.Hd(a,t)&&$Xb.$c(a,t,e,f);break;case 257:$Xb.Ed(a,t,e,f);break;case 129:u=t.b-t.a;v=t.d-t.c;if($Xb.yl(a.K,$Xb.Pn(a.K,e,f))){j=-3;k=-3;}else {j=a.p[e];k=$Xb.fd(a,e);j==$Xb.Ak(a.K,e)&&(j=k);}for(o=2;o<17;o+=2){c.a=t.a+o*u/17-o*v/128;c.c=t.c+o*v/17+o*u/128;c.b=t.a+o*u/17+o*v/128;c.d=t.c+o*v/17-o*u/128;if($Xb.Hd(a,c)){$Xb.Ld(a,o<9?j:k);a.mb(c);$Xb.Ld(a,a.P);}}break;case 32:$Xb.Hd(a,t)&&$Xb.ad(a,t,e,f);}break;case 0:case 2:if((a.r[e]||$Xb.In(a.K,e)==2)&&(a.r[f]||$Xb.In(a.K,f)==2)&&!$Xb.Vo(a.K,b)&&h==2){if(!$Xb.Hd(a,t))break;$Xb.qd(a,t.b-t.a,t.d-t.c,q);u=q.a/2;v=q.b/2;c.a=t.a+u;c.c=t.c+v;c.b=t.b+u;c.d=t.d+v;g.a=t.a-u;g.c=t.c-v;g.b=t.b-u;g.d=t.d-v;$Xb.el(a.K,b)==386&&$Xb.Gd(c,g);$Xb.$c(a,c,e,f);h==2?$Xb.$c(a,g,e,f):$Xb.Yc(a,g,e,f);}else if((a.r[f]||$Xb.In(a.K,f)==2)&&h==2){$Xb.rd(a,t,b,false);}else if((a.r[e]||$Xb.In(a.K,e)==2)&&h==2){$Xb.rd(a,t,b,true);}else {r=$Xb.ro(a.K,b);r==0&&(r=1);c.a=t.a;c.c=t.c;c.b=t.b;c.d=t.d;$Xb.qd(a,t.b-t.a,t.d-t.c,q);if(r>0){g.a=t.a+q.a;g.c=t.c+q.b;g.b=t.b+q.a;g.d=t.d+q.b;if($Xb.pd(a,e,f,1,p)||$Xb.Sn(a.K,e)>1){g.a+=p.a+q.b;g.c+=p.b-q.a;}if($Xb.pd(a,f,e,-1,p)||$Xb.Sn(a.K,f)>1){g.b+=p.a-q.b;g.d+=p.b+q.a;}}else {g.a=t.a-q.a;g.c=t.c-q.b;g.b=t.b-q.a;g.d=t.d-q.b;if($Xb.pd(a,e,f,-1,p)||$Xb.Sn(a.K,e)>1){g.a+=p.a+q.b;g.c+=p.b-q.a;}if($Xb.pd(a,f,e,1,p)||$Xb.Sn(a.K,f)>1){g.b+=p.a-q.b;g.d+=p.b+q.a;}}$Xb.el(a.K,b)==386&&$Xb.Gd(c,g);$Xb.Hd(a,c)&&$Xb.$c(a,c,e,f);h==2?$Xb.Hd(a,g)&&$Xb.$c(a,g,e,f):$Xb.Hd(a,g)&&$Xb.Yc(a,g,e,f);}break;case 3:if($Xb.Hd(a,t)){$Xb.$c(a,t,e,f);$Xb.qd(a,t.b-t.a,t.d-t.c,q);$Xb._c(a,t,e,f,q.a,q.b,c);$Xb._c(a,t,e,f,-q.a,-q.b,c);}break;case 4:if($Xb.Hd(a,t)){$Xb.qd(a,t.b-t.a,t.d-t.c,q);$Xb._c(a,t,e,f,1.5*q.a,1.5*q.b,c);$Xb._c(a,t,e,f,0.5*q.a,0.5*q.b,c);$Xb._c(a,t,e,f,-0.5*q.a,-0.5*q.b,c);$Xb._c(a,t,e,f,-1.5*q.a,-1.5*q.b,c);}break;case 5:if($Xb.Hd(a,t)){$Xb.$c(a,t,e,f);$Xb.qd(a,t.b-t.a,t.d-t.c,q);$Xb._c(a,t,e,f,2*q.a,2*q.b,c);$Xb._c(a,t,e,f,q.a,q.b,c);$Xb._c(a,t,e,f,-q.a,-q.b,c);$Xb._c(a,t,e,f,-2*q.a,-2*q.b,c);}}a.B==-8&&$Xb.Ld(a,-9);};$Xb.wd=function wd(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p;n=false;for(d=0;d<a.K.g;d++){j=null;if($Xb.xl(a.K,d)){l=$Xb.Xk(a.K,d);k=$Xb.Wk(a.K,d);j=l==k?'['+l+']':'['+l+':'+k+']';}else ($Xb.dl(a.K,d)&A$b)!=0?j=($Xb.dl(a.K,d)&A$b)==g$b?'a':($Xb.dl(a.K,d)&384)==256?'r!a':'!a':($Xb.dl(a.K,d)&384)!=0&&(j=($Xb.dl(a.K,d)&384)==256?'r':'!r');m=($Xb.dl(a.K,d)&i$b)>>17;m!=0&&(j=(j==null?'':j)+m);if(j!=null){b=$Xb.Vk(a.K,0,d);c=$Xb.Vk(a.K,1,d);if(!n){a.yb((a.W*2+1)/3|0);n=true;}o=($Xb.bi(a.Q,$Xb.Nk(a.K,b))+$Xb.bi(a.Q,$Xb.Nk(a.K,c)))/2;p=($Xb.ci(a.Q,$Xb.Ok(a.K,b))+$Xb.ci(a.Q,$Xb.Ok(a.K,c)))/2;f=$Xb.bi(a.Q,$Xb.Nk(a.K,c))-$Xb.bi(a.Q,$Xb.Nk(a.K,b));g=$Xb.ci(a.Q,$Xb.Ok(a.K,c))-$Xb.ci(a.Q,$Xb.Ok(a.K,b));e=$wnd.Math.sqrt(f*f+g*g);i=0.6*a.rb(j);h=0.55*a.sb();e!=0&&(f>0?$Xb.yd(a,o+i*g/e,p-h*f/e,j,true):$Xb.yd(a,o-i*g/e,p+h*f/e,j,true));}}n&&a.yb(a.W);};$Xb.xd=function xd(a,b,c,d){_Xb.Si(a.Z,new lYb.KG(b-a.U,c-a.U,2*a.U,2*a.U));a.J||_Xb.Si(a.T,new $Xb.Yd(b,c,$Xb.md(a,d)?-3:a.p[d]));};$Xb.yd=function yd(a,b,c,d,e){var f,g,h;if(e){f=a.rb(d);g=f/2+(a.sb()/8|0);h=a.sb()/2|0;(d=='+'||d=='-')&&(h=h*2/3);_Xb.Si(a.Z,new lYb.KG(b-g,c-h,2*g,2*h));}a.J||a.pb(d,b,c);};$Xb.zd=function zd(a){var b;b=a.a;a.a=a.b;a.b=b;b=a.c;a.c=a.d;a.d=b;};$Xb.Ad=function Ad(a,b,c){var d;d=b==0?OZb+a[0]-a[a.length-1]:a[b]-a[b-1];c>B$b&&c<C$b?d-=2*$wnd.Math.cos(c+D$b):d-=0.5*$wnd.Math.cos(c+D$b);return d;};$Xb.Bd=function Bd(a){var b;b=new lYb.JG();if(a.a<=a.b){b.c=a.a;b.b=a.b-a.a;}else {b.c=a.b;b.b=a.a-a.b;}if(a.c<=a.d){b.d=a.c;b.a=a.d-a.c;}else {b.d=a.d;b.a=a.c-a.d;}return b;};$Xb.Cd=function Cd(a,b){var c,d,e,f,g,h,i;c=Sjb(UXb.jlb,wZb,6,$Xb.Dn(a.K,b),15,1);for(e=0;e<$Xb.Dn(a.K,b);e++)c[e]=$Xb.Uk(a.K,b,$Xb.Rn(a.K,b,e));YXb.fTb(c,YXb.LTb(Axb(_Xb.TOb.prototype.Zd,_Xb.TOb,[])));f=$Xb.Dd(c,0);g=$Xb.Ad(c,0,f);for(d=1;d<c.length;d++){h=$Xb.Dd(c,d);i=$Xb.Ad(c,d,h);if(g<i){g=i;f=h;}}return f;};$Xb.Dd=function Dd(a,b){var c;if(b>0)return (a[b]+a[b-1])/2;c=PZb+(a[0]+a[a.length-1])/2;return c>PZb?c-OZb:c;};$Xb.Ed=function Ed(a,b,c,d){var e,f,g,h;h=new $Xb.Zd();if(b.a==b.b&&b.c==b.d)return;h.a=b.a;h.c=b.c;h.b=b.b;h.d=b.d;g=$Xb.Bd(h);for(e=0;e<a.Z.a.length;e++){f=_Xb.Xi(a.Z,e);if(f.c>g.c+g.b||f.d>g.d+g.a||g.c>f.c+f.b||g.d>f.d+f.a)continue;if($Xb.Fd(a,h.a,h.c,e)){if($Xb.Fd(a,h.b,h.d,e))return;$Xb.Id(a,h,0,e);$Xb.Ed(a,h,c,d);return;}if($Xb.Fd(a,h.b,h.d,e)){$Xb.Id(a,h,1,e);$Xb.Ed(a,h,c,d);return;}}$Xb.bd(a,h,c,d);};$Xb.Fd=function Fd(a,b,c,d){var e;if((a.F&1)!=0)return false;e=_Xb.Xi(a.Z,d);return b>e.c&&b<e.c+e.b&&c>e.d&&c<e.d+e.a;};$Xb.Gd=function Gd(a,b){var c;c=a.b;a.b=b.b;b.b=c;c=a.d;a.d=b.d;b.d=c;};$Xb.Hd=function Hd(a,b){var c,d,e,f,g,h;if(b.a==b.b&&b.c==b.d){for(g=new _Xb.rOb(a.Z);g.a<g.c.a.length;){f=_Xb.qOb(g);if(lYb.FG(f,b.a,b.c))return false;}return true;}h=$Xb.Bd(b);c=false;if(b.a>b.b){$Xb.zd(b);c=true;}for(d=0;d<a.Z.a.length;d++){f=_Xb.Xi(a.Z,d);if(f.c>h.c+h.b||f.d>h.d+h.a||h.c>f.c+f.b||h.d>f.d+f.a)continue;if($Xb.Fd(a,b.a,b.c,d)){if($Xb.Fd(a,b.b,b.d,d)){c&&$Xb.zd(b);return false;}$Xb.Id(a,b,0,d);e=$Xb.Hd(a,b);c&&$Xb.zd(b);return e;}if($Xb.Fd(a,b.b,b.d,d)){$Xb.Id(a,b,1,d);e=$Xb.Hd(a,b);c&&$Xb.zd(b);return e;}}c&&$Xb.zd(b);return true;};$Xb.Id=function Id(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o;if(c==0){l=b.a;n=b.c;m=b.b;o=b.d;}else {l=b.b;n=b.d;m=b.a;o=b.c;}k=_Xb.Xi(a.Z,d);i=m>l?k.c+k.b:k.c;j=o>n?k.d+k.a:k.d;e=m-l;f=o-n;if($wnd.Math.abs(e)>$wnd.Math.abs(f)){if(n==o){g=i;h=n;}else {g=l+e*(j-n)/f;if(m>l==i>g){h=j;}else {g=i;h=n+f*(i-l)/e;}}}else {if(l==m){g=l;h=j;}else {h=n+f*(i-l)/e;if(o>n==j>h){g=i;}else {g=l+e*(j-n)/f;h=j;}}}if(c==0){b.a=g;b.c=h;}else {b.b=g;b.d=h;}};$Xb.Jd=function Jd(a){var b,c,d,e;if(a.K.q==0)return;$Xb.nu(a.K,(a.F&256)!=0?63:(a.F&512)!=0?95:31);$Xb.Vc(a);c=$Xb.su(a.K);d=false;a.p=Sjb(UXb.llb,yZb,6,a.K.q,15,1);for(b=0;b<a.K.q;b++){a.p[b]=$Xb.Ak(a.K,b);a.p[b]!=0&&(d=true);$Xb.Jl(a.K,b)&&(a.p[b]=128);$Xb.ml(a.K,b)&&(a.F&x$b)==0&&(a.p[b]=256);}$Xb.Ld(a,-10);$Xb.jd(a);$Xb.hd(a);$Xb.kd(a);$Xb.Sc(a);a.yb(a.W);a.wb(a.X);$Xb.Ld(a,a.P);$Xb.nd(a);YXb.eTb(a.T.a,0);YXb.eTb(a.Z.a,0);if((a.F&1)!=0){$Xb.sd(a,c);$Xb.td(a);$Xb.wd(a);}for(e=0;e<a.K.q;e++){if($Xb.md(a,e)){$Xb.Ld(a,-3);$Xb.ud(a,e,c);$Xb.Ld(a,a.P);}else if(a.p[e]!=0){$Xb.Ld(a,a.p[e]);$Xb.ud(a,e,c);$Xb.Ld(a,a.P);}else if(!d&&a.K.O!=1&&$Xb.Qk(a.K,e)!=1&&$Xb.Qk(a.K,e)!=6&&(a.F&XZb)==0&&$Xb.Gk(a.K,e)==null&&$Xb.Qk(a.K,e)<$Xb.Pc.length){$Xb.Nd(a,$Xb.ed(a,$Xb.Pc[$Xb.Qk(a.K,e)]));$Xb.ud(a,e,c);$Xb.Ld(a,a.P);}else {$Xb.ud(a,e,c);}}if((a.F&1)==0){$Xb.td(a);$Xb.wd(a);$Xb.sd(a,c);}};$Xb.Kd=function Kd(a,b,c,d){var e;e=c/2;switch(d&E$b){case E$b:if(b){a.w.a=b.c+b.b/2;a.w.b=b.d+b.a-e;break;}case 0:a.w.a=a.v.c+a.v.b/2;a.w.b=a.v.d+a.v.a+e;!!b&&a.w.b>b.d+b.a-e&&(a.w.b=b.d+b.a-e);break;case F$b:if(b){a.w.a=b.c+b.b/2;a.w.b=b.d+e;break;}case G$b:a.w.a=a.v.c+a.v.b/2;a.w.b=a.v.d-e;!!b&&a.w.b<b.d+e&&(a.w.b=b.d+e);}};$Xb.Ld=function Ld(a,b){if(a.J)return;if(b==-10){a.B=-999;b=a.P;}b!=-2&&b!=-7&&a.M!=0&&(b=-4);if(b==a.B)return;if(a.B==-8&&b!=-9)return;b==-8&&(a.N=a.B);b==-9&&(b=a.N);a.B=b;switch(b){case 0:a.xb(a.D==0?H$b:a.D);break;case-6:a.xb(a.D);break;case-4:a.xb(a.M);break;case-2:a.xb(a.t);break;case-3:a.xb(a.u);break;case-7:a.xb(a.G);break;case-8:a.xb(a.H);break;case-5:a.xb(a.O);break;case 64:a.xb(-14655233);break;case 128:a.xb(I$b);break;case 256:a.xb(-4194049);break;case 192:a.xb(-16711936);break;case 320:a.xb(-24576);break;case 384:a.xb(-16744448);break;case 448:a.xb(-6291456);break;case 1:a.xb(-8355712);break;default:a.xb(H$b);}};$Xb.Md=function Md(a,b){a.F=b;};$Xb.Nd=function Nd(a,b){if(a.M!=0){if(a.B!=-4){a.B=-4;a.xb(a.M);}return;}a.B=-5;a.O=b;a.xb(b);};$Xb.Od=function Od(a){var b,c,d,e,f;e=$Xb.bi(a.Q,$Xb.Nk(a.K,0));c=$Xb.bi(a.Q,$Xb.Nk(a.K,0));f=$Xb.ci(a.Q,$Xb.Ok(a.K,0));d=$Xb.ci(a.Q,$Xb.Ok(a.K,0));for(b=0;b<a.K.q;b++){e>$Xb.bi(a.Q,$Xb.Nk(a.K,b))&&(e=$Xb.bi(a.Q,$Xb.Nk(a.K,b)));c<$Xb.bi(a.Q,$Xb.Nk(a.K,b))&&(c=$Xb.bi(a.Q,$Xb.Nk(a.K,b)));f>$Xb.ci(a.Q,$Xb.Ok(a.K,b))&&(f=$Xb.ci(a.Q,$Xb.Ok(a.K,b)));d<$Xb.ci(a.Q,$Xb.Ok(a.K,b))&&(d=$Xb.ci(a.Q,$Xb.Ok(a.K,b)));}return new lYb.KG(e,f,c-e,d-f);};$Xb.Pd=function Pd(a,b,c){var d,e;if(a.K.q==0)return null;a.v=$Xb.Od(a);d=a.Q.c*$Xb.Rk(a.K);e=new $Xb.fi(a.v,b,d,c);if(e.c==1&&e.a==0&&e.b==0){e=null;}else {$Xb.Xh(e,a.Q);$Xb.$h(e,a.v);}$Xb.Kd(a,b,d,c);return e;};$Xb.Qd=function Qd(a){var b;b=a.L!=0?a.L:a.C!=0?a.C:-1;a.t=yYb.p6(b);a.u=yYb.o6(J$b,b);a.G=-24321;a.H=-6291392;};$Xb.Rd=function Rd(a,b){var c;$Xb.Sd(a,b,oZb);if($Xb.ai(a.Q)){return null;}else {c=a.Q;$Xb.Yh(a.Q,a.K);a.Q=new $Xb.di();return c;}};$Xb.Sd=function Sd(a,b,c){var d,e,f,g;if(a.K.q==0)return null;f=a.zb(b,c);$Xb.nu(a.K,(a.F&256)!=0?63:(a.F&512)!=0?95:31);$Xb.nd(a);YXb.eTb(a.T.a,0);YXb.eTb(a.Z.a,0);$Xb.Vc(a);a.yb(a.W);a.J=true;for(e=0;e<a.K.q;e++)$Xb.ud(a,e,null);a.J=false;d=a.Q.c*$Xb.Rk(a.K);$Xb.cd(a,d);$Xb.Kd(a,b,d,c);if(!b||lYb.GG(b,a.v))return f;g=new $Xb.fi(a.v,b,d,c);$Xb.Xh(g,a.Q);$Xb.$h(g,a.v);$Xb.Zh(g,a.w);if(!f)return g;$Xb.Xh(g,f);return f;};$Xb.Td=function Td(a,b){$Xb.Qc();$Xb.Rc(this);this.K=a;this.F=b;$Xb.ld(this);};xxb(144,1,{144:1});_.tb=function Ud(a,b,c,d){};_.ub=function Vd(a,b,c,d,e){};_.vb=function Wd(a){$Xb.Jd(this);};_.zb=function Xd(a,b){return $Xb.Pd(this,a,b);};_.t=0;_.u=0;_.A=0;_.B=0;_.C=0;_.D=0;_.F=0;_.G=0;_.H=0;_.I=0;_.J=false;_.L=0;_.M=0;_.N=0;_.O=0;_.P=0;_.R=0;_.S=0;_.U=0;_.V=0;_.W=0;_.X=0;_.Y=0;UXb.qlb=VFb(144);$Xb.Yd=function Yd(a,b,c){this.b=a;this.c=b;this.a=c;};xxb(161,1,{161:1},$Xb.Yd);_.a=0;_.b=0;_.c=0;UXb.olb=VFb(161);$Xb.Zd=function Zd(){};xxb(81,1,{},$Xb.Zd);_.a=0;_.b=0;_.c=0;_.d=0;UXb.plb=VFb(81);$Xb.$d=function $d(a){return K$b+a.Cb()+'"'+a.Bb()+L$b;};xxb(229,1,{229:1});_.lb=function _d(){var a;a=new VXb._Hb();VXb.$Hb(a,K$b+this.Cb()+'"'+this.Bb()+L$b);return a.a;};_.d=false;UXb.rlb=VFb(229);$Xb.ae=function ae(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X;J=Sjb(UXb.Cwb,KZb,6,b.i.a.length,16,1);A=Sjb(UXb.llb,yZb,6,a.f.f,15,1);for(T=0;T<b.i.a.length;T++){J[T]=true;for(q=_Xb.Xi(b.j,T),r=0,s=q.length;r<s;++r){t=q[r];if(!a.e[t]){J[T]=false;break;}}if(J[T])for(d=_Xb.Xi(b.i,T),g=0,j=d.length;g<j;++g){c=d[g];++A[c];}}I=Sjb(UXb.Cwb,KZb,6,a.f.f,16,1);for(U=0;U<b.i.a.length;U++){V=_Xb.Xi(b.j,U).length;if(V==3||V==5||V==6||V==7){if(J[U]){for(e=_Xb.Xi(b.i,U),h=0,k=e.length;h<k;++h){c=e[h];I[c]=true;}Q=true;M=-1;N=0;for(f=_Xb.Xi(b.i,U),i=0,l=f.length;i<l;++i){c=f[i];if(V==6||A[c]>1){if(!$Xb.ee(a,c,false)){Q=false;break;}}else {S=V==5?$Xb.be(a,c,false):$Xb.ce(a,c,false);if($Xb.ee(a,c,false)){if(N<S){N=S;M=c;}}else {if(N==10){Q=false;break;}M=c;N=20;}}}if(Q){for(d=_Xb.Xi(b.i,U),g=0,j=d.length;g<j;++g){c=d[g];if(c==M){V==5?$Xb.be(a,c,true):$Xb.ce(a,c,true);$Xb.pe(a,c);}else {$Xb.ee(a,c,true);}}}}}}w=Sjb(UXb.llb,yZb,6,a.f.f,15,1);C=Sjb(UXb.Cwb,KZb,6,a.f.f,16,1);for(p=0;p<a.f.g;p++){m=$Xb.Vk(a.f,0,p);n=$Xb.Vk(a.f,1,p);if(!I[m]&&!I[n]){if(a.e[p]){++w[m];++w[n];}if($Xb.el(a.f,p)==32){C[m]=true;C[n]=true;}}}R=Sjb(UXb.llb,yZb,6,a.f.f,15,1);B=Sjb(UXb.llb,yZb,6,a.f.f,15,1);for(X=0;X<a.f.f;X++){if(w[X]==1){B[0]=X;v=0;D=0;while(v<=D){for(F=0;F<$Xb.Sn(a.f,B[v]);F++){if(a.e[$Xb.Tn(a.f,B[v],F)]){u=$Xb.Rn(a.f,B[v],F);if((v==0||u!=B[v-1])&&w[u]!=0){B[++D]=u;if((w[u]&1)!=0){for(L=1;L<D;L+=2)R[B[L]]=-1;D=0;}break;}}}++v;}}}o=Sjb(UXb.Cwb,KZb,6,a.f.f,16,1);for(W=0;W<a.f.f;W++){if(!o[W]&&w[W]!=0){B[0]=W;o[W]=true;v=0;D=0;while(v<=D){for(F=0;F<$Xb.Sn(a.f,B[v]);F++){if(a.e[$Xb.Tn(a.f,B[v],F)]){u=$Xb.Rn(a.f,B[v],F);if(!o[u]){B[++D]=u;o[u]=true;}}}++v;}if((D&1)==0){for(G=0;G<=D;G++)R[B[G]]==0&&(R[B[G]]=$Xb.de(a,B[G],false));K=true;for(H=0;H<=D;H++){if(R[B[H]]<=0){if(!$Xb.ee(a,B[H],false)){K=false;break;}}}if(K){P=0;O=-1;for(F=0;F<=D;F++){if(P<R[B[F]]){P=R[B[F]];O=B[F];}}if(P>0){$Xb.de(a,O,true);$Xb.pe(a,O);}}}}}};$Xb.be=function be(a,b,c){if($Xb.Qk(a.f,b)==7){if($Xb.Dn(a.f,b)==3)return 6;else if($Xb.Sn(a.f,b)==2)return 4;}else if($Xb.Qk(a.f,b)==8){return 10;}else if($Xb.Qk(a.f,b)==15||$Xb.Qk(a.f,b)==33){if($Xb.Sn(a.f,b)==3)return 8;}else if($Xb.Qk(a.f,b)==16||$Xb.Qk(a.f,b)==34||$Xb.Qk(a.f,b)==52){if($Xb.Sn(a.f,b)==2)return 12;}else if($Xb.Qk(a.f,b)==6){c&&$Xb.cm(a.f,b,-1);return $Xb.Dn(a.f,b)!=$Xb.En(a.f,b)?2:3;}return 0;};$Xb.ce=function ce(a,b,c){if(a.a){if($Xb.Dn(a.f,b)!=3)return 0;}else {if($Xb.Dn(a.f,b)>3)return 0;}if($Xb.Qk(a.f,b)==6){c&&$Xb.cm(a.f,b,1);return 2;}if($Xb.Qk(a.f,b)==5){return 4;}return 0;};$Xb.de=function de(a,b,c){if($Xb.zk(a.f,b)!=0)return 0;if(a.a){if($Xb.Qk(a.f,b)==5){if($Xb.ko(a.f,b)!=2)return 0;c&&$Xb.cm(a.f,b,1);return 1;}if($Xb.Qk(a.f,b)==7){if($Xb.ko(a.f,b)!=2)return 0;c&&$Xb.cm(a.f,b,-1);return $Xb.ge(a,b)?6:3;}if($Xb.Qk(a.f,b)==8){if($Xb.ko(a.f,b)!=1)return 0;c&&$Xb.cm(a.f,b,-1);return $Xb.ge(a,b)?7:4;}if($Xb.Qk(a.f,b)==16){if($Xb.ko(a.f,b)!=1)return 0;c&&$Xb.cm(a.f,b,-1);return $Xb.ge(a,b)?5:2;}if($Xb.Qk(a.f,b)==34){if($Xb.ko(a.f,b)!=1)return 0;c&&$Xb.cm(a.f,b,-1);return $Xb.ge(a,b)?4:1;}}else {if($Xb.Qk(a.f,b)==5){if($Xb.ko(a.f,b)>2)return 0;c&&$Xb.cm(a.f,b,1);return 1;}if($Xb.Qk(a.f,b)==7){if($Xb.ko(a.f,b)>2)return 0;c&&$Xb.cm(a.f,b,-1);return $Xb.ge(a,b)?5:3;}if($Xb.Qk(a.f,b)==8){if($Xb.ko(a.f,b)>1)return 0;c&&$Xb.cm(a.f,b,-1);return $Xb.ge(a,b)?7:4;}if($Xb.Qk(a.f,b)==16){if($Xb.ko(a.f,b)>1)return 0;c&&$Xb.cm(a.f,b,-1);return $Xb.ge(a,b)?5:2;}}return 0;};$Xb.ee=function ee(a,b,c){var d,e,f;d=$Xb.Qk(a.f,b);if(d>=5&&d<=8||d==15||d==16||d==33||d==34||d==52){f=$Xb.go(a.f,b);if(f!=0)return true;e=$Xb.zk(a.f,b);if(d==5&&e>=0){c&&$Xb.cm(a.f,b,e-1);return true;}if(d!=5&&e<=0){c&&$Xb.cm(a.f,b,e+1);return true;}}return false;};$Xb.fe=function fe(a,b,c,d){var e;for(e=0;e<$Xb.Sn(a.f,b);e++)if(d[$Xb.Tn(a.f,b,e)]==1&&$Xb.Rn(a.f,b,e)!=c)return e;return -1;};$Xb.ge=function ge(a,b){var c;for(c=0;c<$Xb.Sn(a.f,b);c++)if($Xb.Fl(a.f,$Xb.Rn(a.f,b,c)))return true;return false;};$Xb.he=function he(a,b,c){var d;for(d=0;d<$Xb.Sn(a.f,b);d++)if(c[$Xb.Tn(a.f,b,d)]>1)return true;return false;};$Xb.ie=function ie(a,b){var c;for(c=0;c<$Xb.Sn(a.f,b);c++)if(a.e[$Xb.Tn(a.f,b,c)])return true;return false;};$Xb.je=function je(a,b,c){var d,e,f,g,h,i,j,k,l,m;$Xb.nu(a.f,1);if(b!=null){a.e=b;}else {a.e=Sjb(UXb.Cwb,KZb,6,a.f.g,16,1);for(e=0;e<a.f.g;e++){if($Xb.el(a.f,e)==64){a.e[e]=true;$Xb.Fm(a.f,e,1);}}}a.g=0;a.d=Sjb(UXb.Cwb,KZb,6,a.f.f,16,1);for(f=0;f<a.f.g;f++){if(a.e[f]){++a.c;for(h=0;h<2;h++){if(!a.d[$Xb.Vk(a.f,h,f)]){a.d[$Xb.Vk(a.f,h,f)]=true;++a.b;}}}}if(a.c==0)return true;a.a=false;$Xb.re(a,c);a.f.K&&$Xb.le(a);m=new $Xb.gs(a.f,1);c&&$Xb.ae(a,m);$Xb.se(a,m);$Xb.oe(a,m);$Xb.qe(a);$Xb.me(a);while($Xb.ne(a,m))$Xb.me(a);while(a.c!=0){g=false;if(!g){for(k=0;k<m.i.a.length;k++){if(_Xb.Xi(m.j,k).length==6){j=true;l=_Xb.Xi(m.j,k);for(i=0;i<6;i++){if(!a.e[l[i]]){j=false;break;}}if(j){for(h=0;h<6;h+=2)$Xb.ke(a,l[h]);g=true;break;}}}}if(!g){for(d=0;d<a.f.g;d++){if(a.e[d]){$Xb.ke(a,d);$Xb.me(a);g=true;break;}}}}return a.b==a.g;};$Xb.ke=function ke(a,b){var c,d,e,f;if($Xb.el(a.f,b)==1){$Xb.Fm(a.f,b,2);a.g+=2;}for(e=0;e<2;e++){c=$Xb.Vk(a.f,e,b);a.d[c]=false;for(f=0;f<$Xb.Sn(a.f,c);f++){d=$Xb.Tn(a.f,c,f);if(a.e[d]){a.e[d]=false;--a.c;}}}};$Xb.le=function le(a){var b,c,d,e,f,g,h,i;for(c=0;c<a.f.g;c++){if(a.e[c]){for(e=0;e<2;e++){h=$Xb.Vk(a.f,e,c);b=false;for(g=0;g<$Xb.Sn(a.f,h);g++){if(c!=$Xb.Tn(a.f,h,g)&&a.e[$Xb.Tn(a.f,h,g)]){b=true;break;}}if(!b){i=c;d=$Xb.Vk(a.f,1-e,c);while(i!=-1){a.e[i]=false;--a.c;$Xb.Fm(a.f,i,64);i=-1;h=d;for(f=0;f<$Xb.Sn(a.f,h);f++){if(a.e[$Xb.Tn(a.f,h,f)]){if(i==-1){i=$Xb.Tn(a.f,h,f);d=$Xb.Rn(a.f,h,f);}else {h=-1;i=-1;break;}}}}break;}}}}};$Xb.me=function me(a){var b,c,d,e,f,g,h;do{h=false;for(c=0;c<a.f.g;c++){if(a.e[c]){f=false;for(e=0;e<2;e++){d=$Xb.Vk(a.f,e,c);b=false;for(g=0;g<$Xb.Sn(a.f,d);g++){if(c!=$Xb.Tn(a.f,d,g)&&a.e[$Xb.Tn(a.f,d,g)]){b=true;break;}}if(!b){f=true;break;}}if(f){h=true;$Xb.ke(a,c);}}}}while(h);};$Xb.ne=function ne(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o;o=Sjb(UXb.llb,yZb,6,a.f.g,15,1);for(m=0;m<b.i.a.length;m++){n=_Xb.Xi(b.j,m);l=true;for(k=0;k<n.length;k++){if(!a.e[n[k]]){l=false;break;}}if(l)for(j=0;j<n.length;j++)++o[n[j]];}i=a.c;for(f=0;f<a.f.g;f++){if(o[f]==1){for(j=0;j<2&&a.e[f];j++){c=$Xb.Vk(a.f,j,f);d=$Xb.Vk(a.f,1-j,f);if($Xb.he(a,c,o)&&!$Xb.he(a,d,o)){while(-1!=(h=$Xb.fe(a,d,c,o))){e=$Xb.Rn(a.f,d,h);g=$Xb.Tn(a.f,d,h);if(!a.e[g])break;$Xb.ke(a,g);h=$Xb.fe(a,e,d,o);if(h==-1)break;c=e;d=$Xb.Rn(a.f,e,h);}}}}}return i!=a.c;};$Xb.oe=function oe(a,b){var c;for(c=0;c<a.f.g;c++){if(a.e[c]&&$Xb._r(b,c)){$Xb.pe(a,$Xb.Vk(a.f,0,c));$Xb.pe(a,$Xb.Vk(a.f,1,c));}}};$Xb.pe=function pe(a,b){var c,d;if(a.d[b]){a.d[b]=false;--a.b;}for(d=0;d<$Xb.Sn(a.f,b);d++){c=$Xb.Tn(a.f,b,d);if(a.e[c]){a.e[c]=false;--a.c;}}};$Xb.qe=function qe(a){var b,c,d,e,f;for(c=0;c<a.f.g;c++){if($Xb.bl(a.f,c)==2){for(e=0;e<2;e++){b=$Xb.Vk(a.f,e,c);if($Xb.Qk(a.f,b)<=8){for(f=0;f<$Xb.Sn(a.f,b);f++){d=$Xb.Tn(a.f,b,f);if(a.e[d]){$Xb.pe(a,b);break;}}}}}}};$Xb.re=function re(a,b){var c;for(c=0;c<a.f.f;c++)a.d[c]&&$Xb.go(a.f,c)==0&&(!b||$Xb.Qk(a.f,c)==5&&$Xb.zk(a.f,c)<0||$Xb.Qk(a.f,c)==6||$Xb.Qk(a.f,c)==14||$Xb.Cl(a.f,c)&&$Xb.zk(a.f,c)>0)&&$Xb.pe(a,c);};$Xb.se=function se(a,b){var c,d,e,f,g,h,i,j,k,l,m,n;for(k=0;k<b.i.a.length;k++){n=_Xb.Xi(b.j,k).length;if(n==3||n==5||n==7){l=_Xb.Xi(b.i,k);for(d=0;d<n;d++){c=l[d];$Xb.ie(a,c)&&(n==5?($Xb.Qk(a.f,c)==6&&$Xb.zk(a.f,c)==-1&&$Xb.Dn(a.f,c)==3||$Xb.Qk(a.f,c)==7&&$Xb.zk(a.f,c)==0&&$Xb.Dn(a.f,c)==3||$Xb.Qk(a.f,c)==8&&$Xb.zk(a.f,c)==0&&$Xb.Sn(a.f,c)==2||$Xb.Qk(a.f,c)==16&&$Xb.zk(a.f,c)==0&&$Xb.Sn(a.f,c)==2||$Xb.Qk(a.f,c)==34&&$Xb.zk(a.f,c)==0&&$Xb.Sn(a.f,c)==2)&&$Xb.pe(a,c):($Xb.Qk(a.f,c)==5&&$Xb.zk(a.f,c)==0&&$Xb.Dn(a.f,c)==3||$Xb.Qk(a.f,c)==6&&$Xb.zk(a.f,c)==1)&&$Xb.pe(a,c));}}}for(j=0;j<b.i.a.length;j++){if(_Xb.Xi(b.j,j).length==5){m=_Xb.Xi(b.j,j);f=true;for(e=0;e<m.length;e++){if(!a.e[m[e]]){f=false;break;}}if(f){l=_Xb.Xi(b.i,j);h=0;g=-1;for(d=0;d<m.length;d++){if($Xb.zk(a.f,l[d])==-1&&$Xb.Qk(a.f,l[d])==6){i=$Xb.Dn(a.f,l[d])==3?3:$Xb.En(a.f,l[d])==3?2:1;if(h<i){h=i;g=l[d];}}}g!=-1&&$Xb.pe(a,g);}}}};$Xb.te=function te(a){this.f=a;};xxb(114,1,{},$Xb.te);_.a=false;_.b=0;_.c=0;_.g=0;UXb.slb=VFb(114);$Xb.ue=function ue(a,b){var c,d;c=0;for(d=0;d<a.j[b];d++)a.n[b][d]==2&&($Xb.Qk(a,a.i[b][d])==7||$Xb.Qk(a,a.i[b][d])==8||$Xb.Qk(a,a.i[b][d])==16)&&++c;return c;};$Xb.ve=function ve(a,b){var c,d,e,f,g,h;if(a.s[b]==0){return false;}h=true;c=a.s[b];f=a.j[b];g=0;for(d=0;d<f;d++){e=a.i[b][d];g+=a.s[e];}$wnd.Math.abs(c)<=$wnd.Math.abs(g)&&VXb.lHb(c)!=VXb.lHb(g)&&(h=false);return h;};$Xb.we=function we(a,b){var c,d,e,f,g,h,i;if(a.C[b]!=8||a.s[b]!=0||a.j[b]!=1||a.n[b][0]!=1)return false;c=a.i[b][0];if(a.C[c]==6){g=a.j[c];for(d=0;d<g;d++){e=a.i[c][d];if(e==b){continue;}if(a.C[e]!=8){continue;}f=$Xb.Pn(a,c,e);if(a.H[f]==2)return true;}}else if(a.C[c]==7){if(a.s[c]==1)return true;}else if(a.C[c]==16){h=a.j[c];i=0;for(d=0;d<h;d++){e=a.i[c][d];if(e==b)continue;if(a.C[e]!=8)continue;f=$Xb.Pn(a,c,e);a.H[f]==2&&++i;}if(i==2)return true;}else if($Xb.xe(a,b))return true;return false;};$Xb.xe=function xe(a,b){var c,d,e,f,g;if(a.C[b]!=8)return false;if(a.j[b]!=1)return false;c=a.i[b][0];if(a.C[c]==15){g=a.j[c];for(d=0;d<g;d++){e=a.i[c][d];if(e==b)continue;if(a.C[e]!=8)continue;f=$Xb.Pn(a,c,e);if(a.H[f]==2)return true;}}return false;};$Xb.ye=function ye(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A;if(a.C[b]!=7||a.s[b]!=0||a.j[b]+a.o[b]>3)return false;if(b<a.f&&$Xb.Ur(a.p,b)){if(a.o[b]!=1)return false;if($Xb.Ln(a,b,7)!=1)return false;u=($Xb.nu(a,7),a.p);for(s=0;s<u.i.a.length;s++){if($Xb.Wr(u,s,b)){if(_Xb.Xi(u.j,s).length==5||_Xb.Xi(u.j,s).length==6){v=_Xb.Xi(u.i,s);q=-1;for(i=0;i<v.length;i++){if(v[i]==b){q=i;break;}}e=0;r=null;p=null;if(v.length==5){r=Sjb(UXb.llb,yZb,6,2,15,1);r[0]=v[q-1<0?q+4:q-1];r[1]=v[q-4<0?q+1:q-4];p=Sjb(UXb.llb,yZb,6,2,15,1);p[0]=v[q-2<0?q+3:q-2];p[1]=v[q-3<0?q+2:q-3];}if(v.length==6){r=Sjb(UXb.llb,yZb,6,3,15,1);r[0]=v[q-1<0?q+5:q-1];r[1]=v[q-3<0?q+3:q-3];r[2]=v[q-5<0?q+1:q-5];p=Sjb(UXb.llb,yZb,6,2,15,1);p[0]=v[q-2<0?q+4:q-2];p[1]=v[q-4<0?q+2:q-4];}for(j=0;j<v.length;j++)b!=v[j]&&$Xb.Qk(a,v[j])==7&&$Xb.In(a,v[j])==1&&--e;for(k=0;k<r.length;k++){f=-1;g=-1;for(o=0;o<$Xb.Sn(a,r[k]);o++){if(!$Xb.Io(a,$Xb.Tn(a,r[k],o))){f=$Xb.Rn(a,r[k],o);g=$Xb.Tn(a,r[k],o);break;}}if(f!=-1){if(a.C[f]==7&&a.o[f]==0&&a.j[f]+a.o[f]<=3&&!$Xb.ze(a,f,false)){++e;continue;}if(a.C[f]==8&&a.j[f]==1){e+=2;continue;}if(g<a.g&&$Xb.Vr(a.p,g)){for(w=0;w<u.i.a.length;w++){if(u.d[w]&&$Xb.Wr(u,w,f)){t=_Xb.Xi(u.i,w);for(n=0;n<t.length;n++){if($Xb.Qk(a,t[n])==7&&$Xb.In(a,t[n])==1){--e;break;}}break;}}}}}for(l=0;l<p.length;l++){f=-1;for(n=0;n<$Xb.Sn(a,p[l]);n++)$Xb.Io(a,$Xb.Tn(a,p[l],n))||(f=$Xb.Rn(a,p[l],n));$Xb.Qk(a,p[l])==6?f!=-1&&$Xb.ue(a,f)!=0&&--e:$Xb.Qk(a,p[l])==7&&$Xb.In(a,p[l])==0&&(f==-1||!(f<a.f&&$Xb.Ur(a.p,f))&&$Xb.ue(a,f)==0)&&++e;}return e>0;}break;}}return false;}if(a.o[b]>1)return false;if(a.o[b]==1){m=-1;A=0;for(i=0;i<a.j[b];i++){d=a.i[b][i];if(a.n[b][i]==2){if(a.C[d]!=6)return false;m=d;continue;}if(a.C[d]==8)return false;if(a.C[d]==7){--A;$Xb.ze(a,d,false)&&--A;continue;}d<a.f&&$Xb.Ur(a.p,d)&&--A;}if(m==-1)return false;c=0;for(j=0;j<a.j[m];j++){if(a.n[m][j]==1){d=a.i[m][j];if($Xb.ue(a,d)!=0)return false;d<a.f&&$Xb.Ur(a.p,d)&&++c;a.C[d]==7&&!$Xb.ze(a,d,true)&&++A;(a.C[d]==8||a.C[d]==16)&&--A;}}c==2&&--A;return A>=0;}for(h=0;h<a.j[b];h++){d=a.i[b][h];if(d<a.f&&$Xb.Ur(a.p,d))return false;if(a.C[d]!=6)return false;if($Xb.ue(a,d)!=0)return false;if(a.o[d]!=0&&$Xb.Ae(a,d))return false;}return true;};$Xb.ze=function ze(a,b,c){var d,e,f;d=false;for(f=0;f<a.j[b];f++){if(!$Xb.Io(a,a.k[b][f])&&a.n[b][f]==1){e=a.i[b][f];if(!(e<a.f&&$Xb.Ur(a.p,e))&&(a.C[e]==6&&$Xb.ue(a,e)==1||a.C[e]==16&&$Xb.ue(a,e)==2)){if(d||!c)return true;d=true;}}}return false;};$Xb.Ae=function Ae(a,b){var c,d,e;for(d=0;d<a.j[b];d++){if(a.n[b][d]!=1){c=a.i[b][d];for(e=0;e<a.j[c];e++)if(a.n[c][e]==1&&$Xb.ue(a,a.i[c][e])!=0)return true;}}return false;};$Xb.De=function De(){$Xb.De=zxb;$Xb.Be=$jb(Mjb(UXb.Bwb,1),M$b,6,15,[-1,-1,-1,0,0,1,2,3,4,5,-1,0,0,0,6,7,8,9,-1,0,0,10,10,10,10,10,10,10,10,10,10,1,11,11,12,13,-1,0,0,10,10,10,10,10,10,10,10,10,10,0,0,0,11,14,-1,0,0,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,10,10,10,10,10,10,10,10,1,1,1,1,-1,-1,-1,-1,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1]);$Xb.Ce=$jb(Mjb(UXb.Bwb,1),M$b,6,15,[-1,-1,-1,0,0,0,2,5,5,5,-1,0,0,0,0,9,9,9,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1]);};$Xb.Ee=function Ee(a,b,c){$Xb.De();var d,e,f,g,h,i,j,k,l,m,n,o,p,q;$Xb.nu(a,7);n=Sjb(UXb.mlb,N$b,6,a.j[b],14,1);m=0;for(i=0;i<a.j[b];i++){e=a.i[b][i];if(a.C[e]==1)continue;g=0;if((c&32)!=0){f=Vwb(a.n[b][i]);c==32190?Owb(f,3)<0&&$Xb.Mo(a,a.k[b][i])&&a.o[b]==1&&(f=0):Owb(f,3)<0&&$Xb.Io(a,a.k[b][i])&&(f=0);g=exb(g,fxb(f,4));}if((c&128)!=0){if($Xb.Be[a.C[e]]==-1)throw Hwb(new VXb.aA(O$b+a.C[e]));g=Iwb(g,Vwb($Xb.Be[a.C[e]]));}else if((c&64)!=0){if($Xb.Ce[a.C[e]]==-1)throw Hwb(new VXb.aA(O$b+a.C[e]));g=Iwb(g,Vwb($Xb.Ce[a.C[e]]));}if((c&256)!=0){o=a.j[e]-1;o>3&&(o=3);(c&512)==0&&o>1&&(o=1);g=exb(g,UXb.Rwb(o<<6));}(c&XZb)!=0&&(a.u[e]&8)!=0&&(g=exb(g,256));(c&x$b)!=0&&e<a.f&&$Xb.Ur(a.p,e)&&(g=exb(g,512));(c&RZb)!=0&&(a.u[e]&w$b)!=0&&(g=exb(g,XZb));k=0;while(Owb(g,n[k])<0)++k;for(l=i;l>k;l--)n[l]=n[l-1];n[k]=g;++m;}m>4&&(m=4);d=0;for(j=0;j<m;j++){d=fxb(d,11);d=exb(d,n[j]);}d=fxb(d,15);if($Xb.Be[a.C[b]]==-1)throw Hwb(new VXb.aA(O$b+a.C[b]));d=exb(d,Vwb($Xb.Be[a.C[b]]));if((c&2)!=0){q=!!a.p&&b<a.f?$Xb.Jr(a.p,b):0;q>9&&(q=9);q>2&&(q-=2);d=exb(d,UXb.Rwb(q<<4));}else (c&1)!=0&&(a.u[b]&8)!=0&&(d=exb(d,64));(c&4)!=0&&b<a.f&&$Xb.Ur(a.p,b)&&(d=exb(d,XZb));(c&8)!=0&&(a.u[b]&SZb)!=0&&(d=exb(d,x$b));(c&16)!=0&&(a.u[b]&w$b)!=0&&(d=exb(d,SZb));if((c&SZb)!=0){$Xb.ve(a,b)&&(d=exb(d,w$b));if($Xb.ye(a,b)){for(h=0;h<a.f;h++){if($Xb.we(a,h)){d=exb(d,RZb);break;}}}}if((c&w$b)!=0){p=Vwb($Xb.Ln(a,b,10));d=exb(d,fxb(p,7));}return d;};$Xb.Fe=function Fe(a,b,c,d,e,f){var g,h,i,j;i=0;for(h=0;h<a.P.f;h++)cxb(Jwb($Xb.Lk(a.P,a.w[h]),d),0)&&++i;if(i==0)return;$Xb.Df(a,b);$Xb.yf(a,UXb.Rwb(i),c);for(g=0;g<a.P.f;g++){j=Jwb($Xb.Lk(a.P,a.w[g]),d);if(Owb(j,0)!=0){$Xb.yf(a,UXb.Rwb(g),c);e!=1&&$Xb.yf(a,gxb(j,f),e);}}};$Xb.Ge=function Ge(a,b,c,d,e,f){var g,h,i,j;i=0;for(h=0;h<a.P.g;h++)($Xb.dl(a.P,a.A[h])&d)!=0&&++i;if(i==0)return;$Xb.Df(a,b);$Xb.yf(a,UXb.Rwb(i),c);for(g=0;g<a.P.g;g++){j=$Xb.dl(a.P,a.A[g])&d;if(j!=0){$Xb.yf(a,UXb.Rwb(g),c);e!=1&&$Xb.yf(a,UXb.Rwb(j>>f),e);}}};$Xb.He=function He(a){var b,c,d,e,f,g;while(true){f=Sjb(UXb.Cwb,KZb,6,a.S+1,16,1);d=-1;for(c=0;c<a.P.f;c++){if($Xb.go(a.P,c)!=0){f[a.d[c]]&&d<a.d[c]&&(d=a.d[c]);f[a.d[c]]=true;}}if(d==-1)break;e=0;for(b=0;b<a.P.f;b++){g=0;a.d[b]==d&&(g=++e);$Xb.zg(a.c[b],b);$Xb.wg(a.c[b],a.b,Vwb(a.d[b]));$Xb.wg(a.c[b],8,UXb.Rwb(g));}a.S=$Xb.gf(a);}};$Xb.Ie=function Ie(a){var b,c,d,e;for(c=0;c<a.P.f;c++){$Xb.zg(a.c[c],c);$Xb.wg(a.c[c],2*a.b+4,fxb(Vwb(a.d[c]),a.b+4));}e=false;for(b=0;b<a.P.f;b++)e=e|$Xb.Ve(a,b,3);for(d=0;d<a.P.g;d++)e=e|$Xb.Qe(a,d,3);if(!e)return false;while(a.S<a.P.f){e=$Xb.df(a);if(!e)break;$Xb.ff(a);!!a.N&&$Xb.Pg(a.N,a.d);}return true;};$Xb.Je=function Je(a){var b,c,d,e,f;for(c=0;c<a.P.f;c++){$Xb.zg(a.c[c],c);$Xb.wg(a.c[c],a.b+1,Vwb(2*a.d[c]));}f=Sjb(UXb.llb,yZb,6,a.S+1,15,1);for(d=0;d<a.P.f;d++)++f[a.d[d]];e=1;while(f[e]==1)++e;for(b=0;b<a.P.f;b++){if(a.d[b]==e){$Xb.xg(a.c[b],1);break;}}a.S=$Xb.gf(a);};$Xb.Ke=function Ke(a,b,c){var d,e,f,g,h;if($Xb.Qk(a.P,b)!=6&&$Xb.Qk(a.P,b)!=7)return false;e=$Xb.Rn(a.P,b,0);f=$Xb.Rn(a.P,b,1);if($Xb.In(a.P,e)!=1||$Xb.In(a.P,f)!=1)return false;if($Xb.Sn(a.P,e)==1||$Xb.Sn(a.P,f)==1)return false;if($Xb.Dn(a.P,e)>3||$Xb.Dn(a.P,f)>3)return false;g=new $Xb.Kj(a.P,a.d,b,e);if(g.f&&c==1)return false;h=new $Xb.Kj(a.P,a.d,b,f);if(h.f&&c==1)return false;if(g.f&&h.f)return false;if(c==3){g.f&&g.c&&(a.U[b]=true);h.f&&h.c&&(a.U[b]=true);}d=a.hb?$Xb.Me(a,g,h):$Xb.Le(g,h);if(c==1){a.bb[b]=d;}else if(c==2){g.f&&(d==1?$Xb.xg(a.c[g.b],Vwb(a.d[e])):$Xb.xg(a.c[g.d],Vwb(a.d[e])));h.f&&(d==2?$Xb.xg(a.c[h.b],Vwb(a.d[f])):$Xb.xg(a.c[h.d],Vwb(a.d[f])));}return true;};$Xb.Le=function Le(a,b){var c,d,e;d=$Xb.Jj(a);e=$Xb.Jj(b);if(d==-1||e==-1||(d+e&1)==0)return 3;c=0;switch(d+e){case 3:case 7:c=2;break;case 5:c=1;}return c;};$Xb.Me=function Me(a,b,c){var d,e;d=Sjb(UXb.llb,yZb,6,4,15,1);d[0]=b.b;d[1]=b.a;d[2]=c.a;d[3]=c.b;e=$Xb.dk(a.P,d);if($wnd.Math.abs(e)<0.3||$wnd.Math.abs(e)>P$b)return 3;return e<0?2:1;};$Xb.Ne=function Ne(a,b,c){var d,e,f,g,h;if(!$Xb.Jo(a.P,b))return false;d=$Xb.Vk(a.P,0,b);e=$Xb.Vk(a.P,1,b);g=new $Xb.Kj(a.P,a.d,d,e);if(g.f&&c==1)return false;h=new $Xb.Kj(a.P,a.d,e,d);if(h.f&&c==1)return false;if(g.f&&h.f)return false;if(c==3){g.f&&(a.T[b]=$Xb.Tf(a,e));h.f&&(a.T[b]=$Xb.Tf(a,d));}f=a.hb?$Xb.Pe(a,g,h):$Xb.Oe(g,h);if(c==1){a.k[b]=f;}else if(c==2){g.f&&(f==2?$Xb.xg(a.c[g.b],Vwb(a.d[e])):$Xb.xg(a.c[g.d],Vwb(a.d[e])));h.f&&(f==2?$Xb.xg(a.c[h.b],Vwb(a.d[d])):$Xb.xg(a.c[h.d],Vwb(a.d[d])));}return true;};$Xb.Oe=function Oe(a,b){var c,d,e;d=$Xb.Jj(a);e=$Xb.Jj(b);if(d==-1||e==-1||(d+e&1)==0)return 3;c=0;switch(d+e){case 3:case 7:c=1;break;case 5:c=2;}return c;};$Xb.Pe=function Pe(a,b,c){var d,e;d=Sjb(UXb.llb,yZb,6,4,15,1);d[0]=b.b;d[1]=b.a;d[2]=c.a;d[3]=c.b;e=$Xb.dk(a.P,d);if($wnd.Math.abs(e)<0.3||$wnd.Math.abs(e)>P$b)return 3;return e<0?1:2;};$Xb.Qe=function Qe(a,b,c){var d,e,f,g,h;if(a.k[b]!=0)return false;if($Xb.bl(a.P,b)==1)return $Xb.Ne(a,b,c);if($Xb.bl(a.P,b)!=2)return false;if($Xb.Io(a.P,b))return false;e=$Xb.Vk(a.P,0,b);f=$Xb.Vk(a.P,1,b);if($Xb.Sn(a.P,e)==1||$Xb.Sn(a.P,f)==1)return false;if($Xb.Sn(a.P,e)>3||$Xb.Sn(a.P,f)>3)return false;if($Xb.In(a.P,e)==2||$Xb.In(a.P,f)==2)return false;g=new $Xb.Kj(a.P,a.d,f,e);if(g.f&&c==1)return false;h=new $Xb.Kj(a.P,a.d,e,f);if(h.f&&c==1)return false;if(g.f&&h.f)return false;if(c==3){g.f&&g.c&&(a.T[b]=true);h.f&&h.c&&(a.T[b]=true);}d=$Xb.Bl(a.P,b)?3:a.hb?$Xb.Se(a,g,h):$Xb.Re(g,h);if(c==1){a.k[b]=d;}else if(c==2){g.f&&(d==1?$Xb.xg(a.c[g.b],Vwb(a.d[e])):d==2&&$Xb.xg(a.c[g.d],Vwb(a.d[e])));h.f&&(d==1?$Xb.xg(a.c[h.b],Vwb(a.d[f])):d==2&&$Xb.xg(a.c[h.d],Vwb(a.d[f])));}return true;};$Xb.Re=function Re(a,b){if($Xb.Jj(a)==-1||$Xb.Jj(b)==-1)return 3;if((($Xb.Jj(a)|$Xb.Jj(b))&1)!=0)return 3;return $Xb.Jj(a)==$Xb.Jj(b)?1:2;};$Xb.Se=function Se(a,b,c){var d,e,f,g,h,i,j;f=Sjb(UXb.jlb,wZb,6,3,15,1);f[0]=$Xb.Nk(a.P,c.a)-$Xb.Nk(a.P,b.a);f[1]=$Xb.Ok(a.P,c.a)-$Xb.Ok(a.P,b.a);f[2]=$Xb.Pk(a.P,c.a)-$Xb.Pk(a.P,b.a);i=Sjb(UXb.jlb,wZb,6,3,15,1);i[0]=$Xb.Nk(a.P,b.b)-$Xb.Nk(a.P,b.a);i[1]=$Xb.Ok(a.P,b.b)-$Xb.Ok(a.P,b.a);i[2]=$Xb.Pk(a.P,b.b)-$Xb.Pk(a.P,b.a);j=Sjb(UXb.jlb,wZb,6,3,15,1);j[0]=$Xb.Nk(a.P,c.b)-$Xb.Nk(a.P,c.a);j[1]=$Xb.Ok(a.P,c.b)-$Xb.Ok(a.P,c.a);j[2]=$Xb.Pk(a.P,c.b)-$Xb.Pk(a.P,c.a);g=Sjb(UXb.jlb,wZb,6,3,15,1);g[0]=f[1]*i[2]-f[2]*i[1];g[1]=f[2]*i[0]-f[0]*i[2];g[2]=f[0]*i[1]-f[1]*i[0];h=Sjb(UXb.jlb,wZb,6,3,15,1);h[0]=f[1]*g[2]-f[2]*g[1];h[1]=f[2]*g[0]-f[0]*g[2];h[2]=f[0]*g[1]-f[1]*g[0];d=(i[0]*h[0]+i[1]*h[1]+i[2]*h[2])/($wnd.Math.sqrt(i[0]*i[0]+i[1]*i[1]+i[2]*i[2])*$wnd.Math.sqrt(h[0]*h[0]+h[1]*h[1]+h[2]*h[2]));e=(j[0]*h[0]+j[1]*h[1]+j[2]*h[2])/($wnd.Math.sqrt(j[0]*j[0]+j[1]*j[1]+j[2]*j[2])*$wnd.Math.sqrt(h[0]*h[0]+h[1]*h[1]+h[2]*h[2]));return d<0^e<0?1:2;};$Xb.Te=function Te(a,b){var c,d,e,f;c=$Xb.xk(a.P,b);d=$Xb.eo(a.P,b,false);e=$Xb.eo(a.P,b,true);f=-1;if(d!=e){c!=-1&&c>d?f=c<<24>>24:f=d<<24>>24;}else if(c!=-1){(c>e||c<e&&c>=$Xb.ko(a.P,b))&&(f=c<<24>>24);}else if(!$Xb.lp(a.P,b)&&$Xb.Wn(a.P,b)!=0){f=$Xb.ko(a.P,b);f-=$Xb.il(a.P,b,f);}$Xb.of(a,b,f);return f;};$Xb.Ue=function Ue(a){var b,c,d,e,f,g,h,i,j,k,l;d=Sjb(UXb.llb,yZb,6,a.M,15,1);for(b=0;b<a.P.f;b++){k=$Xb.Sn(a.P,b)+$Xb.ho(a.P,b);j=0;for(f=0;f<$Xb.En(a.P,b);f++){if(f<$Xb.Sn(a.P,b)||f>=$Xb.Dn(a.P,b)){l=2*a.d[$Xb.Rn(a.P,b,f)];c=$Xb.Tn(a.P,b,f);$Xb.bl(a.P,c)==2&&($Xb.Io(a.P,c)||++l);for(h=0;h<j;h++)if(l<d[h])break;for(i=j;i>h;i--)d[i]=d[i-1];d[h]=l;++j;}}$Xb.zg(a.c[b],b);$Xb.wg(a.c[b],a.b,Vwb(a.d[b]));for(g=k;g<a.M;g++)$Xb.wg(a.c[b],a.b+1,0);for(e=0;e<k;e++)$Xb.wg(a.c[b],a.b+1,UXb.Rwb(d[e]));}};$Xb.Ve=function Ve(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o;if(a.bb[b]!=0)return false;if($Xb.Qk(a.P,b)!=5&&$Xb.Qk(a.P,b)!=6&&$Xb.Qk(a.P,b)!=7&&$Xb.Qk(a.P,b)!=14&&$Xb.Qk(a.P,b)!=15&&$Xb.Qk(a.P,b)!=16)return false;if($Xb.In(a.P,b)!=0){if($Xb.Ko(a.P,b))return $Xb.Ke(a,b,c);if($Xb.Qk(a.P,b)!=15&&$Xb.Qk(a.P,b)!=16)return false;}if($Xb.Sn(a.P,b)<3||$Xb.Dn(a.P,b)>4)return false;if($Xb.zk(a.P,b)>0&&$Xb.Qk(a.P,b)==6)return false;if($Xb.Qk(a.P,b)==5&&$Xb.Dn(a.P,b)!=4)return false;if($Xb.Qk(a.P,b)==7&&!a.Q[b])return false;n=Sjb(UXb.llb,yZb,6,4,15,1);o=Sjb(UXb.llb,yZb,6,4,15,1);j=Sjb(UXb.Cwb,KZb,6,4,16,1);for(h=0;h<$Xb.Dn(a.P,b);h++){f=-1;e=0;for(i=0;i<$Xb.Dn(a.P,b);i++){if(!j[i]){if(f<a.d[$Xb.Rn(a.P,b,i)]){f=a.d[$Xb.Rn(a.P,b,i)];e=i;}}}n[h]=e;o[h]=f;j[e]=true;}if($Xb.Dn(a.P,b)==4&&o[0]==o[1]&&o[2]==o[3])return false;if($Xb.Dn(a.P,b)==4&&(o[0]==o[2]||o[1]==o[3]))return false;if($Xb.Dn(a.P,b)==3&&o[0]==o[2])return false;k=0;l=0;m=false;for(g=1;g<$Xb.Dn(a.P,b);g++){if(o[g-1]==o[g]){if(c==1||o[g]==0)return false;k=$Xb.Rn(a.P,b,n[g-1]);l=$Xb.Rn(a.P,b,n[g]);c==3&&$Xb.Vo(a.P,$Xb.Tn(a.P,b,n[g]))&&(a.U[b]=true);m=true;}}if(c!=1&&!m)return false;d=a.hb?$Xb.Xe(a,b,n):$Xb.We(a,b,n);c==1?a.bb[b]=d:c==2&&(d==1?$Xb.xg(a.c[k],Vwb(a.d[b])):d==2&&$Xb.xg(a.c[l],Vwb(a.d[b])));return true;};$Xb.We=function We(a,b,c){var d,e,f,g,h,i,j,k,l,m;m=$jb(Mjb(UXb.llb,2),Q$b,8,0,[$jb(Mjb(UXb.llb,1),yZb,6,15,[2,1,2,1]),$jb(Mjb(UXb.llb,1),yZb,6,15,[1,2,2,1]),$jb(Mjb(UXb.llb,1),yZb,6,15,[1,1,2,2]),$jb(Mjb(UXb.llb,1),yZb,6,15,[2,1,1,2]),$jb(Mjb(UXb.llb,1),yZb,6,15,[2,2,1,1]),$jb(Mjb(UXb.llb,1),yZb,6,15,[1,2,1,2])]);d=Sjb(UXb.jlb,wZb,6,$Xb.Dn(a.P,b),15,1);for(g=0;g<$Xb.Dn(a.P,b);g++)d[g]=$Xb.Uk(a.P,$Xb.Rn(a.P,b,c[g]),b);j=$Xb.Yn(a.P,b,c,d,null)<<24>>24;if(j!=3)return j;k=0;l=0;for(h=0;h<$Xb.Dn(a.P,b);h++){e=$Xb.Tn(a.P,b,c[h]);if($Xb.Vk(a.P,0,e)==b){if($Xb.el(a.P,e)==129){l!=0&&$Xb.Om(a.P,b);k=h;l=1;}if($Xb.el(a.P,e)==257){l!=0&&$Xb.Om(a.P,b);k=h;l=2;}}}if(l==0)return 3;for(f=1;f<$Xb.Dn(a.P,b);f++)d[f]<d[0]&&(d[f]+=OZb);if($Xb.Dn(a.P,b)==3){switch(k){case 0:(d[1]<d[2]&&d[2]-d[1]<PZb||d[1]>d[2]&&d[1]-d[2]>PZb)&&(l=3-l);break;case 1:d[2]-d[0]>PZb&&(l=3-l);break;case 2:d[1]-d[0]<PZb&&(l=3-l);}return l==1?2:1;}i=0;d[1]<=d[2]&&d[2]<=d[3]?i=0:d[1]<=d[3]&&d[3]<=d[2]?i=1:d[2]<=d[1]&&d[1]<=d[3]?i=2:d[2]<=d[3]&&d[3]<=d[1]?i=3:d[3]<=d[1]&&d[1]<=d[2]?i=4:d[3]<=d[2]&&d[2]<=d[1]&&(i=5);return m[i][k]==l?2:1;};$Xb.Xe=function Xe(a,b,c){var d,e,f,g,h,i;d=Sjb(UXb.llb,yZb,6,4,15,1);for(h=0;h<$Xb.Dn(a.P,b);h++)d[h]=$Xb.Rn(a.P,b,c[h]);$Xb.Dn(a.P,b)==3&&(d[3]=b);e=Qjb(UXb.jlb,[aZb,wZb],[13,6],15,[3,3],2);for(g=0;g<3;g++){e[g][0]=$Xb.Nk(a.P,d[g+1])-$Xb.Nk(a.P,d[0]);e[g][1]=$Xb.Ok(a.P,d[g+1])-$Xb.Ok(a.P,d[0]);e[g][2]=$Xb.Pk(a.P,d[g+1])-$Xb.Pk(a.P,d[0]);}i=Sjb(UXb.jlb,wZb,6,3,15,1);i[0]=e[0][1]*e[1][2]-e[0][2]*e[1][1];i[1]=e[0][2]*e[1][0]-e[0][0]*e[1][2];i[2]=e[0][0]*e[1][1]-e[0][1]*e[1][0];f=(e[2][0]*i[0]+e[2][1]*i[1]+e[2][2]*i[2])/($wnd.Math.sqrt(e[2][0]*e[2][0]+e[2][1]*e[2][1]+e[2][2]*e[2][2])*$wnd.Math.sqrt(i[0]*i[0]+i[1]*i[1]+i[2]*i[2]));return f>0?1:2;};$Xb.Ye=function Ye(a){var b,c;b=0;_Xb.POb(a.c);for(c=0;c<a.c.length;c++){(c==0||$Xb.yg(a.c[c],a.c[c-1])!=0)&&++b;a.d[a.c[c].a]=b;}return b;};$Xb.Ze=function Ze(a){var b,c,d,e,f,g,h,i,j,k,l,m;if(a.v)return;a.v=new _Xb.kj();k=0;l=Sjb(UXb.llb,yZb,6,a.P.f,15,1);g=Sjb(UXb.llb,yZb,6,a.P.f,15,1);i=Sjb(UXb.llb,yZb,6,a.P.g,15,1);for(b=0;b<a.P.f;b++){if(l[b]==0&&($Xb.Uo(a.P,b)||$Xb.In(a.P,b)==1)){g[0]=b;h=1;j=0;l[b]=++k;c=Sjb(UXb.Cwb,KZb,6,a.P.g,16,1);for(f=0;f<h;f++){for(m=0;m<$Xb.Sn(a.P,g[f]);m++){e=$Xb.Tn(a.P,g[f],m);if($Xb.Vo(a.P,e)||$Xb.bl(a.P,e)==2||$Xb.Jo(a.P,e)){d=$Xb.Rn(a.P,g[f],m);if(!c[e]){i[j++]=e;c[e]=true;}if(l[d]==0){g[h++]=d;l[d]=k;}}}}_Xb.Si(a.v,new $Xb.Fg(g,h,i,j));}}};$Xb.$e=function $e(a){var b;a.Q=Sjb(UXb.Cwb,KZb,6,a.P.f,16,1);for(b=0;b<a.P.f;b++){if($Xb.Qk(a.P,b)==7){if($Xb.Sn(a.P,b)==4){a.Q[b]=true;continue;}if($Xb.Sn(a.P,b)==3){if($Xb.Mn(a.P,b)==3){a.Q[b]=true;continue;}if($Xb.zk(a.P,b)==1){a.Q[b]=true;continue;}if($Xb.Oo(a.P,b,true))continue;if((a.O&32)!=0){a.Q[b]=true;continue;}if($Xb.To(a.P,b)){a.Q[b]=true;continue;}}}}};$Xb._e=function _e(a,b){var c,d,e,f;e=false;for(d=0;d<a.P.g;d++)if($Xb.Qe(a,d,1)){a.o[d]=a.J;b&&$Xb.pf(a,d);e=true;}f=false;for(c=0;c<a.P.f;c++)if($Xb.Ve(a,c,1)){a.gb[c]=a.J;b&&$Xb.qf(a,c);f=true;}f&&(a.J=!a.J);return e||f;};$Xb.af=function af(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B;s=Sjb(UXb.Cwb,KZb,6,a.P.f,16,1);t=Sjb(UXb.Cwb,KZb,6,a.P.g,16,1);b=0;v=false;if((a.O&128)!=0){a.W=Sjb(UXb.llb,yZb,6,a.P.f,15,1);a.V=Sjb(UXb.llb,yZb,6,a.P.g,15,1);}for(d=0;d<a.P.f;d++){if(a.U[d]){if(!a.db[d]){if($Xb.Ve(a,d,1)){a.db[d]=true;s[d]=true;++b;}}}}for(f=0;f<a.P.g;f++){if(a.T[f]){if(!a.n[f]){if($Xb.Qe(a,f,1)){a.n[f]=true;t[f]=true;++b;}}}}if(b==1){for(c=0;c<a.P.f;c++){if(s[c]){a.bb[c]=0;break;}}for(e=0;e<a.P.g;e++){if(t[e]){a.k[e]=0;break;}}}else if(b>1){$Xb.Ze(a);a.R=0;for(h=new _Xb.rOb(a.v);h.a<h.c.a.length;){g=_Xb.qOb(h);u=0;w=0;k=0;j=0;l=-1;i=-1;for(o=0;o<g.a.length;o++){if(s[g.a[o]]){++u;if(a.bb[g.a[o]]==1||a.bb[g.a[o]]==2){++w;v=true;if(l<a.d[g.a[o]]){l=a.d[g.a[o]];k=g.a[o];}}}}for(p=0;p<g.b.length;p++){if(t[g.b[p]]){++u;A=a.d[$Xb.Vk(a.P,0,g.b[p])];B=a.d[$Xb.Vk(a.P,1,g.b[p])];m=A>B?(A<<16)+B:(B<<16)+A;if(a.k[g.b[p]]==1||a.k[g.b[p]]==2){++w;v=true;if(i<m){i=m;j=g.b[p];}}}}if(u==0)continue;if(u==1){for(q=0;q<g.a.length;q++)s[g.a[q]]&&(a.bb[g.a[q]]=0);for(n=0;n<g.b.length;n++)t[g.b[n]]&&(a.k[g.b[n]]=0);}else {if(w==1){for(q=0;q<g.a.length;q++)s[g.a[q]]&&(a.bb[g.a[q]]=3);for(n=0;n<g.b.length;n++)t[g.b[n]]&&(a.k[g.b[n]]=3);}else {if((a.O&128)!=0){++a.R;for(q=0;q<g.a.length;q++)s[g.a[q]]&&(a.W[g.a[q]]=a.R);for(n=0;n<g.b.length;n++)t[g.b[n]]&&(a.V[g.b[n]]=a.R);}r=false;l!=-1?a.bb[k]==2&&(r=true):a.k[j]==2&&(r=true);if(r){for(q=0;q<g.a.length;q++){if(s[g.a[q]]){switch(a.bb[g.a[q]]){case 1:a.bb[g.a[q]]=2;break;case 2:a.bb[g.a[q]]=1;}}}for(n=0;n<g.b.length;n++){if(t[g.b[n]]){switch(a.k[g.b[n]]){case 1:a.k[g.b[n]]=2;break;case 2:a.k[g.b[n]]=1;}}}}}}}}return v;};$Xb.bf=function bf(a,b){var c,d,e,f,g,h,i,j,k,l,m;f=Qjb(UXb.llb,[Q$b,yZb],[8,6],15,[2,32],2);for(g=0;g<2;g++){c=Sjb(UXb.llb,Q$b,8,32,0,2);m=0;for(e=0;e<32;e++){if(b[g][e]!=null){k=b[g][e].length;c[e]=Sjb(UXb.llb,yZb,6,k,15,1);for(h=0;h<k;h++)c[e][h]=a.d[b[g][e][h]];YXb.fTb(c[e],YXb.LTb(Axb(_Xb.ZOb.prototype.Zd,_Xb.ZOb,[])));++m;}}for(l=m;l>0;l--){j=0;i=null;for(d=0;d<32;d++){if(c[d]!=null){if(i==null||i.length<c[d].length){i=c[d];j=d;}else if(i.length==c[d].length){for(h=i.length-1;h>=0;h--){if(i[h]<c[d][h]){i=c[d];j=d;break;}}}}}f[g][j]=l;c[j]=null;}}return f;};$Xb.cf=function cf(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t;l=false;if(a.P.K){for(j=0;j<a.P.g;j++){if($Xb.dl(a.P,j)!=0){l=true;break;}}}a.M=2;for(c=0;c<a.P.f;c++)a.M=$wnd.Math.max(a.M,$Xb.Sn(a.P,c)+$Xb.ho(a.P,c));i=$wnd.Math.max(2,l?(62+a.b+a.M*(a.b+23))/63|0:(62+a.b+a.M*(a.b+5))/63|0);a.d=Sjb(UXb.llb,yZb,6,a.P.q,15,1);a.c=Sjb(UXb.xlb,R$b,160,a.P.f,0,1);for(d=0;d<a.P.f;d++)a.c[d]=new $Xb.Ag(i);h=false;for(e=0;e<a.P.f;e++){$Xb.zg(a.c[e],e);cxb(Jwb($Xb.Lk(a.P,e),1),0)||$Xb.Gk(a.P,e)!=null?$Xb.wg(a.c[e],8,6):$Xb.wg(a.c[e],8,Vwb($Xb.Qk(a.P,e)));$Xb.wg(a.c[e],8,Vwb($Xb.Jk(a.P,e)));$Xb.wg(a.c[e],2,Vwb($Xb.In(a.P,e)));$Xb.wg(a.c[e],4,Vwb($Xb.Sn(a.P,e)+$Xb.ho(a.P,e)));cxb(Jwb($Xb.Lk(a.P,e),1),0)?$Xb.wg(a.c[e],4,8):$Xb.wg(a.c[e],4,Vwb(8+$Xb.zk(a.P,e)));$Xb.wg(a.c[e],5,Vwb($wnd.Math.min(31,$Xb.Mn(a.P,e))));$Xb.wg(a.c[e],4,Vwb($Xb.Te(a,e)+1));$Xb.wg(a.c[e],2,Vwb($Xb.Mk(a.P,e)>>4));if(a.P.K){$Xb.wg(a.c[e],46,$Xb.Lk(a.P,e));$Xb.Gk(a.P,e)!=null&&(h=true);}}a.S=$Xb.gf(a);if(a.S<a.P.f){for(b=0;b<a.P.f;b++){$Xb.zg(a.c[b],b);$Xb.wg(a.c[b],a.b,Vwb(a.d[b]));m=Sjb(UXb.llb,yZb,6,$Xb.Sn(a.P,b),15,1);for(o=0;o<$Xb.Sn(a.P,b);o++){m[o]=a.d[$Xb.Rn(a.P,b,o)]<<5;m[o]|=$wnd.Math.min(31,$Xb.Qn(a.P,$Xb.Tn(a.P,b,o)));}YXb.fTb(m,YXb.LTb(Axb(_Xb.ZOb.prototype.Zd,_Xb.ZOb,[])));for(p=a.M;p>m.length;p--)$Xb.wg(a.c[b],a.b+5,0);for(n=m.length-1;n>=0;n--)$Xb.wg(a.c[b],a.b+5,UXb.Rwb(m[n]));}a.S=$Xb.gf(a);}if(h&&a.S<a.P.f){for(b=0;b<a.P.f;b++){$Xb.zg(a.c[b],b);$Xb.wg(a.c[b],a.b,Vwb(a.d[b]));g=$Xb.Gk(a.P,b);s=g==null?0:$wnd.Math.min(12,g.length);for(o=12;o>s;o--)$Xb.wg(a.c[b],8,0);for(n=s-1;n>=0;n--)$Xb.wg(a.c[b],8,UXb.Rwb(g[n]));}a.S=$Xb.gf(a);}if(l&&a.S<a.P.f){for(b=0;b<a.P.f;b++){$Xb.zg(a.c[b],b);$Xb.wg(a.c[b],a.b,Vwb(a.d[b]));k=Sjb(UXb.mlb,N$b,6,$Xb.Sn(a.P,b)+$Xb.ho(a.P,b),14,1);q=0;for(o=0;o<$Xb.En(a.P,b);o++){if(o<$Xb.Sn(a.P,b)||o>=$Xb.Dn(a.P,b)){k[q]=Vwb(a.d[$Xb.Rn(a.P,b,o)]);k[q]=fxb(k[q],23);k[q]=exb(k[q],Vwb($Xb.dl(a.P,$Xb.Tn(a.P,b,o))));++q;}}YXb.fTb(k,YXb.LTb(Axb(_Xb.WOb.prototype.$d,_Xb.WOb,[])));for(p=a.M;p>k.length;p--)$Xb.wg(a.c[b],a.b+23,0);for(n=k.length-1;n>=0;n--)$Xb.wg(a.c[b],a.b+23,k[n]);}a.S=$Xb.gf(a);}if((a.O&8)!=0&&a.S<a.P.f){r=new $Xb.ku();for(f=0;f<a.P.f;f++)$Xb.Bk(a.P,f)!=null&&$Xb.iu(r,$Xb.Bk(a.P,f));for(b=0;b<a.P.f;b++){t=$Xb.Bk(a.P,b)==null?0:1+$Xb.ju(r,$Xb.Bk(a.P,b));$Xb.zg(a.c[b],b);$Xb.wg(a.c[b],a.b,Vwb(a.d[b]));$Xb.wg(a.c[b],a.b,UXb.Rwb(t));}a.S=$Xb.gf(a);}if((a.O&16)!=0&&a.S<a.P.f){for(b=0;b<a.P.f;b++){$Xb.zg(a.c[b],b);$Xb.wg(a.c[b],a.b,Vwb(a.d[b]));$Xb.wg(a.c[b],1,Vwb($Xb.Jl(a.P,b)?1:0));}a.S=$Xb.gf(a);}(a.O&512)!=0&&a.P.K&&$Xb.He(a);};$Xb.df=function df(a){var b,c,d,e,f,g,h,i,j;for(c=0;c<a.P.f;c++){$Xb.zg(a.c[c],c);$Xb.wg(a.c[c],2*a.b+4,fxb(Vwb(a.d[c]),a.b+4));}for(i=1;i<=a.S;i++){e=false;for(d=0;d<a.P.f;d++)a.d[d]==i&&(e=e|$Xb.Ve(a,d,2));if(e){h=a.S;a.S=$Xb.gf(a);if(a.S!=h)return true;for(b=0;b<a.P.f;b++){$Xb.zg(a.c[b],b);$Xb.wg(a.c[b],2*a.b+4,fxb(Vwb(a.d[b]),a.b+4));}}}j=Sjb(UXb.ylb,R$b,211,a.P.g,0,1);for(g=0;g<j.length;g++)j[g]=new $Xb.Dg(a.d[$Xb.Vk(a.P,0,g)],a.d[$Xb.Vk(a.P,1,g)],g);_Xb.NOb(j,0,j.length,null);for(f=0;f<j.length;f++){if($Xb.Qe(a,j[f].a,2)){while(f+1<j.length&&$Xb.Cg(j[f],j[f+1])==0)$Xb.Qe(a,j[++f].a,2);h=a.S;a.S=$Xb.gf(a);if(a.S!=h)return true;for(b=0;b<a.P.f;b++){$Xb.zg(a.c[b],b);$Xb.wg(a.c[b],2*a.b+4,fxb(Vwb(a.d[b]),a.b+4));}}}return false;};$Xb.ef=function ef(a){var b,c,d,e,f,g,h,i,j,k;f=0;for(c=0;c<a.P.f;c++)a._[c]!=0&&(a._[c]!=2||(a.O&256)==0)&&++f;if(f==0)return;k=Sjb(UXb.llb,yZb,6,f,15,1);f=0;for(d=0;d<a.P.f;d++){if(a._[d]!=0&&(a._[d]!=2||(a.O&256)==0)){k[f]=a._[d]<<29|a.$[d]<<24|a.d[d]<<12|d;++f;}}YXb.fTb(k,YXb.LTb(Axb(_Xb.ZOb.prototype.Zd,_Xb.ZOb,[])));g=0;j=0;h=k[0]&H$b;while(true){++j;if(j==k.length||h!=(k[j]&H$b)){e=Sjb(UXb.llb,yZb,6,j-g,15,1);for(i=g;i<j;i++){b=k[i]&4095;e[i-g]=b;a.eb[b]=true;}_Xb.Si(a.fb,e);if(j==k.length)break;h=k[j]&H$b;g=j;}}};$Xb.ff=function ff(a){var b,c,d,e,f,g,h,i,j,k,l,m,n;h=false;for(i=0;i<a.fb.a.length;i++){g=_Xb.Xi(a.fb,i);b=true;n=-1;j=false;for(l=0;l<g.length;l++){c=g[l];if(a.bb[c]==0){b=false;break;}if(a.bb[c]!=3){k=true;for(m=0;m<g.length;m++){if(m!=l&&a.d[c]==a.d[g[m]]){k=false;break;}}if(k&&n<a.d[c]){n=a.d[c];j=a.bb[c]==1;}}}if(b&&n!=-1){for(d=g,e=0,f=d.length;e<f;++e){c=d[e];(a.bb[c]==1||a.bb[c]==2)&&(a.cb[c]=j);a.eb[c]=false;}_Xb.dj(a.fb,g);h=true;--i;}}return h;};$Xb.gf=function gf(a){var b,c;b=$Xb.Ye(a);do{c=b;$Xb.Ue(a);b=$Xb.Ye(a);}while(c!=b);return b;};$Xb.hf=function hf(a){(a.O&1)!=0&&(a.O&2)==0&&(a.e=_Xb.xOb(a.d,a.P.f));if((a.O&x$b)==0){a.U=Sjb(UXb.Cwb,KZb,6,a.P.f,16,1);a.T=Sjb(UXb.Cwb,KZb,6,a.P.g,16,1);if(a.S<a.P.f){$Xb.Ie(a);if((a.O&x$b)==0){$Xb.ff(a);!!a.N&&$Xb.Pg(a.N,a.d);}}}a.e==null&&(a.O&1)!=0&&(a.O&2)!=0&&(a.e=_Xb.xOb(a.d,a.P.f));while(a.S<a.P.f){$Xb.Je(a);if((a.O&x$b)==0){$Xb.ff(a);!!a.N&&$Xb.Pg(a.N,a.d);}}if((a.O&x$b)==0){$Xb.ff(a);$Xb.af(a);$Xb.Gf(a);}};$Xb.jf=function jf(a){var b,c,d,e,f;f=a.S;e=_Xb.xOb(a.d,a.P.f);if(!a.P.K){$Xb.lf(a);$Xb.Yf(a,f,e);}a._=Sjb(UXb.hlb,S$b,6,a.P.f,15,1);a.$=Sjb(UXb.hlb,S$b,6,a.P.f,15,1);for(c=0;c<a.P.f;c++){a._[c]=$Xb.Ek(a.P,c)<<24>>24;a.$[c]=$Xb.Dk(a.P,c)<<24>>24;}a.j=Sjb(UXb.hlb,S$b,6,a.P.g,15,1);a.i=Sjb(UXb.hlb,S$b,6,a.P.g,15,1);for(d=0;d<a.P.g;d++){a.j[d]=$Xb.$k(a.P,d)<<24>>24;a.i[d]=$Xb.Zk(a.P,d)<<24>>24;}$Xb.kf(a);a.X=false;a.K=Sjb(UXb.Cwb,KZb,6,a.P.f,16,1);for(b=0;b<a.P.f;b++){if(a.bb[b]!=0){a.K[b]=true;a.X=true;}}$Xb.nf(a);a.N=null;a.ab=Sjb(UXb.Cwb,KZb,6,a.P.f,16,1);if(a.X){a.N=new $Xb.Vg(a.P,e,a.K,a.bb,a.k,a._,a.$,a.gb,a.o,a.ab);$Xb.Qg(a.N);}a.cb=Sjb(UXb.Cwb,KZb,6,a.P.f,16,1);a.eb=Sjb(UXb.Cwb,KZb,6,a.P.f,16,1);a.fb=new _Xb.kj();!!a.N&&$Xb.Pg(a.N,a.d);$Xb.ef(a);$Xb.Yf(a,f,e);$Xb.mf(a);!!a.N&&(a.I=$Xb.Mg(a.N));$Xb.xf(a);};$Xb.kf=function kf(a){var b,c,d,e,f,g;a.J=true;f=$Xb._e(a,false);while(a.S<a.P.f&&f){for(b=0;b<a.P.f;b++){$Xb.zg(a.c[b],b);$Xb.wg(a.c[b],a.b,Vwb(a.d[b]));g=a.bb[b]<<7;if((a.bb[b]==1||a.bb[b]==2)&&a._[b]!=0){g|=a._[b]<<5;g|=a.$[b];}$Xb.wg(a.c[b],18,UXb.Rwb(g<<9));}for(c=0;c<a.P.g;c++){d=a.k[c]<<7;if((a.k[c]==1||a.k[c]==2)&&$Xb.el(a.P,c)==1&&a.j[c]!=0){d|=a.j[c]<<5;d|=a.i[c];}$Xb.xg(a.c[$Xb.Vk(a.P,0,c)],UXb.Rwb(d));$Xb.xg(a.c[$Xb.Vk(a.P,1,c)],UXb.Rwb(d));}e=$Xb.gf(a);if(a.S==e)break;a.S=e;f=$Xb._e(a,false);}};$Xb.lf=function lf(a){var b,c,d,e;a.J=true;a.Y=Sjb(UXb.hlb,S$b,6,a.P.f,15,1);a.f=Sjb(UXb.hlb,S$b,6,a.P.g,15,1);e=$Xb._e(a,true);while(a.S<a.P.f&&e){for(b=0;b<a.P.f;b++){$Xb.zg(a.c[b],b);$Xb.wg(a.c[b],a.b+4,Vwb(a.d[b]<<4|a.bb[b]<<2));}for(c=0;c<a.P.g;c++){$Xb.xg(a.c[$Xb.Vk(a.P,0,c)],Vwb(a.k[c]));$Xb.xg(a.c[$Xb.Vk(a.P,1,c)],Vwb(a.k[c]));}d=$Xb.gf(a);if(a.S==d)break;a.S=d;e=$Xb._e(a,true);}};$Xb.mf=function mf(a){var b,c,d,e,f,g,h;a.J=true;d=$Xb.wf(a);!!a.N&&$Xb.Pg(a.N,a.d)&&(d=$Xb.wf(a));$Xb._e(a,false)&&$Xb.ff(a);g=true;while(a.S<a.P.f&&g){e=$Xb.bf(a,d);for(b=0;b<a.P.f;b++){$Xb.zg(a.c[b],b);$Xb.wg(a.c[b],a.b,Vwb(a.d[b]));$Xb.wg(a.c[b],20,0);!a.ab[b]&&a._[b]!=0&&$Xb.xg(a.c[b],Vwb((a._[b]<<18)+(e[a._[b]==1?0:1][a.$[b]]<<8)));h=a.bb[b];a.cb[b]&&(h==1?h=2:h==2&&(h=1));$Xb.xg(a.c[b],UXb.Rwb(h<<4));}for(c=0;c<a.P.g;c++){$Xb.xg(a.c[$Xb.Vk(a.P,0,c)],Vwb(a.k[c]));$Xb.xg(a.c[$Xb.Vk(a.P,1,c)],Vwb(a.k[c]));}f=$Xb.gf(a);if(a.S==f)break;a.S=f;g=false;if(!!a.N&&$Xb.Pg(a.N,a.d)){g=true;d=$Xb.wf(a);}if($Xb._e(a,false)){g=true;$Xb.ff(a);}}};$Xb.nf=function nf(a){var b,c;for(b=0;b<a.P.f;b++)(!a.K[b]||a.bb[b]==3)&&(a._[b]=0);for(c=0;c<a.P.g;c++)($Xb.el(a.P,c)!=1||a.k[c]==0||a.k[c]==3)&&(a.j[c]=0);};$Xb.of=function of(a,b,c){if(a.a==null){a.a=Sjb(UXb.hlb,S$b,6,a.P.f,15,1);_Xb.AOb(a.a);}a.a[b]=c<<24>>24;};$Xb.pf=function pf(b,c){var d,e,f,g,h,i;if((b.k[c]==1||b.k[c]==2)&&!$Xb.Yo(b.P,c)){h=false;try{for(g=0;g<2;g++){d=$Xb.Vk(b.P,g,c);if($Xb.Sn(b.P,d)==3){e=Sjb(UXb.llb,yZb,6,2,15,1);f=0;for(i=0;i<$Xb.Sn(b.P,d);i++)$Xb.Tn(b.P,d,i)!=c&&(e[f++]=$Xb.Rn(b.P,d,i));b.d[e[0]]>b.d[e[1]]^$Xb.rf(b,d,e[0],e[1])&&(h=!h);}}}catch(a){a=Gwb(a);if(Zkb(a,19)){b.f[c]=3;return;}else throw Hwb(a);}b.k[c]==1^h?b.f[c]=1:b.f[c]=2;}};$Xb.qf=function qf(b,c){var d,e,f,g,h,i,j;if(b.bb[c]==1||b.bb[c]==2){i=false;if($Xb.In(b.P,c)==2){try{for(h=0;h<2;h++){d=$Xb.Rn(b.P,c,h);if($Xb.Sn(b.P,d)==3){f=Sjb(UXb.llb,yZb,6,2,15,1);g=0;for(j=0;j<$Xb.Sn(b.P,d);j++)$Xb.Un(b.P,d,j)==1&&(f[g++]=$Xb.Rn(b.P,d,j));b.d[f[0]]>b.d[f[1]]^$Xb.rf(b,d,f[0],f[1])&&(i=!i);}}}catch(a){a=Gwb(a);if(Zkb(a,19)){b.Y[c]=3;return;}else throw Hwb(a);}}else {try{e=$Xb.tf(b,c);}catch(a){a=Gwb(a);if(Zkb(a,19)){b.Y[c]=3;return;}else throw Hwb(a);}for(h=1;h<e.length;h++)for(j=0;j<h;j++)b.d[e[h]]<b.d[e[j]]&&(i=!i);}b.bb[c]==1^i?b.Y[c]=1:b.Y[c]=2;}};$Xb.rf=function rf(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L;if($Xb.Qk(a.P,c)!=$Xb.Qk(a.P,d))return $Xb.Qk(a.P,c)>$Xb.Qk(a.P,d);if($Xb.Jk(a.P,c)!=$Xb.Jk(a.P,d)){H=$Xb.Gl(a.P,c)?($Xb.Sj(),$Xb.Qj)[$Xb.Qk(a.P,c)]:$Xb.Jk(a.P,c);I=$Xb.Gl(a.P,d)?($Xb.Sj(),$Xb.Qj)[$Xb.Qk(a.P,d)]:$Xb.Jk(a.P,d);return H>I;}w=a.P.f;s=Sjb(UXb.llb,yZb,6,w,15,1);u=Sjb(UXb.llb,yZb,6,w,15,1);v=Sjb(UXb.llb,yZb,6,w,15,1);t=Sjb(UXb.Cwb,KZb,6,w,16,1);i=Sjb(UXb.Cwb,KZb,6,a.P.q,16,1);s[0]=b;s[1]=c;s[2]=d;u[0]=-1;u[1]=0;u[2]=0;i[b]=true;i[c]=true;i[d]=true;m=1;A=2;G=Sjb(UXb.llb,yZb,6,64,15,1);G[1]=1;G[2]=3;o=2;while(m<=A){while(m<G[o]){n=s[m];if(!t[m]){p=0;q=0;for(C=0;C<$Xb.Sn(a.P,n);C++){k=$Xb.Rn(a.P,n,C);if(A+$Xb.Un(a.P,n,C)+1>=w){w+=a.P.f;s=$Xb.ag(s,w);u=$Xb.ag(u,w);v=$Xb.ag(v,w);t=$Xb.bg(t,w);}if($Xb.Mo(a.P,$Xb.Tn(a.P,n,C))){++p;q+=$Xb.Qk(a.P,k);}else {for(F=1;F<$Xb.Un(a.P,n,C);F++){++A;s[A]=k;u[A]=m;t[A]=true;}}K=u[m];if(k==s[K])continue;h=false;if(i[k]){J=u[K];while(J!=-1){if(k==s[J]){h=true;break;}J=u[J];}}if(h){++A;s[A]=k;u[A]=m;t[A]=true;}else {++A;s[A]=k;u[A]=m;i[k]=true;}}if(p!=0){++A;v[A]=(q<<2)/p|0;u[A]=m;t[A]=true;}}++m;if(m==qZb){throw Hwb(new VXb.aA('Emergency break in while loop.'));}}G.length==o+1&&(G=$Xb.ag(G,G.length+64));G[o+1]=A+1;for(B=G[o];B<G[o+1];B++){v[B]==0&&(v[B]=($Xb.Qk(a.P,s[B])==151?1:$Xb.Qk(a.P,s[B])==152?1:$Xb.Qk(a.P,s[B]))<<2);v[B]+=v[u[B]]<<16;}$Xb.vf(a,t,v,u,s,G,o);if(v[1]!=v[2])return v[1]>v[2];o>1&&$Xb.sf(v,u,G,o);++o;}l=Sjb(UXb.llb,yZb,6,a.P.f,15,1);D=false;for(f=0;f<a.P.f;f++){if(i[f]&&!$Xb.Gl(a.P,f)){D=true;break;}}if(D){for(g=0;g<a.P.f;g++)l[g]=$Xb.Gl(a.P,g)?($Xb.Sj(),$Xb.Qj)[$Xb.Qk(a.P,g)]:$Xb.Jk(a.P,g);if($Xb.uf(a,t,v,u,s,l,G,o))return v[1]>v[2];}_Xb.GOb(l,l.length,0);r=false;for(j=0;j<a.P.g;j++){if(i[$Xb.Vk(a.P,0,j)]||i[$Xb.Vk(a.P,1,j)]){if(a.f[j]==1){l[$Xb.Vk(a.P,0,j)]=1;l[$Xb.Vk(a.P,1,j)]=1;r=true;}else if(a.f[j]==2){l[$Xb.Vk(a.P,0,j)]=2;l[$Xb.Vk(a.P,1,j)]=2;r=true;}}}if(r&&$Xb.uf(a,t,v,u,s,l,G,o))return v[1]>v[2];_Xb.GOb(l,l.length,0);L=false;for(e=0;e<a.P.f;e++){if(i[e]){if(a.Y[e]==2){l[e]=1;L=true;}else if(a.Y[e]==1){l[e]=2;L=true;}}}if(L&&$Xb.uf(a,t,v,u,s,l,G,o))return v[1]>v[2];throw Hwb(new VXb.aA('no distinction applying CIP rules'));};$Xb.sf=function sf(a,b,c,d){var e,f,g,h,i,j,k,l,m;l=c[d];g=c[d+1]-l;m=Sjb(UXb.vlb,kZb,213,g,0,1);for(i=0;i<g;i++){m[i]=new $Xb.vg();m[i].c=a[i+l];m[i].b=b[i+l];m[i].a=i+l;}e=new $Xb.sg();for(k=d;k>1;k--){for(j=0;j<g;j++){m[j].c+=a[m[j].b]<<16;m[j].b=b[m[j].b];}_Xb.NOb(m,0,m.length,e);f=1;for(h=0;h<g;h++){a[m[h].a]=f;h!=g-1&&$Xb.rg(m[h],m[h+1])!=0&&++f;}}};$Xb.tf=function tf(a,b){var c,d,e,f,g,h,i;g=$Xb.Dn(a.P,b);h=Sjb(UXb.llb,yZb,6,g,15,1);for(e=0;e<g;e++)h[e]=$Xb.Rn(a.P,b,e);for(d=g;d>1;d--){c=false;for(f=1;f<d;f++){if($Xb.rf(a,b,h[f-1],h[f])){c=true;i=h[f-1];h[f-1]=h[f];h[f]=i;}}if(!c)break;}return h;};$Xb.uf=function uf(a,b,c,d,e,f,g,h){var i,j;for(j=1;j<h;j++){for(i=g[j];i<g[j+1];i++)c[i]=f[e[i]]+(c[d[i]]<<8);$Xb.vf(a,b,c,d,e,g,j);if(c[1]!=c[2])return true;j>1&&$Xb.sf(c,d,g,j);}return false;};$Xb.vf=function vf(a,b,c,d,e,f,g){var h,i,j,k,l,m,n,o,p,q,r;for(l=g;l>1;l--){p=f[l]-f[l-1];r=Sjb(UXb.tlb,kZb,212,p,0,1);h=f[l];for(o=0;o<p;o++){q=f[l-1]+o;m=h;while(m<f[l+1]&&d[m]==q)++m;r[o]=new $Xb.pg();r[o].c=q;r[o].d=c[q];r[o].b=b[q]?0:$Xb.qo(a.P,e[q]);r[o].a=Sjb(UXb.llb,yZb,6,m-h,15,1);for(k=h;k<m;k++)r[o].a[k-h]=c[k];YXb.fTb(r[o].a,YXb.LTb(Axb(_Xb.ZOb.prototype.Zd,_Xb.ZOb,[])));h=m;}i=new $Xb.mg();_Xb.NOb(r,0,r.length,i);j=1;for(n=0;n<p;n++){c[r[n].c]=j;n!=p-1&&$Xb.lg(r[n],r[n+1])!=0&&++j;}}};$Xb.wf=function wf(a){var b,c;c=Qjb(UXb.llb,[aZb,Q$b],[41,8],0,[2,32],2);for(b=0;b<a.P.f;b++){a.K[b]&&(a._[b]==1?c[0][a.$[b]]=$Xb.Wg(c[0][a.$[b]],b):a._[b]==2&&(c[1][a.$[b]]=$Xb.Wg(c[0][a.$[b]],b)));}return c;};$Xb.xf=function xf(a){var b,c,d,e,f,g,h,i,j,k,l,m;f=0;k=0;g=0;h=0;i=0;j=0;l=0;m=false;b=Sjb(UXb.Cwb,KZb,6,32,16,1);for(c=0;c<a.P.f;c++){if(a.bb[c]!=0){++f;if(a.bb[c]==3){++k;}else {if(a._[c]==0){++g;!!a.N&&$Xb.Lg(a.N,c)&&++h;}else if(a._[c]==2){a.$[c]==0&&++j;}else if(a._[c]==1){e=a.$[c];if(!b[e]){++l;b[e]=true;}a.$[c]==0&&++i;!!a.N&&$Xb.Lg(a.N,c)&&(m=true);}}}}for(d=0;d<a.P.g;d++){if(a.k[d]!=0&&$Xb.el(a.P,d)==1){++f;if(a.k[d]==3){++k;}else {if(a.j[d]==0){++g;!!a.N&&$Xb.Lg(a.N,$Xb.Vk(a.P,0,d))&&$Xb.Lg(a.N,$Xb.Vk(a.P,1,d))&&++h;}else if(a.j[d]==2){a.i[d]==0&&++j;}else if(a.j[d]==1){e=a.i[d];if(!b[e]){++l;b[e]=true;}a.i[d]==0&&++i;!!a.N&&$Xb.Lg(a.N,$Xb.Vk(a.P,0,d))&&$Xb.Lg(a.N,$Xb.Vk(a.P,1,d))&&(m=true);}}}}if(f==0){$Xb.Gm(a.P,oZb);return;}if(k!=0){$Xb.Gm(a.P,0);return;}if(a.I){$Xb.Gm(a.P,T$b+(1<<l));return;}i+h==f&&!m?$Xb.Gm(a.P,U$b):g==f?$Xb.Gm(a.P,G$b):j==f?$Xb.Gm(a.P,327680):g==f-1&&i==1?$Xb.Gm(a.P,h$b):$Xb.Gm(a.P,458752+(1<<l));};$Xb.yf=function yf(a,b,c){while(c!=0){if(a.r==0){(!a.p||a.t!=63)&&(a.t+=64);VXb.cIb(a.s,a.t&pZb);a.r=6;a.t=0;}a.t<<=1;a.t=lxb(exb(Vwb(a.t),Jwb(b,1)));b=gxb(b,1);--c;--a.r;}};$Xb.zf=function zf(a){a.t<<=a.r;(!a.p||a.t!=63)&&(a.t+=64);VXb.cIb(a.s,a.t&pZb);return a.s.a;};$Xb.Af=function Af(a,b){a.s=new VXb.jIb();a.r=6;a.t=0;a.p=b;};$Xb.Bf=function Bf(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q;if(a.P.f==0){a.q='';return;}l=false;if(a.hb&&a.P.q>a.P.f&&!a.P.K){l=true;for(i=0;i<a.P.f;i++){if($Xb.fo(a.P,i)!=0){l=false;break;}}}q=a.hb?16:8;$Xb.Af(a,true);VXb.cIb(a.s,l?35:33);$Xb.yf(a,Vwb(a.hb?1:0),1);$Xb.yf(a,UXb.Rwb(b?1:0),1);$Xb.yf(a,UXb.Rwb(q/2|0),4);o=0;for(j=1;j<a.P.f;j++)o=$Xb.Of(a,a.w[j],a.C[j]==-1?-1:a.w[a.C[j]],o,c);if(l){for(i=0;i<a.P.f;i++){d=a.w[i];for(n=$Xb.Sn(a.P,d);n<$Xb.Dn(a.P,d);n++)o=$Xb.Of(a,$Xb.Rn(a.P,d,n),d,o,c);}}if(a.P.f>1&&o==0){a.q='';return;}g=1<<q;m=o/(g/2-1);p=o+m/2;for(k=1;k<a.P.f;k++)$Xb.Cf(a,a.w[k],a.C[k]==-1?-1:a.w[a.C[k]],p,m,q,c);if(l){for(h=0;h<a.P.f;h++){d=a.w[h];for(n=$Xb.Sn(a.P,d);n<$Xb.Dn(a.P,d);n++)$Xb.Cf(a,$Xb.Rn(a.P,d,n),d,p,m,q,c);}}if(b){f=a.hb?1.5:($Xb.Sj(),$Xb.Sj(),$Xb.Rj);e=$Xb.Tk(a.P,l?a.P.q:a.P.f,l?a.P.r:a.P.g,f,c);$Xb.yf(a,Vwb($wnd.Math.min(g-1,$wnd.Math.max(0,glb(0.5+$wnd.Math.log(e/0.1)*$wnd.Math.LOG10E/($wnd.Math.log(2000)*$wnd.Math.LOG10E)*(g-1))))),q);$Xb.yf(a,Vwb($Xb.Ff(c[a.w[0]].a/e,g)),q);$Xb.yf(a,Vwb($Xb.Ff(c[a.w[0]].b/e,g)),q);a.hb&&$Xb.yf(a,Vwb($Xb.Ff(c[a.w[0]].c/e,g)),q);}a.q=$Xb.zf(a);};$Xb.Cf=function Cf(a,b,c,d,e,f,g){var h,i,j;h=c==-1?(g[b].a-g[a.w[0]].a)/8:g[b].a-g[c].a;i=c==-1?(g[b].b-g[a.w[0]].b)/8:g[b].b-g[c].b;$Xb.yf(a,Vwb(glb((d+h)/e)),f);$Xb.yf(a,Vwb(glb((d+i)/e)),f);if(a.hb){j=c==-1?(g[b].c-g[a.w[0]].c)/8:g[b].c-g[c].c;$Xb.yf(a,Vwb(glb((d+j)/e)),f);}};$Xb.Df=function Df(a,b){var c;for(c=0;c<a.u;c++)b-=16;b<0&&(VXb.oIb(),String.fromCharCode(10));while(b>15){$Xb.yf(a,1,1);$Xb.yf(a,15,4);b-=16;++a.u;}$Xb.yf(a,1,1);$Xb.yf(a,UXb.Rwb(b),4);};$Xb.Ef=function Ef(a){var b,c,d,e,f,g;if(a.P.f==0){a.L='';return;}f=0;d=false;e=false;for(c=0;c<a.P.f;c++){f<$Xb.Ik(a.P,c)&&(f=$Xb.Ik(a.P,c));$Xb.vl(a.P,c)?d=true:e=true;}if(f==0){a.L='';return;}g=$Xb.jg(f);$Xb.Af(a,true);$Xb.yf(a,UXb.Rwb(g),4);$Xb.yf(a,UXb.Rwb(d?1:0),1);$Xb.yf(a,UXb.Rwb(e?1:0),1);for(b=0;b<a.P.f;b++){$Xb.yf(a,Vwb($Xb.Ik(a.P,a.w[b])),g);d&&e&&$Xb.yf(a,Vwb($Xb.vl(a.P,a.w[b])?1:0),1);}a.L=$Xb.zf(a);};$Xb.Ff=function Ff(a,b){var c,d,e,f;c=b/2|0;e=a<0;a=$wnd.Math.abs(a);f=b/32|0;d=$wnd.Math.min(c-1,lxb(Uwb($wnd.Math.round(a*c/(a+f)))));return e?c+d:d;};$Xb.Gf=function Gf(a){var b,c,d;for(b=0;b<a.P.f;b++){a.bb[b]==3&&!$Xb.rl(a.P,b)&&$Xb.Om(a.P,b);($Xb.Ek(a.P,b)==1||$Xb.Ek(a.P,b)==2)&&a.bb[b]==3&&$Xb.Om(a.P,b);$Xb.rl(a.P,b)&&a.bb[b]!=3&&!$Xb.$f(a,b)&&$Xb.Om(a.P,b);}for(d=0;d<a.P.r;d++)$Xb.Ll(a.P,d)&&!$Xb.Zf(a,d)&&$Xb.Om(a.P,$Xb.Vk(a.P,0,d));for(c=0;c<a.P.g;c++){if($Xb.bl(a.P,c)==2){if($Xb.Bl(a.P,c)&&(a.k[c]==1||a.k[c]==2)){a.k[c]=3;$Xb.Fm(a.P,c,386);}if(a.k[c]==3&&!a.n[c]){if($Xb.el(a.P,c)!=386){$Xb.Om(a.P,$Xb.Vk(a.P,0,c));$Xb.Om(a.P,$Xb.Vk(a.P,1,c));}}}if($Xb.el(a.P,c)==1&&a.k[c]==3&&!$Xb.rl(a.P,$Xb.Vk(a.P,0,c))&&!$Xb.rl(a.P,$Xb.Vk(a.P,1,c))){$Xb.Om(a.P,$Xb.Vk(a.P,0,c));$Xb.Om(a.P,$Xb.Vk(a.P,1,c));}if(($Xb.$k(a.P,c)==1||$Xb.$k(a.P,c)==2)&&($Xb.el(a.P,c)!=1||a.k[c]!=1&&a.k[c]!=2)){$Xb.Om(a.P,$Xb.Vk(a.P,0,c));$Xb.Om(a.P,$Xb.Vk(a.P,1,c));}}};$Xb.Hf=function Hf(a){var b,c,d,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v;if(a.P.f==0)return;if(a.D)return;a.G=0;v=0;for(c=1;c<a.P.f;c++)a.d[c]>a.d[v]&&(v=c);d=Sjb(UXb.Cwb,KZb,6,a.P.f,16,1);g=Sjb(UXb.Cwb,KZb,6,a.P.g,16,1);a.F=Sjb(UXb.llb,yZb,6,a.P.f,15,1);a.w=Sjb(UXb.llb,yZb,6,a.P.f,15,1);a.C=Sjb(UXb.llb,yZb,6,a.P.f,15,1);a.A=Sjb(UXb.llb,yZb,6,a.P.g,15,1);a.w[0]=v;a.F[v]=0;d[v]=true;i=0;j=1;k=0;while(i<a.P.f){if(i<j){while(true){o=0;p=0;m=-1;b=a.w[i];for(q=0;q<$Xb.En(a.P,b);q++){if(q<$Xb.Sn(a.P,b)||q>=$Xb.Dn(a.P,b)){h=$Xb.Rn(a.P,b,q);if(!d[h]&&a.d[h]>m){o=h;p=$Xb.Tn(a.P,b,q);m=a.d[h];}}}if(m==-1)break;a.F[o]=j;a.C[j]=i;a.w[j++]=o;a.A[k++]=p;d[o]=true;g[p]=true;}++i;}else {n=0;m=-1;for(b=0;b<a.P.f;b++){if(!d[b]&&a.d[b]>m){n=b;m=a.d[b];}}a.F[n]=j;a.C[j]=-1;a.w[j++]=n;d[n]=true;}}a.B=Sjb(UXb.llb,yZb,6,2*(a.P.g-k),15,1);while(true){s=a.P.M;t=a.P.M;u=-1;for(f=0;f<a.P.g;f++){if(!g[f]){if(a.F[$Xb.Vk(a.P,0,f)]<a.F[$Xb.Vk(a.P,1,f)]){r=a.F[$Xb.Vk(a.P,0,f)];l=a.F[$Xb.Vk(a.P,1,f)];}else {r=a.F[$Xb.Vk(a.P,1,f)];l=a.F[$Xb.Vk(a.P,0,f)];}if(r<s||r==s&&l<t){s=r;t=l;u=f;}}}if(u==-1)break;g[u]=true;a.A[k++]=u;a.B[2*a.G]=s;a.B[2*a.G+1]=t;++a.G;}a.D=true;};$Xb.If=function If(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o;i=null;o=$Xb.so(a.P);for(l=0;l<o.i.a.length;l++){if(o.e[l]){f=0;m=_Xb.Xi(o.i,l);for(c=m,d=0,e=c.length;d<e;++d){b=c[d];$Xb.Uf(a,b)&&++f;}if(f!=0){n=_Xb.Xi(o.j,l);i==null&&(i=Sjb(UXb.Cwb,KZb,6,a.P.g,16,1));if(f==m.length){j=-1;k=gZb;for(g=0;g<m.length;g++){if(k>a.w[n[g]]){k=a.w[n[g]];j=g;}}while(f>0){i[n[j]]=true;j=$Xb.gg(j+2,m.length);f-=2;}}else {h=0;while($Xb.Uf(a,m[h]))++h;while(!$Xb.Uf(a,m[h]))h=$Xb.gg(h+1,m.length);while(f>0){i[n[h]]=true;h=$Xb.gg(h+2,m.length);f-=2;while(!$Xb.Uf(a,m[h]))h=$Xb.gg(h+1,m.length);}}}}}return i;};$Xb.Jf=function Jf(a,b){return a.k[b];};$Xb.Kf=function Kf(a){return $Xb.Lf(a,a.hb);};$Xb.Lf=function Lf(a,b){if(a.q==null){$Xb.Hf(a);$Xb.Bf(a,b,a.P.J);}return a.q;};$Xb.Mf=function Mf(a){if(a.L==null){$Xb.Hf(a);$Xb.Ef(a);}return a.L;};$Xb.Nf=function Nf(a){if(a.H==null){$Xb.Hf(a);if((a.O&x$b)==0){$Xb.Wf(a);$Xb.Xf(a,1);$Xb.Xf(a,2);}$Xb.Vf(a);}return a.H;};$Xb.Of=function Of(a,b,c,d,e){var f,g,h;f=c==-1?$wnd.Math.abs(e[b].a-e[a.w[0]].a)/8:$wnd.Math.abs(e[b].a-e[c].a);d<f&&(d=f);g=c==-1?$wnd.Math.abs(e[b].b-e[a.w[0]].b)/8:$wnd.Math.abs(e[b].b-e[c].b);d<g&&(d=g);if(a.hb){h=c==-1?$wnd.Math.abs(e[b].c-e[a.w[0]].c)/8:$wnd.Math.abs(e[b].c-e[c].c);d<h&&(d=h);}return d;};$Xb.Pf=function Pf(a,b){return a.V[b];};$Xb.Qf=function Qf(a,b){return a.W[b];};$Xb.Rf=function Rf(a,b){return a.e==null?-1:a.e[b];};$Xb.Sf=function Sf(a,b){return a.bb[b];};$Xb.Tf=function Tf(a,b){var c,d,e,f,g,h,i;i=$Xb.so(a.P);for(c=0;c<i.i.a.length;c++){if(i.d[c]&&$Xb.Wr(i,c,b)){for(e=_Xb.Xi(i.i,c),f=0,g=e.length;f<g;++f){d=e[f];if(d!=b)for(h=0;h<$Xb.Sn(a.P,d);h++)if($Xb.Jo(a.P,$Xb.Tn(a.P,d,h)))return true;}return false;}}return false;};$Xb.Uf=function Uf(a,b){var c,d,e;if($Xb.In(a.P,b)<2)return false;if($Xb.Sn(a.P,b)==2)return true;c=0;for(e=0;e<$Xb.Sn(a.P,b);e++){d=$Xb.Tn(a.P,b,e);$Xb.Io(a.P,d)&&(c+=$Xb.bl(a.P,d)-1);}return c>1;};$Xb.Vf=function Vf(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X;$Xb.Af(a,false);$Xb.yf(a,9,4);T=$wnd.Math.max($Xb.jg(a.P.f),$Xb.jg(a.P.g));$Xb.yf(a,UXb.Rwb(T),4);if(T==0){$Xb.yf(a,Vwb(a.P.K?1:0),1);$Xb.yf(a,0,1);a.H=$Xb.zf(a);return;}U=W=V=H=0;for(i=0;i<a.P.f;i++){if(Twb(Jwb($Xb.Lk(a.P,i),1),0)){switch($Xb.Qk(a.P,i)){case 6:break;case 7:++U;break;case 8:++W;break;default:++V;}$Xb.zk(a.P,i)!=0&&++H;}}$Xb.yf(a,Vwb(a.P.f),T);$Xb.yf(a,Vwb(a.P.g),T);$Xb.yf(a,UXb.Rwb(U),T);$Xb.yf(a,UXb.Rwb(W),T);$Xb.yf(a,UXb.Rwb(V),T);$Xb.yf(a,UXb.Rwb(H),T);for(j=0;j<a.P.f;j++)$Xb.Qk(a.P,a.w[j])==7&&Twb(Jwb($Xb.Lk(a.P,a.w[j]),1),0)&&$Xb.yf(a,UXb.Rwb(j),T);for(m=0;m<a.P.f;m++)$Xb.Qk(a.P,a.w[m])==8&&Twb(Jwb($Xb.Lk(a.P,a.w[m]),1),0)&&$Xb.yf(a,UXb.Rwb(m),T);for(n=0;n<a.P.f;n++)if($Xb.Qk(a.P,a.w[n])!=6&&$Xb.Qk(a.P,a.w[n])!=7&&$Xb.Qk(a.P,a.w[n])!=8&&Twb(Jwb($Xb.Lk(a.P,a.w[n]),1),0)){$Xb.yf(a,UXb.Rwb(n),T);$Xb.yf(a,Vwb($Xb.Qk(a.P,a.w[n])),8);}for(o=0;o<a.P.f;o++)if($Xb.zk(a.P,a.w[o])!=0&&Twb(Jwb($Xb.Lk(a.P,a.w[o]),1),0)){$Xb.yf(a,UXb.Rwb(o),T);$Xb.yf(a,Vwb(8+$Xb.zk(a.P,a.w[o])),4);}S=0;v=0;for(p=1;p<a.P.f;p++){if(a.C[p]==-1){L=0;}else {L=1+a.C[p]-v;v=a.C[p];}S<L&&(S=L);}K=$Xb.jg(S);$Xb.yf(a,UXb.Rwb(K),4);v=0;for(q=1;q<a.P.f;q++){if(a.C[q]==-1){L=0;}else {L=1+a.C[q]-v;v=a.C[q];}$Xb.yf(a,UXb.Rwb(L),K);}for(N=0;N<2*a.G;N++)$Xb.yf(a,Vwb(a.B[N]),T);for(A=0;A<a.P.g;A++){G=($Xb.dl(a.P,a.A[A])&z$b)!=0||$Xb.el(a.P,a.A[A])==32?1:$Xb.Mo(a.P,a.A[A])?0:$wnd.Math.min(3,$Xb.bl(a.P,a.A[A]));$Xb.yf(a,UXb.Rwb(G),2);}c=0;if((a.O&x$b)==0){for(r=0;r<a.P.f;r++)a.Z[a.w[r]]!=0&&a.Z[a.w[r]]!=3&&++c;}$Xb.yf(a,UXb.Rwb(c),T);if((a.O&x$b)==0){for(r=0;r<a.P.f;r++){if(a.Z[a.w[r]]!=0&&a.Z[a.w[r]]!=3){$Xb.yf(a,UXb.Rwb(r),T);if(a._[a.w[r]]==0){$Xb.yf(a,Vwb(a.Z[a.w[r]]),3);}else {X=a.Z[a.w[r]]==1?a._[a.w[r]]==1?4:6:a._[a.w[r]]==1?5:7;$Xb.yf(a,UXb.Rwb(X),3);$Xb.yf(a,Vwb(a.$[a.w[r]]),3);}}}}b=0;if((a.O&x$b)==0){for(B=0;B<a.P.g;B++)a.g[a.A[B]]!=0&&a.g[a.A[B]]!=3&&(!$Xb.Yo(a.P,a.A[B])||$Xb.el(a.P,a.A[B])==1)&&++b;}$Xb.yf(a,UXb.Rwb(b),T);if((a.O&x$b)==0){for(B=0;B<a.P.g;B++){if(a.g[a.A[B]]!=0&&a.g[a.A[B]]!=3&&(!$Xb.Yo(a.P,a.A[B])||$Xb.el(a.P,a.A[B])==1)){$Xb.yf(a,UXb.Rwb(B),T);if($Xb.el(a.P,a.A[B])==1){if(a.j[a.A[B]]==0){$Xb.yf(a,Vwb(a.g[a.A[B]]),3);}else {X=a.g[a.A[B]]==1?a.j[a.A[B]]==1?4:6:a.j[a.A[B]]==1?5:7;$Xb.yf(a,UXb.Rwb(X),3);$Xb.yf(a,Vwb(a.i[a.A[B]]),3);}}else {$Xb.yf(a,Vwb(a.g[a.A[B]]),2);}}}}$Xb.yf(a,Vwb(a.P.K?1:0),1);I=0;for(s=0;s<a.P.f;s++)$Xb.Jk(a.P,a.w[s])!=0&&++I;if(I!=0){$Xb.Df(a,1);$Xb.yf(a,UXb.Rwb(I),T);for(r=0;r<a.P.f;r++){if($Xb.Jk(a.P,a.w[r])!=0){$Xb.yf(a,UXb.Rwb(r),T);$Xb.yf(a,Vwb($Xb.Jk(a.P,a.w[r])),8);}}}a.u=0;if(a.P.K){$Xb.Fe(a,0,T,x$b,1,-1);$Xb.Fe(a,3,T,SZb,1,-1);$Xb.Fe(a,4,T,120,4,3);$Xb.Fe(a,5,T,V$b,2,1);$Xb.Fe(a,6,T,1,1,-1);$Xb.Fe(a,7,T,WZb,4,7);I=0;for(r=0;r<a.P.f;r++)$Xb.Gk(a.P,a.w[r])!=null&&++I;if(I>0){$Xb.Df(a,8);$Xb.yf(a,UXb.Rwb(I),T);for(t=0;t<a.P.f;t++){u=$Xb.Gk(a.P,a.w[t]);if(u!=null){$Xb.yf(a,UXb.Rwb(t),T);$Xb.yf(a,Vwb(u.length),4);for(e=u,f=0,g=e.length;f<g;++f){d=e[f];$Xb.yf(a,UXb.Rwb(d),8);}}}}$Xb.Ge(a,9,T,384,2,7);$Xb.Ge(a,10,T,31,5,0);$Xb.Fe(a,11,T,w$b,1,-1);$Xb.Ge(a,12,T,z$b,8,9);$Xb.Fe(a,13,T,a$b,3,14);$Xb.Fe(a,14,T,b$b,5,17);$Xb.Fe(a,16,T,u$b,3,22);}I=0;for(k=0;k<a.P.f;k++)a.a!=null&&a.a[a.w[k]]!=-1&&++I;if(I!=0){$Xb.Df(a,17);$Xb.yf(a,UXb.Rwb(I),T);for(r=0;r<a.P.f;r++){if(a.a!=null&&a.a[a.w[r]]!=-1){$Xb.yf(a,UXb.Rwb(r),T);$Xb.yf(a,Vwb(a.a[a.w[r]]),4);}}}if((a.O&8)!=0||(a.O&XZb)!=0){I=0;R=0;for(r=0;r<a.P.f;r++){P=$Xb.Bk(a.P,a.w[r]);if(P!=null){++I;R=$wnd.Math.max(R,YXb.LTb(P).length);}}if(I!=0){Q=$Xb.jg(R);$Xb.Df(a,18);$Xb.yf(a,UXb.Rwb(I),T);$Xb.yf(a,UXb.Rwb(Q),4);for(t=0;t<a.P.f;t++){J=$Xb.Bk(a.P,a.w[t]);if(J!=null){$Xb.yf(a,UXb.Rwb(t),T);$Xb.yf(a,Vwb(YXb.LTb(J).length),Q);for(M=0;M<YXb.LTb(J).length;M++)$Xb.yf(a,(YXb.GTb(M,YXb.LTb(J).length),Vwb(YXb.LTb(J).charCodeAt(M))),7);}}}}if(a.P.K){$Xb.Fe(a,19,T,YZb,3,25);$Xb.Ge(a,20,T,i$b,3,17);}I=0;for(l=0;l<a.P.f;l++)$Xb.Mk(a.P,a.w[l])!=0&&++I;if(I!=0){$Xb.Df(a,21);$Xb.yf(a,UXb.Rwb(I),T);for(h=0;h<a.P.f;h++){if($Xb.Mk(a.P,a.w[h])!=0){$Xb.yf(a,UXb.Rwb(h),T);$Xb.yf(a,Vwb($Xb.Mk(a.P,a.w[h])>>4),2);}}}if(a.P.K){$Xb.Fe(a,22,T,v$b,1,-1);$Xb.Ge(a,23,T,W$b,1,-1);$Xb.Ge(a,24,T,A$b,2,21);}if((a.O&16)!=0){for(h=0;h<a.P.f;h++){if($Xb.Jl(a.P,a.w[h])){$Xb.Df(a,25);for(d=0;d<a.P.f;d++)$Xb.yf(a,Vwb($Xb.Jl(a.P,a.w[d])?1:0),1);break;}}}O=$Xb.If(a);if(O!=null){I=0;for(B=0;B<a.P.g;B++)O[a.A[B]]&&++I;$Xb.Df(a,26);$Xb.yf(a,UXb.Rwb(I),T);for(C=0;C<a.P.g;C++)O[a.A[C]]&&$Xb.yf(a,UXb.Rwb(C),T);}a.P.K&&$Xb.Fe(a,27,T,LZb,1,-1);I=0;for(D=0;D<a.P.g;D++)$Xb.el(a.P,a.A[D])==32&&++I;if(I!=0){$Xb.Df(a,28);$Xb.yf(a,UXb.Rwb(I),T);for(B=0;B<a.P.g;B++)$Xb.el(a.P,a.A[B])==32&&$Xb.yf(a,UXb.Rwb(B),T);}if(a.P.K){$Xb.Fe(a,29,T,X$b,2,30);$Xb.Fe(a,30,T,CZb,7,32);$Xb.Fe(a,32,T,Y$b,2,44);$Xb.Fe(a,33,T,k$b,5,39);$Xb.Fe(a,34,T,VZb,1,-1);$Xb.Ge(a,35,T,Z$b,1,-1);$Xb.Ge(a,36,T,96,2,5);}I=0;for(F=0;F<a.P.g;F++)($Xb.el(a.P,a.A[F])==8||$Xb.el(a.P,a.A[F])==16)&&++I;if(I!=0){$Xb.Df(a,37);$Xb.yf(a,UXb.Rwb(I),T);for(w=0;w<a.P.g;w++){if($Xb.el(a.P,a.A[w])==8||$Xb.el(a.P,a.A[w])==16){$Xb.yf(a,UXb.Rwb(w),T);$Xb.yf(a,Vwb($Xb.el(a.P,a.A[w])==8?0:1),1);}}}$Xb.yf(a,0,1);a.H=$Xb.zf(a);};$Xb.Wf=function Wf(a){var b,c,d,e,f,g,h,i,j,k,l;a.Z=Sjb(UXb.hlb,S$b,6,a.P.f,15,1);for(b=0;b<a.P.f;b++){if(a.bb[b]==1||a.bb[b]==2){i=a.cb[b];if($Xb.Ko(a.P,b)){for(h=0;h<$Xb.Sn(a.P,b);h++){e=$Xb.Rn(a.P,b,h);l=0;k=Sjb(UXb.llb,yZb,6,3,15,1);for(j=0;j<$Xb.Sn(a.P,e);j++){k[l]=$Xb.Rn(a.P,e,j);k[l]!=b&&++l;}l==2&&a.d[k[0]]>a.d[k[1]]^a.F[k[0]]<a.F[k[1]]&&(i=!i);}}else {for(h=1;h<$Xb.Sn(a.P,b);h++){for(j=0;j<h;j++){f=$Xb.Rn(a.P,b,h);g=$Xb.Rn(a.P,b,j);a.d[f]>a.d[g]&&(i=!i);a.F[f]<a.F[g]&&(i=!i);}}}a.Z[b]=a.bb[b]==1^i?1:2;}else {a.Z[b]=a.bb[b];}}a.g=Sjb(UXb.hlb,S$b,6,a.P.g,15,1);for(c=0;c<a.P.g;c++){if(a.k[c]==1||a.k[c]==2){i=false;for(h=0;h<2;h++){d=$Xb.Vk(a.P,h,c);if($Xb.Sn(a.P,d)==3){k=Sjb(UXb.llb,yZb,6,2,15,1);l=0;for(j=0;j<3;j++)$Xb.Rn(a.P,d,j)!=$Xb.Vk(a.P,1-h,c)&&(k[l++]=$Xb.Rn(a.P,d,j));a.d[k[0]]>a.d[k[1]]&&(i=!i);a.F[k[0]]<a.F[k[1]]&&(i=!i);}}a.g[c]=a.k[c]==1^i?1:2;}else {a.g[c]=a.k[c];}}};$Xb.Xf=function Xf(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o;i=Sjb(UXb.llb,yZb,6,32,15,1);j=0;for(d=0;d<a.P.f;d++){if((a.Z[d]==1||a.Z[d]==2)&&a._[d]==b){h=a.$[d];if(i[h]<a.d[d]){i[h]==0&&++j;i[h]=a.d[d];}}}for(f=0;f<a.P.g;f++){if((a.g[f]==1||a.g[f]==2)&&a.j[f]==b&&$Xb.el(a.P,f)==1){h=a.i[f];o=$wnd.Math.max(a.d[$Xb.Vk(a.P,0,f)],a.d[$Xb.Vk(a.P,1,f)]);if(i[h]<o){i[h]==0&&++j;i[h]=o;}}}g=Sjb(UXb.hlb,S$b,6,32,15,1);for(k=0;k<j;k++){m=-1;n=0;for(l=0;l<32;l++){if(n<i[l]){n=i[l];m=l;}}i[m]=0;g[m]=k<<24>>24;}for(c=0;c<a.P.f;c++)(a.Z[c]==1||a.Z[c]==2)&&a._[c]==b&&(a.$[c]=g[a.$[c]]);for(e=0;e<a.P.g;e++)(a.g[e]==1||a.g[e]==2)&&a.j[e]==b&&$Xb.el(a.P,e)==1&&(a.i[e]=g[a.i[e]]);};$Xb.Yf=function Yf(a,b,c){var d,e;a.S=b;for(d=0;d<a.P.f;d++){a.d[d]=c[d];a.bb[d]=0;a.gb[d]=false;}for(e=0;e<a.P.g;e++){a.k[e]=0;a.o[e]=false;}};$Xb.Zf=function Zf(a,b){var c,d,e;c=$Xb.Vk(a.P,0,b);if(c>=a.P.f)return false;if(a.bb[c]==1||a.bb[c]==2)return true;if(a.bb[c]==3)return false;d=$Xb.zn(a.P,c);if(d!=-1)return a.k[d]==1||a.k[d]==2;for(e=0;e<$Xb.Sn(a.P,c);e++){if($Xb.Un(a.P,c,e)==2){if(a.bb[$Xb.Rn(a.P,c,e)]==1||a.bb[$Xb.Rn(a.P,c,e)]==2)return true;}}return false;};$Xb.$f=function $f(a,b){var c;for(c=0;c<$Xb.Sn(a.P,b);c++)if(a.k[$Xb.Tn(a.P,b,c)]==3&&$Xb.Un(a.P,b,c)==1)return true;return false;};$Xb._f=function _f(a){var b,c,d,e,f,g,h;g=Sjb(UXb.llb,yZb,6,a.S+1,15,1);for(c=0;c<a.P.f;c++){$Xb.Ek(a.P,c)==0&&(a.bb[c]==1?++g[a.d[c]]:a.bb[c]==2&&--g[a.d[c]]);}for(e=0;e<a.P.g;e++){if($Xb.bl(a.P,e)==1&&$Xb.$k(a.P,e)==0){if(a.k[e]==1){++g[a.d[$Xb.Vk(a.P,0,e)]];++g[a.d[$Xb.Vk(a.P,1,e)]];}else if(a.k[e]==2){--g[a.d[$Xb.Vk(a.P,0,e)]];--g[a.d[$Xb.Vk(a.P,1,e)]];}}}for(h=1;h<=a.S;h++){if(g[h]!=0){f=g[h]<0;if(f){for(b=0;b<a.P.f;b++){$Xb.Ek(a.P,b)==0&&(a.bb[b]==1?a.bb[b]=2:a.bb[b]==2&&(a.bb[b]=1));}for(d=0;d<a.P.g;d++){$Xb.bl(a.P,d)==1&&$Xb.$k(a.P,d)==0&&(a.k[d]==1?a.k[d]=2:a.k[d]==2&&(a.k[d]=1));}}return f;}}return false;};$Xb.ag=function ag(a,b){var c;c=Sjb(UXb.llb,yZb,6,b,15,1);VXb.pIb(a,0,c,0,a.length);return c;};$Xb.bg=function bg(a,b){var c;c=Sjb(UXb.Cwb,KZb,6,b,16,1);VXb.pIb(a,0,c,0,a.length);return c;};$Xb.cg=function cg(a){var b,c;if(a.Y!=null)for(b=0;b<a.P.f;b++)$Xb.bm(a.P,b,a.Y[b]);if(a.f!=null)for(c=0;c<a.P.g;c++)$Xb.ym(a.P,c,a.f[c]);};$Xb.dg=function dg(a){var b,c,d,e,f,g,h,i,j,k,l;for(b=0;b<a.P.f;b++){if(a.bb[b]==1||a.bb[b]==2){i=false;if($Xb.Ko(a.P,b)){for(h=0;h<$Xb.Sn(a.P,b);h++){e=$Xb.Rn(a.P,b,h);l=0;k=Sjb(UXb.llb,yZb,6,3,15,1);for(j=0;j<$Xb.Sn(a.P,e);j++){k[l]=$Xb.Rn(a.P,e,j);k[l]!=b&&++l;}l==2&&a.d[k[0]]>a.d[k[1]]^k[0]<k[1]&&(i=!i);}}else {for(h=1;h<$Xb.Sn(a.P,b);h++){for(j=0;j<h;j++){f=$Xb.Rn(a.P,b,h);g=$Xb.Rn(a.P,b,j);a.d[f]>a.d[g]&&(i=!i);f<g&&(i=!i);}}}$Xb.nm(a.P,b,a.bb[b]==1^i?1:2,a.db[b]);}else {$Xb.nm(a.P,b,a.bb[b],a.db[b]);}}for(c=0;c<a.P.g;c++){if(a.k[c]==1||a.k[c]==2){i=false;for(h=0;h<2;h++){d=$Xb.Vk(a.P,h,c);if($Xb.Sn(a.P,d)==3){k=Sjb(UXb.llb,yZb,6,2,15,1);l=0;for(j=0;j<3;j++)$Xb.Rn(a.P,d,j)!=$Xb.Vk(a.P,1-h,c)&&(k[l++]=$Xb.Rn(a.P,d,j));a.d[k[0]]>a.d[k[1]]&&(i=!i);k[0]<k[1]&&(i=!i);}}$Xb.Cm(a.P,c,a.k[c]==1^i?1:2,a.n[c]);}else {$Xb.Cm(a.P,c,a.k[c],a.n[c]);}}};$Xb.eg=function eg(a){var b;for(b=0;b<a.P.f;b++){$Xb.rm(a.P,b,a.K[b]);}};$Xb.fg=function fg(a){var b,c,d;for(b=0;b<a.P.f;b++)!$Xb.rl(a.P,b)&&a.bb[b]==3&&$Xb.em(a.P,b,true);for(c=0;c<a.P.g;c++){if(a.k[c]==3){d=$Xb.bl(a.P,c);d==1?$Xb.em(a.P,$Xb.Vk(a.P,0,c),true):d==2&&$Xb.Fm(a.P,c,386);}}};$Xb.gg=function gg(a,b){return a<b?a:a-b;};$Xb.hg=function hg(a){$Xb.ig.call(this,a,0);};$Xb.ig=function ig(a,b){this.P=a;this.O=b;$Xb.nu(this.P,7);this.b=$Xb.jg(this.P.f);(this.O&x$b)==0&&$Xb.$e(this);this.hb=(b&64)!=0||$Xb.ql(this.P);if((this.O&x$b)==0){this.bb=Sjb(UXb.hlb,S$b,6,this.P.f,15,1);this.db=Sjb(UXb.Cwb,KZb,6,this.P.f,16,1);this.gb=Sjb(UXb.Cwb,KZb,6,this.P.f,16,1);this.k=Sjb(UXb.hlb,S$b,6,this.P.g,15,1);this.o=Sjb(UXb.Cwb,KZb,6,this.P.g,16,1);this.n=Sjb(UXb.Cwb,KZb,6,this.P.g,16,1);}$Xb.cf(this);(this.O&x$b)==0&&$Xb.jf(this);$Xb.hf(this);};$Xb.jg=function jg(a){var b;b=0;while(a>0){a>>=1;++b;}return b;};xxb(47,1,{},$Xb.hg,$Xb.ig);_.b=0;_.p=false;_.r=0;_.t=0;_.u=0;_.D=false;_.G=0;_.I=false;_.J=false;_.M=0;_.O=0;_.R=0;_.S=0;_.X=false;_.hb=false;UXb.Dlb=VFb(47);$Xb.kg=function kg(a,b){var c,d,e,f;if(a.d!=b.d)return a.d>b.d?1:-1;e=a.a.length;f=b.a.length;c=$wnd.Math.min(e,f);for(d=0;d<c;d++){--e;--f;if(a.a[e]!=b.a[f])return a.a[e]>b.a[f]?1:-1;}if(e!=f)return e>f?1:-1;if(a.b!=b.b)return a.b>b.b?1:-1;return 0;};$Xb.lg=function lg(a,b){return $Xb.kg(a,b);};$Xb.mg=function mg(){};xxb(390,1,{},$Xb.mg);_.Db=function ng(a,b){return $Xb.lg(a,b);};_.ib=function og(a){return this===a;};UXb.ulb=VFb(390);$Xb.pg=function pg(){};xxb(212,1,{212:1},$Xb.pg);_.b=0;_.c=0;_.d=0;UXb.tlb=VFb(212);$Xb.qg=function qg(a,b){if(a.c!=b.c)return a.c>b.c?1:-1;return 0;};$Xb.rg=function rg(a,b){return $Xb.qg(a,b);};$Xb.sg=function sg(){};xxb(391,1,{},$Xb.sg);_.Db=function tg(a,b){return $Xb.rg(a,b);};_.ib=function ug(a){return this===a;};UXb.wlb=VFb(391);$Xb.vg=function vg(){};xxb(213,1,{213:1},$Xb.vg);_.a=0;_.b=0;_.c=0;UXb.vlb=VFb(213);$Xb.wg=function wg(a,b,c){if(a.b==0){++a.c;a.b=63;}if(a.b==63){a.d[a.c]=exb(a.d[a.c],c);a.b-=b;}else {if(a.b>=b){a.d[a.c]=fxb(a.d[a.c],b);a.d[a.c]=exb(a.d[a.c],c);a.b-=b;}else {a.d[a.c]=fxb(a.d[a.c],a.b);a.d[a.c]=exb(a.d[a.c],gxb(c,b-a.b));b-=a.b;++a.c;a.b=63-b;a.d[a.c]=exb(a.d[a.c],Jwb(c,UXb.Rwb((1<<b)-1)));}}};$Xb.xg=function xg(a,b){a.d[a.c]=Iwb(a.d[a.c],b);};$Xb.yg=function yg(a,b){var c;for(c=0;c<a.c;c++)if(cxb(a.d[c],b.d[c]))return Zwb(a.d[c],b.d[c])?-1:1;return Twb(a.d[a.c],b.d[a.c])?0:Zwb(a.d[a.c],b.d[a.c])?-1:1;};$Xb.zg=function zg(a,b){a.a=b;a.c=0;a.b=63;_Xb.COb(a.d);};$Xb.Ag=function Ag(a){this.d=Sjb(UXb.mlb,N$b,6,a,14,1);};xxb(160,1,{160:1,18:1},$Xb.Ag);_.Eb=function Bg(a){return $Xb.yg(this,a);};_.a=0;_.b=0;_.c=0;UXb.xlb=VFb(160);$Xb.Cg=function Cg(a,b){if(a.b!=b.b)return a.b>b.b?-1:1;if(a.c!=b.c)return a.c>b.c?-1:1;return 0;};$Xb.Dg=function Dg(a,b,c){this.b=$wnd.Math.max(a,b);this.c=$wnd.Math.min(a,b);this.a=c;};xxb(211,1,{211:1,18:1},$Xb.Dg);_.Eb=function Eg(a){return $Xb.Cg(this,a);};_.a=0;_.b=0;_.c=0;UXb.ylb=VFb(211);$Xb.Fg=function Fg(a,b,c,d){this.a=(YXb.wTb(b),_Xb.zOb(a,Sjb(UXb.llb,yZb,6,b,15,1),b));this.b=(YXb.wTb(d),_Xb.zOb(c,Sjb(UXb.llb,yZb,6,d,15,1),d));};xxb(255,1,{255:1},$Xb.Fg);UXb.zlb=VFb(255);$Xb.Gg=function Gg(a,b){var c,d;for(d=0;d<a.g[b].length;d++){c=a.g[b][d];if(a.f[c]&&(a.o[c]==1||a.o[c]==2)&&a.k[c]==0)return true;}return false;};$Xb.Hg=function Hg(a,b,c){var d,e,f,g,h;e=0;g=0;for(h=0;h<a.g[b].length;h++){d=a.g[b][h];if(a.k[d]==c){f=1<<a.j[d];if((g&f)==0){g|=f;++e;}}}return e;};$Xb.Ig=function Ig(a){var b,c,d,e,f,g,h,i,j,k,l,m;k=new _Xb.dSb();for(l=0;l<a.i.f;l++){if($Xb.In(a.i,l)<2||$Xb.Sn(a.i,l)>2){for(g=1;g<$Xb.Sn(a.i,l);g++){b=$Xb.Rn(a.i,l,g);for(h=0;h<g;h++){c=$Xb.Rn(a.i,l,h);$Xb.Ng(a,b,c)&&(i=$Xb.Ug(a,b,c),!!i&&$Xb.qq(i,a.f)&&_Xb.gRb(k.a,i,(VXb.iFb(),hFb))==null);}}}}for(m=0;m<a.i.g;m++){if(a.c[m]!=0){if($Xb.bl(a.i,m)!=2||a.c[m]!=2)continue;}b=$Xb.Vk(a.i,0,m);c=$Xb.Vk(a.i,1,m);$Xb.Ng(a,b,c)&&(i=$Xb.Ug(a,b,c),!!i&&$Xb.qq(i,a.f)&&_Xb.gRb(k.a,i,(VXb.iFb(),hFb))==null);}a.g=Sjb(UXb.llb,Q$b,8,k.a.c,0,2);a.e=Sjb(UXb.Cwb,KZb,6,a.i.f,16,1);f=0;for(j=(e=new _Xb.yRb(new _Xb.DRb(new _Xb.zNb(k.a).a).b),new _Xb.HNb(e));_Xb.hMb(j.a.a);){i=(d=_Xb.wRb(j.a),d.Wd());a.g[f++]=i.b;for(g=0;g<i.b.length;g++)a.e[i.b[g]]=true;}};$Xb.Jg=function Jg(a,b,c,d){var e,f,g,h,i,j,k;e=Sjb(UXb.llb,yZb,6,$Xb.Sn(a.i,c),15,1);h=0;for(g=0;g<$Xb.Sn(a.i,c);g++){e[h]=$Xb.Rn(a.i,c,g);!d[e[h]]&&$Xb.Ng(a,b,e[h])&&++h;}if(h==0)return -1;if(h==1)return e[0];i=-1;j=gZb;for(f=0;f<h;f++){k=$Xb.po(a.i,b,e[f],gZb,d);if(k<j){j=k;i=e[f];}}return i;};$Xb.Kg=function Kg(a,b){return a.f[b]&&(a.o[b]==1||a.o[b]==2);};$Xb.Lg=function Lg(a,b){return a.e[b];};$Xb.Mg=function Mg(a){var b,c;c=true;for(b=0;b<a.i.f;b++){if(a.o[b]!=0&&!a.e[b]){c=false;break;}}return c;};$Xb.Ng=function Ng(a,b,c){var d,e,f,g,h;if(b==c)return false;if(a.a[b]!=a.a[c])return false;if(a.o[b]!=0){if(a.o[b]==3||a.o[c]==3)return false;if(a.p[b]^a.o[b]!==a.o[c])return false;if(a.k[b]!==a.k[c]||a.j[b]!==a.j[c])return false;}d=$Xb.Pn(a.i,b,c);if(d!=-1){if($Xb.bl(a.i,d)==1&&a.c[d]!=0)return false;if($Xb.bl(a.i,d)==2&&a.c[d]==1)return false;}if($Xb.In(a.i,b)==1&&!$Xb.Ho(a.i,b)){e=-1;for(h=0;h<$Xb.Sn(a.i,b);h++){if($Xb.Rn(a.i,b,h)!=c&&$Xb.Un(a.i,b,h)==2){e=$Xb.Tn(a.i,b,h);break;}}f=-1;for(g=0;g<$Xb.Sn(a.i,c);g++){if($Xb.Rn(a.i,c,g)!=b&&$Xb.Un(a.i,c,g)==2){f=$Xb.Tn(a.i,c,g);break;}}if(e!=-1&&a.c[e]!=0&&a.d[e]^a.c[e]===a.c[f])return false;}return true;};$Xb.Og=function Og(a,b,c,d,e){var f,g,h,i,j,k;i=null;f=null;for(k=0;k<a.g[b].length;k++){g=a.g[b][k];a.f[g]&&(a.o[g]==1||a.o[g]==2)&&(a.k[g]==0?f=$Xb.Wg(f,(e[g]<<16)+g):a.k[g]==d&&a.j[g]==c&&(i=$Xb.Wg(i,(e[g]<<16)+g)));}h=$Xb.jh(i,f);if(h==0)return false;if(h<0){for(j=0;j<a.g[b].length;j++){g=a.g[b][j];if(a.f[g]&&(a.o[g]==1||a.o[g]==2)){if(a.k[g]==0){a.k[g]=d<<24>>24;a.j[g]=c<<24>>24;}else if(a.k[g]==d&&a.j[g]==c){a.k[g]=0;a.j[g]=-1;}}}}return true;};$Xb.Pg=function Pg(a,b){var c,d,e,f,g,h;if(!a.b)return false;e=false;for(f=a.b.a.length-1;f>=0;f--){d=false;g=_Xb.Xi(a.b,f);g.a==2?d=$Xb.Og(a,g.b,g.c,g.d,b):g.a==1&&(d=$Xb.Tg(a,g.b,b));if(d){_Xb.dj(a.b,g);for(h=0;h<a.g[g.b].length;h++){c=a.g[g.b][h];a.n[c]=false;}e=true;}}return e;};$Xb.Qg=function Qg(a){var b,c,d,e,f,g,h,i;if(a.g!=null){g=new $Xb.ih(a);a.b=new _Xb.kj();for(e=0;e<a.g.length;e++){d=$Xb._g(g,e);if(d==0){$Xb.Xg(g,e);h=$Xb.Hg(a,e,2);b=$Xb.Hg(a,e,1);c=$Xb.Gg(a,e);if(h==1&&b==1&&!c){$Xb.Sg(a,e,g.a+g.f++);_Xb.Si(a.b,new $Xb.Ij(e,1,-1,-1));}if(h>0){if(c){$Xb.Rg(a,e,g.i+g.g++,2);++h;}_Xb.Si(a.b,new $Xb.Ij(e,1,-1,-1));}else if(b>0){c&&$Xb.Rg(a,e,g.a+g.f++,1);_Xb.Si(a.b,new $Xb.Ij(e,1,-1,-1));}else if(c){$Xb.Rg(a,e,g.a+g.f++,1);_Xb.Si(a.b,new $Xb.Ij(e,1,-1,-1));}}else if(d==1){if($Xb.Gg(a,e)){f=$Xb.$g(g,e);i=$Xb.ah(g,e);_Xb.Si(a.b,new $Xb.Ij(e,2,f,i));}else {$Xb.Xg(g,e);_Xb.Si(a.b,new $Xb.Ij(e,1,-1,-1));}}}}};$Xb.Rg=function Rg(a,b,c,d){var e,f;for(f=0;f<a.g[b].length;f++){e=a.g[b][f];if(a.f[e]&&(a.o[e]==1||a.o[e]==2)&&a.k[e]==0){a.k[e]=d<<24>>24;a.j[e]=c<<24>>24;}}};$Xb.Sg=function Sg(a,b,c){var d,e;for(e=0;e<a.g[b].length;e++){d=a.g[b][e];if(a.k[d]==2){a.k[d]=1;a.j[d]=c<<24>>24;}}};$Xb.Tg=function Tg(a,b,c){var d,e,f,g,h,i,j,k;f=a.g[b];e=1;for(i=0;i<f.length;i++){d=f[i];if(a.f[d]&&a.k[d]==2){e=2;break;}}g=Sjb(UXb.llb,Q$b,8,32,0,2);for(j=0;j<f.length;j++){d=f[j];a.f[d]&&a.k[d]==e&&(g[a.j[d]]=$Xb.Wg(g[a.j[d]],(c[d]<<16)+d));}for(k=0;k<32;k++)g[k]!=null&&YXb.fTb(g[k],YXb.LTb(Axb(_Xb.ZOb.prototype.Zd,_Xb.ZOb,[])));_Xb.ROb(g,new $Xb.kh());if($Xb.jh(g[0],g[1])==0)return false;for(h=0;h<g[0].length;h++){d=g[0][h]&pZb;a.k[d]=0;a.j[d]=-1;}return true;};$Xb.Ug=function Ug(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v;i=Sjb(UXb.llb,yZb,6,a.i.f,15,1);r=Sjb(UXb.llb,yZb,6,a.i.f,15,1);o=Sjb(UXb.Cwb,KZb,6,a.i.f,16,1);j=Sjb(UXb.Cwb,KZb,6,a.i.f,16,1);s=new $Xb.rq(a.i.f);i[0]=b;r[b]=c;r[c]=-2;s.a[b]=true;s.a[c]=true;f=0;k=0;while(f<=k){g=i[f];if(r[g]==g){for(l=0;l<$Xb.Sn(a.i,g);l++){d=$Xb.Rn(a.i,g,l);if(!s.a[d]){if($Xb.Un(a.i,g,l)==2&&$Xb.Qk(a.i,d)<10){i[++k]=d;r[d]=d;j[d]=j[g]||$Xb.In(a.i,d)==2;o[d]=j[g]&&!o[g];s.a[d]=true;}else if(j[g]&&o[g]){t=$Xb.Jg(a,d,r[g],s.a);if(t==-1)return null;i[++k]=d;r[d]=t;r[t]=-2;j[d]=false;s.a[d]=true;s.a[t]=true;}else if($Xb.Vo(a.i,$Xb.Tn(a.i,g,l))){i[++k]=d;r[d]=d;j[d]=false;s.a[d]=true;if(($Xb.Qk(a.i,d)==6&&$Xb.In(a.i,d)==0||$Xb.Qk(a.i,d)==7&&$Xb.zk(a.i,d)==1||$Xb.Qk(a.i,d)==14||$Xb.Qk(a.i,d)==15&&$Xb.Sn(a.i,d)>2||$Xb.Qk(a.i,d)==16&&$Xb.Sn(a.i,d)>2)&&$Xb.Sn(a.i,d)>2){h=false;for(p=1;p<$Xb.Sn(a.i,d);p++){u=$Xb.Rn(a.i,d,p);if(!s.a[u]){for(q=0;q<p;q++){v=$Xb.Rn(a.i,d,q);if(!s.a[v]){if($Xb.Ng(a,u,v)){i[++k]=u;r[u]=v;r[v]=-2;j[u]=false;s.a[u]=true;s.a[v]=true;h=true;}}}}}if(!h)return null;}}}}}else {e=Sjb(UXb.Cwb,KZb,6,$Xb.Sn(a.i,g),16,1);for(m=0;m<$Xb.Sn(a.i,g);m++){d=$Xb.Rn(a.i,g,m);if(s.a[d]){e[m]=r[d]==d;}else {for(p=0;p<$Xb.Sn(a.i,d);p++){if($Xb.Rn(a.i,d,p)==r[g]){e[m]=true;break;}}}}for(n=0;n<$Xb.Sn(a.i,g);n++){if(e[n]){d=$Xb.Rn(a.i,g,n);if(s.a[d]){if($Xb.Pn(a.i,d,r[g])==-1)return null;}else {i[++k]=d;r[d]=d;o[d]=false;j[d]=true;s.a[d]=true;}}}for(l=0;l<$Xb.Sn(a.i,g);l++){if(!e[l]){d=$Xb.Rn(a.i,g,l);if(!s.a[d]){t=$Xb.Jg(a,d,r[g],s.a);if(t==-1)return null;i[++k]=d;r[d]=t;r[t]=-2;j[d]=false;s.a[d]=true;s.a[t]=true;}}}}++f;}return s;};$Xb.Vg=function Vg(a,b,c,d,e,f,g,h,i,j){this.i=a;this.a=b;this.f=c;this.o=d;this.c=e;this.k=f;this.j=g;this.p=h;this.d=i;this.n=j;$Xb.Ig(this);};$Xb.Wg=function Wg(a,b){var c,d;d=Sjb(UXb.llb,yZb,6,a==null?1:a.length+1,15,1);for(c=0;c<d.length-1;c++)d[c]=a[c];d[d.length-1]=b;return d;};xxb(492,1,{},$Xb.Vg);UXb.Blb=VFb(492);$Xb.Xg=function Xg(a,b){var c,d,e,f,g,h;for(e=0;e<a.b;e++){if(a.e[e][b]&&a.c[e]!=-3){for(d=0;d<=a.j.g.length;d++){if(d!=b&&a.e[e][d]){a.e[e][b]=false;h=e<a.a?e:e<a.b?e-a.a:-1;g=$Xb.gh(a,e<a.a?1:e<a.b?2:0);for(f=0;f<a.j.g[b].length;f++){c=a.j.g[b][f];$Xb.Kg(a.j,c)&&a.j.j[c]==h&&(a.j.j[c]=g<<24>>24);}}}}}};$Xb.Yg=function Yg(a,b,c){var d,e,f,g,h;h=false;g=1;b[c]=g;d=true;while(d){d=false;for(e=0;e<a.b;e++){if(b[e]==g){for(f=0;f<a.b;f++){if(b[f]==0&&$Xb.fh(a,e,f)){if(a.c[f]==-2){b[f]=g+1;d=true;}else if(a.c[f]!=a.c[c]){b[f]=g+1;h=true;}}}}}++g;}return h;};$Xb.Zg=function Zg(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o;for(i=d+1;i<a.j.g.length;i++){if(i!=d&&a.e[b][i]&&a.e[c][i]){g=Sjb(UXb.llb,yZb,6,2,15,1);g[0]=c;g[1]=b;return g;}}o=Sjb(UXb.llb,yZb,6,a.b,15,1);k=Sjb(UXb.llb,yZb,6,a.b,15,1);j=Sjb(UXb.llb,yZb,6,a.b,15,1);f=0;l=0;j[0]=b;k[b]=1;while(f<=l){for(m=0;m<a.d[j[f]].length;m++){e=a.d[j[f]][m];if(e==c){if(f==0)continue;h=k[j[f]]+1;g=Sjb(UXb.llb,yZb,6,h,15,1);g[0]=e;g[1]=j[f];for(n=2;n<h;n++)g[n]=o[g[n-1]];return g;}if(k[e]==0&&a.c[e]!=-3){k[e]=k[j[f]]+1;j[++l]=e;o[e]=j[f];}}++f;}return null;};$Xb.$g=function $g(a,b){var c;for(c=0;c<a.b;c++)if(a.e[c][b]&&a.c[c]==-3)return c<a.a?c:c<a.b?c-a.a:-1;return -1;};$Xb._g=function _g(a,b){var c,d;c=0;for(d=0;d<a.b;d++)a.e[d][b]&&a.c[d]==-3&&++c;return c;};$Xb.ah=function ah(a,b){var c;for(c=0;c<a.b;c++)if(a.e[c][b]&&a.c[c]==-3)return c<a.a?1:c<a.b?2:0;return -1;};$Xb.bh=function bh(a,b){return b<a.a?b:b<a.b?b-a.a:-1;};$Xb.dh=function dh(a,b){return b<a.a?1:b<a.b?2:0;};$Xb.eh=function eh(a,b){var c,d;d=a.j.k[b];c=a.j.j[b];return d==0?a.b:d==1?c:a.a+c;};$Xb.fh=function fh(a,b,c){var d;for(d=0;d<a.j.g.length;d++)if(a.e[b][d]&&a.e[c][d])return true;return false;};$Xb.gh=function gh(a,b){return b==1?a.a+a.f++:a.i+a.g++;};$Xb.hh=function hh(a,b){var c,d,e,f,g,h,i,j,k,l;k=gZb;i=-1;l=-1;j=-1;for(d=0;d<a.j.i.f;d++){if($Xb.Kg(a.j,d)&&a.j.k[d]!=0){for(h=0;h<b.length;h++){e=$Xb.bh(a,b[h]);f=$Xb.dh(a,b[h]);if(a.j.k[d]==f&&a.j.j[d]==e){if(k>a.j.a[d]+(f==1?oZb:0)){k=a.j.a[d]+(f==1?oZb:0);i=e;l=f;j=b[h];}}}}}for(c=0;c<a.j.i.f;c++){if($Xb.Kg(a.j,c)&&a.j.k[c]==l&&a.j.j[c]==i){a.j.k[c]=0;a.j.j[c]=-1;}}for(g=0;g<a.j.g.length;g++)a.e[j][g]=false;};$Xb.ih=function ih(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q;this.j=a;for(d=0;d<a.i.f;d++){a.f[d]&&(a.o[d]==1||a.o[d]==2)&&(a.k[d]==1?this.a<=a.j[d]&&(this.a=1+a.j[d]):a.k[d]==2&&this.i<=a.j[d]&&(this.i=1+a.j[d]));}this.b=this.a+this.i;this.e=Qjb(UXb.Cwb,[aZb,KZb],[12,6],16,[this.b+1,a.g.length+1],2);for(e=0;e<a.i.f;e++)a.f[e]&&(a.o[e]==1||a.o[e]==2)&&!a.e[e]&&(this.e[$Xb.eh(this,e)][a.g.length]=true);for(i=0;i<a.g.length;i++){for(q=0;q<a.g[i].length;q++){c=a.g[i][q];a.f[c]&&(a.o[c]==1||a.o[c]==2)&&(this.e[$Xb.eh(this,c)][i]=true);}}this.d=Sjb(UXb.llb,Q$b,8,this.b,0,2);for(j=0;j<a.g.length;j++){for(n=1;n<this.b;n++){if(this.e[n][j]){for(o=0;o<n;o++){if(this.e[o][j]){this.d[n]=$Xb.Wg(this.d[n],o);this.d[o]=$Xb.Wg(this.d[o],n);}}}}}this.c=Sjb(UXb.llb,yZb,6,this.b+1,15,1);for(m=0;m<this.b;m++){this.e[m][a.g.length]?this.c[m]=-1:this.c[m]=-2;}for(k=0;k<a.g.length;k++){if(this.e[this.b][k]){for(l=0;l<this.b;l++){this.e[l][k]&&this.c[l]!=k&&(this.c[l]==-2?this.c[l]=k:this.c[l]=-3);}}}for(b=0;b<this.b;b++){if(this.c[b]>=-1){f=Sjb(UXb.llb,yZb,6,this.b,15,1);if($Xb.Yg(this,f,b)){for(l=0;l<this.b;l++){f[l]!=0&&(this.c[l]=-3);}}}}for(h=0;h<a.g.length-1;h++){for(n=1;n<this.b;n++){if(this.e[n][h]&&this.c[n]!=-3){for(o=0;o<n;o++){if(this.e[o][h]&&this.c[o]!=-3){g=$Xb.Zg(this,n,o,h);if(g!=null){for(p=0;p<g.length;p++)this.c[g[p]]=-3;$Xb.hh(this,g);break;}}}}}}};xxb(493,1,{},$Xb.ih);_.a=0;_.b=0;_.f=0;_.g=0;_.i=0;UXb.Alb=VFb(493);$Xb.jh=function jh(a,b){var c,d;if(a==null)return b==null?0:1;if(b==null)return -1;c=$wnd.Math.min(a.length,b.length);for(d=0;d<c;d++)if((a[d]&I$b)!=(b[d]&I$b))return (a[d]&I$b)<(b[d]&I$b)?-1:1;return a.length==b.length?0:a.length<b.length?-1:1;};$Xb.kh=function kh(){};xxb(494,1,{},$Xb.kh);_.Db=function lh(a,b){return $Xb.jh(a,b);};_.ib=function mh(a){return this===a;};UXb.Clb=VFb(494);$Xb.nh=function nh(a,b){switch(b){case 0:return $Xb.oh(a,false);case 1:return $Xb.qh(a);case 2:return $Xb.ph(a);case 3:return $Xb.sh(a);case 4:return $Xb.rh(a);}return null;};$Xb.oh=function oh(b,c){try{if(!c)return $Xb.Nf(new $Xb.hg(b));b=$Xb.ru(b);$Xb.kp(b,true);$Xb.Dq(b);return $Xb.Nf(new $Xb.hg(b));}catch(a){a=Gwb(a);if(Zkb(a,28)){VXb.oIb();return null;}else throw Hwb(a);}};$Xb.ph=function ph(b){var c,d;try{b=$Xb.ru(b);$Xb.Bu(b);c=b.r;for(d=0;d<c;d++){b.H[d]=1;b.T=0;}return $Xb.Nf(new $Xb.hg(b));}catch(a){a=Gwb(a);if(Zkb(a,28)){VXb.oIb();return null;}else throw Hwb(a);}};$Xb.qh=function qh(b){try{b=$Xb.ru(b);$Xb.Bu(b);return $Xb.Nf(new $Xb.hg(b));}catch(a){a=Gwb(a);if(Zkb(a,28)){VXb.oIb();return null;}else throw Hwb(a);}};$Xb.rh=function rh(b){var c;try{b=$Xb.ru(b);$Xb.Bu(b);c=$Xb.Tu(new $Xb.Wu(b));return $Xb.Nf(new $Xb.ig(c,8));}catch(a){a=Gwb(a);if(Zkb(a,28)){VXb.oIb();return null;}else throw Hwb(a);}};$Xb.sh=function sh(b){var c;try{c=$Xb.Tu(new $Xb.Wu(b));return $Xb.Nf(new $Xb.ig(c,8));}catch(a){a=Gwb(a);if(Zkb(a,28)){VXb.oIb();return null;}else throw Hwb(a);}};$Xb.th=function th(a){var b,c,d,e;d=a.g.a.length+a.f.a.length;e=0;for(b=0;b<d;b++){c=b<a.g.a.length?_Xb.Xi(a.g,b):_Xb.Xi(a.f,b-a.g.a.length);c.q>1&&(e+=$Xb.Sk(c,c.q,c.r,($Xb.Sj(),$Xb.Rj)));}return d>0?e/d:0;};$Xb.uh=function uh(a){var b,c,d,e,f,g,h;e=$$b;g=$$b;f=_$b;h=_$b;if(!a)return null;d=a.q;b=0;b=$Xb.Sk(a,a.q,a.r,($Xb.Sj(),$Xb.Rj));for(c=0;c<d;c++){e=$wnd.Math.max(e,a.J[c].a);f=$wnd.Math.min(f,a.J[c].a);g=$wnd.Math.max(g,a.J[c].b);h=$wnd.Math.min(h,a.J[c].b);}return d>0?new lYb.KG(f,h,$wnd.Math.max(e-f,b),$wnd.Math.max(g-h,b)):null;};$Xb.vh=function vh(a){var b,c,d;if(a.length==0){return new lYb.KG(0,0,0,0);}c=$Xb.uh(a[0]);for(b=1;b<a.length;b++){d=$Xb.uh(a[b]);!!d&&(!c?c=d:c=lYb.IG(c,$Xb.uh(a[b])));}!c&&(c=new lYb.KG(0,0,0,0));return c;};$Xb.wh=function wh(a){var b,c;c=Sjb(UXb.Jlb,a_b,97,a.f.a.length,0,1);for(b=0;b<c.length;b++){c[b]=_Xb.Xi(a.f,b);}return c;};$Xb.xh=function xh(a){var b,c;c=Sjb(UXb.Jlb,a_b,97,a.g.a.length,0,1);for(b=0;b<c.length;b++){c[b]=_Xb.Xi(a.g,b);}return c;};$Xb.yh=function yh(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v;if(b>d*2){p=$Xb.xh(a);m=$Xb.wh(a);u=0;t=0;k=a.g.a.length+a.f.a.length;for(i=0;i<k;i++){j=i<a.g.a.length?_Xb.Xi(a.g,i):_Xb.Xi(a.f,i-a.g.a.length);if(j.q>1){n=$Xb.uh(j);if(n){t+=n.a;u+=n.b;}}}if(t==0||u==0)return;q=b/u;r=c/t;s=q;q>r&&(s=r);e=$Xb.th(a);v=(b-d)/2;h=c;s=$wnd.Math.min(24/e,s);o=$Xb.vh(p);$Xb.Ah(p,0,0,s);o=$Xb.vh(p);f=0-o.c+(v-o.b)/2;g=0-o.d+(h-o.a)/2;$Xb.Ah(p,f,g,1);l=$Xb.vh(m);$Xb.Ah(m,0,0,s);l=$Xb.vh(m);f=v+d-l.c+(v-l.b)/2;g=0-l.d+(h-l.a)/2;$Xb.Ah(m,f,g,1);}};$Xb.zh=function zh(a,b,c,d){var e,f;e=a.q;for(f=0;f<e;f++){$Xb.sm(a,f,(a.J[f].a+b)*d);$Xb.tm(a,f,(a.J[f].b+c)*d);}};$Xb.Ah=function Ah(a,b,c,d){var e,f,g,h;for(f=a,g=0,h=f.length;g<h;++g){e=f[g];$Xb.zh(e,b,c,d);}};$Xb.Bh=function Bh(a,b,c,d){a.a+=b;a.b+=c;a.c+=d;};$Xb.Ch=function Ch(a,b){a.a+=b.a;a.b+=b.b;a.c+=b.c;return a;};$Xb.Dh=function Dh(a,b){return new $Xb.Sh(a.a+b.a,a.b+b.b,a.c+b.c);};$Xb.Eh=function Eh(a,b){a.a=(a.a+b.a)/2;a.b=(a.b+b.b)/2;a.c=(a.c+b.c)/2;return a;};$Xb.Fh=function Fh(a,b){if(a.a!=b.a)return a.a<b.a?-1:1;if(a.b!=b.b)return a.b<b.b?-1:1;if(a.c!=b.c)return a.c<b.c?-1:1;return 0;};$Xb.Gh=function Gh(a,b){return new $Xb.Sh(a.b*b.c-a.c*b.b,-(a.a*b.c-a.c*b.a),a.a*b.b-a.b*b.a);};$Xb.Hh=function Hh(a,b){return $wnd.Math.sqrt((b.a-a.a)*(b.a-a.a)+(b.b-a.b)*(b.b-a.b)+(b.c-a.c)*(b.c-a.c));};$Xb.Ih=function Ih(a,b){var c;if(b==null||!Zkb(b,32))return false;c=b;return $wnd.Math.abs(c.a-a.a)+$wnd.Math.abs(c.b-a.b)+$wnd.Math.abs(c.c-a.c)<1.0E-6;};$Xb.Jh=function Jh(a,b){var c,d,e;d=a.a*a.a+a.b*a.b+a.c*a.c;e=b.a*b.a+b.b*b.b+b.c*b.c;if(d==0||e==0)return 0;c=(a.a*b.a+a.b*b.b+a.c*b.c)/$wnd.Math.sqrt(d*e);if(c>=1)return 0;if(c<=-1)return PZb;return $wnd.Math.acos(c);};$Xb.Kh=function Kh(a,b){var c,d,e;c=a.a;d=a.b;e=a.c;a.a=c*b[0][0]+d*b[1][0]+e*b[2][0];a.b=c*b[0][1]+d*b[1][1]+e*b[2][1];a.c=c*b[0][2]+d*b[1][2]+e*b[2][2];return a;};$Xb.Lh=function Lh(a,b){a.a*=b;a.b*=b;a.c*=b;return a;};$Xb.Mh=function Mh(a,b,c,d){a.a=b;a.b=c;a.c=d;};$Xb.Nh=function Nh(a,b){$Xb.Mh(a,b.a,b.b,b.c);return a;};$Xb.Oh=function Oh(a,b){a.a-=b.a;a.b-=b.b;a.c-=b.c;return a;};$Xb.Ph=function Ph(a,b){return new $Xb.Sh(a.a-b.a,a.b-b.b,a.c-b.c);};$Xb.Qh=function Qh(a){var b;b=$wnd.Math.sqrt(a.a*a.a+a.b*a.b+a.c*a.c);if(b==0){VXb.oIb();a.a=1;a.b=0;a.c=0;return a;}a.a/=b;a.b/=b;a.c/=b;return a;};$Xb.Rh=function Rh(){};$Xb.Sh=function Sh(a,b,c){this.a=a;this.b=b;this.c=c;};$Xb.Th=function Th(a){$Xb.Sh.call(this,a.a,a.b,a.c);};xxb(32,1,{32:1,4:1,18:1},$Xb.Rh,$Xb.Sh,$Xb.Th);_.Eb=function Uh(a){return $Xb.Fh(this,a);};_.ib=function Vh(a){return $Xb.Ih(this,a);};_.lb=function Wh(){var a;a=new UYb.SKb('0.00');return '['+UYb.QKb(a,this.a)+', '+UYb.QKb(a,this.b)+', '+UYb.QKb(a,this.c)+']';};_.a=0;_.b=0;_.c=0;UXb.Elb=VFb(32);$Xb.Xh=function Xh(a,b){b.c*=a.c;b.a=b.a*a.c+a.a;b.b=b.b*a.c+a.b;};$Xb.Yh=function Yh(a,b){$Xb.Zl(b,a.c);$Xb.Um(b,a.a,a.b);};$Xb.Zh=function Zh(a,b){b.a=b.a*a.c+a.a;b.b=b.b*a.c+a.b;};$Xb.$h=function $h(a,b){b.c=b.c*a.c+a.a;b.d=b.d*a.c+a.b;b.b*=a.c;b.a*=a.c;};$Xb._h=function _h(a){a.a=0;a.b=0;a.c=1;};$Xb.ai=function ai(a){return a.c==1&&a.a==0&&a.b==0;};$Xb.bi=function bi(a,b){return b*a.c+a.a;};$Xb.ci=function ci(a,b){return b*a.c+a.b;};$Xb.di=function di(){$Xb._h(this);};$Xb.ei=function ei(a,b){this.c=1;this.a=a;this.b=b;};$Xb.fi=function fi(a,b,c,d){var e,f,g,h;$Xb._h(this);if(b){if((d&U$b)==0){if(!(lYb.FG(b,a.c,a.d)&&lYb.FG(b,a.c+a.b,a.d+a.a))){if(a.b>b.b||a.a>b.a){f=b.b/a.b;h=b.a/a.a;this.c=$wnd.Math.min(f,h);}a.c*this.c<b.c?this.a=b.c-a.c*this.c:(a.c+a.b)*this.c>b.c+b.b&&(this.a=b.c+b.b-(a.c+a.b)*this.c);a.d*this.c<b.d?this.b=b.d-a.d*this.c:(a.d+a.a)*this.c>b.d+b.a&&(this.b=b.d+b.a-(a.d+a.a)*this.c);}}else {f=b.b/a.b;h=b.a/a.a;g=d&pZb;g==0?g=24:(d&T$b)!=0&&(g/=256);e=g/c;this.c=$wnd.Math.min(e,$wnd.Math.min(f,h));this.a=b.c+b.b/2-this.c*(a.c+a.b/2);this.b=b.d+b.a/2-this.c*(a.d+a.a/2);}}else if((d&oZb)!=0){g=(d&pZb)!=0?d&pZb:24;this.c=g/c;}};xxb(106,1,{},$Xb.di,$Xb.ei,$Xb.fi);_.lb=function gi(){return 'DepictorTransformation Offset: '+this.a+','+this.b+' Scaling: '+this.c;};_.a=0;_.b=0;_.c=0;UXb.Flb=VFb(106);$Xb.hi=function hi(a){var b,c,d,e;if(!VXb.DHb(YXb.LTb(a).substr(0,21),K$b)||(d=YXb.LTb(L$b).length,!VXb.DHb(YXb.LTb(a).substr(YXb.LTb(a).length-d,d),L$b)))return null;c=VXb.IHb(a,UHb(34),21);if(c==-1)return null;e=(YXb.FTb(21,c,YXb.LTb(a).length),YXb.LTb(a).substr(21,c-21));b=VXb.RHb(a,21+YXb.LTb(e).length+1,YXb.LTb(a).length-17);if(VXb.DHb(e,'arrow'))return new jYb.IF(b);if(VXb.DHb(e,b_b))return new $Xb.jv(b);return null;};_Xb.ii=function ii(a,b,c){var d,e;for(e=a.Fb();e.Fd();){d=e.Gd();if(flb(b)===flb(d)||b!=null&&VXb.Gc(b,d)){c&&e.Hd();return true;}}return false;};_Xb.ji=function ji(a,b){var c,d;YXb.ATb(b);for(d=b.Fb();d.Fd();){c=d.Gd();if(!a.contains(c)){return false;}}return true;};_Xb.ki=function ki(a,b){var c,d,e;YXb.ATb(b);c=false;for(d=a.Fb();d.Fd();){e=d.Gd();if(b.contains(e)){d.Hd();c=true;}}return c;};_Xb.li=function li(a){var b,c,d;d=new _Xb.YQb('[',']');for(c=a.Fb();c.Fd();){b=c.Gd();_Xb.WQb(d,flb(b)===flb(a)?'(this Collection)':b==null?iZb:Exb(b));}return !d.a?d.c:YXb.LTb(d.e).length==0?d.a.a:d.a.a+(''+d.e);};xxb(60,1,c_b);_.add=function mi(a){throw Hwb(new VXb.sIb('Add not supported on this collection'));};_.addAll=function ni(a){var b,c,d;YXb.ATb(a);b=false;for(d=a.Fb();d.Fd();){c=d.Gd();b=b|this.add(c);}return b;};_.clear=function oi(){var a;for(a=this.Fb();a.Fd();){a.Gd();a.Hd();}};_.contains=function pi(a){return _Xb.ii(this,a,false);};_.containsAll=function qi(a){return _Xb.ji(this,a);};_.isEmpty=function ri(){return this.size()==0;};_.remove=function si(a){return _Xb.ii(this,a,true);};_.removeAll=function ti(a){return _Xb.ki(this,a);};_.retainAll=function ui(a){var b,c,d;YXb.ATb(a);b=false;for(c=this.Fb();c.Fd();){d=c.Gd();if(!a.contains(d)){c.Hd();b=true;}}return b;};_.toArray=function vi(){return this.Gb(Sjb(UXb.Iub,kZb,1,this.size(),5,1));};_.Gb=function wi(a){var b,c,d,e;e=this.size();a.length<e&&(a=YXb.gTb(new Array(e),a));d=a;c=this.Fb();for(b=0;b<e;++b){Wjb(d,b,c.Gd());}a.length>e&&UXb.Vjb(a,e,null);return a;};_.lb=function xi(){return _Xb.li(this);};UXb.Xub=VFb(60);_Xb.yi=function yi(a){return new _Xb.qMb(a,0);};_Xb.zi=function zi(a,b){return new _Xb.qMb(a,b);};_Xb.Ai=function Ai(a,b,c){return new _Xb.uMb(a,b,c);};xxb(104,60,d_b);_.addAtIndex=function Bi(a,b){throw Hwb(new VXb.sIb('Add not supported on this list'));};_.add=function Ci(a){this.addAtIndex(this.size(),a);return true;};_.addAllAtIndex=function Di(a,b){var c,d,e;YXb.ATb(b);c=false;for(e=b.Fb();e.Fd();){d=e.Gd();this.addAtIndex(a++,d);c=true;}return c;};_.clear=function Ei(){this.Jb(0,this.size());};_.ib=function Fi(a){var b,c,d,e,f;if(a===this){return true;}if(!Zkb(a,121)){return false;}f=a;if(this.size()!=f.size()){return false;}e=f.Fb();for(c=this.Fb();c.Fd();){b=c.Gd();d=e.Gd();if(!(flb(b)===flb(d)||b!=null&&VXb.Gc(b,d))){return false;}}return true;};_.kb=function Gi(){return _Xb.cPb(this);};_.indexOf=function Hi(a){var b,c;for(b=0,c=this.size();b<c;++b){if(_Xb.KQb(a,this.getAtIndex(b))){return b;}}return -1;};_.Fb=function Ii(){return new _Xb.kMb(this);};_.lastIndexOf=function Ji(a){var b;for(b=this.size()-1;b>-1;--b){if(_Xb.KQb(a,this.getAtIndex(b))){return b;}}return -1;};_.Hb=function Ki(){return _Xb.yi(this);};_.Ib=function Li(a){return _Xb.zi(this,a);};_.removeAtIndex=function Mi(a){throw Hwb(new VXb.sIb('Remove not supported on this list'));};_.Jb=function Ni(a,b){var c,d;d=new _Xb.qMb(this,a);for(c=a;c<b;++c){YXb.yTb(d.b<d.d.size());d.d.getAtIndex(d.c=d.b++);_Xb.jMb(d);}};_.setAtIndex=function Oi(a,b){throw Hwb(new VXb.sIb('Set not supported on this list'));};_.subList=function Pi(a,b){return _Xb.Ai(this,a,b);};UXb.cvb=VFb(104);function iGb(a){if(a==null){return false;}return a.$implements__java_lang_Cloneable||Array.isArray(a);}_Xb.Qi=function Qi(a){a.a=Sjb(UXb.Iub,kZb,1,0,5,1);};_Xb.Ri=function Ri(a,b,c){YXb.CTb(b,a.a.length);YXb._Sb(a.a,b,c);};_Xb.Si=function Si(a,b){YXb.cTb(a.a,b);return true;};_Xb.Ti=function Ti(a,b,c){var d,e;YXb.CTb(b,a.a.length);d=c.toArray();e=d.length;if(e==0){return false;}YXb.aTb(a.a,b,d);return true;};_Xb.Ui=function Ui(a,b){var c,d;c=b.toArray();d=c.length;if(d==0){return false;}YXb.aTb(a.a,a.a.length,c);return true;};_Xb.Vi=function Vi(a){YXb.eTb(a.a,0);};_Xb.Wi=function Wi(a,b){return _Xb.Zi(a,b,0)!=-1;};_Xb.Xi=function Xi(a,b){YXb.zTb(b,a.a.length);return a.a[b];};_Xb.Yi=function Yi(a,b){return _Xb.Zi(a,b,0);};_Xb.Zi=function Zi(a,b,c){for(;c<a.a.length;++c){if(_Xb.KQb(b,a.a[c])){return c;}}return -1;};_Xb.$i=function $i(a){return a.a.length==0;};_Xb._i=function _i(a){return new _Xb.rOb(a);};_Xb.aj=function aj(a,b){return _Xb.bj(a,b,a.a.length-1);};_Xb.bj=function bj(a,b,c){for(;c>=0;--c){if(_Xb.KQb(b,a.a[c])){return c;}}return -1;};_Xb.cj=function cj(a,b){var c;c=(YXb.zTb(b,a.a.length),a.a[b]);YXb.dTb(a.a,b,1);return c;};_Xb.dj=function dj(a,b){var c;c=_Xb.Zi(a,b,0);if(c==-1){return false;}_Xb.cj(a,c);return true;};_Xb.ej=function ej(a,b,c){var d;YXb.DTb(b,c,a.a.length);d=c-b;YXb.dTb(a.a,b,d);};_Xb.fj=function fj(a,b,c){var d;d=(YXb.zTb(b,a.a.length),a.a[b]);a.a[b]=c;return d;};_Xb.gj=function gj(a){return a.a.length;};_Xb.hj=function hj(a,b){_Xb.QOb(a.a,a.a.length,b);};_Xb.ij=function ij(a){return YXb.YSb(a.a);};_Xb.jj=function jj(a,b){var c,d;d=a.a.length;b.length<d&&(b=YXb.gTb(new Array(d),b));for(c=0;c<d;++c){Wjb(b,c,a.a[c]);}b.length>d&&UXb.Vjb(b,d,null);return b;};_Xb.kj=function kj(){_Xb.Qi(this);};_Xb.lj=function lj(a){_Xb.Qi(this);YXb.uTb(a>=0,'Initial capacity must not be negative');};xxb(21,104,e_b,_Xb.kj,_Xb.lj);_.addAtIndex=function mj(a,b){_Xb.Ri(this,a,b);};_.add=function nj(a){return _Xb.Si(this,a);};_.addAllAtIndex=function oj(a,b){return _Xb.Ti(this,a,b);};_.addAll=function pj(a){return _Xb.Ui(this,a);};_.clear=function qj(){_Xb.Vi(this);};_.contains=function rj(a){return _Xb.Wi(this,a);};_.getAtIndex=function sj(a){return _Xb.Xi(this,a);};_.indexOf=function tj(a){return _Xb.Yi(this,a);};_.isEmpty=function uj(){return _Xb.$i(this);};_.Fb=function vj(){return _Xb._i(this);};_.lastIndexOf=function wj(a){return _Xb.aj(this,a);};_.removeAtIndex=function xj(a){return _Xb.cj(this,a);};_.remove=function yj(a){return _Xb.dj(this,a);};_.Jb=function zj(a,b){_Xb.ej(this,a,b);};_.setAtIndex=function Aj(a,b){return _Xb.fj(this,a,b);};_.size=function Bj(){return _Xb.gj(this);};_.toArray=function Cj(){return _Xb.ij(this);};_.Gb=function Dj(a){return _Xb.jj(this,a);};UXb.tvb=VFb(21);$Xb.Ej=function Ej(a){var b,c;c=new VXb._Hb();for(b=0;b<a.a.length;b++)VXb.$Hb(c,$Xb.$d((YXb.zTb(b,a.a.length),a.a[b]))+_Yb);return c.a;};$Xb.Fj=function Fj(b){var c;_Xb.kj.call(this);try{if(b){for(c=0;c<b.a.length;c++)_Xb.Si(this,(YXb.zTb(c,b.a.length),b.a[c]).Ab());}}catch(a){a=Gwb(a);if(!Zkb(a,19))throw Hwb(a);}};$Xb.Gj=function Gj(a){var b,c,d;_Xb.kj.call(this);if(a==null||YXb.LTb(a).length==0)return;b=0;c=VXb.HHb(a,UHb(10));while(c!=-1){d=$Xb.hi((YXb.FTb(b,c,YXb.LTb(a).length),YXb.LTb(a).substr(b,c-b)));!!d&&(YXb.cTb(this.a,d),true);b=c+1;c=VXb.IHb(a,UHb(10),b);}};xxb(246,21,e_b,$Xb.Fj,$Xb.Gj);_.lb=function Hj(){return $Xb.Ej(this);};UXb.Glb=VFb(246);$Xb.Ij=function Ij(a,b,c,d){this.b=a;this.a=b;this.c=c;this.d=d;};xxb(125,1,{125:1},$Xb.Ij);_.a=0;_.b=0;_.c=0;_.d=0;UXb.Hlb=VFb(125);$Xb.Jj=function Jj(a){var b,c,d,e,f,g;if(a.j!=0)return a.j;if(a.i&&$Xb.Qk(a.e,a.a)!=15&&$Xb.Qk(a.e,a.a)!=16){for(g=0;g<$Xb.Dn(a.e,a.a);g++){f=$Xb.Tn(a.e,a.a,g);if($Xb.Ml(a.e,f,a.a)){$Xb.Rn(a.e,a.a,g)==a.b?a.j=$Xb.el(a.e,f)==257?3:1:a.j=$Xb.el(a.e,f)==257?1:3;return a.j;}}}b=$Xb.Uk(a.e,a.a,a.g);d=$Xb.Uk(a.e,a.a,a.b);d<b&&(d+=OZb);if($Xb.Dn(a.e,a.a)==2){c=d-b;if(c>3.0915926535897933&&c<3.191592653589793){a.j=-1;return a.j;}a.j=c<PZb?4:2;return a.j;}else {e=$Xb.Uk(a.e,a.a,a.d);e<b&&(e+=OZb);a.j=e<d?2:4;return a.j;}};$Xb.Kj=function Kj(a,b,c,d){var e,f,g,h;this.e=a;this.g=c;this.a=d;g=-1;for(h=0;h<$Xb.Dn(this.e,this.a);h++){e=$Xb.Rn(this.e,this.a,h);f=$Xb.Tn(this.e,this.a,h);if(e==this.g){$Xb.el(this.e,f)==386&&(this.j=-1);continue;}if($Xb.Ml(this.e,f,this.a)){this.i&&(a.u[d]|=oZb);this.i=true;}if(g==b[e]){this.d=e;this.f=true;this.c=$Xb.Vo(this.e,f);}else if(g<b[e]){g=b[e];this.d=this.b;this.b=e;}else {this.d=e;}}};xxb(143,1,{},$Xb.Kj);_.a=0;_.b=0;_.c=false;_.d=0;_.f=false;_.g=0;_.i=false;_.j=0;UXb.Ilb=VFb(143);$Xb.Sj=function Sj(){$Xb.Sj=zxb;$Xb.Mj=$jb(Mjb(UXb.Oub,1),nZb,2,6,['?','H','He','Li','Be','B','C','N','O','F','Ne','Na','Mg','Al','Si','P','S','Cl','Ar','K','Ca','Sc','Ti','V','Cr','Mn','Fe','Co','Ni','Cu','Zn','Ga','Ge','As','Se','Br','Kr','Rb','Sr','Y','Zr','Nb','Mo','Tc','Ru','Rh','Pd','Ag','Cd','In','Sn','Sb','Te','I','Xe','Cs','Ba','La','Ce','Pr','Nd','Pm','Sm','Eu','Gd','Tb','Dy','Ho','Er','Tm','Yb','Lu','Hf','Ta','W','Re','Os','Ir','Pt','Au','Hg','Tl','Pb','Bi','Po','At','Rn','Fr','Ra','Ac','Th','Pa','U','Np','Pu','Am','Cm','Bk','Cf','Es','Fm','Md','No','Lr','Rf','Db','Sg','Bh','Hs','Mt','Ds','Rg','Cn','Nh','Fl','Mc','Lv','Ts','Og',f_b,f_b,f_b,f_b,f_b,f_b,f_b,f_b,f_b,f_b,'R4','R5','R6','R7','R8','R9','R10','R11','R12','R13','R14','R15','R16','R1','R2','R3','A','A1','A2','A3',f_b,f_b,'D','T','X','R','H2','H+','Nnn','HYD','Pol',f_b,f_b,f_b,f_b,f_b,f_b,f_b,f_b,f_b,f_b,f_b,'Ala','Arg','Asn','Asp','Cys','Gln','Glu','Gly','His','Ile','Leu','Lys','Met','Phe','Pro','Ser','Thr','Trp','Tyr','Val']);$Xb.Qj=$jb(Mjb(UXb.Bwb,1),M$b,6,15,[0,1,4,7,9,11,12,14,16,19,20,23,24,27,28,31,32,35,40,39,40,45,48,51,52,55,56,59,58,63,64,69,74,75,80,79,84,85,88,89,90,93,98,0,102,103,106,107,114,115,120,121,130,127,132,133,138,139,140,141,142,0,152,153,158,159,164,165,166,169,174,175,180,181,184,187,192,193,195,197,202,205,208,209,209,210,222,223,226,227,232,231,238,237,244,243,247,247,251,252,257,258,259,262,267,268,271,270,277,276,281,281,283,285,289,289,293,294,294,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,156,114,115,103,128,129,57,137,113,113,128,131,147,97,87,101,186,163,99]);$Xb.Pj=$jb(Mjb(UXb.hlb,1),S$b,6,15,[6]);$Xb.Lj=$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]);$Xb.Nj=$jb(Mjb(UXb.hlb,2),aZb,10,0,[null,$jb(Mjb(UXb.hlb,1),S$b,6,15,[1]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[0]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[1]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[4]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[1]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[0]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[1]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[4]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3,5]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2,4,6]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[1,3,5,7]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[0]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[1]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),null,null,null,null,null,null,null,null,null,null,$jb(Mjb(UXb.hlb,1),S$b,6,15,[2,3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2,4]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3,5]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2,4,6]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[1,3,5,7]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[0,2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[1]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),null,null,null,null,null,null,null,null,null,null,$jb(Mjb(UXb.hlb,1),S$b,6,15,[1,2,3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2,4]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3,5]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2,4,6]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[1,3,5,7]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[0,2,4,6]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[1]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2])]);$Xb.Oj=$jb(Mjb(UXb.hlb,2),aZb,10,0,[null,$jb(Mjb(UXb.hlb,1),S$b,6,15,[1]),null,$jb(Mjb(UXb.hlb,1),S$b,6,15,[1]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),null,null,$jb(Mjb(UXb.hlb,1),S$b,6,15,[-3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[-2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[-1]),null,$jb(Mjb(UXb.hlb,1),S$b,6,15,[1]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3]),null,$jb(Mjb(UXb.hlb,1),S$b,6,15,[-3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[-2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[-1]),null,$jb(Mjb(UXb.hlb,1),S$b,6,15,[1]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2,3,4]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2,3,4,5]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2,3,6]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2,3,4,7]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2,3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2,3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2,3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[1,2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2,4]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[-3,3,5]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[-2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[-1]),null,$jb(Mjb(UXb.hlb,1),S$b,6,15,[1]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[4]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3,5]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[6]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[4,6,7]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2,4]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[1]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2,4]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[-3,3,5]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[-2,4,6]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[-1]),null,$jb(Mjb(UXb.hlb,1),S$b,6,15,[1]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3,4]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2,3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2,3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2,3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[4]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[5]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[6]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[4,6,7]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3,4]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3,4]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2,4]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[1,3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[1,2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[1,3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2,4]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3,5]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[-2,2,4]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[-1,1]),null,$jb(Mjb(UXb.hlb,1),S$b,6,15,[1]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[4]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[4,5]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3,4,5,6]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3,4,5,6]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3,4,5,6]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3,4,5,6]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3,4]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2,3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[2,3]),$jb(Mjb(UXb.hlb,1),S$b,6,15,[3])]);};$Xb.Tj=function Tj(a,b,c,d){var e;e=$Xb.Uj(a,6);$Xb.Mh(a.J[e],b,c,d);return e;};$Xb.Uj=function Uj(a,b){a.q>=a.M&&$Xb.Km(a,a.M*2);a.C[a.q]=0;$Xb.vm(a,a.q,b);a.s[a.q]=0;a.u[a.q]=0;a.B[a.q]=0;a.w[a.q]=0;$Xb.Mh(a.J[a.q],0,0,0);a.v!=null&&(a.v[a.q]=null);a.t!=null&&(a.t[a.q]=null);a.T=0;return a.q++;};$Xb.Vj=function Vj(a,b,c){return $Xb.Wj(a,b,c,$Xb.Fl(a,b)||$Xb.Fl(a,c)?32:1);};$Xb.Wj=function Wj(a,b,c,d){var e;if(b==c)return -1;for(e=0;e<a.r;e++){if(a.D[0][e]==b&&a.D[1][e]==c||a.D[0][e]==c&&a.D[1][e]==b){a.H[e]<d&&(a.H[e]=d);return e;}}a.r>=a.N&&$Xb.Lm(a,a.N*2);a.D[0][a.r]=b;a.D[1][a.r]=c;a.H[a.r]=d;a.F[a.r]=0;a.G[a.r]=0;a.T=0;return a.r++;};$Xb.Xj=function Xj(a,b){return $Xb.Yj(a,b,b.q,b.r);};$Xb.Yj=function Yj(a,b,c,d){var e,f,g,h,i;a.K=a.K|b.K;f=Sjb(UXb.llb,yZb,6,b.q,15,1);h=$Xb.Yl(a,1);i=$Xb.Yl(a,2);for(e=0;e<c;e++){f[e]=$Xb.jk(b,a,e,h,i);}for(g=0;g<d;g++){$Xb.kk(b,a,g,h,i,f[b.D[0][g]],f[b.D[1][g]],false);}a.L=a.L&&b.L;a.I=0;a.T=0;return f;};$Xb.Zj=function Zj(a,b,c,d,e,f,g,h){var i,j;i=$Xb.vk(a,b,c);if(i==-1){a.q>=a.M&&$Xb.Km(a,a.M*2);i=$Xb.Uj(a,d);$Xb.Mh(a.J[i],b,c,0);a.A[i]=e;$Xb.am(a,i,f);$Xb.pm(a,i,g);$Xb.fm(a,i,h);return true;}j=$Xb.ek(a,i,d,e,f,g);$Xb.fm(a,i,h);return j;};$Xb.$j=function $j(a,b,c,d){var e;for(e=0;e<a.r;e++){if(a.D[0][e]==b&&a.D[1][e]==c||a.D[0][e]==c&&a.D[1][e]==b){$Xb.gk(a,e,d);a.T=0;return e;}}a.r>=a.N&&$Xb.Lm(a,a.N*2);a.D[0][a.r]=b;a.D[1][a.r]=c;a.H[a.r]=d;a.F[a.r]=0;a.G[a.r]=0;a.T=0;return a.r++;};$Xb._j=function _j(a,b,c,d,e,f){var g,h,i;while(a.q+d>a.M)$Xb.Km(a,a.M*2);while(a.r+d>a.N)$Xb.Lm(a,a.N*2);g=$Xb.vk(a,b,c);if(g!=-1)return $Xb.ak(a,g,d,e,f);h=$Xb.wk(a,b,c);if(h!=-1)return $Xb.bk(a,h,d,e,f);g=$Xb.Tj(a,b,c,0);i=PZb*(d-2)/d;$Xb.Ql(a,g,d,g,e,0,PZb-i,f);a.T=0;return true;};$Xb.ak=function ak(a,b,c,d,e){var f,g,h,i,j,k;if(d&&$Xb.ko(a,b)>1||!d&&$Xb.ko(a,b)>2)return false;g=0;f=Sjb(UXb.jlb,wZb,6,4,15,1);for(i=0;i<a.r;i++){for(j=0;j<2;j++){if(a.D[j][i]==b){if(g==2){g=3;break;}f[g++]=$Xb.Uk(a,b,a.D[1-j][i]);}}if(g==3)break;}if(g==3)return false;k=g==1?f[0]+PZb:$wnd.Math.abs(f[0]-f[1])>PZb?(f[0]+f[1])/2:(f[0]+f[1])/2+PZb;h=PZb*(c-2)/c;$Xb.Ql(a,b,c,b,d,k-h/2,PZb-h,e);a.T=0;return true;};$Xb.bk=function bk(a,b,c,d,e){var f,g,h,i,j,k,l,m,n,o,p;j=Sjb(UXb.llb,yZb,6,2,15,1);i=Sjb(UXb.jlb,wZb,6,2,15,1);j[0]=a.D[0][b];j[1]=a.D[1][b];if($Xb.ko(a,j[0])>3)return false;if($Xb.ko(a,j[1])>3)return false;g=0;f=Sjb(UXb.jlb,wZb,6,4,15,1);for(m=0;m<a.r;m++){if(m==b)continue;for(n=0;n<2;n++){for(o=0;o<2;o++){if(a.D[n][m]==j[o]){if(g==4){g=5;break;}f[g++]=$Xb.Uk(a,j[o],a.D[1-n][m]);}}if(g==5)break;}if(g==5)break;}if(g==5)return false;i[0]=$Xb.Uk(a,j[0],j[1]);if(i[0]<0){i[1]=i[0]+PZb;h=0;}else {i[1]=i[0];i[0]=i[1]-PZb;h=1;}p=0;for(l=0;l<g;l++){f[l]>i[0]&&f[l]<i[1]?--p:++p;}h=p>0?1-h:h;k=PZb*(c-2)/c;$Xb.Ql(a,j[h],c-1,j[1-h],d,i[p>0?0:1]+PZb-k,PZb-k,e);a.T=0;return true;};$Xb.ck=function ck(a,b,c){var d,e,f,g,h;e=Sjb(UXb.llb,yZb,6,b.q,15,1);g=$Xb.Yl(a,1);h=$Xb.Yl(a,2);for(d=0;d<b.q;d++){b.C[d]!=0?e[d]=$Xb.jk(b,a,d,g,h):e[d]=c;}for(f=0;f<b.r;f++){$Xb.kk(b,a,f,g,h,e[b.D[0][f]],e[b.D[1][f]],false);}a.L=a.L&&b.L;a.I=0;a.T=0;return e;};$Xb.dk=function dk(a,b){var c,d,e,f,g,h,i,j,k;c=a.J[b[0]];d=a.J[b[1]];e=a.J[b[2]];f=a.J[b[3]];i=new $Xb.Sh(d.a-c.a,d.b-c.b,d.c-c.c);j=new $Xb.Sh(e.a-d.a,e.b-d.b,e.c-d.c);k=new $Xb.Sh(f.a-e.a,f.b-e.b,f.c-e.c);g=new $Xb.Sh(i.b*j.c-i.c*j.b,-(i.a*j.c-i.c*j.a),i.a*j.b-i.b*j.a);h=new $Xb.Sh(j.b*k.c-j.c*k.b,-(j.a*k.c-j.c*k.a),j.a*k.b-j.b*k.a);return -$wnd.Math.atan2($wnd.Math.sqrt(j.a*j.a+j.b*j.b+j.c*j.c)*(i.a*h.a+i.b*h.b+i.c*h.c),g.a*h.a+g.b*h.b+g.c*h.c);};$Xb.ek=function ek(a,b,c,d,e,f){if((c==1||c==151||c==152)&&$Xb.ko(a,b)>1)return false;a.B[b]=Jwb(a.B[b],-2);a.v!=null&&(a.v[b]=null);a.t!=null&&(a.t[b]=null);if(c==a.C[b]&&d==a.A[b]&&e==((a.u[b]&g_b)>>>27)-1&&f==(a.u[b]&48))return false;if(c==151||c==152){d=c-149;c=1;}a.u[b]&=960;a.C[b]=c;a.A[b]=d;a.s[b]=0;a.B[b]=0;$Xb.am(a,b,e);$Xb.pm(a,b,f);$Xb.Wl(a,a.w[b]);a.T=0;return true;};$Xb.fk=function fk(a,b,c){if(c){if(a.s[b]>8)return false;++a.s[b];}else {if(a.s[b]<-8)return false;--a.s[b];}a.T=0;return true;};$Xb.gk=function gk(a,b,c){var d,e,f,g,h;f=false;g=a.H[b];if(c==511){f=$Xb.nl(a,b);}else if($Xb.np(a,b,c)){if(c==257||c==129){d=$Xb.Rl(a,b,a.D[0][b]);e=$Xb.Rl(a,b,a.D[1][b]);if(c==g){if(d==e||e){h=a.D[0][b];a.D[0][b]=a.D[1][b];a.D[1][b]=h;f=true;}}else {if(!d&&e){h=a.D[0][b];a.D[0][b]=a.D[1][b];a.D[1][b]=h;}a.H[b]=c;f=true;}}else {a.H[b]=c;f=true;}}if(f){a.T=(g&127)==(c&127)?a.T&7:0;a.G[b]=0;}return f;};$Xb.hk=function hk(a){a.q=0;a.r=0;a.K=false;a.L=false;a.I=0;a.v=null;a.t=null;a.P=null;a.T=0;};$Xb.ik=function ik(a){var b,c,d,e,f,g,h,i;for(g=0;g<a.r;g++){if(a.H[g]==512){c=a.D[0][g];d=a.D[1][g];if(a.C[c]==-1^a.C[d]==-1){if(a.s[c]!=0&&a.s[d]!=0){if(a.s[c]<0^a.s[d]<0){if(a.s[c]<0){++a.s[c];--a.s[d];}else {--a.s[c];++a.s[d];}}}}}}i=Sjb(UXb.llb,yZb,6,a.q,15,1);e=0;for(b=0;b<a.q;b++){if(a.C[b]==-1){i[b]=-1;continue;}if(e<b){a.C[e]=a.C[b];a.s[e]=a.s[b];a.A[e]=a.A[b];a.u[e]=a.u[b];a.B[e]=a.B[b];a.w[e]=a.w[b];$Xb.Nh(a.J[e],a.J[b]);a.v!=null&&(a.v[e]=a.v[b]);a.t!=null&&(a.t[e]=a.t[b]);}i[b]=e;++e;}a.q=e;h=0;for(f=0;f<a.r;f++){if(a.H[f]==512)continue;a.H[h]=a.H[f];a.F[h]=a.F[f];a.G[h]=a.G[f];a.D[0][h]=i[a.D[0][f]];a.D[1][h]=i[a.D[1][f]];++h;}a.r=h;return i;};$Xb.jk=function jk(a,b,c,d,e){var f,g,h;f=b.q;f>=b.M&&$Xb.Km(b,b.M*2);h=(a.u[c]&E$b)>>18;g=-1;h==1?d==-1?g=$Xb.Yl(b,h):g=$wnd.Math.min(31,d+((a.u[c]&E$b)>>18!=1&&(a.u[c]&E$b)>>18!=2?-1:(a.u[c]&h_b)>>20)):h==2&&(e==-1?g=$Xb.Yl(b,h):g=$wnd.Math.min(31,e+((a.u[c]&E$b)>>18!=1&&(a.u[c]&E$b)>>18!=2?-1:(a.u[c]&h_b)>>20)));b.C[f]=a.C[c];b.s[f]=a.s[c];b.A[f]=a.A[c];b.u[f]=a.u[c];b.B[f]=b.K?a.B[c]:0;$Xb.Nh(b.J[f],a.J[c]);b.w[f]=a.w[c];b.v!=null&&(b.v[f]=null);if(a.v!=null&&a.v[c]!=null&&b.K){b.v==null&&(b.v=Sjb(UXb.llb,Q$b,8,b.C.length,0,2));b.v[f]=_Xb.xOb(a.v[c],a.v[c].length);}b.t!=null&&(b.t[f]=null);if(a.t!=null&&a.t[c]!=null){b.t==null&&(b.t=Sjb(UXb.hlb,aZb,10,b.C.length,0,2));b.t[f]=_Xb.vOb(a.t[c],a.t[c].length);}if(g!=-1){b.u[f]&=-32505857;b.u[f]|=g<<20;}++b.q;b.T=0;return f;};$Xb.kk=function kk(a,b,c,d,e,f,g,h){var i,j,k,l;j=b.r;j>=b.N&&$Xb.Lm(b,b.N*2);l=(a.F[c]&768)>>8;k=-1;l==1&&(d==-1?k=$Xb.Yl(b,l):k=$wnd.Math.min(32,d+((a.F[c]&768)>>8!=1&&(a.F[c]&768)>>8!=2?-1:(a.F[c]&i_b)>>10)));l==2&&(e==-1?k=$Xb.Yl(b,l):k=$wnd.Math.min(32,e+((a.F[c]&768)>>8!=1&&(a.F[c]&768)>>8!=2?-1:(a.F[c]&i_b)>>10)));b.D[0][j]=f;b.D[1][j]=g;i=h&&a.Lb(c)?64:a.H[c];b.H[j]=i;b.F[j]=a.F[c];b.G[j]=b.K?a.G[c]:0;if(k!=-1){b.F[j]&=-31745;b.F[j]|=k<<10;}++b.r;b.T=0;return j;};$Xb.lk=function lk(a,b,c,d,e,f,g){return $Xb.kk(a,b,c,d,e,f==null?a.D[0][c]:f[a.D[0][c]],f==null?a.D[1][c]:f[a.D[1][c]],g);};$Xb.mk=function mk(a,b){var c,d;b.v=null;b.t=null;b.K=a.K;b.q=0;for(c=0;c<a.q;c++)$Xb.jk(a,b,c,0,0);b.r=0;for(d=0;d<a.r;d++)$Xb.kk(a,b,d,0,0,a.D[0][d],a.D[1][d],false);a.Kb(b);};$Xb.nk=function nk(a,b){b.K=a.K;b.L=a.L;b.S=a.S;b.I=a.I;b.P=a.P;b.T=a.T&24;};$Xb.ok=function ok(a,b){var c,d,e,f;for(c=0;c<a.r;c++){for(e=0;e<2;e++){if(a.D[e][c]==b){a.H[c]=512;d=0;for(f=0;f<a.r;f++){if(f==c)continue;(a.D[0][f]===a.D[1-e][c]||a.D[1][f]===a.D[1-e][c])&&++d;}if(d==0){$Xb.Wl(a,a.w[a.D[1-e][c]]);a.C[a.D[1-e][c]]=-1;}}}}$Xb.Wl(a,a.w[b]);a.C[b]=-1;a.v!=null&&(a.v[b]=null);a.t!=null&&(a.t[b]=null);$Xb.ik(a);a.T=0;};$Xb.pk=function pk(a,b,c){var d,e;d=$Xb.vk(a,b,c);if(d!=-1){(a.u[d]&512)!=0?$Xb.uk(a):$Xb.ok(a,d);a.T=0;return true;}e=$Xb.wk(a,b,c);if(e!=-1){(a.u[a.D[0][e]]&a.u[a.D[1][e]]&512)!=0?$Xb.uk(a):$Xb.sk(a,e);a.T=0;return true;}return false;};$Xb.qk=function qk(a,b){var c,d,e,f;if(b.length==0)return null;for(d=b,e=0,f=d.length;e<f;++e){c=d[e];a.C[c]=-1;}return $Xb.tk(a);};$Xb.rk=function rk(a,b){a.H[b]=512;$Xb.ik(a);a.T=0;};$Xb.sk=function sk(a,b){var c,d,e;for(d=0;d<2;d++){c=0;for(e=0;e<a.r;e++){if(e==b)continue;(a.D[0][e]===a.D[d][b]||a.D[1][e]===a.D[d][b])&&++c;}if(c==0){$Xb.Wl(a,a.w[a.D[d][b]]);a.C[a.D[d][b]]=-1;}}a.H[b]=512;$Xb.ik(a);a.T=0;};$Xb.tk=function tk(a){var b,c,d;d=false;for(b=0;b<a.q;b++){if(a.C[b]==-1){d=true;$Xb.Wl(a,a.w[b]);}}for(c=0;c<a.r;c++){if(a.H[c]==512){d=true;}else if(a.C[a.D[0][c]]==-1||a.C[a.D[1][c]]==-1){a.H[c]=512;d=true;}}if(d){a.T=0;return $Xb.ik(a);}return null;};$Xb.uk=function uk(a){var b,c;c=false;for(b=0;b<a.q;b++){if((a.u[b]&512)!=0){a.C[b]=-1;c=true;}}return c&&$Xb.tk(a)!=null;};$Xb.vk=function vk(a,b,c){var d,e,f,g,h,i,j,k;g=-1;e=$Xb.Sk(a,a.q,a.r,$Xb.Rj);h=_$b;i=e*e/12;for(d=0;d<a.q;d++){j=a.J[d].a;k=a.J[d].b;f=(b-j)*(b-j)+(c-k)*(c-k);if(f<i&&f<h){h=f;g=d;}}return g;};$Xb.wk=function wk(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s;m=-1;o=$Xb.Sk(a,a.q,a.r,$Xb.Rj);n=_$b;for(d=0;d<a.r;d++){p=a.J[a.D[0][d]].a;r=a.J[a.D[0][d]].b;q=a.J[a.D[1][d]].a;s=a.J[a.D[1][d]].b;k=q-p;l=s-r;e=$wnd.Math.sqrt(k*k+l*l);f=(p+q)/2;g=(r+s)/2;k=b-f;l=c-g;if($wnd.Math.sqrt(k*k+l*l)>e/2)continue;if(q==p)j=$wnd.Math.abs(p-b);else {h=(s-r)/(p-q);i=-h*p-r;j=$wnd.Math.abs((h*b+c+i)/$wnd.Math.sqrt(h*h+1));}if(j<o&&j<n){n=j;m=d;}}return m;};$Xb.xk=function xk(a,b){return ((a.u[b]&g_b)>>>27)-1;};$Xb.yk=function yk(a,b){return (a.u[b]&49152)>>14;};$Xb.zk=function zk(a,b){return a.s[b];};$Xb.Ak=function Ak(a,b){return a.u[b]&448;};$Xb.Bk=function Bk(a,b){return a.t==null?null:a.t[b]==null?null:VXb.BHb(a.t[b]);};$Xb.Ck=function Ck(a,b){return a.t==null?null:a.t[b];};$Xb.Dk=function Dk(a,b){return (a.u[b]&E$b)>>18!=1&&(a.u[b]&E$b)>>18!=2?-1:(a.u[b]&h_b)>>20;};$Xb.Ek=function Ek(a,b){return (a.u[b]&E$b)>>18;};$Xb.Fk=function Fk(a,b){return $Xb.Mj[a.C[b]];};$Xb.Gk=function Gk(a,b){return a.v==null?null:a.v[b];};$Xb.Hk=function Hk(a,b){var c,d,e;if(a.v==null||a.v[b]==null)return cxb(Jwb(a.B[b],1),0)?'':$Xb.Mj[a.C[b]];e='';for(d=0;d<a.v[b].length;d++){d>0&&(e=(YXb.ATb(e),e+(YXb.ATb(','),',')));c=a.v[b][d];e=VXb.AHb(e,$Xb.Mj[c]);}return e;};$Xb.Ik=function Ik(a,b){return $wnd.Math.abs(a.w[b]);};$Xb.Jk=function Jk(a,b){return a.A[b];};$Xb.Kk=function Kk(a,b){return a.u[b]&3;};$Xb.Lk=function Lk(a,b){return a.B[b];};$Xb.Mk=function Mk(a,b){return a.u[b]&48;};$Xb.Nk=function Nk(a,b){return a.J[b].a;};$Xb.Ok=function Ok(a,b){return a.J[b].b;};$Xb.Pk=function Pk(a,b){return a.J[b].c;};$Xb.Qk=function Qk(a,b){return a.C[b];};$Xb.Rk=function Rk(a){return $Xb.Sk(a,a.q,a.r,$Xb.Rj);};$Xb.Sk=function Sk(a,b,c,d){return $Xb.Tk(a,b,c,d,a.J);};$Xb.Tk=function Tk(a,b,c,d,e){var f,g,h,i,j,k,l,m,n,o;l=false;m=0;for(j=0;j<c;j++)a.H[j]!=32&&(a.G[j]&z$b)==0&&++m;if(m==0){for(k=0;k<c;k++)(a.G[k]&z$b)==0&&++m;l=true;}if(m==0){if(b<2)return d;o=_$b;for(f=1;f<b;f++){for(g=0;g<f;g++){n=$Xb.Hh(e[f],e[g]);n>0&&n<o&&(o=n);}}return o!=_$b?0.6*o:d;}h=0;for(i=0;i<c;i++){(l||a.H[i]!=32)&&(a.G[i]&z$b)==0&&(h+=$Xb.Hh(e[a.D[1][i]],e[a.D[0][i]]));}return h/m;};$Xb.Uk=function Uk(a,b,c){return $Xb.fn(a.J[b].a,a.J[b].b,a.J[c].a,a.J[c].b);};$Xb.Vk=function Vk(a,b,c){return a.D[b][c];};$Xb.Wk=function Wk(a,b){return ((a.G[b]&7680)>>9)+((a.G[b]&122880)>>13);};$Xb.Xk=function Xk(a,b){return (a.G[b]&7680)>>9;};$Xb.Yk=function Yk(a,b){return (a.F[b]&48)>>4;};$Xb.Zk=function Zk(a,b){return (a.F[b]&768)>>8!=1&&(a.F[b]&768)>>8!=2?-1:(a.F[b]&i_b)>>10;};$Xb.$k=function $k(a,b){return (a.F[b]&768)>>8;};$Xb._k=function _k(a,b){var c,d,e,f;c=a.D[0][b];d=a.D[1][b];e=a.J[d].a-a.J[c].a;f=a.J[d].b-a.J[c].b;return $wnd.Math.sqrt(e*e+f*f);};$Xb.al=function al(a,b,c){var d;for(d=0;d<a.r;d++)if(a.D[0][d]==b&&a.D[1][d]==c||a.D[0][d]==c&&a.D[1][d]==b)if(a.H[d]!=512)return d;return -1;};$Xb.bl=function bl(a,b){switch(a.H[b]&127){case 1:case 64:return 1;case 2:return 2;case 4:return 3;case 8:return 4;case 16:return 5;default:return 0;}};$Xb.cl=function cl(a,b){return a.F[b]&3;};$Xb.dl=function dl(a,b){return a.G[b];};$Xb.el=function el(a,b){return a.H[b];};$Xb.fl=function fl(a,b){return a.H[b]&127;};$Xb.gl=function gl(a,b){var c,d,e,f,g;if(a.q==0)return null;d=a.J[0].a;f=a.J[0].b;e=a.J[0].a;g=a.J[0].b;for(c=1;c<a.q;c++){d>a.J[c].a?d=a.J[c].a:e<a.J[c].a&&(e=a.J[c].a);f>a.J[c].b?f=a.J[c].b:g<a.J[c].b&&(g=a.J[c].b);}if(!b){b=new lYb.KG(d,f,e-d,g-f);}else {b.c=d;b.d=f;b.b=e-d;b.a=g-f;}return b;};$Xb.hl=function hl(a,b){var c;c=a.C[b]<$Xb.Nj.length?$Xb.Nj[a.C[b]]:null;return c==null?6:c[c.length-1];};$Xb.il=function il(a,b,c){var d,e;if(a.C[b]>=171&&a.C[b]<=190)return 0;e=0;(a.u[b]&48)==32&&(e-=1);((a.u[b]&48)==16||(a.u[b]&48)==48)&&(e-=2);d=a.s[b];if(d==0&&a.K){Twb(Jwb(a.B[b],YZb),_Zb)&&(d=-1);Twb(Jwb(a.B[b],YZb),$Zb)&&(d=1);}a.C[b]==7||a.C[b]==8||a.C[b]==9?e+=d:a.C[b]==6||a.C[b]==14||a.C[b]==32?e-=$wnd.Math.abs(d):a.C[b]==15||a.C[b]==33?c-e-d<=3?e+=d:e-=d:a.C[b]==16||a.C[b]==34||a.C[b]==52?c-e-d<=4?e+=d:e-=$wnd.Math.abs(d):a.C[b]==17||a.C[b]==35||a.C[b]==53?c-e-d<=5?e+=d:e-=$wnd.Math.abs(d):e-=d;return e;};$Xb.jl=function jl(a,b){var c;c=$Xb.kl(a,b);return c+$Xb.il(a,b,c);};$Xb.kl=function kl(a,b){var c,d;c=((a.u[b]&g_b)>>>27)-1;c==-1&&(c=(d=a.C[b]<$Xb.Nj.length?$Xb.Nj[a.C[b]]:null,d==null?6:d[d.length-1]));return c;};$Xb.ll=function ll(a,b){var c,d,e,f,g;f=$Xb.Nl(a,a.D[0][b])||$Xb.Nl(a,a.D[1][b])?5:3;for(d=0;d<2;d++){c=a.D[d][b];e=$Xb.bl(a,b)+(g=$Xb.kl(a,c),g+$Xb.il(a,c,g))-$Xb.ko(a,c);f>e&&(f=e);}return f;};$Xb.ml=function ml(a,b){return (a.u[b]&oZb)!=0;};$Xb.nl=function nl(a,b){var c,d,e;d=$Xb.ll(a,b);c=$Xb.Fl(a,a.D[0][b])||$Xb.Fl(a,a.D[1][b]);e=c?32:1;if(a.H[b]==16){a.H[b]=e;a.T=0;return true;}if(a.H[b]==8){a.H[b]=d>4?16:e;a.T=0;return true;}if(a.H[b]==4){a.H[b]=d>3?8:e;a.T=0;return true;}if(a.H[b]==2){a.H[b]=386;a.T&=7;if((a.F[b]&128)==0)return true;}if(a.H[b]==386){d>2?a.H[b]=4:a.H[b]=e;a.T=0;return true;}if((384&a.H[b])!=0){a.H[b]=1;a.T&=7;return true;}if(!c&&d<2)return false;if(a.H[b]==1){a.H[b]=2;a.T=0;return true;}if(d<1)return false;if(a.H[b]==32){a.H[b]=1;a.T=0;return true;}return false;};$Xb.ol=function ol(a){var b;a.T=0;a.C=Sjb(UXb.llb,yZb,6,a.M,15,1);a.s=Sjb(UXb.llb,yZb,6,a.M,15,1);a.w=Sjb(UXb.llb,yZb,6,a.M,15,1);a.J=Sjb(UXb.Elb,j_b,32,a.M,0,1);for(b=0;b<a.M;b++)a.J[b]=new $Xb.Rh();a.A=Sjb(UXb.llb,yZb,6,a.M,15,1);a.u=Sjb(UXb.llb,yZb,6,a.M,15,1);a.B=Sjb(UXb.mlb,N$b,6,a.M,14,1);a.v=null;a.t=null;a.D=Qjb(UXb.llb,[Q$b,yZb],[8,6],15,[2,a.N],2);a.H=Sjb(UXb.llb,yZb,6,a.N,15,1);a.F=Sjb(UXb.llb,yZb,6,a.N,15,1);a.G=Sjb(UXb.llb,yZb,6,a.N,15,1);};$Xb.pl=function pl(a,b){a.T&=~b;};$Xb.ql=function ql(a){var b;for(b=0;b<a.q;b++)if(a.J[b].c!=0)return true;return false;};$Xb.rl=function rl(a,b){return (a.u[b]&k_b)!=0;};$Xb.sl=function sl(a,b){return a.C[b]==-1;};$Xb.tl=function tl(a,b){return (a.u[b]&4)!=0;};$Xb.ul=function ul(a,b){return (a.u[b]&l_b)!=0;};$Xb.vl=function vl(a,b){return a.w[b]<0;};$Xb.wl=function wl(a,b){return (a.F[b]&m_b)!=0;};$Xb.xl=function xl(a,b){return (a.G[b]&z$b)!=0;};$Xb.yl=function yl(a,b){return (a.F[b]&oZb)!=0;};$Xb.zl=function zl(a,b){return a.H[b]==512;};$Xb.Al=function Al(a,b){return (a.F[b]&4)!=0;};$Xb.Bl=function Bl(a,b){return (a.F[b]&T$b)!=0;};$Xb.Cl=function Cl(a,b){var c,d,e,f;if(a.K){if(cxb(Jwb(a.B[b],1),0))return false;if(a.v!=null&&a.v[b]!=null)for(d=a.v[b],e=0,f=d.length;e<f;++e){c=d[e];if(!$Xb.jn(c))return false;}}return $Xb.jn(a.C[b]);};$Xb.Dl=function Dl(a,b){var c,d,e,f;if(a.K){if(cxb(Jwb(a.B[b],1),0))return false;if(a.v!=null&&a.v[b]!=null)for(d=a.v[b],e=0,f=d.length;e<f;++e){c=d[e];if(!$Xb.kn(c))return false;}}return $Xb.kn(a.C[b]);};$Xb.El=function El(a,b){return (a.u[b]&T$b)!=0;};$Xb.Fl=function Fl(a,b){var c,d,e,f;if(a.K){if(cxb(Jwb(a.B[b],1),0))return false;if(a.v!=null&&a.v[b]!=null)for(d=a.v[b],e=0,f=d.length;e<f;++e){c=d[e];if(!(c>=3&&c<=4||c>=11&&c<=13||c>=19&&c<=31||c>=37&&c<=51||c>=55&&c<=84||c>=87&&c<=103))return false;}}return $Xb.ln(a.C[b]);};$Xb.Gl=function Gl(a,b){return a.A[b]==0;};$Xb.Hl=function Hl(a,b){var c,d,e,f;if(a.K){if(cxb(Jwb(a.B[b],1),0))return false;if(a.v!=null&&a.v[b]!=null)for(d=a.v[b],e=0,f=d.length;e<f;++e){c=d[e];if(!(c==1||c>=5&&c<=9||c>=14&&c<=17||c>=32&&c<=35||c>=52&&c<=53))return false;}}return $Xb.mn(a.C[b]);};$Xb.Il=function Il(a){var b;for(b=0;b<a.q;b++){switch(a.C[b]){case 1:case 5:case 6:case 7:case 8:case 9:case 14:case 15:case 16:case 17:case 33:case 34:case 35:case 52:case 53:continue;default:return false;}}return true;};$Xb.Jl=function Jl(a,b){return (a.u[b]&512)!=0;};$Xb.Kl=function Kl(a,b){return (a.u[a.D[0][b]]&a.u[a.D[1][b]]&512)!=0;};$Xb.Ll=function Ll(a,b){return a.H[b]==257||a.H[b]==129;};$Xb.Ml=function Ml(a,b,c){return (a.H[b]==257||a.H[b]==129)&&a.D[0][b]==c;};$Xb.Nl=function Nl(a,b){var c,d,e,f;if(a.K){if(cxb(Jwb(a.B[b],1),0))return false;if(a.v!=null&&a.v[b]!=null)for(d=a.v[b],e=0,f=d.length;e<f;++e){c=d[e];if(!(c>=3&&c<=4||c>=11&&c<=13||c>=19&&c<=31||c>=37&&c<=51||c>=55&&c<=84||c>=87&&c<=103))return false;}}return $Xb.nn(a.C[b]);};$Xb.Ol=function Ol(a,b){a.C[b]=-1;};$Xb.Pl=function Pl(a,b){a.H[b]=512;};$Xb.Ql=function Ql(a,b,c,d,e,f,g,h){var i,j,k,l,m,n,o,p,q,r;if(b!=d){q=a.J[b].a-a.J[d].a;r=a.J[b].b-a.J[d].b;h=$wnd.Math.sqrt(q*q+r*r);}i=b;k=$Xb.Pm(a,b)!=3;for(p=1;p<c;p++){m=a.J[i].a+h*$wnd.Math.sin(f);n=a.J[i].b+h*$wnd.Math.cos(f);o=-1;for(l=0;l<a.q;l++){if($wnd.Math.abs(m-a.J[l].a)<4&&$wnd.Math.abs(n-a.J[l].b)<4){o=l;break;}}if(o==-1){o=$Xb.Tj(a,m,n,0);a.J[o].a=m;a.J[o].b=n;a.J[o].c=0;}j=$Xb.al(a,i,o);if(j==-1){j=$Xb.Wj(a,i,o,$Xb.Fl(a,i)||$Xb.Fl(a,o)?32:1);if(e){k&&$Xb.Pm(a,a.D[0][j])<4&&$Xb.Pm(a,a.D[1][j])<3&&(a.H[j]=2);k=!k;}}i=o;f+=g;}j=$Xb.al(a,i,d);j==-1&&(j=$Xb.Wj(a,i,d,$Xb.Fl(a,i)||$Xb.Fl(a,d)?32:1));e&&k&&$Xb.Pm(a,a.D[0][j])<4&&$Xb.Pm(a,a.D[1][j])<4&&(a.H[j]=2);};$Xb.Rl=function Rl(a,b,c){var d,e;if($Xb.bl(a,b)!=1)return false;if((a.u[c]&3)!=0)return true;for(e=0;e<a.r;e++)if(e!=b&&a.H[e]==2&&(a.D[0][e]==c&&(a.u[a.D[1][e]]&3)!=0||a.D[1][e]==c&&(a.u[a.D[0][e]]&3)!=0))return true;for(d=0;d<a.r;d++)if(d!=b&&a.H[d]==1&&(a.D[0][d]==c||a.D[1][d]==c)&&(a.F[d]&3)!=0)return true;return false;};$Xb.Sl=function Sl(a){var b;for(b=0;b<a.q;b++)a.u[b]&=-449;};$Xb.Tl=function Tl(a){var b;for(b=0;b<a.q;b++)a.u[b]&=-131073;};$Xb.Ul=function Ul(a){var b;for(b=0;b<a.q;b++)a.u[b]&=-513;};$Xb.Vl=function Vl(a){var b;for(b=0;b<a.r;b++)a.F[b]&=-98305;};$Xb.Wl=function Wl(a,b){var c;for(c=0;c<a.q;c++)$wnd.Math.abs(a.w[c])==$wnd.Math.abs(b)&&(a.w[c]=0);};$Xb.Xl=function Xl(a){var b,c,d,e;e=false;for(c=0;c<a.q;c++){if(cxb(Jwb(a.B[c],LZb),0)){a.C[c]=-1;e=true;}}e&&$Xb.tk(a);if(a.v!=null){a.v=null;e=true;}for(b=0;b<a.q;b++){if(cxb(a.B[b],0)){a.B[b]=0;e=true;}}for(d=0;d<a.r;d++){if(a.G[d]!=0){a.G[d]=0;e=true;}if(a.H[d]==64){a.H[d]=1;e=true;}}e&&(a.T=0);return e;};$Xb.Yl=function Yl(a,b){var c,d,e,f,g,h,i,j,k;if(b==0)return 0;h=null;for(d=0;d<a.q;d++){if((a.u[d]&E$b)>>18==b){h==null&&(h=Sjb(UXb.Cwb,KZb,6,32,16,1));h[(a.u[d]&E$b)>>18!=1&&(a.u[d]&E$b)>>18!=2?-1:(a.u[d]&h_b)>>20]=true;}}for(f=0;f<a.r;f++){if((a.F[f]&768)>>8==b){h==null&&(h=Sjb(UXb.Cwb,KZb,6,32,16,1));h[(a.F[f]&768)>>8!=1&&(a.F[f]&768)>>8!=2?-1:(a.F[f]&i_b)>>10]=true;}}k=0;if(h!=null){j=Sjb(UXb.llb,yZb,6,32,15,1);for(i=0;i<32;i++)h[i]&&(j[i]=k++);for(c=0;c<a.q;c++){if((a.u[c]&E$b)>>18==b){g=j[(a.u[c]&E$b)>>18!=1&&(a.u[c]&E$b)>>18!=2?-1:(a.u[c]&h_b)>>20];a.u[c]&=-32505857;a.u[c]|=g<<20;}}for(e=0;e<a.r;e++){if((a.F[e]&768)>>8==b){g=j[(a.F[e]&768)>>8!=1&&(a.F[e]&768)>>8!=2?-1:(a.F[e]&i_b)>>10];a.F[e]&=-31745;a.F[e]|=g<<10;}}}return k;};$Xb.Zl=function Zl(a,b){var c;for(c=0;c<a.q;c++){a.J[c].a*=b;a.J[c].b*=b;}};$Xb.$l=function $l(a,b){a.q=b;a.T=0;};$Xb._l=function _l(a,b){a.r=b;a.T=0;};$Xb.am=function am(a,b,c){if(c>=-1&&c<=14){a.u[b]&=-2013265921;a.u[b]|=1+c<<27;if(a.C[b]==6){if(c==-1||c==0||c==2||c==4){a.u[b]&=-49;c==2&&(a.u[b]|=16);}}}};$Xb.bm=function bm(a,b,c){a.u[b]&=-49153;a.u[b]|=c<<14;};$Xb.cm=function cm(a,b,c){a.s[b]=c;a.T=0;};$Xb.dm=function dm(a,b,c){a.u[b]&=-449;a.u[b]|=c;};$Xb.em=function em(a,b,c){c?a.u[b]|=k_b:a.u[b]&=n_b;a.T&=7;};$Xb.fm=function fm(a,b,c){var d,e;if(c!=null){if(YXb.LTb(c).length==0)c=null;else {d=$Xb.hn(c,321);if(d!=0&&VXb.DHb(c,$Xb.Mj[d])||VXb.DHb(c,'?')){$Xb.vm(a,b,d);c=null;}}}if(c==null){a.t!=null&&(a.t[b]=null);}else {a.t==null&&(a.t=Sjb(UXb.hlb,aZb,10,a.M,0,2));a.t[b]=YXb.mTb((e=c,YXb.hTb(),e));}};$Xb.gm=function gm(a,b,c){c!=null&&c.length==0&&(c=null);if(c==null){a.t!=null&&(a.t[b]=null);}else {a.t==null&&(a.t=Sjb(UXb.hlb,aZb,10,a.M,0,2));a.t[b]=c;}};$Xb.hm=function hm(a,b,c,d){var e,f,g;if(c==0){a.u[b]&=o_b;a.u[b]|=c<<18;}else {if(d>=32)return;if(d==-1){g=-1;for(f=0;f<a.q;f++)f!=b&&c==(a.u[f]&E$b)>>18&&g<((a.u[f]&E$b)>>18!=1&&(a.u[f]&E$b)>>18!=2?-1:(a.u[f]&h_b)>>20)&&(g=(a.u[f]&E$b)>>18!=1&&(a.u[f]&E$b)>>18!=2?-1:(a.u[f]&h_b)>>20);for(e=0;e<a.r;e++)c==(a.F[e]&768)>>8&&g<((a.F[e]&768)>>8!=1&&(a.F[e]&768)>>8!=2?-1:(a.F[e]&i_b)>>10)&&(g=(a.F[e]&768)>>8!=1&&(a.F[e]&768)>>8!=2?-1:(a.F[e]&i_b)>>10);d=g+1;if(d>=32)return;}a.u[b]&=o_b;a.u[b]|=c<<18|d<<20;}a.T&=7;};$Xb.im=function im(a,b,c){a.v==null&&(a.v=Sjb(UXb.llb,Q$b,8,a.M,0,2));YXb.fTb(c,YXb.LTb(Axb(_Xb.ZOb.prototype.Zd,_Xb.ZOb,[])));a.v[b]=c;a.T=0;a.K=true;};$Xb.jm=function jm(a,b,c,d){var e;if(c==null){a.v!=null&&(a.v[b]=null);return;}if(c.length==1&&!d){e=c[0];a.C[b]!=e&&$Xb.ek(a,b,e,0,-1,0);a.v!=null&&(a.v[b]=null);return;}a.v==null&&(a.v=Sjb(UXb.llb,Q$b,8,a.M,0,2));a.v[b]=c;d&&(a.B[b]=exb(a.B[b],1));a.T=0;a.K=true;};$Xb.km=function km(a,b,c,d){a.w[b]=d?-c:c;};$Xb.lm=function lm(a,b,c){c?a.u[b]|=T$b:a.u[b]&=-131073;};$Xb.mm=function mm(a,b,c){a.A[b]=c;a.T&=7;};$Xb.nm=function nm(a,b,c,d){a.u[b]&=-33554440;a.u[b]|=c;d&&(a.u[b]|=4);};$Xb.om=function om(a,b,c,d){d?a.B[b]=exb(a.B[b],c):a.B[b]=Jwb(a.B[b],dxb(c));a.T=0;a.K=true;};$Xb.pm=function pm(a,b,c){a.u[b]&=-49;a.u[b]|=c;a.T&=7;};$Xb.qm=function qm(a,b,c){c?a.u[b]|=512:a.u[b]&=-513;};$Xb.rm=function rm(a,b,c){a.u[b]&=-67108865;c&&(a.u[b]|=l_b);};$Xb.sm=function sm(a,b,c){a.J[b].a=c;a.T&=7;};$Xb.tm=function tm(a,b,c){a.J[b].b=c;a.T&=7;};$Xb.um=function um(a,b,c){a.J[b].c=c;a.T&=7;};$Xb.vm=function vm(a,b,c){if(c>=0&&c<=190){if(c==151||c==152){a.C[b]=1;a.A[b]=c-149;}else {a.C[b]=c;a.A[b]=0;}a.u[b]&=-2013265921;a.T=0;}};$Xb.wm=function wm(a,b,c,d){a.D[b][c]=d;a.T=0;};$Xb.xm=function xm(a,b,c){c?a.F[b]|=m_b:a.F[b]&=-32769;};$Xb.ym=function ym(a,b,c){a.F[b]&=-49;a.F[b]|=c<<4;};$Xb.zm=function zm(a,b,c,d){var e,f,g;if(c==0){a.F[b]&=-32513;a.F[b]|=c<<8;}else {if(d>=32)return;if(d==-1){g=-1;for(f=0;f<a.q;f++)c==(a.u[f]&E$b)>>18&&g<((a.u[f]&E$b)>>18!=1&&(a.u[f]&E$b)>>18!=2?-1:(a.u[f]&h_b)>>20)&&(g=(a.u[f]&E$b)>>18!=1&&(a.u[f]&E$b)>>18!=2?-1:(a.u[f]&h_b)>>20);for(e=0;e<a.r;e++)e!=b&&c==(a.F[e]&768)>>8&&g<((a.F[e]&768)>>8!=1&&(a.F[e]&768)>>8!=2?-1:(a.F[e]&i_b)>>10)&&(g=(a.F[e]&768)>>8!=1&&(a.F[e]&768)>>8!=2?-1:(a.F[e]&i_b)>>10);d=g+1;if(d>=32)return;}a.F[b]&=-32513;a.F[b]|=c<<8|d<<10;}a.T&=7;};$Xb.Am=function Am(a,b,c){c?a.F[b]|=oZb:a.F[b]&=-65537;};$Xb.Bm=function Bm(a,b,c){a.H[b]=c==1?1:c==2?2:c==3?4:32;a.T=0;};$Xb.Cm=function Cm(a,b,c,d){a.F[b]&=-131080;a.F[b]|=c;d&&(a.F[b]|=4);};$Xb.Dm=function Dm(a,b){a.F[b]|=T$b;};$Xb.Em=function Em(a,b,c,d){d?a.G[b]|=c:a.G[b]&=~c;a.T=0;a.K=true;};$Xb.Fm=function Fm(a,b,c){a.H[b]=c;a.T=0;};$Xb.Gm=function Gm(a,b){a.I=b;};$Xb.Hm=function Hm(a,b){if(a.K!=b){a.K=b;b||$Xb.Xl(a);a.T=0;}};$Xb.Im=function Im(a,b){a.T=b;};$Xb.Jm=function Jm(a,b){a.S=b;};$Xb.Km=function Km(a,b){var c,d;a.C=$Xb._m(a.C,b);a.s=$Xb._m(a.s,b);a.w=$Xb._m(a.w,b);d=a.J.length;a.J=$Xb.bn(a.J,b);for(c=d;c<b;c++)a.J[c]=new $Xb.Rh();a.A=$Xb._m(a.A,b);a.u=$Xb._m(a.u,b);a.B=$Xb.an(a.B,b);a.v!=null&&(a.v=$Xb.dn(a.v,b));a.t!=null&&(a.t=$Xb.cn(a.t,b));a.M=b;};$Xb.Lm=function Lm(a,b){a.D[0]=$Xb._m(a.D[0],b);a.D[1]=$Xb._m(a.D[1],b);a.H=$Xb._m(a.H,b);a.F=$Xb._m(a.F,b);a.G=$Xb._m(a.G,b);a.N=b;};$Xb.Mm=function Mm(a,b){a.O=b;};$Xb.Nm=function Nm(a,b){a.P=b;};$Xb.Om=function Om(a,b){a.u[b]|=oZb;};$Xb.Pm=function Pm(a,b){var c,d;d=0;for(c=0;c<a.r;c++)(a.D[0][c]==b||a.D[1][c]==b)&&(d+=$Xb.bl(a,c));return d;};$Xb.Qm=function Qm(a){var b,c,d;c=false;d=false;for(b=0;b<a.q;b++){if(a.A[b]!=0){a.A[b]=0;c=true;a.C[b]==1&&(d=true);}}d&&(a.T=0);return c;};$Xb.Rm=function Rm(a,b,c){return $Xb.Fl(a,b)||$Xb.Fl(a,c)?32:1;};$Xb.Sm=function Sm(a,b,c){var d,e,f,g,h,i;g=a.C[b];a.C[b]=a.C[c];a.C[c]=g;g=a.s[b];a.s[b]=a.s[c];a.s[c]=g;g=a.A[b];a.A[b]=a.A[c];a.A[c]=g;g=a.u[b];a.u[b]=a.u[c];a.u[c]=g;i=a.B[b];a.B[b]=a.B[c];a.B[c]=i;g=a.w[b];a.w[b]=a.w[c];a.w[c]=g;f=a.J[b];a.J[b]=a.J[c];a.J[c]=f;if(a.v!=null){h=a.v[b];a.v[b]=a.v[c];a.v[c]=h;}if(a.t!=null){h=a.t[b];a.t[b]=a.t[c];a.t[c]=h;}for(d=0;d<a.r;d++){for(e=0;e<2;e++){a.D[e][d]==b?a.D[e][d]=c:a.D[e][d]==c&&(a.D[e][d]=b);}}a.T=0;};$Xb.Tm=function Tm(a,b,c){var d;d=a.D[0][b];a.D[0][b]=a.D[0][c];a.D[0][c]=d;d=a.D[1][b];a.D[1][b]=a.D[1][c];a.D[1][c]=d;d=a.H[b];a.H[b]=a.H[c];a.H[c]=d;d=a.F[b];a.F[b]=a.F[c];a.F[c]=d;d=a.G[b];a.G[b]=a.G[c];a.G[c]=d;a.T=0;};$Xb.Um=function Um(a,b,c){var d;for(d=0;d<a.q;d++){a.J[d].a+=b;a.J[d].b+=c;}a.U+=b;a.V+=c;};$Xb.Vm=function Vm(a,b,c){var d,e;e=c&127;d=$Xb.ll(a,b);switch(e){case 1:case 64:return d>=1;case 2:return d>=2;case 4:return d>=3;case 8:return d>=4;case 16:return d>=5;case 32:return true;default:return false;}};$Xb.Wm=function Wm(a,b,c,d){var e,f,g;for(e=0;e<a.q;e++){if(!d||(a.u[e]&512)!=0){g=a.R[e]*b;f=a.Q[e]-c;a.J[e].a=a.U+g*$wnd.Math.sin(f);a.J[e].b=a.V+g*$wnd.Math.cos(f);}}d&&(a.T&=7);};$Xb.Xm=function Xm(a,b,c){var d,e,f;a.U=b;a.V=c;a.Q=Sjb(UXb.jlb,wZb,6,a.q,15,1);a.R=Sjb(UXb.jlb,wZb,6,a.q,15,1);for(d=0;d<a.q;d++){e=b-a.J[d].a;f=c-a.J[d].b;a.R[d]=$wnd.Math.sqrt(e*e+f*f);a.Q[d]=$Xb.fn(b,c,a.J[d].a,a.J[d].b);}};$Xb.Ym=function Ym(){this.M=this.N=256;$Xb.ol(this);};$Xb.Zm=function Zm(a,b){this.M=$wnd.Math.max(1,a);this.N=$wnd.Math.max(1,b);$Xb.ol(this);};$Xb._m=function _m(a,b){var c;c=Sjb(UXb.llb,yZb,6,b,15,1);VXb.pIb(a,0,c,0,$wnd.Math.min(a.length,b));return c;};$Xb.an=function an(a,b){var c;c=Sjb(UXb.mlb,N$b,6,b,14,1);VXb.pIb(a,0,c,0,$wnd.Math.min(a.length,b));return c;};$Xb.bn=function bn(a,b){var c,d;c=Sjb(UXb.Elb,j_b,32,b,0,1);for(d=0;d<a.length;d++)!!a[d]&&(c[d]=new $Xb.Th(a[d]));return c;};$Xb.cn=function cn(a,b){var c,d;c=Sjb(UXb.hlb,aZb,10,b,0,2);for(d=0;d<a.length;d++){if(a[d]!=null){c[d]=Sjb(UXb.hlb,S$b,6,a[d].length,15,1);VXb.pIb(a[d],0,c[d],0,a[d].length);}}return c;};$Xb.dn=function dn(a,b){var c,d;c=Sjb(UXb.llb,Q$b,8,b,0,2);for(d=0;d<a.length;d++){if(a[d]!=null){c[d]=Sjb(UXb.llb,yZb,6,a[d].length,15,1);VXb.pIb(a[d],0,c[d],0,a[d].length);}}return c;};$Xb.en=function en(a){$Xb.Sj();return a>=0&&a<$Xb.Nj.length&&$Xb.Nj[a]!=null?$Xb.Nj[a]:a>=171&&a<=190?$Xb.Lj:$Xb.Pj;};$Xb.fn=function fn(a,b,c,d){$Xb.Sj();var e,f,g;f=c-a;g=d-b;if(g!=0){e=$wnd.Math.atan(f/g);g<0&&(f<0?e-=PZb:e+=PZb);}else e=f>0?QZb:y$b;return e;};$Xb.gn=function gn(a,b){$Xb.Sj();var c;c=a-b;while(c<p_b)c+=OZb;while(c>PZb)c-=OZb;return c;};$Xb.hn=function hn(a,b){$Xb.Sj();var c,d,e,f,g;if((b&256)!=0&&VXb.DHb(a,'?'))return 0;for(d=1;d<=128;d++)if(!VXb.DHb(a,f_b)&&VXb.EHb(a,$Xb.Mj[d]))return d;if((b&2)!=0)for(e=129;e<=144;e++)if(VXb.EHb(a,$Xb.Mj[e]))return e;if((b&4)!=0)for(f=146;f<=148;f++)if(VXb.EHb(a,$Xb.Mj[f]))return f;if((b&1)!=0)for(g=151;g<=152;g++)if(VXb.EHb(a,$Xb.Mj[g]))return g;if((b&32)!=0)if(VXb.EHb(a,$Xb.Mj[153]))return 153;if((b&8)!=0)if(VXb.EHb(a,$Xb.Mj[154]))return 154;if((b&16)!=0)if(VXb.EHb(a,$Xb.Mj[145]))return 145;if((b&128)!=0)if(VXb.EHb(a,$Xb.Mj[159]))return 159;if((b&64)!=0)for(c=171;c<=190;c++)if(VXb.EHb(a,$Xb.Mj[c]))return c;return 0;};$Xb.jn=function jn(a){$Xb.Sj();switch(a){case 7:case 8:case 9:case 15:case 16:case 17:case 33:case 34:case 35:case 52:case 53:return true;}return false;};$Xb.kn=function kn(a){$Xb.Sj();if(a==1||a==6)return false;if($Xb.jn(a))return false;if(a==2||a==10||a==18||a==36||a==54)return false;if(a>103)return false;return true;};$Xb.ln=function ln(a){return a>=3&&a<=4||a>=11&&a<=13||a>=19&&a<=31||a>=37&&a<=51||a>=55&&a<=84||a>=87&&a<=103;};$Xb.mn=function mn(a){return a==1||a>=5&&a<=9||a>=14&&a<=17||a>=32&&a<=35||a>=52&&a<=53;};$Xb.nn=function nn(a){return a>=21&&a<=30||a>=39&&a<=48||a==57||a>=72&&a<=80||a==89||a>=104&&a<=112;};xxb(113,1,{113:1,4:1});_.Kb=function $m(a){$Xb.nk(this,a);};_.Lb=function on(a){return this.H[a]==64;};_.q=0;_.r=0;_.I=0;_.K=false;_.L=false;_.M=0;_.N=0;_.O=0;_.S=false;_.T=0;_.U=0;_.V=0;$Xb.Rj=24;UXb.Qlb=VFb(113);$Xb.pn=function pn(a,b,c,d){var e,f,g,h,i,j,k,l,m;$Xb.nu(b,1);d==null&&(d=Sjb(UXb.llb,yZb,6,b.q,15,1));h=$Xb.Yl(a,1);i=$Xb.Yl(a,2);m=Sjb(UXb.Cwb,KZb,6,b.q,16,1);j=Sjb(UXb.llb,yZb,6,b.q,15,1);j[0]=c;m[c]=true;d[c]=$Xb.jk(b,a,c,h,i);g=0;k=0;while(g<=k){for(l=0;l<$Xb.Dn(b,j[g]);l++){f=b.i[j[g]][l];if(!m[f]){j[++k]=f;m[f]=true;d[f]=$Xb.jk(b,a,f,h,i);}}++g;}for(e=0;e<b.r;e++)m[b.D[0][e]]&&$Xb.kk(b,a,e,h,i,d==null?b.D[0][e]:d[b.D[0][e]],d==null?b.D[1][e]:d[b.D[1][e]],false);$Xb.Yl(a,1);$Xb.Yl(a,2);a.T=0;};$Xb.qn=function qn(a){var b,c,d,e,f,g,h,i,j,k,l,m;a.j=Sjb(UXb.llb,yZb,6,a.q,15,1);a.e=Sjb(UXb.llb,yZb,6,a.q,15,1);a.i=Sjb(UXb.llb,Q$b,8,a.q,0,2);a.k=Sjb(UXb.llb,Q$b,8,a.q,0,2);a.n=Sjb(UXb.llb,Q$b,8,a.q,0,2);a.o=Sjb(UXb.llb,yZb,6,a.f,15,1);j=Sjb(UXb.llb,yZb,6,a.q,15,1);for(g=0;g<a.r;g++){++j[a.D[0][g]];++j[a.D[1][g]];}for(d=0;d<a.q;d++){a.i[d]=Sjb(UXb.llb,yZb,6,j[d],15,1);a.k[d]=Sjb(UXb.llb,yZb,6,j[d],15,1);a.n[d]=Sjb(UXb.llb,yZb,6,j[d],15,1);}l=false;for(h=0;h<a.g;h++){m=$Xb.bl(a,h);if(m==0){l=true;continue;}for(k=0;k<2;k++){c=a.D[k][h];b=a.e[c];a.n[c][b]=m;a.i[c][b]=a.D[1-k][h];a.k[c][b]=h;++a.e[c];++a.j[c];c<a.f&&(m>1?a.o[c]+=m-1:a.H[h]==64&&(a.o[c]=1));}}for(i=a.g;i<a.r;i++){m=$Xb.bl(a,i);if(m==0){l=true;continue;}for(k=0;k<2;k++){c=a.D[k][i];b=a.e[c];a.n[c][b]=m;a.i[c][b]=a.D[1-k][i];a.k[c][b]=i;++a.e[c];a.D[1-k][i]<a.f&&++a.j[c];}}if(l){b=Sjb(UXb.llb,yZb,6,a.q,15,1);for(e=0;e<a.q;e++)b[e]=a.e[e];for(f=0;f<a.r;f++){m=$Xb.bl(a,f);if(m==0){for(k=0;k<2;k++){c=a.D[k][f];a.n[c][b[c]]=m;a.i[c][b[c]]=a.D[1-k][f];a.k[c][b[c]]=f;++b[c];}}}}};$Xb.rn=function rn(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w;$Xb.nu(a,1);c&&(b=true);for(i=0;i<a.r;i++){j=$Xb.bl(a,i);if(j==1||j==2){if(a.s[a.D[0][i]]>0&&a.s[a.D[1][i]]<0){f=a.D[0][i];g=a.D[1][i];}else if(a.s[a.D[0][i]]<0&&a.s[a.D[1][i]]>0){f=a.D[1][i];g=a.D[0][i];}else continue;if($Xb.Fl(a,f)||$Xb.Fl(a,g))continue;if(a.C[f]<9&&$Xb.ko(a,f)>3||a.C[g]<9&&$Xb.ko(a,g)>3)continue;l=$Xb.fo(a,f)!=0;a.s[f]-=1;a.s[g]+=1;if(!l){s=a.H[i];j==1?a.H[i]=2:a.H[i]=4;if(s==129||s==257){w=a.D[0][i];r=$Xb.cp(a,w,false);if(a.D[0][r]!=w){a.D[1][r]=a.D[0][r];a.D[1][r]=w;}}}a.T=0;}}t=0;p=0;n=0;for(e=0;e<a.q;e++){t+=a.s[e];if(a.s[e]<0&&!$Xb.Do(a,e)){++p;$Xb.Cl(a,e)&&(n-=a.s[e]);}}if(!b&&t!=0)throw Hwb(new VXb.aA("molecule's overall charges are not balanced"));$Xb.nu(a,1);u=0;v=c?t+n:n;for(h=0;h<a.q;h++){if(a.s[h]>0){if(!$Xb.Co(a,h)&&$Xb.Cl(a,h)){k=$wnd.Math.min($Xb.fo(a,h),a.s[h]);if(k!=0&&v>=k){t-=k;u-=k;v-=k;a.s[h]-=k;a.T&=1;}}}}q=c?t:u;if(q<0){o=Sjb(UXb.llb,yZb,6,p,15,1);p=0;for(f=0;f<a.q;f++){a.s[f]<0&&!$Xb.Do(a,f)&&(o[p++]=(a.C[f]<<22)+f);}YXb.fTb(o,YXb.LTb(Axb(_Xb.ZOb.prototype.Zd,_Xb.ZOb,[])));for(m=o.length-1;q<0&&m>=o.length-p;m--){d=o[m]&q_b;if($Xb.Cl(a,d)){k=$wnd.Math.min(-q,-a.s[d]);t+=k;q+=k;a.s[d]+=k;a.T&=1;}}}return t;};$Xb.sn=function sn(a){var b,c,d,e,f,g,h,i,j,k,l,m,n;if(!a.K)return false;for(c=0;c<a.q;c++){n=$Xb.kl(a,c);n+$Xb.il(a,c,n)-$Xb.ko(a,c)<=0&&!(a.s[c]==0&&(a.C[c]==5||(e=a.C[c],e==7||e==15||e==33)||(d=a.C[c],d==8||d==16||d==34||d==52)))&&(a.B[c]=Jwb(a.B[c],-6145));}g=false;for(b=0;b<a.f;b++){h=a.e[b]-a.j[b];if(!a.S&&h>0){if(Twb(Jwb(a.B[b],x$b),0)){k=Twb(Jwb(a.B[b],WZb),896)?3:Twb(Jwb(a.B[b],WZb),384)?2:Twb(Jwb(a.B[b],128),128)?1:0;i=(n=$Xb.kl(a,b),n+$Xb.il(a,b,n)-$Xb.ko(a,b));a.s[b]==0&&Twb(Jwb(a.B[b],YZb),0)&&a.C[b]!=6&&++i;l=h;l>3-k&&(l=3-k);l>i+h-k&&(l=i+h-k);if(l>0){m=k==0?0:fxb(Jwb(a.B[b],WZb),l);m=exb(m,UXb.Rwb((l==3?7:h==2?3:1)<<7));a.B[b]=Jwb(a.B[b],-1921);a.B[b]=exb(a.B[b],Jwb(WZb,m));}}for(j=a.j[b];j<a.e[b];j++){f=a.k[b][j];if(a.H[f]==1){a.C[a.i[b][j]]=-1;a.H[f]=512;g=true;}}}}g&&$Xb.ik(a);return g;};$Xb.tn=function tn(a,b){var c,d,e,f;if(a.o[b]==2&&a.j[b]==2&&a.n[b][0]==2){for(e=0;e<2;e++){c=$Xb.yn(a,b,a.i[b][e]);if(c!=-1){for(f=0;f<a.j[c];f++){d=a.k[c][f];(a.H[d]==257||a.H[d]==129)&&a.D[0][d]==c&&(a.H[a.k[c][f]]=1);}}}return;}if(a.o[b]==0||a.C[b]>=15){for(e=0;e<a.e[b];e++){d=a.k[b][e];(a.H[d]==257||a.H[d]==129)&&a.D[0][d]==b&&a.D[0][d]==b&&(a.H[d]=1);}}};$Xb.un=function un(a,b,c,d,e){var f,g,h,i,j;d&&$Xb.nu(a,7);b.v=null;a.K&&$Xb.Hm(b,true);i=c.length;e==null&&(e=Sjb(UXb.llb,yZb,6,i,15,1));b.q=0;for(f=0;f<i;f++)e[f]=c[f]?$Xb.jk(a,b,f,0,0):-1;b.r=0;for(j=0;j<a.r;j++){g=a.D[0][j];h=a.D[1][j];if(g<i&&h<i){if(c[g]&&c[h])$Xb.kk(a,b,j,0,0,e==null?a.D[0][j]:e[a.D[0][j]],e==null?a.D[1][j]:e[a.D[1][j]],d);else if(a.s[g]!=0&&a.s[h]!=0&&a.s[g]<0^a.s[h]<0){c[g]&&(b.s[e[g]]+=a.s[g]<0?1:-1);c[h]&&(b.s[e[h]]+=a.s[h]<0?1:-1);}}}$Xb.nk(a,b);!!a.d&&(b.T=0);b.T=0;$Xb.Yl(b,1);$Xb.Yl(b,2);b.q!=i&&$Xb.Hm(b,true);d&&$Xb.je(new $Xb.te(b),null,false);};$Xb.vn=function vn(a,b,c,d,e){var f,g,h,i,j;d&&$Xb.nu(a,7);b.v=null;a.K&&$Xb.Hm(b,true);e==null&&(e=Sjb(UXb.llb,yZb,6,a.q,15,1));b.q=0;for(f=0;f<a.q;f++){e[f]=-1;for(j=0;j<a.j[f];j++){if(c[a.k[f][j]]){e[f]=$Xb.jk(a,b,f,0,0);break;}}}b.r=0;for(i=0;i<a.r;i++)if(c[i]){$Xb.kk(a,b,i,0,0,e==null?a.D[0][i]:e[a.D[0][i]],e==null?a.D[1][i]:e[a.D[1][i]],d);}else {g=a.D[0][i];h=a.D[1][i];if(e[g]==-1^e[h]==-1){if(a.s[g]!=0&&a.s[h]!=0&&a.s[g]<0^a.s[h]<0){e[g]!=-1&&(b.s[e[g]]+=a.s[g]<0?1:-1);e[h]!=-1&&(b.s[e[h]]+=a.s[h]<0?1:-1);}}}$Xb.nk(a,b);!!a.d&&(b.T=0);b.T=0;$Xb.Yl(b,1);$Xb.Yl(b,2);b.q!=a.q&&$Xb.Hm(b,true);d&&$Xb.je(new $Xb.te(b),null,false);return e;};$Xb.wn=function wn(a,b){var c,d,e,f,g,h,i,j,k,l;if((b&~a.T)==0)return;if((a.T&1)==0){$Xb.Bo(a);$Xb.qn(a);a.T|=1;if($Xb.sn(a)){$Xb.Bo(a);$Xb.qn(a);}}if((b&~a.T)==0)return;if((a.T&-7)!=0){for(d=0;d<a.f;d++)a.u[d]&=-15369;for(f=0;f<a.g;f++)a.F[f]&=-705;if((b&4)==0){$Xb.Bn(a,1);a.T|=2;return;}$Xb.Bn(a,7);for(e=0;e<a.f;e++){for(k=0;k<a.j[e];k++){i=a.k[e][k];if(i<a.g&&$Xb.Vr(a.p,i))continue;h=a.i[e][k];for(l=0;l<a.j[h];l++){if(a.k[h][l]==i)continue;a.n[h][l]>1&&(a.C[a.i[h][l]]==6?a.u[e]|=SZb:!$Xb.Io(a,a.k[h][l])&&$Xb.Cl(a,a.i[h][l])&&(a.u[e]|=w$b));}}}while(true){j=false;for(c=0;c<a.f;c++){if(a.o[c]>0&&(a.u[c]&w$b)!=0&&!$Xb.Ur(a.p,c)){for(k=0;k<a.j[c];k++){if(a.n[c][k]>1){h=a.i[c][k];i=a.k[c][k];for(l=0;l<a.j[h];l++){if(a.k[h][l]!=i){g=a.i[h][l];if((a.u[g]&w$b)==0){a.u[g]|=w$b;j=true;}}}}}}}if(!j)break;}}a.T|=6;};$Xb.xn=function xn(a,b){var c,d,e,f,g;c=-1;if(a.o[b]==1){for(f=0;f<a.j[b];f++){if(a.n[b][f]==2){d=a.i[b][f];if(a.j[d]==2&&a.o[d]==2){for(g=0;g<2;g++){e=a.i[d][g];if(e!=b&&a.o[e]==1){c=d;break;}}}break;}}}return c;};$Xb.yn=function yn(a,b,c){var d,e;d=b;while(a.j[c]==2&&a.o[c]==2&&c!=d){e=c;c=a.i[c][0]==b?a.i[c][1]:a.i[c][0];b=e;}return c==d?-1:c;};$Xb.zn=function zn(a,b){var c;if(a.j[b]==3&&b<a.f&&$Xb.Ur(a.p,b)&&(!!a.p&&b<a.f?$Xb.Jr(a.p,b):0)>=5)for(c=0;c<a.j[b];c++)if($Xb.Jo(a,a.k[b][c]))return a.k[b][c];return -1;};$Xb.An=function An(a,b,c,d,e){var f,g,h,i,j,k;$Xb.nu(a,7);if((a.u[b]&r_b)==0||c&&!(b<a.f&&$Xb.Ur(a.p,b)))return;i=Sjb(UXb.llb,yZb,6,a.f,15,1);i[0]=b;d[b]=true;h=0;j=0;while(h<=j){for(k=0;k<a.j[i[h]];k++){g=a.k[i[h]][k];if(!e[g]&&(a.F[g]&64)!=0&&(!c||g<a.g&&$Xb.Vr(a.p,g))){e[g]=true;f=a.i[i[h]][k];if(!d[f]){d[f]=true;i[++j]=f;}}}++h;}};$Xb.Bn=function Bn(a,b){var c,d,e,f,g,h,i,j;a.p=new $Xb.gs(a,b);d=Sjb(UXb.llb,yZb,6,a.f,15,1);for(e=0;e<a.g;e++){if($Xb.Lr(a.p,e)!=0){a.F[e]|=64;++d[a.D[0][e]];++d[a.D[1][e]];}}for(c=0;c<a.f;c++){d[c]==2?a.u[c]|=XZb:d[c]==3?a.u[c]|=x$b:d[c]>3&&(a.u[c]|=r_b);}for(j=0;j<a.p.i.a.length;j++){g=$Xb.Nr(a.p,j);i=$Xb.Or(a.p,j);h=g.length;for(f=0;f<h;f++){a.u[g[f]]|=8;a.F[i[f]]|=128;a.H[i[f]]==386&&(a.H[i[f]]=2);}}};$Xb.Cn=function Cn(a){var b,c,d,e,f,g,h,i;h=Sjb(UXb.Cwb,KZb,6,a.q,16,1);for(c=0;c<a.q;c++)h[c]=a.C[c]==1&&a.A[c]==0&&a.s[c]==0&&(a.t==null||a.t[c]==null);i=Sjb(UXb.Cwb,KZb,6,a.q,16,1);for(g=0;g<a.r;g++){d=a.D[0][g];e=a.D[1][g];if($Xb.bl(a,g)!=1){h[d]=false;h[e]=false;continue;}i[d]&&(h[d]=false);i[e]&&(h[e]=false);h[d]&&$Xb.Fl(a,e)&&a.C[e]!=13&&(h[d]=false);h[e]&&$Xb.Fl(a,d)&&a.C[d]!=13&&(h[e]=false);i[d]=true;i[e]=true;}for(f=0;f<a.r;f++){if(h[a.D[0][f]]&&h[a.D[1][f]]){h[a.D[0][f]]=false;h[a.D[1][f]]=false;}}for(b=0;b<a.q;b++)i[b]||(h[b]=false);return h;};$Xb.Dn=function Dn(a,b){return a.e[b];};$Xb.En=function En(a,b){return a.i[b].length;};$Xb.Fn=function Fn(a,b){return a.e[b]-$Xb.jo(a,b)+$Xb.fo(a,b);};$Xb.Gn=function Gn(a){var b,c;$Xb.nu(a,7);b=0;for(c=0;c<a.p.i.a.length;c++)$Xb.Tr(a.p,c)&&++b;return b;};$Xb.Hn=function Hn(a,b){var c,d;c=0;for(d=0;d<a.j[b];d++)$Xb.Cl(a,a.i[b][d])&&!$Xb.xl(a,a.k[b][d])&&++c;return c;};$Xb.In=function In(a,b){return a.o[b];};$Xb.Jn=function Jn(a,b){$Xb.nu(a,7);return a.o[b]==2&&a.j[b]==2?$Xb.ap(a,b,false):$Xb.cp(a,b,false);};$Xb.Kn=function Kn(a,b){var c;c=a.u[b]&r_b;return c==0?0:c==XZb?2:c==x$b?3:4;};$Xb.Ln=function Ln(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o;$Xb.nu(a,7);f=Sjb(UXb.Cwb,KZb,6,a.g,16,1);l=Sjb(UXb.Cwb,KZb,6,a.g,16,1);o=Sjb(UXb.llb,yZb,6,a.f,15,1);g=0;for(h=1;h<a.j[b];h++){d=a.k[b][h];if((a.F[d]&64)!=0){for(j=0;j<h;j++){e=a.k[b][j];if((a.F[e]&64)!=0){l[d]=true;l[e]=true;n=$Xb.mo(a,o,a.i[b][h],a.i[b][j],c-2,null,l);l[d]=false;l[e]=false;if(n!=-1){i=false;m=Sjb(UXb.llb,yZb,6,n,15,1);$Xb.no(a,o,m,n);for(k=0;k<n;k++){if(!f[m[k]]){f[m[k]]=true;i=true;}}i&&++g;}}}}}return g;};$Xb.Mn=function Mn(a,b){return !!a.p&&b<a.f?$Xb.Jr(a.p,b):0;};$Xb.Nn=function Nn(a,b){if(b){$Xb.nu(a,1);return $Xb.Sk(a,a.f,a.g,$Xb.Rj);}else {return $Xb.Sk(a,a.q,a.r,$Xb.Rj);}};$Xb.On=function On(a){var b,c,d,e,f,g,h,i;$Xb.nu(a,1);h=Sjb(UXb.klb,s_b,6,a.f,15,1);d=Sjb(UXb.llb,yZb,6,a.f,15,1);for(i=0;i<a.f;i++){d[0]=i;e=Sjb(UXb.llb,yZb,6,a.f,15,1);e[i]=1;c=0;f=0;while(c<=f){for(g=0;g<a.j[d[c]];g++){b=a.i[d[c]][g];if(e[b]==0){e[b]=e[d[c]]+1;d[++f]=b;h[i]+=e[b]-1;}}++c;}h[i]/=f;}return h;};$Xb.Pn=function Pn(a,b,c){var d;for(d=0;d<a.i[b].length;d++)if(a.i[b][d]==c)return a.k[b][d];return -1;};$Xb.Qn=function Qn(a,b){return !!a.p&&b<a.g?$Xb.Lr(a.p,b):0;};$Xb.Rn=function Rn(a,b,c){return a.i[b][c];};$Xb.Sn=function Sn(a,b){return a.j[b];};$Xb.Tn=function Tn(a,b,c){return a.k[b][c];};$Xb.Un=function Un(a,b,c){return a.n[b][c];};$Xb.Vn=function Vn(a,b){var c,d;c=0;for(d=0;d<a.j[b];d++)cxb(Jwb(a.B[d],LZb),0)&&++c;return c;};$Xb.Wn=function Wn(a,b){return a.e[b]-a.j[b];};$Xb.Xn=function Xn(a,b,c,d,e){var f,g,h,i;g=a.e[b];if(a.o[b]!=0||b<a.f&&$Xb.Ur(a.p,b)||a.j[b]<3||g>4)return false;i=Sjb(UXb.Cwb,KZb,6,4,16,1);for(h=0;h<g;h++){f=3.9269908169872414-d[h];if($wnd.Math.abs(t_b-f%QZb)>0.0872664675116539)return false;e[h]=3&glb(f/QZb);if(i[e[h]])return false;i[e[h]]=true;if((e[h]&1)==0){if(a.H[a.k[b][c[h]]]!=1)return false;}else {if(!$Xb.Ml(a,a.k[b][c[h]],b))return false;}}return i[0]&&i[2];};$Xb.Yn=function Yn(a,b,c,d,e){var f,g,h,i,j,k,l,m;if((!!a.p&&b<a.f?$Xb.Jr(a.p,b):0)>24)return 3;f=a.e[b];e==null&&(e=Sjb(UXb.llb,yZb,6,f,15,1));if(!$Xb.Xn(a,b,c,d,e))return 3;i=-1;for(j=0;j<f;j++){if((e[j]&1)==1){g=a.H[a.k[b][c[j]]];if(i!=-1&&i!=g)return 3;i=g;}}k=$wnd.Math.abs(e[0]-e[1])==2?1:0;h=e[k]-e[k+1];m=$wnd.Math.abs(h)==3^e[k]<e[k+1];l=f==3||(e[3]&1)==1;return m^l^i==129?1:2;};$Xb.Zn=function Zn(a,b,c){var d,e,f,g,h,i,j,k,l,m;$Xb.nu(a,1);m=Sjb(UXb.Cwb,KZb,6,a.q,16,1);j=Sjb(UXb.llb,yZb,6,a.q,15,1);j[0]=b;m[b]=true;g=0;k=0;i=1;while(g<=k){f=c?$Xb.En(a,j[g]):a.e[j[g]];for(l=0;l<f;l++){e=a.i[j[g]][l];if(!m[e]){j[++k]=e;m[e]=true;++i;}}++g;}h=Sjb(UXb.llb,yZb,6,i,15,1);i=0;for(d=0;d<a.q;d++)m[d]&&(h[i++]=d);return h;};$Xb.$n=function $n(a,b,c,d){var e,f,g,h,i,j,k,l,m;$Xb.nu(a,1);for(f=0;f<a.q;f++)b[f]=-1;j=0;for(e=0;e<a.q;e++){if(b[e]==-1&&(!c||(a.u[e]&T$b)!=0)){b[e]=j;k=Sjb(UXb.llb,yZb,6,a.q,15,1);k[0]=e;i=0;l=0;while(i<=l){h=d?$Xb.En(a,k[i]):a.e[k[i]];for(m=0;m<h;m++){g=a.i[k[i]][m];if(b[g]==-1&&(!c||(a.u[g]&T$b)!=0)){k[++l]=g;b[g]=j;}}++i;}++j;}}return j;};$Xb._n=function _n(a,b,c,d){var e,f,g,h,i,j,k,l,m;$Xb.nu(a,1);for(f=0;f<a.q;f++)b[f]=-1;j=0;for(e=0;e<a.q;e++){if(b[e]==-1){b[e]=j;k=Sjb(UXb.llb,yZb,6,a.q,15,1);k[0]=e;i=0;l=0;while(i<=l){h=d?$Xb.En(a,k[i]):a.e[k[i]];for(m=0;m<h;m++){g=a.i[k[i]][m];if(b[g]==-1&&!c[a.k[k[i]][m]]){k[++l]=g;b[g]=j;}}++i;}++j;}}return j;};$Xb.ao=function ao(a,b){var c;return c=$Xb.kl(a,b),c+$Xb.il(a,b,c)-$Xb.ko(a,b);};$Xb.bo=function bo(a,b){var c,d,e,f,g,h;f=Sjb(UXb.llb,yZb,6,a.q,15,1);for(d=0;d<a.q;d++)f[d]=d;e=a.q;do--e;while(e>=0&&b[e]);for(c=0;c<e;c++){if(b[f[c]]){h=f[c];f[c]=f[e];f[e]=h;g=b[c];b[c]=b[e];b[e]=g;do--e;while(b[e]);}}return f;};$Xb.co=function co(a){return $Xb.bo(a,$Xb.Cn(a));};$Xb.eo=function eo(a,b,c){var d,e,f;e=$Xb.ko(a,b);e-=$Xb.il(a,b,e);c&&(e-=a.e[b]-a.j[b]);f=$Xb.en(a.C[b]);if(e<=f[0])return -1;for(d=1;d<f.length;d++)if(f[d]>=e)return f[d];return e;};$Xb.fo=function fo(a,b){var c,d,e,f,g,h;if(a.K&&Twb(Jwb(a.B[b],x$b),0))return 0;if(!$Xb.lp(a,b))return 0;$Xb.nu(a,1);g=0;for(e=0;e<a.e[b];e++)g+=a.n[b][e];if(a.K){c=1;for(d=0;d<a.j[b];d++)a.H[a.k[b][d]]==64&&++c;g+=c>>1;}g-=$Xb.il(a,b,g);f=((a.u[b]&g_b)>>>27)-1;if(f==-1){h=$Xb.en(a.C[b]);f=h[0];for(d=1;f<g&&d<h.length;d++)f=h[d];}return $wnd.Math.max(0,f-g);};$Xb.go=function go(a,b){var c,d,e,f,g;e=$Xb.ko(a,b);c=$Xb.il(a,b,e);f=((a.u[b]&g_b)>>>27)-1;if(f==-1){g=$Xb.en(a.C[b]);d=0;while(e>g[d]+c&&d<g.length-1)++d;f=g[d];}return f+c-e;};$Xb.ho=function ho(a,b){return a.i[b].length-a.e[b];};$Xb.io=function io(a){var b,c,d,e;$Xb.nu(a,1);e=0;for(b=0;b<a.q;b++){d=a.A[b]!=0?a.A[b]:$Xb.Qj[a.C[b]];e+=d+$Xb.fo(a,b)*$Xb.Qj[1];if(a.C[b]>=171&&a.C[b]<=190){c=a.e[b];c>2&&(e-=(c-2)*$Xb.Qj[1]);}}return e;};$Xb.jo=function jo(a,b){var c,d;c=a.j[b];for(d=0;d<a.j[b];d++)a.C[a.i[b][d]]==1&&--c;return c;};$Xb.ko=function ko(a,b){var c,d,e,f,g,h;a.Mb(1);g=false;d=false;h=0;for(e=0;e<a.e[b];e++){if(!a.K||Twb(Jwb(a.B[a.i[b][e]],LZb),0)){f=a.n[b][e];h+=f;f>1&&(g=true);c=a.k[b][e];a.H[c]==64&&(d=true);}}d&&!g&&++h;return h;};$Xb.lo=function lo(a,b,c){var d,e,f;e=0;for(f=0;f<a.j[b];f++){d=a.i[b][f];d!=c&&a.j[d]>2&&++e;}return e;};$Xb.mo=function mo(a,b,c,d,e,f,g){var h,i,j,k,l,m,n,o,p;if(c==d){b[0]=c;return 0;}a.Mb(1);k=Sjb(UXb.llb,yZb,6,a.q,15,1);j=Sjb(UXb.llb,yZb,6,a.q,15,1);p=Sjb(UXb.llb,yZb,6,a.q,15,1);j[0]=c;k[c]=1;i=0;l=0;while(i<=l&&k[j[i]]<=e){o=j[i];for(m=0;m<a.e[o];m++){if(g==null||g.length<=a.k[o][m]||!g[a.k[o][m]]){h=a.i[o][m];if(h==d){n=k[o];b[n]=h;b[--n]=o;while(n>0){b[n-1]=p[b[n]];--n;}return k[o];}if(k[h]==0&&(f==null||f.length<=h||!f[h])){j[++l]=h;k[h]=k[o]+1;p[h]=o;}}}++i;}return -1;};$Xb.no=function no(a,b,c,d){var e,f;$Xb.nu(a,1);for(e=0;e<d;e++){for(f=0;f<a.e[b[e]];f++){if(a.i[b[e]][f]==b[e+1]){c[e]=a.k[b[e]][f];break;}}}};$Xb.oo=function oo(a,b,c){var d,e,f,g,h,i;if(b==c)return 0;$Xb.nu(a,1);g=Sjb(UXb.llb,yZb,6,a.q,15,1);f=Sjb(UXb.llb,yZb,6,a.q,15,1);f[0]=b;g[b]=1;e=0;h=0;while(e<=h){for(i=0;i<a.e[f[e]];i++){d=a.i[f[e]][i];if(d==c)return g[f[e]];if(g[d]==0){f[++h]=d;g[d]=g[f[e]]+1;}}++e;}return -1;};$Xb.po=function po(a,b,c,d,e){var f,g,h,i,j,k;if(b==c)return 0;a.Mb(1);i=Sjb(UXb.llb,yZb,6,a.q,15,1);h=Sjb(UXb.llb,yZb,6,a.q,15,1);h[0]=b;i[b]=1;g=0;j=0;while(g<=j&&i[h[g]]<=d){for(k=0;k<a.e[h[g]];k++){f=a.i[h[g]][k];if(f==c)return i[h[g]];if(i[f]==0&&(e==null||e.length<=f||!e[f])){h[++j]=f;i[f]=i[h[g]]+1;}}++g;}return -1;};$Xb.qo=function qo(a,b){return a.e[b]-a.j[b]+$Xb.fo(a,b);};$Xb.ro=function ro(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o;o=Sjb(UXb.llb,yZb,6,16,15,1);c=Sjb(UXb.jlb,wZb,6,16,15,1);f=Sjb(UXb.jlb,wZb,6,2,15,1);d=0;for(k=0;k<2;k++){e=a.D[k][b];for(l=0;l<a.j[e];l++){i=a.k[e][l];if(i==b)continue;if(d==4)return 0;h=a.i[e][l];o[d]=16;a.o[h]!=0&&(o[d]+=(a.u[h]&r_b)!=0?1:4);if((a.F[b]&64)!=0&&(a.F[i]&64)!=0){m=$Xb.Rr(a.p,b,i);m!=-1&&(o[d]+=$Xb.Tr(a.p,m)?64:6);}c[d++]=$Xb.fn(a.J[e].a,a.J[e].b,a.J[h].a,a.J[h].b);}}f[0]=$Xb.Uk(a,a.D[0][b],a.D[1][b]);if(f[0]<0){f[1]=f[0]+PZb;g=false;}else {f[1]=f[0];f[0]=f[1]-PZb;g=true;}n=0;for(j=0;j<d;j++){c[j]>f[0]&&c[j]<f[1]?n-=o[j]:n+=o[j];}return g?-n:n;};$Xb.so=function so(a){$Xb.nu(a,7);return a.p;};$Xb.to=function to(a){var b,c,d,e,f,g,h,i,j;j=0;$Xb.nu(a,7);for(d=0;d<a.g;d++){if($Xb.bl(a,d)==1&&(a.F[d]&64)==0){h=true;for(g=0;g<2;g++){b=a.D[g][d];if(a.j[b]==1){h=false;break;}if(a.C[b]==7&&!(b<a.f&&$Xb.Ur(a.p,b))){c=a.D[1-g][d];for(i=0;i<a.j[c];i++){e=a.i[c][i];f=a.k[c][i];if(f!=d&&$Xb.bl(a,f)>1&&!(e<a.f&&$Xb.Ur(a.p,e))&&$Xb.Cl(a,e)){h=false;break;}}}}h&&!$Xb.Ro(a,d)&&++j;}}return j;};$Xb.uo=function uo(a,b,c){var d,e,f,g,h,i;e=0;for(f=0;f<a.j[b];f++){d=a.i[b][f];if(d!=c){g=0;for(h=0;h<a.j[d];h++){i=a.i[d][h];i!=b&&$Xb.Io(a,a.k[d][h])&&a.j[i]>2&&++g;}g==2&&++e;}}return e;};$Xb.vo=function vo(a,b){var c,d,e,f;c=a.e[b];f=Sjb(UXb.llb,yZb,6,c,15,1);for(e=0;e<c;e++)f[e]=(a.i[b][e]<<16)+e;YXb.fTb(f,YXb.LTb(Axb(_Xb.ZOb.prototype.Zd,_Xb.ZOb,[])));for(d=0;d<c;d++)f[d]&=pZb;return f;};$Xb.wo=function wo(a,b){var c,d;$Xb.nu(a,1);if(a.j[b]==2&&a.n[b][0]==2&&a.n[b][1]==2){for(c=0;c<2;c++)for(d=0;d<a.e[a.i[b][c]];d++)if($Xb.Ml(a,a.k[a.i[b][c]][d],a.i[b][c]))return a.k[a.i[b][c]][d];}else {for(c=0;c<a.e[b];c++)if($Xb.Ml(a,a.k[b][c],b))return a.k[b][c];}return -1;};$Xb.xo=function xo(a,b,c){if($Xb.bl(a,b)!=1)return 0;return 16-a.e[c]+((a.H[b]&384)==0||a.D[0][b]!=c?m_b:0)+(a.C[c]==1?SZb:0)+(a.e[c]==1?x$b:0)+((a.u[c]&3)==0?XZb:0)+((a.F[b]&64)!=0?0:512)+(a.C[c]!=6?256:0);};$Xb.yo=function yo(a,b,c,d,e,f){var g,h,i,j,k;$Xb.nu(a,1);if(e){$Xb.hk(e);e.K=false;}i=Sjb(UXb.llb,yZb,6,a.q,15,1);d==null?d=Sjb(UXb.Cwb,KZb,6,a.q,16,1):_Xb.JOb(d,d.length);i[0]=b;i[1]=c;d[b]=true;d[c]=true;h=1;j=1;while(h<=j){for(k=0;k<a.e[i[h]];k++){g=a.i[i[h]][k];if(g==b){if(h!=1)return -1;}if(!d[g]){d[g]=true;i[++j]=g;}}++h;}if(e){f==null&&(f=Sjb(UXb.llb,yZb,6,d.length,15,1));$Xb.un(a,e,d,false,f);$Xb.ek(e,f[b],0,0,-1,0);}d[b]=false;return j;};$Xb.zo=function zo(a,b,c){var d,e,f,g,h,i;$Xb.nu(a,1);f=Sjb(UXb.llb,yZb,6,a.f,15,1);i=Sjb(UXb.Cwb,KZb,6,a.f,16,1);f[0]=b;f[1]=c;i[b]=true;i[c]=true;e=1;g=1;while(e<=g){for(h=0;h<a.j[f[e]];h++){d=a.i[f[e]][h];if(d==b){if(e!=1)return -1;}if(!i[d]){i[d]=true;f[++g]=d;}}++e;}return g;};$Xb.Ao=function Ao(a,b,c){var d,e,f,g,h,i,j,k,l,m,n;if($Xb.bl(a,c)!=2&&!(c<a.g&&$Xb.Vr(a.p,c)))return -1;n=a.F[c]&3;if(n!=1&&n!=2)return -1;for(i=0;i<2;i++){d=a.D[i][c];e=a.D[1-i][c];m=-1;g=false;for(k=0;k<a.j[d];k++){f=a.i[d][k];f!=e&&(f==b?g=true:m=f);}if(g){l=-1;h=-1;for(j=0;j<a.j[e];j++){f=a.i[e][j];if(f!=d){if(l==-1)l=f;else if(f>l)h=f;else {h=l;l=f;}}}if(a.j[d]==2){if(a.j[e]==2)return n==2?l:-1;return n==2?l:h;}else {if(a.j[e]==2)return n==2^b<m?-1:l;return n==2^b<m?h:l;}}}return -1;};$Xb.Bo=function Bo(a){var b,c,d,e,f,g,h,i,j,k;g=$Xb.Cn(a);i=a.q;do--i;while(i>=0&&g[i]);for(b=0;b<i;b++){if(g[b]){$Xb.Sm(a,b,i);k=g[b];g[b]=g[i];g[i]=k;do--i;while(g[i]);}}a.f=i+1;if(a.q==a.f){a.g=a.r;return;}h=Sjb(UXb.Cwb,KZb,6,a.r,16,1);for(f=0;f<a.r;f++){c=a.D[0][f];d=a.D[1][f];(g[c]||g[d])&&(h[f]=true);}j=a.r;do--j;while(j>=0&&h[j]);for(e=0;e<j;e++){if(h[e]){$Xb.Tm(a,e,j);h[e]=false;do--j;while(h[j]);}}a.g=j+1;};$Xb.Co=function Co(a,b){var c;for(c=0;c<a.j[b];c++)if(a.s[a.i[b][c]]<0)return true;return false;};$Xb.Do=function Do(a,b){var c;for(c=0;c<a.j[b];c++)if(a.s[a.i[b][c]]>0)return true;return false;};$Xb.Eo=function Eo(a,b){var c;c=a.C[b];return c==3||c==11||c==19||c==37||c==55;};$Xb.Fo=function Fo(a,b){return (a.u[b]&SZb)!=0;};$Xb.Go=function Go(a,b){var c,d,e,f,g,h;$Xb.nu(a,1);for(g=0;g<2;g++){c=a.D[g][b];if(a.C[c]==7){d=a.D[1-g][b];for(h=0;h<a.j[d];h++){e=a.i[d][h];f=a.k[d][h];if((a.C[e]==7||a.C[e]==8||a.C[e]==16)&&$Xb.bl(a,f)>=2)return true;}}}return false;};$Xb.Ho=function Ho(a,b){return b<a.f&&$Xb.Ur(a.p,b);};$Xb.Io=function Io(a,b){return b<a.g&&$Xb.Vr(a.p,b);};$Xb.Jo=function Jo(a,b){var c,d,e,f,g,h;if(a.H[b]!=1||b<a.g&&$Xb.Vr(a.p,b)||(a.F[b]&64)!=0&&(!!a.p&&b<a.g?$Xb.Lr(a.p,b):0)<7)return false;c=a.D[0][b];if(!(c<a.f&&$Xb.Ur(a.p,c))||(!!a.p&&c<a.f?$Xb.Jr(a.p,c):0)<5)return false;d=a.D[1][b];if(!(d<a.f&&$Xb.Ur(a.p,d))||(!!a.p&&d<a.f?$Xb.Jr(a.p,d):0)<5)return false;e=$Xb.lo(a,c,d);f=$Xb.lo(a,d,c);if((!!a.p&&c<a.f?$Xb.Jr(a.p,c):0)>5&&(!!a.p&&d<a.f?$Xb.Jr(a.p,d):0)>5)return e+f>2;g=$Xb.uo(a,c,d);h=$Xb.uo(a,d,c);if(e==2&&h>=1)return true;if(f==2&&g>=1)return true;if(g==2&&(f>=1||h>=1))return true;if(h==2&&(e>=1||g>=1))return true;return false;};$Xb.Ko=function Ko(a,b){return a.o[b]==2&&a.j[b]==2&&a.n[b][0]==2&&a.n[b][1]==2&&a.C[b]<=7;};$Xb.Lo=function Lo(a,b){var c;c=a.C[b];return c==8||c==16||c==34||c==52;};$Xb.Mo=function Mo(a,b){return b<a.g&&($Xb.Zr(a.p,b)||a.H[b]==64);};$Xb.No=function No(a,b){var c;c=a.C[b];return c==12||c==20||c==38||c==56;};$Xb.Oo=function Oo(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p;if(a.C[b]!=7||a.j[b]==4)return false;if(b<a.f&&$Xb.Ur(a.p,b)||a.o[b]!=0||cxb(Jwb(a.B[b],v$b),0))return true;if(a.s[b]==1)return false;for(i=0;i<a.j[b];i++)if($Xb.Qn(a,a.k[b][i])==3)return false;g=0;for(j=0;j<a.j[b];j++){if(a.n[b][j]==1){d=a.C[a.i[b][j]];(d==8||d==9||d==17)&&++g;}}if(g==0){for(h=0;h<a.j[b];h++){e=a.i[b][h];if(a.o[e]!=0){if(e<a.f&&$Xb.Ur(a.p,e)){if((!!a.p&&e<a.f?$Xb.Jr(a.p,e):0)>=5){p=0;for(m=0;m<a.j[e];m++){o=a.i[e][m];o!=b&&$Xb.jo(a,o)>=3&&++p;}n=$Xb.jo(a,b);if(p==2&&n>=2||p==1&&n==3)continue;}return !c||!$Xb.To(a,b);}for(l=0;l<a.j[e];l++){if(a.n[e][l]==2||$Xb.Io(a,a.k[e][l]))return !c||!$Xb.To(a,b);}}}}if(g<2){for(h=0;h<a.j[b];h++){e=a.i[b][h];k=false;f=false;for(l=0;l<a.j[e];l++){if(a.i[e][l]!=b){a.n[e][l]!=1&&(a.C[a.i[e][l]]==7||a.C[a.i[e][l]]==8||a.C[a.i[e][l]]==16)&&(k=true);a.n[e][l]==1&&a.C[a.i[e][l]]==7&&(f=true);}}if(k&&(!f||g==0))return !c||!$Xb.To(a,b);}}return false;};$Xb.Po=function Po(a,b){var c;c=a.C[b];return c==9||c==17||c==35||c==53;};$Xb.Qo=function Qo(a,b){var c;c=a.C[b];return c==7||c==15||c==33;};$Xb.Ro=function Ro(a,b){var c,d,e,f,g,h;if($Xb.bl(a,b)!=1)return false;for(f=0;f<2;f++){c=a.D[f][b];h=a.D[1-f][b];while(a.o[c]==2&&a.j[c]==2&&a.C[c]<10){for(g=0;g<2;g++){d=a.i[c][g];if(d!=h){if(a.j[d]==1)return true;e=a.k[c][g];if($Xb.bl(a,e)==1&&e<b)return true;h=c;c=d;break;}}}if(a.j[c]==1)return true;}return false;};$Xb.So=function So(a,b,c,d,e){var f,g,h,i,j,k,l,m,n,o,p,q,r,s;m=Sjb(UXb.Cwb,KZb,6,a.g,16,1);m[e]=true;n=Sjb(UXb.llb,yZb,6,11,15,1);o=$Xb.mo(a,n,d,b,10,null,m);if(o==-1)return false;g=1;while(!$Xb.Wr(a.p,c,n[g]))++g;f=o-g;h=n[g];s=$Xb.Qr(a.p,c);if(s==6&&f==2&&g==3){if($Xb.Kn(a,n[1])>=3){r=$Xb.Nr(a.p,c);for(l=0;l<6;l++){if(b==r[l]){q=$Xb.fs(a.p,c,h==r[$Xb.fs(a.p,c,l+2)]?l-2:l+2);p=r[q];k=a.u[p]&r_b;if((k==0?0:k==XZb?2:k==x$b?3:4)>=3&&$Xb.po(a,n[1],p,2,null)==2)return true;break;}}}}i=a.o[h]==1||h<a.f&&$Xb.Ur(a.p,h)||$Xb.Oo(a,h,false);j=!i&&a.C[h]==7&&a.s[h]!=1;if(f==1&&!i&&!j&&s<=4&&g<=3)return true;switch(s){case 4:if(!i&&!j&&g<=4)return true;break;case 5:if(j){if(g<=3)return true;}else if(!i){if(g<=4)return true;}break;case 6:if(f==2){if(i){if(g<=4)return true;}else if(!j){if(g<=3)return true;}}else if(f==3){if(i){if(g<=6)return true;}else {if(g<=4)return true;}}break;case 7:if(f==3){if(g<=3)return true;}}return false;};$Xb.To=function To(a,b){var c,d,e,f,g;if(b<a.f&&$Xb.Ur(a.p,b)||a.o[b]!=0||cxb(Jwb(a.B[b],v$b),0)||(d=a.u[b]&r_b,(d==0?0:d==XZb?2:d==x$b?3:4)<3))return false;g=!!a.p&&b<a.f?$Xb.Jr(a.p,b):0;if(g>7)return false;f=0;while(f<a.p.i.a.length){if($Xb.Qr(a.p,f)==g&&$Xb.Wr(a.p,f,b))break;++f;}if(f>=XZb&&f==a.p.i.a.length)return false;for(e=0;e<a.j[b];e++){c=a.k[b][e];if(!$Xb.Xr(a.p,f,c)&&$Xb.So(a,b,f,a.i[b][e],c))return true;}return false;};$Xb.Uo=function Uo(a,b){return (a.u[b]&r_b)!=0;};$Xb.Vo=function Vo(a,b){return (a.F[b]&64)!=0;};$Xb.Wo=function Wo(a,b){return a.C[b]==1&&a.A[b]==0&&a.s[b]==0&&(a.t==null||a.t[b]==null);};$Xb.Xo=function Xo(a,b){return (a.u[b]&8)!=0;};$Xb.Yo=function Yo(a,b){return (a.F[b]&128)!=0;};$Xb.Zo=function Zo(a,b){return (a.u[b]&w$b)!=0;};$Xb.$o=function $o(a){var b,c,d,e,f,g,h,i,j,k,l;$Xb.nu(a,1);$Xb._o(a);j=false;for(c=0;c<a.f;c++){if(a.C[c]==7&&a.s[c]==0){l=$Xb.ko(a,c);if(l==4){for(k=0;k<a.j[c];k++){h=a.i[c][k];if(a.n[c][k]==1&&a.C[h]==8&&a.j[h]==1&&a.s[h]==0){j=true;++a.s[c];--a.s[h];break;}}}else if(l==5){for(k=0;k<a.j[c];k++){h=a.i[c][k];i=a.k[c][k];if(a.n[c][k]==2&&a.C[h]==8){j=true;++a.s[c];--a.s[h];a.H[i]=1;break;}if(a.n[c][k]==3&&a.C[h]==7){j=true;++a.s[c];--a.s[h];a.H[i]=2;break;}}}}}g=false;for(f=0;f<a.g;f++){for(k=0;k<2;k++){if($Xb.Cl(a,a.D[k][f])){b=a.D[1-k][f];e=a.C[b];if(e==3||e==11||e==19||e==37||e==55||(d=a.C[b],d==12||d==20||d==38||d==56)){if($Xb.bl(a,f)==1){++a.s[b];--a.s[a.D[k][f]];a.H[f]=512;g=true;}else if(a.H[f]==32){a.H[f]=512;g=true;}}break;}}}if(g){$Xb.ik(a);j=true;}j&&(a.T=0);return j;};$Xb._o=function _o(a){var b;for(b=0;b<a.g;b++)if(a.H[b]==64)return $Xb.je(new $Xb.te(a),null,false);return false;};$Xb.ap=function ap(a,b,c){var d,e,f,g,h,i,j,k;j=-1;e=0;for(h=0;h<2;h++){d=a.i[b][h];for(i=0;i<a.e[d];i++){f=a.i[d][i];if(f!=b){g=a.k[d][i];k=$Xb.xo(a,g,f);if(e<k&&(!c||!(a.H[g]==257||a.H[g]==129))){e=k;j=g;}}}}return j;};$Xb.bp=function bp(a,b){var c,d,e,f,g,h,i,j;i=-1;d=0;for(g=0;g<2;g++){c=a.D[g][b];for(h=0;h<a.e[c];h++){e=a.i[c][h];if(e!=a.D[1-g][b]){f=a.k[c][h];j=$Xb.xo(a,f,e);if(d<j){d=j;i=f;}}}}return i;};$Xb.cp=function cp(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A;d=a.e[b];e=Sjb(UXb.jlb,wZb,6,d,15,1);for(q=0;q<d;q++)e[q]=$Xb.Uk(a,b,a.i[b][q]);for(r=1;r<d;r++){for(u=0;u<r;u++){f=$wnd.Math.abs($Xb.gn(e[r],e[u]));if(f<0.08||f>u_b){g=0;h=0;for(v=0;v<d;v++){if(v!=r&&v!=u){g+=$wnd.Math.abs(yYb.i6(e[r],e[v]));h+=$wnd.Math.abs(yYb.i6(e[u],e[v]));}}j=g<h?a.k[b][r]:a.k[b][u];if($Xb.bl(a,j)==1&&(!c||!(a.H[j]==257||a.H[j]==129)))return j;}}}t=Sjb(UXb.Cwb,KZb,6,d,16,1);for(s=0;s<d;s++){k=-10;l=10;for(u=0;u<d;u++){if(u!=s){o=yYb.i6(e[s],e[u]);o<0?k<o&&(k=o):l>o&&(l=o);}t[s]=l-k<PZb;}}w=-1;i=0;for(p=0;p<d;p++){m=a.i[b][p];n=a.k[b][p];A=$Xb.xo(a,n,m);t[p]&&(A+=RZb);if(i<A&&(!c||!(a.H[n]==257||a.H[n]==129))){i=A;w=n;}}return w;};$Xb.dp=function dp(a,b){var c,d,e,f;$Xb.nu(a,b?15:1);a.q=a.f;a.r=a.g;for(d=0;d<a.f;d++){if(a.e[d]!=a.j[d]){c=$Xb.eo(a,d,false);a.e[d]=a.j[d];if(c!=-1){f=$Xb.eo(a,d,true);if(c!=f){e=((a.u[d]&g_b)>>>27)-1;(e==-1||e<c)&&$Xb.am(a,d,c);}}}}b&&$Xb.jp(a);a.T=0;};$Xb.ep=function ep(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A;if(a.j[b]!=2||a.n[b][0]!=2||a.n[b][1]!=2||a.j[a.i[b][0]]<2||a.j[a.i[b][1]]<2||a.o[a.i[b][0]]!=1||a.o[a.i[b][1]]!=1){$Xb.nm(a,b,0,false);return;}v=-1;u=-1;t=-1;q=-1;f=0;for(l=0;l<2;l++){d=a.i[b][l];for(o=0;o<a.e[d];o++){g=a.i[d][o];if(g!=b){h=a.k[d][o];w=$Xb.xo(a,h,g);if(f<w){f=w;u=g;v=h;t=d;q=a.i[b][1-l];}}}}if(u==-1)return;for(m=0;m<2;m++){d=a.i[b][m];for(o=0;o<a.e[d];o++){g=a.i[d][o];h=a.k[d][o];g!=b&&a.D[0][h]==d&&(a.H[h]=1);}}if(a.D[1][v]!=u){a.D[0][v]=a.D[1][v];a.D[1][v]=u;}i=gZb;for(n=0;n<a.j[t];n++){g=a.i[t][n];g!=b&&i>g&&(i=g);}r=Sjb(UXb.llb,yZb,6,2,15,1);s=0;for(k=0;k<a.j[q];k++){g=a.i[q][k];g!=b&&(r[s++]=g);}c=$Xb.fn(a.J[b].a,a.J[b].b,a.J[q].a,a.J[q].b);e=0;if(s==2){if(r[0]>r[1]){A=r[0];r[0]=r[1];r[1]=A;}j=$Xb.gn(c,$Xb.Uk(a,q,r[0]));p=$Xb.gn(c,$Xb.Uk(a,q,r[1]));e=j-p;}else {e=$Xb.gn(c,$Xb.Uk(a,q,r[0]));}e<0^(a.u[b]&3)==1^i==u?a.H[v]=257:a.H[v]=129;};$Xb.fp=function fp(a,b,c,d){var e,f,g,h,i,j;e=a.e[b];h=Sjb(UXb.llb,yZb,6,e,15,1);j=$Xb.Yn(a,b,c,d,h);if(j==3)return false;g=(a.u[b]&3)==j?257:129;for(i=0;i<e;i++){if((h[i]&1)==1){f=a.k[b][c[i]];a.H[f]=g;if(a.D[0][f]!=b){a.D[1][f]=a.D[0][f];a.D[0][f]=b;}}}return true;};$Xb.gp=function gp(a,b){a.T|=248&(8|b);};$Xb.hp=function hp(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q;$Xb.tn(a,b);if((a.u[b]&3)==0||(a.u[b]&3)==3)return;if(a.o[b]==2&&a.j[b]==2){$Xb.ep(a,b);return;}if(a.j[b]<3||a.j[b]>4){$Xb.nm(a,b,0,false);return;}c=a.e[b];o=false;for(g=0;g<c;g++){if($Xb.bl(a,a.k[b][g])==1){o=true;break;}}if(!o)return;p=$Xb.vo(a,b);d=Sjb(UXb.jlb,wZb,6,c,15,1);for(h=0;h<c;h++)d[h]=$Xb.Uk(a,a.i[b][p[h]],b);for(i=0;i<c;i++)a.D[0][a.k[b][i]]==b&&$Xb.bl(a,a.k[b][i])==1&&(a.H[a.k[b][i]]=1);if((!!a.p&&b<a.f?$Xb.Jr(a.p,b):0)<=24&&$Xb.fp(a,b,p,d))return;m=$Xb.cp(a,b,true);if(a.D[0][m]!=b){a.D[1][m]=a.D[0][m];a.D[0][m]=b;}n=-1;for(j=0;j<c;j++){if(m==a.k[b][p[j]]){n=j;break;}}q=$jb(Mjb(UXb.llb,2),Q$b,8,0,[$jb(Mjb(UXb.llb,1),yZb,6,15,[2,1,2,1]),$jb(Mjb(UXb.llb,1),yZb,6,15,[1,2,2,1]),$jb(Mjb(UXb.llb,1),yZb,6,15,[1,1,2,2]),$jb(Mjb(UXb.llb,1),yZb,6,15,[2,1,1,2]),$jb(Mjb(UXb.llb,1),yZb,6,15,[2,2,1,1]),$jb(Mjb(UXb.llb,1),yZb,6,15,[1,2,1,2])]);for(f=1;f<c;f++)d[f]<d[0]&&(d[f]+=OZb);if(c==3){k=false;switch(n){case 0:k=d[1]<d[2]&&d[2]-d[1]<PZb||d[1]>d[2]&&d[1]-d[2]>PZb;break;case 1:k=d[2]-d[0]>PZb;break;case 2:k=d[1]-d[0]<PZb;}e=(a.u[b]&3)==1^k?257:129;}else {l=0;d[1]<=d[2]&&d[2]<=d[3]?l=0:d[1]<=d[3]&&d[3]<=d[2]?l=1:d[2]<=d[1]&&d[1]<=d[3]?l=2:d[2]<=d[3]&&d[3]<=d[1]?l=3:d[3]<=d[1]&&d[1]<=d[2]?l=4:d[3]<=d[2]&&d[2]<=d[1]&&(l=5);e=(a.u[b]&3)==1^q[l][n]==1?129:257;}a.H[m]=e;};$Xb.ip=function ip(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A;if((a.F[b]&3)==0||(a.F[b]&3)==3||!$Xb.Jo(a,b))return;v=-1;t=-1;u=-1;s=-1;e=0;for(l=0;l<2;l++){d=a.D[l][b];for(o=0;o<a.e[d];o++){h=a.k[d][o];if(h!=b&&$Xb.bl(a,h)==1){g=a.i[d][o];w=$Xb.xo(a,h,g);if(e<w){e=w;t=g;v=h;u=d;s=a.D[1-l][b];}}}}if(t==-1)return;for(m=0;m<2;m++){for(o=0;o<a.e[a.D[m][b]];o++){h=a.k[a.D[m][b]][o];h!=b&&$Xb.bl(a,h)==1&&(a.H[h]=1);}}if(a.D[1][v]!=t){a.D[0][v]=a.D[1][v];a.D[1][v]=t;}i=gZb;for(n=0;n<a.j[u];n++){g=a.i[u][n];a.k[u][n]!=b&&i>g&&(i=g);}q=Sjb(UXb.llb,yZb,6,2,15,1);r=0;for(k=0;k<a.j[s];k++)a.k[s][k]!=b&&(q[r++]=a.i[s][k]);f=$Xb.fn(a.J[u].a,a.J[u].b,a.J[s].a,a.J[s].b);c=0;if(r==2){if(q[0]>q[1]){A=q[0];q[0]=q[1];q[1]=A;}j=$Xb.gn(f,$Xb.Uk(a,s,q[0]));p=$Xb.gn(f,$Xb.Uk(a,s,q[1]));c=j-p;}else {c=$Xb.gn(f,$Xb.Uk(a,s,q[0]));}c<0^(a.F[b]&3)==2^i==t?a.H[v]=257:a.H[v]=129;};$Xb.jp=function jp(a){var b,c,d,e;$Xb.nu(a,7);for(d=0;d<a.g;d++)(a.H[d]==257||a.H[d]==129)&&(a.H[d]=1);for(b=0;b<a.f;b++)$Xb.hp(a,b);for(e=0;e<a.g;e++)$Xb.ip(a,e);for(c=0;c<a.g;c++)a.H[c]==2&&(a.F[c]&3)==3&&(a.H[c]=386);};$Xb.kp=function kp(b,c){var d,e,f,g,h,i,j,k,l,m;i=Sjb(UXb.llb,yZb,6,b.q,15,1);h=$Xb.$n(b,i,false,c);if(h<=1)return null;j=Sjb(UXb.llb,yZb,6,h,15,1);for(e=0;e<b.f;e++)++j[i[e]];l=0;m=j[0];for(k=1;k<h;k++){if(m<j[k]){m=j[k];l=k;}}for(d=0;d<b.q;d++)i[d]!=l&&(b.C[d]=-1);for(g=0;g<b.r;g++)(!c&&b.H[g]==32||i[b.D[0][g]]!=l)&&(b.H[g]=512);f=$Xb.ik(b);b.T=0;try{$Xb.rn(b,true,true);}catch(a){a=Gwb(a);if(!Zkb(a,19))throw Hwb(a);}return f;};$Xb.lp=function lp(a,b){if((a.u[b]&g_b)!=0)return true;if(a.C[b]==1)return false;return $Xb.Hl(a,b)||a.C[b]==13||a.C[b]>=171;};$Xb.mp=function mp(a){var b,c,d,e,f,g,h,i,j,k;f=$Xb.Sk(a,a.q,a.r,$Xb.Rj);g=f*f/16;for(d=1;d<a.q;d++){for(e=0;e<d;e++){i=a.J[e].a-a.J[d].a;j=a.J[e].b-a.J[d].b;k=a.J[e].c-a.J[d].c;if(i*i+j*j+k*k<g)throw Hwb(new VXb.aA('The distance between two atoms is too close.'));}}$Xb.nu(a,1);b=0;for(c=0;c<a.f;c++){if($Xb.ko(a,c)>(h=$Xb.kl(a,c),h+$Xb.il(a,c,h)))throw Hwb(new VXb.aA('atom valence exceeded'));b+=a.s[c];}if(b!=0)throw Hwb(new VXb.aA('unbalanced atom charge'));};$Xb.np=function np(a,b,c){var d;d=$Xb.Vm(a,b,c);if(d&&c==386){$Xb.nu(a,7);d=d&(a.F[b]&128)==0;}return d;};$Xb.op=function op(){$Xb.Ym.call(this);};$Xb.pp=function pp(a,b){$Xb.Zm.call(this,a,b);};$Xb.qp=function qp(a){$Xb.Zm.call(this,!a?256:a.M,!a?256:a.N);!!a&&$Xb.mk(a,this);};xxb(97,113,{97:1,113:1,4:1});_.Mb=function rp(a){$Xb.wn(this,a);};_.Lb=function sp(a){return $Xb.Mo(this,a);};_.f=0;_.g=0;UXb.Jlb=VFb(97);$Xb.tp=function tp(a,b){return $wnd.Math.pow(10,$wnd.Math.log(2000)*$wnd.Math.LOG10E*a/(b-1)-1);};$Xb.up=function up(a,b){var c,d;c=b;d=0;while(b!=0){if(a.d==0){a.f=(a.c[++a.e]&63)<<11;a.d=6;}d|=(oZb&a.f)>>16-c+b;a.f<<=1;--b;--a.d;}return d;};$Xb.vp=function vp(a,b,c){a.d=6;a.e=c;a.c=b;a.f=(b[a.e]&63)<<11;};$Xb.wp=function wp(a,b){var c,d,e,f;d=b/2|0;e=a>=d;e&&(a-=d);f=b/32|0;c=f*a/(d-a);return e?-c:c;};$Xb.xp=function xp(a,b){var c;return b==null||YXb.LTb(b).length==0?null:$Xb.zp(a,YXb.mTb((c=b,YXb.hTb(),c)),null);};$Xb.yp=function yp(a,b,c){var d,e;return b==null?null:$Xb.zp(a,YXb.mTb((e=b,YXb.hTb(),e)),c==null?null:YXb.mTb((d=c,d)));};$Xb.zp=function zp(a,b,c){var d,e,f,g,h;$Xb.vp(a,b,0);d=$Xb.up(a,4);g=$Xb.up(a,4);d>8&&(d=g);e=$Xb.up(a,d);f=$Xb.up(a,g);h=new $Xb.Gu(e,f);$Xb.Dp(a,h,b,c,0);return h;};$Xb.Ap=function Ap(a,b,c){var d,e,f,g;if(c==null||YXb.LTb(c).length==0){$Xb.Cp(a,b,null,null);return;}d=VXb.HHb(c,UHb(32));d>0&&d<YXb.LTb(c).length-1?$Xb.Cp(a,b,YXb.mTb((f=(YXb.FTb(0,d,YXb.LTb(c).length),YXb.LTb(c).substr(0,d)),YXb.hTb(),f)),YXb.mTb((g=(YXb.GTb(d+1,YXb.LTb(c).length+1),YXb.LTb(c).substr(d+1)),g))):$Xb.Cp(a,b,YXb.mTb((e=c,YXb.hTb(),e)),null);};$Xb.Bp=function Bp(a,b,c,d){var e,f,g,h;f=c==null?null:YXb.mTb((h=c,YXb.hTb(),h));e=d==null?null:YXb.mTb((g=d,YXb.hTb(),g));$Xb.Cp(a,b,f,e);};$Xb.Cp=function Cp(a,b,c,d){if(c==null||c.length==0){$Xb.hk(b);return;}$Xb.Dp(a,b,c,d,0);};$Xb.Dp=function Dp(b,c,d,e,f){var g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,$,ab,bb,cb,db,eb,fb,gb,hb,ib,jb,kb,lb,mb,nb,ob,pb,qb,rb,sb,tb,ub,vb,wb,xb,yb,zb,Ab,Bb,Cb,Db,Eb,Fb,Gb,Hb,Ib,Jb,Kb,Lb,Mb,Nb,Ob,Pb,Qb,Rb,Sb,Tb,Ub,Vb,Wb,Xb,Yb,Zb,$b,_b,ac,bc,cc,dc,ec,fc,gc,hc,ic,jc,kc,lc,mc,nc,oc,pc,qc,rc,sc,tc,uc,vc,wc,xc,yc,zc,Ac;$Xb.hk(c);if(d==null||0>=d.length)return;b.g=c;uc=8;e!=null&&(f<0||f>=e.length)&&(e=null);$Xb.vp(b,d,0);i=$Xb.up(b,4);B=$Xb.up(b,4);if(i>8){uc=i;i=B;}if(i==0){$Xb.Hm(b.g,$Xb.up(b,1)==1);return;}j=$Xb.up(b,i);k=$Xb.up(b,B);ic=$Xb.up(b,i);mc=$Xb.up(b,i);lc=$Xb.up(b,i);O=$Xb.up(b,i);for(o=0;o<j;o++)$Xb.Uj(b.g,6);for(kb=0;kb<ic;kb++)$Xb.vm(b.g,$Xb.up(b,i),7);for(lb=0;lb<mc;lb++)$Xb.vm(b.g,$Xb.up(b,i),8);for(wb=0;wb<lc;wb++)$Xb.vm(b.g,$Xb.up(b,i),$Xb.up(b,8));for(Hb=0;Hb<O;Hb++)$Xb.cm(b.g,$Xb.up(b,i),$Xb.up(b,4)-8);P=1+k-j;V=$Xb.up(b,4);A=0;$Xb.sm(b.g,0,0);$Xb.tm(b.g,0,0);$Xb.um(b.g,0,0);W=e!=null&&e[f]>=39;tc=0;wc=0;yc=0;Ac=0;R=false;S=false;if(W){if(e.length>2*j-2&&e[2*j-2]==39||e.length>3*j-3&&e[3*j-3]==39){S=true;R=e.length==3*j-3+9;_b=R?3*j-3:2*j-2;w=86*(e[_b+1]-40)+e[_b+2]-40;tc=$wnd.Math.pow(10,w/2000-1);_b+=2;vc=86*(e[_b+1]-40)+e[_b+2]-40;wc=$wnd.Math.pow(10,vc/1500-1);_b+=2;xc=86*(e[_b+1]-40)+e[_b+2]-40;yc=$wnd.Math.pow(10,xc/1500-1);if(R){_b+=2;zc=86*(e[_b+1]-40)+e[_b+2]-40;Ac=$wnd.Math.pow(10,zc/1500-1);}}else {R=e.length==3*j-3;}}if(b.Nb()&&R){e=null;W=false;}for(Sb=1;Sb<j;Sb++){X=$Xb.up(b,V);if(X==0){if(W){$Xb.sm(b.g,Sb,$Xb.Nk(b.g,0)+8*(e[Sb*2-2]-83));$Xb.tm(b.g,Sb,$Xb.Ok(b.g,0)+8*(e[Sb*2-1]-83));R&&$Xb.um(b.g,Sb,$Xb.Pk(b.g,0)+8*(e[2*j-3+Sb]-83));}++P;continue;}A+=X-1;if(W){$Xb.sm(b.g,Sb,$Xb.Nk(b.g,A)+e[Sb*2-2]-83);$Xb.tm(b.g,Sb,$Xb.Ok(b.g,A)+e[Sb*2-1]-83);R&&$Xb.um(b.g,Sb,$Xb.Pk(b.g,A)+(e[2*j-3+Sb]-83));}$Xb.Wj(b.g,A,Sb,1);}for(Wb=0;Wb<P;Wb++)$Xb.Wj(b.g,$Xb.up(b,i),$Xb.up(b,i),1);ac=Sjb(UXb.Cwb,KZb,6,k,16,1);for(I=0;I<k;I++){J=$Xb.up(b,2);switch(J){case 0:ac[I]=true;break;case 2:$Xb.Fm(b.g,I,2);break;case 3:$Xb.Fm(b.g,I,4);}}h=$Xb.up(b,i);for(Xb=0;Xb<h;Xb++){n=$Xb.up(b,i);if(uc==8){nc=$Xb.up(b,2);if(nc==3){$Xb.hm(b.g,n,1,0);$Xb.nm(b.g,n,1,false);}else {$Xb.nm(b.g,n,nc,false);}}else {nc=$Xb.up(b,3);switch(nc){case 4:$Xb.nm(b.g,n,1,false);$Xb.hm(b.g,n,1,$Xb.up(b,3));break;case 5:$Xb.nm(b.g,n,2,false);$Xb.hm(b.g,n,1,$Xb.up(b,3));break;case 6:$Xb.nm(b.g,n,1,false);$Xb.hm(b.g,n,2,$Xb.up(b,3));break;case 7:$Xb.nm(b.g,n,2,false);$Xb.hm(b.g,n,2,$Xb.up(b,3));break;default:$Xb.nm(b.g,n,nc,false);}}}uc==8&&$Xb.up(b,1)==0&&(b.g.L=true);g=$Xb.up(b,B);for(Yb=0;Yb<g;Yb++){D=$Xb.up(b,B);if($Xb.el(b.g,D)==1){nc=$Xb.up(b,3);switch(nc){case 4:$Xb.Cm(b.g,D,1,false);$Xb.zm(b.g,D,1,$Xb.up(b,3));break;case 5:$Xb.Cm(b.g,D,2,false);$Xb.zm(b.g,D,1,$Xb.up(b,3));break;case 6:$Xb.Cm(b.g,D,1,false);$Xb.zm(b.g,D,2,$Xb.up(b,3));break;case 7:$Xb.Cm(b.g,D,2,false);$Xb.zm(b.g,D,2,$Xb.up(b,3));break;default:$Xb.Cm(b.g,D,nc,false);}}else {$Xb.Cm(b.g,D,$Xb.up(b,2),false);}}$Xb.Hm(b.g,$Xb.up(b,1)==1);m=null;kc=0;while($Xb.up(b,1)==1){U=kc+$Xb.up(b,4);switch(U){case 0:jc=$Xb.up(b,i);for(Zb=0;Zb<jc;Zb++){n=$Xb.up(b,i);$Xb.om(b.g,n,x$b,true);}break;case 1:jc=$Xb.up(b,i);for($b=0;$b<jc;$b++){n=$Xb.up(b,i);gc=$Xb.up(b,8);$Xb.mm(b.g,n,gc);}break;case 2:jc=$Xb.up(b,B);for(mb=0;mb<jc;mb++){$Xb.up(b,B);}break;case 3:jc=$Xb.up(b,i);for(nb=0;nb<jc;nb++){n=$Xb.up(b,i);$Xb.om(b.g,n,SZb,true);}break;case 4:jc=$Xb.up(b,i);for(ob=0;ob<jc;ob++){n=$Xb.up(b,i);rc=fxb(Vwb($Xb.up(b,4)),3);$Xb.om(b.g,n,rc,true);}break;case 5:jc=$Xb.up(b,i);for(pb=0;pb<jc;pb++){n=$Xb.up(b,i);l=fxb(Vwb($Xb.up(b,2)),1);$Xb.om(b.g,n,l,true);}break;case 6:jc=$Xb.up(b,i);for(qb=0;qb<jc;qb++){n=$Xb.up(b,i);$Xb.om(b.g,n,1,true);}break;case 7:jc=$Xb.up(b,i);for(rb=0;rb<jc;rb++){n=$Xb.up(b,i);hb=fxb(Vwb($Xb.up(b,4)),7);$Xb.om(b.g,n,hb,true);}break;case 8:jc=$Xb.up(b,i);for(sb=0;sb<jc;sb++){n=$Xb.up(b,i);t=$Xb.up(b,4);r=Sjb(UXb.llb,yZb,6,t,15,1);for(bc=0;bc<t;bc++){s=$Xb.up(b,8);r[bc]=s;}$Xb.im(b.g,n,r);}break;case 9:jc=$Xb.up(b,B);for(tb=0;tb<jc;tb++){D=$Xb.up(b,B);rc=$Xb.up(b,2)<<7;$Xb.Em(b.g,D,rc,true);}break;case 10:jc=$Xb.up(b,B);for(ub=0;ub<jc;ub++){D=$Xb.up(b,B);L=$Xb.up(b,5);$Xb.Em(b.g,D,L,true);}break;case 11:jc=$Xb.up(b,i);for(vb=0;vb<jc;vb++){n=$Xb.up(b,i);$Xb.om(b.g,n,w$b,true);}break;case 12:jc=$Xb.up(b,B);for(xb=0;xb<jc;xb++){D=$Xb.up(b,B);M=$Xb.up(b,8)<<9;$Xb.Em(b.g,D,M,true);}break;case 13:jc=$Xb.up(b,i);for(yb=0;yb<jc;yb++){n=$Xb.up(b,i);oc=fxb(Vwb($Xb.up(b,3)),14);$Xb.om(b.g,n,oc,true);}break;case 14:jc=$Xb.up(b,i);for(zb=0;zb<jc;zb++){n=$Xb.up(b,i);hc=fxb(Vwb($Xb.up(b,5)),17);$Xb.om(b.g,n,hc,true);}break;case 15:case 31:kc+=16;break;case 16:jc=$Xb.up(b,i);for(Ab=0;Ab<jc;Ab++){n=$Xb.up(b,i);qc=fxb(Vwb($Xb.up(b,3)),22);$Xb.om(b.g,n,qc,true);}break;case 17:jc=$Xb.up(b,i);for(Bb=0;Bb<jc;Bb++){n=$Xb.up(b,i);$Xb.am(b.g,n,$Xb.up(b,4));}break;case 18:jc=$Xb.up(b,i);fc=$Xb.up(b,4);for(Cb=0;Cb<jc;Cb++){n=$Xb.up(b,i);T=$Xb.up(b,fc);cc=Sjb(UXb.hlb,S$b,6,T,15,1);for(bc=0;bc<T;bc++)cc[bc]=$Xb.up(b,7)<<24>>24;$Xb.fm(b.g,n,VXb.WHb(YXb.kTb(cc,0,(dc=cc.length,YXb.hTb(),dc))));}break;case 19:jc=$Xb.up(b,i);for(Db=0;Db<jc;Db++){n=$Xb.up(b,i);N=fxb(Vwb($Xb.up(b,3)),25);$Xb.om(b.g,n,N,true);}break;case 20:jc=$Xb.up(b,B);for(Eb=0;Eb<jc;Eb++){D=$Xb.up(b,B);qc=$Xb.up(b,3)<<17;$Xb.Em(b.g,D,qc,true);}break;case 21:jc=$Xb.up(b,i);for(Fb=0;Fb<jc;Fb++){n=$Xb.up(b,i);$Xb.pm(b.g,n,$Xb.up(b,2)<<4);}break;case 22:jc=$Xb.up(b,i);for(Gb=0;Gb<jc;Gb++){n=$Xb.up(b,i);$Xb.om(b.g,n,v$b,true);}break;case 23:jc=$Xb.up(b,B);for(Ib=0;Ib<jc;Ib++){D=$Xb.up(b,B);$Xb.Em(b.g,D,W$b,true);}break;case 24:jc=$Xb.up(b,B);for(Jb=0;Jb<jc;Jb++){D=$Xb.up(b,B);l=$Xb.up(b,2)<<21;$Xb.Em(b.g,D,l,true);}break;case 25:for(Kb=0;Kb<j;Kb++)$Xb.up(b,1)==1&&$Xb.qm(b.g,Kb,true);break;case 26:jc=$Xb.up(b,B);m=Sjb(UXb.llb,yZb,6,jc,15,1);for(Lb=0;Lb<jc;Lb++)m[Lb]=$Xb.up(b,B);break;case 27:jc=$Xb.up(b,i);for(Mb=0;Mb<jc;Mb++){n=$Xb.up(b,i);$Xb.om(b.g,n,LZb,true);}break;case 28:jc=$Xb.up(b,B);for(Nb=0;Nb<jc;Nb++)$Xb.Fm(b.g,$Xb.up(b,B),32);break;case 29:jc=$Xb.up(b,i);for(Ob=0;Ob<jc;Ob++){n=$Xb.up(b,i);gb=fxb(Vwb($Xb.up(b,2)),30);$Xb.om(b.g,n,gb,true);}break;case 30:jc=$Xb.up(b,i);for(Pb=0;Pb<jc;Pb++){n=$Xb.up(b,i);qc=fxb(Vwb($Xb.up(b,7)),32);$Xb.om(b.g,n,qc,true);}break;case 32:jc=$Xb.up(b,i);for(Qb=0;Qb<jc;Qb++){n=$Xb.up(b,i);sc=fxb(Vwb($Xb.up(b,2)),44);$Xb.om(b.g,n,sc,true);}break;case 33:jc=$Xb.up(b,i);for(Rb=0;Rb<jc;Rb++){n=$Xb.up(b,i);bb=fxb(Vwb($Xb.up(b,5)),39);$Xb.om(b.g,n,bb,true);}break;case 34:jc=$Xb.up(b,i);for(Tb=0;Tb<jc;Tb++){n=$Xb.up(b,i);$Xb.om(b.g,n,VZb,true);}break;case 35:jc=$Xb.up(b,B);for(Ub=0;Ub<jc;Ub++){D=$Xb.up(b,B);$Xb.Em(b.g,D,Z$b,true);}break;case 36:jc=$Xb.up(b,B);for(Vb=0;Vb<jc;Vb++){D=$Xb.up(b,B);K=$Xb.up(b,2)<<5;$Xb.Em(b.g,D,K,true);}break;case 37:jc=$Xb.up(b,B);for(jb=0;jb<jc;jb++){D=$Xb.up(b,B);K=$Xb.up(b,1)==0?8:16;$Xb.Fm(b.g,D,K);}}}$Xb.je(new $Xb.te(b.g),ac,false);if(m!=null)for(F=m,G=0,H=F.length;G<H;++G){D=F[G];$Xb.Fm(b.g,D,$Xb.el(b.g,D)==2?4:2);}if(e==null&&!b.i&&d.length>b.e+1&&(d[b.e+1]==32||d[b.e+1]==9)){e=d;f=b.e+2;}if(e!=null){try{if(e[f]==33||e[f]==35){$Xb.vp(b,e,f+1);R=$Xb.up(b,1)==1;S=$Xb.up(b,1)==1;pc=2*$Xb.up(b,4);C=1<<pc;eb=0;D=0;for(p=1;p<j;p++){if(D<k&&$Xb.Vk(b.g,1,D)==p){eb=$Xb.Vk(b.g,0,D++);db=1;}else {eb=0;db=8;}$Xb.sm(b.g,p,$Xb.Nk(b.g,eb)+db*($Xb.up(b,pc)-(C/2|0)));$Xb.tm(b.g,p,$Xb.Ok(b.g,eb)+db*($Xb.up(b,pc)-(C/2|0)));R&&$Xb.um(b.g,p,$Xb.Pk(b.g,eb)+db*($Xb.up(b,pc)-(C/2|0)));}if(e[f]==35){ib=0;fb=Sjb(UXb.llb,yZb,6,j,15,1);for(q=0;q<j;q++)ib+=fb[q]=$Xb.fo(b.g,q);for(n=0;n<j;n++){for(jb=0;jb<fb[n];jb++){hb=$Xb.Uj(b.g,1);$Xb.Wj(b.g,n,hb,1);$Xb.sm(b.g,hb,$Xb.Nk(b.g,n)+($Xb.up(b,pc)-(C/2|0)));$Xb.tm(b.g,hb,$Xb.Ok(b.g,n)+($Xb.up(b,pc)-(C/2|0)));R&&$Xb.um(b.g,hb,$Xb.Pk(b.g,n)+($Xb.up(b,pc)-(C/2|0)));}}j+=ib;k+=ib;}v=R?1.5:($Xb.Sj(),$Xb.Sj(),$Xb.Rj);u=$Xb.Sk(b.g,j,k,v);if(S){tc=$Xb.tp($Xb.up(b,pc),C);wc=tc*$Xb.wp($Xb.up(b,pc),C);yc=tc*$Xb.wp($Xb.up(b,pc),C);R&&(Ac=tc*$Xb.wp($Xb.up(b,pc),C));db=tc/u;for(n=0;n<j;n++){$Xb.sm(b.g,n,wc+db*$Xb.Nk(b.g,n));$Xb.tm(b.g,n,yc+db*$Xb.Ok(b.g,n));R&&$Xb.um(b.g,n,Ac+db*$Xb.Pk(b.g,n));}}else {tc=1.5;db=tc/u;for(n=0;n<j;n++){$Xb.sm(b.g,n,db*$Xb.Nk(b.g,n));$Xb.tm(b.g,n,db*$Xb.Ok(b.g,n));R&&$Xb.um(b.g,n,db*$Xb.Pk(b.g,n));}}}else {R&&!S&&tc==0&&(tc=1.5);if(tc!=0&&b.g.r!=0){u=0;for(D=0;D<b.g.r;D++){Y=$Xb.Nk(b.g,$Xb.Vk(b.g,0,D))-$Xb.Nk(b.g,$Xb.Vk(b.g,1,D));Z=$Xb.Ok(b.g,$Xb.Vk(b.g,0,D))-$Xb.Ok(b.g,$Xb.Vk(b.g,1,D));$=R?$Xb.Pk(b.g,$Xb.Vk(b.g,0,D))-$Xb.Pk(b.g,$Xb.Vk(b.g,1,D)):0;u+=$wnd.Math.sqrt(Y*Y+Z*Z+$*$);}u/=b.g.r;cb=tc/u;for(n=0;n<b.g.q;n++){$Xb.sm(b.g,n,$Xb.Nk(b.g,n)*cb+wc);$Xb.tm(b.g,n,$Xb.Ok(b.g,n)*cb+yc);R&&$Xb.um(b.g,n,$Xb.Pk(b.g,n)*cb+Ac);}}}}catch(a){a=Gwb(a);if(Zkb(a,19)){ab=a;VXb.Jz(ab,(VXb.oIb(),VXb.nIb),'');'Faulty id-coordinates:'+VXb.Nz(ab,ab.Wb())+' '+VXb.WHb(YXb.kTb(d,0,(ec=d.length,YXb.hTb(),ec)))+' '+VXb.WHb(YXb.kTb(e,0,(dc=e.length,dc)));e=null;R=false;}else throw Hwb(a);}}Q=e!=null&&!R;if(Q||b.Nb()){$Xb.nu(b.g,7);for(D=0;D<b.g.g;D++)$Xb.bl(b.g,D)==2&&!$Xb.Yo(b.g,D)&&$Xb.cl(b.g,D)==0&&$Xb.Dm(b.g,D);}$Xb.gp(b.g,0);if(!Q&&b.Nb()){try{b.Ob(b.g);Q=true;}catch(a){a=Gwb(a);if(Zkb(a,19)){ab=a;VXb.Jz(ab,(VXb.oIb(),VXb.nIb),'');'2D-coordinate creation failed:'+VXb.Nz(ab,ab.Wb())+' '+VXb.WHb(YXb.kTb(d,0,(dc=d.length,YXb.hTb(),dc)));}else throw Hwb(a);}}if(Q){$Xb.jp(b.g);$Xb.Au(b.g);}else R||$Xb.gp(b.g,0);};$Xb.Ep=function Ep(a,b){var c,d,e,f,g,h;if(b.length<=0||b[0]<64)return;$Xb.vp(a,b,0);h=$Xb.up(a,4);e=$Xb.up(a,1)==1;f=$Xb.up(a,1)==1;for(c=0;c<a.g.f;c++){g=$Xb.up(a,h);d=e;e&&f&&(d=$Xb.up(a,1)==1);$Xb.km(a.g,c,g,d);}};$Xb.Fp=function Fp(){};xxb(396,1,{},$Xb.Fp);_.Nb=function Gp(){return false;};_.Ob=function Hp(a){throw Hwb(new VXb.aA('Unexpected request to invent coordinates. Check source code logic!'));};_.d=0;_.e=0;_.f=0;_.i=false;UXb.Klb=VFb(396);$Xb.Ip=function Ip(a){};$Xb.Jp=function Jp(){$Xb.Kp.call(this,true);};$Xb.Kp=function Kp(a){$Xb.Ip(this);this.b=a;};xxb(50,396,{},$Xb.Jp,$Xb.Kp);_.Nb=function Lp(){return this.b;};_.Ob=function Mp(a){var b;b=new cYb.yy(this.a);b.g=new _Xb.VQb(78187493520);cYb.fy(b,a);};_.a=2;_.b=false;UXb.Llb=VFb(50);$Xb.Np=function Np(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p,q,r;e=b.a;n=b.g;j=cxb(Jwb($Xb.Lk(a.k,e),1),0);f=$Xb.Gk(a.k,e);l=f!=null?$Xb.Up(a,e,f,d):j?'*':$Xb.Fk(a.k,e);!j&&f==null&&$Xb.Ho(a.k,e)&&(a.j&4)==0&&($Xb.In(a.k,e)!=0||$Xb.xk(a.k,e)==-1&&$Xb.Mk(a.k,e)==0)&&(l=YXb.LTb(l).toLowerCase());b.f&&(c.a+='(',c);n!=-1&&$Xb.Rp(a,$Xb.Pn(a.k,b.a,b.g),b.g,c);g=$Xb.zk(a.k,e);if(g==0&&(a.j&1)!=0){h=Jwb($Xb.Lk(a.k,e),YZb);Owb(h,_Zb)==0?g=-1:Owb(h,$Zb)==0&&(g=1);}k=$Xb.Jk(a.k,e);m=(a.j&2)!=0?$Xb.Ik(a.k,e):0;o=(a.j&1)!=0?$Xb.$p(a,e,d):null;r=!j&&!$Xb.fq($Xb.Qk(a.k,e))||f!=null||($Xb.Kk(a.k,e)==1||$Xb.Kk(a.k,e)==2)&&(q=$Xb.Ek(a.k,e)-1,!(q!=-1&&a.i[q][$Xb.Dk(a.k,e)]<=1))&&($Xb.Qk(a.k,e)!=7||$Xb.zk(a.k,e)>0)||$Xb.Ho(a.k,e)&&$Xb.In(a.k,e)==0&&(a.j&4)==0||g!=0||k!=0||m!=0||$Xb.xk(a.k,e)!=-1||$Xb.Mk(a.k,e)!=0||o!=null;r&&(c.a+='[',c);k!=0&&(c.a+=k,c);c.a+=''+l;($Xb.Kk(a.k,e)==1||$Xb.Kk(a.k,e)==2)&&(p=$Xb.Ek(a.k,e)-1,!(p!=-1&&a.i[p][$Xb.Dk(a.k,e)]<=1))&&($Xb.Qk(a.k,e)!=7||$Xb.zk(a.k,e)>0)&&VXb.gIb(c,$Xb.Zp(a,e,n));if((a.j&1)==0&&r){i=$Xb.qo(a.k,e);i==1?(c.a+='H',c):i>1&&(c.a+='H'+i,c);}if(g!=0){c.a+=String.fromCharCode(g>0?43:45);$wnd.Math.abs(g)>1&&VXb.dIb(c,$wnd.Math.abs(g));}o!=null&&(c.a+=''+o,c);if(m!=0){c.a+=':';c.a+=m;}r&&(c.a+=']',c);$Xb.Sp(a,b,c);b.e&&(c.a+=')',c);};$Xb.Op=function Op(a,b,c){var d,e,f,g,h;f=true;h=_Xb.Xi(a.g,b).a;g=$Xb.bq(a,h);while(g!=-1){d=$Xb.Rn(a.k,h,g);e=$Xb.Tn(a.k,h,g);g=$Xb.bq(a,d);$Xb.Qp(a,new $Xb.Ct(d,e,h,c&&f,c&&g==-1),++b);h=d;f=false;}};$Xb.Pp=function Pp(a,b,c){var d,e,f,g;for(e=b,f=0,g=e.length;f<g;++f){d=e[f];a.f[d&1073741823]=(d&v_b)!=0^c?2:1;}};$Xb.Qp=function Qp(a,b,c){_Xb.Ri(a.g,c,b);a.b[b.a]=true;b.g!=-1&&(a.c[$Xb.Pn(a.k,b.a,b.g)]=true);};$Xb.Rp=function Rp(a,b,c,d){var e,f,g,h,i;i=YXb.LTb(d.a).length;a.f[b]!=0&&VXb.cIb(d,a.f[b]==1?47:92);if(a.j==1){f=$Xb.dl(a.k,127);if(f!=0){(f&1)!=0&&a.f[b]==0&&(d.a+='-',d);if((f&2)!=0){YXb.LTb(d.a).length!=i&&(d.a+=',',d);d.a+='=';}if((f&4)!=0){YXb.LTb(d.a).length!=i&&(d.a+=',',d);d.a+='#';}if((f&8)!=0){YXb.LTb(d.a).length!=i&&(d.a+=',',d);d.a+='$';}if((f&16)!=0){YXb.LTb(d.a).length!=i&&(d.a+=',',d);d.a+='$';}if((f&64)!=0){YXb.LTb(d.a).length!=i&&(d.a+=',',d);d.a+=':';}if((f&32)!=0){YXb.LTb(d.a).length!=i&&(d.a+=',',d);VXb.gIb(d,$Xb.Fl(a.k,c)?'<-':'->');}}}if(i==YXb.LTb(d.a).length&&(!$Xb.Io(a.k,b)||(a.j&4)!=0)){e=$Xb.el(a.k,b)&127;e==1?$Xb.Ho(a.k,$Xb.Vk(a.k,0,b))&&$Xb.Ho(a.k,$Xb.Vk(a.k,1,b))&&(a.j&4)==0&&a.f[b]==0&&(d.a+='-',d):e==2?(d.a+='=',d):e==4?(d.a+='#',d):e==8?(d.a+='$',d):e==16?(d.a+='$',d):e==64?(d.a+=':',d):e==32&&VXb.gIb(d,$Xb.Fl(a.k,c)?'<-':'->');}if(a.j==1){g=i==YXb.LTb(d.a).length?'':';';h=$Xb.dl(a.k,b)&384;h==256?(d.a+=g+'@',d):h==128&&(d.a+=g+'!@',d);}};$Xb.Sp=function Sp(a,b,c){var d,e,f;if(b.c!=null){for(e=0;e<b.c.length;e++){for(f=0;f<$Xb.Sn(a.k,b.a);f++){if(b.c[e]==$Xb.Rn(a.k,b.a,f)){d=$Xb.Tn(a.k,b.a,f);b.d[e]||$Xb.Rp(a,d,b.a,c);a.e[d]>9&&(c.a+='%',c);VXb.dIb(c,a.e[d]);}}}}};$Xb.Tp=function Tp(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O;M=new _Xb.kj();for(r=new _Xb.rOb(a.g);r.a<r.c.a.length;){q=_Xb.qOb(r);if(q.g!=-1){t=$Xb.Pn(a.k,q.a,q.g);if(!$Xb.Jo(a.k,t)&&!$Xb.Yo(a.k,t)&&($Xb.cl(a.k,t)==1||$Xb.cl(a.k,t)==2)){K=_Xb.Xi(a.g,a.q[q.g]);c=Sjb(UXb.llb,yZb,6,$Xb.Sn(a.k,q.a)+$Xb.Sn(a.k,K.a)-2,15,1);B=0;L=false;if(K.g!=-1){c[B++]=K.b;}else {u=-1;N=-1;v=gZb;for(D=0;D<$Xb.Sn(a.k,K.a);D++){l=$Xb.Rn(a.k,K.a,D);if(l!=q.a){if(u==-1){u=D;v=a.q[l];}else {if(v<a.q[l]){N=D;}else {N=u;u=D;}}}}if(N==-1){H=$Xb.Rn(a.k,K.a,u);I=$Xb.Tn(a.k,K.a,u);c[B++]=I|($Xb.dq(a,K.a,H)?v_b:0);}else {m=$Xb.Rn(a.k,K.a,u);o=$Xb.Tn(a.k,K.a,u);n=$Xb.Rn(a.k,K.a,N);p=$Xb.Tn(a.k,K.a,N);c[B++]=o|($Xb.dq(a,K.a,m)?v_b:0);c[B++]=p|($Xb.dq(a,K.a,n)?0:v_b);}}if($Xb.Sn(a.k,K.a)==3&&K.g!=-1){for(D=0;D<$Xb.Sn(a.k,K.a);D++){l=$Xb.Rn(a.k,K.a,D);if(l!=K.g&&l!=q.a){d=$Xb.Tn(a.k,K.a,D);c[B++]=d|($Xb.dq(a,K.a,l)?v_b:0);l<K.g&&(L=!L);break;}}}$Xb.cl(a.k,t)==2&&(L=!L);for(C=0;C<$Xb.Sn(a.k,q.a);C++){i=$Xb.Rn(a.k,q.a,C);if(i!=q.g){A=L;if($Xb.Sn(a.k,q.a)==3){for(G=0;G<$Xb.Sn(a.k,q.a);G++){l=$Xb.Rn(a.k,q.a,G);if(l!=q.g&&l!=i){l<i&&(A=!A);break;}}}if($Xb.Al(a.k,t)){w=$Xb.Pf(a.d,t);if(!a.n[w]){a.n[w]=true;a.o[w]=A;}a.o[w]&&(A=!A);}j=$Xb.Pn(a.k,q.a,i);c[B++]=j|(A^$Xb.dq(a,q.a,i)?0:v_b);}}YXb.cTb(M.a,c);}}}a.f=Sjb(UXb.llb,yZb,6,a.k.g,15,1);M.a.length!=0&&$Xb.Pp(a,_Xb.cj(M,0),false);while(M.a.length!=0){O=M.a.length;for(C=M.a.length-1;C>=0;C--){c=(YXb.zTb(C,M.a.length),M.a[C]);J=0;F=false;k=false;for(f=c,g=0,h=f.length;g<h;++g){e=f[g];b=e&1073741823;if(a.f[b]!=0){s=(e&v_b)!=0^a.f[b]==2;J==0?F=s:F!=s&&(k=true);++J;}}if(J!=0){c=_Xb.cj(M,C);k||$Xb.Pp(a,c,F);}}O==M.a.length&&$Xb.Pp(a,_Xb.cj(M,0),false);}};$Xb.Up=function Up(a,b,c,d){var e,f,g,h,i,j,k;k=YXb.LTb(d.a).length;0<k?d.a=VXb.RHb(d.a,0,0):0>k&&(d.a+=VXb.WHb(Sjb(UXb.ilb,N$b,6,-k,15,1)));i=$Xb.Ho(a.k,b)&&(a.j&4)==0;for(f=c,g=0,h=f.length;g<h;++g){e=f[g];YXb.LTb(d.a).length!=0&&(d.a+=',',d);j=($Xb.Sj(),$Xb.Mj)[e];VXb.gIb(d,i?YXb.LTb(j).toLowerCase():j);}return d.a;};$Xb.Vp=function Vp(a){var b,c,d,e,f,g,h,i;if(!a.k||a.k.q==0)return '';$Xb.nu(a.k,15);a.d=new $Xb.ig(a.k,129);e=a.d.R;a.o=Sjb(UXb.Cwb,KZb,6,e+1,16,1);a.n=Sjb(UXb.Cwb,KZb,6,e+1,16,1);a.i=Qjb(UXb.llb,[Q$b,yZb],[8,6],15,[2,32],2);for(b=0;b<a.k.f;b++){i=$Xb.Ek(a.k,b)-1;i!=-1&&++a.i[i][$Xb.Dk(a.k,b)];}$Xb.Yp(a);$Xb.Wp(a);$Xb.Tp(a);d=new VXb.jIb();c=new VXb.jIb();f=true;for(h=new _Xb.rOb(a.g);h.a<h.c.a.length;){g=_Xb.qOb(h);g.g==-1&&(f?f=false:(d.a+='.',d));$Xb.Np(a,g,d,c);}return d.a;};$Xb.Wp=function Wp(a){var b,c,d,e,f,g,h,i,j,k,l;for(l=new _Xb.rOb(a.g);l.a<l.c.a.length;){j=_Xb.qOb(l);c=0;for(f=0;f<$Xb.Sn(a.k,j.a);f++)a.c[$Xb.Tn(a.k,j.a,f)]||++c;if(c!=0){j.c=Sjb(UXb.llb,yZb,6,c,15,1);c=0;for(g=0;g<$Xb.Sn(a.k,j.a);g++){if(!a.c[$Xb.Tn(a.k,j.a,g)]){i=$Xb.Rn(a.k,j.a,g);j.c[c++]=a.q[i]<<16|i;}}YXb.fTb(j.c,YXb.LTb(Axb(_Xb.ZOb.prototype.Zd,_Xb.ZOb,[])));for(e=0;e<j.c.length;e++)j.c[e]=pZb&j.c[e];}}d=Sjb(UXb.Cwb,KZb,6,a.k.g,16,1);a.e=Sjb(UXb.llb,yZb,6,a.k.g,15,1);for(k=new _Xb.rOb(a.g);k.a<k.c.a.length;){j=_Xb.qOb(k);if(j.c!=null){j.d=Sjb(UXb.Cwb,KZb,6,j.c.length,16,1);for(e=0;e<j.c.length;e++){for(h=0;h<$Xb.Sn(a.k,j.a);h++){if(j.c[e]==$Xb.Rn(a.k,j.a,h)){b=$Xb.Tn(a.k,j.a,h);if(a.c[b]){d[a.e[b]]=false;}else {a.c[b]=true;j.d[e]=true;a.e[b]=1;while(d[a.e[b]])++a.e[b];d[a.e[b]]=true;}}}}}}};$Xb.Xp=function Xp(a){var b,c,d,e;d=-1;e=gZb;for(b=0;b<a.k.f;b++){if(!a.b[b]){c=a.a[b];cxb(Jwb($Xb.Lk(a.k,b),LZb),0)&&(c+=v_b);$Xb.Sn(a.k,b)==0?c+=1056964608:c+=$Xb.Sn(a.k,b)<<24;if(e>c){e=c;d=b;}}}return d;};$Xb.Yp=function Yp(a){var b,c,d,e,f;a.a=a.d.d;a.b=Sjb(UXb.Cwb,KZb,6,a.k.f,16,1);a.c=Sjb(UXb.Cwb,KZb,6,a.k.g,16,1);a.g=new _Xb.kj();b=$Xb.Xp(a);while(b!=-1){c=a.g.a.length;$Xb.Qp(a,new $Xb.Ct(b,-1,-1,false,false),c);if($Xb.Sn(a.k,b)!=0){$Xb.Op(a,c,false);while(c<a.g.a.length-1){while($Xb.cq(a,_Xb.Xi(a.g,c).a))$Xb.Op(a,c,true);++c;}}b=$Xb.Xp(a);}a.q=Sjb(UXb.llb,yZb,6,a.k.f,15,1);d=0;for(f=new _Xb.rOb(a.g);f.a<f.c.a.length;){e=_Xb.qOb(f);a.q[e.a]=d++;}};$Xb.Zp=function Zp(a,b,c){var d,e,f,g,h,i,j,k,l,m,n;h=false;if($Xb.In(a.k,b)!=0&&$Xb.Sn(a.k,b)==2&&$Xb.Un(a.k,b,0)==2&&$Xb.Un(a.k,b,1)==2){for(f=0;f<$Xb.Sn(a.k,b);f++){d=$Xb.Rn(a.k,b,f);n=0;m=Sjb(UXb.llb,yZb,6,3,15,1);for(j=0;j<$Xb.Sn(a.k,d);j++){m[n]=$Xb.Rn(a.k,d,j);m[n]!=b&&++n;}n==2&&a.q[m[0]]<a.q[m[1]]^m[0]<m[1]&&(h=!h);}}else {k=Sjb(UXb.llb,yZb,6,4,15,1);l=Sjb(UXb.llb,yZb,6,4,15,1);g=0;if(c!=-1){k[g]=c;l[g++]=8*a.q[c];}if($Xb.fo(a.k,b)!=0){k[g]=gZb;l[g++]=8*a.q[b];}else if($Xb.Sn(a.k,b)==3){k[g]=gZb;l[g++]=8*a.q[b];}for(f=0;f<$Xb.Sn(a.k,b);f++){d=$Xb.Rn(a.k,b,f);if(d!=c){k[g]=d;l[g++]=$Xb.aq(a,b,f);}}h=$Xb.eq(k,l);}i=$Xb.Kk(a.k,b)==1^h;if($Xb.tl(a.k,b)){e=$Xb.Qf(a.d,b);if(!a.n[e]){a.n[e]=true;a.o[e]=i;}a.o[e]&&(i=!i);}return i?'@@':'@';};$Xb.$p=function $p(a,b,c){var d,e,f,g,h,i,j,k;h=YXb.LTb(c.a).length;0<h?c.a=VXb.RHb(c.a,0,0):0>h&&(c.a+=VXb.WHb(Sjb(UXb.ilb,N$b,6,-h,15,1)));i=$Xb.Lk(a.k,b);e=lxb(gxb(Jwb(i,YZb),3));switch(e){case 20971520:c.a+='+0';break;case 25165824:$Xb.zk(a.k,b)==0&&(c.a+='-',c);break;case 12582912:$Xb.zk(a.k,b)==0&&(c.a+='+',c);}d=Jwb(i,V$b);Owb(d,2)==0?(c.a+=';a',c):Owb(d,4)==0&&(c.a+=';A',c);f=Jwb(i,WZb);Owb(f,0)!=0&&(Owb(f,1792)==0?(c.a+=';H0',c):Owb(f,1664)==0?(c.a+=';H1',c):Owb(f,1408)==0?(c.a+=';H2',c):Owb(f,896)==0?(c.a+=';H3',c):Owb(f,128)==0?(c.a+=';!H0',c):Owb(f,384)==0?(c.a+=';!H0;!H1',c):Owb(f,1536)==0?(c.a+=';!H2;!H3',c):Owb(f,XZb)==0&&(c.a+=';!H3',c));k=Jwb(i,120);Owb(k,8)==0?(c.a+=';!R0',c):Owb(k,16)==0?(c.a+=';!R1',c):Owb(k,32)==0?(c.a+=';!R2',c):Owb(k,64)==0?(c.a+=';!R3',c):Owb(k,112)==0?(c.a+=';R0',c):Owb(k,104)==0?(c.a+=';R1',c):Owb(k,88)==0?(c.a+=';R2',c):Owb(k,56)==0&&(c.a+=';R3',c);j=Jwb(i,CZb);if(Owb(j,DZb)==0)c.a+=';!r'+mxb(j);else if(Owb(j,w_b)==0)c.a+=';r'+mxb(j);else if(Owb(j,0)!=0){if(cxb(Jwb(j,JZb),0)){Twb(Jwb(j,DZb),0)&&(c.a+=';!r0'+mxb(j),c);Twb(Jwb(j,EZb),0)&&(c.a+=';!r3'+mxb(j),c);Twb(Jwb(j,FZb),0)&&(c.a+=';!r4'+mxb(j),c);Twb(Jwb(j,GZb),0)&&(c.a+=';!r5'+mxb(j),c);Twb(Jwb(j,HZb),0)&&(c.a+=';!r6'+mxb(j),c);Twb(Jwb(j,IZb),0)&&(c.a+=';!r7'+mxb(j),c);}else {c.a+=';';cxb(Jwb(j,DZb),0)&&(c.a+='r0,'+mxb(j),c);cxb(Jwb(j,EZb),0)&&(c.a+='r3,'+mxb(j),c);cxb(Jwb(j,FZb),0)&&(c.a+='r4,'+mxb(j),c);cxb(Jwb(j,GZb),0)&&(c.a+='r5,'+mxb(j),c);cxb(Jwb(j,HZb),0)&&(c.a+='r6,'+mxb(j),c);cxb(Jwb(j,IZb),0)&&(c.a+='r7,'+mxb(j),c);VXb.$Eb(c,YXb.LTb(c.a).length-1);}}if(Owb(j,0)==0){j=gxb(Jwb(i,u$b),22);Owb(j,0)!=0&&(c.a+=';r'+mxb(j),c);}g=Jwb(i,b$b);Owb(g,c$b)==0&&(c.a+=';D1',c);Owb(g,d$b)==0&&(c.a+=';D2',c);Owb(g,e$b)==0&&(c.a+=';D3',c);Owb(g,f$b)==0&&(c.a+=';!D3;!D4',c);Owb(g,g$b)==0&&(c.a+=';!D4',c);Owb(g,h$b)==0&&(c.a+=';!D0;!D1',c);Owb(g,i$b)==0&&(c.a+=';!D0;!D1;!D2',c);Owb(g,j$b)==0&&(c.a+=';!D0;!D1;!D2;!D3',c);cxb(Jwb(i,x$b),0)&&VXb.gIb(c,';D'+$Xb.Sn(a.k,b));cxb(Jwb(i,SZb),0)&&VXb.gIb(c,';!D'+$Xb.Sn(a.k,b));return YXb.LTb(c.a).length==0?null:c.a;};$Xb._p=function _p(a){a.p==null&&(a.p=$Xb.Vp(a));return a.p;};$Xb.aq=function aq(a,b,c){var d,e,f,g,h;d=$Xb.Tn(a.k,b,c);g=$Xb.Rn(a.k,b,c);if(a.e[d]!=0){h=8*a.q[b]+1;e=_Xb.Xi(a.g,a.q[b]).c;for(f=0;f<e.length&&g!=e[f];f++)++h;return h;}return 8*a.q[g];};$Xb.bq=function bq(a,b){var c,d,e,f,g;c=-1;d=-1;for(f=0;f<$Xb.Sn(a.k,b);f++){e=$Xb.Rn(a.k,b,f);g=($Xb.Un(a.k,b,f)<<24)+a.a[e];if(!a.b[e]&&(c==-1||d<g)){c=f;d=g;}}return c;};$Xb.cq=function cq(a,b){var c;for(c=0;c<$Xb.Sn(a.k,b);c++)if(!a.b[$Xb.Rn(a.k,b,c)])return true;return false;};$Xb.dq=function dq(a,b,c){var d,e;d=_Xb.Xi(a.g,a.q[b]);if(d.g==c)return false;e=_Xb.Xi(a.g,a.q[c]);if(e.g==b)return true;return $Xb.Bt(e,b);};$Xb.eq=function eq(a,b){var c,d,e;d=false;for(c=1;c<4;c++){for(e=0;e<c;e++){a[e]>a[c]&&(d=!d);b[e]>b[c]&&(d=!d);}}return d;};$Xb.fq=function fq(a){return a>=5&&a<=9||a>=15&&a<=17||a==35||a==53;};$Xb.gq=function gq(a){$Xb.iq.call(this,a,false);};$Xb.hq=function hq(a,b){this.k=a;this.j=b;};$Xb.iq=function iq(a,b){$Xb.hq.call(this,a,b?2:0);};$Xb.jq=function jq(a){var b,c,d,e;e=new VXb.jIb();for(c=0;c<a.g.a.length;c++){c!=0&&(e.a+='.',e);VXb.gIb(e,$Xb._p(new $Xb.hq(_Xb.Xi(a.g,c),2)));}e.a+='>';for(d=0;d<a.a.a.length;d++){d!=0&&(e.a+='.',e);VXb.gIb(e,$Xb._p(new $Xb.gq(_Xb.Xi(a.a,d))));}e.a+='>';for(b=0;b<a.f.a.length;b++){b!=0&&(e.a+='.',e);VXb.gIb(e,$Xb._p(new $Xb.hq(_Xb.Xi(a.f,b),2)));}return e.a;};xxb(112,1,{},$Xb.gq,$Xb.hq,$Xb.iq);_.j=0;UXb.Mlb=VFb(112);$Xb.kq=function kq(a,b){this.b=a;this.a=b;};xxb(3,1,{3:1},$Xb.kq);_.a=0;_.b=0;UXb.Nlb=VFb(3);$Xb.mq=function mq(){$Xb.mq=zxb;$Xb.lq=$jb(Mjb(UXb.Nlb,2),aZb,17,0,[null,$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(0,1.007825032),new $Xb.kq(1,2.014101778),new $Xb.kq(2,3.016049268),new $Xb.kq(3,4.027834627),new $Xb.kq(4,5.039542911),new $Xb.kq(5,6.044942608)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(1,3.01602931),new $Xb.kq(2,4.00260325),new $Xb.kq(3,5.012223628),new $Xb.kq(4,6.018888072),new $Xb.kq(5,7.028030527),new $Xb.kq(6,8.033921838),new $Xb.kq(7,9.043820323),new $Xb.kq(8,10.052399713)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(1,4.027182329),new $Xb.kq(2,5.012537796),new $Xb.kq(3,6.015122281),new $Xb.kq(4,7.016004049),new $Xb.kq(5,8.02248667),new $Xb.kq(6,9.026789122),new $Xb.kq(7,10.035480884),new $Xb.kq(8,11.043796166),new $Xb.kq(9,12.05378)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(1,5.04079),new $Xb.kq(2,6.019725804),new $Xb.kq(3,7.016929246),new $Xb.kq(4,8.005305094),new $Xb.kq(5,9.012182135),new $Xb.kq(6,10.01353372),new $Xb.kq(7,11.021657653),new $Xb.kq(8,12.026920631),new $Xb.kq(9,13.036133834),new $Xb.kq(10,14.042815522)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(2,7.029917389),new $Xb.kq(3,8.024606713),new $Xb.kq(4,9.013328806),new $Xb.kq(5,10.012937027),new $Xb.kq(6,11.009305466),new $Xb.kq(7,12.014352109),new $Xb.kq(8,13.017780267),new $Xb.kq(9,14.025404064),new $Xb.kq(10,15.031097291),new $Xb.kq(11,16.039808836),new $Xb.kq(12,17.046931399),new $Xb.kq(13,18.05617),new $Xb.kq(14,19.06373)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(2,8.037675026),new $Xb.kq(3,9.031040087),new $Xb.kq(4,10.01685311),new $Xb.kq(5,11.011433818),new $Xb.kq(6,12),new $Xb.kq(7,13.003354838),new $Xb.kq(8,14.003241988),new $Xb.kq(9,15.010599258),new $Xb.kq(10,16.014701243),new $Xb.kq(11,17.022583712),new $Xb.kq(12,18.026757058),new $Xb.kq(13,19.035248094),new $Xb.kq(14,20.040322395),new $Xb.kq(15,21.04934),new $Xb.kq(16,22.05645)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(3,10.042618),new $Xb.kq(4,11.026796226),new $Xb.kq(5,12.018613202),new $Xb.kq(6,13.005738584),new $Xb.kq(7,14.003074005),new $Xb.kq(8,15.000108898),new $Xb.kq(9,16.006101417),new $Xb.kq(10,17.008449673),new $Xb.kq(11,18.014081827),new $Xb.kq(12,19.017026896),new $Xb.kq(13,20.023367295),new $Xb.kq(14,21.027087574),new $Xb.kq(15,22.034440259),new $Xb.kq(16,23.04051),new $Xb.kq(17,24.0505)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(4,12.034404776),new $Xb.kq(5,13.0248104),new $Xb.kq(6,14.008595285),new $Xb.kq(7,15.003065386),new $Xb.kq(8,15.994914622),new $Xb.kq(9,16.999131501),new $Xb.kq(10,17.999160419),new $Xb.kq(11,19.00357873),new $Xb.kq(12,20.00407615),new $Xb.kq(13,21.008654631),new $Xb.kq(14,22.009967157),new $Xb.kq(15,23.015691325),new $Xb.kq(16,24.020369922),new $Xb.kq(17,25.02914),new $Xb.kq(18,26.03775)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(5,14.03608),new $Xb.kq(6,15.018010856),new $Xb.kq(7,16.01146573),new $Xb.kq(8,17.002095238),new $Xb.kq(9,18.000937667),new $Xb.kq(10,18.998403205),new $Xb.kq(11,19.999981324),new $Xb.kq(12,20.999948921),new $Xb.kq(13,22.00299925),new $Xb.kq(14,23.003574385),new $Xb.kq(15,24.008099371),new $Xb.kq(16,25.012094963),new $Xb.kq(17,26.019633157),new $Xb.kq(18,27.026892316),new $Xb.kq(19,28.03567),new $Xb.kq(20,29.04326)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(6,16.025756907),new $Xb.kq(7,17.017697565),new $Xb.kq(8,18.005697066),new $Xb.kq(9,19.001879839),new $Xb.kq(10,19.992440176),new $Xb.kq(11,20.993846744),new $Xb.kq(12,21.99138551),new $Xb.kq(13,22.994467337),new $Xb.kq(14,23.993615074),new $Xb.kq(15,24.997789899),new $Xb.kq(16,26.000461498),new $Xb.kq(17,27.0076152),new $Xb.kq(18,28.012108072),new $Xb.kq(19,29.019345902),new $Xb.kq(20,30.023872),new $Xb.kq(21,31.03311),new $Xb.kq(22,32.03991)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(7,18.02718),new $Xb.kq(8,19.01387945),new $Xb.kq(9,20.00734826),new $Xb.kq(10,20.997655099),new $Xb.kq(11,21.994436782),new $Xb.kq(12,22.989769675),new $Xb.kq(13,23.990963332),new $Xb.kq(14,24.989954352),new $Xb.kq(15,25.992589898),new $Xb.kq(16,26.994008702),new $Xb.kq(17,27.99889041),new $Xb.kq(18,29.002811301),new $Xb.kq(19,30.009226487),new $Xb.kq(20,31.013595108),new $Xb.kq(21,32.019649792),new $Xb.kq(22,33.027386),new $Xb.kq(23,34.0349),new $Xb.kq(24,35.04418)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(8,20.018862744),new $Xb.kq(9,21.011714174),new $Xb.kq(10,21.999574055),new $Xb.kq(11,22.99412485),new $Xb.kq(12,23.985041898),new $Xb.kq(13,24.985837023),new $Xb.kq(14,25.98259304),new $Xb.kq(15,26.984340742),new $Xb.kq(16,27.983876703),new $Xb.kq(17,28.988554743),new $Xb.kq(18,29.990464529),new $Xb.kq(19,30.996548459),new $Xb.kq(20,31.999145889),new $Xb.kq(21,33.005586975),new $Xb.kq(22,34.00907244),new $Xb.kq(23,35.018669),new $Xb.kq(24,36.02245),new $Xb.kq(25,37.03124)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(8,21.02804),new $Xb.kq(9,22.01952),new $Xb.kq(10,23.0072649),new $Xb.kq(11,23.999940911),new $Xb.kq(12,24.990428555),new $Xb.kq(13,25.986891659),new $Xb.kq(14,26.981538441),new $Xb.kq(15,27.981910184),new $Xb.kq(16,28.980444848),new $Xb.kq(17,29.982960304),new $Xb.kq(18,30.983946023),new $Xb.kq(19,31.988124379),new $Xb.kq(20,32.990869587),new $Xb.kq(21,33.996927255),new $Xb.kq(22,34.99993765),new $Xb.kq(23,36.006351501),new $Xb.kq(24,37.01031),new $Xb.kq(25,38.0169),new $Xb.kq(26,39.0219)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(8,22.03453),new $Xb.kq(9,23.02552),new $Xb.kq(10,24.011545711),new $Xb.kq(11,25.00410664),new $Xb.kq(12,25.992329935),new $Xb.kq(13,26.986704764),new $Xb.kq(14,27.976926533),new $Xb.kq(15,28.976494719),new $Xb.kq(16,29.973770218),new $Xb.kq(17,30.975363275),new $Xb.kq(18,31.974148129),new $Xb.kq(19,32.97800052),new $Xb.kq(20,33.978575745),new $Xb.kq(21,34.984584158),new $Xb.kq(22,35.986687363),new $Xb.kq(23,36.99299599),new $Xb.kq(24,37.99598),new $Xb.kq(25,39.0023),new $Xb.kq(26,40.0058),new $Xb.kq(27,41.0127),new $Xb.kq(28,42.0161)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(9,24.03435),new $Xb.kq(10,25.02026),new $Xb.kq(11,26.01178),new $Xb.kq(12,26.999191645),new $Xb.kq(13,27.99231233),new $Xb.kq(14,28.981801376),new $Xb.kq(15,29.978313807),new $Xb.kq(16,30.973761512),new $Xb.kq(17,31.973907163),new $Xb.kq(18,32.971725281),new $Xb.kq(19,33.973636381),new $Xb.kq(20,34.973314249),new $Xb.kq(21,35.978259824),new $Xb.kq(22,36.979608338),new $Xb.kq(23,37.98447),new $Xb.kq(24,38.98642),new $Xb.kq(25,39.99105),new $Xb.kq(26,40.9948),new $Xb.kq(27,42.00009),new $Xb.kq(28,43.00331),new $Xb.kq(29,44.00988),new $Xb.kq(30,45.01514),new $Xb.kq(31,46.02383)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(10,26.02788),new $Xb.kq(11,27.018795),new $Xb.kq(12,28.004372661),new $Xb.kq(13,28.996608805),new $Xb.kq(14,29.984902954),new $Xb.kq(15,30.979554421),new $Xb.kq(16,31.97207069),new $Xb.kq(17,32.971458497),new $Xb.kq(18,33.967866831),new $Xb.kq(19,34.96903214),new $Xb.kq(20,35.96708088),new $Xb.kq(21,36.971125716),new $Xb.kq(22,37.971163443),new $Xb.kq(23,38.975135275),new $Xb.kq(24,39.97547),new $Xb.kq(25,40.98003),new $Xb.kq(26,41.98149),new $Xb.kq(27,42.9866),new $Xb.kq(28,43.98832),new $Xb.kq(29,44.99482),new $Xb.kq(30,45.99957),new $Xb.kq(31,47.00762),new $Xb.kq(32,48.01299),new $Xb.kq(33,49.02201)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(11,28.02851),new $Xb.kq(12,29.01411),new $Xb.kq(13,30.00477),new $Xb.kq(14,30.992416014),new $Xb.kq(15,31.985688908),new $Xb.kq(16,32.977451798),new $Xb.kq(17,33.973761967),new $Xb.kq(18,34.968852707),new $Xb.kq(19,35.968306945),new $Xb.kq(20,36.9659026),new $Xb.kq(21,37.96801055),new $Xb.kq(22,38.968007677),new $Xb.kq(23,39.970415555),new $Xb.kq(24,40.970650212),new $Xb.kq(25,41.973174994),new $Xb.kq(26,42.974203385),new $Xb.kq(27,43.978538712),new $Xb.kq(28,44.9797),new $Xb.kq(29,45.98412),new $Xb.kq(30,46.98795),new $Xb.kq(31,47.99485),new $Xb.kq(32,48.99989),new $Xb.kq(33,50.00773),new $Xb.kq(34,51.01353)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(12,30.02156),new $Xb.kq(13,31.012126),new $Xb.kq(14,31.99766066),new $Xb.kq(15,32.989928719),new $Xb.kq(16,33.980270118),new $Xb.kq(17,34.975256726),new $Xb.kq(18,35.967546282),new $Xb.kq(19,36.966775912),new $Xb.kq(20,37.962732161),new $Xb.kq(21,38.964313413),new $Xb.kq(22,39.962383123),new $Xb.kq(23,40.964500828),new $Xb.kq(24,41.963046386),new $Xb.kq(25,42.965670701),new $Xb.kq(26,43.965365269),new $Xb.kq(27,44.968094979),new $Xb.kq(28,45.968093467),new $Xb.kq(29,46.972186238),new $Xb.kq(30,47.97507),new $Xb.kq(31,48.98218),new $Xb.kq(32,49.98594),new $Xb.kq(33,50.99324),new $Xb.kq(34,51.99817),new $Xb.kq(35,53.006227)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(13,32.02192),new $Xb.kq(14,33.00726),new $Xb.kq(15,33.99841),new $Xb.kq(16,34.988011615),new $Xb.kq(17,35.981293405),new $Xb.kq(18,36.973376915),new $Xb.kq(19,37.969080107),new $Xb.kq(20,38.963706861),new $Xb.kq(21,39.963998672),new $Xb.kq(22,40.961825972),new $Xb.kq(23,41.962403059),new $Xb.kq(24,42.960715746),new $Xb.kq(25,43.961556146),new $Xb.kq(26,44.960699658),new $Xb.kq(27,45.961976203),new $Xb.kq(28,46.961677807),new $Xb.kq(29,47.965512946),new $Xb.kq(30,48.967450084),new $Xb.kq(31,49.972782832),new $Xb.kq(32,50.97638),new $Xb.kq(33,51.98261),new $Xb.kq(34,52.98712),new $Xb.kq(35,53.99399),new $Xb.kq(36,54.999388)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(14,34.01412),new $Xb.kq(15,35.004765),new $Xb.kq(16,35.993087234),new $Xb.kq(17,36.985871505),new $Xb.kq(18,37.976318637),new $Xb.kq(19,38.970717729),new $Xb.kq(20,39.962591155),new $Xb.kq(21,40.962278349),new $Xb.kq(22,41.958618337),new $Xb.kq(23,42.958766833),new $Xb.kq(24,43.955481094),new $Xb.kq(25,44.956185938),new $Xb.kq(26,45.953692759),new $Xb.kq(27,46.954546459),new $Xb.kq(28,47.952533512),new $Xb.kq(29,48.955673302),new $Xb.kq(30,49.957518286),new $Xb.kq(31,50.961474238),new $Xb.kq(32,51.9651),new $Xb.kq(33,52.97005),new $Xb.kq(34,53.97468),new $Xb.kq(35,54.98055),new $Xb.kq(36,55.98579),new $Xb.kq(37,56.992356)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(15,36.01492),new $Xb.kq(16,37.00305),new $Xb.kq(17,37.9947),new $Xb.kq(18,38.984790009),new $Xb.kq(19,39.977964014),new $Xb.kq(20,40.969251316),new $Xb.kq(21,41.965516761),new $Xb.kq(22,42.96115098),new $Xb.kq(23,43.959403048),new $Xb.kq(24,44.955910243),new $Xb.kq(25,45.95517025),new $Xb.kq(26,46.952408027),new $Xb.kq(27,47.952234991),new $Xb.kq(28,48.950024065),new $Xb.kq(29,49.952187008),new $Xb.kq(30,50.9536027),new $Xb.kq(31,51.95665),new $Xb.kq(32,52.95817),new $Xb.kq(33,53.963),new $Xb.kq(34,54.9694),new $Xb.kq(35,55.97266),new $Xb.kq(36,56.97704),new $Xb.kq(37,57.98307),new $Xb.kq(38,58.988041)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(16,38.00977),new $Xb.kq(17,39.001323),new $Xb.kq(18,39.990498907),new $Xb.kq(19,40.983131),new $Xb.kq(20,41.973031622),new $Xb.kq(21,42.968523342),new $Xb.kq(22,43.959690235),new $Xb.kq(23,44.958124349),new $Xb.kq(24,45.952629491),new $Xb.kq(25,46.951763792),new $Xb.kq(26,47.947947053),new $Xb.kq(27,48.947870789),new $Xb.kq(28,49.944792069),new $Xb.kq(29,50.946616017),new $Xb.kq(30,51.946898175),new $Xb.kq(31,52.949731709),new $Xb.kq(32,53.95087),new $Xb.kq(33,54.95512),new $Xb.kq(34,55.95799),new $Xb.kq(35,56.9643),new $Xb.kq(36,57.96611),new $Xb.kq(37,58.97196),new $Xb.kq(38,59.97564),new $Xb.kq(39,60.982018)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(17,40.01109),new $Xb.kq(18,40.99974),new $Xb.kq(19,41.99123),new $Xb.kq(20,42.98065),new $Xb.kq(21,43.9744),new $Xb.kq(22,44.965782286),new $Xb.kq(23,45.960199491),new $Xb.kq(24,46.954906918),new $Xb.kq(25,47.95225448),new $Xb.kq(26,48.948516914),new $Xb.kq(27,49.947162792),new $Xb.kq(28,50.943963675),new $Xb.kq(29,51.944779658),new $Xb.kq(30,52.944342517),new $Xb.kq(31,53.946444381),new $Xb.kq(32,54.947238194),new $Xb.kq(33,55.95036),new $Xb.kq(34,56.95236),new $Xb.kq(35,57.95665),new $Xb.kq(36,58.9593),new $Xb.kq(37,59.9645),new $Xb.kq(38,60.96741),new $Xb.kq(39,61.97314),new $Xb.kq(40,62.97675)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(18,42.00643),new $Xb.kq(19,42.997707),new $Xb.kq(20,43.98547),new $Xb.kq(21,44.97916),new $Xb.kq(22,45.968361649),new $Xb.kq(23,46.962906512),new $Xb.kq(24,47.954035861),new $Xb.kq(25,48.951341135),new $Xb.kq(26,49.946049607),new $Xb.kq(27,50.944771767),new $Xb.kq(28,51.940511904),new $Xb.kq(29,52.940653781),new $Xb.kq(30,53.938884921),new $Xb.kq(31,54.940844164),new $Xb.kq(32,55.940645238),new $Xb.kq(33,56.9437538),new $Xb.kq(34,57.94425),new $Xb.kq(35,58.94863),new $Xb.kq(36,59.94973),new $Xb.kq(37,60.95409),new $Xb.kq(38,61.9558),new $Xb.kq(39,62.96186),new $Xb.kq(40,63.9642),new $Xb.kq(41,64.97037)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(19,44.00687),new $Xb.kq(20,44.99451),new $Xb.kq(21,45.98672),new $Xb.kq(22,46.9761),new $Xb.kq(23,47.96887),new $Xb.kq(24,48.959623415),new $Xb.kq(25,49.95424396),new $Xb.kq(26,50.948215487),new $Xb.kq(27,51.945570079),new $Xb.kq(28,52.941294702),new $Xb.kq(29,53.940363247),new $Xb.kq(30,54.938049636),new $Xb.kq(31,55.938909366),new $Xb.kq(32,56.938287458),new $Xb.kq(33,57.939986451),new $Xb.kq(34,58.940447166),new $Xb.kq(35,59.943193998),new $Xb.kq(36,60.94446),new $Xb.kq(37,61.94797),new $Xb.kq(38,62.94981),new $Xb.kq(39,63.95373),new $Xb.kq(40,64.9561),new $Xb.kq(41,65.96082),new $Xb.kq(42,66.96382)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(19,45.01456),new $Xb.kq(20,46.00081),new $Xb.kq(21,46.99289),new $Xb.kq(22,47.98056),new $Xb.kq(23,48.97361),new $Xb.kq(24,49.962993316),new $Xb.kq(25,50.956824936),new $Xb.kq(26,51.948116526),new $Xb.kq(27,52.945312282),new $Xb.kq(28,53.939614836),new $Xb.kq(29,54.938298029),new $Xb.kq(30,55.934942133),new $Xb.kq(31,56.935398707),new $Xb.kq(32,57.933280458),new $Xb.kq(33,58.934880493),new $Xb.kq(34,59.934076943),new $Xb.kq(35,60.936749461),new $Xb.kq(36,61.936770495),new $Xb.kq(37,62.940118442),new $Xb.kq(38,63.94087),new $Xb.kq(39,64.94494),new $Xb.kq(40,65.94598),new $Xb.kq(41,66.95),new $Xb.kq(42,67.95251),new $Xb.kq(43,68.9577)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(21,48.00176),new $Xb.kq(22,48.98972),new $Xb.kq(23,49.98154),new $Xb.kq(24,50.97072),new $Xb.kq(25,51.96359),new $Xb.kq(26,52.954224985),new $Xb.kq(27,53.948464147),new $Xb.kq(28,54.942003149),new $Xb.kq(29,55.939843937),new $Xb.kq(30,56.936296235),new $Xb.kq(31,57.935757571),new $Xb.kq(32,58.933200194),new $Xb.kq(33,59.933822196),new $Xb.kq(34,60.932479381),new $Xb.kq(35,61.934054212),new $Xb.kq(36,62.933615218),new $Xb.kq(37,63.935813523),new $Xb.kq(38,64.936484581),new $Xb.kq(39,65.939825412),new $Xb.kq(40,66.94061),new $Xb.kq(41,67.94436),new $Xb.kq(42,68.9452),new $Xb.kq(43,69.94981),new $Xb.kq(44,70.95173),new $Xb.kq(45,71.95641)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(22,49.99593),new $Xb.kq(23,50.98772),new $Xb.kq(24,51.97568),new $Xb.kq(25,52.96846),new $Xb.kq(26,53.957910508),new $Xb.kq(27,54.951336329),new $Xb.kq(28,55.942136339),new $Xb.kq(29,56.939800489),new $Xb.kq(30,57.935347922),new $Xb.kq(31,58.934351553),new $Xb.kq(32,59.930790633),new $Xb.kq(33,60.931060442),new $Xb.kq(34,61.928348763),new $Xb.kq(35,62.929672948),new $Xb.kq(36,63.927969574),new $Xb.kq(37,64.930088013),new $Xb.kq(38,65.929115232),new $Xb.kq(39,66.931569638),new $Xb.kq(40,67.931844932),new $Xb.kq(41,68.935181837),new $Xb.kq(42,69.93614),new $Xb.kq(43,70.94),new $Xb.kq(44,71.9413),new $Xb.kq(45,72.94608),new $Xb.kq(46,73.94791),new $Xb.kq(47,74.95297),new $Xb.kq(48,75.95533),new $Xb.kq(49,76.96083),new $Xb.kq(50,77.9638)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(23,51.99718),new $Xb.kq(24,52.98555),new $Xb.kq(25,53.97671),new $Xb.kq(26,54.96605),new $Xb.kq(27,55.95856),new $Xb.kq(28,56.949215695),new $Xb.kq(29,57.944540734),new $Xb.kq(30,58.939504114),new $Xb.kq(31,59.937368123),new $Xb.kq(32,60.933462181),new $Xb.kq(33,61.932587299),new $Xb.kq(34,62.929601079),new $Xb.kq(35,63.929767865),new $Xb.kq(36,64.927793707),new $Xb.kq(37,65.928873041),new $Xb.kq(38,66.927750294),new $Xb.kq(39,67.929637875),new $Xb.kq(40,68.929425281),new $Xb.kq(41,69.932409287),new $Xb.kq(42,70.932619818),new $Xb.kq(43,71.93552),new $Xb.kq(44,72.93649),new $Xb.kq(45,73.9402),new $Xb.kq(46,74.9417),new $Xb.kq(47,75.94599),new $Xb.kq(48,76.94795),new $Xb.kq(49,77.95281),new $Xb.kq(50,78.95528),new $Xb.kq(51,79.96189)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(24,53.99295),new $Xb.kq(25,54.98398),new $Xb.kq(26,55.97238),new $Xb.kq(27,56.96491),new $Xb.kq(28,57.954596465),new $Xb.kq(29,58.949267074),new $Xb.kq(30,59.941832031),new $Xb.kq(31,60.939513907),new $Xb.kq(32,61.934334132),new $Xb.kq(33,62.933215563),new $Xb.kq(34,63.929146578),new $Xb.kq(35,64.929245079),new $Xb.kq(36,65.926036763),new $Xb.kq(37,66.927130859),new $Xb.kq(38,67.924847566),new $Xb.kq(39,68.926553538),new $Xb.kq(40,69.92532487),new $Xb.kq(41,70.927727195),new $Xb.kq(42,71.926861122),new $Xb.kq(43,72.929779469),new $Xb.kq(44,73.929458261),new $Xb.kq(45,74.932937379),new $Xb.kq(46,75.933394207),new $Xb.kq(47,76.937085857),new $Xb.kq(48,77.938569576),new $Xb.kq(49,78.942095175),new $Xb.kq(50,79.944414722),new $Xb.kq(51,80.95048),new $Xb.kq(52,81.95484)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(25,55.99491),new $Xb.kq(26,56.98293),new $Xb.kq(27,57.97425),new $Xb.kq(28,58.96337),new $Xb.kq(29,59.95706),new $Xb.kq(30,60.94917),new $Xb.kq(31,61.944179608),new $Xb.kq(32,62.939141527),new $Xb.kq(33,63.936838307),new $Xb.kq(34,64.932739322),new $Xb.kq(35,65.931592355),new $Xb.kq(36,66.928204915),new $Xb.kq(37,67.927983497),new $Xb.kq(38,68.925580912),new $Xb.kq(39,69.926027741),new $Xb.kq(40,70.92470501),new $Xb.kq(41,71.92636935),new $Xb.kq(42,72.925169832),new $Xb.kq(43,73.926940999),new $Xb.kq(44,74.926500645),new $Xb.kq(45,75.928928262),new $Xb.kq(46,76.929281189),new $Xb.kq(47,77.93165595),new $Xb.kq(48,78.932916371),new $Xb.kq(49,79.936588154),new $Xb.kq(50,80.937752955),new $Xb.kq(51,81.94316),new $Xb.kq(52,82.94687),new $Xb.kq(53,83.95234)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(26,57.99101),new $Xb.kq(27,58.98175),new $Xb.kq(28,59.97019),new $Xb.kq(29,60.96379),new $Xb.kq(30,61.95465),new $Xb.kq(31,62.94964),new $Xb.kq(32,63.941572638),new $Xb.kq(33,64.939440762),new $Xb.kq(34,65.933846798),new $Xb.kq(35,66.932738415),new $Xb.kq(36,67.928097266),new $Xb.kq(37,68.927972002),new $Xb.kq(38,69.924250365),new $Xb.kq(39,70.924953991),new $Xb.kq(40,71.922076184),new $Xb.kq(41,72.923459361),new $Xb.kq(42,73.921178213),new $Xb.kq(43,74.922859494),new $Xb.kq(44,75.921402716),new $Xb.kq(45,76.923548462),new $Xb.kq(46,77.922852886),new $Xb.kq(47,78.92540156),new $Xb.kq(48,79.925444764),new $Xb.kq(49,80.928821065),new $Xb.kq(50,81.929550326),new $Xb.kq(51,82.93451),new $Xb.kq(52,83.93731),new $Xb.kq(53,84.94269),new $Xb.kq(54,85.94627)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(27,59.99313),new $Xb.kq(28,60.98062),new $Xb.kq(29,61.9732),new $Xb.kq(30,62.96369),new $Xb.kq(31,63.957572),new $Xb.kq(32,64.949484),new $Xb.kq(33,65.944099147),new $Xb.kq(34,66.939190417),new $Xb.kq(35,67.936792976),new $Xb.kq(36,68.932280154),new $Xb.kq(37,69.930927811),new $Xb.kq(38,70.927114724),new $Xb.kq(39,71.926752647),new $Xb.kq(40,72.923825288),new $Xb.kq(41,73.923929076),new $Xb.kq(42,74.921596417),new $Xb.kq(43,75.922393933),new $Xb.kq(44,76.920647703),new $Xb.kq(45,77.921828577),new $Xb.kq(46,78.920948498),new $Xb.kq(47,79.922578162),new $Xb.kq(48,80.922132884),new $Xb.kq(49,81.924504668),new $Xb.kq(50,82.924980625),new $Xb.kq(51,83.92906),new $Xb.kq(52,84.93181),new $Xb.kq(53,85.93623),new $Xb.kq(54,86.93958),new $Xb.kq(55,87.94456),new $Xb.kq(56,88.94923)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(31,64.96466),new $Xb.kq(32,65.95521),new $Xb.kq(33,66.95009),new $Xb.kq(34,67.94187),new $Xb.kq(35,68.939562155),new $Xb.kq(36,69.933504),new $Xb.kq(37,70.931868378),new $Xb.kq(38,71.927112313),new $Xb.kq(39,72.9267668),new $Xb.kq(40,73.922476561),new $Xb.kq(41,74.922523571),new $Xb.kq(42,75.919214107),new $Xb.kq(43,76.91991461),new $Xb.kq(44,77.917309522),new $Xb.kq(45,78.918499802),new $Xb.kq(46,79.916521828),new $Xb.kq(47,80.917992931),new $Xb.kq(48,81.9167),new $Xb.kq(49,82.919119072),new $Xb.kq(50,83.918464523),new $Xb.kq(51,84.922244678),new $Xb.kq(52,85.924271165),new $Xb.kq(53,86.928520749),new $Xb.kq(54,87.931423982),new $Xb.kq(55,88.93602),new $Xb.kq(56,89.93942),new $Xb.kq(57,90.94537),new $Xb.kq(58,91.94933)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(32,66.96479),new $Xb.kq(33,67.958248),new $Xb.kq(34,68.950178),new $Xb.kq(35,69.944208),new $Xb.kq(36,70.939246),new $Xb.kq(37,71.936496876),new $Xb.kq(38,72.931794889),new $Xb.kq(39,73.929891152),new $Xb.kq(40,74.92577641),new $Xb.kq(41,75.924541974),new $Xb.kq(42,76.921380123),new $Xb.kq(43,77.92114613),new $Xb.kq(44,78.918337647),new $Xb.kq(45,79.918529952),new $Xb.kq(46,80.91629106),new $Xb.kq(47,81.916804666),new $Xb.kq(48,82.915180219),new $Xb.kq(49,83.916503685),new $Xb.kq(50,84.915608027),new $Xb.kq(51,85.918797162),new $Xb.kq(52,86.920710713),new $Xb.kq(53,87.924065908),new $Xb.kq(54,88.92638726),new $Xb.kq(55,89.930634988),new $Xb.kq(56,90.9339653),new $Xb.kq(57,91.939255258),new $Xb.kq(58,92.9431),new $Xb.kq(59,93.94868)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(33,68.96532),new $Xb.kq(34,69.95601),new $Xb.kq(35,70.95051),new $Xb.kq(36,71.94190754),new $Xb.kq(37,72.938931115),new $Xb.kq(38,73.933258225),new $Xb.kq(39,74.931033794),new $Xb.kq(40,75.925948304),new $Xb.kq(41,76.92466788),new $Xb.kq(42,77.920386271),new $Xb.kq(43,78.920082992),new $Xb.kq(44,79.91637804),new $Xb.kq(45,80.916592419),new $Xb.kq(46,81.913484601),new $Xb.kq(47,82.914135952),new $Xb.kq(48,83.911506627),new $Xb.kq(49,84.912526954),new $Xb.kq(50,85.910610313),new $Xb.kq(51,86.913354251),new $Xb.kq(52,87.914446951),new $Xb.kq(53,88.917632505),new $Xb.kq(54,89.919523803),new $Xb.kq(55,90.923442418),new $Xb.kq(56,91.926152752),new $Xb.kq(57,92.931265246),new $Xb.kq(58,93.934362),new $Xb.kq(59,94.93984),new $Xb.kq(60,95.94307),new $Xb.kq(61,96.94856)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(34,70.96532),new $Xb.kq(35,71.95908),new $Xb.kq(36,72.950366),new $Xb.kq(37,73.944470376),new $Xb.kq(38,74.938569199),new $Xb.kq(39,75.935071448),new $Xb.kq(40,76.930406599),new $Xb.kq(41,77.928141485),new $Xb.kq(42,78.923996719),new $Xb.kq(43,79.922519322),new $Xb.kq(44,80.918994165),new $Xb.kq(45,81.918207691),new $Xb.kq(46,82.915111951),new $Xb.kq(47,83.914384676),new $Xb.kq(48,84.911789341),new $Xb.kq(49,85.91116708),new $Xb.kq(50,86.909183465),new $Xb.kq(51,87.911318556),new $Xb.kq(52,88.912279939),new $Xb.kq(53,89.914808941),new $Xb.kq(54,90.91653416),new $Xb.kq(55,91.919725442),new $Xb.kq(56,92.922032765),new $Xb.kq(57,93.926407326),new $Xb.kq(58,94.92931926),new $Xb.kq(59,95.934283962),new $Xb.kq(60,96.937342863),new $Xb.kq(61,97.941703557),new $Xb.kq(62,98.945420616),new $Xb.kq(63,99.94987),new $Xb.kq(64,100.953195994),new $Xb.kq(65,101.95921)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(35,72.96597),new $Xb.kq(36,73.95631),new $Xb.kq(37,74.94992),new $Xb.kq(38,75.94161),new $Xb.kq(39,76.937761511),new $Xb.kq(40,77.932179362),new $Xb.kq(41,78.929707076),new $Xb.kq(42,79.924524588),new $Xb.kq(43,80.923213095),new $Xb.kq(44,81.918401258),new $Xb.kq(45,82.917555029),new $Xb.kq(46,83.913424778),new $Xb.kq(47,84.912932689),new $Xb.kq(48,85.909262351),new $Xb.kq(49,86.908879316),new $Xb.kq(50,87.905614339),new $Xb.kq(51,88.907452906),new $Xb.kq(52,89.907737596),new $Xb.kq(53,90.910209845),new $Xb.kq(54,91.911029895),new $Xb.kq(55,92.91402241),new $Xb.kq(56,93.915359856),new $Xb.kq(57,94.919358213),new $Xb.kq(58,95.921680473),new $Xb.kq(59,96.926148757),new $Xb.kq(60,97.928471177),new $Xb.kq(61,98.933315038),new $Xb.kq(62,99.935351729),new $Xb.kq(63,100.940517434),new $Xb.kq(64,101.943018795),new $Xb.kq(65,102.94895),new $Xb.kq(66,103.95233)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(38,76.94962),new $Xb.kq(39,77.9435),new $Xb.kq(40,78.937350712),new $Xb.kq(41,79.931982402),new $Xb.kq(42,80.929128719),new $Xb.kq(43,81.926792071),new $Xb.kq(44,82.922352572),new $Xb.kq(45,83.920387768),new $Xb.kq(46,84.916427076),new $Xb.kq(47,85.914887724),new $Xb.kq(48,86.910877833),new $Xb.kq(49,87.909503361),new $Xb.kq(50,88.905847902),new $Xb.kq(51,89.907151443),new $Xb.kq(52,90.907303415),new $Xb.kq(53,91.908946832),new $Xb.kq(54,92.909581582),new $Xb.kq(55,93.911594008),new $Xb.kq(56,94.912823709),new $Xb.kq(57,95.915897787),new $Xb.kq(58,96.918131017),new $Xb.kq(59,97.922219525),new $Xb.kq(60,98.924634736),new $Xb.kq(61,99.927756402),new $Xb.kq(62,100.930313395),new $Xb.kq(63,101.933555501),new $Xb.kq(64,102.93694),new $Xb.kq(65,103.94145),new $Xb.kq(66,104.94509),new $Xb.kq(67,105.95022)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(39,78.94916),new $Xb.kq(40,79.94055),new $Xb.kq(41,80.936815296),new $Xb.kq(42,81.931086249),new $Xb.kq(43,82.92865213),new $Xb.kq(44,83.92325),new $Xb.kq(45,84.92146522),new $Xb.kq(46,85.916472851),new $Xb.kq(47,86.914816578),new $Xb.kq(48,87.910226179),new $Xb.kq(49,88.908888916),new $Xb.kq(50,89.904703679),new $Xb.kq(51,90.905644968),new $Xb.kq(52,91.905040106),new $Xb.kq(53,92.906475627),new $Xb.kq(54,93.906315765),new $Xb.kq(55,94.908042739),new $Xb.kq(56,95.908275675),new $Xb.kq(57,96.910950716),new $Xb.kq(58,97.912746366),new $Xb.kq(59,98.916511084),new $Xb.kq(60,99.917761704),new $Xb.kq(61,100.921139958),new $Xb.kq(62,101.922981089),new $Xb.kq(63,102.926597062),new $Xb.kq(64,103.92878),new $Xb.kq(65,104.93305),new $Xb.kq(66,105.93591),new $Xb.kq(67,106.94086),new $Xb.kq(68,107.94428)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(40,80.94905),new $Xb.kq(41,81.94313),new $Xb.kq(42,82.936703713),new $Xb.kq(43,83.93357),new $Xb.kq(44,84.927906486),new $Xb.kq(45,85.925037588),new $Xb.kq(46,86.920361435),new $Xb.kq(47,87.91833144),new $Xb.kq(48,88.913495503),new $Xb.kq(49,89.911264109),new $Xb.kq(50,90.906990538),new $Xb.kq(51,91.907193214),new $Xb.kq(52,92.906377543),new $Xb.kq(53,93.907283457),new $Xb.kq(54,94.906835178),new $Xb.kq(55,95.908100076),new $Xb.kq(56,96.908097144),new $Xb.kq(57,97.91033069),new $Xb.kq(58,98.911617864),new $Xb.kq(59,99.914181434),new $Xb.kq(60,100.915251567),new $Xb.kq(61,101.918037417),new $Xb.kq(62,102.919141297),new $Xb.kq(63,103.922459464),new $Xb.kq(64,104.923934023),new $Xb.kq(65,105.92819),new $Xb.kq(66,106.93031),new $Xb.kq(67,107.93501),new $Xb.kq(68,108.93763),new $Xb.kq(69,109.94268)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(41,82.94874),new $Xb.kq(42,83.94009),new $Xb.kq(43,84.93659),new $Xb.kq(44,85.930695167),new $Xb.kq(45,86.92732683),new $Xb.kq(46,87.921952728),new $Xb.kq(47,88.919480562),new $Xb.kq(48,89.913936161),new $Xb.kq(49,90.911750754),new $Xb.kq(50,91.90681048),new $Xb.kq(51,92.906812213),new $Xb.kq(52,93.905087578),new $Xb.kq(53,94.905841487),new $Xb.kq(54,95.904678904),new $Xb.kq(55,96.906021033),new $Xb.kq(56,97.905407846),new $Xb.kq(57,98.907711598),new $Xb.kq(58,99.907477149),new $Xb.kq(59,100.910346543),new $Xb.kq(60,101.910297162),new $Xb.kq(61,102.913204596),new $Xb.kq(62,103.913758387),new $Xb.kq(63,104.916972087),new $Xb.kq(64,105.918134284),new $Xb.kq(65,106.921694724),new $Xb.kq(66,107.923973837),new $Xb.kq(67,108.92781),new $Xb.kq(68,109.92973),new $Xb.kq(69,110.93451),new $Xb.kq(70,111.93684),new $Xb.kq(71,112.94203)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(42,84.94894),new $Xb.kq(43,85.94288),new $Xb.kq(44,86.93653),new $Xb.kq(45,87.93283),new $Xb.kq(46,88.92754288),new $Xb.kq(47,89.92355583),new $Xb.kq(48,90.9184282),new $Xb.kq(49,91.915259655),new $Xb.kq(50,92.910248473),new $Xb.kq(51,93.909656309),new $Xb.kq(52,94.907656454),new $Xb.kq(53,95.907870803),new $Xb.kq(54,96.906364843),new $Xb.kq(55,97.907215692),new $Xb.kq(56,98.906254554),new $Xb.kq(57,99.907657594),new $Xb.kq(58,100.90731438),new $Xb.kq(59,101.909212938),new $Xb.kq(60,102.909178805),new $Xb.kq(61,103.911444898),new $Xb.kq(62,104.911658043),new $Xb.kq(63,105.914355408),new $Xb.kq(64,106.915081691),new $Xb.kq(65,107.918479973),new $Xb.kq(66,108.919980998),new $Xb.kq(67,109.92339),new $Xb.kq(68,110.92505),new $Xb.kq(69,111.92924),new $Xb.kq(70,112.93133),new $Xb.kq(71,113.93588),new $Xb.kq(72,114.93828)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(43,86.94918),new $Xb.kq(44,87.94042),new $Xb.kq(45,88.93611),new $Xb.kq(46,89.92978),new $Xb.kq(47,90.926377434),new $Xb.kq(48,91.92012),new $Xb.kq(49,92.917051523),new $Xb.kq(50,93.911359569),new $Xb.kq(51,94.910412729),new $Xb.kq(52,95.907597681),new $Xb.kq(53,96.907554546),new $Xb.kq(54,97.905287111),new $Xb.kq(55,98.905939307),new $Xb.kq(56,99.904219664),new $Xb.kq(57,100.905582219),new $Xb.kq(58,101.904349503),new $Xb.kq(59,102.906323677),new $Xb.kq(60,103.905430145),new $Xb.kq(61,104.907750341),new $Xb.kq(62,105.907326913),new $Xb.kq(63,106.909907207),new $Xb.kq(64,107.910192211),new $Xb.kq(65,108.913201565),new $Xb.kq(66,109.913966185),new $Xb.kq(67,110.91756),new $Xb.kq(68,111.918821673),new $Xb.kq(69,112.92254),new $Xb.kq(70,113.923891981),new $Xb.kq(71,114.92831),new $Xb.kq(72,115.93016),new $Xb.kq(73,116.93479),new $Xb.kq(74,117.93703)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(44,88.94938),new $Xb.kq(45,89.94287),new $Xb.kq(46,90.93655),new $Xb.kq(47,91.93198),new $Xb.kq(48,92.92574),new $Xb.kq(49,93.921698),new $Xb.kq(50,94.915898541),new $Xb.kq(51,95.914518212),new $Xb.kq(52,96.911336643),new $Xb.kq(53,97.910716431),new $Xb.kq(54,98.908132101),new $Xb.kq(55,99.90811663),new $Xb.kq(56,100.906163526),new $Xb.kq(57,101.906842845),new $Xb.kq(58,102.905504182),new $Xb.kq(59,103.906655315),new $Xb.kq(60,104.905692444),new $Xb.kq(61,105.907284615),new $Xb.kq(62,106.90675054),new $Xb.kq(63,107.908730768),new $Xb.kq(64,108.908735621),new $Xb.kq(65,109.910949525),new $Xb.kq(66,110.91166),new $Xb.kq(67,111.913969253),new $Xb.kq(68,112.91542),new $Xb.kq(69,113.91734336),new $Xb.kq(70,114.920124676),new $Xb.kq(71,115.922746643),new $Xb.kq(72,116.92535),new $Xb.kq(73,117.92943),new $Xb.kq(74,118.93136),new $Xb.kq(75,119.93578),new $Xb.kq(76,120.93808)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(45,90.94948),new $Xb.kq(46,91.94042),new $Xb.kq(47,92.93591),new $Xb.kq(48,93.92877),new $Xb.kq(49,94.92469),new $Xb.kq(50,95.91822194),new $Xb.kq(51,96.916478921),new $Xb.kq(52,97.912720751),new $Xb.kq(53,98.911767757),new $Xb.kq(54,99.908504596),new $Xb.kq(55,100.908289144),new $Xb.kq(56,101.905607716),new $Xb.kq(57,102.906087204),new $Xb.kq(58,103.904034912),new $Xb.kq(59,104.905084046),new $Xb.kq(60,105.903483087),new $Xb.kq(61,106.905128453),new $Xb.kq(62,107.903894451),new $Xb.kq(63,108.905953535),new $Xb.kq(64,109.905152385),new $Xb.kq(65,110.907643952),new $Xb.kq(66,111.907313277),new $Xb.kq(67,112.910151346),new $Xb.kq(68,113.910365322),new $Xb.kq(69,114.91368341),new $Xb.kq(70,115.914158288),new $Xb.kq(71,116.91784),new $Xb.kq(72,117.918983915),new $Xb.kq(73,118.92268),new $Xb.kq(74,119.92403),new $Xb.kq(75,120.92818),new $Xb.kq(76,121.9298),new $Xb.kq(77,122.93426)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(47,93.94278),new $Xb.kq(48,94.93548),new $Xb.kq(49,95.93068),new $Xb.kq(50,96.924),new $Xb.kq(51,97.921759995),new $Xb.kq(52,98.917597103),new $Xb.kq(53,99.916069387),new $Xb.kq(54,100.912802135),new $Xb.kq(55,101.911999996),new $Xb.kq(56,102.908972453),new $Xb.kq(57,103.908628228),new $Xb.kq(58,104.906528234),new $Xb.kq(59,105.906666431),new $Xb.kq(60,106.90509302),new $Xb.kq(61,107.905953705),new $Xb.kq(62,108.904755514),new $Xb.kq(63,109.90611046),new $Xb.kq(64,110.905294679),new $Xb.kq(65,111.907004132),new $Xb.kq(66,112.906565708),new $Xb.kq(67,113.908807907),new $Xb.kq(68,114.908762282),new $Xb.kq(69,115.911359558),new $Xb.kq(70,116.911684187),new $Xb.kq(71,117.914582383),new $Xb.kq(72,118.915666045),new $Xb.kq(73,119.918788609),new $Xb.kq(74,120.919851074),new $Xb.kq(75,121.92332),new $Xb.kq(76,122.9249),new $Xb.kq(77,123.92853),new $Xb.kq(78,124.93054),new $Xb.kq(79,125.9345),new $Xb.kq(80,126.93688)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(48,95.93977),new $Xb.kq(49,96.93494),new $Xb.kq(50,97.927579),new $Xb.kq(51,98.92501),new $Xb.kq(52,99.920230232),new $Xb.kq(53,100.918681442),new $Xb.kq(54,101.914777255),new $Xb.kq(55,102.913418952),new $Xb.kq(56,103.909848091),new $Xb.kq(57,104.909467818),new $Xb.kq(58,105.906458007),new $Xb.kq(59,106.906614232),new $Xb.kq(60,107.904183403),new $Xb.kq(61,108.904985569),new $Xb.kq(62,109.903005578),new $Xb.kq(63,110.904181628),new $Xb.kq(64,111.902757226),new $Xb.kq(65,112.904400947),new $Xb.kq(66,113.903358121),new $Xb.kq(67,114.905430553),new $Xb.kq(68,115.904755434),new $Xb.kq(69,116.907218242),new $Xb.kq(70,117.906914144),new $Xb.kq(71,118.909922582),new $Xb.kq(72,119.909851352),new $Xb.kq(73,120.91298039),new $Xb.kq(74,121.9135),new $Xb.kq(75,122.917003675),new $Xb.kq(76,123.917648302),new $Xb.kq(77,124.92124717),new $Xb.kq(78,125.922353996),new $Xb.kq(79,126.926434822),new $Xb.kq(80,127.927760617),new $Xb.kq(81,128.93226),new $Xb.kq(82,129.93398)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(49,97.94224),new $Xb.kq(50,98.93461),new $Xb.kq(51,99.931149033),new $Xb.kq(52,100.92656),new $Xb.kq(53,101.924707541),new $Xb.kq(54,102.919913896),new $Xb.kq(55,103.918338416),new $Xb.kq(56,104.914673434),new $Xb.kq(57,105.913461134),new $Xb.kq(58,106.910292195),new $Xb.kq(59,107.909719683),new $Xb.kq(60,108.907154078),new $Xb.kq(61,109.907168783),new $Xb.kq(62,110.905110677),new $Xb.kq(63,111.905533338),new $Xb.kq(64,112.904061223),new $Xb.kq(65,113.904916758),new $Xb.kq(66,114.903878328),new $Xb.kq(67,115.905259995),new $Xb.kq(68,116.904515731),new $Xb.kq(69,117.906354623),new $Xb.kq(70,118.905846334),new $Xb.kq(71,119.907961505),new $Xb.kq(72,120.907848847),new $Xb.kq(73,121.910277103),new $Xb.kq(74,122.910438951),new $Xb.kq(75,123.913175916),new $Xb.kq(76,124.913601387),new $Xb.kq(77,125.916464532),new $Xb.kq(78,126.917344048),new $Xb.kq(79,127.920170658),new $Xb.kq(80,128.921657958),new $Xb.kq(81,129.924854941),new $Xb.kq(82,130.926767408),new $Xb.kq(83,131.932919005),new $Xb.kq(84,132.93834),new $Xb.kq(85,133.94466)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(50,99.938954),new $Xb.kq(51,100.93606),new $Xb.kq(52,101.93049),new $Xb.kq(53,102.92813),new $Xb.kq(54,103.923185469),new $Xb.kq(55,104.921390409),new $Xb.kq(56,105.916880472),new $Xb.kq(57,106.915666702),new $Xb.kq(58,107.911965339),new $Xb.kq(59,108.911286879),new $Xb.kq(60,109.907852688),new $Xb.kq(61,110.907735404),new $Xb.kq(62,111.90482081),new $Xb.kq(63,112.905173373),new $Xb.kq(64,113.902781816),new $Xb.kq(65,114.903345973),new $Xb.kq(66,115.901744149),new $Xb.kq(67,116.902953765),new $Xb.kq(68,117.901606328),new $Xb.kq(69,118.90330888),new $Xb.kq(70,119.902196571),new $Xb.kq(71,120.904236867),new $Xb.kq(72,121.903440138),new $Xb.kq(73,122.905721901),new $Xb.kq(74,123.90527463),new $Xb.kq(75,124.907784924),new $Xb.kq(76,125.907653953),new $Xb.kq(77,126.91035098),new $Xb.kq(78,127.910534953),new $Xb.kq(79,128.913439976),new $Xb.kq(80,129.913852185),new $Xb.kq(81,130.916919144),new $Xb.kq(82,131.917744455),new $Xb.kq(83,132.923814085),new $Xb.kq(84,133.928463576),new $Xb.kq(85,134.93473),new $Xb.kq(86,135.93934),new $Xb.kq(87,136.94579)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(52,102.94012),new $Xb.kq(53,103.936287),new $Xb.kq(54,104.931528593),new $Xb.kq(55,105.928183134),new $Xb.kq(56,106.92415),new $Xb.kq(57,107.92216),new $Xb.kq(58,108.918136092),new $Xb.kq(59,109.917533911),new $Xb.kq(60,110.912534147),new $Xb.kq(61,111.91239464),new $Xb.kq(62,112.909377941),new $Xb.kq(63,113.909095876),new $Xb.kq(64,114.906598812),new $Xb.kq(65,115.906797235),new $Xb.kq(66,116.90483959),new $Xb.kq(67,117.905531885),new $Xb.kq(68,118.90394646),new $Xb.kq(69,119.905074315),new $Xb.kq(70,120.903818044),new $Xb.kq(71,121.905175415),new $Xb.kq(72,122.904215696),new $Xb.kq(73,123.905937525),new $Xb.kq(74,124.905247804),new $Xb.kq(75,125.907248153),new $Xb.kq(76,126.906914564),new $Xb.kq(77,127.90916733),new $Xb.kq(78,128.909150092),new $Xb.kq(79,129.911546459),new $Xb.kq(80,130.911946487),new $Xb.kq(81,131.914413247),new $Xb.kq(82,132.915236466),new $Xb.kq(83,133.920551554),new $Xb.kq(84,134.925167962),new $Xb.kq(85,135.93066),new $Xb.kq(86,136.93531),new $Xb.kq(87,137.94096),new $Xb.kq(88,138.94571)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(54,105.937702),new $Xb.kq(55,106.935036),new $Xb.kq(56,107.929486838),new $Xb.kq(57,108.927456483),new $Xb.kq(58,109.922407164),new $Xb.kq(59,110.921120589),new $Xb.kq(60,111.917061617),new $Xb.kq(61,112.915452551),new $Xb.kq(62,113.912498025),new $Xb.kq(63,114.911578627),new $Xb.kq(64,115.908420253),new $Xb.kq(65,116.90863418),new $Xb.kq(66,117.905825187),new $Xb.kq(67,118.90640811),new $Xb.kq(68,119.904019891),new $Xb.kq(69,120.904929815),new $Xb.kq(70,121.903047064),new $Xb.kq(71,122.904272951),new $Xb.kq(72,123.902819466),new $Xb.kq(73,124.904424718),new $Xb.kq(74,125.903305543),new $Xb.kq(75,126.90521729),new $Xb.kq(76,127.904461383),new $Xb.kq(77,128.906595593),new $Xb.kq(78,129.906222753),new $Xb.kq(79,130.90852188),new $Xb.kq(80,131.908523782),new $Xb.kq(81,132.910939068),new $Xb.kq(82,133.911540546),new $Xb.kq(83,134.916450782),new $Xb.kq(84,135.920103155),new $Xb.kq(85,136.925324769),new $Xb.kq(86,137.92922),new $Xb.kq(87,138.93473),new $Xb.kq(88,139.9387),new $Xb.kq(89,140.94439),new $Xb.kq(90,141.9485)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(55,107.943291),new $Xb.kq(56,108.938191658),new $Xb.kq(57,109.934634181),new $Xb.kq(58,110.930276),new $Xb.kq(59,111.92797),new $Xb.kq(60,112.923644245),new $Xb.kq(61,113.92185),new $Xb.kq(62,114.918272),new $Xb.kq(63,115.916735014),new $Xb.kq(64,116.913647692),new $Xb.kq(65,117.91337523),new $Xb.kq(66,118.910180837),new $Xb.kq(67,119.910047843),new $Xb.kq(68,120.907366063),new $Xb.kq(69,121.907592451),new $Xb.kq(70,122.905597944),new $Xb.kq(71,123.906211423),new $Xb.kq(72,124.90462415),new $Xb.kq(73,125.905619387),new $Xb.kq(74,126.90446842),new $Xb.kq(75,127.905805254),new $Xb.kq(76,128.904987487),new $Xb.kq(77,129.906674018),new $Xb.kq(78,130.906124168),new $Xb.kq(79,131.907994525),new $Xb.kq(80,132.907806465),new $Xb.kq(81,133.909876552),new $Xb.kq(82,134.91005031),new $Xb.kq(83,135.914655105),new $Xb.kq(84,136.917872653),new $Xb.kq(85,137.922383666),new $Xb.kq(86,138.926093402),new $Xb.kq(87,139.93121),new $Xb.kq(88,140.93483),new $Xb.kq(89,141.94018),new $Xb.kq(90,142.94407),new $Xb.kq(91,143.94961)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(56,109.944476),new $Xb.kq(57,110.941632),new $Xb.kq(58,111.93566535),new $Xb.kq(59,112.933382836),new $Xb.kq(60,113.928145),new $Xb.kq(61,114.926979032),new $Xb.kq(62,115.921394197),new $Xb.kq(63,116.920564355),new $Xb.kq(64,117.91657092),new $Xb.kq(65,118.915554295),new $Xb.kq(66,119.91215199),new $Xb.kq(67,120.911386497),new $Xb.kq(68,121.908548396),new $Xb.kq(69,122.908470748),new $Xb.kq(70,123.905895774),new $Xb.kq(71,124.906398236),new $Xb.kq(72,125.904268868),new $Xb.kq(73,126.905179581),new $Xb.kq(74,127.903530436),new $Xb.kq(75,128.904779458),new $Xb.kq(76,129.903507903),new $Xb.kq(77,130.90508192),new $Xb.kq(78,131.904154457),new $Xb.kq(79,132.90590566),new $Xb.kq(80,133.905394504),new $Xb.kq(81,134.907207499),new $Xb.kq(82,135.907219526),new $Xb.kq(83,136.911562939),new $Xb.kq(84,137.913988549),new $Xb.kq(85,138.918786859),new $Xb.kq(86,139.921635665),new $Xb.kq(87,140.926646282),new $Xb.kq(88,141.929702981),new $Xb.kq(89,142.93489),new $Xb.kq(90,143.93823),new $Xb.kq(91,144.94367),new $Xb.kq(92,145.9473),new $Xb.kq(93,146.95301)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(57,111.950331),new $Xb.kq(58,112.944535512),new $Xb.kq(59,113.940841319),new $Xb.kq(60,114.935939),new $Xb.kq(61,115.932914152),new $Xb.kq(62,116.928639484),new $Xb.kq(63,117.926554883),new $Xb.kq(64,118.922370879),new $Xb.kq(65,119.920678219),new $Xb.kq(66,120.917183637),new $Xb.kq(67,121.916121946),new $Xb.kq(68,122.912990168),new $Xb.kq(69,123.912245731),new $Xb.kq(70,124.909724871),new $Xb.kq(71,125.909447953),new $Xb.kq(72,126.9074176),new $Xb.kq(73,127.907747919),new $Xb.kq(74,128.906063369),new $Xb.kq(75,129.906706163),new $Xb.kq(76,130.905460232),new $Xb.kq(77,131.906429799),new $Xb.kq(78,132.90544687),new $Xb.kq(79,133.906713419),new $Xb.kq(80,134.905971903),new $Xb.kq(81,135.907305741),new $Xb.kq(82,136.907083505),new $Xb.kq(83,137.911010537),new $Xb.kq(84,138.913357921),new $Xb.kq(85,139.917277075),new $Xb.kq(86,140.920043984),new $Xb.kq(87,141.924292317),new $Xb.kq(88,142.927330292),new $Xb.kq(89,143.932027373),new $Xb.kq(90,144.935388226),new $Xb.kq(91,145.940162028),new $Xb.kq(92,146.943864435),new $Xb.kq(93,147.948899539),new $Xb.kq(94,148.95272),new $Xb.kq(95,149.95797),new $Xb.kq(96,150.962)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(58,113.950941),new $Xb.kq(59,114.94771),new $Xb.kq(60,115.94168),new $Xb.kq(61,116.937700229),new $Xb.kq(62,117.93344),new $Xb.kq(63,118.931051927),new $Xb.kq(64,119.926045941),new $Xb.kq(65,120.924485908),new $Xb.kq(66,121.92026),new $Xb.kq(67,122.91885),new $Xb.kq(68,123.915088437),new $Xb.kq(69,124.914620234),new $Xb.kq(70,125.911244146),new $Xb.kq(71,126.911121328),new $Xb.kq(72,127.90830887),new $Xb.kq(73,128.908673749),new $Xb.kq(74,129.906310478),new $Xb.kq(75,130.906930798),new $Xb.kq(76,131.905056152),new $Xb.kq(77,132.906002368),new $Xb.kq(78,133.904503347),new $Xb.kq(79,134.905682749),new $Xb.kq(80,135.904570109),new $Xb.kq(81,136.905821414),new $Xb.kq(82,137.905241273),new $Xb.kq(83,138.908835384),new $Xb.kq(84,139.910599485),new $Xb.kq(85,140.914406439),new $Xb.kq(86,141.916448175),new $Xb.kq(87,142.920617184),new $Xb.kq(88,143.922940468),new $Xb.kq(89,144.926923807),new $Xb.kq(90,145.930106645),new $Xb.kq(91,146.933992519),new $Xb.kq(92,147.937682377),new $Xb.kq(93,148.94246),new $Xb.kq(94,149.94562),new $Xb.kq(95,150.9507),new $Xb.kq(96,151.95416),new $Xb.kq(97,152.95961)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(60,116.95001),new $Xb.kq(61,117.94657),new $Xb.kq(62,118.94099),new $Xb.kq(63,119.93807),new $Xb.kq(64,120.93301),new $Xb.kq(65,121.93071),new $Xb.kq(66,122.92624),new $Xb.kq(67,123.92453),new $Xb.kq(68,124.92067),new $Xb.kq(69,125.91937),new $Xb.kq(70,126.91616),new $Xb.kq(71,127.91544794),new $Xb.kq(72,128.912667334),new $Xb.kq(73,129.91232),new $Xb.kq(74,130.910108489),new $Xb.kq(75,131.910110399),new $Xb.kq(76,132.908396372),new $Xb.kq(77,133.908489607),new $Xb.kq(78,134.906971003),new $Xb.kq(79,135.907651181),new $Xb.kq(80,136.906465656),new $Xb.kq(81,137.907106826),new $Xb.kq(82,138.90634816),new $Xb.kq(83,139.909472552),new $Xb.kq(84,140.910957016),new $Xb.kq(85,141.914074489),new $Xb.kq(86,142.916058646),new $Xb.kq(87,143.919591666),new $Xb.kq(88,144.92163837),new $Xb.kq(89,145.925700146),new $Xb.kq(90,146.927819639),new $Xb.kq(91,147.932191197),new $Xb.kq(92,148.93437),new $Xb.kq(93,149.93857),new $Xb.kq(94,150.94156),new $Xb.kq(95,151.94611),new $Xb.kq(96,152.94945),new $Xb.kq(97,153.9544),new $Xb.kq(98,154.95813)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(61,118.95276),new $Xb.kq(62,119.94664),new $Xb.kq(63,120.94367),new $Xb.kq(64,121.93801),new $Xb.kq(65,122.93551),new $Xb.kq(66,123.93052),new $Xb.kq(67,124.92854),new $Xb.kq(68,125.9241),new $Xb.kq(69,126.92275),new $Xb.kq(70,127.91887),new $Xb.kq(71,128.918679183),new $Xb.kq(72,129.914339361),new $Xb.kq(73,130.914424137),new $Xb.kq(74,131.91149),new $Xb.kq(75,132.91155),new $Xb.kq(76,133.909026379),new $Xb.kq(77,134.909145555),new $Xb.kq(78,135.907143574),new $Xb.kq(79,136.907777634),new $Xb.kq(80,137.905985574),new $Xb.kq(81,138.906646605),new $Xb.kq(82,139.905434035),new $Xb.kq(83,140.908271103),new $Xb.kq(84,141.909239733),new $Xb.kq(85,142.912381158),new $Xb.kq(86,143.913642686),new $Xb.kq(87,144.917227871),new $Xb.kq(88,145.918689722),new $Xb.kq(89,146.922510962),new $Xb.kq(90,147.924394738),new $Xb.kq(91,148.928289207),new $Xb.kq(92,149.930226399),new $Xb.kq(93,150.93404),new $Xb.kq(94,151.93638),new $Xb.kq(95,152.94058),new $Xb.kq(96,153.94332),new $Xb.kq(97,154.94804),new $Xb.kq(98,155.95126),new $Xb.kq(99,156.95634)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(62,120.955364),new $Xb.kq(63,121.95165),new $Xb.kq(64,122.94596),new $Xb.kq(65,123.94296),new $Xb.kq(66,124.93783),new $Xb.kq(67,125.93531),new $Xb.kq(68,126.93083),new $Xb.kq(69,127.9288),new $Xb.kq(70,128.92486),new $Xb.kq(71,129.92338),new $Xb.kq(72,130.920060245),new $Xb.kq(73,131.91912),new $Xb.kq(74,132.9162),new $Xb.kq(75,133.915672),new $Xb.kq(76,134.91313914),new $Xb.kq(77,135.912646935),new $Xb.kq(78,136.910678351),new $Xb.kq(79,137.910748891),new $Xb.kq(80,138.908932181),new $Xb.kq(81,139.909071204),new $Xb.kq(82,140.907647726),new $Xb.kq(83,141.910039865),new $Xb.kq(84,142.910812233),new $Xb.kq(85,143.913300595),new $Xb.kq(86,144.914506897),new $Xb.kq(87,145.917588016),new $Xb.kq(88,146.918979001),new $Xb.kq(89,147.922183237),new $Xb.kq(90,148.923791056),new $Xb.kq(91,149.926995031),new $Xb.kq(92,150.928227869),new $Xb.kq(93,151.9316),new $Xb.kq(94,152.93365),new $Xb.kq(95,153.93739),new $Xb.kq(96,154.93999),new $Xb.kq(97,155.94412),new $Xb.kq(98,156.94717),new $Xb.kq(99,157.95178),new $Xb.kq(100,158.95523)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(66,125.94307),new $Xb.kq(67,126.9405),new $Xb.kq(68,127.93539),new $Xb.kq(69,128.932385),new $Xb.kq(70,129.92878),new $Xb.kq(71,130.927102697),new $Xb.kq(72,131.92312),new $Xb.kq(73,132.92221),new $Xb.kq(74,133.918645),new $Xb.kq(75,134.91824),new $Xb.kq(76,135.915020542),new $Xb.kq(77,136.91463973),new $Xb.kq(78,137.91291745),new $Xb.kq(79,138.91192415),new $Xb.kq(80,139.909309824),new $Xb.kq(81,140.9096048),new $Xb.kq(82,141.907718643),new $Xb.kq(83,142.909809626),new $Xb.kq(84,143.910082629),new $Xb.kq(85,144.912568847),new $Xb.kq(86,145.913112139),new $Xb.kq(87,146.916095794),new $Xb.kq(88,147.916888516),new $Xb.kq(89,148.92014419),new $Xb.kq(90,149.920886563),new $Xb.kq(91,150.923824739),new $Xb.kq(92,151.924682428),new $Xb.kq(93,152.927694534),new $Xb.kq(94,153.929483295),new $Xb.kq(95,154.932629551),new $Xb.kq(96,155.9352),new $Xb.kq(97,156.93927),new $Xb.kq(98,157.94187),new $Xb.kq(99,158.94639),new $Xb.kq(100,159.94939),new $Xb.kq(101,160.95433)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(67,127.94826),new $Xb.kq(68,128.94316),new $Xb.kq(69,129.94045),new $Xb.kq(70,130.9358),new $Xb.kq(71,131.93375),new $Xb.kq(72,132.92972),new $Xb.kq(73,133.92849),new $Xb.kq(74,134.924617),new $Xb.kq(75,135.923447865),new $Xb.kq(76,136.920713),new $Xb.kq(77,137.920432261),new $Xb.kq(78,138.916759814),new $Xb.kq(79,139.915801649),new $Xb.kq(80,140.913606636),new $Xb.kq(81,141.912950738),new $Xb.kq(82,142.910927571),new $Xb.kq(83,143.912585768),new $Xb.kq(84,144.912743879),new $Xb.kq(85,145.914692165),new $Xb.kq(86,146.915133898),new $Xb.kq(87,147.917467786),new $Xb.kq(88,148.918329195),new $Xb.kq(89,149.920979477),new $Xb.kq(90,150.921202693),new $Xb.kq(91,151.923490557),new $Xb.kq(92,152.924113189),new $Xb.kq(93,153.926547019),new $Xb.kq(94,154.928097047),new $Xb.kq(95,155.931060357),new $Xb.kq(96,156.9332),new $Xb.kq(97,157.93669),new $Xb.kq(98,158.93913),new $Xb.kq(99,159.94299),new $Xb.kq(100,160.94586),new $Xb.kq(101,161.95029),new $Xb.kq(102,162.95352)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(68,129.94863),new $Xb.kq(69,130.94589),new $Xb.kq(70,131.94082),new $Xb.kq(71,132.93873),new $Xb.kq(72,133.93402),new $Xb.kq(73,134.93235),new $Xb.kq(74,135.9283),new $Xb.kq(75,136.927046709),new $Xb.kq(76,137.92354),new $Xb.kq(77,138.922302),new $Xb.kq(78,139.918991),new $Xb.kq(79,140.918468512),new $Xb.kq(80,141.915193274),new $Xb.kq(81,142.914623555),new $Xb.kq(82,143.91199473),new $Xb.kq(83,144.913405611),new $Xb.kq(84,145.91303676),new $Xb.kq(85,146.914893275),new $Xb.kq(86,147.914817914),new $Xb.kq(87,148.917179521),new $Xb.kq(88,149.917271454),new $Xb.kq(89,150.919928351),new $Xb.kq(90,151.919728244),new $Xb.kq(91,152.922093907),new $Xb.kq(92,153.922205303),new $Xb.kq(93,154.92463594),new $Xb.kq(94,155.925526236),new $Xb.kq(95,156.928354506),new $Xb.kq(96,157.929987938),new $Xb.kq(97,158.9332),new $Xb.kq(98,159.93514),new $Xb.kq(99,160.93883),new $Xb.kq(100,161.94122),new $Xb.kq(101,162.94536),new $Xb.kq(102,163.94828),new $Xb.kq(103,164.95298)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(69,131.95416),new $Xb.kq(70,132.9489),new $Xb.kq(71,133.94632),new $Xb.kq(72,134.94172),new $Xb.kq(73,135.9395),new $Xb.kq(74,136.93521),new $Xb.kq(75,137.93345),new $Xb.kq(76,138.92882915),new $Xb.kq(77,139.928083921),new $Xb.kq(78,140.924885867),new $Xb.kq(79,141.923400033),new $Xb.kq(80,142.920286634),new $Xb.kq(81,143.918774116),new $Xb.kq(82,144.916261285),new $Xb.kq(83,145.917199714),new $Xb.kq(84,146.916741206),new $Xb.kq(85,147.918153775),new $Xb.kq(86,148.917925922),new $Xb.kq(87,149.919698294),new $Xb.kq(88,150.919846022),new $Xb.kq(89,151.921740399),new $Xb.kq(90,152.921226219),new $Xb.kq(91,153.922975386),new $Xb.kq(92,154.922889429),new $Xb.kq(93,155.924750855),new $Xb.kq(94,156.925419435),new $Xb.kq(95,157.927841923),new $Xb.kq(96,158.9290845),new $Xb.kq(97,159.931460406),new $Xb.kq(98,160.93368),new $Xb.kq(99,161.93704),new $Xb.kq(100,162.93921),new $Xb.kq(101,163.94299),new $Xb.kq(102,164.94572),new $Xb.kq(103,165.94997),new $Xb.kq(104,166.95305)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(72,135.94707),new $Xb.kq(73,136.94465),new $Xb.kq(74,137.93997),new $Xb.kq(75,138.93808),new $Xb.kq(76,139.933236934),new $Xb.kq(77,140.93221),new $Xb.kq(78,141.927908919),new $Xb.kq(79,142.926738636),new $Xb.kq(80,143.923390357),new $Xb.kq(81,144.921687498),new $Xb.kq(82,145.918305344),new $Xb.kq(83,146.919089446),new $Xb.kq(84,147.918109771),new $Xb.kq(85,148.919336427),new $Xb.kq(86,149.918655455),new $Xb.kq(87,150.920344273),new $Xb.kq(88,151.919787882),new $Xb.kq(89,152.921746283),new $Xb.kq(90,153.920862271),new $Xb.kq(91,154.922618801),new $Xb.kq(92,155.922119552),new $Xb.kq(93,156.923956686),new $Xb.kq(94,157.924100533),new $Xb.kq(95,158.926385075),new $Xb.kq(96,159.927050616),new $Xb.kq(97,160.929665688),new $Xb.kq(98,161.930981211),new $Xb.kq(99,162.93399),new $Xb.kq(100,163.93586),new $Xb.kq(101,164.93938),new $Xb.kq(102,165.9416),new $Xb.kq(103,166.94557),new $Xb.kq(104,167.94836),new $Xb.kq(105,168.95287)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(73,137.95287),new $Xb.kq(74,138.94803),new $Xb.kq(75,139.945367985),new $Xb.kq(76,140.94116),new $Xb.kq(77,141.939073781),new $Xb.kq(78,142.93475),new $Xb.kq(79,143.93253),new $Xb.kq(80,144.92888),new $Xb.kq(81,145.927180629),new $Xb.kq(82,146.924037176),new $Xb.kq(83,147.924298636),new $Xb.kq(84,148.92324163),new $Xb.kq(85,149.923654158),new $Xb.kq(86,150.923098169),new $Xb.kq(87,151.924071324),new $Xb.kq(88,152.923430858),new $Xb.kq(89,153.924686236),new $Xb.kq(90,154.923500411),new $Xb.kq(91,155.924743749),new $Xb.kq(92,156.924021155),new $Xb.kq(93,157.92541026),new $Xb.kq(94,158.925343135),new $Xb.kq(95,159.927164021),new $Xb.kq(96,160.927566289),new $Xb.kq(97,161.929484803),new $Xb.kq(98,162.930643942),new $Xb.kq(99,163.933347253),new $Xb.kq(100,164.93488),new $Xb.kq(101,165.93805),new $Xb.kq(102,166.94005),new $Xb.kq(103,167.94364),new $Xb.kq(104,168.94622),new $Xb.kq(105,169.95025),new $Xb.kq(106,170.9533)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(74,139.95379),new $Xb.kq(75,140.95119),new $Xb.kq(76,141.946695946),new $Xb.kq(77,142.94383),new $Xb.kq(78,143.93907),new $Xb.kq(79,144.936717),new $Xb.kq(80,145.932720118),new $Xb.kq(81,146.930878496),new $Xb.kq(82,147.927177882),new $Xb.kq(83,148.927333981),new $Xb.kq(84,149.925579728),new $Xb.kq(85,150.92617963),new $Xb.kq(86,151.924713874),new $Xb.kq(87,152.925760865),new $Xb.kq(88,153.924422046),new $Xb.kq(89,154.92574895),new $Xb.kq(90,155.924278273),new $Xb.kq(91,156.925461256),new $Xb.kq(92,157.924404637),new $Xb.kq(93,158.92573566),new $Xb.kq(94,159.925193718),new $Xb.kq(95,160.926929595),new $Xb.kq(96,161.926794731),new $Xb.kq(97,162.928727532),new $Xb.kq(98,163.929171165),new $Xb.kq(99,164.931699828),new $Xb.kq(100,165.932803241),new $Xb.kq(101,166.935649025),new $Xb.kq(102,167.93723),new $Xb.kq(103,168.940303648),new $Xb.kq(104,169.94267),new $Xb.kq(105,170.94648),new $Xb.kq(106,171.94911),new $Xb.kq(107,172.95344)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(75,141.95986),new $Xb.kq(76,142.95469),new $Xb.kq(77,143.95164),new $Xb.kq(78,144.94688),new $Xb.kq(79,145.9441),new $Xb.kq(80,146.93984),new $Xb.kq(81,147.937269),new $Xb.kq(82,148.933789944),new $Xb.kq(83,149.932760914),new $Xb.kq(84,150.931680791),new $Xb.kq(85,151.931740598),new $Xb.kq(86,152.930194506),new $Xb.kq(87,153.930596268),new $Xb.kq(88,154.929079084),new $Xb.kq(89,155.929001869),new $Xb.kq(90,156.928188059),new $Xb.kq(91,157.92894573),new $Xb.kq(92,158.927708537),new $Xb.kq(93,159.928725679),new $Xb.kq(94,160.927851662),new $Xb.kq(95,161.92909242),new $Xb.kq(96,162.928730286),new $Xb.kq(97,163.930230577),new $Xb.kq(98,164.930319169),new $Xb.kq(99,165.932281267),new $Xb.kq(100,166.933126195),new $Xb.kq(101,167.935496424),new $Xb.kq(102,168.936868306),new $Xb.kq(103,169.939614951),new $Xb.kq(104,170.941461227),new $Xb.kq(105,171.94482),new $Xb.kq(106,172.94729),new $Xb.kq(107,173.95115),new $Xb.kq(108,174.95405)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(76,143.96059),new $Xb.kq(77,144.95746),new $Xb.kq(78,145.95212),new $Xb.kq(79,146.94931),new $Xb.kq(80,147.94444),new $Xb.kq(81,148.942780527),new $Xb.kq(82,149.937171034),new $Xb.kq(83,150.93746),new $Xb.kq(84,151.935078452),new $Xb.kq(85,152.935093125),new $Xb.kq(86,153.932777294),new $Xb.kq(87,154.933204273),new $Xb.kq(88,155.931015001),new $Xb.kq(89,156.931945517),new $Xb.kq(90,157.929912),new $Xb.kq(91,158.930680718),new $Xb.kq(92,159.929078924),new $Xb.kq(93,160.930001348),new $Xb.kq(94,161.928774923),new $Xb.kq(95,162.930029273),new $Xb.kq(96,163.929196996),new $Xb.kq(97,164.9307228),new $Xb.kq(98,165.93028997),new $Xb.kq(99,166.932045448),new $Xb.kq(100,167.932367781),new $Xb.kq(101,168.934588082),new $Xb.kq(102,169.935460334),new $Xb.kq(103,170.938025885),new $Xb.kq(104,171.939352149),new $Xb.kq(105,172.9424),new $Xb.kq(106,173.94434),new $Xb.kq(107,174.94793),new $Xb.kq(108,175.95029),new $Xb.kq(109,176.95437)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(77,145.966495),new $Xb.kq(78,146.961081),new $Xb.kq(79,147.95755),new $Xb.kq(80,148.95265),new $Xb.kq(81,149.94967),new $Xb.kq(82,150.944842),new $Xb.kq(83,151.9443),new $Xb.kq(84,152.942027631),new $Xb.kq(85,153.940832325),new $Xb.kq(86,154.939191562),new $Xb.kq(87,155.939006895),new $Xb.kq(88,156.936756069),new $Xb.kq(89,157.936996),new $Xb.kq(90,158.934808966),new $Xb.kq(91,159.935090772),new $Xb.kq(92,160.933398042),new $Xb.kq(93,161.933970147),new $Xb.kq(94,162.932647648),new $Xb.kq(95,163.933450972),new $Xb.kq(96,164.932432463),new $Xb.kq(97,165.933553133),new $Xb.kq(98,166.932848844),new $Xb.kq(99,167.934170375),new $Xb.kq(100,168.934211117),new $Xb.kq(101,169.935797877),new $Xb.kq(102,170.936425817),new $Xb.kq(103,171.938396118),new $Xb.kq(104,172.939600336),new $Xb.kq(105,173.942164618),new $Xb.kq(106,174.943832897),new $Xb.kq(107,175.946991412),new $Xb.kq(108,176.94904),new $Xb.kq(109,177.95264),new $Xb.kq(110,178.95534)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(78,147.96676),new $Xb.kq(79,148.96348),new $Xb.kq(80,149.95799),new $Xb.kq(81,150.954657965),new $Xb.kq(82,151.950167),new $Xb.kq(83,152.94921),new $Xb.kq(84,153.945651145),new $Xb.kq(85,154.945792),new $Xb.kq(86,155.942847109),new $Xb.kq(87,156.94265865),new $Xb.kq(88,157.939857897),new $Xb.kq(89,158.940153735),new $Xb.kq(90,159.93756),new $Xb.kq(91,160.937357719),new $Xb.kq(92,161.93575),new $Xb.kq(93,162.936265492),new $Xb.kq(94,163.93452),new $Xb.kq(95,164.935397592),new $Xb.kq(96,165.933879623),new $Xb.kq(97,166.934946862),new $Xb.kq(98,167.933894465),new $Xb.kq(99,168.93518712),new $Xb.kq(100,169.934758652),new $Xb.kq(101,170.936322297),new $Xb.kq(102,171.936377696),new $Xb.kq(103,172.938206756),new $Xb.kq(104,173.938858101),new $Xb.kq(105,174.941272494),new $Xb.kq(106,175.942568409),new $Xb.kq(107,176.945257126),new $Xb.kq(108,177.946643396),new $Xb.kq(109,178.95017),new $Xb.kq(110,179.95233),new $Xb.kq(111,180.95615)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(79,149.972668),new $Xb.kq(80,150.967147),new $Xb.kq(81,151.96361),new $Xb.kq(82,152.95869),new $Xb.kq(83,153.9571),new $Xb.kq(84,154.953641324),new $Xb.kq(85,155.952907),new $Xb.kq(86,156.950101536),new $Xb.kq(87,157.948577981),new $Xb.kq(88,158.946615113),new $Xb.kq(89,159.945383),new $Xb.kq(90,160.943047504),new $Xb.kq(91,161.943222),new $Xb.kq(92,162.941203796),new $Xb.kq(93,163.941215),new $Xb.kq(94,164.939605886),new $Xb.kq(95,165.939762646),new $Xb.kq(96,166.938307056),new $Xb.kq(97,167.938698576),new $Xb.kq(98,168.937648757),new $Xb.kq(99,169.93847219),new $Xb.kq(100,170.937909903),new $Xb.kq(101,171.939082239),new $Xb.kq(102,172.938926901),new $Xb.kq(103,173.940333522),new $Xb.kq(104,174.940767904),new $Xb.kq(105,175.942682399),new $Xb.kq(106,176.943754987),new $Xb.kq(107,177.945951366),new $Xb.kq(108,178.947324216),new $Xb.kq(109,179.949879968),new $Xb.kq(110,180.95197),new $Xb.kq(111,181.95521),new $Xb.kq(112,182.95757),new $Xb.kq(113,183.96117)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(82,153.96425),new $Xb.kq(83,154.96276),new $Xb.kq(84,155.959247),new $Xb.kq(85,156.958127),new $Xb.kq(86,157.95405528),new $Xb.kq(87,158.954003),new $Xb.kq(88,159.950713588),new $Xb.kq(89,160.950330852),new $Xb.kq(90,161.947202977),new $Xb.kq(91,162.947057),new $Xb.kq(92,163.944422),new $Xb.kq(93,164.94454),new $Xb.kq(94,165.94225),new $Xb.kq(95,166.9426),new $Xb.kq(96,167.94063),new $Xb.kq(97,168.941158567),new $Xb.kq(98,169.93965),new $Xb.kq(99,170.94049),new $Xb.kq(100,171.93945798),new $Xb.kq(101,172.94065),new $Xb.kq(102,173.940040159),new $Xb.kq(103,174.941502991),new $Xb.kq(104,175.941401828),new $Xb.kq(105,176.943220013),new $Xb.kq(106,177.943697732),new $Xb.kq(107,178.945815073),new $Xb.kq(108,179.94654876),new $Xb.kq(109,180.949099124),new $Xb.kq(110,181.950552893),new $Xb.kq(111,182.953531012),new $Xb.kq(112,183.95544788),new $Xb.kq(113,184.95878),new $Xb.kq(114,185.96092)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(83,155.971689),new $Xb.kq(84,156.968145),new $Xb.kq(85,157.966368),new $Xb.kq(86,158.96232309),new $Xb.kq(87,159.961358),new $Xb.kq(88,160.958372992),new $Xb.kq(89,161.956556553),new $Xb.kq(90,162.95431665),new $Xb.kq(91,163.95357),new $Xb.kq(92,164.950817),new $Xb.kq(93,165.95047),new $Xb.kq(94,166.948639),new $Xb.kq(95,167.947787),new $Xb.kq(96,168.94592),new $Xb.kq(97,169.94609),new $Xb.kq(98,170.94446),new $Xb.kq(99,171.944739818),new $Xb.kq(100,172.94459),new $Xb.kq(101,173.944167937),new $Xb.kq(102,174.94365),new $Xb.kq(103,175.944740551),new $Xb.kq(104,176.944471766),new $Xb.kq(105,177.945750349),new $Xb.kq(106,178.945934113),new $Xb.kq(107,179.947465655),new $Xb.kq(108,180.947996346),new $Xb.kq(109,181.950152414),new $Xb.kq(110,182.951373188),new $Xb.kq(111,183.954009331),new $Xb.kq(112,184.955559086),new $Xb.kq(113,185.9585501),new $Xb.kq(114,186.96041),new $Xb.kq(115,187.96371)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(84,157.973939),new $Xb.kq(85,158.97228),new $Xb.kq(86,159.968369),new $Xb.kq(87,160.967089),new $Xb.kq(88,161.962750303),new $Xb.kq(89,162.962532),new $Xb.kq(90,163.95898381),new $Xb.kq(91,164.958335962),new $Xb.kq(92,165.955019896),new $Xb.kq(93,166.954672),new $Xb.kq(94,167.951863),new $Xb.kq(95,168.951759),new $Xb.kq(96,169.948473988),new $Xb.kq(97,170.94946),new $Xb.kq(98,171.948228837),new $Xb.kq(99,172.948884),new $Xb.kq(100,173.94616),new $Xb.kq(101,174.94677),new $Xb.kq(102,175.94559),new $Xb.kq(103,176.94662),new $Xb.kq(104,177.945848364),new $Xb.kq(105,178.947071733),new $Xb.kq(106,179.946705734),new $Xb.kq(107,180.948198054),new $Xb.kq(108,181.948205519),new $Xb.kq(109,182.950224458),new $Xb.kq(110,183.950932553),new $Xb.kq(111,184.953420586),new $Xb.kq(112,185.954362204),new $Xb.kq(113,186.957158365),new $Xb.kq(114,187.958486954),new $Xb.kq(115,188.96191222),new $Xb.kq(116,189.963179541)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(85,159.981485),new $Xb.kq(86,160.977661),new $Xb.kq(87,161.975707),new $Xb.kq(88,162.971375872),new $Xb.kq(89,163.970319),new $Xb.kq(90,164.967050268),new $Xb.kq(91,165.965211372),new $Xb.kq(92,166.962564),new $Xb.kq(93,167.961609),new $Xb.kq(94,168.95883),new $Xb.kq(95,169.958163),new $Xb.kq(96,170.955547),new $Xb.kq(97,171.955285),new $Xb.kq(98,172.953062),new $Xb.kq(99,173.952114),new $Xb.kq(100,174.951393),new $Xb.kq(101,175.95157),new $Xb.kq(102,176.95027),new $Xb.kq(103,177.950851081),new $Xb.kq(104,178.949981038),new $Xb.kq(105,179.95078768),new $Xb.kq(106,180.950064596),new $Xb.kq(107,181.951211444),new $Xb.kq(108,182.950821349),new $Xb.kq(109,183.952524289),new $Xb.kq(110,184.952955747),new $Xb.kq(111,185.954986529),new $Xb.kq(112,186.955750787),new $Xb.kq(113,187.958112287),new $Xb.kq(114,188.959228359),new $Xb.kq(115,189.961816139),new $Xb.kq(116,190.963123592),new $Xb.kq(117,191.96596)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(86,161.983819),new $Xb.kq(87,162.982048),new $Xb.kq(88,163.977927),new $Xb.kq(89,164.976475),new $Xb.kq(90,165.971934911),new $Xb.kq(91,166.971554),new $Xb.kq(92,167.967832911),new $Xb.kq(93,168.967076205),new $Xb.kq(94,169.963569716),new $Xb.kq(95,170.96304),new $Xb.kq(96,171.960078),new $Xb.kq(97,172.959791),new $Xb.kq(98,173.956307704),new $Xb.kq(99,174.95708),new $Xb.kq(100,175.953757941),new $Xb.kq(101,176.955045),new $Xb.kq(102,177.953348225),new $Xb.kq(103,178.953951),new $Xb.kq(104,179.952308241),new $Xb.kq(105,180.953274494),new $Xb.kq(106,181.952186222),new $Xb.kq(107,182.95311),new $Xb.kq(108,183.952490808),new $Xb.kq(109,184.954043023),new $Xb.kq(110,185.953838355),new $Xb.kq(111,186.955747928),new $Xb.kq(112,187.955835993),new $Xb.kq(113,188.958144866),new $Xb.kq(114,189.95844521),new $Xb.kq(115,190.960927951),new $Xb.kq(116,191.961479047),new $Xb.kq(117,192.964148083),new $Xb.kq(118,193.965179314),new $Xb.kq(119,194.968123889),new $Xb.kq(120,195.96962255)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(88,164.98758),new $Xb.kq(89,165.985506),new $Xb.kq(90,166.980951577),new $Xb.kq(91,167.979966),new $Xb.kq(92,168.976390868),new $Xb.kq(93,169.974441697),new $Xb.kq(94,170.971779),new $Xb.kq(95,171.970643),new $Xb.kq(96,172.967707),new $Xb.kq(97,173.966804),new $Xb.kq(98,174.964279),new $Xb.kq(99,175.963511),new $Xb.kq(100,176.96117),new $Xb.kq(101,177.960084944),new $Xb.kq(102,178.95915),new $Xb.kq(103,179.958555615),new $Xb.kq(104,180.957642156),new $Xb.kq(105,181.958127689),new $Xb.kq(106,182.956814),new $Xb.kq(107,183.957388318),new $Xb.kq(108,184.95659),new $Xb.kq(109,185.957951104),new $Xb.kq(110,186.95736083),new $Xb.kq(111,187.958851962),new $Xb.kq(112,188.958716473),new $Xb.kq(113,189.960592299),new $Xb.kq(114,190.960591191),new $Xb.kq(115,191.962602198),new $Xb.kq(116,192.9629237),new $Xb.kq(117,193.96507561),new $Xb.kq(118,194.9659768),new $Xb.kq(119,195.968379906),new $Xb.kq(120,196.969636496),new $Xb.kq(121,197.97228),new $Xb.kq(122,198.973787159)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(90,167.988035),new $Xb.kq(91,168.986421),new $Xb.kq(92,169.981734918),new $Xb.kq(93,170.981251),new $Xb.kq(94,171.977376138),new $Xb.kq(95,172.976499642),new $Xb.kq(96,173.972811276),new $Xb.kq(97,174.972276),new $Xb.kq(98,175.969),new $Xb.kq(99,176.968453),new $Xb.kq(100,177.964894223),new $Xb.kq(101,178.965475),new $Xb.kq(102,179.962023729),new $Xb.kq(103,180.963177),new $Xb.kq(104,181.961267637),new $Xb.kq(105,182.961729),new $Xb.kq(106,183.959851685),new $Xb.kq(107,184.960753782),new $Xb.kq(108,185.959432346),new $Xb.kq(109,186.960697),new $Xb.kq(110,187.959395697),new $Xb.kq(111,188.9608319),new $Xb.kq(112,189.959930073),new $Xb.kq(113,190.961684653),new $Xb.kq(114,191.961035158),new $Xb.kq(115,192.962984504),new $Xb.kq(116,193.962663581),new $Xb.kq(117,194.964774449),new $Xb.kq(118,195.964934884),new $Xb.kq(119,196.967323401),new $Xb.kq(120,197.967876009),new $Xb.kq(121,198.970576213),new $Xb.kq(122,199.971423885),new $Xb.kq(123,200.974496467),new $Xb.kq(124,201.97574)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(92,170.991183),new $Xb.kq(93,171.990109),new $Xb.kq(94,172.986398138),new $Xb.kq(95,173.984325861),new $Xb.kq(96,174.981552),new $Xb.kq(97,175.980269),new $Xb.kq(98,176.977215),new $Xb.kq(99,177.975975),new $Xb.kq(100,178.973412),new $Xb.kq(101,179.972396),new $Xb.kq(102,180.969948),new $Xb.kq(103,181.968621416),new $Xb.kq(104,182.96762),new $Xb.kq(105,183.966776046),new $Xb.kq(106,184.965806956),new $Xb.kq(107,185.965997671),new $Xb.kq(108,186.964562),new $Xb.kq(109,187.965321662),new $Xb.kq(110,188.9642243),new $Xb.kq(111,189.964698757),new $Xb.kq(112,190.963649239),new $Xb.kq(113,191.964810107),new $Xb.kq(114,192.964131745),new $Xb.kq(115,193.96533889),new $Xb.kq(116,194.965017928),new $Xb.kq(117,195.966551315),new $Xb.kq(118,196.966551609),new $Xb.kq(119,197.968225244),new $Xb.kq(120,198.968748016),new $Xb.kq(121,199.970717886),new $Xb.kq(122,200.971640839),new $Xb.kq(123,201.973788431),new $Xb.kq(124,202.975137256),new $Xb.kq(125,203.977705),new $Xb.kq(126,204.97961)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(95,174.991411),new $Xb.kq(96,175.987413248),new $Xb.kq(97,176.986336874),new $Xb.kq(98,177.982476325),new $Xb.kq(99,178.981783),new $Xb.kq(100,179.978322),new $Xb.kq(101,180.977806),new $Xb.kq(102,181.97393546),new $Xb.kq(103,182.974561),new $Xb.kq(104,183.970705219),new $Xb.kq(105,184.971983),new $Xb.kq(106,185.969460021),new $Xb.kq(107,186.969785),new $Xb.kq(108,187.967511693),new $Xb.kq(109,188.968733187),new $Xb.kq(110,189.966958568),new $Xb.kq(111,190.96706311),new $Xb.kq(112,191.965921572),new $Xb.kq(113,192.966644169),new $Xb.kq(114,193.965381832),new $Xb.kq(115,194.966638981),new $Xb.kq(116,195.965814846),new $Xb.kq(117,196.967195333),new $Xb.kq(118,197.96675183),new $Xb.kq(119,198.968262489),new $Xb.kq(120,199.968308726),new $Xb.kq(121,200.970285275),new $Xb.kq(122,201.970625604),new $Xb.kq(123,202.972857096),new $Xb.kq(124,203.97347564),new $Xb.kq(125,204.976056104),new $Xb.kq(126,205.977498672),new $Xb.kq(127,206.982577025),new $Xb.kq(128,207.98594)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(96,176.996881),new $Xb.kq(97,177.994637),new $Xb.kq(98,178.991466),new $Xb.kq(99,179.990194),new $Xb.kq(100,180.986904),new $Xb.kq(101,181.98561),new $Xb.kq(102,182.982697),new $Xb.kq(103,183.98176),new $Xb.kq(104,184.9791),new $Xb.kq(105,185.977549881),new $Xb.kq(106,186.97617),new $Xb.kq(107,187.97592),new $Xb.kq(108,188.974290451),new $Xb.kq(109,189.974473379),new $Xb.kq(110,190.972261952),new $Xb.kq(111,191.972770785),new $Xb.kq(112,192.970548),new $Xb.kq(113,193.971053),new $Xb.kq(114,194.96965),new $Xb.kq(115,195.970515),new $Xb.kq(116,196.9695362),new $Xb.kq(117,197.970466294),new $Xb.kq(118,198.969813837),new $Xb.kq(119,199.970945394),new $Xb.kq(120,200.97080377),new $Xb.kq(121,201.972090569),new $Xb.kq(122,202.972329088),new $Xb.kq(123,203.973848646),new $Xb.kq(124,204.97441227),new $Xb.kq(125,205.976095321),new $Xb.kq(126,206.977407908),new $Xb.kq(127,207.982004653),new $Xb.kq(128,208.985349125),new $Xb.kq(129,209.990065574)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(99,180.996714),new $Xb.kq(100,181.992676101),new $Xb.kq(101,182.99193),new $Xb.kq(102,183.988198),new $Xb.kq(103,184.98758),new $Xb.kq(104,185.983485388),new $Xb.kq(105,186.98403),new $Xb.kq(106,187.979869108),new $Xb.kq(107,188.98088),new $Xb.kq(108,189.978180008),new $Xb.kq(109,190.9782),new $Xb.kq(110,191.975719811),new $Xb.kq(111,192.97608),new $Xb.kq(112,193.974648056),new $Xb.kq(113,194.975920279),new $Xb.kq(114,195.97271),new $Xb.kq(115,196.97338),new $Xb.kq(116,197.97198),new $Xb.kq(117,198.972909384),new $Xb.kq(118,199.97181556),new $Xb.kq(119,200.972846589),new $Xb.kq(120,201.972143786),new $Xb.kq(121,202.973375491),new $Xb.kq(122,203.973028761),new $Xb.kq(123,204.974467112),new $Xb.kq(124,205.974449002),new $Xb.kq(125,206.975880605),new $Xb.kq(126,207.97663585),new $Xb.kq(127,208.981074801),new $Xb.kq(128,209.984173129),new $Xb.kq(129,210.988731474),new $Xb.kq(130,211.991887495),new $Xb.kq(131,212.9965),new $Xb.kq(132,213.999798147)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(102,184.997708),new $Xb.kq(103,185.99648),new $Xb.kq(104,186.993458),new $Xb.kq(105,187.992173),new $Xb.kq(106,188.989505),new $Xb.kq(107,189.987520007),new $Xb.kq(108,190.986053),new $Xb.kq(109,191.985368),new $Xb.kq(110,192.983662229),new $Xb.kq(111,193.983430186),new $Xb.kq(112,194.98112697),new $Xb.kq(113,195.981236107),new $Xb.kq(114,196.978934287),new $Xb.kq(115,197.979024396),new $Xb.kq(116,198.977576953),new $Xb.kq(117,199.978141983),new $Xb.kq(118,200.976970721),new $Xb.kq(119,201.977674504),new $Xb.kq(120,202.976868118),new $Xb.kq(121,203.977805161),new $Xb.kq(122,204.977374688),new $Xb.kq(123,205.978482854),new $Xb.kq(124,206.978455217),new $Xb.kq(125,207.979726699),new $Xb.kq(126,208.980383241),new $Xb.kq(127,209.984104944),new $Xb.kq(128,210.987258139),new $Xb.kq(129,211.991271542),new $Xb.kq(130,212.994374836),new $Xb.kq(131,213.998698664),new $Xb.kq(132,215.001832349),new $Xb.kq(133,216.006199)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(106,189.994293888),new $Xb.kq(107,190.994653),new $Xb.kq(108,191.99033039),new $Xb.kq(109,192.991102),new $Xb.kq(110,193.988284107),new $Xb.kq(111,194.988045),new $Xb.kq(112,195.985469432),new $Xb.kq(113,196.985567),new $Xb.kq(114,197.984024384),new $Xb.kq(115,198.985044507),new $Xb.kq(116,199.981735),new $Xb.kq(117,200.982209),new $Xb.kq(118,201.980704),new $Xb.kq(119,202.981412863),new $Xb.kq(120,203.980307113),new $Xb.kq(121,204.981165396),new $Xb.kq(122,205.980465241),new $Xb.kq(123,206.981578228),new $Xb.kq(124,207.981231059),new $Xb.kq(125,208.982415788),new $Xb.kq(126,209.982857396),new $Xb.kq(127,210.986636869),new $Xb.kq(128,211.988851755),new $Xb.kq(129,212.992842522),new $Xb.kq(130,213.995185949),new $Xb.kq(131,214.999414609),new $Xb.kq(132,216.001905198),new $Xb.kq(133,217.006253),new $Xb.kq(134,218.008965773)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(108,193.000188),new $Xb.kq(109,193.997973),new $Xb.kq(110,194.996554),new $Xb.kq(111,195.995702),new $Xb.kq(112,196.993891293),new $Xb.kq(113,197.99343368),new $Xb.kq(114,198.991008569),new $Xb.kq(115,199.990920883),new $Xb.kq(116,200.988486908),new $Xb.kq(117,201.988448629),new $Xb.kq(118,202.986847216),new $Xb.kq(119,203.987261559),new $Xb.kq(120,204.986036352),new $Xb.kq(121,205.986599242),new $Xb.kq(122,206.985775861),new $Xb.kq(123,207.986582508),new $Xb.kq(124,208.986158678),new $Xb.kq(125,209.987131308),new $Xb.kq(126,210.987480806),new $Xb.kq(127,211.990734657),new $Xb.kq(128,212.99292115),new $Xb.kq(129,213.996356412),new $Xb.kq(130,214.998641245),new $Xb.kq(131,216.002408839),new $Xb.kq(132,217.004709619),new $Xb.kq(133,218.008681458),new $Xb.kq(134,219.011296478),new $Xb.kq(135,220.015301),new $Xb.kq(136,221.01814),new $Xb.kq(137,222.02233),new $Xb.kq(138,223.02534)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(110,196.001117268),new $Xb.kq(111,197.001661),new $Xb.kq(112,197.998779978),new $Xb.kq(113,198.998309),new $Xb.kq(114,199.995634148),new $Xb.kq(115,200.995535),new $Xb.kq(116,201.993899382),new $Xb.kq(117,202.994765192),new $Xb.kq(118,203.991365),new $Xb.kq(119,204.991668),new $Xb.kq(120,205.99016),new $Xb.kq(121,206.990726826),new $Xb.kq(122,207.989631237),new $Xb.kq(123,208.990376634),new $Xb.kq(124,209.989679862),new $Xb.kq(125,210.99058541),new $Xb.kq(126,211.990688899),new $Xb.kq(127,212.993868354),new $Xb.kq(128,213.995346275),new $Xb.kq(129,214.998729195),new $Xb.kq(130,216.000258153),new $Xb.kq(131,217.003914555),new $Xb.kq(132,218.005586315),new $Xb.kq(133,219.009474831),new $Xb.kq(134,220.011384149),new $Xb.kq(135,221.015455),new $Xb.kq(136,222.017570472),new $Xb.kq(137,223.02179),new $Xb.kq(138,224.02409),new $Xb.kq(139,225.02844),new $Xb.kq(140,226.03089),new $Xb.kq(141,227.035407),new $Xb.kq(142,228.038084)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(113,200.006499),new $Xb.kq(114,201.00458692),new $Xb.kq(115,202.00396885),new $Xb.kq(116,203.001423829),new $Xb.kq(117,204.001221209),new $Xb.kq(118,204.998663961),new $Xb.kq(119,205.998486886),new $Xb.kq(120,206.996859385),new $Xb.kq(121,207.997133849),new $Xb.kq(122,208.995915421),new $Xb.kq(123,209.996398327),new $Xb.kq(124,210.995529332),new $Xb.kq(125,211.996194988),new $Xb.kq(126,212.996174845),new $Xb.kq(127,213.99895474),new $Xb.kq(128,215.000326029),new $Xb.kq(129,216.003187873),new $Xb.kq(130,217.004616452),new $Xb.kq(131,218.007563326),new $Xb.kq(132,219.009240843),new $Xb.kq(133,220.012312978),new $Xb.kq(134,221.014245654),new $Xb.kq(135,222.017543957),new $Xb.kq(136,223.019730712),new $Xb.kq(137,224.023235513),new $Xb.kq(138,225.025606914),new $Xb.kq(139,226.029343423),new $Xb.kq(140,227.031833167),new $Xb.kq(141,228.034776087),new $Xb.kq(142,229.038426),new $Xb.kq(143,230.04251),new $Xb.kq(144,231.045407),new $Xb.kq(145,232.049654)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(115,203.00921),new $Xb.kq(116,204.006434513),new $Xb.kq(117,205.006187),new $Xb.kq(118,206.004463814),new $Xb.kq(119,207.005176607),new $Xb.kq(120,208.001776),new $Xb.kq(121,209.001944),new $Xb.kq(122,210.000446),new $Xb.kq(123,211.000893996),new $Xb.kq(124,211.999783492),new $Xb.kq(125,213.000345847),new $Xb.kq(126,214.000091141),new $Xb.kq(127,215.002704195),new $Xb.kq(128,216.003518402),new $Xb.kq(129,217.00630601),new $Xb.kq(130,218.007123948),new $Xb.kq(131,219.010068787),new $Xb.kq(132,220.011014669),new $Xb.kq(133,221.013907762),new $Xb.kq(134,222.01536182),new $Xb.kq(135,223.01849714),new $Xb.kq(136,224.020202004),new $Xb.kq(137,225.023604463),new $Xb.kq(138,226.025402555),new $Xb.kq(139,227.029170677),new $Xb.kq(140,228.031064101),new $Xb.kq(141,229.034820309),new $Xb.kq(142,230.037084774),new $Xb.kq(143,231.04122),new $Xb.kq(144,232.043693),new $Xb.kq(145,233.047995),new $Xb.kq(146,234.050547)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(118,207.012469754),new $Xb.kq(119,208.012112949),new $Xb.kq(120,209.009568736),new $Xb.kq(121,210.009256802),new $Xb.kq(122,211.007648196),new $Xb.kq(123,212.007811441),new $Xb.kq(124,213.006573689),new $Xb.kq(125,214.006893072),new $Xb.kq(126,215.006450832),new $Xb.kq(127,216.008721268),new $Xb.kq(128,217.009332676),new $Xb.kq(129,218.011625045),new $Xb.kq(130,219.012404918),new $Xb.kq(131,220.014752105),new $Xb.kq(132,221.015575746),new $Xb.kq(133,222.017828852),new $Xb.kq(134,223.01912603),new $Xb.kq(135,224.021708435),new $Xb.kq(136,225.023220576),new $Xb.kq(137,226.026089848),new $Xb.kq(138,227.027746979),new $Xb.kq(139,228.031014825),new $Xb.kq(140,229.032930871),new $Xb.kq(141,230.036025144),new $Xb.kq(142,231.038551503),new $Xb.kq(143,232.042022474),new $Xb.kq(144,233.04455),new $Xb.kq(145,234.04842),new $Xb.kq(146,235.051102),new $Xb.kq(147,236.055178)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(120,210.015711883),new $Xb.kq(121,211.016306912),new $Xb.kq(122,212.012916),new $Xb.kq(123,213.012962),new $Xb.kq(124,214.011451),new $Xb.kq(125,215.011726597),new $Xb.kq(126,216.011050963),new $Xb.kq(127,217.013066169),new $Xb.kq(128,218.013267744),new $Xb.kq(129,219.015521253),new $Xb.kq(130,220.015733126),new $Xb.kq(131,221.018171499),new $Xb.kq(132,222.018454131),new $Xb.kq(133,223.020795153),new $Xb.kq(134,224.02145925),new $Xb.kq(135,225.023941441),new $Xb.kq(136,226.024890681),new $Xb.kq(137,227.027698859),new $Xb.kq(138,228.028731348),new $Xb.kq(139,229.03175534),new $Xb.kq(140,230.033126574),new $Xb.kq(141,231.03629706),new $Xb.kq(142,232.03805036),new $Xb.kq(143,233.041576923),new $Xb.kq(144,234.043595497),new $Xb.kq(145,235.04750442),new $Xb.kq(146,236.04971),new $Xb.kq(147,237.053894),new $Xb.kq(148,238.056243)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(122,213.021183209),new $Xb.kq(123,214.02073923),new $Xb.kq(124,215.019097612),new $Xb.kq(125,216.019109649),new $Xb.kq(126,217.018288571),new $Xb.kq(127,218.020007906),new $Xb.kq(128,219.019880348),new $Xb.kq(129,220.021876493),new $Xb.kq(130,221.021863742),new $Xb.kq(131,222.023726),new $Xb.kq(132,223.023963748),new $Xb.kq(133,224.025614854),new $Xb.kq(134,225.026115172),new $Xb.kq(135,226.02793275),new $Xb.kq(136,227.028793151),new $Xb.kq(137,228.031036942),new $Xb.kq(138,229.032088601),new $Xb.kq(139,230.034532562),new $Xb.kq(140,231.035878898),new $Xb.kq(141,232.03858172),new $Xb.kq(142,233.040240235),new $Xb.kq(143,234.043302325),new $Xb.kq(144,235.045436759),new $Xb.kq(145,236.048675176),new $Xb.kq(146,237.05113943),new $Xb.kq(147,238.054497046),new $Xb.kq(148,239.05713),new $Xb.kq(149,240.06098)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(126,218.023487),new $Xb.kq(127,219.024915423),new $Xb.kq(128,220.024712),new $Xb.kq(129,221.026351),new $Xb.kq(130,222.02607),new $Xb.kq(131,223.027722956),new $Xb.kq(132,224.027590139),new $Xb.kq(133,225.029384369),new $Xb.kq(134,226.02933975),new $Xb.kq(135,227.031140069),new $Xb.kq(136,228.031366357),new $Xb.kq(137,229.033496137),new $Xb.kq(138,230.033927392),new $Xb.kq(139,231.036289158),new $Xb.kq(140,232.03714628),new $Xb.kq(141,233.039628196),new $Xb.kq(142,234.040945606),new $Xb.kq(143,235.043923062),new $Xb.kq(144,236.045561897),new $Xb.kq(145,237.048723955),new $Xb.kq(146,238.050782583),new $Xb.kq(147,239.054287777),new $Xb.kq(148,240.056585734),new $Xb.kq(149,241.06033),new $Xb.kq(150,242.062925)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(132,225.033899689),new $Xb.kq(133,226.035129),new $Xb.kq(134,227.034958261),new $Xb.kq(135,228.03618),new $Xb.kq(136,229.036246866),new $Xb.kq(137,230.037812591),new $Xb.kq(138,231.038233161),new $Xb.kq(139,232.040099),new $Xb.kq(140,233.04073235),new $Xb.kq(141,234.042888556),new $Xb.kq(142,235.044055876),new $Xb.kq(143,236.046559724),new $Xb.kq(144,237.048167253),new $Xb.kq(145,238.050940464),new $Xb.kq(146,239.052931399),new $Xb.kq(147,240.056168828),new $Xb.kq(148,241.058246266),new $Xb.kq(149,242.061635),new $Xb.kq(150,243.064273),new $Xb.kq(151,244.06785)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(134,228.038727686),new $Xb.kq(135,229.040138934),new $Xb.kq(136,230.039645603),new $Xb.kq(137,231.041258),new $Xb.kq(138,232.041179445),new $Xb.kq(139,233.04298757),new $Xb.kq(140,234.043304681),new $Xb.kq(141,235.0452815),new $Xb.kq(142,236.046048088),new $Xb.kq(143,237.048403774),new $Xb.kq(144,238.0495534),new $Xb.kq(145,239.052156519),new $Xb.kq(146,240.05380746),new $Xb.kq(147,241.056845291),new $Xb.kq(148,242.058736847),new $Xb.kq(149,243.061997013),new $Xb.kq(150,244.06419765),new $Xb.kq(151,245.067738657),new $Xb.kq(152,246.070198429),new $Xb.kq(153,247.07407)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(136,231.04556),new $Xb.kq(137,232.04659),new $Xb.kq(138,233.046472),new $Xb.kq(139,234.047794),new $Xb.kq(140,235.048029),new $Xb.kq(141,236.049569),new $Xb.kq(142,237.049970748),new $Xb.kq(143,238.051977839),new $Xb.kq(144,239.053018481),new $Xb.kq(145,240.055287826),new $Xb.kq(146,241.056822944),new $Xb.kq(147,242.059543039),new $Xb.kq(148,243.061372686),new $Xb.kq(149,244.064279429),new $Xb.kq(150,245.066445398),new $Xb.kq(151,246.069768438),new $Xb.kq(152,247.072086),new $Xb.kq(153,248.075745),new $Xb.kq(154,249.07848)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(137,233.0508),new $Xb.kq(138,234.05024),new $Xb.kq(139,235.051591),new $Xb.kq(140,236.051405),new $Xb.kq(141,237.052891),new $Xb.kq(142,238.053016298),new $Xb.kq(143,239.054951),new $Xb.kq(144,240.055519046),new $Xb.kq(145,241.057646736),new $Xb.kq(146,242.058829326),new $Xb.kq(147,243.061382249),new $Xb.kq(148,244.062746349),new $Xb.kq(149,245.065485586),new $Xb.kq(150,246.067217551),new $Xb.kq(151,247.070346811),new $Xb.kq(152,248.072342247),new $Xb.kq(153,249.075947062),new $Xb.kq(154,250.078350687),new $Xb.kq(155,251.082277873),new $Xb.kq(156,252.08487)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(138,235.05658),new $Xb.kq(139,236.05733),new $Xb.kq(140,237.057127),new $Xb.kq(141,238.058266),new $Xb.kq(142,239.058362),new $Xb.kq(143,240.059749),new $Xb.kq(144,241.060223),new $Xb.kq(145,242.06205),new $Xb.kq(146,243.06300157),new $Xb.kq(147,244.065167882),new $Xb.kq(148,245.066355386),new $Xb.kq(149,246.068666836),new $Xb.kq(150,247.070298533),new $Xb.kq(151,248.07308),new $Xb.kq(152,249.074979937),new $Xb.kq(153,250.078310529),new $Xb.kq(154,251.08075344),new $Xb.kq(155,252.084303),new $Xb.kq(156,253.08688),new $Xb.kq(157,254.0906)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(139,237.06207),new $Xb.kq(140,238.06141),new $Xb.kq(141,239.062579),new $Xb.kq(142,240.062295),new $Xb.kq(143,241.063716),new $Xb.kq(144,242.063688713),new $Xb.kq(145,243.065421),new $Xb.kq(146,244.06599039),new $Xb.kq(147,245.068039),new $Xb.kq(148,246.068798807),new $Xb.kq(149,247.070992043),new $Xb.kq(150,248.07217808),new $Xb.kq(151,249.074846818),new $Xb.kq(152,250.076399951),new $Xb.kq(153,251.079580056),new $Xb.kq(154,252.081619582),new $Xb.kq(155,253.085126791),new $Xb.kq(156,254.087316198),new $Xb.kq(157,255.091039),new $Xb.kq(158,256.09344)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(141,240.06892),new $Xb.kq(142,241.068662),new $Xb.kq(143,242.069699),new $Xb.kq(144,243.069631),new $Xb.kq(145,244.070969),new $Xb.kq(146,245.071317),new $Xb.kq(147,246.072965),new $Xb.kq(148,247.07365),new $Xb.kq(149,248.075458),new $Xb.kq(150,249.076405),new $Xb.kq(151,250.078654),new $Xb.kq(152,251.079983592),new $Xb.kq(153,252.082972247),new $Xb.kq(154,253.084817974),new $Xb.kq(155,254.088016026),new $Xb.kq(156,255.090266386),new $Xb.kq(157,256.093592),new $Xb.kq(158,257.095979)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(142,242.07343),new $Xb.kq(143,243.07451),new $Xb.kq(144,244.074077),new $Xb.kq(145,245.075375),new $Xb.kq(146,246.075281634),new $Xb.kq(147,247.076819),new $Xb.kq(148,248.077184411),new $Xb.kq(149,249.079024),new $Xb.kq(150,250.079514759),new $Xb.kq(151,251.081566467),new $Xb.kq(152,252.082460071),new $Xb.kq(153,253.085176259),new $Xb.kq(154,254.086847795),new $Xb.kq(155,255.089955466),new $Xb.kq(156,256.091766522),new $Xb.kq(157,257.095098635),new $Xb.kq(158,258.097069),new $Xb.kq(159,259.100588)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(144,245.081017),new $Xb.kq(145,246.081933),new $Xb.kq(146,247.081804),new $Xb.kq(147,248.082909),new $Xb.kq(148,249.083002),new $Xb.kq(149,250.084488),new $Xb.kq(150,251.084919),new $Xb.kq(151,252.08663),new $Xb.kq(152,253.08728),new $Xb.kq(153,254.089725),new $Xb.kq(154,255.091075196),new $Xb.kq(155,256.094052757),new $Xb.kq(156,257.095534643),new $Xb.kq(157,258.098425321),new $Xb.kq(158,259.100503),new $Xb.kq(159,260.103645)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(147,249.087823),new $Xb.kq(148,250.087493),new $Xb.kq(149,251.08896),new $Xb.kq(150,252.088965909),new $Xb.kq(151,253.090649),new $Xb.kq(152,254.090948746),new $Xb.kq(153,255.093232449),new $Xb.kq(154,256.094275879),new $Xb.kq(155,257.096852778),new $Xb.kq(156,258.0982),new $Xb.kq(157,259.101024),new $Xb.kq(158,260.102636),new $Xb.kq(159,261.105743),new $Xb.kq(160,262.10752)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(148,251.09436),new $Xb.kq(149,252.09533),new $Xb.kq(150,253.095258),new $Xb.kq(151,254.096587),new $Xb.kq(152,255.096769),new $Xb.kq(153,256.098763),new $Xb.kq(154,257.099606),new $Xb.kq(155,258.101883),new $Xb.kq(156,259.10299),new $Xb.kq(157,260.105572),new $Xb.kq(158,261.106941),new $Xb.kq(159,262.109692),new $Xb.kq(160,263.111394)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(149,253.100679),new $Xb.kq(150,254.100166),new $Xb.kq(151,255.101492),new $Xb.kq(152,256.101179573),new $Xb.kq(153,257.103072),new $Xb.kq(154,258.103568),new $Xb.kq(155,259.105628),new $Xb.kq(156,260.106434),new $Xb.kq(157,261.108752),new $Xb.kq(158,262.109918),new $Xb.kq(159,263.11254),new $Xb.kq(160,264.113978)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(150,255.107398),new $Xb.kq(151,256.10811),new $Xb.kq(152,257.107858),new $Xb.kq(153,258.109438),new $Xb.kq(154,259.109721),new $Xb.kq(155,260.111427),new $Xb.kq(156,261.112106),new $Xb.kq(157,262.114153),new $Xb.kq(158,263.115078),new $Xb.kq(159,264.117473),new $Xb.kq(160,265.118659)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(152,258.113151),new $Xb.kq(153,259.114652),new $Xb.kq(154,260.114435447),new $Xb.kq(155,261.116199),new $Xb.kq(156,262.116477),new $Xb.kq(157,263.118313),new $Xb.kq(158,264.118924),new $Xb.kq(159,265.121066),new $Xb.kq(160,266.121928)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(153,260.121803),new $Xb.kq(154,261.1218),new $Xb.kq(155,262.123009),new $Xb.kq(156,263.123146),new $Xb.kq(157,264.12473),new $Xb.kq(158,265.125198),new $Xb.kq(159,266.127009),new $Xb.kq(160,267.12774)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(155,263.12871),new $Xb.kq(156,264.128408258),new $Xb.kq(157,265.130001),new $Xb.kq(158,266.130042),new $Xb.kq(159,267.131774),new $Xb.kq(160,268.132156),new $Xb.kq(161,269.134114)]),$jb(Mjb(UXb.Nlb,1),x_b,3,0,[new $Xb.kq(156,265.136567),new $Xb.kq(157,266.13794),new $Xb.kq(158,267.137526),new $Xb.kq(159,268.138816),new $Xb.kq(160,269.139106),new $Xb.kq(161,270.140723),new $Xb.kq(162,271.141229)])]);};$Xb.nq=function nq(a,b){$Xb.mq();var c,d;d=b-a;for(c=0;c<$Xb.lq[a].length;c++)if($Xb.lq[a][c].b==d)return $Xb.lq[a][c].a;return NaN;};$Xb.oq=function oq(a,b){var c;if(a.b.length!=b.b.length)return a.b.length<b.b.length?-1:1;for(c=0;c<a.b.length;c++)if(a.b[c]!=b.b[c])return a.b[c]<b.b[c]?-1:1;return 0;};$Xb.pq=function pq(a){var b,c,d,e,f,g;c=0;for(e=a.a,f=0,g=e.length;f<g;++f){d=e[f];d&&++c;}a.b=Sjb(UXb.llb,yZb,6,c,15,1);c=0;for(b=0;b<a.a.length;b++)a.a[b]&&(a.b[c++]=b);};$Xb.qq=function qq(a,b){var c;$Xb.pq(a);for(c=0;c<a.b.length;c++)if(b[a.b[c]])return true;return false;};$Xb.rq=function rq(a){this.a=Sjb(UXb.Cwb,KZb,6,a,16,1);};xxb(272,1,{272:1,18:1},$Xb.rq);_.Eb=function sq(a){return $Xb.oq(this,a);};UXb.Olb=VFb(272);$Xb.wq=function wq(){$Xb.wq=zxb;$Xb.vq=$jb(Mjb(UXb.jlb,1),wZb,6,15,[0,1.00794,4.0026,6.941,9.0122,10.811,12.011,14.007,15.999,18.998,20.18,22.99,24.305,26.982,28.086,30.974,32.066,35.453,39.948,39.098,40.078,44.956,47.867,50.942,51.996,54.938,55.845,58.933,58.693,63.546,65.39,69.723,72.61,74.922,78.96,79.904,83.8,85.468,87.62,88.906,91.224,92.906,95.94,98.906,101.07,102.91,106.42,107.87,112.41,114.82,118.71,121.76,127.6,126.9,131.29,132.91,137.33,138.91,140.12,140.91,144.24,146.92,150.36,151.96,157.25,158.93,162.5,164.93,167.26,168.93,173.04,174.97,178.49,180.95,183.84,186.21,190.23,192.22,195.08,196.97,200.59,204.38,207.2,208.98,209.98,209.99,222.02,223.02,226.03,227.03,232.04,231.04,238.03,237.05,239.05,241.06,244.06,249.08,252.08,252.08,257.1,258.1,259.1,262.11,267.12,268.13,271.13,270.13,277.15,276.15,y_b,y_b,283.17,285.18,z_b,z_b,293.2,A_b,A_b,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.0141,3.016,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71.0787,156.18828,114.10364,115.0877,103.1447,128.13052,129.11458,57.05182,137.14158,113.15934,113.15934,128.17428,131.19846,147.17646,97.11658,87.0777,101.10458,186.2134,163.17546,99.13246]);$Xb.tq=$jb(Mjb(UXb.jlb,1),wZb,6,15,[0,1.007825,4.0026,7.016003,9.012182,11.009305,12,14.003074,15.994915,18.998403,19.992435,22.989767,23.985042,26.98153,27.976927,30.973762,31.97207,34.968852,39.962384,38.963707,39.962591,44.95591,47.947947,50.943962,51.940509,54.938047,55.934939,58.933198,57.935346,62.939598,63.929145,68.92558,73.921177,74.921594,79.91652,78.918336,83.911507,84.911794,87.905619,88.905849,89.904703,92.906377,97.905406,89.92381,101.904348,102.9055,105.903478,106.905092,113.903357,114.90388,119.9022,120.903821,129.906229,126.904473,131.904144,132.905429,137.905232,138.906346,139.905433,140.907647,141.907719,135.92398,151.919729,152.921225,157.924099,158.925342,163.929171,164.930319,165.93029,168.934212,173.938859,174.94077,179.946545,180.947992,183.950928,186.955744,191.961467,192.962917,194.964766,196.966543,201.970617,204.974401,207.976627,208.980374,193.98818,195.99573,199.9957,201.00411,206.0038,210.00923,232.038054,216.01896,238.050784,229.03623,232.041169,237.05005,238.05302,242.06194,240.06228,243.06947,243.07446,248.08275,251.08887,253.09515,257.10295,257.10777,271.13,270.13,277.15,276.15,y_b,y_b,283.17,285.18,z_b,z_b,291.2,A_b,A_b,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.014,3.01605,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]);$Xb.uq=$jb(Mjb(UXb.llb,1),yZb,6,15,[6,1,7,8]);};$Xb.xq=function xq(a){var b,c;c=a.a;for(b=0;b<a.b.length;b++)c+=a.b[b]*$Xb.tq[a.c[b]];return c;};$Xb.yq=function yq(a){var b,c;b=new VXb._Hb();for(c=0;c<a.b.length;c++){VXb.$Hb(b,($Xb.Sj(),$Xb.Mj)[a.c[c]]);a.b[c]>1&&VXb.ZHb(b,a.b[c]);}return b.a;};$Xb.zq=function zq(a){var b,c;c=a.d;for(b=0;b<a.b.length;b++)c+=a.b[b]*$Xb.vq[a.c[b]];return c;};$Xb.Aq=function Aq(a){var b,c,d,e,f,g,h,i,j,k,l;$Xb.nu(a,1);e=Sjb(UXb.llb,yZb,6,191,15,1);for(c=0;c<a.q;c++){switch(a.C[c]){case 171:e[1]+=5;e[6]+=3;e[7]+=1;e[8]+=1;break;case 172:e[1]+=12;e[6]+=6;e[7]+=4;e[8]+=1;break;case 173:e[1]+=6;e[6]+=4;e[7]+=2;e[8]+=2;break;case 174:e[1]+=5;e[6]+=4;e[7]+=1;e[8]+=3;break;case 175:e[1]+=5;e[6]+=3;e[7]+=1;e[8]+=1;e[16]+=1;break;case 176:e[1]+=8;e[6]+=5;e[7]+=2;e[8]+=2;break;case 177:e[1]+=7;e[6]+=5;e[7]+=1;e[8]+=3;break;case 178:e[1]+=3;e[6]+=2;e[7]+=1;e[8]+=1;break;case 179:e[1]+=7;e[6]+=6;e[7]+=3;e[8]+=1;break;case 181:case 180:e[1]+=11;e[6]+=6;e[7]+=1;e[8]+=1;break;case 182:e[1]+=12;e[6]+=6;e[7]+=2;e[8]+=1;break;case 183:e[1]+=9;e[6]+=5;e[7]+=1;e[8]+=1;e[16]+=1;break;case 184:e[1]+=9;e[6]+=9;e[7]+=1;e[8]+=1;break;case 185:e[1]+=7;e[6]+=5;e[7]+=1;e[8]+=1;break;case 186:e[1]+=5;e[6]+=3;e[7]+=1;e[8]+=2;break;case 187:e[1]+=7;e[6]+=4;e[7]+=1;e[8]+=2;break;case 188:e[1]+=10;e[6]+=11;e[7]+=2;e[8]+=1;break;case 189:e[1]+=9;e[6]+=9;e[7]+=1;e[8]+=2;break;case 190:e[1]+=9;e[6]+=5;e[7]+=1;e[8]+=1;break;case 1:switch(a.A[c]){case 0:case 1:++e[1];break;case 2:++e[151];break;case 3:++e[152];}break;default:++e[a.C[c]];}}for(d=0;d<a.q;d++)a.C[d]>=171&&a.C[d]<=190?e[1]+=2-$Xb.ko(a,d):e[1]+=$Xb.fo(a,d);h=0;for(j=1;j<=190;j++)e[j]!=0&&++h;this.b=Sjb(UXb.llb,yZb,6,h,15,1);this.c=Sjb(UXb.llb,yZb,6,h,15,1);h=0;for(i=0;i<$Xb.uq.length;i++){if(e[$Xb.uq[i]]!=0){this.b[h]=e[$Xb.uq[i]];this.c[h]=$Xb.uq[i];++h;e[$Xb.uq[i]]=0;}}while(true){l='zzz';k=-1;for(g=1;g<=190;g++)if(e[g]>0&&VXb.yHb(l,($Xb.Sj(),$Xb.Mj)[g])>0){l=($Xb.Sj(),$Xb.Mj)[g];k=g;}if(k==-1)break;this.b[h]=e[k];this.c[h]=k;++h;e[k]=0;}this.a=0;this.d=0;for(b=0;b<a.f;b++){if(a.C[b]!=1&&a.A[b]!=0){g=a.C[b];f=a.A[b];this.a+=$Xb.nq(g,f)-$Xb.tq[g];this.d+=$Xb.nq(g,f)-$Xb.vq[g];}}};xxb(170,1,{170:1});_.ib=function Bq(a){var b;if(a===this)return true;if(!Zkb(a,170))return false;for(b=0;b<this.b.length;b++)if(this.b[b]!=a.b[b])return false;return true;};_.a=0;_.d=0;UXb.Plb=VFb(170);$Xb.Cq=function Cq(a){switch(a){case 6:return 1;case 53:return 2;case 33:return 3;case 34:return 4;case 35:return 5;case 15:return 6;case 16:return 7;case 17:return 8;case 7:return 9;case 8:return 10;case 9:return 11;}return 0;};$Xb.Dq=function Dq(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C;$Xb.nu(a,7);B=0;n=Sjb(UXb.Cwb,KZb,6,a.f,16,1);C=Sjb(UXb.llb,yZb,6,a.f,15,1);for(f=0;f<a.g;f++){c=a.D[0][f];d=a.D[1][f];g=a.s[c];h=a.s[d];if(g!=0&&h!=0&&g<0^h<0){n[c]=true;n[d]=true;}C[c]+=$Xb.bl(a,f);C[d]+=$Xb.bl(a,f);}for(i=0;i<a.f;i++){B+=a.s[i];if(a.s[i]==1){if(a.C[i]==7){if(!n[i]){if(C[i]<=3){B-=1;a.s[i]=0;a.T=0;if(a.j[i]!=a.e[i]){$Xb.ok(a,$Xb.Rn(a,i,a.e[i]-1));$Xb.nu(a,7);}}else if(i<a.f&&$Xb.Ur(a.p,i)){r=Sjb(UXb.Cwb,KZb,6,a.f,16,1);s=Sjb(UXb.Cwb,KZb,6,a.g,16,1);$Xb.An(a,i,true,r,s);for(k=0;k<a.f;k++){if(r[k]&&a.C[k]==7&&a.s[k]==0&&C[k]==2){if($Xb.Gq(a,s,i,k)){B-=1;break;}}}}}}}else if(a.s[i]<0){if(a.C[i]==6||a.C[i]==7||a.C[i]==8||a.C[i]==16){if(n[i]){v=Sjb(UXb.llb,yZb,6,16,15,1);v[0]=i;A=1;w=0;while(w<A){for(e=0;e<a.r;e++){b=-1;a.D[0][e]==v[w]?b=a.D[1][e]:a.D[1][e]==v[w]&&(b=a.D[0][e]);if(b==-1)continue;if(a.s[b]!=0){l=false;for(p=0;p<A;p++){if(b==v[p]){l=true;break;}}if(!l){if(A==v.length){j=Sjb(UXb.llb,yZb,6,2*v.length,15,1);VXb.pIb(v,0,j,0,v.length);v=j;}v[A++]=b;}}}++w;}m=0;for(q=0;q<A;q++){m+=$Xb.zk(a,v[q]);}if(m<0){t=-1;u=99;for(o=0;o<A;o++){if($Xb.zk(a,v[o])<0){if(u>$Xb.Cq($Xb.Qk(a,v[o]))){u=$Xb.Cq($Xb.Qk(a,v[o]));t=v[o];}}}if(t!=-1){B-=a.s[t];a.s[t]=0;a.T=0;}}}else {B-=a.s[i];a.s[i]=0;a.T=0;}}}}B>0&&(B=$Xb.Eq(a,B));return B;};$Xb.Eq=function Eq(a,b){var c,d,e,f;b>0&&(b=$Xb.Hq(a,b,9));b>0&&(b=$Xb.Hq(a,b,17));b>0&&(b=$Xb.Hq(a,b,35));b>0&&(b=$Xb.Hq(a,b,53));if(b>0){for(c=0;c<a.f;c++){if(a.s[c]>0){e=false;for(f=0;f<a.j[c];f++){d=a.i[c][f];if(a.s[d]==0&&$Xb.Cl(a,d)&&$Xb.fo(a,d)>0){a.s[d]=-1;a.T=0;--b;if(b==0)return 0;e=true;break;}}if(e)continue;}}}b>0&&(b=$Xb.Fq(a,b,8,16));b>0&&(b=$Xb.Fq(a,b,8,15));b>0&&(b=$Xb.Fq(a,b,8,6));b>0&&(b=$Xb.Fq(a,b,7,16));return b;};$Xb.Fq=function Fq(a,b,c,d){var e,f,g,h,i,j,k,l;for(e=0;e<a.f;e++){if(a.C[e]==c&&a.s[e]==0&&$Xb.fo(a,e)>0){h=false;for(j=0;j<a.j[e];j++){if(a.n[e][j]==1){f=a.i[e][j];if(a.C[f]==d){l=false;i=false;for(k=0;k<a.j[f];k++){g=a.i[f][k];if(a.s[g]<0){i=true;break;}g!=e&&a.C[g]==8&&a.n[f][k]==2&&(l=true);}if(!i&&l){a.s[e]=-1;a.T=0;--b;if(b==0)return 0;h=true;}}}if(h)break;}}}return b;};$Xb.Gq=function Gq(a,b,c,d){var e,f,g,h,i,j,k,l;l=Sjb(UXb.llb,yZb,6,a.g,15,1);i=Sjb(UXb.Cwb,KZb,6,a.g,16,1);for(g=0;g<a.g;g++){l[g]=a.H[g];if(b[g]){i[g]=true;a.H[g]=1;a.T=0;}}for(e=0;e<a.f;e++){if(e!=d&&a.o[e]==0&&i[a.k[d][0]]){for(k=0;k<a.j[e];k++){h=a.k[e][k];a.H[h]=1;a.T=0;i[h]=false;}}}for(j=0;j<a.j[c];j++){h=a.k[c][j];a.H[h]=1;a.T=0;i[h]=false;}if($Xb.je(new $Xb.te(a),i,false)){a.s[c]=0;a.T=0;a.j[d]!=a.e[d]&&$Xb.ok(a,$Xb.Rn(a,d,a.e[d]-1));$Xb.nu(a,7);return true;}for(f=0;f<a.g;f++){$Xb.Fm(a,f,l[f]);}return false;};$Xb.Hq=function Hq(a,b,c){var d;for(d=0;d<a.f;d++){if(a.C[d]==c&&a.s[d]==0&&a.j[d]==0){a.s[d]=-1;a.T=0;--b;if(b==0)return 0;}}return b;};$Xb.Iq=function Iq(a,b){var c,d;d=UYb.QKb(a.b,b);for(c=YXb.LTb(d).length;c<10;c++)VXb.cIb(a.a,32);VXb.gIb(a.a,d);};$Xb.Jq=function Jq(a,b){var c,d,e;if(b<0||b>999){VXb.gIb(a.a,'  ?');return;}c=false;for(d=0;d<3;d++){e=b/100|0;if(e==0){d==2||c?VXb.cIb(a.a,48):VXb.cIb(a.a,32);}else {VXb.cIb(a.a,48+e&pZb);c=true;}b=10*(b%100);}};$Xb.Kq=function Kq(a,b){RYb.UEb(b,a.a.a);};$Xb.Lq=function Lq(a){$Xb.Mq.call(this,a);};$Xb.Mq=function Mq(a){$Xb.Oq.call(this,a,new VXb.kIb());};$Xb.Nq=function Nq(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z;this.b=new UYb.TKb((N=B_b,N));$Xb.nu(a,15);L=true;for(e=0;e<a.f;e++){if((a.u[e]&3)!=0&&(a.u[e]&3)!=3&&(a.u[e]&E$b)>>18!=1){L=false;break;}}O=-1;if(L){F=Sjb(UXb.llb,yZb,6,32,15,1);P=0;for(f=0;f<a.f;f++){if((a.u[f]&3)!=0&&(a.u[f]&3)!=3&&(a.u[f]&E$b)>>18==1){H=(a.u[f]&E$b)>>18!=1&&(a.u[f]&E$b)>>18!=2?-1:(a.u[f]&h_b)>>20;++F[H];if(P<F[H]){P=F[H];O=H;}break;}}}this.a=!c?new VXb.jIb():c;R=a.P!=null?a.P:'';VXb.gIb(this.a,R+_Yb);VXb.gIb(this.a,'Actelion Java MolfileCreator 1.0\n\n');$Xb.Jq(this,a.q);$Xb.Jq(this,a.r);VXb.gIb(this.a,'  0  0');$Xb.Jq(this,L?0:1);VXb.gIb(this.a,'  0  0  0  0  0999 V2000\n');I=a.q==1;for(i=1;i<a.q;i++){if(a.J[i].a!=a.J[0].a||a.J[i].b!=a.J[0].b||a.J[i].c!=a.J[0].c){I=true;break;}}G=1;if(I){if(b!=0){G=b;}else {s=$Xb.Sk(a,a.q,a.r,($Xb.Sj(),$Xb.Rj));if(s!=0){(s<1||s>3)&&(G=1.5/s);}else {Q=_$b;for(f=1;f<a.q;f++){for(h=0;h<f;h++){B=a.J[h].a-a.J[f].a;C=a.J[h].b-a.J[f].b;D=a.J[h].c-a.J[f].c;A=B*B+C*C+D*D;Q>A&&(Q=A);}}G=3/Q;}}}for(j=0;j<a.q;j++){if(I){$Xb.Iq(this,G*a.J[j].a);$Xb.Iq(this,G*-a.J[j].b);$Xb.Iq(this,G*-a.J[j].c);}else {VXb.gIb(this.a,'    0.0000    0.0000    0.0000');}if((a.v==null?null:a.v[j])!=null)VXb.gIb(this.a,' L  ');else if(cxb(Jwb(a.B[j],1),0))VXb.gIb(this.a,' A  ');else if(a.C[j]>=129&&a.C[j]<=144||a.C[j]==154)VXb.gIb(this.a,' R# ');else {p=($Xb.Sj(),$Xb.Mj)[a.C[j]];VXb.gIb(this.a,' '+p);YXb.LTb(p).length==1?VXb.gIb(this.a,'  '):YXb.LTb(p).length==2&&VXb.gIb(this.a,' ');}VXb.gIb(this.a,' 0  0  0');J=Jwb(WZb,a.B[j]);Owb(J,0)==0?VXb.gIb(this.a,'  0'):Owb(J,384)==0?VXb.gIb(this.a,'  3'):Owb(J,128)==0?VXb.gIb(this.a,'  2'):Owb(J,1792)==0?VXb.gIb(this.a,'  1'):Owb(J,1664)==0&&VXb.gIb(this.a,'  2');VXb.gIb(this.a,cxb(Jwb(a.B[j],w$b),0)?'  1':'  0');Z=((a.u[j]&g_b)>>>27)-1;Z==-1?VXb.gIb(this.a,'  0'):Z==0?VXb.gIb(this.a,' 15'):$Xb.Jq(this,Z);VXb.gIb(this.a,'  0  0  0');$Xb.Jq(this,$wnd.Math.abs(a.w[j]));VXb.gIb(this.a,'  0  0\n');}for(t=0;t<a.r;t++){switch(a.H[t]){case 1:T=1;W=0;break;case 2:T=2;W=0;break;case 4:T=3;W=0;break;case 129:T=1;W=6;break;case 257:T=1;W=1;break;case 386:T=2;W=3;break;case 64:T=4;W=0;break;case 32:T=8;W=0;break;default:T=1;W=0;}if(L&&(W==1||W==6)){f=a.D[0][t];(a.u[f]&E$b)>>18==2?W=0:(a.u[f]&E$b)>>18==1&&((a.u[f]&E$b)>>18!=1&&(a.u[f]&E$b)>>18!=2?-1:(a.u[f]&h_b)>>20)!=O&&(W=4);}u=a.G[t]&31;u!=0&&(u==8?T=4:u==3?T=5:u==9?T=6:u==10?T=7:T=8);V=a.G[t]&384;Y=V==0?0:V==256?1:2;$Xb.Jq(this,1+a.D[0][t]);$Xb.Jq(this,1+a.D[1][t]);$Xb.Jq(this,T);$Xb.Jq(this,W);VXb.gIb(this.a,'  0');$Xb.Jq(this,Y);VXb.gIb(this.a,'  0\n');}S=0;for(k=0;k<a.q;k++)a.s[k]!=0&&++S;if(S!=0){w=0;for(f=0;f<a.q;f++){if(a.s[f]!=0){if(w==0){VXb.gIb(this.a,'M  CHG');$Xb.Jq(this,$wnd.Math.min(8,S));}VXb.gIb(this.a,' ');$Xb.Jq(this,f+1);v=a.s[f];if(v<0){VXb.gIb(this.a,'  -');v=-v;}else VXb.gIb(this.a,'   ');VXb.cIb(this.a,48+v&pZb);--S;if(++w==8||S==0){w=0;VXb.gIb(this.a,_Yb);}}}}S=0;for(l=0;l<a.q;l++)a.A[l]==0||++S;if(S!=0){w=0;for(f=0;f<a.q;f++){if(a.A[f]!=0){if(w==0){VXb.gIb(this.a,'M  ISO');$Xb.Jq(this,$wnd.Math.min(8,S));}VXb.gIb(this.a,' ');$Xb.Jq(this,f+1);VXb.gIb(this.a,' ');$Xb.Jq(this,a.A[f]);--S;if(++w==8||S==0){w=0;VXb.gIb(this.a,_Yb);}}}}S=0;for(m=0;m<a.q;m++)(a.u[m]&48)!=0&&++S;if(S!=0){w=0;for(f=0;f<a.q;f++){if((a.u[f]&48)!=0){if(w==0){VXb.gIb(this.a,'M  RAD');$Xb.Jq(this,$wnd.Math.min(8,S));}VXb.gIb(this.a,' ');$Xb.Jq(this,f+1);switch(a.u[f]&48){case 16:VXb.gIb(this.a,'   1');break;case 32:VXb.gIb(this.a,'   2');break;case 48:VXb.gIb(this.a,'   3');}--S;if(++w==8||S==0){w=0;VXb.gIb(this.a,_Yb);}}}}S=0;for(n=0;n<a.q;n++)(a.C[n]>=129&&a.C[n]<=144||a.C[n]==154)&&++S;if(S!=0){w=0;for(d=0;d<a.q;d++){r=a.C[d];if(r>=129&&r<=144||r==154){if(w==0){VXb.gIb(this.a,'M  RGP');$Xb.Jq(this,$wnd.Math.min(8,S));}VXb.gIb(this.a,' ');$Xb.Jq(this,d+1);VXb.gIb(this.a,' ');$Xb.Jq(this,r==154?0:r>=142?r-141:r-125);--S;if(++w==8||S==0){w=0;VXb.gIb(this.a,_Yb);}}}}if(a.K){S=0;for(f=0;f<a.q;f++)cxb(Jwb(a.B[f],120),0)&&++S;if(S!=0){w=0;for(h=0;h<a.q;h++){U=Jwb(a.B[h],120);if(Owb(U,0)!=0){if(w==0){VXb.gIb(this.a,'M  RBC');$Xb.Jq(this,$wnd.Math.min(8,S));}VXb.gIb(this.a,' ');$Xb.Jq(this,h+1);Owb(U,112)==0?VXb.gIb(this.a,'  -1'):Owb(U,8)==0?VXb.gIb(this.a,'   1'):Owb(U,104)==0?VXb.gIb(this.a,'   2'):Owb(U,88)==0?VXb.gIb(this.a,'   3'):Owb(U,56)==0&&VXb.gIb(this.a,'   4');--S;if(++w==8||S==0){w=0;VXb.gIb(this.a,_Yb);}}}}for(o=0;o<a.q;o++){q=a.v==null?null:a.v[o];if(q!=null){VXb.gIb(this.a,'M  ALS ');$Xb.Jq(this,o+1);$Xb.Jq(this,q.length);VXb.gIb(this.a,cxb(Jwb(a.B[o],1),0)?' T ':' F ');for(K=0;K<q.length;K++){M=($Xb.Sj(),$Xb.Mj)[q[K]];switch(YXb.LTb(M).length){case 1:VXb.gIb(this.a,M+'   ');break;case 2:VXb.gIb(this.a,M+'  ');break;case 3:VXb.gIb(this.a,M+' ');break;default:VXb.gIb(this.a,'   ?');}}VXb.gIb(this.a,_Yb);}}S=0;for(g=0;g<a.q;g++)cxb(Jwb(a.B[g],6144),0)&&++S;if(S!=0){w=0;for(d=0;d<a.q;d++){X=Jwb(a.B[d],6144);if(Owb(X,0)!=0){if(w==0){VXb.gIb(this.a,'M  SUB');$Xb.Jq(this,$wnd.Math.min(8,S));}VXb.gIb(this.a,' ');$Xb.Jq(this,d+1);cxb(Jwb(X,SZb),0)?VXb.gIb(this.a,'   '+(a.e[d]+1)):VXb.gIb(this.a,'  -2');--S;if(++w==8||S==0){w=0;VXb.gIb(this.a,_Yb);}}}}}VXb.gIb(this.a,C_b);};$Xb.Oq=function Oq(a,b){$Xb.Nq.call(this,a,0,b);};xxb(135,1,{},$Xb.Lq,$Xb.Nq);UXb.Rlb=VFb(135);$Xb.Pq=function Pq(a,b,c,d,e,f){var g,h,i,j;j=1;h=false;switch(e){case 1:j=257;break;case 3:j=386;break;case 4:j=257;h=true;break;case 6:j=129;break;default:switch(d){case 1:j=1;break;case 2:j=2;break;case 3:j=4;break;case 4:j=64;break;case 9:j=32;}}g=$Xb.Wj(a.j,b,c,j);i=0;h&&$Xb.hm(a.j,b,1,-1);if(d>4){switch(d){case 5:i|=3;break;case 6:i|=9;break;case 7:i|=10;break;case 8:j!=32&&(i|=31);}}f==1&&(i|=256);f==2&&(i|=128);i!=0&&$Xb.Em(a.j,g,i,true);return g;};$Xb.Qq=function Qq(a){var b,c,d,e,f,g,h,i,j,k,l;g=Sjb(UXb.llb,yZb,6,a.j.q,15,1);for(c=0;c<a.j.q;c++)g[c]=-$Xb.zk(a.j,c);$Xb.je(new $Xb.te(a.j),null,true);for(d=0;d<a.j.q;d++)g[d]+=$Xb.zk(a.j,d);for(b=0;b<a.j.q;b++){if(g[b]!=0){h=-g[b];for(e=0;e<a.j.r;e++){for(j=0;j<2;j++){if(h>0&&$Xb.el(a.j,e)==32&&$Xb.Vk(a.j,1-j,e)==b){l=$Xb.Vk(a.j,j,e);if($Xb.Fl(a.j,l)){k=$Xb.Sq(a,l);f=$Xb.zk(a.j,l);if(f<k){i=$wnd.Math.min(h,k-f);$Xb.cm(a.j,l,f+i);h-=i;}}}}}}}};$Xb.Rq=function Rq(a,b){a.j=null;return $Xb.hr(a,new RYb.PEb(new RYb.TEb(b)))?a.j:null;};$Xb.Sq=function Sq(a,b){var c,d;c=$Xb.Qk(a.j,b);d=c<($Xb.Sj(),$Xb.Oj).length?$Xb.Oj[c]:null;return d==null?0:d[d.length-1];};$Xb.Tq=function Tq(a,b){var c;c=!a.b?null:_Xb.lNb(a.b,new VXb.IGb(b));return !c?b-1:c.a;};$Xb.Uq=function Uq(a,b){var c;c=!a.c?null:_Xb.lNb(a.c,new VXb.IGb(b));return !c?b-1:c.a;};$Xb.Vq=function Vq(a,b){var c,d;if(b!=null){$Xb.nu(a.j,1);for(c=0;c<a.j.f;c++){if(b[c]!=0){d=$Xb.il(a.j,c,$Xb.ko(a.j,c));b[c]==15?d>=0&&$Xb.am(a.j,c,0):b[c]!=$Xb.jl(a.j,c)&&$Xb.am(a.j,c,b[c]-d);}}}};$Xb.Wq=function Wq(a,b){var c;if(b==-1){return -1;}for(c=b+1;c<YXb.LTb(a).length;c++){YXb.GTb(c,YXb.LTb(a).length);if(YXb.LTb(a).charCodeAt(c)!=32&&(YXb.GTb(c,YXb.LTb(a).length),YXb.LTb(a).charCodeAt(c)!=9)){return c;}}return -1;};$Xb.Xq=function Xq(a,b){var c;for(c=b;c<YXb.LTb(a).length;c++){YXb.GTb(c,YXb.LTb(a).length);if(YXb.LTb(a).charCodeAt(c)==32||(YXb.GTb(c,YXb.LTb(a).length),YXb.LTb(a).charCodeAt(c)==9)){return c;}}return -1;};$Xb.Yq=function Yq(a){if(YXb.LTb(a).indexOf('ATOMS=(')!=-1)return D_b;if(YXb.LTb(a).indexOf('BONDS=(')!=-1)return 'BONDS';return null;};$Xb.Zq=function Zq(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F;p=0;q=(h=$Xb.Xq(b,p+1),h==-1?YXb.LTb(b).length:h);d=VXb.nGb((YXb.FTb(p,q,YXb.LTb(b).length),YXb.LTb(b).substr(p,q-p)),E_b,gZb);p=$Xb.Wq(b,q);q=(i=$Xb.Xq(b,p+1),i==-1?YXb.LTb(b).length:i);s=(YXb.FTb(p,q,YXb.LTb(b).length),YXb.LTb(b).substr(p,q-p));A=null;e=false;r=$Xb.er(b);if(r!=0){A=$Xb.$q(b);r<0&&(e=true);q=$wnd.Math.abs(r);}p=$Xb.Wq(b,q);q=(j=$Xb.Xq(b,p+1),j==-1?YXb.LTb(b).length:j);C=AGb((YXb.FTb(p,q,YXb.LTb(b).length),YXb.LTb(b).substr(p,q-p)));p=$Xb.Wq(b,q);q=(k=$Xb.Xq(b,p+1),k==-1?YXb.LTb(b).length:k);D=AGb((YXb.FTb(p,q,YXb.LTb(b).length),YXb.LTb(b).substr(p,q-p)));p=$Xb.Wq(b,q);q=(l=$Xb.Xq(b,p+1),l==-1?YXb.LTb(b).length:l);F=AGb((YXb.FTb(p,q,YXb.LTb(b).length),YXb.LTb(b).substr(p,q-p)));p=$Xb.Wq(b,q);q=(m=$Xb.Xq(b,p+1),m==-1?YXb.LTb(b).length:m);u=VXb.nGb((YXb.FTb(p,q,YXb.LTb(b).length),YXb.LTb(b).substr(p,q-p)),E_b,gZb);c=$Xb.Tj(a.j,C,-D,-F);c+1!=d&&(!a.b&&(a.b=new _Xb.oRb()),_Xb.gRb(a.b,new VXb.IGb(d),new VXb.IGb(c)));if(A!=null){$Xb.vm(a.j,c,6);$Xb.jm(a.j,c,A,e);}u!=0&&$Xb.km(a.j,c,u,false);if(VXb.DHb(s,'A')||VXb.DHb(s,'*')){$Xb.om(a.j,c,1,true);}else if(VXb.DHb(s,'Q')){t=Sjb(UXb.llb,yZb,6,1,15,1);t[0]=6;$Xb.jm(a.j,c,t,true);}else {$Xb.vm(a.j,c,$Xb.hn(s,67));}while((p=$Xb.Wq(b,q))!=-1){q=(g=$Xb.Xq(b,p+1),g==-1?YXb.LTb(b).length:g);v=(YXb.FTb(p,q,YXb.LTb(b).length),YXb.LTb(b).substr(p,q-p));o=VXb.HHb(v,UHb(61));n=(YXb.FTb(0,o,YXb.LTb(v).length),YXb.LTb(v).substr(0,o));B=VXb.nGb((YXb.GTb(o+1,YXb.LTb(v).length+1),YXb.LTb(v).substr(o+1)),E_b,gZb);if(VXb.DHb(n,'CHG')){$Xb.cm(a.j,c,B);}else if(VXb.DHb(n,'RAD')){switch(B){case 1:$Xb.pm(a.j,c,16);break;case 2:$Xb.pm(a.j,c,32);break;case 3:$Xb.pm(a.j,c,48);}}else if(VXb.DHb(n,'CFG'));else if(VXb.DHb(n,'MASS')){$Xb.mm(a.j,c,B);}else if(VXb.DHb(n,'VAL')){$Xb.am(a.j,c,B==-1?0:B==0?-1:B);}else if(VXb.DHb(n,'HCOUNT')){switch(B){case 0:break;case-1:$Xb.om(a.j,c,1792,true);break;case 1:$Xb.om(a.j,c,128,true);break;case 2:$Xb.om(a.j,c,384,true);break;default:$Xb.om(a.j,c,896,true);}}else if(VXb.DHb(n,'SUBST')){if(B==-1){$Xb.om(a.j,c,x$b,true);}else if(B>0){w=0;for(f=0;f<a.j.r;f++){($Xb.Vk(a.j,0,f)==c||$Xb.Vk(a.j,1,f)==c)&&++w;}B>w&&$Xb.om(a.j,c,SZb,true);}}else if(VXb.DHb(n,'RBCNT')){switch(B){case 3:case-1:$Xb.om(a.j,c,112,true);break;case 1:$Xb.om(a.j,c,8,true);break;case 2:$Xb.om(a.j,c,104,true);break;case 4:$Xb.om(a.j,c,56,true);}}}};$Xb.$q=function $q(a){var b,c,d,e,f,g,h,i;h=null;c=YXb.LTb(a).indexOf('[');d=YXb.LTb(a).indexOf(']',c);if(c>=0&&d>0){b=Sjb(UXb.llb,yZb,6,16,15,1);i=(YXb.FTb(c+1,d,YXb.LTb(a).length),YXb.LTb(a).substr(c+1,d-(c+1)));e=0;g=true;while(g&&e<16){c=YXb.LTb(i).indexOf(',');f=null;if(c==-1){f=i;g=false;}else {f=(YXb.FTb(0,c,YXb.LTb(i).length),YXb.LTb(i).substr(0,c));i=(YXb.GTb(c+1,YXb.LTb(i).length+1),YXb.LTb(i).substr(c+1));}b[e++]=$Xb.hn(f,1);}h=Sjb(UXb.llb,yZb,6,e,15,1);VXb.pIb(b,0,h,0,e);}return h;};$Xb._q=function _q(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t;o=0;p=(i=$Xb.Xq(b,o+1),i==-1?YXb.LTb(b).length:i);f=VXb.nGb((YXb.FTb(o,p,YXb.LTb(b).length),YXb.LTb(b).substr(o,p-o)),E_b,gZb);o=$Xb.Wq(b,p);p=(j=$Xb.Xq(b,o+1),j==-1?YXb.LTb(b).length:j);g=VXb.nGb((YXb.FTb(o,p,YXb.LTb(b).length),YXb.LTb(b).substr(o,p-o)),E_b,gZb);o=$Xb.Wq(b,p);p=(k=$Xb.Xq(b,o+1),k==-1?YXb.LTb(b).length:k);c=$Xb.Tq(a,VXb.nGb((YXb.FTb(o,p,YXb.LTb(b).length),YXb.LTb(b).substr(o,p-o)),E_b,gZb));o=$Xb.Wq(b,p);p=(l=$Xb.Xq(b,o+1),l==-1?YXb.LTb(b).length:l);d=$Xb.Tq(a,VXb.nGb((YXb.FTb(o,p,YXb.LTb(b).length),YXb.LTb(b).substr(o,p-o)),E_b,gZb));r=0;s=0;while((o=$Xb.Wq(b,p))!=-1){p=(h=$Xb.Xq(b,o+1),h==-1?YXb.LTb(b).length:h);q=(YXb.FTb(o,p,YXb.LTb(b).length),YXb.LTb(b).substr(o,p-o));n=VXb.HHb(q,UHb(61));m=(YXb.FTb(0,n,YXb.LTb(q).length),YXb.LTb(q).substr(0,n));t=VXb.nGb((YXb.GTb(n+1,YXb.LTb(q).length+1),YXb.LTb(q).substr(n+1)),E_b,gZb);if(VXb.DHb(m,'CFG')){switch(t){case 1:r=1;break;case 2:r=g==2?3:4;break;case 3:r=6;}}else VXb.DHb(m,'TOPO')?s=t:undefined;}e=$Xb.Pq(a,c,d,g,r,s);e+1!=f&&(!a.c&&(a.c=new _Xb.oRb()),_Xb.gRb(a.c,new VXb.IGb(f),new VXb.IGb(e)));};$Xb.ar=function ar(a,b){var c,d,e,f,g,h;h=$Xb.Yq(b);if(h!=null){g=$Xb.cr(b,h);if(VXb.DHb(YXb.LTb(b).substr(0,13),'MDLV30/STEABS')){if(VXb.DHb(h,D_b))for(f=0;f<g.length;f++)$Xb.hm(a.j,$Xb.Tq(a,g[f]),0,-1);else for(e=0;e<g.length;e++)$Xb.zm(a.j,$Xb.Uq(a,g[e]),0,-1);}else if(VXb.DHb(YXb.LTb(b).substr(0,13),'MDLV30/STERAC')){d=VXb.nGb(VXb.RHb(b,13,$Xb.Xq(b,13)),E_b,gZb);if(VXb.DHb(h,D_b))for(f=0;f<g.length;f++)$Xb.hm(a.j,$Xb.Tq(a,g[f]),1,d-1);else for(e=0;e<g.length;e++)$Xb.zm(a.j,$Xb.Uq(a,g[e]),1,d-1);}else if(VXb.DHb(YXb.LTb(b).substr(0,13),'MDLV30/STEREL')){d=VXb.nGb(VXb.RHb(b,13,$Xb.Xq(b,13)),E_b,gZb);if(VXb.DHb(h,D_b))for(f=0;f<g.length;f++)$Xb.hm(a.j,$Xb.Tq(a,g[f]),2,d-1);else for(e=0;e<g.length;e++)$Xb.zm(a.j,$Xb.Uq(a,g[e]),2,d-1);}else if(VXb.DHb(YXb.LTb(b).substr(0,13),'MDLV30/HILITE')){if(VXb.DHb(h,D_b)){for(e=0;e<g.length;e++)$Xb.dm(a.j,$Xb.Tq(a,g[e]),448);}else {for(e=0;e<g.length;e++){c=$Xb.Uq(a,g[e]);$Xb.dm(a.j,$Xb.Vk(a.j,0,c),448);$Xb.dm(a.j,$Xb.Vk(a.j,1,c),448);}}}}};$Xb.br=function br(a,b){var c,d,e;if(!a.j){if(VXb.DHb(YXb.LTb(b).substr(0,6),'COUNTS')){c=$Xb.Wq(b,$Xb.Xq(b,7));d=VXb.nGb(VXb.RHb(b,7,$Xb.Xq(b,7)),E_b,gZb);e=VXb.nGb(VXb.RHb(b,c,$Xb.Xq(b,c)),E_b,gZb);a.j=new $Xb.Gu(d,e);}}};$Xb.cr=function cr(a,b){var c,d,e,f,g,h;f=YXb.LTb(a).indexOf(b+'=(')+YXb.LTb(b).length+2;g=VXb.IHb(a,UHb(41),f);e=$Xb.Xq(a,f);c=VXb.nGb((YXb.FTb(f,e,YXb.LTb(a).length),YXb.LTb(a).substr(f,e-f)),E_b,gZb);h=Sjb(UXb.llb,yZb,6,c,15,1);for(d=0;d<c;d++){f=$Xb.Wq(a,e);e=$Xb.Xq(a,f);(e==-1||e>g)&&(e=g);h[d]=VXb.nGb((YXb.FTb(f,e,YXb.LTb(a).length),YXb.LTb(a).substr(f,e-f)),E_b,gZb);}return h;};$Xb.dr=function dr(a){var b,c,d,e,f,g,h,i,j;i=Sjb(UXb.llb,yZb,6,a.j.q,15,1);for(d=0;d<a.j.r;d++)if($Xb.el(a.j,d)==64)for(g=0;g<2;g++)i[$Xb.Vk(a.j,g,d)]=1;for(e=0;e<a.j.r;e++){j=$Xb.bl(a.j,e);for(f=0;f<2;f++)i[$Xb.Vk(a.j,f,e)]+=j;}for(c=0;c<a.j.r;c++){if($Xb.bl(a.j,c)==1){for(f=0;f<2;f++){h=$Xb.Vk(a.j,1-f,c);if($Xb.Fl(a.j,h)){b=$Xb.Vk(a.j,f,c);if($Xb.Cl(a.j,b)&&i[b]>$Xb.jl(a.j,b)){$Xb.Fm(a.j,c,32);continue;}}}}}};$Xb.er=function er(a){var b,c;if(YXb.LTb(a).indexOf('[')>=0){b=YXb.LTb(a).indexOf(' NOT[');c=YXb.LTb(a).indexOf(']',b);if(b>=0&&c>0){return -(c+1);}else {b=YXb.LTb(a).indexOf(' [');c=YXb.LTb(a).indexOf(']',b);if(b>=0&&c>0){return c+1;}}b=YXb.LTb(a).indexOf(" 'NOT[");c=YXb.LTb(a).indexOf("]'",b);if(b>=0&&c>0){return -(c+2);}else {b=YXb.LTb(a).indexOf(" '[");c=YXb.LTb(a).indexOf("]'",b);if(b>=0&&c>0){return c+2;}}VXb.oIb();}return 0;};$Xb.fr=function fr(a,b,c){a.j=b;return $Xb.hr(a,c);};$Xb.gr=function gr(a){return YXb.LTb(a).length==0?0:VXb.nGb(a,E_b,gZb);};$Xb.hr=function hr(b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X;T=null;try{b.f=null;if(b.j){$Xb.hk(b.j);$Xb.Hm(b.j,false);}D=v=RYb.OEb(c);if(null==D){return false;}if(null==(v=RYb.OEb(c))){return false;}if(null==(v=RYb.OEb(c))){return false;}b.k=YXb.LTb(v).indexOf("From CSD data. Using bond type 'Any'")!=-1;b.e=YXb.LTb(v).indexOf('From CSD data.')!=-1;if(null==(v=RYb.OEb(c))){return false;}b.g=false;b.d=b.a;try{F=VXb.nGb(VXb.SHb((YXb.FTb(0,3,YXb.LTb(v).length),YXb.LTb(v).substr(0,3))),E_b,gZb);G=VXb.nGb(VXb.SHb((YXb.FTb(3,6,YXb.LTb(v).length),YXb.LTb(v).substr(3,3))),E_b,gZb);H=$Xb.gr(VXb.SHb((YXb.FTb(6,9,YXb.LTb(v).length),YXb.LTb(v).substr(6,3))));b.d=b.d|1==$Xb.gr(VXb.SHb((YXb.FTb(12,15,YXb.LTb(v).length),YXb.LTb(v).substr(12,3))));b.g=YXb.LTb(v).length>=39&&VXb.DHb(YXb.LTb(v).substr(34,YXb.LTb('V3000').length),'V3000');}catch(a){a=Gwb(a);if(Zkb(a,19)){return false;}else throw Hwb(a);}if(b.g){K=$Xb.ir(b,c);$Xb.Nm(b.j,D);return K;}!b.j&&(b.j=new $Xb.Gu(F,G));$Xb.Nm(b.j,D);b.d||(b.j.L=true);if(0==F){while(v!=null&&!(VXb.DHb(v,F_b)||VXb.DHb(v,G_b)||VXb.DHb((YXb.GTb(1,YXb.LTb(v).length+1),YXb.LTb(v).substr(1)),'$'))){v=RYb.OEb(c);}return true;}for(q=0;q<F;q++){if(null==(v=RYb.OEb(c))){return false;}V=AGb(VXb.SHb((YXb.FTb(0,10,YXb.LTb(v).length),YXb.LTb(v).substr(0,10))));W=AGb(VXb.SHb((YXb.FTb(10,20,YXb.LTb(v).length),YXb.LTb(v).substr(10,10))));X=AGb(VXb.SHb((YXb.FTb(20,30,YXb.LTb(v).length),YXb.LTb(v).substr(20,10))));e=$Xb.Tj(b.j,V,-W,-X);u=VXb.SHb((YXb.FTb(31,34,YXb.LTb(v).length),YXb.LTb(v).substr(31,3)));if(VXb.DHb(u,'A')||VXb.DHb(u,'*')){$Xb.om(b.j,e,1,true);}else if(VXb.DHb(u,'Q')){w=Sjb(UXb.llb,yZb,6,1,15,1);w[0]=6;$Xb.jm(b.j,e,w,true);}else {h=$Xb.hn(u,67);$Xb.vm(b.j,e,h);}C=$Xb.gr(VXb.SHb((YXb.FTb(34,36,YXb.LTb(v).length),YXb.LTb(v).substr(34,2))));C!=0&&$Xb.mm(b.j,e,($Xb.Sj(),$Xb.Qj)[$Xb.Qk(b.j,e)]+C);m=$Xb.gr(VXb.SHb((YXb.FTb(36,39,YXb.LTb(v).length),YXb.LTb(v).substr(36,3))));m!=0&&(m==4?$Xb.pm(b.j,e,32):$Xb.cm(b.j,e,4-m));A=YXb.LTb(v).length<63?0:$Xb.gr(VXb.SHb((YXb.FTb(60,63,YXb.LTb(v).length),YXb.LTb(v).substr(60,3))));$Xb.km(b.j,e,A,false);o=YXb.LTb(v).length<45?0:$Xb.gr(VXb.SHb((YXb.FTb(42,45,YXb.LTb(v).length),YXb.LTb(v).substr(42,3))));switch(o){case 0:break;case 1:$Xb.om(b.j,e,768,true);break;case 2:$Xb.om(b.j,e,128,true);break;case 3:$Xb.om(b.j,e,384,true);break;default:$Xb.om(b.j,e,896,true);}YXb.LTb(v).length>=48&&(YXb.GTb(47,YXb.LTb(v).length),YXb.LTb(v).charCodeAt(47)==49)&&$Xb.om(b.j,e,w$b,true);S=YXb.LTb(v).length<51?0:$Xb.gr(VXb.SHb((YXb.FTb(48,51,YXb.LTb(v).length),YXb.LTb(v).substr(48,3))));if(S!=0){T==null&&(T=Sjb(UXb.llb,yZb,6,F,15,1));T[e]=S;}}for(r=0;r<G;r++){if(null==(v=RYb.OEb(c))){return false;}f=VXb.nGb(VXb.SHb((YXb.FTb(0,3,YXb.LTb(v).length),YXb.LTb(v).substr(0,3))),E_b,gZb)-1;g=VXb.nGb(VXb.SHb((YXb.FTb(3,6,YXb.LTb(v).length),YXb.LTb(v).substr(3,3))),E_b,gZb)-1;k=VXb.nGb(VXb.SHb((YXb.FTb(6,9,YXb.LTb(v).length),YXb.LTb(v).substr(6,3))),E_b,gZb);N=YXb.LTb(v).length<12?0:$Xb.gr(VXb.SHb((YXb.FTb(9,12,YXb.LTb(v).length),YXb.LTb(v).substr(9,3))));R=YXb.LTb(v).length<18?0:$Xb.gr(VXb.SHb((YXb.FTb(15,18,YXb.LTb(v).length),YXb.LTb(v).substr(15,3))));k==8&&(b.k||$Xb.Fl(b.j,f)||$Xb.Fl(b.j,g))&&(k=9);$Xb.Pq(b,f,g,k,N,R);}for(p=0;p<H;p++){if(null==(v=RYb.OEb(c))){return false;}}if(null==(v=RYb.OEb(c))){(b.i&1)!=0&&(b.f=$Xb.co(b.j));$Xb.Vq(b,T);b.d||$Xb.nu(b.j,15);return true;}while(v!=null&&!(VXb.DHb(v,F_b)||VXb.DHb(v,G_b))){if(VXb.DHb(YXb.LTb(v).substr(0,6),'M  CHG')){s=VXb.nGb(VXb.SHb((YXb.FTb(6,9,YXb.LTb(v).length),YXb.LTb(v).substr(6,3))),E_b,gZb);if(s>0){d=10;U=14;for(t=1;t<=s;++t,d+=8,U+=8){e=VXb.nGb(VXb.SHb((YXb.FTb(d,d+3,YXb.LTb(v).length),YXb.LTb(v).substr(d,d+3-d))),E_b,gZb)-1;l=VXb.nGb(VXb.SHb((YXb.FTb(U,U+3,YXb.LTb(v).length),YXb.LTb(v).substr(U,U+3-U))),E_b,gZb);$Xb.cm(b.j,e,l);}}}if(VXb.DHb(YXb.LTb(v).substr(0,6),'M  ISO')){s=VXb.nGb(VXb.SHb((YXb.FTb(6,9,YXb.LTb(v).length),YXb.LTb(v).substr(6,3))),E_b,gZb);if(s>0){d=10;U=14;for(t=1;t<=s;++t,d+=8,U+=8){e=VXb.nGb(VXb.SHb((YXb.FTb(d,d+3,YXb.LTb(v).length),YXb.LTb(v).substr(d,d+3-d))),E_b,gZb)-1;B=VXb.nGb(VXb.SHb((YXb.FTb(U,U+3,YXb.LTb(v).length),YXb.LTb(v).substr(U,U+3-U))),E_b,gZb);$Xb.mm(b.j,e,B);}}}if(VXb.DHb(YXb.LTb(v).substr(0,6),'M  RAD')){s=VXb.nGb(VXb.SHb((YXb.FTb(6,9,YXb.LTb(v).length),YXb.LTb(v).substr(6,3))),E_b,gZb);if(s>0){d=10;U=14;for(t=1;t<=s;++t,d+=8,U+=8){e=VXb.nGb(VXb.SHb((YXb.FTb(d,d+3,YXb.LTb(v).length),YXb.LTb(v).substr(d,d+3-d))),E_b,gZb)-1;J=VXb.nGb(VXb.SHb((YXb.FTb(U,U+3,YXb.LTb(v).length),YXb.LTb(v).substr(U,U+3-U))),E_b,gZb);switch(J){case 1:$Xb.pm(b.j,e,16);break;case 2:$Xb.pm(b.j,e,32);break;case 3:$Xb.pm(b.j,e,48);}}}}if(VXb.DHb(YXb.LTb(v).substr(0,6),'M  RBC')||VXb.DHb(YXb.LTb(v).substr(0,6),'M  RBD')){s=VXb.nGb(VXb.SHb((YXb.FTb(6,9,YXb.LTb(v).length),YXb.LTb(v).substr(6,3))),E_b,gZb);if(s>0){d=10;U=14;for(t=1;t<=s;++t,d+=8,U+=8){e=VXb.nGb(VXb.SHb((YXb.FTb(d,d+3,YXb.LTb(v).length),YXb.LTb(v).substr(d,d+3-d))),E_b,gZb)-1;L=VXb.nGb(VXb.SHb((YXb.FTb(U,U+3,YXb.LTb(v).length),YXb.LTb(v).substr(U,U+3-U))),E_b,gZb);switch(L){case 3:case-1:$Xb.om(b.j,e,112,true);break;case 1:$Xb.om(b.j,e,8,true);break;case 2:$Xb.om(b.j,e,104,true);break;case 4:$Xb.om(b.j,e,56,true);}}}}if(VXb.DHb(YXb.LTb(v).substr(0,6),'M  ALS')){e=VXb.nGb(VXb.SHb((YXb.FTb(7,10,YXb.LTb(v).length),YXb.LTb(v).substr(7,3))),E_b,gZb)-1;if(e>=0){I=VXb.nGb(VXb.SHb((YXb.FTb(10,13,YXb.LTb(v).length),YXb.LTb(v).substr(10,3))),E_b,gZb);i=(YXb.GTb(14,YXb.LTb(v).length),YXb.LTb(v).charCodeAt(14)==84);S=Sjb(UXb.llb,yZb,6,I,15,1);d=16;for(t=0;t<I;++t,d+=4){Q=VXb.SHb((YXb.FTb(d,d+4,YXb.LTb(v).length),YXb.LTb(v).substr(d,d+4-d)));S[t]=$Xb.hn(Q,1);}$Xb.vm(b.j,e,6);$Xb.jm(b.j,e,S,i);}}if(VXb.DHb(YXb.LTb(v).substr(0,6),'M  SUB')){s=VXb.nGb(VXb.SHb((YXb.FTb(6,9,YXb.LTb(v).length),YXb.LTb(v).substr(6,3))),E_b,gZb);if(s>0){d=10;U=14;for(t=1;t<=s;++t,d+=8,U+=8){e=VXb.nGb(VXb.SHb((YXb.FTb(d,d+3,YXb.LTb(v).length),YXb.LTb(v).substr(d,d+3-d))),E_b,gZb)-1;O=VXb.nGb(VXb.SHb((YXb.FTb(U,U+3,YXb.LTb(v).length),YXb.LTb(v).substr(U,U+3-U))),E_b,gZb);if(O==-2){$Xb.om(b.j,e,x$b,true);}else if(O>0){P=0;for(j=0;j<b.j.r;j++){($Xb.Vk(b.j,0,j)==e||$Xb.Vk(b.j,1,j)==e)&&++P;}O>P&&$Xb.om(b.j,e,SZb,true);}}}}if(VXb.DHb(YXb.LTb(v).substr(0,6),'M  RGP')){s=VXb.nGb(VXb.SHb((YXb.FTb(6,9,YXb.LTb(v).length),YXb.LTb(v).substr(6,3))),E_b,gZb);if(s>0){d=10;U=14;for(t=1;t<=s;++t,d+=8,U+=8){e=VXb.nGb(VXb.SHb((YXb.FTb(d,d+3,YXb.LTb(v).length),YXb.LTb(v).substr(d,d+3-d))),E_b,gZb)-1;M=VXb.nGb(VXb.SHb((YXb.FTb(U,U+3,YXb.LTb(v).length),YXb.LTb(v).substr(U,U+3-U))),E_b,gZb);M>=1&&M<=20&&$Xb.vm(b.j,e,$Xb.hn('R'+M,2));}}}v=RYb.OEb(c);}}catch(a){a=Gwb(a);if(Zkb(a,19)){n=a;VXb.Jz(n,(VXb.oIb(),VXb.nIb),'');return false;}else throw Hwb(a);}if(b.e){$Xb.dr(b);$Xb.Qq(b);}(b.i&1)!=0&&(b.f=$Xb.co(b.j));$Xb.Vq(b,T);$Xb.nu(b.j,15);return true;};$Xb.ir=function ir(a,b){var c,d,e,f,g;!!a.b&&_Xb._Qb(a.b);!!a.c&&_Xb._Qb(a.c);e=0;d=RYb.OEb(b);while(d!=null&&VXb.DHb(YXb.LTb(d).substr(0,7),H_b)){d=VXb.SHb((YXb.GTb(7,YXb.LTb(d).length+1),YXb.LTb(d).substr(7)));while(g=YXb.LTb('-').length,VXb.DHb(YXb.LTb(d).substr(YXb.LTb(d).length-g,g),'-')){c=RYb.OEb(b);if(!VXb.DHb(YXb.LTb(c).substr(0,7),H_b)){return false;}d=VXb.SHb(VXb.AHb(VXb.RHb(d,0,YXb.LTb(d).length-1),(YXb.GTb(7,YXb.LTb(c).length+1),YXb.LTb(c).substr(7))));}if(VXb.DHb(YXb.LTb(d).substr(0,5),'BEGIN')){f=VXb.SHb((YXb.GTb(6,YXb.LTb(d).length+1),YXb.LTb(d).substr(6)));if(VXb.DHb(YXb.LTb(f).substr(0,4),'CTAB')){e=1;}else if(VXb.DHb(YXb.LTb(f).substr(0,4),'ATOM')){e=2;}else if(VXb.DHb(YXb.LTb(f).substr(0,4),'BOND')){e=3;}else if(VXb.DHb(YXb.LTb(f).substr(0,10),'COLLECTION')){e=4;}else {return false;}}else if(VXb.DHb(YXb.LTb(d).substr(0,3),'END')){e=0;}else if(e==1){$Xb.br(a,d);}else if(e==2){$Xb.Zq(a,d);}else if(e==3){$Xb._q(a,d);}else if(e==4){$Xb.ar(a,d);}else {return false;}d=RYb.OEb(b);}while(d!=null&&!(VXb.DHb(YXb.LTb(d).substr(0,6),F_b)||VXb.DHb(d,G_b))){d=RYb.OEb(b);}return true;};$Xb.jr=function jr(){this.i=0;};$Xb.kr=function kr(){this.i=1;};xxb(111,1,{},$Xb.jr,$Xb.kr);_.a=false;_.d=false;_.e=false;_.g=false;_.i=0;_.k=false;UXb.Slb=VFb(111);$Xb.lr=function lr(a){};$Xb.mr=function mr(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J;VXb.gIb(a.a,'M  V30 BEGIN CTAB\n');VXb.gIb(a.a,I_b+b.q+' '+b.r+' 0 0 0'+_Yb);VXb.gIb(a.a,'M  V30 BEGIN ATOM\n');for(i=0;i<b.q;i++){VXb.gIb(a.a,H_b+(i+1));if((b.v==null?null:b.v[i])!=null){k=b.v==null?null:b.v[i];u=cxb(Jwb(b.B[i],1),0);VXb.gIb(a.a,u?' NOT[':' [');for(s=0;s<k.length;s++){s>0&&VXb.gIb(a.a,',');t=($Xb.Sj(),$Xb.Mj)[k[s]];switch(YXb.LTb(t).length){case 2:case 3:case 1:VXb.gIb(a.a,t);break;default:VXb.gIb(a.a,'?');}}VXb.gIb(a.a,']');}else cxb(Jwb(b.B[i],1),0)?VXb.gIb(a.a,' A'):b.C[i]>=129&&b.C[i]<=144||b.C[i]==154?VXb.gIb(a.a,' R#'):VXb.gIb(a.a,' '+($Xb.Sj(),$Xb.Mj)[b.C[i]]);if(c){VXb.gIb(a.a,' '+glb(qZb*a.b*b.J[i].a)/qZb);VXb.gIb(a.a,' '+glb(qZb*a.b*-b.J[i].b)/qZb);VXb.gIb(a.a,' '+glb(qZb*a.b*-b.J[i].c)/qZb);}else {VXb.gIb(a.a,' 0 0 0');}VXb.gIb(a.a,' '+$wnd.Math.abs(b.w[i]));b.s[i]!=0&&VXb.gIb(a.a,' CHG='+b.s[i]);if((b.u[i]&48)!=0){VXb.gIb(a.a,' RAD=');switch(b.u[i]&48){case 16:VXb.gIb(a.a,'1');break;case 32:VXb.gIb(a.a,'2');break;case 48:VXb.gIb(a.a,'3');}}if((b.u[i]&3)==1||(b.u[i]&3)==2){VXb.gIb(a.a,' CFG=');(b.u[i]&3)==1?VXb.gIb(a.a,'1'):VXb.gIb(a.a,'2');}b.A[i]!=0&&VXb.gIb(a.a,' MASS='+b.A[i]);J=((b.u[i]&g_b)>>>27)-1;J!=-1&&VXb.gIb(a.a,' VAL='+(J==0?'-1':VXb.UGb(J)));l=b.C[i];(l>=129&&l<=144||l==154)&&VXb.gIb(a.a,' RGROUPS=(1 '+(l==154?0:l>=142?l-141:l-125)+')');r=Jwb(WZb,b.B[i]);Owb(r,384)==0?VXb.gIb(a.a,' HCOUNT=2'):Owb(r,128)==0?VXb.gIb(a.a,' HCOUNT=1'):Owb(r,1792)==0?VXb.gIb(a.a,' HCOUNT=-1'):Owb(r,1664)==0&&VXb.gIb(a.a,' HCOUNT=1');G=Jwb(b.B[i],6144);Owb(G,0)!=0&&(cxb(Jwb(G,SZb),0)?VXb.gIb(a.a,' SUBST='+(b.e[i]+1)):VXb.gIb(a.a,' SUBST=-1'));C=Jwb(b.B[i],120);Owb(C,0)!=0&&(Owb(C,112)==0?VXb.gIb(a.a,' RBCNT=-1'):Owb(C,8)==0?VXb.gIb(a.a,' RBCNT=2'):Owb(C,104)==0?VXb.gIb(a.a,' RBCNT=2'):Owb(C,88)==0?VXb.gIb(a.a,' RBCNT=3'):Owb(C,56)==0&&VXb.gIb(a.a,' RBCNT=4'));VXb.gIb(a.a,_Yb);}VXb.gIb(a.a,'M  V30 END ATOM\n');VXb.gIb(a.a,'M  V30 BEGIN BOND\n');for(n=0;n<b.r;n++){VXb.gIb(a.a,H_b+(n+1));switch(b.H[n]){case 1:A=1;F=0;break;case 2:A=2;F=0;break;case 4:A=3;F=0;break;case 129:A=1;F=3;break;case 257:A=1;F=1;break;case 386:A=2;F=2;break;case 64:A=4;F=0;break;case 32:A=9;F=0;break;default:A=1;F=0;}p=b.G[n]&31;p!=0&&(p==8?A=4:p==3?A=5:p==9?A=6:p==10?A=7:A=8);VXb.gIb(a.a,' '+A+' '+(b.D[0][n]+1)+' '+(b.D[1][n]+1));F!=0&&VXb.gIb(a.a,' CFG='+F);D=b.G[n]&384;H=D==0?0:D==256?1:2;H!=0&&VXb.gIb(a.a,' TOPO='+H);VXb.gIb(a.a,_Yb);}VXb.gIb(a.a,'M  V30 END BOND\n');B=false;d=0;v=Sjb(UXb.llb,yZb,6,32,15,1);f=Sjb(UXb.llb,yZb,6,32,15,1);for(j=0;j<b.f;j++){if((b.u[j]&3)==1||(b.u[j]&3)==2){B=true;I=(b.u[j]&E$b)>>18;I==1?++f[(b.u[j]&E$b)>>18!=1&&(b.u[j]&E$b)>>18!=2?-1:(b.u[j]&h_b)>>20]:I==2?++v[(b.u[j]&E$b)>>18!=1&&(b.u[j]&E$b)>>18!=2?-1:(b.u[j]&h_b)>>20]:++d;}}e=0;w=Sjb(UXb.llb,yZb,6,32,15,1);g=Sjb(UXb.llb,yZb,6,32,15,1);for(o=0;o<b.g;o++){if($Xb.bl(b,o)!=2&&((b.F[o]&3)==1||(b.F[o]&3)==2)){B=true;I=(b.F[o]&768)>>8;I==1?++g[(b.F[o]&768)>>8!=1&&(b.F[o]&768)>>8!=2?-1:(b.F[o]&i_b)>>10]:I==2?++w[(b.F[o]&768)>>8!=1&&(b.F[o]&768)>>8!=2?-1:(b.F[o]&i_b)>>10]:++e;}}if(B){VXb.gIb(a.a,'M  V30 BEGIN COLLECTION\n');if(d!=0){VXb.gIb(a.a,'M  V30 MDLV30/STEABS ATOMS=('+d);for(h=0;h<b.f;h++){((b.u[h]&3)==1||(b.u[h]&3)==2)&&(b.u[h]&E$b)>>18==0&&VXb.gIb(a.a,' '+(h+1));}VXb.gIb(a.a,J_b);}if(e!=0){VXb.gIb(a.a,'M  V30 MDLV30/STEABS BONDS=('+e);for(m=0;m<b.g;m++){$Xb.bl(b,m)!=2&&((b.F[m]&3)==1||(b.F[m]&3)==2)&&(b.F[m]&768)>>8==0&&VXb.gIb(a.a,' '+(m+1));}VXb.gIb(a.a,J_b);}for(q=0;q<32;q++){if(v[q]!=0){VXb.gIb(a.a,K_b+(q+1)+' ATOMS=('+v[q]);for(h=0;h<b.f;h++){((b.u[h]&3)==1||(b.u[h]&3)==2)&&(b.u[h]&E$b)>>18==2&&((b.u[h]&E$b)>>18!=1&&(b.u[h]&E$b)>>18!=2?-1:(b.u[h]&h_b)>>20)==q&&VXb.gIb(a.a,' '+(h+1));}VXb.gIb(a.a,J_b);}if(f[q]!=0){VXb.gIb(a.a,L_b+(q+1)+' ATOMS=('+f[q]);for(h=0;h<b.f;h++){((b.u[h]&3)==1||(b.u[h]&3)==2)&&(b.u[h]&E$b)>>18==1&&((b.u[h]&E$b)>>18!=1&&(b.u[h]&E$b)>>18!=2?-1:(b.u[h]&h_b)>>20)==q&&VXb.gIb(a.a,' '+(h+1));}VXb.gIb(a.a,J_b);}if(w[q]!=0){VXb.gIb(a.a,K_b+(q+1)+' BONDS=('+w[q]);for(m=0;m<b.g;m++){$Xb.bl(b,m)!=2&&((b.F[m]&3)==1||(b.F[m]&3)==2)&&(b.F[m]&768)>>8==2&&((b.F[m]&768)>>8!=1&&(b.F[m]&768)>>8!=2?-1:(b.F[m]&i_b)>>10)==q&&VXb.gIb(a.a,' '+(m+1));}VXb.gIb(a.a,J_b);}if(g[q]!=0){VXb.gIb(a.a,L_b+(q+1)+' BONDS=('+g[q]);for(m=0;m<b.g;m++){$Xb.bl(b,m)!=2&&((b.F[m]&3)==1||(b.F[m]&3)==2)&&(b.F[m]&768)>>8==1&&((b.F[m]&768)>>8!=1&&(b.F[m]&768)>>8!=2?-1:(b.F[m]&i_b)>>10)==q&&VXb.gIb(a.a,' '+(m+1));}VXb.gIb(a.a,J_b);}}VXb.gIb(a.a,'M  V30 END COLLECTION\n');}VXb.gIb(a.a,'M  V30 END CTAB\n');};$Xb.nr=function nr(){$Xb.lr(this);this.a=new VXb.kIb();};$Xb.or=function or(a){$Xb.pr.call(this,a);};$Xb.pr=function pr(a){$Xb.qr.call(this,a,new VXb.kIb());};$Xb.qr=function qr(a,b){var c,d;$Xb.lr(this);$Xb.nu(a,15);this.a=b;d=a.P!=null?a.P:'';VXb.gIb(this.a,d+_Yb);VXb.gIb(this.a,'Actelion Java MolfileCreator 2.0\n\n');VXb.gIb(this.a,'  0  0  0  0  0  0              0 V3000\n');this.b=1;c=$Xb.sr(a);c&&(this.b=$Xb.rr(a));$Xb.mr(this,a,c);VXb.gIb(this.a,C_b);};$Xb.rr=function rr(a){var b,c,d,e,f,g,h,i,j;j=1;d=$Xb.Sk(a,a.q,a.r,($Xb.Sj(),$Xb.Rj));if(d!=0){(d<1||d>3)&&(j=1.5/d);}else {i=M_b;for(b=1;b<a.q;b++){for(c=0;c<b;c++){f=a.J[c].a-a.J[b].a;g=a.J[c].b-a.J[b].b;h=a.J[c].c-a.J[b].c;e=f*f+g*g+h*h;i>e&&(i=e);}}j=3/$wnd.Math.max(0.75,i);}return j;};$Xb.sr=function sr(a){var b;if(a.q==1)return true;for(b=1;b<a.q;b++){if(a.J[b].a!=a.J[0].a||a.J[b].b!=a.J[0].b||a.J[b].c!=a.J[0].c){return true;}}return false;};$Xb.tr=function tr(a,b){var c;c=new $Xb.nr();c.b=b;$Xb.nu(a,15);$Xb.mr(c,a,true);return c.a.a;};xxb(136,1,{},$Xb.nr,$Xb.or);_.b=1;UXb.Tlb=VFb(136);$Xb.wr=function wr(){$Xb.wr=zxb;$Xb.ur=$jb(Mjb(UXb.Oub,2),aZb,14,0,[$jb(Mjb(UXb.Oub,1),nZb,2,6,['Acyl','gCaHA`AIf`@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['Alloc','gNph@l@ILzuR@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['Allyl','Al']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['Benzyl;Bn','daD@`F@DjUZxHH@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['Boc','daxD`@S@AIgijj@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['BOM;BzOM','deTH`@H@Re[TYj`@@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['Bs','dmtDpAdLS`aPAIe]jf`@e`@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['Bt','dew@`@aJ@DiY]paej`@@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['Btm','did@P@BJ@Die_ahH@@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['Butyl;nButyl','gJPHB@IRuP@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['Benzoyl;Bz','didH`@p@RYm^Eh@@@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['Bzh','dg|@`N@LdbRbtJUB]aAP@@@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['Cbz','dmtD`@S@AIgYVUZh@@@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['cButyl','gKPHL@IThuT@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['cHeptyl','daD@`L@DjWVzjj`@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['cHexyl','gOpHL@IToWUU@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['cOctyl','did@`L@DjWWajjj@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['cPentyl','gFpHL@ITimUP@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['cPropyl','gBPHL@Qxjh@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['COOH','gC`h@l@ILt@@ !Bb@K~@Hc}']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['DEAE','daz@`@x@RiUjj`@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['DEIPS','diD@P@\\B@DjfVjj`@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['DMIPS','gNpD@xD@RjZjh@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['DMPM','dcLD`@kPCIEMDdcttDDT@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['DMPS','deT@P@\\B@LddTjPsU@@@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['DMTr','fak@b@@Mt@ISZ{SMjo{NQKfm@AU@@@E@@@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['DNP','dkmB`hdDt~@HeNfS{HihheCAUhBHX@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['DNS;Dan','fhi`a@KPP@HH@YIHYheEhYKQgKP@@QP@@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['DPIPS','fdyAA@H@\\B@FRRIQSQIHzp_Qjh@h@@@@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['DPTBS','fleAA@H@\\B@FRRIQSRIIWNbEMU@EP@@@@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['DTBMS','dmT@P@\\B@Djffjjjh@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['Ethyl','eMBD@ch@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['Fmoc','fde@b@@Hp@IL{LrjxeVCzKUT@@@P@@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['iAmyl','gGPHJ@YIDZj@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['iButyl','gJPHB@ITuP@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['Im','gFtHAj@IRnKSP@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['iPropyl','gC`HL@Qz`@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['MDIPS','diD@P@\\B@DjfZjj`@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['MDPS','foA@A@@NA@CIIEEBdeeVLzj@@@@@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['Methyl','eFBH@c@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['MEM','gNphAR@IRoUT@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['Mes','deT@`J@DjY{[`bB`@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['MMTr','ffcAB@@Z@Dim]ifuWYrI\\uh@Jh@@@@@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['MOM','gCaHA`AJZ`@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['MPM;PMB','deTH`@d@Rfuunh@J@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['Ms','gJPdH`DD@cuh@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['MTM','gC`D@DX@Rfh@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['mTolyl','daD@`N@DjWjXHB@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['N3','gClHaE`@RnReX@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['nAmyl;Amyl','gGPHJ@IRmU@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['neoAm','gGPHJ@IUMU@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['NO2,Nitro','gChhhE`BRnRYh@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['Np','deVDaHAI@HeNR[e_aZ@B@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['nPropyl;Propyl','gC`HL@IST@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['oTolyl','daD@`J@DjYvxH`@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['Phenyl','gOpHL@IToVD@@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['Pht','dcLL`@RU@Dfyed]ZBA`@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['Piv;Pv','gNqHA`AIffj`@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['PMBM','dcLD`@T`AJUm]FZh@J@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['PNB','dcNLaHAEt@bTyInUvxV`@f@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['Poc','didD`@S@AIgexVjj`@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['PPi','diDFsHSB[`|J|A@Lxn{lddqdZih@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['pTolyl','daD@`N@DjWzXHB@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['sAmyl','gGPHL@YIDZj@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['sButyl','gJPHL@ITuP@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['SEM','diDHPFApD@rRQUJjj`@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['SES','dedDpHP@``AgCIICeHmUT@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['SO3H','gJQdHl@``D^m@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['tAmyl','gGPHB@IUMU@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['TBDMS;TBS','dax@P@\\B@Djfjjh@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['TBDPS','fdy@A@@NA@CIIEEEIde]XOhuPAT@@@@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['TBMPS','dg\\HPHApH@rRQJJPjg]UAT@@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['tButyl,tBu','gJPHB@Q}T@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['TDS','ded@P@\\B@LddTeeUUP@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['Tf','daxDhHP@``BiAiCiCIICHmU@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['TFA','gNqBJIARFdF@YEHYUL@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['Thexyl','gNpHB@IUMUT@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['THF','gFqH@PAJYujj@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['THP','gOqH@PAJYZzjh@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['TIPS','dmT@P@\\B@DjfYjjjh@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['TMS','gJPD@xD@czh@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['Tosyl;Ts','dmtDPHP@``CIICLeaeZ@B@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['Troc','diDDHJxHaHcH`PCHiBeJjf@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['Trt','fbm@B@A@FRQIRKQPiIZdoIcdHJ`@@@@@@']),$jb(Mjb(UXb.Oub,1),nZb,2,6,['Xyl','did@`J@DjYynBHH@@'])]);};$Xb.xr=function xr(){$Xb.wr();var a,b,c,d,e,f,g,h,i;$Xb.vr=new _Xb.oRb();for(g=$Xb.ur,h=0,i=g.length;h<i;++h){f=g[h];e=VXb.OHb(f[0],';');for(b=e,c=0,d=b.length;c<d;++c){a=b[c];_Xb.gRb($Xb.vr,VXb.MHb(YXb.LTb(a).toLowerCase(),'-'),f[1]);}}};$Xb.yr=function yr(a){$Xb.wr();var b,c,d,e;!$Xb.vr&&$Xb.xr();a=VXb.MHb(YXb.LTb(a).toLowerCase(),'-');for(e=(c=new _Xb.yRb(new _Xb.DRb(new _Xb.zNb($Xb.vr).a).b),new _Xb.HNb(c));_Xb.hMb(e.a.a);){d=(b=_Xb.wRb(e.a),b.Wd());if(VXb.DHb(YXb.LTb(d).substr(0,YXb.LTb(a).length),a))return true;}return false;};$Xb.vr=null;$Xb.zr=function zr(a){var b,c;c=0;for(b=0;b<a.a.q;b++)($Xb.Qk(a.a,b)==7||$Xb.Qk(a.a,b)==8)&&++c;return c;};$Xb.Ar=function Ar(a){var b,c;c=0;for(b=0;b<a.a.q;b++)($Xb.Qk(a.a,b)==7||$Xb.Qk(a.a,b)==8)&&$Xb.Fn(a.a,b)>0&&++c;return c;};$Xb.Br=function Br(b){var c;try{return iYb.cE((new iYb.eE(),b.a));}catch(a){a=Gwb(a);if(Zkb(a,19)){c=a;VXb.Jz(c,(VXb.oIb(),VXb.nIb),'');return -999;}else throw Hwb(a);}};$Xb.Cr=function Cr(a){this.a=a;$Xb.$o(a);};xxb(341,1,{});UXb.Ulb=VFb(341);$Xb.Dr=function Dr(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p;k=a.g.M;l=0;for(f=0;f<c;f++){if(k>b[f]){k=b[f];l=f;}}p=Sjb(UXb.llb,yZb,6,c,15,1);j=l>0?l-1:c-1;m=l<c-1?l+1:0;h=b[j]<b[m];for(g=0;g<c;g++){p[g]=b[l];h?--l<0&&(l=c-1):++l==c&&(l=0);}for(e=0;e<a.i.a.length;e++){o=_Xb.Xi(a.i,e);if(o.length!=c)continue;d=true;for(i=0;i<c;i++){if(o[i]!=p[i]){d=false;break;}}if(d)return;}_Xb.Si(a.i,p);n=$Xb.Pr(a,p);_Xb.Si(a.j,n);$Xb.es(a,p,n);};$Xb.Er=function Er(a,b,c){var d,e,f,g,h,i,j;i=Sjb(UXb.llb,yZb,6,a.f,15,1);g=Sjb(UXb.llb,yZb,6,a.f,15,1);j=Sjb(UXb.Cwb,KZb,6,a.g.f,16,1);d=$Xb.Vk(a.g,0,b);e=$Xb.Vk(a.g,1,b);i[0]=d;i[1]=e;g[1]=-1;j[e]=true;h=1;while(h>=1){++g[h];if(g[h]==$Xb.Sn(a.g,i[h])){j[i[h]]=false;--h;continue;}f=$Xb.Rn(a.g,i[h],g[h]);if(j[f]||c[f])continue;if(f==d&&h>1){$Xb.Dr(a,i,h+1);if(a.i.a.length>=XZb)return;continue;}if(h+1<a.f){++h;i[h]=f;j[f]=true;g[h]=-1;}}};$Xb.Fr=function Fr(a,b,c,d,e,f,g,h){var i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D;A=_Xb.Xi(a.i,b);for(l=A,m=0,n=l.length;m<n;++m){k=l[m];if(!$Xb.as(a,k))return true;}B=_Xb.Xi(a.j,b);C=B.length;o=0;j=0;D=false;for(v=0;v<C;v++){o<<=1;j<<=1;if($Xb.cs(a,B[v])){o|=1;}else if(h&&$Xb._r(a,B[v])){o|=1;j|=1;}else {i=c[b][v];if(i!=-1){if(d[i]){if(e[i]){o|=1;f[i]||(j|=1);}}else {D=true;}}}}u=false;switch(C){case 3:p=$jb(Mjb(UXb.llb,1),yZb,6,15,[2,1,4]);u=true;for(t=0;t<3;t++){if((o&p[t])==p[t]){if($Xb.Qk(a.g,A[t])==6&&$Xb.zk(a.g,A[t])==1||$Xb.Qk(a.g,A[t])==5&&$Xb.zk(a.g,A[t])==0){e[b]=true;g[b]=t;(j&p[t])==0&&(u=false);}}}break;case 5:q=$jb(Mjb(UXb.llb,1),yZb,6,15,[10,5,18,9,20]);u=true;for(w=0;w<5;w++){if((o&q[w])==q[w]){switch($Xb.Qk(a.g,A[w])){case 6:if($Xb.zk(a.g,A[w])==-1){e[b]=true;g[b]=w;(j&q[w])==0&&(u=false);}break;case 7:if($Xb.zk(a.g,A[w])<=0){e[b]=true;g[b]=w;}break;case 8:e[b]=true;g[b]=w;break;case 16:case 34:case 52:if($Xb.Sn(a.g,A[w])==2){e[b]=true;g[b]=w;}}}}break;case 6:u=true;if((o&21)==21){e[b]=true;(j&21)==0&&(u=false);}if((o&42)==42){e[b]=true;(j&42)==0&&(u=false);}break;case 7:r=$jb(Mjb(UXb.llb,1),yZb,6,15,[42,21,74,37,82,41,84]);u=true;for(s=0;s<7;s++){if((o&r[s])==r[s]){if($Xb.Qk(a.g,A[s])==6&&($Xb.zk(a.g,A[s])==1||h&&$Xb.Sr(a,A[s]))||$Xb.Qk(a.g,A[s])==5&&$Xb.zk(a.g,A[s])==0){e[b]=true;g[b]=s;(j&r[s])==0&&(u=false);}}}}e[b]&&!u&&(f[b]=true);if(e[b])return true;return !D;};$Xb.Gr=function Gr(a,b,c,d,e){var f,g,h,i,j,k,l,m,n,o,p,q;f=Sjb(UXb.llb,Q$b,8,a.i.a.length,0,2);for(j=0;j<a.i.a.length;j++){f[j]=Sjb(UXb.llb,yZb,6,_Xb.Xi(a.i,j).length,15,1);for(k=0;k<_Xb.Xi(a.i,j).length;k++)f[j][k]=-1;}p=Sjb(UXb.llb,yZb,6,a.g.g,15,1);for(n=0;n<a.j.a.length;n++){o=_Xb.Xi(a.j,n);if(o.length==3||o.length>=5&&o.length<=7){for(i=0;i<o.length;i++){h=o[i];if($Xb.Sn(a.g,$Xb.Vk(a.g,0,h))==3&&$Xb.Sn(a.g,$Xb.Vk(a.g,1,h))==3){if(p[h]>0){f[p[h]>>>16][p[h]&32767]=n;f[n][i]=p[h]>>>16;}else {p[h]=(n<<16)+m_b+i;}}}}}g=Sjb(UXb.Cwb,KZb,6,a.i.a.length,16,1);q=0;l=-1;while(q>l){l=q;for(m=0;m<a.i.a.length;m++){if(!g[m]){if($Xb.Fr(a,m,f,g,b,c,d,e)){g[m]=true;++q;}}}}};$Xb.Hr=function Hr(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o;e=$Xb.Vk(a.g,0,b);f=$Xb.Vk(a.g,1,b);i=Sjb(UXb.llb,yZb,6,a.g.f,15,1);j=Sjb(UXb.llb,yZb,6,a.g.f,15,1);k=Sjb(UXb.llb,yZb,6,a.g.f,15,1);i[0]=e;i[1]=f;j[e]=1;j[f]=2;k[e]=-1;k[f]=e;h=1;l=1;while(h<=l){for(m=0;m<$Xb.Sn(a.g,i[h]);m++){g=$Xb.Rn(a.g,i[h],m);if(h>1&&g==e){o=Sjb(UXb.llb,yZb,6,j[i[h]],15,1);d=i[h];for(n=0;n<o.length;n++){o[n]=d;d=k[d];}return o;}if(j[g]==0&&!c[g]){i[++l]=g;j[g]=j[i[h]]+1;k[g]=i[h];}}++h;}return null;};$Xb.Ir=function Ir(a,b,c){var d,e;e=_Xb.Xi(a.i,b);for(d=0;d<e.length;d++)if(c==e[d])return d;return -1;};$Xb.Jr=function Jr(a,b){return a.a[b]&pZb;};$Xb.Kr=function Kr(a,b,c){var d,e;e=_Xb.Xi(a.j,b);for(d=0;d<e.length;d++)if(c==e[d])return d;return -1;};$Xb.Lr=function Lr(a,b){return a.b[b]&pZb;};$Xb.Mr=function Mr(a,b){return a.c[b];};$Xb.Nr=function Nr(a,b){return _Xb.Xi(a.i,b);};$Xb.Or=function Or(a,b){return _Xb.Xi(a.j,b);};$Xb.Pr=function Pr(a,b){var c,d,e,f,g;f=b.length;g=Sjb(UXb.llb,yZb,6,f,15,1);for(d=0;d<f;d++){c=d==f-1?b[0]:b[d+1];for(e=0;e<$Xb.Sn(a.g,b[d]);e++){if($Xb.Rn(a.g,b[d],e)==c){g[d]=$Xb.Tn(a.g,b[d],e);break;}}}return g;};$Xb.Qr=function Qr(a,b){return _Xb.Xi(a.j,b).length;};$Xb.Rr=function Rr(a,b,c){var d;for(d=0;d<a.j.a.length;d++)if($Xb.Xr(a,d,b)&&$Xb.Xr(a,d,c))return d;return -1;};$Xb.Sr=function Sr(a,b){var c;for(c=0;c<$Xb.Sn(a.g,b);c++)if($Xb.Un(a.g,b,c)==2&&$Xb.Qk(a.g,$Xb.Rn(a.g,b,c))==8)return true;return false;};$Xb.Tr=function Tr(a,b){return a.d[b];};$Xb.Ur=function Ur(a,b){return (a.a[b]&oZb)!=0;};$Xb.Vr=function Vr(a,b){return (a.b[b]&oZb)!=0;};$Xb.Wr=function Wr(a,b,c){var d,e;e=_Xb.Xi(a.i,b);for(d=0;d<e.length;d++)if(c==e[d])return true;return false;};$Xb.Xr=function Xr(a,b,c){var d,e;e=_Xb.Xi(a.j,b);for(d=0;d<e.length;d++)if(c==e[d])return true;return false;};$Xb.Yr=function Yr(a,b){return a.e[b];};$Xb.Zr=function Zr(a,b){return (a.b[b]&T$b)!=0;};$Xb.$r=function $r(a,b){return (a.a[b]&G$b)!=0;};$Xb._r=function _r(a,b){var c,d,e,f,g,h;for(g=0;g<2;g++){c=$Xb.Vk(a.g,g,b);if($Xb.Qk(a.g,c)==7&&$Xb.Sn(a.g,c)==2){d=$Xb.Vk(a.g,1-g,b);if($Xb.Qk(a.g,d)==6){for(h=0;h<$Xb.Sn(a.g,d);h++){e=$Xb.Rn(a.g,d,h);f=$Xb.Tn(a.g,d,h);if(($Xb.Qk(a.g,e)==8||$Xb.Qk(a.g,e)==16)&&$Xb.bl(a.g,f)==2&&$Xb.Sn(a.g,e)==1)return true;}}}}return false;};$Xb.as=function as(a,b){var c,d,e,f,g;if(a.g.K){if(cxb(Jwb($Xb.Lk(a.g,b),1),0)){return true;}else {g=$Xb.Gk(a.g,b);if(g!=null){for(d=g,e=0,f=d.length;e<f;++e){c=d[e];if(c==5||c==6||c==7||c==8||c==15||c==16||c==33||c==34)return true;}return false;}}}return $Xb.is($Xb.Qk(a.g,b));};$Xb.bs=function bs(a,b){var c,d,e,f,g;if(a.g.K){if(cxb(Jwb($Xb.Lk(a.g,b),1),0))return false;c=$Xb.Gk(a.g,b);if(c!=null){for(e=c,f=0,g=e.length;f<g;++f){d=e[f];if(!$Xb.jn(d))return false;}return true;}}return $Xb.jn($Xb.Qk(a.g,b));};$Xb.cs=function cs(a,b){return $Xb.bl(a.g,b)>1||$Xb.el(a.g,b)==64;};$Xb.ds=function ds(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q;for(q=0;q<a.d.length;q++){if(a.d[q]){p=false;for(d=_Xb.Xi(a.i,q),f=0,h=d.length;f<h;++f){b=d[f];a.a[b]|=oZb;$Xb.bs(a,b)&&(p=true);}for(k=_Xb.Xi(a.j,q),m=0,o=k.length;m<o;++m){i=k[m];a.b[i]|=oZb;}if(a.e[q]){for(c=_Xb.Xi(a.i,q),e=0,g=c.length;e<g;++e){b=c[e];a.a[b]|=T$b;}for(j=_Xb.Xi(a.j,q),l=0,n=j.length;l<n;++l){i=j[l];a.b[i]|=T$b;}}if(p){for(c=_Xb.Xi(a.i,q),e=0,g=c.length;e<g;++e){b=c[e];a.a[b]|=G$b;}for(j=_Xb.Xi(a.j,q),l=0,n=j.length;l<n;++l){i=j[l];a.b[i]|=G$b;}}}}};$Xb.es=function es(a,b,c){var d,e,f,g;g=b.length;for(f=0;f<g;f++){d=a.a[b[f]]&pZb;if(d==0||d>g){a.a[b[f]]&=I$b;a.a[b[f]]|=g;}}for(e=0;e<g;e++){d=a.b[c[e]]&pZb;if(d==0||d>g){a.b[c[e]]&=I$b;a.b[c[e]]|=g;}}};$Xb.fs=function fs(a,b,c){var d;d=_Xb.Xi(a.j,b).length;while(c>=d)c-=d;while(c<0)c+=d;return c;};$Xb.gs=function gs(a,b){$Xb.hs.call(this,a,b);};$Xb.hs=function hs(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s;this.g=a;this.f=7;this.i=new _Xb.kj();this.j=new _Xb.kj();this.a=Sjb(UXb.llb,yZb,6,this.g.f,15,1);this.b=Sjb(UXb.llb,yZb,6,this.g.g,15,1);this.g.Mb(1);m=Sjb(UXb.Cwb,KZb,6,this.g.f,16,1);n=Sjb(UXb.Cwb,KZb,6,this.g.g,16,1);do{g=false;for(c=0;c<this.g.f;c++){if(!m[c]){q=0;for(l=0;l<$Xb.Sn(this.g,c);l++)m[$Xb.Rn(this.g,c,l)]||++q;if(q<2){m[c]=true;for(k=0;k<$Xb.Sn(this.g,c);k++)n[$Xb.Tn(this.g,c,k)]=true;g=true;}}}}while(g);s=0;while(s<this.g.f&&m[s])++s;if(s==this.g.f)return;i=Sjb(UXb.llb,yZb,6,this.g.f,15,1);i[0]=s;p=Sjb(UXb.llb,yZb,6,this.g.f,15,1);p[0]=-1;h=Sjb(UXb.llb,yZb,6,this.g.f,15,1);h[s]=1;f=0;j=0;o=1;while(f<=j){for(k=0;k<$Xb.Sn(this.g,i[f]);k++){e=$Xb.Rn(this.g,i[f],k);if(e==p[i[f]])continue;if(h[e]!=0){$Xb.Er(this,$Xb.Tn(this.g,i[f],k),m);continue;}if(!m[e]){h[e]=o;p[e]=i[f];i[++j]=e;}}++f;if(f>j){for(c=0;c<this.g.f;c++){if(h[c]==0&&!m[c]){h[c]=++o;i[++j]=c;p[c]=-1;break;}}}}if((b&4)!=0){this.d=Sjb(UXb.Cwb,KZb,6,this.i.a.length,16,1);this.e=Sjb(UXb.Cwb,KZb,6,this.i.a.length,16,1);this.c=Sjb(UXb.llb,yZb,6,this.i.a.length,15,1);$Xb.Gr(this,this.d,this.e,this.c,(b&8)!=0);$Xb.ds(this);}if((b&2)!=0){for(d=0;d<this.g.g;d++){if(!n[d]&&$Xb.bl(this.g,d)!=0){r=$Xb.Hr(this,d,m);r!=null&&$Xb.es(this,r,$Xb.Pr(this,r));}}}};$Xb.is=function is(a){return a==5||a==6||a==7||a==8||a==15||a==16||a==33||a==34;};xxb(169,1,{},$Xb.gs);_.f=0;UXb.Vlb=VFb(169);$Xb.js=function js(a,b){var c,d,e,f,g,h,i,j,k,l,m;if(b==2||b==5){_Xb.Si(a.D,$Xb.Os(a.F,a.F.length));!!a.b&&_Xb.Si(a.a,$Xb.Ps(a.B,a.B.length));}else if(b==4){m=$Xb.vs($Xb.Os(a.F,a.F.length));if(!_Xb.aSb(a.N,m)){_Xb.$Rb(a.N,m);_Xb.Si(a.D,$Xb.Os(a.F,a.F.length));!!a.b&&_Xb.Si(a.a,$Xb.Ps(a.B,a.B.length));}}else if(b==3){m=$Xb.vs($Xb.Os(a.F,a.F.length));if(!_Xb.aSb(a.N,m)){l=false;for(j=(h=new _Xb.yRb(new _Xb.DRb(new _Xb.zNb(a.N.a).a).b),new _Xb.HNb(h));_Xb.hMb(j.a.a);){i=(g=_Xb.wRb(j.a),g.Wd());k=0;for(d=m,e=0,f=d.length;e<f;++e){c=d[e];while(k<i.length&&i[k]<c)++k;if(k<i.length){if(c==i[k]){l=true;break;}}}if(l)break;}if(!l){_Xb.$Rb(a.N,m);_Xb.Si(a.D,$Xb.Os(a.F,a.F.length));!!a.b&&_Xb.Si(a.a,$Xb.Ps(a.B,a.B.length));}}}else if(b==6){m=$Xb.ws(a,$Xb.Os(a.F,a.F.length));if(!_Xb.aSb(a.N,m)){_Xb.$Rb(a.N,m);_Xb.Si(a.D,$Xb.Os(a.F,a.F.length));!!a.b&&_Xb.Si(a.a,$Xb.Ps(a.B,a.B.length));}}};$Xb.ks=function ks(a,b,c){var d,e,f,g,h,i,j,k,l,m;h=$Xb.Sn(a.G,b);d=a.n[c];if(d>h)return false;j=$Xb.Lk(a.G,b);f=$Xb.Lk(a.g,c);e=$Xb.Gk(a.g,c);i=$Xb.Gk(a.G,b);if(cxb(Jwb(f,1),0)){if(e!=null){if(cxb(Jwb(j,1),0)){if(i==null)return false;if(!$Xb.Bs(e,i))return false;}else {if(i!=null){if($Xb.Ds(i,e))return false;}else {if($Xb.As($Xb.Qk(a.G,b),e))return false;}}}}else {if(cxb(Jwb(j,1),0))return false;if(e!=null){if(i!=null){if(!$Xb.Bs(i,e))return false;}else {if(!$Xb.As($Xb.Qk(a.G,b),e))return false;}}else {if(i!=null)return false;if(a.I[b]!=a.j[c])return false;}}if(cxb(exb(j,f),0)){if(cxb(Jwb(f,x$b),0)){if(a.G.K&&Twb(Jwb(j,x$b),0))return false;else if(d!=h)return false;}if(cxb(Jwb(f,SZb),0)){if(d>=h&&Twb(Jwb(j,SZb),0))return false;}}if(cxb(Jwb(a.H[b],dxb(a.i[c])),0))return false;if(cxb(Jwb(a.A[c],dxb(a.L[b])),0))return false;g=Jwb(f,CZb);if(a.G.K){k=Jwb(f,CZb);if(Owb(k,0)!=0&&(Owb(g,0)==0||cxb(Jwb(g,dxb(k)),0)))return false;}else {if(Owb(g,0)!=0&&Twb(Jwb(g,a.L[b]),0))return false;}if($Xb.zk(a.g,c)!=0&&$Xb.zk(a.g,c)!=$Xb.zk(a.G,b))return false;if($Xb.Jk(a.g,c)!=0&&$Xb.Jk(a.g,c)!=$Xb.Jk(a.G,b))return false;if($Xb.Mk(a.g,c)!=0&&$Xb.Mk(a.g,c)!=$Xb.Mk(a.G,b))return false;l=lxb(gxb(Jwb($Xb.Lk(a.g,c),u$b),22));if(l!=0){if(a.G.K){m=lxb(gxb(Jwb($Xb.Lk(a.G,b),u$b),22));if(l!=m)return false;}else {if($Xb.Mn(a.G,b)!=l)return false;}}return true;};$Xb.ls=function ls(a,b,c){var d,e,f,g,h,i,j,k,l;j=a.J[b];g=a.k[c];if(($Xb.dl(a.g,c)&Z$b)!=0){i=$Xb.fl(a.G,b);e=$Xb.fl(a.g,c);f=$Xb.dl(a.g,c)&31;if(i!=e&&!(i==1&&(f&1)!=0)&&!(i==2&&(f&2)!=0)&&!(i==4&&(f&4)!=0)&&!(i==8&&(f&32)!=0)&&!(i==16&&(f&64)!=0)&&!(i==32&&(f&16)!=0)&&!(i==64&&(f&8)!=0))return false;j&=-32;g&=-32;}if((j&~g)!=0)return false;l=($Xb.dl(a.g,c)&i$b)>>17;if(l!=0){if(a.G.K&&l==($Xb.dl(a.G,c)&i$b)>>17)return true;d=false;k=$Xb.so(a.G);for(h=0;h<k.i.a.length;h++){if(_Xb.Xi(k.j,h).length==l){if($Xb.Xr(k,h,b)){d=true;break;}}}if(!d)return false;}return true;};$Xb.ms=function ms(a){var b,c;a.b=null;for(b=0;b<a.g.g;b++){if($Xb.xl(a.g,b)){!a.b&&(a.b=new _Xb.kj());c=new $Xb.Qs();c.a=$Xb.Vk(a.g,0,b);c.b=$Xb.Vk(a.g,1,b);c.d=$Xb.Xk(a.g,b);c.c=$Xb.Wk(a.g,b);_Xb.Si(a.b,c);}}};$Xb.ns=function ns(a){var b,c,d,e,f,g,h,i,j,k,l,m;$Xb.nu(a.g,a.M);i=$wnd.Math.max(a.g.f,a.g.g)+16;a.r=Sjb(UXb.llb,yZb,6,i,15,1);a.t=Sjb(UXb.llb,yZb,6,i,15,1);a.u=Sjb(UXb.llb,yZb,6,i,15,1);a.s=Sjb(UXb.Cwb,KZb,6,i+1,16,1);g=Sjb(UXb.Cwb,KZb,6,a.g.f,16,1);h=Sjb(UXb.Cwb,KZb,6,a.g.g,16,1);d=0;for(c=0;c<a.g.f;c++){if(!a.C[c]&&!g[c]){a.r[d]=c;a.u[d]=-1;a.t[d]=-1;j=d;while(d<=j){for(k=0;k<$Xb.En(a.g,a.r[d]);k++)j=$Xb.Ls(a,d,j,k,g,h,-1);while(a.s[++d]);}}}a.v=d;if(a.o!=0){j=a.v-1;for(f=0;f<a.d;f++){d=0;while(d<=j){for(l=0;l<$Xb.En(a.g,a.r[d]);l++)j=$Xb.Ls(a,d,j,l,g,h,f);while(a.s[++d]);}}for(b=0;b<a.g.f;b++){if(a.C[b]&&!g[b]){a.r[d]=b;a.u[d]=-1;a.t[d]=-1;j=d;while(d<=j){for(l=0;l<$Xb.En(a.g,a.r[d]);l++)$Xb.Rn(a.g,a.r[d],l)<a.g.f&&(j=$Xb.Ls(a,d,j,l,g,h,a.f[b]));while(a.s[++d]);}}}a.e=Sjb(UXb.llb,yZb,6,a.d,15,1);for(m=0;m<a.d;m++)a.e[m]=-1;for(k=a.v;k<d;k++){e=a.f[a.r[k]];a.e[e]==-1&&(a.e[e]=k);}}a.w=d;};$Xb.os=function os(a,b){var c,d,e,f,g,h,i,j;j=$Xb.so(a.G);for(h=0;h<j.i.a.length;h++){if($Xb.Xr(j,h,b)){i=Sjb(UXb.llb,yZb,6,2,15,1);for(e=0;e<2;e++){i[e]=gZb;d=$Xb.Vk(a.G,e,b);for(f=0;f<$Xb.Sn(a.G,d);f++){c=$Xb.Rn(a.G,d,f);c!=$Xb.Vk(a.G,1-e,b)&&i[e]>c&&(i[e]=c);}}g=0;$Xb.Wr(j,h,i[0])&&++g;$Xb.Wr(j,h,i[1])&&++g;if(g==2)return 2;if(g==1)return 1;return 2;}}return 0;};$Xb.ps=function ps(a,b,c){var d,e,f,g,h;if(a.b){a.B=Sjb(UXb.Cwb,KZb,6,b.length,16,1);for(e=new _Xb.rOb(a.b);e.a<e.c.a.length;){d=_Xb.qOb(e);if(a.f==null||c==-1&&a.f[d.a]==-1&&a.f[d.b]==-1||c!=-1&&(a.f[d.a]==c||a.f[d.b]==c)){h=Sjb(UXb.llb,yZb,6,d.c+2,15,1);f=$Xb.mo(a.G,h,a.F[d.a],a.F[d.b],d.c+1,b,null)-1;if(f<d.d||f>d.c)return false;for(g=1;g<=f;g++)a.B[h[g]]=true;}}}return true;};$Xb.qs=function qs(a,b){var c,d,e,f,g,h,i,j;for(e=0;e<a.g.g;e++){if(($Xb.dl(a.g,e)&W$b)!=0){f=$Xb.cl(a.g,e);if(f==0)continue;c=$Xb.Vk(a.g,0,e);d=$Xb.Vk(a.g,1,e);if(a.f==null||b==-1&&a.f[c]==-1&&a.f[d]==-1||b!=-1&&(a.f[c]==b||a.f[d]==b)){g=a.F[c];h=a.F[d];i=$Xb.Pn(a.G,g,h);j=$Xb.cl(a.G,i);if(j==0){$Xb.Yo(a.G,i)&&(j=$Xb.os(a,i));if(j==0)continue;}if(f==3)continue;if(j==3)continue;if($Xb.xs(a,e)==(f==j))return false;}}}return true;};$Xb.rs=function rs(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p;g=0;for(i=0;i<a.g.f;i++){if((a.f==null||a.f[i]==b)&&cxb(Jwb($Xb.Lk(a.g,i),w$b),0)){m=a.F[i];l=$Xb.Kk(a.g,i);o=$Xb.Kk(a.G,m);if(l==0)continue;if(l==3)continue;if(o==0||o==3)return false;if($Xb.Ek(a.g,i)==1){++g;continue;}if($Xb.Ek(a.G,m)==1)return false;if($Xb.Ek(a.g,i)==2){++g;continue;}if($Xb.Ek(a.G,m)==2)return false;if($Xb.Cs(a,i)==(l==o))return false;}}if(g!=0){e=Sjb(UXb.llb,yZb,6,g,15,1);f=0;for(j=0;j<a.g.f;j++){if((a.f==null||a.f[j]==b)&&cxb(Jwb($Xb.Lk(a.g,j),w$b),0)){l=$Xb.Kk(a.g,j);l!=0&&l!=3&&(e[f++]=$Xb.Dk(a.g,j)<<24|$Xb.Ek(a.g,j)<<22|j);}}YXb.fTb(e,YXb.LTb(Axb(_Xb.ZOb.prototype.Zd,_Xb.ZOb,[])));f=0;while(f<e.length){k=e[f]&q_b;n=a.F[k];c=e[f]&-4194304;d=$Xb.Cs(a,k)^$Xb.Kk(a.g,k)==$Xb.Kk(a.G,n);for(++f;f<e.length&&(e[f]&-4194304)==c;f++){h=e[f]&q_b;m=a.F[h];if($Xb.Ek(a.G,m)!=$Xb.Ek(a.G,n)||$Xb.Dk(a.G,m)!=$Xb.Dk(a.G,n))return false;p=$Xb.Cs(a,h)^$Xb.Kk(a.g,h)==$Xb.Kk(a.G,m);if(p!=d)return false;}}}return true;};$Xb.ss=function ss(a,b,c){var d,e,f,g,h,i,j;a.O=false;a.D=new _Xb.kj();a.a=new _Xb.kj();_Xb._Qb(a.N.a);if(!a.G||!a.g)return 0;if(a.g.f-a.o>a.G.f||a.g.g-a.p>a.G.g)return 0;if(a.g.f==0)return 0;b==6&&(a.M=63);$Xb.Hs(a,c);d=Sjb(UXb.Cwb,KZb,6,a.G.f,16,1);a.F=Sjb(UXb.llb,yZb,6,a.g.f,15,1);_Xb.BOb(a.F);h=Sjb(UXb.llb,yZb,6,a.w,15,1);_Xb.GOb(h,h.length,-1);f=0;while(!a.O){if(a.v!=0){j=a.t[f]==-1?a.G.f:$Xb.En(a.G,a.F[a.t[f]]);++h[f];if(h[f]==j){h[f]=-1;if(f==0)break;--f;a.s[f]||(d[a.F[a.r[f]]]=false);continue;}if(a.t[f]==-1){if(!d[h[f]]){if($Xb.ks(a,h[f],a.r[f])){a.F[a.r[f]]=h[f];d[h[f]]=true;++f;}}}else {if($Xb.Rn(a.G,a.F[a.t[f]],h[f])>=a.G.f)continue;e=$Xb.Rn(a.G,a.F[a.t[f]],h[f]);if(a.s[f]){e==a.F[a.r[f]]&&$Xb.ls(a,$Xb.Tn(a.G,a.F[a.t[f]],h[f]),a.u[f])&&++f;}else {if(!d[e]){if($Xb.ks(a,e,a.r[f])&&$Xb.ls(a,$Xb.Tn(a.G,a.F[a.t[f]],h[f]),a.u[f])){d[e]=true;a.F[a.r[f]]=e;++f;}}}}}if(f==a.v){if($Xb.rs(a,-1)&&$Xb.qs(a,-1)&&$Xb.ps(a,d,-1)){i=false;for(g=0;g<a.d;g++){if($Xb.ys(a,d,h,g)){i=true;break;}}if(b==1&&!i)return 1;if(!i){$Xb.js(a,b);if(b==2)return 1;}}if(f==0)break;--f;a.s[f]||(d[a.F[a.r[f]]]=false);}}return a.D.a.length;};$Xb.ts=function ts(a,b){var c,d,e,f,g,h,i,j;i=0;if(a.K){b<a.f&&$Xb.$r(a.p,b)?i=exb(i,N_b):b<a.f&&$Xb.Ur(a.p,b)&&(i=exb(i,2));j=(e=a.u[b]&r_b,e==0?0:e==XZb?2:e==x$b?3:4);if(j!=0){i=exb(i,8);j>2&&(i=exb(i,16));j>3&&(i=exb(i,32));}c=a.s[b];c<0?i=exb(i,_Zb):c>0&&(i=exb(i,$Zb));g=a.j[b];switch(g){case 0:break;case 1:i=exb(i,T$b);break;case 2:i=exb(i,h$b);break;case 3:i=exb(i,i$b);break;default:i=exb(i,j$b);}d=$Xb.Hn(a,b);switch(d){case 0:break;case 1:i=exb(i,q$b);break;case 2:i=exb(i,r$b);break;case 3:i=exb(i,s$b);break;default:i=exb(i,t$b);}h=a.o[b];h>0&&(i=exb(i,RZb));h>1&&(i=exb(i,m_b));}else {b<a.f&&$Xb.$r(a.p,b)?i=exb(i,N_b):b<a.f&&$Xb.Ur(a.p,b)?i=exb(i,2):i=exb(i,4);(a.u[b]&l_b)!=0?i=exb(i,TZb):i=exb(i,UZb);j=(e=a.u[b]&r_b,e==0?0:e==XZb?2:e==x$b?3:4);j==0?i=exb(i,112):j==2?i=exb(i,104):j==3?i=exb(i,88):i=exb(i,56);c=a.s[b];c==0?i=exb(i,ZZb):c<0?i=exb(i,_Zb):c>0&&(i=exb(i,$Zb));f=a.e[b]-$Xb.jo(a,b)+$Xb.fo(a,b);switch(f){case 0:i=exb(i,1792);break;case 1:i=exb(i,1664);break;case 2:i=exb(i,1408);break;default:i=exb(i,896);}g=a.j[b];switch(g){case 0:i=exb(i,3932160);break;case 1:i=exb(i,c$b);break;case 2:i=exb(i,d$b);break;case 3:i=exb(i,e$b);break;default:i=exb(i,j$b);}d=$Xb.Hn(a,b);switch(d){case 0:i=exb(i,l$b);break;case 1:i=exb(i,m$b);break;case 2:i=exb(i,n$b);break;case 3:i=exb(i,o$b);break;default:i=exb(i,t$b);}h=a.o[b];switch(h){case 0:i=exb(i,98304);break;case 1:i=exb(i,81920);break;default:i=exb(i,49152);}}return i;};$Xb.us=function us(a,b){var c;c=0;if(b<a.g&&($Xb.Zr(a.p,b)||a.H[b]==64)||a.H[b]==64)c|=8;else switch($Xb.bl(a,b)){case 4:case 0:c|=32;break;case 1:c|=1;break;case 2:c|=2;break;case 3:c|=4;break;case 5:c|=64;}(a.F[b]&64)!=0?c|=256:a.K||(c|=128);b<a.g&&$Xb.Vr(a.p,b)?c|=g$b:a.K||(c|=O_b);return c;};$Xb.vs=function vs(a){var b,c,d,e,f,g,h,i,j,k;i=0;for(d=a,f=0,h=d.length;f<h;++f){b=d[f];b==-1&&++i;}if(i!=0){k=a;a=Sjb(UXb.llb,yZb,6,k.length-i,15,1);j=0;for(c=k,e=0,g=c.length;e<g;++e){b=c[e];b!=-1&&(a[j++]=b);}}YXb.fTb(a,YXb.LTb(Axb(_Xb.ZOb.prototype.Zd,_Xb.ZOb,[])));return a;};$Xb.ws=function ws(a,b){var c,d,e,f,g,h,i,j;g=0;for(d=b,e=0,f=d.length;e<f;++e){c=d[e];c==-1&&++g;}j=Sjb(UXb.llb,yZb,6,b.length-g,15,1);i=0;for(h=0;h<b.length;h++){if(b[h]!=-1){j[i]=$Xb.yu(a.g,h)<<16|$Xb.yu(a.G,b[h]);++i;}}YXb.fTb(j,YXb.LTb(Axb(_Xb.ZOb.prototype.Zd,_Xb.ZOb,[])));return j;};$Xb.xs=function xs(a,b){var c,d,e,f,g,h,i,j,k,l,m,n;f=false;for(e=0;e<2;e++){c=$Xb.Vk(a.g,e,b);k=a.F[c];if($Xb.Sn(a.G,k)>2){m=$Xb.Vk(a.g,1-e,b);i=gZb;for(h=0;h<$Xb.Sn(a.g,c);h++){d=$Xb.Rn(a.g,c,h);d!=m&&i>d&&(i=d);}n=a.F[m];j=gZb;for(g=0;g<$Xb.Sn(a.G,k);g++){l=$Xb.Rn(a.G,k,g);l!=n&&j>l&&(j=l);}a.F[i]!=j&&(f=!f);}}return f;};$Xb.ys=function ys(a,b,c,d){var e,f,g,h,i,j,k,l;h=a.e[d];i=h+1;while(i<a.w&&a.f[a.r[i]]==d)++i;for(k=h;k<i;k++)c[k]=-1;g=h;while(true){l=a.t[g]==-1?a.G.f:$Xb.En(a.G,a.F[a.t[g]]);++c[g];if(c[g]==l){c[g]=-1;if(g==h)break;--g;if(!a.s[g]){b[a.F[a.r[g]]]=false;a.F[a.r[g]]=-1;}continue;}if(a.t[g]==-1){if(!b[c[g]]){if($Xb.ks(a,c[g],a.r[g])){a.F[a.r[g]]=c[g];b[c[g]]=true;++g;}}}else {if($Xb.Rn(a.G,a.F[a.t[g]],c[g])>=a.G.f){++c[g];continue;}f=$Xb.Rn(a.G,a.F[a.t[g]],c[g]);if(a.s[g]){f==a.F[a.r[g]]&&$Xb.ls(a,$Xb.Tn(a.G,a.F[a.t[g]],c[g]),a.u[g])&&++g;}else {if(!b[f]){if($Xb.ks(a,f,a.r[g])&&$Xb.ls(a,$Xb.Tn(a.G,a.F[a.t[g]],c[g]),a.u[g])){b[f]=true;a.F[a.r[g]]=f;++g;}}}}if(g==i){if($Xb.rs(a,d)&&$Xb.qs(a,d)&&$Xb.ps(a,b,d)){for(j=h;j<i;j++){if(!a.s[j]){e=a.r[j];b[a.F[e]]=false;a.F[e]=-1;}}return true;}--g;if(!a.s[g]){b[a.F[a.r[g]]]=false;a.F[a.r[g]]=-1;}}}return false;};$Xb.zs=function zs(a){return $Xb.ss(a,1,a.c)>0;};$Xb.As=function As(a,b){var c;for(c=0;c<b.length;c++)if(b[c]==a)return true;return false;};$Xb.Bs=function Bs(a,b){var c,d,e;e=0;for(d=0;d<a.length;d++){c=a[d];while(b[e]<c){++e;if(e==b.length)return false;}if(b[e]>c)return false;}return true;};$Xb.Cs=function Cs(a,b){var c,d,e,f,g,h,i,j;g=false;if($Xb.In(a.g,b)==0){for(f=1;f<$Xb.Sn(a.g,b);f++){for(h=0;h<f;h++){d=$Xb.Rn(a.g,b,f);e=$Xb.Rn(a.g,b,h);a.F[d]>a.F[e]^d>e&&(g=!g);}}}else {for(f=0;f<$Xb.Sn(a.g,b);f++){c=$Xb.Rn(a.g,b,f);j=0;i=Sjb(UXb.llb,yZb,6,3,15,1);for(h=0;h<$Xb.Sn(a.g,c);h++){i[j]=$Xb.Rn(a.g,c,h);i[j]!=b&&++j;}j==2&&a.F[i[0]]>a.F[i[1]]^i[0]>i[1]&&(g=!g);}}return g;};$Xb.Ds=function Ds(a,b){var c,d,e,f;e=0;f=0;while(e<a.length&&f<b.length){c=a[e];d=b[f];if(c==d)return true;c<d?++e:++f;}return false;};$Xb.Es=function Es(a,b){var c,d,e,f,g;if(!b||b.q==0||!b.K){a.g=null;return;}a.g=b;a.q=false;$Xb.nu(a.g,1);a.M=7;for(d=0;d<a.g.f;d++)cxb(Jwb($Xb.Lk(a.g,d),{l:w$b,m:0,h:3}),0)&&(a.M=15);for(g=0;g<a.g.g;g++)($Xb.dl(a.g,g)&W$b)!=0&&(a.M=15);a.K&&a.M!=7&&$Xb.nu(a.G,a.M);a.o=0;a.p=0;a.C=Sjb(UXb.Cwb,KZb,6,a.g.f,16,1);for(e=0;e<a.g.f;e++){a.C[e]=cxb(Jwb($Xb.Lk(a.g,e),LZb),0);a.C[e]&&++a.o;}a.d=0;a.f=null;if(a.o!=0){if(a.o!=0)for(f=0;f<a.g.g;f++)(a.C[$Xb.Vk(a.g,0,f)]||a.C[$Xb.Vk(a.g,1,f)])&&++a.p;for(c=0;c<a.g.q;c++)$Xb.lm(a.g,c,a.C[c]);a.f=Sjb(UXb.llb,yZb,6,a.g.q,15,1);a.d=$Xb.$n(a.g,a.f,true,false);}};$Xb.Fs=function Fs(a,b,c){$Xb.Gs(a,c);$Xb.Es(a,b);};$Xb.Gs=function Gs(a,b){if(!b||b.q==0){a.G=null;return;}a.G=b;a.K=false;$Xb.nu(a.G,1);};$Xb.Hs=function Hs(a,b){if(!a.K){$Xb.Ks(a,b);a.K=true;}if(!a.q){$Xb.Is(a,b);$Xb.ns(a);$Xb.ms(a);a.q=true;}};$Xb.Is=function Is(a,b){var c,d,e,f,g,h,i,j,k,l;f=null;i=null;g=null;$Xb.nu(a.g,a.M);a.n=Sjb(UXb.llb,yZb,6,a.g.f,15,1);for(d=0;d<a.g.f;d++)a.n[d]=$Xb.Sn(a.g,d);if(a.o!=0){j=new $Xb.Gu(a.g.q,a.g.r);l=Sjb(UXb.Cwb,KZb,6,a.g.q,16,1);for(e=0;e<a.g.q;e++)l[e]=!a.C[e];$Xb.un(a.g,j,l,true,null);$Xb.nu(j,a.M);$Xb.Js(a,j,b);f=a.i;i=a.k;g=a.j;k=0;for(c=0;c<a.g.f;c++)a.C[c]||(a.n[c]=$Xb.Sn(j,k++));}$Xb.Js(a,a.g,b);if(a.o!=0){k=0;for(c=0;c<a.g.q;c++){if(!a.C[c]){a.i[c]=f[k];a.j[c]=g[k++];}}k=0;for(h=0;h<a.g.r;h++){!a.C[$Xb.Vk(a.g,0,h)]&&!a.C[$Xb.Vk(a.g,1,h)]&&(a.k[h]=i[k++]);}}};$Xb.Js=function Js(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s;p=b.f;a.i=Sjb(UXb.mlb,N$b,6,b.f,14,1);a.j=Sjb(UXb.llb,yZb,6,b.f,15,1);for(h=0;h<p;h++){a.i[h]=nxb(Jwb(exb($Xb.ts(b,h),b.B[h]),P_b),Q_b);a.j[h]=b.C[h];(c&1)!=0&&(a.j[h]+=b.s[h]+16<<8);(c&2)!=0&&(a.j[h]+=b.A[h]<<16);}a.A=Sjb(UXb.mlb,N$b,6,b.f,14,1);r=($Xb.nu(b,7),b.p);for(o=0;o<r.i.a.length;o++){n=false;for(j=_Xb.Xi(r.j,o),k=0,l=j.length;k<l;++k){m=j[k];if((b.G[m]&z$b)!=0){n=true;break;}}if(!n){s=_Xb.Xi(r.j,o).length;for(e=_Xb.Xi(r.i,o),f=0,g=e.length;f<g;++f){d=e[f];s==3?a.A[d]=exb(a.A[d],EZb):s==4?a.A[d]=exb(a.A[d],FZb):s==5?a.A[d]=exb(a.A[d],GZb):s==6?a.A[d]=exb(a.A[d],HZb):s==7&&(a.A[d]=exb(a.A[d],IZb));}}}q=b.g;a.k=Sjb(UXb.llb,yZb,6,b.g,15,1);for(i=0;i<q;i++){a.k[i]=($Xb.us(b,i)|b.G[i])&6291967^6291840;(c&4)!=0?(a.k[i]&2)!=0&&(a.k[i]|=8):(c&8)!=0&&(a.k[i]&2)!=0&&i<b.g&&$Xb.Vr(b.p,i)&&(a.k[i]|=8);}};$Xb.Ks=function Ks(a,b){var c,d,e,f,g,h,i,j,k,l,m,n;$Xb.nu(a.G,a.M);k=a.G.f;a.I=Sjb(UXb.llb,yZb,6,k,15,1);a.H=Sjb(UXb.mlb,N$b,6,k,14,1);for(g=0;g<k;g++){a.H[g]=nxb(Jwb(exb($Xb.ts(a.G,g),$Xb.Lk(a.G,g)),P_b),Q_b);a.I[g]=$Xb.Qk(a.G,g);(b&1)!=0&&(a.I[g]+=$Xb.zk(a.G,g)+16<<8);(b&2)!=0&&(a.I[g]+=$Xb.Jk(a.G,g)<<16);}a.L=Sjb(UXb.mlb,N$b,6,k,14,1);m=$Xb.so(a.G);for(j=0;j<m.i.a.length;j++){n=_Xb.Xi(m.j,j).length;for(d=_Xb.Xi(m.i,j),e=0,f=d.length;e<f;++e){h=d[e];n==3?a.L[h]=exb(a.L[h],EZb):n==4?a.L[h]=exb(a.L[h],FZb):n==5?a.L[h]=exb(a.L[h],GZb):n==6?a.L[h]=exb(a.L[h],HZb):n==7&&(a.L[h]=exb(a.L[h],IZb));}}for(c=0;c<k;c++){n=$Xb.Mn(a.G,c);n==0?a.L[c]=exb(a.L[c],DZb):n>7&&(a.L[c]=exb(a.L[c],JZb));}l=a.G.g;a.J=Sjb(UXb.llb,yZb,6,l,15,1);for(i=0;i<l;i++)a.J[i]=($Xb.us(a.G,i)|$Xb.dl(a.G,i))&6422527^6291840;};$Xb.Ls=function Ls(a,b,c,d,e,f,g){var h,i;h=$Xb.Rn(a.g,a.r[b],d);if((!a.C[h]||a.f[h]==g)&&h!=a.t[b]){i=$Xb.Tn(a.g,a.r[b],d);if(!f[i]&&!$Xb.xl(a.g,i)){a.r[++c]=h;a.t[c]=a.r[b];a.u[c]=i;f[i]=true;e[h]?a.s[c]=true:e[h]=true;}}return c;};$Xb.Ms=function Ms(){this.c=8;this.N=new _Xb.eSb(new yYb.w6());};$Xb.Ns=function Ns(){this.c=1;this.N=new _Xb.eSb(new yYb.w6());};$Xb.Os=function Os(a,b){var c;c=Sjb(UXb.llb,yZb,6,b,15,1);VXb.pIb(a,0,c,0,$wnd.Math.min(a.length,b));return c;};$Xb.Ps=function Ps(a,b){var c;c=Sjb(UXb.Cwb,KZb,6,b,16,1);VXb.pIb(a,0,c,0,$wnd.Math.min(a.length,b));return c;};xxb(91,1,{},$Xb.Ms,$Xb.Ns);_.c=0;_.d=0;_.o=0;_.p=0;_.q=false;_.v=0;_.w=0;_.K=false;_.M=0;_.O=false;UXb.Ylb=VFb(91);$Xb.Qs=function Qs(){};xxb(249,1,{249:1},$Xb.Qs);_.a=0;_.b=0;_.c=0;_.d=0;UXb.Wlb=VFb(249);$Xb.Ts=function Ts(){$Xb.Ts=zxb;$Xb.Rs=$jb(Mjb(UXb.Oub,1),nZb,2,6,['QM@HzAmdqjF@','RF@Q``','qC`@ISTAlQE`','`J@H','QM@HzAmdqbF@','qC`@ISTAlQEhqPp@','sJP@DiZhAmQEb','RF@QPvR@','QM@HzA@','qC`@ISTAlQEhpPp@','qC`@Qz`MbHl','sJP@DiZhAmQEcFZF@','RFPDXH','qC`@IVtAlQE`','QM@HvAmdqfF@','sGP@DiVj`FsDVM@','`L@H','sJP@DizhAmQEcFBF@','sJP@DjvhAmQEb','sFp@DiTt@@AlqEcP','sGP@LdbMU@MfHlZ','QMHAIhD','QM@HzAy@','sJP@DkVhAmQEb','sNp@DiUjj@[\\QXu`','sJP@DiZhAmQEcFBF@','sGP@DjVj`FsDVM@','RFPDTH','RG@DXOH@','sGP@Divj`FsDVMcAC@','sGP@Dj}j`FsDVM@','qC`@Qz`MbHmFRF@','sNp@LdbJjj@[\\QXu`','QMHAIhGe@','QM@HzAyd`','QM`AIhD','qC`@ISTA@','sGP@DkUj`FsDVM@','qC`@IVtAlQEhqPp@','sNp@DiUjj@[\\QXuqea`@','KAx@@IRjuUPAlHPfES\\','QM`BN`P','sJP@DjZhAmQEcFJF@','Hid@@DjU^nBBH@FtaBXUMp`','sNp@Diujj@[\\QXuq`a`@','sJP@DjvhAmQEcFZF@','sJP@DjZhAmQEcFFF@','sOp@DjWkB@@FwDVM\\YhX@','sNp@Dj}Zj@[\\QXu`','sNp@DiWjj@[\\QXuq`a`@','sOp@DjWkB@@D','KAx@@ITouUPAlHPfES\\','KAx@@YIDTjjh@vDHSBin@','sNp@DkUZj@[\\QXu`','RFPDXOH@','QM`BN`^L`','qC`@ISTAy@','sGP@LdbMU@MfHl[FVF@','qCb@AIZ`H','KAx@@IRjuUPAlHPfES]FFa`@','KAx@@ITnuUPAlHPfES\\','HiD@@DiUVjj`AmHPfES\\H','sNp@DjUjj@[\\QXu`','sJP@DkVhAmQEcFJF@','sGP@DjVj`FsDVMcCC@','qC`@Qz`MbHmFBF@','sJP@DkfhAmQEb','qC`@IVtAlQEhsPp@','sGP@Djuj`FsDVM@','sGP@Dj}j`FsDVMcMC@','sJP@DiZhA@','KAx@@ISjuUPAlHPfES]F@a`@','sJP@DjZhAmQEcFRF@','KAx@@IRnuUPAlHPfES]F@a`@','HiD@@DjWvjj`AmHPfES\\H','QMHAIhGd@','sNp@DiUjj@[\\QXuq`a`@','KAx@@IVjmUPAlHPfES\\','sGP@DjVj`FsDVMcMC@','QM`AIhGe@','HiD@@LdbJRjjh@[RDIaTwB','qCp@AIZ`H','sGP@LdbMU@MfHl[FFF@','QMDARVA@','sNp@LdbJjj@[\\QXuqba`@','sNp@LdbJjj@[\\QXuqca`@','sGP@Dkej`FsDVM@','qCb@AIZ`OI@','HaD@@DjUZxHH@AlHPfES]FLa`@','sGP@DkYj`FsDVM@','qCb@AIV`H','sNp@LdbJjj@[\\QXuqea`@','sGP@DkUj`FsDVMcEC@','sFp@DiTt@@Axa@','Hmt@@DjU_ZxHHj@AmhPfES\\Lj','QM`BN`^P','qCb@AIZ`OH`','sFp@DiTt@@AxaP','sGP@Djuj`FsDVMcEC@','sGP@Djuj`FsDVMcIC@','sGP@DkUj`FsDVMcKC@','sJP@DkfhAmQEcFRF@','sGP@DjVj`FsDVMcIC@','HaD@@DjUZxHH@AlHPfES]FFa`@','qC`@IRtDVqDV@','sNp@Dj}Zj@[\\QXuqfa`@','KAx@@ITnuUPAlHPfES]FFa`@','HiD@@DkUUjj`AmHPfES\\H','sJQ@@dkU@H','qC`@Qz`H','KAx@@IUkmUPAlHPfES\\','KAx@@ITouUPAlHPfES]FJa`@','sJP@H~j@[TQX`','sGP@DjZj`FsDVM@','sJP@DkVhAmQEcFFF@','sJX@@eKU@H','sJP@DizhAy@','QMHAIhGbP','KAx@@ITouUPAlHPfES]FNa`@','HaD@@DjUZxHD@AlHPfES\\','HaD@@DjUZxHH@A@','sNp@LdbJjj@[\\QXuqaa`@','Hed@@LdbRQUUUP@vTHSBinFP','KAx@@ITouUPAlHPfES]FLa`@','sNp@DkUZj@[\\QXuqba`@','KAx@@ITjuUPAlHPfES]FNa`@','KAx@@YIDTjjh@vDHSBincGPp@','HaD@@DjYvxH`@AlHPfES]FLa`@','RF@QP`','qCb@AIj`H','sNp@DjUjj@[\\QXuqaa`@','sNp@DkVZj@[\\QXu`','KAx@@YIDUJjh@vDHSBin@','sGP@DkYj`FsDVMcIC@','sGP@DjVj`FsDVMcAC@','sGP@DiVj`D','sJP@DkVhAmQEcFZF@','sNp@LdbLjj@[\\QXu`','QM@HvAmdqbF@','HaD@@DjWjXHB@AlHPfES\\','sNp@DjwZj@[\\QXuqba`@','sNp@LdbJjj@[\\QXuqda`@','sFp@DiTt@@Axa`','HiD@@Djuujj`AmHPfES\\H','sNp@DkUZj@[\\QXuqca`@','sJP@DiZhAy@','KAx@@YIDTjjh@vDHSBincCPp@','KAx@@IWNmUPAlHPfES\\','KAx@@IVkMUPAlHPfES\\','sJQ@@dju@H','qCb@AIZ`OH@','qC`@ISTAxa@','sNp@DjyZj@[\\QXu`','Hid@@DjUfaBB`@FtaBXUMp`','HiD@@DiUVjj`AmHPfES\\LXBF@','KAx@@IUjmUPAlHPfES\\','HiD@@DjWvjj`AmHPfES\\LXjF@','sJP@DjVhAmQEb','qCb@AIV`OH`','HiD@@LdbJRjjh@[RDIaTwCFDa`@','KAx@@YIDTjjh@vDHSBinc@Pp@','sNp@DjUjj@[\\QXuqda`@','qC`@Qz`OED','sJP@DkfhAmQEcFZF@','KAx@@YIDbjjh@vDHSBincDPp@','sGP@Djyj`FsDVMcMC@','KAx@@IVrmUPAlHPfES\\','qCp@AIZ`OI@','sJX@@dkU@H','sJQ@@dkU@OH`','sNp@Di]ZjBBvxbqk@','Hkl@@DjU_Uk``bj`@[VDIaTwCJzX','sGP@DjZj`FsDVMcEC@','Hid@@DjU^nBBH@FtaBXUMpqcHX@','sNp@DkeZj@[\\QXu`','sNp@DjYjj@[\\QXuqca`@','sGQ@@djuT@`','HiD@@LdbJTjjh@[RDIaTwB','sOp@DjWkB@@Gd`','HeT@@LdbbRKBDQD@CYPaLJfxY@','qCr@XIKTA@','HiD@@DjW^jj`AmHPfES\\LXJF@','HeT@@DjU]k``b`@[JDIaTwCH','sGP@Djuj`FsDVMcCC@','`IH`B','sOp@DjWkB@@GdX','sJQ@@eKU@H','KAx@@YIDUJjh@vDHSBincBPp@','sJX@@eKU@OH@','KAx@@YIDTjjh@vDHSBincAPp@','sOq@@drm\\@@@`','KAx@@IUkMUPAlHPfES\\','qCp@AIj`H','Hed@@DjUUjjj@FraBXUMpr','sGX@@eJuT@`','sGP@DkUj`FsDVMcCC@','HiD@@Dj}Ujj`AmHPfES\\LXrF@','KAx@@ITouUPAlHPfES]FHa`@','Hed@@DjWujjj@FraBXUMpsFIa`@','sGP@DiUj``mfHlZ','sFp@DiTvjhAlqEcP','Hid@@DjU^nBBH@FtaBXUMpq`XX@','sJP@DkVdAmQEb','qCp@AIZ`OH`','QMhDRVA@','qC`@ISJAlQE`','qCp@BOTAyhl','sJX@@eOU@ODB','sFp@DiTt@@AyaB','sGP@DkUj`FsDVMcMC@','Hid@@DjYUaBH`@FtaBXUMpqcHX@','qC`@Qz`OH@','HiD@@DjUVjj`AmHPfES\\LXZF@','sJP@H~j@[TQXqda`@','sJX@@eKU@OI@','sNp@Djejj@[\\QXu`','sJQ@@dsU@H','sJQ@@dkU@OI`','KAx@@YIMDVjh@vDHSBin@','Hid@@DjU^nBBD@FtaBXUMp`','sNp@DkgZj@[\\QXuqca`@','qC`@IRtDVqDVcEC@','Hed@@LdbRQeUUP@vTHSBinFP','sNp@DiUjj@P','qC`@IRtDT','sNp@DkYZj@[\\QXuqca`@','KAx@@IUkmUPAlHPfES]FDa`@','KAx@@IVjmUPAlHPfES]FNa`@','sOx@@drm\\@@@`','KAx@@ITjuUPAlHPfES]FBa`@','QMDARVAyH','sJP`@dfvhA@','HeT@@DjU_k``b`@[JDIaTwCLXfF@','KAx@@IToUUPAlHPfES]FJa`@','sGP@DkYj`FsDVMcEC@','qCb@AIZ`ODH','`I@`B','KAx@@IUzmUPAlHPfES]FFa`@','sNp@DkfZj@[\\QXu`','KAx@@ITnuUPAlHPfES]F@a`@','HiD@@LddURjjh@[RDIaTwB','sNp@Dj~Zj@[\\QXuqfa`@','Hed@@Dj{uZjj@FraBXUMpr','KAx@@ITsUUPAlHPfES\\','Hid@@LdbRQk``b@AmHPfES\\LXrF@','sOp@DjWkB@@GdH','sJQ@@dkU@OH@','Hid@@DjU^nBBH@FtaBXUMpqahX@','sGP@DiYj``mfHlZ','KAx@@IToUUPAlHPfES]FLa`@','qCp@AJZ`ODH','Hmt@@DjU]ZxHHj@AmhPfES\\Lj','sGP@DkUjPFsDVM@','qC`@IVtA@','Hed@@LdbJReUUP@vTHSBinFP','sNp@DjuZj@[\\QXuqea`@','KAx@@IUkmUPAlHPfES]FNa`@','HiD@@DkVUjj`AmHPfES\\H','Hed@@DkUeZjj@FraBXUMpr','sNp@DkVZj@[\\QXuqea`@','sJP@DiVhHKZbKFLLL@','HiD@@Djuyjj`AmHPfES\\H','sNp@DjUjj@[\\QXuq`a`@','HeT@@DjYUXPbH`@[JDIaTwCH','HiD@@DjwUjj`AmHPfES\\LXRF@','sNq@@djmUPB','KAx@@YIEEZjh@vDHSBincCPp@','sGP@Di^V`dmfHlZ','Hid@@DjYUaBHP@FtaBXUMp`','sNp@DjYjj@[\\QXuqba`@','sGP@Dkej`FsDVMcKC@','HeT@@DjU^k``b`@[JDIaTwCH','qC`@Qv`MbHmFBF@','sGQ@@djmT@`','qCr@XIKTAyH','qC`@IVtAlQEhpPp@','Hid@@LdbbQxXF@@AmHPfES\\LXjF@','sGP@DkYj`FsDVMcCC@','KAx@@IVsMUPAlHPfES\\','qCp@AIj`ODl','HiD@@DkeUjj`AmHPfES\\H','deT@@DjU[k``b`@vTHSBinFP','sJP@DkVdAmQEcFRF@','HiD@@LdbJTjjh@[RDIaTwCFDa`@','HiD@@DkYyjj`AmHPfES\\H','sJP@DjZhAyH','KAx@@IVkMUPAlHPfES]FDa`@','sJX@@dkU@OI@','Hed@@LdbRQUUUP@vTHSBinFXpLL@','Hed@@DjuUZjj@FraBXUMpr','sGP@Djfj`FsDVMcKC@','sNp@DkVZj@[\\QXuqba`@','sNp@DjyZj@[\\QXuqfa`@','qCb@AIj`OH@','sNp@DjUZj@[\\QXu`','KAx@@IWOMUPAlHPfES\\','Hid@@DjU^nBBH@D','Hed@@DjuvZjj@FraBXUMpr','sJP@DiVhHKZbKFLtL@','dmt@@DjU_ZxHHj@C[PaLJfxYVLKC@','sNp@DjuZj@[\\QXuqca`@','sJP@DkfhAmQEcFJF@','sNp@LdbJZj@[\\QXu`','HeT@@DjU_k``b`@[JDIaTwCLXFF@','KAx@@IVlmUPAlHPfES]FNa`@','HeT@@LdbbRKBDQD@CYPaLJfxYcEPp@','Hid@@DjUZnBBH@FtaBXUMpqcHX@','qCa@CIKTA@','HiD@@Dj~]jj`AmHPfES\\LXFF@','sKP@Di\\Zj@[TQX`','sGP@Djfj`FsDVMcEC@','HiD@@DkgYjj`AmHPfES\\H','sNp@DjuZj@[\\QXuqaa`@','KAx@@YIMDVjh@vDHSBincDPp@','sJP@DjVhHKZbKFLTL@','Hid@@LdbRQk``b@AmHPfES\\LXZF@','HiD@@Dj}Ujj`AmHPfES\\LXzF@','HeT@@DjU_k``bP@[JDIaTwCH','sNp@DkUZi@[\\QXu`','HiD@@DjYfjj`AmHPfES\\H','sGP@DjZj`FsDVMcAC@','Hmt@@DjU_jxHHj@AmhPfES\\Lj','Hid@@LdbRQk``R@AmHPfES\\H','KAx@@YIDUJjh@vDHSBincDPp@','qCr@XIKTAyD','sOq@@drm\\@@@|`@','Hed@@DjW^jjj@FraBXUMpsFBa`@','HeT@@DjY]zXFB@@[JDIaTwCH','Hkl@@DjU_Vk``bj`@[VDIaTwCJzX','Hid@@DjY}nBHH@FtaBXUMpqcHX@','sGX@@eKuT@|d@','sGP@Dj^Y`FsDVM@','HcL@@DjU_ZnBBJh@FqaBXUMprn`','sJP@DkVdAmQEcFJF@','sOq@@drm\\@@@|b@','sNp@DjyZj@[\\QXuqaa`@','HaD@@DjUZxHH@AyD@','qC`@Qv`H','dmt@@DjU_ZxHHj@C[PaLJfxYVLYC@','sGP@Dkej`FsDVMcMC@','Hed@@DjUUjjj@FraBXUMpsFHa`@','HeT@@LdbbRkBDQD@CYPaLJfxY@','KAx@@IU{MUPAlHPfES]FLa`@','RG@DTH','sJY@DDeVhA@','KAx@@YIDUJjh@vDHSBinc@Pp@','sJX@@dkU@OI`','sJQ@@dju@OI`','HeT@@LdbbRKBDQD@CYPaLJfxYcFPp@','sFp@DiTvjhAlqEcXpPp@','HaD@@DjUZxHH@AyG@','sNx@@eJ}UPB','sNp@LddUjj@[\\QXuqca`@','HaDH@@RVU[j@@@D','sNp@DkgZi@[\\QXu`','sGY@LDeVj`D','sNp@LdbJfZBZvxbqk@','sJP`@dfvhAyL','sGX@AddQjhAxe`','Hmt@@DjU_ZxHHj@AmhPfES\\LkFIa`@','qCh@CIKTA@','sNp@LdbLjj@[\\QXuq`a`@','sOq@@drm\\@@@|a@','KAx@@IUzmUPAlHPfES]FJa`@','sNx@AddQUUPB','sGP@Di]jP`mfHlZ','sJP`@TeZhA@','KAx@@IRjmUPHKXPaLJfx','HeT@@LdbRTM\\DDT@CYPaLJfxY@','HaF@@@Rfu[j@@@D','Hid@@DjYUaBH`@FtaBXUMpqchX@','KAx@@IUjmTpAlHPfES\\','Hid@@DjU^nBBD@FtaBXUMpqcHX@','sGP@DiUj``mfHl[FFF@','KAx@@IUvmUPAlHPfES]FLa`@','Hed@@LdbQTUUUP@vTHSBinFXqDL@','sJP@DkVhA@','sOx@@drm\\@@@|b@','KAx@@IUkMUPAlHPfES]FDa`@','HeT@@LdbRQU\\DDT@CYPaLJfxY@','HiD@@Dj}Yjj`AmHPfES\\LXrF@','HiD@@Dj{ujj`AmHPfES\\LXFF@','KAx@@IWNmUPAlHPfES]FFa`@','KAx@@IRkMUPHKXPaLJfx','sJP@DjYdAmQEcFZF@','sJY@LDeZhAyL','HaDH@@RVU[f@@@D','sJP`@deVhAyB','HaD@@DjWjZjj`AlHPfES\\','sGP@DkYj`FsDVMcMC@','sNp@DkgZj@[\\QXuqea`@','sJQ@@dlu@H','HeT@@DjU]k``b`@[JDIaTwCLXrF@','sJX@@dkU@OH`','RFDDQFCr`','sJP@DiYXIKZbKFLLL@','KAx@@YIHjjjh@vDHSBincGPp@','Hk\\@@DjU^ukmLHH@@@AmXPfES\\Lki`','sGQ@@djmT@|b@','Hid@@DjUfaBB`@FtaBXUMpqahX@','sNx@@eRmUPB','Hmt@@LdbRVak``ah@FvaBXUMprh','qCr@XIJtA@','KAx@@IWMmUPAlHPfES]FNa`@','HeT@@DjYYZPbJ@@[JDIaTwCH','sNp@DkfZj@[\\QXuqea`@','Hid@@DjU^nBAHAEVtaBXUMp`','dmt@@DjUgZDHJJ@C[PaLJfxYT','sGP@DkejPFsDVM@','sNx@@eJmUPB','qCb@AIf`H','HcL@@DjU_VnBBJh@FqaBXUMprnqcXX@','Hid@@DjUZnBBH@FtaBXUMpqahX@','sNp@LdbQZjBBvxbqkcGC@','sOx@@drm\\@@@|c@','sJP@H~j@^R@','KAx@@YIDcFjhDElHPfES\\','Hid@@DjUZnBAH@FtaBXUMp`','sNp@LddUji@[\\QXu`','sGP@DjfjPFsDVM@','HeT@@DjYUXPbD`@[JDIaTwCH','KAx@@IUoMUPAlHPfES]FDa`@','sFp@DiTt@@AyaD','Hed@@DjuuZjj@FraBXUMpsFIa`@','HeT@@DjUghP`h`@[JDIaTwCLXfF@','sOp@DjWkjj`FwDVM\\YhX@','sGP@Djfj`FsDVMcIC@','KAx@@IRkmUPHKXPaLJfzL]C@','sNx@@djmUPB','QM`AIdD','sOp@DjWkB@@Gbe@','sNp@DjyZj@[\\QXuqca`@','QM@HuAmd`','sNp@LddUjj@[\\QXuqea`@','daD@@DjUZxHD@CXPaLJfzLYC@','qCb@AIZPH','HiD@@LdbJTjjh@[RDIaTwCF@a`@','Hmt@@DjU_ZxHHi@AmhPfES\\Lj','HaDH@@RYWih@H@D','HiD@@LdbJTjjh@[RDIaTwCFHa`@','sGX@@djuT@|a@','sNp@DkfZj@[\\QXuqaa`@','Hid@@DjU^nBBH@GdL','KAx@@IVkMUPAlHPfES]FJa`@','qCr@XIKTAy@','HmT@@Dj{uVjjh@[ZDIaTwCJqaXX@','dmt@@DjYWVDHbJ@C[PaLJfxYT','Hif@@@RUe^Fh@@@P','HaDH@@Rfu[j@@@GdH','KAx@@IVsMUPAlHPfES]FDa`@','sKP@Di\\Zj@[TQXq`a`@','sJX@@eMU@OH@','HeT@@DjU^k``b`@[JDIaTwCLXFF@','Hmt@@LdbbRJXPbHh@FvaBXUMprh','sJP@DjvhAmQEcFBF@','dmt@@LdbbRNXPbHh@MmBDpj[aeXplL@','sJP`@dfvhAyD','sGP@Di^V`dmfHl[FVF@','KAx@@IVsmUPAlHPfES]FBa`@','sOq@@drm\\@@@|PP','sJY@BDeZhA@','HeT@@LdbRbmBDED@CYPaLJfxY@','Hed@@Djy[Zjj@FraBXUMpr','HeT@@DjU]k``b`@[JDIaTwCLXFF@','Hid@@DjUfaBB`@D','qCa@CIJtA@','QMPARVA@','Hid@@DjUfaBB`@FtaBXUMpqcHX@','sJY@BDfZhA@','HeT@@DjUghP`hP@[JDIaTwCH','Hed@@Dj{uZjj@FraBXUMpsFIa`@','dmt@@DjYUvDHbJ@C[PaLJfxYVLUC@','sNp`@dfuZj@P','sJQ@@dmU@OH@','sJX@@dmU@H','HeT@@DjU]k``b`@[JDIaTwCLXZF@','HiD@@LdfbJZjh@[RDIaTwCFAa`@','sOx@@drm\\@@@|a@','deT@@DjUfhP`h`@vTHSBinFP','dmt@@DjU]ZxHHj@C[PaLJfxYVLKC@','sOp@DjWkjj`FwDVM\\XHX@','HcL@@LdbbRNSBDQEP@McBDpj[ae]cFpp@','HiD@@Dj}Yji`AmHPfES\\H','HaDH@@RYe[hB@@D','Hid@@DjU^njjj@FtaBXUMpq`XX@','deT@@LdbbRKBDQB@FraBXUMpr','QMPARZA@','sOq@@drm\\@@@|QX','HaD@@DjYvxH`@A@','HcL@@LdbbRNcBDQEP@McBDpj[ae]@','QMhDRZA@','RG@DXLHmP','QM`BN`XQYd','RG@DTLHmP','QMHAIXFEVd','QMDARVAaH','RFPDXLHmP','RF@Q`vRbdLEC@','RF@QpvR@','QO@HyjAmd`','`II@B','`II@CFspqJp','`II@CF[@hM@prB`','`H@[T[|B`XN@PdM@p|@bHrBcDk@','RG@DXMj}F@','QM`BN`[L~b@','RG@DTMj}D@','QMHAIXFt~j@','QMDARVA}L@','RFPDXMj}D@','sKP@Di\\YZ@[TQXqaa`@','eF`BHD']);};$Xb.Us=function Us(a,b){var c,d;if(!b)return null;d=Sjb(UXb.llb,yZb,6,($Xb.Rs.length+31)/32|0,15,1);b=$Xb.Zs(b);$Xb.Gs(a.e,b);for(c=0;c<$Xb.Rs.length;c++){$Xb.Es(a.e,$Xb.Ss[c]);$Xb.ss(a.e,1,4)>0&&(d[c/32|0]|=1<<31-c%32);}return d;};$Xb.Vs=function Vs(a,b){var c,d;if(!b)return null;d=Sjb(UXb.mlb,N$b,6,($Xb.Rs.length+63)/64|0,14,1);b=$Xb.Zs(b);$Xb.Gs(a.e,b);for(c=0;c<$Xb.Rs.length;c++){$Xb.Es(a.e,$Xb.Ss[c]);$Xb.ss(a.e,1,4)>0&&(d[c/64|0]=exb(d[c/64|0],fxb(1,63-c%64)));}return d;};$Xb.Ws=function Ws(){var a,b;if($Xb.Ss==null){b=new $Xb.Kp(false);$Xb.Ss=Sjb(UXb.fmb,R_b,24,$Xb.Rs.length,0,1);for(a=0;a<$Xb.Rs.length;a++){$Xb.Ss[a]=$Xb.xp(b,$Xb.Rs[a]);$Xb.nu($Xb.Ss[a],1);}}};$Xb.Xs=function Xs(a){var b;if(a.d!=null){for(b=0;b<a.d.length;b++)if((a.b[b]&~a.d[b])!=0)return false;}else {return false;}return $Xb.Ys(a);};$Xb.Ys=function Ys(a){!a.c&&(a.c=(new $Xb.Kp(false),null));!a.a&&(a.a=(new $Xb.Kp(false),null));$Xb.Gs(a.e,a.c);$Xb.Es(a.e,a.a);return $Xb.zs(a.e);};$Xb.Zs=function Zs(a){var b,c;if(a.K){for(b=0;b<a.q;b++){if(cxb(Jwb(a.B[b],LZb),0)){a=new $Xb.Hu(a);for(c=b;c<a.q;c++)cxb(Jwb(a.B[c],LZb),0)&&(a.C[c]=-1);$Xb.tk(a);}}}return a;};$Xb.$s=function $s(a,b,c){a.a=b;c==null?a.b=$Xb.Us(a,b):a.b=c;};$Xb._s=function _s(a,b,c){a.c=b;c==null?a.d=$Xb.Us(a,b):a.d=c;};$Xb.at=function at(){$Xb.Ts();this.e=new $Xb.Ms();$Xb.Ws();};$Xb.bt=function bt(a){$Xb.Ts();var b,c,d,e,f,g;if(a==null)return null;b=Sjb(UXb.hlb,S$b,6,a.length*8,15,1);for(d=0;d<a.length;d++){g=a[d];for(e=7;e>=0;e--){c=g&15;c>9&&(c+=7);b[d*8+e]=48+c<<24>>24;g>>=4;}}return VXb.WHb(YXb.kTb(b,0,(f=b.length,YXb.hTb(),f)));};$Xb.ct=function ct(a){$Xb.Ts();var b,c,d,e;if(YXb.LTb(a).length==0||(YXb.LTb(a).length&7)!=0)return null;d=Sjb(UXb.llb,yZb,6,YXb.LTb(a).length/8|0,15,1);for(c=0;c<YXb.LTb(a).length;c++){e=c/8|0;b=(YXb.GTb(c,YXb.LTb(a).length),YXb.LTb(a).charCodeAt(c)-48);b>16&&(b-=7);d[e]<<=4;d[e]+=b;}return d;};$Xb.dt=function dt(a,b){$Xb.Ts();var c,d,e,f;f=0;d=0;e=0;for(c=0;c<a.length;c++){f+=JGb(a[c]&b[c]);d+=JGb(a[c]);e+=JGb(b[c]);}return f/$wnd.Math.sqrt(d*e);};$Xb.et=function et(a,b){$Xb.Ts();var c,d,e;e=0;c=0;for(d=0;d<a.length;d++){e+=JGb(a[d]&b[d]);c+=JGb(a[d]|b[d]);}return e/c;};xxb(196,1,{},$Xb.at);UXb.Xlb=VFb(196);$Xb.gt=function gt(a){a.j=1;a.k=10;a.n=400;a.f=400;a.i=true;a.d='black';a.b=new _Xb.kj();a.a=new _Xb.kj();a.c=new VXb.jIb();a.e=new PYb.sEb(12);};$Xb.ht=function ht(a,b){var c,d;c=(d=PYb.qEb(a.e,b),new QYb.MEb(d)).b;return c;};$Xb.it=function it(a){return a.k;};$Xb.jt=function jt(a){var b,c,d,e,f,g;f='<svg id="'+(a.g!=null?a.g:'mol'+$Xb.ft)+S_b+'xmlns="http://www.w3.org/2000/svg" version="1.1" '+'width="'+a.n+'px" '+'height="'+a.f+'px" '+'viewBox="0 0 '+a.n+' '+a.f+'">\n';g=a.i?'<style> #'+(a.g!=null?a.g:'mol'+$Xb.ft)+' { pointer-events:none; }'+' #'+(a.g!=null?a.g:'mol'+$Xb.ft)+' .event '+' { pointer-events:all; }'+' line { stroke-linecap:round; }'+' polygon { stroke-linejoin:round; }'+' <\/style>\n':'<g style="font-size:'+a.k+'px; fill-opacity:1; stroke-opacity:1; fill:black; stroke:black;'+' font-weight:normal; text-rendering:optimizeLegibility; font-family:sans-serif;'+' stroke-linejoin:round; stroke-linecap:round; stroke-dashoffset:0;">';f+='  ';f+=g;if(a.i){for(e=new _Xb.rOb(a.b);e.a<e.c.a.length;){d=_Xb.qOb(e);$Xb.kt(a,d);}for(c=new _Xb.rOb(a.a);c.a<c.c.a.length;){b=_Xb.qOb(c);$Xb.kt(a,b);}}a.i||$Xb.kt(a,'<\/g>');return f+a.c.a+'<\/svg>';};$Xb.kt=function kt(a,b){VXb.gIb(a.c,'  ');VXb.gIb(a.c,b);VXb.gIb(a.c,_Yb);};$Xb.lt=function lt(a,b,c){$Xb.Qc();$Xb.Td.call(this,a,b);$Xb.gt(this);this.g=c;++$Xb.ft;};$Xb.mt=function mt(a){$Xb.Qc();$Xb.lt.call(this,a,0,null);};xxb(195,144,{144:1},$Xb.lt,$Xb.mt);_.mb=function nt(a){var b;b='<line x1="'+VXb.mGb(SYb.IIb(SYb.FIb(new SYb.JIb(a.a),(SYb.HKb(),SYb.DKb))))+S_b+'y1="'+VXb.mGb(SYb.IIb(SYb.FIb(new SYb.JIb(a.c),SYb.DKb)))+S_b+'x2="'+VXb.mGb(SYb.IIb(SYb.FIb(new SYb.JIb(a.b),SYb.DKb)))+S_b+'y2="'+VXb.mGb(SYb.IIb(SYb.FIb(new SYb.JIb(a.d),SYb.DKb)))+S_b+T_b+this.d+S_b+U_b+this.j+V_b;$Xb.kt(this,b);};_.nb=function ot(a){var b,c;b=VXb.mGb(SYb.IIb(SYb.FIb(new SYb.JIb(3*this.j),(SYb.HKb(),SYb.DKb))));c='<line stroke-dasharray="'+b+','+b+S_b+'x1="'+VXb.mGb(SYb.IIb(SYb.FIb(new SYb.JIb(a.a),SYb.DKb)))+S_b+'y1="'+VXb.mGb(SYb.IIb(SYb.FIb(new SYb.JIb(a.c),SYb.DKb)))+S_b+'x2="'+VXb.mGb(SYb.IIb(SYb.FIb(new SYb.JIb(a.b),SYb.DKb)))+S_b+'y2="'+VXb.mGb(SYb.IIb(SYb.FIb(new SYb.JIb(a.d),SYb.DKb)))+S_b+T_b+this.d+S_b+'stroke-width:'+this.j+V_b;$Xb.kt(this,c);};_.ob=function pt(a){var b,c;c=new VXb.lIb('<polygon points="');for(b=0;b<a.a;b++){VXb.eIb(c,Uwb($wnd.Math.round(a.b[b])));c.a+=',';VXb.eIb(c,Uwb($wnd.Math.round(a.c[b])));c.a+=' ';}VXb.gIb(c,'" fill="'+this.d+S_b+T_b+this.d+S_b+U_b+this.j+V_b);$Xb.kt(this,c.a);};_.pb=function qt(a,b,c){var d,e,f,g;f=(d=(g=PYb.qEb(this.e,a),new QYb.MEb(g)).b,d);e='<text x="'+VXb.mGb(SYb.IIb(SYb.FIb(new SYb.JIb(b-f/2),(SYb.HKb(),SYb.DKb))))+S_b+'y="'+VXb.mGb(SYb.IIb(SYb.FIb(new SYb.JIb(c+this.k/3),SYb.DKb)))+S_b+'stroke="none" '+'font-size="'+this.e.b+S_b+'fill="'+this.d+'">'+a+'<\/text>';$Xb.kt(this,e);};_.qb=function rt(a,b,c){var d;d='<circle cx="'+VXb.mGb(SYb.IIb(SYb.FIb(new SYb.JIb(a+c/2),(SYb.HKb(),SYb.DKb))))+S_b+'cy="'+VXb.mGb(SYb.IIb(SYb.FIb(new SYb.JIb(b+c/2),SYb.DKb)))+S_b+'r="'+VXb.mGb(SYb.IIb(SYb.FIb(new SYb.JIb(c/2),SYb.DKb)))+S_b+'fill="'+this.d+V_b;$Xb.kt(this,d);};_.rb=function st(a){return $Xb.ht(this,a);};_.sb=function tt(){return $Xb.it(this);};_.tb=function ut(a,b,c,d){var e;e='<circle id="'+(this.g!=null?this.g:'mol'+$Xb.ft)+':Atom:'+a+S_b+W_b+'data-atom-map-no="'+$Xb.Ik(this.K,a)+S_b+'cx="'+VXb.mGb(SYb.IIb(SYb.FIb(new SYb.JIb(c),(SYb.HKb(),SYb.DKb))))+S_b+'cy="'+VXb.mGb(SYb.IIb(SYb.FIb(new SYb.JIb(d),SYb.DKb)))+S_b+'r="'+8+S_b+X_b;_Xb.Si(this.a,e);};_.ub=function vt(a,b,c,d,e){var f;f='<line id="'+(this.g!=null?this.g:'mol'+$Xb.ft)+':Bond:'+a+S_b+W_b+'x1="'+VXb.mGb(SYb.IIb(SYb.FIb(new SYb.JIb(b),(SYb.HKb(),SYb.DKb))))+S_b+'y1="'+VXb.mGb(SYb.IIb(SYb.FIb(new SYb.JIb(c),SYb.DKb)))+S_b+'x2="'+VXb.mGb(SYb.IIb(SYb.FIb(new SYb.JIb(d),SYb.DKb)))+S_b+'y2="'+VXb.mGb(SYb.IIb(SYb.FIb(new SYb.JIb(e),SYb.DKb)))+S_b+U_b+8+S_b+X_b;_Xb.Si(this.b,f);};_.wb=function wt(a){this.j=kxb(Uwb($wnd.Math.round(100*$wnd.Math.max(a,1))))/100;};_.xb=function xt(a){this.d='rgb('+((a&Y_b)>>16)+','+((a&AZb)>>8)+','+(a&255)+')';};_.yb=function yt(a){if(this.k!=a){this.k=a;this.e=new PYb.sEb(a);}};_.zb=function zt(a,b){this.n=lxb(Uwb($wnd.Math.round(a.b)));this.f=lxb(Uwb($wnd.Math.round(a.a)));return $Xb.Pd(this,a,b);};_.lb=function At(){return $Xb.jt(this);};_.f=0;_.i=false;_.j=0;_.k=0;_.n=0;$Xb.ft=0;UXb.Zlb=VFb(195);$Xb.Bt=function Bt(a,b){var c;if(a.c!=null)for(c=0;c<a.c.length;c++)if(b==a.c[c]&&a.d[c])return true;return false;};$Xb.Ct=function Ct(a,b,c,d,e){this.a=a;this.b=b;this.g=c;this.f=d;this.e=e;};xxb(210,1,{210:1},$Xb.Ct);_.a=0;_.b=0;_.e=false;_.f=false;_.g=0;UXb.$lb=VFb(210);$Xb.Dt=function Dt(a,b){var c,d,e,f;f=false;a.b=b;$Xb.nu(a.b,15);c=a.b.f;d=a.b.g;a.j=Sjb(UXb.Cwb,KZb,6,d,16,1);for(e=0;e<d;++e)a.j[e]=false;a.g=Sjb(UXb.Cwb,KZb,6,c,16,1);a.c=Sjb(UXb.llb,yZb,6,c,15,1);for(e=0;e<c;++e){a.g[e]=false;a.c[e]=-1;}a.e=Sjb(UXb.Oub,nZb,2,3*c,6,1);a.i=0;a.d=0;a.a=0;while(!f){for(e=0;e<c;++e){if(!a.g[e]){a.a>0&&(a.e[a.i++]='.');$Xb.Ft(a,e,-1);++a.a;break;}}e==c&&(f=true);}a.f='';for(e=0;e<a.i;++e)a.f+=''+a.e[e];return a.f;};$Xb.Et=function Et(a){switch(a){case 5:case 6:case 7:case 8:case 9:case 15:case 16:case 17:case 35:case 53:return true;default:return false;}};$Xb.Ft=function Ft(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p;d=true;i=0;p=0;m=a.i;a.c[b]=m;h=$Xb.Qk(a.b,b);g=$Xb.Fk(a.b,b);e=$Xb.zk(a.b,b);f=$Xb.Jk(a.b,b);k=$Xb.Sn(a.b,b);e==0&&f==0&&$Xb.Et(h)&&(d=false);a.e[m]='';if(c!=-1){switch($Xb.bl(a.b,c)){case 0:a.e[m]+='~';break;case 2:a.e[m]+='=';break;case 3:a.e[m]+='#';}}d&&(a.e[m]+='[');f!=0&&(a.e[m]+=''+f);a.e[m]+=''+g;if(d){if(0<(o=$Xb.fo(a.b,b))){a.e[m]+='H';1<o&&(a.e[m]+=o);}}if(e!=0){e>0?a.e[m]+='+':a.e[m]+='-';$wnd.Math.abs(e)>1&&(a.e[m]+=''+$wnd.Math.abs(e));}d&&(a.e[m]+=']');c!=-1&&(a.j[c]=true);a.g[b]=true;++a.i;for(n=0;n<k;++n)a.j[$Xb.Tn(a.b,b,n)]||++i;for(n=0;n<k;++n){j=$Xb.Rn(a.b,b,n);l=$Xb.Tn(a.b,b,n);if(a.j[l]){++p;continue;}if(a.g[j]){++a.d;a.j[l]=true;switch($Xb.bl(a.b,l)){case 0:a.e[a.c[j]]+='~';a.e[m]+='~';break;case 2:a.e[a.c[j]]+='=';a.e[m]+='=';break;case 3:a.e[a.c[j]]+='#';a.e[m]+='3';}if(a.d>9){a.e[a.c[j]]+='%';a.e[m]+='%';}a.e[a.c[j]]+=''+a.d;a.e[m]+=''+a.d;continue;}n-p<i-1&&(a.e[a.i++]='(');$Xb.Ft(a,j,l);n-p<i-1&&(a.e[a.i++]=')');}};$Xb.Gt=function Gt(){};xxb(327,1,{},$Xb.Gt);_.a=0;_.d=0;_.i=0;UXb._lb=VFb(327);$Xb.Ht=function Ht(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o;j=Sjb(UXb.llb,yZb,6,a.i.f,15,1);h=Sjb(UXb.llb,yZb,6,a.i.f,15,1);i=Sjb(UXb.llb,yZb,6,a.i.f,15,1);k=Sjb(UXb.llb,yZb,6,a.i.f,15,1);c=$Xb.Vk(a.i,0,b);d=$Xb.Vk(a.i,1,b);h[0]=c;h[1]=d;i[0]=-1;i[1]=b;j[c]=1;j[d]=2;k[c]=-1;k[d]=c;g=1;l=1;while(g<=l&&j[h[g]]<15){o=h[g];for(m=0;m<$Xb.Sn(a.i,o);m++){e=$Xb.Rn(a.i,o,m);if(e!=k[o]){f=$Xb.Tn(a.i,o,m);if(e==c){i[0]=f;for(n=0;n<=l;n++){if(!a.f[i[m]]){a.f[i[m]]=true;++a.c;}}return;}if($Xb.El(a.i,e)&&j[e]==0){++l;h[l]=e;i[l]=f;j[e]=j[o]+1;k[e]=o;}}}++g;}return;};$Xb.It=function It(a){var b,c,d,e,f,g,h,i,j,k,l,m,n;$Xb.nu(a.i,7);l=false;m=Sjb(UXb.llb,yZb,6,2,15,1);n=Sjb(UXb.llb,yZb,6,2,15,1);k=Sjb(UXb.llb,yZb,6,2,15,1);for(d=0;d<a.i.g;d++){if(!$Xb.Yo(a.i,d)&&$Xb.el(a.i,d)==2){for(g=0;g<2;g++){m[g]=-1;k[g]=-1;b=$Xb.Vk(a.i,g,d);for(j=0;j<$Xb.Sn(a.i,b);j++){e=$Xb.Tn(a.i,b,j);if(e!=d){if(m[g]==-1&&($Xb.el(a.i,e)==257||$Xb.el(a.i,e)==129)){m[g]=$Xb.Rn(a.i,b,j);n[g]=e;}else {k[g]=$Xb.Rn(a.i,b,j);}}}if(m[g]==-1)break;}if(m[0]!=-1&&m[1]!=-1){i=$Xb.el(a.i,n[0])==$Xb.el(a.i,n[1]);for(h=0;h<2;h++)m[h]==$Xb.Vk(a.i,0,n[h])&&(i=!i);for(f=0;f<2;f++)k[f]!=-1&&k[f]<m[f]&&(i=!i);$Xb.Cm(a.i,d,i?2:1,false);l=true;}}}for(c=0;c<a.i.g;c++)($Xb.el(a.i,c)==257||$Xb.el(a.i,c)==129)&&$Xb.Fm(a.i,c,1);return l;};$Xb.Jt=function Jt(a){return a==61?2:a==35?4:a==36?32:a==58?8:a==62?16:a==126?31:1;};$Xb.Kt=function Kt(a,b){var c,d,e,f,g,h,i,j,k,l,m;for(c=0;c<a.i.f;c++){if($Xb.El(a.i,c)){i=Sjb(UXb.llb,yZb,6,a.i.f,15,1);h=Sjb(UXb.llb,yZb,6,a.i.f,15,1);j=Sjb(UXb.llb,yZb,6,a.i.f,15,1);h[0]=c;i[c]=1;j[c]=-1;g=0;k=0;while(g<=k){e=(i[h[g]]&1)==1?1:2;for(l=0;l<$Xb.Sn(a.i,h[g]);l++){d=$Xb.Tn(a.i,h[g],l);if($Xb.bl(a.i,d)==e&&b[d]){f=$Xb.Rn(a.i,h[g],l);if(i[f]==0){if(e==1&&$Xb.El(a.i,f)){m=h[g];while(m!=-1){$Xb.Fm(a.i,$Xb.Pn(a.i,f,m),e==1?2:1);e=3-e;f=m;m=j[m];}$Xb.lm(a.i,c,false);$Xb.lm(a.i,f,false);a.b-=2;return true;}h[++k]=f;j[f]=h[g];i[f]=i[h[g]]+1;}}}++g;}}}return false;};$Xb.Lt=function Lt(a){var b,c,d,e;for(b=0;b<a.i.f;b++){if($Xb.Qk(a.i,b)==7&&$Xb.zk(a.i,b)==0&&$Xb.ko(a.i,b)>3&&$Xb.In(a.i,b)>0){for(e=0;e<$Xb.Sn(a.i,b);e++){c=$Xb.Rn(a.i,b,e);d=$Xb.Tn(a.i,b,e);if($Xb.bl(a.i,d)>1&&$Xb.Cl(a.i,c)){$Xb.el(a.i,d)==4?$Xb.Fm(a.i,d,2):$Xb.Fm(a.i,d,1);$Xb.cm(a.i,b,$Xb.zk(a.i,b)+1);$Xb.cm(a.i,c,$Xb.zk(a.i,c)-1);$Xb.am(a.i,b,-1);break;}}}}};$Xb.Mt=function Mt(a){return !a.n?'':'Unresolved SMARTS features:'+a.n;};$Xb.Nt=function Nt(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K;$Xb.nu(a.i,1);a.f=Sjb(UXb.Cwb,KZb,6,a.i.g,16,1);a.c=0;for(k=0;k<a.i.g;k++){if($Xb.el(a.i,k)==64){$Xb.Fm(a.i,k,1);a.f[k]=true;++a.c;}}w=Sjb(UXb.Cwb,KZb,6,a.i.f,16,1);K=new $Xb.gs(a.i,3);v=Sjb(UXb.Cwb,KZb,6,K.i.a.length,16,1);for(G=0;G<K.i.a.length;G++){I=_Xb.Xi(K.i,G);v[G]=true;for(q=0;q<I.length;q++){if(!$Xb.El(a.i,I[q])){v[G]=false;break;}}if(v[G]){for(r=0;r<I.length;r++)w[I[r]]=true;J=_Xb.Xi(K.j,G);for(s=0;s<J.length;s++){if(!a.f[J[s]]){a.f[J[s]]=true;++a.c;}}}}for(l=0;l<a.i.g;l++){!a.f[l]&&(K.b[l]&pZb)!=0&&$Xb.El(a.i,$Xb.Vk(a.i,0,l))&&$Xb.El(a.i,$Xb.Vk(a.i,1,l))&&$Xb.Ht(a,l);}for(m=0;m<a.i.g;m++){if(!a.f[m]){e=$Xb.Vk(a.i,0,m);f=$Xb.Vk(a.i,1,m);if(!w[e]&&!w[f]&&$Xb.El(a.i,e)&&$Xb.El(a.i,f)){a.f[m]=true;++a.c;}}}$Xb.nu(a.i,7);u=Sjb(UXb.Cwb,KZb,6,a.i.g,16,1);for(t=0;t<a.i.g;t++)u[t]=a.f[t];for(H=0;H<K.i.a.length;H++){if(v[H]){I=_Xb.Xi(K.i,H);for(p=0;p<I.length;p++){if(!$Xb.Ut(a,I[p])){if($Xb.El(a.i,I[p])){$Xb.lm(a.i,I[p],false);--a.b;}for(B=0;B<$Xb.Sn(a.i,I[p]);B++){o=$Xb.Tn(a.i,I[p],B);if(a.f[o]){a.f[o]=false;--a.c;}}}}}}$Xb.Tt(a);for(F=0;F<K.i.a.length;F++){if(v[F]&&_Xb.Xi(K.j,F).length==6){J=_Xb.Xi(K.j,F);A=true;for(h=J,i=0,j=h.length;i<j;++i){g=h[i];if(!a.f[g]){A=false;break;}}if(A){$Xb.St(a,J[0]);$Xb.St(a,J[2]);$Xb.St(a,J[4]);$Xb.Tt(a);}}}for(D=5;D>=4;D--){do{C=false;for(g=0;g<a.i.g;g++){if(a.f[g]){c=0;for(p=0;p<2;p++){n=$Xb.Vk(a.i,p,g);for(B=0;B<$Xb.Sn(a.i,n);B++)a.f[$Xb.Tn(a.i,n,B)]&&++c;}if(c==D){$Xb.St(a,g);$Xb.Tt(a);C=true;break;}}}}while(C);}while(a.b>=2)if(!$Xb.Kt(a,u))break;if(b){if(a.b!=0){for(d=0;d<a.i.f;d++){if($Xb.El(a.i,d)){$Xb.lm(a.i,d,false);$Xb.om(a.i,d,2,true);--a.b;}}}if(a.c!=0){for(g=0;g<a.i.g;g++){if(a.f[g]){a.f[g]=false;$Xb.Fm(a.i,g,64);--a.c;}}}}else {for(d=0;d<a.i.f;d++){if($Xb.El(a.i,d)&&$Xb.fo(a.i,d)!=0){$Xb.lm(a.i,d,false);$Xb.pm(a.i,d,32);--a.b;}}}if(a.b!=0)throw Hwb(new VXb.aA(Z_b));if(a.c!=0)throw Hwb(new VXb.aA(Z_b));};$Xb.Ot=function Ot(a,b,c,d,e,f,g){var h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,$,ab,bb,cb,db,eb,fb,gb,hb,ib,jb,kb,lb,mb,nb,ob,pb,qb,rb,sb,tb,ub,vb,wb,xb,yb,zb,Ab;a.i=b;$Xb.hk(a.i);!!a.n&&VXb.$Eb(a.n,0);a.b=0;i=a.k!=0;fb=null;p=Sjb(UXb.llb,yZb,6,32,15,1);p[0]=-1;lb=Sjb(UXb.llb,yZb,6,16,15,1);ob=Sjb(UXb.llb,yZb,6,16,15,1);nb=Sjb(UXb.llb,yZb,6,16,15,1);mb=Sjb(UXb.llb,yZb,6,16,15,1);for(M=0;M<16;M++)lb[M]=-1;m=0;H=-1;rb=false;P=false;qb=false;u=0;s=1;r=0;l=new yYb.F6();gb=new $Xb.fu(c);while(c[d]<=32)++d;while(d<e){tb=c[d++]&pZb;if(DFb(tb)||tb==42||tb==63||tb==33&&i&&rb||tb==35&&i&&rb){o=-1;w=0;W=0;h=-1;F=-1;eb=false;O=false;n=0;if(rb){if(tb==42){o=6;n=lxb(exb(UXb.Rwb(n),1));}else if(tb==63){o=0;}else if(tb==35){Z=0;while(d<e&&CFb(c[d]&pZb)){Z=10*Z+c[d]-48;++d;}if(Z<1||Z>=($Xb.Sj(),$Xb.Mj).length)throw Hwb(new VXb.aA('SmilesParser: Atomic number out of range.'));o=Z;}else {Q=tb==33;if(Q){qb=true;n=lxb(exb(UXb.Rwb(n),1));++d;}if(c[d-1]==82&&i&&(CFb(c[d]&pZb)||a.a&&c[d]==123)){o=6;n=lxb(exb(UXb.Rwb(n),1));--d;Q&&--d;}else {R=GFb(c[d]&pZb)==(c[d]&pZb)&&DFb(c[d]&pZb)?2:1;o=($Xb.Sj(),$Xb.hn(VXb.WHb(YXb.kTb(c,d-1,(T=R,YXb.hTb(),T))),321));if(o==-1){o=6;n=lxb(exb(UXb.Rwb(n),1));--d;}else {d+=R-1;F=9;if(i&&(c[d]==44||Q)){ub=false;V=false;sb=d-R;for(bb=sb;bb<c.length;bb++){if(!DFb(c[bb]&pZb)){Y=$Xb.hn(VXb.WHb(YXb.kTb(c,sb,(S=bb-sb,S))),321);if(Y!=0){yYb.A6(l,VXb.UGb(Y));IFb(c[sb]&pZb)==(c[sb]&pZb)&&DFb(c[sb]&pZb)?ub=true:V=true;}sb=bb+1;if(c[bb]!=44)break;if(c[bb+1]==33){if(!Q)throw Hwb(new VXb.aA("SmilesParser: inconsistent '!' in atom list."));++bb;++sb;}}}if(l.d.a.length>1){F=-1;ub?V||(n=lxb(exb(UXb.Rwb(n),4))):n=lxb(exb(UXb.Rwb(n),2));}d=sb-1;}}}}while(rb){if(c[d]==64){++d;if(c[d]==64){O=true;++d;}eb=true;continue;}if(c[d]==58){++d;while(CFb(c[d]&pZb)){W=10*W+c[d]-48;++d;}continue;}if(c[d]==91)throw Hwb(new VXb.aA('SmilesParser: nested square brackets found'));if(c[d]==93){++d;rb=false;continue;}if(c[d]==43){w=1;++d;while(c[d]==43){++w;++d;}if(w==1&&CFb(c[d]&pZb)){w=c[d]-48;++d;}w==0&&(n=lxb(exb(UXb.Rwb(n),ZZb)));continue;}if(c[d]==45){w=-1;++d;while(c[d]==45){--w;++d;}if(w==-1&&CFb(c[d]&pZb)){w=48-c[d];++d;}w==0&&(n=lxb(exb(UXb.Rwb(n),ZZb)));continue;}Q=c[d]==33;Q&&++d;if(c[d]==72){++d;d+=$Xb.cu(gb,c,d,1);F=gb.c;G=0;gb.c<=0&&gb.b>=0&&(G=lxb(exb(UXb.Rwb(G),128)));gb.c<=1&&gb.b>=1&&(G=lxb(exb(UXb.Rwb(G),256)));gb.c<=2&&gb.b>=2&&(G=lxb(exb(UXb.Rwb(G),512)));gb.c<=3&&gb.b>=3&&(G=lxb(exb(UXb.Rwb(G),XZb)));if(Q){n|=G;F=-1;}else {if(gb.b==gb.c){F=gb.c;}else {n=lxb(exb(UXb.Rwb(n),Jwb(WZb,UXb.Rwb(~G))));F=-1;}}continue;}if(c[d]==68){++d;d+=$Xb.cu(gb,c,d,1);G=0;gb.c<=0&&gb.b>=0&&(G=exb(G,T$b));gb.c<=1&&gb.b>=1&&(G=exb(G,G$b));gb.c<=2&&gb.b>=2&&(G=exb(G,F$b));gb.c<=3&&gb.b>=3&&(G=exb(G,W$b));gb.c<=4&&gb.b>=4&&(G=exb(G,g$b));if(Owb(G,0)!=0){Q||(G=nxb(G,b$b));n=lxb(exb(UXb.Rwb(n),G));}continue;}if(c[d]==122&&a.a){++d;d+=$Xb.cu(gb,c,d,4);G=0;gb.c<=0&&gb.b>=0&&(G=exb(G,q$b));gb.c<=1&&gb.b>=1&&(G=exb(G,$_b));gb.c<=2&&gb.b>=2&&(G=exb(G,__b));gb.c<=3&&gb.b>=3&&(G=exb(G,a0b));gb.c<=4&&gb.b>=4&&(G=exb(G,p$b));if(Owb(G,0)!=0){Q||(G=nxb(G,k$b));n=lxb(exb(UXb.Rwb(n),G));}continue;}if(c[d]==88){++d;d+=$Xb.cu(gb,c,d,1);Ab=($Xb.Sj(),$Xb.Nj)[o];if(Ab==null)continue;wb=Ab[0];G=0;wb-gb.c<=0&&wb-gb.b>=0&&(G=exb(G,RZb));wb-gb.c<=1&&wb-gb.b>=1&&(G=exb(G,m_b));wb-gb.c<=2&&wb-gb.b>=2&&(G=exb(G,oZb));if(Owb(G,0)!=0){Q||(G=nxb(G,a$b));n=lxb(exb(UXb.Rwb(n),G));}continue;}if(c[d]==65||c[d]==97){++d;n=lxb(exb(UXb.Rwb(n),Q^c[d]==65?4:2));continue;}if(c[d]==82){++d;d+=$Xb.cu(gb,c,d,3);G=0;gb.c<=0&&gb.b>=0&&(G=exb(G,8));gb.c<=1&&gb.b>=1&&(G=exb(G,16));gb.c<=2&&gb.b>=2&&(G=exb(G,32));gb.c<=3&&gb.b>=3&&(G=exb(G,64));gb.b>3&&$Xb.Wt(a,(Q?'!R':'R')+gb.b);if(Owb(G,0)!=0){Q||(G=nxb(G,120));n=lxb(exb(UXb.Rwb(n),G));}continue;}if(c[d]==114){++d;d+=$Xb.cu(gb,c,d,1);if(gb.a){Q?n=lxb(exb(UXb.Rwb(n),384)):n=lxb(exb(UXb.Rwb(n),8));continue;}pb=gb.c;gb.b>gb.c&&$Xb.Wt(a,(Q?'!r':'r')+('{'+gb.c+'-'+gb.b+'}'));!Q&&pb>=3&&pb<=7?n|=pb<<22:gb.b>gb.c||$Xb.Wt(a,(Q?'!r':'r')+pb);continue;}if(c[d]==118){++d;d+=$Xb.cu(gb,c,d,1);wb=gb.c;gb.b>gb.c&&$Xb.Wt(a,(Q?'!v':'v')+('{'+gb.c+'-'+gb.b+'}'));!Q&&wb<=14?h=wb:gb.b>gb.c||$Xb.Wt(a,(Q?'!v':'v')+wb);continue;}if(i&&(c[d]==59||c[d]==38)){qb=true;++d;continue;}throw Hwb(new VXb.aA("SmilesParser: unexpected character inside brackets: '"+String.fromCharCode(c[d]&pZb)+"'"));}}else if(tb==42){o=6;n=lxb(exb(UXb.Rwb(n),1));}else if(tb==63){o=0;}else if((tb==65||tb==97)&&i){o=6;n=lxb(exb(UXb.Rwb(n),1));n=lxb(exb(UXb.Rwb(n),tb==65?4:2));qb=true;}else {switch(IFb(tb)){case 66:if(d<e&&c[d]==114){o=35;++d;}else o=5;break;case 67:if(d<e&&c[d]==108){o=17;++d;}else o=6;break;case 70:o=9;break;case 73:o=53;break;case 78:o=7;break;case 79:o=8;break;case 80:o=15;break;case 83:o=16;}}if(o==-1&&tb!=63)throw Hwb(new VXb.aA('SmilesParser: unknown element label found'));k=$Xb.Uj(a.i,o);$Xb.cm(a.i,k,w);$Xb.km(a.i,k,W,false);$Xb.am(a.i,k,h);if(n!=0){qb=true;if(cxb(Jwb(UXb.Rwb(n),2),0)){n=lxb(Jwb(UXb.Rwb(n),-3));$Xb.lm(a.i,k,true);++a.b;}else {$Xb.lm(a.i,k,false);}$Xb.om(a.i,k,UXb.Rwb(n),true);}if(l.d.a.length!=0){qb=true;U=Sjb(UXb.llb,yZb,6,l.d.a.length,15,1);for(L=0;L<l.d.a.length;L++)U[L]=(L<0?null:_Xb.Xi(l.d,L)).a;$Xb.im(a.i,k,U);YXb.eTb(l.d.a,0);}else {if(GFb(tb)==tb&&DFb(tb)){if(o!=5&&o!=6&&o!=7&&o!=8&&o!=15&&o!=16&&o!=33&&o!=34)throw Hwb(new VXb.aA('SmilesParser: atomicNo '+o+' must not be aromatic'));$Xb.lm(a.i,k,true);++a.b;}else {$Xb.lm(a.i,k,false);}}if(F!=-1&&o!=1){v=Sjb(UXb.hlb,S$b,6,1,15,1);v[0]=(F==9?0:F)<<24>>24;$Xb.gm(a.i,k,v);}H=p[u];if(p[u]!=-1&&s!=512){q=$Xb.Wj(a.i,p[u],k,s);if(r!=0){qb=true;$Xb.Em(a.i,q,r,true);}}s=1;r=0;p[u]=k;if(m!=0){$Xb.mm(a.i,k,m);m=0;}if(g){cb=!fb?null:_Xb.lNb(fb,VXb.UGb(H));!!cb&&$Xb.$t(cb,k,d);if(eb){!fb&&(fb=new _Xb.oRb());K=F==9?0:F;_Xb.gRb(fb,VXb.UGb(k),new $Xb.bu(k,d-2,H,K,O));}}continue;}if(tb==46){p[u]=-1;s=512;continue;}if(tb==45||tb==61||tb==35||tb==36||tb==58||tb==47||tb==92||tb==60||tb==126||tb==33||tb==64){if(rb)throw Hwb(new VXb.aA("SmilesParser: unexpected bond symbol inside square brackets: '"+String.fromCharCode(tb)+"'"));C=0;while(tb==45||tb==61||tb==35||tb==36||tb==58||tb==47||tb==92||tb==60||tb==126||tb==33||tb==64){if(tb==33){tb=c[d++]&pZb;tb==64&&(r|=128);if(tb==45&&c[d]==62||tb==60&&c[d]==45){C|=32;++d;}else if(tb==45)C|=1;else if(tb==61)C|=2;else if(tb==35)C|=4;else if(tb==36)C|=32;else if(tb==58)C|=8;else throw Hwb(new VXb.aA("SmilesParser: bond symbol '"+String.fromCharCode(tb)+"' not allowed after '!'."));}else {if(tb==64)r|=256;else if(tb==61)s=2;else if(tb==35)s=4;else if(tb==36)s=8;else if(tb==58)s=64;else if(tb==126)r|=31;else if(tb==47){g&&(s=257);}else if(tb==92){g&&(s=129);}else if(tb==45&&c[d]==62||tb==60&&c[d]==45){s=32;++d;}if(c[d]==44){r|=(s==32?62:tb)==61?2:(s==32?62:tb)==35?4:(s==32?62:tb)==36?32:(s==32?62:tb)==58?8:(s==32?62:tb)==62?16:(s==32?62:tb)==126?31:1;while(c[d]==44){if(c[d+1]==60&&c[d+2]==45||c[d+1]==45&&c[d+2]==62){r|=16;d+=3;}else {r|=$Xb.Jt(c[d+1]&pZb);d+=2;}}}}if(c[d]==59){++d;tb=c[d++]&pZb;continue;}C!=0&&(r|=31&~C);break;}continue;}if(tb<=32){d=e;continue;}if(CFb(tb)){Z=tb-48;if(rb){while(d<e&&CFb(c[d]&pZb)){Z=10*Z+c[d]-48;++d;}m=Z;}else {t=P?d-3:d-2;J=c[t]==45||c[t]==47||c[t]==92||c[t]==61||c[t]==35||c[t]==36||c[t]==58||c[t]==62||c[t]==126;if(P&&d<e&&CFb(c[d]&pZb)){Z=10*Z+c[d]-48;P=false;++d;}if(Z>=lb.length){if(Z>=100)throw Hwb(new VXb.aA('SmilesParser: ringClosureAtom number out of range'));$=lb.length;X=lb.length;while(X<=Z)X=$wnd.Math.min(100,X+16);lb=(YXb.wTb(X),_Xb.zOb(lb,Sjb(UXb.llb,yZb,6,X,15,1),X));ob=(YXb.wTb(X),_Xb.zOb(ob,Sjb(UXb.llb,yZb,6,X,15,1),X));nb=(YXb.wTb(X),_Xb.zOb(nb,Sjb(UXb.llb,yZb,6,X,15,1),X));mb=(YXb.wTb(X),_Xb.zOb(mb,Sjb(UXb.llb,yZb,6,X,15,1),X));for(L=$;L<X;L++)lb[L]=-1;}if(lb[Z]==-1){lb[Z]=p[u];ob[Z]=d-1;nb[Z]=J?s:-1;mb[Z]=J?r:0;}else {if(lb[Z]==p[u])throw Hwb(new VXb.aA('SmilesParser: ring closure to same atom'));if(g&&!!fb){cb=_Xb.lNb(fb,VXb.UGb(lb[Z]));!!cb&&$Xb.$t(cb,p[u],ob[Z]);cb=_Xb.lNb(fb,VXb.UGb(p[u]));!!cb&&$Xb.$t(cb,lb[Z],d-1);}nb[Z]!=-1?s=nb[Z]:s==257?s=129:s==129&&(s=257);q=$Xb.Wj(a.i,lb[Z],p[u],s);mb[Z]!=0&&(r=mb[Z]);if(r!=0){qb=true;$Xb.Em(a.i,q,mb[Z],true);}lb[Z]=-1;}s=1;r=0;}continue;}if(tb==43){throw Hwb(new VXb.aA("SmilesParser: '+' found outside brackets"));}if(tb==40){if(p[u]==-1)throw Hwb(new VXb.aA('Smiles with leading parenthesis are not supported'));++u;p.length==u&&(p=_Xb.xOb(p,p.length+32));p[u]=p[u-1];continue;}if(tb==41){--u;continue;}if(tb==91){rb=true;continue;}if(tb==93){throw Hwb(new VXb.aA('SmilesParser: closing bracket at unexpected position'));}if(tb==37){P=true;continue;}throw Hwb(new VXb.aA("SmilesParser: unexpected character outside brackets: '"+String.fromCharCode(tb)+"'"));}if(s!=1)throw Hwb(new VXb.aA('SmilesParser: dangling open bond'));for(ib=lb,jb=0,kb=ib.length;jb<kb;++jb){hb=ib[jb];if(hb!=-1)throw Hwb(new VXb.aA('SmilesParser: dangling ring closure'));}I=$Xb.co(a.i);$Xb.Jm(a.i,true);$Xb.nu(a.i,1);for(j=0;j<a.i.q;j++){if($Xb.Bk(a.i,j)!=null){D=$Xb.Ck(a.i,j)[0];if(qb||a.k==2){if(a.g){for(L=0;L<D;L++)$Xb.Wj(a.i,j,$Xb.Uj(a.i,1),1);}else {D==0&&$Xb.om(a.i,j,1792,true);D==1&&$Xb.om(a.i,j,1664,true);D==2&&$Xb.om(a.i,j,1408,true);D==3&&$Xb.om(a.i,j,896,true);}}else {if(!$Xb.Fl(a.i,j)&&(!$Xb.El(a.i,j)||$Xb.Qk(a.i,j)==6&&$Xb.zk(a.i,j)==0)){Ab=$Xb.en($Xb.Qk(a.i,j));A=false;vb=$Xb.ko(a.i,j);vb-=$Xb.il(a.i,j,vb);vb+=D;$Xb.El(a.i,j)&&++vb;for(xb=Ab,yb=0,zb=xb.length;yb<zb;++yb){wb=xb[yb];if(vb<=wb){A=true;wb==vb+2?$Xb.pm(a.i,j,48):wb==vb+1?$Xb.pm(a.i,j,32):(wb!=vb||wb!=Ab[0])&&$Xb.am(a.i,j,vb);break;}}A||$Xb.am(a.i,j,vb);}if(a.g||!$Xb.lp(a.i,j))for(L=0;L<D;L++)$Xb.Wj(a.i,j,$Xb.Uj(a.i,1),1);}}else if(!a.g&&(qb||a.k==2)){D=$Xb.Wn(a.i,j);D>=1&&$Xb.om(a.i,j,128,true);D>=2&&$Xb.om(a.i,j,256,true);D>=3&&$Xb.om(a.i,j,512,true);D>=4&&$Xb.om(a.i,j,XZb,true);}}!a.g&&(qb||a.k==2)&&$Xb.dp(a.i,true);$Xb.nu(a.i,1);$Xb.Lt(a);$Xb.Nt(a,i);a.i.t=null;$Xb.Jm(a.i,false);if(g){$Xb.It(a);if(fb){for(db=(ab=new _Xb.MMb(fb).a.Td().Fb(),new _Xb.TMb(ab));db.a.Fd();){cb=(B=db.a.Gd(),B.Xd());$Xb.nm(a.i,cb.a,$Xb._t(cb,I),false);}$Xb.gp(a.i,0);}}$Xb.gp(a.i,0);if(f){N=new cYb.yy(a.d);cxb(a.j,0)&&cYb.uy(N,a.j);cYb.fy(N,a.i);g&&$Xb.Au(a.i);}(qb||a.k==2)&&$Xb.Hm(a.i,true);};$Xb.Pt=function Pt(a,b,c,d,e){$Xb.Ot(a,b,c,0,c.length,d,e);};$Xb.Qt=function Qt(a,b){var c;return b==null?null:$Xb.Rt(a,YXb.mTb((c=b,YXb.hTb(),c)));};$Xb.Rt=function Rt(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o;h=yYb.j6(b,0);i=h==-1?-1:yYb.j6(b,h+1);if(i==-1)throw Hwb(new VXb.aA("Missing one or both separators ('>')."));if(yYb.j6(b,i+1)!=-1)throw Hwb(new VXb.aA("Found more than 2 separators ('>')."));n=new jYb.EF();o=0;for(f=o;f<h-1;f++){if(b[f]==46&&b[f+1]==46){if(f>o){l=new $Xb.Fu();$Xb.Ot(a,l,b,o,f,true,true);_Xb.Si(n.g,l);n.d=-1;}o=f+2;}}m=new $Xb.Fu();$Xb.Ot(a,m,b,o,h,true,true);_Xb.Si(n.g,m);n.d=-1;if(i-h>1){o=h+1;for(g=o;g<i-1;g++){if(b[g]==46&&b[g+1]==46){if(g>o){c=new $Xb.Fu();$Xb.Ot(a,c,b,o,g,true,true);_Xb.Si(n.a,c);}o=g+2;}}d=new $Xb.Fu();$Xb.Ot(a,d,b,o,i,true,true);_Xb.Si(n.a,d);}o=i+1;for(e=o;e<b.length-1;e++){if(b[e]==46&&b[e+1]==46){if(e>o){j=new $Xb.Fu();$Xb.Ot(a,j,b,o,e,true,true);_Xb.Si(n.f,j);n.d=-1;}o=e+2;}}k=new $Xb.Fu();$Xb.Ot(a,k,b,o,b.length,true,true);_Xb.Si(n.f,k);n.d=-1;return n;};$Xb.St=function St(a,b){var c,d,e,f;$Xb.el(a.i,b)==1&&$Xb.Fm(a.i,b,2);for(e=0;e<2;e++){c=$Xb.Vk(a.i,e,b);if($Xb.El(a.i,c)){$Xb.lm(a.i,c,false);--a.b;}for(f=0;f<$Xb.Sn(a.i,c);f++){d=$Xb.Tn(a.i,c,f);if(a.f[d]){a.f[d]=false;--a.c;}}}};$Xb.Tt=function Tt(a){var b,c,d,e,f,g,h;do{h=false;for(c=0;c<a.i.g;c++){if(a.f[c]){f=false;for(e=0;e<2;e++){b=false;d=$Xb.Vk(a.i,e,c);for(g=0;g<$Xb.Sn(a.i,d);g++){if(c!=$Xb.Tn(a.i,d,g)&&a.f[$Xb.Tn(a.i,d,g)]){b=true;break;}}if(!b){f=true;break;}}if(f){h=true;$Xb.St(a,c);}}}}while(h);};$Xb.Ut=function Ut(a,b){var c,d;if(!$Xb.is($Xb.Qk(a.i,b)))return false;if($Xb.Qk(a.i,b)==6){if(!$Xb.El(a.i,b))return false;if($Xb.zk(a.i,b)>0)return false;}c=$Xb.Bk(a.i,b)==null?0:$Xb.Ck(a.i,b)[0];d=$Xb.ao(a.i,b)-c;if(d<1)return false;if($Xb.Qk(a.i,b)==16||$Xb.Qk(a.i,b)==34||$Xb.Qk(a.i,b)==52){if($Xb.Sn(a.i,b)==2&&$Xb.zk(a.i,b)<=0)return false;if(d==2)return false;}return true;};$Xb.Vt=function Vt(a,b){a.j=b;};$Xb.Wt=function Wt(a,b){if(a.e){!a.n&&(a.n=new VXb.jIb());VXb.gIb(a.n,' ');VXb.gIb(a.n,b);}};$Xb.Xt=function Xt(){$Xb.Yt.call(this,0,false);};$Xb.Yt=function Yt(a,b){this.k=a&3;this.a=(a&16)==0;this.e=b;this.g=(a&8)!=0;this.d=2;(a&4)!=0&&(this.d|=1);this.g&&(this.d&=-3);};xxb(151,1,{},$Xb.Xt,$Xb.Yt);_.a=false;_.b=0;_.c=0;_.d=0;_.e=false;_.g=false;_.j=0;_.k=0;UXb.cmb=VFb(151);$Xb.Zt=function Zt(a,b){this.a=a;this.b=b;};xxb(209,1,{209:1},$Xb.Zt);_.a=0;_.b=0;UXb.amb=VFb(209);$Xb.$t=function $t(a,b,c){if(!a.c){if(a.e.a.length==4){a.c=true;return;}_Xb.Si(a.e,new $Xb.Zt(b,c));}};$Xb._t=function _t(a,b){var c,d,e;if(a.c)return 3;for(d=new _Xb.rOb(a.e);d.a<d.c.a.length;){c=_Xb.qOb(d);c.a!=2147483646&&c.a!=gZb&&(c.a=b[c.a]);}if(a.e.a.length==3)_Xb.Si(a.e,new $Xb.Zt(gZb,a.b));else if(a.e.a.length!=4)return 3;e=a.d^$Xb.au(a)?1:2;return e;};$Xb.au=function au(a){var b,c,d;c=false;for(b=1;b<a.e.a.length;b++){for(d=0;d<b;d++){_Xb.Xi(a.e,d).a>_Xb.Xi(a.e,b).a&&(c=!c);_Xb.Xi(a.e,d).b>_Xb.Xi(a.e,b).b&&(c=!c);}}return c;};$Xb.bu=function bu(a,b,c,d,e){if(d!=0&&d!=1){this.c=true;}else {this.a=a;this.b=b;this.d=e;this.e=new _Xb.kj();c!=-1&&$Xb.$t(this,c,b-1);c!=-1&&d==1&&$Xb.$t(this,2147483646,b+1);}};xxb(251,1,{251:1},$Xb.bu);_.a=0;_.b=0;_.c=false;_.d=false;UXb.bmb=VFb(251);$Xb.cu=function cu(a,b,c,d){a.a=false;a.d=c;if(CFb(b[c]&pZb)){a.c=a.b=$Xb.du(a);return a.d-c;}if(b[c]==123&&CFb(b[c+1]&pZb)){++a.d;a.c=$Xb.du(a);if(b[a.d++]!=45)return 0;if(!CFb(b[a.d]&pZb))return 0;a.b=$Xb.du(a);if(b[a.d++]!=125)return 0;return a.d-c;}a.c=1;a.b=d;a.a=true;return 0;};$Xb.du=function du(a){var b;b=a.e[a.d++]-48;CFb(a.e[a.d]&pZb)&&(b=10*b+(a.e[a.d++]-48));return b;};$Xb.eu=function eu(a){return '{'+a.c+'-'+a.b+'}';};$Xb.fu=function fu(a){this.e=a;};xxb(385,1,{},$Xb.fu);_.lb=function gu(){return $Xb.eu(this);};_.a=false;_.b=0;_.c=0;_.d=0;UXb.dmb=VFb(385);$Xb.hu=function hu(a){a.c=new _Xb.kj();};$Xb.iu=function iu(a,b){var c,d,e,f;f=a.c.a.length;if(f==0){_Xb.Ri(a.c,0,b);return 0;}e=1;while(2*e<=f)e<<=1;d=e;--e;while(d!=0){d>>=1;if(e>=f){e-=d;continue;}c=VXb.yHb(b,_Xb.Xi(a.c,e));if(c==0)return -1;if(d==0)break;c<0?e-=d:e+=d;}e<f&&VXb.yHb(b,_Xb.Xi(a.c,e))>0&&++e;_Xb.Ri(a.c,e,b);return e;};$Xb.ju=function ju(a,b){var c,d,e,f;f=a.c.a.length;if(f==0)return -1;e=1;while(2*e<=f)e<<=1;d=e;--e;while(d!=0){d>>=1;if(e>=f){e-=d;continue;}c=VXb.yHb(b,_Xb.Xi(a.c,e));if(c==0)return e;if(d==0)break;c<0?e-=d:e+=d;}return -1;};$Xb.ku=function ku(){$Xb.hu(this);};xxb(115,1,b0b,$Xb.ku);_.Pb=function lu(a){return $Xb.ju(this,a);};UXb.emb=VFb(115);$Xb.mu=function mu(a,b){$Xb.nk(a,b);!!a.d&&(b.T=0);};$Xb.nu=function nu(a,b){var c,d,e,f;$Xb.wn(a,b);if((b&~a.T)==0)return;(a.T&15)!=0&&a.q>1&&$Xb.Ih(a.J[0],a.J[1])&&cYb.fy(new cYb.yy(0),a);a.c&&(b|=128);for(c=0;c<a.q;c++)a.u[c]&=-67223560;for(d=0;d<a.g;d++)a.F[d]&=-64;e=0;f=0;if((b&32)!=0){e=32;f=1;}else if((b&64)!=0){e=64;f=3;}if((b&128)!=0){e|=128;f|=32;}a.d=new $Xb.ig(a,f);$Xb.dg(a.d);$Xb.eg(a.d);$Xb.cg(a.d);$Xb.Eu(a)&&(a.d=new $Xb.ig(a,f));a.T|=24|e;};$Xb.ou=function ou(a,b){return $Xb.Sf(a.d,b);};$Xb.pu=function pu(a,b){return $Xb.Jf(a.d,b);};$Xb.qu=function qu(a){var b;$Xb.nu(a,31);b=a.I&pZb;switch(a.I&I$b){case oZb:return null;case T$b:return b==1?'meso':''+b+' meso diastereomers';case 0:return 'unknown chirality';case U$b:return 'both enantiomers';case G$b:return 'this enantiomer';case 327680:return 'this or other enantiomer';case h$b:return 'two epimers';default:return b==1?'one stereo isomer':''+b+' stereo isomers';}};$Xb.ru=function ru(a){var b;b=new $Xb.Gu(a.q,a.r);$Xb.mk(a,b);return b;};$Xb.su=function su(a){var b,c,d,e,f,g,h;$Xb.nu(a,15);g=Sjb(UXb.llb,yZb,6,3,15,1);for(c=0;c<a.f;c++){if((a.u[c]&l_b)!=0){h=(a.u[c]&E$b)>>18;h!=0&&(g[h]=$wnd.Math.max(g[h],(a.u[c]&E$b)>>18!=1&&(a.u[c]&E$b)>>18!=2?-1:(a.u[c]&h_b)>>20));}}for(e=0;e<a.g;e++){if(((a.F[e]&3)==1||(a.F[e]&3)==2)&&a.H[e]==1){h=(a.F[e]&768)>>8;h!=0&&(g[h]=$wnd.Math.max(g[h],(a.F[e]&768)>>8!=1&&(a.F[e]&768)>>8!=2?-1:(a.F[e]&i_b)>>10));}}f=Sjb(UXb.llb,Q$b,8,3,0,2);f[1]=Sjb(UXb.llb,yZb,6,1+g[1],15,1);f[2]=Sjb(UXb.llb,yZb,6,1+g[2],15,1);for(b=0;b<a.f;b++){if((a.u[b]&l_b)!=0){h=(a.u[b]&E$b)>>18;h!=0&&++f[h][(a.u[b]&E$b)>>18!=1&&(a.u[b]&E$b)>>18!=2?-1:(a.u[b]&h_b)>>20];}}for(d=0;d<a.g;d++){if(((a.F[d]&3)==1||(a.F[d]&3)==2)&&a.H[d]==1){h=(a.F[d]&768)>>8;h!=0&&++f[h][(a.F[d]&768)>>8!=1&&(a.F[d]&768)>>8!=2?-1:(a.F[d]&i_b)>>10];}}return f;};$Xb.tu=function tu(a){var b,c;b=Sjb(UXb.llb,yZb,6,a.q,15,1);c=$Xb.$n(a,b,false,false);return $Xb.uu(a,b,c);};$Xb.uu=function uu(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r;q=Sjb(UXb.fmb,R_b,24,c,0,1);g=Sjb(UXb.llb,yZb,6,c,15,1);j=Sjb(UXb.llb,yZb,6,c,15,1);f=Sjb(UXb.llb,yZb,6,a.q,15,1);for(e=0;e<a.q;e++)b[e]!=-1&&(f[e]=g[b[e]]++);for(i=0;i<a.r;i++){o=b[a.D[0][i]];p=b[a.D[1][i]];o==p&&o!=-1&&++j[o];}for(r=0;r<c;r++){q[r]=new $Xb.Gu(g[r],j[r]);$Xb.mu(a,q[r]);}for(d=0;d<a.q;d++)b[d]!=-1&&$Xb.jk(a,q[b[d]],d,0,0);for(h=0;h<a.r;h++){o=b[a.D[0][h]];p=b[a.D[1][h]];o==p&&o!=-1&&$Xb.lk(a,q[o],h,0,0,f,false);}for(l=q,m=0,n=l.length;m<n;++m){k=l[m];$Xb.Yl(k,1);$Xb.Yl(k,2);}return q;};$Xb.vu=function vu(a){$Xb.nu(a,15);!a.d&&(a.f<2||!$Xb.Ih(a.J[0],a.J[1]))&&(a.d=new $Xb.hg(a));return !a.d?null:$Xb.Nf(a.d);};$Xb.wu=function wu(a){$Xb.nu(a,15);!a.d&&(a.f<2||!$Xb.Ih(a.J[0],a.J[1]))&&(a.d=new $Xb.hg(a));return !a.d?null:$Xb.Kf(a.d);};$Xb.xu=function xu(a){var b,c;$Xb.nu(a,31);c=0;for(b=0;b<a.f;b++)(a.u[b]&3)!=0&&(a.u[b]&4)==0&&++c;return c;};$Xb.yu=function yu(a,b){return $Xb.Rf(a.d,b);};$Xb.zu=function zu(a,b){a.c=b;a.T&=-144;};$Xb.Au=function Au(a){$Xb.nu(a,31);!!a.d&&$Xb.fg(a.d);};$Xb.Bu=function Bu(a){var b,c;$Xb.nu(a,15);a.L=false;for(b=0;b<a.q;b++){a.u[b]&=o_b;(a.u[b]&3)!=0?a.u[b]|=k_b:a.u[b]&=n_b;}for(c=0;c<a.r;c++)(a.F[c]&3)!=0&&$Xb.bl(a,c)==2?a.H[c]=386:a.H[c]&=-385;a.T&=-249;};$Xb.Cu=function Cu(a,b,c){var d,e,f,g,h,i,j,k,l;l=a.u[b]&3;if(l==1||l==2){h=false;if(a.o[b]==2&&a.j[b]==2&&a.n[b][0]==2&&a.n[b][1]==2&&a.C[b]<=7){for(g=0;g<a.j[b];g++){d=a.i[b][g];k=0;j=Sjb(UXb.llb,yZb,6,3,15,1);for(i=0;i<a.j[d];i++){j[k]=a.i[d][i];j[k]!=b&&++k;}k==2&&j[0]<j[1]^c[j[0]]<c[j[1]]&&(h=!h);}}else {for(g=1;g<a.j[b];g++){for(i=0;i<g;i++){e=a.i[b][g];f=a.i[b][i];e<f^c[e]<c[f]&&(h=!h);}}}h&&(l=l==1?2:1);}return l;};$Xb.Du=function Du(a){var b,c,d,e,f,g;$Xb.mp(a);$Xb.nu(a,31);for(d=0;d<a.f;d++){if(((a.u[d]&E$b)>>18==1||(a.u[d]&E$b)>>18==2)&&((a.u[d]&l_b)==0||(a.u[d]&3)==3))throw Hwb(new VXb.aA(c0b));if((a.u[d]&oZb)!=0)throw Hwb(new VXb.aA(d0b));if(((a.u[d]&3)==1||(a.u[d]&3)==2)&&a.o[d]==0){b=Sjb(UXb.jlb,wZb,6,a.j[d],15,1);for(f=0;f<a.j[d];f++)b[f]=$Xb.Uk(a,d,a.i[d][f]);for(e=1;e<a.j[d];e++)if(!$Xb.Ml(a,a.k[d][e],d))for(g=0;g<e;g++)if(!$Xb.Ml(a,a.k[d][g],d)){c=$wnd.Math.abs($Xb.gn(b[e],b[g]));if(c<0.08||c>u_b)throw Hwb(new VXb.aA(e0b));}}}};$Xb.Eu=function Eu(a){var b,c,d,e,f,g,h;h=false;for(c=0;c<a.f;c++)((a.u[c]&l_b)==0||(a.u[c]&3)==3)&&(a.u[c]&=o_b);for(f=0;f<a.g;f++)($Xb.bl(a,f)!=1||(a.F[f]&3)==0||(a.F[f]&3)==3)&&(a.F[f]&=-32513);if(a.L){if((a.I&I$b)!=T$b){g=Sjb(UXb.Cwb,KZb,6,a.f,16,1);for(d=0;d<a.f;d++)(a.u[d]&l_b)!=0&&(a.u[d]&3)!=3&&(a.u[d]&E$b)>>18==1&&(g[d]=true);for(e=0;e<a.f;e++){if((a.u[e]&l_b)!=0&&(a.u[e]&3)!=3){$Xb.hm(a,e,1,0);h=true;}}for(b=0;b<a.f;b++){if(g[b]){$Xb.nm(a,b,1,false);$Xb.hm(a,b,1,-1);h=true;}}}a.L=false;}$Xb.Yl(a,1);$Xb.Yl(a,2);return h;};$Xb.Fu=function Fu(){$Xb.Sj();$Xb.op.call(this);};$Xb.Gu=function Gu(a,b){$Xb.Sj();$Xb.pp.call(this,a,b);};$Xb.Hu=function Hu(a){$Xb.Sj();$Xb.qp.call(this,a);};xxb(24,97,f0b,$Xb.Fu,$Xb.Gu,$Xb.Hu);_.Kb=function Iu(a){$Xb.mu(this,a);};_.Mb=function Ju(a){$Xb.nu(this,a);};_.c=false;UXb.fmb=VFb(24);$Xb.Lu=function Lu(a,b){var c,d,e,f,g,h,i,j,k,l,m;h=new _Xb.kj();$Xb.nu(b,1);j=Sjb(UXb.Cwb,KZb,6,b.f,16,1);for(c=0;c<b.f;c++){if(a.f[c]&&($Xb.Qk(a.i,c)==7||$Xb.Qk(a.i,c)==8||$Xb.Qk(a.i,c)==16||$Xb.Qk(a.i,c)==34||$Xb.Qk(a.i,c)==52)){j[c]=true;for(i=0;i<b.j[c];i++){d=b.i[c][i];f=b.k[c][i];l=b.n[c][i];if(b.o[d]!=0&&b.o[c]<l){j[d]=true;_Xb.Si(h,VXb.UGb(f));for(k=0;k<b.j[d];k++){e=b.i[d][k];if(!j[e]){j[e]=true;g=b.k[d][k];m=b.n[d][k];if(b.o[d]+2==l+m){_Xb.Si(h,VXb.UGb(g));l>=m&&(b.o[e]<m?$Xb.Uu(b,e)&&$Xb.Ou(a,b,e,true,false,j,h):$Xb.Ou(a,b,e,true,true,j,h));m>=l&&$Xb.Uu(b,c)&&$Xb.Ou(a,b,e,false,false,j,h);if(a.f[e]&&($Xb.Qk(a.i,e)==5||$Xb.Qk(a.i,e)==6||$Xb.Qk(a.i,e)==7||$Xb.Qk(a.i,e)==8||$Xb.Qk(a.i,e)==16||$Xb.Qk(a.i,e)==34||$Xb.Qk(a.i,e)==52)&&b.o[e]<m){l<=2&&m>=2&&$Xb.Uu(b,c)&&$Xb.Mu(a,b,f,g);l>=2&&m<=2&&$Xb.Uu(b,e)&&$Xb.Mu(a,b,g,f);}_Xb.cj(h,h.a.length-1);}j[e]=false;}}_Xb.cj(h,h.a.length-1);j[d]=false;}}j[c]=false;}}};$Xb.Mu=function Mu(a,b,c,d){var e;e=new $Xb.$u(a,b);$Xb.Zu(e,c,$Xb.bl(b,c)==1?2:3);$Xb.Zu(e,d,$Xb.bl(b,d)==2?1:2);a.g[c]=true;a.g[d]=true;_Xb.$Rb(a.e,e)&&(_Xb.MNb(a.d,e),true);};$Xb.Nu=function Nu(a,b){_Xb.$Rb(a.e,b)&&(_Xb.MNb(a.d,b),true);};$Xb.Ou=function Ou(a,b,c,d,e,f,g){var h,i,j,k,l,m,n,o,p,q,r,s;for(n=0;n<b.j[c];n++){h=b.i[c][n];if(!f[h]){k=b.k[c][n];r=$Xb.bl(b,k);if(d&&r>=2||!d&&r<=2){f[h]=true;g.add(VXb.UGb(k));for(o=0;o<b.j[h];o++){i=b.i[h][o];if(!f[i]){l=b.k[h][o];s=$Xb.bl(b,l);if(b.o[h]+2==r+s&&(d&&s<=2||!d&&s>=2)){f[i]=true;g.add(VXb.UGb(l));if(a.f[i]&&($Xb.Qk(a.i,i)==5||$Xb.Qk(a.i,i)==6||$Xb.Qk(a.i,i)==7||$Xb.Qk(a.i,i)==8||$Xb.Qk(a.i,i)==16||$Xb.Qk(a.i,i)==34||$Xb.Qk(a.i,i)==52)&&(!d||$Xb.Uu(b,i))){m=new $Xb.$u(a,b);for(p=0;p<g.a.length;p++){j=(YXb.zTb(p,g.a.length),g.a[p]).a;q=p<2?d^(p&1)==0:e^(p&1)==0;q?$Xb.Zu(m,j,$Xb.bl(b,j)==1?2:3):$Xb.Zu(m,j,$Xb.bl(b,j)==2?1:2);a.g[j]=true;}_Xb.$Rb(a.e,m)&&(_Xb.MNb(a.d,m),true);}else {$Xb.Ou(a,b,i,d,e,f,g);}_Xb.cj(g,g.a.length-1);f[i]=false;}}}_Xb.cj(g,g.a.length-1);f[h]=false;}}}return false;};$Xb.Pu=function Pu(a){var b,c,d,e,f,g,h,i,j,k,l;a.b=Sjb(UXb.llb,yZb,6,a.i.f,15,1);h=Sjb(UXb.llb,yZb,6,a.i.f,15,1);d=Sjb(UXb.Cwb,KZb,6,a.i.g,16,1);l=0;for(c=0;c<a.i.g;c++){if(!d[c]&&a.g[c]){++l;a.b[$Xb.Vk(a.i,0,c)]=l;a.b[$Xb.Vk(a.i,1,c)]=l;d[c]=true;for(j=0;j<2;j++){b=$Xb.Vk(a.i,j,c);a.b[b]=l;g=0;i=0;h[0]=b;while(g<=i){for(k=0;k<$Xb.Sn(a.i,h[g]);k++){f=$Xb.Tn(a.i,h[g],k);if(!d[f]&&a.g[f]){d[f]=true;e=$Xb.Rn(a.i,h[g],k);if(a.b[e]==0){a.b[e]=l;h[++i]=e;}}}++g;}}}}a.j=l;};$Xb.Qu=function Qu(a){var b,c,d;a.n=Sjb(UXb.llb,yZb,6,a.j,15,1);a.k=Sjb(UXb.llb,yZb,6,a.j,15,1);a.o=Sjb(UXb.llb,yZb,6,a.j,15,1);for(b=0;b<a.i.f;b++){if(a.b[b]!=0){d=a.b[b]-1;a.a!=null&&(a.k[d]+=a.a[b]);a.c!=null&&(a.o[d]+=a.c[b]);}}for(c=0;c<a.i.g;c++){a.g[c]&&$Xb.bl(a.i,c)==2&&(a.n[a.b[$Xb.Vk(a.i,0,c)]-1]+=2);}};$Xb.Ru=function Ru(a){var b,c,d,e;for(d=0;d<a.i.r;d++){for(e=0;e<2;e++){b=$Xb.Vk(a.i,e,d);c=$Xb.Vk(a.i,1-e,d);if($Xb.Qk(a.i,b)==1&&$Xb.Jk(a.i,b)>1&&$Xb.Qk(a.i,c)>1&&a.b[c]!=0){if($Xb.Jk(a.i,b)==2){a.a==null&&(a.a=Sjb(UXb.llb,yZb,6,a.i.q,15,1));++a.a[c];}else {a.c==null&&(a.c=Sjb(UXb.llb,yZb,6,a.i.q,15,1));++a.c[c];}$Xb.Ol(a.i,b);}}}(a.a!=null||a.c!=null)&&$Xb.tk(a.i);};$Xb.Su=function Su(a){var b;a.e=new _Xb.dSb();a.d=new _Xb.YNb();$Xb.Nu(a,new $Xb.$u(a,a.i));b=$Xb.ru(a.i);while(!_Xb.QNb(a.d)){$Xb.Yu(_Xb.SNb(a.d),b);$Xb.Lu(a,b);if(a.e.a.c>=$Xb.Ku){VXb.oIb();'Tautomer count exceeds maximum: '+$Xb.Nf(new $Xb.hg(a.i));break;}}};$Xb.Tu=function Tu(a){var b,c,d,e,f,g,h,i,j,k;if(a.e.a.c==1)return a.i;j=$Xb.ru(a.i);$Xb.Hm(j,true);$Xb.nu(j,7);for(e=0;e<j.g;e++){if(a.g[e]){j.H[e]=1;j.T=0;$Xb.Em(j,e,3,true);}}for(c=0;c<j.f;c++){if(a.b[c]!=0&&$Xb.jo(a.i,c)<4){$Xb.tn(j,c);j.u[c]&=n_b;j.T&=7;$Xb.hm(j,c,0,-1);}}h=Sjb(UXb.llb,yZb,6,a.j,15,1);i=Sjb(UXb.llb,yZb,6,a.j,15,1);d=new $Xb.hg(j).d;for(b=0;b<j.f;b++){if(a.b[b]!=0){k=a.b[b]-1;if(i[k]<d[b]){i[k]=d[b];h[k]=b;}}}for(f=0;f<a.j;f++){g=''+a.n[f]+'|'+a.k[f]+'|'+a.o[f];$Xb.fm(j,h[f],g);}return j;};$Xb.Uu=function Uu(a,b){if(a.e[b]-$Xb.jo(a,b)+$Xb.fo(a,b)<=0)return false;if($Xb.Cl(a,b))return true;if(a.o[b]!=0)return false;return true;};$Xb.Vu=function Vu(a){var b,c,d,e,f,g,h,i;$Xb.nu(a.i,1);h=a.i.f;do--h;while(h>=0&&$Xb.Qk(a.i,h)==1);for(b=0;b<h;b++){if($Xb.Qk(a.i,b)==1){$Xb.Sm(a.i,b,h);do--h;while($Xb.Qk(a.i,h)==1);}}if(h==a.i.f-1)return;g=Sjb(UXb.Cwb,KZb,6,a.i.g,16,1);for(f=0;f<a.i.g;f++){c=$Xb.Vk(a.i,0,f);d=$Xb.Vk(a.i,1,f);($Xb.Qk(a.i,c)==1||$Xb.Qk(a.i,d)==1)&&(g[f]=true);}i=a.i.g;do--i;while(i>=0&&g[i]);for(e=0;e<i;e++){if(g[e]){$Xb.Tm(a.i,e,i);g[e]=false;do--i;while(g[i]);}}};$Xb.Wu=function Wu(a){var b,c;this.i=$Xb.ru(a);$Xb.Vu(this);$Xb.nu(this.i,7);this.g=Sjb(UXb.Cwb,KZb,6,this.i.g,16,1);this.f=Sjb(UXb.Cwb,KZb,6,this.i.f,16,1);for(b=0;b<this.i.f;b++){c=$Xb.en($Xb.Qk(this.i,b))[0];this.f[b]=$Xb.jo(this.i,b)<c;}$Xb.Su(this);$Xb.Pu(this);$Xb.Ru(this);$Xb.Qu(this);};xxb(274,1,{},$Xb.Wu);_.j=0;$Xb.Ku=g0b;UXb.hmb=VFb(274);$Xb.Xu=function Xu(a,b){return yYb.v6(a.a,b.a);};$Xb.Yu=function Yu(a,b){var c,d;for(d=0;d<a.b.i.g;d++){if(a.b.g[d]){c=3&a.a[d>>4]>>2*(d&15);$Xb.Fm(b,d,c==1?1:c==2?a.b.g[d]&&!$Xb.Yo(a.b.i,d)?386:2:c==3?4:32);}}};$Xb.Zu=function Zu(a,b,c){var d,e;d=b>>4;e=2*(b&15);a.a[d]&=~(3<<e);a.a[d]|=c<<e;};$Xb.$u=function $u(a,b){var c;this.b=a;this.a=Sjb(UXb.llb,yZb,6,(a.i.g+15)/16|0,15,1);for(c=0;c<a.i.g;c++)this.a[c>>4]|=$wnd.Math.min(3,$Xb.bl(b,c))<<2*(c&15);};xxb(183,1,{183:1,18:1},$Xb.$u);_.Eb=function _u(a){return $Xb.Xu(this,a);};UXb.gmb=VFb(183);$Xb.av=function av(a){var b,c,d,e,f;c=VXb.HHb(a,UHb(38));if(c==-1)return a;e=0;f=new VXb._Hb();while(c!=-1){VXb.$Hb(f,(YXb.FTb(e,c,YXb.LTb(a).length),YXb.LTb(a).substr(e,c-e)));YXb.GTb(c+1,YXb.LTb(a).length);if(YXb.LTb(a).charCodeAt(c+1)==38){f.a+='&';e=c+2;}else {b=(YXb.GTb(c+1,YXb.LTb(a).length),YXb.LTb(a).charCodeAt(c+1));b=b-(b<65?48:b<97?65:97);d=(YXb.GTb(c+2,YXb.LTb(a).length),YXb.LTb(a).charCodeAt(c+2));d=d-(d<65?48:d<97?65:97);VXb.YHb(f,16*b+d&pZb);e=c+3;}c=VXb.IHb(a,UHb(38),e);}VXb.$Hb(f,(YXb.GTb(e,YXb.LTb(a).length+1),YXb.LTb(a).substr(e)));return f.a;};$Xb.bv=function bv(a){var b,c;c=new VXb._Hb();for(b=0;b<YXb.LTb(a).length;b++){switch(YXb.GTb(b,YXb.LTb(a).length),YXb.LTb(a).charCodeAt(b)){case 38:c.a+='&&';break;case 9:c.a+='&09';break;case 10:c.a+='&0A';break;case 32:c.a+='&20';break;default:VXb.YHb(c,(YXb.GTb(b,YXb.LTb(a).length),YXb.LTb(a).charCodeAt(b)));}}return c.a;};$Xb.cv=function cv(a,b,c){a.e[0].a=b;a.e[0].b=c;};$Xb.dv=function dv(b,c){try{b.a=AGb(c);}catch(a){a=Gwb(a);if(!Zkb(a,52))throw Hwb(a);}};$Xb.ev=function ev(b,c){try{b.b=VXb.nGb(c,E_b,gZb);}catch(a){a=Gwb(a);if(!Zkb(a,52))throw Hwb(a);}};$Xb.fv=function fv(a,b,c,d){a.c=b;a.a=c;a.b=d;};$Xb.gv=function gv(b,c){try{b.e[0].a=AGb(c);}catch(a){a=Gwb(a);if(!Zkb(a,52))throw Hwb(a);}};$Xb.hv=function hv(b,c){try{b.e[0].b=AGb(c);}catch(a){a=Gwb(a);if(!Zkb(a,52))throw Hwb(a);}};$Xb.iv=function iv(){$Xb.kv.call(this,new lYb.AG());};$Xb.jv=function jv(a){var b,c,d,e;$Xb.iv.call(this);b=0;while(b!=-1){c=YXb.LTb(a).indexOf('="',b);if(c==-1)break;d=(YXb.FTb(b+1,c,YXb.LTb(a).length),YXb.LTb(a).substr(b+1,c-(b+1)));b=YXb.LTb(a).indexOf('"',c+2);e=b==-1?(YXb.GTb(c+1,YXb.LTb(a).length+1),YXb.LTb(a).substr(c+1)):(YXb.FTb(c+1,b,YXb.LTb(a).length),YXb.LTb(a).substr(c+1,b-(c+1)));VXb.DHb(d,b_b)?this.c=$Xb.av(e):VXb.DHb(d,'x')?$Xb.gv(this,e):VXb.DHb(d,'y')?$Xb.hv(this,e):VXb.DHb(d,'size')?$Xb.dv(this,e):VXb.DHb(d,h0b)&&$Xb.ev(this,e);}};$Xb.kv=function kv(a){this.c='';this.a=9;this.b=0;this.e=Sjb(UXb.Bnb,kZb,33,1,0,1);this.e[0]=a;};xxb(188,229,{229:1},$Xb.iv,$Xb.jv);_.Ab=function lv(){var a;a=new $Xb.iv();$Xb.fv(a,this.c,this.a,this.b);$Xb.cv(a,this.e[0].a,this.e[0].b);a.d=this.d;return a;};_.Bb=function mv(){var a;a=new VXb.jIb();VXb.gIb(a,' text="'+$Xb.bv(this.c)+'"');VXb.gIb(a,' x="'+this.e[0].a+'"');VXb.gIb(a,' y="'+this.e[0].b+'"');this.a!=9&&VXb.gIb(a,' size="'+this.a+'"');this.b!=0&&VXb.gIb(a,' style="'+this.b+'"');return a.a;};_.Cb=function nv(){return b_b;};_.a=0;_.b=0;UXb.imb=VFb(188);$Xb.ov=function ov(a){a.b=new _Xb.kj();a.a=new _Xb.kj();};$Xb.pv=function pv(a,b){var c,d;c=$Xb.iu(a,b);if(c==-1)return -1;d=a.b.a.length;_Xb.Si(a.b,b);_Xb.Ri(a.a,c,new VXb.IGb(d));return d;};$Xb.qv=function qv(){$Xb.ku.call(this);$Xb.ov(this);};xxb(384,115,b0b,$Xb.qv);_.Pb=function rv(a){var b;b=$Xb.ju(this,a);if(b==-1)return -1;return _Xb.Xi(this.a,b).a;};UXb.jmb=VFb(384);aYb.sv=function sv(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N;K=$Xb.so(a.e);L=_Xb.Xi(K.j,b).length;I=_Xb.Xi(K.i,b);J=_Xb.Xi(K.j,b);C=true;for(r=1;r<L;r++){if(aYb.Hv(a.b,J[r])!=aYb.Hv(a.b,J[0])){C=false;break;}}if(C){f=(L-2)*i0b/L;for(s=0;s<L;s++)aYb.xv(a,I[s],J[s],J[s==0?L-1:s-1],f);return;}G=Sjb(UXb.klb,s_b,6,L,15,1);e=0;for(t=0;t<L;t++){G[t]=$Xb.In(a.e,I[t])==0?1.9106119386631804:$Xb.In(a.e,I[t])==1?2.094499897810209:i0b;e+=G[t];}d=((L-2)*i0b-e)/L;for(u=0;u<L;u++)G[u]+=d;k=Sjb(UXb.klb,s_b,6,L,15,1);for(v=1;v<L;v++)k[v]=k[v-1]+i0b-G[v];h=Sjb(UXb.klb,s_b,6,L,15,1);for(g=0;g<100;g++){M=0;N=0;for(s=0;s<L;s++){M+=aYb.Hv(a.b,J[s])*$wnd.Math.sin(k[s]);N+=aYb.Hv(a.b,J[s])*$wnd.Math.cos(k[s]);}n=$Xb.fn(0,0,M,N);p=$wnd.Math.sqrt(M*M+N*N);F=-1;D=0;for(w=0;w<L;w++){A=w==0?L-1:w-1;B=w+1==L?0:w+1;i=$Xb.gn(k[w],k[A]);j=$Xb.gn(k[B],k[w]);H=$Xb.gn(G[w],G[B]);h[w]=2*i-2*j+2*H;o=$wnd.Math.cos(k[w]-j0b-n);m=p*o-k0b*h[w];if($wnd.Math.abs(m)>$wnd.Math.abs(D)){D=m;F=w;}}l=$wnd.Math.exp(-5*g/100);k[F]+=l*D;}for(q=0;q<L;q++){A=q==0?L-1:q-1;c=k[A]+i0b-k[q];c>OZb&&(c-=OZb);aYb.xv(a,I[q],J[A],J[q],c);}};aYb.tv=function tv(a,b){var c,d,e,f,g,h,i,j,k;i=$Xb.so(a.e);j=_Xb.Xi(i.j,b).length;h=_Xb.Xi(i.j,b);k=false;for(e=0;e<j;e++){if(a.f[h[e]]==0){k=true;break;}}if(k){c=(180*j-360)/j*0.01745329238474369;g=_Xb.Xi(i.i,b);for(f=0;f<j;f++){aYb.xv(a,g[f],h[f==0?j-1:f-1],h[f],c);}if(j<=4){for(d=0;d<j;d++)a.f[h[d]]+=j;}}};aYb.uv=function uv(a,b,c,d){var e,f,g,h;f=-1;g=-1;for(h=0;h<$Xb.Dn(a.e,b);h++){e=$Xb.Rn(a.e,b,h);if(e==c||e==d){if(g==-1){g=h;}else {f=h;break;}}}return a.a[b][f][g];};aYb.vv=function vv(a,b,c,d){return c<d?a.a[b][d][c]:a.a[b][c][d];};aYb.wv=function wv(a,b){var c,d,e,f,g,h,i;d=Sjb(UXb.Cwb,KZb,6,$Xb.Sn(a.e,b),16,1);i=0;for(e=0;e<$Xb.Sn(a.e,b);e++){h=0;g=-1;for(f=0;f<$Xb.Sn(a.e,b);f++){if(!d[f]){c=$Xb.Tn(a.e,b,f);if(h<a.f[c]){h=a.f[c];g=f;}}}if(h==0)return i;i<<=8;i+=h;d[g]=true;}return i;};aYb.xv=function xv(a,b,c,d,e){var f,g,h,i;f=-1;g=-1;for(i=0;i<$Xb.Dn(a.e,b);i++){h=$Xb.Tn(a.e,b,i);if(h==c||h==d){if(f==-1){f=i;}else {g=i;break;}}}if(a.a[b][g][f]==0){a.a[b][g][f]=e;a.d[b]+=e;++a.c[b];}};aYb.yv=function yv(a,b,c,d,e){var f,g,h,i,j,k;f=$Xb.Dn(a.e,b);i=$Xb.Sn(a.e,b);for(j=1;j<f;j++){g=j<i?a.f[$Xb.Tn(a.e,b,j)]:0;for(k=0;k<j;k++){if(a.a[b][j][k]==0){h=k<i?a.f[$Xb.Tn(a.e,b,k)]:0;(g==c&&h==d||g==d&&h==c)&&(a.a[b][j][k]=e);}}}};aYb.zv=function zv(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A;this.b=b;this.e=a;this.a=Sjb(UXb.klb,aZb,679,this.e.f,0,3);for(e=0;e<this.e.f;e++){this.a[e]=Sjb(UXb.klb,{679:1,4:1,9:1,5:1,7:1},59,$Xb.Dn(this.e,e),0,2);for(i=1;i<$Xb.Dn(this.e,e);i++)this.a[e][i]=Sjb(UXb.klb,s_b,6,i,15,1);}this.c=Sjb(UXb.llb,yZb,6,this.e.f,15,1);this.d=Sjb(UXb.klb,s_b,6,this.e.f,15,1);this.f=Sjb(UXb.llb,yZb,6,this.e.g,15,1);w=$Xb.so(this.e);m=Sjb(UXb.Cwb,KZb,6,w.i.a.length,16,1);$Xb.Gr(w,m,Sjb(UXb.Cwb,KZb,6,w.i.a.length,16,1),Sjb(UXb.llb,yZb,6,w.i.a.length,15,1),true);for(h=3;h<=7;h++){for(r=0;r<w.i.a.length;r++){A=_Xb.Xi(w.j,r).length;A==h&&(m[r]?aYb.sv(this,r):A<=4&&aYb.tv(this,r));}}l=Sjb(UXb.Cwb,KZb,6,this.e.f,16,1);for(q=0;q<w.i.a.length;q++)if(m[q])for(t=_Xb.Xi(w.i,q),u=0,v=t.length;u<v;++u){s=t[u];l[s]=true;}f=$jb(Mjb(UXb.llb,1),yZb,6,15,[0,0,1,3,6,10,15,21]);for(d=0;d<this.e.f;d++){g=$Xb.Dn(this.e,d);if(g>4){for(i=1;i<g;i++)for(o=0;o<i;o++)this.a[d][i][o]=j0b;this.c[d]=f[g];continue;}if(this.c[d]==f[g])continue;if($Xb.Xo(this.e,d)&&(l[d]||$Xb.Mn(this.e,d)<=4&&$Xb.In(this.e,d)>0)){if(g>2){if(this.c[d]==1){$Xb.Qk(this.e,d)<=14?c=(l0b-this.d[d])/2:c=m0b+(m0b-this.d[d])*0.18000000715255737;}else {c=l0b-this.d[d];if(g>3){if(this.c[d]==2){n=Sjb(UXb.Cwb,KZb,6,$Xb.Dn(this.e,d),16,1);for(j=1;j<g;j++){for(p=0;p<j;p++){if(this.a[d][j][p]!=0){n[j]=!n[j];n[p]=!n[p];}}}for(k=0;k<g;k++){if(n[k]){for(p=k+1;p<g;p++){if(n[p]){this.a[d][p][k]=c;break;}}break;}}}c=j0b;}}for(i=1;i<g;i++)for(o=0;o<i;o++)this.a[d][i][o]==0&&(this.a[d][i][o]=c);}}else if($Xb.Xo(this.e,d)&&$Xb.Mn(this.e,d)<=4){switch(aYb.wv(this,d)){case 771:aYb.yv(this,d,0,3,2.0653998851776123);aYb.yv(this,d,0,0,1.9814722631346626);break;case 1028:aYb.yv(this,d,0,4,1.9797999858856201);aYb.yv(this,d,0,0,1.94691481878138);break;case 393987:aYb.yv(this,d,0,3,n0b);aYb.yv(this,d,0,6,n0b);aYb.yv(this,d,3,3,1.7229016938441077);break;case 459779:aYb.yv(this,d,0,3,o0b);aYb.yv(this,d,0,4,o0b);aYb.yv(this,d,0,7,o0b);aYb.yv(this,d,3,4,1.9322539839360076);break;case 525316:aYb.yv(this,d,0,4,p0b);aYb.yv(this,d,0,8,p0b);aYb.yv(this,d,4,4,1.99944913298566);case 394758:aYb.yv(this,d,0,6,2.526099920272827);break;case 460550:aYb.yv(this,d,0,6,q0b);aYb.yv(this,d,0,7,q0b);break;case 526087:aYb.yv(this,d,0,7,r0b);aYb.yv(this,d,0,8,r0b);break;case 526344:aYb.yv(this,d,0,8,2.186300039291382);break;case 50529027:aYb.yv(this,d,3,3,2.4189000129699707);break;case 67371779:aYb.yv(this,d,3,4,2.2298998832702637);break;case 67372036:aYb.yv(this,d,4,4,2.094399929046631);break;case 101057283:aYb.yv(this,d,3,6,1.839926051241747);aYb.yv(this,d,3,3,2.9061476191098734);break;case 117834755:aYb.yv(this,d,3,4,2.812249087174905);aYb.yv(this,d,3,7,1.7910569124592968);aYb.yv(this,d,4,6,2.1224948975613245);break;case 134677507:aYb.yv(this,d,3,4,2.642428360523752);aYb.yv(this,d,3,8,2.027723514585844);aYb.yv(this,d,4,7,2.251474717631936);break;case 117900035:aYb.yv(this,d,3,7,2.109753935530918);aYb.yv(this,d,3,3,3.1052897491356646);break;case 117900292:aYb.yv(this,d,4,7,2.090729910747413);aYb.yv(this,d,4,4,2.551671293386306);break;case 134743044:aYb.yv(this,d,4,8,2.139250042271712);aYb.yv(this,d,4,4,2.3520055858942612);}}else {c=$Xb.Qk(this.e,d)>10?s0b:$Xb.In(this.e,d)==2?i0b:$Xb.Oo(this.e,d,true)?t0b:$Xb.In(this.e,d)==0?s0b:t0b;for(i=1;i<g;i++)for(o=0;o<i;o++)this.a[d][i][o]=c;}}};xxb(525,1,{},aYb.zv);UXb.kmb=VFb(525);aYb.Gv=function Gv(){aYb.Gv=zxb;aYb.Ev=$jb(Mjb(UXb.Cwb,1),KZb,6,16,[false,false,false,false,false,true,true,true,true,false,false,false,false,false,false,true,true]);};aYb.Hv=function Hv(a,b){return a.a[b];};aYb.Iv=function Iv(a){aYb.Gv();var b,c;$Xb.nu(a,7);this.a=Sjb(UXb.klb,s_b,6,a.r,15,1);this.b=Sjb(UXb.klb,s_b,6,a.r,15,1);for(b=0;b<a.r;b++){c=aYb.Lv(a,b);if(c==-1){this.a[b]=aYb.Mv(a,b);this.b[b]=aYb.Nv(a,b);}else {this.a[b]=c==-1?2.000499963760376:aYb.Cv[c];this.b[b]=c==-1?1:aYb.Dv[c];}}};aYb.Jv=function Jv(a,b){if(b>=a.f)return 0;if(b<a.f&&$Xb.Ur(a.p,b)&&a.C[b]==6&&a.s[b]!=0)return 1;return a.o[b];};aYb.Kv=function Kv(a,b,c,d,e,f,g){var h,i,j,k,l;k=d<aYb.Ev.length&&aYb.Ev[d]?f<<8:0;l=e<aYb.Ev.length&&aYb.Ev[e]?g<<8:0;h=k+d;i=l+e;j=c?0:b?4+a:a;return (j<<24)+(h<i?(h<<12)+i:(i<<12)+h);};aYb.Lv=function Lv(a,b){var c,d,e,f;c=a.D[0][b];d=a.D[1][b];e=a.C[c];f=a.C[d];return aYb.Pv(aYb.Kv($Xb.bl(a,b),b<a.g&&$Xb.Vr(a.p,b),b<a.g&&($Xb.Zr(a.p,b)||a.H[b]==64),e,f,aYb.Jv(a,c),aYb.Jv(a,d)));};aYb.Mv=function Mv(a,b){var c,d;c=$Xb.Qk(a,a.D[0][b]);d=$Xb.Qk(a,a.D[1][b]);return (c<(aYb.mx(),aYb.kx).length?aYb.kx[c]:c<aYb.lx.length?u0b*aYb.lx[c]:v0b)+(d<aYb.kx.length?aYb.kx[d]:d<aYb.lx.length?u0b*aYb.lx[d]:v0b);};aYb.Nv=function Nv(a,b){var c,d;c=$Xb.Qk(a,a.D[0][b]);d=$Xb.Qk(a,a.D[1][b]);return (c<(aYb.mx(),aYb.kx).length?w0b:0.125)+(d<aYb.kx.length?w0b:0.125);};aYb.Ov=function Ov(){var b,c,d,e,f,g,h;if(!aYb.Fv){b=(h=VXb.OHb('2312\n4099\t2.403\t0.282\t466\n4100\t1.407\t0.2\t28\n4103\t1.561\t0.023\t5\n4104\t1.42\t0.092\t491\n4105\t1.313\t0.149\t32\n4107\t2.677\t0.401\t190\n4108\t2.118\t0.244\t325\n4109\t1.978\t0.26\t968\n4113\t1.819\t0.033\t4\n4115\t3.194\t0.482\t381\n4116\t2.771\t0.32\t198\n4117\t2.398\t0.235\t145\n4118\t2.317\t0.22\t208\n4119\t2.034\t0.212\t34\n4120\t2.033\t0.286\t103\n4121\t1.959\t0.264\t122\n4122\t1.918\t0.267\t664\n4123\t1.893\t0.257\t185\n4124\t1.877\t0.218\t259\n4125\t2.05\t0.257\t556\n4126\t2.012\t0.239\t129\n4127\t1.979\t0.292\t196\n4133\t3.305\t0.429\t34\n4134\t2.593\t0.367\t83\n4135\t2.74\t0.174\t706\n4136\t2.462\t0.196\t611\n4137\t2.207\t0.264\t78\n4138\t2.16\t0.225\t359\n4140\t2.004\t0.188\t2204\n4141\t1.916\t0.256\t610\n4142\t1.95\t0.234\t126\n4143\t2.3\t0.213\t81\n4144\t2.187\t0.116\t6\n4145\t2.103\t0.153\t21\n4146\t2.031\t0.308\t83\n4147\t1.752\t0.443\t21\n4151\t3.49\t0.4\t83\n4152\t3.017\t0.331\t40\n4153\t2.932\t0.276\t176\n4154\t2.39\t0.34\t24\n4155\t3.124\t0.377\t16\n4156\t2.907\t0.232\t198\n4158\t2.857\t0.237\t142\n4159\t2.687\t0.244\t49\n4160\t2.787\t0.359\t29\n4161\t2.785\t0.306\t37\n4162\t2.623\t0.298\t175\n4163\t2.812\t0.154\t70\n4164\t2.745\t0.281\t100\n4165\t2.719\t0.184\t37\n4166\t2.683\t0.361\t231\n4167\t2.655\t0.253\t198\n4168\t2.546\t0.208\t37\n4169\t2.259\t0.231\t190\n4170\t2.043\t0.289\t251\n4171\t2.001\t0.221\t391\n4172\t1.984\t0.164\t885\n4173\t1.904\t0.228\t1074\n4174\t2.036\t0.224\t250\n4175\t1.955\t0.184\t6\n4176\t2.35\t0.15\t12\n4177\t2.367\t0.216\t7\n4178\t2.47\t0.186\t11\n4179\t0.95\t-1.0\t1\n4186\t2.88\t0.309\t39\n4188\t2.804\t0.289\t136\n4189\t2.172\t0.082\t12\n4190\t2.321\t0.0\t2\n4359\t1.503\t0.106\t24\n4360\t1.425\t0.052\t40\n12291\t2.861\t0.27\t1069\n12292\t2.773\t0.086\t4\n12293\t2.507\t0.251\t27\n12294\t2.769\t0.373\t370\n12299\t3.1\t0.221\t116\n12300\t2.844\t0.146\t9\n12301\t3.636\t0.002\t3\n12302\t2.779\t0.318\t189\n12307\t3.639\t0.518\t25\n12308\t3.205\t0.245\t16\n12317\t3.036\t0.064\t4\n12318\t2.88\t-1.0\t1\n12319\t2.615\t0.864\t3\n12320\t2.857\t0.129\t247\n12325\t3.557\t0.41\t18\n12326\t3.273\t0.208\t23\n12330\t3.496\t0.025\t2\n12333\t3.012\t0.276\t2\n12334\t2.679\t0.0\t2\n12338\t2.886\t0.196\t80\n12339\t2.871\t0.221\t18\n12343\t3.628\t0.266\t9\n12344\t3.37\t0.145\t35\n12346\t2.859\t0.0\t4\n12352\t2.722\t0.017\t4\n12354\t3.317\t0.016\t4\n12355\t2.714\t0.006\t2\n12357\t2.703\t0.005\t2\n12365\t2.615\t-1.0\t1\n12367\t2.729\t0.0\t2\n12368\t2.841\t0.0\t2\n12369\t2.889\t0.082\t5\n12370\t2.913\t0.126\t64\n12549\t3.003\t0.175\t18\n12550\t2.797\t0.21\t1156\n12805\t2.63\t0.0\t2\n12806\t2.939\t0.243\t85\n16388\t2.29\t0.104\t57\n16389\t2.022\t0.097\t6\n16390\t2.097\t0.127\t21\n16391\t1.771\t0.395\t281\n16392\t1.648\t0.242\t634\n16393\t1.567\t0.555\t264\n16395\t2.926\t0.104\t14\n16397\t2.368\t-1.0\t1\n16398\t3.269\t-1.0\t1\n16399\t2.211\t0.15\t6\n16400\t2.1\t-1.0\t1\n16401\t2.065\t0.622\t37\n16403\t3.355\t0.087\t11\n16404\t2.9\t0.136\t2\n16416\t2.399\t0.154\t3\n16417\t2.06\t0.0\t2\n16418\t2.195\t-1.0\t1\n16419\t2.167\t0.95\t16\n16421\t3.378\t-1.0\t1\n16422\t2.886\t0.031\t2\n16429\t2.375\t0.124\t6\n16435\t2.635\t-1.0\t1\n16436\t2.399\t-1.0\t1\n16437\t2.417\t0.96\t23\n16439\t3.716\t0.078\t2\n16442\t3.052\t0.0\t4\n16463\t2.64\t-1.0\t1\n16466\t2.23\t-1.0\t1\n16474\t3.061\t0.0\t4\n16476\t3.017\t0.004\t8\n16645\t1.954\t-1.0\t1\n16646\t2.276\t0.281\t56\n16647\t1.966\t0.14\t51\n16648\t1.843\t0.124\t41\n16902\t1.739\t0.003\t2\n16903\t2.003\t-1.0\t1\n20491\t2.681\t-1.0\t1\n20492\t2.402\t0.287\t12\n20493\t2.373\t0.17\t6\n20499\t3.054\t0.395\t11\n20500\t3.076\t0.081\t2\n20501\t2.3\t1.168\t20\n20502\t2.221\t0.057\t3\n20503\t1.964\t-1.0\t1\n20504\t2.515\t0.236\t21\n20505\t1.97\t0.231\t70\n20506\t2.056\t0.352\t138\n20507\t2.553\t0.302\t81\n20508\t2.489\t0.321\t24\n20509\t2.215\t0.363\t36\n20510\t2.786\t0.026\t6\n20511\t2.418\t0.106\t10\n20517\t3.193\t0.063\t3\n20519\t2.598\t0.187\t9\n20520\t2.376\t0.309\t9\n20522\t2.708\t0.265\t154\n20524\t2.526\t0.319\t123\n20525\t2.262\t0.289\t122\n20526\t2.502\t0.287\t18\n20527\t2.365\t0.284\t11\n20528\t2.966\t0.038\t6\n20529\t2.584\t0.061\t7\n20530\t2.771\t0.387\t5\n20531\t1.29\t0.001\t12\n20535\t3.368\t0.154\t5\n20536\t3.023\t0.074\t6\n20537\t2.913\t0.0\t2\n20538\t3.021\t0.331\t2\n20540\t2.651\t0.201\t5\n20543\t2.735\t0.344\t5\n20546\t2.531\t0.277\t7\n20549\t3.267\t-1.0\t1\n20550\t2.329\t0.34\t7\n20552\t2.499\t0.02\t6\n20553\t2.703\t0.218\t20\n20554\t2.693\t0.292\t46\n20555\t2.639\t0.27\t40\n20556\t2.066\t0.059\t39\n20557\t2.599\t0.324\t183\n20558\t2.048\t0.149\t134\n20559\t2.327\t0.386\t34\n20560\t2.179\t-1.0\t1\n20561\t2.619\t-1.0\t1\n20562\t2.967\t-1.0\t1\n20570\t2.665\t0.007\t2\n20572\t2.63\t0.19\t9\n20742\t1.87\t0.155\t40\n24587\t3.525\t0.393\t28\n24588\t2.763\t0.313\t380\n24589\t2.462\t0.308\t5373\n24595\t4.077\t0.356\t19\n24596\t3.17\t0.362\t45\n24597\t2.829\t0.525\t432\n24598\t2.656\t0.164\t627\n24599\t2.654\t0.158\t57\n24600\t2.57\t0.26\t309\n24601\t2.625\t0.288\t208\n24602\t2.45\t0.223\t1004\n24603\t2.182\t0.257\t1071\n24604\t2.355\t0.185\t1159\n24605\t2.384\t0.162\t130\n24606\t2.479\t0.188\t1375\n24607\t2.547\t0.23\t805\n24613\t3.789\t0.188\t2\n24614\t3.484\t0.291\t8\n24615\t3.089\t0.34\t499\n24616\t2.809\t0.177\t912\n24617\t2.665\t0.147\t106\n24618\t2.632\t0.3\t598\n24620\t2.419\t0.207\t1127\n24621\t2.466\t0.217\t582\n24622\t2.456\t0.168\t1672\n24623\t2.573\t0.135\t12\n24624\t2.753\t0.503\t34\n24625\t2.695\t0.487\t478\n24626\t2.644\t0.444\t4321\n24627\t2.655\t0.961\t518\n24631\t3.712\t0.709\t3\n24632\t3.745\t0.575\t6\n24633\t3.382\t0.306\t128\n24634\t3.417\t0.336\t41\n24635\t3.236\t0.278\t27\n24636\t3.365\t0.272\t72\n24638\t3.236\t0.316\t52\n24639\t3.097\t0.0\t2\n24640\t2.718\t0.258\t39\n24641\t3.353\t0.103\t6\n24642\t3.087\t0.178\t51\n24643\t2.988\t0.348\t31\n24644\t2.995\t0.182\t58\n24645\t3.221\t0.798\t58\n24646\t3.104\t0.353\t86\n24647\t3.019\t0.515\t320\n24648\t2.735\t0.176\t341\n24649\t2.703\t0.204\t299\n24650\t2.595\t0.331\t829\n24651\t2.536\t0.58\t227\n24652\t2.472\t0.25\t206\n24653\t2.534\t0.168\t933\n24654\t2.491\t0.326\t1889\n24655\t2.445\t0.168\t254\n24656\t2.51\t0.162\t95\n24657\t3.004\t0.801\t27\n24658\t2.961\t0.516\t71\n24659\t3.105\t0.444\t106\n24666\t3.114\t0.326\t123\n24668\t3.098\t0.303\t230\n28685\t2.353\t0.307\t3006\n28693\t2.684\t0.241\t703\n28694\t2.452\t0.242\t3992\n28695\t2.409\t0.319\t1209\n28696\t2.464\t0.534\t2219\n28697\t2.577\t0.289\t2590\n28698\t2.456\t0.2\t6911\n28699\t2.41\t0.36\t7053\n28700\t2.487\t0.231\t7446\n28701\t2.406\t0.194\t9772\n28702\t2.479\t0.227\t5502\n28703\t2.471\t0.309\t929\n28711\t2.921\t0.239\t1714\n28712\t2.679\t0.232\t2798\n28713\t2.442\t0.272\t911\n28714\t2.445\t0.293\t2412\n28716\t2.475\t0.298\t2904\n28717\t2.428\t0.335\t1207\n28718\t2.458\t0.222\t3289\n28719\t2.487\t0.247\t1033\n28720\t2.81\t0.231\t768\n28721\t2.785\t0.35\t616\n28722\t2.606\t0.37\t1703\n28723\t2.599\t0.29\t531\n28729\t3.125\t0.329\t626\n28730\t3.082\t0.337\t728\n28731\t3.179\t0.249\t153\n28732\t3.022\t0.208\t458\n28734\t3.032\t0.245\t890\n28735\t3.194\t0.258\t616\n28736\t3.148\t0.29\t455\n28737\t3.124\t0.266\t301\n28738\t3.028\t0.263\t602\n28739\t2.987\t0.306\t159\n28740\t2.919\t0.28\t496\n28741\t3.182\t0.365\t119\n28742\t2.892\t0.229\t1179\n28743\t2.821\t0.212\t549\n28744\t2.607\t0.225\t683\n28745\t2.503\t0.227\t1194\n28746\t2.395\t0.326\t1012\n28747\t2.447\t0.267\t941\n28748\t2.383\t0.233\t326\n28749\t2.511\t0.279\t970\n28750\t2.457\t0.24\t1884\n28751\t2.393\t0.172\t533\n28752\t2.849\t0.285\t194\n28753\t2.973\t0.272\t62\n28754\t2.876\t0.236\t326\n28755\t2.753\t0.232\t424\n28762\t3.088\t0.249\t588\n28764\t2.972\t0.34\t2780\n28765\t3.016\t0.335\t10\n28766\t3.297\t0.204\t7\n32781\t2.145\t0.448\t7124\n32789\t2.625\t0.845\t799\n32790\t2.338\t0.282\t13095\n32791\t2.352\t0.77\t18035\n32792\t2.299\t0.427\t5228\n32793\t2.387\t0.292\t15567\n32794\t2.358\t0.225\t12153\n32795\t2.38\t0.29\t13623\n32796\t2.421\t0.301\t14996\n32797\t2.272\t0.223\t19019\n32798\t2.378\t0.357\t12982\n32799\t2.317\t0.208\t831\n32807\t2.796\t0.315\t3153\n32808\t2.497\t0.249\t4631\n32809\t2.375\t0.365\t1523\n32810\t2.347\t0.467\t31965\n32812\t2.419\t0.158\t3311\n32813\t2.436\t0.193\t2109\n32814\t2.4\t0.154\t2649\n32815\t2.661\t0.256\t865\n32816\t2.694\t0.218\t2847\n32817\t2.616\t0.276\t949\n32818\t2.579\t0.438\t4702\n32819\t2.309\t0.553\t1993\n32825\t2.994\t0.343\t2113\n32826\t2.856\t0.3\t2621\n32827\t2.93\t0.228\t1218\n32828\t2.905\t0.207\t2518\n32830\t2.869\t0.237\t2353\n32831\t2.827\t0.209\t3697\n32832\t2.834\t0.197\t5222\n32833\t2.78\t0.177\t4383\n32834\t2.738\t0.205\t8482\n32835\t2.747\t0.193\t1707\n32836\t2.742\t0.193\t2196\n32837\t2.798\t0.21\t502\n32838\t2.734\t0.235\t2716\n32839\t2.767\t0.212\t885\n32840\t2.498\t0.29\t774\n32841\t2.373\t0.261\t1221\n32842\t2.285\t0.417\t9618\n32843\t2.218\t0.348\t3304\n32844\t2.411\t0.2\t303\n32845\t2.462\t0.304\t1297\n32846\t2.393\t0.203\t1953\n32847\t2.305\t0.24\t286\n32848\t2.736\t0.309\t162\n32849\t2.822\t0.336\t202\n32850\t2.624\t0.233\t1404\n32851\t2.579\t0.268\t1906\n32858\t2.759\t0.291\t759\n32860\t2.611\t0.412\t7083\n32861\t2.503\t0.425\t287\n32862\t2.802\t0.399\t255\n32863\t2.837\t0.483\t20\n32864\t3.097\t0.448\t5\n32865\t2.94\t0.02\t3\n32866\t2.916\t0.021\t3\n36877\t1.811\t0.461\t1163\n36885\t2.022\t0.295\t129\n36886\t2.262\t0.492\t1106\n36887\t2.576\t0.889\t536\n36888\t1.937\t0.267\t474\n36889\t2.093\t0.73\t296\n36890\t1.929\t0.743\t373\n36891\t2.283\t0.257\t113\n36892\t2.221\t0.196\t116\n36893\t2.345\t0.817\t110\n36894\t2.065\t0.336\t75\n36895\t2.412\t0.358\t76\n36903\t2.125\t0.259\t44\n36904\t2.154\t1.055\t667\n36905\t2.12\t0.459\t502\n36906\t2.031\t0.453\t512\n36908\t2.395\t0.388\t43\n36909\t2.339\t0.338\t54\n36910\t2.361\t0.307\t101\n36911\t2.57\t0.191\t9\n36912\t2.427\t0.207\t26\n36913\t2.059\t1.008\t121\n36914\t2.126\t0.626\t419\n36915\t2.193\t0.262\t8674\n36921\t2.731\t0.286\t10\n36922\t2.995\t1.207\t51\n36923\t2.406\t0.044\t8\n36924\t2.742\t0.246\t33\n36926\t2.795\t0.182\t52\n36927\t2.799\t0.303\t24\n36928\t2.454\t0.018\t4\n36929\t1.96\t0.0\t6\n36930\t2.434\t0.192\t19\n36931\t2.857\t-1.0\t1\n36932\t2.747\t0.211\t25\n36934\t2.687\t0.139\t19\n36935\t2.806\t0.003\t4\n36936\t2.107\t0.444\t90\n36937\t2.149\t0.225\t250\n36938\t1.882\t0.247\t232\n36939\t2.0\t0.93\t274\n36940\t2.276\t0.144\t56\n36941\t2.293\t1.188\t69\n36942\t2.356\t0.364\t53\n36943\t1.893\t0.555\t149\n36944\t2.373\t0.0\t2\n36945\t2.015\t0.261\t45\n36946\t2.333\t0.203\t37\n36947\t2.152\t0.196\t94\n36954\t2.666\t0.268\t30\n36955\t2.205\t0.007\t16\n36956\t2.285\t0.379\t153\n36957\t2.26\t0.017\t10\n45067\t3.369\t0.477\t389\n45068\t3.242\t-1.0\t1\n45069\t3.524\t0.425\t2\n45070\t3.558\t0.0\t2\n45075\t3.592\t0.346\t36\n45076\t3.383\t0.133\t22\n45081\t3.221\t0.182\t3\n45082\t2.923\t0.336\t4\n45083\t3.382\t-1.0\t1\n45084\t2.961\t0.097\t3\n45087\t3.136\t-1.0\t1\n45088\t3.161\t0.174\t9\n45093\t3.645\t0.249\t17\n45094\t3.529\t0.167\t10\n45101\t3.618\t-1.0\t1\n45106\t3.243\t0.311\t72\n45107\t3.33\t0.219\t17\n45111\t3.704\t0.248\t22\n45112\t3.585\t0.155\t9\n45134\t3.136\t-1.0\t1\n45136\t3.234\t0.09\t7\n45137\t3.405\t0.105\t12\n45138\t3.441\t0.118\t15\n45139\t3.281\t0.068\t7\n45317\t3.245\t0.017\t2\n45318\t3.261\t0.178\t294\n45573\t2.685\t-1.0\t1\n45574\t3.187\t0.261\t35\n49164\t3.052\t0.123\t490\n49165\t3.401\t-1.0\t1\n49166\t2.887\t0.569\t39\n49171\t4.275\t0.055\t2\n49172\t3.412\t0.019\t8\n49177\t3.408\t-1.0\t1\n49178\t3.072\t0.063\t8\n49181\t3.334\t0.086\t3\n49182\t3.217\t0.061\t2\n49183\t2.836\t0.772\t13\n49184\t2.807\t0.438\t17\n49190\t3.648\t0.307\t28\n49191\t2.187\t0.0\t6\n49194\t2.466\t0.0\t2\n49197\t2.818\t0.099\t91\n49202\t2.927\t0.036\t9\n49203\t2.862\t0.432\t19\n49207\t3.807\t0.0\t2\n49208\t3.659\t0.045\t20\n49209\t3.53\t0.075\t16\n49210\t3.447\t0.003\t12\n49211\t3.506\t0.0\t3\n49212\t3.54\t0.0\t3\n49214\t3.463\t0.0\t3\n49215\t3.48\t0.014\t8\n49216\t3.364\t0.0\t3\n49221\t3.144\t0.0\t12\n49229\t2.7\t0.086\t48\n49230\t3.087\t0.019\t2\n49233\t3.145\t0.004\t2\n49413\t2.826\t0.154\t5\n49414\t2.811\t0.216\t411\n49670\t2.681\t0.238\t49\n53261\t3.147\t0.471\t69\n53262\t3.263\t0.176\t31\n53263\t3.143\t0.346\t218\n53264\t2.983\t0.385\t264\n53265\t2.601\t0.322\t2017\n53268\t3.669\t-1.0\t1\n53272\t2.557\t-1.0\t1\n53273\t2.309\t-1.0\t1\n53274\t2.908\t0.179\t18\n53275\t2.828\t0.234\t10\n53276\t2.655\t0.245\t6\n53277\t2.352\t0.06\t13\n53278\t3.3\t0.187\t3\n53279\t3.414\t0.37\t3\n53280\t2.499\t0.185\t12\n53281\t2.448\t0.051\t41\n53282\t2.875\t0.469\t72\n53283\t2.741\t0.288\t381\n53286\t3.495\t0.045\t15\n53292\t2.999\t-1.0\t1\n53293\t3.023\t0.354\t19\n53294\t2.951\t0.089\t21\n53295\t3.08\t-1.0\t1\n53297\t3.715\t-1.0\t1\n53298\t3.418\t0.0\t2\n53299\t2.655\t0.502\t19\n53300\t2.915\t0.495\t30\n53301\t3.049\t0.382\t137\n53303\t2.804\t1.394\t2\n53304\t3.582\t0.06\t4\n53305\t3.584\t0.347\t3\n53308\t3.56\t0.086\t2\n53322\t3.218\t0.048\t2\n53325\t3.468\t0.243\t2\n53326\t3.202\t0.139\t4\n53331\t3.74\t0.255\t4\n53340\t4.01\t0.006\t2\n53509\t2.605\t0.31\t8\n53510\t2.407\t0.249\t1700\n53511\t2.374\t0.163\t1982\n53512\t2.216\t0.23\t533\n53519\t2.935\t0.196\t5\n53520\t2.843\t0.186\t40\n53766\t2.468\t0.199\t96\n53767\t2.448\t0.135\t44\n53768\t1.978\t0.199\t4\n57363\t4.548\t0.464\t19\n57364\t3.083\t0.417\t13\n57366\t3.671\t0.019\t4\n57367\t3.246\t0.035\t4\n57368\t2.795\t0.193\t8\n57369\t2.811\t0.292\t27\n57370\t2.847\t0.192\t233\n57371\t2.715\t0.262\t77\n57372\t2.749\t0.228\t147\n57373\t2.884\t0.306\t43\n57374\t3.288\t0.273\t42\n57375\t3.561\t0.36\t4\n57382\t3.347\t0.097\t2\n57384\t3.775\t0.176\t18\n57385\t3.436\t0.115\t26\n57386\t3.224\t0.255\t49\n57388\t2.956\t0.338\t151\n57389\t2.78\t0.227\t106\n57390\t2.921\t0.275\t97\n57391\t3.357\t0.302\t20\n57393\t3.19\t0.085\t14\n57394\t3.662\t0.527\t210\n57395\t3.917\t0.191\t58\n57399\t3.91\t0.0\t4\n57400\t3.327\t0.062\t5\n57402\t3.01\t0.585\t8\n57406\t4.511\t0.25\t17\n57407\t4.503\t0.08\t6\n57409\t3.926\t0.003\t2\n57411\t3.905\t0.012\t2\n57414\t4.362\t0.205\t19\n57416\t3.87\t0.205\t13\n57417\t3.437\t0.24\t5\n57418\t3.085\t0.21\t66\n57419\t2.96\t0.12\t14\n57420\t3.028\t0.125\t7\n57421\t2.797\t0.286\t150\n57422\t2.978\t0.215\t175\n57423\t2.761\t0.465\t12\n57424\t3.53\t0.211\t22\n57426\t3.874\t0.316\t17\n57427\t4.031\t0.321\t9\n61461\t3.38\t0.299\t100\n61462\t3.21\t0.369\t276\n61463\t3.131\t0.207\t110\n61464\t2.873\t0.244\t730\n61465\t2.696\t0.32\t774\n61466\t2.697\t0.243\t4802\n61467\t2.679\t0.235\t3056\n61468\t2.676\t0.196\t4702\n61469\t2.64\t0.179\t5253\n61470\t2.912\t0.244\t119\n61471\t3.023\t0.242\t152\n61479\t3.617\t0.27\t57\n61480\t3.41\t0.235\t240\n61481\t3.284\t0.297\t129\n61482\t3.002\t0.261\t2058\n61484\t2.758\t0.203\t6616\n61485\t2.714\t0.205\t4052\n61486\t2.713\t0.193\t6710\n61487\t2.863\t0.16\t1964\n61488\t3.199\t0.271\t42\n61489\t3.285\t0.255\t93\n61490\t3.243\t0.31\t221\n61491\t3.183\t0.277\t77\n61497\t3.201\t0.305\t27\n61498\t2.934\t0.476\t9\n61500\t3.451\t0.1\t14\n61502\t3.794\t0.117\t26\n61506\t3.579\t0.083\t13\n61507\t3.584\t0.109\t8\n61508\t3.774\t0.0\t2\n61510\t3.577\t0.217\t22\n61511\t3.739\t0.336\t7\n61512\t3.408\t0.222\t72\n61513\t3.244\t0.257\t147\n61514\t3.003\t0.256\t1665\n61515\t2.906\t0.239\t1623\n61516\t2.798\t0.241\t1057\n61517\t2.754\t0.215\t2863\n61518\t2.714\t0.201\t6668\n61519\t2.668\t0.172\t4216\n61520\t2.879\t0.203\t76\n61521\t3.471\t0.204\t33\n61522\t3.487\t0.164\t39\n61523\t3.141\t0.234\t30\n61530\t3.726\t0.298\t60\n61532\t3.891\t0.328\t80\n65557\t3.412\t0.368\t35\n65558\t2.901\t0.267\t387\n65559\t2.852\t0.348\t489\n65560\t2.881\t0.289\t268\n65561\t2.726\t0.281\t883\n65562\t2.718\t0.226\t7921\n65563\t2.724\t0.272\t1489\n65564\t2.606\t0.234\t5975\n65565\t2.755\t0.225\t5038\n65566\t2.788\t0.225\t1360\n65567\t2.767\t0.214\t227\n65575\t3.418\t0.184\t159\n65576\t3.376\t0.277\t123\n65577\t2.954\t0.528\t373\n65578\t2.911\t0.288\t3355\n65580\t2.816\t0.192\t1907\n65581\t2.839\t0.173\t765\n65582\t2.775\t0.192\t2485\n65583\t3.093\t0.232\t4438\n65584\t3.087\t0.238\t609\n65585\t3.111\t0.393\t484\n65586\t2.949\t0.477\t1247\n65587\t2.995\t0.415\t696\n65593\t3.611\t0.276\t65\n65594\t3.5\t0.164\t59\n65595\t3.551\t0.145\t18\n65596\t3.459\t0.169\t45\n65598\t3.453\t0.18\t175\n65599\t3.683\t0.232\t44\n65600\t3.412\t0.05\t10\n65601\t3.114\t0.282\t6\n65602\t3.516\t0.333\t73\n65603\t3.018\t0.572\t5\n65604\t3.488\t0.196\t81\n65605\t3.266\t0.272\t10\n65606\t3.254\t0.188\t179\n65607\t3.336\t0.194\t34\n65608\t3.554\t0.326\t21\n65609\t2.461\t0.31\t329\n65610\t2.919\t0.288\t2082\n65611\t2.8\t0.267\t1996\n65612\t2.475\t0.252\t240\n65613\t2.833\t0.153\t655\n65614\t2.73\t0.196\t2208\n65615\t2.776\t0.277\t3697\n65616\t2.944\t0.23\t538\n65617\t3.031\t0.277\t17\n65618\t3.147\t0.26\t222\n65619\t3.099\t0.284\t350\n65626\t3.319\t0.35\t170\n65628\t3.382\t0.265\t290\n65629\t3.399\t0.077\t8\n65630\t2.931\t0.387\t17\n65631\t3.438\t0.046\t3\n65632\t3.441\t0.047\t3\n69653\t3.008\t0.308\t233\n69654\t2.799\t0.246\t2597\n69655\t2.789\t0.215\t490\n69656\t2.8\t0.199\t1394\n69657\t2.875\t0.267\t1182\n69658\t2.712\t0.238\t3474\n69659\t2.694\t0.227\t2713\n69660\t2.758\t0.28\t2082\n69661\t2.701\t0.25\t5780\n69662\t2.642\t0.425\t3822\n69663\t2.661\t0.254\t1485\n69671\t3.218\t0.274\t409\n69672\t2.991\t0.248\t1900\n69673\t2.903\t0.356\t1449\n69674\t2.907\t0.475\t2267\n69676\t2.885\t0.203\t5377\n69677\t2.863\t0.235\t2604\n69678\t2.776\t0.213\t6900\n69679\t3.032\t0.245\t617\n69680\t2.974\t0.221\t1026\n69681\t2.957\t0.377\t932\n69682\t2.928\t0.391\t2452\n69683\t2.872\t0.46\t1745\n69689\t3.393\t0.345\t120\n69690\t3.542\t0.471\t133\n69691\t3.384\t0.328\t54\n69692\t3.319\t0.289\t122\n69694\t3.354\t0.248\t151\n69695\t3.179\t0.349\t113\n69696\t3.251\t0.372\t116\n69697\t3.069\t0.3\t85\n69698\t3.114\t0.336\t295\n69699\t3.273\t0.344\t35\n69700\t3.214\t0.336\t160\n69701\t2.947\t0.43\t25\n69702\t3.224\t0.207\t183\n69703\t3.182\t0.198\t73\n69704\t2.972\t0.302\t357\n69705\t2.911\t0.327\t1000\n69706\t2.885\t0.369\t1787\n69707\t2.801\t0.257\t2221\n69708\t2.851\t0.255\t681\n69709\t2.879\t0.222\t2186\n69710\t2.757\t0.265\t4336\n69711\t2.675\t0.201\t2687\n69712\t2.804\t0.27\t1229\n69713\t2.554\t0.473\t192\n69714\t3.224\t0.457\t625\n69715\t3.107\t0.371\t1402\n69722\t3.417\t0.306\t157\n69723\t2.64\t0.0\t4\n69724\t3.21\t0.343\t893\n69725\t3.181\t0.284\t122\n69726\t3.088\t0.296\t154\n69727\t2.915\t-1.0\t1\n69728\t2.915\t-1.0\t1\n69729\t2.465\t0.0\t6\n77843\t3.904\t0.444\t476\n77844\t3.931\t0.219\t13\n77847\t3.213\t0.001\t2\n77848\t3.318\t0.114\t5\n77849\t3.574\t0.313\t3\n77850\t3.205\t-1.0\t1\n77851\t3.463\t0.411\t4\n77852\t3.491\t0.534\t2\n77853\t3.822\t0.039\t3\n77854\t3.511\t0.765\t6\n77856\t3.502\t0.647\t78\n77861\t3.9\t0.078\t12\n77862\t3.806\t0.091\t8\n77864\t3.807\t-1.0\t1\n77865\t3.535\t0.137\t7\n77870\t3.386\t0.218\t17\n77871\t3.245\t0.006\t2\n77874\t3.754\t0.595\t67\n77875\t3.655\t0.42\t25\n77879\t3.899\t0.365\t31\n77880\t4.729\t0.676\t2\n77898\t4.496\t0.606\t3\n77902\t3.48\t0.0\t4\n77905\t3.736\t0.08\t11\n77906\t3.724\t0.099\t26\n77907\t3.562\t0.045\t4\n77917\t4.592\t-1.0\t1\n78085\t3.76\t0.113\t8\n78086\t3.713\t0.29\t1287\n78342\t3.557\t0.28\t73\n81940\t3.661\t0.289\t176\n81943\t3.019\t-1.0\t1\n81944\t2.85\t-1.0\t1\n81945\t3.324\t0.0\t2\n81951\t3.151\t-1.0\t1\n81952\t3.185\t0.116\t25\n81957\t3.75\t0.247\t3\n81958\t3.579\t0.106\t3\n81967\t3.517\t0.128\t5\n81969\t3.26\t0.128\t3\n81970\t3.346\t0.13\t71\n81971\t3.246\t0.132\t128\n81975\t3.895\t0.219\t5\n81976\t3.719\t0.202\t10\n81997\t3.133\t0.007\t2\n81999\t3.088\t0.086\t20\n82000\t3.26\t0.098\t4\n82001\t3.332\t-1.0\t1\n82002\t3.427\t0.083\t10\n82003\t3.25\t0.171\t45\n82012\t3.805\t-1.0\t1\n82182\t3.212\t0.212\t411\n82438\t2.973\t0.227\t13\n86044\t2.357\t-1.0\t1\n86050\t3.301\t0.106\t5\n86051\t3.223\t0.408\t15\n86053\t3.906\t-1.0\t1\n86062\t2.711\t0.034\t2\n86068\t3.534\t0.111\t4\n86069\t3.014\t0.266\t86\n86277\t3.132\t0.206\t3\n86278\t3.08\t0.205\t1002\n86279\t2.704\t0.168\t460\n86280\t2.561\t0.163\t44\n86287\t3.292\t0.078\t26\n86288\t3.128\t0.068\t7\n86534\t2.902\t0.101\t13\n86535\t2.446\t0.18\t5\n90134\t3.158\t0.093\t9\n90138\t2.576\t0.185\t3\n90139\t2.835\t0.161\t13\n90140\t2.925\t0.174\t8\n90141\t3.761\t-1.0\t1\n90143\t3.058\t0.0\t2\n90144\t2.522\t0.784\t3\n90145\t2.482\t0.209\t46\n90146\t3.164\t0.558\t44\n90147\t2.774\t0.281\t113\n90150\t3.233\t0.034\t7\n90156\t3.193\t-1.0\t1\n90157\t2.921\t-1.0\t1\n90161\t3.271\t0.0\t2\n90162\t3.869\t0.023\t3\n90163\t3.573\t0.143\t28\n90164\t3.347\t0.022\t18\n90165\t2.62\t0.414\t54\n90168\t3.427\t0.036\t8\n90194\t3.897\t-1.0\t1\n90373\t3.171\t0.268\t3\n90374\t2.926\t0.185\t13105\n90375\t2.587\t0.178\t1875\n90376\t2.456\t0.185\t917\n90383\t3.113\t0.322\t22\n90384\t3.044\t0.167\t14\n90630\t2.624\t0.183\t73\n90631\t2.431\t0.217\t59\n90632\t2.541\t0.214\t13\n94231\t2.269\t0.138\t9\n94234\t2.503\t0.095\t6\n94235\t2.637\t0.592\t3\n94236\t3.236\t0.203\t2\n94242\t2.529\t0.487\t29\n94243\t2.969\t0.254\t17\n94264\t3.486\t-1.0\t1\n94286\t2.784\t0.083\t10\n94470\t2.664\t0.196\t1656\n94471\t2.46\t0.141\t1730\n94472\t2.373\t0.21\t563\n94479\t3.002\t0.084\t9\n94480\t2.809\t0.211\t72\n94726\t2.339\t0.204\t93\n94727\t2.461\t0.173\t28\n94728\t2.22\t0.033\t36\n98328\t2.585\t0.33\t139\n98329\t3.026\t0.483\t6\n98330\t3.053\t0.116\t7\n98331\t2.861\t0.157\t7\n98332\t3.016\t0.06\t2\n98333\t2.906\t-1.0\t1\n98334\t3.171\t-1.0\t1\n98335\t2.778\t0.078\t6\n98336\t2.83\t0.006\t4\n98337\t2.984\t0.301\t63\n98338\t3.557\t0.536\t97\n98339\t2.852\t0.31\t66\n98341\t3.47\t0.104\t3\n98349\t3.572\t-1.0\t1\n98350\t3.259\t0.092\t4\n98354\t3.11\t0.137\t19\n98355\t3.017\t0.193\t20\n98356\t3.203\t0.219\t43\n98357\t3.129\t0.376\t67\n98378\t3.04\t-1.0\t1\n98381\t3.568\t-1.0\t1\n98382\t3.15\t0.188\t5\n98383\t3.133\t0.037\t3\n98384\t3.045\t0.0\t2\n98386\t3.121\t0.097\t12\n98387\t3.325\t0.016\t2\n98565\t2.688\t0.12\t18\n98566\t2.619\t0.153\t6878\n98567\t2.404\t0.141\t2515\n98568\t2.41\t0.174\t638\n98575\t3.098\t0.146\t259\n98576\t2.876\t0.25\t37\n98822\t2.158\t0.152\t4143\n98823\t2.42\t0.131\t56\n98824\t2.468\t0.236\t5\n102425\t3.087\t0.258\t19\n102426\t2.867\t0.103\t4\n102427\t3.03\t0.131\t2\n102428\t2.886\t-1.0\t1\n102431\t3.326\t0.375\t7\n102432\t2.775\t0.168\t35\n102433\t2.737\t0.092\t14\n102434\t3.052\t0.275\t320\n102435\t2.947\t0.279\t501\n102438\t3.136\t0.442\t2\n102442\t3.198\t-1.0\t1\n102444\t2.998\t0.081\t3\n102445\t2.848\t0.318\t2\n102447\t3.116\t0.312\t4\n102449\t2.668\t0.007\t12\n102450\t2.65\t0.156\t37\n102451\t2.804\t0.128\t97\n102452\t3.71\t0.389\t143\n102453\t3.196\t0.352\t77\n102476\t2.993\t0.038\t4\n102478\t3.256\t-1.0\t1\n102479\t3.089\t0.272\t5\n102480\t2.61\t0.003\t4\n102481\t3.397\t-1.0\t1\n102482\t2.754\t0.035\t4\n102483\t2.878\t0.096\t25\n102661\t2.718\t0.111\t3\n102662\t2.482\t0.226\t2788\n102663\t2.511\t0.177\t8370\n102664\t2.493\t0.179\t2602\n102671\t2.643\t0.184\t45\n102672\t2.962\t0.176\t53\n102918\t2.052\t0.149\t4796\n102919\t2.51\t0.179\t433\n102920\t2.374\t0.161\t19\n106522\t2.941\t0.371\t219\n106523\t2.892\t0.261\t5\n106524\t2.877\t0.111\t7\n106525\t2.863\t0.149\t85\n106526\t2.98\t0.096\t34\n106527\t2.834\t0.242\t89\n106528\t2.743\t0.335\t128\n106529\t2.701\t0.254\t143\n106530\t2.739\t0.223\t715\n106531\t2.904\t0.242\t866\n106536\t3.002\t0.349\t8\n106537\t2.799\t0.229\t2\n106538\t3.086\t0.144\t4\n106540\t2.735\t0.302\t14\n106541\t2.768\t0.387\t2\n106542\t3.159\t0.157\t17\n106543\t2.781\t0.205\t11\n106545\t3.031\t0.266\t33\n106546\t3.013\t0.266\t96\n106547\t2.844\t0.229\t38\n106548\t2.92\t0.185\t202\n106549\t3.146\t0.267\t200\n106551\t3.701\t0.004\t2\n106552\t3.508\t0.08\t2\n106554\t3.692\t-1.0\t1\n106556\t3.882\t-1.0\t1\n106566\t3.665\t0.215\t7\n106570\t3.257\t0.114\t4\n106571\t2.863\t0.015\t4\n106572\t2.976\t0.164\t5\n106574\t3.224\t0.085\t11\n106575\t2.779\t0.247\t4\n106576\t2.981\t0.124\t18\n106577\t3.014\t0.072\t10\n106579\t3.124\t0.117\t28\n106757\t2.221\t0.408\t15\n106758\t2.401\t0.141\t81624\n106759\t2.351\t0.184\t21226\n106760\t2.431\t0.13\t2185\n106767\t2.782\t0.218\t230\n106768\t2.742\t0.183\t221\n107014\t2.077\t0.157\t13871\n107015\t2.286\t0.144\t1126\n107016\t2.261\t0.186\t6\n107023\t2.555\t-1.0\t1\n110619\t2.657\t0.367\t240\n110620\t2.816\t0.234\t12\n110621\t2.849\t0.093\t2\n110622\t2.914\t0.068\t12\n110623\t2.683\t0.337\t23\n110624\t2.349\t0.547\t34\n110625\t2.914\t0.287\t44\n110626\t2.37\t0.334\t254\n110627\t2.823\t0.245\t593\n110629\t3.216\t-1.0\t1\n110632\t3.168\t0.262\t18\n110633\t3.517\t-1.0\t1\n110634\t3.188\t-1.0\t1\n110636\t2.935\t0.025\t5\n110637\t2.659\t0.073\t4\n110638\t2.964\t0.14\t43\n110641\t2.808\t0.245\t6\n110642\t2.669\t0.36\t18\n110643\t2.899\t0.004\t2\n110644\t2.907\t0.266\t28\n110645\t3.111\t0.233\t239\n110654\t3.746\t0.042\t4\n110664\t3.213\t0.095\t2\n110665\t3.535\t-1.0\t1\n110666\t3.211\t-1.0\t1\n110669\t2.652\t-1.0\t1\n110670\t3.108\t0.335\t20\n110671\t3.078\t0.114\t48\n110672\t2.505\t0.007\t4\n110673\t2.66\t0.009\t3\n110674\t2.75\t0.014\t4\n110675\t2.821\t0.241\t50\n110682\t3.786\t-1.0\t1\n110684\t3.602\t0.211\t2\n110853\t2.51\t0.032\t24\n110854\t2.424\t0.18\t7855\n110855\t2.35\t0.165\t15280\n110856\t2.397\t0.151\t2600\n110863\t2.753\t0.315\t114\n110864\t2.718\t0.212\t256\n111110\t2.057\t0.162\t5916\n111111\t2.347\t0.183\t580\n111120\t3.119\t-1.0\t1\n114716\t2.861\t0.204\t423\n114717\t2.956\t0.144\t62\n114718\t3.07\t0.105\t55\n114719\t2.884\t0.235\t61\n114720\t2.67\t0.388\t26\n114721\t2.959\t0.219\t18\n114722\t2.832\t0.233\t173\n114723\t2.869\t0.229\t1269\n114727\t2.635\t0.109\t4\n114728\t2.753\t-1.0\t1\n114730\t2.796\t0.0\t2\n114733\t2.529\t0.017\t3\n114737\t2.923\t0.325\t25\n114738\t3.191\t0.145\t154\n114739\t3.085\t0.122\t9\n114740\t3.439\t0.421\t52\n114741\t3.061\t0.179\t190\n114743\t3.288\t-1.0\t1\n114745\t2.617\t0.062\t2\n114759\t3.289\t0.325\t3\n114760\t2.798\t-1.0\t1\n114762\t2.961\t-1.0\t1\n114765\t2.702\t-1.0\t1\n114766\t3.089\t0.135\t10\n114767\t3.047\t0.066\t62\n114768\t3.431\t0.011\t4\n114769\t3.198\t-1.0\t1\n114770\t3.331\t0.009\t16\n114771\t3.287\t0.091\t62\n114780\t3.048\t-1.0\t1\n114949\t2.438\t0.289\t13\n114950\t2.447\t0.207\t5143\n114951\t2.359\t0.153\t15318\n114952\t2.422\t0.153\t2635\n114959\t2.635\t0.231\t43\n114960\t2.669\t0.201\t795\n115206\t2.167\t0.159\t1651\n115207\t2.384\t0.147\t685\n115208\t2.377\t-1.0\t1\n118813\t2.913\t0.463\t3054\n118814\t2.839\t0.079\t11\n118815\t2.711\t0.001\t4\n118816\t2.916\t0.195\t36\n118817\t2.906\t0.257\t48\n118818\t3.003\t0.19\t1185\n118819\t2.89\t0.233\t2162\n118821\t4.015\t-1.0\t1\n118826\t2.96\t-1.0\t1\n118828\t2.952\t0.11\t39\n118829\t2.507\t0.024\t3\n118830\t2.938\t0.19\t22\n118831\t2.849\t0.2\t37\n118834\t2.765\t0.134\t305\n118835\t3.108\t0.155\t31\n118836\t3.39\t0.219\t189\n118837\t3.139\t0.235\t3644\n118839\t3.839\t-1.0\t1\n118858\t2.994\t-1.0\t1\n118861\t2.937\t0.024\t4\n118862\t2.749\t0.231\t11\n118863\t3.089\t0.14\t128\n118864\t2.73\t0.419\t10\n118867\t4.236\t-1.0\t1\n119046\t2.301\t0.205\t1784\n119047\t2.304\t0.132\t28601\n119048\t2.278\t0.16\t3943\n119055\t2.752\t0.18\t205\n119056\t2.764\t0.209\t1501\n119302\t2.425\t0.207\t1326\n119303\t2.302\t0.163\t1333\n119304\t2.514\t0.012\t2\n122910\t2.933\t0.511\t46\n122911\t2.702\t0.368\t7\n122912\t2.663\t0.513\t47\n122913\t2.561\t0.197\t22\n122914\t2.985\t0.238\t269\n122915\t2.799\t0.235\t1020\n122917\t3.448\t-1.0\t1\n122920\t3.428\t0.0\t2\n122922\t3.262\t0.063\t13\n122924\t3.141\t0.257\t36\n122925\t3.024\t0.038\t68\n122926\t3.08\t0.273\t30\n122929\t3.163\t0.018\t2\n122930\t2.751\t0.402\t11\n122932\t3.359\t0.441\t18\n122933\t3.021\t0.24\t382\n122935\t3.714\t-1.0\t1\n122955\t3.014\t0.026\t6\n122957\t3.238\t0.02\t4\n122958\t3.092\t0.105\t29\n122960\t3.074\t0.0\t2\n122961\t2.928\t0.007\t10\n122962\t3.518\t0.023\t8\n122963\t2.553\t0.0\t2\n123142\t2.737\t0.301\t850\n123143\t2.41\t0.137\t13630\n123144\t2.395\t0.157\t2260\n123151\t2.989\t0.176\t11\n123152\t2.86\t0.169\t504\n123398\t2.392\t0.233\t92\n123399\t2.348\t0.155\t241\n127007\t3.02\t0.246\t86\n127008\t2.974\t0.088\t8\n127009\t3.494\t0.451\t21\n127010\t2.829\t0.38\t37\n127011\t2.708\t0.245\t196\n127014\t3.469\t0.079\t7\n127016\t3.23\t0.0\t2\n127018\t3.049\t0.131\t23\n127020\t2.953\t0.101\t22\n127021\t3.009\t0.238\t45\n127022\t3.086\t0.158\t56\n127023\t3.058\t0.009\t4\n127025\t3.335\t0.196\t5\n127026\t3.283\t0.062\t7\n127027\t2.651\t0.769\t24\n127028\t3.434\t0.203\t18\n127029\t3.123\t0.373\t261\n127031\t3.789\t0.084\t6\n127032\t4.457\t-1.0\t1\n127033\t3.667\t-1.0\t1\n127036\t4.074\t0.0\t2\n127039\t4.048\t-1.0\t1\n127046\t4.093\t-1.0\t1\n127050\t2.953\t0.101\t7\n127052\t3.076\t0.218\t4\n127053\t3.176\t0.156\t3\n127054\t2.924\t0.124\t38\n127055\t2.909\t0.082\t10\n127059\t4.205\t0.525\t4\n127068\t3.948\t0.013\t2\n127237\t2.513\t0.281\t7\n127238\t2.422\t0.173\t417\n127239\t2.418\t0.176\t782\n127240\t2.39\t0.178\t153\n127247\t2.978\t0.075\t57\n127248\t2.775\t0.184\t61\n127494\t2.47\t0.44\t42\n127495\t2.406\t0.044\t2\n131109\t3.618\t0.424\t54\n131110\t3.321\t0.053\t36\n131111\t2.973\t0.025\t4\n131112\t3.771\t0.94\t5\n131113\t3.619\t0.341\t9\n131114\t3.143\t0.38\t30\n131116\t2.916\t0.159\t157\n131117\t2.917\t0.159\t121\n131118\t3.04\t0.268\t107\n131119\t2.922\t0.222\t15\n131120\t3.307\t0.038\t4\n131122\t3.411\t0.477\t35\n131123\t3.351\t-1.0\t1\n131127\t3.814\t0.114\t37\n131128\t3.49\t0.107\t29\n131130\t2.988\t0.0\t6\n131137\t2.864\t-1.0\t1\n131138\t3.615\t0.013\t2\n131144\t3.909\t0.169\t5\n131146\t3.079\t0.227\t59\n131147\t2.946\t0.309\t17\n131148\t2.938\t0.152\t48\n131149\t2.889\t0.075\t105\n131150\t2.932\t0.142\t86\n131151\t2.965\t0.315\t19\n131154\t4.158\t0.0\t3\n131155\t3.469\t0.0\t2\n135208\t3.392\t0.193\t9\n135209\t2.553\t0.506\t113\n135210\t2.846\t0.341\t42\n135212\t2.866\t0.212\t135\n135213\t2.927\t0.123\t16\n135214\t2.871\t0.163\t78\n135215\t2.95\t0.206\t41\n135216\t2.799\t0.488\t10\n135217\t2.858\t0.374\t47\n135218\t3.171\t0.414\t88\n135219\t3.525\t0.292\t6\n135226\t2.999\t0.0\t6\n135230\t3.926\t0.069\t11\n135234\t3.555\t0.069\t7\n135237\t4.014\t0.007\t2\n135240\t2.589\t0.032\t8\n135241\t2.464\t0.036\t10\n135242\t2.986\t0.141\t77\n135243\t2.924\t-1.0\t1\n135244\t2.773\t0.037\t5\n135245\t3.046\t0.0\t2\n135246\t2.825\t0.185\t175\n135247\t2.784\t0.162\t65\n135248\t3.475\t0.422\t13\n135249\t3.243\t0.492\t4\n135250\t3.627\t0.385\t15\n135251\t3.822\t0.36\t16\n135258\t3.001\t0.0\t2\n135260\t3.608\t0.228\t9\n135430\t2.312\t0.051\t4\n139303\t3.535\t0.292\t31\n139304\t3.38\t0.183\t24\n139305\t2.623\t0.529\t104\n139306\t3.083\t0.33\t321\n139308\t2.96\t0.162\t229\n139309\t2.923\t0.274\t63\n139310\t2.882\t0.149\t259\n139311\t3.27\t0.202\t438\n139312\t2.668\t0.417\t260\n139313\t3.241\t0.429\t63\n139314\t3.163\t0.399\t546\n139315\t3.191\t0.461\t290\n139321\t3.855\t0.226\t50\n139322\t3.709\t0.138\t100\n139323\t3.684\t0.123\t46\n139324\t3.633\t0.072\t70\n139326\t3.545\t0.123\t112\n139327\t3.991\t0.038\t4\n139328\t3.786\t0.526\t8\n139329\t3.979\t0.001\t4\n139330\t3.537\t0.014\t6\n139331\t3.355\t0.108\t12\n139332\t3.159\t0.173\t21\n139333\t3.624\t0.136\t27\n139334\t3.334\t0.167\t126\n139336\t3.239\t0.487\t10\n139337\t2.614\t0.35\t62\n139338\t3.123\t0.251\t218\n139339\t3.229\t0.309\t1334\n139340\t3.562\t0.717\t14\n139341\t2.945\t0.19\t49\n139342\t2.914\t0.165\t139\n139343\t2.866\t0.183\t165\n139344\t3.14\t0.274\t105\n139345\t3.078\t0.295\t50\n139346\t3.558\t0.371\t43\n139347\t3.512\t0.445\t86\n139354\t3.623\t0.348\t57\n139356\t3.581\t0.414\t207\n139357\t3.553\t0.26\t12\n139358\t3.738\t0.14\t26\n139526\t2.278\t0.056\t6\n143399\t2.881\t0.269\t29\n143400\t3.289\t0.207\t165\n143401\t2.903\t0.415\t136\n143402\t2.928\t0.263\t822\n143404\t2.981\t0.274\t225\n143405\t3.002\t0.373\t123\n143406\t2.929\t0.211\t1350\n143407\t3.15\t0.245\t392\n143408\t3.115\t0.214\t390\n143409\t2.892\t0.454\t277\n143410\t3.152\t0.327\t288\n143411\t3.118\t0.344\t421\n143417\t3.489\t0.306\t26\n143418\t3.66\t0.441\t102\n143419\t2.889\t0.02\t3\n143420\t3.311\t0.239\t14\n143422\t3.519\t0.117\t10\n143423\t3.405\t0.182\t14\n143424\t3.622\t0.201\t10\n143425\t2.902\t0.279\t14\n143426\t3.441\t0.397\t31\n143427\t2.869\t0.248\t16\n143428\t2.769\t0.111\t12\n143430\t3.342\t0.101\t8\n143433\t3.029\t0.413\t218\n143434\t2.63\t0.358\t237\n143435\t2.974\t0.223\t787\n143436\t2.871\t0.256\t91\n143437\t3.02\t0.255\t120\n143438\t2.97\t0.262\t730\n143439\t2.839\t0.219\t570\n143440\t2.939\t0.303\t600\n143441\t2.709\t0.226\t130\n143442\t3.393\t0.358\t470\n143443\t3.237\t0.326\t869\n143450\t3.569\t0.067\t21\n143452\t3.3\t0.463\t144\n143453\t2.771\t0.0\t6\n143454\t3.655\t0.021\t3\n143455\t2.882\t0.023\t3\n151589\t4.027\t0.433\t171\n151590\t3.818\t0.355\t2\n151594\t3.871\t0.0\t2\n151598\t3.586\t0.162\t20\n151599\t3.353\t0.049\t2\n151601\t3.937\t0.0\t2\n151602\t3.839\t0.296\t15\n151603\t3.859\t0.378\t36\n151607\t4.188\t0.029\t2\n151631\t3.626\t0.064\t26\n151633\t3.814\t0.025\t4\n151634\t3.849\t0.071\t10\n151635\t4.057\t0.0\t2\n151814\t3.815\t0.247\t64\n152069\t3.392\t0.0\t2\n152070\t3.728\t0.185\t7\n155686\t3.715\t0.263\t197\n155692\t3.291\t0.0\t2\n155693\t3.275\t0.0\t2\n155695\t3.371\t-1.0\t1\n155696\t3.544\t0.083\t4\n155697\t3.415\t0.077\t36\n155698\t3.446\t0.074\t26\n155699\t3.346\t0.137\t70\n155703\t4.039\t0.114\t2\n155704\t3.785\t-1.0\t1\n155725\t3.3\t0.0\t4\n155726\t3.174\t0.064\t8\n155727\t3.236\t0.051\t4\n155728\t3.411\t0.02\t2\n155729\t3.492\t0.006\t3\n155730\t3.53\t0.066\t10\n155731\t3.424\t0.132\t88\n155740\t3.534\t-1.0\t1\n155910\t3.584\t0.272\t112\n156166\t2.793\t0.019\t4\n159783\t4.713\t0.009\t2\n159790\t3.627\t0.388\t4\n159795\t3.832\t0.039\t12\n159797\t3.719\t0.347\t56\n159799\t4.168\t0.0\t2\n159822\t3.558\t0.003\t2\n160005\t3.476\t0.074\t35\n160006\t3.258\t0.191\t4054\n160007\t2.913\t0.142\t1412\n160008\t2.796\t0.249\t708\n160015\t3.636\t0.026\t3\n160016\t3.367\t0.408\t27\n160262\t2.99\t0.127\t72\n160263\t3.031\t0.264\t24\n163884\t3.712\t0.084\t3\n163885\t3.713\t0.26\t5\n163889\t3.399\t0.0\t2\n163890\t3.989\t0.377\t5\n163892\t3.476\t0.0\t2\n163893\t3.302\t0.424\t87\n163917\t3.364\t0.045\t5\n163918\t3.314\t0.355\t6\n163922\t4.034\t-1.0\t1\n164101\t3.255\t0.125\t9\n164102\t3.029\t0.219\t13290\n164103\t2.812\t0.186\t1007\n164104\t2.599\t0.231\t718\n164111\t3.355\t0.275\t19\n164112\t3.184\t0.119\t22\n164358\t2.805\t0.151\t103\n164359\t2.642\t0.21\t22\n164360\t2.844\t0.216\t9\n167977\t2.746\t0.433\t12\n167986\t3.166\t-1.0\t1\n167988\t3.668\t0.819\t15\n167989\t2.936\t0.216\t20\n168198\t2.975\t0.237\t953\n168199\t2.749\t0.24\t450\n168200\t2.532\t0.296\t44\n168207\t3.165\t0.13\t49\n168208\t3.318\t0.08\t14\n168454\t2.601\t0.169\t111\n168455\t2.727\t0.161\t25\n172074\t2.912\t0.373\t1298\n172076\t3.157\t0.34\t9\n172078\t3.301\t0.025\t5\n172079\t3.222\t0.067\t8\n172082\t3.28\t0.259\t30\n172083\t3.177\t0.165\t15\n172084\t3.327\t0.193\t23\n172085\t3.272\t0.292\t557\n172087\t3.799\t-1.0\t1\n172088\t3.528\t-1.0\t1\n172106\t2.727\t0.462\t6\n172107\t3.735\t-1.0\t1\n172109\t3.252\t0.082\t43\n172110\t3.239\t0.183\t9\n172111\t3.197\t0.132\t22\n172112\t3.584\t0.076\t4\n172114\t3.693\t0.232\t12\n172115\t3.359\t0.28\t40\n172124\t3.744\t0.013\t2\n172293\t3.03\t0.256\t14\n172294\t2.789\t0.167\t9278\n172295\t2.577\t0.18\t3098\n172296\t2.467\t0.259\t1296\n172303\t2.908\t0.239\t150\n172304\t2.957\t0.217\t165\n172550\t2.341\t0.159\t4663\n172551\t2.511\t0.149\t218\n172559\t2.202\t0.279\t10\n180268\t3.063\t0.299\t1102\n180269\t2.945\t0.515\t10\n180270\t3.082\t0.36\t14\n180271\t3.086\t-1.0\t1\n180272\t3.242\t0.131\t2\n180273\t3.439\t0.268\t6\n180274\t3.072\t0.196\t129\n180275\t3.213\t0.211\t24\n180276\t3.091\t0.153\t98\n180277\t3.22\t0.208\t173\n180295\t3.709\t0.109\t4\n180296\t3.674\t0.024\t2\n180298\t3.338\t0.368\t8\n180299\t3.08\t0.02\t2\n180300\t3.051\t0.136\t6\n180301\t3.2\t0.237\t31\n180302\t3.182\t0.186\t59\n180303\t2.975\t0.164\t24\n180304\t3.255\t-1.0\t1\n180306\t2.931\t0.041\t12\n180307\t2.734\t0.077\t20\n180485\t2.755\t0.204\t14\n180486\t2.611\t0.146\t28221\n180487\t2.363\t0.139\t11820\n180488\t2.408\t0.153\t1326\n180495\t2.75\t0.202\t77\n180496\t2.828\t0.175\t621\n180742\t2.163\t0.16\t10524\n180743\t2.394\t0.13\t880\n180744\t2.447\t0.224\t6\n180751\t2.688\t0.012\t5\n180752\t2.464\t0.284\t5\n184365\t2.871\t0.285\t392\n184366\t3.302\t0.52\t4\n184367\t2.634\t0.029\t2\n184368\t2.701\t-1.0\t1\n184369\t3.216\t0.427\t13\n184370\t3.333\t0.264\t124\n184371\t3.063\t0.086\t29\n184372\t3.343\t0.188\t5\n184373\t3.193\t0.194\t327\n184396\t2.794\t0.148\t26\n184397\t2.962\t0.816\t2\n184398\t2.985\t0.39\t19\n184399\t3.255\t0.176\t61\n184400\t3.215\t0.059\t6\n184402\t3.402\t0.003\t2\n184403\t3.348\t0.247\t21\n184412\t3.283\t0.005\t3\n184581\t2.634\t0.295\t6\n184582\t2.568\t0.171\t12855\n184583\t2.441\t0.153\t3081\n184584\t2.416\t0.166\t1225\n184591\t2.739\t0.094\t61\n184592\t2.805\t0.202\t148\n184837\t2.886\t-1.0\t1\n184838\t2.196\t0.199\t2670\n184839\t2.45\t0.148\t279\n184848\t2.287\t0.009\t6\n188462\t3.197\t0.284\t549\n188463\t3.567\t0.174\t71\n188465\t3.129\t0.275\t2\n188466\t3.378\t0.343\t81\n188467\t3.278\t0.49\t122\n188468\t3.121\t0.318\t140\n188469\t3.118\t0.179\t936\n188472\t3.155\t0.189\t11\n188486\t2.788\t-1.0\t1\n188487\t3.697\t0.043\t2\n188490\t3.361\t-1.0\t1\n188491\t3.319\t0.01\t2\n188492\t3.071\t0.101\t16\n188494\t3.253\t0.286\t17\n188495\t3.308\t0.347\t126\n188496\t3.082\t0.313\t5\n188497\t3.342\t0.379\t39\n188498\t3.685\t0.035\t11\n188499\t2.981\t0.028\t91\n188508\t3.265\t0.257\t3\n188677\t2.545\t0.218\t11\n188678\t2.381\t0.169\t6266\n188679\t2.365\t0.135\t7580\n188680\t2.446\t0.147\t1073\n188687\t2.778\t0.159\t82\n188688\t2.732\t0.177\t615\n188934\t2.405\t0.21\t1341\n188935\t2.38\t0.131\t281\n188936\t2.152\t0.004\t2\n188944\t2.657\t0.082\t9\n192559\t3.554\t0.226\t4083\n192561\t2.716\t-1.0\t1\n192562\t3.443\t0.292\t14\n192563\t3.163\t0.241\t12\n192564\t3.698\t0.229\t62\n192565\t3.522\t0.275\t796\n192572\t3.827\t0.068\t3\n192587\t3.3\t0.096\t6\n192588\t3.119\t0.06\t30\n192589\t3.417\t0.237\t27\n192590\t3.436\t0.273\t279\n192591\t3.326\t0.24\t399\n192592\t2.823\t0.436\t7\n192774\t2.472\t0.2\t1611\n192775\t2.535\t0.173\t5301\n192776\t2.731\t0.17\t305\n192783\t2.898\t0.163\t18\n192784\t3.194\t0.23\t847\n193030\t2.719\t0.257\t1011\n193031\t2.571\t0.187\t351\n196656\t2.962\t0.143\t4\n196659\t2.984\t0.064\t32\n196660\t3.488\t0.2\t53\n196661\t3.212\t0.24\t422\n196664\t3.568\t0.009\t4\n196686\t3.302\t0.12\t162\n196687\t3.375\t0.136\t15\n196690\t3.639\t0.028\t8\n196691\t3.016\t0.052\t32\n196870\t2.546\t0.218\t32\n196871\t2.669\t0.125\t3379\n196872\t2.711\t0.152\t719\n196880\t3.123\t0.225\t349\n197126\t2.828\t0.381\t77\n197127\t2.606\t0.119\t56\n197128\t2.751\t-1.0\t1\n200753\t2.968\t0.291\t109\n200754\t3.781\t0.18\t17\n200755\t2.926\t0.006\t4\n200756\t3.55\t0.394\t50\n200757\t3.215\t0.314\t179\n200759\t3.813\t0.152\t8\n200760\t3.68\t0.079\t15\n200778\t3.2\t0.021\t2\n200779\t2.798\t0.024\t24\n200781\t2.816\t0.38\t2\n200782\t3.146\t0.138\t51\n200783\t3.783\t-1.0\t1\n200784\t3.608\t0.06\t2\n200787\t3.701\t0.063\t13\n200966\t2.737\t0.248\t164\n200967\t2.638\t0.193\t666\n200968\t2.735\t0.196\t128\n200975\t3.61\t0.145\t5\n200976\t2.787\t0.336\t60\n201222\t2.754\t0.18\t12\n201223\t2.897\t0.149\t12\n204850\t3.629\t0.476\t976\n204851\t2.793\t0.054\t34\n204852\t3.367\t0.645\t98\n204853\t3.325\t0.463\t310\n204855\t3.996\t0.344\t33\n204856\t3.682\t0.08\t11\n204857\t3.947\t0.023\t6\n204858\t3.186\t0.0\t6\n204863\t3.44\t0.0\t11\n204866\t3.929\t-1.0\t1\n204870\t3.525\t0.118\t8\n204872\t4.135\t0.14\t3\n204874\t3.301\t0.205\t57\n204875\t3.121\t0.234\t55\n204876\t3.203\t0.168\t70\n204877\t3.061\t0.08\t42\n204878\t3.284\t0.173\t281\n204879\t4.309\t0.589\t23\n204881\t3.669\t0.346\t5\n204882\t3.46\t0.055\t10\n204883\t3.636\t0.704\t18\n204892\t4.537\t-1.0\t1\n205061\t2.753\t0.308\t17\n205062\t2.528\t0.15\t3869\n205063\t2.708\t0.199\t1070\n205064\t2.716\t0.2\t545\n205071\t3.421\t0.246\t38\n205072\t3.123\t0.212\t212\n205318\t2.574\t0.174\t88\n205319\t2.626\t0.158\t25\n208947\t2.969\t0.506\t259\n208948\t3.77\t0.671\t12\n208949\t3.392\t0.45\t229\n208951\t3.952\t0.118\t44\n208952\t3.545\t0.115\t138\n208953\t3.197\t0.0\t6\n208954\t3.176\t0.0\t6\n208962\t3.825\t0.039\t12\n208968\t3.44\t-1.0\t1\n208970\t3.273\t0.166\t30\n208971\t3.245\t0.214\t83\n208972\t2.968\t0.115\t113\n208973\t3.43\t0.067\t4\n208974\t3.1\t0.205\t80\n208975\t3.122\t0.204\t60\n208976\t3.551\t0.081\t6\n208977\t4.668\t0.032\t6\n208978\t4.088\t0.033\t12\n208979\t2.917\t0.271\t11\n209158\t2.495\t0.15\t1844\n209159\t2.721\t0.28\t225\n209160\t2.668\t0.436\t78\n209167\t3.017\t0.046\t5\n209168\t3.149\t0.165\t38\n209414\t2.509\t0.24\t10\n209415\t2.427\t0.146\t6\n213050\t4.433\t0.045\t6\n213054\t4.024\t0.099\t10\n213065\t5.027\t-1.0\t1\n213066\t2.704\t0.455\t23\n213067\t3.276\t0.286\t165\n213068\t3.025\t0.034\t20\n213070\t3.155\t0.284\t48\n213071\t3.03\t0.209\t38\n213072\t3.343\t0.249\t92\n213073\t4.446\t0.01\t2\n213074\t4.01\t0.314\t16\n213075\t3.489\t0.653\t32\n213084\t3.85\t0.333\t22\n213086\t4.355\t0.043\t6\n217145\t3.893\t0.312\t115\n217146\t4.057\t0.272\t72\n217147\t3.309\t0.409\t38\n217148\t3.875\t0.23\t104\n217150\t3.913\t0.338\t122\n217151\t4.078\t0.166\t14\n217152\t3.772\t0.324\t18\n217153\t3.606\t0.456\t25\n217154\t3.192\t0.524\t27\n217156\t3.103\t0.413\t22\n217157\t3.863\t0.489\t46\n217158\t3.761\t0.157\t82\n217159\t3.66\t0.413\t6\n217160\t3.35\t0.322\t22\n217161\t2.816\t0.4\t52\n217162\t2.801\t0.247\t341\n217163\t2.814\t0.353\t94\n217164\t2.999\t0.191\t26\n217165\t3.222\t0.232\t233\n217166\t3.234\t0.277\t811\n217167\t3.066\t0.296\t281\n217168\t3.131\t0.252\t665\n217169\t2.89\t0.413\t19\n217170\t3.801\t0.427\t565\n217171\t3.582\t0.409\t827\n217178\t3.927\t0.242\t20\n217180\t3.819\t0.264\t406\n217182\t3.899\t0.189\t7\n217183\t3.278\t-1.0\t1\n225335\t4.276\t0.49\t265\n225336\t4.479\t0.154\t3\n225338\t4.3\t0.0\t2\n225345\t4.243\t-1.0\t1\n225346\t4.182\t-1.0\t1\n225354\t3.789\t-1.0\t1\n225359\t3.687\t0.153\t5\n225360\t4.965\t0.0\t3\n225361\t4.086\t0.077\t5\n225362\t3.938\t0.124\t17\n225363\t4.209\t0.153\t5\n225542\t4.026\t0.331\t148\n225797\t3.377\t0.162\t3\n225798\t3.864\t0.248\t33\n229432\t4.077\t0.334\t194\n229450\t3.552\t0.0\t2\n229455\t3.61\t0.0\t2\n229458\t3.779\t0.076\t5\n229459\t3.62\t0.105\t15\n229638\t3.726\t0.142\t169\n229893\t2.88\t0.148\t17\n233547\t3.663\t0.041\t4\n233733\t3.661\t0.127\t9\n233734\t3.511\t0.169\t1320\n233735\t3.103\t0.143\t699\n233736\t2.952\t0.191\t544\n233743\t4.137\t0.779\t6\n233744\t3.541\t0.191\t21\n233990\t3.356\t0.17\t18\n233991\t3.128\t0.157\t55\n237830\t3.517\t0.262\t866\n237831\t3.053\t0.238\t780\n237832\t2.942\t0.272\t364\n237839\t3.058\t0.078\t3\n237840\t3.557\t0.208\t14\n238086\t3.309\t0.197\t15\n238087\t3.084\t0.184\t40\n241926\t3.477\t0.124\t197\n241927\t3.016\t0.163\t300\n241928\t2.871\t0.151\t320\n241936\t3.545\t0.074\t6\n242182\t3.213\t0.142\t3\n242183\t3.034\t0.049\t17\n246021\t3.749\t-1.0\t1\n246022\t3.442\t0.199\t803\n246023\t3.027\t0.153\t733\n246024\t2.83\t0.16\t737\n246031\t3.715\t0.509\t10\n246032\t3.489\t0.117\t10\n246278\t3.07\t0.175\t7\n246279\t3.018\t0.113\t65\n254014\t3.621\t0.145\t11\n254027\t3.568\t0.017\t3\n254214\t3.39\t0.158\t2671\n254215\t2.996\t0.161\t998\n254216\t2.805\t0.192\t556\n254223\t3.737\t0.252\t40\n254224\t3.439\t0.148\t13\n254470\t3.227\t0.142\t6\n254471\t3.139\t0.173\t24\n254472\t2.911\t0.206\t20\n258111\t2.215\t0.23\t2\n258310\t3.466\t0.262\t271\n258311\t2.927\t0.187\t1239\n258312\t2.76\t0.166\t1083\n258320\t3.383\t0.05\t12\n258566\t3.457\t0.042\t4\n258567\t2.819\t0.112\t11\n262406\t3.329\t0.213\t453\n262407\t2.926\t0.184\t889\n262408\t2.796\t0.186\t1231\n262416\t3.355\t0.381\t10\n262662\t2.919\t0.044\t2\n262663\t2.999\t0.226\t11\n266502\t3.401\t0.179\t388\n266503\t2.89\t0.17\t992\n266504\t2.734\t0.193\t1159\n266511\t3.732\t-1.0\t1\n266512\t3.445\t0.0\t2\n266758\t2.926\t-1.0\t1\n266759\t2.857\t0.231\t31\n270597\t3.404\t0.076\t3\n270598\t3.222\t0.253\t1595\n270599\t2.866\t0.193\t2042\n270600\t2.707\t0.189\t2073\n270607\t3.718\t-1.0\t1\n270608\t3.41\t0.38\t13\n270854\t2.9\t-1.0\t1\n270855\t2.794\t0.192\t30\n274510\t4.001\t0.0\t2\n274694\t3.388\t0.171\t354\n274695\t2.87\t0.172\t416\n274696\t2.724\t0.185\t439\n274950\t2.925\t0.039\t8\n274951\t2.479\t0.253\t12\n278789\t3.409\t0.069\t2\n278790\t3.158\t0.169\t1145\n278791\t2.849\t0.175\t801\n278792\t2.672\t0.179\t577\n278799\t3.625\t-1.0\t1\n278800\t3.474\t0.092\t7\n279046\t2.934\t0.097\t12\n279047\t2.89\t0.09\t12\n282693\t3.553\t0.0\t4\n282886\t3.443\t0.178\t536\n282887\t2.879\t0.209\t168\n282888\t2.725\t0.147\t129\n282895\t3.631\t0.142\t21\n282896\t3.222\t0.01\t8\n283143\t2.527\t0.136\t9\n286981\t3.507\t0.084\t5\n286982\t3.184\t0.155\t3390\n286983\t2.859\t0.153\t1245\n286984\t2.682\t0.159\t499\n286991\t3.54\t0.155\t13\n286992\t3.365\t0.159\t9\n287238\t3.019\t0.138\t24\n287239\t2.855\t0.076\t16\n287240\t2.979\t0.21\t26\n290891\t3.455\t0.011\t2\n290894\t3.514\t-1.0\t1\n291077\t3.476\t0.16\t11\n291078\t3.284\t0.204\t878\n291079\t2.84\t0.187\t460\n291080\t2.635\t0.193\t132\n291088\t3.528\t0.062\t2\n291334\t2.883\t0.06\t12\n291335\t2.948\t0.137\t14\n294994\t3.999\t-1.0\t1\n295173\t3.165\t0.193\t2\n295174\t3.107\t0.177\t2432\n295175\t2.774\t0.182\t341\n295176\t2.652\t0.204\t104\n295184\t3.109\t0.166\t9\n295430\t2.767\t0.112\t12\n295431\t2.657\t0.278\t12\n299081\t2.935\t0.369\t17\n299085\t3.119\t0.214\t10\n299270\t2.918\t0.218\t1400\n299271\t2.737\t0.199\t305\n299272\t2.492\t0.248\t40\n299279\t2.559\t0.037\t4\n299526\t2.488\t0.241\t28\n299527\t2.804\t0.155\t6\n303178\t2.675\t0.417\t434\n303181\t3.222\t0.078\t41\n303182\t3.654\t-1.0\t1\n303183\t3.21\t0.023\t4\n303186\t3.733\t0.044\t8\n303187\t3.128\t0.192\t8\n303365\t2.968\t0.028\t2\n303366\t2.8\t0.213\t3774\n303367\t2.584\t0.227\t2258\n303368\t2.49\t0.297\t312\n303375\t2.904\t0.202\t124\n303376\t3.053\t0.272\t32\n303622\t2.342\t0.159\t6180\n303623\t2.471\t0.154\t65\n307275\t3.127\t0.383\t1161\n307276\t3.076\t0.401\t28\n307277\t3.191\t0.02\t2\n307278\t3.567\t0.117\t38\n307279\t3.269\t0.094\t25\n307280\t3.228\t0.038\t20\n307281\t3.587\t0.03\t2\n307283\t3.205\t0.081\t30\n307292\t3.713\t0.164\t4\n307462\t2.629\t0.197\t1542\n307463\t2.457\t0.127\t3999\n307464\t2.435\t0.206\t207\n307471\t2.732\t0.251\t11\n307472\t2.825\t0.122\t121\n307718\t2.178\t0.135\t8471\n307719\t2.383\t0.156\t157\n307720\t2.299\t0.121\t3\n307728\t2.409\t0.014\t6\n311372\t3.106\t0.207\t804\n311373\t3.181\t-1.0\t1\n311374\t3.548\t0.146\t32\n311375\t3.12\t0.036\t62\n311379\t2.887\t0.06\t22\n311558\t2.597\t0.187\t2089\n311559\t2.357\t0.157\t1187\n311560\t2.486\t0.163\t95\n311567\t3.048\t0.26\t4\n311568\t3.082\t0.291\t44\n311814\t2.108\t0.152\t4572\n311815\t2.428\t0.139\t86\n311824\t2.543\t0.001\t4\n315469\t3.151\t0.278\t365\n315470\t3.549\t0.122\t63\n315471\t3.157\t0.118\t31\n315475\t3.22\t0.061\t39\n315653\t2.65\t0.215\t20\n315654\t2.552\t0.195\t16080\n315655\t2.382\t0.126\t6084\n315656\t2.483\t0.127\t418\n315663\t2.762\t0.14\t37\n315664\t2.816\t0.196\t162\n315910\t2.215\t0.168\t2203\n315911\t2.436\t0.105\t204\n315920\t2.977\t-1.0\t1\n319566\t3.225\t0.248\t552\n319567\t3.367\t0.293\t115\n319568\t3.169\t0.205\t20\n319569\t3.36\t0.238\t50\n319570\t3.392\t0.286\t42\n319571\t2.929\t0.286\t8\n319580\t2.758\t-1.0\t1\n319749\t2.528\t0.434\t19\n319750\t2.374\t0.187\t4743\n319751\t2.364\t0.145\t6282\n319752\t2.404\t0.169\t399\n319759\t2.743\t0.15\t63\n319760\t2.674\t0.189\t638\n320005\t2.585\t0.095\t3\n320006\t2.331\t0.173\t2612\n320007\t2.357\t0.121\t135\n320015\t2.781\t0.006\t2\n320016\t2.898\t0.124\t6\n323663\t3.245\t0.336\t4562\n323664\t3.526\t0.142\t2\n323665\t3.286\t0.102\t22\n323666\t3.306\t0.022\t2\n323667\t2.881\t0.196\t25\n323846\t2.35\t0.15\t3014\n323847\t2.354\t0.137\t1158\n323848\t2.403\t0.253\t6\n323855\t2.769\t0.169\t45\n323856\t2.739\t0.213\t222\n324102\t2.337\t0.19\t1691\n324103\t2.388\t0.156\t45\n327760\t2.694\t0.474\t53\n327941\t2.577\t-1.0\t1\n327942\t2.266\t0.136\t922\n327943\t2.741\t0.157\t953\n327944\t2.741\t0.235\t37\n327951\t2.904\t0.093\t8\n327952\t2.866\t0.242\t158\n328198\t2.38\t0.168\t94\n328199\t2.875\t0.15\t3\n331857\t3.111\t0.21\t60\n332038\t2.542\t0.227\t19\n332039\t2.984\t0.13\t175\n332040\t2.942\t0.295\t20\n332048\t3.399\t0.21\t18\n332294\t2.174\t0.0\t4\n335954\t3.231\t0.429\t436\n336134\t2.776\t0.248\t252\n336135\t2.833\t0.135\t693\n336136\t2.76\t0.196\t207\n336143\t3.678\t0.123\t15\n336144\t3.263\t0.218\t66\n336390\t2.874\t0.122\t4\n336391\t2.699\t0.147\t7\n340051\t3.126\t0.27\t404\n340229\t2.797\t-1.0\t1\n340230\t2.623\t0.24\t807\n340231\t2.807\t0.169\t491\n340232\t2.771\t0.212\t269\n340239\t3.206\t0.012\t2\n340240\t3.325\t0.293\t98\n340486\t2.701\t0.167\t16\n340487\t3.129\t0.34\t2\n368902\t3.528\t0.229\t2516\n368903\t3.077\t0.237\t337\n368904\t2.966\t0.304\t84\n368911\t3.616\t0.121\t7\n368912\t3.535\t0.376\t64\n369158\t3.14\t0.113\t14\n369159\t3.146\t0.323\t8\n369160\t3.179\t0.006\t2\n376924\t3.747\t0.0\t2\n377094\t3.44\t0.227\t3394\n377095\t2.982\t0.201\t1971\n377096\t2.826\t0.242\t770\n377103\t2.998\t0.426\t10\n377104\t3.462\t0.179\t110\n377350\t3.258\t0.302\t74\n377351\t3.02\t0.219\t96\n377352\t3.011\t0.211\t9\n381190\t3.595\t0.186\t49\n381191\t3.016\t0.171\t33\n381192\t3.071\t0.23\t47\n381200\t3.429\t0.053\t8\n385286\t3.676\t0.046\t15\n385287\t3.005\t0.218\t31\n385288\t3.065\t0.263\t47\n385296\t3.84\t0.251\t6\n389383\t3.107\t0.032\t5\n389384\t2.858\t0.234\t18\n389392\t3.517\t0.038\t3\n393479\t3.128\t0.008\t2\n393488\t3.419\t0.064\t3\n397575\t3.05\t0.029\t3\n397576\t2.942\t0.008\t3\n401671\t3.038\t0.025\t3\n401672\t2.931\t0.016\t3\n1073414\t1.594\t0.077\t2000853\n1073415\t1.527\t0.071\t91806\n1073423\t2.001\t0.161\t74\n1073424\t1.981\t0.067\t42\n1073679\t2.05\t0.093\t4\n1073680\t1.992\t0.039\t7\n1077511\t1.504\t0.087\t791\n1077519\t1.839\t0.106\t1862\n1077520\t1.811\t0.097\t38\n1077776\t1.753\t0.11\t23\n1110287\t2.325\t0.221\t8\n16781317\t1.299\t0.138\t2655\n16781318\t1.157\t0.073\t2154155\n16781319\t1.027\t0.087\t120477\n16781320\t1.0\t0.102\t99234\n16781321\t1.229\t0.768\t39\n16781326\t1.698\t0.206\t492\n16781327\t1.491\t0.16\t461\n16781328\t1.414\t0.148\t260\n16781329\t1.46\t0.267\t16\n16781344\t1.768\t0.207\t170\n16781345\t1.64\t0.233\t13\n16781346\t1.184\t0.24\t11\n16781347\t1.193\t0.14\t10\n16781365\t1.612\t0.001\t2\n16781573\t1.266\t-1.0\t1\n16781574\t1.083\t0.054\t1399983\n16781575\t1.026\t0.08\t10086\n16781576\t1.035\t0.083\t62\n16781583\t1.555\t0.169\t170\n16781830\t1.082\t0.064\t1503\n16781831\t1.012\t0.075\t9\n16797701\t2.055\t0.175\t200\n16797702\t1.917\t0.136\t1968\n16797703\t1.74\t0.145\t4307\n16797704\t1.627\t0.111\t7838\n16797705\t1.579\t0.095\t5410\n16797710\t2.643\t0.184\t32\n16797711\t2.367\t0.191\t736\n16797712\t2.279\t0.266\t207\n16797713\t2.22\t0.188\t513\n16797728\t2.564\t0.128\t21\n16797729\t2.481\t0.101\t5\n16797730\t2.577\t0.148\t48\n16797731\t2.401\t0.231\t244\n16797748\t2.725\t0.14\t4\n16797749\t2.87\t0.374\t77\n16797958\t1.838\t0.106\t11969\n16797959\t1.825\t0.108\t1915\n16797967\t2.268\t0.255\t20\n16798214\t1.868\t0.127\t268\n16798215\t1.772\t0.141\t42\n16798224\t2.259\t-1.0\t1\n16801798\t1.819\t0.111\t650683\n16801799\t1.721\t0.104\t153277\n16801800\t1.674\t0.089\t194202\n16801801\t1.483\t0.083\t37441\n16801806\t2.363\t0.237\t31159\n16801807\t2.243\t0.189\t5173\n16801808\t2.128\t0.132\t11654\n16801809\t2.024\t0.124\t15529\n16801824\t2.527\t0.248\t999\n16801825\t2.422\t0.325\t206\n16801826\t2.378\t0.18\t872\n16801827\t2.279\t0.155\t2704\n16801844\t2.666\t0.308\t172\n16801845\t2.522\t0.166\t717\n16802054\t1.762\t0.092\t352183\n16802055\t1.72\t0.097\t14388\n16802056\t1.688\t0.108\t6\n16802063\t2.207\t0.172\t3307\n16802064\t2.105\t0.131\t3350\n16802310\t1.696\t0.091\t7665\n16802311\t1.656\t0.128\t75\n16802320\t2.082\t0.116\t4919\n16805895\t1.623\t0.108\t3208\n16805896\t1.666\t0.126\t2100\n16805897\t1.415\t0.162\t17\n16805902\t2.205\t0.191\t1967\n16805903\t2.079\t0.152\t1682\n16805904\t1.93\t0.103\t249\n16805905\t1.958\t0.111\t24\n16805920\t2.362\t0.195\t1315\n16805921\t2.241\t0.173\t128\n16805922\t2.3\t0.193\t96\n16805923\t2.162\t0.118\t32\n16805940\t2.674\t0.201\t118\n16805941\t2.473\t0.194\t38\n16806150\t1.59\t0.082\t164495\n16806151\t1.574\t0.081\t7627\n16806159\t1.986\t0.139\t3197\n16806160\t2.009\t0.09\t401\n16806406\t1.512\t0.069\t153\n16806407\t1.394\t0.086\t533\n16806416\t1.9\t0.093\t9234\n16809992\t1.741\t0.264\t647\n16809998\t1.995\t0.155\t7813\n16809999\t1.925\t0.144\t1208\n16810000\t1.916\t0.201\t51\n16810001\t1.673\t0.087\t998\n16810016\t2.152\t0.242\t1021\n16810017\t1.796\t0.244\t670\n16810018\t2.006\t0.2\t174\n16810019\t1.965\t0.381\t4\n16810036\t2.404\t0.302\t460\n16810037\t2.386\t0.22\t205\n16810246\t1.562\t0.08\t163577\n16810247\t1.393\t0.102\t21110\n16810255\t1.861\t0.129\t9068\n16810256\t1.926\t0.104\t123\n16810502\t1.408\t0.07\t41\n16810503\t1.354\t0.073\t7\n16810512\t1.734\t0.114\t5958\n16814089\t1.446\t0.064\t5\n16814094\t1.979\t0.162\t679\n16814095\t1.82\t0.095\t9307\n16814096\t1.773\t0.108\t625\n16814097\t1.615\t0.213\t20\n16814112\t2.054\t0.303\t209\n16814113\t1.845\t0.169\t415\n16814114\t2.218\t0.193\t16\n16814115\t1.836\t0.098\t23\n16814132\t1.837\t0.254\t287\n16814133\t2.14\t0.294\t84\n16814342\t1.478\t0.072\t44091\n16814343\t1.246\t0.169\t3\n16814351\t1.618\t0.194\t150\n16814352\t1.613\t0.103\t16\n16814608\t1.556\t0.127\t44\n16834574\t3.378\t0.364\t2682\n16834575\t2.882\t0.272\t162\n16834576\t2.626\t0.23\t157\n16834577\t2.549\t0.274\t1011\n16834592\t3.473\t0.286\t507\n16834593\t3.314\t0.371\t24\n16834594\t2.897\t0.327\t42\n16834595\t2.87\t0.389\t169\n16834612\t3.665\t0.536\t15\n16834613\t3.09\t0.417\t78\n16834822\t2.235\t0.149\t6897\n16834823\t2.299\t0.166\t545\n16835078\t2.237\t0.123\t1405\n16835079\t2.102\t0.162\t46\n16838671\t2.751\t0.246\t664\n16838672\t2.368\t0.224\t165\n16838673\t2.447\t0.27\t425\n16838688\t3.18\t0.313\t89\n16838689\t2.773\t0.119\t26\n16838690\t2.582\t0.333\t127\n16838691\t2.563\t0.288\t58\n16838708\t3.027\t0.178\t12\n16838709\t2.915\t0.394\t101\n16838918\t2.115\t0.115\t8657\n16838919\t1.855\t0.183\t439\n16838927\t2.715\t0.169\t135\n16838928\t2.658\t0.069\t6\n16839174\t1.936\t0.185\t23\n16839175\t2.101\t0.064\t2\n16839184\t2.948\t-1.0\t1\n16842768\t2.281\t0.201\t1234\n16842769\t2.015\t0.03\t13\n16842784\t2.754\t0.331\t616\n16842785\t2.241\t0.25\t917\n16842786\t2.475\t0.266\t49\n16842787\t2.694\t0.214\t14\n16842804\t3.261\t0.399\t44\n16842805\t3.241\t0.251\t46\n16843014\t2.01\t0.115\t20813\n16843015\t1.834\t0.133\t156\n16843023\t2.464\t0.209\t339\n16843024\t2.494\t0.161\t19\n16843270\t1.935\t0.13\t225\n16843280\t2.489\t0.19\t50\n16846865\t1.992\t0.399\t44\n16846880\t2.745\t0.286\t511\n16846881\t2.728\t0.235\t235\n16846882\t2.384\t0.337\t109\n16846900\t3.03\t0.369\t277\n16846901\t2.906\t0.468\t87\n16847110\t1.969\t0.095\t20992\n16847111\t1.77\t0.177\t16\n16847119\t2.289\t0.187\t1133\n16847120\t2.181\t0.113\t8\n16847366\t1.923\t0.203\t4\n16847376\t2.231\t0.165\t28\n16908320\t3.119\t0.561\t1100\n16908321\t2.481\t0.4\t70\n16908322\t2.624\t0.585\t344\n16908323\t2.911\t0.375\t127\n16908340\t3.181\t0.424\t124\n16908341\t3.271\t0.469\t73\n16908550\t2.342\t0.169\t2233\n16908551\t2.432\t0.175\t414\n16908552\t2.284\t0.062\t14\n16908559\t3.148\t0.384\t31\n16908806\t2.273\t0.193\t233\n16912417\t2.568\t0.286\t226\n16912418\t2.384\t0.277\t52\n16912419\t2.383\t0.526\t37\n16912436\t2.868\t0.102\t3\n16912437\t3.175\t0.376\t43\n16912646\t2.247\t0.155\t563\n16912647\t2.196\t0.137\t13\n16912655\t2.8\t0.063\t13\n16912902\t1.902\t0.429\t4\n16912903\t2.164\t0.088\t7\n16916514\t2.705\t0.288\t257\n16916515\t2.826\t0.329\t129\n16916532\t3.054\t0.385\t17\n16916533\t3.596\t0.24\t25\n16916742\t2.215\t0.127\t1635\n16916743\t1.989\t0.141\t55\n16916751\t2.686\t0.173\t226\n16916752\t2.64\t-1.0\t1\n16916998\t2.197\t0.154\t196\n16920611\t3.015\t0.264\t187\n16920628\t3.279\t0.255\t239\n16920629\t3.195\t0.403\t63\n16920838\t2.164\t0.108\t13670\n16920839\t2.524\t0.134\t43\n16920847\t2.176\t0.207\t50\n16920848\t2.785\t0.214\t9\n16921094\t2.117\t0.097\t16\n16990260\t3.228\t0.382\t40\n16990261\t3.606\t0.35\t107\n16990470\t2.49\t0.154\t812\n16990471\t2.273\t0.267\t50\n16990472\t3.042\t-1.0\t1\n16990479\t3.31\t0.124\t16\n16990726\t2.535\t0.253\t17\n16994357\t3.54\t0.331\t863\n16994566\t2.373\t0.134\t5123\n16994567\t2.597\t0.154\t114\n16994575\t3.258\t0.143\t18\n16994822\t2.308\t0.108\t265\n16994823\t2.683\t0.0\t2\n17846534\t1.807\t0.004\t6\n17850630\t1.686\t0.082\t194786\n17850631\t1.634\t0.082\t26774\n17850632\t1.542\t0.034\t5\n17850639\t2.101\t0.105\t7379\n17850640\t2.077\t0.073\t1123\n17850886\t1.624\t0.087\t18128\n17850887\t1.587\t0.111\t90\n17850896\t2.041\t0.093\t13784\n17854727\t1.605\t0.077\t739\n17854735\t1.988\t0.193\t481\n17854736\t2.01\t0.157\t103\n17854982\t1.518\t0.05\t118\n17854983\t1.299\t0.035\t2\n17854991\t2.079\t0.0\t2\n17854992\t1.872\t0.081\t564\n17858824\t1.212\t0.0\t2\n17887503\t2.816\t0.232\t70\n17887504\t2.775\t-1.0\t1\n17887750\t2.038\t0.159\t42\n17887760\t2.72\t0.033\t2\n17891600\t2.75\t0.187\t12\n17891856\t2.984\t-1.0\t1\n18899462\t1.586\t0.08\t708\n18899472\t2.099\t0.117\t10\n18940432\t2.57\t0.156\t5\n33611790\t2.862\t0.219\t107\n33611809\t3.023\t-1.0\t1\n33611810\t1.697\t0.952\t3\n33611828\t3.382\t-1.0\t1\n33612038\t2.267\t0.06\t19\n33612039\t2.076\t0.084\t9\n33612040\t2.213\t0.116\t7\n33612047\t3.299\t0.356\t32\n33612048\t2.829\t-1.0\t1\n33612294\t2.498\t0.086\t4\n33624117\t2.68\t0.0\t2\n33624326\t2.051\t0.166\t7\n33624328\t1.644\t0.085\t2970\n33685536\t3.587\t0.192\t22\n33685537\t3.362\t0.618\t7\n33685539\t2.768\t-1.0\t1\n33685766\t2.418\t0.096\t23\n33685767\t2.3\t-1.0\t1\n33685768\t1.911\t0.307\t75\n33685775\t3.061\t0.334\t74\n33685776\t3.159\t0.258\t11\n33686022\t2.244\t-1.0\t1\n33689633\t2.268\t0.368\t3\n33689634\t3.2\t0.0\t2\n33689653\t3.142\t0.113\t4\n33689862\t1.874\t0.13\t10\n33689863\t1.999\t-1.0\t1\n33689864\t2.138\t0.163\t58\n33689871\t2.766\t0.099\t11\n33689872\t2.702\t0.904\t6\n33693731\t3.211\t0.049\t4\n33693748\t3.96\t0.381\t8\n33693749\t3.32\t0.198\t7\n33693958\t2.081\t0.047\t6\n33693959\t2.112\t0.21\t9\n33693960\t1.88\t0.205\t162\n33693967\t2.503\t0.176\t332\n33697844\t3.872\t0.0\t2\n33698055\t1.967\t-1.0\t1\n33698056\t1.612\t0.028\t8\n33767476\t2.657\t-1.0\t1\n33767477\t3.446\t-1.0\t1\n33767686\t2.131\t0.005\t3\n33767687\t2.1\t-1.0\t1\n33767688\t2.267\t0.518\t6\n33767695\t2.857\t0.194\t7\n33767696\t3.719\t0.957\t3\n33771573\t3.614\t0.457\t10\n33771783\t2.249\t0.088\t5\n33771784\t2.127\t0.16\t106\n33771791\t3.098\t-1.0\t1\n33771792\t3.166\t0.428\t3\n34623750\t1.78\t0.012\t7\n34627846\t1.55\t0.083\t65623\n34627847\t1.486\t0.077\t27424\n34627848\t1.404\t0.071\t156637\n34627855\t2.044\t0.135\t373\n34627856\t1.945\t0.103\t4751\n34628102\t1.526\t0.109\t716\n34628112\t1.965\t0.141\t8\n34631943\t1.436\t0.08\t1641\n34631944\t1.371\t0.063\t17326\n34631951\t1.879\t0.175\t1347\n34631952\t1.901\t0.158\t89\n34632198\t1.396\t0.123\t200\n34632199\t1.374\t0.136\t116\n34632207\t2.095\t0.0\t2\n34632208\t1.812\t0.114\t109\n34636040\t1.131\t0.253\t79\n34636047\t1.751\t0.123\t5003\n34636048\t1.76\t0.092\t2467\n34636294\t1.228\t0.157\t96\n34636295\t1.111\t0.035\t20\n34636304\t1.661\t0.085\t34493\n34664719\t2.605\t0.159\t86\n34664720\t2.299\t0.162\t912\n34664966\t1.951\t0.174\t35\n34664967\t1.804\t0.217\t28\n34664975\t2.749\t0.0\t2\n34664976\t2.399\t-1.0\t1\n34668816\t2.417\t0.111\t4\n34669062\t1.893\t0.17\t143\n34669071\t2.291\t0.138\t2\n35676678\t1.475\t0.093\t37\n52453894\t1.376\t0.081\t8518\n52453895\t1.293\t0.068\t14577\n52453896\t1.593\t0.165\t45\n52453903\t1.768\t0.204\t5\n52457991\t1.263\t0.085\t581\n52458000\t1.392\t0.156\t3\n83914759\t1.547\t0.085\t5\n83915013\t1.739\t0.204\t7\n83915014\t1.572\t0.079\t50584\n83915015\t1.539\t0.074\t8699\n83915023\t1.977\t0.137\t53\n83919110\t1.558\t0.068\t8984\n83919111\t1.575\t0.101\t961\n83919119\t2.014\t0.019\t9\n83951650\t2.389\t0.04\t4\n83951878\t1.973\t0.109\t22593\n83951879\t1.799\t0.11\t991\n83951887\t2.464\t-1.0\t1\n83951888\t2.672\t0.158\t11\n84025378\t2.575\t0.005\t2\n84025606\t2.151\t0.135\t549\n84025607\t2.077\t0.132\t184\n84959494\t1.626\t0.085\t32317\n84959495\t1.575\t0.081\t14689\n84959503\t2.111\t0.074\t20\n84959504\t2.015\t0.127\t36\n84963591\t1.557\t0.073\t2345\n84963599\t1.935\t0.256\t2\n84963600\t2.2\t0.296\t11\n100802822\t2.071\t0.051\t5\n100802823\t1.97\t0.021\t4\n101732615\t1.731\t0.197\t7\n101736710\t1.567\t0.082\t49304\n101736711\t1.502\t0.079\t23379\n101736719\t2.028\t0.119\t39\n101736720\t1.978\t0.107\t31\n101740807\t1.481\t0.072\t2974\n101740815\t1.989\t0.139\t38\n101740816\t1.737\t0.078\t11\n101773584\t2.915\t0.094\t4',_Yb),h);d=b[0];c=VXb.nGb(d,E_b,gZb);aYb.Bv=Sjb(UXb.llb,yZb,6,c,15,1);aYb.Cv=Sjb(UXb.klb,s_b,6,c,15,1);aYb.Dv=Sjb(UXb.klb,s_b,6,c,15,1);aYb.Av=Sjb(UXb.llb,yZb,6,c,15,1);for(e=0;e<c;e++){g=b[e+1];f=VXb.OHb(g,'\t');if(f.length==4){try{aYb.Bv[e]=VXb.nGb(f[0],E_b,gZb);aYb.Cv[e]=AGb(f[1]);aYb.Dv[e]=AGb(f[2]);aYb.Av[e]=VXb.nGb(f[3],E_b,gZb);}catch(a){a=Gwb(a);if(Zkb(a,52)){break;}else throw Hwb(a);}}}aYb.Fv=true;}};aYb.Pv=function Pv(a){var b,c,d,e;aYb.Fv||aYb.Ov();e=x$b;d=XZb;for(c=0;c<12;c++){b=e>=aYb.Bv.length||a<aYb.Bv[e]?-1:a==aYb.Bv[e]?0:1;if(b==0)return e;e=b<0?e-d:e+d;d=d/2|0;}return -1;};xxb(524,1,{},aYb.Iv);aYb.Fv=false;UXb.lmb=VFb(524);aYb.Qv=function Qv(a,b){a.q=aYb.Nw(new aYb.Qw(a.o,b),a);};aYb.Rv=function Rv(a,b){var c,d,e,f,g,h,i,j,k;c=aYb.Xv(a,b[0]);d=aYb.Xv(a,b[1]);e=aYb.Xv(a,b[2]);f=aYb.Xv(a,b[3]);i=new $Xb.Sh(d.a-c.a,d.b-c.b,d.c-c.c);j=new $Xb.Sh(e.a-d.a,e.b-d.b,e.c-d.c);k=new $Xb.Sh(f.a-e.a,f.b-e.b,f.c-e.c);g=new $Xb.Sh(i.b*j.c-i.c*j.b,-(i.a*j.c-i.c*j.a),i.a*j.b-i.b*j.a);h=new $Xb.Sh(j.b*k.c-j.c*k.b,-(j.a*k.c-j.c*k.a),j.a*k.b-j.b*k.a);return -$wnd.Math.atan2($wnd.Math.sqrt(j.a*j.a+j.b*j.b+j.c*j.c)*(i.a*h.a+i.b*h.b+i.c*h.c),g.a*h.a+g.b*h.b+g.c*h.c);};aYb.Sv=function Sv(a,b){aYb.Vv(a,b);return aYb.Bw(a.q,b.q);};aYb.Tv=function Tv(a,b){var c;for(c=0;c<b.q;c++)$Xb.Nh(a.k[c],b.J[c]);};aYb.Uv=function Uv(a,b){var c;for(c=0;c<b.k.length;c++)$Xb.Nh(a.k[c],b.k[c]);b.j==null?a.j=null:a.j=_Xb.yOb(b.j,b.j.length);};aYb.Vv=function Vv(a,b){var c;if(!a.q||!b.q){c=new aYb.Pw(a.o);!a.q&&(a.q=aYb.Nw(c,a));!b.q&&(b.q=aYb.Nw(c,b));}};aYb.Wv=function Wv(a,b){return a.j==null?-1:a.j[b];};aYb.Xv=function Xv(a,b){return a.k[b];};aYb.Yv=function Yv(a){return a.p==null?a.o.P:a.p;};aYb.Zv=function Zv(a,b){return a.k[b].a;};aYb.$v=function $v(a,b){return a.k[b].b;};aYb._v=function _v(a,b){return a.k[b].c;};aYb.aw=function aw(a,b,c){if(a.j==null){a.j=Sjb(UXb.Bwb,M$b,6,a.o.r,15,1);_Xb.DOb(a.j);}while(c<0)c=c+360<<16>>16;while(c>=360)c=c-360<<16>>16;a.j[b]=c;};aYb.bw=function bw(a,b,c){$Xb.Nh(a.k[b],c);};aYb.cw=function cw(a,b,c){a.k[b]=c;};aYb.dw=function dw(a,b){a.p=b;};aYb.ew=function ew(a,b,c){a.k[b].a=c;};aYb.fw=function fw(a,b,c){a.k[b].b=c;};aYb.gw=function gw(a,b,c){a.k[b].c=c;};aYb.hw=function hw(a,b){var c;!b&&(b=$Xb.ru(a.o));for(c=0;c<b.q;c++)$Xb.Nh(b.J[c],a.k[c]);a.p!=null&&$Xb.Nm(b,a.p);return b;};aYb.iw=function iw(a){var b;this.o=a;this.k=Sjb(UXb.Elb,j_b,32,a.q,0,1);for(b=0;b<a.q;b++)this.k[b]=new $Xb.Th(a.J[b]);this.n=NaN;};aYb.jw=function jw(a){aYb.kw.call(this,a,a.o);};aYb.kw=function kw(a,b){var c;this.o=b;this.k=Sjb(UXb.Elb,j_b,32,a.k.length,0,1);for(c=0;c<this.k.length;c++)this.k[c]=new $Xb.Th(a.k[c]);a.j!=null&&(this.j=_Xb.yOb(a.j,a.j.length));this.p=a.p==null||VXb.CHb(a.p)?a.p:VXb.AHb(a.p,mZb);this.n=NaN;};xxb(79,1,{79:1,18:1},aYb.jw);_.Eb=function lw(a){return aYb.Sv(this,a);};_.n=0;UXb.mmb=VFb(79);aYb.nw=function nw(a,b){var c,d,e,f,g;if(b==null)return null;g=_Xb.lNb(a.c,b);if(g)return g;d=YXb.LTb('<').length;if(VXb.DHb(YXb.LTb(b).substr(YXb.LTb(b).length-d,d),'<')||(e=YXb.LTb('-').length,VXb.DHb(YXb.LTb(b).substr(YXb.LTb(b).length-e,e),'-'))){g=_Xb.lNb(a.c,(f=YXb.LTb('<').length,VXb.DHb(YXb.LTb(b).substr(YXb.LTb(b).length-f,f),'<')?VXb.RHb(b,0,YXb.LTb(b).length-1)+'>':(c=YXb.LTb('-').length,VXb.DHb(YXb.LTb(b).substr(YXb.LTb(b).length-c,c),'-')?VXb.RHb(b,0,YXb.LTb(b).length-1)+'+':b)));if(g){g=new aYb.ix(g);_Xb.gRb(a.c,b,g);return g;}}return null;};aYb.ow=function ow(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C;a.b|=b;A=(m=VXb.OHb('daD@h@\\H\\D\\L\\B\\Djfdrjj`Cj`XZV^[lgl|WjBp^C~RQdp\ndaDD`HP@cIICISKUT@]LCbURss\\bCPVCp_rPmV@\ndaDH@@RfzaJjjbHGWPhxdtl|yXEGDfgf}HDoTE`|G|dC]`<\ndaDH@@RfzaJjjbHGWPhxdtl|yqGDf}HDoTE`|G|dC]`<\ndaDH@@RfzaJjjbHGWPhxdtl|yqGDf}HDoTE`|G|dC]`>\ndaT@`@\\DjfjZn[jjjkJcKhGP`phxdtl|wY@xD`uyo]{|lKUfp\ndax@@DiU[zh@zHfegfzLG``\ndax@@DiYn`@@wHmumm}l=\ndax@@DiYn`@@wHmumm}t=\ndax@@DiYn`@@wHmumn}t=\ndax@@DiYn`@@wHmuum}t\ndax@@DiYn`@@wHmuun}t=\ndax@@DiYn`@@wHnuun}t=\ndax@@DiYn`h@zsEgfyEnmlG``=\ndax@@DiYnf@@zaJyEnnmom`=\ndax@@DiYnf@@zaJyEvnmom`=\ndax@@DiYnf@@zqDffyEv`mom`=\ndax@@DiYnf@@zqDffyEv`mon`\ndax@@DiYnf@@zqDff~TEm}l=\ndax@@DiYnf@@zqDff~Uyn}t=\ndax@@DiYnf@@zqDfjyEv`mom`=\ndax@@DiYnf@@zqDfj~TEm}l=\ndax@@Djfjjh@zDFEGDfegf{HG@dF`lG``\ndax@@Djfjjh@zDFEGDfeggI@phdwY@xD`tE`|D\ndax@@Djfjjh@zDFEGDfeggM@phdtwY@xD`tE`|D\ndax@@Djfjjh@zDFEGDfeggN@pdwY@xD`tE`|D\ndax@@Djfjjh@zDFEGDfeggN@plwY@xD`tE`}x\ndax@@Djfjjh@zDFEGDjegj{HG@dF`lG``\ndax@@DjfjjjHP]BCBcbSRssd`XRV[l`\\BPZBp^|>\ndax@@DjfjjjHP]BCBcbSRsug@XR[l`\\BPZBp^B<\ndax@@DjfjjjHP]BCBcbSRsug@XR[l`\\BPZBp^B>\ndax@D@bH\\DbL\\B\\JbFbN\\Dfnjjh@zRGGNHxlwPo]x\ndax@H@\\H\\D\\J\\Djfjjh@zXFGDegf{I{@dFoLG``\ndax@H@\\H\\D\\J\\Djfjjh@zXFGDeggN@pdwYOXD`uy`|D\ndax@H@\\H\\D\\L\\Djfjjh@zXFDfegf{I{ODF`lG``\ndax@H@\\H\\J\\F\\Djfjjh@zXFEGDgj{HG@dFoM{``\ndax@H@\\J\\F\\N\\Djfjjh@zhFEGDf{HG@dFoM{o@\ndax@H@\\J\\F\\N\\Djfjjh@zhFEGDf}HG@dFoMx\ndax@H@dDdJdFdDfnjjh@zJGDgfzDGo@\ndax@H@dDdJdFdDfnjjh@zJGDgfzE{o@\ndax@H@dDdJdFdDfnjjh@zJGDggNHxlwP`|D\ndax@H@dDdJdFdDfnjjh@zJGDggNHxlwPo]x\ndax@H@dDdJdFdDfnjjh@zJGDkfzDGo@\ndax@H@dDdJdFdDfnjjh@zJGDkgNHxlwP`}x\ndax@H@dDdJdFdDfnjjh@zJGDkjzDG``\ndax@H@dDdLdJdLbdLeUT@]EBRss]F}w`\ndax@H@dDdLdJdLbdLeUUAPNbaIZyncA{p<\ndax@H@dDdLdJdLbdLeUUAPNbaIZyncA{p>\ndax@P@BFBDiuZ{h@zHEEgfzHG``\ndax@P@QFQDiuZ{h@zHEEgfzHG``\ndax@P@\\H\\Djfjjh@zDFEGDfegf{HG@dF`lG``\ndax@P@\\H\\Djfjjh@zDFEGDjegj{HG@dF`lG``\ndax@P@\\H\\Djnjjh@zxEGDfegf{Q{@dF`lG``\ndax@P@\\H\\Djnjjh@zxEGDfegf{Q{OEz`lG``\ndax@P@\\H\\Djnjjh@zxEGDfegf}YxoTE`|D\ndax@P@\\H\\Djnjjj@P]\\BcbSRss]h}`R}PVCpP<\ndax@P@\\H\\Djnjjj@P]\\BcbSRss]h}`R}PVCpP>\ndax@P@\\H\\Djnjjj@P]\\BcbSRss^lBWjBp^B<\ndax@P@\\H\\Djnjjj@P]\\BcbSRss^lBWjBp^B>\ndax@Q@|Bh@dnRjZjj`Ck`XT\\ZV^[t`\\CPVCpP\ndax@R@BH|HeIijjj@NnaQqIiYyoV^KuAXOA@\ndax@R@QH|HeIijjj@NnaQqIiYyoV^KuAXOA@\ndax@R@\\H\\HyJkjjj@NnAQqIiYyoV^KuAXOA@\ndax@X@\\H\\D\\L\\B\\J\\Djfjjh@zHFEgf{I{OEzoLG``\ndax@X@\\H\\D\\L\\B\\J\\Djfjjh@zHFEggI@phdwYOYxoUy`|D\ndax@X@\\H\\D\\L\\B\\J\\Djfjjh@zHFEggN@pdwYOYxoUy`|D\ndax@X@kDdLdJkFdNdLbdLeUT@]IBR\ndax@`@BDf]j^@@zbJyAoMmom`=\ndax@`@BDf]j^@@zbJyAoNmom`=\ndax@`@BDf]j^@@zbJyAoNmwn`=\ndax@`@\\Df]j^@@zRGFyA{Nmom`=\ndax@`@\\Djfjjh@zDFEGDfegf{HG@dF`lG``\ndax@`@\\Djfjjh@zDFEGDfegf{HG@ez`lG``\ndax@`@\\Djfjjh@zDFEGDjegf{HG@dF`lG``\ndax@`@\\Djfjjh@zDFEGHjegf{HG@dF`lG``\ndax@`@\\Djfjjh@zDFEKHjegf{HG@dF`lG``\ndax@`@\\LddUUUr@]LBcbRss\\dC`RCwP\ndax@`@dDffjjjHP]]BcbSRssgHTR[u`RCPVCpP<\ndax@b@|@eJijjj@NaAaQqIiYynrApI^hKAxH\ndax@b@|@eJijjj@NaAaQqIiYynrAsq^hKAxH\ndax@b@|@eJijjj`DGP`phyDtl|wY@xDoTE`|D<\ndax@b@|@eJijjj`DGP`phyDtl|wY@xDoTE`|D>\ndax@h@BDdLdJdFdLbdLeUT@]YBSs]@}w`\ndax@h@\\H\\D\\L\\B\\Djfjjh@zhFFegf{I{OEz`lG``\ndax@h@\\H\\D\\L\\B\\Djfjjh@zhFFegf{I{OEz`lG`\x7FddEB\ndax@h@\\H\\D\\L\\B\\Djfjjh@zhFFegf}I{OTE`|D\ndax@h@\\H\\D\\L\\J\\Djfjjh@zhFDegf{I{ODFoLG``\ndax@h@\\H\\D\\L\\J\\Djfjjh@zhFDeggI@phdwYOYx`uy`|D\ndax@h@\\H\\D\\L\\J\\Djfjjj@P]TCBRssg@XR[lgl|PZ|p^B<\ndax@h@\\H\\D\\L\\J\\Djfjjj@P]TCBRssg@XR[lgl|PZ|p^B>\ndax@h@dDdLdJdFdLbdLeUT@]YBSs^NB\ndax@h@dDdLdJdFdLbdLeUT@]YBSs^N|\ndax@h@dDdLdJdFdLbdLeUT@]YBSu^NB\ndax@h@kDdLdJdFdLbdLeUT@]YBSs^N|\ndax@p@\\H\\D\\Djfjjh@zxFGDfegf{I{@dF`lG``\ndax@p@\\H\\D\\Djfjjh@zxFGDfegj{I{@dF`lG``\ndax@p@\\J\\F\\Djfjjh@zXFEGDgf{HG@dFoM{``\ndax@p@\\J\\F\\Djfjjh@zXFEGDgj{HG@dFoM{``\ndax@p@\\J\\F\\DjfjjjHP]LCBcbSs^dC`RCWnB<\ndax@p@\\J\\F\\DjfjjjHP]LCBcbSs^dC`RCWnB>\ndax@p@dDdLdLbdLeUT@]UBSRss_JBp^B\ndax@p@dDdLdLbdLeUT@]UBSRss_JBp^|\ndax@p@dDdLdLbdLeUT@]UBSRsu_JBp^B\ndax@p@dDdLdLbdLeUT@]UBSRuu_JBp^B\ndax@p@dDdLdLbdLeUT@]UBSTus_JBp^|\ndax@p@|D\\L\\DffjjjHP]MBbSRss^l|PZBp^B<\ndax@p@|D\\L\\DffjjjHP]MBbSRss^l|PZBp^B>\ndaxB@@RfRZzjjdaX`zJGDggN@hdwP`|D<\ndaxB@@RfRZzjjdaX`zJGDggN@hdwP`|D>\ndaxBRHSFCpkpslddlcUT`HdGV@d|wRo\\D>\ndaxB`HSJCprRRrMUPAtPIKOMtXOA@\ndaxD@@QIkjjj@NfaqIiYysbNIMrHMAXOA@\ndaxD@@QIkjjjbDGSPxdtl|yHEGDfyDF`lG``<\ndaxD@@QImYk`@Nhanc[{X=\ndaxD@@iIijjj@NfaQqIYynVAHKAxH\ndaxD@@iIijjj@NfaQqIYysTJNMKMrpIAXOA@\ndaxD@@iIijjjRDbCihT\\RV^\\yBcS\\lBPVCpP\ndaxD@@iIijjjRDdCihT\\RV^\\yBbs\\lBPVCw`>\ndaxD@@iIijjjRDdCihT\\RV^\\yBcS\\lBPVCpP<\ndaxD@@yIUVnz@NdaY@\ndaxDHHP@biAiCiCIICHmU@GV@xdw```\ndaxDPHP@b`cIICHmU@GU@xeL|wH`uy`|D\ndaxD`HP@cIICHmU@GS@xdtl|wH`tE`|D\ndaxD`HP@cIICHmU@GS@xeTl|wH`tE`|D\ndaxD`HPGCIICIUU@GS@xdtl|wHoTE`|D\ndaxDpJXIAICICHiCIUU@GVPd|wc``\ndaxDpJXIAICICHiCIUU@GVPd|wco@\ndaxH@@RYvjxHaAtdNM|pK[{X+\ndaxH@@RZZjj`CkhT\\RZV^[u`RCPVCpP\ndaxH@@RZZjj`CkhT\\RZV^\\lCBcbSS^lBPZBp^B\ndaxH@@RZZjj`CkhT\\RZV^\\uBcbSS^lBPZBp^B\ndaxH@@RZZjj`CkhT\\RZV^lmBcbSRs^lBPZBp^B\ndaxH@@RZZjjhQAutJNIMKONZaQqIYoVAHMAXO^@<\ndaxH@@RZZjjhaAutJNIMKONVAaQqIioVAKuAXOA@<\ndaxH@@RZZjjhaAutJNIMKONZAaQIioVAHMAXOA@<\ndaxH@@RZZjjhaAutJNIMKONZaQqIioVAKuAXOA@>\ndaxH@@RZZjjhaAutJNIMKON\\aQIoVAHMAXOA@<\ndaxH@@RZZjjhaAutJNIMKON\\aQIoVAHMAXOA@>\ndaxH@@RZZjjhaAutJNIMKON\\aQYoVAHMAXO^@>\ndaxH@@RZZjjhaAutJNIMKON\\aqIoVAKuAXOA@<\ndaxH@@RZZjjhaAutJNIMKON\\aqIoVAKuAXOA@>\ndaxH@@RZZjjhaAutJNIMKON\\aqYoVAKuAXO^@<\ndaxHHBApapQpqpRjZjj`Cj`XZV^[tgl}PVCpP\ndaxHPJBPRPRZzjjhrAuTNIKWM|KsA{p<\ndaxHPJBPRPRZzjjhrAuTNIKWM|KsA{p>\ndaxH`HApRjzjj`Ck`T\\RZV^[u`RCPVCpP\ndaxH`HApRjzjj`Ck`T\\RZV^[ugb}PVCpP\ndaxH`HApRjzjj`Ck`T\\bjV^[u`RCPVCpP\ndaxH`HApRjzjjhAAupJNIMKOMzpI^hKAxH<\ndaxH`HApRjzjjhAAupJNIMKOMzpI^hKAxH>\ndaxH`JBHRZZjjhaAttJNIKONRaQiYnVAHKAxH>\ndaxHpJBHRHrHrJPrUUPAtTIKOMtXOA@\ndaxHpJBPRPrPrJPrUUPAtTIKOMtXOA@\ndaxHpJBPRPrPrJPrUUPAtTIKOMt[w^@\ndaxHpJBPRPrPrJPrUUTE@zJDegfzLGo@<\ndaxHpJBPRPrPrJPrUUTE@zJDegfzLGo@>\ndaxHpJBPRPrPrJPrUUTE@zJDegjzLG``<\ndaxHpJBPRPrPrJPrUUTE@zJDegjzLG``>\ndaxHpJBPRPrPrJPrUUTE@zJDekfzLGo@<\ndaxHpJBPRPrPrJPrUUTE@zJDekfzLGo@>\ndaxL@@RdfnjjjHP]UCbRsse`T\\RZV[xPVCpP<\ndaxLHHS@BJdFdNdLddlbuT@]HBR\ndaxLJHS@BJdFdNdL{IIKHmU@GR@d`\ndaxL`HS@\\LddleUT@]TBSRss_JBp^B\ndaxLhJ[`\\H\\D\\L\\B\\Djfjjh@zPFF~I{OEx\nday@@@QIkjjj@NfaqIiYysPLJIMMrHMAXOA@\ndayDaLJD@HrR{IICHmU@GU@xtl|wr`lG``\ndaz@@@RYvHx@C\\`wfvwvp=\ndaz@@@RYvHx@C\\`wfvwwP\ndaz@@@RYvHx@C\\`wgVwvp=\ndaz@@@RYvix@CjHkdF|zv~v=\ndaz@@@RYvix@CjHkdG\\zv~v=\ndaz@B@BTf]bN@@wHMymm}t\ndaz@HBApapQpqpRjZjj`Cj`XZV^[tgl}PVCpP\ndaz@bHCpBTjnjjh@zxEGDfegf}YxoTE`|D\ndaz@pJBPRPrPrJPrUUPAtTIKOMtXOA@\ndaz@pJBPRPrPrJPrUUTE@zJDegjzLG``>\ndazDHLa@BJdFdNdLddlbuT@]HBR\ndazDJLa@BJdFdNdL{IIKHmU@GR@d`\ndazD`La@BLddlbuT@]TBSRss_JBp^B\ndazH`D`OCIICHuUPBCi`\\RZV^[dWjBp^B<\ndazH`D`OCIICHuUPBCi`\\RZV^[dWjBp^B>\ndazHpFhIAICICHiCIUUPRCkHR^[qpP<\ndazHpFhIAICICHiCIUUPRCkHR^[qpP>\ndazLQFaLCpkpsfgIIKHuUHBIAu`IOMtkwA@<\ndazLQFaLCpkpsfgIIKHuUHBIAu`IOMtkwA@>\ndctD@@gHiDTeIU]uPAttNIHjnmrpIATNa@\ndctD@@gHiDTeIU]uPAttNQPjvurpIATNa@\nded@@DiUfoh@@Mr[_[G\\{@=\nded@@DiUfoh@@Mr[_]G\\}@\nded@P@\\F\\LddUTeUuPAtHJNIKOHlmvPNAHOADLa@\ndedD@@{HiDUIU]T@]MCdTrMM\\lBPQCHP\ndiD@@DiYkhJ`ChlV^Q[tVzvp^BHP=\ndiD@@DiYkhJ`ChlV^Q[tVzzp^BHP\ndiD@@DiYkhJ`ChlV^aktVzvp^BHP=\ndiD@@DiYkhJ`ChlVnaktVzvp^BHP=\ndiD@@DiYkhJ`ChlVnaktVzzp^BHP\ndiD@H@\\H\\D\\L\\LddjTjn@@z`F}QyOY{nct=\ndiD@`@\\LddUTjn@@zHEGDf}HG@dGmcl=\ndiD@`@\\LddUTjn@@zHEGDf}HG@dGmct\ndiD@`@\\LddUTjn@@zHEGDf}HG@dGnct=\ndiD@`@\\LddUTjnX@zhEGDej}HG@dGnct\ndiD@`@\\LddUTjnX@zxEGDegdV}HG@dGnbD\ndiD@`@\\LddUTjnX@zxEGDegdZ}HG@dGnbD\ndiDH@@rJQERjx@CkH\\R[e`RCvqv=\ndiDH@@rJQERjx@CkH\\R[e`RCvqz\ndiDH@@rJQERjx@CkH\\bke`RCvqv=\ndiDH@@rJQERjx@CkH\\bke`RCvqz\ndiDH@@rJQERjxHaAudNIMrpI^{X{@+\ndiDH@@rJQERjxHaAudNIMrpI^{X{@-\ndiDH@@rJQERjxHaAudNIMrpI^{X}@<\ndiDH@@rJQERjy`Cih\\RV^Q[y`RBO`\ndiDH@@rJQERjy`Cih\\bf^Q[e`RCwQB\ndiF@@@rJQERjx@CkH\\R[e`RCvqv=\ndiF@`NAprRQURjx@Ch`T\\R[t`\\BP^vNp\ndiF@a@b`BX{HiDUJk`@NlarJnVAHO[Gh\ndiFH@NCHiDUJk`@NlaqInVAHO[GX\ngC`@Die@zHXir\ngC`@Die@zHXis]Knz\ngC`@Die@zHXis^Kh\ngC`@Die@zHXisgAbd\ngC`@Die@zHXisgAbfzW]t\ngC`@Die@zHXisgAbf|WP\ngC`@Dij@zHXis]HNB\ngC`@Dij@zHXis]HN|\ngC`@Dij@zHXis]Kv|\ngC`@Dij@zHXisgAbfzP\\D\ngC`@Dij@zHXisgAbfzP]x\ngC`@Dij@zHXisgAbfzWmx\ngC`@Dij@zHXiu]HNB\ngC`@Dij@zHXiugAbfzP\\D\ngC`@Dij@zHXjs]HN|\ngC`@Dij@zHXjsgAbfzP]x\ngC`@Dij@zHXju]HNB\ngC`@Dij@zHXjugAbfzP\\D\ngC`@DkZ@zHXis]SnB\ngC`@DkZ@zHXis]Sn|\ngC`@DkZ@zHXis^XH\ngC`@DkZ@zHXis^[p\ngC`@DkZ@zHXisgAbfzg\\D\ngC`@DkZ@zHXisgAbfzg]x\ngC`@DkZ@zHXisgAbf|pP\ngC`@DkZ@zHXisgAbf|w`\ngC`@DkZ@zHXiu]SnB\ngC`@DkZ@zHXiu^XH\ngC`@DkZ@zHXiugAbfzg\\D\ngC`@DkZ@zHXiugAbf|pP\ngC`B@DPHPQ`aJZ`NdFH\ngC`B@DPHPQ`aJZ`NdFN\\FJP\ngC`B@DPHWaoAJZ`NdFMto[p\ngC`D@DPHRfhChabgMt`xH\ngC`D@DPHRfhChabgN\\FJ[iApP\ngC`D@DPHRfhChabgN\\FJ[i^w`\ngC`D@DPHRfhChabkUt`xH\ngC`D@DPHRnhCkASf|pP\ngC`D@DPHRnhCkASj|pP\ngC`D@DXHRVhCiQR\ngC`D@DXHRVhCiQSgAbd\ngC`D@DXHRfhCkAbf|PP\ngC`D@DXHRfhCkAbgNCEMx``\ngC`D@DXHRfhCkAbj|PP\ngC`D@DYpRVhCiQS]Cv|\ngC`D@VPlRfhChabkUt`xH\ngC`D@VYpRfhCkAbfzP]x\ngC`D@bQDRfhChabgMt`xH\ngC`D@bQDRfhChabkUt`xH\ngC`D@bSpRnhCkASfzglD\ngC`D@xYpRVhCiQS]Cv|\ngC`D@xYpRVhCiQSgAbfzGmx\ngC`DABPHRVhCkQSj|pP\ngC`DADZHRVhCiQR\ngC`DAb[DRVhCiQR\ngC`DAx[pRVhCiQR\ngC`DAx[pRVhCiQS]Cv|\ngC`Dax[pDzTej@zTTwP}o@\ngC`H@DIKRAuhir\ngC`H@DIKTAuhis]CvB\ngC`H@DIKTAuhis^XH\ngC`H@DIKTAuhis^[p\ngC`H@DIKTAuhisgAbfzGlD\ngC`H@DIKTAuhisgAbf|pP\ngC`H@DIKTAuhisgAbf|w`\ngC`H@DIKTAuhiu]CvB\ngC`H@DIKTAuhiu^XH\ngC`H@DISRAtPqSfzP]t\ngC`H@DISRAtPqSf|PP\ngC`H@DISRAtPqSgNCEMt`{h\ngC`H@DISRAtPqSgNCEMx``\ngC`H@DISRAtPqUfzP]t\ngC`H@DISRAtPqUgNCEMt`{h\ngC`H@DISTAtPqSfzP\\D\ngC`H@DISTAtPqSfzP]x\ngC`H@DISTAtPqSfzWlD\ngC`H@DISTAtPqSgNCEMt`xH\ngC`H@DISTAtPqSgNCEMt`{p\ngC`H@DISTAtPqSgNCEMtoXH\ngC`H@DISTAtPqSjzP\\D\ngC`H@DISTAtPqSjzWlD\ngC`H@DISTAtPqSkNCEMt`xH\ngC`H@DISTAtPqUfzP\\D\ngC`H@DISTAtPqUfzP]x\ngC`H@DISTAtPqUgNCEMt`xH\ngC`H@DISTAtPqUjzP\\D\ngC`H@VIKTAuhis]CvB\ngC`H@bIKTAuhis^XH\ngC`H@bISRAtPqSf|PP\ngC`H@bISTAtPqSfzP\\D\ngC`H@bISTAtPqSgNCEMt`xH\ngC`H@bISTAtPqSjzP\\D\ngC`H@bISTAtPqUfzP\\D\ngC`H@bISTAtPqUjzP\\D\ngC`H@xIKRAuhis^Cp\ngC`H@xIKTAuhis]CvB\ngC`H@xIKTAuhis]Cv|\ngC`H@xIKTAuhis^XH\ngC`H@xIKTAuhisgAbfzGlD\ngC`H@xIKTAuhiu]CvB\ngC`HADIKTAuhis^XH\ngC`HAVIKTAuhis^XH\ngC`HAbIKTAuhis^XH\ngC`HAxIKTAuhis]CvB\ngC`HAxIKTAuhis^XH\ngC`HAxIKTAuhisgAbfzGlD\ngC`HAxIKTAuhiu]CvB\ngC`HMPISTAu`qS]HN|\ngC`HMPISTAu`qS^HH\ngC`IAVBTii@zHXjs]HNz\ngC`IAxBTej@ztTyna{A@\ngC`IAxBTej@ztTys`qS]CvB\ngC`IMP[dij@zpXindG^@\ngC`L@DPHPPeMPGVCGMy``\ngC`L@DPHPPeMPGVCGMyo@\ngC`L@DPHPPeMPGVCGUy``\ngC`L@DPHPPeMPGVCGV\\FJ[sA@\ngC`L@VPHPPeMPGVCGMy``\ngC`L@bPHPPeMPGVCGMy``\ngC`PAEdij@zPXypXi@\ngC``@deZ@ztTyoLD\ngC``ADij@zHXis]HN|\ngC``ADij@zHXis]Kv|\ngC``ADij@zHXisgAbfzP\\D\ngC``ADij@zHXisgAbfzP]x\ngC``ADij@zHXisgAbfzWmx\ngC``Adej@zTT`\ngC``Adej@zTTypXi@\ngC``Adij@zpXioDD\ngC``Adij@zpXioEx\ngC``Adij@zpXis`qS^HH\ngC``Adij@zpXjoDD\ngC``Adij@zpXjs`qS^HH\ngC`hH`xIKTAuhis]Cv|\ngCa@@dkHGVbgH\ngCa@@dkHGVbgMyn`\ngCa@@dkPGVbgMy``\ngCa@@dmHGVbgH\ngCa@@dmHGVbgMyn`\ngCa@@dmHGVbgN\\FJP\ngCa@@dmHGVbgN\\FJ[s]@\ngCa@@dmPGVbgMy``\ngCa@@dmPGVbgMyo@\ngCa@@dmPGVbgN\\FJ[sA@\ngCa@@dmPGVbgN\\FJ[s^@\ngCa@@dmPGVbgUy``\ngCa@@dmPGVbgV\\FJ[sA@\ngCa@@eMHGQCEN[iAwP\ngCa@@eMHGQCEN[qA@\ngCa@@eMHGQCEN[q^@\ngCa@@eMHGQCEN\\xLTwRCn`\ngCa@@eMHGQCEN\\xLTwbB\ngCa@@eMHGQCEV[iAwP\ngCa@@eMHGQCEV\\xLTwRCn`\ngCa@@eMHGQCEV\\xLTwbB\ngCa@@eMPGQCEN[iApP\ngCa@@eMPGQCEN[iAw`\ngCa@@eMPGQCEN[i^pP\ngCa@@eMPGQCEN[i^w`\ngCa@@eMPGQCEN\\xLTwRC``\ngCa@@eMPGQCEN\\xLTwRCo@\ngCa@@eMPGQCEN\\xLTwR}``\ngCa@@eMPGQCEN\\xLTwR}o@\ngCa@@eMPGQCENkiApP\ngCa@@eMPGQCENki^pP\ngCa@@eMPGQCENlxLTwRC``\ngCa@@eMPGQCENlxLTwR}``\ngCa@@eMPGQCEV[iApP\ngCa@@eMPGQCEV[iAw`\ngCa@@eMPGQCEV\\xLTwRC``\ngCa@@eMPGQCEV\\xLTwRCo@\ngCa@@eMPGQCEVkiApP\ngCa@@eMPGQCEVlxLTwRC``\ngCaH@jAJZ`NlFN[i^pP\ngCaH@jAJZ`NlFN\\xLTwR}``\ngCaH@jAJZ`NlFN\\xLTwfB\ngCaH@jAJZ`NlFN\\xLTwf|\ngCaHDGAIZ`NmEN[h^pP\ngCaHH@aIZ`NmEN[h^pP\ngCaHH@aIZ`NmEN[h^w`\ngCaHH@aIZ`NmEN\\xLTwP}``\ngCaHHGAIZ`NmEN[h^pP\ngCaHHGAIZ`NmEN[h^w`\ngCaHHGAIZ`NmEN\\xLTwP}``\ngCaHHGAIZ`NmENkh^pP\ngCaHHOAIZ`NmEN[h^pP\ngCaHHOAIZ`NmEN[h^w`\ngCaHHOAIZ`NmEN[sA@\ngCaHHOAIZ`NmEN\\xLTwP}``\ngCaHHOAIZ`NmEN\\xLTwP}o@\ngCaHHOAIZ`NmEN\\xLTwf|\ngCaHHOAIZ`NmENkh^pP\ngCaHHOAIZ`NmENlxLTwP}``\ngCaHL@aIZ`NeEH\ngCaHL@aIZ`NeEN\\FJP\ngCaHLDQIZ`NeEH\ngCaHLGAIZ`NeEMxO@\ngCaHLHaIZ`NeEH\ngCaHLLQIZ`NeEH\ngCaHLOAIZ`NeEMxO@\ngCaI@jA\\eMPGVCGMtoXH\ngCaIHO@RdmPGVbgMtOXH\ngCaIHO@RdmPGVbgN\\FJ[h^pP\ngCaIL@`RdmPGRbd\ngCd@@deZ@ztTyoLG}h`\ngCd@@deZ@ztTys`qS^XO{Q@\ngCd@@deZ@ztTzoLG}h`\ngCd@@deZ@ztTzs`qS^XO{Q@\ngCd@ADie@zHXis]Kn{~rD@\ngCd@ADie@zHXis^Ko{HP\ngCd@ADie@zHXisgAbfzW]w}dH\ngCd@ADie@zHXis~rD@\ngCd@ADif@zHXis]KnC~rD@\ngCd@ADif@zHXis^XO{HP\ngCd@ADif@zHXisgAbfzW\\G}dH\ngCd@ADif@zHXisgAbf|p_vP`\ngCd@ADif@zHXiu]KnC~rD@\ngCd@ADif@zHXiu^XO{HP\ngCd@ADij@zHXis]HNC~rD@\ngCd@ADij@zHXis]HNC~t@\ngCd@ADij@zHXiu]HNC~rD@\ngCd@ADij@zHXju]HNC~rD@\ngCd@ADkj@zpTzoLD\ngCd@AdeY@zTT`\ngCd@Adej@zTT`\ngCd@Adej@zTTypXi@\ngCd@Adij@zpXioDG}h@\ngCd@Adij@zpXis`qS^HO{P@\ngCd@Adij@zpXjoDG}h@\ngCd@Adij@zpXjs`qS^HO{P@\ngCd@aAteJz`NlEN[sA\x7FZ@\ngCd@aAteJz`NlEN[s^\x7FZ@\ngCd@aaNeIZ`NeEH\ngCd@aaNeIZ`NeEN\\FJP\ngCd@aaNeIZ`NeEN\\FJ[h^w`\ngCd@aaNeIZ`NeEN\\FJ[p^@\ngCdAAIrTs@]DLTznewA\x7FYB@\ngCdAAaJRu@]JJP\ngCdAAaJRu@]JJ[p^@\ngCdAAaJRu@]JJ\\xLT`\ngCdAAaJRu@]JJ\\xLTw`|\ngCdDE`DPHRfhCiAb\ngCdHH`DIKRAuhis]Cv{~rb@\ngCdHH`DIKRAuhis^Cw{JH\ngCdHI`DIKTAthis`qS^Cw{R@\ngCe@E`dkPGRbg}h`\ngCh@@dkHGVbgH\ngCh@@dkPGVbgMy``\ngCh@@dmHGVbgH\ngCh@@dmHGVbgMyn`\ngCh@@dmHGVbgN\\FJP\ngCh@@dmHGVbgN\\FJ[s]@\ngCh@@dmPGVbgMtOXH\ngCh@@dmPGVbgMy``\ngCh@@dmPGVbgMyo@\ngCh@@dmPGVbgN\\FJ[h^pP\ngCh@@dmPGVbgN\\FJ[sA@\ngCh@@dmPGVbgN\\FJ[s^@\ngCh@@dmPGVbgUy``\ngCh@@dmPGVbgV\\FJ[sA@\ngCh@@eLhGQCEN\\xLTwR{n\x7Fm@\ngCh@@eLhGQCEN\\xLTwb{~t@\ngCh@@eMHGQCEN[iAw_v`@\ngCh@@eMHGQCEN[i^w_v`@\ngCh@@eMHGQCEN[qA\x7FZ@\ngCh@@eMHGQCEN\\xLTwRCn\x7Fm@\ngCh@@eMHGQCEN\\xLTwbC~t@\ngCh@@eMHGQCEV[iAw_v`@\ngCh@@eMHGQCEV[qA\x7FZ@\ngCh@@eMPGQCEN[iApP\ngCh@@eMPGQCEN[iAp_v`@\ngCh@@eMPGQCEN[iAw`\ngCh@@eMPGQCEN[iAwov`@\ngCh@@eMPGQCEN[i^pP\ngCh@@eMPGQCEN\\xLTwRC``\ngCh@@eMPGQCEN\\xLTwRC`\x7Fm@\ngCh@@eMPGQCEN\\xLTwRCo@\ngCh@@eMPGQCEN\\xLTwRCo_m@\ngCh@@eMPGQCEN\\xLTwR}``\ngCh@@eMPGQCENkiApP\ngCh@@eMPGQCENkiAp_v`@\ngCh@@eMPGQCENki^pP\ngCh@@eMPGQCENlxLTwRC``\ngCh@@eMPGQCEV[iApP\ngCh@@eMPGQCEV[iAp_v`@\ngCh@@eMPGQCEV[iAwov`@\ngCh@@eMPGQCEV\\xLTwRC``\ngCh@@eMPGQCEV\\xLTwRC`\x7Fm@\ngCh@@eMPGQCEVkiApP\ngCh@@eMPGQCEVkiAp_v`@\ngCh@@e[PGQCEN[j]p_v`@\ngCh@@e[PGQCEN[sA\x7FZ@\ngCh@@e[PGQCEN[s^\x7FZ@\ngCh@@e[PGQCEN\\xLTwT{`\x7Fm@\ngCh@@e[PGQCENkj]p_v`@\ngCh@@e[PGQCENksA\x7FZ@\ngCh@@e[PGQCENlxLTwT{`\x7Fm@\ngChA@IRUdCkQSf|GP\ngChA@IRVdCkQSd\ngChA@IRVhCkQSfzGlD\ngChA@IRVhCkQSf|pP\ngChA@IRVhCkQSf|w`\ngChA@IRVhCkQSgNCEMtOXH\ngChA@IRVhCkQSgNCEMy``\ngChA@IRVhCkQSgNCEMyo@\ngChA@IRVhCkQSj|pP\ngChA@IRVhCkQSkNCEMy``\ngChA@IRfhChabgMt`xH\ngChA@IRfhChabgMt`{p\ngChA@IRfhChabgMtoXH\ngChA@IRfhChabgN\\FJ[iApP\ngChA@IRfhChabgUt`xH\ngChA@IRfhChabgUtoXH\ngChA@IRfhChabgV\\FJ[iApP\ngChA@IRfhChabkUt`xH\ngChA@IRmhChabgMuNxO{P@\ngChA@IRmhChabgMy`\x7Fm@\ngChA@IRmhChabgN\\FJ[j]p_v`@\ngChA@IRmhChabgUuNxO{P@\ngChDD@bABUt`]XJ\\wf{~tP\ngChDDDRHbUt`]XJ\\wf{~tP\ngChHD@aIZ`NmEN[h^p_vb@\ngChHDOAIZ`NmENkh^p_vb@\ngChHH@aIZPNmEN[h^w_vd@\ngChHH@aIZ`NmEN[h^p_vd@\ngChHH@aIZ`NmEN[h^wovd@\ngChHH@aIZ`NmEN\\xLTwP}`\x7FmH\ngChHH@aIZ`NmENkh^p_vd@\ngChHH@aJZPNbFJlypXindG]\x7FZP\ngChHHOAIZ`NmEN[h^p_vd@\ngChHHOAIZ`NmEN\\xLTwP}`\x7FmH\ngChHHOAIZ`NmENkh^p_vd@\ngChHL@aIZ`NeEH\ngChHL@aIZ`NeEMxO@\ngChHL@aIZ`NeEN\\FJP\ngChHL@aJZ`NlFJ[qA@\ngChHL@aJZ`NlFJ\\xLTwbB\ngChHLHaIZ`NeEH\ngChHLLQIZ`NeEH\ngChHLOAIZ`NeEH\ngChIDOARdmPGVbgMtOXH\ngChIHOBRdkPGVbgMy`\x7FmH\ngChIL@cRdmPGRbd\ngChIL@cRdmPGRbf|G`\ngChILLSRdmPGRbd\ngCh`LHe]PGRBd\ngCi@DDeZ@ztTyoLG}h`\ngCi@DDeZ@ztTyoM{}h`\ngCi@DDeZ@ztTzoLG}h`\ngCi@HDii@zHXis]HN{~t`\ngCi@HDii@zHXis^HO{R@\ngCi@HDii@zHXisgAbfzP]w}i@\ngCi@HDii@zHXjs]HN{~t`\ngCi@HDij@zHXis]HNB\ngCi@HDij@zHXis]HNC~t`\ngCi@HDkj@zpTyoLD\ngCi@HDkj@zpTyoMx\ngCi@HDkj@zpTys`qS^XH\ngCi@HDkj@zpTzoLD\ngCi@LDej@zTT`\ngCi@LDej@zTTypXi@\ngCi@LDej@zTTypXioMx\ngCi@LDij@zpXioDD\ngCi@LDij@zpXis`qS^HH\ngCi@LDij@zpXjs`qS^HH\ngCiALMJRu@]JJP\ngCiALMJRu@]JJ[s^@\ngCiALMJRu@]JJ\\xLT`\ngCiALMJRu@]JJ\\xLTwf|\ngCl@ADe[PGVBgUy`\x7Fl``\ngClAADnRmhCkASj|p_vPP\ngFp@DjYZXHCkASfyW]x{n\x7FrTrp=\ngFp@DjYZjjQCiabgIZyHXis\\kv|_WwyJYX<\ngFp@DjxujhCiabgIZwL{`dMC~RvN@\ngFp@LdaahUPGVrVmsMkYCP\x7Fdmc`=\ngFp@LdaahUPGVrVmsMkY}__dmc`=\ngFp@LdaahUPGVrVmsMkiCP\x7Fdmc`\ngFp@LdaahUTrGVrVmsMkYC__dmc`+\ngFp@LdaahUTrGVrVmsMkYC__dmc`-\ngFp@LdaahUTrGVrVmsMkiC__dmc`<\ngFp@LdaahUTrGVrVmsMkiC__dmc`>\ngFp@LddLUUPGSCENRusdyK\\pJBPtOyHZX\ngFp@LddLUUPGSCENRusdyK\\sr|PtOyHZX\ngFp@LddLUUTBGSCENRurPqRVy`Uxah_rPtp>\ngFp@LddLU