/**
 * zenodo - Node.js library to access the Zenodo API
 * @version v3.0.0
 * @link https://github.com/cheminfo/zenodo#readme
 * @license MIT
 */
(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
    typeof define === 'function' && define.amd ? define(['exports'], factory) :
    (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.Zenodo = {}));
})(this, (function (exports) { 'use strict';

    var _documentCurrentScript = typeof document !== 'undefined' ? document.currentScript : null;
    /**
     * Represents the different states of Zenodo authentication for retry logic.
     *
     * States:
     * - NOT_TRIED: Authentication verification has not been attempted yet
     * - FAILED: Authentication verification has failed
     * - SUCCEEDED: Authentication verification has succeeded
     *
     * Usage in retry mechanism (src/services/zenodoService.ts):
     * The Zenodo API sometimes returns 401 Unauthorized or 403 Forbidden due to temporary issues.
     * - If SUCCEEDED: Access token is valid, safe to retry the request
     * - If FAILED: Access token is invalid/expired, do not retry
     * - If NOT_TRIED: Can attempt authentication once to determine next steps
     */
    const ZenodoAuthenticationStates = {
      NOT_TRIED: 0,
      FAILED: 1,
      SUCCEEDED: 2
    };

    function getDefaultExportFromCjs (x) {
    	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
    }

    var ajv$1 = {exports: {}};

    var core$2 = {};

    var validate = {};

    var boolSchema = {};

    var errors = {};

    var codegen = {};

    var code$1 = {};

    var hasRequiredCode$1;
    function requireCode$1() {
      if (hasRequiredCode$1) return code$1;
      hasRequiredCode$1 = 1;
      (function (exports) {

        Object.defineProperty(exports, "__esModule", {
          value: true
        });
        exports.regexpCode = exports.getEsmExportName = exports.getProperty = exports.safeStringify = exports.stringify = exports.strConcat = exports.addCodeArg = exports.str = exports._ = exports.nil = exports._Code = exports.Name = exports.IDENTIFIER = exports._CodeOrName = void 0;
        // eslint-disable-next-line @typescript-eslint/no-extraneous-class
        class _CodeOrName {}
        exports._CodeOrName = _CodeOrName;
        exports.IDENTIFIER = /^[a-z$_][a-z$_0-9]*$/i;
        class Name extends _CodeOrName {
          constructor(s) {
            super();
            if (!exports.IDENTIFIER.test(s)) throw new Error("CodeGen: name must be a valid identifier");
            this.str = s;
          }
          toString() {
            return this.str;
          }
          emptyStr() {
            return false;
          }
          get names() {
            return {
              [this.str]: 1
            };
          }
        }
        exports.Name = Name;
        class _Code extends _CodeOrName {
          constructor(code) {
            super();
            this._items = typeof code === "string" ? [code] : code;
          }
          toString() {
            return this.str;
          }
          emptyStr() {
            if (this._items.length > 1) return false;
            const item = this._items[0];
            return item === "" || item === '""';
          }
          get str() {
            var _a;
            return (_a = this._str) !== null && _a !== void 0 ? _a : this._str = this._items.reduce((s, c) => `${s}${c}`, "");
          }
          get names() {
            var _a;
            return (_a = this._names) !== null && _a !== void 0 ? _a : this._names = this._items.reduce((names, c) => {
              if (c instanceof Name) names[c.str] = (names[c.str] || 0) + 1;
              return names;
            }, {});
          }
        }
        exports._Code = _Code;
        exports.nil = new _Code("");
        function _(strs, ...args) {
          const code = [strs[0]];
          let i = 0;
          while (i < args.length) {
            addCodeArg(code, args[i]);
            code.push(strs[++i]);
          }
          return new _Code(code);
        }
        exports._ = _;
        const plus = new _Code("+");
        function str(strs, ...args) {
          const expr = [safeStringify(strs[0])];
          let i = 0;
          while (i < args.length) {
            expr.push(plus);
            addCodeArg(expr, args[i]);
            expr.push(plus, safeStringify(strs[++i]));
          }
          optimize(expr);
          return new _Code(expr);
        }
        exports.str = str;
        function addCodeArg(code, arg) {
          if (arg instanceof _Code) code.push(...arg._items);else if (arg instanceof Name) code.push(arg);else code.push(interpolate(arg));
        }
        exports.addCodeArg = addCodeArg;
        function optimize(expr) {
          let i = 1;
          while (i < expr.length - 1) {
            if (expr[i] === plus) {
              const res = mergeExprItems(expr[i - 1], expr[i + 1]);
              if (res !== undefined) {
                expr.splice(i - 1, 3, res);
                continue;
              }
              expr[i++] = "+";
            }
            i++;
          }
        }
        function mergeExprItems(a, b) {
          if (b === '""') return a;
          if (a === '""') return b;
          if (typeof a == "string") {
            if (b instanceof Name || a[a.length - 1] !== '"') return;
            if (typeof b != "string") return `${a.slice(0, -1)}${b}"`;
            if (b[0] === '"') return a.slice(0, -1) + b.slice(1);
            return;
          }
          if (typeof b == "string" && b[0] === '"' && !(a instanceof Name)) return `"${a}${b.slice(1)}`;
          return;
        }
        function strConcat(c1, c2) {
          return c2.emptyStr() ? c1 : c1.emptyStr() ? c2 : str`${c1}${c2}`;
        }
        exports.strConcat = strConcat;
        // TODO do not allow arrays here
        function interpolate(x) {
          return typeof x == "number" || typeof x == "boolean" || x === null ? x : safeStringify(Array.isArray(x) ? x.join(",") : x);
        }
        function stringify(x) {
          return new _Code(safeStringify(x));
        }
        exports.stringify = stringify;
        function safeStringify(x) {
          return JSON.stringify(x).replace(/\u2028/g, "\\u2028").replace(/\u2029/g, "\\u2029");
        }
        exports.safeStringify = safeStringify;
        function getProperty(key) {
          return typeof key == "string" && exports.IDENTIFIER.test(key) ? new _Code(`.${key}`) : _`[${key}]`;
        }
        exports.getProperty = getProperty;
        //Does best effort to format the name properly
        function getEsmExportName(key) {
          if (typeof key == "string" && exports.IDENTIFIER.test(key)) {
            return new _Code(`${key}`);
          }
          throw new Error(`CodeGen: invalid export name: ${key}, use explicit $id name mapping`);
        }
        exports.getEsmExportName = getEsmExportName;
        function regexpCode(rx) {
          return new _Code(rx.toString());
        }
        exports.regexpCode = regexpCode;
      })(code$1);
      return code$1;
    }

    var scope = {};

    var hasRequiredScope;
    function requireScope() {
      if (hasRequiredScope) return scope;
      hasRequiredScope = 1;
      (function (exports) {

        Object.defineProperty(exports, "__esModule", {
          value: true
        });
        exports.ValueScope = exports.ValueScopeName = exports.Scope = exports.varKinds = exports.UsedValueState = void 0;
        const code_1 = /*@__PURE__*/requireCode$1();
        class ValueError extends Error {
          constructor(name) {
            super(`CodeGen: "code" for ${name} not defined`);
            this.value = name.value;
          }
        }
        var UsedValueState;
        (function (UsedValueState) {
          UsedValueState[UsedValueState["Started"] = 0] = "Started";
          UsedValueState[UsedValueState["Completed"] = 1] = "Completed";
        })(UsedValueState || (exports.UsedValueState = UsedValueState = {}));
        exports.varKinds = {
          const: new code_1.Name("const"),
          let: new code_1.Name("let"),
          var: new code_1.Name("var")
        };
        class Scope {
          constructor({
            prefixes,
            parent
          } = {}) {
            this._names = {};
            this._prefixes = prefixes;
            this._parent = parent;
          }
          toName(nameOrPrefix) {
            return nameOrPrefix instanceof code_1.Name ? nameOrPrefix : this.name(nameOrPrefix);
          }
          name(prefix) {
            return new code_1.Name(this._newName(prefix));
          }
          _newName(prefix) {
            const ng = this._names[prefix] || this._nameGroup(prefix);
            return `${prefix}${ng.index++}`;
          }
          _nameGroup(prefix) {
            var _a, _b;
            if (((_b = (_a = this._parent) === null || _a === void 0 ? void 0 : _a._prefixes) === null || _b === void 0 ? void 0 : _b.has(prefix)) || this._prefixes && !this._prefixes.has(prefix)) {
              throw new Error(`CodeGen: prefix "${prefix}" is not allowed in this scope`);
            }
            return this._names[prefix] = {
              prefix,
              index: 0
            };
          }
        }
        exports.Scope = Scope;
        class ValueScopeName extends code_1.Name {
          constructor(prefix, nameStr) {
            super(nameStr);
            this.prefix = prefix;
          }
          setValue(value, {
            property,
            itemIndex
          }) {
            this.value = value;
            this.scopePath = (0, code_1._)`.${new code_1.Name(property)}[${itemIndex}]`;
          }
        }
        exports.ValueScopeName = ValueScopeName;
        const line = (0, code_1._)`\n`;
        class ValueScope extends Scope {
          constructor(opts) {
            super(opts);
            this._values = {};
            this._scope = opts.scope;
            this.opts = {
              ...opts,
              _n: opts.lines ? line : code_1.nil
            };
          }
          get() {
            return this._scope;
          }
          name(prefix) {
            return new ValueScopeName(prefix, this._newName(prefix));
          }
          value(nameOrPrefix, value) {
            var _a;
            if (value.ref === undefined) throw new Error("CodeGen: ref must be passed in value");
            const name = this.toName(nameOrPrefix);
            const {
              prefix
            } = name;
            const valueKey = (_a = value.key) !== null && _a !== void 0 ? _a : value.ref;
            let vs = this._values[prefix];
            if (vs) {
              const _name = vs.get(valueKey);
              if (_name) return _name;
            } else {
              vs = this._values[prefix] = new Map();
            }
            vs.set(valueKey, name);
            const s = this._scope[prefix] || (this._scope[prefix] = []);
            const itemIndex = s.length;
            s[itemIndex] = value.ref;
            name.setValue(value, {
              property: prefix,
              itemIndex
            });
            return name;
          }
          getValue(prefix, keyOrRef) {
            const vs = this._values[prefix];
            if (!vs) return;
            return vs.get(keyOrRef);
          }
          scopeRefs(scopeName, values = this._values) {
            return this._reduceValues(values, name => {
              if (name.scopePath === undefined) throw new Error(`CodeGen: name "${name}" has no value`);
              return (0, code_1._)`${scopeName}${name.scopePath}`;
            });
          }
          scopeCode(values = this._values, usedValues, getCode) {
            return this._reduceValues(values, name => {
              if (name.value === undefined) throw new Error(`CodeGen: name "${name}" has no value`);
              return name.value.code;
            }, usedValues, getCode);
          }
          _reduceValues(values, valueCode, usedValues = {}, getCode) {
            let code = code_1.nil;
            for (const prefix in values) {
              const vs = values[prefix];
              if (!vs) continue;
              const nameSet = usedValues[prefix] = usedValues[prefix] || new Map();
              vs.forEach(name => {
                if (nameSet.has(name)) return;
                nameSet.set(name, UsedValueState.Started);
                let c = valueCode(name);
                if (c) {
                  const def = this.opts.es5 ? exports.varKinds.var : exports.varKinds.const;
                  code = (0, code_1._)`${code}${def} ${name} = ${c};${this.opts._n}`;
                } else if (c = getCode === null || getCode === void 0 ? void 0 : getCode(name)) {
                  code = (0, code_1._)`${code}${c}${this.opts._n}`;
                } else {
                  throw new ValueError(name);
                }
                nameSet.set(name, UsedValueState.Completed);
              });
            }
            return code;
          }
        }
        exports.ValueScope = ValueScope;
      })(scope);
      return scope;
    }

    var hasRequiredCodegen;
    function requireCodegen() {
      if (hasRequiredCodegen) return codegen;
      hasRequiredCodegen = 1;
      (function (exports) {

        Object.defineProperty(exports, "__esModule", {
          value: true
        });
        exports.or = exports.and = exports.not = exports.CodeGen = exports.operators = exports.varKinds = exports.ValueScopeName = exports.ValueScope = exports.Scope = exports.Name = exports.regexpCode = exports.stringify = exports.getProperty = exports.nil = exports.strConcat = exports.str = exports._ = void 0;
        const code_1 = /*@__PURE__*/requireCode$1();
        const scope_1 = /*@__PURE__*/requireScope();
        var code_2 = /*@__PURE__*/requireCode$1();
        Object.defineProperty(exports, "_", {
          enumerable: true,
          get: function () {
            return code_2._;
          }
        });
        Object.defineProperty(exports, "str", {
          enumerable: true,
          get: function () {
            return code_2.str;
          }
        });
        Object.defineProperty(exports, "strConcat", {
          enumerable: true,
          get: function () {
            return code_2.strConcat;
          }
        });
        Object.defineProperty(exports, "nil", {
          enumerable: true,
          get: function () {
            return code_2.nil;
          }
        });
        Object.defineProperty(exports, "getProperty", {
          enumerable: true,
          get: function () {
            return code_2.getProperty;
          }
        });
        Object.defineProperty(exports, "stringify", {
          enumerable: true,
          get: function () {
            return code_2.stringify;
          }
        });
        Object.defineProperty(exports, "regexpCode", {
          enumerable: true,
          get: function () {
            return code_2.regexpCode;
          }
        });
        Object.defineProperty(exports, "Name", {
          enumerable: true,
          get: function () {
            return code_2.Name;
          }
        });
        var scope_2 = /*@__PURE__*/requireScope();
        Object.defineProperty(exports, "Scope", {
          enumerable: true,
          get: function () {
            return scope_2.Scope;
          }
        });
        Object.defineProperty(exports, "ValueScope", {
          enumerable: true,
          get: function () {
            return scope_2.ValueScope;
          }
        });
        Object.defineProperty(exports, "ValueScopeName", {
          enumerable: true,
          get: function () {
            return scope_2.ValueScopeName;
          }
        });
        Object.defineProperty(exports, "varKinds", {
          enumerable: true,
          get: function () {
            return scope_2.varKinds;
          }
        });
        exports.operators = {
          GT: new code_1._Code(">"),
          GTE: new code_1._Code(">="),
          LT: new code_1._Code("<"),
          LTE: new code_1._Code("<="),
          EQ: new code_1._Code("==="),
          NEQ: new code_1._Code("!=="),
          NOT: new code_1._Code("!"),
          OR: new code_1._Code("||"),
          AND: new code_1._Code("&&"),
          ADD: new code_1._Code("+")
        };
        class Node {
          optimizeNodes() {
            return this;
          }
          optimizeNames(_names, _constants) {
            return this;
          }
        }
        class Def extends Node {
          constructor(varKind, name, rhs) {
            super();
            this.varKind = varKind;
            this.name = name;
            this.rhs = rhs;
          }
          render({
            es5,
            _n
          }) {
            const varKind = es5 ? scope_1.varKinds.var : this.varKind;
            const rhs = this.rhs === undefined ? "" : ` = ${this.rhs}`;
            return `${varKind} ${this.name}${rhs};` + _n;
          }
          optimizeNames(names, constants) {
            if (!names[this.name.str]) return;
            if (this.rhs) this.rhs = optimizeExpr(this.rhs, names, constants);
            return this;
          }
          get names() {
            return this.rhs instanceof code_1._CodeOrName ? this.rhs.names : {};
          }
        }
        class Assign extends Node {
          constructor(lhs, rhs, sideEffects) {
            super();
            this.lhs = lhs;
            this.rhs = rhs;
            this.sideEffects = sideEffects;
          }
          render({
            _n
          }) {
            return `${this.lhs} = ${this.rhs};` + _n;
          }
          optimizeNames(names, constants) {
            if (this.lhs instanceof code_1.Name && !names[this.lhs.str] && !this.sideEffects) return;
            this.rhs = optimizeExpr(this.rhs, names, constants);
            return this;
          }
          get names() {
            const names = this.lhs instanceof code_1.Name ? {} : {
              ...this.lhs.names
            };
            return addExprNames(names, this.rhs);
          }
        }
        class AssignOp extends Assign {
          constructor(lhs, op, rhs, sideEffects) {
            super(lhs, rhs, sideEffects);
            this.op = op;
          }
          render({
            _n
          }) {
            return `${this.lhs} ${this.op}= ${this.rhs};` + _n;
          }
        }
        class Label extends Node {
          constructor(label) {
            super();
            this.label = label;
            this.names = {};
          }
          render({
            _n
          }) {
            return `${this.label}:` + _n;
          }
        }
        class Break extends Node {
          constructor(label) {
            super();
            this.label = label;
            this.names = {};
          }
          render({
            _n
          }) {
            const label = this.label ? ` ${this.label}` : "";
            return `break${label};` + _n;
          }
        }
        class Throw extends Node {
          constructor(error) {
            super();
            this.error = error;
          }
          render({
            _n
          }) {
            return `throw ${this.error};` + _n;
          }
          get names() {
            return this.error.names;
          }
        }
        class AnyCode extends Node {
          constructor(code) {
            super();
            this.code = code;
          }
          render({
            _n
          }) {
            return `${this.code};` + _n;
          }
          optimizeNodes() {
            return `${this.code}` ? this : undefined;
          }
          optimizeNames(names, constants) {
            this.code = optimizeExpr(this.code, names, constants);
            return this;
          }
          get names() {
            return this.code instanceof code_1._CodeOrName ? this.code.names : {};
          }
        }
        class ParentNode extends Node {
          constructor(nodes = []) {
            super();
            this.nodes = nodes;
          }
          render(opts) {
            return this.nodes.reduce((code, n) => code + n.render(opts), "");
          }
          optimizeNodes() {
            const {
              nodes
            } = this;
            let i = nodes.length;
            while (i--) {
              const n = nodes[i].optimizeNodes();
              if (Array.isArray(n)) nodes.splice(i, 1, ...n);else if (n) nodes[i] = n;else nodes.splice(i, 1);
            }
            return nodes.length > 0 ? this : undefined;
          }
          optimizeNames(names, constants) {
            const {
              nodes
            } = this;
            let i = nodes.length;
            while (i--) {
              // iterating backwards improves 1-pass optimization
              const n = nodes[i];
              if (n.optimizeNames(names, constants)) continue;
              subtractNames(names, n.names);
              nodes.splice(i, 1);
            }
            return nodes.length > 0 ? this : undefined;
          }
          get names() {
            return this.nodes.reduce((names, n) => addNames(names, n.names), {});
          }
        }
        class BlockNode extends ParentNode {
          render(opts) {
            return "{" + opts._n + super.render(opts) + "}" + opts._n;
          }
        }
        class Root extends ParentNode {}
        class Else extends BlockNode {}
        Else.kind = "else";
        class If extends BlockNode {
          constructor(condition, nodes) {
            super(nodes);
            this.condition = condition;
          }
          render(opts) {
            let code = `if(${this.condition})` + super.render(opts);
            if (this.else) code += "else " + this.else.render(opts);
            return code;
          }
          optimizeNodes() {
            super.optimizeNodes();
            const cond = this.condition;
            if (cond === true) return this.nodes; // else is ignored here
            let e = this.else;
            if (e) {
              const ns = e.optimizeNodes();
              e = this.else = Array.isArray(ns) ? new Else(ns) : ns;
            }
            if (e) {
              if (cond === false) return e instanceof If ? e : e.nodes;
              if (this.nodes.length) return this;
              return new If(not(cond), e instanceof If ? [e] : e.nodes);
            }
            if (cond === false || !this.nodes.length) return undefined;
            return this;
          }
          optimizeNames(names, constants) {
            var _a;
            this.else = (_a = this.else) === null || _a === void 0 ? void 0 : _a.optimizeNames(names, constants);
            if (!(super.optimizeNames(names, constants) || this.else)) return;
            this.condition = optimizeExpr(this.condition, names, constants);
            return this;
          }
          get names() {
            const names = super.names;
            addExprNames(names, this.condition);
            if (this.else) addNames(names, this.else.names);
            return names;
          }
        }
        If.kind = "if";
        class For extends BlockNode {}
        For.kind = "for";
        class ForLoop extends For {
          constructor(iteration) {
            super();
            this.iteration = iteration;
          }
          render(opts) {
            return `for(${this.iteration})` + super.render(opts);
          }
          optimizeNames(names, constants) {
            if (!super.optimizeNames(names, constants)) return;
            this.iteration = optimizeExpr(this.iteration, names, constants);
            return this;
          }
          get names() {
            return addNames(super.names, this.iteration.names);
          }
        }
        class ForRange extends For {
          constructor(varKind, name, from, to) {
            super();
            this.varKind = varKind;
            this.name = name;
            this.from = from;
            this.to = to;
          }
          render(opts) {
            const varKind = opts.es5 ? scope_1.varKinds.var : this.varKind;
            const {
              name,
              from,
              to
            } = this;
            return `for(${varKind} ${name}=${from}; ${name}<${to}; ${name}++)` + super.render(opts);
          }
          get names() {
            const names = addExprNames(super.names, this.from);
            return addExprNames(names, this.to);
          }
        }
        class ForIter extends For {
          constructor(loop, varKind, name, iterable) {
            super();
            this.loop = loop;
            this.varKind = varKind;
            this.name = name;
            this.iterable = iterable;
          }
          render(opts) {
            return `for(${this.varKind} ${this.name} ${this.loop} ${this.iterable})` + super.render(opts);
          }
          optimizeNames(names, constants) {
            if (!super.optimizeNames(names, constants)) return;
            this.iterable = optimizeExpr(this.iterable, names, constants);
            return this;
          }
          get names() {
            return addNames(super.names, this.iterable.names);
          }
        }
        class Func extends BlockNode {
          constructor(name, args, async) {
            super();
            this.name = name;
            this.args = args;
            this.async = async;
          }
          render(opts) {
            const _async = this.async ? "async " : "";
            return `${_async}function ${this.name}(${this.args})` + super.render(opts);
          }
        }
        Func.kind = "func";
        class Return extends ParentNode {
          render(opts) {
            return "return " + super.render(opts);
          }
        }
        Return.kind = "return";
        class Try extends BlockNode {
          render(opts) {
            let code = "try" + super.render(opts);
            if (this.catch) code += this.catch.render(opts);
            if (this.finally) code += this.finally.render(opts);
            return code;
          }
          optimizeNodes() {
            var _a, _b;
            super.optimizeNodes();
            (_a = this.catch) === null || _a === void 0 ? void 0 : _a.optimizeNodes();
            (_b = this.finally) === null || _b === void 0 ? void 0 : _b.optimizeNodes();
            return this;
          }
          optimizeNames(names, constants) {
            var _a, _b;
            super.optimizeNames(names, constants);
            (_a = this.catch) === null || _a === void 0 ? void 0 : _a.optimizeNames(names, constants);
            (_b = this.finally) === null || _b === void 0 ? void 0 : _b.optimizeNames(names, constants);
            return this;
          }
          get names() {
            const names = super.names;
            if (this.catch) addNames(names, this.catch.names);
            if (this.finally) addNames(names, this.finally.names);
            return names;
          }
        }
        class Catch extends BlockNode {
          constructor(error) {
            super();
            this.error = error;
          }
          render(opts) {
            return `catch(${this.error})` + super.render(opts);
          }
        }
        Catch.kind = "catch";
        class Finally extends BlockNode {
          render(opts) {
            return "finally" + super.render(opts);
          }
        }
        Finally.kind = "finally";
        class CodeGen {
          constructor(extScope, opts = {}) {
            this._values = {};
            this._blockStarts = [];
            this._constants = {};
            this.opts = {
              ...opts,
              _n: opts.lines ? "\n" : ""
            };
            this._extScope = extScope;
            this._scope = new scope_1.Scope({
              parent: extScope
            });
            this._nodes = [new Root()];
          }
          toString() {
            return this._root.render(this.opts);
          }
          // returns unique name in the internal scope
          name(prefix) {
            return this._scope.name(prefix);
          }
          // reserves unique name in the external scope
          scopeName(prefix) {
            return this._extScope.name(prefix);
          }
          // reserves unique name in the external scope and assigns value to it
          scopeValue(prefixOrName, value) {
            const name = this._extScope.value(prefixOrName, value);
            const vs = this._values[name.prefix] || (this._values[name.prefix] = new Set());
            vs.add(name);
            return name;
          }
          getScopeValue(prefix, keyOrRef) {
            return this._extScope.getValue(prefix, keyOrRef);
          }
          // return code that assigns values in the external scope to the names that are used internally
          // (same names that were returned by gen.scopeName or gen.scopeValue)
          scopeRefs(scopeName) {
            return this._extScope.scopeRefs(scopeName, this._values);
          }
          scopeCode() {
            return this._extScope.scopeCode(this._values);
          }
          _def(varKind, nameOrPrefix, rhs, constant) {
            const name = this._scope.toName(nameOrPrefix);
            if (rhs !== undefined && constant) this._constants[name.str] = rhs;
            this._leafNode(new Def(varKind, name, rhs));
            return name;
          }
          // `const` declaration (`var` in es5 mode)
          const(nameOrPrefix, rhs, _constant) {
            return this._def(scope_1.varKinds.const, nameOrPrefix, rhs, _constant);
          }
          // `let` declaration with optional assignment (`var` in es5 mode)
          let(nameOrPrefix, rhs, _constant) {
            return this._def(scope_1.varKinds.let, nameOrPrefix, rhs, _constant);
          }
          // `var` declaration with optional assignment
          var(nameOrPrefix, rhs, _constant) {
            return this._def(scope_1.varKinds.var, nameOrPrefix, rhs, _constant);
          }
          // assignment code
          assign(lhs, rhs, sideEffects) {
            return this._leafNode(new Assign(lhs, rhs, sideEffects));
          }
          // `+=` code
          add(lhs, rhs) {
            return this._leafNode(new AssignOp(lhs, exports.operators.ADD, rhs));
          }
          // appends passed SafeExpr to code or executes Block
          code(c) {
            if (typeof c == "function") c();else if (c !== code_1.nil) this._leafNode(new AnyCode(c));
            return this;
          }
          // returns code for object literal for the passed argument list of key-value pairs
          object(...keyValues) {
            const code = ["{"];
            for (const [key, value] of keyValues) {
              if (code.length > 1) code.push(",");
              code.push(key);
              if (key !== value || this.opts.es5) {
                code.push(":");
                (0, code_1.addCodeArg)(code, value);
              }
            }
            code.push("}");
            return new code_1._Code(code);
          }
          // `if` clause (or statement if `thenBody` and, optionally, `elseBody` are passed)
          if(condition, thenBody, elseBody) {
            this._blockNode(new If(condition));
            if (thenBody && elseBody) {
              this.code(thenBody).else().code(elseBody).endIf();
            } else if (thenBody) {
              this.code(thenBody).endIf();
            } else if (elseBody) {
              throw new Error('CodeGen: "else" body without "then" body');
            }
            return this;
          }
          // `else if` clause - invalid without `if` or after `else` clauses
          elseIf(condition) {
            return this._elseNode(new If(condition));
          }
          // `else` clause - only valid after `if` or `else if` clauses
          else() {
            return this._elseNode(new Else());
          }
          // end `if` statement (needed if gen.if was used only with condition)
          endIf() {
            return this._endBlockNode(If, Else);
          }
          _for(node, forBody) {
            this._blockNode(node);
            if (forBody) this.code(forBody).endFor();
            return this;
          }
          // a generic `for` clause (or statement if `forBody` is passed)
          for(iteration, forBody) {
            return this._for(new ForLoop(iteration), forBody);
          }
          // `for` statement for a range of values
          forRange(nameOrPrefix, from, to, forBody, varKind = this.opts.es5 ? scope_1.varKinds.var : scope_1.varKinds.let) {
            const name = this._scope.toName(nameOrPrefix);
            return this._for(new ForRange(varKind, name, from, to), () => forBody(name));
          }
          // `for-of` statement (in es5 mode replace with a normal for loop)
          forOf(nameOrPrefix, iterable, forBody, varKind = scope_1.varKinds.const) {
            const name = this._scope.toName(nameOrPrefix);
            if (this.opts.es5) {
              const arr = iterable instanceof code_1.Name ? iterable : this.var("_arr", iterable);
              return this.forRange("_i", 0, (0, code_1._)`${arr}.length`, i => {
                this.var(name, (0, code_1._)`${arr}[${i}]`);
                forBody(name);
              });
            }
            return this._for(new ForIter("of", varKind, name, iterable), () => forBody(name));
          }
          // `for-in` statement.
          // With option `ownProperties` replaced with a `for-of` loop for object keys
          forIn(nameOrPrefix, obj, forBody, varKind = this.opts.es5 ? scope_1.varKinds.var : scope_1.varKinds.const) {
            if (this.opts.ownProperties) {
              return this.forOf(nameOrPrefix, (0, code_1._)`Object.keys(${obj})`, forBody);
            }
            const name = this._scope.toName(nameOrPrefix);
            return this._for(new ForIter("in", varKind, name, obj), () => forBody(name));
          }
          // end `for` loop
          endFor() {
            return this._endBlockNode(For);
          }
          // `label` statement
          label(label) {
            return this._leafNode(new Label(label));
          }
          // `break` statement
          break(label) {
            return this._leafNode(new Break(label));
          }
          // `return` statement
          return(value) {
            const node = new Return();
            this._blockNode(node);
            this.code(value);
            if (node.nodes.length !== 1) throw new Error('CodeGen: "return" should have one node');
            return this._endBlockNode(Return);
          }
          // `try` statement
          try(tryBody, catchCode, finallyCode) {
            if (!catchCode && !finallyCode) throw new Error('CodeGen: "try" without "catch" and "finally"');
            const node = new Try();
            this._blockNode(node);
            this.code(tryBody);
            if (catchCode) {
              const error = this.name("e");
              this._currNode = node.catch = new Catch(error);
              catchCode(error);
            }
            if (finallyCode) {
              this._currNode = node.finally = new Finally();
              this.code(finallyCode);
            }
            return this._endBlockNode(Catch, Finally);
          }
          // `throw` statement
          throw(error) {
            return this._leafNode(new Throw(error));
          }
          // start self-balancing block
          block(body, nodeCount) {
            this._blockStarts.push(this._nodes.length);
            if (body) this.code(body).endBlock(nodeCount);
            return this;
          }
          // end the current self-balancing block
          endBlock(nodeCount) {
            const len = this._blockStarts.pop();
            if (len === undefined) throw new Error("CodeGen: not in self-balancing block");
            const toClose = this._nodes.length - len;
            if (toClose < 0 || nodeCount !== undefined && toClose !== nodeCount) {
              throw new Error(`CodeGen: wrong number of nodes: ${toClose} vs ${nodeCount} expected`);
            }
            this._nodes.length = len;
            return this;
          }
          // `function` heading (or definition if funcBody is passed)
          func(name, args = code_1.nil, async, funcBody) {
            this._blockNode(new Func(name, args, async));
            if (funcBody) this.code(funcBody).endFunc();
            return this;
          }
          // end function definition
          endFunc() {
            return this._endBlockNode(Func);
          }
          optimize(n = 1) {
            while (n-- > 0) {
              this._root.optimizeNodes();
              this._root.optimizeNames(this._root.names, this._constants);
            }
          }
          _leafNode(node) {
            this._currNode.nodes.push(node);
            return this;
          }
          _blockNode(node) {
            this._currNode.nodes.push(node);
            this._nodes.push(node);
          }
          _endBlockNode(N1, N2) {
            const n = this._currNode;
            if (n instanceof N1 || N2 && n instanceof N2) {
              this._nodes.pop();
              return this;
            }
            throw new Error(`CodeGen: not in block "${N2 ? `${N1.kind}/${N2.kind}` : N1.kind}"`);
          }
          _elseNode(node) {
            const n = this._currNode;
            if (!(n instanceof If)) {
              throw new Error('CodeGen: "else" without "if"');
            }
            this._currNode = n.else = node;
            return this;
          }
          get _root() {
            return this._nodes[0];
          }
          get _currNode() {
            const ns = this._nodes;
            return ns[ns.length - 1];
          }
          set _currNode(node) {
            const ns = this._nodes;
            ns[ns.length - 1] = node;
          }
        }
        exports.CodeGen = CodeGen;
        function addNames(names, from) {
          for (const n in from) names[n] = (names[n] || 0) + (from[n] || 0);
          return names;
        }
        function addExprNames(names, from) {
          return from instanceof code_1._CodeOrName ? addNames(names, from.names) : names;
        }
        function optimizeExpr(expr, names, constants) {
          if (expr instanceof code_1.Name) return replaceName(expr);
          if (!canOptimize(expr)) return expr;
          return new code_1._Code(expr._items.reduce((items, c) => {
            if (c instanceof code_1.Name) c = replaceName(c);
            if (c instanceof code_1._Code) items.push(...c._items);else items.push(c);
            return items;
          }, []));
          function replaceName(n) {
            const c = constants[n.str];
            if (c === undefined || names[n.str] !== 1) return n;
            delete names[n.str];
            return c;
          }
          function canOptimize(e) {
            return e instanceof code_1._Code && e._items.some(c => c instanceof code_1.Name && names[c.str] === 1 && constants[c.str] !== undefined);
          }
        }
        function subtractNames(names, from) {
          for (const n in from) names[n] = (names[n] || 0) - (from[n] || 0);
        }
        function not(x) {
          return typeof x == "boolean" || typeof x == "number" || x === null ? !x : (0, code_1._)`!${par(x)}`;
        }
        exports.not = not;
        const andCode = mappend(exports.operators.AND);
        // boolean AND (&&) expression with the passed arguments
        function and(...args) {
          return args.reduce(andCode);
        }
        exports.and = and;
        const orCode = mappend(exports.operators.OR);
        // boolean OR (||) expression with the passed arguments
        function or(...args) {
          return args.reduce(orCode);
        }
        exports.or = or;
        function mappend(op) {
          return (x, y) => x === code_1.nil ? y : y === code_1.nil ? x : (0, code_1._)`${par(x)} ${op} ${par(y)}`;
        }
        function par(x) {
          return x instanceof code_1.Name ? x : (0, code_1._)`(${x})`;
        }
      })(codegen);
      return codegen;
    }

    var util = {};

    Object.defineProperty(util, "__esModule", {
      value: true
    });
    util.checkStrictMode = util.getErrorPath = util.Type = util.useFunc = util.setEvaluated = util.evaluatedPropsToName = util.mergeEvaluated = util.eachItem = util.unescapeJsonPointer = util.escapeJsonPointer = util.escapeFragment = util.unescapeFragment = util.schemaRefOrVal = util.schemaHasRulesButRef = util.schemaHasRules = util.checkUnknownRules = util.alwaysValidSchema = util.toHash = void 0;
    const codegen_1$o = /*@__PURE__*/requireCodegen();
    const code_1$9 = /*@__PURE__*/requireCode$1();
    // TODO refactor to use Set
    function toHash(arr) {
      const hash = {};
      for (const item of arr) hash[item] = true;
      return hash;
    }
    util.toHash = toHash;
    function alwaysValidSchema(it, schema) {
      if (typeof schema == "boolean") return schema;
      if (Object.keys(schema).length === 0) return true;
      checkUnknownRules(it, schema);
      return !schemaHasRules(schema, it.self.RULES.all);
    }
    util.alwaysValidSchema = alwaysValidSchema;
    function checkUnknownRules(it, schema = it.schema) {
      const {
        opts,
        self
      } = it;
      if (!opts.strictSchema) return;
      if (typeof schema === "boolean") return;
      const rules = self.RULES.keywords;
      for (const key in schema) {
        if (!rules[key]) checkStrictMode(it, `unknown keyword: "${key}"`);
      }
    }
    util.checkUnknownRules = checkUnknownRules;
    function schemaHasRules(schema, rules) {
      if (typeof schema == "boolean") return !schema;
      for (const key in schema) if (rules[key]) return true;
      return false;
    }
    util.schemaHasRules = schemaHasRules;
    function schemaHasRulesButRef(schema, RULES) {
      if (typeof schema == "boolean") return !schema;
      for (const key in schema) if (key !== "$ref" && RULES.all[key]) return true;
      return false;
    }
    util.schemaHasRulesButRef = schemaHasRulesButRef;
    function schemaRefOrVal({
      topSchemaRef,
      schemaPath
    }, schema, keyword, $data) {
      if (!$data) {
        if (typeof schema == "number" || typeof schema == "boolean") return schema;
        if (typeof schema == "string") return (0, codegen_1$o._)`${schema}`;
      }
      return (0, codegen_1$o._)`${topSchemaRef}${schemaPath}${(0, codegen_1$o.getProperty)(keyword)}`;
    }
    util.schemaRefOrVal = schemaRefOrVal;
    function unescapeFragment(str) {
      return unescapeJsonPointer(decodeURIComponent(str));
    }
    util.unescapeFragment = unescapeFragment;
    function escapeFragment(str) {
      return encodeURIComponent(escapeJsonPointer(str));
    }
    util.escapeFragment = escapeFragment;
    function escapeJsonPointer(str) {
      if (typeof str == "number") return `${str}`;
      return str.replace(/~/g, "~0").replace(/\//g, "~1");
    }
    util.escapeJsonPointer = escapeJsonPointer;
    function unescapeJsonPointer(str) {
      return str.replace(/~1/g, "/").replace(/~0/g, "~");
    }
    util.unescapeJsonPointer = unescapeJsonPointer;
    function eachItem(xs, f) {
      if (Array.isArray(xs)) {
        for (const x of xs) f(x);
      } else {
        f(xs);
      }
    }
    util.eachItem = eachItem;
    function makeMergeEvaluated({
      mergeNames,
      mergeToName,
      mergeValues,
      resultToName
    }) {
      return (gen, from, to, toName) => {
        const res = to === undefined ? from : to instanceof codegen_1$o.Name ? (from instanceof codegen_1$o.Name ? mergeNames(gen, from, to) : mergeToName(gen, from, to), to) : from instanceof codegen_1$o.Name ? (mergeToName(gen, to, from), from) : mergeValues(from, to);
        return toName === codegen_1$o.Name && !(res instanceof codegen_1$o.Name) ? resultToName(gen, res) : res;
      };
    }
    util.mergeEvaluated = {
      props: makeMergeEvaluated({
        mergeNames: (gen, from, to) => gen.if((0, codegen_1$o._)`${to} !== true && ${from} !== undefined`, () => {
          gen.if((0, codegen_1$o._)`${from} === true`, () => gen.assign(to, true), () => gen.assign(to, (0, codegen_1$o._)`${to} || {}`).code((0, codegen_1$o._)`Object.assign(${to}, ${from})`));
        }),
        mergeToName: (gen, from, to) => gen.if((0, codegen_1$o._)`${to} !== true`, () => {
          if (from === true) {
            gen.assign(to, true);
          } else {
            gen.assign(to, (0, codegen_1$o._)`${to} || {}`);
            setEvaluated(gen, to, from);
          }
        }),
        mergeValues: (from, to) => from === true ? true : {
          ...from,
          ...to
        },
        resultToName: evaluatedPropsToName
      }),
      items: makeMergeEvaluated({
        mergeNames: (gen, from, to) => gen.if((0, codegen_1$o._)`${to} !== true && ${from} !== undefined`, () => gen.assign(to, (0, codegen_1$o._)`${from} === true ? true : ${to} > ${from} ? ${to} : ${from}`)),
        mergeToName: (gen, from, to) => gen.if((0, codegen_1$o._)`${to} !== true`, () => gen.assign(to, from === true ? true : (0, codegen_1$o._)`${to} > ${from} ? ${to} : ${from}`)),
        mergeValues: (from, to) => from === true ? true : Math.max(from, to),
        resultToName: (gen, items) => gen.var("items", items)
      })
    };
    function evaluatedPropsToName(gen, ps) {
      if (ps === true) return gen.var("props", true);
      const props = gen.var("props", (0, codegen_1$o._)`{}`);
      if (ps !== undefined) setEvaluated(gen, props, ps);
      return props;
    }
    util.evaluatedPropsToName = evaluatedPropsToName;
    function setEvaluated(gen, props, ps) {
      Object.keys(ps).forEach(p => gen.assign((0, codegen_1$o._)`${props}${(0, codegen_1$o.getProperty)(p)}`, true));
    }
    util.setEvaluated = setEvaluated;
    const snippets = {};
    function useFunc(gen, f) {
      return gen.scopeValue("func", {
        ref: f,
        code: snippets[f.code] || (snippets[f.code] = new code_1$9._Code(f.code))
      });
    }
    util.useFunc = useFunc;
    var Type;
    (function (Type) {
      Type[Type["Num"] = 0] = "Num";
      Type[Type["Str"] = 1] = "Str";
    })(Type || (util.Type = Type = {}));
    function getErrorPath(dataProp, dataPropType, jsPropertySyntax) {
      // let path
      if (dataProp instanceof codegen_1$o.Name) {
        const isNumber = dataPropType === Type.Num;
        return jsPropertySyntax ? isNumber ? (0, codegen_1$o._)`"[" + ${dataProp} + "]"` : (0, codegen_1$o._)`"['" + ${dataProp} + "']"` : isNumber ? (0, codegen_1$o._)`"/" + ${dataProp}` : (0, codegen_1$o._)`"/" + ${dataProp}.replace(/~/g, "~0").replace(/\\//g, "~1")`; // TODO maybe use global escapePointer
      }
      return jsPropertySyntax ? (0, codegen_1$o.getProperty)(dataProp).toString() : "/" + escapeJsonPointer(dataProp);
    }
    util.getErrorPath = getErrorPath;
    function checkStrictMode(it, msg, mode = it.opts.strictSchema) {
      if (!mode) return;
      msg = `strict mode: ${msg}`;
      if (mode === true) throw new Error(msg);
      it.self.logger.warn(msg);
    }
    util.checkStrictMode = checkStrictMode;

    var names = {};

    var hasRequiredNames;
    function requireNames() {
      if (hasRequiredNames) return names;
      hasRequiredNames = 1;
      Object.defineProperty(names, "__esModule", {
        value: true
      });
      const codegen_1 = /*@__PURE__*/requireCodegen();
      const names$1 = {
        // validation function arguments
        data: new codegen_1.Name("data"),
        // data passed to validation function
        // args passed from referencing schema
        valCxt: new codegen_1.Name("valCxt"),
        // validation/data context - should not be used directly, it is destructured to the names below
        instancePath: new codegen_1.Name("instancePath"),
        parentData: new codegen_1.Name("parentData"),
        parentDataProperty: new codegen_1.Name("parentDataProperty"),
        rootData: new codegen_1.Name("rootData"),
        // root data - same as the data passed to the first/top validation function
        dynamicAnchors: new codegen_1.Name("dynamicAnchors"),
        // used to support recursiveRef and dynamicRef
        // function scoped variables
        vErrors: new codegen_1.Name("vErrors"),
        // null or array of validation errors
        errors: new codegen_1.Name("errors"),
        // counter of validation errors
        this: new codegen_1.Name("this"),
        // "globals"
        self: new codegen_1.Name("self"),
        scope: new codegen_1.Name("scope"),
        // JTD serialize/parse name for JSON string and position
        json: new codegen_1.Name("json"),
        jsonPos: new codegen_1.Name("jsonPos"),
        jsonLen: new codegen_1.Name("jsonLen"),
        jsonPart: new codegen_1.Name("jsonPart")
      };
      names.default = names$1;
      return names;
    }

    var hasRequiredErrors;
    function requireErrors() {
      if (hasRequiredErrors) return errors;
      hasRequiredErrors = 1;
      (function (exports) {

        Object.defineProperty(exports, "__esModule", {
          value: true
        });
        exports.extendErrors = exports.resetErrorsCount = exports.reportExtraError = exports.reportError = exports.keyword$DataError = exports.keywordError = void 0;
        const codegen_1 = /*@__PURE__*/requireCodegen();
        const util_1 = util;
        const names_1 = /*@__PURE__*/requireNames();
        exports.keywordError = {
          message: ({
            keyword
          }) => (0, codegen_1.str)`must pass "${keyword}" keyword validation`
        };
        exports.keyword$DataError = {
          message: ({
            keyword,
            schemaType
          }) => schemaType ? (0, codegen_1.str)`"${keyword}" keyword must be ${schemaType} ($data)` : (0, codegen_1.str)`"${keyword}" keyword is invalid ($data)`
        };
        function reportError(cxt, error = exports.keywordError, errorPaths, overrideAllErrors) {
          const {
            it
          } = cxt;
          const {
            gen,
            compositeRule,
            allErrors
          } = it;
          const errObj = errorObjectCode(cxt, error, errorPaths);
          if (overrideAllErrors !== null && overrideAllErrors !== void 0 ? overrideAllErrors : compositeRule || allErrors) {
            addError(gen, errObj);
          } else {
            returnErrors(it, (0, codegen_1._)`[${errObj}]`);
          }
        }
        exports.reportError = reportError;
        function reportExtraError(cxt, error = exports.keywordError, errorPaths) {
          const {
            it
          } = cxt;
          const {
            gen,
            compositeRule,
            allErrors
          } = it;
          const errObj = errorObjectCode(cxt, error, errorPaths);
          addError(gen, errObj);
          if (!(compositeRule || allErrors)) {
            returnErrors(it, names_1.default.vErrors);
          }
        }
        exports.reportExtraError = reportExtraError;
        function resetErrorsCount(gen, errsCount) {
          gen.assign(names_1.default.errors, errsCount);
          gen.if((0, codegen_1._)`${names_1.default.vErrors} !== null`, () => gen.if(errsCount, () => gen.assign((0, codegen_1._)`${names_1.default.vErrors}.length`, errsCount), () => gen.assign(names_1.default.vErrors, null)));
        }
        exports.resetErrorsCount = resetErrorsCount;
        function extendErrors({
          gen,
          keyword,
          schemaValue,
          data,
          errsCount,
          it
        }) {
          /* istanbul ignore if */
          if (errsCount === undefined) throw new Error("ajv implementation error");
          const err = gen.name("err");
          gen.forRange("i", errsCount, names_1.default.errors, i => {
            gen.const(err, (0, codegen_1._)`${names_1.default.vErrors}[${i}]`);
            gen.if((0, codegen_1._)`${err}.instancePath === undefined`, () => gen.assign((0, codegen_1._)`${err}.instancePath`, (0, codegen_1.strConcat)(names_1.default.instancePath, it.errorPath)));
            gen.assign((0, codegen_1._)`${err}.schemaPath`, (0, codegen_1.str)`${it.errSchemaPath}/${keyword}`);
            if (it.opts.verbose) {
              gen.assign((0, codegen_1._)`${err}.schema`, schemaValue);
              gen.assign((0, codegen_1._)`${err}.data`, data);
            }
          });
        }
        exports.extendErrors = extendErrors;
        function addError(gen, errObj) {
          const err = gen.const("err", errObj);
          gen.if((0, codegen_1._)`${names_1.default.vErrors} === null`, () => gen.assign(names_1.default.vErrors, (0, codegen_1._)`[${err}]`), (0, codegen_1._)`${names_1.default.vErrors}.push(${err})`);
          gen.code((0, codegen_1._)`${names_1.default.errors}++`);
        }
        function returnErrors(it, errs) {
          const {
            gen,
            validateName,
            schemaEnv
          } = it;
          if (schemaEnv.$async) {
            gen.throw((0, codegen_1._)`new ${it.ValidationError}(${errs})`);
          } else {
            gen.assign((0, codegen_1._)`${validateName}.errors`, errs);
            gen.return(false);
          }
        }
        const E = {
          keyword: new codegen_1.Name("keyword"),
          schemaPath: new codegen_1.Name("schemaPath"),
          // also used in JTD errors
          params: new codegen_1.Name("params"),
          propertyName: new codegen_1.Name("propertyName"),
          message: new codegen_1.Name("message"),
          schema: new codegen_1.Name("schema"),
          parentSchema: new codegen_1.Name("parentSchema")
        };
        function errorObjectCode(cxt, error, errorPaths) {
          const {
            createErrors
          } = cxt.it;
          if (createErrors === false) return (0, codegen_1._)`{}`;
          return errorObject(cxt, error, errorPaths);
        }
        function errorObject(cxt, error, errorPaths = {}) {
          const {
            gen,
            it
          } = cxt;
          const keyValues = [errorInstancePath(it, errorPaths), errorSchemaPath(cxt, errorPaths)];
          extraErrorProps(cxt, error, keyValues);
          return gen.object(...keyValues);
        }
        function errorInstancePath({
          errorPath
        }, {
          instancePath
        }) {
          const instPath = instancePath ? (0, codegen_1.str)`${errorPath}${(0, util_1.getErrorPath)(instancePath, util_1.Type.Str)}` : errorPath;
          return [names_1.default.instancePath, (0, codegen_1.strConcat)(names_1.default.instancePath, instPath)];
        }
        function errorSchemaPath({
          keyword,
          it: {
            errSchemaPath
          }
        }, {
          schemaPath,
          parentSchema
        }) {
          let schPath = parentSchema ? errSchemaPath : (0, codegen_1.str)`${errSchemaPath}/${keyword}`;
          if (schemaPath) {
            schPath = (0, codegen_1.str)`${schPath}${(0, util_1.getErrorPath)(schemaPath, util_1.Type.Str)}`;
          }
          return [E.schemaPath, schPath];
        }
        function extraErrorProps(cxt, {
          params,
          message
        }, keyValues) {
          const {
            keyword,
            data,
            schemaValue,
            it
          } = cxt;
          const {
            opts,
            propertyName,
            topSchemaRef,
            schemaPath
          } = it;
          keyValues.push([E.keyword, keyword], [E.params, typeof params == "function" ? params(cxt) : params || (0, codegen_1._)`{}`]);
          if (opts.messages) {
            keyValues.push([E.message, typeof message == "function" ? message(cxt) : message]);
          }
          if (opts.verbose) {
            keyValues.push([E.schema, schemaValue], [E.parentSchema, (0, codegen_1._)`${topSchemaRef}${schemaPath}`], [names_1.default.data, data]);
          }
          if (propertyName) keyValues.push([E.propertyName, propertyName]);
        }
      })(errors);
      return errors;
    }

    var hasRequiredBoolSchema;
    function requireBoolSchema() {
      if (hasRequiredBoolSchema) return boolSchema;
      hasRequiredBoolSchema = 1;
      Object.defineProperty(boolSchema, "__esModule", {
        value: true
      });
      boolSchema.boolOrEmptySchema = boolSchema.topBoolOrEmptySchema = void 0;
      const errors_1 = /*@__PURE__*/requireErrors();
      const codegen_1 = /*@__PURE__*/requireCodegen();
      const names_1 = /*@__PURE__*/requireNames();
      const boolError = {
        message: "boolean schema is false"
      };
      function topBoolOrEmptySchema(it) {
        const {
          gen,
          schema,
          validateName
        } = it;
        if (schema === false) {
          falseSchemaError(it, false);
        } else if (typeof schema == "object" && schema.$async === true) {
          gen.return(names_1.default.data);
        } else {
          gen.assign((0, codegen_1._)`${validateName}.errors`, null);
          gen.return(true);
        }
      }
      boolSchema.topBoolOrEmptySchema = topBoolOrEmptySchema;
      function boolOrEmptySchema(it, valid) {
        const {
          gen,
          schema
        } = it;
        if (schema === false) {
          gen.var(valid, false); // TODO var
          falseSchemaError(it);
        } else {
          gen.var(valid, true); // TODO var
        }
      }
      boolSchema.boolOrEmptySchema = boolOrEmptySchema;
      function falseSchemaError(it, overrideAllErrors) {
        const {
          gen,
          data
        } = it;
        // TODO maybe some other interface should be used for non-keyword validation errors...
        const cxt = {
          gen,
          keyword: "false schema",
          data,
          schema: false,
          schemaCode: false,
          schemaValue: false,
          params: {},
          it
        };
        (0, errors_1.reportError)(cxt, boolError, undefined, overrideAllErrors);
      }
      return boolSchema;
    }

    var dataType = {};

    var rules = {};

    Object.defineProperty(rules, "__esModule", {
      value: true
    });
    rules.getRules = rules.isJSONType = void 0;
    const _jsonTypes = ["string", "number", "integer", "boolean", "null", "object", "array"];
    const jsonTypes = new Set(_jsonTypes);
    function isJSONType(x) {
      return typeof x == "string" && jsonTypes.has(x);
    }
    rules.isJSONType = isJSONType;
    function getRules() {
      const groups = {
        number: {
          type: "number",
          rules: []
        },
        string: {
          type: "string",
          rules: []
        },
        array: {
          type: "array",
          rules: []
        },
        object: {
          type: "object",
          rules: []
        }
      };
      return {
        types: {
          ...groups,
          integer: true,
          boolean: true,
          null: true
        },
        rules: [{
          rules: []
        }, groups.number, groups.string, groups.array, groups.object],
        post: {
          rules: []
        },
        all: {},
        keywords: {}
      };
    }
    rules.getRules = getRules;

    var applicability = {};

    var hasRequiredApplicability;
    function requireApplicability() {
      if (hasRequiredApplicability) return applicability;
      hasRequiredApplicability = 1;
      Object.defineProperty(applicability, "__esModule", {
        value: true
      });
      applicability.shouldUseRule = applicability.shouldUseGroup = applicability.schemaHasRulesForType = void 0;
      function schemaHasRulesForType({
        schema,
        self
      }, type) {
        const group = self.RULES.types[type];
        return group && group !== true && shouldUseGroup(schema, group);
      }
      applicability.schemaHasRulesForType = schemaHasRulesForType;
      function shouldUseGroup(schema, group) {
        return group.rules.some(rule => shouldUseRule(schema, rule));
      }
      applicability.shouldUseGroup = shouldUseGroup;
      function shouldUseRule(schema, rule) {
        var _a;
        return schema[rule.keyword] !== undefined || ((_a = rule.definition.implements) === null || _a === void 0 ? void 0 : _a.some(kwd => schema[kwd] !== undefined));
      }
      applicability.shouldUseRule = shouldUseRule;
      return applicability;
    }

    Object.defineProperty(dataType, "__esModule", {
      value: true
    });
    dataType.reportTypeError = dataType.checkDataTypes = dataType.checkDataType = dataType.coerceAndCheckDataType = dataType.getJSONTypes = dataType.getSchemaTypes = dataType.DataType = void 0;
    const rules_1 = rules;
    const applicability_1 = /*@__PURE__*/requireApplicability();
    const errors_1 = /*@__PURE__*/requireErrors();
    const codegen_1$n = /*@__PURE__*/requireCodegen();
    const util_1$m = util;
    var DataType;
    (function (DataType) {
      DataType[DataType["Correct"] = 0] = "Correct";
      DataType[DataType["Wrong"] = 1] = "Wrong";
    })(DataType || (dataType.DataType = DataType = {}));
    function getSchemaTypes(schema) {
      const types = getJSONTypes(schema.type);
      const hasNull = types.includes("null");
      if (hasNull) {
        if (schema.nullable === false) throw new Error("type: null contradicts nullable: false");
      } else {
        if (!types.length && schema.nullable !== undefined) {
          throw new Error('"nullable" cannot be used without "type"');
        }
        if (schema.nullable === true) types.push("null");
      }
      return types;
    }
    dataType.getSchemaTypes = getSchemaTypes;
    // eslint-disable-next-line @typescript-eslint/no-redundant-type-constituents
    function getJSONTypes(ts) {
      const types = Array.isArray(ts) ? ts : ts ? [ts] : [];
      if (types.every(rules_1.isJSONType)) return types;
      throw new Error("type must be JSONType or JSONType[]: " + types.join(","));
    }
    dataType.getJSONTypes = getJSONTypes;
    function coerceAndCheckDataType(it, types) {
      const {
        gen,
        data,
        opts
      } = it;
      const coerceTo = coerceToTypes(types, opts.coerceTypes);
      const checkTypes = types.length > 0 && !(coerceTo.length === 0 && types.length === 1 && (0, applicability_1.schemaHasRulesForType)(it, types[0]));
      if (checkTypes) {
        const wrongType = checkDataTypes(types, data, opts.strictNumbers, DataType.Wrong);
        gen.if(wrongType, () => {
          if (coerceTo.length) coerceData(it, types, coerceTo);else reportTypeError(it);
        });
      }
      return checkTypes;
    }
    dataType.coerceAndCheckDataType = coerceAndCheckDataType;
    const COERCIBLE = new Set(["string", "number", "integer", "boolean", "null"]);
    function coerceToTypes(types, coerceTypes) {
      return coerceTypes ? types.filter(t => COERCIBLE.has(t) || coerceTypes === "array" && t === "array") : [];
    }
    function coerceData(it, types, coerceTo) {
      const {
        gen,
        data,
        opts
      } = it;
      const dataType = gen.let("dataType", (0, codegen_1$n._)`typeof ${data}`);
      const coerced = gen.let("coerced", (0, codegen_1$n._)`undefined`);
      if (opts.coerceTypes === "array") {
        gen.if((0, codegen_1$n._)`${dataType} == 'object' && Array.isArray(${data}) && ${data}.length == 1`, () => gen.assign(data, (0, codegen_1$n._)`${data}[0]`).assign(dataType, (0, codegen_1$n._)`typeof ${data}`).if(checkDataTypes(types, data, opts.strictNumbers), () => gen.assign(coerced, data)));
      }
      gen.if((0, codegen_1$n._)`${coerced} !== undefined`);
      for (const t of coerceTo) {
        if (COERCIBLE.has(t) || t === "array" && opts.coerceTypes === "array") {
          coerceSpecificType(t);
        }
      }
      gen.else();
      reportTypeError(it);
      gen.endIf();
      gen.if((0, codegen_1$n._)`${coerced} !== undefined`, () => {
        gen.assign(data, coerced);
        assignParentData(it, coerced);
      });
      function coerceSpecificType(t) {
        switch (t) {
          case "string":
            gen.elseIf((0, codegen_1$n._)`${dataType} == "number" || ${dataType} == "boolean"`).assign(coerced, (0, codegen_1$n._)`"" + ${data}`).elseIf((0, codegen_1$n._)`${data} === null`).assign(coerced, (0, codegen_1$n._)`""`);
            return;
          case "number":
            gen.elseIf((0, codegen_1$n._)`${dataType} == "boolean" || ${data} === null
              || (${dataType} == "string" && ${data} && ${data} == +${data})`).assign(coerced, (0, codegen_1$n._)`+${data}`);
            return;
          case "integer":
            gen.elseIf((0, codegen_1$n._)`${dataType} === "boolean" || ${data} === null
              || (${dataType} === "string" && ${data} && ${data} == +${data} && !(${data} % 1))`).assign(coerced, (0, codegen_1$n._)`+${data}`);
            return;
          case "boolean":
            gen.elseIf((0, codegen_1$n._)`${data} === "false" || ${data} === 0 || ${data} === null`).assign(coerced, false).elseIf((0, codegen_1$n._)`${data} === "true" || ${data} === 1`).assign(coerced, true);
            return;
          case "null":
            gen.elseIf((0, codegen_1$n._)`${data} === "" || ${data} === 0 || ${data} === false`);
            gen.assign(coerced, null);
            return;
          case "array":
            gen.elseIf((0, codegen_1$n._)`${dataType} === "string" || ${dataType} === "number"
              || ${dataType} === "boolean" || ${data} === null`).assign(coerced, (0, codegen_1$n._)`[${data}]`);
        }
      }
    }
    function assignParentData({
      gen,
      parentData,
      parentDataProperty
    }, expr) {
      // TODO use gen.property
      gen.if((0, codegen_1$n._)`${parentData} !== undefined`, () => gen.assign((0, codegen_1$n._)`${parentData}[${parentDataProperty}]`, expr));
    }
    function checkDataType(dataType, data, strictNums, correct = DataType.Correct) {
      const EQ = correct === DataType.Correct ? codegen_1$n.operators.EQ : codegen_1$n.operators.NEQ;
      let cond;
      switch (dataType) {
        case "null":
          return (0, codegen_1$n._)`${data} ${EQ} null`;
        case "array":
          cond = (0, codegen_1$n._)`Array.isArray(${data})`;
          break;
        case "object":
          cond = (0, codegen_1$n._)`${data} && typeof ${data} == "object" && !Array.isArray(${data})`;
          break;
        case "integer":
          cond = numCond((0, codegen_1$n._)`!(${data} % 1) && !isNaN(${data})`);
          break;
        case "number":
          cond = numCond();
          break;
        default:
          return (0, codegen_1$n._)`typeof ${data} ${EQ} ${dataType}`;
      }
      return correct === DataType.Correct ? cond : (0, codegen_1$n.not)(cond);
      function numCond(_cond = codegen_1$n.nil) {
        return (0, codegen_1$n.and)((0, codegen_1$n._)`typeof ${data} == "number"`, _cond, strictNums ? (0, codegen_1$n._)`isFinite(${data})` : codegen_1$n.nil);
      }
    }
    dataType.checkDataType = checkDataType;
    function checkDataTypes(dataTypes, data, strictNums, correct) {
      if (dataTypes.length === 1) {
        return checkDataType(dataTypes[0], data, strictNums, correct);
      }
      let cond;
      const types = (0, util_1$m.toHash)(dataTypes);
      if (types.array && types.object) {
        const notObj = (0, codegen_1$n._)`typeof ${data} != "object"`;
        cond = types.null ? notObj : (0, codegen_1$n._)`!${data} || ${notObj}`;
        delete types.null;
        delete types.array;
        delete types.object;
      } else {
        cond = codegen_1$n.nil;
      }
      if (types.number) delete types.integer;
      for (const t in types) cond = (0, codegen_1$n.and)(cond, checkDataType(t, data, strictNums, correct));
      return cond;
    }
    dataType.checkDataTypes = checkDataTypes;
    const typeError = {
      message: ({
        schema
      }) => `must be ${schema}`,
      params: ({
        schema,
        schemaValue
      }) => typeof schema == "string" ? (0, codegen_1$n._)`{type: ${schema}}` : (0, codegen_1$n._)`{type: ${schemaValue}}`
    };
    function reportTypeError(it) {
      const cxt = getTypeErrorContext(it);
      (0, errors_1.reportError)(cxt, typeError);
    }
    dataType.reportTypeError = reportTypeError;
    function getTypeErrorContext(it) {
      const {
        gen,
        data,
        schema
      } = it;
      const schemaCode = (0, util_1$m.schemaRefOrVal)(it, schema, "type");
      return {
        gen,
        keyword: "type",
        data,
        schema: schema.type,
        schemaCode,
        schemaValue: schemaCode,
        parentSchema: schema,
        params: {},
        it
      };
    }

    var defaults = {};

    var hasRequiredDefaults;
    function requireDefaults() {
      if (hasRequiredDefaults) return defaults;
      hasRequiredDefaults = 1;
      Object.defineProperty(defaults, "__esModule", {
        value: true
      });
      defaults.assignDefaults = void 0;
      const codegen_1 = /*@__PURE__*/requireCodegen();
      const util_1 = util;
      function assignDefaults(it, ty) {
        const {
          properties,
          items
        } = it.schema;
        if (ty === "object" && properties) {
          for (const key in properties) {
            assignDefault(it, key, properties[key].default);
          }
        } else if (ty === "array" && Array.isArray(items)) {
          items.forEach((sch, i) => assignDefault(it, i, sch.default));
        }
      }
      defaults.assignDefaults = assignDefaults;
      function assignDefault(it, prop, defaultValue) {
        const {
          gen,
          compositeRule,
          data,
          opts
        } = it;
        if (defaultValue === undefined) return;
        const childData = (0, codegen_1._)`${data}${(0, codegen_1.getProperty)(prop)}`;
        if (compositeRule) {
          (0, util_1.checkStrictMode)(it, `default is ignored for: ${childData}`);
          return;
        }
        let condition = (0, codegen_1._)`${childData} === undefined`;
        if (opts.useDefaults === "empty") {
          condition = (0, codegen_1._)`${condition} || ${childData} === null || ${childData} === ""`;
        }
        // `${childData} === undefined` +
        // (opts.useDefaults === "empty" ? ` || ${childData} === null || ${childData} === ""` : "")
        gen.if(condition, (0, codegen_1._)`${childData} = ${(0, codegen_1.stringify)(defaultValue)}`);
      }
      return defaults;
    }

    var keyword = {};

    var code = {};

    var hasRequiredCode;
    function requireCode() {
      if (hasRequiredCode) return code;
      hasRequiredCode = 1;
      Object.defineProperty(code, "__esModule", {
        value: true
      });
      code.validateUnion = code.validateArray = code.usePattern = code.callValidateCode = code.schemaProperties = code.allSchemaProperties = code.noPropertyInData = code.propertyInData = code.isOwnProperty = code.hasPropFunc = code.reportMissingProp = code.checkMissingProp = code.checkReportMissingProp = void 0;
      const codegen_1 = /*@__PURE__*/requireCodegen();
      const util_1 = util;
      const names_1 = /*@__PURE__*/requireNames();
      const util_2 = util;
      function checkReportMissingProp(cxt, prop) {
        const {
          gen,
          data,
          it
        } = cxt;
        gen.if(noPropertyInData(gen, data, prop, it.opts.ownProperties), () => {
          cxt.setParams({
            missingProperty: (0, codegen_1._)`${prop}`
          }, true);
          cxt.error();
        });
      }
      code.checkReportMissingProp = checkReportMissingProp;
      function checkMissingProp({
        gen,
        data,
        it: {
          opts
        }
      }, properties, missing) {
        return (0, codegen_1.or)(...properties.map(prop => (0, codegen_1.and)(noPropertyInData(gen, data, prop, opts.ownProperties), (0, codegen_1._)`${missing} = ${prop}`)));
      }
      code.checkMissingProp = checkMissingProp;
      function reportMissingProp(cxt, missing) {
        cxt.setParams({
          missingProperty: missing
        }, true);
        cxt.error();
      }
      code.reportMissingProp = reportMissingProp;
      function hasPropFunc(gen) {
        return gen.scopeValue("func", {
          // eslint-disable-next-line @typescript-eslint/unbound-method
          ref: Object.prototype.hasOwnProperty,
          code: (0, codegen_1._)`Object.prototype.hasOwnProperty`
        });
      }
      code.hasPropFunc = hasPropFunc;
      function isOwnProperty(gen, data, property) {
        return (0, codegen_1._)`${hasPropFunc(gen)}.call(${data}, ${property})`;
      }
      code.isOwnProperty = isOwnProperty;
      function propertyInData(gen, data, property, ownProperties) {
        const cond = (0, codegen_1._)`${data}${(0, codegen_1.getProperty)(property)} !== undefined`;
        return ownProperties ? (0, codegen_1._)`${cond} && ${isOwnProperty(gen, data, property)}` : cond;
      }
      code.propertyInData = propertyInData;
      function noPropertyInData(gen, data, property, ownProperties) {
        const cond = (0, codegen_1._)`${data}${(0, codegen_1.getProperty)(property)} === undefined`;
        return ownProperties ? (0, codegen_1.or)(cond, (0, codegen_1.not)(isOwnProperty(gen, data, property))) : cond;
      }
      code.noPropertyInData = noPropertyInData;
      function allSchemaProperties(schemaMap) {
        return schemaMap ? Object.keys(schemaMap).filter(p => p !== "__proto__") : [];
      }
      code.allSchemaProperties = allSchemaProperties;
      function schemaProperties(it, schemaMap) {
        return allSchemaProperties(schemaMap).filter(p => !(0, util_1.alwaysValidSchema)(it, schemaMap[p]));
      }
      code.schemaProperties = schemaProperties;
      function callValidateCode({
        schemaCode,
        data,
        it: {
          gen,
          topSchemaRef,
          schemaPath,
          errorPath
        },
        it
      }, func, context, passSchema) {
        const dataAndSchema = passSchema ? (0, codegen_1._)`${schemaCode}, ${data}, ${topSchemaRef}${schemaPath}` : data;
        const valCxt = [[names_1.default.instancePath, (0, codegen_1.strConcat)(names_1.default.instancePath, errorPath)], [names_1.default.parentData, it.parentData], [names_1.default.parentDataProperty, it.parentDataProperty], [names_1.default.rootData, names_1.default.rootData]];
        if (it.opts.dynamicRef) valCxt.push([names_1.default.dynamicAnchors, names_1.default.dynamicAnchors]);
        const args = (0, codegen_1._)`${dataAndSchema}, ${gen.object(...valCxt)}`;
        return context !== codegen_1.nil ? (0, codegen_1._)`${func}.call(${context}, ${args})` : (0, codegen_1._)`${func}(${args})`;
      }
      code.callValidateCode = callValidateCode;
      const newRegExp = (0, codegen_1._)`new RegExp`;
      function usePattern({
        gen,
        it: {
          opts
        }
      }, pattern) {
        const u = opts.unicodeRegExp ? "u" : "";
        const {
          regExp
        } = opts.code;
        const rx = regExp(pattern, u);
        return gen.scopeValue("pattern", {
          key: rx.toString(),
          ref: rx,
          code: (0, codegen_1._)`${regExp.code === "new RegExp" ? newRegExp : (0, util_2.useFunc)(gen, regExp)}(${pattern}, ${u})`
        });
      }
      code.usePattern = usePattern;
      function validateArray(cxt) {
        const {
          gen,
          data,
          keyword,
          it
        } = cxt;
        const valid = gen.name("valid");
        if (it.allErrors) {
          const validArr = gen.let("valid", true);
          validateItems(() => gen.assign(validArr, false));
          return validArr;
        }
        gen.var(valid, true);
        validateItems(() => gen.break());
        return valid;
        function validateItems(notValid) {
          const len = gen.const("len", (0, codegen_1._)`${data}.length`);
          gen.forRange("i", 0, len, i => {
            cxt.subschema({
              keyword,
              dataProp: i,
              dataPropType: util_1.Type.Num
            }, valid);
            gen.if((0, codegen_1.not)(valid), notValid);
          });
        }
      }
      code.validateArray = validateArray;
      function validateUnion(cxt) {
        const {
          gen,
          schema,
          keyword,
          it
        } = cxt;
        /* istanbul ignore if */
        if (!Array.isArray(schema)) throw new Error("ajv implementation error");
        const alwaysValid = schema.some(sch => (0, util_1.alwaysValidSchema)(it, sch));
        if (alwaysValid && !it.opts.unevaluated) return;
        const valid = gen.let("valid", false);
        const schValid = gen.name("_valid");
        gen.block(() => schema.forEach((_sch, i) => {
          const schCxt = cxt.subschema({
            keyword,
            schemaProp: i,
            compositeRule: true
          }, schValid);
          gen.assign(valid, (0, codegen_1._)`${valid} || ${schValid}`);
          const merged = cxt.mergeValidEvaluated(schCxt, schValid);
          // can short-circuit if `unevaluatedProperties/Items` not supported (opts.unevaluated !== true)
          // or if all properties and items were evaluated (it.props === true && it.items === true)
          if (!merged) gen.if((0, codegen_1.not)(valid));
        }));
        cxt.result(valid, () => cxt.reset(), () => cxt.error(true));
      }
      code.validateUnion = validateUnion;
      return code;
    }

    var hasRequiredKeyword;
    function requireKeyword() {
      if (hasRequiredKeyword) return keyword;
      hasRequiredKeyword = 1;
      Object.defineProperty(keyword, "__esModule", {
        value: true
      });
      keyword.validateKeywordUsage = keyword.validSchemaType = keyword.funcKeywordCode = keyword.macroKeywordCode = void 0;
      const codegen_1 = /*@__PURE__*/requireCodegen();
      const names_1 = /*@__PURE__*/requireNames();
      const code_1 = /*@__PURE__*/requireCode();
      const errors_1 = /*@__PURE__*/requireErrors();
      function macroKeywordCode(cxt, def) {
        const {
          gen,
          keyword,
          schema,
          parentSchema,
          it
        } = cxt;
        const macroSchema = def.macro.call(it.self, schema, parentSchema, it);
        const schemaRef = useKeyword(gen, keyword, macroSchema);
        if (it.opts.validateSchema !== false) it.self.validateSchema(macroSchema, true);
        const valid = gen.name("valid");
        cxt.subschema({
          schema: macroSchema,
          schemaPath: codegen_1.nil,
          errSchemaPath: `${it.errSchemaPath}/${keyword}`,
          topSchemaRef: schemaRef,
          compositeRule: true
        }, valid);
        cxt.pass(valid, () => cxt.error(true));
      }
      keyword.macroKeywordCode = macroKeywordCode;
      function funcKeywordCode(cxt, def) {
        var _a;
        const {
          gen,
          keyword,
          schema,
          parentSchema,
          $data,
          it
        } = cxt;
        checkAsyncKeyword(it, def);
        const validate = !$data && def.compile ? def.compile.call(it.self, schema, parentSchema, it) : def.validate;
        const validateRef = useKeyword(gen, keyword, validate);
        const valid = gen.let("valid");
        cxt.block$data(valid, validateKeyword);
        cxt.ok((_a = def.valid) !== null && _a !== void 0 ? _a : valid);
        function validateKeyword() {
          if (def.errors === false) {
            assignValid();
            if (def.modifying) modifyData(cxt);
            reportErrs(() => cxt.error());
          } else {
            const ruleErrs = def.async ? validateAsync() : validateSync();
            if (def.modifying) modifyData(cxt);
            reportErrs(() => addErrs(cxt, ruleErrs));
          }
        }
        function validateAsync() {
          const ruleErrs = gen.let("ruleErrs", null);
          gen.try(() => assignValid((0, codegen_1._)`await `), e => gen.assign(valid, false).if((0, codegen_1._)`${e} instanceof ${it.ValidationError}`, () => gen.assign(ruleErrs, (0, codegen_1._)`${e}.errors`), () => gen.throw(e)));
          return ruleErrs;
        }
        function validateSync() {
          const validateErrs = (0, codegen_1._)`${validateRef}.errors`;
          gen.assign(validateErrs, null);
          assignValid(codegen_1.nil);
          return validateErrs;
        }
        function assignValid(_await = def.async ? (0, codegen_1._)`await ` : codegen_1.nil) {
          const passCxt = it.opts.passContext ? names_1.default.this : names_1.default.self;
          const passSchema = !("compile" in def && !$data || def.schema === false);
          gen.assign(valid, (0, codegen_1._)`${_await}${(0, code_1.callValidateCode)(cxt, validateRef, passCxt, passSchema)}`, def.modifying);
        }
        function reportErrs(errors) {
          var _a;
          gen.if((0, codegen_1.not)((_a = def.valid) !== null && _a !== void 0 ? _a : valid), errors);
        }
      }
      keyword.funcKeywordCode = funcKeywordCode;
      function modifyData(cxt) {
        const {
          gen,
          data,
          it
        } = cxt;
        gen.if(it.parentData, () => gen.assign(data, (0, codegen_1._)`${it.parentData}[${it.parentDataProperty}]`));
      }
      function addErrs(cxt, errs) {
        const {
          gen
        } = cxt;
        gen.if((0, codegen_1._)`Array.isArray(${errs})`, () => {
          gen.assign(names_1.default.vErrors, (0, codegen_1._)`${names_1.default.vErrors} === null ? ${errs} : ${names_1.default.vErrors}.concat(${errs})`).assign(names_1.default.errors, (0, codegen_1._)`${names_1.default.vErrors}.length`);
          (0, errors_1.extendErrors)(cxt);
        }, () => cxt.error());
      }
      function checkAsyncKeyword({
        schemaEnv
      }, def) {
        if (def.async && !schemaEnv.$async) throw new Error("async keyword in sync schema");
      }
      function useKeyword(gen, keyword, result) {
        if (result === undefined) throw new Error(`keyword "${keyword}" failed to compile`);
        return gen.scopeValue("keyword", typeof result == "function" ? {
          ref: result
        } : {
          ref: result,
          code: (0, codegen_1.stringify)(result)
        });
      }
      function validSchemaType(schema, schemaType, allowUndefined = false) {
        // TODO add tests
        return !schemaType.length || schemaType.some(st => st === "array" ? Array.isArray(schema) : st === "object" ? schema && typeof schema == "object" && !Array.isArray(schema) : typeof schema == st || allowUndefined && typeof schema == "undefined");
      }
      keyword.validSchemaType = validSchemaType;
      function validateKeywordUsage({
        schema,
        opts,
        self,
        errSchemaPath
      }, def, keyword) {
        /* istanbul ignore if */
        if (Array.isArray(def.keyword) ? !def.keyword.includes(keyword) : def.keyword !== keyword) {
          throw new Error("ajv implementation error");
        }
        const deps = def.dependencies;
        if (deps === null || deps === void 0 ? void 0 : deps.some(kwd => !Object.prototype.hasOwnProperty.call(schema, kwd))) {
          throw new Error(`parent schema must have dependencies of ${keyword}: ${deps.join(",")}`);
        }
        if (def.validateSchema) {
          const valid = def.validateSchema(schema[keyword]);
          if (!valid) {
            const msg = `keyword "${keyword}" value is invalid at path "${errSchemaPath}": ` + self.errorsText(def.validateSchema.errors);
            if (opts.validateSchema === "log") self.logger.error(msg);else throw new Error(msg);
          }
        }
      }
      keyword.validateKeywordUsage = validateKeywordUsage;
      return keyword;
    }

    var subschema = {};

    var hasRequiredSubschema;
    function requireSubschema() {
      if (hasRequiredSubschema) return subschema;
      hasRequiredSubschema = 1;
      Object.defineProperty(subschema, "__esModule", {
        value: true
      });
      subschema.extendSubschemaMode = subschema.extendSubschemaData = subschema.getSubschema = void 0;
      const codegen_1 = /*@__PURE__*/requireCodegen();
      const util_1 = util;
      function getSubschema(it, {
        keyword,
        schemaProp,
        schema,
        schemaPath,
        errSchemaPath,
        topSchemaRef
      }) {
        if (keyword !== undefined && schema !== undefined) {
          throw new Error('both "keyword" and "schema" passed, only one allowed');
        }
        if (keyword !== undefined) {
          const sch = it.schema[keyword];
          return schemaProp === undefined ? {
            schema: sch,
            schemaPath: (0, codegen_1._)`${it.schemaPath}${(0, codegen_1.getProperty)(keyword)}`,
            errSchemaPath: `${it.errSchemaPath}/${keyword}`
          } : {
            schema: sch[schemaProp],
            schemaPath: (0, codegen_1._)`${it.schemaPath}${(0, codegen_1.getProperty)(keyword)}${(0, codegen_1.getProperty)(schemaProp)}`,
            errSchemaPath: `${it.errSchemaPath}/${keyword}/${(0, util_1.escapeFragment)(schemaProp)}`
          };
        }
        if (schema !== undefined) {
          if (schemaPath === undefined || errSchemaPath === undefined || topSchemaRef === undefined) {
            throw new Error('"schemaPath", "errSchemaPath" and "topSchemaRef" are required with "schema"');
          }
          return {
            schema,
            schemaPath,
            topSchemaRef,
            errSchemaPath
          };
        }
        throw new Error('either "keyword" or "schema" must be passed');
      }
      subschema.getSubschema = getSubschema;
      function extendSubschemaData(subschema, it, {
        dataProp,
        dataPropType: dpType,
        data,
        dataTypes,
        propertyName
      }) {
        if (data !== undefined && dataProp !== undefined) {
          throw new Error('both "data" and "dataProp" passed, only one allowed');
        }
        const {
          gen
        } = it;
        if (dataProp !== undefined) {
          const {
            errorPath,
            dataPathArr,
            opts
          } = it;
          const nextData = gen.let("data", (0, codegen_1._)`${it.data}${(0, codegen_1.getProperty)(dataProp)}`, true);
          dataContextProps(nextData);
          subschema.errorPath = (0, codegen_1.str)`${errorPath}${(0, util_1.getErrorPath)(dataProp, dpType, opts.jsPropertySyntax)}`;
          subschema.parentDataProperty = (0, codegen_1._)`${dataProp}`;
          subschema.dataPathArr = [...dataPathArr, subschema.parentDataProperty];
        }
        if (data !== undefined) {
          const nextData = data instanceof codegen_1.Name ? data : gen.let("data", data, true); // replaceable if used once?
          dataContextProps(nextData);
          if (propertyName !== undefined) subschema.propertyName = propertyName;
          // TODO something is possibly wrong here with not changing parentDataProperty and not appending dataPathArr
        }
        if (dataTypes) subschema.dataTypes = dataTypes;
        function dataContextProps(_nextData) {
          subschema.data = _nextData;
          subschema.dataLevel = it.dataLevel + 1;
          subschema.dataTypes = [];
          it.definedProperties = new Set();
          subschema.parentData = it.data;
          subschema.dataNames = [...it.dataNames, _nextData];
        }
      }
      subschema.extendSubschemaData = extendSubschemaData;
      function extendSubschemaMode(subschema, {
        jtdDiscriminator,
        jtdMetadata,
        compositeRule,
        createErrors,
        allErrors
      }) {
        if (compositeRule !== undefined) subschema.compositeRule = compositeRule;
        if (createErrors !== undefined) subschema.createErrors = createErrors;
        if (allErrors !== undefined) subschema.allErrors = allErrors;
        subschema.jtdDiscriminator = jtdDiscriminator; // not inherited
        subschema.jtdMetadata = jtdMetadata; // not inherited
      }
      subschema.extendSubschemaMode = extendSubschemaMode;
      return subschema;
    }

    var resolve$2 = {};

    // do not edit .js files directly - edit src/index.jst

    var fastDeepEqual = function equal(a, b) {
      if (a === b) return true;
      if (a && b && typeof a == 'object' && typeof b == 'object') {
        if (a.constructor !== b.constructor) return false;
        var length, i, keys;
        if (Array.isArray(a)) {
          length = a.length;
          if (length != b.length) return false;
          for (i = length; i-- !== 0;) if (!equal(a[i], b[i])) return false;
          return true;
        }
        if (a.constructor === RegExp) return a.source === b.source && a.flags === b.flags;
        if (a.valueOf !== Object.prototype.valueOf) return a.valueOf() === b.valueOf();
        if (a.toString !== Object.prototype.toString) return a.toString() === b.toString();
        keys = Object.keys(a);
        length = keys.length;
        if (length !== Object.keys(b).length) return false;
        for (i = length; i-- !== 0;) if (!Object.prototype.hasOwnProperty.call(b, keys[i])) return false;
        for (i = length; i-- !== 0;) {
          var key = keys[i];
          if (!equal(a[key], b[key])) return false;
        }
        return true;
      }

      // true if both NaN, false otherwise
      return a !== a && b !== b;
    };

    var jsonSchemaTraverse = {exports: {}};

    var traverse$1 = jsonSchemaTraverse.exports = function (schema, opts, cb) {
      // Legacy support for v0.3.1 and earlier.
      if (typeof opts == 'function') {
        cb = opts;
        opts = {};
      }
      cb = opts.cb || cb;
      var pre = typeof cb == 'function' ? cb : cb.pre || function () {};
      var post = cb.post || function () {};
      _traverse(opts, pre, post, schema, '', schema);
    };
    traverse$1.keywords = {
      additionalItems: true,
      items: true,
      contains: true,
      additionalProperties: true,
      propertyNames: true,
      not: true,
      if: true,
      then: true,
      else: true
    };
    traverse$1.arrayKeywords = {
      items: true,
      allOf: true,
      anyOf: true,
      oneOf: true
    };
    traverse$1.propsKeywords = {
      $defs: true,
      definitions: true,
      properties: true,
      patternProperties: true,
      dependencies: true
    };
    traverse$1.skipKeywords = {
      default: true,
      enum: true,
      const: true,
      required: true,
      maximum: true,
      minimum: true,
      exclusiveMaximum: true,
      exclusiveMinimum: true,
      multipleOf: true,
      maxLength: true,
      minLength: true,
      pattern: true,
      format: true,
      maxItems: true,
      minItems: true,
      uniqueItems: true,
      maxProperties: true,
      minProperties: true
    };
    function _traverse(opts, pre, post, schema, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex) {
      if (schema && typeof schema == 'object' && !Array.isArray(schema)) {
        pre(schema, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex);
        for (var key in schema) {
          var sch = schema[key];
          if (Array.isArray(sch)) {
            if (key in traverse$1.arrayKeywords) {
              for (var i = 0; i < sch.length; i++) _traverse(opts, pre, post, sch[i], jsonPtr + '/' + key + '/' + i, rootSchema, jsonPtr, key, schema, i);
            }
          } else if (key in traverse$1.propsKeywords) {
            if (sch && typeof sch == 'object') {
              for (var prop in sch) _traverse(opts, pre, post, sch[prop], jsonPtr + '/' + key + '/' + escapeJsonPtr(prop), rootSchema, jsonPtr, key, schema, prop);
            }
          } else if (key in traverse$1.keywords || opts.allKeys && !(key in traverse$1.skipKeywords)) {
            _traverse(opts, pre, post, sch, jsonPtr + '/' + key, rootSchema, jsonPtr, key, schema);
          }
        }
        post(schema, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex);
      }
    }
    function escapeJsonPtr(str) {
      return str.replace(/~/g, '~0').replace(/\//g, '~1');
    }
    var jsonSchemaTraverseExports = jsonSchemaTraverse.exports;

    Object.defineProperty(resolve$2, "__esModule", {
      value: true
    });
    resolve$2.getSchemaRefs = resolve$2.resolveUrl = resolve$2.normalizeId = resolve$2._getFullPath = resolve$2.getFullPath = resolve$2.inlineRef = void 0;
    const util_1$l = util;
    const equal$3 = fastDeepEqual;
    const traverse = jsonSchemaTraverseExports;
    // TODO refactor to use keyword definitions
    const SIMPLE_INLINED = new Set(["type", "format", "pattern", "maxLength", "minLength", "maxProperties", "minProperties", "maxItems", "minItems", "maximum", "minimum", "uniqueItems", "multipleOf", "required", "enum", "const"]);
    function inlineRef(schema, limit = true) {
      if (typeof schema == "boolean") return true;
      if (limit === true) return !hasRef(schema);
      if (!limit) return false;
      return countKeys(schema) <= limit;
    }
    resolve$2.inlineRef = inlineRef;
    const REF_KEYWORDS = new Set(["$ref", "$recursiveRef", "$recursiveAnchor", "$dynamicRef", "$dynamicAnchor"]);
    function hasRef(schema) {
      for (const key in schema) {
        if (REF_KEYWORDS.has(key)) return true;
        const sch = schema[key];
        if (Array.isArray(sch) && sch.some(hasRef)) return true;
        if (typeof sch == "object" && hasRef(sch)) return true;
      }
      return false;
    }
    function countKeys(schema) {
      let count = 0;
      for (const key in schema) {
        if (key === "$ref") return Infinity;
        count++;
        if (SIMPLE_INLINED.has(key)) continue;
        if (typeof schema[key] == "object") {
          (0, util_1$l.eachItem)(schema[key], sch => count += countKeys(sch));
        }
        if (count === Infinity) return Infinity;
      }
      return count;
    }
    function getFullPath(resolver, id = "", normalize) {
      if (normalize !== false) id = normalizeId(id);
      const p = resolver.parse(id);
      return _getFullPath(resolver, p);
    }
    resolve$2.getFullPath = getFullPath;
    function _getFullPath(resolver, p) {
      const serialized = resolver.serialize(p);
      return serialized.split("#")[0] + "#";
    }
    resolve$2._getFullPath = _getFullPath;
    const TRAILING_SLASH_HASH = /#\/?$/;
    function normalizeId(id) {
      return id ? id.replace(TRAILING_SLASH_HASH, "") : "";
    }
    resolve$2.normalizeId = normalizeId;
    function resolveUrl(resolver, baseId, id) {
      id = normalizeId(id);
      return resolver.resolve(baseId, id);
    }
    resolve$2.resolveUrl = resolveUrl;
    const ANCHOR = /^[a-z_][-a-z0-9._]*$/i;
    function getSchemaRefs(schema, baseId) {
      if (typeof schema == "boolean") return {};
      const {
        schemaId,
        uriResolver
      } = this.opts;
      const schId = normalizeId(schema[schemaId] || baseId);
      const baseIds = {
        "": schId
      };
      const pathPrefix = getFullPath(uriResolver, schId, false);
      const localRefs = {};
      const schemaRefs = new Set();
      traverse(schema, {
        allKeys: true
      }, (sch, jsonPtr, _, parentJsonPtr) => {
        if (parentJsonPtr === undefined) return;
        const fullPath = pathPrefix + jsonPtr;
        let innerBaseId = baseIds[parentJsonPtr];
        if (typeof sch[schemaId] == "string") innerBaseId = addRef.call(this, sch[schemaId]);
        addAnchor.call(this, sch.$anchor);
        addAnchor.call(this, sch.$dynamicAnchor);
        baseIds[jsonPtr] = innerBaseId;
        function addRef(ref) {
          // eslint-disable-next-line @typescript-eslint/unbound-method
          const _resolve = this.opts.uriResolver.resolve;
          ref = normalizeId(innerBaseId ? _resolve(innerBaseId, ref) : ref);
          if (schemaRefs.has(ref)) throw ambiguos(ref);
          schemaRefs.add(ref);
          let schOrRef = this.refs[ref];
          if (typeof schOrRef == "string") schOrRef = this.refs[schOrRef];
          if (typeof schOrRef == "object") {
            checkAmbiguosRef(sch, schOrRef.schema, ref);
          } else if (ref !== normalizeId(fullPath)) {
            if (ref[0] === "#") {
              checkAmbiguosRef(sch, localRefs[ref], ref);
              localRefs[ref] = sch;
            } else {
              this.refs[ref] = fullPath;
            }
          }
          return ref;
        }
        function addAnchor(anchor) {
          if (typeof anchor == "string") {
            if (!ANCHOR.test(anchor)) throw new Error(`invalid anchor "${anchor}"`);
            addRef.call(this, `#${anchor}`);
          }
        }
      });
      return localRefs;
      function checkAmbiguosRef(sch1, sch2, ref) {
        if (sch2 !== undefined && !equal$3(sch1, sch2)) throw ambiguos(ref);
      }
      function ambiguos(ref) {
        return new Error(`reference "${ref}" resolves to more than one schema`);
      }
    }
    resolve$2.getSchemaRefs = getSchemaRefs;

    var hasRequiredValidate;
    function requireValidate() {
      if (hasRequiredValidate) return validate;
      hasRequiredValidate = 1;
      Object.defineProperty(validate, "__esModule", {
        value: true
      });
      validate.getData = validate.KeywordCxt = validate.validateFunctionCode = void 0;
      const boolSchema_1 = /*@__PURE__*/requireBoolSchema();
      const dataType_1 = dataType;
      const applicability_1 = /*@__PURE__*/requireApplicability();
      const dataType_2 = dataType;
      const defaults_1 = /*@__PURE__*/requireDefaults();
      const keyword_1 = /*@__PURE__*/requireKeyword();
      const subschema_1 = /*@__PURE__*/requireSubschema();
      const codegen_1 = /*@__PURE__*/requireCodegen();
      const names_1 = /*@__PURE__*/requireNames();
      const resolve_1 = resolve$2;
      const util_1 = util;
      const errors_1 = /*@__PURE__*/requireErrors();
      // schema compilation - generates validation function, subschemaCode (below) is used for subschemas
      function validateFunctionCode(it) {
        if (isSchemaObj(it)) {
          checkKeywords(it);
          if (schemaCxtHasRules(it)) {
            topSchemaObjCode(it);
            return;
          }
        }
        validateFunction(it, () => (0, boolSchema_1.topBoolOrEmptySchema)(it));
      }
      validate.validateFunctionCode = validateFunctionCode;
      function validateFunction({
        gen,
        validateName,
        schema,
        schemaEnv,
        opts
      }, body) {
        if (opts.code.es5) {
          gen.func(validateName, (0, codegen_1._)`${names_1.default.data}, ${names_1.default.valCxt}`, schemaEnv.$async, () => {
            gen.code((0, codegen_1._)`"use strict"; ${funcSourceUrl(schema, opts)}`);
            destructureValCxtES5(gen, opts);
            gen.code(body);
          });
        } else {
          gen.func(validateName, (0, codegen_1._)`${names_1.default.data}, ${destructureValCxt(opts)}`, schemaEnv.$async, () => gen.code(funcSourceUrl(schema, opts)).code(body));
        }
      }
      function destructureValCxt(opts) {
        return (0, codegen_1._)`{${names_1.default.instancePath}="", ${names_1.default.parentData}, ${names_1.default.parentDataProperty}, ${names_1.default.rootData}=${names_1.default.data}${opts.dynamicRef ? (0, codegen_1._)`, ${names_1.default.dynamicAnchors}={}` : codegen_1.nil}}={}`;
      }
      function destructureValCxtES5(gen, opts) {
        gen.if(names_1.default.valCxt, () => {
          gen.var(names_1.default.instancePath, (0, codegen_1._)`${names_1.default.valCxt}.${names_1.default.instancePath}`);
          gen.var(names_1.default.parentData, (0, codegen_1._)`${names_1.default.valCxt}.${names_1.default.parentData}`);
          gen.var(names_1.default.parentDataProperty, (0, codegen_1._)`${names_1.default.valCxt}.${names_1.default.parentDataProperty}`);
          gen.var(names_1.default.rootData, (0, codegen_1._)`${names_1.default.valCxt}.${names_1.default.rootData}`);
          if (opts.dynamicRef) gen.var(names_1.default.dynamicAnchors, (0, codegen_1._)`${names_1.default.valCxt}.${names_1.default.dynamicAnchors}`);
        }, () => {
          gen.var(names_1.default.instancePath, (0, codegen_1._)`""`);
          gen.var(names_1.default.parentData, (0, codegen_1._)`undefined`);
          gen.var(names_1.default.parentDataProperty, (0, codegen_1._)`undefined`);
          gen.var(names_1.default.rootData, names_1.default.data);
          if (opts.dynamicRef) gen.var(names_1.default.dynamicAnchors, (0, codegen_1._)`{}`);
        });
      }
      function topSchemaObjCode(it) {
        const {
          schema,
          opts,
          gen
        } = it;
        validateFunction(it, () => {
          if (opts.$comment && schema.$comment) commentKeyword(it);
          checkNoDefault(it);
          gen.let(names_1.default.vErrors, null);
          gen.let(names_1.default.errors, 0);
          if (opts.unevaluated) resetEvaluated(it);
          typeAndKeywords(it);
          returnResults(it);
        });
        return;
      }
      function resetEvaluated(it) {
        // TODO maybe some hook to execute it in the end to check whether props/items are Name, as in assignEvaluated
        const {
          gen,
          validateName
        } = it;
        it.evaluated = gen.const("evaluated", (0, codegen_1._)`${validateName}.evaluated`);
        gen.if((0, codegen_1._)`${it.evaluated}.dynamicProps`, () => gen.assign((0, codegen_1._)`${it.evaluated}.props`, (0, codegen_1._)`undefined`));
        gen.if((0, codegen_1._)`${it.evaluated}.dynamicItems`, () => gen.assign((0, codegen_1._)`${it.evaluated}.items`, (0, codegen_1._)`undefined`));
      }
      function funcSourceUrl(schema, opts) {
        const schId = typeof schema == "object" && schema[opts.schemaId];
        return schId && (opts.code.source || opts.code.process) ? (0, codegen_1._)`/*# sourceURL=${schId} */` : codegen_1.nil;
      }
      // schema compilation - this function is used recursively to generate code for sub-schemas
      function subschemaCode(it, valid) {
        if (isSchemaObj(it)) {
          checkKeywords(it);
          if (schemaCxtHasRules(it)) {
            subSchemaObjCode(it, valid);
            return;
          }
        }
        (0, boolSchema_1.boolOrEmptySchema)(it, valid);
      }
      function schemaCxtHasRules({
        schema,
        self
      }) {
        if (typeof schema == "boolean") return !schema;
        for (const key in schema) if (self.RULES.all[key]) return true;
        return false;
      }
      function isSchemaObj(it) {
        return typeof it.schema != "boolean";
      }
      function subSchemaObjCode(it, valid) {
        const {
          schema,
          gen,
          opts
        } = it;
        if (opts.$comment && schema.$comment) commentKeyword(it);
        updateContext(it);
        checkAsyncSchema(it);
        const errsCount = gen.const("_errs", names_1.default.errors);
        typeAndKeywords(it, errsCount);
        // TODO var
        gen.var(valid, (0, codegen_1._)`${errsCount} === ${names_1.default.errors}`);
      }
      function checkKeywords(it) {
        (0, util_1.checkUnknownRules)(it);
        checkRefsAndKeywords(it);
      }
      function typeAndKeywords(it, errsCount) {
        if (it.opts.jtd) return schemaKeywords(it, [], false, errsCount);
        const types = (0, dataType_1.getSchemaTypes)(it.schema);
        const checkedTypes = (0, dataType_1.coerceAndCheckDataType)(it, types);
        schemaKeywords(it, types, !checkedTypes, errsCount);
      }
      function checkRefsAndKeywords(it) {
        const {
          schema,
          errSchemaPath,
          opts,
          self
        } = it;
        if (schema.$ref && opts.ignoreKeywordsWithRef && (0, util_1.schemaHasRulesButRef)(schema, self.RULES)) {
          self.logger.warn(`$ref: keywords ignored in schema at path "${errSchemaPath}"`);
        }
      }
      function checkNoDefault(it) {
        const {
          schema,
          opts
        } = it;
        if (schema.default !== undefined && opts.useDefaults && opts.strictSchema) {
          (0, util_1.checkStrictMode)(it, "default is ignored in the schema root");
        }
      }
      function updateContext(it) {
        const schId = it.schema[it.opts.schemaId];
        if (schId) it.baseId = (0, resolve_1.resolveUrl)(it.opts.uriResolver, it.baseId, schId);
      }
      function checkAsyncSchema(it) {
        if (it.schema.$async && !it.schemaEnv.$async) throw new Error("async schema in sync schema");
      }
      function commentKeyword({
        gen,
        schemaEnv,
        schema,
        errSchemaPath,
        opts
      }) {
        const msg = schema.$comment;
        if (opts.$comment === true) {
          gen.code((0, codegen_1._)`${names_1.default.self}.logger.log(${msg})`);
        } else if (typeof opts.$comment == "function") {
          const schemaPath = (0, codegen_1.str)`${errSchemaPath}/$comment`;
          const rootName = gen.scopeValue("root", {
            ref: schemaEnv.root
          });
          gen.code((0, codegen_1._)`${names_1.default.self}.opts.$comment(${msg}, ${schemaPath}, ${rootName}.schema)`);
        }
      }
      function returnResults(it) {
        const {
          gen,
          schemaEnv,
          validateName,
          ValidationError,
          opts
        } = it;
        if (schemaEnv.$async) {
          // TODO assign unevaluated
          gen.if((0, codegen_1._)`${names_1.default.errors} === 0`, () => gen.return(names_1.default.data), () => gen.throw((0, codegen_1._)`new ${ValidationError}(${names_1.default.vErrors})`));
        } else {
          gen.assign((0, codegen_1._)`${validateName}.errors`, names_1.default.vErrors);
          if (opts.unevaluated) assignEvaluated(it);
          gen.return((0, codegen_1._)`${names_1.default.errors} === 0`);
        }
      }
      function assignEvaluated({
        gen,
        evaluated,
        props,
        items
      }) {
        if (props instanceof codegen_1.Name) gen.assign((0, codegen_1._)`${evaluated}.props`, props);
        if (items instanceof codegen_1.Name) gen.assign((0, codegen_1._)`${evaluated}.items`, items);
      }
      function schemaKeywords(it, types, typeErrors, errsCount) {
        const {
          gen,
          schema,
          data,
          allErrors,
          opts,
          self
        } = it;
        const {
          RULES
        } = self;
        if (schema.$ref && (opts.ignoreKeywordsWithRef || !(0, util_1.schemaHasRulesButRef)(schema, RULES))) {
          gen.block(() => keywordCode(it, "$ref", RULES.all.$ref.definition)); // TODO typecast
          return;
        }
        if (!opts.jtd) checkStrictTypes(it, types);
        gen.block(() => {
          for (const group of RULES.rules) groupKeywords(group);
          groupKeywords(RULES.post);
        });
        function groupKeywords(group) {
          if (!(0, applicability_1.shouldUseGroup)(schema, group)) return;
          if (group.type) {
            gen.if((0, dataType_2.checkDataType)(group.type, data, opts.strictNumbers));
            iterateKeywords(it, group);
            if (types.length === 1 && types[0] === group.type && typeErrors) {
              gen.else();
              (0, dataType_2.reportTypeError)(it);
            }
            gen.endIf();
          } else {
            iterateKeywords(it, group);
          }
          // TODO make it "ok" call?
          if (!allErrors) gen.if((0, codegen_1._)`${names_1.default.errors} === ${errsCount || 0}`);
        }
      }
      function iterateKeywords(it, group) {
        const {
          gen,
          schema,
          opts: {
            useDefaults
          }
        } = it;
        if (useDefaults) (0, defaults_1.assignDefaults)(it, group.type);
        gen.block(() => {
          for (const rule of group.rules) {
            if ((0, applicability_1.shouldUseRule)(schema, rule)) {
              keywordCode(it, rule.keyword, rule.definition, group.type);
            }
          }
        });
      }
      function checkStrictTypes(it, types) {
        if (it.schemaEnv.meta || !it.opts.strictTypes) return;
        checkContextTypes(it, types);
        if (!it.opts.allowUnionTypes) checkMultipleTypes(it, types);
        checkKeywordTypes(it, it.dataTypes);
      }
      function checkContextTypes(it, types) {
        if (!types.length) return;
        if (!it.dataTypes.length) {
          it.dataTypes = types;
          return;
        }
        types.forEach(t => {
          if (!includesType(it.dataTypes, t)) {
            strictTypesError(it, `type "${t}" not allowed by context "${it.dataTypes.join(",")}"`);
          }
        });
        narrowSchemaTypes(it, types);
      }
      function checkMultipleTypes(it, ts) {
        if (ts.length > 1 && !(ts.length === 2 && ts.includes("null"))) {
          strictTypesError(it, "use allowUnionTypes to allow union type keyword");
        }
      }
      function checkKeywordTypes(it, ts) {
        const rules = it.self.RULES.all;
        for (const keyword in rules) {
          const rule = rules[keyword];
          if (typeof rule == "object" && (0, applicability_1.shouldUseRule)(it.schema, rule)) {
            const {
              type
            } = rule.definition;
            if (type.length && !type.some(t => hasApplicableType(ts, t))) {
              strictTypesError(it, `missing type "${type.join(",")}" for keyword "${keyword}"`);
            }
          }
        }
      }
      function hasApplicableType(schTs, kwdT) {
        return schTs.includes(kwdT) || kwdT === "number" && schTs.includes("integer");
      }
      function includesType(ts, t) {
        return ts.includes(t) || t === "integer" && ts.includes("number");
      }
      function narrowSchemaTypes(it, withTypes) {
        const ts = [];
        for (const t of it.dataTypes) {
          if (includesType(withTypes, t)) ts.push(t);else if (withTypes.includes("integer") && t === "number") ts.push("integer");
        }
        it.dataTypes = ts;
      }
      function strictTypesError(it, msg) {
        const schemaPath = it.schemaEnv.baseId + it.errSchemaPath;
        msg += ` at "${schemaPath}" (strictTypes)`;
        (0, util_1.checkStrictMode)(it, msg, it.opts.strictTypes);
      }
      class KeywordCxt {
        constructor(it, def, keyword) {
          (0, keyword_1.validateKeywordUsage)(it, def, keyword);
          this.gen = it.gen;
          this.allErrors = it.allErrors;
          this.keyword = keyword;
          this.data = it.data;
          this.schema = it.schema[keyword];
          this.$data = def.$data && it.opts.$data && this.schema && this.schema.$data;
          this.schemaValue = (0, util_1.schemaRefOrVal)(it, this.schema, keyword, this.$data);
          this.schemaType = def.schemaType;
          this.parentSchema = it.schema;
          this.params = {};
          this.it = it;
          this.def = def;
          if (this.$data) {
            this.schemaCode = it.gen.const("vSchema", getData(this.$data, it));
          } else {
            this.schemaCode = this.schemaValue;
            if (!(0, keyword_1.validSchemaType)(this.schema, def.schemaType, def.allowUndefined)) {
              throw new Error(`${keyword} value must be ${JSON.stringify(def.schemaType)}`);
            }
          }
          if ("code" in def ? def.trackErrors : def.errors !== false) {
            this.errsCount = it.gen.const("_errs", names_1.default.errors);
          }
        }
        result(condition, successAction, failAction) {
          this.failResult((0, codegen_1.not)(condition), successAction, failAction);
        }
        failResult(condition, successAction, failAction) {
          this.gen.if(condition);
          if (failAction) failAction();else this.error();
          if (successAction) {
            this.gen.else();
            successAction();
            if (this.allErrors) this.gen.endIf();
          } else {
            if (this.allErrors) this.gen.endIf();else this.gen.else();
          }
        }
        pass(condition, failAction) {
          this.failResult((0, codegen_1.not)(condition), undefined, failAction);
        }
        fail(condition) {
          if (condition === undefined) {
            this.error();
            if (!this.allErrors) this.gen.if(false); // this branch will be removed by gen.optimize
            return;
          }
          this.gen.if(condition);
          this.error();
          if (this.allErrors) this.gen.endIf();else this.gen.else();
        }
        fail$data(condition) {
          if (!this.$data) return this.fail(condition);
          const {
            schemaCode
          } = this;
          this.fail((0, codegen_1._)`${schemaCode} !== undefined && (${(0, codegen_1.or)(this.invalid$data(), condition)})`);
        }
        error(append, errorParams, errorPaths) {
          if (errorParams) {
            this.setParams(errorParams);
            this._error(append, errorPaths);
            this.setParams({});
            return;
          }
          this._error(append, errorPaths);
        }
        _error(append, errorPaths) {
          (append ? errors_1.reportExtraError : errors_1.reportError)(this, this.def.error, errorPaths);
        }
        $dataError() {
          (0, errors_1.reportError)(this, this.def.$dataError || errors_1.keyword$DataError);
        }
        reset() {
          if (this.errsCount === undefined) throw new Error('add "trackErrors" to keyword definition');
          (0, errors_1.resetErrorsCount)(this.gen, this.errsCount);
        }
        ok(cond) {
          if (!this.allErrors) this.gen.if(cond);
        }
        setParams(obj, assign) {
          if (assign) Object.assign(this.params, obj);else this.params = obj;
        }
        block$data(valid, codeBlock, $dataValid = codegen_1.nil) {
          this.gen.block(() => {
            this.check$data(valid, $dataValid);
            codeBlock();
          });
        }
        check$data(valid = codegen_1.nil, $dataValid = codegen_1.nil) {
          if (!this.$data) return;
          const {
            gen,
            schemaCode,
            schemaType,
            def
          } = this;
          gen.if((0, codegen_1.or)((0, codegen_1._)`${schemaCode} === undefined`, $dataValid));
          if (valid !== codegen_1.nil) gen.assign(valid, true);
          if (schemaType.length || def.validateSchema) {
            gen.elseIf(this.invalid$data());
            this.$dataError();
            if (valid !== codegen_1.nil) gen.assign(valid, false);
          }
          gen.else();
        }
        invalid$data() {
          const {
            gen,
            schemaCode,
            schemaType,
            def,
            it
          } = this;
          return (0, codegen_1.or)(wrong$DataType(), invalid$DataSchema());
          function wrong$DataType() {
            if (schemaType.length) {
              /* istanbul ignore if */
              if (!(schemaCode instanceof codegen_1.Name)) throw new Error("ajv implementation error");
              const st = Array.isArray(schemaType) ? schemaType : [schemaType];
              return (0, codegen_1._)`${(0, dataType_2.checkDataTypes)(st, schemaCode, it.opts.strictNumbers, dataType_2.DataType.Wrong)}`;
            }
            return codegen_1.nil;
          }
          function invalid$DataSchema() {
            if (def.validateSchema) {
              const validateSchemaRef = gen.scopeValue("validate$data", {
                ref: def.validateSchema
              }); // TODO value.code for standalone
              return (0, codegen_1._)`!${validateSchemaRef}(${schemaCode})`;
            }
            return codegen_1.nil;
          }
        }
        subschema(appl, valid) {
          const subschema = (0, subschema_1.getSubschema)(this.it, appl);
          (0, subschema_1.extendSubschemaData)(subschema, this.it, appl);
          (0, subschema_1.extendSubschemaMode)(subschema, appl);
          const nextContext = {
            ...this.it,
            ...subschema,
            items: undefined,
            props: undefined
          };
          subschemaCode(nextContext, valid);
          return nextContext;
        }
        mergeEvaluated(schemaCxt, toName) {
          const {
            it,
            gen
          } = this;
          if (!it.opts.unevaluated) return;
          if (it.props !== true && schemaCxt.props !== undefined) {
            it.props = util_1.mergeEvaluated.props(gen, schemaCxt.props, it.props, toName);
          }
          if (it.items !== true && schemaCxt.items !== undefined) {
            it.items = util_1.mergeEvaluated.items(gen, schemaCxt.items, it.items, toName);
          }
        }
        mergeValidEvaluated(schemaCxt, valid) {
          const {
            it,
            gen
          } = this;
          if (it.opts.unevaluated && (it.props !== true || it.items !== true)) {
            gen.if(valid, () => this.mergeEvaluated(schemaCxt, codegen_1.Name));
            return true;
          }
        }
      }
      validate.KeywordCxt = KeywordCxt;
      function keywordCode(it, keyword, def, ruleType) {
        const cxt = new KeywordCxt(it, def, keyword);
        if ("code" in def) {
          def.code(cxt, ruleType);
        } else if (cxt.$data && def.validate) {
          (0, keyword_1.funcKeywordCode)(cxt, def);
        } else if ("macro" in def) {
          (0, keyword_1.macroKeywordCode)(cxt, def);
        } else if (def.compile || def.validate) {
          (0, keyword_1.funcKeywordCode)(cxt, def);
        }
      }
      const JSON_POINTER = /^\/(?:[^~]|~0|~1)*$/;
      const RELATIVE_JSON_POINTER = /^([0-9]+)(#|\/(?:[^~]|~0|~1)*)?$/;
      function getData($data, {
        dataLevel,
        dataNames,
        dataPathArr
      }) {
        let jsonPointer;
        let data;
        if ($data === "") return names_1.default.rootData;
        if ($data[0] === "/") {
          if (!JSON_POINTER.test($data)) throw new Error(`Invalid JSON-pointer: ${$data}`);
          jsonPointer = $data;
          data = names_1.default.rootData;
        } else {
          const matches = RELATIVE_JSON_POINTER.exec($data);
          if (!matches) throw new Error(`Invalid JSON-pointer: ${$data}`);
          const up = +matches[1];
          jsonPointer = matches[2];
          if (jsonPointer === "#") {
            if (up >= dataLevel) throw new Error(errorMsg("property/index", up));
            return dataPathArr[dataLevel - up];
          }
          if (up > dataLevel) throw new Error(errorMsg("data", up));
          data = dataNames[dataLevel - up];
          if (!jsonPointer) return data;
        }
        let expr = data;
        const segments = jsonPointer.split("/");
        for (const segment of segments) {
          if (segment) {
            data = (0, codegen_1._)`${data}${(0, codegen_1.getProperty)((0, util_1.unescapeJsonPointer)(segment))}`;
            expr = (0, codegen_1._)`${expr} && ${data}`;
          }
        }
        return expr;
        function errorMsg(pointerType, up) {
          return `Cannot access ${pointerType} ${up} levels up, current level is ${dataLevel}`;
        }
      }
      validate.getData = getData;
      return validate;
    }

    var validation_error = {};

    var hasRequiredValidation_error;
    function requireValidation_error() {
      if (hasRequiredValidation_error) return validation_error;
      hasRequiredValidation_error = 1;
      Object.defineProperty(validation_error, "__esModule", {
        value: true
      });
      class ValidationError extends Error {
        constructor(errors) {
          super("validation failed");
          this.errors = errors;
          this.ajv = this.validation = true;
        }
      }
      validation_error.default = ValidationError;
      return validation_error;
    }

    var ref_error = {};

    var hasRequiredRef_error;
    function requireRef_error() {
      if (hasRequiredRef_error) return ref_error;
      hasRequiredRef_error = 1;
      Object.defineProperty(ref_error, "__esModule", {
        value: true
      });
      const resolve_1 = resolve$2;
      class MissingRefError extends Error {
        constructor(resolver, baseId, ref, msg) {
          super(msg || `can't resolve reference ${ref} from id ${baseId}`);
          this.missingRef = (0, resolve_1.resolveUrl)(resolver, baseId, ref);
          this.missingSchema = (0, resolve_1.normalizeId)((0, resolve_1.getFullPath)(resolver, this.missingRef));
        }
      }
      ref_error.default = MissingRefError;
      return ref_error;
    }

    var compile = {};

    Object.defineProperty(compile, "__esModule", {
      value: true
    });
    compile.resolveSchema = compile.getCompilingSchema = compile.resolveRef = compile.compileSchema = compile.SchemaEnv = void 0;
    const codegen_1$m = /*@__PURE__*/requireCodegen();
    const validation_error_1 = /*@__PURE__*/requireValidation_error();
    const names_1$2 = /*@__PURE__*/requireNames();
    const resolve_1 = resolve$2;
    const util_1$k = util;
    const validate_1$1 = /*@__PURE__*/requireValidate();
    class SchemaEnv {
      constructor(env) {
        var _a;
        this.refs = {};
        this.dynamicAnchors = {};
        let schema;
        if (typeof env.schema == "object") schema = env.schema;
        this.schema = env.schema;
        this.schemaId = env.schemaId;
        this.root = env.root || this;
        this.baseId = (_a = env.baseId) !== null && _a !== void 0 ? _a : (0, resolve_1.normalizeId)(schema === null || schema === void 0 ? void 0 : schema[env.schemaId || "$id"]);
        this.schemaPath = env.schemaPath;
        this.localRefs = env.localRefs;
        this.meta = env.meta;
        this.$async = schema === null || schema === void 0 ? void 0 : schema.$async;
        this.refs = {};
      }
    }
    compile.SchemaEnv = SchemaEnv;
    // let codeSize = 0
    // let nodeCount = 0
    // Compiles schema in SchemaEnv
    function compileSchema(sch) {
      // TODO refactor - remove compilations
      const _sch = getCompilingSchema.call(this, sch);
      if (_sch) return _sch;
      const rootId = (0, resolve_1.getFullPath)(this.opts.uriResolver, sch.root.baseId); // TODO if getFullPath removed 1 tests fails
      const {
        es5,
        lines
      } = this.opts.code;
      const {
        ownProperties
      } = this.opts;
      const gen = new codegen_1$m.CodeGen(this.scope, {
        es5,
        lines,
        ownProperties
      });
      let _ValidationError;
      if (sch.$async) {
        _ValidationError = gen.scopeValue("Error", {
          ref: validation_error_1.default,
          code: (0, codegen_1$m._)`require("ajv/dist/runtime/validation_error").default`
        });
      }
      const validateName = gen.scopeName("validate");
      sch.validateName = validateName;
      const schemaCxt = {
        gen,
        allErrors: this.opts.allErrors,
        data: names_1$2.default.data,
        parentData: names_1$2.default.parentData,
        parentDataProperty: names_1$2.default.parentDataProperty,
        dataNames: [names_1$2.default.data],
        dataPathArr: [codegen_1$m.nil],
        // TODO can its length be used as dataLevel if nil is removed?
        dataLevel: 0,
        dataTypes: [],
        definedProperties: new Set(),
        topSchemaRef: gen.scopeValue("schema", this.opts.code.source === true ? {
          ref: sch.schema,
          code: (0, codegen_1$m.stringify)(sch.schema)
        } : {
          ref: sch.schema
        }),
        validateName,
        ValidationError: _ValidationError,
        schema: sch.schema,
        schemaEnv: sch,
        rootId,
        baseId: sch.baseId || rootId,
        schemaPath: codegen_1$m.nil,
        errSchemaPath: sch.schemaPath || (this.opts.jtd ? "" : "#"),
        errorPath: (0, codegen_1$m._)`""`,
        opts: this.opts,
        self: this
      };
      let sourceCode;
      try {
        this._compilations.add(sch);
        (0, validate_1$1.validateFunctionCode)(schemaCxt);
        gen.optimize(this.opts.code.optimize);
        // gen.optimize(1)
        const validateCode = gen.toString();
        sourceCode = `${gen.scopeRefs(names_1$2.default.scope)}return ${validateCode}`;
        // console.log((codeSize += sourceCode.length), (nodeCount += gen.nodeCount))
        if (this.opts.code.process) sourceCode = this.opts.code.process(sourceCode, sch);
        // console.log("\n\n\n *** \n", sourceCode)
        const makeValidate = new Function(`${names_1$2.default.self}`, `${names_1$2.default.scope}`, sourceCode);
        const validate = makeValidate(this, this.scope.get());
        this.scope.value(validateName, {
          ref: validate
        });
        validate.errors = null;
        validate.schema = sch.schema;
        validate.schemaEnv = sch;
        if (sch.$async) validate.$async = true;
        if (this.opts.code.source === true) {
          validate.source = {
            validateName,
            validateCode,
            scopeValues: gen._values
          };
        }
        if (this.opts.unevaluated) {
          const {
            props,
            items
          } = schemaCxt;
          validate.evaluated = {
            props: props instanceof codegen_1$m.Name ? undefined : props,
            items: items instanceof codegen_1$m.Name ? undefined : items,
            dynamicProps: props instanceof codegen_1$m.Name,
            dynamicItems: items instanceof codegen_1$m.Name
          };
          if (validate.source) validate.source.evaluated = (0, codegen_1$m.stringify)(validate.evaluated);
        }
        sch.validate = validate;
        return sch;
      } catch (e) {
        delete sch.validate;
        delete sch.validateName;
        if (sourceCode) this.logger.error("Error compiling schema, function code:", sourceCode);
        // console.log("\n\n\n *** \n", sourceCode, this.opts)
        throw e;
      } finally {
        this._compilations.delete(sch);
      }
    }
    compile.compileSchema = compileSchema;
    function resolveRef(root, baseId, ref) {
      var _a;
      ref = (0, resolve_1.resolveUrl)(this.opts.uriResolver, baseId, ref);
      const schOrFunc = root.refs[ref];
      if (schOrFunc) return schOrFunc;
      let _sch = resolve$1.call(this, root, ref);
      if (_sch === undefined) {
        const schema = (_a = root.localRefs) === null || _a === void 0 ? void 0 : _a[ref]; // TODO maybe localRefs should hold SchemaEnv
        const {
          schemaId
        } = this.opts;
        if (schema) _sch = new SchemaEnv({
          schema,
          schemaId,
          root,
          baseId
        });
      }
      if (_sch === undefined) return;
      return root.refs[ref] = inlineOrCompile.call(this, _sch);
    }
    compile.resolveRef = resolveRef;
    function inlineOrCompile(sch) {
      if ((0, resolve_1.inlineRef)(sch.schema, this.opts.inlineRefs)) return sch.schema;
      return sch.validate ? sch : compileSchema.call(this, sch);
    }
    // Index of schema compilation in the currently compiled list
    function getCompilingSchema(schEnv) {
      for (const sch of this._compilations) {
        if (sameSchemaEnv(sch, schEnv)) return sch;
      }
    }
    compile.getCompilingSchema = getCompilingSchema;
    function sameSchemaEnv(s1, s2) {
      return s1.schema === s2.schema && s1.root === s2.root && s1.baseId === s2.baseId;
    }
    // resolve and compile the references ($ref)
    // TODO returns AnySchemaObject (if the schema can be inlined) or validation function
    function resolve$1(root,
    // information about the root schema for the current schema
    ref // reference to resolve
    ) {
      let sch;
      while (typeof (sch = this.refs[ref]) == "string") ref = sch;
      return sch || this.schemas[ref] || resolveSchema.call(this, root, ref);
    }
    // Resolve schema, its root and baseId
    function resolveSchema(root,
    // root object with properties schema, refs TODO below SchemaEnv is assigned to it
    ref // reference to resolve
    ) {
      const p = this.opts.uriResolver.parse(ref);
      const refPath = (0, resolve_1._getFullPath)(this.opts.uriResolver, p);
      let baseId = (0, resolve_1.getFullPath)(this.opts.uriResolver, root.baseId, undefined);
      // TODO `Object.keys(root.schema).length > 0` should not be needed - but removing breaks 2 tests
      if (Object.keys(root.schema).length > 0 && refPath === baseId) {
        return getJsonPointer.call(this, p, root);
      }
      const id = (0, resolve_1.normalizeId)(refPath);
      const schOrRef = this.refs[id] || this.schemas[id];
      if (typeof schOrRef == "string") {
        const sch = resolveSchema.call(this, root, schOrRef);
        if (typeof (sch === null || sch === void 0 ? void 0 : sch.schema) !== "object") return;
        return getJsonPointer.call(this, p, sch);
      }
      if (typeof (schOrRef === null || schOrRef === void 0 ? void 0 : schOrRef.schema) !== "object") return;
      if (!schOrRef.validate) compileSchema.call(this, schOrRef);
      if (id === (0, resolve_1.normalizeId)(ref)) {
        const {
          schema
        } = schOrRef;
        const {
          schemaId
        } = this.opts;
        const schId = schema[schemaId];
        if (schId) baseId = (0, resolve_1.resolveUrl)(this.opts.uriResolver, baseId, schId);
        return new SchemaEnv({
          schema,
          schemaId,
          root,
          baseId
        });
      }
      return getJsonPointer.call(this, p, schOrRef);
    }
    compile.resolveSchema = resolveSchema;
    const PREVENT_SCOPE_CHANGE = new Set(["properties", "patternProperties", "enum", "dependencies", "definitions"]);
    function getJsonPointer(parsedRef, {
      baseId,
      schema,
      root
    }) {
      var _a;
      if (((_a = parsedRef.fragment) === null || _a === void 0 ? void 0 : _a[0]) !== "/") return;
      for (const part of parsedRef.fragment.slice(1).split("/")) {
        if (typeof schema === "boolean") return;
        const partSchema = schema[(0, util_1$k.unescapeFragment)(part)];
        if (partSchema === undefined) return;
        schema = partSchema;
        // TODO PREVENT_SCOPE_CHANGE could be defined in keyword def?
        const schId = typeof schema === "object" && schema[this.opts.schemaId];
        if (!PREVENT_SCOPE_CHANGE.has(part) && schId) {
          baseId = (0, resolve_1.resolveUrl)(this.opts.uriResolver, baseId, schId);
        }
      }
      let env;
      if (typeof schema != "boolean" && schema.$ref && !(0, util_1$k.schemaHasRulesButRef)(schema, this.RULES)) {
        const $ref = (0, resolve_1.resolveUrl)(this.opts.uriResolver, baseId, schema.$ref);
        env = resolveSchema.call(this, root, $ref);
      }
      // even though resolution failed we need to return SchemaEnv to throw exception
      // so that compileAsync loads missing schema.
      const {
        schemaId
      } = this.opts;
      env = env || new SchemaEnv({
        schema,
        schemaId,
        root,
        baseId
      });
      if (env.schema !== env.root.schema) return env;
      return undefined;
    }

    var $id$1 = "https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#";
    var description = "Meta-schema for $data reference (JSON AnySchema extension proposal)";
    var type$1 = "object";
    var required$1 = [
    	"$data"
    ];
    var properties$2 = {
    	$data: {
    		type: "string",
    		anyOf: [
    			{
    				format: "relative-json-pointer"
    			},
    			{
    				format: "json-pointer"
    			}
    		]
    	}
    };
    var additionalProperties$1 = false;
    var require$$9 = {
    	$id: $id$1,
    	description: description,
    	type: type$1,
    	required: required$1,
    	properties: properties$2,
    	additionalProperties: additionalProperties$1
    };

    var uri$1 = {};

    var fastUri$1 = {exports: {}};

    const HEX$1 = {
      0: 0,
      1: 1,
      2: 2,
      3: 3,
      4: 4,
      5: 5,
      6: 6,
      7: 7,
      8: 8,
      9: 9,
      a: 10,
      A: 10,
      b: 11,
      B: 11,
      c: 12,
      C: 12,
      d: 13,
      D: 13,
      e: 14,
      E: 14,
      f: 15,
      F: 15
    };
    var scopedChars = {
      HEX: HEX$1
    };

    const {
      HEX
    } = scopedChars;
    const IPV4_REG = /^(?:(?:25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.){3}(?:25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)$/u;
    function normalizeIPv4$1(host) {
      if (findToken(host, '.') < 3) {
        return {
          host,
          isIPV4: false
        };
      }
      const matches = host.match(IPV4_REG) || [];
      const [address] = matches;
      if (address) {
        return {
          host: stripLeadingZeros(address, '.'),
          isIPV4: true
        };
      } else {
        return {
          host,
          isIPV4: false
        };
      }
    }

    /**
     * @param {string[]} input
     * @param {boolean} [keepZero=false]
     * @returns {string|undefined}
     */
    function stringArrayToHexStripped(input, keepZero = false) {
      let acc = '';
      let strip = true;
      for (const c of input) {
        if (HEX[c] === undefined) return undefined;
        if (c !== '0' && strip === true) strip = false;
        if (!strip) acc += c;
      }
      if (keepZero && acc.length === 0) acc = '0';
      return acc;
    }
    function getIPV6(input) {
      let tokenCount = 0;
      const output = {
        error: false,
        address: '',
        zone: ''
      };
      const address = [];
      const buffer = [];
      let isZone = false;
      let endipv6Encountered = false;
      let endIpv6 = false;
      function consume() {
        if (buffer.length) {
          if (isZone === false) {
            const hex = stringArrayToHexStripped(buffer);
            if (hex !== undefined) {
              address.push(hex);
            } else {
              output.error = true;
              return false;
            }
          }
          buffer.length = 0;
        }
        return true;
      }
      for (let i = 0; i < input.length; i++) {
        const cursor = input[i];
        if (cursor === '[' || cursor === ']') {
          continue;
        }
        if (cursor === ':') {
          if (endipv6Encountered === true) {
            endIpv6 = true;
          }
          if (!consume()) {
            break;
          }
          tokenCount++;
          address.push(':');
          if (tokenCount > 7) {
            // not valid
            output.error = true;
            break;
          }
          if (i - 1 >= 0 && input[i - 1] === ':') {
            endipv6Encountered = true;
          }
          continue;
        } else if (cursor === '%') {
          if (!consume()) {
            break;
          }
          // switch to zone detection
          isZone = true;
        } else {
          buffer.push(cursor);
          continue;
        }
      }
      if (buffer.length) {
        if (isZone) {
          output.zone = buffer.join('');
        } else if (endIpv6) {
          address.push(buffer.join(''));
        } else {
          address.push(stringArrayToHexStripped(buffer));
        }
      }
      output.address = address.join('');
      return output;
    }
    function normalizeIPv6$1(host) {
      if (findToken(host, ':') < 2) {
        return {
          host,
          isIPV6: false
        };
      }
      const ipv6 = getIPV6(host);
      if (!ipv6.error) {
        let newHost = ipv6.address;
        let escapedHost = ipv6.address;
        if (ipv6.zone) {
          newHost += '%' + ipv6.zone;
          escapedHost += '%25' + ipv6.zone;
        }
        return {
          host: newHost,
          escapedHost,
          isIPV6: true
        };
      } else {
        return {
          host,
          isIPV6: false
        };
      }
    }
    function stripLeadingZeros(str, token) {
      let out = '';
      let skip = true;
      const l = str.length;
      for (let i = 0; i < l; i++) {
        const c = str[i];
        if (c === '0' && skip) {
          if (i + 1 <= l && str[i + 1] === token || i + 1 === l) {
            out += c;
            skip = false;
          }
        } else {
          if (c === token) {
            skip = true;
          } else {
            skip = false;
          }
          out += c;
        }
      }
      return out;
    }
    function findToken(str, token) {
      let ind = 0;
      for (let i = 0; i < str.length; i++) {
        if (str[i] === token) ind++;
      }
      return ind;
    }
    const RDS1 = /^\.\.?\//u;
    const RDS2 = /^\/\.(?:\/|$)/u;
    const RDS3 = /^\/\.\.(?:\/|$)/u;
    const RDS5 = /^\/?(?:.|\n)*?(?=\/|$)/u;
    function removeDotSegments$1(input) {
      const output = [];
      while (input.length) {
        if (input.match(RDS1)) {
          input = input.replace(RDS1, '');
        } else if (input.match(RDS2)) {
          input = input.replace(RDS2, '/');
        } else if (input.match(RDS3)) {
          input = input.replace(RDS3, '/');
          output.pop();
        } else if (input === '.' || input === '..') {
          input = '';
        } else {
          const im = input.match(RDS5);
          if (im) {
            const s = im[0];
            input = input.slice(s.length);
            output.push(s);
          } else {
            throw new Error('Unexpected dot segment condition');
          }
        }
      }
      return output.join('');
    }
    function normalizeComponentEncoding$1(components, esc) {
      const func = esc !== true ? escape : unescape;
      if (components.scheme !== undefined) {
        components.scheme = func(components.scheme);
      }
      if (components.userinfo !== undefined) {
        components.userinfo = func(components.userinfo);
      }
      if (components.host !== undefined) {
        components.host = func(components.host);
      }
      if (components.path !== undefined) {
        components.path = func(components.path);
      }
      if (components.query !== undefined) {
        components.query = func(components.query);
      }
      if (components.fragment !== undefined) {
        components.fragment = func(components.fragment);
      }
      return components;
    }
    function recomposeAuthority$1(components) {
      const uriTokens = [];
      if (components.userinfo !== undefined) {
        uriTokens.push(components.userinfo);
        uriTokens.push('@');
      }
      if (components.host !== undefined) {
        let host = unescape(components.host);
        const ipV4res = normalizeIPv4$1(host);
        if (ipV4res.isIPV4) {
          host = ipV4res.host;
        } else {
          const ipV6res = normalizeIPv6$1(ipV4res.host);
          if (ipV6res.isIPV6 === true) {
            host = `[${ipV6res.escapedHost}]`;
          } else {
            host = components.host;
          }
        }
        uriTokens.push(host);
      }
      if (typeof components.port === 'number' || typeof components.port === 'string') {
        uriTokens.push(':');
        uriTokens.push(String(components.port));
      }
      return uriTokens.length ? uriTokens.join('') : undefined;
    }
    var utils = {
      recomposeAuthority: recomposeAuthority$1,
      normalizeComponentEncoding: normalizeComponentEncoding$1,
      removeDotSegments: removeDotSegments$1,
      normalizeIPv4: normalizeIPv4$1,
      normalizeIPv6: normalizeIPv6$1};

    const UUID_REG = /^[\da-f]{8}-[\da-f]{4}-[\da-f]{4}-[\da-f]{4}-[\da-f]{12}$/iu;
    const URN_REG = /([\da-z][\d\-a-z]{0,31}):((?:[\w!$'()*+,\-.:;=@]|%[\da-f]{2})+)/iu;
    function isSecure(wsComponents) {
      return typeof wsComponents.secure === 'boolean' ? wsComponents.secure : String(wsComponents.scheme).toLowerCase() === 'wss';
    }
    function httpParse(components) {
      if (!components.host) {
        components.error = components.error || 'HTTP URIs must have a host.';
      }
      return components;
    }
    function httpSerialize(components) {
      const secure = String(components.scheme).toLowerCase() === 'https';

      // normalize the default port
      if (components.port === (secure ? 443 : 80) || components.port === '') {
        components.port = undefined;
      }

      // normalize the empty path
      if (!components.path) {
        components.path = '/';
      }

      // NOTE: We do not parse query strings for HTTP URIs
      // as WWW Form Url Encoded query strings are part of the HTML4+ spec,
      // and not the HTTP spec.

      return components;
    }
    function wsParse(wsComponents) {
      // indicate if the secure flag is set
      wsComponents.secure = isSecure(wsComponents);

      // construct resouce name
      wsComponents.resourceName = (wsComponents.path || '/') + (wsComponents.query ? '?' + wsComponents.query : '');
      wsComponents.path = undefined;
      wsComponents.query = undefined;
      return wsComponents;
    }
    function wsSerialize(wsComponents) {
      // normalize the default port
      if (wsComponents.port === (isSecure(wsComponents) ? 443 : 80) || wsComponents.port === '') {
        wsComponents.port = undefined;
      }

      // ensure scheme matches secure flag
      if (typeof wsComponents.secure === 'boolean') {
        wsComponents.scheme = wsComponents.secure ? 'wss' : 'ws';
        wsComponents.secure = undefined;
      }

      // reconstruct path from resource name
      if (wsComponents.resourceName) {
        const [path, query] = wsComponents.resourceName.split('?');
        wsComponents.path = path && path !== '/' ? path : undefined;
        wsComponents.query = query;
        wsComponents.resourceName = undefined;
      }

      // forbid fragment component
      wsComponents.fragment = undefined;
      return wsComponents;
    }
    function urnParse(urnComponents, options) {
      if (!urnComponents.path) {
        urnComponents.error = 'URN can not be parsed';
        return urnComponents;
      }
      const matches = urnComponents.path.match(URN_REG);
      if (matches) {
        const scheme = options.scheme || urnComponents.scheme || 'urn';
        urnComponents.nid = matches[1].toLowerCase();
        urnComponents.nss = matches[2];
        const urnScheme = `${scheme}:${options.nid || urnComponents.nid}`;
        const schemeHandler = SCHEMES$1[urnScheme];
        urnComponents.path = undefined;
        if (schemeHandler) {
          urnComponents = schemeHandler.parse(urnComponents, options);
        }
      } else {
        urnComponents.error = urnComponents.error || 'URN can not be parsed.';
      }
      return urnComponents;
    }
    function urnSerialize(urnComponents, options) {
      const scheme = options.scheme || urnComponents.scheme || 'urn';
      const nid = urnComponents.nid.toLowerCase();
      const urnScheme = `${scheme}:${options.nid || nid}`;
      const schemeHandler = SCHEMES$1[urnScheme];
      if (schemeHandler) {
        urnComponents = schemeHandler.serialize(urnComponents, options);
      }
      const uriComponents = urnComponents;
      const nss = urnComponents.nss;
      uriComponents.path = `${nid || options.nid}:${nss}`;
      options.skipEscape = true;
      return uriComponents;
    }
    function urnuuidParse(urnComponents, options) {
      const uuidComponents = urnComponents;
      uuidComponents.uuid = uuidComponents.nss;
      uuidComponents.nss = undefined;
      if (!options.tolerant && (!uuidComponents.uuid || !UUID_REG.test(uuidComponents.uuid))) {
        uuidComponents.error = uuidComponents.error || 'UUID is not valid.';
      }
      return uuidComponents;
    }
    function urnuuidSerialize(uuidComponents) {
      const urnComponents = uuidComponents;
      // normalize UUID
      urnComponents.nss = (uuidComponents.uuid || '').toLowerCase();
      return urnComponents;
    }
    const http = {
      scheme: 'http',
      domainHost: true,
      parse: httpParse,
      serialize: httpSerialize
    };
    const https = {
      scheme: 'https',
      domainHost: http.domainHost,
      parse: httpParse,
      serialize: httpSerialize
    };
    const ws = {
      scheme: 'ws',
      domainHost: true,
      parse: wsParse,
      serialize: wsSerialize
    };
    const wss = {
      scheme: 'wss',
      domainHost: ws.domainHost,
      parse: ws.parse,
      serialize: ws.serialize
    };
    const urn = {
      scheme: 'urn',
      parse: urnParse,
      serialize: urnSerialize,
      skipNormalize: true
    };
    const urnuuid = {
      scheme: 'urn:uuid',
      parse: urnuuidParse,
      serialize: urnuuidSerialize,
      skipNormalize: true
    };
    const SCHEMES$1 = {
      http,
      https,
      ws,
      wss,
      urn,
      'urn:uuid': urnuuid
    };
    var schemes = SCHEMES$1;

    const {
      normalizeIPv6,
      normalizeIPv4,
      removeDotSegments,
      recomposeAuthority,
      normalizeComponentEncoding
    } = utils;
    const SCHEMES = schemes;
    function normalize(uri, options) {
      if (typeof uri === 'string') {
        uri = serialize(parse(uri, options), options);
      } else if (typeof uri === 'object') {
        uri = parse(serialize(uri, options), options);
      }
      return uri;
    }
    function resolve(baseURI, relativeURI, options) {
      const schemelessOptions = Object.assign({
        scheme: 'null'
      }, options);
      const resolved = resolveComponents(parse(baseURI, schemelessOptions), parse(relativeURI, schemelessOptions), schemelessOptions, true);
      return serialize(resolved, {
        ...schemelessOptions,
        skipEscape: true
      });
    }
    function resolveComponents(base, relative, options, skipNormalization) {
      const target = {};
      if (!skipNormalization) {
        base = parse(serialize(base, options), options); // normalize base components
        relative = parse(serialize(relative, options), options); // normalize relative components
      }
      options = options || {};
      if (!options.tolerant && relative.scheme) {
        target.scheme = relative.scheme;
        // target.authority = relative.authority;
        target.userinfo = relative.userinfo;
        target.host = relative.host;
        target.port = relative.port;
        target.path = removeDotSegments(relative.path || '');
        target.query = relative.query;
      } else {
        if (relative.userinfo !== undefined || relative.host !== undefined || relative.port !== undefined) {
          // target.authority = relative.authority;
          target.userinfo = relative.userinfo;
          target.host = relative.host;
          target.port = relative.port;
          target.path = removeDotSegments(relative.path || '');
          target.query = relative.query;
        } else {
          if (!relative.path) {
            target.path = base.path;
            if (relative.query !== undefined) {
              target.query = relative.query;
            } else {
              target.query = base.query;
            }
          } else {
            if (relative.path.charAt(0) === '/') {
              target.path = removeDotSegments(relative.path);
            } else {
              if ((base.userinfo !== undefined || base.host !== undefined || base.port !== undefined) && !base.path) {
                target.path = '/' + relative.path;
              } else if (!base.path) {
                target.path = relative.path;
              } else {
                target.path = base.path.slice(0, base.path.lastIndexOf('/') + 1) + relative.path;
              }
              target.path = removeDotSegments(target.path);
            }
            target.query = relative.query;
          }
          // target.authority = base.authority;
          target.userinfo = base.userinfo;
          target.host = base.host;
          target.port = base.port;
        }
        target.scheme = base.scheme;
      }
      target.fragment = relative.fragment;
      return target;
    }
    function equal$2(uriA, uriB, options) {
      if (typeof uriA === 'string') {
        uriA = unescape(uriA);
        uriA = serialize(normalizeComponentEncoding(parse(uriA, options), true), {
          ...options,
          skipEscape: true
        });
      } else if (typeof uriA === 'object') {
        uriA = serialize(normalizeComponentEncoding(uriA, true), {
          ...options,
          skipEscape: true
        });
      }
      if (typeof uriB === 'string') {
        uriB = unescape(uriB);
        uriB = serialize(normalizeComponentEncoding(parse(uriB, options), true), {
          ...options,
          skipEscape: true
        });
      } else if (typeof uriB === 'object') {
        uriB = serialize(normalizeComponentEncoding(uriB, true), {
          ...options,
          skipEscape: true
        });
      }
      return uriA.toLowerCase() === uriB.toLowerCase();
    }
    function serialize(cmpts, opts) {
      const components = {
        host: cmpts.host,
        scheme: cmpts.scheme,
        userinfo: cmpts.userinfo,
        port: cmpts.port,
        path: cmpts.path,
        query: cmpts.query,
        nid: cmpts.nid,
        nss: cmpts.nss,
        uuid: cmpts.uuid,
        fragment: cmpts.fragment,
        reference: cmpts.reference,
        resourceName: cmpts.resourceName,
        secure: cmpts.secure,
        error: ''
      };
      const options = Object.assign({}, opts);
      const uriTokens = [];

      // find scheme handler
      const schemeHandler = SCHEMES[(options.scheme || components.scheme || '').toLowerCase()];

      // perform scheme specific serialization
      if (schemeHandler && schemeHandler.serialize) schemeHandler.serialize(components, options);
      if (components.path !== undefined) {
        if (!options.skipEscape) {
          components.path = escape(components.path);
          if (components.scheme !== undefined) {
            components.path = components.path.split('%3A').join(':');
          }
        } else {
          components.path = unescape(components.path);
        }
      }
      if (options.reference !== 'suffix' && components.scheme) {
        uriTokens.push(components.scheme, ':');
      }
      const authority = recomposeAuthority(components);
      if (authority !== undefined) {
        if (options.reference !== 'suffix') {
          uriTokens.push('//');
        }
        uriTokens.push(authority);
        if (components.path && components.path.charAt(0) !== '/') {
          uriTokens.push('/');
        }
      }
      if (components.path !== undefined) {
        let s = components.path;
        if (!options.absolutePath && (!schemeHandler || !schemeHandler.absolutePath)) {
          s = removeDotSegments(s);
        }
        if (authority === undefined) {
          s = s.replace(/^\/\//u, '/%2F'); // don't allow the path to start with "//"
        }
        uriTokens.push(s);
      }
      if (components.query !== undefined) {
        uriTokens.push('?', components.query);
      }
      if (components.fragment !== undefined) {
        uriTokens.push('#', components.fragment);
      }
      return uriTokens.join('');
    }
    const hexLookUp = Array.from({
      length: 127
    }, (_v, k) => /[^!"$&'()*+,\-.;=_`a-z{}~]/u.test(String.fromCharCode(k)));
    function nonSimpleDomain(value) {
      let code = 0;
      for (let i = 0, len = value.length; i < len; ++i) {
        code = value.charCodeAt(i);
        if (code > 126 || hexLookUp[code]) {
          return true;
        }
      }
      return false;
    }
    const URI_PARSE = /^(?:([^#/:?]+):)?(?:\/\/((?:([^#/?@]*)@)?(\[[^#/?\]]+\]|[^#/:?]*)(?::(\d*))?))?([^#?]*)(?:\?([^#]*))?(?:#((?:.|[\n\r])*))?/u;
    function parse(uri, opts) {
      const options = Object.assign({}, opts);
      const parsed = {
        scheme: undefined,
        userinfo: undefined,
        host: '',
        port: undefined,
        path: '',
        query: undefined,
        fragment: undefined
      };
      const gotEncoding = uri.indexOf('%') !== -1;
      let isIP = false;
      if (options.reference === 'suffix') uri = (options.scheme ? options.scheme + ':' : '') + '//' + uri;
      const matches = uri.match(URI_PARSE);
      if (matches) {
        // store each component
        parsed.scheme = matches[1];
        parsed.userinfo = matches[3];
        parsed.host = matches[4];
        parsed.port = parseInt(matches[5], 10);
        parsed.path = matches[6] || '';
        parsed.query = matches[7];
        parsed.fragment = matches[8];

        // fix port number
        if (isNaN(parsed.port)) {
          parsed.port = matches[5];
        }
        if (parsed.host) {
          const ipv4result = normalizeIPv4(parsed.host);
          if (ipv4result.isIPV4 === false) {
            const ipv6result = normalizeIPv6(ipv4result.host);
            parsed.host = ipv6result.host.toLowerCase();
            isIP = ipv6result.isIPV6;
          } else {
            parsed.host = ipv4result.host;
            isIP = true;
          }
        }
        if (parsed.scheme === undefined && parsed.userinfo === undefined && parsed.host === undefined && parsed.port === undefined && parsed.query === undefined && !parsed.path) {
          parsed.reference = 'same-document';
        } else if (parsed.scheme === undefined) {
          parsed.reference = 'relative';
        } else if (parsed.fragment === undefined) {
          parsed.reference = 'absolute';
        } else {
          parsed.reference = 'uri';
        }

        // check for reference errors
        if (options.reference && options.reference !== 'suffix' && options.reference !== parsed.reference) {
          parsed.error = parsed.error || 'URI is not a ' + options.reference + ' reference.';
        }

        // find scheme handler
        const schemeHandler = SCHEMES[(options.scheme || parsed.scheme || '').toLowerCase()];

        // check if scheme can't handle IRIs
        if (!options.unicodeSupport && (!schemeHandler || !schemeHandler.unicodeSupport)) {
          // if host component is a domain name
          if (parsed.host && (options.domainHost || schemeHandler && schemeHandler.domainHost) && isIP === false && nonSimpleDomain(parsed.host)) {
            // convert Unicode IDN -> ASCII IDN
            try {
              parsed.host = URL.domainToASCII(parsed.host.toLowerCase());
            } catch (e) {
              parsed.error = parsed.error || "Host's domain name can not be converted to ASCII: " + e;
            }
          }
          // convert IRI -> URI
        }
        if (!schemeHandler || schemeHandler && !schemeHandler.skipNormalize) {
          if (gotEncoding && parsed.scheme !== undefined) {
            parsed.scheme = unescape(parsed.scheme);
          }
          if (gotEncoding && parsed.host !== undefined) {
            parsed.host = unescape(parsed.host);
          }
          if (parsed.path) {
            parsed.path = escape(unescape(parsed.path));
          }
          if (parsed.fragment) {
            parsed.fragment = encodeURI(decodeURIComponent(parsed.fragment));
          }
        }

        // perform scheme specific parsing
        if (schemeHandler && schemeHandler.parse) {
          schemeHandler.parse(parsed, options);
        }
      } else {
        parsed.error = parsed.error || 'URI can not be parsed.';
      }
      return parsed;
    }
    const fastUri = {
      SCHEMES,
      normalize,
      resolve,
      resolveComponents,
      equal: equal$2,
      serialize,
      parse
    };
    fastUri$1.exports = fastUri;
    fastUri$1.exports.default = fastUri;
    fastUri$1.exports.fastUri = fastUri;
    var fastUriExports = fastUri$1.exports;

    Object.defineProperty(uri$1, "__esModule", {
      value: true
    });
    const uri = fastUriExports;
    uri.code = 'require("ajv/dist/runtime/uri").default';
    uri$1.default = uri;

    (function (exports) {

      Object.defineProperty(exports, "__esModule", {
        value: true
      });
      exports.CodeGen = exports.Name = exports.nil = exports.stringify = exports.str = exports._ = exports.KeywordCxt = void 0;
      var validate_1 = /*@__PURE__*/requireValidate();
      Object.defineProperty(exports, "KeywordCxt", {
        enumerable: true,
        get: function () {
          return validate_1.KeywordCxt;
        }
      });
      var codegen_1 = /*@__PURE__*/requireCodegen();
      Object.defineProperty(exports, "_", {
        enumerable: true,
        get: function () {
          return codegen_1._;
        }
      });
      Object.defineProperty(exports, "str", {
        enumerable: true,
        get: function () {
          return codegen_1.str;
        }
      });
      Object.defineProperty(exports, "stringify", {
        enumerable: true,
        get: function () {
          return codegen_1.stringify;
        }
      });
      Object.defineProperty(exports, "nil", {
        enumerable: true,
        get: function () {
          return codegen_1.nil;
        }
      });
      Object.defineProperty(exports, "Name", {
        enumerable: true,
        get: function () {
          return codegen_1.Name;
        }
      });
      Object.defineProperty(exports, "CodeGen", {
        enumerable: true,
        get: function () {
          return codegen_1.CodeGen;
        }
      });
      const validation_error_1 = /*@__PURE__*/requireValidation_error();
      const ref_error_1 = /*@__PURE__*/requireRef_error();
      const rules_1 = rules;
      const compile_1 = compile;
      const codegen_2 = /*@__PURE__*/requireCodegen();
      const resolve_1 = resolve$2;
      const dataType_1 = dataType;
      const util_1 = util;
      const $dataRefSchema = require$$9;
      const uri_1 = uri$1;
      const defaultRegExp = (str, flags) => new RegExp(str, flags);
      defaultRegExp.code = "new RegExp";
      const META_IGNORE_OPTIONS = ["removeAdditional", "useDefaults", "coerceTypes"];
      const EXT_SCOPE_NAMES = new Set(["validate", "serialize", "parse", "wrapper", "root", "schema", "keyword", "pattern", "formats", "validate$data", "func", "obj", "Error"]);
      const removedOptions = {
        errorDataPath: "",
        format: "`validateFormats: false` can be used instead.",
        nullable: '"nullable" keyword is supported by default.',
        jsonPointers: "Deprecated jsPropertySyntax can be used instead.",
        extendRefs: "Deprecated ignoreKeywordsWithRef can be used instead.",
        missingRefs: "Pass empty schema with $id that should be ignored to ajv.addSchema.",
        processCode: "Use option `code: {process: (code, schemaEnv: object) => string}`",
        sourceCode: "Use option `code: {source: true}`",
        strictDefaults: "It is default now, see option `strict`.",
        strictKeywords: "It is default now, see option `strict`.",
        uniqueItems: '"uniqueItems" keyword is always validated.',
        unknownFormats: "Disable strict mode or pass `true` to `ajv.addFormat` (or `formats` option).",
        cache: "Map is used as cache, schema object as key.",
        serialize: "Map is used as cache, schema object as key.",
        ajvErrors: "It is default now."
      };
      const deprecatedOptions = {
        ignoreKeywordsWithRef: "",
        jsPropertySyntax: "",
        unicode: '"minLength"/"maxLength" account for unicode characters by default.'
      };
      const MAX_EXPRESSION = 200;
      // eslint-disable-next-line complexity
      function requiredOptions(o) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0;
        const s = o.strict;
        const _optz = (_a = o.code) === null || _a === void 0 ? void 0 : _a.optimize;
        const optimize = _optz === true || _optz === undefined ? 1 : _optz || 0;
        const regExp = (_c = (_b = o.code) === null || _b === void 0 ? void 0 : _b.regExp) !== null && _c !== void 0 ? _c : defaultRegExp;
        const uriResolver = (_d = o.uriResolver) !== null && _d !== void 0 ? _d : uri_1.default;
        return {
          strictSchema: (_f = (_e = o.strictSchema) !== null && _e !== void 0 ? _e : s) !== null && _f !== void 0 ? _f : true,
          strictNumbers: (_h = (_g = o.strictNumbers) !== null && _g !== void 0 ? _g : s) !== null && _h !== void 0 ? _h : true,
          strictTypes: (_k = (_j = o.strictTypes) !== null && _j !== void 0 ? _j : s) !== null && _k !== void 0 ? _k : "log",
          strictTuples: (_m = (_l = o.strictTuples) !== null && _l !== void 0 ? _l : s) !== null && _m !== void 0 ? _m : "log",
          strictRequired: (_p = (_o = o.strictRequired) !== null && _o !== void 0 ? _o : s) !== null && _p !== void 0 ? _p : false,
          code: o.code ? {
            ...o.code,
            optimize,
            regExp
          } : {
            optimize,
            regExp
          },
          loopRequired: (_q = o.loopRequired) !== null && _q !== void 0 ? _q : MAX_EXPRESSION,
          loopEnum: (_r = o.loopEnum) !== null && _r !== void 0 ? _r : MAX_EXPRESSION,
          meta: (_s = o.meta) !== null && _s !== void 0 ? _s : true,
          messages: (_t = o.messages) !== null && _t !== void 0 ? _t : true,
          inlineRefs: (_u = o.inlineRefs) !== null && _u !== void 0 ? _u : true,
          schemaId: (_v = o.schemaId) !== null && _v !== void 0 ? _v : "$id",
          addUsedSchema: (_w = o.addUsedSchema) !== null && _w !== void 0 ? _w : true,
          validateSchema: (_x = o.validateSchema) !== null && _x !== void 0 ? _x : true,
          validateFormats: (_y = o.validateFormats) !== null && _y !== void 0 ? _y : true,
          unicodeRegExp: (_z = o.unicodeRegExp) !== null && _z !== void 0 ? _z : true,
          int32range: (_0 = o.int32range) !== null && _0 !== void 0 ? _0 : true,
          uriResolver: uriResolver
        };
      }
      class Ajv {
        constructor(opts = {}) {
          this.schemas = {};
          this.refs = {};
          this.formats = {};
          this._compilations = new Set();
          this._loading = {};
          this._cache = new Map();
          opts = this.opts = {
            ...opts,
            ...requiredOptions(opts)
          };
          const {
            es5,
            lines
          } = this.opts.code;
          this.scope = new codegen_2.ValueScope({
            scope: {},
            prefixes: EXT_SCOPE_NAMES,
            es5,
            lines
          });
          this.logger = getLogger(opts.logger);
          const formatOpt = opts.validateFormats;
          opts.validateFormats = false;
          this.RULES = (0, rules_1.getRules)();
          checkOptions.call(this, removedOptions, opts, "NOT SUPPORTED");
          checkOptions.call(this, deprecatedOptions, opts, "DEPRECATED", "warn");
          this._metaOpts = getMetaSchemaOptions.call(this);
          if (opts.formats) addInitialFormats.call(this);
          this._addVocabularies();
          this._addDefaultMetaSchema();
          if (opts.keywords) addInitialKeywords.call(this, opts.keywords);
          if (typeof opts.meta == "object") this.addMetaSchema(opts.meta);
          addInitialSchemas.call(this);
          opts.validateFormats = formatOpt;
        }
        _addVocabularies() {
          this.addKeyword("$async");
        }
        _addDefaultMetaSchema() {
          const {
            $data,
            meta,
            schemaId
          } = this.opts;
          let _dataRefSchema = $dataRefSchema;
          if (schemaId === "id") {
            _dataRefSchema = {
              ...$dataRefSchema
            };
            _dataRefSchema.id = _dataRefSchema.$id;
            delete _dataRefSchema.$id;
          }
          if (meta && $data) this.addMetaSchema(_dataRefSchema, _dataRefSchema[schemaId], false);
        }
        defaultMeta() {
          const {
            meta,
            schemaId
          } = this.opts;
          return this.opts.defaultMeta = typeof meta == "object" ? meta[schemaId] || meta : undefined;
        }
        validate(schemaKeyRef,
        // key, ref or schema object
        // eslint-disable-next-line @typescript-eslint/no-redundant-type-constituents
        data // to be validated
        ) {
          let v;
          if (typeof schemaKeyRef == "string") {
            v = this.getSchema(schemaKeyRef);
            if (!v) throw new Error(`no schema with key or ref "${schemaKeyRef}"`);
          } else {
            v = this.compile(schemaKeyRef);
          }
          const valid = v(data);
          if (!("$async" in v)) this.errors = v.errors;
          return valid;
        }
        compile(schema, _meta) {
          const sch = this._addSchema(schema, _meta);
          return sch.validate || this._compileSchemaEnv(sch);
        }
        compileAsync(schema, meta) {
          if (typeof this.opts.loadSchema != "function") {
            throw new Error("options.loadSchema should be a function");
          }
          const {
            loadSchema
          } = this.opts;
          return runCompileAsync.call(this, schema, meta);
          async function runCompileAsync(_schema, _meta) {
            await loadMetaSchema.call(this, _schema.$schema);
            const sch = this._addSchema(_schema, _meta);
            return sch.validate || _compileAsync.call(this, sch);
          }
          async function loadMetaSchema($ref) {
            if ($ref && !this.getSchema($ref)) {
              await runCompileAsync.call(this, {
                $ref
              }, true);
            }
          }
          async function _compileAsync(sch) {
            try {
              return this._compileSchemaEnv(sch);
            } catch (e) {
              if (!(e instanceof ref_error_1.default)) throw e;
              checkLoaded.call(this, e);
              await loadMissingSchema.call(this, e.missingSchema);
              return _compileAsync.call(this, sch);
            }
          }
          function checkLoaded({
            missingSchema: ref,
            missingRef
          }) {
            if (this.refs[ref]) {
              throw new Error(`AnySchema ${ref} is loaded but ${missingRef} cannot be resolved`);
            }
          }
          async function loadMissingSchema(ref) {
            const _schema = await _loadSchema.call(this, ref);
            if (!this.refs[ref]) await loadMetaSchema.call(this, _schema.$schema);
            if (!this.refs[ref]) this.addSchema(_schema, ref, meta);
          }
          async function _loadSchema(ref) {
            const p = this._loading[ref];
            if (p) return p;
            try {
              return await (this._loading[ref] = loadSchema(ref));
            } finally {
              delete this._loading[ref];
            }
          }
        }
        // Adds schema to the instance
        addSchema(schema,
        // If array is passed, `key` will be ignored
        key,
        // Optional schema key. Can be passed to `validate` method instead of schema object or id/ref. One schema per instance can have empty `id` and `key`.
        _meta,
        // true if schema is a meta-schema. Used internally, addMetaSchema should be used instead.
        _validateSchema = this.opts.validateSchema // false to skip schema validation. Used internally, option validateSchema should be used instead.
        ) {
          if (Array.isArray(schema)) {
            for (const sch of schema) this.addSchema(sch, undefined, _meta, _validateSchema);
            return this;
          }
          let id;
          if (typeof schema === "object") {
            const {
              schemaId
            } = this.opts;
            id = schema[schemaId];
            if (id !== undefined && typeof id != "string") {
              throw new Error(`schema ${schemaId} must be string`);
            }
          }
          key = (0, resolve_1.normalizeId)(key || id);
          this._checkUnique(key);
          this.schemas[key] = this._addSchema(schema, _meta, key, _validateSchema, true);
          return this;
        }
        // Add schema that will be used to validate other schemas
        // options in META_IGNORE_OPTIONS are alway set to false
        addMetaSchema(schema, key,
        // schema key
        _validateSchema = this.opts.validateSchema // false to skip schema validation, can be used to override validateSchema option for meta-schema
        ) {
          this.addSchema(schema, key, true, _validateSchema);
          return this;
        }
        //  Validate schema against its meta-schema
        validateSchema(schema, throwOrLogError) {
          if (typeof schema == "boolean") return true;
          let $schema;
          $schema = schema.$schema;
          if ($schema !== undefined && typeof $schema != "string") {
            throw new Error("$schema must be a string");
          }
          $schema = $schema || this.opts.defaultMeta || this.defaultMeta();
          if (!$schema) {
            this.logger.warn("meta-schema not available");
            this.errors = null;
            return true;
          }
          const valid = this.validate($schema, schema);
          if (!valid && throwOrLogError) {
            const message = "schema is invalid: " + this.errorsText();
            if (this.opts.validateSchema === "log") this.logger.error(message);else throw new Error(message);
          }
          return valid;
        }
        // Get compiled schema by `key` or `ref`.
        // (`key` that was passed to `addSchema` or full schema reference - `schema.$id` or resolved id)
        getSchema(keyRef) {
          let sch;
          while (typeof (sch = getSchEnv.call(this, keyRef)) == "string") keyRef = sch;
          if (sch === undefined) {
            const {
              schemaId
            } = this.opts;
            const root = new compile_1.SchemaEnv({
              schema: {},
              schemaId
            });
            sch = compile_1.resolveSchema.call(this, root, keyRef);
            if (!sch) return;
            this.refs[keyRef] = sch;
          }
          return sch.validate || this._compileSchemaEnv(sch);
        }
        // Remove cached schema(s).
        // If no parameter is passed all schemas but meta-schemas are removed.
        // If RegExp is passed all schemas with key/id matching pattern but meta-schemas are removed.
        // Even if schema is referenced by other schemas it still can be removed as other schemas have local references.
        removeSchema(schemaKeyRef) {
          if (schemaKeyRef instanceof RegExp) {
            this._removeAllSchemas(this.schemas, schemaKeyRef);
            this._removeAllSchemas(this.refs, schemaKeyRef);
            return this;
          }
          switch (typeof schemaKeyRef) {
            case "undefined":
              this._removeAllSchemas(this.schemas);
              this._removeAllSchemas(this.refs);
              this._cache.clear();
              return this;
            case "string":
              {
                const sch = getSchEnv.call(this, schemaKeyRef);
                if (typeof sch == "object") this._cache.delete(sch.schema);
                delete this.schemas[schemaKeyRef];
                delete this.refs[schemaKeyRef];
                return this;
              }
            case "object":
              {
                const cacheKey = schemaKeyRef;
                this._cache.delete(cacheKey);
                let id = schemaKeyRef[this.opts.schemaId];
                if (id) {
                  id = (0, resolve_1.normalizeId)(id);
                  delete this.schemas[id];
                  delete this.refs[id];
                }
                return this;
              }
            default:
              throw new Error("ajv.removeSchema: invalid parameter");
          }
        }
        // add "vocabulary" - a collection of keywords
        addVocabulary(definitions) {
          for (const def of definitions) this.addKeyword(def);
          return this;
        }
        addKeyword(kwdOrDef, def // deprecated
        ) {
          let keyword;
          if (typeof kwdOrDef == "string") {
            keyword = kwdOrDef;
            if (typeof def == "object") {
              this.logger.warn("these parameters are deprecated, see docs for addKeyword");
              def.keyword = keyword;
            }
          } else if (typeof kwdOrDef == "object" && def === undefined) {
            def = kwdOrDef;
            keyword = def.keyword;
            if (Array.isArray(keyword) && !keyword.length) {
              throw new Error("addKeywords: keyword must be string or non-empty array");
            }
          } else {
            throw new Error("invalid addKeywords parameters");
          }
          checkKeyword.call(this, keyword, def);
          if (!def) {
            (0, util_1.eachItem)(keyword, kwd => addRule.call(this, kwd));
            return this;
          }
          keywordMetaschema.call(this, def);
          const definition = {
            ...def,
            type: (0, dataType_1.getJSONTypes)(def.type),
            schemaType: (0, dataType_1.getJSONTypes)(def.schemaType)
          };
          (0, util_1.eachItem)(keyword, definition.type.length === 0 ? k => addRule.call(this, k, definition) : k => definition.type.forEach(t => addRule.call(this, k, definition, t)));
          return this;
        }
        getKeyword(keyword) {
          const rule = this.RULES.all[keyword];
          return typeof rule == "object" ? rule.definition : !!rule;
        }
        // Remove keyword
        removeKeyword(keyword) {
          // TODO return type should be Ajv
          const {
            RULES
          } = this;
          delete RULES.keywords[keyword];
          delete RULES.all[keyword];
          for (const group of RULES.rules) {
            const i = group.rules.findIndex(rule => rule.keyword === keyword);
            if (i >= 0) group.rules.splice(i, 1);
          }
          return this;
        }
        // Add format
        addFormat(name, format) {
          if (typeof format == "string") format = new RegExp(format);
          this.formats[name] = format;
          return this;
        }
        errorsText(errors = this.errors,
        // optional array of validation errors
        {
          separator = ", ",
          dataVar = "data"
        } = {} // optional options with properties `separator` and `dataVar`
        ) {
          if (!errors || errors.length === 0) return "No errors";
          return errors.map(e => `${dataVar}${e.instancePath} ${e.message}`).reduce((text, msg) => text + separator + msg);
        }
        $dataMetaSchema(metaSchema, keywordsJsonPointers) {
          const rules = this.RULES.all;
          metaSchema = JSON.parse(JSON.stringify(metaSchema));
          for (const jsonPointer of keywordsJsonPointers) {
            const segments = jsonPointer.split("/").slice(1); // first segment is an empty string
            let keywords = metaSchema;
            for (const seg of segments) keywords = keywords[seg];
            for (const key in rules) {
              const rule = rules[key];
              if (typeof rule != "object") continue;
              const {
                $data
              } = rule.definition;
              const schema = keywords[key];
              if ($data && schema) keywords[key] = schemaOrData(schema);
            }
          }
          return metaSchema;
        }
        _removeAllSchemas(schemas, regex) {
          for (const keyRef in schemas) {
            const sch = schemas[keyRef];
            if (!regex || regex.test(keyRef)) {
              if (typeof sch == "string") {
                delete schemas[keyRef];
              } else if (sch && !sch.meta) {
                this._cache.delete(sch.schema);
                delete schemas[keyRef];
              }
            }
          }
        }
        _addSchema(schema, meta, baseId, validateSchema = this.opts.validateSchema, addSchema = this.opts.addUsedSchema) {
          let id;
          const {
            schemaId
          } = this.opts;
          if (typeof schema == "object") {
            id = schema[schemaId];
          } else {
            if (this.opts.jtd) throw new Error("schema must be object");else if (typeof schema != "boolean") throw new Error("schema must be object or boolean");
          }
          let sch = this._cache.get(schema);
          if (sch !== undefined) return sch;
          baseId = (0, resolve_1.normalizeId)(id || baseId);
          const localRefs = resolve_1.getSchemaRefs.call(this, schema, baseId);
          sch = new compile_1.SchemaEnv({
            schema,
            schemaId,
            meta,
            baseId,
            localRefs
          });
          this._cache.set(sch.schema, sch);
          if (addSchema && !baseId.startsWith("#")) {
            // TODO atm it is allowed to overwrite schemas without id (instead of not adding them)
            if (baseId) this._checkUnique(baseId);
            this.refs[baseId] = sch;
          }
          if (validateSchema) this.validateSchema(schema, true);
          return sch;
        }
        _checkUnique(id) {
          if (this.schemas[id] || this.refs[id]) {
            throw new Error(`schema with key or id "${id}" already exists`);
          }
        }
        _compileSchemaEnv(sch) {
          if (sch.meta) this._compileMetaSchema(sch);else compile_1.compileSchema.call(this, sch);
          /* istanbul ignore if */
          if (!sch.validate) throw new Error("ajv implementation error");
          return sch.validate;
        }
        _compileMetaSchema(sch) {
          const currentOpts = this.opts;
          this.opts = this._metaOpts;
          try {
            compile_1.compileSchema.call(this, sch);
          } finally {
            this.opts = currentOpts;
          }
        }
      }
      Ajv.ValidationError = validation_error_1.default;
      Ajv.MissingRefError = ref_error_1.default;
      exports.default = Ajv;
      function checkOptions(checkOpts, options, msg, log = "error") {
        for (const key in checkOpts) {
          const opt = key;
          if (opt in options) this.logger[log](`${msg}: option ${key}. ${checkOpts[opt]}`);
        }
      }
      function getSchEnv(keyRef) {
        keyRef = (0, resolve_1.normalizeId)(keyRef); // TODO tests fail without this line
        return this.schemas[keyRef] || this.refs[keyRef];
      }
      function addInitialSchemas() {
        const optsSchemas = this.opts.schemas;
        if (!optsSchemas) return;
        if (Array.isArray(optsSchemas)) this.addSchema(optsSchemas);else for (const key in optsSchemas) this.addSchema(optsSchemas[key], key);
      }
      function addInitialFormats() {
        for (const name in this.opts.formats) {
          const format = this.opts.formats[name];
          if (format) this.addFormat(name, format);
        }
      }
      function addInitialKeywords(defs) {
        if (Array.isArray(defs)) {
          this.addVocabulary(defs);
          return;
        }
        this.logger.warn("keywords option as map is deprecated, pass array");
        for (const keyword in defs) {
          const def = defs[keyword];
          if (!def.keyword) def.keyword = keyword;
          this.addKeyword(def);
        }
      }
      function getMetaSchemaOptions() {
        const metaOpts = {
          ...this.opts
        };
        for (const opt of META_IGNORE_OPTIONS) delete metaOpts[opt];
        return metaOpts;
      }
      const noLogs = {
        log() {},
        warn() {},
        error() {}
      };
      function getLogger(logger) {
        if (logger === false) return noLogs;
        if (logger === undefined) return console;
        if (logger.log && logger.warn && logger.error) return logger;
        throw new Error("logger must implement log, warn and error methods");
      }
      const KEYWORD_NAME = /^[a-z_$][a-z0-9_$:-]*$/i;
      function checkKeyword(keyword, def) {
        const {
          RULES
        } = this;
        (0, util_1.eachItem)(keyword, kwd => {
          if (RULES.keywords[kwd]) throw new Error(`Keyword ${kwd} is already defined`);
          if (!KEYWORD_NAME.test(kwd)) throw new Error(`Keyword ${kwd} has invalid name`);
        });
        if (!def) return;
        if (def.$data && !("code" in def || "validate" in def)) {
          throw new Error('$data keyword must have "code" or "validate" function');
        }
      }
      function addRule(keyword, definition, dataType) {
        var _a;
        const post = definition === null || definition === void 0 ? void 0 : definition.post;
        if (dataType && post) throw new Error('keyword with "post" flag cannot have "type"');
        const {
          RULES
        } = this;
        let ruleGroup = post ? RULES.post : RULES.rules.find(({
          type: t
        }) => t === dataType);
        if (!ruleGroup) {
          ruleGroup = {
            type: dataType,
            rules: []
          };
          RULES.rules.push(ruleGroup);
        }
        RULES.keywords[keyword] = true;
        if (!definition) return;
        const rule = {
          keyword,
          definition: {
            ...definition,
            type: (0, dataType_1.getJSONTypes)(definition.type),
            schemaType: (0, dataType_1.getJSONTypes)(definition.schemaType)
          }
        };
        if (definition.before) addBeforeRule.call(this, ruleGroup, rule, definition.before);else ruleGroup.rules.push(rule);
        RULES.all[keyword] = rule;
        (_a = definition.implements) === null || _a === void 0 ? void 0 : _a.forEach(kwd => this.addKeyword(kwd));
      }
      function addBeforeRule(ruleGroup, rule, before) {
        const i = ruleGroup.rules.findIndex(_rule => _rule.keyword === before);
        if (i >= 0) {
          ruleGroup.rules.splice(i, 0, rule);
        } else {
          ruleGroup.rules.push(rule);
          this.logger.warn(`rule ${before} is not defined`);
        }
      }
      function keywordMetaschema(def) {
        let {
          metaSchema
        } = def;
        if (metaSchema === undefined) return;
        if (def.$data && this.opts.$data) metaSchema = schemaOrData(metaSchema);
        def.validateSchema = this.compile(metaSchema, true);
      }
      const $dataRef = {
        $ref: "https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#"
      };
      function schemaOrData(schema) {
        return {
          anyOf: [schema, $dataRef]
        };
      }
    })(core$2);

    var draft7 = {};

    var core$1 = {};

    var id = {};

    Object.defineProperty(id, "__esModule", {
      value: true
    });
    const def$s = {
      keyword: "id",
      code() {
        throw new Error('NOT SUPPORTED: keyword "id", use "$id" for schema ID');
      }
    };
    id.default = def$s;

    var ref = {};

    Object.defineProperty(ref, "__esModule", {
      value: true
    });
    ref.callRef = ref.getValidate = void 0;
    const ref_error_1$1 = /*@__PURE__*/requireRef_error();
    const code_1$8 = /*@__PURE__*/requireCode();
    const codegen_1$l = /*@__PURE__*/requireCodegen();
    const names_1$1 = /*@__PURE__*/requireNames();
    const compile_1$1 = compile;
    const util_1$j = util;
    const def$r = {
      keyword: "$ref",
      schemaType: "string",
      code(cxt) {
        const {
          gen,
          schema: $ref,
          it
        } = cxt;
        const {
          baseId,
          schemaEnv: env,
          validateName,
          opts,
          self
        } = it;
        const {
          root
        } = env;
        if (($ref === "#" || $ref === "#/") && baseId === root.baseId) return callRootRef();
        const schOrEnv = compile_1$1.resolveRef.call(self, root, baseId, $ref);
        if (schOrEnv === undefined) throw new ref_error_1$1.default(it.opts.uriResolver, baseId, $ref);
        if (schOrEnv instanceof compile_1$1.SchemaEnv) return callValidate(schOrEnv);
        return inlineRefSchema(schOrEnv);
        function callRootRef() {
          if (env === root) return callRef(cxt, validateName, env, env.$async);
          const rootName = gen.scopeValue("root", {
            ref: root
          });
          return callRef(cxt, (0, codegen_1$l._)`${rootName}.validate`, root, root.$async);
        }
        function callValidate(sch) {
          const v = getValidate(cxt, sch);
          callRef(cxt, v, sch, sch.$async);
        }
        function inlineRefSchema(sch) {
          const schName = gen.scopeValue("schema", opts.code.source === true ? {
            ref: sch,
            code: (0, codegen_1$l.stringify)(sch)
          } : {
            ref: sch
          });
          const valid = gen.name("valid");
          const schCxt = cxt.subschema({
            schema: sch,
            dataTypes: [],
            schemaPath: codegen_1$l.nil,
            topSchemaRef: schName,
            errSchemaPath: $ref
          }, valid);
          cxt.mergeEvaluated(schCxt);
          cxt.ok(valid);
        }
      }
    };
    function getValidate(cxt, sch) {
      const {
        gen
      } = cxt;
      return sch.validate ? gen.scopeValue("validate", {
        ref: sch.validate
      }) : (0, codegen_1$l._)`${gen.scopeValue("wrapper", {
    ref: sch
  })}.validate`;
    }
    ref.getValidate = getValidate;
    function callRef(cxt, v, sch, $async) {
      const {
        gen,
        it
      } = cxt;
      const {
        allErrors,
        schemaEnv: env,
        opts
      } = it;
      const passCxt = opts.passContext ? names_1$1.default.this : codegen_1$l.nil;
      if ($async) callAsyncRef();else callSyncRef();
      function callAsyncRef() {
        if (!env.$async) throw new Error("async schema referenced by sync schema");
        const valid = gen.let("valid");
        gen.try(() => {
          gen.code((0, codegen_1$l._)`await ${(0, code_1$8.callValidateCode)(cxt, v, passCxt)}`);
          addEvaluatedFrom(v); // TODO will not work with async, it has to be returned with the result
          if (!allErrors) gen.assign(valid, true);
        }, e => {
          gen.if((0, codegen_1$l._)`!(${e} instanceof ${it.ValidationError})`, () => gen.throw(e));
          addErrorsFrom(e);
          if (!allErrors) gen.assign(valid, false);
        });
        cxt.ok(valid);
      }
      function callSyncRef() {
        cxt.result((0, code_1$8.callValidateCode)(cxt, v, passCxt), () => addEvaluatedFrom(v), () => addErrorsFrom(v));
      }
      function addErrorsFrom(source) {
        const errs = (0, codegen_1$l._)`${source}.errors`;
        gen.assign(names_1$1.default.vErrors, (0, codegen_1$l._)`${names_1$1.default.vErrors} === null ? ${errs} : ${names_1$1.default.vErrors}.concat(${errs})`); // TODO tagged
        gen.assign(names_1$1.default.errors, (0, codegen_1$l._)`${names_1$1.default.vErrors}.length`);
      }
      function addEvaluatedFrom(source) {
        var _a;
        if (!it.opts.unevaluated) return;
        const schEvaluated = (_a = sch === null || sch === void 0 ? void 0 : sch.validate) === null || _a === void 0 ? void 0 : _a.evaluated;
        // TODO refactor
        if (it.props !== true) {
          if (schEvaluated && !schEvaluated.dynamicProps) {
            if (schEvaluated.props !== undefined) {
              it.props = util_1$j.mergeEvaluated.props(gen, schEvaluated.props, it.props);
            }
          } else {
            const props = gen.var("props", (0, codegen_1$l._)`${source}.evaluated.props`);
            it.props = util_1$j.mergeEvaluated.props(gen, props, it.props, codegen_1$l.Name);
          }
        }
        if (it.items !== true) {
          if (schEvaluated && !schEvaluated.dynamicItems) {
            if (schEvaluated.items !== undefined) {
              it.items = util_1$j.mergeEvaluated.items(gen, schEvaluated.items, it.items);
            }
          } else {
            const items = gen.var("items", (0, codegen_1$l._)`${source}.evaluated.items`);
            it.items = util_1$j.mergeEvaluated.items(gen, items, it.items, codegen_1$l.Name);
          }
        }
      }
    }
    ref.callRef = callRef;
    ref.default = def$r;

    Object.defineProperty(core$1, "__esModule", {
      value: true
    });
    const id_1 = id;
    const ref_1 = ref;
    const core = ["$schema", "$id", "$defs", "$vocabulary", {
      keyword: "$comment"
    }, "definitions", id_1.default, ref_1.default];
    core$1.default = core;

    var validation$1 = {};

    var limitNumber = {};

    Object.defineProperty(limitNumber, "__esModule", {
      value: true
    });
    const codegen_1$k = /*@__PURE__*/requireCodegen();
    const ops = codegen_1$k.operators;
    const KWDs = {
      maximum: {
        okStr: "<=",
        ok: ops.LTE,
        fail: ops.GT
      },
      minimum: {
        okStr: ">=",
        ok: ops.GTE,
        fail: ops.LT
      },
      exclusiveMaximum: {
        okStr: "<",
        ok: ops.LT,
        fail: ops.GTE
      },
      exclusiveMinimum: {
        okStr: ">",
        ok: ops.GT,
        fail: ops.LTE
      }
    };
    const error$i = {
      message: ({
        keyword,
        schemaCode
      }) => (0, codegen_1$k.str)`must be ${KWDs[keyword].okStr} ${schemaCode}`,
      params: ({
        keyword,
        schemaCode
      }) => (0, codegen_1$k._)`{comparison: ${KWDs[keyword].okStr}, limit: ${schemaCode}}`
    };
    const def$q = {
      keyword: Object.keys(KWDs),
      type: "number",
      schemaType: "number",
      $data: true,
      error: error$i,
      code(cxt) {
        const {
          keyword,
          data,
          schemaCode
        } = cxt;
        cxt.fail$data((0, codegen_1$k._)`${data} ${KWDs[keyword].fail} ${schemaCode} || isNaN(${data})`);
      }
    };
    limitNumber.default = def$q;

    var multipleOf = {};

    Object.defineProperty(multipleOf, "__esModule", {
      value: true
    });
    const codegen_1$j = /*@__PURE__*/requireCodegen();
    const error$h = {
      message: ({
        schemaCode
      }) => (0, codegen_1$j.str)`must be multiple of ${schemaCode}`,
      params: ({
        schemaCode
      }) => (0, codegen_1$j._)`{multipleOf: ${schemaCode}}`
    };
    const def$p = {
      keyword: "multipleOf",
      type: "number",
      schemaType: "number",
      $data: true,
      error: error$h,
      code(cxt) {
        const {
          gen,
          data,
          schemaCode,
          it
        } = cxt;
        // const bdt = bad$DataType(schemaCode, <string>def.schemaType, $data)
        const prec = it.opts.multipleOfPrecision;
        const res = gen.let("res");
        const invalid = prec ? (0, codegen_1$j._)`Math.abs(Math.round(${res}) - ${res}) > 1e-${prec}` : (0, codegen_1$j._)`${res} !== parseInt(${res})`;
        cxt.fail$data((0, codegen_1$j._)`(${schemaCode} === 0 || (${res} = ${data}/${schemaCode}, ${invalid}))`);
      }
    };
    multipleOf.default = def$p;

    var limitLength = {};

    var ucs2length$1 = {};

    Object.defineProperty(ucs2length$1, "__esModule", {
      value: true
    });
    // https://mathiasbynens.be/notes/javascript-encoding
    // https://github.com/bestiejs/punycode.js - punycode.ucs2.decode
    function ucs2length(str) {
      const len = str.length;
      let length = 0;
      let pos = 0;
      let value;
      while (pos < len) {
        length++;
        value = str.charCodeAt(pos++);
        if (value >= 0xd800 && value <= 0xdbff && pos < len) {
          // high surrogate, and there is a next character
          value = str.charCodeAt(pos);
          if ((value & 0xfc00) === 0xdc00) pos++; // low surrogate
        }
      }
      return length;
    }
    ucs2length$1.default = ucs2length;
    ucs2length.code = 'require("ajv/dist/runtime/ucs2length").default';

    Object.defineProperty(limitLength, "__esModule", {
      value: true
    });
    const codegen_1$i = /*@__PURE__*/requireCodegen();
    const util_1$i = util;
    const ucs2length_1 = ucs2length$1;
    const error$g = {
      message({
        keyword,
        schemaCode
      }) {
        const comp = keyword === "maxLength" ? "more" : "fewer";
        return (0, codegen_1$i.str)`must NOT have ${comp} than ${schemaCode} characters`;
      },
      params: ({
        schemaCode
      }) => (0, codegen_1$i._)`{limit: ${schemaCode}}`
    };
    const def$o = {
      keyword: ["maxLength", "minLength"],
      type: "string",
      schemaType: "number",
      $data: true,
      error: error$g,
      code(cxt) {
        const {
          keyword,
          data,
          schemaCode,
          it
        } = cxt;
        const op = keyword === "maxLength" ? codegen_1$i.operators.GT : codegen_1$i.operators.LT;
        const len = it.opts.unicode === false ? (0, codegen_1$i._)`${data}.length` : (0, codegen_1$i._)`${(0, util_1$i.useFunc)(cxt.gen, ucs2length_1.default)}(${data})`;
        cxt.fail$data((0, codegen_1$i._)`${len} ${op} ${schemaCode}`);
      }
    };
    limitLength.default = def$o;

    var pattern = {};

    Object.defineProperty(pattern, "__esModule", {
      value: true
    });
    const code_1$7 = /*@__PURE__*/requireCode();
    const codegen_1$h = /*@__PURE__*/requireCodegen();
    const error$f = {
      message: ({
        schemaCode
      }) => (0, codegen_1$h.str)`must match pattern "${schemaCode}"`,
      params: ({
        schemaCode
      }) => (0, codegen_1$h._)`{pattern: ${schemaCode}}`
    };
    const def$n = {
      keyword: "pattern",
      type: "string",
      schemaType: "string",
      $data: true,
      error: error$f,
      code(cxt) {
        const {
          data,
          $data,
          schema,
          schemaCode,
          it
        } = cxt;
        // TODO regexp should be wrapped in try/catchs
        const u = it.opts.unicodeRegExp ? "u" : "";
        const regExp = $data ? (0, codegen_1$h._)`(new RegExp(${schemaCode}, ${u}))` : (0, code_1$7.usePattern)(cxt, schema);
        cxt.fail$data((0, codegen_1$h._)`!${regExp}.test(${data})`);
      }
    };
    pattern.default = def$n;

    var limitProperties = {};

    Object.defineProperty(limitProperties, "__esModule", {
      value: true
    });
    const codegen_1$g = /*@__PURE__*/requireCodegen();
    const error$e = {
      message({
        keyword,
        schemaCode
      }) {
        const comp = keyword === "maxProperties" ? "more" : "fewer";
        return (0, codegen_1$g.str)`must NOT have ${comp} than ${schemaCode} properties`;
      },
      params: ({
        schemaCode
      }) => (0, codegen_1$g._)`{limit: ${schemaCode}}`
    };
    const def$m = {
      keyword: ["maxProperties", "minProperties"],
      type: "object",
      schemaType: "number",
      $data: true,
      error: error$e,
      code(cxt) {
        const {
          keyword,
          data,
          schemaCode
        } = cxt;
        const op = keyword === "maxProperties" ? codegen_1$g.operators.GT : codegen_1$g.operators.LT;
        cxt.fail$data((0, codegen_1$g._)`Object.keys(${data}).length ${op} ${schemaCode}`);
      }
    };
    limitProperties.default = def$m;

    var required = {};

    Object.defineProperty(required, "__esModule", {
      value: true
    });
    const code_1$6 = /*@__PURE__*/requireCode();
    const codegen_1$f = /*@__PURE__*/requireCodegen();
    const util_1$h = util;
    const error$d = {
      message: ({
        params: {
          missingProperty
        }
      }) => (0, codegen_1$f.str)`must have required property '${missingProperty}'`,
      params: ({
        params: {
          missingProperty
        }
      }) => (0, codegen_1$f._)`{missingProperty: ${missingProperty}}`
    };
    const def$l = {
      keyword: "required",
      type: "object",
      schemaType: "array",
      $data: true,
      error: error$d,
      code(cxt) {
        const {
          gen,
          schema,
          schemaCode,
          data,
          $data,
          it
        } = cxt;
        const {
          opts
        } = it;
        if (!$data && schema.length === 0) return;
        const useLoop = schema.length >= opts.loopRequired;
        if (it.allErrors) allErrorsMode();else exitOnErrorMode();
        if (opts.strictRequired) {
          const props = cxt.parentSchema.properties;
          const {
            definedProperties
          } = cxt.it;
          for (const requiredKey of schema) {
            if ((props === null || props === void 0 ? void 0 : props[requiredKey]) === undefined && !definedProperties.has(requiredKey)) {
              const schemaPath = it.schemaEnv.baseId + it.errSchemaPath;
              const msg = `required property "${requiredKey}" is not defined at "${schemaPath}" (strictRequired)`;
              (0, util_1$h.checkStrictMode)(it, msg, it.opts.strictRequired);
            }
          }
        }
        function allErrorsMode() {
          if (useLoop || $data) {
            cxt.block$data(codegen_1$f.nil, loopAllRequired);
          } else {
            for (const prop of schema) {
              (0, code_1$6.checkReportMissingProp)(cxt, prop);
            }
          }
        }
        function exitOnErrorMode() {
          const missing = gen.let("missing");
          if (useLoop || $data) {
            const valid = gen.let("valid", true);
            cxt.block$data(valid, () => loopUntilMissing(missing, valid));
            cxt.ok(valid);
          } else {
            gen.if((0, code_1$6.checkMissingProp)(cxt, schema, missing));
            (0, code_1$6.reportMissingProp)(cxt, missing);
            gen.else();
          }
        }
        function loopAllRequired() {
          gen.forOf("prop", schemaCode, prop => {
            cxt.setParams({
              missingProperty: prop
            });
            gen.if((0, code_1$6.noPropertyInData)(gen, data, prop, opts.ownProperties), () => cxt.error());
          });
        }
        function loopUntilMissing(missing, valid) {
          cxt.setParams({
            missingProperty: missing
          });
          gen.forOf(missing, schemaCode, () => {
            gen.assign(valid, (0, code_1$6.propertyInData)(gen, data, missing, opts.ownProperties));
            gen.if((0, codegen_1$f.not)(valid), () => {
              cxt.error();
              gen.break();
            });
          }, codegen_1$f.nil);
        }
      }
    };
    required.default = def$l;

    var limitItems = {};

    Object.defineProperty(limitItems, "__esModule", {
      value: true
    });
    const codegen_1$e = /*@__PURE__*/requireCodegen();
    const error$c = {
      message({
        keyword,
        schemaCode
      }) {
        const comp = keyword === "maxItems" ? "more" : "fewer";
        return (0, codegen_1$e.str)`must NOT have ${comp} than ${schemaCode} items`;
      },
      params: ({
        schemaCode
      }) => (0, codegen_1$e._)`{limit: ${schemaCode}}`
    };
    const def$k = {
      keyword: ["maxItems", "minItems"],
      type: "array",
      schemaType: "number",
      $data: true,
      error: error$c,
      code(cxt) {
        const {
          keyword,
          data,
          schemaCode
        } = cxt;
        const op = keyword === "maxItems" ? codegen_1$e.operators.GT : codegen_1$e.operators.LT;
        cxt.fail$data((0, codegen_1$e._)`${data}.length ${op} ${schemaCode}`);
      }
    };
    limitItems.default = def$k;

    var uniqueItems = {};

    var equal$1 = {};

    Object.defineProperty(equal$1, "__esModule", {
      value: true
    });
    // https://github.com/ajv-validator/ajv/issues/889
    const equal = fastDeepEqual;
    equal.code = 'require("ajv/dist/runtime/equal").default';
    equal$1.default = equal;

    Object.defineProperty(uniqueItems, "__esModule", {
      value: true
    });
    const dataType_1 = dataType;
    const codegen_1$d = /*@__PURE__*/requireCodegen();
    const util_1$g = util;
    const equal_1$2 = equal$1;
    const error$b = {
      message: ({
        params: {
          i,
          j
        }
      }) => (0, codegen_1$d.str)`must NOT have duplicate items (items ## ${j} and ${i} are identical)`,
      params: ({
        params: {
          i,
          j
        }
      }) => (0, codegen_1$d._)`{i: ${i}, j: ${j}}`
    };
    const def$j = {
      keyword: "uniqueItems",
      type: "array",
      schemaType: "boolean",
      $data: true,
      error: error$b,
      code(cxt) {
        const {
          gen,
          data,
          $data,
          schema,
          parentSchema,
          schemaCode,
          it
        } = cxt;
        if (!$data && !schema) return;
        const valid = gen.let("valid");
        const itemTypes = parentSchema.items ? (0, dataType_1.getSchemaTypes)(parentSchema.items) : [];
        cxt.block$data(valid, validateUniqueItems, (0, codegen_1$d._)`${schemaCode} === false`);
        cxt.ok(valid);
        function validateUniqueItems() {
          const i = gen.let("i", (0, codegen_1$d._)`${data}.length`);
          const j = gen.let("j");
          cxt.setParams({
            i,
            j
          });
          gen.assign(valid, true);
          gen.if((0, codegen_1$d._)`${i} > 1`, () => (canOptimize() ? loopN : loopN2)(i, j));
        }
        function canOptimize() {
          return itemTypes.length > 0 && !itemTypes.some(t => t === "object" || t === "array");
        }
        function loopN(i, j) {
          const item = gen.name("item");
          const wrongType = (0, dataType_1.checkDataTypes)(itemTypes, item, it.opts.strictNumbers, dataType_1.DataType.Wrong);
          const indices = gen.const("indices", (0, codegen_1$d._)`{}`);
          gen.for((0, codegen_1$d._)`;${i}--;`, () => {
            gen.let(item, (0, codegen_1$d._)`${data}[${i}]`);
            gen.if(wrongType, (0, codegen_1$d._)`continue`);
            if (itemTypes.length > 1) gen.if((0, codegen_1$d._)`typeof ${item} == "string"`, (0, codegen_1$d._)`${item} += "_"`);
            gen.if((0, codegen_1$d._)`typeof ${indices}[${item}] == "number"`, () => {
              gen.assign(j, (0, codegen_1$d._)`${indices}[${item}]`);
              cxt.error();
              gen.assign(valid, false).break();
            }).code((0, codegen_1$d._)`${indices}[${item}] = ${i}`);
          });
        }
        function loopN2(i, j) {
          const eql = (0, util_1$g.useFunc)(gen, equal_1$2.default);
          const outer = gen.name("outer");
          gen.label(outer).for((0, codegen_1$d._)`;${i}--;`, () => gen.for((0, codegen_1$d._)`${j} = ${i}; ${j}--;`, () => gen.if((0, codegen_1$d._)`${eql}(${data}[${i}], ${data}[${j}])`, () => {
            cxt.error();
            gen.assign(valid, false).break(outer);
          })));
        }
      }
    };
    uniqueItems.default = def$j;

    var _const = {};

    Object.defineProperty(_const, "__esModule", {
      value: true
    });
    const codegen_1$c = /*@__PURE__*/requireCodegen();
    const util_1$f = util;
    const equal_1$1 = equal$1;
    const error$a = {
      message: "must be equal to constant",
      params: ({
        schemaCode
      }) => (0, codegen_1$c._)`{allowedValue: ${schemaCode}}`
    };
    const def$i = {
      keyword: "const",
      $data: true,
      error: error$a,
      code(cxt) {
        const {
          gen,
          data,
          $data,
          schemaCode,
          schema
        } = cxt;
        if ($data || schema && typeof schema == "object") {
          cxt.fail$data((0, codegen_1$c._)`!${(0, util_1$f.useFunc)(gen, equal_1$1.default)}(${data}, ${schemaCode})`);
        } else {
          cxt.fail((0, codegen_1$c._)`${schema} !== ${data}`);
        }
      }
    };
    _const.default = def$i;

    var _enum = {};

    Object.defineProperty(_enum, "__esModule", {
      value: true
    });
    const codegen_1$b = /*@__PURE__*/requireCodegen();
    const util_1$e = util;
    const equal_1 = equal$1;
    const error$9 = {
      message: "must be equal to one of the allowed values",
      params: ({
        schemaCode
      }) => (0, codegen_1$b._)`{allowedValues: ${schemaCode}}`
    };
    const def$h = {
      keyword: "enum",
      schemaType: "array",
      $data: true,
      error: error$9,
      code(cxt) {
        const {
          gen,
          data,
          $data,
          schema,
          schemaCode,
          it
        } = cxt;
        if (!$data && schema.length === 0) throw new Error("enum must have non-empty array");
        const useLoop = schema.length >= it.opts.loopEnum;
        let eql;
        const getEql = () => eql !== null && eql !== void 0 ? eql : eql = (0, util_1$e.useFunc)(gen, equal_1.default);
        let valid;
        if (useLoop || $data) {
          valid = gen.let("valid");
          cxt.block$data(valid, loopEnum);
        } else {
          /* istanbul ignore if */
          if (!Array.isArray(schema)) throw new Error("ajv implementation error");
          const vSchema = gen.const("vSchema", schemaCode);
          valid = (0, codegen_1$b.or)(...schema.map((_x, i) => equalCode(vSchema, i)));
        }
        cxt.pass(valid);
        function loopEnum() {
          gen.assign(valid, false);
          gen.forOf("v", schemaCode, v => gen.if((0, codegen_1$b._)`${getEql()}(${data}, ${v})`, () => gen.assign(valid, true).break()));
        }
        function equalCode(vSchema, i) {
          const sch = schema[i];
          return typeof sch === "object" && sch !== null ? (0, codegen_1$b._)`${getEql()}(${data}, ${vSchema}[${i}])` : (0, codegen_1$b._)`${data} === ${sch}`;
        }
      }
    };
    _enum.default = def$h;

    Object.defineProperty(validation$1, "__esModule", {
      value: true
    });
    const limitNumber_1 = limitNumber;
    const multipleOf_1 = multipleOf;
    const limitLength_1 = limitLength;
    const pattern_1 = pattern;
    const limitProperties_1 = limitProperties;
    const required_1 = required;
    const limitItems_1 = limitItems;
    const uniqueItems_1 = uniqueItems;
    const const_1 = _const;
    const enum_1 = _enum;
    const validation = [
    // number
    limitNumber_1.default, multipleOf_1.default,
    // string
    limitLength_1.default, pattern_1.default,
    // object
    limitProperties_1.default, required_1.default,
    // array
    limitItems_1.default, uniqueItems_1.default,
    // any
    {
      keyword: "type",
      schemaType: ["string", "array"]
    }, {
      keyword: "nullable",
      schemaType: "boolean"
    }, const_1.default, enum_1.default];
    validation$1.default = validation;

    var applicator = {};

    var additionalItems = {};

    Object.defineProperty(additionalItems, "__esModule", {
      value: true
    });
    additionalItems.validateAdditionalItems = void 0;
    const codegen_1$a = /*@__PURE__*/requireCodegen();
    const util_1$d = util;
    const error$8 = {
      message: ({
        params: {
          len
        }
      }) => (0, codegen_1$a.str)`must NOT have more than ${len} items`,
      params: ({
        params: {
          len
        }
      }) => (0, codegen_1$a._)`{limit: ${len}}`
    };
    const def$g = {
      keyword: "additionalItems",
      type: "array",
      schemaType: ["boolean", "object"],
      before: "uniqueItems",
      error: error$8,
      code(cxt) {
        const {
          parentSchema,
          it
        } = cxt;
        const {
          items
        } = parentSchema;
        if (!Array.isArray(items)) {
          (0, util_1$d.checkStrictMode)(it, '"additionalItems" is ignored when "items" is not an array of schemas');
          return;
        }
        validateAdditionalItems(cxt, items);
      }
    };
    function validateAdditionalItems(cxt, items) {
      const {
        gen,
        schema,
        data,
        keyword,
        it
      } = cxt;
      it.items = true;
      const len = gen.const("len", (0, codegen_1$a._)`${data}.length`);
      if (schema === false) {
        cxt.setParams({
          len: items.length
        });
        cxt.pass((0, codegen_1$a._)`${len} <= ${items.length}`);
      } else if (typeof schema == "object" && !(0, util_1$d.alwaysValidSchema)(it, schema)) {
        const valid = gen.var("valid", (0, codegen_1$a._)`${len} <= ${items.length}`); // TODO var
        gen.if((0, codegen_1$a.not)(valid), () => validateItems(valid));
        cxt.ok(valid);
      }
      function validateItems(valid) {
        gen.forRange("i", items.length, len, i => {
          cxt.subschema({
            keyword,
            dataProp: i,
            dataPropType: util_1$d.Type.Num
          }, valid);
          if (!it.allErrors) gen.if((0, codegen_1$a.not)(valid), () => gen.break());
        });
      }
    }
    additionalItems.validateAdditionalItems = validateAdditionalItems;
    additionalItems.default = def$g;

    var prefixItems = {};

    var items = {};

    Object.defineProperty(items, "__esModule", {
      value: true
    });
    items.validateTuple = void 0;
    const codegen_1$9 = /*@__PURE__*/requireCodegen();
    const util_1$c = util;
    const code_1$5 = /*@__PURE__*/requireCode();
    const def$f = {
      keyword: "items",
      type: "array",
      schemaType: ["object", "array", "boolean"],
      before: "uniqueItems",
      code(cxt) {
        const {
          schema,
          it
        } = cxt;
        if (Array.isArray(schema)) return validateTuple(cxt, "additionalItems", schema);
        it.items = true;
        if ((0, util_1$c.alwaysValidSchema)(it, schema)) return;
        cxt.ok((0, code_1$5.validateArray)(cxt));
      }
    };
    function validateTuple(cxt, extraItems, schArr = cxt.schema) {
      const {
        gen,
        parentSchema,
        data,
        keyword,
        it
      } = cxt;
      checkStrictTuple(parentSchema);
      if (it.opts.unevaluated && schArr.length && it.items !== true) {
        it.items = util_1$c.mergeEvaluated.items(gen, schArr.length, it.items);
      }
      const valid = gen.name("valid");
      const len = gen.const("len", (0, codegen_1$9._)`${data}.length`);
      schArr.forEach((sch, i) => {
        if ((0, util_1$c.alwaysValidSchema)(it, sch)) return;
        gen.if((0, codegen_1$9._)`${len} > ${i}`, () => cxt.subschema({
          keyword,
          schemaProp: i,
          dataProp: i
        }, valid));
        cxt.ok(valid);
      });
      function checkStrictTuple(sch) {
        const {
          opts,
          errSchemaPath
        } = it;
        const l = schArr.length;
        const fullTuple = l === sch.minItems && (l === sch.maxItems || sch[extraItems] === false);
        if (opts.strictTuples && !fullTuple) {
          const msg = `"${keyword}" is ${l}-tuple, but minItems or maxItems/${extraItems} are not specified or different at path "${errSchemaPath}"`;
          (0, util_1$c.checkStrictMode)(it, msg, opts.strictTuples);
        }
      }
    }
    items.validateTuple = validateTuple;
    items.default = def$f;

    Object.defineProperty(prefixItems, "__esModule", {
      value: true
    });
    const items_1$1 = items;
    const def$e = {
      keyword: "prefixItems",
      type: "array",
      schemaType: ["array"],
      before: "uniqueItems",
      code: cxt => (0, items_1$1.validateTuple)(cxt, "items")
    };
    prefixItems.default = def$e;

    var items2020 = {};

    Object.defineProperty(items2020, "__esModule", {
      value: true
    });
    const codegen_1$8 = /*@__PURE__*/requireCodegen();
    const util_1$b = util;
    const code_1$4 = /*@__PURE__*/requireCode();
    const additionalItems_1$1 = additionalItems;
    const error$7 = {
      message: ({
        params: {
          len
        }
      }) => (0, codegen_1$8.str)`must NOT have more than ${len} items`,
      params: ({
        params: {
          len
        }
      }) => (0, codegen_1$8._)`{limit: ${len}}`
    };
    const def$d = {
      keyword: "items",
      type: "array",
      schemaType: ["object", "boolean"],
      before: "uniqueItems",
      error: error$7,
      code(cxt) {
        const {
          schema,
          parentSchema,
          it
        } = cxt;
        const {
          prefixItems
        } = parentSchema;
        it.items = true;
        if ((0, util_1$b.alwaysValidSchema)(it, schema)) return;
        if (prefixItems) (0, additionalItems_1$1.validateAdditionalItems)(cxt, prefixItems);else cxt.ok((0, code_1$4.validateArray)(cxt));
      }
    };
    items2020.default = def$d;

    var contains = {};

    Object.defineProperty(contains, "__esModule", {
      value: true
    });
    const codegen_1$7 = /*@__PURE__*/requireCodegen();
    const util_1$a = util;
    const error$6 = {
      message: ({
        params: {
          min,
          max
        }
      }) => max === undefined ? (0, codegen_1$7.str)`must contain at least ${min} valid item(s)` : (0, codegen_1$7.str)`must contain at least ${min} and no more than ${max} valid item(s)`,
      params: ({
        params: {
          min,
          max
        }
      }) => max === undefined ? (0, codegen_1$7._)`{minContains: ${min}}` : (0, codegen_1$7._)`{minContains: ${min}, maxContains: ${max}}`
    };
    const def$c = {
      keyword: "contains",
      type: "array",
      schemaType: ["object", "boolean"],
      before: "uniqueItems",
      trackErrors: true,
      error: error$6,
      code(cxt) {
        const {
          gen,
          schema,
          parentSchema,
          data,
          it
        } = cxt;
        let min;
        let max;
        const {
          minContains,
          maxContains
        } = parentSchema;
        if (it.opts.next) {
          min = minContains === undefined ? 1 : minContains;
          max = maxContains;
        } else {
          min = 1;
        }
        const len = gen.const("len", (0, codegen_1$7._)`${data}.length`);
        cxt.setParams({
          min,
          max
        });
        if (max === undefined && min === 0) {
          (0, util_1$a.checkStrictMode)(it, `"minContains" == 0 without "maxContains": "contains" keyword ignored`);
          return;
        }
        if (max !== undefined && min > max) {
          (0, util_1$a.checkStrictMode)(it, `"minContains" > "maxContains" is always invalid`);
          cxt.fail();
          return;
        }
        if ((0, util_1$a.alwaysValidSchema)(it, schema)) {
          let cond = (0, codegen_1$7._)`${len} >= ${min}`;
          if (max !== undefined) cond = (0, codegen_1$7._)`${cond} && ${len} <= ${max}`;
          cxt.pass(cond);
          return;
        }
        it.items = true;
        const valid = gen.name("valid");
        if (max === undefined && min === 1) {
          validateItems(valid, () => gen.if(valid, () => gen.break()));
        } else if (min === 0) {
          gen.let(valid, true);
          if (max !== undefined) gen.if((0, codegen_1$7._)`${data}.length > 0`, validateItemsWithCount);
        } else {
          gen.let(valid, false);
          validateItemsWithCount();
        }
        cxt.result(valid, () => cxt.reset());
        function validateItemsWithCount() {
          const schValid = gen.name("_valid");
          const count = gen.let("count", 0);
          validateItems(schValid, () => gen.if(schValid, () => checkLimits(count)));
        }
        function validateItems(_valid, block) {
          gen.forRange("i", 0, len, i => {
            cxt.subschema({
              keyword: "contains",
              dataProp: i,
              dataPropType: util_1$a.Type.Num,
              compositeRule: true
            }, _valid);
            block();
          });
        }
        function checkLimits(count) {
          gen.code((0, codegen_1$7._)`${count}++`);
          if (max === undefined) {
            gen.if((0, codegen_1$7._)`${count} >= ${min}`, () => gen.assign(valid, true).break());
          } else {
            gen.if((0, codegen_1$7._)`${count} > ${max}`, () => gen.assign(valid, false).break());
            if (min === 1) gen.assign(valid, true);else gen.if((0, codegen_1$7._)`${count} >= ${min}`, () => gen.assign(valid, true));
          }
        }
      }
    };
    contains.default = def$c;

    var dependencies = {};

    (function (exports) {

      Object.defineProperty(exports, "__esModule", {
        value: true
      });
      exports.validateSchemaDeps = exports.validatePropertyDeps = exports.error = void 0;
      const codegen_1 = /*@__PURE__*/requireCodegen();
      const util_1 = util;
      const code_1 = /*@__PURE__*/requireCode();
      exports.error = {
        message: ({
          params: {
            property,
            depsCount,
            deps
          }
        }) => {
          const property_ies = depsCount === 1 ? "property" : "properties";
          return (0, codegen_1.str)`must have ${property_ies} ${deps} when property ${property} is present`;
        },
        params: ({
          params: {
            property,
            depsCount,
            deps,
            missingProperty
          }
        }) => (0, codegen_1._)`{property: ${property},
    missingProperty: ${missingProperty},
    depsCount: ${depsCount},
    deps: ${deps}}` // TODO change to reference
      };
      const def = {
        keyword: "dependencies",
        type: "object",
        schemaType: "object",
        error: exports.error,
        code(cxt) {
          const [propDeps, schDeps] = splitDependencies(cxt);
          validatePropertyDeps(cxt, propDeps);
          validateSchemaDeps(cxt, schDeps);
        }
      };
      function splitDependencies({
        schema
      }) {
        const propertyDeps = {};
        const schemaDeps = {};
        for (const key in schema) {
          if (key === "__proto__") continue;
          const deps = Array.isArray(schema[key]) ? propertyDeps : schemaDeps;
          deps[key] = schema[key];
        }
        return [propertyDeps, schemaDeps];
      }
      function validatePropertyDeps(cxt, propertyDeps = cxt.schema) {
        const {
          gen,
          data,
          it
        } = cxt;
        if (Object.keys(propertyDeps).length === 0) return;
        const missing = gen.let("missing");
        for (const prop in propertyDeps) {
          const deps = propertyDeps[prop];
          if (deps.length === 0) continue;
          const hasProperty = (0, code_1.propertyInData)(gen, data, prop, it.opts.ownProperties);
          cxt.setParams({
            property: prop,
            depsCount: deps.length,
            deps: deps.join(", ")
          });
          if (it.allErrors) {
            gen.if(hasProperty, () => {
              for (const depProp of deps) {
                (0, code_1.checkReportMissingProp)(cxt, depProp);
              }
            });
          } else {
            gen.if((0, codegen_1._)`${hasProperty} && (${(0, code_1.checkMissingProp)(cxt, deps, missing)})`);
            (0, code_1.reportMissingProp)(cxt, missing);
            gen.else();
          }
        }
      }
      exports.validatePropertyDeps = validatePropertyDeps;
      function validateSchemaDeps(cxt, schemaDeps = cxt.schema) {
        const {
          gen,
          data,
          keyword,
          it
        } = cxt;
        const valid = gen.name("valid");
        for (const prop in schemaDeps) {
          if ((0, util_1.alwaysValidSchema)(it, schemaDeps[prop])) continue;
          gen.if((0, code_1.propertyInData)(gen, data, prop, it.opts.ownProperties), () => {
            const schCxt = cxt.subschema({
              keyword,
              schemaProp: prop
            }, valid);
            cxt.mergeValidEvaluated(schCxt, valid);
          }, () => gen.var(valid, true) // TODO var
          );
          cxt.ok(valid);
        }
      }
      exports.validateSchemaDeps = validateSchemaDeps;
      exports.default = def;
    })(dependencies);

    var propertyNames = {};

    Object.defineProperty(propertyNames, "__esModule", {
      value: true
    });
    const codegen_1$6 = /*@__PURE__*/requireCodegen();
    const util_1$9 = util;
    const error$5 = {
      message: "property name must be valid",
      params: ({
        params
      }) => (0, codegen_1$6._)`{propertyName: ${params.propertyName}}`
    };
    const def$b = {
      keyword: "propertyNames",
      type: "object",
      schemaType: ["object", "boolean"],
      error: error$5,
      code(cxt) {
        const {
          gen,
          schema,
          data,
          it
        } = cxt;
        if ((0, util_1$9.alwaysValidSchema)(it, schema)) return;
        const valid = gen.name("valid");
        gen.forIn("key", data, key => {
          cxt.setParams({
            propertyName: key
          });
          cxt.subschema({
            keyword: "propertyNames",
            data: key,
            dataTypes: ["string"],
            propertyName: key,
            compositeRule: true
          }, valid);
          gen.if((0, codegen_1$6.not)(valid), () => {
            cxt.error(true);
            if (!it.allErrors) gen.break();
          });
        });
        cxt.ok(valid);
      }
    };
    propertyNames.default = def$b;

    var additionalProperties = {};

    Object.defineProperty(additionalProperties, "__esModule", {
      value: true
    });
    const code_1$3 = /*@__PURE__*/requireCode();
    const codegen_1$5 = /*@__PURE__*/requireCodegen();
    const names_1 = /*@__PURE__*/requireNames();
    const util_1$8 = util;
    const error$4 = {
      message: "must NOT have additional properties",
      params: ({
        params
      }) => (0, codegen_1$5._)`{additionalProperty: ${params.additionalProperty}}`
    };
    const def$a = {
      keyword: "additionalProperties",
      type: ["object"],
      schemaType: ["boolean", "object"],
      allowUndefined: true,
      trackErrors: true,
      error: error$4,
      code(cxt) {
        const {
          gen,
          schema,
          parentSchema,
          data,
          errsCount,
          it
        } = cxt;
        /* istanbul ignore if */
        if (!errsCount) throw new Error("ajv implementation error");
        const {
          allErrors,
          opts
        } = it;
        it.props = true;
        if (opts.removeAdditional !== "all" && (0, util_1$8.alwaysValidSchema)(it, schema)) return;
        const props = (0, code_1$3.allSchemaProperties)(parentSchema.properties);
        const patProps = (0, code_1$3.allSchemaProperties)(parentSchema.patternProperties);
        checkAdditionalProperties();
        cxt.ok((0, codegen_1$5._)`${errsCount} === ${names_1.default.errors}`);
        function checkAdditionalProperties() {
          gen.forIn("key", data, key => {
            if (!props.length && !patProps.length) additionalPropertyCode(key);else gen.if(isAdditional(key), () => additionalPropertyCode(key));
          });
        }
        function isAdditional(key) {
          let definedProp;
          if (props.length > 8) {
            // TODO maybe an option instead of hard-coded 8?
            const propsSchema = (0, util_1$8.schemaRefOrVal)(it, parentSchema.properties, "properties");
            definedProp = (0, code_1$3.isOwnProperty)(gen, propsSchema, key);
          } else if (props.length) {
            definedProp = (0, codegen_1$5.or)(...props.map(p => (0, codegen_1$5._)`${key} === ${p}`));
          } else {
            definedProp = codegen_1$5.nil;
          }
          if (patProps.length) {
            definedProp = (0, codegen_1$5.or)(definedProp, ...patProps.map(p => (0, codegen_1$5._)`${(0, code_1$3.usePattern)(cxt, p)}.test(${key})`));
          }
          return (0, codegen_1$5.not)(definedProp);
        }
        function deleteAdditional(key) {
          gen.code((0, codegen_1$5._)`delete ${data}[${key}]`);
        }
        function additionalPropertyCode(key) {
          if (opts.removeAdditional === "all" || opts.removeAdditional && schema === false) {
            deleteAdditional(key);
            return;
          }
          if (schema === false) {
            cxt.setParams({
              additionalProperty: key
            });
            cxt.error();
            if (!allErrors) gen.break();
            return;
          }
          if (typeof schema == "object" && !(0, util_1$8.alwaysValidSchema)(it, schema)) {
            const valid = gen.name("valid");
            if (opts.removeAdditional === "failing") {
              applyAdditionalSchema(key, valid, false);
              gen.if((0, codegen_1$5.not)(valid), () => {
                cxt.reset();
                deleteAdditional(key);
              });
            } else {
              applyAdditionalSchema(key, valid);
              if (!allErrors) gen.if((0, codegen_1$5.not)(valid), () => gen.break());
            }
          }
        }
        function applyAdditionalSchema(key, valid, errors) {
          const subschema = {
            keyword: "additionalProperties",
            dataProp: key,
            dataPropType: util_1$8.Type.Str
          };
          if (errors === false) {
            Object.assign(subschema, {
              compositeRule: true,
              createErrors: false,
              allErrors: false
            });
          }
          cxt.subschema(subschema, valid);
        }
      }
    };
    additionalProperties.default = def$a;

    var properties$1 = {};

    Object.defineProperty(properties$1, "__esModule", {
      value: true
    });
    const validate_1 = /*@__PURE__*/requireValidate();
    const code_1$2 = /*@__PURE__*/requireCode();
    const util_1$7 = util;
    const additionalProperties_1$1 = additionalProperties;
    const def$9 = {
      keyword: "properties",
      type: "object",
      schemaType: "object",
      code(cxt) {
        const {
          gen,
          schema,
          parentSchema,
          data,
          it
        } = cxt;
        if (it.opts.removeAdditional === "all" && parentSchema.additionalProperties === undefined) {
          additionalProperties_1$1.default.code(new validate_1.KeywordCxt(it, additionalProperties_1$1.default, "additionalProperties"));
        }
        const allProps = (0, code_1$2.allSchemaProperties)(schema);
        for (const prop of allProps) {
          it.definedProperties.add(prop);
        }
        if (it.opts.unevaluated && allProps.length && it.props !== true) {
          it.props = util_1$7.mergeEvaluated.props(gen, (0, util_1$7.toHash)(allProps), it.props);
        }
        const properties = allProps.filter(p => !(0, util_1$7.alwaysValidSchema)(it, schema[p]));
        if (properties.length === 0) return;
        const valid = gen.name("valid");
        for (const prop of properties) {
          if (hasDefault(prop)) {
            applyPropertySchema(prop);
          } else {
            gen.if((0, code_1$2.propertyInData)(gen, data, prop, it.opts.ownProperties));
            applyPropertySchema(prop);
            if (!it.allErrors) gen.else().var(valid, true);
            gen.endIf();
          }
          cxt.it.definedProperties.add(prop);
          cxt.ok(valid);
        }
        function hasDefault(prop) {
          return it.opts.useDefaults && !it.compositeRule && schema[prop].default !== undefined;
        }
        function applyPropertySchema(prop) {
          cxt.subschema({
            keyword: "properties",
            schemaProp: prop,
            dataProp: prop
          }, valid);
        }
      }
    };
    properties$1.default = def$9;

    var patternProperties = {};

    Object.defineProperty(patternProperties, "__esModule", {
      value: true
    });
    const code_1$1 = /*@__PURE__*/requireCode();
    const codegen_1$4 = /*@__PURE__*/requireCodegen();
    const util_1$6 = util;
    const util_2 = util;
    const def$8 = {
      keyword: "patternProperties",
      type: "object",
      schemaType: "object",
      code(cxt) {
        const {
          gen,
          schema,
          data,
          parentSchema,
          it
        } = cxt;
        const {
          opts
        } = it;
        const patterns = (0, code_1$1.allSchemaProperties)(schema);
        const alwaysValidPatterns = patterns.filter(p => (0, util_1$6.alwaysValidSchema)(it, schema[p]));
        if (patterns.length === 0 || alwaysValidPatterns.length === patterns.length && (!it.opts.unevaluated || it.props === true)) {
          return;
        }
        const checkProperties = opts.strictSchema && !opts.allowMatchingProperties && parentSchema.properties;
        const valid = gen.name("valid");
        if (it.props !== true && !(it.props instanceof codegen_1$4.Name)) {
          it.props = (0, util_2.evaluatedPropsToName)(gen, it.props);
        }
        const {
          props
        } = it;
        validatePatternProperties();
        function validatePatternProperties() {
          for (const pat of patterns) {
            if (checkProperties) checkMatchingProperties(pat);
            if (it.allErrors) {
              validateProperties(pat);
            } else {
              gen.var(valid, true); // TODO var
              validateProperties(pat);
              gen.if(valid);
            }
          }
        }
        function checkMatchingProperties(pat) {
          for (const prop in checkProperties) {
            if (new RegExp(pat).test(prop)) {
              (0, util_1$6.checkStrictMode)(it, `property ${prop} matches pattern ${pat} (use allowMatchingProperties)`);
            }
          }
        }
        function validateProperties(pat) {
          gen.forIn("key", data, key => {
            gen.if((0, codegen_1$4._)`${(0, code_1$1.usePattern)(cxt, pat)}.test(${key})`, () => {
              const alwaysValid = alwaysValidPatterns.includes(pat);
              if (!alwaysValid) {
                cxt.subschema({
                  keyword: "patternProperties",
                  schemaProp: pat,
                  dataProp: key,
                  dataPropType: util_2.Type.Str
                }, valid);
              }
              if (it.opts.unevaluated && props !== true) {
                gen.assign((0, codegen_1$4._)`${props}[${key}]`, true);
              } else if (!alwaysValid && !it.allErrors) {
                // can short-circuit if `unevaluatedProperties` is not supported (opts.next === false)
                // or if all properties were evaluated (props === true)
                gen.if((0, codegen_1$4.not)(valid), () => gen.break());
              }
            });
          });
        }
      }
    };
    patternProperties.default = def$8;

    var not = {};

    Object.defineProperty(not, "__esModule", {
      value: true
    });
    const util_1$5 = util;
    const def$7 = {
      keyword: "not",
      schemaType: ["object", "boolean"],
      trackErrors: true,
      code(cxt) {
        const {
          gen,
          schema,
          it
        } = cxt;
        if ((0, util_1$5.alwaysValidSchema)(it, schema)) {
          cxt.fail();
          return;
        }
        const valid = gen.name("valid");
        cxt.subschema({
          keyword: "not",
          compositeRule: true,
          createErrors: false,
          allErrors: false
        }, valid);
        cxt.failResult(valid, () => cxt.reset(), () => cxt.error());
      },
      error: {
        message: "must NOT be valid"
      }
    };
    not.default = def$7;

    var anyOf = {};

    Object.defineProperty(anyOf, "__esModule", {
      value: true
    });
    const code_1 = /*@__PURE__*/requireCode();
    const def$6 = {
      keyword: "anyOf",
      schemaType: "array",
      trackErrors: true,
      code: code_1.validateUnion,
      error: {
        message: "must match a schema in anyOf"
      }
    };
    anyOf.default = def$6;

    var oneOf = {};

    Object.defineProperty(oneOf, "__esModule", {
      value: true
    });
    const codegen_1$3 = /*@__PURE__*/requireCodegen();
    const util_1$4 = util;
    const error$3 = {
      message: "must match exactly one schema in oneOf",
      params: ({
        params
      }) => (0, codegen_1$3._)`{passingSchemas: ${params.passing}}`
    };
    const def$5 = {
      keyword: "oneOf",
      schemaType: "array",
      trackErrors: true,
      error: error$3,
      code(cxt) {
        const {
          gen,
          schema,
          parentSchema,
          it
        } = cxt;
        /* istanbul ignore if */
        if (!Array.isArray(schema)) throw new Error("ajv implementation error");
        if (it.opts.discriminator && parentSchema.discriminator) return;
        const schArr = schema;
        const valid = gen.let("valid", false);
        const passing = gen.let("passing", null);
        const schValid = gen.name("_valid");
        cxt.setParams({
          passing
        });
        // TODO possibly fail straight away (with warning or exception) if there are two empty always valid schemas
        gen.block(validateOneOf);
        cxt.result(valid, () => cxt.reset(), () => cxt.error(true));
        function validateOneOf() {
          schArr.forEach((sch, i) => {
            let schCxt;
            if ((0, util_1$4.alwaysValidSchema)(it, sch)) {
              gen.var(schValid, true);
            } else {
              schCxt = cxt.subschema({
                keyword: "oneOf",
                schemaProp: i,
                compositeRule: true
              }, schValid);
            }
            if (i > 0) {
              gen.if((0, codegen_1$3._)`${schValid} && ${valid}`).assign(valid, false).assign(passing, (0, codegen_1$3._)`[${passing}, ${i}]`).else();
            }
            gen.if(schValid, () => {
              gen.assign(valid, true);
              gen.assign(passing, i);
              if (schCxt) cxt.mergeEvaluated(schCxt, codegen_1$3.Name);
            });
          });
        }
      }
    };
    oneOf.default = def$5;

    var allOf = {};

    Object.defineProperty(allOf, "__esModule", {
      value: true
    });
    const util_1$3 = util;
    const def$4 = {
      keyword: "allOf",
      schemaType: "array",
      code(cxt) {
        const {
          gen,
          schema,
          it
        } = cxt;
        /* istanbul ignore if */
        if (!Array.isArray(schema)) throw new Error("ajv implementation error");
        const valid = gen.name("valid");
        schema.forEach((sch, i) => {
          if ((0, util_1$3.alwaysValidSchema)(it, sch)) return;
          const schCxt = cxt.subschema({
            keyword: "allOf",
            schemaProp: i
          }, valid);
          cxt.ok(valid);
          cxt.mergeEvaluated(schCxt);
        });
      }
    };
    allOf.default = def$4;

    var _if = {};

    Object.defineProperty(_if, "__esModule", {
      value: true
    });
    const codegen_1$2 = /*@__PURE__*/requireCodegen();
    const util_1$2 = util;
    const error$2 = {
      message: ({
        params
      }) => (0, codegen_1$2.str)`must match "${params.ifClause}" schema`,
      params: ({
        params
      }) => (0, codegen_1$2._)`{failingKeyword: ${params.ifClause}}`
    };
    const def$3 = {
      keyword: "if",
      schemaType: ["object", "boolean"],
      trackErrors: true,
      error: error$2,
      code(cxt) {
        const {
          gen,
          parentSchema,
          it
        } = cxt;
        if (parentSchema.then === undefined && parentSchema.else === undefined) {
          (0, util_1$2.checkStrictMode)(it, '"if" without "then" and "else" is ignored');
        }
        const hasThen = hasSchema(it, "then");
        const hasElse = hasSchema(it, "else");
        if (!hasThen && !hasElse) return;
        const valid = gen.let("valid", true);
        const schValid = gen.name("_valid");
        validateIf();
        cxt.reset();
        if (hasThen && hasElse) {
          const ifClause = gen.let("ifClause");
          cxt.setParams({
            ifClause
          });
          gen.if(schValid, validateClause("then", ifClause), validateClause("else", ifClause));
        } else if (hasThen) {
          gen.if(schValid, validateClause("then"));
        } else {
          gen.if((0, codegen_1$2.not)(schValid), validateClause("else"));
        }
        cxt.pass(valid, () => cxt.error(true));
        function validateIf() {
          const schCxt = cxt.subschema({
            keyword: "if",
            compositeRule: true,
            createErrors: false,
            allErrors: false
          }, schValid);
          cxt.mergeEvaluated(schCxt);
        }
        function validateClause(keyword, ifClause) {
          return () => {
            const schCxt = cxt.subschema({
              keyword
            }, schValid);
            gen.assign(valid, schValid);
            cxt.mergeValidEvaluated(schCxt, valid);
            if (ifClause) gen.assign(ifClause, (0, codegen_1$2._)`${keyword}`);else cxt.setParams({
              ifClause: keyword
            });
          };
        }
      }
    };
    function hasSchema(it, keyword) {
      const schema = it.schema[keyword];
      return schema !== undefined && !(0, util_1$2.alwaysValidSchema)(it, schema);
    }
    _if.default = def$3;

    var thenElse = {};

    Object.defineProperty(thenElse, "__esModule", {
      value: true
    });
    const util_1$1 = util;
    const def$2 = {
      keyword: ["then", "else"],
      schemaType: ["object", "boolean"],
      code({
        keyword,
        parentSchema,
        it
      }) {
        if (parentSchema.if === undefined) (0, util_1$1.checkStrictMode)(it, `"${keyword}" without "if" is ignored`);
      }
    };
    thenElse.default = def$2;

    Object.defineProperty(applicator, "__esModule", {
      value: true
    });
    const additionalItems_1 = additionalItems;
    const prefixItems_1 = prefixItems;
    const items_1 = items;
    const items2020_1 = items2020;
    const contains_1 = contains;
    const dependencies_1 = dependencies;
    const propertyNames_1 = propertyNames;
    const additionalProperties_1 = additionalProperties;
    const properties_1 = properties$1;
    const patternProperties_1 = patternProperties;
    const not_1 = not;
    const anyOf_1 = anyOf;
    const oneOf_1 = oneOf;
    const allOf_1 = allOf;
    const if_1 = _if;
    const thenElse_1 = thenElse;
    function getApplicator(draft2020 = false) {
      const applicator = [
      // any
      not_1.default, anyOf_1.default, oneOf_1.default, allOf_1.default, if_1.default, thenElse_1.default,
      // object
      propertyNames_1.default, additionalProperties_1.default, dependencies_1.default, properties_1.default, patternProperties_1.default];
      // array
      if (draft2020) applicator.push(prefixItems_1.default, items2020_1.default);else applicator.push(additionalItems_1.default, items_1.default);
      applicator.push(contains_1.default);
      return applicator;
    }
    applicator.default = getApplicator;

    var format$2 = {};

    var format$1 = {};

    Object.defineProperty(format$1, "__esModule", {
      value: true
    });
    const codegen_1$1 = /*@__PURE__*/requireCodegen();
    const error$1 = {
      message: ({
        schemaCode
      }) => (0, codegen_1$1.str)`must match format "${schemaCode}"`,
      params: ({
        schemaCode
      }) => (0, codegen_1$1._)`{format: ${schemaCode}}`
    };
    const def$1 = {
      keyword: "format",
      type: ["number", "string"],
      schemaType: "string",
      $data: true,
      error: error$1,
      code(cxt, ruleType) {
        const {
          gen,
          data,
          $data,
          schema,
          schemaCode,
          it
        } = cxt;
        const {
          opts,
          errSchemaPath,
          schemaEnv,
          self
        } = it;
        if (!opts.validateFormats) return;
        if ($data) validate$DataFormat();else validateFormat();
        function validate$DataFormat() {
          const fmts = gen.scopeValue("formats", {
            ref: self.formats,
            code: opts.code.formats
          });
          const fDef = gen.const("fDef", (0, codegen_1$1._)`${fmts}[${schemaCode}]`);
          const fType = gen.let("fType");
          const format = gen.let("format");
          // TODO simplify
          gen.if((0, codegen_1$1._)`typeof ${fDef} == "object" && !(${fDef} instanceof RegExp)`, () => gen.assign(fType, (0, codegen_1$1._)`${fDef}.type || "string"`).assign(format, (0, codegen_1$1._)`${fDef}.validate`), () => gen.assign(fType, (0, codegen_1$1._)`"string"`).assign(format, fDef));
          cxt.fail$data((0, codegen_1$1.or)(unknownFmt(), invalidFmt()));
          function unknownFmt() {
            if (opts.strictSchema === false) return codegen_1$1.nil;
            return (0, codegen_1$1._)`${schemaCode} && !${format}`;
          }
          function invalidFmt() {
            const callFormat = schemaEnv.$async ? (0, codegen_1$1._)`(${fDef}.async ? await ${format}(${data}) : ${format}(${data}))` : (0, codegen_1$1._)`${format}(${data})`;
            const validData = (0, codegen_1$1._)`(typeof ${format} == "function" ? ${callFormat} : ${format}.test(${data}))`;
            return (0, codegen_1$1._)`${format} && ${format} !== true && ${fType} === ${ruleType} && !${validData}`;
          }
        }
        function validateFormat() {
          const formatDef = self.formats[schema];
          if (!formatDef) {
            unknownFormat();
            return;
          }
          if (formatDef === true) return;
          const [fmtType, format, fmtRef] = getFormat(formatDef);
          if (fmtType === ruleType) cxt.pass(validCondition());
          function unknownFormat() {
            if (opts.strictSchema === false) {
              self.logger.warn(unknownMsg());
              return;
            }
            throw new Error(unknownMsg());
            function unknownMsg() {
              return `unknown format "${schema}" ignored in schema at path "${errSchemaPath}"`;
            }
          }
          function getFormat(fmtDef) {
            const code = fmtDef instanceof RegExp ? (0, codegen_1$1.regexpCode)(fmtDef) : opts.code.formats ? (0, codegen_1$1._)`${opts.code.formats}${(0, codegen_1$1.getProperty)(schema)}` : undefined;
            const fmt = gen.scopeValue("formats", {
              key: schema,
              ref: fmtDef,
              code
            });
            if (typeof fmtDef == "object" && !(fmtDef instanceof RegExp)) {
              return [fmtDef.type || "string", fmtDef.validate, (0, codegen_1$1._)`${fmt}.validate`];
            }
            return ["string", fmtDef, fmt];
          }
          function validCondition() {
            if (typeof formatDef == "object" && !(formatDef instanceof RegExp) && formatDef.async) {
              if (!schemaEnv.$async) throw new Error("async format in sync schema");
              return (0, codegen_1$1._)`await ${fmtRef}(${data})`;
            }
            return typeof format == "function" ? (0, codegen_1$1._)`${fmtRef}(${data})` : (0, codegen_1$1._)`${fmtRef}.test(${data})`;
          }
        }
      }
    };
    format$1.default = def$1;

    Object.defineProperty(format$2, "__esModule", {
      value: true
    });
    const format_1$1 = format$1;
    const format = [format_1$1.default];
    format$2.default = format;

    var metadata = {};

    Object.defineProperty(metadata, "__esModule", {
      value: true
    });
    metadata.contentVocabulary = metadata.metadataVocabulary = void 0;
    metadata.metadataVocabulary = ["title", "description", "default", "deprecated", "readOnly", "writeOnly", "examples"];
    metadata.contentVocabulary = ["contentMediaType", "contentEncoding", "contentSchema"];

    Object.defineProperty(draft7, "__esModule", {
      value: true
    });
    const core_1 = core$1;
    const validation_1 = validation$1;
    const applicator_1 = applicator;
    const format_1 = format$2;
    const metadata_1 = metadata;
    const draft7Vocabularies = [core_1.default, validation_1.default, (0, applicator_1.default)(), format_1.default, metadata_1.metadataVocabulary, metadata_1.contentVocabulary];
    draft7.default = draft7Vocabularies;

    var discriminator = {};

    var types = {};

    Object.defineProperty(types, "__esModule", {
      value: true
    });
    types.DiscrError = void 0;
    var DiscrError;
    (function (DiscrError) {
      DiscrError["Tag"] = "tag";
      DiscrError["Mapping"] = "mapping";
    })(DiscrError || (types.DiscrError = DiscrError = {}));

    Object.defineProperty(discriminator, "__esModule", {
      value: true
    });
    const codegen_1 = /*@__PURE__*/requireCodegen();
    const types_1 = types;
    const compile_1 = compile;
    const ref_error_1 = /*@__PURE__*/requireRef_error();
    const util_1 = util;
    const error = {
      message: ({
        params: {
          discrError,
          tagName
        }
      }) => discrError === types_1.DiscrError.Tag ? `tag "${tagName}" must be string` : `value of tag "${tagName}" must be in oneOf`,
      params: ({
        params: {
          discrError,
          tag,
          tagName
        }
      }) => (0, codegen_1._)`{error: ${discrError}, tag: ${tagName}, tagValue: ${tag}}`
    };
    const def = {
      keyword: "discriminator",
      type: "object",
      schemaType: "object",
      error,
      code(cxt) {
        const {
          gen,
          data,
          schema,
          parentSchema,
          it
        } = cxt;
        const {
          oneOf
        } = parentSchema;
        if (!it.opts.discriminator) {
          throw new Error("discriminator: requires discriminator option");
        }
        const tagName = schema.propertyName;
        if (typeof tagName != "string") throw new Error("discriminator: requires propertyName");
        if (schema.mapping) throw new Error("discriminator: mapping is not supported");
        if (!oneOf) throw new Error("discriminator: requires oneOf keyword");
        const valid = gen.let("valid", false);
        const tag = gen.const("tag", (0, codegen_1._)`${data}${(0, codegen_1.getProperty)(tagName)}`);
        gen.if((0, codegen_1._)`typeof ${tag} == "string"`, () => validateMapping(), () => cxt.error(false, {
          discrError: types_1.DiscrError.Tag,
          tag,
          tagName
        }));
        cxt.ok(valid);
        function validateMapping() {
          const mapping = getMapping();
          gen.if(false);
          for (const tagValue in mapping) {
            gen.elseIf((0, codegen_1._)`${tag} === ${tagValue}`);
            gen.assign(valid, applyTagSchema(mapping[tagValue]));
          }
          gen.else();
          cxt.error(false, {
            discrError: types_1.DiscrError.Mapping,
            tag,
            tagName
          });
          gen.endIf();
        }
        function applyTagSchema(schemaProp) {
          const _valid = gen.name("valid");
          const schCxt = cxt.subschema({
            keyword: "oneOf",
            schemaProp
          }, _valid);
          cxt.mergeEvaluated(schCxt, codegen_1.Name);
          return _valid;
        }
        function getMapping() {
          var _a;
          const oneOfMapping = {};
          const topRequired = hasRequired(parentSchema);
          let tagRequired = true;
          for (let i = 0; i < oneOf.length; i++) {
            let sch = oneOf[i];
            if ((sch === null || sch === void 0 ? void 0 : sch.$ref) && !(0, util_1.schemaHasRulesButRef)(sch, it.self.RULES)) {
              const ref = sch.$ref;
              sch = compile_1.resolveRef.call(it.self, it.schemaEnv.root, it.baseId, ref);
              if (sch instanceof compile_1.SchemaEnv) sch = sch.schema;
              if (sch === undefined) throw new ref_error_1.default(it.opts.uriResolver, it.baseId, ref);
            }
            const propSch = (_a = sch === null || sch === void 0 ? void 0 : sch.properties) === null || _a === void 0 ? void 0 : _a[tagName];
            if (typeof propSch != "object") {
              throw new Error(`discriminator: oneOf subschemas (or referenced schemas) must have "properties/${tagName}"`);
            }
            tagRequired = tagRequired && (topRequired || hasRequired(sch));
            addMappings(propSch, i);
          }
          if (!tagRequired) throw new Error(`discriminator: "${tagName}" must be required`);
          return oneOfMapping;
          function hasRequired({
            required
          }) {
            return Array.isArray(required) && required.includes(tagName);
          }
          function addMappings(sch, i) {
            if (sch.const) {
              addMapping(sch.const, i);
            } else if (sch.enum) {
              for (const tagValue of sch.enum) {
                addMapping(tagValue, i);
              }
            } else {
              throw new Error(`discriminator: "properties/${tagName}" must have "const" or "enum"`);
            }
          }
          function addMapping(tagValue, i) {
            if (typeof tagValue != "string" || tagValue in oneOfMapping) {
              throw new Error(`discriminator: "${tagName}" values must be unique strings`);
            }
            oneOfMapping[tagValue] = i;
          }
        }
      }
    };
    discriminator.default = def;

    var $schema = "http://json-schema.org/draft-07/schema#";
    var $id = "http://json-schema.org/draft-07/schema#";
    var title = "Core schema meta-schema";
    var definitions = {
    	schemaArray: {
    		type: "array",
    		minItems: 1,
    		items: {
    			$ref: "#"
    		}
    	},
    	nonNegativeInteger: {
    		type: "integer",
    		minimum: 0
    	},
    	nonNegativeIntegerDefault0: {
    		allOf: [
    			{
    				$ref: "#/definitions/nonNegativeInteger"
    			},
    			{
    				"default": 0
    			}
    		]
    	},
    	simpleTypes: {
    		"enum": [
    			"array",
    			"boolean",
    			"integer",
    			"null",
    			"number",
    			"object",
    			"string"
    		]
    	},
    	stringArray: {
    		type: "array",
    		items: {
    			type: "string"
    		},
    		uniqueItems: true,
    		"default": [
    		]
    	}
    };
    var type = [
    	"object",
    	"boolean"
    ];
    var properties = {
    	$id: {
    		type: "string",
    		format: "uri-reference"
    	},
    	$schema: {
    		type: "string",
    		format: "uri"
    	},
    	$ref: {
    		type: "string",
    		format: "uri-reference"
    	},
    	$comment: {
    		type: "string"
    	},
    	title: {
    		type: "string"
    	},
    	description: {
    		type: "string"
    	},
    	"default": true,
    	readOnly: {
    		type: "boolean",
    		"default": false
    	},
    	examples: {
    		type: "array",
    		items: true
    	},
    	multipleOf: {
    		type: "number",
    		exclusiveMinimum: 0
    	},
    	maximum: {
    		type: "number"
    	},
    	exclusiveMaximum: {
    		type: "number"
    	},
    	minimum: {
    		type: "number"
    	},
    	exclusiveMinimum: {
    		type: "number"
    	},
    	maxLength: {
    		$ref: "#/definitions/nonNegativeInteger"
    	},
    	minLength: {
    		$ref: "#/definitions/nonNegativeIntegerDefault0"
    	},
    	pattern: {
    		type: "string",
    		format: "regex"
    	},
    	additionalItems: {
    		$ref: "#"
    	},
    	items: {
    		anyOf: [
    			{
    				$ref: "#"
    			},
    			{
    				$ref: "#/definitions/schemaArray"
    			}
    		],
    		"default": true
    	},
    	maxItems: {
    		$ref: "#/definitions/nonNegativeInteger"
    	},
    	minItems: {
    		$ref: "#/definitions/nonNegativeIntegerDefault0"
    	},
    	uniqueItems: {
    		type: "boolean",
    		"default": false
    	},
    	contains: {
    		$ref: "#"
    	},
    	maxProperties: {
    		$ref: "#/definitions/nonNegativeInteger"
    	},
    	minProperties: {
    		$ref: "#/definitions/nonNegativeIntegerDefault0"
    	},
    	required: {
    		$ref: "#/definitions/stringArray"
    	},
    	additionalProperties: {
    		$ref: "#"
    	},
    	definitions: {
    		type: "object",
    		additionalProperties: {
    			$ref: "#"
    		},
    		"default": {
    		}
    	},
    	properties: {
    		type: "object",
    		additionalProperties: {
    			$ref: "#"
    		},
    		"default": {
    		}
    	},
    	patternProperties: {
    		type: "object",
    		additionalProperties: {
    			$ref: "#"
    		},
    		propertyNames: {
    			format: "regex"
    		},
    		"default": {
    		}
    	},
    	dependencies: {
    		type: "object",
    		additionalProperties: {
    			anyOf: [
    				{
    					$ref: "#"
    				},
    				{
    					$ref: "#/definitions/stringArray"
    				}
    			]
    		}
    	},
    	propertyNames: {
    		$ref: "#"
    	},
    	"const": true,
    	"enum": {
    		type: "array",
    		items: true,
    		minItems: 1,
    		uniqueItems: true
    	},
    	type: {
    		anyOf: [
    			{
    				$ref: "#/definitions/simpleTypes"
    			},
    			{
    				type: "array",
    				items: {
    					$ref: "#/definitions/simpleTypes"
    				},
    				minItems: 1,
    				uniqueItems: true
    			}
    		]
    	},
    	format: {
    		type: "string"
    	},
    	contentMediaType: {
    		type: "string"
    	},
    	contentEncoding: {
    		type: "string"
    	},
    	"if": {
    		$ref: "#"
    	},
    	then: {
    		$ref: "#"
    	},
    	"else": {
    		$ref: "#"
    	},
    	allOf: {
    		$ref: "#/definitions/schemaArray"
    	},
    	anyOf: {
    		$ref: "#/definitions/schemaArray"
    	},
    	oneOf: {
    		$ref: "#/definitions/schemaArray"
    	},
    	not: {
    		$ref: "#"
    	}
    };
    var require$$3 = {
    	$schema: $schema,
    	$id: $id,
    	title: title,
    	definitions: definitions,
    	type: type,
    	properties: properties,
    	"default": true
    };

    (function (module, exports) {

      Object.defineProperty(exports, "__esModule", {
        value: true
      });
      exports.MissingRefError = exports.ValidationError = exports.CodeGen = exports.Name = exports.nil = exports.stringify = exports.str = exports._ = exports.KeywordCxt = exports.Ajv = void 0;
      const core_1 = core$2;
      const draft7_1 = draft7;
      const discriminator_1 = discriminator;
      const draft7MetaSchema = require$$3;
      const META_SUPPORT_DATA = ["/properties"];
      const META_SCHEMA_ID = "http://json-schema.org/draft-07/schema";
      class Ajv extends core_1.default {
        _addVocabularies() {
          super._addVocabularies();
          draft7_1.default.forEach(v => this.addVocabulary(v));
          if (this.opts.discriminator) this.addKeyword(discriminator_1.default);
        }
        _addDefaultMetaSchema() {
          super._addDefaultMetaSchema();
          if (!this.opts.meta) return;
          const metaSchema = this.opts.$data ? this.$dataMetaSchema(draft7MetaSchema, META_SUPPORT_DATA) : draft7MetaSchema;
          this.addMetaSchema(metaSchema, META_SCHEMA_ID, false);
          this.refs["http://json-schema.org/schema"] = META_SCHEMA_ID;
        }
        defaultMeta() {
          return this.opts.defaultMeta = super.defaultMeta() || (this.getSchema(META_SCHEMA_ID) ? META_SCHEMA_ID : undefined);
        }
      }
      exports.Ajv = Ajv;
      module.exports = exports = Ajv;
      module.exports.Ajv = Ajv;
      Object.defineProperty(exports, "__esModule", {
        value: true
      });
      exports.default = Ajv;
      var validate_1 = /*@__PURE__*/requireValidate();
      Object.defineProperty(exports, "KeywordCxt", {
        enumerable: true,
        get: function () {
          return validate_1.KeywordCxt;
        }
      });
      var codegen_1 = /*@__PURE__*/requireCodegen();
      Object.defineProperty(exports, "_", {
        enumerable: true,
        get: function () {
          return codegen_1._;
        }
      });
      Object.defineProperty(exports, "str", {
        enumerable: true,
        get: function () {
          return codegen_1.str;
        }
      });
      Object.defineProperty(exports, "stringify", {
        enumerable: true,
        get: function () {
          return codegen_1.stringify;
        }
      });
      Object.defineProperty(exports, "nil", {
        enumerable: true,
        get: function () {
          return codegen_1.nil;
        }
      });
      Object.defineProperty(exports, "Name", {
        enumerable: true,
        get: function () {
          return codegen_1.Name;
        }
      });
      Object.defineProperty(exports, "CodeGen", {
        enumerable: true,
        get: function () {
          return codegen_1.CodeGen;
        }
      });
      var validation_error_1 = /*@__PURE__*/requireValidation_error();
      Object.defineProperty(exports, "ValidationError", {
        enumerable: true,
        get: function () {
          return validation_error_1.default;
        }
      });
      var ref_error_1 = /*@__PURE__*/requireRef_error();
      Object.defineProperty(exports, "MissingRefError", {
        enumerable: true,
        get: function () {
          return ref_error_1.default;
        }
      });
    })(ajv$1, ajv$1.exports);
    var ajvExports = ajv$1.exports;
    var Ajv = /*@__PURE__*/getDefaultExportFromCjs(ajvExports);

    var dist = {exports: {}};

    var formats = {};

    (function (exports) {

      Object.defineProperty(exports, "__esModule", {
        value: true
      });
      exports.formatNames = exports.fastFormats = exports.fullFormats = void 0;
      function fmtDef(validate, compare) {
        return {
          validate,
          compare
        };
      }
      exports.fullFormats = {
        // date: http://tools.ietf.org/html/rfc3339#section-5.6
        date: fmtDef(date, compareDate),
        // date-time: http://tools.ietf.org/html/rfc3339#section-5.6
        time: fmtDef(getTime(true), compareTime),
        "date-time": fmtDef(getDateTime(true), compareDateTime),
        "iso-time": fmtDef(getTime(), compareIsoTime),
        "iso-date-time": fmtDef(getDateTime(), compareIsoDateTime),
        // duration: https://tools.ietf.org/html/rfc3339#appendix-A
        duration: /^P(?!$)((\d+Y)?(\d+M)?(\d+D)?(T(?=\d)(\d+H)?(\d+M)?(\d+S)?)?|(\d+W)?)$/,
        uri,
        "uri-reference": /^(?:[a-z][a-z0-9+\-.]*:)?(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'"()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?(?:\?(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i,
        // uri-template: https://tools.ietf.org/html/rfc6570
        "uri-template": /^(?:(?:[^\x00-\x20"'<>%\\^`{|}]|%[0-9a-f]{2})|\{[+#./;?&=,!@|]?(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?(?:,(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?)*\})*$/i,
        // For the source: https://gist.github.com/dperini/729294
        // For test cases: https://mathiasbynens.be/demo/url-regex
        url: /^(?:https?|ftp):\/\/(?:\S+(?::\S*)?@)?(?:(?!(?:10|127)(?:\.\d{1,3}){3})(?!(?:169\.254|192\.168)(?:\.\d{1,3}){2})(?!172\.(?:1[6-9]|2\d|3[0-1])(?:\.\d{1,3}){2})(?:[1-9]\d?|1\d\d|2[01]\d|22[0-3])(?:\.(?:1?\d{1,2}|2[0-4]\d|25[0-5])){2}(?:\.(?:[1-9]\d?|1\d\d|2[0-4]\d|25[0-4]))|(?:(?:[a-z0-9\u{00a1}-\u{ffff}]+-)*[a-z0-9\u{00a1}-\u{ffff}]+)(?:\.(?:[a-z0-9\u{00a1}-\u{ffff}]+-)*[a-z0-9\u{00a1}-\u{ffff}]+)*(?:\.(?:[a-z\u{00a1}-\u{ffff}]{2,})))(?::\d{2,5})?(?:\/[^\s]*)?$/iu,
        email: /^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$/i,
        hostname: /^(?=.{1,253}\.?$)[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[-0-9a-z]{0,61}[0-9a-z])?)*\.?$/i,
        // optimized https://www.safaribooksonline.com/library/view/regular-expressions-cookbook/9780596802837/ch07s16.html
        ipv4: /^(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)\.){3}(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)$/,
        ipv6: /^((([0-9a-f]{1,4}:){7}([0-9a-f]{1,4}|:))|(([0-9a-f]{1,4}:){6}(:[0-9a-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9a-f]{1,4}:){5}(((:[0-9a-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9a-f]{1,4}:){4}(((:[0-9a-f]{1,4}){1,3})|((:[0-9a-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9a-f]{1,4}:){3}(((:[0-9a-f]{1,4}){1,4})|((:[0-9a-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9a-f]{1,4}:){2}(((:[0-9a-f]{1,4}){1,5})|((:[0-9a-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9a-f]{1,4}:){1}(((:[0-9a-f]{1,4}){1,6})|((:[0-9a-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9a-f]{1,4}){1,7})|((:[0-9a-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))$/i,
        regex,
        // uuid: http://tools.ietf.org/html/rfc4122
        uuid: /^(?:urn:uuid:)?[0-9a-f]{8}-(?:[0-9a-f]{4}-){3}[0-9a-f]{12}$/i,
        // JSON-pointer: https://tools.ietf.org/html/rfc6901
        // uri fragment: https://tools.ietf.org/html/rfc3986#appendix-A
        "json-pointer": /^(?:\/(?:[^~/]|~0|~1)*)*$/,
        "json-pointer-uri-fragment": /^#(?:\/(?:[a-z0-9_\-.!$&'()*+,;:=@]|%[0-9a-f]{2}|~0|~1)*)*$/i,
        // relative JSON-pointer: http://tools.ietf.org/html/draft-luff-relative-json-pointer-00
        "relative-json-pointer": /^(?:0|[1-9][0-9]*)(?:#|(?:\/(?:[^~/]|~0|~1)*)*)$/,
        // the following formats are used by the openapi specification: https://spec.openapis.org/oas/v3.0.0#data-types
        // byte: https://github.com/miguelmota/is-base64
        byte,
        // signed 32 bit integer
        int32: {
          type: "number",
          validate: validateInt32
        },
        // signed 64 bit integer
        int64: {
          type: "number",
          validate: validateInt64
        },
        // C-type float
        float: {
          type: "number",
          validate: validateNumber
        },
        // C-type double
        double: {
          type: "number",
          validate: validateNumber
        },
        // hint to the UI to hide input strings
        password: true,
        // unchecked string payload
        binary: true
      };
      exports.fastFormats = {
        ...exports.fullFormats,
        date: fmtDef(/^\d\d\d\d-[0-1]\d-[0-3]\d$/, compareDate),
        time: fmtDef(/^(?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)$/i, compareTime),
        "date-time": fmtDef(/^\d\d\d\d-[0-1]\d-[0-3]\dt(?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)$/i, compareDateTime),
        "iso-time": fmtDef(/^(?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)?$/i, compareIsoTime),
        "iso-date-time": fmtDef(/^\d\d\d\d-[0-1]\d-[0-3]\d[t\s](?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)?$/i, compareIsoDateTime),
        // uri: https://github.com/mafintosh/is-my-json-valid/blob/master/formats.js
        uri: /^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/)?[^\s]*$/i,
        "uri-reference": /^(?:(?:[a-z][a-z0-9+\-.]*:)?\/?\/)?(?:[^\\\s#][^\s#]*)?(?:#[^\\\s]*)?$/i,
        // email (sources from jsen validator):
        // http://stackoverflow.com/questions/201323/using-a-regular-expression-to-validate-an-email-address#answer-8829363
        // http://www.w3.org/TR/html5/forms.html#valid-e-mail-address (search for 'wilful violation')
        email: /^[a-z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?)*$/i
      };
      exports.formatNames = Object.keys(exports.fullFormats);
      function isLeapYear(year) {
        // https://tools.ietf.org/html/rfc3339#appendix-C
        return year % 4 === 0 && (year % 100 !== 0 || year % 400 === 0);
      }
      const DATE = /^(\d\d\d\d)-(\d\d)-(\d\d)$/;
      const DAYS = [0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
      function date(str) {
        // full-date from http://tools.ietf.org/html/rfc3339#section-5.6
        const matches = DATE.exec(str);
        if (!matches) return false;
        const year = +matches[1];
        const month = +matches[2];
        const day = +matches[3];
        return month >= 1 && month <= 12 && day >= 1 && day <= (month === 2 && isLeapYear(year) ? 29 : DAYS[month]);
      }
      function compareDate(d1, d2) {
        if (!(d1 && d2)) return undefined;
        if (d1 > d2) return 1;
        if (d1 < d2) return -1;
        return 0;
      }
      const TIME = /^(\d\d):(\d\d):(\d\d(?:\.\d+)?)(z|([+-])(\d\d)(?::?(\d\d))?)?$/i;
      function getTime(strictTimeZone) {
        return function time(str) {
          const matches = TIME.exec(str);
          if (!matches) return false;
          const hr = +matches[1];
          const min = +matches[2];
          const sec = +matches[3];
          const tz = matches[4];
          const tzSign = matches[5] === "-" ? -1 : 1;
          const tzH = +(matches[6] || 0);
          const tzM = +(matches[7] || 0);
          if (tzH > 23 || tzM > 59 || strictTimeZone && !tz) return false;
          if (hr <= 23 && min <= 59 && sec < 60) return true;
          // leap second
          const utcMin = min - tzM * tzSign;
          const utcHr = hr - tzH * tzSign - (utcMin < 0 ? 1 : 0);
          return (utcHr === 23 || utcHr === -1) && (utcMin === 59 || utcMin === -1) && sec < 61;
        };
      }
      function compareTime(s1, s2) {
        if (!(s1 && s2)) return undefined;
        const t1 = new Date("2020-01-01T" + s1).valueOf();
        const t2 = new Date("2020-01-01T" + s2).valueOf();
        if (!(t1 && t2)) return undefined;
        return t1 - t2;
      }
      function compareIsoTime(t1, t2) {
        if (!(t1 && t2)) return undefined;
        const a1 = TIME.exec(t1);
        const a2 = TIME.exec(t2);
        if (!(a1 && a2)) return undefined;
        t1 = a1[1] + a1[2] + a1[3];
        t2 = a2[1] + a2[2] + a2[3];
        if (t1 > t2) return 1;
        if (t1 < t2) return -1;
        return 0;
      }
      const DATE_TIME_SEPARATOR = /t|\s/i;
      function getDateTime(strictTimeZone) {
        const time = getTime(strictTimeZone);
        return function date_time(str) {
          // http://tools.ietf.org/html/rfc3339#section-5.6
          const dateTime = str.split(DATE_TIME_SEPARATOR);
          return dateTime.length === 2 && date(dateTime[0]) && time(dateTime[1]);
        };
      }
      function compareDateTime(dt1, dt2) {
        if (!(dt1 && dt2)) return undefined;
        const d1 = new Date(dt1).valueOf();
        const d2 = new Date(dt2).valueOf();
        if (!(d1 && d2)) return undefined;
        return d1 - d2;
      }
      function compareIsoDateTime(dt1, dt2) {
        if (!(dt1 && dt2)) return undefined;
        const [d1, t1] = dt1.split(DATE_TIME_SEPARATOR);
        const [d2, t2] = dt2.split(DATE_TIME_SEPARATOR);
        const res = compareDate(d1, d2);
        if (res === undefined) return undefined;
        return res || compareTime(t1, t2);
      }
      const NOT_URI_FRAGMENT = /\/|:/;
      const URI = /^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)(?:\?(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i;
      function uri(str) {
        // http://jmrware.com/articles/2009/uri_regexp/URI_regex.html + optional protocol + required "."
        return NOT_URI_FRAGMENT.test(str) && URI.test(str);
      }
      const BYTE = /^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$/gm;
      function byte(str) {
        BYTE.lastIndex = 0;
        return BYTE.test(str);
      }
      const MIN_INT32 = -2147483648;
      const MAX_INT32 = 2 ** 31 - 1;
      function validateInt32(value) {
        return Number.isInteger(value) && value <= MAX_INT32 && value >= MIN_INT32;
      }
      function validateInt64(value) {
        // JSON and javascript max Int is 2**53, so any int that passes isInteger is valid for Int64
        return Number.isInteger(value);
      }
      function validateNumber() {
        return true;
      }
      const Z_ANCHOR = /[^\\]\\Z/;
      function regex(str) {
        if (Z_ANCHOR.test(str)) return false;
        try {
          new RegExp(str);
          return true;
        } catch (e) {
          return false;
        }
      }
    })(formats);

    var limit = {};

    (function (exports) {

      Object.defineProperty(exports, "__esModule", {
        value: true
      });
      exports.formatLimitDefinition = void 0;
      const ajv_1 = ajvExports;
      const codegen_1 = /*@__PURE__*/requireCodegen();
      const ops = codegen_1.operators;
      const KWDs = {
        formatMaximum: {
          okStr: "<=",
          ok: ops.LTE,
          fail: ops.GT
        },
        formatMinimum: {
          okStr: ">=",
          ok: ops.GTE,
          fail: ops.LT
        },
        formatExclusiveMaximum: {
          okStr: "<",
          ok: ops.LT,
          fail: ops.GTE
        },
        formatExclusiveMinimum: {
          okStr: ">",
          ok: ops.GT,
          fail: ops.LTE
        }
      };
      const error = {
        message: ({
          keyword,
          schemaCode
        }) => (0, codegen_1.str)`should be ${KWDs[keyword].okStr} ${schemaCode}`,
        params: ({
          keyword,
          schemaCode
        }) => (0, codegen_1._)`{comparison: ${KWDs[keyword].okStr}, limit: ${schemaCode}}`
      };
      exports.formatLimitDefinition = {
        keyword: Object.keys(KWDs),
        type: "string",
        schemaType: "string",
        $data: true,
        error,
        code(cxt) {
          const {
            gen,
            data,
            schemaCode,
            keyword,
            it
          } = cxt;
          const {
            opts,
            self
          } = it;
          if (!opts.validateFormats) return;
          const fCxt = new ajv_1.KeywordCxt(it, self.RULES.all.format.definition, "format");
          if (fCxt.$data) validate$DataFormat();else validateFormat();
          function validate$DataFormat() {
            const fmts = gen.scopeValue("formats", {
              ref: self.formats,
              code: opts.code.formats
            });
            const fmt = gen.const("fmt", (0, codegen_1._)`${fmts}[${fCxt.schemaCode}]`);
            cxt.fail$data((0, codegen_1.or)((0, codegen_1._)`typeof ${fmt} != "object"`, (0, codegen_1._)`${fmt} instanceof RegExp`, (0, codegen_1._)`typeof ${fmt}.compare != "function"`, compareCode(fmt)));
          }
          function validateFormat() {
            const format = fCxt.schema;
            const fmtDef = self.formats[format];
            if (!fmtDef || fmtDef === true) return;
            if (typeof fmtDef != "object" || fmtDef instanceof RegExp || typeof fmtDef.compare != "function") {
              throw new Error(`"${keyword}": format "${format}" does not define "compare" function`);
            }
            const fmt = gen.scopeValue("formats", {
              key: format,
              ref: fmtDef,
              code: opts.code.formats ? (0, codegen_1._)`${opts.code.formats}${(0, codegen_1.getProperty)(format)}` : undefined
            });
            cxt.fail$data(compareCode(fmt));
          }
          function compareCode(fmt) {
            return (0, codegen_1._)`${fmt}.compare(${data}, ${schemaCode}) ${KWDs[keyword].fail} 0`;
          }
        },
        dependencies: ["format"]
      };
      const formatLimitPlugin = ajv => {
        ajv.addKeyword(exports.formatLimitDefinition);
        return ajv;
      };
      exports.default = formatLimitPlugin;
    })(limit);

    (function (module, exports) {

      Object.defineProperty(exports, "__esModule", {
        value: true
      });
      const formats_1 = formats;
      const limit_1 = limit;
      const codegen_1 = /*@__PURE__*/requireCodegen();
      const fullName = new codegen_1.Name("fullFormats");
      const fastName = new codegen_1.Name("fastFormats");
      const formatsPlugin = (ajv, opts = {
        keywords: true
      }) => {
        if (Array.isArray(opts)) {
          addFormats(ajv, opts, formats_1.fullFormats, fullName);
          return ajv;
        }
        const [formats, exportName] = opts.mode === "fast" ? [formats_1.fastFormats, fastName] : [formats_1.fullFormats, fullName];
        const list = opts.formats || formats_1.formatNames;
        addFormats(ajv, list, formats, exportName);
        if (opts.keywords) (0, limit_1.default)(ajv);
        return ajv;
      };
      formatsPlugin.get = (name, mode = "full") => {
        const formats = mode === "fast" ? formats_1.fastFormats : formats_1.fullFormats;
        const f = formats[name];
        if (!f) throw new Error(`Unknown format "${name}"`);
        return f;
      };
      function addFormats(ajv, list, fs, exportName) {
        var _a;
        var _b;
        (_a = (_b = ajv.opts.code).formats) !== null && _a !== void 0 ? _a : _b.formats = (0, codegen_1._)`require("ajv-formats/dist/formats").${exportName}`;
        for (const f of list) ajv.addFormat(f, fs[f]);
      }
      module.exports = exports = formatsPlugin;
      Object.defineProperty(exports, "__esModule", {
        value: true
      });
      exports.default = formatsPlugin;
    })(dist, dist.exports);
    var distExports = dist.exports;
    var addFormats = /*@__PURE__*/getDefaultExportFromCjs(distExports);

    var e$1 = Object.defineProperty;
    var h = Object.getOwnPropertyDescriptor;
    var d = Object.getOwnPropertyNames;
    var x = Object.prototype.hasOwnProperty;
    var D = (t, r) => {
        for (var o in r) e$1(t, o, {
          get: r[o],
          enumerable: true
        });
      },
      m = (t, r, o, i) => {
        if (r && typeof r == "object" || typeof r == "function") for (let n of d(r)) !x.call(t, n) && n !== o && e$1(t, n, {
          get: () => r[n],
          enumerable: !(i = h(r, n)) || i.enumerable
        });
        return t;
      };
    var b = t => m(e$1({}, "__esModule", {
      value: true
    }), t);
    var I = {};
    D(I, {
      ORCID: () => F,
      inAcceptedFormat: () => s,
      isValid: () => g,
      toDashFormat: () => a,
      toNoDashFormat: () => c,
      toUriWithProtocol: () => f,
      toUriWithoutProtocol: () => u,
      validate: () => l
    });
    var orcid_min = b(I);
    function s(t) {
      if (typeof t != "string") throw TypeError("Input must be string");
      return /^((https?:\/\/)?orcid\.org\/)?([0-9]{4}-?){3}[0-9]{3}[0-9X]$/i.test(t);
    }
    function a(t) {
      const r = c(t);
      return [0, 4, 8, 12].map(o => r.slice(o, o + 4)).join("-");
    }
    function p(t) {
      return t.replace(/-/g, "").slice(-16).toUpperCase();
    }
    function c(t) {
      return l(t), p(t);
    }
    function f(t, r) {
      return (r === void 0 || r ? "https" : "http") + "://" + u(t);
    }
    function u(t) {
      return "orcid.org/" + a(t);
    }
    function g(t) {
      if (!s(t)) return false;
      const r = p(t);
      let o = 0;
      for (let n = 0; n < 15; n++) o = (o + +r[n]) * 2;
      const i = (12 - o % 11) % 11;
      return r[15] === (i === 10 ? "X" : i + "");
    }
    function l(t) {
      if (!g(t)) throw Error("Invalid ORCID");
    }
    const F = {
      isValid: g,
      validate: l,
      inAcceptedFormat: s,
      toDashFormat: a,
      toNoDashFormat: c,
      toUriWithProtocol: f,
      toUriWithoutProtocol: u
    };
    var orcidPkg = /*@__PURE__*/getDefaultExportFromCjs(orcid_min);

    const licenseEnum = {
      enum: ['glide', 'amdplpa', 'antlr-pd', 'antlr-pd-fallback', 'abstyles', 'afl-1.1', 'afl-1.2', 'afl-2.0', 'afl-2.1', 'afl-3.0', 'ampas', 'apl-1.0', 'adobe-glyph', 'apafml', 'adobe-2006', 'agpl-1.0-only', 'agpl-1.0-or-later', 'afmparse', 'against-drm', 'aladdin', 'adsl', 'apache-1.0', 'apache-1.1', 'apache-2.0', 'aml', 'apsl-1.0', 'apsl-1.1', 'apsl-1.2', 'apsl-2.0', 'artistic-1.0', 'artistic-1.0-perl', 'artistic-1.0-cl8', 'artistic-2.0', 'aal', 'bsd-1-clause', 'bsd-2-clause', 'bsd-2-clause-views', 'bsd-3-clause', 'bsd-3-clause-clear', 'bsd-3-clause-no-nuclear-license', 'bsd-3-clause-no-nuclear-license-2014', 'bsd-3-clause-no-nuclear-warranty', 'bsd-3-clause-open-mpi', 'bsd-4-clause', 'bsd-protection', 'bsd-source-code', '0bsd', 'bsd-3-clause-attribution', 'bsd-2-clause-patent', 'bsd-4-clause-uc', 'bahyph', 'barr', 'beerware', 'bittorrent-1.0', 'bittorrent-1.1', 'blueoak-1.0.0', 'bsl-1.0', 'borceux', 'busl-1.1', 'cern-ohl-p-2.0', 'cern-ohl-s-2.0', 'cern-ohl-w-2.0', 'cern-ohl-1.1', 'cern-ohl-1.2', 'mit-cmu', 'cnri-jython', 'cnri-python', 'cnri-python-gpl-compatible', 'cua-opl-1.0', 'caldera', 'cecill-1.0', 'cecill-1.1', 'cecill-2.0', 'cecill-2.1', 'cecill-b', 'cecill-c', 'clartistic', 'cpol-1.02', 'cddl-1.0', 'cddl-1.1', 'cpal-1.0', 'cpl-1.0', 'cdla-permissive-1.0', 'cdla-sharing-1.0', 'catosl-1.1', 'condor-1.1', 'cc-by-1.0', 'cc-by-2.0', 'cc-by-2.5', 'cc-by-3.0-at', 'cc-by-3.0-us', 'cc-by-3.0', 'cc-by-4.0', 'cc-by-nd-1.0', 'cc-by-nd-2.0', 'cc-by-nd-2.5', 'cc-by-nd-3.0', 'cc-by-nd-4.0', 'cc-by-nc-1.0', 'cc-by-nc-2.0', 'cc-by-nc-2.5', 'cc-by-nc-3.0', 'cc-by-nc-4.0', 'cc-by-nc-nd-1.0', 'cc-by-nc-nd-2.0', 'cc-by-nc-nd-2.5', 'cc-by-nc-nd-3.0-igo', 'cc-by-nc-nd-3.0', 'cc-by-nc-nd-4.0', 'cc-by-nc-sa-1.0', 'cc-by-nc-sa-2.0', 'cc-by-nc-sa-2.5', 'cc-by-nc-sa-3.0', 'cc-by-nc-sa-4.0', 'cc-by-sa-1.0', 'cc-by-sa-2.0-uk', 'cc-by-sa-2.0', 'cc-by-sa-2.5', 'cc-by-sa-3.0', 'cc-by-sa-4.0', 'cc-by-sa-3.0-at', 'cc-pddc', 'cc0-1.0', 'crossword', 'cal-1.0', 'cal-1.0-combined-work-exception', 'crystalstacker', 'cube', 'doc', 'dsdp', 'dsl', 'd-fsl-1.0', 'wtfpl', 'dotseqn', 'epics', 'eudatagrid', 'epl-1.0', 'epl-2.0', 'ecl-1.0', 'ecl-2.0', 'efl-1.0', 'efl-2.0', 'mit-advertising', 'entessa', 'erlpl-1.1', 'etalab-2.0', 'eurofound', 'eupl-1.0', 'eupl-1.1', 'eupl-1.2', 'eurosym', 'fsfap', 'fsful', 'fsfullr', 'fair', 'frameworx-1.0', 'zenodo-freetoread-1.0', 'freeimage', 'ftl', 'gl2ps', 'agpl-3.0-only', 'agpl-3.0-or-later', 'gfdl-1.1-only', 'gfdl-1.1-invariants-only', 'gfdl-1.1-no-invariants-only', 'gfdl-1.1-or-later', 'gfdl-1.1-invariants-or-later', 'gfdl-1.1-no-invariants-or-later', 'gfdl-1.2-only', 'gfdl-1.2-invariants-only', 'gfdl-1.2-no-invariants-only', 'gfdl-1.2-or-later', 'gfdl-1.2-invariants-or-later', 'gfdl-1.2-no-invariants-or-later', 'gfdl-1.3-only', 'gfdl-1.3-invariants-only', 'gfdl-1.3-no-invariants-only', 'gfdl-1.3-or-later', 'gfdl-1.3-invariants-or-later', 'gfdl-1.3-no-invariants-or-later', 'gpl-1.0-only', 'gpl-1.0-or-later', 'gpl-2.0-only', 'gpl-2.0-or-later', 'gpl-3.0-only', 'gpl-3.0-or-later', 'lgpl-2.1-only', 'lgpl-2.1-or-later', 'lgpl-3.0-only', 'lgpl-3.0-or-later', 'lgpl-2.0-only', 'lgpl-2.0-or-later', 'geogratis', 'giftware', 'glulxe', 'glwtpl', 'htmltidy', 'haskellreport', 'hesa-withrights', 'hippocratic-2.1', 'hpnd', 'hpnd-sell-variant', 'ibm-pibs', 'ipl-1.0', 'icu', 'ipa', 'isc', 'imagemagick', 'imlib2', 'ijg', 'info-zip', 'intel-acpi', 'intel', 'interbase-1.0', 'user-jsim', 'json', 'jabber-osl', 'jpnic', 'jasper-2.0', 'lppl-1.0', 'lppl-1.1', 'lppl-1.2', 'lppl-1.3a', 'lppl-1.3c', 'latex2e', 'bsd-3-clause-lbnl', 'leptonica', 'lgpllr', 'lal-1.2', 'lal-1.3', 'liliq-p-1.1', 'liliq-rplus-1.1', 'liliq-r-1.1', 'notspecified', 'linux-openib', 'localauth-withrights', 'lucent-plan9', 'lpl-1.0', 'lpl-1.02', 'mitnfa', 'mit', 'mit-0', 'mit-open-group', 'mitre', 'makeindex', 'mtll', 'met-office-cp', 'ms-pl', 'ms-rl', 'motosoto', 'mpl-1.0', 'mpl-1.1', 'mpl-2.0', 'mpl-2.0-no-copyleft-exception', 'mulanpsl-1.0', 'mulanpsl-2.0', 'multics', 'mup', 'nasa-1.3', 'nist-pd', 'nist-pd-fallback', 'nrl', 'ntp', 'ntp-0', 'naumen', 'nbpl-1.0', 'net-snmp', 'netcdf', 'ngpl', 'nosl', 'npl-1.0', 'npl-1.1', 'newsletr', 'geo-no-fee-unrestricted', 'nlpl', 'nokia', 'ncgl-uk-2.0', 'nposl-3.0', 'nlod-1.0', 'noweb', 'oclc-2.0', 'odbl-1.0', 'pddl-1.0', 'ogc-1.0', 'oset-pl-2.1', 'occt-pl', 'odc-by-1.0', 'ogl-canada-2.0', 'ogl-uk-1.0', 'ogl-uk-2.0', 'ogl-uk-3.0', 'ogtsl', 'oldap-2.2.2', 'oldap-1.1', 'oldap-1.2', 'oldap-1.3', 'oldap-1.4', 'oldap-2.0', 'oldap-2.0.1', 'oldap-2.1', 'oldap-2.2', 'oldap-2.2.1', 'oldap-2.3', 'oldap-2.4', 'oldap-2.5', 'oldap-2.6', 'oldap-2.7', 'oldap-2.8', 'oml', 'opl-1.0', 'osl-1.0', 'osl-1.1', 'osl-2.0', 'osl-2.1', 'osl-3.0', 'o-uda-1.0', 'openssl', 'other-at', 'other-nc', 'other-closed', 'other-open', 'other-pd', 'php-3.0', 'php-3.01', 'libpng-2.0', 'plexus', 'polyform-noncommercial-1.0.0', 'polyform-small-business-1.0.0', 'postgresql', 'python-2.0', 'psf-2.0', 'qpl-1.0', 'qhull', 'qtpl', 'rsa-md', 'rdisc', 'rpsl-1.0', 'rpl-1.1', 'rpl-1.5', 'rhecos-1.1', 'rscpl', 'ruby', 'scea', 'sgi-b-1.0', 'sgi-b-1.1', 'sgi-b-2.0', 'ofl-1.0', 'ofl-1.0-rfn', 'ofl-1.0-no-rfn', 'ofl-1.1', 'ofl-1.1-rfn', 'ofl-1.1-no-rfn', 'snia', 'blessing', 'ssh-openssh', 'ssh-short', 'sax-pd', 'saxpath', 'swl', 'smppl', 'sendmail', 'sendmail-8.23', 'sspl-1.0', 'simpl-2.0', 'sleepycat', 'shl-0.5', 'shl-0.51', 'spencer-86', 'spencer-94', 'spencer-99', 'smlnj', 'dli-model-use', 'sugarcrm-1.1.3', 'sissl', 'sissl-1.2', 'spl-1.0', 'watcom-1.0', 'tapr-ohl-1.0', 'tcl', 'tcp-wrappers', 'tmate', 'torque-1.1', 'tu-berlin-1.0', 'tu-berlin-2.0', 'miros', 'parity-6.0.0', 'parity-7.0.0', 'unlicense', 'tosl', 'ukclickusepsi', 'ukcrown', 'ukcrown-withrights', 'ukpsi', 'unicode-dfs-2015', 'unicode-dfs-2016', 'unicode-tou', 'upl-1.0', 'ncsa', 'ucl-1.0', 'vostrom', 'vim', 'vsl-1.0', 'w3c-20150513', 'w3c-19980720', 'w3c', 'wsuipa', 'xnet', 'x11', 'xfree86-1.1', 'xpp', 'xskat', 'xerox', 'ypl-1.0', 'ypl-1.1', 'zed', 'zend-2.0', 'zimbra-1.3', 'zimbra-1.4', 'zpl-1.1', 'zpl-2.0', 'zpl-2.1', 'bzip2-1.0.5', 'bzip2-1.0.6', 'copyleft-next-0.3.0', 'copyleft-next-0.3.1', 'curl', 'diffmark', 'dvipdfm', 'egenix', 'mit-enna', 'mit-feh', 'gsoap-1.3b', 'gnuplot', 'imatix', 'libpng', 'libselinux-1.0', 'libtiff', 'mpich2', 'psfrag', 'psutils', 'wxwindows', 'xinetd', 'zlib', 'zlib-acknowledgement']
    };

    /**
     * The schema was taken from the Unofficial JSON schema for Zenodo upload metadata the 16th of June 2025.
     * https:// github.com/zenodraft/metadata-schema-zenodo
     */
    const zenodoMetadataSchema = {
      $schema: 'http://json-schema.org/draft-07/schema',
      additionalProperties: true,
      allOf: [{
        if: {
          type: 'object',
          properties: {
            access_right: {
              const: 'embargoed'
            }
          },
          required: ['access_right']
        },
        // eslint-disable-next-line unicorn/no-thenable
        then: {
          type: 'object',
          required: ['embargo_date', 'license']
        }
      }],
      definitions: {},
      properties: {
        access_conditions: {
          type: 'string'
        },
        access_right: {
          description: 'Open access uploads have considerably higher visibility on Zenodo.',
          enum: ['closed', 'embargoed', 'open', 'restricted'],
          type: 'string'
        },
        communities: {
          items: {
            additionalProperties: true,
            properties: {
              identifier: {
                type: 'string'
              }
            },
            required: [],
            type: 'object'
          },
          minItems: 0,
          type: 'array',
          uniqueItems: true
        },
        conference_acronym: {
          type: 'string'
        },
        conference_dates: {
          type: 'string'
        },
        conference_place: {
          type: 'string'
        },
        conference_session: {
          type: 'string'
        },
        conference_session_part: {
          type: 'string'
        },
        conference_title: {
          type: 'string'
        },
        conference_url: {
          format: 'uri',
          type: 'string'
        },
        contributors: {
          items: {
            additionalProperties: false,
            properties: {
              affiliation: {
                minLength: 1,
                type: ['string', 'null']
              },
              name: {
                description: 'Family name, given names',
                minLength: 1,
                type: 'string'
              },
              orcid: {
                description: 'ORCID identifier',
                examples: ['0000-0002-1825-0097'],
                pattern: '[0-9]{4}-[0-9]{4}-[0-9]{4}-[0-9]{3}[0-9X]{1}',
                type: 'string'
              },
              type: {
                enum: ['ContactPerson', 'DataCollector', 'DataCurator', 'DataManager', 'Distributor', 'Editor', 'HostingInstitution', 'Other', 'Producer', 'ProjectLeader', 'ProjectManager', 'ProjectMember', 'RegistrationAgency', 'RegistrationAuthority', 'RelatedPerson', 'Researcher', 'ResearchGroup', 'RightsHolder', 'Sponsor', 'Supervisor', 'WorkPackageLeader', null],
                type: ['string', 'null']
              }
            },
            required: ['name', 'type'],
            type: 'object'
          },
          minItems: 0,
          type: 'array',
          uniqueItems: true
        },
        creators: {
          items: {
            additionalProperties: false,
            properties: {
              affiliation: {
                minLength: 1,
                type: ['string', 'null']
              },
              name: {
                description: 'Family name, given names',
                minLength: 1,
                type: 'string'
              },
              orcid: {
                description: 'ORCID identifier',
                examples: ['0000-0002-1825-0097'],
                pattern: '[0-9]{4}-[0-9]{4}-[0-9]{4}-[0-9]{3}[0-9X]{1}',
                type: 'string'
              }
            },
            required: ['name'],
            type: 'object'
          },
          type: 'array',
          uniqueItems: true,
          minItems: 1
        },
        description: {
          description: 'Description',
          type: 'string'
        },
        doi: {
          oneOf: [{
            examples: ['10.5281/zenodo.1003150'],
            pattern: String.raw`^10\.\d{4,9}(\.\d+)?/[A-Za-z0-9:/_;\-\.\(\)\[\]\\]+$`,
            type: 'string'
          }, {
            const: ''
          }]
        },
        embargo_date: {
          format: 'date',
          type: 'string'
        },
        grants: {
          items: {
            additionalProperties: true,
            examples: ['10.13039/501100000780::675191'],
            properties: {
              id: {
                type: 'string'
              }
            },
            required: [],
            type: 'object'
          },
          minItems: 0,
          type: 'array',
          uniqueItems: true
        },
        image_type: {
          enum: ['diagram', 'drawing', 'figure', 'other', 'photo', 'plot'],
          type: 'string'
        },
        imprint_isbn: {
          type: 'string'
        },
        imprint_place: {
          type: 'string'
        },
        imprint_publisher: {
          type: 'string'
        },
        journal_issue: {
          type: 'string'
        },
        journal_pages: {
          type: 'string'
        },
        journal_title: {
          type: 'string'
        },
        journal_volume: {
          type: 'string'
        },
        keywords: {
          items: {
            type: 'string'
          },
          minItems: 0,
          type: 'array',
          uniqueItems: true
        },
        language: {
          description: 'ISO 639 language identifier.',
          examples: ['ada', 'eng', 'bla'],
          pattern: '^[a-z]{2,3}$',
          type: 'string'
        },
        license: {
          anyOf: [licenseEnum, {
            type: 'string'
          }, {
            type: 'object',
            properties: {
              id: {
                anyOf: [licenseEnum, {
                  type: 'string'
                }]
              }
            },
            required: ['id'],
            additionalProperties: false
          }]
        },
        notes: {
          minLength: 0,
          type: 'string'
        },
        partof_pages: {
          type: 'string'
        },
        partof_title: {
          type: 'string'
        },
        publication_date: {
          description: 'Format: YYYY-MM-DD. In case your upload was already published elsewhere, please use the date of first publication.',
          examples: ['2013-05-08'],
          format: 'date',
          type: 'string'
        },
        publication_type: {
          enum: ['annotationcollection', 'article', 'book', 'conferencepaper', 'datamanagementplan', 'deliverable', 'milestone', 'other', 'patent', 'preprint', 'proposal', 'report', 'section', 'softwaredocumentation', 'taxonomictreatment', 'technicalnote', 'thesis', 'workingpaper'],
          type: 'string'
        },
        references: {
          items: {
            type: 'string'
          },
          minItems: 0,
          type: 'array',
          uniqueItems: true
        },
        related_identifiers: {
          items: {
            additionalProperties: false,
            properties: {
              identifier: {
                type: 'string'
              },
              relation: {
                enum: ['cites', 'compiles', 'continues', 'describes', 'documents', 'hasMetadata', 'hasPart', 'hasVersion', 'isAlternateIdentifier', 'isCitedBy', 'isCompiledBy', 'isContinuedBy', 'isDerivedFrom', 'isDescribedBy', 'isDocumentedBy', 'isIdenticalTo', 'isMetadataFor', 'isNewVersionOf', 'isObsoletedBy', 'isOriginalFormOf', 'isPartOf', 'isPreviousVersionOf', 'isPublishedIn', 'isReferencedBy', 'isRequiredBy', 'isReviewedBy', 'isSourceOf', 'isSupplementedBy', 'isSupplementTo', 'isVariantFormOf', 'isVersionOf', 'obsoletes', 'references', 'requires', 'reviews'],
                type: 'string'
              },
              resource_type: {
                enum: ['dataset', 'image-diagram', 'image-drawing', 'image-figure', 'image-other', 'image-photo', 'image-plot', 'lesson', 'other', 'physicalobject', 'poster', 'presentation', 'publication', 'publication-annotationcollection', 'publication-article', 'publication-book', 'publication-conferencepaper', 'publication-datamanagementplan', 'publication-deliverable', 'publication-milestone', 'publication-other', 'publication-patent', 'publication-preprint', 'publication-proposal', 'publication-report', 'publication-section', 'publication-softwaredocumentation', 'publication-taxonomictreatment', 'publication-technicalnote', 'publication-thesis', 'publication-workingpaper', 'software', 'video'],
                type: 'string'
              },
              scheme: {
                enum: ['ads', 'ark', 'arxiv', 'doi', 'ean13', 'handle', 'isbn', 'isni', 'issn', 'istc', 'lsid', 'orcid', 'pmid', 'purl', 'url', 'urn', 'other'],
                type: 'string'
              }
            },
            required: ['identifier', 'relation'],
            type: 'object'
          },
          minItems: 0,
          type: 'array',
          uniqueItems: true
        },
        resource_type: {
          properties: {
            type: {
              enum: ['dataset', 'image-diagram', 'image-drawing', 'image-figure', 'image-other', 'image-photo', 'image-plot', 'lesson', 'other', 'physicalobject', 'poster', 'presentation', 'publication', 'publication-annotationcollection', 'publication-article', 'publication-book', 'publication-conferencepaper', 'publication-datamanagementplan', 'publication-deliverable', 'publication-milestone', 'publication-other', 'publication-patent', 'publication-preprint', 'publication-proposal', 'publication-report', 'publication-section', 'publication-softwaredocumentation', 'publication-taxonomictreatment', 'publication-technicalnote', 'publication-thesis', 'publication-workingpaper', 'software', 'video'],
              type: 'string'
            },
            title: {
              type: 'string'
            }
          },
          type: 'object'
        },
        relations: {
          additionalProperties: false,
          properties: {
            version: {
              type: 'array',
              items: {
                type: 'object',
                properties: {
                  index: {
                    type: 'integer',
                    minimum: 0
                  },
                  is_last: {
                    type: 'boolean'
                  },
                  parent: {
                    type: 'object',
                    properties: {
                      pid_type: {
                        type: 'string'
                      },
                      pid_value: {
                        type: 'string'
                      }
                    }
                  }
                }
              }
            }
          },
          type: 'object'
        },
        subjects: {
          items: {
            additionalProperties: false,
            properties: {
              identifier: {
                type: 'string'
              },
              scheme: {
                enum: ['ads', 'ark', 'arxiv', 'ascl', 'bioproject', 'biosample', 'doi', 'ean13', 'ean8', 'ensembl', 'genome', 'gnd', 'hal', 'handle', 'isbn', 'isni', 'issn', 'istc', 'lsid', 'orcid', 'pmcid', 'pmid', 'purl', 'refseq', 'sra', 'swh', 'uniprot', 'url', 'urn'],
                type: 'string'
              },
              term: {
                type: 'string'
              }
            },
            required: ['identifier', 'term'],
            type: 'object'
          },
          minItems: 0,
          type: 'array',
          uniqueItems: true
        },
        thesis_supervisors: {
          items: {
            additionalProperties: false,
            properties: {
              affiliation: {
                minLength: 1,
                type: ['string', 'null']
              },
              name: {
                description: 'Family name, given names',
                minLength: 1,
                type: 'string'
              },
              orcid: {
                description: 'ORCID identifier',
                examples: ['0000-0002-1825-0097'],
                pattern: '[0-9]{4}-[0-9]{4}-[0-9]{4}-[0-9]{3}[0-9X]{1}',
                type: 'string'
              }
            },
            required: ['name'],
            type: 'object'
          },
          minItems: 0,
          type: 'array',
          uniqueItems: true
        },
        thesis_university: {
          type: 'string'
        },
        title: {
          type: 'string'
        },
        upload_type: {
          enum: ['dataset', 'image', 'lesson', 'other', 'physicalobject', 'poster', 'presentation', 'publication', 'software', 'video'],
          type: 'string'
        },
        version: {
          type: 'string'
        },
        prereserve_doi: {
          type: 'object',
          required: ['doi', 'recid'],
          properties: {
            doi: {
              type: 'string'
            },
            recid: {
              type: 'integer'
            }
          },
          additionalProperties: false
        }
      },
      required: [],
      type: 'object'
    };

    const zenodoDepositionSchema = {
      $schema: 'http://json-schema.org/draft-07/schema#',
      title: 'Deposition',
      type: 'object',
      properties: {
        created: {
          type: 'string',
          format: 'date-time',
          description: 'Creation time of deposition (ISO8601 format).'
        },
        modified: {
          type: 'string',
          format: 'date-time',
          description: 'Last modification time of deposition (ISO8601 format).'
        },
        doi: {
          type: 'string',
          description: 'Digital Object Identifier (DOI). Present only for published depositions.'
        },
        doi_url: {
          type: 'string',
          format: 'uri',
          description: 'Persistent link to your published deposition. Present only for published depositions.'
        },
        files: {
          type: 'array',
          description: 'A list of deposition files resources.',
          items: {
            type: 'object'
          }
        },
        id: {
          type: 'integer',
          description: 'Deposition identifier.'
        },
        metadata: zenodoMetadataSchema,
        owner: {
          type: 'integer',
          description: 'User identifier of the owner of the deposition.'
        },
        record_id: {
          type: 'integer',
          description: 'Record identifier. Present only for published depositions.'
        },
        record_url: {
          type: 'string',
          format: 'uri',
          description: 'URL to public version of record for this deposition. Present only for published depositions.'
        },
        state: {
          type: 'string',
          enum: ['inprogress', 'done', 'error', 'unsubmitted'],
          description: 'State of deposition: inprogress, done, or error.'
        },
        submitted: {
          type: 'boolean',
          description: 'True if the deposition has been published, False otherwise.'
        },
        title: {
          type: 'string',
          description: 'Title of deposition (automatically set from metadata). Defaults to empty string.'
        },
        conceptrecid: {
          type: 'string',
          description: 'Concept record ID.'
        },
        links: {
          type: 'object',
          description: 'Links related to the deposition.'
        },
        conceptdoi: {
          type: 'string',
          description: 'Concept DOI.'
        }
      },
      required: [],
      additionalProperties: false
    };

    const zenodoFileSchema = {
      $schema: 'http://json-schema.org/draft-07/schema#',
      title: 'Zenodo File',
      type: 'object',
      properties: {
        id: {
          type: 'string'
        },
        filename: {
          type: 'string'
        },
        filesize: {
          type: 'number'
        },
        checksum: {
          type: 'string'
        },
        links: {
          type: 'object',
          properties: {
            download: {
              type: 'string',
              format: 'uri'
            },
            self: {
              type: 'string',
              format: 'uri'
            }
          },
          required: ['download', 'self'],
          additionalProperties: false
        }
      },
      required: ['id', 'filename', 'filesize', 'checksum', 'links'],
      additionalProperties: false
    };

    const modifiedDepositionSchema = {
      ...zenodoDepositionSchema,
      additionalProperties: true,
      // Change this to match the record schema
      properties: {
        ...zenodoDepositionSchema.properties,
        record_id: {
          type: 'integer',
          description: 'Record identifier. Present only for published depositions.'
        }
      }
    };
    const zenodoRecordSchema = {
      $schema: 'http://json-schema.org/draft-07/schema#',
      title: 'ZenodoRecord',
      allOf: [modifiedDepositionSchema, {
        type: 'object',
        required: [],
        properties: {
          recid: {
            type: 'string'
          },
          updated: {
            type: 'string',
            format: 'date-time'
          },
          revision: {
            type: 'number'
          },
          swh: {
            type: 'object',
            additionalProperties: true // structure is not known
          },
          owners: {
            type: 'array',
            items: {
              type: 'object',
              properties: {
                id: {
                  type: 'string'
                }
              },
              required: ['id'],
              additionalProperties: false
            }
          },
          status: {
            type: 'string'
          },
          stats: {
            type: 'object',
            properties: {
              downloads: {
                type: 'number'
              },
              unique_downloads: {
                type: 'number'
              },
              views: {
                type: 'number'
              },
              unique_views: {
                type: 'number'
              },
              version_downloads: {
                type: 'number'
              },
              version_unique_downloads: {
                type: 'number'
              },
              version_views: {
                type: 'number'
              },
              version_unique_views: {
                type: 'number'
              }
            },
            required: ['downloads', 'unique_downloads', 'views', 'unique_views', 'version_downloads', 'version_unique_downloads', 'version_views', 'version_unique_views'],
            additionalProperties: false
          }
        },
        additionalProperties: true
      }]
    };

    const ZenodoReviewSchema = {
      $schema: 'http://json-schema.org/draft-07/schema#',
      title: 'ZenodoReview',
      type: 'object',
      properties: {
        id: {
          type: 'number'
        },
        created: {
          type: 'string',
          format: 'date-time'
        },
        updated: {
          type: 'string',
          format: 'date-time'
        },
        links: {
          type: 'object',
          properties: {
            actions: {
              type: 'object',
              properties: {
                accept: {
                  type: 'string'
                },
                decline: {
                  type: 'string'
                },
                cancel: {
                  type: 'string'
                },
                submit: {
                  type: 'string'
                } // Only appears in the record/review endpoint but is not accessible (probably a bug)
              },
              additionalProperties: false
            },
            self: {
              type: 'string'
            },
            self_html: {
              type: 'string'
            },
            comments: {
              type: 'string'
            },
            timeline: {
              type: 'string'
            }
          },
          required: ['self', 'self_html', 'comments', 'timeline'],
          additionalProperties: false
        },
        revision_id: {
          type: 'number'
        },
        type: {
          type: 'string'
        },
        status: {
          type: 'string'
        },
        is_closed: {
          type: 'boolean'
        },
        is_open: {
          type: 'boolean'
        },
        expires_at: {
          type: 'string',
          format: 'date-time'
        },
        is_expired: {
          type: 'boolean'
        },
        created_by: {
          type: 'object',
          properties: {
            user: {
              type: 'string'
            }
          },
          required: ['user'],
          additionalProperties: false
        },
        receiver: {
          type: 'object',
          properties: {
            community: {
              type: 'string'
            }
          },
          required: ['community'],
          additionalProperties: false
        },
        topic: {
          type: 'object',
          properties: {
            record: {
              type: 'string'
            }
          },
          required: ['record'],
          additionalProperties: false
        }
      },
      required: ['id', 'created', 'updated', 'links', 'revision_id', 'type', 'status', 'is_closed', 'is_open', 'expires_at', 'is_expired', 'created_by', 'receiver', 'topic'],
      additionalProperties: false
    };

    const {
      ORCID
    } = orcidPkg;
    // eslint-disable-next-line new-cap
    const ajv = new Ajv.default({
      allErrors: true
    });
    addFormats.default(ajv);
    const validateMetadata = ajv.compile(zenodoMetadataSchema);
    /**
     * Validate Zenodo metadata against the schema
     * @param metadata - Zenodo metadata object to validate
     * @throws {Error} If the metadata does not conform to the Zenodo schema
     * @returns The validated Zenodo metadata object
     */
    function validateZenodoMetadata(metadata) {
      const isValid = validateMetadata(metadata);
      if (!isValid) {
        throw new Error(JSON.stringify(validateMetadata.errors, null, 2));
      }
      const validatedMetadata = metadata;
      if (validatedMetadata.creators) {
        for (const creator of validatedMetadata.creators) {
          if (creator.orcid) {
            validateORCID(creator.orcid);
          }
        }
      }
      return validatedMetadata;
    }
    const validateDeposition = ajv.compile(zenodoDepositionSchema);
    /**
     * Validate Zenodo deposition against the schema
     * @param deposition - Zenodo deposition object to validate
     * @param logger - FifoLogger instance for logging
     * @throws {Error} If the deposition does not conform to the Zenodo schema
     * @returns The validated Zenodo deposition object
     */
    function validateZenodoDeposition(deposition, logger) {
      const licenses = [...licenseEnum.enum];
      const isValid = validateDeposition(deposition);
      if (!isValid) {
        throw new Error(JSON.stringify(validateDeposition.errors, null, 2));
      }
      const validatedDeposition = deposition;
      const license = validatedDeposition.metadata?.license;
      if (!license) {
        logger?.warn(`Invalid license "${license}". Valid licenses are: ${licenses.join(', ')}`);
      }
      if (validatedDeposition?.metadata?.creators) {
        for (const creator of validatedDeposition.metadata.creators) {
          if (creator.orcid) {
            validateORCID(creator.orcid);
          }
        }
      }
      return validatedDeposition;
    }
    const validateRecord = ajv.compile(zenodoRecordSchema);
    /**
     * Validate Zenodo record against the schema
     * @param record - Zenodo record object to validate
     * @throws {Error} If the record does not conform to the Zenodo schema
     * @returns The validated Zenodo record object
     */
    function validateZenodoRecord(record) {
      const isValid = validateRecord(record);
      if (!isValid) {
        throw new Error(JSON.stringify(validateRecord.errors, null, 2));
      }
      return record;
    }
    const validateFile = ajv.compile(zenodoFileSchema);
    /**
     * Validate Zenodo file against the schema
     * @param file - Zenodo deposition object to validate
     * @throws {Error} If the deposition does not conform to the Zenodo schema
     * @returns The validated Zenodo file object
     */
    function validateZenodoFile(file) {
      const isValid = validateFile(file);
      if (!isValid) {
        throw new Error(JSON.stringify(validateMetadata.errors, null, 2));
      }
      return file;
    }
    const validateRequest = ajv.compile(ZenodoReviewSchema);
    /**
     * Validate Zenodo request against the schema
     * @param request - Zenodo request object to validate
     * @throws {Error} If the request does not conform to the Zenodo schema
     * @returns The validated Zenodo request object
     */
    function validateZenodoRequest(request) {
      const isValid = validateRequest(request);
      if (!isValid) {
        throw new Error(JSON.stringify(validateRequest.errors, null, 2));
      }
      return request;
    }
    /**
     * This function checks if the provided ORCID ID is valid and returns it in dash format.
     * @param id - ORCID ID to validate
     * @throws {Error} If the ORCID ID is invalid or not provided
     * @returns The ORCID ID in dash format
     */
    function validateORCID(id) {
      if (!id) {
        throw new Error('ORCID is required');
      }
      const isValid = ORCID.isValid(id);
      if (!isValid) {
        throw new Error(`Invalid ORCID: ${id}`);
      }
      return ORCID.toDashFormat(id);
    }

    class ZenodoFile {
      zenodo;
      value;
      constructor(zenodo, file) {
        this.value = validateZenodoFile(file);
        this.zenodo = zenodo;
      }
      async getContentResponse() {
        const link = this.value.links.download;
        const response = await fetch(link, {
          headers: {
            Authorization: `Bearer ${this.zenodo.accessToken}`
          }
        });
        if (!response.ok) {
          throw new Error(`Failed to fetch ${link}`);
        }
        return response;
      }
    }

    const responseStatuses = {
      200: {
        code: 200,
        name: 'OK',
        description: 'Request succeeded. Response included. Usually sent for GET/PUT/PATCH requests.'
      },
      201: {
        code: 201,
        name: 'Created',
        description: 'Request succeeded. Response included. Usually sent for POST requests.'
      },
      202: {
        code: 202,
        name: 'Accepted',
        description: 'Request succeeded. Response included. Usually sent for POST requests, where background processing is needed to fulfill the request.'
      },
      204: {
        code: 204,
        name: 'No Content',
        description: 'Request succeeded. No response included. Usually sent for DELETE requests.'
      },
      400: {
        code: 400,
        name: 'Bad Request',
        description: 'Request failed. Error response included.'
      },
      401: {
        code: 401,
        name: 'Unauthorized',
        description: 'Request failed, due to an invalid access token. Error response included.'
      },
      403: {
        code: 403,
        name: 'Forbidden',
        description: 'Request failed, due to missing authorization (e.g. deleting an already submitted upload or missing scopes for your access token). Error response included.'
      },
      404: {
        code: 404,
        name: 'Not Found',
        description: 'Request failed, due to the resource not being found. Error response included.'
      },
      405: {
        code: 405,
        name: 'Method Not Allowed',
        description: 'Request failed, due to unsupported HTTP method. Error response included.'
      },
      409: {
        code: 409,
        name: 'Conflict',
        description: 'Request failed, due to the current state of the resource (e.g. edit a deposition which is not fully integrated). Error response included.'
      },
      415: {
        code: 415,
        name: 'Unsupported Media Type',
        description: 'Request failed, due to missing or invalid request header Content-Type. Error response included.'
      },
      429: {
        code: 429,
        name: 'Too Many Requests',
        description: 'Request failed, due to rate limiting. Error response included.'
      },
      500: {
        code: 500,
        name: 'Internal Server Error',
        description: 'Request failed, due to an internal server error. Error response NOT included. Don’t worry, Zenodo admins have been notified and will be dealing with the problem ASAP.'
      }
    };

    /**
     * Extract rate limit information from response headers.
     * @param response - The fetch response object.
     * @returns The rate limit information or null if not present.
     */
    function extractRateLimitInfo(response) {
      const limit = response.headers.get('X-RateLimit-Limit');
      const remaining = response.headers.get('X-RateLimit-Remaining');
      const reset = response.headers.get('X-RateLimit-Reset');
      if (!limit || !remaining || !reset) {
        return null;
      }
      return {
        limit: Number.parseInt(limit, 10),
        remaining: Number.parseInt(remaining, 10),
        reset: Number.parseInt(reset, 10)
      };
    }
    /**
     * Calculate delay based on rate limit information.
     * @param rateLimitInfo - The rate limit information extracted from response headers.
     * @returns Delay in milliseconds to wait before retrying.
     */
    function calculateRateLimitDelay(rateLimitInfo) {
      if (rateLimitInfo.remaining > 0) {
        return 0;
      }
      const now = Math.floor(Date.now() / 1000);
      const waitTime = Math.max(0, rateLimitInfo.reset - now);
      return (waitTime + 1) * 1000;
    }
    /**
     * Determine if an error is retryable based on status code.
     * @param status - The HTTP status code of the response.
     * @param zenodo - The Zenodo instance
     * @returns True if the error is retryable, false otherwise.
     */
    async function shouldRetry(status, zenodo) {
      if (status === 429 || status >= 500 && status < 600 || status === 408) {
        zenodo.logger?.debug(`Retrying status ${status} - server/rate limit error`);
        return true;
      }
      const isAuthError = (status === 401 || status === 403) && (zenodo.authenticationState === ZenodoAuthenticationStates.NOT_TRIED || zenodo.authenticationState === ZenodoAuthenticationStates.SUCCEEDED);
      if (isAuthError) {
        zenodo.logger?.debug(`Auth error detected (${status}), current state: ${zenodo.authenticationState}`);
        zenodo.logger?.debug('Attempting to verify authentication...');
        try {
          await zenodo.verifyAuthentication();
          zenodo.logger?.debug(`Authentication verification completed, new state: ${zenodo.authenticationState}`);
          return true;
        } catch (error) {
          zenodo.logger?.error(`Authentication verification failed: ${error instanceof Error ? error.message : String(error)}`);
          return false;
        }
      }
      return false;
    }
    /**
     * Sleep for a specified number of milliseconds.
     * @param ms - The number of milliseconds to sleep
     */
    function sleep(ms) {
      return new Promise(resolve => {
        setTimeout(resolve, ms);
      });
    }
    /**
     * Calculate the appropriate delay for a retry attempt.
     * @param attempt - Current attempt number (0-based)
     * @param response - The failed response
     * @param rateLimitInfo - Rate limit information from headers
     * @param options - Retry options
     * @returns Delay in milliseconds
     */
    function calculateRetryDelay(attempt, response, rateLimitInfo, options) {
      const {
        baseDelay = 1000,
        useExponentialBackoff = true,
        respectRateLimit = true
      } = options;
      if (response.status === 429 && respectRateLimit && rateLimitInfo) {
        // Rate limit hit - respect the rate limit headers
        return calculateRateLimitDelay(rateLimitInfo);
      }
      // Other retryable error - use exponential backoff
      const delay = useExponentialBackoff ? baseDelay * 2 ** attempt : baseDelay;
      // Add jitter to prevent thundering herd
      return delay + Math.random() * 1000;
    }
    /**
     * Perform a single fetch attempt.
     * @param zenodo - The Zenodo instance
     * @param url - The URL to fetch
     * @param requestOptions - The fetch options
     * @param expectedStatus - The expected response status
     * @param attempt - Current attempt number (0-based)
     * @returns The response or throws an error
     */
    async function performFetchAttempt(zenodo, url, requestOptions, expectedStatus, attempt) {
      zenodo.logger?.debug(`Attempt ${attempt + 1} for ${requestOptions.method} ${url}`);
      const response = await fetch(url, requestOptions);
      // Check rate limit headers
      const rateLimitInfo = extractRateLimitInfo(response);
      if (rateLimitInfo && zenodo.logger) {
        zenodo.logger.debug(`Rate limit status: ${rateLimitInfo.remaining}/${rateLimitInfo.limit} remaining, resets at ${rateLimitInfo.reset}`);
      }
      return response;
    }
    /**
     * Handle a failed response and determine if retry is appropriate.
     * @param zenodo - The Zenodo instance
     * @param response - The failed response
     * @param url - The request URL
     * @param method - The request method
     * @param contentType - The request content type
     * @param body - The request body
     * @returns Error to throw
     */
    async function handleFailedResponse(zenodo, response, url, method, contentType, body) {
      const errorMessage = responseStatuses[response.status]?.description || response.statusText;
      if (!(await shouldRetry(response.status, zenodo))) {
        zenodo.logger?.error(`Non-retryable error fetching ${url} with ${method}: ${errorMessage}`);
      }
      return new Error(errorMessage, {
        cause: {
          url,
          method,
          contentType,
          body,
          response
        }
      });
    }
    /**
     * Retry logic using recursive approach to avoid await in loops.
     * @param zenodo - The Zenodo instance
     * @param url - The URL to fetch
     * @param requestOptions - The fetch options
     * @param fetchOptions - The original fetch options
     * @param attempt - Current attempt number (0-based)
     * @returns The successful response
     */
    async function retryFetch(zenodo, url, requestOptions, fetchOptions, attempt) {
      const {
        expectedStatus,
        maxRetries,
        method = 'GET',
        contentType,
        body
      } = fetchOptions;
      try {
        const response = await performFetchAttempt(zenodo, url, requestOptions, expectedStatus, attempt);
        if (response.status === expectedStatus) {
          if (attempt > 0) {
            zenodo.logger?.info(`Request succeeded after ${attempt} retries`);
          }
          return response;
        }
        if (!(await shouldRetry(response.status, zenodo))) {
          throw await handleFailedResponse(zenodo, response, url, method, contentType, body);
        }
        if (attempt >= maxRetries) {
          throw await handleFailedResponse(zenodo, response, url, method, contentType, body);
        }
        const rateLimitInfo = extractRateLimitInfo(response);
        const delay = calculateRetryDelay(attempt, response, rateLimitInfo, fetchOptions);
        if (response.status === 429 && fetchOptions.respectRateLimit && rateLimitInfo) {
          zenodo.logger?.warn(`Rate limit exceeded. Waiting ${delay}ms before retry (attempt ${attempt + 1}/${maxRetries + 1})`);
        } else {
          zenodo.logger?.warn(`Retryable error (${response.status}). Waiting ${delay}ms before retry (attempt ${attempt + 1}/${maxRetries + 1})`);
        }
        await sleep(delay);
        return await retryFetch(zenodo, url, requestOptions, fetchOptions, attempt + 1);
      } catch (error) {
        if (error instanceof Error) {
          if (error.cause && typeof error.cause === 'object' && 'response' in error.cause) {
            throw error;
          }
          if (attempt >= maxRetries) {
            zenodo.logger?.error(`All ${maxRetries + 1} attempts failed for ${method} ${url}`);
            throw error;
          }
          const delay = fetchOptions.useExponentialBackoff ? fetchOptions.baseDelay * 2 ** attempt : fetchOptions.baseDelay;
          zenodo.logger?.warn(`Network error: ${error.message}. Waiting ${delay}ms before retry (attempt ${attempt + 1}/${maxRetries + 1})`);
          await sleep(delay);
          return retryFetch(zenodo, url, requestOptions, fetchOptions, attempt + 1);
        } else {
          throw error;
        }
      }
    }
    /**
     * Fetch data from the Zenodo API with retry logic.
     * @param zenodo - The Zenodo instance containing the base URL and access token.
     * @param options - The options for the fetch request.
     * @returns The response from the Zenodo API.
     */
    async function fetchZenodo(zenodo, options) {
      const {
        body,
        route = 'deposit/depositions',
        method = 'GET',
        contentType = body instanceof FormData ? undefined : 'application/json',
        expectedStatus = 200,
        searchParams,
        maxRetries = 3,
        baseDelay = 1000,
        useExponentialBackoff = true,
        respectRateLimit = true
      } = options;
      let url;
      if (searchParams) {
        const urlSearchParams = new URLSearchParams(searchParams);
        url = zenodo.baseURL + route + (urlSearchParams ? `?${urlSearchParams.toString()}` : '');
      } else {
        url = zenodo.baseURL + route;
      }
      const headers = new Headers();
      if (zenodo.accessToken) {
        headers.set('Authorization', `Bearer ${zenodo.accessToken}`);
      }
      if (contentType) {
        headers.set('Content-Type', contentType);
      }
      const requestOptions = {
        method,
        headers,
        body
      };
      const fetchOptionsWithDefaults = {
        expectedStatus,
        maxRetries,
        baseDelay,
        useExponentialBackoff,
        respectRateLimit,
        method,
        contentType,
        body
      };
      return retryFetch(zenodo, url, requestOptions, fetchOptionsWithDefaults, 0);
    }

    /*
     Copyright (c) 2022 Gildas Lormeau. All rights reserved.

     Redistribution and use in source and binary forms, with or without
     modification, are permitted provided that the following conditions are met:

     1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright 
     notice, this list of conditions and the following disclaimer in 
     the documentation and/or other materials provided with the distribution.

     3. The names of the authors may not be used to endorse or promote products
     derived from this software without specific prior written permission.

     THIS SOFTWARE IS PROVIDED ''AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
     INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
     FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JCRAFT,
     INC. OR ANY CONTRIBUTORS TO THIS SOFTWARE BE LIABLE FOR ANY DIRECT, INDIRECT,
     INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
     LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
     OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
     LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
     NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
     EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     */

    const MAX_32_BITS = 0xffffffff;
    const MAX_16_BITS = 0xffff;
    const COMPRESSION_METHOD_DEFLATE = 0x08;
    const COMPRESSION_METHOD_DEFLATE_64 = 0x09;
    const COMPRESSION_METHOD_STORE = 0x00;
    const COMPRESSION_METHOD_AES = 0x63;
    const LOCAL_FILE_HEADER_SIGNATURE = 0x04034b50;
    const SPLIT_ZIP_FILE_SIGNATURE = 0x08074b50;
    const DATA_DESCRIPTOR_RECORD_SIGNATURE = SPLIT_ZIP_FILE_SIGNATURE;
    const CENTRAL_FILE_HEADER_SIGNATURE = 0x02014b50;
    const END_OF_CENTRAL_DIR_SIGNATURE = 0x06054b50;
    const ZIP64_END_OF_CENTRAL_DIR_SIGNATURE = 0x06064b50;
    const ZIP64_END_OF_CENTRAL_DIR_LOCATOR_SIGNATURE = 0x07064b50;
    const END_OF_CENTRAL_DIR_LENGTH = 22;
    const ZIP64_END_OF_CENTRAL_DIR_LOCATOR_LENGTH = 20;
    const ZIP64_END_OF_CENTRAL_DIR_LENGTH = 56;
    const ZIP64_END_OF_CENTRAL_DIR_TOTAL_LENGTH = END_OF_CENTRAL_DIR_LENGTH + ZIP64_END_OF_CENTRAL_DIR_LOCATOR_LENGTH + ZIP64_END_OF_CENTRAL_DIR_LENGTH;
    const EXTRAFIELD_TYPE_ZIP64 = 0x0001;
    const EXTRAFIELD_TYPE_AES = 0x9901;
    const EXTRAFIELD_TYPE_NTFS = 0x000a;
    const EXTRAFIELD_TYPE_NTFS_TAG1 = 0x0001;
    const EXTRAFIELD_TYPE_EXTENDED_TIMESTAMP = 0x5455;
    const EXTRAFIELD_TYPE_UNICODE_PATH = 0x7075;
    const EXTRAFIELD_TYPE_UNICODE_COMMENT = 0x6375;
    const EXTRAFIELD_TYPE_USDZ = 0x1986;
    const BITFLAG_ENCRYPTED = 0b1;
    const BITFLAG_LEVEL = 0b0110;
    const BITFLAG_LEVEL_MAX_MASK = 0b010;
    const BITFLAG_LEVEL_FAST_MASK = 0b100;
    const BITFLAG_LEVEL_SUPER_FAST_MASK = 0b110;
    const BITFLAG_DATA_DESCRIPTOR = 0b1000;
    const BITFLAG_LANG_ENCODING_FLAG = 0b100000000000;
    const FILE_ATTR_MSDOS_DIR_MASK = 0b10000;
    const FILE_ATTR_UNIX_TYPE_MASK = 0o170000;
    const FILE_ATTR_UNIX_TYPE_DIR = 0o040000;
    const FILE_ATTR_UNIX_EXECUTABLE_MASK = 0o111;
    const FILE_ATTR_UNIX_DEFAULT_MASK = 0o644;
    const VERSION_DEFLATE = 0x14;
    const VERSION_ZIP64 = 0x2D;
    const VERSION_AES = 0x33;
    const DIRECTORY_SIGNATURE = "/";
    const HEADER_SIZE = 26;
    const HEADER_OFFSET_SIGNATURE = 10;
    const HEADER_OFFSET_COMPRESSED_SIZE = 14;
    const HEADER_OFFSET_UNCOMPRESSED_SIZE = 18;
    const MAX_DATE = new Date(2107, 11, 31);
    const MIN_DATE = new Date(1980, 0, 1);
    const UNDEFINED_VALUE = undefined;
    const UNDEFINED_TYPE = "undefined";
    const FUNCTION_TYPE = "function";

    /*
     Copyright (c) 2022 Gildas Lormeau. All rights reserved.

     Redistribution and use in source and binary forms, with or without
     modification, are permitted provided that the following conditions are met:

     1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright 
     notice, this list of conditions and the following disclaimer in 
     the documentation and/or other materials provided with the distribution.

     3. The names of the authors may not be used to endorse or promote products
     derived from this software without specific prior written permission.

     THIS SOFTWARE IS PROVIDED ''AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
     INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
     FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JCRAFT,
     INC. OR ANY CONTRIBUTORS TO THIS SOFTWARE BE LIABLE FOR ANY DIRECT, INDIRECT,
     INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
     LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
     OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
     LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
     NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
     EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     */

    class StreamAdapter {
      constructor(Codec) {
        return class extends TransformStream {
          constructor(_format, options) {
            const codec = new Codec(options);
            super({
              transform(chunk, controller) {
                controller.enqueue(codec.append(chunk));
              },
              flush(controller) {
                const chunk = codec.flush();
                if (chunk) {
                  controller.enqueue(chunk);
                }
              }
            });
          }
        };
      }
    }

    /*
     Copyright (c) 2022 Gildas Lormeau. All rights reserved.

     Redistribution and use in source and binary forms, with or without
     modification, are permitted provided that the following conditions are met:

     1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright 
     notice, this list of conditions and the following disclaimer in 
     the documentation and/or other materials provided with the distribution.

     3. The names of the authors may not be used to endorse or promote products
     derived from this software without specific prior written permission.

     THIS SOFTWARE IS PROVIDED ''AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
     INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
     FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JCRAFT,
     INC. OR ANY CONTRIBUTORS TO THIS SOFTWARE BE LIABLE FOR ANY DIRECT, INDIRECT,
     INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
     LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
     OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
     LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
     NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
     EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     */

    const MINIMUM_CHUNK_SIZE = 64;
    let maxWorkers = 2;
    try {
      if (typeof navigator != UNDEFINED_TYPE && navigator.hardwareConcurrency) {
        maxWorkers = navigator.hardwareConcurrency;
      }
      // eslint-disable-next-line no-unused-vars
    } catch (_) {
      // ignored
    }
    const DEFAULT_CONFIGURATION = {
      chunkSize: 512 * 1024,
      maxWorkers,
      terminateWorkerTimeout: 5000,
      useWebWorkers: true,
      useCompressionStream: true,
      workerScripts: UNDEFINED_VALUE,
      CompressionStreamNative: typeof CompressionStream != UNDEFINED_TYPE && CompressionStream,
      DecompressionStreamNative: typeof DecompressionStream != UNDEFINED_TYPE && DecompressionStream
    };
    const config = Object.assign({}, DEFAULT_CONFIGURATION);
    function getConfiguration() {
      return config;
    }
    function getChunkSize(config) {
      return Math.max(config.chunkSize, MINIMUM_CHUNK_SIZE);
    }
    function configure(configuration) {
      const {
        baseURL,
        chunkSize,
        maxWorkers,
        terminateWorkerTimeout,
        useCompressionStream,
        useWebWorkers,
        Deflate,
        Inflate,
        CompressionStream,
        DecompressionStream,
        workerScripts
      } = configuration;
      setIfDefined("baseURL", baseURL);
      setIfDefined("chunkSize", chunkSize);
      setIfDefined("maxWorkers", maxWorkers);
      setIfDefined("terminateWorkerTimeout", terminateWorkerTimeout);
      setIfDefined("useCompressionStream", useCompressionStream);
      setIfDefined("useWebWorkers", useWebWorkers);
      if (Deflate) {
        config.CompressionStream = new StreamAdapter(Deflate);
      }
      if (Inflate) {
        config.DecompressionStream = new StreamAdapter(Inflate);
      }
      setIfDefined("CompressionStream", CompressionStream);
      setIfDefined("DecompressionStream", DecompressionStream);
      if (workerScripts !== UNDEFINED_VALUE) {
        const {
          deflate,
          inflate
        } = workerScripts;
        if (deflate || inflate) {
          if (!config.workerScripts) {
            config.workerScripts = {};
          }
        }
        if (deflate) {
          if (!Array.isArray(deflate)) {
            throw new Error("workerScripts.deflate must be an array");
          }
          config.workerScripts.deflate = deflate;
        }
        if (inflate) {
          if (!Array.isArray(inflate)) {
            throw new Error("workerScripts.inflate must be an array");
          }
          config.workerScripts.inflate = inflate;
        }
      }
    }
    function setIfDefined(propertyName, propertyValue) {
      if (propertyValue !== UNDEFINED_VALUE) {
        config[propertyName] = propertyValue;
      }
    }

    /*
     Copyright (c) 2022 Gildas Lormeau. All rights reserved.

     Redistribution and use in source and binary forms, with or without
     modification, are permitted provided that the following conditions are met:

     1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright 
     notice, this list of conditions and the following disclaimer in 
     the documentation and/or other materials provided with the distribution.

     3. The names of the authors may not be used to endorse or promote products
     derived from this software without specific prior written permission.

     THIS SOFTWARE IS PROVIDED ''AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
     INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
     FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JCRAFT,
     INC. OR ANY CONTRIBUTORS TO THIS SOFTWARE BE LIABLE FOR ANY DIRECT, INDIRECT,
     INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
     LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
     OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
     LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
     NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
     EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     */

    const table = [];
    for (let i = 0; i < 256; i++) {
      let t = i;
      for (let j = 0; j < 8; j++) {
        if (t & 1) {
          t = t >>> 1 ^ 0xEDB88320;
        } else {
          t = t >>> 1;
        }
      }
      table[i] = t;
    }
    class Crc32 {
      constructor(crc) {
        this.crc = crc || -1;
      }
      append(data) {
        let crc = this.crc | 0;
        for (let offset = 0, length = data.length | 0; offset < length; offset++) {
          crc = crc >>> 8 ^ table[(crc ^ data[offset]) & 0xFF];
        }
        this.crc = crc;
      }
      get() {
        return ~this.crc;
      }
    }

    /*
     Copyright (c) 2022 Gildas Lormeau. All rights reserved.

     Redistribution and use in source and binary forms, with or without
     modification, are permitted provided that the following conditions are met:

     1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright 
     notice, this list of conditions and the following disclaimer in 
     the documentation and/or other materials provided with the distribution.

     3. The names of the authors may not be used to endorse or promote products
     derived from this software without specific prior written permission.

     THIS SOFTWARE IS PROVIDED ''AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
     INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
     FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JCRAFT,
     INC. OR ANY CONTRIBUTORS TO THIS SOFTWARE BE LIABLE FOR ANY DIRECT, INDIRECT,
     INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
     LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
     OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
     LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
     NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
     EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     */

    class Crc32Stream extends TransformStream {
      constructor() {
        // deno-lint-ignore prefer-const
        let stream;
        const crc32 = new Crc32();
        super({
          transform(chunk, controller) {
            crc32.append(chunk);
            controller.enqueue(chunk);
          },
          flush() {
            const value = new Uint8Array(4);
            const dataView = new DataView(value.buffer);
            dataView.setUint32(0, crc32.get());
            stream.value = value;
          }
        });
        stream = this;
      }
    }

    /*
     Copyright (c) 2022 Gildas Lormeau. All rights reserved.

     Redistribution and use in source and binary forms, with or without
     modification, are permitted provided that the following conditions are met:

     1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright 
     notice, this list of conditions and the following disclaimer in 
     the documentation and/or other materials provided with the distribution.

     3. The names of the authors may not be used to endorse or promote products
     derived from this software without specific prior written permission.

     THIS SOFTWARE IS PROVIDED ''AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
     INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
     FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JCRAFT,
     INC. OR ANY CONTRIBUTORS TO THIS SOFTWARE BE LIABLE FOR ANY DIRECT, INDIRECT,
     INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
     LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
     OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
     LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
     NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
     EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     */

    function encodeText(value) {
      if (typeof TextEncoder == UNDEFINED_TYPE) {
        value = unescape(encodeURIComponent(value));
        const result = new Uint8Array(value.length);
        for (let i = 0; i < result.length; i++) {
          result[i] = value.charCodeAt(i);
        }
        return result;
      } else {
        return new TextEncoder().encode(value);
      }
    }

    // Derived from https://github.com/xqdoo00o/jszip/blob/master/lib/sjcl.js and https://github.com/bitwiseshiftleft/sjcl

    // deno-lint-ignore-file no-this-alias

    /*
     * SJCL is open. You can use, modify and redistribute it under a BSD
     * license or under the GNU GPL, version 2.0.
     */

    /** @fileOverview Javascript cryptography implementation.
     *
     * Crush to remove comments, shorten variable names and
     * generally reduce transmission size.
     *
     * @author Emily Stark
     * @author Mike Hamburg
     * @author Dan Boneh
     */

    /*jslint indent: 2, bitwise: false, nomen: false, plusplus: false, white: false, regexp: false */

    /** @fileOverview Arrays of bits, encoded as arrays of Numbers.
     *
     * @author Emily Stark
     * @author Mike Hamburg
     * @author Dan Boneh
     */

    /**
     * Arrays of bits, encoded as arrays of Numbers.
     * @namespace
     * @description
     * <p>
     * These objects are the currency accepted by SJCL's crypto functions.
     * </p>
     *
     * <p>
     * Most of our crypto primitives operate on arrays of 4-byte words internally,
     * but many of them can take arguments that are not a multiple of 4 bytes.
     * This library encodes arrays of bits (whose size need not be a multiple of 8
     * bits) as arrays of 32-bit words.  The bits are packed, big-endian, into an
     * array of words, 32 bits at a time.  Since the words are double-precision
     * floating point numbers, they fit some extra data.  We use this (in a private,
     * possibly-changing manner) to encode the number of bits actually  present
     * in the last word of the array.
     * </p>
     *
     * <p>
     * Because bitwise ops clear this out-of-band data, these arrays can be passed
     * to ciphers like AES which want arrays of words.
     * </p>
     */
    const bitArray = {
      /**
       * Concatenate two bit arrays.
       * @param {bitArray} a1 The first array.
       * @param {bitArray} a2 The second array.
       * @return {bitArray} The concatenation of a1 and a2.
       */
      concat(a1, a2) {
        if (a1.length === 0 || a2.length === 0) {
          return a1.concat(a2);
        }
        const last = a1[a1.length - 1],
          shift = bitArray.getPartial(last);
        if (shift === 32) {
          return a1.concat(a2);
        } else {
          return bitArray._shiftRight(a2, shift, last | 0, a1.slice(0, a1.length - 1));
        }
      },
      /**
       * Find the length of an array of bits.
       * @param {bitArray} a The array.
       * @return {Number} The length of a, in bits.
       */
      bitLength(a) {
        const l = a.length;
        if (l === 0) {
          return 0;
        }
        const x = a[l - 1];
        return (l - 1) * 32 + bitArray.getPartial(x);
      },
      /**
       * Truncate an array.
       * @param {bitArray} a The array.
       * @param {Number} len The length to truncate to, in bits.
       * @return {bitArray} A new array, truncated to len bits.
       */
      clamp(a, len) {
        if (a.length * 32 < len) {
          return a;
        }
        a = a.slice(0, Math.ceil(len / 32));
        const l = a.length;
        len = len & 31;
        if (l > 0 && len) {
          a[l - 1] = bitArray.partial(len, a[l - 1] & 0x80000000 >> len - 1, 1);
        }
        return a;
      },
      /**
       * Make a partial word for a bit array.
       * @param {Number} len The number of bits in the word.
       * @param {Number} x The bits.
       * @param {Number} [_end=0] Pass 1 if x has already been shifted to the high side.
       * @return {Number} The partial word.
       */
      partial(len, x, _end) {
        if (len === 32) {
          return x;
        }
        return (_end ? x | 0 : x << 32 - len) + len * 0x10000000000;
      },
      /**
       * Get the number of bits used by a partial word.
       * @param {Number} x The partial word.
       * @return {Number} The number of bits used by the partial word.
       */
      getPartial(x) {
        return Math.round(x / 0x10000000000) || 32;
      },
      /** Shift an array right.
       * @param {bitArray} a The array to shift.
       * @param {Number} shift The number of bits to shift.
       * @param {Number} [carry=0] A byte to carry in
       * @param {bitArray} [out=[]] An array to prepend to the output.
       * @private
       */
      _shiftRight(a, shift, carry, out) {
        if (out === undefined) {
          out = [];
        }
        for (; shift >= 32; shift -= 32) {
          out.push(carry);
          carry = 0;
        }
        if (shift === 0) {
          return out.concat(a);
        }
        for (let i = 0; i < a.length; i++) {
          out.push(carry | a[i] >>> shift);
          carry = a[i] << 32 - shift;
        }
        const last2 = a.length ? a[a.length - 1] : 0;
        const shift2 = bitArray.getPartial(last2);
        out.push(bitArray.partial(shift + shift2 & 31, shift + shift2 > 32 ? carry : out.pop(), 1));
        return out;
      }
    };

    /** @fileOverview Bit array codec implementations.
     *
     * @author Emily Stark
     * @author Mike Hamburg
     * @author Dan Boneh
     */

    /**
     * Arrays of bytes
     * @namespace
     */
    const codec = {
      bytes: {
        /** Convert from a bitArray to an array of bytes. */
        fromBits(arr) {
          const bl = bitArray.bitLength(arr);
          const byteLength = bl / 8;
          const out = new Uint8Array(byteLength);
          let tmp;
          for (let i = 0; i < byteLength; i++) {
            if ((i & 3) === 0) {
              tmp = arr[i / 4];
            }
            out[i] = tmp >>> 24;
            tmp <<= 8;
          }
          return out;
        },
        /** Convert from an array of bytes to a bitArray. */
        toBits(bytes) {
          const out = [];
          let i;
          let tmp = 0;
          for (i = 0; i < bytes.length; i++) {
            tmp = tmp << 8 | bytes[i];
            if ((i & 3) === 3) {
              out.push(tmp);
              tmp = 0;
            }
          }
          if (i & 3) {
            out.push(bitArray.partial(8 * (i & 3), tmp));
          }
          return out;
        }
      }
    };
    const hash = {};

    /**
     * Context for a SHA-1 operation in progress.
     * @constructor
     */
    hash.sha1 = class {
      constructor(hash) {
        const sha1 = this;
        /**
         * The hash's block size, in bits.
         * @constant
         */
        sha1.blockSize = 512;
        /**
         * The SHA-1 initialization vector.
         * @private
         */
        sha1._init = [0x67452301, 0xEFCDAB89, 0x98BADCFE, 0x10325476, 0xC3D2E1F0];
        /**
         * The SHA-1 hash key.
         * @private
         */
        sha1._key = [0x5A827999, 0x6ED9EBA1, 0x8F1BBCDC, 0xCA62C1D6];
        if (hash) {
          sha1._h = hash._h.slice(0);
          sha1._buffer = hash._buffer.slice(0);
          sha1._length = hash._length;
        } else {
          sha1.reset();
        }
      }

      /**
       * Reset the hash state.
       * @return this
       */
      reset() {
        const sha1 = this;
        sha1._h = sha1._init.slice(0);
        sha1._buffer = [];
        sha1._length = 0;
        return sha1;
      }

      /**
       * Input several words to the hash.
       * @param {bitArray|String} data the data to hash.
       * @return this
       */
      update(data) {
        const sha1 = this;
        if (typeof data === "string") {
          data = codec.utf8String.toBits(data);
        }
        const b = sha1._buffer = bitArray.concat(sha1._buffer, data);
        const ol = sha1._length;
        const nl = sha1._length = ol + bitArray.bitLength(data);
        if (nl > 9007199254740991) {
          throw new Error("Cannot hash more than 2^53 - 1 bits");
        }
        const c = new Uint32Array(b);
        let j = 0;
        for (let i = sha1.blockSize + ol - (sha1.blockSize + ol & sha1.blockSize - 1); i <= nl; i += sha1.blockSize) {
          sha1._block(c.subarray(16 * j, 16 * (j + 1)));
          j += 1;
        }
        b.splice(0, 16 * j);
        return sha1;
      }

      /**
       * Complete hashing and output the hash value.
       * @return {bitArray} The hash value, an array of 5 big-endian words. TODO
       */
      finalize() {
        const sha1 = this;
        let b = sha1._buffer;
        const h = sha1._h;

        // Round out and push the buffer
        b = bitArray.concat(b, [bitArray.partial(1, 1)]);
        // Round out the buffer to a multiple of 16 words, less the 2 length words.
        for (let i = b.length + 2; i & 15; i++) {
          b.push(0);
        }

        // append the length
        b.push(Math.floor(sha1._length / 0x100000000));
        b.push(sha1._length | 0);
        while (b.length) {
          sha1._block(b.splice(0, 16));
        }
        sha1.reset();
        return h;
      }

      /**
       * The SHA-1 logical functions f(0), f(1), ..., f(79).
       * @private
       */
      _f(t, b, c, d) {
        if (t <= 19) {
          return b & c | ~b & d;
        } else if (t <= 39) {
          return b ^ c ^ d;
        } else if (t <= 59) {
          return b & c | b & d | c & d;
        } else if (t <= 79) {
          return b ^ c ^ d;
        }
      }

      /**
       * Circular left-shift operator.
       * @private
       */
      _S(n, x) {
        return x << n | x >>> 32 - n;
      }

      /**
       * Perform one cycle of SHA-1.
       * @param {Uint32Array|bitArray} words one block of words.
       * @private
       */
      _block(words) {
        const sha1 = this;
        const h = sha1._h;
        // When words is passed to _block, it has 16 elements. SHA1 _block
        // function extends words with new elements (at the end there are 80 elements). 
        // The problem is that if we use Uint32Array instead of Array, 
        // the length of Uint32Array cannot be changed. Thus, we replace words with a 
        // normal Array here.
        const w = Array(80); // do not use Uint32Array here as the instantiation is slower
        for (let j = 0; j < 16; j++) {
          w[j] = words[j];
        }
        let a = h[0];
        let b = h[1];
        let c = h[2];
        let d = h[3];
        let e = h[4];
        for (let t = 0; t <= 79; t++) {
          if (t >= 16) {
            w[t] = sha1._S(1, w[t - 3] ^ w[t - 8] ^ w[t - 14] ^ w[t - 16]);
          }
          const tmp = sha1._S(5, a) + sha1._f(t, b, c, d) + e + w[t] + sha1._key[Math.floor(t / 20)] | 0;
          e = d;
          d = c;
          c = sha1._S(30, b);
          b = a;
          a = tmp;
        }
        h[0] = h[0] + a | 0;
        h[1] = h[1] + b | 0;
        h[2] = h[2] + c | 0;
        h[3] = h[3] + d | 0;
        h[4] = h[4] + e | 0;
      }
    };

    /** @fileOverview Low-level AES implementation.
     *
     * This file contains a low-level implementation of AES, optimized for
     * size and for efficiency on several browsers.  It is based on
     * OpenSSL's aes_core.c, a public-domain implementation by Vincent
     * Rijmen, Antoon Bosselaers and Paulo Barreto.
     *
     * An older version of this implementation is available in the public
     * domain, but this one is (c) Emily Stark, Mike Hamburg, Dan Boneh,
     * Stanford University 2008-2010 and BSD-licensed for liability
     * reasons.
     *
     * @author Emily Stark
     * @author Mike Hamburg
     * @author Dan Boneh
     */

    const cipher = {};

    /**
     * Schedule out an AES key for both encryption and decryption.  This
     * is a low-level class.  Use a cipher mode to do bulk encryption.
     *
     * @constructor
     * @param {Array} key The key as an array of 4, 6 or 8 words.
     */
    cipher.aes = class {
      constructor(key) {
        /**
         * The expanded S-box and inverse S-box tables.  These will be computed
         * on the client so that we don't have to send them down the wire.
         *
         * There are two tables, _tables[0] is for encryption and
         * _tables[1] is for decryption.
         *
         * The first 4 sub-tables are the expanded S-box with MixColumns.  The
         * last (_tables[01][4]) is the S-box itself.
         *
         * @private
         */
        const aes = this;
        aes._tables = [[[], [], [], [], []], [[], [], [], [], []]];
        if (!aes._tables[0][0][0]) {
          aes._precompute();
        }
        const sbox = aes._tables[0][4];
        const decTable = aes._tables[1];
        const keyLen = key.length;
        let i,
          encKey,
          decKey,
          rcon = 1;
        if (keyLen !== 4 && keyLen !== 6 && keyLen !== 8) {
          throw new Error("invalid aes key size");
        }
        aes._key = [encKey = key.slice(0), decKey = []];

        // schedule encryption keys
        for (i = keyLen; i < 4 * keyLen + 28; i++) {
          let tmp = encKey[i - 1];

          // apply sbox
          if (i % keyLen === 0 || keyLen === 8 && i % keyLen === 4) {
            tmp = sbox[tmp >>> 24] << 24 ^ sbox[tmp >> 16 & 255] << 16 ^ sbox[tmp >> 8 & 255] << 8 ^ sbox[tmp & 255];

            // shift rows and add rcon
            if (i % keyLen === 0) {
              tmp = tmp << 8 ^ tmp >>> 24 ^ rcon << 24;
              rcon = rcon << 1 ^ (rcon >> 7) * 283;
            }
          }
          encKey[i] = encKey[i - keyLen] ^ tmp;
        }

        // schedule decryption keys
        for (let j = 0; i; j++, i--) {
          const tmp = encKey[j & 3 ? i : i - 4];
          if (i <= 4 || j < 4) {
            decKey[j] = tmp;
          } else {
            decKey[j] = decTable[0][sbox[tmp >>> 24]] ^ decTable[1][sbox[tmp >> 16 & 255]] ^ decTable[2][sbox[tmp >> 8 & 255]] ^ decTable[3][sbox[tmp & 255]];
          }
        }
      }
      // public
      /* Something like this might appear here eventually
      name: "AES",
      blockSize: 4,
      keySizes: [4,6,8],
      */

      /**
       * Encrypt an array of 4 big-endian words.
       * @param {Array} data The plaintext.
       * @return {Array} The ciphertext.
       */
      encrypt(data) {
        return this._crypt(data, 0);
      }

      /**
       * Decrypt an array of 4 big-endian words.
       * @param {Array} data The ciphertext.
       * @return {Array} The plaintext.
       */
      decrypt(data) {
        return this._crypt(data, 1);
      }

      /**
       * Expand the S-box tables.
       *
       * @private
       */
      _precompute() {
        const encTable = this._tables[0];
        const decTable = this._tables[1];
        const sbox = encTable[4];
        const sboxInv = decTable[4];
        const d = [];
        const th = [];
        let xInv, x2, x4, x8;

        // Compute double and third tables
        for (let i = 0; i < 256; i++) {
          th[(d[i] = i << 1 ^ (i >> 7) * 283) ^ i] = i;
        }
        for (let x = xInv = 0; !sbox[x]; x ^= x2 || 1, xInv = th[xInv] || 1) {
          // Compute sbox
          let s = xInv ^ xInv << 1 ^ xInv << 2 ^ xInv << 3 ^ xInv << 4;
          s = s >> 8 ^ s & 255 ^ 99;
          sbox[x] = s;
          sboxInv[s] = x;

          // Compute MixColumns
          x8 = d[x4 = d[x2 = d[x]]];
          let tDec = x8 * 0x1010101 ^ x4 * 0x10001 ^ x2 * 0x101 ^ x * 0x1010100;
          let tEnc = d[s] * 0x101 ^ s * 0x1010100;
          for (let i = 0; i < 4; i++) {
            encTable[i][x] = tEnc = tEnc << 24 ^ tEnc >>> 8;
            decTable[i][s] = tDec = tDec << 24 ^ tDec >>> 8;
          }
        }

        // Compactify.  Considerable speedup on Firefox.
        for (let i = 0; i < 5; i++) {
          encTable[i] = encTable[i].slice(0);
          decTable[i] = decTable[i].slice(0);
        }
      }

      /**
       * Encryption and decryption core.
       * @param {Array} input Four words to be encrypted or decrypted.
       * @param dir The direction, 0 for encrypt and 1 for decrypt.
       * @return {Array} The four encrypted or decrypted words.
       * @private
       */
      _crypt(input, dir) {
        if (input.length !== 4) {
          throw new Error("invalid aes block size");
        }
        const key = this._key[dir];
        const nInnerRounds = key.length / 4 - 2;
        const out = [0, 0, 0, 0];
        const table = this._tables[dir];

        // load up the tables
        const t0 = table[0];
        const t1 = table[1];
        const t2 = table[2];
        const t3 = table[3];
        const sbox = table[4];

        // state variables a,b,c,d are loaded with pre-whitened data
        let a = input[0] ^ key[0];
        let b = input[dir ? 3 : 1] ^ key[1];
        let c = input[2] ^ key[2];
        let d = input[dir ? 1 : 3] ^ key[3];
        let kIndex = 4;
        let a2, b2, c2;

        // Inner rounds.  Cribbed from OpenSSL.
        for (let i = 0; i < nInnerRounds; i++) {
          a2 = t0[a >>> 24] ^ t1[b >> 16 & 255] ^ t2[c >> 8 & 255] ^ t3[d & 255] ^ key[kIndex];
          b2 = t0[b >>> 24] ^ t1[c >> 16 & 255] ^ t2[d >> 8 & 255] ^ t3[a & 255] ^ key[kIndex + 1];
          c2 = t0[c >>> 24] ^ t1[d >> 16 & 255] ^ t2[a >> 8 & 255] ^ t3[b & 255] ^ key[kIndex + 2];
          d = t0[d >>> 24] ^ t1[a >> 16 & 255] ^ t2[b >> 8 & 255] ^ t3[c & 255] ^ key[kIndex + 3];
          kIndex += 4;
          a = a2;
          b = b2;
          c = c2;
        }

        // Last round.
        for (let i = 0; i < 4; i++) {
          out[dir ? 3 & -i : i] = sbox[a >>> 24] << 24 ^ sbox[b >> 16 & 255] << 16 ^ sbox[c >> 8 & 255] << 8 ^ sbox[d & 255] ^ key[kIndex++];
          a2 = a;
          a = b;
          b = c;
          c = d;
          d = a2;
        }
        return out;
      }
    };

    /**
     * Random values
     * @namespace
     */
    const random = {
      /** 
       * Generate random words with pure js, cryptographically not as strong & safe as native implementation.
       * @param {TypedArray} typedArray The array to fill.
       * @return {TypedArray} The random values.
       */
      getRandomValues(typedArray) {
        const words = new Uint32Array(typedArray.buffer);
        const r = m_w => {
          let m_z = 0x3ade68b1;
          const mask = 0xffffffff;
          return function () {
            m_z = 0x9069 * (m_z & 0xFFFF) + (m_z >> 0x10) & mask;
            m_w = 0x4650 * (m_w & 0xFFFF) + (m_w >> 0x10) & mask;
            const result = ((m_z << 0x10) + m_w & mask) / 0x100000000 + .5;
            return result * (Math.random() > .5 ? 1 : -1);
          };
        };
        for (let i = 0, rcache; i < typedArray.length; i += 4) {
          const _r = r((rcache || Math.random()) * 0x100000000);
          rcache = _r() * 0x3ade67b7;
          words[i / 4] = _r() * 0x100000000 | 0;
        }
        return typedArray;
      }
    };

    /** @fileOverview CTR mode implementation.
     *
     * Special thanks to Roy Nicholson for pointing out a bug in our
     * implementation.
     *
     * @author Emily Stark
     * @author Mike Hamburg
     * @author Dan Boneh
     */

    /** Brian Gladman's CTR Mode.
    * @constructor
    * @param {Object} _prf The aes instance to generate key.
    * @param {bitArray} _iv The iv for ctr mode, it must be 128 bits.
    */

    const mode = {};

    /**
     * Brian Gladman's CTR Mode.
     * @namespace
     */
    mode.ctrGladman = class {
      constructor(prf, iv) {
        this._prf = prf;
        this._initIv = iv;
        this._iv = iv;
      }
      reset() {
        this._iv = this._initIv;
      }

      /** Input some data to calculate.
       * @param {bitArray} data the data to process, it must be intergral multiple of 128 bits unless it's the last.
       */
      update(data) {
        return this.calculate(this._prf, data, this._iv);
      }
      incWord(word) {
        if ((word >> 24 & 0xff) === 0xff) {
          //overflow
          let b1 = word >> 16 & 0xff;
          let b2 = word >> 8 & 0xff;
          let b3 = word & 0xff;
          if (b1 === 0xff) {
            // overflow b1   
            b1 = 0;
            if (b2 === 0xff) {
              b2 = 0;
              if (b3 === 0xff) {
                b3 = 0;
              } else {
                ++b3;
              }
            } else {
              ++b2;
            }
          } else {
            ++b1;
          }
          word = 0;
          word += b1 << 16;
          word += b2 << 8;
          word += b3;
        } else {
          word += 0x01 << 24;
        }
        return word;
      }
      incCounter(counter) {
        if ((counter[0] = this.incWord(counter[0])) === 0) {
          // encr_data in fileenc.c from  Dr Brian Gladman's counts only with DWORD j < 8
          counter[1] = this.incWord(counter[1]);
        }
      }
      calculate(prf, data, iv) {
        let l;
        if (!(l = data.length)) {
          return [];
        }
        const bl = bitArray.bitLength(data);
        for (let i = 0; i < l; i += 4) {
          this.incCounter(iv);
          const e = prf.encrypt(iv);
          data[i] ^= e[0];
          data[i + 1] ^= e[1];
          data[i + 2] ^= e[2];
          data[i + 3] ^= e[3];
        }
        return bitArray.clamp(data, bl);
      }
    };
    const misc = {
      importKey(password) {
        return new misc.hmacSha1(codec.bytes.toBits(password));
      },
      pbkdf2(prf, salt, count, length) {
        count = count || 10000;
        if (length < 0 || count < 0) {
          throw new Error("invalid params to pbkdf2");
        }
        const byteLength = (length >> 5) + 1 << 2;
        let u, ui, i, j, k;
        const arrayBuffer = new ArrayBuffer(byteLength);
        const out = new DataView(arrayBuffer);
        let outLength = 0;
        const b = bitArray;
        salt = codec.bytes.toBits(salt);
        for (k = 1; outLength < (byteLength || 1); k++) {
          u = ui = prf.encrypt(b.concat(salt, [k]));
          for (i = 1; i < count; i++) {
            ui = prf.encrypt(ui);
            for (j = 0; j < ui.length; j++) {
              u[j] ^= ui[j];
            }
          }
          for (i = 0; outLength < (byteLength || 1) && i < u.length; i++) {
            out.setInt32(outLength, u[i]);
            outLength += 4;
          }
        }
        return arrayBuffer.slice(0, length / 8);
      }
    };

    /** @fileOverview HMAC implementation.
     *
     * @author Emily Stark
     * @author Mike Hamburg
     * @author Dan Boneh
     */

    /** HMAC with the specified hash function.
     * @constructor
     * @param {bitArray} key the key for HMAC.
     * @param {Object} [Hash=hash.sha1] The hash function to use.
     */
    misc.hmacSha1 = class {
      constructor(key) {
        const hmac = this;
        const Hash = hmac._hash = hash.sha1;
        const exKey = [[], []];
        hmac._baseHash = [new Hash(), new Hash()];
        const bs = hmac._baseHash[0].blockSize / 32;
        if (key.length > bs) {
          key = new Hash().update(key).finalize();
        }
        for (let i = 0; i < bs; i++) {
          exKey[0][i] = key[i] ^ 0x36363636;
          exKey[1][i] = key[i] ^ 0x5C5C5C5C;
        }
        hmac._baseHash[0].update(exKey[0]);
        hmac._baseHash[1].update(exKey[1]);
        hmac._resultHash = new Hash(hmac._baseHash[0]);
      }
      reset() {
        const hmac = this;
        hmac._resultHash = new hmac._hash(hmac._baseHash[0]);
        hmac._updated = false;
      }
      update(data) {
        const hmac = this;
        hmac._updated = true;
        hmac._resultHash.update(data);
      }
      digest() {
        const hmac = this;
        const w = hmac._resultHash.finalize();
        const result = new hmac._hash(hmac._baseHash[1]).update(w).finalize();
        hmac.reset();
        return result;
      }
      encrypt(data) {
        if (!this._updated) {
          this.update(data);
          return this.digest(data);
        } else {
          throw new Error("encrypt on already updated hmac called!");
        }
      }
    };

    /*
     Copyright (c) 2022 Gildas Lormeau. All rights reserved.

     Redistribution and use in source and binary forms, with or without
     modification, are permitted provided that the following conditions are met:

     1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright 
     notice, this list of conditions and the following disclaimer in 
     the documentation and/or other materials provided with the distribution.

     3. The names of the authors may not be used to endorse or promote products
     derived from this software without specific prior written permission.

     THIS SOFTWARE IS PROVIDED ''AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
     INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
     FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JCRAFT,
     INC. OR ANY CONTRIBUTORS TO THIS SOFTWARE BE LIABLE FOR ANY DIRECT, INDIRECT,
     INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
     LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
     OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
     LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
     NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
     EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     */

    const GET_RANDOM_VALUES_SUPPORTED = typeof crypto != UNDEFINED_TYPE && typeof crypto.getRandomValues == FUNCTION_TYPE;
    const ERR_INVALID_PASSWORD = "Invalid password";
    const ERR_INVALID_SIGNATURE = "Invalid signature";
    const ERR_ABORT_CHECK_PASSWORD = "zipjs-abort-check-password";
    function getRandomValues(array) {
      if (GET_RANDOM_VALUES_SUPPORTED) {
        return crypto.getRandomValues(array);
      } else {
        return random.getRandomValues(array);
      }
    }

    /*
     Copyright (c) 2022 Gildas Lormeau. All rights reserved.

     Redistribution and use in source and binary forms, with or without
     modification, are permitted provided that the following conditions are met:

     1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright 
     notice, this list of conditions and the following disclaimer in 
     the documentation and/or other materials provided with the distribution.

     3. The names of the authors may not be used to endorse or promote products
     derived from this software without specific prior written permission.

     THIS SOFTWARE IS PROVIDED ''AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
     INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
     FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JCRAFT,
     INC. OR ANY CONTRIBUTORS TO THIS SOFTWARE BE LIABLE FOR ANY DIRECT, INDIRECT,
     INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
     LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
     OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
     LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
     NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
     EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     */

    const BLOCK_LENGTH = 16;
    const RAW_FORMAT = "raw";
    const PBKDF2_ALGORITHM = {
      name: "PBKDF2"
    };
    const HASH_ALGORITHM = {
      name: "HMAC"
    };
    const HASH_FUNCTION = "SHA-1";
    const BASE_KEY_ALGORITHM = Object.assign({
      hash: HASH_ALGORITHM
    }, PBKDF2_ALGORITHM);
    const DERIVED_BITS_ALGORITHM = Object.assign({
      iterations: 1000,
      hash: {
        name: HASH_FUNCTION
      }
    }, PBKDF2_ALGORITHM);
    const DERIVED_BITS_USAGE = ["deriveBits"];
    const SALT_LENGTH = [8, 12, 16];
    const KEY_LENGTH = [16, 24, 32];
    const SIGNATURE_LENGTH = 10;
    const COUNTER_DEFAULT_VALUE = [0, 0, 0, 0];
    const CRYPTO_API_SUPPORTED = typeof crypto != UNDEFINED_TYPE;
    const subtle = CRYPTO_API_SUPPORTED && crypto.subtle;
    const SUBTLE_API_SUPPORTED = CRYPTO_API_SUPPORTED && typeof subtle != UNDEFINED_TYPE;
    const codecBytes = codec.bytes;
    const Aes = cipher.aes;
    const CtrGladman = mode.ctrGladman;
    const HmacSha1 = misc.hmacSha1;
    let IMPORT_KEY_SUPPORTED = CRYPTO_API_SUPPORTED && SUBTLE_API_SUPPORTED && typeof subtle.importKey == FUNCTION_TYPE;
    let DERIVE_BITS_SUPPORTED = CRYPTO_API_SUPPORTED && SUBTLE_API_SUPPORTED && typeof subtle.deriveBits == FUNCTION_TYPE;
    class AESDecryptionStream extends TransformStream {
      constructor({
        password,
        rawPassword,
        signed,
        encryptionStrength,
        checkPasswordOnly
      }) {
        super({
          start() {
            Object.assign(this, {
              ready: new Promise(resolve => this.resolveReady = resolve),
              password: encodePassword(password, rawPassword),
              signed,
              strength: encryptionStrength - 1,
              pending: new Uint8Array()
            });
          },
          async transform(chunk, controller) {
            const aesCrypto = this;
            const {
              password,
              strength,
              resolveReady,
              ready
            } = aesCrypto;
            if (password) {
              await createDecryptionKeys(aesCrypto, strength, password, subarray(chunk, 0, SALT_LENGTH[strength] + 2));
              chunk = subarray(chunk, SALT_LENGTH[strength] + 2);
              if (checkPasswordOnly) {
                controller.error(new Error(ERR_ABORT_CHECK_PASSWORD));
              } else {
                resolveReady();
              }
            } else {
              await ready;
            }
            const output = new Uint8Array(chunk.length - SIGNATURE_LENGTH - (chunk.length - SIGNATURE_LENGTH) % BLOCK_LENGTH);
            controller.enqueue(append(aesCrypto, chunk, output, 0, SIGNATURE_LENGTH, true));
          },
          async flush(controller) {
            const {
              signed,
              ctr,
              hmac,
              pending,
              ready
            } = this;
            if (hmac && ctr) {
              await ready;
              const chunkToDecrypt = subarray(pending, 0, pending.length - SIGNATURE_LENGTH);
              const originalSignature = subarray(pending, pending.length - SIGNATURE_LENGTH);
              let decryptedChunkArray = new Uint8Array();
              if (chunkToDecrypt.length) {
                const encryptedChunk = toBits(codecBytes, chunkToDecrypt);
                hmac.update(encryptedChunk);
                const decryptedChunk = ctr.update(encryptedChunk);
                decryptedChunkArray = fromBits(codecBytes, decryptedChunk);
              }
              if (signed) {
                const signature = subarray(fromBits(codecBytes, hmac.digest()), 0, SIGNATURE_LENGTH);
                for (let indexSignature = 0; indexSignature < SIGNATURE_LENGTH; indexSignature++) {
                  if (signature[indexSignature] != originalSignature[indexSignature]) {
                    throw new Error(ERR_INVALID_SIGNATURE);
                  }
                }
              }
              controller.enqueue(decryptedChunkArray);
            }
          }
        });
      }
    }
    class AESEncryptionStream extends TransformStream {
      constructor({
        password,
        rawPassword,
        encryptionStrength
      }) {
        // deno-lint-ignore prefer-const
        let stream;
        super({
          start() {
            Object.assign(this, {
              ready: new Promise(resolve => this.resolveReady = resolve),
              password: encodePassword(password, rawPassword),
              strength: encryptionStrength - 1,
              pending: new Uint8Array()
            });
          },
          async transform(chunk, controller) {
            const aesCrypto = this;
            const {
              password,
              strength,
              resolveReady,
              ready
            } = aesCrypto;
            let preamble = new Uint8Array();
            if (password) {
              preamble = await createEncryptionKeys(aesCrypto, strength, password);
              resolveReady();
            } else {
              await ready;
            }
            const output = new Uint8Array(preamble.length + chunk.length - chunk.length % BLOCK_LENGTH);
            output.set(preamble, 0);
            controller.enqueue(append(aesCrypto, chunk, output, preamble.length, 0));
          },
          async flush(controller) {
            const {
              ctr,
              hmac,
              pending,
              ready
            } = this;
            if (hmac && ctr) {
              await ready;
              let encryptedChunkArray = new Uint8Array();
              if (pending.length) {
                const encryptedChunk = ctr.update(toBits(codecBytes, pending));
                hmac.update(encryptedChunk);
                encryptedChunkArray = fromBits(codecBytes, encryptedChunk);
              }
              stream.signature = fromBits(codecBytes, hmac.digest()).slice(0, SIGNATURE_LENGTH);
              controller.enqueue(concat(encryptedChunkArray, stream.signature));
            }
          }
        });
        stream = this;
      }
    }
    function append(aesCrypto, input, output, paddingStart, paddingEnd, verifySignature) {
      const {
        ctr,
        hmac,
        pending
      } = aesCrypto;
      const inputLength = input.length - paddingEnd;
      if (pending.length) {
        input = concat(pending, input);
        output = expand(output, inputLength - inputLength % BLOCK_LENGTH);
      }
      let offset;
      for (offset = 0; offset <= inputLength - BLOCK_LENGTH; offset += BLOCK_LENGTH) {
        const inputChunk = toBits(codecBytes, subarray(input, offset, offset + BLOCK_LENGTH));
        if (verifySignature) {
          hmac.update(inputChunk);
        }
        const outputChunk = ctr.update(inputChunk);
        if (!verifySignature) {
          hmac.update(outputChunk);
        }
        output.set(fromBits(codecBytes, outputChunk), offset + paddingStart);
      }
      aesCrypto.pending = subarray(input, offset);
      return output;
    }
    async function createDecryptionKeys(decrypt, strength, password, preamble) {
      const passwordVerificationKey = await createKeys$1(decrypt, strength, password, subarray(preamble, 0, SALT_LENGTH[strength]));
      const passwordVerification = subarray(preamble, SALT_LENGTH[strength]);
      if (passwordVerificationKey[0] != passwordVerification[0] || passwordVerificationKey[1] != passwordVerification[1]) {
        throw new Error(ERR_INVALID_PASSWORD);
      }
    }
    async function createEncryptionKeys(encrypt, strength, password) {
      const salt = getRandomValues(new Uint8Array(SALT_LENGTH[strength]));
      const passwordVerification = await createKeys$1(encrypt, strength, password, salt);
      return concat(salt, passwordVerification);
    }
    async function createKeys$1(aesCrypto, strength, password, salt) {
      aesCrypto.password = null;
      const baseKey = await importKey(RAW_FORMAT, password, BASE_KEY_ALGORITHM, false, DERIVED_BITS_USAGE);
      const derivedBits = await deriveBits(Object.assign({
        salt
      }, DERIVED_BITS_ALGORITHM), baseKey, 8 * (KEY_LENGTH[strength] * 2 + 2));
      const compositeKey = new Uint8Array(derivedBits);
      const key = toBits(codecBytes, subarray(compositeKey, 0, KEY_LENGTH[strength]));
      const authentication = toBits(codecBytes, subarray(compositeKey, KEY_LENGTH[strength], KEY_LENGTH[strength] * 2));
      const passwordVerification = subarray(compositeKey, KEY_LENGTH[strength] * 2);
      Object.assign(aesCrypto, {
        keys: {
          key,
          authentication,
          passwordVerification
        },
        ctr: new CtrGladman(new Aes(key), Array.from(COUNTER_DEFAULT_VALUE)),
        hmac: new HmacSha1(authentication)
      });
      return passwordVerification;
    }
    async function importKey(format, password, algorithm, extractable, keyUsages) {
      if (IMPORT_KEY_SUPPORTED) {
        try {
          return await subtle.importKey(format, password, algorithm, extractable, keyUsages);
          // eslint-disable-next-line no-unused-vars
        } catch (_) {
          IMPORT_KEY_SUPPORTED = false;
          return misc.importKey(password);
        }
      } else {
        return misc.importKey(password);
      }
    }
    async function deriveBits(algorithm, baseKey, length) {
      if (DERIVE_BITS_SUPPORTED) {
        try {
          return await subtle.deriveBits(algorithm, baseKey, length);
          // eslint-disable-next-line no-unused-vars
        } catch (_) {
          DERIVE_BITS_SUPPORTED = false;
          return misc.pbkdf2(baseKey, algorithm.salt, DERIVED_BITS_ALGORITHM.iterations, length);
        }
      } else {
        return misc.pbkdf2(baseKey, algorithm.salt, DERIVED_BITS_ALGORITHM.iterations, length);
      }
    }
    function encodePassword(password, rawPassword) {
      if (rawPassword === UNDEFINED_VALUE) {
        return encodeText(password);
      } else {
        return rawPassword;
      }
    }
    function concat(leftArray, rightArray) {
      let array = leftArray;
      if (leftArray.length + rightArray.length) {
        array = new Uint8Array(leftArray.length + rightArray.length);
        array.set(leftArray, 0);
        array.set(rightArray, leftArray.length);
      }
      return array;
    }
    function expand(inputArray, length) {
      if (length && length > inputArray.length) {
        const array = inputArray;
        inputArray = new Uint8Array(length);
        inputArray.set(array, 0);
      }
      return inputArray;
    }
    function subarray(array, begin, end) {
      return array.subarray(begin, end);
    }
    function fromBits(codecBytes, chunk) {
      return codecBytes.fromBits(chunk);
    }
    function toBits(codecBytes, chunk) {
      return codecBytes.toBits(chunk);
    }

    /*
     Copyright (c) 2022 Gildas Lormeau. All rights reserved.

     Redistribution and use in source and binary forms, with or without
     modification, are permitted provided that the following conditions are met:

     1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright 
     notice, this list of conditions and the following disclaimer in 
     the documentation and/or other materials provided with the distribution.

     3. The names of the authors may not be used to endorse or promote products
     derived from this software without specific prior written permission.

     THIS SOFTWARE IS PROVIDED ''AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
     INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
     FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JCRAFT,
     INC. OR ANY CONTRIBUTORS TO THIS SOFTWARE BE LIABLE FOR ANY DIRECT, INDIRECT,
     INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
     LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
     OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
     LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
     NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
     EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     */

    const HEADER_LENGTH = 12;
    class ZipCryptoDecryptionStream extends TransformStream {
      constructor({
        password,
        passwordVerification,
        checkPasswordOnly
      }) {
        super({
          start() {
            Object.assign(this, {
              password,
              passwordVerification
            });
            createKeys(this, password);
          },
          transform(chunk, controller) {
            const zipCrypto = this;
            if (zipCrypto.password) {
              const decryptedHeader = decrypt(zipCrypto, chunk.subarray(0, HEADER_LENGTH));
              zipCrypto.password = null;
              if (decryptedHeader[HEADER_LENGTH - 1] != zipCrypto.passwordVerification) {
                throw new Error(ERR_INVALID_PASSWORD);
              }
              chunk = chunk.subarray(HEADER_LENGTH);
            }
            if (checkPasswordOnly) {
              controller.error(new Error(ERR_ABORT_CHECK_PASSWORD));
            } else {
              controller.enqueue(decrypt(zipCrypto, chunk));
            }
          }
        });
      }
    }
    class ZipCryptoEncryptionStream extends TransformStream {
      constructor({
        password,
        passwordVerification
      }) {
        super({
          start() {
            Object.assign(this, {
              password,
              passwordVerification
            });
            createKeys(this, password);
          },
          transform(chunk, controller) {
            const zipCrypto = this;
            let output;
            let offset;
            if (zipCrypto.password) {
              zipCrypto.password = null;
              const header = getRandomValues(new Uint8Array(HEADER_LENGTH));
              header[HEADER_LENGTH - 1] = zipCrypto.passwordVerification;
              output = new Uint8Array(chunk.length + header.length);
              output.set(encrypt(zipCrypto, header), 0);
              offset = HEADER_LENGTH;
            } else {
              output = new Uint8Array(chunk.length);
              offset = 0;
            }
            output.set(encrypt(zipCrypto, chunk), offset);
            controller.enqueue(output);
          }
        });
      }
    }
    function decrypt(target, input) {
      const output = new Uint8Array(input.length);
      for (let index = 0; index < input.length; index++) {
        output[index] = getByte(target) ^ input[index];
        updateKeys(target, output[index]);
      }
      return output;
    }
    function encrypt(target, input) {
      const output = new Uint8Array(input.length);
      for (let index = 0; index < input.length; index++) {
        output[index] = getByte(target) ^ input[index];
        updateKeys(target, input[index]);
      }
      return output;
    }
    function createKeys(target, password) {
      const keys = [0x12345678, 0x23456789, 0x34567890];
      Object.assign(target, {
        keys,
        crcKey0: new Crc32(keys[0]),
        crcKey2: new Crc32(keys[2])
      });
      for (let index = 0; index < password.length; index++) {
        updateKeys(target, password.charCodeAt(index));
      }
    }
    function updateKeys(target, byte) {
      let [key0, key1, key2] = target.keys;
      target.crcKey0.append([byte]);
      key0 = ~target.crcKey0.get();
      key1 = getInt32(Math.imul(getInt32(key1 + getInt8(key0)), 134775813) + 1);
      target.crcKey2.append([key1 >>> 24]);
      key2 = ~target.crcKey2.get();
      target.keys = [key0, key1, key2];
    }
    function getByte(target) {
      const temp = target.keys[2] | 2;
      return getInt8(Math.imul(temp, temp ^ 1) >>> 8);
    }
    function getInt8(number) {
      return number & 0xFF;
    }
    function getInt32(number) {
      return number & 0xFFFFFFFF;
    }

    /*
     Copyright (c) 2022 Gildas Lormeau. All rights reserved.

     Redistribution and use in source and binary forms, with or without
     modification, are permitted provided that the following conditions are met:

     1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright 
     notice, this list of conditions and the following disclaimer in 
     the documentation and/or other materials provided with the distribution.

     3. The names of the authors may not be used to endorse or promote products
     derived from this software without specific prior written permission.

     THIS SOFTWARE IS PROVIDED ''AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
     INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
     FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JCRAFT,
     INC. OR ANY CONTRIBUTORS TO THIS SOFTWARE BE LIABLE FOR ANY DIRECT, INDIRECT,
     INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
     LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
     OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
     LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
     NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
     EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     */

    const COMPRESSION_FORMAT = "deflate-raw";
    class DeflateStream extends TransformStream {
      constructor(options, {
        chunkSize,
        CompressionStream,
        CompressionStreamNative
      }) {
        super({});
        const {
          compressed,
          encrypted,
          useCompressionStream,
          zipCrypto,
          signed,
          level
        } = options;
        const stream = this;
        let crc32Stream, encryptionStream;
        let readable = filterEmptyChunks(super.readable);
        if ((!encrypted || zipCrypto) && signed) {
          crc32Stream = new Crc32Stream();
          readable = pipeThrough(readable, crc32Stream);
        }
        if (compressed) {
          readable = pipeThroughCommpressionStream(readable, useCompressionStream, {
            level,
            chunkSize
          }, CompressionStreamNative, CompressionStream);
        }
        if (encrypted) {
          if (zipCrypto) {
            readable = pipeThrough(readable, new ZipCryptoEncryptionStream(options));
          } else {
            encryptionStream = new AESEncryptionStream(options);
            readable = pipeThrough(readable, encryptionStream);
          }
        }
        setReadable(stream, readable, () => {
          let signature;
          if (encrypted && !zipCrypto) {
            signature = encryptionStream.signature;
          }
          if ((!encrypted || zipCrypto) && signed) {
            signature = new DataView(crc32Stream.value.buffer).getUint32(0);
          }
          stream.signature = signature;
        });
      }
    }
    class InflateStream extends TransformStream {
      constructor(options, {
        chunkSize,
        DecompressionStream,
        DecompressionStreamNative
      }) {
        super({});
        const {
          zipCrypto,
          encrypted,
          signed,
          signature,
          compressed,
          useCompressionStream
        } = options;
        let crc32Stream, decryptionStream;
        let readable = filterEmptyChunks(super.readable);
        if (encrypted) {
          if (zipCrypto) {
            readable = pipeThrough(readable, new ZipCryptoDecryptionStream(options));
          } else {
            decryptionStream = new AESDecryptionStream(options);
            readable = pipeThrough(readable, decryptionStream);
          }
        }
        if (compressed) {
          readable = pipeThroughCommpressionStream(readable, useCompressionStream, {
            chunkSize
          }, DecompressionStreamNative, DecompressionStream);
        }
        if ((!encrypted || zipCrypto) && signed) {
          crc32Stream = new Crc32Stream();
          readable = pipeThrough(readable, crc32Stream);
        }
        setReadable(this, readable, () => {
          if ((!encrypted || zipCrypto) && signed) {
            const dataViewSignature = new DataView(crc32Stream.value.buffer);
            if (signature != dataViewSignature.getUint32(0, false)) {
              throw new Error(ERR_INVALID_SIGNATURE);
            }
          }
        });
      }
    }
    function filterEmptyChunks(readable) {
      return pipeThrough(readable, new TransformStream({
        transform(chunk, controller) {
          if (chunk && chunk.length) {
            controller.enqueue(chunk);
          }
        }
      }));
    }
    function setReadable(stream, readable, flush) {
      readable = pipeThrough(readable, new TransformStream({
        flush
      }));
      Object.defineProperty(stream, "readable", {
        get() {
          return readable;
        }
      });
    }
    function pipeThroughCommpressionStream(readable, useCompressionStream, options, CodecStreamNative, CodecStream) {
      try {
        const CompressionStream = useCompressionStream && CodecStreamNative ? CodecStreamNative : CodecStream;
        readable = pipeThrough(readable, new CompressionStream(COMPRESSION_FORMAT, options));
        // eslint-disable-next-line no-unused-vars
      } catch (_) {
        if (useCompressionStream) {
          try {
            readable = pipeThrough(readable, new CodecStream(COMPRESSION_FORMAT, options));
            // eslint-disable-next-line no-unused-vars
          } catch (_) {
            return readable;
          }
        } else {
          return readable;
        }
      }
      return readable;
    }
    function pipeThrough(readable, transformStream) {
      return readable.pipeThrough(transformStream);
    }

    /*
     Copyright (c) 2022 Gildas Lormeau. All rights reserved.

     Redistribution and use in source and binary forms, with or without
     modification, are permitted provided that the following conditions are met:

     1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright 
     notice, this list of conditions and the following disclaimer in 
     the documentation and/or other materials provided with the distribution.

     3. The names of the authors may not be used to endorse or promote products
     derived from this software without specific prior written permission.

     THIS SOFTWARE IS PROVIDED ''AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
     INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
     FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JCRAFT,
     INC. OR ANY CONTRIBUTORS TO THIS SOFTWARE BE LIABLE FOR ANY DIRECT, INDIRECT,
     INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
     LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
     OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
     LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
     NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
     EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     */

    const MESSAGE_EVENT_TYPE = "message";
    const MESSAGE_START = "start";
    const MESSAGE_PULL = "pull";
    const MESSAGE_DATA = "data";
    const MESSAGE_ACK_DATA = "ack";
    const MESSAGE_CLOSE = "close";
    const CODEC_DEFLATE = "deflate";
    const CODEC_INFLATE = "inflate";
    class CodecStream extends TransformStream {
      constructor(options, config) {
        super({});
        const codec = this;
        const {
          codecType
        } = options;
        let Stream;
        if (codecType.startsWith(CODEC_DEFLATE)) {
          Stream = DeflateStream;
        } else if (codecType.startsWith(CODEC_INFLATE)) {
          Stream = InflateStream;
        }
        codec.outputSize = 0;
        let inputSize = 0;
        const stream = new Stream(options, config);
        const readable = super.readable;
        const inputSizeStream = new TransformStream({
          transform(chunk, controller) {
            if (chunk && chunk.length) {
              inputSize += chunk.length;
              controller.enqueue(chunk);
            }
          },
          flush() {
            Object.assign(codec, {
              inputSize
            });
          }
        });
        const outputSizeStream = new TransformStream({
          transform(chunk, controller) {
            if (chunk && chunk.length) {
              controller.enqueue(chunk);
              codec.outputSize += chunk.length;
            }
          },
          flush() {
            const {
              signature
            } = stream;
            Object.assign(codec, {
              signature,
              inputSize
            });
          }
        });
        Object.defineProperty(codec, "readable", {
          get() {
            return readable.pipeThrough(inputSizeStream).pipeThrough(stream).pipeThrough(outputSizeStream);
          }
        });
      }
    }
    class ChunkStream extends TransformStream {
      constructor(chunkSize) {
        let pendingChunk;
        super({
          transform,
          flush(controller) {
            if (pendingChunk && pendingChunk.length) {
              controller.enqueue(pendingChunk);
            }
          }
        });
        function transform(chunk, controller) {
          if (pendingChunk) {
            const newChunk = new Uint8Array(pendingChunk.length + chunk.length);
            newChunk.set(pendingChunk);
            newChunk.set(chunk, pendingChunk.length);
            chunk = newChunk;
            pendingChunk = null;
          }
          if (chunk.length > chunkSize) {
            controller.enqueue(chunk.slice(0, chunkSize));
            transform(chunk.slice(chunkSize), controller);
          } else {
            pendingChunk = chunk;
          }
        }
      }
    }

    /*
     Copyright (c) 2022 Gildas Lormeau. All rights reserved.

     Redistribution and use in source and binary forms, with or without
     modification, are permitted provided that the following conditions are met:

     1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright 
     notice, this list of conditions and the following disclaimer in 
     the documentation and/or other materials provided with the distribution.

     3. The names of the authors may not be used to endorse or promote products
     derived from this software without specific prior written permission.

     THIS SOFTWARE IS PROVIDED ''AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
     INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
     FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JCRAFT,
     INC. OR ANY CONTRIBUTORS TO THIS SOFTWARE BE LIABLE FOR ANY DIRECT, INDIRECT,
     INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
     LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
     OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
     LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
     NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
     EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     */

    let WEB_WORKERS_SUPPORTED = typeof Worker != UNDEFINED_TYPE;
    class CodecWorker {
      constructor(workerData, {
        readable,
        writable
      }, {
        options,
        config,
        streamOptions,
        useWebWorkers,
        transferStreams,
        scripts
      }, onTaskFinished) {
        const {
          signal
        } = streamOptions;
        Object.assign(workerData, {
          busy: true,
          readable: readable.pipeThrough(new ChunkStream(config.chunkSize)).pipeThrough(new ProgressWatcherStream(streamOptions), {
            signal
          }),
          writable,
          options: Object.assign({}, options),
          scripts,
          transferStreams,
          terminate() {
            return new Promise(resolve => {
              const {
                worker,
                busy
              } = workerData;
              if (worker) {
                if (busy) {
                  workerData.resolveTerminated = resolve;
                } else {
                  worker.terminate();
                  resolve();
                }
                workerData.interface = null;
              } else {
                resolve();
              }
            });
          },
          onTaskFinished() {
            const {
              resolveTerminated
            } = workerData;
            if (resolveTerminated) {
              workerData.resolveTerminated = null;
              workerData.terminated = true;
              workerData.worker.terminate();
              resolveTerminated();
            }
            workerData.busy = false;
            onTaskFinished(workerData);
          }
        });
        return (useWebWorkers && WEB_WORKERS_SUPPORTED ? createWebWorkerInterface : createWorkerInterface)(workerData, config);
      }
    }
    class ProgressWatcherStream extends TransformStream {
      constructor({
        onstart,
        onprogress,
        size,
        onend
      }) {
        let chunkOffset = 0;
        super({
          async start() {
            if (onstart) {
              await callHandler(onstart, size);
            }
          },
          async transform(chunk, controller) {
            chunkOffset += chunk.length;
            if (onprogress) {
              await callHandler(onprogress, chunkOffset, size);
            }
            controller.enqueue(chunk);
          },
          async flush() {
            if (onend) {
              await callHandler(onend, chunkOffset);
            }
          }
        });
      }
    }
    async function callHandler(handler, ...parameters) {
      try {
        await handler(...parameters);
        // eslint-disable-next-line no-unused-vars
      } catch (_) {
        // ignored
      }
    }
    function createWorkerInterface(workerData, config) {
      return {
        run: () => runWorker$1(workerData, config)
      };
    }
    function createWebWorkerInterface(workerData, config) {
      const {
        baseURL,
        chunkSize
      } = config;
      if (!workerData.interface) {
        let worker;
        try {
          worker = getWebWorker(workerData.scripts[0], baseURL, workerData);
          // eslint-disable-next-line no-unused-vars
        } catch (_) {
          WEB_WORKERS_SUPPORTED = false;
          return createWorkerInterface(workerData, config);
        }
        Object.assign(workerData, {
          worker,
          interface: {
            run: () => runWebWorker(workerData, {
              chunkSize
            })
          }
        });
      }
      return workerData.interface;
    }
    async function runWorker$1({
      options,
      readable,
      writable,
      onTaskFinished
    }, config) {
      let codecStream;
      try {
        codecStream = new CodecStream(options, config);
        await readable.pipeThrough(codecStream).pipeTo(writable, {
          preventClose: true,
          preventAbort: true
        });
        const {
          signature,
          inputSize,
          outputSize
        } = codecStream;
        return {
          signature,
          inputSize,
          outputSize
        };
      } catch (error) {
        if (codecStream) {
          error.outputSize = codecStream.outputSize;
        }
        throw error;
      } finally {
        onTaskFinished();
      }
    }
    async function runWebWorker(workerData, config) {
      let resolveResult, rejectResult;
      const result = new Promise((resolve, reject) => {
        resolveResult = resolve;
        rejectResult = reject;
      });
      Object.assign(workerData, {
        reader: null,
        writer: null,
        resolveResult,
        rejectResult,
        result
      });
      const {
        readable,
        options,
        scripts
      } = workerData;
      const {
        writable,
        closed
      } = watchClosedStream(workerData.writable);
      const streamsTransferred = sendMessage({
        type: MESSAGE_START,
        scripts: scripts.slice(1),
        options,
        config,
        readable,
        writable
      }, workerData);
      if (!streamsTransferred) {
        Object.assign(workerData, {
          reader: readable.getReader(),
          writer: writable.getWriter()
        });
      }
      const resultValue = await result;
      if (!streamsTransferred) {
        await writable.getWriter().close();
      }
      await closed;
      return resultValue;
    }
    function watchClosedStream(writableSource) {
      let resolveStreamClosed;
      const closed = new Promise(resolve => resolveStreamClosed = resolve);
      const writable = new WritableStream({
        async write(chunk) {
          const writer = writableSource.getWriter();
          await writer.ready;
          await writer.write(chunk);
          writer.releaseLock();
        },
        close() {
          resolveStreamClosed();
        },
        abort(reason) {
          const writer = writableSource.getWriter();
          return writer.abort(reason);
        }
      });
      return {
        writable,
        closed
      };
    }
    let classicWorkersSupported = true;
    let transferStreamsSupported = true;
    function getWebWorker(url, baseURL, workerData) {
      const workerOptions = {
        type: "module"
      };
      let scriptUrl, worker;
      if (typeof url == FUNCTION_TYPE) {
        url = url();
      }
      try {
        scriptUrl = new URL(url, baseURL);
        // eslint-disable-next-line no-unused-vars
      } catch (_) {
        scriptUrl = url;
      }
      if (classicWorkersSupported) {
        try {
          worker = new Worker(scriptUrl);
          // eslint-disable-next-line no-unused-vars
        } catch (_) {
          classicWorkersSupported = false;
          worker = new Worker(scriptUrl, workerOptions);
        }
      } else {
        worker = new Worker(scriptUrl, workerOptions);
      }
      worker.addEventListener(MESSAGE_EVENT_TYPE, event => onMessage(event, workerData));
      return worker;
    }
    function sendMessage(message, {
      worker,
      writer,
      onTaskFinished,
      transferStreams
    }) {
      try {
        const {
          value,
          readable,
          writable
        } = message;
        const transferables = [];
        if (value) {
          if (value.byteLength < value.buffer.byteLength) {
            message.value = value.buffer.slice(0, value.byteLength);
          } else {
            message.value = value.buffer;
          }
          transferables.push(message.value);
        }
        if (transferStreams && transferStreamsSupported) {
          if (readable) {
            transferables.push(readable);
          }
          if (writable) {
            transferables.push(writable);
          }
        } else {
          message.readable = message.writable = null;
        }
        if (transferables.length) {
          try {
            worker.postMessage(message, transferables);
            return true;
            // eslint-disable-next-line no-unused-vars
          } catch (_) {
            transferStreamsSupported = false;
            message.readable = message.writable = null;
            worker.postMessage(message);
          }
        } else {
          worker.postMessage(message);
        }
      } catch (error) {
        if (writer) {
          writer.releaseLock();
        }
        onTaskFinished();
        throw error;
      }
    }
    async function onMessage({
      data
    }, workerData) {
      const {
        type,
        value,
        messageId,
        result,
        error
      } = data;
      const {
        reader,
        writer,
        resolveResult,
        rejectResult,
        onTaskFinished
      } = workerData;
      try {
        if (error) {
          const {
            message,
            stack,
            code,
            name,
            outputSize
          } = error;
          const responseError = new Error(message);
          Object.assign(responseError, {
            stack,
            code,
            name,
            outputSize
          });
          close(responseError);
        } else {
          if (type == MESSAGE_PULL) {
            const {
              value,
              done
            } = await reader.read();
            sendMessage({
              type: MESSAGE_DATA,
              value,
              done,
              messageId
            }, workerData);
          }
          if (type == MESSAGE_DATA) {
            await writer.ready;
            await writer.write(new Uint8Array(value));
            sendMessage({
              type: MESSAGE_ACK_DATA,
              messageId
            }, workerData);
          }
          if (type == MESSAGE_CLOSE) {
            close(null, result);
          }
        }
      } catch (error) {
        sendMessage({
          type: MESSAGE_CLOSE,
          messageId
        }, workerData);
        close(error);
      }
      function close(error, result) {
        if (error) {
          rejectResult(error);
        } else {
          resolveResult(result);
        }
        if (writer) {
          writer.releaseLock();
        }
        onTaskFinished();
      }
    }

    /*
     Copyright (c) 2022 Gildas Lormeau. All rights reserved.

     Redistribution and use in source and binary forms, with or without
     modification, are permitted provided that the following conditions are met:

     1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright 
     notice, this list of conditions and the following disclaimer in 
     the documentation and/or other materials provided with the distribution.

     3. The names of the authors may not be used to endorse or promote products
     derived from this software without specific prior written permission.

     THIS SOFTWARE IS PROVIDED ''AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
     INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
     FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JCRAFT,
     INC. OR ANY CONTRIBUTORS TO THIS SOFTWARE BE LIABLE FOR ANY DIRECT, INDIRECT,
     INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
     LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
     OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
     LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
     NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
     EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     */

    let pool = [];
    const pendingRequests = [];
    let indexWorker = 0;
    async function runWorker(stream, workerOptions) {
      const {
        options,
        config
      } = workerOptions;
      const {
        transferStreams,
        useWebWorkers,
        useCompressionStream,
        codecType,
        compressed,
        signed,
        encrypted
      } = options;
      const {
        workerScripts,
        maxWorkers
      } = config;
      workerOptions.transferStreams = transferStreams || transferStreams === UNDEFINED_VALUE;
      const streamCopy = !compressed && !signed && !encrypted && !workerOptions.transferStreams;
      workerOptions.useWebWorkers = !streamCopy && (useWebWorkers || useWebWorkers === UNDEFINED_VALUE && config.useWebWorkers);
      workerOptions.scripts = workerOptions.useWebWorkers && workerScripts ? workerScripts[codecType] : [];
      options.useCompressionStream = useCompressionStream || useCompressionStream === UNDEFINED_VALUE && config.useCompressionStream;
      return (await getWorker()).run();

      // deno-lint-ignore require-await
      async function getWorker() {
        const workerData = pool.find(workerData => !workerData.busy);
        if (workerData) {
          clearTerminateTimeout(workerData);
          return new CodecWorker(workerData, stream, workerOptions, onTaskFinished);
        } else if (pool.length < maxWorkers) {
          const workerData = {
            indexWorker
          };
          indexWorker++;
          pool.push(workerData);
          return new CodecWorker(workerData, stream, workerOptions, onTaskFinished);
        } else {
          return new Promise(resolve => pendingRequests.push({
            resolve,
            stream,
            workerOptions
          }));
        }
      }
      function onTaskFinished(workerData) {
        if (pendingRequests.length) {
          const [{
            resolve,
            stream,
            workerOptions
          }] = pendingRequests.splice(0, 1);
          resolve(new CodecWorker(workerData, stream, workerOptions, onTaskFinished));
        } else if (workerData.worker) {
          clearTerminateTimeout(workerData);
          terminateWorker(workerData, workerOptions);
        } else {
          pool = pool.filter(data => data != workerData);
        }
      }
    }
    function terminateWorker(workerData, workerOptions) {
      const {
        config
      } = workerOptions;
      const {
        terminateWorkerTimeout
      } = config;
      if (Number.isFinite(terminateWorkerTimeout) && terminateWorkerTimeout >= 0) {
        if (workerData.terminated) {
          workerData.terminated = false;
        } else {
          workerData.terminateTimeout = setTimeout(async () => {
            pool = pool.filter(data => data != workerData);
            try {
              await workerData.terminate();
              // eslint-disable-next-line no-unused-vars
            } catch (_) {
              // ignored
            }
          }, terminateWorkerTimeout);
        }
      }
    }
    function clearTerminateTimeout(workerData) {
      const {
        terminateTimeout
      } = workerData;
      if (terminateTimeout) {
        clearTimeout(terminateTimeout);
        workerData.terminateTimeout = null;
      }
    }

    function e(e, t = {}) {
      const n = 'const{Array:e,Object:t,Number:n,Math:r,Error:s,Uint8Array:i,Uint16Array:o,Uint32Array:c,Int32Array:f,Map:a,DataView:u,Promise:l,TextEncoder:w,crypto:h,postMessage:d,TransformStream:p,ReadableStream:y,WritableStream:m,CompressionStream:b,DecompressionStream:g}=self,k=void 0,v="undefined",S="function";class z{constructor(e){return class extends p{constructor(t,n){const r=new e(n);super({transform(e,t){t.enqueue(r.append(e))},flush(e){const t=r.flush();t&&e.enqueue(t)}})}}}}const C=[];for(let e=0;256>e;e++){let t=e;for(let e=0;8>e;e++)1&t?t=t>>>1^3988292384:t>>>=1;C[e]=t}class x{constructor(e){this.t=e||-1}append(e){let t=0|this.t;for(let n=0,r=0|e.length;r>n;n++)t=t>>>8^C[255&(t^e[n])];this.t=t}get(){return~this.t}}class A extends p{constructor(){let e;const t=new x;super({transform(e,n){t.append(e),n.enqueue(e)},flush(){const n=new i(4);new u(n.buffer).setUint32(0,t.get()),e.value=n}}),e=this}}const _={concat(e,t){if(0===e.length||0===t.length)return e.concat(t);const n=e[e.length-1],r=_.i(n);return 32===r?e.concat(t):_.o(t,r,0|n,e.slice(0,e.length-1))},u(e){const t=e.length;if(0===t)return 0;const n=e[t-1];return 32*(t-1)+_.i(n)},l(e,t){if(32*e.length<t)return e;const n=(e=e.slice(0,r.ceil(t/32))).length;return t&=31,n>0&&t&&(e[n-1]=_.h(t,e[n-1]&2147483648>>t-1,1)),e},h:(e,t,n)=>32===e?t:(n?0|t:t<<32-e)+1099511627776*e,i:e=>r.round(e/1099511627776)||32,o(e,t,n,r){for(void 0===r&&(r=[]);t>=32;t-=32)r.push(n),n=0;if(0===t)return r.concat(e);for(let s=0;s<e.length;s++)r.push(n|e[s]>>>t),n=e[s]<<32-t;const s=e.length?e[e.length-1]:0,i=_.i(s);return r.push(_.h(t+i&31,t+i>32?n:r.pop(),1)),r}},I={bytes:{p(e){const t=_.u(e)/8,n=new i(t);let r;for(let s=0;t>s;s++)3&s||(r=e[s/4]),n[s]=r>>>24,r<<=8;return n},m(e){const t=[];let n,r=0;for(n=0;n<e.length;n++)r=r<<8|e[n],3&~n||(t.push(r),r=0);return 3&n&&t.push(_.h(8*(3&n),r)),t}}},P=class{constructor(e){const t=this;t.blockSize=512,t.k=[1732584193,4023233417,2562383102,271733878,3285377520],t.v=[1518500249,1859775393,2400959708,3395469782],e?(t.S=e.S.slice(0),t.C=e.C.slice(0),t.A=e.A):t.reset()}reset(){const e=this;return e.S=e.k.slice(0),e.C=[],e.A=0,e}update(e){const t=this;"string"==typeof e&&(e=I._.m(e));const n=t.C=_.concat(t.C,e),r=t.A,i=t.A=r+_.u(e);if(i>9007199254740991)throw new s("Cannot hash more than 2^53 - 1 bits");const o=new c(n);let f=0;for(let e=t.blockSize+r-(t.blockSize+r&t.blockSize-1);i>=e;e+=t.blockSize)t.I(o.subarray(16*f,16*(f+1))),f+=1;return n.splice(0,16*f),t}P(){const e=this;let t=e.C;const n=e.S;t=_.concat(t,[_.h(1,1)]);for(let e=t.length+2;15&e;e++)t.push(0);for(t.push(r.floor(e.A/4294967296)),t.push(0|e.A);t.length;)e.I(t.splice(0,16));return e.reset(),n}D(e,t,n,r){return e>19?e>39?e>59?e>79?void 0:t^n^r:t&n|t&r|n&r:t^n^r:t&n|~t&r}V(e,t){return t<<e|t>>>32-e}I(t){const n=this,s=n.S,i=e(80);for(let e=0;16>e;e++)i[e]=t[e];let o=s[0],c=s[1],f=s[2],a=s[3],u=s[4];for(let e=0;79>=e;e++){16>e||(i[e]=n.V(1,i[e-3]^i[e-8]^i[e-14]^i[e-16]));const t=n.V(5,o)+n.D(e,c,f,a)+u+i[e]+n.v[r.floor(e/20)]|0;u=a,a=f,f=n.V(30,c),c=o,o=t}s[0]=s[0]+o|0,s[1]=s[1]+c|0,s[2]=s[2]+f|0,s[3]=s[3]+a|0,s[4]=s[4]+u|0}},D={getRandomValues(e){const t=new c(e.buffer),n=e=>{let t=987654321;const n=4294967295;return()=>(t=36969*(65535&t)+(t>>16)&n,(((t<<16)+(e=18e3*(65535&e)+(e>>16)&n)&n)/4294967296+.5)*(r.random()>.5?1:-1))};for(let s,i=0;i<e.length;i+=4){const e=n(4294967296*(s||r.random()));s=987654071*e(),t[i/4]=4294967296*e()|0}return e}},V={importKey:e=>new V.R(I.bytes.m(e)),B(e,t,n,r){if(n=n||1e4,0>r||0>n)throw new s("invalid params to pbkdf2");const i=1+(r>>5)<<2;let o,c,f,a,l;const w=new ArrayBuffer(i),h=new u(w);let d=0;const p=_;for(t=I.bytes.m(t),l=1;(i||1)>d;l++){for(o=c=e.encrypt(p.concat(t,[l])),f=1;n>f;f++)for(c=e.encrypt(c),a=0;a<c.length;a++)o[a]^=c[a];for(f=0;(i||1)>d&&f<o.length;f++)h.setInt32(d,o[f]),d+=4}return w.slice(0,r/8)},R:class{constructor(e){const t=this,n=t.M=P,r=[[],[]];t.U=[new n,new n];const s=t.U[0].blockSize/32;e.length>s&&(e=(new n).update(e).P());for(let t=0;s>t;t++)r[0][t]=909522486^e[t],r[1][t]=1549556828^e[t];t.U[0].update(r[0]),t.U[1].update(r[1]),t.K=new n(t.U[0])}reset(){const e=this;e.K=new e.M(e.U[0]),e.N=!1}update(e){this.N=!0,this.K.update(e)}digest(){const e=this,t=e.K.P(),n=new e.M(e.U[1]).update(t).P();return e.reset(),n}encrypt(e){if(this.N)throw new s("encrypt on already updated hmac called!");return this.update(e),this.digest(e)}}},R=typeof h!=v&&typeof h.getRandomValues==S,B="Invalid password",E="Invalid signature",M="zipjs-abort-check-password";function U(e){return R?h.getRandomValues(e):D.getRandomValues(e)}const K=16,N={name:"PBKDF2"},O=t.assign({hash:{name:"HMAC"}},N),T=t.assign({iterations:1e3,hash:{name:"SHA-1"}},N),W=["deriveBits"],j=[8,12,16],H=[16,24,32],L=10,F=[0,0,0,0],q=typeof h!=v,G=q&&h.subtle,J=q&&typeof G!=v,Q=I.bytes,X=class{constructor(e){const t=this;t.O=[[[],[],[],[],[]],[[],[],[],[],[]]],t.O[0][0][0]||t.T();const n=t.O[0][4],r=t.O[1],i=e.length;let o,c,f,a=1;if(4!==i&&6!==i&&8!==i)throw new s("invalid aes key size");for(t.v=[c=e.slice(0),f=[]],o=i;4*i+28>o;o++){let e=c[o-1];(o%i===0||8===i&&o%i===4)&&(e=n[e>>>24]<<24^n[e>>16&255]<<16^n[e>>8&255]<<8^n[255&e],o%i===0&&(e=e<<8^e>>>24^a<<24,a=a<<1^283*(a>>7))),c[o]=c[o-i]^e}for(let e=0;o;e++,o--){const t=c[3&e?o:o-4];f[e]=4>=o||4>e?t:r[0][n[t>>>24]]^r[1][n[t>>16&255]]^r[2][n[t>>8&255]]^r[3][n[255&t]]}}encrypt(e){return this.W(e,0)}decrypt(e){return this.W(e,1)}T(){const e=this.O[0],t=this.O[1],n=e[4],r=t[4],s=[],i=[];let o,c,f,a;for(let e=0;256>e;e++)i[(s[e]=e<<1^283*(e>>7))^e]=e;for(let u=o=0;!n[u];u^=c||1,o=i[o]||1){let i=o^o<<1^o<<2^o<<3^o<<4;i=i>>8^255&i^99,n[u]=i,r[i]=u,a=s[f=s[c=s[u]]];let l=16843009*a^65537*f^257*c^16843008*u,w=257*s[i]^16843008*i;for(let n=0;4>n;n++)e[n][u]=w=w<<24^w>>>8,t[n][i]=l=l<<24^l>>>8}for(let n=0;5>n;n++)e[n]=e[n].slice(0),t[n]=t[n].slice(0)}W(e,t){if(4!==e.length)throw new s("invalid aes block size");const n=this.v[t],r=n.length/4-2,i=[0,0,0,0],o=this.O[t],c=o[0],f=o[1],a=o[2],u=o[3],l=o[4];let w,h,d,p=e[0]^n[0],y=e[t?3:1]^n[1],m=e[2]^n[2],b=e[t?1:3]^n[3],g=4;for(let e=0;r>e;e++)w=c[p>>>24]^f[y>>16&255]^a[m>>8&255]^u[255&b]^n[g],h=c[y>>>24]^f[m>>16&255]^a[b>>8&255]^u[255&p]^n[g+1],d=c[m>>>24]^f[b>>16&255]^a[p>>8&255]^u[255&y]^n[g+2],b=c[b>>>24]^f[p>>16&255]^a[y>>8&255]^u[255&m]^n[g+3],g+=4,p=w,y=h,m=d;for(let e=0;4>e;e++)i[t?3&-e:e]=l[p>>>24]<<24^l[y>>16&255]<<16^l[m>>8&255]<<8^l[255&b]^n[g++],w=p,p=y,y=m,m=b,b=w;return i}},Y=class{constructor(e,t){this.j=e,this.H=t,this.L=t}reset(){this.L=this.H}update(e){return this.F(this.j,e,this.L)}q(e){if(255&~(e>>24))e+=1<<24;else{let t=e>>16&255,n=e>>8&255,r=255&e;255===t?(t=0,255===n?(n=0,255===r?r=0:++r):++n):++t,e=0,e+=t<<16,e+=n<<8,e+=r}return e}G(e){0===(e[0]=this.q(e[0]))&&(e[1]=this.q(e[1]))}F(e,t,n){let r;if(!(r=t.length))return[];const s=_.u(t);for(let s=0;r>s;s+=4){this.G(n);const r=e.encrypt(n);t[s]^=r[0],t[s+1]^=r[1],t[s+2]^=r[2],t[s+3]^=r[3]}return _.l(t,s)}},Z=V.R;let $=q&&J&&typeof G.importKey==S,ee=q&&J&&typeof G.deriveBits==S;class te extends p{constructor({password:e,rawPassword:n,signed:r,encryptionStrength:o,checkPasswordOnly:c}){super({start(){t.assign(this,{ready:new l(e=>this.J=e),password:ie(e,n),signed:r,X:o-1,pending:new i})},async transform(e,t){const n=this,{password:r,X:o,J:f,ready:a}=n;r?(await(async(e,t,n,r)=>{const i=await se(e,t,n,ce(r,0,j[t])),o=ce(r,j[t]);if(i[0]!=o[0]||i[1]!=o[1])throw new s(B)})(n,o,r,ce(e,0,j[o]+2)),e=ce(e,j[o]+2),c?t.error(new s(M)):f()):await a;const u=new i(e.length-L-(e.length-L)%K);t.enqueue(re(n,e,u,0,L,!0))},async flush(e){const{signed:t,Y:n,Z:r,pending:o,ready:c}=this;if(r&&n){await c;const f=ce(o,0,o.length-L),a=ce(o,o.length-L);let u=new i;if(f.length){const e=ae(Q,f);r.update(e);const t=n.update(e);u=fe(Q,t)}if(t){const e=ce(fe(Q,r.digest()),0,L);for(let t=0;L>t;t++)if(e[t]!=a[t])throw new s(E)}e.enqueue(u)}}})}}class ne extends p{constructor({password:e,rawPassword:n,encryptionStrength:r}){let s;super({start(){t.assign(this,{ready:new l(e=>this.J=e),password:ie(e,n),X:r-1,pending:new i})},async transform(e,t){const n=this,{password:r,X:s,J:o,ready:c}=n;let f=new i;r?(f=await(async(e,t,n)=>{const r=U(new i(j[t]));return oe(r,await se(e,t,n,r))})(n,s,r),o()):await c;const a=new i(f.length+e.length-e.length%K);a.set(f,0),t.enqueue(re(n,e,a,f.length,0))},async flush(e){const{Y:t,Z:n,pending:r,ready:o}=this;if(n&&t){await o;let c=new i;if(r.length){const e=t.update(ae(Q,r));n.update(e),c=fe(Q,e)}s.signature=fe(Q,n.digest()).slice(0,L),e.enqueue(oe(c,s.signature))}}}),s=this}}function re(e,t,n,r,s,o){const{Y:c,Z:f,pending:a}=e,u=t.length-s;let l;for(a.length&&(t=oe(a,t),n=((e,t)=>{if(t&&t>e.length){const n=e;(e=new i(t)).set(n,0)}return e})(n,u-u%K)),l=0;u-K>=l;l+=K){const e=ae(Q,ce(t,l,l+K));o&&f.update(e);const s=c.update(e);o||f.update(s),n.set(fe(Q,s),l+r)}return e.pending=ce(t,l),n}async function se(n,r,s,o){n.password=null;const c=await(async(e,t,n,r,s)=>{if(!$)return V.importKey(t);try{return await G.importKey("raw",t,n,!1,s)}catch(e){return $=!1,V.importKey(t)}})(0,s,O,0,W),f=await(async(e,t,n)=>{if(!ee)return V.B(t,e.salt,T.iterations,n);try{return await G.deriveBits(e,t,n)}catch(r){return ee=!1,V.B(t,e.salt,T.iterations,n)}})(t.assign({salt:o},T),c,8*(2*H[r]+2)),a=new i(f),u=ae(Q,ce(a,0,H[r])),l=ae(Q,ce(a,H[r],2*H[r])),w=ce(a,2*H[r]);return t.assign(n,{keys:{key:u,$:l,passwordVerification:w},Y:new Y(new X(u),e.from(F)),Z:new Z(l)}),w}function ie(e,t){return t===k?(e=>{if(typeof w==v){const t=new i((e=unescape(encodeURIComponent(e))).length);for(let n=0;n<t.length;n++)t[n]=e.charCodeAt(n);return t}return(new w).encode(e)})(e):t}function oe(e,t){let n=e;return e.length+t.length&&(n=new i(e.length+t.length),n.set(e,0),n.set(t,e.length)),n}function ce(e,t,n){return e.subarray(t,n)}function fe(e,t){return e.p(t)}function ae(e,t){return e.m(t)}class ue extends p{constructor({password:e,passwordVerification:n,checkPasswordOnly:r}){super({start(){t.assign(this,{password:e,passwordVerification:n}),de(this,e)},transform(e,t){const n=this;if(n.password){const t=we(n,e.subarray(0,12));if(n.password=null,t[11]!=n.passwordVerification)throw new s(B);e=e.subarray(12)}r?t.error(new s(M)):t.enqueue(we(n,e))}})}}class le extends p{constructor({password:e,passwordVerification:n}){super({start(){t.assign(this,{password:e,passwordVerification:n}),de(this,e)},transform(e,t){const n=this;let r,s;if(n.password){n.password=null;const t=U(new i(12));t[11]=n.passwordVerification,r=new i(e.length+t.length),r.set(he(n,t),0),s=12}else r=new i(e.length),s=0;r.set(he(n,e),s),t.enqueue(r)}})}}function we(e,t){const n=new i(t.length);for(let r=0;r<t.length;r++)n[r]=ye(e)^t[r],pe(e,n[r]);return n}function he(e,t){const n=new i(t.length);for(let r=0;r<t.length;r++)n[r]=ye(e)^t[r],pe(e,t[r]);return n}function de(e,n){const r=[305419896,591751049,878082192];t.assign(e,{keys:r,ee:new x(r[0]),te:new x(r[2])});for(let t=0;t<n.length;t++)pe(e,n.charCodeAt(t))}function pe(e,t){let[n,s,i]=e.keys;e.ee.append([t]),n=~e.ee.get(),s=be(r.imul(be(s+me(n)),134775813)+1),e.te.append([s>>>24]),i=~e.te.get(),e.keys=[n,s,i]}function ye(e){const t=2|e.keys[2];return me(r.imul(t,1^t)>>>8)}function me(e){return 255&e}function be(e){return 4294967295&e}const ge="deflate-raw";class ke extends p{constructor(e,{chunkSize:t,CompressionStream:n,CompressionStreamNative:r}){super({});const{compressed:s,encrypted:i,useCompressionStream:o,zipCrypto:c,signed:f,level:a}=e,l=this;let w,h,d=Se(super.readable);i&&!c||!f||(w=new A,d=xe(d,w)),s&&(d=Ce(d,o,{level:a,chunkSize:t},r,n)),i&&(c?d=xe(d,new le(e)):(h=new ne(e),d=xe(d,h))),ze(l,d,()=>{let e;i&&!c&&(e=h.signature),i&&!c||!f||(e=new u(w.value.buffer).getUint32(0)),l.signature=e})}}class ve extends p{constructor(e,{chunkSize:t,DecompressionStream:n,DecompressionStreamNative:r}){super({});const{zipCrypto:i,encrypted:o,signed:c,signature:f,compressed:a,useCompressionStream:l}=e;let w,h,d=Se(super.readable);o&&(i?d=xe(d,new ue(e)):(h=new te(e),d=xe(d,h))),a&&(d=Ce(d,l,{chunkSize:t},r,n)),o&&!i||!c||(w=new A,d=xe(d,w)),ze(this,d,()=>{if((!o||i)&&c){const e=new u(w.value.buffer);if(f!=e.getUint32(0,!1))throw new s(E)}})}}function Se(e){return xe(e,new p({transform(e,t){e&&e.length&&t.enqueue(e)}}))}function ze(e,n,r){n=xe(n,new p({flush:r})),t.defineProperty(e,"readable",{get:()=>n})}function Ce(e,t,n,r,s){try{e=xe(e,new(t&&r?r:s)(ge,n))}catch(r){if(!t)return e;try{e=xe(e,new s(ge,n))}catch(t){return e}}return e}function xe(e,t){return e.pipeThrough(t)}const Ae="data",_e="close";class Ie extends p{constructor(e,n){super({});const r=this,{codecType:s}=e;let i;s.startsWith("deflate")?i=ke:s.startsWith("inflate")&&(i=ve),r.outputSize=0;let o=0;const c=new i(e,n),f=super.readable,a=new p({transform(e,t){e&&e.length&&(o+=e.length,t.enqueue(e))},flush(){t.assign(r,{inputSize:o})}}),u=new p({transform(e,t){e&&e.length&&(t.enqueue(e),r.outputSize+=e.length)},flush(){const{signature:e}=c;t.assign(r,{signature:e,inputSize:o})}});t.defineProperty(r,"readable",{get:()=>f.pipeThrough(a).pipeThrough(c).pipeThrough(u)})}}class Pe extends p{constructor(e){let t;super({transform:function n(r,s){if(t){const e=new i(t.length+r.length);e.set(t),e.set(r,t.length),r=e,t=null}r.length>e?(s.enqueue(r.slice(0,e)),n(r.slice(e),s)):t=r},flush(e){t&&t.length&&e.enqueue(t)}})}}const De=new a,Ve=new a;let Re,Be=0,Ee=!0;async function Me(e){try{const{options:t,scripts:r,config:s}=e;if(r&&r.length)try{Ee?importScripts.apply(k,r):await Ue(r)}catch(e){Ee=!1,await Ue(r)}self.initCodec&&self.initCodec(),s.CompressionStreamNative=self.CompressionStream,s.DecompressionStreamNative=self.DecompressionStream,self.Deflate&&(s.CompressionStream=new z(self.Deflate)),self.Inflate&&(s.DecompressionStream=new z(self.Inflate));const i={highWaterMark:1},o=e.readable||new y({async pull(e){const t=new l(e=>De.set(Be,e));Ke({type:"pull",messageId:Be}),Be=(Be+1)%n.MAX_SAFE_INTEGER;const{value:r,done:s}=await t;e.enqueue(r),s&&e.close()}},i),c=e.writable||new m({async write(e){let t;const r=new l(e=>t=e);Ve.set(Be,t),Ke({type:Ae,value:e,messageId:Be}),Be=(Be+1)%n.MAX_SAFE_INTEGER,await r}},i),f=new Ie(t,s);Re=new AbortController;const{signal:a}=Re;await o.pipeThrough(f).pipeThrough(new Pe(s.chunkSize)).pipeTo(c,{signal:a,preventClose:!0,preventAbort:!0}),await c.getWriter().close();const{signature:u,inputSize:w,outputSize:h}=f;Ke({type:_e,result:{signature:u,inputSize:w,outputSize:h}})}catch(e){e.outputSize=0,Ne(e)}}async function Ue(e){for(const t of e)await import(t)}function Ke(e){let{value:t}=e;if(t)if(t.length)try{t=new i(t),e.value=t.buffer,d(e,[e.value])}catch(t){d(e)}else d(e);else d(e)}function Ne(e=new s("Unknown error")){const{message:t,stack:n,code:r,name:i,outputSize:o}=e;d({error:{message:t,stack:n,code:r,name:i,outputSize:o}})}addEventListener("message",({data:e})=>{const{type:t,messageId:n,value:r,done:s}=e;try{if("start"==t&&Me(e),t==Ae){const e=De.get(n);De.delete(n),e({value:new i(r),done:s})}if("ack"==t){const e=Ve.get(n);Ve.delete(n),e()}t==_e&&Re.abort()}catch(e){Ne(e)}});const Oe=-2;function Te(t){return We(t.map(([t,n])=>new e(t).fill(n,0,t)))}function We(t){return t.reduce((t,n)=>t.concat(e.isArray(n)?We(n):n),[])}const je=[0,1,2,3].concat(...Te([[2,4],[2,5],[4,6],[4,7],[8,8],[8,9],[16,10],[16,11],[32,12],[32,13],[64,14],[64,15],[2,0],[1,16],[1,17],[2,18],[2,19],[4,20],[4,21],[8,22],[8,23],[16,24],[16,25],[32,26],[32,27],[64,28],[64,29]]));function He(){const e=this;function t(e,t){let n=0;do{n|=1&e,e>>>=1,n<<=1}while(--t>0);return n>>>1}e.ne=n=>{const s=e.re,i=e.ie.se,o=e.ie.oe;let c,f,a,u=-1;for(n.ce=0,n.fe=573,c=0;o>c;c++)0!==s[2*c]?(n.ae[++n.ce]=u=c,n.ue[c]=0):s[2*c+1]=0;for(;2>n.ce;)a=n.ae[++n.ce]=2>u?++u:0,s[2*a]=1,n.ue[a]=0,n.le--,i&&(n.we-=i[2*a+1]);for(e.he=u,c=r.floor(n.ce/2);c>=1;c--)n.de(s,c);a=o;do{c=n.ae[1],n.ae[1]=n.ae[n.ce--],n.de(s,1),f=n.ae[1],n.ae[--n.fe]=c,n.ae[--n.fe]=f,s[2*a]=s[2*c]+s[2*f],n.ue[a]=r.max(n.ue[c],n.ue[f])+1,s[2*c+1]=s[2*f+1]=a,n.ae[1]=a++,n.de(s,1)}while(n.ce>=2);n.ae[--n.fe]=n.ae[1],(t=>{const n=e.re,r=e.ie.se,s=e.ie.pe,i=e.ie.ye,o=e.ie.me;let c,f,a,u,l,w,h=0;for(u=0;15>=u;u++)t.be[u]=0;for(n[2*t.ae[t.fe]+1]=0,c=t.fe+1;573>c;c++)f=t.ae[c],u=n[2*n[2*f+1]+1]+1,u>o&&(u=o,h++),n[2*f+1]=u,f>e.he||(t.be[u]++,l=0,i>f||(l=s[f-i]),w=n[2*f],t.le+=w*(u+l),r&&(t.we+=w*(r[2*f+1]+l)));if(0!==h){do{for(u=o-1;0===t.be[u];)u--;t.be[u]--,t.be[u+1]+=2,t.be[o]--,h-=2}while(h>0);for(u=o;0!==u;u--)for(f=t.be[u];0!==f;)a=t.ae[--c],a>e.he||(n[2*a+1]!=u&&(t.le+=(u-n[2*a+1])*n[2*a],n[2*a+1]=u),f--)}})(n),((e,n,r)=>{const s=[];let i,o,c,f=0;for(i=1;15>=i;i++)s[i]=f=f+r[i-1]<<1;for(o=0;n>=o;o++)c=e[2*o+1],0!==c&&(e[2*o]=t(s[c]++,c))})(s,e.he,n.be)}}function Le(e,t,n,r,s){const i=this;i.se=e,i.pe=t,i.ye=n,i.oe=r,i.me=s}He.ge=[0,1,2,3,4,5,6,7].concat(...Te([[2,8],[2,9],[2,10],[2,11],[4,12],[4,13],[4,14],[4,15],[8,16],[8,17],[8,18],[8,19],[16,20],[16,21],[16,22],[16,23],[32,24],[32,25],[32,26],[31,27],[1,28]])),He.ke=[0,1,2,3,4,5,6,7,8,10,12,14,16,20,24,28,32,40,48,56,64,80,96,112,128,160,192,224,0],He.ve=[0,1,2,3,4,6,8,12,16,24,32,48,64,96,128,192,256,384,512,768,1024,1536,2048,3072,4096,6144,8192,12288,16384,24576],He.Se=e=>256>e?je[e]:je[256+(e>>>7)],He.ze=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0],He.Ce=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13],He.xe=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,7],He.Ae=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15];const Fe=Te([[144,8],[112,9],[24,7],[8,8]]);Le._e=We([12,140,76,204,44,172,108,236,28,156,92,220,60,188,124,252,2,130,66,194,34,162,98,226,18,146,82,210,50,178,114,242,10,138,74,202,42,170,106,234,26,154,90,218,58,186,122,250,6,134,70,198,38,166,102,230,22,150,86,214,54,182,118,246,14,142,78,206,46,174,110,238,30,158,94,222,62,190,126,254,1,129,65,193,33,161,97,225,17,145,81,209,49,177,113,241,9,137,73,201,41,169,105,233,25,153,89,217,57,185,121,249,5,133,69,197,37,165,101,229,21,149,85,213,53,181,117,245,13,141,77,205,45,173,109,237,29,157,93,221,61,189,125,253,19,275,147,403,83,339,211,467,51,307,179,435,115,371,243,499,11,267,139,395,75,331,203,459,43,299,171,427,107,363,235,491,27,283,155,411,91,347,219,475,59,315,187,443,123,379,251,507,7,263,135,391,71,327,199,455,39,295,167,423,103,359,231,487,23,279,151,407,87,343,215,471,55,311,183,439,119,375,247,503,15,271,143,399,79,335,207,463,47,303,175,431,111,367,239,495,31,287,159,415,95,351,223,479,63,319,191,447,127,383,255,511,0,64,32,96,16,80,48,112,8,72,40,104,24,88,56,120,4,68,36,100,20,84,52,116,3,131,67,195,35,163,99,227].map((e,t)=>[e,Fe[t]]));const qe=Te([[30,5]]);function Ge(e,t,n,r,s){const i=this;i.Ie=e,i.Pe=t,i.De=n,i.Ve=r,i.Re=s}Le.Be=We([0,16,8,24,4,20,12,28,2,18,10,26,6,22,14,30,1,17,9,25,5,21,13,29,3,19,11,27,7,23].map((e,t)=>[e,qe[t]])),Le.Ee=new Le(Le._e,He.ze,257,286,15),Le.Me=new Le(Le.Be,He.Ce,0,30,15),Le.Ue=new Le(null,He.xe,0,19,7);const Je=[new Ge(0,0,0,0,0),new Ge(4,4,8,4,1),new Ge(4,5,16,8,1),new Ge(4,6,32,32,1),new Ge(4,4,16,16,2),new Ge(8,16,32,32,2),new Ge(8,16,128,128,2),new Ge(8,32,128,256,2),new Ge(32,128,258,1024,2),new Ge(32,258,258,4096,2)],Qe=["need dictionary","stream end","","","stream error","data error","","buffer error","",""],Xe=113,Ye=666,Ze=262;function $e(e,t,n,r){const s=e[2*t],i=e[2*n];return i>s||s==i&&r[t]<=r[n]}function et(){const e=this;let t,n,s,c,f,a,u,l,w,h,d,p,y,m,b,g,k,v,S,z,C,x,A,_,I,P,D,V,R,B,E,M,U;const K=new He,N=new He,O=new He;let T,W,j,H,L,F;function q(){let t;for(t=0;286>t;t++)E[2*t]=0;for(t=0;30>t;t++)M[2*t]=0;for(t=0;19>t;t++)U[2*t]=0;E[512]=1,e.le=e.we=0,W=j=0}function G(e,t){let n,r=-1,s=e[1],i=0,o=7,c=4;0===s&&(o=138,c=3),e[2*(t+1)+1]=65535;for(let f=0;t>=f;f++)n=s,s=e[2*(f+1)+1],++i<o&&n==s||(c>i?U[2*n]+=i:0!==n?(n!=r&&U[2*n]++,U[32]++):i>10?U[36]++:U[34]++,i=0,r=n,0===s?(o=138,c=3):n==s?(o=6,c=3):(o=7,c=4))}function J(t){e.Ke[e.pending++]=t}function Q(e){J(255&e),J(e>>>8&255)}function X(e,t){let n;const r=t;F>16-r?(n=e,L|=n<<F&65535,Q(L),L=n>>>16-F,F+=r-16):(L|=e<<F&65535,F+=r)}function Y(e,t){const n=2*e;X(65535&t[n],65535&t[n+1])}function Z(e,t){let n,r,s=-1,i=e[1],o=0,c=7,f=4;for(0===i&&(c=138,f=3),n=0;t>=n;n++)if(r=i,i=e[2*(n+1)+1],++o>=c||r!=i){if(f>o)do{Y(r,U)}while(0!==--o);else 0!==r?(r!=s&&(Y(r,U),o--),Y(16,U),X(o-3,2)):o>10?(Y(18,U),X(o-11,7)):(Y(17,U),X(o-3,3));o=0,s=r,0===i?(c=138,f=3):r==i?(c=6,f=3):(c=7,f=4)}}function $(){16==F?(Q(L),L=0,F=0):8>F||(J(255&L),L>>>=8,F-=8)}function ee(t,n){let s,i,o;if(e.Ne[W]=t,e.Oe[W]=255&n,W++,0===t?E[2*n]++:(j++,t--,E[2*(He.ge[n]+256+1)]++,M[2*He.Se(t)]++),!(8191&W)&&D>2){for(s=8*W,i=C-k,o=0;30>o;o++)s+=M[2*o]*(5+He.Ce[o]);if(s>>>=3,j<r.floor(W/2)&&s<r.floor(i/2))return!0}return W==T-1}function te(t,n){let r,s,i,o,c=0;if(0!==W)do{r=e.Ne[c],s=e.Oe[c],c++,0===r?Y(s,t):(i=He.ge[s],Y(i+256+1,t),o=He.ze[i],0!==o&&(s-=He.ke[i],X(s,o)),r--,i=He.Se(r),Y(i,n),o=He.Ce[i],0!==o&&(r-=He.ve[i],X(r,o)))}while(W>c);Y(256,t),H=t[513]}function ne(){F>8?Q(L):F>0&&J(255&L),L=0,F=0}function re(t,n,r){X(0+(r?1:0),3),((t,n)=>{ne(),H=8,Q(n),Q(~n),e.Ke.set(l.subarray(t,t+n),e.pending),e.pending+=n})(t,n)}function se(n){((t,n,r)=>{let s,i,o=0;D>0?(K.ne(e),N.ne(e),o=(()=>{let t;for(G(E,K.he),G(M,N.he),O.ne(e),t=18;t>=3&&0===U[2*He.Ae[t]+1];t--);return e.le+=14+3*(t+1),t})(),s=e.le+3+7>>>3,i=e.we+3+7>>>3,i>s||(s=i)):s=i=n+5,n+4>s||-1==t?i==s?(X(2+(r?1:0),3),te(Le._e,Le.Be)):(X(4+(r?1:0),3),((e,t,n)=>{let r;for(X(e-257,5),X(t-1,5),X(n-4,4),r=0;n>r;r++)X(U[2*He.Ae[r]+1],3);Z(E,e-1),Z(M,t-1)})(K.he+1,N.he+1,o+1),te(E,M)):re(t,n,r),q(),r&&ne()})(0>k?-1:k,C-k,n),k=C,t.Te()}function ie(){let e,n,r,s;do{if(s=w-A-C,0===s&&0===C&&0===A)s=f;else if(-1==s)s--;else if(C>=f+f-Ze){l.set(l.subarray(f,f+f),0),x-=f,C-=f,k-=f,e=y,r=e;do{n=65535&d[--r],d[r]=f>n?0:n-f}while(0!==--e);e=f,r=e;do{n=65535&h[--r],h[r]=f>n?0:n-f}while(0!==--e);s+=f}if(0===t.We)return;e=t.je(l,C+A,s),A+=e,3>A||(p=255&l[C],p=(p<<g^255&l[C+1])&b)}while(Ze>A&&0!==t.We)}function oe(e){let t,n,r=I,s=C,i=_;const o=C>f-Ze?C-(f-Ze):0;let c=B;const a=u,w=C+258;let d=l[s+i-1],p=l[s+i];R>_||(r>>=2),c>A&&(c=A);do{if(t=e,l[t+i]==p&&l[t+i-1]==d&&l[t]==l[s]&&l[++t]==l[s+1]){s+=2,t++;do{}while(l[++s]==l[++t]&&l[++s]==l[++t]&&l[++s]==l[++t]&&l[++s]==l[++t]&&l[++s]==l[++t]&&l[++s]==l[++t]&&l[++s]==l[++t]&&l[++s]==l[++t]&&w>s);if(n=258-(w-s),s=w-258,n>i){if(x=e,i=n,n>=c)break;d=l[s+i-1],p=l[s+i]}}}while((e=65535&h[e&a])>o&&0!==--r);return i>A?A:i}e.ue=[],e.be=[],e.ae=[],E=[],M=[],U=[],e.de=(t,n)=>{const r=e.ae,s=r[n];let i=n<<1;for(;i<=e.ce&&(i<e.ce&&$e(t,r[i+1],r[i],e.ue)&&i++,!$e(t,s,r[i],e.ue));)r[n]=r[i],n=i,i<<=1;r[n]=s},e.He=(t,S,x,W,j,G)=>(W||(W=8),j||(j=8),G||(G=0),t.Le=null,-1==S&&(S=6),1>j||j>9||8!=W||9>x||x>15||0>S||S>9||0>G||G>2?Oe:(t.Fe=e,a=x,f=1<<a,u=f-1,m=j+7,y=1<<m,b=y-1,g=r.floor((m+3-1)/3),l=new i(2*f),h=[],d=[],T=1<<j+6,e.Ke=new i(4*T),s=4*T,e.Ne=new o(T),e.Oe=new i(T),D=S,V=G,(t=>(t.qe=t.Ge=0,t.Le=null,e.pending=0,e.Je=0,n=Xe,c=0,K.re=E,K.ie=Le.Ee,N.re=M,N.ie=Le.Me,O.re=U,O.ie=Le.Ue,L=0,F=0,H=8,q(),(()=>{w=2*f,d[y-1]=0;for(let e=0;y-1>e;e++)d[e]=0;P=Je[D].Pe,R=Je[D].Ie,B=Je[D].De,I=Je[D].Ve,C=0,k=0,A=0,v=_=2,z=0,p=0})(),0))(t))),e.Qe=()=>42!=n&&n!=Xe&&n!=Ye?Oe:(e.Oe=null,e.Ne=null,e.Ke=null,d=null,h=null,l=null,e.Fe=null,n==Xe?-3:0),e.Xe=(e,t,n)=>{let r=0;return-1==t&&(t=6),0>t||t>9||0>n||n>2?Oe:(Je[D].Re!=Je[t].Re&&0!==e.qe&&(r=e.Ye(1)),D!=t&&(D=t,P=Je[D].Pe,R=Je[D].Ie,B=Je[D].De,I=Je[D].Ve),V=n,r)},e.Ze=(e,t,r)=>{let s,i=r,o=0;if(!t||42!=n)return Oe;if(3>i)return 0;for(i>f-Ze&&(i=f-Ze,o=r-i),l.set(t.subarray(o,o+i),0),C=i,k=i,p=255&l[0],p=(p<<g^255&l[1])&b,s=0;i-3>=s;s++)p=(p<<g^255&l[s+2])&b,h[s&u]=d[p],d[p]=s;return 0},e.Ye=(r,i)=>{let o,w,m,I,R;if(i>4||0>i)return Oe;if(!r.$e||!r.et&&0!==r.We||n==Ye&&4!=i)return r.Le=Qe[4],Oe;if(0===r.tt)return r.Le=Qe[7],-5;var B;if(t=r,I=c,c=i,42==n&&(w=8+(a-8<<4)<<8,m=(D-1&255)>>1,m>3&&(m=3),w|=m<<6,0!==C&&(w|=32),w+=31-w%31,n=Xe,J((B=w)>>8&255),J(255&B)),0!==e.pending){if(t.Te(),0===t.tt)return c=-1,0}else if(0===t.We&&I>=i&&4!=i)return t.Le=Qe[7],-5;if(n==Ye&&0!==t.We)return r.Le=Qe[7],-5;if(0!==t.We||0!==A||0!=i&&n!=Ye){switch(R=-1,Je[D].Re){case 0:R=(e=>{let n,r=65535;for(r>s-5&&(r=s-5);;){if(1>=A){if(ie(),0===A&&0==e)return 0;if(0===A)break}if(C+=A,A=0,n=k+r,(0===C||C>=n)&&(A=C-n,C=n,se(!1),0===t.tt))return 0;if(C-k>=f-Ze&&(se(!1),0===t.tt))return 0}return se(4==e),0===t.tt?4==e?2:0:4==e?3:1})(i);break;case 1:R=(e=>{let n,r=0;for(;;){if(Ze>A){if(ie(),Ze>A&&0==e)return 0;if(0===A)break}if(3>A||(p=(p<<g^255&l[C+2])&b,r=65535&d[p],h[C&u]=d[p],d[p]=C),0===r||(C-r&65535)>f-Ze||2!=V&&(v=oe(r)),3>v)n=ee(0,255&l[C]),A--,C++;else if(n=ee(C-x,v-3),A-=v,v>P||3>A)C+=v,v=0,p=255&l[C],p=(p<<g^255&l[C+1])&b;else{v--;do{C++,p=(p<<g^255&l[C+2])&b,r=65535&d[p],h[C&u]=d[p],d[p]=C}while(0!==--v);C++}if(n&&(se(!1),0===t.tt))return 0}return se(4==e),0===t.tt?4==e?2:0:4==e?3:1})(i);break;case 2:R=(e=>{let n,r,s=0;for(;;){if(Ze>A){if(ie(),Ze>A&&0==e)return 0;if(0===A)break}if(3>A||(p=(p<<g^255&l[C+2])&b,s=65535&d[p],h[C&u]=d[p],d[p]=C),_=v,S=x,v=2,0!==s&&P>_&&f-Ze>=(C-s&65535)&&(2!=V&&(v=oe(s)),5>=v&&(1==V||3==v&&C-x>4096)&&(v=2)),3>_||v>_)if(0!==z){if(n=ee(0,255&l[C-1]),n&&se(!1),C++,A--,0===t.tt)return 0}else z=1,C++,A--;else{r=C+A-3,n=ee(C-1-S,_-3),A-=_-1,_-=2;do{++C>r||(p=(p<<g^255&l[C+2])&b,s=65535&d[p],h[C&u]=d[p],d[p]=C)}while(0!==--_);if(z=0,v=2,C++,n&&(se(!1),0===t.tt))return 0}}return 0!==z&&(n=ee(0,255&l[C-1]),z=0),se(4==e),0===t.tt?4==e?2:0:4==e?3:1})(i)}if(2!=R&&3!=R||(n=Ye),0==R||2==R)return 0===t.tt&&(c=-1),0;if(1==R){if(1==i)X(2,3),Y(256,Le._e),$(),9>1+H+10-F&&(X(2,3),Y(256,Le._e),$()),H=7;else if(re(0,0,!1),3==i)for(o=0;y>o;o++)d[o]=0;if(t.Te(),0===t.tt)return c=-1,0}}return 4!=i?0:1}}function tt(){const e=this;e.nt=0,e.rt=0,e.We=0,e.qe=0,e.tt=0,e.Ge=0}function nt(e){const t=new tt,n=(o=e&&e.chunkSize?e.chunkSize:65536)+5*(r.floor(o/16383)+1);var o;const c=new i(n);let f=e?e.level:-1;void 0===f&&(f=-1),t.He(f),t.$e=c,this.append=(e,r)=>{let o,f,a=0,u=0,l=0;const w=[];if(e.length){t.nt=0,t.et=e,t.We=e.length;do{if(t.rt=0,t.tt=n,o=t.Ye(0),0!=o)throw new s("deflating: "+t.Le);t.rt&&(t.rt==n?w.push(new i(c)):w.push(c.subarray(0,t.rt))),l+=t.rt,r&&t.nt>0&&t.nt!=a&&(r(t.nt),a=t.nt)}while(t.We>0||0===t.tt);return w.length>1?(f=new i(l),w.forEach(e=>{f.set(e,u),u+=e.length})):f=w[0]?new i(w[0]):new i,f}},this.flush=()=>{let e,r,o=0,f=0;const a=[];do{if(t.rt=0,t.tt=n,e=t.Ye(4),1!=e&&0!=e)throw new s("deflating: "+t.Le);n-t.tt>0&&a.push(c.slice(0,t.rt)),f+=t.rt}while(t.We>0||0===t.tt);return t.Qe(),r=new i(f),a.forEach(e=>{r.set(e,o),o+=e.length}),r}}tt.prototype={He(e,t){const n=this;return n.Fe=new et,t||(t=15),n.Fe.He(n,e,t)},Ye(e){const t=this;return t.Fe?t.Fe.Ye(t,e):Oe},Qe(){const e=this;if(!e.Fe)return Oe;const t=e.Fe.Qe();return e.Fe=null,t},Xe(e,t){const n=this;return n.Fe?n.Fe.Xe(n,e,t):Oe},Ze(e,t){const n=this;return n.Fe?n.Fe.Ze(n,e,t):Oe},je(e,t,n){const r=this;let s=r.We;return s>n&&(s=n),0===s?0:(r.We-=s,e.set(r.et.subarray(r.nt,r.nt+s),t),r.nt+=s,r.qe+=s,s)},Te(){const e=this;let t=e.Fe.pending;t>e.tt&&(t=e.tt),0!==t&&(e.$e.set(e.Fe.Ke.subarray(e.Fe.Je,e.Fe.Je+t),e.rt),e.rt+=t,e.Fe.Je+=t,e.Ge+=t,e.tt-=t,e.Fe.pending-=t,0===e.Fe.pending&&(e.Fe.Je=0))}};const rt=-2,st=-3,it=-5,ot=[0,1,3,7,15,31,63,127,255,511,1023,2047,4095,8191,16383,32767,65535],ct=[96,7,256,0,8,80,0,8,16,84,8,115,82,7,31,0,8,112,0,8,48,0,9,192,80,7,10,0,8,96,0,8,32,0,9,160,0,8,0,0,8,128,0,8,64,0,9,224,80,7,6,0,8,88,0,8,24,0,9,144,83,7,59,0,8,120,0,8,56,0,9,208,81,7,17,0,8,104,0,8,40,0,9,176,0,8,8,0,8,136,0,8,72,0,9,240,80,7,4,0,8,84,0,8,20,85,8,227,83,7,43,0,8,116,0,8,52,0,9,200,81,7,13,0,8,100,0,8,36,0,9,168,0,8,4,0,8,132,0,8,68,0,9,232,80,7,8,0,8,92,0,8,28,0,9,152,84,7,83,0,8,124,0,8,60,0,9,216,82,7,23,0,8,108,0,8,44,0,9,184,0,8,12,0,8,140,0,8,76,0,9,248,80,7,3,0,8,82,0,8,18,85,8,163,83,7,35,0,8,114,0,8,50,0,9,196,81,7,11,0,8,98,0,8,34,0,9,164,0,8,2,0,8,130,0,8,66,0,9,228,80,7,7,0,8,90,0,8,26,0,9,148,84,7,67,0,8,122,0,8,58,0,9,212,82,7,19,0,8,106,0,8,42,0,9,180,0,8,10,0,8,138,0,8,74,0,9,244,80,7,5,0,8,86,0,8,22,192,8,0,83,7,51,0,8,118,0,8,54,0,9,204,81,7,15,0,8,102,0,8,38,0,9,172,0,8,6,0,8,134,0,8,70,0,9,236,80,7,9,0,8,94,0,8,30,0,9,156,84,7,99,0,8,126,0,8,62,0,9,220,82,7,27,0,8,110,0,8,46,0,9,188,0,8,14,0,8,142,0,8,78,0,9,252,96,7,256,0,8,81,0,8,17,85,8,131,82,7,31,0,8,113,0,8,49,0,9,194,80,7,10,0,8,97,0,8,33,0,9,162,0,8,1,0,8,129,0,8,65,0,9,226,80,7,6,0,8,89,0,8,25,0,9,146,83,7,59,0,8,121,0,8,57,0,9,210,81,7,17,0,8,105,0,8,41,0,9,178,0,8,9,0,8,137,0,8,73,0,9,242,80,7,4,0,8,85,0,8,21,80,8,258,83,7,43,0,8,117,0,8,53,0,9,202,81,7,13,0,8,101,0,8,37,0,9,170,0,8,5,0,8,133,0,8,69,0,9,234,80,7,8,0,8,93,0,8,29,0,9,154,84,7,83,0,8,125,0,8,61,0,9,218,82,7,23,0,8,109,0,8,45,0,9,186,0,8,13,0,8,141,0,8,77,0,9,250,80,7,3,0,8,83,0,8,19,85,8,195,83,7,35,0,8,115,0,8,51,0,9,198,81,7,11,0,8,99,0,8,35,0,9,166,0,8,3,0,8,131,0,8,67,0,9,230,80,7,7,0,8,91,0,8,27,0,9,150,84,7,67,0,8,123,0,8,59,0,9,214,82,7,19,0,8,107,0,8,43,0,9,182,0,8,11,0,8,139,0,8,75,0,9,246,80,7,5,0,8,87,0,8,23,192,8,0,83,7,51,0,8,119,0,8,55,0,9,206,81,7,15,0,8,103,0,8,39,0,9,174,0,8,7,0,8,135,0,8,71,0,9,238,80,7,9,0,8,95,0,8,31,0,9,158,84,7,99,0,8,127,0,8,63,0,9,222,82,7,27,0,8,111,0,8,47,0,9,190,0,8,15,0,8,143,0,8,79,0,9,254,96,7,256,0,8,80,0,8,16,84,8,115,82,7,31,0,8,112,0,8,48,0,9,193,80,7,10,0,8,96,0,8,32,0,9,161,0,8,0,0,8,128,0,8,64,0,9,225,80,7,6,0,8,88,0,8,24,0,9,145,83,7,59,0,8,120,0,8,56,0,9,209,81,7,17,0,8,104,0,8,40,0,9,177,0,8,8,0,8,136,0,8,72,0,9,241,80,7,4,0,8,84,0,8,20,85,8,227,83,7,43,0,8,116,0,8,52,0,9,201,81,7,13,0,8,100,0,8,36,0,9,169,0,8,4,0,8,132,0,8,68,0,9,233,80,7,8,0,8,92,0,8,28,0,9,153,84,7,83,0,8,124,0,8,60,0,9,217,82,7,23,0,8,108,0,8,44,0,9,185,0,8,12,0,8,140,0,8,76,0,9,249,80,7,3,0,8,82,0,8,18,85,8,163,83,7,35,0,8,114,0,8,50,0,9,197,81,7,11,0,8,98,0,8,34,0,9,165,0,8,2,0,8,130,0,8,66,0,9,229,80,7,7,0,8,90,0,8,26,0,9,149,84,7,67,0,8,122,0,8,58,0,9,213,82,7,19,0,8,106,0,8,42,0,9,181,0,8,10,0,8,138,0,8,74,0,9,245,80,7,5,0,8,86,0,8,22,192,8,0,83,7,51,0,8,118,0,8,54,0,9,205,81,7,15,0,8,102,0,8,38,0,9,173,0,8,6,0,8,134,0,8,70,0,9,237,80,7,9,0,8,94,0,8,30,0,9,157,84,7,99,0,8,126,0,8,62,0,9,221,82,7,27,0,8,110,0,8,46,0,9,189,0,8,14,0,8,142,0,8,78,0,9,253,96,7,256,0,8,81,0,8,17,85,8,131,82,7,31,0,8,113,0,8,49,0,9,195,80,7,10,0,8,97,0,8,33,0,9,163,0,8,1,0,8,129,0,8,65,0,9,227,80,7,6,0,8,89,0,8,25,0,9,147,83,7,59,0,8,121,0,8,57,0,9,211,81,7,17,0,8,105,0,8,41,0,9,179,0,8,9,0,8,137,0,8,73,0,9,243,80,7,4,0,8,85,0,8,21,80,8,258,83,7,43,0,8,117,0,8,53,0,9,203,81,7,13,0,8,101,0,8,37,0,9,171,0,8,5,0,8,133,0,8,69,0,9,235,80,7,8,0,8,93,0,8,29,0,9,155,84,7,83,0,8,125,0,8,61,0,9,219,82,7,23,0,8,109,0,8,45,0,9,187,0,8,13,0,8,141,0,8,77,0,9,251,80,7,3,0,8,83,0,8,19,85,8,195,83,7,35,0,8,115,0,8,51,0,9,199,81,7,11,0,8,99,0,8,35,0,9,167,0,8,3,0,8,131,0,8,67,0,9,231,80,7,7,0,8,91,0,8,27,0,9,151,84,7,67,0,8,123,0,8,59,0,9,215,82,7,19,0,8,107,0,8,43,0,9,183,0,8,11,0,8,139,0,8,75,0,9,247,80,7,5,0,8,87,0,8,23,192,8,0,83,7,51,0,8,119,0,8,55,0,9,207,81,7,15,0,8,103,0,8,39,0,9,175,0,8,7,0,8,135,0,8,71,0,9,239,80,7,9,0,8,95,0,8,31,0,9,159,84,7,99,0,8,127,0,8,63,0,9,223,82,7,27,0,8,111,0,8,47,0,9,191,0,8,15,0,8,143,0,8,79,0,9,255],ft=[80,5,1,87,5,257,83,5,17,91,5,4097,81,5,5,89,5,1025,85,5,65,93,5,16385,80,5,3,88,5,513,84,5,33,92,5,8193,82,5,9,90,5,2049,86,5,129,192,5,24577,80,5,2,87,5,385,83,5,25,91,5,6145,81,5,7,89,5,1537,85,5,97,93,5,24577,80,5,4,88,5,769,84,5,49,92,5,12289,82,5,13,90,5,3073,86,5,193,192,5,24577],at=[3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51,59,67,83,99,115,131,163,195,227,258,0,0],ut=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0,112,112],lt=[1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257,385,513,769,1025,1537,2049,3073,4097,6145,8193,12289,16385,24577],wt=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13];function ht(){let e,t,n,r,s,i;function o(e,t,o,c,f,a,u,l,w,h,d){let p,y,m,b,g,k,v,S,z,C,x,A,_,I,P;C=0,g=o;do{n[e[t+C]]++,C++,g--}while(0!==g);if(n[0]==o)return u[0]=-1,l[0]=0,0;for(S=l[0],k=1;15>=k&&0===n[k];k++);for(v=k,k>S&&(S=k),g=15;0!==g&&0===n[g];g--);for(m=g,S>g&&(S=g),l[0]=S,I=1<<k;g>k;k++,I<<=1)if(0>(I-=n[k]))return st;if(0>(I-=n[g]))return st;for(n[g]+=I,i[1]=k=0,C=1,_=2;0!==--g;)i[_]=k+=n[C],_++,C++;g=0,C=0;do{0!==(k=e[t+C])&&(d[i[k]++]=g),C++}while(++g<o);for(o=i[m],i[0]=g=0,C=0,b=-1,A=-S,s[0]=0,x=0,P=0;m>=v;v++)for(p=n[v];0!==p--;){for(;v>A+S;){if(b++,A+=S,P=m-A,P=P>S?S:P,(y=1<<(k=v-A))>p+1&&(y-=p+1,_=v,P>k))for(;++k<P&&(y<<=1)>n[++_];)y-=n[_];if(P=1<<k,h[0]+P>1440)return st;s[b]=x=h[0],h[0]+=P,0!==b?(i[b]=g,r[0]=k,r[1]=S,k=g>>>A-S,r[2]=x-s[b-1]-k,w.set(r,3*(s[b-1]+k))):u[0]=x}for(r[1]=v-A,o>C?d[C]<c?(r[0]=256>d[C]?0:96,r[2]=d[C++]):(r[0]=a[d[C]-c]+16+64,r[2]=f[d[C++]-c]):r[0]=192,y=1<<v-A,k=g>>>A;P>k;k+=y)w.set(r,3*(x+k));for(k=1<<v-1;0!==(g&k);k>>>=1)g^=k;for(g^=k,z=(1<<A)-1;(g&z)!=i[b];)b--,A-=S,z=(1<<A)-1}return 0!==I&&1!=m?it:0}function c(o){let c;for(e||(e=[],t=[],n=new f(16),r=[],s=new f(15),i=new f(16)),t.length<o&&(t=[]),c=0;o>c;c++)t[c]=0;for(c=0;16>c;c++)n[c]=0;for(c=0;3>c;c++)r[c]=0;s.set(n.subarray(0,15),0),i.set(n.subarray(0,16),0)}this.st=(n,r,s,i,f)=>{let a;return c(19),e[0]=0,a=o(n,0,19,19,null,null,s,r,i,e,t),a==st?f.Le="oversubscribed dynamic bit lengths tree":a!=it&&0!==r[0]||(f.Le="incomplete dynamic bit lengths tree",a=st),a},this.it=(n,r,s,i,f,a,u,l,w)=>{let h;return c(288),e[0]=0,h=o(s,0,n,257,at,ut,a,i,l,e,t),0!=h||0===i[0]?(h==st?w.Le="oversubscribed literal/length tree":-4!=h&&(w.Le="incomplete literal/length tree",h=st),h):(c(288),h=o(s,n,r,0,lt,wt,u,f,l,e,t),0!=h||0===f[0]&&n>257?(h==st?w.Le="oversubscribed distance tree":h==it?(w.Le="incomplete distance tree",h=st):-4!=h&&(w.Le="empty distance tree with lengths",h=st),h):0)}}function dt(){const e=this;let t,n,r,s,i=0,o=0,c=0,f=0,a=0,u=0,l=0,w=0,h=0,d=0;function p(e,t,n,r,s,i,o,c){let f,a,u,l,w,h,d,p,y,m,b,g,k,v,S,z;d=c.nt,p=c.We,w=o.ot,h=o.ct,y=o.write,m=y<o.read?o.read-y-1:o.end-y,b=ot[e],g=ot[t];do{for(;20>h;)p--,w|=(255&c.ft(d++))<<h,h+=8;if(f=w&b,a=n,u=r,z=3*(u+f),0!==(l=a[z]))for(;;){if(w>>=a[z+1],h-=a[z+1],16&l){for(l&=15,k=a[z+2]+(w&ot[l]),w>>=l,h-=l;15>h;)p--,w|=(255&c.ft(d++))<<h,h+=8;for(f=w&g,a=s,u=i,z=3*(u+f),l=a[z];;){if(w>>=a[z+1],h-=a[z+1],16&l){for(l&=15;l>h;)p--,w|=(255&c.ft(d++))<<h,h+=8;if(v=a[z+2]+(w&ot[l]),w>>=l,h-=l,m-=k,v>y){S=y-v;do{S+=o.end}while(0>S);if(l=o.end-S,k>l){if(k-=l,y-S>0&&l>y-S)do{o.ut[y++]=o.ut[S++]}while(0!==--l);else o.ut.set(o.ut.subarray(S,S+l),y),y+=l,S+=l,l=0;S=0}}else S=y-v,y-S>0&&2>y-S?(o.ut[y++]=o.ut[S++],o.ut[y++]=o.ut[S++],k-=2):(o.ut.set(o.ut.subarray(S,S+2),y),y+=2,S+=2,k-=2);if(y-S>0&&k>y-S)do{o.ut[y++]=o.ut[S++]}while(0!==--k);else o.ut.set(o.ut.subarray(S,S+k),y),y+=k,S+=k,k=0;break}if(64&l)return c.Le="invalid distance code",k=c.We-p,k=k>h>>3?h>>3:k,p+=k,d-=k,h-=k<<3,o.ot=w,o.ct=h,c.We=p,c.qe+=d-c.nt,c.nt=d,o.write=y,st;f+=a[z+2],f+=w&ot[l],z=3*(u+f),l=a[z]}break}if(64&l)return 32&l?(k=c.We-p,k=k>h>>3?h>>3:k,p+=k,d-=k,h-=k<<3,o.ot=w,o.ct=h,c.We=p,c.qe+=d-c.nt,c.nt=d,o.write=y,1):(c.Le="invalid literal/length code",k=c.We-p,k=k>h>>3?h>>3:k,p+=k,d-=k,h-=k<<3,o.ot=w,o.ct=h,c.We=p,c.qe+=d-c.nt,c.nt=d,o.write=y,st);if(f+=a[z+2],f+=w&ot[l],z=3*(u+f),0===(l=a[z])){w>>=a[z+1],h-=a[z+1],o.ut[y++]=a[z+2],m--;break}}else w>>=a[z+1],h-=a[z+1],o.ut[y++]=a[z+2],m--}while(m>=258&&p>=10);return k=c.We-p,k=k>h>>3?h>>3:k,p+=k,d-=k,h-=k<<3,o.ot=w,o.ct=h,c.We=p,c.qe+=d-c.nt,c.nt=d,o.write=y,0}e.init=(e,i,o,c,f,a)=>{t=0,l=e,w=i,r=o,h=c,s=f,d=a,n=null},e.lt=(e,y,m)=>{let b,g,k,v,S,z,C,x=0,A=0,_=0;for(_=y.nt,v=y.We,x=e.ot,A=e.ct,S=e.write,z=S<e.read?e.read-S-1:e.end-S;;)switch(t){case 0:if(z>=258&&v>=10&&(e.ot=x,e.ct=A,y.We=v,y.qe+=_-y.nt,y.nt=_,e.write=S,m=p(l,w,r,h,s,d,e,y),_=y.nt,v=y.We,x=e.ot,A=e.ct,S=e.write,z=S<e.read?e.read-S-1:e.end-S,0!=m)){t=1==m?7:9;break}c=l,n=r,o=h,t=1;case 1:for(b=c;b>A;){if(0===v)return e.ot=x,e.ct=A,y.We=v,y.qe+=_-y.nt,y.nt=_,e.write=S,e.wt(y,m);m=0,v--,x|=(255&y.ft(_++))<<A,A+=8}if(g=3*(o+(x&ot[b])),x>>>=n[g+1],A-=n[g+1],k=n[g],0===k){f=n[g+2],t=6;break}if(16&k){a=15&k,i=n[g+2],t=2;break}if(!(64&k)){c=k,o=g/3+n[g+2];break}if(32&k){t=7;break}return t=9,y.Le="invalid literal/length code",m=st,e.ot=x,e.ct=A,y.We=v,y.qe+=_-y.nt,y.nt=_,e.write=S,e.wt(y,m);case 2:for(b=a;b>A;){if(0===v)return e.ot=x,e.ct=A,y.We=v,y.qe+=_-y.nt,y.nt=_,e.write=S,e.wt(y,m);m=0,v--,x|=(255&y.ft(_++))<<A,A+=8}i+=x&ot[b],x>>=b,A-=b,c=w,n=s,o=d,t=3;case 3:for(b=c;b>A;){if(0===v)return e.ot=x,e.ct=A,y.We=v,y.qe+=_-y.nt,y.nt=_,e.write=S,e.wt(y,m);m=0,v--,x|=(255&y.ft(_++))<<A,A+=8}if(g=3*(o+(x&ot[b])),x>>=n[g+1],A-=n[g+1],k=n[g],16&k){a=15&k,u=n[g+2],t=4;break}if(!(64&k)){c=k,o=g/3+n[g+2];break}return t=9,y.Le="invalid distance code",m=st,e.ot=x,e.ct=A,y.We=v,y.qe+=_-y.nt,y.nt=_,e.write=S,e.wt(y,m);case 4:for(b=a;b>A;){if(0===v)return e.ot=x,e.ct=A,y.We=v,y.qe+=_-y.nt,y.nt=_,e.write=S,e.wt(y,m);m=0,v--,x|=(255&y.ft(_++))<<A,A+=8}u+=x&ot[b],x>>=b,A-=b,t=5;case 5:for(C=S-u;0>C;)C+=e.end;for(;0!==i;){if(0===z&&(S==e.end&&0!==e.read&&(S=0,z=S<e.read?e.read-S-1:e.end-S),0===z&&(e.write=S,m=e.wt(y,m),S=e.write,z=S<e.read?e.read-S-1:e.end-S,S==e.end&&0!==e.read&&(S=0,z=S<e.read?e.read-S-1:e.end-S),0===z)))return e.ot=x,e.ct=A,y.We=v,y.qe+=_-y.nt,y.nt=_,e.write=S,e.wt(y,m);e.ut[S++]=e.ut[C++],z--,C==e.end&&(C=0),i--}t=0;break;case 6:if(0===z&&(S==e.end&&0!==e.read&&(S=0,z=S<e.read?e.read-S-1:e.end-S),0===z&&(e.write=S,m=e.wt(y,m),S=e.write,z=S<e.read?e.read-S-1:e.end-S,S==e.end&&0!==e.read&&(S=0,z=S<e.read?e.read-S-1:e.end-S),0===z)))return e.ot=x,e.ct=A,y.We=v,y.qe+=_-y.nt,y.nt=_,e.write=S,e.wt(y,m);m=0,e.ut[S++]=f,z--,t=0;break;case 7:if(A>7&&(A-=8,v++,_--),e.write=S,m=e.wt(y,m),S=e.write,z=S<e.read?e.read-S-1:e.end-S,e.read!=e.write)return e.ot=x,e.ct=A,y.We=v,y.qe+=_-y.nt,y.nt=_,e.write=S,e.wt(y,m);t=8;case 8:return m=1,e.ot=x,e.ct=A,y.We=v,y.qe+=_-y.nt,y.nt=_,e.write=S,e.wt(y,m);case 9:return m=st,e.ot=x,e.ct=A,y.We=v,y.qe+=_-y.nt,y.nt=_,e.write=S,e.wt(y,m);default:return m=rt,e.ot=x,e.ct=A,y.We=v,y.qe+=_-y.nt,y.nt=_,e.write=S,e.wt(y,m)}},e.ht=()=>{}}ht.dt=(e,t,n,r)=>(e[0]=9,t[0]=5,n[0]=ct,r[0]=ft,0);const pt=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15];function yt(e,t){const n=this;let r,s=0,o=0,c=0,a=0;const u=[0],l=[0],w=new dt;let h=0,d=new f(4320);const p=new ht;n.ct=0,n.ot=0,n.ut=new i(t),n.end=t,n.read=0,n.write=0,n.reset=(e,t)=>{t&&(t[0]=0),6==s&&w.ht(e),s=0,n.ct=0,n.ot=0,n.read=n.write=0},n.reset(e,null),n.wt=(e,t)=>{let r,s,i;return s=e.rt,i=n.read,r=(i>n.write?n.end:n.write)-i,r>e.tt&&(r=e.tt),0!==r&&t==it&&(t=0),e.tt-=r,e.Ge+=r,e.$e.set(n.ut.subarray(i,i+r),s),s+=r,i+=r,i==n.end&&(i=0,n.write==n.end&&(n.write=0),r=n.write-i,r>e.tt&&(r=e.tt),0!==r&&t==it&&(t=0),e.tt-=r,e.Ge+=r,e.$e.set(n.ut.subarray(i,i+r),s),s+=r,i+=r),e.rt=s,n.read=i,t},n.lt=(e,t)=>{let i,f,y,m,b,g,k,v;for(m=e.nt,b=e.We,f=n.ot,y=n.ct,g=n.write,k=g<n.read?n.read-g-1:n.end-g;;){let S,z,C,x,A,_,I,P;switch(s){case 0:for(;3>y;){if(0===b)return n.ot=f,n.ct=y,e.We=b,e.qe+=m-e.nt,e.nt=m,n.write=g,n.wt(e,t);t=0,b--,f|=(255&e.ft(m++))<<y,y+=8}switch(i=7&f,h=1&i,i>>>1){case 0:f>>>=3,y-=3,i=7&y,f>>>=i,y-=i,s=1;break;case 1:S=[],z=[],C=[[]],x=[[]],ht.dt(S,z,C,x),w.init(S[0],z[0],C[0],0,x[0],0),f>>>=3,y-=3,s=6;break;case 2:f>>>=3,y-=3,s=3;break;case 3:return f>>>=3,y-=3,s=9,e.Le="invalid block type",t=st,n.ot=f,n.ct=y,e.We=b,e.qe+=m-e.nt,e.nt=m,n.write=g,n.wt(e,t)}break;case 1:for(;32>y;){if(0===b)return n.ot=f,n.ct=y,e.We=b,e.qe+=m-e.nt,e.nt=m,n.write=g,n.wt(e,t);t=0,b--,f|=(255&e.ft(m++))<<y,y+=8}if((~f>>>16&65535)!=(65535&f))return s=9,e.Le="invalid stored block lengths",t=st,n.ot=f,n.ct=y,e.We=b,e.qe+=m-e.nt,e.nt=m,n.write=g,n.wt(e,t);o=65535&f,f=y=0,s=0!==o?2:0!==h?7:0;break;case 2:if(0===b)return n.ot=f,n.ct=y,e.We=b,e.qe+=m-e.nt,e.nt=m,n.write=g,n.wt(e,t);if(0===k&&(g==n.end&&0!==n.read&&(g=0,k=g<n.read?n.read-g-1:n.end-g),0===k&&(n.write=g,t=n.wt(e,t),g=n.write,k=g<n.read?n.read-g-1:n.end-g,g==n.end&&0!==n.read&&(g=0,k=g<n.read?n.read-g-1:n.end-g),0===k)))return n.ot=f,n.ct=y,e.We=b,e.qe+=m-e.nt,e.nt=m,n.write=g,n.wt(e,t);if(t=0,i=o,i>b&&(i=b),i>k&&(i=k),n.ut.set(e.je(m,i),g),m+=i,b-=i,g+=i,k-=i,0!==(o-=i))break;s=0!==h?7:0;break;case 3:for(;14>y;){if(0===b)return n.ot=f,n.ct=y,e.We=b,e.qe+=m-e.nt,e.nt=m,n.write=g,n.wt(e,t);t=0,b--,f|=(255&e.ft(m++))<<y,y+=8}if(c=i=16383&f,(31&i)>29||(i>>5&31)>29)return s=9,e.Le="too many length or distance symbols",t=st,n.ot=f,n.ct=y,e.We=b,e.qe+=m-e.nt,e.nt=m,n.write=g,n.wt(e,t);if(i=258+(31&i)+(i>>5&31),!r||r.length<i)r=[];else for(v=0;i>v;v++)r[v]=0;f>>>=14,y-=14,a=0,s=4;case 4:for(;4+(c>>>10)>a;){for(;3>y;){if(0===b)return n.ot=f,n.ct=y,e.We=b,e.qe+=m-e.nt,e.nt=m,n.write=g,n.wt(e,t);t=0,b--,f|=(255&e.ft(m++))<<y,y+=8}r[pt[a++]]=7&f,f>>>=3,y-=3}for(;19>a;)r[pt[a++]]=0;if(u[0]=7,i=p.st(r,u,l,d,e),0!=i)return(t=i)==st&&(r=null,s=9),n.ot=f,n.ct=y,e.We=b,e.qe+=m-e.nt,e.nt=m,n.write=g,n.wt(e,t);a=0,s=5;case 5:for(;i=c,258+(31&i)+(i>>5&31)>a;){let o,w;for(i=u[0];i>y;){if(0===b)return n.ot=f,n.ct=y,e.We=b,e.qe+=m-e.nt,e.nt=m,n.write=g,n.wt(e,t);t=0,b--,f|=(255&e.ft(m++))<<y,y+=8}if(i=d[3*(l[0]+(f&ot[i]))+1],w=d[3*(l[0]+(f&ot[i]))+2],16>w)f>>>=i,y-=i,r[a++]=w;else{for(v=18==w?7:w-14,o=18==w?11:3;i+v>y;){if(0===b)return n.ot=f,n.ct=y,e.We=b,e.qe+=m-e.nt,e.nt=m,n.write=g,n.wt(e,t);t=0,b--,f|=(255&e.ft(m++))<<y,y+=8}if(f>>>=i,y-=i,o+=f&ot[v],f>>>=v,y-=v,v=a,i=c,v+o>258+(31&i)+(i>>5&31)||16==w&&1>v)return r=null,s=9,e.Le="invalid bit length repeat",t=st,n.ot=f,n.ct=y,e.We=b,e.qe+=m-e.nt,e.nt=m,n.write=g,n.wt(e,t);w=16==w?r[v-1]:0;do{r[v++]=w}while(0!==--o);a=v}}if(l[0]=-1,A=[],_=[],I=[],P=[],A[0]=9,_[0]=6,i=c,i=p.it(257+(31&i),1+(i>>5&31),r,A,_,I,P,d,e),0!=i)return i==st&&(r=null,s=9),t=i,n.ot=f,n.ct=y,e.We=b,e.qe+=m-e.nt,e.nt=m,n.write=g,n.wt(e,t);w.init(A[0],_[0],d,I[0],d,P[0]),s=6;case 6:if(n.ot=f,n.ct=y,e.We=b,e.qe+=m-e.nt,e.nt=m,n.write=g,1!=(t=w.lt(n,e,t)))return n.wt(e,t);if(t=0,w.ht(e),m=e.nt,b=e.We,f=n.ot,y=n.ct,g=n.write,k=g<n.read?n.read-g-1:n.end-g,0===h){s=0;break}s=7;case 7:if(n.write=g,t=n.wt(e,t),g=n.write,k=g<n.read?n.read-g-1:n.end-g,n.read!=n.write)return n.ot=f,n.ct=y,e.We=b,e.qe+=m-e.nt,e.nt=m,n.write=g,n.wt(e,t);s=8;case 8:return t=1,n.ot=f,n.ct=y,e.We=b,e.qe+=m-e.nt,e.nt=m,n.write=g,n.wt(e,t);case 9:return t=st,n.ot=f,n.ct=y,e.We=b,e.qe+=m-e.nt,e.nt=m,n.write=g,n.wt(e,t);default:return t=rt,n.ot=f,n.ct=y,e.We=b,e.qe+=m-e.nt,e.nt=m,n.write=g,n.wt(e,t)}}},n.ht=e=>{n.reset(e,null),n.ut=null,d=null},n.yt=(e,t,r)=>{n.ut.set(e.subarray(t,t+r),0),n.read=n.write=r},n.bt=()=>1==s?1:0}const mt=13,bt=[0,0,255,255];function gt(){const e=this;function t(e){return e&&e.gt?(e.qe=e.Ge=0,e.Le=null,e.gt.mode=7,e.gt.kt.reset(e,null),0):rt}e.mode=0,e.method=0,e.vt=[0],e.St=0,e.marker=0,e.zt=0,e.Ct=t=>(e.kt&&e.kt.ht(t),e.kt=null,0),e.xt=(n,r)=>(n.Le=null,e.kt=null,8>r||r>15?(e.Ct(n),rt):(e.zt=r,n.gt.kt=new yt(n,1<<r),t(n),0)),e.At=(e,t)=>{let n,r;if(!e||!e.gt||!e.et)return rt;const s=e.gt;for(t=4==t?it:0,n=it;;)switch(s.mode){case 0:if(0===e.We)return n;if(n=t,e.We--,e.qe++,8!=(15&(s.method=e.ft(e.nt++)))){s.mode=mt,e.Le="unknown compression method",s.marker=5;break}if(8+(s.method>>4)>s.zt){s.mode=mt,e.Le="invalid win size",s.marker=5;break}s.mode=1;case 1:if(0===e.We)return n;if(n=t,e.We--,e.qe++,r=255&e.ft(e.nt++),((s.method<<8)+r)%31!=0){s.mode=mt,e.Le="incorrect header check",s.marker=5;break}if(!(32&r)){s.mode=7;break}s.mode=2;case 2:if(0===e.We)return n;n=t,e.We--,e.qe++,s.St=(255&e.ft(e.nt++))<<24&4278190080,s.mode=3;case 3:if(0===e.We)return n;n=t,e.We--,e.qe++,s.St+=(255&e.ft(e.nt++))<<16&16711680,s.mode=4;case 4:if(0===e.We)return n;n=t,e.We--,e.qe++,s.St+=(255&e.ft(e.nt++))<<8&65280,s.mode=5;case 5:return 0===e.We?n:(n=t,e.We--,e.qe++,s.St+=255&e.ft(e.nt++),s.mode=6,2);case 6:return s.mode=mt,e.Le="need dictionary",s.marker=0,rt;case 7:if(n=s.kt.lt(e,n),n==st){s.mode=mt,s.marker=0;break}if(0==n&&(n=t),1!=n)return n;n=t,s.kt.reset(e,s.vt),s.mode=12;case 12:return e.We=0,1;case mt:return st;default:return rt}},e._t=(e,t,n)=>{let r=0,s=n;if(!e||!e.gt||6!=e.gt.mode)return rt;const i=e.gt;return s<1<<i.zt||(s=(1<<i.zt)-1,r=n-s),i.kt.yt(t,r,s),i.mode=7,0},e.It=e=>{let n,r,s,i,o;if(!e||!e.gt)return rt;const c=e.gt;if(c.mode!=mt&&(c.mode=mt,c.marker=0),0===(n=e.We))return it;for(r=e.nt,s=c.marker;0!==n&&4>s;)e.ft(r)==bt[s]?s++:s=0!==e.ft(r)?0:4-s,r++,n--;return e.qe+=r-e.nt,e.nt=r,e.We=n,c.marker=s,4!=s?st:(i=e.qe,o=e.Ge,t(e),e.qe=i,e.Ge=o,c.mode=7,0)},e.Pt=e=>e&&e.gt&&e.gt.kt?e.gt.kt.bt():rt}function kt(){}function vt(e){const t=new kt,n=e&&e.chunkSize?r.floor(2*e.chunkSize):131072,o=new i(n);let c=!1;t.xt(),t.$e=o,this.append=(e,r)=>{const f=[];let a,u,l=0,w=0,h=0;if(0!==e.length){t.nt=0,t.et=e,t.We=e.length;do{if(t.rt=0,t.tt=n,0!==t.We||c||(t.nt=0,c=!0),a=t.At(0),c&&a===it){if(0!==t.We)throw new s("inflating: bad input")}else if(0!==a&&1!==a)throw new s("inflating: "+t.Le);if((c||1===a)&&t.We===e.length)throw new s("inflating: bad input");t.rt&&(t.rt===n?f.push(new i(o)):f.push(o.subarray(0,t.rt))),h+=t.rt,r&&t.nt>0&&t.nt!=l&&(r(t.nt),l=t.nt)}while(t.We>0||0===t.tt);return f.length>1?(u=new i(h),f.forEach(e=>{u.set(e,w),w+=e.length})):u=f[0]?new i(f[0]):new i,u}},this.flush=()=>{t.Ct()}}kt.prototype={xt(e){const t=this;return t.gt=new gt,e||(e=15),t.gt.xt(t,e)},At(e){const t=this;return t.gt?t.gt.At(t,e):rt},Ct(){const e=this;if(!e.gt)return rt;const t=e.gt.Ct(e);return e.gt=null,t},It(){const e=this;return e.gt?e.gt.It(e):rt},_t(e,t){const n=this;return n.gt?n.gt._t(n,e,t):rt},ft(e){return this.et[e]},je(e,t){return this.et.subarray(e,e+t)}},self.initCodec=()=>{self.Deflate=nt,self.Inflate=vt};\n',
        r = () => t.useDataURI ? "data:text/javascript," + encodeURIComponent(n) : URL.createObjectURL(new Blob([n], {
          type: "text/javascript"
        }));
      e({
        workerScripts: {
          inflate: [r],
          deflate: [r]
        }
      });
    }

    /*
     Copyright (c) 2022 Gildas Lormeau. All rights reserved.

     Redistribution and use in source and binary forms, with or without
     modification, are permitted provided that the following conditions are met:

     1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright 
     notice, this list of conditions and the following disclaimer in 
     the documentation and/or other materials provided with the distribution.

     3. The names of the authors may not be used to endorse or promote products
     derived from this software without specific prior written permission.

     THIS SOFTWARE IS PROVIDED ''AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
     INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
     FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JCRAFT,
     INC. OR ANY CONTRIBUTORS TO THIS SOFTWARE BE LIABLE FOR ANY DIRECT, INDIRECT,
     INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
     LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
     OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
     LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
     NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
     EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     */

    const ERR_ITERATOR_COMPLETED_TOO_SOON = "Writer iterator completed too soon";
    const DEFAULT_CHUNK_SIZE = 64 * 1024;
    const PROPERTY_NAME_WRITABLE = "writable";
    class Stream {
      constructor() {
        this.size = 0;
      }
      init() {
        this.initialized = true;
      }
    }
    class Reader extends Stream {
      get readable() {
        const reader = this;
        const {
          chunkSize = DEFAULT_CHUNK_SIZE
        } = reader;
        const readable = new ReadableStream({
          start() {
            this.chunkOffset = 0;
          },
          async pull(controller) {
            const {
              offset = 0,
              size,
              diskNumberStart
            } = readable;
            const {
              chunkOffset
            } = this;
            const dataSize = size === UNDEFINED_VALUE ? chunkSize : Math.min(chunkSize, size - chunkOffset);
            const data = await readUint8Array(reader, offset + chunkOffset, dataSize, diskNumberStart);
            controller.enqueue(data);
            if (chunkOffset + chunkSize > size || size === UNDEFINED_VALUE && !data.length && dataSize) {
              controller.close();
            } else {
              this.chunkOffset += chunkSize;
            }
          }
        });
        return readable;
      }
    }
    class BlobReader extends Reader {
      constructor(blob) {
        super();
        Object.assign(this, {
          blob,
          size: blob.size
        });
      }
      async readUint8Array(offset, length) {
        const reader = this;
        const offsetEnd = offset + length;
        const blob = offset || offsetEnd < reader.size ? reader.blob.slice(offset, offsetEnd) : reader.blob;
        let arrayBuffer = await blob.arrayBuffer();
        if (arrayBuffer.byteLength > length) {
          arrayBuffer = arrayBuffer.slice(offset, offsetEnd);
        }
        return new Uint8Array(arrayBuffer);
      }
    }
    class SplitDataReader extends Reader {
      constructor(readers) {
        super();
        this.readers = readers;
      }
      async init() {
        const reader = this;
        const {
          readers
        } = reader;
        reader.lastDiskNumber = 0;
        reader.lastDiskOffset = 0;
        await Promise.all(readers.map(async (diskReader, indexDiskReader) => {
          await diskReader.init();
          if (indexDiskReader != readers.length - 1) {
            reader.lastDiskOffset += diskReader.size;
          }
          reader.size += diskReader.size;
        }));
        super.init();
      }
      async readUint8Array(offset, length, diskNumber = 0) {
        const reader = this;
        const {
          readers
        } = this;
        let result;
        let currentDiskNumber = diskNumber;
        if (currentDiskNumber == -1) {
          currentDiskNumber = readers.length - 1;
        }
        let currentReaderOffset = offset;
        while (readers[currentDiskNumber] && currentReaderOffset >= readers[currentDiskNumber].size) {
          currentReaderOffset -= readers[currentDiskNumber].size;
          currentDiskNumber++;
        }
        const currentReader = readers[currentDiskNumber];
        if (currentReader) {
          const currentReaderSize = currentReader.size;
          if (currentReaderOffset + length <= currentReaderSize) {
            result = await readUint8Array(currentReader, currentReaderOffset, length);
          } else {
            const chunkLength = currentReaderSize - currentReaderOffset;
            result = new Uint8Array(length);
            const firstPart = await readUint8Array(currentReader, currentReaderOffset, chunkLength);
            result.set(firstPart, 0);
            const secondPart = await reader.readUint8Array(offset + chunkLength, length - chunkLength, diskNumber);
            result.set(secondPart, chunkLength);
            if (firstPart.length + secondPart.length < length) {
              result = result.subarray(0, firstPart.length + secondPart.length);
            }
          }
        } else {
          result = new Uint8Array();
        }
        reader.lastDiskNumber = Math.max(currentDiskNumber, reader.lastDiskNumber);
        return result;
      }
    }
    class SplitDataWriter extends Stream {
      constructor(writerGenerator, maxSize = 4294967295) {
        super();
        const writer = this;
        Object.assign(writer, {
          diskNumber: 0,
          diskOffset: 0,
          size: 0,
          maxSize,
          availableSize: maxSize
        });
        let diskSourceWriter, diskWritable, diskWriter;
        const writable = new WritableStream({
          async write(chunk) {
            const {
              availableSize
            } = writer;
            if (!diskWriter) {
              const {
                value,
                done
              } = await writerGenerator.next();
              if (done && !value) {
                throw new Error(ERR_ITERATOR_COMPLETED_TOO_SOON);
              } else {
                diskSourceWriter = value;
                diskSourceWriter.size = 0;
                if (diskSourceWriter.maxSize) {
                  writer.maxSize = diskSourceWriter.maxSize;
                }
                writer.availableSize = writer.maxSize;
                await initStream(diskSourceWriter);
                diskWritable = value.writable;
                diskWriter = diskWritable.getWriter();
              }
              await this.write(chunk);
            } else if (chunk.length >= availableSize) {
              await writeChunk(chunk.subarray(0, availableSize));
              await closeDisk();
              writer.diskOffset += diskSourceWriter.size;
              writer.diskNumber++;
              diskWriter = null;
              await this.write(chunk.subarray(availableSize));
            } else {
              await writeChunk(chunk);
            }
          },
          async close() {
            await diskWriter.ready;
            await closeDisk();
          }
        });
        Object.defineProperty(writer, PROPERTY_NAME_WRITABLE, {
          get() {
            return writable;
          }
        });
        async function writeChunk(chunk) {
          const chunkLength = chunk.length;
          if (chunkLength) {
            await diskWriter.ready;
            await diskWriter.write(chunk);
            diskSourceWriter.size += chunkLength;
            writer.size += chunkLength;
            writer.availableSize -= chunkLength;
          }
        }
        async function closeDisk() {
          await diskWriter.close();
        }
      }
    }
    class GenericReader {
      constructor(reader) {
        if (Array.isArray(reader)) {
          reader = new SplitDataReader(reader);
        }
        if (reader instanceof ReadableStream) {
          reader = {
            readable: reader
          };
        }
        return reader;
      }
    }
    class GenericWriter {
      constructor(writer) {
        if (writer.writable === UNDEFINED_VALUE && typeof writer.next == FUNCTION_TYPE) {
          writer = new SplitDataWriter(writer);
        }
        if (writer instanceof WritableStream) {
          writer = {
            writable: writer
          };
        }
        if (writer.size === UNDEFINED_VALUE) {
          writer.size = 0;
        }
        if (!(writer instanceof SplitDataWriter)) {
          Object.assign(writer, {
            diskNumber: 0,
            diskOffset: 0,
            availableSize: Infinity,
            maxSize: Infinity
          });
        }
        return writer;
      }
    }
    async function initStream(stream, initSize) {
      if (stream.init && !stream.initialized) {
        await stream.init(initSize);
      } else {
        return Promise.resolve();
      }
    }
    function readUint8Array(reader, offset, size, diskNumber) {
      return reader.readUint8Array(offset, size, diskNumber);
    }

    /*
     Copyright (c) 2022 Gildas Lormeau. All rights reserved.

     Redistribution and use in source and binary forms, with or without
     modification, are permitted provided that the following conditions are met:

     1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright 
     notice, this list of conditions and the following disclaimer in 
     the documentation and/or other materials provided with the distribution.

     3. The names of the authors may not be used to endorse or promote products
     derived from this software without specific prior written permission.

     THIS SOFTWARE IS PROVIDED ''AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
     INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
     FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JCRAFT,
     INC. OR ANY CONTRIBUTORS TO THIS SOFTWARE BE LIABLE FOR ANY DIRECT, INDIRECT,
     INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
     LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
     OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
     LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
     NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
     EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     */

    /* global TextDecoder */

    const CP437 = "\0☺☻♥♦♣♠•◘○◙♂♀♪♫☼►◄↕‼¶§▬↨↑↓→←∟↔▲▼ !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~⌂ÇüéâäàåçêëèïîìÄÅÉæÆôöòûùÿÖÜ¢£¥₧ƒáíóúñÑªº¿⌐¬½¼¡«»░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀αßΓπΣσµτΦΘΩδ∞φε∩≡±≥≤⌠⌡÷≈°∙·√ⁿ²■ ".split("");
    const VALID_CP437 = CP437.length == 256;
    function decodeCP437(stringValue) {
      if (VALID_CP437) {
        let result = "";
        for (let indexCharacter = 0; indexCharacter < stringValue.length; indexCharacter++) {
          result += CP437[stringValue[indexCharacter]];
        }
        return result;
      } else {
        return new TextDecoder().decode(stringValue);
      }
    }

    /*
     Copyright (c) 2022 Gildas Lormeau. All rights reserved.

     Redistribution and use in source and binary forms, with or without
     modification, are permitted provided that the following conditions are met:

     1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright 
     notice, this list of conditions and the following disclaimer in 
     the documentation and/or other materials provided with the distribution.

     3. The names of the authors may not be used to endorse or promote products
     derived from this software without specific prior written permission.

     THIS SOFTWARE IS PROVIDED ''AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
     INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
     FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JCRAFT,
     INC. OR ANY CONTRIBUTORS TO THIS SOFTWARE BE LIABLE FOR ANY DIRECT, INDIRECT,
     INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
     LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
     OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
     LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
     NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
     EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     */

    function decodeText(value, encoding) {
      if (encoding && encoding.trim().toLowerCase() == "cp437") {
        return decodeCP437(value);
      } else {
        return new TextDecoder(encoding).decode(value);
      }
    }

    /*
     Copyright (c) 2022 Gildas Lormeau. All rights reserved.

     Redistribution and use in source and binary forms, with or without
     modification, are permitted provided that the following conditions are met:

     1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright 
     notice, this list of conditions and the following disclaimer in 
     the documentation and/or other materials provided with the distribution.

     3. The names of the authors may not be used to endorse or promote products
     derived from this software without specific prior written permission.

     THIS SOFTWARE IS PROVIDED ''AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
     INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
     FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JCRAFT,
     INC. OR ANY CONTRIBUTORS TO THIS SOFTWARE BE LIABLE FOR ANY DIRECT, INDIRECT,
     INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
     LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
     OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
     LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
     NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
     EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     */

    const PROPERTY_NAME_FILENAME = "filename";
    const PROPERTY_NAME_RAW_FILENAME = "rawFilename";
    const PROPERTY_NAME_COMMENT = "comment";
    const PROPERTY_NAME_RAW_COMMENT = "rawComment";
    const PROPERTY_NAME_UNCOMPPRESSED_SIZE = "uncompressedSize";
    const PROPERTY_NAME_COMPPRESSED_SIZE = "compressedSize";
    const PROPERTY_NAME_OFFSET = "offset";
    const PROPERTY_NAME_DISK_NUMBER_START = "diskNumberStart";
    const PROPERTY_NAME_LAST_MODIFICATION_DATE = "lastModDate";
    const PROPERTY_NAME_RAW_LAST_MODIFICATION_DATE = "rawLastModDate";
    const PROPERTY_NAME_LAST_ACCESS_DATE = "lastAccessDate";
    const PROPERTY_NAME_RAW_LAST_ACCESS_DATE = "rawLastAccessDate";
    const PROPERTY_NAME_CREATION_DATE = "creationDate";
    const PROPERTY_NAME_RAW_CREATION_DATE = "rawCreationDate";
    const PROPERTY_NAME_INTERNAL_FILE_ATTRIBUTE = "internalFileAttribute";
    const PROPERTY_NAME_INTERNAL_FILE_ATTRIBUTES = "internalFileAttributes";
    const PROPERTY_NAME_EXTERNAL_FILE_ATTRIBUTE = "externalFileAttribute";
    const PROPERTY_NAME_EXTERNAL_FILE_ATTRIBUTES = "externalFileAttributes";
    const PROPERTY_NAME_MS_DOS_COMPATIBLE = "msDosCompatible";
    const PROPERTY_NAME_ZIP64 = "zip64";
    const PROPERTY_NAME_ENCRYPTED = "encrypted";
    const PROPERTY_NAME_VERSION = "version";
    const PROPERTY_NAME_VERSION_MADE_BY = "versionMadeBy";
    const PROPERTY_NAME_ZIPCRYPTO = "zipCrypto";
    const PROPERTY_NAME_DIRECTORY = "directory";
    const PROPERTY_NAME_EXECUTABLE = "executable";
    const PROPERTY_NAMES = [PROPERTY_NAME_FILENAME, PROPERTY_NAME_RAW_FILENAME, PROPERTY_NAME_COMPPRESSED_SIZE, PROPERTY_NAME_UNCOMPPRESSED_SIZE, PROPERTY_NAME_LAST_MODIFICATION_DATE, PROPERTY_NAME_RAW_LAST_MODIFICATION_DATE, PROPERTY_NAME_COMMENT, PROPERTY_NAME_RAW_COMMENT, PROPERTY_NAME_LAST_ACCESS_DATE, PROPERTY_NAME_CREATION_DATE, PROPERTY_NAME_OFFSET, PROPERTY_NAME_DISK_NUMBER_START, PROPERTY_NAME_DISK_NUMBER_START, PROPERTY_NAME_INTERNAL_FILE_ATTRIBUTE, PROPERTY_NAME_INTERNAL_FILE_ATTRIBUTES, PROPERTY_NAME_EXTERNAL_FILE_ATTRIBUTE, PROPERTY_NAME_EXTERNAL_FILE_ATTRIBUTES, PROPERTY_NAME_MS_DOS_COMPATIBLE, PROPERTY_NAME_ZIP64, PROPERTY_NAME_ENCRYPTED, PROPERTY_NAME_VERSION, PROPERTY_NAME_VERSION_MADE_BY, PROPERTY_NAME_ZIPCRYPTO, PROPERTY_NAME_DIRECTORY, PROPERTY_NAME_EXECUTABLE, "bitFlag", "signature", "filenameUTF8", "commentUTF8", "compressionMethod", "extraField", "rawExtraField", "extraFieldZip64", "extraFieldUnicodePath", "extraFieldUnicodeComment", "extraFieldAES", "extraFieldNTFS", "extraFieldExtendedTimestamp"];
    class Entry {
      constructor(data) {
        PROPERTY_NAMES.forEach(name => this[name] = data[name]);
      }
    }

    /*
     Copyright (c) 2022 Gildas Lormeau. All rights reserved.

     Redistribution and use in source and binary forms, with or without
     modification, are permitted provided that the following conditions are met:

     1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in
     the documentation and/or other materials provided with the distribution.

     3. The names of the authors may not be used to endorse or promote products
     derived from this software without specific prior written permission.

     THIS SOFTWARE IS PROVIDED ''AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
     INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
     FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JCRAFT,
     INC. OR ANY CONTRIBUTORS TO THIS SOFTWARE BE LIABLE FOR ANY DIRECT, INDIRECT,
     INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
     LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
     OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
     LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
     NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
     EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     */

    const ERR_BAD_FORMAT = "File format is not recognized";
    const ERR_EOCDR_NOT_FOUND = "End of central directory not found";
    const ERR_EOCDR_LOCATOR_ZIP64_NOT_FOUND = "End of Zip64 central directory locator not found";
    const ERR_CENTRAL_DIRECTORY_NOT_FOUND = "Central directory header not found";
    const ERR_LOCAL_FILE_HEADER_NOT_FOUND = "Local file header not found";
    const ERR_EXTRAFIELD_ZIP64_NOT_FOUND = "Zip64 extra field not found";
    const ERR_ENCRYPTED = "File contains encrypted entry";
    const ERR_UNSUPPORTED_ENCRYPTION = "Encryption method not supported";
    const ERR_UNSUPPORTED_COMPRESSION = "Compression method not supported";
    const ERR_SPLIT_ZIP_FILE = "Split zip file";
    const CHARSET_UTF8 = "utf-8";
    const CHARSET_CP437 = "cp437";
    const ZIP64_PROPERTIES = [[PROPERTY_NAME_UNCOMPPRESSED_SIZE, MAX_32_BITS], [PROPERTY_NAME_COMPPRESSED_SIZE, MAX_32_BITS], [PROPERTY_NAME_OFFSET, MAX_32_BITS], [PROPERTY_NAME_DISK_NUMBER_START, MAX_16_BITS]];
    const ZIP64_EXTRACTION = {
      [MAX_16_BITS]: {
        getValue: getUint32,
        bytes: 4
      },
      [MAX_32_BITS]: {
        getValue: getBigUint64,
        bytes: 8
      }
    };
    class ZipReader {
      constructor(reader, options = {}) {
        Object.assign(this, {
          reader: new GenericReader(reader),
          options,
          config: getConfiguration()
        });
      }
      async *getEntriesGenerator(options = {}) {
        const zipReader = this;
        let {
          reader
        } = zipReader;
        const {
          config
        } = zipReader;
        await initStream(reader);
        if (reader.size === UNDEFINED_VALUE || !reader.readUint8Array) {
          reader = new BlobReader(await new Response(reader.readable).blob());
          await initStream(reader);
        }
        if (reader.size < END_OF_CENTRAL_DIR_LENGTH) {
          throw new Error(ERR_BAD_FORMAT);
        }
        reader.chunkSize = getChunkSize(config);
        const endOfDirectoryInfo = await seekSignature(reader, END_OF_CENTRAL_DIR_SIGNATURE, reader.size, END_OF_CENTRAL_DIR_LENGTH, MAX_16_BITS * 16);
        if (!endOfDirectoryInfo) {
          const signatureArray = await readUint8Array(reader, 0, 4);
          const signatureView = getDataView$1(signatureArray);
          if (getUint32(signatureView) == SPLIT_ZIP_FILE_SIGNATURE) {
            throw new Error(ERR_SPLIT_ZIP_FILE);
          } else {
            throw new Error(ERR_EOCDR_NOT_FOUND);
          }
        }
        const endOfDirectoryView = getDataView$1(endOfDirectoryInfo);
        let directoryDataLength = getUint32(endOfDirectoryView, 12);
        let directoryDataOffset = getUint32(endOfDirectoryView, 16);
        const commentOffset = endOfDirectoryInfo.offset;
        const commentLength = getUint16(endOfDirectoryView, 20);
        const appendedDataOffset = commentOffset + END_OF_CENTRAL_DIR_LENGTH + commentLength;
        let lastDiskNumber = getUint16(endOfDirectoryView, 4);
        const expectedLastDiskNumber = reader.lastDiskNumber || 0;
        let diskNumber = getUint16(endOfDirectoryView, 6);
        let filesLength = getUint16(endOfDirectoryView, 8);
        let prependedDataLength = 0;
        let startOffset = 0;
        if (directoryDataOffset == MAX_32_BITS || directoryDataLength == MAX_32_BITS || filesLength == MAX_16_BITS || diskNumber == MAX_16_BITS) {
          const endOfDirectoryLocatorArray = await readUint8Array(reader, endOfDirectoryInfo.offset - ZIP64_END_OF_CENTRAL_DIR_LOCATOR_LENGTH, ZIP64_END_OF_CENTRAL_DIR_LOCATOR_LENGTH);
          const endOfDirectoryLocatorView = getDataView$1(endOfDirectoryLocatorArray);
          if (getUint32(endOfDirectoryLocatorView, 0) == ZIP64_END_OF_CENTRAL_DIR_LOCATOR_SIGNATURE) {
            directoryDataOffset = getBigUint64(endOfDirectoryLocatorView, 8);
            let endOfDirectoryArray = await readUint8Array(reader, directoryDataOffset, ZIP64_END_OF_CENTRAL_DIR_LENGTH, -1);
            let endOfDirectoryView = getDataView$1(endOfDirectoryArray);
            const expectedDirectoryDataOffset = endOfDirectoryInfo.offset - ZIP64_END_OF_CENTRAL_DIR_LOCATOR_LENGTH - ZIP64_END_OF_CENTRAL_DIR_LENGTH;
            if (getUint32(endOfDirectoryView, 0) != ZIP64_END_OF_CENTRAL_DIR_SIGNATURE && directoryDataOffset != expectedDirectoryDataOffset) {
              const originalDirectoryDataOffset = directoryDataOffset;
              directoryDataOffset = expectedDirectoryDataOffset;
              prependedDataLength = directoryDataOffset - originalDirectoryDataOffset;
              endOfDirectoryArray = await readUint8Array(reader, directoryDataOffset, ZIP64_END_OF_CENTRAL_DIR_LENGTH, -1);
              endOfDirectoryView = getDataView$1(endOfDirectoryArray);
            }
            if (getUint32(endOfDirectoryView, 0) != ZIP64_END_OF_CENTRAL_DIR_SIGNATURE) {
              throw new Error(ERR_EOCDR_LOCATOR_ZIP64_NOT_FOUND);
            }
            if (lastDiskNumber == MAX_16_BITS) {
              lastDiskNumber = getUint32(endOfDirectoryView, 16);
            }
            if (diskNumber == MAX_16_BITS) {
              diskNumber = getUint32(endOfDirectoryView, 20);
            }
            if (filesLength == MAX_16_BITS) {
              filesLength = getBigUint64(endOfDirectoryView, 32);
            }
            if (directoryDataLength == MAX_32_BITS) {
              directoryDataLength = getBigUint64(endOfDirectoryView, 40);
            }
            directoryDataOffset -= directoryDataLength;
          }
        }
        if (directoryDataOffset >= reader.size) {
          prependedDataLength = reader.size - directoryDataOffset - directoryDataLength - END_OF_CENTRAL_DIR_LENGTH;
          directoryDataOffset = reader.size - directoryDataLength - END_OF_CENTRAL_DIR_LENGTH;
        }
        if (expectedLastDiskNumber != lastDiskNumber) {
          throw new Error(ERR_SPLIT_ZIP_FILE);
        }
        if (directoryDataOffset < 0) {
          throw new Error(ERR_BAD_FORMAT);
        }
        let offset = 0;
        let directoryArray = await readUint8Array(reader, directoryDataOffset, directoryDataLength, diskNumber);
        let directoryView = getDataView$1(directoryArray);
        if (directoryDataLength) {
          const expectedDirectoryDataOffset = endOfDirectoryInfo.offset - directoryDataLength;
          if (getUint32(directoryView, offset) != CENTRAL_FILE_HEADER_SIGNATURE && directoryDataOffset != expectedDirectoryDataOffset) {
            const originalDirectoryDataOffset = directoryDataOffset;
            directoryDataOffset = expectedDirectoryDataOffset;
            prependedDataLength += directoryDataOffset - originalDirectoryDataOffset;
            directoryArray = await readUint8Array(reader, directoryDataOffset, directoryDataLength, diskNumber);
            directoryView = getDataView$1(directoryArray);
          }
        }
        const expectedDirectoryDataLength = endOfDirectoryInfo.offset - directoryDataOffset - (reader.lastDiskOffset || 0);
        if (directoryDataLength != expectedDirectoryDataLength && expectedDirectoryDataLength >= 0) {
          directoryDataLength = expectedDirectoryDataLength;
          directoryArray = await readUint8Array(reader, directoryDataOffset, directoryDataLength, diskNumber);
          directoryView = getDataView$1(directoryArray);
        }
        if (directoryDataOffset < 0 || directoryDataOffset >= reader.size) {
          throw new Error(ERR_BAD_FORMAT);
        }
        const filenameEncoding = getOptionValue$1(zipReader, options, "filenameEncoding");
        const commentEncoding = getOptionValue$1(zipReader, options, "commentEncoding");
        for (let indexFile = 0; indexFile < filesLength; indexFile++) {
          const fileEntry = new ZipEntry(reader, config, zipReader.options);
          if (getUint32(directoryView, offset) != CENTRAL_FILE_HEADER_SIGNATURE) {
            throw new Error(ERR_CENTRAL_DIRECTORY_NOT_FOUND);
          }
          readCommonHeader(fileEntry, directoryView, offset + 6);
          const languageEncodingFlag = Boolean(fileEntry.bitFlag.languageEncodingFlag);
          const filenameOffset = offset + 46;
          const extraFieldOffset = filenameOffset + fileEntry.filenameLength;
          const commentOffset = extraFieldOffset + fileEntry.extraFieldLength;
          const versionMadeBy = getUint16(directoryView, offset + 4);
          const msDosCompatible = versionMadeBy >> 8 == 0;
          const unixCompatible = versionMadeBy >> 8 == 3;
          const rawFilename = directoryArray.subarray(filenameOffset, extraFieldOffset);
          const commentLength = getUint16(directoryView, offset + 32);
          const endOffset = commentOffset + commentLength;
          const rawComment = directoryArray.subarray(commentOffset, endOffset);
          const filenameUTF8 = languageEncodingFlag;
          const commentUTF8 = languageEncodingFlag;
          const externalFileAttributes = getUint32(directoryView, offset + 38);
          const directory = msDosCompatible && (getUint8(directoryView, offset + 38) & FILE_ATTR_MSDOS_DIR_MASK) == FILE_ATTR_MSDOS_DIR_MASK || unixCompatible && (externalFileAttributes >> 16 & FILE_ATTR_UNIX_TYPE_MASK) == FILE_ATTR_UNIX_TYPE_DIR || rawFilename.length && rawFilename[rawFilename.length - 1] == DIRECTORY_SIGNATURE.charCodeAt(0);
          const executable = unixCompatible && (externalFileAttributes >> 16 & FILE_ATTR_UNIX_EXECUTABLE_MASK) != 0;
          const offsetFileEntry = getUint32(directoryView, offset + 42) + prependedDataLength;
          Object.assign(fileEntry, {
            versionMadeBy,
            msDosCompatible,
            compressedSize: 0,
            uncompressedSize: 0,
            commentLength,
            directory,
            offset: offsetFileEntry,
            diskNumberStart: getUint16(directoryView, offset + 34),
            internalFileAttributes: getUint16(directoryView, offset + 36),
            externalFileAttributes,
            rawFilename,
            filenameUTF8,
            commentUTF8,
            rawExtraField: directoryArray.subarray(extraFieldOffset, commentOffset),
            executable
          });
          fileEntry.internalFileAttribute = fileEntry.internalFileAttributes;
          fileEntry.externalFileAttribute = fileEntry.externalFileAttributes;
          const decode = getOptionValue$1(zipReader, options, "decodeText") || decodeText;
          const rawFilenameEncoding = filenameUTF8 ? CHARSET_UTF8 : filenameEncoding || CHARSET_CP437;
          const rawCommentEncoding = commentUTF8 ? CHARSET_UTF8 : commentEncoding || CHARSET_CP437;
          let filename = decode(rawFilename, rawFilenameEncoding);
          if (filename === UNDEFINED_VALUE) {
            filename = decodeText(rawFilename, rawFilenameEncoding);
          }
          let comment = decode(rawComment, rawCommentEncoding);
          if (comment === UNDEFINED_VALUE) {
            comment = decodeText(rawComment, rawCommentEncoding);
          }
          Object.assign(fileEntry, {
            rawComment,
            filename,
            comment,
            directory: directory || filename.endsWith(DIRECTORY_SIGNATURE)
          });
          startOffset = Math.max(offsetFileEntry, startOffset);
          readCommonFooter(fileEntry, fileEntry, directoryView, offset + 6);
          fileEntry.zipCrypto = fileEntry.encrypted && !fileEntry.extraFieldAES;
          const entry = new Entry(fileEntry);
          entry.getData = (writer, options) => fileEntry.getData(writer, entry, options);
          entry.arrayBuffer = async options => {
            const writer = new TransformStream();
            const [arrayBuffer] = await Promise.all([new Response(writer.readable).arrayBuffer(), fileEntry.getData(writer, entry, options)]);
            return arrayBuffer;
          };
          offset = endOffset;
          const {
            onprogress
          } = options;
          if (onprogress) {
            try {
              await onprogress(indexFile + 1, filesLength, new Entry(fileEntry));
              // eslint-disable-next-line no-unused-vars
            } catch (_) {
              // ignored
            }
          }
          yield entry;
        }
        const extractPrependedData = getOptionValue$1(zipReader, options, "extractPrependedData");
        const extractAppendedData = getOptionValue$1(zipReader, options, "extractAppendedData");
        if (extractPrependedData) {
          zipReader.prependedData = startOffset > 0 ? await readUint8Array(reader, 0, startOffset) : new Uint8Array();
        }
        zipReader.comment = commentLength ? await readUint8Array(reader, commentOffset + END_OF_CENTRAL_DIR_LENGTH, commentLength) : new Uint8Array();
        if (extractAppendedData) {
          zipReader.appendedData = appendedDataOffset < reader.size ? await readUint8Array(reader, appendedDataOffset, reader.size - appendedDataOffset) : new Uint8Array();
        }
        return true;
      }
      async getEntries(options = {}) {
        const entries = [];
        for await (const entry of this.getEntriesGenerator(options)) {
          entries.push(entry);
        }
        return entries;
      }
      async close() {}
    }
    class ZipEntry {
      constructor(reader, config, options) {
        Object.assign(this, {
          reader,
          config,
          options
        });
      }
      async getData(writer, fileEntry, options = {}) {
        const zipEntry = this;
        const {
          reader,
          offset,
          diskNumberStart,
          extraFieldAES,
          compressionMethod,
          config,
          bitFlag,
          signature,
          rawLastModDate,
          uncompressedSize,
          compressedSize
        } = zipEntry;
        const localDirectory = fileEntry.localDirectory = {};
        const dataArraySize = HEADER_SIZE + 4;
        const dataArray = await readUint8Array(reader, offset, dataArraySize + 4, diskNumberStart);
        const dataView = getDataView$1(dataArray);
        let password = getOptionValue$1(zipEntry, options, "password");
        let rawPassword = getOptionValue$1(zipEntry, options, "rawPassword");
        const passThrough = getOptionValue$1(zipEntry, options, "passThrough");
        password = password && password.length && password;
        rawPassword = rawPassword && rawPassword.length && rawPassword;
        if (extraFieldAES) {
          if (extraFieldAES.originalCompressionMethod != COMPRESSION_METHOD_AES) {
            throw new Error(ERR_UNSUPPORTED_COMPRESSION);
          }
        }
        if (compressionMethod != COMPRESSION_METHOD_STORE && compressionMethod != COMPRESSION_METHOD_DEFLATE && !passThrough) {
          throw new Error(ERR_UNSUPPORTED_COMPRESSION);
        }
        if (getUint32(dataView, 0) != LOCAL_FILE_HEADER_SIGNATURE) {
          throw new Error(ERR_LOCAL_FILE_HEADER_NOT_FOUND);
        }
        readCommonHeader(localDirectory, dataView, 4);
        localDirectory.rawExtraField = localDirectory.extraFieldLength ? await readUint8Array(reader, offset + dataArraySize + localDirectory.filenameLength, localDirectory.extraFieldLength, diskNumberStart) : new Uint8Array();
        readCommonFooter(zipEntry, localDirectory, dataView, 4, true);
        Object.assign(fileEntry, {
          lastAccessDate: localDirectory.lastAccessDate,
          creationDate: localDirectory.creationDate
        });
        const encrypted = zipEntry.encrypted && localDirectory.encrypted && !passThrough;
        const zipCrypto = encrypted && !extraFieldAES;
        if (!passThrough) {
          fileEntry.zipCrypto = zipCrypto;
        }
        if (encrypted) {
          if (!zipCrypto && extraFieldAES.strength === UNDEFINED_VALUE) {
            throw new Error(ERR_UNSUPPORTED_ENCRYPTION);
          } else if (!password && !rawPassword) {
            throw new Error(ERR_ENCRYPTED);
          }
        }
        const dataOffset = offset + dataArraySize + localDirectory.filenameLength + localDirectory.extraFieldLength;
        const size = compressedSize;
        const readable = reader.readable;
        Object.assign(readable, {
          diskNumberStart,
          offset: dataOffset,
          size
        });
        const signal = getOptionValue$1(zipEntry, options, "signal");
        const checkPasswordOnly = getOptionValue$1(zipEntry, options, "checkPasswordOnly");
        if (checkPasswordOnly) {
          writer = new WritableStream();
        }
        writer = new GenericWriter(writer);
        await initStream(writer, passThrough ? compressedSize : uncompressedSize);
        const {
          writable
        } = writer;
        const {
          onstart,
          onprogress,
          onend
        } = options;
        const workerOptions = {
          options: {
            codecType: CODEC_INFLATE,
            password,
            rawPassword,
            zipCrypto,
            encryptionStrength: extraFieldAES && extraFieldAES.strength,
            signed: getOptionValue$1(zipEntry, options, "checkSignature") && !passThrough,
            passwordVerification: zipCrypto && (bitFlag.dataDescriptor ? rawLastModDate >>> 8 & 0xFF : signature >>> 24 & 0xFF),
            signature,
            compressed: compressionMethod != 0 && !passThrough,
            encrypted: zipEntry.encrypted && !passThrough,
            useWebWorkers: getOptionValue$1(zipEntry, options, "useWebWorkers"),
            useCompressionStream: getOptionValue$1(zipEntry, options, "useCompressionStream"),
            transferStreams: getOptionValue$1(zipEntry, options, "transferStreams"),
            checkPasswordOnly
          },
          config,
          streamOptions: {
            signal,
            size,
            onstart,
            onprogress,
            onend
          }
        };
        try {
          const {
            outputSize
          } = await runWorker({
            readable,
            writable
          }, workerOptions);
          writer.size += outputSize;
        } catch (error) {
          if (error.outputSize !== UNDEFINED_VALUE) {
            writer.size += error.outputSize;
          }
          if (!checkPasswordOnly || error.message != ERR_ABORT_CHECK_PASSWORD) {
            throw error;
          }
        } finally {
          const preventClose = getOptionValue$1(zipEntry, options, "preventClose");
          if (!preventClose && !writable.locked) {
            await writable.getWriter().close();
          }
        }
        return checkPasswordOnly ? UNDEFINED_VALUE : writer.getData ? writer.getData() : writable;
      }
    }
    function readCommonHeader(directory, dataView, offset) {
      const rawBitFlag = directory.rawBitFlag = getUint16(dataView, offset + 2);
      const encrypted = (rawBitFlag & BITFLAG_ENCRYPTED) == BITFLAG_ENCRYPTED;
      const rawLastModDate = getUint32(dataView, offset + 6);
      Object.assign(directory, {
        encrypted,
        version: getUint16(dataView, offset),
        bitFlag: {
          level: (rawBitFlag & BITFLAG_LEVEL) >> 1,
          dataDescriptor: (rawBitFlag & BITFLAG_DATA_DESCRIPTOR) == BITFLAG_DATA_DESCRIPTOR,
          languageEncodingFlag: (rawBitFlag & BITFLAG_LANG_ENCODING_FLAG) == BITFLAG_LANG_ENCODING_FLAG
        },
        rawLastModDate,
        lastModDate: getDate(rawLastModDate),
        filenameLength: getUint16(dataView, offset + 22),
        extraFieldLength: getUint16(dataView, offset + 24)
      });
    }
    function readCommonFooter(fileEntry, directory, dataView, offset, localDirectory) {
      const {
        rawExtraField
      } = directory;
      const extraField = directory.extraField = new Map();
      const rawExtraFieldView = getDataView$1(new Uint8Array(rawExtraField));
      let offsetExtraField = 0;
      try {
        while (offsetExtraField < rawExtraField.length) {
          const type = getUint16(rawExtraFieldView, offsetExtraField);
          const size = getUint16(rawExtraFieldView, offsetExtraField + 2);
          extraField.set(type, {
            type,
            data: rawExtraField.slice(offsetExtraField + 4, offsetExtraField + 4 + size)
          });
          offsetExtraField += 4 + size;
        }
        // eslint-disable-next-line no-unused-vars
      } catch (_) {
        // ignored
      }
      const compressionMethod = getUint16(dataView, offset + 4);
      Object.assign(directory, {
        signature: getUint32(dataView, offset + HEADER_OFFSET_SIGNATURE),
        compressedSize: getUint32(dataView, offset + HEADER_OFFSET_COMPRESSED_SIZE),
        uncompressedSize: getUint32(dataView, offset + HEADER_OFFSET_UNCOMPRESSED_SIZE)
      });
      const extraFieldZip64 = extraField.get(EXTRAFIELD_TYPE_ZIP64);
      if (extraFieldZip64) {
        readExtraFieldZip64(extraFieldZip64, directory);
        directory.extraFieldZip64 = extraFieldZip64;
      }
      const extraFieldUnicodePath = extraField.get(EXTRAFIELD_TYPE_UNICODE_PATH);
      if (extraFieldUnicodePath) {
        readExtraFieldUnicode(extraFieldUnicodePath, PROPERTY_NAME_FILENAME, PROPERTY_NAME_RAW_FILENAME, directory, fileEntry);
        directory.extraFieldUnicodePath = extraFieldUnicodePath;
      }
      const extraFieldUnicodeComment = extraField.get(EXTRAFIELD_TYPE_UNICODE_COMMENT);
      if (extraFieldUnicodeComment) {
        readExtraFieldUnicode(extraFieldUnicodeComment, PROPERTY_NAME_COMMENT, PROPERTY_NAME_RAW_COMMENT, directory, fileEntry);
        directory.extraFieldUnicodeComment = extraFieldUnicodeComment;
      }
      const extraFieldAES = extraField.get(EXTRAFIELD_TYPE_AES);
      if (extraFieldAES) {
        readExtraFieldAES(extraFieldAES, directory, compressionMethod);
        directory.extraFieldAES = extraFieldAES;
      } else {
        directory.compressionMethod = compressionMethod;
      }
      const extraFieldNTFS = extraField.get(EXTRAFIELD_TYPE_NTFS);
      if (extraFieldNTFS) {
        readExtraFieldNTFS(extraFieldNTFS, directory);
        directory.extraFieldNTFS = extraFieldNTFS;
      }
      const extraFieldExtendedTimestamp = extraField.get(EXTRAFIELD_TYPE_EXTENDED_TIMESTAMP);
      if (extraFieldExtendedTimestamp) {
        readExtraFieldExtendedTimestamp(extraFieldExtendedTimestamp, directory, localDirectory);
        directory.extraFieldExtendedTimestamp = extraFieldExtendedTimestamp;
      }
      const extraFieldUSDZ = extraField.get(EXTRAFIELD_TYPE_USDZ);
      if (extraFieldUSDZ) {
        directory.extraFieldUSDZ = extraFieldUSDZ;
      }
    }
    function readExtraFieldZip64(extraFieldZip64, directory) {
      directory.zip64 = true;
      const extraFieldView = getDataView$1(extraFieldZip64.data);
      const missingProperties = ZIP64_PROPERTIES.filter(([propertyName, max]) => directory[propertyName] == max);
      for (let indexMissingProperty = 0, offset = 0; indexMissingProperty < missingProperties.length; indexMissingProperty++) {
        const [propertyName, max] = missingProperties[indexMissingProperty];
        if (directory[propertyName] == max) {
          const extraction = ZIP64_EXTRACTION[max];
          directory[propertyName] = extraFieldZip64[propertyName] = extraction.getValue(extraFieldView, offset);
          offset += extraction.bytes;
        } else if (extraFieldZip64[propertyName]) {
          throw new Error(ERR_EXTRAFIELD_ZIP64_NOT_FOUND);
        }
      }
    }
    function readExtraFieldUnicode(extraFieldUnicode, propertyName, rawPropertyName, directory, fileEntry) {
      const extraFieldView = getDataView$1(extraFieldUnicode.data);
      const crc32 = new Crc32();
      crc32.append(fileEntry[rawPropertyName]);
      const dataViewSignature = getDataView$1(new Uint8Array(4));
      dataViewSignature.setUint32(0, crc32.get(), true);
      const signature = getUint32(extraFieldView, 1);
      Object.assign(extraFieldUnicode, {
        version: getUint8(extraFieldView, 0),
        [propertyName]: decodeText(extraFieldUnicode.data.subarray(5)),
        valid: !fileEntry.bitFlag.languageEncodingFlag && signature == getUint32(dataViewSignature, 0)
      });
      if (extraFieldUnicode.valid) {
        directory[propertyName] = extraFieldUnicode[propertyName];
        directory[propertyName + "UTF8"] = true;
      }
    }
    function readExtraFieldAES(extraFieldAES, directory, compressionMethod) {
      const extraFieldView = getDataView$1(extraFieldAES.data);
      const strength = getUint8(extraFieldView, 4);
      Object.assign(extraFieldAES, {
        vendorVersion: getUint8(extraFieldView, 0),
        vendorId: getUint8(extraFieldView, 2),
        strength,
        originalCompressionMethod: compressionMethod,
        compressionMethod: getUint16(extraFieldView, 5)
      });
      directory.compressionMethod = extraFieldAES.compressionMethod;
    }
    function readExtraFieldNTFS(extraFieldNTFS, directory) {
      const extraFieldView = getDataView$1(extraFieldNTFS.data);
      let offsetExtraField = 4;
      let tag1Data;
      try {
        while (offsetExtraField < extraFieldNTFS.data.length && !tag1Data) {
          const tagValue = getUint16(extraFieldView, offsetExtraField);
          const attributeSize = getUint16(extraFieldView, offsetExtraField + 2);
          if (tagValue == EXTRAFIELD_TYPE_NTFS_TAG1) {
            tag1Data = extraFieldNTFS.data.slice(offsetExtraField + 4, offsetExtraField + 4 + attributeSize);
          }
          offsetExtraField += 4 + attributeSize;
        }
        // eslint-disable-next-line no-unused-vars
      } catch (_) {
        // ignored
      }
      try {
        if (tag1Data && tag1Data.length == 24) {
          const tag1View = getDataView$1(tag1Data);
          const rawLastModDate = tag1View.getBigUint64(0, true);
          const rawLastAccessDate = tag1View.getBigUint64(8, true);
          const rawCreationDate = tag1View.getBigUint64(16, true);
          Object.assign(extraFieldNTFS, {
            rawLastModDate,
            rawLastAccessDate,
            rawCreationDate
          });
          const lastModDate = getDateNTFS(rawLastModDate);
          const lastAccessDate = getDateNTFS(rawLastAccessDate);
          const creationDate = getDateNTFS(rawCreationDate);
          const extraFieldData = {
            lastModDate,
            lastAccessDate,
            creationDate
          };
          Object.assign(extraFieldNTFS, extraFieldData);
          Object.assign(directory, extraFieldData);
        }
        // eslint-disable-next-line no-unused-vars
      } catch (_) {
        // ignored
      }
    }
    function readExtraFieldExtendedTimestamp(extraFieldExtendedTimestamp, directory, localDirectory) {
      const extraFieldView = getDataView$1(extraFieldExtendedTimestamp.data);
      const flags = getUint8(extraFieldView, 0);
      const timeProperties = [];
      const timeRawProperties = [];
      if (localDirectory) {
        if ((flags & 0x1) == 0x1) {
          timeProperties.push(PROPERTY_NAME_LAST_MODIFICATION_DATE);
          timeRawProperties.push(PROPERTY_NAME_RAW_LAST_MODIFICATION_DATE);
        }
        if ((flags & 0x2) == 0x2) {
          timeProperties.push(PROPERTY_NAME_LAST_ACCESS_DATE);
          timeRawProperties.push(PROPERTY_NAME_RAW_LAST_ACCESS_DATE);
        }
        if ((flags & 0x4) == 0x4) {
          timeProperties.push(PROPERTY_NAME_CREATION_DATE);
          timeRawProperties.push(PROPERTY_NAME_RAW_CREATION_DATE);
        }
      } else if (extraFieldExtendedTimestamp.data.length >= 5) {
        timeProperties.push(PROPERTY_NAME_LAST_MODIFICATION_DATE);
        timeRawProperties.push(PROPERTY_NAME_RAW_LAST_MODIFICATION_DATE);
      }
      let offset = 1;
      timeProperties.forEach((propertyName, indexProperty) => {
        if (extraFieldExtendedTimestamp.data.length >= offset + 4) {
          const time = getUint32(extraFieldView, offset);
          directory[propertyName] = extraFieldExtendedTimestamp[propertyName] = new Date(time * 1000);
          const rawPropertyName = timeRawProperties[indexProperty];
          extraFieldExtendedTimestamp[rawPropertyName] = time;
        }
        offset += 4;
      });
    }
    async function seekSignature(reader, signature, startOffset, minimumBytes, maximumLength) {
      const signatureArray = new Uint8Array(4);
      const signatureView = getDataView$1(signatureArray);
      setUint32$1(signatureView, 0, signature);
      const maximumBytes = minimumBytes + maximumLength;
      return (await seek(minimumBytes)) || (await seek(Math.min(maximumBytes, startOffset)));
      async function seek(length) {
        const offset = startOffset - length;
        const bytes = await readUint8Array(reader, offset, length);
        for (let indexByte = bytes.length - minimumBytes; indexByte >= 0; indexByte--) {
          if (bytes[indexByte] == signatureArray[0] && bytes[indexByte + 1] == signatureArray[1] && bytes[indexByte + 2] == signatureArray[2] && bytes[indexByte + 3] == signatureArray[3]) {
            return {
              offset: offset + indexByte,
              buffer: bytes.slice(indexByte, indexByte + minimumBytes).buffer
            };
          }
        }
      }
    }
    function getOptionValue$1(zipReader, options, name) {
      return options[name] === UNDEFINED_VALUE ? zipReader.options[name] : options[name];
    }
    function getDate(timeRaw) {
      const date = (timeRaw & 0xffff0000) >> 16,
        time = timeRaw & 0x0000ffff;
      try {
        return new Date(1980 + ((date & 0xFE00) >> 9), ((date & 0x01E0) >> 5) - 1, date & 0x001F, (time & 0xF800) >> 11, (time & 0x07E0) >> 5, (time & 0x001F) * 2, 0);
        // eslint-disable-next-line no-unused-vars
      } catch (_) {
        // ignored
      }
    }
    function getDateNTFS(timeRaw) {
      return new Date(Number(timeRaw / BigInt(10000) - BigInt(11644473600000)));
    }
    function getUint8(view, offset) {
      return view.getUint8(offset);
    }
    function getUint16(view, offset) {
      return view.getUint16(offset, true);
    }
    function getUint32(view, offset) {
      return view.getUint32(offset, true);
    }
    function getBigUint64(view, offset) {
      return Number(view.getBigUint64(offset, true));
    }
    function setUint32$1(view, offset, value) {
      view.setUint32(offset, value, true);
    }
    function getDataView$1(array) {
      return new DataView(array.buffer);
    }

    /*
     Copyright (c) 2022 Gildas Lormeau. All rights reserved.

     Redistribution and use in source and binary forms, with or without
     modification, are permitted provided that the following conditions are met:

     1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in
     the documentation and/or other materials provided with the distribution.

     3. The names of the authors may not be used to endorse or promote products
     derived from this software without specific prior written permission.

     THIS SOFTWARE IS PROVIDED ''AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
     INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
     FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JCRAFT,
     INC. OR ANY CONTRIBUTORS TO THIS SOFTWARE BE LIABLE FOR ANY DIRECT, INDIRECT,
     INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
     LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
     OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
     LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
     NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
     EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     */

    const ERR_DUPLICATED_NAME = "File already exists";
    const ERR_INVALID_COMMENT = "Zip file comment exceeds 64KB";
    const ERR_INVALID_ENTRY_COMMENT = "File entry comment exceeds 64KB";
    const ERR_INVALID_ENTRY_NAME = "File entry name exceeds 64KB";
    const ERR_INVALID_VERSION = "Version exceeds 65535";
    const ERR_INVALID_ENCRYPTION_STRENGTH = "The strength must equal 1, 2, or 3";
    const ERR_INVALID_EXTRAFIELD_TYPE = "Extra field type exceeds 65535";
    const ERR_INVALID_EXTRAFIELD_DATA = "Extra field data exceeds 64KB";
    const ERR_UNSUPPORTED_FORMAT = "Zip64 is not supported (make sure 'keepOrder' is set to 'true')";
    const ERR_UNDEFINED_UNCOMPRESSED_SIZE = "Undefined uncompressed size";
    const ERR_ZIP_NOT_EMPTY = "Zip file not empty";
    const EXTRAFIELD_DATA_AES = new Uint8Array([0x07, 0x00, 0x02, 0x00, 0x41, 0x45, 0x03, 0x00, 0x00]);
    let workers = 0;
    const pendingEntries = [];
    class ZipWriter {
      constructor(writer, options = {}) {
        writer = new GenericWriter(writer);
        const addSplitZipSignature = writer.availableSize !== UNDEFINED_VALUE && writer.availableSize > 0 && writer.availableSize !== Infinity && writer.maxSize !== UNDEFINED_VALUE && writer.maxSize > 0 && writer.maxSize !== Infinity;
        Object.assign(this, {
          writer,
          addSplitZipSignature,
          options,
          config: getConfiguration(),
          files: new Map(),
          filenames: new Set(),
          offset: options.offset === UNDEFINED_VALUE ? writer.size || writer.writable.size || 0 : options.offset,
          pendingEntriesSize: 0,
          pendingAddFileCalls: new Set(),
          bufferedWrites: 0
        });
      }
      async prependZip(reader) {
        if (this.filenames.size) {
          throw new Error(ERR_ZIP_NOT_EMPTY);
        }
        reader = new GenericReader(reader);
        const zipReader = new ZipReader(reader.readable);
        const entries = await zipReader.getEntries();
        await zipReader.close();
        await reader.readable.pipeTo(this.writer.writable, {
          preventClose: true,
          preventAbort: true
        });
        this.writer.size = this.offset = reader.size;
        this.filenames = new Set(entries.map(entry => entry.filename));
        this.files = new Map(entries.map(entry => {
          const {
            version,
            compressionMethod,
            lastModDate,
            lastAccessDate,
            creationDate,
            rawFilename,
            bitFlag,
            encrypted,
            uncompressedSize,
            compressedSize,
            diskOffset,
            diskNumber,
            zip64
          } = entry;
          let {
            rawExtraFieldZip64,
            rawExtraFieldAES,
            rawExtraFieldExtendedTimestamp,
            rawExtraFieldNTFS,
            rawExtraField
          } = entry;
          const {
            level,
            languageEncodingFlag,
            dataDescriptor
          } = bitFlag;
          rawExtraFieldZip64 = rawExtraFieldZip64 || new Uint8Array();
          rawExtraFieldAES = rawExtraFieldAES || new Uint8Array();
          rawExtraFieldExtendedTimestamp = rawExtraFieldExtendedTimestamp || new Uint8Array();
          rawExtraFieldNTFS = rawExtraFieldNTFS || new Uint8Array();
          rawExtraField = rawExtraField || new Uint8Array();
          const extraFieldLength = getLength(rawExtraFieldZip64, rawExtraFieldAES, rawExtraFieldExtendedTimestamp, rawExtraFieldNTFS, rawExtraField);
          const zip64UncompressedSize = zip64 && uncompressedSize > MAX_32_BITS;
          const zip64CompressedSize = zip64 && compressedSize > MAX_32_BITS;
          const {
            headerArray,
            headerView
          } = getHeaderArrayData({
            version,
            bitFlag: getBitFlag(level, languageEncodingFlag, dataDescriptor, encrypted, compressionMethod),
            compressionMethod,
            uncompressedSize,
            compressedSize,
            lastModDate,
            rawFilename,
            zip64CompressedSize,
            zip64UncompressedSize,
            extraFieldLength
          });
          Object.assign(entry, {
            zip64UncompressedSize,
            zip64CompressedSize,
            zip64Offset: zip64 && this.offset - diskOffset > MAX_32_BITS,
            zip64DiskNumberStart: zip64 && diskNumber > MAX_16_BITS,
            rawExtraFieldZip64,
            rawExtraFieldAES,
            rawExtraFieldExtendedTimestamp,
            rawExtraFieldNTFS,
            rawExtraField,
            extendedTimestamp: rawExtraFieldExtendedTimestamp.length > 0 || rawExtraFieldNTFS.length > 0,
            extraFieldExtendedTimestampFlag: 0x1 + (lastAccessDate ? 0x2 : 0) + (creationDate ? 0x4 : 0),
            headerArray,
            headerView
          });
          return [entry.filename, entry];
        }));
      }
      async add(name = "", reader, options = {}) {
        const zipWriter = this;
        const {
          pendingAddFileCalls,
          config
        } = zipWriter;
        if (workers < config.maxWorkers) {
          workers++;
        } else {
          await new Promise(resolve => pendingEntries.push(resolve));
        }
        let promiseAddFile;
        try {
          name = name.trim();
          if (zipWriter.filenames.has(name)) {
            throw new Error(ERR_DUPLICATED_NAME);
          }
          zipWriter.filenames.add(name);
          promiseAddFile = addFile(zipWriter, name, reader, options);
          pendingAddFileCalls.add(promiseAddFile);
          return await promiseAddFile;
        } catch (error) {
          zipWriter.filenames.delete(name);
          throw error;
        } finally {
          pendingAddFileCalls.delete(promiseAddFile);
          const pendingEntry = pendingEntries.shift();
          if (pendingEntry) {
            pendingEntry();
          } else {
            workers--;
          }
        }
      }
      remove(entry) {
        const {
          filenames,
          files
        } = this;
        if (typeof entry == "string") {
          entry = files.get(entry);
        }
        if (entry && entry.filename !== UNDEFINED_VALUE) {
          const {
            filename
          } = entry;
          if (filenames.has(filename) && files.has(filename)) {
            filenames.delete(filename);
            files.delete(filename);
            return true;
          }
        }
        return false;
      }
      async close(comment = new Uint8Array(), options = {}) {
        const zipWriter = this;
        const {
          pendingAddFileCalls,
          writer
        } = this;
        const {
          writable
        } = writer;
        while (pendingAddFileCalls.size) {
          await Promise.allSettled(Array.from(pendingAddFileCalls));
        }
        await closeFile(this, comment, options);
        const preventClose = getOptionValue(zipWriter, options, "preventClose");
        if (!preventClose) {
          await writable.getWriter().close();
        }
        return writer.getData ? writer.getData() : writable;
      }
    }
    async function addFile(zipWriter, name, reader, options) {
      name = name.trim();
      const msDosCompatible = getOptionValue(zipWriter, options, PROPERTY_NAME_MS_DOS_COMPATIBLE);
      const versionMadeBy = getOptionValue(zipWriter, options, PROPERTY_NAME_VERSION_MADE_BY, msDosCompatible ? 20 : 768);
      const executable = getOptionValue(zipWriter, options, PROPERTY_NAME_EXECUTABLE);
      if (versionMadeBy > MAX_16_BITS) {
        throw new Error(ERR_INVALID_VERSION);
      }
      let externalFileAttributes = getOptionValue(zipWriter, options, PROPERTY_NAME_EXTERNAL_FILE_ATTRIBUTES, 0);
      if (externalFileAttributes === 0) {
        externalFileAttributes = getOptionValue(zipWriter, options, PROPERTY_NAME_EXTERNAL_FILE_ATTRIBUTE, 0);
      }
      if (!options.directory && name.endsWith(DIRECTORY_SIGNATURE)) {
        options.directory = true;
      }
      const directory = getOptionValue(zipWriter, options, PROPERTY_NAME_DIRECTORY);
      if (directory) {
        if (!name.endsWith(DIRECTORY_SIGNATURE)) {
          name += DIRECTORY_SIGNATURE;
        }
        if (externalFileAttributes === 0) {
          externalFileAttributes = FILE_ATTR_MSDOS_DIR_MASK;
          if (!msDosCompatible) {
            externalFileAttributes |= (FILE_ATTR_UNIX_TYPE_DIR | FILE_ATTR_UNIX_EXECUTABLE_MASK | FILE_ATTR_UNIX_DEFAULT_MASK) << 16;
          }
        }
      } else if (!msDosCompatible && externalFileAttributes === 0) {
        if (executable) {
          externalFileAttributes = (FILE_ATTR_UNIX_EXECUTABLE_MASK | FILE_ATTR_UNIX_DEFAULT_MASK) << 16;
        } else {
          externalFileAttributes = FILE_ATTR_UNIX_DEFAULT_MASK << 16;
        }
      }
      const encode = getOptionValue(zipWriter, options, "encodeText", encodeText);
      let rawFilename = encode(name);
      if (rawFilename === UNDEFINED_VALUE) {
        rawFilename = encodeText(name);
      }
      if (getLength(rawFilename) > MAX_16_BITS) {
        throw new Error(ERR_INVALID_ENTRY_NAME);
      }
      const comment = options.comment || "";
      let rawComment = encode(comment);
      if (rawComment === UNDEFINED_VALUE) {
        rawComment = encodeText(comment);
      }
      if (getLength(rawComment) > MAX_16_BITS) {
        throw new Error(ERR_INVALID_ENTRY_COMMENT);
      }
      const version = getOptionValue(zipWriter, options, PROPERTY_NAME_VERSION, VERSION_DEFLATE);
      if (version > MAX_16_BITS) {
        throw new Error(ERR_INVALID_VERSION);
      }
      const lastModDate = getOptionValue(zipWriter, options, PROPERTY_NAME_LAST_MODIFICATION_DATE, new Date());
      const lastAccessDate = getOptionValue(zipWriter, options, PROPERTY_NAME_LAST_ACCESS_DATE);
      const creationDate = getOptionValue(zipWriter, options, PROPERTY_NAME_CREATION_DATE);
      let internalFileAttributes = getOptionValue(zipWriter, options, PROPERTY_NAME_INTERNAL_FILE_ATTRIBUTES, 0);
      if (internalFileAttributes === 0) {
        internalFileAttributes = getOptionValue(zipWriter, options, PROPERTY_NAME_INTERNAL_FILE_ATTRIBUTE, 0);
      }
      const passThrough = getOptionValue(zipWriter, options, "passThrough");
      let password, rawPassword;
      if (!passThrough) {
        password = getOptionValue(zipWriter, options, "password");
        rawPassword = getOptionValue(zipWriter, options, "rawPassword");
      }
      const encryptionStrength = getOptionValue(zipWriter, options, "encryptionStrength", 3);
      const zipCrypto = getOptionValue(zipWriter, options, PROPERTY_NAME_ZIPCRYPTO);
      const extendedTimestamp = getOptionValue(zipWriter, options, "extendedTimestamp", true);
      const keepOrder = getOptionValue(zipWriter, options, "keepOrder", true);
      const level = getOptionValue(zipWriter, options, "level");
      const useWebWorkers = getOptionValue(zipWriter, options, "useWebWorkers");
      const bufferedWrite = getOptionValue(zipWriter, options, "bufferedWrite");
      const dataDescriptorSignature = getOptionValue(zipWriter, options, "dataDescriptorSignature", false);
      const signal = getOptionValue(zipWriter, options, "signal");
      const useUnicodeFileNames = getOptionValue(zipWriter, options, "useUnicodeFileNames", true);
      const useCompressionStream = getOptionValue(zipWriter, options, "useCompressionStream");
      const compressionMethod = getOptionValue(zipWriter, options, "compressionMethod");
      let dataDescriptor = getOptionValue(zipWriter, options, "dataDescriptor");
      if (bufferedWrite && dataDescriptor === UNDEFINED_VALUE) {
        dataDescriptor = false;
      }
      if (dataDescriptor === UNDEFINED_VALUE || zipCrypto) {
        dataDescriptor = true;
      }
      let zip64 = getOptionValue(zipWriter, options, PROPERTY_NAME_ZIP64);
      if (!zipCrypto && (password !== UNDEFINED_VALUE || rawPassword !== UNDEFINED_VALUE) && !(encryptionStrength >= 1 && encryptionStrength <= 3)) {
        throw new Error(ERR_INVALID_ENCRYPTION_STRENGTH);
      }
      let rawExtraField = new Uint8Array();
      const {
        extraField
      } = options;
      if (extraField) {
        let extraFieldSize = 0;
        let offset = 0;
        extraField.forEach(data => extraFieldSize += 4 + getLength(data));
        rawExtraField = new Uint8Array(extraFieldSize);
        extraField.forEach((data, type) => {
          if (type > MAX_16_BITS) {
            throw new Error(ERR_INVALID_EXTRAFIELD_TYPE);
          }
          if (getLength(data) > MAX_16_BITS) {
            throw new Error(ERR_INVALID_EXTRAFIELD_DATA);
          }
          arraySet(rawExtraField, new Uint16Array([type]), offset);
          arraySet(rawExtraField, new Uint16Array([getLength(data)]), offset + 2);
          arraySet(rawExtraField, data, offset + 4);
          offset += 4 + getLength(data);
        });
      }
      let maximumCompressedSize = 0;
      let maximumEntrySize = 0;
      let uncompressedSize = 0;
      if (passThrough) {
        ({
          uncompressedSize
        } = options);
        if (uncompressedSize === UNDEFINED_VALUE) {
          throw new Error(ERR_UNDEFINED_UNCOMPRESSED_SIZE);
        }
      }
      const zip64Enabled = zip64 === true;
      if (reader) {
        reader = new GenericReader(reader);
        await initStream(reader);
        if (!passThrough) {
          if (reader.size === UNDEFINED_VALUE) {
            dataDescriptor = true;
            if (zip64 || zip64 === UNDEFINED_VALUE) {
              zip64 = true;
              uncompressedSize = maximumCompressedSize = MAX_32_BITS + 1;
            }
          } else {
            options.uncompressedSize = uncompressedSize = reader.size;
            maximumCompressedSize = getMaximumCompressedSize(uncompressedSize);
          }
        } else {
          options.uncompressedSize = uncompressedSize;
          maximumCompressedSize = getMaximumCompressedSize(uncompressedSize);
        }
      }
      const {
        diskOffset,
        diskNumber,
        maxSize
      } = zipWriter.writer;
      const zip64UncompressedSize = zip64Enabled || uncompressedSize > MAX_32_BITS;
      const zip64CompressedSize = zip64Enabled || maximumCompressedSize > MAX_32_BITS;
      const zip64Offset = zip64Enabled || zipWriter.offset + zipWriter.pendingEntriesSize - diskOffset > MAX_32_BITS;
      const supportZip64SplitFile = getOptionValue(zipWriter, options, "supportZip64SplitFile", true);
      const zip64DiskNumberStart = supportZip64SplitFile && zip64Enabled || diskNumber + Math.ceil(zipWriter.pendingEntriesSize / maxSize) > MAX_16_BITS;
      if (zip64Offset || zip64UncompressedSize || zip64CompressedSize || zip64DiskNumberStart) {
        if (zip64 === false || !keepOrder) {
          throw new Error(ERR_UNSUPPORTED_FORMAT);
        } else {
          zip64 = true;
        }
      }
      zip64 = zip64 || false;
      const encrypted = getOptionValue(zipWriter, options, PROPERTY_NAME_ENCRYPTED);
      const {
        signature
      } = options;
      options = Object.assign({}, options, {
        rawFilename,
        rawComment,
        version,
        versionMadeBy,
        lastModDate,
        lastAccessDate,
        creationDate,
        rawExtraField,
        zip64,
        zip64UncompressedSize,
        zip64CompressedSize,
        zip64Offset,
        zip64DiskNumberStart,
        password,
        rawPassword,
        level: !useCompressionStream && zipWriter.config.CompressionStream === UNDEFINED_VALUE && zipWriter.config.CompressionStreamNative === UNDEFINED_VALUE ? 0 : level,
        useWebWorkers,
        encryptionStrength,
        extendedTimestamp,
        zipCrypto,
        bufferedWrite,
        keepOrder,
        useUnicodeFileNames,
        dataDescriptor,
        dataDescriptorSignature,
        signal,
        msDosCompatible,
        internalFileAttribute: internalFileAttributes,
        internalFileAttributes,
        externalFileAttribute: externalFileAttributes,
        externalFileAttributes,
        useCompressionStream,
        passThrough,
        encrypted: Boolean(password && getLength(password) || rawPassword && getLength(rawPassword)) || passThrough && encrypted,
        signature,
        compressionMethod,
        uncompressedSize,
        offset: zipWriter.offset - diskOffset,
        diskNumberStart: diskNumber
      });
      const headerInfo = getHeaderInfo(options);
      const dataDescriptorInfo = getDataDescriptorInfo(options);
      const metadataSize = getLength(headerInfo.localHeaderArray, dataDescriptorInfo.dataDescriptorArray);
      maximumEntrySize = metadataSize + maximumCompressedSize;
      if (zipWriter.options.usdz) {
        maximumEntrySize += maximumEntrySize + 64;
      }
      zipWriter.pendingEntriesSize += maximumEntrySize;
      let fileEntry;
      try {
        fileEntry = await getFileEntry(zipWriter, name, reader, {
          headerInfo,
          dataDescriptorInfo,
          metadataSize
        }, options);
      } finally {
        zipWriter.pendingEntriesSize -= maximumEntrySize;
      }
      Object.assign(fileEntry, {
        name,
        comment,
        extraField
      });
      return new Entry(fileEntry);
    }
    async function getFileEntry(zipWriter, name, reader, entryInfo, options) {
      const {
        files,
        writer
      } = zipWriter;
      const {
        keepOrder,
        dataDescriptor,
        signal
      } = options;
      const {
        headerInfo
      } = entryInfo;
      const {
        usdz
      } = zipWriter.options;
      const previousFileEntry = Array.from(files.values()).pop();
      let fileEntry = {};
      let bufferedWrite;
      let releaseLockWriter;
      let releaseLockCurrentFileEntry;
      let writingBufferedEntryData;
      let writingEntryData;
      let fileWriter;
      let blobPromise;
      files.set(name, fileEntry);
      try {
        let lockPreviousFileEntry;
        if (keepOrder) {
          lockPreviousFileEntry = previousFileEntry && previousFileEntry.lock;
          requestLockCurrentFileEntry();
        }
        if ((options.bufferedWrite || zipWriter.writerLocked || zipWriter.bufferedWrites && keepOrder || !dataDescriptor) && !usdz) {
          fileWriter = new TransformStream();
          fileWriter.size = 0;
          bufferedWrite = true;
          zipWriter.bufferedWrites++;
          await initStream(writer);
        } else {
          fileWriter = writer;
          await requestLockWriter();
        }
        await initStream(fileWriter);
        const {
          writable,
          diskOffset
        } = writer;
        if (zipWriter.addSplitZipSignature) {
          delete zipWriter.addSplitZipSignature;
          const signatureArray = new Uint8Array(4);
          const signatureArrayView = getDataView(signatureArray);
          setUint32(signatureArrayView, 0, SPLIT_ZIP_FILE_SIGNATURE);
          await writeData(writer, signatureArray);
          zipWriter.offset += 4;
        }
        if (usdz) {
          appendExtraFieldUSDZ(entryInfo, zipWriter.offset - diskOffset);
        }
        const {
          localHeaderView,
          localHeaderArray
        } = headerInfo;
        if (!bufferedWrite) {
          await lockPreviousFileEntry;
          await skipDiskIfNeeded(writable);
        }
        const {
          diskNumber
        } = writer;
        writingEntryData = true;
        fileEntry.diskNumberStart = diskNumber;
        if (bufferedWrite) {
          blobPromise = new Response(fileWriter.readable).blob();
        } else {
          await writeData(fileWriter, localHeaderArray);
        }
        fileEntry = await createFileEntry(reader, fileWriter, fileEntry, entryInfo, zipWriter.config, options);
        const {
          zip64
        } = fileEntry;
        writingEntryData = false;
        files.set(name, fileEntry);
        fileEntry.filename = name;
        if (bufferedWrite) {
          const [blob] = await Promise.all([blobPromise, fileWriter.writable.getWriter().close(), lockPreviousFileEntry]);
          await requestLockWriter();
          writingBufferedEntryData = true;
          fileEntry.diskNumberStart = writer.diskNumber;
          fileEntry.offset = zipWriter.offset - writer.diskOffset;
          if (zip64) {
            updateZip64ExtraField(fileEntry);
          }
          updateLocalHeader(fileEntry, localHeaderView);
          await skipDiskIfNeeded(writable);
          await writeData(writer, localHeaderArray);
          await blob.stream().pipeTo(writable, {
            preventClose: true,
            preventAbort: true,
            signal
          });
          writer.size += fileWriter.size;
          writingBufferedEntryData = false;
        } else {
          fileEntry.offset = zipWriter.offset - diskOffset;
          if (zip64) {
            updateZip64ExtraField(fileEntry);
          }
        }
        if (fileEntry.offset > MAX_32_BITS && !zip64) {
          throw new Error(ERR_UNSUPPORTED_FORMAT);
        }
        zipWriter.offset += fileEntry.size;
        return fileEntry;
      } catch (error) {
        if (bufferedWrite && writingBufferedEntryData || !bufferedWrite && writingEntryData) {
          zipWriter.hasCorruptedEntries = true;
          if (error) {
            try {
              error.corruptedEntry = true;
              // eslint-disable-next-line no-unused-vars
            } catch (_) {
              // ignored
            }
          }
          if (bufferedWrite) {
            zipWriter.offset += fileWriter.size;
          } else {
            zipWriter.offset = fileWriter.size;
          }
        }
        files.delete(name);
        throw error;
      } finally {
        if (bufferedWrite) {
          zipWriter.bufferedWrites--;
        }
        if (releaseLockCurrentFileEntry) {
          releaseLockCurrentFileEntry();
        }
        if (releaseLockWriter) {
          releaseLockWriter();
        }
      }
      function requestLockCurrentFileEntry() {
        fileEntry.lock = new Promise(resolve => releaseLockCurrentFileEntry = resolve);
      }
      async function requestLockWriter() {
        zipWriter.writerLocked = true;
        const {
          lockWriter
        } = zipWriter;
        zipWriter.lockWriter = new Promise(resolve => releaseLockWriter = () => {
          zipWriter.writerLocked = false;
          resolve();
        });
        await lockWriter;
      }
      async function skipDiskIfNeeded(writable) {
        if (getLength(headerInfo.localHeaderArray) > writer.availableSize) {
          writer.availableSize = 0;
          await writeData(writable, new Uint8Array());
        }
      }
    }
    async function createFileEntry(reader, writer, {
      diskNumberStart,
      lock
    }, entryInfo, config, options) {
      const {
        headerInfo,
        dataDescriptorInfo,
        metadataSize
      } = entryInfo;
      const {
        headerArray,
        headerView,
        lastModDate,
        rawLastModDate,
        encrypted,
        compressed,
        version,
        compressionMethod,
        rawExtraFieldZip64,
        localExtraFieldZip64Length,
        rawExtraFieldExtendedTimestamp,
        extraFieldExtendedTimestampFlag,
        rawExtraFieldNTFS,
        rawExtraFieldAES
      } = headerInfo;
      const {
        dataDescriptorArray
      } = dataDescriptorInfo;
      const {
        rawFilename,
        lastAccessDate,
        creationDate,
        password,
        rawPassword,
        level,
        zip64,
        zip64UncompressedSize,
        zip64CompressedSize,
        zip64Offset,
        zip64DiskNumberStart,
        zipCrypto,
        dataDescriptor,
        directory,
        executable,
        versionMadeBy,
        rawComment,
        rawExtraField,
        useWebWorkers,
        onstart,
        onprogress,
        onend,
        signal,
        encryptionStrength,
        extendedTimestamp,
        msDosCompatible,
        internalFileAttributes,
        externalFileAttributes,
        useCompressionStream,
        passThrough
      } = options;
      const fileEntry = {
        lock,
        versionMadeBy,
        zip64,
        directory: Boolean(directory),
        executable: Boolean(executable),
        filenameUTF8: true,
        rawFilename,
        commentUTF8: true,
        rawComment,
        rawExtraFieldZip64,
        localExtraFieldZip64Length,
        rawExtraFieldExtendedTimestamp,
        rawExtraFieldNTFS,
        rawExtraFieldAES,
        rawExtraField,
        extendedTimestamp,
        msDosCompatible,
        internalFileAttributes,
        externalFileAttributes,
        diskNumberStart
      };
      let {
        signature,
        uncompressedSize
      } = options;
      let compressedSize = 0;
      if (!passThrough) {
        uncompressedSize = 0;
      }
      const {
        writable
      } = writer;
      if (reader) {
        reader.chunkSize = getChunkSize(config);
        const readable = reader.readable;
        const size = reader.size;
        const workerOptions = {
          options: {
            codecType: CODEC_DEFLATE,
            level,
            rawPassword,
            password,
            encryptionStrength,
            zipCrypto: encrypted && zipCrypto,
            passwordVerification: encrypted && zipCrypto && rawLastModDate >> 8 & 0xFF,
            signed: !passThrough,
            compressed: compressed && !passThrough,
            encrypted: encrypted && !passThrough,
            useWebWorkers,
            useCompressionStream,
            transferStreams: false
          },
          config,
          streamOptions: {
            signal,
            size,
            onstart,
            onprogress,
            onend
          }
        };
        try {
          const result = await runWorker({
            readable,
            writable
          }, workerOptions);
          compressedSize = result.outputSize;
          writer.size += compressedSize;
          if (!passThrough) {
            uncompressedSize = result.inputSize;
            signature = result.signature;
          }
        } catch (error) {
          if (error.outputSize !== UNDEFINED_VALUE) {
            writer.size += error.outputSize;
          }
          throw error;
        }
      }
      setEntryInfo({
        signature,
        compressedSize,
        uncompressedSize,
        headerInfo,
        dataDescriptorInfo
      }, options);
      if (dataDescriptor) {
        await writeData(writer, dataDescriptorArray);
      }
      Object.assign(fileEntry, {
        uncompressedSize,
        compressedSize,
        lastModDate,
        rawLastModDate,
        creationDate,
        lastAccessDate,
        encrypted,
        zipCrypto,
        size: metadataSize + compressedSize,
        compressionMethod,
        version,
        headerArray,
        headerView,
        signature,
        extraFieldExtendedTimestampFlag,
        zip64UncompressedSize,
        zip64CompressedSize,
        zip64Offset,
        zip64DiskNumberStart
      });
      return fileEntry;
    }
    function getHeaderInfo(options) {
      const {
        rawFilename,
        lastModDate,
        lastAccessDate,
        creationDate,
        level,
        zip64,
        zipCrypto,
        useUnicodeFileNames,
        dataDescriptor,
        directory,
        rawExtraField,
        encryptionStrength,
        extendedTimestamp,
        passThrough,
        encrypted,
        zip64UncompressedSize,
        zip64CompressedSize,
        zip64Offset,
        zip64DiskNumberStart,
        uncompressedSize,
        offset,
        diskNumberStart
      } = options;
      let {
        version,
        compressionMethod
      } = options;
      const compressed = !directory && (level > 0 || level === UNDEFINED_VALUE && compressionMethod !== 0);
      let rawExtraFieldZip64;
      const uncompressedFile = passThrough || !compressed;
      const zip64ExtraFieldComplete = zip64 && (options.bufferedWrite || !zip64UncompressedSize && !zip64CompressedSize || uncompressedFile);
      if (zip64) {
        let rawExtraFieldZip64Length = 4;
        if (zip64UncompressedSize) {
          rawExtraFieldZip64Length += 8;
        }
        if (zip64CompressedSize) {
          rawExtraFieldZip64Length += 8;
        }
        if (zip64Offset) {
          rawExtraFieldZip64Length += 8;
        }
        if (zip64DiskNumberStart) {
          rawExtraFieldZip64Length += 4;
        }
        rawExtraFieldZip64 = new Uint8Array(rawExtraFieldZip64Length);
        const rawExtraFieldZip64View = getDataView(rawExtraFieldZip64);
        setUint16(rawExtraFieldZip64View, 0, EXTRAFIELD_TYPE_ZIP64);
        setUint16(rawExtraFieldZip64View, 2, getLength(rawExtraFieldZip64) - 4);
        if (zip64ExtraFieldComplete) {
          const rawExtraFieldZip64View = getDataView(rawExtraFieldZip64);
          let rawExtraFieldZip64Offset = 4;
          if (zip64UncompressedSize) {
            setBigUint64(rawExtraFieldZip64View, rawExtraFieldZip64Offset, BigInt(uncompressedSize));
            rawExtraFieldZip64Offset += 8;
          }
          if (zip64CompressedSize && uncompressedFile) {
            setBigUint64(rawExtraFieldZip64View, rawExtraFieldZip64Offset, BigInt(uncompressedSize));
            rawExtraFieldZip64Offset += 8;
          }
          if (zip64Offset) {
            setBigUint64(rawExtraFieldZip64View, rawExtraFieldZip64Offset, BigInt(offset));
            rawExtraFieldZip64Offset += 8;
          }
          if (zip64DiskNumberStart) {
            setUint32(rawExtraFieldZip64View, rawExtraFieldZip64Offset, diskNumberStart);
            rawExtraFieldZip64Offset += 4;
          }
        }
      } else {
        rawExtraFieldZip64 = new Uint8Array();
      }
      let rawExtraFieldAES;
      if (encrypted && !zipCrypto) {
        rawExtraFieldAES = new Uint8Array(getLength(EXTRAFIELD_DATA_AES) + 2);
        const extraFieldAESView = getDataView(rawExtraFieldAES);
        setUint16(extraFieldAESView, 0, EXTRAFIELD_TYPE_AES);
        arraySet(rawExtraFieldAES, EXTRAFIELD_DATA_AES, 2);
        setUint8(extraFieldAESView, 8, encryptionStrength);
      } else {
        rawExtraFieldAES = new Uint8Array();
      }
      let rawExtraFieldNTFS;
      let rawExtraFieldExtendedTimestamp;
      let extraFieldExtendedTimestampFlag;
      if (extendedTimestamp) {
        rawExtraFieldExtendedTimestamp = new Uint8Array(9 + (lastAccessDate ? 4 : 0) + (creationDate ? 4 : 0));
        const extraFieldExtendedTimestampView = getDataView(rawExtraFieldExtendedTimestamp);
        setUint16(extraFieldExtendedTimestampView, 0, EXTRAFIELD_TYPE_EXTENDED_TIMESTAMP);
        setUint16(extraFieldExtendedTimestampView, 2, getLength(rawExtraFieldExtendedTimestamp) - 4);
        extraFieldExtendedTimestampFlag = 0x1 + (lastAccessDate ? 0x2 : 0) + (creationDate ? 0x4 : 0);
        setUint8(extraFieldExtendedTimestampView, 4, extraFieldExtendedTimestampFlag);
        let offset = 5;
        setUint32(extraFieldExtendedTimestampView, offset, Math.floor(lastModDate.getTime() / 1000));
        offset += 4;
        if (lastAccessDate) {
          setUint32(extraFieldExtendedTimestampView, offset, Math.floor(lastAccessDate.getTime() / 1000));
          offset += 4;
        }
        if (creationDate) {
          setUint32(extraFieldExtendedTimestampView, offset, Math.floor(creationDate.getTime() / 1000));
        }
        try {
          rawExtraFieldNTFS = new Uint8Array(36);
          const extraFieldNTFSView = getDataView(rawExtraFieldNTFS);
          const lastModTimeNTFS = getTimeNTFS(lastModDate);
          setUint16(extraFieldNTFSView, 0, EXTRAFIELD_TYPE_NTFS);
          setUint16(extraFieldNTFSView, 2, 32);
          setUint16(extraFieldNTFSView, 8, EXTRAFIELD_TYPE_NTFS_TAG1);
          setUint16(extraFieldNTFSView, 10, 24);
          setBigUint64(extraFieldNTFSView, 12, lastModTimeNTFS);
          setBigUint64(extraFieldNTFSView, 20, getTimeNTFS(lastAccessDate) || lastModTimeNTFS);
          setBigUint64(extraFieldNTFSView, 28, getTimeNTFS(creationDate) || lastModTimeNTFS);
          // eslint-disable-next-line no-unused-vars
        } catch (_) {
          rawExtraFieldNTFS = new Uint8Array();
        }
      } else {
        rawExtraFieldNTFS = rawExtraFieldExtendedTimestamp = new Uint8Array();
      }
      if (compressionMethod === UNDEFINED_VALUE) {
        compressionMethod = compressed ? COMPRESSION_METHOD_DEFLATE : COMPRESSION_METHOD_STORE;
      }
      if (zip64) {
        version = version > VERSION_ZIP64 ? version : VERSION_ZIP64;
      }
      if (encrypted && !zipCrypto) {
        version = version > VERSION_AES ? version : VERSION_AES;
        rawExtraFieldAES[9] = compressionMethod;
        compressionMethod = COMPRESSION_METHOD_AES;
      }
      const localExtraFieldZip64Length = zip64ExtraFieldComplete ? getLength(rawExtraFieldZip64) : 0;
      const extraFieldLength = localExtraFieldZip64Length + getLength(rawExtraFieldAES, rawExtraFieldExtendedTimestamp, rawExtraFieldNTFS, rawExtraField);
      const {
        headerArray,
        headerView,
        rawLastModDate
      } = getHeaderArrayData({
        version,
        bitFlag: getBitFlag(level, useUnicodeFileNames, dataDescriptor, encrypted, compressionMethod),
        compressionMethod,
        uncompressedSize,
        lastModDate: lastModDate < MIN_DATE ? MIN_DATE : lastModDate > MAX_DATE ? MAX_DATE : lastModDate,
        rawFilename,
        zip64CompressedSize,
        zip64UncompressedSize,
        extraFieldLength
      });
      let localHeaderOffset = HEADER_SIZE + 4;
      const localHeaderArray = new Uint8Array(localHeaderOffset + getLength(rawFilename) + extraFieldLength);
      const localHeaderView = getDataView(localHeaderArray);
      setUint32(localHeaderView, 0, LOCAL_FILE_HEADER_SIGNATURE);
      arraySet(localHeaderArray, headerArray, 4);
      arraySet(localHeaderArray, rawFilename, localHeaderOffset);
      localHeaderOffset += getLength(rawFilename);
      if (zip64ExtraFieldComplete) {
        arraySet(localHeaderArray, rawExtraFieldZip64, localHeaderOffset);
      }
      localHeaderOffset += localExtraFieldZip64Length;
      arraySet(localHeaderArray, rawExtraFieldAES, localHeaderOffset);
      localHeaderOffset += getLength(rawExtraFieldAES);
      arraySet(localHeaderArray, rawExtraFieldExtendedTimestamp, localHeaderOffset);
      localHeaderOffset += getLength(rawExtraFieldExtendedTimestamp);
      arraySet(localHeaderArray, rawExtraFieldNTFS, localHeaderOffset);
      localHeaderOffset += getLength(rawExtraFieldNTFS);
      arraySet(localHeaderArray, rawExtraField, localHeaderOffset);
      return {
        localHeaderArray,
        localHeaderView,
        headerArray,
        headerView,
        lastModDate,
        rawLastModDate,
        encrypted,
        compressed,
        version,
        compressionMethod,
        extraFieldExtendedTimestampFlag,
        rawExtraFieldZip64,
        localExtraFieldZip64Length,
        rawExtraFieldExtendedTimestamp,
        rawExtraFieldNTFS,
        rawExtraFieldAES,
        extraFieldLength
      };
    }
    function appendExtraFieldUSDZ(entryInfo, zipWriterOffset) {
      const {
        headerInfo
      } = entryInfo;
      let {
        localHeaderArray,
        extraFieldLength
      } = headerInfo;
      let localHeaderArrayView = getDataView(localHeaderArray);
      let extraBytesLength = 64 - (zipWriterOffset + getLength(localHeaderArray)) % 64;
      if (extraBytesLength < 4) {
        extraBytesLength += 64;
      }
      const rawExtraFieldUSDZ = new Uint8Array(extraBytesLength);
      const extraFieldUSDZView = getDataView(rawExtraFieldUSDZ);
      setUint16(extraFieldUSDZView, 0, EXTRAFIELD_TYPE_USDZ);
      setUint16(extraFieldUSDZView, 2, extraBytesLength - 2);
      const previousLocalHeaderArray = localHeaderArray;
      headerInfo.localHeaderArray = localHeaderArray = new Uint8Array(getLength(previousLocalHeaderArray) + extraBytesLength);
      arraySet(localHeaderArray, previousLocalHeaderArray);
      arraySet(localHeaderArray, rawExtraFieldUSDZ, getLength(previousLocalHeaderArray));
      localHeaderArrayView = getDataView(localHeaderArray);
      setUint16(localHeaderArrayView, 28, extraFieldLength + extraBytesLength);
      entryInfo.metadataSize += extraBytesLength;
    }
    function getDataDescriptorInfo({
      zip64,
      dataDescriptor,
      dataDescriptorSignature
    }) {
      let dataDescriptorArray = new Uint8Array();
      let dataDescriptorView,
        dataDescriptorOffset = 0;
      if (dataDescriptor) {
        dataDescriptorArray = new Uint8Array(zip64 ? dataDescriptorSignature ? 24 : 20 : dataDescriptorSignature ? 16 : 12);
        dataDescriptorView = getDataView(dataDescriptorArray);
        if (dataDescriptorSignature) {
          dataDescriptorOffset = 4;
          setUint32(dataDescriptorView, 0, DATA_DESCRIPTOR_RECORD_SIGNATURE);
        }
      }
      return {
        dataDescriptorArray,
        dataDescriptorView,
        dataDescriptorOffset
      };
    }
    function setEntryInfo({
      signature,
      compressedSize,
      uncompressedSize,
      headerInfo,
      dataDescriptorInfo
    }, {
      zip64,
      zipCrypto,
      dataDescriptor
    }) {
      const {
        headerView,
        encrypted
      } = headerInfo;
      const {
        dataDescriptorView,
        dataDescriptorOffset
      } = dataDescriptorInfo;
      if ((!encrypted || zipCrypto) && signature !== UNDEFINED_VALUE) {
        setUint32(headerView, HEADER_OFFSET_SIGNATURE, signature);
        if (dataDescriptor) {
          setUint32(dataDescriptorView, dataDescriptorOffset, signature);
        }
      }
      if (zip64) {
        if (dataDescriptor) {
          setBigUint64(dataDescriptorView, dataDescriptorOffset + 4, BigInt(compressedSize));
          setBigUint64(dataDescriptorView, dataDescriptorOffset + 12, BigInt(uncompressedSize));
        }
      } else {
        setUint32(headerView, HEADER_OFFSET_COMPRESSED_SIZE, compressedSize);
        setUint32(headerView, HEADER_OFFSET_UNCOMPRESSED_SIZE, uncompressedSize);
        if (dataDescriptor) {
          setUint32(dataDescriptorView, dataDescriptorOffset + 4, compressedSize);
          setUint32(dataDescriptorView, dataDescriptorOffset + 8, uncompressedSize);
        }
      }
    }
    function updateLocalHeader({
      rawFilename,
      dataDescriptor,
      encrypted,
      zip64,
      localExtraFieldZip64Length,
      signature,
      compressedSize,
      uncompressedSize,
      offset,
      diskNumberStart,
      zip64UncompressedSize,
      zip64CompressedSize,
      zip64Offset,
      zip64DiskNumberStart
    }, localHeaderView) {
      if (!dataDescriptor) {
        if (!encrypted) {
          setUint32(localHeaderView, HEADER_OFFSET_SIGNATURE + 4, signature);
        }
        if (!zip64) {
          setUint32(localHeaderView, HEADER_OFFSET_COMPRESSED_SIZE + 4, compressedSize);
          setUint32(localHeaderView, HEADER_OFFSET_UNCOMPRESSED_SIZE + 4, uncompressedSize);
        }
      }
      if (zip64) {
        if (localExtraFieldZip64Length) {
          let localHeaderOffset = HEADER_SIZE + 4 + getLength(rawFilename) + 4;
          if (zip64UncompressedSize) {
            setBigUint64(localHeaderView, localHeaderOffset, BigInt(uncompressedSize));
            localHeaderOffset += 8;
          }
          if (zip64CompressedSize) {
            setBigUint64(localHeaderView, localHeaderOffset, BigInt(compressedSize));
            localHeaderOffset += 8;
          }
          if (zip64Offset) {
            setBigUint64(localHeaderView, localHeaderOffset, BigInt(offset));
            localHeaderOffset += 8;
          }
          if (zip64DiskNumberStart) {
            setUint32(localHeaderView, localHeaderOffset, diskNumberStart);
          }
        }
      }
    }
    function updateZip64ExtraField({
      compressedSize,
      uncompressedSize,
      offset,
      diskNumberStart,
      zip64UncompressedSize,
      zip64CompressedSize,
      zip64Offset,
      zip64DiskNumberStart,
      rawExtraFieldZip64
    }) {
      const rawExtraFieldZip64View = getDataView(rawExtraFieldZip64);
      let rawExtraFieldZip64Offset = 4;
      if (zip64UncompressedSize) {
        setBigUint64(rawExtraFieldZip64View, rawExtraFieldZip64Offset, BigInt(uncompressedSize));
        rawExtraFieldZip64Offset += 8;
      }
      if (zip64CompressedSize) {
        setBigUint64(rawExtraFieldZip64View, rawExtraFieldZip64Offset, BigInt(compressedSize));
        rawExtraFieldZip64Offset += 8;
      }
      if (zip64Offset) {
        setBigUint64(rawExtraFieldZip64View, rawExtraFieldZip64Offset, BigInt(offset));
        rawExtraFieldZip64Offset += 8;
      }
      if (zip64DiskNumberStart) {
        setUint32(rawExtraFieldZip64View, rawExtraFieldZip64Offset, diskNumberStart);
      }
    }
    async function closeFile(zipWriter, comment, options) {
      const {
        files,
        writer
      } = zipWriter;
      const {
        diskOffset
      } = writer;
      let {
        diskNumber
      } = writer;
      let offset = 0;
      let directoryDataLength = 0;
      let directoryOffset = zipWriter.offset - diskOffset;
      let filesLength = files.size;
      for (const [, fileEntry] of files) {
        const {
          rawFilename,
          rawExtraFieldZip64,
          rawExtraFieldAES,
          rawComment,
          rawExtraFieldNTFS,
          rawExtraField,
          extendedTimestamp,
          extraFieldExtendedTimestampFlag,
          lastModDate
        } = fileEntry;
        let rawExtraFieldTimestamp;
        if (extendedTimestamp) {
          rawExtraFieldTimestamp = new Uint8Array(9);
          const extraFieldExtendedTimestampView = getDataView(rawExtraFieldTimestamp);
          setUint16(extraFieldExtendedTimestampView, 0, EXTRAFIELD_TYPE_EXTENDED_TIMESTAMP);
          setUint16(extraFieldExtendedTimestampView, 2, 5);
          setUint8(extraFieldExtendedTimestampView, 4, extraFieldExtendedTimestampFlag);
          setUint32(extraFieldExtendedTimestampView, 5, Math.floor(lastModDate.getTime() / 1000));
        } else {
          rawExtraFieldTimestamp = new Uint8Array();
        }
        fileEntry.rawExtraFieldExtendedTimestamp = rawExtraFieldTimestamp;
        directoryDataLength += 46 + getLength(rawFilename, rawComment, rawExtraFieldZip64, rawExtraFieldAES, rawExtraFieldNTFS, rawExtraFieldTimestamp, rawExtraField);
      }
      const directoryArray = new Uint8Array(directoryDataLength);
      const directoryView = getDataView(directoryArray);
      await initStream(writer);
      let directoryDiskOffset = 0;
      for (const [indexFileEntry, fileEntry] of Array.from(files.values()).entries()) {
        const {
          offset: fileEntryOffset,
          rawFilename,
          rawExtraFieldZip64,
          rawExtraFieldAES,
          rawExtraFieldExtendedTimestamp,
          rawExtraFieldNTFS,
          rawExtraField,
          rawComment,
          versionMadeBy,
          headerArray,
          headerView,
          zip64,
          zip64UncompressedSize,
          zip64CompressedSize,
          zip64DiskNumberStart,
          zip64Offset,
          internalFileAttributes,
          externalFileAttributes,
          diskNumberStart,
          uncompressedSize,
          compressedSize
        } = fileEntry;
        const extraFieldLength = getLength(rawExtraFieldZip64, rawExtraFieldAES, rawExtraFieldExtendedTimestamp, rawExtraFieldNTFS, rawExtraField);
        setUint32(directoryView, offset, CENTRAL_FILE_HEADER_SIGNATURE);
        setUint16(directoryView, offset + 4, versionMadeBy);
        if (!zip64UncompressedSize) {
          setUint32(headerView, HEADER_OFFSET_UNCOMPRESSED_SIZE, uncompressedSize);
        }
        if (!zip64CompressedSize) {
          setUint32(headerView, HEADER_OFFSET_COMPRESSED_SIZE, compressedSize);
        }
        arraySet(directoryArray, headerArray, offset + 6);
        let directoryOffset = offset + HEADER_SIZE + 4;
        setUint16(directoryView, directoryOffset, extraFieldLength);
        directoryOffset += 2;
        setUint16(directoryView, directoryOffset, getLength(rawComment));
        directoryOffset += 2;
        setUint16(directoryView, directoryOffset, zip64 && zip64DiskNumberStart ? MAX_16_BITS : diskNumberStart);
        directoryOffset += 2;
        setUint16(directoryView, directoryOffset, internalFileAttributes);
        directoryOffset += 2;
        if (externalFileAttributes) {
          setUint32(directoryView, directoryOffset, externalFileAttributes);
        }
        directoryOffset += 4;
        setUint32(directoryView, directoryOffset, zip64 && zip64Offset ? MAX_32_BITS : fileEntryOffset);
        directoryOffset += 4;
        arraySet(directoryArray, rawFilename, directoryOffset);
        directoryOffset += getLength(rawFilename);
        arraySet(directoryArray, rawExtraFieldZip64, directoryOffset);
        directoryOffset += getLength(rawExtraFieldZip64);
        arraySet(directoryArray, rawExtraFieldAES, directoryOffset);
        directoryOffset += getLength(rawExtraFieldAES);
        arraySet(directoryArray, rawExtraFieldExtendedTimestamp, directoryOffset);
        directoryOffset += getLength(rawExtraFieldExtendedTimestamp);
        arraySet(directoryArray, rawExtraFieldNTFS, directoryOffset);
        directoryOffset += getLength(rawExtraFieldNTFS);
        arraySet(directoryArray, rawExtraField, directoryOffset);
        directoryOffset += getLength(rawExtraField);
        arraySet(directoryArray, rawComment, directoryOffset);
        if (offset - directoryDiskOffset > writer.availableSize) {
          writer.availableSize = 0;
          await writeData(writer, directoryArray.slice(directoryDiskOffset, offset));
          directoryDiskOffset = offset;
        }
        offset = directoryOffset;
        if (options.onprogress) {
          try {
            await options.onprogress(indexFileEntry + 1, files.size, new Entry(fileEntry));
            // eslint-disable-next-line no-unused-vars
          } catch (_) {
            // ignored
          }
        }
      }
      await writeData(writer, directoryDiskOffset ? directoryArray.slice(directoryDiskOffset) : directoryArray);
      let lastDiskNumber = writer.diskNumber;
      const {
        availableSize
      } = writer;
      if (availableSize < END_OF_CENTRAL_DIR_LENGTH) {
        lastDiskNumber++;
      }
      let zip64 = getOptionValue(zipWriter, options, PROPERTY_NAME_ZIP64);
      if (directoryOffset > MAX_32_BITS || directoryDataLength > MAX_32_BITS || filesLength > MAX_16_BITS || lastDiskNumber > MAX_16_BITS) {
        if (zip64 === false) {
          throw new Error(ERR_UNSUPPORTED_FORMAT);
        } else {
          zip64 = true;
        }
      }
      const endOfdirectoryArray = new Uint8Array(zip64 ? ZIP64_END_OF_CENTRAL_DIR_TOTAL_LENGTH : END_OF_CENTRAL_DIR_LENGTH);
      const endOfdirectoryView = getDataView(endOfdirectoryArray);
      offset = 0;
      if (zip64) {
        setUint32(endOfdirectoryView, 0, ZIP64_END_OF_CENTRAL_DIR_SIGNATURE);
        setBigUint64(endOfdirectoryView, 4, BigInt(44));
        setUint16(endOfdirectoryView, 12, 45);
        setUint16(endOfdirectoryView, 14, 45);
        setUint32(endOfdirectoryView, 16, lastDiskNumber);
        setUint32(endOfdirectoryView, 20, diskNumber);
        setBigUint64(endOfdirectoryView, 24, BigInt(filesLength));
        setBigUint64(endOfdirectoryView, 32, BigInt(filesLength));
        setBigUint64(endOfdirectoryView, 40, BigInt(directoryDataLength));
        setBigUint64(endOfdirectoryView, 48, BigInt(directoryOffset));
        setUint32(endOfdirectoryView, 56, ZIP64_END_OF_CENTRAL_DIR_LOCATOR_SIGNATURE);
        setBigUint64(endOfdirectoryView, 64, BigInt(directoryOffset) + BigInt(directoryDataLength));
        setUint32(endOfdirectoryView, 72, lastDiskNumber + 1);
        const supportZip64SplitFile = getOptionValue(zipWriter, options, "supportZip64SplitFile", true);
        if (supportZip64SplitFile) {
          lastDiskNumber = MAX_16_BITS;
          diskNumber = MAX_16_BITS;
        }
        filesLength = MAX_16_BITS;
        directoryOffset = MAX_32_BITS;
        directoryDataLength = MAX_32_BITS;
        offset += ZIP64_END_OF_CENTRAL_DIR_LENGTH + ZIP64_END_OF_CENTRAL_DIR_LOCATOR_LENGTH;
      }
      setUint32(endOfdirectoryView, offset, END_OF_CENTRAL_DIR_SIGNATURE);
      setUint16(endOfdirectoryView, offset + 4, lastDiskNumber);
      setUint16(endOfdirectoryView, offset + 6, diskNumber);
      setUint16(endOfdirectoryView, offset + 8, filesLength);
      setUint16(endOfdirectoryView, offset + 10, filesLength);
      setUint32(endOfdirectoryView, offset + 12, directoryDataLength);
      setUint32(endOfdirectoryView, offset + 16, directoryOffset);
      const commentLength = getLength(comment);
      if (commentLength) {
        if (commentLength <= MAX_16_BITS) {
          setUint16(endOfdirectoryView, offset + 20, commentLength);
        } else {
          throw new Error(ERR_INVALID_COMMENT);
        }
      }
      await writeData(writer, endOfdirectoryArray);
      if (commentLength) {
        await writeData(writer, comment);
      }
    }
    async function writeData(writer, array) {
      const {
        writable
      } = writer;
      const streamWriter = writable.getWriter();
      try {
        await streamWriter.ready;
        writer.size += getLength(array);
        await streamWriter.write(array);
      } finally {
        streamWriter.releaseLock();
      }
    }
    function getTimeNTFS(date) {
      if (date) {
        return (BigInt(date.getTime()) + BigInt(11644473600000)) * BigInt(10000);
      }
    }
    function getOptionValue(zipWriter, options, name, defaultValue) {
      const result = options[name] === UNDEFINED_VALUE ? zipWriter.options[name] : options[name];
      return result === UNDEFINED_VALUE ? defaultValue : result;
    }
    function getMaximumCompressedSize(uncompressedSize) {
      return uncompressedSize + 5 * (Math.floor(uncompressedSize / 16383) + 1);
    }
    function setUint8(view, offset, value) {
      view.setUint8(offset, value);
    }
    function setUint16(view, offset, value) {
      view.setUint16(offset, value, true);
    }
    function setUint32(view, offset, value) {
      view.setUint32(offset, value, true);
    }
    function setBigUint64(view, offset, value) {
      view.setBigUint64(offset, value, true);
    }
    function arraySet(array, typedArray, offset) {
      array.set(typedArray, offset);
    }
    function getDataView(array) {
      return new DataView(array.buffer);
    }
    function getLength(...arrayLikes) {
      let result = 0;
      arrayLikes.forEach(arrayLike => arrayLike && (result += arrayLike.length));
      return result;
    }
    function getHeaderArrayData({
      version,
      bitFlag,
      compressionMethod,
      uncompressedSize,
      compressedSize,
      lastModDate,
      rawFilename,
      zip64CompressedSize,
      zip64UncompressedSize,
      extraFieldLength
    }) {
      const headerArray = new Uint8Array(HEADER_SIZE);
      const headerView = getDataView(headerArray);
      setUint16(headerView, 0, version);
      setUint16(headerView, 2, bitFlag);
      setUint16(headerView, 4, compressionMethod);
      const dateArray = new Uint32Array(1);
      const dateView = getDataView(dateArray);
      setUint16(dateView, 0, (lastModDate.getHours() << 6 | lastModDate.getMinutes()) << 5 | lastModDate.getSeconds() / 2);
      setUint16(dateView, 2, (lastModDate.getFullYear() - 1980 << 4 | lastModDate.getMonth() + 1) << 5 | lastModDate.getDate());
      const rawLastModDate = dateArray[0];
      setUint32(headerView, 6, rawLastModDate);
      if (zip64CompressedSize || compressedSize !== UNDEFINED_VALUE) {
        setUint32(headerView, HEADER_OFFSET_COMPRESSED_SIZE, zip64CompressedSize ? MAX_32_BITS : compressedSize);
      }
      if (zip64UncompressedSize || uncompressedSize !== UNDEFINED_VALUE) {
        setUint32(headerView, HEADER_OFFSET_UNCOMPRESSED_SIZE, zip64UncompressedSize ? MAX_32_BITS : uncompressedSize);
      }
      setUint16(headerView, 22, getLength(rawFilename));
      setUint16(headerView, 24, extraFieldLength);
      return {
        headerArray,
        headerView,
        rawLastModDate
      };
    }
    function getBitFlag(level, useUnicodeFileNames, dataDescriptor, encrypted, compressionMethod) {
      let bitFlag = 0;
      if (useUnicodeFileNames) {
        bitFlag = bitFlag | BITFLAG_LANG_ENCODING_FLAG;
      }
      if (dataDescriptor) {
        bitFlag = bitFlag | BITFLAG_DATA_DESCRIPTOR;
      }
      if (compressionMethod == COMPRESSION_METHOD_DEFLATE || compressionMethod == COMPRESSION_METHOD_DEFLATE_64) {
        if (level >= 0 && level <= 3) {
          bitFlag = bitFlag | BITFLAG_LEVEL_SUPER_FAST_MASK;
        }
        if (level > 3 && level <= 5) {
          bitFlag = bitFlag | BITFLAG_LEVEL_FAST_MASK;
        }
        if (level == 9) {
          bitFlag = bitFlag | BITFLAG_LEVEL_MAX_MASK;
        }
      }
      if (encrypted) {
        bitFlag = bitFlag | BITFLAG_ENCRYPTED;
      }
      return bitFlag;
    }

    /*
     Copyright (c) 2022 Gildas Lormeau. All rights reserved.

     Redistribution and use in source and binary forms, with or without
     modification, are permitted provided that the following conditions are met:

     1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in
     the documentation and/or other materials provided with the distribution.

     3. The names of the authors may not be used to endorse or promote products
     derived from this software without specific prior written permission.

     THIS SOFTWARE IS PROVIDED ''AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
     INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
     FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JCRAFT,
     INC. OR ANY CONTRIBUTORS TO THIS SOFTWARE BE LIABLE FOR ANY DIRECT, INDIRECT,
     INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
     LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
     OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
     LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
     NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
     EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     */

    let baseURL;
    try {
      baseURL = (typeof document === 'undefined' && typeof location === 'undefined' ? require('u' + 'rl').pathToFileURL(__filename).href : typeof document === 'undefined' ? location.href : (_documentCurrentScript && _documentCurrentScript.tagName.toUpperCase() === 'SCRIPT' && _documentCurrentScript.src || new URL('zenodo.js', document.baseURI).href));
      // eslint-disable-next-line no-unused-vars
    } catch (_) {
      // ignored
    }
    configure({
      baseURL
    });
    e(configure);

    configure({
      useCompressionStream: true,
      useWebWorkers: false
    });
    /**
     *
     * This function zips an array of File objects into a single zip file.
     * @param files - Array of File objects to be zipped
     * @param zipName - The name of the resulting zip file (without extension)
     * @returns A promise that resolves to a File object representing the zip file.
     */
    async function zipFiles(files, zipName) {
      const zipFileStream = new TransformStream();
      const zipFileBlobPromise = new Response(zipFileStream.readable).blob();
      const zipWriter = new ZipWriter(zipFileStream.writable);
      const attachmentPromises = files.map(file => zipWriter.add(file.name, file.stream()));
      await Promise.all(attachmentPromises);
      await zipWriter.close();
      const zipFileBlob = await zipFileBlobPromise;
      if (zipFileBlob.size > 50 * 1024 * 1024 * 1024) {
        throw new Error(`Zip file exceeds 50GB limit`);
      }
      return new File([zipFileBlob], `${zipName}.zip`, {
        type: 'application/zip'
      });
    }

    class Deposition {
      zenodo;
      value;
      constructor(zenodo, deposition) {
        this.zenodo = zenodo;
        this.value = validateZenodoDeposition(deposition, zenodo.logger);
      }
      /**
       * This method creates a new file in the deposition. If the file is already it will first
       * delete the existing file and then create a new one.
       * @param file - the file to create in the deposition
       * @returns the created file object
       */
      async createFile(file) {
        const createdFile = await this.createFiles([file]);
        if (!createdFile[0]) {
          throw new Error('Failed to create file: No status object returned.');
        }
        return createdFile[0];
      }
      /**
       * Creates multiple files in the deposition. It will attempt to create each file
       * multiple times with delays in between until all files are successfully created or
       * the maximum number of attempts is reached.
       * @param filesAndNames - an array of File objects to be created in the deposition
       * @returns an array of the created ZenodoFile objects
       */
      async createFiles(filesAndNames) {
        const promises = filesAndNames.map(file => this.uploadFile(file));
        return await Promise.all(promises);
      }
      /**
       * Creates a zip file from multiple files and uploads it to the deposition.
       * @param filesAndNames - an array of File objects to be created in the deposition
       * @param zipName - the name of the zip file to be created
       * @returns an array of the created ZenodoFile objects
       */
      async createFilesAsZip(filesAndNames, zipName) {
        const zippedFile = await zipFiles(filesAndNames, zipName);
        return this.createFiles([zippedFile]);
      }
      /**
       * List all files in the deposition
       * @returns an array of ZenodoFile objects
       */
      async listFiles() {
        const response = await fetchZenodo(this.zenodo, {
          route: `deposit/depositions/${this.value.id}/files`
        });
        const files = await response.json();
        this.zenodo.logger?.info(`Listed ${files.length} files for deposition ${this.value.id}`);
        return files.map(file => new ZenodoFile(this.zenodo, file));
      }
      /**
       * Delete a file from the deposition
       * @param id - the ID or the name of the file to delete
       */
      async deleteFile(id) {
        await fetchZenodo(this.zenodo, {
          route: `deposit/depositions/${this.value.id}/files/${id}`,
          method: 'DELETE',
          expectedStatus: 204
        });
        this.zenodo.logger?.info(`Deleted file ${id} for deposition ${this.value.id}`);
      }
      /**
       * delete all files from the deposition
       */
      async deleteAllFiles() {
        const files = await this.listFiles();
        for (const file of files) {
          await this.deleteFile(file.value.id);
        }
        this.zenodo.logger?.info(`Deleted all files for deposition ${this.value.id}`);
      }
      /**
       * Retrieve a file from the deposition
       * @param id - the ID or the name of the file to retrieve
       * @returns the file object
       */
      async retrieveFile(id) {
        const response = await fetchZenodo(this.zenodo, {
          route: `deposit/depositions/${this.value.id}/files/${id}`
        });
        const file = new ZenodoFile(this.zenodo, await response.json());
        this.zenodo.logger?.info(`Retrieved file ${id} for deposition ${this.value.id}`);
        return file;
      }
      /**
       * Update the metadata of the deposition
       * @param metadata - the new metadata to update the deposition with
       * @returns the updated deposition object
       */
      async update(metadata) {
        const response = await fetchZenodo(this.zenodo, {
          route: `deposit/depositions/${this.value.id}`,
          method: 'PUT',
          body: JSON.stringify({
            metadata
          })
        });
        const deposition = new Deposition(this.zenodo, await response.json());
        this.zenodo.logger?.info(`Updated deposition ${this.value.id}`);
        return deposition;
      }
      /**
       * Publish the deposition. This will make it publicly available.
       * !!! Note that the deposition cannot be deleted after it is published.
       * @returns the updated deposition object after publishing
       */
      async publish() {
        const response = await fetchZenodo(this.zenodo, {
          route: `deposit/depositions/${this.value.id}/actions/publish`,
          method: 'POST',
          expectedStatus: 202
        });
        const deposition = new Deposition(this.zenodo, await response.json());
        this.zenodo.logger?.info(`Published deposition ${this.value.id}`);
        return deposition;
      }
      /**
       * Creates a new version of a published deposition.
       * This is useful for updating the deposition with new files or metadata.
       * The new version will have a new ID and will not overwrite the existing deposition.
       * @returns a new deposition object that is a new version of the current deposition
       */
      async newVersion() {
        const response = await fetchZenodo(this.zenodo, {
          route: `deposit/depositions/${this.value.id}/actions/newversion`,
          method: 'POST',
          expectedStatus: 201
        });
        const deposition = new Deposition(this.zenodo, await response.json());
        if (deposition.value.metadata && !deposition.value.metadata?.publication_date) {
          deposition.value.metadata.publication_date = new Date().toISOString().split('T')[0];
          await deposition.update(deposition.value.metadata);
        }
        this.zenodo.logger?.info(`Created new version for deposition ${this.value.id}`);
        return deposition;
      }
      /**
       * Upload a file to the deposition
       * @param file - the file to upload to the deposition
       * @returns the created file object
       */
      async uploadFile(file) {
        const formData = new FormData();
        formData.append('file', file);
        const response = await fetchZenodo(this.zenodo, {
          route: `deposit/depositions/${this.value.id}/files`,
          method: 'POST',
          body: formData,
          expectedStatus: 201
        });
        const zenodoFile = new ZenodoFile(this.zenodo, await response.json());
        this.zenodo.logger?.info(`Created file ${zenodoFile.value.id} for deposition ${this.value.id}`);
        this.value.files?.push(zenodoFile.value);
        return zenodoFile;
      }
      /**
       * Submits the deposition for review via browser.
       * CORS request won't work from the other endpoint when using a browser.
       * If a URL is provided, it will use that URL to submit the request.
       * Otherwise, it will find the request for the current deposition and submit it.
       * This is not the intended endpoint for submitting requests via browser.
       * But the base endpoint is not CORS enabled.
       * You can find the method with the right endpoint at:
       * https://github.com/cheminfo/zenodo/blob/7fbf3e8bb44246b3465b94b68c21cd3f4fee3bf6/src/depositions/Deposition.ts#L286-L301
       * @param url - optional URL to submit the request
       * @returns The submitted Zenodo request object
       */
      async submitForReview(url) {
        if (url) {
          // If a URL is provided, we assume it's a full API endpoint for submitting the request
          url = url.replace(/.*requests\//, 'requests/');
          const response = await fetchZenodo(this.zenodo, {
            route: url,
            method: 'POST'
          });
          this.zenodo.logger?.info(`Submitted deposition ${this.value.id} for review via URL ${url}`);
          return await response.json();
        } else {
          const response = await fetchZenodo(this.zenodo, {
            route: `requests`
          });
          const requests = await response.json();
          const request = requests.hits.hits.find(req => req.topic.record === String(this.value.id));
          await fetchZenodo(this.zenodo, {
            route: request?.links.actions?.submit,
            method: 'POST',
            expectedStatus: 202
          });
          this.zenodo.logger?.info(`Submitted deposition ${this.value.id} for review`);
          return request;
        }
      }
      /**
       * Adds the deposition to a community.
       * This method adds the deposition to a community by creating a review request.
       * @param communityId - the ID of the community to add the deposition to
       * @returns the response from the Zenodo API
       */
      async addToCommunity(communityId) {
        const body = JSON.stringify({
          receiver: {
            community: communityId
          },
          type: 'community-submission'
        });
        const response = await fetchZenodo(this.zenodo, {
          route: `records/${this.value.id}/draft/review`,
          method: 'PUT',
          body,
          expectedStatus: 200
        });
        this.zenodo.logger?.info(`Added deposition ${this.value.id} to community ${communityId}`);
        return await response.json();
      }
    }

    class Record {
      value;
      zenodo;
      constructor(zenodo, value) {
        this.zenodo = zenodo;
        this.value = validateZenodoRecord(value);
      }
      async getDeposition() {
        if (this.value.id === undefined) {
          throw new Error('Deposition ID is undefined');
        }
        if (this.zenodo.accessToken === undefined) {
          throw new Error('Access token is required to retrieve a deposition');
        }
        return await this.zenodo.retrieveDeposition(this.value.id);
      }
    }

    class Zenodo {
      host;
      accessToken;
      baseURL;
      logger;
      authenticationState;
      constructor(options) {
        const {
          accessToken,
          host = 'sandbox.zenodo.org',
          logger
        } = options;
        this.host = host;
        this.baseURL = `https://${host}/api/`;
        this.logger = logger;
        this.accessToken = accessToken;
        this.authenticationState = ZenodoAuthenticationStates.NOT_TRIED;
      }
      /**
       * Create a new Zenodo instance.
       * This method authenticates the user and initializes a new Zenodo instance.
       * @param options - the options for creating a Zenodo instance
       * @throws {Error} If the authentication fails
       * @returns a new Zenodo instance
       */
      static async create(options) {
        const zenodo = new Zenodo(options);
        const response = await fetchZenodo(zenodo, {
          route: 'deposit/depositions',
          expectedStatus: 200
        });
        if (!response.ok) {
          throw new Error(`Failed to authenticate: ${response.statusText}`);
        }
        zenodo.logger?.info('Authenticated successfully');
        zenodo.authenticationState = ZenodoAuthenticationStates.SUCCEEDED;
        return zenodo;
      }
      /**
       * Verify the authentication state of the Zenodo instance.
       * This method checks if the access token is valid by making a request to the Zenodo API.
       * @returns true if authentication is successful, false otherwise.
       */
      async verifyAuthentication() {
        const url = `${this.baseURL}deposit/depositions`;
        const headers = new Headers();
        if (this.accessToken) {
          headers.set('Authorization', `Bearer ${this.accessToken}`);
        }
        // can't use fetchZenodo to avoid circular dependency
        try {
          const response = await fetch(url, {
            method: 'GET',
            headers
          });
          if (response.status === 200) {
            this.authenticationState = ZenodoAuthenticationStates.SUCCEEDED;
            this.logger?.info('Authentication verified successfully');
            return true;
          } else {
            this.authenticationState = ZenodoAuthenticationStates.FAILED;
            this.logger?.warn(`Authentication failed with status ${response.status}`);
            return false;
          }
        } catch (error) {
          this.authenticationState = ZenodoAuthenticationStates.FAILED;
          this.logger?.error(`Authentication verification failed: ${String(error)}`);
          return false;
        }
      }
      /**
       * List all depositions
       * @param options - options for listing depositions
       * @returns an array of deposition objects
       */
      async listDepositions(options = {}) {
        // all the values must be string
        const optionsWithStrings = Object.fromEntries(Object.entries(options).map(([key, value]) => {
          if (key === 'allVersions') {
            return ['all_versions', String(value)];
          }
          return [key, String(value)];
        }));
        const response = await fetchZenodo(this, {
          route: 'deposit/depositions',
          searchParams: optionsWithStrings
        });
        const depositions = await response.json();
        this.logger?.info(`Listed ${depositions.length} depositions`);
        return depositions.map(deposition => new Deposition(this, deposition));
      }
      /**
       * Create a new deposition
       * @param metadata - the metadata for the new deposition
       * @throws {Error} If the metadata is invalid or the request fails
       * @description Creates a new deposition with the provided metadata.
       * @returns The created deposition object
       */
      async createDeposition(metadata) {
        const response = await fetchZenodo(this, {
          route: 'deposit/depositions',
          expectedStatus: 201,
          method: 'POST',
          body: JSON.stringify({
            metadata
          })
        });
        const deposition = new Deposition(this, await response.json());
        this.logger?.info(`Created deposition ${deposition.value.id}`);
        return deposition;
      }
      /**
       * Retrieve a deposition by its ID
       * @param id - the deposition id
       * @throws {Error} If the deposition does not exist or the ID is undefined
       * @returns The retrieved deposition object
       */
      async retrieveDeposition(id) {
        const response = await fetchZenodo(this, {
          route: `deposit/depositions/${id}`
        });
        const deposition = await response.json();
        this.logger?.info(`Retrieved deposition ${id}`);
        return new Deposition(this, deposition);
      }
      /**
       * Retrieve a public deposition record
       * @param id - the deposition id
       * @param options - additional options for the request
       * @throws {Error} If the deposition does not exist or the ID is undefined
       * @returns The public deposition record
       */
      async retrieveRecord(id, options = {}) {
        const {
          isPublished = false
        } = options;
        const route = isPublished ? `records/${id}` : `records/${id}/draft`;
        const response = await fetchZenodo(this, {
          route
        });
        const deposition = await response.json();
        this.logger?.info(`Retrieved public deposition ${id}`);
        return new Record(this, deposition);
      }
      /**
       * List files in a deposition
       * @param depositionId - the deposition id to retrieve requests for
       * @returns An object containing the total number of requests and the list of requests
       */
      async retrieveRequests(depositionId) {
        const response = await fetchZenodo(this, {
          route: `requests/`,
          searchParams: {
            q: String(depositionId)
          }
        });
        const requests = await response.json();
        this.logger?.info(`Retrieved ${requests.hits.total} requests for deposition ${depositionId}`);
        return requests;
      }
      /**
       * Retrieve all versions of a deposition
       * @param id - the deposition id
       * @returns unvalidated array of deposition versions
       */
      async retrieveVersions(id) {
        const response = await fetchZenodo(this, {
          route: `records/${id}/versions`
        });
        const versions = await response.json();
        this.logger?.info(`Retrieved ${versions?.hits.total} versions for deposition ${id}`);
        return versions?.hits.hits || [];
      }
      /**
       * Deletes a deposition.
       * @param id - the deposition id
       * @throws {Error} If the deposition does not exist or the ID is undefined
       */
      async deleteDeposition(id) {
        await fetchZenodo(this, {
          method: 'DELETE',
          route: `deposit/depositions/${id}`,
          expectedStatus: 204
        });
        this.logger?.info(`Deleted deposition ${id}`);
      }
    }

    exports.Zenodo = Zenodo;
    exports.validateORCID = validateORCID;
    exports.validateZenodoDeposition = validateZenodoDeposition;
    exports.validateZenodoFile = validateZenodoFile;
    exports.validateZenodoMetadata = validateZenodoMetadata;
    exports.validateZenodoRecord = validateZenodoRecord;
    exports.validateZenodoRequest = validateZenodoRequest;
    exports.zipFiles = zipFiles;

}));
//# sourceMappingURL=zenodo.js.map
