!function(n,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports):"function"==typeof define&&define.amd?define(["exports"],t):t((n="undefined"!=typeof globalThis?globalThis:n||self).nmrProcessing={})}(this,(function(exports){"use strict";for(var IDX=256,HEX=[],BUFFER;IDX--;)HEX[IDX]=(IDX+256).toString(16).substring(1);function v4(){var n,t=0,e="";if(!BUFFER||IDX+16>256){for(BUFFER=Array(t=256);t--;)BUFFER[t]=256*Math.random()|0;t=IDX=0}for(;t<16;t++)n=BUFFER[IDX+t],e+=6==t?HEX[15&n|64]:8==t?HEX[63&n|128]:HEX[n],1&t&&t>1&&t<11&&(e+="-");return IDX++,e}function cloneData1D(n){const{x:t,re:e,im:i}=n||{x:[],re:[],im:[]};return{x:t.slice(),re:e.slice(),im:i?.slice()||null}}function cloneData2D(n){const t={};if(isData2DFt(n))for(const e in n)addCloneData(t,e,n[e]);else for(const e in n)addCloneData(t,e,n[e]);return t}function isData2DFt(n){return"re"in n}function addCloneData(n,t,e){if(e){const{z:i,...a}=e;n[t]={z:i.slice(),...a}}}function applyWindow(n,t){const e=n.length,{windowData:i,start:a=0,length:s=e,pointsToShift:r=0,output:o=new Float64Array(n)}=t,f=Math.min(a+s,e-r);for(let n=a,t=0;n<f;n++)o[n]*=i[t++];for(let n=e-1,t=0;n>e-r-1;n--)o[n]*=i[t++];return o}function getData(n,t){const e=new Float64Array(t);let i=Number.MIN_SAFE_INTEGER;for(let a=0;a<t;a++){const t=n(a);e[a]=t,t>i&&(i=t)}for(let n=0;n<t;n++)e[n]/=i;return e}function exponential$2(n){const{lb:t=.3,dw:e}=n,i=-t*Math.PI*e;return n=>Math.exp(i*n)}function ensureExponentialOptions(n,t){let{dw:e}=t;if(void 0===e){if(!("x"in n))throw new Error("dw should be defined");const{x:t}=n;e=t[1]-t[0]}return{kind:"exponential",options:{dw:e,...t}}}function lorentzToGauss(n){const{dw:t,length:e,gaussianHz:i=0,exponentialHz:a=0,center:s=0}=n;if(s>1||s<0)throw new Error("The center of gaussian shape should be inside of the window function: 0 - 1");const r=.6*Math.PI*i*t,o=s*(e-1),f=Math.PI*t*a;return n=>Math.exp(n*f-((o-n)*r)**2)}function ensureLorentzToGaussOptions(n,t){const{length:e=n.re.length}=t;let{dw:i}=t;if(void 0===i){if(!("x"in n))throw new Error("dw should be defined");{const{x:t}=n;i=t[1]-t[0]}}return{kind:"lorentzToGauss",options:{dw:i,length:e,...t}}}function modifiedGaussian(n){const{dwellTime:t,length:e,gaussianBroadening:i=.01,lineBroadening:a=-.01}=n,s=Math.PI*a,r=s*t/(2*i*e);return n=>Math.exp(-s*n*t+r*n**2)}function ensureModifiedGaussianOptions(n,t){const{length:e=n.re.length}=t;let{dwellTime:i}=t;if(void 0===i){if(!("x"in n))throw new Error("dwellTime should be defined");{const{x:t}=n;i=t[1]-t[0]}}return{kind:"modifiedGaussian",options:{dwellTime:i,length:e,...t}}}function sineBell(n){const{exponent:t=1,offset:e=0,end:i=1,length:a}=n;if(void 0===a)throw new Error("length options should exists for sineBell shape");if(i<0||i>1)throw new Error("the end parameter should be [0-1]");const s=Math.PI*e,r=Math.PI*(i-e)/(a-1);return n=>Math.sin(s+r*n)**t}function ensureSineBellOptions(n,t){const{length:e=n.re.length}=t;return{kind:"sineBell",options:{length:e,...t}}}function traf(n){const{length:t,lb:e=1,dw:i}=n,a=-i/e;return n=>{const e=Math.exp(a*n);return e/(e**2+Math.exp(-a*(n-t))**2)}}function ensureTrafOptions(n,t){let{dw:e}=t;const{length:i=n.re.length}=t;if(void 0===e){if(!("x"in n))throw new Error("dw should be defined");{const{x:t}=n;e=t[1]-t[0]}}return{kind:"traf",options:{dw:e,length:i,...t}}}function getFunction(n){const{kind:t,options:e}=n;switch(t){case"exponential":return exponential$2(e);case"modifiedGaussian":return modifiedGaussian(e);case"lorentzToGauss":return lorentzToGauss(e);case"sineBell":return sineBell(e);case"traf":return traf(e);default:throw Error(`Unknown distribution ${t}`)}}function compose(n){const{length:t,shapes:e=[]}=n,i=new Float64Array(t).fill(1);return e.forEach((n=>{const{shape:e,start:a=0}=n,{options:s}=e,r="length"in s?s.length:t-a,o=getData(getFunction(e),r);applyWindow(i,{windowData:o,length:r,start:a,output:i})})),i}const optionsInsurance={exponential:ensureExponentialOptions,lorentzToGauss:ensureLorentzToGaussOptions,sineBell:ensureSineBellOptions,traf:ensureTrafOptions,modifiedGaussian:ensureModifiedGaussianOptions};function ensureShapeOptions(n,t){const{kind:e,options:i}=t;if(!(e in optionsInsurance))throw new Error(`shape ${e} is not supported`);return optionsInsurance[e](n,i)}function ensureComposeOptions(n,t){const{shapes:e=[],length:i=n.re.length,...a}=t,s=[];for(const t of e){const{shape:e,...i}=t;s.push({...i,shape:ensureShapeOptions(n,e)})}return{...a,shapes:s,length:i}}function apodization$1(n,t={}){const{apply:e=!0,pointsToShift:i,compose:a,windowData:s=a&&compose(ensureComposeOptions(n,a))}=t;if(!s)return{...n,windowData:new Float64Array(n.re.length).fill(1)};const r={windowData:s,pointsToShift:i},o=e?applyWindow(n.re,r):n.re,f=e?applyWindow(n.im,r):n.im;return{...n,re:o,im:f,windowData:s}}function apodizationFilter(n,t){const{lineBroadening:e,gaussBroadening:i,lineBroadeningCenter:a}=t,s=n.filters?.find((n=>"digitalFilter"===n.name&&n.flag)),r=s?Math.floor(s.value.digitalFilterValue):0,o=n.data.re,f=n.data.im,l=n.data.x,d=o.length;return apodization$1({re:o,im:f},{pointsToShift:r,compose:{length:d,shapes:[{start:0,shape:{kind:"lorentzToGauss",options:{length:d,dw:(l[d-1]-l[0])/(d-1),exponentialHz:i>0?e:-e,gaussianHz:i,center:a}}}]}})}const id$q="apodization",name$q="Apodization",DOMAIN_UPDATE_RULES$q={updateXDomain:!0,updateYDomain:!1};function apply$r(n,t){if(!isApplicable$q(n))throw new Error("apodization not applicable on this data");const{lineBroadening:e=1,gaussBroadening:i=0,lineBroadeningCenter:a=0}=t;if(0===Object.keys(t).length){const t=n.filters?.find((n=>n.name===id$q));t&&(t.value={lineBroadening:e,gaussBroadening:i,lineBroadeningCenter:a})}const s=apodizationFilter(n,{lineBroadening:e,gaussBroadening:i,lineBroadeningCenter:a});n.data={...n.data,re:s.re,im:s.im}}function isApplicable$q(n){return!(!n.info.isComplex||!n.info.isFid)}function reduce$q(n,t){return{once:!0,reduce:t}}var apodization=Object.freeze({__proto__:null,id:id$q,name:name$q,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$q,apply:apply$r,isApplicable:isApplicable$q,reduce:reduce$q});function reimAbsolute(n){const t=n.re.length,e=n.re,i=n.im,a=new Float64Array(t);for(let n=0;n<t;n++)a[n]=Math.sqrt(e[n]**2+i[n]**2);return a}const toString$2=Object.prototype.toString;function isAnyArray$1(n){const t=toString$2.call(n);return t.endsWith("Array]")&&!t.includes("Big")}var libEsm=Object.freeze({__proto__:null,isAnyArray:isAnyArray$1});function getOutputArray(n,t){if(void 0!==n){if(!isAnyArray$1(n))throw new TypeError("output option must be an array if specified");if(n.length!==t)throw new TypeError("the output array does not have the correct length");return n}return new Float64Array(t)}function xAbsolute(n){const t=n.slice();for(let n=0;n<t.length;n++)t[n]<0&&(t[n]*=-1);return t}function xMedian(n){if(!isAnyArray$1(n))throw new TypeError("input must be an array");if(0===n.length)throw new TypeError("input must not be empty");const t=n.slice();let e=0,i=t.length-1,a=0,s=0,r=0;const o=calcMiddle(e,i);for(;;){if(i<=e)return t[o];if(i===e+1)return t[e]>t[i]&&swap(t,e,i),t[o];for(a=calcMiddle(e,i),t[a]>t[i]&&swap(t,a,i),t[e]>t[i]&&swap(t,e,i),t[a]>t[e]&&swap(t,a,e),swap(t,a,e+1),s=e+1,r=i;;){do{s++}while(t[e]>t[s]);do{r--}while(t[r]>t[e]);if(r<s)break;swap(t,s,r)}swap(t,e,r),r<=o&&(e=s),r>=o&&(i=r-1)}}function swap(n,t,e){const i=n[e];n[e]=n[t],n[t]=i}function calcMiddle(n,t){return Math.floor((n+t)/2)}function xAbsoluteMedian(n){return xMedian(xAbsolute(n))}function xCheck(n,t={}){const{minLength:e}=t;if(!isAnyArray$1(n))throw new TypeError("input must be an array");if(0===n.length)throw new TypeError("input must not be empty");if("number"!=typeof n[0])throw new TypeError("input must contain numbers");if(e&&n.length<e)throw new Error(`input must have a length of at least ${e}`)}function xFindClosestIndex(n,t,e={}){const{sorted:i=!0}=e;if(i){let e=0,i=n.length-1,a=0;for(;i-e>1;)if(a=e+(i-e>>1),n[a]<t)e=a;else{if(!(n[a]>t))return a;i=a}return e<n.length-1?Math.abs(t-n[e])<Math.abs(n[e+1]-t)?e:e+1:e}{let e=0,i=Number.POSITIVE_INFINITY;for(let a=0;a<n.length;a++){const s=Math.abs(n[a]-t);s<i&&(i=s,e=a)}return e}}function xGetFromToIndex(n,t={}){let{fromIndex:e,toIndex:i}=t;const{from:a,to:s}=t;return void 0===e&&(e=void 0!==a?xFindClosestIndex(n,a):0),void 0===i&&(i=void 0!==s?xFindClosestIndex(n,s):n.length-1),e<0&&(e=0),i<0&&(i=0),e>=n.length&&(e=n.length-1),i>=n.length&&(i=n.length-1),e>i&&([e,i]=[i,e]),{fromIndex:e,toIndex:i}}function xAbsoluteSum(n,t={}){xCheck(n);const{fromIndex:e,toIndex:i}=xGetFromToIndex(n,t);let a=0;for(let t=e;t<=i;t++)n[t]<0?a-=n[t]:a+=n[t];return a}function xAdd(n,t){let e=!1,i=0;if(isAnyArray$1(t)){if(n.length!==t.length)throw new Error("size of array1 and array2 must be identical")}else e=!0,i=t;const a=new Float64Array(n.length);if(e)for(let t=0;t<n.length;t++)a[t]=n[t]+i;else for(let e=0;e<n.length;e++)a[e]=n[e]+t[e];return a}function xApplyFunctionStr(n,t={}){const{variableLabel:e="x",fctString:i=e}=t,a=new Function(e,`return Number(${i.replace(/(?<before>^|\W)(?<after>[\da-z]{2,}\()/g,"$<before>Math.$<after>").replace(/Math\.Math/g,"Math")})`),s=Float64Array.from(n);for(let t=0;t<n.length;t++)if(s[t]=a(n[t]),Number.isNaN(s[t]))throw new Error(`The callback ${i} does not return a number: ${n[t]}`);return s}function xMultiply(n,t,e={}){let i=!1,a=0;if(isAnyArray$1(t)){if(n.length!==t.length)throw new Error("size of array1 and array2 must be identical")}else i=!0,a=Number(t);const s=getOutputArray(e.output,n.length);if(i)for(let t=0;t<n.length;t++)s[t]=n[t]*a;else for(let e=0;e<n.length;e++)s[e]=n[e]*t[e];return s}function xBoxPlot(n,t={}){const{allowSmallArray:e=!1}=t;if(n.length<5){if(!e)throw new Error("can not calculate info if array contains less than 5 elements");if(n.length<1)throw new Error("can not calculate info if array is empty")}const i={q1:0,median:0,q3:0,min:(n=Float64Array.from(n).sort())[0],max:n[n.length-1]};let a,s;if(n.length%2==1){const t=(n.length-1)/2;i.median=n[t],a=Math.max(t-1,0),s=Math.min(t+1,n.length-1)}else s=n.length/2,a=s-1,i.median=(n[a]+n[s])/2;if(a%2==0)i.q1=n[a/2],i.q3=n[(n.length+s-1)/2];else{i.q1=(n[(a+1)/2]+n[(a-1)/2])/2;const t=(n.length+s)/2;i.q3=(n[t]+n[t-1])/2}return i}function xCorrelation(n,t){const e=n.length;let i=0,a=0,s=0,r=0,o=0;for(let f=0;f<e;f++){const e=n[f],l=t[f];i+=e,a+=e**2,s+=l,r+=l**2,o+=e*l}return(e*o-i*s)/(Math.sqrt(e*a-i**2)*Math.sqrt(e*r-s**2))}var commonjsGlobal="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function getAugmentedNamespace(n){if(n.__esModule)return n;var t=Object.defineProperty({},"__esModule",{value:!0});return Object.keys(n).forEach((function(e){var i=Object.getOwnPropertyDescriptor(n,e);Object.defineProperty(t,e,i.get?i:{enumerable:!0,get:function(){return n[e]}})})),t}var matrix={},require$$0=getAugmentedNamespace(libEsm);function max(n){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isAnyArray$1(n))throw new TypeError("input must be an array");if(0===n.length)throw new TypeError("input must not be empty");var e=t.fromIndex,i=void 0===e?0:e,a=t.toIndex,s=void 0===a?n.length:a;if(i<0||i>=n.length||!Number.isInteger(i))throw new Error("fromIndex must be a positive integer smaller than length");if(s<=i||s>n.length||!Number.isInteger(s))throw new Error("toIndex must be an integer greater than fromIndex and at most equal to length");for(var r=n[i],o=i+1;o<s;o++)n[o]>r&&(r=n[o]);return r}function min(n){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isAnyArray$1(n))throw new TypeError("input must be an array");if(0===n.length)throw new TypeError("input must not be empty");var e=t.fromIndex,i=void 0===e?0:e,a=t.toIndex,s=void 0===a?n.length:a;if(i<0||i>=n.length||!Number.isInteger(i))throw new Error("fromIndex must be a positive integer smaller than length");if(s<=i||s>n.length||!Number.isInteger(s))throw new Error("toIndex must be an integer greater than fromIndex and at most equal to length");for(var r=n[i],o=i+1;o<s;o++)n[o]<r&&(r=n[o]);return r}function rescale$2(n){var t,e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isAnyArray$1(n))throw new TypeError("input must be an array");if(0===n.length)throw new TypeError("input must not be empty");if(void 0!==e.output){if(!isAnyArray$1(e.output))throw new TypeError("output option must be an array if specified");t=e.output}else t=new Array(n.length);var i=min(n),a=max(n);if(i===a)throw new RangeError("minimum and maximum input values are equal. Cannot rescale a constant array");var s=e.min,r=void 0===s?e.autoMinMax?i:0:s,o=e.max,f=void 0===o?e.autoMinMax?a:1:o;if(r>=f)throw new RangeError("min option must be smaller than max option");for(var l=(f-r)/(a-i),d=0;d<n.length;d++)t[d]=(n[d]-i)*l+r;return t}var libEs6=Object.freeze({__proto__:null,default:rescale$2}),require$$1=getAugmentedNamespace(libEs6);Object.defineProperty(matrix,"__esModule",{value:!0});var isAnyArray=require$$0,rescale$1=require$$1;const indent=" ".repeat(2),indentData=" ".repeat(4);function inspectMatrix(){return inspectMatrixWithOptions(this)}function inspectMatrixWithOptions(n,t={}){const{maxRows:e=15,maxColumns:i=10,maxNumSize:a=8,padMinus:s="auto"}=t;return`${n.constructor.name} {\n${indent}[\n${indentData}${inspectData(n,e,i,a,s)}\n${indent}]\n${indent}rows: ${n.rows}\n${indent}columns: ${n.columns}\n}`}function inspectData(n,t,e,i,a){const{rows:s,columns:r}=n,o=Math.min(s,t),f=Math.min(r,e),l=[];if("auto"===a){a=!1;n:for(let t=0;t<o;t++)for(let e=0;e<f;e++)if(n.get(t,e)<0){a=!0;break n}}for(let t=0;t<o;t++){let e=[];for(let s=0;s<f;s++)e.push(formatNumber(n.get(t,s),i,a));l.push(`${e.join(" ")}`)}return f!==r&&(l[l.length-1]+=` ... ${r-e} more columns`),o!==s&&l.push(`... ${s-t} more rows`),l.join(`\n${indentData}`)}function formatNumber(n,t,e){return(n>=0&&e?` ${formatNumber2(n,t-1)}`:formatNumber2(n,t)).padEnd(t)}function formatNumber2(n,t){let e=n.toString();if(e.length<=t)return e;let i=n.toFixed(t);if(i.length>t&&(i=n.toFixed(Math.max(0,t-(i.length-t)))),i.length<=t&&!i.startsWith("0.000")&&!i.startsWith("-0.000"))return i;let a=n.toExponential(t);return a.length>t&&(a=n.toExponential(Math.max(0,t-(a.length-t)))),a.slice(0)}function installMathOperations(n,t){n.prototype.add=function(n){return"number"==typeof n?this.addS(n):this.addM(n)},n.prototype.addS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)+n);return this},n.prototype.addM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)+n.get(t,e));return this},n.add=function(n,e){return new t(n).add(e)},n.prototype.sub=function(n){return"number"==typeof n?this.subS(n):this.subM(n)},n.prototype.subS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)-n);return this},n.prototype.subM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)-n.get(t,e));return this},n.sub=function(n,e){return new t(n).sub(e)},n.prototype.subtract=n.prototype.sub,n.prototype.subtractS=n.prototype.subS,n.prototype.subtractM=n.prototype.subM,n.subtract=n.sub,n.prototype.mul=function(n){return"number"==typeof n?this.mulS(n):this.mulM(n)},n.prototype.mulS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)*n);return this},n.prototype.mulM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)*n.get(t,e));return this},n.mul=function(n,e){return new t(n).mul(e)},n.prototype.multiply=n.prototype.mul,n.prototype.multiplyS=n.prototype.mulS,n.prototype.multiplyM=n.prototype.mulM,n.multiply=n.mul,n.prototype.div=function(n){return"number"==typeof n?this.divS(n):this.divM(n)},n.prototype.divS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)/n);return this},n.prototype.divM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)/n.get(t,e));return this},n.div=function(n,e){return new t(n).div(e)},n.prototype.divide=n.prototype.div,n.prototype.divideS=n.prototype.divS,n.prototype.divideM=n.prototype.divM,n.divide=n.div,n.prototype.mod=function(n){return"number"==typeof n?this.modS(n):this.modM(n)},n.prototype.modS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)%n);return this},n.prototype.modM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)%n.get(t,e));return this},n.mod=function(n,e){return new t(n).mod(e)},n.prototype.modulus=n.prototype.mod,n.prototype.modulusS=n.prototype.modS,n.prototype.modulusM=n.prototype.modM,n.modulus=n.mod,n.prototype.and=function(n){return"number"==typeof n?this.andS(n):this.andM(n)},n.prototype.andS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)&n);return this},n.prototype.andM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)&n.get(t,e));return this},n.and=function(n,e){return new t(n).and(e)},n.prototype.or=function(n){return"number"==typeof n?this.orS(n):this.orM(n)},n.prototype.orS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)|n);return this},n.prototype.orM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)|n.get(t,e));return this},n.or=function(n,e){return new t(n).or(e)},n.prototype.xor=function(n){return"number"==typeof n?this.xorS(n):this.xorM(n)},n.prototype.xorS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)^n);return this},n.prototype.xorM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)^n.get(t,e));return this},n.xor=function(n,e){return new t(n).xor(e)},n.prototype.leftShift=function(n){return"number"==typeof n?this.leftShiftS(n):this.leftShiftM(n)},n.prototype.leftShiftS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)<<n);return this},n.prototype.leftShiftM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)<<n.get(t,e));return this},n.leftShift=function(n,e){return new t(n).leftShift(e)},n.prototype.signPropagatingRightShift=function(n){return"number"==typeof n?this.signPropagatingRightShiftS(n):this.signPropagatingRightShiftM(n)},n.prototype.signPropagatingRightShiftS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)>>n);return this},n.prototype.signPropagatingRightShiftM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)>>n.get(t,e));return this},n.signPropagatingRightShift=function(n,e){return new t(n).signPropagatingRightShift(e)},n.prototype.rightShift=function(n){return"number"==typeof n?this.rightShiftS(n):this.rightShiftM(n)},n.prototype.rightShiftS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)>>>n);return this},n.prototype.rightShiftM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)>>>n.get(t,e));return this},n.rightShift=function(n,e){return new t(n).rightShift(e)},n.prototype.zeroFillRightShift=n.prototype.rightShift,n.prototype.zeroFillRightShiftS=n.prototype.rightShiftS,n.prototype.zeroFillRightShiftM=n.prototype.rightShiftM,n.zeroFillRightShift=n.rightShift,n.prototype.not=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,~this.get(n,t));return this},n.not=function(n){return new t(n).not()},n.prototype.abs=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.abs(this.get(n,t)));return this},n.abs=function(n){return new t(n).abs()},n.prototype.acos=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.acos(this.get(n,t)));return this},n.acos=function(n){return new t(n).acos()},n.prototype.acosh=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.acosh(this.get(n,t)));return this},n.acosh=function(n){return new t(n).acosh()},n.prototype.asin=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.asin(this.get(n,t)));return this},n.asin=function(n){return new t(n).asin()},n.prototype.asinh=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.asinh(this.get(n,t)));return this},n.asinh=function(n){return new t(n).asinh()},n.prototype.atan=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.atan(this.get(n,t)));return this},n.atan=function(n){return new t(n).atan()},n.prototype.atanh=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.atanh(this.get(n,t)));return this},n.atanh=function(n){return new t(n).atanh()},n.prototype.cbrt=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.cbrt(this.get(n,t)));return this},n.cbrt=function(n){return new t(n).cbrt()},n.prototype.ceil=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.ceil(this.get(n,t)));return this},n.ceil=function(n){return new t(n).ceil()},n.prototype.clz32=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.clz32(this.get(n,t)));return this},n.clz32=function(n){return new t(n).clz32()},n.prototype.cos=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.cos(this.get(n,t)));return this},n.cos=function(n){return new t(n).cos()},n.prototype.cosh=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.cosh(this.get(n,t)));return this},n.cosh=function(n){return new t(n).cosh()},n.prototype.exp=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.exp(this.get(n,t)));return this},n.exp=function(n){return new t(n).exp()},n.prototype.expm1=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.expm1(this.get(n,t)));return this},n.expm1=function(n){return new t(n).expm1()},n.prototype.floor=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.floor(this.get(n,t)));return this},n.floor=function(n){return new t(n).floor()},n.prototype.fround=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.fround(this.get(n,t)));return this},n.fround=function(n){return new t(n).fround()},n.prototype.log=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.log(this.get(n,t)));return this},n.log=function(n){return new t(n).log()},n.prototype.log1p=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.log1p(this.get(n,t)));return this},n.log1p=function(n){return new t(n).log1p()},n.prototype.log10=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.log10(this.get(n,t)));return this},n.log10=function(n){return new t(n).log10()},n.prototype.log2=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.log2(this.get(n,t)));return this},n.log2=function(n){return new t(n).log2()},n.prototype.round=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.round(this.get(n,t)));return this},n.round=function(n){return new t(n).round()},n.prototype.sign=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.sign(this.get(n,t)));return this},n.sign=function(n){return new t(n).sign()},n.prototype.sin=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.sin(this.get(n,t)));return this},n.sin=function(n){return new t(n).sin()},n.prototype.sinh=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.sinh(this.get(n,t)));return this},n.sinh=function(n){return new t(n).sinh()},n.prototype.sqrt=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.sqrt(this.get(n,t)));return this},n.sqrt=function(n){return new t(n).sqrt()},n.prototype.tan=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.tan(this.get(n,t)));return this},n.tan=function(n){return new t(n).tan()},n.prototype.tanh=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.tanh(this.get(n,t)));return this},n.tanh=function(n){return new t(n).tanh()},n.prototype.trunc=function(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)this.set(n,t,Math.trunc(this.get(n,t)));return this},n.trunc=function(n){return new t(n).trunc()},n.pow=function(n,e){return new t(n).pow(e)},n.prototype.pow=function(n){return"number"==typeof n?this.powS(n):this.powM(n)},n.prototype.powS=function(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)**n);return this},n.prototype.powM=function(n){if(n=t.checkMatrix(n),this.rows!==n.rows||this.columns!==n.columns)throw new RangeError("Matrices dimensions must be equal");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)**n.get(t,e));return this}}function checkRowIndex(n,t,e){let i=e?n.rows:n.rows-1;if(t<0||t>i)throw new RangeError("Row index out of range")}function checkColumnIndex(n,t,e){let i=e?n.columns:n.columns-1;if(t<0||t>i)throw new RangeError("Column index out of range")}function checkRowVector(n,t){if(t.to1DArray&&(t=t.to1DArray()),t.length!==n.columns)throw new RangeError("vector size must be the same as the number of columns");return t}function checkColumnVector(n,t){if(t.to1DArray&&(t=t.to1DArray()),t.length!==n.rows)throw new RangeError("vector size must be the same as the number of rows");return t}function checkRowIndices(n,t){if(!isAnyArray.isAnyArray(t))throw new TypeError("row indices must be an array");for(let e=0;e<t.length;e++)if(t[e]<0||t[e]>=n.rows)throw new RangeError("row indices are out of range")}function checkColumnIndices(n,t){if(!isAnyArray.isAnyArray(t))throw new TypeError("column indices must be an array");for(let e=0;e<t.length;e++)if(t[e]<0||t[e]>=n.columns)throw new RangeError("column indices are out of range")}function checkRange(n,t,e,i,a){if(5!==arguments.length)throw new RangeError("expected 4 arguments");if(checkNumber("startRow",t),checkNumber("endRow",e),checkNumber("startColumn",i),checkNumber("endColumn",a),t>e||i>a||t<0||t>=n.rows||e<0||e>=n.rows||i<0||i>=n.columns||a<0||a>=n.columns)throw new RangeError("Submatrix indices are out of range")}function newArray$1(n,t=0){let e=[];for(let i=0;i<n;i++)e.push(t);return e}function checkNumber(n,t){if("number"!=typeof t)throw new TypeError(`${n} must be a number`)}function checkNonEmpty(n){if(n.isEmpty())throw new Error("Empty matrix has no elements to index")}function sumByRow(n){let t=newArray$1(n.rows);for(let e=0;e<n.rows;++e)for(let i=0;i<n.columns;++i)t[e]+=n.get(e,i);return t}function sumByColumn(n){let t=newArray$1(n.columns);for(let e=0;e<n.rows;++e)for(let i=0;i<n.columns;++i)t[i]+=n.get(e,i);return t}function sumAll(n){let t=0;for(let e=0;e<n.rows;e++)for(let i=0;i<n.columns;i++)t+=n.get(e,i);return t}function productByRow(n){let t=newArray$1(n.rows,1);for(let e=0;e<n.rows;++e)for(let i=0;i<n.columns;++i)t[e]*=n.get(e,i);return t}function productByColumn(n){let t=newArray$1(n.columns,1);for(let e=0;e<n.rows;++e)for(let i=0;i<n.columns;++i)t[i]*=n.get(e,i);return t}function productAll(n){let t=1;for(let e=0;e<n.rows;e++)for(let i=0;i<n.columns;i++)t*=n.get(e,i);return t}function varianceByRow(n,t,e){const i=n.rows,a=n.columns,s=[];for(let r=0;r<i;r++){let i=0,o=0,f=0;for(let t=0;t<a;t++)f=n.get(r,t)-e[r],i+=f,o+=f*f;t?s.push((o-i*i/a)/(a-1)):s.push((o-i*i/a)/a)}return s}function varianceByColumn(n,t,e){const i=n.rows,a=n.columns,s=[];for(let r=0;r<a;r++){let a=0,o=0,f=0;for(let t=0;t<i;t++)f=n.get(t,r)-e[r],a+=f,o+=f*f;t?s.push((o-a*a/i)/(i-1)):s.push((o-a*a/i)/i)}return s}function varianceAll(n,t,e){const i=n.rows,a=n.columns,s=i*a;let r=0,o=0,f=0;for(let t=0;t<i;t++)for(let i=0;i<a;i++)f=n.get(t,i)-e,r+=f,o+=f*f;return t?(o-r*r/s)/(s-1):(o-r*r/s)/s}function centerByRow(n,t){for(let e=0;e<n.rows;e++)for(let i=0;i<n.columns;i++)n.set(e,i,n.get(e,i)-t[e])}function centerByColumn(n,t){for(let e=0;e<n.rows;e++)for(let i=0;i<n.columns;i++)n.set(e,i,n.get(e,i)-t[i])}function centerAll(n,t){for(let e=0;e<n.rows;e++)for(let i=0;i<n.columns;i++)n.set(e,i,n.get(e,i)-t)}function getScaleByRow(n){const t=[];for(let e=0;e<n.rows;e++){let i=0;for(let t=0;t<n.columns;t++)i+=n.get(e,t)**2/(n.columns-1);t.push(Math.sqrt(i))}return t}function scaleByRow(n,t){for(let e=0;e<n.rows;e++)for(let i=0;i<n.columns;i++)n.set(e,i,n.get(e,i)/t[e])}function getScaleByColumn(n){const t=[];for(let e=0;e<n.columns;e++){let i=0;for(let t=0;t<n.rows;t++)i+=n.get(t,e)**2/(n.rows-1);t.push(Math.sqrt(i))}return t}function scaleByColumn(n,t){for(let e=0;e<n.rows;e++)for(let i=0;i<n.columns;i++)n.set(e,i,n.get(e,i)/t[i])}function getScaleAll(n){const t=n.size-1;let e=0;for(let i=0;i<n.columns;i++)for(let a=0;a<n.rows;a++)e+=n.get(a,i)**2/t;return Math.sqrt(e)}function scaleAll(n,t){for(let e=0;e<n.rows;e++)for(let i=0;i<n.columns;i++)n.set(e,i,n.get(e,i)/t)}class AbstractMatrix{static from1DArray(n,t,e){if(n*t!==e.length)throw new RangeError("data length does not match given dimensions");let i=new Matrix$2(n,t);for(let a=0;a<n;a++)for(let n=0;n<t;n++)i.set(a,n,e[a*t+n]);return i}static rowVector(n){let t=new Matrix$2(1,n.length);for(let e=0;e<n.length;e++)t.set(0,e,n[e]);return t}static columnVector(n){let t=new Matrix$2(n.length,1);for(let e=0;e<n.length;e++)t.set(e,0,n[e]);return t}static zeros(n,t){return new Matrix$2(n,t)}static ones(n,t){return new Matrix$2(n,t).fill(1)}static rand(n,t,e={}){if("object"!=typeof e)throw new TypeError("options must be an object");const{random:i=Math.random}=e;let a=new Matrix$2(n,t);for(let e=0;e<n;e++)for(let n=0;n<t;n++)a.set(e,n,i());return a}static randInt(n,t,e={}){if("object"!=typeof e)throw new TypeError("options must be an object");const{min:i=0,max:a=1e3,random:s=Math.random}=e;if(!Number.isInteger(i))throw new TypeError("min must be an integer");if(!Number.isInteger(a))throw new TypeError("max must be an integer");if(i>=a)throw new RangeError("min must be smaller than max");let r=a-i,o=new Matrix$2(n,t);for(let e=0;e<n;e++)for(let n=0;n<t;n++){let t=i+Math.round(s()*r);o.set(e,n,t)}return o}static eye(n,t,e){void 0===t&&(t=n),void 0===e&&(e=1);let i=Math.min(n,t),a=this.zeros(n,t);for(let n=0;n<i;n++)a.set(n,n,e);return a}static diag(n,t,e){let i=n.length;void 0===t&&(t=i),void 0===e&&(e=t);let a=Math.min(i,t,e),s=this.zeros(t,e);for(let t=0;t<a;t++)s.set(t,t,n[t]);return s}static min(n,t){n=this.checkMatrix(n),t=this.checkMatrix(t);let e=n.rows,i=n.columns,a=new Matrix$2(e,i);for(let s=0;s<e;s++)for(let e=0;e<i;e++)a.set(s,e,Math.min(n.get(s,e),t.get(s,e)));return a}static max(n,t){n=this.checkMatrix(n),t=this.checkMatrix(t);let e=n.rows,i=n.columns,a=new this(e,i);for(let s=0;s<e;s++)for(let e=0;e<i;e++)a.set(s,e,Math.max(n.get(s,e),t.get(s,e)));return a}static checkMatrix(n){return AbstractMatrix.isMatrix(n)?n:new Matrix$2(n)}static isMatrix(n){return null!=n&&"Matrix"===n.klass}get size(){return this.rows*this.columns}apply(n){if("function"!=typeof n)throw new TypeError("callback must be a function");for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)n.call(this,t,e);return this}to1DArray(){let n=[];for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)n.push(this.get(t,e));return n}to2DArray(){let n=[];for(let t=0;t<this.rows;t++){n.push([]);for(let e=0;e<this.columns;e++)n[t].push(this.get(t,e))}return n}toJSON(){return this.to2DArray()}isRowVector(){return 1===this.rows}isColumnVector(){return 1===this.columns}isVector(){return 1===this.rows||1===this.columns}isSquare(){return this.rows===this.columns}isEmpty(){return 0===this.rows||0===this.columns}isSymmetric(){if(this.isSquare()){for(let n=0;n<this.rows;n++)for(let t=0;t<=n;t++)if(this.get(n,t)!==this.get(t,n))return!1;return!0}return!1}isDistance(){if(!this.isSymmetric())return!1;for(let n=0;n<this.rows;n++)if(0!==this.get(n,n))return!1;return!0}isEchelonForm(){let n=0,t=0,e=-1,i=!0,a=!1;for(;n<this.rows&&i;){for(t=0,a=!1;t<this.columns&&!1===a;)0===this.get(n,t)?t++:1===this.get(n,t)&&t>e?(a=!0,e=t):(i=!1,a=!0);n++}return i}isReducedEchelonForm(){let n=0,t=0,e=-1,i=!0,a=!1;for(;n<this.rows&&i;){for(t=0,a=!1;t<this.columns&&!1===a;)0===this.get(n,t)?t++:1===this.get(n,t)&&t>e?(a=!0,e=t):(i=!1,a=!0);for(let e=t+1;e<this.rows;e++)0!==this.get(n,e)&&(i=!1);n++}return i}echelonForm(){let n=this.clone(),t=0,e=0;for(;t<n.rows&&e<n.columns;){let i=t;for(let a=t;a<n.rows;a++)n.get(a,e)>n.get(i,e)&&(i=a);if(0===n.get(i,e))e++;else{n.swapRows(t,i);let a=n.get(t,e);for(let i=e;i<n.columns;i++)n.set(t,i,n.get(t,i)/a);for(let i=t+1;i<n.rows;i++){let a=n.get(i,e)/n.get(t,e);n.set(i,e,0);for(let s=e+1;s<n.columns;s++)n.set(i,s,n.get(i,s)-n.get(t,s)*a)}t++,e++}}return n}reducedEchelonForm(){let n=this.echelonForm(),t=n.columns,e=n.rows,i=e-1;for(;i>=0;)if(0===n.maxRow(i))i--;else{let a=0,s=!1;for(;a<e&&!1===s;)1===n.get(i,a)?s=!0:a++;for(let e=0;e<i;e++){let s=n.get(e,a);for(let r=a;r<t;r++){let t=n.get(e,r)-s*n.get(i,r);n.set(e,r,t)}}i--}return n}set(){throw new Error("set method is unimplemented")}get(){throw new Error("get method is unimplemented")}repeat(n={}){if("object"!=typeof n)throw new TypeError("options must be an object");const{rows:t=1,columns:e=1}=n;if(!Number.isInteger(t)||t<=0)throw new TypeError("rows must be a positive integer");if(!Number.isInteger(e)||e<=0)throw new TypeError("columns must be a positive integer");let i=new Matrix$2(this.rows*t,this.columns*e);for(let n=0;n<t;n++)for(let t=0;t<e;t++)i.setSubMatrix(this,this.rows*n,this.columns*t);return i}fill(n){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,n);return this}neg(){return this.mulS(-1)}getRow(n){checkRowIndex(this,n);let t=[];for(let e=0;e<this.columns;e++)t.push(this.get(n,e));return t}getRowVector(n){return Matrix$2.rowVector(this.getRow(n))}setRow(n,t){checkRowIndex(this,n),t=checkRowVector(this,t);for(let e=0;e<this.columns;e++)this.set(n,e,t[e]);return this}swapRows(n,t){checkRowIndex(this,n),checkRowIndex(this,t);for(let e=0;e<this.columns;e++){let i=this.get(n,e);this.set(n,e,this.get(t,e)),this.set(t,e,i)}return this}getColumn(n){checkColumnIndex(this,n);let t=[];for(let e=0;e<this.rows;e++)t.push(this.get(e,n));return t}getColumnVector(n){return Matrix$2.columnVector(this.getColumn(n))}setColumn(n,t){checkColumnIndex(this,n),t=checkColumnVector(this,t);for(let e=0;e<this.rows;e++)this.set(e,n,t[e]);return this}swapColumns(n,t){checkColumnIndex(this,n),checkColumnIndex(this,t);for(let e=0;e<this.rows;e++){let i=this.get(e,n);this.set(e,n,this.get(e,t)),this.set(e,t,i)}return this}addRowVector(n){n=checkRowVector(this,n);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)+n[e]);return this}subRowVector(n){n=checkRowVector(this,n);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)-n[e]);return this}mulRowVector(n){n=checkRowVector(this,n);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)*n[e]);return this}divRowVector(n){n=checkRowVector(this,n);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)/n[e]);return this}addColumnVector(n){n=checkColumnVector(this,n);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)+n[t]);return this}subColumnVector(n){n=checkColumnVector(this,n);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)-n[t]);return this}mulColumnVector(n){n=checkColumnVector(this,n);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)*n[t]);return this}divColumnVector(n){n=checkColumnVector(this,n);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,this.get(t,e)/n[t]);return this}mulRow(n,t){checkRowIndex(this,n);for(let e=0;e<this.columns;e++)this.set(n,e,this.get(n,e)*t);return this}mulColumn(n,t){checkColumnIndex(this,n);for(let e=0;e<this.rows;e++)this.set(e,n,this.get(e,n)*t);return this}max(n){if(this.isEmpty())return NaN;switch(n){case"row":{const n=new Array(this.rows).fill(Number.NEGATIVE_INFINITY);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.get(t,e)>n[t]&&(n[t]=this.get(t,e));return n}case"column":{const n=new Array(this.columns).fill(Number.NEGATIVE_INFINITY);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.get(t,e)>n[e]&&(n[e]=this.get(t,e));return n}case void 0:{let n=this.get(0,0);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.get(t,e)>n&&(n=this.get(t,e));return n}default:throw new Error(`invalid option: ${n}`)}}maxIndex(){checkNonEmpty(this);let n=this.get(0,0),t=[0,0];for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.get(e,i)>n&&(n=this.get(e,i),t[0]=e,t[1]=i);return t}min(n){if(this.isEmpty())return NaN;switch(n){case"row":{const n=new Array(this.rows).fill(Number.POSITIVE_INFINITY);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.get(t,e)<n[t]&&(n[t]=this.get(t,e));return n}case"column":{const n=new Array(this.columns).fill(Number.POSITIVE_INFINITY);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.get(t,e)<n[e]&&(n[e]=this.get(t,e));return n}case void 0:{let n=this.get(0,0);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.get(t,e)<n&&(n=this.get(t,e));return n}default:throw new Error(`invalid option: ${n}`)}}minIndex(){checkNonEmpty(this);let n=this.get(0,0),t=[0,0];for(let e=0;e<this.rows;e++)for(let i=0;i<this.columns;i++)this.get(e,i)<n&&(n=this.get(e,i),t[0]=e,t[1]=i);return t}maxRow(n){if(checkRowIndex(this,n),this.isEmpty())return NaN;let t=this.get(n,0);for(let e=1;e<this.columns;e++)this.get(n,e)>t&&(t=this.get(n,e));return t}maxRowIndex(n){checkRowIndex(this,n),checkNonEmpty(this);let t=this.get(n,0),e=[n,0];for(let i=1;i<this.columns;i++)this.get(n,i)>t&&(t=this.get(n,i),e[1]=i);return e}minRow(n){if(checkRowIndex(this,n),this.isEmpty())return NaN;let t=this.get(n,0);for(let e=1;e<this.columns;e++)this.get(n,e)<t&&(t=this.get(n,e));return t}minRowIndex(n){checkRowIndex(this,n),checkNonEmpty(this);let t=this.get(n,0),e=[n,0];for(let i=1;i<this.columns;i++)this.get(n,i)<t&&(t=this.get(n,i),e[1]=i);return e}maxColumn(n){if(checkColumnIndex(this,n),this.isEmpty())return NaN;let t=this.get(0,n);for(let e=1;e<this.rows;e++)this.get(e,n)>t&&(t=this.get(e,n));return t}maxColumnIndex(n){checkColumnIndex(this,n),checkNonEmpty(this);let t=this.get(0,n),e=[0,n];for(let i=1;i<this.rows;i++)this.get(i,n)>t&&(t=this.get(i,n),e[0]=i);return e}minColumn(n){if(checkColumnIndex(this,n),this.isEmpty())return NaN;let t=this.get(0,n);for(let e=1;e<this.rows;e++)this.get(e,n)<t&&(t=this.get(e,n));return t}minColumnIndex(n){checkColumnIndex(this,n),checkNonEmpty(this);let t=this.get(0,n),e=[0,n];for(let i=1;i<this.rows;i++)this.get(i,n)<t&&(t=this.get(i,n),e[0]=i);return e}diag(){let n=Math.min(this.rows,this.columns),t=[];for(let e=0;e<n;e++)t.push(this.get(e,e));return t}norm(n="frobenius"){switch(n){case"max":return this.max();case"frobenius":return Math.sqrt(this.dot(this));default:throw new RangeError(`unknown norm type: ${n}`)}}cumulativeSum(){let n=0;for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)n+=this.get(t,e),this.set(t,e,n);return this}dot(n){AbstractMatrix.isMatrix(n)&&(n=n.to1DArray());let t=this.to1DArray();if(t.length!==n.length)throw new RangeError("vectors do not have the same size");let e=0;for(let i=0;i<t.length;i++)e+=t[i]*n[i];return e}mmul(n){n=Matrix$2.checkMatrix(n);let t=this.rows,e=this.columns,i=n.columns,a=new Matrix$2(t,i),s=new Float64Array(e);for(let r=0;r<i;r++){for(let t=0;t<e;t++)s[t]=n.get(t,r);for(let n=0;n<t;n++){let t=0;for(let i=0;i<e;i++)t+=this.get(n,i)*s[i];a.set(n,r,t)}}return a}strassen2x2(n){n=Matrix$2.checkMatrix(n);let t=new Matrix$2(2,2);const e=this.get(0,0),i=n.get(0,0),a=this.get(0,1),s=n.get(0,1),r=this.get(1,0),o=n.get(1,0),f=this.get(1,1),l=n.get(1,1),d=(e+f)*(i+l),g=(r+f)*i,u=e*(s-l),c=f*(o-i),b=(e+a)*l,h=d+c-b+(a-f)*(o+l),D=u+b,H=g+c,j=d-g+u+(r-e)*(i+s);return t.set(0,0,h),t.set(0,1,D),t.set(1,0,H),t.set(1,1,j),t}strassen3x3(n){n=Matrix$2.checkMatrix(n);let t=new Matrix$2(3,3);const e=this.get(0,0),i=this.get(0,1),a=this.get(0,2),s=this.get(1,0),r=this.get(1,1),o=this.get(1,2),f=this.get(2,0),l=this.get(2,1),d=this.get(2,2),g=n.get(0,0),u=n.get(0,1),c=n.get(0,2),b=n.get(1,0),h=n.get(1,1),D=n.get(1,2),H=n.get(2,0),j=n.get(2,1),m=n.get(2,2),A=(e-s)*(-u+h),C=(-e+s+r)*(g-u+h),p=(s+r)*(-g+u),M=e*g,I=(-e+f+l)*(g-c+D),P=(-e+f)*(c-D),T=(f+l)*(-g+c),N=(-a+l+d)*(h+H-j),w=(a-d)*(h-j),U=a*H,J=(l+d)*(-H+j),L=(-a+r+o)*(D+H-m),y=(a-o)*(D-m),B=(r+o)*(-H+m),R=M+U+i*b,k=(e+i+a-s-r-l-d)*h+C+p+M+N+U+J,x=M+I+T+(e+i+a-r-o-f-l)*D+U+L+B,E=A+r*(-g+u+b-h-D-H+m)+C+M+U+L+y,F=A+C+p+M+o*j,Q=U+L+y+B+s*c,z=M+I+P+l*(-g+c+b-h-D-H+j)+N+w+U,S=N+w+U+J+f*u,X=M+I+P+T+d*m;return t.set(0,0,R),t.set(0,1,k),t.set(0,2,x),t.set(1,0,E),t.set(1,1,F),t.set(1,2,Q),t.set(2,0,z),t.set(2,1,S),t.set(2,2,X),t}mmulStrassen(n){n=Matrix$2.checkMatrix(n);let t=this.clone(),e=t.rows,i=t.columns,a=n.rows,s=n.columns;function r(n,t,e){let i=n.rows,a=n.columns;if(i===t&&a===e)return n;{let i=AbstractMatrix.zeros(t,e);return i=i.setSubMatrix(n,0,0),i}}i!==a&&console.warn(`Multiplying ${e} x ${i} and ${a} x ${s} matrix: dimensions do not match.`);let o=Math.max(e,a),f=Math.max(i,s);return t=r(t,o,f),function n(t,e,i,a){if(i<=512||a<=512)return t.mmul(e);i%2==1&&a%2==1?(t=r(t,i+1,a+1),e=r(e,i+1,a+1)):i%2==1?(t=r(t,i+1,a),e=r(e,i+1,a)):a%2==1&&(t=r(t,i,a+1),e=r(e,i,a+1));let s=parseInt(t.rows/2,10),o=parseInt(t.columns/2,10),f=t.subMatrix(0,s-1,0,o-1),l=e.subMatrix(0,s-1,0,o-1),d=t.subMatrix(0,s-1,o,t.columns-1),g=e.subMatrix(0,s-1,o,e.columns-1),u=t.subMatrix(s,t.rows-1,0,o-1),c=e.subMatrix(s,e.rows-1,0,o-1),b=t.subMatrix(s,t.rows-1,o,t.columns-1),h=e.subMatrix(s,e.rows-1,o,e.columns-1),D=n(AbstractMatrix.add(f,b),AbstractMatrix.add(l,h),s,o),H=n(AbstractMatrix.add(u,b),l,s,o),j=n(f,AbstractMatrix.sub(g,h),s,o),m=n(b,AbstractMatrix.sub(c,l),s,o),A=n(AbstractMatrix.add(f,d),h,s,o),C=n(AbstractMatrix.sub(u,f),AbstractMatrix.add(l,g),s,o),p=n(AbstractMatrix.sub(d,b),AbstractMatrix.add(c,h),s,o),M=AbstractMatrix.add(D,m);M.sub(A),M.add(p);let I=AbstractMatrix.add(j,A),P=AbstractMatrix.add(H,m),T=AbstractMatrix.sub(D,H);T.add(j),T.add(C);let N=AbstractMatrix.zeros(2*M.rows,2*M.columns);return N=N.setSubMatrix(M,0,0),N=N.setSubMatrix(I,M.rows,0),N=N.setSubMatrix(P,0,M.columns),N=N.setSubMatrix(T,M.rows,M.columns),N.subMatrix(0,i-1,0,a-1)}(t,n=r(n,o,f),o,f)}scaleRows(n={}){if("object"!=typeof n)throw new TypeError("options must be an object");const{min:t=0,max:e=1}=n;if(!Number.isFinite(t))throw new TypeError("min must be a number");if(!Number.isFinite(e))throw new TypeError("max must be a number");if(t>=e)throw new RangeError("min must be smaller than max");let i=new Matrix$2(this.rows,this.columns);for(let n=0;n<this.rows;n++){const a=this.getRow(n);a.length>0&&rescale$1(a,{min:t,max:e,output:a}),i.setRow(n,a)}return i}scaleColumns(n={}){if("object"!=typeof n)throw new TypeError("options must be an object");const{min:t=0,max:e=1}=n;if(!Number.isFinite(t))throw new TypeError("min must be a number");if(!Number.isFinite(e))throw new TypeError("max must be a number");if(t>=e)throw new RangeError("min must be smaller than max");let i=new Matrix$2(this.rows,this.columns);for(let n=0;n<this.columns;n++){const a=this.getColumn(n);a.length&&rescale$1(a,{min:t,max:e,output:a}),i.setColumn(n,a)}return i}flipRows(){const n=Math.ceil(this.columns/2);for(let t=0;t<this.rows;t++)for(let e=0;e<n;e++){let n=this.get(t,e),i=this.get(t,this.columns-1-e);this.set(t,e,i),this.set(t,this.columns-1-e,n)}return this}flipColumns(){const n=Math.ceil(this.rows/2);for(let t=0;t<this.columns;t++)for(let e=0;e<n;e++){let n=this.get(e,t),i=this.get(this.rows-1-e,t);this.set(e,t,i),this.set(this.rows-1-e,t,n)}return this}kroneckerProduct(n){n=Matrix$2.checkMatrix(n);let t=this.rows,e=this.columns,i=n.rows,a=n.columns,s=new Matrix$2(t*i,e*a);for(let r=0;r<t;r++)for(let t=0;t<e;t++)for(let e=0;e<i;e++)for(let o=0;o<a;o++)s.set(i*r+e,a*t+o,this.get(r,t)*n.get(e,o));return s}kroneckerSum(n){if(n=Matrix$2.checkMatrix(n),!this.isSquare()||!n.isSquare())throw new Error("Kronecker Sum needs two Square Matrices");let t=this.rows,e=n.rows,i=this.kroneckerProduct(Matrix$2.eye(e,e)),a=Matrix$2.eye(t,t).kroneckerProduct(n);return i.add(a)}transpose(){let n=new Matrix$2(this.columns,this.rows);for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)n.set(e,t,this.get(t,e));return n}sortRows(n=compareNumbers){for(let t=0;t<this.rows;t++)this.setRow(t,this.getRow(t).sort(n));return this}sortColumns(n=compareNumbers){for(let t=0;t<this.columns;t++)this.setColumn(t,this.getColumn(t).sort(n));return this}subMatrix(n,t,e,i){checkRange(this,n,t,e,i);let a=new Matrix$2(t-n+1,i-e+1);for(let s=n;s<=t;s++)for(let t=e;t<=i;t++)a.set(s-n,t-e,this.get(s,t));return a}subMatrixRow(n,t,e){if(void 0===t&&(t=0),void 0===e&&(e=this.columns-1),t>e||t<0||t>=this.columns||e<0||e>=this.columns)throw new RangeError("Argument out of range");let i=new Matrix$2(n.length,e-t+1);for(let a=0;a<n.length;a++)for(let s=t;s<=e;s++){if(n[a]<0||n[a]>=this.rows)throw new RangeError(`Row index out of range: ${n[a]}`);i.set(a,s-t,this.get(n[a],s))}return i}subMatrixColumn(n,t,e){if(void 0===t&&(t=0),void 0===e&&(e=this.rows-1),t>e||t<0||t>=this.rows||e<0||e>=this.rows)throw new RangeError("Argument out of range");let i=new Matrix$2(e-t+1,n.length);for(let a=0;a<n.length;a++)for(let s=t;s<=e;s++){if(n[a]<0||n[a]>=this.columns)throw new RangeError(`Column index out of range: ${n[a]}`);i.set(s-t,a,this.get(s,n[a]))}return i}setSubMatrix(n,t,e){if((n=Matrix$2.checkMatrix(n)).isEmpty())return this;checkRange(this,t,t+n.rows-1,e,e+n.columns-1);for(let i=0;i<n.rows;i++)for(let a=0;a<n.columns;a++)this.set(t+i,e+a,n.get(i,a));return this}selection(n,t){checkRowIndices(this,n),checkColumnIndices(this,t);let e=new Matrix$2(n.length,t.length);for(let i=0;i<n.length;i++){let a=n[i];for(let n=0;n<t.length;n++){let s=t[n];e.set(i,n,this.get(a,s))}}return e}trace(){let n=Math.min(this.rows,this.columns),t=0;for(let e=0;e<n;e++)t+=this.get(e,e);return t}clone(){return this.constructor.copy(this,new Matrix$2(this.rows,this.columns))}static copy(n,t){for(const[e,i,a]of n.entries())t.set(e,i,a);return t}sum(n){switch(n){case"row":return sumByRow(this);case"column":return sumByColumn(this);case void 0:return sumAll(this);default:throw new Error(`invalid option: ${n}`)}}product(n){switch(n){case"row":return productByRow(this);case"column":return productByColumn(this);case void 0:return productAll(this);default:throw new Error(`invalid option: ${n}`)}}mean(n){const t=this.sum(n);switch(n){case"row":for(let n=0;n<this.rows;n++)t[n]/=this.columns;return t;case"column":for(let n=0;n<this.columns;n++)t[n]/=this.rows;return t;case void 0:return t/this.size;default:throw new Error(`invalid option: ${n}`)}}variance(n,t={}){if("object"==typeof n&&(t=n,n=void 0),"object"!=typeof t)throw new TypeError("options must be an object");const{unbiased:e=!0,mean:i=this.mean(n)}=t;if("boolean"!=typeof e)throw new TypeError("unbiased must be a boolean");switch(n){case"row":if(!isAnyArray.isAnyArray(i))throw new TypeError("mean must be an array");return varianceByRow(this,e,i);case"column":if(!isAnyArray.isAnyArray(i))throw new TypeError("mean must be an array");return varianceByColumn(this,e,i);case void 0:if("number"!=typeof i)throw new TypeError("mean must be a number");return varianceAll(this,e,i);default:throw new Error(`invalid option: ${n}`)}}standardDeviation(n,t){"object"==typeof n&&(t=n,n=void 0);const e=this.variance(n,t);if(void 0===n)return Math.sqrt(e);for(let n=0;n<e.length;n++)e[n]=Math.sqrt(e[n]);return e}center(n,t={}){if("object"==typeof n&&(t=n,n=void 0),"object"!=typeof t)throw new TypeError("options must be an object");const{center:e=this.mean(n)}=t;switch(n){case"row":if(!isAnyArray.isAnyArray(e))throw new TypeError("center must be an array");return centerByRow(this,e),this;case"column":if(!isAnyArray.isAnyArray(e))throw new TypeError("center must be an array");return centerByColumn(this,e),this;case void 0:if("number"!=typeof e)throw new TypeError("center must be a number");return centerAll(this,e),this;default:throw new Error(`invalid option: ${n}`)}}scale(n,t={}){if("object"==typeof n&&(t=n,n=void 0),"object"!=typeof t)throw new TypeError("options must be an object");let e=t.scale;switch(n){case"row":if(void 0===e)e=getScaleByRow(this);else if(!isAnyArray.isAnyArray(e))throw new TypeError("scale must be an array");return scaleByRow(this,e),this;case"column":if(void 0===e)e=getScaleByColumn(this);else if(!isAnyArray.isAnyArray(e))throw new TypeError("scale must be an array");return scaleByColumn(this,e),this;case void 0:if(void 0===e)e=getScaleAll(this);else if("number"!=typeof e)throw new TypeError("scale must be a number");return scaleAll(this,e),this;default:throw new Error(`invalid option: ${n}`)}}toString(n){return inspectMatrixWithOptions(this,n)}[Symbol.iterator](){return this.entries()}*entries(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)yield[n,t,this.get(n,t)]}*values(){for(let n=0;n<this.rows;n++)for(let t=0;t<this.columns;t++)yield this.get(n,t)}}function compareNumbers(n,t){return n-t}function isArrayOfNumbers(n){return n.every((n=>"number"==typeof n))}AbstractMatrix.prototype.klass="Matrix","undefined"!=typeof Symbol&&(AbstractMatrix.prototype[Symbol.for("nodejs.util.inspect.custom")]=inspectMatrix),AbstractMatrix.random=AbstractMatrix.rand,AbstractMatrix.randomInt=AbstractMatrix.randInt,AbstractMatrix.diagonal=AbstractMatrix.diag,AbstractMatrix.prototype.diagonal=AbstractMatrix.prototype.diag,AbstractMatrix.identity=AbstractMatrix.eye,AbstractMatrix.prototype.negate=AbstractMatrix.prototype.neg,AbstractMatrix.prototype.tensorProduct=AbstractMatrix.prototype.kroneckerProduct;class Matrix$2 extends AbstractMatrix{data;#n(n,t){if(this.data=[],!(Number.isInteger(t)&&t>=0))throw new TypeError("nColumns must be a positive integer");for(let e=0;e<n;e++)this.data.push(new Float64Array(t));this.rows=n,this.columns=t}constructor(n,t){if(super(),Matrix$2.isMatrix(n))this.#n(n.rows,n.columns),Matrix$2.copy(n,this);else if(Number.isInteger(n)&&n>=0)this.#n(n,t);else{if(!isAnyArray.isAnyArray(n))throw new TypeError("First argument must be a positive number or an array");{const e=n;if("number"!=typeof(t=(n=e.length)?e[0].length:0))throw new TypeError("Data must be a 2D array with at least one element");this.data=[];for(let i=0;i<n;i++){if(e[i].length!==t)throw new RangeError("Inconsistent array dimensions");if(!isArrayOfNumbers(e[i]))throw new TypeError("Input data contains non-numeric values");this.data.push(Float64Array.from(e[i]))}this.rows=n,this.columns=t}}}set(n,t,e){return this.data[n][t]=e,this}get(n,t){return this.data[n][t]}removeRow(n){return checkRowIndex(this,n),this.data.splice(n,1),this.rows-=1,this}addRow(n,t){return void 0===t&&(t=n,n=this.rows),checkRowIndex(this,n,!0),t=Float64Array.from(checkRowVector(this,t)),this.data.splice(n,0,t),this.rows+=1,this}removeColumn(n){checkColumnIndex(this,n);for(let t=0;t<this.rows;t++){const e=new Float64Array(this.columns-1);for(let i=0;i<n;i++)e[i]=this.data[t][i];for(let i=n+1;i<this.columns;i++)e[i-1]=this.data[t][i];this.data[t]=e}return this.columns-=1,this}addColumn(n,t){void 0===t&&(t=n,n=this.columns),checkColumnIndex(this,n,!0),t=checkColumnVector(this,t);for(let e=0;e<this.rows;e++){const i=new Float64Array(this.columns+1);let a=0;for(;a<n;a++)i[a]=this.data[e][a];for(i[a++]=t[e];a<this.columns+1;a++)i[a]=this.data[e][a-1];this.data[e]=i}return this.columns+=1,this}}installMathOperations(AbstractMatrix,Matrix$2);class SymmetricMatrix extends AbstractMatrix{#t;get size(){return this.#t.size}get rows(){return this.#t.rows}get columns(){return this.#t.columns}get diagonalSize(){return this.rows}static isSymmetricMatrix(n){return Matrix$2.isMatrix(n)&&"SymmetricMatrix"===n.klassType}static zeros(n){return new this(n)}static ones(n){return new this(n).fill(1)}constructor(n){if(super(),Matrix$2.isMatrix(n)){if(!n.isSymmetric())throw new TypeError("not symmetric data");this.#t=Matrix$2.copy(n,new Matrix$2(n.rows,n.rows))}else if(Number.isInteger(n)&&n>=0)this.#t=new Matrix$2(n,n);else if(this.#t=new Matrix$2(n),!this.isSymmetric())throw new TypeError("not symmetric data")}clone(){const n=new SymmetricMatrix(this.diagonalSize);for(const[t,e,i]of this.upperRightEntries())n.set(t,e,i);return n}toMatrix(){return new Matrix$2(this)}get(n,t){return this.#t.get(n,t)}set(n,t,e){return this.#t.set(n,t,e),this.#t.set(t,n,e),this}removeCross(n){return this.#t.removeRow(n),this.#t.removeColumn(n),this}addCross(n,t){void 0===t&&(t=n,n=this.diagonalSize);const e=t.slice();return e.splice(n,1),this.#t.addRow(n,e),this.#t.addColumn(n,t),this}applyMask(n){if(n.length!==this.diagonalSize)throw new RangeError("Mask size do not match with matrix size");const t=[];for(const[e,i]of n.entries())i||t.push(e);t.reverse();for(const n of t)this.removeCross(n);return this}toCompact(){const{diagonalSize:n}=this,t=new Array(n*(n+1)/2);for(let e=0,i=0,a=0;a<t.length;a++)t[a]=this.get(i,e),++e>=n&&(e=++i);return t}static fromCompact(n){const t=n.length,e=(Math.sqrt(8*t+1)-1)/2;if(!Number.isInteger(e))throw new TypeError(`This array is not a compact representation of a Symmetric Matrix, ${JSON.stringify(n)}`);const i=new SymmetricMatrix(e);for(let a=0,s=0,r=0;r<t;r++)i.set(a,s,n[r]),++a>=e&&(a=++s);return i}*upperRightEntries(){for(let n=0,t=0;n<this.diagonalSize;void 0){const e=this.get(n,t);yield[n,t,e],++t>=this.diagonalSize&&(t=++n)}}*upperRightValues(){for(let n=0,t=0;n<this.diagonalSize;void 0){const e=this.get(n,t);yield e,++t>=this.diagonalSize&&(t=++n)}}}SymmetricMatrix.prototype.klassType="SymmetricMatrix";class DistanceMatrix extends SymmetricMatrix{static isDistanceMatrix(n){return SymmetricMatrix.isSymmetricMatrix(n)&&"DistanceMatrix"===n.klassSubType}constructor(n){if(super(n),!this.isDistance())throw new TypeError("Provided arguments do no produce a distance matrix")}set(n,t,e){return n===t&&(e=0),super.set(n,t,e)}addCross(n,t){return void 0===t&&(t=n,n=this.diagonalSize),(t=t.slice())[n]=0,super.addCross(n,t)}toSymmetricMatrix(){return new SymmetricMatrix(this)}clone(){const n=new DistanceMatrix(this.diagonalSize);for(const[t,e,i]of this.upperRightEntries())t!==e&&n.set(t,e,i);return n}toCompact(){const{diagonalSize:n}=this,t=new Array((n-1)*n/2);for(let e=1,i=0,a=0;a<t.length;a++)t[a]=this.get(i,e),++e>=n&&(e=1+ ++i);return t}static fromCompact(n){const t=n.length;if(0===t)return new this(0);const e=(Math.sqrt(8*t+1)+1)/2;if(!Number.isInteger(e))throw new TypeError(`This array is not a compact representation of a DistanceMatrix, ${JSON.stringify(n)}`);const i=new this(e);for(let a=1,s=0,r=0;r<t;r++)i.set(a,s,n[r]),++a>=e&&(a=1+ ++s);return i}}DistanceMatrix.prototype.klassSubType="DistanceMatrix";class BaseView extends AbstractMatrix{constructor(n,t,e){super(),this.matrix=n,this.rows=t,this.columns=e}}class MatrixColumnView extends BaseView{constructor(n,t){checkColumnIndex(n,t),super(n,n.rows,1),this.column=t}set(n,t,e){return this.matrix.set(n,this.column,e),this}get(n){return this.matrix.get(n,this.column)}}class MatrixColumnSelectionView extends BaseView{constructor(n,t){checkColumnIndices(n,t),super(n,n.rows,t.length),this.columnIndices=t}set(n,t,e){return this.matrix.set(n,this.columnIndices[t],e),this}get(n,t){return this.matrix.get(n,this.columnIndices[t])}}class MatrixFlipColumnView extends BaseView{constructor(n){super(n,n.rows,n.columns)}set(n,t,e){return this.matrix.set(n,this.columns-t-1,e),this}get(n,t){return this.matrix.get(n,this.columns-t-1)}}class MatrixFlipRowView extends BaseView{constructor(n){super(n,n.rows,n.columns)}set(n,t,e){return this.matrix.set(this.rows-n-1,t,e),this}get(n,t){return this.matrix.get(this.rows-n-1,t)}}class MatrixRowView extends BaseView{constructor(n,t){checkRowIndex(n,t),super(n,1,n.columns),this.row=t}set(n,t,e){return this.matrix.set(this.row,t,e),this}get(n,t){return this.matrix.get(this.row,t)}}class MatrixRowSelectionView extends BaseView{constructor(n,t){checkRowIndices(n,t),super(n,t.length,n.columns),this.rowIndices=t}set(n,t,e){return this.matrix.set(this.rowIndices[n],t,e),this}get(n,t){return this.matrix.get(this.rowIndices[n],t)}}class MatrixSelectionView extends BaseView{constructor(n,t,e){checkRowIndices(n,t),checkColumnIndices(n,e),super(n,t.length,e.length),this.rowIndices=t,this.columnIndices=e}set(n,t,e){return this.matrix.set(this.rowIndices[n],this.columnIndices[t],e),this}get(n,t){return this.matrix.get(this.rowIndices[n],this.columnIndices[t])}}class MatrixSubView extends BaseView{constructor(n,t,e,i,a){checkRange(n,t,e,i,a),super(n,e-t+1,a-i+1),this.startRow=t,this.startColumn=i}set(n,t,e){return this.matrix.set(this.startRow+n,this.startColumn+t,e),this}get(n,t){return this.matrix.get(this.startRow+n,this.startColumn+t)}}class MatrixTransposeView$1 extends BaseView{constructor(n){super(n,n.columns,n.rows)}set(n,t,e){return this.matrix.set(t,n,e),this}get(n,t){return this.matrix.get(t,n)}}class WrapperMatrix1D extends AbstractMatrix{constructor(n,t={}){const{rows:e=1}=t;if(n.length%e!=0)throw new Error("the data length is not divisible by the number of rows");super(),this.rows=e,this.columns=n.length/e,this.data=n}set(n,t,e){let i=this._calculateIndex(n,t);return this.data[i]=e,this}get(n,t){let e=this._calculateIndex(n,t);return this.data[e]}_calculateIndex(n,t){return n*this.columns+t}}class WrapperMatrix2D$1 extends AbstractMatrix{constructor(n){super(),this.data=n,this.rows=n.length,this.columns=n[0].length}set(n,t,e){return this.data[n][t]=e,this}get(n,t){return this.data[n][t]}}function wrap(n,t){if(isAnyArray.isAnyArray(n))return n[0]&&isAnyArray.isAnyArray(n[0])?new WrapperMatrix2D$1(n):new WrapperMatrix1D(n,t);throw new Error("the argument is not an array")}class LuDecomposition{constructor(n){let t,e,i,a,s,r,o,f,l,d=(n=WrapperMatrix2D$1.checkMatrix(n)).clone(),g=d.rows,u=d.columns,c=new Float64Array(g),b=1;for(t=0;t<g;t++)c[t]=t;for(f=new Float64Array(g),e=0;e<u;e++){for(t=0;t<g;t++)f[t]=d.get(t,e);for(t=0;t<g;t++){for(l=Math.min(t,e),s=0,i=0;i<l;i++)s+=d.get(t,i)*f[i];f[t]-=s,d.set(t,e,f[t])}for(a=e,t=e+1;t<g;t++)Math.abs(f[t])>Math.abs(f[a])&&(a=t);if(a!==e){for(i=0;i<u;i++)r=d.get(a,i),d.set(a,i,d.get(e,i)),d.set(e,i,r);o=c[a],c[a]=c[e],c[e]=o,b=-b}if(e<g&&0!==d.get(e,e))for(t=e+1;t<g;t++)d.set(t,e,d.get(t,e)/d.get(e,e))}this.LU=d,this.pivotVector=c,this.pivotSign=b}isSingular(){let n=this.LU,t=n.columns;for(let e=0;e<t;e++)if(0===n.get(e,e))return!0;return!1}solve(n){n=Matrix$2.checkMatrix(n);let t=this.LU;if(t.rows!==n.rows)throw new Error("Invalid matrix dimensions");if(this.isSingular())throw new Error("LU matrix is singular");let e,i,a,s=n.columns,r=n.subMatrixRow(this.pivotVector,0,s-1),o=t.columns;for(a=0;a<o;a++)for(e=a+1;e<o;e++)for(i=0;i<s;i++)r.set(e,i,r.get(e,i)-r.get(a,i)*t.get(e,a));for(a=o-1;a>=0;a--){for(i=0;i<s;i++)r.set(a,i,r.get(a,i)/t.get(a,a));for(e=0;e<a;e++)for(i=0;i<s;i++)r.set(e,i,r.get(e,i)-r.get(a,i)*t.get(e,a))}return r}get determinant(){let n=this.LU;if(!n.isSquare())throw new Error("Matrix must be square");let t=this.pivotSign,e=n.columns;for(let i=0;i<e;i++)t*=n.get(i,i);return t}get lowerTriangularMatrix(){let n=this.LU,t=n.rows,e=n.columns,i=new Matrix$2(t,e);for(let a=0;a<t;a++)for(let t=0;t<e;t++)a>t?i.set(a,t,n.get(a,t)):a===t?i.set(a,t,1):i.set(a,t,0);return i}get upperTriangularMatrix(){let n=this.LU,t=n.rows,e=n.columns,i=new Matrix$2(t,e);for(let a=0;a<t;a++)for(let t=0;t<e;t++)a<=t?i.set(a,t,n.get(a,t)):i.set(a,t,0);return i}get pivotPermutationVector(){return Array.from(this.pivotVector)}}function hypotenuse(n,t){let e=0;return Math.abs(n)>Math.abs(t)?(e=t/n,Math.abs(n)*Math.sqrt(1+e*e)):0!==t?(e=n/t,Math.abs(t)*Math.sqrt(1+e*e)):0}class QrDecomposition{constructor(n){let t,e,i,a,s=(n=WrapperMatrix2D$1.checkMatrix(n)).clone(),r=n.rows,o=n.columns,f=new Float64Array(o);for(i=0;i<o;i++){let n=0;for(t=i;t<r;t++)n=hypotenuse(n,s.get(t,i));if(0!==n){for(s.get(i,i)<0&&(n=-n),t=i;t<r;t++)s.set(t,i,s.get(t,i)/n);for(s.set(i,i,s.get(i,i)+1),e=i+1;e<o;e++){for(a=0,t=i;t<r;t++)a+=s.get(t,i)*s.get(t,e);for(a=-a/s.get(i,i),t=i;t<r;t++)s.set(t,e,s.get(t,e)+a*s.get(t,i))}}f[i]=-n}this.QR=s,this.Rdiag=f}solve(n){n=Matrix$2.checkMatrix(n);let t=this.QR,e=t.rows;if(n.rows!==e)throw new Error("Matrix row dimensions must agree");if(!this.isFullRank())throw new Error("Matrix is rank deficient");let i,a,s,r,o=n.columns,f=n.clone(),l=t.columns;for(s=0;s<l;s++)for(a=0;a<o;a++){for(r=0,i=s;i<e;i++)r+=t.get(i,s)*f.get(i,a);for(r=-r/t.get(s,s),i=s;i<e;i++)f.set(i,a,f.get(i,a)+r*t.get(i,s))}for(s=l-1;s>=0;s--){for(a=0;a<o;a++)f.set(s,a,f.get(s,a)/this.Rdiag[s]);for(i=0;i<s;i++)for(a=0;a<o;a++)f.set(i,a,f.get(i,a)-f.get(s,a)*t.get(i,s))}return f.subMatrix(0,l-1,0,o-1)}isFullRank(){let n=this.QR.columns;for(let t=0;t<n;t++)if(0===this.Rdiag[t])return!1;return!0}get upperTriangularMatrix(){let n,t,e=this.QR,i=e.columns,a=new Matrix$2(i,i);for(n=0;n<i;n++)for(t=0;t<i;t++)n<t?a.set(n,t,e.get(n,t)):n===t?a.set(n,t,this.Rdiag[n]):a.set(n,t,0);return a}get orthogonalMatrix(){let n,t,e,i,a=this.QR,s=a.rows,r=a.columns,o=new Matrix$2(s,r);for(e=r-1;e>=0;e--){for(n=0;n<s;n++)o.set(n,e,0);for(o.set(e,e,1),t=e;t<r;t++)if(0!==a.get(e,e)){for(i=0,n=e;n<s;n++)i+=a.get(n,e)*o.get(n,t);for(i=-i/a.get(e,e),n=e;n<s;n++)o.set(n,t,o.get(n,t)+i*a.get(n,e))}}return o}}class SingularValueDecomposition{constructor(n,t={}){if((n=WrapperMatrix2D$1.checkMatrix(n)).isEmpty())throw new Error("Matrix must be non-empty");let e=n.rows,i=n.columns;const{computeLeftSingularVectors:a=!0,computeRightSingularVectors:s=!0,autoTranspose:r=!1}=t;let o,f=Boolean(a),l=Boolean(s),d=!1;if(e<i)if(r){o=n.transpose(),e=o.rows,i=o.columns,d=!0;let t=f;f=l,l=t}else o=n.clone(),console.warn("Computing SVD on a matrix with more columns than rows. Consider enabling autoTranspose");else o=n.clone();let g=Math.min(e,i),u=Math.min(e+1,i),c=new Float64Array(u),b=new Matrix$2(e,g),h=new Matrix$2(i,i),D=new Float64Array(i),H=new Float64Array(e),j=new Float64Array(u);for(let n=0;n<u;n++)j[n]=n;let m=Math.min(e-1,i),A=Math.max(0,Math.min(i-2,e)),C=Math.max(m,A);for(let n=0;n<C;n++){if(n<m){c[n]=0;for(let t=n;t<e;t++)c[n]=hypotenuse(c[n],o.get(t,n));if(0!==c[n]){o.get(n,n)<0&&(c[n]=-c[n]);for(let t=n;t<e;t++)o.set(t,n,o.get(t,n)/c[n]);o.set(n,n,o.get(n,n)+1)}c[n]=-c[n]}for(let t=n+1;t<i;t++){if(n<m&&0!==c[n]){let i=0;for(let a=n;a<e;a++)i+=o.get(a,n)*o.get(a,t);i=-i/o.get(n,n);for(let a=n;a<e;a++)o.set(a,t,o.get(a,t)+i*o.get(a,n))}D[t]=o.get(n,t)}if(f&&n<m)for(let t=n;t<e;t++)b.set(t,n,o.get(t,n));if(n<A){D[n]=0;for(let t=n+1;t<i;t++)D[n]=hypotenuse(D[n],D[t]);if(0!==D[n]){D[n+1]<0&&(D[n]=0-D[n]);for(let t=n+1;t<i;t++)D[t]/=D[n];D[n+1]+=1}if(D[n]=-D[n],n+1<e&&0!==D[n]){for(let t=n+1;t<e;t++)H[t]=0;for(let t=n+1;t<e;t++)for(let e=n+1;e<i;e++)H[t]+=D[e]*o.get(t,e);for(let t=n+1;t<i;t++){let i=-D[t]/D[n+1];for(let a=n+1;a<e;a++)o.set(a,t,o.get(a,t)+i*H[a])}}if(l)for(let t=n+1;t<i;t++)h.set(t,n,D[t])}}let p=Math.min(i,e+1);if(m<i&&(c[m]=o.get(m,m)),e<p&&(c[p-1]=0),A+1<p&&(D[A]=o.get(A,p-1)),D[p-1]=0,f){for(let n=m;n<g;n++){for(let t=0;t<e;t++)b.set(t,n,0);b.set(n,n,1)}for(let n=m-1;n>=0;n--)if(0!==c[n]){for(let t=n+1;t<g;t++){let i=0;for(let a=n;a<e;a++)i+=b.get(a,n)*b.get(a,t);i=-i/b.get(n,n);for(let a=n;a<e;a++)b.set(a,t,b.get(a,t)+i*b.get(a,n))}for(let t=n;t<e;t++)b.set(t,n,-b.get(t,n));b.set(n,n,1+b.get(n,n));for(let t=0;t<n-1;t++)b.set(t,n,0)}else{for(let t=0;t<e;t++)b.set(t,n,0);b.set(n,n,1)}}if(l)for(let n=i-1;n>=0;n--){if(n<A&&0!==D[n])for(let t=n+1;t<i;t++){let e=0;for(let a=n+1;a<i;a++)e+=h.get(a,n)*h.get(a,t);e=-e/h.get(n+1,n);for(let a=n+1;a<i;a++)h.set(a,t,h.get(a,t)+e*h.get(a,n))}for(let t=0;t<i;t++)h.set(t,n,0);h.set(n,n,1)}let M=p-1,I=Number.EPSILON;for(;p>0;){let n,t;for(n=p-2;n>=-1&&-1!==n;n--){const t=Number.MIN_VALUE+I*Math.abs(c[n]+Math.abs(c[n+1]));if(Math.abs(D[n])<=t||Number.isNaN(D[n])){D[n]=0;break}}if(n===p-2)t=4;else{let e;for(e=p-1;e>=n&&e!==n;e--){let t=(e!==p?Math.abs(D[e]):0)+(e!==n+1?Math.abs(D[e-1]):0);if(Math.abs(c[e])<=I*t){c[e]=0;break}}e===n?t=3:e===p-1?t=1:(t=2,n=e)}switch(n++,t){case 1:{let t=D[p-2];D[p-2]=0;for(let e=p-2;e>=n;e--){let a=hypotenuse(c[e],t),s=c[e]/a,r=t/a;if(c[e]=a,e!==n&&(t=-r*D[e-1],D[e-1]=s*D[e-1]),l)for(let n=0;n<i;n++)a=s*h.get(n,e)+r*h.get(n,p-1),h.set(n,p-1,-r*h.get(n,e)+s*h.get(n,p-1)),h.set(n,e,a)}break}case 2:{let t=D[n-1];D[n-1]=0;for(let i=n;i<p;i++){let a=hypotenuse(c[i],t),s=c[i]/a,r=t/a;if(c[i]=a,t=-r*D[i],D[i]=s*D[i],f)for(let t=0;t<e;t++)a=s*b.get(t,i)+r*b.get(t,n-1),b.set(t,n-1,-r*b.get(t,i)+s*b.get(t,n-1)),b.set(t,i,a)}break}case 3:{const t=Math.max(Math.abs(c[p-1]),Math.abs(c[p-2]),Math.abs(D[p-2]),Math.abs(c[n]),Math.abs(D[n])),a=c[p-1]/t,s=c[p-2]/t,r=D[p-2]/t,o=c[n]/t,d=D[n]/t,g=((s+a)*(s-a)+r*r)/2,u=a*r*(a*r);let H=0;0===g&&0===u||(H=g<0?0-Math.sqrt(g*g+u):Math.sqrt(g*g+u),H=u/(g+H));let j=(o+a)*(o-a)+H,m=o*d;for(let t=n;t<p-1;t++){let a=hypotenuse(j,m);0===a&&(a=Number.MIN_VALUE);let s=j/a,r=m/a;if(t!==n&&(D[t-1]=a),j=s*c[t]+r*D[t],D[t]=s*D[t]-r*c[t],m=r*c[t+1],c[t+1]=s*c[t+1],l)for(let n=0;n<i;n++)a=s*h.get(n,t)+r*h.get(n,t+1),h.set(n,t+1,-r*h.get(n,t)+s*h.get(n,t+1)),h.set(n,t,a);if(a=hypotenuse(j,m),0===a&&(a=Number.MIN_VALUE),s=j/a,r=m/a,c[t]=a,j=s*D[t]+r*c[t+1],c[t+1]=-r*D[t]+s*c[t+1],m=r*D[t+1],D[t+1]=s*D[t+1],f&&t<e-1)for(let n=0;n<e;n++)a=s*b.get(n,t)+r*b.get(n,t+1),b.set(n,t+1,-r*b.get(n,t)+s*b.get(n,t+1)),b.set(n,t,a)}D[p-2]=j;break}case 4:if(c[n]<=0&&(c[n]=c[n]<0?-c[n]:0,l))for(let t=0;t<=M;t++)h.set(t,n,-h.get(t,n));for(;n<M&&!(c[n]>=c[n+1]);){let t=c[n];if(c[n]=c[n+1],c[n+1]=t,l&&n<i-1)for(let e=0;e<i;e++)t=h.get(e,n+1),h.set(e,n+1,h.get(e,n)),h.set(e,n,t);if(f&&n<e-1)for(let i=0;i<e;i++)t=b.get(i,n+1),b.set(i,n+1,b.get(i,n)),b.set(i,n,t);n++}p--}}if(d){let n=h;h=b,b=n}this.m=e,this.n=i,this.s=c,this.U=b,this.V=h}solve(n){let t=n,e=this.threshold,i=this.s.length,a=Matrix$2.zeros(i,i);for(let n=0;n<i;n++)Math.abs(this.s[n])<=e?a.set(n,n,0):a.set(n,n,1/this.s[n]);let s=this.U,r=this.rightSingularVectors,o=r.mmul(a),f=r.rows,l=s.rows,d=Matrix$2.zeros(f,l);for(let n=0;n<f;n++)for(let t=0;t<l;t++){let e=0;for(let a=0;a<i;a++)e+=o.get(n,a)*s.get(t,a);d.set(n,t,e)}return d.mmul(t)}solveForDiagonal(n){return this.solve(Matrix$2.diag(n))}inverse(){let n=this.V,t=this.threshold,e=n.rows,i=n.columns,a=new Matrix$2(e,this.s.length);for(let s=0;s<e;s++)for(let e=0;e<i;e++)Math.abs(this.s[e])>t&&a.set(s,e,n.get(s,e)/this.s[e]);let s=this.U,r=s.rows,o=s.columns,f=new Matrix$2(e,r);for(let n=0;n<e;n++)for(let t=0;t<r;t++){let e=0;for(let i=0;i<o;i++)e+=a.get(n,i)*s.get(t,i);f.set(n,t,e)}return f}get condition(){return this.s[0]/this.s[Math.min(this.m,this.n)-1]}get norm2(){return this.s[0]}get rank(){let n=Math.max(this.m,this.n)*this.s[0]*Number.EPSILON,t=0,e=this.s;for(let i=0,a=e.length;i<a;i++)e[i]>n&&t++;return t}get diagonal(){return Array.from(this.s)}get threshold(){return Number.EPSILON/2*Math.max(this.m,this.n)*this.s[0]}get leftSingularVectors(){return this.U}get rightSingularVectors(){return this.V}get diagonalMatrix(){return Matrix$2.diag(this.s)}}function inverse$1(n,t=!1){return n=WrapperMatrix2D$1.checkMatrix(n),t?new SingularValueDecomposition(n).inverse():solve$1(n,Matrix$2.eye(n.rows))}function solve$1(n,t,e=!1){return n=WrapperMatrix2D$1.checkMatrix(n),t=WrapperMatrix2D$1.checkMatrix(t),e?new SingularValueDecomposition(n).solve(t):n.isSquare()?new LuDecomposition(n).solve(t):new QrDecomposition(n).solve(t)}function determinant(n){if((n=Matrix$2.checkMatrix(n)).isSquare()){if(0===n.columns)return 1;let t,e,i,a;if(2===n.columns)return t=n.get(0,0),e=n.get(0,1),i=n.get(1,0),a=n.get(1,1),t*a-e*i;if(3===n.columns){let a,s,r;return a=new MatrixSelectionView(n,[1,2],[1,2]),s=new MatrixSelectionView(n,[1,2],[0,2]),r=new MatrixSelectionView(n,[1,2],[0,1]),t=n.get(0,0),e=n.get(0,1),i=n.get(0,2),t*determinant(a)-e*determinant(s)+i*determinant(r)}return new LuDecomposition(n).determinant}throw Error("determinant can only be calculated for a square matrix")}function xrange(n,t){let e=[];for(let i=0;i<n;i++)i!==t&&e.push(i);return e}function dependenciesOneRow(n,t,e,i=1e-9,a=1e-9){if(n>a)return new Array(t.rows+1).fill(0);{let n=t.addRow(e,[0]);for(let t=0;t<n.rows;t++)Math.abs(n.get(t,0))<i&&n.set(t,0,0);return n.to1DArray()}}function linearDependencies(n,t={}){const{thresholdValue:e=1e-9,thresholdError:i=1e-9}=t;let a=(n=Matrix$2.checkMatrix(n)).rows,s=new Matrix$2(a,a);for(let t=0;t<a;t++){let r=Matrix$2.columnVector(n.getRow(t)),o=n.subMatrixRow(xrange(a,t)).transpose(),f=new SingularValueDecomposition(o).solve(r),l=Matrix$2.sub(r,o.mmul(f)).abs().max();s.setRow(t,dependenciesOneRow(l,f,t,e,i))}return s}function pseudoInverse(n,t=Number.EPSILON){if((n=Matrix$2.checkMatrix(n)).isEmpty())return n.transpose();let e=new SingularValueDecomposition(n,{autoTranspose:!0}),i=e.leftSingularVectors,a=e.rightSingularVectors,s=e.diagonal;for(let n=0;n<s.length;n++)Math.abs(s[n])>t?s[n]=1/s[n]:s[n]=0;return a.mmul(Matrix$2.diag(s).mmul(i.transpose()))}function covariance(n,t=n,e={}){n=new Matrix$2(n);let i=!1;if("object"!=typeof t||Matrix$2.isMatrix(t)||isAnyArray.isAnyArray(t)?t=new Matrix$2(t):(e=t,t=n,i=!0),n.rows!==t.rows)throw new TypeError("Both matrices must have the same number of rows");const{center:a=!0}=e;a&&(n=n.center("column"),i||(t=t.center("column")));const s=n.transpose().mmul(t);for(let t=0;t<s.rows;t++)for(let e=0;e<s.columns;e++)s.set(t,e,s.get(t,e)*(1/(n.rows-1)));return s}function correlation(n,t=n,e={}){n=new Matrix$2(n);let i=!1;if("object"!=typeof t||Matrix$2.isMatrix(t)||isAnyArray.isAnyArray(t)?t=new Matrix$2(t):(e=t,t=n,i=!0),n.rows!==t.rows)throw new TypeError("Both matrices must have the same number of rows");const{center:a=!0,scale:s=!0}=e;a&&(n.center("column"),i||t.center("column")),s&&(n.scale("column"),i||t.scale("column"));const r=n.standardDeviation("column",{unbiased:!0}),o=i?r:t.standardDeviation("column",{unbiased:!0}),f=n.transpose().mmul(t);for(let t=0;t<f.rows;t++)for(let e=0;e<f.columns;e++)f.set(t,e,f.get(t,e)*(1/(r[t]*o[e]))*(1/(n.rows-1)));return f}class EigenvalueDecomposition{constructor(n,t={}){const{assumeSymmetric:e=!1}=t;if(!(n=WrapperMatrix2D$1.checkMatrix(n)).isSquare())throw new Error("Matrix is not a square matrix");if(n.isEmpty())throw new Error("Matrix must be non-empty");let i,a,s=n.columns,r=new Matrix$2(s,s),o=new Float64Array(s),f=new Float64Array(s),l=n,d=!1;if(d=!!e||n.isSymmetric(),d){for(i=0;i<s;i++)for(a=0;a<s;a++)r.set(i,a,l.get(i,a));tred2(s,f,o,r),tql2(s,f,o,r)}else{let n=new Matrix$2(s,s),t=new Float64Array(s);for(a=0;a<s;a++)for(i=0;i<s;i++)n.set(i,a,l.get(i,a));orthes(s,n,t,r),hqr2(s,f,o,r,n)}this.n=s,this.e=f,this.d=o,this.V=r}get realEigenvalues(){return Array.from(this.d)}get imaginaryEigenvalues(){return Array.from(this.e)}get eigenvectorMatrix(){return this.V}get diagonalMatrix(){let n,t,e=this.n,i=this.e,a=this.d,s=new Matrix$2(e,e);for(n=0;n<e;n++){for(t=0;t<e;t++)s.set(n,t,0);s.set(n,n,a[n]),i[n]>0?s.set(n,n+1,i[n]):i[n]<0&&s.set(n,n-1,i[n])}return s}}function tred2(n,t,e,i){let a,s,r,o,f,l,d,g;for(f=0;f<n;f++)e[f]=i.get(n-1,f);for(o=n-1;o>0;o--){for(g=0,r=0,l=0;l<o;l++)g+=Math.abs(e[l]);if(0===g)for(t[o]=e[o-1],f=0;f<o;f++)e[f]=i.get(o-1,f),i.set(o,f,0),i.set(f,o,0);else{for(l=0;l<o;l++)e[l]/=g,r+=e[l]*e[l];for(a=e[o-1],s=Math.sqrt(r),a>0&&(s=-s),t[o]=g*s,r-=a*s,e[o-1]=a-s,f=0;f<o;f++)t[f]=0;for(f=0;f<o;f++){for(a=e[f],i.set(f,o,a),s=t[f]+i.get(f,f)*a,l=f+1;l<=o-1;l++)s+=i.get(l,f)*e[l],t[l]+=i.get(l,f)*a;t[f]=s}for(a=0,f=0;f<o;f++)t[f]/=r,a+=t[f]*e[f];for(d=a/(r+r),f=0;f<o;f++)t[f]-=d*e[f];for(f=0;f<o;f++){for(a=e[f],s=t[f],l=f;l<=o-1;l++)i.set(l,f,i.get(l,f)-(a*t[l]+s*e[l]));e[f]=i.get(o-1,f),i.set(o,f,0)}}e[o]=r}for(o=0;o<n-1;o++){if(i.set(n-1,o,i.get(o,o)),i.set(o,o,1),r=e[o+1],0!==r){for(l=0;l<=o;l++)e[l]=i.get(l,o+1)/r;for(f=0;f<=o;f++){for(s=0,l=0;l<=o;l++)s+=i.get(l,o+1)*i.get(l,f);for(l=0;l<=o;l++)i.set(l,f,i.get(l,f)-s*e[l])}}for(l=0;l<=o;l++)i.set(l,o+1,0)}for(f=0;f<n;f++)e[f]=i.get(n-1,f),i.set(n-1,f,0);i.set(n-1,n-1,1),t[0]=0}function tql2(n,t,e,i){let a,s,r,o,f,l,d,g,u,c,b,h,D,H,j,m;for(r=1;r<n;r++)t[r-1]=t[r];t[n-1]=0;let A=0,C=0,p=Number.EPSILON;for(l=0;l<n;l++){for(C=Math.max(C,Math.abs(e[l])+Math.abs(t[l])),d=l;d<n&&!(Math.abs(t[d])<=p*C);)d++;if(d>l)do{for(a=e[l],g=(e[l+1]-a)/(2*t[l]),u=hypotenuse(g,1),g<0&&(u=-u),e[l]=t[l]/(g+u),e[l+1]=t[l]*(g+u),c=e[l+1],s=a-e[l],r=l+2;r<n;r++)e[r]-=s;for(A+=s,g=e[d],b=1,h=b,D=b,H=t[l+1],j=0,m=0,r=d-1;r>=l;r--)for(D=h,h=b,m=j,a=b*t[r],s=b*g,u=hypotenuse(g,t[r]),t[r+1]=j*u,j=t[r]/u,b=g/u,g=b*e[r]-j*a,e[r+1]=s+j*(b*a+j*e[r]),f=0;f<n;f++)s=i.get(f,r+1),i.set(f,r+1,j*i.get(f,r)+b*s),i.set(f,r,b*i.get(f,r)-j*s);g=-j*m*D*H*t[l]/c,t[l]=j*g,e[l]=b*g}while(Math.abs(t[l])>p*C);e[l]=e[l]+A,t[l]=0}for(r=0;r<n-1;r++){for(f=r,g=e[r],o=r+1;o<n;o++)e[o]<g&&(f=o,g=e[o]);if(f!==r)for(e[f]=e[r],e[r]=g,o=0;o<n;o++)g=i.get(o,r),i.set(o,r,i.get(o,f)),i.set(o,f,g)}}function orthes(n,t,e,i){let a,s,r,o,f,l,d,g=n-1;for(l=1;l<=g-1;l++){for(d=0,o=l;o<=g;o++)d+=Math.abs(t.get(o,l-1));if(0!==d){for(r=0,o=g;o>=l;o--)e[o]=t.get(o,l-1)/d,r+=e[o]*e[o];for(s=Math.sqrt(r),e[l]>0&&(s=-s),r-=e[l]*s,e[l]=e[l]-s,f=l;f<n;f++){for(a=0,o=g;o>=l;o--)a+=e[o]*t.get(o,f);for(a/=r,o=l;o<=g;o++)t.set(o,f,t.get(o,f)-a*e[o])}for(o=0;o<=g;o++){for(a=0,f=g;f>=l;f--)a+=e[f]*t.get(o,f);for(a/=r,f=l;f<=g;f++)t.set(o,f,t.get(o,f)-a*e[f])}e[l]=d*e[l],t.set(l,l-1,d*s)}}for(o=0;o<n;o++)for(f=0;f<n;f++)i.set(o,f,o===f?1:0);for(l=g-1;l>=1;l--)if(0!==t.get(l,l-1)){for(o=l+1;o<=g;o++)e[o]=t.get(o,l-1);for(f=l;f<=g;f++){for(s=0,o=l;o<=g;o++)s+=e[o]*i.get(o,f);for(s=s/e[l]/t.get(l,l-1),o=l;o<=g;o++)i.set(o,f,i.get(o,f)+s*e[o])}}}function hqr2(n,t,e,i,a){let s,r,o,f,l,d,g,u,c,b,h,D,H,j,m,A=n-1,C=n-1,p=Number.EPSILON,M=0,I=0,P=0,T=0,N=0,w=0,U=0,J=0;for(s=0;s<n;s++)for((s<0||s>C)&&(e[s]=a.get(s,s),t[s]=0),r=Math.max(s-1,0);r<n;r++)I+=Math.abs(a.get(s,r));for(;A>=0;){for(f=A;f>0&&(w=Math.abs(a.get(f-1,f-1))+Math.abs(a.get(f,f)),0===w&&(w=I),!(Math.abs(a.get(f,f-1))<p*w));)f--;if(f===A)a.set(A,A,a.get(A,A)+M),e[A]=a.get(A,A),t[A]=0,A--,J=0;else if(f===A-1){if(g=a.get(A,A-1)*a.get(A-1,A),P=(a.get(A-1,A-1)-a.get(A,A))/2,T=P*P+g,U=Math.sqrt(Math.abs(T)),a.set(A,A,a.get(A,A)+M),a.set(A-1,A-1,a.get(A-1,A-1)+M),u=a.get(A,A),T>=0){for(U=P>=0?P+U:P-U,e[A-1]=u+U,e[A]=e[A-1],0!==U&&(e[A]=u-g/U),t[A-1]=0,t[A]=0,u=a.get(A,A-1),w=Math.abs(u)+Math.abs(U),P=u/w,T=U/w,N=Math.sqrt(P*P+T*T),P/=N,T/=N,r=A-1;r<n;r++)U=a.get(A-1,r),a.set(A-1,r,T*U+P*a.get(A,r)),a.set(A,r,T*a.get(A,r)-P*U);for(s=0;s<=A;s++)U=a.get(s,A-1),a.set(s,A-1,T*U+P*a.get(s,A)),a.set(s,A,T*a.get(s,A)-P*U);for(s=0;s<=C;s++)U=i.get(s,A-1),i.set(s,A-1,T*U+P*i.get(s,A)),i.set(s,A,T*i.get(s,A)-P*U)}else e[A-1]=u+P,e[A]=u+P,t[A-1]=U,t[A]=-U;A-=2,J=0}else{if(u=a.get(A,A),c=0,g=0,f<A&&(c=a.get(A-1,A-1),g=a.get(A,A-1)*a.get(A-1,A)),10===J){for(M+=u,s=0;s<=A;s++)a.set(s,s,a.get(s,s)-u);w=Math.abs(a.get(A,A-1))+Math.abs(a.get(A-1,A-2)),u=c=.75*w,g=-.4375*w*w}if(30===J&&(w=(c-u)/2,w=w*w+g,w>0)){for(w=Math.sqrt(w),c<u&&(w=-w),w=u-g/((c-u)/2+w),s=0;s<=A;s++)a.set(s,s,a.get(s,s)-w);M+=w,u=c=g=.964}for(J+=1,l=A-2;l>=f&&(U=a.get(l,l),N=u-U,w=c-U,P=(N*w-g)/a.get(l+1,l)+a.get(l,l+1),T=a.get(l+1,l+1)-U-N-w,N=a.get(l+2,l+1),w=Math.abs(P)+Math.abs(T)+Math.abs(N),P/=w,T/=w,N/=w,l!==f)&&!(Math.abs(a.get(l,l-1))*(Math.abs(T)+Math.abs(N))<p*(Math.abs(P)*(Math.abs(a.get(l-1,l-1))+Math.abs(U)+Math.abs(a.get(l+1,l+1)))));)l--;for(s=l+2;s<=A;s++)a.set(s,s-2,0),s>l+2&&a.set(s,s-3,0);for(o=l;o<=A-1&&(j=o!==A-1,o!==l&&(P=a.get(o,o-1),T=a.get(o+1,o-1),N=j?a.get(o+2,o-1):0,u=Math.abs(P)+Math.abs(T)+Math.abs(N),0!==u&&(P/=u,T/=u,N/=u)),0!==u);o++)if(w=Math.sqrt(P*P+T*T+N*N),P<0&&(w=-w),0!==w){for(o!==l?a.set(o,o-1,-w*u):f!==l&&a.set(o,o-1,-a.get(o,o-1)),P+=w,u=P/w,c=T/w,U=N/w,T/=P,N/=P,r=o;r<n;r++)P=a.get(o,r)+T*a.get(o+1,r),j&&(P+=N*a.get(o+2,r),a.set(o+2,r,a.get(o+2,r)-P*U)),a.set(o,r,a.get(o,r)-P*u),a.set(o+1,r,a.get(o+1,r)-P*c);for(s=0;s<=Math.min(A,o+3);s++)P=u*a.get(s,o)+c*a.get(s,o+1),j&&(P+=U*a.get(s,o+2),a.set(s,o+2,a.get(s,o+2)-P*N)),a.set(s,o,a.get(s,o)-P),a.set(s,o+1,a.get(s,o+1)-P*T);for(s=0;s<=C;s++)P=u*i.get(s,o)+c*i.get(s,o+1),j&&(P+=U*i.get(s,o+2),i.set(s,o+2,i.get(s,o+2)-P*N)),i.set(s,o,i.get(s,o)-P),i.set(s,o+1,i.get(s,o+1)-P*T)}}}if(0!==I){for(A=n-1;A>=0;A--)if(P=e[A],T=t[A],0===T)for(f=A,a.set(A,A,1),s=A-1;s>=0;s--){for(g=a.get(s,s)-P,N=0,r=f;r<=A;r++)N+=a.get(s,r)*a.get(r,A);if(t[s]<0)U=g,w=N;else if(f=s,0===t[s]?a.set(s,A,0!==g?-N/g:-N/(p*I)):(u=a.get(s,s+1),c=a.get(s+1,s),T=(e[s]-P)*(e[s]-P)+t[s]*t[s],d=(u*w-U*N)/T,a.set(s,A,d),a.set(s+1,A,Math.abs(u)>Math.abs(U)?(-N-g*d)/u:(-w-c*d)/U)),d=Math.abs(a.get(s,A)),p*d*d>1)for(r=s;r<=A;r++)a.set(r,A,a.get(r,A)/d)}else if(T<0)for(f=A-1,Math.abs(a.get(A,A-1))>Math.abs(a.get(A-1,A))?(a.set(A-1,A-1,T/a.get(A,A-1)),a.set(A-1,A,-(a.get(A,A)-P)/a.get(A,A-1))):(m=cdiv(0,-a.get(A-1,A),a.get(A-1,A-1)-P,T),a.set(A-1,A-1,m[0]),a.set(A-1,A,m[1])),a.set(A,A-1,0),a.set(A,A,1),s=A-2;s>=0;s--){for(b=0,h=0,r=f;r<=A;r++)b+=a.get(s,r)*a.get(r,A-1),h+=a.get(s,r)*a.get(r,A);if(g=a.get(s,s)-P,t[s]<0)U=g,N=b,w=h;else if(f=s,0===t[s]?(m=cdiv(-b,-h,g,T),a.set(s,A-1,m[0]),a.set(s,A,m[1])):(u=a.get(s,s+1),c=a.get(s+1,s),D=(e[s]-P)*(e[s]-P)+t[s]*t[s]-T*T,H=2*(e[s]-P)*T,0===D&&0===H&&(D=p*I*(Math.abs(g)+Math.abs(T)+Math.abs(u)+Math.abs(c)+Math.abs(U))),m=cdiv(u*N-U*b+T*h,u*w-U*h-T*b,D,H),a.set(s,A-1,m[0]),a.set(s,A,m[1]),Math.abs(u)>Math.abs(U)+Math.abs(T)?(a.set(s+1,A-1,(-b-g*a.get(s,A-1)+T*a.get(s,A))/u),a.set(s+1,A,(-h-g*a.get(s,A)-T*a.get(s,A-1))/u)):(m=cdiv(-N-c*a.get(s,A-1),-w-c*a.get(s,A),U,T),a.set(s+1,A-1,m[0]),a.set(s+1,A,m[1]))),d=Math.max(Math.abs(a.get(s,A-1)),Math.abs(a.get(s,A))),p*d*d>1)for(r=s;r<=A;r++)a.set(r,A-1,a.get(r,A-1)/d),a.set(r,A,a.get(r,A)/d)}for(s=0;s<n;s++)if(s<0||s>C)for(r=s;r<n;r++)i.set(s,r,a.get(s,r));for(r=n-1;r>=0;r--)for(s=0;s<=C;s++){for(U=0,o=0;o<=Math.min(r,C);o++)U+=i.get(s,o)*a.get(o,r);i.set(s,r,U)}}}function cdiv(n,t,e,i){let a,s;return Math.abs(e)>Math.abs(i)?(a=i/e,s=e+a*i,[(n+a*t)/s,(t-a*n)/s]):(a=e/i,s=i+a*e,[(a*n+t)/s,(a*t-n)/s])}class CholeskyDecomposition{constructor(n){if(!(n=WrapperMatrix2D$1.checkMatrix(n)).isSymmetric())throw new Error("Matrix is not symmetric");let t,e,i,a=n,s=a.rows,r=new Matrix$2(s,s),o=!0;for(e=0;e<s;e++){let n=0;for(i=0;i<e;i++){let s=0;for(t=0;t<i;t++)s+=r.get(i,t)*r.get(e,t);s=(a.get(e,i)-s)/r.get(i,i),r.set(e,i,s),n+=s*s}for(n=a.get(e,e)-n,o&=n>0,r.set(e,e,Math.sqrt(Math.max(n,0))),i=e+1;i<s;i++)r.set(e,i,0)}this.L=r,this.positiveDefinite=Boolean(o)}isPositiveDefinite(){return this.positiveDefinite}solve(n){n=WrapperMatrix2D$1.checkMatrix(n);let t=this.L,e=t.rows;if(n.rows!==e)throw new Error("Matrix dimensions do not match");if(!1===this.isPositiveDefinite())throw new Error("Matrix is not positive definite");let i,a,s,r=n.columns,o=n.clone();for(s=0;s<e;s++)for(a=0;a<r;a++){for(i=0;i<s;i++)o.set(s,a,o.get(s,a)-o.get(i,a)*t.get(s,i));o.set(s,a,o.get(s,a)/t.get(s,s))}for(s=e-1;s>=0;s--)for(a=0;a<r;a++){for(i=s+1;i<e;i++)o.set(s,a,o.get(s,a)-o.get(i,a)*t.get(i,s));o.set(s,a,o.get(s,a)/t.get(s,s))}return o}get lowerTriangularMatrix(){return this.L}}class nipals{constructor(n,t={}){n=WrapperMatrix2D$1.checkMatrix(n);let{Y:e}=t;const{scaleScores:i=!1,maxIterations:a=1e3,terminationCriteria:s=1e-10}=t;let r;if(e){if(e=isAnyArray.isAnyArray(e)&&"number"==typeof e[0]?Matrix$2.columnVector(e):WrapperMatrix2D$1.checkMatrix(e),e.rows!==n.rows)throw new Error("Y should have the same number of rows as X");r=e.getColumnVector(0)}else r=n.getColumnVector(0);let o,f,l,d,g=1;for(let t=0;t<a&&g>s;t++)l=n.transpose().mmul(r).div(r.transpose().mmul(r).get(0,0)),l=l.div(l.norm()),o=n.mmul(l).div(l.transpose().mmul(l).get(0,0)),t>0&&(g=o.clone().sub(d).pow(2).sum()),d=o.clone(),e?(f=e.transpose().mmul(o).div(o.transpose().mmul(o).get(0,0)),f=f.div(f.norm()),r=e.mmul(f).div(f.transpose().mmul(f).get(0,0))):r=o;if(e){let t=n.transpose().mmul(o).div(o.transpose().mmul(o).get(0,0));t=t.div(t.norm());let i=n.clone().sub(o.clone().mmul(t.transpose())),a=r.transpose().mmul(o).div(o.transpose().mmul(o).get(0,0)),s=e.clone().sub(o.clone().mulS(a.get(0,0)).mmul(f.transpose()));this.t=o,this.p=t.transpose(),this.w=l.transpose(),this.q=f,this.u=r,this.s=o.transpose().mmul(o),this.xResidual=i,this.yResidual=s,this.betas=a}else this.w=l.transpose(),this.s=o.transpose().mmul(o).sqrt(),this.t=i?o.clone().div(this.s.get(0,0)):o,this.xResidual=n.sub(o.mmul(l.transpose()))}}matrix.AbstractMatrix=AbstractMatrix,matrix.CHO=CholeskyDecomposition,matrix.CholeskyDecomposition=CholeskyDecomposition,matrix.DistanceMatrix=DistanceMatrix;var EVD$1=matrix.EVD=EigenvalueDecomposition;matrix.EigenvalueDecomposition=EigenvalueDecomposition,matrix.LU=LuDecomposition,matrix.LuDecomposition=LuDecomposition;var Matrix_1=matrix.Matrix=Matrix$2;matrix.MatrixColumnSelectionView=MatrixColumnSelectionView,matrix.MatrixColumnView=MatrixColumnView,matrix.MatrixFlipColumnView=MatrixFlipColumnView,matrix.MatrixFlipRowView=MatrixFlipRowView,matrix.MatrixRowSelectionView=MatrixRowSelectionView,matrix.MatrixRowView=MatrixRowView,matrix.MatrixSelectionView=MatrixSelectionView,matrix.MatrixSubView=MatrixSubView;var MatrixTransposeView_1=matrix.MatrixTransposeView=MatrixTransposeView$1;matrix.NIPALS=nipals,matrix.Nipals=nipals,matrix.QR=QrDecomposition,matrix.QrDecomposition=QrDecomposition;var SVD$1=matrix.SVD=SingularValueDecomposition;matrix.SingularValueDecomposition=SingularValueDecomposition,matrix.SymmetricMatrix=SymmetricMatrix,matrix.WrapperMatrix1D=WrapperMatrix1D;var WrapperMatrix2D_1=matrix.WrapperMatrix2D=WrapperMatrix2D$1;matrix.correlation=correlation,matrix.covariance=covariance;var _default=matrix.default=Matrix$2;matrix.determinant=determinant;var inverse_1=matrix.inverse=inverse$1;matrix.linearDependencies=linearDependencies,matrix.pseudoInverse=pseudoInverse;var solve_1=matrix.solve=solve$1;matrix.wrap=wrap;const EVD=EVD$1,Matrix=Matrix_1,MatrixTransposeView=MatrixTransposeView_1,SVD=SVD$1,WrapperMatrix2D=WrapperMatrix2D_1;var Matrix$1=_default.Matrix?_default.Matrix:Matrix_1;const inverse=inverse_1,solve=solve_1;function xEnsureFloat64(n){return xCheck(n),n instanceof Float64Array?n.slice(0):Float64Array.from(n)}function FFT$1(n){if(this.size=0|n,this.size<=1||this.size&this.size-1)throw new Error("FFT size must be a power of two and bigger than 1");this._csize=n<<1;for(var t=new Array(2*this.size),e=0;e<t.length;e+=2){const n=Math.PI*e/this.size;t[e]=Math.cos(n),t[e+1]=-Math.sin(n)}this.table=t;for(var i=0,a=1;this.size>a;a<<=1)i++;this._width=i%2==0?i-1:i,this._bitrev=new Array(1<<this._width);for(var s=0;s<this._bitrev.length;s++){this._bitrev[s]=0;for(var r=0;r<this._width;r+=2){var o=this._width-r-2;this._bitrev[s]|=(s>>>r&3)<<o}}this._out=null,this._data=null,this._inv=0}var fft$1=FFT$1;FFT$1.prototype.fromComplexArray=function(n,t){for(var e=t||new Array(n.length>>>1),i=0;i<n.length;i+=2)e[i>>>1]=n[i];return e},FFT$1.prototype.createComplexArray=function(){const n=new Array(this._csize);for(var t=0;t<n.length;t++)n[t]=0;return n},FFT$1.prototype.toComplexArray=function(n,t){for(var e=t||this.createComplexArray(),i=0;i<e.length;i+=2)e[i]=n[i>>>1],e[i+1]=0;return e},FFT$1.prototype.completeSpectrum=function(n){for(var t=this._csize,e=t>>>1,i=2;i<e;i+=2)n[t-i]=n[i],n[t-i+1]=-n[i+1]},FFT$1.prototype.transform=function(n,t){if(n===t)throw new Error("Input and output buffers must be different");this._out=n,this._data=t,this._inv=0,this._transform4(),this._out=null,this._data=null},FFT$1.prototype.realTransform=function(n,t){if(n===t)throw new Error("Input and output buffers must be different");this._out=n,this._data=t,this._inv=0,this._realTransform4(),this._out=null,this._data=null},FFT$1.prototype.inverseTransform=function(n,t){if(n===t)throw new Error("Input and output buffers must be different");this._out=n,this._data=t,this._inv=1,this._transform4();for(var e=0;e<n.length;e++)n[e]/=this.size;this._out=null,this._data=null},FFT$1.prototype._transform4=function(){var n,t,e=this._out,i=this._csize,a=1<<this._width,s=i/a<<1,r=this._bitrev;if(4===s)for(n=0,t=0;n<i;n+=s,t++){const e=r[t];this._singleTransform2(n,e,a)}else for(n=0,t=0;n<i;n+=s,t++){const e=r[t];this._singleTransform4(n,e,a)}var o=this._inv?-1:1,f=this.table;for(a>>=2;a>=2;a>>=2){var l=(s=i/a<<1)>>>2;for(n=0;n<i;n+=s)for(var d=n+l,g=n,u=0;g<d;g+=2,u+=a){const n=g,t=n+l,i=t+l,a=i+l,s=e[n],r=e[n+1],d=e[t],c=e[t+1],b=e[i],h=e[i+1],D=e[a],H=e[a+1],j=s,m=r,A=f[u],C=o*f[u+1],p=d*A-c*C,M=d*C+c*A,I=f[2*u],P=o*f[2*u+1],T=b*I-h*P,N=b*P+h*I,w=f[3*u],U=o*f[3*u+1],J=D*w-H*U,L=D*U+H*w,y=j+T,B=m+N,R=j-T,k=m-N,x=p+J,E=M+L,F=o*(p-J),Q=o*(M-L),z=y+x,S=B+E,X=y-x,G=B-E,Y=R+Q,q=k-F,V=R-Q,v=k+F;e[n]=z,e[n+1]=S,e[t]=Y,e[t+1]=q,e[i]=X,e[i+1]=G,e[a]=V,e[a+1]=v}}},FFT$1.prototype._singleTransform2=function(n,t,e){const i=this._out,a=this._data,s=a[t],r=a[t+1],o=a[t+e],f=a[t+e+1],l=s+o,d=r+f,g=s-o,u=r-f;i[n]=l,i[n+1]=d,i[n+2]=g,i[n+3]=u},FFT$1.prototype._singleTransform4=function(n,t,e){const i=this._out,a=this._data,s=this._inv?-1:1,r=2*e,o=3*e,f=a[t],l=a[t+1],d=a[t+e],g=a[t+e+1],u=a[t+r],c=a[t+r+1],b=a[t+o],h=a[t+o+1],D=f+u,H=l+c,j=f-u,m=l-c,A=d+b,C=g+h,p=s*(d-b),M=s*(g-h),I=D+A,P=H+C,T=j+M,N=m-p,w=D-A,U=H-C,J=j-M,L=m+p;i[n]=I,i[n+1]=P,i[n+2]=T,i[n+3]=N,i[n+4]=w,i[n+5]=U,i[n+6]=J,i[n+7]=L},FFT$1.prototype._realTransform4=function(){var n,t,e=this._out,i=this._csize,a=1<<this._width,s=i/a<<1,r=this._bitrev;if(4===s)for(n=0,t=0;n<i;n+=s,t++){const e=r[t];this._singleRealTransform2(n,e>>>1,a>>>1)}else for(n=0,t=0;n<i;n+=s,t++){const e=r[t];this._singleRealTransform4(n,e>>>1,a>>>1)}var o=this._inv?-1:1,f=this.table;for(a>>=2;a>=2;a>>=2){var l=(s=i/a<<1)>>>1,d=l>>>1,g=d>>>1;for(n=0;n<i;n+=s)for(var u=0,c=0;u<=g;u+=2,c+=a){var b=n+u,h=b+d,D=h+d,H=D+d,j=e[b],m=e[b+1],A=e[h],C=e[h+1],p=e[D],M=e[D+1],I=e[H],P=e[H+1],T=j,N=m,w=f[c],U=o*f[c+1],J=A*w-C*U,L=A*U+C*w,y=f[2*c],B=o*f[2*c+1],R=p*y-M*B,k=p*B+M*y,x=f[3*c],E=o*f[3*c+1],F=I*x-P*E,Q=I*E+P*x,z=T+R,S=N+k,X=T-R,G=N-k,Y=J+F,q=L+Q,V=o*(J-F),v=o*(L-Q),Z=z+Y,O=S+q,K=X+v,W=G-V;if(e[b]=Z,e[b+1]=O,e[h]=K,e[h+1]=W,0!==u){if(u!==g){var _=X+-o*v,$=-G+-o*V,nn=z+-o*Y,tn=-S- -o*q,en=n+d-u,an=n+l-u;e[en]=_,e[en+1]=$,e[an]=nn,e[an+1]=tn}}else{var sn=z-Y,rn=S-q;e[D]=sn,e[D+1]=rn}}}},FFT$1.prototype._singleRealTransform2=function(n,t,e){const i=this._out,a=this._data,s=a[t],r=a[t+e],o=s+r,f=s-r;i[n]=o,i[n+1]=0,i[n+2]=f,i[n+3]=0},FFT$1.prototype._singleRealTransform4=function(n,t,e){const i=this._out,a=this._data,s=this._inv?-1:1,r=2*e,o=3*e,f=a[t],l=a[t+e],d=a[t+r],g=a[t+o],u=f+d,c=f-d,b=l+g,h=s*(l-g),D=u+b,H=c,j=-h,m=u-b,A=c,C=h;i[n]=D,i[n+1]=0,i[n+2]=H,i[n+3]=j,i[n+4]=m,i[n+5]=0,i[n+6]=A,i[n+7]=C};var FFT$2=fft$1;function createNumberArray(n,t){return n===Array?new n(t).fill(0):new n(t)}function createFromToArray(n={}){const{from:t=0,to:e=1,length:i=1e3,includeFrom:a=!0,includeTo:s=!0,distribution:r="uniform"}=n,o=new Float64Array(i);let f=i;a&&s?f=i-1:!a&&s||a&&!s?f=i:a||s||(f=i+1);const l=(e-t)/f;if("uniform"===r)if(a){let n=0;for(;n<i;)o[n]=t+l*n,n++}else{let n=0;for(;n<i;)o[n]=t+l*(n+1),n++}else{if("log"!==r)throw new Error("distribution must be uniform or log");{const n=(e/t)**(1/f),s=Math.log(t)/Math.log(n);if(a){let t=0;for(;t<i;)o[t]=n**(s+t),t++}else{let t=0;for(;t<i;)o[t]=n**(s+t+1),t++}}}return o}const LOOP=8,FLOAT_MUL=1/16777216,sh1=15,sh2=18,sh3=11;function multiply_uint32(n,t){const e=65535&(n>>>=0);return((n-e)*(t>>>=0)>>>0)+e*t>>>0}class XSadd{constructor(n=Date.now()){this.state=new Uint32Array(4),this.init(n),this.random=this.getFloat.bind(this)}getUint32(){return this.nextState(),this.state[3]+this.state[2]>>>0}getFloat(){return(this.getUint32()>>>8)*FLOAT_MUL}init(n){if(!Number.isInteger(n))throw new TypeError("seed must be an integer");this.state[0]=n,this.state[1]=0,this.state[2]=0,this.state[3]=0;for(let n=1;n<LOOP;n++)this.state[3&n]^=n+multiply_uint32(1812433253,this.state[n-1&3]^this.state[n-1&3]>>>30>>>0)>>>0;this.periodCertification();for(let n=0;n<LOOP;n++)this.nextState()}periodCertification(){0===this.state[0]&&0===this.state[1]&&0===this.state[2]&&0===this.state[3]&&(this.state[0]=88,this.state[1]=83,this.state[2]=65,this.state[3]=68)}nextState(){let n=this.state[0];n^=n<<sh1,n^=n>>>sh2,n^=this.state[3]<<sh3,this.state[0]=this.state[1],this.state[1]=this.state[2],this.state[2]=this.state[3],this.state[3]=n}}var __classPrivateFieldSet=function(n,t,e,i,a){if("m"===i)throw new TypeError("Private method is not writable");if("a"===i&&!a)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?n!==t||!a:!t.has(n))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===i?a.call(n,e):a?a.value=e:t.set(n,e),e},__classPrivateFieldGet=function(n,t,e,i){if("a"===e&&!i)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?n!==t||!i:!t.has(n))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===e?i:"a"===e?i.call(n):i?i.value:t.get(n)},_GaussianGenerator_spare,_GaussianGenerator_hasSpare,_GaussianGenerator_mean,_GaussianGenerator_standardDeviation,_GaussianGenerator_generator;function createRandomArray(n={}){const{mean:t=0,standardDeviation:e=1,length:i=1e3,range:a=1,seed:s,distribution:r="normal"}=n,o=new XSadd(s),f=new Float64Array(i);switch(r){case"normal":{const n=new GaussianGenerator(t,e,o);for(let t=0;t<i;t++)f[t]=n.generateGaussian();break}case"uniform":for(let n=0;n<i;n++)f[n]=(o.random()-.5)*a+t;break;default:throw new Error(`unknown distribution: ${String(r)}`)}return f}class GaussianGenerator{constructor(n,t,e){_GaussianGenerator_spare.set(this,0),_GaussianGenerator_hasSpare.set(this,!1),_GaussianGenerator_mean.set(this,void 0),_GaussianGenerator_standardDeviation.set(this,void 0),_GaussianGenerator_generator.set(this,void 0),__classPrivateFieldSet(this,_GaussianGenerator_mean,n,"f"),__classPrivateFieldSet(this,_GaussianGenerator_standardDeviation,t,"f"),__classPrivateFieldSet(this,_GaussianGenerator_generator,e,"f")}generateGaussian(){let n,t,e,i;if(__classPrivateFieldGet(this,_GaussianGenerator_hasSpare,"f"))__classPrivateFieldSet(this,_GaussianGenerator_hasSpare,!1,"f"),n=__classPrivateFieldGet(this,_GaussianGenerator_spare,"f")*__classPrivateFieldGet(this,_GaussianGenerator_standardDeviation,"f")+__classPrivateFieldGet(this,_GaussianGenerator_mean,"f");else{do{t=2*__classPrivateFieldGet(this,_GaussianGenerator_generator,"f").random()-1,e=2*__classPrivateFieldGet(this,_GaussianGenerator_generator,"f").random()-1,i=t*t+e*e}while(i>=1||0===i);i=Math.sqrt(-2*Math.log(i)/i),__classPrivateFieldSet(this,_GaussianGenerator_spare,e*i,"f"),__classPrivateFieldSet(this,_GaussianGenerator_hasSpare,!0,"f"),n=__classPrivateFieldGet(this,_GaussianGenerator_mean,"f")+__classPrivateFieldGet(this,_GaussianGenerator_standardDeviation,"f")*t*i}return n}}function xMaxValue(n,t={}){xCheck(n);const{fromIndex:e,toIndex:i}=xGetFromToIndex(n,t);let a=n[e];for(let t=e+1;t<=i;t++)n[t]>a&&(a=n[t]);return a}function xMinValue(n,t={}){xCheck(n);const{fromIndex:e,toIndex:i}=xGetFromToIndex(n,t);let a=n[e];for(let t=e+1;t<=i;t++)n[t]<a&&(a=n[t]);return a}function xIsEquallySpaced(n,t={}){if(n.length<3)return!0;const{tolerance:e=.05}=t;let i=0,a=Number.MAX_SAFE_INTEGER;for(let t=0;t<n.length-1;++t){const e=n[t+1]-n[t];e<a&&(a=e),e>i&&(i=e)}return(i-a)/i<e}function xIsMonotonic(n){if(n.length<=2)return 1;if(n[0]===n[1]){for(let t=1;t<n.length-1;t++)if(n[t]!==n[t+1])return 0;return 1}if(n[0]<n[n.length-1]){for(let t=0;t<n.length-1;t++)if(n[t]>=n[t+1])return 0;return 1}for(let t=0;t<n.length-1;t++)if(n[t]<=n[t+1])return 0;return-1}function xMaxAbsoluteValue(n,t={}){xCheck(n);const{fromIndex:e,toIndex:i}=xGetFromToIndex(n,t);let a=n[e];for(let t=e+1;t<=i;t++)n[t]>=0?n[t]>a&&(a=n[t]):-n[t]>a&&(a=-n[t]);return a}function xMaxIndex(n,t={}){xCheck(n);const{fromIndex:e,toIndex:i}=xGetFromToIndex(n,t);let a=e;for(let t=e+1;t<=i;t++)n[t]>n[a]&&(a=t);return a}function xMean(n,t={}){xCheck(n);const{fromIndex:e,toIndex:i}=xGetFromToIndex(n,t);let a=n[e];for(let t=e+1;t<=i;t++)a+=n[t];return a/(i-e+1)}function xMedianAbsoluteDeviation(n){const t=xMedian(n),e=new Float64Array(n.length);for(let i=0;i<n.length;i++)e[i]=Math.abs(n[i]-t);return{median:t,mad:xMedian(e)}}function xMinMaxValues(n){xCheck(n);let t=n[0],e=n[0];for(const i of n)i<t&&(t=i),i>e&&(e=i);return{min:t,max:e}}_GaussianGenerator_spare=new WeakMap,_GaussianGenerator_hasSpare=new WeakMap,_GaussianGenerator_mean=new WeakMap,_GaussianGenerator_standardDeviation=new WeakMap,_GaussianGenerator_generator=new WeakMap;var d3Array={exports:{}};!function(n,t){!function(n){function t(n,t){return n<t?-1:n>t?1:n>=t?0:NaN}function e(n){return 1===n.length&&(n=i(n)),{left:function(t,e,i,a){for(null==i&&(i=0),null==a&&(a=t.length);i<a;){var s=i+a>>>1;n(t[s],e)<0?i=s+1:a=s}return i},right:function(t,e,i,a){for(null==i&&(i=0),null==a&&(a=t.length);i<a;){var s=i+a>>>1;n(t[s],e)>0?a=s:i=s+1}return i}}}function i(n){return function(e,i){return t(n(e),i)}}var a=e(t),s=a.right,r=a.left;function o(n,t){return t<n?-1:t>n?1:t>=n?0:NaN}function f(n){return null===n?NaN:+n}function l(n,t){var e,i,a=n.length,s=0,r=0,o=-1,l=0;if(null==t)for(;++o<a;)isNaN(e=f(n[o]))||(r+=(i=e-s)*(e-(s+=i/++l)));else for(;++o<a;)isNaN(e=f(t(n[o],o,n)))||(r+=(i=e-s)*(e-(s+=i/++l)));if(l>1)return r/(l-1)}function d(n,t){var e=l(n,t);return e?Math.sqrt(e):e}function g(n,t){var e,i,a,s=-1,r=n.length;if(null==t){for(;++s<r;)if(null!=(i=n[s])&&i>=i){e=a=i;break}for(;++s<r;)null!=(i=n[s])&&(e>i&&(e=i),a<i&&(a=i))}else{for(;++s<r;)if(null!=(i=t(n[s],s,n))&&i>=i){e=a=i;break}for(;++s<r;)null!=(i=t(n[s],s,n))&&(e>i&&(e=i),a<i&&(a=i))}return[e,a]}function u(n){return function(){return n}}function c(n){return n}function b(n,t,e){n=+n,t=+t,e=(a=arguments.length)<2?(t=n,n=0,1):a<3?1:+e;for(var i=-1,a=0|Math.max(0,Math.ceil((t-n)/e)),s=new Array(a);++i<a;)s[i]=n+i*e;return s}var h=Math.sqrt(50),D=Math.sqrt(10),H=Math.sqrt(2);function j(n,t,e){var i=m(n,t,e);return b(Math.ceil(n/i)*i,Math.floor(t/i)*i+i/2,i)}function m(n,t,e){var i=Math.abs(t-n)/Math.max(0,e),a=Math.pow(10,Math.floor(Math.log(i)/Math.LN10)),s=i/a;return s>=h?a*=10:s>=D?a*=5:s>=H&&(a*=2),t<n?-a:a}function A(n){return Math.ceil(Math.log(n.length)/Math.LN2)+1}function C(n){return+n}function p(){var n=c,t=g,e=A;function i(i){var a,r,o=i.length,f=new Array(o);for(a=0;a<o;++a)f[a]=+n(i[a],a,i);var l=t(f),d=+l[0],g=+l[1],u=e(f,d,g);Array.isArray(u)||(u=j(d,g,+u));var c=u.length;for(a=0;a<c;++a)u[a]=+u[a];for(;u[0]<=d;)u.shift(),--c;for(;u[c-1]>=g;)u.pop(),--c;var b,h=new Array(c+1);for(a=0;a<=c;++a)(b=h[a]=[]).x0=a>0?u[a-1]:d,b.x1=a<c?u[a]:g;for(a=0;a<o;++a)d<=(r=f[a])&&r<=g&&h[s(u,r,0,c)].push(i[a]);return h}return i.value=function(t){return arguments.length?(n="function"==typeof t?t:u(+t),i):n},i.domain=function(n){return arguments.length?(t="function"==typeof n?n:u([+n[0],+n[1]]),i):t},i.thresholds=function(n){return arguments.length?(e="function"==typeof n?n:Array.isArray(n)?u(Array.prototype.map.call(n,C)):u(+n),i):e},i}function M(n,t,e){if(null==e&&(e=f),i=n.length){if((t=+t)<=0||i<2)return+e(n[0],0,n);if(t>=1)return+e(n[i-1],i-1,n);var i,a=(i-1)*t,s=Math.floor(a),r=+e(n[s],s,n);return r+(+e(n[s+1],s+1,n)-r)*(a-s)}}function I(n,e,i){return n.sort(t),Math.ceil((i-e)/(2*(M(n,.75)-M(n,.25))*Math.pow(n.length,-1/3)))}function P(n,t,e){return Math.ceil((e-t)/(3.5*d(n)*Math.pow(n.length,-1/3)))}function T(n,t){var e,i,a=-1,s=n.length;if(null==t){for(;++a<s;)if(null!=(i=n[a])&&i>=i){e=i;break}for(;++a<s;)null!=(i=n[a])&&i>e&&(e=i)}else{for(;++a<s;)if(null!=(i=t(n[a],a,n))&&i>=i){e=i;break}for(;++a<s;)null!=(i=t(n[a],a,n))&&i>e&&(e=i)}return e}function N(n,t){var e,i=0,a=n.length,s=-1,r=a;if(null==t)for(;++s<a;)isNaN(e=f(n[s]))?--r:i+=e;else for(;++s<a;)isNaN(e=f(t(n[s],s,n)))?--r:i+=e;if(r)return i/r}function w(n,e){var i,a=[],s=n.length,r=-1;if(null==e)for(;++r<s;)isNaN(i=f(n[r]))||a.push(i);else for(;++r<s;)isNaN(i=f(e(n[r],r,n)))||a.push(i);return M(a.sort(t),.5)}function U(n){for(var t,e,i,a=n.length,s=-1,r=0;++s<a;)r+=n[s].length;for(e=new Array(r);--a>=0;)for(t=(i=n[a]).length;--t>=0;)e[--r]=i[t];return e}function J(n,t){var e,i,a=-1,s=n.length;if(null==t){for(;++a<s;)if(null!=(i=n[a])&&i>=i){e=i;break}for(;++a<s;)null!=(i=n[a])&&e>i&&(e=i)}else{for(;++a<s;)if(null!=(i=t(n[a],a,n))&&i>=i){e=i;break}for(;++a<s;)null!=(i=t(n[a],a,n))&&e>i&&(e=i)}return e}function L(n){for(var t=0,e=n.length-1,i=n[0],a=new Array(e<0?0:e);t<e;)a[t]=[i,i=n[++t]];return a}function y(n,t){for(var e=t.length,i=new Array(e);e--;)i[e]=n[t[e]];return i}function B(n,e){if(i=n.length){var i,a,s=0,r=0,o=n[r];for(e||(e=t);++s<i;)(e(a=n[s],o)<0||0!==e(o,o))&&(o=a,r=s);return 0===e(o,o)?r:void 0}}function R(n,t,e){for(var i,a,s=(null==e?n.length:e)-(t=null==t?0:+t);s;)a=Math.random()*s--|0,i=n[s+t],n[s+t]=n[a+t],n[a+t]=i;return n}function k(n,t){var e,i=0,a=n.length,s=-1;if(null==t)for(;++s<a;)(e=+n[s])&&(i+=e);else for(;++s<a;)(e=+t(n[s],s,n))&&(i+=e);return i}function x(n){if(!(a=n.length))return[];for(var t=-1,e=J(n,E),i=new Array(e);++t<e;)for(var a,s=-1,r=i[t]=new Array(a);++s<a;)r[s]=n[s][t];return i}function E(n){return n.length}function F(){return x(arguments)}var Q="0.7.1";n.version=Q,n.bisect=s,n.bisectRight=s,n.bisectLeft=r,n.ascending=t,n.bisector=e,n.descending=o,n.deviation=d,n.extent=g,n.histogram=p,n.thresholdFreedmanDiaconis=I,n.thresholdScott=P,n.thresholdSturges=A,n.max=T,n.mean=N,n.median=w,n.merge=U,n.min=J,n.pairs=L,n.permute=y,n.quantile=M,n.range=b,n.scan=B,n.shuffle=R,n.sum=k,n.ticks=j,n.tickStep=m,n.transpose=x,n.variance=l,n.zip=F}(t)}(0,d3Array.exports);const{bisectRight:bisectRight}=d3Array.exports,quincunx=(n,t,e,i)=>{const a=n.length-1;n[0]=0,t[0]=0,e[0]=0,t[1]=t[1]/n[1],e[1]=e[1]/n[1];for(let i=2;i<a;++i)n[i]=n[i]-n[i-2]*e[i-2]*e[i-2]-n[i-1]*t[i-1]*t[i-1],t[i]=(t[i]-n[i-1]*t[i-1]*e[i-1])/n[i],e[i]=e[i]/n[i];for(let n=2;n<a;++n)i[n]=i[n]-t[n-1]*i[n-1]-e[n-2]*i[n-2];for(let t=1;t<a;++t)i[t]=i[t]/n[t];i[a-2]=i[a-2]-t[a-2]*i[a-1];for(let n=a-3;n>0;--n)i[n]=i[n]-t[n]*i[n+1]-e[n]*i[n+2]},smoothingSpline=(n,t,e,i)=>{const a=n.length-1,s=new Array(a+1),r=new Array(a+1),o=new Array(a+1),f=new Array(a+1),l=new Array(a+1),d=new Array(a+1),g=new Array(a+1),u=new Array(a+1),c=n.map((()=>[0,0,0,0]));c.pop();const b=2*(1-i)/(3*i);for(let t=0;t<a;++t)s[t]=n[t+1]-n[t],r[t]=3/s[t];l[0]=0;for(let e=1;e<a;++e)o[e]=-(r[e-1]+r[e]),f[e]=2*(n[e+1]-n[e-1]),l[e]=3*(t[e+1]-t[e])/s[e]-3*(t[e]-t[e-1])/s[e-1];l[a]=0;for(let n=1;n<a;++n)d[n]=r[n-1]*r[n-1]*e[n-1]+o[n]*o[n]*e[n]+r[n]*r[n]*e[n+1],d[n]=b*d[n]+f[n];for(let n=1;n<a-1;++n)g[n]=o[n]*r[n]*e[n]+r[n]*o[n+1]*e[n+1],g[n]=b*g[n]+s[n];for(let n=1;n<a-2;++n)u[n]=b*r[n]*r[n+1]*e[n+1];quincunx(d,g,u,l),c[0][3]=t[0]-b*r[0]*l[1]*e[0],c[1][3]=t[1]-b*(o[1]*l[1]+r[1]*l[2])*e[0],c[0][0]=l[1]/(3*s[0]),c[0][1]=0,c[0][2]=(c[1][3]-c[0][3])/s[0]-l[1]*s[0]/3,r[0]=0;for(let n=1;n<a;++n)c[n][0]=(l[n+1]-l[n])/(3*s[n]),c[n][1]=l[n],c[n][2]=(l[n]+l[n-1])*s[n-1]+c[n-1][2],c[n][3]=r[n-1]*l[n-1]+o[n]*l[n]+r[n]*l[n+1],c[n][3]=t[n]-b*c[n][3]*e[n];return c};class SplineInterpolator{constructor(n,t,e=1){const i=n.map(((n,t)=>t));i.sort(((t,e)=>n[t]-n[e]));const a=i.map((t=>n[t])),s=i.map((n=>t[n])),r=i.length,o=i.map((()=>1));this.n=r,this.x=a,this.y=s,this.params=smoothingSpline(a,s,o,e)}interpolate(n){if(n===this.x[this.n-1])return this.y[this.n-1];const t=Math.min(Math.max(0,bisectRight(this.x,n)-1),this.n-2),[e,i,a,s]=this.params[t];return e*(n-=this.x[t])*n*n+i*n*n+a*n+s}max(n=100){const t=this.x[0],e=(this.x[this.n-1]-t)/n;let i=-1/0;for(let a=0,s=t;a<n;++a,s+=e){const n=this.interpolate(s);n>i&&(i=n)}return i}min(n=100){const t=this.x[0],e=(this.x[this.n-1]-t)/n;let i=1/0;for(let a=0,s=t;a<n;++a,s+=e){const n=this.interpolate(s);n<i&&(i=n)}return i}domain(){return[this.x[0],this.x[this.x.length-1]]}range(){return[this.min(),this.max()]}curve(n,t=null){const e=((t=t||this.domain())[1]-t[0])/(n-1),i=new Array(n);for(let a=0;a<n;++a){const n=e*a+t[0];i[a]=[n,this.interpolate(n)]}return i}}var splineInterpolator=SplineInterpolator,SplineInterpolator$1=splineInterpolator;const Y1=.08913147449493408,P1=[-.005387729650712429,.008226878746769157,.02198786811111689,-.03656379714117627,-.012692614766297404,.03348066254097446,-.008368748197417368,-.0005087819496582806],Q1=[.0008862163904564247,-.0023339375937419,.07952836873415717,-.05273963823400997,-.7122890234154284,.662328840472003,1.5622155839842302,-1.5657455823417585,-.9700050433032906,1],Y2=2.249481201171875,P2=[-3.6719225470772936,21.12946554483405,17.445385985570866,-44.6382324441787,-18.851064805871424,17.644729840837403,8.3705032834312,.10526468069939171,-.20243350835593876],Q2=[1.7211476576120028,-22.643693341313973,10.826866735546016,48.560921310873994,-20.14326346804852,-28.66081804998,3.971343795334387,6.242641248542475,1],Y3=.807220458984375,P3=[-6.81149956853777e-10,2.8522533178221704e-8,-6.794655751811263e-7,.0021455899538880526,.029015791000532906,.14286953440815717,.3377855389120359,.38707973897260434,.11703015634199525,-.16379404719331705,-.1311027816799519],Q3=[.011059242293464892,.15226433829533179,.848854343457902,2.5930192162362027,4.778465929458438,5.381683457070069,3.4662540724256723,1],Y4=.9399557113647461,P4=[26633922742578204e-28,-2.304047769118826e-10,460469890584318e-20,.00015754461742496055,.0018712349281955923,.009508047013259196,.018557330651423107,-.0022242652921344794,-.0350353787183178],Q4=[7646752923027944e-20,.00263861676657016,.03415891436709477,.22009110576413124,.7620591645536234,1.3653349817554064,1],Y5=.9836282730102539,P5=[9905570997331033e-32,-2811287356288318e-29,4.625961635228786e-9,4.4969678992770644e-7,14962478375834237e-21,.00020938631748758808,.001056288621524929,-.0011295143874558028,-.016743100507663373],Q5=[2.82243172016108e-7,27533547476472603e-21,.0009640118070051656,.016074608709367652,.1381518657490833,.5914293448864175,1];function polyval(n,t){let e=0;for(const i of n)e=e*t+i;return e}function calc(n,t,e,i,a){const s=n-t;return a*n+polyval(e,s)/polyval(i,s)*n}function erfcinv(n){let t,e,i,a,s=!1;if(Number.isNaN(n))return Number.NaN;if(n<0||n>2)throw new RangeError(`erfcinv()::invalid input argument. Value must be on the interval [0,2]. Value: \`${n}\`.`);return 0===n?Number.POSITIVE_INFINITY:2===n?Number.NEGATIVE_INFINITY:1===n?0:(n>1?(e=2-n,n=1-e,s=!0):(e=n,n=1-n),n<=.5?(i=n*(n+10),a=polyval(P1,n)/polyval(Q1,n),t=i*Y1+i*a,s?-t:t):e>=.25?(i=Math.sqrt(-2*Math.log(e)),e-=.25,a=polyval(P2,e)/polyval(Q2,e),t=i/(Y2+a),s?-t:t):(e=Math.sqrt(-Math.log(e)),e<3?calc(e,1.125,P3,Q3,Y3):e<6?calc(e,3,P4,Q4,Y4):calc(e,6,P5,Q5,Y5)))}function rayleighCdf(n,t=1){return n<0?0:-Math.expm1(-(n**2)/(2*t**2))}function xNoiseSanPlot(n,t={}){const{mask:e,cutOff:i,refine:a=!0,magnitudeMode:s=!1,scaleFactor:r=1,factorStd:o=5,fixOffset:f=!0}=t;let l;if(l=Array.isArray(e)&&e.length===n.length?new Float64Array(n.filter(((n,t)=>!e[t]))):new Float64Array(n),r>1)for(let n=0;n<l.length;n++)l[n]*=r;if(l=l.sort().reverse(),f&&!s){const n=Math.floor(l.length/2),t=.5*(l[n]+l[n+1]);for(let n=0;n<l.length;n++)l[n]-=t}const d=l[l.length-1]>=0?l.length:l.findIndex((n=>n<0));let g=d-1;for(let n=g;n>=0;n--)if(l[n]>0){g=n;break}const u=l.slice(0,g+1),c=l.slice(d),b=i||determineCutOff(u,{magnitudeMode:s});let h=u[Math.floor(u.length*b)];const D=u[0];let H;if(c.length>0){H=-1*c[Math.floor(c.length*(1-b))]}else H=0;let j=h,m=H,A=u.slice(),C=c.slice(),p=0,M=2;if(a){let n=j*o;p=u.findIndex((t=>t<n)),p>-1&&(A=u.slice(p),j=A[Math.floor(A.length*b)]),n=m*o,M=c.findIndex((t=>t<n)),M>-1&&(C=c.slice(M),m=A[Math.floor(C.length*(1-b))])}const I=-simpleNormInvNumber(b/2,{magnitudeMode:s});let P,T;return h/=I,H/=I,a&&p>-1?(P=(b*A.length+p)/(A.length+p),T=-1*simpleNormInvNumber(P/2,{magnitudeMode:s}),j/=T,M>-1&&(P=(b*C.length+M)/(C.length+M),T=-1*simpleNormInvNumber(P/2,{magnitudeMode:s}),0!==m&&(m/=T))):(j/=I,m/=I),{positive:j,negative:m,snr:D/j,sanplot:generateSanPlot(l,{fromTo:{positive:{from:0,to:g},negative:{from:d,to:l.length}}})}}function determineCutOff(n,t={}){const{magnitudeMode:e=!1,considerList:i={from:.5,step:.1,to:.9}}=t,a=[],s=n.length-1;for(let t=.01;t<=.99;t+=.01){const i=-n[Math.round(s*t)]/simpleNormInvNumber(t/2,{magnitudeMode:e});a.push([t,i])}let r=Number.MAX_SAFE_INTEGER;const{from:o,to:f,step:l}=i,d=l/2;let g=.5;for(let n=o;n<=f;n+=l){const t=n-d,e=n+d,i=a.filter((n=>n[0]<e&&n[0]>t)),s=i.reduce(((n,t)=>n+Math.abs(t[1])),0);let o=0;for(const n of i)o+=(n[1]-s)**2;o<r&&(r=o,g=n)}return g}function simpleNormInvNumber(n,t){return simpleNormInv([n],t)[0]}function simpleNormInv(n,t={}){const{magnitudeMode:e=!1}=t,i=createArray(0,2,.01),a=new Float64Array(n.length),s=new Float64Array(i.length);if(e){const t=1;for(let n=0;n<s.length;n++){const e=i[n]*t;s[n]=1-rayleighCdf(e)}const e=new SplineInterpolator$1(i,s);for(let t=0;t<a.length;t++){const i=2*n[t];a[t]=-1*e.interpolate(i)}}else for(let t=0;t<a.length;t++)a[t]=-1*Math.SQRT2*erfcinv(2*n[t]);return a}function createArray(n,t,e){const i=Math.abs((n-t)/e+1),a=[];for(let t=0;t<i;t++)a.push(n+t*e);return a}function generateSanPlot(n,t={}){const{fromTo:e,logBaseY:i=2}=t,a={};for(const t in e){const{from:s,to:r}=e[t];a[t]=s!==r?scale(n.slice(s,r),{logBaseY:i}):{x:[],y:[]},"negative"===t&&a[t].y.reverse()}return a}function scale(n,t={}){const{log10:e,abs:i}=Math,{logBaseY:a}=t;if(a){n=n.slice();const t=e(a);for(let a=0;a<n.length;a++)n[a]=e(i(n[a]))/t}return{x:createFromToArray({from:0,to:n.length-1,length:n.length}),y:n}}function xNoiseStandardDeviation(n){const{mad:t,median:e}=xMedianAbsoluteDeviation(n);return{sd:t/.6744897501960817,mad:t,median:e}}function xNorm(n){let t=0;for(const e of n)t+=e**2;return Math.sqrt(t)}function xSum(n,t={}){xCheck(n);const{fromIndex:e,toIndex:i}=xGetFromToIndex(n,t);let a=n[e];for(let t=e+1;t<=i;t++)a+=n[t];return a}function xNormed(n,t={}){const{algorithm:e="absolute",value:i=1}=t;xCheck(n);const a=getOutputArray(t.output,n.length);if(0===n.length)throw new Error("input must not be empty");switch(e){case"absolute":{const t=absoluteSum(n)/i;if(0===t)throw new Error("trying to divide by 0");for(let e=0;e<n.length;e++)a[e]=n[e]/t;return a}case"max":{const t=xMaxValue(n);if(0===t)throw new Error("trying to divide by 0");const e=i/t;for(let t=0;t<n.length;t++)a[t]=n[t]*e;return a}case"sum":{const t=xSum(n)/i;if(0===t)throw new Error("trying to divide by 0");for(let e=0;e<n.length;e++)a[e]=n[e]/t;return a}default:throw new Error(`unknown algorithm: ${String(e)}`)}}function absoluteSum(n){let t=0;for(let e=0;e<n.length;e++)t+=Math.abs(n[e]);return t}function xPadding(n,t={}){const{size:e=0,value:i=0,algorithm:a}=t;if(xCheck(n),!a)return xEnsureFloat64(n);const s=new Float64Array(n.length+2*e);for(let t=0;t<n.length;t++)s[t+e]=n[t];const r=e+n.length,o=2*e+n.length;switch(a){case"value":for(let n=0;n<e;n++)s[n]=i;for(let n=r;n<o;n++)s[n]=i;break;case"duplicate":for(let t=0;t<e;t++)s[t]=n[0];for(let t=r;t<o;t++)s[t]=n[n.length-1];break;case"circular":for(let t=0;t<e;t++)s[t]=n[(n.length-e%n.length+t)%n.length];for(let t=0;t<e;t++)s[t+r]=n[t%n.length];break;default:throw new Error(`unknown algorithm ${String(a)}`)}return s}function xVariance(n,t={}){if(!isAnyArray$1(n))throw new TypeError("input must be an array");const{unbiased:e=!0,mean:i=xMean(n)}=t;let a=0;for(let t=0;t<n.length;t++){const e=n[t]-i;a+=e*e}return e?a/(n.length-1):a/n.length}function xStandardDeviation(n,t={}){return Math.sqrt(xVariance(n,t))}function xParetoNormalization(n){xCheck(n);const t=new Float64Array(n.length),e=Math.sqrt(xStandardDeviation(n));for(let i=0;i<n.length;i++)t[i]=n[i]/e;return t}function xRescale(n,t={}){xCheck(n);const e=getOutputArray(t.output,n.length),i=xMinValue(n),a=xMaxValue(n);if(i===a)throw new RangeError("minimum and maximum input values are equal. Cannot rescale a constant array");const{min:s=0,max:r=1}=t;if(s>=r)throw new RangeError("min option must be smaller than max option");const o=(r-s)/(a-i);for(let t=0;t<n.length;t++)e[t]=(n[t]-i)*o+s;return e}function xRolling(n,t,e={}){if(xCheck(n),"function"!=typeof t)throw new TypeError("fct must be a function");const{window:i=5,padding:a={}}=e,{size:s=i-1,algorithm:r,value:o}=a,f=xPadding(n,{size:s,algorithm:r,value:o}),l=[];for(let n=0;n<f.length-i+1;n++)l.push(t(f.subarray(n,n+i)));return l}function xRollingAverage(n,t={}){return xRolling(n,xMean,t)}function xRollingMedian(n,t={}){return xRolling(n,xMedian,t)}function xRotate(n,t){(t%=n.length)<0&&(t+=n.length);const e=new Float64Array(n.length);return e.set(n.slice(n.length-t)),e.set(n.slice(0,n.length-t),t),e}function xSequentialFillFromStep(n,t={}){const{from:e,step:i,size:a}=n,{ArrayConstructor:s=Float64Array}=t,r=createNumberArray(s,a);for(let n=0;n<a;n++)r[n]=e+n*i;return r}function xSequentialFillFromTo(n,t={}){const{from:e,to:i,size:a}=n;return xSequentialFillFromStep({from:e,step:(i-e)/(a-1),size:a},t)}function xSubtract(n,t){let e=!1,i=0;if(isAnyArray$1(t)){if(n.length!==t.length)throw new Error("size of array1 and array2 must be identical")}else e=!0,i=Number(t);const a=new Float64Array(n.length);if(e)for(let t=0;t<n.length;t++)a[t]=n[t]-i;else for(let e=0;e<n.length;e++)a[e]=n[e]-t[e];return a}function reimPhaseCorrection(n,t=0,e=0,i={}){const{reverse:a=!1}=i;t=Number.isFinite(t)?t:0,e=Number.isFinite(e)?e:0;const s=n.re,r=n.im,o=n.re.length;let f=t,l=e/o;a&&(l*=-1,f+=e);const d=2*Math.sin(l/2)**2,g=Math.sin(l);let u=Math.cos(f),c=Math.sin(f);const b=new Float64Array(o),h=new Float64Array(o);for(let n=0;n<o;n++){b[n]=s[n]*u-r[n]*c,h[n]=r[n]*u+s[n]*c;const t=c-(d*c-g*u);u=u-(d*u+g*c),c=t}return{re:b,im:h}}function reimAutoPhaseCorrection(n,t={}){const{magnitudeMode:e=!0,minRegSize:i=30,factorNoise:a=3,maxDistanceToJoin:s=256,reverse:r=!1}=t,o=detectBaselineRegions(n,{maxDistanceToJoin:s,magnitudeMode:e,factorNoise:a}),{re:f,im:l}=n,d=f.length,g=r?n=>d-1-n:n=>n;let u=0,c=-1;const b=[];for(;c<d;){const n=[],t=[];for(;!o[g(++c)]&&c<d;)u=c;for(;o[g(c)]&&c<d;c+=2)n.push(f[g(c)]),t.push(l[g(c)]);n.length>i&&b.push(autoPhaseRegion(n,t,u))}const{ph1:h,ph0:D}=determiningGlobalValues(b.map((n=>n.x0/d)),b.map((n=>n.ph0)),b.map((n=>n.area/1e11)));return{data:reimPhaseCorrection({re:f,im:l},toRadians(D),toRadians(h),{reverse:r}),ph0:D,ph1:h}}function determiningGlobalValues(n,t,e){const[i,a]=weightedLinearRegression(n,t,e);let s=-1,r=Number.MIN_SAFE_INTEGER;for(let e=0;e<n.length;e++){const o=n[e]*i+a,f=Math.abs(t[e]-o);f>34&&r<f&&(s=e,r=f)}return s>-1?(n.splice(s,1),t.splice(s,1),e.splice(s,1),determiningGlobalValues(n,t,e)):{ph0:a,ph1:i}}function detectBaselineRegions(n,t){const e=t.magnitudeMode?reimAbsolute(n):n.re,i=robustBaseLineRegionsDetection(holoborodko(e),t);return robustBaseLineRegionsDetection(e,t).map(((n,t)=>n&&i[t]))}function autoPhaseRegion(n,t,e){let i=-180,a=180;let s=10,r=0,o=Number.MAX_SAFE_INTEGER;for(;s>0;){const e=(a-i)/7;for(let s=i;s<=a;s+=e){const e=getNegArea(reimPhaseCorrection({re:n,im:t},toRadians(s),0).re);e<o&&([o,r]=[e,s])}i=r-e,a=r+e,s--}const f=reimPhaseCorrection({re:n,im:t},toRadians(r),0);let l=0,d=0;for(let t=0;t<n.length;t++)l+=f.re[t],d+=f.re[t]*(t+e);return{ph0:r,area:l,x0:d/l}}function holoborodko(n){const t=new Float64Array(n.length);for(let e=5;e<n.length-5;e++)t[e]=(42*(n[e+1]-n[e-1])+48*(n[e+2]-n[e-2])+27*(n[e+3]+n[e-3])+8*(n[e+4]-n[e-4])+n[e+5]-n[e-5])/512;for(let e=0;e<5;e++)t[e]=t[5],t[n.length-e-1]=t[n.length-6];return t}function robustBaseLineRegionsDetection(n,t){const{maxDistanceToJoin:e,magnitudeMode:i,factorNoise:a}=t,s=new Uint8Array(n.length);for(let t=0;t<n.length;t++)s[t]=0;let r=!0;for(;r;){const t=a*xNoiseSanPlot(n,{magnitudeMode:i}).positive;r=!1;for(let e=0;e<n.length;e++)Math.abs(n[e])>t&&!s[e]&&(r=!0,s[e]=1)}let o=0,f=0;for(let t=0;t<n.length;t++)if(s[t]){if(o<e)for(let n=0;n<=o;n++)s[f+n]=1;for(;s[++t]&&t<n.length;);f=t,o=0}else o++;return s}function weightedLinearRegression(n,t,e){let i=0,a=0,s=0,r=0,o=0;for(let f=0;f<n.length;f++)i+=n[f]*n[f]*e[f],a+=n[f]*e[f],s+=e[f],r+=n[f]*e[f]*t[f],o+=e[f]*t[f];const f=i*s-a*a,l=[[s/f,-a/f],[-a/f,i/f]];return[l[0][0]*r+l[0][1]*o,l[1][0]*r+l[1][1]*o]}function toRadians(n){return n*Math.PI/180}function getNegArea(n){let t=0;for(const e of n)e<0&&(t-=e);return t}function reimFFT(n,t={}){const{inverse:e=!1,applyZeroShift:i=!1}=t,{re:a,im:s}=n,r=a.length,o=r<<1;let f=new Float64Array(o);for(let n=0;n<o;n+=2)f[n]=a[n>>>1],f[n+1]=s[n>>>1];const l=new FFT$2(r);let d=new Float64Array(o);e?(i&&(f=zeroShift(f,!0)),l.inverseTransform(d,f)):(l.transform(d,f),i&&(d=zeroShift(d)));const g=new Float64Array(r),u=new Float64Array(r);for(let n=0;n<o;n+=2)g[n>>>1]=d[n],u[n>>>1]=d[n+1];return{re:g,im:u}}function zeroShift(n,t){return xRotate(n,t?Math.ceil(n.length/2):Math.floor(n.length/2))}function xyCheck(n,t={}){const{minLength:e}=t;if(null===n||"object"!=typeof n||!isAnyArray$1(n.x)||!isAnyArray$1(n.y))throw new Error("data must be an object of x and y arrays");if(n.x.length!==n.y.length)throw new Error("the x and y arrays must have the same length");if(e&&n.x.length<e)throw new Error(`data.x must have a length of at least ${e}`)}function xyMaxYPoint(n,t={}){xyCheck(n,{minLength:1});const{x:e,y:i}=n;if(1===e.length)return{x:e[0],y:i[0],index:0};const{fromIndex:a,toIndex:s}=xGetFromToIndex(e,t);let r={x:e[a],y:i[a],index:a};for(let n=a;n<=s;n++)i[n]>r.y&&(r={x:e[n],y:i[n],index:n});return r}function xyEnsureGrowingX(n){if(xyCheck(n),1===xIsMonotonic(n.x))return n;const t=Array.from(n.x),e=Array.from(n.y);let i=Number.NEGATIVE_INFINITY,a=0;for(let n=0;n<t.length;n++)i<t[n]&&(a<n&&(t[a]=t[n],e[a]=e[n]),a++,i=t[n]);return t.length=a,e.length=a,{x:t,y:e}}function zonesNormalize(n=[],t={}){const{exclusions:e=[]}=t;let{from:i=Number.NEGATIVE_INFINITY,to:a=Number.POSITIVE_INFINITY}=t;i>a&&([i,a]=[a,i]),0===(n=n.map((n=>n.from>n.to?{from:n.to,to:n.from}:{...n})).sort(((n,t)=>n.from!==t.from?n.from-t.from:n.to-t.to))).length&&n.push({from:i,to:a});for(const t of n)i>t.from&&(t.from=i),a<t.to&&(t.to=a);if(0===(n=n.filter((n=>n.from<=n.to))).length)return[];let s=n[0];const r=[s];for(let t=1;t<n.length;t++){const e=n[t];e.from<=s.to?s.to<e.to&&(s.to=e.to):(s=e,r.push(s))}if(0===e.length)return r;const o=zonesNormalize(e);let f=0;const l=[];for(let n=0;n<r.length;n++){const t=r[n];if(f!==o.length){for(;f<o.length&&o[f].to<=t.from;)f++;if(f!==o.length)if(t.to<o[f].from)l.push(t);else{if(o[f].to>=t.to){if(o[f].from<=t.from)continue;l.push({from:o[f].to,to:t.to})}o[f].from>t.from&&l.push({from:t.from,to:o[f].from}),t.from=o[f].to,n--}else l.push(t)}else l.push(t)}return l}function zonesWithPoints(n=[],t=10,e={}){if(0===n.length)return[];const i=zonesNormalize(n,e),a=[],s=i.reduce(((n,t)=>n+(t.to-t.from)),0)/t;let r=0;for(let n=0;n<i.length-1;n++){const e=i[n],o=Math.min(Math.round((e.to-e.from)/s),t-r);a.push({...e,numberOfPoints:o}),r+=o}return a.push({...i[i.length-1],numberOfPoints:t-r}),a}function equallySpacedSlot(n,t,e,i,a){const s=n.length,r=(i-e)/(a>1?a-1:1),o=r/2,f=n[n.length-1]-n[n.length-2],l=e-o,d=new Float64Array(a);let g=l,u=l+r,c=-Number.MAX_VALUE,b=0,h=n[0],D=t[0],H=0,j=!0,m=0,A=0,C=1,p=0;n:for(;;){if(c>=h)throw new Error("x must be a growing series");for(;c-u>0;){if(j&&(A++,j=!1),d[p]=A<=0?0:m/A,p++,p===a)break n;g=u,u+=r,m=0,A=0}c>g&&(m+=b,A++),(c===-Number.MAX_VALUE||H>1)&&A--,c=h,b=D,C<s?(h=n[C],D=t[C],C++):(h+=f,D=0,H++)}return d}function integral(n,t,e,i){return.5*e*t*t+i*t-(.5*e*n*n+i*n)}function equallySpacedSmooth(n,t,e,i,a){const s=n.length,r=(i-e)/(a>1?a-1:1),o=r/2,f=new Float64Array(a),l=n[1]-n[0],d=n[s-1]-n[s-2];let g=e-o,u=e+o,c=Number.MIN_SAFE_INTEGER,b=0,h=n[0]-l,D=0,H=0,j=0,m=0,A=0,C=0,p=0,M=0,I=0;n:for(;;){if(c>=h)throw new Error("x must be a growing series");for(c<=g&&g<=h&&(I=integral(0,g-c,j,b),A=H+I);h-u>=0;){if(I=integral(0,u-c,j,b),C=H+I,f[M++]=(C-A)/r,M===a)break n;g=u,u+=r,A=C}H+=integral(c,h,j,m),c=h,b=D,p<s?(h=n[p],D=t[p],p++):p===s&&(h+=d,D=0),j=getSlope(c,b,h,D),m=-j*c+b}return f}function getSlope(n,t,e,i){return(i-t)/(e-n)}function xyEquallySpaced(n,t={}){const{x:e,y:i}=n,a=e.length,{from:s=e[0],to:r=e[a-1],variant:o="smooth",numberOfPoints:f=100,exclusions:l=[],zones:d=[{from:s,to:r}]}=t;if(s>r)throw new RangeError("from should be larger than to");if(xyCheck(n),f<2)throw new RangeError("'numberOfPoints' option must be greater than 1");const g=zonesWithPoints(zonesNormalize(d,{from:s,to:r,exclusions:l}),f,{from:s,to:r});let u=[],c=[];for(const n of g){n.numberOfPoints||(n.numberOfPoints=0);const t=processZone(Array.from(e),Array.from(i),n.from,n.to,n.numberOfPoints,o);u=u.concat(t.x),c=c.concat(t.y)}return{x:u,y:c}}function processZone(n,t,e,i,a,s){if(a<1)throw new RangeError("the number of points must be at least 1");const r="slot"===s?Array.from(equallySpacedSlot(n,t,e,i,a)):Array.from(equallySpacedSmooth(n,t,e,i,a));return{x:Array.from(createFromToArray({from:e,to:i,length:a})),y:r}}function xyExtract(n,t={}){xyCheck(n);const{x:e,y:i}=n;let{zones:a}=t;if(a=zonesNormalize(a),void 0===e||void 0===i||!Array.isArray(a)||0===a.length)return n;const s=[],r=[];let o=a[0],f=0;n:for(let n=0;n<e.length;n++){for(;o.to<e[n];)if(f++,o=a[f],!o){n=e.length;break n}e[n]>=o.from&&(s.push(e[n]),r.push(i[n]))}return{x:s,y:r}}function xyFilterX(n,t={}){const{x:e,y:i}=n,{from:a=e[0],to:s=e[e.length-1],zones:r=[{from:a,to:s}],exclusions:o=[]}=t,f=zonesNormalize(r,{from:a,to:s,exclusions:o});let l=0;const d=[],g=[];let u=0;for(;u<e.length;){if(e[u]<=f[l].to&&e[u]>=f[l].from)d.push(e[u]),g.push(i[u]);else if(e[u]>f[l].to&&(l++,!f[l]))break;u++}return{x:d,y:g}}function xyFindClosestPoint(n,t){const{x:e,y:i}=n,a=xFindClosestIndex(e,t);return{x:e[a],y:i[a]}}function xyIntegration(n,t={}){xyCheck(n,{minLength:1});const{x:e,y:i}=n;if(1===e.length)return 0;const{fromIndex:a,toIndex:s}=xGetFromToIndex(e,t);let r=0;for(let n=a;n<s;n++)r+=(e[n+1]-e[n])*(i[n+1]+i[n])/2;return r}function xySetYValue(n,t={}){xyCheck(n);const{x:e,y:i}=n,{value:a=0}=t;let{zones:s}=t;if(!Array.isArray(s)||0===s.length)return n;s=zonesNormalize(s);const r=e.slice(),o=i.slice();let f=s[0],l=0;n:for(let n=0;n<e.length;n++){for(;f.to<e[n];)if(l++,f=s[l],!f){n=e.length;break n}e[n]>=f.from&&(o[n]=a)}return{x:r,y:o}}function matrixCreateEmpty(n){const{matrix:t,nbRows:e=t?.length||1,nbColumns:i=t?.[0].length||1,ArrayConstructor:a=Float64Array}=n,s=[];for(let n=0;n<e;n++)s.push(createNumberArray(a,i));return s}function matrixCheck(n){if(0===n.length||0===n[0].length)throw new RangeError("matrix must contain data");const t=n[0].length;for(let e=1;e<n.length;e++)if(n[e].length!==t)throw new RangeError("all rows must has the same length")}function matrixMinMaxZ(n){matrixCheck(n);const t=n.length,e=n[0].length;let i=n[0][0],a=n[0][0];for(let s=0;s<e;s++)for(let e=0;e<t;e++)n[e][s]<i&&(i=n[e][s]),n[e][s]>a&&(a=n[e][s]);return{min:i,max:a}}function xBackwardLinearPrediction(n,t){const{nbCoefficients:e,nbInputs:i,nbPoints:a}=t;if(n.length<i+e+a)throw new RangeError("data length should be bigger than nbInputs + nbCoefficients + nbPoints");const s=[];for(let t=0;t<i;t++){const i=new Float64Array(e);for(let s=0;s<e;s++)i[s]=n[t+s+a+1];s.push(i)}const r=new SVD(s),o=new Float64Array(i);for(let t=0;t<i;t++)o[t]=n[t+a];const f=r.solve(Matrix.from1DArray(o.length,1,o)).to1DArray(),{output:l=Float64Array.from(n)}=t;for(let n=0;n<a;n++){let t=0;for(let e=0;e<f.length;e++)t+=f[e]*l[e+a-n];l[a-n-1]=t}return{output:l,predicted:l.slice(0,a)}}function reimBackwardLinearPrediction(n,t){const{re:e,im:i}=n,{nbCoefficients:a,nbPoints:s,nbInputs:r=e.length/2}=t,o=Math.abs(s),f=s<0?o:0,l=2*Math.ceil((r+o+a)/2);if(e.length<l-f)throw new RangeError(`The sum of nbPoints, nbInputs and nbCoefficients should be less than data length (${e.length})`);const d=new Float64Array(2*l);for(let n=0;n<l-f;n++)d.set([e[n],i[n]],2*(n+f));xBackwardLinearPrediction(d,{nbInputs:2*r,nbCoefficients:a,nbPoints:2*o,output:d});const g=new Float64Array(e.length),u=new Float64Array(i.length);for(let n=0;n<2*o;n+=2)g[n>>1]=d[n],u[n>>1]=d[n+1];return s<0?(g.set(e.slice(0,e.length-o),o),u.set(i.slice(0,e.length-o),o)):(g.set(e.slice(s),o),u.set(i.slice(s),o)),{re:g,im:u}}const id$p="backwardLinearPrediction",name$p="Backward Linear Prediction Filter",DOMAIN_UPDATE_RULES$p={updateXDomain:!0,updateYDomain:!0};function apply$q(n,t={}){if(!isApplicable$p(n))throw new Error("Digital Filter is not applicable on this data");const{info:e,data:{re:i,im:a}}=n,{lpNumberOfCoefficients:s=0,tdOff:r=0}=e,{nbCoefficients:o=s,nbPoints:f=r/2,nbInputs:l=Math.floor(i.length/2-o-f)}=t,{re:d,im:g}=reimBackwardLinearPrediction({re:i,im:a},{nbCoefficients:o,nbInputs:l,nbPoints:f}),u=n.filters.find((n=>n.name===id$p));u&&(u.value={nbCoefficients:o,nbPoints:f,nbInputs:l});const c=n.data.x;Object.assign(n.data,{re:d,im:g,x:f<0?xSequentialFillFromStep({from:0,size:d.length,step:c[1]-c[0]}):c})}function isApplicable$p(n){return!(!n.info.isComplex||!n.info.isFid)}function reduce$p(){return{once:!0,reduce:void 0}}var backwardLinearPrediction=Object.freeze({__proto__:null,id:id$p,name:name$p,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$p,apply:apply$q,isApplicable:isApplicable$p,reduce:reduce$p});function ldlSymbolic(n,t,e,i,a,s,r){let o,f,l,d,g;for(f=0;f<n;f++)for(a[f]=-1,r[f]=f,s[f]=0,d=f,g=t[d+1],l=t[d];l<g;l++)if(o=e[l],o<f)for(;r[o]!==f;o=a[o])-1===a[o]&&(a[o]=f),s[o]++,r[o]=f;for(i[0]=0,f=0;f<n;f++)i[f+1]=i[f]+s[f]}function ldlNumeric(n,t,e,i,a,s,r,o,f,l,d,g,u){let c,b,h,D,H,j,m,A,C;for(D=0;D<n;D++){for(d[D]=0,C=n,u[D]=D,r[D]=0,j=D,m=t[j+1],H=t[j];H<m;H++)if(h=e[H],h<=D){for(d[h]+=i[H],A=0;u[h]!==D;h=s[h])g[A++]=h,u[h]=D;for(;A>0;)g[--C]=g[--A]}for(l[D]=d[D],d[D]=0;C<n;C++){for(h=g[C],c=d[h],d[h]=0,m=a[h]+r[h],H=a[h];H<m;H++)d[o[H]]-=f[H]*c;b=c/l[h],l[D]-=b*c,o[H]=D,f[H]=b,r[h]++}if(0===l[D])return D}return n}function ldlLsolve(n,t,e,i,a){let s,r,o;for(s=0;s<n;s++)for(o=e[s+1],r=e[s];r<o;r++)t[i[r]]-=a[r]*t[s]}function ldlDsolve(n,t,e){let i;for(i=0;i<n;i++)t[i]/=e[i]}function ldlLTsolve(n,t,e,i,a){let s,r,o;for(s=n-1;s>=0;s--)for(o=e[s+1],r=e[s];r<o;r++)t[s]-=a[r]*t[i[r]]}function ldlPerm(n,t,e,i){let a;for(a=0;a<n;a++)t[a]=e[i[a]]}function ldlPermt(n,t,e,i){let a;for(a=0;a<n;a++)t[i[a]]=e[a]}function prepare(n,t,e){if(e){let i=new Array(t);for(let n=0;n<t;n++)i[e[n]]=n;let a=[];for(let t=0;t<n.length;++t){let e=i[n[t][0]],s=i[n[t][1]];if(s<e){let n=s;s=e,e=n}a[t]=[],a[t][0]=e,a[t][1]=s,a[t][2]=n[t][2]}n=a}else{e=[];for(let n=0;n<t;++n)e[n]=n}let i=new Array(t+1),a=new Array(n.length),s=new Array(n.length),r=[];for(let n=0;n<t;++n)r[n]=0;for(let t=0;t<n.length;++t)r[n[t][1]]++;i[0]=0;for(let n=0;n<t;++n)i[n+1]=i[n]+r[n];let o=[];for(let n=0;n<t;++n)o[n]=0;for(let t=0;t<n.length;++t){let e=n[t],r=e[1],f=i[r]+o[r];a[f]=e[0],s[f]=e[2],o[r]++}let f,l=new Array(t),d=new Array(t),g=new Array(t+1),u=new Array(t),c=new Array(t),b=new Array(t),h=new Array(t),D=new Array(t),H=new Array(t);ldlSymbolic(t,i,a,g,u,c,b);let j=new Array(g[t]),m=new Array(g[t]);return f=ldlNumeric(t,i,a,s,g,u,c,m,j,l,d,h,b),f===t?n=>(ldlPerm(t,D,n,e),ldlLsolve(t,D,g,m,j),ldlDsolve(t,D,l),ldlLTsolve(t,D,g,m,j),ldlPermt(t,H,D,e),H):null}var cuthillMckee_1=cuthillMckee;function compareNum(n,t){return n-t}function cuthillMckee(n,t){for(var e=new Array(t),i=new Array(t),a=0;a<t;++a)e[a]=[],i[a]=!1;for(a=0;a<n.length;++a){var s=n[a];e[s[0]].push(s[1])}var r=new Array(t),o=0,f=0;for(a=0;a<t;++a)if(!i[a])for(r[o++]=a,i[a]=!0;f<o;){var l=e[r[f++]];l.sort(compareNum);for(var d=0;d<l.length;++d){var g=l[d];i[g]||(i[g]=!0,r[o++]=g)}}var u=new Array(t);for(a=0;a<t;++a)u[r[a]]=a;return u}var cuthillMckee$1=cuthillMckee_1;const getClosestNumber=(n=[],t=0)=>n.reduce(((n,e)=>Math.abs(e-t)<Math.abs(n-t)?e:n)),getCloseIndex=(n=[],t=0)=>{const e=getClosestNumber(n,t);return n.indexOf(e)},updateSystem=(n,t,e)=>{let i=t.length,a=i-1,s=new Array(n.length),r=new Float64Array(i);for(let i=0;i<a;i++){let a=e[i],o=2*i,f=o+1;s[o]=n[o].slice(),s[f]=n[f].slice(),0===a?r[i]=0:(r[i]=t[i]*a,s[o][2]+=a)}return r[a]=t[a]*e[a],s[2*a]=n[2*a].slice(),s[2*a][2]+=e[a],[s,r]},getDeltaMatrix=(n,t)=>{let e=[],i=n-1;for(let n=0;n<i;n++)e.push([n,n,2*t]),e.push([n+1,n,-1*t]);return e[0][2]=t,e.push([i,i,t]),{lowerTriangularNonZeros:e,permutationEncodedArray:cuthillMckee$1(e,n)}};function getControlPoints(n,t,e={}){const{length:i}=n;let{controlPoints:a=Int8Array.from({length:i}).fill(0)}=e;const{zones:s=[],weights:r=Float64Array.from({length:i}).fill(1)}=e;if(n.length!==t.length)throw new RangeError("Y should match the length with X");if(a.length!==n.length)throw new RangeError("controlPoints should match the length with X");if(r.length!==n.length)throw new RangeError("weights should match the length with X");return s.forEach((t=>{let e=getCloseIndex(n,t.from),i=getCloseIndex(n,t.to);e>i&&([e,i]=[i,e]);for(let n=e;n<i;n++)a[n]=1})),{weights:"controlPoints"in e||s.length>0?xMultiply(r,a):r,controlPoints:a}}function airPLS(n,t,e={}){const{weights:i,controlPoints:a}=getControlPoints(n,t,e);let s,r,{maxIterations:o=100,lambda:f=10,tolerance:l=.001}=e,d=Number.MAX_SAFE_INTEGER;const g=Float64Array.from(t);let u=getStopCriterion(t,l);const{length:c}=t;let{lowerTriangularNonZeros:b,permutationEncodedArray:h}=getDeltaMatrix(c,f),D=1;const H=c-1;let j=Number.MAX_SAFE_INTEGER;for(r=0;r<o&&Math.abs(d)>u;r++){let[n,e]=updateSystem(b,t,i);if(s=prepare(n,c,h)(e),d=m(t,s,g),1===r){const{positive:n}=xNoiseSanPlot(g);D=n}else{const n=Math.abs(j/d);if(n<1.01&&n>.99)break}j=d+0;for(let n=1;n<H;n++){const t=g[n];if(a[n]<1&&Math.abs(t)>D)i[n]=0;else{const e=t>0?-1:1;i[n]=Math.exp(e*(r*t)/Math.abs(d))}}i[0]=1,i[H]=1}return{corrected:g,baseline:s,iteration:r,error:d};function m(n,t,e){let i=0;for(let a=0;a<n.length;a++){let s=n[a]-t[a];s<0&&(i+=s),e[a]=s}return i}}function getStopCriterion(n,t){return t*xAbsoluteSum(n)}function checkArrayLength(n,t){if(!isAnyArray$1(n)||!isAnyArray$1(t))throw new TypeError("x and y must be arrays");if(n.length!==t.length)throw new RangeError("x and y arrays must have the same length")}class BaseRegression{constructor(){if(new.target===BaseRegression)throw new Error("BaseRegression must be subclassed")}predict(n){if("number"==typeof n)return this._predict(n);if(isAnyArray$1(n)){const t=[];for(const e of n)t.push(this._predict(e));return t}throw new TypeError("x must be a number or array")}_predict(n){throw new Error("_predict must be implemented")}train(){}toString(n){return""}toLaTeX(n){return""}score(n,t){checkArrayLength(n,t);const e=n.length,i=new Array(e);for(let t=0;t<e;t++)i[t]=this._predict(n[t]);let a=0,s=0,r=0,o=0,f=0,l=0,d=0;for(let n=0;n<e;n++)a+=i[n],s+=t[n],f+=i[n]*i[n],l+=t[n]*t[n],d+=i[n]*t[n],0!==t[n]&&(r+=(t[n]-i[n])*(t[n]-i[n])/t[n]),o+=(t[n]-i[n])*(t[n]-i[n]);const g=(e*d-a*s)/Math.sqrt((e*f-a*a)*(e*l-s*s));return{r:g,r2:g*g,chi2:r,rmsd:Math.sqrt(o/e)}}}function maybeToPrecision(n,t){return n<0?(n=0-n,"number"==typeof t?`- ${n.toPrecision(t)}`:`- ${n.toString()}`):"number"==typeof t?n.toPrecision(t):n.toString()}class PolynomialRegression extends BaseRegression{constructor(n,t,e,i={}){if(super(),!0===n)this.degree=t.degree,this.powers=t.powers,this.coefficients=t.coefficients;else{checkArrayLength(n,t);const a=regress$2(n,t,e,i);this.degree=a.degree,this.powers=a.powers,this.coefficients=a.coefficients}}_predict(n){let t=0;for(let e=0;e<this.powers.length;e++)t+=this.coefficients[e]*n**this.powers[e];return t}toJSON(){return{name:"polynomialRegression",degree:this.degree,powers:this.powers,coefficients:this.coefficients}}toString(n){return this._toFormula(n,!1)}toLaTeX(n){return this._toFormula(n,!0)}_toFormula(n,t){let e="^",i="",a=" * ";t&&(e="^{",i="}",a="");let s="",r="";for(let t=0;t<this.coefficients.length;t++)r="",0!==this.coefficients[t]&&(r=0===this.powers[t]?maybeToPrecision(this.coefficients[t],n):1===this.powers[t]?`${maybeToPrecision(this.coefficients[t],n)+a}x`:`${maybeToPrecision(this.coefficients[t],n)+a}x${e}${this.powers[t]}${i}`,this.coefficients[t]>0&&t!==this.coefficients.length-1?r=` + ${r}`:t!==this.coefficients.length-1&&(r=` ${r}`)),s=r+s;return s.startsWith("+")&&(s=s.slice(1)),`f(x) = ${s}`}static load(n){if("polynomialRegression"!==n.name)throw new TypeError("not a polynomial regression model");return new PolynomialRegression(!0,n)}}function regress$2(n,t,e,i={}){const a=n.length;let{interceptAtZero:s=!1}=i,r=[];if(Array.isArray(e))r=e,s=!1;else if("number"==typeof e)if(s){r=new Array(e);for(let n=0;n<e;n++)r[n]=n+1}else{r=new Array(e+1);for(let n=0;n<=e;n++)r[n]=n}const o=r.length,f=new Matrix(a,o),l=new Matrix([t]);for(let t=0;t<o;t++)for(let e=0;e<a;e++)0===r[t]?f.set(e,t,1):f.set(e,t,n[e]**r[t]);const d=new MatrixTransposeView(f),g=d.mmul(f),u=d.mmul(new MatrixTransposeView(l));return{coefficients:solve(g,u).to1DArray(),degree:Math.max(...r),powers:r}}const id$o="baselineCorrection",name$o="Baseline correction",DOMAIN_UPDATE_RULES$o={updateXDomain:!1,updateYDomain:!1};function apply$p(n,t){if(!isApplicable$o(n))throw new Error("baselineCorrection not applicable on this data");const{algorithm:e}=t,{x:i,re:a}=n.data;let s;switch(e){case"airpls":s=airPLS(i,a,t).corrected;break;case"polynomial":{const{degree:n,zones:e}=t,r=xyEquallySpaced({x:i,y:a},{numberOfPoints:4096,zones:e}),o=new PolynomialRegression(r.x,r.y,n,{interceptAtZero:!1}).predict(i);s=new Float64Array(i.length);for(let n=0;n<a.length;n++)s[n]=a[n]-o[n]}break;default:throw new Error(`baselineCorrection: algorithm unknown: ${e}`)}Object.assign(n.data,{re:s})}function isApplicable$o(n){return!n.info.isFid}function reduce$o(n,t){return{once:!0,reduce:t}}var baselineCorrection=Object.freeze({__proto__:null,id:id$o,name:name$o,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$o,apply:apply$p,isApplicable:isApplicable$o,reduce:reduce$o});const id$n="digitalFilter",name$n="Digital Filter",DOMAIN_UPDATE_RULES$n={updateXDomain:!0,updateYDomain:!0};function apply$o(n,t={}){if(!isApplicable$n(n))throw new Error("Digital Filter is not applicable on this data");let{digitalFilterValue:e}=t;if(!e){e=n.info.digitalFilter||0;const t=n.filters.find((n=>n.name===id$n));t&&(t.value={digitalFilterValue:e})}const i=new Float64Array(n.data.re),a=new Float64Array(n.data.im);let s=Math.floor(e);s+=0;const r=new Float64Array(i.length),o=new Float64Array(a.length);r.set(i.slice(s)),r.set(i.slice(0,s),i.length-s),o.set(a.slice(s)),o.set(a.slice(0,s),a.length-s),n.data.re=r,n.data.im=o}function isApplicable$n(n){return!(!n.info.isComplex||!n.info.isFid)}function reduce$n(){return{once:!0,reduce:void 0}}var digitalFilter$1=Object.freeze({__proto__:null,id:id$n,name:name$n,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$n,apply:apply$o,isApplicable:isApplicable$n,reduce:reduce$n});const id$m="equallySpaced",name$m="Equally spaced",DOMAIN_UPDATE_RULES$m={updateXDomain:!1,updateYDomain:!1};function apply$n(n,t={}){if(!isApplicable$m(n))throw new Error("Equally Spaced is not applicable on this data");const{from:e,to:i,numberOfPoints:a,exclusions:s}=t,{x:r,re:o,im:f}=n.data,l=xyEquallySpaced({x:r,y:o},{from:e,to:i,numberOfPoints:a,exclusions:s});if(n.data.x=xEnsureFloat64(l.x),n.data.re=xEnsureFloat64(l.y),f){const t=xyEquallySpaced({x:r,y:o},{from:e,to:i,numberOfPoints:a,exclusions:s});n.data.im=xEnsureFloat64(t.y)}}function isApplicable$m(n){return!(!n.info.isComplex||n.info.isFid)}function reduce$m(){return{once:!1,reduce:null}}var equallySpaced$1=Object.freeze({__proto__:null,id:id$m,name:name$m,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$m,apply:apply$n,isApplicable:isApplicable$m,reduce:reduce$m});const id$l="exclusionZones",name$l="Exclusion zones",DOMAIN_UPDATE_RULES$l={updateXDomain:!1,updateYDomain:!1};function apply$m(n,t=[]){if(!isApplicable$l(n))throw new Error("Exclusion Zones filter not applicable on this data");const{x:e,re:i,im:a}=n.data;n.data.re=Float64Array.from(xySetYValue({x:e,y:i},{zones:t}).y),n.data.im=a?Float64Array.from(xySetYValue({x:e,y:i},{zones:t}).y):a}function isApplicable$l(n){return!!n.info.isFt}function reduce$l(n,t){return{once:!0,reduce:zonesNormalize(n.concat(t))}}var exclusionZones=Object.freeze({__proto__:null,id:id$l,name:name$l,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$l,apply:apply$m,isApplicable:isApplicable$l,reduce:reduce$l});const degreeToRadians=Math.PI/180;function isPowerOfTwo(n){return 0!==n&&!(n&n-1)}function nextPowerOfTwo(n){return 0===n?1:(n--,n|=n>>1,n|=n>>2,n|=n>>4,n|=n>>8,(n|=n>>16)+1)}function padDataToNextPowerOfTwo(n,t){const{x:e,re:i,im:a}=n.data,s=nextPowerOfTwo(e.length),r=new Float64Array(s),o=new Float64Array(s),f=n.info?.digitalFilter||0,l=f>0?Math.floor(f):0;r.set(i.slice(0,s-l)),o.set(a.slice(0,s-l)),l>0&&t&&(r.set(i.slice(i.length-l),s-l),o.set(a.slice(i.length-l),s-l));const d=xSequentialFillFromStep({from:e[0],size:s,step:e[1]-e[0]});n.data={...n.data,re:r,im:o,x:d}}const id$k="fft",name$k="FFT",DOMAIN_UPDATE_RULES$k={updateXDomain:!0,updateYDomain:!0};function apply$l(n){if(!isApplicable$k(n))throw new Error("fft not applicable on this data");checkSameLength(n);const t=n.filters.some((n=>"digitalFilter"===n.name&&n.flag)),{info:{aqMod:e}}=n;1===e&&removeDCOffset$1(n,t),isPowerOfTwo(n.data.x.length)||padDataToNextPowerOfTwo(n,t);const{data:i,info:a}=n;if(Object.assign(i,reimFFT({re:i.re,im:a.reverse?xMultiply(i.im,-1):i.im},{applyZeroShift:!0})),t){const{digitalFilter:n=0}=a,t=(n-Math.floor(n))*Math.PI*2,e=Math.floor(n)%2?180*degreeToRadians:0;Object.assign(i,reimPhaseCorrection(i,e,-t,{reverse:!0}))}n.data.x=generateXAxis(n),n.info={...n.info,isFid:!1,isFt:!0}}function isApplicable$k(n){return!(!n.info.isComplex||!n.info.isFid)}function reduce$k(){return{once:!0,reduce:void 0}}function generateXAxis(n){const t=n.info,e=Number(t.baseFrequency),i=Number(t.frequencyOffset),a=Number(t.spectralWidth),s=i/e,r=.5*a,o=n.data.x.length;let f=s-r;const l=a/(o-1),d=new Float64Array(o);for(let n=0;n<o;n++)d[n]=f,f+=l;return d}function removeDCOffset$1(n,t){const{digitalFilter:e=0}=t&&n.info?n.info:{},i=n.data,a=i.re.length,s=new Float64Array(i.re),r=new Float64Array(i.im),o=xMean(i.re.slice(.75*a|0,a-e)),f=xMean(i.im.slice(.75*a|0,a-e));for(let n=t?0:e;n<a-e;n++)s[n]-=o,r[n]-=f;return Object.assign(n.data,{re:s,im:r}),n}function checkSameLength(n){const{data:t}=n;if(t.x.length!==t.re.length||t.x.length!==t.im.length)throw new Error("The length of data should be equal")}var fft=Object.freeze({__proto__:null,id:id$k,name:name$k,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$k,apply:apply$l,isApplicable:isApplicable$k,reduce:reduce$k});function xForwardLinearPrediction(n,t){const{nbCoefficients:e,nbInputs:i,nbPoints:a}=t;if(n.length<i+e+a)throw new RangeError("data length should be bigger than nbInputs + nbCoefficients + nbPoints");const s=n.length-a-2,r=[];for(let t=0;t<i;t++){const i=new Float64Array(e);for(let a=0;a<e;a++)i[a]=n[s-t-a];r.push(i)}const o=new SVD(r),f=new Float64Array(i);for(let t=0;t<i;t++)f[t]=n[s-t+1];const l=o.solve(Matrix.from1DArray(f.length,1,f)).to1DArray(),{output:d=Float64Array.from(n)}=t;for(let n=0;n<a;n++){let t=0;for(let e=0;e<l.length;e++)t+=l[e]*d[s+1+n-e];d[s+n+2]=t}return{output:d,predicted:d.slice(s+2)}}function reimForwardLinearPrediction(n,t){const{re:e,im:i}=n,{nbCoefficients:a,nbPoints:s,nbInputs:r=e.length}=t,o=Math.abs(s),f=s<0?o:0,l=2*Math.ceil((r+o+a)/2);if(e.length<l-f)throw new RangeError(`The sum of nbPoints, nbInputs and nbCoefficients should be less than data length (${e.length})`);const d=new Float64Array(2*l),g=e.length-l+f;for(let n=0;n<l-f;n++)d.set([e[g+n],i[g+n]],2*n);xForwardLinearPrediction(d,{nbInputs:2*r,nbCoefficients:a,nbPoints:2*o,output:d});const u=new Float64Array(e.length+f),c=new Float64Array(f+i.length);s<0?(u.set(e),c.set(i)):(u.set(e.slice(0,e.length-s)),c.set(i.slice(0,i.length-s)));for(let n=0;n<2*o;n+=2)u[u.length-1-(n>>1)]=d[d.length-2-n],c[u.length-1-(n>>1)]=d[d.length-1-n];return{re:u,im:c}}function getNbPredictedPoints(n,t,e){const i=2*n,a=2*t;if(0===e){if(i<t)return 0;if(t<i&&i<a)return t;if(a<i)return e-t}return t<e?e-t:0}const id$j="forwardLinearPrediction",name$j="Forward Linear Prediction Filter",DOMAIN_UPDATE_RULES$j={updateXDomain:!0,updateYDomain:!0};function apply$k(n,t={}){if(!isApplicable$j(n))throw new Error("Digital Filter is not applicable on this data");const{info:e,data:{re:i,im:a}}=n,{lpNumberOfCoefficients:s=0,linearPredictionBin:r=0,spectrumSize:o=i.length,numberOfPoints:f=i.length}=e,{nbPoints:l=getNbPredictedPoints(o,f,r)/-2,nbCoefficients:d=s,nbInputs:g=Math.floor(i.length-l-d)}=t,u=n.filters.find((n=>n.name===id$j));u&&(u.value={nbCoefficients:d,nbPoints:l,nbInputs:g});const{re:c,im:b}=reimForwardLinearPrediction({re:i,im:a},{nbCoefficients:d,nbInputs:g,nbPoints:l}),{data:{x:h}}=n;Object.assign(n.data,{re:c,im:b,x:l<0?xSequentialFillFromStep({from:0,size:c.length,step:h[1]-h[0]}):h})}function isApplicable$j(n){return!(!n.info.isComplex||!n.info.isFid)}function reduce$j(){return{once:!0,reduce:void 0}}var forwardLinearPrediction=Object.freeze({__proto__:null,id:id$j,name:name$j,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$j,apply:apply$k,isApplicable:isApplicable$j,reduce:reduce$j});const id$i="phaseCorrection",name$i="Phase correction",DOMAIN_UPDATE_RULES$i={updateXDomain:!1,updateYDomain:!1};function apply$j(n,t={}){if(!isApplicable$i(n))throw new Error("phaseCorrection not applicable on this data");const{absolute:e=!1}=t,i=n.filters?.find((n=>n.name===id$i));if(e){const{re:t,im:a}=n.data;n.data.re=reimAbsolute({re:t,im:a}),n.data.im=new Float64Array(0),i&&(i.value={...i.value,ph0:0,ph1:0,absolute:e})}else if("ph0"in t&&"ph1"in t){const{ph0:a,ph1:s}=t;phaseCorrection(n,{ph0:a,ph1:s}),i&&(i.value={...i.value,absolute:e})}else{const{ph0:t,ph1:a}=autoPhaseCorrection(n);phaseCorrection(n,{ph0:t,ph1:a}),i&&(i.value={...i.value,absolute:e,ph0:t,ph1:a})}}function phaseCorrection(n,t){const{ph0:e,ph1:i}=t,{re:a,im:s}=n.data,r=reimPhaseCorrection({re:a,im:s},e*Math.PI/180,i*Math.PI/180,{reverse:!0});n.data={...n.data,re:xEnsureFloat64(r.re),im:xEnsureFloat64(r.im)}}function autoPhaseCorrection(n,t={}){const{minRegSize:e=5,maxDistanceToJoin:i=128,magnitudeMode:a=!0,factorNoise:s=5,reverse:r=!0}=t;return reimAutoPhaseCorrection(n.data,{minRegSize:e,maxDistanceToJoin:i,magnitudeMode:a,factorNoise:s,reverse:r})}function isApplicable$i(n){return!(!n.info.isComplex||n.info.isFid)}function reduce$i(n,t){return{once:!0,reduce:t}}var phaseCorrection$1=Object.freeze({__proto__:null,id:id$i,name:name$i,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$i,apply:apply$j,isApplicable:isApplicable$i,reduce:reduce$i});const id$h="shiftX",name$h="Shift X",DOMAIN_UPDATE_RULES$h={updateXDomain:!0,updateYDomain:!1};function apply$i(n,t={}){const{shift:e=0}=t;n.data.x=n.data.x.map((n=>n+e))}function isApplicable$h(){return!0}function reduce$h(n,t){const{shift:e=0}=n,{shift:i=0}=t;return{once:!0,reduce:{shift:e+i}}}var shiftX=Object.freeze({__proto__:null,id:id$h,name:name$h,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$h,apply:apply$i,isApplicable:isApplicable$h,reduce:reduce$h});function centerMean(n){const{y:t}=n,e=xMean(t);for(let n=0;n<t.length;n++)t[n]-=e;return{data:n}}function centerMedian(n){const{y:t}=n,e=xMedian(t);for(let n=0;n<t.length;n++)t[n]-=e;return{data:n}}function fromTo$1(n,t={}){const{fromIndex:e,toIndex:i}=xGetFromToIndex(n.x,t);return{data:{x:n.x.subarray(e,i+1),y:n.y.subarray(e,i+1)}}}function normed(n,t={}){return xNormed(n.y,{...t,output:n.y}),{data:n}}function divideBySD(n){const{y:t}=n,e=xStandardDeviation(t);for(let n=0;n<t.length;n++)t[n]/=e;return{data:n}}function rescale(n,t={}){return xRescale(n.y,{...t,output:n.y}),{data:n}}function paretoNormalization(n){return{data:{x:n.x,y:xParetoNormalization(n.y)}}}function _typeof(n){return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(n){return typeof n}:function(n){return n&&"function"==typeof Symbol&&n.constructor===Symbol&&n!==Symbol.prototype?"symbol":typeof n},_typeof(n)}function sequentialFill(){var n=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if("object"!==_typeof(n)||isAnyArray$1(n)||(t=n,n=[]),!isAnyArray$1(n))throw new TypeError("input must be an array");var e=t,i=e.from,a=void 0===i?0:i,s=e.to,r=void 0===s?10:s,o=e.size,f=void 0===o?n.length:o,l=e.step;if(0!==f&&l)throw new Error("step is defined by the array size");if(f||(f=l?Math.floor((r-a)/l)+1:r-a+1),!l&&f&&(l=(r-a)/(f-1)),Array.isArray(n)){n.length=0;for(var d=0;d<f;d++)n.push(a),a+=l}else{if(n.length!==f)throw new Error("sequentialFill typed array must have the correct length");for(var g=0;g<f;g++)n[g]=a,a+=l}return n}function airPLSBaseline$1(n,t={}){const e=n.length;let{x:i,regressionOptions:a}=t;i||(i=sequentialFill({from:0,to:e-1,size:e}));let s=airPLS(i,n,a);return{baseline:s.baseline,correctedSpectrum:s.corrected}}function baselineCorrectionRegression(n,t,e={}){let{maxIterations:i=100,Regression:a=PolynomialRegression,regressionOptions:s,tolerance:r=.001}=e;s||a!==PolynomialRegression||(s=3);let o,f,l=t.slice(),d=t.slice(),g=t,u=0;for(;u<i;){f=new a(n,l,s),o=0;for(let t=0;t<l.length;t++)d[t]=f.predict(n[t]),l[t]>d[t]&&(l[t]=d[t]),o+=Math.abs((d[t]-g[t])/g[t]);if(o<r)break;g=d.slice(),u++}let c=new Array(l.length);for(let n=0;n<l.length;n++)c[n]=t[n]-l[n];return{corrected:c,delta:o,iteration:u,baseline:l,regression:f}}function iterativePolynomialBaseline$1(n,t={}){const e=n.length;let{x:i,regressionOptions:a}=t;i||(i=sequentialFill({from:0,to:e-1,size:e}));let s=baselineCorrectionRegression(i,n,a);return{baseline:s.baseline,correctedSpectrum:s.corrected}}function rollingAverageBaseline$1(n,t={}){let e=Math.max(Math.round(.1*n.length),2),i=xRollingAverage(n,{...{window:e,padding:{size:e-1,algorithm:"duplicate",value:0}},...t}),a=new Float64Array(n.length);for(let t=0;t<a.length;t++)a[t]=n[t]-i[t];return{baseline:i,correctedSpectrum:a}}function rollingBall(n,t={}){if(!isAnyArray$1(n))throw new Error("Spectrum must be an array");if(0===n.length)throw new TypeError("Spectrum must not be empty");const e=n.length,i=new Float64Array(e),a=new Float64Array(e),s=new Float64Array(e),{windowM:r=Math.round(.04*e),windowS:o=Math.round(.08*e)}=t;for(let t=0;t<n.length;t++){const e=Math.max(0,t-r),i=Math.min(t+r+1,n.length);a[t]=xMinValue(n,{fromIndex:e,toIndex:i})}for(let n=0;n<a.length;n++){const t=Math.max(0,n-r),e=Math.min(n+r+1,a.length);i[n]=xMaxValue(a,{fromIndex:t,toIndex:e})}for(let n=0;n<a.length;n++){const t=Math.max(0,n-o),e=Math.min(n+o+1,i.length);s[n]=xMean(i.subarray(t,e))}return s}function rollingBallBaseline$1(n,t={}){const e=rollingBall(n,t);let i=new Float64Array(n.length);for(let t=0;t<i.length;t++)i[t]=n[t]-e[t];return{baseline:e,correctedSpectrum:i}}function rollingMedianBaseline$1(n,t={}){let e=Math.max(Math.round(.1*n.length),2),i=xRollingMedian(n,{...{window:e,padding:{size:e-1,algorithm:"duplicate",value:0}},...t}),a=new Float64Array(n.length);for(let t=0;t<a.length;t++)a[t]=n[t]-i[t];return{baseline:i,correctedSpectrum:a}}function airPLSBaseline(n){return n.y=airPLSBaseline$1(n.y).correctedSpectrum,{data:n}}function iterativePolynomialBaseline(n){return n.y=iterativePolynomialBaseline$1(n.y).correctedSpectrum,{data:n}}function rollingAverageBaseline(n){return n.y=rollingAverageBaseline$1(n.y).correctedSpectrum,{data:n}}function rollingBallBaseline(n){return n.y=rollingBallBaseline$1(n.y).correctedSpectrum,{data:n}}function rollingMedianBaseline(n){return n.y=rollingMedianBaseline$1(n.y).correctedSpectrum,{data:n}}function sgg(n,t,e={}){const{windowSize:i=9,derivative:a=0,polynomial:s=3}=e;if(i%2==0||i<5||!Number.isInteger(i))throw new RangeError("Invalid window size (should be odd and at least 5 integer number)");if(!isAnyArray$1(n))throw new TypeError("Y values must be an array");if(void 0===t)throw new TypeError("X must be defined");if(i>n.length)throw new RangeError(`Window size is higher than the data length ${i}>${n.length}`);if(a<0||!Number.isInteger(a))throw new RangeError("Derivative should be a positive integer");if(s<1||!Number.isInteger(s))throw new RangeError("Polynomial should be a positive integer");s>=6&&console.warn("You should not use polynomial grade higher than 5 if you are not sure that your data arises from such a model. Possible polynomial oscillation problems");const r=Math.floor(i/2),o=n.length,f=new Float64Array(o),l=fullWeights(i,s,a);let d=0,g=!0;isAnyArray$1(t)?g=!1:d=t**a;for(let e=0;e<r;e++){const s=l[r-e-1],u=l[r+e+1];let c=0,b=0;for(let t=0;t<i;t++)c+=s[t]*n[t],b+=u[t]*n[o-i+t];g?(f[r-e-1]=c/d,f[o-r+e]=b/d):(d=getHs(t,r-e-1,r,a),f[r-e-1]=c/d,d=getHs(t,o-r+e,r,a),f[o-r+e]=b/d)}const u=l[r];for(let e=i;e<=o;e++){let s=0;for(let t=0;t<i;t++)s+=u[t]*n[t+e-i];g||(d=getHs(t,e-r-1,r,a)),f[e-r-1]=s/d}return f}function getHs(n,t,e,i){let a=0,s=0;for(let i=t-e;i<t+e;i++)i>=0&&i<n.length-1&&(a+=n[i+1]-n[i],s++);return(a/s)**i}function gramPoly(n,t,e,i){let a=0;return a=e>0?(4*e-2)/(e*(2*t-e+1))*(n*gramPoly(n,t,e-1,i)+i*gramPoly(n,t,e-1,i-1))-(e-1)*(2*t+e)/(e*(2*t-e+1))*gramPoly(n,t,e-2,i):0===e&&0===i?1:0,a}function genFact(n,t){let e=1;if(n>=t)for(let i=n-t+1;i<=n;i++)e*=i;return e}function weight(n,t,e,i,a){let s=0;for(let r=0;r<=i;r++)s+=(2*r+1)*(genFact(2*e,r)/genFact(2*e+r+1,r+1))*gramPoly(n,e,r,0)*gramPoly(t,e,r,a);return s}function fullWeights(n,t,e){const i=new Array(n),a=Math.floor(n/2);for(let s=-a;s<=a;s++){i[s+a]=new Float64Array(n);for(let n=-a;n<=a;n++)i[s+a][n+a]=weight(n,s,a,t,e)}return i}function firstDerivative(n,t={}){const{x:e,y:i}=n;return{data:{x:e,y:sgg(i,e,{...t,derivative:1})}}}function secondDerivative(n,t={}){const{x:e,y:i}=n;return{data:{x:e,y:sgg(i,e,{...t,derivative:2})}}}function thirdDerivative(n,t={}){const{x:e,y:i}=n;return{data:{x:e,y:sgg(i,e,{...t,derivative:3})}}}function savitzkyGolay(n,t={}){const{x:e,y:i}=n;return{data:{x:e,y:sgg(i,e,t)}}}function ensureGrowing(n){return{data:xyEnsureGrowingX(n)}}function equallySpaced(n,t={}){return{data:xyEquallySpaced(n,t)}}function filterX(n,t={}){return{data:xyFilterX(n,t)}}function optimizeTop(n,t){const{x:e,y:i}=n;for(const n of t){let t=n.index;if(i[t-1]>=i[t-2]&&i[t-1]>=i[t]?t--:i[t+1]>=i[t]&&i[t+1]>=i[t+2]?t++:i[t-2]>=i[t-3]&&i[t-2]>=i[t-1]?t-=2:i[t+2]>=i[t+1]&&i[t+2]>=i[t+3]&&(t+=2),i[t-1]>0&&i[t+1]>0&&i[t]>=i[t-1]&&i[t]>=i[t+1]&&(i[t]!==i[t-1]||i[t]!==i[t+1])){const a=20*Math.log10(i[t-1]),s=20*Math.log10(i[t]),r=20*Math.log10(i[t+1]),o=.5*(a-r)/(a-2*s+r);n.x=e[t]+(e[t]-e[t-1])*o,n.y=i[t]-.25*(i[t-1]-i[t+1])*o}}}function gsd(n,t={}){let{noiseLevel:e}=t;const{sgOptions:i={windowSize:9,polynomial:3},smoothY:a=!1,maxCriteria:s=!0,minMaxRatio:r=25e-5,realTopDetection:o=!1}=t,{x:f}=n;let{y:l}=n;if(1!==xIsMonotonic(f))throw new Error("GSD only accepts monotone increasing x values");l=l.slice();const d=xIsEquallySpaced(f);if(void 0===e)if(d){const n=xNoiseStandardDeviation(l);e=s?n.median+1.5*n.sd:-n.median+1.5*n.sd}else e=0;else s||(e*=-1);if(!s)for(let n=0;n<l.length;n++)l[n]*=-1;if(void 0!==e)for(let n=0;n<l.length;n++)l[n]<e&&(l[n]=e);const g=d?f[1]-f[0]:f,u=a?sgg(l,g,{...i,derivative:0}):l,c=sgg(l,g,{...i,derivative:1}),b=sgg(l,g,{...i,derivative:2}),{min:h,max:D}=xMinMaxValues(u);if(h>D||h===D)return[];const H=h+(D-h)*r,j=f[1]-f[0];let m=null,A=null;const C=[],p=[],M=[];for(let n=1;n<u.length-1;++n)(c[n]<c[n-1]&&c[n]<=c[n+1]||c[n]<=c[n-1]&&c[n]<c[n+1])&&(A={x:f[n],index:n},j>0&&null!==m&&(p.push(m),M.push(A))),(c[n]>=c[n-1]&&c[n]>c[n+1]||c[n]>c[n-1]&&c[n]>=c[n+1])&&(m={x:f[n],index:n},j<0&&null!==A&&(p.push(m),M.push(A))),b[n]<b[n-1]&&b[n]<b[n+1]&&C.push(n);let I=-1;const P=[];for(const n of C){const t=f[n];let e=-1,i=I+1,a=Number.POSITIVE_INFINITY,s=0;for(;-1===e&&i<p.length&&(s=Math.abs(t-(p[i].x+M[i].x)/2),s<(M[i].x-p[i].x)/2&&(e=i,I=i),++i,!(s>=a));)a=s;if(-1!==e&&u[n]>H){const i=Math.abs(M[e].x-p[e].x);P.push({id:v4(),x:t,y:u[n],width:i,index:n,ddY:b[n],inflectionPoints:{from:p[e],to:M[e]}})}}return o&&optimizeTop({x:f,y:u},P),P.forEach((n=>{s||(n.y*=-1,n.ddY=-1*n.ddY)})),P.sort(((n,t)=>n.x-t.x)),P}const GAUSSIAN_EXP_FACTOR=-4*Math.LN2,ROOT_PI_OVER_LN2=Math.sqrt(Math.PI/Math.LN2),ROOT_THREE=Math.sqrt(3),ROOT_2LN2=Math.sqrt(2*Math.LN2),ROOT_2LN2_MINUS_ONE=Math.sqrt(2*Math.LN2)-1;function erfinv(n){if(0===n)return 0;let t=Math.log(1-n*n),e=t/2+2/(.147*Math.PI),i=Math.sqrt(e**2-t/.147);return Math.sqrt(i-e)*(n>0?1:-1)}class Gaussian{constructor(n={}){const{fwhm:t=500,sd:e}=n;this.fwhm=e?gaussianWidthToFWHM(2*e):t}fwhmToWidth(n=this.fwhm){return gaussianFwhmToWidth(n)}widthToFWHM(n){return gaussianWidthToFWHM(n)}fct(n){return gaussianFct(n,this.fwhm)}getArea(n=calculateGaussianHeight({fwhm:this.fwhm})){return getGaussianArea({fwhm:this.fwhm,height:n})}getFactor(n){return getGaussianFactor(n)}getData(n={}){return getGaussianData(this,n)}calculateHeight(n=1){return calculateGaussianHeight({fwhm:this.fwhm,area:n})}getParameters(){return["fwhm"]}}function calculateGaussianHeight(n){let{fwhm:t=500,area:e=1,sd:i}=n;return i&&(t=gaussianWidthToFWHM(2*i)),2*e/ROOT_PI_OVER_LN2/t}function gaussianFct(n,t){return Math.exp(GAUSSIAN_EXP_FACTOR*Math.pow(n/t,2))}function gaussianWidthToFWHM(n){return n*ROOT_2LN2}function gaussianFwhmToWidth(n){return n/ROOT_2LN2}function getGaussianArea(n){let{fwhm:t=500,sd:e,height:i=1}=n;return e&&(t=gaussianWidthToFWHM(2*e)),i*ROOT_PI_OVER_LN2*t/2}function getGaussianFactor(n=.9999){return Math.sqrt(2)*erfinv(n)}function getGaussianData(n={},t={}){let{fwhm:e=500,sd:i}=n;i&&(e=gaussianWidthToFWHM(2*i));let{length:a,factor:s=getGaussianFactor(),height:r=calculateGaussianHeight({fwhm:e})}=t;a||(a=Math.min(Math.ceil(e*s),Math.pow(2,25)-1),a%2==0&&a++);const o=(a-1)/2,f=new Float64Array(a);for(let n=0;n<=o;n++)f[n]=gaussianFct(n-o,e)*r,f[a-1-n]=f[n];return f}class Lorentzian{constructor(n={}){const{fwhm:t=500}=n;this.fwhm=t}fwhmToWidth(n=this.fwhm){return lorentzianFwhmToWidth(n)}widthToFWHM(n){return lorentzianWidthToFWHM(n)}fct(n){return lorentzianFct(n,this.fwhm)}getArea(n=1){return getLorentzianArea({fwhm:this.fwhm,height:n})}getFactor(n){return getLorentzianFactor(n)}getData(n={}){return getLorentzianData(this,n)}calculateHeight(n=1){return calculateLorentzianHeight({fwhm:this.fwhm,area:n})}getParameters(){return["fwhm"]}}const calculateLorentzianHeight=({fwhm:n=1,area:t=1})=>2*t/Math.PI/n,getLorentzianArea=n=>{const{fwhm:t=500,height:e=1}=n;return e*Math.PI*t/2},lorentzianFct=(n,t)=>t**2/(4*n**2+t**2),lorentzianWidthToFWHM=n=>n*ROOT_THREE,lorentzianFwhmToWidth=n=>n/ROOT_THREE,getLorentzianFactor=(n=.9999)=>{if(n>=1)throw new Error("area should be (0 - 1)");const t=.5*(1-n),e=n=>Math.tan(Math.PI*(n-.5));return(e(1-t)-e(t))/2},getLorentzianData=(n={},t={})=>{let{fwhm:e=500}=n,{length:i,factor:a=getLorentzianFactor(),height:s=calculateLorentzianHeight({fwhm:e,area:1})}=t;i||(i=Math.min(Math.ceil(e*a),Math.pow(2,25)-1),i%2==0&&i++);const r=(i-1)/2,o=new Float64Array(i);for(let n=0;n<=r;n++)o[n]=lorentzianFct(n-r,e)*s,o[i-1-n]=o[n];return o};class PseudoVoigt{constructor(n={}){const{fwhm:t=500,mu:e=.5}=n;this.mu=e,this.fwhm=t}fwhmToWidth(n=this.fwhm,t=this.mu){return pseudoVoigtFwhmToWidth(n,t)}widthToFWHM(n,t=this.mu){return pseudoVoigtWidthToFWHM(n,t)}fct(n){return pseudoVoigtFct(n,this.fwhm,this.mu)}getArea(n=1){return getPseudoVoigtArea({fwhm:this.fwhm,height:n,mu:this.mu})}getFactor(n){return getPseudoVoigtFactor(n)}getData(n={}){const{length:t,factor:e,height:i=calculatePseudoVoigtHeight({fwhm:this.fwhm,mu:this.mu,area:1})}=n;return getPseudoVoigtData(this,{factor:e,length:t,height:i})}calculateHeight(n=1){return calculatePseudoVoigtHeight({fwhm:this.fwhm,mu:this.mu,area:n})}getParameters(){return["fwhm","mu"]}}const calculatePseudoVoigtHeight=(n={})=>{let{fwhm:t=1,mu:e=.5,area:i=1}=n;return 2*i/(t*(e*ROOT_PI_OVER_LN2+(1-e)*Math.PI))},pseudoVoigtFct=(n,t,e)=>(1-e)*lorentzianFct(n,t)+e*gaussianFct(n,t),pseudoVoigtWidthToFWHM=(n,t=.5)=>n*(t*ROOT_2LN2_MINUS_ONE+1),pseudoVoigtFwhmToWidth=(n,t=.5)=>n/(t*ROOT_2LN2_MINUS_ONE+1),getPseudoVoigtArea=n=>{const{fwhm:t=500,height:e=1,mu:i=.5}=n;return t*e*(i*ROOT_PI_OVER_LN2+(1-i)*Math.PI)/2},getPseudoVoigtFactor=(n=.9999,t=.5)=>t<1?getLorentzianFactor(n):getGaussianFactor(n),getPseudoVoigtData=(n={},t={})=>{let{fwhm:e=500,mu:i=.5}=n,{length:a,factor:s=getPseudoVoigtFactor(.999,i),height:r=calculatePseudoVoigtHeight({fwhm:e,mu:i,area:1})}=t;r||(r=1/(i/Math.sqrt(-GAUSSIAN_EXP_FACTOR/Math.PI)*e+(1-i)*e*Math.PI/2)),a||(a=Math.min(Math.ceil(e*s),Math.pow(2,25)-1),a%2==0&&a++);const o=(a-1)/2,f=new Float64Array(a);for(let n=0;n<=o;n++)f[n]=pseudoVoigtFct(n-o,e,i)*r,f[a-1-n]=f[n];return f};class Gaussian2D{constructor(n={}){let{fwhm:t=20,sd:e}=n;t=ensureFWHM2D(t,e),this.fwhmX=t.x,this.fwhmY=t.y}fct(n,t){return gaussian2DFct(n,t,this.fwhmX,this.fwhmY)}getData(n={}){return getGaussian2DData({fwhm:{x:this.fwhmX,y:this.fwhmY}},n)}getFactor(n=1){return getGaussianFactor(n)}getVolume(n=calculateGaussian2DHeight({fwhm:{x:this.fwhmX,y:this.fwhmY},volume:1})){return getGaussian2DVolume({fwhm:{x:this.fwhmX,y:this.fwhmY},height:n})}widthToFWHM(n){return gaussianWidthToFWHM(n)}fwhmToWidth(n){return gaussianFwhmToWidth(n)}calculateHeight(n=1){return calculateGaussian2DHeight({volume:n,fwhm:{x:this.fwhmX,y:this.fwhmY}})}set fwhm(n){n=ensureXYNumber$2(n),this.fwhmX=n.x,this.fwhmY=n.y}}const gaussian2DFct=(n,t,e,i)=>Math.exp(GAUSSIAN_EXP_FACTOR*(Math.pow(n/e,2)+Math.pow(t/i,2))),getGaussian2DData=(n,t={})=>{let{fwhm:e=50,sd:i}=n;e=ensureFWHM2D(e,i);let{factor:a=getGaussianFactor(),length:s={x:0,y:0},height:r=calculateGaussian2DHeight({fwhm:e,volume:1})}=t;a=ensureXYNumber$2(a),s=ensureXYNumber$2(s);for(const n of["x","y"])s[n]||(s[n]=Math.min(Math.ceil(e[n]*a[n]),Math.pow(2,25)-1),s[n]%2==0&&s[n]++);const o=(s.x-1)/2,f=(s.y-1)/2,l=new Array(s.x);for(let n=0;n<s.x;n++)l[n]=new Float64Array(s.y);for(let n=0;n<s.x;n++)for(let t=0;t<s.y;t++)l[n][t]=gaussian2DFct(n-o,t-f,e.x,e.y)*r;return l},calculateGaussian2DHeight=(n={})=>{let{volume:t=1,fwhm:e=50,sd:i}=n;return e=ensureFWHM2D(e,i),t*Math.LN2*4/(Math.PI*e.y*e.x)},getGaussian2DVolume=(n={})=>{let{fwhm:t=50,height:e=1,sd:i}=n;return t=ensureFWHM2D(t,i),e*Math.PI*t.y*t.x/Math.LN2/4};function ensureXYNumber$2(n){return"object"!=typeof n?{x:n,y:n}:{...n}}function ensureFWHM2D(n,t){if(void 0!==t){let n=ensureXYNumber$2(t);return{x:gaussianWidthToFWHM(2*n.x),y:gaussianWidthToFWHM(2*n.y)}}if(void 0!==n)return ensureXYNumber$2(n);throw new Error("ensureFWHM2D must have either fwhm or sd defined")}function getShape1D(n){const{kind:t}=n;switch(t){case"gaussian":return new Gaussian(n);case"lorentzian":return new Lorentzian(n);case"pseudoVoigt":return new PseudoVoigt(n);default:throw Error(`Unknown distribution ${t}`)}}function getShape2D(n){const{kind:t}=n;if("gaussian"===t)return new Gaussian2D(n);throw Error(`Unknown distribution ${t}`)}function getSumOfShapes$1(n){return function(t){return e=>{let i=0;for(const a of n){const n=t[a.fromIndex],s=t[a.fromIndex+1];for(let n=2;n<t.length;n++)a.shapeFct[a.parameters[n]]=t[a.fromIndex+n];i+=s*a.shapeFct.fct(e-n)}return i}}}function assert(n,t){if(!n)throw new Error(t||"unreachable")}const DefaultParameters={x:{init:n=>n.x,min:(n,t)=>n.x-2*t.fwhm,max:(n,t)=>n.x+2*t.fwhm,gradientDifference:(n,t)=>.002*t.fwhm},y:{init:n=>n.y,min:n=>n.y<0?-1.1:0,max:n=>n.y<0?0:1.1,gradientDifference:()=>.001},fwhm:{init:(n,t)=>t.fwhm,min:(n,t)=>.25*t.fwhm,max:(n,t)=>4*t.fwhm,gradientDifference:(n,t)=>.002*t.fwhm},mu:{init:(n,t)=>t.mu,min:()=>0,max:()=>1,gradientDifference:()=>.01}},properties$1=["init","min","max","gradientDifference"];function getInternalPeaks(n,t,e={}){let i=0;const a=[],{baseline:s=t.min}=e,r=n.map((n=>({...n,y:(n.y-s)/t.range})));for(const n of r){const{id:s,shape:r=(e.shape?e.shape:{kind:"gaussian"})}=n,o=getShape1D(r),f=["x","y",...o.getParameters()],l={min:[],max:[],init:[],gradientDifference:[]};for(const i of f)for(const a of properties$1){let s=n?.parameters?.[i]?.[a];if(s){s=getNormalizedValue$1(s,i,a,t,e.baseline),l[a].push(s);continue}let r=e?.parameters?.[i]?.[a];if(r){if("number"==typeof r){r=getNormalizedValue$1(r,i,a,t,e.baseline),l[a].push(r);continue}{let s=r(n);s=getNormalizedValue$1(s,i,a,t,e.baseline),l[a].push(s);continue}}assert(DefaultParameters[i],`No default parameter for ${i}`);const f=DefaultParameters[i][a];l[a].push(f(n,o))}const d=i,g=d+f.length-1;i+=g-d+1,a.push({id:s,shape:r,shapeFct:o,parameters:f,propertiesValues:l,fromIndex:d,toIndex:g})}return a}function getNormalizedValue$1(n,t,e,i,a){return"y"===t?"gradientDifference"===e?n:void 0!==a?(n-a)/i.range:(n-i.min)/i.range:n}function checkOptions(n,t,e){let{timeout:i,minValues:a,maxValues:s,initialValues:r,weights:o=1,damping:f=.01,dampingStepUp:l=11,dampingStepDown:d=9,maxIterations:g=100,errorTolerance:u=1e-7,centralDifference:c=!1,gradientDifference:b=.1,improvementThreshold:h=.001}=e;if(f<=0)throw new Error("The damping option must be a positive number");if(!n.x||!n.y)throw new Error("The data parameter must have x and y elements");if(!isAnyArray$1(n.x)||n.x.length<2||!isAnyArray$1(n.y)||n.y.length<2)throw new Error("The data parameter elements must be an array with more than 2 points");if(n.x.length!==n.y.length)throw new Error("The data parameter elements must have the same size");if(!(r&&r.length>0))throw new Error("The initialValues option is mandatory and must be an array");let D,H,j=r,m=n.y.length,A=j.length;if(s=s||new Array(A).fill(Number.MAX_SAFE_INTEGER),a=a||new Array(A).fill(Number.MIN_SAFE_INTEGER),s.length!==a.length)throw new Error("minValues and maxValues must be the same size");if("number"==typeof b)b=new Array(j.length).fill(b);else{if(!isAnyArray$1(b))throw new Error("gradientDifference should be a number or array with length equal to the number of parameters");b.length!==A&&(b=new Array(A).fill(b[0]))}if("number"==typeof o){let n=1/o**2;D=()=>n}else{if(!isAnyArray$1(o))throw new Error("weights should be a number or array with length equal to the number of data points");if(o.length<n.x.length){let n=1/o[0]**2;D=()=>n}else D=n=>1/o[n]**2}if(void 0!==i){if("number"!=typeof i)throw new Error("timeout should be a number");let n=Date.now()+1e3*i;H=()=>Date.now()>n}else H=()=>!1;let C=new Array(n.x.length);for(let n=0;n<m;n++)C[n]=D(n);return{checkTimeout:H,minValues:a,maxValues:s,parameters:j,weightSquare:C,damping:f,dampingStepUp:l,dampingStepDown:d,maxIterations:g,errorTolerance:u,centralDifference:c,gradientDifference:b,improvementThreshold:h}}function errorCalculation(n,t,e,i){let a=0;const s=e(t);for(let t=0;t<n.x.length;t++)a+=Math.pow(n.y[t]-s(n.x[t]),2)/i[t];return a}function gradientFunction(n,t,e,i,a,s){const r=e.length,o=n.x.length;let f=Matrix.zeros(r,o),l=0;for(let d=0;d<r;d++){if(0===i[d])continue;let r=i[d],g=e.slice();g[d]+=r;let u=a(g);if(s){g=e.slice(),g[d]-=r,r*=2;let t=a(g);for(let e=0;e<o;e++)f.set(l,e,(t(n.x[e])-u(n.x[e]))/r)}else for(let e=0;e<o;e++)f.set(l,e,(t[e]-u(n.x[e]))/r);l++}return f}function matrixFunction(n,t){const e=n.x.length;let i=new Matrix(e,1);for(let a=0;a<e;a++)i.set(a,0,n.y[a]-t[a]);return i}function step(n,t,e,i,a,s,r){let o=e,f=Matrix.eye(t.length,t.length,o);const l=a(t);let d=new Float64Array(n.x.length);for(let t=0;t<n.x.length;t++)d[t]=l(n.x[t]);let g=gradientFunction(n,d,t,i,a,s),u=matrixFunction(n,d),c=inverse(f.add(g.mmul(g.transpose().scale("row",{scale:r})))),b=g.mmul(u.scale("row",{scale:r}));return{perturbations:c.mmul(b),jacobianWeightResidualError:b}}function levenbergMarquardt(n,t,e){let{checkTimeout:i,minValues:a,maxValues:s,parameters:r,weightSquare:o,damping:f,dampingStepUp:l,dampingStepDown:d,maxIterations:g,errorTolerance:u,centralDifference:c,gradientDifference:b,improvementThreshold:h}=checkOptions(n,t,e),D=errorCalculation(n,r,t,o),H=D,j=r.slice(),m=D<=u,A=0;for(;A<g&&!m;A++){let g=D,{perturbations:A,jacobianWeightResidualError:C}=step(n,r,f,b,t,c,o);for(let n=0;n<r.length;n++)r[n]=Math.min(Math.max(a[n],r[n]-A.get(n,0)),s[n]);if(D=errorCalculation(n,r,t,o),isNaN(D))break;if(D<H-u&&(H=D,j=r.slice()),f=(g-D)/A.transpose().mmul(A.mul(f).add(C)).get(0,0)>h?Math.max(f/d,1e-7):Math.min(f*l,1e7),i())throw new Error(`The execution time is over to ${e.timeout} seconds`);m=D<=u}return{parameterValues:j,parameterError:H,iterations:A}}function antiLowerConvexHull(n,t){if(n.length!==t.length)throw new RangeError("X and Y vectors has different dimensions");const e=n.length-1;if(0===e)return[0];if(1===e)return[0,1];let i=0,a=new Array(n.length).fill(!0);for(;;){const s=i,r=moveOn(i,e,a),o=moveOn(moveOn(i,e,a),e,a);if(n[o]*(t[s]-t[r])+n[s]*(t[r]-t[o])+n[r]*(t[o]-t[s])>=0?i=r:(a[r]=!1,i=moveBack(i,e,a)),o===e)break}return a.map(((n,t)=>!1!==n&&t)).filter((n=>!1!==n))}function moveBack(n,t,e){let i=n-1;for(;!1===e[i];)i--;return 0===n?t:i}function moveOn(n,t,e){let i=n+1;for(;!1===e[i];)i++;return n===t?0:i}function direct(n,t,e,i={}){const{iterations:a=50,epsilon:s=1e-4,tolerance:r=1e-16,tolerance2:o=1e-12,initialState:f={}}=i;if(void 0===n||void 0===t||void 0===e)throw new RangeError("There is something undefined");if(t=new Float64Array(t),e=new Float64Array(e),t.length!==e.length)throw new Error("Lower bounds and Upper bounds for x are not of the same length");let l=t.length,d=e.map(((n,e)=>n-t[e])),{numberOfRectangles:g=0,totalIterations:u=0,unitaryCoordinates:c=[new Float64Array(l).fill(.5)],middlePoint:b=new Float64Array(l).map(((n,e)=>t[e]+c[0][e]*d[e])),bestCurrentValue:h=n(b),fCalls:D=1,smallerDistance:H=0,edgeSizes:j=[new Float64Array(l).fill(.5)],diagonalDistances:m=[Math.sqrt(.25*l)],functionValues:A=[h],differentDistances:C=m,smallerValuesByDistance:p=[h],choiceLimit:M}=f;if(f.originalCoordinates&&f.originalCoordinates.length>0){h=xMinValue(A),M=s*Math.abs(h)>1e-8?s*Math.abs(h):1e-8,H=getMinIndex(A,m,M,h),c=f.originalCoordinates.slice();for(let n=0;n<c.length;n++)for(let e=0;e<t.length;e++)c[n][e]=(c[n][e]-t[e])/d[e]}let I=0;for(;I<a;){let e,i,a=[],f=C.findIndex((n=>n===m[H])),l=0;for(let n=f;n<C.length;n++)for(let t=0;t<A.length;t++)A[t]===p[n]&m[t]===C[n]&&(a[l++]=t);if(C.length-f>1){let n=m[H],t=A[H],e=C[C.length-1],s=(p[C.length-1]-t)/(e-n),r=t-s*n,f=new Uint32Array(l);l=0;for(let n=0;n<f.length;n++){let t=a[n];A[t]<=s*m[t]+r+o&&(f[l++]=t)}let d=[],g=[];for(let n=0;n<l;n++)d.push(m[f[n]]),g.push(A[f[n]]);let u=antiLowerConvexHull(d,g);i=[];for(let n=0;n<u.length;n++)i.push(f[u[n]])}else i=a.slice(0,l);e=i;for(let i=0;i<e.length;i++){let a=e[i],s=xMaxValue(j[a]),o=new Uint32Array(j[a].length);l=0;for(let n=0;n<j[a].length;n++)Math.abs(j[a][n]-s)<r&&(o[l++]=n);let f=2*s/3,u=[];for(let e=0;e<l;e++){let i=o[e],s=c[a].slice(),r=c[a].slice();s[i]+=f,r[i]-=f;let l=new Float64Array(s.length),g=new Float64Array(r.length);for(let n=0;n<s.length;n++)l[n]=t[n]+s[n]*d[n],g[n]=t[n]+r[n]*d[n];let b=n(l),h=n(g);D+=2,u.push({minValue:Math.min(b,h),index:e}),c.push(s,r),A.push(b,h)}let b=u.sort(((n,t)=>n.minValue-t.minValue));for(let n=0;n<l;n++){let t=o[b[n].index],e=g+2*(b[n].index+1)-1,i=g+2*(b[n].index+1);j[a][t]=f/2,j[e]=j[a].slice(),j[i]=j[a].slice(),m[a]=xNorm(j[a]),m[e]=m[a],m[i]=m[a]}g+=2*l}h=xMinValue(A),M=s*Math.abs(h)>1e-8?s*Math.abs(h):1e-8,H=getMinIndex(A,m,M,h),C=Array.from(new Set(m)),C=C.sort(((n,t)=>n-t)),p=[];for(let n=0;n<C.length;n++){let t,e=Number.POSITIVE_INFINITY;for(let i=0;i<m.length;i++)m[i]===C[n]&&A[i]<e&&(e=A[i],t=i);p.push(A[t])}for(let n=0;n<A.length;n++)if(A[n]===h){let e=[];for(let i=0;i<t.length;i++)e.push(t[i]+c[n][i]*d[i])}I+=1}let P={};P.minFunctionValue=h,P.iterations=I;let T=[];for(let n=0;n<g+1;n++){let e=[];for(let i=0;i<t.length;i++)e.push(t[i]+c[n][i]*d[i]);T.push(e)}P.finalState={numberOfRectangles:g,totalIterations:u+=a,originalCoordinates:T,middlePoint:b,fCalls:D,smallerDistance:H,edgeSizes:j,diagonalDistances:m,functionValues:A,differentDistances:C,smallerValuesByDistance:p,choiceLimit:M};let N=[];for(let n=0;n<A.length;n++)A[n]===h&&N.push(T[n]);return P.optima=N,P}function getMinIndex(n,t,e,i){let a=[];for(let s=0;s<n.length;s++)a[s]=Math.abs(n[s]-(i+e))/t[s];const s=xMinValue(a);return a.findIndex((n=>n===s))}function directOptimization$1(n,t,e){const{minValues:i,maxValues:a,maxIterations:s,epsilon:r,tolerance:o,tolerance2:f,initialState:l}=e,d=direct(getObjectiveFunction$2(n,t),i,a,{iterations:s,epsilon:r,tolerance:o,tolerance2:f,initialState:l}),{optima:g}=d;return{parameterError:d.minFunctionValue,iterations:d.iterations,parameterValues:g[0]}}function getObjectiveFunction$2(n,t){const{x:e,y:i}=n,a=e.length;return n=>{const s=t(n);let r=0;for(let n=0;n<a;n++)r+=(i[n]-s(e[n]))**2;return r}}function selectMethod(n={}){const{kind:t="lm",options:e}=n;switch(t){case"lm":case"levenbergMarquardt":return{algorithm:levenbergMarquardt,optimizationOptions:{damping:1.5,maxIterations:100,errorTolerance:1e-8,...e}};case"direct":return{algorithm:directOptimization$1,optimizationOptions:{iterations:20,epsilon:1e-4,tolerance:1e-16,tolerance2:1e-12,initialState:{},...e}};default:throw new Error("Unknown fitting algorithm")}}function optimize(n,t,e={}){const i=xMinMaxValues(n.y),a={...i,range:i.max-i.min},s=getInternalPeaks(t,a,e),{baseline:r=a.min}=e,o=new Float64Array(n.y.length);for(let t=0;t<n.y.length;t++)o[t]=(n.y[t]-r)/a.range;const f=s[s.length-1].toIndex+1,l=new Float64Array(f),d=new Float64Array(f),g=new Float64Array(f),u=new Float64Array(f);let c=0;for(const n of s)for(let t=0;t<n.parameters.length;t++)l[c]=n.propertiesValues.min[t],d[c]=n.propertiesValues.max[t],g[c]=n.propertiesValues.init[t],u[c]=n.propertiesValues.gradientDifference[t],c++;const{algorithm:b,optimizationOptions:h}=selectMethod(e.optimization),D=getSumOfShapes$1(s),H=b({x:n.x,y:o},D,{minValues:l,maxValues:d,initialValues:g,gradientDifference:u,...h}),j=H.parameterValues,m=[];for(const n of s){const{id:t,shape:e,parameters:i,fromIndex:s}=n;let o={x:0,y:0,shape:e};t&&(o={...o,id:t}),o.x=j[s],o.y=j[s+1]*a.range+r;for(let n=2;n<i.length;n++)o.shape[i[n]]=j[s+n];m.push(o)}return{error:H.parameterError,iterations:H.iterations,peaks:m}}const{parse:parse$7,stringify:stringify$7}=JSON;function addMissingShape(n,t={}){const{shape:e={kind:"gaussian"},output:i=parse$7(stringify$7(n))}=t,a=getShape1D(e);return i.map((n=>{if(hasShape(n)){if(!("fwhm"in n.shape)){const t=getShape1D(n.shape);n.shape.fwhm=t.widthToFWHM(n.width)}return n}return{...n,shape:{fwhm:a.widthToFWHM(n.width),...e}}}))}function hasShape(n){return"shape"in n}function groupPeaks(n,t={}){if(n&&0===n.length)return[];const{factor:e=1}=t;(n=JSON.parse(JSON.stringify(n))).sort(((n,t)=>n.x-t.x));let i=n[0],a=[i];const s=[a];for(let t=1;t<n.length;t++){const r=n[t];(r.x-i.x)/((r.width+i.width)/2)<=e?a.push(r):(a=[r],s.push(a)),i=r}return s}function optimizePeaksWithLogs(n,t,e={}){const{fromTo:i={},baseline:a,shape:s={kind:"gaussian"},groupingFactor:r=1,factorLimits:o=2,optimization:f={kind:"lm",options:{timeout:10}}}=e,l=groupPeaks(t,{factor:r}),d=[],g=[];return l.forEach((t=>{const e=Date.now(),r=addMissingShape(t,{shape:s}),l=r[0],u=r[r.length-1],{from:c=l.x-l.width*o,to:b=u.x+u.width*o}=i,{fromIndex:h,toIndex:D}=xGetFromToIndex(n.x,{from:c,to:b}),H=n.x instanceof Float64Array?n.x.subarray(h,D):n.x.slice(h,D),j=n.y instanceof Float64Array?n.y.subarray(h,D):n.y.slice(h,D),m={range:{from:c,to:b},parameters:f,groupSize:t.length,time:Date.now()-e};if(H.length>5){const{iterations:n,error:t,peaks:e}=optimize({x:H,y:j},r,{shape:s,baseline:a,optimization:f});for(let n=0;n<r.length;n++)g.push({...e[n],width:getShape1D(r[n].shape).fwhmToWidth(e[n].shape.fwhm)});d.push({...m,iterations:n,error:t,message:"optimization successful"})}else g.push(...r),d.push({...m,iterations:0,message:"x length too small for optimization"})})),{logs:d,optimizedPeaks:g}}function optimizePeaks(n,t,e={}){return optimizePeaksWithLogs(n,t,e).optimizedPeaks}const{parse:parse$6,stringify:stringify$6}=JSON;function addMissingIDs$1(n,t={}){const{output:e=parse$6(stringify$6(n))}=t;for(const n of e)"id"in n||(n.id=v4());return e}function joinBroadPeaks(n,t={}){const{shape:e={kind:"gaussian"},optimization:i={kind:"lm",options:{timeout:10}},broadWidth:a=.25,broadRatio:s=.0025}=t;let r=0,o=0,f=1;const l=[];if(n.length<2)return addMissingIDs$1(addMissingShape(n.map(getGSDPeakOptimizedStructure),{shape:e}));let d=n[0].ddY;for(let t=1;t<n.length;t++)Math.abs(n[t].ddY)>d&&(d=Math.abs(n[t].ddY));const g=[];for(const t of n)Math.abs(t.ddY)<=s*d?l.push(t):g.push(getGSDPeakOptimizedStructure(t));l.push({x:Number.MAX_VALUE,y:0});let u={x:[l[0].x],y:[l[0].y]},c=[0];for(let n=1;n<l.length;n++)if(Math.abs(l[n-1].x-l[n].x)<a)u.x.push(l[n].x),u.y.push(l[n].y),l[n].y>r&&(r=l[n].y,o=n),c.push(n),f++;else{if(f>2){const n=Math.abs(u.x[u.x.length-1]-u.x[0]),{logs:t,optimizedPeaks:e}=optimizePeaksWithLogs(u,[{id:v4(),x:l[o].x,y:r,width:n,parameters:{width:{max:4*n,min:.8*n}}}],{shape:{kind:"pseudoVoigt"},optimization:i});[r,o]=[0,0];const a=t.find((n=>"optimization successful"===n.message));if(a){const{error:n}=a;n<.2?g.push(e[0]):pushBackPeaks(l,c,g)}else pushBackPeaks(l,c,g)}else pushBackPeaks(l,c,g);u={x:[l[n].x],y:[l[n].y]},c=[n],r=l[n].y,o=n,f=1}return g.sort(((n,t)=>n.x-t.x)),addMissingIDs$1(g,{output:g})}function pushBackPeaks(n,t,e){for(const i of t)e.push(getGSDPeakOptimizedStructure(n[i]))}function getGSDPeakOptimizedStructure(n){const{id:t,shape:e,x:i,y:a,width:s}=n,r={x:i,y:a,width:s,shape:e};return t&&(r.id=t),r}const{parse:parse$5,stringify:stringify$5}=JSON;function setShape(n,t={}){const{shape:e={kind:"gaussian"},output:i=parse$5(stringify$5(n))}=t,a=getShape1D(e);return i.map((n=>({...n,shape:{fwhm:a.widthToFWHM(n.width),...e}})))}function calibrateX(n,t={}){const{targetX:e=0,nbPeaks:i=1,from:a=n.x[0],to:s=n.x[n.x.length-1],gsd:r={minMaxRatio:.1,realTopDetection:!0,smoothY:!0,sgOptions:{windowSize:7,polynomial:3}}}=t,o=xFindClosestIndex(n.x,a),f=xFindClosestIndex(n.x,s),l=gsd({x:n.x.subarray(o,f),y:n.y.subarray(o,f)},r).sort(((n,t)=>t.y-n.y)).slice(0,i);if(l.length<i)return{data:n};const d=xMean(l.map((n=>n.x)));return{data:{x:xAdd(n.x,e-d),y:n.y}}}function xFunction(n,t={}){return{data:{x:xApplyFunctionStr(n.x,{variableLabel:"x",fctString:t.function}),y:n.y}}}function yFunction(n,t={}){return{data:{x:n.x,y:xApplyFunctionStr(n.y,{variableLabel:"y",fctString:t.function})}}}var Filters$2=Object.freeze({__proto__:null,centerMean:centerMean,centerMedian:centerMedian,fromTo:fromTo$1,normed:normed,divideBySD:divideBySD,rescale:rescale,paretoNormalization:paretoNormalization,airPLSBaseline:airPLSBaseline,iterativePolynomialBaseline:iterativePolynomialBaseline,rollingAverageBaseline:rollingAverageBaseline,rollingBallBaseline:rollingBallBaseline,rollingMedianBaseline:rollingMedianBaseline,firstDerivative:firstDerivative,secondDerivative:secondDerivative,thirdDerivative:thirdDerivative,savitzkyGolay:savitzkyGolay,ensureGrowing:ensureGrowing,equallySpaced:equallySpaced,filterX:filterX,calibrateX:calibrateX,xFunction:xFunction,yFunction:yFunction});function filterXY$1(n,t){let e={data:{x:xEnsureFloat64(n.x),y:xEnsureFloat64(n.y)}};const i=[];for(const n of t){const t=Date.now(),a=Filters$2[n.name];if(!a)throw new Error(`Unknown filter: ${n.name}`);e=a(e.data,n.options),i.push({name:n.name,time:Date.now()-t})}return{logs:i,data:e.data}}function filterMatrix(n,t){return{logs:[],data:{data:n}.data}}var Filters$1=Object.freeze({__proto__:null,filterXY:filterXY$1,filterMatrix:filterMatrix,centerMean:centerMean,centerMedian:centerMedian,fromTo:fromTo$1,normed:normed,divideBySD:divideBySD,rescale:rescale,paretoNormalization:paretoNormalization,airPLSBaseline:airPLSBaseline,iterativePolynomialBaseline:iterativePolynomialBaseline,rollingAverageBaseline:rollingAverageBaseline,rollingBallBaseline:rollingBallBaseline,rollingMedianBaseline:rollingMedianBaseline,firstDerivative:firstDerivative,secondDerivative:secondDerivative,thirdDerivative:thirdDerivative,savitzkyGolay:savitzkyGolay,ensureGrowing:ensureGrowing,equallySpaced:equallySpaced,filterX:filterX,calibrateX:calibrateX,xFunction:xFunction,yFunction:yFunction});const id$g="signalProcessing",name$g="Signal processing",DOMAIN_UPDATE_RULES$g={updateXDomain:!0,updateYDomain:!0};function apply$h(n,t){if(!isApplicable$g(n))throw new Error("Signal Processing is not applicable on this data");n.data=filterXY(n,t)}function isApplicable$g(n){return!!n.info.isFt}function reduce$g(n,t){return{once:!0,reduce:t}}function filterXY(n,t){let e=n.data.x.slice(0);const i=n.data.x.slice(0);let a=n.data.re.slice(0),s=n.data.im?.slice(0);const r=t.filters.slice(),{range:{from:o,to:f},numberOfPoints:l,exclusionsZones:d}=t;r.push({name:"equallySpaced",options:{from:o,to:f,numberOfPoints:l,exclusions:d},properties:{}});for(const n of r){const t=Filters$1[n.name];if(!t)throw new Error(`Unknown filter: ${n.name}`);const r=n?.options||{},o=t({x:e,y:a},r);if(e=o.data.x,a=o.data.y,s){s=t({x:i,y:s},r).data.y}}return{x:e,re:a,im:s}}var signalProcessing=Object.freeze({__proto__:null,id:id$g,name:name$g,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$g,apply:apply$h,isApplicable:isApplicable$g,reduce:reduce$g,filterXY:filterXY});function zeroFilling$1(n,t){const{re:e,im:i}=n,{factor:a=2,pointsToShift:s=0,nbPoints:r=2**Math.round(Math.log2(e.length*a))}=t,o=new Float64Array(r),f=new Float64Array(r),l=Math.min(r,e.length);return o.set(e.slice(0,l-s)),f.set(i.slice(0,l-s)),s>0&&s<r&&(o.set(e.slice(e.length-s),r-s),f.set(i.slice(e.length-s),r-s)),{re:o,im:f}}const id$f="zeroFilling",name$f="Zero Filling",DOMAIN_UPDATE_RULES$f={updateXDomain:!0,updateYDomain:!1};function apply$g(n,t){if(!isApplicable$f(n))throw new Error("zeroFilling not applicable on this data");const{factor:e=2,nbPoints:i=2**Math.round(Math.log2(n.data.x.length*e))}=t;if(!t.nbPoints){const t=n.filters.find((n=>n.name===id$f));t&&(t.value={nbPoints:i})}const a=n.filters?.find((n=>"digitalFilter"===n.name&&n.flag)),s=a?Math.floor(a.value.digitalFilterValue):0,{re:r,im:o}=zeroFilling$1(n.data,{pointsToShift:s,nbPoints:i}),f=new Float64Array(i),l=Math.min(i,n.data.re.length),{x:d}=n.data;f.set(d.slice(0,l-s));const g=d[1]-d[0];let u=d[l-s-1];for(let n=l-s;n<i;n++)u+=g,f[n]=u;n.data={...n.data,re:r,im:o,x:f}}function isApplicable$f(n){return!(!n.info?.isComplex||!n.info?.isFid)}function reduce$f(n,t){return delete t.factor,{once:!0,reduce:t}}var zeroFilling=Object.freeze({__proto__:null,id:id$f,name:name$f,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$f,apply:apply$g,isApplicable:isApplicable$f,reduce:reduce$f});const Filters1D={apodization:apodization,backwardLinearPrediction:backwardLinearPrediction,forwardLinearPrediction:forwardLinearPrediction,exclusionZones:exclusionZones,signalProcessing:signalProcessing,baselineCorrection:baselineCorrection,digitalFilter:digitalFilter$1,equallySpaced:equallySpaced$1,fft:fft,phaseCorrection:phaseCorrection$1,shiftX:shiftX,zeroFilling:zeroFilling},id$e="apodizationDimension1",name$e="Apodization on Dimension 1",DOMAIN_UPDATE_RULES$e={updateXDomain:!0,updateYDomain:!0};function apply$f(n,t={}){if(!isApplicable$e(n))throw new Error("Apodization on dimension 1 is not applicable on this data");const{data:{re:e,im:i}}=n,{z:a,minX:s,maxX:r}=e,o=i.z,f=a.length,l=[],d=[],g=(r-s)/(a[0].length-1),{compose:u}=t;if(!u)return;const c=n.filters.find((n=>"digitalFilter"===n.name&&n.flag)),b=c?Math.floor(c.value.digitalFilterValue):0,h=compose(ensureComposeOptions({re:a[0],im:o[0],x:[s,s+g]},u));for(let n=0;n<f;n++){const{re:e,im:i}=apodization$1({re:a[n].slice(),im:o[n].slice()},{...t,pointsToShift:b,windowData:h});l.push(e),d.push(i)}const D=matrixMinMaxZ(l),H=matrixMinMaxZ(d),j={re:{...e,z:l,minZ:D.min,maxZ:D.max},im:{...i,z:d,minZ:H.min,maxZ:H.max}};Object.assign(n.data,j)}function isApplicable$e(n){return!(!n.info.isComplex||!n.info.isFid)}function reduce$e(){return{once:!0,reduce:void 0}}var apodizationDimension1=Object.freeze({__proto__:null,id:id$e,name:name$e,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$e,apply:apply$f,isApplicable:isApplicable$e,reduce:reduce$e});function getColumn(n,t){const e=new Float64Array(n.length);for(let i=0;i<n.length;i++)e[i]=n[i][t];return e}function setColumn(n,t,e){for(let i=0;i<n.length;i++)n[i][e]=t[i];return n}const id$d="apodizationDimension2",name$d="Apodization on Dimension 2",DOMAIN_UPDATE_RULES$d={updateXDomain:!0,updateYDomain:!0};function apply$e(n,t={}){if(!isApplicable$d(n))throw new Error("Apodization on dimension 2 is not applicable on this data");const{data:{re:e,im:i}}=n,{z:a,minY:s,maxY:r}=e,o=i.z,f=a.length,l=a[0].length,d=matrixCreateEmpty({nbRows:f,nbColumns:l,ArrayConstructor:Float64Array}),g=matrixCreateEmpty({nbRows:f,nbColumns:l,ArrayConstructor:Float64Array}),{compose:u}=t;if(!u)return;const c=n.filters.find((n=>"digitalFilter"===n.name&&n.flag)),b=c?Math.floor(c.value.digitalFilterValue):0,h=(r-s)/(a.length-1),D=compose(ensureComposeOptions({re:getColumn(a,0),im:getColumn(o,0),x:[s,s+h]},u));for(let n=0;n<l;n++){const{re:e,im:i}=apodization$1({re:getColumn(a,n),im:getColumn(o,n),x:[s,s+h]},{...t,pointsToShift:b,windowData:D});setColumn(d,e,n),setColumn(g,i,n)}const H=matrixMinMaxZ(d),j=matrixMinMaxZ(g),m={re:{...e,z:d,minZ:H.min,maxZ:H.max},im:{...i,z:g,minZ:j.min,maxZ:j.max}};Object.assign(n.data,m)}function isApplicable$d(n){return!(!n.info.isComplex||!n.info.isFid)}function reduce$d(){return{once:!0,reduce:void 0}}var apodizationDimension2=Object.freeze({__proto__:null,id:id$d,name:name$d,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$d,apply:apply$e,isApplicable:isApplicable$d,reduce:reduce$d});const id$c="blpDimension1",name$c="Backward-LP Dimension 1",DOMAIN_UPDATE_RULES$c={updateXDomain:!0,updateYDomain:!0};function apply$d(n,t={}){if(!isApplicable$c(n))throw new Error("Backward Linear Prediction on dimension 1 is not applicable on this data");const{data:{re:e,im:i},info:a}=n,s=e.z,r=i.z,o=s.length,f=s[0].length,l=[],d=[],{lpNumberOfCoefficients:g=[15,15],tdOff:u=[0,0]}=a,{nbCoefficients:c=g[0],nbPoints:b=u[0]/2,nbInputs:h=Math.floor(f-(b<0?0:b)-c)}=t;if(0===b||0===c)return;const D=n.filters.find((n=>n.name===id$c));D&&(D.value={nbCoefficients:c,nbPoints:b,nbInputs:h});for(let n=0;n<o;n++){const{re:t,im:e}=reimBackwardLinearPrediction({re:s[n],im:r[n]},{nbInputs:h,nbPoints:b,nbCoefficients:c});l.push(t),d.push(e)}const H=matrixMinMaxZ(l),j=matrixMinMaxZ(d),m={re:{...e,z:l,minZ:H.min,maxZ:H.max},im:{...i,z:d,minZ:j.min,maxZ:j.max}};if(b<0){const n=s[0].length,{minX:t,maxX:i}=e,a=(i-t)/(n-1);m.re.maxX=i+a*Math.abs(b)}Object.assign(n.data,m)}function isApplicable$c(n){return!(!n.info.isComplex||!n.info.isFid)}function reduce$c(){return{once:!0,reduce:void 0}}var blpDimension1=Object.freeze({__proto__:null,id:id$c,name:name$c,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$c,apply:apply$d,isApplicable:isApplicable$c,reduce:reduce$c});const id$b="blpDimension2",name$b="Backward-LP Dimension 2",DOMAIN_UPDATE_RULES$b={updateXDomain:!0,updateYDomain:!0};function apply$c(n,t={}){if(!isApplicable$b(n))throw new Error("Backward Linear Prediction on dimension 2 is not applicable on this data");const{info:e,data:{re:i,im:a}}=n,s=i.z,r=a.z,o=s.length,f=s[0].length,{lpNumberOfCoefficients:l=[15,15],tdOff:d=[0,0]}=e,{nbCoefficients:g=l[1],nbPoints:u=d[1]/2,nbInputs:c=Math.floor(o-g-(u<0?0:u))}=t;if(0===u||0===g)return;const b=n.filters.find((n=>n.name===id$b));b&&(b.value={nbCoefficients:g,nbPoints:u,nbInputs:c});const h=u<0?-1*u:0,D=matrixCreateEmpty({nbRows:o+h,nbColumns:f}),H=matrixCreateEmpty({nbRows:o+h,nbColumns:f});for(let n=0;n<f;n++){const{re:t,im:e}=reimBackwardLinearPrediction({re:getColumn(s,n),im:getColumn(r,n)},{nbInputs:c,nbPoints:u,nbCoefficients:g});setColumn(D,t,n),setColumn(H,e,n)}const j=matrixMinMaxZ(D),m=matrixMinMaxZ(H),A={re:{...i,z:D,minZ:j.min,maxZ:j.max},im:{...a,z:H,minZ:m.min,maxZ:m.max}};if(u<0){const{minY:n,maxY:t}=i,e=t+(t-n)/(o-1)*h;A.re.maxY=e,A.im.maxY=e}Object.assign(n.data,A)}function isApplicable$b(n){return!(!n.info.isComplex||!n.info.isFid)}function reduce$b(){return{once:!0,reduce:void 0}}var blpDimension2=Object.freeze({__proto__:null,id:id$b,name:name$b,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$b,apply:apply$c,isApplicable:isApplicable$b,reduce:reduce$b});function digitalFilter(n,t){const{digitalFilterValue:e=0}=t,i=new Float64Array(n.re),a=new Float64Array(n.im);let s=Math.floor(e);s+=0;const r=new Float64Array(i.length),o=new Float64Array(a.length);return r.set(i.slice(s)),r.set(i.slice(0,s),i.length-s),o.set(a.slice(s)),o.set(a.slice(0,s),a.length-s),{re:r,im:o}}const id$a="digitalFilter2D",name$a="Digital filter on Dimension 1",DOMAIN_UPDATE_RULES$a={updateXDomain:!1,updateYDomain:!1};function apply$b(n,t={}){if(!isApplicable$a(n))throw new Error("Digital filter on dimension 1 is not applicable on this data");const{data:{re:e,im:i}}=n,a=e.z,s=i.z,r=a.length,o=[],f=[],{digitalFilterValue:l}=t;if(!l||0===l)return;const d=n.filters.find((n=>n.name===id$a));d&&(d.value={digitalFilterValue:l});for(let n=0;n<r;n++){const{re:t,im:e}=digitalFilter({re:a[n],im:s[n]},{digitalFilterValue:l});o.push(t),f.push(e)}Object.assign(n.data.re,{z:o}),Object.assign(n.data.im,{z:f})}function isApplicable$a(n){return!(!n.info.isComplex||!n.info.isFid)}function reduce$a(){return{once:!0,reduce:void 0}}var digitalFilter2D=Object.freeze({__proto__:null,id:id$a,name:name$a,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$a,apply:apply$b,isApplicable:isApplicable$a,reduce:reduce$a});function removeDCOffset(n,t={}){const{digitalFilterValue:e=0}=t,i=n.re.length,a=new Float64Array(n.re),s=new Float64Array(n.im),r=xMean(n.re.slice(.75*i|0,i-e)),o=xMean(n.im.slice(.75*i|0,i-e));for(let n=e;n<i-e;n++)a[n]-=r,s[n]-=o;return{re:a,im:s}}function fftDirectDimension(n,t={}){const{re:e,im:i}=n,a=e.length,s=e[0].length,{reverse:r,digitalFilterValue:o=0}=t,f=new Matrix(a,s),l=new Matrix(a,s),{phaseCorrection:d={}}=t,{ph0:g,ph1:u,mode:c="no"}=d;for(let n=0;n<a;n++){const t={re:e[n],im:r?xMultiply(i[n],-1):i[n]};Object.assign(t,removeDCOffset(t,{digitalFilterValue:o})),Object.assign(t,reimFFT(t,{applyZeroShift:!0}));const a=o*Math.PI*2;a>0&&Object.assign(t,reimPhaseCorrection(t,0,-a,{reverse:!0})),"pk"===c&&void 0!==g&&void 0!==u&&Object.assign(t,reimPhaseCorrection(t,g*Math.PI/180,u*Math.PI/180,{reverse:!0})),f.setRow(n,t.re),l.setRow(n,t.im)}return{re:f,im:l}}function echoQuadrature(n){const{re:{z:t},im:{z:e}}=n,i=[],a=[];for(let n=0;n<t.length;n+=2){const s=t[n],r=e[n],o=t[n+1],f=e[n+1];i.push(xSubtract(xMultiply(f,-1),r)),i.push(xSubtract(o,s)),a.push(xAdd(o,s)),a.push(xSubtract(f,r))}return{re:i,im:a}}const id$9="fftDimension1",name$9="FFT Dimension 1",DOMAIN_UPDATE_RULES$9={updateXDomain:!0,updateYDomain:!0};function apply$a(n,t){if(!isApplicable$9(n))throw new Error("fft dimension 1 not applicable on this data");const{data:e,info:i}=n,{digitalFilter:a=0,reverse:s=[!1,!1]}=i,r=i.acquisitionScheme.toLowerCase();if(e.re.z.length!==e.im.z.length||e.re.z[0].length!==e.im.z[0].length)throw new RangeError("real and imaginary data must have the same dimensionality");const o=fftDirectDimension("echo-antiecho"===r?echoQuadrature(e):{re:e.re.z,im:e.im.z},{acquisitionScheme:r,...t,reverse:s[0],digitalFilterValue:a});n.data.re.z=o.re.to2DArray().map(xEnsureFloat64),n.data.im.z=o.im.to2DArray().map(xEnsureFloat64)}function isApplicable$9(n){return!(!n.info.isComplex||!n.info.isFid)}function reduce$9(){return{once:!0,reduce:void 0}}var fftDimension1=Object.freeze({__proto__:null,id:id$9,name:name$9,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$9,apply:apply$a,isApplicable:isApplicable$9,reduce:reduce$9});function fftIndirectDimension(n,t){const e={re:Matrix.checkMatrix(n.re),im:Matrix.checkMatrix(n.im)},i=e.re.rows,a=e.re.columns,{acquisitionScheme:s,reverse:r}=t,o={...t},f={};if("notPhaseSensitive"===s){const n=new Matrix(i,a),t=new Matrix(i,a);for(let i=0;i<a;i++){const a={re:e.re.getColumn(i),im:r||"notPhaseSensitive"===s?xMultiply(e.im.getColumn(i),-1):e.im.getColumn(i)};a.re[0]*=.5,a.im[0]*=.5;const{re:f,im:l}=applyFFT(a,o);n.setColumn(i,f),t.setColumn(i,l)}f.rr=n,f.ir=t}else for(const n in e){const t="SEQ"===s?i:i/2,l=new Matrix(t,a),d=new Matrix(t,a);for(let t=0;t<a;t++){const i=getColumnFrom(e[n],{acquisitionScheme:s,index:t,reverse:r});i.re[0]*=.5,i.im[0]*=.5;const{re:a,im:f}=applyFFT(i,o);l.setColumn(t,a),d.setColumn(t,f)}"re"===n?(f.rr=l,f.ri=d):(f.ir=l,f.ii=d)}return f}function applyFFT(n,t){const{acquisitionScheme:e,phaseCorrection:i={}}=t;n.re[0]*=.5,n.im[0]*=.5;const a=reimFFT(n,{applyZeroShift:"SEQ"!==e}),{mode:s,ph0:r,ph1:o}=i;return(s&&"mc"===s||"notPhaseSensitive"===e)&&Object.assign(a,{re:reimAbsolute(a),im:new Float64Array(n.re.length)}),"pk"===s&&void 0!==r&&void 0!==o&&Object.assign(a,reimPhaseCorrection(a,r*Math.PI/180,o*Math.PI/180)),a}function getColumnFrom(n,t){const{index:e}=t,i=(t.acquisitionScheme||"").toLocaleLowerCase();if("seq"===i)return{re:n.getColumn(e),im:new Float64Array(n.rows)};const a=n.rows/2,s=new Float64Array(a),r=new Float64Array(a);if(t.reverse||"notphasesensitive"===i)for(let t=0;t<a;t++)s[t]=n.get(2*t,e),r[t]=-n.get(2*t+1,e);else for(let t=0;t<a;t++)s[t]=n.get(2*t,e),r[t]=n.get(2*t+1,e);if(["states-tppi","tppi"].some((n=>i===n)))for(let n=0;n<a;n+=2)s[n]*=-1,r[n]*=-1;return{re:s,im:r}}function getMinMaxXY(n){const t=[],e=[];for(let i=0;i<n.baseFrequency.length;i++){const a=n.baseFrequency[i],s=n.frequencyOffset[i],r=n.spectralWidth[i],o=s/a;t.push(o-.5*r),e.push(o+.5*r)}return{minX:t[0],maxX:e[0],minY:t[1],maxY:e[1]}}const id$8="fftDimension2",name$8="FFT Dimension 2",DOMAIN_UPDATE_RULES$8={updateXDomain:!0,updateYDomain:!0};function apply$9(n,t){if(!isApplicable$8(n))throw new Error("fft dimension 2 not applicable on this data");const{data:e,info:i}=n,a=i.acquisitionScheme;if(e.re.z.length!==e.im.z.length||e.re.z[0].length!==e.im.z[0].length)throw new RangeError("real and imaginary data must have the same dimensionality");const s={re:e.re.z,im:e.im.z},{reverse:r=[!1,!1]}=i,o=fftIndirectDimension({re:s.re,im:s.im},{reverse:r[1],acquisitionScheme:a,...t});n.data={...getQuadrants(o,i)};const{isFid:f,isComplex:l,...d}=i;n.info={...d,isFt:!0}}function getQuadrants(n,t){const e={},{acquisitionScheme:i}=t,a=getMinMaxXY(t),s=t=>{for(const i of t){const t=Object.values(n[i])[0],{min:s,max:r}=matrixMinMaxZ(t);e[i]={z:t,maxZ:r,minZ:s,...a}}return e};return s("notPhaseSensitive"===i?["rr","ir"]:["rr","ir","ri","ii"])}function isApplicable$8(n){return!(!n.info.isComplex||!n.info.isFid)}function reduce$8(){return{once:!0,reduce:void 0}}var fftDimension2=Object.freeze({__proto__:null,id:id$8,name:name$8,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$8,apply:apply$9,isApplicable:isApplicable$8,reduce:reduce$8});const id$7="flpDimension1",name$7="Fordward-LP Dimension 1",DOMAIN_UPDATE_RULES$7={updateXDomain:!0,updateYDomain:!0};function apply$8(n,t={}){if(!isApplicable$7(n))throw new Error("Forward Linear Prediction on dimension 1 is not applicable on this data");const{info:e,data:{re:i,im:a}}=n,s=i.z,r=a.z,o=s.length,f=s[0].length,l=[],d=[],{lpNumberOfCoefficients:g=[0,0],linearPredictionBin:u=[0,0],spectrumSize:c=[f,o],numberOfPoints:b=[f,o]}=e,{nbPoints:h=getNbPredictedPoints(c[0],b[0],u[0])/-2,nbCoefficients:D=g[0],nbInputs:H=Math.floor(f-D-(h<0?0:h))}=t,j=n.filters.find((n=>n.name===id$7));if(j&&(j.value={nbCoefficients:D,nbPoints:h,nbInputs:H}),0===Math.abs(h)||0===D)return;for(let n=0;n<o;n++){const{re:t,im:e}=reimForwardLinearPrediction({re:s[n].slice(),im:r[n].slice()},{nbCoefficients:D,nbInputs:H,nbPoints:h});l.push(t),d.push(e)}const m=matrixMinMaxZ(l),A=matrixMinMaxZ(d),C={re:{...i,z:l,minZ:m.min,maxZ:m.max},im:{...a,z:d,minZ:A.min,maxZ:A.max}};if(h<0){const{minX:n,maxX:t}=i,e=(t-n)/(f-1);C.re.maxX=t+e*Math.abs(h)}Object.assign(n.data,C)}function isApplicable$7(n){return!(!n.info.isComplex||!n.info.isFid)}function reduce$7(){return{once:!0,reduce:void 0}}var flpDimension1=Object.freeze({__proto__:null,id:id$7,name:name$7,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$7,apply:apply$8,isApplicable:isApplicable$7,reduce:reduce$7});const id$6="flpDimension2",name$6="Fordward-LP Dimension 2",DOMAIN_UPDATE_RULES$6={updateXDomain:!0,updateYDomain:!0};function apply$7(n,t={}){if(!isApplicable$6(n))throw new Error("Forward Linear Prediction on dimension 2 is not applicable on this data");const{info:e,data:{re:i,im:a}}=n,s=i.z,r=a.z,o=s.length,f=s[0].length,{lpNumberOfCoefficients:l=[0,0],linearPredictionBin:d=[0,0],spectrumSize:g=[f,o],numberOfPoints:u=[f,o]}=e,{nbPoints:c=getNbPredictedPoints(g[1],u[1],d[1])/-2,nbCoefficients:b=l[1],nbInputs:h=Math.floor(o-b-(c<0?0:c))}=t,D=n.filters.find((n=>n.name===id$6));if(D&&(D.value={nbCoefficients:b,nbPoints:c,nbInputs:h}),0===Math.abs(c)||0===b)return;const H=c<0?-1*c:0,j=matrixCreateEmpty({nbRows:o+H,nbColumns:f}),m=matrixCreateEmpty({nbRows:o+H,nbColumns:f});for(let n=0;n<f;n++){const{re:t,im:e}=reimForwardLinearPrediction({re:getColumn(s,n),im:getColumn(r,n)},{nbPoints:c,nbCoefficients:b,nbInputs:h});setColumn(j,t,n),setColumn(m,e,n)}const A=matrixMinMaxZ(j),C=matrixMinMaxZ(m),p={re:{...i,z:j,minZ:A.min,maxZ:A.max},im:{...a,z:m,minZ:C.min,maxZ:C.max}};Object.assign(n.data,p)}function isApplicable$6(n){return!(!n.info.isComplex||!n.info.isFid)}function reduce$6(){return{once:!0,reduce:void 0}}var flpDimension2=Object.freeze({__proto__:null,id:id$6,name:name$6,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$6,apply:apply$7,isApplicable:isApplicable$6,reduce:reduce$6}),binarySearch=function(n,t,e,i,a){var s,r;if(void 0===i)i=0;else if((i|=0)<0||i>=n.length)throw new RangeError("invalid lower bound");if(void 0===a)a=n.length-1;else if((a|=0)<i||a>=n.length)throw new RangeError("invalid upper bound");for(;i<=a;)if((r=+e(n[s=i+(a-i>>>1)],t,s,n))<0)i=s+1;else{if(!(r>0))return s;a=s-1}return~i},binarySearch$1=binarySearch,numSort={};function assertNumber$2(n){if("number"!=typeof n)throw new TypeError("Expected a number")}var ascending=numSort.ascending=(n,t)=>(assertNumber$2(n),assertNumber$2(t),Number.isNaN(n)?-1:Number.isNaN(t)?1:n-t);numSort.descending=(n,t)=>(assertNumber$2(n),assertNumber$2(t),Number.isNaN(n)?1:Number.isNaN(t)?-1:t-n);const largestPrime=2147483647,primeNumbers=[largestPrime,5,11,23,47,97,197,397,797,1597,3203,6421,12853,25717,51437,102877,205759,411527,823117,1646237,3292489,6584983,13169977,26339969,52679969,105359939,210719881,421439783,842879579,1685759167,433,877,1759,3527,7057,14143,28289,56591,113189,226379,452759,905551,1811107,3622219,7244441,14488931,28977863,57955739,115911563,231823147,463646329,927292699,1854585413,953,1907,3821,7643,15287,30577,61169,122347,244703,489407,978821,1957651,3915341,7830701,15661423,31322867,62645741,125291483,250582987,501165979,1002331963,2004663929,1039,2081,4177,8363,16729,33461,66923,133853,267713,535481,1070981,2141977,4283963,8567929,17135863,34271747,68543509,137087021,274174111,548348231,1096696463,31,67,137,277,557,1117,2237,4481,8963,17929,35863,71741,143483,286973,573953,1147921,2295859,4591721,9183457,18366923,36733847,73467739,146935499,293871013,587742049,1175484103,599,1201,2411,4831,9677,19373,38747,77509,155027,310081,620171,1240361,2480729,4961459,9922933,19845871,39691759,79383533,158767069,317534141,635068283,1270136683,311,631,1277,2557,5119,10243,20507,41017,82037,164089,328213,656429,1312867,2625761,5251529,10503061,21006137,42012281,84024581,168049163,336098327,672196673,1344393353,3,7,17,37,79,163,331,673,1361,2729,5471,10949,21911,43853,87719,175447,350899,701819,1403641,2807303,5614657,11229331,22458671,44917381,89834777,179669557,359339171,718678369,1437356741,43,89,179,359,719,1439,2879,5779,11579,23159,46327,92657,185323,370661,741337,1482707,2965421,5930887,11861791,23723597,47447201,94894427,189788857,379577741,759155483,1518310967,379,761,1523,3049,6101,12203,24407,48817,97649,195311,390647,781301,1562611,3125257,6250537,12501169,25002389,50004791,100009607,200019221,400038451,800076929,1600153859,13,29,59,127,257,521,1049,2099,4201,8419,16843,33703,67409,134837,269683,539389,1078787,2157587,4315183,8630387,17260781,34521589,69043189,138086407,276172823,552345671,1104691373,19,41,83,167,337,677,1361,2729,5471,10949,21911,43853,87719,175447,350899,701819,1403641,2807303,5614657,11229331,22458671,44917381,89834777,179669557,359339171,718678369,1437356741,53,107,223,449,907,1823,3659,7321,14653,29311,58631,117269,234539,469099,938207,1876417,3752839,7505681,15011389,30022781,60045577,120091177,240182359,480364727,960729461,1921458943];function nextPrime(n){let t=binarySearch$1(primeNumbers,n,ascending);return t<0&&(t=~t),primeNumbers[t]}primeNumbers.sort(ascending);const FREE=0,FULL=1,REMOVED=2,defaultInitialCapacity=150,defaultMinLoadFactor=1/6,defaultMaxLoadFactor=2/3;class HashTable{constructor(n={}){if(n instanceof HashTable)return this.table=n.table.slice(),this.values=n.values.slice(),this.state=n.state.slice(),this.minLoadFactor=n.minLoadFactor,this.maxLoadFactor=n.maxLoadFactor,this.distinct=n.distinct,this.freeEntries=n.freeEntries,this.lowWaterMark=n.lowWaterMark,void(this.highWaterMark=n.maxLoadFactor);const t=void 0===n.initialCapacity?defaultInitialCapacity:n.initialCapacity;if(t<0)throw new RangeError(`initial capacity must not be less than zero: ${t}`);const e=void 0===n.minLoadFactor?defaultMinLoadFactor:n.minLoadFactor,i=void 0===n.maxLoadFactor?defaultMaxLoadFactor:n.maxLoadFactor;if(e<0||e>=1)throw new RangeError(`invalid minLoadFactor: ${e}`);if(i<=0||i>=1)throw new RangeError(`invalid maxLoadFactor: ${i}`);if(e>=i)throw new RangeError(`minLoadFactor (${e}) must be smaller than maxLoadFactor (${i})`);let a=t;a=a/i|0,a=nextPrime(a),0===a&&(a=1),this.table=newArray(a),this.values=newArray(a),this.state=newArray(a),this.minLoadFactor=e,this.maxLoadFactor=a===largestPrime?1:i,this.distinct=0,this.freeEntries=a,this.lowWaterMark=0,this.highWaterMark=chooseHighWaterMark(a,this.maxLoadFactor)}clone(){return new HashTable(this)}get size(){return this.distinct}get(n){const t=this.indexOfKey(n);return t<0?0:this.values[t]}set(n,t){let e=this.indexOfInsertion(n);if(e<0)return e=-e-1,this.values[e]=t,!1;if(this.distinct>this.highWaterMark){const e=chooseGrowCapacity(this.distinct+1,this.minLoadFactor,this.maxLoadFactor);return this.rehash(e),this.set(n,t)}if(this.table[e]=n,this.values[e]=t,this.state[e]===FREE&&this.freeEntries--,this.state[e]=FULL,this.distinct++,this.freeEntries<1){const n=chooseGrowCapacity(this.distinct+1,this.minLoadFactor,this.maxLoadFactor);this.rehash(n)}return!0}remove(n,t){const e=this.indexOfKey(n);return!(e<0)&&(this.state[e]=REMOVED,this.distinct--,t||this.maybeShrinkCapacity(),!0)}delete(n,t){const e=this.indexOfKey(n);return!(e<0)&&(this.state[e]=FREE,this.distinct--,t||this.maybeShrinkCapacity(),!0)}maybeShrinkCapacity(){if(this.distinct<this.lowWaterMark){const n=chooseShrinkCapacity(this.distinct,this.minLoadFactor,this.maxLoadFactor);this.rehash(n)}}containsKey(n){return this.indexOfKey(n)>=0}indexOfKey(n){const t=this.table,e=this.state,i=this.table.length,a=2147483647&n;let s=a%i,r=a%(i-2);for(0===r&&(r=1);e[s]!==FREE&&(e[s]===REMOVED||t[s]!==n);)s-=r,s<0&&(s+=i);return e[s]===FREE?-1:s}containsValue(n){return this.indexOfValue(n)>=0}indexOfValue(n){const t=this.values,e=this.state;for(var i=0;i<e.length;i++)if(e[i]===FULL&&t[i]===n)return i;return-1}indexOfInsertion(n){const t=this.table,e=this.state,i=t.length,a=2147483647&n;let s=a%i,r=a%(i-2);for(0===r&&(r=1);e[s]===FULL&&t[s]!==n;)s-=r,s<0&&(s+=i);if(e[s]===REMOVED){const a=s;for(;e[s]!==FREE&&(e[s]===REMOVED||t[s]!==n);)s-=r,s<0&&(s+=i);e[s]===FREE&&(s=a)}return e[s]===FULL?-s-1:s}ensureCapacity(n){if(this.table.length<n){const t=nextPrime(n);this.rehash(t)}}rehash(n){const t=this.table.length;if(n<=this.distinct)throw new Error("Unexpected");const e=this.table,i=this.values,a=this.state,s=newArray(n),r=newArray(n),o=newArray(n);this.lowWaterMark=chooseLowWaterMark(n,this.minLoadFactor),this.highWaterMark=chooseHighWaterMark(n,this.maxLoadFactor),this.table=s,this.values=r,this.state=o,this.freeEntries=n-this.distinct;for(var f=0;f<t;f++)if(a[f]===FULL){var l=e[f],d=this.indexOfInsertion(l);s[d]=l,r[d]=i[f],o[d]=FULL}}forEachKey(n){for(var t=0;t<this.state.length;t++)if(this.state[t]===FULL&&!n(this.table[t]))return!1;return!0}forEachValue(n){for(var t=0;t<this.state.length;t++)if(this.state[t]===FULL&&!n(this.values[t]))return!1;return!0}forEachPair(n){for(var t=0;t<this.state.length;t++)if(this.state[t]===FULL&&!n(this.table[t],this.values[t]))return!1;return!0}}function chooseLowWaterMark(n,t){return n*t|0}function chooseHighWaterMark(n,t){return Math.min(n-2,n*t|0)}function chooseGrowCapacity(n,t,e){return nextPrime(Math.max(n+1,4*n/(3*t+e)|0))}function chooseShrinkCapacity(n,t,e){return nextPrime(Math.max(n+1,4*n/(t+3*e)|0))}function newArray(n){return Array(n).fill(0)}class SparseMatrix{constructor(n,t,e={}){if(n instanceof SparseMatrix){const t=n;this._init(t.rows,t.columns,t.elements.clone(),t.threshold)}else if(Array.isArray(n)){const i=n;n=i.length,e=t||{},t=i[0].length,this._init(n,t,new HashTable(e),e.threshold);for(let e=0;e<n;e++)for(let n=0;n<t;n++){let a=i[e][n];this.threshold&&Math.abs(a)<this.threshold&&(a=0),0!==a&&this.elements.set(e*t+n,i[e][n])}}else this._init(n,t,new HashTable(e),e.threshold)}_init(n,t,e,i){this.rows=n,this.columns=t,this.elements=e,this.threshold=i||0}static eye(n=1,t=n){const e=Math.min(n,t),i=new SparseMatrix(n,t,{initialCapacity:e});for(let n=0;n<e;n++)i.set(n,n,1);return i}clone(){return new SparseMatrix(this)}to2DArray(){const n=new Array(this.rows);for(let t=0;t<this.rows;t++){n[t]=new Array(this.columns);for(let e=0;e<this.columns;e++)n[t][e]=this.get(t,e)}return n}isSquare(){return this.rows===this.columns}isSymmetric(){if(!this.isSquare())return!1;let n=!0;return this.forEachNonZero(((t,e,i)=>this.get(e,t)!==i?(n=!1,!1):i)),n}bandWidth(){let n=this.columns,t=-1;return this.forEachNonZero(((e,i,a)=>{let s=e-i;return n=Math.min(n,s),t=Math.max(t,s),a})),t-n}isBanded(n){return this.bandWidth()<=n}get cardinality(){return this.elements.size}get size(){return this.rows*this.columns}get(n,t){return this.elements.get(n*this.columns+t)}set(n,t,e){return this.threshold&&Math.abs(e)<this.threshold&&(e=0),0===e?this.elements.remove(n*this.columns+t):this.elements.set(n*this.columns+t,e),this}mmul(n){this.columns!==n.rows&&console.warn("Number of columns of left matrix are not equal to number of rows of right matrix.");const t=this.rows,e=n.columns,i=new SparseMatrix(t,e);return this.forEachNonZero(((t,e,a)=>(n.forEachNonZero(((n,s,r)=>(e===n&&i.set(t,s,i.get(t,s)+a*r),r))),a))),i}kroneckerProduct(n){const t=this.rows,e=this.columns,i=n.rows,a=n.columns,s=new SparseMatrix(t*i,e*a,{initialCapacity:this.cardinality*n.cardinality});return this.forEachNonZero(((t,e,r)=>(n.forEachNonZero(((n,o,f)=>(s.set(i*t+n,a*e+o,r*f),f))),r))),s}forEachNonZero(n){return this.elements.forEachPair(((t,e)=>{const i=t/this.columns|0,a=t%this.columns;let s=n(i,a,e);return!1!==s&&(this.threshold&&Math.abs(s)<this.threshold&&(s=0),s!==e&&(0===s?this.elements.remove(t,!0):this.elements.set(t,s)),!0)})),this.elements.maybeShrinkCapacity(),this}getNonZeros(){const n=this.cardinality,t=new Array(n),e=new Array(n),i=new Array(n);let a=0;return this.forEachNonZero(((n,s,r)=>(t[a]=n,e[a]=s,i[a]=r,a++,r))),{rows:t,columns:e,values:i}}setThreshold(n){return 0!==n&&n!==this.threshold&&(this.threshold=n,this.forEachNonZero(((n,t,e)=>e))),this}transpose(){let n=new SparseMatrix(this.columns,this.rows,{initialCapacity:this.cardinality});return this.forEachNonZero(((t,e,i)=>(n.set(e,t,i),i))),n}isEmpty(){return 0===this.rows||0===this.columns}}SparseMatrix.prototype.klass="Matrix",SparseMatrix.identity=SparseMatrix.eye,SparseMatrix.prototype.tensorProduct=SparseMatrix.prototype.kroneckerProduct;let inplaceOperator="\n(function %name%(value) {\n    if (typeof value === 'number') return this.%name%S(value);\n    return this.%name%M(value);\n})\n",inplaceOperatorScalar="\n(function %name%S(value) {\n    this.forEachNonZero((i, j, v) => v %op% value);\n    return this;\n})\n",inplaceOperatorMatrix="\n(function %name%M(matrix) {\n    matrix.forEachNonZero((i, j, v) => {\n        this.set(i, j, this.get(i, j) %op% v);\n        return v;\n    });\n    return this;\n})\n",staticOperator="\n(function %name%(matrix, value) {\n    var newMatrix = new SparseMatrix(matrix);\n    return newMatrix.%name%(value);\n})\n",inplaceMethod="\n(function %name%() {\n    this.forEachNonZero((i, j, v) => %method%(v));\n    return this;\n})\n",staticMethod="\n(function %name%(matrix) {\n    var newMatrix = new SparseMatrix(matrix);\n    return newMatrix.%name%();\n})\n";const operators=[["+","add"],["-","sub","subtract"],["*","mul","multiply"],["/","div","divide"],["%","mod","modulus"],["&","and"],["|","or"],["^","xor"],["<<","leftShift"],[">>","signPropagatingRightShift"],[">>>","rightShift","zeroFillRightShift"]];for(const operator of operators)for(let i=1;i<operator.length;i++)SparseMatrix.prototype[operator[i]]=eval(fillTemplateFunction(inplaceOperator,{name:operator[i],op:operator[0]})),SparseMatrix.prototype[`${operator[i]}S`]=eval(fillTemplateFunction(inplaceOperatorScalar,{name:`${operator[i]}S`,op:operator[0]})),SparseMatrix.prototype[`${operator[i]}M`]=eval(fillTemplateFunction(inplaceOperatorMatrix,{name:`${operator[i]}M`,op:operator[0]})),SparseMatrix[operator[i]]=eval(fillTemplateFunction(staticOperator,{name:operator[i]}));let methods=[["~","not"]];["abs","acos","acosh","asin","asinh","atan","atanh","cbrt","ceil","clz32","cos","cosh","exp","expm1","floor","fround","log","log1p","log10","log2","round","sign","sin","sinh","sqrt","tan","tanh","trunc"].forEach((function(n){methods.push([`Math.${n}`,n])}));for(const method of methods)for(let i=1;i<method.length;i++)SparseMatrix.prototype[method[i]]=eval(fillTemplateFunction(inplaceMethod,{name:method[i],method:method[0]})),SparseMatrix[method[i]]=eval(fillTemplateFunction(staticMethod,{name:method[i]}));function fillTemplateFunction(n,t){for(const e in t)n=n.replace(new RegExp(`%${e}%`,"g"),t[e]);return n}function checkNmrData2DFourQuad(n){if(["rr","ir","ri","ii"].some((t=>!(t in n))))throw new Error("four quadrants should has ir, ri and ii quadrants")}function checkNmrData2DRrRi(n){if(["rr","ri"].some((t=>!(t in n))))throw new Error("Two quadrants should has ri quadrant")}function getZMinMax(n){return{z:n.to2DArray().map(xEnsureFloat64),maxZ:n.max(),minZ:n.min()}}function genericPhaseCorrection(n,t){const{applyPhaseCorrection:e,keys:{re:i,im:a}}=t,s=e({re:Matrix$1.checkMatrix(n[i]?.z||[[]]),im:Matrix$1.checkMatrix(n[a]?.z||[[]])},t),r={};return r[i]={...n[i],...getZMinMax(s.re)},r[a]={...n[a],...getZMinMax(s.im)},{...n,...r}}function xyzPhaseCorrectionHorizontal(n,t){checkNmrData2DRrRi(n);const e=genericPhaseCorrection(n,{...t,applyPhaseCorrection:applyPhaseCorrection$1,keys:{re:"rr",im:"ir"}});return"ri"in e&&"ii"in e?(checkNmrData2DFourQuad(e),genericPhaseCorrection(e,{...t,applyPhaseCorrection:applyPhaseCorrection$1,keys:{re:"ri",im:"ii"}})):e}function applyPhaseCorrection$1(n,t){const e=t.ph0*degreeToRadians,i=t.ph1*degreeToRadians,a=n.re.rows;for(let t=0;t<a;t++){const{re:a,im:s}=reimPhaseCorrection({re:n.re.getRow(t),im:n.im.getRow(t)},e,i);n.re.setRow(t,a),n.im.setRow(t,s)}return n}function xyzAutoPhaseCorrection(n,t={}){checkNmrData2DRrRi(n);const e=autoPhase({re:n.rr.z,im:n.ir.z},t),i=xyzPhaseCorrectionHorizontal(n,e);checkNmrData2DFourQuad(i);return{horizontal:e,vertical:autoPhase({re:i.rr.z,im:i.ri.z},{transpose:!0,...t})}}function autoPhase(n,t={}){const{absolute:e,phases:i,threshold:a,nonZeros:s}=calculateAbsoluteAndPhases(n,t),r=getObjectiveFunction$1(e,i,a),{columns:o,rows:f,values:l}=s,d=xMaxIndex(l);return findZeroAndFirstOrders(r,{pivot:{x:o[d],y:f[d]},absolute:e,phases:i,threshold:a})}function findZeroAndFirstOrders(n,t){let e=-30,i=30,a=8,s=Number.MAX_SAFE_INTEGER,r=Number.MAX_SAFE_INTEGER;const{pivot:o,absolute:f}=t,{x:l}=o,{columns:d}=f;let g=0;const u=findZeroOrder(t);for(;a>0&&g!==s;){s=g;for(let t=e;t<=i+1;t+=30){const e=n([u-t*l/d,t]);e<r&&([r,g]=[e,t])}e=u+30*Math.sign(u),i=e,a--}e=g-30,i=g+30;for(a=5,s=Number.MAX_SAFE_INTEGER;a>0;){s=g;const t=(i-e)/4;for(let a=e;a<=i+1;a+=t){const t=n([u-a*l/d,a]);t<r&&([r,g]=[t,a])}e=g-t,i=g+t,a--}return{ph0:u-g*l/d,ph1:g}}function findZeroOrder(n){const{pivot:t,absolute:e,phases:i,threshold:a}=n,{rows:s,columns:r}=e,o=new SparseMatrix(s,r,{threshold:0}),f=new SparseMatrix(s,r,{threshold:0}),{x:l,y:d}=t;for(let n=d-40;n<d+40;n++)for(let t=l-40;t<l+40;t++)o.set(n,t,e.get(n,t)),f.set(n,t,i.get(n,t));const g=getObjectiveFunction$1(o,f,a);let u=-15,c=15,b=12,h=0,D=Number.MAX_SAFE_INTEGER,H=Number.MAX_SAFE_INTEGER;for(;b>0&&h!==D;){D=h;for(let n=u;n<c+1;n+=15){const t=g([n,0]);t<=H&&([H,h]=[t,n])}u=h+15*Math.sign(h),c=u,b--}u=h-15,c=h+15;for(b=5;b>0;){const n=(c-u)/4;for(let t=u;t<=c;t+=n){const n=g([t,0]);n<H&&([H,h]=[n,t])}u=h-n,c=h+n,b--}const j=e.get(d,l),m=i.get(d,l);return j*Math.cos(m+h*degreeToRadians)<0?h-180*Math.sign(h):h}function calculateAbsoluteAndPhases(n,t={}){const{re:e,im:i}=n,{transpose:a=!1}=t,s=a?new MatrixTransposeView(new Matrix$1(e)):new Matrix$1(e),r=a?new MatrixTransposeView(new Matrix$1(i)):new Matrix$1(i),{rows:o,columns:f}=s,l=matrixCreateEmpty({nbRows:o,nbColumns:f});for(let n=0;n<o;n++)for(let t=0;t<f;t++)l[n][t]=computeAbs(s.get(n,t),r.get(n,t));const{threshold:d=2*new WrapperMatrix2D(l).mean()}=t,g=new SparseMatrix(l,{threshold:d}),u=new SparseMatrix(g.rows,g.columns,{threshold:-1}),c=g.getNonZeros(),{columns:b,rows:h}=c;for(let n=0;n<h.length;n++){const[t,e]=[h[n],b[n]];u.set(t,e,Math.atan2(r.get(t,e),s.get(t,e)))}return{absolute:g,phases:u,threshold:d,nonZeros:c}}function computeAbs(n,t){return Math.sqrt(n*n+t*t)}function getObjectiveFunction$1(n,t,e){const i=n.columns;return a=>{const[s,r]=[...a];let o=0;return n.forEachNonZero(((n,a,f)=>{const l=s+a*r/i,d=f*Math.cos(t.get(n,a)+l*degreeToRadians);return(d>=e||d<=-e)&&(o+=1),f})),o}}function xyzPhaseCorrectionVertical(n,t){checkNmrData2DFourQuad(n);const{quad:e}=t;return genericPhaseCorrection(n,"imag"===e?{...t,applyPhaseCorrection:applyPhaseCorrection,keys:{re:"ir",im:"ii"}}:{...t,applyPhaseCorrection:applyPhaseCorrection,keys:{re:"rr",im:"ri"}})}function applyPhaseCorrection(n,t){const e=t.ph0*degreeToRadians,i=t.ph1*degreeToRadians,a=n.re.columns;for(let t=0;t<a;t++){const{re:a,im:s}=reimPhaseCorrection({re:n.re.getColumn(t),im:n.im.getColumn(t)},e,i);n.re.setColumn(t,a),n.im.setColumn(t,s)}return n}function xyzPhaseCorrection(n,t){let e=n;const{horizontal:i,vertical:a}=t;return checkOption(i)&&(e=xyzPhaseCorrectionHorizontal(e,i)),checkOption(a)&&(e=xyzPhaseCorrectionVertical(e,a),e=xyzPhaseCorrectionVertical(e,{...a,quad:"imag"})),e}function checkOption(n){return!!n&&(0!==n?.ph0||0!==n?.ph1)}const id$5="phaseCorrectionTwoDimensions",name$5="Phase correction",DOMAIN_UPDATE_RULES$5={updateXDomain:!1,updateYDomain:!1};function apply$6(n,t){if(!isApplicable$5(n,t))throw new Error("phase correction is not applicable to raw data");const{data:e}=n;if("horizontal"in t||"vertical"in t)n.data={...e,...xyzPhaseCorrection(e,t)};else{const i=xyzAutoPhaseCorrection(e,t.automatic);n.data={...e,...xyzPhaseCorrection(e,i)};const a=n.filters?.find((n=>n.name===id$5));a&&(a.value={...a.value,...i})}}function isApplicable$5(n,t){const{horizontal:e,vertical:i}=t;if(e&&i)return["rr","ir","ri","ii"].every((t=>t in n.data));if(e)return["rr","ri"].every((t=>!(t in n.data)));if(i){const{quad:t}=i;return"imag"===t?["ir","ii"].every((t=>t in n.data)):["rr","ir"].every((t=>t in n.data))}return["rr","ir","ri","ii"].every((t=>t in n.data))}function reduce$5(n,t){return{once:!0,reduce:t}}var phaseCorrectionTwoDimensions=Object.freeze({__proto__:null,id:id$5,name:name$5,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$5,apply:apply$6,isApplicable:isApplicable$5,reduce:reduce$5});const id$4="shift2DX",name$4="Shift 2D X",DOMAIN_UPDATE_RULES$4={updateXDomain:!0,updateYDomain:!1};function apply$5(n,t){const{shift:e}=t,i={...n.data};for(const n in i)i[n].minX+=e,i[n].maxX+=e}function isApplicable$4(){return!0}function reduce$4(n,t){const{shift:e=0}=n,{shift:i}=t;return{once:!0,reduce:{shift:e+i}}}var shift2DX=Object.freeze({__proto__:null,id:id$4,name:name$4,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$4,apply:apply$5,isApplicable:isApplicable$4,reduce:reduce$4});const id$3="shift2DY",name$3="Shift 2D Y",DOMAIN_UPDATE_RULES$3={updateXDomain:!1,updateYDomain:!0};function apply$4(n,t){const{shift:e}=t,i={...n.data};for(const n in i)i[n].minY+=e,i[n].maxY+=e}function isApplicable$3(){return!0}function reduce$3(n,t){const{shift:e=0}=n,{shift:i}=t;return{once:!0,reduce:{shift:e+i}}}var shift2DY=Object.freeze({__proto__:null,id:id$3,name:name$3,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$3,apply:apply$4,isApplicable:isApplicable$3,reduce:reduce$3});const id$2="symmetrizeCosyLike",name$2="symmetrize COSY-like",DOMAIN_UPDATE_RULES$2={updateXDomain:!0,updateYDomain:!0};function apply$3(n){if(!isApplicable$2(n))throw new Error("symmetrization is only applicable to square matrices and FT data");const t={...n.data},e=symmetrizeCosyLike(t.rr.z),i=matrixMinMaxZ(e);n.data={rr:{...t.rr,z:e,minZ:i.min,maxZ:i.max}},n.info.isComplex=!1}function isApplicable$2(n){if(n.info.isFt&&"rr"in n.data){const t=n.data.rr.z;return t[0].length===t.length}return!1}function reduce$2(){return{once:!0,reduce:void 0}}const getAbs=Math.abs;function symmetrizeCosyLike(n){const t=n.length,e=n[0].length;for(let i=0;i<t;i++)for(let t=i;t<e;t++){const e=Math.min(getAbs(n[i][t]),getAbs(n[t][i]));n[i][t]=e,n[t][i]=e}return n}var symmetrizeCosyLike$1=Object.freeze({__proto__:null,id:id$2,name:name$2,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$2,apply:apply$3,isApplicable:isApplicable$2,reduce:reduce$2});const id$1="zeroFillingDimension1",name$1="Zero filling on Dimension 1",DOMAIN_UPDATE_RULES$1={updateXDomain:!0,updateYDomain:!0};function apply$2(n,t={}){if(!isApplicable$1(n))throw new Error("Zero filling on dimension 1 is not applicable on this data");const{data:{re:e,im:i}}=n,{z:a}=e,s=i.z,r=a.length,o=a[0].length,f=[],l=[],{factor:d=2,nbPoints:g=2**Math.round(Math.log2(o*d))}=t,u=n.filters.find((n=>n.name===id$1));u&&(u.value={nbPoints:g});const c=n.filters.find((n=>"digitalFilter"===n.name&&n.flag)),b=c?Math.floor(c.value.digitalFilterValue):0;for(let n=0;n<r;n++){const{re:e,im:i}=zeroFilling$1({re:a[n].slice(),im:s[n].slice()},{...t,pointsToShift:b});f.push(e),l.push(i)}const h=matrixMinMaxZ(f),D=matrixMinMaxZ(l),H={re:{...e,z:f,minZ:h.min,maxZ:h.max},im:{...i,z:l,minZ:D.min,maxZ:D.max}},{minX:j,maxX:m}=e,A=j+(m-j)/(o-1)*g;H.re.maxX=A,H.im.maxX=A,Object.assign(n.data,H)}function isApplicable$1(n){return!(!n.info.isComplex||!n.info.isFid)}function reduce$1(){return{once:!0,reduce:void 0}}var zeroFillingDimension1=Object.freeze({__proto__:null,id:id$1,name:name$1,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES$1,apply:apply$2,isApplicable:isApplicable$1,reduce:reduce$1});const id="zeroFillingDimension2",name="Zero filling on Dimension 2",DOMAIN_UPDATE_RULES={updateXDomain:!0,updateYDomain:!0};function apply$1(n,t={}){if(!isApplicable(n))throw new Error("Zero filling on dimension 2 is not applicable on this data");const{data:{re:e,im:i}}=n,a=e.z,s=i.z,r=a.length,o=a[0].length,{factor:f=2,nbPoints:l=2**Math.round(Math.log2(r*f))}=t,d=n.filters.find((n=>n.name===id));d&&(d.value={nbPoints:l});const g=n.filters.find((n=>"digitalFilter"===n.name&&n.flag)),u=g?Math.floor(g.value.digitalFilterValue):0,c=matrixCreateEmpty({nbRows:l,nbColumns:o}),b=matrixCreateEmpty({nbRows:l,nbColumns:o});for(let n=0;n<o;n++){const{re:t,im:e}=zeroFilling$1({re:getColumn(a,n),im:getColumn(s,n)},{nbPoints:l,pointsToShift:u});setColumn(c,t,n),setColumn(b,e,n)}const h=matrixMinMaxZ(c),D=matrixMinMaxZ(b),H={re:{...e,z:c,minZ:h.min,maxZ:h.max},im:{...i,z:b,minZ:D.min,maxZ:D.max}},{minY:j,maxY:m}=e,A=j+(m-j)/(r-1)*(l-1);H.re.maxY=A,H.im.maxY=A,Object.assign(n.data,H)}function isApplicable(n){return!(!n.info.isComplex||!n.info.isFid)}function reduce(){return{once:!0,reduce:void 0}}var zeroFillingDimension2=Object.freeze({__proto__:null,id:id,name:name,DOMAIN_UPDATE_RULES:DOMAIN_UPDATE_RULES,apply:apply$1,isApplicable:isApplicable,reduce:reduce});const Filters2D={zeroFillingDimension1:zeroFillingDimension1,zeroFillingDimension2:zeroFillingDimension2,apodizationDimension1:apodizationDimension1,apodizationDimension2:apodizationDimension2,phaseCorrectionTwoDimensions:phaseCorrectionTwoDimensions,digitalFilter2D:digitalFilter2D,fftDimension1:fftDimension1,fftDimension2:fftDimension2,blpDimension1:blpDimension1,blpDimension2:blpDimension2,flpDimension1:flpDimension1,flpDimension2:flpDimension2,symmetrizeCosyLike:symmetrizeCosyLike$1,shift2DX:shift2DX,shift2DY:shift2DY},Filters={...Filters1D,...Filters2D};function getShiftX(n){const t=n?.filters?.find((n=>n.name===Filters1D.shiftX.id));return t?.flag?t.value.shift:0}function getRange$1(n,t,e){const{originalFrom:i,originalTo:a,from:s,to:r}=n;return"origin"===t?{originalFrom:s-e,originalTo:r-e,from:s,to:r}:{originalFrom:i,originalTo:a,from:i+e,to:a+e}}function mapIntegrals(n,t,e="origin"){const{x:i,re:a}=t.data,s=getShiftX(t);return n.map((n=>{const t=getRange$1(n,e,s),r=xyIntegration({x:i,y:a},{from:t.from,to:t.to});return{...n,id:n.id||v4(),...t,absolute:r}}))}function getSum(n,t,e=null){let i=0;for(const a of n)if(e?.(a)){const n=a[t];if(!n||"number"!=typeof n)continue;i+=Math.abs(n)}return i}const SignalKinds=[{label:"Signal",value:"signal"},{label:"Reference",value:"reference"},{label:"Solvent",value:"solvent"},{label:"Impurity",value:"impurity"},{label:"Standard",value:"standard"},{label:"P1",value:"p1"},{label:"P2",value:"p2"},{label:"P3",value:"p3"}],SignalKindsToInclude=["signal"],DatumKind={signal:"signal",mixed:"mixed"};function checkIntegralKind(n){return SignalKindsToInclude.includes(n.kind)}function mapValues(n,t,e,i){return n.map((n=>({...n,...i(n)&&{[t]:n.absolute*e}})))}function updateIntegralsRelativeValues(n,t=!1){const{values:e,options:i}=n.integrals,a=getSum(e,"absolute",checkIntegralKind);let s=0;if(i?.sum)if(i.isSumConstant||t)s=a>0?i.sum/a:0;else if(e?.[0]){const n=e[0];s=(n.integral||i.sum)/n.absolute}n.integrals.values=mapValues(e,"integral",s,checkIntegralKind),i?.isSumConstant||t||(i.sum=getSum(n.integrals.values,"integral",checkIntegralKind))}function updateIntegrals(n){n.integrals.values=mapIntegrals(n.integrals.values,n,"current"),updateIntegralsRelativeValues(n,!0)}function get1DErrorFactor(n){const{x:t}=n.data;return(t[t.length-1]-t[0])/1e4}function isExists(n,t,e){for(const{x:i}of t.peaks?.values||[])if(Math.abs(n.x-i)<e)return!0;return!1}function getPeakDelta(n,t,e){const{originalX:i=0,x:a}=n;return"origin"===t?{originalX:a-e,x:a}:{originalX:i,x:i+e}}function mapPeaks(n,t,e={}){const{checkIsExisting:i=!0,shiftTarget:a="origin"}=e,s=getShiftX(t),r=get1DErrorFactor(t),o=[];for(const e of n){const n=getPeakDelta(e,a,s);(!i||i&&!isExists(e,t,r))&&o.push({...e,id:e?.id||v4(),...n})}return o}function updatePeaks(n){n.peaks.values=mapPeaks(n.peaks.values,n,{checkIsExisting:!1,shiftTarget:"current"})}const MultiplicityPatterns=[{label:"singlet",value:"s",multiplicity:1,names:["br s","br. s"]},{label:"doublet",value:"d",multiplicity:2,names:["br d"]},{label:"triplet",value:"t",multiplicity:3,names:[]},{label:"quartet",value:"q",multiplicity:4,names:[]},{label:"quintet",value:"i",acs:"quint",multiplicity:5,names:["quint","qui","qnt","pentet","pnt","pent"]},{label:"sextet",value:"h",multiplicity:6,names:["x","sxt","sext","hexuplet"]},{label:"septet",value:"p",acs:"sept",multiplicity:7,names:["sept","spt","heptet","hpt","hept"]},{label:"octet",value:"o",multiplicity:8,names:["oct"]},{label:"nonet",value:"n",multiplicity:9,names:["non"]},{label:"massive",value:"m",multiplicity:null,names:[]}],result={};for(const{value:n,multiplicity:t,names:e}of MultiplicityPatterns){t&&(result[n]=t-1);for(const n of e)t&&(result[n]=t-1)}const couplingValues=result;function selectACSPattern(n){const t=couplingValues[n];if(!t)throw new Error(`multiplicity pattern ${n} is not supported`);return couplingACSPatterns[t]}function signalMultiplicityPattern(n,t){const e=n.js;let i="";if(e&&e.length>0)for(const n of e){const{multiplicity:e=""}=n;i+=t?.acsFormat?selectACSPattern(e):e}else i=n.delta?"":"m";return i}function isRangeExists(n,t,e){for(const{from:i,to:a}of t.ranges?.values||[])if(Math.abs(n.from-i)<e&&Math.abs(n.to-a)<e)return!0}function getRange(n,t,e){const{originalFrom:i,originalTo:a,from:s,to:r}=n;return"origin"===t?{originalFrom:s-e,originalTo:r-e,from:s,to:r}:{originalFrom:i,originalTo:a,from:(i||0)+e,to:(a||0)+e}}function getSignalDelta(n,t,e){const{delta:i,originalDelta:a}=n;return"origin"===t?{originalDelta:i-e,delta:i}:{originalDelta:a,delta:(a||0)+e}}function nmrRangeToRange(n){const{signals:t=[],integration:e=0,...i}=n,a=[];for(const n of t){const{multiplicity:t,...e}=n;a.push({id:v4(),js:[],multiplicity:t||signalMultiplicityPattern(n),...e})}return{id:v4(),integration:e,absolute:e||0,signals:a,...i}}function mapRanges(n,t,e={}){const{checkIsExisting:i=!0,shiftTarget:a="origin"}=e,{x:s,re:r}=t.data,o=getShiftX(t),f=get1DErrorFactor(t);let l=n.map(nmrRangeToRange);return i&&(l=l.filter((n=>i&&!isRangeExists(n,t,f)||"new"===n.id))),l.map((n=>{const t=getRange(n,a,o),e=xyIntegration({x:s,y:r},{from:t.from,to:t.to}),i=n.signals.map((n=>{const{kind:t=null,id:e,peaks:i=[],...s}=n,r=i.map((n=>{const t=getPeakDelta(n,a,o);return{id:n?.id||v4(),...n,...t}}));return{kind:t||"signal",id:e||v4(),peaks:r,...s,...getSignalDelta(n,a,o)}}));return{...n,id:n.id||v4(),kind:i?.length&&i[0].kind||DatumKind.signal,...t,absolute:e,signals:i}}))}var LARGE_ARRAY_SIZE$1=200,HASH_UNDEFINED$3="__lodash_hash_undefined__",INFINITY$2=1/0,MAX_SAFE_INTEGER$2=9007199254740991,argsTag$4="[object Arguments]",funcTag$3="[object Function]",genTag$2="[object GeneratorFunction]",symbolTag$4="[object Symbol]",reRegExpChar$1=/[\\^$.*+?()[\]{}|]/g,reIsHostCtor$1=/^\[object .+?Constructor\]$/,reIsUint$1=/^(?:0|[1-9]\d*)$/,freeGlobal$2="object"==typeof commonjsGlobal&&commonjsGlobal&&commonjsGlobal.Object===Object&&commonjsGlobal,freeSelf$1="object"==typeof self&&self&&self.Object===Object&&self,root$9=freeGlobal$2||freeSelf$1||Function("return this")();function apply(n,t,e){switch(e.length){case 0:return n.call(t);case 1:return n.call(t,e[0]);case 2:return n.call(t,e[0],e[1]);case 3:return n.call(t,e[0],e[1],e[2])}return n.apply(t,e)}function arrayIncludes(n,t){return!!(n?n.length:0)&&baseIndexOf(n,t,0)>-1}function arrayIncludesWith(n,t,e){for(var i=-1,a=n?n.length:0;++i<a;)if(e(t,n[i]))return!0;return!1}function arrayMap$2(n,t){for(var e=-1,i=n?n.length:0,a=Array(i);++e<i;)a[e]=t(n[e],e,n);return a}function arrayPush$3(n,t){for(var e=-1,i=t.length,a=n.length;++e<i;)n[a+e]=t[e];return n}function baseFindIndex(n,t,e,i){for(var a=n.length,s=e+(i?1:-1);i?s--:++s<a;)if(t(n[s],s,n))return s;return-1}function baseIndexOf(n,t,e){if(t!=t)return baseFindIndex(n,baseIsNaN,e);for(var i=e-1,a=n.length;++i<a;)if(n[i]===t)return i;return-1}function baseIsNaN(n){return n!=n}function baseTimes$2(n,t){for(var e=-1,i=Array(n);++e<n;)i[e]=t(e);return i}function baseUnary$4(n){return function(t){return n(t)}}function cacheHas$2(n,t){return n.has(t)}function getValue$2(n,t){return null==n?void 0:n[t]}function isHostObject(n){var t=!1;if(null!=n&&"function"!=typeof n.toString)try{t=!!(n+"")}catch(n){}return t}function overArg$3(n,t){return function(e){return n(t(e))}}var arrayProto$1=Array.prototype,funcProto$2=Function.prototype,objectProto$f=Object.prototype,coreJsData$2=root$9["__core-js_shared__"],maskSrcKey$1=(uid=/[^.]+$/.exec(coreJsData$2&&coreJsData$2.keys&&coreJsData$2.keys.IE_PROTO||""),uid?"Symbol(src)_1."+uid:""),uid,funcToString$2=funcProto$2.toString,hasOwnProperty$c=objectProto$f.hasOwnProperty,objectToString$2=objectProto$f.toString,reIsNative$1=RegExp("^"+funcToString$2.call(hasOwnProperty$c).replace(reRegExpChar$1,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$"),Symbol$7=root$9.Symbol,getPrototype$3=overArg$3(Object.getPrototypeOf,Object),propertyIsEnumerable$2=objectProto$f.propertyIsEnumerable,splice$1=arrayProto$1.splice,spreadableSymbol=Symbol$7?Symbol$7.isConcatSpreadable:void 0,nativeGetSymbols$2=Object.getOwnPropertySymbols,nativeMax=Math.max,Map$5=getNative$8(root$9,"Map"),nativeCreate$5=getNative$8(Object,"create");function Hash$2(n){var t=-1,e=n?n.length:0;for(this.clear();++t<e;){var i=n[t];this.set(i[0],i[1])}}function hashClear$2(){this.__data__=nativeCreate$5?nativeCreate$5(null):{}}function hashDelete$2(n){return this.has(n)&&delete this.__data__[n]}function hashGet$2(n){var t=this.__data__;if(nativeCreate$5){var e=t[n];return e===HASH_UNDEFINED$3?void 0:e}return hasOwnProperty$c.call(t,n)?t[n]:void 0}function hashHas$2(n){var t=this.__data__;return nativeCreate$5?void 0!==t[n]:hasOwnProperty$c.call(t,n)}function hashSet$2(n,t){return this.__data__[n]=nativeCreate$5&&void 0===t?HASH_UNDEFINED$3:t,this}function ListCache$5(n){var t=-1,e=n?n.length:0;for(this.clear();++t<e;){var i=n[t];this.set(i[0],i[1])}}function listCacheClear$2(){this.__data__=[]}function listCacheDelete$2(n){var t=this.__data__,e=assocIndexOf$5(t,n);return!(e<0)&&(e==t.length-1?t.pop():splice$1.call(t,e,1),!0)}function listCacheGet$2(n){var t=this.__data__,e=assocIndexOf$5(t,n);return e<0?void 0:t[e][1]}function listCacheHas$2(n){return assocIndexOf$5(this.__data__,n)>-1}function listCacheSet$2(n,t){var e=this.__data__,i=assocIndexOf$5(e,n);return i<0?e.push([n,t]):e[i][1]=t,this}function MapCache$4(n){var t=-1,e=n?n.length:0;for(this.clear();++t<e;){var i=n[t];this.set(i[0],i[1])}}function mapCacheClear$2(){this.__data__={hash:new Hash$2,map:new(Map$5||ListCache$5),string:new Hash$2}}function mapCacheDelete$2(n){return getMapData$5(this,n).delete(n)}function mapCacheGet$2(n){return getMapData$5(this,n).get(n)}function mapCacheHas$2(n){return getMapData$5(this,n).has(n)}function mapCacheSet$2(n,t){return getMapData$5(this,n).set(n,t),this}function SetCache$2(n){var t=-1,e=n?n.length:0;for(this.__data__=new MapCache$4;++t<e;)this.add(n[t])}function setCacheAdd$2(n){return this.__data__.set(n,HASH_UNDEFINED$3),this}function setCacheHas$2(n){return this.__data__.has(n)}function arrayLikeKeys$3(n,t){var e=isArray$8(n)||isArguments$2(n)?baseTimes$2(n.length,String):[],i=e.length,a=!!i;for(var s in n)!t&&!hasOwnProperty$c.call(n,s)||a&&("length"==s||isIndex$2(s,i))||e.push(s);return e}function assocIndexOf$5(n,t){for(var e=n.length;e--;)if(eq$4(n[e][0],t))return e;return-1}function baseDifference(n,t,e,i){var a=-1,s=arrayIncludes,r=!0,o=n.length,f=[],l=t.length;if(!o)return f;e&&(t=arrayMap$2(t,baseUnary$4(e))),i?(s=arrayIncludesWith,r=!1):t.length>=LARGE_ARRAY_SIZE$1&&(s=cacheHas$2,r=!1,t=new SetCache$2(t));n:for(;++a<o;){var d=n[a],g=e?e(d):d;if(d=i||0!==d?d:0,r&&g==g){for(var u=l;u--;)if(t[u]===g)continue n;f.push(d)}else s(t,g,i)||f.push(d)}return f}function baseFlatten(n,t,e,i,a){var s=-1,r=n.length;for(e||(e=isFlattenable),a||(a=[]);++s<r;){var o=n[s];t>0&&e(o)?t>1?baseFlatten(o,t-1,e,i,a):arrayPush$3(a,o):i||(a[a.length]=o)}return a}function baseGetAllKeys$3(n,t,e){var i=t(n);return isArray$8(n)?i:arrayPush$3(i,e(n))}function baseIsNative$2(n){return!(!isObject$6(n)||isMasked$2(n))&&(isFunction$3(n)||isHostObject(n)?reIsNative$1:reIsHostCtor$1).test(toSource$3(n))}function baseKeysIn$2(n){if(!isObject$6(n))return nativeKeysIn$2(n);var t=isPrototype$4(n),e=[];for(var i in n)("constructor"!=i||!t&&hasOwnProperty$c.call(n,i))&&e.push(i);return e}function basePick(n,t){return basePickBy(n=Object(n),t,(function(t,e){return e in n}))}function basePickBy(n,t,e){for(var i=-1,a=t.length,s={};++i<a;){var r=t[i],o=n[r];e(o,r)&&(s[r]=o)}return s}function baseRest(n,t){return t=nativeMax(void 0===t?n.length-1:t,0),function(){for(var e=arguments,i=-1,a=nativeMax(e.length-t,0),s=Array(a);++i<a;)s[i]=e[t+i];i=-1;for(var r=Array(t+1);++i<t;)r[i]=e[i];return r[t]=s,apply(n,this,r)}}function getAllKeysIn$2(n){return baseGetAllKeys$3(n,keysIn$4,getSymbolsIn$3)}function getMapData$5(n,t){var e=n.__data__;return isKeyable$2(t)?e["string"==typeof t?"string":"hash"]:e.map}function getNative$8(n,t){var e=getValue$2(n,t);return baseIsNative$2(e)?e:void 0}Hash$2.prototype.clear=hashClear$2,Hash$2.prototype.delete=hashDelete$2,Hash$2.prototype.get=hashGet$2,Hash$2.prototype.has=hashHas$2,Hash$2.prototype.set=hashSet$2,ListCache$5.prototype.clear=listCacheClear$2,ListCache$5.prototype.delete=listCacheDelete$2,ListCache$5.prototype.get=listCacheGet$2,ListCache$5.prototype.has=listCacheHas$2,ListCache$5.prototype.set=listCacheSet$2,MapCache$4.prototype.clear=mapCacheClear$2,MapCache$4.prototype.delete=mapCacheDelete$2,MapCache$4.prototype.get=mapCacheGet$2,MapCache$4.prototype.has=mapCacheHas$2,MapCache$4.prototype.set=mapCacheSet$2,SetCache$2.prototype.add=SetCache$2.prototype.push=setCacheAdd$2,SetCache$2.prototype.has=setCacheHas$2;var getSymbols$4=nativeGetSymbols$2?overArg$3(nativeGetSymbols$2,Object):stubArray$3,getSymbolsIn$3=nativeGetSymbols$2?function(n){for(var t=[];n;)arrayPush$3(t,getSymbols$4(n)),n=getPrototype$3(n);return t}:stubArray$3;function isFlattenable(n){return isArray$8(n)||isArguments$2(n)||!!(spreadableSymbol&&n&&n[spreadableSymbol])}function isIndex$2(n,t){return!!(t=null==t?MAX_SAFE_INTEGER$2:t)&&("number"==typeof n||reIsUint$1.test(n))&&n>-1&&n%1==0&&n<t}function isKeyable$2(n){var t=typeof n;return"string"==t||"number"==t||"symbol"==t||"boolean"==t?"__proto__"!==n:null===n}function isMasked$2(n){return!!maskSrcKey$1&&maskSrcKey$1 in n}function isPrototype$4(n){var t=n&&n.constructor;return n===("function"==typeof t&&t.prototype||objectProto$f)}function nativeKeysIn$2(n){var t=[];if(null!=n)for(var e in Object(n))t.push(e);return t}function toKey$2(n){if("string"==typeof n||isSymbol$4(n))return n;var t=n+"";return"0"==t&&1/n==-INFINITY$2?"-0":t}function toSource$3(n){if(null!=n){try{return funcToString$2.call(n)}catch(n){}try{return n+""}catch(n){}}return""}function eq$4(n,t){return n===t||n!=n&&t!=t}function isArguments$2(n){return isArrayLikeObject(n)&&hasOwnProperty$c.call(n,"callee")&&(!propertyIsEnumerable$2.call(n,"callee")||objectToString$2.call(n)==argsTag$4)}var isArray$8=Array.isArray;function isArrayLike$3(n){return null!=n&&isLength$3(n.length)&&!isFunction$3(n)}function isArrayLikeObject(n){return isObjectLike$8(n)&&isArrayLike$3(n)}function isFunction$3(n){var t=isObject$6(n)?objectToString$2.call(n):"";return t==funcTag$3||t==genTag$2}function isLength$3(n){return"number"==typeof n&&n>-1&&n%1==0&&n<=MAX_SAFE_INTEGER$2}function isObject$6(n){var t=typeof n;return!!n&&("object"==t||"function"==t)}function isObjectLike$8(n){return!!n&&"object"==typeof n}function isSymbol$4(n){return"symbol"==typeof n||isObjectLike$8(n)&&objectToString$2.call(n)==symbolTag$4}function keysIn$4(n){return isArrayLike$3(n)?arrayLikeKeys$3(n,!0):baseKeysIn$2(n)}var omit=baseRest((function(n,t){return null==n?{}:(t=arrayMap$2(baseFlatten(t,1),toKey$2),basePick(n,baseDifference(getAllKeysIn$2(n),t)))}));function stubArray$3(){return[]}var lodash_omit=omit,omit$1=lodash_omit;function getDiaIDs(n){return[].concat(n.diaIDs||[],n.signals?n.signals.flatMap((n=>n.diaIDs||[])):[])}function getNbAtoms(n,t){if(void 0===t){let t=0;if(n.signals)for(const e of n.signals)t+=e.nbAtoms||0;return t}return n.signals[t].nbAtoms||0}function setNbAtoms(n,t){n.nbAtoms=getNbAtoms(n,t),0===n.nbAtoms&&delete n.nbAtoms}function resetDiaIDs(n){(n=omit$1(n,["diaIDs","nbAtoms"])).signals=n.signals.map((n=>omit$1(n,["diaIDs","nbAtoms"])))}function unlink(n,t={}){const{unlinkType:e="both",signalIndex:i=-1}=t;switch(e){case"both":resetDiaIDs(n);break;case"range":n=omit$1(n,["diaIDs","nbAtoms"]);break;case"signal":-1!==i&&(n.signals[i]=omit$1(n.signals[i],["diaIDs","nbAtoms"]))}return n}function addDefaultSignal(n){n.signals.push({id:v4(),multiplicity:"m",kind:"signal",js:[],delta:(n.to+n.from)/2})}function checkRangeKind$1(n){return n.kind===DatumKind.signal}function checkSignalKinds(n,t){return!n.signals.some((n=>void 0===n.kind||!t.includes(n.kind)))}var RangeUtilities=Object.freeze({__proto__:null,getDiaIDs:getDiaIDs,getNbAtoms:getNbAtoms,setNbAtoms:setNbAtoms,resetDiaIDs:resetDiaIDs,unlink:unlink,addDefaultSignal:addDefaultSignal,checkRangeKind:checkRangeKind$1,checkSignalKinds:checkSignalKinds});function checkRangeKind(n){return n.signals&&checkSignalKinds(n,SignalKindsToInclude)}function updateRangesRelativeValues(n,t=!1){const{values:e,options:i}=n.ranges,a=getSum(e,"absolute",checkRangeKind);let s=0;if(i?.sum)if(i.isSumConstant||t)s=a>0?i.sum/a:0;else if(e?.[0]){const n=e[0];s=(n.integration||i.sum)/n.absolute}n.ranges.values=mapValues(e,"integration",s,checkRangeKind),i?.isSumConstant||t||(i.sum=getSum(n.ranges.values,"integration",checkRangeKind))}function updateRanges(n){n.ranges.values=mapRanges(n.ranges.values,n,{checkIsExisting:!1,shiftTarget:"current"}),updateRangesRelativeValues(n,!0)}function get2DErrorFactor(n){const{data:t,info:e}=n,{minX:i,maxX:a,minY:s,maxY:r}=e.isFid?t.re:t.rr;return{x:Math.abs(a-i)/1e4,y:Math.abs(r-s)/1e4}}function getShift(n){const t={x:0,y:0};if(n?.filters)for(const e of n.filters)e.name===Filters.shift2DX.id&&(t.x=e?.flag?e.value.shift:0),e.name===Filters.shift2DY.id&&(t.y=e?.flag?e.value.shift:0);return t}function isZoneExists(n,t,e){const i=n.x||{from:0,to:0},a=n.y||{from:0,to:0};if(!t.zones?.values)return!1;for(const{x:n,y:s}of t.zones.values)if(Math.abs(i.from-n.from)<e.x&&Math.abs(i.to-n.to)<e.x&&Math.abs(a.from-s.from)<e.y&&Math.abs(a.to-s.to)<e.y)return!0;return!1}function getSignal(n,t,e){const{x:i,y:a}=n;return"origin"===t?{...n,x:{...i,originalDelta:i.delta-e.x},y:{...a,originalDelta:a.delta-e.y}}:{...n,x:{...i,delta:i.originalDelta+e.x},y:{...a,delta:a.originalDelta+e.y}}}function getZoneAxis(n,t,e){const{x:i,y:a}=n;return"origin"===t?{x:{...i,originalFrom:i.from-e.x,originalTo:i.to-e.x},y:{...a,originalFrom:a.from-e.y,originalTo:a.to-e.y}}:{x:{...i,from:(i?.originalFrom||0)+e.x,to:(i?.originalTo||0)+e.x},y:{...a,from:(a?.originalFrom||0)+e.y,to:(a?.originalTo||0)+e.y}}}function getPeak(n,t,e){const{x:i,y:a,originalX:s=0,originalY:r=0}=n;return"origin"===t?{...n,originalX:i-e.x,originalY:a-e.y}:{...n,x:s+e.x,y:r+e.y}}function mapZones(n,t,e={}){const{checkIsExisting:i=!0,shiftTarget:a="origin"}=e,s=getShift(t),r=get2DErrorFactor(t);let o=n;return i&&(o=n.filter((n=>!isZoneExists(n,t,r)))),o.map((n=>{n.x=n.x||{from:0,to:0},n.y=n.y||{from:0,to:0};const t=n.signals.map((n=>{const{id:t,kind:e}=n;let i;return n?.peaks&&(i=(n?.peaks||[]).map((n=>{const t=getPeak(n,a,s);return{...n,...t,id:n?.id||v4()}}))),{...getSignal(n,a,s),peaks:i,id:t||v4(),kind:e||"signal"}}));return{...n,id:n.id||v4(),...getZoneAxis(n,a,s),signals:t,kind:n.kind||DatumKind.signal}}))}function updateZones(n){n.zones.values=mapZones(n.zones.values,n,{checkIsExisting:!1,shiftTarget:"current"})}function resetDataToOrigin(n){n.data=1===n.info.dimension?cloneData1D(n.originalData):cloneData2D(n.originalData);const{originalInfo:t}=n;t&&(n.info={...t})}function updateData(n){1===n.info.dimension?(updatePeaks(n),updateRanges(n),updateIntegrals(n)):2===n.info.dimension&&updateZones(n)}function applyFilter(n,t=[],e={}){const{forceReapply:i=!1,filterIndex:a}=e;let s=!1;for(const e of t){const t={name:e.name,label:Filters[e.name].name,value:e.value},i=lookupForFilter(n,e.name),r=!("isDeleteAllow"in e)||e.isDeleteAllow;if(i){const o=Filters[e.name].reduce(i.value,t.value);o.once?(s||(s=!0),null!=o.reduce&&void 0!==o.reduce&&replaceFilter(n,i.id,o.reduce)):addFilter(n,t,{isDeleteAllow:r,filterIndex:a})}else addFilter(n,t,{isDeleteAllow:r,filterIndex:a})}if(i)reapplyFilters(n);else if(s)1===t.length&&isLastFilter(n,t[0].name)?Filters[t[0].name].apply(n,t[0].value):reapplyFilters(n);else for(const e of t)Filters[e.name].apply(n,e.value);updateData(n)}function isLastFilter(n,t){const e=n.filters.findIndex((n=>n.name===t));return n.filters.length===e+1}function lookupForFilter(n,t){return n.filters.find((n=>n.name===t))}function reapplyFilters(n,t){enableFilter(n,null,null,t||n.filters)}function enableFilter(n,t,e,i){n.filters=n.filters.slice(0),t&&(n.filters=n.filters.map((n=>({...n,flag:n.id===t?e:n.flag})))),resetDataToOrigin(n);const a=i||n.filters;for(let t=0;t<a.length;t++){const e=n.filters[t];if(delete e.error,e.flag)try{Filters[e.name].apply(n,e.value)}catch(i){n.filters[t]={...e,error:i.message}}}updateData(n)}function deleteFilter(n,t){const e=n.filters.find((n=>n.id===t));if(n.filters=n.filters.slice(0).filter((n=>t?n.id!==t:!n.isDeleteAllow)),e?.flag){resetDataToOrigin(n);for(let t=0;t<n.filters.length;t++){const e=n.filters[t];if(delete e.error,e.flag){const{name:i,value:a}=e;try{Filters[i].apply(n,a)}catch(i){n.filters[t]={...e,error:i.message}}}}updateData(n)}}function addFilter(n,t,e={}){const{filterIndex:i,isDeleteAllow:a=!0}=e,s={...t,id:v4(),flag:!0,isDeleteAllow:a};"number"==typeof i&&-1!==i?n.filters=[...n.filters.slice(0,i+1),s,...n.filters.slice(i+1)]:n.filters.push(s)}function replaceFilter(n,t,e){const i=n.filters.findIndex((n=>n.id===t));n.filters[i]={...n.filters[i],value:e}}var FiltersManager=Object.freeze({__proto__:null,applyFilter:applyFilter,lookupForFilter:lookupForFilter,reapplyFilters:reapplyFilters,enableFilter:enableFilter,deleteFilter:deleteFilter,addFilter:addFilter});const gyromagneticRatio={"1H":267522187.44,"2H":41065e3,"3H":285350800,"3He":-203789e3,"7Li":103962e3,"13C":67282840,"14N":19331e3,"15N":-27116e3,"17O":-36264e3,"19F":251662e3,"23Na":70761e3,"27Al":69763e3,"29Si":-5319e4,"31P":108291e3,"57Fe":8681e3,"63Cu":71118e3,"67Zn":16767e3,"129Xe":-73997e3,"195Pt":58385e3,"199Hg":48457916,"187Os":6192895,"183W":11282403,"125Te":-85108404,"123Te":-70590980,"119Sn":-100317e3,"117Sn":-95887900,"115Sn":-88013e3,"113Cd":-59609155,"111Cd":-56983131,"109Ag":-12518634,"77Se":51253857,"89Y":-13162791,"103Rh":-8468e3,"107Ag":-10889181,"203Tl":155393338,"205Tl":156921808,"207Pb":55804600};function getGyromagneticRatio(n){if(gyromagneticRatio[n])return gyromagneticRatio[n];if("proton"===(n=n.toLowerCase()))return gyromagneticRatio["1H"];const t=n.replace(/[^0-9]/g,"");if(!t)return null;for(const n in gyromagneticRatio)if(n.replace(/[^0-9]/g,"")===t)return gyromagneticRatio[n];return null}const impuritiesContent={cdcl3:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"ds",shift:7.26}],h2o:[{proton:"H2O",coupling:0,multiplicity:"bs",shift:1.56}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.1}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.17}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.1}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.36}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.28}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.19},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.22}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.98},{proton:"OHc",coupling:0,multiplicity:"s",shift:5.01},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.27},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.43}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.26}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.43}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.73}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.3}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.21},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.48}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.65},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.57},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.39}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.4},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.55}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.09},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3.02},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.94}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:8.02},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.96},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.88}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.62}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.71}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.25},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.72},{proton:"OH",coupling:5,multiplicity:"s,t",shift:1.32}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.05},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.12},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.26}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.14},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.46},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.06}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.76}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.86},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.26}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.26}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.65}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.49},{proton:"OH",coupling:0,multiplicity:"s",shift:1.09}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.33}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:7},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.27}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.22},{proton:"CH",coupling:6,multiplicity:"sep",shift:4.04}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.62},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.29},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.68}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.07}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.85},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.76}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.36},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.17},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.25}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.03},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.53}]},"(cd3)2co":{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:2.05}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:2.84}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.96}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.09}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.05}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.36}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.18}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.13},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.13}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.96},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.22},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.41}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:8.02}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.43}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.87}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.63}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.11},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.41}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.56},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.47},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.28}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.28},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.46}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.83}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.96},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.94},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.78}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.52}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.59}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.12},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.57},{proton:"OH",coupling:5,multiplicity:"s,t",shift:3.39}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.05},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.2}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.45},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.96}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.28}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.87},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.29}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.28}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.59}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.31},{proton:"OH",coupling:0,multiplicity:"s",shift:3.12}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.43}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.27}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.1},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.9}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.58},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.35},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.76}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.13}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.79},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.63}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.32},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.5},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.5}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.45}]},dmso:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"quint",shift:2.5}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:3.33}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.91}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.09}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.07}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.37}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.11},{proton:"OHc",coupling:0,multiplicity:"s",shift:4.19}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.11},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.08}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.87},{proton:"OHc",coupling:0,multiplicity:"s",shift:6.65},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.18},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.36}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:8.32}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.4}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.9}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.76}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.09},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.38}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.51},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.38},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.24}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.24},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.43}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.96},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.94},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.78}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.95},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.89},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.73}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.54}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.57}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.06},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.44},{proton:"OH",coupling:5,multiplicity:"s,t",shift:4.63}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.99},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.03},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.17}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.43},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.91}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.34}],"grease^f":[],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.86},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.25}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.53}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.16},{proton:"OH",coupling:0,multiplicity:"s",shift:4.01}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.42}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.27}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.04},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.78}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.58},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.39},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.79}],silicone_greasei:[],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.76},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.6}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.3},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.18},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.25}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.93},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.43}]},c6d6:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:7.16}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:.4}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.55}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.55}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.55}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.15}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.05},{proton:"OHc",coupling:0,multiplicity:"s",shift:1.55}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.07},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.04}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:7.05},{proton:"OHc",coupling:0,multiplicity:"s",shift:4.79},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.24},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.38}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:6.15}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.4}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:2.9}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:4.27}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.11},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.26}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.46},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.34},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.11}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.12},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.33}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.6},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.57},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.05}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.63},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.36},{proton:"CH3",coupling:0,multiplicity:"s",shift:1.86}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.68}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.35}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.34}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.65},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:3.89},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.92}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.58},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:1.81},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.85}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.41}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.92},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.36}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.89},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.24}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.4}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.07}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.94}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.86},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.23}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:.95},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.67}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.53},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:6.66},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:6.98}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.29}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.4},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.57}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.11},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.02},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.13}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.4}]},cd3cn:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:1.94}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:2.13}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.96}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.08}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.96}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.37}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.16},{proton:"OHc",coupling:0,multiplicity:"s",shift:2.18}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.14},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.13}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.97},{proton:"OHc",coupling:0,multiplicity:"s",shift:5.2},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.22},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.39}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.58}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.44}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.81}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.44}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.12},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.42}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.53},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.45},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.29}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.28},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.45}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.96},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.83}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.92},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.89},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.77}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.5}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.6}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.12},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.54},{proton:"OH",coupling:5,multiplicity:"s,t",shift:2.47}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.06},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.2}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.06},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.43},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.96}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.51}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.86},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.27}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.89},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.28}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.57}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.28},{proton:"OH",coupling:0,multiplicity:"s",shift:2.16}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.31}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.87},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.29}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.09},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.87}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.57},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.33},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.73}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.08}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.8},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.64}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.33},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.2},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.2}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.45}]},cd3od:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:3.31}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:4.87}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.99}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.15}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.03}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.33}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.4}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.15},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.2}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.92},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.21},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.4}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.9}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.45}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.78}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.49}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.18},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.49}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.61},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.58},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.35}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.35},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.52}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3.31},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.92}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.97},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.99},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.86}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.65}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.66}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.19},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.6}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.01},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.09},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.24}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.12},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.5},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.01}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.59}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.88},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.29}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.9},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.29}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.64}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.34}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.34}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.89},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.29}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.5},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.92}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.53},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.44},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.85}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.1}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.87},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.71}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.32},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.16},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.16}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.05},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.58}]},d2o:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:4.79}],h2o:[],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.08}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.22}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.06}],benzene:[],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.24}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.21},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.22}],bhtb:[],chloroform:[],cyclohexane:[],"1,2-dichloroethane":[],dichloromethane:[],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.17},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.56}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.67},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.61},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.37}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.37},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.6}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.08},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3.06},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.9}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.92},{proton:"CH3",coupling:0,multiplicity:"s",shift:3.01},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.85}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.71}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.75}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.17},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.65}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.14},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.24}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.19},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:3.18},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.26}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.65}],"grease^f":[],"n-hexane":[],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.61}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.34}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.4}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.9}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.17},{proton:"CH",coupling:6,multiplicity:"sep",shift:4.02}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.52},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.45},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.87}],silicone_greasei:[],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.88},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.74}],toluene:[],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.99},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.57}]}},impurities=impuritiesContent;MultiplicityPatterns.sort(((n,t)=>null!==n.multiplicity&&null!==t.multiplicity?n.multiplicity-t.multiplicity:Number.MAX_SAFE_INTEGER));const couplingPatterns=MultiplicityPatterns.map((n=>n.value)),couplingACSPatterns=MultiplicityPatterns.map((n=>n.acs||n.value)),toCheck=["solvent","h2o","tms"];function peaksFilterImpurities(n,t={}){const{error:e=.025,remove:i=!1}=t;if(t.solvent){let{solvent:a}=t;"(cd3)2so"===a&&(a="dmso"),"meod"===a&&(a="cd3od");const s=impurities[a];for(const t of toCheck){checkImpurity(n,s[t],{error:e,remove:i,name:t})}}return n}function checkImpurity(n,t,e){const{name:i,error:a,remove:s}=e;let r,o,f,l=t.length;for(;l--;)for(r=n.length;r--;)o=a+n[r].width,f=Math.abs(t[l].shift-n[r].x),f<o&&(s?n.splice(r,1):n[r].kind=i)}function addBaseline(n,t){if(!t)return n;const e=n.x,i=n.y;for(let n=0;n<e.length;n++)i[n]+=t(e[n]);return n}function addNoise(n,t={}){const{seed:e=0,distribution:i="normal",percent:a=1}=t,s=xMaxValue(n.y)*a/100,r=createRandomArray({distribution:i,seed:e,mean:0,standardDeviation:s,range:s,length:n.x.length});return n.y=xAdd(n.y,r),n}class SpectrumGenerator{constructor(n={}){const{from:t=0,to:e=1e3,nbPoints:i=10001,peakWidthFct:a,shape:s={kind:"gaussian",fwhm:5}}=n;this.from=t,this.to=e,this.nbPoints=i,this.interval=(this.to-this.from)/(this.nbPoints-1),this.peakWidthFct=a,this.maxPeakHeight=Number.MIN_SAFE_INTEGER,this.data={x:new Float64Array(this.nbPoints),y:new Float64Array(this.nbPoints)};const r=getShape1D(s);if(this.shape=r,assertNumber$1(this.from,"from"),assertNumber$1(this.to,"to"),assertInteger$1(this.nbPoints,"nbPoints"),this.to<=this.from)throw new RangeError("to option must be larger than from");if(this.peakWidthFct&&"function"!=typeof this.peakWidthFct)throw new TypeError("peakWidthFct option must be a function");this.reset()}addPeaks(n,t){if(!(Array.isArray(n)||"object"==typeof n&&void 0!==n.x&&void 0!==n.y&&Array.isArray(n.x)&&Array.isArray(n.y)&&n.x.length===n.y.length))throw new TypeError("peaks must be an array or an object containing x[] and y[]");if(Array.isArray(n))for(const e of n)this.addPeak(e,t);else for(let e=0;e<n.x.length;e++)this.addPeak([n.x[e],n.y[e]],t)}addPeak(n,t={}){if(Array.isArray(n)&&n.length<2)throw new Error("peak must be an array with two (or three) values or an object with {x,y,width?}");if(!Array.isArray(n)&&(void 0===n.x||void 0===n.y))throw new Error("peak must be an array with two (or three) values or an object with {x,y,width?}");let e,i,a,s,r;Array.isArray(n)?[e,i,a,r]=n:(e=n.x,i=n.y,s=n.width,r=n.shape),i>this.maxPeakHeight&&(this.maxPeakHeight=i);let{shape:o}=t;r&&(o=o?{...o,...r}:r);const f=o?getShape1D(o):Object.assign(Object.create(Object.getPrototypeOf(this.shape)),this.shape),{width:l}=t;let{widthLeft:d,widthRight:g}=t;const u=void 0!==a?a:s?f.widthToFWHM(s):this.peakWidthFct?this.peakWidthFct(e):void 0!==l?l:f.fwhm;if(d||(d=u),g||(g=u),!d||!g)throw new Error("Width left or right is undefined or zero");const c=void 0===t.factor?f.getFactor():t.factor,b=e-d/2*c,h=e+g/2*c,D=Math.max(0,Math.floor((b-this.from)/this.interval)),H=Math.min(this.nbPoints-1,Math.ceil((h-this.from)/this.interval)),j=Math.round((e-this.from)/this.interval);f.fwhm=d;for(let n=D;n<Math.max(j,0);n++)this.data.y[n]+=i*f.fct(this.data.x[n]-e);f.fwhm=g;for(let n=Math.min(j,H);n<=H;n++)this.data.y[n]+=i*f.fct(this.data.x[n]-e)}addBaseline(n){return addBaseline(this.data,n),this}addNoise(n){return addNoise(this.data,n),this}getSpectrum(n={}){"boolean"==typeof n&&(n={copy:n});const{copy:t=!0,threshold:e=0}=n;if(e){const n=this.maxPeakHeight*e,t=[],i=[];for(let e=0;e<this.data.x.length;e++)this.data.y[e]>=n&&(t.push(this.data.x[e]),i.push(this.data.y[e]));return{x:Float64Array.from(t),y:Float64Array.from(i)}}return t?{x:this.data.x.slice(),y:this.data.y.slice()}:this.data}reset(){const n=this.data;for(let t=0;t<this.nbPoints;t++)n.x[t]=this.from+t*this.interval;return this}}function assertInteger$1(n,t){if(!Number.isInteger(n))throw new TypeError(`${t} option must be an integer`)}function assertNumber$1(n,t){if(!Number.isFinite(n))throw new TypeError(`${t} option must be a number`)}function generateSpectrum(n,t={}){const{generator:e,noise:i,baseline:a,threshold:s,peakOptions:r}=t,o=new SpectrumGenerator(e);return o.addPeaks(n,r),a&&o.addBaseline(a),i&&o.addNoise(i),o.getSpectrum({threshold:s})}const axis2D=["x","y"],peakCoordinates=["x","y","z"],convertWidthToFWHM=(n,t)=>{const e=ensureXYNumber$1(t);for(const t of axis2D)e[t]=n.widthToFWHM(e[t]);return e};class Spectrum2DGenerator{constructor(n={}){const{peakWidthFct:t=(()=>5),shape:e={kind:"gaussian"}}=n;let{from:i=0,to:a=100,nbPoints:s=1001}=n;i=ensureXYNumber$1(i),a=ensureXYNumber$1(a),s=ensureXYNumber$1(s);for(const n of axis2D)assertNumber(i[n],`from-${n}`),assertNumber(a[n],`to-${n}`),assertInteger(s[n],`nbPoints-${n}`);this.from=i,this.to=a,this.nbPoints=s,this.interval=calculeIntervals(i,a,s),this.peakWidthFct=t,this.maxPeakHeight=Number.MIN_SAFE_INTEGER;const r=getShape2D(e);this.shape=r,this.data={x:new Float64Array(s.x),y:new Float64Array(s.y),z:createMatrix(this.nbPoints)};for(const n of axis2D)if(this.to[n]<=this.from[n])throw new RangeError("to option must be larger than from");if("function"!=typeof this.peakWidthFct)throw new TypeError("peakWidthFct option must be a function");this.reset()}addPeaks(n,t){if(!(Array.isArray(n)||"object"==typeof n&&void 0!==n.x&&void 0!==n.y&&Array.isArray(n.x)&&Array.isArray(n.y)&&n.x.length===n.y.length))throw new TypeError("peaks must be an array or an object containing x[] and y[]");if(Array.isArray(n))for(const e of n)this.addPeak(e,t);else{const e=n.x.length;for(const t of peakCoordinates)if(n[t]&&Array.isArray(n[t])&&e!==n[t].length)throw new Error("x, y, z should have the same length");for(let e=0;e<n.x.length;e++)this.addPeak([n.x[e],n.y[e],n.z[e]],t)}return this}addPeak(n,t={}){if(Array.isArray(n)&&n.length<3)throw new Error("peak must be an array with three (or four) values or an object with {x,y,z,width?}");if(!Array.isArray(n)&&peakCoordinates.some((t=>void 0===n[t])))throw new Error("peak must be an array with three (or four) values or an object with {x,y,z,width?}");let e,i,a,s,r,o;Array.isArray(n)?[e,i,a,s,o]=n:(e=n.x,i=n.y,a=n.z,s=n.fwhm,r=n.width,o=n.shape);const f={x:e,y:i};a>this.maxPeakHeight&&(this.maxPeakHeight=a);const{width:l}=t;let{shape:d}=t;o&&(d=d?{...d,...o}:o);const g=d?getShape2D(d):Object.assign(Object.create(Object.getPrototypeOf(this.shape)),JSON.parse(JSON.stringify(this.shape)));let{fwhm:u=(void 0!==s?s:r?convertWidthToFWHM(g,r):l?convertWidthToFWHM(g,l):this.peakWidthFct(e,i))}=t;u=ensureXYNumber$1(u);let c=void 0===t.factor?g.getFactor():t.factor;c=ensureXYNumber$1(c);const b={x:0,y:0},h={x:0,y:0};for(const n of axis2D){const t=f[n]-u[n]/2*c[n],e=f[n]+u[n]/2*c[n];b[n]=Math.max(0,Math.floor((t-this.from[n])/this.interval[n])),h[n]=Math.min(this.nbPoints[n],Math.ceil((e-this.from[n])/this.interval[n]))}g.fwhm=u;for(let n=b.x;n<h.x;n++)for(let t=b.y;t<h.y;t++){const e=a*g.fct(this.data.x[n]-f.x,this.data.y[t]-f.y);e>1e-6&&(this.data.z[t][n]+=e)}return this}getSpectrum(n={}){"boolean"==typeof n&&(n={copy:n});const{copy:t=!0}=n,e=matrixMinMaxZ(this.data.z);return{minX:this.from.x,maxX:this.to.x,maxY:this.to.y,minY:this.from.y,minZ:e.min,maxZ:e.max,z:t?this.data.z.slice():this.data.z}}reset(){const n=this.data;for(const t of axis2D)for(let e=0;e<this.nbPoints[t];e++)n[t][e]=this.from[t]+e*this.interval[t];for(const t of n.z)for(let n=0;n<t.length;n++)t[n]=0;return this}}function generateSpectrum2D(n,t={}){const{generator:e,peaks:i}=t,a=new Spectrum2DGenerator(e);return a.addPeaks(n,i),a.getSpectrum()}function ensureXYNumber$1(n){return"object"!=typeof n?{x:n,y:n}:{...n}}function calculeIntervals(n,t,e){return{x:(t.x-n.x)/(e.x-1),y:(t.y-n.y)/(e.y-1)}}function assertInteger(n,t){if(!Number.isInteger(n))throw new TypeError(`${t} option must be an integer`)}function assertNumber(n,t){if(!Number.isFinite(n))throw new TypeError(`${t} option must be a number`)}function createMatrix(n){const t=new Array(n.y);for(let e=0;e<n.y;e++)t[e]=new Float64Array(n.x);return t}function hasProperty(n,t){return t in n}const{parse:parse$4,stringify:stringify$4}=JSON;function convertWidth(n,t){const{frequency:e,convertTo:i,output:a=parse$4(stringify$4(n))}=t,s=getConverter(i,e);for(const n of a)if(n.width=s(n.width),hasProperty(n,"shape")){const t=n.shape;t.fwhm&&(t.fwhm=s(t.fwhm))}return a}function getConverter(n,t){switch(n){case"ppm":return n=>n/t;case"hz":return n=>n*t;default:throw new Error(`Does not support convert to ${n}`)}}function convertWidthToPPM(n,t){return convertWidth(n,{...t,convertTo:"ppm"})}function peaksToXY(n,t){const{frequency:e,nbPoints:i=1024,shape:a}=t;if(!e)throw new Error("frequency is mandatory");const s=convertWidthToPPM(n,{frequency:e});return generateSpectrum(s,{generator:{...getFromTo$1(s,t),nbPoints:i,shape:a}})}function getFromTo$1(n,t){if("to"in t&&"from"in t)return{from:t.from,to:t.to};n.sort(((n,t)=>n.x-t.x));const e=n[0],i=n[n.length-1],{from:a=e.x-2*e.width/t.frequency,to:s=i.x+2*i.width/t.frequency}=t;return{from:a,to:s}}function peakToXY(n,t){const e=addMissingShape([n])[0],i=getShape1D(e.shape).getFactor(),{from:a=e.x-n.width*i/t.frequency,to:s=e.x+n.width*i/t.frequency}=t;return peaksToXY([n],{...t,from:a,to:s})}let xAtomicNumber=0;function getXAtomicNumber(n){if(!xAtomicNumber){const t=n.getOCL();xAtomicNumber=t.Molecule.getAtomicNoFromLabel("X",t.Molecule.cPseudoAtomX)}return xAtomicNumber}function isCsp3(n,t){return 6===n.getAtomicNo(t)&&(0===n.getAtomCharge(t)&&n.getImplicitHydrogens(t)+n.getConnAtoms(t)===4)}function makeRacemic(n){const{Molecule:t}=n.getOCL();n.ensureHelperArrays(t.cHelperCIP);for(let e=0;e<n.getAllAtoms();e++)n.getAtomParity(e)!==t.cAtomParityNone&&n.setAtomESR(e,t.cESRTypeAnd,0);n.ensureHelperArrays(t.cHelperCIP)}function tagAtom(n,t){const e=`${n.getAtomLabel(t)}*`;return n.setAtomCustomLabel(t,e),1===n.getAtomicNo(t)?n.setAtomicNo(t,getXAtomicNumber(n)):n.setAtomMass(t,n.getAtomMass(t)+5),e}const FULL_HOSE_CODE=1,HOSE_CODE_CUT_C_SP3_SP3=2;function getHoseCodesForAtomsInternal(n,t={}){const e=getHoseCodesForAtomsAsFragments(n,t),i=n.getOCL(),a=[];for(const n of e)a.push(n.getCanonizedIDCode(i.Molecule.CANONIZER_ENCODE_ATOM_CUSTOM_LABELS));return a}function getHoseCodesForAtomsAsFragments(n,t={}){const e=n.getOCL(),{allowedCustomLabels:i,minSphereSize:a=0,maxSphereSize:s=4,kind:r=FULL_HOSE_CODE,tagAtoms:o=[],tagAtomFct:f=tagAtom}=t,l=t.rootAtoms?t.rootAtoms.slice():[];if(n=n.getCompactCopy(),o.length>0?internalTagAtoms(n,o,l,f):n.ensureHelperArrays(e.Molecule.cHelperNeighbours),0===l.length)for(let t=0;t<n.getAllAtoms();t++)(i?.includes(n.getAtomCustomLabel(t))||n.getAtomCustomLabel(t))&&l.push(t);const d=[],g=new e.Molecule(0,0),u=[];let c=0,b=0;const h=new Uint8Array(n.getAllAtoms()),D=new Uint8Array(n.getAllAtoms());for(let t=0;t<=s;t++){if(0===b)for(const n of l)D[b]=n,h[n]=!0,b++;else{let t=b;for(let e=c;e<b;e++){const i=D[e];for(let e=0;e<n.getAllConnAtoms(i);e++){const a=n.getConnAtom(i,e);if(!h[a])switch(r){case FULL_HOSE_CODE:h[a]=!0,D[t++]=a;break;case HOSE_CODE_CUT_C_SP3_SP3:isCsp3(n,i)&&isCsp3(n,a)||(h[a]=!0,D[t++]=a);break;default:throw new Error("getHoseCoesForAtom unknown kind")}}}c=b,b=t}if(t>=a){n.copyMoleculeByAtoms(g,h,!0,u);for(let n=0;n<g.getAllAtoms();n++)g.setAtomMapNo(n,u.indexOf(n)+1);g.removeExplicitHydrogens(),makeRacemic(g),addQueryFeaturesAndRemoveMapNo(g,n),d.push(g.getCompactCopy())}}return d}function addQueryFeaturesAndRemoveMapNo(n,t){const e=t.getOCL().Molecule;for(let i=0;i<n.getAllAtoms();i++){const a=n.getAtomMapNo(i)-1;if(n.setAtomMapNo(i,0),[1,9,17,35,53,getXAtomicNumber(t)].includes(n.getAtomicNo(i)))continue;t.isAromaticAtom(a)?(n.setAtomQueryFeature(i,e.cAtomQFAromatic,!0),n.setAtomQueryFeature(i,e.cAtomQFNotAromatic,!1)):(n.setAtomQueryFeature(i,e.cAtomQFAromatic,!1),n.setAtomQueryFeature(i,e.cAtomQFNotAromatic,!0));switch(t.getAtomRingSize(a)){case 0:break;case 3:n.setAtomQueryFeature(i,e.cAtomQFRingSize3,!0);break;case 4:n.setAtomQueryFeature(i,e.cAtomQFRingSize4,!0);break;case 5:n.setAtomQueryFeature(i,e.cAtomQFRingSize5,!0);break;case 6:n.setAtomQueryFeature(i,e.cAtomQFRingSize6,!0);break;case 7:n.setAtomQueryFeature(i,e.cAtomQFRingSize7,!0);break;default:n.setAtomQueryFeature(i,e.cAtomQFRingSizeLarge,!0)}const s=t.getAllHydrogens(a);0===s?n.setAtomQueryFeature(i,e.cAtomQFNot0Hydrogen,!1):n.setAtomQueryFeature(i,e.cAtomQFNot0Hydrogen,!0),1===s?n.setAtomQueryFeature(i,e.cAtomQFNot1Hydrogen,!1):n.setAtomQueryFeature(i,e.cAtomQFNot1Hydrogen,!0),2===s?n.setAtomQueryFeature(i,e.cAtomQFNot2Hydrogen,!1):n.setAtomQueryFeature(i,e.cAtomQFNot2Hydrogen,!0),3===s?n.setAtomQueryFeature(i,e.cAtomQFNot3Hydrogen,!1):n.setAtomQueryFeature(i,e.cAtomQFNot3Hydrogen,!0)}}function internalTagAtoms(n,t,e,i){const a=n.getOCL();if(t){for(let t=0;t<n.getAllAtoms();t++)n.setAtomMapNo(t,t+1);if(t.length>0)for(const e of t)i(n,e)}if(n.ensureHelperArrays(a.Molecule.cHelperNeighbours),e.length>0){const t=new Int32Array(n.getAllAtoms());for(let e=0;e<n.getAllAtoms();e++)t[n.getAtomMapNo(e)-1]=e;for(let n=0;n<e.length;n++)e[n]=t[e[n]]}}function getAllAtomsPaths(n,t={}){const{maxPathLength:e=5}=t,i=[];for(let t=0;t<n.getAllAtoms();t++){const a=[];i.push(a);let s=[];s.push({path:[t],pathLength:0}),a.push(s);let r=[0],o=[t];for(let t=1;t<=e;t++){s=[],a.push(s);const e=r,i=o;r=[],o=[];for(let f=0;f<e.length;f++){const l=i[f],d=e[f],g=a[t-1][d].path;for(let e=0;e<n.getAllConnAtoms(l);e++){const i=n.getConnAtom(l,e);g.includes(i)||(r.push(s.length),o.push(i),s.push({path:[...g,i],pathLength:t}))}}}}return i}function floydWarshall(n){if(Matrix.isMatrix(n)&&n.columns!==n.rows)throw new TypeError("The adjacency matrix should be squared");const t=n.columns;let e=new Matrix(t,t);e.apply(((t,i)=>{if(t===i)e.set(t,i,0);else{let a=n.get(t,i);a||Object.is(a,-0)?e.set(t,i,a):e.set(t,i,Number.POSITIVE_INFINITY)}}));for(let n=0;n<t;++n)for(let i=0;i<t;++i)for(let a=0;a<t;++a){let t=e.get(i,n)+e.get(n,a);e.get(i,a)>t&&e.set(i,a,t)}return e.apply(((n,t)=>{e.get(n,t)===Number.POSITIVE_INFINITY&&e.set(n,t,-1)})),e}function getConnectivityMatrix(n,t={}){const e=n.getOCL();n.ensureHelperArrays(e.Molecule.cHelperNeighbours);const i=n.getAllAtoms();let a=new Array(i).fill();if(a=a.map((()=>new Array(i).fill(0))),!t.pathLength)if(t.atomicNo)for(let t=0;t<i;t++)a[t][t]=n.getAtomicNo(t);else if(t.negativeAtomicNo)for(let t=0;t<i;t++)a[t][t]=-n.getAtomicNo(t);else if(t.mass)for(let t=0;t<i;t++)a[t][t]=e.Molecule.cRoundedMass[n.getAtomicNo(t)];else for(let n=0;n<i;n++)a[n][n]=1;if(t.sdt)for(let t=0;t<i;t++){const e=n.getAllConnAtoms(t);for(let i=0;i<e;i++)a[t][n.getConnAtom(t,i)]=n.getConnBondOrder(t,i)}else if(t.sdta)for(let t=0;t<i;t++){const e=n.getAllConnAtoms(t);for(let i=0;i<e;i++){const e=n.getConnBond(t,i);n.isAromaticBond(e)?a[t][n.getConnAtom(t,i)]=4:a[t][n.getConnAtom(t,i)]=n.getConnBondOrder(t,i)}}else for(let t=0;t<i;t++){const e=n.getAllConnAtoms(t);for(let i=0;i<e;i++)a[t][n.getConnAtom(t,i)]=1}return t.pathLength&&(a=floydWarshall(new Matrix(a)).to2DArray()),a}function getCanonizedDiaIDs(n){const t=n.heterotopicSymmetryRanks,e=n.moleculeWithH,i=n.finalRanks,a=new Array(e.getAllAtoms());e.ensureHelperArrays(n.molecule.getOCL().Molecule.cHelperSymmetryStereoHeterotopicity);const s={};for(let e=0;e<n.moleculeWithH.getAllAtoms();e++){const r=t[e];if(r&&s[r]){a[i[e]]=s[r].diaID;continue}const o=n.moleculeWithH.getCompactCopy();tagAtom(o,e),makeRacemic(o);const f=o.getCanonizedIDCode(n.molecule.getOCL().Molecule.CANONIZER_ENCODE_ATOM_CUSTOM_LABELS);a[i[e]]=f}return a}function getCanonizedHoseCodes(n){const t=n.options,e=n.heterotopicSymmetryRanks,i=n.moleculeWithH,a=n.finalRanks,s=new Array(i.getAllAtoms());i.ensureHelperArrays(n.molecule.getOCL().Molecule.cHelperSymmetryStereoHeterotopicity);const r={};for(let i=0;i<n.moleculeWithH.getAllAtoms();i++){const o=e[i];if(o&&r[o]){s[a[i]]=r[o].diaID;continue}const f=n.moleculeWithH.getCompactCopy();tagAtom(f,i);const l=getHoseCodesForAtomsInternal(f,t);s[a[i]]=l}return s}function getDiaIDsAndInfo(n,t){const e=[],i=n.moleculeWithH,a={};for(const n of t)a[n]||(a[n]=0),a[n]++;for(let s=0;s<t.length;s++){const r=t[n.finalRanks[s]],o={idCode:r,attachedHydrogensIDCodes:[],attachedHydrogens:[],nbAttachedHydrogens:0,atomLabel:i.getAtomLabel(s),nbEquivalentAtoms:a[r],heavyAtom:void 0,atomMapNo:i.getAtomMapNo(s)};if(1===i.getAtomicNo(s)){const e=i.getConnAtom(s,0);o.heavyAtom=t[n.finalRanks[e]]}for(let e=0;e<i.getAllConnAtoms(s);e++){const a=i.getConnAtom(s,e);if(1===i.getAtomicNo(a)){o.nbAttachedHydrogens++,o.attachedHydrogens.push(a);const e=t[n.finalRanks[a]];o.attachedHydrogensIDCodes.includes(e)||o.attachedHydrogensIDCodes.push(e)}}e.push(o)}return e}function getHeterotopicSymmetryRanks(n){n.ensureHelperArrays(n.getOCL().Molecule.cHelperSymmetryStereoHeterotopicity);const t=[];for(let e=0;e<n.getAllAtoms();e++)t.push(n.getSymmetryRank(e));return t}function getFinalRanks(n){return n.ensureHelperArrays(n.getOCL().Molecule.cHelperSymmetryStereoHeterotopicity),n.getFinalRanks(0).map((n=>n-1))}function getChiralOrHeterotopicCarbons(n){const{Molecule:t}=n.getOCL(),e=getXAtomicNumber(n),i=n.getCompactCopy();i.addImplicitHydrogens();for(let n=0;n<i.getAllAtoms();n++)1===i.getAtomicNo(n)&&i.setAtomicNo(n,e);addPossibleChiralBonds(i),i.ensureHelperArrays(t.cHelperSymmetryStereoHeterotopicity);const a=[];for(let t=0;t<n.getAllAtoms();t++){if(i.getAtomicNo(t)===e)continue;if(n.getAtomicNo(t)!==i.getAtomicNo(t))throw new Error("getChiralOrHeterotopicCarbons: mismatching atomic numbers");if(6!==i.getAtomicNo(t))continue;4===getNeighbourSymmetries(i,t).length&&a.push(t)}return a}function addPossibleChiralBonds(n){const{Molecule:t}=n.getOCL();n.ensureHelperArrays(t.cHelperSymmetryStereoHeterotopicity);for(let e=0;e<n.getAtoms();e++){if(6!==n.getAtomicNo(e))continue;if(n.getStereoBond(e)>=0)continue;if(getNeighbourSymmetries(n,e).length<=2)continue;const i=n.getAtomPreferredStereoBond(e);if(-1!==i){if(n.setBondType(i,t.cBondTypeUp),n.getBondAtom(1,i)===e){const t=n.getBondAtom(0,i);n.setBondAtom(0,i,e),n.setBondAtom(1,i,t)}n.setAtomESR(e,t.cESRTypeAnd,0)}}}function getNeighbourSymmetries(n,t){const e=[];for(let i=0;i<n.getAllConnAtoms(t);i++){const a=n.getConnAtom(t,i),s=n.getSymmetryRank(a);e.includes(s)||e.push(n.getSymmetryRank(a))}return e}function ensureHeterotopicChiralBonds(n,t={}){const{Molecule:e}=n.getOCL(),{esrType:i=e.cESRTypeAnd,atLeastThreeAtoms:a=!0}=t;n.ensureHelperArrays(e.cHelperBitNeighbours);const s=getChiralOrHeterotopicCarbons(n);for(const t of s)if(!(a&&n.getAllConnAtoms(t)<3)&&-1===n.getStereoBond(t)){const a=n.getAtomPreferredStereoBond(t);if(-1!==a){if(n.setBondType(a,e.cBondTypeUp),n.getBondAtom(1,a)===t){const e=n.getBondAtom(0,a);n.setBondAtom(0,a,t),n.setBondAtom(1,a,e)}n.setAtomESR(t,i,0)}}}function getMoleculeWithH(n,t={}){const{maxNbAtoms:e=250}=t,i=n.getCompactCopy();if(i.addImplicitHydrogens(),i.getAllAtoms()>e)throw new Error(`too many atoms to add hydrogens: ${i.getAllAtoms()} > ${e}`);return ensureHeterotopicChiralBonds(i),i}function getXMolecule(n){const t=getXAtomicNumber(n),e=n.getCompactCopy();for(let n=0;n<e.getAllAtoms();n++)1===e.getAtomicNo(n)&&e.setAtomicNo(n,t);return e}class TopicMolecule{constructor(n,t={}){this.originalMolecule=n,this.options={maxPathLength:5,...t},this.idCode=n.getIDCode(),this.molecule=this.originalMolecule.getCompactCopy(),this.molecule.ensureHelperArrays(n.getOCL().Molecule.cHelperNeighbours),this.molecule.ensureHelperArrays(this.molecule.getOCL().Molecule.cHelperNeighbours),this.cache={}}ensureMapNo(){const n={};for(let t=0;t<this.molecule.getAllAtoms();t++){const e=this.molecule.getAtomMapNo(t);if(e){if(n[e])throw new Error("The molecule contains several atoms with the same mapNo");n[e]=!0}}let t=1;for(let e=0;e<this.molecule.getAllAtoms();e++){if(!this.molecule.getAtomMapNo(e)){for(;n[t];)t++;n[t]=!0,this.molecule.setAtomMapNo(e,t,!1)}}}getHoseFragment(n,t={}){const{sphereSize:e=2,tagAtoms:i=n,tagAtomFct:a}=t;return getHoseCodesForAtomsAsFragments(this.moleculeWithH,{rootAtoms:n,minSphereSize:e,maxSphereSize:e,tagAtoms:i,tagAtomFct:a})[0]}getAtomPaths(n,t,e={}){const{pathLength:i}=e;if(void 0!==i&&i>this.options.maxPathLength)throw new Error("The distance is too long, you should increase the maxPathLength when instantiating the TopicMolecule");const a=this.atomsPaths[n],s=i||0,r=i||this.options.maxPathLength,o=[];for(let n=s;n<=r;n++)for(const e of a[n])e.path.at(-1)===t&&o.push(e.path);return o}get atomsPaths(){return this.cache.atomsPaths||(this.cache.atomsPaths=getAllAtomsPaths(this.moleculeWithH,{maxPathLength:this.options.maxPathLength})),this.cache.atomsPaths}toMolfile(n={}){const{version:t=2}=n;return 2===t?this.molecule.toMolfile():this.molecule.toMolfileV3()}getMolecule(){return this.molecule}fromMolecule(n){if(n.getIDCode()!==this.idCode)return new TopicMolecule(n);const t=new TopicMolecule(n);return t.cache={canonizedDiaIDs:this.cache.canonizedDiaIDs,canonizedHoseCodes:this.cache.canonizedHoseCodes},t}get moleculeWithH(){return this.cache.moleculeWithH||(this.cache.moleculeWithH=getMoleculeWithH(this.molecule,{maxNbAtoms:this.options.maxNbAtoms})),this.cache.moleculeWithH}get xMolecule(){return this.cache.xMolecule||(this.cache.xMolecule=getXMolecule(this.moleculeWithH)),this.cache.xMolecule}get diaIDs(){if(this.cache.diaIDs)return this.cache.diaIDs;const n=[];for(let t=0;t<this.moleculeWithH.getAllAtoms();t++)n.push(this.canonizedDiaIDs[this.finalRanks[t]]);return this.cache.diaIDs=n,n}getDiaIDsObject(){return groupDiastereotopicAtomIDsAsObject(this.diaIDs,this.molecule,this.moleculeWithH)}get hoseCodes(){if(this.cache.hoseCodes)return this.cache.hoseCodes;const n=[];for(let t=0;t<this.moleculeWithH.getAllAtoms();t++)n.push(this.canonizedHoseCodes[this.finalRanks[t]]);return this.cache.hoseCodes=n,n}get canonizedDiaIDs(){return this.cache.canonizedDiaIDs||(this.cache.canonizedDiaIDs=getCanonizedDiaIDs(this)),this.cache.canonizedDiaIDs}get canonizedHoseCodes(){return this.cache.canonizedHoseCodes||(this.cache.canonizedHoseCodes=getCanonizedHoseCodes(this)),this.cache.canonizedHoseCodes}get distanceMatrix(){return getConnectivityMatrix(this.moleculeWithH,{pathLength:!0})}get diaIDsAndInfo(){return this.cache.diaIDsAndInfo||(this.cache.diaIDsAndInfo=getDiaIDsAndInfo(this,this.canonizedDiaIDs)),this.cache.diaIDsAndInfo}get heterotopicSymmetryRanks(){return this.cache.heterotopicSymmetryRanks?this.cache.heterotopicSymmetryRanks:(this.cache.heterotopicSymmetryRanks=getHeterotopicSymmetryRanks(this.xMolecule),[...this.cache.heterotopicSymmetryRanks])}get finalRanks(){return this.cache.finalRanks||(this.cache.finalRanks=getFinalRanks(this.xMolecule)),this.cache.finalRanks}toMolfileWithH(n={}){const{version:t=2}=n;return 2===t?this.moleculeWithH.toMolfile():this.moleculeWithH.toMolfileV3()}getGroupedDiastereotopicAtomIDs(n={}){return groupDiastereotopicAtomIDs(this.diaIDs,this.moleculeWithH,n)}getDiaIDsMapping(n){const t=new TopicMolecule(n),e=this.diaIDsAndInfo.filter((n=>n.atomMapNo)),i=t.diaIDsAndInfo.filter((n=>n.atomMapNo)),a={};for(const n of i){const t=e.find((t=>t.atomMapNo===n.atomMapNo)),i=n.idCode,s=t.idCode;s in a?a[s]!==i&&(a[s]=void 0):a[s]=i}for(const n of i){const t=e.find((t=>t.atomMapNo===n.atomMapNo));for(let e=0;e<t.attachedHydrogensIDCodes.length;e++){const i=t.attachedHydrogensIDCodes[e];if(a[i])continue;const s=n.attachedHydrogensIDCodes[e];i&&s&&(i in a?a[i]!==s&&(a[i]=void 0):a[i]=s)}}return a}}function groupDiastereotopicAtomIDs(n,t,e={}){const i=groupDiastereotopicAtomIDsAsObject(n,t,t,e);return Object.keys(i).map((n=>i[n]))}function groupDiastereotopicAtomIDsAsObject(n,t,e,i={}){const{atomLabel:a}=i,s={};for(let i=0;i<n.length;i++)if(!a||e.getAtomLabel(i)===a){const a=n[i];if(s[a]||(s[a]={counter:0,atoms:[],oclID:a,atomLabel:e.getAtomLabel(i),heavyAtoms:[],attachedHydrogens:[],existingAtoms:[]}),1===e.getAtomicNo(i)){const n=e.getConnAtom(i,0);s[a].heavyAtoms.includes(n)||s[a].heavyAtoms.push(n),t.getAtomicNo(i)?s[a].existingAtoms.push(i):s[a].existingAtoms.includes(n)||s[a].existingAtoms.push(n)}else{for(let n=0;n<e.getAllConnAtoms(i);n++){const t=e.getConnAtom(i,n);1===e.getAtomicNo(t)&&s[a].attachedHydrogens.push(t)}s[a].existingAtoms.push(i)}s[a].counter++,s[a].atoms.push(i)}for(const n in s)s[n].existingAtoms.sort(((n,t)=>n-t)),s[n].attachedHydrogens.sort(((n,t)=>n-t));return s}function squaredEuclidean(n,t){let e=0;for(let i=0;i<n.length;i++)e+=(n[i]-t[i])*(n[i]-t[i]);return e}function euclidean(n,t){return Math.sqrt(squaredEuclidean(n,t))}function distanceMatrix(n,t){const e=getMatrix(n.length);for(let i=0;i<n.length;i++)for(let a=0;a<=i;a++)e[i][a]=t(n[i],n[a]),e[a][i]=e[i][a];return e}function getMatrix(n){const t=[];for(let e=0;e<n;e++){const e=[];t.push(e);for(let t=0;t<n;t++)e.push(0)}return t}var heap$1={exports:{}};!function(n,t){(function(){var t,e,i,a,s,r,o,f,l,d,g,u,c,b,h;i=Math.floor,d=Math.min,e=function(n,t){return n<t?-1:n>t?1:0},l=function(n,t,a,s,r){var o;if(null==a&&(a=0),null==r&&(r=e),a<0)throw new Error("lo must be non-negative");for(null==s&&(s=n.length);a<s;)r(t,n[o=i((a+s)/2)])<0?s=o:a=o+1;return[].splice.apply(n,[a,a-a].concat(t)),t},r=function(n,t,i){return null==i&&(i=e),n.push(t),b(n,0,n.length-1,i)},s=function(n,t){var i,a;return null==t&&(t=e),i=n.pop(),n.length?(a=n[0],n[0]=i,h(n,0,t)):a=i,a},f=function(n,t,i){var a;return null==i&&(i=e),a=n[0],n[0]=t,h(n,0,i),a},o=function(n,t,i){var a;return null==i&&(i=e),n.length&&i(n[0],t)<0&&(t=(a=[n[0],t])[0],n[0]=a[1],h(n,0,i)),t},a=function(n,t){var a,s,r,o,f,l;for(null==t&&(t=e),f=[],s=0,r=(o=function(){l=[];for(var t=0,e=i(n.length/2);0<=e?t<e:t>e;0<=e?t++:t--)l.push(t);return l}.apply(this).reverse()).length;s<r;s++)a=o[s],f.push(h(n,a,t));return f},c=function(n,t,i){var a;if(null==i&&(i=e),-1!==(a=n.indexOf(t)))return b(n,0,a,i),h(n,a,i)},g=function(n,t,i){var s,r,f,l,d;if(null==i&&(i=e),!(r=n.slice(0,t)).length)return r;for(a(r,i),f=0,l=(d=n.slice(t)).length;f<l;f++)s=d[f],o(r,s,i);return r.sort(i).reverse()},u=function(n,t,i){var r,o,f,g,u,c,b,h,D;if(null==i&&(i=e),10*t<=n.length){if(!(f=n.slice(0,t).sort(i)).length)return f;for(o=f[f.length-1],g=0,c=(b=n.slice(t)).length;g<c;g++)i(r=b[g],o)<0&&(l(f,r,0,null,i),f.pop(),o=f[f.length-1]);return f}for(a(n,i),D=[],u=0,h=d(t,n.length);0<=h?u<h:u>h;0<=h?++u:--u)D.push(s(n,i));return D},b=function(n,t,i,a){var s,r,o;for(null==a&&(a=e),s=n[i];i>t&&a(s,r=n[o=i-1>>1])<0;)n[i]=r,i=o;return n[i]=s},h=function(n,t,i){var a,s,r,o,f;for(null==i&&(i=e),s=n.length,f=t,r=n[t],a=2*t+1;a<s;)(o=a+1)<s&&!(i(n[a],n[o])<0)&&(a=o),n[t]=n[a],a=2*(t=a)+1;return n[t]=r,b(n,f,t,i)},t=function(){function n(n){this.cmp=null!=n?n:e,this.nodes=[]}return n.push=r,n.pop=s,n.replace=f,n.pushpop=o,n.heapify=a,n.updateItem=c,n.nlargest=g,n.nsmallest=u,n.prototype.push=function(n){return r(this.nodes,n,this.cmp)},n.prototype.pop=function(){return s(this.nodes,this.cmp)},n.prototype.peek=function(){return this.nodes[0]},n.prototype.contains=function(n){return-1!==this.nodes.indexOf(n)},n.prototype.replace=function(n){return f(this.nodes,n,this.cmp)},n.prototype.pushpop=function(n){return o(this.nodes,n,this.cmp)},n.prototype.heapify=function(){return a(this.nodes,this.cmp)},n.prototype.updateItem=function(n){return c(this.nodes,n,this.cmp)},n.prototype.clear=function(){return this.nodes=[]},n.prototype.empty=function(){return 0===this.nodes.length},n.prototype.size=function(){return this.nodes.length},n.prototype.clone=function(){var t;return(t=new n).nodes=this.nodes.slice(0),t},n.prototype.toArray=function(){return this.nodes.slice(0)},n.prototype.insert=n.prototype.push,n.prototype.top=n.prototype.peek,n.prototype.front=n.prototype.peek,n.prototype.has=n.prototype.contains,n.prototype.copy=n.prototype.clone,n}(),n.exports=t}).call(commonjsGlobal)}(heap$1);var heap=heap$1.exports,Heap=heap;class Cluster{constructor(){this.children=[],this.height=0,this.size=1,this.index=-1,this.isLeaf=!1}cut(n){if("number"!=typeof n)throw new TypeError("threshold must be a number");if(n<0)throw new RangeError("threshold must be a positive number");let t=[this];const e=[];for(;t.length>0;){const i=t.shift();n>=i.height?e.push(i):t=t.concat(i.children)}return e}group(n){if(!Number.isInteger(n)||n<1)throw new RangeError("groups must be a positive integer");const t=new Heap(((n,t)=>t.height-n.height));for(t.push(this);t.size()<n;){const n=t.pop();if(0===n.children.length)break;n.children.forEach((n=>t.push(n)))}const e=new Cluster;return e.children=t.toArray(),e.height=this.height,e}traverse(n){!function n(t,e){if(e(t),t.children)for(const i of t.children)n(i,e)}(this,n)}indices(){const n=[];return this.traverse((t=>{t.isLeaf&&n.push(t.index)})),n}}function singleLink(n,t){return Math.min(n,t)}function completeLink(n,t){return Math.max(n,t)}function averageLink(n,t,e,i,a){return i/(i+a)*n+a/(i+a)*t}function weightedAverageLink(n,t){return(n+t)/2}function centroidLink(n,t,e,i,a){return i/(i+a)*n+a/(i+a)*t+-i*a/(i+a)**2*e}function medianLink(n,t,e){return n/2+t/2-e/4}function wardLink(n,t,e,i,a,s){return(i+s)/(i+a+s)*n+(a+s)/(i+a+s)*t+-s/(i+a+s)*e}function wardLink2(n,t,e,i,a,s){const r=(i+s)/(i+a+s),o=(a+s)/(i+a+s),f=-s/(i+a+s);return Math.sqrt(r*n*n+o*t*t+f*e*e)}function agnes(n,t={}){const{distanceFunction:e=euclidean,method:i="complete",isDistanceMatrix:a=!1}=t;let s;a||(n=distanceMatrix(n,e));let r=new Matrix(n);const o=r.rows;if("string"==typeof i)switch(i.toLowerCase()){case"single":s=singleLink;break;case"complete":s=completeLink;break;case"average":case"upgma":s=averageLink;break;case"wpgma":s=weightedAverageLink;break;case"centroid":case"upgmc":s=centroidLink;break;case"median":case"wpgmc":s=medianLink;break;case"ward":s=wardLink;break;case"ward2":s=wardLink2;break;default:throw new RangeError(`unknown clustering method: ${i}`)}else if("function"!=typeof i)throw new TypeError("method must be a string or function");let f=[];for(let n=0;n<o;n++){const t=new Cluster;t.isLeaf=!0,t.index=n,f.push(t)}for(let n=0;n<o-1;n++){const[n,t,e]=getSmallestDistance(r),i=f[n],a=f[t],o=new Cluster;o.size=i.size+a.size,o.children.push(i,a),o.height=e;const l=[o],d=new Matrix(r.rows-1,r.rows-1),g=e=>getPreviousIndex(e,Math.min(n,t),Math.max(n,t));for(let o=1;o<d.rows;o++){const u=g(o),c=f[u];l.push(c);for(let f=0;f<o;f++)if(0===f){const l=s(r.get(n,u),r.get(u,t),e,i.size,a.size,c.size);d.set(o,f,l),d.set(f,o,l)}else{const n=r.get(u,g(f));d.set(o,f,n),d.set(f,o,n)}}f=l,r=d}return f[0]}function getSmallestDistance(n){let t=1/0,e=0,i=0;for(let a=1;a<n.rows;a++)for(let s=0;s<a;s++)n.get(a,s)<t&&(t=n.get(a,s),e=a,i=s);return[e,i,t]}function getPreviousIndex(n,t,e){return(n-=1)>=t&&n++,n>=e&&n++,n}var full={},openchemlibFull={};!function(n){!function(t){var e,i;"undefined"!=typeof self?(e=!0,i=self):void 0!==commonjsGlobal?(e=!1,i=commonjsGlobal):(e=!1,i=t);var a,s=i.document||{};s.compatMode||(s.compatMode="CSS1Compat"),e?a=i:((a={}).setTimeout=i.setTimeout?i.setTimeout.bind(i):o,a.clearTimeout=i.clearTimeout?i.clearTimeout.bind(i):o,a.setInterval=i.setInterval?i.setInterval.bind(i):o,a.clearInterval=i.clearInterval?i.clearInterval.bind(i):o,a.Error=i.Error,a.Math=i.Math,a.RegExp=i.RegExp,a.TypeError=i.TypeError),a.document||(a.document=s);var r=function(n){var t=n.document,e={},i={userAgent:"webkit"};function a(){}var r=a;r.__moduleStartupDone=a;var o,f,l,d,g,u,c,b="object",h="anonymous",D="fnStack",H="\n",j={4:1,9:1,5:1,7:1},m="Unknown",A="boolean",C="number",p="string",M="function",I=2147483647,P='For input string: "',T="null",N="__noinit__",w={4:1,5:1,7:1},U={4:1,18:1,28:1},J=" (copy)",L={4:1,9:1,15:1,5:1,11:1,7:1,14:1},y=65536,B=65535,R=1e4,k="fromIndex: ",x=" > toIndex: ",E=", toIndex: ",F=", length: ",Q="Index: ",z=", Size: ",S={13:1,4:1,5:1},X={4:1},G={8:1,4:1,5:1},Y=16777215,q=65280,V=.30000001192092896,v=545460846592,Z=4294967296,O=8589934592,K=17179869184,W=34359738368,_=68719476736,$=137438953472,nn=274877906944,tn={12:1,4:1,5:1},en=536870912,an=2.617993878,sn=3.665191429,rn=6.283185307179586,on=3.141592653589793,fn=1.5707963267948966,ln=16384,dn=4096,gn={l:0,m:0,h:1},un={l:0,m:0,h:2},cn={l:0,m:0,h:4},bn=1920,hn=1024,Dn=234881024,Hn=167772160,jn=100663296,mn=201326592,An=114688,Cn=4063232,pn=3801088,Mn=3538944,In=3014656,Pn=3145728,Tn=2097152,Nn=393216,wn=917504,Un=1966080,Jn=0xf8000000000,Ln=0xf0000000000,yn=0xe8000000000,Bn=0xd8000000000,Rn=0xb8000000000,kn=8796093022208,xn=549755813888,En=1649267441664,Fn=3848290697216,Qn=8246337208320,zn=29360128,Sn=268435456,Xn=8192,Gn=2048,Yn=-1.5707963267948966,qn=130560,Vn=6291456,vn=-2.0943951023931953,Zn=1.0471975511965976,On=.5235987755982988,Kn=786432,Wn=524288,_n=262144,$n=-16777216,nt=-65536,tt=-32768,et='<DrawingObject type="',it="></DrawingObject>",at={4:1,5:1,16:1},st={4:1,5:1},rt="unsupported atomicNo:",ot=2.8415926535897933,ft={41:1,4:1,9:1,5:1,7:1},lt={4:1,5:1,11:1,7:1},dt={10:1,4:1,5:1},gt=131072,ut=196608,ct={l:6,m:0,h:4},bt=1048576,ht=3221225472,Dt={l:0,m:0,h:3},Ht=8388608,jt="text",mt={30:1,61:1,62:1},At={30:1,61:1,105:1,62:1,122:1},Ct={4:1,5:1,30:1,61:1,105:1,21:1,62:1,122:1,194:1},pt="??",Mt=2013265920,It=32505856,Pt=31744,Tt=17976931348623157e292,Nt=122880,wt={153:1,4:1,9:1,5:1,11:1,7:1},Ut=33554432,Jt=67108864,Lt=32768,yt=-33554433,Bt=-33292289,Rt=-3.141592653589793,kt=4194303,xt=3072,Et={60:1,4:1,5:1},Ft=.7853981633974483,Qt=3.061592653589793,zt=1073741824,St=541165879296,Xt={17:1,4:1,5:1,7:1},Gt=281.17,Yt=289.19,qt=294.21,Vt="0.0000",vt="M  END\n",Zt="ATOMS",Ot=-2147483648,Kt="M  END",Wt="$$$$",_t="M  V30 ",$t="M  V30 COUNTS ",ne=")\n",te="M  V30 MDLV30/STEREL",ee="M  V30 MDLV30/STERAC",ie=34028234663852886e22,ae={l:2,m:0,h:4},se=4194304,re={l:4179966,m:4063288,h:7},oe={l:4194302,m:4193343,h:7},fe={90:1,85:1,99:1,4:1,9:1,5:1,7:1},le='" ',de='stroke="',ge='stroke-width="',ue='" />',ce='class="event" ',be='opacity="0" />',he=16711680,De="Assignment of aromatic double bonds failed",He="' position:",je="'. Position:",me=1099511627776,Ae=2199023255552,Ce=4398046511104,pe="', position:",Me={117:1,4:1},Ie="Members of ESR groups must only be stereo centers with known configuration.",Pe="Over- or under-specified stereo feature or more than one racemic type bond",Te="Ambiguous configuration at stereo center because of 2 parallel bonds",Ne={98:1,115:1,26:1,4:1},we=1e5,Ue="style",Je=3.1415927410125732,Le=1.5707963705062866,ye=.029999999329447746,Be=6.2831854820251465,Re=1.9106119871139526,ke=2.2639999389648438,xe=2.16759991645813,Ee=2.0662999153137207,Fe=2.3561999797821045,Qe=2.2844998836517334,ze=1.9106120066311025,Se=2.094395160675049,Xe=.6000000238418579,Ge=1.7999999523162842,Ye=.05000000074505806,qe={4:1,9:1,5:1,7:1,48:1},Ve=.2617993950843811,ve=2.0943951023931953,Ze=1.2000000476837158,Oe=1.4299999475479126,Ke=1.659999966621399,We=1.4600000381469727,_e=1.8200000524520874,$e=2.4600000381469727,ni=2.4200000762939453,ti=2.450000047683716,ei=2.440000057220459,ii=2.4000000953674316,ai=2.319999933242798,si=2.2899999618530273,ri=1.8600000143051147,oi=2.5299999713897705,fi=2.490000009536743,li=2.4700000286102295,di=2.880000114440918,gi=2.9200000762939453,ui=2.869999885559082,ci=2.8299999237060547,bi=2.7899999618530273,hi=2.809999942779541,Di=2.799999952316284,Hi=3.049999952316284,ji=.3199999928474426,mi=1.3300000429153442,Ai=1.3899999856948853,Ci=1.159999966621399,pi=1.1100000143051147,Mi=1.0700000524520874,Ii=1.9600000381469727,Pi=1.7100000381469727,Ti=1.3600000143051147,Ni=1.340000033378601,wi=1.2200000286102295,Ui=1.2400000095367432,Ji=1.2100000381469727,Li=1.850000023841858,yi=1.6299999952316284,Bi=1.4700000286102295,Ri=1.2799999713897705,ki=1.440000057220459,xi=1.399999976158142,Ei=1.7599999904632568,Fi=1.7300000190734863,Qi=1.7200000286102295,zi=1.6799999475479126,Si=1.690000057220459,Xi=1.6699999570846558,Gi=1.649999976158142,Yi=1.7000000476837158,qi=1.6200000047683716,Vi=1.3700000047683716,vi=1.2899999618530273,Zi=1.4500000476837158,Oi=1.5700000524520874,Ki=-.5235987755982988,Wi=-1.0471975511965976,_i=-.7853981633974483,$i=.017453292519943295,na=.17453292519943295,ta=1e-4,ea={169:1},ia=57.29577951308232,aa=.021922173386725217,sa=1e-8,ra=2.5120960256267386,oa=1e-5,fa="MMFF94s+",la="nonbonded cutoff",da="dielectric constant",ga="dielectric model",ua="angle bend",ca="bond stretch",ba="electrostatic",ha="out of plane",Da="stretch bend",Ha="torsion angle",ja="van der waals",ma={4:1,9:1,5:1,11:1,7:1},Aa=.07000000000000006,Ca=.1200000000000001,pa=-7.840000000000001,Ma="OCL_RXN_V1.0:",Ia="'$MOL' tag not found",Pa="'M  END' not found",Ta="\nActelion Java MolfileCreator 2.0\n\n  0  0  0  0  0  0              0 V3000\n",Na="M  V30 END CTAB",wa=2475109711874,Ua=2475109711875,Ja=2887426572290,La=2887426572291,ya=2887627898882,Ba=2887627898883,Ra=2887627997186,ka=3437182386178,xa=3437182386179,Ea=3437383712770,Fa=3437383811074,Qa=3437652148226,za=3437652377602,Sa=4674132967426,Xa=4674334294018,Ga=4674334392322,Ya=4674602729474,qa=4674602958850,Va=5086449827842,va=5086449827848,Za=5086651154434,Oa=5086651252738,Ka=5086651252743,Wa=5086919589890,_a=5086919688194,$a=5636406968322,ns=5636407066626,ts=5636675502082,es={l:589826,m:590112,h:4},is={l:589827,m:590112,h:4},as={l:589826,m:590160,h:4},ss={l:589827,m:590160,h:4},rs={l:688130,m:590160,h:4},os={l:589826,m:590224,h:4},fs={l:589827,m:590224,h:4},ls={l:819203,m:590224,h:4},ds={l:589826,m:590368,h:4},gs={l:688130,m:590368,h:4},us={l:819202,m:590368,h:4},cs={l:819208,m:590368,h:4},bs={l:589826,m:590416,h:4},hs={l:589832,m:590416,h:4},Ds={l:688130,m:590416,h:4},Hs={l:819202,m:590416,h:4},js={l:589826,m:598304,h:4},ms={l:589827,m:598304,h:4},As={l:688130,m:598304,h:4},Cs={l:1114114,m:598304,h:4},ps={l:1212418,m:598304,h:4},Ms={l:589826,m:598308,h:4},Is={l:589826,m:688416,h:4},Ps={l:589826,m:688464,h:4},Ts={l:589826,m:688720,h:4},Ns={l:688130,m:688720,h:4},ws={l:589826,m:590112,h:288},Us={l:589826,m:590112,h:336},Js={l:589826,m:688416,h:336},Ls={l:589826,m:688464,h:336},ys={l:688130,m:688464,h:336},Bs={l:589826,m:590112,h:400},Rs={l:589826,m:688416,h:400},ks={l:589826,m:688464,h:400},xs={l:688130,m:688464,h:400},Es={l:589826,m:819488,h:400},Fs={l:589826,m:819536,h:400},Qs={l:589826,m:819600,h:400},zs={l:688130,m:819600,h:400},Ss={l:819202,m:819600,h:400},Xs={l:589831,m:688416,h:592},Gs={l:589831,m:688464,h:592},Ys={l:688135,m:688464,h:592},qs={l:589831,m:819536,h:592},Vs={l:688135,m:819536,h:592},vs={l:688135,m:819600,h:592},Zs={l:589832,m:1212704,h:592},Os={l:589832,m:1212752,h:592},Ks={l:688136,m:1212752,h:592},Ws={l:589831,m:688464,h:656},_s={l:589826,m:590112,h:8480},$s={l:589826,m:688416,h:8480},nr={l:589826,m:688464,h:8480},tr={l:688130,m:688464,h:8480},er={l:819202,m:819600,h:8480},ir={l:688135,m:1212752,h:8480},ar={l:589832,m:1213008,h:8480},sr={l:688136,m:1213008,h:8480},rr={l:589826,m:590112,h:8484},or={l:589826,m:590160,h:8484},fr={l:688130,m:598304,h:8484},lr=.6262000203132629,dr=-1.3825000524520874,gr=.33169999718666077,ur=-1.4915000200271606,cr=.3540000021457672,br=.38179999589920044,hr=-.6019999980926514,Dr=.07999999821186066,Hr=-.7379999756813049,jr="Atom-types are 64-bit numbers describing atoms and their near surrounding.",mr="Recognized atom types and their contributions are:",Ar="Druglikeness predictor not properly initialized.",Cr=3.009999990463257,pr=-.17000000178813934,Mr=-.1809999942779541,Ir=-.2029999941587448,Pr=2147483648,Tr="MMFF94",Nr="MMFF94s",wr="117\nint,int,int,int,float\n0,2,0,0,0.020\n1,2,1,2,0.030\n1,2,2,2,0.027\n1,2,2,3,0.026\n1,2,2,5,0.013\n1,2,2,37,0.032\n2,2,2,5,0.013\n2,2,3,5,0.012\n2,2,5,5,0.006\n2,2,5,6,0.027\n2,2,5,37,0.017\n2,2,5,40,0.012\n2,2,5,41,0.008\n0,3,0,0,0.130\n1,3,1,7,0.146\n1,3,2,7,0.138\n1,3,3,7,0.134\n1,3,5,7,0.122\n1,3,6,7,0.141\n1,3,7,10,0.129\n1,3,7,37,0.138\n2,3,5,7,0.113\n2,3,5,9,0.081\n2,3,6,7,0.127\n2,3,7,10,0.116\n3,3,5,7,0.113\n3,3,6,7,0.127\n5,3,5,7,0.103\n5,3,5,9,0.074\n5,3,5,54,0.078\n5,3,6,7,0.119\n5,3,7,10,0.102\n5,3,9,40,0.067\n6,3,7,37,0.127\n7,3,10,10,0.113\n7,3,20,20,0.151\n9,3,40,40,0.057\n0,8,0,0,0.000\n0,10,0,0,0.015\n1,10,1,3,0.015\n1,10,3,6,0.015\n1,10,3,28,0.015\n3,10,3,28,0.015\n3,10,28,28,0.015\n0,17,0,0,0.000\n0,26,0,0,0.000\n0,30,0,0,0.010\n5,30,20,30,0.008\n0,37,0,0,0.035\n1,37,37,37,0.040\n2,37,37,37,0.031\n3,37,37,37,0.027\n5,37,37,37,0.015\n5,37,37,38,0.046\n5,37,37,63,0.008\n5,37,37,64,0.012\n5,37,37,69,0.016\n5,37,38,38,0.084\n6,37,37,37,0.048\n15,37,37,37,0.025\n37,37,37,40,0.046\n0,39,0,0,0.020\n1,39,63,63,0.012\n23,39,63,63,-0.014\n23,39,63,65,0.021\n23,39,65,65,0.062\n0,40,0,0,0.030\n1,40,28,37,0.030\n2,40,28,28,0.030\n3,40,28,28,0.030\n28,40,28,37,0.030\n0,41,0,0,0.180\n1,41,32,32,0.178\n2,41,32,32,0.161\n5,41,32,32,0.158\n0,43,0,0,0.000\n0,45,0,0,0.150\n0,49,0,0,0.000\n50,49,50,50,0.000\n0,54,0,0,0.020\n1,54,3,36,0.016\n3,54,36,36,0.018\n0,55,0,0,0.020\n1,55,36,57,0.020\n36,55,36,57,0.020\n0,56,0,0,0.020\n1,56,36,57,0.020\n36,56,36,57,0.020\n0,57,0,0,0.080\n5,57,55,55,0.038\n56,57,56,56,0.158\n0,58,0,0,0.025\n0,63,0,0,0.050\n5,63,39,64,0.019\n5,63,39,66,0.068\n5,63,44,64,0.014\n5,63,44,66,0.055\n5,63,59,64,0.033\n5,63,59,66,0.085\n37,63,39,64,0.010\n0,64,0,0,0.040\n5,64,63,64,0.006\n5,64,63,66,0.043\n5,64,64,65,0.052\n5,64,65,66,0.094\n37,64,63,64,-0.01\n0,67,0,0,0.070\n0,69,0,0,0.070\n32,69,37,37,0.067\n0,73,0,0,0.000\n0,78,0,0,0.045\n5,78,78,81,0.046\n0,80,0,0,0.080\n5,80,81,81,0.057\n0,81,0,0,0.025\n36,81,78,80,0.016\n0,82,0,0,0.000\n",Ur={197:1,4:1,5:1,7:1},Jr="div",Lr="position:absolute;left:",yr="px;",Br="rgba(",Rr=4278190080,kr="px",xr={204:1},Er={384:1,25:1},Fr={385:1,25:1},Qr="position:absolute;width:",zr="px;height:",Sr={46:1,4:1,5:1,7:1},Xr=22.5,Gr=21.176470588235293,Yr={206:1,25:1},qr={207:1,25:1},Vr={253:1,25:1},vr={371:1,25:1},Zr="true",Or="data-idcode",Kr="MutationObserver",Wr="Parse exception ",_r="error setting idcode data ",$r={251:1,25:1},no={103:1,25:1},to="data:image/gif;base64,R0lGODlhHABGANUAAISChPLx8ubl5uDf4NLR0s/OzwAA//Hx8tHR0svLzMXFxuvs7OXm5t/g4MvMzAD/APf49+vs6+Xm5dfY18vMy/j49/Ly8enp6ODg38bGxdbTzv8AAPj39+zr68bFxcC/v/////39/fr6+vf39/T09PHx8e7u7uzs7Obm5uPj4+Dg4N3d3dra2tfX19TU1NHR0czMzMvLy8nJycbGxsPDw8DAwL29vbq6uqqqqiEhIQAAAAAAAAAAAAAAAAAAAAAAACwAAAAAHABGAAAG/0CQcEgsGo0AkGbJbDqfzqQGQK1ar1iqUgrIeb/gsFi33eZAp7R6zV6Tp+bTzfahzWSUAsLVYq02KQIXEThvXDknNjU0GTIxBS98fhuUFwsmhWVTiIsKjpCSf5SUJhaZcJsnNJ4OeqEqo6Mkp4cnHp+RE36wsaO0cTIwrn0rDb2jIr+pCQUEoQPHlCIhyl0nw34DKccc0yDViLl+GNu9I97fhnGv5bHdIUPgJ8Qq5To6GyTn8PHqqbspJFC6pw9dP03Wit27t2GhDngO0yFEVI9BQx0H7omIeBCVtRQoHJK4F+IeiIVC5Am4Z+IeBJMmhZiUd8Ghjo0oOco7YeIACf8IBo9I9IgIh9GjSJMi9ddFjFOnTM+0mdomqhw6dvBgW2Eg0CB5ihjhCmWgrCVMVjuNJVa2bSl5q2S02kOvbdtZVm89ErdChV278oJtbfC3bTKrzJwRG1C47DR5W7UVfje0Fl9yhfeltMpuskF59FL8Lchv88QTACXYJV1EXrFAq1GenGm1YlufJGGSqRwH5IWyAfTpnm2a6AlBHUyU+ImTeEyaPJdX8Cb7uVWePoGWFipPqXelUZ+K/xIVDdXzJ6zOqXMnD10/D7wSshq20d5QD/Kflaf2PrH8AL5lVVxzvQIggHidphcouvR14IGBCfNeMQ8CeNhpiT1TYX6PWRVvWQoVUibPZSA+qBlvqbAT4mdWhfbgSLKhaE1qB8JY0m4yIvKaADUCFWOOJ1QEoE/n/Aikb/kFVyQZNgGJnHLM3SiTdaddEB0J0/FjE22nYRelUB3V8t2YRjG15Zlo+gPmmkWgAsWbcMKRxZx0VhEEADs=",eo="data:image/gif;base64,R0lGODlhHABGANUAAISChH59fnt6e3h3eHRzdMTDxLi3uJiXmAAAw3d3eLe3uKamp5eXmI+PkIaGh4ODhH1+fsPExLe4uJGSkgDDAM/Qz8DBwHh4d76+vZ6enZiYl4qKidbTzsMAANDPz8fGxqSjo5KRkYqJiYSDg////9LS0svLy76+vru7u7i4uLW1tbKysq+vr6ysrKmpqaOjo6GhoZubm5iYmJWVlZKSko+Pj4yMjImJiYSEhIODg4CAgHh4eG9vb19fXyEhIQAAACwAAAAAHABGAAAG/0CScEgsGo0AEmfJbDqfziQHQK1ar1iqUgrweb/gsPi33YrPaF956qXx3vC4PL7u+t4EQkIQ0AEcNzY1NB0HMRkwPXVePHk7fDojgIKEHR2IL4pTZncEAwIQOjkOIpSWpyALmlyMF5A4k4Mzp6cuq5w8kA+xNLO0p7dsd6GjgbK/pyzBdjyRvL7ILCvLjLvGEzMayC3SKtR3DhuCITMy290p3zzGvQznKyoKKOqU2ZY/Px0u3PAGKCfqGvSSEePej33d/J2woK4XPnwdHv6AJ7GAunIF8S3Ax0IiBgsFPqjTEEOiC3wr8KF4+MGEupI/XuBrgU8FvoUR8LlcdCeDxP8fHR9ikGjCgzoYLxYghCcBxceQJkxUKKGuh9WrWLNi5Zmmq5pNwtzMGSuHJx49kP6wQ2AIkTpHkCStRYAA09tHxEhRoss3lTpXfWCxm8GXry2zup4VLqwu7+DFfJWZdfYYMgJp6qwJwqYBMj9vZsONK+cZnbrBDErDk0dPVufCS1UoDDgwBuzPChmarQ37oYoUDy2axchXKUqV+EKOPERXKc0fNn+cwNfyJSbnQQ3gs6BzJ1hmiFLFfghSp1GzSLEzdQqypVSqZrXK18rVKxqeYsnqN9sIbR+1lFDQViJmwdWHXAFSQIFdBX6SVymDKCihX2YBpoNg9Ugo4WHfMZKO2GAaatiYKM+EKKFkHd5BWYYmUoCZWZrVwJmJn6kjWg3kyECjaWahtuNq85hVjwYhnvTQbGYJhJGGRqb0wz+6pchDbUxy8xB7wkm5pILYXfmUSGaRlAGXCOEDHFHWpbeUStN1p0546v32Ez7nSanmZ019GdVUy/xwx3yAWrXGEYQWChYUiCa6SRaMNlpFEAA7",io=21.333333333333332,ao={239:1,25:1},so="width",ro="height",oo="offsetHeight",fo="offsetWidth",lo="Null widget handle. If you are creating a composite, ensure that initWidget() has been called.",go="Style names cannot be empty",uo="aria-hidden",co={43:1,37:1,40:1,39:1,44:1,35:1,34:1},bo={43:1,37:1,40:1,39:1,44:1,35:1,34:1,30:1},ho="left",Do="visibility",Ho="hidden",jo="visible",mo="popupContent",Ao=1281818470,Co={24:1},po={168:1,24:1},Mo=23.333333333333332,Io=4294967295,Po="font: 12px sans-serif",To="Atom Properties",No="cellPadding",wo="Cancel",Uo="excluded atoms:",Jo="allowed atoms:",Lo="200px",yo="any ring state",Bo={326:1,25:1},Ro="disabled",ko="px Helvetica",xo="Helvetica",Eo="canvas",Fo="undefined",Qo=.08726646502812703,zo=4278190335,So=5e-324,Xo={90:1,85:1,4:1,9:1,5:1,7:1},Go=.003921568859368563,Yo="CENTER",qo="position",Vo="absolute",vo="CSS1Compat",Zo={38:1,31:1,4:1,19:1,20:1},Oo={36:1,31:1,4:1,19:1,20:1},Ko={31:1,86:1,4:1,19:1,20:1},Wo={59:1,4:1,19:1,20:1},_o="load",$o="touchcancel",nf="touchstart",tf={147:1,4:1,18:1,28:1},ef='Too many percent/per mille characters in pattern "',af=1048575,sf=17592186044416,rf=1e9,of=-17592186044416,ff=16777216,lf="__gwtLastUnhandledEvent",df="__uiObjectID",gf="cellSpacing",uf="Column index: ",cf=", Column size: ",bf="Row index: ",hf=", Row size: ",Df="overflow",Hf={43:1,37:1,40:1,39:1,44:1,183:1,35:1,34:1,30:1},jf={89:1,4:1,19:1,20:1},mf=5.56,Af=11.12,Cf=13.34,pf=14.44,Mf=.3010299956639812,If="BigInteger divide by zero",Pf={l:0,m:0,h:524288},Tf={19:1,134:1},Nf={151:1},wf={30:1,61:1,62:1,132:1},Uf="delete",Jf=15525485,Lf=5.960464477539063e-8,yf={4:1,151:1},Bf={4:1,19:1,20:1,93:1},Rf="Invalid UTF8 sequence",kf=.20000000298023224,xf=" distance:",Ef="gGP`@dfyjidNcGI[WQCP`<",Ff={65:1},Qf={},zf={},Sf={},Xf={},Gf={},Yf={},qf={},Vf={},vf={},Zf={},Of={},Kf={},Wf={},_f={},$f={},nl={},tl={},el={},il={},al={},sl={},rl={},ol={},fl={},ll={},dl={},gl={},ul={},cl={},bl={},hl={},Dl={},Hl={},jl={},ml={},Al={},Cl={},pl={},Ml={},Il={},Pl={},Tl={},Nl={},wl={},Ul={},Jl={},Ll={},yl={},Bl={},Rl={},kl={},xl={},El={},Fl={},Ql={},zl={},Sl={},Xl={};function Gl(){}function Yl(n){return Array.isArray(n)&&n.ie===Gl?zf.Mc(n):n.toString()}function ql(t,e){var i=n;if(""===t)return i;var a,s=t.split(".");(!(s[0]in i)&&i.execScript&&i.execScript("var "+s[0]),e)&&(e.prototype.ge.e=e);for(;s.length&&(a=s.shift());)i=i[a]=i[a]||!s.length&&e||{};return i}function Vl(n,t,e){var i=function(){return n.apply(i,arguments)};return t.apply(i,e),i}function vl(){}function Zl(n,t){for(var e in t)t[e].configurable=!0;Object.defineProperties(n,t)}function Ol(n,t,e){var i=f,a=i[n],s=Qf.mzb(a);a&&!s?o=a:((o=Qf.hzb(t)).he=e,!t&&(o.ie=Gl),i[n]=o);for(var r=3;r<arguments.length;++r)arguments[r].prototype=o;s&&(o.ge=s)}function Kl(){}function Wl(n,t){return Qf.mlb(n,t)}function _l(n,t,e,i,a,s){return Qf.qlb(n,t,e,i,a,0,s)}function $l(n,t,e,i,a,s){var r;return r=Qf.slb(a,i),10!=a&&ed(Wl(n,s),t,e,a,r),r}function nd(n){return Array.isArray(n)&&n.ie===Gl}function td(n,t,e){return Qf.ulb(n,t,e)}function ed(n,t,e,i,a){return Qf.wlb(a,n),a.he=t,a.ie=Gl,Qf.ylb(a,e),Qf.xlb(a,i),a}function id(n){return String.fromCharCode(n)}function ad(n){return!Array.isArray(n)&&n.ie===Gl}function sd(n,t){return null!=n&&function(n,t){return dd(n)?!!u[t]:n.he?!!n.he[t]:od(n)?!!g[t]:!!rd(n)&&!!d[t]}(n,t)}function rd(n){return typeof n===A}function od(n){return typeof n===C}function fd(n){return null!=n&&Qf.Emb(n)&&!(n.ie===Gl)}function ld(n,t){return Qf.Fmb(n,t)}function dd(n){return typeof n===p}function gd(n){return null==n?null:n}function ud(n){return 0|Math.max(Math.min(n,I),-2147483648)}function cd(n){var t;return sd(n,28)?n:((t=Qf.qyb(n))||(t=new Sf.K9(n),Xf.Hab(t)),t)}function bd(n){return n.backingJsObject}function hd(n){var t;return t=zf.FHb(n),zf.THb(n,t),t}function Dd(n,t){var e;return e=zf.FHb(n),zf.THb(n,e),e.f=t?8:0,e}function Hd(n){var t;return(t=zf.FHb(n)).k=n,t.f=1,t}Qf.pyb=function(){},Qf.czb=function(){null==l&&(l=[])},Qf.azb=function(){},Qf.nzb=function(n){function t(){}return t.prototype=n||{},new t},Qf.mzb=function(n){return n instanceof Array?n[0]:null},Qf.hzb=function(n){var t=n&&n.prototype;return!t&&(t=f[n]),Qf.nzb(t)},Qf.gzb=function(){},n.goog=n.goog||{},n.goog.global=n.goog.global||n,f={},zf.Bc=function(n,t){return gd(n)===gd(t)},zf.Cc=function(n){return n.ge},zf.Dc=function(n){return Gf.gVb(n)},zf.Gc=function(n,t){return dd(n)?zf.pJb(n,t):od(n)?zf.eIb(n,t):rd(n)?zf.ZGb(n,t):ad(n)?n.ib(t):nd(n)?zf.Bc(n,t):Sf.n4(n,t)},zf.Ic=function(n){return dd(n)?zf.rJb():od(n)?zf.fIb():rd(n)?zf.$Gb():ad(n)?n.ge:nd(n)?zf.Cc(n):Sf.o4(n)},zf.Kc=function(n){return dd(n)?zf.sJb(n):od(n)?zf.gIb(n):rd(n)?zf._Gb(n):ad(n)?n.kb():nd(n)?zf.Dc(n):Sf.p4(n)},zf.Mc=function(n){return zf.AHb(zf.Ic(n))+"@"+Gf.zVb(Gf.yVb(zf.Kc(n))).toString(16)},Ol(1,null,{},Kl),o.ib=function(n){return zf.Bc(this,n)},o.jb=function(){return zf.Cc(this)},o.kb=function(){return zf.Dc(this)},o.lb=function(){return zf.AHb(zf.Ic(this))+"@"+Gf.zVb(Gf.yVb(zf.Kc(this))).toString(16)},o.equals=function(n){return this.ib(n)},o.hashCode=function(){return this.kb()},o.toString=function(){return this.lb()},Sf.n4=function(n,t){return Sf.t4(n)?Sf.q4(n,t):gd(n)===gd(t)},Sf.o4=function(n){return n.ge||Array.isArray(n)&&Wl(Qf.dsb,1)||Qf.dsb},Sf.p4=function(n){return Sf.u4(n)?Sf.r4(n):Gf.gVb(n)},Sf.q4=function(n,t){return n.equals(t)},Sf.r4=function(n){return n.hashCode()},Sf.s4=function(){return[]},Sf.t4=function(n){return!!n&&!!n.equals},Sf.u4=function(n){return!!n&&!!n.hashCode},Sf.v4=function(n){return n.toString?n.toString():"[JavaScriptObject]"},Xf.Gab=function(){var n,t;Xf.Gab=vl,t=!Xf.Pab(),n=new Xf.Yab,Xf.Fab=t?new Xf.Qab:n},Xf.Hab=function(n){Xf.Gab(),Xf.Fab.ud(n)},Xf.Iab=function(n){var t;return Xf.Gab(),t=Xf.Fab.vd(n),Xf.Jab(t)},Xf.Jab=function(t){var e;for(e=n.Math.min(t.length,5)-1;e>=0;e--)if(zf.pJb(t[e].d,"Hab")||zf.pJb(t[e].d,"Xz")){t.length>=e+1&&Gf.zVb(t).splice(0,e+1);break}return t},Xf.Kab=function(n){var t=/function(?:\s+([\w$]+))?\s*\(/.exec(n);return t&&t[1]||h},Xf.Lab=function(n){return Xf.Gab(),n&&n[D]?n[D]:[]},Xf.Mab=function(n){return Xf.Gab(),n.name||(n.name=Xf.Kab(n.toString()))},Xf.Nab=function(n){return Xf.Gab(),parseInt(n)||-1},Xf.Oab=function(n){Xf.Gab();var t=n.backingJsObject;if(t&&t.stack){var e=t.stack,i=t+H;return e.substring(0,i.length)==i&&(e=e.substring(i.length)),e.split(H)}return[]},Xf.Pab=function(){return Error.stackTraceLimit>0?(n.Error.stackTraceLimit=Error.stackTraceLimit=64,!0):"stack"in new Error},Ol(665,1,{}),Xf.Qab=function(){},Ol(395,665,{},Xf.Qab),o.ud=function(n){var t={},e=[];n[D]=e;for(var i=arguments.callee.caller;i;){var a=Xf.Mab(i);e.push(a);var s,r,o=":"+a,f=t[o];if(f)for(s=0,r=f.length;s<r;s++)if(f[s]===i)return;(f||(t[o]=[])).push(i),i=i.caller}},o.vd=function(n){var t,e,i,a;for(i=Xf.Lab(n),e=Sf.V9(i),a=$l(Qf.vwb,j,96,e,0,1),t=0;t<e;t++)a[t]=new zf.dJb(Sf.U9(i,t),null,-1);return a},Xf.Tab=function(n,t){var e,i,a,s,r,o,f,l,d;return l="",0==Gf.zVb(t).length?n.wd(m,h,-1,-1):(d=zf.EJb(t),zf.pJb(Gf.zVb(d).substr(0,3),"at ")&&(Gf.uVb(3,Gf.zVb(d).length+1),d=Gf.zVb(d).substr(3)),d=Xf.Uab(d),-1==(r=Gf.zVb(d).indexOf("("))?-1==(r=Gf.zVb(d).indexOf("@"))?(l=d,d=""):(l=zf.EJb((Gf.uVb(r+1,Gf.zVb(d).length+1),Gf.zVb(d).substr(r+1))),d=zf.EJb((Gf.tVb(0,r,Gf.zVb(d).length),Gf.zVb(d).substr(0,r)))):(e=Gf.zVb(d).indexOf(")",r),Gf.tVb(r+1,e,Gf.zVb(d).length),l=Gf.zVb(d).substr(r+1,e-(r+1)),d=zf.EJb((Gf.tVb(0,r,Gf.zVb(d).length),Gf.zVb(d).substr(0,r)))),-1!=(r=zf.tJb(d,pd(46)))&&(Gf.uVb(r+1,Gf.zVb(d).length+1),d=Gf.zVb(d).substr(r+1)),(0==Gf.zVb(d).length||zf.pJb(d,"Anonymous function"))&&(d=h),o=zf.wJb(l,pd(58)),a=zf.xJb(l,pd(58),o-1),f=-1,i=-1,s=m,-1!=o&&-1!=a&&(Gf.tVb(0,a,Gf.zVb(l).length),s=Gf.zVb(l).substr(0,a),f=Xf.Nab((Gf.tVb(a+1,o,Gf.zVb(l).length),Gf.zVb(l).substr(a+1,o-(a+1)))),i=Xf.Nab((Gf.uVb(o+1,Gf.zVb(l).length+1),Gf.zVb(l).substr(o+1)))),n.wd(s,d,f,i))},Xf.Uab=function(n){return n.replace(/\[.*?\]/g,"")},Ol(666,665,{}),o.ud=function(n){},o.wd=function(n,t,e,i){return new zf.dJb(t,n+"@"+i,e<0?-1:e)},o.vd=function(n){var t,e,i,a,s,r;if(a=Xf.Oab(n),s=$l(Qf.vwb,j,96,0,0,1),t=0,0==(i=Sf.V9(a)))return s;for(r=Xf.Tab(this,Sf.U9(a,0)),zf.pJb(r.d,h)||(s[t++]=r),e=1;e<i;e++)s[t++]=Xf.Tab(this,Sf.U9(a,e));return s},Xf.Yab=function(){},Ol(396,666,{},Xf.Yab),o.wd=function(n,t,e,i){return new zf.dJb(t,n,-1)},Qf.klb=function(n){return n},Qf.mlb=function(n,t){return zf.LHb(n,t)},Qf.nlb=function(n){return null==n.__elementTypeCategory$?10:n.__elementTypeCategory$},Qf.olb=function(n){return n.__elementTypeId$},Qf.qlb=function(n,t,e,i,a,s,r){var o,f,l,d,g;if(d=a[s],o=(l=s==r-1)?i:0,g=Qf.slb(o,d),10!=i&&ed(Wl(n,r-s),t[s],e[s],o,g),!l)for(++s,f=0;f<d;++f)Qf.ulb(g,f,Qf.qlb(n,t,e,i,a,s,r));return g},Qf.slb=function(n,t){var e,i=new Array(t);switch(n){case 14:case 15:e=0;break;case 16:e=!1;break;default:return i}for(var a=0;a<t;++a)i[a]=e;return i},Qf.ulb=function(n,t,e){return n[t]=e},Qf.wlb=function(n,t){n.ge=t},Qf.xlb=function(n,t){n.__elementTypeCategory$=t},Qf.ylb=function(n,t){n.__elementTypeId$=t},Qf.Alb=function(n,t){return 10!=Qf.nlb(t)&&ed(zf.Ic(t),t.he,Qf.olb(t),Qf.nlb(t),n),Qf.klb(n)},Qf.Emb=function(n){return typeof n===b||typeof n===M},Qf.Fmb=function(n,t){return n&&t&&n instanceof t},Qf.qyb=function(n){return n&&n.__java$exception},zf.VGb=function(){zf.VGb=vl,c=Gf.zVb(!1),Gf.zVb(!0)},zf.WGb=function(n){return Gf.AVb((Gf.oVb(n),n))},zf.XGb=function(n,t){return function(n,t){return zf.VGb(),n==t?0:n?1:-1}(Gf.AVb((Gf.oVb(n),n)),Gf.AVb((Gf.oVb(t),t)))},zf.YGb=function(n,t){return zf.XGb(n,t)},zf.ZGb=function(n,t){return Gf.oVb(n),n===t},zf.$Gb=function(){return Qf.dwb},zf._Gb=function(n){return Gf.AVb((Gf.oVb(n),n))?1231:1237},zf.cHb=function(n,t){return zf.VGb(),dd(n)?zf.iJb(n,t):od(n)?zf.cIb(n,t):rd(n)?zf.YGb(n,t):n.Eb(t)},d={4:1,386:1,19:1},zf.yHb=function(n){n.i=md++},zf.zHb=function(n){null==n.n&&zf.PHb(n)},zf.AHb=function(n){return zf.zHb(n),n.n},zf.BHb=function(n){return!!(4&n.f)},zf.CHb=function(n){return!!(1&n.f)},zf.DHb=function(){zf.yHb(this),this.n=null,this.j=null,this.g=null,this.d=null,this.b=null,this.k=null,this.a=null},zf.FHb=function(n){var t;return(t=new zf.DHb).n="Class$"+(n?"S"+n:""+t.i),t.b=t.n,t.j=t.n,t},zf.LHb=function(n,t){var e=n.a=n.a||[];return e[t]||(e[t]=n.Ld(t))},zf.PHb=function(n){if(n.Pd()){var t=n.c;return t.Qd()?n.n="["+t.k:t.Pd()?n.n="["+t.Nd():n.n="[L"+t.Nd()+";",n.b=t.Md()+"[]",void(n.j=t.Od()+"[]")}var e=n.g,i=n.d;i=i.split("/"),n.n=zf.SHb(".",[e,zf.SHb("$",i)]),n.b=zf.SHb(".",[e,zf.SHb(".",i)]),n.j=i[i.length-1]},zf.SHb=function(n,t){for(var e=0;!t[e]||""==t[e];)e++;for(var i=t[e++];e<t.length;e++)t[e]&&""!=t[e]&&(i+=n+t[e]);return i},zf.THb=function(n,t){if(n){t.k=n;var e=function(n){if(n.Qd())return null;var t=n.k;return f[t]}(t);e?e.ge=t:f[n]=[t]}},Ol(240,1,{},zf.DHb),o.Ld=function(n){var t;return(t=new zf.DHb).f=4,t.c=n>1?zf.LHb(this,n-1):this,t},o.Md=function(){return zf.zHb(this),this.b},o.Nd=function(){return zf.AHb(this)},o.Od=function(){return zf.zHb(this),this.j},o.Pd=function(){return zf.BHb(this)},o.Qd=function(){return zf.CHb(this)},o.lb=function(){return(2&this.f?"interface ":1&this.f?"":"class ")+(zf.zHb(this),this.n)},o.f=0,o.i=0;var jd,md=1;function Ad(n,t){return n<t?-1:n>t?1:n==t?0==n?Ad(1/n,1/t):0:isNaN(n)?isNaN(t)?0:1:-1}function Cd(n){return isNaN(n)?{l:0,m:0,h:524160}:Gf.vVb(n)}function pd(n){var t,e;return n>=y?(t=55296+(n-y>>10&1023)&B,e=56320+(n-y&1023)&B,String.fromCharCode(t)+""+String.fromCharCode(e)):String.fromCharCode(n&B)}function Md(n,t){this.b=n,this.c=t}zf.YHb=function(t){return zf.pJb(C,typeof t)||ld(t,n.java.lang.Number$impl)},zf.ZHb=function(n){if(null==zf.XHb&&(zf.XHb=new RegExp("^\\s*[+-]?(NaN|Infinity|((\\d+\\.?\\d*)|(\\.\\d+))([eE][+-]?\\d+)?[dDfF]?)\\s*$")),!zf.XHb.test(n))throw bd(new zf.cJb(P+n+'"'));return parseFloat(n)},zf.$Hb=function(n,t,e){var i,a,s,r;if(null==n)throw bd(new zf.cJb(T));for(i=(s=Gf.zVb(n).length)>0&&(Gf.uVb(0,Gf.zVb(n).length),45==Gf.zVb(n).charCodeAt(0)||(Gf.uVb(0,Gf.zVb(n).length),43==Gf.zVb(n).charCodeAt(0)))?1:0;i<s;i++)if(-1==ng((Gf.uVb(i,Gf.zVb(n).length),Gf.zVb(n).charCodeAt(i))))throw bd(new zf.cJb(P+n+'"'));if(a=(r=parseInt(n,10))<t,isNaN(r))throw bd(new zf.cJb(P+n+'"'));if(a||r>e)throw bd(new zf.cJb(P+n+'"'));return r},zf._Hb=function(n){return od(n)?zf.dIb(n):n.Rd()},zf.aIb=function(n){return od(n)?zf.hIb(n):n.Sd()},Ol(143,1,{4:1,143:1}),zf.bIb=function(n,t){return Ad(Gf.BVb((Gf.oVb(n),n)),Gf.BVb((Gf.oVb(t),t)))},zf.cIb=function(n,t){return zf.bIb(n,t)},zf.dIb=function(n){return Gf.BVb((Gf.oVb(n),n))},zf.eIb=function(n,t){return Gf.oVb(n),gd(n)===gd(t)},zf.fIb=function(){return Qf.gwb},zf.gIb=function(n){return ud(Gf.BVb((Gf.oVb(n),n)))},zf.hIb=function(n){return ud(Gf.BVb((Gf.oVb(n),n)))},g={4:1,19:1,393:1,143:1},zf.Cz=function(n){n.i=$l(Qf.vwb,j,96,0,0,1)},zf.Dz=function(n,t){Gf.pVb(t,"Cannot suppress a null exception."),Gf.iVb(t!=n,"Exception can not suppress itself."),n.g||(null==n.j?n.j=ed(Wl(Qf.Awb,1),j,28,0,[t]):n.j[n.j.length]=t)},zf.Ez=function(n){Xf.Hab(n)},zf.Fz=function(n){return Xf.Iab(n)},zf.Gz=function(n){return n.k&&(n.backingJsObject!==N&&n.Xb(),n.i=null),n},zf.Hz=function(n){return n.e},zf.Iz=function(n,e){if(e instanceof Object)try{if(e.__java$exception=n,-1!=i.userAgent.toLowerCase().indexOf("msie")&&t.documentMode<9)return;var a=n;Object.defineProperties(e,{cause:{get:function(){var n=a.Vb();return n&&n.Tb()}},suppressed:{get:function(){return a.Ub()}}})}catch(n){}},zf.Jz=function(n,t,e){var i,a,s,r,o;for(zf.Kz(n),null==n.j&&(n.j=$l(Qf.Awb,j,28,0,0,1)),s=0,r=(a=n.j).length;s<r;++s)i=a[s],zf.Jz(i,t,"\t"+e);(o=n.e)&&zf.Jz(o,t,e)},zf.Kz=function(n){var t,e;for(null==n.i&&(n.i=zf.Fz(n)),t=0,e=n.i.length;t<e;++t);},zf.Lz=function(n,t){n.backingJsObject=t,zf.Iz(n,t)},zf.Mz=function(n){return zf.Nz(n,n.Wb())},zf.Nz=function(n,t){var e;return e=zf.AHb(n.ge),null==t?e:e+": "+t},zf.Oz=function(){zf.Cz(this),zf.Gz(this),this.Xb()},zf.Pz=function(n){zf.Cz(this),this.f=n,zf.Gz(this),this.Xb()},zf.Qz=function(n,t){zf.Cz(this),this.e=t,this.f=n,zf.Gz(this),this.Xb()},zf.Sz=function(n){if(!("stack"in n))try{throw n}catch(n){}return n},Ol(28,1,{4:1,28:1}),o.Sb=function(n){return new Error(n)},o.Tb=function(){return this.backingJsObject},o.Ub=function(){var n,t,e;for(null==this.j&&(this.j=$l(Qf.Awb,j,28,0,0,1)),e=this.j,t=$l(Qf.twb,w,1,e.length,5,1),n=0;n<e.length;n++)t[n]=e[n].backingJsObject;return t},o.Vb=function(){return zf.Hz(this)},o.Wb=function(){return this.f},o.Xb=function(){zf.Lz(this,zf.Sz(this.Sb(zf.Nz(this,this.f)))),zf.Ez(this)},o.lb=function(){return zf.Mz(this)},o.backingJsObject=N,o.g=!1,o.k=!0,zf.$z=function(){zf.Oz.call(this)},zf._z=function(n){zf.Cz(this),zf.Gz(this),this.backingJsObject=n,zf.Iz(this,n),this.f=null==n?T:Yl(n)},zf.aA=function(n){zf.Pz.call(this,n)},zf.bA=function(n,t){zf.Qz.call(this,n,t)},Ol(18,28,U,zf.aA),zf.cA=function(){zf.$z.call(this)},zf.dA=function(n){zf._z.call(this,n)},zf.eA=function(n){zf.aA.call(this,n)},zf.fA=function(n,t){zf.bA.call(this,n,t)},Ol(56,18,U,zf.eA),zf.QGb=function(){zf.cA.call(this)},zf.RGb=function(n){zf.eA.call(this,n)},Ol(57,56,U,zf.QGb,zf.RGb),zf.B9=function(){zf.cA.call(this)},zf.C9=function(n){zf.dA.call(this,n)},zf.D9=function(n){zf.eA.call(this,n)},Ol(152,56,U,zf.C9),zf.$Ib=function(){zf.B9.call(this)},zf._Ib=function(n){zf.C9.call(this,n)},zf.aJb=function(n){zf.D9.call(this,n)},Ol(74,152,U,zf.$Ib,zf._Ib,zf.aJb),o.Sb=function(n){return new TypeError(n)},zf.hJb=function(n,t){return Gf.uVb(t,Gf.zVb(n).length),Gf.zVb(n).charCodeAt(t)},zf.iJb=function(n,t){return zf.jJb(n,t)},zf.jJb=function(n,t){var e,i;return(e=zf.dIb(Gf.zVb(n)))==(i=zf.dIb(Gf.zVb(t)))?0:e<i?-1:1},zf.kJb=function(n,t){return zf.jJb(Gf.zVb(n).toLowerCase(),Gf.zVb(t).toLowerCase())},zf.lJb=function(n,t){return Gf.oVb(n),n+""+(Gf.oVb(t),t)},zf.mJb=function(n){var t;return zf.IJb(Gf.$Ub(n,0,(t=n.length,Gf.XUb(),t)))},zf.nJb=function(n){return zf.IJb(Gf.$Ub(n,0,n.length))},zf.oJb=function(n){var t;return t=Gf.zVb(J).length,zf.pJb(Gf.zVb(n).substr(Gf.zVb(n).length-t,t),J)},zf.pJb=function(n,t){return Gf.oVb(n),gd(n)===gd(t)},zf.qJb=function(n,t){return Gf.oVb(n),null!=t&&(!!zf.pJb(n,t)||Gf.zVb(n).length==Gf.zVb(t).length&&zf.pJb(Gf.zVb(n).toLowerCase(),Gf.zVb(t).toLowerCase()))},zf.rJb=function(){return Qf.zwb},zf.sJb=function(n){var t,e;for(t=0,e=0;e<Gf.zVb(n).length;e++)t=(t<<5)-t+(Gf.uVb(e,Gf.zVb(n).length),Gf.zVb(n).charCodeAt(e))|0;return t},zf.tJb=function(n,t){return Gf.zVb(n).indexOf(t)},zf.uJb=function(n,t,e){return Gf.zVb(n).indexOf(t,e)},zf.wJb=function(n,t){return Gf.zVb(n).lastIndexOf(t)},zf.xJb=function(n,t,e){return Gf.zVb(n).lastIndexOf(t,e)},zf.yJb=function(n,t){var e;return e=zf.zJb(t,"([/\\\\\\.\\*\\+\\?\\|\\(\\)\\[\\]\\{\\}$^])","\\\\$1"),zf.zJb(n,e,"")},zf.zJb=function(n,t,e){return e=zf.HJb(e),Gf.zVb(n).replace(new RegExp(t,"g"),e)},zf.AJb=function(n,t){var e,i,a,s,r,o,f,l;for(e=new RegExp(t,"g"),f=$l(Qf.zwb,L,2,0,6,1),i=0,l=n,s=null;;){if(null==(o=e.exec(l))||""==l){f[i]=l;break}r=o.index,f[i]=(Gf.tVb(0,r,Gf.zVb(l).length),Gf.zVb(l).substr(0,r)),l=zf.DJb(l,r+Gf.zVb(Gf.zVb(o)[0]).length,Gf.zVb(l).length),e.lastIndex=0,s==l&&(f[i]=(Gf.tVb(0,1,Gf.zVb(l).length),Gf.zVb(l).substr(0,1)),Gf.uVb(1,Gf.zVb(l).length+1),l=Gf.zVb(l).substr(1)),s=l,++i}if(Gf.zVb(n).length>0){for(a=f.length;a>0&&""==f[a-1];)--a;a<f.length&&(Gf.zVb(f).length=a)}return f},zf.BJb=function(n,t){return zf.pJb(Gf.zVb(n).substr(0,Gf.zVb(t).length),t)},zf.CJb=function(n,t){return Gf.uVb(t,Gf.zVb(n).length+1),Gf.zVb(n).substr(t)},zf.DJb=function(n,t,e){return Gf.tVb(t,e,Gf.zVb(n).length),Gf.zVb(n).substr(t,e-t)},zf.EJb=function(n){var t,e,i;for(e=Gf.zVb(n).length,i=0;i<e&&(Gf.uVb(i,Gf.zVb(n).length),Gf.zVb(n).charCodeAt(i)<=32);)++i;for(t=e;t>i&&(Gf.uVb(t-1,Gf.zVb(n).length),Gf.zVb(n).charCodeAt(t-1)<=32);)--t;return i>0||t<e?(Gf.tVb(i,t,Gf.zVb(n).length),Gf.zVb(n).substr(i,t-i)):n},zf.FJb=function(n){return String.fromCharCode.apply(null,n)},zf.HJb=function(n){var t;for(t=0;0<=(t=Gf.zVb(n).indexOf("\\",t));)Gf.uVb(t+1,Gf.zVb(n).length),36==Gf.zVb(n).charCodeAt(t+1)?(Gf.tVb(0,t,Gf.zVb(n).length),n=Gf.zVb(n).substr(0,t)+"$"+zf.CJb(n,++t)):(Gf.tVb(0,t,Gf.zVb(n).length),n=Gf.zVb(n).substr(0,t)+""+zf.CJb(n,++t));return n},zf.IJb=function(n){return zf.JJb(n,0,n.length)},zf.JJb=function(t,e,i){var a,s,r,o;for(r=e+i,Gf.tVb(e,r,t.length),o="",s=e;s<r;)a=n.Math.min(s+R,r),o+=zf.FJb(Gf.zVb(t).slice(s,a)),s=a;return o},u={4:1,242:1,19:1,2:1},zf.$Jb=function(n){zf.RGb.call(this,n)},Ol(265,57,U,zf.$Jb),Gf.MUb=function(n){var t;return t=Gf.zVb(n).slice(),Gf.WUb(t,n)},Gf.NUb=function(t,e,i,a,s,r){var o,f,l,d,g;if(0!=s)for(gd(t)===gd(i)&&(t=Gf.zVb(t).slice(e,e+s),e=0),l=Gf.zVb(i),f=e,d=e+s;f<d;)s=(o=n.Math.min(f+R,d))-f,g=Gf.zVb(t).slice(f,o),Gf.zVb(g).splice(0,0,Gf.zVb(a),Gf.zVb(r?s:0)),Array.prototype.splice.apply(l,g),f=o,a+=s},Gf.OUb=function(n,t){return Gf.WUb(new Array(t),n)},Gf.PUb=function(n,t,e){Gf.zVb(n).splice(t,0,e)},Gf.QUb=function(n,t,e){Gf.NUb(e,0,n,t,e.length,!1)},Gf.RUb=function(n,t){Gf.zVb(n).push(t)},Gf.SUb=function(n,t){Gf.zVb(n).push(t)},Gf.TUb=function(n,t,e){Gf.zVb(n).splice(t,e)},Gf.UUb=function(n,t){Gf.zVb(n).length=t},Gf.VUb=function(n,t){Gf.zVb(n).sort(t)},Ol(757,1,{}),Gf.dVb=function(){},Gf.eVb=function(n){switch(typeof n){case p:return zf.sJb(Gf.zVb(n));case C:return zf.gIb(Gf.zVb(n));case A:return zf._Gb(Gf.zVb(n));default:return null==n?0:Gf.gVb(n)}},Gf.fVb=function(){return++Gf.cVb},Gf.gVb=function(n){return n.$H||(n.$H=Gf.fVb())},Ol(663,1,{},Gf.dVb),Gf.cVb=0,Gf.hVb=function(n){if(!n)throw bd(new zf.mIb)},Gf.iVb=function(n,t){if(!n)throw bd(new zf.nIb(t))},Gf.jVb=function(n,t,e){if(n>t)throw bd(new zf.nIb(k+n+x+t));if(n<0||t>e)throw bd(new zf.TGb(k+n+E+t+F+e))},Gf.kVb=function(n){if(n<0)throw bd(new zf.ZIb("Negative array size: "+n))},Gf.lVb=function(n,t){if(n!=t)throw bd(new Vf.pRb)},Gf.mVb=function(n){if(!n)throw bd(new Vf.xSb)},Gf.nVb=function(n,t){if(n<0||n>=t)throw bd(new zf.RGb(Q+n+z+t))},Gf.oVb=function(n){if(null==n)throw bd(new zf.$Ib);return n},Gf.pVb=function(n,t){if(null==n)throw bd(new zf.aJb(t))},Gf.qVb=function(n,t){if(n<0||n>t)throw bd(new zf.RGb(Q+n+z+t))},Gf.rVb=function(n,t,e){if(n<0||t>e)throw bd(new zf.RGb(k+n+E+t+", size: "+e));if(n>t)throw bd(new zf.nIb(k+n+x+t))},Gf.sVb=function(n){if(!n)throw bd(new zf.oIb)},Gf.tVb=function(n,t,e){if(n<0||t>e||t<n)throw bd(new zf.$Jb(k+n+E+t+F+e))},Gf.uVb=function(n,t){if(n<0||n>=t)throw bd(new zf.$Jb(Q+n+z+t))},Gf.vVb=function(n){var t,e;return t=new ArrayBuffer(8),Gf.zVb(new Float64Array(t))[0]=n,e=Gf.zVb(new Uint32Array(t)),Gf.CVb(0|e[0],0|e[1])},Gf.wVb=function(n,t){return n[t]},Gf.xVb=function(n){return void 0===n},Gf.yVb=function(n){return n>>>0},Gf.zVb=function(n){return n},Gf.AVb=function(n){return n},Gf.BVb=function(n){return n},Ol(664,1,{}),Qf.twb=hd(1),Qf.dsb=hd(0),Qf.msb=hd(665),Qf.jsb=hd(395),Qf.lsb=hd(666),Qf.ksb=hd(396),Qf.dwb=hd(386),Qf.fwb=hd(240),Qf.swb=hd(143),Qf.gwb=hd(393),Qf.Awb=hd(28),Qf.iwb=hd(18),Qf.uwb=hd(56),Qf.lwb=hd(57),Qf.nwb=hd(152),Qf.qwb=hd(74),Qf.zwb=hd(2),Qf.ywb=hd(265),Qf.Jxb=hd(663),Qf.Kxb=hd(664),Yf.Nc=function(t){var e,i,a,s,r,o,f,l,d,g,u,c,b,h,D,H,m,A,C,p,M,I,P,T,N,w,U,J,L,y,B,R,k,x,E,F,Q;for(this.c=t.length,this.d=t[0].length,U=n.Math.min(this.c,this.d),this.e=$l(Qf.Kmb,S,6,n.Math.min(this.c+1,this.d),15,1),this.a=_l(Qf.Kmb,[j,S],[13,6],15,[this.c,U],2),this.b=_l(Qf.Kmb,[j,S],[13,6],15,[this.d,this.d],2),s=$l(Qf.Kmb,S,6,this.d,15,1),Q=$l(Qf.Kmb,S,6,this.c,15,1),N=n.Math.min(this.c-1,this.d),w=n.Math.max(0,n.Math.min(this.d-2,this.c)),p=0;p<n.Math.max(N,w);p++){if(p<N){for(this.e[p]=0,u=p;u<this.c;u++)this.e[p]=Yf.Oc(this.e[p],t[u][p]);if(0!=this.e[p]){for(t[p][p]<0&&(this.e[p]=-this.e[p]),g=p;g<this.c;g++)t[g][p]/=this.e[p];t[p][p]+=1}this.e[p]=-this.e[p]}for(D=p+1;D<this.d;D++){if(p<N&0!=this.e[p]){for(F=0,u=p;u<this.c;u++)F+=t[u][p]*t[u][D];for(F=-F/t[p][p],g=p;g<this.c;g++)t[g][D]+=F*t[g][p]}s[D]=t[p][D]}if(!0&p<N)for(g=p;g<this.c;g++)this.a[g][p]=t[g][p];if(p<w){for(s[p]=0,u=p+1;u<this.d;u++)s[p]=Yf.Oc(s[p],s[u]);if(0!=s[p]){for(s[p+1]<0&&(s[p]=-s[p]),c=p+1;c<this.d;c++)s[c]/=s[p];s[p+1]+=1}if(s[p]=-s[p],p+1<this.c&0!=s[p]){for(c=p+1;c<this.c;c++)Q[c]=0;for(H=p+1;H<this.d;H++)for(b=p+1;b<this.c;b++)Q[b]+=s[H]*t[b][H];for(m=p+1;m<this.d;m++)for(F=-s[m]/s[p+1],b=p+1;b<this.c;b++)t[b][m]+=F*Q[b]}for(g=p+1;g<this.d;g++)this.b[g][p]=s[g]}}for(J=n.Math.min(this.d,this.c+1),N<this.d&&(this.e[N]=t[N][N]),this.c<J&&(this.e[J-1]=0),w+1<J&&(s[w]=t[w][J-1]),s[J-1]=0,A=N;A<U;A++){for(g=0;g<this.c;g++)this.a[g][A]=0;this.a[A][A]=1}for(M=N-1;M>=0;M--)if(0!=this.e[M]){for(h=M+1;h<U;h++){for(F=0,u=M;u<this.c;u++)F+=this.a[u][M]*this.a[u][h];for(F=-F/this.a[M][M],c=M;c<this.c;c++)this.a[c][h]+=F*this.a[c][M]}for(b=M;b<this.c;b++)this.a[b][M]=-this.a[b][M];for(this.a[M][M]=1+this.a[M][M],g=0;g<M-1;g++)this.a[g][M]=0}else{for(g=0;g<this.c;g++)this.a[g][M]=0;this.a[M][M]=1}for(I=this.d-1;I>=0;I--){if(I<w&0!=s[I])for(h=I+1;h<U;h++){for(F=0,u=I+1;u<this.d;u++)F+=this.b[u][I]*this.b[u][h];for(F=-F/this.b[I+1][I],c=I+1;c<this.d;c++)this.b[c][h]+=F*this.b[c][I]}for(g=0;g<this.d;g++)this.b[g][I]=0;this.b[I][I]=1}for(L=J-1,f=n.Math.pow(2,-52);J>0;){for(C=J-2;C>=-1&&-1!=C;C--)if(n.Math.abs(s[C])<=f*(n.Math.abs(this.e[C])+n.Math.abs(this.e[C+1]))){s[C]=0;break}if(C==J-2)P=4;else{for(T=J-1;T>=C&&T!=C;T--)if(F=(T!=J?n.Math.abs(s[T]):0)+(T!=C+1?n.Math.abs(s[T-1]):0),n.Math.abs(this.e[T])<=f*F){this.e[T]=0;break}T==C?P=3:T==J-1?P=1:(P=2,C=T)}switch(++C,P){case 1:for(l=s[J-2],s[J-2]=0,h=J-2;h>=C;h--)for(F=Yf.Oc(this.e[h],l),a=this.e[h]/F,k=l/F,this.e[h]=F,h!=C&&(l=-k*s[h-1],s[h-1]=a*s[h-1]),g=0;g<this.d;g++)F=a*this.b[g][h]+k*this.b[g][J-1],this.b[g][J-1]=-k*this.b[g][h]+a*this.b[g][J-1],this.b[g][h]=F;break;case 2:for(l=s[C-1],s[C-1]=0,h=C;h<J;h++)for(F=Yf.Oc(this.e[h],l),a=this.e[h]/F,k=l/F,this.e[h]=F,l=-k*s[h],s[h]=a*s[h],g=0;g<this.c;g++)F=a*this.a[g][h]+k*this.a[g][C-1],this.a[g][C-1]=-k*this.a[g][h]+a*this.a[g][C-1],this.a[g][h]=F;break;case 3:for(y=n.Math.max(n.Math.max(n.Math.max(n.Math.max(n.Math.abs(this.e[J-1]),n.Math.abs(this.e[J-2])),n.Math.abs(s[J-2])),n.Math.abs(this.e[C])),n.Math.abs(s[C])),x=this.e[J-1]/y,E=this.e[J-2]/y,o=s[J-2]/y,R=this.e[C]/y,r=s[C]/y,B=0,0!=(e=((E+x)*(E-x)+o*o)/2)|0!=(i=x*o*(x*o))&&(B=n.Math.sqrt(e*e+i),e<0&&(B=-B),B=i/(e+B)),l=(R+x)*(R-x)+B,d=R*r,h=C;h<J-1;h++){for(a=l/(F=Yf.Oc(l,d)),k=d/F,h!=C&&(s[h-1]=F),l=a*this.e[h]+k*s[h],s[h]=a*s[h]-k*this.e[h],d=k*this.e[h+1],this.e[h+1]=a*this.e[h+1],u=0;u<this.d;u++)F=a*this.b[u][h]+k*this.b[u][h+1],this.b[u][h+1]=-k*this.b[u][h]+a*this.b[u][h+1],this.b[u][h]=F;if(a=l/(F=Yf.Oc(l,d)),k=d/F,this.e[h]=F,l=a*s[h]+k*this.e[h+1],this.e[h+1]=-k*s[h]+a*this.e[h+1],d=k*s[h+1],s[h+1]=a*s[h+1],h<this.c-1)for(g=0;g<this.c;g++)F=a*this.a[g][h]+k*this.a[g][h+1],this.a[g][h+1]=-k*this.a[g][h]+a*this.a[g][h+1],this.a[g][h]=F}s[J-2]=l;break;case 4:if(this.e[C]<=0)for(this.e[C]=this.e[C]<0?-this.e[C]:0,g=0;g<=L;g++)this.b[g][C]=-this.b[g][C];for(;C<L&&!(this.e[C]>=this.e[C+1]);){if(F=this.e[C],this.e[C]=this.e[C+1],this.e[C+1]=F,C<this.d-1)for(g=0;g<this.d;g++)F=this.b[g][C+1],this.b[g][C+1]=this.b[g][C],this.b[g][C]=F;if(C<this.c-1)for(g=0;g<this.c;g++)F=this.a[g][C+1],this.a[g][C+1]=this.a[g][C],this.a[g][C]=F;++C}--J}}},Yf.Oc=function(t,e){var i;return n.Math.abs(t)>n.Math.abs(e)?(i=e/t,i=n.Math.abs(t)*n.Math.sqrt(1+i*i)):0!=e?(i=t/e,i=n.Math.abs(e)*n.Math.sqrt(1+i*i)):i=0,i},Ol(233,1,X,Yf.Nc),o.c=0,o.d=0,Qf.Omb=hd(233),qf.Qc=function(){qf.Qc=vl,qf.Pc=ed(Wl(Qf.Mmb,1),G,6,15,[0,Y,14286847,13402367,12779264,16758197,9474192,3166456,16715021,9494608,11789301,11230450,9109248,12560038,1578e4,16744448,16777008,2093087,8442339,9388244,4062976,15132390,12567239,10921643,9083335,10255047,14706227,15765664,5296208,13140019,8224944,12750735,6721423,12419299,16752896,10889513,6076625,7351984,q,9764863,9756896,7586505,5551541,3907230,2396047,687500,27013,12632256,16767375,10909043,6717568,10380213,13924864,9699476,4366e3,5707663,51456,7394559,16777159,14286791,13107143,10747847,9437127,6422471,4587463,3211207,2097095,65436,58997,54354,48952,43812,5096191,5089023,2200790,2522539,2516630,1528967,13684960,16765219,12105936,10900557,5724513,10375093,11230208,7688005,4358806,4325478,32e3,7384058,47871,41471,36863,33023,27647,5528818,7888099,9064419,10565332,11739092,11739066,11734438,12389767,13041766,13369433,13697103,14221381,14680120,15073326,15400998,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13158600,1334015,56540,15075850,15132160,56540,15075850,15461355,8553170,1016335,1016335,1334015,15132160,3289770,14456450,16422400,16422400,11819700,3289770,1016335])},qf.Rc=function(n){n.w=new al.NG},qf.Sc=function(n){var t,e;32&n.G||null!=(e=qf.qu(n.L))&&(0==n.A.a&&0==n.A.b&&(t=n.R.c*qf.Ik(n.L),n.w=qf.Nd(n),qf.cd(n,t),qf.Jd(n,null,t,0)),n.yb(ud(n.B)),1!=n.L.O&&qf.Kd(n,448),n.pb(e,n.A.a,n.A.b+V*n.B))},qf.Tc=function(n,t){return null==n?t:null==t?n:n+","+t},qf.Uc=function(n,t){qf.Oh(t,n.R),qf.Rh(t,n.w),qf.Qh(t,n.A)},qf.Vc=function(n){var t;t=n.R.c*(0!=n.r?n.r:qf.Ik(n.L)),n.Y=.06*t,n.T=.15*t,n.S=.38*t,n.W=.47*t,n.X=ud(t*n.J*.6+.5),n.V=.12*t,n.Z=.4*t,n.B=.5*t+.5},qf.Wc=function(n){var t,e;for(n=wd(n,v),e=0;e<(il.CG(),il.BG).length;e++)if(Ld(n,il.BG[e]))return il.AG[e];return t=new zf.ZJb("R"),Sd(wd(n,Z),0)&&(t.a+="0"),Sd(wd(n,O),0)&&(t.a+="3"),Sd(wd(n,K),0)&&(t.a+="4"),Sd(wd(n,W),0)&&(t.a+="5"),Sd(wd(n,_),0)&&(t.a+="6"),Sd(wd(n,$),0)&&(t.a+="7"),Sd(wd(n,nn),0)&&(t.a+="8"),t.a},qf.Xc=function(n,t,e,i){var a,s;a=new qf.Yd,s=new qf.Yd,a.a=t.a,a.c=t.c,a.b=(t.a+t.b)/2,a.d=(t.c+t.d)/2,s.a=a.b,s.c=a.d,s.b=t.b,s.d=t.d,qf.Gd(n,a)&&(qf.Kd(n,n.p[e]),n.mb(a)),qf.Gd(n,s)&&(qf.Kd(n,n.p[i]),n.mb(s)),qf.Kd(n,n.Q)},qf.Yc=function(n,t,e,i){var a,s,r,o,f;o=(t.b-t.a)/10,f=(t.d-t.c)/10,a=new qf.Yd,qf.ql(n.L,qf.Hn(n.L,e,i))?(s=-3,r=-3):(s=n.p[e],r=n.p[i]),qf.Kd(n,s),a.a=t.a,a.c=t.c,a.b=t.a+2*o,a.d=t.c+2*f,n.mb(a),a.a=t.a+4*o,a.c=t.c+4*f,a.b=t.a+5*o,a.d=t.c+5*f,n.mb(a),qf.Kd(n,r),a.a=t.a+5*o,a.c=t.c+5*f,a.b=t.a+6*o,a.d=t.c+6*f,n.mb(a),a.a=t.a+8*o,a.c=t.c+8*f,a.b=t.b,a.d=t.d,n.mb(a),qf.Kd(n,n.Q)},qf.Zc=function(n,t,e){n.qb(t-n.V/2,e-n.V/2,n.V)},qf.$c=function(n,t,e,i){qf.ql(n.L,qf.Hn(n.L,e,i))?(qf.Kd(n,-3),n.mb(t),qf.Kd(n,n.Q)):n.p[e]!=n.p[i]?qf.Xc(n,t,e,i):0!=n.p[e]?(qf.Kd(n,n.p[e]),n.mb(t),qf.Kd(n,n.Q)):n.mb(t)},qf._c=function(n,t,e,i,a,s,r){r.a=t.a+a,r.c=t.c+s,r.b=t.b+a,r.d=t.d+s,qf.$c(n,r,e,i)},qf.ad=function(t,e,i,a){var s,r,o,f,l,d,g,u,c,b,h,D;for(u=e.b-e.a,h=e.d-e.c,l=n.Math.sqrt(u*u+h*h),c=u/((d=2*Od(yd(n.Math.round(l/(4*t.Y)))))-1),D=h/(d-1),qf.ql(t.L,qf.Hn(t.L,i,a))?(s=-3,r=-3):(s=t.p[i],r=t.p[a]),g=e.a-t.Y/2,b=e.c-t.Y/2,qf.Kd(t,s),f=0;f<(d/2|0);f++)t.qb(g,b,t.Y),g+=c,b+=D;for(qf.Kd(t,r),o=0;o<(d/2|0);o++)t.qb(g,b,t.Y),g+=c,b+=D;qf.Kd(t,t.Q)},qf.bd=function(n,t,e,i){var a,s,r,o,f,l,d,g,u,c,b,h,D,H;f=(t.c-t.d)/9,c=(t.b-t.a)/9,l=t.b+f,b=t.d+c,d=t.b-f,h=t.d-c,g=(t.a+l)/2,D=(t.c+b)/2,u=(t.a+d)/2,H=(t.c+h)/2,r=new al.IG(3),o=new al.IG(4),al.HG(r,t.a,t.c),al.HG(r,g,D),al.HG(r,u,H),al.HG(o,u,H),al.HG(o,g,D),al.HG(o,l,b),al.HG(o,d,h),qf.ql(n.L,qf.Hn(n.L,e,i))?(a=-3,s=-3):(a=n.p[e],s=n.p[i],1!=n.L.O&&(s=qf.ed(n,e),a==qf.rk(n.L,e)&&(a=s))),qf.Kd(n,a),n.ob(r),qf.Kd(n,s),n.ob(o),qf.Kd(n,n.Q)},qf.cd=function(n,t){var e,i;for(i=0;i<n.$.a.length;i++)n.w=al.MG(n.w,Vf.Oi(n.$,i));qf.dd(n,t),e=.1*t,n.w.c-=e,n.w.d-=e,n.w.b+=2*e,n.w.a+=2*e},qf.dd=function(n,t){var e,i,a,s,r,o,f;for(a=$l(Qf.nyb,tn,6,n.L.q,16,1),i=0;i<n.L.r;i++)qf.ol(n.L,i)&&(a[qf.Mk(n.L,0,i)]=!0,a[qf.Mk(n.L,1,i)]=!0);for(r=new al.NG,e=0;e<n.L.q;e++)0!=(s=Sd(wd(qf.Ck(n.L,e),en),0)?.47*t:a[e]?.38*t:0)&&(o=qf.Uh(n.R,qf.Ek(n.L,e)),f=qf.Vh(n.R,qf.Fk(n.L,e)),al.LG(r,o-s,f-s,2*s,2*s),n.w=al.MG(n.w,r))},qf.ed=function(n,t){var e,i;if(4224&n.G)return n.p[t];if(-1==(i=qf.fd(n,t))&&-1!=(e=qf.pn(n.L,t))&&(t=e,i=qf.fd(n,t)),-1==i)return n.p[t];switch(255&i){case 1:return 384;case 2:return 64;default:return 448}},qf.fd=function(n,t){var e,i,a;return a=-1,i=-1,128&n.G||(qf.ml(n.L,t)&&(a=qf.vk(n.L,t),i=qf.uk(n.L,t)),-1!=(e=qf.rn(n.L,t))&&(a=qf.Rk(n.L,e),i=qf.Qk(n.L,e)),-1!=a&&0!=a&&(a|=i<<8)),a},qf.gd=function(n){var t,e,i,a;for(n.wb(2*n.S),a=new qf.Yd,i=0;i<n.L.r;i++)t=qf.Mk(n.L,0,i),e=qf.Mk(n.L,1,i),qf.ol(n.L,i)&&(a.a=qf.Uh(n.R,qf.Ek(n.L,t)),a.c=qf.Vh(n.R,qf.Fk(n.L,t)),a.b=qf.Uh(n.R,qf.Ek(n.L,e)),a.d=qf.Vh(n.R,qf.Fk(n.L,e)),qf.Kd(n,-2),n.mb(a))},qf.hd=function(n){var t,e,i,a,s,r;if(n.L.K){for(r=n.W,qf.Kd(n,-7),t=0;t<n.L.f;t++)Sd(wd(qf.Ck(n.L,t),en),0)&&n.qb(qf.Uh(n.R,qf.Ek(n.L,t))-r,qf.Vh(n.R,qf.Fk(n.L,t))-r,2*r);for(n.wb(2*n.W),s=new qf.Yd,a=0;a<n.L.r;a++)e=qf.Mk(n.L,0,a),i=qf.Mk(n.L,1,a),Sd(wd(wd(qf.Ck(n.L,e),qf.Ck(n.L,i)),en),0)&&(s.a=qf.Uh(n.R,qf.Ek(n.L,e)),s.c=qf.Vh(n.R,qf.Fk(n.L,e)),s.b=qf.Uh(n.R,qf.Ek(n.L,i)),s.d=qf.Vh(n.R,qf.Fk(n.L,i)),n.mb(s))}},qf.jd=function(n){var t,e,i,a;if(n.L.K){if(qf.Kd(n,320),8&n.G)for(t=0;t<n.L.f;t++)Sd(wd(qf.Ck(n.L,t),-536870913),0)&&n.qb(qf.Uh(n.R,qf.Ek(n.L,t))-n.Z/2,qf.Vh(n.R,qf.Fk(n.L,t))-n.Z/2,n.Z);for(a=0;a<n.L.g;a++)0!=qf.Wk(n.L,a)&&(e=qf.Mk(n.L,0,a),i=qf.Mk(n.L,1,a),n.qb((qf.Uh(n.R,qf.Ek(n.L,e))+qf.Uh(n.R,qf.Ek(n.L,i))-n.Z)/2,(qf.Vh(n.R,qf.Fk(n.L,e))+qf.Vh(n.R,qf.Fk(n.L,i))-n.Z)/2,n.Z))}},qf.kd=function(n){n.J=1,n.R=new qf.Wh,n.$=new Vf.bj,n.U=new Vf.bj,n.s=$l(Qf.nyb,tn,6,n.L.q,16,1),n.A=new al.EG,n.Q=0,n.C=-1,qf.Pd(n)},qf.ld=function(n,t){var e;if(0==qf.vn(n.L,t))return!1;for(e=0;e<qf.vn(n.L,t);e++)if(!qf.ql(n.L,qf.Ln(n.L,t,e)))return!1;return!0},qf.md=function(n){var t;for(n.q=$l(Qf.nyb,tn,6,n.L.q,16,1),t=0;t<n.L.r;t++)n.q[qf.Mk(n.L,0,t)]=!0,n.q[qf.Mk(n.L,1,t)]=!0},qf.nd=function(n,t){var e;if(2!=qf.Kn(n.L,t))return!1;for(e=0;e<2;e++)if(2!=qf.Mn(n.L,t,e))return!1;return!0},qf.od=function(t,e,i,a,s){var r,o,f,l,d,g,u,c,b,h;for(c=!1,s.a=0,s.b=0,r=a>0?an:sn,h=qf.Lk(t.L,e,i),g=0;g<qf.Kn(t.L,e);g++)o=qf.Ln(t.L,e,g),f=h,(u=qf.Mk(t.L,0,o)==e?qf.Mk(t.L,1,o):qf.Mk(t.L,0,o))!=i&&(f<(b=qf.Lk(t.L,e,u))&&(f+=rn),l=f-b,a>0?(l<on&&(c=!0),l>an&&(l=an),l<.523598776&&(l=.523598776),l<=r&&(r=l,d=t.T*n.Math.tan(r-fn)/2,s.a=-d*n.Math.sin(f),s.b=-d*n.Math.cos(f))):(l>=on&&(c=!0),l<sn&&(l=sn),l>5.759586531&&(l=5.759586531),l>=r&&(r=l,d=t.T*n.Math.tan(4.712388981-r)/2,s.a=-d*n.Math.sin(f),s.b=-d*n.Math.cos(f))));return c},qf.pd=function(t,e,i,a){var s;if(0==e)return a.a=i<0?t.T:-t.T,void(a.b=0);s=n.Math.atan(i/e),e<0&&(s+=on),a.a=-t.T*n.Math.sin(s),a.b=t.T*n.Math.cos(s)},qf.qd=function(n,t,e,i){var a,s,r,o,f,l,d,g,u,c,b,h;a=new qf.Yd,f=new qf.Yd,d=new al.EG,l=new al.EG,r=qf.Mk(n.L,0,e),o=qf.Mk(n.L,1,e),i&&(u=t.a,t.a=t.b,t.b=u,u=t.c,t.c=t.d,t.d=u,c=r,r=o,o=c),qf.Gd(n,t)&&(qf.Po(n.L,e)?(a.a=t.a,a.c=t.c,a.b=t.b,a.d=t.d,0==(g=i?-qf.lo(n.L,e):qf.lo(n.L,e))&&(g=1),qf.pd(n,t.b-t.a,t.d-t.c,d),g>0?(f.a=t.a+d.a,f.c=t.c+d.b,f.b=t.b+d.a,f.d=t.d+d.b,(qf.od(n,r,o,1,l)||qf.Kn(n.L,r)>1)&&(f.a+=l.a+d.b,f.c+=l.b-d.a)):(f.a=t.a-d.a,f.c=t.c-d.b,f.b=t.b-d.a,f.d=t.d-d.b,(qf.od(n,r,o,-1,l)||qf.Kn(n.L,r)>1)&&(f.a+=l.a+d.b,f.c+=l.b-d.a)),386==qf.Xk(n.L,e)&&qf.Fd(a,f),qf.Gd(n,a)&&qf.$c(n,a,r,o),64==qf.Xk(n.L,e)?qf.Gd(n,f)&&qf.Yc(n,f,r,o):qf.Gd(n,f)&&qf.$c(n,f,r,o)):(qf.pd(n,t.b-t.a,t.d-t.c,d),b=d.a/2,h=d.b/2,s=!1,a.a=t.a+b,a.c=t.c+h,a.b=t.b+b,a.d=t.d+h,qf.Kn(n.L,r)>1&&(qf.od(n,r,o,1,l)?(a.a+=l.a,a.c+=l.b,2==qf.Kn(n.L,r)&&(0==l.a&&0==l.b||(a.a+=d.b,a.c-=d.a))):n.o[r]=new al.FG(a.a,a.c)),f.a=t.a-b,f.c=t.c-h,f.b=t.b-b,f.d=t.d-h,qf.Kn(n.L,r)>1&&(qf.od(n,r,o,0,l)?(f.a+=l.a,f.c+=l.b,2==qf.Kn(n.L,r)&&(0==l.a&&0==l.b||(f.a+=d.b,f.c-=d.a))):(n.o[r]=new al.FG(f.a,f.c),s=!0)),386==qf.Xk(n.L,e)&&qf.Fd(a,f),64==qf.Xk(n.L,e)?s?(qf.Yc(n,a,r,o),qf.$c(n,f,r,o)):(qf.$c(n,a,r,o),qf.Yc(n,f,r,o)):(qf.$c(n,a,r,o),qf.$c(n,f,r,o))))},qf.rd=function(n,t){var e,i,a,s,r,o,f,l,d,g,u,c,b;for(d=n.Q,g=n.F,n.G&ln&&(n.Q=-6,n.F=-8355712,qf.Kd(n,1)),n.o=$l(Qf.bpb,w,33,n.L.q,0,1),f=0;f<n.L.r;f++)(2==qf.Xk(n.L,f)||386==qf.Xk(n.L,f)||64==qf.Xk(n.L,f))&&qf.ud(n,f);for(l=0;l<n.L.r;l++)2!=qf.Xk(n.L,l)&&386!=qf.Xk(n.L,l)&&64!=qf.Xk(n.L,l)&&qf.ud(n,l);if(!(64&n.G))for(o=0;o<n.L.r;o++)0!=qf.Pk(n.L,o)&&(a=null,1==qf.Pk(n.L,o)||2==qf.Pk(n.L,o)?(2==qf.Uk(n.L,o)||0==qf.Rk(n.L,o)||t[qf.Rk(n.L,o)][qf.Qk(n.L,o)]>1)&&(a=1==qf.Pk(n.L,o)?2==qf.Uk(n.L,o)?"E":qf.sl(n.L,o)?"p":"P":2==qf.Uk(n.L,o)?"Z":qf.sl(n.L,o)?"m":"M"):a="?",null!=a&&(n.yb((2*n.X+1)/3|0),qf.Kd(n,qf.ql(n.L,o)?-3:1==n.L.O||n.G&dn?n.Q:448),e=qf.Mk(n.L,0,o),i=qf.Mk(n.L,1,o),c=(qf.Uh(n.R,qf.Ek(n.L,e))+qf.Uh(n.R,qf.Ek(n.L,i)))/2,b=(qf.Vh(n.R,qf.Fk(n.L,e))+qf.Vh(n.R,qf.Fk(n.L,i)))/2,s=(qf.Uh(n.R,qf.Ek(n.L,e))-qf.Uh(n.R,qf.Ek(n.L,i)))/3,r=(qf.Vh(n.R,qf.Fk(n.L,e))-qf.Vh(n.R,qf.Fk(n.L,i)))/3,qf.xd(n,c+r,b-s,a,!0),qf.Kd(n,n.Q),n.yb(n.X)));if(4&n.G){for(n.yb((2*n.X+1)/3|0),qf.Kd(n,384),o=0;o<n.L.r;o++)e=qf.Mk(n.L,0,o),i=qf.Mk(n.L,1,o),u=qf.Go(n.L,o)?"d":qf.Co(n.L,o)?"a":"",c=(qf.Uh(n.R,qf.Ek(n.L,e))+qf.Uh(n.R,qf.Ek(n.L,i)))/2,b=(qf.Vh(n.R,qf.Fk(n.L,e))+qf.Vh(n.R,qf.Fk(n.L,i)))/2,qf.xd(n,c,b,u+""+o,!0);qf.Kd(n,n.Q),n.yb(n.X)}n.G&ln&&(n.Q=d,n.F=g)},qf.sd=function(n){var t,e;for(e=new Vf.eQb(n.U);e.a<e.c.a.length;)t=Vf.dQb(e),qf.Kd(n,t.a),qf.Zc(n,t.b,t.c);qf.Kd(n,n.Q)},qf.td=function(t,e,i){var a,s,r,o,f,l,d,g,u,c,b,h,D,H,j,m,A,C,p,M,I,P,T,N,w,U,J,L,y,B,R,k,x,E,F,Q,z,X,G,Y,q,V;if(t.K||t.tb(e,qf.wk(t.L,e),qf.Uh(t.R,qf.Ek(t.L,e)),qf.Vh(t.R,qf.Fk(t.L,e))),k=null,0!=qf.qk(t.L,e)&&(X=1==n.Math.abs(qf.qk(t.L,e))?"":""+n.Math.abs(qf.qk(t.L,e)),k=qf.qk(t.L,e)<0?X+"-":X+"+"),null!=t.t&&e<t.t.length&&null!=t.t[e]&&Gf.zVb(t.t[e]).length>0&&(k=qf.Tc(k,t.t[e])),N=null,0!=Ud(x=qf.Ck(t.L,e),0)&&(Sd(wd(x,gn),0)&&(N=null==N?"*":N+",*"),Sd(wd(x,un),0)&&(N=null==N?"!*":N+",!*"),Sd(wd(x,cn),0)?N=null==N?"ha":N+",ha":Sd(wd(x,2),0)?N=null==N?"a":N+",a":Sd(wd(x,4),0)&&(N=null==N?"!a":N+",!a"),Sd(wd(x,dn),0)&&(N=null==N?"s":N+",s"),Sd(wd(x,bn),0)&&(0==Ud(M=wd(x,bn),1792)?N=null==N?"h0":N+",h0":0==Ud(M,1664)?N=null==N?"h1":N+",h1":0==Ud(M,1408)?N=null==N?"h2":N+",h2":0==Ud(M,128)?N=null==N?"h>0":N+",h>0":0==Ud(M,384)?N=null==N?"h>1":N+",h>1":0==Ud(M,896)?N=null==N?"h>2":N+",h>2":0==Ud(M,hn)?N=null==N?"h<3":N+",h<3":0==Ud(M,1536)?N=null==N?"h<2":N+",h<2":0==Ud(M,1152)&&(N=null==N?"h1-2":N+",h1-2")),Sd(wd(x,Dn),0)&&(0==Ud(l=wd(x,Dn),Hn)?N=null==N?"c0":N+",c0":0==Ud(l,jn)?N=null==N?"c+":N+",c+":0==Ud(l,mn)&&(N=null==N?"c-":N+",c-")),Sd(wd(x,An),0)&&(0==Ud(R=wd(x,An),98304)?N=null==N?"pi0":N+",pi0":0==Ud(R,81920)?N=null==N?"pi1":N+",pi1":0==Ud(R,49152)?N=null==N?"pi2":N+",pi2":0==Ud(R,ln)&&(N=null==N?"pi>0":N+",pi>0")),Sd(wd(x,Cn),0)&&(0==Ud(B=wd(x,Cn),pn)?N=null==N?"n1":N+",n1":0==Ud(B,Mn)?N=null==N?"n2":N+",n2":0==Ud(B,In)?N=null==N?"n3":N+",n3":0==Ud(B,Pn)?N=null==N?"n<3":N+",n<3":0==Ud(B,Tn)?N=null==N?"n<4":N+",n<4":0==Ud(B,Nn)?N=null==N?"n>1":N+",n>1":0==Ud(B,wn)?N=null==N?"n>2":N+",n>2":0==Ud(B,Un)?N=null==N?"n>3":N+",n>3":0==Ud(B,3276800)?N=null==N?"n1-2":N+",n1-2":0==Ud(B,2228224)?N=null==N?"n1-3":N+",n1-3":0==Ud(B,2490368)&&(N=null==N?"n2-3":N+",n2-3")),Sd(wd(x,Jn),0)&&(0==Ud(h=wd(x,Jn),Ln)?N=null==N?"e0":N+",e0":0==Ud(h,yn)?N=null==N?"e1":N+",e1":0==Ud(h,Bn)?N=null==N?"e2":N+",e2":0==Ud(h,Rn)?N=null==N?"e3":N+",e3":0==Ud(h,0xe0000000000)?N=null==N?"e<2":N+",e<2":0==Ud(h,0xc0000000000)?N=null==N?"e<3":N+",e<3":0==Ud(h,kn)?N=null==N?"e<4":N+",e<4":0==Ud(h,xn)?N=null==N?"e>0":N+",e>0":0==Ud(h,En)?N=null==N?"e>1":N+",e>1":0==Ud(h,Fn)?N=null==N?"e>2":N+",e>2":0==Ud(h,Qn)?N=null==N?"e>3":N+",e>3":0==Ud(h,0xc8000000000)?N=null==N?"e1-2":N+",e1-2":0==Ud(h,9345848836096)?N=null==N?"e1-3":N+",e1-3":0==Ud(h,0x98000000000)&&(N=null==N?"e2-3":N+",e2-3")),Sd(wd(x,120),0)&&(0==Ud(E=wd(x,120),112)?N=null==N?"!r":N+",!r":0==Ud(E,8)?N=null==N?"r":N+",r":0==Ud(E,96)?N=null==N?"rb<3":N+",rb<3":0==Ud(E,104)?N=null==N?"rb2":N+",rb2":0==Ud(E,88)?N=null==N?"rb3":N+",rb3":0==Ud(E,56)&&(N=null==N?"rb4":N+",rb4")),Sd(wd(x,zn),0)&&(N=null==N?"r"+Kd(qd(wd(x,zn),22)):N+",r"+Kd(qd(wd(x,zn),22))),Sd(wd(x,v),0)&&(N=qf.Tc(N,qf.Wc(x))),Sd(wd(x,Sn),0)&&(N=null==N?"f":N+",f")),0!=qf.Ak(t.L,e)&&(N=qf.Tc(N,""+qf.Ak(t.L,e))),z=0,0!=qf.Dk(t.L,e))switch(qf.Dk(t.L,e)){case 16:k=null==k?"|":k+",|";break;case 32:z=1;break;case 48:z=2}if(u=null,!(64&t.G))if(qf.jl(t.L,e))u="?";else if(0!=qf.pk(t.L,e)&&(0==qf.vk(t.L,e)||null==i||i[qf.vk(t.L,e)][qf.uk(t.L,e)]>1))if(2==qf.Kn(t.L,e))switch(qf.pk(t.L,e)){case 2:u=qf.ll(t.L,e)?"p":"P";break;case 1:u=qf.ll(t.L,e)?"m":"M";break;default:u="*"}else switch(qf.pk(t.L,e)){case 1:u=qf.ll(t.L,e)?"r":"R";break;case 2:u=qf.ll(t.L,e)?"s":"S";break;default:u="*"}if(768&t.G&&(u=qf.Tc(u,""+qf.yu(t.L,e))),L=null,16&t.G&&0!=qf.zk(t.L,e)&&(L=""+qf.zk(t.L,e)),H=null,-1!=qf.qo(t.L,e)&&-1!=(D=qf.fd(t,e))&&(H=0==D?"abs":(1==(255&D)?"&":"or")+(1+(D>>8))),I=0,!(t.G&Xn)&&(t.L.K?Sd(wd(qf.Ck(t.L,e),Gn),0)&&(I=qf.Zn(t.L,e)):(6!=qf.Hk(t.L,e)||0!=qf.Ak(t.L,e)||!t.q[e]||0!=qf.Dk(t.L,e))&&(I=qf.Zn(t.L,e))),J=!1,null!=(r=qf.sk(t.L,e))&&zf.pJb(Gf.zVb(r).substr(0,1),"]")&&(N=qf.Tc((Gf.uVb(1,Gf.zVb(r).length+1),Gf.zVb(r).substr(1)),N),r=null,J=!0),null!=r?I=0:null!=qf.xk(t.L,e)?(r=(s=Sd(wd(qf.Ck(t.L,e),1),0)?"[!":"[")+qf.yk(t.L,e)+"]",Gf.zVb(r).length>5&&(r=s+qf.xk(t.L,e).length+"]"),Sd(wd(qf.Ck(t.L,e),Gn),0)&&(I=-1)):Sd(wd(qf.Ck(t.L,e),1),0)?(r="?",Sd(wd(qf.Ck(t.L,e),Gn),0)&&(I=-1)):(6!=qf.Hk(t.L,e)||null!=k||null!=N||I>0||!t.q[e])&&(r=qf.wk(t.L,e)),U=0,!qf.Bl(t.L,e)&Sd(wd(qf.Ck(t.L,e),en),0)&&qf.Kd(t,-8),null!=r?(U=t.rb(r),qf.xd(t,qf.Uh(t.R,qf.Ek(t.L,e)),qf.Vh(t.R,qf.Fk(t.L,e)),r,!0),t.s[e]=!0):qf.nd(t,e)&&qf.wd(t,qf.Uh(t.R,qf.Ek(t.L,e)),qf.Vh(t.R,qf.Fk(t.L,e)),e),null!=k&&(t.yb((2*t.X+1)/3|0),G=qf.Uh(t.R,qf.Ek(t.L,e))+((U+t.rb(k))/2+1),q=qf.Vh(t.R,qf.Fk(t.L,e))-((4*t.sb()-4)/8|0),qf.xd(t,G,q,k,!0),t.yb(t.X)),2&t.G&&(N=""+e),null!=N&&(J?t.yb((5*t.X+1)/6|0):t.yb((2*t.X+1)/3|0),G=qf.Uh(t.R,qf.Ek(t.L,e))-(U+t.rb(N))/2,q=qf.Vh(t.R,qf.Fk(t.L,e))-((4*t.sb()-4)/8|0),qf.xd(t,G,q,N,!0),t.yb(t.X)),null!=u&&(t.yb((2*t.X+1)/3|0),G=qf.Uh(t.R,qf.Ek(t.L,e))-(U+t.rb(u))/2,q=qf.Vh(t.R,qf.Fk(t.L,e))+((4*t.sb()+4)/8|0),Q=t.C,1!=t.L.O&&!(t.G&dn)&&qf.Kd(t,448),qf.xd(t,G,q,u,!1),qf.Kd(t,Q),t.yb(t.X)),null!=L&&(t.yb((2*t.X+1)/3|0),G=qf.Uh(t.R,qf.Ek(t.L,e))+((U+t.rb(L))/2+1),q=qf.Vh(t.R,qf.Fk(t.L,e))+((4*t.sb()+4)/8|0),Q=t.C,qf.Kd(t,qf.nl(t.L,e)?384:448),qf.xd(t,G,q,L,!0),qf.Kd(t,Q),t.yb(t.X)),null!=H&&(a=qf.Bd(t,e),t.yb((2*t.X+1)/3|0),G=qf.Uh(t.R,qf.Ek(t.L,e))+.7*t.sb()*n.Math.sin(a),q=qf.Vh(t.R,qf.Fk(t.L,e))+.7*t.sb()*n.Math.cos(a),Q=t.C,!t.K&&1!=t.L.O&&qf.Kd(t,qf.ed(t,e)),qf.xd(t,G,q,H,!1),qf.Kd(t,Q),t.yb(t.X)),0!=I||0!=z){for(C=$l(Qf.Kmb,S,6,4,15,1),T=0;T<qf.wn(t.L,e);T++)for(f=qf.Ln(t.L,e,T),w=0;w<2;w++)qf.Mk(t.L,w,f)==e&&((F=qf.Lk(t.L,qf.Mk(t.L,w,f),qf.Mk(t.L,1-w,f)))<Yn?(C[0]-=F+fn,C[3]+=F+on):F<0?(C[2]+=F+fn,C[3]-=F):F<fn?(C[1]+=F,C[2]+=fn-F):(C[0]+=F-fn,C[1]+=on-F));if(0==qf.Kn(t.L,e)?qf.ul(t.L,e)?C[3]-=.2:C[1]-=.2:C[1]-=.1,(null!=k||null!=L)&&(C[1]+=10),(null!=N||null!=u)&&(C[3]+=10),m="",0!=I&&(p=t.rb("H"),A=0,j=t.sb(),-1==I?(m="n",t.yb((2*t.X+1)/3|0),A=t.rb(m)):I>1&&(m=""+I,t.yb((2*t.X+1)/3|0),A=t.rb(m)),C[1]<.6||C[3]<.6?(g=qf.Vh(t.R,qf.Fk(t.L,e)),C[1]<=C[3]?(C[1]+=10,d=qf.Uh(t.R,qf.Ek(t.L,e))+(U+p)/2):(C[3]+=10,d=qf.Uh(t.R,qf.Ek(t.L,e))-(U+p)/2-A)):(d=qf.Uh(t.R,qf.Ek(t.L,e)),C[0]<C[2]?(C[0]+=10,g=qf.Vh(t.R,qf.Fk(t.L,e))-j):(C[2]+=10,g=qf.Vh(t.R,qf.Fk(t.L,e))+j)),A>0&&(G=d+(p+A)/2,q=g+((4*t.sb()+4)/8|0),qf.xd(t,G,q,m,!0),t.yb(t.X)),qf.xd(t,d,g,"H",!0)),o=0,0!=z){for(y=50,c=0,P=0;P<4;P++)b=P>1?P-2:P+2,C[P]<y?(o=P,y=C[P],c=C[b]):C[P]==y&&C[b]>c&&(o=P,c=C[b]);switch(o){case 0:d=qf.Uh(t.R,qf.Ek(t.L,e)),g=qf.Vh(t.R,qf.Fk(t.L,e))-t.V-U/2;break;case 1:d=qf.Uh(t.R,qf.Ek(t.L,e))+t.V+U/2,g=qf.Vh(t.R,qf.Fk(t.L,e));break;case 2:d=qf.Uh(t.R,qf.Ek(t.L,e)),g=qf.Vh(t.R,qf.Fk(t.L,e))+t.V+U/2;break;default:d=qf.Uh(t.R,qf.Ek(t.L,e))-t.V-U/2,g=qf.Vh(t.R,qf.Fk(t.L,e))}if(1==z)Vf.Ji(t.$,new al.OG(d-t.V,g-t.V,2*t.V,2*t.V)),t.K||Vf.Ji(t.U,new qf.Xd(d,g,qf.ld(t,e)?-3:t.p[e]));else{switch(o){case 2:case 0:Y=2*t.V,V=0,d-=t.V;break;default:Y=0,V=2*t.V,g-=t.V}Vf.Ji(t.$,new al.OG(d-t.V,g-t.V,2*t.V,2*t.V)),t.K||Vf.Ji(t.U,new qf.Xd(d,g,qf.ld(t,e)?-3:t.p[e])),Vf.Ji(t.$,new al.OG(d+Y-t.V,g+V-t.V,2*t.V,2*t.V)),t.K||Vf.Ji(t.U,new qf.Xd(d+Y,g+V,qf.ld(t,e)?-3:t.p[e]))}}-8==t.C&&qf.Kd(t,-9)}else-8==t.C&&qf.Kd(t,-9)},qf.ud=function(n,t){var e,i,a,s,r,o,f,l,d,g,u,c,b,h,D,H,j,m,A,C;if(m=new qf.Yd,e=new qf.Yd,r=new qf.Yd,D=new al.EG,h=new al.EG,a=qf.Mk(n.L,0,t),s=qf.Mk(n.L,1,t),n.ub(t,qf.Uh(n.R,qf.Ek(n.L,a)),qf.Vh(n.R,qf.Fk(n.L,a)),qf.Uh(n.R,qf.Ek(n.L,s)),qf.Vh(n.R,qf.Fk(n.L,s))),!qf.Bl(n.L,a)&&!qf.Bl(n.L,s)&&Sd(wd(Gd(qf.Ck(n.L,a),qf.Ck(n.L,s)),en),0)&&qf.Kd(n,-8),n.o[a]?(m.a=n.o[a].a,m.c=n.o[a].b):(m.a=qf.Uh(n.R,qf.Ek(n.L,a)),m.c=qf.Vh(n.R,qf.Fk(n.L,a))),n.o[s]?(m.b=n.o[s].a,m.d=n.o[s].b):(m.b=qf.Uh(n.R,qf.Ek(n.L,s)),m.d=qf.Vh(n.R,qf.Fk(n.L,s))),qf.Wk(n.L,t)&qn)return qf.Gd(n,m)&&n.nb(m),void qf.Kd(n,-9);switch(o=64==qf.Xk(n.L,t)?0:32==qf.Xk(n.L,t)?1:qf.Uk(n.L,t)){case 1:if(f=qf.Xk(n.L,t),128&n.G&&(257==f||129==f)&&(j=qf.Mk(n.L,0,t),0!=(c=qf.vk(n.L,j)))){for(u=qf.uk(n.L,j),g=0,i=0;i<n.L.f;i++)qf.vk(n.L,i)==c&&qf.uk(n.L,i)==u&&++g;1==g&&(f=1)}switch(f){case 1:qf.Gd(n,m)&&qf.$c(n,m,a,s);break;case 257:qf.Dd(n,m,a,s);break;case 129:for(A=m.b-m.a,C=m.d-m.c,qf.ql(n.L,qf.Hn(n.L,a,s))?(l=-3,d=-3):(l=n.p[a],d=qf.ed(n,a),l==qf.rk(n.L,a)&&(l=d)),b=2;b<17;b+=2)e.a=m.a+b*A/17-b*C/128,e.c=m.c+b*C/17+b*A/128,e.b=m.a+b*A/17+b*C/128,e.d=m.c+b*C/17-b*A/128,qf.Gd(n,e)&&(qf.Kd(n,b<9?l:d),n.mb(e),qf.Kd(n,n.Q));break;case 32:qf.Gd(n,m)&&qf.ad(n,m,a,s)}break;case 0:case 2:if(!n.s[a]&&2!=qf.An(n.L,a)||!n.s[s]&&2!=qf.An(n.L,s)||qf.Po(n.L,t)||2!=o)!n.s[s]&&2!=qf.An(n.L,s)||2!=o?!n.s[a]&&2!=qf.An(n.L,a)||2!=o?(0==(H=qf.lo(n.L,t))&&(H=1),e.a=m.a,e.c=m.c,e.b=m.b,e.d=m.d,qf.pd(n,m.b-m.a,m.d-m.c,D),H>0?(r.a=m.a+D.a,r.c=m.c+D.b,r.b=m.b+D.a,r.d=m.d+D.b,(qf.od(n,a,s,1,h)||qf.Kn(n.L,a)>1)&&(r.a+=h.a+D.b,r.c+=h.b-D.a),(qf.od(n,s,a,-1,h)||qf.Kn(n.L,s)>1)&&(r.b+=h.a-D.b,r.d+=h.b+D.a)):(r.a=m.a-D.a,r.c=m.c-D.b,r.b=m.b-D.a,r.d=m.d-D.b,(qf.od(n,a,s,-1,h)||qf.Kn(n.L,a)>1)&&(r.a+=h.a+D.b,r.c+=h.b-D.a),(qf.od(n,s,a,1,h)||qf.Kn(n.L,s)>1)&&(r.b+=h.a-D.b,r.d+=h.b+D.a)),386==qf.Xk(n.L,t)&&qf.Fd(e,r),qf.Gd(n,e)&&qf.$c(n,e,a,s),2==o?qf.Gd(n,r)&&qf.$c(n,r,a,s):qf.Gd(n,r)&&qf.Yc(n,r,a,s)):qf.qd(n,m,t,!0):qf.qd(n,m,t,!1);else{if(!qf.Gd(n,m))break;qf.pd(n,m.b-m.a,m.d-m.c,D),A=D.a/2,C=D.b/2,e.a=m.a+A,e.c=m.c+C,e.b=m.b+A,e.d=m.d+C,r.a=m.a-A,r.c=m.c-C,r.b=m.b-A,r.d=m.d-C,386==qf.Xk(n.L,t)&&qf.Fd(e,r),qf.$c(n,e,a,s),2==o?qf.$c(n,r,a,s):qf.Yc(n,r,a,s)}break;case 3:qf.Gd(n,m)&&(qf.$c(n,m,a,s),qf.pd(n,m.b-m.a,m.d-m.c,D),qf._c(n,m,a,s,D.a,D.b,e),qf._c(n,m,a,s,-D.a,-D.b,e));break;case 4:qf.Gd(n,m)&&(qf.pd(n,m.b-m.a,m.d-m.c,D),qf._c(n,m,a,s,1.5*D.a,1.5*D.b,e),qf._c(n,m,a,s,.5*D.a,.5*D.b,e),qf._c(n,m,a,s,-.5*D.a,-.5*D.b,e),qf._c(n,m,a,s,-1.5*D.a,-1.5*D.b,e));break;case 5:qf.Gd(n,m)&&(qf.$c(n,m,a,s),qf.pd(n,m.b-m.a,m.d-m.c,D),qf._c(n,m,a,s,2*D.a,2*D.b,e),qf._c(n,m,a,s,D.a,D.b,e),qf._c(n,m,a,s,-D.a,-D.b,e),qf._c(n,m,a,s,-2*D.a,-2*D.b,e))}-8==n.C&&qf.Kd(n,-9)},qf.vd=function(t){var e,i,a,s,r,o,f,l,d,g,u,c,b,h,D;for(b=!1,a=0;a<t.L.g;a++)d=null,qf.pl(t.L,a)?d=(u=qf.Ok(t.L,a))==(g=qf.Nk(t.L,a))?"["+u+"]":"["+u+":"+g+"]":qf.Wk(t.L,a)&Vn?d=(qf.Wk(t.L,a)&Vn)==Tn?"a":256==(384&qf.Wk(t.L,a))?"r!a":"!a":384&qf.Wk(t.L,a)&&(d=256==(384&qf.Wk(t.L,a))?"r":"!r"),0!=(c=(qf.Wk(t.L,a)&wn)>>17)&&(d=(null==d?"":d)+c),null!=d&&(e=qf.Mk(t.L,0,a),i=qf.Mk(t.L,1,a),b||(t.yb((2*t.X+1)/3|0),b=!0),h=(qf.Uh(t.R,qf.Ek(t.L,e))+qf.Uh(t.R,qf.Ek(t.L,i)))/2,D=(qf.Vh(t.R,qf.Fk(t.L,e))+qf.Vh(t.R,qf.Fk(t.L,i)))/2,r=qf.Uh(t.R,qf.Ek(t.L,i))-qf.Uh(t.R,qf.Ek(t.L,e)),o=qf.Vh(t.R,qf.Fk(t.L,i))-qf.Vh(t.R,qf.Fk(t.L,e)),s=n.Math.sqrt(r*r+o*o),l=.6*t.rb(d),f=.55*t.sb(),0!=s&&(r>0?qf.xd(t,h+l*o/s,D-f*r/s,d,!0):qf.xd(t,h-l*o/s,D+f*r/s,d,!0)));b&&t.yb(t.X)},qf.wd=function(n,t,e,i){Vf.Ji(n.$,new al.OG(t-n.V,e-n.V,2*n.V,2*n.V)),n.K||Vf.Ji(n.U,new qf.Xd(t,e,qf.ld(n,i)?-3:n.p[i]))},qf.xd=function(n,t,e,i,a){var s,r;a&&(s=n.rb(i)/2+(n.sb()/8|0),r=n.sb()/2|0,("+"==i||"-"==i)&&(r=2*r/3),Vf.Ji(n.$,new al.OG(t-s,e-r,2*s,2*r))),n.K||n.pb(i,t,e)},qf.yd=function(n){var t;t=n.a,n.a=n.b,n.b=t,t=n.c,n.c=n.d,n.d=t},qf.zd=function(t,e,i){var a;return a=0==e?rn+t[0]-t[t.length-1]:t[e]-t[e-1],a-=i>vn&&i<Zn?2*n.Math.cos(i+On):.5*n.Math.cos(i+On)},qf.Ad=function(n){var t;return t=new al.NG,n.a<=n.b?(t.c=n.a,t.b=n.b-n.a):(t.c=n.b,t.b=n.a-n.b),n.c<=n.d?(t.d=n.c,t.a=n.d-n.c):(t.d=n.d,t.a=n.c-n.d),t},qf.Bd=function(n,t){var e,i,a,s,r,o,f;for(e=$l(Qf.Kmb,S,6,qf.vn(n.L,t),15,1),a=0;a<qf.vn(n.L,t);a++)e[a]=qf.Lk(n.L,t,qf.Jn(n.L,t,a));for(Gf.VUb(e,Gf.zVb(Vl(Vf.HQb.prototype.$d,Vf.HQb,[]))),s=qf.Cd(e,0),r=qf.zd(e,0,s),i=1;i<e.length;i++)o=qf.Cd(e,i),r<(f=qf.zd(e,i,o))&&(r=f,s=o);return s},qf.Cd=function(n,t){var e;return t>0?(n[t]+n[t-1])/2:(e=on+(n[0]+n[n.length-1])/2)>on?e-rn:e},qf.Dd=function(n,t,e,i){var a,s,r,o;if(o=new qf.Yd,t.a!=t.b||t.c!=t.d){for(o.a=t.a,o.c=t.c,o.b=t.b,o.d=t.d,r=qf.Ad(o),a=0;a<n.$.a.length;a++)if(!((s=Vf.Oi(n.$,a)).c>r.c+r.b||s.d>r.d+r.a||r.c>s.c+s.b||r.d>s.d+s.a)){if(qf.Ed(n,o.a,o.c,a)){if(qf.Ed(n,o.b,o.d,a))return;return qf.Hd(n,o,0,a),void qf.Dd(n,o,e,i)}if(qf.Ed(n,o.b,o.d,a))return qf.Hd(n,o,1,a),void qf.Dd(n,o,e,i)}qf.bd(n,o,e,i)}},qf.Ed=function(n,t,e,i){var a;return!(1&n.G)&&(t>(a=Vf.Oi(n.$,i)).c&&t<a.c+a.b&&e>a.d&&e<a.d+a.a)},qf.Fd=function(n,t){var e;e=n.b,n.b=t.b,t.b=e,e=n.d,n.d=t.d,t.d=e},qf.Gd=function(n,t){var e,i,a,s,r,o;if(t.a==t.b&&t.c==t.d){for(r=new Vf.eQb(n.$);r.a<r.c.a.length;)if(s=Vf.dQb(r),al.JG(s,t.a,t.c))return!1;return!0}for(o=qf.Ad(t),e=!1,t.a>t.b&&(qf.yd(t),e=!0),i=0;i<n.$.a.length;i++)if(!((s=Vf.Oi(n.$,i)).c>o.c+o.b||s.d>o.d+o.a||o.c>s.c+s.b||o.d>s.d+s.a)){if(qf.Ed(n,t.a,t.c,i))return qf.Ed(n,t.b,t.d,i)?(e&&qf.yd(t),!1):(qf.Hd(n,t,0,i),a=qf.Gd(n,t),e&&qf.yd(t),a);if(qf.Ed(n,t.b,t.d,i))return qf.Hd(n,t,1,i),a=qf.Gd(n,t),e&&qf.yd(t),a}return e&&qf.yd(t),!0},qf.Hd=function(t,e,i,a){var s,r,o,f,l,d,g,u,c,b,h;0==i?(u=e.a,b=e.c,c=e.b,h=e.d):(u=e.b,b=e.d,c=e.a,h=e.c),g=Vf.Oi(t.$,a),l=c>u?g.c+g.b:g.c,d=h>b?g.d+g.a:g.d,s=c-u,r=h-b,n.Math.abs(s)>n.Math.abs(r)?b==h?(o=l,f=b):c>u==l>(o=u+s*(d-b)/r)?f=d:(o=l,f=b+r*(l-u)/s):u==c?(o=u,f=d):h>b==d>(f=b+r*(l-u)/s)?o=l:(o=u+s*(d-b)/r,f=d),0==i?(e.a=o,e.c=f):(e.b=o,e.d=f)},qf.Id=function(n){var t,e,i,a,s,r;if(0!=n.L.q){for(qf.nu(n.L,256&n.G?63:512&n.G?95:31),qf.Vc(n),i=qf.su(n.L),a=!1,n.p=$l(Qf.Mmb,G,6,n.L.q,15,1),t=0;t<n.L.q;t++)n.p[t]=qf.rk(n.L,t),0!=n.p[t]&&(a=!0),qf.Bl(n.L,t)&&(n.p[t]=128),qf.el(n.L,t)&&!(n.G&Gn)&&(n.p[t]=256);for(qf.Kd(n,-10),qf.hd(n),qf.gd(n),qf.jd(n),qf.Sc(n),n.yb(n.X),n.wb(n.Y),qf.Kd(n,n.Q),qf.md(n),Gf.UUb(n.U.a,0),Gf.UUb(n.$.a,0),1&n.G&&(qf.rd(n,i),qf.sd(n),qf.vd(n)),s=0;s<n.L.q;s++)qf.ld(n,s)?(qf.Kd(n,-3),qf.td(n,s,i),qf.Kd(n,n.Q)):0!=n.p[s]?(qf.Kd(n,n.p[s]),qf.td(n,s,i),qf.Kd(n,n.Q)):a||1==n.L.O||1==qf.Hk(n.L,s)||6==qf.Hk(n.L,s)||n.G&hn||null!=qf.xk(n.L,s)||!(qf.Hk(n.L,s)<qf.Pc.length)||0==qf.Pc[qf.Hk(n.L,s)]?qf.td(n,s,i):(r=qf.Pc[qf.Hk(n.L,s)],qf.Md(n,(e=0!=n.M?n.M:0!=n.D?n.D:-1,Hl.m7(r,e))),qf.td(n,s,i),qf.Kd(n,n.Q));1&n.G||(qf.sd(n),qf.vd(n),qf.rd(n,i))}},qf.Jd=function(n,t,e,i){var a;switch(a=e/2,i&Kn){case Kn:if(t){n.A.a=t.c+t.b/2,n.A.b=t.d+t.a-a;break}case 0:n.A.a=n.w.c+n.w.b/2,n.A.b=n.w.d+n.w.a+a,t&&n.A.b>t.d+t.a-a&&(n.A.b=t.d+t.a-a);break;case Wn:if(t){n.A.a=t.c+t.b/2,n.A.b=t.d+a;break}case _n:n.A.a=n.w.c+n.w.b/2,n.A.b=n.w.d-a,t&&n.A.b<t.d+a&&(n.A.b=t.d+a)}},qf.Kd=function(n,t){if(!n.K&&(-10==t&&(n.C=-999,t=n.Q),-2!=t&&-7!=t&&0!=n.N&&(t=-4),t!=n.C&&(-8!=n.C||-9==t)))switch(-8==t&&(n.O=n.C),-9==t&&(t=n.O),n.C=t,t){case 0:n.xb(0==n.F?$n:n.F);break;case-6:n.xb(n.F);break;case-4:n.xb(n.N);break;case-2:n.xb(n.u);break;case-3:n.xb(n.v);break;case-7:n.xb(n.H);break;case-8:n.xb(n.I);break;case-5:n.xb(n.P);break;case 64:n.xb(-14655233);break;case 128:n.xb(nt);break;case 256:n.xb(-4194049);break;case 192:n.xb(-16711936);break;case 320:n.xb(-24576);break;case 384:n.xb(-16744448);break;case 448:n.xb(-6291456);break;case 1:n.xb(-8355712);break;default:n.xb($n)}},qf.Ld=function(n,t){n.G=t},qf.Md=function(n,t){0==n.N?(n.C=-5,n.P=t,n.xb(t)):-4!=n.C&&(n.C=-4,n.xb(n.N))},qf.Nd=function(n){var t,e,i,a,s;for(a=qf.Uh(n.R,qf.Ek(n.L,0)),e=qf.Uh(n.R,qf.Ek(n.L,0)),s=qf.Vh(n.R,qf.Fk(n.L,0)),i=qf.Vh(n.R,qf.Fk(n.L,0)),t=0;t<n.L.q;t++)a>qf.Uh(n.R,qf.Ek(n.L,t))&&(a=qf.Uh(n.R,qf.Ek(n.L,t))),e<qf.Uh(n.R,qf.Ek(n.L,t))&&(e=qf.Uh(n.R,qf.Ek(n.L,t))),s>qf.Vh(n.R,qf.Fk(n.L,t))&&(s=qf.Vh(n.R,qf.Fk(n.L,t))),i<qf.Vh(n.R,qf.Fk(n.L,t))&&(i=qf.Vh(n.R,qf.Fk(n.L,t)));return new al.OG(a,s,e-a,i-s)},qf.Od=function(n,t,e){var i,a;return 0==n.L.q?null:(n.w=qf.Nd(n),i=n.R.c*qf.Ik(n.L),1==(a=new qf.Yh(n.w,t,i,e)).c&&0==a.a&&0==a.b?a=null:(qf.Oh(a,n.R),qf.Rh(a,n.w)),qf.Jd(n,t,i,e),a)},qf.Pd=function(n){var t;t=0!=n.M?n.M:0!=n.D?n.D:-1,n.u=Hl.n7(t),n.v=Hl.m7(tt,t),n.H=-24321,n.I=-6291392},qf.Qd=function(n,t){var e;return qf.Rd(n,t,y),qf.Th(n.R)?null:(e=n.R,qf.Ph(n.R,n.L),n.R=new qf.Wh,e)},qf.Rd=function(n,t,e){var i,a,s,r;if(0==n.L.q)return null;for(s=n.zb(t,e),qf.nu(n.L,256&n.G?63:512&n.G?95:31),qf.md(n),Gf.UUb(n.U.a,0),Gf.UUb(n.$.a,0),qf.Vc(n),n.yb(n.X),n.K=!0,a=0;a<n.L.q;a++)qf.td(n,a,null);return n.K=!1,i=n.R.c*qf.Ik(n.L),qf.cd(n,i),qf.Jd(n,t,i,e),!t||al.KG(t,n.w)?s:(r=new qf.Yh(n.w,t,i,e),qf.Oh(r,n.R),qf.Rh(r,n.w),qf.Qh(r,n.A),s?(qf.Oh(r,s),s):r)},qf.Sd=function(n,t){qf.Qc(),qf.Rc(this),this.L=n,this.G=t,qf.kd(this)},Ol(145,1,{145:1}),o.tb=function(n,t,e,i){},o.ub=function(n,t,e,i,a){},o.vb=function(n){qf.Id(this)},o.zb=function(n,t){return qf.Od(this,n,t)},o.r=0,o.u=0,o.v=0,o.B=0,o.C=0,o.D=0,o.F=0,o.G=0,o.H=0,o.I=0,o.J=0,o.K=!1,o.M=0,o.N=0,o.O=0,o.P=0,o.Q=0,o.S=0,o.T=0,o.V=0,o.W=0,o.X=0,o.Y=0,o.Z=0,Qf.Rmb=hd(145),qf.Xd=function(n,t,e){this.b=n,this.c=t,this.a=e},Ol(162,1,{162:1},qf.Xd),o.a=0,o.b=0,o.c=0,Qf.Pmb=hd(162),qf.Yd=function(){},Ol(81,1,{},qf.Yd),o.a=0,o.b=0,o.c=0,o.d=0,Qf.Qmb=hd(81),qf.Zd=function(n){return et+n.Cb()+'"'+n.Bb()+it},Ol(231,1,{231:1}),o.lb=function(){var n;return n=new zf.NJb,zf.MJb(n,et+this.Cb()+'"'+this.Bb()+it),n.a},o.d=!1,Qf.Smb=hd(231),qf._d=function(n,t){var e,i,a,s,r,o,f,l,d,g,u,c,b,h,D,H,j,m,A,C,p,M,I,P,T,N,w,U,J,L,y,B,R,k,x,E,F,Q,z,S,X,Y,q,V;for(L=$l(Qf.nyb,tn,6,t.i.a.length,16,1),M=$l(Qf.Mmb,G,6,n.f.f,15,1),S=0;S<t.i.a.length;S++){for(L[S]=!0,H=0,j=(D=Vf.Oi(t.j,S)).length;H<j;++H)if(m=D[H],!n.e[m]){L[S]=!1;break}if(L[S])for(r=0,l=(i=Vf.Oi(t.i,S)).length;r<l;++r)++M[e=i[r]]}for(J=$l(Qf.nyb,tn,6,n.f.f,16,1),X=0;X<t.i.a.length;X++)if((3==(Y=Vf.Oi(t.j,X).length)||5==Y||6==Y||7==Y)&&L[X]){for(o=0,d=(a=Vf.Oi(t.i,X)).length;o<d;++o)J[e=a[o]]=!0;for(F=!0,R=-1,k=0,f=0,g=(s=Vf.Oi(t.i,X)).length;f<g;++f)if(e=s[f],6==Y||M[e]>1){if(!qf.de(n,e,!1)){F=!1;break}}else if(z=5==Y?qf.ae(n,e,!1):qf.be(n,e,!1),qf.de(n,e,!1))k<z&&(k=z,R=e);else{if(10==k){F=!1;break}R=e,k=20}if(F)for(r=0,l=(i=Vf.Oi(t.i,X)).length;r<l;++r)(e=i[r])==R?(5==Y?qf.ae(n,e,!0):qf.be(n,e,!0),qf.oe(n,e)):qf.de(n,e,!0)}for(p=$l(Qf.Mmb,G,6,n.f.f,15,1),P=$l(Qf.nyb,tn,6,n.f.f,16,1),h=0;h<n.f.g;h++)u=qf.Mk(n.f,0,h),c=qf.Mk(n.f,1,h),J[u]||J[c]||(n.e[h]&&(++p[u],++p[c]),32==qf.Xk(n.f,h)&&(P[u]=!0,P[c]=!0));for(Q=$l(Qf.Mmb,G,6,n.f.f,15,1),I=$l(Qf.Mmb,G,6,n.f.f,15,1),V=0;V<n.f.f;V++)if(1==p[V])for(I[0]=V,C=0,T=0;C<=T;){for(N=0;N<qf.Kn(n.f,I[C]);N++)if(n.e[qf.Ln(n.f,I[C],N)]&&(A=qf.Jn(n.f,I[C],N),(0==C||A!=I[C-1])&&0!=p[A])){if(I[++T]=A,1&p[A]){for(B=1;B<T;B+=2)Q[I[B]]=-1;T=0}break}++C}for(b=$l(Qf.nyb,tn,6,n.f.f,16,1),q=0;q<n.f.f;q++)if(!b[q]&&0!=p[q]){for(I[0]=q,b[q]=!0,C=0,T=0;C<=T;){for(N=0;N<qf.Kn(n.f,I[C]);N++)n.e[qf.Ln(n.f,I[C],N)]&&(b[A=qf.Jn(n.f,I[C],N)]||(I[++T]=A,b[A]=!0));++C}if(!(1&T)){for(w=0;w<=T;w++)0==Q[I[w]]&&(Q[I[w]]=qf.ce(n,I[w],!1));for(y=!0,U=0;U<=T;U++)if(Q[I[U]]<=0&&!qf.de(n,I[U],!1)){y=!1;break}if(y){for(E=0,x=-1,N=0;N<=T;N++)E<Q[I[N]]&&(E=Q[I[N]],x=I[N]);E>0&&(qf.ce(n,x,!0),qf.oe(n,x))}}}},qf.ae=function(n,t,e){if(7==qf.Hk(n.f,t)){if(3==qf.vn(n.f,t))return 6;if(2==qf.Kn(n.f,t))return 4}else{if(8==qf.Hk(n.f,t))return 10;if(15==qf.Hk(n.f,t)||33==qf.Hk(n.f,t)){if(3==qf.Kn(n.f,t))return 8}else if(16==qf.Hk(n.f,t)||34==qf.Hk(n.f,t)||52==qf.Hk(n.f,t)){if(2==qf.Kn(n.f,t))return 12}else if(6==qf.Hk(n.f,t))return e&&qf.Wl(n.f,t,-1),qf.vn(n.f,t)!=qf.wn(n.f,t)?2:3}return 0},qf.be=function(n,t,e){if(n.a){if(3!=qf.vn(n.f,t))return 0}else if(qf.vn(n.f,t)>3)return 0;return 6==qf.Hk(n.f,t)?(e&&qf.Wl(n.f,t,1),2):5==qf.Hk(n.f,t)?4:0},qf.ce=function(n,t,e){if(0!=qf.qk(n.f,t))return 0;if(n.a){if(5==qf.Hk(n.f,t))return 2!=qf.eo(n.f,t)?0:(e&&qf.Wl(n.f,t,1),1);if(7==qf.Hk(n.f,t))return 2!=qf.eo(n.f,t)?0:(e&&qf.Wl(n.f,t,-1),qf.fe(n,t)?6:3);if(8==qf.Hk(n.f,t))return 1!=qf.eo(n.f,t)?0:(e&&qf.Wl(n.f,t,-1),qf.fe(n,t)?7:4);if(16==qf.Hk(n.f,t))return 1!=qf.eo(n.f,t)?0:(e&&qf.Wl(n.f,t,-1),qf.fe(n,t)?5:2);if(34==qf.Hk(n.f,t))return 1!=qf.eo(n.f,t)?0:(e&&qf.Wl(n.f,t,-1),qf.fe(n,t)?4:1)}else{if(5==qf.Hk(n.f,t))return qf.eo(n.f,t)>2?0:(e&&qf.Wl(n.f,t,1),1);if(7==qf.Hk(n.f,t))return qf.eo(n.f,t)>2?0:(e&&qf.Wl(n.f,t,-1),qf.fe(n,t)?5:3);if(8==qf.Hk(n.f,t))return qf.eo(n.f,t)>1?0:(e&&qf.Wl(n.f,t,-1),qf.fe(n,t)?7:4);if(16==qf.Hk(n.f,t))return qf.eo(n.f,t)>1?0:(e&&qf.Wl(n.f,t,-1),qf.fe(n,t)?5:2)}return 0},qf.de=function(n,t,e){var i,a;if((i=qf.Hk(n.f,t))>=5&&i<=8||15==i||16==i||33==i||34==i||52==i){if(0!=qf.$n(n.f,t))return!0;if(a=qf.qk(n.f,t),5==i&&a>=0)return e&&qf.Wl(n.f,t,a-1),!0;if(5!=i&&a<=0)return e&&qf.Wl(n.f,t,a+1),!0}return!1},qf.ee=function(n,t,e,i){var a;for(a=0;a<qf.Kn(n.f,t);a++)if(1==i[qf.Ln(n.f,t,a)]&&qf.Jn(n.f,t,a)!=e)return a;return-1},qf.fe=function(n,t){var e;for(e=0;e<qf.Kn(n.f,t);e++)if(qf.xl(n.f,qf.Jn(n.f,t,e)))return!0;return!1},qf.ge=function(n,t,e){var i;for(i=0;i<qf.Kn(n.f,t);i++)if(e[qf.Ln(n.f,t,i)]>1)return!0;return!1},qf.he=function(n,t){var e;for(e=0;e<qf.Kn(n.f,t);e++)if(n.e[qf.Ln(n.f,t,e)])return!0;return!1},qf.ie=function(n,t,e){var i,a,s,r,o,f,l,d,g,u;if(qf.nu(n.f,1),null!=t)n.e=t;else for(n.e=$l(Qf.nyb,tn,6,n.f.g,16,1),a=0;a<n.f.g;a++)64==qf.Xk(n.f,a)&&(n.e[a]=!0,qf.xm(n.f,a,1));for(n.g=0,n.d=$l(Qf.nyb,tn,6,n.f.f,16,1),s=0;s<n.f.g;s++)if(n.e[s])for(++n.c,o=0;o<2;o++)n.d[qf.Mk(n.f,o,s)]||(n.d[qf.Mk(n.f,o,s)]=!0,++n.b);if(0==n.c)return!0;for(n.a=!1,qf.qe(n,e),n.f.K&&qf.ke(n),u=new qf.as(n.f,1),e&&qf._d(n,u),qf.re(n,u),qf.ne(n,u),qf.pe(n),qf.le(n);qf.me(n,u);)qf.le(n);for(;0!=n.c;){if(!(r=!1))for(d=0;d<u.i.a.length;d++)if(6==Vf.Oi(u.j,d).length){for(l=!0,g=Vf.Oi(u.j,d),f=0;f<6;f++)if(!n.e[g[f]]){l=!1;break}if(l){for(o=0;o<6;o+=2)qf.je(n,g[o]);r=!0;break}}if(!r)for(i=0;i<n.f.g;i++)if(n.e[i]){qf.je(n,i),qf.le(n),r=!0;break}}return n.b==n.g},qf.je=function(n,t){var e,i,a,s;for(1==qf.Xk(n.f,t)&&(qf.xm(n.f,t,2),n.g+=2),a=0;a<2;a++)for(e=qf.Mk(n.f,a,t),n.d[e]=!1,s=0;s<qf.Kn(n.f,e);s++)i=qf.Ln(n.f,e,s),n.e[i]&&(n.e[i]=!1,--n.c)},qf.ke=function(n){var t,e,i,a,s,r,o,f;for(e=0;e<n.f.g;e++)if(n.e[e])for(a=0;a<2;a++){for(o=qf.Mk(n.f,a,e),t=!1,r=0;r<qf.Kn(n.f,o);r++)if(e!=qf.Ln(n.f,o,r)&&n.e[qf.Ln(n.f,o,r)]){t=!0;break}if(!t){for(f=e,i=qf.Mk(n.f,1-a,e);-1!=f;)for(n.e[f]=!1,--n.c,qf.xm(n.f,f,64),f=-1,o=i,s=0;s<qf.Kn(n.f,o);s++)if(n.e[qf.Ln(n.f,o,s)]){if(-1!=f){o=-1,f=-1;break}f=qf.Ln(n.f,o,s),i=qf.Jn(n.f,o,s)}break}}},qf.le=function(n){var t,e,i,a,s,r,o;do{for(o=!1,e=0;e<n.f.g;e++)if(n.e[e]){for(s=!1,a=0;a<2;a++){for(i=qf.Mk(n.f,a,e),t=!1,r=0;r<qf.Kn(n.f,i);r++)if(e!=qf.Ln(n.f,i,r)&&n.e[qf.Ln(n.f,i,r)]){t=!0;break}if(!t){s=!0;break}}s&&(o=!0,qf.je(n,e))}}while(o)},qf.me=function(n,t){var e,i,a,s,r,o,f,l,d,g,u,c,b;for(b=$l(Qf.Mmb,G,6,n.f.g,15,1),u=0;u<t.i.a.length;u++){for(c=Vf.Oi(t.j,u),g=!0,d=0;d<c.length;d++)if(!n.e[c[d]]){g=!1;break}if(g)for(l=0;l<c.length;l++)++b[c[l]]}for(f=n.c,s=0;s<n.f.g;s++)if(1==b[s])for(l=0;l<2&&n.e[s];l++)if(e=qf.Mk(n.f,l,s),i=qf.Mk(n.f,1-l,s),qf.ge(n,e,b)&&!qf.ge(n,i,b))for(;-1!=(o=qf.ee(n,i,e,b))&&(a=qf.Jn(n.f,i,o),r=qf.Ln(n.f,i,o),n.e[r])&&(qf.je(n,r),-1!=(o=qf.ee(n,a,i,b)));)e=a,i=qf.Jn(n.f,a,o);return f!=n.c},qf.ne=function(n,t){var e;for(e=0;e<n.f.g;e++)n.e[e]&&qf.Vr(t,e)&&(qf.oe(n,qf.Mk(n.f,0,e)),qf.oe(n,qf.Mk(n.f,1,e)))},qf.oe=function(n,t){var e,i;for(n.d[t]&&(n.d[t]=!1,--n.b),i=0;i<qf.Kn(n.f,t);i++)e=qf.Ln(n.f,t,i),n.e[e]&&(n.e[e]=!1,--n.c)},qf.pe=function(n){var t,e,i,a,s;for(e=0;e<n.f.g;e++)if(2==qf.Uk(n.f,e))for(a=0;a<2;a++)if(t=qf.Mk(n.f,a,e),qf.Hk(n.f,t)<=8)for(s=0;s<qf.Kn(n.f,t);s++)if(i=qf.Ln(n.f,t,s),n.e[i]){qf.oe(n,t);break}},qf.qe=function(n,t){var e;for(e=0;e<n.f.f;e++)n.d[e]&&0==qf.$n(n.f,e)&&(!t||5==qf.Hk(n.f,e)&&qf.qk(n.f,e)<0||6==qf.Hk(n.f,e)||14==qf.Hk(n.f,e)||qf.ul(n.f,e)&&qf.qk(n.f,e)>0)&&qf.oe(n,e)},qf.re=function(n,t){var e,i,a,s,r,o,f,l,d,g,u,c;for(d=0;d<t.i.a.length;d++)if(3==(c=Vf.Oi(t.j,d).length)||5==c||7==c)for(g=Vf.Oi(t.i,d),i=0;i<c;i++)e=g[i],qf.he(n,e)&&(5==c?(6==qf.Hk(n.f,e)&&-1==qf.qk(n.f,e)&&3==qf.vn(n.f,e)||7==qf.Hk(n.f,e)&&0==qf.qk(n.f,e)&&3==qf.vn(n.f,e)||8==qf.Hk(n.f,e)&&0==qf.qk(n.f,e)&&2==qf.Kn(n.f,e)||16==qf.Hk(n.f,e)&&0==qf.qk(n.f,e)&&2==qf.Kn(n.f,e)||34==qf.Hk(n.f,e)&&0==qf.qk(n.f,e)&&2==qf.Kn(n.f,e))&&qf.oe(n,e):(5==qf.Hk(n.f,e)&&0==qf.qk(n.f,e)&&3==qf.vn(n.f,e)||6==qf.Hk(n.f,e)&&1==qf.qk(n.f,e))&&qf.oe(n,e));for(l=0;l<t.i.a.length;l++)if(5==Vf.Oi(t.j,l).length){for(u=Vf.Oi(t.j,l),s=!0,a=0;a<u.length;a++)if(!n.e[u[a]]){s=!1;break}if(s){for(g=Vf.Oi(t.i,l),o=0,r=-1,i=0;i<u.length;i++)-1==qf.qk(n.f,g[i])&&6==qf.Hk(n.f,g[i])&&o<(f=3==qf.vn(n.f,g[i])?3:3==qf.wn(n.f,g[i])?2:1)&&(o=f,r=g[i]);-1!=r&&qf.oe(n,r)}}},qf.se=function(n){this.f=n},Ol(116,1,{},qf.se),o.a=!1,o.b=0,o.c=0,o.g=0,Qf.Tmb=hd(116),qf.te=function(n,t){var e,i;for(e=0,i=0;i<n.j[t];i++)2==n.n[t][i]&&(7==qf.Hk(n,n.i[t][i])||8==qf.Hk(n,n.i[t][i])||16==qf.Hk(n,n.i[t][i]))&&++e;return e},qf.ue=function(t,e){var i,a,s,r,o,f;if(0==t.s[e])return!1;for(f=!0,i=t.s[e],r=t.j[e],o=0,a=0;a<r;a++)s=t.i[e][a],o+=t.s[s];return n.Math.abs(i)<=n.Math.abs(o)&&zf.YIb(i)!=zf.YIb(o)&&(f=!1),f},qf.ve=function(n,t){var e,i,a,s,r,o,f;if(8!=n.C[t]||0!=n.s[t]||1!=n.j[t]||1!=n.n[t][0])return!1;if(e=n.i[t][0],6==n.C[e]){for(r=n.j[e],i=0;i<r;i++)if((a=n.i[e][i])!=t&&8==n.C[a]&&(s=qf.Hn(n,e,a),2==n.H[s]))return!0}else if(7==n.C[e]){if(1==n.s[e])return!0}else if(16==n.C[e]){for(o=n.j[e],f=0,i=0;i<o;i++)(a=n.i[e][i])!=t&&8==n.C[a]&&(s=qf.Hn(n,e,a),2==n.H[s]&&++f);if(2==f)return!0}else if(qf.we(n,t))return!0;return!1},qf.we=function(n,t){var e,i,a,s,r;if(8!=n.C[t])return!1;if(1!=n.j[t])return!1;if(e=n.i[t][0],15==n.C[e])for(r=n.j[e],i=0;i<r;i++)if((a=n.i[e][i])!=t&&8==n.C[a]&&(s=qf.Hn(n,e,a),2==n.H[s]))return!0;return!1},qf.xe=function(n,t){var e,i,a,s,r,o,f,l,d,g,u,c,b,h,D,H,j,m,A,C,p,M;if(7!=n.C[t]||0!=n.s[t]||n.j[t]+n.o[t]>3)return!1;if(t<n.f&&qf.Or(n.p,t)){if(1!=n.o[t])return!1;if(1!=qf.Dn(n,t,7))return!1;for(qf.nu(n,7),A=n.p,j=0;j<A.i.a.length;j++)if(qf.Qr(A,j,t)){if(5==Vf.Oi(A.j,j).length||6==Vf.Oi(A.j,j).length){for(C=Vf.Oi(A.i,j),D=-1,f=0;f<C.length;f++)if(C[f]==t){D=f;break}for(a=0,H=null,h=null,5==C.length&&((H=$l(Qf.Mmb,G,6,2,15,1))[0]=C[D-1<0?D+4:D-1],H[1]=C[D-4<0?D+1:D-4],(h=$l(Qf.Mmb,G,6,2,15,1))[0]=C[D-2<0?D+3:D-2],h[1]=C[D-3<0?D+2:D-3]),6==C.length&&((H=$l(Qf.Mmb,G,6,3,15,1))[0]=C[D-1<0?D+5:D-1],H[1]=C[D-3<0?D+3:D-3],H[2]=C[D-5<0?D+1:D-5],(h=$l(Qf.Mmb,G,6,2,15,1))[0]=C[D-2<0?D+4:D-2],h[1]=C[D-4<0?D+2:D-4]),l=0;l<C.length;l++)t!=C[l]&&7==qf.Hk(n,C[l])&&1==qf.An(n,C[l])&&--a;for(d=0;d<H.length;d++){for(s=-1,r=-1,b=0;b<qf.Kn(n,H[d]);b++)if(!qf.Co(n,qf.Ln(n,H[d],b))){s=qf.Jn(n,H[d],b),r=qf.Ln(n,H[d],b);break}if(-1!=s){if(7==n.C[s]&&0==n.o[s]&&n.j[s]+n.o[s]<=3&&!qf.ye(n,s,!1)){++a;continue}if(8==n.C[s]&&1==n.j[s]){a+=2;continue}if(r<n.g&&qf.Pr(n.p,r))for(p=0;p<A.i.a.length;p++)if(A.d[p]&&qf.Qr(A,p,s)){for(m=Vf.Oi(A.i,p),c=0;c<m.length;c++)if(7==qf.Hk(n,m[c])&&1==qf.An(n,m[c])){--a;break}break}}}for(g=0;g<h.length;g++){for(s=-1,c=0;c<qf.Kn(n,h[g]);c++)qf.Co(n,qf.Ln(n,h[g],c))||(s=qf.Jn(n,h[g],c));6==qf.Hk(n,h[g])?-1!=s&&0!=qf.te(n,s)&&--a:7==qf.Hk(n,h[g])&&0==qf.An(n,h[g])&&(-1==s||!(s<n.f&&qf.Or(n.p,s))&&0==qf.te(n,s))&&++a}return a>0}break}return!1}if(n.o[t]>1)return!1;if(1==n.o[t]){for(u=-1,M=0,f=0;f<n.j[t];f++)if(i=n.i[t][f],2!=n.n[t][f]){if(8==n.C[i])return!1;7!=n.C[i]?i<n.f&&qf.Or(n.p,i)&&--M:(--M,qf.ye(n,i,!1)&&--M)}else{if(6!=n.C[i])return!1;u=i}if(-1==u)return!1;for(e=0,l=0;l<n.j[u];l++)if(1==n.n[u][l]){if(i=n.i[u][l],0!=qf.te(n,i))return!1;i<n.f&&qf.Or(n.p,i)&&++e,7==n.C[i]&&!qf.ye(n,i,!0)&&++M,(8==n.C[i]||16==n.C[i])&&--M}return 2==e&&--M,M>=0}for(o=0;o<n.j[t];o++){if((i=n.i[t][o])<n.f&&qf.Or(n.p,i))return!1;if(6!=n.C[i])return!1;if(0!=qf.te(n,i))return!1;if(0!=n.o[i]&&qf.ze(n,i))return!1}return!0},qf.ye=function(n,t,e){var i,a,s;for(i=!1,s=0;s<n.j[t];s++)if(!qf.Co(n,n.k[t][s])&&1==n.n[t][s]&&!((a=n.i[t][s])<n.f&&qf.Or(n.p,a))&&(6==n.C[a]&&1==qf.te(n,a)||16==n.C[a]&&2==qf.te(n,a))){if(i||!e)return!0;i=!0}return!1},qf.ze=function(n,t){var e,i,a;for(i=0;i<n.j[t];i++)if(1!=n.n[t][i])for(e=n.i[t][i],a=0;a<n.j[e];a++)if(1==n.n[e][a]&&0!=qf.te(n,n.i[e][a]))return!0;return!1},qf.Ce=function(){qf.Ce=vl,qf.Ae=ed(Wl(Qf.myb,1),at,6,15,[-1,-1,-1,0,0,1,2,3,4,5,-1,0,0,0,6,7,8,9,-1,0,0,10,10,10,10,10,10,10,10,10,10,1,11,11,12,13,-1,0,0,10,10,10,10,10,10,10,10,10,10,0,0,0,11,14,-1,0,0,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,10,10,10,10,10,10,10,10,1,1,1,1,-1,-1,-1,-1,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1]),qf.Be=ed(Wl(Qf.myb,1),at,6,15,[-1,-1,-1,0,0,0,2,5,5,5,-1,0,0,0,0,9,9,9,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1])},qf.De=function(n,t,e){var i,a,s,r,o,f,l,d,g,u,c,b,h;for(qf.Ce(),qf.nu(n,7),c=$l(Qf.Nmb,st,6,n.j[t],14,1),u=0,f=0;f<n.j[t];f++)if(a=n.i[t][f],1!=n.C[a]){if(r=0,32&e&&(s=Bd(n.n[t][f]),32190==e?Ud(s,3)<0&&qf.Go(n,n.k[t][f])&&1==n.o[t]&&(s=0):Ud(s,3)<0&&qf.Co(n,n.k[t][f])&&(s=0),r=Gd(r,Yd(s,4))),128&e){if(-1==qf.Ae[n.C[a]])throw bd(new zf.aA(rt+n.C[a]));r=Nd(r,Bd(qf.Ae[n.C[a]]))}else if(64&e){if(-1==qf.Be[n.C[a]])throw bd(new zf.aA(rt+n.C[a]));r=Nd(r,Bd(qf.Be[n.C[a]]))}for(256&e&&((b=n.j[a]-1)>3&&(b=3),!(512&e)&&b>1&&(b=1),r=Gd(r,Qf.Cyb(b<<6))),e&hn&&8&n.u[a]&&(r=Gd(r,256)),e&Gn&&a<n.f&&qf.Or(n.p,a)&&(r=Gd(r,512)),e&ln&&n.u[a]&Xn&&(r=Gd(r,hn)),d=0;Ud(r,c[d])<0;)++d;for(g=f;g>d;g--)c[g]=c[g-1];c[d]=r,++u}for(u>4&&(u=4),i=0,l=0;l<u;l++)i=Gd(i=Yd(i,11),c[l]);if(i=Yd(i,15),-1==qf.Ae[n.C[t]])throw bd(new zf.aA(rt+n.C[t]));if(i=Gd(i,Bd(qf.Ae[n.C[t]])),2&e?((h=n.p&&t<n.f?qf.Dr(n.p,t):0)>9&&(h=9),h>2&&(h-=2),i=Gd(i,Qf.Cyb(h<<4))):1&e&&8&n.u[t]&&(i=Gd(i,64)),4&e&&t<n.f&&qf.Or(n.p,t)&&(i=Gd(i,hn)),8&e&&n.u[t]&dn&&(i=Gd(i,Gn)),16&e&&n.u[t]&Xn&&(i=Gd(i,dn)),e&dn&&(qf.ue(n,t)&&(i=Gd(i,Xn)),qf.xe(n,t)))for(o=0;o<n.f;o++)if(qf.ve(n,o)){i=Gd(i,ln);break}return e&Xn&&(i=Gd(i,Yd(Bd(qf.Dn(n,t,10)),7))),i},qf.Ee=function(n,t,e,i,a,s){var r,o,f,l;for(f=0,o=0;o<n.P.f;o++)Sd(wd(qf.Ck(n.P,n.w[o]),i),0)&&++f;if(0!=f)for(qf.Cf(n,t),qf.xf(n,Qf.Cyb(f),e),r=0;r<n.P.f;r++)0!=Ud(l=wd(qf.Ck(n.P,n.w[r]),i),0)&&(qf.xf(n,Qf.Cyb(r),e),1!=a&&qf.xf(n,qd(l,s),a))},qf.Fe=function(n,t,e,i,a,s){var r,o,f,l;for(f=0,o=0;o<n.P.g;o++)qf.Wk(n.P,n.A[o])&i&&++f;if(0!=f)for(qf.Cf(n,t),qf.xf(n,Qf.Cyb(f),e),r=0;r<n.P.g;r++)0!=(l=qf.Wk(n.P,n.A[r])&i)&&(qf.xf(n,Qf.Cyb(r),e),1!=a&&qf.xf(n,Qf.Cyb(l>>s),a))},qf.Ge=function(n){for(var t,e,i,a,s,r;;){for(s=$l(Qf.nyb,tn,6,n.S+1,16,1),i=-1,e=0;e<n.P.f;e++)0!=qf.$n(n.P,e)&&(s[n.d[e]]&&i<n.d[e]&&(i=n.d[e]),s[n.d[e]]=!0);if(-1==i)break;for(a=0,t=0;t<n.P.f;t++)r=0,n.d[t]==i&&(r=++a),qf.yg(n.c[t],t),qf.vg(n.c[t],n.b,Bd(n.d[t])),qf.vg(n.c[t],8,Qf.Cyb(r));n.S=qf.ff(n)}},qf.He=function(n){var t,e,i,a;for(e=0;e<n.P.f;e++)qf.yg(n.c[e],e),qf.vg(n.c[e],2*n.b+4,Yd(Bd(n.d[e]),n.b+4));for(a=!1,t=0;t<n.P.f;t++)a|=qf.Ue(n,t,3);for(i=0;i<n.P.g;i++)a|=qf.Pe(n,i,3);if(!a)return!1;for(;n.S<n.P.f&&(a=qf.cf(n));)qf.ef(n),n.N&&qf.Og(n.N,n.d);return!0},qf.Ie=function(n){var t,e,i,a,s;for(e=0;e<n.P.f;e++)qf.yg(n.c[e],e),qf.vg(n.c[e],n.b+1,Bd(2*n.d[e]));for(s=$l(Qf.Mmb,G,6,n.S+1,15,1),i=0;i<n.P.f;i++)++s[n.d[i]];for(a=1;1==s[a];)++a;for(t=0;t<n.P.f;t++)if(n.d[t]==a){qf.wg(n.c[t],1);break}n.S=qf.ff(n)},qf.Je=function(n,t,e){var i,a,s,r,o;return(6==qf.Hk(n.P,t)||7==qf.Hk(n.P,t))&&(a=qf.Jn(n.P,t,0),s=qf.Jn(n.P,t,1),1==qf.An(n.P,a)&&1==qf.An(n.P,s)&&(1!=qf.Kn(n.P,a)&&1!=qf.Kn(n.P,s)&&(!(qf.vn(n.P,a)>3||qf.vn(n.P,s)>3)&&((!(r=new qf.Bj(n.P,n.d,t,a)).f||1!=e)&&((!(o=new qf.Bj(n.P,n.d,t,s)).f||1!=e)&&((!r.f||!o.f)&&(3==e&&(r.f&&r.c&&(n.U[t]=!0),o.f&&o.c&&(n.U[t]=!0)),i=n.hb?qf.Le(n,r,o):qf.Ke(r,o),1==e?n.bb[t]=i:2==e&&(r.f&&(1==i?qf.wg(n.c[r.b],Bd(n.d[a])):qf.wg(n.c[r.d],Bd(n.d[a]))),o.f&&(2==i?qf.wg(n.c[o.b],Bd(n.d[s])):qf.wg(n.c[o.d],Bd(n.d[s])))),!0)))))))},qf.Ke=function(n,t){var e,i,a;if(i=qf.Aj(n),a=qf.Aj(t),-1==i||-1==a||!(i+a&1))return 3;switch(e=0,i+a){case 3:case 7:e=2;break;case 5:e=1}return e},qf.Le=function(t,e,i){var a,s;return(a=$l(Qf.Mmb,G,6,4,15,1))[0]=e.b,a[1]=e.a,a[2]=i.a,a[3]=i.b,s=qf.Wj(t.P,a),n.Math.abs(s)<.3||n.Math.abs(s)>ot?3:s<0?2:1},qf.Me=function(n,t,e){var i,a,s,r,o;return!!qf.Do(n.P,t)&&(i=qf.Mk(n.P,0,t),a=qf.Mk(n.P,1,t),(!(r=new qf.Bj(n.P,n.d,i,a)).f||1!=e)&&((!(o=new qf.Bj(n.P,n.d,a,i)).f||1!=e)&&((!r.f||!o.f)&&(3==e&&(r.f&&(n.T[t]=qf.Sf(n,a)),o.f&&(n.T[t]=qf.Sf(n,i))),s=n.hb?qf.Oe(n,r,o):qf.Ne(r,o),1==e?n.k[t]=s:2==e&&(r.f&&(2==s?qf.wg(n.c[r.b],Bd(n.d[a])):qf.wg(n.c[r.d],Bd(n.d[a]))),o.f&&(2==s?qf.wg(n.c[o.b],Bd(n.d[i])):qf.wg(n.c[o.d],Bd(n.d[i])))),!0))))},qf.Ne=function(n,t){var e,i,a;if(i=qf.Aj(n),a=qf.Aj(t),-1==i||-1==a||!(i+a&1))return 3;switch(e=0,i+a){case 3:case 7:e=1;break;case 5:e=2}return e},qf.Oe=function(t,e,i){var a,s;return(a=$l(Qf.Mmb,G,6,4,15,1))[0]=e.b,a[1]=e.a,a[2]=i.a,a[3]=i.b,s=qf.Wj(t.P,a),n.Math.abs(s)<.3||n.Math.abs(s)>ot?3:s<0?1:2},qf.Pe=function(n,t,e){var i,a,s,r,o,f,l,d;if(0!=n.k[t])return!1;if(n.P.K)for(l=0;l<2;l++)for(i=qf.Mk(n.P,l,t),d=0;d<qf.vn(n.P,i);d++)if(Sd(wd(qf.Ck(n.P,qf.Jn(n.P,i,d)),en),0))return!1;return 1==qf.Uk(n.P,t)?qf.Me(n,t,e):2==qf.Uk(n.P,t)&&(!qf.Co(n.P,t)&&(s=qf.Mk(n.P,0,t),r=qf.Mk(n.P,1,t),1!=qf.Kn(n.P,s)&&1!=qf.Kn(n.P,r)&&(!(qf.Kn(n.P,s)>3||qf.Kn(n.P,r)>3)&&(2!=qf.An(n.P,s)&&2!=qf.An(n.P,r)&&((!(o=new qf.Bj(n.P,n.d,r,s)).f||1!=e)&&((!(f=new qf.Bj(n.P,n.d,s,r)).f||1!=e)&&((!o.f||!f.f)&&(3==e&&(o.f&&o.c&&(n.T[t]=!0),f.f&&f.c&&(n.T[t]=!0)),a=qf.tl(n.P,t)?3:n.hb?qf.Re(n,o,f):qf.Qe(o,f),1==e?n.k[t]=a:2==e&&(o.f&&(1==a?qf.wg(n.c[o.b],Bd(n.d[s])):2==a&&qf.wg(n.c[o.d],Bd(n.d[s]))),f.f&&(1==a?qf.wg(n.c[f.b],Bd(n.d[r])):2==a&&qf.wg(n.c[f.d],Bd(n.d[r])))),!0))))))))},qf.Qe=function(n,t){return-1==qf.Aj(n)||-1==qf.Aj(t)||1&(qf.Aj(n)|qf.Aj(t))?3:qf.Aj(n)==qf.Aj(t)?1:2},qf.Re=function(t,e,i){var a,s,r,o,f;return(a=$l(Qf.Kmb,S,6,3,15,1))[0]=qf.Ek(t.P,i.a)-qf.Ek(t.P,e.a),a[1]=qf.Fk(t.P,i.a)-qf.Fk(t.P,e.a),a[2]=qf.Gk(t.P,i.a)-qf.Gk(t.P,e.a),(o=$l(Qf.Kmb,S,6,3,15,1))[0]=qf.Ek(t.P,e.b)-qf.Ek(t.P,e.a),o[1]=qf.Fk(t.P,e.b)-qf.Fk(t.P,e.a),o[2]=qf.Gk(t.P,e.b)-qf.Gk(t.P,e.a),(f=$l(Qf.Kmb,S,6,3,15,1))[0]=qf.Ek(t.P,i.b)-qf.Ek(t.P,i.a),f[1]=qf.Fk(t.P,i.b)-qf.Fk(t.P,i.a),f[2]=qf.Gk(t.P,i.b)-qf.Gk(t.P,i.a),(s=$l(Qf.Kmb,S,6,3,15,1))[0]=a[1]*o[2]-a[2]*o[1],s[1]=a[2]*o[0]-a[0]*o[2],s[2]=a[0]*o[1]-a[1]*o[0],(r=$l(Qf.Kmb,S,6,3,15,1))[0]=a[1]*s[2]-a[2]*s[1],r[1]=a[2]*s[0]-a[0]*s[2],r[2]=a[0]*s[1]-a[1]*s[0],(o[0]*r[0]+o[1]*r[1]+o[2]*r[2])/(n.Math.sqrt(o[0]*o[0]+o[1]*o[1]+o[2]*o[2])*n.Math.sqrt(r[0]*r[0]+r[1]*r[1]+r[2]*r[2]))<0^(f[0]*r[0]+f[1]*r[1]+f[2]*r[2])/(n.Math.sqrt(f[0]*f[0]+f[1]*f[1]+f[2]*f[2])*n.Math.sqrt(r[0]*r[0]+r[1]*r[1]+r[2]*r[2]))<0?1:2},qf.Se=function(n,t){var e,i,a,s;return e=qf.ok(n.P,t),s=-1,(i=qf.Yn(n.P,t,!1))!=(a=qf.Yn(n.P,t,!0))?s=-1!=e&&e>i?e<<24>>24:i<<24>>24:-1!=e?(e>a||e<a&&e>=qf.eo(n.P,t))&&(s=e<<24>>24):qf.hp(n.P,t)||0==qf.On(n.P,t)||(s=qf.eo(n.P,t),s-=qf._k(n.P,t,s)),qf.nf(n,t,s),s},qf.Te=function(n){var t,e,i,a,s,r,o,f,l,d,g;for(i=$l(Qf.Mmb,G,6,n.M,15,1),t=0;t<n.P.f;t++){for(d=qf.Kn(n.P,t)+qf.ao(n.P,t),l=0,s=0;s<qf.wn(n.P,t);s++)if(s<qf.Kn(n.P,t)||s>=qf.vn(n.P,t)){for(g=2*n.d[qf.Jn(n.P,t,s)],e=qf.Ln(n.P,t,s),2==qf.Uk(n.P,e)&&(qf.Co(n.P,e)||++g),o=0;o<l&&!(g<i[o]);o++);for(f=l;f>o;f--)i[f]=i[f-1];i[o]=g,++l}for(qf.yg(n.c[t],t),qf.vg(n.c[t],n.b,Bd(n.d[t])),r=d;r<n.M;r++)qf.vg(n.c[t],n.b+1,0);for(a=0;a<d;a++)qf.vg(n.c[t],n.b+1,Qf.Cyb(i[a]))}},qf.Ue=function(n,t,e){var i,a,s,r,o,f,l,d,g,u,c,b,h;if(0!=n.bb[t])return!1;if(5!=qf.Hk(n.P,t)&&6!=qf.Hk(n.P,t)&&7!=qf.Hk(n.P,t)&&14!=qf.Hk(n.P,t)&&15!=qf.Hk(n.P,t)&&16!=qf.Hk(n.P,t))return!1;if(0!=qf.An(n.P,t)){if(qf.Eo(n.P,t))return qf.Je(n,t,e);if(15!=qf.Hk(n.P,t)&&16!=qf.Hk(n.P,t))return!1}if(qf.Kn(n.P,t)<3||qf.vn(n.P,t)>4)return!1;if(qf.qk(n.P,t)>0&&6==qf.Hk(n.P,t))return!1;if(5==qf.Hk(n.P,t)&&4!=qf.vn(n.P,t))return!1;if(n.P.K){if(Sd(wd(qf.Ck(n.P,t),en),0))return!1;for(o=0;o<qf.vn(n.P,t);o++)if(Sd(wd(qf.Ck(n.P,qf.Jn(n.P,t,o)),en),0))return!1}if(7==qf.Hk(n.P,t)&&!n.Q[t])return!1;for(b=$l(Qf.Mmb,G,6,4,15,1),h=$l(Qf.Mmb,G,6,4,15,1),d=$l(Qf.nyb,tn,6,4,16,1),f=0;f<qf.vn(n.P,t);f++){for(s=-1,a=0,l=0;l<qf.vn(n.P,t);l++)d[l]||s<n.d[qf.Jn(n.P,t,l)]&&(s=n.d[qf.Jn(n.P,t,l)],a=l);b[f]=a,h[f]=s,d[a]=!0}if(4==qf.vn(n.P,t)&&h[0]==h[1]&&h[2]==h[3])return!1;if(4==qf.vn(n.P,t)&&(h[0]==h[2]||h[1]==h[3]))return!1;if(3==qf.vn(n.P,t)&&h[0]==h[2])return!1;for(g=0,u=0,c=!1,r=1;r<qf.vn(n.P,t);r++)if(h[r-1]==h[r]){if(1==e||0==h[r])return!1;g=qf.Jn(n.P,t,b[r-1]),u=qf.Jn(n.P,t,b[r]),3==e&&qf.Po(n.P,qf.Ln(n.P,t,b[r]))&&(n.U[t]=!0),c=!0}return!(1!=e&&!c)&&(i=n.hb?qf.We(n,t,b):qf.Ve(n,t,b),1==e?n.bb[t]=i:2==e&&(1==i?qf.wg(n.c[g],Bd(n.d[t])):2==i&&qf.wg(n.c[u],Bd(n.d[t]))),!0)},qf.Ve=function(n,t,e){var i,a,s,r,o,f,l,d,g,u;for(u=ed(Wl(Qf.Mmb,2),ft,8,0,[ed(Wl(Qf.Mmb,1),G,6,15,[2,1,2,1]),ed(Wl(Qf.Mmb,1),G,6,15,[1,2,2,1]),ed(Wl(Qf.Mmb,1),G,6,15,[1,1,2,2]),ed(Wl(Qf.Mmb,1),G,6,15,[2,1,1,2]),ed(Wl(Qf.Mmb,1),G,6,15,[2,2,1,1]),ed(Wl(Qf.Mmb,1),G,6,15,[1,2,1,2])]),i=$l(Qf.Kmb,S,6,qf.vn(n.P,t),15,1),r=0;r<qf.vn(n.P,t);r++)i[r]=qf.Lk(n.P,qf.Jn(n.P,t,e[r]),t);if(3!=(l=qf.Qn(n.P,t,e,i,null)<<24>>24))return l;for(d=0,g=0,o=0;o<qf.vn(n.P,t);o++)a=qf.Ln(n.P,t,e[o]),qf.Mk(n.P,0,a)==t&&(129==qf.Xk(n.P,a)&&(0!=g&&qf.Gm(n.P,t),d=o,g=1),257==qf.Xk(n.P,a)&&(0!=g&&qf.Gm(n.P,t),d=o,g=2));if(0==g)return 3;for(s=1;s<qf.vn(n.P,t);s++)i[s]<i[0]&&(i[s]+=rn);if(3==qf.vn(n.P,t)){switch(d){case 0:(i[1]<i[2]&&i[2]-i[1]<on||i[1]>i[2]&&i[1]-i[2]>on)&&(g=3-g);break;case 1:i[2]-i[0]>on&&(g=3-g);break;case 2:i[1]-i[0]<on&&(g=3-g)}return 1==g?2:1}return f=0,i[1]<=i[2]&&i[2]<=i[3]?f=0:i[1]<=i[3]&&i[3]<=i[2]?f=1:i[2]<=i[1]&&i[1]<=i[3]?f=2:i[2]<=i[3]&&i[3]<=i[1]?f=3:i[3]<=i[1]&&i[1]<=i[2]?f=4:i[3]<=i[2]&&i[2]<=i[1]&&(f=5),u[f][d]==g?2:1},qf.We=function(t,e,i){var a,s,r,o,f;for(a=$l(Qf.Mmb,G,6,4,15,1),o=0;o<qf.vn(t.P,e);o++)a[o]=qf.Jn(t.P,e,i[o]);for(3==qf.vn(t.P,e)&&(a[3]=e),s=_l(Qf.Kmb,[j,S],[13,6],15,[3,3],2),r=0;r<3;r++)s[r][0]=qf.Ek(t.P,a[r+1])-qf.Ek(t.P,a[0]),s[r][1]=qf.Fk(t.P,a[r+1])-qf.Fk(t.P,a[0]),s[r][2]=qf.Gk(t.P,a[r+1])-qf.Gk(t.P,a[0]);return(f=$l(Qf.Kmb,S,6,3,15,1))[0]=s[0][1]*s[1][2]-s[0][2]*s[1][1],f[1]=s[0][2]*s[1][0]-s[0][0]*s[1][2],f[2]=s[0][0]*s[1][1]-s[0][1]*s[1][0],(s[2][0]*f[0]+s[2][1]*f[1]+s[2][2]*f[2])/(n.Math.sqrt(s[2][0]*s[2][0]+s[2][1]*s[2][1]+s[2][2]*s[2][2])*n.Math.sqrt(f[0]*f[0]+f[1]*f[1]+f[2]*f[2]))>0?1:2},qf.Xe=function(n){var t,e;for(t=0,Vf.DQb(n.c),e=0;e<n.c.length;e++)(0==e||0!=qf.xg(n.c[e],n.c[e-1]))&&++t,n.d[n.c[e].a]=t;return t},qf.Ye=function(n){var t,e,i,a,s,r,o,f,l,d,g,u;if(!n.v)for(n.v=new Vf.bj,d=0,g=$l(Qf.Mmb,G,6,n.P.f,15,1),r=$l(Qf.Mmb,G,6,n.P.f,15,1),f=$l(Qf.Mmb,G,6,n.P.g,15,1),t=0;t<n.P.f;t++)if(0==g[t]&&(qf.Oo(n.P,t)||1==qf.An(n.P,t))){for(r[0]=t,o=1,l=0,g[t]=++d,e=$l(Qf.nyb,tn,6,n.P.g,16,1),s=0;s<o;s++)for(u=0;u<qf.Kn(n.P,r[s]);u++)a=qf.Ln(n.P,r[s],u),(qf.Po(n.P,a)||2==qf.Uk(n.P,a)||qf.Do(n.P,a))&&(i=qf.Jn(n.P,r[s],u),e[a]||(f[l++]=a,e[a]=!0),0==g[i]&&(r[o++]=i,g[i]=d));Vf.Ji(n.v,new qf.Eg(r,o,f,l))}},qf.Ze=function(n){var t;for(n.Q=$l(Qf.nyb,tn,6,n.P.f,16,1),t=0;t<n.P.f;t++)if(7==qf.Hk(n.P,t)){if(4==qf.Kn(n.P,t)){n.Q[t]=!0;continue}if(3==qf.Kn(n.P,t)){if(3==qf.En(n.P,t)){n.Q[t]=!0;continue}if(1==qf.qk(n.P,t)){n.Q[t]=!0;continue}if(qf.Io(n.P,t,!0))continue;if(32&n.O){n.Q[t]=!0;continue}if(qf.No(n.P,t)){n.Q[t]=!0;continue}}}},qf.$e=function(n,t){var e,i,a,s;for(a=!1,i=0;i<n.P.g;i++)qf.Pe(n,i,1)&&(n.o[i]=n.J,t&&qf.of(n,i),a=!0);for(s=!1,e=0;e<n.P.f;e++)qf.Ue(n,e,1)&&(n.gb[e]=n.J,t&&qf.pf(n,e),s=!0);return s&&(n.J=!n.J),a||s},qf._e=function(n){var t,e,i,a,s,r,o,f,l,d,g,u,c,b,h,D,H,j,m,A,C,p,M,I;for(j=$l(Qf.nyb,tn,6,n.P.f,16,1),m=$l(Qf.nyb,tn,6,n.P.g,16,1),t=0,C=!1,128&n.O&&(n.W=$l(Qf.Mmb,G,6,n.P.f,15,1),n.V=$l(Qf.Mmb,G,6,n.P.g,15,1)),i=0;i<n.P.f;i++)n.U[i]&&(n.db[i]||qf.Ue(n,i,1)&&(n.db[i]=!0,j[i]=!0,++t));for(s=0;s<n.P.g;s++)n.T[s]&&(n.n[s]||qf.Pe(n,s,1)&&(n.n[s]=!0,m[s]=!0,++t));if(1==t){for(e=0;e<n.P.f;e++)if(j[e]){n.bb[e]=0;break}for(a=0;a<n.P.g;a++)if(m[a]){n.k[a]=0;break}}else if(t>1)for(qf.Ye(n),n.R=0,o=new Vf.eQb(n.v);o.a<o.c.a.length;){for(r=Vf.dQb(o),A=0,p=0,d=0,l=0,g=-1,f=-1,b=0;b<r.a.length;b++)j[r.a[b]]&&(++A,1!=n.bb[r.a[b]]&&2!=n.bb[r.a[b]]||(++p,C=!0,g<n.d[r.a[b]]&&(g=n.d[r.a[b]],d=r.a[b])));for(h=0;h<r.b.length;h++)m[r.b[h]]&&(++A,u=(M=n.d[qf.Mk(n.P,0,r.b[h])])>(I=n.d[qf.Mk(n.P,1,r.b[h])])?(M<<16)+I:(I<<16)+M,1!=n.k[r.b[h]]&&2!=n.k[r.b[h]]||(++p,C=!0,f<u&&(f=u,l=r.b[h])));if(0!=A)if(1==A){for(D=0;D<r.a.length;D++)j[r.a[D]]&&(n.bb[r.a[D]]=0);for(c=0;c<r.b.length;c++)m[r.b[c]]&&(n.k[r.b[c]]=0)}else if(1==p){for(D=0;D<r.a.length;D++)j[r.a[D]]&&(n.bb[r.a[D]]=3);for(c=0;c<r.b.length;c++)m[r.b[c]]&&(n.k[r.b[c]]=3)}else{if(128&n.O){for(++n.R,D=0;D<r.a.length;D++)j[r.a[D]]&&(n.W[r.a[D]]=n.R);for(c=0;c<r.b.length;c++)m[r.b[c]]&&(n.V[r.b[c]]=n.R)}if(H=!1,-1!=g?2==n.bb[d]&&(H=!0):2==n.k[l]&&(H=!0),H){for(D=0;D<r.a.length;D++)if(j[r.a[D]])switch(n.bb[r.a[D]]){case 1:n.bb[r.a[D]]=2;break;case 2:n.bb[r.a[D]]=1}for(c=0;c<r.b.length;c++)if(m[r.b[c]])switch(n.k[r.b[c]]){case 1:n.k[r.b[c]]=2;break;case 2:n.k[r.b[c]]=1}}}}return C},qf.af=function(n,t){var e,i,a,s,r,o,f,l,d,g,u;for(s=_l(Qf.Mmb,[ft,G],[8,6],15,[2,32],2),r=0;r<2;r++){for(e=$l(Qf.Mmb,ft,8,32,0,2),u=0,a=0;a<32;a++)if(null!=t[r][a]){for(d=t[r][a].length,e[a]=$l(Qf.Mmb,G,6,d,15,1),o=0;o<d;o++)e[a][o]=n.d[t[r][a][o]];Gf.VUb(e[a],Gf.zVb(Vl(Vf.NQb.prototype.$d,Vf.NQb,[]))),++u}for(g=u;g>0;g--){for(l=0,f=null,i=0;i<32;i++)if(null!=e[i])if(null==f||f.length<e[i].length)f=e[i],l=i;else if(f.length==e[i].length)for(o=f.length-1;o>=0;o--)if(f[o]<e[i][o]){f=e[i],l=i;break}s[r][l]=g,e[l]=null}}return s},qf.bf=function(t){var e,i,a,s,r,o,f,l,d,g,u,c,b,h,D,H,j,m,A;if(u=!1,t.P.K)for(d=0;d<t.P.g;d++)if(0!=qf.Wk(t.P,d)){u=!0;break}for(t.M=2,i=0;i<t.P.f;i++)t.M=n.Math.max(t.M,qf.Kn(t.P,i)+qf.ao(t.P,i));for(l=n.Math.max(2,u?(62+t.b+t.M*(t.b+23))/63|0:(62+t.b+t.M*(t.b+5))/63|0),t.d=$l(Qf.Mmb,G,6,t.P.q,15,1),t.c=$l(Qf.Ymb,lt,161,t.P.f,0,1),a=0;a<t.P.f;a++)t.c[a]=new qf.zg(l);for(f=!1,s=0;s<t.P.f;s++)qf.yg(t.c[s],s),Sd(wd(qf.Ck(t.P,s),1),0)||null!=qf.xk(t.P,s)?qf.vg(t.c[s],8,6):qf.vg(t.c[s],8,Bd(qf.Hk(t.P,s))),qf.vg(t.c[s],8,Bd(qf.Ak(t.P,s))),qf.vg(t.c[s],2,Bd(qf.An(t.P,s))),qf.vg(t.c[s],4,Bd(qf.Kn(t.P,s)+qf.ao(t.P,s))),Sd(wd(qf.Ck(t.P,s),1),0)?qf.vg(t.c[s],4,8):qf.vg(t.c[s],4,Bd(8+qf.qk(t.P,s))),qf.vg(t.c[s],5,Bd(n.Math.min(31,qf.En(t.P,s)))),qf.vg(t.c[s],4,Bd(qf.Se(t,s)+1)),qf.vg(t.c[s],2,Bd(qf.Dk(t.P,s)>>4)),t.P.K&&(qf.vg(t.c[s],46,qf.Ck(t.P,s)),null!=qf.xk(t.P,s)&&(f=!0));if(t.S=qf.ff(t),t.S<t.P.f){for(e=0;e<t.P.f;e++){for(qf.yg(t.c[e],e),qf.vg(t.c[e],t.b,Bd(t.d[e])),c=$l(Qf.Mmb,G,6,qf.Kn(t.P,e),15,1),h=0;h<qf.Kn(t.P,e);h++)c[h]=t.d[qf.Jn(t.P,e,h)]<<5,c[h]|=n.Math.min(31,qf.In(t.P,qf.Ln(t.P,e,h)));for(Gf.VUb(c,Gf.zVb(Vl(Vf.NQb.prototype.$d,Vf.NQb,[]))),D=t.M;D>c.length;D--)qf.vg(t.c[e],t.b+5,0);for(b=c.length-1;b>=0;b--)qf.vg(t.c[e],t.b+5,Qf.Cyb(c[b]))}t.S=qf.ff(t)}if(f&&t.S<t.P.f){for(e=0;e<t.P.f;e++){for(qf.yg(t.c[e],e),qf.vg(t.c[e],t.b,Bd(t.d[e])),m=null==(o=qf.xk(t.P,e))?0:n.Math.min(12,o.length),h=12;h>m;h--)qf.vg(t.c[e],8,0);for(b=m-1;b>=0;b--)qf.vg(t.c[e],8,Qf.Cyb(o[b]))}t.S=qf.ff(t)}if(u&&t.S<t.P.f){for(e=0;e<t.P.f;e++){for(qf.yg(t.c[e],e),qf.vg(t.c[e],t.b,Bd(t.d[e])),g=$l(Qf.Nmb,st,6,qf.Kn(t.P,e)+qf.ao(t.P,e),14,1),H=0,h=0;h<qf.wn(t.P,e);h++)(h<qf.Kn(t.P,e)||h>=qf.vn(t.P,e))&&(g[H]=Bd(t.d[qf.Jn(t.P,e,h)]),g[H]=Yd(g[H],23),g[H]=Gd(g[H],Bd(qf.Wk(t.P,qf.Ln(t.P,e,h)))),++H);for(Gf.VUb(g,Gf.zVb(Vl(Vf.KQb.prototype._d,Vf.KQb,[]))),D=t.M;D>g.length;D--)qf.vg(t.c[e],t.b+23,0);for(b=g.length-1;b>=0;b--)qf.vg(t.c[e],t.b+23,g[b])}t.S=qf.ff(t)}if(8&t.O&&t.S<t.P.f){for(j=new qf.ju,r=0;r<t.P.f;r++)null!=qf.sk(t.P,r)&&qf.hu(j,qf.sk(t.P,r));for(e=0;e<t.P.f;e++)A=null==qf.sk(t.P,e)?0:1+qf.iu(j,qf.sk(t.P,e)),qf.yg(t.c[e],e),qf.vg(t.c[e],t.b,Bd(t.d[e])),qf.vg(t.c[e],t.b,Qf.Cyb(A));t.S=qf.ff(t)}if(16&t.O&&t.S<t.P.f){for(e=0;e<t.P.f;e++)qf.yg(t.c[e],e),qf.vg(t.c[e],t.b,Bd(t.d[e])),qf.vg(t.c[e],1,Bd(qf.Bl(t.P,e)?1:0));t.S=qf.ff(t)}512&t.O&&t.P.K&&qf.Ge(t)},qf.cf=function(n){var t,e,i,a,s,r,o,f,l;for(e=0;e<n.P.f;e++)qf.yg(n.c[e],e),qf.vg(n.c[e],2*n.b+4,Yd(Bd(n.d[e]),n.b+4));for(f=1;f<=n.S;f++){for(a=!1,i=0;i<n.P.f;i++)n.d[i]==f&&(a|=qf.Ue(n,i,2));if(a){if(o=n.S,n.S=qf.ff(n),n.S!=o)return!0;for(t=0;t<n.P.f;t++)qf.yg(n.c[t],t),qf.vg(n.c[t],2*n.b+4,Yd(Bd(n.d[t]),n.b+4))}}for(l=$l(Qf.Zmb,lt,213,n.P.g,0,1),r=0;r<l.length;r++)l[r]=new qf.Cg(n.d[qf.Mk(n.P,0,r)],n.d[qf.Mk(n.P,1,r)],r);for(Vf.BQb(l,0,l.length,null),s=0;s<l.length;s++)if(qf.Pe(n,l[s].a,2)){for(;s+1<l.length&&0==qf.Bg(l[s],l[s+1]);)qf.Pe(n,l[++s].a,2);if(o=n.S,n.S=qf.ff(n),n.S!=o)return!0;for(t=0;t<n.P.f;t++)qf.yg(n.c[t],t),qf.vg(n.c[t],2*n.b+4,Yd(Bd(n.d[t]),n.b+4))}return!1},qf.df=function(n){var t,e,i,a,s,r,o,f,l,d;for(s=0,e=0;e<n.P.f;e++)0!=n._[e]&&(2!=n._[e]||!(256&n.O))&&++s;if(0!=s){for(d=$l(Qf.Mmb,G,6,s,15,1),s=0,i=0;i<n.P.f;i++)0==n._[i]||2==n._[i]&&256&n.O||(d[s]=n._[i]<<29|n.$[i]<<24|n.d[i]<<12|i,++s);for(Gf.VUb(d,Gf.zVb(Vl(Vf.NQb.prototype.$d,Vf.NQb,[]))),r=0,l=0,o=d[0]&$n;;)if(++l==d.length||o!=(d[l]&$n)){for(a=$l(Qf.Mmb,G,6,l-r,15,1),f=r;f<l;f++)t=4095&d[f],a[f-r]=t,n.eb[t]=!0;if(Vf.Ji(n.fb,a),l==d.length)break;o=d[l]&$n,r=l}}},qf.ef=function(n){var t,e,i,a,s,r,o,f,l,d,g,u,c;for(o=!1,f=0;f<n.fb.a.length;f++){for(r=Vf.Oi(n.fb,f),t=!0,c=-1,l=!1,g=0;g<r.length;g++){if(e=r[g],0==n.bb[e]){t=!1;break}if(3!=n.bb[e]){for(d=!0,u=0;u<r.length;u++)if(u!=g&&n.d[e]==n.d[r[u]]){d=!1;break}d&&c<n.d[e]&&(c=n.d[e],l=1==n.bb[e])}}if(t&&-1!=c){for(a=0,s=(i=r).length;a<s;++a)e=i[a],(1==n.bb[e]||2==n.bb[e])&&(n.cb[e]=l),n.eb[e]=!1;Vf.Wi(n.fb,r),o=!0,--f}}return o},qf.ff=function(n){var t,e;t=qf.Xe(n);do{e=t,qf.Te(n),t=qf.Xe(n)}while(e!=t);return t},qf.gf=function(n){for(1&n.O&&!(2&n.O)&&(n.e=Vf.lQb(n.d,n.P.f)),n.O&Gn||(n.U=$l(Qf.nyb,tn,6,n.P.f,16,1),n.T=$l(Qf.nyb,tn,6,n.P.g,16,1),n.S<n.P.f&&(qf.He(n),n.O&Gn||(qf.ef(n),n.N&&qf.Og(n.N,n.d)))),null==n.e&&1&n.O&&2&n.O&&(n.e=Vf.lQb(n.d,n.P.f));n.S<n.P.f;)qf.Ie(n),n.O&Gn||(qf.ef(n),n.N&&qf.Og(n.N,n.d));n.O&Gn||(qf.ef(n),qf._e(n),qf.Ff(n))},qf.hf=function(n){var t,e,i,a,s;for(s=n.S,a=Vf.lQb(n.d,n.P.f),n.P.K||(qf.kf(n),qf.Xf(n,s,a)),n._=$l(Qf.Imb,dt,6,n.P.f,15,1),n.$=$l(Qf.Imb,dt,6,n.P.f,15,1),e=0;e<n.P.f;e++)n._[e]=qf.vk(n.P,e)<<24>>24,n.$[e]=qf.uk(n.P,e)<<24>>24;for(n.j=$l(Qf.Imb,dt,6,n.P.g,15,1),n.i=$l(Qf.Imb,dt,6,n.P.g,15,1),i=0;i<n.P.g;i++)n.j[i]=qf.Rk(n.P,i)<<24>>24,n.i[i]=qf.Qk(n.P,i)<<24>>24;for(qf.jf(n),n.X=!1,n.K=$l(Qf.nyb,tn,6,n.P.f,16,1),t=0;t<n.P.f;t++)0!=n.bb[t]&&(n.K[t]=!0,n.X=!0);qf.mf(n),n.N=null,n.ab=$l(Qf.nyb,tn,6,n.P.f,16,1),n.X&&(n.N=new qf.Ug(n.P,a,n.K,n.bb,n.k,n._,n.$,n.gb,n.o,n.ab),qf.Pg(n.N)),n.cb=$l(Qf.nyb,tn,6,n.P.f,16,1),n.eb=$l(Qf.nyb,tn,6,n.P.f,16,1),n.fb=new Vf.bj,n.N&&qf.Og(n.N,n.d),qf.df(n),qf.Xf(n,s,a),qf.lf(n),n.N&&(n.I=qf.Lg(n.N)),qf.wf(n)},qf.jf=function(n){var t,e,i,a,s,r;for(n.J=!0,s=qf.$e(n,!1);n.S<n.P.f&&s;){for(t=0;t<n.P.f;t++)qf.yg(n.c[t],t),qf.vg(n.c[t],n.b,Bd(n.d[t])),r=n.bb[t]<<7,1!=n.bb[t]&&2!=n.bb[t]||0==n._[t]||(r|=n._[t]<<5,r|=n.$[t]),qf.vg(n.c[t],18,Qf.Cyb(r<<9));for(e=0;e<n.P.g;e++)i=n.k[e]<<7,1!=n.k[e]&&2!=n.k[e]||1!=qf.Xk(n.P,e)||0==n.j[e]||(i|=n.j[e]<<5,i|=n.i[e]),qf.wg(n.c[qf.Mk(n.P,0,e)],Qf.Cyb(i)),qf.wg(n.c[qf.Mk(n.P,1,e)],Qf.Cyb(i));if(a=qf.ff(n),n.S==a)break;n.S=a,s=qf.$e(n,!1)}},qf.kf=function(n){var t,e,i,a;for(n.J=!0,n.Y=$l(Qf.Imb,dt,6,n.P.f,15,1),n.f=$l(Qf.Imb,dt,6,n.P.g,15,1),a=qf.$e(n,!0);n.S<n.P.f&&a;){for(t=0;t<n.P.f;t++)qf.yg(n.c[t],t),qf.vg(n.c[t],n.b+4,Gd(Yd(Bd(n.d[t]),4),Bd(n.bb[t]<<2)));for(e=0;e<n.P.g;e++)qf.wg(n.c[qf.Mk(n.P,0,e)],Bd(n.k[e])),qf.wg(n.c[qf.Mk(n.P,1,e)],Bd(n.k[e]));if(i=qf.ff(n),n.S==i)break;n.S=i,a=qf.$e(n,!0)}},qf.lf=function(n){var t,e,i,a,s,r,o;for(n.J=!0,i=qf.vf(n),n.N&&qf.Og(n.N,n.d)&&(i=qf.vf(n)),qf.$e(n,!1)&&qf.ef(n),r=!0;n.S<n.P.f&&r;){for(a=qf.af(n,i),t=0;t<n.P.f;t++)qf.yg(n.c[t],t),qf.vg(n.c[t],n.b,Bd(n.d[t])),qf.vg(n.c[t],20,0),!n.ab[t]&&0!=n._[t]&&qf.wg(n.c[t],Nd(Bd(n._[t]<<18),Yd(Bd(a[1==n._[t]?0:1][n.$[t]]),8))),o=n.bb[t],n.cb[t]&&(1==o?o=2:2==o&&(o=1)),qf.wg(n.c[t],Qf.Cyb(o<<4));for(e=0;e<n.P.g;e++)qf.wg(n.c[qf.Mk(n.P,0,e)],Bd(n.k[e])),qf.wg(n.c[qf.Mk(n.P,1,e)],Bd(n.k[e]));if(s=qf.ff(n),n.S==s)break;n.S=s,r=!1,n.N&&qf.Og(n.N,n.d)&&(r=!0,i=qf.vf(n)),qf.$e(n,!1)&&(r=!0,qf.ef(n))}},qf.mf=function(n){var t,e;for(t=0;t<n.P.f;t++)(!n.K[t]||3==n.bb[t])&&(n._[t]=0);for(e=0;e<n.P.g;e++)(1!=qf.Xk(n.P,e)||0==n.k[e]||3==n.k[e])&&(n.j[e]=0)},qf.nf=function(n,t,e){null==n.a&&(n.a=$l(Qf.Imb,dt,6,n.P.f,15,1),Vf.oQb(n.a)),n.a[t]=e<<24>>24},qf.of=function(n,t){var e,i,a,s,r,o;if((1==n.k[t]||2==n.k[t])&&!qf.So(n.P,t)){r=!1;try{for(s=0;s<2;s++)if(e=qf.Mk(n.P,s,t),3==qf.Kn(n.P,e)){for(i=$l(Qf.Mmb,G,6,2,15,1),a=0,o=0;o<qf.Kn(n.P,e);o++)qf.Ln(n.P,e,o)!=t&&(i[a++]=qf.Jn(n.P,e,o));n.d[i[0]]>n.d[i[1]]^qf.qf(n,e,i[0],i[1])&&(r=!r)}}catch(e){if(sd(e=cd(e),18))return void(n.f[t]=3);throw bd(e)}1==n.k[t]^r?n.f[t]=1:n.f[t]=2}},qf.pf=function(n,t){var e,i,a,s,r,o,f;if(1==n.bb[t]||2==n.bb[t]){if(o=!1,2==qf.An(n.P,t)&&2==qf.Kn(n.P,t))try{for(r=0;r<2;r++)if(e=qf.Jn(n.P,t,r),3==qf.Kn(n.P,e)){for(a=$l(Qf.Mmb,G,6,2,15,1),s=0,f=0;f<qf.Kn(n.P,e);f++)1==qf.Mn(n.P,e,f)&&(a[s++]=qf.Jn(n.P,e,f));n.d[a[0]]>n.d[a[1]]^qf.qf(n,e,a[0],a[1])&&(o=!o)}}catch(e){if(sd(e=cd(e),18))return void(n.Y[t]=3);throw bd(e)}else{try{i=qf.sf(n,t)}catch(e){if(sd(e=cd(e),18))return void(n.Y[t]=3);throw bd(e)}for(r=1;r<i.length;r++)for(f=0;f<r;f++)n.d[i[r]]<n.d[i[f]]&&(o=!o)}1==n.bb[t]^o?n.Y[t]=1:n.Y[t]=2}},qf.qf=function(n,t,e,i){var a,s,r,o,f,l,d,g,u,c,b,h,D,H,j,m,A,C,p,M,I,P,T,N,w,U,J,L;if(qf.Hk(n.P,e)!=qf.Hk(n.P,i))return qf.Hk(n.P,e)>qf.Hk(n.P,i);if(qf.Ak(n.P,e)!=qf.Ak(n.P,i))return(qf.yl(n.P,e)?(qf.Jj(),qf.Hj)[qf.Hk(n.P,e)]:qf.Ak(n.P,e))>(qf.yl(n.P,i)?(qf.Jj(),qf.Hj)[qf.Hk(n.P,i)]:qf.Ak(n.P,i));for(p=n.P.f,j=$l(Qf.Mmb,G,6,p,15,1),A=$l(Qf.Mmb,G,6,p,15,1),C=$l(Qf.Mmb,G,6,p,15,1),m=$l(Qf.nyb,tn,6,p,16,1),f=$l(Qf.nyb,tn,6,n.P.q,16,1),j[0]=t,j[1]=e,j[2]=i,A[0]=-1,A[1]=0,A[2]=0,f[t]=!0,f[e]=!0,f[i]=!0,u=1,M=2,(w=$l(Qf.Mmb,G,6,64,15,1))[1]=1,w[2]=3,b=2;u<=M;){for(;u<w[b];){if(c=j[u],!m[u]){for(h=0,D=0,P=0;P<qf.Kn(n.P,c);P++){if(d=qf.Jn(n.P,c,P),M+qf.Mn(n.P,c,P)+1>=p&&(p+=n.P.f,j=qf._f(j,p),A=qf._f(A,p),C=qf._f(C,p),m=qf.ag(m,p)),qf.Go(n.P,qf.Ln(n.P,c,P)))++h,D+=qf.Hk(n.P,d);else if(d!=t)for(N=1;N<qf.Mn(n.P,c,P);N++)j[++M]=d,A[M]=u,m[M]=!0;if(d!=j[J=A[u]]){if(o=!1,f[d])for(U=A[J];-1!=U;){if(d==j[U]){o=!0;break}U=A[U]}o?(j[++M]=d,A[M]=u,m[M]=!0):(j[++M]=d,A[M]=u,f[d]=!0)}}0!=h&&(C[++M]=(D<<2)/h|0,A[M]=u,m[M]=!0)}if(++u==R)throw bd(new zf.aA("Emergency break in while loop."))}for(w.length==b+1&&(w=qf._f(w,w.length+64)),w[b+1]=M+1,I=w[b];I<w[b+1];I++)0==C[I]&&(C[I]=(151==qf.Hk(n.P,j[I])||152==qf.Hk(n.P,j[I])?1:qf.Hk(n.P,j[I]))<<2),C[I]+=C[A[I]]<<16;if(qf.uf(n,m,C,A,j,w,b),C[1]!=C[2])return C[1]>C[2];b>1&&qf.rf(C,A,w,b),++b}for(g=$l(Qf.Mmb,G,6,n.P.f,15,1),T=!1,s=0;s<n.P.f;s++)if(f[s]&&!qf.yl(n.P,s)){T=!0;break}if(T){for(r=0;r<n.P.f;r++)g[r]=qf.yl(n.P,r)?(qf.Jj(),qf.Hj)[qf.Hk(n.P,r)]:qf.Ak(n.P,r);if(qf.tf(n,m,C,A,j,g,w,b))return C[1]>C[2]}for(Vf.uQb(g,g.length,0),H=!1,l=0;l<n.P.g;l++)(f[qf.Mk(n.P,0,l)]||f[qf.Mk(n.P,1,l)])&&(1==n.f[l]?(g[qf.Mk(n.P,0,l)]=1,g[qf.Mk(n.P,1,l)]=1,H=!0):2==n.f[l]&&(g[qf.Mk(n.P,0,l)]=2,g[qf.Mk(n.P,1,l)]=2,H=!0));if(H&&qf.tf(n,m,C,A,j,g,w,b))return C[1]>C[2];for(Vf.uQb(g,g.length,0),L=!1,a=0;a<n.P.f;a++)f[a]&&(2==n.Y[a]?(g[a]=1,L=!0):1==n.Y[a]&&(g[a]=2,L=!0));if(L&&qf.tf(n,m,C,A,j,g,w,b))return C[1]>C[2];throw bd(new zf.aA("no distinction applying CIP rules"))},qf.rf=function(n,t,e,i){var a,s,r,o,f,l,d,g,u;for(g=e[i],r=e[i+1]-g,u=$l(Qf.Wmb,w,215,r,0,1),f=0;f<r;f++)u[f]=new qf.ug,u[f].c=n[f+g],u[f].b=t[f+g],u[f].a=f+g;for(a=new qf.rg,d=i;d>1;d--){for(l=0;l<r;l++)u[l].c+=n[u[l].b]<<16,u[l].b=t[u[l].b];for(Vf.BQb(u,0,u.length,a),s=1,o=0;o<r;o++)n[u[o].a]=s,o!=r-1&&0!=qf.qg(u[o],u[o+1])&&++s}},qf.sf=function(n,t){var e,i,a,s,r,o,f;for(r=qf.vn(n.P,t),o=$l(Qf.Mmb,G,6,r,15,1),a=0;a<r;a++)o[a]=qf.Jn(n.P,t,a);for(i=r;i>1;i--){for(e=!1,s=1;s<i;s++)qf.qf(n,t,o[s-1],o[s])&&(e=!0,f=o[s-1],o[s-1]=o[s],o[s]=f);if(!e)break}return o},qf.tf=function(n,t,e,i,a,s,r,o){var f,l;for(l=1;l<o;l++){for(f=r[l];f<r[l+1];f++)e[f]=s[a[f]]+(e[i[f]]<<8);if(qf.uf(n,t,e,i,a,r,l),e[1]!=e[2])return!0;l>1&&qf.rf(e,i,r,l)}return!1},qf.uf=function(n,t,e,i,a,s,r){var o,f,l,d,g,u,c,b,h,D,H;for(g=r;g>1;g--){for(h=s[g]-s[g-1],H=$l(Qf.Umb,w,214,h,0,1),o=s[g],b=0;b<h;b++){for(D=s[g-1]+b,u=o;u<s[g+1]&&i[u]==D;)++u;for(H[b]=new qf.og,H[b].c=D,H[b].d=e[D],H[b].b=t[D]?0:qf.ko(n.P,a[D]),H[b].a=$l(Qf.Mmb,G,6,u-o,15,1),d=o;d<u;d++)H[b].a[d-o]=e[d];Gf.VUb(H[b].a,Gf.zVb(Vl(Vf.NQb.prototype.$d,Vf.NQb,[]))),o=u}for(f=new qf.lg,Vf.BQb(H,0,H.length,f),l=1,c=0;c<h;c++)e[H[c].c]=l,c!=h-1&&0!=qf.kg(H[c],H[c+1])&&++l}},qf.vf=function(n){var t,e;for(e=_l(Qf.Mmb,[j,ft],[41,8],0,[2,32],2),t=0;t<n.P.f;t++)n.K[t]&&(1==n._[t]?e[0][n.$[t]]=qf.Vg(e[0][n.$[t]],t):2==n._[t]&&(e[1][n.$[t]]=qf.Vg(e[0][n.$[t]],t)));return e},qf.wf=function(n){var t,e,i,a,s,r,o,f,l,d,g,u;for(s=0,d=0,r=0,o=0,f=0,l=0,g=0,u=!1,t=$l(Qf.nyb,tn,6,32,16,1),e=0;e<n.P.f;e++)0!=n.bb[e]&&(++s,3==n.bb[e]?++d:0==n._[e]?(++r,n.N&&qf.Kg(n.N,e)&&++o):2==n._[e]?0==n.$[e]&&++l:1==n._[e]&&(t[a=n.$[e]]||(++g,t[a]=!0),0==n.$[e]&&++f,n.N&&qf.Kg(n.N,e)&&(u=!0)));for(i=0;i<n.P.g;i++)0!=n.k[i]&&1==qf.Xk(n.P,i)&&(++s,3==n.k[i]?++d:0==n.j[i]?(++r,n.N&&qf.Kg(n.N,qf.Mk(n.P,0,i))&&qf.Kg(n.N,qf.Mk(n.P,1,i))&&++o):2==n.j[i]?0==n.i[i]&&++l:1==n.j[i]&&(t[a=n.i[i]]||(++g,t[a]=!0),0==n.i[i]&&++f,n.N&&qf.Kg(n.N,qf.Mk(n.P,0,i))&&qf.Kg(n.N,qf.Mk(n.P,1,i))&&(u=!0)));0!=s?0==d?n.I?qf.ym(n.P,gt+(1<<g)):f+o!=s||u?r==s?qf.ym(n.P,_n):l==s?qf.ym(n.P,327680):r==s-1&&1==f?qf.ym(n.P,Nn):qf.ym(n.P,458752+(1<<g)):qf.ym(n.P,ut):qf.ym(n.P,0):qf.ym(n.P,y)},qf.xf=function(n,t,e){for(;0!=e;)0==n.r&&((!n.p||63!=n.t)&&(n.t+=64),zf.QJb(n.s,n.t&B),n.r=6,n.t=0),n.t<<=1,n.t=Od(Gd(Bd(n.t),wd(t,1))),t=qd(t,1),--e,--n.r},qf.yf=function(n){return n.t<<=n.r,(!n.p||63!=n.t)&&(n.t+=64),zf.QJb(n.s,n.t&B),n.s.a},qf.zf=function(n,t){n.s=new zf.XJb,n.r=6,n.t=0,n.p=t},qf.Af=function(t,e,i){var a,s,r,o,f,l,d,g,u,c,b,h,D,H;if(0!=t.P.f){if(u=!1,t.hb&&t.P.q>t.P.f&&!t.P.K)for(u=!0,l=0;l<t.P.f;l++)if(0!=qf.Zn(t.P,l)){u=!1;break}for(H=t.hb?16:8,qf.zf(t,!0),zf.QJb(t.s,u?35:33),qf.xf(t,Bd(t.hb?1:0),1),qf.xf(t,Qf.Cyb(e?1:0),1),qf.xf(t,Qf.Cyb(H/2|0),4),h=0,d=1;d<t.P.f;d++)h=qf.Nf(t,t.w[d],-1==t.C[d]?-1:t.w[t.C[d]],h,i);if(u)for(l=0;l<t.P.f;l++)for(a=t.w[l],b=qf.Kn(t.P,a);b<qf.vn(t.P,a);b++)h=qf.Nf(t,qf.Jn(t.P,a,b),a,h,i);if(t.P.f>1&&0==h)t.q="";else{for(D=h+(c=h/((o=1<<H)/2-1))/2,g=1;g<t.P.f;g++)qf.Bf(t,t.w[g],-1==t.C[g]?-1:t.w[t.C[g]],D,c,H,i);if(u)for(f=0;f<t.P.f;f++)for(a=t.w[f],b=qf.Kn(t.P,a);b<qf.vn(t.P,a);b++)qf.Bf(t,qf.Jn(t.P,a,b),a,D,c,H,i);e&&(r=t.hb?1.5:(qf.Jj(),qf.Jj(),qf.Ij),s=qf.Kk(t.P,u?t.P.q:t.P.f,u?t.P.r:t.P.g,r,i),qf.xf(t,Bd(n.Math.min(o-1,n.Math.max(0,ud(.5+n.Math.log(s/.1)*n.Math.LOG10E/(n.Math.log(2e3)*n.Math.LOG10E)*(o-1))))),H),qf.xf(t,Bd(qf.Ef(i[t.w[0]].a/s,o)),H),qf.xf(t,Bd(qf.Ef(i[t.w[0]].b/s,o)),H),t.hb&&qf.xf(t,Bd(qf.Ef(i[t.w[0]].c/s,o)),H)),t.q=qf.yf(t)}}else t.q=""},qf.Bf=function(n,t,e,i,a,s,r){var o,f,l;o=-1==e?(r[t].a-r[n.w[0]].a)/8:r[t].a-r[e].a,f=-1==e?(r[t].b-r[n.w[0]].b)/8:r[t].b-r[e].b,qf.xf(n,Bd(ud((i+o)/a)),s),qf.xf(n,Bd(ud((i+f)/a)),s),n.hb&&(l=-1==e?(r[t].c-r[n.w[0]].c)/8:r[t].c-r[e].c,qf.xf(n,Bd(ud((i+l)/a)),s))},qf.Cf=function(n,t){var e;for(e=0;e<n.u;e++)t-=16;for(t<0&&(zf.aKb(),String.fromCharCode(10));t>15;)qf.xf(n,1,1),qf.xf(n,15,4),t-=16,++n.u;qf.xf(n,1,1),qf.xf(n,Qf.Cyb(t),4)},qf.Df=function(n){var t,e,i,a,s,r;if(0!=n.P.f){for(s=0,i=!1,a=!1,e=0;e<n.P.f;e++)s<qf.zk(n.P,e)&&(s=qf.zk(n.P,e)),qf.nl(n.P,e)?i=!0:a=!0;if(0!=s){for(r=qf.ig(s),qf.zf(n,!0),qf.xf(n,Qf.Cyb(r),4),qf.xf(n,Qf.Cyb(i?1:0),1),qf.xf(n,Qf.Cyb(a?1:0),1),t=0;t<n.P.f;t++)qf.xf(n,Bd(qf.zk(n.P,n.w[t])),r),i&&a&&qf.xf(n,Bd(qf.nl(n.P,n.w[t])?1:0),1);n.L=qf.yf(n)}else n.L=""}else n.L=""},qf.Ef=function(t,e){var i,a,s,r;return i=e/2|0,s=t<0,t=n.Math.abs(t),r=e/32|0,a=n.Math.min(i-1,Od(yd(n.Math.round(t*i/(t+r))))),s?i+a:a},qf.Ff=function(n){var t,e,i;for(t=0;t<n.P.f;t++)3==n.bb[t]&&!qf.jl(n.P,t)&&qf.Gm(n.P,t),(1==qf.vk(n.P,t)||2==qf.vk(n.P,t))&&3==n.bb[t]&&qf.Gm(n.P,t),qf.jl(n.P,t)&&3!=n.bb[t]&&!qf.Zf(n,t)&&qf.Gm(n.P,t);for(i=0;i<n.P.r;i++)qf.Dl(n.P,i)&&!qf.Yf(n,i)&&qf.Gm(n.P,qf.Mk(n.P,0,i));for(e=0;e<n.P.g;e++)2==qf.Uk(n.P,e)&&(!qf.tl(n.P,e)||1!=n.k[e]&&2!=n.k[e]||(n.k[e]=3,qf.xm(n.P,e,386)),3!=n.k[e]||n.n[e]||386!=qf.Xk(n.P,e)&&(qf.Gm(n.P,qf.Mk(n.P,0,e)),qf.Gm(n.P,qf.Mk(n.P,1,e)))),1!=qf.Xk(n.P,e)||3!=n.k[e]||qf.jl(n.P,qf.Mk(n.P,0,e))||qf.jl(n.P,qf.Mk(n.P,1,e))||(qf.Gm(n.P,qf.Mk(n.P,0,e)),qf.Gm(n.P,qf.Mk(n.P,1,e))),1!=qf.Rk(n.P,e)&&2!=qf.Rk(n.P,e)||1==qf.Xk(n.P,e)&&(1==n.k[e]||2==n.k[e])||(qf.Gm(n.P,qf.Mk(n.P,0,e)),qf.Gm(n.P,qf.Mk(n.P,1,e)))},qf.Gf=function(n){var t,e,i,a,s,r,o,f,l,d,g,u,c,b,h,D,H,j,m,A;if(0!=n.P.f&&!n.D){for(n.G=0,A=0,e=1;e<n.P.f;e++)n.d[e]>n.d[A]&&(A=e);for(i=$l(Qf.nyb,tn,6,n.P.f,16,1),s=$l(Qf.nyb,tn,6,n.P.g,16,1),n.F=$l(Qf.Mmb,G,6,n.P.f,15,1),n.w=$l(Qf.Mmb,G,6,n.P.f,15,1),n.C=$l(Qf.Mmb,G,6,n.P.f,15,1),n.A=$l(Qf.Mmb,G,6,n.P.g,15,1),n.w[0]=A,n.F[A]=0,i[A]=!0,o=0,f=1,l=0;o<n.P.f;)if(o<f){for(;;){for(c=0,b=0,g=-1,t=n.w[o],h=0;h<qf.wn(n.P,t);h++)(h<qf.Kn(n.P,t)||h>=qf.vn(n.P,t))&&!i[r=qf.Jn(n.P,t,h)]&&n.d[r]>g&&(c=r,b=qf.Ln(n.P,t,h),g=n.d[r]);if(-1==g)break;n.F[c]=f,n.C[f]=o,n.w[f++]=c,n.A[l++]=b,i[c]=!0,s[b]=!0}++o}else{for(u=0,g=-1,t=0;t<n.P.f;t++)!i[t]&&n.d[t]>g&&(u=t,g=n.d[t]);n.F[u]=f,n.C[f]=-1,n.w[f++]=u,i[u]=!0}for(n.B=$l(Qf.Mmb,G,6,2*(n.P.g-l),15,1);;){for(H=n.P.M,j=n.P.M,m=-1,a=0;a<n.P.g;a++)s[a]||(n.F[qf.Mk(n.P,0,a)]<n.F[qf.Mk(n.P,1,a)]?(D=n.F[qf.Mk(n.P,0,a)],d=n.F[qf.Mk(n.P,1,a)]):(D=n.F[qf.Mk(n.P,1,a)],d=n.F[qf.Mk(n.P,0,a)]),(D<H||D==H&&d<j)&&(H=D,j=d,m=a));if(-1==m)break;s[m]=!0,n.A[l++]=m,n.B[2*n.G]=H,n.B[2*n.G+1]=j,++n.G}n.D=!0}},qf.Hf=function(n){var t,e,i,a,s,r,o,f,l,d,g,u,c,b;for(f=null,b=qf.mo(n.P),g=0;g<b.i.a.length;g++)if(b.e[g]){for(s=0,i=0,a=(e=u=Vf.Oi(b.i,g)).length;i<a;++i)t=e[i],qf.Tf(n,t)&&++s;if(0!=s)if(c=Vf.Oi(b.j,g),null==f&&(f=$l(Qf.nyb,tn,6,n.P.g,16,1)),s==u.length){for(l=-1,d=I,r=0;r<u.length;r++)d>n.w[c[r]]&&(d=n.w[c[r]],l=r);for(;s>0;)f[c[l]]=!0,l=qf.fg(l+2,u.length),s-=2}else{for(o=0;qf.Tf(n,u[o]);)++o;for(;!qf.Tf(n,u[o]);)o=qf.fg(o+1,u.length);for(;s>0;)for(f[c[o]]=!0,o=qf.fg(o+2,u.length),s-=2;!qf.Tf(n,u[o]);)o=qf.fg(o+1,u.length)}}return f},qf.If=function(n,t){return n.k[t]},qf.Jf=function(n){return qf.Kf(n,n.hb)},qf.Kf=function(n,t){return null==n.q&&(qf.Gf(n),qf.Af(n,t,n.P.J)),n.q},qf.Lf=function(n){return null==n.L&&(qf.Gf(n),qf.Df(n)),n.L},qf.Mf=function(n){return null==n.H&&(qf.Gf(n),n.O&Gn||(qf.Vf(n),qf.Wf(n,1),qf.Wf(n,2)),qf.Uf(n)),n.H},qf.Nf=function(t,e,i,a,s){var r,o,f;return a<(r=-1==i?n.Math.abs(s[e].a-s[t.w[0]].a)/8:n.Math.abs(s[e].a-s[i].a))&&(a=r),a<(o=-1==i?n.Math.abs(s[e].b-s[t.w[0]].b)/8:n.Math.abs(s[e].b-s[i].b))&&(a=o),t.hb&&a<(f=-1==i?n.Math.abs(s[e].c-s[t.w[0]].c)/8:n.Math.abs(s[e].c-s[i].c))&&(a=f),a},qf.Of=function(n,t){return n.V[t]},qf.Pf=function(n,t){return n.W[t]},qf.Qf=function(n,t){return null==n.e?-1:n.e[t]},qf.Rf=function(n,t){return n.bb[t]},qf.Sf=function(n,t){var e,i,a,s,r,o,f;for(f=qf.mo(n.P),e=0;e<f.i.a.length;e++)if(f.d[e]&&qf.Qr(f,e,t)){for(s=0,r=(a=Vf.Oi(f.i,e)).length;s<r;++s)if((i=a[s])!=t)for(o=0;o<qf.Kn(n.P,i);o++)if(qf.Do(n.P,qf.Ln(n.P,i,o)))return!0;return!1}return!1},qf.Tf=function(n,t){var e,i,a;if(qf.An(n.P,t)<2)return!1;if(2==qf.Kn(n.P,t))return!0;for(e=0,a=0;a<qf.Kn(n.P,t);a++)i=qf.Ln(n.P,t,a),qf.Co(n.P,i)&&(e+=qf.Uk(n.P,i)-1);return e>1},qf.Uf=function(t){var e,i,a,s,r,o,f,l,d,g,u,c,b,h,D,H,j,m,A,C,p,M,I,P,T,N,w,U,J,L,y,B,R,k,x,E,F,Q,z,S,X,G,Y,q,V;if(qf.zf(t,!1),qf.xf(t,9,4),X=n.Math.max(qf.ig(t.P.f),qf.ig(t.P.g)),qf.xf(t,Qf.Cyb(X),4),0==X)return qf.xf(t,Bd(t.P.K?1:0),1),qf.xf(t,0,1),void(t.H=qf.yf(t));for(G=q=Y=J=0,l=0;l<t.P.f;l++)if(Ld(wd(qf.Ck(t.P,l),1),0)){switch(qf.Hk(t.P,l)){case 6:break;case 7:++G;break;case 8:++q;break;default:++Y}0!=qf.qk(t.P,l)&&++J}for(qf.xf(t,Bd(t.P.f),X),qf.xf(t,Bd(t.P.g),X),qf.xf(t,Qf.Cyb(G),X),qf.xf(t,Qf.Cyb(q),X),qf.xf(t,Qf.Cyb(Y),X),qf.xf(t,Qf.Cyb(J),X),d=0;d<t.P.f;d++)7==qf.Hk(t.P,t.w[d])&&Ld(wd(qf.Ck(t.P,t.w[d]),1),0)&&qf.xf(t,Qf.Cyb(d),X);for(c=0;c<t.P.f;c++)8==qf.Hk(t.P,t.w[c])&&Ld(wd(qf.Ck(t.P,t.w[c]),1),0)&&qf.xf(t,Qf.Cyb(c),X);for(b=0;b<t.P.f;b++)6!=qf.Hk(t.P,t.w[b])&&7!=qf.Hk(t.P,t.w[b])&&8!=qf.Hk(t.P,t.w[b])&&Ld(wd(qf.Ck(t.P,t.w[b]),1),0)&&(qf.xf(t,Qf.Cyb(b),X),qf.xf(t,Bd(qf.Hk(t.P,t.w[b])),8));for(h=0;h<t.P.f;h++)0!=qf.qk(t.P,t.w[h])&&Ld(wd(qf.Ck(t.P,t.w[h]),1),0)&&(qf.xf(t,Qf.Cyb(h),X),qf.xf(t,Bd(8+qf.qk(t.P,t.w[h])),4));for(S=0,p=0,D=1;D<t.P.f;D++)-1==t.C[D]?R=0:(R=1+t.C[D]-p,p=t.C[D]),S<R&&(S=R);for(B=qf.ig(S),qf.xf(t,Qf.Cyb(B),4),p=0,H=1;H<t.P.f;H++)-1==t.C[H]?R=0:(R=1+t.C[H]-p,p=t.C[H]),qf.xf(t,Qf.Cyb(R),B);for(x=0;x<2*t.G;x++)qf.xf(t,Bd(t.B[x]),X);for(I=0;I<t.P.g;I++)U=qf.Wk(t.P,t.A[I])&qn||32==qf.Xk(t.P,t.A[I])?1:qf.Go(t.P,t.A[I])?0:n.Math.min(3,qf.Uk(t.P,t.A[I])),qf.xf(t,Qf.Cyb(U),2);if(i=0,!(t.O&Gn))for(j=0;j<t.P.f;j++)0!=t.Z[t.w[j]]&&3!=t.Z[t.w[j]]&&++i;if(qf.xf(t,Qf.Cyb(i),X),!(t.O&Gn))for(j=0;j<t.P.f;j++)0!=t.Z[t.w[j]]&&3!=t.Z[t.w[j]]&&(qf.xf(t,Qf.Cyb(j),X),0==t._[t.w[j]]?qf.xf(t,Bd(t.Z[t.w[j]]),3):(V=1==t.Z[t.w[j]]?1==t._[t.w[j]]?4:6:1==t._[t.w[j]]?5:7,qf.xf(t,Qf.Cyb(V),3),qf.xf(t,Bd(t.$[t.w[j]]),3)));if(e=0,!(t.O&Gn))for(P=0;P<t.P.g;P++)0!=t.g[t.A[P]]&&3!=t.g[t.A[P]]&&(!qf.So(t.P,t.A[P])||1==qf.Xk(t.P,t.A[P]))&&++e;if(qf.xf(t,Qf.Cyb(e),X),!(t.O&Gn))for(P=0;P<t.P.g;P++)0==t.g[t.A[P]]||3==t.g[t.A[P]]||qf.So(t.P,t.A[P])&&1!=qf.Xk(t.P,t.A[P])||(qf.xf(t,Qf.Cyb(P),X),1==qf.Xk(t.P,t.A[P])?0==t.j[t.A[P]]?qf.xf(t,Bd(t.g[t.A[P]]),3):(V=1==t.g[t.A[P]]?1==t.j[t.A[P]]?4:6:1==t.j[t.A[P]]?5:7,qf.xf(t,Qf.Cyb(V),3),qf.xf(t,Bd(t.i[t.A[P]]),3)):qf.xf(t,Bd(t.g[t.A[P]]),2));for(qf.xf(t,Bd(t.P.K?1:0),1),L=0,m=0;m<t.P.f;m++)0!=qf.Ak(t.P,t.w[m])&&++L;if(0!=L)for(qf.Cf(t,1),qf.xf(t,Qf.Cyb(L),X),j=0;j<t.P.f;j++)0!=qf.Ak(t.P,t.w[j])&&(qf.xf(t,Qf.Cyb(j),X),qf.xf(t,Bd(qf.Ak(t.P,t.w[j])),8));if(t.u=0,t.P.K){for(qf.Ee(t,0,X,Gn,1,-1),qf.Ee(t,3,X,dn,1,-1),qf.Ee(t,4,X,120,4,3),qf.Ee(t,5,X,ct,2,1),qf.Ee(t,6,X,1,1,-1),qf.Ee(t,7,X,bn,4,7),L=0,j=0;j<t.P.f;j++)null!=qf.xk(t.P,t.w[j])&&++L;if(L>0)for(qf.Cf(t,8),qf.xf(t,Qf.Cyb(L),X),A=0;A<t.P.f;A++)if(null!=(C=qf.xk(t.P,t.w[A])))for(qf.xf(t,Qf.Cyb(A),X),qf.xf(t,Bd(C.length),4),r=0,o=(s=C).length;r<o;++r)a=s[r],qf.xf(t,Qf.Cyb(a),8);qf.Fe(t,9,X,384,2,7),qf.Fe(t,10,X,31,5,0),qf.Ee(t,11,X,Xn,1,-1),qf.Fe(t,12,X,qn,8,9),qf.Ee(t,13,X,An,3,14),qf.Ee(t,14,X,Cn,5,17),qf.Ee(t,16,X,zn,3,22)}for(L=0,g=0;g<t.P.f;g++)null!=t.a&&-1!=t.a[t.w[g]]&&++L;if(0!=L)for(qf.Cf(t,17),qf.xf(t,Qf.Cyb(L),X),j=0;j<t.P.f;j++)null!=t.a&&-1!=t.a[t.w[j]]&&(qf.xf(t,Qf.Cyb(j),X),qf.xf(t,Bd(t.a[t.w[j]]),4));if(8&t.O||t.O&hn){for(L=0,z=0,j=0;j<t.P.f;j++)null!=(F=qf.sk(t.P,t.w[j]))&&(++L,z=n.Math.max(z,Gf.zVb(F).length));if(0!=L)for(Q=qf.ig(z),qf.Cf(t,18),qf.xf(t,Qf.Cyb(L),X),qf.xf(t,Qf.Cyb(Q),4),A=0;A<t.P.f;A++)if(null!=(y=qf.sk(t.P,t.w[A])))for(qf.xf(t,Qf.Cyb(A),X),qf.xf(t,Bd(Gf.zVb(y).length),Q),k=0;k<Gf.zVb(y).length;k++)qf.xf(t,(Gf.uVb(k,Gf.zVb(y).length),Bd(Gf.zVb(y).charCodeAt(k))),7)}for(t.P.K&&(qf.Ee(t,19,X,Dn,3,25),qf.Fe(t,20,X,wn,3,17)),L=0,u=0;u<t.P.f;u++)0!=qf.Dk(t.P,t.w[u])&&++L;if(0!=L)for(qf.Cf(t,21),qf.xf(t,Qf.Cyb(L),X),f=0;f<t.P.f;f++)0!=qf.Dk(t.P,t.w[f])&&(qf.xf(t,Qf.Cyb(f),X),qf.xf(t,Bd(qf.Dk(t.P,t.w[f])>>4),2));if(t.P.K&&(qf.Ee(t,22,X,Sn,1,-1),qf.Fe(t,23,X,bt,1,-1),qf.Fe(t,24,X,Vn,2,21)),16&t.O)for(f=0;f<t.P.f;f++)if(qf.Bl(t.P,t.w[f])){for(qf.Cf(t,25),a=0;a<t.P.f;a++)qf.xf(t,Bd(qf.Bl(t.P,t.w[a])?1:0),1);break}if(null!=(E=qf.Hf(t))){for(L=0,P=0;P<t.P.g;P++)E[t.A[P]]&&++L;for(qf.Cf(t,26),qf.xf(t,Qf.Cyb(L),X),T=0;T<t.P.g;T++)E[t.A[T]]&&qf.xf(t,Qf.Cyb(T),X)}for(t.P.K&&qf.Ee(t,27,X,en,1,-1),L=0,N=0;N<t.P.g;N++)32==qf.Xk(t.P,t.A[N])&&++L;if(0!=L)for(qf.Cf(t,28),qf.xf(t,Qf.Cyb(L),X),P=0;P<t.P.g;P++)32==qf.Xk(t.P,t.A[P])&&qf.xf(t,Qf.Cyb(P),X);for(t.P.K&&(qf.Ee(t,29,X,ht,2,30),qf.Ee(t,30,X,v,7,32),qf.Ee(t,32,X,Dt,2,44),qf.Ee(t,33,X,Jn,5,39),qf.Ee(t,34,X,cn,1,-1),qf.Fe(t,35,X,Ht,1,-1),qf.Fe(t,36,X,96,2,5)),L=0,w=0;w<t.P.g;w++)(8==qf.Xk(t.P,t.A[w])||16==qf.Xk(t.P,t.A[w]))&&++L;if(0!=L)for(qf.Cf(t,37),qf.xf(t,Qf.Cyb(L),X),M=0;M<t.P.g;M++)8!=qf.Xk(t.P,t.A[M])&&16!=qf.Xk(t.P,t.A[M])||(qf.xf(t,Qf.Cyb(M),X),qf.xf(t,Bd(8==qf.Xk(t.P,t.A[M])?0:1),1));qf.xf(t,0,1),t.H=qf.yf(t)},qf.Vf=function(n){var t,e,i,a,s,r,o,f,l,d,g;for(n.Z=$l(Qf.Imb,dt,6,n.P.f,15,1),t=0;t<n.P.f;t++)if(1==n.bb[t]||2==n.bb[t]){if(f=n.cb[t],qf.Eo(n.P,t))for(o=0;o<qf.Kn(n.P,t);o++){for(a=qf.Jn(n.P,t,o),g=0,d=$l(Qf.Mmb,G,6,3,15,1),l=0;l<qf.Kn(n.P,a);l++)d[g]=qf.Jn(n.P,a,l),d[g]!=t&&++g;2==g&&n.d[d[0]]>n.d[d[1]]^n.F[d[0]]<n.F[d[1]]&&(f=!f)}else for(o=1;o<qf.Kn(n.P,t);o++)for(l=0;l<o;l++)s=qf.Jn(n.P,t,o),r=qf.Jn(n.P,t,l),n.d[s]>n.d[r]&&(f=!f),n.F[s]<n.F[r]&&(f=!f);n.Z[t]=1==n.bb[t]^f?1:2}else n.Z[t]=n.bb[t];for(n.g=$l(Qf.Imb,dt,6,n.P.g,15,1),e=0;e<n.P.g;e++)if(1==n.k[e]||2==n.k[e]){for(f=!1,o=0;o<2;o++)if(i=qf.Mk(n.P,o,e),3==qf.Kn(n.P,i)){for(d=$l(Qf.Mmb,G,6,2,15,1),g=0,l=0;l<3;l++)qf.Jn(n.P,i,l)!=qf.Mk(n.P,1-o,e)&&(d[g++]=qf.Jn(n.P,i,l));n.d[d[0]]>n.d[d[1]]&&(f=!f),n.F[d[0]]<n.F[d[1]]&&(f=!f)}n.g[e]=1==n.k[e]^f?1:2}else n.g[e]=n.k[e]},qf.Wf=function(t,e){var i,a,s,r,o,f,l,d,g,u,c,b,h;for(l=$l(Qf.Mmb,G,6,32,15,1),d=0,a=0;a<t.P.f;a++)1!=t.Z[a]&&2!=t.Z[a]||t._[a]!=e||l[f=t.$[a]]<t.d[a]&&(0==l[f]&&++d,l[f]=t.d[a]);for(r=0;r<t.P.g;r++)1!=t.g[r]&&2!=t.g[r]||t.j[r]!=e||1!=qf.Xk(t.P,r)||(f=t.i[r],h=n.Math.max(t.d[qf.Mk(t.P,0,r)],t.d[qf.Mk(t.P,1,r)]),l[f]<h&&(0==l[f]&&++d,l[f]=h));for(o=$l(Qf.Imb,dt,6,32,15,1),g=0;g<d;g++){for(c=-1,b=0,u=0;u<32;u++)b<l[u]&&(b=l[u],c=u);l[c]=0,o[c]=g<<24>>24}for(i=0;i<t.P.f;i++)(1==t.Z[i]||2==t.Z[i])&&t._[i]==e&&(t.$[i]=o[t.$[i]]);for(s=0;s<t.P.g;s++)(1==t.g[s]||2==t.g[s])&&t.j[s]==e&&1==qf.Xk(t.P,s)&&(t.i[s]=o[t.i[s]])},qf.Xf=function(n,t,e){var i,a;for(n.S=t,i=0;i<n.P.f;i++)n.d[i]=e[i],n.bb[i]=0,n.gb[i]=!1;for(a=0;a<n.P.g;a++)n.k[a]=0,n.o[a]=!1},qf.Yf=function(n,t){var e,i,a;if((e=qf.Mk(n.P,0,t))>=n.P.f)return!1;if(1==n.bb[e]||2==n.bb[e])return!0;if(3==n.bb[e])return!1;if(-1!=(i=qf.rn(n.P,e)))return 1==n.k[i]||2==n.k[i];for(a=0;a<qf.Kn(n.P,e);a++)if(2==qf.Mn(n.P,e,a)&&(1==n.bb[qf.Jn(n.P,e,a)]||2==n.bb[qf.Jn(n.P,e,a)]))return!0;return!1},qf.Zf=function(n,t){var e;for(e=0;e<qf.Kn(n.P,t);e++)if(3==n.k[qf.Ln(n.P,t,e)]&&1==qf.Mn(n.P,t,e))return!0;return!1},qf.$f=function(n){var t,e,i,a,s,r,o;for(r=$l(Qf.Mmb,G,6,n.S+1,15,1),e=0;e<n.P.f;e++)0==qf.vk(n.P,e)&&(1==n.bb[e]?++r[n.d[e]]:2==n.bb[e]&&--r[n.d[e]]);for(a=0;a<n.P.g;a++)1==qf.Uk(n.P,a)&&0==qf.Rk(n.P,a)&&(1==n.k[a]?(++r[n.d[qf.Mk(n.P,0,a)]],++r[n.d[qf.Mk(n.P,1,a)]]):2==n.k[a]&&(--r[n.d[qf.Mk(n.P,0,a)]],--r[n.d[qf.Mk(n.P,1,a)]]));for(o=1;o<=n.S;o++)if(0!=r[o]){if(s=r[o]<0){for(t=0;t<n.P.f;t++)0==qf.vk(n.P,t)&&(1==n.bb[t]?n.bb[t]=2:2==n.bb[t]&&(n.bb[t]=1));for(i=0;i<n.P.g;i++)1==qf.Uk(n.P,i)&&0==qf.Rk(n.P,i)&&(1==n.k[i]?n.k[i]=2:2==n.k[i]&&(n.k[i]=1))}return s}return!1},qf._f=function(n,t){var e;return e=$l(Qf.Mmb,G,6,t,15,1),zf.bKb(n,0,e,0,n.length),e},qf.ag=function(n,t){var e;return e=$l(Qf.nyb,tn,6,t,16,1),zf.bKb(n,0,e,0,n.length),e},qf.bg=function(n){var t,e;if(null!=n.Y)for(t=0;t<n.P.f;t++)qf.Vl(n.P,t,n.Y[t]);if(null!=n.f)for(e=0;e<n.P.g;e++)qf.qm(n.P,e,n.f[e])},qf.cg=function(n){var t,e,i,a,s,r,o,f,l,d,g;for(t=0;t<n.P.f;t++)if(1==n.bb[t]||2==n.bb[t]){if(f=!1,qf.Eo(n.P,t))for(o=0;o<qf.Kn(n.P,t);o++){for(a=qf.Jn(n.P,t,o),g=0,d=$l(Qf.Mmb,G,6,3,15,1),l=0;l<qf.Kn(n.P,a);l++)d[g]=qf.Jn(n.P,a,l),d[g]!=t&&++g;2==g&&n.d[d[0]]>n.d[d[1]]^d[0]<d[1]&&(f=!f)}else for(o=1;o<qf.Kn(n.P,t);o++)for(l=0;l<o;l++)s=qf.Jn(n.P,t,o),r=qf.Jn(n.P,t,l),n.d[s]>n.d[r]&&(f=!f),s<r&&(f=!f);qf.fm(n.P,t,1==n.bb[t]^f?1:2,n.db[t])}else qf.fm(n.P,t,n.bb[t],n.db[t]);for(e=0;e<n.P.g;e++)if(1==n.k[e]||2==n.k[e]){for(f=!1,o=0;o<2;o++)if(i=qf.Mk(n.P,o,e),3==qf.Kn(n.P,i)){for(d=$l(Qf.Mmb,G,6,2,15,1),g=0,l=0;l<3;l++)qf.Jn(n.P,i,l)!=qf.Mk(n.P,1-o,e)&&(d[g++]=qf.Jn(n.P,i,l));n.d[d[0]]>n.d[d[1]]&&(f=!f),d[0]<d[1]&&(f=!f)}qf.um(n.P,e,1==n.k[e]^f?1:2,n.n[e])}else qf.um(n.P,e,n.k[e],n.n[e])},qf.dg=function(n){var t;for(t=0;t<n.P.f;t++)qf.jm(n.P,t,n.K[t])},qf.eg=function(n){var t,e,i;for(t=0;t<n.P.f;t++)!qf.jl(n.P,t)&&3==n.bb[t]&&qf.Yl(n.P,t,!0);for(e=0;e<n.P.g;e++)3==n.k[e]&&(1==(i=qf.Uk(n.P,e))?qf.Yl(n.P,qf.Mk(n.P,0,e),!0):2==i&&qf.xm(n.P,e,386))},qf.fg=function(n,t){return n<t?n:n-t},qf.gg=function(n){qf.hg.call(this,n,0)},qf.hg=function(n,t){this.P=n,this.O=t,qf.nu(this.P,7),this.b=qf.ig(this.P.f),!(this.O&Gn)&&qf.Ze(this),this.hb=!!(64&t)||qf.il(this.P),this.O&Gn||(this.bb=$l(Qf.Imb,dt,6,this.P.f,15,1),this.db=$l(Qf.nyb,tn,6,this.P.f,16,1),this.gb=$l(Qf.nyb,tn,6,this.P.f,16,1),this.k=$l(Qf.Imb,dt,6,this.P.g,15,1),this.o=$l(Qf.nyb,tn,6,this.P.g,16,1),this.n=$l(Qf.nyb,tn,6,this.P.g,16,1)),qf.bf(this),!(this.O&Gn)&&qf.hf(this),qf.gf(this)},qf.ig=function(n){var t;for(t=0;n>0;)n>>=1,++t;return t},Ol(47,1,{},qf.gg,qf.hg),o.b=0,o.p=!1,o.r=0,o.t=0,o.u=0,o.D=!1,o.G=0,o.I=!1,o.J=!1,o.M=0,o.O=0,o.R=0,o.S=0,o.X=!1,o.hb=!1,Qf.cnb=hd(47),qf.jg=function(t,e){var i,a,s,r;if(t.d!=e.d)return t.d>e.d?1:-1;for(s=t.a.length,r=e.a.length,i=n.Math.min(s,r),a=0;a<i;a++)if(--s,--r,t.a[s]!=e.a[r])return t.a[s]>e.a[r]?1:-1;return s!=r?s>r?1:-1:t.b!=e.b?t.b>e.b?1:-1:0},qf.kg=function(n,t){return qf.jg(n,t)},qf.lg=function(){},Ol(397,1,{},qf.lg),o.Db=function(n,t){return qf.kg(n,t)},o.ib=function(n){return this===n},Qf.Vmb=hd(397),qf.og=function(){},Ol(214,1,{214:1},qf.og),o.b=0,o.c=0,o.d=0,Qf.Umb=hd(214),qf.pg=function(n,t){return n.c!=t.c?n.c>t.c?1:-1:0},qf.qg=function(n,t){return qf.pg(n,t)},qf.rg=function(){},Ol(398,1,{},qf.rg),o.Db=function(n,t){return qf.qg(n,t)},o.ib=function(n){return this===n},Qf.Xmb=hd(398),qf.ug=function(){},Ol(215,1,{215:1},qf.ug),o.a=0,o.b=0,o.c=0,Qf.Wmb=hd(215),qf.vg=function(n,t,e){0==n.b&&(++n.c,n.b=63),63==n.b?(n.d[n.c]=Gd(n.d[n.c],e),n.b-=t):n.b>=t?(n.d[n.c]=Yd(n.d[n.c],t),n.d[n.c]=Gd(n.d[n.c],e),n.b-=t):(n.d[n.c]=Yd(n.d[n.c],n.b),n.d[n.c]=Gd(n.d[n.c],qd(e,t-n.b)),t-=n.b,++n.c,n.b=63-t,n.d[n.c]=Gd(n.d[n.c],wd(e,Qf.Cyb((1<<t)-1))))},qf.wg=function(n,t){n.d[n.c]=Nd(n.d[n.c],t)},qf.xg=function(n,t){var e;for(e=0;e<n.c;e++)if(Sd(n.d[e],t.d[e]))return xd(n.d[e],t.d[e])?-1:1;return Ld(n.d[n.c],t.d[n.c])?0:xd(n.d[n.c],t.d[n.c])?-1:1},qf.yg=function(n,t){n.a=t,n.c=0,n.b=63,Vf.qQb(n.d)},qf.zg=function(n){this.d=$l(Qf.Nmb,st,6,n,14,1)},Ol(161,1,{161:1,19:1},qf.zg),o.Eb=function(n){return qf.xg(this,n)},o.a=0,o.b=0,o.c=0,Qf.Ymb=hd(161),qf.Bg=function(n,t){return n.b!=t.b?n.b>t.b?-1:1:n.c!=t.c?n.c>t.c?-1:1:0},qf.Cg=function(t,e,i){this.b=n.Math.max(t,e),this.c=n.Math.min(t,e),this.a=i},Ol(213,1,{213:1,19:1},qf.Cg),o.Eb=function(n){return qf.Bg(this,n)},o.a=0,o.b=0,o.c=0,Qf.Zmb=hd(213),qf.Eg=function(n,t,e,i){this.a=(Gf.kVb(t),Vf.nQb(n,$l(Qf.Mmb,G,6,t,15,1),0,t)),this.b=(Gf.kVb(i),Vf.nQb(e,$l(Qf.Mmb,G,6,i,15,1),0,i))},Ol(258,1,{258:1},qf.Eg),Qf.$mb=hd(258),qf.Fg=function(n,t){var e,i;for(i=0;i<n.g[t].length;i++)if(e=n.g[t][i],n.f[e]&&(1==n.o[e]||2==n.o[e])&&0==n.k[e])return!0;return!1},qf.Gg=function(n,t,e){var i,a,s,r,o;for(a=0,r=0,o=0;o<n.g[t].length;o++)i=n.g[t][o],n.k[i]==e&&(r&(s=1<<n.j[i])||(r|=s,++a));return a},qf.Hg=function(n){var t,e,i,a,s,r,o,f,l,d,g;for(l=new Vf.TTb,d=0;d<n.i.f;d++)if(qf.An(n.i,d)<2||qf.Kn(n.i,d)>2)for(s=1;s<qf.Kn(n.i,d);s++)for(t=qf.Jn(n.i,d,s),r=0;r<s;r++)e=qf.Jn(n.i,d,r),qf.Mg(n,t,e)&&((o=qf.Tg(n,t,e))&&qf.oq(o,n.f)&&Vf.WSb(l.a,o,(zf.VGb(),c)));for(g=0;g<n.i.g;g++)(0==n.c[g]||2==qf.Uk(n.i,g)&&2==n.c[g])&&(t=qf.Mk(n.i,0,g),e=qf.Mk(n.i,1,g),qf.Mg(n,t,e)&&((o=qf.Tg(n,t,e))&&qf.oq(o,n.f)&&Vf.WSb(l.a,o,(zf.VGb(),c))));for(n.g=$l(Qf.Mmb,ft,8,l.a.c,0,2),n.e=$l(Qf.nyb,tn,6,n.i.f,16,1),a=0,i=new Vf.mTb(new Vf.rTb(new Vf.mPb(l.a).a).b),f=new Vf.uPb(i);Vf.WNb(f.a.a);)for(o=Vf.kTb(f.a).Xd(),n.g[a++]=o.b,s=0;s<o.b.length;s++)n.e[o.b[s]]=!0},qf.Ig=function(n,t,e,i){var a,s,r,o,f,l,d;for(a=$l(Qf.Mmb,G,6,qf.Kn(n.i,e),15,1),o=0,r=0;r<qf.Kn(n.i,e);r++)a[o]=qf.Jn(n.i,e,r),!i[a[o]]&&qf.Mg(n,t,a[o])&&++o;if(0==o)return-1;if(1==o)return a[0];for(f=-1,l=I,s=0;s<o;s++)(d=qf.jo(n.i,t,a[s],I,i))<l&&(l=d,f=a[s]);return f},qf.Jg=function(n,t){return n.f[t]&&(1==n.o[t]||2==n.o[t])},qf.Kg=function(n,t){return n.e[t]},qf.Lg=function(n){var t,e;for(e=!0,t=0;t<n.i.f;t++)if(0!=n.o[t]&&!n.e[t]){e=!1;break}return e},qf.Mg=function(n,t,e){var i,a,s,r,o;if(t==e)return!1;if(n.a[t]!=n.a[e])return!1;if(0!=n.o[t]){if(3==n.o[t]||3==n.o[e])return!1;if(n.p[t]^n.o[t]!==n.o[e])return!1;if(n.k[t]!==n.k[e]||n.j[t]!==n.j[e])return!1}if(-1!=(i=qf.Hn(n.i,t,e))){if(1==qf.Uk(n.i,i)&&0!=n.c[i])return!1;if(2==qf.Uk(n.i,i)&&1==n.c[i])return!1}if(1==qf.An(n.i,t)&&!qf.Bo(n.i,t)){for(a=-1,o=0;o<qf.Kn(n.i,t);o++)if(qf.Jn(n.i,t,o)!=e&&2==qf.Mn(n.i,t,o)){a=qf.Ln(n.i,t,o);break}for(s=-1,r=0;r<qf.Kn(n.i,e);r++)if(qf.Jn(n.i,e,r)!=t&&2==qf.Mn(n.i,e,r)){s=qf.Ln(n.i,e,r);break}if(-1!=a&&0!=n.c[a]&&n.d[a]^n.c[a]===n.c[s])return!1}return!0},qf.Ng=function(n,t,e,i,a){var s,r,o,f,l,d;for(f=null,s=null,d=0;d<n.g[t].length;d++)r=n.g[t][d],n.f[r]&&(1==n.o[r]||2==n.o[r])&&(0==n.k[r]?s=qf.Vg(s,(a[r]<<16)+r):n.k[r]==i&&n.j[r]==e&&(f=qf.Vg(f,(a[r]<<16)+r)));if(0==(o=qf.ih(f,s)))return!1;if(o<0)for(l=0;l<n.g[t].length;l++)r=n.g[t][l],!n.f[r]||1!=n.o[r]&&2!=n.o[r]||(0==n.k[r]?(n.k[r]=i<<24>>24,n.j[r]=e<<24>>24):n.k[r]==i&&n.j[r]==e&&(n.k[r]=0,n.j[r]=-1));return!0},qf.Og=function(n,t){var e,i,a,s,r,o;if(!n.b)return!1;for(a=!1,s=n.b.a.length-1;s>=0;s--)if(i=!1,2==(r=Vf.Oi(n.b,s)).a?i=qf.Ng(n,r.b,r.c,r.d,t):1==r.a&&(i=qf.Sg(n,r.b,t)),i){for(Vf.Wi(n.b,r),o=0;o<n.g[r.b].length;o++)e=n.g[r.b][o],n.n[e]=!1;a=!0}return a},qf.Pg=function(n){var t,e,i,a,s,r,o,f;if(null!=n.g)for(r=new qf.hh(n),n.b=new Vf.bj,a=0;a<n.g.length;a++)0==(i=qf.$g(r,a))?(qf.Wg(r,a),o=qf.Gg(n,a,2),t=qf.Gg(n,a,1),e=qf.Fg(n,a),1!=o||1!=t||e||(qf.Rg(n,a,r.a+r.f++),Vf.Ji(n.b,new qf.zj(a,1,-1,-1))),o>0?(e&&(qf.Qg(n,a,r.i+r.g++,2),++o),Vf.Ji(n.b,new qf.zj(a,1,-1,-1))):t>0?(e&&qf.Qg(n,a,r.a+r.f++,1),Vf.Ji(n.b,new qf.zj(a,1,-1,-1))):e&&(qf.Qg(n,a,r.a+r.f++,1),Vf.Ji(n.b,new qf.zj(a,1,-1,-1)))):1==i&&(qf.Fg(n,a)?(s=qf.Zg(r,a),f=qf._g(r,a),Vf.Ji(n.b,new qf.zj(a,2,s,f))):(qf.Wg(r,a),Vf.Ji(n.b,new qf.zj(a,1,-1,-1))))},qf.Qg=function(n,t,e,i){var a,s;for(s=0;s<n.g[t].length;s++)a=n.g[t][s],!n.f[a]||1!=n.o[a]&&2!=n.o[a]||0!=n.k[a]||(n.k[a]=i<<24>>24,n.j[a]=e<<24>>24)},qf.Rg=function(n,t,e){var i,a;for(a=0;a<n.g[t].length;a++)i=n.g[t][a],2==n.k[i]&&(n.k[i]=1,n.j[i]=e<<24>>24)},qf.Sg=function(n,t,e){var i,a,s,r,o,f,l,d;for(s=n.g[t],a=1,f=0;f<s.length;f++)if(i=s[f],n.f[i]&&2==n.k[i]){a=2;break}for(r=$l(Qf.Mmb,ft,8,32,0,2),l=0;l<s.length;l++)i=s[l],n.f[i]&&n.k[i]==a&&(r[n.j[i]]=qf.Vg(r[n.j[i]],(e[i]<<16)+i));for(d=0;d<32;d++)null!=r[d]&&Gf.VUb(r[d],Gf.zVb(Vl(Vf.NQb.prototype.$d,Vf.NQb,[])));if(Vf.FQb(r,new qf.jh),0==qf.ih(r[0],r[1]))return!1;for(o=0;o<r[0].length;o++)i=r[0][o]&B,n.k[i]=0,n.j[i]=-1;return!0},qf.Tg=function(n,t,e){var i,a,s,r,o,f,l,d,g,u,c,b,h,D,H,j,m,A,C;for(f=$l(Qf.Mmb,G,6,n.i.f,15,1),H=$l(Qf.Mmb,G,6,n.i.f,15,1),b=$l(Qf.nyb,tn,6,n.i.f,16,1),l=$l(Qf.nyb,tn,6,n.i.f,16,1),j=new qf.pq(n.i.f),f[0]=t,H[t]=e,H[e]=-2,j.a[t]=!0,j.a[e]=!0,s=0,d=0;s<=d;){if(H[r=f[s]]==r){for(g=0;g<qf.Kn(n.i,r);g++)if(i=qf.Jn(n.i,r,g),!j.a[i])if(2==qf.Mn(n.i,r,g)&&qf.Hk(n.i,i)<10)f[++d]=i,H[i]=i,l[i]=l[r]||2==qf.An(n.i,i),b[i]=l[r]&&!b[r],j.a[i]=!0;else if(l[r]&&b[r]){if(-1==(m=qf.Ig(n,i,H[r],j.a)))return null;f[++d]=i,H[i]=m,H[m]=-2,l[i]=!1,j.a[i]=!0,j.a[m]=!0}else if(qf.Po(n.i,qf.Ln(n.i,r,g))&&(f[++d]=i,H[i]=i,l[i]=!1,j.a[i]=!0,(6==qf.Hk(n.i,i)&&0==qf.An(n.i,i)||7==qf.Hk(n.i,i)&&1==qf.qk(n.i,i)||14==qf.Hk(n.i,i)||15==qf.Hk(n.i,i)&&qf.Kn(n.i,i)>2||16==qf.Hk(n.i,i)&&qf.Kn(n.i,i)>2)&&qf.Kn(n.i,i)>2)){for(o=!1,h=1;h<qf.Kn(n.i,i);h++)if(A=qf.Jn(n.i,i,h),!j.a[A])for(D=0;D<h;D++)C=qf.Jn(n.i,i,D),j.a[C]||qf.Mg(n,A,C)&&(f[++d]=A,H[A]=C,H[C]=-2,l[A]=!1,j.a[A]=!0,j.a[C]=!0,o=!0);if(!o)return null}}else{for(a=$l(Qf.nyb,tn,6,qf.Kn(n.i,r),16,1),u=0;u<qf.Kn(n.i,r);u++)if(i=qf.Jn(n.i,r,u),j.a[i])a[u]=H[i]==i;else for(h=0;h<qf.Kn(n.i,i);h++)if(qf.Jn(n.i,i,h)==H[r]){a[u]=!0;break}for(c=0;c<qf.Kn(n.i,r);c++)if(a[c])if(i=qf.Jn(n.i,r,c),j.a[i]){if(-1==qf.Hn(n.i,i,H[r]))return null}else f[++d]=i,H[i]=i,b[i]=!1,l[i]=!0,j.a[i]=!0;for(g=0;g<qf.Kn(n.i,r);g++)if(!a[g]&&(i=qf.Jn(n.i,r,g),!j.a[i])){if(-1==(m=qf.Ig(n,i,H[r],j.a)))return null;f[++d]=i,H[i]=m,H[m]=-2,l[i]=!1,j.a[i]=!0,j.a[m]=!0}}++s}return j},qf.Ug=function(n,t,e,i,a,s,r,o,f,l){this.i=n,this.a=t,this.f=e,this.o=i,this.c=a,this.k=s,this.j=r,this.p=o,this.d=f,this.n=l,qf.Hg(this)},qf.Vg=function(n,t){var e,i;for(i=$l(Qf.Mmb,G,6,null==n?1:n.length+1,15,1),e=0;e<i.length-1;e++)i[e]=n[e];return i[i.length-1]=t,i},Ol(499,1,{},qf.Ug),Qf.anb=hd(499),qf.Wg=function(n,t){var e,i,a,s,r,o;for(a=0;a<n.b;a++)if(n.e[a][t]&&-3!=n.c[a])for(i=0;i<=n.j.g.length;i++)if(i!=t&&n.e[a][i])for(n.e[a][t]=!1,o=a<n.a?a:a<n.b?a-n.a:-1,r=qf.fh(n,a<n.a?1:a<n.b?2:0),s=0;s<n.j.g[t].length;s++)e=n.j.g[t][s],qf.Jg(n.j,e)&&n.j.j[e]==o&&(n.j.j[e]=r<<24>>24)},qf.Xg=function(n,t,e){var i,a,s,r,o;for(o=!1,r=1,t[e]=r,i=!0;i;){for(i=!1,a=0;a<n.b;a++)if(t[a]==r)for(s=0;s<n.b;s++)0==t[s]&&qf.eh(n,a,s)&&(-2==n.c[s]?(t[s]=r+1,i=!0):n.c[s]!=n.c[e]&&(t[s]=r+1,o=!0));++r}return o},qf.Yg=function(n,t,e,i){var a,s,r,o,f,l,d,g,u,c,b;for(f=i+1;f<n.j.g.length;f++)if(f!=i&&n.e[t][f]&&n.e[e][f])return(r=$l(Qf.Mmb,G,6,2,15,1))[0]=e,r[1]=t,r;for(b=$l(Qf.Mmb,G,6,n.b,15,1),d=$l(Qf.Mmb,G,6,n.b,15,1),s=0,g=0,(l=$l(Qf.Mmb,G,6,n.b,15,1))[0]=t,d[t]=1;s<=g;){for(u=0;u<n.d[l[s]].length;u++){if((a=n.d[l[s]][u])==e){if(0==s)continue;for(o=d[l[s]]+1,(r=$l(Qf.Mmb,G,6,o,15,1))[0]=a,r[1]=l[s],c=2;c<o;c++)r[c]=b[r[c-1]];return r}0==d[a]&&-3!=n.c[a]&&(d[a]=d[l[s]]+1,l[++g]=a,b[a]=l[s])}++s}return null},qf.Zg=function(n,t){var e;for(e=0;e<n.b;e++)if(n.e[e][t]&&-3==n.c[e])return e<n.a?e:e<n.b?e-n.a:-1;return-1},qf.$g=function(n,t){var e,i;for(e=0,i=0;i<n.b;i++)n.e[i][t]&&-3==n.c[i]&&++e;return e},qf._g=function(n,t){var e;for(e=0;e<n.b;e++)if(n.e[e][t]&&-3==n.c[e])return e<n.a?1:e<n.b?2:0;return-1},qf.ah=function(n,t){return t<n.a?t:t<n.b?t-n.a:-1},qf.bh=function(n,t){return t<n.a?1:t<n.b?2:0},qf.dh=function(n,t){var e,i;return i=n.j.k[t],e=n.j.j[t],0==i?n.b:1==i?e:n.a+e},qf.eh=function(n,t,e){var i;for(i=0;i<n.j.g.length;i++)if(n.e[t][i]&&n.e[e][i])return!0;return!1},qf.fh=function(n,t){return 1==t?n.a+n.f++:n.i+n.g++},qf.gh=function(n,t){var e,i,a,s,r,o,f,l,d,g;for(d=I,f=-1,g=-1,l=-1,i=0;i<n.j.i.f;i++)if(qf.Jg(n.j,i)&&0!=n.j.k[i])for(o=0;o<t.length;o++)a=qf.ah(n,t[o]),s=qf.bh(n,t[o]),n.j.k[i]==s&&n.j.j[i]==a&&d>n.j.a[i]+(1==s?y:0)&&(d=n.j.a[i]+(1==s?y:0),f=a,g=s,l=t[o]);for(e=0;e<n.j.i.f;e++)qf.Jg(n.j,e)&&n.j.k[e]==g&&n.j.j[e]==f&&(n.j.k[e]=0,n.j.j[e]=-1);for(r=0;r<n.j.g.length;r++)n.e[l][r]=!1},qf.hh=function(n){var t,e,i,a,s,r,o,f,l,d,g,u,c,b,h,D;for(this.j=n,i=0;i<n.i.f;i++)n.f[i]&&(1==n.o[i]||2==n.o[i])&&(1==n.k[i]?this.a<=n.j[i]&&(this.a=1+n.j[i]):2==n.k[i]&&this.i<=n.j[i]&&(this.i=1+n.j[i]));for(this.b=this.a+this.i,this.e=_l(Qf.nyb,[j,tn],[12,6],16,[this.b+1,n.g.length+1],2),a=0;a<n.i.f;a++)n.f[a]&&(1==n.o[a]||2==n.o[a])&&!n.e[a]&&(this.e[qf.dh(this,a)][n.g.length]=!0);for(f=0;f<n.g.length;f++)for(D=0;D<n.g[f].length;D++)e=n.g[f][D],n.f[e]&&(1==n.o[e]||2==n.o[e])&&(this.e[qf.dh(this,e)][f]=!0);for(this.d=$l(Qf.Mmb,ft,8,this.b,0,2),l=0;l<n.g.length;l++)for(c=1;c<this.b;c++)if(this.e[c][l])for(b=0;b<c;b++)this.e[b][l]&&(this.d[c]=qf.Vg(this.d[c],b),this.d[b]=qf.Vg(this.d[b],c));for(this.c=$l(Qf.Mmb,G,6,this.b+1,15,1),u=0;u<this.b;u++)this.e[u][n.g.length]?this.c[u]=-1:this.c[u]=-2;for(d=0;d<n.g.length;d++)if(this.e[this.b][d])for(g=0;g<this.b;g++)this.e[g][d]&&this.c[g]!=d&&(-2==this.c[g]?this.c[g]=d:this.c[g]=-3);for(t=0;t<this.b;t++)if(this.c[t]>=-1&&(s=$l(Qf.Mmb,G,6,this.b,15,1),qf.Xg(this,s,t)))for(g=0;g<this.b;g++)0!=s[g]&&(this.c[g]=-3);for(o=0;o<n.g.length-1;o++)for(c=1;c<this.b;c++)if(this.e[c][o]&&-3!=this.c[c])for(b=0;b<c;b++)if(this.e[b][o]&&-3!=this.c[b]&&null!=(r=qf.Yg(this,c,b,o))){for(h=0;h<r.length;h++)this.c[r[h]]=-3;qf.gh(this,r);break}},Ol(500,1,{},qf.hh),o.a=0,o.b=0,o.f=0,o.g=0,o.i=0,Qf._mb=hd(500),qf.ih=function(t,e){var i,a;if(null==t)return null==e?0:1;if(null==e)return-1;for(i=n.Math.min(t.length,e.length),a=0;a<i;a++)if((t[a]&nt)!=(e[a]&nt))return(t[a]&nt)<(e[a]&nt)?-1:1;return t.length==e.length?0:t.length<e.length?-1:1},qf.jh=function(){},Ol(501,1,{},qf.jh),o.Db=function(n,t){return qf.ih(n,t)},o.ib=function(n){return this===n},Qf.bnb=hd(501),qf.mh=function(n,t){switch(t){case 0:return qf.nh(n,!1);case 1:return qf.ph(n);case 2:return qf.oh(n);case 3:return qf.rh(n);case 4:return qf.qh(n)}return null},qf.nh=function(n,t){try{return t?(n=qf.ru(n),qf.gp(n,!0),qf.Bq(n),qf.Mf(new qf.gg(n))):qf.Mf(new qf.gg(n))}catch(n){if(sd(n=cd(n),28))return zf.aKb(),null;throw bd(n)}},qf.oh=function(n){var t,e;try{for(n=qf.ru(n),qf.Bu(n),t=n.r,e=0;e<t;e++)n.H[e]=1,n.T=0;return qf.Mf(new qf.gg(n))}catch(n){if(sd(n=cd(n),28))return zf.aKb(),null;throw bd(n)}},qf.ph=function(n){try{return n=qf.ru(n),qf.Bu(n),qf.Mf(new qf.gg(n))}catch(n){if(sd(n=cd(n),28))return zf.aKb(),null;throw bd(n)}},qf.qh=function(n){var t;try{return n=qf.ru(n),qf.Bu(n),t=qf.Tu(new qf.Wu(n)),qf.Mf(new qf.hg(t,8))}catch(n){if(sd(n=cd(n),28))return zf.aKb(),null;throw bd(n)}},qf.rh=function(n){var t;try{return t=qf.Tu(new qf.Wu(n)),qf.Mf(new qf.hg(t,8))}catch(n){if(sd(n=cd(n),28))return zf.aKb(),null;throw bd(n)}},qf.sh=function(n,t,e,i){n.a+=t,n.b+=e,n.c+=i},qf.th=function(n,t){return n.a+=t.a,n.b+=t.b,n.c+=t.c,n},qf.uh=function(n,t){return new qf.Jh(n.a+t.a,n.b+t.b,n.c+t.c)},qf.vh=function(n,t){return n.a=(n.a+t.a)/2,n.b=(n.b+t.b)/2,n.c=(n.c+t.c)/2,n},qf.wh=function(n,t){return n.a!=t.a?n.a<t.a?-1:1:n.b!=t.b?n.b<t.b?-1:1:n.c!=t.c?n.c<t.c?-1:1:0},qf.xh=function(n,t){return new qf.Jh(n.b*t.c-n.c*t.b,-(n.a*t.c-n.c*t.a),n.a*t.b-n.b*t.a)},qf.yh=function(t,e){return n.Math.sqrt((e.a-t.a)*(e.a-t.a)+(e.b-t.b)*(e.b-t.b)+(e.c-t.c)*(e.c-t.c))},qf.zh=function(t,e){var i;return!(null==e||!sd(e,32))&&(i=e,n.Math.abs(i.a-t.a)+n.Math.abs(i.b-t.b)+n.Math.abs(i.c-t.c)<1e-6)},qf.Ah=function(t,e){var i,a,s;return a=t.a*t.a+t.b*t.b+t.c*t.c,s=e.a*e.a+e.b*e.b+e.c*e.c,0==a||0==s||(i=(t.a*e.a+t.b*e.b+t.c*e.c)/n.Math.sqrt(a*s))>=1?0:i<=-1?on:n.Math.acos(i)},qf.Bh=function(n,t){var e,i,a;return e=n.a,i=n.b,a=n.c,n.a=e*t[0][0]+i*t[1][0]+a*t[2][0],n.b=e*t[0][1]+i*t[1][1]+a*t[2][1],n.c=e*t[0][2]+i*t[1][2]+a*t[2][2],n},qf.Ch=function(n,t){return n.a*=t,n.b*=t,n.c*=t,n},qf.Dh=function(n,t,e,i){n.a=t,n.b=e,n.c=i},qf.Eh=function(n,t){return qf.Dh(n,t.a,t.b,t.c),n},qf.Fh=function(n,t){return n.a-=t.a,n.b-=t.b,n.c-=t.c,n},qf.Gh=function(n,t){return new qf.Jh(n.a-t.a,n.b-t.b,n.c-t.c)},qf.Hh=function(t){var e;return 0==(e=n.Math.sqrt(t.a*t.a+t.b*t.b+t.c*t.c))?(zf.aKb(),t.a=1,t.b=0,t.c=0,t):(t.a/=e,t.b/=e,t.c/=e,t)},qf.Ih=function(){},qf.Jh=function(n,t,e){this.a=n,this.b=t,this.c=e},qf.Kh=function(n){qf.Jh.call(this,n.a,n.b,n.c)},Ol(32,1,{32:1,4:1,19:1},qf.Ih,qf.Jh,qf.Kh),o.Eb=function(n){return qf.wh(this,n)},o.ib=function(n){return qf.zh(this,n)},o.lb=function(){var n;return n=new Ql.FMb("0.00"),"["+Ql.DMb(n,this.a)+", "+Ql.DMb(n,this.b)+", "+Ql.DMb(n,this.c)+"]"},o.a=0,o.b=0,o.c=0,Qf.dnb=hd(32),qf.Oh=function(n,t){t.c*=n.c,t.a=t.a*n.c+n.a,t.b=t.b*n.c+n.b},qf.Ph=function(n,t){qf.Rl(t,n.c),qf.Mm(t,n.a,n.b)},qf.Qh=function(n,t){t.a=t.a*n.c+n.a,t.b=t.b*n.c+n.b},qf.Rh=function(n,t){t.c=t.c*n.c+n.a,t.d=t.d*n.c+n.b,t.b*=n.c,t.a*=n.c},qf.Sh=function(n){n.a=0,n.b=0,n.c=1},qf.Th=function(n){return 1==n.c&&0==n.a&&0==n.b},qf.Uh=function(n,t){return t*n.c+n.a},qf.Vh=function(n,t){return t*n.c+n.b},qf.Wh=function(){qf.Sh(this)},qf.Xh=function(n,t){this.c=1,this.a=n,this.b=t},qf.Yh=function(t,e,i,a){var s,r,o,f;qf.Sh(this),e?a&ut?(r=e.b/t.b,f=e.a/t.a,0==(o=a&B)?o=24:a&gt&&(o/=256),s=o/i,this.c=n.Math.min(s,n.Math.min(r,f)),this.a=e.c+e.b/2-this.c*(t.c+t.b/2),this.b=e.d+e.a/2-this.c*(t.d+t.a/2)):al.JG(e,t.c,t.d)&&al.JG(e,t.c+t.b,t.d+t.a)||((t.b>e.b||t.a>e.a)&&(r=e.b/t.b,f=e.a/t.a,this.c=n.Math.min(r,f)),t.c*this.c<e.c?this.a=e.c-t.c*this.c:(t.c+t.b)*this.c>e.c+e.b&&(this.a=e.c+e.b-(t.c+t.b)*this.c),t.d*this.c<e.d?this.b=e.d-t.d*this.c:(t.d+t.a)*this.c>e.d+e.a&&(this.b=e.d+e.a-(t.d+t.a)*this.c)):a&y&&(o=a&B?a&B:24,this.c=o/i)},Ol(107,1,{},qf.Wh,qf.Xh,qf.Yh),o.lb=function(){return"DepictorTransformation Offset: "+this.a+","+this.b+" Scaling: "+this.c},o.a=0,o.b=0,o.c=0,Qf.enb=hd(107),qf.$h=function(n){var t,e,i,a;return zf.pJb(Gf.zVb(n).substr(0,21),et)&&(i=Gf.zVb(it).length,zf.pJb(Gf.zVb(n).substr(Gf.zVb(n).length-i,i),it))?-1==(e=zf.uJb(n,pd(34),21))?null:(Gf.tVb(21,e,Gf.zVb(n).length),a=Gf.zVb(n).substr(21,e-21),t=zf.DJb(n,21+Gf.zVb(a).length+1,Gf.zVb(n).length-17),zf.pJb(a,"arrow")?new el.MF(t):zf.pJb(a,jt)?new qf.jv(t):null):null},Vf._h=function(n,t,e){var i,a;for(a=n.Fb();a.Gd();)if(i=a.Hd(),gd(t)===gd(i)||null!=t&&zf.Gc(t,i))return e&&a.Id(),!0;return!1},Vf.ai=function(n,t){var e,i;for(Gf.oVb(t),i=t.Fb();i.Gd();)if(e=i.Hd(),!n.contains(e))return!1;return!0},Vf.bi=function(n,t){var e,i,a;for(Gf.oVb(t),e=!1,i=n.Fb();i.Gd();)a=i.Hd(),t.contains(a)&&(i.Id(),e=!0);return e},Vf.ci=function(n){var t,e,i;for(i=new Vf.MSb("[","]"),e=n.Fb();e.Gd();)t=e.Hd(),Vf.KSb(i,gd(t)===gd(n)?"(this Collection)":null==t?T:Yl(t));return i.a?0==Gf.zVb(i.e).length?i.a.a:i.a.a+""+i.e:i.c},Ol(61,1,mt),o.add=function(n){throw bd(new zf.eKb("Add not supported on this collection"))},o.addAll=function(n){var t,e,i;for(Gf.oVb(n),t=!1,i=n.Fb();i.Gd();)e=i.Hd(),t|=this.add(e);return t},o.clear=function(){var n;for(n=this.Fb();n.Gd();)n.Hd(),n.Id()},o.contains=function(n){return Vf._h(this,n,!1)},o.containsAll=function(n){return Vf.ai(this,n)},o.isEmpty=function(){return 0==this.size()},o.remove=function(n){return Vf._h(this,n,!0)},o.removeAll=function(n){return Vf.bi(this,n)},o.retainAll=function(n){var t,e,i;for(Gf.oVb(n),t=!1,e=this.Fb();e.Gd();)i=e.Hd(),n.contains(i)||(e.Id(),t=!0);return t},o.toArray=function(){return this.Gb($l(Qf.twb,w,1,this.size(),5,1))},o.Gb=function(n){var t,e,i,a;for(a=this.size(),n.length<a&&(n=Gf.WUb(new Array(a),n)),i=n,e=this.Fb(),t=0;t<a;++t)td(i,t,e.Hd());return n.length>a&&Qf.ulb(n,a,null),n},o.lb=function(){return Vf.ci(this)},Qf.Iwb=hd(61),Vf.pi=function(n){return new Vf.dOb(n,0)},Vf.qi=function(n,t){return new Vf.dOb(n,t)},Vf.ri=function(n,t,e){return new Vf.hOb(n,t,e)},Ol(105,61,At),o.addAtIndex=function(n,t){throw bd(new zf.eKb("Add not supported on this list"))},o.add=function(n){return this.addAtIndex(this.size(),n),!0},o.addAllAtIndex=function(n,t){var e,i,a;for(Gf.oVb(t),e=!1,a=t.Fb();a.Gd();)i=a.Hd(),this.addAtIndex(n++,i),e=!0;return e},o.clear=function(){this.Jb(0,this.size())},o.ib=function(n){var t,e,i,a,s;if(n===this)return!0;if(!sd(n,122))return!1;if(s=n,this.size()!=s.size())return!1;for(a=s.Fb(),e=this.Fb();e.Gd();)if(t=e.Hd(),i=a.Hd(),!(gd(t)===gd(i)||null!=t&&zf.Gc(t,i)))return!1;return!0},o.kb=function(){return Vf.SQb(this)},o.indexOf=function(n){var t,e;for(t=0,e=this.size();t<e;++t)if(Vf.ySb(n,this.getAtIndex(t)))return t;return-1},o.Fb=function(){return new Vf.ZNb(this)},o.lastIndexOf=function(n){var t;for(t=this.size()-1;t>-1;--t)if(Vf.ySb(n,this.getAtIndex(t)))return t;return-1},o.Hb=function(){return Vf.pi(this)},o.Ib=function(n){return Vf.qi(this,n)},o.removeAtIndex=function(n){throw bd(new zf.eKb("Remove not supported on this list"))},o.Jb=function(n,t){var e,i;for(i=new Vf.dOb(this,n),e=n;e<t;++e)Gf.mVb(i.b<i.d.size()),i.d.getAtIndex(i.c=i.b++),Vf.YNb(i)},o.setAtIndex=function(n,t){throw bd(new zf.eKb("Set not supported on this list"))},o.subList=function(n,t){return Vf.ri(this,n,t)},Qf.Pwb=hd(105),Vf.Hi=function(n){n.a=$l(Qf.twb,w,1,0,5,1)},Vf.Ii=function(n,t,e){Gf.qVb(t,n.a.length),Gf.PUb(n.a,t,e)},Vf.Ji=function(n,t){return Gf.SUb(n.a,t),!0},Vf.Ki=function(n,t,e){var i;return Gf.qVb(t,n.a.length),0!=(i=e.toArray()).length&&(Gf.QUb(n.a,t,i),!0)},Vf.Li=function(n,t){var e;return 0!=(e=t.toArray()).length&&(Gf.QUb(n.a,n.a.length,e),!0)},Vf.Mi=function(n){Gf.UUb(n.a,0)},Vf.Ni=function(n,t){return-1!=Vf.Qi(n,t,0)},Vf.Oi=function(n,t){return Gf.nVb(t,n.a.length),n.a[t]},Vf.Pi=function(n,t){return Vf.Qi(n,t,0)},Vf.Qi=function(n,t,e){for(;e<n.a.length;++e)if(Vf.ySb(t,n.a[e]))return e;return-1},Vf.Ri=function(n){return 0==n.a.length},Vf.Si=function(n){return new Vf.eQb(n)},Vf.Ti=function(n,t){return Vf.Ui(n,t,n.a.length-1)},Vf.Ui=function(n,t,e){for(;e>=0;--e)if(Vf.ySb(t,n.a[e]))return e;return-1},Vf.Vi=function(n,t){var e;return Gf.nVb(t,n.a.length),e=n.a[t],Gf.TUb(n.a,t,1),e},Vf.Wi=function(n,t){var e;return-1!=(e=Vf.Qi(n,t,0))&&(Vf.Vi(n,e),!0)},Vf.Xi=function(n,t,e){var i;Gf.rVb(t,e,n.a.length),i=e-t,Gf.TUb(n.a,t,i)},Vf.Yi=function(n,t,e){var i;return Gf.nVb(t,n.a.length),i=n.a[t],n.a[t]=e,i},Vf.Zi=function(n){return n.a.length},Vf.$i=function(n,t){Vf.EQb(n.a,n.a.length,t)},Vf._i=function(n){return Gf.MUb(n.a)},Vf.aj=function(n,t){var e,i;for(i=n.a.length,t.length<i&&(t=Gf.WUb(new Array(i),t)),e=0;e<i;++e)td(t,e,n.a[e]);return t.length>i&&Qf.ulb(t,i,null),t},Vf.bj=function(){Vf.Hi(this)},Vf.cj=function(n){Vf.Hi(this),Gf.iVb(n>=0,"Initial capacity must not be negative")},Ol(21,105,Ct,Vf.bj,Vf.cj),o.addAtIndex=function(n,t){Vf.Ii(this,n,t)},o.add=function(n){return Vf.Ji(this,n)},o.addAllAtIndex=function(n,t){return Vf.Ki(this,n,t)},o.addAll=function(n){return Vf.Li(this,n)},o.clear=function(){Vf.Mi(this)},o.contains=function(n){return Vf.Ni(this,n)},o.getAtIndex=function(n){return Vf.Oi(this,n)},o.indexOf=function(n){return Vf.Pi(this,n)},o.isEmpty=function(){return Vf.Ri(this)},o.Fb=function(){return Vf.Si(this)},o.lastIndexOf=function(n){return Vf.Ti(this,n)},o.removeAtIndex=function(n){return Vf.Vi(this,n)},o.remove=function(n){return Vf.Wi(this,n)},o.Jb=function(n,t){Vf.Xi(this,n,t)},o.setAtIndex=function(n,t){return Vf.Yi(this,n,t)},o.size=function(){return Vf.Zi(this)},o.toArray=function(){return Vf._i(this)},o.Gb=function(n){return Vf.aj(this,n)},Qf.exb=hd(21),qf.vj=function(n){var t,e;for(e=new zf.NJb,t=0;t<n.a.length;t++)zf.MJb(e,qf.Zd((Gf.nVb(t,n.a.length),n.a[t]))+H);return e.a},qf.wj=function(n){var t;Vf.bj.call(this);try{if(n)for(t=0;t<n.a.length;t++)Vf.Ji(this,(Gf.nVb(t,n.a.length),n.a[t]).Ab())}catch(n){if(!sd(n=cd(n),18))throw bd(n)}},qf.xj=function(n){var t,e,i;if(Vf.bj.call(this),null!=n&&0!=Gf.zVb(n).length)for(t=0,e=zf.tJb(n,pd(10));-1!=e;)(i=qf.$h((Gf.tVb(t,e,Gf.zVb(n).length),Gf.zVb(n).substr(t,e-t))))&&Gf.SUb(this.a,i),t=e+1,e=zf.uJb(n,pd(10),t)},Ol(248,21,Ct,qf.wj,qf.xj),o.lb=function(){return qf.vj(this)},Qf.fnb=hd(248),qf.zj=function(n,t,e,i){this.b=n,this.a=t,this.c=e,this.d=i},Ol(126,1,{126:1},qf.zj),o.a=0,o.b=0,o.c=0,o.d=0,Qf.gnb=hd(126),qf.Aj=function(n){var t,e,i,a,s,r;if(0!=n.j)return n.j;if(n.i&&15!=qf.Hk(n.e,n.a)&&16!=qf.Hk(n.e,n.a))for(r=0;r<qf.vn(n.e,n.a);r++)if(s=qf.Ln(n.e,n.a,r),qf.El(n.e,s,n.a))return qf.Jn(n.e,n.a,r)==n.b?n.j=257==qf.Xk(n.e,s)?3:1:n.j=257==qf.Xk(n.e,s)?1:3,n.j;return t=qf.Lk(n.e,n.a,n.g),(i=qf.Lk(n.e,n.a,n.b))<t&&(i+=rn),2==qf.vn(n.e,n.a)?(e=i-t)>3.0915926535897933&&e<3.191592653589793?(n.j=-1,n.j):(n.j=e<on?4:2,n.j):((a=qf.Lk(n.e,n.a,n.d))<t&&(a+=rn),n.j=a<i?2:4,n.j)},qf.Bj=function(n,t,e,i){var a,s,r,o;for(this.e=n,this.g=e,this.a=i,r=-1,o=0;o<qf.vn(this.e,this.a);o++)a=qf.Jn(this.e,this.a,o),s=qf.Ln(this.e,this.a,o),a!=this.g?(qf.El(this.e,s,this.a)&&(this.i&&(n.u[i]|=y),this.i=!0),r==t[a]?(this.d=a,this.f=!0,this.c=qf.Po(this.e,s)):r<t[a]?(r=t[a],this.d=this.b,this.b=a):this.d=a):386==qf.Xk(this.e,s)&&(this.j=-1)},Ol(144,1,{},qf.Bj),o.a=0,o.b=0,o.c=!1,o.d=0,o.f=!1,o.g=0,o.i=!1,o.j=0,Qf.hnb=hd(144),qf.Jj=function(){qf.Jj=vl,qf.Dj=ed(Wl(Qf.zwb,1),L,2,6,["?","H","He","Li","Be","B","C","N","O","F","Ne","Na","Mg","Al","Si","P","S","Cl","Ar","K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr","Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe","Cs","Ba","La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu","Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn","Fr","Ra","Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr","Rf","Db","Sg","Bh","Hs","Mt","Ds","Rg","Cn","Nh","Fl","Mc","Lv","Ts","Og",pt,pt,pt,pt,pt,pt,pt,pt,pt,pt,"R4","R5","R6","R7","R8","R9","R10","R11","R12","R13","R14","R15","R16","R1","R2","R3","A","A1","A2","A3",pt,pt,"D","T","X","R","H2","H+","Nnn","HYD","Pol",pt,pt,pt,pt,pt,pt,pt,pt,pt,pt,pt,"Ala","Arg","Asn","Asp","Cys","Gln","Glu","Gly","His","Ile","Leu","Lys","Met","Phe","Pro","Ser","Thr","Trp","Tyr","Val"]),qf.Hj=ed(Wl(Qf.myb,1),at,6,15,[0,1,4,7,9,11,12,14,16,19,20,23,24,27,28,31,32,35,40,39,40,45,48,51,52,55,56,59,58,63,64,69,74,75,80,79,84,85,88,89,90,93,98,0,102,103,106,107,114,115,120,121,130,127,132,133,138,139,140,141,142,0,152,153,158,159,164,165,166,169,174,175,180,181,184,187,192,193,195,197,202,205,208,209,209,210,222,223,226,227,232,231,238,237,244,243,247,247,251,252,257,258,259,262,267,268,271,270,277,276,281,281,283,285,289,289,293,294,294,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,156,114,115,103,128,129,57,137,113,113,128,131,147,97,87,101,186,163,99]),qf.Gj=ed(Wl(Qf.Imb,1),dt,6,15,[6]),qf.Cj=ed(Wl(Qf.Imb,1),dt,6,15,[2]),qf.Ej=ed(Wl(Qf.Imb,2),j,10,0,[null,ed(Wl(Qf.Imb,1),dt,6,15,[1]),ed(Wl(Qf.Imb,1),dt,6,15,[0]),ed(Wl(Qf.Imb,1),dt,6,15,[1]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),ed(Wl(Qf.Imb,1),dt,6,15,[3]),ed(Wl(Qf.Imb,1),dt,6,15,[4]),ed(Wl(Qf.Imb,1),dt,6,15,[3]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),ed(Wl(Qf.Imb,1),dt,6,15,[1]),ed(Wl(Qf.Imb,1),dt,6,15,[0]),ed(Wl(Qf.Imb,1),dt,6,15,[1]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),ed(Wl(Qf.Imb,1),dt,6,15,[3]),ed(Wl(Qf.Imb,1),dt,6,15,[4]),ed(Wl(Qf.Imb,1),dt,6,15,[3,5]),ed(Wl(Qf.Imb,1),dt,6,15,[2,4,6]),ed(Wl(Qf.Imb,1),dt,6,15,[1,3,5,7]),ed(Wl(Qf.Imb,1),dt,6,15,[0]),ed(Wl(Qf.Imb,1),dt,6,15,[1]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),null,null,null,null,null,null,null,null,null,null,ed(Wl(Qf.Imb,1),dt,6,15,[2,3]),ed(Wl(Qf.Imb,1),dt,6,15,[2,4]),ed(Wl(Qf.Imb,1),dt,6,15,[3,5]),ed(Wl(Qf.Imb,1),dt,6,15,[2,4,6]),ed(Wl(Qf.Imb,1),dt,6,15,[1,3,5,7]),ed(Wl(Qf.Imb,1),dt,6,15,[0,2]),ed(Wl(Qf.Imb,1),dt,6,15,[1]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),null,null,null,null,null,null,null,null,null,null,ed(Wl(Qf.Imb,1),dt,6,15,[1,2,3]),ed(Wl(Qf.Imb,1),dt,6,15,[2,4]),ed(Wl(Qf.Imb,1),dt,6,15,[3,5]),ed(Wl(Qf.Imb,1),dt,6,15,[2,4,6]),ed(Wl(Qf.Imb,1),dt,6,15,[1,3,5,7]),ed(Wl(Qf.Imb,1),dt,6,15,[0,2,4,6]),ed(Wl(Qf.Imb,1),dt,6,15,[1]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,ed(Wl(Qf.Imb,1),dt,6,15,[2]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),ed(Wl(Qf.Imb,1),dt,6,15,[3]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),ed(Wl(Qf.Imb,1),dt,6,15,[2])]),qf.Fj=ed(Wl(Qf.Imb,2),j,10,0,[null,ed(Wl(Qf.Imb,1),dt,6,15,[1]),null,ed(Wl(Qf.Imb,1),dt,6,15,[1]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),null,null,ed(Wl(Qf.Imb,1),dt,6,15,[-3]),ed(Wl(Qf.Imb,1),dt,6,15,[-2]),ed(Wl(Qf.Imb,1),dt,6,15,[-1]),null,ed(Wl(Qf.Imb,1),dt,6,15,[1]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),ed(Wl(Qf.Imb,1),dt,6,15,[3]),null,ed(Wl(Qf.Imb,1),dt,6,15,[-3]),ed(Wl(Qf.Imb,1),dt,6,15,[-2]),ed(Wl(Qf.Imb,1),dt,6,15,[-1]),null,ed(Wl(Qf.Imb,1),dt,6,15,[1]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),ed(Wl(Qf.Imb,1),dt,6,15,[3]),ed(Wl(Qf.Imb,1),dt,6,15,[2,3,4]),ed(Wl(Qf.Imb,1),dt,6,15,[2,3,4,5]),ed(Wl(Qf.Imb,1),dt,6,15,[2,3,6]),ed(Wl(Qf.Imb,1),dt,6,15,[2,3,4,7]),ed(Wl(Qf.Imb,1),dt,6,15,[2,3]),ed(Wl(Qf.Imb,1),dt,6,15,[2,3]),ed(Wl(Qf.Imb,1),dt,6,15,[2,3]),ed(Wl(Qf.Imb,1),dt,6,15,[1,2]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),ed(Wl(Qf.Imb,1),dt,6,15,[3]),ed(Wl(Qf.Imb,1),dt,6,15,[2,4]),ed(Wl(Qf.Imb,1),dt,6,15,[-3,3,5]),ed(Wl(Qf.Imb,1),dt,6,15,[-2]),ed(Wl(Qf.Imb,1),dt,6,15,[-1]),null,ed(Wl(Qf.Imb,1),dt,6,15,[1]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),ed(Wl(Qf.Imb,1),dt,6,15,[3]),ed(Wl(Qf.Imb,1),dt,6,15,[4]),ed(Wl(Qf.Imb,1),dt,6,15,[3,5]),ed(Wl(Qf.Imb,1),dt,6,15,[6]),ed(Wl(Qf.Imb,1),dt,6,15,[4,6,7]),ed(Wl(Qf.Imb,1),dt,6,15,[3]),ed(Wl(Qf.Imb,1),dt,6,15,[3]),ed(Wl(Qf.Imb,1),dt,6,15,[2,4]),ed(Wl(Qf.Imb,1),dt,6,15,[1]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),ed(Wl(Qf.Imb,1),dt,6,15,[3]),ed(Wl(Qf.Imb,1),dt,6,15,[2,4]),ed(Wl(Qf.Imb,1),dt,6,15,[-3,3,5]),ed(Wl(Qf.Imb,1),dt,6,15,[-2,4,6]),ed(Wl(Qf.Imb,1),dt,6,15,[-1]),null,ed(Wl(Qf.Imb,1),dt,6,15,[1]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),ed(Wl(Qf.Imb,1),dt,6,15,[3]),ed(Wl(Qf.Imb,1),dt,6,15,[3,4]),ed(Wl(Qf.Imb,1),dt,6,15,[3]),ed(Wl(Qf.Imb,1),dt,6,15,[3]),ed(Wl(Qf.Imb,1),dt,6,15,[3]),ed(Wl(Qf.Imb,1),dt,6,15,[2,3]),ed(Wl(Qf.Imb,1),dt,6,15,[2,3]),ed(Wl(Qf.Imb,1),dt,6,15,[3]),ed(Wl(Qf.Imb,1),dt,6,15,[3]),ed(Wl(Qf.Imb,1),dt,6,15,[3]),ed(Wl(Qf.Imb,1),dt,6,15,[3]),ed(Wl(Qf.Imb,1),dt,6,15,[3]),ed(Wl(Qf.Imb,1),dt,6,15,[3]),ed(Wl(Qf.Imb,1),dt,6,15,[2,3]),ed(Wl(Qf.Imb,1),dt,6,15,[3]),ed(Wl(Qf.Imb,1),dt,6,15,[4]),ed(Wl(Qf.Imb,1),dt,6,15,[5]),ed(Wl(Qf.Imb,1),dt,6,15,[6]),ed(Wl(Qf.Imb,1),dt,6,15,[4,6,7]),ed(Wl(Qf.Imb,1),dt,6,15,[3,4]),ed(Wl(Qf.Imb,1),dt,6,15,[3,4]),ed(Wl(Qf.Imb,1),dt,6,15,[2,4]),ed(Wl(Qf.Imb,1),dt,6,15,[1,3]),ed(Wl(Qf.Imb,1),dt,6,15,[1,2]),ed(Wl(Qf.Imb,1),dt,6,15,[1,3]),ed(Wl(Qf.Imb,1),dt,6,15,[2,4]),ed(Wl(Qf.Imb,1),dt,6,15,[3,5]),ed(Wl(Qf.Imb,1),dt,6,15,[-2,2,4]),ed(Wl(Qf.Imb,1),dt,6,15,[-1,1]),null,ed(Wl(Qf.Imb,1),dt,6,15,[1]),ed(Wl(Qf.Imb,1),dt,6,15,[2]),ed(Wl(Qf.Imb,1),dt,6,15,[3]),ed(Wl(Qf.Imb,1),dt,6,15,[4]),ed(Wl(Qf.Imb,1),dt,6,15,[4,5]),ed(Wl(Qf.Imb,1),dt,6,15,[3,4,5,6]),ed(Wl(Qf.Imb,1),dt,6,15,[3,4,5,6]),ed(Wl(Qf.Imb,1),dt,6,15,[3,4,5,6]),ed(Wl(Qf.Imb,1),dt,6,15,[3,4,5,6]),ed(Wl(Qf.Imb,1),dt,6,15,[3]),ed(Wl(Qf.Imb,1),dt,6,15,[3,4]),ed(Wl(Qf.Imb,1),dt,6,15,[3]),ed(Wl(Qf.Imb,1),dt,6,15,[3]),ed(Wl(Qf.Imb,1),dt,6,15,[3]),ed(Wl(Qf.Imb,1),dt,6,15,[2,3]),ed(Wl(Qf.Imb,1),dt,6,15,[2,3]),ed(Wl(Qf.Imb,1),dt,6,15,[3])])},qf.Kj=function(n,t,e,i){var a;return a=qf.Lj(n,6),qf.Dh(n.J[a],t,e,i),a},qf.Lj=function(n,t){return n.q>=n.M&&qf.Cm(n,2*n.M),n.C[n.q]=0,qf.nm(n,n.q,t),n.s[n.q]=0,n.u[n.q]=0,n.B[n.q]=0,n.w[n.q]=0,qf.Dh(n.J[n.q],0,0,0),null!=n.v&&(n.v[n.q]=null),null!=n.t&&(n.t[n.q]=null),n.T=0,n.q++},qf.Mj=function(n,t,e){return qf.Nj(n,t,e,qf.xl(n,t)||qf.xl(n,e)?32:1)},qf.Nj=function(n,t,e,i){var a;if(t==e)return-1;for(a=0;a<n.r;a++)if(n.D[0][a]==t&&n.D[1][a]==e||n.D[0][a]==e&&n.D[1][a]==t)return n.H[a]<i&&(n.H[a]=i),a;return n.r>=n.N&&qf.Dm(n,2*n.N),n.D[0][n.r]=t,n.D[1][n.r]=e,n.H[n.r]=i,n.F[n.r]=0,n.G[n.r]=0,n.T=0,n.r++},qf.Oj=function(n,t){return qf.Pj(n,t,t.q,t.r)},qf.Pj=function(n,t,e,i){var a,s,r,o,f;for(n.K=n.K|t.K,s=$l(Qf.Mmb,G,6,t.q,15,1),o=qf.Ql(n,1),f=qf.Ql(n,2),a=0;a<e;a++)s[a]=qf.ak(t,n,a,o,f);for(r=0;r<i;r++)qf.bk(t,n,r,o,f,s[t.D[0][r]],s[t.D[1][r]],!1);return n.L=n.L&&t.L,n.I=0,n.T=0,s},qf.Qj=function(n,t,e,i,a,s,r,o){var f,l;return-1==(f=qf.mk(n,t,e))?(n.q>=n.M&&qf.Cm(n,2*n.M),f=qf.Lj(n,i),qf.Dh(n.J[f],t,e,0),n.A[f]=a,qf.Ul(n,f,s),qf.hm(n,f,r),qf.Zl(n,f,o),!0):(l=qf.Xj(n,f,i,a,s,r),qf.Zl(n,f,o),l)},qf.Rj=function(n,t,e,i){var a;for(a=0;a<n.r;a++)if(n.D[0][a]==t&&n.D[1][a]==e||n.D[0][a]==e&&n.D[1][a]==t)return qf.Zj(n,a,i),n.T=0,a;return n.r>=n.N&&qf.Dm(n,2*n.N),n.D[0][n.r]=t,n.D[1][n.r]=e,n.H[n.r]=i,n.F[n.r]=0,n.G[n.r]=0,n.T=0,n.r++},qf.Sj=function(n,t,e,i,a,s){for(var r,o,f;n.q+i>n.M;)qf.Cm(n,2*n.M);for(;n.r+i>n.N;)qf.Dm(n,2*n.N);return-1!=(r=qf.mk(n,t,e))?qf.Tj(n,r,i,a,s):-1!=(o=qf.nk(n,t,e))?qf.Uj(n,o,i,a,s):(r=qf.Kj(n,t,e,0),f=on*(i-2)/i,qf.Il(n,r,i,r,a,0,on-f,s),n.T=0,!0)},qf.Tj=function(t,e,i,a,s){var r,o,f,l,d,g;if(a&&qf.eo(t,e)>1||!a&&qf.eo(t,e)>2)return!1;for(o=0,r=$l(Qf.Kmb,S,6,4,15,1),l=0;l<t.r;l++){for(d=0;d<2;d++)if(t.D[d][l]==e){if(2==o){o=3;break}r[o++]=qf.Lk(t,e,t.D[1-d][l])}if(3==o)break}return 3!=o&&(g=1==o?r[0]+on:n.Math.abs(r[0]-r[1])>on?(r[0]+r[1])/2:(r[0]+r[1])/2+on,f=on*(i-2)/i,qf.Il(t,e,i,e,a,g-f/2,on-f,s),t.T=0,!0)},qf.Uj=function(n,t,e,i,a){var s,r,o,f,l,d,g,u,c,b,h;if(l=$l(Qf.Mmb,G,6,2,15,1),f=$l(Qf.Kmb,S,6,2,15,1),l[0]=n.D[0][t],l[1]=n.D[1][t],qf.eo(n,l[0])>3)return!1;if(qf.eo(n,l[1])>3)return!1;for(r=0,s=$l(Qf.Kmb,S,6,4,15,1),u=0;u<n.r;u++)if(u!=t){for(c=0;c<2;c++){for(b=0;b<2;b++)if(n.D[c][u]==l[b]){if(4==r){r=5;break}s[r++]=qf.Lk(n,l[b],n.D[1-c][u])}if(5==r)break}if(5==r)break}if(5==r)return!1;for(f[0]=qf.Lk(n,l[0],l[1]),f[0]<0?(f[1]=f[0]+on,o=0):(f[1]=f[0],f[0]=f[1]-on,o=1),h=0,g=0;g<r;g++)s[g]>f[0]&&s[g]<f[1]?--h:++h;return o=h>0?1-o:o,d=on*(e-2)/e,qf.Il(n,l[o],e-1,l[1-o],i,f[h>0?0:1]+on-d,on-d,a),n.T=0,!0},qf.Vj=function(n,t,e){var i,a,s,r,o,f,l,d,g,u,c,b,h;for(a=$l(Qf.Mmb,G,6,t.q,15,1),f=qf.Ql(n,1),l=qf.Ql(n,2),i=0;i<t.q;i++)if(0!=t.C[i]||null!=(null==t.t||null==t.t[i]?null:zf.nJb((c=t.t[i],Fl.CMb(),c))))a[i]=qf.ak(t,n,i,f,l);else if(a[i]=e,8&t.T)for(o=0;o<t.r;o++)for(d=0;d<2;d++)if(t.D[d][o]==i){if(b=t.D[1-d][o],g=!1,1==(h=3&t.u[b])||2==h)for(s=0;s<t.r;s++)if(s!=o)for(u=0;u<2;u++)t.D[u][s]==b&&t.D[1-u][s]<i&&(g=!g);g&&qf.fm(t,b,1==h?2:1,!!(4&t.u[b]))}for(r=0;r<t.r;r++)qf.bk(t,n,r,f,l,a[t.D[0][r]],a[t.D[1][r]],!1);return n.L=n.L&&t.L,n.I=0,n.T=0,a},qf.Wj=function(t,e){var i,a,s,r,o,f,l,d,g;return i=t.J[e[0]],a=t.J[e[1]],s=t.J[e[2]],r=t.J[e[3]],l=new qf.Jh(a.a-i.a,a.b-i.b,a.c-i.c),d=new qf.Jh(s.a-a.a,s.b-a.b,s.c-a.c),g=new qf.Jh(r.a-s.a,r.b-s.b,r.c-s.c),o=new qf.Jh(l.b*d.c-l.c*d.b,-(l.a*d.c-l.c*d.a),l.a*d.b-l.b*d.a),f=new qf.Jh(d.b*g.c-d.c*g.b,-(d.a*g.c-d.c*g.a),d.a*g.b-d.b*g.a),-n.Math.atan2(n.Math.sqrt(d.a*d.a+d.b*d.b+d.c*d.c)*(l.a*f.a+l.b*f.b+l.c*f.c),o.a*f.a+o.b*f.b+o.c*f.c)},qf.Xj=function(n,t,e,i,a,s){return(1!=e&&151!=e&&152!=e||!(qf.eo(n,t)>1))&&(n.B[t]=wd(n.B[t],-2),null!=n.v&&(n.v[t]=null),null!=n.t&&(n.t[t]=null),(e!=n.C[t]||i!=n.A[t]||a!=((n.u[t]&Mt)>>>27)-1||s!=(48&n.u[t]))&&(151!=e&&152!=e||(i=e-149,e=1),n.u[t]&=960,n.C[t]=e,n.A[t]=i,n.s[t]=0,n.B[t]=0,qf.Ul(n,t,a),qf.hm(n,t,s),qf.Ol(n,n.w[t]),n.T=0,!0))},qf.Yj=function(n,t,e){if(e){if(n.s[t]>8)return!1;++n.s[t]}else{if(n.s[t]<-8)return!1;--n.s[t]}return n.T=0,!0},qf.Zj=function(n,t,e){var i,a,s,r,o;return s=!1,r=n.H[t],511==e?s=qf.fl(n,t):qf.lp(n,t,e)&&(257==e||129==e?(i=qf.Jl(n,t,n.D[0][t]),a=qf.Jl(n,t,n.D[1][t]),e==r?(i==a||a)&&(o=n.D[0][t],n.D[0][t]=n.D[1][t],n.D[1][t]=o,s=!0):(!i&&a&&(o=n.D[0][t],n.D[0][t]=n.D[1][t],n.D[1][t]=o),n.H[t]=e,s=!0)):(n.H[t]=e,s=!0)),s&&(n.T=(127&r)==(127&e)?7&n.T:0,n.G[t]=0),s},qf.$j=function(n){n.q=0,n.r=0,n.K=!1,n.L=!1,n.I=0,n.v=null,n.t=null,n.P=null,n.T=0},qf._j=function(n){var t,e,i,a,s,r,o,f;for(r=0;r<n.r;r++)512==n.H[r]&&(e=n.D[0][r],i=n.D[1][r],-1==n.C[e]^-1==n.C[i]&&0!=n.s[e]&&0!=n.s[i]&&n.s[e]<0^n.s[i]<0&&(n.s[e]<0?(++n.s[e],--n.s[i]):(--n.s[e],++n.s[i])));for(f=$l(Qf.Mmb,G,6,n.q,15,1),a=0,t=0;t<n.q;t++)-1!=n.C[t]?(a<t&&(n.C[a]=n.C[t],n.s[a]=n.s[t],n.A[a]=n.A[t],n.u[a]=n.u[t],n.B[a]=n.B[t],n.w[a]=n.w[t],qf.Eh(n.J[a],n.J[t]),null!=n.v&&(n.v[a]=n.v[t]),null!=n.t&&(n.t[a]=n.t[t])),f[t]=a,++a):f[t]=-1;for(n.q=a,o=0,s=0;s<n.r;s++)512!=n.H[s]&&(n.H[o]=n.H[s],n.F[o]=n.F[s],n.G[o]=n.G[s],n.D[0][o]=f[n.D[0][s]],n.D[1][o]=f[n.D[1][s]],++o);return n.r=o,f},qf.ak=function(t,e,i,a,s){var r,o,f;return(r=e.q)>=e.M&&qf.Cm(e,2*e.M),o=-1,1==(f=(t.u[i]&Kn)>>18)?o=-1==a?qf.Ql(e,f):n.Math.min(31,a+((t.u[i]&Kn)>>18!=1&&(t.u[i]&Kn)>>18!=2?-1:(t.u[i]&It)>>20)):2==f&&(o=-1==s?qf.Ql(e,f):n.Math.min(31,s+((t.u[i]&Kn)>>18!=1&&(t.u[i]&Kn)>>18!=2?-1:(t.u[i]&It)>>20))),e.C[r]=t.C[i],e.s[r]=t.s[i],e.A[r]=t.A[i],e.u[r]=t.u[i],e.B[r]=e.K?t.B[i]:0,qf.Eh(e.J[r],t.J[i]),e.w[r]=t.w[i],null!=e.v&&(e.v[r]=null),null!=t.v&&null!=t.v[i]&&e.K&&(null==e.v&&(e.v=$l(Qf.Mmb,ft,8,e.C.length,0,2)),e.v[r]=Vf.lQb(t.v[i],t.v[i].length)),null!=e.t&&(e.t[r]=null),null!=t.t&&null!=t.t[i]&&(null==e.t&&(e.t=$l(Qf.Imb,j,10,e.C.length,0,2)),e.t[r]=Vf.jQb(t.t[i],t.t[i].length)),-1!=o&&(e.u[r]&=-32505857,e.u[r]|=o<<20),++e.q,e.T=0,r},qf.bk=function(t,e,i,a,s,r,o,f){var l,d,g,u;return(d=e.r)>=e.N&&qf.Dm(e,2*e.N),g=-1,1==(u=(768&t.F[i])>>8)&&(g=-1==a?qf.Ql(e,u):n.Math.min(32,a+((768&t.F[i])>>8!=1&&(768&t.F[i])>>8!=2?-1:(t.F[i]&Pt)>>10))),2==u&&(g=-1==s?qf.Ql(e,u):n.Math.min(32,s+((768&t.F[i])>>8!=1&&(768&t.F[i])>>8!=2?-1:(t.F[i]&Pt)>>10))),e.D[0][d]=r,e.D[1][d]=o,l=f&&t.Lb(i)?64:t.H[i],e.H[d]=l,e.F[d]=t.F[i],e.G[d]=e.K?t.G[i]:0,-1!=g&&(e.F[d]&=-31745,e.F[d]|=g<<10),++e.r,e.T=0,d},qf.ck=function(n,t,e,i,a,s,r){return qf.bk(n,t,e,i,a,null==s?n.D[0][e]:s[n.D[0][e]],null==s?n.D[1][e]:s[n.D[1][e]],r)},qf.dk=function(n,t){var e,i;for(t.v=null,t.t=null,t.K=n.K,t.q=0,e=0;e<n.q;e++)qf.ak(n,t,e,0,0);for(t.r=0,i=0;i<n.r;i++)qf.bk(n,t,i,0,0,n.D[0][i],n.D[1][i],!1);n.Kb(t)},qf.ek=function(n,t){t.K=n.K,t.L=n.L,t.S=n.S,t.I=n.I,t.P=n.P,t.T=24&n.T},qf.fk=function(n,t){var e,i,a,s;for(e=0;e<n.r;e++)for(a=0;a<2;a++)if(n.D[a][e]==t){for(n.H[e]=512,i=0,s=0;s<n.r;s++)s!=e&&(n.D[0][s]===n.D[1-a][e]||n.D[1][s]===n.D[1-a][e])&&++i;0==i&&(qf.Ol(n,n.w[n.D[1-a][e]]),n.C[n.D[1-a][e]]=-1)}qf.Ol(n,n.w[t]),n.C[t]=-1,null!=n.v&&(n.v[t]=null),null!=n.t&&(n.t[t]=null),qf._j(n),n.T=0},qf.gk=function(n,t,e){var i,a;return-1!=(i=qf.mk(n,t,e))?(512&n.u[i]?qf.lk(n):qf.fk(n,i),n.T=0,!0):-1!=(a=qf.nk(n,t,e))&&(n.u[n.D[0][a]]&n.u[n.D[1][a]]&512?qf.lk(n):qf.jk(n,a),n.T=0,!0)},qf.hk=function(n,t){var e,i,a,s;if(0==t.length)return null;for(a=0,s=(i=t).length;a<s;++a)e=i[a],n.C[e]=-1;return qf.kk(n)},qf.ik=function(n,t){n.H[t]=512,qf._j(n),n.T=0},qf.jk=function(n,t){var e,i,a;for(i=0;i<2;i++){for(e=0,a=0;a<n.r;a++)a!=t&&(n.D[0][a]===n.D[i][t]||n.D[1][a]===n.D[i][t])&&++e;0==e&&(qf.Ol(n,n.w[n.D[i][t]]),n.C[n.D[i][t]]=-1)}n.H[t]=512,qf._j(n),n.T=0},qf.kk=function(n){var t,e,i;for(i=!1,t=0;t<n.q;t++)-1==n.C[t]&&(i=!0,qf.Ol(n,n.w[t]));for(e=0;e<n.r;e++)512==n.H[e]?i=!0:-1!=n.C[n.D[0][e]]&&-1!=n.C[n.D[1][e]]||(n.H[e]=512,i=!0);return i?(n.T=0,qf._j(n)):null},qf.lk=function(n){var t,e;for(e=!1,t=0;t<n.q;t++)512&n.u[t]&&(n.C[t]=-1,e=!0);return e&&null!=qf.kk(n)},qf.mk=function(n,t,e){var i,a,s,r,o,f,l,d;for(r=-1,a=qf.Jk(n,n.q,n.r,qf.Ij),o=Tt,f=a*a/12,i=0;i<n.q;i++)(s=(t-(l=n.J[i].a))*(t-l)+(e-(d=n.J[i].b))*(e-d))<f&&s<o&&(o=s,r=i);return r},qf.nk=function(t,e,i){var a,s,r,o,f,l,d,g,u,c,b,h,D,H;for(g=-1,c=qf.Jk(t,t.q,t.r,qf.Ij),u=Tt,a=0;a<t.r;a++)b=t.J[t.D[0][a]].a,D=t.J[t.D[0][a]].b,l=(h=t.J[t.D[1][a]].a)-b,d=(H=t.J[t.D[1][a]].b)-D,s=n.Math.sqrt(l*l+d*d),l=e-(b+h)/2,d=i-(D+H)/2,n.Math.sqrt(l*l+d*d)>s/2||(h==b?f=n.Math.abs(b-e):(o=-(r=(H-D)/(b-h))*b-D,f=n.Math.abs((r*e+i+o)/n.Math.sqrt(r*r+1))),f<c&&f<u&&(u=f,g=a));return g},qf.ok=function(n,t){return((n.u[t]&Mt)>>>27)-1},qf.pk=function(n,t){return(49152&n.u[t])>>14},qf.qk=function(n,t){return n.s[t]},qf.rk=function(n,t){return 448&n.u[t]},qf.sk=function(n,t){var e;return null==n.t||null==n.t[t]?null:zf.nJb((e=n.t[t],Fl.CMb(),e))},qf.tk=function(n,t){return null==n.t?null:n.t[t]},qf.uk=function(n,t){return(n.u[t]&Kn)>>18!=1&&(n.u[t]&Kn)>>18!=2?-1:(n.u[t]&It)>>20},qf.vk=function(n,t){return(n.u[t]&Kn)>>18},qf.wk=function(n,t){return qf.Dj[n.C[t]]},qf.xk=function(n,t){return null==n.v?null:n.v[t]},qf.yk=function(n,t){var e,i,a;if(null==n.v||null==n.v[t])return Sd(wd(n.B[t],1),0)?"":qf.Dj[n.C[t]];for(a="",i=0;i<n.v[t].length;i++)i>0&&(Gf.oVb(a),a+=(Gf.oVb(","),",")),e=n.v[t][i],a=zf.lJb(a,qf.Dj[e]);return a},qf.zk=function(t,e){return n.Math.abs(t.w[e])},qf.Ak=function(n,t){return n.A[t]},qf.Bk=function(n,t){return 3&n.u[t]},qf.Ck=function(n,t){return n.B[t]},qf.Dk=function(n,t){return 48&n.u[t]},qf.Ek=function(n,t){return n.J[t].a},qf.Fk=function(n,t){return n.J[t].b},qf.Gk=function(n,t){return n.J[t].c},qf.Hk=function(n,t){return n.C[t]},qf.Ik=function(n){return qf.Jk(n,n.q,n.r,qf.Ij)},qf.Jk=function(n,t,e,i){return qf.Kk(n,t,e,i,n.J)},qf.Kk=function(n,t,e,i,a){var s,r,o,f,l,d,g,u,c,b;for(g=!1,u=0,l=0;l<e;l++)32!=n.H[l]&&!(n.G[l]&qn)&&++u;if(0==u){for(d=0;d<e;d++)!(n.G[d]&qn)&&++u;g=!0}if(0==u){if(t<2)return i;for(b=Tt,s=1;s<t;s++)for(r=0;r<s;r++)(c=qf.yh(a[s],a[r]))>0&&c<b&&(b=c);return b!=Tt?.6*b:i}for(o=0,f=0;f<e;f++)(g||32!=n.H[f])&&!(n.G[f]&qn)&&(o+=qf.yh(a[n.D[1][f]],a[n.D[0][f]]));return o/u},qf.Lk=function(n,t,e){return qf.Zm(n.J[t].a,n.J[t].b,n.J[e].a,n.J[e].b)},qf.Mk=function(n,t,e){return n.D[t][e]},qf.Nk=function(n,t){return((7680&n.G[t])>>9)+((n.G[t]&Nt)>>13)},qf.Ok=function(n,t){return(7680&n.G[t])>>9},qf.Pk=function(n,t){return(48&n.F[t])>>4},qf.Qk=function(n,t){return(768&n.F[t])>>8!=1&&(768&n.F[t])>>8!=2?-1:(n.F[t]&Pt)>>10},qf.Rk=function(n,t){return(768&n.F[t])>>8},qf.Sk=function(t,e){var i,a,s,r;return i=t.D[0][e],a=t.D[1][e],s=t.J[a].a-t.J[i].a,r=t.J[a].b-t.J[i].b,n.Math.sqrt(s*s+r*r)},qf.Tk=function(n,t,e){var i;for(i=0;i<n.r;i++)if((n.D[0][i]==t&&n.D[1][i]==e||n.D[0][i]==e&&n.D[1][i]==t)&&512!=n.H[i])return i;return-1},qf.Uk=function(n,t){if(n.K&&31&n.G[t]){if(9&n.G[t])return 1;if(2&n.G[t])return 2;if(4&n.G[t])return 3;if(32&n.G[t])return 4;if(64&n.G[t])return 5;if(16&n.G[t])return 0}switch(127&n.H[t]){case 1:case 64:return 1;case 2:return 2;case 4:return 3;case 8:return 4;case 16:return 5;default:return 0}},qf.Vk=function(n,t){return 3&n.F[t]},qf.Wk=function(n,t){return n.G[t]},qf.Xk=function(n,t){return n.H[t]},qf.Yk=function(n,t){return 127&n.H[t]},qf.Zk=function(n,t){var e,i,a,s,r;if(0==n.q)return null;for(i=n.J[0].a,s=n.J[0].b,a=n.J[0].a,r=n.J[0].b,e=1;e<n.q;e++)i>n.J[e].a?i=n.J[e].a:a<n.J[e].a&&(a=n.J[e].a),s>n.J[e].b?s=n.J[e].b:r<n.J[e].b&&(r=n.J[e].b);return t?(t.c=i,t.d=s,t.b=a-i,t.a=r-s):t=new al.OG(i,s,a-i,r-s),t},qf.$k=function(n,t){var e;return null==(e=n.C[t]<qf.Ej.length?qf.Ej[n.C[t]]:null)?6:e[e.length-1]},qf._k=function(n,t,e){return qf.al(n,t,e,n.C[t])},qf.al=function(t,e,i,a){var s,r;return a>=171&&a<=190?0:(r=0,32==(48&t.u[e])&&(r-=1),(16==(48&t.u[e])||!(48&~t.u[e]))&&(r-=2),0==(s=t.s[e])&&t.K&&(Ld(wd(t.B[e],Dn),mn)&&(s=-1),Ld(wd(t.B[e],Dn),jn)&&(s=1)),7==a||8==a||9==a?r+=s:6==a||14==a||32==a?r-=n.Math.abs(s):15==a||33==a?i-r-s<=3?r+=s:r-=s:16==a||34==a||52==a?i-r-s<=4?r+=s:r-=n.Math.abs(s):17==a||35==a||53==a?i-r-s<=5?r+=s:r-=n.Math.abs(s):r-=s,r)},qf.bl=function(n,t){var e;return(e=qf.cl(n,t))+qf.al(n,t,e,n.C[t])},qf.cl=function(n,t){var e,i;return-1==(e=((n.u[t]&Mt)>>>27)-1)&&(e=null==(i=n.C[t]<qf.Ej.length?qf.Ej[n.C[t]]:null)?6:i[i.length-1]),e},qf.dl=function(n,t){var e,i,a,s,r;for(s=qf.Fl(n,n.D[0][t])||qf.Fl(n,n.D[1][t])?5:3,i=0;i<2;i++)e=n.D[i][t],s>(a=qf.Uk(n,t)+((r=qf.cl(n,e))+qf.al(n,e,r,n.C[e]))-qf.eo(n,e))&&(s=a);return s},qf.el=function(n,t){return!!(n.u[t]&y)},qf.fl=function(n,t){var e,i,a;return i=qf.dl(n,t),a=(e=qf.xl(n,n.D[0][t])||qf.xl(n,n.D[1][t]))?32:1,16==n.H[t]?(n.H[t]=a,n.T=0,!0):8==n.H[t]?(n.H[t]=i>4?16:a,n.T=0,!0):4==n.H[t]?(n.H[t]=i>3?8:a,n.T=0,!0):!(2!=n.H[t]||(n.H[t]=386,n.T&=7,128&n.F[t]))||(386==n.H[t]?(n.H[t]=i>2?4:a,n.T=0,!0):384&n.H[t]?(n.H[t]=1,n.T&=7,!0):!(!e&&i<2)&&(1==n.H[t]?(n.H[t]=2,n.T=0,!0):!(i<1)&&(32==n.H[t]&&(n.H[t]=1,n.T=0,!0))))},qf.gl=function(n){var t;for(n.T=0,n.C=$l(Qf.Mmb,G,6,n.M,15,1),n.s=$l(Qf.Mmb,G,6,n.M,15,1),n.w=$l(Qf.Mmb,G,6,n.M,15,1),n.J=$l(Qf.dnb,wt,32,n.M,0,1),t=0;t<n.M;t++)n.J[t]=new qf.Ih;n.A=$l(Qf.Mmb,G,6,n.M,15,1),n.u=$l(Qf.Mmb,G,6,n.M,15,1),n.B=$l(Qf.Nmb,st,6,n.M,14,1),n.v=null,n.t=null,n.D=_l(Qf.Mmb,[ft,G],[8,6],15,[2,n.N],2),n.H=$l(Qf.Mmb,G,6,n.N,15,1),n.F=$l(Qf.Mmb,G,6,n.N,15,1),n.G=$l(Qf.Mmb,G,6,n.N,15,1)},qf.hl=function(n,t){n.T&=~t},qf.il=function(n){var t;for(t=0;t<n.q;t++)if(0!=n.J[t].c)return!0;return!1},qf.jl=function(n,t){return!!(n.u[t]&Ut)},qf.kl=function(n,t){return-1==n.C[t]},qf.ll=function(n,t){return!!(4&n.u[t])},qf.ml=function(n,t){return!!(n.u[t]&Jt)},qf.nl=function(n,t){return n.w[t]<0},qf.ol=function(n,t){return!!(n.F[t]&Lt)},qf.pl=function(n,t){return!!(n.G[t]&qn)},qf.ql=function(n,t){return!!(n.F[t]&y)},qf.rl=function(n,t){return 512==n.H[t]},qf.sl=function(n,t){return!!(4&n.F[t])},qf.tl=function(n,t){return!!(n.F[t]&gt)},qf.ul=function(n,t){var e,i,a,s;if(n.K){if(Sd(wd(n.B[t],1),0))return!1;if(null!=n.v&&null!=n.v[t])for(a=0,s=(i=n.v[t]).length;a<s;++a)if(e=i[a],!qf.an(e))return!1}return qf.an(n.C[t])},qf.vl=function(n,t){var e,i,a,s;if(n.K){if(Sd(wd(n.B[t],1),0))return!1;if(null!=n.v&&null!=n.v[t])for(a=0,s=(i=n.v[t]).length;a<s;++a)if(e=i[a],!qf.bn(e))return!1}return qf.bn(n.C[t])},qf.wl=function(n,t){return!!(n.u[t]&gt)},qf.xl=function(n,t){var e,i,a,s;if(n.K){if(Sd(wd(n.B[t],1),0))return!1;if(null!=n.v&&null!=n.v[t])for(a=0,s=(i=n.v[t]).length;a<s;++a)if(!((e=i[a])>=3&&e<=4||e>=11&&e<=13||e>=19&&e<=31||e>=37&&e<=51||e>=55&&e<=84||e>=87&&e<=112))return!1}return qf.cn(n.C[t])},qf.yl=function(n,t){return 0==n.A[t]},qf.zl=function(n,t){var e,i,a,s;if(n.K){if(Sd(wd(n.B[t],1),0))return!1;if(null!=n.v&&null!=n.v[t])for(a=0,s=(i=n.v[t]).length;a<s;++a)if(!(1==(e=i[a])||e>=5&&e<=9||e>=14&&e<=17||e>=32&&e<=35||e>=52&&e<=53))return!1}return qf.dn(n.C[t])},qf.Al=function(n){var t;for(t=0;t<n.q;t++)switch(n.C[t]){case 1:case 5:case 6:case 7:case 8:case 9:case 14:case 15:case 16:case 17:case 33:case 34:case 35:case 52:case 53:continue;default:return!1}return!0},qf.Bl=function(n,t){return!!(512&n.u[t])},qf.Cl=function(n,t){return!!(n.u[n.D[0][t]]&n.u[n.D[1][t]]&512)},qf.Dl=function(n,t){return 257==n.H[t]||129==n.H[t]},qf.El=function(n,t,e){return(257==n.H[t]||129==n.H[t])&&n.D[0][t]==e},qf.Fl=function(n,t){var e,i,a,s;if(n.K){if(Sd(wd(n.B[t],1),0))return!1;if(null!=n.v&&null!=n.v[t])for(a=0,s=(i=n.v[t]).length;a<s;++a)if(!((e=i[a])>=21&&e<=30||e>=39&&e<=48||57==e||e>=72&&e<=80||89==e||e>=104&&e<=112))return!1}return qf.en(n.C[t])},qf.Gl=function(n,t){n.C[t]=-1},qf.Hl=function(n,t){n.H[t]=512},qf.Il=function(t,e,i,a,s,r,o,f){var l,d,g,u,c,b,h,D,H,j;for(e!=a&&(H=t.J[e].a-t.J[a].a,j=t.J[e].b-t.J[a].b,f=n.Math.sqrt(H*H+j*j)),l=e,g=3!=qf.Hm(t,e),D=1;D<i;D++){for(c=t.J[l].a+f*n.Math.sin(r),b=t.J[l].b+f*n.Math.cos(r),h=-1,u=0;u<t.q;u++)if(n.Math.abs(c-t.J[u].a)<4&&n.Math.abs(b-t.J[u].b)<4){h=u;break}-1==h&&(h=qf.Kj(t,c,b,0),t.J[h].a=c,t.J[h].b=b,t.J[h].c=0),-1==(d=qf.Tk(t,l,h))&&(d=qf.Nj(t,l,h,qf.xl(t,l)||qf.xl(t,h)?32:1),s&&(g&&qf.Hm(t,t.D[0][d])<4&&qf.Hm(t,t.D[1][d])<3&&(t.H[d]=2),g=!g)),l=h,r+=o}-1==(d=qf.Tk(t,l,a))&&(d=qf.Nj(t,l,a,qf.xl(t,l)||qf.xl(t,a)?32:1)),s&&g&&qf.Hm(t,t.D[0][d])<4&&qf.Hm(t,t.D[1][d])<4&&(t.H[d]=2)},qf.Jl=function(n,t,e){var i,a;if(1!=qf.Uk(n,t))return!1;if(3&n.u[e])return!0;for(a=0;a<n.r;a++)if(a!=t&&2==n.H[a]&&(n.D[0][a]==e&&3&n.u[n.D[1][a]]||n.D[1][a]==e&&3&n.u[n.D[0][a]]))return!0;for(i=0;i<n.r;i++)if(i!=t&&1==n.H[i]&&(n.D[0][i]==e||n.D[1][i]==e)&&3&n.F[i])return!0;return!1},qf.Kl=function(n){var t;for(t=0;t<n.q;t++)n.u[t]&=-449},qf.Ll=function(n){var t;for(t=0;t<n.q;t++)n.u[t]&=-131073},qf.Ml=function(n){var t;for(t=0;t<n.q;t++)n.u[t]&=-513},qf.Nl=function(n){var t;for(t=0;t<n.r;t++)n.F[t]&=-98305},qf.Ol=function(t,e){var i;for(i=0;i<t.q;i++)n.Math.abs(t.w[i])==n.Math.abs(e)&&(t.w[i]=0)},qf.Pl=function(n){var t,e,i,a;for(a=!1,e=0;e<n.q;e++)Sd(wd(n.B[e],en),0)&&(n.C[e]=-1,a=!0);for(a&&qf.kk(n),null!=n.v&&(n.v=null,a=!0),t=0;t<n.q;t++)Sd(n.B[t],0)&&(n.B[t]=0,a=!0);for(i=0;i<n.r;i++)0!=n.G[i]&&(n.G[i]=0,a=!0),64==n.H[i]&&(n.H[i]=1,a=!0);return a&&(n.T=0),a},qf.Ql=function(n,t){var e,i,a,s,r,o,f,l,d;if(0==t)return 0;for(o=null,i=0;i<n.q;i++)(n.u[i]&Kn)>>18==t&&(null==o&&(o=$l(Qf.nyb,tn,6,32,16,1)),o[(n.u[i]&Kn)>>18!=1&&(n.u[i]&Kn)>>18!=2?-1:(n.u[i]&It)>>20]=!0);for(s=0;s<n.r;s++)(768&n.F[s])>>8==t&&(null==o&&(o=$l(Qf.nyb,tn,6,32,16,1)),o[(768&n.F[s])>>8!=1&&(768&n.F[s])>>8!=2?-1:(n.F[s]&Pt)>>10]=!0);if(d=0,null!=o){for(l=$l(Qf.Mmb,G,6,32,15,1),f=0;f<32;f++)o[f]&&(l[f]=d++);for(e=0;e<n.q;e++)(n.u[e]&Kn)>>18==t&&(r=l[(n.u[e]&Kn)>>18!=1&&(n.u[e]&Kn)>>18!=2?-1:(n.u[e]&It)>>20],n.u[e]&=-32505857,n.u[e]|=r<<20);for(a=0;a<n.r;a++)(768&n.F[a])>>8==t&&(r=l[(768&n.F[a])>>8!=1&&(768&n.F[a])>>8!=2?-1:(n.F[a]&Pt)>>10],n.F[a]&=-31745,n.F[a]|=r<<10)}return d},qf.Rl=function(n,t){var e;for(e=0;e<n.q;e++)n.J[e].a*=t,n.J[e].b*=t},qf.Sl=function(n,t){n.q=t,n.T=0},qf.Tl=function(n,t){n.r=t,n.T=0},qf.Ul=function(n,t,e){e>=-1&&e<=14&&(n.u[t]&=-2013265921,n.u[t]|=1+e<<27,6==n.C[t]&&(-1!=e&&0!=e&&2!=e&&4!=e||(n.u[t]&=-49,2==e&&(n.u[t]|=16))))},qf.Vl=function(n,t,e){n.u[t]&=-49153,n.u[t]|=e<<14},qf.Wl=function(n,t,e){n.s[t]=e,n.T=0},qf.Xl=function(n,t,e){n.u[t]&=-449,n.u[t]|=e},qf.Yl=function(n,t,e){e?n.u[t]|=Ut:n.u[t]&=yt,n.T&=7},qf.Zl=function(n,t,e){var i,a;null!=e&&(0==Gf.zVb(e).length?e=null:(0!=(i=qf._m(e,321))&&zf.pJb(e,qf.Dj[i])||zf.pJb(e,"?"))&&(qf.nm(n,t,i),e=null)),null==e?null!=n.t&&(n.t[t]=null):(null==n.t&&(n.t=$l(Qf.Imb,j,10,n.M,0,2)),n.t[t]=Gf.aVb((a=e,Fl.CMb(),a)))},qf.$l=function(n,t,e){null!=e&&0==e.length&&(e=null),null==e?null!=n.t&&(n.t[t]=null):(null==n.t&&(n.t=$l(Qf.Imb,j,10,n.M,0,2)),n.t[t]=e)},qf._l=function(n,t,e,i){var a,s,r;if(0==e)n.u[t]&=Bt,n.u[t]|=e<<18;else{if(i>=32)return;if(-1==i){for(r=-1,s=0;s<n.q;s++)s!=t&&e==(n.u[s]&Kn)>>18&&r<((n.u[s]&Kn)>>18!=1&&(n.u[s]&Kn)>>18!=2?-1:(n.u[s]&It)>>20)&&(r=(n.u[s]&Kn)>>18!=1&&(n.u[s]&Kn)>>18!=2?-1:(n.u[s]&It)>>20);for(a=0;a<n.r;a++)e==(768&n.F[a])>>8&&r<((768&n.F[a])>>8!=1&&(768&n.F[a])>>8!=2?-1:(n.F[a]&Pt)>>10)&&(r=(768&n.F[a])>>8!=1&&(768&n.F[a])>>8!=2?-1:(n.F[a]&Pt)>>10);if((i=r+1)>=32)return}n.u[t]&=Bt,n.u[t]|=e<<18|i<<20}n.T&=7},qf.am=function(n,t,e){null==n.v&&(n.v=$l(Qf.Mmb,ft,8,n.M,0,2)),Gf.VUb(e,Gf.zVb(Vl(Vf.NQb.prototype.$d,Vf.NQb,[]))),n.v[t]=e,n.T=0,n.K=!0},qf.bm=function(n,t,e,i){var a;if(null!=e){if(1==e.length&&!i)return a=e[0],n.C[t]!=a&&qf.Xj(n,t,a,0,-1,0),void(null!=n.v&&(n.v[t]=null));null==n.v&&(n.v=$l(Qf.Mmb,ft,8,n.M,0,2)),n.v[t]=e,i&&(n.B[t]=Gd(n.B[t],1)),n.T=0,n.K=!0}else null!=n.v&&(n.v[t]=null)},qf.cm=function(n,t,e,i){n.w[t]=i?-e:e},qf.dm=function(n,t,e){e?n.u[t]|=gt:n.u[t]&=-131073},qf.em=function(n,t,e){n.A[t]=e,n.T&=1==n.C[t]?0:7},qf.fm=function(n,t,e,i){n.u[t]&=-8,3!=e&&(n.u[t]&=yt),n.u[t]|=e,i&&(n.u[t]|=4)},qf.gm=function(n,t,e,i){n.B[t]=i?Gd(n.B[t],e):wd(n.B[t],Xd(e)),n.T=0,n.K=!0},qf.hm=function(n,t,e){n.u[t]&=-49,n.u[t]|=e,n.T&=7},qf.im=function(n,t,e){e?n.u[t]|=512:n.u[t]&=-513},qf.jm=function(n,t,e){n.u[t]&=-67108865,e&&(n.u[t]|=Jt)},qf.km=function(n,t,e){n.J[t].a=e,n.T&=7},qf.lm=function(n,t,e){n.J[t].b=e,n.T&=7},qf.mm=function(n,t,e){n.J[t].c=e,n.T&=7},qf.nm=function(n,t,e){e>=0&&e<=190&&(151==e||152==e?(n.C[t]=1,n.A[t]=e-149):(n.C[t]=e,n.A[t]=0),n.u[t]&=-2013265921,n.T=0)},qf.om=function(n,t,e,i){n.D[t][e]=i,n.T=0},qf.pm=function(n,t,e){e?n.F[t]|=Lt:n.F[t]&=-32769},qf.qm=function(n,t,e){n.F[t]&=-49,n.F[t]|=e<<4},qf.rm=function(n,t,e,i){var a,s,r;if(0==e)n.F[t]&=-32513,n.F[t]|=e<<8;else{if(i>=32)return;if(-1==i){for(r=-1,s=0;s<n.q;s++)e==(n.u[s]&Kn)>>18&&r<((n.u[s]&Kn)>>18!=1&&(n.u[s]&Kn)>>18!=2?-1:(n.u[s]&It)>>20)&&(r=(n.u[s]&Kn)>>18!=1&&(n.u[s]&Kn)>>18!=2?-1:(n.u[s]&It)>>20);for(a=0;a<n.r;a++)a!=t&&e==(768&n.F[a])>>8&&r<((768&n.F[a])>>8!=1&&(768&n.F[a])>>8!=2?-1:(n.F[a]&Pt)>>10)&&(r=(768&n.F[a])>>8!=1&&(768&n.F[a])>>8!=2?-1:(n.F[a]&Pt)>>10);if((i=r+1)>=32)return}n.F[t]&=-32513,n.F[t]|=e<<8|i<<10}n.T&=7},qf.sm=function(n,t,e){e?n.F[t]|=y:n.F[t]&=-65537},qf.tm=function(n,t,e){n.H[t]=1==e?1:2==e?2:3==e?4:32,n.T=0},qf.um=function(n,t,e,i){n.F[t]&=-131080,n.F[t]|=e,i&&(n.F[t]|=4)},qf.vm=function(n,t){n.F[t]|=gt};qf.wm=function(n,t,e,i){i?n.G[t]|=e:n.G[t]&=~e,n.T=0,n.K=!0},qf.xm=function(n,t,e){n.H[t]=e,n.T=0},qf.ym=function(n,t){n.I=t},qf.zm=function(n,t){n.K!=t&&(n.K=t,t||qf.Pl(n),n.T=0)},qf.Am=function(n,t){n.T=t},qf.Bm=function(n,t){n.S=t},qf.Cm=function(n,t){var e,i;for(n.C=qf.Tm(n.C,t),n.s=qf.Tm(n.s,t),n.w=qf.Tm(n.w,t),i=n.J.length,n.J=qf.Vm(n.J,t),e=i;e<t;e++)n.J[e]=new qf.Ih;n.A=qf.Tm(n.A,t),n.u=qf.Tm(n.u,t),n.B=qf.Um(n.B,t),null!=n.v&&(n.v=qf.Xm(n.v,t)),null!=n.t&&(n.t=qf.Wm(n.t,t)),n.M=t},qf.Dm=function(n,t){n.D[0]=qf.Tm(n.D[0],t),n.D[1]=qf.Tm(n.D[1],t),n.H=qf.Tm(n.H,t),n.F=qf.Tm(n.F,t),n.G=qf.Tm(n.G,t),n.N=t},qf.Em=function(n,t){n.O=t},qf.Fm=function(n,t){n.P=t},qf.Gm=function(n,t){n.u[t]|=y},qf.Hm=function(n,t){var e,i;for(i=0,e=0;e<n.r;e++)(n.D[0][e]==t||n.D[1][e]==t)&&(i+=qf.Uk(n,e));return i},qf.Im=function(n){var t,e,i;for(e=!1,i=!1,t=0;t<n.q;t++)0!=n.A[t]&&(n.A[t]=0,e=!0,1==n.C[t]&&(i=!0));return i&&(n.T=0),e},qf.Jm=function(n,t,e){return qf.xl(n,t)||qf.xl(n,e)?32:1},qf.Km=function(n,t,e){var i,a,s,r,o,f;for(r=n.C[t],n.C[t]=n.C[e],n.C[e]=r,r=n.s[t],n.s[t]=n.s[e],n.s[e]=r,r=n.A[t],n.A[t]=n.A[e],n.A[e]=r,r=n.u[t],n.u[t]=n.u[e],n.u[e]=r,f=n.B[t],n.B[t]=n.B[e],n.B[e]=f,r=n.w[t],n.w[t]=n.w[e],n.w[e]=r,s=n.J[t],n.J[t]=n.J[e],n.J[e]=s,null!=n.v&&(o=n.v[t],n.v[t]=n.v[e],n.v[e]=o),null!=n.t&&(o=n.t[t],n.t[t]=n.t[e],n.t[e]=o),i=0;i<n.r;i++)for(a=0;a<2;a++)n.D[a][i]==t?n.D[a][i]=e:n.D[a][i]==e&&(n.D[a][i]=t);n.T=0},qf.Lm=function(n,t,e){var i;i=n.D[0][t],n.D[0][t]=n.D[0][e],n.D[0][e]=i,i=n.D[1][t],n.D[1][t]=n.D[1][e],n.D[1][e]=i,i=n.H[t],n.H[t]=n.H[e],n.H[e]=i,i=n.F[t],n.F[t]=n.F[e],n.F[e]=i,i=n.G[t],n.G[t]=n.G[e],n.G[e]=i,n.T=0},qf.Mm=function(n,t,e){var i;for(i=0;i<n.q;i++)n.J[i].a+=t,n.J[i].b+=e;n.U+=t,n.V+=e},qf.Nm=function(n,t,e){var i,a;switch(a=127&e,i=qf.dl(n,t),a){case 1:case 64:return i>=1;case 2:return i>=2;case 4:return i>=3;case 8:return i>=4;case 16:return i>=5;case 32:return!0;default:return!1}},qf.Om=function(t,e,i,a){var s,r,o;for(s=0;s<t.q;s++)(!a||512&t.u[s])&&(o=t.R[s]*e,r=t.Q[s]-i,t.J[s].a=t.U+o*n.Math.sin(r),t.J[s].b=t.V+o*n.Math.cos(r));a&&(t.T&=7)},qf.Pm=function(t,e,i){var a,s,r;for(t.U=e,t.V=i,t.Q=$l(Qf.Kmb,S,6,t.q,15,1),t.R=$l(Qf.Kmb,S,6,t.q,15,1),a=0;a<t.q;a++)s=e-t.J[a].a,r=i-t.J[a].b,t.R[a]=n.Math.sqrt(s*s+r*r),t.Q[a]=qf.Zm(e,i,t.J[a].a,t.J[a].b)},qf.Qm=function(){this.M=this.N=256,qf.gl(this)},qf.Rm=function(t,e){this.M=n.Math.max(1,t),this.N=n.Math.max(1,e),qf.gl(this)},qf.Tm=function(t,e){var i;return i=$l(Qf.Mmb,G,6,e,15,1),zf.bKb(t,0,i,0,n.Math.min(t.length,e)),i},qf.Um=function(t,e){var i;return i=$l(Qf.Nmb,st,6,e,14,1),zf.bKb(t,0,i,0,n.Math.min(t.length,e)),i},qf.Vm=function(n,t){var e,i;for(e=$l(Qf.dnb,wt,32,t,0,1),i=0;i<n.length;i++)n[i]&&(e[i]=new qf.Kh(n[i]));return e},qf.Wm=function(n,t){var e,i;for(e=$l(Qf.Imb,j,10,t,0,2),i=0;i<n.length;i++)null!=n[i]&&(e[i]=$l(Qf.Imb,dt,6,n[i].length,15,1),zf.bKb(n[i],0,e[i],0,n[i].length));return e},qf.Xm=function(n,t){var e,i;for(e=$l(Qf.Mmb,ft,8,t,0,2),i=0;i<n.length;i++)null!=n[i]&&(e[i]=$l(Qf.Mmb,G,6,n[i].length,15,1),zf.bKb(n[i],0,e[i],0,n[i].length));return e},qf.Ym=function(n){return qf.Jj(),n>=0&&n<qf.Ej.length&&null!=qf.Ej[n]?qf.Ej[n]:n>=171&&n<=190?qf.Cj:qf.Gj},qf.Zm=function(t,e,i,a){var s,r,o;return qf.Jj(),r=i-t,0!=(o=a-e)?(s=n.Math.atan(r/o),o<0&&(r<0?s-=on:s+=on)):s=r>0?fn:Yn,s},qf.$m=function(n,t){var e;for(qf.Jj(),e=n-t;e<Rt;)e+=rn;for(;e>on;)e-=rn;return e},qf._m=function(n,t){var e,i,a,s,r;if(qf.Jj(),256&t&&zf.pJb(n,"?"))return 0;for(i=1;i<=128;i++)if(!zf.pJb(n,pt)&&zf.qJb(n,qf.Dj[i]))return i;if(2&t)for(a=129;a<=144;a++)if(zf.qJb(n,qf.Dj[a]))return a;if(4&t)for(s=146;s<=148;s++)if(zf.qJb(n,qf.Dj[s]))return s;if(1&t)for(r=151;r<=152;r++)if(zf.qJb(n,qf.Dj[r]))return r;if(32&t&&zf.qJb(n,qf.Dj[153]))return 153;if(8&t&&zf.qJb(n,qf.Dj[154]))return 154;if(16&t&&zf.qJb(n,qf.Dj[145]))return 145;if(128&t&&zf.qJb(n,qf.Dj[159]))return 159;if(64&t)for(e=171;e<=190;e++)if(zf.qJb(n,qf.Dj[e]))return e;return 0},qf.an=function(n){switch(qf.Jj(),n){case 7:case 8:case 9:case 15:case 16:case 17:case 33:case 34:case 35:case 52:case 53:return!0}return!1},qf.bn=function(n){return qf.Jj(),1!=n&&6!=n&&(!qf.an(n)&&(2!=n&&10!=n&&18!=n&&36!=n&&54!=n&&!(n>103)))},qf.cn=function(n){return n>=3&&n<=4||n>=11&&n<=13||n>=19&&n<=31||n>=37&&n<=51||n>=55&&n<=84||n>=87&&n<=112},qf.dn=function(n){return 1==n||n>=5&&n<=9||n>=14&&n<=17||n>=32&&n<=35||n>=52&&n<=53},qf.en=function(n){return n>=21&&n<=30||n>=39&&n<=48||57==n||n>=72&&n<=80||89==n||n>=104&&n<=112},Ol(115,1,{115:1,4:1}),o.Kb=function(n){qf.ek(this,n)},o.Lb=function(n){return 64==this.H[n]},o.q=0,o.r=0,o.I=0,o.K=!1,o.L=!1,o.M=0,o.N=0,o.O=0,o.S=!1,o.T=0,o.U=0,o.V=0,qf.Ij=24,Qf.pnb=hd(115),qf.gn=function(n,t,e,i){var a,s,r,o,f,l,d,g,u;for(qf.nu(t,1),null==i&&(i=$l(Qf.Mmb,G,6,t.q,15,1)),o=qf.Ql(n,1),f=qf.Ql(n,2),u=$l(Qf.nyb,tn,6,t.q,16,1),(l=$l(Qf.Mmb,G,6,t.q,15,1))[0]=e,u[e]=!0,i[e]=qf.ak(t,n,e,o,f),r=0,d=0;r<=d;){for(g=0;g<qf.vn(t,l[r]);g++)u[s=t.i[l[r]][g]]||(l[++d]=s,u[s]=!0,i[s]=qf.ak(t,n,s,o,f));++r}for(a=0;a<t.r;a++)u[t.D[0][a]]&&qf.bk(t,n,a,o,f,null==i?t.D[0][a]:i[t.D[0][a]],null==i?t.D[1][a]:i[t.D[1][a]],!1);qf.Ql(n,1),qf.Ql(n,2),n.T=0},qf.hn=function(n){var t,e,i,a,s,r,o,f,l,d,g,u;for(n.j=$l(Qf.Mmb,G,6,n.q,15,1),n.e=$l(Qf.Mmb,G,6,n.q,15,1),n.i=$l(Qf.Mmb,ft,8,n.q,0,2),n.k=$l(Qf.Mmb,ft,8,n.q,0,2),n.n=$l(Qf.Mmb,ft,8,n.q,0,2),n.o=$l(Qf.Mmb,G,6,n.f,15,1),l=$l(Qf.Mmb,G,6,n.q,15,1),r=0;r<n.r;r++)++l[n.D[0][r]],++l[n.D[1][r]];for(i=0;i<n.q;i++)n.i[i]=$l(Qf.Mmb,G,6,l[i],15,1),n.k[i]=$l(Qf.Mmb,G,6,l[i],15,1),n.n[i]=$l(Qf.Mmb,G,6,l[i],15,1);for(g=!1,o=0;o<n.g;o++)if(0!=(u=qf.Uk(n,o)))for(d=0;d<2;d++)e=n.D[d][o],t=n.e[e],n.n[e][t]=u,n.i[e][t]=n.D[1-d][o],n.k[e][t]=o,++n.e[e],++n.j[e],e<n.f&&(u>1?n.o[e]+=u-1:64==n.H[o]&&(n.o[e]=1));else g=!0;for(f=n.g;f<n.r;f++)if(0!=(u=qf.Uk(n,f)))for(d=0;d<2;d++)e=n.D[d][f],t=n.e[e],n.n[e][t]=u,n.i[e][t]=n.D[1-d][f],n.k[e][t]=f,++n.e[e],n.D[1-d][f]<n.f&&++n.j[e];else g=!0;if(g){for(t=$l(Qf.Mmb,G,6,n.q,15,1),a=0;a<n.q;a++)t[a]=n.e[a];for(s=0;s<n.r;s++)if(0==(u=qf.Uk(n,s)))for(d=0;d<2;d++)e=n.D[d][s],n.n[e][t[e]]=u,n.i[e][t[e]]=n.D[1-d][s],n.k[e][t[e]]=s,++t[e]}},qf.jn=function(t,e,i){var a,s,r,o,f,l,d,g,u,c,b,h,D,H,j,m,A,C,p,M;for(qf.nu(t,1),i&&(e=!0),l=0;l<t.r;l++)if(1==(d=qf.Uk(t,l))||2==d){if(t.s[t.D[0][l]]>0&&t.s[t.D[1][l]]<0)r=t.D[0][l],o=t.D[1][l];else{if(!(t.s[t.D[0][l]]<0&&t.s[t.D[1][l]]>0))continue;r=t.D[1][l],o=t.D[0][l]}if(qf.xl(t,r)||qf.xl(t,o))continue;if(t.C[r]<9&&qf.eo(t,r)>3||t.C[o]<9&&qf.eo(t,o)>3)continue;u=0!=qf.Zn(t,r),t.s[r]-=1,t.s[o]+=1,u||(m=t.H[l],t.H[l]=1==d?2:4,129!=m&&257!=m||(M=t.D[0][l],j=qf.Yo(t,M,!1),t.D[0][j]!=M&&(t.D[1][j]=t.D[0][j],t.D[1][j]=M))),t.T=0}for(A=0,D=0,b=0,s=0;s<t.q;s++)A+=t.s[s],t.s[s]<0&&!qf.xo(t,s)&&(++D,qf.ul(t,s)&&(b-=t.s[s]));if(!e&&0!=A)throw bd(new zf.aA("molecule's overall charges are not balanced"));for(qf.nu(t,1),C=0,p=i?A+b:b,f=0;f<t.q;f++)t.s[f]>0&&!qf.wo(t,f)&&qf.ul(t,f)&&0!=(g=n.Math.min(qf.Zn(t,f),t.s[f]))&&p>=g&&(A-=g,C-=g,p-=g,t.s[f]-=g,t.T&=1);if((H=i?A:C)<0){for(h=$l(Qf.Mmb,G,6,D,15,1),D=0,r=0;r<t.q;r++)t.s[r]<0&&!qf.xo(t,r)&&(h[D++]=(t.C[r]<<22)+r);for(Gf.VUb(h,Gf.zVb(Vl(Vf.NQb.prototype.$d,Vf.NQb,[]))),c=h.length-1;H<0&&c>=h.length-D;c--)a=h[c]&kt,qf.ul(t,a)&&(A+=g=n.Math.min(-H,-t.s[a]),H+=g,t.s[a]+=g,t.T&=1)}return A},qf.kn=function(n){var t,e,i,a,s,r,o,f,l,d,g,u,c;if(!n.K)return!1;for(e=0;e<n.q;e++)(c=qf.cl(n,e))+qf.al(n,e,c,n.C[e])-qf.eo(n,e)<=0&&(0!=n.s[e]||5!=n.C[e]&&(7!=(a=n.C[e])&&15!=a&&33!=a)&&(8!=(i=n.C[e])&&16!=i&&34!=i&&52!=i))&&(n.B[e]=wd(n.B[e],-6145));for(r=!1,t=0;t<n.f;t++)if(o=n.e[t]-n.j[t],!n.S&&o>0)for(Ld(wd(n.B[t],Gn),0)&&(d=Ld(wd(n.B[t],bn),896)?3:Ld(wd(n.B[t],bn),384)?2:Ld(wd(n.B[t],128),128)?1:0,f=(c=qf.cl(n,t))+qf.al(n,t,c,n.C[t])-qf.eo(n,t),0==n.s[t]&&Ld(wd(n.B[t],Dn),0)&&6!=n.C[t]&&++f,(g=o)>3-d&&(g=3-d),g>f+o-d&&(g=f+o-d),g>0&&(u=Gd(u=0==d?0:Yd(wd(n.B[t],bn),g),Qf.Cyb((3==g?7:2==o?3:1)<<7)),n.B[t]=wd(n.B[t],-1921),n.B[t]=Gd(n.B[t],wd(bn,u)))),l=n.j[t];l<n.e[t];l++)s=n.k[t][l],1==n.H[s]&&(n.C[n.i[t][l]]=-1,n.H[s]=512,r=!0);return r&&qf._j(n),r},qf.ln=function(n,t){var e,i,a,s;if(2!=n.o[t]||2!=n.j[t]||2!=n.n[t][0]){if(0==n.o[t]||n.C[t]>=15)for(a=0;a<n.e[t];a++)i=n.k[t][a],(257==n.H[i]||129==n.H[i])&&n.D[0][i]==t&&n.D[0][i]==t&&(n.H[i]=1)}else for(a=0;a<2;a++)if(-1!=(e=qf.qn(n,t,n.i[t][a])))for(s=0;s<n.j[e];s++)i=n.k[e][s],(257==n.H[i]||129==n.H[i])&&n.D[0][i]==e&&(n.H[n.k[e][s]]=1)},qf.mn=function(n,t,e,i,a){var s,r,o,f,l,d,g,u;for(qf.nu(n,i?7:1),t.v=null,n.K&&qf.zm(t,!0),f=e.length,null==a&&(a=$l(Qf.Mmb,G,6,f,15,1)),t.q=0,s=0;s<f;s++)if(e[s]){if(a[s]=qf.ak(n,t,s,0,0),1==n.C[s]&&(u=qf.eo(n,s))>1)for(g=0;g<n.e[s];g++)if(!e[n.i[s][g]]){qf.Ul(t,a[s],u);break}}else a[s]=-1;for(d=$l(Qf.Mmb,G,6,n.r,15,1),Vf.uQb(d,d.length,-1),t.r=0,l=0;l<n.r;l++)r=n.D[0][l],o=n.D[1][l],r<f&&o<f&&(e[r]&&e[o]?d[l]=qf.bk(n,t,l,0,0,null==a?n.D[0][l]:a[n.D[0][l]],null==a?n.D[1][l]:a[n.D[1][l]],i):0!=n.s[r]&&0!=n.s[o]&&n.s[r]<0^n.s[o]<0&&(e[r]&&(t.s[a[r]]+=n.s[r]<0?1:-1),e[o]&&(t.s[a[o]]+=n.s[o]<0?1:-1)));qf.ek(n,t),n.d&&(t.T=0),t.T=0,qf.Ql(t,1),qf.Ql(t,2),t.q!=f&&qf.zm(t,!0),qf._o(n,t,f,a,d),qf.$o(n,t,f,a),i&&qf.ie(new qf.se(t),null,!1)},qf.nn=function(n,t,e,i,a){var s,r,o,f,l,d,g,u;for(qf.nu(n,i?7:1),t.v=null,n.K&&qf.zm(t,!0),null==a&&(a=$l(Qf.Mmb,G,6,n.q,15,1)),t.q=0,s=0;s<n.q;s++)for(a[s]=-1,d=0;d<n.j[s];d++)if(e[n.k[s][d]]){if(a[s]=qf.ak(n,t,s,0,0),1==n.C[s]&&(u=qf.eo(n,s))>1)for(g=0;g<n.e[s];g++)if(!e[n.k[s][g]]){qf.Ul(t,a[s],u);break}break}for(l=$l(Qf.Mmb,G,6,n.r,15,1),t.r=0,f=0;f<n.r;f++)e[f]?l[f]=qf.bk(n,t,f,0,0,null==a?n.D[0][f]:a[n.D[0][f]],null==a?n.D[1][f]:a[n.D[1][f]],i):(l[f]=-1,r=n.D[0][f],o=n.D[1][f],-1==a[r]^-1==a[o]&&0!=n.s[r]&&0!=n.s[o]&&n.s[r]<0^n.s[o]<0&&(-1!=a[r]&&(t.s[a[r]]+=n.s[r]<0?1:-1),-1!=a[o]&&(t.s[a[o]]+=n.s[o]<0?1:-1)));return qf.ek(n,t),n.d&&(t.T=0),t.T=0,qf.Ql(t,1),qf.Ql(t,2),t.q!=n.q&&qf.zm(t,!0),qf._o(n,t,n.q,a,l),qf.$o(n,t,n.q,a),i&&qf.ie(new qf.se(t),null,!1),a},qf.on=function(n,t){var e,i,a,s,r,o,f,l,d,g;if(t&~n.T&&(1&n.T||(qf.vo(n),qf.hn(n),n.T|=1,qf.kn(n)&&(qf.vo(n),qf.hn(n))),t&~n.T)){if(-7&n.T){for(i=0;i<n.f;i++)n.u[i]&=-15369;for(s=0;s<n.g;s++)n.F[s]&=-705;if(!(4&t))return qf.tn(n,1),void(n.T|=2);for(qf.tn(n,7),a=0;a<n.f;a++)for(d=0;d<n.j[a];d++)if(!((f=n.k[a][d])<n.g&&qf.Pr(n.p,f)))for(o=n.i[a][d],g=0;g<n.j[o];g++)n.k[o][g]!=f&&n.n[o][g]>1&&(6==n.C[n.i[o][g]]?n.u[a]|=dn:!qf.Co(n,n.k[o][g])&&qf.ul(n,n.i[o][g])&&(n.u[a]|=Xn));for(;;){for(l=!1,e=0;e<n.f;e++)if(n.o[e]>0&&n.u[e]&Xn&&!qf.Or(n.p,e))for(d=0;d<n.j[e];d++)if(n.n[e][d]>1)for(o=n.i[e][d],f=n.k[e][d],g=0;g<n.j[o];g++)n.k[o][g]!=f&&(r=n.i[o][g],n.u[r]&Xn||(n.u[r]|=Xn,l=!0));if(!l)break}}n.T|=6}},qf.pn=function(n,t){var e,i,a,s,r;if(e=-1,1==n.o[t])for(s=0;s<n.j[t];s++)if(2==n.n[t][s]){if(i=n.i[t][s],2==n.j[i]&&2==n.o[i])for(r=0;r<2;r++)if((a=n.i[i][r])!=t&&1==n.o[a]){e=i;break}break}return e},qf.qn=function(n,t,e){var i,a;for(i=t;2==n.j[e]&&2==n.o[e]&&e!=i;)a=e,e=n.i[e][0]==t?n.i[e][1]:n.i[e][0],t=a;return e==i?-1:e},qf.rn=function(n,t){var e;if(3==n.j[t]&&t<n.f&&qf.Or(n.p,t)&&(n.p&&t<n.f?qf.Dr(n.p,t):0)>=5)for(e=0;e<n.j[t];e++)if(qf.Do(n,n.k[t][e]))return n.k[t][e];return-1},qf.sn=function(n,t,e,i,a){var s,r,o,f,l,d;if(qf.nu(n,7),n.u[t]&xt&&(!e||t<n.f&&qf.Or(n.p,t)))for((f=$l(Qf.Mmb,G,6,n.f,15,1))[0]=t,i[t]=!0,o=0,l=0;o<=l;){for(d=0;d<n.j[f[o]];d++)!a[r=n.k[f[o]][d]]&&64&n.F[r]&&(!e||r<n.g&&qf.Pr(n.p,r))&&(a[r]=!0,i[s=n.i[f[o]][d]]||(i[s]=!0,f[++l]=s));++o}},qf.tn=function(n,t){var e,i,a,s,r,o,f,l;for(n.p=new qf.as(n,t),i=$l(Qf.Mmb,G,6,n.f,15,1),a=0;a<n.g;a++)0!=qf.Fr(n.p,a)&&(n.F[a]|=64,++i[n.D[0][a]],++i[n.D[1][a]]);for(e=0;e<n.f;e++)2==i[e]?n.u[e]|=hn:3==i[e]?n.u[e]|=Gn:i[e]>3&&(n.u[e]|=xt);for(l=0;l<n.p.i.a.length;l++)for(r=qf.Hr(n.p,l),f=qf.Ir(n.p,l),o=r.length,s=0;s<o;s++)n.u[r[s]]|=8,n.F[f[s]]|=128,386==n.H[f[s]]&&(n.H[f[s]]=2)},qf.un=function(n){var t,e,i,a,s,r,o,f;for(o=$l(Qf.nyb,tn,6,n.q,16,1),e=0;e<n.q;e++)o[e]=!(1!=n.C[e]||0!=n.A[e]||0!=n.s[e]||n.u[e]&Mt||null!=n.t&&null!=n.t[e]);for(f=$l(Qf.nyb,tn,6,n.q,16,1),r=0;r<n.r;r++)i=n.D[0][r],a=n.D[1][r],1==qf.Uk(n,r)?(f[i]&&(o[i]=!1),f[a]&&(o[a]=!1),o[i]&&qf.xl(n,a)&&13!=n.C[a]&&(o[i]=!1),o[a]&&qf.xl(n,i)&&13!=n.C[i]&&(o[a]=!1),f[i]=!0,f[a]=!0):(o[i]=!1,o[a]=!1);for(s=0;s<n.r;s++)o[n.D[0][s]]&&o[n.D[1][s]]&&(o[n.D[0][s]]=!1,o[n.D[1][s]]=!1);for(t=0;t<n.q;t++)f[t]||(o[t]=!1);return o},qf.vn=function(n,t){return n.e[t]},qf.wn=function(n,t){return n.i[t].length},qf.xn=function(n,t){return n.e[t]-qf.co(n,t)+qf.Zn(n,t)},qf.yn=function(n){var t,e;for(qf.nu(n,7),t=0,e=0;e<n.p.i.a.length;e++)qf.Nr(n.p,e)&&++t;return t},qf.zn=function(n,t){var e,i;for(e=0,i=0;i<n.j[t];i++)qf.ul(n,n.i[t][i])&&!qf.pl(n,n.k[t][i])&&++e;return e},qf.An=function(n,t){return n.o[t]},qf.Bn=function(n,t){return qf.nu(n,7),2==n.o[t]&&2==n.j[t]?qf.Wo(n,t,!1):qf.Yo(n,t,!1)},qf.Cn=function(n,t){var e;return 0==(e=n.u[t]&xt)?0:e==hn?2:e==Gn?3:4},qf.Dn=function(n,t,e){var i,a,s,r,o,f,l,d,g,u,c,b;for(qf.nu(n,7),s=$l(Qf.nyb,tn,6,n.g,16,1),g=$l(Qf.nyb,tn,6,n.g,16,1),b=$l(Qf.Mmb,G,6,n.f,15,1),r=0,o=1;o<n.j[t];o++)if(i=n.k[t][o],64&n.F[i])for(l=0;l<o;l++)if(a=n.k[t][l],64&n.F[a]&&(g[i]=!0,g[a]=!0,c=qf.go(n,b,n.i[t][o],n.i[t][l],e-2,null,g),g[i]=!1,g[a]=!1,-1!=c)){for(f=!1,u=$l(Qf.Mmb,G,6,c,15,1),qf.ho(n,b,u,c),d=0;d<c;d++)s[u[d]]||(s[u[d]]=!0,f=!0);f&&++r}return r},qf.En=function(n,t){return n.p&&t<n.f?qf.Dr(n.p,t):0},qf.Fn=function(n,t){return t?(qf.nu(n,1),qf.Jk(n,n.f,n.g,qf.Ij)):qf.Jk(n,n.q,n.r,qf.Ij)},qf.Gn=function(n){var t,e,i,a,s,r,o,f;for(qf.nu(n,1),o=$l(Qf.Lmb,Et,6,n.f,15,1),i=$l(Qf.Mmb,G,6,n.f,15,1),f=0;f<n.f;f++){for(i[0]=f,(a=$l(Qf.Mmb,G,6,n.f,15,1))[f]=1,e=0,s=0;e<=s;){for(r=0;r<n.j[i[e]];r++)0==a[t=n.i[i[e]][r]]&&(a[t]=a[i[e]]+1,i[++s]=t,o[f]+=a[t]-1);++e}o[f]/=s}return o},qf.Hn=function(n,t,e){var i;for(i=0;i<n.i[t].length;i++)if(n.i[t][i]==e)return n.k[t][i];return-1},qf.In=function(n,t){return n.p&&t<n.g?qf.Fr(n.p,t):0},qf.Jn=function(n,t,e){return n.i[t][e]},qf.Kn=function(n,t){return n.j[t]},qf.Ln=function(n,t,e){return n.k[t][e]},qf.Mn=function(n,t,e){return n.n[t][e]},qf.Nn=function(n,t){var e,i;for(e=0,i=0;i<n.j[t];i++)Sd(wd(n.B[n.i[t][i]],en),0)&&++e;return e},qf.On=function(n,t){return n.e[t]-n.j[t]},qf.Pn=function(t,e,i,a,s){var r,o,f,l;if(o=t.e[e],0!=t.o[e]||e<t.f&&qf.Or(t.p,e)||t.j[e]<3||o>4)return!1;for(l=$l(Qf.nyb,tn,6,4,16,1),f=0;f<o;f++){if(r=3.9269908169872414-a[f],n.Math.abs(Ft-r%fn)>.0872664675116539)return!1;if(s[f]=3&ud(r/fn),l[s[f]])return!1;if(l[s[f]]=!0,1&s[f]){if(!qf.El(t,t.k[e][i[f]],e))return!1}else if(1!=t.H[t.k[e][i[f]]])return!1}return l[0]&&l[2]},qf.Qn=function(t,e,i,a,s){var r,o,f,l,d,g;if((t.p&&e<t.f?qf.Dr(t.p,e):0)>24)return 3;if(r=t.e[e],null==s&&(s=$l(Qf.Mmb,G,6,r,15,1)),!qf.Pn(t,e,i,a,s))return 3;for(l=-1,d=0;d<r;d++)if(!(1&~s[d])){if(o=t.H[t.k[e][i[d]]],-1!=l&&l!=o)return 3;l=o}return f=s[g=2==n.Math.abs(s[0]-s[1])?1:0]-s[g+1],3==n.Math.abs(f)^s[g]<s[g+1]^(3==r||!(1&~s[3]))^129==l?1:2},qf.Rn=function(n,t,e){var i,a,s,r;for(r=r=$l(Qf.nyb,tn,6,n.q,16,1),s=qf.Sn(n,t,e,r),a=$l(Qf.Mmb,G,6,s,15,1),s=0,i=0;i<n.q;i++)r[i]&&(a[s++]=i);return a},qf.Sn=function(n,t,e,i){var a,s,r,o,f,l,d;for(qf.nu(n,1),null==i&&(i=$l(Qf.nyb,tn,6,n.q,16,1)),(f=$l(Qf.Mmb,G,6,n.q,15,1))[0]=t,i[t]=!0,r=0,l=0,o=1;r<=l;){for(s=e?qf.wn(n,f[r]):n.e[f[r]],d=0;d<s;d++)(a=n.i[f[r]][d])<i.length&&!i[a]&&(f[++l]=a,i[a]=!0,++o);++r}return o},qf.Tn=function(n,t,e,i){var a,s,r,o,f,l,d,g,u;for(qf.nu(n,1),s=0;s<n.q;s++)t[s]=-1;for(l=0,a=0;a<n.q;a++)if(-1==t[a]&&(!e||n.u[a]&gt)){for(t[a]=l,(d=$l(Qf.Mmb,G,6,n.q,15,1))[0]=a,f=0,g=0;f<=g;){for(o=i?qf.wn(n,d[f]):n.e[d[f]],u=0;u<o;u++)-1==t[r=n.i[d[f]][u]]&&(!e||n.u[r]&gt)&&(d[++g]=r,t[r]=l);++f}++l}return l},qf.Un=function(n,t,e,i){var a,s,r,o,f,l,d,g,u;for(qf.nu(n,1),s=0;s<n.q;s++)t[s]=-1;for(l=0,a=0;a<n.q;a++)if(-1==t[a]){for(t[a]=l,(d=$l(Qf.Mmb,G,6,n.q,15,1))[0]=a,f=0,g=0;f<=g;){for(o=i?qf.wn(n,d[f]):n.e[d[f]],u=0;u<o;u++)-1!=t[r=n.i[d[f]][u]]||e[n.k[d[f]][u]]||(d[++g]=r,t[r]=l);++f}++l}return l},qf.Vn=function(n,t){var e;return(e=qf.cl(n,t))+qf.al(n,t,e,n.C[t])-qf.eo(n,t)},qf.Wn=function(n,t){var e,i,a,s,r,o;for(s=$l(Qf.Mmb,G,6,n.q,15,1),i=0;i<n.q;i++)s[i]=i;a=n.q;do{--a}while(a>=0&&t[a]);for(e=0;e<a;e++)if(t[s[e]]){o=s[e],s[e]=s[a],s[a]=o,r=t[e],t[e]=t[a],t[a]=r;do{--a}while(t[a])}return s},qf.Xn=function(n){return qf.Wn(n,qf.un(n))},qf.Yn=function(n,t,e){var i,a,s;if(a=qf.eo(n,t),a-=qf.al(n,t,a,n.C[t]),e&&(a-=n.e[t]-n.j[t]),a<=(s=qf.Ym(n.C[t]))[0])return-1;for(i=1;i<s.length;i++)if(s[i]>=a)return s[i];return a},qf.Zn=function(t,e){var i,a,s,r,o,f;if(t.K&&Ld(wd(t.B[e],Gn),0))return 0;if(!qf.hp(t,e))return 0;for(qf.nu(t,1),o=0,s=0;s<t.e[e];s++)o+=t.n[e][s];if(t.K){for(i=1,a=0;a<t.j[e];a++)64==t.H[t.k[e][a]]&&++i;o+=i>>1}if(o-=qf.al(t,e,o,t.C[e]),-1==(r=((t.u[e]&Mt)>>>27)-1))for(r=(f=qf.Ym(t.C[e]))[0],a=1;r<o&&a<f.length;a++)r=f[a];return n.Math.max(0,r-o)},qf.$n=function(t,e){var i,a,s,r,o;if(!t.K||null==t.v||null==t.v[e])return qf._n(t,e,t.C[e]);for(o=0,s=0,r=(a=t.v[e]).length;s<r;++s)i=a[s],o=n.Math.max(o,qf._n(t,e,i));return o},qf._n=function(n,t,e){var i,a,s,r,o;if(s=qf.eo(n,t),i=qf.al(n,t,s,e),-1==(r=((n.u[t]&Mt)>>>27)-1)){for(o=qf.Ym(n.C[t]),a=0;s>o[a]+i&&a<o.length-1;)++a;r=o[a]}return r+i-s},qf.ao=function(n,t){return n.i[t].length-n.e[t]},qf.bo=function(n){var t,e,i;for(qf.nu(n,1),i=0,t=0;t<n.q;t++)i+=(0!=n.A[t]?n.A[t]:qf.Hj[n.C[t]])+qf.Zn(n,t)*qf.Hj[1],n.C[t]>=171&&n.C[t]<=190&&(e=n.e[t])>2&&(i-=(e-2)*qf.Hj[1]);return i},qf.co=function(n,t){var e,i;for(e=n.j[t],i=0;i<n.j[t];i++)1==n.C[n.i[t][i]]&&--e;return e},qf.eo=function(n,t){var e,i,a,s,r,o;for(n.Mb(1),r=!1,i=!1,o=0,a=0;a<n.e[t];a++)n.K&&!Ld(wd(n.B[n.i[t][a]],en),0)||(o+=s=n.n[t][a],s>1&&(r=!0),e=n.k[t][a],64==n.H[e]&&(i=!0));return i&&!r&&++o,o},qf.fo=function(n,t,e){var i,a,s;for(a=0,s=0;s<n.j[t];s++)(i=n.i[t][s])!=e&&n.j[i]>2&&++a;return a},qf.go=function(n,t,e,i,a,s,r){var o,f,l,d,g,u,c,b,h;if(e==i)return t[0]=e,0;for(n.Mb(1),d=$l(Qf.Mmb,G,6,n.q,15,1),l=$l(Qf.Mmb,G,6,n.q,15,1),h=$l(Qf.Mmb,G,6,n.q,15,1),l[0]=e,d[e]=1,f=0,g=0;f<=g&&d[l[f]]<=a;){for(b=l[f],u=0;u<n.e[b];u++)if(null==r||r.length<=n.k[b][u]||!r[n.k[b][u]]){if((o=n.i[b][u])==i){for(t[c=d[b]]=o,t[--c]=b;c>0;)t[c-1]=h[t[c]],--c;return d[b]}0==d[o]&&(null==s||s.length<=o||!s[o])&&(l[++g]=o,d[o]=d[b]+1,h[o]=b)}++f}return-1},qf.ho=function(n,t,e,i){var a,s;for(qf.nu(n,1),a=0;a<i;a++)for(s=0;s<n.e[t[a]];s++)if(n.i[t[a]][s]==t[a+1]){e[a]=n.k[t[a]][s];break}},qf.io=function(n,t,e){var i,a,s,r,o,f;if(t==e)return 0;for(qf.nu(n,1),r=$l(Qf.Mmb,G,6,n.q,15,1),(s=$l(Qf.Mmb,G,6,n.q,15,1))[0]=t,r[t]=1,a=0,o=0;a<=o;){for(f=0;f<n.e[s[a]];f++){if((i=n.i[s[a]][f])==e)return r[s[a]];0==r[i]&&(s[++o]=i,r[i]=r[s[a]]+1)}++a}return-1},qf.jo=function(n,t,e,i,a){var s,r,o,f,l,d;if(t==e)return 0;for(n.Mb(1),f=$l(Qf.Mmb,G,6,n.q,15,1),(o=$l(Qf.Mmb,G,6,n.q,15,1))[0]=t,f[t]=1,r=0,l=0;r<=l&&f[o[r]]<=i;){for(d=0;d<n.e[o[r]];d++){if((s=n.i[o[r]][d])==e)return f[o[r]];0==f[s]&&(null==a||a.length<=s||!a[s])&&(o[++l]=s,f[s]=f[o[r]]+1)}++r}return-1},qf.ko=function(n,t){return n.e[t]-n.j[t]+qf.Zn(n,t)},qf.lo=function(n,t){var e,i,a,s,r,o,f,l,d,g,u,c,b;for(b=$l(Qf.Mmb,G,6,16,15,1),e=$l(Qf.Kmb,S,6,16,15,1),s=$l(Qf.Kmb,S,6,2,15,1),i=0,d=0;d<2;d++)for(a=n.D[d][t],g=0;g<n.j[a];g++)if((f=n.k[a][g])!=t){if(4==i)return 0;o=n.i[a][g],b[i]=16,0!=n.o[o]&&(b[i]+=n.u[o]&xt?1:4),64&n.F[t]&&64&n.F[f]&&-1!=(u=qf.Lr(n.p,t,f))&&(b[i]+=qf.Nr(n.p,u)?64:6),e[i++]=qf.Zm(n.J[a].a,n.J[a].b,n.J[o].a,n.J[o].b)}for(s[0]=qf.Lk(n,n.D[0][t],n.D[1][t]),s[0]<0?(s[1]=s[0]+on,r=!1):(s[1]=s[0],s[0]=s[1]-on,r=!0),c=0,l=0;l<i;l++)e[l]>s[0]&&e[l]<s[1]?c-=b[l]:c+=b[l];return r?-c:c},qf.mo=function(n){return qf.nu(n,7),n.p},qf.no=function(n){var t,e,i,a,s,r,o,f,l;for(l=0,qf.nu(n,7),i=0;i<n.g;i++)if(1==qf.Uk(n,i)&&!(64&n.F[i])){for(o=!0,r=0;r<2;r++){if(t=n.D[r][i],1==n.j[t]){o=!1;break}if(7==n.C[t]&&!(t<n.f&&qf.Or(n.p,t)))for(e=n.D[1-r][i],f=0;f<n.j[e];f++)if(a=n.i[e][f],(s=n.k[e][f])!=i&&qf.Uk(n,s)>1&&!(a<n.f&&qf.Or(n.p,a))&&qf.ul(n,a)){o=!1;break}}o&&!qf.Lo(n,i)&&++l}return l},qf.oo=function(n,t,e){var i,a,s,r,o,f;for(a=0,s=0;s<n.j[t];s++)if((i=n.i[t][s])!=e){for(r=0,o=0;o<n.j[i];o++)(f=n.i[i][o])!=t&&qf.Co(n,n.k[i][o])&&n.j[f]>2&&++r;2==r&&++a}return a},qf.po=function(n,t){var e,i,a,s;for(e=n.e[t],s=$l(Qf.Mmb,G,6,e,15,1),a=0;a<e;a++)s[a]=(n.i[t][a]<<16)+a;for(Gf.VUb(s,Gf.zVb(Vl(Vf.NQb.prototype.$d,Vf.NQb,[]))),i=0;i<e;i++)s[i]&=B;return s},qf.qo=function(n,t){var e,i;if(qf.nu(n,1),2==n.j[t]&&2==n.n[t][0]&&2==n.n[t][1]){for(e=0;e<2;e++)for(i=0;i<n.e[n.i[t][e]];i++)if(qf.El(n,n.k[n.i[t][e]][i],n.i[t][e]))return n.k[n.i[t][e]][i]}else for(e=0;e<n.e[t];e++)if(qf.El(n,n.k[t][e],t))return n.k[t][e];return-1},qf.ro=function(t,e,i){return 1!=qf.Uk(t,e)?0:16-t.e[i]+16*n.Math.max(0,n.Math.min(9,t.p&&e<t.g?qf.Fr(t.p,e):0)-2)+(384&t.H[e]&&t.D[0][e]==i?0:Lt)+(3&t.u[i]?0:dn)+(1==t.C[i]?Gn:0)+(1==t.e[i]?hn:0)+(64&t.F[e]?0:512)+(6!=t.C[i]?256:0)},qf.so=function(n,t,e,i,a,s){var r,o,f,l,d;for(qf.nu(n,1),a&&(qf.$j(a),a.d=null,a.K=!1),f=$l(Qf.Mmb,G,6,n.q,15,1),null==i?i=$l(Qf.nyb,tn,6,n.q,16,1):Vf.xQb(i,i.length),f[0]=t,f[1]=e,i[t]=!0,i[e]=!0,o=1,l=1;o<=l;){for(d=0;d<n.e[f[o]];d++){if((r=n.i[f[o]][d])==t&&1!=o)return-1;i[r]||(i[r]=!0,f[++l]=r)}++o}return a&&(null==s&&(s=$l(Qf.Mmb,G,6,i.length,15,1)),qf.mn(n,a,i,!1,s),qf.Xj(a,s[t],0,0,-1,0)),i[t]=!1,l},qf.to=function(n,t,e){var i,a,s,r,o,f;for(qf.nu(n,1),s=$l(Qf.Mmb,G,6,n.f,15,1),f=$l(Qf.nyb,tn,6,n.f,16,1),s[0]=t,s[1]=e,f[t]=!0,f[e]=!0,a=1,r=1;a<=r;){for(o=0;o<n.j[s[a]];o++){if((i=n.i[s[a]][o])==t&&1!=a)return-1;f[i]||(f[i]=!0,s[++r]=i)}++a}return r},qf.uo=function(n,t,e){var i,a,s,r,o,f,l,d,g,u,c;if(2!=qf.Uk(n,e)&&!(e<n.g&&qf.Pr(n.p,e)))return-1;if(1!=(c=3&n.F[e])&&2!=c)return-1;for(f=0;f<2;f++){for(i=n.D[f][e],a=n.D[1-f][e],u=-1,r=!1,d=0;d<n.j[i];d++)(s=n.i[i][d])!=a&&(s==t?r=!0:u=s);if(r){for(g=-1,o=-1,l=0;l<n.j[a];l++)(s=n.i[a][l])!=i&&(-1==g?g=s:s>g?o=s:(o=g,g=s));return 2==n.j[i]?2==n.j[a]?2==c?g:-1:2==c?g:o:2==n.j[a]?2==c^t<u?-1:g:2==c^t<u?o:g}}return-1},qf.vo=function(n){var t,e,i,a,s,r,o,f,l,d;r=qf.un(n),f=n.q;do{--f}while(f>=0&&r[f]);for(t=0;t<f;t++)if(r[t]){qf.Km(n,t,f),d=r[t],r[t]=r[f],r[f]=d;do{--f}while(r[f])}if(n.f=f+1,n.q!=n.f){for(o=$l(Qf.nyb,tn,6,n.r,16,1),s=0;s<n.r;s++)e=n.D[0][s],i=n.D[1][s],(r[e]||r[i])&&(o[s]=!0);l=n.r;do{--l}while(l>=0&&o[l]);for(a=0;a<l;a++)if(o[a]){qf.Lm(n,a,l),o[a]=!1;do{--l}while(o[l])}n.g=l+1}else n.g=n.r},qf.wo=function(n,t){var e;for(e=0;e<n.j[t];e++)if(n.s[n.i[t][e]]<0)return!0;return!1},qf.xo=function(n,t){var e;for(e=0;e<n.j[t];e++)if(n.s[n.i[t][e]]>0)return!0;return!1},qf.yo=function(n,t){var e;return 3==(e=n.C[t])||11==e||19==e||37==e||55==e},qf.zo=function(n,t){return!!(n.u[t]&dn)},qf.Ao=function(n,t){var e,i,a,s,r,o;for(qf.nu(n,1),r=0;r<2;r++)if(e=n.D[r][t],7==n.C[e])for(i=n.D[1-r][t],o=0;o<n.j[i];o++)if(a=n.i[i][o],s=n.k[i][o],(7==n.C[a]||8==n.C[a]||16==n.C[a])&&qf.Uk(n,s)>=2)return!0;return!1},qf.Bo=function(n,t){return t<n.f&&qf.Or(n.p,t)},qf.Co=function(n,t){return t<n.g&&qf.Pr(n.p,t)},qf.Do=function(n,t){var e,i,a,s,r,o;return!(1!=n.H[t]||t<n.g&&qf.Pr(n.p,t)||64&n.F[t]&&(n.p&&t<n.g?qf.Fr(n.p,t):0)<7)&&(!(!((e=n.D[0][t])<n.f&&qf.Or(n.p,e))||(n.p&&e<n.f?qf.Dr(n.p,e):0)<5)&&(!(!((i=n.D[1][t])<n.f&&qf.Or(n.p,i))||(n.p&&i<n.f?qf.Dr(n.p,i):0)<5)&&(a=qf.fo(n,e,i),s=qf.fo(n,i,e),(n.p&&e<n.f?qf.Dr(n.p,e):0)>5&&(n.p&&i<n.f?qf.Dr(n.p,i):0)>5?a+s>2:(r=qf.oo(n,e,i),o=qf.oo(n,i,e),2==a&&o>=1||(2==s&&r>=1||(2==r&&(s>=1||o>=1)||2==o&&(a>=1||r>=1)))))))},qf.Eo=function(n,t){return 2==n.o[t]&&2==n.j[t]&&2==n.n[t][0]&&2==n.n[t][1]&&n.C[t]<=7},qf.Fo=function(n,t){var e;return 8==(e=n.C[t])||16==e||34==e||52==e},qf.Go=function(n,t){return t<n.g&&(qf.Tr(n.p,t)||64==n.H[t])},qf.Ho=function(n,t){var e;return 12==(e=n.C[t])||20==e||38==e||56==e},qf.Io=function(n,t,e){var i,a,s,r,o,f,l,d,g,u,c,b,h;if(7!=n.C[t]||4==n.j[t])return!1;if(t<n.f&&qf.Or(n.p,t)||0!=n.o[t]||Sd(wd(n.B[t],Sn),0))return!0;if(1==n.s[t])return!1;for(f=0;f<n.j[t];f++)if(3==qf.In(n,n.k[t][f]))return!1;for(r=0,l=0;l<n.j[t];l++)1==n.n[t][l]&&(8==(i=n.C[n.i[t][l]])||9==i||17==i)&&++r;if(0==r)for(o=0;o<n.j[t];o++)if(a=n.i[t][o],0!=n.o[a]){if(a<n.f&&qf.Or(n.p,a)){if((n.p&&a<n.f?qf.Dr(n.p,a):0)>=5){for(h=0,u=0;u<n.j[a];u++)(b=n.i[a][u])!=t&&qf.co(n,b)>=3&&++h;if(c=qf.co(n,t),2==h&&c>=2||1==h&&3==c)continue}return!e||!qf.No(n,t)}for(g=0;g<n.j[a];g++)if(2==n.n[a][g]||qf.Co(n,n.k[a][g]))return!e||!qf.No(n,t)}if(r<2)for(o=0;o<n.j[t];o++){for(a=n.i[t][o],d=!1,s=!1,g=0;g<n.j[a];g++)n.i[a][g]!=t&&(1!=n.n[a][g]&&(7==n.C[n.i[a][g]]||8==n.C[n.i[a][g]]||16==n.C[n.i[a][g]])&&(d=!0),1==n.n[a][g]&&7==n.C[n.i[a][g]]&&(s=!0));if(d&&(!s||0==r))return!e||!qf.No(n,t)}return!1},qf.Jo=function(n,t){var e;return 9==(e=n.C[t])||17==e||35==e||53==e},qf.Ko=function(n,t){var e;return 7==(e=n.C[t])||15==e||33==e},qf.Lo=function(n,t){var e,i,a,s,r,o;if(1!=qf.Uk(n,t))return!1;for(s=0;s<2;s++){for(e=n.D[s][t],o=n.D[1-s][t];2==n.o[e]&&2==n.j[e]&&n.C[e]<10;)for(r=0;r<2;r++)if((i=n.i[e][r])!=o){if(1==n.j[i])return!0;if(a=n.k[e][r],1==qf.Uk(n,a)&&a<t)return!0;o=e,e=i;break}if(1==n.j[e])return!0}return!1},qf.Mo=function(n,t,e,i,a){var s,r,o,f,l,d,g,u,c,b,h,D,H;if((u=$l(Qf.nyb,tn,6,n.g,16,1))[a]=!0,c=$l(Qf.Mmb,G,6,11,15,1),-1==(b=qf.go(n,c,i,t,10,null,u)))return!1;for(r=1;!qf.Qr(n.p,e,c[r]);)++r;if(s=b-r,o=c[r],6==(H=qf.Kr(n.p,e))&&2==s&&3==r&&qf.Cn(n,c[1])>=3)for(D=qf.Hr(n.p,e),g=0;g<6;g++)if(t==D[g]){if(h=D[qf._r(n.p,e,o==D[qf._r(n.p,e,g+2)]?g-2:g+2)],(0==(d=n.u[h]&xt)?0:d==hn?2:d==Gn?3:4)>=3&&2==qf.jo(n,c[1],h,2,null))return!0;break}if(l=!(f=1==n.o[o]||o<n.f&&qf.Or(n.p,o)||qf.Io(n,o,!1))&&7==n.C[o]&&1!=n.s[o],1==s)return!f&&!l&&H<=4&&r<=3;switch(H){case 4:if(!f&&!l&&r<=4)return!0;break;case 5:if(l){if(r<=3)return!0}else if(!f&&r<=4)return!0;break;case 6:if(2==s){if(f){if(r<=4)return!0}else if(!l&&r<=3)return!0}else if(3==s)if(f){if(r<=6)return!0}else if(r<=4)return!0;break;case 7:if(3==s&&r<=3)return!0}return!1},qf.No=function(n,t){var e,i,a,s,r;if(t<n.f&&qf.Or(n.p,t)||0!=n.o[t]||Sd(wd(n.B[t],Sn),0)||(0==(i=n.u[t]&xt)?0:i==hn?2:i==Gn?3:4)<3)return!1;if((r=n.p&&t<n.f?qf.Dr(n.p,t):0)>7)return!1;for(s=0;s<n.p.i.a.length&&(qf.Kr(n.p,s)!=r||!qf.Qr(n.p,s,t));)++s;if(s>=hn&&s==n.p.i.a.length)return!1;for(a=0;a<n.j[t];a++)if(e=n.k[t][a],!qf.Rr(n.p,s,e)&&qf.Mo(n,t,s,n.i[t][a],e))return!0;return!1},qf.Oo=function(n,t){return!!(n.u[t]&xt)},qf.Po=function(n,t){return!!(64&n.F[t])},qf.Qo=function(n,t){return!(1!=n.C[t]||0!=n.A[t]||0!=n.s[t]||n.u[t]&Mt||null!=n.t&&null!=n.t[t])},qf.Ro=function(n,t){return!!(8&n.u[t])},qf.So=function(n,t){return!!(128&n.F[t])},qf.To=function(n,t){return!!(n.u[t]&Xn)},qf.Uo=function(n){var t,e,i,a,s,r,o,f,l,d,g;for(qf.nu(n,1),qf.Vo(n),l=!1,e=0;e<n.f;e++)if(7==n.C[e]&&0==n.s[e])if(4==(g=qf.eo(n,e))){for(d=0;d<n.j[e];d++)if(o=n.i[e][d],1==n.n[e][d]&&8==n.C[o]&&1==n.j[o]&&0==n.s[o]){l=!0,++n.s[e],--n.s[o];break}}else if(5==g)for(d=0;d<n.j[e];d++){if(o=n.i[e][d],f=n.k[e][d],2==n.n[e][d]&&8==n.C[o]){l=!0,++n.s[e],--n.s[o],n.H[f]=1;break}if(3==n.n[e][d]&&7==n.C[o]){l=!0,++n.s[e],--n.s[o],n.H[f]=2;break}}for(r=!1,s=0;s<n.g;s++)for(d=0;d<2;d++)if(qf.ul(n,n.D[d][s])){t=n.D[1-d][s],3!=(a=n.C[t])&&11!=a&&19!=a&&37!=a&&55!=a&&(12!=(i=n.C[t])&&20!=i&&38!=i&&56!=i)||(1==qf.Uk(n,s)?(++n.s[t],--n.s[n.D[d][s]],n.H[s]=512,r=!0):32==n.H[s]&&(n.H[s]=512,r=!0));break}return r&&(qf._j(n),l=!0),l&&(n.T=0),l},qf.Vo=function(n){var t;for(t=0;t<n.g;t++)if(64==n.H[t])return qf.ie(new qf.se(n),null,!1);return!1},qf.Wo=function(n,t,e){var i,a,s,r,o,f,l,d;for(l=-1,a=0,o=0;o<2;o++)for(i=n.i[t][o],f=0;f<n.e[i];f++)(s=n.i[i][f])!=t&&(r=n.k[i][f],a<(d=qf.ro(n,r,s))&&(!e||257!=n.H[r]&&129!=n.H[r])&&(a=d,l=r));return l},qf.Xo=function(n,t){var e,i,a,s,r,o,f,l;for(f=-1,i=0,r=0;r<2;r++)for(e=n.D[r][t],o=0;o<n.e[e];o++)(a=n.i[e][o])!=n.D[1-r][t]&&(s=n.k[e][o],i<(l=qf.ro(n,s,a))&&(i=l,f=s));return f},qf.Yo=function(t,e,i){var a,s,r,o,f,l,d,g,u,c,b,h,D,H,j,m;for(a=t.e[e],s=$l(Qf.Kmb,S,6,a,15,1),b=0;b<a;b++)s[b]=qf.Lk(t,e,t.i[e][b]);for(h=1;h<a;h++)for(D=0;D<h;D++)if((r=n.Math.abs(qf.$m(s[h],s[D])))<.08||r>Qt){for(o=0,f=0,H=0;H<a;H++)H!=h&&H!=D&&(o+=n.Math.abs(Hl.g7(s[h],s[H])),f+=n.Math.abs(Hl.g7(s[D],s[H])));if(d=o<f?t.k[e][h]:t.k[e][D],1==qf.Uk(t,d)&&(!i||257!=t.H[d]&&129!=t.H[d]))return d}for(j=-1,l=0,c=0;c<a;c++)g=t.i[e][c],u=t.k[e][c],l<(m=qf.ro(t,u,g))&&(!i||257!=t.H[u]&&129!=t.H[u])&&(l=m,j=u);return j},qf.Zo=function(n,t){var e,i,a;for(qf.nu(n,t?15:1),n.q=n.f,n.r=n.g,i=0;i<n.f;i++)n.e[i]!=n.j[i]&&(e=qf.Yn(n,i,!1),n.e[i]=n.j[i],-1!=e&&e!=qf.Yn(n,i,!0)&&(-1==(a=((n.u[i]&Mt)>>>27)-1)||a<e)&&qf.Ul(n,i,e));t&&qf.fp(n),n.T=0},qf.$o=function(n,t,e,i){var a,s,r;for(qf.nu(t,1),s=0;s<e;s++)-1!=i[s]&&1!=n.C[s]&&n.e[s]!=qf.vn(t,i[s])&&-1!=(a=qf.Yn(n,s,!1))&&a!=qf.Yn(t,i[s],!1)&&(-1==(r=qf.ok(t,i[s]))||r<a)&&qf.Ul(t,i[s],a)},qf._o=function(t,e,i,a,s){var r,o,f,l,d,g,u,c,b,h,D;for(f=0;f<i;f++)if(-1!=a[f]&&t.e[f]>3&&t.u[f]&Jt){for(D=0,c=-1,u=-1,g=0;g<t.e[f];g++)-1!=s[t.k[f][g]]?++D:1==t.n[f][g]&&qf.Dl(t,t.k[f][g])&&t.D[0][t.k[f][g]]==f&&(c=t.k[f][g],u=t.i[f][g]);if(-1!=c&&D>=3){for(r=qf.Zm(t.J[f].a,t.J[f].b,t.J[u].a,t.J[u].b),b=10,h=-1,d=0;d<t.e[f];d++)1!=t.n[f][d]||qf.Dl(t,t.k[f][d])&&t.D[0][t.k[f][d]]!=f||-1==s[t.k[f][d]]||b>(o=n.Math.abs(qf.$m(r,qf.Lk(t,f,t.i[f][d]))))&&(b=o,h=t.k[f][d]);-1!=h&&(l=s[h],qf.xm(e,l,257==t.H[h]?129:257),t.D[0][h]!=f&&(qf.om(e,1,l,a[t.D[0][h]]),qf.om(e,0,l,a[f])))}}},qf.ap=function(n,t){var e,i,a,s,r,o,f,l,d,g,u,c,b,h,D,H,j,m,A,C;if(2!=n.j[t]||2!=n.n[t][0]||2!=n.n[t][1]||n.j[n.i[t][0]]<2||n.j[n.i[t][1]]<2||1!=n.o[n.i[t][0]]||1!=n.o[n.i[t][1]])qf.fm(n,t,0,!1);else{for(m=-1,j=-1,H=-1,b=-1,s=0,d=0;d<2;d++)for(i=n.i[t][d],c=0;c<n.e[i];c++)(r=n.i[i][c])!=t&&(o=n.k[i][c],s<(A=qf.ro(n,o,r))&&(s=A,j=r,m=o,H=i,b=n.i[t][1-d]));if(-1!=j){for(g=0;g<2;g++)for(i=n.i[t][g],c=0;c<n.e[i];c++)r=n.i[i][c],o=n.k[i][c],r!=t&&n.D[0][o]==i&&(n.H[o]=1);for(n.D[1][m]!=j&&(n.D[0][m]=n.D[1][m],n.D[1][m]=j),f=I,u=0;u<n.j[H];u++)(r=n.i[H][u])!=t&&f>r&&(f=r);for(h=$l(Qf.Mmb,G,6,2,15,1),D=0,l=0;l<n.j[b];l++)(r=n.i[b][l])!=t&&(h[D++]=r);e=qf.Zm(n.J[t].a,n.J[t].b,n.J[b].a,n.J[b].b),a=0,2==D?(h[0]>h[1]&&(C=h[0],h[0]=h[1],h[1]=C),a=qf.$m(e,qf.Lk(n,b,h[0]))-qf.$m(e,qf.Lk(n,b,h[1]))):a=qf.$m(e,qf.Lk(n,b,h[0])),a<0^1==(3&n.u[t])^f==j?n.H[m]=257:n.H[m]=129}}},qf.bp=function(n,t,e,i){var a,s,r,o,f,l;if(a=n.e[t],o=$l(Qf.Mmb,G,6,a,15,1),3==(l=qf.Qn(n,t,e,i,o)))return!1;for(r=(3&n.u[t])==l?257:129,f=0;f<a;f++)1&~o[f]||(s=n.k[t][e[f]],n.H[s]=r,n.D[0][s]!=t&&(n.D[1][s]=n.D[0][s],n.D[0][s]=t));return!0},qf.cp=function(n,t){n.T|=248&t|8},qf.dp=function(n,t){var e,i,a,s,r,o,f,l,d,g,u,c,b,h,D;if(qf.ln(n,t),3&n.u[t]&&3&~n.u[t])if(2!=n.o[t]||2!=n.j[t])if(n.j[t]<3||n.j[t]>4)qf.fm(n,t,0,!1);else{for(e=n.e[t],b=!1,r=0;r<e;r++)if(1==qf.Uk(n,n.k[t][r])){b=!0;break}if(b){for(h=qf.po(n,t),i=$l(Qf.Kmb,S,6,e,15,1),o=0;o<e;o++)i[o]=qf.Lk(n,n.i[t][h[o]],t);for(f=0;f<e;f++)n.D[0][n.k[t][f]]==t&&1==qf.Uk(n,n.k[t][f])&&(n.H[n.k[t][f]]=1);if(!((n.p&&t<n.f?qf.Dr(n.p,t):0)<=24&&qf.bp(n,t,h,i))&&-1!=(u=qf.Yo(n,t,!0))){for(n.D[0][u]!=t&&(n.D[1][u]=n.D[0][u],n.D[0][u]=t),c=-1,l=0;l<e;l++)if(u==n.k[t][h[l]]){c=l;break}for(D=ed(Wl(Qf.Mmb,2),ft,8,0,[ed(Wl(Qf.Mmb,1),G,6,15,[2,1,2,1]),ed(Wl(Qf.Mmb,1),G,6,15,[1,2,2,1]),ed(Wl(Qf.Mmb,1),G,6,15,[1,1,2,2]),ed(Wl(Qf.Mmb,1),G,6,15,[2,1,1,2]),ed(Wl(Qf.Mmb,1),G,6,15,[2,2,1,1]),ed(Wl(Qf.Mmb,1),G,6,15,[1,2,1,2])]),s=1;s<e;s++)i[s]<i[0]&&(i[s]+=rn);if(3==e){switch(d=!1,c){case 0:d=i[1]<i[2]&&i[2]-i[1]<on||i[1]>i[2]&&i[1]-i[2]>on;break;case 1:d=i[2]-i[0]>on;break;case 2:d=i[1]-i[0]<on}a=1==(3&n.u[t])^d?257:129}else g=0,i[1]<=i[2]&&i[2]<=i[3]?g=0:i[1]<=i[3]&&i[3]<=i[2]?g=1:i[2]<=i[1]&&i[1]<=i[3]?g=2:i[2]<=i[3]&&i[3]<=i[1]?g=3:i[3]<=i[1]&&i[1]<=i[2]?g=4:i[3]<=i[2]&&i[2]<=i[1]&&(g=5),a=1==(3&n.u[t])^1==D[g][c]?129:257;n.H[u]=a}}}else qf.ap(n,t)},qf.ep=function(n,t){var e,i,a,s,r,o,f,l,d,g,u,c,b,h,D,H,j,m,A,C;if(3&n.F[t]&&3&~n.F[t]&&qf.Do(n,t)){for(m=-1,H=-1,j=-1,D=-1,a=0,d=0;d<2;d++)for(i=n.D[d][t],c=0;c<n.e[i];c++)(o=n.k[i][c])!=t&&1==qf.Uk(n,o)&&(r=n.i[i][c],a<(A=qf.ro(n,o,r))&&(a=A,H=r,m=o,j=i,D=n.D[1-d][t]));if(-1!=H){for(g=0;g<2;g++)for(c=0;c<n.e[n.D[g][t]];c++)(o=n.k[n.D[g][t]][c])!=t&&1==qf.Uk(n,o)&&(n.H[o]=1);for(n.D[1][m]!=H&&(n.D[0][m]=n.D[1][m],n.D[1][m]=H),f=I,u=0;u<n.j[j];u++)r=n.i[j][u],n.k[j][u]!=t&&f>r&&(f=r);for(b=$l(Qf.Mmb,G,6,2,15,1),h=0,l=0;l<n.j[D];l++)n.k[D][l]!=t&&(b[h++]=n.i[D][l]);s=qf.Zm(n.J[j].a,n.J[j].b,n.J[D].a,n.J[D].b),e=0,2==h?(b[0]>b[1]&&(C=b[0],b[0]=b[1],b[1]=C),e=qf.$m(s,qf.Lk(n,D,b[0]))-qf.$m(s,qf.Lk(n,D,b[1]))):e=qf.$m(s,qf.Lk(n,D,b[0])),e<0^2==(3&n.F[t])^f==H?n.H[m]=257:n.H[m]=129}}},qf.fp=function(n){var t,e,i,a;for(qf.nu(n,7),i=0;i<n.g;i++)(257==n.H[i]||129==n.H[i])&&(n.H[i]=1);for(t=0;t<n.f;t++)qf.dp(n,t);for(a=0;a<n.g;a++)qf.ep(n,a);for(e=0;e<n.g;e++)2==n.H[e]&&!(3&~n.F[e])&&(n.H[e]=386)},qf.gp=function(n,t){var e,i,a,s,r,o,f,l,d,g;if(o=$l(Qf.Mmb,G,6,n.q,15,1),(r=qf.Tn(n,o,!1,t))<=1)return null;for(f=$l(Qf.Mmb,G,6,r,15,1),i=0;i<n.f;i++)++f[o[i]];for(d=0,g=f[0],l=1;l<r;l++)g<f[l]&&(g=f[l],d=l);for(e=0;e<n.q;e++)o[e]!=d&&(n.C[e]=-1);for(s=0;s<n.r;s++)(!t&&32==n.H[s]||o[n.D[0][s]]!=d)&&(n.H[s]=512);a=qf._j(n),n.T=0;try{qf.jn(n,!0,!0)}catch(n){if(!sd(n=cd(n),18))throw bd(n)}return a},qf.hp=function(n,t){return!!(n.u[t]&Mt)||1!=n.C[t]&&(qf.zl(n,t)||13==n.C[t]||n.C[t]>=171)},qf.ip=function(n){var t,e,i,a,s,r,o,f,l,d;for(r=(s=qf.Jk(n,n.q,n.r,qf.Ij))*s/16,i=1;i<n.q;i++)for(a=0;a<i;a++)if((f=n.J[a].a-n.J[i].a)*f+(l=n.J[a].b-n.J[i].b)*l+(d=n.J[a].c-n.J[i].c)*d<r)throw bd(new zf.aA("The distance between two atoms is too close."));for(qf.nu(n,1),t=0,e=0;e<n.f;e++){if(qf.eo(n,e)>(o=qf.cl(n,e))+qf.al(n,e,o,n.C[e]))throw bd(new zf.aA("atom valence exceeded"));t+=n.s[e]}if(0!=t)throw bd(new zf.aA("unbalanced atom charge"))},qf.jp=function(n){var t,e;if(n.K)for(qf.nu(n,7),t=0;t<n.f;t++)n.u[t]&xt&&(Ld(wd(n.B[t],120),8)&&(n.B[t]=wd(n.B[t],-9)),n.B[t]=wd(n.B[t],-4294967297)),t<n.f&&qf.Or(n.p,t)?n.B[t]=wd(n.B[t],{l:4194297,m:kt,h:1048571}):Sd(wd(n.B[t],2),0)&&(n.B[t]=wd(n.B[t],-5)),(Sd(wd(n.B[t],zn),0)||Sd(wd(n.B[t],v),0)&&Ld(wd(n.B[t],Z),0))&&Ld(wd(n.B[t],120),8)&&(n.B[t]=wd(n.B[t],-9)),0!=n.s[t]&&(n.B[t]=wd(n.B[t],-234881025)),qf.eo(n,t)==(e=qf.cl(n,t))+qf.al(n,t,e,n.C[t])&&(n.B[t]=wd(n.B[t],-4063233),n.B[t]=wd(n.B[t],-0xf8000000001),n.B[t]=wd(n.B[t],-1921),n.B[t]=wd(n.B[t],-114689))},qf.kp=function(n){var t,e;if(n.K)for(qf.nu(n,7),t=0;t<n.g;t++)t<n.g&&(qf.Tr(n.p,t)||64==n.H[t])&&(n.G[t]&=-9),1==(e=127&n.H[t])?n.G[t]&=-2:2==e?n.G[t]&=-3:4==e?n.G[t]&=-5:8==e?n.G[t]&=-33:16==e?n.G[t]&=-65:32==e?n.G[t]&=-17:64==e&&(n.G[t]&=-9)},qf.lp=function(n,t,e){var i;return(i=qf.Nm(n,t,e))&&386==e&&(qf.nu(n,7),i&=!(128&n.F[t])),i},qf.mp=function(){qf.Qm.call(this)},qf.np=function(n,t){qf.Rm.call(this,n,t)},qf.op=function(n){qf.Rm.call(this,n?n.M:256,n?n.N:256),n&&qf.dk(n,this)},Ol(98,115,{98:1,115:1,4:1}),o.Mb=function(n){qf.on(this,n)},o.Lb=function(n){return qf.Go(this,n)},o.f=0,o.g=0,Qf.inb=hd(98),qf.rp=function(t,e){return n.Math.pow(10,n.Math.log(2e3)*n.Math.LOG10E*t/(e-1)-1)},qf.sp=function(n,t){var e,i;for(e=t,i=0;0!=t;)0==n.d&&(n.f=(63&n.c[++n.e])<<11,n.d=6),i|=(y&n.f)>>16-e+t,n.f<<=1,--t,--n.d;return i},qf.tp=function(n,t,e){n.d=6,n.e=e,n.c=t,n.f=(63&t[n.e])<<11},qf.up=function(n,t){var e,i,a;return(a=n>=(i=t/2|0))&&(n-=i),e=(t/32|0)*n/(i-n),a?-e:e},qf.vp=function(n,t){var e;return null==t||0==Gf.zVb(t).length?null:qf.xp(n,Gf.aVb((e=t,Fl.CMb(),e)),null)},qf.wp=function(n,t,e){var i;return null==t?null:qf.xp(n,Gf.aVb((i=t,Fl.CMb(),i)),null==e?null:Gf.aVb(e))},qf.xp=function(n,t,e){var i,a,s,r,o;return qf.tp(n,t,0),i=qf.sp(n,4),r=qf.sp(n,4),i>8&&(i=r),a=qf.sp(n,i),s=qf.sp(n,r),o=new qf.Gu(a,s),qf.Bp(n,o,t,e,0),o},qf.yp=function(n,t,e){var i,a,s;null!=e&&0!=Gf.zVb(e).length?(i=zf.tJb(e,pd(32)))>0&&i<Gf.zVb(e).length-1?qf.Ap(n,t,Gf.aVb((Gf.tVb(0,i,Gf.zVb(e).length),s=Gf.zVb(e).substr(0,i),Fl.CMb(),s)),Gf.aVb((Gf.uVb(i+1,Gf.zVb(e).length+1),Gf.zVb(e).substr(i+1)))):qf.Ap(n,t,Gf.aVb((a=e,Fl.CMb(),a)),null):qf.Ap(n,t,null,null)},qf.zp=function(n,t,e,i){var a,s,r,o;s=null==e?null:Gf.aVb((o=e,Fl.CMb(),o)),a=null==i?null:Gf.aVb((r=i,Fl.CMb(),r)),qf.Ap(n,t,s,a)},qf.Ap=function(n,t,e,i){if(null==e||0==e.length)return qf.$j(t),void(t.d=null);qf.Bp(n,t,e,i,0)},qf.Bp=function(t,e,i,a,s){var r,o,f,l,d,g,u,c,b,h,D,H,j,m,A,C,p,M,I,P,T,N,w,U,J,L,y,B,R,k,x,E,F,Q,z,S,X,Y,q,V,v,Z,O,K,W,_,$,nn,an,sn,rn,on,fn,ln,gn,un,bn,hn,Dn,Hn,jn,mn,An,Cn,pn,Mn,In,Pn,Tn,Nn,wn,Un,Jn,Ln,yn,Bn,Rn,kn,xn,En,Fn,Qn,zn,Yn,qn,Vn,vn,Zn,On,Kn,Wn,_n,$n,nt,tt,et,it,at,st,rt,ot,ft,lt,gt,ut,ct,ht,Dt,jt,mt,At,Ct,pt,Mt,It,Pt,Tt,Nt,wt,Ut,Jt,Lt;if(qf.$j(e),e.d=null,!(null==i||0>=i.length))if(t.g=e,Pt=8,null!=a&&(s<0||s>=a.length)&&(a=null),qf.tp(t,i,0),f=qf.sp(t,4),I=qf.sp(t,4),f>8&&(Pt=f,f=I),0!=f){for(l=qf.sp(t,f),d=qf.sp(t,I),gt=qf.sp(t,f),Dt=qf.sp(t,f),ht=qf.sp(t,f),k=qf.sp(t,f),b=0;b<l;b++)qf.Lj(t.g,6);for(on=0;on<gt;on++)qf.nm(t.g,qf.sp(t,f),7);for(fn=0;fn<Dt;fn++)qf.nm(t.g,qf.sp(t,f),8);for(Cn=0;Cn<ht;Cn++)qf.nm(t.g,qf.sp(t,f),qf.sp(t,8));for(yn=0;yn<k;yn++)qf.Wl(t.g,qf.sp(t,f),qf.sp(t,4)-8);for(x=1+d-l,S=qf.sp(t,4),M=0,qf.km(t.g,0,0),qf.lm(t.g,0,0),qf.mm(t.g,0,0),It=0,Nt=0,Ut=0,Lt=0,F=!1,Q=!1,(X=null!=a&&a[s]>=39)&&(a.length>2*l-2&&39==a[2*l-2]||a.length>3*l-3&&39==a[3*l-3]?(Q=!0,p=86*(a[(tt=(F=a.length==3*l-3+9)?3*l-3:2*l-2)+1]-40)+a[tt+2]-40,It=n.Math.pow(10,p/2e3-1),Tt=86*(a[(tt+=2)+1]-40)+a[tt+2]-40,Nt=n.Math.pow(10,Tt/1500-1),wt=86*(a[(tt+=2)+1]-40)+a[tt+2]-40,Ut=n.Math.pow(10,wt/1500-1),F&&(Jt=86*(a[(tt+=2)+1]-40)+a[tt+2]-40,Lt=n.Math.pow(10,Jt/1500-1))):F=a.length==3*l-3),t.Nb()&&F&&(a=null,X=!1),Vn=1;Vn<l;Vn++)0!=(Y=qf.sp(t,S))?(M+=Y-1,X&&(qf.km(t.g,Vn,qf.Ek(t.g,M)+a[2*Vn-2]-83),qf.lm(t.g,Vn,qf.Fk(t.g,M)+a[2*Vn-1]-83),F&&qf.mm(t.g,Vn,qf.Gk(t.g,M)+(a[2*l-3+Vn]-83))),qf.Nj(t.g,M,Vn,1)):(X&&(qf.km(t.g,Vn,qf.Ek(t.g,0)+8*(a[2*Vn-2]-83)),qf.lm(t.g,Vn,qf.Fk(t.g,0)+8*(a[2*Vn-1]-83)),F&&qf.mm(t.g,Vn,qf.Gk(t.g,0)+8*(a[2*l-3+Vn]-83))),++x);for(Kn=0;Kn<x;Kn++)qf.Nj(t.g,qf.sp(t,f),qf.sp(t,f),1);for(et=$l(Qf.nyb,tn,6,d,16,1),J=0;J<d;J++)switch(qf.sp(t,2)){case 0:et[J]=!0;break;case 2:qf.xm(t.g,J,2);break;case 3:qf.xm(t.g,J,4)}for(o=qf.sp(t,f),Wn=0;Wn<o;Wn++)if(c=qf.sp(t,f),8==Pt)3==(jt=qf.sp(t,2))?(qf._l(t.g,c,1,0),qf.fm(t.g,c,1,!1)):qf.fm(t.g,c,jt,!1);else switch(jt=qf.sp(t,3)){case 4:qf.fm(t.g,c,1,!1),qf._l(t.g,c,1,qf.sp(t,3));break;case 5:qf.fm(t.g,c,2,!1),qf._l(t.g,c,1,qf.sp(t,3));break;case 6:qf.fm(t.g,c,1,!1),qf._l(t.g,c,2,qf.sp(t,3));break;case 7:qf.fm(t.g,c,2,!1),qf._l(t.g,c,2,qf.sp(t,3));break;default:qf.fm(t.g,c,jt,!1)}for(8==Pt&&0==qf.sp(t,1)&&(t.g.L=!0),r=qf.sp(t,I),_n=0;_n<r;_n++)if(T=qf.sp(t,I),1==qf.Xk(t.g,T))switch(jt=qf.sp(t,3)){case 4:qf.um(t.g,T,1,!1),qf.rm(t.g,T,1,qf.sp(t,3));break;case 5:qf.um(t.g,T,2,!1),qf.rm(t.g,T,1,qf.sp(t,3));break;case 6:qf.um(t.g,T,1,!1),qf.rm(t.g,T,2,qf.sp(t,3));break;case 7:qf.um(t.g,T,2,!1),qf.rm(t.g,T,2,qf.sp(t,3));break;default:qf.um(t.g,T,jt,!1)}else qf.um(t.g,T,qf.sp(t,2),!1);for(qf.zm(t.g,1==qf.sp(t,1)),u=null,ct=0;1==qf.sp(t,1);)switch(ct+qf.sp(t,4)){case 0:for(ut=qf.sp(t,f),$n=0;$n<ut;$n++)c=qf.sp(t,f),qf.gm(t.g,c,Gn,!0);break;case 1:for(ut=qf.sp(t,f),nt=0;nt<ut;nt++)c=qf.sp(t,f),ft=qf.sp(t,8),qf.em(t.g,c,ft);break;case 2:for(ut=qf.sp(t,I),ln=0;ln<ut;ln++)qf.sp(t,I);break;case 3:for(ut=qf.sp(t,f),gn=0;gn<ut;gn++)c=qf.sp(t,f),qf.gm(t.g,c,dn,!0);break;case 4:for(ut=qf.sp(t,f),un=0;un<ut;un++)c=qf.sp(t,f),pt=Yd(Bd(qf.sp(t,4)),3),qf.gm(t.g,c,pt,!0);break;case 5:for(ut=qf.sp(t,f),bn=0;bn<ut;bn++)c=qf.sp(t,f),g=Yd(Bd(qf.sp(t,2)),1),qf.gm(t.g,c,g,!0);break;case 6:for(ut=qf.sp(t,f),hn=0;hn<ut;hn++)c=qf.sp(t,f),qf.gm(t.g,c,1,!0);break;case 7:for(ut=qf.sp(t,f),Dn=0;Dn<ut;Dn++)c=qf.sp(t,f),an=Yd(Bd(qf.sp(t,4)),7),qf.gm(t.g,c,an,!0);break;case 8:for(ut=qf.sp(t,f),Hn=0;Hn<ut;Hn++){for(c=qf.sp(t,f),m=qf.sp(t,4),H=$l(Qf.Mmb,G,6,m,15,1),it=0;it<m;it++)j=qf.sp(t,8),H[it]=j;qf.am(t.g,c,H)}break;case 9:for(ut=qf.sp(t,I),jn=0;jn<ut;jn++)T=qf.sp(t,I),pt=qf.sp(t,2)<<7,qf.wm(t.g,T,pt,!0);break;case 10:for(ut=qf.sp(t,I),mn=0;mn<ut;mn++)T=qf.sp(t,I),y=qf.sp(t,5),qf.wm(t.g,T,y,!0);break;case 11:for(ut=qf.sp(t,f),An=0;An<ut;An++)c=qf.sp(t,f),qf.gm(t.g,c,Xn,!0);break;case 12:for(ut=qf.sp(t,I),pn=0;pn<ut;pn++)T=qf.sp(t,I),B=qf.sp(t,8)<<9,qf.wm(t.g,T,B,!0);break;case 13:for(ut=qf.sp(t,f),Mn=0;Mn<ut;Mn++)c=qf.sp(t,f),mt=Yd(Bd(qf.sp(t,3)),14),qf.gm(t.g,c,mt,!0);break;case 14:for(ut=qf.sp(t,f),In=0;In<ut;In++)c=qf.sp(t,f),lt=Yd(Bd(qf.sp(t,5)),17),qf.gm(t.g,c,lt,!0);break;case 15:case 31:ct+=16;break;case 16:for(ut=qf.sp(t,f),Pn=0;Pn<ut;Pn++)c=qf.sp(t,f),Ct=Yd(Bd(qf.sp(t,3)),22),qf.gm(t.g,c,Ct,!0);break;case 17:for(ut=qf.sp(t,f),Tn=0;Tn<ut;Tn++)c=qf.sp(t,f),qf.Ul(t.g,c,qf.sp(t,4));break;case 18:for(ut=qf.sp(t,f),ot=qf.sp(t,4),Nn=0;Nn<ut;Nn++){for(c=qf.sp(t,f),z=qf.sp(t,ot),at=$l(Qf.Imb,dt,6,z,15,1),it=0;it<z;it++)at[it]=qf.sp(t,7)<<24>>24;qf.Zl(t.g,c,zf.nJb((st=at,Fl.CMb(),st)))}break;case 19:for(ut=qf.sp(t,f),wn=0;wn<ut;wn++)c=qf.sp(t,f),R=Yd(Bd(qf.sp(t,3)),25),qf.gm(t.g,c,R,!0);break;case 20:for(ut=qf.sp(t,I),Un=0;Un<ut;Un++)T=qf.sp(t,I),Ct=qf.sp(t,3)<<17,qf.wm(t.g,T,Ct,!0);break;case 21:for(ut=qf.sp(t,f),Jn=0;Jn<ut;Jn++)c=qf.sp(t,f),qf.hm(t.g,c,qf.sp(t,2)<<4);break;case 22:for(ut=qf.sp(t,f),Ln=0;Ln<ut;Ln++)c=qf.sp(t,f),qf.gm(t.g,c,Sn,!0);break;case 23:for(ut=qf.sp(t,I),Bn=0;Bn<ut;Bn++)T=qf.sp(t,I),qf.wm(t.g,T,bt,!0);break;case 24:for(ut=qf.sp(t,I),Rn=0;Rn<ut;Rn++)T=qf.sp(t,I),g=qf.sp(t,2)<<21,qf.wm(t.g,T,g,!0);break;case 25:for(kn=0;kn<l;kn++)1==qf.sp(t,1)&&qf.im(t.g,kn,!0);break;case 26:for(ut=qf.sp(t,I),u=$l(Qf.Mmb,G,6,ut,15,1),xn=0;xn<ut;xn++)u[xn]=qf.sp(t,I);break;case 27:for(ut=qf.sp(t,f),En=0;En<ut;En++)c=qf.sp(t,f),qf.gm(t.g,c,en,!0);break;case 28:for(ut=qf.sp(t,I),Fn=0;Fn<ut;Fn++)qf.xm(t.g,qf.sp(t,I),32);break;case 29:for(ut=qf.sp(t,f),Qn=0;Qn<ut;Qn++)c=qf.sp(t,f),nn=Yd(Bd(qf.sp(t,2)),30),qf.gm(t.g,c,nn,!0);break;case 30:for(ut=qf.sp(t,f),zn=0;zn<ut;zn++)c=qf.sp(t,f),Ct=Yd(Bd(qf.sp(t,7)),32),qf.gm(t.g,c,Ct,!0);break;case 32:for(ut=qf.sp(t,f),Yn=0;Yn<ut;Yn++)c=qf.sp(t,f),Mt=Yd(Bd(qf.sp(t,2)),44),qf.gm(t.g,c,Mt,!0);break;case 33:for(ut=qf.sp(t,f),qn=0;qn<ut;qn++)c=qf.sp(t,f),O=Yd(Bd(qf.sp(t,5)),39),qf.gm(t.g,c,O,!0);break;case 34:for(ut=qf.sp(t,f),vn=0;vn<ut;vn++)c=qf.sp(t,f),qf.gm(t.g,c,cn,!0);break;case 35:for(ut=qf.sp(t,I),Zn=0;Zn<ut;Zn++)T=qf.sp(t,I),qf.wm(t.g,T,Ht,!0);break;case 36:for(ut=qf.sp(t,I),On=0;On<ut;On++)T=qf.sp(t,I),L=qf.sp(t,2)<<5,qf.wm(t.g,T,L,!0);break;case 37:for(ut=qf.sp(t,I),rn=0;rn<ut;rn++)T=qf.sp(t,I),L=0==qf.sp(t,1)?8:16,qf.xm(t.g,T,L)}if(qf.ie(new qf.se(t.g),et,!1),null!=u)for(w=0,U=(N=u).length;w<U;++w)T=N[w],qf.xm(t.g,T,2==qf.Xk(t.g,T)?4:2);if(null==a&&!t.i&&i.length>t.e+1&&(32==i[t.e+1]||9==i[t.e+1])&&(a=i,s=t.e+2),null!=a)try{if(33==a[s]||35==a[s]){for(qf.tp(t,a,s+1),F=1==qf.sp(t,1),Q=1==qf.sp(t,1),P=1<<(At=2*qf.sp(t,4)),_=0,T=0,h=1;h<l;h++)T<d&&qf.Mk(t.g,1,T)==h?(_=qf.Mk(t.g,0,T++),W=1):(_=0,W=8),qf.km(t.g,h,qf.Ek(t.g,_)+W*(qf.sp(t,At)-(P/2|0))),qf.lm(t.g,h,qf.Fk(t.g,_)+W*(qf.sp(t,At)-(P/2|0))),F&&qf.mm(t.g,h,qf.Gk(t.g,_)+W*(qf.sp(t,At)-(P/2|0)));if(35==a[s]){for(sn=0,$=$l(Qf.Mmb,G,6,l,15,1),D=0;D<l;D++)sn+=$[D]=qf.Zn(t.g,D);for(c=0;c<l;c++)for(rn=0;rn<$[c];rn++)an=qf.Lj(t.g,1),qf.Nj(t.g,c,an,1),qf.km(t.g,an,qf.Ek(t.g,c)+(qf.sp(t,At)-(P/2|0))),qf.lm(t.g,an,qf.Fk(t.g,c)+(qf.sp(t,At)-(P/2|0))),F&&qf.mm(t.g,an,qf.Gk(t.g,c)+(qf.sp(t,At)-(P/2|0)));l+=sn,d+=sn}if(C=F?1.5:(qf.Jj(),qf.Jj(),qf.Ij),A=qf.Jk(t.g,l,d,C),Q)for(Nt=(It=qf.rp(qf.sp(t,At),P))*qf.up(qf.sp(t,At),P),Ut=It*qf.up(qf.sp(t,At),P),F&&(Lt=It*qf.up(qf.sp(t,At),P)),W=It/A,c=0;c<l;c++)qf.km(t.g,c,Nt+W*qf.Ek(t.g,c)),qf.lm(t.g,c,Ut+W*qf.Fk(t.g,c)),F&&qf.mm(t.g,c,Lt+W*qf.Gk(t.g,c));else for(W=(It=1.5)/A,c=0;c<l;c++)qf.km(t.g,c,W*qf.Ek(t.g,c)),qf.lm(t.g,c,W*qf.Fk(t.g,c)),F&&qf.mm(t.g,c,W*qf.Gk(t.g,c))}else if(F&&!Q&&0==It&&(It=1.5),0!=It&&0!=t.g.r){for(A=0,T=0;T<t.g.r;T++)q=qf.Ek(t.g,qf.Mk(t.g,0,T))-qf.Ek(t.g,qf.Mk(t.g,1,T)),V=qf.Fk(t.g,qf.Mk(t.g,0,T))-qf.Fk(t.g,qf.Mk(t.g,1,T)),v=F?qf.Gk(t.g,qf.Mk(t.g,0,T))-qf.Gk(t.g,qf.Mk(t.g,1,T)):0,A+=n.Math.sqrt(q*q+V*V+v*v);for(K=It/(A/=t.g.r),c=0;c<t.g.q;c++)qf.km(t.g,c,qf.Ek(t.g,c)*K+Nt),qf.lm(t.g,c,qf.Fk(t.g,c)*K+Ut),F&&qf.mm(t.g,c,qf.Gk(t.g,c)*K+Lt)}}catch(n){if(!sd(n=cd(n),18))throw bd(n);Z=n,zf.Jz(Z,(zf.aKb(),zf._Jb),""),zf.nJb((rt=i,Fl.CMb(),rt)),zf.nJb(st=a),a=null,F=!1}if((E=null!=a&&!F)||t.Nb())for(qf.nu(t.g,7),T=0;T<t.g.g;T++)2==qf.Uk(t.g,T)&&!qf.So(t.g,T)&&0==qf.Vk(t.g,T)&&qf.vm(t.g,T);if(qf.cp(t.g,0),!E&&t.Nb())try{t.Ob(t.g),E=!0}catch(n){if(!sd(n=cd(n),18))throw bd(n);Z=n,zf.Jz(Z,(zf.aKb(),zf._Jb),""),zf.nJb((st=i,Fl.CMb(),st))}E?(qf.fp(t.g),qf.Au(t.g)):F||qf.cp(t.g,0)}else qf.zm(t.g,1==qf.sp(t,1))},qf.Cp=function(n,t){var e,i,a,s,r,o;if(!(t.length<=0||t[0]<64))for(qf.tp(n,t,0),o=qf.sp(n,4),a=1==qf.sp(n,1),s=1==qf.sp(n,1),e=0;e<n.g.f;e++)r=qf.sp(n,o),i=a,a&&s&&(i=1==qf.sp(n,1)),qf.cm(n.g,e,r,i)},qf.Dp=function(){},Ol(403,1,{},qf.Dp),o.Nb=function(){return!1},o.Ob=function(n){throw bd(new zf.aA("Unexpected request to invent coordinates. Check source code logic!"))},o.d=0,o.e=0,o.f=0,o.i=!1,Qf.jnb=hd(403),qf.Gp=function(n){},qf.Hp=function(){qf.Ip.call(this,!0)},qf.Ip=function(n){qf.Gp(this),this.b=n},Ol(51,403,{},qf.Hp,qf.Ip),o.Nb=function(){return this.b},o.Ob=function(n){var t;(t=new Of.yy(this.a)).g=new Vf.JSb(78187493520),Of.fy(t,n)},o.a=2,o.b=!1,Qf.knb=hd(51),qf.Lp=function(t,e,i,a){var s,r,o,f,l,d,g,u,c,b,h,D,H,j;s=e.a,b=e.g,d=Sd(wd(qf.Ck(t.k,s),1),0),u=null!=(r=qf.xk(t.k,s))?qf.Sp(t,s,r,a):d?"*":qf.wk(t.k,s),!d&&null==r&&qf.Bo(t.k,s)&&!(4&t.j)&&(0!=qf.An(t.k,s)||-1==qf.ok(t.k,s)&&0==qf.Dk(t.k,s))&&(u=Gf.zVb(u).toLowerCase()),e.f&&(i.a+="("),-1!=b&&qf.Pp(t,qf.Hn(t.k,e.a,e.g),e.g,i),0==(o=qf.qk(t.k,s))&&1&t.j&&(0==Ud(f=wd(qf.Ck(t.k,s),Dn),mn)?o=-1:0==Ud(f,jn)&&(o=1)),g=qf.Ak(t.k,s),c=2&t.j?qf.zk(t.k,s):0,h=1&t.j?qf.Yp(t,s,a):null,(j=!d&&!qf.dq(qf.Hk(t.k,s))||null!=r||(1==qf.Bk(t.k,s)||2==qf.Bk(t.k,s))&&!(-1!=(H=qf.vk(t.k,s)-1)&&t.i[H][qf.uk(t.k,s)]<=1)&&(7!=qf.Hk(t.k,s)||qf.qk(t.k,s)>0)||qf.Bo(t.k,s)&&0==qf.An(t.k,s)&&!(4&t.j)||0!=o||0!=g||0!=c||-1!=qf.ok(t.k,s)||0!=qf.Dk(t.k,s)||null!=h)&&(i.a+="["),0!=g&&(i.a+=g),i.a+=""+u,(1==qf.Bk(t.k,s)||2==qf.Bk(t.k,s))&&!(-1!=(D=qf.vk(t.k,s)-1)&&t.i[D][qf.uk(t.k,s)]<=1)&&(7!=qf.Hk(t.k,s)||qf.qk(t.k,s)>0)&&zf.UJb(i,qf.Xp(t,s,b)),1&t.j||!j||(1==(l=qf.ko(t.k,s))?i.a+="H":l>1&&(i.a+="H"+l)),0!=o&&(i.a+=String.fromCharCode(o>0?43:45),n.Math.abs(o)>1&&zf.RJb(i,n.Math.abs(o))),null!=h&&(i.a+=""+h),0!=c&&(i.a+=":",i.a+=c),j&&(i.a+="]"),qf.Qp(t,e,i),e.e&&(i.a+=")")},qf.Mp=function(n,t,e){var i,a,s,r,o;for(s=!0,o=Vf.Oi(n.g,t).a,r=qf._p(n,o);-1!=r;)i=qf.Jn(n.k,o,r),a=qf.Ln(n.k,o,r),r=qf._p(n,i),qf.Op(n,new qf.wt(i,a,o,e&&s,e&&-1==r),++t),o=i,s=!1},qf.Np=function(n,t,e){var i,a,s,r;for(s=0,r=(a=t).length;s<r;++s)i=a[s],n.f[1073741823&i]=!!(i&zt)^e?2:1},qf.Op=function(n,t,e){Vf.Ii(n.g,e,t),n.b[t.a]=!0,-1!=t.g&&(n.c[qf.Hn(n.k,t.a,t.g)]=!0)},qf.Pp=function(n,t,e,i){var a,s,r,o,f;f=Gf.zVb(i.a).length,0!=n.f[t]&&zf.QJb(i,1==n.f[t]?47:92),1==n.j&&0!=(s=qf.Wk(n.k,127))&&(1&s&&0==n.f[t]&&(i.a+="-"),2&s&&(Gf.zVb(i.a).length!=f&&(i.a+=","),i.a+="="),4&s&&(Gf.zVb(i.a).length!=f&&(i.a+=","),i.a+="#"),8&s&&(Gf.zVb(i.a).length!=f&&(i.a+=","),i.a+="$"),16&s&&(Gf.zVb(i.a).length!=f&&(i.a+=","),i.a+="$"),64&s&&(Gf.zVb(i.a).length!=f&&(i.a+=","),i.a+=":"),32&s&&(Gf.zVb(i.a).length!=f&&(i.a+=","),zf.UJb(i,qf.xl(n.k,e)?"<-":"->"))),f==Gf.zVb(i.a).length&&(!qf.Co(n.k,t)||4&n.j)&&(1==(a=127&qf.Xk(n.k,t))?qf.Bo(n.k,qf.Mk(n.k,0,t))&&qf.Bo(n.k,qf.Mk(n.k,1,t))&&!(4&n.j)&&0==n.f[t]&&(i.a+="-"):2==a?i.a+="=":4==a?i.a+="#":8==a||16==a?i.a+="$":64==a?i.a+=":":32==a&&zf.UJb(i,qf.xl(n.k,e)?"<-":"->")),1==n.j&&(r=f==Gf.zVb(i.a).length?"":";",256==(o=384&qf.Wk(n.k,t))?i.a+=r+"@":128==o&&(i.a+=r+"!@"))},qf.Qp=function(n,t,e){var i,a,s;if(null!=t.c)for(a=0;a<t.c.length;a++)for(s=0;s<qf.Kn(n.k,t.a);s++)t.c[a]==qf.Jn(n.k,t.a,s)&&(i=qf.Ln(n.k,t.a,s),t.d[a]||qf.Pp(n,i,t.a,e),n.e[i]>9&&(e.a+="%"),zf.RJb(e,n.e[i]))},qf.Rp=function(n){var t,e,i,a,s,r,o,f,l,d,g,u,c,b,h,D,H,j,m,A,C,p,M,P,T,N,w,U,J,L,y,B,R,k,x,E;for(k=new Vf.bj,H=new Vf.eQb(n.g);H.a<H.c.a.length;)if(-1!=(D=Vf.dQb(H)).g&&(m=qf.Hn(n.k,D.a,D.g),!(qf.Do(n.k,m)||qf.So(n.k,m)||1!=qf.Vk(n.k,m)&&2!=qf.Vk(n.k,m)))){if(B=Vf.Oi(n.g,n.q[D.g]),e=$l(Qf.Mmb,G,6,qf.Kn(n.k,D.a)+qf.Kn(n.k,B.a)-2,15,1),P=0,R=!1,-1!=B.g)e[P++]=B.b;else{for(A=-1,x=-1,C=I,N=0;N<qf.Kn(n.k,B.a);N++)(g=qf.Jn(n.k,B.a,N))!=D.a&&(-1==A?(A=N,C=n.q[g]):C<n.q[g]?x=N:(x=A,A=N));-1==x?(J=qf.Jn(n.k,B.a,A),L=qf.Ln(n.k,B.a,A),e[P++]=L|(qf.bq(n,B.a,J)?zt:0)):(u=qf.Jn(n.k,B.a,A),b=qf.Ln(n.k,B.a,A),c=qf.Jn(n.k,B.a,x),h=qf.Ln(n.k,B.a,x),e[P++]=b|(qf.bq(n,B.a,u)?zt:0),e[P++]=h|(qf.bq(n,B.a,c)?0:zt))}if(3==qf.Kn(n.k,B.a)&&-1!=B.g)for(N=0;N<qf.Kn(n.k,B.a);N++)if((g=qf.Jn(n.k,B.a,N))!=B.g&&g!=D.a){i=qf.Ln(n.k,B.a,N),e[P++]=i|(qf.bq(n,B.a,g)?zt:0),g<B.g&&(R=!R);break}for(2==qf.Vk(n.k,m)&&(R=!R),T=0;T<qf.Kn(n.k,D.a);T++)if((f=qf.Jn(n.k,D.a,T))!=D.g){if(M=R,3==qf.Kn(n.k,D.a))for(U=0;U<qf.Kn(n.k,D.a);U++)if((g=qf.Jn(n.k,D.a,U))!=D.g&&g!=f){g<f&&(M=!M);break}qf.sl(n.k,m)&&(p=qf.Of(n.d,m),n.n[p]||(n.n[p]=!0,n.o[p]=M),n.o[p]&&(M=!M)),l=qf.Hn(n.k,D.a,f),e[P++]=l|(M^qf.bq(n,D.a,f)?0:zt)}Gf.SUb(k.a,e)}for(n.f=$l(Qf.Mmb,G,6,n.k.g,15,1),0!=k.a.length&&qf.Np(n,Vf.Vi(k,0),!1);0!=k.a.length;){for(E=k.a.length,T=k.a.length-1;T>=0;T--){for(Gf.nVb(T,k.a.length),y=0,w=!1,d=!1,r=0,o=(s=e=k.a[T]).length;r<o;++r)t=1073741823&(a=s[r]),0!=n.f[t]&&(j=!!(a&zt)^2==n.f[t],0==y?w=j:w!=j&&(d=!0),++y);0!=y&&(e=Vf.Vi(k,T),d||qf.Np(n,e,w))}E==k.a.length&&qf.Np(n,Vf.Vi(k,0),!1)}},qf.Sp=function(n,t,e,i){var a,s,r,o,f,l,d;for(0<(d=Gf.zVb(i.a).length)?i.a=zf.DJb(i.a,0,0):0>d&&(i.a+=zf.IJb($l(Qf.Jmb,st,6,-d,15,1))),f=qf.Bo(n.k,t)&&!(4&n.j),r=0,o=(s=e).length;r<o;++r)a=s[r],0!=Gf.zVb(i.a).length&&(i.a+=","),l=(qf.Jj(),qf.Dj)[a],zf.UJb(i,f?Gf.zVb(l).toLowerCase():l);return i.a},qf.Tp=function(n){var t,e,i,a,s,r,o,f;if(!n.k||0==n.k.q)return"";for(qf.nu(n.k,15),n.d=new qf.hg(n.k,129),a=n.d.R,n.o=$l(Qf.nyb,tn,6,a+1,16,1),n.n=$l(Qf.nyb,tn,6,a+1,16,1),n.i=_l(Qf.Mmb,[ft,G],[8,6],15,[2,32],2),t=0;t<n.k.f;t++)-1!=(f=qf.vk(n.k,t)-1)&&++n.i[f][qf.uk(n.k,t)];for(qf.Wp(n),qf.Up(n),qf.Rp(n),i=new zf.XJb,e=new zf.XJb,s=!0,o=new Vf.eQb(n.g);o.a<o.c.a.length;)-1==(r=Vf.dQb(o)).g&&(s?s=!1:i.a+="."),qf.Lp(n,r,i,e);return i.a},qf.Up=function(n){var t,e,i,a,s,r,o,f,l,d,g;for(g=new Vf.eQb(n.g);g.a<g.c.a.length;){for(l=Vf.dQb(g),e=0,s=0;s<qf.Kn(n.k,l.a);s++)n.c[qf.Ln(n.k,l.a,s)]||++e;if(0!=e){for(l.c=$l(Qf.Mmb,G,6,e,15,1),e=0,r=0;r<qf.Kn(n.k,l.a);r++)n.c[qf.Ln(n.k,l.a,r)]||(f=qf.Jn(n.k,l.a,r),l.c[e++]=n.q[f]<<16|f);for(Gf.VUb(l.c,Gf.zVb(Vl(Vf.NQb.prototype.$d,Vf.NQb,[]))),a=0;a<l.c.length;a++)l.c[a]=B&l.c[a]}}for(i=$l(Qf.nyb,tn,6,n.k.g,16,1),n.e=$l(Qf.Mmb,G,6,n.k.g,15,1),d=new Vf.eQb(n.g);d.a<d.c.a.length;)if(null!=(l=Vf.dQb(d)).c)for(l.d=$l(Qf.nyb,tn,6,l.c.length,16,1),a=0;a<l.c.length;a++)for(o=0;o<qf.Kn(n.k,l.a);o++)if(l.c[a]==qf.Jn(n.k,l.a,o))if(t=qf.Ln(n.k,l.a,o),n.c[t])i[n.e[t]]=!1;else{for(n.c[t]=!0,l.d[a]=!0,n.e[t]=1;i[n.e[t]];)++n.e[t];i[n.e[t]]=!0}},qf.Vp=function(n){var t,e,i,a;for(i=-1,a=I,t=0;t<n.k.f;t++)n.b[t]||(e=n.a[t],Sd(wd(qf.Ck(n.k,t),en),0)&&(e+=zt),0==qf.Kn(n.k,t)?e+=1056964608:e+=qf.Kn(n.k,t)<<24,a>e&&(a=e,i=t));return i},qf.Wp=function(n){var t,e,i,a,s;for(n.a=n.d.d,n.b=$l(Qf.nyb,tn,6,n.k.f,16,1),n.c=$l(Qf.nyb,tn,6,n.k.g,16,1),n.g=new Vf.bj,t=qf.Vp(n);-1!=t;){if(e=n.g.a.length,qf.Op(n,new qf.wt(t,-1,-1,!1,!1),e),0!=qf.Kn(n.k,t))for(qf.Mp(n,e,!1);e<n.g.a.length-1;){for(;qf.aq(n,Vf.Oi(n.g,e).a);)qf.Mp(n,e,!0);++e}t=qf.Vp(n)}for(n.q=$l(Qf.Mmb,G,6,n.k.f,15,1),i=0,s=new Vf.eQb(n.g);s.a<s.c.a.length;)a=Vf.dQb(s),n.q[a.a]=i++},qf.Xp=function(n,t,e){var i,a,s,r,o,f,l,d,g,u,c;if(o=!1,0!=qf.An(n.k,t)&&2==qf.Kn(n.k,t)&&2==qf.Mn(n.k,t,0)&&2==qf.Mn(n.k,t,1))for(s=0;s<qf.Kn(n.k,t);s++){for(i=qf.Jn(n.k,t,s),c=0,u=$l(Qf.Mmb,G,6,3,15,1),l=0;l<qf.Kn(n.k,i);l++)u[c]=qf.Jn(n.k,i,l),u[c]!=t&&++c;2==c&&n.q[u[0]]<n.q[u[1]]^u[0]<u[1]&&(o=!o)}else{for(d=$l(Qf.Mmb,G,6,4,15,1),g=$l(Qf.Mmb,G,6,4,15,1),r=0,-1!=e&&(d[r]=e,g[r++]=8*n.q[e]),(0!=qf.Zn(n.k,t)||3==qf.Kn(n.k,t))&&(d[r]=I,g[r++]=8*n.q[t]),s=0;s<qf.Kn(n.k,t);s++)(i=qf.Jn(n.k,t,s))!=e&&(d[r]=i,g[r++]=qf.$p(n,t,s));o=qf.cq(d,g)}return f=1==qf.Bk(n.k,t)^o,qf.ll(n.k,t)&&(a=qf.Pf(n.d,t),n.n[a]||(n.n[a]=!0,n.o[a]=f),n.o[a]&&(f=!f)),f?"@@":"@"},qf.Yp=function(n,t,e){var i,a,s,r,o,f,l;switch(0<(r=Gf.zVb(e.a).length)?e.a=zf.DJb(e.a,0,0):0>r&&(e.a+=zf.IJb($l(Qf.Jmb,st,6,-r,15,1))),Od(qd(wd(o=qf.Ck(n.k,t),Dn),3))){case 20971520:e.a+="+0";break;case 25165824:0==qf.qk(n.k,t)&&(e.a+="-");break;case 12582912:0==qf.qk(n.k,t)&&(e.a+="+")}return 0==Ud(i=wd(o,ct),2)?e.a+=";a":0==Ud(i,4)&&(e.a+=";A"),0!=Ud(a=wd(o,bn),0)&&(0==Ud(a,1792)?e.a+=";H0":0==Ud(a,1664)?e.a+=";H1":0==Ud(a,1408)?e.a+=";H2":0==Ud(a,896)?e.a+=";H3":0==Ud(a,128)?e.a+=";!H0":0==Ud(a,384)?e.a+=";!H0;!H1":0==Ud(a,1536)?e.a+=";!H2;!H3":0==Ud(a,hn)&&(e.a+=";!H3")),0==Ud(l=wd(o,120),8)?e.a+=";!R0":0==Ud(l,16)?e.a+=";!R1":0==Ud(l,32)?e.a+=";!R2":0==Ud(l,64)?e.a+=";!R3":0==Ud(l,112)?e.a+=";R0":0==Ud(l,104)?e.a+=";R1":0==Ud(l,88)?e.a+=";R2":0==Ud(l,56)&&(e.a+=";R3"),0==Ud(f=wd(o,v),Z)?e.a+=";!r"+Kd(f):0==Ud(f,St)?e.a+=";r"+Kd(f):0!=Ud(f,0)&&(Sd(wd(f,nn),0)?(Ld(wd(f,Z),0)&&(e.a+=";!r0"+Kd(f)),Ld(wd(f,O),0)&&(e.a+=";!r3"+Kd(f)),Ld(wd(f,K),0)&&(e.a+=";!r4"+Kd(f)),Ld(wd(f,W),0)&&(e.a+=";!r5"+Kd(f)),Ld(wd(f,_),0)&&(e.a+=";!r6"+Kd(f)),Ld(wd(f,$),0)&&(e.a+=";!r7"+Kd(f))):(e.a+=";",Sd(wd(f,Z),0)&&(e.a+="r0,"+Kd(f)),Sd(wd(f,O),0)&&(e.a+="r3,"+Kd(f)),Sd(wd(f,K),0)&&(e.a+="r4,"+Kd(f)),Sd(wd(f,W),0)&&(e.a+="r5,"+Kd(f)),Sd(wd(f,_),0)&&(e.a+="r6,"+Kd(f)),Sd(wd(f,$),0)&&(e.a+="r7,"+Kd(f)),zf.LGb(e,Gf.zVb(e.a).length-1))),0==Ud(f,0)&&0!=Ud(f=qd(wd(o,zn),22),0)&&(e.a+=";r"+Kd(f)),0==Ud(s=wd(o,Cn),pn)&&(e.a+=";D1"),0==Ud(s,Mn)&&(e.a+=";D2"),0==Ud(s,In)&&(e.a+=";D3"),0==Ud(s,Pn)&&(e.a+=";!D3;!D4"),0==Ud(s,Tn)&&(e.a+=";!D4"),0==Ud(s,Nn)&&(e.a+=";!D0;!D1"),0==Ud(s,wn)&&(e.a+=";!D0;!D1;!D2"),0==Ud(s,Un)&&(e.a+=";!D0;!D1;!D2;!D3"),Sd(wd(o,Gn),0)&&zf.UJb(e,";D"+qf.Kn(n.k,t)),Sd(wd(o,dn),0)&&zf.UJb(e,";!D"+qf.Kn(n.k,t)),0==Gf.zVb(e.a).length?null:e.a},qf.Zp=function(n){return null==n.p&&(n.p=qf.Tp(n)),n.p},qf.$p=function(n,t,e){var i,a,s,r,o;if(i=qf.Ln(n.k,t,e),r=qf.Jn(n.k,t,e),0!=n.e[i]){for(o=8*n.q[t]+1,a=Vf.Oi(n.g,n.q[t]).c,s=0;s<a.length&&r!=a[s];s++)++o;return o}return 8*n.q[r]},qf._p=function(n,t){var e,i,a,s,r;for(e=-1,i=-1,s=0;s<qf.Kn(n.k,t);s++)a=qf.Jn(n.k,t,s),r=(qf.Mn(n.k,t,s)<<24)+n.a[a],!n.b[a]&&(-1==e||i<r)&&(e=s,i=r);return e},qf.aq=function(n,t){var e;for(e=0;e<qf.Kn(n.k,t);e++)if(!n.b[qf.Jn(n.k,t,e)])return!0;return!1},qf.bq=function(n,t,e){var i;return Vf.Oi(n.g,n.q[t]).g!=e&&((i=Vf.Oi(n.g,n.q[e])).g==t||qf.vt(i,t))},qf.cq=function(n,t){var e,i,a;for(i=!1,e=1;e<4;e++)for(a=0;a<e;a++)n[a]>n[e]&&(i=!i),t[a]>t[e]&&(i=!i);return i},qf.dq=function(n){return n>=5&&n<=9||n>=15&&n<=17||35==n||53==n},qf.eq=function(n){qf.gq.call(this,n)},qf.fq=function(n,t){this.k=n,this.j=t},qf.gq=function(n){qf.fq.call(this,n,0)},qf.hq=function(n){var t,e,i,a;for(a=new zf.XJb,e=0;e<n.g.a.length;e++)0!=e&&(a.a+="."),zf.UJb(a,qf.Zp(new qf.fq(Vf.Oi(n.g,e),2)));for(a.a+=">",i=0;i<n.a.a.length;i++)0!=i&&(a.a+="."),zf.UJb(a,qf.Zp(new qf.eq(Vf.Oi(n.a,i))));for(a.a+=">",t=0;t<n.f.a.length;t++)0!=t&&(a.a+="."),zf.UJb(a,qf.Zp(new qf.fq(Vf.Oi(n.f,t),2)));return a.a},Ol(97,1,{},qf.eq,qf.fq),o.j=0,Qf.lnb=hd(97),qf.iq=function(n,t){this.b=n,this.a=t},Ol(3,1,{3:1},qf.iq),o.a=0,o.b=0,Qf.mnb=hd(3),qf.kq=function(){qf.kq=vl,qf.jq=ed(Wl(Qf.mnb,2),j,17,0,[null,ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(0,1.007825032),new qf.iq(1,2.014101778),new qf.iq(2,3.016049268),new qf.iq(3,4.027834627),new qf.iq(4,5.039542911),new qf.iq(5,6.044942608)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(1,3.01602931),new qf.iq(2,4.00260325),new qf.iq(3,5.012223628),new qf.iq(4,6.018888072),new qf.iq(5,7.028030527),new qf.iq(6,8.033921838),new qf.iq(7,9.043820323),new qf.iq(8,10.052399713)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(1,4.027182329),new qf.iq(2,5.012537796),new qf.iq(3,6.015122281),new qf.iq(4,7.016004049),new qf.iq(5,8.02248667),new qf.iq(6,9.026789122),new qf.iq(7,10.035480884),new qf.iq(8,11.043796166),new qf.iq(9,12.05378)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(1,5.04079),new qf.iq(2,6.019725804),new qf.iq(3,7.016929246),new qf.iq(4,8.005305094),new qf.iq(5,9.012182135),new qf.iq(6,10.01353372),new qf.iq(7,11.021657653),new qf.iq(8,12.026920631),new qf.iq(9,13.036133834),new qf.iq(10,14.042815522)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(2,7.029917389),new qf.iq(3,8.024606713),new qf.iq(4,9.013328806),new qf.iq(5,10.012937027),new qf.iq(6,11.009305466),new qf.iq(7,12.014352109),new qf.iq(8,13.017780267),new qf.iq(9,14.025404064),new qf.iq(10,15.031097291),new qf.iq(11,16.039808836),new qf.iq(12,17.046931399),new qf.iq(13,18.05617),new qf.iq(14,19.06373)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(2,8.037675026),new qf.iq(3,9.031040087),new qf.iq(4,10.01685311),new qf.iq(5,11.011433818),new qf.iq(6,12),new qf.iq(7,13.003354838),new qf.iq(8,14.003241988),new qf.iq(9,15.010599258),new qf.iq(10,16.014701243),new qf.iq(11,17.022583712),new qf.iq(12,18.026757058),new qf.iq(13,19.035248094),new qf.iq(14,20.040322395),new qf.iq(15,21.04934),new qf.iq(16,22.05645)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(3,10.042618),new qf.iq(4,11.026796226),new qf.iq(5,12.018613202),new qf.iq(6,13.005738584),new qf.iq(7,14.003074005),new qf.iq(8,15.000108898),new qf.iq(9,16.006101417),new qf.iq(10,17.008449673),new qf.iq(11,18.014081827),new qf.iq(12,19.017026896),new qf.iq(13,20.023367295),new qf.iq(14,21.027087574),new qf.iq(15,22.034440259),new qf.iq(16,23.04051),new qf.iq(17,24.0505)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(4,12.034404776),new qf.iq(5,13.0248104),new qf.iq(6,14.008595285),new qf.iq(7,15.003065386),new qf.iq(8,15.994914622),new qf.iq(9,16.999131501),new qf.iq(10,17.999160419),new qf.iq(11,19.00357873),new qf.iq(12,20.00407615),new qf.iq(13,21.008654631),new qf.iq(14,22.009967157),new qf.iq(15,23.015691325),new qf.iq(16,24.020369922),new qf.iq(17,25.02914),new qf.iq(18,26.03775)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(5,14.03608),new qf.iq(6,15.018010856),new qf.iq(7,16.01146573),new qf.iq(8,17.002095238),new qf.iq(9,18.000937667),new qf.iq(10,18.998403205),new qf.iq(11,19.999981324),new qf.iq(12,20.999948921),new qf.iq(13,22.00299925),new qf.iq(14,23.003574385),new qf.iq(15,24.008099371),new qf.iq(16,25.012094963),new qf.iq(17,26.019633157),new qf.iq(18,27.026892316),new qf.iq(19,28.03567),new qf.iq(20,29.04326)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(6,16.025756907),new qf.iq(7,17.017697565),new qf.iq(8,18.005697066),new qf.iq(9,19.001879839),new qf.iq(10,19.992440176),new qf.iq(11,20.993846744),new qf.iq(12,21.99138551),new qf.iq(13,22.994467337),new qf.iq(14,23.993615074),new qf.iq(15,24.997789899),new qf.iq(16,26.000461498),new qf.iq(17,27.0076152),new qf.iq(18,28.012108072),new qf.iq(19,29.019345902),new qf.iq(20,30.023872),new qf.iq(21,31.03311),new qf.iq(22,32.03991)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(7,18.02718),new qf.iq(8,19.01387945),new qf.iq(9,20.00734826),new qf.iq(10,20.997655099),new qf.iq(11,21.994436782),new qf.iq(12,22.989769675),new qf.iq(13,23.990963332),new qf.iq(14,24.989954352),new qf.iq(15,25.992589898),new qf.iq(16,26.994008702),new qf.iq(17,27.99889041),new qf.iq(18,29.002811301),new qf.iq(19,30.009226487),new qf.iq(20,31.013595108),new qf.iq(21,32.019649792),new qf.iq(22,33.027386),new qf.iq(23,34.0349),new qf.iq(24,35.04418)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(8,20.018862744),new qf.iq(9,21.011714174),new qf.iq(10,21.999574055),new qf.iq(11,22.99412485),new qf.iq(12,23.985041898),new qf.iq(13,24.985837023),new qf.iq(14,25.98259304),new qf.iq(15,26.984340742),new qf.iq(16,27.983876703),new qf.iq(17,28.988554743),new qf.iq(18,29.990464529),new qf.iq(19,30.996548459),new qf.iq(20,31.999145889),new qf.iq(21,33.005586975),new qf.iq(22,34.00907244),new qf.iq(23,35.018669),new qf.iq(24,36.02245),new qf.iq(25,37.03124)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(8,21.02804),new qf.iq(9,22.01952),new qf.iq(10,23.0072649),new qf.iq(11,23.999940911),new qf.iq(12,24.990428555),new qf.iq(13,25.986891659),new qf.iq(14,26.981538441),new qf.iq(15,27.981910184),new qf.iq(16,28.980444848),new qf.iq(17,29.982960304),new qf.iq(18,30.983946023),new qf.iq(19,31.988124379),new qf.iq(20,32.990869587),new qf.iq(21,33.996927255),new qf.iq(22,34.99993765),new qf.iq(23,36.006351501),new qf.iq(24,37.01031),new qf.iq(25,38.0169),new qf.iq(26,39.0219)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(8,22.03453),new qf.iq(9,23.02552),new qf.iq(10,24.011545711),new qf.iq(11,25.00410664),new qf.iq(12,25.992329935),new qf.iq(13,26.986704764),new qf.iq(14,27.976926533),new qf.iq(15,28.976494719),new qf.iq(16,29.973770218),new qf.iq(17,30.975363275),new qf.iq(18,31.974148129),new qf.iq(19,32.97800052),new qf.iq(20,33.978575745),new qf.iq(21,34.984584158),new qf.iq(22,35.986687363),new qf.iq(23,36.99299599),new qf.iq(24,37.99598),new qf.iq(25,39.0023),new qf.iq(26,40.0058),new qf.iq(27,41.0127),new qf.iq(28,42.0161)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(9,24.03435),new qf.iq(10,25.02026),new qf.iq(11,26.01178),new qf.iq(12,26.999191645),new qf.iq(13,27.99231233),new qf.iq(14,28.981801376),new qf.iq(15,29.978313807),new qf.iq(16,30.973761512),new qf.iq(17,31.973907163),new qf.iq(18,32.971725281),new qf.iq(19,33.973636381),new qf.iq(20,34.973314249),new qf.iq(21,35.978259824),new qf.iq(22,36.979608338),new qf.iq(23,37.98447),new qf.iq(24,38.98642),new qf.iq(25,39.99105),new qf.iq(26,40.9948),new qf.iq(27,42.00009),new qf.iq(28,43.00331),new qf.iq(29,44.00988),new qf.iq(30,45.01514),new qf.iq(31,46.02383)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(10,26.02788),new qf.iq(11,27.018795),new qf.iq(12,28.004372661),new qf.iq(13,28.996608805),new qf.iq(14,29.984902954),new qf.iq(15,30.979554421),new qf.iq(16,31.97207069),new qf.iq(17,32.971458497),new qf.iq(18,33.967866831),new qf.iq(19,34.96903214),new qf.iq(20,35.96708088),new qf.iq(21,36.971125716),new qf.iq(22,37.971163443),new qf.iq(23,38.975135275),new qf.iq(24,39.97547),new qf.iq(25,40.98003),new qf.iq(26,41.98149),new qf.iq(27,42.9866),new qf.iq(28,43.98832),new qf.iq(29,44.99482),new qf.iq(30,45.99957),new qf.iq(31,47.00762),new qf.iq(32,48.01299),new qf.iq(33,49.02201)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(11,28.02851),new qf.iq(12,29.01411),new qf.iq(13,30.00477),new qf.iq(14,30.992416014),new qf.iq(15,31.985688908),new qf.iq(16,32.977451798),new qf.iq(17,33.973761967),new qf.iq(18,34.968852707),new qf.iq(19,35.968306945),new qf.iq(20,36.9659026),new qf.iq(21,37.96801055),new qf.iq(22,38.968007677),new qf.iq(23,39.970415555),new qf.iq(24,40.970650212),new qf.iq(25,41.973174994),new qf.iq(26,42.974203385),new qf.iq(27,43.978538712),new qf.iq(28,44.9797),new qf.iq(29,45.98412),new qf.iq(30,46.98795),new qf.iq(31,47.99485),new qf.iq(32,48.99989),new qf.iq(33,50.00773),new qf.iq(34,51.01353)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(12,30.02156),new qf.iq(13,31.012126),new qf.iq(14,31.99766066),new qf.iq(15,32.989928719),new qf.iq(16,33.980270118),new qf.iq(17,34.975256726),new qf.iq(18,35.967546282),new qf.iq(19,36.966775912),new qf.iq(20,37.962732161),new qf.iq(21,38.964313413),new qf.iq(22,39.962383123),new qf.iq(23,40.964500828),new qf.iq(24,41.963046386),new qf.iq(25,42.965670701),new qf.iq(26,43.965365269),new qf.iq(27,44.968094979),new qf.iq(28,45.968093467),new qf.iq(29,46.972186238),new qf.iq(30,47.97507),new qf.iq(31,48.98218),new qf.iq(32,49.98594),new qf.iq(33,50.99324),new qf.iq(34,51.99817),new qf.iq(35,53.006227)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(13,32.02192),new qf.iq(14,33.00726),new qf.iq(15,33.99841),new qf.iq(16,34.988011615),new qf.iq(17,35.981293405),new qf.iq(18,36.973376915),new qf.iq(19,37.969080107),new qf.iq(20,38.963706861),new qf.iq(21,39.963998672),new qf.iq(22,40.961825972),new qf.iq(23,41.962403059),new qf.iq(24,42.960715746),new qf.iq(25,43.961556146),new qf.iq(26,44.960699658),new qf.iq(27,45.961976203),new qf.iq(28,46.961677807),new qf.iq(29,47.965512946),new qf.iq(30,48.967450084),new qf.iq(31,49.972782832),new qf.iq(32,50.97638),new qf.iq(33,51.98261),new qf.iq(34,52.98712),new qf.iq(35,53.99399),new qf.iq(36,54.999388)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(14,34.01412),new qf.iq(15,35.004765),new qf.iq(16,35.993087234),new qf.iq(17,36.985871505),new qf.iq(18,37.976318637),new qf.iq(19,38.970717729),new qf.iq(20,39.962591155),new qf.iq(21,40.962278349),new qf.iq(22,41.958618337),new qf.iq(23,42.958766833),new qf.iq(24,43.955481094),new qf.iq(25,44.956185938),new qf.iq(26,45.953692759),new qf.iq(27,46.954546459),new qf.iq(28,47.952533512),new qf.iq(29,48.955673302),new qf.iq(30,49.957518286),new qf.iq(31,50.961474238),new qf.iq(32,51.9651),new qf.iq(33,52.97005),new qf.iq(34,53.97468),new qf.iq(35,54.98055),new qf.iq(36,55.98579),new qf.iq(37,56.992356)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(15,36.01492),new qf.iq(16,37.00305),new qf.iq(17,37.9947),new qf.iq(18,38.984790009),new qf.iq(19,39.977964014),new qf.iq(20,40.969251316),new qf.iq(21,41.965516761),new qf.iq(22,42.96115098),new qf.iq(23,43.959403048),new qf.iq(24,44.955910243),new qf.iq(25,45.95517025),new qf.iq(26,46.952408027),new qf.iq(27,47.952234991),new qf.iq(28,48.950024065),new qf.iq(29,49.952187008),new qf.iq(30,50.9536027),new qf.iq(31,51.95665),new qf.iq(32,52.95817),new qf.iq(33,53.963),new qf.iq(34,54.9694),new qf.iq(35,55.97266),new qf.iq(36,56.97704),new qf.iq(37,57.98307),new qf.iq(38,58.988041)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(16,38.00977),new qf.iq(17,39.001323),new qf.iq(18,39.990498907),new qf.iq(19,40.983131),new qf.iq(20,41.973031622),new qf.iq(21,42.968523342),new qf.iq(22,43.959690235),new qf.iq(23,44.958124349),new qf.iq(24,45.952629491),new qf.iq(25,46.951763792),new qf.iq(26,47.947947053),new qf.iq(27,48.947870789),new qf.iq(28,49.944792069),new qf.iq(29,50.946616017),new qf.iq(30,51.946898175),new qf.iq(31,52.949731709),new qf.iq(32,53.95087),new qf.iq(33,54.95512),new qf.iq(34,55.95799),new qf.iq(35,56.9643),new qf.iq(36,57.96611),new qf.iq(37,58.97196),new qf.iq(38,59.97564),new qf.iq(39,60.982018)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(17,40.01109),new qf.iq(18,40.99974),new qf.iq(19,41.99123),new qf.iq(20,42.98065),new qf.iq(21,43.9744),new qf.iq(22,44.965782286),new qf.iq(23,45.960199491),new qf.iq(24,46.954906918),new qf.iq(25,47.95225448),new qf.iq(26,48.948516914),new qf.iq(27,49.947162792),new qf.iq(28,50.943963675),new qf.iq(29,51.944779658),new qf.iq(30,52.944342517),new qf.iq(31,53.946444381),new qf.iq(32,54.947238194),new qf.iq(33,55.95036),new qf.iq(34,56.95236),new qf.iq(35,57.95665),new qf.iq(36,58.9593),new qf.iq(37,59.9645),new qf.iq(38,60.96741),new qf.iq(39,61.97314),new qf.iq(40,62.97675)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(18,42.00643),new qf.iq(19,42.997707),new qf.iq(20,43.98547),new qf.iq(21,44.97916),new qf.iq(22,45.968361649),new qf.iq(23,46.962906512),new qf.iq(24,47.954035861),new qf.iq(25,48.951341135),new qf.iq(26,49.946049607),new qf.iq(27,50.944771767),new qf.iq(28,51.940511904),new qf.iq(29,52.940653781),new qf.iq(30,53.938884921),new qf.iq(31,54.940844164),new qf.iq(32,55.940645238),new qf.iq(33,56.9437538),new qf.iq(34,57.94425),new qf.iq(35,58.94863),new qf.iq(36,59.94973),new qf.iq(37,60.95409),new qf.iq(38,61.9558),new qf.iq(39,62.96186),new qf.iq(40,63.9642),new qf.iq(41,64.97037)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(19,44.00687),new qf.iq(20,44.99451),new qf.iq(21,45.98672),new qf.iq(22,46.9761),new qf.iq(23,47.96887),new qf.iq(24,48.959623415),new qf.iq(25,49.95424396),new qf.iq(26,50.948215487),new qf.iq(27,51.945570079),new qf.iq(28,52.941294702),new qf.iq(29,53.940363247),new qf.iq(30,54.938049636),new qf.iq(31,55.938909366),new qf.iq(32,56.938287458),new qf.iq(33,57.939986451),new qf.iq(34,58.940447166),new qf.iq(35,59.943193998),new qf.iq(36,60.94446),new qf.iq(37,61.94797),new qf.iq(38,62.94981),new qf.iq(39,63.95373),new qf.iq(40,64.9561),new qf.iq(41,65.96082),new qf.iq(42,66.96382)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(19,45.01456),new qf.iq(20,46.00081),new qf.iq(21,46.99289),new qf.iq(22,47.98056),new qf.iq(23,48.97361),new qf.iq(24,49.962993316),new qf.iq(25,50.956824936),new qf.iq(26,51.948116526),new qf.iq(27,52.945312282),new qf.iq(28,53.939614836),new qf.iq(29,54.938298029),new qf.iq(30,55.934942133),new qf.iq(31,56.935398707),new qf.iq(32,57.933280458),new qf.iq(33,58.934880493),new qf.iq(34,59.934076943),new qf.iq(35,60.936749461),new qf.iq(36,61.936770495),new qf.iq(37,62.940118442),new qf.iq(38,63.94087),new qf.iq(39,64.94494),new qf.iq(40,65.94598),new qf.iq(41,66.95),new qf.iq(42,67.95251),new qf.iq(43,68.9577)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(21,48.00176),new qf.iq(22,48.98972),new qf.iq(23,49.98154),new qf.iq(24,50.97072),new qf.iq(25,51.96359),new qf.iq(26,52.954224985),new qf.iq(27,53.948464147),new qf.iq(28,54.942003149),new qf.iq(29,55.939843937),new qf.iq(30,56.936296235),new qf.iq(31,57.935757571),new qf.iq(32,58.933200194),new qf.iq(33,59.933822196),new qf.iq(34,60.932479381),new qf.iq(35,61.934054212),new qf.iq(36,62.933615218),new qf.iq(37,63.935813523),new qf.iq(38,64.936484581),new qf.iq(39,65.939825412),new qf.iq(40,66.94061),new qf.iq(41,67.94436),new qf.iq(42,68.9452),new qf.iq(43,69.94981),new qf.iq(44,70.95173),new qf.iq(45,71.95641)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(22,49.99593),new qf.iq(23,50.98772),new qf.iq(24,51.97568),new qf.iq(25,52.96846),new qf.iq(26,53.957910508),new qf.iq(27,54.951336329),new qf.iq(28,55.942136339),new qf.iq(29,56.939800489),new qf.iq(30,57.935347922),new qf.iq(31,58.934351553),new qf.iq(32,59.930790633),new qf.iq(33,60.931060442),new qf.iq(34,61.928348763),new qf.iq(35,62.929672948),new qf.iq(36,63.927969574),new qf.iq(37,64.930088013),new qf.iq(38,65.929115232),new qf.iq(39,66.931569638),new qf.iq(40,67.931844932),new qf.iq(41,68.935181837),new qf.iq(42,69.93614),new qf.iq(43,70.94),new qf.iq(44,71.9413),new qf.iq(45,72.94608),new qf.iq(46,73.94791),new qf.iq(47,74.95297),new qf.iq(48,75.95533),new qf.iq(49,76.96083),new qf.iq(50,77.9638)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(23,51.99718),new qf.iq(24,52.98555),new qf.iq(25,53.97671),new qf.iq(26,54.96605),new qf.iq(27,55.95856),new qf.iq(28,56.949215695),new qf.iq(29,57.944540734),new qf.iq(30,58.939504114),new qf.iq(31,59.937368123),new qf.iq(32,60.933462181),new qf.iq(33,61.932587299),new qf.iq(34,62.929601079),new qf.iq(35,63.929767865),new qf.iq(36,64.927793707),new qf.iq(37,65.928873041),new qf.iq(38,66.927750294),new qf.iq(39,67.929637875),new qf.iq(40,68.929425281),new qf.iq(41,69.932409287),new qf.iq(42,70.932619818),new qf.iq(43,71.93552),new qf.iq(44,72.93649),new qf.iq(45,73.9402),new qf.iq(46,74.9417),new qf.iq(47,75.94599),new qf.iq(48,76.94795),new qf.iq(49,77.95281),new qf.iq(50,78.95528),new qf.iq(51,79.96189)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(24,53.99295),new qf.iq(25,54.98398),new qf.iq(26,55.97238),new qf.iq(27,56.96491),new qf.iq(28,57.954596465),new qf.iq(29,58.949267074),new qf.iq(30,59.941832031),new qf.iq(31,60.939513907),new qf.iq(32,61.934334132),new qf.iq(33,62.933215563),new qf.iq(34,63.929146578),new qf.iq(35,64.929245079),new qf.iq(36,65.926036763),new qf.iq(37,66.927130859),new qf.iq(38,67.924847566),new qf.iq(39,68.926553538),new qf.iq(40,69.92532487),new qf.iq(41,70.927727195),new qf.iq(42,71.926861122),new qf.iq(43,72.929779469),new qf.iq(44,73.929458261),new qf.iq(45,74.932937379),new qf.iq(46,75.933394207),new qf.iq(47,76.937085857),new qf.iq(48,77.938569576),new qf.iq(49,78.942095175),new qf.iq(50,79.944414722),new qf.iq(51,80.95048),new qf.iq(52,81.95484)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(25,55.99491),new qf.iq(26,56.98293),new qf.iq(27,57.97425),new qf.iq(28,58.96337),new qf.iq(29,59.95706),new qf.iq(30,60.94917),new qf.iq(31,61.944179608),new qf.iq(32,62.939141527),new qf.iq(33,63.936838307),new qf.iq(34,64.932739322),new qf.iq(35,65.931592355),new qf.iq(36,66.928204915),new qf.iq(37,67.927983497),new qf.iq(38,68.925580912),new qf.iq(39,69.926027741),new qf.iq(40,70.92470501),new qf.iq(41,71.92636935),new qf.iq(42,72.925169832),new qf.iq(43,73.926940999),new qf.iq(44,74.926500645),new qf.iq(45,75.928928262),new qf.iq(46,76.929281189),new qf.iq(47,77.93165595),new qf.iq(48,78.932916371),new qf.iq(49,79.936588154),new qf.iq(50,80.937752955),new qf.iq(51,81.94316),new qf.iq(52,82.94687),new qf.iq(53,83.95234)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(26,57.99101),new qf.iq(27,58.98175),new qf.iq(28,59.97019),new qf.iq(29,60.96379),new qf.iq(30,61.95465),new qf.iq(31,62.94964),new qf.iq(32,63.941572638),new qf.iq(33,64.939440762),new qf.iq(34,65.933846798),new qf.iq(35,66.932738415),new qf.iq(36,67.928097266),new qf.iq(37,68.927972002),new qf.iq(38,69.924250365),new qf.iq(39,70.924953991),new qf.iq(40,71.922076184),new qf.iq(41,72.923459361),new qf.iq(42,73.921178213),new qf.iq(43,74.922859494),new qf.iq(44,75.921402716),new qf.iq(45,76.923548462),new qf.iq(46,77.922852886),new qf.iq(47,78.92540156),new qf.iq(48,79.925444764),new qf.iq(49,80.928821065),new qf.iq(50,81.929550326),new qf.iq(51,82.93451),new qf.iq(52,83.93731),new qf.iq(53,84.94269),new qf.iq(54,85.94627)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(27,59.99313),new qf.iq(28,60.98062),new qf.iq(29,61.9732),new qf.iq(30,62.96369),new qf.iq(31,63.957572),new qf.iq(32,64.949484),new qf.iq(33,65.944099147),new qf.iq(34,66.939190417),new qf.iq(35,67.936792976),new qf.iq(36,68.932280154),new qf.iq(37,69.930927811),new qf.iq(38,70.927114724),new qf.iq(39,71.926752647),new qf.iq(40,72.923825288),new qf.iq(41,73.923929076),new qf.iq(42,74.921596417),new qf.iq(43,75.922393933),new qf.iq(44,76.920647703),new qf.iq(45,77.921828577),new qf.iq(46,78.920948498),new qf.iq(47,79.922578162),new qf.iq(48,80.922132884),new qf.iq(49,81.924504668),new qf.iq(50,82.924980625),new qf.iq(51,83.92906),new qf.iq(52,84.93181),new qf.iq(53,85.93623),new qf.iq(54,86.93958),new qf.iq(55,87.94456),new qf.iq(56,88.94923)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(31,64.96466),new qf.iq(32,65.95521),new qf.iq(33,66.95009),new qf.iq(34,67.94187),new qf.iq(35,68.939562155),new qf.iq(36,69.933504),new qf.iq(37,70.931868378),new qf.iq(38,71.927112313),new qf.iq(39,72.9267668),new qf.iq(40,73.922476561),new qf.iq(41,74.922523571),new qf.iq(42,75.919214107),new qf.iq(43,76.91991461),new qf.iq(44,77.917309522),new qf.iq(45,78.918499802),new qf.iq(46,79.916521828),new qf.iq(47,80.917992931),new qf.iq(48,81.9167),new qf.iq(49,82.919119072),new qf.iq(50,83.918464523),new qf.iq(51,84.922244678),new qf.iq(52,85.924271165),new qf.iq(53,86.928520749),new qf.iq(54,87.931423982),new qf.iq(55,88.93602),new qf.iq(56,89.93942),new qf.iq(57,90.94537),new qf.iq(58,91.94933)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(32,66.96479),new qf.iq(33,67.958248),new qf.iq(34,68.950178),new qf.iq(35,69.944208),new qf.iq(36,70.939246),new qf.iq(37,71.936496876),new qf.iq(38,72.931794889),new qf.iq(39,73.929891152),new qf.iq(40,74.92577641),new qf.iq(41,75.924541974),new qf.iq(42,76.921380123),new qf.iq(43,77.92114613),new qf.iq(44,78.918337647),new qf.iq(45,79.918529952),new qf.iq(46,80.91629106),new qf.iq(47,81.916804666),new qf.iq(48,82.915180219),new qf.iq(49,83.916503685),new qf.iq(50,84.915608027),new qf.iq(51,85.918797162),new qf.iq(52,86.920710713),new qf.iq(53,87.924065908),new qf.iq(54,88.92638726),new qf.iq(55,89.930634988),new qf.iq(56,90.9339653),new qf.iq(57,91.939255258),new qf.iq(58,92.9431),new qf.iq(59,93.94868)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(33,68.96532),new qf.iq(34,69.95601),new qf.iq(35,70.95051),new qf.iq(36,71.94190754),new qf.iq(37,72.938931115),new qf.iq(38,73.933258225),new qf.iq(39,74.931033794),new qf.iq(40,75.925948304),new qf.iq(41,76.92466788),new qf.iq(42,77.920386271),new qf.iq(43,78.920082992),new qf.iq(44,79.91637804),new qf.iq(45,80.916592419),new qf.iq(46,81.913484601),new qf.iq(47,82.914135952),new qf.iq(48,83.911506627),new qf.iq(49,84.912526954),new qf.iq(50,85.910610313),new qf.iq(51,86.913354251),new qf.iq(52,87.914446951),new qf.iq(53,88.917632505),new qf.iq(54,89.919523803),new qf.iq(55,90.923442418),new qf.iq(56,91.926152752),new qf.iq(57,92.931265246),new qf.iq(58,93.934362),new qf.iq(59,94.93984),new qf.iq(60,95.94307),new qf.iq(61,96.94856)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(34,70.96532),new qf.iq(35,71.95908),new qf.iq(36,72.950366),new qf.iq(37,73.944470376),new qf.iq(38,74.938569199),new qf.iq(39,75.935071448),new qf.iq(40,76.930406599),new qf.iq(41,77.928141485),new qf.iq(42,78.923996719),new qf.iq(43,79.922519322),new qf.iq(44,80.918994165),new qf.iq(45,81.918207691),new qf.iq(46,82.915111951),new qf.iq(47,83.914384676),new qf.iq(48,84.911789341),new qf.iq(49,85.91116708),new qf.iq(50,86.909183465),new qf.iq(51,87.911318556),new qf.iq(52,88.912279939),new qf.iq(53,89.914808941),new qf.iq(54,90.91653416),new qf.iq(55,91.919725442),new qf.iq(56,92.922032765),new qf.iq(57,93.926407326),new qf.iq(58,94.92931926),new qf.iq(59,95.934283962),new qf.iq(60,96.937342863),new qf.iq(61,97.941703557),new qf.iq(62,98.945420616),new qf.iq(63,99.94987),new qf.iq(64,100.953195994),new qf.iq(65,101.95921)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(35,72.96597),new qf.iq(36,73.95631),new qf.iq(37,74.94992),new qf.iq(38,75.94161),new qf.iq(39,76.937761511),new qf.iq(40,77.932179362),new qf.iq(41,78.929707076),new qf.iq(42,79.924524588),new qf.iq(43,80.923213095),new qf.iq(44,81.918401258),new qf.iq(45,82.917555029),new qf.iq(46,83.913424778),new qf.iq(47,84.912932689),new qf.iq(48,85.909262351),new qf.iq(49,86.908879316),new qf.iq(50,87.905614339),new qf.iq(51,88.907452906),new qf.iq(52,89.907737596),new qf.iq(53,90.910209845),new qf.iq(54,91.911029895),new qf.iq(55,92.91402241),new qf.iq(56,93.915359856),new qf.iq(57,94.919358213),new qf.iq(58,95.921680473),new qf.iq(59,96.926148757),new qf.iq(60,97.928471177),new qf.iq(61,98.933315038),new qf.iq(62,99.935351729),new qf.iq(63,100.940517434),new qf.iq(64,101.943018795),new qf.iq(65,102.94895),new qf.iq(66,103.95233)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(38,76.94962),new qf.iq(39,77.9435),new qf.iq(40,78.937350712),new qf.iq(41,79.931982402),new qf.iq(42,80.929128719),new qf.iq(43,81.926792071),new qf.iq(44,82.922352572),new qf.iq(45,83.920387768),new qf.iq(46,84.916427076),new qf.iq(47,85.914887724),new qf.iq(48,86.910877833),new qf.iq(49,87.909503361),new qf.iq(50,88.905847902),new qf.iq(51,89.907151443),new qf.iq(52,90.907303415),new qf.iq(53,91.908946832),new qf.iq(54,92.909581582),new qf.iq(55,93.911594008),new qf.iq(56,94.912823709),new qf.iq(57,95.915897787),new qf.iq(58,96.918131017),new qf.iq(59,97.922219525),new qf.iq(60,98.924634736),new qf.iq(61,99.927756402),new qf.iq(62,100.930313395),new qf.iq(63,101.933555501),new qf.iq(64,102.93694),new qf.iq(65,103.94145),new qf.iq(66,104.94509),new qf.iq(67,105.95022)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(39,78.94916),new qf.iq(40,79.94055),new qf.iq(41,80.936815296),new qf.iq(42,81.931086249),new qf.iq(43,82.92865213),new qf.iq(44,83.92325),new qf.iq(45,84.92146522),new qf.iq(46,85.916472851),new qf.iq(47,86.914816578),new qf.iq(48,87.910226179),new qf.iq(49,88.908888916),new qf.iq(50,89.904703679),new qf.iq(51,90.905644968),new qf.iq(52,91.905040106),new qf.iq(53,92.906475627),new qf.iq(54,93.906315765),new qf.iq(55,94.908042739),new qf.iq(56,95.908275675),new qf.iq(57,96.910950716),new qf.iq(58,97.912746366),new qf.iq(59,98.916511084),new qf.iq(60,99.917761704),new qf.iq(61,100.921139958),new qf.iq(62,101.922981089),new qf.iq(63,102.926597062),new qf.iq(64,103.92878),new qf.iq(65,104.93305),new qf.iq(66,105.93591),new qf.iq(67,106.94086),new qf.iq(68,107.94428)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(40,80.94905),new qf.iq(41,81.94313),new qf.iq(42,82.936703713),new qf.iq(43,83.93357),new qf.iq(44,84.927906486),new qf.iq(45,85.925037588),new qf.iq(46,86.920361435),new qf.iq(47,87.91833144),new qf.iq(48,88.913495503),new qf.iq(49,89.911264109),new qf.iq(50,90.906990538),new qf.iq(51,91.907193214),new qf.iq(52,92.906377543),new qf.iq(53,93.907283457),new qf.iq(54,94.906835178),new qf.iq(55,95.908100076),new qf.iq(56,96.908097144),new qf.iq(57,97.91033069),new qf.iq(58,98.911617864),new qf.iq(59,99.914181434),new qf.iq(60,100.915251567),new qf.iq(61,101.918037417),new qf.iq(62,102.919141297),new qf.iq(63,103.922459464),new qf.iq(64,104.923934023),new qf.iq(65,105.92819),new qf.iq(66,106.93031),new qf.iq(67,107.93501),new qf.iq(68,108.93763),new qf.iq(69,109.94268)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(41,82.94874),new qf.iq(42,83.94009),new qf.iq(43,84.93659),new qf.iq(44,85.930695167),new qf.iq(45,86.92732683),new qf.iq(46,87.921952728),new qf.iq(47,88.919480562),new qf.iq(48,89.913936161),new qf.iq(49,90.911750754),new qf.iq(50,91.90681048),new qf.iq(51,92.906812213),new qf.iq(52,93.905087578),new qf.iq(53,94.905841487),new qf.iq(54,95.904678904),new qf.iq(55,96.906021033),new qf.iq(56,97.905407846),new qf.iq(57,98.907711598),new qf.iq(58,99.907477149),new qf.iq(59,100.910346543),new qf.iq(60,101.910297162),new qf.iq(61,102.913204596),new qf.iq(62,103.913758387),new qf.iq(63,104.916972087),new qf.iq(64,105.918134284),new qf.iq(65,106.921694724),new qf.iq(66,107.923973837),new qf.iq(67,108.92781),new qf.iq(68,109.92973),new qf.iq(69,110.93451),new qf.iq(70,111.93684),new qf.iq(71,112.94203)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(42,84.94894),new qf.iq(43,85.94288),new qf.iq(44,86.93653),new qf.iq(45,87.93283),new qf.iq(46,88.92754288),new qf.iq(47,89.92355583),new qf.iq(48,90.9184282),new qf.iq(49,91.915259655),new qf.iq(50,92.910248473),new qf.iq(51,93.909656309),new qf.iq(52,94.907656454),new qf.iq(53,95.907870803),new qf.iq(54,96.906364843),new qf.iq(55,97.907215692),new qf.iq(56,98.906254554),new qf.iq(57,99.907657594),new qf.iq(58,100.90731438),new qf.iq(59,101.909212938),new qf.iq(60,102.909178805),new qf.iq(61,103.911444898),new qf.iq(62,104.911658043),new qf.iq(63,105.914355408),new qf.iq(64,106.915081691),new qf.iq(65,107.918479973),new qf.iq(66,108.919980998),new qf.iq(67,109.92339),new qf.iq(68,110.92505),new qf.iq(69,111.92924),new qf.iq(70,112.93133),new qf.iq(71,113.93588),new qf.iq(72,114.93828)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(43,86.94918),new qf.iq(44,87.94042),new qf.iq(45,88.93611),new qf.iq(46,89.92978),new qf.iq(47,90.926377434),new qf.iq(48,91.92012),new qf.iq(49,92.917051523),new qf.iq(50,93.911359569),new qf.iq(51,94.910412729),new qf.iq(52,95.907597681),new qf.iq(53,96.907554546),new qf.iq(54,97.905287111),new qf.iq(55,98.905939307),new qf.iq(56,99.904219664),new qf.iq(57,100.905582219),new qf.iq(58,101.904349503),new qf.iq(59,102.906323677),new qf.iq(60,103.905430145),new qf.iq(61,104.907750341),new qf.iq(62,105.907326913),new qf.iq(63,106.909907207),new qf.iq(64,107.910192211),new qf.iq(65,108.913201565),new qf.iq(66,109.913966185),new qf.iq(67,110.91756),new qf.iq(68,111.918821673),new qf.iq(69,112.92254),new qf.iq(70,113.923891981),new qf.iq(71,114.92831),new qf.iq(72,115.93016),new qf.iq(73,116.93479),new qf.iq(74,117.93703)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(44,88.94938),new qf.iq(45,89.94287),new qf.iq(46,90.93655),new qf.iq(47,91.93198),new qf.iq(48,92.92574),new qf.iq(49,93.921698),new qf.iq(50,94.915898541),new qf.iq(51,95.914518212),new qf.iq(52,96.911336643),new qf.iq(53,97.910716431),new qf.iq(54,98.908132101),new qf.iq(55,99.90811663),new qf.iq(56,100.906163526),new qf.iq(57,101.906842845),new qf.iq(58,102.905504182),new qf.iq(59,103.906655315),new qf.iq(60,104.905692444),new qf.iq(61,105.907284615),new qf.iq(62,106.90675054),new qf.iq(63,107.908730768),new qf.iq(64,108.908735621),new qf.iq(65,109.910949525),new qf.iq(66,110.91166),new qf.iq(67,111.913969253),new qf.iq(68,112.91542),new qf.iq(69,113.91734336),new qf.iq(70,114.920124676),new qf.iq(71,115.922746643),new qf.iq(72,116.92535),new qf.iq(73,117.92943),new qf.iq(74,118.93136),new qf.iq(75,119.93578),new qf.iq(76,120.93808)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(45,90.94948),new qf.iq(46,91.94042),new qf.iq(47,92.93591),new qf.iq(48,93.92877),new qf.iq(49,94.92469),new qf.iq(50,95.91822194),new qf.iq(51,96.916478921),new qf.iq(52,97.912720751),new qf.iq(53,98.911767757),new qf.iq(54,99.908504596),new qf.iq(55,100.908289144),new qf.iq(56,101.905607716),new qf.iq(57,102.906087204),new qf.iq(58,103.904034912),new qf.iq(59,104.905084046),new qf.iq(60,105.903483087),new qf.iq(61,106.905128453),new qf.iq(62,107.903894451),new qf.iq(63,108.905953535),new qf.iq(64,109.905152385),new qf.iq(65,110.907643952),new qf.iq(66,111.907313277),new qf.iq(67,112.910151346),new qf.iq(68,113.910365322),new qf.iq(69,114.91368341),new qf.iq(70,115.914158288),new qf.iq(71,116.91784),new qf.iq(72,117.918983915),new qf.iq(73,118.92268),new qf.iq(74,119.92403),new qf.iq(75,120.92818),new qf.iq(76,121.9298),new qf.iq(77,122.93426)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(47,93.94278),new qf.iq(48,94.93548),new qf.iq(49,95.93068),new qf.iq(50,96.924),new qf.iq(51,97.921759995),new qf.iq(52,98.917597103),new qf.iq(53,99.916069387),new qf.iq(54,100.912802135),new qf.iq(55,101.911999996),new qf.iq(56,102.908972453),new qf.iq(57,103.908628228),new qf.iq(58,104.906528234),new qf.iq(59,105.906666431),new qf.iq(60,106.90509302),new qf.iq(61,107.905953705),new qf.iq(62,108.904755514),new qf.iq(63,109.90611046),new qf.iq(64,110.905294679),new qf.iq(65,111.907004132),new qf.iq(66,112.906565708),new qf.iq(67,113.908807907),new qf.iq(68,114.908762282),new qf.iq(69,115.911359558),new qf.iq(70,116.911684187),new qf.iq(71,117.914582383),new qf.iq(72,118.915666045),new qf.iq(73,119.918788609),new qf.iq(74,120.919851074),new qf.iq(75,121.92332),new qf.iq(76,122.9249),new qf.iq(77,123.92853),new qf.iq(78,124.93054),new qf.iq(79,125.9345),new qf.iq(80,126.93688)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(48,95.93977),new qf.iq(49,96.93494),new qf.iq(50,97.927579),new qf.iq(51,98.92501),new qf.iq(52,99.920230232),new qf.iq(53,100.918681442),new qf.iq(54,101.914777255),new qf.iq(55,102.913418952),new qf.iq(56,103.909848091),new qf.iq(57,104.909467818),new qf.iq(58,105.906458007),new qf.iq(59,106.906614232),new qf.iq(60,107.904183403),new qf.iq(61,108.904985569),new qf.iq(62,109.903005578),new qf.iq(63,110.904181628),new qf.iq(64,111.902757226),new qf.iq(65,112.904400947),new qf.iq(66,113.903358121),new qf.iq(67,114.905430553),new qf.iq(68,115.904755434),new qf.iq(69,116.907218242),new qf.iq(70,117.906914144),new qf.iq(71,118.909922582),new qf.iq(72,119.909851352),new qf.iq(73,120.91298039),new qf.iq(74,121.9135),new qf.iq(75,122.917003675),new qf.iq(76,123.917648302),new qf.iq(77,124.92124717),new qf.iq(78,125.922353996),new qf.iq(79,126.926434822),new qf.iq(80,127.927760617),new qf.iq(81,128.93226),new qf.iq(82,129.93398)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(49,97.94224),new qf.iq(50,98.93461),new qf.iq(51,99.931149033),new qf.iq(52,100.92656),new qf.iq(53,101.924707541),new qf.iq(54,102.919913896),new qf.iq(55,103.918338416),new qf.iq(56,104.914673434),new qf.iq(57,105.913461134),new qf.iq(58,106.910292195),new qf.iq(59,107.909719683),new qf.iq(60,108.907154078),new qf.iq(61,109.907168783),new qf.iq(62,110.905110677),new qf.iq(63,111.905533338),new qf.iq(64,112.904061223),new qf.iq(65,113.904916758),new qf.iq(66,114.903878328),new qf.iq(67,115.905259995),new qf.iq(68,116.904515731),new qf.iq(69,117.906354623),new qf.iq(70,118.905846334),new qf.iq(71,119.907961505),new qf.iq(72,120.907848847),new qf.iq(73,121.910277103),new qf.iq(74,122.910438951),new qf.iq(75,123.913175916),new qf.iq(76,124.913601387),new qf.iq(77,125.916464532),new qf.iq(78,126.917344048),new qf.iq(79,127.920170658),new qf.iq(80,128.921657958),new qf.iq(81,129.924854941),new qf.iq(82,130.926767408),new qf.iq(83,131.932919005),new qf.iq(84,132.93834),new qf.iq(85,133.94466)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(50,99.938954),new qf.iq(51,100.93606),new qf.iq(52,101.93049),new qf.iq(53,102.92813),new qf.iq(54,103.923185469),new qf.iq(55,104.921390409),new qf.iq(56,105.916880472),new qf.iq(57,106.915666702),new qf.iq(58,107.911965339),new qf.iq(59,108.911286879),new qf.iq(60,109.907852688),new qf.iq(61,110.907735404),new qf.iq(62,111.90482081),new qf.iq(63,112.905173373),new qf.iq(64,113.902781816),new qf.iq(65,114.903345973),new qf.iq(66,115.901744149),new qf.iq(67,116.902953765),new qf.iq(68,117.901606328),new qf.iq(69,118.90330888),new qf.iq(70,119.902196571),new qf.iq(71,120.904236867),new qf.iq(72,121.903440138),new qf.iq(73,122.905721901),new qf.iq(74,123.90527463),new qf.iq(75,124.907784924),new qf.iq(76,125.907653953),new qf.iq(77,126.91035098),new qf.iq(78,127.910534953),new qf.iq(79,128.913439976),new qf.iq(80,129.913852185),new qf.iq(81,130.916919144),new qf.iq(82,131.917744455),new qf.iq(83,132.923814085),new qf.iq(84,133.928463576),new qf.iq(85,134.93473),new qf.iq(86,135.93934),new qf.iq(87,136.94579)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(52,102.94012),new qf.iq(53,103.936287),new qf.iq(54,104.931528593),new qf.iq(55,105.928183134),new qf.iq(56,106.92415),new qf.iq(57,107.92216),new qf.iq(58,108.918136092),new qf.iq(59,109.917533911),new qf.iq(60,110.912534147),new qf.iq(61,111.91239464),new qf.iq(62,112.909377941),new qf.iq(63,113.909095876),new qf.iq(64,114.906598812),new qf.iq(65,115.906797235),new qf.iq(66,116.90483959),new qf.iq(67,117.905531885),new qf.iq(68,118.90394646),new qf.iq(69,119.905074315),new qf.iq(70,120.903818044),new qf.iq(71,121.905175415),new qf.iq(72,122.904215696),new qf.iq(73,123.905937525),new qf.iq(74,124.905247804),new qf.iq(75,125.907248153),new qf.iq(76,126.906914564),new qf.iq(77,127.90916733),new qf.iq(78,128.909150092),new qf.iq(79,129.911546459),new qf.iq(80,130.911946487),new qf.iq(81,131.914413247),new qf.iq(82,132.915236466),new qf.iq(83,133.920551554),new qf.iq(84,134.925167962),new qf.iq(85,135.93066),new qf.iq(86,136.93531),new qf.iq(87,137.94096),new qf.iq(88,138.94571)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(54,105.937702),new qf.iq(55,106.935036),new qf.iq(56,107.929486838),new qf.iq(57,108.927456483),new qf.iq(58,109.922407164),new qf.iq(59,110.921120589),new qf.iq(60,111.917061617),new qf.iq(61,112.915452551),new qf.iq(62,113.912498025),new qf.iq(63,114.911578627),new qf.iq(64,115.908420253),new qf.iq(65,116.90863418),new qf.iq(66,117.905825187),new qf.iq(67,118.90640811),new qf.iq(68,119.904019891),new qf.iq(69,120.904929815),new qf.iq(70,121.903047064),new qf.iq(71,122.904272951),new qf.iq(72,123.902819466),new qf.iq(73,124.904424718),new qf.iq(74,125.903305543),new qf.iq(75,126.90521729),new qf.iq(76,127.904461383),new qf.iq(77,128.906595593),new qf.iq(78,129.906222753),new qf.iq(79,130.90852188),new qf.iq(80,131.908523782),new qf.iq(81,132.910939068),new qf.iq(82,133.911540546),new qf.iq(83,134.916450782),new qf.iq(84,135.920103155),new qf.iq(85,136.925324769),new qf.iq(86,137.92922),new qf.iq(87,138.93473),new qf.iq(88,139.9387),new qf.iq(89,140.94439),new qf.iq(90,141.9485)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(55,107.943291),new qf.iq(56,108.938191658),new qf.iq(57,109.934634181),new qf.iq(58,110.930276),new qf.iq(59,111.92797),new qf.iq(60,112.923644245),new qf.iq(61,113.92185),new qf.iq(62,114.918272),new qf.iq(63,115.916735014),new qf.iq(64,116.913647692),new qf.iq(65,117.91337523),new qf.iq(66,118.910180837),new qf.iq(67,119.910047843),new qf.iq(68,120.907366063),new qf.iq(69,121.907592451),new qf.iq(70,122.905597944),new qf.iq(71,123.906211423),new qf.iq(72,124.90462415),new qf.iq(73,125.905619387),new qf.iq(74,126.90446842),new qf.iq(75,127.905805254),new qf.iq(76,128.904987487),new qf.iq(77,129.906674018),new qf.iq(78,130.906124168),new qf.iq(79,131.907994525),new qf.iq(80,132.907806465),new qf.iq(81,133.909876552),new qf.iq(82,134.91005031),new qf.iq(83,135.914655105),new qf.iq(84,136.917872653),new qf.iq(85,137.922383666),new qf.iq(86,138.926093402),new qf.iq(87,139.93121),new qf.iq(88,140.93483),new qf.iq(89,141.94018),new qf.iq(90,142.94407),new qf.iq(91,143.94961)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(56,109.944476),new qf.iq(57,110.941632),new qf.iq(58,111.93566535),new qf.iq(59,112.933382836),new qf.iq(60,113.928145),new qf.iq(61,114.926979032),new qf.iq(62,115.921394197),new qf.iq(63,116.920564355),new qf.iq(64,117.91657092),new qf.iq(65,118.915554295),new qf.iq(66,119.91215199),new qf.iq(67,120.911386497),new qf.iq(68,121.908548396),new qf.iq(69,122.908470748),new qf.iq(70,123.905895774),new qf.iq(71,124.906398236),new qf.iq(72,125.904268868),new qf.iq(73,126.905179581),new qf.iq(74,127.903530436),new qf.iq(75,128.904779458),new qf.iq(76,129.903507903),new qf.iq(77,130.90508192),new qf.iq(78,131.904154457),new qf.iq(79,132.90590566),new qf.iq(80,133.905394504),new qf.iq(81,134.907207499),new qf.iq(82,135.907219526),new qf.iq(83,136.911562939),new qf.iq(84,137.913988549),new qf.iq(85,138.918786859),new qf.iq(86,139.921635665),new qf.iq(87,140.926646282),new qf.iq(88,141.929702981),new qf.iq(89,142.93489),new qf.iq(90,143.93823),new qf.iq(91,144.94367),new qf.iq(92,145.9473),new qf.iq(93,146.95301)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(57,111.950331),new qf.iq(58,112.944535512),new qf.iq(59,113.940841319),new qf.iq(60,114.935939),new qf.iq(61,115.932914152),new qf.iq(62,116.928639484),new qf.iq(63,117.926554883),new qf.iq(64,118.922370879),new qf.iq(65,119.920678219),new qf.iq(66,120.917183637),new qf.iq(67,121.916121946),new qf.iq(68,122.912990168),new qf.iq(69,123.912245731),new qf.iq(70,124.909724871),new qf.iq(71,125.909447953),new qf.iq(72,126.9074176),new qf.iq(73,127.907747919),new qf.iq(74,128.906063369),new qf.iq(75,129.906706163),new qf.iq(76,130.905460232),new qf.iq(77,131.906429799),new qf.iq(78,132.90544687),new qf.iq(79,133.906713419),new qf.iq(80,134.905971903),new qf.iq(81,135.907305741),new qf.iq(82,136.907083505),new qf.iq(83,137.911010537),new qf.iq(84,138.913357921),new qf.iq(85,139.917277075),new qf.iq(86,140.920043984),new qf.iq(87,141.924292317),new qf.iq(88,142.927330292),new qf.iq(89,143.932027373),new qf.iq(90,144.935388226),new qf.iq(91,145.940162028),new qf.iq(92,146.943864435),new qf.iq(93,147.948899539),new qf.iq(94,148.95272),new qf.iq(95,149.95797),new qf.iq(96,150.962)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(58,113.950941),new qf.iq(59,114.94771),new qf.iq(60,115.94168),new qf.iq(61,116.937700229),new qf.iq(62,117.93344),new qf.iq(63,118.931051927),new qf.iq(64,119.926045941),new qf.iq(65,120.924485908),new qf.iq(66,121.92026),new qf.iq(67,122.91885),new qf.iq(68,123.915088437),new qf.iq(69,124.914620234),new qf.iq(70,125.911244146),new qf.iq(71,126.911121328),new qf.iq(72,127.90830887),new qf.iq(73,128.908673749),new qf.iq(74,129.906310478),new qf.iq(75,130.906930798),new qf.iq(76,131.905056152),new qf.iq(77,132.906002368),new qf.iq(78,133.904503347),new qf.iq(79,134.905682749),new qf.iq(80,135.904570109),new qf.iq(81,136.905821414),new qf.iq(82,137.905241273),new qf.iq(83,138.908835384),new qf.iq(84,139.910599485),new qf.iq(85,140.914406439),new qf.iq(86,141.916448175),new qf.iq(87,142.920617184),new qf.iq(88,143.922940468),new qf.iq(89,144.926923807),new qf.iq(90,145.930106645),new qf.iq(91,146.933992519),new qf.iq(92,147.937682377),new qf.iq(93,148.94246),new qf.iq(94,149.94562),new qf.iq(95,150.9507),new qf.iq(96,151.95416),new qf.iq(97,152.95961)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(60,116.95001),new qf.iq(61,117.94657),new qf.iq(62,118.94099),new qf.iq(63,119.93807),new qf.iq(64,120.93301),new qf.iq(65,121.93071),new qf.iq(66,122.92624),new qf.iq(67,123.92453),new qf.iq(68,124.92067),new qf.iq(69,125.91937),new qf.iq(70,126.91616),new qf.iq(71,127.91544794),new qf.iq(72,128.912667334),new qf.iq(73,129.91232),new qf.iq(74,130.910108489),new qf.iq(75,131.910110399),new qf.iq(76,132.908396372),new qf.iq(77,133.908489607),new qf.iq(78,134.906971003),new qf.iq(79,135.907651181),new qf.iq(80,136.906465656),new qf.iq(81,137.907106826),new qf.iq(82,138.90634816),new qf.iq(83,139.909472552),new qf.iq(84,140.910957016),new qf.iq(85,141.914074489),new qf.iq(86,142.916058646),new qf.iq(87,143.919591666),new qf.iq(88,144.92163837),new qf.iq(89,145.925700146),new qf.iq(90,146.927819639),new qf.iq(91,147.932191197),new qf.iq(92,148.93437),new qf.iq(93,149.93857),new qf.iq(94,150.94156),new qf.iq(95,151.94611),new qf.iq(96,152.94945),new qf.iq(97,153.9544),new qf.iq(98,154.95813)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(61,118.95276),new qf.iq(62,119.94664),new qf.iq(63,120.94367),new qf.iq(64,121.93801),new qf.iq(65,122.93551),new qf.iq(66,123.93052),new qf.iq(67,124.92854),new qf.iq(68,125.9241),new qf.iq(69,126.92275),new qf.iq(70,127.91887),new qf.iq(71,128.918679183),new qf.iq(72,129.914339361),new qf.iq(73,130.914424137),new qf.iq(74,131.91149),new qf.iq(75,132.91155),new qf.iq(76,133.909026379),new qf.iq(77,134.909145555),new qf.iq(78,135.907143574),new qf.iq(79,136.907777634),new qf.iq(80,137.905985574),new qf.iq(81,138.906646605),new qf.iq(82,139.905434035),new qf.iq(83,140.908271103),new qf.iq(84,141.909239733),new qf.iq(85,142.912381158),new qf.iq(86,143.913642686),new qf.iq(87,144.917227871),new qf.iq(88,145.918689722),new qf.iq(89,146.922510962),new qf.iq(90,147.924394738),new qf.iq(91,148.928289207),new qf.iq(92,149.930226399),new qf.iq(93,150.93404),new qf.iq(94,151.93638),new qf.iq(95,152.94058),new qf.iq(96,153.94332),new qf.iq(97,154.94804),new qf.iq(98,155.95126),new qf.iq(99,156.95634)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(62,120.955364),new qf.iq(63,121.95165),new qf.iq(64,122.94596),new qf.iq(65,123.94296),new qf.iq(66,124.93783),new qf.iq(67,125.93531),new qf.iq(68,126.93083),new qf.iq(69,127.9288),new qf.iq(70,128.92486),new qf.iq(71,129.92338),new qf.iq(72,130.920060245),new qf.iq(73,131.91912),new qf.iq(74,132.9162),new qf.iq(75,133.915672),new qf.iq(76,134.91313914),new qf.iq(77,135.912646935),new qf.iq(78,136.910678351),new qf.iq(79,137.910748891),new qf.iq(80,138.908932181),new qf.iq(81,139.909071204),new qf.iq(82,140.907647726),new qf.iq(83,141.910039865),new qf.iq(84,142.910812233),new qf.iq(85,143.913300595),new qf.iq(86,144.914506897),new qf.iq(87,145.917588016),new qf.iq(88,146.918979001),new qf.iq(89,147.922183237),new qf.iq(90,148.923791056),new qf.iq(91,149.926995031),new qf.iq(92,150.928227869),new qf.iq(93,151.9316),new qf.iq(94,152.93365),new qf.iq(95,153.93739),new qf.iq(96,154.93999),new qf.iq(97,155.94412),new qf.iq(98,156.94717),new qf.iq(99,157.95178),new qf.iq(100,158.95523)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(66,125.94307),new qf.iq(67,126.9405),new qf.iq(68,127.93539),new qf.iq(69,128.932385),new qf.iq(70,129.92878),new qf.iq(71,130.927102697),new qf.iq(72,131.92312),new qf.iq(73,132.92221),new qf.iq(74,133.918645),new qf.iq(75,134.91824),new qf.iq(76,135.915020542),new qf.iq(77,136.91463973),new qf.iq(78,137.91291745),new qf.iq(79,138.91192415),new qf.iq(80,139.909309824),new qf.iq(81,140.9096048),new qf.iq(82,141.907718643),new qf.iq(83,142.909809626),new qf.iq(84,143.910082629),new qf.iq(85,144.912568847),new qf.iq(86,145.913112139),new qf.iq(87,146.916095794),new qf.iq(88,147.916888516),new qf.iq(89,148.92014419),new qf.iq(90,149.920886563),new qf.iq(91,150.923824739),new qf.iq(92,151.924682428),new qf.iq(93,152.927694534),new qf.iq(94,153.929483295),new qf.iq(95,154.932629551),new qf.iq(96,155.9352),new qf.iq(97,156.93927),new qf.iq(98,157.94187),new qf.iq(99,158.94639),new qf.iq(100,159.94939),new qf.iq(101,160.95433)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(67,127.94826),new qf.iq(68,128.94316),new qf.iq(69,129.94045),new qf.iq(70,130.9358),new qf.iq(71,131.93375),new qf.iq(72,132.92972),new qf.iq(73,133.92849),new qf.iq(74,134.924617),new qf.iq(75,135.923447865),new qf.iq(76,136.920713),new qf.iq(77,137.920432261),new qf.iq(78,138.916759814),new qf.iq(79,139.915801649),new qf.iq(80,140.913606636),new qf.iq(81,141.912950738),new qf.iq(82,142.910927571),new qf.iq(83,143.912585768),new qf.iq(84,144.912743879),new qf.iq(85,145.914692165),new qf.iq(86,146.915133898),new qf.iq(87,147.917467786),new qf.iq(88,148.918329195),new qf.iq(89,149.920979477),new qf.iq(90,150.921202693),new qf.iq(91,151.923490557),new qf.iq(92,152.924113189),new qf.iq(93,153.926547019),new qf.iq(94,154.928097047),new qf.iq(95,155.931060357),new qf.iq(96,156.9332),new qf.iq(97,157.93669),new qf.iq(98,158.93913),new qf.iq(99,159.94299),new qf.iq(100,160.94586),new qf.iq(101,161.95029),new qf.iq(102,162.95352)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(68,129.94863),new qf.iq(69,130.94589),new qf.iq(70,131.94082),new qf.iq(71,132.93873),new qf.iq(72,133.93402),new qf.iq(73,134.93235),new qf.iq(74,135.9283),new qf.iq(75,136.927046709),new qf.iq(76,137.92354),new qf.iq(77,138.922302),new qf.iq(78,139.918991),new qf.iq(79,140.918468512),new qf.iq(80,141.915193274),new qf.iq(81,142.914623555),new qf.iq(82,143.91199473),new qf.iq(83,144.913405611),new qf.iq(84,145.91303676),new qf.iq(85,146.914893275),new qf.iq(86,147.914817914),new qf.iq(87,148.917179521),new qf.iq(88,149.917271454),new qf.iq(89,150.919928351),new qf.iq(90,151.919728244),new qf.iq(91,152.922093907),new qf.iq(92,153.922205303),new qf.iq(93,154.92463594),new qf.iq(94,155.925526236),new qf.iq(95,156.928354506),new qf.iq(96,157.929987938),new qf.iq(97,158.9332),new qf.iq(98,159.93514),new qf.iq(99,160.93883),new qf.iq(100,161.94122),new qf.iq(101,162.94536),new qf.iq(102,163.94828),new qf.iq(103,164.95298)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(69,131.95416),new qf.iq(70,132.9489),new qf.iq(71,133.94632),new qf.iq(72,134.94172),new qf.iq(73,135.9395),new qf.iq(74,136.93521),new qf.iq(75,137.93345),new qf.iq(76,138.92882915),new qf.iq(77,139.928083921),new qf.iq(78,140.924885867),new qf.iq(79,141.923400033),new qf.iq(80,142.920286634),new qf.iq(81,143.918774116),new qf.iq(82,144.916261285),new qf.iq(83,145.917199714),new qf.iq(84,146.916741206),new qf.iq(85,147.918153775),new qf.iq(86,148.917925922),new qf.iq(87,149.919698294),new qf.iq(88,150.919846022),new qf.iq(89,151.921740399),new qf.iq(90,152.921226219),new qf.iq(91,153.922975386),new qf.iq(92,154.922889429),new qf.iq(93,155.924750855),new qf.iq(94,156.925419435),new qf.iq(95,157.927841923),new qf.iq(96,158.9290845),new qf.iq(97,159.931460406),new qf.iq(98,160.93368),new qf.iq(99,161.93704),new qf.iq(100,162.93921),new qf.iq(101,163.94299),new qf.iq(102,164.94572),new qf.iq(103,165.94997),new qf.iq(104,166.95305)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(72,135.94707),new qf.iq(73,136.94465),new qf.iq(74,137.93997),new qf.iq(75,138.93808),new qf.iq(76,139.933236934),new qf.iq(77,140.93221),new qf.iq(78,141.927908919),new qf.iq(79,142.926738636),new qf.iq(80,143.923390357),new qf.iq(81,144.921687498),new qf.iq(82,145.918305344),new qf.iq(83,146.919089446),new qf.iq(84,147.918109771),new qf.iq(85,148.919336427),new qf.iq(86,149.918655455),new qf.iq(87,150.920344273),new qf.iq(88,151.919787882),new qf.iq(89,152.921746283),new qf.iq(90,153.920862271),new qf.iq(91,154.922618801),new qf.iq(92,155.922119552),new qf.iq(93,156.923956686),new qf.iq(94,157.924100533),new qf.iq(95,158.926385075),new qf.iq(96,159.927050616),new qf.iq(97,160.929665688),new qf.iq(98,161.930981211),new qf.iq(99,162.93399),new qf.iq(100,163.93586),new qf.iq(101,164.93938),new qf.iq(102,165.9416),new qf.iq(103,166.94557),new qf.iq(104,167.94836),new qf.iq(105,168.95287)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(73,137.95287),new qf.iq(74,138.94803),new qf.iq(75,139.945367985),new qf.iq(76,140.94116),new qf.iq(77,141.939073781),new qf.iq(78,142.93475),new qf.iq(79,143.93253),new qf.iq(80,144.92888),new qf.iq(81,145.927180629),new qf.iq(82,146.924037176),new qf.iq(83,147.924298636),new qf.iq(84,148.92324163),new qf.iq(85,149.923654158),new qf.iq(86,150.923098169),new qf.iq(87,151.924071324),new qf.iq(88,152.923430858),new qf.iq(89,153.924686236),new qf.iq(90,154.923500411),new qf.iq(91,155.924743749),new qf.iq(92,156.924021155),new qf.iq(93,157.92541026),new qf.iq(94,158.925343135),new qf.iq(95,159.927164021),new qf.iq(96,160.927566289),new qf.iq(97,161.929484803),new qf.iq(98,162.930643942),new qf.iq(99,163.933347253),new qf.iq(100,164.93488),new qf.iq(101,165.93805),new qf.iq(102,166.94005),new qf.iq(103,167.94364),new qf.iq(104,168.94622),new qf.iq(105,169.95025),new qf.iq(106,170.9533)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(74,139.95379),new qf.iq(75,140.95119),new qf.iq(76,141.946695946),new qf.iq(77,142.94383),new qf.iq(78,143.93907),new qf.iq(79,144.936717),new qf.iq(80,145.932720118),new qf.iq(81,146.930878496),new qf.iq(82,147.927177882),new qf.iq(83,148.927333981),new qf.iq(84,149.925579728),new qf.iq(85,150.92617963),new qf.iq(86,151.924713874),new qf.iq(87,152.925760865),new qf.iq(88,153.924422046),new qf.iq(89,154.92574895),new qf.iq(90,155.924278273),new qf.iq(91,156.925461256),new qf.iq(92,157.924404637),new qf.iq(93,158.92573566),new qf.iq(94,159.925193718),new qf.iq(95,160.926929595),new qf.iq(96,161.926794731),new qf.iq(97,162.928727532),new qf.iq(98,163.929171165),new qf.iq(99,164.931699828),new qf.iq(100,165.932803241),new qf.iq(101,166.935649025),new qf.iq(102,167.93723),new qf.iq(103,168.940303648),new qf.iq(104,169.94267),new qf.iq(105,170.94648),new qf.iq(106,171.94911),new qf.iq(107,172.95344)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(75,141.95986),new qf.iq(76,142.95469),new qf.iq(77,143.95164),new qf.iq(78,144.94688),new qf.iq(79,145.9441),new qf.iq(80,146.93984),new qf.iq(81,147.937269),new qf.iq(82,148.933789944),new qf.iq(83,149.932760914),new qf.iq(84,150.931680791),new qf.iq(85,151.931740598),new qf.iq(86,152.930194506),new qf.iq(87,153.930596268),new qf.iq(88,154.929079084),new qf.iq(89,155.929001869),new qf.iq(90,156.928188059),new qf.iq(91,157.92894573),new qf.iq(92,158.927708537),new qf.iq(93,159.928725679),new qf.iq(94,160.927851662),new qf.iq(95,161.92909242),new qf.iq(96,162.928730286),new qf.iq(97,163.930230577),new qf.iq(98,164.930319169),new qf.iq(99,165.932281267),new qf.iq(100,166.933126195),new qf.iq(101,167.935496424),new qf.iq(102,168.936868306),new qf.iq(103,169.939614951),new qf.iq(104,170.941461227),new qf.iq(105,171.94482),new qf.iq(106,172.94729),new qf.iq(107,173.95115),new qf.iq(108,174.95405)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(76,143.96059),new qf.iq(77,144.95746),new qf.iq(78,145.95212),new qf.iq(79,146.94931),new qf.iq(80,147.94444),new qf.iq(81,148.942780527),new qf.iq(82,149.937171034),new qf.iq(83,150.93746),new qf.iq(84,151.935078452),new qf.iq(85,152.935093125),new qf.iq(86,153.932777294),new qf.iq(87,154.933204273),new qf.iq(88,155.931015001),new qf.iq(89,156.931945517),new qf.iq(90,157.929912),new qf.iq(91,158.930680718),new qf.iq(92,159.929078924),new qf.iq(93,160.930001348),new qf.iq(94,161.928774923),new qf.iq(95,162.930029273),new qf.iq(96,163.929196996),new qf.iq(97,164.9307228),new qf.iq(98,165.93028997),new qf.iq(99,166.932045448),new qf.iq(100,167.932367781),new qf.iq(101,168.934588082),new qf.iq(102,169.935460334),new qf.iq(103,170.938025885),new qf.iq(104,171.939352149),new qf.iq(105,172.9424),new qf.iq(106,173.94434),new qf.iq(107,174.94793),new qf.iq(108,175.95029),new qf.iq(109,176.95437)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(77,145.966495),new qf.iq(78,146.961081),new qf.iq(79,147.95755),new qf.iq(80,148.95265),new qf.iq(81,149.94967),new qf.iq(82,150.944842),new qf.iq(83,151.9443),new qf.iq(84,152.942027631),new qf.iq(85,153.940832325),new qf.iq(86,154.939191562),new qf.iq(87,155.939006895),new qf.iq(88,156.936756069),new qf.iq(89,157.936996),new qf.iq(90,158.934808966),new qf.iq(91,159.935090772),new qf.iq(92,160.933398042),new qf.iq(93,161.933970147),new qf.iq(94,162.932647648),new qf.iq(95,163.933450972),new qf.iq(96,164.932432463),new qf.iq(97,165.933553133),new qf.iq(98,166.932848844),new qf.iq(99,167.934170375),new qf.iq(100,168.934211117),new qf.iq(101,169.935797877),new qf.iq(102,170.936425817),new qf.iq(103,171.938396118),new qf.iq(104,172.939600336),new qf.iq(105,173.942164618),new qf.iq(106,174.943832897),new qf.iq(107,175.946991412),new qf.iq(108,176.94904),new qf.iq(109,177.95264),new qf.iq(110,178.95534)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(78,147.96676),new qf.iq(79,148.96348),new qf.iq(80,149.95799),new qf.iq(81,150.954657965),new qf.iq(82,151.950167),new qf.iq(83,152.94921),new qf.iq(84,153.945651145),new qf.iq(85,154.945792),new qf.iq(86,155.942847109),new qf.iq(87,156.94265865),new qf.iq(88,157.939857897),new qf.iq(89,158.940153735),new qf.iq(90,159.93756),new qf.iq(91,160.937357719),new qf.iq(92,161.93575),new qf.iq(93,162.936265492),new qf.iq(94,163.93452),new qf.iq(95,164.935397592),new qf.iq(96,165.933879623),new qf.iq(97,166.934946862),new qf.iq(98,167.933894465),new qf.iq(99,168.93518712),new qf.iq(100,169.934758652),new qf.iq(101,170.936322297),new qf.iq(102,171.936377696),new qf.iq(103,172.938206756),new qf.iq(104,173.938858101),new qf.iq(105,174.941272494),new qf.iq(106,175.942568409),new qf.iq(107,176.945257126),new qf.iq(108,177.946643396),new qf.iq(109,178.95017),new qf.iq(110,179.95233),new qf.iq(111,180.95615)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(79,149.972668),new qf.iq(80,150.967147),new qf.iq(81,151.96361),new qf.iq(82,152.95869),new qf.iq(83,153.9571),new qf.iq(84,154.953641324),new qf.iq(85,155.952907),new qf.iq(86,156.950101536),new qf.iq(87,157.948577981),new qf.iq(88,158.946615113),new qf.iq(89,159.945383),new qf.iq(90,160.943047504),new qf.iq(91,161.943222),new qf.iq(92,162.941203796),new qf.iq(93,163.941215),new qf.iq(94,164.939605886),new qf.iq(95,165.939762646),new qf.iq(96,166.938307056),new qf.iq(97,167.938698576),new qf.iq(98,168.937648757),new qf.iq(99,169.93847219),new qf.iq(100,170.937909903),new qf.iq(101,171.939082239),new qf.iq(102,172.938926901),new qf.iq(103,173.940333522),new qf.iq(104,174.940767904),new qf.iq(105,175.942682399),new qf.iq(106,176.943754987),new qf.iq(107,177.945951366),new qf.iq(108,178.947324216),new qf.iq(109,179.949879968),new qf.iq(110,180.95197),new qf.iq(111,181.95521),new qf.iq(112,182.95757),new qf.iq(113,183.96117)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(82,153.96425),new qf.iq(83,154.96276),new qf.iq(84,155.959247),new qf.iq(85,156.958127),new qf.iq(86,157.95405528),new qf.iq(87,158.954003),new qf.iq(88,159.950713588),new qf.iq(89,160.950330852),new qf.iq(90,161.947202977),new qf.iq(91,162.947057),new qf.iq(92,163.944422),new qf.iq(93,164.94454),new qf.iq(94,165.94225),new qf.iq(95,166.9426),new qf.iq(96,167.94063),new qf.iq(97,168.941158567),new qf.iq(98,169.93965),new qf.iq(99,170.94049),new qf.iq(100,171.93945798),new qf.iq(101,172.94065),new qf.iq(102,173.940040159),new qf.iq(103,174.941502991),new qf.iq(104,175.941401828),new qf.iq(105,176.943220013),new qf.iq(106,177.943697732),new qf.iq(107,178.945815073),new qf.iq(108,179.94654876),new qf.iq(109,180.949099124),new qf.iq(110,181.950552893),new qf.iq(111,182.953531012),new qf.iq(112,183.95544788),new qf.iq(113,184.95878),new qf.iq(114,185.96092)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(83,155.971689),new qf.iq(84,156.968145),new qf.iq(85,157.966368),new qf.iq(86,158.96232309),new qf.iq(87,159.961358),new qf.iq(88,160.958372992),new qf.iq(89,161.956556553),new qf.iq(90,162.95431665),new qf.iq(91,163.95357),new qf.iq(92,164.950817),new qf.iq(93,165.95047),new qf.iq(94,166.948639),new qf.iq(95,167.947787),new qf.iq(96,168.94592),new qf.iq(97,169.94609),new qf.iq(98,170.94446),new qf.iq(99,171.944739818),new qf.iq(100,172.94459),new qf.iq(101,173.944167937),new qf.iq(102,174.94365),new qf.iq(103,175.944740551),new qf.iq(104,176.944471766),new qf.iq(105,177.945750349),new qf.iq(106,178.945934113),new qf.iq(107,179.947465655),new qf.iq(108,180.947996346),new qf.iq(109,181.950152414),new qf.iq(110,182.951373188),new qf.iq(111,183.954009331),new qf.iq(112,184.955559086),new qf.iq(113,185.9585501),new qf.iq(114,186.96041),new qf.iq(115,187.96371)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(84,157.973939),new qf.iq(85,158.97228),new qf.iq(86,159.968369),new qf.iq(87,160.967089),new qf.iq(88,161.962750303),new qf.iq(89,162.962532),new qf.iq(90,163.95898381),new qf.iq(91,164.958335962),new qf.iq(92,165.955019896),new qf.iq(93,166.954672),new qf.iq(94,167.951863),new qf.iq(95,168.951759),new qf.iq(96,169.948473988),new qf.iq(97,170.94946),new qf.iq(98,171.948228837),new qf.iq(99,172.948884),new qf.iq(100,173.94616),new qf.iq(101,174.94677),new qf.iq(102,175.94559),new qf.iq(103,176.94662),new qf.iq(104,177.945848364),new qf.iq(105,178.947071733),new qf.iq(106,179.946705734),new qf.iq(107,180.948198054),new qf.iq(108,181.948205519),new qf.iq(109,182.950224458),new qf.iq(110,183.950932553),new qf.iq(111,184.953420586),new qf.iq(112,185.954362204),new qf.iq(113,186.957158365),new qf.iq(114,187.958486954),new qf.iq(115,188.96191222),new qf.iq(116,189.963179541)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(85,159.981485),new qf.iq(86,160.977661),new qf.iq(87,161.975707),new qf.iq(88,162.971375872),new qf.iq(89,163.970319),new qf.iq(90,164.967050268),new qf.iq(91,165.965211372),new qf.iq(92,166.962564),new qf.iq(93,167.961609),new qf.iq(94,168.95883),new qf.iq(95,169.958163),new qf.iq(96,170.955547),new qf.iq(97,171.955285),new qf.iq(98,172.953062),new qf.iq(99,173.952114),new qf.iq(100,174.951393),new qf.iq(101,175.95157),new qf.iq(102,176.95027),new qf.iq(103,177.950851081),new qf.iq(104,178.949981038),new qf.iq(105,179.95078768),new qf.iq(106,180.950064596),new qf.iq(107,181.951211444),new qf.iq(108,182.950821349),new qf.iq(109,183.952524289),new qf.iq(110,184.952955747),new qf.iq(111,185.954986529),new qf.iq(112,186.955750787),new qf.iq(113,187.958112287),new qf.iq(114,188.959228359),new qf.iq(115,189.961816139),new qf.iq(116,190.963123592),new qf.iq(117,191.96596)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(86,161.983819),new qf.iq(87,162.982048),new qf.iq(88,163.977927),new qf.iq(89,164.976475),new qf.iq(90,165.971934911),new qf.iq(91,166.971554),new qf.iq(92,167.967832911),new qf.iq(93,168.967076205),new qf.iq(94,169.963569716),new qf.iq(95,170.96304),new qf.iq(96,171.960078),new qf.iq(97,172.959791),new qf.iq(98,173.956307704),new qf.iq(99,174.95708),new qf.iq(100,175.953757941),new qf.iq(101,176.955045),new qf.iq(102,177.953348225),new qf.iq(103,178.953951),new qf.iq(104,179.952308241),new qf.iq(105,180.953274494),new qf.iq(106,181.952186222),new qf.iq(107,182.95311),new qf.iq(108,183.952490808),new qf.iq(109,184.954043023),new qf.iq(110,185.953838355),new qf.iq(111,186.955747928),new qf.iq(112,187.955835993),new qf.iq(113,188.958144866),new qf.iq(114,189.95844521),new qf.iq(115,190.960927951),new qf.iq(116,191.961479047),new qf.iq(117,192.964148083),new qf.iq(118,193.965179314),new qf.iq(119,194.968123889),new qf.iq(120,195.96962255)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(88,164.98758),new qf.iq(89,165.985506),new qf.iq(90,166.980951577),new qf.iq(91,167.979966),new qf.iq(92,168.976390868),new qf.iq(93,169.974441697),new qf.iq(94,170.971779),new qf.iq(95,171.970643),new qf.iq(96,172.967707),new qf.iq(97,173.966804),new qf.iq(98,174.964279),new qf.iq(99,175.963511),new qf.iq(100,176.96117),new qf.iq(101,177.960084944),new qf.iq(102,178.95915),new qf.iq(103,179.958555615),new qf.iq(104,180.957642156),new qf.iq(105,181.958127689),new qf.iq(106,182.956814),new qf.iq(107,183.957388318),new qf.iq(108,184.95659),new qf.iq(109,185.957951104),new qf.iq(110,186.95736083),new qf.iq(111,187.958851962),new qf.iq(112,188.958716473),new qf.iq(113,189.960592299),new qf.iq(114,190.960591191),new qf.iq(115,191.962602198),new qf.iq(116,192.9629237),new qf.iq(117,193.96507561),new qf.iq(118,194.9659768),new qf.iq(119,195.968379906),new qf.iq(120,196.969636496),new qf.iq(121,197.97228),new qf.iq(122,198.973787159)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(90,167.988035),new qf.iq(91,168.986421),new qf.iq(92,169.981734918),new qf.iq(93,170.981251),new qf.iq(94,171.977376138),new qf.iq(95,172.976499642),new qf.iq(96,173.972811276),new qf.iq(97,174.972276),new qf.iq(98,175.969),new qf.iq(99,176.968453),new qf.iq(100,177.964894223),new qf.iq(101,178.965475),new qf.iq(102,179.962023729),new qf.iq(103,180.963177),new qf.iq(104,181.961267637),new qf.iq(105,182.961729),new qf.iq(106,183.959851685),new qf.iq(107,184.960753782),new qf.iq(108,185.959432346),new qf.iq(109,186.960697),new qf.iq(110,187.959395697),new qf.iq(111,188.9608319),new qf.iq(112,189.959930073),new qf.iq(113,190.961684653),new qf.iq(114,191.961035158),new qf.iq(115,192.962984504),new qf.iq(116,193.962663581),new qf.iq(117,194.964774449),new qf.iq(118,195.964934884),new qf.iq(119,196.967323401),new qf.iq(120,197.967876009),new qf.iq(121,198.970576213),new qf.iq(122,199.971423885),new qf.iq(123,200.974496467),new qf.iq(124,201.97574)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(92,170.991183),new qf.iq(93,171.990109),new qf.iq(94,172.986398138),new qf.iq(95,173.984325861),new qf.iq(96,174.981552),new qf.iq(97,175.980269),new qf.iq(98,176.977215),new qf.iq(99,177.975975),new qf.iq(100,178.973412),new qf.iq(101,179.972396),new qf.iq(102,180.969948),new qf.iq(103,181.968621416),new qf.iq(104,182.96762),new qf.iq(105,183.966776046),new qf.iq(106,184.965806956),new qf.iq(107,185.965997671),new qf.iq(108,186.964562),new qf.iq(109,187.965321662),new qf.iq(110,188.9642243),new qf.iq(111,189.964698757),new qf.iq(112,190.963649239),new qf.iq(113,191.964810107),new qf.iq(114,192.964131745),new qf.iq(115,193.96533889),new qf.iq(116,194.965017928),new qf.iq(117,195.966551315),new qf.iq(118,196.966551609),new qf.iq(119,197.968225244),new qf.iq(120,198.968748016),new qf.iq(121,199.970717886),new qf.iq(122,200.971640839),new qf.iq(123,201.973788431),new qf.iq(124,202.975137256),new qf.iq(125,203.977705),new qf.iq(126,204.97961)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(95,174.991411),new qf.iq(96,175.987413248),new qf.iq(97,176.986336874),new qf.iq(98,177.982476325),new qf.iq(99,178.981783),new qf.iq(100,179.978322),new qf.iq(101,180.977806),new qf.iq(102,181.97393546),new qf.iq(103,182.974561),new qf.iq(104,183.970705219),new qf.iq(105,184.971983),new qf.iq(106,185.969460021),new qf.iq(107,186.969785),new qf.iq(108,187.967511693),new qf.iq(109,188.968733187),new qf.iq(110,189.966958568),new qf.iq(111,190.96706311),new qf.iq(112,191.965921572),new qf.iq(113,192.966644169),new qf.iq(114,193.965381832),new qf.iq(115,194.966638981),new qf.iq(116,195.965814846),new qf.iq(117,196.967195333),new qf.iq(118,197.96675183),new qf.iq(119,198.968262489),new qf.iq(120,199.968308726),new qf.iq(121,200.970285275),new qf.iq(122,201.970625604),new qf.iq(123,202.972857096),new qf.iq(124,203.97347564),new qf.iq(125,204.976056104),new qf.iq(126,205.977498672),new qf.iq(127,206.982577025),new qf.iq(128,207.98594)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(96,176.996881),new qf.iq(97,177.994637),new qf.iq(98,178.991466),new qf.iq(99,179.990194),new qf.iq(100,180.986904),new qf.iq(101,181.98561),new qf.iq(102,182.982697),new qf.iq(103,183.98176),new qf.iq(104,184.9791),new qf.iq(105,185.977549881),new qf.iq(106,186.97617),new qf.iq(107,187.97592),new qf.iq(108,188.974290451),new qf.iq(109,189.974473379),new qf.iq(110,190.972261952),new qf.iq(111,191.972770785),new qf.iq(112,192.970548),new qf.iq(113,193.971053),new qf.iq(114,194.96965),new qf.iq(115,195.970515),new qf.iq(116,196.9695362),new qf.iq(117,197.970466294),new qf.iq(118,198.969813837),new qf.iq(119,199.970945394),new qf.iq(120,200.97080377),new qf.iq(121,201.972090569),new qf.iq(122,202.972329088),new qf.iq(123,203.973848646),new qf.iq(124,204.97441227),new qf.iq(125,205.976095321),new qf.iq(126,206.977407908),new qf.iq(127,207.982004653),new qf.iq(128,208.985349125),new qf.iq(129,209.990065574)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(99,180.996714),new qf.iq(100,181.992676101),new qf.iq(101,182.99193),new qf.iq(102,183.988198),new qf.iq(103,184.98758),new qf.iq(104,185.983485388),new qf.iq(105,186.98403),new qf.iq(106,187.979869108),new qf.iq(107,188.98088),new qf.iq(108,189.978180008),new qf.iq(109,190.9782),new qf.iq(110,191.975719811),new qf.iq(111,192.97608),new qf.iq(112,193.974648056),new qf.iq(113,194.975920279),new qf.iq(114,195.97271),new qf.iq(115,196.97338),new qf.iq(116,197.97198),new qf.iq(117,198.972909384),new qf.iq(118,199.97181556),new qf.iq(119,200.972846589),new qf.iq(120,201.972143786),new qf.iq(121,202.973375491),new qf.iq(122,203.973028761),new qf.iq(123,204.974467112),new qf.iq(124,205.974449002),new qf.iq(125,206.975880605),new qf.iq(126,207.97663585),new qf.iq(127,208.981074801),new qf.iq(128,209.984173129),new qf.iq(129,210.988731474),new qf.iq(130,211.991887495),new qf.iq(131,212.9965),new qf.iq(132,213.999798147)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(102,184.997708),new qf.iq(103,185.99648),new qf.iq(104,186.993458),new qf.iq(105,187.992173),new qf.iq(106,188.989505),new qf.iq(107,189.987520007),new qf.iq(108,190.986053),new qf.iq(109,191.985368),new qf.iq(110,192.983662229),new qf.iq(111,193.983430186),new qf.iq(112,194.98112697),new qf.iq(113,195.981236107),new qf.iq(114,196.978934287),new qf.iq(115,197.979024396),new qf.iq(116,198.977576953),new qf.iq(117,199.978141983),new qf.iq(118,200.976970721),new qf.iq(119,201.977674504),new qf.iq(120,202.976868118),new qf.iq(121,203.977805161),new qf.iq(122,204.977374688),new qf.iq(123,205.978482854),new qf.iq(124,206.978455217),new qf.iq(125,207.979726699),new qf.iq(126,208.980383241),new qf.iq(127,209.984104944),new qf.iq(128,210.987258139),new qf.iq(129,211.991271542),new qf.iq(130,212.994374836),new qf.iq(131,213.998698664),new qf.iq(132,215.001832349),new qf.iq(133,216.006199)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(106,189.994293888),new qf.iq(107,190.994653),new qf.iq(108,191.99033039),new qf.iq(109,192.991102),new qf.iq(110,193.988284107),new qf.iq(111,194.988045),new qf.iq(112,195.985469432),new qf.iq(113,196.985567),new qf.iq(114,197.984024384),new qf.iq(115,198.985044507),new qf.iq(116,199.981735),new qf.iq(117,200.982209),new qf.iq(118,201.980704),new qf.iq(119,202.981412863),new qf.iq(120,203.980307113),new qf.iq(121,204.981165396),new qf.iq(122,205.980465241),new qf.iq(123,206.981578228),new qf.iq(124,207.981231059),new qf.iq(125,208.982415788),new qf.iq(126,209.982857396),new qf.iq(127,210.986636869),new qf.iq(128,211.988851755),new qf.iq(129,212.992842522),new qf.iq(130,213.995185949),new qf.iq(131,214.999414609),new qf.iq(132,216.001905198),new qf.iq(133,217.006253),new qf.iq(134,218.008965773)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(108,193.000188),new qf.iq(109,193.997973),new qf.iq(110,194.996554),new qf.iq(111,195.995702),new qf.iq(112,196.993891293),new qf.iq(113,197.99343368),new qf.iq(114,198.991008569),new qf.iq(115,199.990920883),new qf.iq(116,200.988486908),new qf.iq(117,201.988448629),new qf.iq(118,202.986847216),new qf.iq(119,203.987261559),new qf.iq(120,204.986036352),new qf.iq(121,205.986599242),new qf.iq(122,206.985775861),new qf.iq(123,207.986582508),new qf.iq(124,208.986158678),new qf.iq(125,209.987131308),new qf.iq(126,210.987480806),new qf.iq(127,211.990734657),new qf.iq(128,212.99292115),new qf.iq(129,213.996356412),new qf.iq(130,214.998641245),new qf.iq(131,216.002408839),new qf.iq(132,217.004709619),new qf.iq(133,218.008681458),new qf.iq(134,219.011296478),new qf.iq(135,220.015301),new qf.iq(136,221.01814),new qf.iq(137,222.02233),new qf.iq(138,223.02534)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(110,196.001117268),new qf.iq(111,197.001661),new qf.iq(112,197.998779978),new qf.iq(113,198.998309),new qf.iq(114,199.995634148),new qf.iq(115,200.995535),new qf.iq(116,201.993899382),new qf.iq(117,202.994765192),new qf.iq(118,203.991365),new qf.iq(119,204.991668),new qf.iq(120,205.99016),new qf.iq(121,206.990726826),new qf.iq(122,207.989631237),new qf.iq(123,208.990376634),new qf.iq(124,209.989679862),new qf.iq(125,210.99058541),new qf.iq(126,211.990688899),new qf.iq(127,212.993868354),new qf.iq(128,213.995346275),new qf.iq(129,214.998729195),new qf.iq(130,216.000258153),new qf.iq(131,217.003914555),new qf.iq(132,218.005586315),new qf.iq(133,219.009474831),new qf.iq(134,220.011384149),new qf.iq(135,221.015455),new qf.iq(136,222.017570472),new qf.iq(137,223.02179),new qf.iq(138,224.02409),new qf.iq(139,225.02844),new qf.iq(140,226.03089),new qf.iq(141,227.035407),new qf.iq(142,228.038084)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(113,200.006499),new qf.iq(114,201.00458692),new qf.iq(115,202.00396885),new qf.iq(116,203.001423829),new qf.iq(117,204.001221209),new qf.iq(118,204.998663961),new qf.iq(119,205.998486886),new qf.iq(120,206.996859385),new qf.iq(121,207.997133849),new qf.iq(122,208.995915421),new qf.iq(123,209.996398327),new qf.iq(124,210.995529332),new qf.iq(125,211.996194988),new qf.iq(126,212.996174845),new qf.iq(127,213.99895474),new qf.iq(128,215.000326029),new qf.iq(129,216.003187873),new qf.iq(130,217.004616452),new qf.iq(131,218.007563326),new qf.iq(132,219.009240843),new qf.iq(133,220.012312978),new qf.iq(134,221.014245654),new qf.iq(135,222.017543957),new qf.iq(136,223.019730712),new qf.iq(137,224.023235513),new qf.iq(138,225.025606914),new qf.iq(139,226.029343423),new qf.iq(140,227.031833167),new qf.iq(141,228.034776087),new qf.iq(142,229.038426),new qf.iq(143,230.04251),new qf.iq(144,231.045407),new qf.iq(145,232.049654)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(115,203.00921),new qf.iq(116,204.006434513),new qf.iq(117,205.006187),new qf.iq(118,206.004463814),new qf.iq(119,207.005176607),new qf.iq(120,208.001776),new qf.iq(121,209.001944),new qf.iq(122,210.000446),new qf.iq(123,211.000893996),new qf.iq(124,211.999783492),new qf.iq(125,213.000345847),new qf.iq(126,214.000091141),new qf.iq(127,215.002704195),new qf.iq(128,216.003518402),new qf.iq(129,217.00630601),new qf.iq(130,218.007123948),new qf.iq(131,219.010068787),new qf.iq(132,220.011014669),new qf.iq(133,221.013907762),new qf.iq(134,222.01536182),new qf.iq(135,223.01849714),new qf.iq(136,224.020202004),new qf.iq(137,225.023604463),new qf.iq(138,226.025402555),new qf.iq(139,227.029170677),new qf.iq(140,228.031064101),new qf.iq(141,229.034820309),new qf.iq(142,230.037084774),new qf.iq(143,231.04122),new qf.iq(144,232.043693),new qf.iq(145,233.047995),new qf.iq(146,234.050547)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(118,207.012469754),new qf.iq(119,208.012112949),new qf.iq(120,209.009568736),new qf.iq(121,210.009256802),new qf.iq(122,211.007648196),new qf.iq(123,212.007811441),new qf.iq(124,213.006573689),new qf.iq(125,214.006893072),new qf.iq(126,215.006450832),new qf.iq(127,216.008721268),new qf.iq(128,217.009332676),new qf.iq(129,218.011625045),new qf.iq(130,219.012404918),new qf.iq(131,220.014752105),new qf.iq(132,221.015575746),new qf.iq(133,222.017828852),new qf.iq(134,223.01912603),new qf.iq(135,224.021708435),new qf.iq(136,225.023220576),new qf.iq(137,226.026089848),new qf.iq(138,227.027746979),new qf.iq(139,228.031014825),new qf.iq(140,229.032930871),new qf.iq(141,230.036025144),new qf.iq(142,231.038551503),new qf.iq(143,232.042022474),new qf.iq(144,233.04455),new qf.iq(145,234.04842),new qf.iq(146,235.051102),new qf.iq(147,236.055178)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(120,210.015711883),new qf.iq(121,211.016306912),new qf.iq(122,212.012916),new qf.iq(123,213.012962),new qf.iq(124,214.011451),new qf.iq(125,215.011726597),new qf.iq(126,216.011050963),new qf.iq(127,217.013066169),new qf.iq(128,218.013267744),new qf.iq(129,219.015521253),new qf.iq(130,220.015733126),new qf.iq(131,221.018171499),new qf.iq(132,222.018454131),new qf.iq(133,223.020795153),new qf.iq(134,224.02145925),new qf.iq(135,225.023941441),new qf.iq(136,226.024890681),new qf.iq(137,227.027698859),new qf.iq(138,228.028731348),new qf.iq(139,229.03175534),new qf.iq(140,230.033126574),new qf.iq(141,231.03629706),new qf.iq(142,232.03805036),new qf.iq(143,233.041576923),new qf.iq(144,234.043595497),new qf.iq(145,235.04750442),new qf.iq(146,236.04971),new qf.iq(147,237.053894),new qf.iq(148,238.056243)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(122,213.021183209),new qf.iq(123,214.02073923),new qf.iq(124,215.019097612),new qf.iq(125,216.019109649),new qf.iq(126,217.018288571),new qf.iq(127,218.020007906),new qf.iq(128,219.019880348),new qf.iq(129,220.021876493),new qf.iq(130,221.021863742),new qf.iq(131,222.023726),new qf.iq(132,223.023963748),new qf.iq(133,224.025614854),new qf.iq(134,225.026115172),new qf.iq(135,226.02793275),new qf.iq(136,227.028793151),new qf.iq(137,228.031036942),new qf.iq(138,229.032088601),new qf.iq(139,230.034532562),new qf.iq(140,231.035878898),new qf.iq(141,232.03858172),new qf.iq(142,233.040240235),new qf.iq(143,234.043302325),new qf.iq(144,235.045436759),new qf.iq(145,236.048675176),new qf.iq(146,237.05113943),new qf.iq(147,238.054497046),new qf.iq(148,239.05713),new qf.iq(149,240.06098)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(126,218.023487),new qf.iq(127,219.024915423),new qf.iq(128,220.024712),new qf.iq(129,221.026351),new qf.iq(130,222.02607),new qf.iq(131,223.027722956),new qf.iq(132,224.027590139),new qf.iq(133,225.029384369),new qf.iq(134,226.02933975),new qf.iq(135,227.031140069),new qf.iq(136,228.031366357),new qf.iq(137,229.033496137),new qf.iq(138,230.033927392),new qf.iq(139,231.036289158),new qf.iq(140,232.03714628),new qf.iq(141,233.039628196),new qf.iq(142,234.040945606),new qf.iq(143,235.043923062),new qf.iq(144,236.045561897),new qf.iq(145,237.048723955),new qf.iq(146,238.050782583),new qf.iq(147,239.054287777),new qf.iq(148,240.056585734),new qf.iq(149,241.06033),new qf.iq(150,242.062925)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(132,225.033899689),new qf.iq(133,226.035129),new qf.iq(134,227.034958261),new qf.iq(135,228.03618),new qf.iq(136,229.036246866),new qf.iq(137,230.037812591),new qf.iq(138,231.038233161),new qf.iq(139,232.040099),new qf.iq(140,233.04073235),new qf.iq(141,234.042888556),new qf.iq(142,235.044055876),new qf.iq(143,236.046559724),new qf.iq(144,237.048167253),new qf.iq(145,238.050940464),new qf.iq(146,239.052931399),new qf.iq(147,240.056168828),new qf.iq(148,241.058246266),new qf.iq(149,242.061635),new qf.iq(150,243.064273),new qf.iq(151,244.06785)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(134,228.038727686),new qf.iq(135,229.040138934),new qf.iq(136,230.039645603),new qf.iq(137,231.041258),new qf.iq(138,232.041179445),new qf.iq(139,233.04298757),new qf.iq(140,234.043304681),new qf.iq(141,235.0452815),new qf.iq(142,236.046048088),new qf.iq(143,237.048403774),new qf.iq(144,238.0495534),new qf.iq(145,239.052156519),new qf.iq(146,240.05380746),new qf.iq(147,241.056845291),new qf.iq(148,242.058736847),new qf.iq(149,243.061997013),new qf.iq(150,244.06419765),new qf.iq(151,245.067738657),new qf.iq(152,246.070198429),new qf.iq(153,247.07407)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(136,231.04556),new qf.iq(137,232.04659),new qf.iq(138,233.046472),new qf.iq(139,234.047794),new qf.iq(140,235.048029),new qf.iq(141,236.049569),new qf.iq(142,237.049970748),new qf.iq(143,238.051977839),new qf.iq(144,239.053018481),new qf.iq(145,240.055287826),new qf.iq(146,241.056822944),new qf.iq(147,242.059543039),new qf.iq(148,243.061372686),new qf.iq(149,244.064279429),new qf.iq(150,245.066445398),new qf.iq(151,246.069768438),new qf.iq(152,247.072086),new qf.iq(153,248.075745),new qf.iq(154,249.07848)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(137,233.0508),new qf.iq(138,234.05024),new qf.iq(139,235.051591),new qf.iq(140,236.051405),new qf.iq(141,237.052891),new qf.iq(142,238.053016298),new qf.iq(143,239.054951),new qf.iq(144,240.055519046),new qf.iq(145,241.057646736),new qf.iq(146,242.058829326),new qf.iq(147,243.061382249),new qf.iq(148,244.062746349),new qf.iq(149,245.065485586),new qf.iq(150,246.067217551),new qf.iq(151,247.070346811),new qf.iq(152,248.072342247),new qf.iq(153,249.075947062),new qf.iq(154,250.078350687),new qf.iq(155,251.082277873),new qf.iq(156,252.08487)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(138,235.05658),new qf.iq(139,236.05733),new qf.iq(140,237.057127),new qf.iq(141,238.058266),new qf.iq(142,239.058362),new qf.iq(143,240.059749),new qf.iq(144,241.060223),new qf.iq(145,242.06205),new qf.iq(146,243.06300157),new qf.iq(147,244.065167882),new qf.iq(148,245.066355386),new qf.iq(149,246.068666836),new qf.iq(150,247.070298533),new qf.iq(151,248.07308),new qf.iq(152,249.074979937),new qf.iq(153,250.078310529),new qf.iq(154,251.08075344),new qf.iq(155,252.084303),new qf.iq(156,253.08688),new qf.iq(157,254.0906)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(139,237.06207),new qf.iq(140,238.06141),new qf.iq(141,239.062579),new qf.iq(142,240.062295),new qf.iq(143,241.063716),new qf.iq(144,242.063688713),new qf.iq(145,243.065421),new qf.iq(146,244.06599039),new qf.iq(147,245.068039),new qf.iq(148,246.068798807),new qf.iq(149,247.070992043),new qf.iq(150,248.07217808),new qf.iq(151,249.074846818),new qf.iq(152,250.076399951),new qf.iq(153,251.079580056),new qf.iq(154,252.081619582),new qf.iq(155,253.085126791),new qf.iq(156,254.087316198),new qf.iq(157,255.091039),new qf.iq(158,256.09344)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(141,240.06892),new qf.iq(142,241.068662),new qf.iq(143,242.069699),new qf.iq(144,243.069631),new qf.iq(145,244.070969),new qf.iq(146,245.071317),new qf.iq(147,246.072965),new qf.iq(148,247.07365),new qf.iq(149,248.075458),new qf.iq(150,249.076405),new qf.iq(151,250.078654),new qf.iq(152,251.079983592),new qf.iq(153,252.082972247),new qf.iq(154,253.084817974),new qf.iq(155,254.088016026),new qf.iq(156,255.090266386),new qf.iq(157,256.093592),new qf.iq(158,257.095979)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(142,242.07343),new qf.iq(143,243.07451),new qf.iq(144,244.074077),new qf.iq(145,245.075375),new qf.iq(146,246.075281634),new qf.iq(147,247.076819),new qf.iq(148,248.077184411),new qf.iq(149,249.079024),new qf.iq(150,250.079514759),new qf.iq(151,251.081566467),new qf.iq(152,252.082460071),new qf.iq(153,253.085176259),new qf.iq(154,254.086847795),new qf.iq(155,255.089955466),new qf.iq(156,256.091766522),new qf.iq(157,257.095098635),new qf.iq(158,258.097069),new qf.iq(159,259.100588)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(144,245.081017),new qf.iq(145,246.081933),new qf.iq(146,247.081804),new qf.iq(147,248.082909),new qf.iq(148,249.083002),new qf.iq(149,250.084488),new qf.iq(150,251.084919),new qf.iq(151,252.08663),new qf.iq(152,253.08728),new qf.iq(153,254.089725),new qf.iq(154,255.091075196),new qf.iq(155,256.094052757),new qf.iq(156,257.095534643),new qf.iq(157,258.098425321),new qf.iq(158,259.100503),new qf.iq(159,260.103645)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(147,249.087823),new qf.iq(148,250.087493),new qf.iq(149,251.08896),new qf.iq(150,252.088965909),new qf.iq(151,253.090649),new qf.iq(152,254.090948746),new qf.iq(153,255.093232449),new qf.iq(154,256.094275879),new qf.iq(155,257.096852778),new qf.iq(156,258.0982),new qf.iq(157,259.101024),new qf.iq(158,260.102636),new qf.iq(159,261.105743),new qf.iq(160,262.10752)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(148,251.09436),new qf.iq(149,252.09533),new qf.iq(150,253.095258),new qf.iq(151,254.096587),new qf.iq(152,255.096769),new qf.iq(153,256.098763),new qf.iq(154,257.099606),new qf.iq(155,258.101883),new qf.iq(156,259.10299),new qf.iq(157,260.105572),new qf.iq(158,261.106941),new qf.iq(159,262.109692),new qf.iq(160,263.111394)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(149,253.100679),new qf.iq(150,254.100166),new qf.iq(151,255.101492),new qf.iq(152,256.101179573),new qf.iq(153,257.103072),new qf.iq(154,258.103568),new qf.iq(155,259.105628),new qf.iq(156,260.106434),new qf.iq(157,261.108752),new qf.iq(158,262.109918),new qf.iq(159,263.11254),new qf.iq(160,264.113978)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(150,255.107398),new qf.iq(151,256.10811),new qf.iq(152,257.107858),new qf.iq(153,258.109438),new qf.iq(154,259.109721),new qf.iq(155,260.111427),new qf.iq(156,261.112106),new qf.iq(157,262.114153),new qf.iq(158,263.115078),new qf.iq(159,264.117473),new qf.iq(160,265.118659)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(152,258.113151),new qf.iq(153,259.114652),new qf.iq(154,260.114435447),new qf.iq(155,261.116199),new qf.iq(156,262.116477),new qf.iq(157,263.118313),new qf.iq(158,264.118924),new qf.iq(159,265.121066),new qf.iq(160,266.121928)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(153,260.121803),new qf.iq(154,261.1218),new qf.iq(155,262.123009),new qf.iq(156,263.123146),new qf.iq(157,264.12473),new qf.iq(158,265.125198),new qf.iq(159,266.127009),new qf.iq(160,267.12774)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(155,263.12871),new qf.iq(156,264.128408258),new qf.iq(157,265.130001),new qf.iq(158,266.130042),new qf.iq(159,267.131774),new qf.iq(160,268.132156),new qf.iq(161,269.134114)]),ed(Wl(Qf.mnb,1),Xt,3,0,[new qf.iq(156,265.136567),new qf.iq(157,266.13794),new qf.iq(158,267.137526),new qf.iq(159,268.138816),new qf.iq(160,269.139106),new qf.iq(161,270.140723),new qf.iq(162,271.141229)])])},qf.lq=function(n,t){var e,i;for(qf.kq(),i=t-n,e=0;e<qf.jq[n].length;e++)if(qf.jq[n][e].b==i)return qf.jq[n][e].a;return NaN},qf.mq=function(n,t){var e;if(n.b.length!=t.b.length)return n.b.length<t.b.length?-1:1;for(e=0;e<n.b.length;e++)if(n.b[e]!=t.b[e])return n.b[e]<t.b[e]?-1:1;return 0},qf.nq=function(n){var t,e,i,a,s;for(e=0,a=0,s=(i=n.a).length;a<s;++a)i[a]&&++e;for(n.b=$l(Qf.Mmb,G,6,e,15,1),e=0,t=0;t<n.a.length;t++)n.a[t]&&(n.b[e++]=t)},qf.oq=function(n,t){var e;for(qf.nq(n),e=0;e<n.b.length;e++)if(t[n.b[e]])return!0;return!1},qf.pq=function(n){this.a=$l(Qf.nyb,tn,6,n,16,1)},Ol(275,1,{275:1,19:1},qf.pq),o.Eb=function(n){return qf.mq(this,n)},Qf.nnb=hd(275),qf.uq=function(){qf.uq=vl,qf.tq=ed(Wl(Qf.Kmb,1),S,6,15,[0,1.00794,4.0026,6.941,9.0122,10.811,12.011,14.007,15.999,18.998,20.18,22.99,24.305,26.982,28.086,30.974,32.066,35.453,39.948,39.098,40.078,44.956,47.867,50.942,51.996,54.938,55.845,58.933,58.693,63.546,65.39,69.723,72.61,74.922,78.96,79.904,83.8,85.468,87.62,88.906,91.224,92.906,95.94,98.906,101.07,102.91,106.42,107.87,112.41,114.82,118.71,121.76,127.6,126.9,131.29,132.91,137.33,138.91,140.12,140.91,144.24,146.92,150.36,151.96,157.25,158.93,162.5,164.93,167.26,168.93,173.04,174.97,178.49,180.95,183.84,186.21,190.23,192.22,195.08,196.97,200.59,204.38,207.2,208.98,209.98,209.99,222.02,223.02,226.03,227.03,232.04,231.04,238.03,237.05,239.05,241.06,244.06,249.08,252.08,252.08,257.1,258.1,259.1,262.11,267.12,268.13,271.13,270.13,277.15,276.15,Gt,Gt,283.17,285.18,Yt,Yt,293.2,qt,qt,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.0141,3.016,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71.0787,156.18828,114.10364,115.0877,103.1447,128.13052,129.11458,57.05182,137.14158,113.15934,113.15934,128.17428,131.19846,147.17646,97.11658,87.0777,101.10458,186.2134,163.17546,99.13246]),qf.rq=ed(Wl(Qf.Kmb,1),S,6,15,[0,1.007825,4.0026,7.016003,9.012182,11.009305,12,14.003074,15.994915,18.998403,19.992435,22.989767,23.985042,26.98153,27.976927,30.973762,31.97207,34.968852,39.962384,38.963707,39.962591,44.95591,47.947947,50.943962,51.940509,54.938047,55.934939,58.933198,57.935346,62.939598,63.929145,68.92558,73.921177,74.921594,79.91652,78.918336,83.911507,84.911794,87.905619,88.905849,89.904703,92.906377,97.905406,89.92381,101.904348,102.9055,105.903478,106.905092,113.903357,114.90388,119.9022,120.903821,129.906229,126.904473,131.904144,132.905429,137.905232,138.906346,139.905433,140.907647,141.907719,135.92398,151.919729,152.921225,157.924099,158.925342,163.929171,164.930319,165.93029,168.934212,173.938859,174.94077,179.946545,180.947992,183.950928,186.955744,191.961467,192.962917,194.964766,196.966543,201.970617,204.974401,207.976627,208.980374,193.98818,195.99573,199.9957,201.00411,206.0038,210.00923,232.038054,216.01896,238.050784,229.03623,232.041169,237.05005,238.05302,242.06194,240.06228,243.06947,243.07446,248.08275,251.08887,253.09515,257.10295,257.10777,271.13,270.13,277.15,276.15,Gt,Gt,283.17,285.18,Yt,Yt,291.2,qt,qt,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.014,3.01605,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]),qf.sq=ed(Wl(Qf.Mmb,1),G,6,15,[6,1,7,8])},qf.vq=function(n){var t,e;for(e=n.a,t=0;t<n.b.length;t++)e+=n.b[t]*qf.rq[n.c[t]];return e},qf.wq=function(n){var t,e;for(t=new zf.NJb,e=0;e<n.b.length;e++)zf.MJb(t,(qf.Jj(),qf.Dj)[n.c[e]]),n.b[e]>1&&zf.LJb(t,n.b[e]);return t.a},qf.xq=function(n){var t,e;for(e=n.d,t=0;t<n.b.length;t++)e+=n.b[t]*qf.tq[n.c[t]];return e},qf.yq=function(n){var t,e,i,a,s,r,o,f,l,d,g;for(qf.nu(n,1),a=$l(Qf.Mmb,G,6,191,15,1),e=0;e<n.q;e++)switch(n.C[e]){case 171:a[1]+=5,a[6]+=3,a[7]+=1,a[8]+=1;break;case 172:a[1]+=12,a[6]+=6,a[7]+=4,a[8]+=1;break;case 173:a[1]+=6,a[6]+=4,a[7]+=2,a[8]+=2;break;case 174:a[1]+=5,a[6]+=4,a[7]+=1,a[8]+=3;break;case 175:a[1]+=5,a[6]+=3,a[7]+=1,a[8]+=1,a[16]+=1;break;case 176:a[1]+=8,a[6]+=5,a[7]+=2,a[8]+=2;break;case 177:a[1]+=7,a[6]+=5,a[7]+=1,a[8]+=3;break;case 178:a[1]+=3,a[6]+=2,a[7]+=1,a[8]+=1;break;case 179:a[1]+=7,a[6]+=6,a[7]+=3,a[8]+=1;break;case 181:case 180:a[1]+=11,a[6]+=6,a[7]+=1,a[8]+=1;break;case 182:a[1]+=12,a[6]+=6,a[7]+=2,a[8]+=1;break;case 183:a[1]+=9,a[6]+=5,a[7]+=1,a[8]+=1,a[16]+=1;break;case 184:a[1]+=9,a[6]+=9,a[7]+=1,a[8]+=1;break;case 185:a[1]+=7,a[6]+=5,a[7]+=1,a[8]+=1;break;case 186:a[1]+=5,a[6]+=3,a[7]+=1,a[8]+=2;break;case 187:a[1]+=7,a[6]+=4,a[7]+=1,a[8]+=2;break;case 188:a[1]+=10,a[6]+=11,a[7]+=2,a[8]+=1;break;case 189:a[1]+=9,a[6]+=9,a[7]+=1,a[8]+=2;break;case 190:a[1]+=9,a[6]+=5,a[7]+=1,a[8]+=1;break;case 1:switch(n.A[e]){case 0:case 1:++a[1];break;case 2:++a[151];break;case 3:++a[152]}break;default:++a[n.C[e]]}for(i=0;i<n.q;i++)n.C[i]>=171&&n.C[i]<=190?a[1]+=2-qf.eo(n,i):a[1]+=qf.Zn(n,i);for(o=0,l=1;l<=190;l++)0!=a[l]&&++o;for(this.b=$l(Qf.Mmb,G,6,o,15,1),this.c=$l(Qf.Mmb,G,6,o,15,1),o=0,f=0;f<qf.sq.length;f++)0!=a[qf.sq[f]]&&(this.b[o]=a[qf.sq[f]],this.c[o]=qf.sq[f],++o,a[qf.sq[f]]=0);for(;;){for(g="zzz",d=-1,r=1;r<=190;r++)a[r]>0&&zf.jJb(g,(qf.Jj(),qf.Dj)[r])>0&&(g=(qf.Jj(),qf.Dj)[r],d=r);if(-1==d)break;this.b[o]=a[d],this.c[o]=d,++o,a[d]=0}for(this.a=0,this.d=0,t=0;t<n.f;t++)1!=n.C[t]&&0!=n.A[t]&&(r=n.C[t],s=n.A[t],this.a+=qf.lq(r,s)-qf.rq[r],this.d+=qf.lq(r,s)-qf.tq[r])},Ol(171,1,{171:1}),o.ib=function(n){var t;if(n===this)return!0;if(!sd(n,171))return!1;for(t=0;t<this.b.length;t++)if(this.b[t]!=n.b[t])return!1;return!0},o.a=0,o.d=0,Qf.onb=hd(171),qf.Aq=function(n){switch(n){case 6:return 1;case 53:return 2;case 33:return 3;case 34:return 4;case 35:return 5;case 15:return 6;case 16:return 7;case 17:return 8;case 7:return 9;case 8:return 10;case 9:return 11}return 0},qf.Bq=function(n){var t,e,i,a,s,r,o,f,l,d,g,u,c,b,h,D,H,j,m,A,C,p,M,I,P;for(qf.nu(n,7),I=0,c=$l(Qf.nyb,tn,6,n.f,16,1),P=$l(Qf.Mmb,G,6,n.f,15,1),s=0;s<n.g;s++)e=n.D[0][s],i=n.D[1][s],r=n.s[e],o=n.s[i],0!=r&&0!=o&&r<0^o<0&&(c[e]=!0,c[i]=!0),P[e]+=qf.Uk(n,s),P[i]+=qf.Uk(n,s);for(f=0;f<n.f;f++)if(I+=n.s[f],1==n.s[f]){if(7==n.C[f]&&!c[f])if(P[f]<=3)I-=1,n.s[f]=0,n.T=0,n.j[f]!=n.e[f]&&(qf.fk(n,qf.Jn(n,f,n.e[f]-1)),qf.nu(n,7));else if(f<n.f&&qf.Or(n.p,f))for(H=$l(Qf.nyb,tn,6,n.f,16,1),j=$l(Qf.nyb,tn,6,n.g,16,1),qf.sn(n,f,!0,H,j),d=0;d<n.f;d++)if(H[d]&&7==n.C[d]&&0==n.s[d]&&2==P[d]&&qf.Eq(n,j,f,d)){I-=1;break}}else if(n.s[f]<0&&(6==n.C[f]||7==n.C[f]||8==n.C[f]||16==n.C[f]))if(c[f]){for((C=$l(Qf.Mmb,G,6,16,15,1))[0]=f,M=1,p=0;p<M;){for(a=0;a<n.r;a++)if(t=-1,n.D[0][a]==C[p]?t=n.D[1][a]:n.D[1][a]==C[p]&&(t=n.D[0][a]),-1!=t&&0!=n.s[t]){for(g=!1,h=0;h<M;h++)if(t==C[h]){g=!0;break}g||(M==C.length&&(l=$l(Qf.Mmb,G,6,2*C.length,15,1),zf.bKb(C,0,l,0,C.length),C=l),C[M++]=t)}++p}for(u=0,D=0;D<M;D++)u+=qf.qk(n,C[D]);if(u<0){for(m=-1,A=99,b=0;b<M;b++)qf.qk(n,C[b])<0&&A>qf.Aq(qf.Hk(n,C[b]))&&(A=qf.Aq(qf.Hk(n,C[b])),m=C[b]);-1!=m&&(I-=n.s[m],n.s[m]=0,n.T=0)}}else I-=n.s[f],n.s[f]=0,n.T=0;return I>0&&(I=qf.Cq(n,I)),I},qf.Cq=function(n,t){var e,i,a,s;if(t>0&&(t=qf.Fq(n,t,9)),t>0&&(t=qf.Fq(n,t,17)),t>0&&(t=qf.Fq(n,t,35)),t>0&&(t=qf.Fq(n,t,53)),t>0)for(e=0;e<n.f;e++)if(n.s[e]>0){for(a=!1,s=0;s<n.j[e];s++)if(i=n.i[e][s],0==n.s[i]&&qf.ul(n,i)&&qf.Zn(n,i)>0){if(n.s[i]=-1,n.T=0,0==--t)return 0;a=!0;break}if(a)continue}return t>0&&(t=qf.Dq(n,t,8,16)),t>0&&(t=qf.Dq(n,t,8,15)),t>0&&(t=qf.Dq(n,t,8,6)),t>0&&(t=qf.Dq(n,t,7,16)),t},qf.Dq=function(n,t,e,i){var a,s,r,o,f,l,d,g;for(a=0;a<n.f;a++)if(n.C[a]==e&&0==n.s[a]&&qf.Zn(n,a)>0)for(o=!1,l=0;l<n.j[a];l++){if(1==n.n[a][l]&&(s=n.i[a][l],n.C[s]==i)){for(g=!1,f=!1,d=0;d<n.j[s];d++){if(r=n.i[s][d],n.s[r]<0){f=!0;break}r!=a&&8==n.C[r]&&2==n.n[s][d]&&(g=!0)}if(!f&&g){if(n.s[a]=-1,n.T=0,0==--t)return 0;o=!0}}if(o)break}return t},qf.Eq=function(n,t,e,i){var a,s,r,o,f,l,d,g;for(g=$l(Qf.Mmb,G,6,n.g,15,1),f=$l(Qf.nyb,tn,6,n.g,16,1),r=0;r<n.g;r++)g[r]=n.H[r],t[r]&&(f[r]=!0,n.H[r]=1,n.T=0);for(a=0;a<n.f;a++)if(a!=i&&0==n.o[a]&&f[n.k[i][0]])for(d=0;d<n.j[a];d++)o=n.k[a][d],n.H[o]=1,n.T=0,f[o]=!1;for(l=0;l<n.j[e];l++)o=n.k[e][l],n.H[o]=1,n.T=0,f[o]=!1;if(qf.ie(new qf.se(n),f,!1))return n.s[e]=0,n.T=0,n.j[i]!=n.e[i]&&qf.fk(n,qf.Jn(n,i,n.e[i]-1)),qf.nu(n,7),!0;for(s=0;s<n.g;s++)qf.xm(n,s,g[s]);return!1},qf.Fq=function(n,t,e){var i;for(i=0;i<n.f;i++)if(n.C[i]==e&&0==n.s[i]&&0==n.j[i]&&(n.s[i]=-1,n.T=0,0==--t))return 0;return t},qf.Gq=function(n,t){var e,i;for(i=Ql.DMb(n.b,t),e=Gf.zVb(i).length;e<10;e++)zf.QJb(n.a,32);zf.UJb(n.a,i)},qf.Hq=function(n,t){var e,i,a;if(t<0||t>999)zf.UJb(n.a,"  ?");else for(e=!1,i=0;i<3;i++)0==(a=t/100|0)?2==i||e?zf.QJb(n.a,48):zf.QJb(n.a,32):(zf.QJb(n.a,48+a&B),e=!0),t=t%100*10},qf.Iq=function(n,t){xl.FGb(t,n.a.a)},qf.Jq=function(n){qf.Kq.call(this,n)},qf.Kq=function(n){qf.Mq.call(this,n,new zf.YJb)},qf.Lq=function(t,e,i){var a,s,r,o,f,l,d,g,u,c,b,h,D,j,m,A,C,p,M,I,P,T,N,w,U,J,L,y,R,k,x,E,F,Q,z,S,X,Y,q,V,v,Z,O,K;for(this.b=new Ql.GMb(Vt),qf.nu(t,15),x=!0,s=0;s<t.f;s++)if(3&t.u[s]&&3&~t.u[s]&&(t.u[s]&Kn)>>18!=1){x=!1;break}if(F=-1,x)for(U=$l(Qf.Mmb,G,6,32,15,1),Q=0,r=0;r<t.f;r++)if(3&t.u[r]&&3&~t.u[r]&&(t.u[r]&Kn)>>18==1){++U[L=(t.u[r]&Kn)>>18!=1&&(t.u[r]&Kn)>>18!=2?-1:(t.u[r]&It)>>20],Q<U[L]&&(Q=U[L],F=L);break}for(this.a=i||new zf.XJb,S=null!=t.P?t.P:"",zf.UJb(this.a,S+H),zf.UJb(this.a,"Actelion Java MolfileCreator 1.0\n\n"),qf.Hq(this,t.q),qf.Hq(this,t.r),zf.UJb(this.a,"  0  0"),qf.Hq(this,x?0:1),zf.UJb(this.a,"  0  0  0  0  0999 V2000\n"),y=1==t.q,l=1;l<t.q;l++)if(t.J[l].a!=t.J[0].a||t.J[l].b!=t.J[0].b||t.J[l].c!=t.J[0].c){y=!0;break}if(J=1,y)if(0!=e)J=e;else if(0!=(A=qf.Jk(t,t.q,t.r,(qf.Jj(),qf.Ij))))(A<1||A>3)&&(J=1.5/A);else{for(z=Tt,r=1;r<t.q;r++)for(f=0;f<r;f++)z>(P=(T=t.J[f].a-t.J[r].a)*T+(N=t.J[f].b-t.J[r].b)*N+(w=t.J[f].c-t.J[r].c)*w)&&(z=P);J=3/z}for(d=0;d<t.q;d++)y?(qf.Gq(this,J*t.J[d].a),qf.Gq(this,J*-t.J[d].b),qf.Gq(this,J*-t.J[d].c)):zf.UJb(this.a,"    0.0000    0.0000    0.0000"),null!=(null==t.v?null:t.v[d])?zf.UJb(this.a," L  "):Sd(wd(t.B[d],1),0)?zf.UJb(this.a," A  "):t.C[d]>=129&&t.C[d]<=144||154==t.C[d]?zf.UJb(this.a," R# "):(D=(qf.Jj(),qf.Dj)[t.C[d]],zf.UJb(this.a," "+D),1==Gf.zVb(D).length?zf.UJb(this.a,"  "):2==Gf.zVb(D).length&&zf.UJb(this.a," ")),zf.UJb(this.a," 0  0  0"),0==Ud(R=wd(bn,t.B[d]),0)?zf.UJb(this.a,"  0"):0==Ud(R,384)?zf.UJb(this.a,"  3"):0==Ud(R,128)?zf.UJb(this.a,"  2"):0==Ud(R,1792)?zf.UJb(this.a,"  1"):0==Ud(R,1664)&&zf.UJb(this.a,"  2"),zf.UJb(this.a,Sd(wd(t.B[d],Xn),0)?"  1":"  0"),-1==(K=((t.u[d]&Mt)>>>27)-1)?zf.UJb(this.a,"  0"):0==K?zf.UJb(this.a," 15"):qf.Hq(this,K),zf.UJb(this.a,"  0  0  0"),qf.Hq(this,n.Math.abs(t.w[d])),zf.UJb(this.a,"  0  0\n");for(C=0;C<t.r;C++){switch(t.H[C]){case 1:default:Y=1,v=0;break;case 2:Y=2,v=0;break;case 4:Y=3,v=0;break;case 129:Y=1,v=6;break;case 257:Y=1,v=1;break;case 386:Y=2,v=3;break;case 64:Y=4,v=0;break;case 32:Y=8,v=0}!x||1!=v&&6!=v||(r=t.D[0][C],(t.u[r]&Kn)>>18==2?v=0:(t.u[r]&Kn)>>18==1&&((t.u[r]&Kn)>>18!=1&&(t.u[r]&Kn)>>18!=2?-1:(t.u[r]&It)>>20)!=F&&(v=4)),0!=(p=31&t.G[C])&&(Y=8==p?4:3==p?5:9==p?6:10==p?7:8),O=0==(V=384&t.G[C])?0:256==V?1:2,qf.Hq(this,1+t.D[0][C]),qf.Hq(this,1+t.D[1][C]),qf.Hq(this,Y),qf.Hq(this,v),zf.UJb(this.a,"  0"),qf.Hq(this,O),zf.UJb(this.a,"  0\n")}for(X=0,g=0;g<t.q;g++)0!=t.s[g]&&++X;if(0!=X)for(I=0,r=0;r<t.q;r++)0!=t.s[r]&&(0==I&&(zf.UJb(this.a,"M  CHG"),qf.Hq(this,n.Math.min(8,X))),zf.UJb(this.a," "),qf.Hq(this,r+1),(M=t.s[r])<0?(zf.UJb(this.a,"  -"),M=-M):zf.UJb(this.a,"   "),zf.QJb(this.a,48+M&B),--X,8!=++I&&0!=X||(I=0,zf.UJb(this.a,H)));for(X=0,u=0;u<t.q;u++)0==t.A[u]||++X;if(0!=X)for(I=0,r=0;r<t.q;r++)0!=t.A[r]&&(0==I&&(zf.UJb(this.a,"M  ISO"),qf.Hq(this,n.Math.min(8,X))),zf.UJb(this.a," "),qf.Hq(this,r+1),zf.UJb(this.a," "),qf.Hq(this,t.A[r]),--X,8!=++I&&0!=X||(I=0,zf.UJb(this.a,H)));for(X=0,c=0;c<t.q;c++)48&t.u[c]&&++X;if(0!=X)for(I=0,r=0;r<t.q;r++)if(48&t.u[r]){switch(0==I&&(zf.UJb(this.a,"M  RAD"),qf.Hq(this,n.Math.min(8,X))),zf.UJb(this.a," "),qf.Hq(this,r+1),48&t.u[r]){case 16:zf.UJb(this.a,"   1");break;case 32:zf.UJb(this.a,"   2");break;case 48:zf.UJb(this.a,"   3")}--X,8!=++I&&0!=X||(I=0,zf.UJb(this.a,H))}for(X=0,b=0;b<t.q;b++)(t.C[b]>=129&&t.C[b]<=144||154==t.C[b])&&++X;if(0!=X)for(I=0,a=0;a<t.q;a++)((m=t.C[a])>=129&&m<=144||154==m)&&(0==I&&(zf.UJb(this.a,"M  RGP"),qf.Hq(this,n.Math.min(8,X))),zf.UJb(this.a," "),qf.Hq(this,a+1),zf.UJb(this.a," "),qf.Hq(this,154==m?0:m>=142?m-141:m-125),--X,8!=++I&&0!=X||(I=0,zf.UJb(this.a,H)));if(t.K){for(X=0,r=0;r<t.q;r++)Sd(wd(t.B[r],120),0)&&++X;if(0!=X)for(I=0,f=0;f<t.q;f++)0!=Ud(q=wd(t.B[f],120),0)&&(0==I&&(zf.UJb(this.a,"M  RBC"),qf.Hq(this,n.Math.min(8,X))),zf.UJb(this.a," "),qf.Hq(this,f+1),0==Ud(q,112)?zf.UJb(this.a,"  -1"):0==Ud(q,8)?zf.UJb(this.a,"   1"):0==Ud(q,104)?zf.UJb(this.a,"   2"):0==Ud(q,88)?zf.UJb(this.a,"   3"):0==Ud(q,56)&&zf.UJb(this.a,"   4"),--X,8!=++I&&0!=X||(I=0,zf.UJb(this.a,H)));for(h=0;h<t.q;h++)if(null!=(j=null==t.v?null:t.v[h])){for(zf.UJb(this.a,"M  ALS "),qf.Hq(this,h+1),qf.Hq(this,j.length),zf.UJb(this.a,Sd(wd(t.B[h],1),0)?" T ":" F "),k=0;k<j.length;k++)switch(E=(qf.Jj(),qf.Dj)[j[k]],Gf.zVb(E).length){case 1:zf.UJb(this.a,E+"   ");break;case 2:zf.UJb(this.a,E+"  ");break;case 3:zf.UJb(this.a,E+" ");break;default:zf.UJb(this.a,"   ?")}zf.UJb(this.a,H)}for(X=0,o=0;o<t.q;o++)Sd(wd(t.B[o],6144),0)&&++X;if(0!=X)for(I=0,a=0;a<t.q;a++)0!=Ud(Z=wd(t.B[a],6144),0)&&(0==I&&(zf.UJb(this.a,"M  SUB"),qf.Hq(this,n.Math.min(8,X))),zf.UJb(this.a," "),qf.Hq(this,a+1),Sd(wd(Z,dn),0)?zf.UJb(this.a,"   "+(t.e[a]+1)):zf.UJb(this.a,"  -2"),--X,8!=++I&&0!=X||(I=0,zf.UJb(this.a,H)))}zf.UJb(this.a,vt)},qf.Mq=function(n,t){qf.Lq.call(this,n,0,t)},Ol(113,1,{},qf.Jq,qf.Lq),Qf.qnb=hd(113),qf.Nq=function(n,t,e,i,a,s){var r,o,f,l;switch(l=1,o=!1,a){case 1:l=257;break;case 3:l=386;break;case 4:l=257,o=!0;break;case 6:l=129;break;default:switch(i){case 1:l=1;break;case 2:l=2;break;case 3:l=4;break;case 4:l=64;break;case 9:l=32}}if(r=qf.Nj(n.j,t,e,l),f=0,o&&qf._l(n.j,t,1,-1),i>4)switch(i){case 5:f|=3;break;case 6:f|=9;break;case 7:f|=10;break;case 8:32!=l&&(f|=31)}return 1==s&&(f|=256),2==s&&(f|=128),0!=f&&qf.wm(n.j,r,f,!0),r},qf.Oq=function(t){var e,i,a,s,r,o,f,l,d,g,u;for(o=$l(Qf.Mmb,G,6,t.j.q,15,1),i=0;i<t.j.q;i++)o[i]=-qf.qk(t.j,i);for(qf.ie(new qf.se(t.j),null,!0),a=0;a<t.j.q;a++)o[a]+=qf.qk(t.j,a);for(e=0;e<t.j.q;e++)if(0!=o[e])for(f=-o[e],s=0;s<t.j.r;s++)for(d=0;d<2;d++)f>0&&32==qf.Xk(t.j,s)&&qf.Mk(t.j,1-d,s)==e&&(u=qf.Mk(t.j,d,s),qf.xl(t.j,u)&&(g=qf.Qq(t,u),(r=qf.qk(t.j,u))<g&&(l=n.Math.min(f,g-r),qf.Wl(t.j,u,r+l),f-=l)))},qf.Pq=function(n,t){return n.j=null,qf.fr(n,new xl.AGb(new xl.EGb(t)))?n.j:null},qf.Qq=function(n,t){var e,i;return null==(i=(e=qf.Hk(n.j,t))<(qf.Jj(),qf.Fj).length?qf.Fj[e]:null)?0:i[i.length-1]},qf.Rq=function(n,t){var e;return(e=n.b?Vf.$Ob(n.b,new zf.tIb(t)):null)?e.a:t-1},qf.Sq=function(n,t){var e;return(e=n.c?Vf.$Ob(n.c,new zf.tIb(t)):null)?e.a:t-1},qf.Tq=function(n,t){var e,i;if(null!=t)for(qf.nu(n.j,1),e=0;e<n.j.f;e++)0!=t[e]&&(i=qf._k(n.j,e,qf.eo(n.j,e)),15==t[e]?i>=0&&qf.Ul(n.j,e,0):t[e]!=qf.bl(n.j,e)&&qf.Ul(n.j,e,t[e]-i))},qf.Uq=function(n,t){var e;if(-1==t)return-1;for(e=t+1;e<Gf.zVb(n).length;e++)if(Gf.uVb(e,Gf.zVb(n).length),32!=Gf.zVb(n).charCodeAt(e)&&(Gf.uVb(e,Gf.zVb(n).length),9!=Gf.zVb(n).charCodeAt(e)))return e;return-1},qf.Vq=function(n,t){var e;for(e=t;e<Gf.zVb(n).length;e++)if(Gf.uVb(e,Gf.zVb(n).length),32==Gf.zVb(n).charCodeAt(e)||(Gf.uVb(e,Gf.zVb(n).length),9==Gf.zVb(n).charCodeAt(e)))return e;return-1},qf.Wq=function(n){return-1!=Gf.zVb(n).indexOf("ATOMS=(")?Zt:-1!=Gf.zVb(n).indexOf("BONDS=(")?"BONDS":null},qf.Xq=function(t,e){var i,a,s,r,o,f,l,d,g,u,c,b,h,D,H,j,m,A,C,p,M,P,T,N,w,U;for(D=0,H=-1==(f=qf.Vq(e,D+1))?Gf.zVb(e).length:f,a=zf.$Hb((Gf.tVb(D,H,Gf.zVb(e).length),Gf.zVb(e).substr(D,H-D)),Ot,I),D=qf.Uq(e,H),H=-1==(l=qf.Vq(e,D+1))?Gf.zVb(e).length:l,Gf.tVb(D,H,Gf.zVb(e).length),m=Gf.zVb(e).substr(D,H-D),P=null,s=!1,0!=(j=qf.cr(e))&&(P=qf.Yq(e),j<0&&(s=!0),H=n.Math.abs(j)),D=qf.Uq(e,H),H=-1==(d=qf.Vq(e,D+1))?Gf.zVb(e).length:d,N=og((Gf.tVb(D,H,Gf.zVb(e).length),Gf.zVb(e).substr(D,H-D))),D=qf.Uq(e,H),H=-1==(g=qf.Vq(e,D+1))?Gf.zVb(e).length:g,w=og((Gf.tVb(D,H,Gf.zVb(e).length),Gf.zVb(e).substr(D,H-D))),D=qf.Uq(e,H),H=-1==(u=qf.Vq(e,D+1))?Gf.zVb(e).length:u,U=og((Gf.tVb(D,H,Gf.zVb(e).length),Gf.zVb(e).substr(D,H-D))),D=qf.Uq(e,H),H=-1==(c=qf.Vq(e,D+1))?Gf.zVb(e).length:c,C=zf.$Hb((Gf.tVb(D,H,Gf.zVb(e).length),Gf.zVb(e).substr(D,H-D)),Ot,I),(i=qf.Kj(t.j,N,-w,-U))+1!=a&&(!t.b&&(t.b=new Vf.cTb),Vf.WSb(t.b,new zf.tIb(a),new zf.tIb(i))),null!=P&&(qf.nm(t.j,i,6),qf.bm(t.j,i,P,s)),0!=C&&qf.cm(t.j,i,C,!1),zf.pJb(m,"A")||zf.pJb(m,"*")?qf.gm(t.j,i,1,!0):zf.pJb(m,"Q")?((A=$l(Qf.Mmb,G,6,1,15,1))[0]=6,qf.bm(t.j,i,A,!0)):qf.nm(t.j,i,qf._m(m,67));-1!=(D=qf.Uq(e,H));)if(H=-1==(o=qf.Vq(e,D+1))?Gf.zVb(e).length:o,Gf.tVb(D,H,Gf.zVb(e).length),p=Gf.zVb(e).substr(D,H-D),h=zf.tJb(p,pd(61)),Gf.tVb(0,h,Gf.zVb(p).length),b=Gf.zVb(p).substr(0,h),T=zf.$Hb((Gf.uVb(h+1,Gf.zVb(p).length+1),Gf.zVb(p).substr(h+1)),Ot,I),zf.pJb(b,"CHG"))qf.Wl(t.j,i,T);else if(zf.pJb(b,"RAD"))switch(T){case 1:qf.hm(t.j,i,16);break;case 2:qf.hm(t.j,i,32);break;case 3:qf.hm(t.j,i,48)}else if(zf.pJb(b,"CFG"));else if(zf.pJb(b,"MASS"))qf.em(t.j,i,T);else if(zf.pJb(b,"VAL"))qf.Ul(t.j,i,-1==T?0:0==T?-1:T);else if(zf.pJb(b,"HCOUNT"))switch(T){case 0:break;case-1:qf.gm(t.j,i,1792,!0);break;case 1:qf.gm(t.j,i,128,!0);break;case 2:qf.gm(t.j,i,384,!0);break;default:qf.gm(t.j,i,896,!0)}else if(zf.pJb(b,"SUBST")){if(-1==T)qf.gm(t.j,i,Gn,!0);else if(T>0){for(M=0,r=0;r<t.j.r;r++)(qf.Mk(t.j,0,r)==i||qf.Mk(t.j,1,r)==i)&&++M;T>M&&qf.gm(t.j,i,dn,!0)}}else if(zf.pJb(b,"RBCNT"))switch(T){case 3:case-1:qf.gm(t.j,i,112,!0);break;case 1:qf.gm(t.j,i,8,!0);break;case 2:qf.gm(t.j,i,104,!0);break;case 4:qf.gm(t.j,i,56,!0)}},qf.Yq=function(n){var t,e,i,a,s,r,o,f;if(o=null,e=Gf.zVb(n).indexOf("["),i=Gf.zVb(n).indexOf("]",e),e>=0&&i>0){for(t=$l(Qf.Mmb,G,6,16,15,1),Gf.tVb(e+1,i,Gf.zVb(n).length),f=Gf.zVb(n).substr(e+1,i-(e+1)),a=0,r=!0;r&&a<16;)s=null,-1==(e=Gf.zVb(f).indexOf(","))?(s=f,r=!1):(Gf.tVb(0,e,Gf.zVb(f).length),s=Gf.zVb(f).substr(0,e),Gf.uVb(e+1,Gf.zVb(f).length+1),f=Gf.zVb(f).substr(e+1)),t[a++]=qf._m(s,1);o=$l(Qf.Mmb,G,6,a,15,1),zf.bKb(t,0,o,0,a)}return o},qf.Zq=function(n,t){var e,i,a,s,r,o,f,l,d,g,u,c,b,h,D,H,j,m;for(b=0,h=-1==(f=qf.Vq(t,b+1))?Gf.zVb(t).length:f,s=zf.$Hb((Gf.tVb(b,h,Gf.zVb(t).length),Gf.zVb(t).substr(b,h-b)),Ot,I),b=qf.Uq(t,h),h=-1==(l=qf.Vq(t,b+1))?Gf.zVb(t).length:l,r=zf.$Hb((Gf.tVb(b,h,Gf.zVb(t).length),Gf.zVb(t).substr(b,h-b)),Ot,I),b=qf.Uq(t,h),h=-1==(d=qf.Vq(t,b+1))?Gf.zVb(t).length:d,e=qf.Rq(n,zf.$Hb((Gf.tVb(b,h,Gf.zVb(t).length),Gf.zVb(t).substr(b,h-b)),Ot,I)),b=qf.Uq(t,h),h=-1==(g=qf.Vq(t,b+1))?Gf.zVb(t).length:g,i=qf.Rq(n,zf.$Hb((Gf.tVb(b,h,Gf.zVb(t).length),Gf.zVb(t).substr(b,h-b)),Ot,I)),H=0,j=0;-1!=(b=qf.Uq(t,h));)if(h=-1==(o=qf.Vq(t,b+1))?Gf.zVb(t).length:o,Gf.tVb(b,h,Gf.zVb(t).length),D=Gf.zVb(t).substr(b,h-b),c=zf.tJb(D,pd(61)),Gf.tVb(0,c,Gf.zVb(D).length),u=Gf.zVb(D).substr(0,c),m=zf.$Hb((Gf.uVb(c+1,Gf.zVb(D).length+1),Gf.zVb(D).substr(c+1)),Ot,I),zf.pJb(u,"CFG"))switch(m){case 1:H=1;break;case 2:H=2==r?3:4;break;case 3:H=6}else zf.pJb(u,"TOPO")&&(j=m);(a=qf.Nq(n,e,i,r,H,j))+1!=s&&(!n.c&&(n.c=new Vf.cTb),Vf.WSb(n.c,new zf.tIb(s),new zf.tIb(a)))},qf.$q=function(n,t){var e,i,a,s,r,o;if(null!=(o=qf.Wq(t)))if(r=qf.ar(t,o),zf.pJb(Gf.zVb(t).substr(0,13),"MDLV30/STEABS"))if(zf.pJb(o,Zt))for(s=0;s<r.length;s++)qf._l(n.j,qf.Rq(n,r[s]),0,-1);else for(a=0;a<r.length;a++)qf.rm(n.j,qf.Sq(n,r[a]),0,-1);else if(zf.pJb(Gf.zVb(t).substr(0,13),"MDLV30/STERAC"))if(i=zf.$Hb(zf.DJb(t,13,qf.Vq(t,13)),Ot,I),zf.pJb(o,Zt))for(s=0;s<r.length;s++)qf._l(n.j,qf.Rq(n,r[s]),1,i-1);else for(a=0;a<r.length;a++)qf.rm(n.j,qf.Sq(n,r[a]),1,i-1);else if(zf.pJb(Gf.zVb(t).substr(0,13),"MDLV30/STEREL"))if(i=zf.$Hb(zf.DJb(t,13,qf.Vq(t,13)),Ot,I),zf.pJb(o,Zt))for(s=0;s<r.length;s++)qf._l(n.j,qf.Rq(n,r[s]),2,i-1);else for(a=0;a<r.length;a++)qf.rm(n.j,qf.Sq(n,r[a]),2,i-1);else if(zf.pJb(Gf.zVb(t).substr(0,13),"MDLV30/HILITE"))if(zf.pJb(o,Zt))for(a=0;a<r.length;a++)qf.Xl(n.j,qf.Rq(n,r[a]),448);else for(a=0;a<r.length;a++)e=qf.Sq(n,r[a]),qf.Xl(n.j,qf.Mk(n.j,0,e),448),qf.Xl(n.j,qf.Mk(n.j,1,e),448)},qf._q=function(n,t){var e,i,a;n.j||zf.pJb(Gf.zVb(t).substr(0,6),"COUNTS")&&(e=qf.Uq(t,qf.Vq(t,7)),i=zf.$Hb(zf.DJb(t,7,qf.Vq(t,7)),Ot,I),a=zf.$Hb(zf.DJb(t,e,qf.Vq(t,e)),Ot,I),n.j=new qf.Gu(i,a))},qf.ar=function(n,t){var e,i,a,s,r,o;for(s=Gf.zVb(n).indexOf(t+"=(")+Gf.zVb(t).length+2,r=zf.uJb(n,pd(41),s),a=qf.Vq(n,s),e=zf.$Hb((Gf.tVb(s,a,Gf.zVb(n).length),Gf.zVb(n).substr(s,a-s)),Ot,I),o=$l(Qf.Mmb,G,6,e,15,1),i=0;i<e;i++)s=qf.Uq(n,a),(-1==(a=qf.Vq(n,s))||a>r)&&(a=r),o[i]=zf.$Hb((Gf.tVb(s,a,Gf.zVb(n).length),Gf.zVb(n).substr(s,a-s)),Ot,I);return o},qf.br=function(n){var t,e,i,a,s,r,o,f,l;for(f=$l(Qf.Mmb,G,6,n.j.q,15,1),i=0;i<n.j.r;i++)if(64==qf.Xk(n.j,i))for(r=0;r<2;r++)f[qf.Mk(n.j,r,i)]=1;for(a=0;a<n.j.r;a++)for(l=qf.Uk(n.j,a),s=0;s<2;s++)f[qf.Mk(n.j,s,a)]+=l;for(e=0;e<n.j.r;e++)if(1==qf.Uk(n.j,e))for(s=0;s<2;s++)o=qf.Mk(n.j,1-s,e),qf.xl(n.j,o)&&(t=qf.Mk(n.j,s,e),qf.ul(n.j,t)&&f[t]>qf.bl(n.j,t))&&qf.xm(n.j,e,32)},qf.cr=function(n){var t,e;if(Gf.zVb(n).indexOf("[")>=0){if(t=Gf.zVb(n).indexOf(" NOT["),e=Gf.zVb(n).indexOf("]",t),t>=0&&e>0)return-(e+1);if(t=Gf.zVb(n).indexOf(" ["),e=Gf.zVb(n).indexOf("]",t),t>=0&&e>0)return e+1;if(t=Gf.zVb(n).indexOf(" 'NOT["),e=Gf.zVb(n).indexOf("]'",t),t>=0&&e>0)return-(e+2);if(t=Gf.zVb(n).indexOf(" '["),e=Gf.zVb(n).indexOf("]'",t),t>=0&&e>0)return e+2;zf.aKb()}return 0},qf.dr=function(n,t,e){return n.j=t,qf.fr(n,e)},qf.er=function(n){return 0==Gf.zVb(n).length?0:zf.$Hb(n,Ot,I)},qf.fr=function(n,t){var e,i,a,s,r,o,f,l,d,g,u,c,b,h,D,H,j,m,A,C,p,M,P,T,N,w,U,J,L,y,B,R,k,x,E,F,Q,z,S,X;F=null;try{if(n.f=null,n.j&&(qf.lu(n.j),qf.zm(n.j,!1)),null==(P=m=xl.zGb(t)))return!1;if(null==(m=xl.zGb(t)))return!1;if(null==(m=xl.zGb(t)))return!1;if(n.k=-1!=Gf.zVb(m).indexOf("From CSD data. Using bond type 'Any'"),n.e=-1!=Gf.zVb(m).indexOf("From CSD data."),null==(m=xl.zGb(t)))return!1;n.g=!1,n.d=n.a;try{T=zf.$Hb(zf.EJb((Gf.tVb(0,3,Gf.zVb(m).length),Gf.zVb(m).substr(0,3))),Ot,I),N=zf.$Hb(zf.EJb((Gf.tVb(3,6,Gf.zVb(m).length),Gf.zVb(m).substr(3,3))),Ot,I),w=qf.er(zf.EJb((Gf.tVb(6,9,Gf.zVb(m).length),Gf.zVb(m).substr(6,3)))),n.d=n.d|1==qf.er(zf.EJb((Gf.tVb(12,15,Gf.zVb(m).length),Gf.zVb(m).substr(12,3)))),n.g=Gf.zVb(m).length>=39&&zf.pJb(Gf.zVb(m).substr(34,Gf.zVb("V3000").length),"V3000")}catch(n){if(sd(n=cd(n),18))return!1;throw bd(n)}if(n.g)return J=qf.gr(n,t),qf.Fm(n.j,P),J;if(!n.j&&(n.j=new qf.Gu(T,N)),qf.Fm(n.j,P),n.d||(n.j.L=!0),0==T){for(;null!=m&&!(zf.pJb(m,Kt)||zf.pJb(m,Wt)||zf.pJb((Gf.uVb(1,Gf.zVb(m).length+1),Gf.zVb(m).substr(1)),"$"));)m=xl.zGb(t);return!0}for(b=0;b<T;b++){if(null==(m=xl.zGb(t)))return!1;switch(z=og(zf.EJb((Gf.tVb(0,10,Gf.zVb(m).length),Gf.zVb(m).substr(0,10)))),S=og(zf.EJb((Gf.tVb(10,20,Gf.zVb(m).length),Gf.zVb(m).substr(10,10)))),X=og(zf.EJb((Gf.tVb(20,30,Gf.zVb(m).length),Gf.zVb(m).substr(20,10)))),i=qf.Kj(n.j,z,-S,-X),j=zf.EJb((Gf.tVb(31,34,Gf.zVb(m).length),Gf.zVb(m).substr(31,3))),zf.pJb(j,"A")||zf.pJb(j,"*")?qf.gm(n.j,i,1,!0):zf.pJb(j,"Q")?((A=$l(Qf.Mmb,G,6,1,15,1))[0]=6,qf.bm(n.j,i,A,!0)):(r=qf._m(j,67),qf.nm(n.j,i,r)),0!=(M=qf.er(zf.EJb((Gf.tVb(34,36,Gf.zVb(m).length),Gf.zVb(m).substr(34,2)))))&&qf.em(n.j,i,(qf.Jj(),qf.Hj)[qf.Hk(n.j,i)]+M),0!=(g=qf.er(zf.EJb((Gf.tVb(36,39,Gf.zVb(m).length),Gf.zVb(m).substr(36,3)))))&&(4==g?qf.hm(n.j,i,32):qf.Wl(n.j,i,4-g)),C=Gf.zVb(m).length<63?0:qf.er(zf.EJb((Gf.tVb(60,63,Gf.zVb(m).length),Gf.zVb(m).substr(60,3)))),qf.cm(n.j,i,C,!1),Gf.zVb(m).length<45?0:qf.er(zf.EJb((Gf.tVb(42,45,Gf.zVb(m).length),Gf.zVb(m).substr(42,3))))){case 0:break;case 1:qf.gm(n.j,i,768,!0);break;case 2:qf.gm(n.j,i,128,!0);break;case 3:qf.gm(n.j,i,384,!0);break;default:qf.gm(n.j,i,896,!0)}Gf.zVb(m).length>=48&&(Gf.uVb(47,Gf.zVb(m).length),49==Gf.zVb(m).charCodeAt(47))&&qf.gm(n.j,i,Xn,!0),0!=(E=Gf.zVb(m).length<51?0:qf.er(zf.EJb((Gf.tVb(48,51,Gf.zVb(m).length),Gf.zVb(m).substr(48,3)))))&&(null==F&&(F=$l(Qf.Mmb,G,6,T,15,1)),F[i]=E)}for(h=0;h<N;h++){if(null==(m=xl.zGb(t)))return!1;a=zf.$Hb(zf.EJb((Gf.tVb(0,3,Gf.zVb(m).length),Gf.zVb(m).substr(0,3))),Ot,I)-1,s=zf.$Hb(zf.EJb((Gf.tVb(3,6,Gf.zVb(m).length),Gf.zVb(m).substr(3,3))),Ot,I)-1,l=zf.$Hb(zf.EJb((Gf.tVb(6,9,Gf.zVb(m).length),Gf.zVb(m).substr(6,3))),Ot,I),y=Gf.zVb(m).length<12?0:qf.er(zf.EJb((Gf.tVb(9,12,Gf.zVb(m).length),Gf.zVb(m).substr(9,3)))),x=Gf.zVb(m).length<18?0:qf.er(zf.EJb((Gf.tVb(15,18,Gf.zVb(m).length),Gf.zVb(m).substr(15,3)))),8==l&&(n.k||qf.xl(n.j,a)||qf.xl(n.j,s))&&(l=9),qf.Nq(n,a,s,l,y,x)}for(c=0;c<w;c++)if(null==(m=xl.zGb(t)))return!1;if(null==(m=xl.zGb(t)))return 1&n.i&&(n.f=qf.Xn(n.j)),qf.Tq(n,F),n.d||qf.nu(n.j,15),!0;for(;null!=m&&!zf.pJb(m,Kt)&&!zf.pJb(m,Wt);){if(zf.pJb(Gf.zVb(m).substr(0,6),"M  CHG")&&(D=zf.$Hb(zf.EJb((Gf.tVb(6,9,Gf.zVb(m).length),Gf.zVb(m).substr(6,3))),Ot,I))>0)for(e=10,Q=14,H=1;H<=D;++H,e+=8,Q+=8)i=zf.$Hb(zf.EJb((Gf.tVb(e,e+3,Gf.zVb(m).length),Gf.zVb(m).substr(e,e+3-e))),Ot,I)-1,d=zf.$Hb(zf.EJb((Gf.tVb(Q,Q+3,Gf.zVb(m).length),Gf.zVb(m).substr(Q,Q+3-Q))),Ot,I),qf.Wl(n.j,i,d);if(zf.pJb(Gf.zVb(m).substr(0,6),"M  ISO")&&(D=zf.$Hb(zf.EJb((Gf.tVb(6,9,Gf.zVb(m).length),Gf.zVb(m).substr(6,3))),Ot,I))>0)for(e=10,Q=14,H=1;H<=D;++H,e+=8,Q+=8)i=zf.$Hb(zf.EJb((Gf.tVb(e,e+3,Gf.zVb(m).length),Gf.zVb(m).substr(e,e+3-e))),Ot,I)-1,p=zf.$Hb(zf.EJb((Gf.tVb(Q,Q+3,Gf.zVb(m).length),Gf.zVb(m).substr(Q,Q+3-Q))),Ot,I),qf.em(n.j,i,p);if(zf.pJb(Gf.zVb(m).substr(0,6),"M  RAD")&&(D=zf.$Hb(zf.EJb((Gf.tVb(6,9,Gf.zVb(m).length),Gf.zVb(m).substr(6,3))),Ot,I))>0)for(e=10,Q=14,H=1;H<=D;++H,e+=8,Q+=8)switch(i=zf.$Hb(zf.EJb((Gf.tVb(e,e+3,Gf.zVb(m).length),Gf.zVb(m).substr(e,e+3-e))),Ot,I)-1,zf.$Hb(zf.EJb((Gf.tVb(Q,Q+3,Gf.zVb(m).length),Gf.zVb(m).substr(Q,Q+3-Q))),Ot,I)){case 1:qf.hm(n.j,i,16);break;case 2:qf.hm(n.j,i,32);break;case 3:qf.hm(n.j,i,48)}if((zf.pJb(Gf.zVb(m).substr(0,6),"M  RBC")||zf.pJb(Gf.zVb(m).substr(0,6),"M  RBD"))&&(D=zf.$Hb(zf.EJb((Gf.tVb(6,9,Gf.zVb(m).length),Gf.zVb(m).substr(6,3))),Ot,I))>0)for(e=10,Q=14,H=1;H<=D;++H,e+=8,Q+=8)switch(i=zf.$Hb(zf.EJb((Gf.tVb(e,e+3,Gf.zVb(m).length),Gf.zVb(m).substr(e,e+3-e))),Ot,I)-1,zf.$Hb(zf.EJb((Gf.tVb(Q,Q+3,Gf.zVb(m).length),Gf.zVb(m).substr(Q,Q+3-Q))),Ot,I)){case 3:case-1:qf.gm(n.j,i,112,!0);break;case 1:qf.gm(n.j,i,8,!0);break;case 2:qf.gm(n.j,i,104,!0);break;case 4:qf.gm(n.j,i,56,!0)}if(zf.pJb(Gf.zVb(m).substr(0,6),"M  ALS")&&(i=zf.$Hb(zf.EJb((Gf.tVb(7,10,Gf.zVb(m).length),Gf.zVb(m).substr(7,3))),Ot,I)-1)>=0){for(U=zf.$Hb(zf.EJb((Gf.tVb(10,13,Gf.zVb(m).length),Gf.zVb(m).substr(10,3))),Ot,I),Gf.uVb(14,Gf.zVb(m).length),o=84==Gf.zVb(m).charCodeAt(14),E=$l(Qf.Mmb,G,6,U,15,1),e=16,H=0;H<U;++H,e+=4)k=zf.EJb((Gf.tVb(e,e+4,Gf.zVb(m).length),Gf.zVb(m).substr(e,e+4-e))),E[H]=qf._m(k,1);qf.nm(n.j,i,6),qf.bm(n.j,i,E,o)}if(zf.pJb(Gf.zVb(m).substr(0,6),"M  SUB")&&(D=zf.$Hb(zf.EJb((Gf.tVb(6,9,Gf.zVb(m).length),Gf.zVb(m).substr(6,3))),Ot,I))>0)for(e=10,Q=14,H=1;H<=D;++H,e+=8,Q+=8)if(i=zf.$Hb(zf.EJb((Gf.tVb(e,e+3,Gf.zVb(m).length),Gf.zVb(m).substr(e,e+3-e))),Ot,I)-1,-2==(B=zf.$Hb(zf.EJb((Gf.tVb(Q,Q+3,Gf.zVb(m).length),Gf.zVb(m).substr(Q,Q+3-Q))),Ot,I)))qf.gm(n.j,i,Gn,!0);else if(B>0){for(R=0,f=0;f<n.j.r;f++)(qf.Mk(n.j,0,f)==i||qf.Mk(n.j,1,f)==i)&&++R;B>R&&qf.gm(n.j,i,dn,!0)}if(zf.pJb(Gf.zVb(m).substr(0,6),"M  RGP")&&(D=zf.$Hb(zf.EJb((Gf.tVb(6,9,Gf.zVb(m).length),Gf.zVb(m).substr(6,3))),Ot,I))>0)for(e=10,Q=14,H=1;H<=D;++H,e+=8,Q+=8)i=zf.$Hb(zf.EJb((Gf.tVb(e,e+3,Gf.zVb(m).length),Gf.zVb(m).substr(e,e+3-e))),Ot,I)-1,(L=zf.$Hb(zf.EJb((Gf.tVb(Q,Q+3,Gf.zVb(m).length),Gf.zVb(m).substr(Q,Q+3-Q))),Ot,I))>=1&&L<=20&&qf.nm(n.j,i,qf._m("R"+L,2));m=xl.zGb(t)}}catch(n){if(sd(n=cd(n),18))return u=n,zf.Jz(u,(zf.aKb(),zf._Jb),""),!1;throw bd(n)}return n.e&&(qf.br(n),qf.Oq(n)),1&n.i&&(n.f=qf.Xn(n.j)),qf.Tq(n,F),qf.nu(n.j,15),!0},qf.gr=function(n,t){var e,i,a,s,r;for(n.b&&Vf.PSb(n.b),n.c&&Vf.PSb(n.c),a=0,i=xl.zGb(t);null!=i&&zf.pJb(Gf.zVb(i).substr(0,7),_t);){for(i=zf.EJb((Gf.uVb(7,Gf.zVb(i).length+1),Gf.zVb(i).substr(7)));r=Gf.zVb("-").length,zf.pJb(Gf.zVb(i).substr(Gf.zVb(i).length-r,r),"-");){if(e=xl.zGb(t),!zf.pJb(Gf.zVb(e).substr(0,7),_t))return!1;i=zf.EJb(zf.lJb(zf.DJb(i,0,Gf.zVb(i).length-1),(Gf.uVb(7,Gf.zVb(e).length+1),Gf.zVb(e).substr(7))))}if(zf.pJb(Gf.zVb(i).substr(0,5),"BEGIN"))if(s=zf.EJb((Gf.uVb(6,Gf.zVb(i).length+1),Gf.zVb(i).substr(6))),zf.pJb(Gf.zVb(s).substr(0,4),"CTAB"))a=1;else if(zf.pJb(Gf.zVb(s).substr(0,4),"ATOM"))a=2;else if(zf.pJb(Gf.zVb(s).substr(0,4),"BOND"))a=3;else{if(!zf.pJb(Gf.zVb(s).substr(0,10),"COLLECTION"))return!1;a=4}else if(zf.pJb(Gf.zVb(i).substr(0,3),"END"))a=0;else if(1==a)qf._q(n,i);else if(2==a)qf.Xq(n,i);else if(3==a)qf.Zq(n,i);else{if(4!=a)return!1;qf.$q(n,i)}i=xl.zGb(t)}for(;null!=i&&!zf.pJb(Gf.zVb(i).substr(0,6),Kt)&&!zf.pJb(i,Wt);)i=xl.zGb(t);return!0},qf.hr=function(){this.i=0},qf.ir=function(){this.i=1},Ol(112,1,{},qf.hr,qf.ir),o.a=!1,o.d=!1,o.e=!1,o.g=!1,o.i=0,o.k=!1,Qf.rnb=hd(112),qf.jr=function(n){},qf.kr=function(t,e,i){var a,s,r,o,f,l,d,g,u,c,b,h,D,j,m,A,C,p,M,I,P,T,N,w,U,J,L,y,B;for(zf.UJb(t.a,"M  V30 BEGIN CTAB\n"),zf.UJb(t.a,$t+e.q+" "+e.r+" 0 0 0"+H),zf.UJb(t.a,"M  V30 BEGIN ATOM\n"),l=0;l<e.q;l++){if(zf.UJb(t.a,_t+(l+1)),null!=(null==e.v?null:e.v[l])){for(g=null==e.v?null:e.v[l],p=Sd(wd(e.B[l],1),0),zf.UJb(t.a,p?" NOT[":" ["),A=0;A<g.length;A++)switch(A>0&&zf.UJb(t.a,","),C=(qf.Jj(),qf.Dj)[g[A]],Gf.zVb(C).length){case 2:case 3:case 1:zf.UJb(t.a,C);break;default:zf.UJb(t.a,"?")}zf.UJb(t.a,"]")}else Sd(wd(e.B[l],1),0)?zf.UJb(t.a," A"):e.C[l]>=129&&e.C[l]<=144||154==e.C[l]?zf.UJb(t.a," R#"):zf.UJb(t.a," "+(qf.Jj(),qf.Dj)[e.C[l]]);if(i?(zf.UJb(t.a," "+ud(R*t.b*e.J[l].a)/R),zf.UJb(t.a," "+ud(R*t.b*-e.J[l].b)/R),zf.UJb(t.a," "+ud(R*t.b*-e.J[l].c)/R)):zf.UJb(t.a," 0 0 0"),zf.UJb(t.a," "+n.Math.abs(e.w[l])),0!=e.s[l]&&zf.UJb(t.a," CHG="+e.s[l]),48&e.u[l])switch(zf.UJb(t.a," RAD="),48&e.u[l]){case 16:zf.UJb(t.a,"1");break;case 32:zf.UJb(t.a,"2");break;case 48:zf.UJb(t.a,"3")}1!=(3&e.u[l])&&2!=(3&e.u[l])||(zf.UJb(t.a," CFG="),1==(3&e.u[l])?zf.UJb(t.a,"1"):zf.UJb(t.a,"2")),0!=e.A[l]&&zf.UJb(t.a," MASS="+e.A[l]),-1!=(B=((e.u[l]&Mt)>>>27)-1)&&zf.UJb(t.a," VAL="+(0==B?"-1":zf.FIb(B))),((u=e.C[l])>=129&&u<=144||154==u)&&zf.UJb(t.a," RGROUPS=(1 "+(154==u?0:u>=142?u-141:u-125)+")"),0==Ud(m=wd(bn,e.B[l]),384)?zf.UJb(t.a," HCOUNT=2"):0==Ud(m,128)?zf.UJb(t.a," HCOUNT=1"):0==Ud(m,1792)?zf.UJb(t.a," HCOUNT=-1"):0==Ud(m,1664)&&zf.UJb(t.a," HCOUNT=1"),0!=Ud(J=wd(e.B[l],6144),0)&&(Sd(wd(J,dn),0)?zf.UJb(t.a," SUBST="+(e.e[l]+1)):zf.UJb(t.a," SUBST=-1")),0!=Ud(N=wd(e.B[l],120),0)&&(0==Ud(N,112)?zf.UJb(t.a," RBCNT=-1"):0==Ud(N,8)||0==Ud(N,104)?zf.UJb(t.a," RBCNT=2"):0==Ud(N,88)?zf.UJb(t.a," RBCNT=3"):0==Ud(N,56)&&zf.UJb(t.a," RBCNT=4")),zf.UJb(t.a,H)}for(zf.UJb(t.a,"M  V30 END ATOM\n"),zf.UJb(t.a,"M  V30 BEGIN BOND\n"),b=0;b<e.r;b++){switch(zf.UJb(t.a,_t+(b+1)),e.H[b]){case 1:default:P=1,U=0;break;case 2:P=2,U=0;break;case 4:P=3,U=0;break;case 129:P=1,U=3;break;case 257:P=1,U=1;break;case 386:P=2,U=2;break;case 64:P=4,U=0;break;case 32:P=9,U=0}0!=(D=31&e.G[b])&&(P=8==D?4:3==D?5:9==D?6:10==D?7:8),zf.UJb(t.a," "+P+" "+(e.D[0][b]+1)+" "+(e.D[1][b]+1)),0!=U&&zf.UJb(t.a," CFG="+U),0!=(L=0==(w=384&e.G[b])?0:256==w?1:2)&&zf.UJb(t.a," TOPO="+L),zf.UJb(t.a,H)}for(zf.UJb(t.a,"M  V30 END BOND\n"),T=!1,a=0,M=$l(Qf.Mmb,G,6,32,15,1),r=$l(Qf.Mmb,G,6,32,15,1),d=0;d<e.f;d++)1!=(3&e.u[d])&&2!=(3&e.u[d])||(T=!0,1==(y=(e.u[d]&Kn)>>18)?++r[(e.u[d]&Kn)>>18!=1&&(e.u[d]&Kn)>>18!=2?-1:(e.u[d]&It)>>20]:2==y?++M[(e.u[d]&Kn)>>18!=1&&(e.u[d]&Kn)>>18!=2?-1:(e.u[d]&It)>>20]:++a);for(s=0,I=$l(Qf.Mmb,G,6,32,15,1),o=$l(Qf.Mmb,G,6,32,15,1),h=0;h<e.g;h++)2==qf.Uk(e,h)||1!=(3&e.F[h])&&2!=(3&e.F[h])||(T=!0,1==(y=(768&e.F[h])>>8)?++o[(768&e.F[h])>>8!=1&&(768&e.F[h])>>8!=2?-1:(e.F[h]&Pt)>>10]:2==y?++I[(768&e.F[h])>>8!=1&&(768&e.F[h])>>8!=2?-1:(e.F[h]&Pt)>>10]:++s);if(T){if(zf.UJb(t.a,"M  V30 BEGIN COLLECTION\n"),0!=a){for(zf.UJb(t.a,"M  V30 MDLV30/STEABS ATOMS=("+a),f=0;f<e.f;f++)(1==(3&e.u[f])||2==(3&e.u[f]))&&!((e.u[f]&Kn)>>18)&&zf.UJb(t.a," "+(f+1));zf.UJb(t.a,ne)}if(0!=s){for(zf.UJb(t.a,"M  V30 MDLV30/STEABS BONDS=("+s),c=0;c<e.g;c++)2!=qf.Uk(e,c)&&(1==(3&e.F[c])||2==(3&e.F[c]))&&!((768&e.F[c])>>8)&&zf.UJb(t.a," "+(c+1));zf.UJb(t.a,ne)}for(j=0;j<32;j++){if(0!=M[j]){for(zf.UJb(t.a,te+(j+1)+" ATOMS=("+M[j]),f=0;f<e.f;f++)(1==(3&e.u[f])||2==(3&e.u[f]))&&(e.u[f]&Kn)>>18==2&&((e.u[f]&Kn)>>18!=1&&(e.u[f]&Kn)>>18!=2?-1:(e.u[f]&It)>>20)==j&&zf.UJb(t.a," "+(f+1));zf.UJb(t.a,ne)}if(0!=r[j]){for(zf.UJb(t.a,ee+(j+1)+" ATOMS=("+r[j]),f=0;f<e.f;f++)(1==(3&e.u[f])||2==(3&e.u[f]))&&(e.u[f]&Kn)>>18==1&&((e.u[f]&Kn)>>18!=1&&(e.u[f]&Kn)>>18!=2?-1:(e.u[f]&It)>>20)==j&&zf.UJb(t.a," "+(f+1));zf.UJb(t.a,ne)}if(0!=I[j]){for(zf.UJb(t.a,te+(j+1)+" BONDS=("+I[j]),c=0;c<e.g;c++)2!=qf.Uk(e,c)&&(1==(3&e.F[c])||2==(3&e.F[c]))&&(768&e.F[c])>>8==2&&((768&e.F[c])>>8!=1&&(768&e.F[c])>>8!=2?-1:(e.F[c]&Pt)>>10)==j&&zf.UJb(t.a," "+(c+1));zf.UJb(t.a,ne)}if(0!=o[j]){for(zf.UJb(t.a,ee+(j+1)+" BONDS=("+o[j]),c=0;c<e.g;c++)2!=qf.Uk(e,c)&&(1==(3&e.F[c])||2==(3&e.F[c]))&&(768&e.F[c])>>8==1&&((768&e.F[c])>>8!=1&&(768&e.F[c])>>8!=2?-1:(e.F[c]&Pt)>>10)==j&&zf.UJb(t.a," "+(c+1));zf.UJb(t.a,ne)}}zf.UJb(t.a,"M  V30 END COLLECTION\n")}zf.UJb(t.a,"M  V30 END CTAB\n")},qf.lr=function(){qf.jr(this),this.a=new zf.YJb},qf.mr=function(n){qf.nr.call(this,n)},qf.nr=function(n){qf.or.call(this,n,new zf.YJb)},qf.or=function(n,t){var e,i;qf.jr(this),qf.nu(n,15),this.a=t,i=null!=n.P?n.P:"",zf.UJb(this.a,i+H),zf.UJb(this.a,"Actelion Java MolfileCreator 2.0\n\n"),zf.UJb(this.a,"  0  0  0  0  0  0              0 V3000\n"),this.b=1,(e=qf.qr(n))&&(this.b=qf.pr(n)),qf.kr(this,n,e),zf.UJb(this.a,vt)},qf.pr=function(t){var e,i,a,s,r,o,f,l,d;if(d=1,0!=(a=qf.Jk(t,t.q,t.r,(qf.Jj(),qf.Ij))))(a<1||a>3)&&(d=1.5/a);else{for(l=ie,e=1;e<t.q;e++)for(i=0;i<e;i++)l>(s=(r=t.J[i].a-t.J[e].a)*r+(o=t.J[i].b-t.J[e].b)*o+(f=t.J[i].c-t.J[e].c)*f)&&(l=s);d=3/n.Math.max(.75,l)}return d},qf.qr=function(n){var t;if(1==n.q)return!0;for(t=1;t<n.q;t++)if(n.J[t].a!=n.J[0].a||n.J[t].b!=n.J[0].b||n.J[t].c!=n.J[0].c)return!0;return!1},qf.rr=function(n,t){var e;return(e=new qf.lr).b=t,qf.nu(n,15),qf.kr(e,n,!0),e.a.a},Ol(136,1,{},qf.lr,qf.mr),o.b=1,Qf.snb=hd(136),qf.ur=function(){qf.ur=vl,qf.sr=ed(Wl(Qf.zwb,2),j,14,0,[ed(Wl(Qf.zwb,1),L,2,6,["Acyl","gCaHA`AIf`@"]),ed(Wl(Qf.zwb,1),L,2,6,["Alloc","gNph@l@ILzuR@@"]),ed(Wl(Qf.zwb,1),L,2,6,["Allyl","Al"]),ed(Wl(Qf.zwb,1),L,2,6,["Benzyl;Bn","daD@`F@DjUZxHH@@"]),ed(Wl(Qf.zwb,1),L,2,6,["Boc","daxD`@S@AIgijj@@"]),ed(Wl(Qf.zwb,1),L,2,6,["BOM;BzOM","deTH`@H@Re[TYj`@@@"]),ed(Wl(Qf.zwb,1),L,2,6,["Bs","dmtDpAdLS`aPAIe]jf`@e`@@"]),ed(Wl(Qf.zwb,1),L,2,6,["Bt","dew@`@aJ@DiY]paej`@@@"]),ed(Wl(Qf.zwb,1),L,2,6,["Btm","did@P@BJ@Die_ahH@@@"]),ed(Wl(Qf.zwb,1),L,2,6,["Butyl;nButyl","gJPHB@IRuP@"]),ed(Wl(Qf.zwb,1),L,2,6,["Benzoyl;Bz","didH`@p@RYm^Eh@@@@"]),ed(Wl(Qf.zwb,1),L,2,6,["Bzh","dg|@`N@LdbRbtJUB]aAP@@@@"]),ed(Wl(Qf.zwb,1),L,2,6,["Cbz","dmtD`@S@AIgYVUZh@@@@"]),ed(Wl(Qf.zwb,1),L,2,6,["cButyl","gKPHL@IThuT@@"]),ed(Wl(Qf.zwb,1),L,2,6,["cHeptyl","daD@`L@DjWVzjj`@"]),ed(Wl(Qf.zwb,1),L,2,6,["cHexyl","gOpHL@IToWUU@@"]),ed(Wl(Qf.zwb,1),L,2,6,["cOctyl","did@`L@DjWWajjj@@"]),ed(Wl(Qf.zwb,1),L,2,6,["cPentyl","gFpHL@ITimUP@"]),ed(Wl(Qf.zwb,1),L,2,6,["cPropyl","gBPHL@Qxjh@"]),ed(Wl(Qf.zwb,1),L,2,6,["COOH","gC`h@l@ILt@@ !Bb@K~@Hc}"]),ed(Wl(Qf.zwb,1),L,2,6,["DEAE","daz@`@x@RiUjj`@"]),ed(Wl(Qf.zwb,1),L,2,6,["DEIPS","diD@P@\\B@DjfVjj`@"]),ed(Wl(Qf.zwb,1),L,2,6,["DMIPS","gNpD@xD@RjZjh@"]),ed(Wl(Qf.zwb,1),L,2,6,["DMPM","dcLD`@kPCIEMDdcttDDT@@"]),ed(Wl(Qf.zwb,1),L,2,6,["DMPS","deT@P@\\B@LddTjPsU@@@@"]),ed(Wl(Qf.zwb,1),L,2,6,["DMTr","fak@b@@Mt@ISZ{SMjo{NQKfm@AU@@@E@@@@"]),ed(Wl(Qf.zwb,1),L,2,6,["DNP","dkmB`hdDt~@HeNfS{HihheCAUhBHX@@"]),ed(Wl(Qf.zwb,1),L,2,6,["DNS;Dan","fhi`a@KPP@HH@YIHYheEhYKQgKP@@QP@@@"]),ed(Wl(Qf.zwb,1),L,2,6,["DPIPS","fdyAA@H@\\B@FRRIQSQIHzp_Qjh@h@@@@@"]),ed(Wl(Qf.zwb,1),L,2,6,["DPTBS","fleAA@H@\\B@FRRIQSRIIWNbEMU@EP@@@@@"]),ed(Wl(Qf.zwb,1),L,2,6,["DTBMS","dmT@P@\\B@Djffjjjh@@"]),ed(Wl(Qf.zwb,1),L,2,6,["Ethyl","eMBD@ch@"]),ed(Wl(Qf.zwb,1),L,2,6,["Fmoc","fde@b@@Hp@IL{LrjxeVCzKUT@@@P@@@"]),ed(Wl(Qf.zwb,1),L,2,6,["iAmyl","gGPHJ@YIDZj@@"]),ed(Wl(Qf.zwb,1),L,2,6,["iButyl","gJPHB@ITuP@"]),ed(Wl(Qf.zwb,1),L,2,6,["Im","gFtHAj@IRnKSP@"]),ed(Wl(Qf.zwb,1),L,2,6,["iPropyl","gC`HL@Qz`@"]),ed(Wl(Qf.zwb,1),L,2,6,["MDIPS","diD@P@\\B@DjfZjj`@"]),ed(Wl(Qf.zwb,1),L,2,6,["MDPS","foA@A@@NA@CIIEEBdeeVLzj@@@@@@"]),ed(Wl(Qf.zwb,1),L,2,6,["Methyl","eFBH@c@@"]),ed(Wl(Qf.zwb,1),L,2,6,["MEM","gNphAR@IRoUT@@"]),ed(Wl(Qf.zwb,1),L,2,6,["Mes","deT@`J@DjY{[`bB`@@"]),ed(Wl(Qf.zwb,1),L,2,6,["MMTr","ffcAB@@Z@Dim]ifuWYrI\\uh@Jh@@@@@@"]),ed(Wl(Qf.zwb,1),L,2,6,["MOM","gCaHA`AJZ`@"]),ed(Wl(Qf.zwb,1),L,2,6,["MPM;PMB","deTH`@d@Rfuunh@J@@"]),ed(Wl(Qf.zwb,1),L,2,6,["Ms","gJPdH`DD@cuh@"]),ed(Wl(Qf.zwb,1),L,2,6,["MTM","gC`D@DX@Rfh@"]),ed(Wl(Qf.zwb,1),L,2,6,["mTolyl","daD@`N@DjWjXHB@@"]),ed(Wl(Qf.zwb,1),L,2,6,["N3","gClHaE`@RnReX@"]),ed(Wl(Qf.zwb,1),L,2,6,["nAmyl;Amyl","gGPHJ@IRmU@@"]),ed(Wl(Qf.zwb,1),L,2,6,["neoAm","gGPHJ@IUMU@@"]),ed(Wl(Qf.zwb,1),L,2,6,["NO2,Nitro","gChhhE`BRnRYh@"]),ed(Wl(Qf.zwb,1),L,2,6,["Np","deVDaHAI@HeNR[e_aZ@B@@"]),ed(Wl(Qf.zwb,1),L,2,6,["nPropyl;Propyl","gC`HL@IST@@"]),ed(Wl(Qf.zwb,1),L,2,6,["oTolyl","daD@`J@DjYvxH`@@"]),ed(Wl(Qf.zwb,1),L,2,6,["Phenyl","gOpHL@IToVD@@@"]),ed(Wl(Qf.zwb,1),L,2,6,["Pht","dcLL`@RU@Dfyed]ZBA`@@"]),ed(Wl(Qf.zwb,1),L,2,6,["Piv;Pv","gNqHA`AIffj`@"]),ed(Wl(Qf.zwb,1),L,2,6,["PMBM","dcLD`@T`AJUm]FZh@J@@"]),ed(Wl(Qf.zwb,1),L,2,6,["PNB","dcNLaHAEt@bTyInUvxV`@f@@"]),ed(Wl(Qf.zwb,1),L,2,6,["Poc","didD`@S@AIgexVjj`@"]),ed(Wl(Qf.zwb,1),L,2,6,["PPi","diDFsHSB[`|J|A@Lxn{lddqdZih@@"]),ed(Wl(Qf.zwb,1),L,2,6,["pTolyl","daD@`N@DjWzXHB@@"]),ed(Wl(Qf.zwb,1),L,2,6,["sAmyl","gGPHL@YIDZj@@"]),ed(Wl(Qf.zwb,1),L,2,6,["sButyl","gJPHL@ITuP@"]),ed(Wl(Qf.zwb,1),L,2,6,["SEM","diDHPFApD@rRQUJjj`@"]),ed(Wl(Qf.zwb,1),L,2,6,["SES","dedDpHP@``AgCIICeHmUT@@"]),ed(Wl(Qf.zwb,1),L,2,6,["SO3H","gJQdHl@``D^m@@"]),ed(Wl(Qf.zwb,1),L,2,6,["tAmyl","gGPHB@IUMU@@"]),ed(Wl(Qf.zwb,1),L,2,6,["TBDMS;TBS","dax@P@\\B@Djfjjh@@"]),ed(Wl(Qf.zwb,1),L,2,6,["TBDPS","fdy@A@@NA@CIIEEEIde]XOhuPAT@@@@@"]),ed(Wl(Qf.zwb,1),L,2,6,["TBMPS","dg\\HPHApH@rRQJJPjg]UAT@@@"]),ed(Wl(Qf.zwb,1),L,2,6,["tButyl,tBu","gJPHB@Q}T@@"]),ed(Wl(Qf.zwb,1),L,2,6,["TDS","ded@P@\\B@LddTeeUUP@@"]),ed(Wl(Qf.zwb,1),L,2,6,["Tf","daxDhHP@``BiAiCiCIICHmU@@"]),ed(Wl(Qf.zwb,1),L,2,6,["TFA","gNqBJIARFdF@YEHYUL@@"]),ed(Wl(Qf.zwb,1),L,2,6,["Thexyl","gNpHB@IUMUT@@"]),ed(Wl(Qf.zwb,1),L,2,6,["THF","gFqH@PAJYujj@@"]),ed(Wl(Qf.zwb,1),L,2,6,["THP","gOqH@PAJYZzjh@"]),ed(Wl(Qf.zwb,1),L,2,6,["TIPS","dmT@P@\\B@DjfYjjjh@@"]),ed(Wl(Qf.zwb,1),L,2,6,["TMS","gJPD@xD@czh@"]),ed(Wl(Qf.zwb,1),L,2,6,["Tosyl;Ts","dmtDPHP@``CIICLeaeZ@B@@"]),ed(Wl(Qf.zwb,1),L,2,6,["Troc","diDDHJxHaHcH`PCHiBeJjf@@"]),ed(Wl(Qf.zwb,1),L,2,6,["Trt","fbm@B@A@FRQIRKQPiIZdoIcdHJ`@@@@@@"]),ed(Wl(Qf.zwb,1),L,2,6,["Xyl","did@`J@DjYynBHH@@"])])},qf.vr=function(){var n,t,e,i,a,s,r,o;for(qf.ur(),qf.tr=new Vf.cTb,r=0,o=(s=qf.sr).length;r<o;++r)for(a=s[r],e=0,i=(t=zf.AJb(a[0],";")).length;e<i;++e)n=t[e],Vf.WSb(qf.tr,zf.yJb(Gf.zVb(n).toLowerCase(),"-"),a[1])},qf.wr=function(n){var t,e,i;for(qf.ur(),!qf.tr&&qf.vr(),n=zf.yJb(Gf.zVb(n).toLowerCase(),"-"),t=new Vf.mTb(new Vf.rTb(new Vf.mPb(qf.tr).a).b),i=new Vf.uPb(t);Vf.WNb(i.a.a);)if(e=Vf.kTb(i.a).Xd(),zf.pJb(Gf.zVb(e).substr(0,Gf.zVb(n).length),n))return!0;return!1},qf.tr=null,qf.xr=function(n,t,e){var i,a,s,r,o,f,l,d,g,u,c,b;for(l=n.g.M,d=0,s=0;s<e;s++)l>t[s]&&(l=t[s],d=s);for(b=$l(Qf.Mmb,G,6,e,15,1),g=d<e-1?d+1:0,o=t[d>0?d-1:e-1]<t[g],r=0;r<e;r++)b[r]=t[d],o?--d<0&&(d=e-1):++d==e&&(d=0);for(a=0;a<n.i.a.length;a++)if((c=Vf.Oi(n.i,a)).length==e){for(i=!0,f=0;f<e;f++)if(c[f]!=b[f]){i=!1;break}if(i)return}Vf.Ji(n.i,b),u=qf.Jr(n,b),Vf.Ji(n.j,u),qf.$r(n,b,u)},qf.yr=function(n,t,e){var i,a,s,r,o,f,l;for(f=$l(Qf.Mmb,G,6,n.f,15,1),r=$l(Qf.Mmb,G,6,n.f,15,1),l=$l(Qf.nyb,tn,6,n.g.f,16,1),i=qf.Mk(n.g,0,t),a=qf.Mk(n.g,1,t),f[0]=i,f[1]=a,r[1]=-1,l[a]=!0,o=1;o>=1;)if(++r[o],r[o]!=qf.Kn(n.g,f[o])){if(!l[s=qf.Jn(n.g,f[o],r[o])]&&!e[s])if(s==i&&o>1){if(qf.xr(n,f,o+1),n.i.a.length>=hn)return}else o+1<n.f&&(f[++o]=s,l[s]=!0,r[o]=-1)}else l[f[o]]=!1,--o},qf.zr=function(n,t,e,i,a,s,r,o){var f,l,d,g,u,c,b,h,D,H,j,m,A,C,p,M,I,P,T;for(u=0,c=(g=M=Vf.Oi(n.i,t)).length;u<c;++u)if(d=g[u],!qf.Wr(n,d))return!0;for(P=(I=Vf.Oi(n.j,t)).length,b=0,l=0,T=!1,C=0;C<P;C++)b<<=1,l<<=1,qf.Yr(n,I[C])?b|=1:o&&qf.Vr(n,I[C])?(b|=1,l|=1):-1!=(f=e[t][C])&&(i[f]?a[f]&&(b|=1,s[f]||(l|=1)):T=!0);switch(A=!1,P){case 3:for(h=ed(Wl(Qf.Mmb,1),G,6,15,[2,1,4]),A=!0,m=0;m<3;m++)(b&h[m])==h[m]&&(6==qf.Hk(n.g,M[m])&&1==qf.qk(n.g,M[m])||5==qf.Hk(n.g,M[m])&&0==qf.qk(n.g,M[m]))&&(a[t]=!0,r[t]=m,!(l&h[m])&&(A=!1));break;case 5:for(D=ed(Wl(Qf.Mmb,1),G,6,15,[10,5,18,9,20]),A=!0,p=0;p<5;p++)if((b&D[p])==D[p])switch(qf.Hk(n.g,M[p])){case 6:-1==qf.qk(n.g,M[p])&&(a[t]=!0,r[t]=p,!(l&D[p])&&(A=!1));break;case 7:qf.qk(n.g,M[p])<=0&&(a[t]=!0,r[t]=p);break;case 8:a[t]=!0,r[t]=p;break;case 16:case 34:case 52:2==qf.Kn(n.g,M[p])&&(a[t]=!0,r[t]=p)}break;case 6:A=!0,21&~b||(a[t]=!0,!(21&l)&&(A=!1)),42&~b||(a[t]=!0,!(42&l)&&(A=!1));break;case 7:for(H=ed(Wl(Qf.Mmb,1),G,6,15,[42,21,74,37,82,41,84]),A=!0,j=0;j<7;j++)(b&H[j])==H[j]&&(6==qf.Hk(n.g,M[j])&&(1==qf.qk(n.g,M[j])||o&&qf.Mr(n,M[j]))||5==qf.Hk(n.g,M[j])&&0==qf.qk(n.g,M[j]))&&(a[t]=!0,r[t]=j,!(l&H[j])&&(A=!1))}return a[t]&&!A&&(s[t]=!0),!!a[t]||!T},qf.Ar=function(n,t,e,i,a){var s,r,o,f,l,d,g,u,c,b,h,D;for(s=$l(Qf.Mmb,ft,8,n.i.a.length,0,2),l=0;l<n.i.a.length;l++)for(s[l]=$l(Qf.Mmb,G,6,Vf.Oi(n.i,l).length,15,1),d=0;d<Vf.Oi(n.i,l).length;d++)s[l][d]=-1;for(h=$l(Qf.Mmb,G,6,n.g.g,15,1),c=0;c<n.j.a.length;c++)if(3==(b=Vf.Oi(n.j,c)).length||b.length>=5&&b.length<=7)for(f=0;f<b.length;f++)o=b[f],3==qf.Kn(n.g,qf.Mk(n.g,0,o))&&3==qf.Kn(n.g,qf.Mk(n.g,1,o))&&(h[o]>0?(s[h[o]>>>16][32767&h[o]]=c,s[c][f]=h[o]>>>16):h[o]=(c<<16)+Lt+f);for(r=$l(Qf.nyb,tn,6,n.i.a.length,16,1),D=0,g=-1;D>g;)for(g=D,u=0;u<n.i.a.length;u++)r[u]||qf.zr(n,u,s,r,t,e,i,a)&&(r[u]=!0,++D)},qf.Br=function(n,t,e){var i,a,s,r,o,f,l,d,g,u,c,b;for(a=qf.Mk(n.g,0,t),s=qf.Mk(n.g,1,t),f=$l(Qf.Mmb,G,6,n.g.f,15,1),l=$l(Qf.Mmb,G,6,n.g.f,15,1),d=$l(Qf.Mmb,G,6,n.g.f,15,1),f[0]=a,f[1]=s,l[a]=1,l[s]=2,d[a]=-1,d[s]=a,o=1,g=1;o<=g;){for(u=0;u<qf.Kn(n.g,f[o]);u++){if(r=qf.Jn(n.g,f[o],u),o>1&&r==a){for(b=$l(Qf.Mmb,G,6,l[f[o]],15,1),i=f[o],c=0;c<b.length;c++)b[c]=i,i=d[i];return b}0!=l[r]||e[r]||(f[++g]=r,l[r]=l[f[o]]+1,d[r]=f[o])}++o}return null},qf.Cr=function(n,t,e){var i,a;for(a=Vf.Oi(n.i,t),i=0;i<a.length;i++)if(e==a[i])return i;return-1},qf.Dr=function(n,t){return n.a[t]&B},qf.Er=function(n,t,e){var i,a;for(a=Vf.Oi(n.j,t),i=0;i<a.length;i++)if(e==a[i])return i;return-1},qf.Fr=function(n,t){return n.b[t]&B},qf.Gr=function(n,t){return n.c[t]},qf.Hr=function(n,t){return Vf.Oi(n.i,t)},qf.Ir=function(n,t){return Vf.Oi(n.j,t)},qf.Jr=function(n,t){var e,i,a,s,r;for(s=t.length,r=$l(Qf.Mmb,G,6,s,15,1),i=0;i<s;i++)for(e=i==s-1?t[0]:t[i+1],a=0;a<qf.Kn(n.g,t[i]);a++)if(qf.Jn(n.g,t[i],a)==e){r[i]=qf.Ln(n.g,t[i],a);break}return r},qf.Kr=function(n,t){return Vf.Oi(n.j,t).length},qf.Lr=function(n,t,e){var i;for(i=0;i<n.j.a.length;i++)if(qf.Rr(n,i,t)&&qf.Rr(n,i,e))return i;return-1},qf.Mr=function(n,t){var e;for(e=0;e<qf.Kn(n.g,t);e++)if(2==qf.Mn(n.g,t,e)&&8==qf.Hk(n.g,qf.Jn(n.g,t,e)))return!0;return!1},qf.Nr=function(n,t){return n.d[t]},qf.Or=function(n,t){return!!(n.a[t]&y)},qf.Pr=function(n,t){return!!(n.b[t]&y)},qf.Qr=function(n,t,e){var i,a;for(a=Vf.Oi(n.i,t),i=0;i<a.length;i++)if(e==a[i])return!0;return!1},qf.Rr=function(n,t,e){var i,a;for(a=Vf.Oi(n.j,t),i=0;i<a.length;i++)if(e==a[i])return!0;return!1},qf.Sr=function(n,t){return n.e[t]},qf.Tr=function(n,t){return!!(n.b[t]&gt)},qf.Ur=function(n,t){return!!(n.a[t]&_n)},qf.Vr=function(n,t){var e,i,a,s,r,o;for(r=0;r<2;r++)if(e=qf.Mk(n.g,r,t),7==qf.Hk(n.g,e)&&2==qf.Kn(n.g,e)&&(i=qf.Mk(n.g,1-r,t),6==qf.Hk(n.g,i)))for(o=0;o<qf.Kn(n.g,i);o++)if(a=qf.Jn(n.g,i,o),s=qf.Ln(n.g,i,o),(8==qf.Hk(n.g,a)||16==qf.Hk(n.g,a))&&2==qf.Uk(n.g,s)&&1==qf.Kn(n.g,a))return!0;return!1},qf.Wr=function(n,t){var e,i,a,s,r;if(n.g.K){if(Sd(wd(qf.Ck(n.g,t),1),0))return!0;if(null!=(r=qf.xk(n.g,t))){for(a=0,s=(i=r).length;a<s;++a)if(5==(e=i[a])||6==e||7==e||8==e||15==e||16==e||33==e||34==e)return!0;return!1}}return qf.cs(qf.Hk(n.g,t))},qf.Xr=function(n,t){var e,i,a,s,r;if(n.g.K){if(Sd(wd(qf.Ck(n.g,t),1),0))return!1;if(null!=(e=qf.xk(n.g,t))){for(s=0,r=(a=e).length;s<r;++s)if(i=a[s],!qf.an(i))return!1;return!0}}return qf.an(qf.Hk(n.g,t))},qf.Yr=function(n,t){return qf.Uk(n.g,t)>1||64==qf.Xk(n.g,t)},qf.Zr=function(n){var t,e,i,a,s,r,o,f,l,d,g,u,c,b,h,D;for(D=0;D<n.d.length;D++)if(n.d[D]){for(h=!1,s=0,o=(i=Vf.Oi(n.i,D)).length;s<o;++s)t=i[s],n.a[t]|=y,qf.Xr(n,t)&&(h=!0);for(u=0,b=(d=Vf.Oi(n.j,D)).length;u<b;++u)f=d[u],n.b[f]|=y;if(n.e[D]){for(a=0,r=(e=Vf.Oi(n.i,D)).length;a<r;++a)t=e[a],n.a[t]|=gt;for(g=0,c=(l=Vf.Oi(n.j,D)).length;g<c;++g)f=l[g],n.b[f]|=gt}if(h){for(a=0,r=(e=Vf.Oi(n.i,D)).length;a<r;++a)t=e[a],n.a[t]|=_n;for(g=0,c=(l=Vf.Oi(n.j,D)).length;g<c;++g)f=l[g],n.b[f]|=_n}}},qf.$r=function(n,t,e){var i,a,s,r;for(r=t.length,s=0;s<r;s++)(0==(i=n.a[t[s]]&B)||i>r)&&(n.a[t[s]]&=nt,n.a[t[s]]|=r);for(a=0;a<r;a++)(0==(i=n.b[e[a]]&B)||i>r)&&(n.b[e[a]]&=nt,n.b[e[a]]|=r)},qf._r=function(n,t,e){var i;for(i=Vf.Oi(n.j,t).length;e>=i;)e-=i;for(;e<0;)e+=i;return e},qf.as=function(n,t){qf.bs.call(this,n,t)},qf.bs=function(n,t){var e,i,a,s,r,o,f,l,d,g,u,c,b,h,D,H,j;this.g=n,this.f=7,this.i=new Vf.bj,this.j=new Vf.bj,this.a=$l(Qf.Mmb,G,6,this.g.f,15,1),this.b=$l(Qf.Mmb,G,6,this.g.g,15,1),this.g.Mb(1),u=$l(Qf.nyb,tn,6,this.g.f,16,1),c=$l(Qf.nyb,tn,6,this.g.g,16,1);do{for(r=!1,e=0;e<this.g.f;e++)if(!u[e]){for(D=0,g=0;g<qf.Kn(this.g,e);g++)u[qf.Jn(this.g,e,g)]||++D;if(D<2){for(u[e]=!0,d=0;d<qf.Kn(this.g,e);d++)c[qf.Ln(this.g,e,d)]=!0;r=!0}}}while(r);for(j=0;j<this.g.f&&u[j];)++j;if(j!=this.g.f){for((f=$l(Qf.Mmb,G,6,this.g.f,15,1))[0]=j,(h=$l(Qf.Mmb,G,6,this.g.f,15,1))[0]=-1,(o=$l(Qf.Mmb,G,6,this.g.f,15,1))[j]=1,s=0,l=0,b=1;s<=l;){for(d=0;d<qf.Kn(this.g,f[s]);d++)(a=qf.Jn(this.g,f[s],d))!=h[f[s]]&&(0==o[a]?u[a]||(o[a]=b,h[a]=f[s],f[++l]=a):qf.yr(this,qf.Ln(this.g,f[s],d),u));if(++s>l)for(e=0;e<this.g.f;e++)if(0==o[e]&&!u[e]){o[e]=++b,f[++l]=e,h[e]=-1;break}}if(4&t&&(this.d=$l(Qf.nyb,tn,6,this.i.a.length,16,1),this.e=$l(Qf.nyb,tn,6,this.i.a.length,16,1),this.c=$l(Qf.Mmb,G,6,this.i.a.length,15,1),qf.Ar(this,this.d,this.e,this.c,!!(8&t)),qf.Zr(this)),2&t)for(i=0;i<this.g.g;i++)c[i]||0==qf.Uk(this.g,i)||null!=(H=qf.Br(this,i,u))&&qf.$r(this,H,qf.Jr(this,H))}},qf.cs=function(n){return 5==n||6==n||7==n||8==n||15==n||16==n||33==n||34==n},Ol(170,1,{},qf.as),o.f=0,Qf.tnb=hd(170),qf.ds=function(n,t){var e,i,a,s,r,o,f,l,d,g;if(2==t||5==t)Vf.Ji(n.D,qf.Is(n.F,n.F.length)),n.b&&Vf.Ji(n.a,qf.Js(n.B,n.B.length));else if(4==t)g=qf.ps(qf.Is(n.F,n.F.length)),Vf.QTb(n.N,g)||(Vf.OTb(n.N,g),Vf.Ji(n.D,qf.Is(n.F,n.F.length)),n.b&&Vf.Ji(n.a,qf.Js(n.B,n.B.length)));else if(3==t){if(g=qf.ps(qf.Is(n.F,n.F.length)),!Vf.QTb(n.N,g)){for(d=!1,r=new Vf.mTb(new Vf.rTb(new Vf.mPb(n.N.a).a).b),f=new Vf.uPb(r);Vf.WNb(f.a.a);){for(o=Vf.kTb(f.a).Xd(),l=0,a=0,s=(i=g).length;a<s;++a){for(e=i[a];l<o.length&&o[l]<e;)++l;if(l<o.length&&e==o[l]){d=!0;break}}if(d)break}d||(Vf.OTb(n.N,g),Vf.Ji(n.D,qf.Is(n.F,n.F.length)),n.b&&Vf.Ji(n.a,qf.Js(n.B,n.B.length)))}}else 6==t&&(g=qf.qs(n,qf.Is(n.F,n.F.length)),Vf.QTb(n.N,g)||(Vf.OTb(n.N,g),Vf.Ji(n.D,qf.Is(n.F,n.F.length)),n.b&&Vf.Ji(n.a,qf.Js(n.B,n.B.length))))},qf.es=function(n,t,e){var i,a,s,r,o,f,l,d,g;if(o=qf.Kn(n.G,t),(i=n.n[e])>o)return!1;if(l=qf.Ck(n.G,t),s=qf.Ck(n.g,e),a=qf.xk(n.g,e),f=qf.xk(n.G,t),Sd(wd(s,1),0)){if(null!=a)if(Sd(wd(l,1),0)){if(null==f)return!1;if(!qf.vs(a,f))return!1}else if(null!=f){if(qf.xs(f,a))return!1}else if(qf.us(qf.Hk(n.G,t),a))return!1}else{if(Sd(wd(l,1),0))return!1;if(null!=a){if(null!=f){if(!qf.vs(f,a))return!1}else if(!qf.us(qf.Hk(n.G,t),a))return!1}else{if(null!=f)return!1;if(n.I[t]!=n.j[e])return!1}}if(Sd(Gd(l,s),0)){if(Sd(wd(s,Gn),0)){if(n.G.K&&Ld(wd(l,Gn),0))return!1;if(i!=o)return!1}if(Sd(wd(s,dn),0)&&i>=o&&Ld(wd(l,dn),0))return!1}if(Sd(wd(n.H[t],Xd(n.i[e])),0))return!1;if(Sd(wd(n.A[e],Xd(n.L[t])),0))return!1;if(r=wd(s,v),n.G.K){if(0!=Ud(d=wd(s,v),0)&&(0==Ud(r,0)||Sd(wd(r,Xd(d)),0)))return!1}else if(0!=Ud(r,0)&&Ld(wd(r,n.L[t]),0))return!1;if(0!=qf.qk(n.g,e)&&qf.qk(n.g,e)!=qf.qk(n.G,t))return!1;if(0!=qf.Ak(n.g,e)&&qf.Ak(n.g,e)!=qf.Ak(n.G,t))return!1;if(0!=qf.Dk(n.g,e)&&qf.Dk(n.g,e)!=qf.Dk(n.G,t))return!1;if(0!=(g=Od(qd(wd(qf.Ck(n.g,e),zn),22))))if(n.G.K){if(g!=Od(qd(wd(qf.Ck(n.G,t),zn),22)))return!1}else if(qf.En(n.G,t)!=g)return!1;return!0},qf.fs=function(n,t,e){var i,a,s,r,o,f,l,d,g;if(l=n.J[t],r=n.k[e],qf.Wk(n.g,e)&Ht){if(f=qf.Yk(n.G,t),a=qf.Yk(n.g,e),s=31&qf.Wk(n.g,e),!(f==a||1==f&&1&s||2==f&&2&s||4==f&&4&s||8==f&&32&s||16==f&&64&s||32==f&&16&s||64==f&&8&s))return!1;l&=-32,r&=-32}if(l&~r)return!1;if(0!=(g=(qf.Wk(n.g,e)&wn)>>17)){if(n.G.K&&g==(qf.Wk(n.G,e)&wn)>>17)return!0;for(i=!1,d=qf.mo(n.G),o=0;o<d.i.a.length;o++)if(Vf.Oi(d.j,o).length==g&&qf.Rr(d,o,t)){i=!0;break}if(!i)return!1}return!0},qf.gs=function(n){var t,e;for(n.b=null,t=0;t<n.g.g;t++)qf.pl(n.g,t)&&(!n.b&&(n.b=new Vf.bj),(e=new qf.Ks).a=qf.Mk(n.g,0,t),e.b=qf.Mk(n.g,1,t),e.d=qf.Ok(n.g,t),e.c=qf.Nk(n.g,t),Vf.Ji(n.b,e))},qf.hs=function(t){var e,i,a,s,r,o,f,l,d,g,u,c;for(qf.nu(t.g,t.M),l=n.Math.max(t.g.f,t.g.g)+16,t.r=$l(Qf.Mmb,G,6,l,15,1),t.t=$l(Qf.Mmb,G,6,l,15,1),t.u=$l(Qf.Mmb,G,6,l,15,1),t.s=$l(Qf.nyb,tn,6,l+1,16,1),o=$l(Qf.nyb,tn,6,t.g.f,16,1),f=$l(Qf.nyb,tn,6,t.g.g,16,1),a=0,i=0;i<t.g.f;i++)if(!t.C[i]&&!o[i])for(t.r[a]=i,t.u[a]=-1,t.t[a]=-1,d=a;a<=d;){for(g=0;g<qf.wn(t.g,t.r[a]);g++)d=qf.Fs(t,a,d,g,o,f,-1);for(;t.s[++a];);}if(t.v=a,0!=t.o){for(d=t.v-1,r=0;r<t.d;r++)for(a=0;a<=d;){for(u=0;u<qf.wn(t.g,t.r[a]);u++)d=qf.Fs(t,a,d,u,o,f,r);for(;t.s[++a];);}for(e=0;e<t.g.f;e++)if(t.C[e]&&!o[e])for(t.r[a]=e,t.u[a]=-1,t.t[a]=-1,d=a;a<=d;){for(u=0;u<qf.wn(t.g,t.r[a]);u++)qf.Jn(t.g,t.r[a],u)<t.g.f&&(d=qf.Fs(t,a,d,u,o,f,t.f[e]));for(;t.s[++a];);}for(t.e=$l(Qf.Mmb,G,6,t.d,15,1),c=0;c<t.d;c++)t.e[c]=-1;for(g=t.v;g<a;g++)s=t.f[t.r[g]],-1==t.e[s]&&(t.e[s]=g)}t.w=a},qf.is=function(n,t){var e,i,a,s,r,o,f,l;for(l=qf.mo(n.G),o=0;o<l.i.a.length;o++)if(qf.Rr(l,o,t)){for(f=$l(Qf.Mmb,G,6,2,15,1),a=0;a<2;a++)for(f[a]=I,i=qf.Mk(n.G,a,t),s=0;s<qf.Kn(n.G,i);s++)(e=qf.Jn(n.G,i,s))!=qf.Mk(n.G,1-a,t)&&f[a]>e&&(f[a]=e);return r=0,qf.Qr(l,o,f[0])&&++r,qf.Qr(l,o,f[1])&&++r,2==r?2:1==r?1:2}return 0},qf.js=function(n,t,e){var i,a,s,r,o;if(n.b)for(n.B=$l(Qf.nyb,tn,6,t.length,16,1),a=new Vf.eQb(n.b);a.a<a.c.a.length;)if(i=Vf.dQb(a),null==n.f||-1==e&&-1==n.f[i.a]&&-1==n.f[i.b]||-1!=e&&(n.f[i.a]==e||n.f[i.b]==e)){if(o=$l(Qf.Mmb,G,6,i.c+2,15,1),(s=qf.go(n.G,o,n.F[i.a],n.F[i.b],i.c+1,t,null)-1)<i.d||s>i.c)return!1;for(r=1;r<=s;r++)n.B[o[r]]=!0}return!0},qf.ks=function(n,t){var e,i,a,s,r,o,f,l;for(a=0;a<n.g.g;a++)if(qf.Wk(n.g,a)&bt){if(0==(s=qf.Vk(n.g,a)))continue;if(e=qf.Mk(n.g,0,a),i=qf.Mk(n.g,1,a),null==n.f||-1==t&&-1==n.f[e]&&-1==n.f[i]||-1!=t&&(n.f[e]==t||n.f[i]==t)){if(r=n.F[e],o=n.F[i],f=qf.Hn(n.G,r,o),0==(l=qf.Vk(n.G,f))&&(qf.So(n.G,f)&&(l=qf.is(n,f)),0==l))continue;if(3==s)continue;if(3==l)continue;if(qf.rs(n,a)==(s==l))return!1}}return!0},qf.ls=function(n,t){var e,i,a,s,r,o,f,l,d,g,u,c,b;for(r=0,f=0;f<n.g.f;f++)if((null==n.f||n.f[f]==t)&&Sd(wd(qf.Ck(n.g,f),Xn),0)){if(u=n.F[f],g=qf.Bk(n.g,f),b=qf.Bk(n.G,u),0==g)continue;if(3==g)continue;if(0==b||3==b)return!1;if(1==qf.vk(n.g,f)){++r;continue}if(1==qf.vk(n.G,u))return!1;if(2==qf.vk(n.g,f)){++r;continue}if(2==qf.vk(n.G,u))return!1;if(qf.ws(n,f)==(g==b))return!1}if(0!=r){for(a=$l(Qf.Mmb,G,6,r,15,1),s=0,l=0;l<n.g.f;l++)null!=n.f&&n.f[l]!=t||!Sd(wd(qf.Ck(n.g,l),Xn),0)||0!=(g=qf.Bk(n.g,l))&&3!=g&&(a[s++]=qf.uk(n.g,l)<<24|qf.vk(n.g,l)<<22|l);for(Gf.VUb(a,Gf.zVb(Vl(Vf.NQb.prototype.$d,Vf.NQb,[]))),s=0;s<a.length;)for(d=a[s]&kt,c=n.F[d],e=-4194304&a[s],i=qf.ws(n,d)^qf.Bk(n.g,d)==qf.Bk(n.G,c),++s;s<a.length&&(-4194304&a[s])==e;s++){if(o=a[s]&kt,u=n.F[o],qf.vk(n.G,u)!=qf.vk(n.G,c)||qf.uk(n.G,u)!=qf.uk(n.G,c))return!1;if((qf.ws(n,o)^qf.Bk(n.g,o)==qf.Bk(n.G,u))!=i)return!1}}return!0},qf.ms=function(n,t,e){var i,a,s,r,o,f,l;if(n.O=!1,n.D=new Vf.bj,n.a=new Vf.bj,Vf.PSb(n.N.a),!n.G||!n.g)return 0;if(n.g.f-n.o>n.G.f||n.g.g-n.p>n.G.g)return 0;if(0==n.g.f)return 0;for(6==t&&(n.M=63),qf.Bs(n,e),i=$l(Qf.nyb,tn,6,n.G.f,16,1),n.F=$l(Qf.Mmb,G,6,n.g.f,15,1),Vf.pQb(n.F),o=$l(Qf.Mmb,G,6,n.w,15,1),Vf.uQb(o,o.length,-1),s=0;!n.O;){if(0!=n.v){if(l=-1==n.t[s]?n.G.f:qf.wn(n.G,n.F[n.t[s]]),++o[s],o[s]==l){if(o[s]=-1,0==s)break;--s,n.s[s]||(i[n.F[n.r[s]]]=!1);continue}if(-1==n.t[s])i[o[s]]||qf.es(n,o[s],n.r[s])&&(n.F[n.r[s]]=o[s],i[o[s]]=!0,++s);else{if(qf.Jn(n.G,n.F[n.t[s]],o[s])>=n.G.f)continue;a=qf.Jn(n.G,n.F[n.t[s]],o[s]),n.s[s]?a==n.F[n.r[s]]&&qf.fs(n,qf.Ln(n.G,n.F[n.t[s]],o[s]),n.u[s])&&++s:i[a]||qf.es(n,a,n.r[s])&&qf.fs(n,qf.Ln(n.G,n.F[n.t[s]],o[s]),n.u[s])&&(i[a]=!0,n.F[n.r[s]]=a,++s)}}if(s==n.v){if(qf.ls(n,-1)&&qf.ks(n,-1)&&qf.js(n,i,-1)){for(f=!1,r=0;r<n.d;r++)if(qf.ss(n,i,o,r)){f=!0;break}if(1==t&&!f)return 1;if(!f&&(qf.ds(n,t),2==t))return 1}if(0==s)break;--s,n.s[s]||(i[n.F[n.r[s]]]=!1)}}return n.D.a.length},qf.ns=function(n,t){var e,i,a,s,r;if(s=0,n.K){switch(t<n.f&&qf.Ur(n.p,t)?s=Gd(s,ae):t<n.f&&qf.Or(n.p,t)&&(s=Gd(s,2)),0!=(r=0==(i=n.u[t]&xt)?0:i==hn?2:i==Gn?3:4)&&(s=Gd(s,8),r>2&&(s=Gd(s,16)),r>3&&(s=Gd(s,32))),(e=n.s[t])<0?s=Gd(s,mn):e>0&&(s=Gd(s,jn)),n.j[t]){case 0:break;case 1:s=Gd(s,gt);break;case 2:s=Gd(s,Nn);break;case 3:s=Gd(s,wn);break;default:s=Gd(s,Un)}switch(qf.zn(n,t)){case 0:break;case 1:s=Gd(s,xn);break;case 2:s=Gd(s,En);break;case 3:s=Gd(s,Fn);break;default:s=Gd(s,Qn)}(a=n.o[t])>0&&(s=Gd(s,ln)),a>1&&(s=Gd(s,Lt))}else{switch(s=t<n.f&&qf.Ur(n.p,t)?Gd(s,ae):t<n.f&&qf.Or(n.p,t)?Gd(s,2):Gd(s,4),s=n.u[t]&Jt?Gd(s,gn):Gd(s,un),s=Gd(s,0==(r=0==(i=n.u[t]&xt)?0:i==hn?2:i==Gn?3:4)?112:2==r?104:3==r?88:56),0==(e=n.s[t])?s=Gd(s,Hn):e<0?s=Gd(s,mn):e>0&&(s=Gd(s,jn)),n.e[t]-qf.co(n,t)+qf.Zn(n,t)){case 0:s=Gd(s,1792);break;case 1:s=Gd(s,1664);break;case 2:s=Gd(s,1408);break;default:s=Gd(s,896)}switch(n.j[t]){case 0:s=Gd(s,3932160);break;case 1:s=Gd(s,pn);break;case 2:s=Gd(s,Mn);break;case 3:s=Gd(s,In);break;default:s=Gd(s,Un)}switch(qf.zn(n,t)){case 0:s=Gd(s,Ln);break;case 1:s=Gd(s,yn);break;case 2:s=Gd(s,Bn);break;case 3:s=Gd(s,Rn);break;default:s=Gd(s,Qn)}switch(a=n.o[t]){case 0:s=Gd(s,98304);break;case 1:s=Gd(s,81920);break;default:s=Gd(s,49152)}}return s},qf.os=function(n,t){var e;if(e=0,t<n.g&&(qf.Tr(n.p,t)||64==n.H[t])||64==n.H[t])e|=8;else switch(qf.Uk(n,t)){case 4:case 0:e|=32;break;case 1:e|=1;break;case 2:e|=2;break;case 3:e|=4;break;case 5:e|=64}return 64&n.F[t]?e|=256:n.K||(e|=128),t<n.g&&qf.Pr(n.p,t)?e|=Tn:n.K||(e|=se),e},qf.ps=function(n){var t,e,i,a,s,r,o,f,l,d;for(f=0,s=0,o=(i=n).length;s<o;++s)-1==(t=i[s])&&++f;if(0!=f)for(d=n,n=$l(Qf.Mmb,G,6,d.length-f,15,1),l=0,a=0,r=(e=d).length;a<r;++a)-1!=(t=e[a])&&(n[l++]=t);return Gf.VUb(n,Gf.zVb(Vl(Vf.NQb.prototype.$d,Vf.NQb,[]))),n},qf.qs=function(n,t){var e,i,a,s,r,o,f;for(s=0,i=0,a=(e=t).length;i<a;++i)-1==e[i]&&++s;for(f=$l(Qf.Mmb,G,6,t.length-s,15,1),o=0,r=0;r<t.length;r++)-1!=t[r]&&(f[o]=qf.yu(n.g,r)<<16|qf.yu(n.G,t[r]),++o);return Gf.VUb(f,Gf.zVb(Vl(Vf.NQb.prototype.$d,Vf.NQb,[]))),f},qf.rs=function(n,t){var e,i,a,s,r,o,f,l,d,g,u,c;for(s=!1,a=0;a<2;a++)if(e=qf.Mk(n.g,a,t),d=n.F[e],qf.Kn(n.G,d)>2){for(u=qf.Mk(n.g,1-a,t),f=I,o=0;o<qf.Kn(n.g,e);o++)(i=qf.Jn(n.g,e,o))!=u&&f>i&&(f=i);for(c=n.F[u],l=I,r=0;r<qf.Kn(n.G,d);r++)(g=qf.Jn(n.G,d,r))!=c&&l>g&&(l=g);n.F[f]!=l&&(s=!s)}return s},qf.ss=function(n,t,e,i){var a,s,r,o,f,l,d,g;for(f=(o=n.e[i])+1;f<n.w&&n.f[n.r[f]]==i;)++f;for(d=o;d<f;d++)e[d]=-1;for(r=o;;)if(g=-1==n.t[r]?n.G.f:qf.wn(n.G,n.F[n.t[r]]),++e[r],e[r]!=g){if(-1==n.t[r])t[e[r]]||qf.es(n,e[r],n.r[r])&&(n.F[n.r[r]]=e[r],t[e[r]]=!0,++r);else{if(qf.Jn(n.G,n.F[n.t[r]],e[r])>=n.G.f){++e[r];continue}s=qf.Jn(n.G,n.F[n.t[r]],e[r]),n.s[r]?s==n.F[n.r[r]]&&qf.fs(n,qf.Ln(n.G,n.F[n.t[r]],e[r]),n.u[r])&&++r:t[s]||qf.es(n,s,n.r[r])&&qf.fs(n,qf.Ln(n.G,n.F[n.t[r]],e[r]),n.u[r])&&(t[s]=!0,n.F[n.r[r]]=s,++r)}if(r==f){if(qf.ls(n,i)&&qf.ks(n,i)&&qf.js(n,t,i)){for(l=o;l<f;l++)n.s[l]||(a=n.r[l],t[n.F[a]]=!1,n.F[a]=-1);return!0}--r,n.s[r]||(t[n.F[n.r[r]]]=!1,n.F[n.r[r]]=-1)}}else{if(e[r]=-1,r==o)break;--r,n.s[r]||(t[n.F[n.r[r]]]=!1,n.F[n.r[r]]=-1)}return!1},qf.ts=function(n){return qf.ms(n,1,n.c)>0},qf.us=function(n,t){var e;for(e=0;e<t.length;e++)if(t[e]==n)return!0;return!1},qf.vs=function(n,t){var e,i,a;for(a=0,i=0;i<n.length;i++){for(e=n[i];t[a]<e;)if(++a==t.length)return!1;if(t[a]>e)return!1}return!0},qf.ws=function(n,t){var e,i,a,s,r,o,f,l;if(r=!1,0==qf.An(n.g,t))for(s=1;s<qf.Kn(n.g,t);s++)for(o=0;o<s;o++)i=qf.Jn(n.g,t,s),a=qf.Jn(n.g,t,o),n.F[i]>n.F[a]^i>a&&(r=!r);else for(s=0;s<qf.Kn(n.g,t);s++){for(e=qf.Jn(n.g,t,s),l=0,f=$l(Qf.Mmb,G,6,3,15,1),o=0;o<qf.Kn(n.g,e);o++)f[l]=qf.Jn(n.g,e,o),f[l]!=t&&++l;2==l&&n.F[f[0]]>n.F[f[1]]^f[0]>f[1]&&(r=!r)}return r},qf.xs=function(n,t){var e,i,a,s;for(a=0,s=0;a<n.length&&s<t.length;){if((e=n[a])==(i=t[s]))return!0;e<i?++a:++s}return!1},qf.ys=function(n,t){var e,i,a,s,r;if(t&&0!=t.q&&t.K){for(n.g=t,n.q=!1,qf.nu(n.g,1),n.M=7,i=0;i<n.g.f;i++)Sd(wd(qf.Ck(n.g,i),{l:Xn,m:0,h:3}),0)&&(n.M=15);for(r=0;r<n.g.g;r++)qf.Wk(n.g,r)&bt&&(n.M=15);for(n.K&&7!=n.M&&qf.nu(n.G,n.M),n.o=0,n.p=0,n.C=$l(Qf.nyb,tn,6,n.g.f,16,1),a=0;a<n.g.f;a++)n.C[a]=Sd(wd(qf.Ck(n.g,a),en),0),n.C[a]&&++n.o;if(n.d=0,n.f=null,0!=n.o){if(0!=n.o)for(s=0;s<n.g.g;s++)(n.C[qf.Mk(n.g,0,s)]||n.C[qf.Mk(n.g,1,s)])&&++n.p;for(e=0;e<n.g.q;e++)qf.dm(n.g,e,n.C[e]);n.f=$l(Qf.Mmb,G,6,n.g.q,15,1),n.d=qf.Tn(n.g,n.f,!0,!1)}}else n.g=null},qf.zs=function(n,t,e){qf.As(n,e),qf.ys(n,t)},qf.As=function(n,t){t&&0!=t.q?(n.G=t,n.K=!1,qf.nu(n.G,1)):n.G=null},qf.Bs=function(n,t){n.K||(qf.Es(n,t),n.K=!0),n.q||(qf.Cs(n,t),qf.hs(n),qf.gs(n),n.q=!0)},qf.Cs=function(n,t){var e,i,a,s,r,o,f,l,d,g;for(s=null,f=null,r=null,qf.nu(n.g,n.M),n.n=$l(Qf.Mmb,G,6,n.g.f,15,1),i=0;i<n.g.f;i++)n.n[i]=qf.Kn(n.g,i);if(0!=n.o){for(l=new qf.Gu(n.g.q,n.g.r),g=$l(Qf.nyb,tn,6,n.g.q,16,1),a=0;a<n.g.q;a++)g[a]=!n.C[a];for(qf.mn(n.g,l,g,!0,null),qf.nu(l,n.M),qf.Ds(n,l,t),s=n.i,f=n.k,r=n.j,d=0,e=0;e<n.g.f;e++)n.C[e]||(n.n[e]=qf.Kn(l,d++))}if(qf.Ds(n,n.g,t),0!=n.o){for(d=0,e=0;e<n.g.q;e++)n.C[e]||(n.i[e]=s[d],n.j[e]=r[d++]);for(d=0,o=0;o<n.g.r;o++)!n.C[qf.Mk(n.g,0,o)]&&!n.C[qf.Mk(n.g,1,o)]&&(n.k[o]=f[d++])}},qf.Ds=function(n,t,e){var i,a,s,r,o,f,l,d,g,u,c,b,h,D,H,j;for(h=t.f,n.i=$l(Qf.Nmb,st,6,t.f,14,1),n.j=$l(Qf.Mmb,G,6,t.f,15,1),o=0;o<h;o++)n.i[o]=Wd(wd(Gd(qf.ns(t,o),t.B[o]),re),oe),n.j[o]=t.C[o],1&e&&(n.j[o]+=t.s[o]+16<<8),2&e&&(n.j[o]+=t.A[o]<<16);for(n.A=$l(Qf.Nmb,st,6,t.f,14,1),qf.nu(t,7),H=t.p,b=0;b<H.i.a.length;b++){for(c=!1,d=0,g=(l=Vf.Oi(H.j,b)).length;d<g;++d)if(u=l[d],t.G[u]&qn){c=!0;break}if(!c)for(j=Vf.Oi(H.j,b).length,s=0,r=(a=Vf.Oi(H.i,b)).length;s<r;++s)i=a[s],3==j?n.A[i]=Gd(n.A[i],O):4==j?n.A[i]=Gd(n.A[i],K):5==j?n.A[i]=Gd(n.A[i],W):6==j?n.A[i]=Gd(n.A[i],_):7==j&&(n.A[i]=Gd(n.A[i],$))}for(D=t.g,n.k=$l(Qf.Mmb,G,6,t.g,15,1),f=0;f<D;f++)n.k[f]=6291967&(qf.os(t,f)|t.G[f])^6291840,4&e?2&n.k[f]&&(n.k[f]|=8):8&e&&2&n.k[f]&&f<t.g&&qf.Pr(t.p,f)&&(n.k[f]|=8)},qf.Es=function(n,t){var e,i,a,s,r,o,f,l,d,g,u,c;for(qf.nu(n.G,n.M),d=n.G.f,n.I=$l(Qf.Mmb,G,6,d,15,1),n.H=$l(Qf.Nmb,st,6,d,14,1),r=0;r<d;r++)n.H[r]=Wd(wd(Gd(qf.ns(n.G,r),qf.Ck(n.G,r)),re),oe),n.I[r]=qf.Hk(n.G,r),1&t&&(n.I[r]+=qf.qk(n.G,r)+16<<8),2&t&&(n.I[r]+=qf.Ak(n.G,r)<<16);for(n.L=$l(Qf.Nmb,st,6,d,14,1),u=qf.mo(n.G),l=0;l<u.i.a.length;l++)for(c=Vf.Oi(u.j,l).length,a=0,s=(i=Vf.Oi(u.i,l)).length;a<s;++a)o=i[a],3==c?n.L[o]=Gd(n.L[o],O):4==c?n.L[o]=Gd(n.L[o],K):5==c?n.L[o]=Gd(n.L[o],W):6==c?n.L[o]=Gd(n.L[o],_):7==c&&(n.L[o]=Gd(n.L[o],$));for(e=0;e<d;e++)0==(c=qf.En(n.G,e))?n.L[e]=Gd(n.L[e],Z):c>7&&(n.L[e]=Gd(n.L[e],nn));for(g=n.G.g,n.J=$l(Qf.Mmb,G,6,g,15,1),f=0;f<g;f++)n.J[f]=6422527&(qf.os(n.G,f)|qf.Wk(n.G,f))^6291840},qf.Fs=function(n,t,e,i,a,s,r){var o,f;return o=qf.Jn(n.g,n.r[t],i),n.C[o]&&n.f[o]!=r||o==n.t[t]||s[f=qf.Ln(n.g,n.r[t],i)]||qf.pl(n.g,f)||(n.r[++e]=o,n.t[e]=n.r[t],n.u[e]=f,s[f]=!0,a[o]?n.s[e]=!0:a[o]=!0),e},qf.Gs=function(){this.c=8,this.N=new Vf.UTb(new Hl.u7)},qf.Hs=function(){this.c=1,this.N=new Vf.UTb(new Hl.u7)},qf.Is=function(t,e){var i;return i=$l(Qf.Mmb,G,6,e,15,1),zf.bKb(t,0,i,0,n.Math.min(t.length,e)),i},qf.Js=function(t,e){var i;return i=$l(Qf.nyb,tn,6,e,16,1),zf.bKb(t,0,i,0,n.Math.min(t.length,e)),i},Ol(91,1,{},qf.Gs,qf.Hs),o.c=0,o.d=0,o.o=0,o.p=0,o.q=!1,o.v=0,o.w=0,o.K=!1,o.M=0,o.O=!1,Qf.wnb=hd(91),qf.Ks=function(){},Ol(252,1,{252:1},qf.Ks),o.a=0,o.b=0,o.c=0,o.d=0,Qf.unb=hd(252),qf.Ns=function(){qf.Ns=vl,qf.Ls=ed(Wl(Qf.zwb,1),L,2,6,["QM@HzAmdqjF@","RF@Q``","qC`@ISTAlQE`","`J@H","QM@HzAmdqbF@","qC`@ISTAlQEhqPp@","sJP@DiZhAmQEb","RF@QPvR@","QM@HzA@","qC`@ISTAlQEhpPp@","qC`@Qz`MbHl","sJP@DiZhAmQEcFZF@","RFPDXH","qC`@IVtAlQE`","QM@HvAmdqfF@","sGP@DiVj`FsDVM@","`L@H","sJP@DizhAmQEcFBF@","sJP@DjvhAmQEb","sFp@DiTt@@AlqEcP","sGP@LdbMU@MfHlZ","QMHAIhD","QM@HzAy@","sJP@DkVhAmQEb","sNp@DiUjj@[\\QXu`","sJP@DiZhAmQEcFBF@","sGP@DjVj`FsDVM@","RFPDTH","RG@DXOH@","sGP@Divj`FsDVMcAC@","sGP@Dj}j`FsDVM@","qC`@Qz`MbHmFRF@","sNp@LdbJjj@[\\QXu`","QMHAIhGe@","QM@HzAyd`","QM`AIhD","qC`@ISTA@","sGP@DkUj`FsDVM@","qC`@IVtAlQEhqPp@","sNp@DiUjj@[\\QXuqea`@","KAx@@IRjuUPAlHPfES\\","QM`BN`P","sJP@DjZhAmQEcFJF@","Hid@@DjU^nBBH@FtaBXUMp`","sNp@Diujj@[\\QXuq`a`@","sJP@DjvhAmQEcFZF@","sJP@DjZhAmQEcFFF@","sOp@DjWkB@@FwDVM\\YhX@","sNp@Dj}Zj@[\\QXu`","sNp@DiWjj@[\\QXuq`a`@","sOp@DjWkB@@D","KAx@@ITouUPAlHPfES\\","KAx@@YIDTjjh@vDHSBin@","sNp@DkUZj@[\\QXu`","RFPDXOH@","QM`BN`^L`","qC`@ISTAy@","sGP@LdbMU@MfHl[FVF@","qCb@AIZ`H","KAx@@IRjuUPAlHPfES]FFa`@","KAx@@ITnuUPAlHPfES\\","HiD@@DiUVjj`AmHPfES\\H","sNp@DjUjj@[\\QXu`","sJP@DkVhAmQEcFJF@","sGP@DjVj`FsDVMcCC@","qC`@Qz`MbHmFBF@","sJP@DkfhAmQEb","qC`@IVtAlQEhsPp@","sGP@Djuj`FsDVM@","sGP@Dj}j`FsDVMcMC@","sJP@DiZhA@","KAx@@ISjuUPAlHPfES]F@a`@","sJP@DjZhAmQEcFRF@","KAx@@IRnuUPAlHPfES]F@a`@","HiD@@DjWvjj`AmHPfES\\H","QMHAIhGd@","sNp@DiUjj@[\\QXuq`a`@","KAx@@IVjmUPAlHPfES\\","sGP@DjVj`FsDVMcMC@","QM`AIhGe@","HiD@@LdbJRjjh@[RDIaTwB","qCp@AIZ`H","sGP@LdbMU@MfHl[FFF@","QMDARVA@","sNp@LdbJjj@[\\QXuqba`@","sNp@LdbJjj@[\\QXuqca`@","sGP@Dkej`FsDVM@","qCb@AIZ`OI@","HaD@@DjUZxHH@AlHPfES]FLa`@","sGP@DkYj`FsDVM@","qCb@AIV`H","sNp@LdbJjj@[\\QXuqea`@","sGP@DkUj`FsDVMcEC@","sFp@DiTt@@Axa@","Hmt@@DjU_ZxHHj@AmhPfES\\Lj","QM`BN`^P","qCb@AIZ`OH`","sFp@DiTt@@AxaP","sGP@Djuj`FsDVMcEC@","sGP@Djuj`FsDVMcIC@","sGP@DkUj`FsDVMcKC@","sJP@DkfhAmQEcFRF@","sGP@DjVj`FsDVMcIC@","HaD@@DjUZxHH@AlHPfES]FFa`@","qC`@IRtDVqDV@","sNp@Dj}Zj@[\\QXuqfa`@","KAx@@ITnuUPAlHPfES]FFa`@","HiD@@DkUUjj`AmHPfES\\H","sJQ@@dkU@H","qC`@Qz`H","KAx@@IUkmUPAlHPfES\\","KAx@@ITouUPAlHPfES]FJa`@","sJP@H~j@[TQX`","sGP@DjZj`FsDVM@","sJP@DkVhAmQEcFFF@","sJX@@eKU@H","sJP@DizhAy@","QMHAIhGbP","KAx@@ITouUPAlHPfES]FNa`@","HaD@@DjUZxHD@AlHPfES\\","HaD@@DjUZxHH@A@","sNp@LdbJjj@[\\QXuqaa`@","Hed@@LdbRQUUUP@vTHSBinFP","KAx@@ITouUPAlHPfES]FLa`@","sNp@DkUZj@[\\QXuqba`@","KAx@@ITjuUPAlHPfES]FNa`@","KAx@@YIDTjjh@vDHSBincGPp@","HaD@@DjYvxH`@AlHPfES]FLa`@","RF@QP`","qCb@AIj`H","sNp@DjUjj@[\\QXuqaa`@","sNp@DkVZj@[\\QXu`","KAx@@YIDUJjh@vDHSBin@","sGP@DkYj`FsDVMcIC@","sGP@DjVj`FsDVMcAC@","sGP@DiVj`D","sJP@DkVhAmQEcFZF@","sNp@LdbLjj@[\\QXu`","QM@HvAmdqbF@","HaD@@DjWjXHB@AlHPfES\\","sNp@DjwZj@[\\QXuqba`@","sNp@LdbJjj@[\\QXuqda`@","sFp@DiTt@@Axa`","HiD@@Djuujj`AmHPfES\\H","sNp@DkUZj@[\\QXuqca`@","sJP@DiZhAy@","KAx@@YIDTjjh@vDHSBincCPp@","KAx@@IWNmUPAlHPfES\\","KAx@@IVkMUPAlHPfES\\","sJQ@@dju@H","qCb@AIZ`OH@","qC`@ISTAxa@","sNp@DjyZj@[\\QXu`","Hid@@DjUfaBB`@FtaBXUMp`","HiD@@DiUVjj`AmHPfES\\LXBF@","KAx@@IUjmUPAlHPfES\\","HiD@@DjWvjj`AmHPfES\\LXjF@","sJP@DjVhAmQEb","qCb@AIV`OH`","HiD@@LdbJRjjh@[RDIaTwCFDa`@","KAx@@YIDTjjh@vDHSBinc@Pp@","sNp@DjUjj@[\\QXuqda`@","qC`@Qz`OED","sJP@DkfhAmQEcFZF@","KAx@@YIDbjjh@vDHSBincDPp@","sGP@Djyj`FsDVMcMC@","KAx@@IVrmUPAlHPfES\\","qCp@AIZ`OI@","sJX@@dkU@H","sJQ@@dkU@OH`","sNp@Di]ZjBBvxbqk@","Hkl@@DjU_Uk``bj`@[VDIaTwCJzX","sGP@DjZj`FsDVMcEC@","Hid@@DjU^nBBH@FtaBXUMpqcHX@","sNp@DkeZj@[\\QXu`","sNp@DjYjj@[\\QXuqca`@","sGQ@@djuT@`","HiD@@LdbJTjjh@[RDIaTwB","sOp@DjWkB@@Gd`","HeT@@LdbbRKBDQD@CYPaLJfxY@","qCr@XIKTA@","HiD@@DjW^jj`AmHPfES\\LXJF@","HeT@@DjU]k``b`@[JDIaTwCH","sGP@Djuj`FsDVMcCC@","`IH`B","sOp@DjWkB@@GdX","sJQ@@eKU@H","KAx@@YIDUJjh@vDHSBincBPp@","sJX@@eKU@OH@","KAx@@YIDTjjh@vDHSBincAPp@","sOq@@drm\\@@@`","KAx@@IUkMUPAlHPfES\\","qCp@AIj`H","Hed@@DjUUjjj@FraBXUMpr","sGX@@eJuT@`","sGP@DkUj`FsDVMcCC@","HiD@@Dj}Ujj`AmHPfES\\LXrF@","KAx@@ITouUPAlHPfES]FHa`@","Hed@@DjWujjj@FraBXUMpsFIa`@","sGP@DiUj``mfHlZ","sFp@DiTvjhAlqEcP","Hid@@DjU^nBBH@FtaBXUMpq`XX@","sJP@DkVdAmQEb","qCp@AIZ`OH`","QMhDRVA@","qC`@ISJAlQE`","qCp@BOTAyhl","sJX@@eOU@ODB","sFp@DiTt@@AyaB","sGP@DkUj`FsDVMcMC@","Hid@@DjYUaBH`@FtaBXUMpqcHX@","qC`@Qz`OH@","HiD@@DjUVjj`AmHPfES\\LXZF@","sJP@H~j@[TQXqda`@","sJX@@eKU@OI@","sNp@Djejj@[\\QXu`","sJQ@@dsU@H","sJQ@@dkU@OI`","KAx@@YIMDVjh@vDHSBin@","Hid@@DjU^nBBD@FtaBXUMp`","sNp@DkgZj@[\\QXuqca`@","qC`@IRtDVqDVcEC@","Hed@@LdbRQeUUP@vTHSBinFP","sNp@DiUjj@P","qC`@IRtDT","sNp@DkYZj@[\\QXuqca`@","KAx@@IUkmUPAlHPfES]FDa`@","KAx@@IVjmUPAlHPfES]FNa`@","sOx@@drm\\@@@`","KAx@@ITjuUPAlHPfES]FBa`@","QMDARVAyH","sJP`@dfvhA@","HeT@@DjU_k``b`@[JDIaTwCLXfF@","KAx@@IToUUPAlHPfES]FJa`@","sGP@DkYj`FsDVMcEC@","qCb@AIZ`ODH","`I@`B","KAx@@IUzmUPAlHPfES]FFa`@","sNp@DkfZj@[\\QXu`","KAx@@ITnuUPAlHPfES]F@a`@","HiD@@LddURjjh@[RDIaTwB","sNp@Dj~Zj@[\\QXuqfa`@","Hed@@Dj{uZjj@FraBXUMpr","KAx@@ITsUUPAlHPfES\\","Hid@@LdbRQk``b@AmHPfES\\LXrF@","sOp@DjWkB@@GdH","sJQ@@dkU@OH@","Hid@@DjU^nBBH@FtaBXUMpqahX@","sGP@DiYj``mfHlZ","KAx@@IToUUPAlHPfES]FLa`@","qCp@AJZ`ODH","Hmt@@DjU]ZxHHj@AmhPfES\\Lj","sGP@DkUjPFsDVM@","qC`@IVtA@","Hed@@LdbJReUUP@vTHSBinFP","sNp@DjuZj@[\\QXuqea`@","KAx@@IUkmUPAlHPfES]FNa`@","HiD@@DkVUjj`AmHPfES\\H","Hed@@DkUeZjj@FraBXUMpr","sNp@DkVZj@[\\QXuqea`@","sJP@DiVhHKZbKFLLL@","HiD@@Djuyjj`AmHPfES\\H","sNp@DjUjj@[\\QXuq`a`@","HeT@@DjYUXPbH`@[JDIaTwCH","HiD@@DjwUjj`AmHPfES\\LXRF@","sNq@@djmUPB","KAx@@YIEEZjh@vDHSBincCPp@","sGP@Di^V`dmfHlZ","Hid@@DjYUaBHP@FtaBXUMp`","sNp@DjYjj@[\\QXuqba`@","sGP@Dkej`FsDVMcKC@","HeT@@DjU^k``b`@[JDIaTwCH","qC`@Qv`MbHmFBF@","sGQ@@djmT@`","qCr@XIKTAyH","qC`@IVtAlQEhpPp@","Hid@@LdbbQxXF@@AmHPfES\\LXjF@","sGP@DkYj`FsDVMcCC@","KAx@@IVsMUPAlHPfES\\","qCp@AIj`ODl","HiD@@DkeUjj`AmHPfES\\H","deT@@DjU[k``b`@vTHSBinFP","sJP@DkVdAmQEcFRF@","HiD@@LdbJTjjh@[RDIaTwCFDa`@","HiD@@DkYyjj`AmHPfES\\H","sJP@DjZhAyH","KAx@@IVkMUPAlHPfES]FDa`@","sJX@@dkU@OI@","Hed@@LdbRQUUUP@vTHSBinFXpLL@","Hed@@DjuUZjj@FraBXUMpr","sGP@Djfj`FsDVMcKC@","sNp@DkVZj@[\\QXuqba`@","sNp@DjyZj@[\\QXuqfa`@","qCb@AIj`OH@","sNp@DjUZj@[\\QXu`","KAx@@IWOMUPAlHPfES\\","Hid@@DjU^nBBH@D","Hed@@DjuvZjj@FraBXUMpr","sJP@DiVhHKZbKFLtL@","dmt@@DjU_ZxHHj@C[PaLJfxYVLKC@","sNp@DjuZj@[\\QXuqca`@","sJP@DkfhAmQEcFJF@","sNp@LdbJZj@[\\QXu`","HeT@@DjU_k``b`@[JDIaTwCLXFF@","KAx@@IVlmUPAlHPfES]FNa`@","HeT@@LdbbRKBDQD@CYPaLJfxYcEPp@","Hid@@DjUZnBBH@FtaBXUMpqcHX@","qCa@CIKTA@","HiD@@Dj~]jj`AmHPfES\\LXFF@","sKP@Di\\Zj@[TQX`","sGP@Djfj`FsDVMcEC@","HiD@@DkgYjj`AmHPfES\\H","sNp@DjuZj@[\\QXuqaa`@","KAx@@YIMDVjh@vDHSBincDPp@","sJP@DjVhHKZbKFLTL@","Hid@@LdbRQk``b@AmHPfES\\LXZF@","HiD@@Dj}Ujj`AmHPfES\\LXzF@","HeT@@DjU_k``bP@[JDIaTwCH","sNp@DkUZi@[\\QXu`","HiD@@DjYfjj`AmHPfES\\H","sGP@DjZj`FsDVMcAC@","Hmt@@DjU_jxHHj@AmhPfES\\Lj","Hid@@LdbRQk``R@AmHPfES\\H","KAx@@YIDUJjh@vDHSBincDPp@","qCr@XIKTAyD","sOq@@drm\\@@@|`@","Hed@@DjW^jjj@FraBXUMpsFBa`@","HeT@@DjY]zXFB@@[JDIaTwCH","Hkl@@DjU_Vk``bj`@[VDIaTwCJzX","Hid@@DjY}nBHH@FtaBXUMpqcHX@","sGX@@eKuT@|d@","sGP@Dj^Y`FsDVM@","HcL@@DjU_ZnBBJh@FqaBXUMprn`","sJP@DkVdAmQEcFJF@","sOq@@drm\\@@@|b@","sNp@DjyZj@[\\QXuqaa`@","HaD@@DjUZxHH@AyD@","qC`@Qv`H","dmt@@DjU_ZxHHj@C[PaLJfxYVLYC@","sGP@Dkej`FsDVMcMC@","Hed@@DjUUjjj@FraBXUMpsFHa`@","HeT@@LdbbRkBDQD@CYPaLJfxY@","KAx@@IU{MUPAlHPfES]FLa`@","RG@DTH","sJY@DDeVhA@","KAx@@YIDUJjh@vDHSBinc@Pp@","sJX@@dkU@OI`","sJQ@@dju@OI`","HeT@@LdbbRKBDQD@CYPaLJfxYcFPp@","sFp@DiTvjhAlqEcXpPp@","HaD@@DjUZxHH@AyG@","sNx@@eJ}UPB","sNp@LddUjj@[\\QXuqca`@","HaDH@@RVU[j@@@D","sNp@DkgZi@[\\QXu`","sGY@LDeVj`D","sNp@LdbJfZBZvxbqk@","sJP`@dfvhAyL","sGX@AddQjhAxe`","Hmt@@DjU_ZxHHj@AmhPfES\\LkFIa`@","qCh@CIKTA@","sNp@LdbLjj@[\\QXuq`a`@","sOq@@drm\\@@@|a@","KAx@@IUzmUPAlHPfES]FJa`@","sNx@AddQUUPB","sGP@Di]jP`mfHlZ","sJP`@TeZhA@","KAx@@IRjmUPHKXPaLJfx","HeT@@LdbRTM\\DDT@CYPaLJfxY@","HaF@@@Rfu[j@@@D","Hid@@DjYUaBH`@FtaBXUMpqchX@","KAx@@IUjmTpAlHPfES\\","Hid@@DjU^nBBD@FtaBXUMpqcHX@","sGP@DiUj``mfHl[FFF@","KAx@@IUvmUPAlHPfES]FLa`@","Hed@@LdbQTUUUP@vTHSBinFXqDL@","sJP@DkVhA@","sOx@@drm\\@@@|b@","KAx@@IUkMUPAlHPfES]FDa`@","HeT@@LdbRQU\\DDT@CYPaLJfxY@","HiD@@Dj}Yjj`AmHPfES\\LXrF@","HiD@@Dj{ujj`AmHPfES\\LXFF@","KAx@@IWNmUPAlHPfES]FFa`@","KAx@@IRkMUPHKXPaLJfx","sJP@DjYdAmQEcFZF@","sJY@LDeZhAyL","HaDH@@RVU[f@@@D","sJP`@deVhAyB","HaD@@DjWjZjj`AlHPfES\\","sGP@DkYj`FsDVMcMC@","sNp@DkgZj@[\\QXuqea`@","sJQ@@dlu@H","HeT@@DjU]k``b`@[JDIaTwCLXrF@","sJX@@dkU@OH`","RFDDQFCr`","sJP@DiYXIKZbKFLLL@","KAx@@YIHjjjh@vDHSBincGPp@","Hk\\@@DjU^ukmLHH@@@AmXPfES\\Lki`","sGQ@@djmT@|b@","Hid@@DjUfaBB`@FtaBXUMpqahX@","sNx@@eRmUPB","Hmt@@LdbRVak``ah@FvaBXUMprh","qCr@XIJtA@","KAx@@IWMmUPAlHPfES]FNa`@","HeT@@DjYYZPbJ@@[JDIaTwCH","sNp@DkfZj@[\\QXuqea`@","Hid@@DjU^nBAHAEVtaBXUMp`","dmt@@DjUgZDHJJ@C[PaLJfxYT","sGP@DkejPFsDVM@","sNx@@eJmUPB","qCb@AIf`H","HcL@@DjU_VnBBJh@FqaBXUMprnqcXX@","Hid@@DjUZnBBH@FtaBXUMpqahX@","sNp@LdbQZjBBvxbqkcGC@","sOx@@drm\\@@@|c@","sJP@H~j@^R@","KAx@@YIDcFjhDElHPfES\\","Hid@@DjUZnBAH@FtaBXUMp`","sNp@LddUji@[\\QXu`","sGP@DjfjPFsDVM@","HeT@@DjYUXPbD`@[JDIaTwCH","KAx@@IUoMUPAlHPfES]FDa`@","sFp@DiTt@@AyaD","Hed@@DjuuZjj@FraBXUMpsFIa`@","HeT@@DjUghP`h`@[JDIaTwCLXfF@","sOp@DjWkjj`FwDVM\\YhX@","sGP@Djfj`FsDVMcIC@","KAx@@IRkmUPHKXPaLJfzL]C@","sNx@@djmUPB","QM`AIdD","sOp@DjWkB@@Gbe@","sNp@DjyZj@[\\QXuqca`@","QM@HuAmd`","sNp@LddUjj@[\\QXuqea`@","daD@@DjUZxHD@CXPaLJfzLYC@","qCb@AIZPH","HiD@@LdbJTjjh@[RDIaTwCF@a`@","Hmt@@DjU_ZxHHi@AmhPfES\\Lj","HaDH@@RYWih@H@D","HiD@@LdbJTjjh@[RDIaTwCFHa`@","sGX@@djuT@|a@","sNp@DkfZj@[\\QXuqaa`@","Hid@@DjU^nBBH@GdL","KAx@@IVkMUPAlHPfES]FJa`@","qCr@XIKTAy@","HmT@@Dj{uVjjh@[ZDIaTwCJqaXX@","dmt@@DjYWVDHbJ@C[PaLJfxYT","Hif@@@RUe^Fh@@@P","HaDH@@Rfu[j@@@GdH","KAx@@IVsMUPAlHPfES]FDa`@","sKP@Di\\Zj@[TQXq`a`@","sJX@@eMU@OH@","HeT@@DjU^k``b`@[JDIaTwCLXFF@","Hmt@@LdbbRJXPbHh@FvaBXUMprh","sJP@DjvhAmQEcFBF@","dmt@@LdbbRNXPbHh@MmBDpj[aeXplL@","sJP`@dfvhAyD","sGP@Di^V`dmfHl[FVF@","KAx@@IVsmUPAlHPfES]FBa`@","sOq@@drm\\@@@|PP","sJY@BDeZhA@","HeT@@LdbRbmBDED@CYPaLJfxY@","Hed@@Djy[Zjj@FraBXUMpr","HeT@@DjU]k``b`@[JDIaTwCLXFF@","Hid@@DjUfaBB`@D","qCa@CIJtA@","QMPARVA@","Hid@@DjUfaBB`@FtaBXUMpqcHX@","sJY@BDfZhA@","HeT@@DjUghP`hP@[JDIaTwCH","Hed@@Dj{uZjj@FraBXUMpsFIa`@","dmt@@DjYUvDHbJ@C[PaLJfxYVLUC@","sNp`@dfuZj@P","sJQ@@dmU@OH@","sJX@@dmU@H","HeT@@DjU]k``b`@[JDIaTwCLXZF@","HiD@@LdfbJZjh@[RDIaTwCFAa`@","sOx@@drm\\@@@|a@","deT@@DjUfhP`h`@vTHSBinFP","dmt@@DjU]ZxHHj@C[PaLJfxYVLKC@","sOp@DjWkjj`FwDVM\\XHX@","HcL@@LdbbRNSBDQEP@McBDpj[ae]cFpp@","HiD@@Dj}Yji`AmHPfES\\H","HaDH@@RYe[hB@@D","Hid@@DjU^njjj@FtaBXUMpq`XX@","deT@@LdbbRKBDQB@FraBXUMpr","QMPARZA@","sOq@@drm\\@@@|QX","HaD@@DjYvxH`@A@","HcL@@LdbbRNcBDQEP@McBDpj[ae]@","QMhDRZA@","RG@DXLHmP","QM`BN`XQYd","RG@DTLHmP","QMHAIXFEVd","QMDARVAaH","RFPDXLHmP","RF@Q`vRbdLEC@","RF@QpvR@","QO@HyjAmd`","`II@B","`II@CFspqJp","`II@CF[@hM@prB`","`H@[T[|B`XN@PdM@p|@bHrBcDk@","RG@DXMj}F@","QM`BN`[L~b@","RG@DTMj}D@","QMHAIXFt~j@","QMDARVA}L@","RFPDXMj}D@","sKP@Di\\YZ@[TQXqaa`@","eF`BHD"])},qf.Os=function(n,t){var e,i;if(!t)return null;for(i=$l(Qf.Mmb,G,6,(qf.Ls.length+31)/32|0,15,1),t=qf.Ts(t),qf.As(n.e,t),e=0;e<qf.Ls.length;e++)qf.ys(n.e,qf.Ms[e]),qf.ms(n.e,1,4)>0&&(i[e/32|0]|=1<<31-e%32);return i},qf.Ps=function(n,t){var e,i;if(!t)return null;for(i=$l(Qf.Nmb,st,6,(qf.Ls.length+63)/64|0,14,1),t=qf.Ts(t),qf.As(n.e,t),e=0;e<qf.Ls.length;e++)qf.ys(n.e,qf.Ms[e]),qf.ms(n.e,1,4)>0&&(i[e/64|0]=Gd(i[e/64|0],Yd(1,63-e%64)));return i},qf.Qs=function(){var n,t;if(null==qf.Ms)for(t=new qf.Ip(!1),qf.Ms=$l(Qf.Gnb,fe,26,qf.Ls.length,0,1),n=0;n<qf.Ls.length;n++)qf.Ms[n]=qf.vp(t,qf.Ls[n]),qf.nu(qf.Ms[n],1)},qf.Rs=function(n){var t;if(null==n.d)return!1;for(t=0;t<n.d.length;t++)if(n.b[t]&~n.d[t])return!1;return qf.Ss(n)},qf.Ss=function(n){return!n.c&&(n.c=(new qf.Ip(!1),null)),!n.a&&(n.a=(new qf.Ip(!1),null)),qf.As(n.e,n.c),qf.ys(n.e,n.a),qf.ts(n.e)},qf.Ts=function(n){var t,e;if(n.K)for(t=0;t<n.q;t++)if(Sd(wd(n.B[t],en),0)){for(n=new qf.Hu(n),e=t;e<n.q;e++)Sd(wd(n.B[e],en),0)&&(n.C[e]=-1);qf.kk(n)}return n},qf.Us=function(n,t,e){n.a=t,n.b=null==e?qf.Os(n,t):e},qf.Vs=function(n,t,e){n.c=t,n.d=null==e?qf.Os(n,t):e},qf.Ws=function(){qf.Ns(),this.e=new qf.Gs,qf.Qs()},qf.Xs=function(n){var t,e,i,a,s,r;if(qf.Ns(),null==n)return null;for(t=$l(Qf.Imb,dt,6,8*n.length,15,1),i=0;i<n.length;i++)for(r=n[i],a=7;a>=0;a--)(e=15&r)>9&&(e+=7),t[8*i+a]=48+e<<24>>24,r>>=4;return zf.nJb((s=t,Fl.CMb(),s))},qf.Ys=function(n){var t,e,i,a;if(qf.Ns(),0==Gf.zVb(n).length||7&Gf.zVb(n).length)return null;for(i=$l(Qf.Mmb,G,6,Gf.zVb(n).length/8|0,15,1),e=0;e<Gf.zVb(n).length;e++)a=e/8|0,Gf.uVb(e,Gf.zVb(n).length),(t=Gf.zVb(n).charCodeAt(e)-48)>16&&(t-=7),i[a]<<=4,i[a]+=t;return i},qf.Zs=function(t,e){var i,a,s,r;for(qf.Ns(),r=0,a=0,s=0,i=0;i<t.length;i++)r+=fg(t[i]&e[i]),a+=fg(t[i]),s+=fg(e[i]);return r/n.Math.sqrt(a*s)},qf.$s=function(n,t){var e,i,a;for(qf.Ns(),a=0,e=0,i=0;i<n.length;i++)a+=fg(n[i]&t[i]),e+=fg(n[i]|t[i]);return a/e},Ol(198,1,{},qf.Ws),Qf.vnb=hd(198),qf.at=function(n){n.j=1,n.k=10,n.n=400,n.f=400,n.i=!0,n.d="black",n.b=new Vf.bj,n.a=new Vf.bj,n.c=new zf.XJb,n.e=new Rl.dGb(12)},qf.bt=function(n,t){var e;return(e=Rl.bGb(n.e,t),new kl.xGb(e)).b},qf.ct=function(n){return n.k},qf.dt=function(n){var t,e,i,a,s;if(s='<svg id="'+(null!=n.g?n.g:"mol"+qf._s)+'" xmlns="http://www.w3.org/2000/svg" version="1.1" width="'+n.n+'px" height="'+n.f+'px" viewBox="0 0 '+n.n+" "+n.f+'">\n',s+="  ",s+=n.i?"<style> #"+(null!=n.g?n.g:"mol"+qf._s)+" { pointer-events:none; } #"+(null!=n.g?n.g:"mol"+qf._s)+" .event  { pointer-events:all; } line { stroke-linecap:round; } polygon { stroke-linejoin:round; } </style>\n":'<g style="font-size:'+n.k+'px; fill-opacity:1; stroke-opacity:1; fill:black; stroke:black; font-weight:normal; text-rendering:optimizeLegibility; font-family:sans-serif; stroke-linejoin:round; stroke-linecap:round; stroke-dashoffset:0;">',n.i){for(a=new Vf.eQb(n.b);a.a<a.c.a.length;)i=Vf.dQb(a),qf.et(n,i);for(e=new Vf.eQb(n.a);e.a<e.c.a.length;)t=Vf.dQb(e),qf.et(n,t)}return n.i||qf.et(n,"</g>"),s+n.c.a+"</svg>"},qf.et=function(n,t){zf.UJb(n.c,"  "),zf.UJb(n.c,t),zf.UJb(n.c,H)},qf.ft=function(n,t,e){qf.Qc(),qf.Sd.call(this,n,t),qf.at(this),this.g=e,++qf._s},qf.gt=function(n){qf.Qc(),qf.ft.call(this,n,0,null)},Ol(196,145,{145:1},qf.ft,qf.gt),o.mb=function(n){var t;t='<line x1="'+zf.ZHb(El.uKb(El.rKb(new El.vKb(n.a),(El.tMb(),El.pMb))))+'" y1="'+zf.ZHb(El.uKb(El.rKb(new El.vKb(n.c),El.pMb)))+'" x2="'+zf.ZHb(El.uKb(El.rKb(new El.vKb(n.b),El.pMb)))+'" y2="'+zf.ZHb(El.uKb(El.rKb(new El.vKb(n.d),El.pMb)))+le+de+this.d+le+ge+this.j+ue,qf.et(this,t)},o.nb=function(n){var t,e;e='<line stroke-dasharray="'+(t=zf.ZHb(El.uKb(El.rKb(new El.vKb(3*this.j),(El.tMb(),El.pMb)))))+","+t+'" x1="'+zf.ZHb(El.uKb(El.rKb(new El.vKb(n.a),El.pMb)))+'" y1="'+zf.ZHb(El.uKb(El.rKb(new El.vKb(n.c),El.pMb)))+'" x2="'+zf.ZHb(El.uKb(El.rKb(new El.vKb(n.b),El.pMb)))+'" y2="'+zf.ZHb(El.uKb(El.rKb(new El.vKb(n.d),El.pMb)))+le+de+this.d+'" stroke-width:'+this.j+ue,qf.et(this,e)},o.ob=function(t){var e,i;for(i=new zf.ZJb('<polygon points="'),e=0;e<t.a;e++)zf.SJb(i,yd(n.Math.round(t.b[e]))),i.a+=",",zf.SJb(i,yd(n.Math.round(t.c[e]))),i.a+=" ";zf.UJb(i,'" fill="'+this.d+le+de+this.d+le+ge+this.j+ue),qf.et(this,i.a)},o.pb=function(n,t,e){var i,a,s;a=(s=Rl.bGb(this.e,n),new kl.xGb(s)).b,i='<text x="'+zf.ZHb(El.uKb(El.rKb(new El.vKb(t-a/2),(El.tMb(),El.pMb))))+'" y="'+zf.ZHb(El.uKb(El.rKb(new El.vKb(e+this.k/3),El.pMb)))+'" stroke="none" font-size="'+this.e.b+'" fill="'+this.d+'">'+n+"</text>",qf.et(this,i)},o.qb=function(n,t,e){var i;i='<circle cx="'+zf.ZHb(El.uKb(El.rKb(new El.vKb(n+e/2),(El.tMb(),El.pMb))))+'" cy="'+zf.ZHb(El.uKb(El.rKb(new El.vKb(t+e/2),El.pMb)))+'" r="'+zf.ZHb(El.uKb(El.rKb(new El.vKb(e/2),El.pMb)))+'" fill="'+this.d+ue,qf.et(this,i)},o.rb=function(n){return qf.bt(this,n)},o.sb=function(){return qf.ct(this)},o.tb=function(n,t,e,i){var a,s;a=qf.zk(this.L,n),s='<circle id="'+(null!=this.g?this.g:"mol"+qf._s)+":Atom:"+n+le+ce+(0==a?"":'data-atom-map-no="'+a+le)+'cx="'+zf.ZHb(El.uKb(El.rKb(new El.vKb(e),(El.tMb(),El.pMb))))+'" cy="'+zf.ZHb(El.uKb(El.rKb(new El.vKb(i),El.pMb)))+'" r="8'+le+be,Vf.Ji(this.a,s)},o.ub=function(n,t,e,i,a){var s;s='<line id="'+(null!=this.g?this.g:"mol"+qf._s)+":Bond:"+n+le+ce+'x1="'+zf.ZHb(El.uKb(El.rKb(new El.vKb(t),(El.tMb(),El.pMb))))+'" y1="'+zf.ZHb(El.uKb(El.rKb(new El.vKb(e),El.pMb)))+'" x2="'+zf.ZHb(El.uKb(El.rKb(new El.vKb(i),El.pMb)))+'" y2="'+zf.ZHb(El.uKb(El.rKb(new El.vKb(a),El.pMb)))+le+ge+8+le+be,Vf.Ji(this.b,s)},o.wb=function(t){this.j=Zd(yd(n.Math.round(100*n.Math.max(t,1))))/100},o.xb=function(n){this.d="rgb("+((n&he)>>16)+","+((n&q)>>8)+","+(255&n)+")"},o.yb=function(n){this.k!=n&&(this.k=n,this.e=new Rl.dGb(n))},o.zb=function(t,e){return this.n=Od(yd(n.Math.round(t.b))),this.f=Od(yd(n.Math.round(t.a))),qf.Od(this,t,e)},o.lb=function(){return qf.dt(this)},o.f=0,o.i=!1,o.j=0,o.k=0,o.n=0,qf._s=0,Qf.xnb=hd(196),qf.vt=function(n,t){var e;if(null!=n.c)for(e=0;e<n.c.length;e++)if(t==n.c[e]&&n.d[e])return!0;return!1},qf.wt=function(n,t,e,i,a){this.a=n,this.b=t,this.g=e,this.f=i,this.e=a},Ol(212,1,{212:1},qf.wt),o.a=0,o.b=0,o.e=!1,o.f=!1,o.g=0,Qf.ynb=hd(212),qf.xt=function(n,t){var e,i,a,s;for(s=!1,n.b=t,qf.nu(n.b,15),e=n.b.f,i=n.b.g,n.j=$l(Qf.nyb,tn,6,i,16,1),a=0;a<i;++a)n.j[a]=!1;for(n.g=$l(Qf.nyb,tn,6,e,16,1),n.c=$l(Qf.Mmb,G,6,e,15,1),a=0;a<e;++a)n.g[a]=!1,n.c[a]=-1;for(n.e=$l(Qf.zwb,L,2,3*e,6,1),n.i=0,n.d=0,n.a=0;!s;){for(a=0;a<e;++a)if(!n.g[a]){n.a>0&&(n.e[n.i++]="."),qf.zt(n,a,-1),++n.a;break}a==e&&(s=!0)}for(n.f="",a=0;a<n.i;++a)n.f+=""+n.e[a];return n.f},qf.yt=function(n){switch(n){case 5:case 6:case 7:case 8:case 9:case 15:case 16:case 17:case 35:case 53:return!0;default:return!1}},qf.zt=function(t,e,i){var a,s,r,o,f,l,d,g,u,c,b,h,D;if(a=!0,l=0,D=0,c=t.i,t.c[e]=c,f=qf.Hk(t.b,e),o=qf.wk(t.b,e),s=qf.qk(t.b,e),r=qf.Ak(t.b,e),g=qf.Kn(t.b,e),0==s&&0==r&&qf.yt(f)&&(a=!1),t.e[c]="",-1!=i)switch(qf.Uk(t.b,i)){case 0:t.e[c]+="~";break;case 2:t.e[c]+="=";break;case 3:t.e[c]+="#"}for(a&&(t.e[c]+="["),0!=r&&(t.e[c]+=""+r),t.e[c]+=""+o,a&&0<(h=qf.Zn(t.b,e))&&(t.e[c]+="H",1<h&&(t.e[c]+=h)),0!=s&&(t.e[c]+=s>0?"+":"-",n.Math.abs(s)>1&&(t.e[c]+=""+n.Math.abs(s))),a&&(t.e[c]+="]"),-1!=i&&(t.j[i]=!0),t.g[e]=!0,++t.i,b=0;b<g;++b)t.j[qf.Ln(t.b,e,b)]||++l;for(b=0;b<g;++b)if(d=qf.Jn(t.b,e,b),u=qf.Ln(t.b,e,b),t.j[u])++D;else if(t.g[d]){switch(++t.d,t.j[u]=!0,qf.Uk(t.b,u)){case 0:t.e[t.c[d]]+="~",t.e[c]+="~";break;case 2:t.e[t.c[d]]+="=",t.e[c]+="=";break;case 3:t.e[t.c[d]]+="#",t.e[c]+="3"}t.d>9&&(t.e[t.c[d]]+="%",t.e[c]+="%"),t.e[t.c[d]]+=""+t.d,t.e[c]+=""+t.d}else b-D<l-1&&(t.e[t.i++]="("),qf.zt(t,d,u),b-D<l-1&&(t.e[t.i++]=")")},qf.At=function(){},Ol(330,1,{},qf.At),o.a=0,o.d=0,o.i=0,Qf.znb=hd(330),qf.Bt=function(n,t){var e,i,a,s,r,o,f,l,d,g,u,c,b;for(l=$l(Qf.Mmb,G,6,n.j.f,15,1),o=$l(Qf.Mmb,G,6,n.j.f,15,1),f=$l(Qf.Mmb,G,6,n.j.f,15,1),d=$l(Qf.Mmb,G,6,n.j.f,15,1),e=qf.Mk(n.j,0,t),i=qf.Mk(n.j,1,t),o[0]=e,o[1]=i,f[0]=-1,f[1]=t,l[e]=1,l[i]=2,d[e]=-1,d[i]=e,r=1,g=1;r<=g&&l[o[r]]<15;){for(b=o[r],u=0;u<qf.Kn(n.j,b);u++)if((a=qf.Jn(n.j,b,u))!=d[b]){if(s=qf.Ln(n.j,b,u),a==e){for(f[0]=s,c=0;c<=g;c++)n.f[f[u]]||(n.f[f[u]]=!0,++n.c);return}qf.wl(n.j,a)&&0==l[a]&&(o[++g]=a,f[g]=s,l[a]=l[b]+1,d[a]=b)}++r}},qf.Ct=function(n){var t,e,i,a,s,r,o,f,l,d,g,u,c;for(qf.nu(n.j,7),g=!1,u=$l(Qf.Mmb,G,6,2,15,1),c=$l(Qf.Mmb,G,6,2,15,1),d=$l(Qf.Mmb,G,6,2,15,1),i=0;i<n.j.g;i++)if(!qf.So(n.j,i)&&2==qf.Xk(n.j,i)){for(r=0;r<2;r++){for(u[r]=-1,d[r]=-1,t=qf.Mk(n.j,r,i),l=0;l<qf.Kn(n.j,t);l++)(a=qf.Ln(n.j,t,l))!=i&&(-1!=u[r]||257!=qf.Xk(n.j,a)&&129!=qf.Xk(n.j,a)?d[r]=qf.Jn(n.j,t,l):(u[r]=qf.Jn(n.j,t,l),c[r]=a));if(-1==u[r])break}if(-1!=u[0]&&-1!=u[1]){for(f=qf.Xk(n.j,c[0])==qf.Xk(n.j,c[1]),o=0;o<2;o++)u[o]==qf.Mk(n.j,0,c[o])&&(f=!f);for(s=0;s<2;s++)-1!=d[s]&&d[s]<u[s]&&(f=!f);qf.um(n.j,i,f?2:1,!1),g=!0}}for(e=0;e<n.j.g;e++)(257==qf.Xk(n.j,e)||129==qf.Xk(n.j,e))&&qf.xm(n.j,e,1);return g},qf.Dt=function(n){return 61==n?2:35==n?4:36==n?32:58==n?8:62==n?16:126==n?31:1},qf.Et=function(n,t){var e,i,a,s,r,o,f,l,d,g,u;for(e=0;e<n.j.f;e++)if(qf.wl(n.j,e))for(f=$l(Qf.Mmb,G,6,n.j.f,15,1),o=$l(Qf.Mmb,G,6,n.j.f,15,1),l=$l(Qf.Mmb,G,6,n.j.f,15,1),o[0]=e,f[e]=1,l[e]=-1,r=0,d=0;r<=d;){for(a=1&~f[o[r]]?2:1,g=0;g<qf.Kn(n.j,o[r]);g++)if(i=qf.Ln(n.j,o[r],g),qf.Uk(n.j,i)==a&&t[i]&&0==f[s=qf.Jn(n.j,o[r],g)]){if(1==a&&qf.wl(n.j,s)){for(u=o[r];-1!=u;)qf.xm(n.j,qf.Hn(n.j,s,u),1==a?2:1),a=3-a,s=u,u=l[u];return qf.dm(n.j,e,!1),qf.dm(n.j,s,!1),n.b-=2,!0}o[++d]=s,l[s]=o[r],f[s]=f[o[r]]+1}++r}return!1},qf.Ft=function(n){var t,e,i,a;for(t=0;t<n.j.f;t++)if(7==qf.Hk(n.j,t)&&0==qf.qk(n.j,t)&&qf.eo(n.j,t)>3&&qf.An(n.j,t)>0)for(a=0;a<qf.Kn(n.j,t);a++)if(e=qf.Jn(n.j,t,a),i=qf.Ln(n.j,t,a),qf.Uk(n.j,i)>1&&qf.ul(n.j,e)){4==qf.Xk(n.j,i)?qf.xm(n.j,i,2):qf.xm(n.j,i,1),qf.Wl(n.j,t,qf.qk(n.j,t)+1),qf.Wl(n.j,e,qf.qk(n.j,e)-1),qf.Ul(n.j,t,-1);break}},qf.Gt=function(n){return n.q?"Unresolved SMARTS features:"+n.q:""},qf.Ht=function(n,t,e){var i,a;if(t<3)return!1;if((43==n[i=t-1]||45==n[i])&&--i,!eg(n[i]&B))return!1;if(68!=n[--i]&&82!=n[i]&&88!=n[i]&&122!=n[i])return!1;for(e[0]=0;i>0&&ig(n[i-1]);)--i,++e[0];for(a=t+1;ig(n[i]);){if(n.length<=a||n[i]!==n[a])return!1;++i,++a}return!0},qf.It=function(n,t,e){var i,a,s,r,o,f,l,d,g,u,c,b,h,D,H,j,m,A,C,p,M,I,P,T,N,w,U,J,L,y,R,k,x,E,F,Q,z,S,X,G;for(qf.nu(n.j,1),n.f=$l(Qf.nyb,tn,6,n.j.g,16,1),n.c=0,g=0;g<n.j.g;g++)64==qf.Xk(n.j,g)&&(qf.xm(n.j,g,1),n.f[g]=!0,++n.c);for(m=$l(Qf.nyb,tn,6,n.j.f,16,1),G=new qf.as(n.j,3),j=$l(Qf.nyb,tn,6,G.i.a.length,16,1),Q=0;Q<G.i.a.length;Q++){for(S=Vf.Oi(G.i,Q),j[Q]=!0,T=0,U=(M=S).length;T<U;++T)if(C=M[T],!qf.wl(n.j,C)){j[Q]=!1;break}if(j[Q]){for(N=0,J=(I=S).length;N<J;++N)m[C=I[N]]=!0;for(P=0,w=(p=X=Vf.Oi(G.j,Q)).length;P<w;++P)C=p[P],n.f[C]||(n.f[C]=!0,++n.c)}}for(u=0;u<n.j.g;u++)!n.f[u]&&G.b[u]&B&&qf.wl(n.j,qf.Mk(n.j,0,u))&&qf.wl(n.j,qf.Mk(n.j,1,u))&&qf.Bt(n,u);for(c=0;c<n.j.g;c++)n.f[c]||(s=qf.Mk(n.j,0,c),r=qf.Mk(n.j,1,c),!m[s]&&!m[r]&&qf.wl(n.j,s)&&qf.wl(n.j,r)&&(n.f[c]=!0,++n.c));for(qf.nu(n.j,7),H=$l(Qf.nyb,tn,6,n.j.g,16,1),n.j.g>=0&&zf.bKb(n.f,0,H,0,n.j.g),z=0;z<G.i.a.length;z++)if(j[z])for(R=0,k=(y=S=Vf.Oi(G.i,z)).length;R<k;++R)if(L=y[R],!qf.St(n,L))for(qf.wl(n.j,L)&&(qf.dm(n.j,L,!1),--n.b),C=0;C<qf.Kn(n.j,L);C++)h=qf.Ln(n.j,L,C),n.f[h]&&(n.f[h]=!1,--n.c);for(qf.Rt(n),F=0;F<G.i.a.length;F++)if(j[F]&&6==Vf.Oi(G.j,F).length){for(A=!0,l=0,d=(f=X=Vf.Oi(G.j,F)).length;l<d;++l)if(o=f[l],!n.f[o]){A=!1;break}A&&(qf.Qt(n,X[0]),qf.Qt(n,X[2]),qf.Qt(n,X[4]),qf.Rt(n))}for(E=5;E>=4;E--)do{for(x=!1,o=0;o<n.j.g;o++)if(n.f[o]){for(i=0,D=0;D<2;D++)for(b=qf.Mk(n.j,D,o),C=0;C<qf.Kn(n.j,b);C++)n.f[qf.Ln(n.j,b,C)]&&++i;if(i==E){qf.Qt(n,o),qf.Rt(n),x=!0;break}}}while(x);for(;n.b>=2&&qf.Et(n,H););if(t){if(0!=n.b)for(a=0;a<n.j.f;a++)qf.wl(n.j,a)&&(qf.dm(n.j,a,!1),qf.gm(n.j,a,2,!0),--n.b,e=!0);if(0!=n.c)for(o=0;o<n.j.g;o++)n.f[o]&&(n.f[o]=!1,qf.xm(n.j,o,64),--n.c,e=!0)}else for(a=0;a<n.j.f;a++)qf.wl(n.j,a)&&0!=qf.Zn(n.j,a)&&(qf.dm(n.j,a,!1),qf.hm(n.j,a,32),--n.b);if(0==n.p||1==n.p&&!e){if(0!=n.b)throw bd(new zf.aA(De));if(0!=n.c)throw bd(new zf.aA(De))}},qf.Jt=function(t,e,i,a,s,r,o){var f,l,d,g,u,c,b,h,D,H,j,m,A,C,p,M,I,P,T,N,w,U,J,L,R,k,x,E,F,Q,z,S,X,Y,q,V,v,Z,O,K,W,_,$,nn,tn,en,an,sn,rn,on,fn,dn,gn,un,cn,Dn,jn,mn,pn,Mn,In,Pn,Nn,wn,Un,Ln,yn,Bn,Rn;for(t.j=e,qf.lu(t.j),t.q&&zf.LGb(t.q,0),t.b=0,t.o=!1,l=0!=t.p,rn=null,(H=$l(Qf.Mmb,G,6,32,15,1))[0]=-1,cn=$l(Qf.Mmb,G,6,16,15,1),mn=$l(Qf.Mmb,G,6,16,15,1),jn=$l(Qf.Mmb,G,6,16,15,1),Dn=$l(Qf.Mmb,G,6,16,15,1),z=0;z<16;z++)cn[z]=-1;for(b=0,J=-1,In=!1,Y=!1,E=!1,p=0,A=1,m=0,c=new Hl.D7,on=new qf.eu(i),u=new qf.Xt,un=new Vf.bj,Mn=$l(Qf.Mmb,G,6,1,15,1);i[a]<=32;)++a;for(;a<s;)if(Nn=i[a++]&B,zf.pHb(Nn)||42==Nn||63==Nn||33==Nn&&l&&In||35==Nn&&l&&In){if(D=-1,I=0,O=0,f=-1,w=-1,sn=!1,X=!1,h=0,In){if(42==Nn)D=6,h=Gd(h,1);else if(63==Nn)D=0;else if((V=33==Nn)&&(t.o=!0,h=Gd(h,1),++a),82==i[a-1]&&l&&(eg(i[a]&B)||t.a&&123==i[a]))D=6,h=Gd(h,1),--a,V&&--a;else{if(!qf.Lt(t,i,a-1,s,u))throw bd(new zf.aA("SmilesParser: Unexpected character in atom definition:'"+String.fromCharCode(i[a-1]&B)+He+(a-1)));if(D=u.a,a+=u.b-1,2!=t.p&&(w=9),l&&(44==i[a]||V)){for(W=u.d,K=u.c,Pn=a-u.b;Pn<s;){if(!qf.Lt(t,i,Pn,s,u)){if(!V)throw bd(new zf.aA("SmilesParser: Unexpected character in atom list:'"+String.fromCharCode(i[Pn]&B)+je+Pn));break}if(1==u.a){if(!V)throw bd(new zf.aA("SmilesParser: Hydrogen is not supported in positive atom lists:'"+zf.mJb((Vf.iQb(i,Pn,s),Vf.nQb(i,$l(Qf.Imb,dt,6,s-Pn,15,1),Pn,s)))+je+Pn))}else Hl.y7(c,zf.FIb(u.a)),W|=u.d,K|=u.c;if(i[Pn+=u.b]!=(V?59:44))break;if(V&&33!=i[Pn+1])break;33==i[++Pn]&&++Pn}c.d.a.length>1&&(w=-1,K?W||(h=Gd(h,4)):h=Gd(h,2)),a=Pn}}for(;In;)if(64!=i[a])if(58!=i[a]){if(91==i[a])throw bd(new zf.aA("SmilesParser: nested square brackets found. Position:"+a));if(93!=i[a])if(I=qf.Mt(i,a,Mn),0==Mn[0])if((q=33==i[a])&&++a,72!=i[a])if(68!=i[a])if(122==i[a]&&t.a)++a,a+=qf.bu(on,a,4),U=0,on.c<=0&&on.b>=0&&(U=Gd(U,xn)),on.c<=1&&on.b>=1&&(U=Gd(U,me)),on.c<=2&&on.b>=2&&(U=Gd(U,Ae)),on.c<=3&&on.b>=3&&(U=Gd(U,Ce)),on.c<=4&&on.b>=4&&(U=Gd(U,kn)),0!=Ud(U,0)&&(h=q?Gd(h,U):Sd(wd(h,Jn),0)?wd(h,Xd(U)):Gd(h,U=Wd(U,Jn)));else if(88!=i[a])if(65!=i[a]&&97!=i[a])if(82!=i[a])if(114!=i[a])if(118!=i[a])if(36!=i[a])if(!l||59!=i[a]&&38!=i[a]){if(!l||44!=i[a]||!qf.Ht(i,a,Mn))throw bd(new zf.aA("SmilesParser: unexpected character inside brackets: '"+String.fromCharCode(i[a]&B)+pe+a));t.o=!0,a+=Mn[0]+1}else t.o=!0,++a;else a+=qf.Pt(t,i,a,un);else++a,a+=qf.bu(on,a,1),Un=on.c,on.b>on.c&&qf.Ut(t,(q?"!v":"v")+"{"+on.c+"-"+on.b+"}"),!q&&Un<=14?f=Un:on.b>on.c||qf.Ut(t,(q?"!v":"v")+Un);else{if(++a,a+=qf.bu(on,a,1),on.a){h=Gd(h,q?384:8);continue}pn=on.c,on.b>on.c&&qf.Ut(t,(q?"!r":"r")+"{"+on.c+"-"+on.b+"}"),!q&&pn>=3&&pn<=7?h=Gd(h,Qf.Cyb(pn<<22)):on.b>on.c||qf.Ut(t,(q?"!r":"r")+pn)}else++a,a+=qf.bu(on,a,3),U=0,on.c<=0&&on.b>=0&&(U=Gd(U,8)),on.c<=1&&on.b>=1&&(U=Gd(U,16)),on.c<=2&&on.b>=2&&(U=Gd(U,32)),on.c<=3&&on.b>=3&&(U=Gd(U,64)),on.b>3&&qf.Ut(t,(q?"!R":"R")+on.b),0!=Ud(U,0)&&(h=q?Gd(h,U):Sd(wd(h,120),0)?wd(h,Xd(U)):Gd(h,U=Wd(U,120)));else h=Gd(h,q^65==i[++a]?4:2);else{if(++a,a+=qf.bu(on,a,1),null==(Rn=(qf.Jj(),qf.Ej)[D]))continue;Un=Rn[0],Z=qf.Mt(i,a,Mn),0!=Mn[0]&&(qf.an(D)?Un+=Z:Un-=6==D?n.Math.abs(Z):Z),U=0,Un-on.c<=0&&Un-on.b>=0&&(U=Gd(U,ln)),Un-on.c<=1&&Un-on.b>=1&&(U=Gd(U,Lt)),Un-on.c<=2&&Un-on.b>=2&&(U=Gd(U,y)),0!=Ud(U,0)&&(h=q?Gd(h,U):Sd(wd(h,An),0)?wd(h,Xd(U)):Gd(h,U=Wd(U,An)))}else++a,a+=qf.bu(on,a,1),U=0,on.c<=0&&on.b>=0&&(U=Gd(U,gt)),on.c<=1&&on.b>=1&&(U=Gd(U,_n)),on.c<=2&&on.b>=2&&(U=Gd(U,Wn)),on.c<=3&&on.b>=3&&(U=Gd(U,bt)),on.c<=4&&on.b>=4&&(U=Gd(U,Tn)),0!=Ud(U,0)&&(h=q?Gd(h,U):Sd(wd(h,Cn),0)?wd(h,Xd(U)):Gd(h,U=Wd(U,Cn)));else++a,a+=qf.bu(on,a,1),U=0,on.c<=0&&on.b>=0&&(U=Gd(U,128)),on.c<=1&&on.b>=1&&(U=Gd(U,256)),on.c<=2&&on.b>=2&&(U=Gd(U,512)),on.c<=3&&on.b>=3&&(U=Gd(U,hn)),q?(h=Gd(h,U),w=-1):on.b==on.c?w=on.c:(h=Gd(h,wd(bn,Xd(U))),w=-1);else a+=Mn[0],0==I&&(h=Gd(h,Hn));else++a,In=!1}else for(++a;eg(i[a]&B);)O=10*O+i[a]-48,++a;else 64==i[++a]&&(X=!0,++a),sn=!0}else if(42==Nn)D=6,h=Gd(h,1);else if(63==Nn)D=0;else if(65!=Nn&&97!=Nn||!l)switch(String.fromCharCode(Nn).toUpperCase().charCodeAt(0)){case 66:a<s&&114==i[a]?(D=35,++a):D=5;break;case 67:a<s&&108==i[a]?(D=17,++a):D=6;break;case 70:D=9;break;case 73:D=53;break;case 78:D=7;break;case 79:D=8;break;case 80:D=15;break;case 83:D=16}else D=6,h=Gd(h,1),h=Gd(h,65==Nn?4:2),t.o=!0;if(-1==D&&63!=Nn)throw bd(new zf.aA("SmilesParser: unknown element label found. Position:"+(a-1)));if(g=qf.Lj(t.j,D),qf.Wl(t.j,g,I),qf.cm(t.j,g,O,!1),qf.Ul(t.j,g,f),0!=Ud(h,0)&&(t.o=!0,Sd(wd(h,2),0)?(h=wd(h,-3),qf.dm(t.j,g,!0),++t.b):qf.dm(t.j,g,!1),qf.gm(t.j,g,h,!0)),0!=c.d.a.length){for(t.o=!0,v=$l(Qf.Mmb,G,6,c.d.a.length,15,1),Q=0;Q<c.d.a.length;Q++)v[Q]=(Q<0?null:Vf.Oi(c.d,Q)).a;qf.am(t.j,g,v),Gf.UUb(c.d.a,0)}else if(String.fromCharCode(Nn).toLowerCase().charCodeAt(0)==Nn&&zf.pHb(Nn)){if(5!=D&&6!=D&&7!=D&&8!=D&&15!=D&&16!=D&&33!=D&&34!=D)throw bd(new zf.aA("SmilesParser: atomicNo "+D+" must not be aromatic. Position:"+(a-1)));qf.dm(t.j,g,!0),++t.b}else qf.dm(t.j,g,!1);if(0!=un.a.length){for(R=new Vf.eQb(un);R.a<R.c.a.length;)L=Vf.dQb(R),qf.nm(L,0,0),qf.Vj(e,L,g);Gf.UUb(un.a,0)}-1!=w&&1!=D&&((M=$l(Qf.Imb,dt,6,1,15,1))[0]=w<<24>>24,qf.$l(t.j,g,M)),J=H[p],-1!=H[p]&&512!=A&&(j=qf.Nj(t.j,H[p],g,A),0!=m&&(t.o=!0,qf.wm(t.j,j,m,!0))),A=1,m=0,H[p]=g,0!=b&&(qf.em(t.j,g,b),b=0),o&&((en=rn?Vf.$Ob(rn,zf.FIb(J)):null)&&qf.Zt(en,g,a),sn&&(!rn&&(rn=new Vf.cTb),F=9==w?0:w,Vf.WSb(rn,zf.FIb(g),new qf.au(g,a-2,J,F,X))))}else if(36!=Nn)if(46!=Nn)if(45!=Nn&&61!=Nn&&35!=Nn&&36!=Nn&&58!=Nn&&47!=Nn&&92!=Nn&&60!=Nn&&126!=Nn&&33!=Nn&&64!=Nn)if(Nn<=32)a=s;else if(eg(Nn))if($=Nn-48,In){for(;a<s&&eg(i[a]&B);)$=10*$+i[a]-48,++a;b=$}else{if(x=45==i[C=Y?a-3:a-2]||47==i[C]||92==i[C]||61==i[C]||35==i[C]||36==i[C]||58==i[C]||62==i[C]||126==i[C],Y&&a<s&&eg(i[a]&B)&&($=10*$+i[a]-48,Y=!1,++a),$>=cn.length){if($>=100)throw bd(new zf.aA("SmilesParser: ringClosureAtom number out of range: "+$));for(nn=cn.length,_=cn.length;_<=$;)_=n.Math.min(100,_+16);for(Gf.kVb(_),cn=Vf.nQb(cn,$l(Qf.Mmb,G,6,_,15,1),0,_),Gf.kVb(_),mn=Vf.nQb(mn,$l(Qf.Mmb,G,6,_,15,1),0,_),Gf.kVb(_),jn=Vf.nQb(jn,$l(Qf.Mmb,G,6,_,15,1),0,_),Gf.kVb(_),Dn=Vf.nQb(Dn,$l(Qf.Mmb,G,6,_,15,1),0,_),Q=nn;Q<_;Q++)cn[Q]=-1}if(-1==cn[$])cn[$]=H[p],mn[$]=a-1,jn[$]=x?A:-1,Dn[$]=x?m:0;else{if(cn[$]==H[p])throw bd(new zf.aA("SmilesParser: ring closure to same atom"));o&&rn&&((en=Vf.$Ob(rn,zf.FIb(cn[$])))&&qf.Zt(en,H[p],mn[$]),(en=Vf.$Ob(rn,zf.FIb(H[p])))&&qf.Zt(en,cn[$],a-1)),-1!=jn[$]?A=jn[$]:257==A?A=129:129==A&&(A=257),j=qf.Nj(t.j,cn[$],H[p],A),0!=Dn[$]&&(m=Dn[$]),0!=m&&(t.o=!0,qf.wm(t.j,j,Dn[$],!0)),cn[$]=-1}A=1,m=0}else{if(43==Nn)throw bd(new zf.aA("SmilesParser: '+' found outside brackets. Position:"+(a-1)));if(40!=Nn)if(41!=Nn)if(91!=Nn){if(93==Nn)throw bd(new zf.aA("SmilesParser: closing bracket at unexpected position:"+(a-1)));if(37!=Nn)throw bd(new zf.aA("SmilesParser: unexpected character outside brackets: '"+String.fromCharCode(Nn)+He+(a-1)));Y=!0}else In=!0;else{if(0==p){if(!E)throw bd(new zf.aA("SmilesParser: Closing ')' without opening counterpart. Position:"+(a-1)));H[0]=-1,E=!1;continue}--p}else{if(-1==H[p]){E=!0;continue}++p,H.length==p&&(H=Vf.lQb(H,H.length+32)),H[p]=H[p-1]}}else{if(In)throw bd(new zf.aA("SmilesParser: unexpected bond symbol inside square brackets: '"+String.fromCharCode(Nn)+pe+(a-1)));for(T=0;45==Nn||61==Nn||35==Nn||36==Nn||58==Nn||47==Nn||92==Nn||60==Nn||126==Nn||33==Nn||64==Nn;){if(33==Nn)if(64==(Nn=i[a++]&B))m|=128;else if(45==Nn&&62==i[a]||60==Nn&&45==i[a])T|=32,++a;else if(45==Nn)T|=1;else if(61==Nn)T|=2;else if(35==Nn)T|=4;else if(36==Nn)T|=32;else{if(58!=Nn)throw bd(new zf.aA("SmilesParser: bond symbol '"+String.fromCharCode(Nn)+"' not allowed after '!'. Position:"+(a-1)));T|=8}else if(64==Nn?m|=256:61==Nn?A=2:35==Nn?A=4:36==Nn?A=8:58==Nn?A=64:126==Nn?m|=15:47==Nn?o&&(A=257):92==Nn?o&&(A=129):(45==Nn&&62==i[a]||60==Nn&&45==i[a])&&(A=32,++a),44==i[a])for(m|=61==(32==A?62:Nn)?2:35==(32==A?62:Nn)?4:36==(32==A?62:Nn)?32:58==(32==A?62:Nn)?8:62==(32==A?62:Nn)?16:126==(32==A?62:Nn)?31:1;44==i[a];)60==i[a+1]&&45==i[a+2]||45==i[a+1]&&62==i[a+2]?(m|=16,a+=3):(m|=qf.Dt(i[a+1]&B),a+=2);if(59!=i[a]){0!=T&&(m|=31&~T);break}++a,Nn=i[a++]&B}}else H[p]=-1,A=512;else{if(0!=un.a.length)throw bd(new zf.aA("SmilesParser: multiple recursive SMARTS without preceding atom are not supported yet. Position:"+(a-1)));H[p]=e.q,a+=qf.Pt(t,i,a-1,un),qf.Oj(e,(Gf.nVb(0,un.a.length),un.a[0])),Gf.UUb(un.a,0)}if(1!=A)throw bd(new zf.aA("SmilesParser: dangling open bond"));for(dn=0,gn=(fn=cn).length;dn<gn;++dn)if(-1!=fn[dn])throw bd(new zf.aA("SmilesParser: dangling ring closure."));for(k=qf.Xn(t.j),qf.Bm(t.j,!0),qf.nu(t.j,1),d=0;d<t.j.q;d++)if(null!=qf.sk(t.j,d))if(N=qf.tk(t.j,d)[0],t.o||2==t.p){if(9!=N)if(t.g)for(Q=0;Q<N;Q++)qf.Nj(t.j,d,qf.Lj(t.j,1),1);else 0==N&&qf.gm(t.j,d,1792,!0),1==N&&qf.gm(t.j,d,1664,!0),2==N&&qf.gm(t.j,d,1408,!0),3==N&&qf.gm(t.j,d,896,!0)}else{if(9==N&&(N=0),!qf.xl(t.j,d)&&(!qf.wl(t.j,d)||6==qf.Hk(t.j,d)&&0==qf.qk(t.j,d))){for(Rn=qf.Ym(qf.Hk(t.j,d)),P=!1,wn=qf.eo(t.j,d),wn-=qf._k(t.j,d,wn),wn+=N,qf.wl(t.j,d)&&++wn,yn=0,Bn=(Ln=Rn).length;yn<Bn;++yn)if(wn<=(Un=Ln[yn])){P=!0,Un==wn+2?qf.hm(t.j,d,48):Un==wn+1?qf.hm(t.j,d,32):(Un!=wn||Un!=Rn[0])&&qf.Ul(t.j,d,wn);break}P||qf.Ul(t.j,d,wn)}if(t.g||!qf.hp(t.j,d))for(Q=0;Q<N;Q++)qf.Nj(t.j,d,qf.Lj(t.j,1),1)}else t.g||!t.o&&2!=t.p||((N=qf.On(t.j,d))>=1&&qf.gm(t.j,d,128,!0),N>=2&&qf.gm(t.j,d,256,!0),N>=3&&qf.gm(t.j,d,512,!0),N>=4&&qf.gm(t.j,d,hn,!0));if(!t.g&&(t.o||2==t.p)&&qf.Zo(t.j,!0),qf.nu(t.j,1),qf.Ft(t),qf.It(t,l,t.o),t.j.t=null,qf.Bm(t.j,!1),o&&(qf.Ct(t),rn)){for(tn=new Vf.zOb(rn).a.Ud().Fb(),an=new Vf.GOb(tn);an.a.Gd();)en=an.a.Hd().Yd(),qf.fm(t.j,en.a,qf.$t(en,k),!1);qf.cp(t.j,0)}qf.cp(t.j,0),r&&(S=new Of.yy(t.d),Sd(t.k,0)&&Of.uy(S,t.k),Of.fy(S,t.j),o&&qf.Au(t.j)),(t.o||2==t.p)&&(qf.zm(t.j,!0),qf.jp(t.j),qf.kp(t.j))},qf.Kt=function(n,t,e,i,a){qf.Jt(n,t,e,0,e.length,i,a)},qf.Lt=function(n,t,e,i,a){var s;if(a.d=!0,a.c=!0,35==t[e]){for(++e,n.o=!0,a.a=0,a.b=1;e<i&&eg(t[e]&B);)a.a=10*a.a+t[e]-48,++a.b,++e;if(0==a.a||a.a>=(qf.Jj(),qf.Dj).length)throw bd(new zf.aA("SmilesParser: Atomic number out of range. position:"+(e-1)));return!0}return t[e]>=65&&t[e]<=90?(a.b=t[e+1]>=97&&t[e+1]<=122?2:1,a.a=(qf.Jj(),qf._m(zf.IJb(Gf.$Ub(t,e,(s=a.b,Fl.CMb(),s))),321)),a.d=!1,!0):t[e]>=97&&t[e]<=122&&(a.b=t[e+1]>=97&&t[e+1]<=122?2:1,a.a=(qf.Jj(),qf._m(zf.IJb(Gf.$Ub(t,e,(s=a.b,Fl.CMb(),s))),321)),a.c=!1,!0)},qf.Mt=function(n,t,e){var i,a;if(e[0]=0,43==n[t]||45==n[t]){for(a=n[t],i=1,++e[0];n[t+e[0]]==a;)++i,++e[0];return 1==i&&eg(n[t+1]&B)&&(i=n[t+1]-48,++e[0]),43==a?i:-i}return 0},qf.Nt=function(n,t){var e;return null==t?null:qf.Ot(n,Gf.aVb((e=t,Fl.CMb(),e)))},qf.Ot=function(n,t){var e,i,a,s,r,o,f,l,d,g,u;for(r=Hl.h7(t,0);r>0&&45==t[r-1];)r=Hl.h7(t,r+1);for(o=-1==r?-1:Hl.h7(t,r+1);o>0&&45==t[o-1];)o=Hl.h7(t,o+1);if(-1==o)throw bd(new zf.aA("Missing one or both separators ('>')."));if(-1!=Hl.h7(t,o+1))throw bd(new zf.aA("Found more than 2 separators ('>')."));for(u=new el.IF,g=0,s=0,e=-1;s<t.length;){for(;s<t.length&&46==t[s];)++s;if(40==t[s]){if(-1!=e)throw bd(new zf.aA("Second open group bracket found before closing first one."));for(f=0,a=++s;a<t.length;a++)if(40==t[a])++f;else if(41==t[a]&&0==f--){e=a;break}}for(i=s;i<t.length&&62!=t[i]&&(46!=t[i]||!(n.n&&-1==e||e==i-1||i+1==t.length||46==t[i+1]));)++i;if(d=i,e==i-1&&(--d,e=-1),s!=d){if(l=new qf.Fu,qf.Jt(n,l,t,s,d,!0,!0),1==n.p&&n.o)return qf.Ot(new qf.Wt(2|n.i),t);0==g?(Vf.Ji(u.g,l),u.d=-1):1==g?Vf.Ji(u.a,l):(Vf.Ji(u.f,l),u.d=-1)}for(s=i;s<t.length&&62==t[s];)++s,++g}return u},qf.Pt=function(n,t,e,i){var a,s,r,o;if(40!=t[e+1])throw bd(new zf.aA("SmilesParser: '$' for recursive SMARTS must be followed by '('. position:"+e));for(o=1,s=e+2;s<t.length&&o>0;)40==t[s]?++o:41==t[s]&&--o,++s;if(o>0)throw bd(new zf.aA("SmilesParser: Missing closing ')' for recursive SMARTS. '('-position:"+(e+1)));if(r=new qf.Gu(16,16),qf.Jt(new qf.Wt(n.i|n.p),r,t,e+2,s-1,!0,!0),Gf.SUb(i.a,r),33==t[e-1])for(a=0;a<r.q;a++)qf.gm(r,a,en,!0);return s-e},qf.Qt=function(n,t){var e,i,a,s;for(1==qf.Xk(n.j,t)&&qf.xm(n.j,t,2),a=0;a<2;a++)for(e=qf.Mk(n.j,a,t),qf.wl(n.j,e)&&(qf.dm(n.j,e,!1),--n.b),s=0;s<qf.Kn(n.j,e);s++)i=qf.Ln(n.j,e,s),n.f[i]&&(n.f[i]=!1,--n.c)},qf.Rt=function(n){var t,e,i,a,s,r,o;do{for(o=!1,e=0;e<n.j.g;e++)if(n.f[e]){for(s=!1,a=0;a<2;a++){for(t=!1,i=qf.Mk(n.j,a,e),r=0;r<qf.Kn(n.j,i);r++)if(e!=qf.Ln(n.j,i,r)&&n.f[qf.Ln(n.j,i,r)]){t=!0;break}if(!t){s=!0;break}}s&&(o=!0,qf.Qt(n,e))}}while(o)},qf.St=function(n,t){var e,i;if(!qf.cs(qf.Hk(n.j,t)))return!1;if(6==qf.Hk(n.j,t)){if(!qf.wl(n.j,t))return!1;if(qf.qk(n.j,t)>0)return!1}return e=null==qf.sk(n.j,t)||9==qf.tk(n.j,t)[0]?0:qf.tk(n.j,t)[0],!((i=qf.Vn(n.j,t)-e)<1)&&(16!=qf.Hk(n.j,t)&&34!=qf.Hk(n.j,t)&&52!=qf.Hk(n.j,t)||!(2==qf.Kn(n.j,t)&&qf.qk(n.j,t)<=0)&&2!=i)},qf.Tt=function(n,t){n.k=t},qf.Ut=function(n,t){n.e&&(!n.q&&(n.q=new zf.XJb),zf.UJb(n.q," "),zf.UJb(n.q,t))},qf.Vt=function(){qf.Wt.call(this,0)},qf.Wt=function(n){this.i=-4&n,this.p=3&n,this.a=!(16&n),this.n=!!(32&n),this.e=!!(64&n),this.g=!!(8&n),this.d=2,4&n&&(this.d|=1),this.g&&(this.d&=-3)},Ol(114,1,{},qf.Vt,qf.Wt),o.a=!1,o.b=0,o.c=0,o.d=0,o.e=!1,o.g=!1,o.i=0,o.k=0,o.n=!1,o.o=!1,o.p=0,Qf.Dnb=hd(114),qf.Xt=function(){},Ol(392,1,{},qf.Xt),o.a=0,o.b=0,o.c=!1,o.d=!1,Qf.Anb=hd(392),qf.Yt=function(n,t){this.a=n,this.b=t},Ol(211,1,{211:1},qf.Yt),o.a=0,o.b=0,Qf.Bnb=hd(211),qf.Zt=function(n,t,e){if(!n.c){if(4==n.e.a.length)return void(n.c=!0);Vf.Ji(n.e,new qf.Yt(t,e))}},qf.$t=function(n,t){var e,i;if(n.c)return 3;for(i=new Vf.eQb(n.e);i.a<i.c.a.length;)2147483646!=(e=Vf.dQb(i)).a&&e.a!=I&&(e.a=t[e.a]);if(3==n.e.a.length)Vf.Ji(n.e,new qf.Yt(I,n.b));else if(4!=n.e.a.length)return 3;return n.d^qf._t(n)?1:2},qf._t=function(n){var t,e,i;for(e=!1,t=1;t<n.e.a.length;t++)for(i=0;i<t;i++)Vf.Oi(n.e,i).a>Vf.Oi(n.e,t).a&&(e=!e),Vf.Oi(n.e,i).b>Vf.Oi(n.e,t).b&&(e=!e);return e},qf.au=function(n,t,e,i,a){0!=i&&1!=i?this.c=!0:(this.a=n,this.b=t,this.d=a,this.e=new Vf.bj,-1!=e&&qf.Zt(this,e,t-1),-1!=e&&1==i&&qf.Zt(this,2147483646,t+1))},Ol(254,1,{254:1},qf.au),o.a=0,o.b=0,o.c=!1,o.d=!1,Qf.Cnb=hd(254),qf.bu=function(n,t,e){var i,a,s,r,o;if(n.a=!1,n.d=t,eg(n.e[t]&B)){for(o=qf.cu(n),n.c=n.b=o,i=t-1;i>1&&ag(n.e[i-1]);)--i;for(;44==n.e[n.d];){for(r=!0,s=t-i,a=0;a<s;a++)if(n.e[i+a]!==n.e[n.d+1+a]){r=!1;break}if(!r)break;n.d+=1+s,o=qf.cu(n),n.c>o?n.c=o:n.b<o&&(n.b=o)}return n.d-t}return 123==n.e[t]&&eg(n.e[t+1]&B)?(++n.d,n.c=qf.cu(n),45!=n.e[n.d++]?0:eg(n.e[n.d]&B)?(n.b=qf.cu(n),125!=n.e[n.d++]?0:n.d-t):0):(n.c=1,n.b=e,n.a=!0,0)},qf.cu=function(n){var t;return t=n.e[n.d++]-48,eg(n.e[n.d]&B)&&(t=10*t+(n.e[n.d++]-48)),t},qf.du=function(n){return"{"+n.c+"-"+n.b+"}"},qf.eu=function(n){this.e=n},Ol(391,1,{},qf.eu),o.lb=function(){return qf.du(this)},o.a=!1,o.b=0,o.c=0,o.d=0,Qf.Enb=hd(391),qf.gu=function(n){n.c=new Vf.bj},qf.hu=function(n,t){var e,i,a,s;if(0==(s=n.c.a.length))return Vf.Ii(n.c,0,t),0;for(a=1;2*a<=s;)a<<=1;for(i=a,--a;0!=i;)if(i>>=1,a>=s)a-=i;else{if(0==(e=zf.jJb(t,Vf.Oi(n.c,a))))return-1;if(0==i)break;e<0?a-=i:a+=i}return a<s&&zf.jJb(t,Vf.Oi(n.c,a))>0&&++a,Vf.Ii(n.c,a,t),a},qf.iu=function(n,t){var e,i,a,s;if(0==(s=n.c.a.length))return-1;for(a=1;2*a<=s;)a<<=1;for(i=a,--a;0!=i;)if(i>>=1,a>=s)a-=i;else{if(0==(e=zf.jJb(t,Vf.Oi(n.c,a))))return a;if(0==i)break;e<0?a-=i:a+=i}return-1},qf.ju=function(){qf.gu(this)},Ol(117,1,Me,qf.ju),o.Pb=function(n){return qf.iu(this,n)},Qf.Fnb=hd(117),qf.lu=function(n){qf.$j(n),n.d=null},qf.mu=function(n,t){qf.ek(n,t),n.d&&(t.T=0)},qf.nu=function(n,t){var e,i,a,s;if(qf.on(n,t),t&~n.T){for(15&n.T&&n.q>1&&qf.zh(n.J[0],n.J[1])&&Of.fy(new Of.yy(0),n),n.c&&(t|=128),e=0;e<n.q;e++)n.u[e]&=-67223560;for(i=0;i<n.g;i++)n.F[i]&=-64;a=0,s=0,32&t?(a=32,s=1):64&t&&(a=64,s=3),128&t&&(a|=128,s|=32),n.d=new qf.hg(n,s),qf.cg(n.d),qf.dg(n.d),qf.bg(n.d),qf.Eu(n)&&(n.d=new qf.hg(n,s)),n.T|=24|a}},qf.ou=function(n,t){return qf.Rf(n.d,t)},qf.pu=function(n,t){return qf.If(n.d,t)},qf.qu=function(n){var t;switch(qf.nu(n,31),t=n.I&B,n.I&nt){case y:return null;case gt:return 1==t?"meso":t+" meso diastereomers";case 0:return"unknown chirality";case ut:return"both enantiomers";case _n:return"this enantiomer";case 327680:return"this or other enantiomer";case Nn:return"two epimers";default:return 1==t?"one stereo isomer":t+" stereo isomers"}},qf.ru=function(n){var t;return t=new qf.Gu(n.q,n.r),qf.dk(n,t),t},qf.su=function(t){var e,i,a,s,r,o,f;for(qf.nu(t,15),o=$l(Qf.Mmb,G,6,3,15,1),i=0;i<t.f;i++)t.u[i]&Jt&&0!=(f=(t.u[i]&Kn)>>18)&&(o[f]=n.Math.max(o[f],(t.u[i]&Kn)>>18!=1&&(t.u[i]&Kn)>>18!=2?-1:(t.u[i]&It)>>20));for(s=0;s<t.g;s++)1!=(3&t.F[s])&&2!=(3&t.F[s])||1!=t.H[s]||0!=(f=(768&t.F[s])>>8)&&(o[f]=n.Math.max(o[f],(768&t.F[s])>>8!=1&&(768&t.F[s])>>8!=2?-1:(t.F[s]&Pt)>>10));for((r=$l(Qf.Mmb,ft,8,3,0,2))[1]=$l(Qf.Mmb,G,6,1+o[1],15,1),r[2]=$l(Qf.Mmb,G,6,1+o[2],15,1),e=0;e<t.f;e++)t.u[e]&Jt&&0!=(f=(t.u[e]&Kn)>>18)&&++r[f][(t.u[e]&Kn)>>18!=1&&(t.u[e]&Kn)>>18!=2?-1:(t.u[e]&It)>>20];for(a=0;a<t.g;a++)1!=(3&t.F[a])&&2!=(3&t.F[a])||1!=t.H[a]||0!=(f=(768&t.F[a])>>8)&&++r[f][(768&t.F[a])>>8!=1&&(768&t.F[a])>>8!=2?-1:(t.F[a]&Pt)>>10];return r},qf.tu=function(n){var t,e;return t=$l(Qf.Mmb,G,6,n.q,15,1),e=qf.Tn(n,t,!1,!1),qf.uu(n,t,e)},qf.uu=function(n,t,e){var i,a,s,r,o,f,l,d,g,u,c,b,h,D;for(h=$l(Qf.Gnb,fe,26,e,0,1),r=$l(Qf.Mmb,G,6,e,15,1),l=$l(Qf.Mmb,G,6,e,15,1),s=$l(Qf.Mmb,G,6,n.q,15,1),a=0;a<n.q;a++)-1!=t[a]&&(s[a]=r[t[a]]++);for(f=0;f<n.r;f++)(b=t[n.D[0][f]])==t[n.D[1][f]]&&-1!=b&&++l[b];for(D=0;D<e;D++)h[D]=new qf.Gu(r[D],l[D]),qf.mu(n,h[D]);for(i=0;i<n.q;i++)-1!=t[i]&&qf.ak(n,h[t[i]],i,0,0);for(o=0;o<n.r;o++)(b=t[n.D[0][o]])==t[n.D[1][o]]&&-1!=b&&qf.ck(n,h[b],o,0,0,s,!1);for(u=0,c=(g=h).length;u<c;++u)d=g[u],qf.Ql(d,1),qf.Ql(d,2);return h},qf.vu=function(n){return qf.nu(n,15),!n.d&&(n.f<2||!qf.zh(n.J[0],n.J[1]))&&(n.d=new qf.gg(n)),n.d?qf.Mf(n.d):null},qf.wu=function(n){return qf.nu(n,15),!n.d&&(n.f<2||!qf.zh(n.J[0],n.J[1]))&&(n.d=new qf.gg(n)),n.d?qf.Jf(n.d):null},qf.xu=function(n){var t,e;for(qf.nu(n,31),e=0,t=0;t<n.f;t++)3&n.u[t]&&!(4&n.u[t])&&++e;return e},qf.yu=function(n,t){return qf.Qf(n.d,t)},qf.zu=function(n,t){n.c=t,n.T&=-144},qf.Au=function(n){qf.nu(n,31),n.d&&qf.eg(n.d)},qf.Bu=function(n){var t,e;for(qf.nu(n,15),n.L=!1,t=0;t<n.q;t++)n.u[t]&=Bt,3&n.u[t]?n.u[t]|=Ut:n.u[t]&=yt;for(e=0;e<n.r;e++)3&n.F[e]&&2==qf.Uk(n,e)?n.H[e]=386:n.H[e]&=-385;n.T&=-249},qf.Cu=function(n,t,e){var i,a,s,r,o,f,l,d,g;if(1==(g=3&n.u[t])||2==g){if(o=!1,2==n.o[t]&&2==n.j[t]&&2==n.n[t][0]&&2==n.n[t][1]&&n.C[t]<=7)for(r=0;r<n.j[t];r++){for(i=n.i[t][r],d=0,l=$l(Qf.Mmb,G,6,3,15,1),f=0;f<n.j[i];f++)l[d]=n.i[i][f],l[d]!=t&&++d;2==d&&l[0]<l[1]^e[l[0]]<e[l[1]]&&(o=!o)}else for(r=1;r<n.j[t];r++)for(f=0;f<r;f++)(a=n.i[t][r])<(s=n.i[t][f])^e[a]<e[s]&&(o=!o);o&&(g=1==g?2:1)}return g},qf.Du=function(t){var e,i,a,s,r,o;for(qf.ip(t),qf.nu(t,31),a=0;a<t.f;a++){if(!((t.u[a]&Kn)>>18!=1&&(t.u[a]&Kn)>>18!=2||t.u[a]&Jt&&3&~t.u[a]))throw bd(new zf.aA(Ie));if(t.u[a]&y)throw bd(new zf.aA(Pe));if((1==(3&t.u[a])||2==(3&t.u[a]))&&0==t.o[a]){for(e=$l(Qf.Kmb,S,6,t.j[a],15,1),r=0;r<t.j[a];r++)e[r]=qf.Lk(t,a,t.i[a][r]);for(s=1;s<t.j[a];s++)if(!qf.El(t,t.k[a][s],a))for(o=0;o<s;o++)if(!qf.El(t,t.k[a][o],a)&&((i=n.Math.abs(qf.$m(e[s],e[o])))<.08||i>Qt))throw bd(new zf.aA(Te))}}},qf.Eu=function(n){var t,e,i,a,s,r,o;for(o=!1,e=0;e<n.f;e++)(!(n.u[e]&Jt)||!(3&~n.u[e]))&&(n.u[e]&=Bt);for(s=0;s<n.g;s++)(1!=qf.Uk(n,s)||!(3&n.F[s])||!(3&~n.F[s]))&&(n.F[s]&=-32513);if(n.L){if((n.I&nt)!=gt){for(r=$l(Qf.nyb,tn,6,n.f,16,1),i=0;i<n.f;i++)n.u[i]&Jt&&3&~n.u[i]&&(n.u[i]&Kn)>>18==1&&(r[i]=!0);for(a=0;a<n.f;a++)n.u[a]&Jt&&3&~n.u[a]&&(qf._l(n,a,1,0),o=!0);for(t=0;t<n.f;t++)r[t]&&(qf.fm(n,t,1,!1),qf._l(n,t,1,-1),o=!0)}n.L=!1}return qf.Ql(n,1),qf.Ql(n,2),o},qf.Fu=function(){qf.Jj(),qf.mp.call(this)},qf.Gu=function(n,t){qf.Jj(),qf.np.call(this,n,t)},qf.Hu=function(n){qf.Jj(),qf.op.call(this,n)},Ol(26,98,Ne,qf.Fu,qf.Gu,qf.Hu),o.Kb=function(n){qf.mu(this,n)},o.Mb=function(n){qf.nu(this,n)},o.c=!1,Qf.Gnb=hd(26),qf.Lu=function(n,t){var e,i,a,s,r,o,f,l,d,g,u;for(o=new Vf.bj,qf.nu(t,1),l=$l(Qf.nyb,tn,6,t.f,16,1),e=0;e<t.f;e++)if(n.f[e]&&(7==qf.Hk(n.i,e)||8==qf.Hk(n.i,e)||16==qf.Hk(n.i,e)||34==qf.Hk(n.i,e)||52==qf.Hk(n.i,e))){for(l[e]=!0,f=0;f<t.j[e];f++)if(i=t.i[e][f],s=t.k[e][f],g=t.n[e][f],0!=t.o[i]&&t.o[e]<g){for(l[i]=!0,Vf.Ji(o,zf.FIb(s)),d=0;d<t.j[i];d++)l[a=t.i[i][d]]||(l[a]=!0,r=t.k[i][d],u=t.n[i][d],t.o[i]+2==g+u&&(Vf.Ji(o,zf.FIb(r)),g>=u&&(t.o[a]<u?qf.Uu(t,a)&&qf.Ou(n,t,a,!0,!1,l,o):qf.Ou(n,t,a,!0,!0,l,o)),u>=g&&qf.Uu(t,e)&&qf.Ou(n,t,a,!1,!1,l,o),n.f[a]&&(5==qf.Hk(n.i,a)||6==qf.Hk(n.i,a)||7==qf.Hk(n.i,a)||8==qf.Hk(n.i,a)||16==qf.Hk(n.i,a)||34==qf.Hk(n.i,a)||52==qf.Hk(n.i,a))&&t.o[a]<u&&(g<=2&&u>=2&&qf.Uu(t,e)&&qf.Mu(n,t,s,r),g>=2&&u<=2&&qf.Uu(t,a)&&qf.Mu(n,t,r,s)),Vf.Vi(o,o.a.length-1)),l[a]=!1);Vf.Vi(o,o.a.length-1),l[i]=!1}l[e]=!1}},qf.Mu=function(n,t,e,i){var a;a=new qf.$u(n,t),qf.Zu(a,e,1==qf.Uk(t,e)?2:3),qf.Zu(a,i,2==qf.Uk(t,i)?1:2),n.g[e]=!0,n.g[i]=!0,Vf.OTb(n.e,a)&&Vf.zPb(n.d,a)},qf.Nu=function(n,t){Vf.OTb(n.e,t)&&Vf.zPb(n.d,t)},qf.Ou=function(n,t,e,i,a,s,r){var o,f,l,d,g,u,c,b,h,D,H;for(c=0;c<t.j[e];c++)if(!s[o=t.i[e][c]]&&(d=t.k[e][c],D=qf.Uk(t,d),i&&D>=2||!i&&D<=2)){for(s[o]=!0,r.add(zf.FIb(d)),b=0;b<t.j[o];b++)if(!s[f=t.i[o][b]]&&(g=t.k[o][b],H=qf.Uk(t,g),t.o[o]+2==D+H&&(i&&H<=2||!i&&H>=2))){if(s[f]=!0,r.add(zf.FIb(g)),!n.f[f]||5!=qf.Hk(n.i,f)&&6!=qf.Hk(n.i,f)&&7!=qf.Hk(n.i,f)&&8!=qf.Hk(n.i,f)&&16!=qf.Hk(n.i,f)&&34!=qf.Hk(n.i,f)&&52!=qf.Hk(n.i,f)||i&&!qf.Uu(t,f))qf.Ou(n,t,f,i,a,s,r);else{for(u=new qf.$u(n,t),h=0;h<r.a.length;h++)l=(Gf.nVb(h,r.a.length),r.a[h]).a,(h<2?i^!(1&h):a^!(1&h))?qf.Zu(u,l,1==qf.Uk(t,l)?2:3):qf.Zu(u,l,2==qf.Uk(t,l)?1:2),n.g[l]=!0;Vf.OTb(n.e,u)&&Vf.zPb(n.d,u)}Vf.Vi(r,r.a.length-1),s[f]=!1}Vf.Vi(r,r.a.length-1),s[o]=!1}return!1},qf.Pu=function(n){var t,e,i,a,s,r,o,f,l,d,g;for(n.b=$l(Qf.Mmb,G,6,n.i.f,15,1),o=$l(Qf.Mmb,G,6,n.i.f,15,1),i=$l(Qf.nyb,tn,6,n.i.g,16,1),g=0,e=0;e<n.i.g;e++)if(!i[e]&&n.g[e])for(++g,n.b[qf.Mk(n.i,0,e)]=g,n.b[qf.Mk(n.i,1,e)]=g,i[e]=!0,l=0;l<2;l++)for(t=qf.Mk(n.i,l,e),n.b[t]=g,r=0,f=0,o[0]=t;r<=f;){for(d=0;d<qf.Kn(n.i,o[r]);d++)!i[s=qf.Ln(n.i,o[r],d)]&&n.g[s]&&(i[s]=!0,a=qf.Jn(n.i,o[r],d),0==n.b[a]&&(n.b[a]=g,o[++f]=a));++r}n.j=g},qf.Qu=function(n){var t,e,i;for(n.n=$l(Qf.Mmb,G,6,n.j,15,1),n.k=$l(Qf.Mmb,G,6,n.j,15,1),n.o=$l(Qf.Mmb,G,6,n.j,15,1),t=0;t<n.i.f;t++)0!=n.b[t]&&(i=n.b[t]-1,null!=n.a&&(n.k[i]+=n.a[t]),null!=n.c&&(n.o[i]+=n.c[t]));for(e=0;e<n.i.g;e++)n.g[e]&&2==qf.Uk(n.i,e)&&(n.n[n.b[qf.Mk(n.i,0,e)]-1]+=2)},qf.Ru=function(n){var t,e,i,a;for(i=0;i<n.i.r;i++)for(a=0;a<2;a++)t=qf.Mk(n.i,a,i),e=qf.Mk(n.i,1-a,i),1==qf.Hk(n.i,t)&&qf.Ak(n.i,t)>1&&qf.Hk(n.i,e)>1&&0!=n.b[e]&&(2==qf.Ak(n.i,t)?(null==n.a&&(n.a=$l(Qf.Mmb,G,6,n.i.q,15,1)),++n.a[e]):(null==n.c&&(n.c=$l(Qf.Mmb,G,6,n.i.q,15,1)),++n.c[e]),qf.Gl(n.i,t));(null!=n.a||null!=n.c)&&qf.kk(n.i)},qf.Su=function(n){var t;for(n.e=new Vf.TTb,n.d=new Vf.LPb,qf.Nu(n,new qf.$u(n,n.i)),t=qf.ru(n.i);!Vf.DPb(n.d);)if(qf.Yu(Vf.FPb(n.d),t),qf.Lu(n,t),n.e.a.c>=qf.Ku){zf.aKb(),qf.Mf(new qf.gg(n.i));break}},qf.Tu=function(n){var t,e,i,a,s,r,o,f,l,d;if(1==n.e.a.c)return n.i;for(l=qf.ru(n.i),qf.zm(l,!0),qf.nu(l,7),a=0;a<l.g;a++)n.g[a]&&(l.H[a]=1,l.T=0,qf.wm(l,a,3,!0));for(e=0;e<l.f;e++)0!=n.b[e]&&qf.co(n.i,e)<4&&(qf.ln(l,e),l.u[e]&=yt,l.T&=7,qf._l(l,e,0,-1));for(o=$l(Qf.Mmb,G,6,n.j,15,1),f=$l(Qf.Mmb,G,6,n.j,15,1),i=new qf.gg(l).d,t=0;t<l.f;t++)0!=n.b[t]&&f[d=n.b[t]-1]<i[t]&&(f[d]=i[t],o[d]=t);for(s=0;s<n.j;s++)r=n.n[s]+"|"+n.k[s]+"|"+n.o[s],qf.Zl(l,o[s],r);return l},qf.Uu=function(n,t){return!(n.e[t]-qf.co(n,t)+qf.Zn(n,t)<=0)&&(!!qf.ul(n,t)||0==n.o[t])},qf.Vu=function(n){var t,e,i,a,s,r,o,f;qf.nu(n.i,1),o=n.i.f;do{--o}while(o>=0&&1==qf.Hk(n.i,o));for(t=0;t<o;t++)if(1==qf.Hk(n.i,t)){qf.Km(n.i,t,o);do{--o}while(1==qf.Hk(n.i,o))}if(o!=n.i.f-1){for(r=$l(Qf.nyb,tn,6,n.i.g,16,1),s=0;s<n.i.g;s++)e=qf.Mk(n.i,0,s),i=qf.Mk(n.i,1,s),(1==qf.Hk(n.i,e)||1==qf.Hk(n.i,i))&&(r[s]=!0);f=n.i.g;do{--f}while(f>=0&&r[f]);for(a=0;a<f;a++)if(r[a]){qf.Lm(n.i,a,f),r[a]=!1;do{--f}while(r[f])}}},qf.Wu=function(n){var t,e;for(this.i=qf.ru(n),qf.Vu(this),qf.nu(this.i,7),this.g=$l(Qf.nyb,tn,6,this.i.g,16,1),this.f=$l(Qf.nyb,tn,6,this.i.f,16,1),t=0;t<this.i.f;t++)e=qf.Ym(qf.Hk(this.i,t))[0],this.f[t]=qf.co(this.i,t)<e;qf.Su(this),qf.Pu(this),qf.Ru(this),qf.Qu(this)},Ol(277,1,{},qf.Wu),o.j=0,qf.Ku=we,Qf.Inb=hd(277),qf.Xu=function(n,t){return Hl.t7(n.a,t.a)},qf.Yu=function(n,t){var e,i;for(i=0;i<n.b.i.g;i++)n.b.g[i]&&(e=3&n.a[i>>4]>>2*(15&i),qf.xm(t,i,1==e?1:2==e?n.b.g[i]&&!qf.So(n.b.i,i)?386:2:3==e?4:32))},qf.Zu=function(n,t,e){var i,a;i=t>>4,a=2*(15&t),n.a[i]&=~(3<<a),n.a[i]|=e<<a},qf.$u=function(t,e){var i;for(this.b=t,this.a=$l(Qf.Mmb,G,6,(t.i.g+15)/16|0,15,1),i=0;i<t.i.g;i++)this.a[i>>4]|=n.Math.min(3,qf.Uk(e,i))<<2*(15&i)},Ol(184,1,{184:1,19:1},qf.$u),o.Eb=function(n){return qf.Xu(this,n)},Qf.Hnb=hd(184),qf.av=function(n){var t,e,i,a,s;if(-1==(e=zf.tJb(n,pd(38))))return n;for(a=0,s=new zf.NJb;-1!=e;)zf.MJb(s,(Gf.tVb(a,e,Gf.zVb(n).length),Gf.zVb(n).substr(a,e-a))),Gf.uVb(e+1,Gf.zVb(n).length),38==Gf.zVb(n).charCodeAt(e+1)?(s.a+="&",a=e+2):(Gf.uVb(e+1,Gf.zVb(n).length),t=Gf.zVb(n).charCodeAt(e+1),t-=t<65?48:t<97?65:97,Gf.uVb(e+2,Gf.zVb(n).length),i=Gf.zVb(n).charCodeAt(e+2),i-=i<65?48:i<97?65:97,zf.KJb(s,16*t+i&B),a=e+3),e=zf.uJb(n,pd(38),a);return zf.MJb(s,(Gf.uVb(a,Gf.zVb(n).length+1),Gf.zVb(n).substr(a))),s.a},qf.bv=function(n){var t,e;for(e=new zf.NJb,t=0;t<Gf.zVb(n).length;t++)switch(Gf.uVb(t,Gf.zVb(n).length),Gf.zVb(n).charCodeAt(t)){case 38:e.a+="&&";break;case 9:e.a+="&09";break;case 10:e.a+="&0A";break;case 32:e.a+="&20";break;default:zf.KJb(e,(Gf.uVb(t,Gf.zVb(n).length),Gf.zVb(n).charCodeAt(t)))}return e.a},qf.cv=function(n,t,e){n.e[0].a=t,n.e[0].b=e},qf.dv=function(n,t){try{n.a=og(t)}catch(n){if(!sd(n=cd(n),54))throw bd(n)}},qf.ev=function(n,t){try{n.b=zf.$Hb(t,Ot,I)}catch(n){if(!sd(n=cd(n),54))throw bd(n)}},qf.fv=function(n,t,e,i){n.c=t,n.a=e,n.b=i},qf.gv=function(n,t){try{n.e[0].a=og(t)}catch(n){if(!sd(n=cd(n),54))throw bd(n)}},qf.hv=function(n,t){try{n.e[0].b=og(t)}catch(n){if(!sd(n=cd(n),54))throw bd(n)}},qf.iv=function(){qf.kv.call(this,new al.EG)},qf.jv=function(n){var t,e,i,a;for(qf.iv.call(this),t=0;-1!=t&&-1!=(e=Gf.zVb(n).indexOf('="',t));)Gf.tVb(t+1,e,Gf.zVb(n).length),i=Gf.zVb(n).substr(t+1,e-(t+1)),a=-1==(t=Gf.zVb(n).indexOf('"',e+2))?(Gf.uVb(e+1,Gf.zVb(n).length+1),Gf.zVb(n).substr(e+1)):(Gf.tVb(e+1,t,Gf.zVb(n).length),Gf.zVb(n).substr(e+1,t-(e+1))),zf.pJb(i,jt)?this.c=qf.av(a):zf.pJb(i,"x")?qf.gv(this,a):zf.pJb(i,"y")?qf.hv(this,a):zf.pJb(i,"size")?qf.dv(this,a):zf.pJb(i,Ue)&&qf.ev(this,a)},qf.kv=function(n){this.c="",this.a=9,this.b=0,this.e=$l(Qf.bpb,w,33,1,0,1),this.e[0]=n},Ol(189,231,{231:1},qf.iv,qf.jv),o.Ab=function(){var n;return n=new qf.iv,qf.fv(n,this.c,this.a,this.b),qf.cv(n,this.e[0].a,this.e[0].b),n.d=this.d,n},o.Bb=function(){var n;return n=new zf.XJb,zf.UJb(n,' text="'+qf.bv(this.c)+'"'),zf.UJb(n,' x="'+this.e[0].a+'"'),zf.UJb(n,' y="'+this.e[0].b+'"'),9!=this.a&&zf.UJb(n,' size="'+this.a+'"'),0!=this.b&&zf.UJb(n,' style="'+this.b+'"'),n.a},o.Cb=function(){return jt},o.a=0,o.b=0,Qf.Jnb=hd(189),qf.ov=function(n){n.b=new Vf.bj,n.a=new Vf.bj},qf.pv=function(n,t){var e,i;return-1==(e=qf.hu(n,t))?-1:(i=n.b.a.length,Vf.Ji(n.b,t),Vf.Ii(n.a,e,new zf.tIb(i)),i)},qf.qv=function(){qf.ju.call(this),qf.ov(this)},Ol(390,117,Me,qf.qv),o.Pb=function(n){var t;return-1==(t=qf.iu(this,n))?-1:Vf.Oi(this.a,t).a},Qf.Knb=hd(390),vf.sv=function(t,e){var i,a,s,r,o,f,l,d,g,u,c,b,h,D,H,j,m,A,C,p,M,I,P,T,N,w,U,J,L,y,B,R,k;for(y=qf.mo(t.e),B=Vf.Oi(y.j,e).length,J=Vf.Oi(y.i,e),L=Vf.Oi(y.j,e),P=!0,H=1;H<B;H++)if(vf.Hv(t.b,L[H])!=vf.Hv(t.b,L[0])){P=!1;break}if(P)for(r=(B-2)*Je/B,j=0;j<B;j++)vf.xv(t,J[j],L[j],L[0==j?B-1:j-1],r);else{for(w=$l(Qf.Lmb,Et,6,B,15,1),s=0,m=0;m<B;m++)w[m]=0==qf.An(t.e,J[m])?1.9106119386631804:1==qf.An(t.e,J[m])?2.094499897810209:Je,s+=w[m];for(a=((B-2)*Je-s)/B,A=0;A<B;A++)w[A]+=a;for(g=$l(Qf.Lmb,Et,6,B,15,1),C=1;C<B;C++)g[C]=g[C-1]+Je-w[C];for(f=$l(Qf.Lmb,Et,6,B,15,1),o=0;o<100;o++){for(R=0,k=0,j=0;j<B;j++)R+=vf.Hv(t.b,L[j])*n.Math.sin(g[j]),k+=vf.Hv(t.b,L[j])*n.Math.cos(g[j]);for(b=qf.Zm(0,0,R,k),h=n.Math.sqrt(R*R+k*k),N=-1,T=0,p=0;p<B;p++)M=0==p?B-1:p-1,I=p+1==B?0:p+1,l=qf.$m(g[p],g[M]),d=qf.$m(g[I],g[p]),U=qf.$m(w[p],w[I]),f[p]=2*l-2*d+2*U,c=h*n.Math.cos(g[p]-Le-b)-ye*f[p],n.Math.abs(c)>n.Math.abs(T)&&(T=c,N=p);u=n.Math.exp(-5*o/100),g[N]+=u*T}for(D=0;D<B;D++)(i=g[M=0==D?B-1:D-1]+Je-g[D])>rn&&(i-=rn),vf.xv(t,J[D],L[M],L[D],i)}},vf.tv=function(n,t){var e,i,a,s,r,o,f,l,d;for(f=qf.mo(n.e),l=Vf.Oi(f.j,t).length,o=Vf.Oi(f.j,t),d=!1,a=0;a<l;a++)if(0==n.f[o[a]]){d=!0;break}if(d){for(e=(180*l-360)/l*.01745329238474369,r=Vf.Oi(f.i,t),s=0;s<l;s++)vf.xv(n,r[s],o[0==s?l-1:s-1],o[s],e);if(l<=4)for(i=0;i<l;i++)n.f[o[i]]+=l}},vf.uv=function(n,t,e,i){var a,s,r,o;for(s=-1,r=-1,o=0;o<qf.vn(n.e,t);o++)if((a=qf.Jn(n.e,t,o))==e||a==i){if(-1!=r){s=o;break}r=o}return n.a[t][s][r]},vf.vv=function(n,t,e,i){return e<i?n.a[t][i][e]:n.a[t][e][i]},vf.wv=function(n,t){var e,i,a,s,r,o,f;for(i=$l(Qf.nyb,tn,6,qf.Kn(n.e,t),16,1),f=0,a=0;a<qf.Kn(n.e,t);a++){for(o=0,r=-1,s=0;s<qf.Kn(n.e,t);s++)i[s]||(e=qf.Ln(n.e,t,s),o<n.f[e]&&(o=n.f[e],r=s));if(0==o)return f;f<<=8,f+=o,i[r]=!0}return f},vf.xv=function(n,t,e,i,a){var s,r,o,f;for(s=-1,r=-1,f=0;f<qf.vn(n.e,t);f++)if((o=qf.Ln(n.e,t,f))==e||o==i){if(-1!=s){r=f;break}s=f}0==n.a[t][r][s]&&(n.a[t][r][s]=a,n.d[t]+=a,++n.c[t])},vf.yv=function(n,t,e,i,a){var s,r,o,f,l,d;for(s=qf.vn(n.e,t),f=qf.Kn(n.e,t),l=1;l<s;l++)for(r=l<f?n.f[qf.Ln(n.e,t,l)]:0,d=0;d<l;d++)0==n.a[t][l][d]&&(o=d<f?n.f[qf.Ln(n.e,t,d)]:0,(r==e&&o==i||r==i&&o==e)&&(n.a[t][l][d]=a))},vf.zv=function(n,t){var e,i,a,s,r,o,f,l,d,g,u,c,b,h,D,H,m,A,C,p,M;for(this.b=t,this.e=n,this.a=$l(Qf.Lmb,j,691,this.e.f,0,3),a=0;a<this.e.f;a++)for(this.a[a]=$l(Qf.Lmb,{691:1,4:1,9:1,5:1,7:1},60,qf.vn(this.e,a),0,2),f=1;f<qf.vn(this.e,a);f++)this.a[a][f]=$l(Qf.Lmb,Et,6,f,15,1);for(this.c=$l(Qf.Mmb,G,6,this.e.f,15,1),this.d=$l(Qf.Lmb,Et,6,this.e.f,15,1),this.f=$l(Qf.Mmb,G,6,this.e.g,15,1),p=qf.mo(this.e),u=$l(Qf.nyb,tn,6,p.i.a.length,16,1),qf.Ar(p,u,$l(Qf.nyb,tn,6,p.i.a.length,16,1),$l(Qf.Mmb,G,6,p.i.a.length,15,1),!0),o=3;o<=7;o++)for(H=0;H<p.i.a.length;H++)(M=Vf.Oi(p.j,H).length)==o&&(u[H]?vf.sv(this,H):M<=4&&vf.tv(this,H));for(g=$l(Qf.nyb,tn,6,this.e.f,16,1),D=0;D<p.i.a.length;D++)if(u[D])for(A=0,C=(m=Vf.Oi(p.i,D)).length;A<C;++A)g[m[A]]=!0;for(s=ed(Wl(Qf.Mmb,1),G,6,15,[0,0,1,3,6,10,15,21]),i=0;i<this.e.f;i++)if((r=qf.vn(this.e,i))>4){for(f=1;f<r;f++)for(b=0;b<f;b++)this.a[i][f][b]=Le;this.c[i]=s[r]}else if(this.c[i]!=s[r])if(qf.Ro(this.e,i)&&(g[i]||qf.En(this.e,i)<=4&&qf.An(this.e,i)>0)){if(r>2){if(1==this.c[i])e=qf.Hk(this.e,i)<=14?(Be-this.d[i])/2:Re+.18000000715255737*(Re-this.d[i]);else if(e=Be-this.d[i],r>3){if(2==this.c[i]){for(c=$l(Qf.nyb,tn,6,qf.vn(this.e,i),16,1),l=1;l<r;l++)for(h=0;h<l;h++)0!=this.a[i][l][h]&&(c[l]=!c[l],c[h]=!c[h]);for(d=0;d<r;d++)if(c[d]){for(h=d+1;h<r;h++)if(c[h]){this.a[i][h][d]=e;break}break}}e=Le}for(f=1;f<r;f++)for(b=0;b<f;b++)0==this.a[i][f][b]&&(this.a[i][f][b]=e)}}else if(qf.Ro(this.e,i)&&qf.En(this.e,i)<=4)switch(vf.wv(this,i)){case 771:vf.yv(this,i,0,3,2.0653998851776123),vf.yv(this,i,0,0,1.9814722631346626);break;case 1028:vf.yv(this,i,0,4,1.9797999858856201),vf.yv(this,i,0,0,1.94691481878138);break;case 393987:vf.yv(this,i,0,3,ke),vf.yv(this,i,0,6,ke),vf.yv(this,i,3,3,1.7229016938441077);break;case 459779:vf.yv(this,i,0,3,xe),vf.yv(this,i,0,4,xe),vf.yv(this,i,0,7,xe),vf.yv(this,i,3,4,1.9322539839360076);break;case 525316:vf.yv(this,i,0,4,Ee),vf.yv(this,i,0,8,Ee),vf.yv(this,i,4,4,1.99944913298566);case 394758:vf.yv(this,i,0,6,2.526099920272827);break;case 460550:vf.yv(this,i,0,6,Fe),vf.yv(this,i,0,7,Fe);break;case 526087:vf.yv(this,i,0,7,Qe),vf.yv(this,i,0,8,Qe);break;case 526344:vf.yv(this,i,0,8,2.186300039291382);break;case 50529027:vf.yv(this,i,3,3,2.4189000129699707);break;case 67371779:vf.yv(this,i,3,4,2.2298998832702637);break;case 67372036:vf.yv(this,i,4,4,2.094399929046631);break;case 101057283:vf.yv(this,i,3,6,1.839926051241747),vf.yv(this,i,3,3,2.9061476191098734);break;case 117834755:vf.yv(this,i,3,4,2.812249087174905),vf.yv(this,i,3,7,1.7910569124592968),vf.yv(this,i,4,6,2.1224948975613245);break;case 134677507:vf.yv(this,i,3,4,2.642428360523752),vf.yv(this,i,3,8,2.027723514585844),vf.yv(this,i,4,7,2.251474717631936);break;case 117900035:vf.yv(this,i,3,7,2.109753935530918),vf.yv(this,i,3,3,3.1052897491356646);break;case 117900292:vf.yv(this,i,4,7,2.090729910747413),vf.yv(this,i,4,4,2.551671293386306);break;case 134743044:vf.yv(this,i,4,8,2.139250042271712),vf.yv(this,i,4,4,2.3520055858942612)}else for(e=qf.Hk(this.e,i)>10?ze:2==qf.An(this.e,i)?Je:qf.Io(this.e,i,!0)?Se:0==qf.An(this.e,i)?ze:Se,f=1;f<r;f++)for(b=0;b<f;b++)this.a[i][f][b]=e},Ol(536,1,{},vf.zv),Qf.Lnb=hd(536),vf.Gv=function(){vf.Gv=vl,vf.Ev=ed(Wl(Qf.nyb,1),tn,6,16,[!1,!1,!1,!1,!1,!0,!0,!0,!0,!1,!1,!1,!1,!1,!1,!0,!0])},vf.Hv=function(n,t){return n.a[t]},vf.Iv=function(n){var t,e;for(vf.Gv(),qf.nu(n,7),this.a=$l(Qf.Lmb,Et,6,n.r,15,1),this.b=$l(Qf.Lmb,Et,6,n.r,15,1),t=0;t<n.r;t++)-1==(e=vf.Lv(n,t))?(this.a[t]=vf.Mv(n,t),this.b[t]=vf.Nv(n,t)):(this.a[t]=-1==e?2.000499963760376:vf.Cv[e],this.b[t]=-1==e?1:vf.Dv[e])},vf.Jv=function(n,t){return t>=n.f?0:t<n.f&&qf.Or(n.p,t)&&6==n.C[t]&&0!=n.s[t]?1:n.o[t]},vf.Kv=function(n,t,e,i,a,s,r){var o,f;return((e?0:t?4+n:n)<<24)+((o=(i<vf.Ev.length&&vf.Ev[i]?s<<8:0)+i)<(f=(a<vf.Ev.length&&vf.Ev[a]?r<<8:0)+a)?(o<<12)+f:(f<<12)+o)},vf.Lv=function(n,t){var e,i,a,s;return e=n.D[0][t],i=n.D[1][t],a=n.C[e],s=n.C[i],vf.Pv(vf.Kv(qf.Uk(n,t),t<n.g&&qf.Pr(n.p,t),t<n.g&&(qf.Tr(n.p,t)||64==n.H[t]),a,s,vf.Jv(n,e),vf.Jv(n,i)))},vf.Mv=function(n,t){var e,i;return e=qf.Hk(n,n.D[0][t]),i=qf.Hk(n,n.D[1][t]),(e<(vf.mx(),vf.kx).length?vf.kx[e]:e<vf.lx.length?Xe*vf.lx[e]:Ge)+(i<vf.kx.length?vf.kx[i]:i<vf.lx.length?Xe*vf.lx[i]:Ge)},vf.Nv=function(n,t){var e,i;return e=qf.Hk(n,n.D[0][t]),i=qf.Hk(n,n.D[1][t]),(e<(vf.mx(),vf.kx).length?Ye:.125)+(i<vf.kx.length?Ye:.125)},vf.Ov=function(){var n,t,e,i,a,s;if(!vf.Fv){for(e=(n=zf.AJb("2312\n4099\t2.403\t0.282\t466\n4100\t1.407\t0.2\t28\n4103\t1.561\t0.023\t5\n4104\t1.42\t0.092\t491\n4105\t1.313\t0.149\t32\n4107\t2.677\t0.401\t190\n4108\t2.118\t0.244\t325\n4109\t1.978\t0.26\t968\n4113\t1.819\t0.033\t4\n4115\t3.194\t0.482\t381\n4116\t2.771\t0.32\t198\n4117\t2.398\t0.235\t145\n4118\t2.317\t0.22\t208\n4119\t2.034\t0.212\t34\n4120\t2.033\t0.286\t103\n4121\t1.959\t0.264\t122\n4122\t1.918\t0.267\t664\n4123\t1.893\t0.257\t185\n4124\t1.877\t0.218\t259\n4125\t2.05\t0.257\t556\n4126\t2.012\t0.239\t129\n4127\t1.979\t0.292\t196\n4133\t3.305\t0.429\t34\n4134\t2.593\t0.367\t83\n4135\t2.74\t0.174\t706\n4136\t2.462\t0.196\t611\n4137\t2.207\t0.264\t78\n4138\t2.16\t0.225\t359\n4140\t2.004\t0.188\t2204\n4141\t1.916\t0.256\t610\n4142\t1.95\t0.234\t126\n4143\t2.3\t0.213\t81\n4144\t2.187\t0.116\t6\n4145\t2.103\t0.153\t21\n4146\t2.031\t0.308\t83\n4147\t1.752\t0.443\t21\n4151\t3.49\t0.4\t83\n4152\t3.017\t0.331\t40\n4153\t2.932\t0.276\t176\n4154\t2.39\t0.34\t24\n4155\t3.124\t0.377\t16\n4156\t2.907\t0.232\t198\n4158\t2.857\t0.237\t142\n4159\t2.687\t0.244\t49\n4160\t2.787\t0.359\t29\n4161\t2.785\t0.306\t37\n4162\t2.623\t0.298\t175\n4163\t2.812\t0.154\t70\n4164\t2.745\t0.281\t100\n4165\t2.719\t0.184\t37\n4166\t2.683\t0.361\t231\n4167\t2.655\t0.253\t198\n4168\t2.546\t0.208\t37\n4169\t2.259\t0.231\t190\n4170\t2.043\t0.289\t251\n4171\t2.001\t0.221\t391\n4172\t1.984\t0.164\t885\n4173\t1.904\t0.228\t1074\n4174\t2.036\t0.224\t250\n4175\t1.955\t0.184\t6\n4176\t2.35\t0.15\t12\n4177\t2.367\t0.216\t7\n4178\t2.47\t0.186\t11\n4179\t0.95\t-1.0\t1\n4186\t2.88\t0.309\t39\n4188\t2.804\t0.289\t136\n4189\t2.172\t0.082\t12\n4190\t2.321\t0.0\t2\n4359\t1.503\t0.106\t24\n4360\t1.425\t0.052\t40\n12291\t2.861\t0.27\t1069\n12292\t2.773\t0.086\t4\n12293\t2.507\t0.251\t27\n12294\t2.769\t0.373\t370\n12299\t3.1\t0.221\t116\n12300\t2.844\t0.146\t9\n12301\t3.636\t0.002\t3\n12302\t2.779\t0.318\t189\n12307\t3.639\t0.518\t25\n12308\t3.205\t0.245\t16\n12317\t3.036\t0.064\t4\n12318\t2.88\t-1.0\t1\n12319\t2.615\t0.864\t3\n12320\t2.857\t0.129\t247\n12325\t3.557\t0.41\t18\n12326\t3.273\t0.208\t23\n12330\t3.496\t0.025\t2\n12333\t3.012\t0.276\t2\n12334\t2.679\t0.0\t2\n12338\t2.886\t0.196\t80\n12339\t2.871\t0.221\t18\n12343\t3.628\t0.266\t9\n12344\t3.37\t0.145\t35\n12346\t2.859\t0.0\t4\n12352\t2.722\t0.017\t4\n12354\t3.317\t0.016\t4\n12355\t2.714\t0.006\t2\n12357\t2.703\t0.005\t2\n12365\t2.615\t-1.0\t1\n12367\t2.729\t0.0\t2\n12368\t2.841\t0.0\t2\n12369\t2.889\t0.082\t5\n12370\t2.913\t0.126\t64\n12549\t3.003\t0.175\t18\n12550\t2.797\t0.21\t1156\n12805\t2.63\t0.0\t2\n12806\t2.939\t0.243\t85\n16388\t2.29\t0.104\t57\n16389\t2.022\t0.097\t6\n16390\t2.097\t0.127\t21\n16391\t1.771\t0.395\t281\n16392\t1.648\t0.242\t634\n16393\t1.567\t0.555\t264\n16395\t2.926\t0.104\t14\n16397\t2.368\t-1.0\t1\n16398\t3.269\t-1.0\t1\n16399\t2.211\t0.15\t6\n16400\t2.1\t-1.0\t1\n16401\t2.065\t0.622\t37\n16403\t3.355\t0.087\t11\n16404\t2.9\t0.136\t2\n16416\t2.399\t0.154\t3\n16417\t2.06\t0.0\t2\n16418\t2.195\t-1.0\t1\n16419\t2.167\t0.95\t16\n16421\t3.378\t-1.0\t1\n16422\t2.886\t0.031\t2\n16429\t2.375\t0.124\t6\n16435\t2.635\t-1.0\t1\n16436\t2.399\t-1.0\t1\n16437\t2.417\t0.96\t23\n16439\t3.716\t0.078\t2\n16442\t3.052\t0.0\t4\n16463\t2.64\t-1.0\t1\n16466\t2.23\t-1.0\t1\n16474\t3.061\t0.0\t4\n16476\t3.017\t0.004\t8\n16645\t1.954\t-1.0\t1\n16646\t2.276\t0.281\t56\n16647\t1.966\t0.14\t51\n16648\t1.843\t0.124\t41\n16902\t1.739\t0.003\t2\n16903\t2.003\t-1.0\t1\n20491\t2.681\t-1.0\t1\n20492\t2.402\t0.287\t12\n20493\t2.373\t0.17\t6\n20499\t3.054\t0.395\t11\n20500\t3.076\t0.081\t2\n20501\t2.3\t1.168\t20\n20502\t2.221\t0.057\t3\n20503\t1.964\t-1.0\t1\n20504\t2.515\t0.236\t21\n20505\t1.97\t0.231\t70\n20506\t2.056\t0.352\t138\n20507\t2.553\t0.302\t81\n20508\t2.489\t0.321\t24\n20509\t2.215\t0.363\t36\n20510\t2.786\t0.026\t6\n20511\t2.418\t0.106\t10\n20517\t3.193\t0.063\t3\n20519\t2.598\t0.187\t9\n20520\t2.376\t0.309\t9\n20522\t2.708\t0.265\t154\n20524\t2.526\t0.319\t123\n20525\t2.262\t0.289\t122\n20526\t2.502\t0.287\t18\n20527\t2.365\t0.284\t11\n20528\t2.966\t0.038\t6\n20529\t2.584\t0.061\t7\n20530\t2.771\t0.387\t5\n20531\t1.29\t0.001\t12\n20535\t3.368\t0.154\t5\n20536\t3.023\t0.074\t6\n20537\t2.913\t0.0\t2\n20538\t3.021\t0.331\t2\n20540\t2.651\t0.201\t5\n20543\t2.735\t0.344\t5\n20546\t2.531\t0.277\t7\n20549\t3.267\t-1.0\t1\n20550\t2.329\t0.34\t7\n20552\t2.499\t0.02\t6\n20553\t2.703\t0.218\t20\n20554\t2.693\t0.292\t46\n20555\t2.639\t0.27\t40\n20556\t2.066\t0.059\t39\n20557\t2.599\t0.324\t183\n20558\t2.048\t0.149\t134\n20559\t2.327\t0.386\t34\n20560\t2.179\t-1.0\t1\n20561\t2.619\t-1.0\t1\n20562\t2.967\t-1.0\t1\n20570\t2.665\t0.007\t2\n20572\t2.63\t0.19\t9\n20742\t1.87\t0.155\t40\n24587\t3.525\t0.393\t28\n24588\t2.763\t0.313\t380\n24589\t2.462\t0.308\t5373\n24595\t4.077\t0.356\t19\n24596\t3.17\t0.362\t45\n24597\t2.829\t0.525\t432\n24598\t2.656\t0.164\t627\n24599\t2.654\t0.158\t57\n24600\t2.57\t0.26\t309\n24601\t2.625\t0.288\t208\n24602\t2.45\t0.223\t1004\n24603\t2.182\t0.257\t1071\n24604\t2.355\t0.185\t1159\n24605\t2.384\t0.162\t130\n24606\t2.479\t0.188\t1375\n24607\t2.547\t0.23\t805\n24613\t3.789\t0.188\t2\n24614\t3.484\t0.291\t8\n24615\t3.089\t0.34\t499\n24616\t2.809\t0.177\t912\n24617\t2.665\t0.147\t106\n24618\t2.632\t0.3\t598\n24620\t2.419\t0.207\t1127\n24621\t2.466\t0.217\t582\n24622\t2.456\t0.168\t1672\n24623\t2.573\t0.135\t12\n24624\t2.753\t0.503\t34\n24625\t2.695\t0.487\t478\n24626\t2.644\t0.444\t4321\n24627\t2.655\t0.961\t518\n24631\t3.712\t0.709\t3\n24632\t3.745\t0.575\t6\n24633\t3.382\t0.306\t128\n24634\t3.417\t0.336\t41\n24635\t3.236\t0.278\t27\n24636\t3.365\t0.272\t72\n24638\t3.236\t0.316\t52\n24639\t3.097\t0.0\t2\n24640\t2.718\t0.258\t39\n24641\t3.353\t0.103\t6\n24642\t3.087\t0.178\t51\n24643\t2.988\t0.348\t31\n24644\t2.995\t0.182\t58\n24645\t3.221\t0.798\t58\n24646\t3.104\t0.353\t86\n24647\t3.019\t0.515\t320\n24648\t2.735\t0.176\t341\n24649\t2.703\t0.204\t299\n24650\t2.595\t0.331\t829\n24651\t2.536\t0.58\t227\n24652\t2.472\t0.25\t206\n24653\t2.534\t0.168\t933\n24654\t2.491\t0.326\t1889\n24655\t2.445\t0.168\t254\n24656\t2.51\t0.162\t95\n24657\t3.004\t0.801\t27\n24658\t2.961\t0.516\t71\n24659\t3.105\t0.444\t106\n24666\t3.114\t0.326\t123\n24668\t3.098\t0.303\t230\n28685\t2.353\t0.307\t3006\n28693\t2.684\t0.241\t703\n28694\t2.452\t0.242\t3992\n28695\t2.409\t0.319\t1209\n28696\t2.464\t0.534\t2219\n28697\t2.577\t0.289\t2590\n28698\t2.456\t0.2\t6911\n28699\t2.41\t0.36\t7053\n28700\t2.487\t0.231\t7446\n28701\t2.406\t0.194\t9772\n28702\t2.479\t0.227\t5502\n28703\t2.471\t0.309\t929\n28711\t2.921\t0.239\t1714\n28712\t2.679\t0.232\t2798\n28713\t2.442\t0.272\t911\n28714\t2.445\t0.293\t2412\n28716\t2.475\t0.298\t2904\n28717\t2.428\t0.335\t1207\n28718\t2.458\t0.222\t3289\n28719\t2.487\t0.247\t1033\n28720\t2.81\t0.231\t768\n28721\t2.785\t0.35\t616\n28722\t2.606\t0.37\t1703\n28723\t2.599\t0.29\t531\n28729\t3.125\t0.329\t626\n28730\t3.082\t0.337\t728\n28731\t3.179\t0.249\t153\n28732\t3.022\t0.208\t458\n28734\t3.032\t0.245\t890\n28735\t3.194\t0.258\t616\n28736\t3.148\t0.29\t455\n28737\t3.124\t0.266\t301\n28738\t3.028\t0.263\t602\n28739\t2.987\t0.306\t159\n28740\t2.919\t0.28\t496\n28741\t3.182\t0.365\t119\n28742\t2.892\t0.229\t1179\n28743\t2.821\t0.212\t549\n28744\t2.607\t0.225\t683\n28745\t2.503\t0.227\t1194\n28746\t2.395\t0.326\t1012\n28747\t2.447\t0.267\t941\n28748\t2.383\t0.233\t326\n28749\t2.511\t0.279\t970\n28750\t2.457\t0.24\t1884\n28751\t2.393\t0.172\t533\n28752\t2.849\t0.285\t194\n28753\t2.973\t0.272\t62\n28754\t2.876\t0.236\t326\n28755\t2.753\t0.232\t424\n28762\t3.088\t0.249\t588\n28764\t2.972\t0.34\t2780\n28765\t3.016\t0.335\t10\n28766\t3.297\t0.204\t7\n32781\t2.145\t0.448\t7124\n32789\t2.625\t0.845\t799\n32790\t2.338\t0.282\t13095\n32791\t2.352\t0.77\t18035\n32792\t2.299\t0.427\t5228\n32793\t2.387\t0.292\t15567\n32794\t2.358\t0.225\t12153\n32795\t2.38\t0.29\t13623\n32796\t2.421\t0.301\t14996\n32797\t2.272\t0.223\t19019\n32798\t2.378\t0.357\t12982\n32799\t2.317\t0.208\t831\n32807\t2.796\t0.315\t3153\n32808\t2.497\t0.249\t4631\n32809\t2.375\t0.365\t1523\n32810\t2.347\t0.467\t31965\n32812\t2.419\t0.158\t3311\n32813\t2.436\t0.193\t2109\n32814\t2.4\t0.154\t2649\n32815\t2.661\t0.256\t865\n32816\t2.694\t0.218\t2847\n32817\t2.616\t0.276\t949\n32818\t2.579\t0.438\t4702\n32819\t2.309\t0.553\t1993\n32825\t2.994\t0.343\t2113\n32826\t2.856\t0.3\t2621\n32827\t2.93\t0.228\t1218\n32828\t2.905\t0.207\t2518\n32830\t2.869\t0.237\t2353\n32831\t2.827\t0.209\t3697\n32832\t2.834\t0.197\t5222\n32833\t2.78\t0.177\t4383\n32834\t2.738\t0.205\t8482\n32835\t2.747\t0.193\t1707\n32836\t2.742\t0.193\t2196\n32837\t2.798\t0.21\t502\n32838\t2.734\t0.235\t2716\n32839\t2.767\t0.212\t885\n32840\t2.498\t0.29\t774\n32841\t2.373\t0.261\t1221\n32842\t2.285\t0.417\t9618\n32843\t2.218\t0.348\t3304\n32844\t2.411\t0.2\t303\n32845\t2.462\t0.304\t1297\n32846\t2.393\t0.203\t1953\n32847\t2.305\t0.24\t286\n32848\t2.736\t0.309\t162\n32849\t2.822\t0.336\t202\n32850\t2.624\t0.233\t1404\n32851\t2.579\t0.268\t1906\n32858\t2.759\t0.291\t759\n32860\t2.611\t0.412\t7083\n32861\t2.503\t0.425\t287\n32862\t2.802\t0.399\t255\n32863\t2.837\t0.483\t20\n32864\t3.097\t0.448\t5\n32865\t2.94\t0.02\t3\n32866\t2.916\t0.021\t3\n36877\t1.811\t0.461\t1163\n36885\t2.022\t0.295\t129\n36886\t2.262\t0.492\t1106\n36887\t2.576\t0.889\t536\n36888\t1.937\t0.267\t474\n36889\t2.093\t0.73\t296\n36890\t1.929\t0.743\t373\n36891\t2.283\t0.257\t113\n36892\t2.221\t0.196\t116\n36893\t2.345\t0.817\t110\n36894\t2.065\t0.336\t75\n36895\t2.412\t0.358\t76\n36903\t2.125\t0.259\t44\n36904\t2.154\t1.055\t667\n36905\t2.12\t0.459\t502\n36906\t2.031\t0.453\t512\n36908\t2.395\t0.388\t43\n36909\t2.339\t0.338\t54\n36910\t2.361\t0.307\t101\n36911\t2.57\t0.191\t9\n36912\t2.427\t0.207\t26\n36913\t2.059\t1.008\t121\n36914\t2.126\t0.626\t419\n36915\t2.193\t0.262\t8674\n36921\t2.731\t0.286\t10\n36922\t2.995\t1.207\t51\n36923\t2.406\t0.044\t8\n36924\t2.742\t0.246\t33\n36926\t2.795\t0.182\t52\n36927\t2.799\t0.303\t24\n36928\t2.454\t0.018\t4\n36929\t1.96\t0.0\t6\n36930\t2.434\t0.192\t19\n36931\t2.857\t-1.0\t1\n36932\t2.747\t0.211\t25\n36934\t2.687\t0.139\t19\n36935\t2.806\t0.003\t4\n36936\t2.107\t0.444\t90\n36937\t2.149\t0.225\t250\n36938\t1.882\t0.247\t232\n36939\t2.0\t0.93\t274\n36940\t2.276\t0.144\t56\n36941\t2.293\t1.188\t69\n36942\t2.356\t0.364\t53\n36943\t1.893\t0.555\t149\n36944\t2.373\t0.0\t2\n36945\t2.015\t0.261\t45\n36946\t2.333\t0.203\t37\n36947\t2.152\t0.196\t94\n36954\t2.666\t0.268\t30\n36955\t2.205\t0.007\t16\n36956\t2.285\t0.379\t153\n36957\t2.26\t0.017\t10\n45067\t3.369\t0.477\t389\n45068\t3.242\t-1.0\t1\n45069\t3.524\t0.425\t2\n45070\t3.558\t0.0\t2\n45075\t3.592\t0.346\t36\n45076\t3.383\t0.133\t22\n45081\t3.221\t0.182\t3\n45082\t2.923\t0.336\t4\n45083\t3.382\t-1.0\t1\n45084\t2.961\t0.097\t3\n45087\t3.136\t-1.0\t1\n45088\t3.161\t0.174\t9\n45093\t3.645\t0.249\t17\n45094\t3.529\t0.167\t10\n45101\t3.618\t-1.0\t1\n45106\t3.243\t0.311\t72\n45107\t3.33\t0.219\t17\n45111\t3.704\t0.248\t22\n45112\t3.585\t0.155\t9\n45134\t3.136\t-1.0\t1\n45136\t3.234\t0.09\t7\n45137\t3.405\t0.105\t12\n45138\t3.441\t0.118\t15\n45139\t3.281\t0.068\t7\n45317\t3.245\t0.017\t2\n45318\t3.261\t0.178\t294\n45573\t2.685\t-1.0\t1\n45574\t3.187\t0.261\t35\n49164\t3.052\t0.123\t490\n49165\t3.401\t-1.0\t1\n49166\t2.887\t0.569\t39\n49171\t4.275\t0.055\t2\n49172\t3.412\t0.019\t8\n49177\t3.408\t-1.0\t1\n49178\t3.072\t0.063\t8\n49181\t3.334\t0.086\t3\n49182\t3.217\t0.061\t2\n49183\t2.836\t0.772\t13\n49184\t2.807\t0.438\t17\n49190\t3.648\t0.307\t28\n49191\t2.187\t0.0\t6\n49194\t2.466\t0.0\t2\n49197\t2.818\t0.099\t91\n49202\t2.927\t0.036\t9\n49203\t2.862\t0.432\t19\n49207\t3.807\t0.0\t2\n49208\t3.659\t0.045\t20\n49209\t3.53\t0.075\t16\n49210\t3.447\t0.003\t12\n49211\t3.506\t0.0\t3\n49212\t3.54\t0.0\t3\n49214\t3.463\t0.0\t3\n49215\t3.48\t0.014\t8\n49216\t3.364\t0.0\t3\n49221\t3.144\t0.0\t12\n49229\t2.7\t0.086\t48\n49230\t3.087\t0.019\t2\n49233\t3.145\t0.004\t2\n49413\t2.826\t0.154\t5\n49414\t2.811\t0.216\t411\n49670\t2.681\t0.238\t49\n53261\t3.147\t0.471\t69\n53262\t3.263\t0.176\t31\n53263\t3.143\t0.346\t218\n53264\t2.983\t0.385\t264\n53265\t2.601\t0.322\t2017\n53268\t3.669\t-1.0\t1\n53272\t2.557\t-1.0\t1\n53273\t2.309\t-1.0\t1\n53274\t2.908\t0.179\t18\n53275\t2.828\t0.234\t10\n53276\t2.655\t0.245\t6\n53277\t2.352\t0.06\t13\n53278\t3.3\t0.187\t3\n53279\t3.414\t0.37\t3\n53280\t2.499\t0.185\t12\n53281\t2.448\t0.051\t41\n53282\t2.875\t0.469\t72\n53283\t2.741\t0.288\t381\n53286\t3.495\t0.045\t15\n53292\t2.999\t-1.0\t1\n53293\t3.023\t0.354\t19\n53294\t2.951\t0.089\t21\n53295\t3.08\t-1.0\t1\n53297\t3.715\t-1.0\t1\n53298\t3.418\t0.0\t2\n53299\t2.655\t0.502\t19\n53300\t2.915\t0.495\t30\n53301\t3.049\t0.382\t137\n53303\t2.804\t1.394\t2\n53304\t3.582\t0.06\t4\n53305\t3.584\t0.347\t3\n53308\t3.56\t0.086\t2\n53322\t3.218\t0.048\t2\n53325\t3.468\t0.243\t2\n53326\t3.202\t0.139\t4\n53331\t3.74\t0.255\t4\n53340\t4.01\t0.006\t2\n53509\t2.605\t0.31\t8\n53510\t2.407\t0.249\t1700\n53511\t2.374\t0.163\t1982\n53512\t2.216\t0.23\t533\n53519\t2.935\t0.196\t5\n53520\t2.843\t0.186\t40\n53766\t2.468\t0.199\t96\n53767\t2.448\t0.135\t44\n53768\t1.978\t0.199\t4\n57363\t4.548\t0.464\t19\n57364\t3.083\t0.417\t13\n57366\t3.671\t0.019\t4\n57367\t3.246\t0.035\t4\n57368\t2.795\t0.193\t8\n57369\t2.811\t0.292\t27\n57370\t2.847\t0.192\t233\n57371\t2.715\t0.262\t77\n57372\t2.749\t0.228\t147\n57373\t2.884\t0.306\t43\n57374\t3.288\t0.273\t42\n57375\t3.561\t0.36\t4\n57382\t3.347\t0.097\t2\n57384\t3.775\t0.176\t18\n57385\t3.436\t0.115\t26\n57386\t3.224\t0.255\t49\n57388\t2.956\t0.338\t151\n57389\t2.78\t0.227\t106\n57390\t2.921\t0.275\t97\n57391\t3.357\t0.302\t20\n57393\t3.19\t0.085\t14\n57394\t3.662\t0.527\t210\n57395\t3.917\t0.191\t58\n57399\t3.91\t0.0\t4\n57400\t3.327\t0.062\t5\n57402\t3.01\t0.585\t8\n57406\t4.511\t0.25\t17\n57407\t4.503\t0.08\t6\n57409\t3.926\t0.003\t2\n57411\t3.905\t0.012\t2\n57414\t4.362\t0.205\t19\n57416\t3.87\t0.205\t13\n57417\t3.437\t0.24\t5\n57418\t3.085\t0.21\t66\n57419\t2.96\t0.12\t14\n57420\t3.028\t0.125\t7\n57421\t2.797\t0.286\t150\n57422\t2.978\t0.215\t175\n57423\t2.761\t0.465\t12\n57424\t3.53\t0.211\t22\n57426\t3.874\t0.316\t17\n57427\t4.031\t0.321\t9\n61461\t3.38\t0.299\t100\n61462\t3.21\t0.369\t276\n61463\t3.131\t0.207\t110\n61464\t2.873\t0.244\t730\n61465\t2.696\t0.32\t774\n61466\t2.697\t0.243\t4802\n61467\t2.679\t0.235\t3056\n61468\t2.676\t0.196\t4702\n61469\t2.64\t0.179\t5253\n61470\t2.912\t0.244\t119\n61471\t3.023\t0.242\t152\n61479\t3.617\t0.27\t57\n61480\t3.41\t0.235\t240\n61481\t3.284\t0.297\t129\n61482\t3.002\t0.261\t2058\n61484\t2.758\t0.203\t6616\n61485\t2.714\t0.205\t4052\n61486\t2.713\t0.193\t6710\n61487\t2.863\t0.16\t1964\n61488\t3.199\t0.271\t42\n61489\t3.285\t0.255\t93\n61490\t3.243\t0.31\t221\n61491\t3.183\t0.277\t77\n61497\t3.201\t0.305\t27\n61498\t2.934\t0.476\t9\n61500\t3.451\t0.1\t14\n61502\t3.794\t0.117\t26\n61506\t3.579\t0.083\t13\n61507\t3.584\t0.109\t8\n61508\t3.774\t0.0\t2\n61510\t3.577\t0.217\t22\n61511\t3.739\t0.336\t7\n61512\t3.408\t0.222\t72\n61513\t3.244\t0.257\t147\n61514\t3.003\t0.256\t1665\n61515\t2.906\t0.239\t1623\n61516\t2.798\t0.241\t1057\n61517\t2.754\t0.215\t2863\n61518\t2.714\t0.201\t6668\n61519\t2.668\t0.172\t4216\n61520\t2.879\t0.203\t76\n61521\t3.471\t0.204\t33\n61522\t3.487\t0.164\t39\n61523\t3.141\t0.234\t30\n61530\t3.726\t0.298\t60\n61532\t3.891\t0.328\t80\n65557\t3.412\t0.368\t35\n65558\t2.901\t0.267\t387\n65559\t2.852\t0.348\t489\n65560\t2.881\t0.289\t268\n65561\t2.726\t0.281\t883\n65562\t2.718\t0.226\t7921\n65563\t2.724\t0.272\t1489\n65564\t2.606\t0.234\t5975\n65565\t2.755\t0.225\t5038\n65566\t2.788\t0.225\t1360\n65567\t2.767\t0.214\t227\n65575\t3.418\t0.184\t159\n65576\t3.376\t0.277\t123\n65577\t2.954\t0.528\t373\n65578\t2.911\t0.288\t3355\n65580\t2.816\t0.192\t1907\n65581\t2.839\t0.173\t765\n65582\t2.775\t0.192\t2485\n65583\t3.093\t0.232\t4438\n65584\t3.087\t0.238\t609\n65585\t3.111\t0.393\t484\n65586\t2.949\t0.477\t1247\n65587\t2.995\t0.415\t696\n65593\t3.611\t0.276\t65\n65594\t3.5\t0.164\t59\n65595\t3.551\t0.145\t18\n65596\t3.459\t0.169\t45\n65598\t3.453\t0.18\t175\n65599\t3.683\t0.232\t44\n65600\t3.412\t0.05\t10\n65601\t3.114\t0.282\t6\n65602\t3.516\t0.333\t73\n65603\t3.018\t0.572\t5\n65604\t3.488\t0.196\t81\n65605\t3.266\t0.272\t10\n65606\t3.254\t0.188\t179\n65607\t3.336\t0.194\t34\n65608\t3.554\t0.326\t21\n65609\t2.461\t0.31\t329\n65610\t2.919\t0.288\t2082\n65611\t2.8\t0.267\t1996\n65612\t2.475\t0.252\t240\n65613\t2.833\t0.153\t655\n65614\t2.73\t0.196\t2208\n65615\t2.776\t0.277\t3697\n65616\t2.944\t0.23\t538\n65617\t3.031\t0.277\t17\n65618\t3.147\t0.26\t222\n65619\t3.099\t0.284\t350\n65626\t3.319\t0.35\t170\n65628\t3.382\t0.265\t290\n65629\t3.399\t0.077\t8\n65630\t2.931\t0.387\t17\n65631\t3.438\t0.046\t3\n65632\t3.441\t0.047\t3\n69653\t3.008\t0.308\t233\n69654\t2.799\t0.246\t2597\n69655\t2.789\t0.215\t490\n69656\t2.8\t0.199\t1394\n69657\t2.875\t0.267\t1182\n69658\t2.712\t0.238\t3474\n69659\t2.694\t0.227\t2713\n69660\t2.758\t0.28\t2082\n69661\t2.701\t0.25\t5780\n69662\t2.642\t0.425\t3822\n69663\t2.661\t0.254\t1485\n69671\t3.218\t0.274\t409\n69672\t2.991\t0.248\t1900\n69673\t2.903\t0.356\t1449\n69674\t2.907\t0.475\t2267\n69676\t2.885\t0.203\t5377\n69677\t2.863\t0.235\t2604\n69678\t2.776\t0.213\t6900\n69679\t3.032\t0.245\t617\n69680\t2.974\t0.221\t1026\n69681\t2.957\t0.377\t932\n69682\t2.928\t0.391\t2452\n69683\t2.872\t0.46\t1745\n69689\t3.393\t0.345\t120\n69690\t3.542\t0.471\t133\n69691\t3.384\t0.328\t54\n69692\t3.319\t0.289\t122\n69694\t3.354\t0.248\t151\n69695\t3.179\t0.349\t113\n69696\t3.251\t0.372\t116\n69697\t3.069\t0.3\t85\n69698\t3.114\t0.336\t295\n69699\t3.273\t0.344\t35\n69700\t3.214\t0.336\t160\n69701\t2.947\t0.43\t25\n69702\t3.224\t0.207\t183\n69703\t3.182\t0.198\t73\n69704\t2.972\t0.302\t357\n69705\t2.911\t0.327\t1000\n69706\t2.885\t0.369\t1787\n69707\t2.801\t0.257\t2221\n69708\t2.851\t0.255\t681\n69709\t2.879\t0.222\t2186\n69710\t2.757\t0.265\t4336\n69711\t2.675\t0.201\t2687\n69712\t2.804\t0.27\t1229\n69713\t2.554\t0.473\t192\n69714\t3.224\t0.457\t625\n69715\t3.107\t0.371\t1402\n69722\t3.417\t0.306\t157\n69723\t2.64\t0.0\t4\n69724\t3.21\t0.343\t893\n69725\t3.181\t0.284\t122\n69726\t3.088\t0.296\t154\n69727\t2.915\t-1.0\t1\n69728\t2.915\t-1.0\t1\n69729\t2.465\t0.0\t6\n77843\t3.904\t0.444\t476\n77844\t3.931\t0.219\t13\n77847\t3.213\t0.001\t2\n77848\t3.318\t0.114\t5\n77849\t3.574\t0.313\t3\n77850\t3.205\t-1.0\t1\n77851\t3.463\t0.411\t4\n77852\t3.491\t0.534\t2\n77853\t3.822\t0.039\t3\n77854\t3.511\t0.765\t6\n77856\t3.502\t0.647\t78\n77861\t3.9\t0.078\t12\n77862\t3.806\t0.091\t8\n77864\t3.807\t-1.0\t1\n77865\t3.535\t0.137\t7\n77870\t3.386\t0.218\t17\n77871\t3.245\t0.006\t2\n77874\t3.754\t0.595\t67\n77875\t3.655\t0.42\t25\n77879\t3.899\t0.365\t31\n77880\t4.729\t0.676\t2\n77898\t4.496\t0.606\t3\n77902\t3.48\t0.0\t4\n77905\t3.736\t0.08\t11\n77906\t3.724\t0.099\t26\n77907\t3.562\t0.045\t4\n77917\t4.592\t-1.0\t1\n78085\t3.76\t0.113\t8\n78086\t3.713\t0.29\t1287\n78342\t3.557\t0.28\t73\n81940\t3.661\t0.289\t176\n81943\t3.019\t-1.0\t1\n81944\t2.85\t-1.0\t1\n81945\t3.324\t0.0\t2\n81951\t3.151\t-1.0\t1\n81952\t3.185\t0.116\t25\n81957\t3.75\t0.247\t3\n81958\t3.579\t0.106\t3\n81967\t3.517\t0.128\t5\n81969\t3.26\t0.128\t3\n81970\t3.346\t0.13\t71\n81971\t3.246\t0.132\t128\n81975\t3.895\t0.219\t5\n81976\t3.719\t0.202\t10\n81997\t3.133\t0.007\t2\n81999\t3.088\t0.086\t20\n82000\t3.26\t0.098\t4\n82001\t3.332\t-1.0\t1\n82002\t3.427\t0.083\t10\n82003\t3.25\t0.171\t45\n82012\t3.805\t-1.0\t1\n82182\t3.212\t0.212\t411\n82438\t2.973\t0.227\t13\n86044\t2.357\t-1.0\t1\n86050\t3.301\t0.106\t5\n86051\t3.223\t0.408\t15\n86053\t3.906\t-1.0\t1\n86062\t2.711\t0.034\t2\n86068\t3.534\t0.111\t4\n86069\t3.014\t0.266\t86\n86277\t3.132\t0.206\t3\n86278\t3.08\t0.205\t1002\n86279\t2.704\t0.168\t460\n86280\t2.561\t0.163\t44\n86287\t3.292\t0.078\t26\n86288\t3.128\t0.068\t7\n86534\t2.902\t0.101\t13\n86535\t2.446\t0.18\t5\n90134\t3.158\t0.093\t9\n90138\t2.576\t0.185\t3\n90139\t2.835\t0.161\t13\n90140\t2.925\t0.174\t8\n90141\t3.761\t-1.0\t1\n90143\t3.058\t0.0\t2\n90144\t2.522\t0.784\t3\n90145\t2.482\t0.209\t46\n90146\t3.164\t0.558\t44\n90147\t2.774\t0.281\t113\n90150\t3.233\t0.034\t7\n90156\t3.193\t-1.0\t1\n90157\t2.921\t-1.0\t1\n90161\t3.271\t0.0\t2\n90162\t3.869\t0.023\t3\n90163\t3.573\t0.143\t28\n90164\t3.347\t0.022\t18\n90165\t2.62\t0.414\t54\n90168\t3.427\t0.036\t8\n90194\t3.897\t-1.0\t1\n90373\t3.171\t0.268\t3\n90374\t2.926\t0.185\t13105\n90375\t2.587\t0.178\t1875\n90376\t2.456\t0.185\t917\n90383\t3.113\t0.322\t22\n90384\t3.044\t0.167\t14\n90630\t2.624\t0.183\t73\n90631\t2.431\t0.217\t59\n90632\t2.541\t0.214\t13\n94231\t2.269\t0.138\t9\n94234\t2.503\t0.095\t6\n94235\t2.637\t0.592\t3\n94236\t3.236\t0.203\t2\n94242\t2.529\t0.487\t29\n94243\t2.969\t0.254\t17\n94264\t3.486\t-1.0\t1\n94286\t2.784\t0.083\t10\n94470\t2.664\t0.196\t1656\n94471\t2.46\t0.141\t1730\n94472\t2.373\t0.21\t563\n94479\t3.002\t0.084\t9\n94480\t2.809\t0.211\t72\n94726\t2.339\t0.204\t93\n94727\t2.461\t0.173\t28\n94728\t2.22\t0.033\t36\n98328\t2.585\t0.33\t139\n98329\t3.026\t0.483\t6\n98330\t3.053\t0.116\t7\n98331\t2.861\t0.157\t7\n98332\t3.016\t0.06\t2\n98333\t2.906\t-1.0\t1\n98334\t3.171\t-1.0\t1\n98335\t2.778\t0.078\t6\n98336\t2.83\t0.006\t4\n98337\t2.984\t0.301\t63\n98338\t3.557\t0.536\t97\n98339\t2.852\t0.31\t66\n98341\t3.47\t0.104\t3\n98349\t3.572\t-1.0\t1\n98350\t3.259\t0.092\t4\n98354\t3.11\t0.137\t19\n98355\t3.017\t0.193\t20\n98356\t3.203\t0.219\t43\n98357\t3.129\t0.376\t67\n98378\t3.04\t-1.0\t1\n98381\t3.568\t-1.0\t1\n98382\t3.15\t0.188\t5\n98383\t3.133\t0.037\t3\n98384\t3.045\t0.0\t2\n98386\t3.121\t0.097\t12\n98387\t3.325\t0.016\t2\n98565\t2.688\t0.12\t18\n98566\t2.619\t0.153\t6878\n98567\t2.404\t0.141\t2515\n98568\t2.41\t0.174\t638\n98575\t3.098\t0.146\t259\n98576\t2.876\t0.25\t37\n98822\t2.158\t0.152\t4143\n98823\t2.42\t0.131\t56\n98824\t2.468\t0.236\t5\n102425\t3.087\t0.258\t19\n102426\t2.867\t0.103\t4\n102427\t3.03\t0.131\t2\n102428\t2.886\t-1.0\t1\n102431\t3.326\t0.375\t7\n102432\t2.775\t0.168\t35\n102433\t2.737\t0.092\t14\n102434\t3.052\t0.275\t320\n102435\t2.947\t0.279\t501\n102438\t3.136\t0.442\t2\n102442\t3.198\t-1.0\t1\n102444\t2.998\t0.081\t3\n102445\t2.848\t0.318\t2\n102447\t3.116\t0.312\t4\n102449\t2.668\t0.007\t12\n102450\t2.65\t0.156\t37\n102451\t2.804\t0.128\t97\n102452\t3.71\t0.389\t143\n102453\t3.196\t0.352\t77\n102476\t2.993\t0.038\t4\n102478\t3.256\t-1.0\t1\n102479\t3.089\t0.272\t5\n102480\t2.61\t0.003\t4\n102481\t3.397\t-1.0\t1\n102482\t2.754\t0.035\t4\n102483\t2.878\t0.096\t25\n102661\t2.718\t0.111\t3\n102662\t2.482\t0.226\t2788\n102663\t2.511\t0.177\t8370\n102664\t2.493\t0.179\t2602\n102671\t2.643\t0.184\t45\n102672\t2.962\t0.176\t53\n102918\t2.052\t0.149\t4796\n102919\t2.51\t0.179\t433\n102920\t2.374\t0.161\t19\n106522\t2.941\t0.371\t219\n106523\t2.892\t0.261\t5\n106524\t2.877\t0.111\t7\n106525\t2.863\t0.149\t85\n106526\t2.98\t0.096\t34\n106527\t2.834\t0.242\t89\n106528\t2.743\t0.335\t128\n106529\t2.701\t0.254\t143\n106530\t2.739\t0.223\t715\n106531\t2.904\t0.242\t866\n106536\t3.002\t0.349\t8\n106537\t2.799\t0.229\t2\n106538\t3.086\t0.144\t4\n106540\t2.735\t0.302\t14\n106541\t2.768\t0.387\t2\n106542\t3.159\t0.157\t17\n106543\t2.781\t0.205\t11\n106545\t3.031\t0.266\t33\n106546\t3.013\t0.266\t96\n106547\t2.844\t0.229\t38\n106548\t2.92\t0.185\t202\n106549\t3.146\t0.267\t200\n106551\t3.701\t0.004\t2\n106552\t3.508\t0.08\t2\n106554\t3.692\t-1.0\t1\n106556\t3.882\t-1.0\t1\n106566\t3.665\t0.215\t7\n106570\t3.257\t0.114\t4\n106571\t2.863\t0.015\t4\n106572\t2.976\t0.164\t5\n106574\t3.224\t0.085\t11\n106575\t2.779\t0.247\t4\n106576\t2.981\t0.124\t18\n106577\t3.014\t0.072\t10\n106579\t3.124\t0.117\t28\n106757\t2.221\t0.408\t15\n106758\t2.401\t0.141\t81624\n106759\t2.351\t0.184\t21226\n106760\t2.431\t0.13\t2185\n106767\t2.782\t0.218\t230\n106768\t2.742\t0.183\t221\n107014\t2.077\t0.157\t13871\n107015\t2.286\t0.144\t1126\n107016\t2.261\t0.186\t6\n107023\t2.555\t-1.0\t1\n110619\t2.657\t0.367\t240\n110620\t2.816\t0.234\t12\n110621\t2.849\t0.093\t2\n110622\t2.914\t0.068\t12\n110623\t2.683\t0.337\t23\n110624\t2.349\t0.547\t34\n110625\t2.914\t0.287\t44\n110626\t2.37\t0.334\t254\n110627\t2.823\t0.245\t593\n110629\t3.216\t-1.0\t1\n110632\t3.168\t0.262\t18\n110633\t3.517\t-1.0\t1\n110634\t3.188\t-1.0\t1\n110636\t2.935\t0.025\t5\n110637\t2.659\t0.073\t4\n110638\t2.964\t0.14\t43\n110641\t2.808\t0.245\t6\n110642\t2.669\t0.36\t18\n110643\t2.899\t0.004\t2\n110644\t2.907\t0.266\t28\n110645\t3.111\t0.233\t239\n110654\t3.746\t0.042\t4\n110664\t3.213\t0.095\t2\n110665\t3.535\t-1.0\t1\n110666\t3.211\t-1.0\t1\n110669\t2.652\t-1.0\t1\n110670\t3.108\t0.335\t20\n110671\t3.078\t0.114\t48\n110672\t2.505\t0.007\t4\n110673\t2.66\t0.009\t3\n110674\t2.75\t0.014\t4\n110675\t2.821\t0.241\t50\n110682\t3.786\t-1.0\t1\n110684\t3.602\t0.211\t2\n110853\t2.51\t0.032\t24\n110854\t2.424\t0.18\t7855\n110855\t2.35\t0.165\t15280\n110856\t2.397\t0.151\t2600\n110863\t2.753\t0.315\t114\n110864\t2.718\t0.212\t256\n111110\t2.057\t0.162\t5916\n111111\t2.347\t0.183\t580\n111120\t3.119\t-1.0\t1\n114716\t2.861\t0.204\t423\n114717\t2.956\t0.144\t62\n114718\t3.07\t0.105\t55\n114719\t2.884\t0.235\t61\n114720\t2.67\t0.388\t26\n114721\t2.959\t0.219\t18\n114722\t2.832\t0.233\t173\n114723\t2.869\t0.229\t1269\n114727\t2.635\t0.109\t4\n114728\t2.753\t-1.0\t1\n114730\t2.796\t0.0\t2\n114733\t2.529\t0.017\t3\n114737\t2.923\t0.325\t25\n114738\t3.191\t0.145\t154\n114739\t3.085\t0.122\t9\n114740\t3.439\t0.421\t52\n114741\t3.061\t0.179\t190\n114743\t3.288\t-1.0\t1\n114745\t2.617\t0.062\t2\n114759\t3.289\t0.325\t3\n114760\t2.798\t-1.0\t1\n114762\t2.961\t-1.0\t1\n114765\t2.702\t-1.0\t1\n114766\t3.089\t0.135\t10\n114767\t3.047\t0.066\t62\n114768\t3.431\t0.011\t4\n114769\t3.198\t-1.0\t1\n114770\t3.331\t0.009\t16\n114771\t3.287\t0.091\t62\n114780\t3.048\t-1.0\t1\n114949\t2.438\t0.289\t13\n114950\t2.447\t0.207\t5143\n114951\t2.359\t0.153\t15318\n114952\t2.422\t0.153\t2635\n114959\t2.635\t0.231\t43\n114960\t2.669\t0.201\t795\n115206\t2.167\t0.159\t1651\n115207\t2.384\t0.147\t685\n115208\t2.377\t-1.0\t1\n118813\t2.913\t0.463\t3054\n118814\t2.839\t0.079\t11\n118815\t2.711\t0.001\t4\n118816\t2.916\t0.195\t36\n118817\t2.906\t0.257\t48\n118818\t3.003\t0.19\t1185\n118819\t2.89\t0.233\t2162\n118821\t4.015\t-1.0\t1\n118826\t2.96\t-1.0\t1\n118828\t2.952\t0.11\t39\n118829\t2.507\t0.024\t3\n118830\t2.938\t0.19\t22\n118831\t2.849\t0.2\t37\n118834\t2.765\t0.134\t305\n118835\t3.108\t0.155\t31\n118836\t3.39\t0.219\t189\n118837\t3.139\t0.235\t3644\n118839\t3.839\t-1.0\t1\n118858\t2.994\t-1.0\t1\n118861\t2.937\t0.024\t4\n118862\t2.749\t0.231\t11\n118863\t3.089\t0.14\t128\n118864\t2.73\t0.419\t10\n118867\t4.236\t-1.0\t1\n119046\t2.301\t0.205\t1784\n119047\t2.304\t0.132\t28601\n119048\t2.278\t0.16\t3943\n119055\t2.752\t0.18\t205\n119056\t2.764\t0.209\t1501\n119302\t2.425\t0.207\t1326\n119303\t2.302\t0.163\t1333\n119304\t2.514\t0.012\t2\n122910\t2.933\t0.511\t46\n122911\t2.702\t0.368\t7\n122912\t2.663\t0.513\t47\n122913\t2.561\t0.197\t22\n122914\t2.985\t0.238\t269\n122915\t2.799\t0.235\t1020\n122917\t3.448\t-1.0\t1\n122920\t3.428\t0.0\t2\n122922\t3.262\t0.063\t13\n122924\t3.141\t0.257\t36\n122925\t3.024\t0.038\t68\n122926\t3.08\t0.273\t30\n122929\t3.163\t0.018\t2\n122930\t2.751\t0.402\t11\n122932\t3.359\t0.441\t18\n122933\t3.021\t0.24\t382\n122935\t3.714\t-1.0\t1\n122955\t3.014\t0.026\t6\n122957\t3.238\t0.02\t4\n122958\t3.092\t0.105\t29\n122960\t3.074\t0.0\t2\n122961\t2.928\t0.007\t10\n122962\t3.518\t0.023\t8\n122963\t2.553\t0.0\t2\n123142\t2.737\t0.301\t850\n123143\t2.41\t0.137\t13630\n123144\t2.395\t0.157\t2260\n123151\t2.989\t0.176\t11\n123152\t2.86\t0.169\t504\n123398\t2.392\t0.233\t92\n123399\t2.348\t0.155\t241\n127007\t3.02\t0.246\t86\n127008\t2.974\t0.088\t8\n127009\t3.494\t0.451\t21\n127010\t2.829\t0.38\t37\n127011\t2.708\t0.245\t196\n127014\t3.469\t0.079\t7\n127016\t3.23\t0.0\t2\n127018\t3.049\t0.131\t23\n127020\t2.953\t0.101\t22\n127021\t3.009\t0.238\t45\n127022\t3.086\t0.158\t56\n127023\t3.058\t0.009\t4\n127025\t3.335\t0.196\t5\n127026\t3.283\t0.062\t7\n127027\t2.651\t0.769\t24\n127028\t3.434\t0.203\t18\n127029\t3.123\t0.373\t261\n127031\t3.789\t0.084\t6\n127032\t4.457\t-1.0\t1\n127033\t3.667\t-1.0\t1\n127036\t4.074\t0.0\t2\n127039\t4.048\t-1.0\t1\n127046\t4.093\t-1.0\t1\n127050\t2.953\t0.101\t7\n127052\t3.076\t0.218\t4\n127053\t3.176\t0.156\t3\n127054\t2.924\t0.124\t38\n127055\t2.909\t0.082\t10\n127059\t4.205\t0.525\t4\n127068\t3.948\t0.013\t2\n127237\t2.513\t0.281\t7\n127238\t2.422\t0.173\t417\n127239\t2.418\t0.176\t782\n127240\t2.39\t0.178\t153\n127247\t2.978\t0.075\t57\n127248\t2.775\t0.184\t61\n127494\t2.47\t0.44\t42\n127495\t2.406\t0.044\t2\n131109\t3.618\t0.424\t54\n131110\t3.321\t0.053\t36\n131111\t2.973\t0.025\t4\n131112\t3.771\t0.94\t5\n131113\t3.619\t0.341\t9\n131114\t3.143\t0.38\t30\n131116\t2.916\t0.159\t157\n131117\t2.917\t0.159\t121\n131118\t3.04\t0.268\t107\n131119\t2.922\t0.222\t15\n131120\t3.307\t0.038\t4\n131122\t3.411\t0.477\t35\n131123\t3.351\t-1.0\t1\n131127\t3.814\t0.114\t37\n131128\t3.49\t0.107\t29\n131130\t2.988\t0.0\t6\n131137\t2.864\t-1.0\t1\n131138\t3.615\t0.013\t2\n131144\t3.909\t0.169\t5\n131146\t3.079\t0.227\t59\n131147\t2.946\t0.309\t17\n131148\t2.938\t0.152\t48\n131149\t2.889\t0.075\t105\n131150\t2.932\t0.142\t86\n131151\t2.965\t0.315\t19\n131154\t4.158\t0.0\t3\n131155\t3.469\t0.0\t2\n135208\t3.392\t0.193\t9\n135209\t2.553\t0.506\t113\n135210\t2.846\t0.341\t42\n135212\t2.866\t0.212\t135\n135213\t2.927\t0.123\t16\n135214\t2.871\t0.163\t78\n135215\t2.95\t0.206\t41\n135216\t2.799\t0.488\t10\n135217\t2.858\t0.374\t47\n135218\t3.171\t0.414\t88\n135219\t3.525\t0.292\t6\n135226\t2.999\t0.0\t6\n135230\t3.926\t0.069\t11\n135234\t3.555\t0.069\t7\n135237\t4.014\t0.007\t2\n135240\t2.589\t0.032\t8\n135241\t2.464\t0.036\t10\n135242\t2.986\t0.141\t77\n135243\t2.924\t-1.0\t1\n135244\t2.773\t0.037\t5\n135245\t3.046\t0.0\t2\n135246\t2.825\t0.185\t175\n135247\t2.784\t0.162\t65\n135248\t3.475\t0.422\t13\n135249\t3.243\t0.492\t4\n135250\t3.627\t0.385\t15\n135251\t3.822\t0.36\t16\n135258\t3.001\t0.0\t2\n135260\t3.608\t0.228\t9\n135430\t2.312\t0.051\t4\n139303\t3.535\t0.292\t31\n139304\t3.38\t0.183\t24\n139305\t2.623\t0.529\t104\n139306\t3.083\t0.33\t321\n139308\t2.96\t0.162\t229\n139309\t2.923\t0.274\t63\n139310\t2.882\t0.149\t259\n139311\t3.27\t0.202\t438\n139312\t2.668\t0.417\t260\n139313\t3.241\t0.429\t63\n139314\t3.163\t0.399\t546\n139315\t3.191\t0.461\t290\n139321\t3.855\t0.226\t50\n139322\t3.709\t0.138\t100\n139323\t3.684\t0.123\t46\n139324\t3.633\t0.072\t70\n139326\t3.545\t0.123\t112\n139327\t3.991\t0.038\t4\n139328\t3.786\t0.526\t8\n139329\t3.979\t0.001\t4\n139330\t3.537\t0.014\t6\n139331\t3.355\t0.108\t12\n139332\t3.159\t0.173\t21\n139333\t3.624\t0.136\t27\n139334\t3.334\t0.167\t126\n139336\t3.239\t0.487\t10\n139337\t2.614\t0.35\t62\n139338\t3.123\t0.251\t218\n139339\t3.229\t0.309\t1334\n139340\t3.562\t0.717\t14\n139341\t2.945\t0.19\t49\n139342\t2.914\t0.165\t139\n139343\t2.866\t0.183\t165\n139344\t3.14\t0.274\t105\n139345\t3.078\t0.295\t50\n139346\t3.558\t0.371\t43\n139347\t3.512\t0.445\t86\n139354\t3.623\t0.348\t57\n139356\t3.581\t0.414\t207\n139357\t3.553\t0.26\t12\n139358\t3.738\t0.14\t26\n139526\t2.278\t0.056\t6\n143399\t2.881\t0.269\t29\n143400\t3.289\t0.207\t165\n143401\t2.903\t0.415\t136\n143402\t2.928\t0.263\t822\n143404\t2.981\t0.274\t225\n143405\t3.002\t0.373\t123\n143406\t2.929\t0.211\t1350\n143407\t3.15\t0.245\t392\n143408\t3.115\t0.214\t390\n143409\t2.892\t0.454\t277\n143410\t3.152\t0.327\t288\n143411\t3.118\t0.344\t421\n143417\t3.489\t0.306\t26\n143418\t3.66\t0.441\t102\n143419\t2.889\t0.02\t3\n143420\t3.311\t0.239\t14\n143422\t3.519\t0.117\t10\n143423\t3.405\t0.182\t14\n143424\t3.622\t0.201\t10\n143425\t2.902\t0.279\t14\n143426\t3.441\t0.397\t31\n143427\t2.869\t0.248\t16\n143428\t2.769\t0.111\t12\n143430\t3.342\t0.101\t8\n143433\t3.029\t0.413\t218\n143434\t2.63\t0.358\t237\n143435\t2.974\t0.223\t787\n143436\t2.871\t0.256\t91\n143437\t3.02\t0.255\t120\n143438\t2.97\t0.262\t730\n143439\t2.839\t0.219\t570\n143440\t2.939\t0.303\t600\n143441\t2.709\t0.226\t130\n143442\t3.393\t0.358\t470\n143443\t3.237\t0.326\t869\n143450\t3.569\t0.067\t21\n143452\t3.3\t0.463\t144\n143453\t2.771\t0.0\t6\n143454\t3.655\t0.021\t3\n143455\t2.882\t0.023\t3\n151589\t4.027\t0.433\t171\n151590\t3.818\t0.355\t2\n151594\t3.871\t0.0\t2\n151598\t3.586\t0.162\t20\n151599\t3.353\t0.049\t2\n151601\t3.937\t0.0\t2\n151602\t3.839\t0.296\t15\n151603\t3.859\t0.378\t36\n151607\t4.188\t0.029\t2\n151631\t3.626\t0.064\t26\n151633\t3.814\t0.025\t4\n151634\t3.849\t0.071\t10\n151635\t4.057\t0.0\t2\n151814\t3.815\t0.247\t64\n152069\t3.392\t0.0\t2\n152070\t3.728\t0.185\t7\n155686\t3.715\t0.263\t197\n155692\t3.291\t0.0\t2\n155693\t3.275\t0.0\t2\n155695\t3.371\t-1.0\t1\n155696\t3.544\t0.083\t4\n155697\t3.415\t0.077\t36\n155698\t3.446\t0.074\t26\n155699\t3.346\t0.137\t70\n155703\t4.039\t0.114\t2\n155704\t3.785\t-1.0\t1\n155725\t3.3\t0.0\t4\n155726\t3.174\t0.064\t8\n155727\t3.236\t0.051\t4\n155728\t3.411\t0.02\t2\n155729\t3.492\t0.006\t3\n155730\t3.53\t0.066\t10\n155731\t3.424\t0.132\t88\n155740\t3.534\t-1.0\t1\n155910\t3.584\t0.272\t112\n156166\t2.793\t0.019\t4\n159783\t4.713\t0.009\t2\n159790\t3.627\t0.388\t4\n159795\t3.832\t0.039\t12\n159797\t3.719\t0.347\t56\n159799\t4.168\t0.0\t2\n159822\t3.558\t0.003\t2\n160005\t3.476\t0.074\t35\n160006\t3.258\t0.191\t4054\n160007\t2.913\t0.142\t1412\n160008\t2.796\t0.249\t708\n160015\t3.636\t0.026\t3\n160016\t3.367\t0.408\t27\n160262\t2.99\t0.127\t72\n160263\t3.031\t0.264\t24\n163884\t3.712\t0.084\t3\n163885\t3.713\t0.26\t5\n163889\t3.399\t0.0\t2\n163890\t3.989\t0.377\t5\n163892\t3.476\t0.0\t2\n163893\t3.302\t0.424\t87\n163917\t3.364\t0.045\t5\n163918\t3.314\t0.355\t6\n163922\t4.034\t-1.0\t1\n164101\t3.255\t0.125\t9\n164102\t3.029\t0.219\t13290\n164103\t2.812\t0.186\t1007\n164104\t2.599\t0.231\t718\n164111\t3.355\t0.275\t19\n164112\t3.184\t0.119\t22\n164358\t2.805\t0.151\t103\n164359\t2.642\t0.21\t22\n164360\t2.844\t0.216\t9\n167977\t2.746\t0.433\t12\n167986\t3.166\t-1.0\t1\n167988\t3.668\t0.819\t15\n167989\t2.936\t0.216\t20\n168198\t2.975\t0.237\t953\n168199\t2.749\t0.24\t450\n168200\t2.532\t0.296\t44\n168207\t3.165\t0.13\t49\n168208\t3.318\t0.08\t14\n168454\t2.601\t0.169\t111\n168455\t2.727\t0.161\t25\n172074\t2.912\t0.373\t1298\n172076\t3.157\t0.34\t9\n172078\t3.301\t0.025\t5\n172079\t3.222\t0.067\t8\n172082\t3.28\t0.259\t30\n172083\t3.177\t0.165\t15\n172084\t3.327\t0.193\t23\n172085\t3.272\t0.292\t557\n172087\t3.799\t-1.0\t1\n172088\t3.528\t-1.0\t1\n172106\t2.727\t0.462\t6\n172107\t3.735\t-1.0\t1\n172109\t3.252\t0.082\t43\n172110\t3.239\t0.183\t9\n172111\t3.197\t0.132\t22\n172112\t3.584\t0.076\t4\n172114\t3.693\t0.232\t12\n172115\t3.359\t0.28\t40\n172124\t3.744\t0.013\t2\n172293\t3.03\t0.256\t14\n172294\t2.789\t0.167\t9278\n172295\t2.577\t0.18\t3098\n172296\t2.467\t0.259\t1296\n172303\t2.908\t0.239\t150\n172304\t2.957\t0.217\t165\n172550\t2.341\t0.159\t4663\n172551\t2.511\t0.149\t218\n172559\t2.202\t0.279\t10\n180268\t3.063\t0.299\t1102\n180269\t2.945\t0.515\t10\n180270\t3.082\t0.36\t14\n180271\t3.086\t-1.0\t1\n180272\t3.242\t0.131\t2\n180273\t3.439\t0.268\t6\n180274\t3.072\t0.196\t129\n180275\t3.213\t0.211\t24\n180276\t3.091\t0.153\t98\n180277\t3.22\t0.208\t173\n180295\t3.709\t0.109\t4\n180296\t3.674\t0.024\t2\n180298\t3.338\t0.368\t8\n180299\t3.08\t0.02\t2\n180300\t3.051\t0.136\t6\n180301\t3.2\t0.237\t31\n180302\t3.182\t0.186\t59\n180303\t2.975\t0.164\t24\n180304\t3.255\t-1.0\t1\n180306\t2.931\t0.041\t12\n180307\t2.734\t0.077\t20\n180485\t2.755\t0.204\t14\n180486\t2.611\t0.146\t28221\n180487\t2.363\t0.139\t11820\n180488\t2.408\t0.153\t1326\n180495\t2.75\t0.202\t77\n180496\t2.828\t0.175\t621\n180742\t2.163\t0.16\t10524\n180743\t2.394\t0.13\t880\n180744\t2.447\t0.224\t6\n180751\t2.688\t0.012\t5\n180752\t2.464\t0.284\t5\n184365\t2.871\t0.285\t392\n184366\t3.302\t0.52\t4\n184367\t2.634\t0.029\t2\n184368\t2.701\t-1.0\t1\n184369\t3.216\t0.427\t13\n184370\t3.333\t0.264\t124\n184371\t3.063\t0.086\t29\n184372\t3.343\t0.188\t5\n184373\t3.193\t0.194\t327\n184396\t2.794\t0.148\t26\n184397\t2.962\t0.816\t2\n184398\t2.985\t0.39\t19\n184399\t3.255\t0.176\t61\n184400\t3.215\t0.059\t6\n184402\t3.402\t0.003\t2\n184403\t3.348\t0.247\t21\n184412\t3.283\t0.005\t3\n184581\t2.634\t0.295\t6\n184582\t2.568\t0.171\t12855\n184583\t2.441\t0.153\t3081\n184584\t2.416\t0.166\t1225\n184591\t2.739\t0.094\t61\n184592\t2.805\t0.202\t148\n184837\t2.886\t-1.0\t1\n184838\t2.196\t0.199\t2670\n184839\t2.45\t0.148\t279\n184848\t2.287\t0.009\t6\n188462\t3.197\t0.284\t549\n188463\t3.567\t0.174\t71\n188465\t3.129\t0.275\t2\n188466\t3.378\t0.343\t81\n188467\t3.278\t0.49\t122\n188468\t3.121\t0.318\t140\n188469\t3.118\t0.179\t936\n188472\t3.155\t0.189\t11\n188486\t2.788\t-1.0\t1\n188487\t3.697\t0.043\t2\n188490\t3.361\t-1.0\t1\n188491\t3.319\t0.01\t2\n188492\t3.071\t0.101\t16\n188494\t3.253\t0.286\t17\n188495\t3.308\t0.347\t126\n188496\t3.082\t0.313\t5\n188497\t3.342\t0.379\t39\n188498\t3.685\t0.035\t11\n188499\t2.981\t0.028\t91\n188508\t3.265\t0.257\t3\n188677\t2.545\t0.218\t11\n188678\t2.381\t0.169\t6266\n188679\t2.365\t0.135\t7580\n188680\t2.446\t0.147\t1073\n188687\t2.778\t0.159\t82\n188688\t2.732\t0.177\t615\n188934\t2.405\t0.21\t1341\n188935\t2.38\t0.131\t281\n188936\t2.152\t0.004\t2\n188944\t2.657\t0.082\t9\n192559\t3.554\t0.226\t4083\n192561\t2.716\t-1.0\t1\n192562\t3.443\t0.292\t14\n192563\t3.163\t0.241\t12\n192564\t3.698\t0.229\t62\n192565\t3.522\t0.275\t796\n192572\t3.827\t0.068\t3\n192587\t3.3\t0.096\t6\n192588\t3.119\t0.06\t30\n192589\t3.417\t0.237\t27\n192590\t3.436\t0.273\t279\n192591\t3.326\t0.24\t399\n192592\t2.823\t0.436\t7\n192774\t2.472\t0.2\t1611\n192775\t2.535\t0.173\t5301\n192776\t2.731\t0.17\t305\n192783\t2.898\t0.163\t18\n192784\t3.194\t0.23\t847\n193030\t2.719\t0.257\t1011\n193031\t2.571\t0.187\t351\n196656\t2.962\t0.143\t4\n196659\t2.984\t0.064\t32\n196660\t3.488\t0.2\t53\n196661\t3.212\t0.24\t422\n196664\t3.568\t0.009\t4\n196686\t3.302\t0.12\t162\n196687\t3.375\t0.136\t15\n196690\t3.639\t0.028\t8\n196691\t3.016\t0.052\t32\n196870\t2.546\t0.218\t32\n196871\t2.669\t0.125\t3379\n196872\t2.711\t0.152\t719\n196880\t3.123\t0.225\t349\n197126\t2.828\t0.381\t77\n197127\t2.606\t0.119\t56\n197128\t2.751\t-1.0\t1\n200753\t2.968\t0.291\t109\n200754\t3.781\t0.18\t17\n200755\t2.926\t0.006\t4\n200756\t3.55\t0.394\t50\n200757\t3.215\t0.314\t179\n200759\t3.813\t0.152\t8\n200760\t3.68\t0.079\t15\n200778\t3.2\t0.021\t2\n200779\t2.798\t0.024\t24\n200781\t2.816\t0.38\t2\n200782\t3.146\t0.138\t51\n200783\t3.783\t-1.0\t1\n200784\t3.608\t0.06\t2\n200787\t3.701\t0.063\t13\n200966\t2.737\t0.248\t164\n200967\t2.638\t0.193\t666\n200968\t2.735\t0.196\t128\n200975\t3.61\t0.145\t5\n200976\t2.787\t0.336\t60\n201222\t2.754\t0.18\t12\n201223\t2.897\t0.149\t12\n204850\t3.629\t0.476\t976\n204851\t2.793\t0.054\t34\n204852\t3.367\t0.645\t98\n204853\t3.325\t0.463\t310\n204855\t3.996\t0.344\t33\n204856\t3.682\t0.08\t11\n204857\t3.947\t0.023\t6\n204858\t3.186\t0.0\t6\n204863\t3.44\t0.0\t11\n204866\t3.929\t-1.0\t1\n204870\t3.525\t0.118\t8\n204872\t4.135\t0.14\t3\n204874\t3.301\t0.205\t57\n204875\t3.121\t0.234\t55\n204876\t3.203\t0.168\t70\n204877\t3.061\t0.08\t42\n204878\t3.284\t0.173\t281\n204879\t4.309\t0.589\t23\n204881\t3.669\t0.346\t5\n204882\t3.46\t0.055\t10\n204883\t3.636\t0.704\t18\n204892\t4.537\t-1.0\t1\n205061\t2.753\t0.308\t17\n205062\t2.528\t0.15\t3869\n205063\t2.708\t0.199\t1070\n205064\t2.716\t0.2\t545\n205071\t3.421\t0.246\t38\n205072\t3.123\t0.212\t212\n205318\t2.574\t0.174\t88\n205319\t2.626\t0.158\t25\n208947\t2.969\t0.506\t259\n208948\t3.77\t0.671\t12\n208949\t3.392\t0.45\t229\n208951\t3.952\t0.118\t44\n208952\t3.545\t0.115\t138\n208953\t3.197\t0.0\t6\n208954\t3.176\t0.0\t6\n208962\t3.825\t0.039\t12\n208968\t3.44\t-1.0\t1\n208970\t3.273\t0.166\t30\n208971\t3.245\t0.214\t83\n208972\t2.968\t0.115\t113\n208973\t3.43\t0.067\t4\n208974\t3.1\t0.205\t80\n208975\t3.122\t0.204\t60\n208976\t3.551\t0.081\t6\n208977\t4.668\t0.032\t6\n208978\t4.088\t0.033\t12\n208979\t2.917\t0.271\t11\n209158\t2.495\t0.15\t1844\n209159\t2.721\t0.28\t225\n209160\t2.668\t0.436\t78\n209167\t3.017\t0.046\t5\n209168\t3.149\t0.165\t38\n209414\t2.509\t0.24\t10\n209415\t2.427\t0.146\t6\n213050\t4.433\t0.045\t6\n213054\t4.024\t0.099\t10\n213065\t5.027\t-1.0\t1\n213066\t2.704\t0.455\t23\n213067\t3.276\t0.286\t165\n213068\t3.025\t0.034\t20\n213070\t3.155\t0.284\t48\n213071\t3.03\t0.209\t38\n213072\t3.343\t0.249\t92\n213073\t4.446\t0.01\t2\n213074\t4.01\t0.314\t16\n213075\t3.489\t0.653\t32\n213084\t3.85\t0.333\t22\n213086\t4.355\t0.043\t6\n217145\t3.893\t0.312\t115\n217146\t4.057\t0.272\t72\n217147\t3.309\t0.409\t38\n217148\t3.875\t0.23\t104\n217150\t3.913\t0.338\t122\n217151\t4.078\t0.166\t14\n217152\t3.772\t0.324\t18\n217153\t3.606\t0.456\t25\n217154\t3.192\t0.524\t27\n217156\t3.103\t0.413\t22\n217157\t3.863\t0.489\t46\n217158\t3.761\t0.157\t82\n217159\t3.66\t0.413\t6\n217160\t3.35\t0.322\t22\n217161\t2.816\t0.4\t52\n217162\t2.801\t0.247\t341\n217163\t2.814\t0.353\t94\n217164\t2.999\t0.191\t26\n217165\t3.222\t0.232\t233\n217166\t3.234\t0.277\t811\n217167\t3.066\t0.296\t281\n217168\t3.131\t0.252\t665\n217169\t2.89\t0.413\t19\n217170\t3.801\t0.427\t565\n217171\t3.582\t0.409\t827\n217178\t3.927\t0.242\t20\n217180\t3.819\t0.264\t406\n217182\t3.899\t0.189\t7\n217183\t3.278\t-1.0\t1\n225335\t4.276\t0.49\t265\n225336\t4.479\t0.154\t3\n225338\t4.3\t0.0\t2\n225345\t4.243\t-1.0\t1\n225346\t4.182\t-1.0\t1\n225354\t3.789\t-1.0\t1\n225359\t3.687\t0.153\t5\n225360\t4.965\t0.0\t3\n225361\t4.086\t0.077\t5\n225362\t3.938\t0.124\t17\n225363\t4.209\t0.153\t5\n225542\t4.026\t0.331\t148\n225797\t3.377\t0.162\t3\n225798\t3.864\t0.248\t33\n229432\t4.077\t0.334\t194\n229450\t3.552\t0.0\t2\n229455\t3.61\t0.0\t2\n229458\t3.779\t0.076\t5\n229459\t3.62\t0.105\t15\n229638\t3.726\t0.142\t169\n229893\t2.88\t0.148\t17\n233547\t3.663\t0.041\t4\n233733\t3.661\t0.127\t9\n233734\t3.511\t0.169\t1320\n233735\t3.103\t0.143\t699\n233736\t2.952\t0.191\t544\n233743\t4.137\t0.779\t6\n233744\t3.541\t0.191\t21\n233990\t3.356\t0.17\t18\n233991\t3.128\t0.157\t55\n237830\t3.517\t0.262\t866\n237831\t3.053\t0.238\t780\n237832\t2.942\t0.272\t364\n237839\t3.058\t0.078\t3\n237840\t3.557\t0.208\t14\n238086\t3.309\t0.197\t15\n238087\t3.084\t0.184\t40\n241926\t3.477\t0.124\t197\n241927\t3.016\t0.163\t300\n241928\t2.871\t0.151\t320\n241936\t3.545\t0.074\t6\n242182\t3.213\t0.142\t3\n242183\t3.034\t0.049\t17\n246021\t3.749\t-1.0\t1\n246022\t3.442\t0.199\t803\n246023\t3.027\t0.153\t733\n246024\t2.83\t0.16\t737\n246031\t3.715\t0.509\t10\n246032\t3.489\t0.117\t10\n246278\t3.07\t0.175\t7\n246279\t3.018\t0.113\t65\n254014\t3.621\t0.145\t11\n254027\t3.568\t0.017\t3\n254214\t3.39\t0.158\t2671\n254215\t2.996\t0.161\t998\n254216\t2.805\t0.192\t556\n254223\t3.737\t0.252\t40\n254224\t3.439\t0.148\t13\n254470\t3.227\t0.142\t6\n254471\t3.139\t0.173\t24\n254472\t2.911\t0.206\t20\n258111\t2.215\t0.23\t2\n258310\t3.466\t0.262\t271\n258311\t2.927\t0.187\t1239\n258312\t2.76\t0.166\t1083\n258320\t3.383\t0.05\t12\n258566\t3.457\t0.042\t4\n258567\t2.819\t0.112\t11\n262406\t3.329\t0.213\t453\n262407\t2.926\t0.184\t889\n262408\t2.796\t0.186\t1231\n262416\t3.355\t0.381\t10\n262662\t2.919\t0.044\t2\n262663\t2.999\t0.226\t11\n266502\t3.401\t0.179\t388\n266503\t2.89\t0.17\t992\n266504\t2.734\t0.193\t1159\n266511\t3.732\t-1.0\t1\n266512\t3.445\t0.0\t2\n266758\t2.926\t-1.0\t1\n266759\t2.857\t0.231\t31\n270597\t3.404\t0.076\t3\n270598\t3.222\t0.253\t1595\n270599\t2.866\t0.193\t2042\n270600\t2.707\t0.189\t2073\n270607\t3.718\t-1.0\t1\n270608\t3.41\t0.38\t13\n270854\t2.9\t-1.0\t1\n270855\t2.794\t0.192\t30\n274510\t4.001\t0.0\t2\n274694\t3.388\t0.171\t354\n274695\t2.87\t0.172\t416\n274696\t2.724\t0.185\t439\n274950\t2.925\t0.039\t8\n274951\t2.479\t0.253\t12\n278789\t3.409\t0.069\t2\n278790\t3.158\t0.169\t1145\n278791\t2.849\t0.175\t801\n278792\t2.672\t0.179\t577\n278799\t3.625\t-1.0\t1\n278800\t3.474\t0.092\t7\n279046\t2.934\t0.097\t12\n279047\t2.89\t0.09\t12\n282693\t3.553\t0.0\t4\n282886\t3.443\t0.178\t536\n282887\t2.879\t0.209\t168\n282888\t2.725\t0.147\t129\n282895\t3.631\t0.142\t21\n282896\t3.222\t0.01\t8\n283143\t2.527\t0.136\t9\n286981\t3.507\t0.084\t5\n286982\t3.184\t0.155\t3390\n286983\t2.859\t0.153\t1245\n286984\t2.682\t0.159\t499\n286991\t3.54\t0.155\t13\n286992\t3.365\t0.159\t9\n287238\t3.019\t0.138\t24\n287239\t2.855\t0.076\t16\n287240\t2.979\t0.21\t26\n290891\t3.455\t0.011\t2\n290894\t3.514\t-1.0\t1\n291077\t3.476\t0.16\t11\n291078\t3.284\t0.204\t878\n291079\t2.84\t0.187\t460\n291080\t2.635\t0.193\t132\n291088\t3.528\t0.062\t2\n291334\t2.883\t0.06\t12\n291335\t2.948\t0.137\t14\n294994\t3.999\t-1.0\t1\n295173\t3.165\t0.193\t2\n295174\t3.107\t0.177\t2432\n295175\t2.774\t0.182\t341\n295176\t2.652\t0.204\t104\n295184\t3.109\t0.166\t9\n295430\t2.767\t0.112\t12\n295431\t2.657\t0.278\t12\n299081\t2.935\t0.369\t17\n299085\t3.119\t0.214\t10\n299270\t2.918\t0.218\t1400\n299271\t2.737\t0.199\t305\n299272\t2.492\t0.248\t40\n299279\t2.559\t0.037\t4\n299526\t2.488\t0.241\t28\n299527\t2.804\t0.155\t6\n303178\t2.675\t0.417\t434\n303181\t3.222\t0.078\t41\n303182\t3.654\t-1.0\t1\n303183\t3.21\t0.023\t4\n303186\t3.733\t0.044\t8\n303187\t3.128\t0.192\t8\n303365\t2.968\t0.028\t2\n303366\t2.8\t0.213\t3774\n303367\t2.584\t0.227\t2258\n303368\t2.49\t0.297\t312\n303375\t2.904\t0.202\t124\n303376\t3.053\t0.272\t32\n303622\t2.342\t0.159\t6180\n303623\t2.471\t0.154\t65\n307275\t3.127\t0.383\t1161\n307276\t3.076\t0.401\t28\n307277\t3.191\t0.02\t2\n307278\t3.567\t0.117\t38\n307279\t3.269\t0.094\t25\n307280\t3.228\t0.038\t20\n307281\t3.587\t0.03\t2\n307283\t3.205\t0.081\t30\n307292\t3.713\t0.164\t4\n307462\t2.629\t0.197\t1542\n307463\t2.457\t0.127\t3999\n307464\t2.435\t0.206\t207\n307471\t2.732\t0.251\t11\n307472\t2.825\t0.122\t121\n307718\t2.178\t0.135\t8471\n307719\t2.383\t0.156\t157\n307720\t2.299\t0.121\t3\n307728\t2.409\t0.014\t6\n311372\t3.106\t0.207\t804\n311373\t3.181\t-1.0\t1\n311374\t3.548\t0.146\t32\n311375\t3.12\t0.036\t62\n311379\t2.887\t0.06\t22\n311558\t2.597\t0.187\t2089\n311559\t2.357\t0.157\t1187\n311560\t2.486\t0.163\t95\n311567\t3.048\t0.26\t4\n311568\t3.082\t0.291\t44\n311814\t2.108\t0.152\t4572\n311815\t2.428\t0.139\t86\n311824\t2.543\t0.001\t4\n315469\t3.151\t0.278\t365\n315470\t3.549\t0.122\t63\n315471\t3.157\t0.118\t31\n315475\t3.22\t0.061\t39\n315653\t2.65\t0.215\t20\n315654\t2.552\t0.195\t16080\n315655\t2.382\t0.126\t6084\n315656\t2.483\t0.127\t418\n315663\t2.762\t0.14\t37\n315664\t2.816\t0.196\t162\n315910\t2.215\t0.168\t2203\n315911\t2.436\t0.105\t204\n315920\t2.977\t-1.0\t1\n319566\t3.225\t0.248\t552\n319567\t3.367\t0.293\t115\n319568\t3.169\t0.205\t20\n319569\t3.36\t0.238\t50\n319570\t3.392\t0.286\t42\n319571\t2.929\t0.286\t8\n319580\t2.758\t-1.0\t1\n319749\t2.528\t0.434\t19\n319750\t2.374\t0.187\t4743\n319751\t2.364\t0.145\t6282\n319752\t2.404\t0.169\t399\n319759\t2.743\t0.15\t63\n319760\t2.674\t0.189\t638\n320005\t2.585\t0.095\t3\n320006\t2.331\t0.173\t2612\n320007\t2.357\t0.121\t135\n320015\t2.781\t0.006\t2\n320016\t2.898\t0.124\t6\n323663\t3.245\t0.336\t4562\n323664\t3.526\t0.142\t2\n323665\t3.286\t0.102\t22\n323666\t3.306\t0.022\t2\n323667\t2.881\t0.196\t25\n323846\t2.35\t0.15\t3014\n323847\t2.354\t0.137\t1158\n323848\t2.403\t0.253\t6\n323855\t2.769\t0.169\t45\n323856\t2.739\t0.213\t222\n324102\t2.337\t0.19\t1691\n324103\t2.388\t0.156\t45\n327760\t2.694\t0.474\t53\n327941\t2.577\t-1.0\t1\n327942\t2.266\t0.136\t922\n327943\t2.741\t0.157\t953\n327944\t2.741\t0.235\t37\n327951\t2.904\t0.093\t8\n327952\t2.866\t0.242\t158\n328198\t2.38\t0.168\t94\n328199\t2.875\t0.15\t3\n331857\t3.111\t0.21\t60\n332038\t2.542\t0.227\t19\n332039\t2.984\t0.13\t175\n332040\t2.942\t0.295\t20\n332048\t3.399\t0.21\t18\n332294\t2.174\t0.0\t4\n335954\t3.231\t0.429\t436\n336134\t2.776\t0.248\t252\n336135\t2.833\t0.135\t693\n336136\t2.76\t0.196\t207\n336143\t3.678\t0.123\t15\n336144\t3.263\t0.218\t66\n336390\t2.874\t0.122\t4\n336391\t2.699\t0.147\t7\n340051\t3.126\t0.27\t404\n340229\t2.797\t-1.0\t1\n340230\t2.623\t0.24\t807\n340231\t2.807\t0.169\t491\n340232\t2.771\t0.212\t269\n340239\t3.206\t0.012\t2\n340240\t3.325\t0.293\t98\n340486\t2.701\t0.167\t16\n340487\t3.129\t0.34\t2\n368902\t3.528\t0.229\t2516\n368903\t3.077\t0.237\t337\n368904\t2.966\t0.304\t84\n368911\t3.616\t0.121\t7\n368912\t3.535\t0.376\t64\n369158\t3.14\t0.113\t14\n369159\t3.146\t0.323\t8\n369160\t3.179\t0.006\t2\n376924\t3.747\t0.0\t2\n377094\t3.44\t0.227\t3394\n377095\t2.982\t0.201\t1971\n377096\t2.826\t0.242\t770\n377103\t2.998\t0.426\t10\n377104\t3.462\t0.179\t110\n377350\t3.258\t0.302\t74\n377351\t3.02\t0.219\t96\n377352\t3.011\t0.211\t9\n381190\t3.595\t0.186\t49\n381191\t3.016\t0.171\t33\n381192\t3.071\t0.23\t47\n381200\t3.429\t0.053\t8\n385286\t3.676\t0.046\t15\n385287\t3.005\t0.218\t31\n385288\t3.065\t0.263\t47\n385296\t3.84\t0.251\t6\n389383\t3.107\t0.032\t5\n389384\t2.858\t0.234\t18\n389392\t3.517\t0.038\t3\n393479\t3.128\t0.008\t2\n393488\t3.419\t0.064\t3\n397575\t3.05\t0.029\t3\n397576\t2.942\t0.008\t3\n401671\t3.038\t0.025\t3\n401672\t2.931\t0.016\t3\n1073414\t1.594\t0.077\t2000853\n1073415\t1.527\t0.071\t91806\n1073423\t2.001\t0.161\t74\n1073424\t1.981\t0.067\t42\n1073679\t2.05\t0.093\t4\n1073680\t1.992\t0.039\t7\n1077511\t1.504\t0.087\t791\n1077519\t1.839\t0.106\t1862\n1077520\t1.811\t0.097\t38\n1077776\t1.753\t0.11\t23\n1110287\t2.325\t0.221\t8\n16781317\t1.299\t0.138\t2655\n16781318\t1.157\t0.073\t2154155\n16781319\t1.027\t0.087\t120477\n16781320\t1.0\t0.102\t99234\n16781321\t1.229\t0.768\t39\n16781326\t1.698\t0.206\t492\n16781327\t1.491\t0.16\t461\n16781328\t1.414\t0.148\t260\n16781329\t1.46\t0.267\t16\n16781344\t1.768\t0.207\t170\n16781345\t1.64\t0.233\t13\n16781346\t1.184\t0.24\t11\n16781347\t1.193\t0.14\t10\n16781365\t1.612\t0.001\t2\n16781573\t1.266\t-1.0\t1\n16781574\t1.083\t0.054\t1399983\n16781575\t1.026\t0.08\t10086\n16781576\t1.035\t0.083\t62\n16781583\t1.555\t0.169\t170\n16781830\t1.082\t0.064\t1503\n16781831\t1.012\t0.075\t9\n16797701\t2.055\t0.175\t200\n16797702\t1.917\t0.136\t1968\n16797703\t1.74\t0.145\t4307\n16797704\t1.627\t0.111\t7838\n16797705\t1.579\t0.095\t5410\n16797710\t2.643\t0.184\t32\n16797711\t2.367\t0.191\t736\n16797712\t2.279\t0.266\t207\n16797713\t2.22\t0.188\t513\n16797728\t2.564\t0.128\t21\n16797729\t2.481\t0.101\t5\n16797730\t2.577\t0.148\t48\n16797731\t2.401\t0.231\t244\n16797748\t2.725\t0.14\t4\n16797749\t2.87\t0.374\t77\n16797958\t1.838\t0.106\t11969\n16797959\t1.825\t0.108\t1915\n16797967\t2.268\t0.255\t20\n16798214\t1.868\t0.127\t268\n16798215\t1.772\t0.141\t42\n16798224\t2.259\t-1.0\t1\n16801798\t1.819\t0.111\t650683\n16801799\t1.721\t0.104\t153277\n16801800\t1.674\t0.089\t194202\n16801801\t1.483\t0.083\t37441\n16801806\t2.363\t0.237\t31159\n16801807\t2.243\t0.189\t5173\n16801808\t2.128\t0.132\t11654\n16801809\t2.024\t0.124\t15529\n16801824\t2.527\t0.248\t999\n16801825\t2.422\t0.325\t206\n16801826\t2.378\t0.18\t872\n16801827\t2.279\t0.155\t2704\n16801844\t2.666\t0.308\t172\n16801845\t2.522\t0.166\t717\n16802054\t1.762\t0.092\t352183\n16802055\t1.72\t0.097\t14388\n16802056\t1.688\t0.108\t6\n16802063\t2.207\t0.172\t3307\n16802064\t2.105\t0.131\t3350\n16802310\t1.696\t0.091\t7665\n16802311\t1.656\t0.128\t75\n16802320\t2.082\t0.116\t4919\n16805895\t1.623\t0.108\t3208\n16805896\t1.666\t0.126\t2100\n16805897\t1.415\t0.162\t17\n16805902\t2.205\t0.191\t1967\n16805903\t2.079\t0.152\t1682\n16805904\t1.93\t0.103\t249\n16805905\t1.958\t0.111\t24\n16805920\t2.362\t0.195\t1315\n16805921\t2.241\t0.173\t128\n16805922\t2.3\t0.193\t96\n16805923\t2.162\t0.118\t32\n16805940\t2.674\t0.201\t118\n16805941\t2.473\t0.194\t38\n16806150\t1.59\t0.082\t164495\n16806151\t1.574\t0.081\t7627\n16806159\t1.986\t0.139\t3197\n16806160\t2.009\t0.09\t401\n16806406\t1.512\t0.069\t153\n16806407\t1.394\t0.086\t533\n16806416\t1.9\t0.093\t9234\n16809992\t1.741\t0.264\t647\n16809998\t1.995\t0.155\t7813\n16809999\t1.925\t0.144\t1208\n16810000\t1.916\t0.201\t51\n16810001\t1.673\t0.087\t998\n16810016\t2.152\t0.242\t1021\n16810017\t1.796\t0.244\t670\n16810018\t2.006\t0.2\t174\n16810019\t1.965\t0.381\t4\n16810036\t2.404\t0.302\t460\n16810037\t2.386\t0.22\t205\n16810246\t1.562\t0.08\t163577\n16810247\t1.393\t0.102\t21110\n16810255\t1.861\t0.129\t9068\n16810256\t1.926\t0.104\t123\n16810502\t1.408\t0.07\t41\n16810503\t1.354\t0.073\t7\n16810512\t1.734\t0.114\t5958\n16814089\t1.446\t0.064\t5\n16814094\t1.979\t0.162\t679\n16814095\t1.82\t0.095\t9307\n16814096\t1.773\t0.108\t625\n16814097\t1.615\t0.213\t20\n16814112\t2.054\t0.303\t209\n16814113\t1.845\t0.169\t415\n16814114\t2.218\t0.193\t16\n16814115\t1.836\t0.098\t23\n16814132\t1.837\t0.254\t287\n16814133\t2.14\t0.294\t84\n16814342\t1.478\t0.072\t44091\n16814343\t1.246\t0.169\t3\n16814351\t1.618\t0.194\t150\n16814352\t1.613\t0.103\t16\n16814608\t1.556\t0.127\t44\n16834574\t3.378\t0.364\t2682\n16834575\t2.882\t0.272\t162\n16834576\t2.626\t0.23\t157\n16834577\t2.549\t0.274\t1011\n16834592\t3.473\t0.286\t507\n16834593\t3.314\t0.371\t24\n16834594\t2.897\t0.327\t42\n16834595\t2.87\t0.389\t169\n16834612\t3.665\t0.536\t15\n16834613\t3.09\t0.417\t78\n16834822\t2.235\t0.149\t6897\n16834823\t2.299\t0.166\t545\n16835078\t2.237\t0.123\t1405\n16835079\t2.102\t0.162\t46\n16838671\t2.751\t0.246\t664\n16838672\t2.368\t0.224\t165\n16838673\t2.447\t0.27\t425\n16838688\t3.18\t0.313\t89\n16838689\t2.773\t0.119\t26\n16838690\t2.582\t0.333\t127\n16838691\t2.563\t0.288\t58\n16838708\t3.027\t0.178\t12\n16838709\t2.915\t0.394\t101\n16838918\t2.115\t0.115\t8657\n16838919\t1.855\t0.183\t439\n16838927\t2.715\t0.169\t135\n16838928\t2.658\t0.069\t6\n16839174\t1.936\t0.185\t23\n16839175\t2.101\t0.064\t2\n16839184\t2.948\t-1.0\t1\n16842768\t2.281\t0.201\t1234\n16842769\t2.015\t0.03\t13\n16842784\t2.754\t0.331\t616\n16842785\t2.241\t0.25\t917\n16842786\t2.475\t0.266\t49\n16842787\t2.694\t0.214\t14\n16842804\t3.261\t0.399\t44\n16842805\t3.241\t0.251\t46\n16843014\t2.01\t0.115\t20813\n16843015\t1.834\t0.133\t156\n16843023\t2.464\t0.209\t339\n16843024\t2.494\t0.161\t19\n16843270\t1.935\t0.13\t225\n16843280\t2.489\t0.19\t50\n16846865\t1.992\t0.399\t44\n16846880\t2.745\t0.286\t511\n16846881\t2.728\t0.235\t235\n16846882\t2.384\t0.337\t109\n16846900\t3.03\t0.369\t277\n16846901\t2.906\t0.468\t87\n16847110\t1.969\t0.095\t20992\n16847111\t1.77\t0.177\t16\n16847119\t2.289\t0.187\t1133\n16847120\t2.181\t0.113\t8\n16847366\t1.923\t0.203\t4\n16847376\t2.231\t0.165\t28\n16908320\t3.119\t0.561\t1100\n16908321\t2.481\t0.4\t70\n16908322\t2.624\t0.585\t344\n16908323\t2.911\t0.375\t127\n16908340\t3.181\t0.424\t124\n16908341\t3.271\t0.469\t73\n16908550\t2.342\t0.169\t2233\n16908551\t2.432\t0.175\t414\n16908552\t2.284\t0.062\t14\n16908559\t3.148\t0.384\t31\n16908806\t2.273\t0.193\t233\n16912417\t2.568\t0.286\t226\n16912418\t2.384\t0.277\t52\n16912419\t2.383\t0.526\t37\n16912436\t2.868\t0.102\t3\n16912437\t3.175\t0.376\t43\n16912646\t2.247\t0.155\t563\n16912647\t2.196\t0.137\t13\n16912655\t2.8\t0.063\t13\n16912902\t1.902\t0.429\t4\n16912903\t2.164\t0.088\t7\n16916514\t2.705\t0.288\t257\n16916515\t2.826\t0.329\t129\n16916532\t3.054\t0.385\t17\n16916533\t3.596\t0.24\t25\n16916742\t2.215\t0.127\t1635\n16916743\t1.989\t0.141\t55\n16916751\t2.686\t0.173\t226\n16916752\t2.64\t-1.0\t1\n16916998\t2.197\t0.154\t196\n16920611\t3.015\t0.264\t187\n16920628\t3.279\t0.255\t239\n16920629\t3.195\t0.403\t63\n16920838\t2.164\t0.108\t13670\n16920839\t2.524\t0.134\t43\n16920847\t2.176\t0.207\t50\n16920848\t2.785\t0.214\t9\n16921094\t2.117\t0.097\t16\n16990260\t3.228\t0.382\t40\n16990261\t3.606\t0.35\t107\n16990470\t2.49\t0.154\t812\n16990471\t2.273\t0.267\t50\n16990472\t3.042\t-1.0\t1\n16990479\t3.31\t0.124\t16\n16990726\t2.535\t0.253\t17\n16994357\t3.54\t0.331\t863\n16994566\t2.373\t0.134\t5123\n16994567\t2.597\t0.154\t114\n16994575\t3.258\t0.143\t18\n16994822\t2.308\t0.108\t265\n16994823\t2.683\t0.0\t2\n17846534\t1.807\t0.004\t6\n17850630\t1.686\t0.082\t194786\n17850631\t1.634\t0.082\t26774\n17850632\t1.542\t0.034\t5\n17850639\t2.101\t0.105\t7379\n17850640\t2.077\t0.073\t1123\n17850886\t1.624\t0.087\t18128\n17850887\t1.587\t0.111\t90\n17850896\t2.041\t0.093\t13784\n17854727\t1.605\t0.077\t739\n17854735\t1.988\t0.193\t481\n17854736\t2.01\t0.157\t103\n17854982\t1.518\t0.05\t118\n17854983\t1.299\t0.035\t2\n17854991\t2.079\t0.0\t2\n17854992\t1.872\t0.081\t564\n17858824\t1.212\t0.0\t2\n17887503\t2.816\t0.232\t70\n17887504\t2.775\t-1.0\t1\n17887750\t2.038\t0.159\t42\n17887760\t2.72\t0.033\t2\n17891600\t2.75\t0.187\t12\n17891856\t2.984\t-1.0\t1\n18899462\t1.586\t0.08\t708\n18899472\t2.099\t0.117\t10\n18940432\t2.57\t0.156\t5\n33611790\t2.862\t0.219\t107\n33611809\t3.023\t-1.0\t1\n33611810\t1.697\t0.952\t3\n33611828\t3.382\t-1.0\t1\n33612038\t2.267\t0.06\t19\n33612039\t2.076\t0.084\t9\n33612040\t2.213\t0.116\t7\n33612047\t3.299\t0.356\t32\n33612048\t2.829\t-1.0\t1\n33612294\t2.498\t0.086\t4\n33624117\t2.68\t0.0\t2\n33624326\t2.051\t0.166\t7\n33624328\t1.644\t0.085\t2970\n33685536\t3.587\t0.192\t22\n33685537\t3.362\t0.618\t7\n33685539\t2.768\t-1.0\t1\n33685766\t2.418\t0.096\t23\n33685767\t2.3\t-1.0\t1\n33685768\t1.911\t0.307\t75\n33685775\t3.061\t0.334\t74\n33685776\t3.159\t0.258\t11\n33686022\t2.244\t-1.0\t1\n33689633\t2.268\t0.368\t3\n33689634\t3.2\t0.0\t2\n33689653\t3.142\t0.113\t4\n33689862\t1.874\t0.13\t10\n33689863\t1.999\t-1.0\t1\n33689864\t2.138\t0.163\t58\n33689871\t2.766\t0.099\t11\n33689872\t2.702\t0.904\t6\n33693731\t3.211\t0.049\t4\n33693748\t3.96\t0.381\t8\n33693749\t3.32\t0.198\t7\n33693958\t2.081\t0.047\t6\n33693959\t2.112\t0.21\t9\n33693960\t1.88\t0.205\t162\n33693967\t2.503\t0.176\t332\n33697844\t3.872\t0.0\t2\n33698055\t1.967\t-1.0\t1\n33698056\t1.612\t0.028\t8\n33767476\t2.657\t-1.0\t1\n33767477\t3.446\t-1.0\t1\n33767686\t2.131\t0.005\t3\n33767687\t2.1\t-1.0\t1\n33767688\t2.267\t0.518\t6\n33767695\t2.857\t0.194\t7\n33767696\t3.719\t0.957\t3\n33771573\t3.614\t0.457\t10\n33771783\t2.249\t0.088\t5\n33771784\t2.127\t0.16\t106\n33771791\t3.098\t-1.0\t1\n33771792\t3.166\t0.428\t3\n34623750\t1.78\t0.012\t7\n34627846\t1.55\t0.083\t65623\n34627847\t1.486\t0.077\t27424\n34627848\t1.404\t0.071\t156637\n34627855\t2.044\t0.135\t373\n34627856\t1.945\t0.103\t4751\n34628102\t1.526\t0.109\t716\n34628112\t1.965\t0.141\t8\n34631943\t1.436\t0.08\t1641\n34631944\t1.371\t0.063\t17326\n34631951\t1.879\t0.175\t1347\n34631952\t1.901\t0.158\t89\n34632198\t1.396\t0.123\t200\n34632199\t1.374\t0.136\t116\n34632207\t2.095\t0.0\t2\n34632208\t1.812\t0.114\t109\n34636040\t1.131\t0.253\t79\n34636047\t1.751\t0.123\t5003\n34636048\t1.76\t0.092\t2467\n34636294\t1.228\t0.157\t96\n34636295\t1.111\t0.035\t20\n34636304\t1.661\t0.085\t34493\n34664719\t2.605\t0.159\t86\n34664720\t2.299\t0.162\t912\n34664966\t1.951\t0.174\t35\n34664967\t1.804\t0.217\t28\n34664975\t2.749\t0.0\t2\n34664976\t2.399\t-1.0\t1\n34668816\t2.417\t0.111\t4\n34669062\t1.893\t0.17\t143\n34669071\t2.291\t0.138\t2\n35676678\t1.475\t0.093\t37\n52453894\t1.376\t0.081\t8518\n52453895\t1.293\t0.068\t14577\n52453896\t1.593\t0.165\t45\n52453903\t1.768\t0.204\t5\n52457991\t1.263\t0.085\t581\n52458000\t1.392\t0.156\t3\n83914759\t1.547\t0.085\t5\n83915013\t1.739\t0.204\t7\n83915014\t1.572\t0.079\t50584\n83915015\t1.539\t0.074\t8699\n83915023\t1.977\t0.137\t53\n83919110\t1.558\t0.068\t8984\n83919111\t1.575\t0.101\t961\n83919119\t2.014\t0.019\t9\n83951650\t2.389\t0.04\t4\n83951878\t1.973\t0.109\t22593\n83951879\t1.799\t0.11\t991\n83951887\t2.464\t-1.0\t1\n83951888\t2.672\t0.158\t11\n84025378\t2.575\t0.005\t2\n84025606\t2.151\t0.135\t549\n84025607\t2.077\t0.132\t184\n84959494\t1.626\t0.085\t32317\n84959495\t1.575\t0.081\t14689\n84959503\t2.111\t0.074\t20\n84959504\t2.015\t0.127\t36\n84963591\t1.557\t0.073\t2345\n84963599\t1.935\t0.256\t2\n84963600\t2.2\t0.296\t11\n100802822\t2.071\t0.051\t5\n100802823\t1.97\t0.021\t4\n101732615\t1.731\t0.197\t7\n101736710\t1.567\t0.082\t49304\n101736711\t1.502\t0.079\t23379\n101736719\t2.028\t0.119\t39\n101736720\t1.978\t0.107\t31\n101740807\t1.481\t0.072\t2974\n101740815\t1.989\t0.139\t38\n101740816\t1.737\t0.078\t11\n101773584\t2.915\t0.094\t4",H))[0],t=zf.$Hb(e,Ot,I),vf.Bv=$l(Qf.Mmb,G,6,t,15,1),vf.Cv=$l(Qf.Lmb,Et,6,t,15,1),vf.Dv=$l(Qf.Lmb,Et,6,t,15,1),vf.Av=$l(Qf.Mmb,G,6,t,15,1),i=0;i<t;i++)if(s=n[i+1],4==(a=zf.AJb(s,"\t")).length)try{vf.Bv[i]=zf.$Hb(a[0],Ot,I),vf.Cv[i]=og(a[1]),vf.Dv[i]=og(a[2]),vf.Av[i]=zf.$Hb(a[3],Ot,I)}catch(n){if(sd(n=cd(n),54))break;throw bd(n)}vf.Fv=!0}},vf.Pv=function(n){var t,e,i,a;for(vf.Fv||vf.Ov(),a=Gn,i=hn,e=0;e<12;e++){if(0==(t=a>=vf.Bv.length||n<vf.Bv[a]?-1:n==vf.Bv[a]?0:1))return a;a=t<0?a-i:a+i,i=i/2|0}return-1},Ol(535,1,{},vf.Iv),vf.Fv=!1,Qf.Mnb=hd(535),vf.Qv=function(n,t){n.q=vf.Nw(new vf.Qw(n.o,t),n)},vf.Rv=function(t,e){var i,a,s,r,o,f,l,d,g;return i=vf.Xv(t,e[0]),a=vf.Xv(t,e[1]),s=vf.Xv(t,e[2]),r=vf.Xv(t,e[3]),l=new qf.Jh(a.a-i.a,a.b-i.b,a.c-i.c),d=new qf.Jh(s.a-a.a,s.b-a.b,s.c-a.c),g=new qf.Jh(r.a-s.a,r.b-s.b,r.c-s.c),o=new qf.Jh(l.b*d.c-l.c*d.b,-(l.a*d.c-l.c*d.a),l.a*d.b-l.b*d.a),f=new qf.Jh(d.b*g.c-d.c*g.b,-(d.a*g.c-d.c*g.a),d.a*g.b-d.b*g.a),-n.Math.atan2(n.Math.sqrt(d.a*d.a+d.b*d.b+d.c*d.c)*(l.a*f.a+l.b*f.b+l.c*f.c),o.a*f.a+o.b*f.b+o.c*f.c)},vf.Sv=function(n,t){return vf.Vv(n,t),vf.Bw(n.q,t.q)},vf.Tv=function(n,t){var e;for(e=0;e<t.q;e++)qf.Eh(n.k[e],t.J[e])},vf.Uv=function(n,t){var e;for(e=0;e<t.k.length;e++)qf.Eh(n.k[e],t.k[e]);null==t.j?n.j=null:n.j=Vf.mQb(t.j,t.j.length)},vf.Vv=function(n,t){var e;n.q&&t.q||(e=new vf.Pw(n.o),!n.q&&(n.q=vf.Nw(e,n)),!t.q&&(t.q=vf.Nw(e,t)))},vf.Wv=function(n,t){return null==n.j?-1:n.j[t]},vf.Xv=function(n,t){return n.k[t]},vf.Yv=function(n){return null==n.p?n.o.P:n.p},vf.Zv=function(n,t){return n.k[t].a},vf.$v=function(n,t){return n.k[t].b},vf._v=function(n,t){return n.k[t].c},vf.aw=function(n,t,e){for(null==n.j&&(n.j=$l(Qf.myb,at,6,n.o.r,15,1),Vf.rQb(n.j));e<0;)e=e+360<<16>>16;for(;e>=360;)e=e-360<<16>>16;n.j[t]=e},vf.bw=function(n,t,e){qf.Eh(n.k[t],e)},vf.cw=function(n,t,e){n.k[t]=e},vf.dw=function(n,t){n.p=t},vf.ew=function(n,t,e){n.k[t].a=e},vf.fw=function(n,t,e){n.k[t].b=e},vf.gw=function(n,t,e){n.k[t].c=e},vf.hw=function(n,t){var e;for(!t&&(t=qf.ru(n.o)),e=0;e<t.q;e++)qf.Eh(t.J[e],n.k[e]);return null!=n.p&&qf.Fm(t,n.p),t},vf.iw=function(n){var t;for(this.o=n,this.k=$l(Qf.dnb,wt,32,n.q,0,1),t=0;t<n.q;t++)this.k[t]=new qf.Kh(n.J[t]);this.n=NaN},vf.jw=function(n){vf.kw.call(this,n,n.o)},vf.kw=function(n,t){var e;for(this.o=t,this.k=$l(Qf.dnb,wt,32,n.k.length,0,1),e=0;e<this.k.length;e++)this.k[e]=new qf.Kh(n.k[e]);null!=n.j&&(this.j=Vf.mQb(n.j,n.j.length)),this.p=null==n.p||zf.oJb(n.p)?n.p:zf.lJb(n.p,J),this.n=NaN},Ol(79,1,{79:1,19:1},vf.jw),o.Eb=function(n){return vf.Sv(this,n)},o.n=0,Qf.Nnb=hd(79),vf.nw=function(n,t){var e,i,a,s,r;return null==t?null:(r=Vf.$Ob(n.c,t))?r:(i=Gf.zVb("<").length,(zf.pJb(Gf.zVb(t).substr(Gf.zVb(t).length-i,i),"<")||(a=Gf.zVb("-").length,zf.pJb(Gf.zVb(t).substr(Gf.zVb(t).length-a,a),"-")))&&(r=Vf.$Ob(n.c,(s=Gf.zVb("<").length,zf.pJb(Gf.zVb(t).substr(Gf.zVb(t).length-s,s),"<")?zf.DJb(t,0,Gf.zVb(t).length-1)+">":(e=Gf.zVb("-").length,zf.pJb(Gf.zVb(t).substr(Gf.zVb(t).length-e,e),"-")?zf.DJb(t,0,Gf.zVb(t).length-1)+"+":t))))?(r=new vf.ix(r),Vf.WSb(n.c,t,r),r):null)},vf.ow=function(n,t){var e,i,a,s,r,o,f,l,d,g,u,c,b,h,D,j,m,A,C;for(n.b|=t,m=zf.AJb("daD@h@\\H\\D\\L\\B\\Djfdrjj`Cj`XZV^[lgl|WjBp^C~RQdp\ndaDD`HP@cIICISKUT@]LCbURss\\bCPVCp_rPmV@\ndaDH@@RfzaJjjbHGWPhxdtl|yXEGDfgf}HDoTE`|G|dC]`<\ndaDH@@RfzaJjjbHGWPhxdtl|yqGDf}HDoTE`|G|dC]`<\ndaDH@@RfzaJjjbHGWPhxdtl|yqGDf}HDoTE`|G|dC]`>\ndaT@`@\\DjfjZn[jjjkJcKhGP`phxdtl|wY@xD`uyo]{|lKUfp\ndax@@DiU[zh@zHfegfzLG``\ndax@@DiYn`@@wHmumm}l=\ndax@@DiYn`@@wHmumm}t=\ndax@@DiYn`@@wHmumn}t=\ndax@@DiYn`@@wHmuum}t\ndax@@DiYn`@@wHmuun}t=\ndax@@DiYn`@@wHnuun}t=\ndax@@DiYn`h@zsEgfyEnmlG``=\ndax@@DiYnf@@zaJyEnnmom`=\ndax@@DiYnf@@zaJyEvnmom`=\ndax@@DiYnf@@zqDffyEv`mom`=\ndax@@DiYnf@@zqDffyEv`mon`\ndax@@DiYnf@@zqDff~TEm}l=\ndax@@DiYnf@@zqDff~Uyn}t=\ndax@@DiYnf@@zqDfjyEv`mom`=\ndax@@DiYnf@@zqDfj~TEm}l=\ndax@@Djfjjh@zDFEGDfegf{HG@dF`lG``\ndax@@Djfjjh@zDFEGDfeggI@phdwY@xD`tE`|D\ndax@@Djfjjh@zDFEGDfeggM@phdtwY@xD`tE`|D\ndax@@Djfjjh@zDFEGDfeggN@pdwY@xD`tE`|D\ndax@@Djfjjh@zDFEGDfeggN@plwY@xD`tE`}x\ndax@@Djfjjh@zDFEGDjegj{HG@dF`lG``\ndax@@DjfjjjHP]BCBcbSRssd`XRV[l`\\BPZBp^|>\ndax@@DjfjjjHP]BCBcbSRsug@XR[l`\\BPZBp^B<\ndax@@DjfjjjHP]BCBcbSRsug@XR[l`\\BPZBp^B>\ndax@D@bH\\DbL\\B\\JbFbN\\Dfnjjh@zRGGNHxlwPo]x\ndax@H@\\H\\D\\J\\Djfjjh@zXFGDegf{I{@dFoLG``\ndax@H@\\H\\D\\J\\Djfjjh@zXFGDeggN@pdwYOXD`uy`|D\ndax@H@\\H\\D\\L\\Djfjjh@zXFDfegf{I{ODF`lG``\ndax@H@\\H\\J\\F\\Djfjjh@zXFEGDgj{HG@dFoM{``\ndax@H@\\J\\F\\N\\Djfjjh@zhFEGDf{HG@dFoM{o@\ndax@H@\\J\\F\\N\\Djfjjh@zhFEGDf}HG@dFoMx\ndax@H@dDdJdFdDfnjjh@zJGDgfzDGo@\ndax@H@dDdJdFdDfnjjh@zJGDgfzE{o@\ndax@H@dDdJdFdDfnjjh@zJGDggNHxlwP`|D\ndax@H@dDdJdFdDfnjjh@zJGDggNHxlwPo]x\ndax@H@dDdJdFdDfnjjh@zJGDkfzDGo@\ndax@H@dDdJdFdDfnjjh@zJGDkgNHxlwP`}x\ndax@H@dDdJdFdDfnjjh@zJGDkjzDG``\ndax@H@dDdLdJdLbdLeUT@]EBRss]F}w`\ndax@H@dDdLdJdLbdLeUUAPNbaIZyncA{p<\ndax@H@dDdLdJdLbdLeUUAPNbaIZyncA{p>\ndax@P@BFBDiuZ{h@zHEEgfzHG``\ndax@P@QFQDiuZ{h@zHEEgfzHG``\ndax@P@\\H\\Djfjjh@zDFEGDfegf{HG@dF`lG``\ndax@P@\\H\\Djfjjh@zDFEGDjegj{HG@dF`lG``\ndax@P@\\H\\Djnjjh@zxEGDfegf{Q{@dF`lG``\ndax@P@\\H\\Djnjjh@zxEGDfegf{Q{OEz`lG``\ndax@P@\\H\\Djnjjh@zxEGDfegf}YxoTE`|D\ndax@P@\\H\\Djnjjj@P]\\BcbSRss]h}`R}PVCpP<\ndax@P@\\H\\Djnjjj@P]\\BcbSRss]h}`R}PVCpP>\ndax@P@\\H\\Djnjjj@P]\\BcbSRss^lBWjBp^B<\ndax@P@\\H\\Djnjjj@P]\\BcbSRss^lBWjBp^B>\ndax@Q@|Bh@dnRjZjj`Ck`XT\\ZV^[t`\\CPVCpP\ndax@R@BH|HeIijjj@NnaQqIiYyoV^KuAXOA@\ndax@R@QH|HeIijjj@NnaQqIiYyoV^KuAXOA@\ndax@R@\\H\\HyJkjjj@NnAQqIiYyoV^KuAXOA@\ndax@X@\\H\\D\\L\\B\\J\\Djfjjh@zHFEgf{I{OEzoLG``\ndax@X@\\H\\D\\L\\B\\J\\Djfjjh@zHFEggI@phdwYOYxoUy`|D\ndax@X@\\H\\D\\L\\B\\J\\Djfjjh@zHFEggN@pdwYOYxoUy`|D\ndax@X@kDdLdJkFdNdLbdLeUT@]IBR\ndax@`@BDf]j^@@zbJyAoMmom`=\ndax@`@BDf]j^@@zbJyAoNmom`=\ndax@`@BDf]j^@@zbJyAoNmwn`=\ndax@`@\\Df]j^@@zRGFyA{Nmom`=\ndax@`@\\Djfjjh@zDFEGDfegf{HG@dF`lG``\ndax@`@\\Djfjjh@zDFEGDfegf{HG@ez`lG``\ndax@`@\\Djfjjh@zDFEGDjegf{HG@dF`lG``\ndax@`@\\Djfjjh@zDFEGHjegf{HG@dF`lG``\ndax@`@\\Djfjjh@zDFEKHjegf{HG@dF`lG``\ndax@`@\\LddUUUr@]LBcbRss\\dC`RCwP\ndax@`@dDffjjjHP]]BcbSRssgHTR[u`RCPVCpP<\ndax@b@|@eJijjj@NaAaQqIiYynrApI^hKAxH\ndax@b@|@eJijjj@NaAaQqIiYynrAsq^hKAxH\ndax@b@|@eJijjj`DGP`phyDtl|wY@xDoTE`|D<\ndax@b@|@eJijjj`DGP`phyDtl|wY@xDoTE`|D>\ndax@h@BDdLdJdFdLbdLeUT@]YBSs]@}w`\ndax@h@\\H\\D\\L\\B\\Djfjjh@zhFFegf{I{OEz`lG``\ndax@h@\\H\\D\\L\\B\\Djfjjh@zhFFegf{I{OEz`lG`ddEB\ndax@h@\\H\\D\\L\\B\\Djfjjh@zhFFegf}I{OTE`|D\ndax@h@\\H\\D\\L\\J\\Djfjjh@zhFDegf{I{ODFoLG``\ndax@h@\\H\\D\\L\\J\\Djfjjh@zhFDeggI@phdwYOYx`uy`|D\ndax@h@\\H\\D\\L\\J\\Djfjjj@P]TCBRssg@XR[lgl|PZ|p^B<\ndax@h@\\H\\D\\L\\J\\Djfjjj@P]TCBRssg@XR[lgl|PZ|p^B>\ndax@h@dDdLdJdFdLbdLeUT@]YBSs^NB\ndax@h@dDdLdJdFdLbdLeUT@]YBSs^N|\ndax@h@dDdLdJdFdLbdLeUT@]YBSu^NB\ndax@h@kDdLdJdFdLbdLeUT@]YBSs^N|\ndax@p@\\H\\D\\Djfjjh@zxFGDfegf{I{@dF`lG``\ndax@p@\\H\\D\\Djfjjh@zxFGDfegj{I{@dF`lG``\ndax@p@\\J\\F\\Djfjjh@zXFEGDgf{HG@dFoM{``\ndax@p@\\J\\F\\Djfjjh@zXFEGDgj{HG@dFoM{``\ndax@p@\\J\\F\\DjfjjjHP]LCBcbSs^dC`RCWnB<\ndax@p@\\J\\F\\DjfjjjHP]LCBcbSs^dC`RCWnB>\ndax@p@dDdLdLbdLeUT@]UBSRss_JBp^B\ndax@p@dDdLdLbdLeUT@]UBSRss_JBp^|\ndax@p@dDdLdLbdLeUT@]UBSRsu_JBp^B\ndax@p@dDdLdLbdLeUT@]UBSRuu_JBp^B\ndax@p@dDdLdLbdLeUT@]UBSTus_JBp^|\ndax@p@|D\\L\\DffjjjHP]MBbSRss^l|PZBp^B<\ndax@p@|D\\L\\DffjjjHP]MBbSRss^l|PZBp^B>\ndaxB@@RfRZzjjdaX`zJGDggN@hdwP`|D<\ndaxB@@RfRZzjjdaX`zJGDggN@hdwP`|D>\ndaxBRHSFCpkpslddlcUT`HdGV@d|wRo\\D>\ndaxB`HSJCprRRrMUPAtPIKOMtXOA@\ndaxD@@QIkjjj@NfaqIiYysbNIMrHMAXOA@\ndaxD@@QIkjjjbDGSPxdtl|yHEGDfyDF`lG``<\ndaxD@@QImYk`@Nhanc[{X=\ndaxD@@iIijjj@NfaQqIYynVAHKAxH\ndaxD@@iIijjj@NfaQqIYysTJNMKMrpIAXOA@\ndaxD@@iIijjjRDbCihT\\RV^\\yBcS\\lBPVCpP\ndaxD@@iIijjjRDdCihT\\RV^\\yBbs\\lBPVCw`>\ndaxD@@iIijjjRDdCihT\\RV^\\yBcS\\lBPVCpP<\ndaxD@@yIUVnz@NdaY@\ndaxDHHP@biAiCiCIICHmU@GV@xdw```\ndaxDPHP@b`cIICHmU@GU@xeL|wH`uy`|D\ndaxD`HP@cIICHmU@GS@xdtl|wH`tE`|D\ndaxD`HP@cIICHmU@GS@xeTl|wH`tE`|D\ndaxD`HPGCIICIUU@GS@xdtl|wHoTE`|D\ndaxDpJXIAICICHiCIUU@GVPd|wc``\ndaxDpJXIAICICHiCIUU@GVPd|wco@\ndaxH@@RYvjxHaAtdNM|pK[{X+\ndaxH@@RZZjj`CkhT\\RZV^[u`RCPVCpP\ndaxH@@RZZjj`CkhT\\RZV^\\lCBcbSS^lBPZBp^B\ndaxH@@RZZjj`CkhT\\RZV^\\uBcbSS^lBPZBp^B\ndaxH@@RZZjj`CkhT\\RZV^lmBcbSRs^lBPZBp^B\ndaxH@@RZZjjhQAutJNIMKONZaQqIYoVAHMAXO^@<\ndaxH@@RZZjjhaAutJNIMKONVAaQqIioVAKuAXOA@<\ndaxH@@RZZjjhaAutJNIMKONZAaQIioVAHMAXOA@<\ndaxH@@RZZjjhaAutJNIMKONZaQqIioVAKuAXOA@>\ndaxH@@RZZjjhaAutJNIMKON\\aQIoVAHMAXOA@<\ndaxH@@RZZjjhaAutJNIMKON\\aQIoVAHMAXOA@>\ndaxH@@RZZjjhaAutJNIMKON\\aQYoVAHMAXO^@>\ndaxH@@RZZjjhaAutJNIMKON\\aqIoVAKuAXOA@<\ndaxH@@RZZjjhaAutJNIMKON\\aqIoVAKuAXOA@>\ndaxH@@RZZjjhaAutJNIMKON\\aqYoVAKuAXO^@<\ndaxHHBApapQpqpRjZjj`Cj`XZV^[tgl}PVCpP\ndaxHPJBPRPRZzjjhrAuTNIKWM|KsA{p<\ndaxHPJBPRPRZzjjhrAuTNIKWM|KsA{p>\ndaxH`HApRjzjj`Ck`T\\RZV^[u`RCPVCpP\ndaxH`HApRjzjj`Ck`T\\RZV^[ugb}PVCpP\ndaxH`HApRjzjj`Ck`T\\bjV^[u`RCPVCpP\ndaxH`HApRjzjjhAAupJNIMKOMzpI^hKAxH<\ndaxH`HApRjzjjhAAupJNIMKOMzpI^hKAxH>\ndaxH`JBHRZZjjhaAttJNIKONRaQiYnVAHKAxH>\ndaxHpJBHRHrHrJPrUUPAtTIKOMtXOA@\ndaxHpJBPRPrPrJPrUUPAtTIKOMtXOA@\ndaxHpJBPRPrPrJPrUUPAtTIKOMt[w^@\ndaxHpJBPRPrPrJPrUUTE@zJDegfzLGo@<\ndaxHpJBPRPrPrJPrUUTE@zJDegfzLGo@>\ndaxHpJBPRPrPrJPrUUTE@zJDegjzLG``<\ndaxHpJBPRPrPrJPrUUTE@zJDegjzLG``>\ndaxHpJBPRPrPrJPrUUTE@zJDekfzLGo@<\ndaxHpJBPRPrPrJPrUUTE@zJDekfzLGo@>\ndaxL@@RdfnjjjHP]UCbRsse`T\\RZV[xPVCpP<\ndaxLHHS@BJdFdNdLddlbuT@]HBR\ndaxLJHS@BJdFdNdL{IIKHmU@GR@d`\ndaxL`HS@\\LddleUT@]TBSRss_JBp^B\ndaxLhJ[`\\H\\D\\L\\B\\Djfjjh@zPFF~I{OEx\nday@@@QIkjjj@NfaqIiYysPLJIMMrHMAXOA@\ndayDaLJD@HrR{IICHmU@GU@xtl|wr`lG``\ndaz@@@RYvHx@C\\`wfvwvp=\ndaz@@@RYvHx@C\\`wfvwwP\ndaz@@@RYvHx@C\\`wgVwvp=\ndaz@@@RYvix@CjHkdF|zv~v=\ndaz@@@RYvix@CjHkdG\\zv~v=\ndaz@B@BTf]bN@@wHMymm}t\ndaz@HBApapQpqpRjZjj`Cj`XZV^[tgl}PVCpP\ndaz@bHCpBTjnjjh@zxEGDfegf}YxoTE`|D\ndaz@pJBPRPrPrJPrUUPAtTIKOMtXOA@\ndaz@pJBPRPrPrJPrUUTE@zJDegjzLG``>\ndazDHLa@BJdFdNdLddlbuT@]HBR\ndazDJLa@BJdFdNdL{IIKHmU@GR@d`\ndazD`La@BLddlbuT@]TBSRss_JBp^B\ndazH`D`OCIICHuUPBCi`\\RZV^[dWjBp^B<\ndazH`D`OCIICHuUPBCi`\\RZV^[dWjBp^B>\ndazHpFhIAICICHiCIUUPRCkHR^[qpP<\ndazHpFhIAICICHiCIUUPRCkHR^[qpP>\ndazLQFaLCpkpsfgIIKHuUHBIAu`IOMtkwA@<\ndazLQFaLCpkpsfgIIKHuUHBIAu`IOMtkwA@>\ndctD@@gHiDTeIU]uPAttNIHjnmrpIATNa@\ndctD@@gHiDTeIU]uPAttNQPjvurpIATNa@\nded@@DiUfoh@@Mr[_[G\\{@=\nded@@DiUfoh@@Mr[_]G\\}@\nded@P@\\F\\LddUTeUuPAtHJNIKOHlmvPNAHOADLa@\ndedD@@{HiDUIU]T@]MCdTrMM\\lBPQCHP\ndiD@@DiYkhJ`ChlV^Q[tVzvp^BHP=\ndiD@@DiYkhJ`ChlV^Q[tVzzp^BHP\ndiD@@DiYkhJ`ChlV^aktVzvp^BHP=\ndiD@@DiYkhJ`ChlVnaktVzvp^BHP=\ndiD@@DiYkhJ`ChlVnaktVzzp^BHP\ndiD@H@\\H\\D\\L\\LddjTjn@@z`F}QyOY{nct=\ndiD@`@\\LddUTjn@@zHEGDf}HG@dGmcl=\ndiD@`@\\LddUTjn@@zHEGDf}HG@dGmct\ndiD@`@\\LddUTjn@@zHEGDf}HG@dGnct=\ndiD@`@\\LddUTjnX@zhEGDej}HG@dGnct\ndiD@`@\\LddUTjnX@zxEGDegdV}HG@dGnbD\ndiD@`@\\LddUTjnX@zxEGDegdZ}HG@dGnbD\ndiDH@@rJQERjx@CkH\\R[e`RCvqv=\ndiDH@@rJQERjx@CkH\\R[e`RCvqz\ndiDH@@rJQERjx@CkH\\bke`RCvqv=\ndiDH@@rJQERjx@CkH\\bke`RCvqz\ndiDH@@rJQERjxHaAudNIMrpI^{X{@+\ndiDH@@rJQERjxHaAudNIMrpI^{X{@-\ndiDH@@rJQERjxHaAudNIMrpI^{X}@<\ndiDH@@rJQERjy`Cih\\RV^Q[y`RBO`\ndiDH@@rJQERjy`Cih\\bf^Q[e`RCwQB\ndiF@@@rJQERjx@CkH\\R[e`RCvqv=\ndiF@`NAprRQURjx@Ch`T\\R[t`\\BP^vNp\ndiF@a@b`BX{HiDUJk`@NlarJnVAHO[Gh\ndiFH@NCHiDUJk`@NlaqInVAHO[GX\ngC`@Die@zHXir\ngC`@Die@zHXis]Knz\ngC`@Die@zHXis^Kh\ngC`@Die@zHXisgAbd\ngC`@Die@zHXisgAbfzW]t\ngC`@Die@zHXisgAbf|WP\ngC`@Dij@zHXis]HNB\ngC`@Dij@zHXis]HN|\ngC`@Dij@zHXis]Kv|\ngC`@Dij@zHXisgAbfzP\\D\ngC`@Dij@zHXisgAbfzP]x\ngC`@Dij@zHXisgAbfzWmx\ngC`@Dij@zHXiu]HNB\ngC`@Dij@zHXiugAbfzP\\D\ngC`@Dij@zHXjs]HN|\ngC`@Dij@zHXjsgAbfzP]x\ngC`@Dij@zHXju]HNB\ngC`@Dij@zHXjugAbfzP\\D\ngC`@DkZ@zHXis]SnB\ngC`@DkZ@zHXis]Sn|\ngC`@DkZ@zHXis^XH\ngC`@DkZ@zHXis^[p\ngC`@DkZ@zHXisgAbfzg\\D\ngC`@DkZ@zHXisgAbfzg]x\ngC`@DkZ@zHXisgAbf|pP\ngC`@DkZ@zHXisgAbf|w`\ngC`@DkZ@zHXiu]SnB\ngC`@DkZ@zHXiu^XH\ngC`@DkZ@zHXiugAbfzg\\D\ngC`@DkZ@zHXiugAbf|pP\ngC`B@DPHPQ`aJZ`NdFH\ngC`B@DPHPQ`aJZ`NdFN\\FJP\ngC`B@DPHWaoAJZ`NdFMto[p\ngC`D@DPHRfhChabgMt`xH\ngC`D@DPHRfhChabgN\\FJ[iApP\ngC`D@DPHRfhChabgN\\FJ[i^w`\ngC`D@DPHRfhChabkUt`xH\ngC`D@DPHRnhCkASf|pP\ngC`D@DPHRnhCkASj|pP\ngC`D@DXHRVhCiQR\ngC`D@DXHRVhCiQSgAbd\ngC`D@DXHRfhCkAbf|PP\ngC`D@DXHRfhCkAbgNCEMx``\ngC`D@DXHRfhCkAbj|PP\ngC`D@DYpRVhCiQS]Cv|\ngC`D@VPlRfhChabkUt`xH\ngC`D@VYpRfhCkAbfzP]x\ngC`D@bQDRfhChabgMt`xH\ngC`D@bQDRfhChabkUt`xH\ngC`D@bSpRnhCkASfzglD\ngC`D@xYpRVhCiQS]Cv|\ngC`D@xYpRVhCiQSgAbfzGmx\ngC`DABPHRVhCkQSj|pP\ngC`DADZHRVhCiQR\ngC`DAb[DRVhCiQR\ngC`DAx[pRVhCiQR\ngC`DAx[pRVhCiQS]Cv|\ngC`Dax[pDzTej@zTTwP}o@\ngC`H@DIKRAuhir\ngC`H@DIKTAuhis]CvB\ngC`H@DIKTAuhis^XH\ngC`H@DIKTAuhis^[p\ngC`H@DIKTAuhisgAbfzGlD\ngC`H@DIKTAuhisgAbf|pP\ngC`H@DIKTAuhisgAbf|w`\ngC`H@DIKTAuhiu]CvB\ngC`H@DIKTAuhiu^XH\ngC`H@DISRAtPqSfzP]t\ngC`H@DISRAtPqSf|PP\ngC`H@DISRAtPqSgNCEMt`{h\ngC`H@DISRAtPqSgNCEMx``\ngC`H@DISRAtPqUfzP]t\ngC`H@DISRAtPqUgNCEMt`{h\ngC`H@DISTAtPqSfzP\\D\ngC`H@DISTAtPqSfzP]x\ngC`H@DISTAtPqSfzWlD\ngC`H@DISTAtPqSgNCEMt`xH\ngC`H@DISTAtPqSgNCEMt`{p\ngC`H@DISTAtPqSgNCEMtoXH\ngC`H@DISTAtPqSjzP\\D\ngC`H@DISTAtPqSjzWlD\ngC`H@DISTAtPqSkNCEMt`xH\ngC`H@DISTAtPqUfzP\\D\ngC`H@DISTAtPqUfzP]x\ngC`H@DISTAtPqUgNCEMt`xH\ngC`H@DISTAtPqUjzP\\D\ngC`H@VIKTAuhis]CvB\ngC`H@bIKTAuhis^XH\ngC`H@bISRAtPqSf|PP\ngC`H@bISTAtPqSfzP\\D\ngC`H@bISTAtPqSgNCEMt`xH\ngC`H@bISTAtPqSjzP\\D\ngC`H@bISTAtPqUfzP\\D\ngC`H@bISTAtPqUjzP\\D\ngC`H@xIKRAuhis^Cp\ngC`H@xIKTAuhis]CvB\ngC`H@xIKTAuhis]Cv|\ngC`H@xIKTAuhis^XH\ngC`H@xIKTAuhisgAbfzGlD\ngC`H@xIKTAuhiu]CvB\ngC`HADIKTAuhis^XH\ngC`HAVIKTAuhis^XH\ngC`HAbIKTAuhis^XH\ngC`HAxIKTAuhis]CvB\ngC`HAxIKTAuhis^XH\ngC`HAxIKTAuhisgAbfzGlD\ngC`HAxIKTAuhiu]CvB\ngC`HMPISTAu`qS]HN|\ngC`HMPISTAu`qS^HH\ngC`IAVBTii@zHXjs]HNz\ngC`IAxBTej@ztTyna{A@\ngC`IAxBTej@ztTys`qS]CvB\ngC`IMP[dij@zpXindG^@\ngC`L@DPHPPeMPGVCGMy``\ngC`L@DPHPPeMPGVCGMyo@\ngC`L@DPHPPeMPGVCGUy``\ngC`L@DPHPPeMPGVCGV\\FJ[sA@\ngC`L@VPHPPeMPGVCGMy``\ngC`L@bPHPPeMPGVCGMy``\ngC`PAEdij@zPXypXi@\ngC``@deZ@ztTyoLD\ngC``ADij@zHXis]HN|\ngC``ADij@zHXis]Kv|\ngC``ADij@zHXisgAbfzP\\D\ngC``ADij@zHXisgAbfzP]x\ngC``ADij@zHXisgAbfzWmx\ngC``Adej@zTT`\ngC``Adej@zTTypXi@\ngC``Adij@zpXioDD\ngC``Adij@zpXioEx\ngC``Adij@zpXis`qS^HH\ngC``Adij@zpXjoDD\ngC``Adij@zpXjs`qS^HH\ngC`hH`xIKTAuhis]Cv|\ngCa@@dkHGVbgH\ngCa@@dkHGVbgMyn`\ngCa@@dkPGVbgMy``\ngCa@@dmHGVbgH\ngCa@@dmHGVbgMyn`\ngCa@@dmHGVbgN\\FJP\ngCa@@dmHGVbgN\\FJ[s]@\ngCa@@dmPGVbgMy``\ngCa@@dmPGVbgMyo@\ngCa@@dmPGVbgN\\FJ[sA@\ngCa@@dmPGVbgN\\FJ[s^@\ngCa@@dmPGVbgUy``\ngCa@@dmPGVbgV\\FJ[sA@\ngCa@@eMHGQCEN[iAwP\ngCa@@eMHGQCEN[qA@\ngCa@@eMHGQCEN[q^@\ngCa@@eMHGQCEN\\xLTwRCn`\ngCa@@eMHGQCEN\\xLTwbB\ngCa@@eMHGQCEV[iAwP\ngCa@@eMHGQCEV\\xLTwRCn`\ngCa@@eMHGQCEV\\xLTwbB\ngCa@@eMPGQCEN[iApP\ngCa@@eMPGQCEN[iAw`\ngCa@@eMPGQCEN[i^pP\ngCa@@eMPGQCEN[i^w`\ngCa@@eMPGQCEN\\xLTwRC``\ngCa@@eMPGQCEN\\xLTwRCo@\ngCa@@eMPGQCEN\\xLTwR}``\ngCa@@eMPGQCEN\\xLTwR}o@\ngCa@@eMPGQCENkiApP\ngCa@@eMPGQCENki^pP\ngCa@@eMPGQCENlxLTwRC``\ngCa@@eMPGQCENlxLTwR}``\ngCa@@eMPGQCEV[iApP\ngCa@@eMPGQCEV[iAw`\ngCa@@eMPGQCEV\\xLTwRC``\ngCa@@eMPGQCEV\\xLTwRCo@\ngCa@@eMPGQCEVkiApP\ngCa@@eMPGQCEVlxLTwRC``\ngCaH@jAJZ`NlFN[i^pP\ngCaH@jAJZ`NlFN\\xLTwR}``\ngCaH@jAJZ`NlFN\\xLTwfB\ngCaH@jAJZ`NlFN\\xLTwf|\ngCaHDGAIZ`NmEN[h^pP\ngCaHH@aIZ`NmEN[h^pP\ngCaHH@aIZ`NmEN[h^w`\ngCaHH@aIZ`NmEN\\xLTwP}``\ngCaHHGAIZ`NmEN[h^pP\ngCaHHGAIZ`NmEN[h^w`\ngCaHHGAIZ`NmEN\\xLTwP}``\ngCaHHGAIZ`NmENkh^pP\ngCaHHOAIZ`NmEN[h^pP\ngCaHHOAIZ`NmEN[h^w`\ngCaHHOAIZ`NmEN[sA@\ngCaHHOAIZ`NmEN\\xLTwP}``\ngCaHHOAIZ`NmEN\\xLTwP}o@\ngCaHHOAIZ`NmEN\\xLTwf|\ngCaHHOAIZ`NmENkh^pP\ngCaHHOAIZ`NmENlxLTwP}``\ngCaHL@aIZ`NeEH\ngCaHL@aIZ`NeEN\\FJP\ngCaHLDQIZ`NeEH\ngCaHLGAIZ`NeEMxO@\ngCaHLHaIZ`NeEH\ngCaHLLQIZ`NeEH\ngCaHLOAIZ`NeEMxO@\ngCaI@jA\\eMPGVCGMtoXH\ngCaIHO@RdmPGVbgMtOXH\ngCaIHO@RdmPGVbgN\\FJ[h^pP\ngCaIL@`RdmPGRbd\ngCd@@deZ@ztTyoLG}h`\ngCd@@deZ@ztTys`qS^XO{Q@\ngCd@@deZ@ztTzoLG}h`\ngCd@@deZ@ztTzs`qS^XO{Q@\ngCd@ADie@zHXis]Kn{~rD@\ngCd@ADie@zHXis^Ko{HP\ngCd@ADie@zHXisgAbfzW]w}dH\ngCd@ADie@zHXis~rD@\ngCd@ADif@zHXis]KnC~rD@\ngCd@ADif@zHXis^XO{HP\ngCd@ADif@zHXisgAbfzW\\G}dH\ngCd@ADif@zHXisgAbf|p_vP`\ngCd@ADif@zHXiu]KnC~rD@\ngCd@ADif@zHXiu^XO{HP\ngCd@ADij@zHXis]HNC~rD@\ngCd@ADij@zHXis]HNC~t@\ngCd@ADij@zHXiu]HNC~rD@\ngCd@ADij@zHXju]HNC~rD@\ngCd@ADkj@zpTzoLD\ngCd@AdeY@zTT`\ngCd@Adej@zTT`\ngCd@Adej@zTTypXi@\ngCd@Adij@zpXioDG}h@\ngCd@Adij@zpXis`qS^HO{P@\ngCd@Adij@zpXjoDG}h@\ngCd@Adij@zpXjs`qS^HO{P@\ngCd@aAteJz`NlEN[sAZ@\ngCd@aAteJz`NlEN[s^Z@\ngCd@aaNeIZ`NeEH\ngCd@aaNeIZ`NeEN\\FJP\ngCd@aaNeIZ`NeEN\\FJ[h^w`\ngCd@aaNeIZ`NeEN\\FJ[p^@\ngCdAAIrTs@]DLTznewAYB@\ngCdAAaJRu@]JJP\ngCdAAaJRu@]JJ[p^@\ngCdAAaJRu@]JJ\\xLT`\ngCdAAaJRu@]JJ\\xLTw`|\ngCdDE`DPHRfhCiAb\ngCdHH`DIKRAuhis]Cv{~rb@\ngCdHH`DIKRAuhis^Cw{JH\ngCdHI`DIKTAthis`qS^Cw{R@\ngCe@E`dkPGRbg}h`\ngCh@@dkHGVbgH\ngCh@@dkPGVbgMy``\ngCh@@dmHGVbgH\ngCh@@dmHGVbgMyn`\ngCh@@dmHGVbgN\\FJP\ngCh@@dmHGVbgN\\FJ[s]@\ngCh@@dmPGVbgMtOXH\ngCh@@dmPGVbgMy``\ngCh@@dmPGVbgMyo@\ngCh@@dmPGVbgN\\FJ[h^pP\ngCh@@dmPGVbgN\\FJ[sA@\ngCh@@dmPGVbgN\\FJ[s^@\ngCh@@dmPGVbgUy``\ngCh@@dmPGVbgV\\FJ[sA@\ngCh@@eLhGQCEN\\xLTwR{nm@\ngCh@@eLhGQCEN\\xLTwb{~t@\ngCh@@eMHGQCEN[iAw_v`@\ngCh@@eMHGQCEN[i^w_v`@\ngCh@@eMHGQCEN[qAZ@\ngCh@@eMHGQCEN\\xLTwRCnm@\ngCh@@eMHGQCEN\\xLTwbC~t@\ngCh@@eMHGQCEV[iAw_v`@\ngCh@@eMHGQCEV[qAZ@\ngCh@@eMPGQCEN[iApP\ngCh@@eMPGQCEN[iAp_v`@\ngCh@@eMPGQCEN[iAw`\ngCh@@eMPGQCEN[iAwov`@\ngCh@@eMPGQCEN[i^pP\ngCh@@eMPGQCEN\\xLTwRC``\ngCh@@eMPGQCEN\\xLTwRC`m@\ngCh@@eMPGQCEN\\xLTwRCo@\ngCh@@eMPGQCEN\\xLTwRCo_m@\ngCh@@eMPGQCEN\\xLTwR}``\ngCh@@eMPGQCENkiApP\ngCh@@eMPGQCENkiAp_v`@\ngCh@@eMPGQCENki^pP\ngCh@@eMPGQCENlxLTwRC``\ngCh@@eMPGQCEV[iApP\ngCh@@eMPGQCEV[iAp_v`@\ngCh@@eMPGQCEV[iAwov`@\ngCh@@eMPGQCEV\\xLTwRC``\ngCh@@eMPGQCEV\\xLTwRC`m@\ngCh@@eMPGQCEVkiApP\ngCh@@eMPGQCEVkiAp_v`@\ngCh@@e[PGQCEN[j]p_v`@\ngCh@@e[PGQCEN[sAZ@\ngCh@@e[PGQCEN[s^Z@\ngCh@@e[PGQCEN\\xLTwT{`m@\ngCh@@e[PGQCENkj]p_v`@\ngCh@@e[PGQCENksAZ@\ngCh@@e[PGQCENlxLTwT{`m@\ngChA@IRUdCkQSf|GP\ngChA@IRVdCkQSd\ngChA@IRVhCkQSfzGlD\ngChA@IRVhCkQSf|pP\ngChA@IRVhCkQSf|w`\ngChA@IRVhCkQSgNCEMtOXH\ngChA@IRVhCkQSgNCEMy``\ngChA@IRVhCkQSgNCEMyo@\ngChA@IRVhCkQSj|pP\ngChA@IRVhCkQSkNCEMy``\ngChA@IRfhChabgMt`xH\ngChA@IRfhChabgMt`{p\ngChA@IRfhChabgMtoXH\ngChA@IRfhChabgN\\FJ[iApP\ngChA@IRfhChabgUt`xH\ngChA@IRfhChabgUtoXH\ngChA@IRfhChabgV\\FJ[iApP\ngChA@IRfhChabkUt`xH\ngChA@IRmhChabgMuNxO{P@\ngChA@IRmhChabgMy`m@\ngChA@IRmhChabgN\\FJ[j]p_v`@\ngChA@IRmhChabgUuNxO{P@\ngChDD@bABUt`]XJ\\wf{~tP\ngChDDDRHbUt`]XJ\\wf{~tP\ngChHD@aIZ`NmEN[h^p_vb@\ngChHDOAIZ`NmENkh^p_vb@\ngChHH@aIZPNmEN[h^w_vd@\ngChHH@aIZ`NmEN[h^p_vd@\ngChHH@aIZ`NmEN[h^wovd@\ngChHH@aIZ`NmEN\\xLTwP}`mH\ngChHH@aIZ`NmENkh^p_vd@\ngChHH@aJZPNbFJlypXindG]ZP\ngChHHOAIZ`NmEN[h^p_vd@\ngChHHOAIZ`NmEN\\xLTwP}`mH\ngChHHOAIZ`NmENkh^p_vd@\ngChHL@aIZ`NeEH\ngChHL@aIZ`NeEMxO@\ngChHL@aIZ`NeEN\\FJP\ngChHL@aJZ`NlFJ[qA@\ngChHL@aJZ`NlFJ\\xLTwbB\ngChHLHaIZ`NeEH\ngChHLLQIZ`NeEH\ngChHLOAIZ`NeEH\ngChIDOARdmPGVbgMtOXH\ngChIHOBRdkPGVbgMy`mH\ngChIL@cRdmPGRbd\ngChIL@cRdmPGRbf|G`\ngChILLSRdmPGRbd\ngCh`LHe]PGRBd\ngCi@DDeZ@ztTyoLG}h`\ngCi@DDeZ@ztTyoM{}h`\ngCi@DDeZ@ztTzoLG}h`\ngCi@HDii@zHXis]HN{~t`\ngCi@HDii@zHXis^HO{R@\ngCi@HDii@zHXisgAbfzP]w}i@\ngCi@HDii@zHXjs]HN{~t`\ngCi@HDij@zHXis]HNB\ngCi@HDij@zHXis]HNC~t`\ngCi@HDkj@zpTyoLD\ngCi@HDkj@zpTyoMx\ngCi@HDkj@zpTys`qS^XH\ngCi@HDkj@zpTzoLD\ngCi@LDej@zTT`\ngCi@LDej@zTTypXi@\ngCi@LDej@zTTypXioMx\ngCi@LDij@zpXioDD\ngCi@LDij@zpXis`qS^HH\ngCi@LDij@zpXjs`qS^HH\ngCiALMJRu@]JJP\ngCiALMJRu@]JJ[s^@\ngCiALMJRu@]JJ\\xLT`\ngCiALMJRu@]JJ\\xLTwf|\ngCl@ADe[PGVBgUy`l``\ngClAADnRmhCkASj|p_vPP\ngFp@DjYZXHCkASfyW]x{nrTrp=\ngFp@DjYZjjQCiabgIZyHXis\\kv|_WwyJYX<\ngFp@DjxujhCiabgIZwL{`dMC~RvN@\ngFp@LdaahUPGVrVmsMkYCPdmc`=\ngFp@LdaahUPGVrVmsMkY}__dmc`=\ngFp@LdaahUPGVrVmsMkiCPdmc`\ngFp@LdaahUTrGVrVmsMkYC__dmc`+\ngFp@LdaahUTrGVrVmsMkYC__dmc`-\ngFp@LdaahUTrGVrVmsMkiC__dmc`<\ngFp@LdaahUTrGVrVmsMkiC__dmc`>\ngFp@LddLUUPGSCENRusdyK\\pJBPtOyHZX\ngFp@LddLUUPGSCENRusdyK\\sr|PtOyHZX\ngFp@LddLUUTBGSCENRurPqRVy`Uxah_rPtp>\ngFp@LddLUUTBGSCENRus`iK\\sr|PtOyHZX>\ngFp@LddLUUTBGSCENRusdyK\\pJ|PtOyHZX<\ngFp@LddLUUTBGSCENRusdyK\\pJ|PtOyHZX>\ngFp@LddLUUTBGSCENRushiK\\pJ|PtOyHZX<\ngFp`@TfXujjJChqSfnSENRwVCPdmc`<\ngFp`@TizJjiRYChqSfn\\dm[iAh_rPup<\ngFp`@TizJjiRZChqSfmtoTOyHZx<\ngFp`@TizJjiRZChqSfmtoTOyHZx>\ngFp`@TizJjiRZChqSfn\\dm[iAh_rPup<\ngFp`@TizJjiRZChqSfn\\dm[iAh_rPup>\ngFp`@dfxujhChqrVmtPtOyKXx\ngFp`@dfxujhChqrVmt_WwyKXx\ngFp`@dfxujjYChqrVmtPwwyKXx<\ngFp`@dfxujjYChqrVmtPwwyKXx>\ngFq@@dmXuU@]VJ\\ek_XICPdem`\ngFq@@dsFmU@]VJ\\ek_XICPdmc`\ngFq@@dsFmU@]VJ]Ek_XICPdmc`\ngFq@@dsFmUQH]VJ]Ek_XIC__dmc`<\ngFq@@dsFmUQH]VJ]Ek_XIC__dmc`>\ngFq@@dsFuURH]VJ\\ek_XICPdmc`<\ngFq@@dsFuURH]VJ\\ek_XICPdmc`>\ngFq@@eMXuURH]LLTyKVyP\\D~h_rRvp<\ngFq@@eMqUURH]VJ\\ek_HICPdak`<\ngFq@@eMqUURH]VJ\\ek_HICPdak`>\ngFq@@eMqUURH]VJ\\ek_KqCPdak`<\ngFq@@eMqUURH]VJ\\ekdaRVm|oDMC~RFn@>\ngFq@@eMqUURH]VJ\\ekgIKV~WbFaICW@<\ngFq@@eMqUURH]VJ\\ekgIKV~WbFaICW@>\ngFq@@eMqUURH]VJ\\ekgIrV~PRFaICW@<\ngFq@@eMqUURH]VJ\\ekgIrV~PRFaICW@>\ngFq@@eMqUURH]VJ\\ekgIrV~PSzaICW@<\ngFq@@eOQUARP]JJ[yAN{o|dM\\+\ngFq@@eOQUARP]JJ[yAN{o|dM\\-\ngFq@@eOQUARP]JJ[y^N{o|dM\\+\ngFq@@eOQUARP]JJ[y^N{o|dM\\-\ngFq`@bdwFmUSP]ZNZweC~RvN@>\ngFq`ALe\\qUU@]ENRunbFaISW@\ngFx@@eMXuU@]LLTyKVyP\\Dah_rRvuh@\ngFx@@eOQMA@]JJ[y^N{o|dM\\=\ngFx@@eOQUARP]JJ[yAN{o|dM\\+\ngFx@@eOQUARP]JJ[yAN{o|dM\\-\ngFx@@eOQUARP]JJ[y^N{o|dM\\+\ngFx@@eOQUARP]JJ[y^N{o|dM\\-\ngFx@@eSFuU@]LLTyKVyP\\Dah_rVquh@=\ngFx@@eSFuU@]LLTzKVyP\\Dah_rVquh@\ngFx@@eSFuU@]LLUZKVyP\\Dah_rVqp\ngFxAAIRicZ`@NbFR\\wJC`gm{~RvN@=\ngFxAAYRicZ`@NbFR\\wJC`gm{~RvNm@=\ngFx`DBdwFmUSP]ZNZweC~RvN@<\ngFy@DDfxujhChqrVmtPtOyKXx\ngFy@DDfxujjYChqrVmtPwwyKXx<\ngFy@DDfxujjYChqrVmtPwwyKXx>\ngGP@DiWj`NbgIZwQCP`\ngGP@DjZ@@Mrm{Yw]`=\ngGP@DjZ@@Mrm{Yw^`=\ngGP@DjZ@@Mrm{Y{^`=\ngGP@DjZ@@Mrm{iw^`\ngGP@DjZ@@Mrm{i{^`=\ngGP@DjZ@@Mrn{i{^`=\ngGP@DjZ@@NZFJ\\enUw]O[t=\ngGP@DjZ@@N\\EI[e[wSn}@\ngGP@DjZ@@N\\EN[e[wSv}@\ngGP@DjZ@@N\\FN[e]wSv}@\ngGP@DjZX@NhJyV}l{np=\ngGP@DjZX@NhJyV}l{oP\ngGP@DjZX@NhJyV}l}oP=\ngGP@DjZX@NhJyV}t{np=\ngGP@DjZX@NhJyV}t{oP\ngGP@DjZX@NhJyW]l{np=\ngGP@DjZX@NhJyW]l{oP\ngGP@DjZX@NhJyW]l}oP=\ngGP@DjZX@NhJyW]t{np=\ngGP@DjZX@NhJyW]t{oP\ngGP@DjZX@NhJyW]t}oP=\ngGP@DjZX@NhKNBdmrn{iw^`\ngGP@DjZX@NhKNCDmrn{Yw^`\ngGP@DjZX@NhKNCDmrn{iw^`\ngGP@DjZX@NlEN[e]pSn{@=\ngGP@DjZX@NlEN[e]pSn{IPh`=\ngGP@DjZX@NlEN[e]pSn}@\ngGP@DjZX@NlEN[e]pSv}@=\ngGP@DjZX@NlEN[e]wcn{@=\ngGP@DjZX@NlEN[e]wcn{IPh`=\ngGP@DjZX@NlEN[e]wcn}@\ngGP@DjZX@NlEN[e]wcv}@=\ngGP@DjZX@NlEN[{AN{l=\ngGP@DjZX@NlEN[{AN{t\ngGP@DjZX@NlEN[{AO[t=\ngGP@DjZX@NlEN[{^N{l=\ngGP@DjZX@NlEN[{^N{t\ngGP@DjZX@NlEN\\xJRwJ{`g]z\ngGP@DjZX@NlEN\\xJRwJ{oG]z\ngGP@DjZX@NlEN\\xJRwvB]wh\ngGP@DjZX@NlEN\\xJRwv|]wh\ngGP@DjZX@NlEN\\xJ\\wJ{`gmz\ngGP@DjZX@NlEN\\xJ\\wvB^wh\ngGP@DjZX@NlEN\\xLRwJ{`g]z\ngGP@DjZX@NlEN\\xLRwvB]wh\ngGP@DjZX@NlEN\\xLRwv|]wh\ngGP@DjZX@NlEN\\xL\\wJ{`gmz\ngGP@DjZX@NlEN\\xL\\wvB^wh\ngGP@DjZX@NlENke]pSn{@=\ngGP@DjZX@NlENke]pSn}@\ngGP@DjZX@NlENke]pSv}@=\ngGP@DjZX@NlENk{AN{l=\ngGP@DjZX@NlENk{AN{t\ngGP@DjZX@NlENk{AO[t=\ngGP@DjZX@NlENlxJRwJ{`g]z\ngGP@DjZX@NlENlxJRwvB]wh\ngGP@DjZX@NlENlxLRwJ{`g]z\ngGP@DjZX@NlENlxLRwvB]wh\ngGP@DjZX@NlENlxL\\wJ{`gmz\ngGP@DjZX@NlENlxL\\wvB^wh\ngGP@DjZY`NbFR\\wJ{`g]z\ngGP@DjZY`NbFR\\wJ{`gmv\ngGP@DjZY`NbFR\\wJ{`gmz\ngGP@DjZY`NbFR\\wJ{oGmv\ngGP@DjZY`NbFR\\wJ{oGmz\ngGP@DjZY`NbFR\\wvB]wX\ngGP@DjZY`NbFR\\wvB^wh\ngGP@DjZY`NbFR]WJ{`gmv\ngGP@DjZY`NbFR]WJ{`gmz\ngGP@DjZY`NdJUrm{Yw]`\ngGP@DjZY`NdJUrm{iw^`\ngGP@DjZY`NdJUrn{Y{]`\ngGP@DjZY`NdJUrn{i{^`\ngGP@DjZY`NfFJ\\ek\\knB^tH\ngGP@DjZY`NfFJ\\ek]XMB\ngGP@DjZY`NfFJ\\ek_KnCP`\ngGP@DjZY`NfFJ\\ek_XI{_@\ngGP@DjZY`NfFJ\\ekfabgI[e]pSva@\ngGP@DjZY`NfFJ\\ekfabgI[kAhP\ngGP@DjZY`NfFJ\\ekfabgI[y]pZD\ngGP@DjZY`NfFJ\\ekgARVyW\\D}hP\ngGP@DjZY`NfFJ\\ekgARV~W\\Fa@\ngGP@DjZY`NfFJ\\ekgASf~W\\Fa@\ngGP@DjZY`NfFJ\\ekgAbVzpZD\ngGP@DjZY`NfFJ\\ekgAbV~W\\Fa@\ngGP@DjZY`NfFJ\\ekgAcfyW\\D}hP\ngGP@DjZY`NfFJ\\ekgAcf~W\\Fa@\ngGP@DjZY`NfFJ\\em\\knB^tH\ngGP@DjZY`NfFJ\\em]XMB\ngGP@DjZY`NfFJ\\em_KnCP`\ngGP@DjZY`NfFJ\\em_XI{P`\ngGP@DjZY`NfFJ\\emgAcfyW\\D}hP\ngGP@DjZY`NfFJ\\emgAcf~W\\Fa@\ngGP@DjZY`NfFJ]Em\\knB^tH\ngGP@DjZY`NfFJ]Em]XMB\ngGP@DjZY`NfFJ]Em_KnCP`\ngGP@DjZY`NfFJ]EmgAcfyW\\D}hP\ngGP@DjZj`NfFJ\\ek\\hNBPtH\ngGP@DjZj`NfFJ\\ekfabgI[eApRFa@\ngGP@DjZj`NfFJ\\fm\\hNBPtH\ngGP@DjZj`NfFJmFm\\hNBPtH\ngGP@DjZjdEDNfFJ\\ekdacdmr`xIC_@<\ngGP@DjZjdEDNfFJ\\ekdacdmr`xIC_@>\ngGP@DjZjdEDNfFJ\\ekfabgI[eAwbF~@<\ngGP@DjZjdEDNfFJ\\ekfabgI[eAwbF~@>\ngGP@DjZjdEDNfFJ\\ekgARVyP]xao`<\ngGP@DjZjdEDNfFJ\\ekgARVyP]xao`>\ngGP@DjZjdEDNfFJ\\ekgAbVyP\\Dao`<\ngGP@DjZjdEDNfFJ\\ekgAbVyP\\Dao`>\ngGP@DjZjdEDNfFJ\\ekgAcfyP\\DahP<\ngGP@DjZjdEDNfFJ\\ekgAcfyP\\DahP>\ngGP@DjZjdEDNfFJ\\ekgAcfyP\\Dao`<\ngGP@DjZjdEDNfFJ\\ekgAcfyP\\Dao`>\ngGP@DjZjdEDNfFJ\\emgAbVyP\\DahP<\ngGP@DjZjdEDNfFJ\\emgAbVyP\\DahP>\ngGP@DjZjdEDNfFJ\\emgAcfyP\\DahP<\ngGP@DjZjdEDNfFJ\\emgAcfyP\\DahP>\ngGP@DjZjdEDNfFJ\\fmgAcfyP\\DahP<\ngGP@DjZjdEDNfFJ\\fmgAcfyP\\DahP>\ngGP@DjZjdEDNfFJ]EkfabgI[eApRF~@<\ngGP@DjZjdEDNfFJ]EkfabgI[eApRF~@>\ngGP@DjZjdEDNfFJ]Em\\hNBPtH<\ngGP@DjZjdEDNfFJ]Em\\hNBPtH>\ngGP@DjZjdEDNfFJ]EmgAcfyP\\DahP<\ngGP@DjZjdEDNfFJ]EmgAcfyP\\DahP>\ngGP@DjZjdEDNfFJ]FmgAcfyP\\DahP<\ngGP@DjZjdEHNfFJ\\ekfabgI[eAwbF~@\ngGP@DjZjdEHNfFJ\\ekgARVyP]xao`\ngGP@DjZjdEHNfFJ\\ekgAbVyP\\Dao`<\ngGP@DjZjdEHNfFJ\\ekgAbVyP\\Dao`>\ngGP@DjZjdEHNfFJ\\ekgAcfyP\\DahP\ngGP@DjZjdEHNfFJ\\emgAbVyP\\DahP<\ngGP@DjZjdEHNfFJ\\emgAbVyP\\DahP>\ngGP@DjZjdEHNfFJ\\emgAcfyP\\DahP<\ngGP@DjZjdEHNfFJ\\emgAcfyP\\DahP>\ngGP@DjZjdEHNfFJ\\fkgAbVyP\\Dao`<\ngGP@DjZjdEHNfFJ\\fkgAbVyP\\Dao`>\ngGP@DjZjdEHNfFJ\\fmgAcfyP\\DahP<\ngGP@DjZjdEHNfFJ\\fmgAcfyP\\DahP>\ngGP@DjZjdEHNfFJ]EkfabgI[eApRF~@>\ngGP@DjZjdEHNfFJ]EkgAbVyP\\Dao`<\ngGP@DjZjdEHNfFJ]EkgAbVyP\\Dao`>\ngGP@DjZjdEHNfFJ]Em\\hNBPtH\ngGP@DjZjdEHNfFJ]EmgAbVyP\\DahP<\ngGP@DjZjdEHNfFJ]EmgAbVyP\\DahP>\ngGP@DjZjhDNfFJ\\fmdacdmr`xICP`<\ngGP@DjZjhDNfFJ\\fmdacdmr`xICP`>\ngGP@DjZjhDNfFJ]Fm\\hNBPtH>\ngGP@DjZjiDNfFJ\\ek\\hNBPwp<\ngGP@DjZjiDNfFJ\\ek\\hNBPwp>\ngGP@DjZjiDNfFJ\\ekdabdmr`xIC_@<\ngGP@DjZjiDNfFJ\\ekdabdmr`xIC_@>\ngGP@DjZjiDNfFJ\\ekdabgMr`xICP`<\ngGP@DjZjiDNfFJ\\ekdabgMr`xICP`>\ngGP@DjZjiDNfFJ\\ekfabgI[eApRF~@<\ngGP@DjZjiDNfFJ\\ekfabgI[eApRF~@>\ngGP@DjZjiDNfFJ\\em\\hNBPtH<\ngGP@DjZjiDNfFJ\\em\\hNBPtH>\ngGP@DjZjiDNfFJ\\emdabgMr`xICP`<\ngGP@DjZjiDNfFJ\\emdabgMr`xICP`>\ngGP@DjZjiDNfFJ\\emfabgI[eApRFa@<\ngGP@DjZjiDNfFJ\\emfabgI[eApRFa@>\ngGP@Djfj`NfFJ\\ek\\hNBPtH\ngGP@Djfj`NfFJ\\ek\\hNBPtOyJED\ngGP@Djfj`NfFJ\\ek\\hNBPwp\ngGP@Djfj`NfFJ\\ek\\hNB_TH\ngGP@Djfj`NfFJ\\ek\\hNB_Wp\ngGP@Djfj`NfFJ\\ek\\hN|_TH\ngGP@Djfj`NfFJ\\ekdaSdmr`{q}P`\ngGP@Djfj`NfFJ\\ekdaSdmr`{q}_@\ngGP@Djfj`NfFJ\\ekdabdmr`xICP`\ngGP@Djfj`NfFJ\\ekdabdmr`xIC_@\ngGP@Djfj`NfFJ\\ekdabdmr`xI}P`\ngGP@Djfj`NfFJ\\ekgAbVyP\\DahP\ngGP@Djfj`NfFJ\\ekgAbVyP\\Dao`\ngGP@Djfj`NfFJ\\ekgArVyP\\Dah_rTJH\ngGP@Djfj`NfFJ\\ekgArVyP\\D~hP\ngGP@Djfj`NfFJ\\ekgArVyP\\D~o`\ngGP@Djfj`NfFJ\\em\\hNBPtH\ngGP@Djfj`NfFJ\\em\\hNB_TH\ngGP@Djfj`NfFJ\\emgAbVyP\\DahP\ngGP@Djfj`NfFJ\\emgArVyP\\D~hP\ngGP@Djfj`NfFJ\\fk\\hNBPtH\ngGP@Djfj`NfFJ\\fk\\hNBPwp\ngGP@Djfj`NfFJ\\fkdabdmr`xICP`\ngGP@Djfj`NfFJ\\fkdabdmr`xIC_@\ngGP@Djfj`NfFJ\\fkgArVyP\\DahP\ngGP@Djfj`NfFJ\\fkgArVyP\\Dao`\ngGP@Djfj`NfFJ\\fm\\hNBPtH\ngGP@Djfj`NfFJ]Fk\\hNBPtH\ngGP@Djfj`NfFJ]Fk\\hNBPwp\ngGP@Djfj`NfFJ]FkgAbVyP\\DahP\ngGP@Djfj`NfFJ]Fm\\hNBPtH\ngGP@Djfj`NfFJmEk\\hNB_TH\ngGP@Djfj`NfFJmFk\\hNBPtH\ngGP@DjfjhDNfFJ\\ekdabdmr`{q}P`<\ngGP@DjfjhDNfFJ\\ekdabdmr`{q}P`>\ngGP@DjfjhDNfFJ\\ekdacdmr`xI}P`<\ngGP@DjfjhDNfFJ\\ekdacdmr`xI}P`>\ngGP@DjfjhDNfFJ\\ekdacdmr`xI}_@<\ngGP@DjfjhDNfFJ\\ekdacdmr`xI}_@>\ngGP@DjfjhDNfFJ\\ekgARVyP]x~hP<\ngGP@DjfjhDNfFJ\\ekgARVyP]x~hP>\ngGP@DjfjhDNfFJ\\ekgAbVyP\\D~hP<\ngGP@DjfjhDNfFJ\\ekgAbVyP\\D~hP>\ngGP@DjfjhDNfFJ\\fkgAbVyP\\DahP<\ngGP@DjfjhDNfFJ\\fkgAbVyP\\DahP>\ngGP@DjfjhDNfFJ]Ek\\hNB_TH<\ngGP@DjfjhDNfFJ]Ek\\hNB_TH>\ngGP@DjfjhDNfFJ]EkgAbVyP\\D~hP<\ngGP@DjfjhDNfFJ]EkgArVyP\\D~hP<\ngGP@DjfjhDNfFJ]EkgArVyP\\D~hP>\ngGP@DjfjhDNfFJ]FkgARVyP\\DahP<\ngGP@DjfjhDNfFJ]FkgARVyP\\DahP>\ngGP@DjfjhDNfFJ]FkgARVyP\\Dao`<\ngGP@DjfjhDNfFJ]FkgARVyP\\Dao`>\ngGP@Djyj`NbIIZwLwmdMB\ngGP@Djyj`NbIIZwLwndMB\ngGP@Djyj`NbIIZwL{mdMB\ngGP@Djyj`NbIIZwL{ndMB\ngGP@Djyj`NbIIkWLwmdMB\ngGP@Djyj`NbIIkWLwndMB\ngGP@Djyj`NbIIkWL{ndMB\ngGP@Djyj`NbIIkYLTyK\\s^zPtH\ngGP@Djyj`NfFJ\\ek\\snBPtH\ngGP@Djyj`NfFJ\\ek_XICP`\ngGP@Djyj`NfFJ\\ek_XICPdlRP\ngGP@Djyj`NfFJ\\ekdacdmsNxICP`\ngGP@Djyj`NfFJ\\ekdacdm}`dMB\ngGP@Djyj`NfFJ\\ekdqSdmsNxICP`\ngGP@Djyj`NfFJ\\ekdqSdmsN{qCP`\ngGP@Djyj`NfFJ\\ekdqSdm}`dMB\ngGP@Djyj`NfFJ\\ekfabgI[f]pRFa@\ngGP@Djyj`NfFJ\\ekfabgI[{AHZD\ngGP@Djyj`NfFJ\\ekfabgI[{^HZD\ngGP@Djyj`NfFJ\\fm\\snBPtH\ngGP@Djyj`NfFJ\\fm_XICP`\ngGP@Djyj`NfFJ\\fmdacdmsNxICP`\ngGP@Djyj`NfFJ]Ek\\snBPtH\ngGP@Djyj`NfFJ]Ek_XICP`\ngGP@Djyj`NfFJ]Ekdacdm}`dMB\ngGP@Djyj`NfFJ]EkfabgI[f]pRFa@\ngGP@Djyj`NfFJ]EkfabgI[{AHZD\ngGP@Djyj`NfFJ]FmdacdmsNxICP`\ngGP@DjyjhdNbIIZwLwmdM|>\ngGP@DjyjhdNbIIZwLwndM|<\ngGP@DjyjhdNbIIZypXynYw[HZD<\ngGP@DjyjhdNbIIZypXynYw[HZD>\ngGP@DjyjhdNbIIZypXynYw]HZD<\ngGP@DjyjhdNbIIZypXynYw]HZD>\ngGP@DjyjhdNbII[WLwndMB<\ngGP@DjyjhdNbII[WLwndMB>\ngGP@DjyjhdNbII[WL{ndMB<\ngGP@DjyjhdNbII[WL{ndMB>\ngGP@DjyjhdNbII[YpXynYw]HZD<\ngGP@DjyjhdNbII[YpXynYw]HZD>\ngGP@DjyjhdNbII[YtTynYw]HZD<\ngGP@DjyjhdNbIIjypXenYw]H[x<\ngGP@DjyjhdNfFJ\\ek_XIC_@<\ngGP@DjyjhdNfFJ\\ek_XIC_@>\ngGP@DjyjhdNfFJ\\ekdacdm}`dM|<\ngGP@DjyjhdNfFJ\\ekdacdm}`dM|>\ngGP@DjyjhdNfFJ\\ekdacdm}`dM}~RqI@>\ngGP@DjyjhdNfFJ\\ekfabgI[f]pRF~@>\ngGP@DjyjhdNfFJ\\ekfabgI[{AH[x<\ngGP@DjyjhdNfFJ\\ekfabgI[{AH[x>\ngGP@DjyjhdNfFJ\\ekfabgI[{^H[x<\ngGP@DjyjhdNfFJ\\ekfabgI[{^H[x>\ngGP@DjyjhdNfFJ\\ekgAbVyg\\Dao`<\ngGP@DjyjhdNfFJ\\ekgAbVyg\\Dao`>\ngGP@DjyjhdNfFJ\\ekgAbV~pRF~@<\ngGP@DjyjhdNfFJ\\ekgAbV~pRF~@>\ngGP@DjyjhdNfFJ\\ekgAcfyg\\DahP<\ngGP@DjyjhdNfFJ\\ekgAcfyg\\DahP>\ngGP@DjyjhdNfFJ\\ekgAcf~pRFa@<\ngGP@DjyjhdNfFJ\\ekgAcf~pRFa@>\ngGP@DjyjhdNfFJ\\ekgQRV~pRF~@<\ngGP@DjyjhdNfFJ\\ekgQRV~pRF~@>\ngGP@DjyjhdNfFJ\\ekgQRV~wbF~@<\ngGP@DjyjhdNfFJ\\ekgQRV~wbF~@>\ngGP@DjyjhdNfFJ\\ekgQSfyg\\DahP<\ngGP@DjyjhdNfFJ\\ekgQSfyg\\DahP>\ngGP@DjyjhdNfFJ\\ekgQSf~pRFa@<\ngGP@DjyjhdNfFJ\\ekgQSf~pRFa@>\ngGP@DjyjhdNfFJ\\ekgQSf~wbFa@<\ngGP@DjyjhdNfFJ\\ekgQSf~wbFa@>\ngGP@DjyjhdNfFJ\\em\\snBPtH<\ngGP@DjyjhdNfFJ\\em\\snBPtH>\ngGP@DjyjhdNfFJ\\em_XICP`<\ngGP@DjyjhdNfFJ\\em_XICP`>\ngGP@DjyjhdNfFJ\\emdacdmsNxICP`<\ngGP@DjyjhdNfFJ\\emdacdmsNxICP`>\ngGP@DjyjhdNfFJ\\emgAbVyg\\DahP<\ngGP@DjyjhdNfFJ\\emgAbVyg\\DahP>\ngGP@DjyjhdNfFJ\\emgAbV~pRFa@<\ngGP@DjyjhdNfFJ\\emgAcfyg\\DahP<\ngGP@DjyjhdNfFJ\\emgAcfyg\\DahP>\ngGP@DjyjhdNfFJ\\emgAcf~pRFa@<\ngGP@DjyjhdNfFJ\\emgAcf~pRFa@>\ngGP@DjyjhdNfFJ\\emgQSfyg\\DahP<\ngGP@DjyjhdNfFJ\\emgQSf~pRFa@>\ngGP@DjyjhdNfFJ\\fkgAbVyg\\Dao`<\ngGP@DjyjhdNfFJ\\fkgAbVyg\\Dao`>\ngGP@DjyjhdNfFJ\\fkgAbV~pRF~@<\ngGP@DjyjhdNfFJ\\fmgAcfyg\\DahP<\ngGP@DjyjhdNfFJ\\fmgAcfyg\\DahP>\ngGP@DjyjhdNfFJ]EkgAcfyg\\DahP<\ngGP@DjyjhdNfFJ]EkgAcfyg\\DahP>\ngGP@DjyjhdNfFJ]EkgAcf~pRFa@<\ngGP@DjyjhdNfFJ]EkgQSfyg\\DahP<\ngGP@DjyjhdNfFJ]EkgQSfyg\\DahP>\ngGP@DjyjhdNfFJ]EmgAcf~pRFa@>\ngGP@Dkij`NfFJ\\ek\\snBPtH\ngGP@Dkij`NfFJ\\ek_XICP`\ngGP@Dkij`NfFJ\\ek_XIC_@\ngGP@Dkij`NfFJ\\ekdabgMsNxICP`\ngGP@Dkij`NfFJ\\ekdabgM}`dMB\ngGP@Dkij`NfFJ\\ekgAbVyg\\Dao`\ngGP@Dkij`NfFJ\\ekgAbV~pRF~@\ngGP@Dkij`NfFJ\\ekgAbfyg\\DahP\ngGP@Dkij`NfFJ\\ekgAbf~pRFa@\ngGP@Dkij`NfFJ\\em_XICP`\ngGP@Dkij`NfFJ\\fmgAbfyg\\DahP\ngGP@Dkij`NfFJ\\fmgAbf~pRFa@\ngGP@DkijhdNfFJ\\ekdabdm}`dM|<\ngGP@DkijhdNfFJ\\ekgAbfyg\\Dao`>\ngGP@DkijhdNfFJ\\ekgAbf~pRF~@<\ngGP@DkijhdNfFJ\\ekgAbf~pRF~@>\ngGP@DkijhdNfFJ\\emgAbfyg\\DahP<\ngGP@DkijhdNfFJ\\emgAbfyg\\DahP>\ngGP@DkijhdNfFJ\\emgAbf~pRFa@<\ngGP@DkijhdNfFJ\\emgAbf~pRFa@>\ngGP@Lda`U@][IZwLvmdMB=\ngGP@Lda`U@][IZwLvmdMC~RqI@=\ngGP@Lda`U@][IZwLvmgu|=\ngGP@Lda`U@][IZwLvmgu}~RqI@=\ngGP@Lda`U@][IZwLvndMB\ngGP@Lda`U@][IZwLvndMC~RqI@\ngGP@Lda`U@][IZwLzndMB=\ngGP@Lda`U@][IZwLzndMC~RqI@=\ngGP@Lda`U@][IZyHTyK\\sjzPtH\ngGP@Lda`U@][IZyLTyK\\sZzPtH\ngGP@Lda`U@][IZyhXirVygUtahP=\ngGP@Lda`U@][IkWLvmdMB=\ngGP@Lda`U@][IkWLvndMB\ngGP@Lda`U@][IkWLzndMB=\ngGP@Lda`U@][IkYHTyK\\sjzPtH\ngGP@Lda`U@][IkYLTyK\\sZzPtH\ngGP@Lda`USH][IZwLvmdM|+\ngGP@Lda`USH][IZwLvmdM|-\ngGP@Lda`USH][IZwLvmdM}~RqI@+\ngGP@Lda`USH][IZwLvmdM}~RqI@-\ngGP@Lda`USH][IZwLvndM|<\ngGP@Lda`USH][IZwLvndM|>\ngGP@Lda`USH][IZyHTyK\\sjzPwp>\ngGP@Lda`USH][IZyLTyK\\sZzPwp>\ngGP@Lda`USH][IZyLTyK\\sZzPwwyKDd>\ngGP@Lda`USH][IZypTynYu]HZD<\ngGP@Lda`USH][IZypTynYu]HZD>\ngGP@Lda`USH][IZytTenYm]H[x<\ngGP@Lda`USH][IZytTenYm]H[x>\ngGP@Lda`USH][IZytTenYm]H[{|ebR<\ngGP@Lda`USH][IZytTenYm]H[{|ebR>\ngGP@Lda`USH][IZytTynYm]HZD<\ngGP@Lda`USH][IZytTynYm]HZD>\ngGP@Lda`USH][IZytTynYm]HZG|ebR<\ngGP@Lda`USH][IZytTynYm]HZG|ebR>\ngGP@Lda`USH][IZytTynYm]H[x<\ngGP@Lda`USH][IZytTynYm]H[x>\ngGP@Lda`USH][IZytTynYm]Okx<\ngGP@Lda`USH][IZytTynYm]Okx>\ngGP@Lda`USH][I[WLvmdMB+\ngGP@Lda`USH][I[WLvmdMB-\ngGP@Lda`USH][I[WLvndMB<\ngGP@Lda`USH][I[WLvndMB>\ngGP@Lda`USH][I[WLzndMB+\ngGP@Lda`USH][I[WLzndMB-\ngGP@Lda`USH][I[YHTyK\\sjzPtH<\ngGP@Lda`USH][I[YHTyK\\sjzPtH>\ngGP@Lda`USH][I[YLTyK\\sZzPtH<\ngGP@Lda`USH][I[YLTyK\\sZzPtH>\ngGP@Lda`USH][I[YpTenYu]HZD<\ngGP@Lda`USH][I[YpTenYu]HZD>\ngGP@Lda`USH][I[YpTynYu]HZD<\ngGP@Lda`USH][I[YpTynYu]HZD>\ngGP@Lda`USH][I[YtTenYm]HZD<\ngGP@Lda`USH][I[YtTenYm]HZD>\ngGP@Lda`USH][I[YtTynYm]HZD<\ngGP@Lda`USH][I[YtTynYm]HZD>\ngGP@Lda`USH][IjwLvmdM|+\ngGP@Lda`USH][IjwLvmdM|-\ngGP@Lda`USH][IjwLvndM|<\ngGP@Lda`USH][IjwLvndM|>\ngGP@Lda`USH][IjyHTyK\\sjzPwp<\ngGP@Lda`USH][IjyHTyK\\sjzPwp>\ngGP@Lda`USH][IjyLTyK\\sZzPwp<\ngGP@Lda`USH][IjyLTyK\\sZzPwp>\ngGP@Lda`USH][IjytTenYm]H[x<\ngGP@Lda`USH][IjytTenYm]H[x>\ngGP@Lda`USH][IjytTynYm]H[x<\ngGP@Lda`USH][IjytTynYm]H[x>\ngGP@Lda`USH][IkYpTynYu]HZD<\ngGP@Lda`USH][IkYpTynYu]HZD>\ngGP@Lda`USH][IkYtTynYm]HZD<\ngGP@Lda`USH][IkYtTynYm]HZD>\ngGPAEJU\\uPGSCENRusPqSdmsNxICP`\ngGPAEJU\\uPGSCENRusPqSdm}`dMB\ngGPAKrUM@@FyV}l}oP=\ngGPAMJUML@GVBgN\\EI[{AN{t\ngGPAMNRPpJ`Nmdm[f]WRFa@=\ngGPAMNRPpJ`Nmdukf[VrFa@=\ngGPAMNRPpJ`Nmdukf[WRFa@\ngGPAMNRPpJ`Nmdukf]WRFa@=\ngGPAMNRPpJ`NmdultLTyK\\sjzPtH=\ngGPAMNRPpJ`NmdulxJ\\wLzndMB>\ngGPAMNRPpJ`NmdulzJ\\wLvndMB>\ngGPAMvRPpJ`Nijyful}oP=\ngGPB@DZPLaYAJZjhCkAbf|PP\ngGPB@DZPLaYAJZjhCkAbj|PP\ngGPBABRDKaWAJnjhCkASf~pSz~@>\ngGPBADJHLQXaInjhCiQr\ngGPD@DDHRYjY@zTeWHwmg]v\ngGPD@DDHRYjY@zTeWHwmg]z\ngGPD@DDHRYjY@zTeWHwng]z\ngGPD@DDHRYjY@zTeYtTenQo]N{t\ngGPD@DDHRYjY@ztdunao[@\ngGPD@DDHRYjjTR`zLTykgAcfzpZD>\ngGPD@DFPRYfi@zLTykgQRVzp[t\ngGPD@DGpRYjY@ztduoao[oP\ngGPD@DHHRZzj@zL\\ek]DMB\ngGPD@DHHRZzj@zL\\ekgIrVyGexahP\ngGPD@DHHRZzj@zL\\ekgIrVzHZD\ngGPD@DHHR[f`@zd[h{np=\ngGPD@DHHR[ff@zL\\ek]GmB\ngGPD@DHHR[j`@zd[h{np=\ngGPD@DHHR[j`@zd[h{oP\ngGPD@DKpRYjZ@zLdfm\\c^vPtH\ngGPD@DSpRZVj@zlTyKV~pRFa@\ngGPD@DXHRfjj@zhXiKV~PRFa@\ngGPD@DXHRfjj@zhXiKWNCEM|`dMB\ngGPD@DXHRfjj@zhXjKV~PRFa@\ngGPD@DXHRfjjdPzhXiK[NCEM|`dMB<\ngGPD@DXHRfjjdPzhXiK[NCEM|`dMB>\ngGPD@DZ`R[ij@zLlfm\\cZvPtH\ngGPD@VIpRVjj@zlTyKV~pRFa@\ngGPD@bSpRZVj@zlTzMV~pRFa@\ngGPD@xIpR[j`@zd[d^Wcn{@=\ngGPD@xIpR[j`@zd[d^Wcn}@\ngGPD@xQpRjzj@zhTyKVyglDahP\ngGPD@xQpRkf`@zP\\wL{`gmz+\ngGPD@xQpRkf`@zP]WL{`g]v+\ngGPD@xQpRkf`@zP]WL{`gmz+\ngGPD@xUpRjZj@zhXirVyP\\Dao`\ngGPDADFHRYjY@zLTykgQRVzw[t\ngGPDADFHRYjjTRPzLTyk]XMB\ngGPDAHFPRYjjTRPzLTykgQRVzpZD\ngGPDAHFPRYjjTRPzLTykgQRVzp[x<\ngGPDAHFPRYjjTRPzLTykgQRVzp[x>\ngGPDAHJPRZzj@zL\\ek]DMB\ngGPDAHJPRZzj@zL\\ek]DM|\ngGPDAHJPRZzj@zL\\ek]GuB\ngGPDAbGDRYjjTRPzLTyk]XMB\ngGPDAbGDRYjjTRPzLTym]XMB>\ngGPDAbR`RYj`@zT]YtTeolD{oP>\ngGPDAxKpRYfj@zlTyKV~pRFa@\ngGPDAxSpRijj@zXXirVmr`xICP`\ngGPDAxSpRkj``PzP]WL}`g]v+\ngGPDAxSpRkj``PzP]WL}`g]v-\ngGPDAxSpRkj``PzP]WvB]wX+\ngGPDAxSpRkj``PzP]WvB]wX-\ngGPDAxSpRkjj`PzhTyKV~pRFa@<\ngGPDAxSpRkjj`PzhTyKV~pRFa@>\ngGPDaxF`Dgdjfj`NjFJ\\unTGAOjD\ngGPDaxF`Dgdjfj`NjFJ\\uodGAhP\ngGPDaxF`DgdjfjhDNjFJ]UodGAhP<\ngGPDaxF`DgdjfjhDNjFJ]UodGAhP>\ngGPEAxSpdiUuPPH]HNkf^pSn{@+\ngGPEAxSpdiUuPPH]HNkf^pSn{@-\ngGPFAVRDTIhPueaDfZj`NeEN]EIP>\ngGPH@DIJm]@]ZIZweB\ngGPH@DIKUU@]VJ\\ek\\cvBPtH\ngGPH@DIKUU@]VJ\\ek\\cvBPwp\ngGPH@DIKUU@]VJ\\ek_XICP`\ngGPH@DIKUU@]VJ\\ekgAbf~pRFa@\ngGPH@DILsP@]JNlzJRwvB]wh\ngGPH@DILuH@]JN[d^wSn{@=\ngGPH@DILuH@]JN[h{np=\ngGPH@DILuH@]JN[x^N{l=\ngGPH@DILuH@]JN[{]N{l=\ngGPH@DILuH@]RUrM{Yw]`=\ngGPH@DILuH@]RUrM{Yw^`\ngGPH@DILuH@]RUrM{Y{^`=\ngGPH@DILuH@]RUrM{iw]`=\ngGPH@DILuH@]RUrM{iw^`\ngGPH@DILuH@]RV]EI[d[wSn}@\ngGPH@DILuK@]FRRunQo[OZD\ngGPH@DILuK@]FRRunQo]OZD\ngGPH@DILuK@]FRRunQo]O[x\ngGPH@DILuK@]FRRuoao[hP\ngGPH@DILuK@]FRRvnQo[OZD\ngGPH@DILuK@]JRkd[vsn}@\ngGPH@DILuK@]JRkd[vsv}@\ngGPH@DILuPRH]JN[d^pSn{@+\ngGPH@DILuPRH]JN[d^pSn{@-\ngGPH@DILuPRH]JN[{AN{l+\ngGPH@DILuPRH]JN[{AN{l-\ngGPH@DILuPRH]JN[{AN{t>\ngGPH@DILuPRH]JNk{AN{l-\ngGPH@DIMMU@]VJ\\ekdqSdm}`dMB\ngGPH@DIMMU@]VJ\\ekgAbV~pRFa@\ngGPH@DIMMURH]VJ\\ekgQRV~pRFa@<\ngGPH@DIMMURH]VJ\\ekgQRV~pRFa@>\ngGPH@DIMtu@]FVRunQm[HZD\ngGPH@DIMtu@]FVRunQm]HZD\ngGPH@DISUU@]LLTyKVyP\\DahP\ngGPH@DISUU@]LLTyKWNCDmr`xIC_@\ngGPH@DISUU@]LLTyKWNCEMr`xICP`\ngGPH@DISUU@]LLTzMZyP\\DahP\ngGPH@DISUU@]LLUYKVyP\\DahP\ngGPH@DISUU@]LLUYKWNCEMr`xICP`\ngGPH@DISUU@]LLUYKZyP\\DahP\ngGPH@DISm]@]DJRundFa@\ngGPH@VILuH@]JN[h{np=\ngGPH@VILuH@]JN[x^N{l=\ngGPH@VILuH@]JN[{]N{l=\ngGPH@bILuH@]JN[h{np=\ngGPH@bILuH@]JN[{]N{l=\ngGPH@bILuH@]RUrM{Yw]`=\ngGPH@bILuH@]RUrM{iw]`=\ngGPH@bISUU@]LLUYKVyP\\DahP\ngGPH@xIKUU@]VJ\\ek\\cvBPtH\ngGPH@xILuH@]JN[d^wSn{@=\ngGPH@xILuH@]JN[x^N{l=\ngGPH@xIMMU@]VJ\\ek\\cvBPtH\ngGPH@xITuP@]XJ\\wJC`g]z\ngGPH@xITuP@]XJmWJC`g]v=\ngGPH@xITuP@]XJmWJC`g]z\ngGPH@xITuPPH]XJ]WJC`g]v+\ngGPH@xITuPPH]XJ]WJC`g]v-\ngGPH@xITuU@]LLTyKVyP\\DahP\ngGPH@xIUMT`]LLTyKVyP\\DaoP\ngGPH@xIUMT`]LLTyKV~P\\Da@\ngGPH@xIUMT`]LLTyMV~P\\Da@\ngGPH@xIUMT`]LLTzMV~P\\Da@\ngGPH@xIUMU@]LLTyKVyP\\DahP\ngGPH@xIUMU@]LLTyKVyP\\Dao`\ngGPH@xIUMU@]LLTyKVyP\\D~hP\ngGPH@xIUMU@]LLTyKWNCDmr`xICP`\ngGPH@xIUMU@]LLTyKZyP\\DahP\ngGPH@xIUMU@]LLTyMVyP\\DahP\ngGPH@xIUMU@]LLTzMVyP\\DahP\ngGPH@xIUMU@]LLTzMWNCDmr`xICP`\ngGPH@xIUMU@]LLTzMZyP\\DahP\ngGPHABILuH@]JN[h{np=\ngGPHABITuP@]XJmWJC`g]v=\ngGPHABITuP@]XJmWJC`g]z\ngGPHABITuP@]XJmWJC`gmz=\ngGPHABITuS@]LLTyKWNCGMr`xI{P`>\ngGPHADILuH@]JN[h{np=\ngGPHADILuH@]JN[{]N{l=\ngGPHADILuH@]JN\\zJRwvz]wh\ngGPHADILuPRH]JN[{AN{l+\ngGPHADILuPRH]JN[{AN{l-\ngGPHADILuUJIP]VJ\\ekgQRV~pRF~@<\ngGPHADIMMU@]VJ\\ek_XICP`\ngGPHADIMMU@]VJ\\ekdqSdm}`dMB\ngGPHADIMMURH]VJ\\ekgQRV~pRFa@<\ngGPHADIMMURH]VJ\\ekgQRV~pRFa@>\ngGPHADIMMURH]VJ\\ekgQrV~pSza@>\ngGPHAHILuH@]JN[{]N{l=\ngGPHAHILuK@]VJ\\ekgQRVzOZD\ngGPHAHILuK@]VJ\\ekgQRV~wSva@\ngGPHAHILuPRH]JN[{AN{l-\ngGPHAHIMMU@]VJ\\ekdqSdm}`dMB\ngGPHAHIMMURH]VJ\\ekgQRV~pRFa@<\ngGPHAHIMMURH]VJ\\ekgQRV~pRFa@>\ngGPHAVILuH@]JN[{]N{l=\ngGPHAVILuH@]JN\\zJRwvz]wh\ngGPHAVIMMU@]VJ\\ekdqSdm}`dMB\ngGPHAbIKUU@]VJ\\ek_XICP`\ngGPHAbILuH@]JN[{]N{l=\ngGPHAbILuPRH]JN[{AN{l+\ngGPHAbILuPRH]JN[{AN{l-\ngGPHAbILuPRH]JN\\zJ\\wvB^wh<\ngGPHAbILuUJIH]VJ]EmgQSf~pRFa@>\ngGPHAbIMMU@]VJ\\ekdqSdm}`dM|\ngGPHAxILsP@]JNk{AN{l=\ngGPHAxILuH@]JN[d^wSn{@=\ngGPHAxILuH@]JN[h{np=\ngGPHAxILuH@]JN[x^N{l=\ngGPHAxILuH@]JN[x^N{t\ngGPHAxILuH@]JN[{]N{l=\ngGPHAxILuPRH]JN[d^pSn{@+\ngGPHAxILuPRH]JN[d^pSn{@-\ngGPHAxILuUJIH]VJ\\ekgQSfyGlDahP<\ngGPHAxIMMU@]VJ\\ekdqSdmrOXICP`\ngGPHAxIMMU@]VJ\\ekdqSdm}`dMB\ngGPHAxITuP@]XJ\\wJC`g]v=\ngGPHAxITuP@]XJ\\wJC`g]z\ngGPHAxITuP@]XJ\\wJC`gmz=\ngGPHAxITuP@]XJmWJC`g]v=\ngGPHAxITuP@]XJmWJC`g]z\ngGPHAxITuP@]XJmWJC`gmz=\ngGPHAxITuP@]XJmYHXiK\\hNB]wh\ngGPHAxITuP@]XJmYhXirVyP\\D}oP=\ngGPHAxITuPPH]XJ]WJC`g]v+\ngGPHAxITuPPH]XJ]WJC`g]v-\ngGPHAxITuPPH]XJ]WJC`g]z<\ngGPHAxITuPPH]XJ]WJC`g]z>\ngGPHAxITuPPH]XJ]WJC`gmz+\ngGPHAxITuPPH]XJ]WJC`gmz-\ngGPHAxITuPPH]XJlwJCoG]v+\ngGPHAxITuPPH]XJlwJCoG]v-\ngGPHAxITuS@]LLUZKVyP\\D}hP\ngGPHAxITuU@]LLTyKVyP\\DahP\ngGPHAxITuU@]LLUZKVyP\\DahP\ngGPHAxITuUPH]LLTzKVyP\\DahP<\ngGPHAxITuUPH]LLTzKVyP\\DahP>\ngGPHKPITuURH]TLTyM\\hNBPwp<\ngGPHKPYIC@jfPzVRwtvmdH+\ngGPHKPYIC@jfPzVRwtvmdH-\ngGPHKPYIC@jfPzVRytTenYm]H[x>\ngGPHMPITtp@]HJ[e]wcn{@=\ngGPHMPITtp@]HJ[e]wcv}@=\ngGPHMPITtp@]HJ[h{np=\ngGPHMPITtp@]HJ[y]N{l=\ngGPHMPITtp@]HJ[y]O[t=\ngGPHMPYIC@j@zvRunYu]HZD=\ngGPHMPYIC@j@zvRvnYu]HZD+\ngGPHMPYIC@j@zvRvshis\\sZzPtH>\ngGPHMPYIC@j@zvSVnYm[HZD=\ngGPHMPYIC@j@zvSVnYm]HZD\ngGPHMPYIC@j@zvSVnYu]HZD=\ngGPHMPYIC@j@zvSVsPqSdmsNkiCP`=\ngGPHMPYIC@j@zvSVshis\\sZzPtH>\ngGPHMPYICFj@zXXjrVv\\EN[f]PRFa@>\ngGPHMPYICFj@zXXjrZusNhICP`\ngGPHMPYICJj@zXXirVnRFJ\\wLB`dMB>\ngGPHaxCeJSLuPGUbgI[YtTynQwAHZD>\ngGPI@DBTjZh@NlEVkeApSn{@=\ngGPI@DBTjZhHDNlENkeApSn}@<\ngGPI@DBTjZhHDNlENlxJRwJC`g]z<\ngGPI@DBTjZhHDNlENlxJRwJC`g]z>\ngGPI@DZTfzZ`NcKIkWHvmdMB\ngGPI@VBTjZh@NlEVkeApSn{@=\ngGPIAxBTfZd@NeGMrO[iw]`=\ngGPIAxBTfZhIDNeGMrOXIw]`+\ngGPIAxBTfZhIDNeGMrOXIw]`-\ngGPIAxBTffj`NkENRurXirVyGlDahP\ngGPIAxBTffj`NkENRurXirV~pRFa@\ngGPIAxBTijj`NfFJ\\ek\\kvBPtH\ngGPIAxBTjZh@NlEN[eApSn}@\ngGPIAxBTjZh@NlEVkeApSn{@=\ngGPIAxBTjZh@NlEVkeApSn}@\ngGPIAxBTjZh@NlEVkeApSv}@=\ngGPIAxBTjZhHDNlENkeApSv}@+\ngGPIAxBTjZhHDNlENkeApSv}@-\ngGPIAxBTjZj`NfFJ\\ek\\hNBPtH\ngGPIAxBTjZjhDNfFJ]Ek\\hNBPtH<\ngGPIAxBTjZjhDNfFJ]Ek\\hNBPtH>\ngGPIAxBTjfjPNfFJmFk\\hNBPwh\ngGPIAxBTjfj`NfFJ\\ek\\hNBPtH\ngGPIAxBTjfj`NfFJ\\em\\hNBPtH\ngGPIAxBTjfj`NfFJ\\fk\\hNBPtH\ngGPIAxBTjfj`NfFJ]Fk\\hNBPtH\ngGPIAxBTjfj`NfFJ]FkgAbVyP\\DahP\ngGPIAxBTjfj`NfFJmFk\\hNBPtH\ngGPIAxBTjfj`NfFJmFm\\hNBPtH\ngGPIEPKdkij`NfFJ]Fm\\snBPtH\ngGPIEPKdkjj`NfFJ\\em\\pNBPtH\ngGPIEPKdkjj`NfFJ\\fm\\pNBPtH\ngGPIEPKdkjj`NfFJ\\fmgAbfy`\\DahP\ngGPIEPKdkjj`NfFJ]Fm\\pNBPtH\ngGPIMP[djZX@NdEMrn{qw]`=\ngGPIMP[djZX@NdEMrn{q{^`=\ngGPIMP[lda`U@][I[WLzndMB+\ngGPIMP[lda`U@][IkWLvndMB\ngGPIMP[lda`U@][IkWLzndMB=\ngGPIMP[ldaeU@]LLTyK[ICEN[fAPRFa@>\ngGPIMP[ldaeU@]LLTyMZy`TDahP\ngGPJ@DQpSa``aBTuUPGVCFvRFJ\\wR}P`\ngGPJ@xQpSagBnFRRVj`NdDmsOKv}_@\ngGPL@DXHHPeMUTAtPqSWICEN[i^hP\ngGPL@xIpsadTajhCkQKWNSdm|OKuB\ngGPL@xQpSaddLZ@CjAnYu^O[t+\ngGPL@xQpSaddajhCharVmsOKqCP`\ngGPL@xQpSaddajhCharVmsOKqC__d`XP\ngGPLADHHhPdtuTAtXirVzwc{|dcb\ngGPLAHJPtadTajdCkQKT\ngGPLAHJPtadTajdCkQKV|oP\ngGPLAHJPtadTajhCkQKV|hP\ngGPLAHJPtadTajhCkQKV|o`\ngGPLAHJPtadTajhCkQKZ|hP\ngGPP@cTfyi`NeGH\ngGPPAcTijj`NlFJ\\xLTwbB\ngGPP`cUuyInZXCiQr\ngGPQ@c[rS\\tpGRcd\ngGPT@cYPZ`R[jj@zT\\`\ngGPTHlPxUpRjZj@zPXwe|\ngGPTHlPxUpRjZj@zPXypXeoKx\ngGPTHlQxUpRjvj@zPTwe|\ngGPTHlQxWpRjvj@zPTwe|\ngGPTIcQxIpRVjj@zTTw`|\ngGPUHlQxWpOIU[UPH]HJ[r~@<\ngGPUHlQxWpOIU[UPH]HJ[r~@>\ngGPXHlPDYIHUj@zp\\uoJD\ngGPXHlPDYIHUj@zp\\usdyK^TH\ngGPXHlPxIUMU@]XLZweB\ngGPXHlPxIUMU@]XL[WeB\ngGPXHlQxIU[U@]XJZweB\ngGPXHlQxIU[U@]XJZyLTyK^TH\ngGPXHlQxIU[U@]XJ[WeB\ngGPXHlQxIU[UPH]XJZytTeoJD<\ngGPXHlQxIU[UPH]XJZytTeoJD>\ngGPXHlQxIU[UPH]XJ[YtTeoJD<\ngGPXHlQxIU[UPH]XJ[YtTeoJD>\ngGPXIcPVIKUU@]JJP\ngGPXhlQx[crUVuPGVBfmyP`\ngGPYAcUPKdkjj`NlFJ[rA@\ngGPYAcUPKdkjj`NlFJ\\xLTwdB\ngGPYAcUPKdkjj`NlFR\\xLTwdB\ngGPYHlPDGlddJu@]XNZweB\ngGPYHlQxGdjmjhDNlEM[ra@<\ngGPYHlQxGdjmjhDNlEM[ra@>\ngGPYHlQxGdjmjhDNlEM\\zJRweB<\ngGPYHlQxGdjmjhDNlEM\\zJRweB>\ngGPYHlQxGdjmjhDNlEMkra@<\ngGPYHlQxGdjmjhDNlEMkra@>\ngGPYHlQxGdjmjhDNlEMlzJRweB<\ngGPYHlQxGdjmjhDNlEMlzJRweB>\ngGP`@TfYi`NcENZytTenlFa@\ngGP`@TfYi`NcEN[YtTenlFa@\ngGP`@TfYi`NcENkWVCP`\ngGP`@TfYi`NcENkYtTenlFa@\ngGP`@TfYjPNcENZytTenlF}@\ngGP`@TfYjPNcENZytTenmz}@\ngGP`@TfYjPNcENZytTeoLD\ngGP`@TfYjPNcENjytTenlF}@\ngGP`@TfYjPNcENjytTeoLD\ngGP`@TfYjPNmEV[{AN{l\ngGP`@TfYjPNmEV[{AN{t\ngGP`@TfYjPNmEVk{AN{l\ngGP`@TfYjPNmEVk{AN{t\ngGP`@TfYjPNmEVlzJRwvB]wh\ngGP`@TfYjhhNcENZwVCP`<\ngGP`@TfYjhhNcENZwVCP`>\ngGP`@TfYjhhNcENZwV}P`<\ngGP`@TfYjhhNcENZyLTyK]XMB<\ngGP`@TfYjhhNcENZyLTyK]XMB>\ngGP`@TfYjhhNcENZytTenlFa@<\ngGP`@TfYjhhNcENZytTenlFa@>\ngGP`@TfYjhhNcENZytTenlF~@<\ngGP`@TfYjhhNcENZytTenlF~@>\ngGP`@TfYjhhNcENZytTenmza@<\ngGP`@TfYjhhNcENjwVCP`<\ngGP`@TfYjhhNcENjwVCP`>\ngGP`@TfZfPNeIUrM{Yw]`\ngGP`@TfZfPNeIV]EI[d[wSn}@\ngGP`@TfZjeDdNcENZwVCP`\ngGP`@TfZjeDdNcENZwVC_@<\ngGP`@TfZjeDdNcENZyHXiK]XMB<\ngGP`@TfZjeDdNcENZyHXiK]XMB>\ngGP`@TfZjeDdNcENZyHXiK]XM|<\ngGP`@TfZjeDdNcENZyhXirVzpZD\ngGP`@TfZjeDdNcENZypXenlFa@<\ngGP`@TfZjeDdNcENZypXenlFa@>\ngGP`@TfZjeDdNcENZypXenlF~@>\ngGP`@TfZjeDdNcENZytTenlFa@\ngGP`@TfZjeDdNcENZytTenlF~@<\ngGP`@TfZjeDdNcENZytTenlF~@>\ngGP`@TfZjeDdNcEN[WVCP`<\ngGP`@TfZjeDdNcEN[WVCP`>\ngGP`@TfZjeDdNcEN[YtTynlFa@<\ngGP`@TfZjeDdNcEN[YtTynlFa@>\ngGP`@TfZjeDdNcENkWVCP`\ngGP`@TfZjeDhNcENZwVCP`<\ngGP`@TfZjeDhNcENZwVCP`>\ngGP`@TfZjeDhNcENZwVC_@<\ngGP`@TfZjeDhNcENZwVC_@>\ngGP`@TfZjeDhNcENZyHXiK]XMB<\ngGP`@TfZjeDhNcENZyHXiK]XMB>\ngGP`@TfZjeDhNcENZyhXirVzpZD<\ngGP`@TfZjeDhNcENZyhXirVzpZD>\ngGP`@TfZjeDhNcENZypXenlFa@<\ngGP`@TfZjeDhNcENZypXenlFa@>\ngGP`@TfZjeDhNcENZypXynlFa@>\ngGP`@TfZjeDhNcENZytTenlFa@<\ngGP`@TfZjeDhNcENZytTenlFa@>\ngGP`@TfZjeDhNcENZytTenlF~@<\ngGP`@TfZjeDhNcENZytTenlF~@>\ngGP`@TfZjeDhNcENZytTenmz~@<\ngGP`@TfZjeDhNcEN[WVCP`<\ngGP`@TfZjeDhNcEN[WVCP`>\ngGP`@TfZjeDhNcEN[YpXenlFa@<\ngGP`@TfZjeDhNcENkWVCP`<\ngGP`@TfZjeDhNcENkWVCP`>\ngGP`@TfzZihNcENZweB>\ngGP`@TfzZihNcENZytTeneva@>\ngGP`@TfzZihNmKM[x[VzD<\ngGP`@TfzZihNmKM[x[VzD>\ngGP`@dfnjPNcGIZyr\\enbF}@\ngGP`@dfnjPNcGIZyr\\eoBD\ngGP`@dfnj`NcGIZwQCP`\ngGP`@dfnj`NcGIZyHXiK]DMB\ngGP`@dfnj`NcGIZyHXiK]DM|\ngGP`@dfnj`NcGIZyr\\enbFa@\ngGP`@dfnj`NcGIZyr\\enbF~@\ngGP`@dfnj`NcGIZyr\\encza@\ngGP`@dfnj`NcGI[WQCP`\ngGP`@dfnj`NcGIjyHXiK]DMB\ngGP`@dfnjiDNcGIZyHTyK]DMB<\ngGP`@dfnjiDNcGIZyHTyK]DMB>\ngGP`@dfnjiDNcGIZypTenbFa@<\ngGP`@dfnjiDNcGIZypTenbFa@>\ngGP`@dfnjiDNcGIZypTenbF~@<\ngGP`@dfnjiDNcGIZypTencza@<\ngGP`@dfnjiDNcGIZypTencza@>\ngGP`@dfyh@NiFzN{l=\ngGP`@dfyh@NiFzN{t\ngGP`@dfyh@NiFzO[t=\ngGP`@dfyh@NiGNbdmt]wh\ngGP`@dfyh@NiGNbgMt^wh\ngGP`@dfyi`NcGIZwQ{P`\ngGP`@dfyi`NcGIZwQ{PdlRP\ngGP`@dfyi`NcGIZwQ{_@\ngGP`@dfyi`NcGIZweB\ngGP`@dfyi`NcGIZwe|\ngGP`@dfyi`NcGIZytTencva@\ngGP`@dfyi`NcGIZytTeoJD\ngGP`@dfyi`NcGIZytTyncva@\ngGP`@dfyi`NcGIZytTyncv~@\ngGP`@dfyi`NcGIZytTyoJD\ngGP`@dfyi`NcGI[WQ{P`\ngGP`@dfyi`NcGI[WeB\ngGP`@dfyi`NcGI[YtTyncva@\ngGP`@dfyi`NcGI[YtTyoJD\ngGP`@dfyi`NeGUt]wX\ngGP`@dfyi`NeGUt]wh\ngGP`@dfyi`NeGUt^wX\ngGP`@dfyi`NeGUt^wh\ngGP`@dfyi`NeGV]EN[h}oP\ngGP`@dfyj`NcGIZwQCP`\ngGP`@dfyj`NcGIZwQCPdlRP\ngGP`@dfyj`NcGIZwQ}_@\ngGP`@dfyj`NcGIkWQCP`\ngGP`@dfyjidNcGIZwQC_@<\ngGP`@dfyjidNcGIZwQC_@>\ngGP`@dfyjidNcGIZyLTyK]DM|>\ngGP`@dfyjidNcGIZytTenbF~@<\ngGP`@dfyjidNcGIZytTenbF~@>\ngGP`@dfyjidNcGIZytTynbFa@<\ngGP`@dfyjidNcGIZytTynbFa@>\ngGP`@dfyjidNcGIZytTynbF~@<\ngGP`@dfyjidNcGIZytTynbF~@>\ngGP`@dfyjidNcGI[WQCP`<\ngGP`@dfyjidNcGI[WQCP`>\ngGP`@dfyjidNcGI[YtTynbFa@>\ngGP`@dfyjidNcGIjwQC_@<\ngGP`@dfyjidNcGIjwQC_@>\ngGP`@dfzh@NiFzN{l=\ngGP`@dfzh@NiFzN{t\ngGP`@dfzh@NiGICEI[h{oP\ngGP`@dfzhIDNiGNBdmt]wh<\ngGP`@dfzhIDNiGNBdmt]wh>\ngGP`@dfzj`NcGIZwQCP`\ngGP`@dfzj`NcGIZyhXirVzHZD\ngGP`@dfzjeEdNcGIZypTynbFa@<\ngGP`@dfzjeEdNcGIZypTynbFa@>\ngGP`@dfzjeEhNcGIZypTynbFa@>\ngGP`ADkjj`NjENRuolDahP\ngGP`ADkjj`NjENRurPqSf~pRFa@\ngGP`ADkjj`NjENRus`qK_XIC_@\ngGP`ADkjj`NjENRus`qS_XICP`\ngGP`ADkjj`NjENRvolDahP\ngGP`ADkjj`NjENcVolDahP\ngGP`ADkjj`NjENcVrPqSf~pRFa@\ngGP`ATeVn`NeDh\ngGP`ATffj`NcENRwVBP`\ngGP`ATffjiDNcENRwVB_@<\ngGP`ATffjiDNcENRwVB_@>\ngGP`ATffjiDNcENRytTenlDa@<\ngGP`ATffjiDNcENRytTenlDa@>\ngGP`ATffjiDNcENSWVBP`>\ngGP`Adeij`NcEIZwQCP`\ngGP`Adijj`NjFJRuodDahP\ngGP`Adijj`NjFJRuodD~o`\ngGP`Adijj`NjFJRurPqrV~WbFa@\ngGP`Adijj`NjFJRus`qS_HICP`\ngGP`Adijj`NjFJRus`qS_KqCP`\ngGP`Adijj`NjFJSVs`qS_HICP`\ngGP`Adijj`NjFJbus`qS_HICP`\ngGP`AdijjiDNjFJRuodDao`<\ngGP`AdijjiDNjFJRuodDao`>\ngGP`AdijjiDNjFJRurPqSf~PRFa@>\ngGP`AdijjiDNjFJRurPqSf~WbFa@<\ngGP`AdijjiDNjFJRurPqSf~WbFa@>\ngGP`AdijjiDNjFJRurPqrV~PRF~@>\ngGP`AdijjiDNjFJRus`qK_HIC_@<\ngGP`AdijjiDNjFJRus`qK_HIC_@>\ngGP`AdijjiDNjFJRus`qK_KqC_@>\ngGP`AdijjiDNjFJRus`qS_HIC_@<\ngGP`AdijjiDNjFJRus`qs_HICP`<\ngGP`AdijjiDNjFJRus`qs_HICP`>\ngGP`AdijjiDNjFJRus`qs_HIC_@<\ngGP`AdijjiDNjFJRus`qs_HIC_@>\ngGP`AdijjiDNjFJRus`qs_KqCP`<\ngGP`AdijjiDNjFJRus`qs_KqCP`>\ngGP`AdijjiDNjFJRvodDahP<\ngGP`AdijjiDNjFJRvodDahP>\ngGP`AdijjiDNjFJRvs`qS_HICP`<\ngGP`AdijjiDNjFJRvs`qS_HICP`>\ngGP`AdijjiDNjFJRvs`qs_HICP`<\ngGP`AdijjiDNjFJRvs`qs_HICP`>\ngGP`AdijjiDNjFJSUs`qK_HIC_@<\ngGP`AdijjiDNjFJSUs`qK_HIC_@>\ngGP`AdijjiDNjFJbus`qK_HIC_@<\ngGP`AdijjiDNjFJbus`qs_HICP`<\ngGP`AdijjiDNjFJbus`qs_HICP`>\ngGP`AdijjiDNjFJbvs`qs_HICP`<\ngGP`AdijjiDNjFJbvs`qs_HICP`>\ngGPa@SrSLuHGQbgM\\zJRwVC^`\ngGPa@SrSMSHGQbgM\\zJRwV{^`\ngGPa@erS\\t@GTc]G]v=\ngGPa@erS\\t@GTc]G]z\ngGPa@erS\\t@GTc]Gmz=\ngGPa@erS\\tpGQcdm[ra@\ngGPa@erS\\uPGQcdm[hahP\ngGPa@erS\\uPGQcdm[hah_rVIH\ngGPa@erS\\uTrGQcdmkhahP<\ngGPa@iJS]T@GTc]G]v=\ngGPa@krS\\t@GTc]Gmz\ngGPa@mrS\\uPGRcjzO[t\ngGPdCPVZ`R[ij@ztTyoEt\ngGPdE`DRPrRRrtAu`ek^TH\ngGPdH`DTHrRPkTAu`yK]DM|\ngGPdH`DWprRPkTAu`yK]DM|\ngGPdH`VTlRjZj@zHXzM_XIC_@\ngGPdH`VUpRjZj@zHXzM_XIC_@\ngGPdH`xUpRjZj@zHXyK_XIC_@\ngGPdH`xUpRjZj@zHXyKgAbV~pRF~@\ngGPdH`xUpRjZj@zHXzM_XIC_@\ngGPdH`xUpRjZj@zHXzMgAbV~pRF~@\ngGPdH`xUpRjZj`PzHXyM_XIC_@<\ngGPdH`xUpRjZj`PzHXyM_XIC_@>\ngGPdH`xV`RjZj@zHXzM]XIB\ngGPdI`VIpRVjj@zLTfm_CqCP`\ngGPeE`DSpGIM\\uRH]FNSUnbFa@>\ngGPeH`VUDliUMU@]DL]FnlDa@\ngGPh@iPIMuP@]RMt]wX=\ngGPh@iPIMuP@]RMt]wh\ngGPh@iPIMuP@]RMt^wh=\ngGPh@iPIMuP@]RN\\EI[h{oP>\ngGPh@iPIMuS@]FNRuncva@\ngGPh@iPIMuS@]FNRuoJD\ngGPh@iPIMuS@]FNRvncva@\ngGPh@iPIMuS@]FNRvoJD\ngGPh@iPIMuS@]JNkh{oP\ngGPh@iPIMuU@]FNRunbFa@\ngGPh@iPIMuUSH]FNRvnbFa@>\ngGPhCPDILuK@]JR[h[vp\ngGPhCPDILuK@]JR[h[wP\ngGPhCPDILuK@]ZJ\\`\ngGPhCPDILuK@]ZJ\\wfz\ngGPhCPDILuSRH]ZJ\\wP}``>\ngGPhCPDILuSRH]ZJ\\wfB<\ngGPhCPDILuSRH]ZJ\\wfB>\ngGPhCQBILuK@]ZJ\\wfz\ngGPhCQDILuSRH]ZJ\\wfB>\ngGPhCQbILuSRH]ZJ\\wfB>\ngGPhCQxILsS@]ZJ\\wfB\ngGPhCQxILuK@]ZJ\\wP}n`\ngGPhCQxILuK@]ZJ\\wfz\ngGPhDPDIMuUJKH]ZNZytTeoJD<\ngGPhDPDIMuUJKH]ZNZytTeoJD>\ngGPhH`DYIHUi@zH\\ek^DH\ngGPhH`DYIHUi@zH\\ekgIrVzH[t\ngGPhH`DYIHUi@zH\\fk]DMz\ngGPhH`DYIHUi@zH\\fk^DH\ngGPhH`DYIHUj@zH\\ek]DMB\ngGPhH`DYIHUj@zH\\ekgIrVzHZD\ngGPhH`DYIHUj@zH\\em]DMB\ngGPhH`DYIHUj@zH\\fk]DMB\ngGPhH`DYIHUj@zH\\fk]DM|\ngGPhH`DYIHUj@zH\\fm]DMB\ngGPhH`xIUMU@]TL\\ek_XICP`\ngGPhH`xIUMU@]TL\\ek_[q}P`\ngGPhH`xIUMU@]TL\\ekgAbV~pRF~@\ngGPhH`xIUMU@]TL\\ekgAbV~wcza@\ngGPhH`xIUMU@]TL\\em_XICP`\ngGPhH`xIUMU@]TL]Fm_XICP`\ngGPhH`xYIHZj@zH\\ek]DMB\ngGPhHaVYICE`@z`[h{oP\ngGPhHaVYICJ`@z`[h{np=\ngGPhHaxIU[U@]TJ\\ek_XICP`\ngGPhHaxIU[U@]TJ]Fm_XICP`\ngGPhHaxIU[UPH]TJ\\fk_XICP`<\ngGPhHaxYICJ`@z`[h{oP\ngGPhI`xIKUU@]FJRuoaxahP\ngGPhaePRUrUuUPGUCEIkWtBPtH\ngGPhaePRUrUuUPGUCEIkYpXiohDahP\ngGPiAePKdkjj`NjFJSVs`qS_PICP`\ngGPiCPDWdfZe`NeIMtM{X\ngGPllQHR`TaNliM]U@]ZNZyr\\eoJD\ngGPmLQHR`TaNRZzj@zt\\usdyK^TH\ngGQ@@dmMTAuXirVm}`dMB\ngGQ@@dmMTAuXirVm}`dM|\ngGQ@@dmMTAuXirVu}`dMB\ngGQ@@dmMTAuXirZu}`dMB\ngGQ@@dmUTAuXirVm}`dMB\ngGQ@@dmUTAuXirVm}`dM|\ngGQ@@dmUTAuXirVnRFJ\\wvBPtH\ngGQ@@dmUTAuXirVn\\FJ[{AHZD\ngGQ@@dmUTAuXirVu}`dMB\ngGQ@@dsM@AthyolD{np=\ngGQ@@dsM@AthyolD{oP\ngGQ@@dsM@AthyolD}oP=\ngGQ@@dsM@Athyomx{np=\ngGQ@@dsM@Athyomx{oP\ngGQ@@dsM@AthyshiK_XIw^`\ngGQ@@dsM@AthyshiK_[qw^`\ngGQ@@dsM@Athyshis_XI{^`\ngGQ@@dsM@Athyshis_[q{^`\ngGQ@@dsM@AthzolD{np=\ngGQ@@dsM@AthzolD{oP\ngGQ@@dsM@AthzolD}oP=\ngGQ@@dsM@AthzshiK_XIw^`\ngGQ@@dsM@Athzshis_XI{^`\ngGQ@@dsMLAuXirVmu`tH\ngGQ@@dsMLAuXirVmu`wp\ngGQ@@dsMLAuXirVmuoTH\ngGQ@@dsMLAuXirVm}`gmB\ngGQ@@dsMLAuXirVm}`gm|\ngGQ@@dsMLAuXirVn]EI[kAhP\ngGQ@@dsMLAuXirVn]EI[kAo`\ngGQ@@dsMLAuXirVn]EI[k^hP\ngGQ@@dsMLAuXirVn]EI[{AOZD\ngGQ@@dsMLAuXirVn]EI[{AO[x\ngGQ@@dsMLAuXirVn]EI[{^OZD\ngGQ@@dsMLAuXirVn]EN[kAhP\ngGQ@@dsMLAuXirVn]EN[kAo`\ngGQ@@dsMLAuXirVn]EN[k^hP\ngGQ@@dsMLAuXirVn]EN[{AOZD\ngGQ@@dsMLAuXirVn]EN[{AO[x\ngGQ@@dsMLAuXirVn]EN[{^OZD\ngGQ@@dsMLAuXirVu}`gmB\ngGQ@@dsMLAuXirVv]EI[{AOZD\ngGQ@@dsMLAuXirVv]EN[kAhP\ngGQ@@dsMLAuXirVv]EN[{AOZD\ngGQ@@dsMLAuXitVmu`tH\ngGQ@@dsMLAuXitVmu`wp\ngGQ@@dsMLAuXitVm}`gmB\ngGQ@@dsMLAuXitVm}`gm|\ngGQ@@dsMLAuXitVn]EI[kAhP\ngGQ@@dsMLAuXitVn]EI[kAo`\ngGQ@@dsMLAuXitVn]EI[{AOZD\ngGQ@@dsMLAuXitVn]EI[{AO[x\ngGQ@@dsMLAuXitVn]EN[kAhP\ngGQ@@dsMLAuXitVn]EN[kAo`\ngGQ@@dsMLAuXitVn]EN[{AOZD\ngGQ@@dsMLAuXitVn]EN[{AO[x\ngGQ@@dsMLAuXitVuu`tH\ngGQ@@dsMLAuXitVu}`gmB\ngGQ@@dsMLAuXitVv]EN[kAhP\ngGQ@@dsMLAuXitVv]EN[{AOZD\ngGQ@@dsMLAuhjs_XIw]`\ngGQ@@dsMLAuhjs_XIw^`\ngGQ@@dsMLAuhjs_XI{]`\ngGQ@@dsMLAuhjs_XI{^`\ngGQ@@dsMLAuhjs_[qw^`\ngGQ@@dsMLAuhjsgQSf~pSv{@\ngGQ@@dsMLAuhjsgQSf~pSv}@\ngGQ@@dsMLAuhju_XIw^`\ngGQ@@dsMLAuhju_XI{]`\ngGQ@@dsMLAuhju_XI{^`\ngGQ@@dsMLAuhjugQSf~pSv{@\ngGQ@@dsMLAuhjugQSf~pSv}@\ngGQ@@dsMTAuXirVm}`dMB\ngGQ@@dsMTAuXirVm}`dMC~RqI@\ngGQ@@dsMTAuXirVm}oDMB\ngGQ@@dsMTAuXirVnSENRwvBPtH\ngGQ@@dsMTAuXirVnSENRwv|PtH\ngGQ@@dsMTAuXirZvSENRwvBPtH\ngGQ@@dsMTAuXitVm}`dMB\ngGQ@@dsMTAuXitVm}`dMC~RqI@\ngGQ@@dsMTAuXitVm}`gu|\ngGQ@@dsMTAuXitZu}`dMB\ngGQ@@dsMUDauXirVm}`dM|<\ngGQ@@dsMUDauXirVm}`dM|>\ngGQ@@dsMUDauXirVnSENRwvBPwp<\ngGQ@@dsMUDauXirVnSENRwvBPwp>\ngGQ@@dsMUDauXirVnSENRwv|Pwp>\ngGQ@@dsMUDauXirVn]EI[{AH[x<\ngGQ@@dsMUDauXirVn]EI[{AH[x>\ngGQ@@dsMUDauXirVn]EI[{AH[{|ebR>\ngGQ@@dsMUDauXirVn]EN[{AHZD<\ngGQ@@dsMUDauXirVn]EN[{AHZD>\ngGQ@@dsMUDauXirVn]EN[{AHZG|ebR<\ngGQ@@dsMUDauXirVn]EN[{AHZG|ebR>\ngGQ@@dsMUDauXirVn]EN[{AH[x<\ngGQ@@dsMUDauXirVn]EN[{AH[x>\ngGQ@@dsMUDauXirVn]EN[{AOkx<\ngGQ@@dsMUDauXirVn]EN[{AOkx>\ngGQ@@dsMUDauXirVn]EN[{^HZD<\ngGQ@@dsMUDauXirVn]EN[{^HZD>\ngGQ@@dsMUDauXirVv]EN[{AHZD<\ngGQ@@dsMUDauXirVv]EN[{AHZD>\ngGQ@@dsMUDauXitVm}`dM|<\ngGQ@@dsMUDauXitVm}`dM|>\ngGQ@@dsMUDauXitVn]EI[{AH[x<\ngGQ@@dsMUDauXitVn]EN[{AHZD<\ngGQ@@dsMUDauXitVn]EN[{AHZD>\ngGQ@@dsMUDauXitVu}`dMB<\ngGQ@@dsMUDauXitVu}`dMB>\ngGQ@@dsT`Athyncn{@=\ngGQ@@dsT`Athyncn}@\ngGQ@@dsT`Athyncv}@=\ngGQ@@dsT`Athyomt{np=\ngGQ@@dsT`Athyomt{oP\ngGQ@@dsT`Athys`qK]G]z\ngGQ@@dsT`Athys`qK_[iw^`\ngGQ@@dsT`AthyshiK]G]z\ngGQ@@dsT`AthyshiK_[iw^`\ngGQ@@dsT`Athyshis_[i{^`\ngGQ@@dsT`AuIWHwmg]v=\ngGQ@@dsT`AuIWHwmg]z\ngGQ@@dsT`AuIWHwmgmz=\ngGQ@@dsT`AuIWHwng]v=\ngGQ@@dsT`AuIWHwng]z\ngGQ@@dsT`AuIYtTenQo]N{t\ngGQ@@dsTlAtYIKV~F}na@\ngGQ@@dsTlAtYIKZyF}l}hP\ngGQ@@dsTlAuXirVnZFJ\\encva@\ngGQ@@dsTlAuXirVn]EN[{]OZD\ngGQ@@dsUAHathyolD{np+\ngGQ@@dsUAHathyolD{np-\ngGQ@@dsUAHathyolD{oP<\ngGQ@@dsUAHathyolD{oP>\ngGQ@@dsUAHathyolD}oP+\ngGQ@@dsUAHathyolD}oP-\ngGQ@@dsUAHathyomx{np+\ngGQ@@dsUAHathyomx{np-\ngGQ@@dsUAHathyomx{oP<\ngGQ@@dsUAHathyomx{oP>\ngGQ@@dsUAHathyrPqRV~pSn}@<\ngGQ@@dsUAHathyrPqRV~pSn}@>\ngGQ@@dsUAHathys`qK_XIw^`<\ngGQ@@dsUAHathys`qK_XIw^`>\ngGQ@@dsUAHathyshiK_XIw^`<\ngGQ@@dsUAHathyshiK_XIw^`>\ngGQ@@dsUAHathyshiK_[qw^`<\ngGQ@@dsUAHathyshiK_[qw^`>\ngGQ@@dsUAHathyshis_XI{^`<\ngGQ@@dsUAHathyshis_XI{^`>\ngGQ@@dsUAHathyshis_[q{^`<\ngGQ@@dsUAHathyshis_[q{^`>\ngGQ@@dsUAHathzolD{np+\ngGQ@@dsUAHathzolD{np-\ngGQ@@dsUAHathzolD{oP<\ngGQ@@dsUAHathzolD{oP>\ngGQ@@dsUAHathzolD}oP-\ngGQ@@dsUAHathzs`qK_XIw^`<\ngGQ@@dsUAHathzs`qK_XIw^`>\ngGQ@@dsUMHauXirVmu`tH<\ngGQ@@dsUMHauXirVmu`tH>\ngGQ@@dsUMHauXirVm}`gmB<\ngGQ@@dsUMHauXirVm}`gmB>\ngGQ@@dsUMHauXirVm}`gm|>\ngGQ@@dsUMHauXirVnRFJ\\wVCP`<\ngGQ@@dsUMHauXirVnZFJ\\enlFa@>\ngGQ@@dsUMHauXirVn\\FN[{AOZD<\ngGQ@@dsUMHauXirVn\\FN[{AOZD>\ngGQ@@dsUMHauXirVn]EI[kAhP<\ngGQ@@dsUMHauXirVn]EI[kAhP>\ngGQ@@dsUMHauXirVn]EI[kAo`<\ngGQ@@dsUMHauXirVn]EI[kAo`>\ngGQ@@dsUMHauXirVn]EI[k^hP>\ngGQ@@dsUMHauXirVn]EI[{AO[x>\ngGQ@@dsUMHauXirVn]EI[{^OZD<\ngGQ@@dsUMHauXirVn]EN[kAhP<\ngGQ@@dsUMHauXirVn]EN[kAhP>\ngGQ@@dsUMHauXirVn]EN[{AOZD<\ngGQ@@dsUMHauXirVn]EN[{AOZD>\ngGQ@@dsUMHauXirVuu`tH<\ngGQ@@dsUMHauXitVmu`tH<\ngGQ@@dsUMHauXitVmu`tH>\ngGQ@@dsUMHauhjs_XIw]`<\ngGQ@@dsUMHauhjs_XIw]`>\ngGQ@@dsUMHauhjs_[qw]`<\ngGQ@@dsUMHauhjs_[qw]`>\ngGQ@@dsUThdauXirVm}`dM|<\ngGQ@@dsUThdauXirVm}`dM|>\ngGQ@@dsUThdauXirVnRFJRwvBPwp<\ngGQ@@dsUThdauXirVnRFJ\\wvBPtH>\ngGQ@@dsUThdauXirVnSENRwvBPwp>\ngGQ@@dsUThdauXirVn\\FN[{AHZD<\ngGQ@@dsUThdauXirVn\\FN[{AHZD>\ngGQ@@dsUThdauXirVn]EI[{AH[x<\ngGQ@@dsUThdauXirVn]EI[{AH[x>\ngGQ@@dsUThdauXirVn]EN[{AHZD<\ngGQ@@dsUThdauXirVn]EN[{AHZD>\ngGQ@@dsUThdauXirVn]EN[{AH[x<\ngGQ@@dsUThdauXirVn]EN[{AH[x>\ngGQ@@dsUThdauXirVn]EN[{AOkx<\ngGQ@@dsUThdauXirVn]EN[{AOkx>\ngGQ@@dsUThdauXirVn]EN[{^HZD<\ngGQ@@dsUThdauXirVn]EN[{^HZD>\ngGQ@@dsUThdauXirVn]EN[{^Okx<\ngGQ@@dsUThdauXirVu}`dMB<\ngGQ@@dsUThdauXirVv]EN[{AHZD<\ngGQ@@dsUThdauXirVv]EN[{AHZD>\ngGQ@@dsUThdauXitVn]EN[{AHZD<\ngGQ@@dsUThdauXitVn]EN[{AHZD>\ngGQ@@dsUTheAuXirVm}`dM|<\ngGQ@@dsUTheAuXirVm}`dM|>\ngGQ@@dsUTheAuXirVm}oDM|<\ngGQ@@dsUTheAuXirVnRFJRwvBPwp>\ngGQ@@dsUTheAuXirVnRFJ\\wvBPtH<\ngGQ@@dsUTheAuXirVnRFJ\\wvBPtH>\ngGQ@@dsUTheAuXirVn\\FN[{AHZD<\ngGQ@@dsUTheAuXirVn\\FN[{AHZD>\ngGQ@@dsUTheAuXirVn]EI[{AH[x<\ngGQ@@dsUTheAuXirVn]EI[{AH[x>\ngGQ@@dsUTheAuXirVn]EI[{^H[x>\ngGQ@@dsUTheAuXirVn]EN[{AHZD<\ngGQ@@dsUTheAuXirVn]EN[{AHZD>\ngGQ@@dsUTheAuXirVn]EN[{AH[x<\ngGQ@@dsUTheAuXirVn]EN[{AH[x>\ngGQ@@dsUTheAuXirVn]EN[{AOkx<\ngGQ@@dsUTheAuXirVn]EN[{AOkx>\ngGQ@@dsUTheAuXirVu}`dMB<\ngGQ@@dsUTheAuXirVu}`dMB>\ngGQ@@dsUTheAuXirVv]EN[{AHZD<\ngGQ@@dsUTheAuXitVm}`dM|>\ngGQ@@dsUTiDauXirVn]EN[{^HZD<\ngGQ@@dsUTiDauXirVn]EN[{^HZD>\ngGQ@@dsUTiDauXitVn\\FN[{AHZD<\ngGQ@@dsUTiDauXitVn\\FN[{AHZD>\ngGQ@@dsUTiDauXitVn]EN[{AHZD>\ngGQ@@dsUUHauXirVm}`dMB<\ngGQ@@dsUUHauXirVm}`dMB>\ngGQ@@dsUUHauXirVm}`dMC~RqI@<\ngGQ@@dsUUHauXirVm}`gu|>\ngGQ@@dsUUHauXirVm}oDMB<\ngGQ@@dsUUHauXirVm}oDMB>\ngGQ@@dsUUHauXirVm}oGu|<\ngGQ@@dsUUHauXirVnSENRwvBPtH<\ngGQ@@dsUUHauXirVnSENRwvBPtH>\ngGQ@@dsUUHauXirVnSENRwv|PtH<\ngGQ@@dsUUHauXirVnZFJ\\eolDahP<\ngGQ@@dsUUHauXirVnZFJ\\eolDahP>\ngGQ@@dsUUHauXirVnZFJ\\eomxahP<\ngGQ@@dsUUHauXitVm}`dMB<\ngGQ@@dsUUHauXitVm}`dMB>\ngGQ@@dtuRAuXirVmu`dH\ngGQ@@dtuRAuXirVnSENRwVBP`\ngGQ@@dtuRAuXirVn\\FI[kAHP\ngGQ@@dtuRAuXirVn\\FI[{AH[t\ngGQ@@dtuRAuXitZn\\FI[kAHP\ngGQ@@dtuSHauXirVmu`gp>\ngGQ@@dtuSHauXirVnRFJRwVBP`<\ngGQ@@dtuSHauXirVnRFNRwVB_@<\ngGQ@@dtuSHauXirVnSENRwVB_@>\ngGQ@@dtuSHauXirVn]EI[kAHP<\ngGQ@@dtuSHauXirVn]EI[kAHP>\ngGQ@@dtuSHauXirVn]EI[{AH[t<\ngGQ@@dtuSHauXirVn]EI[{AH[t>\ngGQ@@dtuSHauXirVn]GI[kAO`<\ngGQ@@dtuSHauXirZn]EI[kAHP<\ngGQ@@dtuSHauXirZn]EI[kAHP>\ngGQ@@dtuTAuXirVm}`dMB\ngGQ@@dtuTAuXirVm}oGuB\ngGQ@@dtuTAuXirVnSENRwvBPtH\ngGQ@@dtuTAuXirVnSENRwvBPwp\ngGQ@@dtuTAuXirVn\\FI[{AHZD\ngGQ@@dtuTAuXirVn\\FI[{AH[x\ngGQ@@dtuTAuXirVu}`dMB\ngGQ@@dtuTAuXitZm}`dMB\ngGQ@@dtuUHauXirVm}`guB<\ngGQ@@dtuUHauXirVm}`guB>\ngGQ@@dtuUHauXirVnRFJRwvBPtH<\ngGQ@@dtuUHauXirVnRFJRwvBPtH>\ngGQ@@dtuUHauXirVnRFNRwvB_TH<\ngGQ@@dtuUHauXirVnRFNRwvB_TH>\ngGQ@@dtuUHauXirVnSENRwvB_TH<\ngGQ@@dtuUHauXirVn]EI[{AHZD<\ngGQ@@dtuUHauXirVn]EI[{AHZD>\ngGQ@@dtuUHauXirVn]EI[{AHZG|dcb>\ngGQ@@dtuUHauXirVn]EI[{AH[x<\ngGQ@@dtuUHauXirVn]EI[{AH[x>\ngGQ@@dtuUHauXirVn]EI[{AOjD<\ngGQ@@dtuUHauXirVn]EI[{AOjD>\ngGQ@@dtuUHauXirVn]EI[{^OjD<\ngGQ@@dtuUHauXirVn]EI[{^OjD>\ngGQ@@dtuUHauXirVn]GI[{AOjD<\ngGQ@@dtuUHauXirVn]GI[{AOjD>\ngGQ@@dtuUHauXirVn]GI[{AOkx<\ngGQ@@dtuUHauXirVn]GI[{AOkx>\ngGQ@@dtuUHauXirVv]EI[{AHZD<\ngGQ@@dtuUHauXirZm}`dMB<\ngGQ@@dtuUHauXirZm}`dMB>\ngGQ@@dtuUHauXirZm}`dM|<\ngGQ@@dtuUHauXirZn\\FI[{AHZD<\ngGQ@@dtuUHauXirZn\\FI[{AHZD>\ngGQ@@dtuUHauXirZn]EI[{AHZD<\ngGQ@@dtuUHauXirZn]EI[{AHZD>\ngGQ@@dtuUHauXirZu}`dMB<\ngGQ@@dtuUHauXirZu}`dMB>\ngGQ@@dtuUHauXitVm}`guB<\ngGQ@@dtuUHauXitVm}`guB>\ngGQ@@dtuUHauXitVn]GI[{AOjD>\ngGQ@@dwSTAtYYKVyFulahP\ngGQ@@dwSTAuXirVmtPtH\ngGQ@@dwSTAuXirVm|ndMB\ngGQ@@dwSULauXirVn]EN[hahP>\ngGQ@@dwSULauXirVn]EN[y]HZD<\ngGQ@@eMUTAtpqSdm[eApRFa@\ngGQ@@eMUTAtpqSdm[eApRFaIHx`\ngGQ@@eMUTAtpqSdm[eApRF~@\ngGQ@@eMUTAtpqSdm[eApSz~@\ngGQ@@eMUTAtpqSdm\\dLTynTGAHZD\ngGQ@@eMUTAtpqSdm\\dLTynU{AHZD\ngGQ@@eMUTAtpqSdm\\xLRwJC`dM|\ngGQ@@eMUTAtpqSdm\\xLRwJ}`dM|\ngGQ@@eMUTAtpqSdm\\xLTwJC`dMB\ngGQ@@eMUTAtpqSdm\\xLTwJ}`dMB\ngGQ@@eMUTAtpqSdmkeApRFa@\ngGQ@@eMUTAtpqSdmkeApRFaIHx`\ngGQ@@eMUTAtpqSdukeApRFa@\ngGQ@@eMUTAtpqShukeApRFa@\ngGQ@@eMUTAtpqShulxLTwJ}`dMB\ngGQ@@eMUTAtpqUdm[eApRFa@\ngGQ@@eMUTAtpqUdm\\xLRwJC`dM|\ngGQ@@eMUTAtpqUdm\\xLTwJC`dMB\ngGQ@@eMUTAtpqUdulxLTwJC`dMB\ngGQ@@eMUUHatpqSdm\\dLTenU{AH[x>\ngGQ@@eMUUHatpqSdm\\xLTwJC`dM|<\ngGQ@@eMUUHatpqSdm\\xLTwJC`dM|>\ngGQ@@eMUUHatpqSdmlxLTwJC`dMB<\ngGQ@@eMUUHatpqSdmlxLTwJC`dMB>\ngGQ@@eMUUHatpqSdu[eApRF~@<\ngGQ@@eMUUHatpqSdu[eApRF~@>\ngGQ@@eMUUHatpqUdmlxLTwJC`dMB>\ngGQA@NRYjP@zT\\wQw]`=\ngGQA@NRYjP@zT\\wvz]wX=\ngGQA@NRYjP@zT\\ytTeomt{oP\ngGQAAIRYj`@zT\\wvB]wX+\ngGQAAIRYjf@zlTyK[Nbdm}`gmB>\ngGQBBGBNB\\LxYIIZj@zpRunYy^wjD\ngGQDHGBnBUSUPGUCENRwJC`dM|\ngGQDHGBnBUSUPGUCENRwJC`gu|\ngGQDHGBnBUSUPGUCENRypXenTGAH[x\ngGQDHGBnBUSUPGUCENSWJC`dM|\ngGQDHGBnBUSUPGUCEVcWJC`dM|\ngGQDJ@aABSWUPGVcdmxP`\ngGQDJIARBSWUPGVcdmx_@\ngGQDJIARBSWUPGVcdn\\gI[p~@\ngGQDLOA^FQRFj`NmDm[x^WjD\ngGQHAJAIfj@CiQs_XIw]`+\ngGQHAJAIfj@CiQs_XI{^`+\ngGQHAJAIfj@CiQu_XIw^`>\ngGQHAJAIfj@CiQu_XI{^`+\ngGQHAJAIfj@CiQugQRV~pSn}@>\ngGQHAJAIfj@CiQugQSf~pSv}@>\ngGQHAJAIfjXCjqShmk{AOZD>\ngGQHAJAIfjhCjqSdm[{AHZD>\ngGQHAjAInfhChrrZurMkYCP`\ngGQHB@aIfiXChqSfn]EI[k]hP\ngGQHB@aIfiXChqSfuyP`\ngGQHB@aIfiXChqSfv]EI[k]hP\ngGQHB@aIfiXCkRSV~F}na@\ngGQHB@aIfiXCkRSV~F}va@\ngGQHB@aIfiXCkRSWNbdm|M{mB\ngGQHB@aIfiXCkRSZ~F}na@\ngGQHB@aIfiXCkRSZ~F}va@\ngGQHB@aIfiXCkRS[Nbdm|M{mB\ngGQHB@aIfidCiRU\\c^v]wX\ngGQHB@aIfjiQJChqSjn\\FI[kAhP>\ngGQHB@aInfjZCkRsV~Fuva@<\ngGQHBGAIfiXChqSfn]EI[h^hP\ngGQHBHaIfiXChqSfn]EI[k]hP\ngGQHBHaIfiXChqSfn]EI[k]o`\ngGQHBHaIfiXChqSfn]EI[ra@\ngGQHBHaIfiXChqSfv]EI[k]hP\ngGQHBHaIfjiQIChqSfmu`tH<\ngGQHBHaIfjiQJChqSfmu`tH>\ngGQHBHaIfjiQJChqSfn]EI[kAhP<\ngGQHBHaIfjiQJChqSfn]EI[kAhP>\ngGQHBIAIfiXChqSfn]EI[k]hP\ngGQHBIAIfjiQIChqSfnSENRwVCP`>\ngGQHBIAIfjiQIChqSfn]EI[kAhP>\ngGQHBIAIfjiQJChqSfn]EI[kAhP<\ngGQHBIAIfjiQJChqSfn]EI[kAhP>\ngGQHBJqIfiXChqSfn]EI[k]hP\ngGQHBJqIfiXChqSfn]EI[ra@\ngGQHBJqIfjiQJChqSfn]EI[kAhP<\ngGQHBLQIfiXChqSfn]EI[k]hP\ngGQHBLQIfiXChqSfn]EI[ra@\ngGQHBLQIfiXChqSfv]EI[k]hP\ngGQHBLQIfjZQChqSfuu`tH<\ngGQHBLQIfjZQChqSfuu`tH>\ngGQHBLQIfjiQIChqSfmu`tH>\ngGQHBLQIfjiQJChqSfmu`tH>\ngGQHBLQInfjZChqSfn]EI[ra@>\ngGQHD@aInZ@CjQshiK]G]z\ngGQHD@aInf@CjQncn{@=\ngGQHD@aInfhChqrVmtPtH\ngGQHDHaInf@CjQncn{@=\ngGQHDOAIijjQCjqSdm\\dLTenQ{AH[x<\ngGQHDOAIijjQCjqSdm\\dLTeolDao`<\ngGQHDOAIkjjQChqrVnRFJRwQC_@<\ngGQHDOAIkjjQChqrVnRFJRwp|Pwp<\ngGQHDOAInf@CjQncn{@=\ngGQHDOAInjBQCjQoax{np+\ngGQHDOAInjBQCjQoax{np-\ngGQHH@aJnZBACiAs_XIw]`+\ngGQHH@aJnZBACiAs_XIw]`-\ngGQHH@aJnZBACiAs_XIw^`>\ngGQHH@aJnZBACiAs_[qw]`-\ngGQHH@aJnZBACiAu_XIw]`+\ngGQHH@aJnZBACiAu_XIw]`-\ngGQHH@aJnZBACiAu_XIw^`<\ngGQHH@aJnZBACiAu_XIw^`>\ngGQHH@aJnZBACiAugQRV~pSn}@<\ngGQHH@aJnZBACiAugQRV~pSn}@>\ngGQHH@aJnZZACkAUf~pSv}@<\ngGQHH@aJnZZACkAUf~pSv}@>\ngGQHH@aJnZZACkAUj~pSv}@<\ngGQHH@aJnZZACkAUj~pSv}@>\ngGQHH@aJnZjACjaShm[{AHZD>\ngGQHHDQJnZ@CiAu_XIw^`>\ngGQHHGAIZjhCjqSdm[d^pRFa@\ngGQHHGAIZjhCjqSdm[d^pRF~@\ngGQHHGAIZjhCjqSdm\\xLTwH}`dMB\ngGQHHGAIZjhCjqSdmkd^pRFa@\ngGQHHGAIZjhCjqSdukd^pRFa@\ngGQHHGAJijhCiabgIZwJC`dMB\ngGQHHGAJijhCiabgIZwJC`dM|\ngGQHHGAJijhCiabgIZwJC`guB\ngGQHHGAJijhCiabgIZwJC`gu|\ngGQHHGAJijhCiabgI[WJC`dMB\ngGQHHGAJijhCiabgI[WJC`guB\ngGQHHGAJijhCiabkQZwJC`guB\ngGQHHGAJijhCiabkQ[WJC`guB\ngGQHHGAJijhCiabkQjwJC`dMB\ngGQHHGAJkjdCjaSdm[kAHP\ngGQHHGAJkjhCjaSdm[{AHZD\ngGQHHOAJkZhCjaSdm[{AHZD\ngGQHHOAJkZhCjaShu[{AHZD\ngGQHHOAJkZhCjaShuk{AHZD\ngGQHJGAJijhCjabgI[yApRD\ngGQH`jBRnRnjj@zXXitZus@xICP`\ngGQI@jA\\e]UTAtpqSdukfApRFa@\ngGQI@jA\\e]UTAtpqSdulxLTwLC`dMB\ngGQI@jA\\e]UTAtpqShukfApRFa@\ngGQIAJB\\dsU@AthzolD}oP+\ngGQIAJB\\dtuTAuXirVm}`dMB\ngGQIAJB\\dtuTAuXitZn\\FI[{AHZD\ngGQIB@`|dsTrAuiIkgQRV~F}v}@\ngGQIHBpReWU@At`zolD{oP>\ngGQIHO@ReUuTAuPirVm}`dMB\ngGQIJO@ReTuTAuPqSdm|`xIB\ngGQLBIARFdLbdMU@]ZIZweB\ngGQLBIARFdLbdMU@]ZI[WeB\ngGQLJHaQFbLbdMU@]JIP\ngGQLJIARFdLbdMU@]JIP\ngGQLL@b^BBDfmjiDNcGIjwQCP`<\ngGQ`@ZdsMTAuhisdqSdmy``\ngGQ`@ZdwSTAtiYnam[@\ngGQ`@bdwMLAuhyk^TH\ngGQ`@bdwMLAuhym^TH\ngGQ`@bdwMRAthzncn{@\ngGQ`@bdwMRAthzncn}@\ngGQ`@bdwMRAuhyj\ngGQ`@bdwMRAuhyk^Wh\ngGQ`@bdwMUMAuhyk^TH<\ngGQ`@bdwMUMAuhyk^TH>\ngGQ`@bdwMUMAuhyk^Wp<\ngGQ`@bdwMUMAuhyk^Wp>\ngGQ`@bdwMUMAuhykgQSf|hP<\ngGQ`@bdwMUMAuhykgQSf|hP>\ngGQ`@bdwMUMAuhym^TH<\ngGQ`@bdwMUMAuhym^TH>\ngGQ`@bdwUThlauhykgARV|hP<\ngGQ`@bdwUThlauhykgARV|hP>\ngGQ`@bdwUThmAuhykgARV|hP<\ngGQ`@bdwUThmAuhykgARV|hP>\ngGQ`@bdwUThmAuhykgARV|o`<\ngGQ`@bdwUUMAuhykdabdmyP`<\ngGQ`@bdwUUMAuhykdabdmyP`>\ngGQ`@jduuTAuhyK^DH\ngGQ`@jduuTAuhyKgIrV|HP\ngGQ`@jduuTAuhyM^DH\ngGQ`ALe]UTAtPiKVzHZD\ngGQ`ALe]UTAtPiKWNCEMtPtH\ngGQ`ALe]UUDatPiKWICEN[hahP<\ngGQ`AbeMUTAtPqSVzPZD\ngGQ`AbeMUTAtPqSWICEN[iAhP\ngGQ`AbeMUTAtPqS[ICEN[iAhP\ngGQa@bnR[fjf`zt\\uoJD<\ngGQa@bnR[fjf`zt\\uoJD>\ngGQa@bnR[fjf`zt\\voJD<\ngGQa@bnR[fjf`zt\\voJD>\ngGQdEb@b^BSRuPGVbfmyP`\ngGQdEb@b^BSRuPGVbfuyP`\ngGQdEbGBNBUWUPGVBfmuOTH\ngGQdHl@btFRREZ`NlGI[h~o`\ngGQdHlGBnBUSUPGVCDmtPwp\ngGQdHlGBnBUSUPGVCDmt_Wp\ngGQdHlGBnBUSUPGVCDutPwp\ngGQdHlGBtBUSUPGVCDuxP`\ngGQdHlOB~BUVuTBGVBdutPwp>\ngGQdHlOB~BUVuTBGVBdv]EI[hao`<\ngGQdHlOB~BUVuTBGVBdv]EI[hao`>\ngGQdIbBqNBRuUPGVbfmtOWp\ngGQdLZ@a^BRuSPGRbf|G`\ngGQdhlOBt@f|eTuTAu`qM]DM|\ngGQdibOAT@e\\dmUTAuhim]CuB\ngGQeEb@bN@yIijhCkQSV|o`\ngGQeEb@bN@yIijhCkQSZ|hP\ngGQhHl@cIIBmPGQCdm[hahP\ngGQhHl@cIIBmPGQCdm[h~hP\ngGQhHl@cIIBmPGQCdmkhahP\ngGQhHl@cIIBmPGQCdmkh~hP\ngGQhHl@cIIBmPGQCdu[hahP\ngGQhHl@cIIBmPGQCdukhahP\ngGQhHl@cIIJmPGVBVmy_@\ngGQhHlBqJijhChabZv\\GI[hah_rTJH\ngGQhHlGAJijhChabVmtPtH\ngGQhHlGAJijhChabVmtPwp\ngGQhHlGCIIKUHGVBVh\ngGQhHlGCIIKUPGVBVmyP`\ngGQhHlOAJkZjAChaRVmtPtH<\ngGQhHlOAJkZjAChaRVmtPtH>\ngGQhHlOAJkZjAChaRVmt_TH<\ngGQhHlOAJkZjAChaRVmt_TH>\ngGQhHlOAJkZjAChaRVn]EI[hahP<\ngGQhHlOAJkZjAChaRVn]EI[hahP>\ngGQhHlOAJkZjAChaRVn]EI[h~hP<\ngGQhHlOAJkZjAChaRVn]EI[h~hP>\ngGQhHlOAJkZjAChaRVutPtH<\ngGQhHlOAJkZjAChaRVutPtH>\ngGQhHlOAJkZjAChaRZmtPtH<\ngGQhHlOAJkZjAChaRZmtPtH>\ngGQhHlOAJkZjAChaRZutPtH<\ngGQhHlOAJkZjAChaRZutPtH>\ngGQhHlOCIIJuHGVBVmy^`\ngGQhHlOCIIJuPGVBVmyP`\ngGQhHlOCIIJuPGVBVuyP`\ngGQiAbjA\\e]UTAtPqSZz`ZD\ngGQiHl@c]ddeVhCkAKV|hP\ngGQiHl@c]ddeVhCkAKV|o`\ngGQiHlOC]ddeZjACkAKV|hP<\ngGQiHlOC]ddeZjACkAKV|hP>\ngGR@@cTfxH@MrMkYw]`=\ngGR@@cTfyi`NeKUrMkYw]`\ngGR@@cTfyi`NeKUrMkYw^`\ngGR@@cTfyi`NeKUrMkiw^`\ngGR@@cTfzj`NeGNZFJ\\e@\ngGR@@lTfYj`NeEUt]wo{Q@\ngGR@@lTfYj`NeIUrM{Yw^mD\ngGR@@lTfxJ`NijyFul{nvf@=\ngGR@@lTfxJ`NijyFul{o_vf@=\ngGR@@m\\bdMU@]JIP\ngGR@ACTjzj`NdIMuM{_{P@\ngGR@ACTjzj`NdIMuM{o{P@\ngGRA@l]rSLuPGRdjyF}l{o_vb@\ngGRD@cYPZ`R[jj@zT\\`\ngGRDHlQxWpRjYi@zPXmH\ngGREHlQxWpTiULtpH]HL\\xJRmH<\ngGREHlQxWpTiULtpH]HL\\xJRmH>\ngGREHlQxWpWIU[U@]HJ\\xLRwe}~tP\ngGREIcQxKpTiKSU@]JJ\\xLTmH\ngGRHHlQxIU[U@]XJZweC~tP\ngGRHHlQxYIHPj@zVZwtvmtO{S@\ngGRHHlQxYIHPj@zVZwtvmww{S@\ngGRHHlQxYIHPj@zVZyr\\eoim[h_vf@\ngGRHHlQxYIHPj@zV[WtvmtO{S@\ngGRIHlQxBTjfj`NlFM[ra@\ngGRIHlQxRTjmj`NlEM[raZH\ngGT@@TfX`@MrM{Yw]`\ngGT@@TfX`@MrM{Yw^`\ngGT@@TfX`@MrM{Y{]`\ngGT@@TfX`@MrM{iw^`\ngGT@@TfX`@N]EI[d[wSn}@\ngGT@@TfXa`NdfmrM{Y{P`\ngGT@@TfXa`Ndfm|M{]B\ngGT@@TfXa`NdfurM{Y{P`\ngGT@@TfXa`Ndfu|M{]B\ngGT@@TfXbPNdfmtM{X\ngGT@@TfXbPNdfm|M{]z\ngGT@@TfXbPNhjyF}l{np\ngGT@@TfXbPNhjyF}l{oP\ngGT@@TfXbPNhjyF}l}np\ngGT@@TfXbPNhjyF}t{np\ngGT@@TfXbPNhjyF}t{oP\ngGT@@TfXbPNhkNbdmrM{iw^`\ngGT@@TfYh@NiJyF}l{np\ngGT@@TfYh@NiJyF}t{np\ngGT@@TfYi`NcENZwVCP`\ngGT@@TfYi`NcENkWH{`gmB\ngGT@@TfYjPNcENZytTeoLD\ngGT@@TfYjPNmEV[{AN{l\ngGT@@TfYjPNmEV[{AN{t\ngGT@@TfZfPNeIUrM{Yw]`\ngGT@@TfZfPNeIUrM{Yw^`\ngGT@@TfZfPNeIUrM{Y{]`\ngGT@@TfZfPNeIUrM{iw^`\ngGT@@TfZfPNeIUrN{Y{]`\ngGT@@TfZfPNeIUrN{i{^`\ngGT@@TfZjeDdNcENZwVCP`\ngGT@@TfZjeDdNcENZytTenlFa@\ngGT@@TfZjeDdNcEN[WVCP`<\ngGT@@TfZjeDdNcEN[YtTynlFa@>\ngGT@@TfZjeDdNcENkWVCP`\ngGT@@TfZjeDhNcENZwVCP`<\ngGT@@TfZjeDhNcENZwVCP`>\ngGT@@TfZjeDhNcENZyhXirVzpZD<\ngGT@@TfZjeDhNcENZytTenlFa@<\ngGT@@TfZjeDhNcENZytTenlFa@>\ngGT@@TfZjeDhNcEN[WVCP`<\ngGT@@TfZjeDhNcEN[WVCP`>\ngGT@@TfZjeDhNcEN[YpXynlFa@>\ngGT@@TfZjeDhNcENkWVCP`<\ngGT@@TfZjeDhNcENkWVCP`>\ngGT@@TfZjeDhNcENkYpXynlFa@>\ngGT@@TfxJihNefm|Mk]B<\ngGT@@TfxJihNefm|Mk]B>\ngGT@@TfxJihNefm|Mk]|>\ngGT@@TfzZihNmKM\\zJ\\wpvntH<\ngGT@@TfzZihNmKM\\zJ\\wpvntH>\ngGT@@TfzZihNmKM\\zJ\\wpzntH>\ngGT@@TfzZihNmKMlzJ\\wpvntH<\ngGT@@TfzZihNmKMlzJ\\wpvntH>\ngGT@@TjZjPNbFR\\wJC`g]z=\ngGT@@TjZjPNbFR\\wJC`gmz=\ngGT@@TjZjPNbFR\\ypXenTGAN{w}h@\ngGT@@TjZjPNbFR\\ypXenTGAO[t\ngGT@@TjZjPNbFR\\ypXenTGAO[w}h@\ngGT@@TjZjPNjFJ\\undGAZ@=\ngGT@@TjZjPNjFJ\\uodGAo_v`@=\ngGT@@TjZjPNjFJ\\usPqSdm|`xM{~t@=\ngGT@@TjZjPNjFJ\\us`qK]HNC~t@\ngGT@@TjZjPNjFJ\\us`qK_HNC^m@\ngGT@@TjZjPNjFJ]Us`is_HNC^m@\ngGT@@TjZjPNjFJ]Us`qK_HNC^m@\ngGT@@TjZjdEDNjFJ\\vs`qs_HNCP`<\ngGT@@TjZjiDNjFJ\\uodGAh_v`@+\ngGT@@TjZjiDNjFJ\\urPqrV~P\\FaZ@<\ngGT@@TjZjiDNjFJ\\usPqSdm|`xMB<\ngGT@@TjZjiDNjFJ\\usPqSdm|`xMB>\ngGT@@TjZjiDNjFJ\\usPqSdm|`xMC~t@-\ngGT@@TjZjiDNjFJ\\us`qK_HNC__m@<\ngGT@@TjZjiDNjFJ\\us`qK_HNC__m@>\ngGT@@TjZjiDNjFJ\\us`qs_HNCPm@>\ngGT@@TjZjiDNjFJ\\vodGAhP>\ngGT@@TjZjiDNjFJ\\vrPqSf~P\\Fa@<\ngGT@@TjZjiDNjFJ\\vrPqSf~P\\Fa@>\ngGT@@TjZjiDNjFJ\\vs`qs_HNCPm@<\ngGT@@TjZjiDNjFJ]Vs`qs_HNCPm@<\ngGT@@TjZjiDNjFJ]Vs`qs_HNCPm@>\ngGT@@TjZjiDNlJM\\xJRwrwntO{P@<\ngGT@@TjZjiDNlJM\\xJRwrwntO{P@>\ngGT@@TjZjiDNlJMlxL\\wr{ntO{P@<\ngGT@@TjZjiDNlJMlxL\\wr{ntO{P@>\ngGT@@dfXb`NhjyF}l{nvb@=\ngGT@@dfXb`NhjyF}l{o_vb@\ngGT@@dfXb`NhjyF}l}o_vb@=\ngGT@@dfXb`NhjyF}t{nvb@=\ngGT@@dfXb`NhjyF}t{o_vb@\ngGT@@dfXb`Nldm[d[vrFaZH=\ngGT@@dfXb`Nldm[d[wRFa@\ngGT@@dfXb`Nldm[d[wRFaZH=\ngGT@@dfXb`Nldm\\zJ\\wHwndMC~tP\ngGT@@dfXb`Nldmkd[vrFaZH\ngGT@@dfXb`Nldmkd[wRFaZH\ngGT@@dfXb`Nldukd[vrFaZH=\ngGT@@dfXb`Nldukd[wRFaZH=\ngGT@@dfXbhdNldm\\zJ\\wHwndMB<\ngGT@@dfXbhdNldmlzJRwHwndMB<\ngGT@@dfXbhdNldmlzJRwHwndMB>\ngGT@@dfYj`NcIIZwHwndMC~tP=\ngGT@@dfYj`NkENRuolDah_vb@=\ngGT@@dfYj`NkENRuomxah_rPJMh`=\ngGT@@dfYj`NkENRusPqSdm}`dMC~tP=\ngGT@@dfYj`NkENRus`qs_XICPmD\ngGT@@dfYj`NkENRushis_XICPmD\ngGT@@dfYj`NkENRvs`qs_XICPmD\ngGT@@dfYj`NkENRvshiK_XICPmD\ngGT@@dfYj`NkENRvshiK_[qCPmD\ngGT@@dfYj`NkENRvshis_XICPmD\ngGT@@dfYj`NkENbuolDah_vb@=\ngGT@@dfYj`NkENbusPqSdm}`dMC~tP=\ngGT@@dfYj`NkENbus`qs_XICPmD\ngGT@@dfYj`NkENbvs`qs_XICPmD\ngGT@@dfnjPNcGIZyr\\eoBD\ngGT@@dfnj`NcGIZwQCP`\ngGT@@dfnj`NcGIZyHXiK]DMB\ngGT@@dfnj`NcGIZyr\\enbFa@\ngGT@@dfnj`NcGI[WQCP`\ngGT@@dfxH@MrMkYw]`=\ngGT@@dfxH@MrMkYw^`=\ngGT@@dfxH@MrMkY{^`=\ngGT@@dfyh@NiFzN{l=\ngGT@@dfyh@NiFzN{t\ngGT@@dfyh@NiFzO[t=\ngGT@@dfyh@NiF~GSn{@=\ngGT@@dfyh@NiF~GSn{I@p`=\ngGT@@dfyh@NiF~GSn}@\ngGT@@dfyh@NiGNBdmt]wh\ngGT@@dfyh@NiGNbdmt]wh\ngGT@@dfyh@NiJyFul{np=\ngGT@@dfyh@NiJyFul{oP\ngGT@@dfyh@NiJyFul}oP=\ngGT@@dfyh@NiJyFut{np=\ngGT@@dfyh@NiJyFut{oP\ngGT@@dfyh@NiJyFut}oP=\ngGT@@dfyh@NiKNbdmrMkiw^`\ngGT@@dfyi`NcGIZytTyncva@\ngGT@@dfyi`NeGV\\EN[h}np\ngGT@@dfyi`NeKUrMkiw^`\ngGT@@dfyj`NcGIZwQCP`\ngGT@@dfyj`NcKIZwHvndMB\ngGT@@dfyjidNcGI[WQCP`<\ngGT@@dfzh@NiFzN{l=\ngGT@@dfzh@NiFzN{t\ngGT@@dfzhIDNiGNBdmt]wh<\ngGT@@dfzhIDNiGNBdmt]wh>\ngGT@@dfzi`NeGUt]wh\ngGT@ADjZj`NbJIZwJ{ndMC~t@=\ngGT@ADjZj`NfFJ\\ek\\hNBPtO{HP=\ngGT@ADjZj`NfFJ\\ekgAcfyP\\Dah_vP`\ngGT@ADjZj`NfFJ\\em\\hNBPtO{HP=\ngGT@ADjZjiDNfFJ\\ekgAcfyP\\Dah_v`@<\ngGT@ADjzh@NdGM}`g]w~t@=\ngGT@ADjzh@NdGM}`g]{~t@\ngGT@ADjzh@NdGM}`gm{~t@=\ngGT@ADjzh@NdGM}oG]w~t@=\ngGT@ADjzh@NdGU}`g]w~t@=\ngGT@ADjzh@NhJyf}l{nv`@=\ngGT@ADjzh@NhJyf}l{o_v`@\ngGT@ADjzh@NhJyf}l}o_v`@=\ngGT@ADjzh@NhJyf}t{nv`@=\ngGT@ADjzh@NhJyf}t{o_v`@\ngGT@ADjzh@NhJyf}t}o_v`@=\ngGT@ADjzh@NhKNbdmsM{iw^m@\ngGT@ADjzi`NbIIZwLwmgmC~t@\ngGT@ADjzi`NbIIZwtwmtO{P@\ngGT@ADjzi`NjENRushis_XI{Pm@\ngGT@ADjzj`NbIIZwLwmdMC~t@\ngGT@ADjzj`NbIIZwLwndMC~t@\ngGT@ADjzj`NjENRuolDah_v`@\ngGT@ADjzj`NjENRurPqrV~pRFaZ@\ngGT@ADjzjdDhNjENRus`qs_XICP`<\ngGT@ADjzjhdNbII[WLwndMC~t@>\ngGT@ADjzjhdNbII[YtTynYo]HZG}h@>\ngGT@ADjzjhdNjENRurPqrV~pRF~Z@<\ngGT@ADjzjhdNjENRurPqrV~pRF~Z@>\ngGT@ADjzjhdNjENRus`qs_XICPm@<\ngGT@ADjzjhdNjENRus`qs_XICPm@>\ngGT@ADjzjhdNjENRvolDah_v`@<\ngGT@ADjzjhdNjENRvolDah_v`@>\ngGT@ADjzjhdNjENRvshis_XICPm@<\ngGT@ADjzjhdNjENRvshis_XICPm@>\ngGT@ADkij`NjENRuolDah_v`@\ngGT@ATeVn`NeDh\ngGT@ATffj`NcENRwVBP`\ngGT@ATffj`NcENRyLTyK]XIB\ngGT@ATffjiDNcENRytTenlDa@<\ngGT@ATffjiDNcENRytTenlDa@>\ngGT@Adijj`NjFJRuodDah_v`@\ngGT@Adijj`NjFJRus`qS_HICPm@\ngGT@Adijj`NjFJbus`qS_HICPm@\ngGT@`QIeIfH@C\\c^v]wX\ngGT@`QIeIfH@CgAcfyG]l}np\ngGT@`QIeIfjiQJChqSfn]EI[kAhP<\ngGT@`QIeIfjiQJChqSjuu`tH<\ngGT@`QIeIfjiQJChqSjuu`tH>\ngGT@`aJyInZ@CjRnQu[N{l=\ngGT@aAteJzjhCjaSdm[{AHZG}h@\ngGTA@QJSLP@FyF}l{np\ngGTA@QJSLP@FyF}l{oP\ngGTA@QJSLPpGRSV~F}na@\ngGTA@QJSLuHGVbkM}`g]v\ngGTA@QJSLuHGVbkV]EN[{AO[l\ngGTA@QJSMURbTGQbgM\\zJRwVCP`<\ngGTA@aJSLuPGUbgIZwH{`dMC~tP=\ngGTA@aJSLuPGUbgIZyhXirV~pRFaZH=\ngGTA@aJS\\D@FyFul{np=\ngGTA@aJS\\t@GTc]G]v=\ngGTA@aJS\\t@GTc]G]z\ngGTA@aJS\\t@GTc_Ciw]`=\ngGTA@aJS\\t@GTc_Ciw]d`XP=\ngGTA@aJS\\t@GTe\\cZv]wX=\ngGTA@aJS\\t@GTe\\cjz]wX=\ngGTA@erS\\t@GTe\\cZv]wX=\ngGTAAAJU\\t@GTE\\s^z^wo{P@=\ngGTAAAJU]R@GTE\\s^v]w_{P@=\ngGTAAAJU]R@GTE\\s^z]w_{P@=\ngGTAAIJTuMPGSCENRus`qS\\knBPtO{P@\ngGTAAQJSSUPGQbgI[kAHP\ngGTAAQJUSUPGUCENRyHXiK_HNBP`\ngGTBLQDSpTQ_AIkjTCiQs~tp\ngGTCLQDSpTQ_@}dTaihCiQKgIrV|oova@\ngGTD@UPZ`Rkjj@zHYImgQSfz`ZG}h@>\ngGTD@]PV`rRFUTAtPqSfz`TD>\ngGTDCPDZ`R[ij@zTlwPvm`\ngGTDEPDDHR[ff@zT\\`\ngGTDEPDDHR[ii@zTmWHvmg]v\ngGTDEaxSpRkjj`PzHTek]DMB<\ngGTDEaxSpRkjj`PzHTek]DMB>\ngGTDQMPV`Dr]uyJffXChabdnZFJ\\enmz~YB@\ngGTDcPDHHWFTfyi`NeGUt^wh\ngGTEIaxKpTiKSU@]FJSVs`qS]DMC~t`\ngGTH@]PYICJj@zhXisV~`TFa@>\ngGTH@]PYICJj@zhXisZ~`TFa@>\ngGTH@iPIMuP@]RMt]wX=\ngGTH@iPIMuP@]RMt^wh=\ngGTHAMPIUuP@]PMt]w_{P@=\ngGTHAMPIUuP@]PM}oG]w~t@=\ngGTHCPDILsS@]ZJ\\ytTenlD}@\ngGTHCPDILuH@]RUrM{Yw]`=\ngGTHCPDILuK@]JR[h[vp\ngGTHCPDILuK@]JRkd[vsn{@\ngGTHCPDILuK@]JRkd[vsn}@\ngGTHCQHILuK@]ZJ\\ytTy@\ngGTHCQxITuS@]DLeZnTGAN{t\ngGTHDPDIMtp@]RUrMkYw]`\ngGTHDPDIMtuSP]ZVZwpvmtH>\ngGTHE`DILsU@]FJRunbFaZH=\ngGTHE`DILsU@]FJRushis]DMC~tP\ngGTHE`DILsU@]FJRvnbFaZH\ngGTHE`DILsU@]FJRvshis]DMC~tP\ngGTHE`DIMtu@]FNRunbFaZX=\ngGTHE`DIMtu@]FNRushis]DMC~tp\ngGTHE`DIMtu@]FVRunQm[HZG}i`=\ngGTHHPxILuS@]FJ\\voa{Ah_vd@\ngGTHHPxILuS@]FJ\\voa{^h_vd@\ngGTHHaxITuUPH]TL]Ek_XICP`<\ngGTHHaxITuUPH]TL]Ek_XICP`>\ngGTHHaxYICJ`@z`[h{np=\ngGTH`iPBYrSWUTbGQcdm[hahP<\ngGTH`iPBYrSWUTbGQcdm[hahP>\ngGTHaMPB]rU\\t@GTC_[qw]m@=\ngGTHdPDCeJS]L@GTc]G]v\ngGTHe`DCeJS]MPGQcdm\\zJ\\wQCPmL\ngGTHe`DCeJS]MPGQcdmlzJ\\wQCPmL\ngGTICQHFTfZe`NmEN\\zJR`\ngGTICQxFTjZi`NbFRmWJC`gmz\ngGT`CPdfyi`NeGH\ngGT`CPdfyj`NeGH\ngGT`EPTfyi`NeGH\ngGT`EPTfyi`NeGN]EIP\ngGT`EPTfzZPNeKUrMkYw]`\ngGT`E`TfYjhhNmEM[ra@<\ngGT`LPdfyj`NmGM[raZX\ngGT`LPdfyj`NmGM[r~ZX\ngGT`LPdfyj`NmGMkraZX\ngGT`hPiJyInZ@CjQncn}ZP\ngGT`hPiJyInZXCiQu]G]w~t`\ngGT`hPiJyInZXCiQu]G]{~t`\ngGT`hPiJyInZdCiQu]G]w~t`\ngGT`hPiJyInZdCiQu]G]{~t`\ngGT`hPiJyInZdCiQu]Gmw~t`\ngGT`hPiJyInZdCiQu]Gm{~t`\ngGT`hPiJyInZdCkQsV|o_vd@\ngGT`hPiJyInZjYCkQsZ|h_vd@<\ngGT`hPiJyInZjYCkQsZ|h_vd@>\ngGT`i`iJyInZhChqrVmtPtO{JX=\ngGT`i`iJyInZhChqrVutPtO{JX\ngGTahPiJx|dwMRAthzncn}ZP\ngGTdLXaxWpRjvj@zPTwe|\ngGTdlX`DTHwF\\ddJu@]HN[h~oovf@\ngGTeI\\QxKpTiKSU@]JJ\\xLRmH\ngGTeLXaxWpOYIIZZ@zPRyr\\eoK{}hP\ngGThLX`DYIHUj@zp\\uoJG}i`\ngGThLX`DYIHUj@zp\\voJG}i`\ngGThLXaxIUMA@]JM[{[NzD\ngGThLXaxIUMA@]JM\\xLRwvv]tH\ngGThLXaxIUMA@]JMk{[NzD\ngGThLXaxIUMA@]JMlxLRwvv]tH\ngGThLXaxIU[U@]XJ[WeB\ngGThLXaxIU[U@]XJ[WeC~RQq@\ngGThLXaxYIHVj`Pzp\\voJG}i`<\ngGThLXaxYIHVj`Pzp\\voJG}i`>\ngGThMX`DYIHUj@zp\\foBG}i`\ngGThmX`D[kNRREZ`NlGIkpaZX\ngGTiCQePKdkjj`NlFJ[rA@\ngGTiCQePKdkjjhdNlFR\\xL\\wdB<\ngGTiLXaxGdjffhDNlFMkra@<\ngGTiLXaxGdjffhDNlFMkra@>\ngGU@CPdsMLAuhiu^XH\ngGU@CPdsMLAuhjs_XIw^`\ngGU@CPdsMLAuhju_XIw^`\ngGU@CPdsTlAtiJnQo[N{t\ngGU@DPdsMTAtXisVzpZG}h`\ngGU@DPdsMTAtXisVzp[{}h`\ngGU@DPdsMTAtXisWNbdmu`tO{Q@\ngGU@DPdsMTAtXisWNbgMu`tO{Q@\ngGU@DPdsMTAtXisZzpZG}h`\ngGU@DPdsMTAtXis[NbgMu`tO{Q@\ngGU@DPdsMTAtXiuVzpZG}h`\ngGU@DPdsMTAtXiuVzp[{}h`\ngGU@DPdsMTAtXiuWNbdmu`tO{Q@\ngGU@DPdsMTAtXiuWNbgMu`tO{Q@\ngGU@DPdsMTAtXiu[NbgMu`tO{Q@\ngGU@DPdsMTAuhjs_XIw]mD\ngGU@DPdsMTAuhjs_XIw^mD\ngGU@DPdsMTAuhjsgQRV~pSn}ZH\ngGU@DPdsMTAuhju_XIw^mD\ngGU@DPdsUUHauhjs_XIw]mD<\ngGU@DPdsUUHauhjs_XIw^mD<\ngGU@DPdsUUHauhjs_XIw^mD>\ngGU@DPdwM@AuHwQw]`\ngGU@DPdwM@AuHwQw^`\ngGU@DPdwM@AuHytTencn}@\ngGU@DPdwMLAthzncn{@\ngGU@DPdwMLAthzncn}@\ngGU@DPdwMLAuhyk]GmB\ngGU@DPdwMLAuhyk^TH\ngGU@DPdwMLAuhykgQRVzOZD\ngGU@DPdwMLAuhykgQRV|hP\ngGU@DPdwMLAuhykgQSf|hP\ngGU@DPdwMLAuhym^TH\ngGU@DPdwMLAuhymgQSf|hP\ngGU@DPdwMRAthzncn{@\ngGU@DPdwMRAthzncn}@\ngGU@DPdwMRAthzncv{@\ngGU@DPdwMRAthzncv}@\ngGU@DPdwMRAthzshiK]G]z\ngGU@DPdwMRAthzshiK]Gmz\ngGU@DPdwMRAthzshis]Gmv\ngGU@DPdwMRAuhyj\ngGU@DPdwMRAuhyk^Wh\ngGU@DPdwMRAuhykgQRT\ngGU@DPdwMRAuhykgQRV|oP\ngGU@DPdwMRAuhykgQSd\ngGU@DPdwMUMAuhyk^TH<\ngGU@DPdwMUMAuhyk^TH>\ngGU@DPdwMUMAuhyk^Wp<\ngGU@DPdwMUMAuhyk^Wp>\ngGU@DPdwMUMAuhykgQRV|hP<\ngGU@DPdwMUMAuhykgQRV|hP>\ngGU@DPdwMUMAuhykgQSf|hP<\ngGU@DPdwMUMAuhykgQSf|hP>\ngGU@DPdwMUMAuhym^TH<\ngGU@DPdwMUMAuhym^TH>\ngGU@DPdwS@AuHwQw]`\ngGU@DPdwS@AuIWHvmg]v\ngGU@DPdwSRAtiZnQm[N{t\ngGU@DPdwSUMAuhykgQSf|hP<\ngGU@DPdwSUMAuhykgQSf|hP>\ngGU@E`dsMTAtXiKVzHZG}h`=\ngGU@E`dsMTAtXiKVzH[{}h`\ngGU@E`dsMTAtXiKWNbdmtPww{Q@\ngGU@E`dsMTAtXiKWNbgMtPtO{Q@\ngGU@E`dsMTAtXiKWNbgMtPww{Q@\ngGU@E`dsMTAtXiKZzHZG}h`\ngGU@E`dsMTAtXiK[NbdmtPtO{Q@\ngGU@E`dsMTAtXiK[NbgMtPtO{Q@\ngGU@E`dsMTAtXiMZzHZG}h`=\ngGU@E`dsMTAthjshiK]G]{~tP\ngGU@E`dsMTAthjshis]Gm{~tP\ngGU@E`dwSTAtXyKVzHZG}i`=\ngGU@E`dwSTAtXyKWNbgMtPtO{S@\ngGU@E`dwSTAtXyK[NbgMtPtO{S@\ngGU@LPdmUTAuhik^TH\ngGU@h`NdiMtp@]RMt]w_{R@=\ngGUACPYRYjV@ztTynmt}@\ngGUADPYR[fi@zT]YtTencn}@\ngGUADPYR[fi@zT]YtTencv}@\ngGUADPYR[fjf`zt\\uoJD<\ngGUADPYR[fjf`zt\\uoJD>\ngGUADP^R[fi@zT]WQw^`\ngGUAE`iRYff@zLTekgQSfzOZG}h`\ngGUAE`iR[ij@zL\\ek]DMC~tp=\ngGUAE`iR[ij@zL\\fm]DMC~tp=\ngGUAIQIRZZj@zLTyKdqSdmu`dH\ngGUDLT@b^BSRuPGVbfmyPdd\\P\ngGUDLT@b^BSRuPGVbfuyP`\ngGUDLTHb^BSSPPGRSV~vsna@\ngGUDLTHb^BSSPPGRSZ~vsna@\ngGUHEjICHiCUPGRbT\ngGUHeaZCS^RYfj@ztTfshiK]DM}~tP\ngGX@@dmMTAuXirVm}`dMB\ngGX@@dmUTAuXirVm}`dMB\ngGX@@dmUTAuXirVnRFJ\\wvBPtH\ngGX@@dmUTAuXirVn\\FI[{AH[x\ngGX@@dmUTAuXirVn\\FJ[{AHZD\ngGX@@dmUTAuXirVu}`dMB\ngGX@@dmUTAuXirVv\\FI[{AHZD\ngGX@@dmUTAuXirZu}`dMB\ngGX@@dmUUDauXirVn\\FJ[{AH[x<\ngGX@@dmUUDauXirVn\\FJ[{AH[x>\ngGX@@dmUUDauXirVv\\FJ[{AHZD>\ngGX@@dsD@AnQo[N{l=\ngGX@@dsD@AnQo[N{t\ngGX@@dsD@AnQo[O[t=\ngGX@@dsD@AnQo]N{l=\ngGX@@dsD@AnQo]N{t\ngGX@@dsD@AnQo]O[t=\ngGX@@dsD@AnQw[N{l=\ngGX@@dsD@AnQw]N{l=\ngGX@@dsD@As`qK\\cnv]wh\ngGX@@dsD@AshiK\\c^z]wh\ngGX@@dsD@Ashis\\c^z^wh\ngGX@@dsDLAuEWHwng]z\ngGX@@dsDLAudek\\c^v^tH\ngGX@@dsDLAudek\\cnv^wp\ngGX@@dsDLAudek_C^wP`\ngGX@@dsDLAudem\\c^v^tH\ngGX@@dsDLAudemgAcfyG]l}hP\ngGX@@dsDLAudemgQRVyF}t}hP\ngGX@@dsM@AthynQwAN{l=\ngGX@@dsM@AthynQwAN{t\ngGX@@dsM@AthynQw^N{l=\ngGX@@dsM@AthyolD{np=\ngGX@@dsM@AthyolD{oP\ngGX@@dsM@AthyolD}oP=\ngGX@@dsM@Athyomx{np=\ngGX@@dsM@Athys`qK\\cnB]wh\ngGX@@dsM@Athys`qK_XIw^`\ngGX@@dsM@AthyshiK\\cnB]wh\ngGX@@dsM@AthyshiK_XIw^`\ngGX@@dsM@AthyshiK_[qw^`\ngGX@@dsM@Athyshis_XI{^`\ngGX@@dsM@AthznQwAN{l=\ngGX@@dsM@AthznQwAN{t\ngGX@@dsM@AthzolD{np=\ngGX@@dsM@AthzolD{oP\ngGX@@dsM@Athzs`qK\\cnB]wh\ngGX@@dsM@Athzs`qK_XIw^`\ngGX@@dsM@AthzshiK\\cnB]wh\ngGX@@dsM@AthzshiK_XIw^`\ngGX@@dsM@AuIWHwmg]v=\ngGX@@dsM@AuIWHwmg]z\ngGX@@dsM@AuIWHwmgmz=\ngGX@@dsM@AuIWHwng]v=\ngGX@@dsM@AuIWHwng]z\ngGX@@dsM@AuIWHwngmz=\ngGX@@dsM@AuIYtTenQo]N{t\ngGX@@dsMLAuXirVmu`tH\ngGX@@dsMLAuXirVm}`gmB\ngGX@@dsMLAuXirVn]EN[kAhP\ngGX@@dsMLAuXirVn]EN[{AOZD\ngGX@@dsMLAuXirVn]EN[{^OZD\ngGX@@dsMLAuXirVu}`gmB\ngGX@@dsMLAuXitVmrNxI{P`\ngGX@@dsMLAuXitVn\\FN[kAhP\ngGX@@dsMLAuhjs_XIw^`\ngGX@@dsMTAtYIKVyF}lahP\ngGX@@dsMTAtYIKVyF}tahP\ngGX@@dsMTAtYIM[IbgI[d[wRFa@\ngGX@@dsMTAuXirVmrNxICP`\ngGX@@dsMTAuXirVm}`dMB\ngGX@@dsMTAuXirVnSENRwH{`dMB\ngGX@@dsMTAuXirVnSENRwvBPtH\ngGX@@dsMUDauXirVn]EN[{AHZD<\ngGX@@dsMUDauXirVn]EN[{AHZD>\ngGX@@dsT`Athyncn{@=\ngGX@@dsT`Athyncn}@\ngGX@@dsT`Athyomt{np=\ngGX@@dsT`Athyomt{oP\ngGX@@dsT`Athys`qK]G]z\ngGX@@dsT`Athys`qK_[iw^`\ngGX@@dsT`AthyshiK_[iw^`\ngGX@@dsT`AuIWHwmg]v=\ngGX@@dsT`AuIWHwmg]z\ngGX@@dsT`AuIWHwmgmz=\ngGX@@dsT`AuIWHwng]v=\ngGX@@dsT`AuIWHwng]z\ngGX@@dsT`AuIWHwngmz=\ngGX@@dsT`AuIWH{mg]v=\ngGX@@dsT`AuIWH{mg]z\ngGX@@dsT`AuIWH{ng]v=\ngGX@@dsT`AuIWH{ng]z\ngGX@@dsT`AuIYpXenQw[N{t\ngGX@@dsT`AuIYpXenQw]N{t\ngGX@@dsT`AuIYtTenQo]N{t\ngGX@@dsT`AuIYtTenQw]N{t\ngGX@@dsTlAtYIKVyF}l}hP\ngGX@@dsTlAtYIKVyF}t}o`\ngGX@@dsTlAtYIKV~F}na@\ngGX@@dsTlAtYIKV~F}va@\ngGX@@dsTlAtYIKWNCGMrN{Y{P`\ngGX@@dsTlAtYIKZyF}l}hP\ngGX@@dsTlAtYIKZyF}t}hP\ngGX@@dsTlAtYIKZyG]l}hP\ngGX@@dsTlAtYIK[NCDm|N{]B\ngGX@@dsTlAtYIK[NCDm|N{mB\ngGX@@dsTlAtiJnQo]O[l\ngGX@@dsTlAtiJnQw]N{t\ngGX@@dsUAHathyolD{np+\ngGX@@dsUAHathyolD{np-\ngGX@@dsUAHathyolD{nrPJH+\ngGX@@dsUAHathyolD{nrPJH-\ngGX@@dsUAHathyolD{oP<\ngGX@@dsUAHathyolD{oP>\ngGX@@dsUAHathyolD}oP+\ngGX@@dsUAHathyolD}oP-\ngGX@@dsUAHathyomx{np+\ngGX@@dsUAHathyomx{np-\ngGX@@dsUAHathyomx{nrPJH+\ngGX@@dsUAHathyomx{nrPJH-\ngGX@@dsUAHathyomx{oP<\ngGX@@dsUAHathyomx{oP>\ngGX@@dsUAHathys`qK_XIw^`<\ngGX@@dsUAHathys`qK_XIw^`>\ngGX@@dsUAHathys`qK_[qw^`<\ngGX@@dsUAHathys`qK_[qw^`>\ngGX@@dsUAHathys`qs_XI{^`<\ngGX@@dsUAHathys`qs_XI{^`>\ngGX@@dsUAHathyshiK_XIw^`<\ngGX@@dsUAHathyshiK_XIw^`>\ngGX@@dsUAHathyshiK_[qw^`<\ngGX@@dsUAHathyshiK_[qw^`>\ngGX@@dsUAHathzolD{np+\ngGX@@dsUAHathzolD{np-\ngGX@@dsUAHathzolD{oP<\ngGX@@dsUAHathzolD{oP>\ngGX@@dsUAHathzolD}oP+\ngGX@@dsUAHathzolD}oP-\ngGX@@dsUAHathzs`qK_XIw^`<\ngGX@@dsUAHathzs`qK_XIw^`>\ngGX@@dsUAHathzs`qs_XI{^`<\ngGX@@dsUAHathzs`qs_XI{^`>\ngGX@@dsUMHauXirVmu`tH<\ngGX@@dsUMHauXirVmu`tH>\ngGX@@dsUMHauXirVm}`gmB<\ngGX@@dsUMHauXirVn\\FN[{AOZD<\ngGX@@dsUMHauXirVn\\FN[{AOZD>\ngGX@@dsUMHauXirVv\\FN[{AOZD>\ngGX@@dsUMHauXitVmu`tH>\ngGX@@dsUMHauXitVn\\FN[{AOZD<\ngGX@@dsUMHauXitVn\\FN[{AOZD>\ngGX@@dsUMHauhjs_XIw^`<\ngGX@@dsUMHauhjs_XIw^`>\ngGX@@dsUThdauXirVnRFJ\\wvBPtH>\ngGX@@dsUThdauXirVn\\FN[{AHZD<\ngGX@@dsUThdauXirVn\\FN[{AHZD>\ngGX@@dsUThdauXirVn]EN[{AHZD<\ngGX@@dsUThdauXirVn]EN[{AHZD>\ngGX@@dsUThdauXirVu}`dMB<\ngGX@@dsUThdauXirVu}`dMB>\ngGX@@dsUThdauXirVv]EN[{AHZD<\ngGX@@dsUThdauXirVv]EN[{AHZD>\ngGX@@dsUThdauXirVv]EN[{^HZD<\ngGX@@dsUThdauXitVn\\FN[{AHZD<\ngGX@@dsUThdauXitVn\\FN[{AHZD>\ngGX@@dsUThdauXitVu}`dMB<\ngGX@@dsUThdauXitVu}`dMB>\ngGX@@dsUTheAuXirVnRFJRwvBPwp<\ngGX@@dsUTheAuXirVnRFJRwvBPwp>\ngGX@@dsUTheAuXirVnRFJ\\wvBPtH<\ngGX@@dsUTheAuXirVnRFJ\\wvBPtH>\ngGX@@dsUTheAuXirVn\\FN[{AHZD<\ngGX@@dsUTheAuXirVn\\FN[{AHZD>\ngGX@@dsUTheAuXirVn]EN[{AHZD<\ngGX@@dsUTheAuXirVn]EN[{AHZD>\ngGX@@dsUTheAuXirVu}`dMB<\ngGX@@dsUTheAuXirVu}`dMB>\ngGX@@dsUTheAuXirVvZFJ\\eolDahP>\ngGX@@dsUTheAuXirVv]EI[{AHZD<\ngGX@@dsUTheAuXirVv]EN[{AHZD>\ngGX@@dsUTheAuXirZn]EI[{AH[x<\ngGX@@dsUTheAuXitVv\\FN[{AHZD<\ngGX@@dsUTheAuXitVv\\FN[{AHZD>\ngGX@@dsUTiDauXitVn\\FN[{AHZD<\ngGX@@dsUTiDauXitVn\\FN[{AHZD>\ngGX@@dsUTiDauXitVn]EN[{AHZD<\ngGX@@dsUUHauXirVm}`dMB<\ngGX@@dsUUHauXirVm}`dMB>\ngGX@@dsUUHauXirVm}oDMB<\ngGX@@dsUUHauXirVm}oDMB>\ngGX@@dsUUHauXirVnSENRwvBPtH>\ngGX@@dsUUHauXirVnZFJ\\eolDahP<\ngGX@@dsUUHauXirVnZFJ\\eolDahP>\ngGX@@dsUUHauXirVnZFJ\\eomxahP<\ngGX@@dsUUHauXirZu}`dMB<\ngGX@@dsUUHauXirZu}`dMB>\ngGX@@dsUUHauXitVm}`dMB<\ngGX@@dsUUHauXitVm}`dMB>\ngGX@@dsUUHauXitVnRFNRwvBPtH<\ngGX@@dsUUHauXitVnRFNRwvBPtH>\ngGX@@dtuRAuXirVmu`dH\ngGX@@dtuRAuXirVn\\FI[{AH[t\ngGX@@dtuSHauXirVn]EI[kAHP<\ngGX@@dtuSHauXirVn]EI[kAHP>\ngGX@@dtuSHauXirZn]EI[{AH[t>\ngGX@@dtuTAuXirVm}`dMB\ngGX@@dtuTAuXirVm}`dM|\ngGX@@dtuTAuXirVnSENRwvBPtH\ngGX@@dtuTAuXirVnSENRwvBPwp\ngGX@@dtuTAuXirVn\\FI[{AHZD\ngGX@@dtuTAuXirVn\\FI[{AH[x\ngGX@@dtuTAuXirVu}`dMB\ngGX@@dtuTAuXirVv\\FI[{AHZD\ngGX@@dtuUHauXirVm}`guB<\ngGX@@dtuUHauXirVm}`guB>\ngGX@@dtuUHauXirVnRFJRwvBPtH<\ngGX@@dtuUHauXirVnRFJRwvBPtH>\ngGX@@dtuUHauXirVn]EI[{AHZD<\ngGX@@dtuUHauXirVn]EI[{AHZD>\ngGX@@dtuUHauXirVn]EI[{AOjD<\ngGX@@dtuUHauXirVn]EI[{AOjD>\ngGX@@dtuUHauXirVn]GI[{AOjD<\ngGX@@dtuUHauXirVn]GI[{AOjD>\ngGX@@dtuUHauXirZm}`dMB<\ngGX@@dtuUHauXirZm}`dMB>\ngGX@@dtuUHauXirZn\\FI[{AHZD<\ngGX@@dtuUHauXirZn\\FI[{AHZD>\ngGX@@dtuUHauXirZn]EI[{AHZD<\ngGX@@dtuUHauXirZn]EI[{AHZD>\ngGX@@dwATAulek\\cZvPtH\ngGX@@dwATAulek\\cZvPtOyKDd\ngGX@@dwATAulek\\cZzPtH\ngGX@@dwATAulfm\\cZvPtH\ngGX@@dwAULaulekgQSfyFutahP<\ngGX@@dwAULaulekgQSfyFutahP>\ngGX@@dwAULaulem\\cZvPtH<\ngGX@@dwSTAtYYKVyFutahP\ngGX@@dwSTAtYYKVyGUlahP\ngGX@@dwSTAtYYMZyFulahP\ngGX@@dwSTAtYYMZyFutahP\ngGX@@dwSTAtYYMZyGUlahP\ngGX@@dwSTAuXirVmtPtH\ngGX@@dwSULatYYKWNbgMrMkiCP`<\ngGX@@dwSULatYYKWNbgMrMkiCP`>\ngGX@@dwSULatYYKWNbgMrNkiCP`>\ngGX@@dwSULatYYKZyFulahP<\ngGX@@dwSULatYYKZyFulahP>\ngGX@@dwSULauXirVn\\EN[hahP>\ngGX@@dwSULauXirVv]EN[y]HZD<\ngGX@@eMUTAtpqSdm[eApRFa@\ngGX@@eMUTAtpqSdm[eApRFaIHxv`@\ngGX@@eMUTAtpqSdm[eApRFaZ@\ngGX@@eMUTAtpqSdm[eApRF~Z@\ngGX@@eMUTAtpqSdm\\dLTynTGAHZG}h@\ngGX@@eMUTAtpqSdm\\xLTwJC`dMB\ngGX@@eMUTAtpqSdm\\xLTwJC`dMC~t@\ngGX@@eMUTAtpqSdm\\xLTwJ}`dMB\ngGX@@eMUTAtpqSdmkeApRFa@\ngGX@@eMUTAtpqSdmkeApRFaZ@\ngGX@@eMUTAtpqSdmlxLRwJC`dMC~t@\ngGX@@eMUTAtpqSdukeApRFaZ@\ngGX@@eMUTAtpqSdulxLTwJC`dMC~t@\ngGX@@eMUTAtpqShukeApRFa@\ngGX@@eMUTAtpqShukeApRFaZ@\ngGX@@eMUTAtpqUdm[eApRFa@\ngGX@@eMUTAtpqUdm[eApRFaZ@\ngGX@@eMUTAtpqUdm\\xLTwJC`dMB\ngGX@@eMUTAtpqUdm\\xLTwJC`dMC~t@\ngGX@@eMUTAtpqUdmkeApRFaZ@\ngGX@@eMUUHatpqSdu[eApRF~Z@<\ngGX@@eMUUHatpqSdu[eApRF~Z@>\ngGX@@eSU@AuAWJwmg]w~t@=\ngGX@@eSU@AuAWJwmg]{~t@=\ngGX@@eSU@AuAWJwmgm{~t@=\ngGX@@eSU@AuAWJwng]w~t@=\ngGX@@eSU@AuAWJwng]{~t@\ngGX@@eSU@AuAWJwngm{~t@=\ngGX@@eSU@AuAWJ{ng]w~t@=\ngGX@@eSU@AuAWJ{ng]{~t@=\ngGX@@eSU@AuAWJ{ngm{~t@=\ngGX@@eSU@AuAYpTenUo]N{w}h@\ngGX@@eSU@AuAYpXenUw]N{w}h@\ngGX@@eSU@Au`is\\hNB]w_yJEFt@=\ngGX@@eSU@Au`is\\hNB]w_{P@=\ngGX@@eSU@Au`is\\hNB]wh\ngGX@@eSU@Au`is\\hNB]woyJEFt@=\ngGX@@eSU@Au`is\\hNB]wo{P@=\ngGX@@eSU@Au`is\\hNB^wh=\ngGX@@eSU@Au`is\\hNB^wo{P@=\ngGX@@eSU@Au`is\\hN|]w_yJEFt@=\ngGX@@eSU@Au`is\\hN|]w_{P@=\ngGX@@eSU@Au`is\\hN|]wo{P@\ngGX@@eSU@Au`is\\hN|^wo{P@=\ngGX@@eSU@Au`isfabgI[eApSv}@=\ngGX@@eSU@Au`isfabgI[eApSv}Z@=\ngGX@@eSU@Au`isgARVyP]x{o_v`@\ngGX@@eSU@Au`isgAbVyP\\D{o_v`@\ngGX@@eSU@Au`isgAcfyP\\D}o_v`@\ngGX@@eSU@Au`iu\\hNB]w_{P@=\ngGX@@eSU@Au`iu\\hNB]wo{P@\ngGX@@eSU@Au`iu\\hNB^wo{P@=\ngGX@@eSU@Au`iugARVyP\\D{o_v`@\ngGX@@eSU@Au`iugAbVyP\\D{o_v`@\ngGX@@eSU@Au`js\\hN|]w_{P@=\ngGX@@eSU@Au`ju\\hNB]w_{P@=\ngGX@@eSU@Au`ju\\hNB]wh\ngGX@@eSU@Au`ju\\hNB]wo{P@=\ngGX@@eSU@Au`ju\\hNB^wh=\ngGX@@eSU@Au`ju\\hNB^wo{P@=\ngGX@@eSU@Au`jufabgI[eApSv}@=\ngGX@@eSU@Au`jugAbVyP\\D{o_v`@\ngGX@@eSU@Au`jugAcfyP\\D}o_v`@\ngGX@@eSUA@au`is\\hN|^wh-\ngGX@@eSUA@au`isgARVyP]x{oP<\ngGX@@eSUA@au`isgARVyP]x{oP>\ngGX@@eSUA@au`isgAbVyP\\D{oP<\ngGX@@eSUA@au`isgAbVyP\\D{oP>\ngGX@@eSUA@au`isgAcfyP\\D}oP<\ngGX@@eSUA@au`isgAcfyP\\D}oP>\ngGX@@eSUA@au`iugARVyP\\D{oP<\ngGX@@eSUA@au`iugARVyP\\D{oP>\ngGX@@eSUA@au`iugASfyP\\D}oP<\ngGX@@eSUA@au`iugASfyP\\D}oP>\ngGX@@eSUA@au`jugAbVyP\\D{oP<\ngGX@@eSUA@au`jugAbVyP\\D{oP>\ngGX@@eSULAtPrSfyP\\D}o_v`@=\ngGX@@eSULAtaRnUw]N{w}h@=\ngGX@@eSULAtpqSdm[eApSvaZ@=\ngGX@@eSULAtpqSdm[yApZG}h@=\ngGX@@eSULAtpqSdm[yAwjG}h@\ngGX@@eSULAtpqSdm\\dLTenTGAOZG}h@=\ngGX@@eSULAtpqSdm\\tLTyK_HNCPm@=\ngGX@@eSULAtpqSdm\\xLRwJC`gmC~t@\ngGX@@eSULAtpqSdm\\xLRwrC`tO{P@\ngGX@@eSULAtpqSdm\\xL\\wJC`gmC~t@\ngGX@@eSULAtpqSdm\\xL\\wrC`tO{P@\ngGX@@eSULAtpqSdmkeApSvaZ@=\ngGX@@eSULAtpqSdmkyApZG}h@=\ngGX@@eSULAtpqSdmltLTyK\\hNB^tO{P@=\ngGX@@eSULAtpqSdmlxL\\wJC`gmC~t@\ngGX@@eSULAtpqSdmlxL\\wrC`tO{P@\ngGX@@eSULAtpqShm[yApZG}h@\ngGX@@eSULAtpqShm\\xL\\wJC`gmC~t@\ngGX@@eSULAtpqShm\\xL\\wrC`tO{P@\ngGX@@eSULAtpqShmkeApSvaZ@\ngGX@@eSULAtpqShmkyApZG}h@\ngGX@@eSULAtpqShmlxL\\wJC`gmC~t@\ngGX@@eSULAtpqShmlxL\\wrC`tO{P@\ngGX@@eSULAtpqUdm\\xJ\\wJCoGmC~t@\ngGX@@eSUTAtQQKVyV}lah_v`@=\ngGX@@eSUTAtQQKVyV}tah_v`@\ngGX@@eSUTAtQQKVyW]tah_v`@=\ngGX@@eSUTAtpqSdm[eApRFa@\ngGX@@eSUTAtpqSdm[eApRFaIPhv`@=\ngGX@@eSUTAtpqSdm[eApRFaIXdv`@=\ngGX@@eSUTAtpqSdm[eApRFaZ@=\ngGX@@eSUTAtpqSdm[eAwbFaZ@\ngGX@@eSUTAtpqSdm\\dL\\enTGAHZG}h@\ngGX@@eSUTAtpqSdm\\tLTyK\\hNBPtH\ngGX@@eSUTAtpqSdm\\tLTyK\\hNBPtO{P@=\ngGX@@eSUTAtpqSdukeApRFa@\ngGX@@eSUTAtpqSdukeApRFaZ@=\ngGX@@eSUTAtpqShm[eApRFaZ@\ngGX@@eSUTAtpqShm\\dL\\enTGAHZG}h@\ngGX@@eSUT`hatpqSdm\\dL\\enTGAH[x>\ngGX@@eSUT`hatpqSdm\\xLRwJC`dM|>\ngGX@@eSUT`hatpqSdm\\xL\\wJC`dMB<\ngGX@@eSUT`hatpqSdm\\xL\\wJC`dMB>\ngGX@@eSUT`hatpqSdmlxL\\wJC`dMB<\ngGX@@eSUT`hatpqSdmlxL\\wJC`dMB>\ngGX@@eSUT`hatpqSdulxL\\wJC`dMB<\ngGX@@eSUT`hatpqSdulxL\\wJC`dMB>\ngGX@@eSUT`hatpqShm\\xJ\\wJC`dMB>\ngGX@@eSUT`hatpqShmlxJ\\wJC`dMB<\ngGX@@eSUT`iAtpqSdm\\xL\\wJC`dMB<\ngGX@@eSUT`iAtpqSdm\\xL\\wJC`dMB>\ngGX@@eSUT`iAtpqSdmldL\\enTGAHZD>\ngGX@@eSUT`iAtpqSdmlxLRwJC`dMB<\ngGX@@eSUT`iAtpqSdmlxLRwJC`dMB>\ngGX@@eSUT`iAtpqSdmlxL\\wJC`dMB<\ngGX@@eSUT`iAtpqSdu\\xLRwJC`dM|<\ngGX@@eSUT`iAtpqSdu\\xLRwJC`dM|>\ngGX@@eSUT`iAtpqShm\\xJ\\wJC`dMB<\ngGX@@eSUU@atpqSdm\\dL\\enTGAHZD<\ngGX@@eSUU@atpqSdm\\dL\\enTGAHZD>\ngGX@@eSUU@atpqShm[eApRFa@<\ngGX@@eSUU@atpqShm[eApRFa@>\ngGX@@eSUUHatQQKWNCGMrn{iCPm@<\ngGX@@eSUUHatQQKZyV}lah_v`@+\ngGX@@eSUUHatpqSdm[eApRF~Z@+\ngGX@@eSUUHatpqSdm[eApRF~Z@-\ngGX@@eSUUHatpqSdm\\dLTynTGAHZD<\ngGX@@eSUUHatpqSdm\\dLTynTGAHZD>\ngGX@@eSUUHatpqSdm\\dL\\enTGAH[{}h@<\ngGX@@eSUUHatpqSdm\\tLTyK\\hNBPwp<\ngGX@@eSUUHatpqSdm\\tLTyK\\hNBPwp>\ngGX@@eSUUHatpqSdm\\xJ\\wJCoDMC~t@<\ngGX@@eSUUHatpqSdm\\xJ\\wJCoDMC~t@>\ngGX@@eSUUHatpqSdm\\xLRwJC`dM}~t@<\ngGX@@eSUUHatpqSdm\\xLRwJC`dM}~t@>\ngGX@@eSUUHatpqSdm\\xL\\wJC`dMC~t@<\ngGX@@eSUUHatpqSdm\\xL\\wJC`dMC~t@>\ngGX@@eSUUHatpqSdm\\xL\\wJC`dM}~t@<\ngGX@@eSUUHatpqSdmkeApRFa@<\ngGX@@eSUUHatpqSdmkeApRFa@>\ngGX@@eSUUHatpqSdmkeApRFaZ@+\ngGX@@eSUUHatpqSdmkeApRFaZ@-\ngGX@@eSUUHatpqSdmldLTynTGAHZD<\ngGX@@eSUUHatpqSdmldLTynTGAHZD>\ngGX@@eSUUHatpqSdmltLTyK\\hNBPtH<\ngGX@@eSUUHatpqSdmltLTyK\\hNBPtH>\ngGX@@eSUUHatpqSdmltLTyK\\hNBPtO{P@+\ngGX@@eSUUHatpqSdmltLTyK\\hNBPtO{P@-\ngGX@@eSUUHatpqSdmlxLRwJC`dMC~t@<\ngGX@@eSUUHatpqSdmlxLRwJC`dMC~t@>\ngGX@@eSUUHatpqSdmlxL\\wJC`dMC~t@<\ngGX@@eSUUHatpqSdmlxL\\wJC`dMC~t@>\ngGX@@eSUUHatpqSdu\\tLTyK\\hNBPwp>\ngGX@@eSUUHatpqSdu\\xLRwJC`dM}~t@<\ngGX@@eSUUHatpqSdulxL\\wJC`dMC~t@>\ngGX@@eSUUHatpqShm\\xJ\\wJC`dMC~t@<\ngGX@@eSUUHatpqShm\\xJ\\wJC`dMC~t@>\ngGX@@eSUUHatpqShm\\xL\\wJC`dMC~t@<\ngGX@@eSUUHatpqShm\\xL\\wJC`dMC~t@>\ngGX@@eSUUHatpqShmkeApRFaZ@>\ngGX@@eSUUHatpqShmlxJ\\wJC`dMC~t@<\ngGX@@eSUUHatpqShmlxJ\\wJC`dMC~t@>\ngGX@@eSUUHatpqShmlxLRwJC`dMC~t@<\ngGX@@eSUUHatpqShmlxLRwJC`dMC~t@>\ngGX@@eSUUHatpqShmlxL\\wJC`dMC~t@<\ngGX@@eSUUHatpqShmlxL\\wJC`dMC~t@>\ngGX@@eSUUHatpqShulxL\\wJC`dMC~t@<\ngGX@@eSUUHatpqShulxL\\wJC`dMC~t@>\ngGX@@e]MTAtpqSdm[f]pRFaZ@\ngGX@@e]MTAtpqSdm[{AHZG}h@\ngGX@@e]MTAtpqSdm\\xLTwL{`dMC~t@\ngGX@@e]MTAtpqSdmk{AHZG}h@\ngGX@`IWITtp@]PUrm{Y{^m@=\ngGX@`IWITtp@]PUrm{i{^m@=\ngGX@`IWITtp@]XJ\\wvB^wo{P@=\ngGX@`NtiMtu@]FVSVnQm[HZD\ngGXA@IRVjj@zlTyKV~pRFa@\ngGXA@IRVjj@zlTyKWICEN[{AHZD\ngGXA@IRVjj@zlTyKWNCEM}`dMB\ngGXA@IRYb@@wH{mg]v=\ngGXA@IRYb@@wH{ng]v=\ngGXA@IRYb@@ypXenQw[N{t\ngGXA@IRYb@@ypXynQw[O[t\ngGXA@IRYb@@ypXynQw]O[t\ngGXA@IRYf`@zT\\wH{`g]v=\ngGXA@IRYf`@zdkd[vsn{@=\ngGXA@IRYjP@zdkd[vsn{@=\ngGXA@IRYjP@zdkd[wSn{@=\ngGXA@IRYjP@zdkd]vsn{@=\ngGXA@IRYjP@zdkd]wSn{@=\ngGXA@IRYj`dPzT\\wvB]wX+\ngGXA@IRYj`dPzT\\wvB]wX-\ngGXA@IRYj`dPzT\\wvB]wh<\ngGXA@IRYj`dPzT\\wvB]wh>\ngGXA@IRYj`dPzT\\ypXeolD{oP<\ngGXA@IRYj`dPzT\\ypXeolD{oP>\ngGXA@IRYj`dPzT]WvB]wX+\ngGXA@IRYj`dPzT]WvB]wX-\ngGXA@IRYjfdPzlTzKWNCGM}`gmB<\ngGXA@IRYjfdPzlTzKWNCGM}`gmB>\ngGXA@IRYjjTR`zlTyKWNCGM}`dMB>\ngGXA@IRYjjdPzlTyKV~pRFa@<\ngGXA@IRYjjdPzlTyKV~pRFa@>\ngGXA@IRZZi@zlTyKWNCDm}`dMz\ngGXA@IRZZj@zlTyKV~pRFa@\ngGXA@IRZZj@zlTyKV~pRF~@\ngGXA@IRZZj@zlTyKWIbgI[d^pRF~@\ngGXA@IRZZj@zlTyKWIbgI[{AHZD\ngGXA@IRZZj@zlTyKWNCDm}`dMB\ngGXA@IRZZjdPzlTyKWICEI[{AHZD<\ngGXA@IRZZjdPzlTyKWICEI[{AHZD>\ngGXA@IRZZjdPzlTyKWNbdm}`dMB<\ngGXA@IRZZjdPzlTyKWNbdm}`dMB>\ngGXA@IRfjj@zXXirVmr`xICP`\ngGXA@IRfjj@zXXirVn\\FJ[e^pRFa@\ngGXA@IRih@@wJwmg]w~t@=\ngGXA@IRih@@wJwng]w~t@=\ngGXA@IRih@@wJ{ng]w~t@=\ngGXA@IRihF@ztRunUo[OZG}h@=\ngGXA@IRii`@z`ke[vsn{Z@=\ngGXA@IRii`@z`ke[vsn}Z@\ngGXA@IRii`@z`ke[vsv}Z@=\ngGXA@IRii`@z`ke]vsv}Z@=\ngGXA@IRii`@z`ke]wSn{Z@=\ngGXA@IRii`@z`ke]wSv}Z@=\ngGXA@IRii`@zpTynUwAN{o}h@=\ngGXA@IRii`@zpTynUwAO[w}h@=\ngGXA@IRii`@zpTynUw^O[w}h@=\ngGXA@IRii`@zpTyolD{o_v`@\ngGXA@IRii`@zpTyolD}o_v`@=\ngGXA@IRii`@zpTznUwAN{o}h@=\ngGXA@IRij`@zpTynTGAN{l=\ngGXA@IRij`@zpTynTGAN{t\ngGXA@IRijj@zXXirVmr`xICP`\ngGXA@IRijj@zXXirVnZFJ\\enTGAHZD\ngGXA@IRijjPTPzXXirVn\\FN[eApRFa@<\ngGXA@IRijjPT`zXXirVn\\FN[eApRFa@>\ngGXA@IRijjdPzXXirVnRFJ\\wJC`dMB<\ngGXA@IRijjdPzXXirVur`xICP`>\ngGXA@IRjZj@zXXirVmr`xICP`\ngGXA@IRjZj@zXXirVnRFJRwJC`dMB\ngGXA@IRjZj@zXXirVnRFJRwJC`dM|\ngGXA@IRjZj@zXXirVn\\FI[eApRFa@\ngGXA@IRjZj@zXXirVur`xICP`\ngGXA@IRjZj@zXXirVv\\FI[eApRFa@\ngGXA@IRkfj@zHdek\\s^vPtO{P@\ngGXA@IRkfj@zHdek\\s^zPtO{P@\ngGXA@IRkfj@zHdek\\snvPtO{P@\ngGXA@IRkfj@zHdek\\snzPtO{P@\ngGXA@IRkfj@zXXirVmsNxICPm@\ngGXA@IRkfj@zXXirVm}`dMC~t@\ngGXA@IRnfj@zXXirVn\\FJ[f]pRFaZ@\ngGXA@NRYjP@zdkd[vsn{@=\ngGXA@NRYjP@zdkd[wSn{@=\ngGXA@NRYjV@zLdem\\c^v^tH\ngGXA@NRZZj@zlTyKWIbgI[{AHZD\ngGXAAiR[ij@zLlemgARVyGUlahP>\ngGXAAiR[ij@zLlemgARVyGUtahP>\ngGXAAiR[ij@zLlfkgASfyGUlao`>\ngGXAAiR[ij@zLlfm\\cZvPtH\ngGXAAiR[ij@zLlfm\\cZzPtH\ngGXAAiR[ij@zLlfmgASfyGUlahP>\ngGXAAiR[ij@zLlfmgASfyGUtahP>\ngGXD@jCTBUMT@GTC]G]w~t@=\ngGXDAjBtFRPrj`NjFJ\\eohEAHP>\ngGXDD@`aBS]MHGRejyFul{np\ngGXDD@`aBS]MHGRejyFul{oP\ngGXDD@b^BSRuPGUbgQjwvBPtO{Q@\ngGXDH@aABS]T@GTc\\cr|]w_{R@=\ngGXDH@aABS]T@GTc\\cr|]wo{R@=\ngGXDHGANBS]T@GTc\\cr|^wh=\ngGXDHGANBS]T@GTc\\cr|^woyHFD=\ngGXDHHQPbS]T@GTc]Gmz=\ngGXDHHQPbS]T@GTc]Gm{~RAa@=\ngGXDHO@~BUMUTbGUCEVjwrC`tH<\ngGXDHO@~BUMUTbGUCEVjwrC`tH>\ngGXDHOANBRtuPGUbgIZwvBPtO{R@\ngGXDHOA^BS]T@GTc]G]w~RAamH=\ngGXDHOA^BS]T@GTc]G]w~t`=\ngGXDHOA^BS]T@GTc]Gmz=\ngGXDHOA^BS]T@GTc]Gm{~RAa@=\ngGXDHOA^BS]UPGQcdm[d^WbFaI@pvd@=\ngGXDJDR^BSRuPGQbgI[kAHP\ngGXDJIARBSWUPGVcdmx_@\ngGXDL@aABS\\uPGQcdm[hah_vf@=\ngGXDL@bABUuUTRGQBdm\\dLTynbFa@<\ngGXDL@bABUuUTRGQBdm\\dLTynbFa@>\ngGXEHOA^BeIZZhCjqShuk{AHZG}i@\ngGXEHOA^DeInZ@CjQoat}o_rPLMi@=\ngGXEL@aAByInZhChqrVmtPtO{S@=\ngGXEaJAT@f\\nRfjj@zhXzMZyWlDahP\ngGXHAJAIfj@CiQs_XIw]`+\ngGXHAJAIfj@CiQs_XI{^`+\ngGXHAJAIfj@CiQu_XIw]`+\ngGXHAJAIfj@CiQu_XI{^`+\ngGXHAJAIfj@CiQugAbV~pSn}@>\ngGXHAJAIfj@CiQugAcf~pSv}@>\ngGXHAJAIfjXCkQUkNCGM}`gmv>\ngGXHAJAIfjhCjqSdm\\fJ\\eolDahP>\ngGXHAjAJfj@CiAS\\hN|]w_{P@=\ngGXHAjAJfj@CiAS\\hN|^wo{P@=\ngGXHAjAJfj@CiAS_HIw]m@=\ngGXHAjAJfj@CiAS_HI{^m@=\ngGXHAjAJfj@CiAU_HIw]m@=\ngGXHAjAJfjBACiAS_HI{^`+\ngGXHAjAJfjBACiAS_HI{^`-\ngGXHAjAJfjBACiAU_HI{^`+\ngGXHAjAJfjBACiAU_HI{^`-\ngGXHAjAJfjXCjabhmlxJ\\wrCoTO{P@\ngGXHAjAJfjjACjabdm[yAHZD<\ngGXHAjAJfjjACjabdm[yAHZD>\ngGXHAjCIHYUPGSCENRunXEAHZD\ngGXHAjCIHYUPGSCENRusPqSdms@hICPm@=\ngGXHB@aIfi@CjRnQo[N{l\ngGXHB@aIfi@CjRnQo[N{t\ngGXHB@aIfi@CjRnQo]N{l\ngGXHB@aIfiXCiRU\\c^v]wh\ngGXHB@aIfiXCkRSV~F}na@\ngGXHB@aIfidCiRU\\c^v^wX\ngGXHB@aIfidCiRU\\c^v^wh\ngGXHB@aIfidCkRSV~F}n}@\ngGXHB@aIfjBQCiQsgAbV~pSn}@>\ngGXHB@aIfjiQJChqSfn]EN[kAhP<\ngGXHB@aInfjZCkRsV~Funa@<\ngGXHB@aInfjZCkRsV~Funa@>\ngGXHBOAJfj@CkAUjyP\\D{np\ngGXHBOAJfjdCjabgM\\dLTeodGAoP\ngGXHD@aIfZhCjqSdm[{AHZG}h`=\ngGXHD@aIfZhCjqSdm\\zJ\\wvBPtO{Q@\ngGXHD@aIfZhCjqShm[{AHZG}h`=\ngGXHD@aIfZhCjqShm\\zJ\\wvBPtO{Q@\ngGXHD@aIfZhCjqShmk{AHZG}h`\ngGXHD@aIfihChrRVmrM{YCPmD=\ngGXHD@aIfihChrRVmrM{iCP`=\ngGXHD@aIfihChrRZurM{YCPmD=\ngGXHD@aIfihCiRU\\c^v]w_{Q@=\ngGXHD@aIfjjQCjqShmlxL\\wvBPtO{Q@>\ngGXHD@aIkjjQChqrVn\\gI[hahP<\ngGXHD@aIkjjQChqrVn\\gI[hahP>\ngGXHD@aInZ@CjQncn{@=\ngGXHD@aInZ@CjQncn}@\ngGXHD@aInZ@CjQshiK]G]z\ngGXHD@aInZXChqrVmt^tH\ngGXHD@aInZXChqrVmyP`\ngGXHD@aInZhChqrVmtPtH\ngGXHD@aInf@CjQncn{@=\ngGXHD@aInf@CjQncn}@\ngGXHD@aInf@CjRnQm[N{l=\ngGXHD@aInf@CjRnQm[N{t\ngGXHD@aInf@CjRnQm[O[t=\ngGXHD@aInf@CjRshiK\\cZz]wh\ngGXHD@aInfXChrrVm|Mk]B\ngGXHD@aInfXCiRu\\cZv^wh\ngGXHD@aInjBQCjQncn{@+\ngGXHD@aInjBQCjQncn{@-\ngGXHD@aInjBQCjQncn}@>\ngGXHDDQInf@CjRnQm[N{l=\ngGXHDOAInjBQCjQoax{np+\ngGXHDOAInjBQCjQoax{np-\ngGXHH@aIZjhCjqSdm[d^pRFaZP\ngGXHH@aIZjhCjqSdmk{AHZG}i@\ngGXHH@aIfj@CiQs\\cvB]w_{R@=\ngGXHH@aIfj@CiQs\\cvB]wo{R@\ngGXHH@aIfj@CiQsgAbVyGlD{o_vd@\ngGXHH@aIfj@CiQsgQRVyGlD{o_vd@\ngGXHH@aIfj@CiQsgQSfyGlD}o_vd@\ngGXHH@aIfj@CiQu\\cvB]w_{R@=\ngGXHH@aIfjXCjqSdm[d^pSvaZP\ngGXHH@aIfjXCjqSdm\\xL\\wH}`gmC~t`\ngGXHH@aIfjXCjqSdmlzJ\\wp}`tO{R@\ngGXHH@aIfjXCkQUgNCDmrOXI{^mH\ngGXHH@aIfjXCkQUgNbgMrOXI{^mH\ngGXHH@aIfjhCjqSdm[d^pRFaZP\ngGXHH@aIfjhCjqSdm[{AHZG}i@\ngGXHH@aIfjhCjqSdm\\fJ\\enQ{AHZG}i@\ngGXHH@aIfjjICjqSdm\\zJ\\wH}`dMC~t`<\ngGXHH@aIfjjICjqSdm\\zJ\\wH}`dMC~t`>\ngGXHH@aIfjjICjqSdmlzJRwH}`dMC~t`>\ngGXHH@aIfjjICjqSdmlzJ\\wH}`dMC~t`<\ngGXHH@aIfjjICjqSdmlzJ\\wH}`dMC~t`>\ngGXHH@aIfjjICjqSdulzJ\\wH}`dMC~t`>\ngGXHH@aIfjjICjqShm\\zJ\\wH}`dMC~t`<\ngGXHH@aIfjjICjqShm\\zJ\\wH}`dMC~t`>\ngGXHH@aJnZBACiAu_XIw]`+\ngGXHH@aJnZBACiAu_XIw]`-\ngGXHHGAIfj@CiQs\\cvB]w_{R@=\ngGXHHGAIfj@CiQs\\cvB^wo{R@=\ngGXHHGAIfj@CiQs_XI{^mH=\ngGXHHGAIfjXCjqShm\\xLRwp}`tO{R@\ngGXHHGAIfjXCjqShm\\xL\\wVCPmH\ngGXHHGAIfjXCjqShm\\xL\\wp}`tO{R@\ngGXHHGAIfjhCjqSdm[d^pRFaZP\ngGXHHGAIfjhCjqSdm[{AHZG|dBcZP\ngGXHHOAIZZhCjqSdm[{AHZG}i@\ngGXHHOAIZjhCjqSdm[d^pRFaZP\ngGXHHOAIZjhCjqSdm[{AHZD\ngGXHHOAIfj@CiQs\\cvB]w_{R@=\ngGXHHOAIfj@CiQs\\cvB^wo{R@=\ngGXHHOAIfj@CiQs_XIw]mH=\ngGXHHOAIfj@CiQs_XI{^mH=\ngGXHHOAIfjBQCiQs_XI{^`+\ngGXHHOAIfjBQCiQs_XI{^`-\ngGXHHOAIfjhCjqSdm[d^pRFaZP\ngGXHHOAIfjhCjqSdm[{AHZG}i@\ngGXHHOAIfjjICjqSdmkd^pRFaZP<\ngGXHHOAIfjjQCjqSdm[{AHZD<\ngGXHHOAIfjjQCjqSdm[{AHZD>\ngGXHHOAJkZhCjaSdm[f]pRFa@\ngGXHHOAJkZhCjaSdm[{AHZD\ngGXHHOAJnjBACiAu_XIw]`+\ngGXHHOAJnjBACiAu_XIw]`-\ngGXHHOAJnjjACjaSdm[{AHZD<\ngGXHHOAJnjjACjaSdm[{AHZD>\ngGXHL@aJZjhCjabdm[yAHZD\ngGXH`Z@R^RjZj@zhXisV~P\\Fa@\ngGXH`Z@R^RjZj@zhXisWICEI[yApZD\ngGXHaJ@SNRYj`@zT]WvB^wh+\ngGXHaJ@SNRZZj@zlTyKV~pRFa@\ngGXHaJ@SNRZZjdPzlTyMV~pRFa@<\ngGXHaJ@SNRZZjdPzlTyMV~pRFa@>\ngGXHaj@SnRii`@zPTwJ{oG]w~t@=\ngGXHaj@SnRii`@zPTwJ{oGm{~t@=\ngGXHaj@SnRii`@zPTwv|]w_{P@=\ngGXHaj@SnRii`@zPTwv|]wo{P@\ngGXHaj@SnRii`@zPTwv|^wo{P@=\ngGXHaj@SnRii`@zPTypTeomx{o_v`@\ngGXHaj@SnRkfj@zhXiKVyg]xah_rPJMh@\ngGXHaj@SnRkfj@zhXiKV~wbFaZ@\ngGXHhG@]IR[ij@zlTyKV~WRFaI@pvd@\ngGXI@Z@ReTuTAuPqSfm|`xMB\ngGXIAjC\\eSU@At`inTG^N{o}h@=\ngGXIDHaRdmUTAuXirVm}`dMB\ngGXIHDPReWU@At`zolD{np+\ngGXIHO@ReUuTAuPirVm}`dMB\ngGXIHOBRdmMTAuXirVm}`dMC~t`\ngGXIHOBRdsMTAuXirVm}`dMC~t`\ngGXLJIARFdLbdMU@]JIP\ngGX`BDdwM@AuHwQw]`\ngGX`BDdwM@AuHwQw^`\ngGX`BDdwMLAthzncn{@\ngGX`BDdwMLAthzncn}@\ngGX`BDdwMLAuhyk]GmB\ngGX`BDdwMLAuhyk^TH\ngGX`BDdwMLAuhym]GmB\ngGX`BDdwMLAuhym^TH\ngGX`BDdwMRAthzncn{@\ngGX`BDdwMRAthzncn}@\ngGX`BDdwMRAthzncv{@\ngGX`BDdwMRAthzncv}@\ngGX`BDdwMRAthzshiK]Gmz\ngGX`BDdwMRAuhyj\ngGX`BDdwMRAuhyk^Wh\ngGX`BDdwMRAuhykgQRT\ngGX`BDdwMRAuhykgQRV|oP\ngGX`BDdwMUMAuhyk^TH<\ngGX`BDdwMUMAuhyk^TH>\ngGX`BDdwMUMAuhyk^Wp<\ngGX`BDdwMUMAuhyk^Wp>\ngGX`BDdwMUMAuhykgQRV|hP>\ngGX`BDdwMUMAuhykgQSf|hP<\ngGX`BDdwMUMAuhykgQSf|hP>\ngGX`BDdwMUMAuhym^TH<\ngGX`BDdwMUMAuhym^TH>\ngGX`BDdwULAuhykdabdmyP`\ngGX`BDdwUThlauhykgARV|hP>\ngGX`BDdwUThmAuhykgARV|hP<\ngGX`DBdsMTAtXisVzpZG}h`\ngGX`DBdsMTAtXisWNbdmu`tO{Q@\ngGX`DBdsMTAtXiuVzpZG}h`\ngGX`DBdsMTAtXiuWNbdmu`tO{Q@\ngGX`DBdsMTAtXiuZzpZG}h`\ngGX`DBdwMLAuhyk^TH\ngGX`DBdwMLAuhym^TH\ngGX`DBdwMRAthzncn{@\ngGX`DBdwMRAthzncn}@\ngGX`DBdwMRAthzshiK]G]z\ngGX`DBdwMRAuhyj\ngGX`DBdwMRAuhykgQRT\ngGX`DBdwMRAuhykgQRV|oP\ngGX`DBdwMUMAuhyk^TH<\ngGX`DBdwMUMAuhyk^TH>\ngGX`DBdwMUMAuhykgQRV|hP<\ngGX`DBdwMUMAuhykgQRV|hP>\ngGX`DBdwMUMAuhykgQSf|hP>\ngGX`DBdwMUMAuhym^TH<\ngGX`DBdwMUMAuhym^TH>\ngGX`DBdwSRAtiZnQm[N{l\ngGX`DBdwUThmAuhykgARV|hP<\ngGX`DBdwUThmAuhykgARV|hP>\ngGX`JDduuTAuhyK^DH\ngGX`JDduuTAuhyM^DH\ngGX`LDdwMTAtXyKVzHZG|ebSZX=\ngGX`LDdwMTAtXyKVzHZG}i`=\ngGX`LDdwMTAtXyKVzH[{|ebSZX\ngGX`LDdwMTAtXyKVzH[{}i`\ngGX`LDdwMTAtXyKWNbgMtPtO{S@\ngGX`LDdwMTAtXyKZzHZG}i`\ngGX`LDdwMTAtXyK[NbgMtPtO{S@\ngGX`LDdwMTAtXyMVzH[{}i`\ngGX`LDdwMTAtXyMZzHZG}i`=\ngGX`LDdwMTAthzncn{ZX=\ngGX`LDdwMTAthzncn}ZX\ngGX`LDdwMTAthzncv}ZX=\ngGX`bDnLiMsP@]RMt]wX\ngGX`bDnLiMsT`]ZNZ`\ngGX`bDnLiMsUSP]ZNZweB<\ngGX`bDnLiMsUSP]ZNZweB>\ngGX`hEIWIMsP@]RMt]w_{R@=\ngGX`hEIWIMsP@]RMt]wo{R@\ngGX`hEIWIMsP@]RMt^wo{R@=\ngGX`hEIWIMsS@]FNRuncvaZP\ngGX`hEIWIMsS@]FNRuncv~ZP\ngGX`hEIWIMsS@]FNRuoJG}i@\ngGX`hEIWIMsS@]JNkh{nvd@\ngGX`hEIWIMsS@]JNkh{o_vd@\ngGX`hEIWIMsS@]JNkh}nvd@\ngGX`hEIWIMsS@]JNkh}o_vd@\ngGX`hEIWIMsU@]FNRunbFaZP\ngGX`hEIWIMsUSH]FNRunbF~ZP<\ngGX`hEIWIMsUSH]FNRunbF~ZP>\ngGXaBDYR[f`@zd[h{np\ngGXaBDYR[fi@zt\\uoKt\ngGXaBDYR[fjf`zt\\uoJD<\ngGXaBDYR[fjf`zt\\uoJD>\ngGXaBDYR[fjf`zt\\voJD<\ngGXaBDnR[f`@zd[h{np\ngGXaBDnR[f`@zd[h{oP\ngGXaBDnR[ff@zT]WQw^`\ngGXaBDnR[fi@zT]WQw]`\ngGXaBDnR[fi@zT]WQw^`\ngGXaBDnR[fi@zt\\u@\ngGXaBDnR[fi@zt\\uoKt\ngGXaBDnR[fjf`zt\\uoJD<\ngGXaBDnR[fjf`zt\\uoJD>\ngGXaLDnR[fj@zL\\ek]DMC~tp=\ngGXdBl@b^BSRuTbGVbfmyP`<\ngGXdBl@b^BSRuTbGVbfmyP`>\ngGXdBl@b^BSRuTbGVbfuyP`<\ngGXdBl@b^BSRuTbGVbfuyP`>\ngGXdBl@b^FQREj`NmDm[raZD\ngGXdMD@baFRREZPNlGIkhao_vf@\ngGXdMD@baFRREZPNlGIkpaZX\ngGXdMD@baFRREZ`NlGI[haoovf@\ngGXdMD@baFRREZ`NlGIkhaoovf@\ngGXeMD@baF{IIBmPGVCdmtPww{S@\ngGXeMD@baF{IIBmPGVCdmt_Ww{S@\ngGXeMD@baF{IIBmPGVCdutPww{S@\ngGXhHZ@aIfjXCkQSfzGlG}i@\ngGXhHZ@aIfjXCkQSgNbdmtOXO{R@\ngGXhLEJAInjhChqrVmtPtO{S@=\ngGXhLEJAInjhChqrVutPtO{S@\ngGXhMD@cIIBmHGQCdu[hao_vf@\ngGXhMD@cIIBmHGQCdu[paZX\ngGXhMD@cIIBmHGQCdu\\yNRwQC^mL\ngGXhMD@cIIBmHGQCdu\\yNRwaC~tp\ngGXhMD@cIIBmPGQCdm[hah_vf@\ngGXhMD@cIIBmPGQCdm[h~h_vf@\ngGXhMD@cIIBmPGQCdmkhah_vf@\ngGXhMD@cIIBmPGQCdu[hah_vf@\ngGXhMD@cIIBmPGQCdu[haoovf@\ngGXhMD@cIIBmPGQCdu\\yNRwQCPmL\ngGXhMD@cIIBmPGQCdukhah_vf@\ngGXhMD@cIIJmPGVBVmyP`\ngGXhMD@cIIJmPGVBVmy_@\ngGXhMD@cIIJmPGVBVn\\gI[ra@\ngGXhMD@cIIJmPGVBVuyP`\ngGXhMDOCIHYUPGQCdm[hahP\ngGXhbLjA\\YRnjjbPzHYImgAcfz`ZD<\ngGXhbLjA\\YRnjjbPzHYImgAcfz`ZD>\ngGXhdZ@aS^RYjV@zTdwPwmmD\ngGXiMD@c]ddaVhCharZmtPtO{S@\ngGXiMD@c]ddaVhCharZutPtO{S@\ngGY@BDfYh@NeGM}`g]v\ngGY@BDfYh@NeGN]EI[{AN{t\ngGY@BDfYh@NeGU}`g]v\ngGY@BDfYh@NeGU}`g]z\ngGY@BDfYh@NeGV]EI[{AN{t\ngGY@BDfYi`NcENZwVCP`\ngGY@BDfYi`NcENZwvB^tH\ngGY@BDfYi`NcENZytTenlFa@\ngGY@BDfYi`NcEN[YtTeolD}hP\ngGY@BDfYi`NcENjwVCP`\ngGY@BDfYi`NcENkWvB^tH\ngGY@BDfYi`NmEV[{AN{t\ngGY@BDfYi`NmEVk{AN{t\ngGY@BDfYi`NmEVlzJRwvB]wh\ngGY@BDfYjPNcENZytTenlF}@\ngGY@BDfYjPNcENZytTeoLD\ngGY@BDfYjPNcENZytTyoLD\ngGY@BDfYjPNcENjwVC^`\ngGY@BDfYjPNcENjwfB\ngGY@BDfYjPNcENjytTenlF}@\ngGY@BDfYjPNcENjytTeoLD\ngGY@BDfYjPNmEV[{AN{l\ngGY@BDfYjPNmEV[{AN{t\ngGY@BDfYjPNmEV[{AO[l\ngGY@BDfYjPNmEV\\zJRwvB]wh\ngGY@BDfYjPNmEV\\zJRwvB^wh\ngGY@BDfYjPNmEVk{AN{l\ngGY@BDfYjPNmEVk{AN{t\ngGY@BDfYjPNmEVk{AO[l\ngGY@BDfYjPNmEVk{AO[t\ngGY@BDfYjPNmEVlzJRwvB]wh\ngGY@BDfYjPNmEVlzJRwvB^wh\ngGY@BDfYjhhNcENZwVCP`>\ngGY@BDfYjhhNcENjwVCP`<\ngGY@BDfYjhhNcENjwVCP`>\ngGY@BDfZd@NiJyF}l{oP\ngGY@BDfZe`NmIM[x[vzD\ngGY@BDfZfPNeIUrM{Yw]`\ngGY@BDfZfPNmEV[h{np\ngGY@BDfZfPNmEV[h{oP\ngGY@BDfZfPNmIM[x[v{t\ngGY@BDfZhIDNeGM}`g]v>\ngGY@BDfZhIDNeGN]EI[{AO[t>\ngGY@BDfZjeDdNcENZwVCP`<\ngGY@BDfZjeDdNcENZwVCP`>\ngGY@BDfZjeDdNcENZypXenlFa@<\ngGY@BDfZjeDdNcENZypXenlFa@>\ngGY@BDfZjeDdNcENZytTenlFa@<\ngGY@BDfZjeDdNcENZytTenlFa@>\ngGY@BDfZjeDdNcENZytTynlFa@<\ngGY@BDfZjeDdNcENZytTynlFa@>\ngGY@BDfZjeDdNcEN[WVCP`<\ngGY@BDfZjeDdNcEN[YtTynlFa@<\ngGY@BDfZjeDdNcEN[YtTynlFa@>\ngGY@BDfZjeDdNcENkWVCP`>\ngGY@BDfZjeDhNcENZwVCP`<\ngGY@BDfZjeDhNcENZwVCP`>\ngGY@BDfZjeDhNcENZyLTyK]XMB<\ngGY@BDfZjeDhNcENZyLTyK]XMB>\ngGY@BDfZjeDhNcENZytTenlFa@<\ngGY@BDfZjeDhNcENZytTenlFa@>\ngGY@BDfZjeDhNcENZytTynlFa@<\ngGY@BDfZjeDhNcENZytTynlFa@>\ngGY@BDfZjeDhNcEN[WVCP`<\ngGY@BDfZjeDhNcEN[WVCP`>\ngGY@BDfZjeDhNcENjwVCP`<\ngGY@BDfZjeDhNcENjwVCP`>\ngGY@BDfZjeHhNcENjwVCP`<\ngGY@BDfZjeHhNcENjwVCP`>\ngGY@BDfZjeHhNcENjypXynlFa@>\ngGY@BDfzZihNmKM[x[VzD<\ngGY@BDfzZihNmKM[x[VzD>\ngGY@DDfYj`NkENRuolDah_vb@=\ngGY@DDfYj`NkENRuolDaoovb@\ngGY@DDfYj`NkENRuomxah_vb@=\ngGY@DDfYj`NkENRushiK_XIC__mD\ngGY@DDfYj`NkENRushiK_[qC__mD\ngGY@DDfYj`NkENRushis_XICPmD\ngGY@DDfYj`NkENRushis_XIC__mD\ngGY@DDfYj`NkENRushis_[qCPmD\ngGY@DDfYj`NkENRvolDah_vb@\ngGY@DDfYj`NkENRvomxah_vb@\ngGY@DDfYj`NkENRvshiK_XICPmD\ngGY@DDfYj`NkENRvshiK_[qCPmD\ngGY@DDfYj`NkENRvshis_XICPmD\ngGY@DDfYj`NkENRvshis_[qCPmD\ngGY@DDfYj`NkENSUolDaoovb@\ngGY@DDfYj`NkENSUshiK_XIC__mD\ngGY@DDfYj`NkENSUshiK_[qC__mD\ngGY@DDfYj`NkENSVolDah_vb@=\ngGY@DDfYj`NkENSVshis_XICPmD\ngGY@DDfYj`NkENbuolDah_vb@=\ngGY@DDfYj`NkENbuolDaoovb@\ngGY@DDfYj`NkENbushiK_XIC__mD\ngGY@DDfYj`NkENbushis_XICPmD\ngGY@DDfYj`NkENbushis_XIC__mD\ngGY@DDfYj`NkENbvolDah_vb@\ngGY@DDfYj`NkENbvshiK_XICPmD\ngGY@DDfYj`NkENbvshis_XICPmD\ngGY@DDfYj`NkENcVolDah_vb@=\ngGY@DDfYj`NkENcVshis_XICPmD\ngGY@DDfYj`NmEV[{AN{w}h`\ngGY@DDfYj`NmEV[{AO[w}h`=\ngGY@DDfYj`NmEV\\zJRwvB]wo{Q@\ngGY@DDfYj`NmEV\\zJ\\wvB^wo{Q@\ngGY@DDfYj`NmEVk{AN{w}h`\ngGY@DDfYj`NmEVk{AO[w}h`=\ngGY@DDfYj`NmEVlzJ\\wvB^wo{Q@\ngGY@DDfZf`NcIIZwHwndMB=\ngGY@DDfZf`NkENRuomtah_vb@=\ngGY@DDfZf`NkENRushis_[iCPmD\ngGY@DDfZjiDNkENRuolDah_vb@+\ngGY@DDfZjiDNkENRuolDah_vb@-\ngGY@DDfZjiDNkENRushis_XICPmD<\ngGY@DDfZjiDNkENRvolDah_vb@<\ngGY@DDfZjiDNmEV[{AN{w}h`<\ngGY@DDfZjiDNmEV[{AN{w}h`>\ngGY@DDfZjiDNmEV[{AO[w}h`-\ngGY@DDffj`NkENRuolDah_vb@\ngGY@DDffjiDNkENRushiK_XICPmD>\ngGY@DDfnjYDNcGIZypTeoCx<\ngGY@DDfnjYDNcGIZypTeoCx>\ngGY@DDfnjiDNcGIZwQCP`<\ngGY@DDfnjiDNcGIZwQCP`>\ngGY@DDfnjiDNcGIZyHXiK]DMB>\ngGY@DDfnjiDNcGIZyr\\enbFa@<\ngGY@DDfnjiDNcGIZyr\\enbFa@>\ngGY@DDfnjiDNcGIZytTenbFa@<\ngGY@DDfnjiDNcGIZytTenbFa@>\ngGY@DDfyh@NiFzN{l=\ngGY@DDfyh@NiFzN{t\ngGY@DDfyh@NiFzO[t=\ngGY@DDfyh@NiGNbdmt]wh\ngGY@DDfyh@NiGNbgMt^wh\ngGY@DDfyi`NcGIZwQ{P`\ngGY@DDfyi`NcGIZweB\ngGY@DDfyi`NcGIZytTencva@\ngGY@DDfyi`NcGIZytTeoJD\ngGY@DDfyi`NcGIZytTyncva@\ngGY@DDfyi`NcGIZytTyncv~@\ngGY@DDfyi`NcGIZytTyoJD\ngGY@DDfyi`NcGI[WQ{P`\ngGY@DDfyi`NcGI[WeB\ngGY@DDfyi`NcGI[YtTyncva@\ngGY@DDfyi`NcGI[YtTyoJD\ngGY@DDfyi`NeGUt]wh\ngGY@DDfyi`NeGUt^wX\ngGY@DDfyi`NeGUt^wh\ngGY@DDfyi`NeGV]EI[h}oP\ngGY@DDfyi`NeGV]EN[h}np\ngGY@DDfyi`NeGV]EN[h}oP\ngGY@DDfyj`NcGIZwQCP`\ngGY@DDfyj`NcGIZwQCPdlRP\ngGY@DDfyj`NcGIZyLTyK]DMB\ngGY@DDfyj`NcGIkWQCP`\ngGY@DDfyjidNcGIZwQC_@<\ngGY@DDfyjidNcGIZwQC_@>\ngGY@DDfyjidNcGIZytTenbF~@<\ngGY@DDfyjidNcGIZytTenbF~@>\ngGY@DDfyjidNcGIZytTynbFa@<\ngGY@DDfyjidNcGIZytTynbFa@>\ngGY@DDfyjidNcGIZytTynbF~@>\ngGY@DDfyjidNcGI[WQCP`<\ngGY@DDfyjidNcGI[WQCP`>\ngGY@DDfyjidNcGI[YtTynbFa@<\ngGY@DDfyjidNcGI[YtTynbFa@>\ngGY@DDfzX@NiFzN{l=\ngGY@DDfzX@NiFzN{t\ngGY@DDfzX@NiGNBdmt]wh\ngGY@DDfzX@NiJyFul{np=\ngGY@DDfzX@NiJyFul{oP\ngGY@DDfzX@NiJyFul}oP=\ngGY@DDfzX@NiKNbdmrMkiw^`\ngGY@DDfzY`NcGIZypTyoJD\ngGY@DDfzY`NcKIZwpvmtH\ngGY@DDfzZ`NcKIZwHvmdMB\ngGY@DDfzZ`NcKIZwHvmdMC~RqI@\ngGY@DDfzhIDNiFzN{l+\ngGY@DDfzhIDNiFzN{l-\ngGY@DDfzhIDNiFzN{t<\ngGY@DDfzhIDNiGNbdmt]wh<\ngGY@DDfzhIDNiGNbdmt]wh>\ngGY@HDfZh@NeGM}`g]w~t`=\ngGY@HDfZh@NeGN]EI[{AN{w}i@\ngGY@HDfZhIDNeGM}`g]v+\ngGY@HDfZhIDNeGM}`g]v-\ngGY@HDfZhIDNeGM}oG]v-\ngGY@HDfZhIDNeGM}oG]z<\ngGY@HDfZhIDNeGM}oG]z>\ngGY@HDfZhIDNeGNRFJRwvB]wh<\ngGY@HDfZhIDNeGNRFJRwvB]wh>\ngGY@HDfZi`NkENRushis]XMC~t`\ngGY@HDfZj`NkENRurPqrV~pRFaZP\ngGY@HDkjj`NjENRuolDahP\ngGY@HDkjj`NjENRus`qS_XICP`\ngGY@JDffj`NcENRwVBP`\ngGY@JDffjiDNcENRytTenlDa@<\ngGY@JDffjiDNcENRytTenlDa@>\ngGY@JDffjiDNcENRyt\\enlD~@>\ngGY@JDffjiDNcENSWVBP`<\ngGY@JDffjiDNcENSWVBP`>\ngGY@LDejj`NcEIZwQCP`\ngGY@LDejj`NcEIZypXinbFa@\ngGY@LDejjhhNcEIZwQC_@>\ngGY@LDejjhhNcEIZypXynbFa@<\ngGY@LDejjhhNcEIZypXynbFa@>\ngGY@LDijj`NjFJRuodDahP\ngGY@LDijj`NjFJRus`qS_HICP`\ngGY@LDijjiDNjFJRus`qs_HICP`<\ngGY@LDijjiDNjFJRus`qs_HICP`>\ngGY@LDijjiDNjFJbus`qs_HICP`<\ngGY@LDijjiDNjFJbus`qs_HICP`>\ngGY@LDijjiDNjFJbus`qs_HIC_@<\ngGY@LDijjiDNjFJbus`qs_HIC_@>\ngGY@bAqeIfiXChqSfn]EI[ra@\ngGY@dAreInf@CjQshiK]G]z\ngGY@hAteIfi@CiQs]G]w~t`=\ngGY@hAteIfi@CiQs_[iw]mH=\ngGY@hAteIijhCjqSdm[{AHZD\ngGY@hAteIijjQCjqSdm\\zJRwvBPtH<\ngGY@hAteIijjQCjqSdm\\zJRwvBPtH>\ngGYABCJSLuTTGQbgU[kAhP<\ngGYABCJSLuTTGQbgU[kAhP>\ngGYABCJSMURbRGQbgM\\zJRwVCP`<\ngGYABCJSMURbRGQbgUkkAhP<\ngGYABCJSMURbTGQbgM[kAhP<\ngGYABCJSMURdTGQbgU[kAhP<\ngGYABCJSMURdTGQbgU[kAhP>\ngGYABIJSMUHGVbkM}`g]v>\ngGYABIJSMUHGVbkM}`g]z>\ngGYABIJSMUHGVbkV]EN[{AO[l>\ngGYADArSMSPGUbgIZytTyomtah_vb@\ngGYADArS]L@GTc]G]v=\ngGYADEJSMTDbGRcf~pSn}ZH<\ngGYADEJS]L@GTc_Ki{^`=\ngGYAJKJSSUPGQbgI[kAHP\ngGYALMJRuUPGQbdm[hahP\ngGYDJQDJHR[jf@zT\\`\ngGYHBaxIMtp@]RMt]wX\ngGYHDIPIMuP@]RN]EI[h{oP>\ngGYHDPDIMts@]ZVZwpvmtH\ngGYHDQxILuUJIP]FJ\\uoa{^o`>\ngGYHE@DIUsUPH]TJ\\ek_[qCPmD-\ngGYHE@DYICF``Pz`[h{np+\ngGYHEAxIU[U@]TJ]Fk_XICPmD\ngGYHEAxIU[U@]TJ]Fm_XICPmD\ngGYHHPDILuS@]FJ\\uoa{Ah_vd@\ngGYHHPDILuS@]FJ\\ushiK_CvCPmH\ngGYHHPDILuS@]FJ\\voa{Ah_vd@\ngGYHHPDILuS@]FJ\\vshiK_CvCPmH\ngGYHHPDILuS@]FJ]Uoa{Ah_vd@\ngGYHHPDILuS@]FJ]UshiK_CvCPmH\ngGYHHPDILuS@]FJ]UshiK_CvC__mH\ngGYHHPDILuT`]FJ\\uoa{Ao_vd@\ngGYHHPDILuUQP]FJ\\ushiK_CvCPmH<\ngGYHHPxILuS@]FJ\\ushiK_CvCPmH\ngGYHJPDILuK@]JR[h[vp\ngGYHJPDILuK@]JR[h[wP\ngGYHJPDILuK@]JR\\zJRwPwn`\ngGYHJPDILuK@]ZJ\\`\ngGYHJPDILuK@]ZJ\\wfz\ngGYHJPDILuK@]ZJ\\ypXe@\ngGYHJPDILuL`]JRkd[vsn{@\ngGYHJPDILuL`]JRkd[wSn{@\ngGYHJPDILuSRH]ZJ\\wfB<\ngGYHJQDILuK@]ZJ\\ytTeoMt\ngGYHJQHILuK@]ZJ\\ytTe@\ngGYHJQHILuSRH]ZJ\\wfB>\ngGYHK@xIUMU@]TLTyK_HNB_@\ngGYHKAxIU[U@]DJ\\enlDa@\ngGYHKAxIU[U@]DJ\\erXirVzpRD\ngGYHKAxIU[U@]DJ]FnlDa@\ngGYHL`DIMsU@]FNRunbFaZX=\ngGYHL`DIMtu@]FNRunbFaZX=\ngGYHdIPSeJSWUTbGQcdm[hahP<\ngGYHdIPSeJSWUTbGQcdm[hahP>\ngGYHlEPKmJUuUPGUCEIkYpXiohDahP\ngGYHlEPKmJUuUPGUCIIkYpXiohDahP\ngGYIHEPKdkjj`NjENcVolDahP\ngGYILEPKdkjj`NjFJSVs`qS_PICP`\ngGYLcaHR`TaNLiM]U@]ZNZyr\\eoJD\ngGYLcaHR`TaNLiM]U@]ZN[Yr\\eoJD\ngGY`JDTfyi`NeGH\ngGY`LDTfyj`NmGM[raZX\ngGY`hDYJyInZdCiQu]G]w~t`\ngGY`hDYJyInZjZCkQsV|h_vd@>\ngGYhCE`DYIHUj@zp\\uoJD\ngGYhCE`DYIHUj@zp\\usdyK^TH\ngGYhCE`DYIHUj@zp\\voJD\ngGYhCE`DYIHUj@zp\\vsdyK^TH\ngGYhCE`DYIIUi@zpRusdyK^Wo{P`\ngGYhCE`DYIIUj@zpRuoJG}hP\ngGYhCE`DYIIUj@zpRusdyK^TO{P`\ngGYhCE`DYIIUj@zpRusdyK^Ww{P`\ngGYhCEaxIU[UPH]XJZweB<\ngGYhCEaxIU[UPH]XJZweB>\ngGYhCEaxIU[UPH]XJZytTeoJD<\ngGYhCEaxIU[UPH]XJZytTeoJD>\ngGYhCEaxIU[UPH]XJ[WeB<\ngGYhCEaxIU[UPH]XJ[WeB>\ngGYhCEaxYIIVj@zpRuoJG}hP\ngGYhCEaxYIIVj@zpRvoJG}hP\ngGYhKE`DYIHUj@zp\\foBD\ngGYhjLUPKkJUuUPGVCEMy@`\ngGYhjLUPKkJUuUPGVCIMy@`\ngGYhjLUPKkJUuUPGVCIN\\FI[rA@\ngGYhkEax[kNRRUjhDNdDh<\ngGYhkEax[kNRRUjhDNdDh>\ngGYiKE`D[lddju@]HIP\ngG\\@@ZdsDLAuDwPwm`\ngG\\@@ZdsMLAtiInao]@\ngG\\@@ZdwATAuLwPvm`\ngG\\@@bdsDTAtduoao[h_vb@\ngG\\@@bdsDTAuEWHwmg]w~tP\ngG\\@@bdsDTAuEWHwmg]{~tP\ngG\\@@bdsDTAuEWHwng]{~tP\ngG\\@@bdsMTAtXisWNCDmu`tO{Q@\ngG\\@@bdsMTAtXisWNCGMu`tO{Q@\ngG\\@@bdsMTAtXiuWNCGMu`tO{Q@\ngG\\@@bdwA@AnQm[N{l=\ngG\\@@bdwM@AuIWHvmg]v\ngG\\@@bdwM@AuIWHvng]v\ngG\\@@bdwMLAtiZnQm[N{t\ngG\\@@bdwMLAtiZnQm]N{t\ngG\\@@bdwMUMAuiYk_CZ{P`>\ngG\\@@ldsMTAtXiKVzHZG}h`=\ngG\\@@ldsMTAtXiKWMCENRwQCPmD=\ngG\\@@ldsMTAtXiKWMCENRwpzPtO{Q@=\ngG\\@@ldsMTAtXiKWNCGMtPtO{Q@\ngG\\@@ldsMTAtXiKWNbgMtPtO{Q@\ngG\\@@ldsMTAtXiK[NCGMtPtO{Q@\ngG\\@@ldsMTAtXiK[NbgMtPtO{Q@\ngG\\@@ldsMTAtYIKVyF}lah_vb@=\ngG\\@@ldsMTAthjoat}o_vb@=\ngG\\@@ldwATAuMWHvmg]w~tp=\ngG\\@@ldwATAuMWHvmgm{~tp=\ngG\\@@ldwATAulek\\cZvPtO{S@=\ngG\\@@ldwATAulem\\cZvPtO{S@=\ngG\\@@ldwATAulfm\\cZvPtO{S@=\ngG\\@ABeWURAuaIk_S^{^m@\ngG\\@ABeWUUDatPisWIbgI[kAh_v`@<\ngG\\@ABeWUUDatPisWIbgI[kAh_v`@>\ngG\\@ABeWUUDauaIk_S^{Pm@<\ngG\\@ABeWUUDauaIk_S^{Pm@>\ngG\\@ABeWUUDauaIm_S^wPm@<\ngG\\@ABeWUUDauaIm_S^wPm@>\ngG\\@ABeWUUDauaIm_S^{Pm@<\ngG\\@ABeWUUDauaIm_S^{Pm@>\ngG\\@AEddLj@CjBnYm[N{o}h@=\ngG\\@AEddLj@CjBnYm[N{w}h@=\ngG\\A@ZIRYb@@wHwmg]v=\ngG\\A@lIRYfj@zLTek]DMC~tP=\ngG\\A@lIRYfj@zLTek_CiCPmD=\ngG\\A@lIRYfj@zLTekfabgI[hah_vb@=\ngG\\A@lIRYfj@zLTekgAcf~GRFaZH\ngG\\DEb@b^BSRuPGVbfmy__dd\\[Q@\ngG\\DEb@b^BSRuPGVbfuyPmD\ngG\\EebDR^@yRYRZyjdPzt\\unev~IPxvf@>\ngG\\H@[jCIHYUPGQCEN[jAPP\ngG\\HEb@aIfZhCkQSV|h_vb@\ngG\\HEb@aInfhCkRsV~FunaZX\ngG\\HHlOAJfjhChabVmtPtH\ngG\\HHlOAJfjhChabVutPtO{R@\ngG\\IHl@`ReSUTAtPqKVzHZD\ngG\\`hZEIWIMsS@]JN_vd@\ngG\\`hZEIWIMsS@]JNkh{nvd@\ngG\\`hZEIWIMsS@]JNkh{o_vd@\ngG\\ahZEIWWdfyi`NeGUt]w_{R@\ngG]@DZDfyi`NeGUt]wX\ngG]@DZDfyi`NeGUt]wh\ngG]@EbDfYj`NmEM[raZH\ngG]@EbDfYj`NmEM\\zJ\\weC~tP\ngG]@LZDejj`NeEH\ngG]HEcAxIULE@]JM[y[vzD\ngG]HEcAxIULE@]JM\\xNRwrwmtH\ngG]HEcAxIULE@]JMlxNRwrwmtH\ngG]HEcAxIU[U@]XJZweC~tP\ngG]HEcAxIU[U@]XJ[WeC~tP\ngG]HEcAxYIIXJ@zQZyp\\eoeo[h_va@\ngG]HlZEPKmJUuUPGVCIMy@`\ngJP@DjXDCiQK]K^v=\ngJP@DjXDCiQK]K^z\ngJP@DjXDCiQK]Knz=\ngJP@DjXDCiQK_K^v^`=\ngJP@DjXDCiQK_K^z^`\ngJP@DjXDCiQK_Knz^`=\ngJP@DjXDCiQKgASfzV}t\ngJP@DjXDCiQKgASf~V}t}@\ngJP@DjXDCiQKgAcfzW]t\ngJP@DjXDCiQKgAcf~W]t}@\ngJP@DjYdCjabgI[i]pP\ngJP@DjYdCjabgI[i]w`\ngJP@DjYdCjabgI[kAOP\ngJP@DjYdCjabgI[sA@\ngJP@DjYdCjabgI[y]pSt\ngJP@DjYdCjabgI\\xJ\\wR{``\ngJP@DjYdCjabgI\\xJ\\wR{o@\ngJP@DjYdCjabgI\\xJ\\wVB^`\ngJP@DjYdCjabgI\\xJ\\wV|^`\ngJP@DjYdCjabgI\\xJ\\wfB\ngJP@DjYdCjabgI\\xJ\\wf|\ngJP@DjYdCjabgI\\xJ\\wr{`gh\ngJP@DjYdCjabgI\\xJ\\wr{oGh\ngJP@DjYdCjabgI\\xL\\wR{``\ngJP@DjYdCjabgI\\xL\\wR{o@\ngJP@DjYdCjabgI\\xL\\wVB^`\ngJP@DjYdCjabgI\\xL\\wV|^`\ngJP@DjYdCjabgI\\xL\\wfB\ngJP@DjYdCjabgI\\xL\\wf|\ngJP@DjYdCjabgI\\xL\\wr{`gh\ngJP@DjYdCjabgI\\xL\\wr{oGh\ngJP@DjYdCjabgQ[i]pP\ngJP@DjYdCjabgQ[sA@\ngJP@DjYdCjabgQ[y]pSt\ngJP@DjYdCjabgQ\\xJ\\wR{``\ngJP@DjYdCjabgQ\\xJ\\wr{`gh\ngJP@DjYdCjabgQ\\xL\\wVB^`\ngJP@DjYdCjabgQ\\xL\\wr{`gh\ngJP@DjYdCkBbVzV}l\ngJP@DjYdCkBbVzV}t\ngJP@DjYdCkBbVzW]l\ngJP@DjYdCkBbVzW]t\ngJP@DjYdCkBbV~V}t}@\ngJP@DjYdCkBbV~W]t}@\ngJP@DjZhCjabgI[yApRD\ngJP@DjZhCjabgI[yApRG|eBb\ngJP@DjZhCjabgI[yApSx\ngJP@DjZhCjabgI[y^wbD\ngJP@DjZhCjabgI\\dLTyodGAHP\ngJP@DjZhCjabgI\\dLTyodGAO`\ngJP@DjZhCjabgI\\dLTyoe{^HP\ngJP@DjZhCjabgIkyApRD\ngJP@DjZhCjabgIldLTyodGAHP\ngJP@DjZhCjabkQ[yApRD\ngJP@DjZhCjabkQ\\dLTyodGAHP\ngJP@DjZhCjabkQ\\dLTyodGAO`\ngJP@DjZhCjabkQkyApRD\ngJP@DjZjACjabgI[yAwbD<\ngJP@DjZjACjabgI[yAwbD>\ngJP@DjZjACjabgI[yAwbG|eBb>\ngJP@DjZjACjabgI[yAwcx<\ngJP@DjZjACjabgI\\dLTyodG^HP<\ngJP@DjZjACjabgI\\dLTyodG^HP>\ngJP@DjZjACjabgI\\dLTyodG^H_rTJH<\ngJP@DjZjACjabgI\\dLTyodG^H_rTJH>\ngJP@DjZjACjabgI\\dLTyodG^O`<\ngJP@DjZjACjabgI\\dLTyodG^O`>\ngJP@DjZjACjabgI\\xJ\\wrCoDH<\ngJP@DjZjACjabgI\\xJ\\wrCoDH>\ngJP@DjZjACjabgI\\xJ\\wrCoDOyJED<\ngJP@DjZjACjabgI\\xJ\\wrCoDOyJED>\ngJP@DjZjACjabgI\\xJ\\wrCoGp<\ngJP@DjZjACjabgI\\xJ\\wrCoGp>\ngJP@DjZjACjabgI\\xL\\wrC`dH<\ngJP@DjZjACjabgI\\xL\\wrC`dH>\ngJP@DjZjACjabgI\\xL\\wrC`dOyJED<\ngJP@DjZjACjabgI\\xL\\wrC`dOyJED>\ngJP@DjZjACjabgI\\xL\\wrC`gp<\ngJP@DjZjACjabgI\\xL\\wrC`gp>\ngJP@DjZjACjabgI\\xL\\wrCoDH<\ngJP@DjZjACjabgI\\xL\\wrCoDH>\ngJP@DjZjACjabgI\\xL\\wrCoDOyJED<\ngJP@DjZjACjabgI\\xL\\wrCoGp<\ngJP@DjZjACjabgI\\xL\\wrCoGp>\ngJP@DjZjACjabgI\\xL\\wr}oDH<\ngJP@DjZjACjabgI\\xL\\wr}oDH>\ngJP@DjZjACjabgI\\xL\\wr}oGp<\ngJP@DjZjACjabgI\\xL\\wr}oGp>\ngJP@DjZjACjabgIkyAwbD<\ngJP@DjZjACjabgIkyAwbD>\ngJP@DjZjACjabgIldLTyodG^H_rTJH<\ngJP@DjZjACjabgIlxJ\\wrCoDH<\ngJP@DjZjACjabgIlxJ\\wrCoDH>\ngJP@DjZjACjabgIlxL\\wrC`dH<\ngJP@DjZjACjabgIlxL\\wrC`dH>\ngJP@DjZjACjabgIlxL\\wrCoDH<\ngJP@DjZjACjabgIlxL\\wr}oDH<\ngJP@DjZjACjabgIlxL\\wr}oDH>\ngJP@DjZjACjabgQ[yApRD<\ngJP@DjZjACjabgQ[yApRD>\ngJP@DjZjACjabgQ[yApSx>\ngJP@DjZjACjabgQ\\dLTyodGAHP<\ngJP@DjZjACjabgQ\\dLTyodGAHP>\ngJP@DjZjACjabgQ\\dLTyodGAO`>\ngJP@DjZjACjabgQ\\xJ\\wrC`dH<\ngJP@DjZjACjabgQ\\xJ\\wrC`dH>\ngJP@DjZjACjabgQ\\xJ\\wrC`gp>\ngJP@DjZjACjabgQ\\xL\\wrC`dH<\ngJP@DjZjACjabgQ\\xL\\wrC`dH>\ngJP@DjZjACjabgQ\\xL\\wrC`gp<\ngJP@DjZjACjabgQ\\xL\\wrC`gp>\ngJP@DjZjACjabgQkyApRD<\ngJP@DjZjACjabgQkyApRD>\ngJP@DjZjACjabgQlxJ\\wrC`dH<\ngJP@DjZjACjabgQlxL\\wrC`dH<\ngJP@DjZjACjabgQlxL\\wrC`dH>\ngJP@DjZjACjabkI[yAwbD<\ngJP@DjZjACjabkI[yAwbD>\ngJP@DjZjACjabkI\\xJ\\wrCoDH<\ngJP@DjZjACjabkI\\xJ\\wrCoDH>\ngJP@DjZjACjabkI\\xJ\\wrCoGp<\ngJP@DjZjACjabkI\\xJ\\wrCoGp>\ngJP@DjZjACjabkQ\\xL\\wrC`dH<\ngJP@DjZjACjabkQ\\xL\\wrC`dH>\ngJP@DjZjACjabkQ\\xL\\wrC`gp<\ngJP@DjZjACjabkQ\\xL\\wrC`gp>\ngJP@DjvhCjabgI[kAHP\ngJP@DjvhCjabgI[kAO`\ngJP@DjvhCjabgI[k^HP\ngJP@DjvhCjabgI[z]pRD\ngJP@DjvhCjabgI[z]pSx\ngJP@DjvhCjabgI[z]wbD\ngJP@DjvhCjabgI\\xL\\wVBP`\ngJP@DjvhCjabgI\\xL\\wVB_@\ngJP@DjvhCjabgI\\xL\\wV|P`\ngJP@DjvhCjabgI\\xL\\wt{`dH\ngJP@DjvhCjabgI\\xL\\wt{`gp\ngJP@DjvhCjabgI\\xL\\wt{oDH\ngJP@DjvhCjabgI\\zJ\\wVBP`\ngJP@DjvhCjabgI\\zJ\\wVB_@\ngJP@DjvhCjabgI\\zJ\\wV|P`\ngJP@DjvhCjabgI\\zJ\\wV|_@\ngJP@DjvhCjabgI\\zJ\\wt{`dH\ngJP@DjvhCjabgI\\zJ\\wt{`gp\ngJP@DjvhCjabgI\\zJ\\wt{oDH\ngJP@DjvhCjabgI\\zJ\\wt{oGp\ngJP@DjvhCjabgIkkAHP\ngJP@DjvhCjabgIkz]pRD\ngJP@DjvhCjabgIlxL\\wt{`dH\ngJP@DjvhCjabgQ[kAHP\ngJP@DjvhCjabgQ[z]pRD\ngJP@DjvhCjabgQ\\xL\\wVBP`\ngJP@DjvhCjabgQ\\xL\\wVB_@\ngJP@DjvhCjabgQ\\xL\\wt{`dH\ngJP@DjvhCjabgQ\\xL\\wt{`gp\ngJP@DjvhCjabgQ\\zJ\\wt{`dH\ngJP@DjvhCjabgQkz]pRD\ngJP@DjvhCkBRV~f}la@\ngJP@DjvhCkBRV~f}ta@\ngJP@DjvhCkBRV~f}t~@\ngJP@DjvhCkBRV~g]la@\ngJP@DjvhCkBRV~g]ta@\ngJP@DjvhCkBRWNCGM}N{YB\ngJP@DjvhCkBRWNCGM}N{Y|\ngJP@DjvhCkBRWNCGM}N{iB\ngJP@DjvhCkBRWNCGM}N{i|\ngJP@DjvhCkBRWNbgM}M{iB\ngJP@DjvhCkBRWNbgM}M{i|\ngJP@DjvhCkBRWNbgM}N{iB\ngJP@DjvhCkBRZ~f}ta@\ngJP@DjvhCkBRZ~g]ta@\ngJP@DkfhCjabgI[kAHP\ngJP@DkfhCjabgI[kAH_rRNH\ngJP@DkfhCjabgI[z]pRD\ngJP@DkfhCjabgI\\dLTynlDa@\ngJP@DkfhCjabgI\\dLTyoiwAHP\ngJP@DkfhCjabgQkkAHP\ngJP@DkfhCjabgQkz]pRD\ngJP@DkfjICjabgI[kAO`<\ngJP@DkfjICjabgI[kAO`>\ngJP@DkfjICjabgI[z]pSx<\ngJP@DkfjICjabgI[z]pSx>\ngJP@DkfjICjabgI\\dLTynlD~@<\ngJP@DkfjICjabgI\\dLTynlD~@>\ngJP@DkfjICjabgI\\dLTyoiwAO`<\ngJP@DkfjICjabgI\\dLTyoiwAO`>\ngJP@DkfjICjabgI\\xLTwVBP`<\ngJP@DkfjICjabgI\\xLTwVBP`>\ngJP@DkfjICjabgI\\xLTwVB_@<\ngJP@DkfjICjabgI\\xLTwVB_@>\ngJP@DkfjICjabgI\\xLTwV|_@<\ngJP@DkfjICjabgI\\xLTwV|_@>\ngJP@DkfjICjabgI\\xLTwt{`dH<\ngJP@DkfjICjabgI\\xLTwt{`dH>\ngJP@DkfjICjabgI\\xLTwt{`gp<\ngJP@DkfjICjabgI\\xLTwt{`gp>\ngJP@DkfjICjabgI\\xLTwt{oGp<\ngJP@DkfjICjabgI\\xL\\wVB_@<\ngJP@DkfjICjabgI\\xL\\wVB_@>\ngJP@DkfjICjabgI\\xL\\wt{`gp<\ngJP@DkfjICjabgI\\xL\\wt{`gp>\ngJP@DkfjICjabgIkkAHP<\ngJP@DkfjICjabgIkkAHP>\ngJP@DkfjICjabgIkz]pRD<\ngJP@DkfjICjabgIkz]pRD>\ngJP@DkfjICjabgIldLTynlDa@<\ngJP@DkfjICjabgIldLTynlDa@>\ngJP@DkfjICjabgIlxLTwVBP`<\ngJP@DkfjICjabgIlxLTwVBP`>\ngJP@DkfjICjabgIlxLTwt{`dH<\ngJP@DkfjICjabgIlxLTwt{`dH>\ngJP@DkfjICjabgQ[kAO`<\ngJP@DkfjICjabgQ[kAO`>\ngJP@DkfjICjabgQ\\xL\\wt{`gp<\ngJP@DkfjICjabgQ\\xL\\wt{`gp>\ngJP@DkfjICjabgQlxLTwVBP`<\ngJP@DkfjICjabgQlxLTwVBP`>\ngJP@LdaB`Nedm}MkYB=\ngJP@LdaB`Nedm}MkY|=\ngJP@LdaB`Nedm}MkiB\ngJP@LdaB`Nedm}Mki|\ngJP@LdaB`Nedm}NkiB=\ngJP@LdaB`Nedm}Nki|=\ngJP@LdaB`Nedn\\EN[z]WRD\ngJP@LdaB`Nedn\\EN[z]WSx\ngJP@LdaB`Nedn]EN[z[WRD\ngJP@LdaB`Nedn]EN[z[WSx\ngJP@LdaB`Nedu}MkYB=\ngJP@LdaB`Nedu}MkiB\ngJP@LdaB`Nedu}NkiB=\ngJP@LdaB`Nedv\\EN[z]WRD\ngJP@LdaB`Nedv]EN[z[WRD\ngJPAEJUsTAuPqSdv\\FJ[kAHP>\ngJPAMJULrAuPqSdn\\EN[sA@\ngJPBABPHPQ`aJfj@zpXeoBD\ngJPBABRHPQ`aJnj@zpTeoBD>\ngJPD@DHHRYZ`NcENRwVBP`\ngJPD@DHHRYZ`NcENbwVBP`\ngJPD@DHHR[j`NmGI[pa@\ngJPD@DHHR[j`NmGI[x^WbD\ngJPD@DJ`Rfh@NhFzvsl=\ngJPD@DPHRnh@NhFzvsl=\ngJPD@DPHRnh@NhFzvst\ngJPD@DPHRnh@NhFzwSt=\ngJPD@DPHRnh@NhGNCGMumgh\ngJPD@DPHRni`NdEUungh\ngJPD@DPHRni`NdEV\\FN[k]OP\ngJPD@DPHRnj`NbENRwVBP`\ngJPD@DSpRnh@NhF~gml{@=\ngJPD@DXHRfjPNbFJRwRB^`\ngJPD@DXHRfjPNbFJRwbB\ngJPD@DXHRfjPNbFJRypXyndD}@\ngJPD@DXHRfjPNbFJbwRB^`\ngJPD@DXHRfjPNbFJbypXyndD}@\ngJPD@DXHRfjPNlFR[yAvsl\ngJPD@DXHRfjPNlFR[yAvst\ngJPD@DXHRfjPNlFRkyAvsl\ngJPD@DXHRfjPNlFRkyAvst\ngJPD@DXHRfjPNlFRlxL\\wrCmgh\ngJPD@DXHRfjiDNbFJRypXindDa@<\ngJPD@DXHRfjiDNbFJRypXindDa@>\ngJPD@DXHRfjiDNbFJSYpXindDa@<\ngJPD@DXHRfjiDNbFJSYpXindDa@>\ngJPD@VPlRnh@NhFzvst\ngJPD@bQDRnh@NhFzvsl=\ngJPD@bQDRnh@NhFzvst\ngJPD@bSpRnh@NhF~gml{@=\ngJPDAxGpRij`NbFJmWRC``\ngJPDAxSpRnX@NhFzwSt=\ngJPE@bSpdiWT@GTC_Svv]`=\ngJPH@DIKT@GTc][Yv=\ngJPH@DIKT@GTc][Yz\ngJPH@DIKT@GTc][iz=\ngJPH@DIKT@GTc_Cvv]`=\ngJPH@DIKT@GTc_Cvv^`\ngJPH@DIKT@GTcgAcfzvst\ngJPH@DIKTpGQbgI\\xLTwVzP`\ngJPH@DIKTpGQbgIkpa@\ngJPH@DIKUPGQbgI[kAHP\ngJPH@DIKUPGQbgI[x^pRD\ngJPH@DIKUTRGQbgI\\xLTwVBP`<\ngJPH@DIKUTRGQbgI\\xLTwVBP`>\ngJPH@DILmHGQbgI\\zJ\\wVB^`\ngJPH@DILmHGQbgI\\zJ\\wfB\ngJPH@DILthGVddmtM{X\ngJPH@DILthGVddmtM{h\ngJPH@DILthGVddm|M{Yz\ngJPH@DILthGVddm|M{iz\ngJPH@DILuTbGQbgI[kAHP<\ngJPH@DILuTbGQbgI[kAHP>\ngJPH@DILuTbGQbgI[x^pRD<\ngJPH@DILuTbGQbgI\\xL\\wVBP`<\ngJPH@DILuTbGQbgI\\xL\\wVBP`>\ngJPH@DILuTbGQbgI\\zJ\\wVBP`<\ngJPH@DILuTbGQbgI\\zJ\\wVBP`>\ngJPH@DILuTbGQbgI\\zJ\\wV|P`<\ngJPH@DILuTbGQbgI\\zJ\\wV|P`>\ngJPH@DILuTbGQbgI\\zJ\\wp}`dH<\ngJPH@DILuTbGQbgI\\zJ\\wp}`dH>\ngJPH@DILuTbGQbgQ[kAHP>\ngJPH@DILuTbGQbgQ\\xL\\wVBP`<\ngJPH@DILuTbGQbgQ\\xL\\wVBP`>\ngJPH@DIMsPGQbgI\\zJ\\wRzP`\ngJPH@DIMsPGVedm|MkYB\ngJPH@DIMsPGVedm|MkiB\ngJPH@DIMsPGVedn]EN[x[WRD\ngJPH@DIMsPGVedu|MkiB\ngJPH@DIST@GRBf~P]l{@=\ngJPH@DIST@GRBf~P]l}@\ngJPH@DIST@GRBf~P]t}@=\ngJPH@DIST@GRBf~Wml{@=\ngJPH@DIST@GRBf~Wml}@\ngJPH@DIST@GRBgNCEM|`{iz\ngJPH@DIST@GRBgNCGM|`{Yz\ngJPH@DIST@GRBgNCGM|o[Yz\ngJPH@DIST@GRBj~P]l{@=\ngJPH@DIST@GRBj~P]l}@\ngJPH@DIST@GRBj~P]t}@=\ngJPH@DIST@GRBkNCEM|`{iz\ngJPH@DIST@GRBkNCGM|`{Yz\ngJPH@DISTpGUCENRwRBP`\ngJPH@DISTpGUCENRwrCndH\ngJPH@DISTpGUCENRypXiodG]HP\ngJPH@DISTpGUCENRypXioe{]HP\ngJPH@DISTpGUCENSWrCndH\ngJPH@DISTpGUCENSYpXindDa@\ngJPH@DISTpGUCENSYpXiodG]HP\ngJPH@DISTpGUCEVRwRBP`\ngJPH@DISTpGUCEVRwrCndH\ngJPH@DISTpGUCEVRypXiodG]HP\ngJPH@DISTpGUCEVRypXyodG]HP\ngJPH@DISTpGUCEVSWrCndH\ngJPH@DISTpGVCIM|`{Yz\ngJPH@DISTpGVCIM|`{iv\ngJPH@DISTpGVCIM|`{iz\ngJPH@DISTpGVCIN\\FN[yAwSt\ngJPH@DISTpGVCIU|`{Yz\ngJPH@DISTpGVCIU|`{iz\ngJPH@DISUPGUCENRwrC`dH\ngJPH@DISUPGUCEVRwrC`dH\ngJPH@DISUTbGUCENRypXiodGAHP<\ngJPH@DISUTbGUCENRypXiodGAHP>\ngJPH@DISUTbGUCENSWrC`dH<\ngJPH@DISUTbGUCENSWrC`dH>\ngJPH@DISUTbGUCENSYHXis_HNBP`<\ngJPH@DISUTbGUCENSYpXiodGAHP<\ngJPH@DISUTbGUCENSYpXiodGAHP>\ngJPH@DISUTbGUCEVRwrC`gp>\ngJPH@DISUTbGUCEVRypXiodGAHP<\ngJPH@DISUTbGUCEVSWrC`dH<\ngJPH@DISUTbGUCEVSWrC`dH>\ngJPH@DISUTbGUCEVSYpXiodGAHP<\ngJPH@DISUTbGUCEVSYpXiodGAHP>\ngJPH@VIST@GRBj~P]l{@=\ngJPH@VIST@GRBj~P]l}@\ngJPH@VIST@GRBj~P]t}@=\ngJPH@VISTpGUCENSYpXiodG]HP\ngJPH@bIKT@GTc][Yv=\ngJPH@bIKT@GTc][Yz\ngJPH@bIKT@GTc][iz=\ngJPH@bIMsPGVedm|MkiB\ngJPH@bIST@GRBf~P]l{@=\ngJPH@bIST@GRBf~P]l}@\ngJPH@bIST@GRBf~Wml{@=\ngJPH@bIST@GRBj~P]l{@=\ngJPH@bIST@GRBj~P]l}@\ngJPH@bIST@GRBj~P]t}@=\ngJPH@bIST@GRBkNCGM|`{Yz\ngJPH@bISTpGUCEVRwrCndH\ngJPH@bISTpGUCEVSWrCndH\ngJPH@bISTpGVCIU|`{iz\ngJPH@bISUPGUCEVRwrC`dH\ngJPH@xIKT@GTc][iz=\ngJPH@xIKT@GTc_Cvv]`=\ngJPH@xIKT@GTc_Cvz^`=\ngJPH@xIKUPGQbgI[x^pRD\ngJPH@xILuTbGQbgI[x^pRD<\ngJPH@xILuTbGQbgI[x^pRD>\ngJPH@xILuTbGQbgI\\zJ\\wp}`dH<\ngJPH@xILuTbGQbgI\\zJ\\wp}`dH>\ngJPH@xIMsPGQbgI[x^WRD\ngJPH@xITuPGUCENRwrC`dH\ngJPH@xITuPGUCENSWrC`dH\ngJPHABIKT@GTcgAcfzvst\ngJPHADIKT@GTc][Yv=\ngJPHADIKT@GTc][Yz\ngJPHADIKUPGQbgI[kAHP\ngJPHADILthGQbgI\\zJ\\`\ngJPHADILuTbGQbgI[kAHP<\ngJPHADILuTbGQbgI[kAHP>\ngJPHADILuTbGQbgI\\zJ\\wVBP`<\ngJPHADILuTbGQbgI\\zJ\\wVBP`>\ngJPHADILuTbGQbgI\\zJ\\wV|P`<\ngJPHADILuTbGQbgI\\zJ\\wV|P`>\ngJPHAHILuLbGQbgI[sA@>\ngJPHAHILuTbGQbgI[kAHP<\ngJPHAHILuTbGQbgI[kAHP>\ngJPHAHILuTbGQbgI\\zJ\\wVBP`<\ngJPHAHILuTbGQbgI\\zJ\\wVBP`>\ngJPHAVIKUPGQbgI[kAHP\ngJPHAVILuTbGQbgI\\zJ\\wVBP`<\ngJPHAVILuTbGQbgI\\zJ\\wVBP`>\ngJPHAbIKT@GTc][Yv=\ngJPHAbIKT@GTc][Yz\ngJPHAbIKT@GTc][iz=\ngJPHAbIKTpGQbgI[k]HP\ngJPHAbIKTpGQbgI[pa@\ngJPHAbILuTbGQbgI[kAHP<\ngJPHAbILuTbGQbgI[kAHP>\ngJPHAbILuTbGQbgI\\zJ\\wVBP`<\ngJPHAbILuTbGQbgI\\zJ\\wVBP`>\ngJPHAbILuTbGQbgI\\zJ\\wVB_@>\ngJPHAbILuTbGQbgI\\zJ\\wV|P`<\ngJPHAbILuTbGQbgI\\zJ\\wV|P`>\ngJPHAxIKT@GTc][Yv=\ngJPHAxIKT@GTc][Yz\ngJPHAxIKT@GTc_Cvv]`=\ngJPHAxIKT@GTc_Cvv^`\ngJPHAxIKT@GTc_Cvz^`=\ngJPHAxIKTpGQbgI\\xLTwVzP`\ngJPHAxIKTpGQbgI\\xLTwp}ndH\ngJPHAxIKUPGQbgI[x^pRD\ngJPHAxILuTbGQbgI[x^pRD<\ngJPHAxILuTbGQbgI\\xL\\wVBP`<\ngJPHAxILuTbGQbgI\\xL\\wVBP`>\ngJPHAxILuTbGQbgI\\xL\\wp}`dH>\ngJPHAxILuTbGQbgI\\zJ\\wVBP`<\ngJPHAxILuTbGQbgI\\zJ\\wVBP`>\ngJPHAxILuTbGQbgI\\zJ\\wp}`dH<\ngJPHAxILuTbGQbgI\\zJ\\wp}`dH>\ngJPHAxILuTbGQbgQ[x^pRD<\ngJPHAxISR@GRBfzwSt=\ngJPHAxISR@GRBf~W]t}@=\ngJPHAxITuPGUCENRwrC`dH\ngJPHAxITuPGUCENSWrC`dH\ngJPHAxITuPGUCENSWr}oDH\ngJPHAxITuPGUCEVbwrC`dH\ngJPHAxITuPGUCEVcWrC`dH\ngJPHAxITuTBGUCENbwrC`dH<\ngJPHAxITuTBGUCENbwrC`dH>\ngJPHCPITuPGQCEN\\dLTyodGAO`\ngJPHEPIWUPGUCENcWtC`dH\ngJPHMPITsHGQCEI[i]worTJH\ngJPHMPITuTBGQCEI\\xJ\\wRBP`<\ngJPHMPITuTBGQCEI\\xJ\\wRBP`>\ngJPHMPITuTBGQCEI\\xJ\\wrCoDH<\ngJPHMPITuTBGQCEI\\xJ\\wrCoDH>\ngJPHMPITuTBGQCEI\\xL\\wRBP`<\ngJPHMPITuTBGQCEI\\xL\\wRBP`>\ngJPHMPITuTBGQCEI\\xL\\wrCoDH<\ngJPHMPITuTBGQCEI\\xL\\wrCoDH>\ngJPHMPYIBE@]KIkz[WRD\ngJPI@DBTjZhCjabgI[yApRD\ngJPIAVBTij@CiAS_HNv]`=\ngJPIAVBTij@CiAS_Kvv^`\ngJPIAVBTij@CiAU_HNv]`=\ngJPIAVBTij@CiAU_HNv^`\ngJPIAVBTij@CiAU_HNz^`=\ngJPIAxBTej@CjQoa{[Np=\ngJPIAxBTej@CjQoa{[OP\ngJPIAxBTfZjQChqSdn]EN[kAHP<\ngJPIAxBTfZjQChqSdn]EN[kAHP>\ngJPIAxBTfZjQChqSdn]EN[x^pRD<\ngJPIAxBTfZjQChqSdn]EN[x^pRD>\ngJPIAxBTjZhCjabkQ[yApRD\ngJPIMPZTjZjAChabdn\\EN[yAwbD<\ngJPIMPZTjZjAChabdn\\EN[yAwbD>\ngJPIMP[djZjAChabdn\\EN[iAHP<\ngJPIMP[djZjAChabdn\\EN[iAHP>\ngJPIMP[djZjAChabdn\\EN[yAwbD<\ngJPIMP[djZjAChabdn\\EN[yAwbD>\ngJPIMP[djZjAChabdn\\FN[yAwbD>\ngJPL@DHHpPdru@]ZJRwaB\ngJP`@TfVhCkQSf|pP\ngJP`@TfVhCkQSf|w`\ngJP`@TfVhCkQSgNbgMy``\ngJP`@TfVhCkQSj|pP\ngJP`@TfZjQCkQSf|pP<\ngJP`@TfZjQCkQSf|pP>\ngJP`@TfZjQCkQSf|w`<\ngJP`@TfZjQCkQSf|w`>\ngJP`@TfZjQCkQSgICEN[sA@>\ngJP`@TfZjQCkQSgNCGMy``<\ngJP`@TfZjQCkQSgNCGMy``>\ngJP`@TfZjQCkQSgNbgMy``<\ngJP`@TfZjQCkQSgNbgMy``>\ngJP`@TfZjQCkQSj|pP>\ngJP`@TfyhCiRs]CZv\ngJP`@TfyhCiRs]CZz\ngJP`@dfVhChqSdmu`dH\ngJP`@dfVhChqSdmu`gp\ngJP`@dfVhChqSdmuoDH\ngJP`@dfVhChqSdmuoGp\ngJP`@dfVhChqSdn]EN[kAHP\ngJP`@dfVhChqSdn]EN[kAO`\ngJP`@dfVhChqSdn]EN[k^HP\ngJP`@dfVhChqSdn]EN[k^O`\ngJP`@dfVhChqSduu`dH\ngJP`@dfVhChqSduuoDH\ngJP`@dfVhChqSdv]EN[kAHP\ngJP`@dfVhChqSdv]EN[k^HP\ngJP`@dfVhChqShmu`dH\ngJP`@dfVhChqShmu`gp\ngJP`@dfVhChqShn]EN[kAHP\ngJP`@dfVhChqShn]EN[kAO`\ngJP`@dfVhChqShuu`dH\ngJP`@dfVhChqShv]EN[kAHP\ngJP`@dfvdCkQrT\ngJP`@dfvdCkQrV|OP\ngJP`@dfvdCkQrWNbgH\ngJP`@dfvdCkQrWNbgMx^`\ngJP`@dfvhCkQrV|HP\ngJP`@dfvhCkQrV|O`\ngJP`@dfvhCkQrWNbgMxP`\ngJP`@dfvhCkQrWNbgMx_@\ngJP`@dfvhCkQrZ|HP\ngJP`@dfzhCkQrV|HP\ngJP`@dfzhCkQrWICEN[pa@\ngJP`@dfzjQCkQrWNBgMxP`<\ngJP`@dfzjQCkQrWNBgMxP`>\ngJP`@dfzjQCkQrWNBgMx_@<\ngJP`@dfzjQCkQrWNBgMx_@>\ngJP`ADkjhChaSdnRFJ\\wVBP`\ngJP`ADkjjIChaSdn\\FJ[kAHP<\ngJP`AdefdCiQU][Yv\ngJP`AdijdChabdmt`gh\ngJP`AdijdChabdn\\FN[iAOP\ngJP`AdijdCkAdf~P]l}@\ngJP`AdijjQChabdmt`dH<\ngJP`AdijjQChabdmt`dH>\ngJP`AdijjQChabdmt`gp<\ngJP`AdijjQChabdmt`gp>\ngJP`AdijjQChabdmtoDH<\ngJP`AdijjQChabdmtoDH>\ngJP`AdijjQChabdnRFJ\\wRBP`<\ngJP`AdijjQChabdnRFJ\\wRBP`>\ngJP`AdijjQChabdn\\FJ[iAHP<\ngJP`AdijjQChabdn\\FJ[iAHP>\ngJP`AdijjQChabdn\\FJ[iAO`<\ngJP`AdijjQChabdn\\FJ[iAO`>\ngJP`AdijjQChabdn\\FN[iAHP<\ngJP`AdijjQChabdn\\FN[iAHP>\ngJP`AdijjQChabdn\\FN[iAO`<\ngJP`AdijjQChabdn\\FN[iAO`>\ngJP`AdijjQChabdn\\FN[i^O`<\ngJP`AdijjQChabdut`dH<\ngJP`AdijjQChabdut`dH>\ngJP`AdijjQChabdv\\FJ[iAHP<\ngJP`AdijjQChabdv\\FJ[iAHP>\ngJP`AdijjQChabdv\\FN[iAHP>\ngJP`AdijjQChabhmt`dH<\ngJP`AdijjQChabhmt`dH>\ngJP`AdijjQChabhn\\FN[iAHP<\ngJP`AdijjQChabhn\\FN[iAHP>\ngJPa@erS[RAuhyJ\ngJPa@erS[RAuhyK^Gh\ngJPa@erS[TAuhyK^DH\ngJPa@erS[TAuhyK^Gp\ngJPa@erS[TAuhyM^DH\ngJPa@mrSKTAtXitVzpRD\ngJPaAiJTuTAtPqRVzPRD>\ngJPdAePF`Rnj`NlFJ\\xLTwdB>\ngJPdAiPJ`Rfj`NlFI\\xLTwa|>\ngJPdAiPJ`Rfj`NlFIlxLTwR|P`>\ngJPdAiPJ`Rfj`NlFIlxLTwaB>\ngJPdHaBFDRij`NlFN\\dLTyoLD>\ngJPdHaVFlRij`NlFNksA@>\ngJPdI`xJ`RVj`NmEIkh^HP>\ngJPeI`VIDTiKUPGVbdutODH>\ngJPh@iPIMuHGVcdh\ngJPh@iPIMuHGVcdmx^`\ngJPh@iPIMuPGVcdmxP`\ngJPhAePIWUPGQCEIkjAHP>\ngJPhAePIWUPGQCEIlxLTwTBP`>\ngJPhAePIWUPGQCIIkjAHP>\ngJPhAePIWUPGQCIIlxLTwTBP`>\ngJPhAePIWUPGQCIIlxL\\wTBP`>\ngJPhDPDIMuTbGRcd<\ngJPhE`DIMsPGVcdmxP`\ngJPhHaVITuPGQCGQ[kAHP>\ngJPhI`xIKTpGVbdmtODH\ngJPhIaVIKTpGVbdmxP`\ngJPhIaVIKTpGVbdmx_@\ngJPhLPDIKTpGRbd\ngJPhLQDIKTpGRbd\ngJPhLQxIKTpGRbf|G`\ngJPhaePRUrTuTAu`qK]KqB>\ngJPhaePRUrTuTAu`qM]KqB>\ngJPhaePRUrTuTAu`qMgAbfzWbD>\ngJPi@cPGdfVhCkQSkNbgMu`gp\ngJPiLPDGdejXCiQR\ngJQ@@dlp@]RMumgX=\ngJQ@@dlp@]RMumgh\ngJQ@@dlp@]RMungh=\ngJQ@@dls@]FJ\\enmta@\ngJQ@@dls@]FJ\\eoBD\ngJQ@@dls@]FJ\\foBD\ngJQ@@dls@]JJkk[OP\ngJQ@@dls@]JJkk]Np\ngJQ@@dls@]JJkk]OP\ngJQ@@dlu@]FJ\\enlDa@\ngJQ@@dluQH]FJ\\enlD~@<\ngJQ@@dluQH]FJ\\enlD~@>\ngJQ@@dmP@]RMumgX=\ngJQ@@dmP@]RMumgh\ngJQ@@dmP@]RMungh=\ngJQ@@dmP@]RN\\FJ[k]OP\ngJQ@@dmP@]RN\\FN[k[OP\ngJQ@@dmS@]FJ\\enmta@\ngJQ@@dmS@]FJ\\eoBD\ngJQ@@dmS@]FJ\\eoCx\ngJQ@@dmS@]FJ\\es`qS][iB\ngJQ@@dmS@]FJ\\es`qs][iB\ngJQ@@dmS@]FJ\\es`qs^DH\ngJQ@@dmS@]FJ\\es`qs^Gp\ngJQ@@dmS@]FJ\\fnmta@\ngJQ@@dmS@]FJ\\foBD\ngJQ@@dmS@]JJkk[OP\ngJQ@@dmS@]JJkk]OP\ngJQ@@dmS@]JJlxL\\wVz^`\ngJQ@@dmU@]FJ\\enlDa@\ngJQ@@dmU@]FJ\\enlDaIHx`\ngJQ@@dmU@]FJ\\enmx~@\ngJQ@@dmU@]FJ\\erPqSfzpRD\ngJQ@@dmU@]FJ\\erPqSfzpRG|dcb\ngJQ@@dmU@]FJ]FnlDa@\ngJQ@@dmUQH]FJ\\enlD~@<\ngJQ@@dmUQH]FJ\\enlD~@>\ngJQ@@dmUQH]FJ\\enlD~IHx`>\ngJQ@@dmUQH]FJ\\es`qS]XIB<\ngJQ@@dmUQH]FJ\\es`qS]XIB>\ngJQ@@dmUQH]FJ\\es`qS]XI|<\ngJQ@@dmUQH]FJ\\es`qS]XI|>\ngJQ@@dmUQH]FJ\\es`qs]XI|<\ngJQ@@dmUQH]FJ\\es`qs]XI|>\ngJQ@@dmUQH]FJ\\fnlDa@<\ngJQ@@dmUQH]FJ\\fnlDa@>\ngJQ@@dmUQH]FJ\\fs`qS]XIB<\ngJQ@@dmUQH]FJ\\fs`qS]XIB>\ngJQ@@drt`]FJ\\enlD}@\ngJQ@@drt`]FJ\\enmx}@\ngJQ@@drt`]FJ\\eoLD\ngJQ@@drt`]FJ\\eoMx\ngJQ@@drt`]FJ\\eshis]XIz\ngJQ@@drt`]FJ\\eshis][qz\ngJQ@@drt`]FJ\\eshis^XH\ngJQ@@drt`]FJ\\eshis^[p\ngJQ@@drt`]FJ]EnlD}@\ngJQ@@drt`]FJ]EoLD\ngJQ@@drt`]FJ]Eshis]XIz\ngJQ@@drt`]FJ]Eshis^XH\ngJQ@@dru@]FJ\\enlDa@\ngJQ@@dru@]FJ\\enlD~@\ngJQ@@dru@]FJ\\enmxa@\ngJQ@@dru@]FJ\\eshis]XIB\ngJQ@@dru@]FJ\\eshis]XI|\ngJQ@@dru@]FJ\\eshis][qB\ngJQ@@dru@]FJ\\eshis][q|\ngJQ@@dru@]FJ\\fnlDa@\ngJQ@@dru@]FJ]EnlDa@\ngJQ@@dru@]FJ]EnlD~@\ngJQ@@dru@]FJ]Eshis]XIB\ngJQ@@dru@]FJ]Eshis]XI|\ngJQ@@dru@]FJ]FnlDa@\ngJQ@@dsR`]FJ\\e@\ngJQ@@dsR`]FJ\\eoCt\ngJQ@@dsR`]FJ\\eoMt\ngJQ@@dsR`]FJ\\eshir\ngJQ@@dsR`]FJ\\eshis][iz\ngJQ@@dsR`]FJ\\eshis^Gh\ngJQ@@dsR`]FJ\\eshis^[h\ngJQ@@dsR`]ZRRwPwm`\ngJQ@@dsR`]ZRRwpwmgh\ngJQ@@dsTrH]FJ\\enlD}@<\ngJQ@@dsTrH]FJ\\enlD}@>\ngJQ@@dsTrH]FJ\\eoLD<\ngJQ@@dsTrH]FJ\\eoLD>\ngJQ@@dsTrH]FJ\\eoMx<\ngJQ@@dsTrH]FJ\\eoMx>\ngJQ@@dsTrH]FJ\\erPqSfzpSt>\ngJQ@@dsTrH]FJ\\erPqSf|pP<\ngJQ@@dsTrH]FJ\\erPqSf|pP>\ngJQ@@dsTrH]FJ\\eshis]XIz<\ngJQ@@dsTrH]FJ\\eshis]XIz>\ngJQ@@dsTrH]FJ\\eshis][qz<\ngJQ@@dsTrH]FJ\\eshis][qz>\ngJQ@@dsTrH]FJ\\eshis^XH<\ngJQ@@dsTrH]FJ\\eshis^XH>\ngJQ@@dsTrH]FJ\\eshis^[p<\ngJQ@@dsTrH]FJ\\eshis^[p>\ngJQ@@dsURH]FJ\\enlDa@<\ngJQ@@dsURH]FJ\\enlDa@>\ngJQ@@dsURH]FJ\\enlD~@<\ngJQ@@dsURH]FJ\\enlD~@>\ngJQ@@dsURH]FJ\\enmxa@<\ngJQ@@dsURH]FJ\\enmxa@>\ngJQ@@dsURH]FJ\\enmx~@>\ngJQ@@dsURH]FJ\\erPqSfzpRD<\ngJQ@@dsURH]FJ\\erPqSfzpRD>\ngJQ@@dsURH]FJ\\erPqSfzpSx<\ngJQ@@dsURH]FJ\\erPqSfzpSx>\ngJQ@@dsURH]FJ\\erPqSfzwbD>\ngJQ@@dsURH]FJ\\erPqSfzwcx>\ngJQ@@dsURH]FJ\\es`qs]XIB<\ngJQ@@dsURH]FJ\\es`qs]XIB>\ngJQ@@dsURH]FJ\\es`qs]XI|<\ngJQ@@dsURH]FJ\\es`qs]XI|>\ngJQ@@dsURH]FJ\\es`qs][qB<\ngJQ@@dsURH]FJ\\es`qs][qB>\ngJQ@@dsURH]FJ\\eshis]XIB<\ngJQ@@dsURH]FJ\\eshis]XIB>\ngJQ@@dsURH]FJ\\eshis]XI|<\ngJQ@@dsURH]FJ\\eshis]XI|>\ngJQ@@dsURH]FJ\\eshis][qB<\ngJQ@@dsURH]FJ\\eshis][qB>\ngJQ@@dsURH]FJ\\eshis][qC~RAQ@>\ngJQ@@dsURH]FJ\\eshis][q|<\ngJQ@@dsURH]FJ\\eshis][q|>\ngJQ@@dsURH]FJ\\fnlDa@<\ngJQ@@dsURH]FJ\\fnlDa@>\ngJQ@@dsURH]FJ\\frPqSfzpRD<\ngJQ@@dsURH]FJ\\frPqSfzpRD>\ngJQ@@dsURH]FJ\\fs`qs]XIB<\ngJQ@@dsURH]FJ\\fs`qs]XIB>\ngJQ@@dsURH]FJ\\fshis]XIB<\ngJQ@@dsURH]FJ\\fshis]XIB>\ngJQ@@dsURH]FJ\\fshis][qB<\ngJQ@@dsURH]FJ]EnlDa@<\ngJQ@@dsURH]FJ]EnlDa@>\ngJQ@@dsURH]FJ]Es`qs]XIB<\ngJQ@@dsURH]FJ]Es`qs]XIB>\ngJQ@@dsURH]FJ]Es`qs]XI|<\ngJQ@@dsURH]FJ]Es`qs]XI|>\ngJQ@@dsURH]FJ]Eshis]XIB<\ngJQ@@dsURH]FJ]Eshis]XIB>\ngJQ@@dsURH]FJ]Eshis]XI|<\ngJQ@@dsURH]FJ]FnlDa@>\ngJQ@@dwM@]FJ\\eneta@\ngJQ@@dwM@]FJ\\eoBD\ngJQ@@dwM@]FJ\\es`is]KiB\ngJQ@@dwM@]FJ\\eshis]KiB\ngJQ@@dwM@]FJ\\eshis]Ki|\ngJQ@@dwM@]FJ\\eshis^DH\ngJQ@@dwM@]FJ\\eshis^Gp\ngJQ@@dwM@]FJ\\foBD\ngJQ@@dwM@]ZVRwpvmdH\ngJQ@@dwM@]ZVRwpvndH\ngJQ@@dwM@]ZVRytTyoam]HP\ngJQ@@dwM@]ZVRytTyoam]O`\ngJQ@@eMP@]HJ[yAvsl=\ngJQ@@eMP@]HJ[yAvst\ngJQ@@eMP@]HJ[yAwSt=\ngJQ@@eMP@]HJ[y^vsl=\ngJQ@@eMP@]HJ[y^vst\ngJQ@@eMP@]HJ[y^wSt=\ngJQ@@eMP@]HJ\\xLTwrCngh\ngJQ@@eMP@]HJ\\xLTwr}ngh\ngJQ@@eMP@]HJ\\xL\\wrCmgh\ngJQ@@eMP@]HJ\\xL\\wr}mgh\ngJQ@@eMP@]HJkyAvsl=\ngJQ@@eMP@]HJkyAvst\ngJQ@@eMP@]HJkyAwSt=\ngJQ@@eMP@]HJlxLTwrCngh\ngJQ@@eMP@]HJlxL\\wrCmgh\ngJQ@@eMS@]TLTyK]HIB\ngJQ@@eMS@]TLTyK]HI|\ngJQ@@eMS@]TLTyK_HNzP`\ngJQ@@eMS@]TLTyK_HNzPdd\\P\ngJQ@@eMS@]TLTyK_HNz_@\ngJQ@@eMS@]TLTyKgAbfzPRD\ngJQ@@eMS@]TLTyKgAbfzPSx\ngJQ@@eMS@]TLTyKgAbfzWbD\ngJQ@@eMS@]TLTyKgAbf~P]ta@\ngJQ@@eMS@]TLTyKgAbf~P]t~@\ngJQ@@eMS@]TLTyKgAbf~Wmta@\ngJQ@@eMS@]TLTyKgAbf~Wmt~@\ngJQ@@eMS@]TLTyKgAcfzPRD\ngJQ@@eMS@]TLTyKgAcf~P]ta@\ngJQ@@eMS@]TLTyKgAcf~Wmt~@\ngJQ@@eMS@]TLTyM]HIB\ngJQ@@eMS@]TLTyM_HNzP`\ngJQ@@eMS@]TLTyMgAbfzPRD\ngJQ@@eMS@]TLTyMgAbfzWbD\ngJQ@@eMS@]TLTyMgAbf~P]ta@\ngJQ@@eMS@]TLTyMgAbf~Wmta@\ngJQ@@eMS@]TLTyMgAcf~P]ta@\ngJQ@@eMS@]TLUYK]HIB\ngJQ@@eMS@]TLUYK_HNzP`\ngJQ@@eMS@]TLUYKgAbfzPRD\ngJQ@@eMS@]TLUYKgAbf~P]ta@\ngJQ@@eMS@]TLUYKgAbf~P]t~@\ngJQ@@eMS@]TLUYKgAcfzPRD\ngJQ@@eMS@]TLUYKgAcf~P]ta@\ngJQ@@eMS@]TLUYM_HNzP`\ngJQ@@eMS@]TLUYMgAbfzPRD\ngJQ@@eMS@]TLUYMgAbf~P]ta@\ngJQ@@eMS@]XLdwrCmgh\ngJQ@@eMS@]XLdwrCngX\ngJQ@@eMS@]XLdwrCngh\ngJQ@@eMS@]XLdypXiodG]OP\ngJQ@@eMS@]XLdypXyodG[OP\ngJQ@@eMS@]XLdypXyodG]OP\ngJQ@@eMS@]XLeYpXiodG]OP\ngJQ@@eMS@]XLeYpXyodG[OP\ngJQ@@eMU@]TLTyK_HNBP`\ngJQ@@eMU@]TLTyK_HNBPdd\\P\ngJQ@@eMU@]TLTyK_HN|_@\ngJQ@@eMU@]TLTyK_KvBP`\ngJQ@@eMU@]TLTyKdabgM|`xIB\ngJQ@@eMU@]TLTyKdabgM|oXIB\ngJQ@@eMU@]TLTzM_HNBP`\ngJQ@@eMU@]TLUYK_HNBP`\ngJQ@@eMU@]TLUYK_HNBPdd\\P\ngJQ@@eMURH]TLTyK_HNB_@<\ngJQ@@eMURH]TLTyK_HNB_@>\ngJQ@@eMURH]TLTyK_HNB__dd\\P<\ngJQ@@eMURH]TLTyK_HNB__dd\\P>\ngJQ@@eMURH]TLTyK_KvB_@<\ngJQ@@eMURH]TLTyKdabgM|`xI|<\ngJQ@@eMURH]TLTyKdabgM|`xI|>\ngJQ@@eMURH]TLTyKgAbf~P\\Da@<\ngJQ@@eMURH]TLTyKgAbf~P\\Da@>\ngJQ@@eMURH]TLTyKgAbf~P\\D~@<\ngJQ@@eMURH]TLTyKgAbf~P\\D~@>\ngJQ@@eMURH]TLTyKgAbf~WlDa@<\ngJQ@@eMURH]TLTyKgAbf~WlDa@>\ngJQ@@eMURH]TLTyKgAcf~P\\D~@<\ngJQ@@eMURH]TLTyKgAcf~P\\D~@>\ngJQ@@eMURH]TLTyKgAcf~WlD~@<\ngJQ@@eMURH]TLTyKgAcf~WlD~@>\ngJQ@@eMURH]TLTyM_HNBP`<\ngJQ@@eMURH]TLTyM_HNBP`>\ngJQ@@eMURH]TLTyMgAbf~P\\Da@<\ngJQ@@eMURH]TLTyMgAbf~P\\Da@>\ngJQ@@eMURH]TLTyMgAbf~WlDa@<\ngJQ@@eMURH]TLTyMgAbf~WlDa@>\ngJQ@@eMURH]TLTyMgAcf~P\\Da@<\ngJQ@@eMURH]TLTyMgAcf~P\\Da@>\ngJQ@@eMURH]TLTzK_HNB_@<\ngJQ@@eMURH]TLTzK_HNB_@>\ngJQ@@eMURH]TLTzKgAcf~P\\D~@<\ngJQ@@eMURH]TLTzKgAcf~P\\D~@>\ngJQ@@eMURH]TLTzMgAbf~P\\Da@<\ngJQ@@eMURH]TLTzMgAbf~P\\Da@>\ngJQ@@eMURH]TLUYKgAbf~P\\Da@<\ngJQ@@eMURH]TLUYKgAbf~P\\Da@>\ngJQ@@eMURH]TLUYKgAbf~P\\D~@<\ngJQ@@eMURH]TLUYKgAcf~P\\D~@<\ngJQ@@eMURH]TLUYKgAcf~P\\D~@>\ngJQ@@eMURH]TLUYM_HNBP`<\ngJQ@@eMURH]TLUYM_HNBP`>\ngJQ@@eMURH]TLUYMgAbf~P\\Da@<\ngJQ@@eMURH]TLUYMgAbf~P\\Da@>\ngJQ@@eMURH]TLUZKgAcf~P\\D~@<\ngJQ@@eMURH]TLUZKgAcf~P\\D~@>\ngJQAAIRYjPNcENRytTyoLD>\ngJQAAIRYjPNcENbwVB^`>\ngJQAAIRYjPNcENbypXynlD}@>\ngJQDAJATBTuTAtPqtZzpRD\ngJQDHHPpbU]TAu`isdabgMy``>\ngJQDL@aABSKTAuhiK^DH\ngJQDL@aABS[TAuhyK^DH\ngJQH@jAJZ`@z`[k[OP\ngJQH@jAJZ`@z`[k]OP=\ngJQH@jAJZ`@z`[y^vsl=\ngJQH@jAJZ`@z`[y^vst\ngJQH@jAJZ`@z`[y^wSt=\ngJQH@jAJZ`@z`\\xLTwr}ngh\ngJQH@jAJZ`@z`\\xL\\wVv^`\ngJQH@jAJZ`@z`\\xL\\wr}mgh\ngJQH@jAJZf@zHXyKgAbfzWbD\ngJQH@jAJZf@zHXyMgAbfzWbD\ngJQH@jAJZf@zHXyMgAbf~Wmta@\ngJQH@jAJZj@zHXyK]XIB\ngJQH@jAJZjdPzHXyKgAbfzpRD<\ngJQH@jAJzj@zhXitZ~`\\Da@\ngJQHB@aIfe@zTdwPwm`\ngJQHB@aInZ@zTlwPvm`\ngJQHB@aInZ@ztTyoEt\ngJQHBDQIfjdPztTyoLD<\ngJQHBHaIfjdPztTyoLD<\ngJQHBHaIfjdPztTyoLD>\ngJQHBIAIfjdPztTyoLD>\ngJQHBOAIfjdPztTyna{A@<\ngJQHD@aIej@zLTzKgQSfzpRD\ngJQHD@aIff@zLTyKgQSfzwRD\ngJQHD@aIff@ztdeoao[HP\ngJQHD@aIfjdPzLTyKgQSfzpRD<\ngJQHD@aIfjdPzLTyKgQSfzpRD>\ngJQHDIAIfjdPzLTyKgQSfzpRD<\ngJQHH@aIZ`@zd[x^vsl=\ngJQHH@aIZ`@zd[x^vst\ngJQHH@aIZ`@zd[x^wSt=\ngJQHH@aIZ`@zd\\xL\\wp}mgh\ngJQHH@aIZf@zLTyK]CqB\ngJQHH@aIZf@zLTyK_CvzP`\ngJQHH@aIZf@zLTyKgAbfzGbD\ngJQHH@aIZf@zLTyM_CvzP`\ngJQHH@aIZj@zLTyK_CvBP`\ngJQHH@aIZjbPzLTyK_CvB_@<\ngJQHH@aJmj`PzHTyK]XIB<\ngJQHH@aJmj`PzHTyK]XIB>\ngJQHH@aJmj`PzHTyKgQSfzpRD<\ngJQHH@aJmj`PzHTyKgQSfzpRD>\ngJQHH@aJmj`PzHTyM]XIB<\ngJQHH@aJmj`PzHTyM]XIB>\ngJQHH@aJmj`PzHTzK]XIB<\ngJQHH@aJmj`PzHTzK]XIB>\ngJQHH@aJmj`PzHTzM]XIB>\ngJQHHBqIZ`@zd\\xLTwp}ngh\ngJQHHGAIZ`@zd[x^vsl=\ngJQHHGAIZ`@zd[x^vst\ngJQHHGAIZ`@zd[x^wSt=\ngJQHHGAIZ`@zd\\xLTwVz^`\ngJQHHGAIZ`@zd\\xL\\wVv^`\ngJQHHGAIZf@zLTyK]CqB\ngJQHHGAIZf@zLTyK_CvzP`\ngJQHHGAIZj@zLTyK_CvBP`\ngJQHHGAIZjbPzLTyK_CvB_@<\ngJQHHGAIZjbPzLTyK_CvB_@>\ngJQHHGAIZjbPzLTyKgAbf~GlDa@>\ngJQHHGAIZjbPzLTyM_CvBP`<\ngJQHHGAIZjbPzLTyM_CvBP`>\ngJQHHOAIZ`@zd[k[Np=\ngJQHHOAIZ`@zd[k[OP\ngJQHHOAIZ`@zd[k]OP=\ngJQHHOAIZ`@zd[x^vsl=\ngJQHHOAIZ`@zd[x^vst\ngJQHHOAIZ`@zd[x^wSt=\ngJQHHOAIZ`@zd\\xLTwVz^`\ngJQHHOAIZ`@zd\\xLTwp}ngh\ngJQHHOAIZ`@zd\\xL\\wVv^`\ngJQHHOAIZ`@zd\\xL\\wp}mgh\ngJQHHOAIZf@zLTyM_CvzP`\ngJQHHOAIZj@zLTyK]XIB\ngJQHHOAIZj@zLTyK_CvBP`\ngJQHHOAIZjbPzLTyKgAbf~GlDa@<\ngJQHHOAIZjbPzLTyKgAbf~GlDa@>\ngJQHHOAIZjbPzLTyMgAbf~GlDa@>\ngJQHHOAIZjbPzLTzKgAcf~GlD~@>\ngJQHL@aIZf@ztTeoBD\ngJQHL@aIZf@ztTfnaxa@\ngJQHL@aIZf@ztTfoBD\ngJQHL@aIZjb`ztTeoBD<\ngJQHL@aIZjb`ztTeoBD>\ngJQHL@aIZjb`ztTes`qs^DH<\ngJQHL@aIZjb`ztTes`qs^DH>\ngJQHL@aJZf@zHXiK]HIB\ngJQHL@aJZf@zHXiK]HI|\ngJQHL@aJZf@zHXiK]KqB\ngJQHL@aJZf@zHXiM]HIB\ngJQHL@aJZf@zHXjK]HIB\ngJQHL@aJZf@zHXjK]HI|\ngJQHL@aJZf@zHXjM]HIB\ngJQHL@aJZjdPzHXiK]HIB<\ngJQHL@aJZjdPzHXiK]HIB>\ngJQHL@aJZjdPzHXjK]HIB<\ngJQHL@aJZjdPzHXjK]HIB>\ngJQHLHaIZf@ztTeoBD\ngJQHLHaIZf@ztTfoBD\ngJQHLHaIZjb`ztTeoBD<\ngJQHLHaIZjb`ztTeoBD>\ngJQHLJqIZjb`ztTeoBD>\ngJQHLLQIZf@ztTfoBD\ngJQH`jBRnRfj`NbFNSYpXioe{AHP>\ngJQI@jA\\eMP@]PN\\FJ[y^wSt\ngJQI@jA\\eMP@]PN\\FN[y^vst\ngJQI@jA\\eMS@]DL\\fs`qS]KqB\ngJQI@jA\\eMS@]DL\\fs`qS_KvzP`\ngJQIHO@RdmP@]RM|O[Yv=\ngJQ`@bdvu@]JNP\ngJQ`@ldru@]ZJRwaB\ngJQ`@ldru@]ZJRwa|\ngJQ`@ldru@]ZJRytTyoBD\ngJQ`@ldru@]ZJRytTyoCx\ngJQ`@ldru@]ZJSWaB\ngJQ`AbeMU@]XLTyHXis^HH\ngJQa@bnR[Z`NeGH\ngJQdAcJATBTuTAt`qs`qR>\ngJQeAcJATByJZj@zPXypXioEx>\ngJQhAbjAJzj@zpXioHD\ngJQhAbjAJzj@zpYIoHD\ngJQhAbjAJzj@zpYIs`qS^PH>\ngJQhHl@aJmj`PzpTeshis^DH<\ngJQhHl@aJmj`PzpTeshis^DH>\ngJQhHlOAJfj@zpXeoBD\ngJQhHlOAJfj@zpXerPqSf|HP\ngJQhHlOAJfj@zpXfoBD\ngJQhHlOAJfj`PzpXfs`qs^DH<\ngJQhHlOAJfj`PzpXfs`qs^DH>\ngJR@@lTfVhCiRS]C^w~tP\ngJR@@lTfphCjYnam[ZX=\ngJR@ALTkfXCiAU][Yw~t@\ngJR@ALTkfXCiAU][Y{~t@\ngJR@`lQJyIej@zTdwPwmmD\ngJR@`lQJyIej@zTdwPwnmD\ngJR@`lQJyIej@zTdwP{nmD\ngJR@`lUqeIej@zTdwPwmmD\ngJR@`l]qeIlJ@zf[h[Vvf@=\ngJRA@lQJSKTAthiZH\ngJRA@lUrSKTAtiInao[ZH\ngJRA@lUrSKTAtiInao]ZH\ngJRAALSrUsLAt`jnml{Z@\ngJRAAL]JUsLAt`jnmt}Z@\ngJT@@TfRDCjInao[@\ngJT@@TfVhCkQSf|pP\ngJT@@TfVhCkQSkNbgMtNxH\ngJT@@TfZjQCkQSf|pP<\ngJT@@TfZjQCkQSf|pP>\ngJT@@TfZjQCkQSgNCGMy``<\ngJT@@TfZjQCkQSgNCGMy``>\ngJT@@TfZjQCkQSgNbgMy``<\ngJT@@TfZjQCkQSgNbgMy``>\ngJT@@TfZjQCkQSkNCGMy``<\ngJT@@TfZjQCkQSkNCGMy``>\ngJT@@TfphCjYnam[@\ngJT@@TfphCjYnam]@\ngJT@@TfyhCiRs]CZv\ngJT@@TfyhCiRs]CZz\ngJT@@TfyhCiRs]Cjv\ngJT@@TfyhCiRs]Cjz\ngJT@@TfyhCiRsgASfzGUl\ngJT@@TfyhCiRsgQSfzGUt\ngJT@@TjZhChabgMt`xH\ngJT@@TjZhChabgMt`xO{P@=\ngJT@@TjZhChabgMt`{w{P@\ngJT@@TjZhChabgNRFJ\\wRC``\ngJT@@TjZhChabgNRFJ\\wrC`gp\ngJT@@TjZhChabgN\\EN[iAwov`@\ngJT@@TjZhChabgN\\FN[iAp_v`@\ngJT@@TjZhChabgUt`xO{P@\ngJT@@TjZhChabgV\\FN[iAp_v`@\ngJT@@TjZhCiBc]K^w~t@=\ngJT@@TjZhCiBc]K^{~t@\ngJT@@TjZhCiBcgASfzV}w}h@\ngJT@@TjZjAChabgN\\FN[iApP<\ngJT@@TjZjAChabgN\\FN[iApP>\ngJT@@TjZjAChabgN\\FN[iAw`<\ngJT@@TjZjAChabgN\\FN[iAw`>\ngJT@@TjZjAChabgVRFJ\\wRC``<\ngJT@@TjZjAChabgVRFJ\\wRC``>\ngJT@@TjZjAChabgV\\FN[iApP>\ngJT@@defhChqSdmu`dO{Q@=\ngJT@@defhChqSdn\\FJ[kAH_vb@\ngJT@@defhChqSdv\\FJ[kAH_vb@\ngJT@@dfRHCiIK_C^vPmD\ngJT@@dfRHCiIK_C^zPmD\ngJT@@dfRHCiIK_CnvPmD\ngJT@@dfRHCiIKgQSf~F}taZH\ngJT@@dfRHCiIM_C^vPmD\ngJT@@dfRHCiIM_C^zPmD\ngJT@@dfRHCiIMgQSf~F}taZH\ngJT@@dfVhChqSdmu`dO{Q@\ngJT@@dfVhChqSdn\\FN[kAH_vb@\ngJT@@dfVhChqSdn\\FN[k^H_vb@\ngJT@@dfVhChqSdn]EN[x]pRG}h`\ngJT@@dfVhChqSduu`dO{Q@\ngJT@@dfVhChqSduuoDO{Q@\ngJT@@dfVhChqSdu|NxIC~tP\ngJT@@dfVhChqSdv\\FN[kAH_vb@\ngJT@@dfVhChqShmu`dO{Q@\ngJT@@dfVhChqShmu`gw{Q@\ngJT@@dfVhChqShn\\FN[kAH_vb@\ngJT@@dfVhChqShuu`dO{Q@\ngJT@@dfVhChqShu|NxIC~tP\ngJT@@dfVhChqShv\\FN[kAH_vb@\ngJT@@dfVhCkRRV~F}laZH\ngJT@@dfVhCkRRV~F}taZH\ngJT@@dfVhCkRRWNbgM|M{iC~tP\ngJT@@dfVhCkRRZ~F}taZH\ngJT@@dfphCiYK_CZvP`=\ngJT@@dfvdCkQrWNBgH\ngJT@@dfvdCkQrWNbgH\ngJT@@dfvdCkRrVzFut\ngJT@@dfvhCkQrV|HP\ngJT@@dfvhCkQrWNbgMxP`\ngJT@@dfvhCkQrZzGRD\ngJT@@dfvhCkQrZ|HP\ngJT@@dfvhCkRrV~Fula@\ngJT@@dfvhCkRrV~Futa@\ngJT@@dfvhCkRrZ~Fula@\ngJT@@dfvhCkRrZ~Futa@\ngJT@@dfzhCkQrV|HP\ngJT@@dfzhCkQrWICEN[pa@\ngJT@@dfzjQCkQrWNBgMxP`<\ngJT@@dfzjQCkQrWNBgMxP`>\ngJT@ADiihCjabgI[kAH_vP`=\ngJT@ADiihCjabgI[kAOovP`\ngJT@ADiihCjabgI[y]pRG}dH=\ngJT@ADiihCjabgI\\xLTwVBPla@\ngJT@ADiihCjabgI\\xLTwr{`dO{HP\ngJT@ADiihCjabgIkkAH_vP`\ngJT@ADiihCjabgIlxLTwr{`dO{HP\ngJT@ADiihCjabgQkkAH_vP`=\ngJT@ADiihCkAdfzvso}dH=\ngJT@ADiihCkAdfzwSw}dH=\ngJT@ADiihCkAdgNCEM|n{i{~rD@\ngJT@ADiihCkAdgNCGM|n{Y{~rD@\ngJT@ADjZhCjabgI[yApRG}dH=\ngJT@ADjZhCjabgI[yApRG}h@=\ngJT@ADjZhCjabgI[yApRG}i@\ngJT@ADjZhCjabgI[yAwbG}dH\ngJT@ADjZhCjabgI\\xL\\wrC`dO{P@\ngJT@ADjZhCjabgIkyApRG}dH=\ngJT@ADjZhCjabgQ[yApRG}dH\ngJT@ADjZhCjabgQkyApRG}dH\ngJT@ADjZhCkBbV~W]taYB@=\ngJT@ADjzhChaSdmu`dO{P@\ngJT@ADjzhChaSdn\\FN[kAH_v`@\ngJT@ADjzhChaSdn]EN[kAH_v`@\ngJT@ADjzhChaSduu`dO{P@\ngJT@ADjzhChaShmu`dO{P@\ngJT@ADjzhCkBRV~f}laZ@\ngJT@ADjzhCkBRV~f}l~Z@\ngJT@ADjzhCkBRV~f}taZ@\ngJT@ADjzhCkBRWNbgM}M{iC~t@\ngJT@ADjzhCkBRZ~f}laZ@\ngJT@ADjzhCkBRZ~f}taZ@\ngJT@ADjzjAChaSdmu`dH<\ngJT@ADjzjAChaSdmu`dH>\ngJT@ADjzjAChaSdn]EN[kAHP<\ngJT@ADjzjAChaSdn]EN[kAHP>\ngJT@ADjzjAChaSduu`dH<\ngJT@ADjzjAChaSduu`dH>\ngJT@ADkf@CjAnml{Z@=\ngJT@ADkf@CjAnml}Z@\ngJT@ADkf@CjAnmt}Z@=\ngJT@ADkf@CjAoiw[Nv`@=\ngJT@ADkf@CjAoiw[O_v`@\ngJT@ADkf@CjAoiw]O_v`@=\ngJT@ADkfXChaSdmundO{P@\ngJT@ADkfXChaSduundO{P@\ngJT@ADkfXCiAU][i{~t@\ngJT@ADkj@CjAnml{Z@=\ngJT@ADkj@CjAnml}Z@\ngJT@ADkj@CjAnmt}Z@=\ngJT@ADkjXChaSdmundO{P@\ngJT@AdefdCiQU][Yv\ngJT@AdefdCiQU][Yz\ngJT@AdefdCiQU][iv\ngJT@AdefdCiQUgAbf~G]t}@\ngJT@Adii@CiAS][Yw~t@\ngJT@Adii@CiAS_Knv]m@\ngJT@Adii@CiASgAbf~W]t{Z@\ngJT@Adii@CiASgAcf~W]l}Z@\ngJT@AdiiXChabdmtngw{P@\ngJT@AdiiXChabdv\\FJ[y]wRG}h@\ngJT@AdiiXChabdv\\FN[y]wRG}h@\ngJT@AdiidChabdn\\FN[i]O_v`@\ngJT@AdiidChabdn\\FN[q]Z@\ngJT@AdiidCkAdfzwSo}h@\ngJT@AdiidCkAdfzwSw}h@\ngJT@AdiidCkAdgNCEM|n{i{~t@\ngJT@AdiidCkAdgNCGMumgo{P@\ngJT@AdiidCkAdgNCGMungo{P@\ngJT@AdiidCkAdgNCGM|n{Y{~t@\ngJT@AdiidCkAdgNCGM|n{i{~t@\ngJT@AdijdChabdmt`go{P@\ngJT@AdijdChabdn\\FJ[iAO_v`@\ngJT@AdijdChabdn\\FN[iAO_v`@\ngJT@AdijdChabdn\\FN[qAZ@\ngJT@AdijdCkAdf~P]t{Z@\ngJT@AdijdCkAdf~P]t}@\ngJT@AdijdCkAdf~Wmt}@\ngJT@AdijdCkAdgNCEM|`{iz\ngJT@AdijdCkAdgNCGM|`{Y{~t@\ngJT@AdijdCkAdgNCGM|`{iz\ngJT@AdijjQChabdmt`dO{P@<\ngJT@AdijjQChabdmt`dO{P@>\ngJT@AdijjQChabdnRFJ\\wRBP`>\ngJT@AdijjQChabdv\\FJ[iAHP<\ngJT@AdijjQChabdv\\FJ[iAH_v`@<\ngJT@AdijjQChabdv\\FJ[iAH_v`@>\ngJT@AdijjQChabhmt`dO{P@<\ngJT@AdijjQChabhv\\FJ[iAH_v`@<\ngJT@AdijjQChabhv\\FJ[iAH_v`@>\ngJT@`QIeIfjdPztTys`qs^XH>\ngJT@`QIeIlJ@zf[h[Vp\ngJT@`aJyIdb@zRRypXyoaw[H_vb@\ngJT@`aJyIdb@zRRytTyoaw]H_vb@\ngJT@aAteJz`@z`[k[Nv`@=\ngJT@aAteJz`@z`[k[O_v`@\ngJT@aAteJz`@z`[k]O_v`@=\ngJT@aAteJzj@zHTyK]XIC~t@\ngJTA@QJSIBAuDwPwm`\ngJTA@QJSMUHauhis^XH<\ngJTA@QJSMUHauhis^XH>\ngJTA@QJSXTAuLwPvm`\ngJTA@QJUMTAtPqSgICEN[iApP\ngJTA@SJSXTAuLwPvm`\ngJTA@SJUMTAtPqSgICEN[iApP\ngJTA@SJUMTAtPqSgICEN[yApSx\ngJTA@aJRsTAtXirWNCEM|NxIC~tP\ngJTA@aJRsTAtXir[NCEM|NxIC~tP\ngJTA@aJSIDAtdeoao[H_vb@\ngJTA@aJSIDAtdeoaw[H_vb@\ngJTA@aJSIDAtdfoao[H_vb@\ngJTA@aJSKTAtXirWNbgMu`dO{Q@\ngJTA@aJS[RAuhyKgQSd\ngJTA@aJS[TAuiYK_CZvP`\ngJTA@aJS[TAuiYM_CjzP`\ngJTAAAJU[TAuaIK_S^vPm@\ngJTAAaJRuRAthjnml{@\ngJTAAaJRuUEAuhiK^DH>\ngJTD@UPZ`Rkj`NlFR\\zJ\\wdC~t@\ngJTDAePF`Rnj`NlFR\\xL\\wdC~t@>\ngJTDAiPJ`Rfj`NlFI\\xLTwaB>\ngJTDE`DGpRYZ`NeEMx__mD\ngJTDEaxR`RYj`NmEIlzJ\\waC~tP>\ngJTDLPDHHR[Z`NeGO{S@\ngJTDLPDPHRnh@NhFzvsl=\ngJTDLPDPHRni`NdEUumgX\ngJTDLPDPHRni`NdEUumgh\ngJTD`UPZ`DkdjzjACkAbgNbgMyO@<\ngJTD`UPZ`DkdjzjACkAbgNbgMyO@>\ngJTDe`DDHT{dfyhCiRs_CZv__mL\ngJTDlQVPHGZTejXCiQR\ngJTELPDPHtiWTpGRBd\ngJTHACPISSPGQCENlxL\\wr{`gw{HP\ngJTHAePIWUPGQCII\\xLTwTBPm@>\ngJTHDPDIMsPGRefzFul\ngJTHE`DILmHGVbdmx^mD\ngJTHE`DILmHGVbdn]EN[p}ZH\ngJTHE`DILmPGVbdmxPmD\ngJTHE`DILmPGVbdmx__mD\ngJTHE`DILmPGVbdn]EN[paZH\ngJTHE`DILmPGVbduxPmD\ngJTHE`DILmPGVbdv]EN[paZH\ngJTHE`DILthGVddmtM{_{Q@\ngJTHE`DILthGVddm|M{Y{~tP\ngJTHE`DILthGVddn]EN[x[wSw}h`\ngJTHE`DIMsPGVcdmxPmL\ngJTHE`DIMsPGVcdn]EN[paZX\ngJTHE`DIMsPGVcduxPmL\ngJTHE`DIMsPGVedm|MkYC~tp\ngJTHE`DIMsPGVedu|MkYC~tp\ngJTHEaDILthGVbdn]EN[p}ZH\ngJTHHPDILuPGVbgN]EN[h^p_vd@\ngJTHH`xIKUPGQbgI[x^pRD\ngJTHHaxILuHGQbgI[h^p_vTP\ngJTHI`DIKT@GTc_Cvv]mH\ngJTHI`DIKTpGRbj~Gml{ZP\ngJTHI`DIKUHGRbj~Gmt}ZP\ngJTHIaxIKT@GTc_Cvv]mH\ngJTHLPDIST@GRBf~P]l{@=\ngJTHLPDIST@GRBj~P]l{@=\ngJTHLPDISTpGVCEMx``\ngJTHLPDISTpGVCEN\\FJ[qA@\ngJTHLPDISTpGVCEN\\FN[iAwP\ngJTHLPDISTpGVCIM|`{Yv\ngJTHLPDISTpGVCIM|`{Yz\ngJTHLPDISTpGVCIN\\FN[yAvst\ngJTH`mPB]rS[TAuiYK_CjzP`\ngJTHe`DCeJS\\tAuhyKgQSf|H_vf@\ngJTHe`DJ]rS\\tAuiYKgQSf~FutaZX\ngJTHe`bCeJS\\tAuhyK]KiC~tp\ngJTHi`DSmJRu@AuHwp}mg_{R@\ngJTHlQxCmJTuLAu`rU_HNz^`\ngJTIE`DJTfyhCkRrV~FulaZX\ngJTILPDZTijXCkAbf|PP\ngJTIhaVCiJeJZ`@z`[k[Nvd@=\ngJTIhaVCiJeJZ`@z`[k]O_vd@=\ngJTIhabCiJeJZ`@z`[k[Nvd@=\ngJTIhabCiJeJZ`@z`[k]O_vd@=\ngJT`E`TfVhCiQR\ngJT`LPdfVhCiQR\ngJT`LPdfvhCiQs~tp\ngJT`i`iJyImi@zt\\eoCw}eL\ngJT`i`iJyImj@zt\\eoBG}eL\ngJT`i`iJyImj@zt\\foBG}eL\ngJTai`iJ{\\dvu@]ZNRwaC~rf@\ngJTai`iJ{\\dvu@]ZNSWaC~rf@\ngJU@DPdru@]ZJ\\wfC~tP\ngJU@DPdru@]ZJ\\wf}~tP\ngJU@DPdru@]ZJ\\ytTyoLG}h`\ngJU@DPdru@]ZJ]WfC~tP\ngJU@DPdru@]ZJ]YtTyoLG}h`\ngJU@DPdvt`]JN\\zJ\\`\ngJU@DPdvu@]JNP\ngJU@DPdvu@]JN\\zJ\\`\ngJU@E`drt`]ZJRwa{~tP\ngJU@E`drt`]ZJRytTyoCw}h`\ngJU@E`dru@]ZJRwaC~tP\ngJU@E`dru@]ZJRwa}~tP\ngJU@E`dru@]ZJRytTyoBG}h`\ngJU@E`dru@]ZJRytTyoC{}h`\ngJU@E`dru@]ZJSWaC~tP\ngJU@E`dru@]ZJSYtTyoBG}h`\ngJU@E`dwM@]ZVSWpvmdO{S@\ngJU@H`dlu@]FJ\\enlDaYQ@=\ngJU@H`dlu@]FJ\\fnlDaYQ@\ngJU@I`eMU@]XLdwrCmgo{R@\ngJU@LPdmS@]JJkk[Np\ngJU@LPdmS@]JJkk[OP\ngJU@LPdmS@]JJlxL\\wVv^`\ngJU@LPeMP@]HJ[yAvsl=\ngJU@LPeMP@]HJkyAvsl=\ngJU@LPeMS@]XLTwbB\ngJU@LPeMS@]XLUWbB\ngJU@LPeMU@]XLTwbB\ngJU@e`NTiMsPGVcdn]EN[paZX\ngJUADPYRYZ`NmENksAZH\ngJUADPYR[Z`NeGH\ngJUAE`nRYZ`NmEI\\zJ\\waC~tP\ngJUAE`nRYZ`NmEIlzJ\\waC~tP\ngJUAEanRYZ`NmEI[paZH\ngJUAEanRYZ`NmEI\\zJ\\waC~tP\ngJUDEhO@~BUMTAt`qIPh`\ngJUHEhOAJfj@zpXfoBG|eBb\ngJUHH\\@aIZf@zTTw`}~t`\ngJUHLPjAJzj@zpXioHD\ngJUIH\\@b\\dmS@]JJ[p^ZP\ngJX@@dlp@]RMumgX=\ngJX@@dlp@]RMumgh\ngJX@@dlp@]RMungh=\ngJX@@dlp@]RM|N{Yv=\ngJX@@dlp@]RM|N{Yz\ngJX@@dlp@]RN\\FJ[x]wSt\ngJX@@dlp@]RN\\FN[k[OP\ngJX@@dlp@]RN\\FN[x]vst\ngJX@@dls@]FJ\\enmta@\ngJX@@dls@]FJ\\eoBD\ngJX@@dls@]FJ\\foBD\ngJX@@dls@]JJkk[OP\ngJX@@dls@]JJkk]OP\ngJX@@dlu@]FJ\\enlDa@\ngJX@@dmP@]RMumgX=\ngJX@@dmP@]RMumgh\ngJX@@dmP@]RMungh=\ngJX@@dmP@]RN\\FJ[k]OP\ngJX@@dmP@]RN\\FN[k[OP\ngJX@@dmP@]RN\\FN[x^vst\ngJX@@dmS@]FJ\\enmta@\ngJX@@dmS@]FJ\\eoBD\ngJX@@dmS@]FJ\\es`qS][iB\ngJX@@dmS@]FJ\\es`qS^DH\ngJX@@dmS@]FJ\\es`qs][iB\ngJX@@dmS@]FJ\\es`qs^DH\ngJX@@dmS@]FJ\\foBD\ngJX@@dmS@]FJ\\fs`qs][iB\ngJX@@dmS@]JJlxLTwVz]`\ngJX@@dmS@]JJlxLTwVz^`\ngJX@@dmU@]FJ\\enlDa@\ngJX@@dmU@]FJ\\erPqSfzpRD\ngJX@@dmU@]FJ]FnlDa@\ngJX@@dmUQH]FJ\\enlD~@<\ngJX@@dmUQH]FJ\\es`qS]XIB<\ngJX@@dmUQH]FJ\\es`qS]XIB>\ngJX@@dmUQH]FJ\\es`qS]XI|<\ngJX@@dmUQH]FJ\\es`qS]XI|>\ngJX@@dmUQH]FJ\\es`qs]XI|<\ngJX@@dmUQH]FJ\\es`qs]XI|>\ngJX@@dmUQH]FJ\\fnlDa@<\ngJX@@dmUQH]FJ\\fnlDa@>\ngJX@@dmUQH]FJ\\frPqSfzpRD>\ngJX@@dmUQH]FJ\\fs`qS]XIB<\ngJX@@dmUQH]FJ\\fs`qS]XIB>\ngJX@@dmUQH]FJ\\fs`qs]XIB<\ngJX@@dmUQH]FJ]EnlD~@<\ngJX@@dmUQH]FJ]EnlD~@>\ngJX@@drP`]II[h[vp\ngJX@@drP`]II[h[wP\ngJX@@drP`]II[x[vst\ngJX@@drP`]II\\xL\\wp{mgh\ngJX@@drt`]FJ\\enlD}@\ngJX@@drt`]FJ\\enmx}@\ngJX@@drt`]FJ\\eoLD\ngJX@@drt`]FJ\\eoMx\ngJX@@drt`]FJ\\es`qs]XIz\ngJX@@drt`]FJ\\es`qs_CnB^`\ngJX@@drt`]FJ\\eshis]CnB\ngJX@@drt`]FJ\\eshis]XIz\ngJX@@drt`]FJ\\eshis^XH\ngJX@@drt`]FJ\\eshis_CnB^`\ngJX@@drt`]FJ]EnawA@\ngJX@@drt`]FJ]Es`qs]XIz\ngJX@@drt`]FJ]Eshis_CnB^`\ngJX@@dru@]FJ\\enlDa@\ngJX@@dru@]FJ\\enlD~@\ngJX@@dru@]FJ\\eoawAHP\ngJX@@dru@]FJ\\eoaw^HP\ngJX@@dru@]FJ\\es`qs]XIB\ngJX@@dru@]FJ\\eshis]XIB\ngJX@@dru@]FJ\\eshis][qB\ngJX@@dru@]FJ\\eshis_CnBP`\ngJX@@dru@]FJ\\eshis_Cn|P`\ngJX@@dru@]FJ\\fnlDa@\ngJX@@dru@]FJ]EnlDa@\ngJX@@dru@]FJ]EoawAHP\ngJX@@dru@]FJ]Es`qs]XIB\ngJX@@dru@]FJ]Es`qs]XI|\ngJX@@dru@]FJ]Eshis_CnBP`\ngJX@@dru@]ZRRwpwmdH\ngJX@@dru@]ZRRwpwndH\ngJX@@dru@]ZRRytTyoao]HP\ngJX@@dsR`]FJ\\e@\ngJX@@dsR`]FJ\\es`qs^Gh\ngJX@@dsR`]FJ\\es`qs^[h\ngJX@@dsR`]FJ\\eshir\ngJX@@dsR`]FJ\\eshis][iz\ngJX@@dsR`]FJ\\eshis^Gh\ngJX@@dsR`]ZRRwPwm`\ngJX@@dsR`]ZRRwPwn`\ngJX@@dsR`]ZRRwP{m`\ngJX@@dsR`]ZRRwP{n`\ngJX@@dsR`]ZRRwpwmgh\ngJX@@dsR`]ZRRwpwngh\ngJX@@dsR`]ZRRwp{mgh\ngJX@@dsR`]ZRRytTyoaw]OP\ngJX@@dsTrH]FJ\\enlD}@>\ngJX@@dsTrH]FJ\\eoLD<\ngJX@@dsTrH]FJ\\eoLD>\ngJX@@dsTrH]FJ\\erPqSf|pP<\ngJX@@dsTrH]FJ\\erPqSf|pP>\ngJX@@dsTrH]FJ\\erPqSf|w`<\ngJX@@dsTrH]FJ\\erPqSf|w`>\ngJX@@dsTrH]FJ\\es`qs^XH<\ngJX@@dsTrH]FJ\\es`qs^XH>\ngJX@@dsTrH]FJ\\eshis]XIz<\ngJX@@dsTrH]FJ\\eshis^XH<\ngJX@@dsTrH]FJ\\eshis^XH>\ngJX@@dsTrH]FJ\\eshis^[p<\ngJX@@dsTrH]FJ]EoLD<\ngJX@@dsURH]FJ\\enlDa@<\ngJX@@dsURH]FJ\\enlDa@>\ngJX@@dsURH]FJ\\enlD~@<\ngJX@@dsURH]FJ\\enlD~@>\ngJX@@dsURH]FJ\\enmxa@<\ngJX@@dsURH]FJ\\enmxa@>\ngJX@@dsURH]FJ\\erPqSfzpRD<\ngJX@@dsURH]FJ\\erPqSfzpRD>\ngJX@@dsURH]FJ\\erPqSfzwbD<\ngJX@@dsURH]FJ\\erPqSfzwbD>\ngJX@@dsURH]FJ\\es`qs]XIB<\ngJX@@dsURH]FJ\\es`qs]XIB>\ngJX@@dsURH]FJ\\es`qs]XI|<\ngJX@@dsURH]FJ\\es`qs]XI|>\ngJX@@dsURH]FJ\\es`qs][qB<\ngJX@@dsURH]FJ\\es`qs][qB>\ngJX@@dsURH]FJ\\eshis]XIB<\ngJX@@dsURH]FJ\\eshis]XIB>\ngJX@@dsURH]FJ\\eshis]XI|<\ngJX@@dsURH]FJ\\eshis]XI|>\ngJX@@dsURH]FJ\\eshis][qB<\ngJX@@dsURH]FJ\\eshis][qB>\ngJX@@dsURH]FJ\\fnlDa@<\ngJX@@dsURH]FJ\\fnlDa@>\ngJX@@dsURH]FJ\\fnmxa@<\ngJX@@dsURH]FJ\\fnmxa@>\ngJX@@dsURH]FJ\\fs`qs]XIB<\ngJX@@dsURH]FJ\\fs`qs]XIB>\ngJX@@dsURH]FJ\\fshis]XIB<\ngJX@@dsURH]FJ\\fshis]XIB>\ngJX@@dsURH]FJ\\fshis][qB>\ngJX@@dsURH]FJ]EnlDa@<\ngJX@@dsURH]FJ]EnlDa@>\ngJX@@dsURH]FJ]ErPqSfzpRD<\ngJX@@dsURH]FJ]Es`qs]XIB<\ngJX@@dsURH]FJ]Es`qs]XIB>\ngJX@@dsURH]FJ]Es`qs]XI|<\ngJX@@dsURH]FJ]Es`qs]XI|>\ngJX@@dsURH]FJ]Eshis]XIB<\ngJX@@dsURH]FJ]Eshis]XIB>\ngJX@@dsURH]FJ]FnlDa@<\ngJX@@dsURH]FJ]FnlDa@>\ngJX@@dsURH]FJ]Fs`qs]XIB<\ngJX@@dsURH]FJ]Fs`qs]XIB>\ngJX@@dvE@]KI[x[VrD\ngJX@@dvE@]KI[x[Vsx\ngJX@@dvE@]KI[x[WRD\ngJX@@dvE@]KI[x]VrD\ngJX@@dvE@]KI\\zJ\\wpvndH\ngJX@@dvE@]KI\\zJ\\wpvngp\ngJX@@dvE@]KIkx[VrD\ngJX@@dvE@]KIkx[WRD\ngJX@@dwM@]FJ\\eneta@\ngJX@@dwM@]FJ\\eoBD\ngJX@@dwM@]FJ\\es`is]KiB\ngJX@@dwM@]FJ\\es`is^DH\ngJX@@dwM@]FJ\\eshis]KiB\ngJX@@dwM@]FJ\\eshis]Ki|\ngJX@@dwM@]FJ\\eshis^DH\ngJX@@dwM@]FJ\\eshis^Gp\ngJX@@dwM@]FJ\\fneta@\ngJX@@dwM@]ZVRwpvmdH\ngJX@@dwM@]ZVRwpvndH\ngJX@@dwM@]ZVRwpzmdH\ngJX@@dwM@]ZVRwpzndH\ngJX@@dwM@]ZVRypTyoau[HP\ngJX@@dwM@]ZVRypTyoau]HP\ngJX@@dwM@]ZVRytTyoam]HP\ngJX@@dwM@]ZVRytTyoau]HP\ngJX@@dwM@]ZVRytTyoau]O`\ngJX@@dwM@]ZVSWpvmdH\ngJX@@dwM@]ZVSWpvndH\ngJX@@dwM@]ZVSWpzmdH\ngJX@@dwM@]ZVSWpzndH\ngJX@@eMH@]HJ[k[Nv`@=\ngJX@@eMH@]HJ[k[O_v`@\ngJX@@eMH@]HJ[k]O_v`@=\ngJX@@eMH@]HJ[y]vso}h@=\ngJX@@eMH@]HJ[y]vsw}h@\ngJX@@eMH@]HJ[y]wSw}h@=\ngJX@@eMH@]HJ\\xLTwVz^m@\ngJX@@eMH@]HJ\\xLTwr{ngo{P@\ngJX@@eMH@]HJ\\xL\\wVv^m@\ngJX@@eMH@]HJ\\xL\\wr{mgo{P@\ngJX@@eMK@]TLTyK][iC~t@\ngJX@@eMK@]TLTyK_KnzPm@\ngJX@@eMK@]TLTyKgAbfzWRG}h@\ngJX@@eMK@]TLTyKgAbf~W]taZ@\ngJX@@eMK@]XLdypXioew]O_v`@\ngJX@@eMP@]HJ[yAvso}h@=\ngJX@@eMP@]HJ[yAvsw}h@\ngJX@@eMP@]HJ[yAwSt=\ngJX@@eMP@]HJ[yAwSw}h@=\ngJX@@eMP@]HJ[y^vso}h@=\ngJX@@eMP@]HJ[y^vsw}h@\ngJX@@eMP@]HJ\\xLTwrCngh\ngJX@@eMP@]HJ\\xLTwrCngo{P@\ngJX@@eMP@]HJ\\xLTwr}ngh\ngJX@@eMP@]HJ\\xL\\wrCmgo{P@\ngJX@@eMP@]HJ\\xL\\wr}mgo{P@\ngJX@@eMP@]HJkyAvso}h@=\ngJX@@eMP@]HJkyAvsw}h@\ngJX@@eMP@]HJkyAwSt=\ngJX@@eMP@]HJkyAwSw}h@=\ngJX@@eMP@]HJlxLTwrCngh\ngJX@@eMP@]HJlxLTwrCngo{P@\ngJX@@eMP@]HJlxL\\wrCmgo{P@\ngJX@@eMS@]TLTyK]HIC~t@\ngJX@@eMS@]TLTyK_HNzPdd\\[P@\ngJX@@eMS@]TLTyK_HNzPm@\ngJX@@eMS@]TLTyKgAbfzPRG}h@\ngJX@@eMS@]TLTyKgAbf~P]taZ@\ngJX@@eMS@]TLTyKgAbf~WmtaZ@\ngJX@@eMS@]TLTyKgAcf~P]taZ@\ngJX@@eMS@]TLTyM_HNzPm@\ngJX@@eMS@]TLTyMgAbfzPRG}h@\ngJX@@eMS@]TLTyMgAbf~P]taZ@\ngJX@@eMS@]TLUYK]HIC~t@\ngJX@@eMS@]TLUYK_HNzPdd\\[P@\ngJX@@eMS@]TLUYK_HNzPm@\ngJX@@eMS@]TLUYKgAbfzPRG}h@\ngJX@@eMS@]TLUYKgAbf~P]taZ@\ngJX@@eMS@]TLUYKgAcf~P]taZ@\ngJX@@eMS@]TLUYM_HNzPm@\ngJX@@eMS@]TLUYMgAbf~P]taZ@\ngJX@@eMS@]XLdwrCng_{P@\ngJX@@eMS@]XLdwrCngo{P@\ngJX@@eMS@]XLeWrCmgo{P@\ngJX@@eMS@]XLeWrCngo{P@\ngJX@@eMU@]TLTyK_HNBP`\ngJX@@eMU@]TLTyK_HNBPdd\\[P@\ngJX@@eMU@]TLTyK_HNBPm@\ngJX@@eMU@]TLTyK_KvBP`\ngJX@@eMU@]TLTzM_HNBP`\ngJX@@eMU@]TLTzM_HNBPm@\ngJX@@eMU@]TLUYK_HNBP`\ngJX@@eMU@]TLUYK_HNBPm@\ngJX@@eMU@]TLUZM_HNBPm@\ngJX@@eMURH]TLTyK_HNB__m@<\ngJX@@eMURH]TLTyK_HNB__m@>\ngJX@@eMURH]TLTyKgAbf~P\\Da@<\ngJX@@eMURH]TLTyKgAbf~P\\Da@>\ngJX@@eMURH]TLTyKgAbf~P\\DaZ@<\ngJX@@eMURH]TLTyKgAbf~P\\DaZ@>\ngJX@@eMURH]TLTyKgAbf~WlDa@<\ngJX@@eMURH]TLTyM_HNBP`<\ngJX@@eMURH]TLTyM_HNBP`>\ngJX@@eMURH]TLTyM_HNBPm@<\ngJX@@eMURH]TLTyM_HNBPm@>\ngJX@@eMURH]TLTyMgAbf~P\\Da@<\ngJX@@eMURH]TLTyMgAbf~P\\Da@>\ngJX@@eMURH]TLTyMgAbf~P\\DaZ@<\ngJX@@eMURH]TLTyMgAbf~P\\DaZ@>\ngJX@@eMURH]TLTzK_HNB__m@<\ngJX@@eMURH]TLTzK_HNB__m@>\ngJX@@eMURH]TLTzKgAcf~P\\D~@<\ngJX@@eMURH]TLTzKgAcf~P\\D~@>\ngJX@@eMURH]TLTzMgAbf~P\\Da@<\ngJX@@eMURH]TLUYK_HNB__m@>\ngJX@@eMURH]TLUYKgAbf~P\\Da@<\ngJX@@eMURH]TLUYKgAbf~P\\Da@>\ngJX@@eMURH]TLUYKgAbf~P\\DaZ@<\ngJX@@eMURH]TLUYKgAbf~P\\DaZ@>\ngJX@@eMURH]TLUYM_HNBPm@<\ngJX@@eMURH]TLUYM_HNBPm@>\ngJX@@eMURH]TLUYMgAbf~P\\DaZ@<\ngJX@@eMURH]TLUYMgAbf~P\\DaZ@>\ngJX@@eMURH]TLUZK_HNB__m@<\ngJX@@eMURH]TLUZK_HNB__m@>\ngJX@@eST`]TLTyK]HNC~t@=\ngJX@@eST`]TLTyK_HNB^m@=\ngJX@@eST`]TLTyKgASfzP]{}h@\ngJX@@eST`]TLTyKgASf~P]x}Z@\ngJX@@eST`]TLTyKgAcfzP\\G}h@\ngJX@@eST`]TLTyKgAcf~P\\D}Z@\ngJX@@eST`]TLTzK]HNC~t@\ngJX@@eST`]TLTzK_HNB^m@\ngJX@@eST`]TLTzKgASf~P\\D}Z@\ngJX@@eST`]TLTzKgAcfzP\\G}h@\ngJX@@eST`]TLTzKgAcf~P\\D}Z@\ngJX@@eST`]XTRwRwnm@\ngJX@@eST`]XTRwR{nm@=\ngJX@@eSU@]TLTyK_HNBP`\ngJX@@eSU@]TLTyK_HNBPdhT[P@=\ngJX@@eSU@]TLTyK_HNBPm@=\ngJX@@eSU@]TLTyK_HNB_@\ngJX@@eSU@]TLTyK_HNB__m@=\ngJX@@eSU@]TLTyK_HN|Pm@\ngJX@@eSU@]TLTyKdabgM|`xIB\ngJX@@eSU@]TLTyKdabgM|`xIC~t@=\ngJX@@eSU@]TLTyKdabgM|`xI|\ngJX@@eSU@]TLTyKgASf~P]xaZ@\ngJX@@eSU@]TLTyKgAcf~P\\DaZ@\ngJX@@eSU@]TLTyKgAcf~P\\D~Z@\ngJX@@eSU@]TLTyKgAcf~P]xaZ@\ngJX@@eSU@]TLTyM_HNBP`\ngJX@@eSU@]TLTyM_HNBPdhT[P@=\ngJX@@eSU@]TLTyM_HNBPm@=\ngJX@@eSU@]TLTyM_HN|Pm@\ngJX@@eSU@]TLTyMgASf~P]xaZ@\ngJX@@eSU@]TLTyMgAcf~P\\DaZ@\ngJX@@eSU@]TLTzK_HNBPm@\ngJX@@eSU@]TLTzKgASf~P\\DaZ@\ngJX@@eSU@]TLTzKgAcf~P\\DaZ@\ngJX@@eSU@]TLTzKgAcf~P\\D~Z@\ngJX@@eSU@]TLTzM_HNBPm@\ngJX@@eSU@]TLTzMgASf~P\\DaZ@\ngJX@@eSU@]TLTzMgAcf~P\\DaZ@\ngJX@@eSU@]TLUZK_HNBP`\ngJX@@eSU@]TLUZK_HNBPm@=\ngJX@@eSU@]TLUZM_HNBPm@=\ngJX@@eSU@]XTRwrwmdO{P@=\ngJX@@eSU@]XTRwrwmgw{P@=\ngJX@@eSU@]XTRwrwndO{P@\ngJX@@eSU@]XTRwrwngw{P@\ngJX@@eSU@]XTRwr{ndO{P@=\ngJX@@eSU@]XTRypTyoeo]H_v`@\ngJX@@eSU@]XTRypXyoew]H_v`@\ngJX@@eSU@]XTSWrwmdO{P@=\ngJX@@eSU@]XTSWrwndO{P@\ngJX@@eSU@]XTSWr{ndO{P@=\ngJX@@eSU@]XTSYpXyoew]H_v`@\ngJX@@eSUPH]TLTyK_HN|P`<\ngJX@@eSUPH]TLTyK_HN|P`>\ngJX@@eSUPH]TLTyKgASf~P]xa@<\ngJX@@eSUPH]TLTyKgASf~P]xa@>\ngJX@@eSUPH]TLTyKgAcf~P\\Da@<\ngJX@@eSUPH]TLTyKgAcf~P\\Da@>\ngJX@@eSUPH]TLTyKgAcf~P\\D~@<\ngJX@@eSUPH]TLTyKgAcf~P\\D~@>\ngJX@@eSUPH]TLTyKgAcf~P]xa@<\ngJX@@eSUPH]TLTyKgAcf~P]xa@>\ngJX@@eSUPH]TLTyM_HN|P`<\ngJX@@eSUPH]TLTyM_HN|P`>\ngJX@@eSUPH]TLTyMgAcf~P\\Da@<\ngJX@@eSUPH]TLTyMgAcf~P\\Da@>\ngJX@@eSUPH]TLTzK_HNBP`<\ngJX@@eSUPH]TLTzK_HNBP`>\ngJX@@eSUPH]TLTzKdabgM|`xIB<\ngJX@@eSUPH]TLTzKgASf~P\\Da@<\ngJX@@eSUPH]TLTzKgASf~P\\Da@>\ngJX@@eSUPH]TLTzKgAcf~P\\Da@<\ngJX@@eSUPH]TLTzKgAcf~P\\Da@>\ngJX@@eSUPH]TLTzM_HNBP`<\ngJX@@eSUPH]TLTzM_HNBP`>\ngJX@@eSUPH]TLTzMgAcf~P\\Da@<\ngJX@@eSUPH]TLTzMgAcf~P\\Da@>\ngJX@@eSUPH]TLUYK_HN|P`<\ngJX@@eSUPH]TLUYK_HN|P`>\ngJX@@eSUPH]TLUYM_HN|P`<\ngJX@@eSUPH]TLUYM_HN|P`>\ngJX@@e\\u@]TLTyK]XIC~t@\ngJX@@e\\u@]TLTyK_SnBPm@\ngJX@@e\\u@]TLTzM]XIC~t@\ngJX@@e\\uQH]TLTyK]XI}~t@>\ngJX@@e\\uQH]TLTyKgAbf~g\\DaZ@<\ngJX@@e\\uQH]TLTyKgAbf~g\\DaZ@>\ngJX@@e\\uQH]TLTyM]XIC~t@<\ngJX@@e\\uQH]TLTyM]XIC~t@>\ngJX@@e\\uQH]TLTyMgAbf~g\\DaZ@<\ngJX@@e\\uQH]TLTyMgAbf~g\\DaZ@>\ngJXA@IRVX@NiFzvst\ngJXA@IRVX@NiGNCGM|N{Yz\ngJXA@IRVh@NiFzvsl=\ngJXA@IRVh@NiFzvst\ngJXA@IRVh@NiFzwSt=\ngJXA@IRVh@NiF~Gml{@=\ngJXA@IRVh@NiF~Gml}@\ngJXA@IRVh@NiF~Gmt}@=\ngJXA@IRVh@NiGNCEMungh\ngJXA@IRVh@NiGNCEM|O[iz\ngJXA@IRVh@NiGNCGMumgh\ngJXA@IRVi`NcENRwaB\ngJXA@IRVi`NcENRypXynmta@\ngJXA@IRVi`NcENRypXyoBD\ngJXA@IRVj`NcENRwVBP`\ngJXA@IRVjhdNcENRypXinlDa@<\ngJXA@IRVjhdNcENRypXinlDa@>\ngJXA@IRVjhdNcENRypXioa{AHP<\ngJXA@IRVjhdNcENSWVBP`>\ngJXA@IRVjhdNcENSYpXinlDa@<\ngJXA@IRYHPNddmtN{X\ngJXA@IRYZPNcENRwP{o@\ngJXA@IRYZPNcENRwVB^`\ngJXA@IRYZPNcENRwp{`gh\ngJXA@IRYZPNcENRypXyoawAOP\ngJXA@IRYZPNcENRytTyoawAOP\ngJXA@IRYjiDNcENRwVBP`<\ngJXA@IRYjiDNcENRwVBP`>\ngJXA@IRYjiDNcENRwVB_@<\ngJXA@IRYjiDNcENRwVB_@>\ngJXA@IRYjiDNcENRyHXis]XIB>\ngJXA@IRYjiDNcENRyHXis][qB<\ngJXA@IRYjiDNcENRyHXis_CvBP`<\ngJXA@IRYjiDNcENRyHXis_CvBP`>\ngJXA@IRYjiDNcENRypXynlDa@<\ngJXA@IRYjiDNcENRypXynlDa@>\ngJXA@IRYjiDNcENRytTynlDa@<\ngJXA@IRYjiDNcENRytTynlDa@>\ngJXA@IRYjiDNcENSWVBP`<\ngJXA@IRYjiDNcENSWVBP`>\ngJXA@IRYjiDNcENSYpXynlDa@<\ngJXA@IRYjiDNcENSYtTynlDa@>\ngJXA@IRYjiDNcENbwVBP`>\ngJXA@IRYjiDNcENbypXynlDa@<\ngJXA@IRYjiDNcENbypXynlDa@>\ngJXA@IR[B`Nedm|MkYB\ngJXA@IR[B`Nedm|MkiB\ngJXA@IRfd@NdEMumg_{P@=\ngJXA@IRfd@NdEMumgo{P@\ngJXA@IRfd@NdEM|n{Yw~t@=\ngJXA@IRfd@NdEM|n{Y{~t@\ngJXA@IRfd@NdEM|n{i{~t@=\ngJXA@IRfd@NdEN\\FN[y]vsw}h@\ngJXA@IRfe`NjFJ\\es`qS]KiC~t@\ngJXA@IRfh@NdEM|`{Yv=\ngJXA@IRfj`NjFJ\\eodGAHP\ngJXA@IRfjiDNjFJ\\es`qS_HNBP`<\ngJXA@IRfjiDNjFJ\\es`qS_HNBP`>\ngJXA@IRfjiDNjFJ\\fodGAHP<\ngJXA@IRfjiDNjFJ\\fodGAHP>\ngJXA@IRij`NjFJ\\eodGAHP\ngJXA@IRij`NjFJ\\eodGAO`\ngJXA@IRij`NjFJ\\erPqSf~P\\Da@\ngJXA@IRij`NjFJ\\erPqSf~P\\D~@\ngJXA@IRij`NjFJ\\fodGAHP\ngJXA@IRijhDNjFJ\\es`qs_HNBP`<\ngJXA@IRijhDNjFJ\\es`qs_HNBP`>\ngJXA@IRijhDNjFJ\\fs`qs_HNBP`<\ngJXA@IRijhDNjFJ\\fs`qs_HNBP`>\ngJXA@IRkZ`NjFJ\\enlDaZ@\ngJXA@IRkZ`NjFJ\\eoiwAH_v`@\ngJXA@IRkZ`NjFJ\\es`qs]XIC~t@\ngJXA@IRkZ`NjFJ\\es`qs_SnBPm@\ngJXA@IRkZ`NjFJ\\eshis]XIC~t@\ngJXA@IRkZ`NjFJ\\eshis_SnBPm@\ngJXA@IRkZ`NjFJ\\fnlDaZ@\ngJXA@IRkZ`NjFJ\\foiwAH_v`@\ngJXA@IRkZ`NjFJ]EoiwAH_v`@\ngJXA@IRkZ`NjFJ]Es`qs]XIC~t@\ngJXA@IRkZ`NlII[z[vrG}h@\ngJXA@IRkZ`NlII[z[wRG}h@\ngJXA@IRkZ`NlII[z]vrG}h@\ngJXA@IRkZ`NlII[z]wRG}h@\ngJXA@IRkZ`NlIIkz[vrG}h@\ngJXA@IRkZ`NlIIkz[wRG}h@\ngJXA@IRkZ`NlIIkz]vrG}h@\ngJXA@IRkZ`NlIIkz]wRG}h@\ngJXA@IRnZ`NjFJ\\eoiwAH_v`@\ngJXA@IRnZhdNjFJ\\fs`qS_SnBPm@<\ngJXA@IRnZhdNjFJ\\fs`qS_SnBPm@>\ngJXA@IrRDJ@zVRwtvmdO{P@=\ngJXA@IrRDJ@zVRwtvndO{P@\ngJXA@IrRDJ@zVRwtzndO{P@=\ngJXA@IrRDJ@zVRypTyoiu]H_v`@\ngJXA@IrRDJ@zVRytTyoim]H_v`@\ngJXA@IrRDJ@zVSWtvmdO{P@=\ngJXA@IrRDJ@zVSWtvndO{P@\ngJXA@NRfh@NdEM|`{Yw~t@=\ngJXA@NRfi`NjFJles`qS_HNzPm@\ngJXAAnR[f`NmKIkx[WRD\ngJXDB@cABTuRAu`qS^HH\ngJXDB@cABTuRAu`rS_HNv]`\ngJXDD@bABUuTAtPirVzpRG}h`=\ngJXDHOA^BS]TAuhyK^DH\ngJXDHOA^BS]TAuhyK_Cr|PmH=\ngJXDL@aABSKTAuhiK^DH\ngJXDL@aABS[TAuhyK^DO{S@\ngJXDL@bABUu@Au@wVv]`\ngJXH@jAJZ`@z`[k[Nv`@=\ngJXH@jAJZ`@z`[k]OP=\ngJXH@jAJZ`@z`\\xLTwVz^`\ngJXH@jAJZ`@z`\\xL\\wVv^m@\ngJXH@jAJzj@zhYIr[NCEM}@xIC~t@>\ngJXH@jAJzj@zhYIt[NCEM}@xIB>\ngJXH@jAJzj@zhYIt[NCEM}@xIC~t@>\ngJXHAJAIfi@zLTyKgAcf|pP>\ngJXHAJAIfi@zLTzKgAcf|pP>\ngJXHAjAJfi@zHXiKgASf|P_v`@\ngJXHAjAJfi@zHXiKgAcfzPSw}h@\ngJXHAjAJfi@zHXiKgAcf|P_v`@\ngJXHAjAJfi@zHXjK]HI{~t@\ngJXHAjAJfj@zHXiKgAcf~P]xaZ@\ngJXHAjAJfj`PzHXjK]HIB<\ngJXHAjAJfj`PzHXjK]HIB>\ngJXHB@aIfe@zTdwPwm`\ngJXHB@aInZ@zTlwPvm`\ngJXHB@aInZ@zTlwPvn`\ngJXHB@aInZ@zTlytTynam]@\ngJXHBOAJfj@zHXis]HNB\ngJXHBOAJfj@zHXisdabgMt`xH\ngJXHBOAJfj@zHXju]HNB\ngJXHBOAJfj`PzHXiu]HNB<\ngJXHBOAJfj`PzHXiu]HNB>\ngJXHD@aIZjbPzLTyKgAbfzpRD<\ngJXHD@aIZjbPzLTyKgAbfzpRD>\ngJXHD@aIej@zLTyK]XIC~tP\ngJXHD@aIej@zLTyKgQSfzpRG}h`\ngJXHD@aIej@zLTyM]XIC~tP\ngJXHD@aIej@zLTyMgQSfzpRG}h`\ngJXHD@aIej@zLTzK]XIC~tP\ngJXHD@aIej@zLTzKgQSfzpRG}h`\ngJXHD@aIej@zLTzM]XIC~tP\ngJXHD@aIfe@ztdenao]ZH\ngJXHD@aIfe@ztdeshis_C^z^mD\ngJXHD@aIff@zLTyK][iC~tP\ngJXHD@aIff@zLTyM][iC~tP\ngJXHD@aIff@ztdeoao]H_vb@\ngJXHD@aIff@ztdfoao]H_vb@\ngJXHD@aIff@ztdfshis_C^zPmD\ngJXHD@aImi@zt\\eshir\ngJXHD@aImj@zt\\eshis^DH\ngJXHD@aInZ@ztleoam[HP\ngJXHD@aInZ@ztlfoam[HP\ngJXHDHaIfe@zLTyKgQSf|O_vb@\ngJXHDOAIZj@zLTyK]XIB\ngJXHDOAIZj@zLTyK_CvBP`\ngJXHDOAIZj@zLTyKdabgMu`dH\ngJXHDOAIZj@zLTyKdabgM|OXIB\ngJXHDOAIZj@zLTyM]XIC~tP\ngJXHDOAIfjdPzLTzM_CvBPmD>\ngJXHH@aIYj@zLTyK]XIC~t`\ngJXHH@aIZ`@zd[x^vso}i@=\ngJXHH@aIZ`@zd[x^vsw}i@\ngJXHH@aIZ`@zd[x^wSw}i@=\ngJXHH@aIZ`@zd\\xL\\wp}mgo{R@\ngJXHH@aIZf@zLTyK_CvzPmH\ngJXHH@aIZf@zLTyKgAbf~GmtaZP\ngJXHH@aIZf@zTUWp}ngo{R@\ngJXHH@aIZj@zLTyK]XIC~t`\ngJXHH@aIZj@zLTyK_CvBPmH\ngJXHH@aIZj@zLTzM]XIC~t`\ngJXHH@aIZj@zLTzM_CvBPmH\ngJXHH@aIZjbPzLTyK]XI}~t`<\ngJXHH@aIZjbPzLTyK]XI}~t`>\ngJXHH@aIZjbPzLTyK_CvB__mH<\ngJXHH@aIZjbPzLTyK_CvB__mH>\ngJXHH@aIZjbPzLTyKgAbf~GlDaZP<\ngJXHH@aIZjbPzLTyKgAbf~GlDaZP>\ngJXHH@aIZjbPzLTyM]XIC~t`<\ngJXHH@aIZjbPzLTyM]XIC~t`>\ngJXHH@aIZjbPzLTyM_CvBPmH<\ngJXHH@aIZjbPzLTyM_CvBPmH>\ngJXHH@aIZjbPzLTzK]XI}~t`<\ngJXHH@aIZjbPzLTzK_CvB__mH<\ngJXHH@aIZjbPzLTzK_CvB__mH>\ngJXHH@aIfi@zLTyK_CvB^mH\ngJXHH@aIfi@zLTyKgQSfzGlG}i@\ngJXHH@aIfi@zLTyKgQSf~GlD}ZP\ngJXHH@aIfj@zLTyK_CvBPmH\ngJXHH@aIfj@zLTyKgAcf~GlDaZP\ngJXHH@aIfj@zLTyKgQSf~GlDaZP\ngJXHH@aIfj@zLTyKgQSf~GlD~ZP\ngJXHH@aIfj@zLTyKgQSf~GmxaZP\ngJXHH@aIfj@zLTyM_CvBPmH\ngJXHH@aIfj@zLTyMgQSf~GlDaZP\ngJXHH@aIfj@zLTzK_CvBPmH\ngJXHH@aIfj@zLTzKgQSf~GlDaZP\ngJXHH@aIfj@zLTzKgQSf~GlD~ZP\ngJXHH@aIfj@zLTzM_CvBPmH\ngJXHH@aJz`@z`[k[OP\ngJXHH@aJz`@z`\\xL\\wVv^`\ngJXHHGAIZ`@zd[x^vsw}i@\ngJXHHGAIZ`@zd[x^wSt=\ngJXHHGAIfj@zLTyKgQSf~GlDaZP\ngJXHHGAIfjdPzLTzK_CvB_@<\ngJXHHGAIfjdPzLTzK_CvB_@>\ngJXHHOAIY`@zd[k[Nvd@=\ngJXHHOAIY`@zd[k[O_vd@\ngJXHHOAIY`@zd[k]O_vd@=\ngJXHHOAIZ`@zd[k[O_vd@\ngJXHHOAIZ`@zd[x^vso}i@=\ngJXHHOAIZ`@zd[x^vsw}i@\ngJXHHOAIZ`@zd[x^wSw}i@=\ngJXHHOAIZ`@zd\\xL\\wp}mgo{R@\ngJXHHOAIZj@zLTyK_CvBPmH\ngJXHHOAIZjbPzLTyM_CvBPmH<\ngJXHHOAIZjbPzLTyM_CvBPmH>\ngJXHHOAIfj@zLTyK_CvBPmH\ngJXHHOAIfj@zLTyKgAcf~GlDaZP\ngJXHHOAIfj@zLTyKgAcf~GlD~ZP\ngJXHHOAIfj@zLTyKgQSf~GlDaZP\ngJXHHOAIfj@zLTyM_CvBPmH\ngJXHHOAIfj@zLTyMgAcf~GlDaZP\ngJXHHOAIfj@zLTzK]XIC~t`\ngJXHHOAIfjdPzLTyK]XIB<\ngJXHHOAIfjdPzLTyK]XIB>\ngJXHHOAIfjdPzLTyK_CvBP`>\ngJXHHOAJfj@zhXjtZ~P\\DaZP\ngJXHL@aIZ`@zd[k[Np\ngJXHL@aIZ`@zd[k[OP\ngJXHL@aIZf@ztTfs`qS^DH\ngJXHL@aIZf@ztTfs`qs_CvzP`\ngJXHL@aIZjb`ztTeoBD<\ngJXHL@aIZjb`ztTeoBD>\ngJXHL@aJZ`@zPTwrCmgX\ngJXHL@aJZ`@zPTwrCmgh\ngJXHL@aJZ`@zPTwrCngX\ngJXHL@aJZ`@zPTypXyodG[OP\ngJXHL@aJZ`@zPUWrCmgX\ngJXHL@aJZ`@zPUWrCmgh\ngJXHL@aJZ`@zPUYpXyodG[OP\ngJXHL@aJZf@zHXiK]HIB\ngJXHL@aJZf@zpYIodG[OP\ngJXHL@aJZf@zpYIs`qs_HNv^`\ngJXHL@aJZi@zHXiK]HIz\ngJXHL@aJZi@zHXjK]HIz\ngJXHL@aJZi@zpYIodG[OP\ngJXHL@aJZjdPzHXjMgAbfzPRD<\ngJXHL@aJZjdPzHXjMgAbfzPRD>\ngJXHLDQJZ`@zPTwrCmgX\ngJXHLJqIZjb`ztTeoBD<\ngJXHLLQIZ`@zd[k[OP\ngJXHLLQIZ`@zd[k]OP\ngJXHLLQIZjb`ztTeoBD<\ngJXHLOAIZ`@zd[x^vsl\ngJXHLOAIZi@zTUWp}mgX\ngJXHaj@SnRkZ`NbFJRwV|Pm@\ngJXIB@`rdwM@]JV[h[Vp\ngJXID@aRdwL`]ZVRwPvn`\ngJXIDOARdmU@]FJ\\eoa{AHP\ngJXIH@b\\dmP@]RM|O[Yw~t`=\ngJXIHOBRdlp@]RMungo{R@=\ngJXIHOBRdlu@]FJ\\enlDaZP\ngJXIHOBRdru@]FJ\\enlDaZP\ngJXIL@cRdmP@]RMumgX\ngJXIL@cRdmUQP]ZJRwaB<\ngJXIL@cRdmUQP]ZJRwaB>\ngJXLB@bAFBDkjdCiAU][Yv\ngJXLL@aAABDfVhCiQR\ngJX`BDdru@]ZJ\\wfB\ngJX`BDdru@]ZJ\\wf|\ngJX`BDdru@]ZJ]WfB\ngJX`BDdvu@]JNP\ngJX`BDdwU@]JNP\ngJX`BLeMT`]XLTwbB\ngJX`DBdru@]ZJ\\wfC~tP\ngJX`DBdru@]ZJ\\wf}~tP\ngJX`DBdru@]ZJ]WfC~tP\ngJX`DBdvu@]JNP\ngJX`DBdvu@]JN\\zJ\\`\ngJX`DBdwM@]JV[h[Vp\ngJX`LDdru@]ZJRwaB\ngJX`LDdru@]ZJRwa|\ngJX`LDdru@]ZJRytTyoBD\ngJX`LDdru@]ZJRytTyoCx\ngJX`LDdru@]ZJSWaB\ngJX`LDdru@]ZJSYtTyoBD\ngJX`LDdvt`]ZNRwa{~tp\ngJX`LDdvu@]ZNRwaC~tp\ngJX`LDdvu@]ZNRwa}~tp\ngJX`LDdvu@]ZNRytTyoBG}i`\ngJX`LDdvu@]ZNRytTyoC{}i`\ngJX`LDdvu@]ZNSWaC~tp\ngJX`LDdvu@]ZNSYtTyoBG}i`\ngJX`bDnLiMmPGRcd\ngJX`bDnLiMmPGRcf|O`\ngJX`hEIWIMmHGVcdmx^mH\ngJX`hEIWIMmHGVcdo{R@\ngJX`hEIWIMmPGVcdmxPmH\ngJX`hEIWIMmPGVcdmx__mH\ngJXaBDYR[Z`NeGH\ngJXaBDYR[Z`NeGMx_@\ngJXaBDnR[Z`NeGH\ngJXaLDnR[Z`NmGI[paZX\ngJXhMDOAJfj`PzpXfoBD<\ngJXhMDOAJfj`PzpXfoBD>\ngJXhMDOAJfj`PzpXfs`qs^DH<\ngJXhMDOAJfj`PzpXfs`qs^DH>\ngJY@BDfVhCkQSf|pP\ngJY@BDfVhCkQSj|pP\ngJY@BDfZTCiRS]C^v\ngJY@BDfZjQCkQSf|pP<\ngJY@BDfZjQCkQSf|pP>\ngJY@BDfZjQCkQSgNCGMy``<\ngJY@BDfZjQCkQSgNCGMy``>\ngJY@BDfZjQCkQSgNbgMy``<\ngJY@BDfZjQCkQSgNbgMy``>\ngJY@BDfZjQCkQSj|pP<\ngJY@BDfZjQCkQSj|pP>\ngJY@BDfZjQCkQSkNCGMy``>\ngJY@BDfyhCiRs]CZv\ngJY@DDefhChqSdmu`dO{Q@=\ngJY@DDefhChqSduu`dO{Q@\ngJY@DDejhChqSdmu`dO{Q@=\ngJY@DDejhChqSdn\\FN[kAOovb@\ngJY@DDejhChqSduu`dO{Q@\ngJY@DDejhChqSdv\\FJ[kAH_vb@\ngJY@DDejhCiQU][Y{~tP\ngJY@DDejjIChqSdn\\FJ[kAHP<\ngJY@DDejjIChqSdn\\FJ[kAHP>\ngJY@DDfVdChqSdn]EN[kAO_vb@\ngJY@DDfVdChqShmu`go{Q@\ngJY@DDfVdChqShn]EN[kAO_vb@\ngJY@DDfVhChqSdmu`dO{Q@\ngJY@DDfVhChqSdmu`gw{Q@\ngJY@DDfVhChqSdmuoDO{Q@\ngJY@DDfVhChqSdmuoGw{Q@\ngJY@DDfVhChqSdn]EN[kAH_vb@\ngJY@DDfVhChqSdn]EN[kAOovb@\ngJY@DDfVhChqSdn]EN[k^H_vb@\ngJY@DDfVhChqSdn]EN[k^Oovb@\ngJY@DDfVhChqSduu`dO{Q@\ngJY@DDfVhChqSduuoDO{Q@\ngJY@DDfVhChqSdv]EN[kAH_vb@\ngJY@DDfVhChqSdv]EN[k^H_vb@\ngJY@DDfVhChqShmu`dO{Q@\ngJY@DDfVhChqShmu`gw{Q@\ngJY@DDfVhChqShn]EN[kAH_vb@\ngJY@DDfVhChqShn]EN[kAOovb@\ngJY@DDfVhChqShuu`dO{Q@\ngJY@DDfVhChqShv]EN[kAH_vb@\ngJY@DDfZTCkRRVzF}w}h`\ngJY@DDfZXChqSdmundO{Q@\ngJY@DDfZXChqSduundO{Q@\ngJY@DDfZjQChqSdmu`dO{Q@<\ngJY@DDfZjQChqSdmu`dO{Q@>\ngJY@DDfZjQChqSdn]EN[k^H_vb@<\ngJY@DDfZjQChqSduu`dO{Q@<\ngJY@DDfZjQChqShuu`dO{Q@<\ngJY@DDfZjQChqShuu`dO{Q@>\ngJY@DDfvdCkQrT\ngJY@DDfvdCkQrV|OP\ngJY@DDfvdCkQrWNbgH\ngJY@DDfvdCkQrWNbgMx^`\ngJY@DDfvhCkQrV|HP\ngJY@DDfvhCkQrV|O`\ngJY@DDfvhCkQrWNbgMxP`\ngJY@DDfvhCkQrWNbgMx_@\ngJY@DDfvhCkQrZ|HP\ngJY@DDfvhCkQr[NbgMxP`\ngJY@DDfydCkRrVzFul\ngJY@DDfyhCkRrV~Fula@\ngJY@DDfyhCkRrZ~Fula@\ngJY@DDfzjQCkQrWNBgMxP`<\ngJY@DDfzjQCkQrWNBgMxP`>\ngJY@DDfzjQCkQrWNbgMxP`<\ngJY@DDfzjQCkQrWNbgMxP`>\ngJY@HDef@CjQnmt}ZP=\ngJY@HDfZjQChqSdn]EN[kAHP<\ngJY@HDfZjQChqSdn]EN[kAHP>\ngJY@HDfZjQChqSduu`dH<\ngJY@HDfZjQChqSduu`dH>\ngJY@HDfZjQChqShn\\FN[kAHP<\ngJY@HDijhCjabgI[yApRD\ngJY@HDijhCjabgI[yApRG}i@=\ngJY@HDijhCjabgI[yApS{}i@\ngJY@HDijhCjabgI[yAwcx\ngJY@HDijhCjabgI\\xLTwrC`dO{R@\ngJY@HDijhCjabgIkyApRG}i@\ngJY@HDijjQCjabgI[yApSx<\ngJY@HDijjQCjabgI[yApSx>\ngJY@HDijjQCjabgI\\xLTwrC`dH<\ngJY@HDijjQCjabgI\\xLTwrC`dH>\ngJY@HDijjQCjabgIlxLTwrC`dH<\ngJY@HDijjQCjabgIlxLTwrC`dH>\ngJY@HDkjhChaSdmu`dH\ngJY@HDkjhChaSdnRFJ\\wVBP`\ngJY@HDkjjIChaSdn\\FJ[kAHP<\ngJY@HDkjjIChaSdn\\FJ[kAHP>\ngJY@HDkjjIChaSduu`dH<\ngJY@HDkjjIChaSduu`dH>\ngJY@HDkjjIChaSdv\\FJ[kAHP<\ngJY@HDkjjIChaSdv\\FJ[kAHP>\ngJY@LDef@CjQnml{@\ngJY@LDefdCiQU][Yv\ngJY@LDefdCiQU][Yz\ngJY@LDefdCiQU][iv\ngJY@LDefdCiQU][iz\ngJY@LDej@CjQnml{@\ngJY@LDejXCkQRV|HP\ngJY@LDejdCiQU][Yv\ngJY@LDejdCiQU][Yz\ngJY@LDejdCiQU][iz\ngJY@LDejdCiQUgAbfzwSl\ngJY@LDejjJCkQRV|HP<\ngJY@LDejjJCkQRV|HP>\ngJY@LDejjJCkQRWNCEMxP`<\ngJY@LDejjJCkQRWNCEMxP`>\ngJY@LDejjJCkQRWNCGMxP`<\ngJY@LDejjJCkQRWNCGMxP`>\ngJY@LDejjJCkQRZ|HP<\ngJY@LDejjJCkQRZ|HP>\ngJY@LDejjJCkQR[NCEMxP`<\ngJY@LDejjJCkQR[NCEMxP`>\ngJY@LDij@CiAS_HNv]`\ngJY@LDij@CiAS_HNv^`\ngJY@LDij@CiASgAcf~P]l}@\ngJY@LDij@CiAU_HNv]`\ngJY@LDij@CiAU_HNv^`\ngJY@LDij@CiAUgAcf~P]l}@\ngJY@LDijXChabdmt`dH\ngJY@LDijXChabdmt`gp\ngJY@LDijXChabdn\\FJ[iAHP\ngJY@LDijXChabdut`dH\ngJY@LDijXChabdv\\FJ[iAHP\ngJY@LDijXChabdv\\FN[yAwRD\ngJY@LDijXChabhn\\FN[yAwRD\ngJY@LDijXCkAdf~P]l}@\ngJY@LDijXCkAdgNCGM|`{Yz\ngJY@LDijXCkAdj~P]l}@\ngJY@LDijdChabdmx``\ngJY@LDijdChabdn\\FN[iAOP\ngJY@LDijdChabdn\\FN[i^OP\ngJY@LDijdChabhn\\FN[iAOP\ngJY@LDijdCkAdf~P]t{@\ngJY@LDijdCkAdf~P]t}@\ngJY@LDijdCkAdgNCGM|`{Yz\ngJY@LDijdCkAdgNCGM|`{iz\ngJY@LDijdCkAdj~P]t}@\ngJY@LDijjQChabdmt`dH<\ngJY@LDijjQChabdmt`dH>\ngJY@LDijjQChabdn\\FJ[iAHP<\ngJY@LDijjQChabdn\\FJ[iAHP>\ngJY@LDijjQChabdn\\FN[iAHP<\ngJY@LDijjQChabdn\\FN[iAHP>\ngJY@LDijjQChabdut`dH<\ngJY@LDijjQChabdut`dH>\ngJY@LDijjQChabdv\\FJ[iAHP<\ngJY@LDijjQChabdv\\FJ[iAHP>\ngJY@LDijjQChabhv\\FJ[iAHP<\ngJY@LDijjQChabhv\\FJ[iAHP>\ngJY@dAreInZ@zt\\eshis^DH\ngJYABCJSKTAuhiu^XH\ngJYABCJSMUHauhis]XI|<\ngJYABCJSMUHauhis^XH<\ngJYABCJSMUHauhis^XH>\ngJYABCJSMUHauhiu^XH<\ngJYABCJSMUHauhiu^XH>\ngJYABCJS\\tAtiYnam[@\ngJYADArSMLAtXirWNbgMxPmD\ngJYADEJS[RAuhyKgQSf|OP\ngJYALMJRuUEAuhiK^DH<\ngJYALMJRuUEAuhiK^DH>\ngJYALMJTu@At`iodG[Np\ngJYDC`DPHRni`NdEH\ngJYHC`DIKTpGRbd\ngJYHC`DIKTpGRbgNCGH\ngJYHC`DISTpGVCEUx``\ngJYHC`DISUHGVCIM|`{Yv\ngJYHC`VIKTpGRbf|G`\ngJYHCaDIKTpGRbd\ngJYHCaxIKTpGRbf|G`\ngJYHDPDIMsPGRefzFul\ngJYHE@DIUmLBGQBgI[k^O_vb@<\ngJYHE@DIUmTBGQBgI[k^H_vb@<\ngJYHE@DIUmTBGQBgI[k^H_vb@>\ngJYHE@DIUmTBGQBgI[k^Oovb@<\ngJYHE@DIUmTBGQBgI[k^Oovb@>\ngJYHE@DIUmTBGQBgQ[kAH_vb@>\ngJYHI`DIKTpGVbdmtODO{R@\ngJYHI`DIKTpGVbdutODO{R@\ngJYHIaxIKTpGVbdmtOGw{R@\ngJYHIaxIKTpGVbdutODO{R@\ngJYHLEPISTpGVCDv\\FJ[i^HP\ngJYHL`DILmPGVbdmxP`\ngJYHL`DILmPGVbduxP`\ngJYHL`DILtpGVbdmxP`\ngJYHL`DILtpGVddm|M{YB\ngJYHL`DIMmPGVcdmxPmL\ngJYHL`DIMmPGVcduxPmL\ngJYHM@DIKT@GTc_Cvv^`\ngJYHlEPKmJTuLAu`qMgAbf~Wmta@\ngJY`BEdfVhCiQR\ngJY`LDTfvhCiQs~tp\ngJY`hEiNyIej@ztTeoBG}i@\ngJYieLPxAeIyIZf@zTTmD\ngJ\\@@bdrQ@]QMtM{_{Q@\ngJ\\@@bdrQ@]QMtM{o{Q@\ngJ\\@@bdru@]JR[h[w_vb@\ngJ\\@@bdru@]ZJ]YpXyoLG}h`\ngJ\\@@bdru@]ZJ]YtTynawAZH\ngJ\\@@bdvt`]JV[h[Vp\ngJ\\@@bdvt`]JV[h[WP\ngJ\\@@bdvu@]JNP\ngJ\\@@bdvu@]JV[h[Vp\ngJ\\@@bdvu@]JV[h[WP\ngJ\\@@ldru@]ZJRwPzPmD\ngJ\\@@ldru@]ZJRwaC~tP\ngJ\\@@ldru@]ZJRypXyoBG}h`\ngJ\\@@ldru@]ZJRytTyoBG}h`\ngJ\\@@ldru@]ZJSWPzPmD\ngJ\\@@ldru@]ZJSWaC~tP\ngJ\\@@ldru@]ZRRwpwmdO{Q@\ngJ\\@@ldru@]ZRRwpwndO{Q@\ngJ\\@@ldru@]ZRRytTyoao]H_vb@\ngJ\\@@ldru@]ZRSWpwmdO{Q@\ngJ\\@@ldru@]ZRSWpwndO{Q@\ngJ\\@@ldvE@]KI[x[VrG}i`=\ngJ\\@@ldvE@]KI[x[Vs{}i`=\ngJ\\@@ldvE@]KIkx[VrG}i`=\ngJ\\@ABeWU@]HR[j[vv`@\ngJ\\@ABeWU@]HR[j[w_v`@\ngJ\\@ABeWU@]XJ\\wfC~t@\ngJ\\@ABeWU@]XJ\\ytTyoLG}h@\ngJ\\@ADeSU@]XTSWrwndO{HP\ngJ\\@ADe\\u@]DJ\\enlDaYA@=\ngJ\\@ADe\\u@]DJ\\es`qS]XIC~rB@\ngJ\\@AEddMTAuaYK_SZvPm@=\ngJ\\@AEddMTAuaYM_SZvPm@=\ngJ\\@ALe\\p@]PMumg_{P@\ngJ\\@ALe\\s@]HJkk[O_v`@\ngJ\\@ALe\\s@]XJSYpXinitaZ@\ngJ\\@ALe\\t`]HJkk[Nv`@\ngJ\\@ALe\\t`]HJlxLTwVz^m@\ngJ\\@AbeMK@]XLTwb{~t@\ngJ\\@AbeMK@]XLTypXioEw}h@\ngJ\\@AbeMK@]XLTypXyoEw}h@\ngJ\\@`bnLiLmPGRdfzF}o}h`\ngJ\\A@bIR[Z`NeKMtMkX\ngJ\\A@bnR[Z`NeKMtMkX\ngJ\\A@lIRYZ`NmEI[h]H_vb@\ngJ\\A@lIRYZ`NmEI[paZH\ngJ\\A@lIRYZ`NmEI\\xL\\wPzPmD\ngJ\\A@lIRYZ`NmEI\\xL\\waC~tP\ngJ\\A@lIRYZ`NmEI\\zJ\\waC~tP\ngJ\\A@lIRYZ`NmEIkh]H_vb@\ngJ\\A@lIRYZ`NmEIkpaZH\ngJ\\A@lIRYZ`NmII[x[vrG}h`\ngJ\\A@lIR[B`Nedm|MkYC~tp\ngJ\\AAciRfe`NlFJ[i]w_v`@\ngJ\\AAciRfe`NlFJ[q]Z@\ngJ\\DAcJATBTuTAt`qs`qR>\ngJ\\HEb@aIej@zTTmD\ngJ\\HEb@aIfe@zTdwPwmmD\ngJ\\HEb@aInZ@zTlwPvmmL\ngJ\\HHlOAJfj@zpXeoC{|eBb\ngJ\\HHlOAJfj@zpXfoBG|eBcZP\ngJ\\HIb@aIZ`@zd[x^vso}i@=\ngJ\\HIbOAIY`@zd[k[Nvd@=\ngJ\\H`cj@SnR[Z`NeKMtNkh\ngJ\\Hib@b]iRVh@NiF~Gml{ZP\ngJ\\IIb@b\\dmP@]RM|O[Yw~t`=\ngJ\\aibEIW[dfvhCiQs~rf@\ngJ]@EbDfVhCiQS~tP\ngJ]@ebEqeIej@zTTmD\ngJ]AEbCJSKTAthiZH\ngKP@DklVj@zhXirVzpRG|dml\ngKP@DklVj@zhXirWICEN[kAH_rRvp\ngKP@DklVj@zhXirWICEN[z]pRG|dml\ngKP@DklVjbPzhXirV~g\\D~IK[@<\ngKP@DklVjbPzhXirV~g\\D~IK[@>\ngKP@DklVjbPzhXirWICEN[kAOorRvp<\ngKP@DklVjbPzhXirWICEN[kAOorRvp>\ngKP@LdabjhCjabgI[zAPRG|dML\ngKP@LdabjjACjabgI[zAWbG|dML<\ngKP@LdabjjACjabgI[zAWbG|dML>\ngKP@LdabjjACjabgI\\dLTyohE^H_rPtp<\ngKP@LdabjjACjabgI\\dLTyohE^H_rPtp>\ngKP@LdabjjACjabgI\\xJ\\wtBoDOyHZX<\ngKP@LdabjjACjabgI\\xJ\\wtBoDOyHZX>\ngKP@LdabjjACjabgI\\zJ\\wtBoDOyHZX<\ngKP@LdabjjACjabgI\\zJ\\wtBoDOyHZX>\ngKP`@TixjjdPztTyoDG|dL\\<\ngKQ@@dmcUPGQbgI[kAH_rRvp\ngKQ@@eOEUTbGQbgI[iAH_rPqp<\ngKQ@@eOEUTbGQbgI[iAH_rPqp>\ngKQ@@eOEUTbGQbgI[i^H_rPqp<\ngKQ@@eOEUTbGQbgI[i^H_rPqp>\ngKQ@@eOEUTbGQbgI\\yNRwRBPdac`<\ngKQ@@eOEUTbGQbgI\\yNRwRBPdac`>\ngKQ@@eOEUTbGQbgI\\yNRwR|Pdac`<\ngKQ@@eOEUTbGQbgI\\yNRwR|Pdac`>\ngKX@@dmcUPGQbgI[kAH_rRvp\ngNp@DiYzA@zVVwQw]`=\ngNp@DiYzA@zVVwqw]oh=\ngNp@DiYzB@zVVwqw]lH=\ngNp@DiYzB@zVVwqw^lH\ngNp@DiYzB@zVVwq{^lH=\ngNp@Djfjj@zxXirVk[uApRFaXP\ngNp@Djfjj@zxXirVk\\dLRuoTGAHZEa@\ngNp@Djfjj@zxXirVk\\dNRuoTGAOjEa@\ngNp@Djfjj@zxXirVk\\lLTyKV}P\\DahVD\ngNp@Djfjj@zxXirVk\\lLTyKV}P\\Daogx\ngNp@Djfjj@zxXirVk\\lLTyKV}P\\D~hVD\ngNp@Djfjj@zxXirVk\\tLTek^hNBPtKB\ngNp@Djfjj@zxXirVk\\tLTek^hNB_TKB\ngNp@Djfjj@zxXirVskuApRFaXP\ngNp@Djfjj@zxXirVsldNRuoTGAOjEa@\ngNp@Djfjj@zxXirZk[uApRFaXP\ngNp@Djfjj@zxXirZk\\lLTyKV}P\\DahVD\ngNp@Djfjj@zxXirZk\\tLTek^hNBPtKB\ngNp@Djfjj@zxXitZk[uApRFaXP\ngNp@Djfjj@zxXitZskuApRFaXP\ngNp@DjfjjPTPzxXirVk\\tL\\ek^hNB_TK|<\ngNp@DjfjjPTPzxXirVk\\tL\\ek^hNB_TK|>\ngNp@DjfjjPTPzxXirZk\\tL\\ek^hNBPtK|<\ngNp@DjfjjPTPzxXirZk\\tL\\ek^hNBPtK|>\ngNp@DjfjjPTPzxXirZk\\xLRwjC`dMBp`<\ngNp@DjfjjPTPzxXirZk\\xLRwjC`dMBp`>\ngNp@DjfjjPTPzxXirZklxLRwjC`dMBp`<\ngNp@DjfjjPT`zxXirVk\\dL\\eoTGAOjEa@>\ngNp@DjfjjPT`zxXirVk\\tL\\ek^hNB_TK|>\ngNp@DjfjjPT`zxXirZk\\xLRwjC`dMBp`<\ngNp@DjfjjPT`zxXirZk\\xLRwjC`dMBp`>\ngNp@DjfjjPT`zxXirZklxLRwjC`dMBp`<\ngNp@DjfjjPT`zxXirZklxLRwjC`dMBp`>\ngNp@Djfjj`PzxXirVk\\tL\\ek^hNB_TKB<\ngNp@Djfjj`PzxXirVk\\tL\\ek^hNB_TKB>\ngNp@Djfjj`PzxXirZk\\dLRuoTGAHZEa@<\ngNp@Djfjj`PzxXirZk\\tL\\ek^hNBPtKB<\ngNp@Djfjj`PzxXirZk\\tL\\ek^hNBPtKB>\ngNp@DjfjjdPzxXirVk[uApRFa_`>\ngNp@DjfjjdPzxXirVk\\dLTeoTGAHZEa@<\ngNp@DjfjjdPzxXirVk\\dLTeoTGAHZEa@>\ngNp@DjfjjdPzxXirVk\\dLTuoTGAHZE~@<\ngNp@DjfjjdPzxXirVk\\dLTuoTGAHZE~@>\ngNp@DjfjjdPzxXirVk\\lLTyKV}P\\DahWx<\ngNp@DjfjjdPzxXirVk\\lLTyKV}P\\DahWx>\ngNp@DjfjjdPzxXirVk\\lLTyKV}P\\D~hWx<\ngNp@DjfjjdPzxXirVk\\tLTek^hNBPtK|<\ngNp@DjfjjdPzxXirVk\\tLTek^hNBPtK|>\ngNp@DjfjjdPzxXirVk\\xLRwjC`dMBp`<\ngNp@DjfjjdPzxXirVk\\xLRwjC`dMBp`>\ngNp@DjfjjdPzxXirVk\\xLZwjC`dMB@<\ngNp@DjfjjdPzxXirVk\\xLZwjC`dMB@>\ngNp@DjfjjdPzxXirVk\\xNRwjC`guBp`<\ngNp@DjfjjdPzxXirVk\\xNRwjC`guBp`>\ngNp@DjfjjdPzxXirVk\\xNZwjC`guB@<\ngNp@DjfjjdPzxXirVk\\xNZwjC`guB@>\ngNp@DjfjjdPzxXirVkkuApRFaXP<\ngNp@DjfjjdPzxXirVkkuApRFaXP>\ngNp@DjfjjdPzxXirVkldLTeoTGAHZEa@>\ngNp@DjfjjdPzxXirVkltLTek^hNBPtKB<\ngNp@DjfjjdPzxXirVklxLRwjC`dMBp`<\ngNp@DjfjjdPzxXirVklxLRwjC`dMBp`>\ngNp@DjfjjdPzxXirVklxLZwjC`dMBp`<\ngNp@DjfjjdPzxXirVklxLZwjC`dMBp`>\ngNp@DjfjjdPzxXirVslxLRwjC`dMBp`>\ngNp@DjfjjdPzxXirZk\\xNRwjC`dMBp`<\ngNp@DjfjjdPzxXirZk\\xNRwjC`dMBp`>\ngNp@DjfjjdPzxXirZkkuApRFaXP<\ngNp@DjfjjdPzxXirZkkuApRFaXP>\ngNp@DjfjjdPzxXitZk\\dJ\\eoTGAHZEa@>\ngNp@DjzZj@zhdejv}f}tahVD\ngNp@DjzZj@zhdejwNCGM{N{iCPlH\ngNp@DjzZj@zhdejwNbgM{M{iCPlH\ngNp@DjzZj@zhdejz}f}tahVD\ngNp@DjzZj@zhdelz}f}tahVD\ngNp@DjzZj@zxXirVk[gAHZEa@\ngNp@DjzZj@zxXirVk[v]pRFaXP\ngNp@DjzZj@zxXirVk\\fJ\\en]xahVD\ngNp@DjzZj@zxXirVk\\lLTyKVywbFaXP\ngNp@DjzZj@zxXirVk\\lLTyKV}g\\DahVD\ngNp@DjzZj@zxXirVk\\tLTyK\\xICPlH\ngNp@DjzZj@zxXirVk\\tLTyK\\{qCPlH\ngNp@DjzZj@zxXirVk\\tLTyK^snBPtKB\ngNp@DjzZj@zxXirVk\\tLTyK^sn|PtKB\ngNp@DjzZj@zxXirVk\\xLZwl{`dMB@\ngNp@DjzZj@zxXirVk\\xL\\wNBPtKB\ngNp@DjzZj@zxXirVk\\xL\\wl{`dMBp`\ngNp@DjzZj@zxXirVk\\zJZwNBPtK|\ngNp@DjzZj@zxXirVk\\zJ\\wNBPtKB\ngNp@DjzZj@zxXirVk\\zJ\\wN|PtKB\ngNp@DjzZj@zxXirVk\\zJ\\wl{oDMBp`\ngNp@DjzZj@zxXirVkkgAHZEa@\ngNp@DjzZj@zxXirVsldLRuoYwAHZEa@\ngNp@DjzZj@zxXitVk[gAHZEa@\ngNp@DjzZj@zxXitVk[v]pRFaXP\ngNp@DjzZj@zxXitVk\\tLTyK^snBPtKB\ngNp@DjzZj@zxXitVk\\xL\\wNBPtKB\ngNp@DjzZj@zxXitVkldL\\eoYwAHZEa@\ngNp@DjzZjbPzhdej{NCGM{N{iCPlH<\ngNp@DjzZjbPzxXirVk\\tLTyk\\xICPop<\ngNp@DjzZjbPzxXirVk\\tLTyk\\xICPop>\ngNp@DjzZjbPzxXirVk\\tLTyk^snBPtK|>\ngNp@DjzZjbPzxXirVklxL\\wl{`dMBp`<\ngNp@DjzZjbPzxXirVklxL\\wl{`dMBp`>\ngNp@DjzZjbPzxXirVslxLRwl{`dMBp`<\ngNp@DjzZjbPzxXirVslxLRwl{`dMBp`>\ngNp@LdadBj@zNRu[^sZvPtKB=\ngNp@LdadBj@zNRu[^sZvPtKC~RqI@=\ngNp@LdadBj@zNRu[^sZvPtKC~VqIi@=\ngNp@LdadBj@zNRu[^sZvPtK|=\ngNp@LdadBj@zNRu[^sZvPtK}~VqIi@=\ngNp@LdadBj@zNRu[^sZzPtKB\ngNp@LdadBj@zNRu[^sjzPtKB=\ngNp@LdadBj@zNRu[^sjzPtKC~RqI@=\ngNp@LdadBj@zNRu[dqSdm{MkiCPlH\ngNp@LdadBj@zNRu[gASV}gUtahWx\ngNp@LdadBj@zNRu[gASf}gUtahVD\ngNp@LdadBj@zNRu[gQSV}futahWx\ngNp@LdadBj@zNRu[gQSf}futahVD\ngNp@LdadBj@zNRu]^sZvPtKB=\ngNp@LdadBj@zNRu]^sZvPtKC~RqI@=\ngNp@LdadBj@zNRu]^sZzPtKB\ngNp@LdadBj@zNRu]dqSdm{MkiCPlH\ngNp@LdadBj@zNRu]gQSV}futahVD\ngNp@LdadBj@zNRu]gQSV}futahVG|ebR\ngNp@LdadBj@zNRv]^sZvPtKB=\ngNp@LdadBj@zNRv]^sZzPtKB\ngNp@LdadBj@zNRv]daRVm{NkiCPlH\ngNp@LdadBj@zNRv]dqRVm{MkiCPlH\ngNp@LdadBj@zNRv]gQSf}futahVD\ngNp@LdadBj@zNSU[^sZvPws|=\ngNp@LdadBj@zNSV[^sZvPtK|=\ngNp@LdadBj@zNSV[gQSV}futahWx\ngNp@LdadBj@zNSV]^sZvPtKB=\ngNp@LdadBj@zNSV]^sZzPtKB\ngNp@LdadBj@zNSV]dqSdm{MkiCPlH\ngNp@LdadBj@zNSV]gQSf}futahVD\ngNp@LdadBjfPzNRu[^sZvPtK}~Rqi@-\ngNp@LdadBjfPzNRu[gQSf}futahWx>\ngNp@LdadBjfPzNRu]dqSfm{MkiCPlH<\ngNp@LdadBjfPzNRu]dqSfm{MkiCPlH>\ngNp@LdadBjfPzNRu]gQSf}futahVD<\ngNp@LdadBjfPzNRu]gQSf}futahVD>\ngNp@LdadBjfPzNRv[^sZvPtK|+\ngNp@LdadBjfPzNRv[^sZvPtK|-\ngNp@LdadBjfPzNRv[^sZvPtK}~Rqi@+\ngNp@LdadBjfPzNRv[^sZvPtK}~Rqi@-\ngNp@LdadBjfPzNRv[gQRV}futahW{|ecR<\ngNp@LdadBjfPzNRv[gQRV}futahW{|ecR>\ngNp@LdadBjfPzNRv]gQRV}futahVD<\ngNp@LdadBjfPzNRv]gQRV}futahVD>\ngNp@LdadBjfPzNSV[gQSf}futahWx<\ngNp@LdadBjfPzNSV[gQSf}futahWx>\ngNpB@xQpSagCIIKJj`NbDmVwl|o[uBpe`XTP\ngNpB@xQpk`wAJkjj`NbENRwNBPws|\ngNpBADFPl`yAInij`NmENP\ngNpCAHR`TaiB]dTaeT@GTc]W[z\ngNpD@DHHRZzj@CiQK_DMv}`=\ngNpD@DHHRZzj@CiQK_Guv}`=\ngNpD@DHHRZzj@CiQM_DMv}`=\ngNpD@DHHRZzjhCjqrVk\\eNRuobFaXP\ngNpD@DIpRYjfhCiqSdmVwH|PtK|\ngNpD@DIpRYjfhCjrRVk[t[vrFaXP\ngNpD@DIpRYjfhCjrRVk[t[vrFa_`\ngNpD@DIpRYjfhCjrRVk[t[wRFaXP\ngNpD@DSpRZYj@CkQrVypRF{^p=\ngNpD@DSpRZYj@CkQtZypRF{^p=\ngNpD@DSpRZYj@CkQtZypRF{_P\ngNpD@DSpRZYj@CkQtZypRF}_P=\ngNpD@DSpRZYj@CkQt[MbgIZwNBPwkz=\ngNpD@DSpRZYjBQCkQrZypRF{^p+\ngNpD@DSpRZYjBQCkQrZypRF{^p-\ngNpD@DSpRZYjhCiqSdmVwNBPtKB\ngNpD@DSpRZYjjQCiqSduVwNBPtKB<\ngNpD@DSpRZYjjQCiqSduVwNBPtKB>\ngNpD@bIpRYjfhCjrRVk[t[vrFaXP\ngNpD@bQpRZZj@CkQtZypRF{^p=\ngNpD@bSpRZYj@CkQtZypRF{^p=\ngNpD@bSpRZYj@CkQtZypRF{_P\ngNpD@bSpRZYjBQCkQrZypRF{^p+\ngNpD@bSpRZYjBQCkQrZypRF{^p-\ngNpD@bSpRZYjhCiqSdmVwNBPtKB\ngNpD@xN`RjZjXCiabgIZwJC`dMz\ngNpD@xQpRjzj@CkArV}glDanwl=\ngNpD@xQpRjzj@CkArV}glDanwt\ngNpD@xQpRjzj@CkAtZ}glDanwl=\ngNpD@xQpRjzj@CkAt[IbgM[v^pRF{_P\ngNpD@xQpRjzjBACkArZ}glDanwl-\ngNpD@xQpRjzjhCiaSdmVwNBPtKB\ngNpD@xQpRjzjhCiaSdmVwl}`dMBp`\ngNpD@xRPRjzj@CkAtZypRF{^p=\ngNpD@xRPRjzj@CkAtZypRF{_P\ngNpD@xUpRjZjdCiabgIVwJC`dM|\ngNpD@xUpRjZjjQCiabgIWWjC`dM|p`<\ngNpD@xUpRjZjjQCiabgIWWjC`dM|p`>\ngNpDADFHR[jZhCjqSfk\\fJRuoevaXP\ngNpDAHJPRZzj@CiQK_DMv~`\ngNpDAHJPRZzj@CiQK_Guv}`=\ngNpDAHJPRZzj@CiQK_Guv~`\ngNpDAHJPRZzj@CiQK_Guz~`=\ngNpDAHJPRZzjXCjqrVk[xaoVD\ngNpDAxKpR[ijhCjqrVk[xahVD\ngNpDAxSpRjyj@CkAtZypRF{^p=\ngNpDAxSpRjyjBACkArZypRF{^p+\ngNpDAxSpRjyjBACkArZypRF{^p-\ngNpD`DR`Dsdffj`@zt]Fn\\DaoWt=\ngNpDaxF`Dgdjfj`@zpTynTGAnwl=\ngNpDaxF`Dgdjfj`@zpUZnTGAnwl=\ngNpDaxF`Dgdjfj`@zpUZoTGAOkm{@=\ngNpDaxF`Dgdjfj``PzpTznTGAnwl+\ngNpDaxF`Dgdjfj``PzpTznTGAnwl-\ngNpDaxF`Dgdjfj``PzpTznTGAnwt<\ngNpDaxF`Dgdjfj``PzpTzoTGAOkm{IPx`+\ngNpDaxF`Dgdjfj``PzpTzoTGAOkm{IPx`-\ngNpDaxF`Dgdjfjj@zXXisUmr`xMBp`\ngNpDaxF`Dgdjfjj@zXXisUmz`xI}PlH\ngNpDaxF`Dgdjfjj@zXXjuUmr`xMBp`\ngNpDaxF`Dgdjfjj`PzXXiuUmr`xMBp`<\ngNpDaxF`Dgdjfjj`PzXXiuUmr`xMBp`>\ngNpDaxR`Dsdffj`@zt]Fn\\DaoWt=\ngNpDaxR`Dsdffj`@zt]FoQ{AH[u}@=\ngNpDaxR`Dsdffj`dPzt\\foQ{AH[u}I@h`+\ngNpDaxR`Dsdffj`dPzt\\foQ{AH[u}I@h`-\ngNpE@DSpdiMMU@AuhzM\\xIC]oX=\ngNpE@bSpdiMMU@AuhzM\\xIC]oX=\ngNpE@bSpdiMMUAHauhyM\\xIC]oX+\ngNpE@bSpdiMMUAHauhyM\\xIC]oX-\ngNpE@bSpdiMMUTAtxirVk[gAHZEa@\ngNpEADR`gIMMU@AuhzM\\xIC^oh=\ngNpEAHR`gIMMU@AuhzM\\xIC]oX=\ngNpEAHR`gIMMU@AuhzM\\xIC^oh=\ngNpEAHR`gIMMU@AuhzMfqSdm[gAH[u}@=\ngNpEAVRDdiMMU@AuhzM\\xIC]oX=\ngNpEAVSpdiMMU@AuhzM\\xIC]oX=\ngNpEAVSpdiMMU@AuhzM\\xIC]oh\ngNpEAVSpdiMMUTAtxirVk[gAHZEa@\ngNpEAbSpdiMMU@AuhzM\\xIC]oX=\ngNpEAxF`DiUMU@Au`ju\\hNC]oX=\ngNpEAxF`DiUMUTAtpqSfk[eApZEa@\ngNpEAxRPDiU]U@Au`zM\\xIC]oX=\ngNpEAxRPDiU]U@Au`zM\\xIC^oh=\ngNpEAxR`gIMMU@AuhzM\\xIC^oh=\ngNpEAxSpDiUMUTAupqSdmgWjC`dMBp`\ngNpEAxSpDiU]U@Au`zM\\xIC]oX=\ngNpEAxSpDiU]UA@au`yM\\xIC]oX+\ngNpEAxSpDiU]UA@au`yM\\xIC]oX-\ngNpEAxSpDiU]UTAtpirVk[gAHZEa@\ngNpH@DIMMU@AuhyK\\xIC]oX=\ngNpH@DIMMU@AuhzM\\xIC]oX=\ngNpH@DIMMU@AuhzMdqSfms`dMv~`\ngNpH@DIMMUAHauhyK^cvBPw[w~RAQ@-\ngNpH@DIMMUAHauhyMdqSfms`dMv~`<\ngNpH@DIMMUAHauhyMdqSfms`dMv~`>\ngNpH@DIMuMTAuYYKUmzMkYCPlH\ngNpH@DIMuMTAuYYKUuzMkYCPlH\ngNpH@DIMuMTAuYYKYuzMkYCPlH\ngNpH@DISmW@At`iodF{_P\ngNpH@bIMMU@AuhzMdqSfms`dMv~`\ngNpH@bISmW@At`iodF{_P\ngNpH@xIUMU@AtPirV}P\\Danwl=\ngNpH@xIUMU@AtPirV}P\\Danwt\ngNpH@xIUMU@AtPirV}P\\DaoWt=\ngNpH@xIUMU@AtPirV}P\\D~nwl=\ngNpH@xIUMU@AtPirWNCFmz`xIC]oh\ngNpH@xIUMU@AtPirZ}P\\Danwl=\ngNpH@xIUMU@AtPirZ}P\\Danwt\ngNpH@xIUMU@AtPirZ}P\\DaoWt=\ngNpH@xIUMU@AtPir[NCfmz`xIC]oh\ngNpH@xIUMU@AtPitZ}P\\Danwl=\ngNpH@xIUMU@AtPitZ}P\\Danwt\ngNpH@xIUMU@AtPjtV}P\\D~nwl=\ngNpH@xIUMU@AtPjtZ}P\\Danwl=\ngNpH@xIUMU@AtPjtZ}P\\Danwt\ngNpH@xIUMU@AtPjt[NCFmz`xIC]oh\ngNpH@xIUMUA@atPitV}P\\D~nwl+\ngNpH@xIUMUA@atPitV}P\\D~nwl-\ngNpH@xIUMULAuPrSdmz`xIC^oX\ngNpH@xIUMULAupqSdmVwJC`dKB\ngNpH@xIUMULAupqSdmVwjC`dMzp`\ngNpH@xIUMULAupqSdmVwjC`dMzpdbZP\ngNpH@xIUMULAupqSdmWWjC`dMzp`\ngNpH@xIUMULAupqSduVwJC`dKB\ngNpH@xIUMUTAupqSdmVwjC`dMBp`\ngNpH@xIUMUTAupqSdmVwjC`guBp`\ngNpH@xIUMUTAupqSduVwjC`dMBp`\ngNpH@xIUMUTAupqShuVwjC`dMBp`\ngNpHABIUMM@AtPitZ}W\\Danwl=\ngNpHADIMMULAtxirVk\\vJ\\ek\\xIC^op\ngNpHAHILuUUHatxirVk\\zJ\\wNBPtKB<\ngNpHAHIMMU@AuhyK\\xIC]oX=\ngNpHAHIMMUUHatxirVk\\vJ\\ek\\xI}PlH<\ngNpHAbILuUUHatxirVk\\zJ\\wNBPtKB>\ngNpHAxIMMU@AuhzM\\xIC]oX=\ngNpHAxIMMU@AuhzM^cvBPw[v=\ngNpHAxITuUTAupqUhmVwjC`dMBp`\ngNpHAxITuUU@aupqSdmVwjCoDMBp`<\ngNpHAxITuUU@aupqSdmVwjCoDMBp`>\ngNpHAxITuUU@aupqUdmVwjCoDMBp`<\ngNpHAxITuUU@aupqUdmVwjCoDMBp`>\ngNpHAxIUMA@AoUw]H[m{@=\ngNpHAxIUMM@AtPitZypRF{^p=\ngNpHAxIUMM@AtPitZ}W\\Danwl=\ngNpHAxIUMMA@atPirZ}W\\Danwl+\ngNpHAxIUMMA@atPirZ}W\\Danwl-\ngNpHGPYICHETAulfm\\sZvPtH=\ngNpIABBTjfj`@zHTzM^hNBPw[v=\ngNpIABBTjfj`@zHUZM^hNBPw[v=\ngNpIAxBTjZjj@zxXirVk[u^wbFaXP\ngNpIAxBTjZjj`PzxXirVk[uAwbFaXP<\ngNpIAxBTjZjj`PzxXirVk[uAwbFaXP>\ngNpIAxBTjfj`@zHTyK^hNBPwkz=\ngNpIAxBTjfj`@zHTyM^hNBPw[v=\ngNpIAxBTjfj`@zHTyM^hNBPwkz=\ngNpIAxBTjfj`@zHTzM^hNBPw[v=\ngNpIAxBTjfj`@zHTzM^hNBPw[z\ngNpIAxBTjfj`@zHTzM^hNBPwkz=\ngNpIAxBTjfj`@zHTzMgAcV}P\\Danwt\ngNpIAxBTjfj`@zHUZK^hNB_W[v=\ngNpIAxBTjfj`@zHUZM^hNBPw[v=\ngNpIAxBTjfj`@zHUZM^hNBPw[z\ngNpIAxBTjfjf@zxXjtZk[eApREa@\ngNpIAxBTjfjj@zxXirVk[uApRFaXP\ngNpIAxBTjfjj@zxXirZk[uApRFaXP\ngNpIMP[ldadBj@zNRu[^sZvPtKB=\ngNpIMP[ldadBj@zNRu]^sjzPtKB=\ngNpIMP[ldadBj@zNRv]^sZvPtKB=\ngNpIMP[ldadBj@zNRv]^sjzPtKB=\ngNpIMP[ldadBj@zNSV]^sZvPtKB=\ngNpIMP[ldadBj@zNSV]^sjzPtKB=\ngNpIMP[ldadBj@zNSV]dqSdm{MkiCPlH\ngNpL@DIpK`dsUMPGQdfk[t[vszaXP\ngNpL@VSDVIddaeT@GRBZ~H[m{@=\ngNpL@VSDVIddaeT@GRBZ~H[m}@\ngNpL@xIpsadTaeT@GTc^cr}oW[v=\ngNpL@xQpSaddaeT@GRBZ}gexanwl=\ngNpL@xQpSaddaeT@GRBZ}gexaoWw|dCB=\ngNpL@xQpSaddaeUPGUCdmVwl|oDMBpd`XP\ngNpL@xUp[`eTuUPGUCENRwjC`dM|@\ngNpLABIps`dsUUTbGUbdmVwN|PtKB<\ngNpLABIps`dsUUTbGUbdmVwN|PtKB>\ngNpLADJHtQdTaeUPGQbVskjaXP\ngNpLAHJPtadTaeT@GTc]W[v=\ngNpLAHJPtadTaeT@GTc]W[z\ngNpLAHJPtadTaeT@GTc]Wkz=\ngNpLAHJPtadTaeTpGQbVk[j}XP\ngNpLAHJPtadTaeTpGQbVk[qa@\ngNpLAHJPtadTaeTpGQbVkkqa@\ngNpLAHJPtadTaeTpGRbZzoWl\ngNpLAHJPtadTaeTpGRbZzoWt\ngNpLAHJPtadTaeUPGQbVk[jaXP\ngNpLAHJPtadTaeUTJGQbVk[ja_`<\ngNpLAHJPtadTaeUTJGQbVkkjaXP<\ngNpLAHJPtadTaeUTJGQbVkkjaXP>\ngNpLAxIps`dsUUTbGUbdmVwN|PtKB<\ngNpLAxIps`dsUUTbGUbdmVwN|PtKB>\ngNpLaxKpw`itiLtuTAuXiMYusoDMBp`\ngNpMAxZ`M@IRjZjhCjabfk[uAwczaX_rRNH\ngNpMAxZ`M@IRjZjjACjabfk[eAwjEaIHx`<\ngNpMAxZ`M@IRjZjjACjabfk[eAwjEaIHx`>\ngNpP@cTfzZj@zt\\moFD\ngNpXHmQxYIIXuUBau`e[^LH<\ngNpXHmQxYIIXuUBau`e[^LH>\ngNpXHmQxYIIXuUBau`e]^LH<\ngNpXHmQxYIIXuUBau`e]^LH>\ngNp`@TfZZj@zlTyjv~pZEa@\ngNp`@TfZZj@zlTzjv~pZEa@\ngNp`@TfZZjb`zlTyjv~pZE~@<\ngNp`@TfZZjb`zlTyjv~pZE~@>\ngNp`@TfZZjb`zlTyjwIbgI[{AhVD>\ngNp`@TfZZjb`zlTyjwNbdm}`tKB<\ngNp`@TfZZjb`zlTyjwNbdm}`tKB>\ngNp`@TfZZjb`zlTyjwNbdm}`tK|>\ngNp`@TfZZjb`zlTyjwNbdm}oTKB<\ngNp`@TfZZjb`zlTyjwNbdm}oTKB>\ngNp`@TfZZjb`zlTyjwNbfm}`tK|<\ngNp`@TfZZjb`zlTyjwNbfm}`tK|>\ngNp`@TfZZjb`zlTyj{Nbfm}`tKB<\ngNp`@TfZZjb`zlTzjwNbdm}`tKB<\ngNp`@TfZZjb`zlTzjwNbdm}`tKB>\ngNp`@TfZZjb`zlTzjwNbfm}`tK|<\ngNp`@Tfzfjf`zlTyjwNbdmuPlH>\ngNp`@dfnj`@zTRwqC]oX=\ngNp`@dfnj`@zTRwqC]oh\ngNp`@dfnj`@zTRwq}]oX=\ngNp`@dfnj`@zTRyr\\uobF{_P\ngNp`@dfnj`@zTRyr\\uocz{_P\ngNp`@dfnj`@zTSWqC]oX=\ngNp`@dfnj`dPzTRypTuobF{_P>\ngNp`@dfnjf@zl\\ejwNSdmtPlH\ngNp`@dfnjj@zl\\ejv~HZEa@\ngNp`@dfnjj@zl\\ejwISdm[xahVD\ngNp`@dfnjjTV`zl\\ejwNBdm|PtKB<\ngNp`@dfnjjTV`zl\\ejwNBdm|PtKB>\ngNp`@dfnjjdPzl\\ejwMBgIZwqCPlH<\ngNp`@dfnjjdPzl\\ejwMBgIZwqCPlH>\ngNp`@dfnjjfPzl\\ejwICEM[xahWx<\ngNp`@dfnjjfPzl\\ejwNSdm|PtKB<\ngNp`@dfnjjfPzl\\ejwNSdm|PtKB>\ngNp`@dfzZj@zl\\ejv~HZEa@\ngNp`@dfzZj@zl\\ejv~HZEaIXd`\ngNp`@dfzZj@zl\\ejv~HZEaKXdt`\ngNp`@dfzZj@zl\\ejv~HZE~@\ngNp`@dfzZj@zl\\ejv~H[y~@\ngNp`@dfzZj@zl\\ejwIbgI[xahVD\ngNp`@dfzZj@zl\\ejwNbgM|PtKB\ngNp`@dfzZj@zl\\ejz~HZEa@\ngNp`@dfzZj@zl\\elz~HZEa@\ngNp`@dfzZjfPzl\\ejv~HZE~IXt`<\ngNp`@dfzZjfPzl\\elv~HZE~@<\ngNp`@dfzZjfPzl\\elv~HZE~@>\ngNp`@dfzjj@zl\\ejv~HZEa@\ngNp`@dfzjjdPzl\\ejwNBgM|PtKB>\ngNp`ATffjjTRPzlTyJv~pSya@<\ngNp`ATffjjTRPzlTyJwMCEIZwvBPlH<\ngNp`ATffjjTRPzlTyJwMCEIZwvBPlH>\ngNp`ATffjjTRPzlTyJwNbfm}`dKB<\ngNp`ATffjjTRPzlTyJwNbfm}`dKB>\ngNp`ATffjjTRPzlTyJwNbfm}`dK|<\ngNp`ATffjjTRPzlTyJwNbfm}`dK|>\ngNp`ATffjjTRPzlTyJwNbfm}`gsB>\ngNp`ATffjjTRPzlTyJwNbfm}oGsB>\ngNp`ATffjjTRPzlTyJwNcfm}`gsB<\ngNp`ATffjjTRPzlTyJwNcfm}`gsB>\ngNp`ATffjjTR`zlTyJwICEM[{AHVD>\ngNp`ATffjjTR`zlTyJwNbdm}`dKB<\ngNp`ATffjjTR`zlTyJwNbfm}`dKB<\ngNp`ATffjjTR`zlTyJwNbfm}`dKB>\ngNp`ATffjjTR`zlTyJwNbfm}`dK|<\ngNp`ATffjjTR`zlTyJwNcfm}`gsB<\ngNp`ATffjjTR`zlTyLv~pREa@<\ngNp`ATffjjTR`zlTyLz~pREa@>\ngNp`ATffjjb`zlTyJv~pREa@<\ngNp`ATffjjb`zlTyJv~pREa@>\ngNp`ATffjjb`zlTyJv~wcya@<\ngNp`ATffjjb`zlTyJwIbgM[{AHVD>\ngNp`ATffjjb`zlTyJwNCFm}`dKB<\ngNp`ATffjjb`zlTyJwNCFm}`dKB>\ngNp`ATffjjb`zlTyJz~pREa@>\ngNp`ATffjjb`zlTzLv~pREa@<\ngNp`ATffjjb`zlTzLv~pREa@>\ngNpa@erS]MU@]VNRu[_DMBp`\ngNpa@erS]MU@]VNRu[_DMBpdlRP\ngNpa@erS]MU@]VNSV]_DMBp`\ngNpdH`DTHrRPqZjYCharYm|PwsB<\ngNpdH`DTHrRPqZjYCharYm|PwsB>\ngNpdJqHJPRZzjXCkQrV|HP\ngNpdJqHJPRZzjXCkQrV|O`\ngNpdJqHJPRZzjXCkQrZ|HP\ngNpeE`DSpGYEHYMAHauHwUv}`+\ngNphH`DYIHXm@At`eobF{^p=\ngNphH`DYIHXm@At`eobF{_P\ngNphH`DYIHXm@At`eocz{^p=\ngNphH`DYIHXm@At`eocz}_P=\ngNphH`DYIHXm@At`fobF{^p=\ngNphH`DYIHXm@At`fobF{_P\ngNphH`DYIHXm@At`fobF}_P=\ngNphH`DYIHXm@At`fsdyk_DMv~`\ngNphH`DYIHXmLAuPyMUmtPlH\ngNphH`DYIHXmLAuPyMUm|PwkB\ngNphH`DYIHXmLAuPyMUutPlH\ngNphH`DYIHXmLAuPyMUu|PwkB\ngNphH`DYIHXmLAu`zK_DMz~`\ngNphH`DYIHXmLAu`zM_DMz~`\ngNphH`DYIHXmTAuPyKUm|PtKB\ngNphH`DYIHXmTAuPyMUm|PtKB\ngNphH`DYIHXmULauPyKUn\\gI[xahVD<\ngNphH`DYIHXmULauPyKUn\\gI[xahVD>\ngNphH`DYIHXmULauPyMUm|PtK|<\ngNphH`DYIHXmULauPyMUu|PtKB<\ngNphH`DYIHXmULauPyMUu|PtKB>\ngNphH`VYIHYU@At`fobF{^p=\ngNphH`xYIHYU@At`eobF{^p=\ngNphH`xYIHYU@At`fobF{^p=\ngNphH`xYIHYU@At`fobF{_P\ngNphH`xYIHYU@At`fobF}_P=\ngNphH`xYIHYUTAuPyKUm|PtKB\ngNphHaxYIHXuA@at`eobF{^p+\ngNphHaxYIHXuA@at`eobF{^p-\ngNphHaxYIHXuA@at`fobF{^p+\ngNphHaxYIHXuA@at`fobF{^p-\ngNphJpDIMMULAtXirVzpRD\ngNphJqHIMMULAtXirVzpRD\ngNphJqbIMMULAtXirVzpRD\ngNpi@iPSdfnj`@zTSWqC]oX=\ngNpi@iPSdfnj`@zTSWqC^oh=\ngNplJqDJHtQdTaeTpGRbT\ngNplJqHJPtadTaeTpGRbT\ngNpmJqDJHtP~rJPrjXCiQJ\ngNpmJqHJPt`~rJPrjXCiQJ\ngNq@@dju\\@GTc]W[v=\ngNq@@dju\\@GTc]W[z\ngNq@@dsSUPGSbgIZmn\\DahVD\ngNq@@dsSUPGSbgIZmn\\DahWx\ngNq@@dsSUPGSbgIZmn]xahVD\ngNq@@dsSUPGSbgIZmrXirVypRFaXP\ngNq@@dsSUPGSbgIZmrXirVywbFaXP\ngNq@@dsSUPGSbgIZmshik\\xICPop\ngNq@@dsSUPGSbgIZmshik\\{qCPop\ngNq@@dsSUPGSbgIZmshis\\xICPlH\ngNq@@dsSUPGSbgIZmshis\\{qCPlH\ngNq@@dsSUPGSbgIZnn\\DahVD\ngNq@@dsSUPGSbgIZnn]xahVD\ngNq@@dsSUPGSbgIZnshik\\xICPlH\ngNq@@dsSUPGSbgI[Nn\\DahVD\ngNq@@dsSUPGSbgQZmn\\DahVD\ngNq@@dsSUPGSbgQZmn\\DahWx\ngNq@@dsSUPGSbgQZmshik\\xICPop\ngNq@@dsSUPGSbgQZmshis\\xICPlH\ngNq@@dsSUPGSbgQZnn\\DahVD\ngNq@@dsSUTRGSbgIZmrXisVypRFa_`<\ngNq@@dsSUTRGSbgIZmrXisVypRFa_`>\ngNq@@dsSUTRGSbgIZmrXisVywbFa_`<\ngNq@@dsSUTRGSbgIZmrXisVywbFa_`>\ngNq@@dsSUTRGSbgIZmshis\\xICPop<\ngNq@@dsSUTRGSbgIZmshis\\xICPop>\ngNq@@dsSUTRGSbgIZmshis\\{qCPop<\ngNq@@dsSUTRGSbgIZnshis\\xICPlH<\ngNq@@dsSUTRGSbgIZnshis\\xICPlH>\ngNq@@dsSUTRGSbgQZmshis\\xICPop>\ngNq@@dsSUTRGSbgQZnshis\\xICPlH<\ngNq@@dsUURbRGSbgIZmsPqSfms`dMB@<\ngNq@@dsUURbRGSbgIZmshis\\xICPop<\ngNq@@dsUURdRGSbgIZmshiK\\xIC_Op>\ngNq@@dsUURdRGSbgIZmshis\\xICPop<\ngNq@@dsUURdRGSbgIZmshis\\xICPop>\ngNq@@dsUURdRGSbgIZnshis\\xICPlH<\ngNq@@dsUUTbGSbgIZmn\\DahVD<\ngNq@@dsUUTbGSbgIZmn\\DahVD>\ngNq@@dsUUTbGSbgIZmn\\DahWx>\ngNq@@dsUUTbGSbgIZmrPqSfypRFaXP<\ngNq@@dsUUTbGSbgIZmrXirVypRFaXP<\ngNq@@dsUUTbGSbgIZmrXirVypRFaXP>\ngNq@@dsUUTbGSbgIZmrXirVywbFaXP<\ngNq@@dsUUTbGSbgIZmrXirVywbFaXP>\ngNq@@dsUUTbGSbgIZmsPqSdms`dMBp`<\ngNq@@dsUUTbGSbgIZmsPqSdms`dMBp`>\ngNq@@dsUUTbGSbgIZms`qs\\xICPlH<\ngNq@@dsUUTbGSbgIZmshik\\xICPop<\ngNq@@dsUUTbGSbgIZmshik\\xICPop>\ngNq@@dsUUTbGSbgIZmshis\\xICPlH<\ngNq@@dsUUTbGSbgIZmshis\\xICPlH>\ngNq@@dsUUTbGSbgIZmshis\\{qCPlH<\ngNq@@dsUUTbGSbgIZmshis\\{qCPlH>\ngNq@@dsUUTbGSbgIZnshik\\xICPlH>\ngNq@@dsUUTbGSbgQZmn\\DahVD<\ngNq@@dsUUTbGSbgQZmn\\DahVD>\ngNq@@dsUUTbGSbgQZms`qk\\xICPop>\ngNq@@dsUUTbGSbgQZms`qs\\xICPlH<\ngNq@@dsUUTbGSbgQZms`qs\\xICPlH>\ngNq@@dsUUTbGSbgQZmshis\\xICPlH>\ngNq@@dtuT@GVcdms`dMv}`=\ngNq@@dtuT@GVcdms`dMv}dd\\P=\ngNq@@dtuT@GVcdms`dMv~`\ngNq@@dtuT@GVcdmsoGuv~`\ngNq@@dtuT@GVcdn\\FM[gAH[m}@\ngNq@@dtuT@GVchus`dMv}`=\ngNq@@dtuT@GVchus`dMv~`\ngNq@@dtuT@GVchus`dMz~`=\ngNq@@dtuT@GVchvSENZwNBPw[z\ngNq@@dtuT@GVchvVFJ\\ek\\xIC^oh=\ngNq@@dtuT@GVchv\\FM[gAH[m}@\ngNq@@dtuTDbGVcdms`guv}`+\ngNq@@dtuTDbGVcdms`guv}`-\ngNq@@dtuTDbGVcdms`guv}dd\\P-\ngNq@@dtuTDbGVcdn]EM[gAH[m}@<\ngNq@@dtuTDbGVcdn]EM[gAH[m}@>\ngNq@@dtuTDbGVcdn]GM[gAOkm}@<\ngNq@@dtuTDbGVcdn]GM[gAOkm}@>\ngNq@@dtuTDbGVcdus`dMv}`+\ngNq@@dtuTDbGVcdus`dMv}`-\ngNq@@dtuTDbGVcdus`dMv~`<\ngNq@@dtuTDbGVcdus`dMv~`>\ngNq@@dtuTDbGVcdv]EM[gAH[m}@<\ngNq@@dtuTDbGVcdv]EM[gAH[m}@>\ngNq@@dtuTDbGVcdv]GI[gAH[u}@<\ngNq@@dtuTDbGVcdv]GI[gAH[u}@>\ngNq@@dtuTDbGVcdv]GM[gAH[m}@<\ngNq@@dtuTDbGVcdv]GM[gAH[m}@>\ngNq@@dtuTDbGVchms`guv}`+\ngNq@@dtuTDbGVchms`guv}`-\ngNq@@dtuTDbGVchvRFJZwNBPw[z<\ngNq@@dtuTDbGVchvRFJZwNBPw[z>\ngNq@@dtuTDbGVchv]EM[gAH[m}@<\ngNq@@dtuTDbGVchv]EM[gAH[m}@>\ngNq@@dtuTpGSbgIZmolDaXP\ngNq@@dtuTpGSbgIZmrpqSdm[{AHVD\ngNq@@dtuTpGSbgIZmsXirVm}`dKB\ngNq@@dtuTtbGSbgIZmsXirVm}`gsB<\ngNq@@dtuTtbGSbgIZmshiK\\xIC^lH<\ngNq@@dtuTtbGSbgIZmshik_XIBp`<\ngNq@@dtuTtbGSbgIZmshik_XIBp`>\ngNq@@dtuTtbGSbgIZmshik_XIB@<\ngNq@@dtuTtbGSbgIZmshyk_XI|p`<\ngNq@@dtuUPGSbgIZmn\\DahVD\ngNq@@dtuUPGSbgIZmn\\DahVG|dSR\ngNq@@dtuUPGSbgIZmrpqSdm[gAHZEa@\ngNq@@dtuUPGSbgIZmsXirVms`dMBp`\ngNq@@dtuUPGSbgI[Nn\\DahVD\ngNq@@dtuURbRGSbgIZmrPqRVypRFaXP<\ngNq@@dtuURbRGSbgIZmrXiKVypRFa_orQMH<\ngNq@@dtuURbRGSbgIZmrXiKVypRFa_orQMH>\ngNq@@dtuURbRGSbgIZmshiK\\xICPlH<\ngNq@@dtuURbRGSbgIZmshiK\\xICPlH>\ngNq@@dtuURbRGSbgIZmshik\\xICPop<\ngNq@@dtuURbRGSbgIZmshik\\xICPop>\ngNq@@dtuURbRGSbgIZmshyK\\xI}PlH<\ngNq@@dtuURbRGSbgIZmshyK\\xI}PlH>\ngNq@@dtuURbRGSbgIjmshyK\\xICPlH>\ngNq@@dtuURbRGSbgIjnn\\DahVD<\ngNq@@dtuURbRGSbgIjnn\\DahVD>\ngNq@@dtuURbTGSbgIZmrPqRVypRFaXP<\ngNq@@dtuURbTGSbgIZmsPqRVms`dMB@<\ngNq@@dtuURbTGSbgIZmsPqRVms`dMB@>\ngNq@@dtuURbTGSbgIZmshiK\\xICPlH<\ngNq@@dtuURbTGSbgIZmshiK\\xICPlH>\ngNq@@dtuURbTGSbgIZmshik\\xICPop<\ngNq@@dtuURbTGSbgIZmshik\\xICPop>\ngNq@@dtuURbTGSbgIZmshik\\xICPowyIGD>\ngNq@@dtuURbTGSbgIZmshyK\\xI}PlH>\ngNq@@dtuURbTGSbgIZnshiK\\xICPlH<\ngNq@@dtuURbTGSbgIjmshiK\\xICPlH<\ngNq@@dtuURbTGSbgIjmshiK\\xICPlH>\ngNq@@dtuURbTGSbgIjnn\\DahVD>\ngNq@@dtuUTRGSbgIZmn\\DahWx<\ngNq@@dtuUTRGSbgIZmrXirVypRFaXP<\ngNq@@dtuUTRGSbgIZmrXirVypRFaXP>\ngNq@@dtuUTRGSbgIZmsXirVms`dMB@<\ngNq@@dtuUTRGSbgIZmsXirVms`dMB@>\ngNq@@dtuUTRGSbgIZms`qK\\xICPlH<\ngNq@@dtuUTRGSbgIZms`qK\\xICPlH>\ngNq@@dtuUTRGSbgIZms`qk\\xICPop>\ngNq@@dtuUTRGSbgIZnn\\DahVD<\ngNq@@dtuUTRGSbgIZnn\\DahVD>\ngNq@@dtuUTRGSbgQjnn\\DahVD<\ngNq@@dtuUTRGSbgQjnn\\DahVD>\ngNq@@dtuUTbGSbgIZmn\\D~hVD>\ngNq@@dtuUTbGSbgIZmrXiKVypRFaXP<\ngNq@@dtuUTbGSbgIZmrXiKVypRFaXP>\ngNq@@dtuUTbGSbgIZmrXyKVypSzaXP<\ngNq@@dtuUTbGSbgIZmrXyKVypSzaXP>\ngNq@@dtuUTbGSbgIZmsPqRVms`dMBp`<\ngNq@@dtuUTbGSbgIZmsPqRVms`dMBp`>\ngNq@@dtuUTbGSbgIZmsXirVms`guBp`<\ngNq@@dtuUTbGSbgIZmsXirVms`guBp`>\ngNq@@dtuUTbGSbgIjmn\\DahVD<\ngNq@@dtuUTbGSbgIjmn\\DahVD>\ngNq@@dtuUTbGSbgIkNn\\DahVD>\ngNq@@dwTuPGSbgIZmnUtahVD\ngNq@@dwTuPGSbgIZmobFaXP\ngNq@@dwTuPGSbgIZmshis\\kiCPlH\ngNq@@dwTuPGSbgIZmshis_DMBp`\ngNq@@dwTuPGUedmVwhvmdMBp`\ngNq@@dwTuPGUedmWWhvmdMBp`\ngNqDJDR^BSSMT`]FJmFn\\Danwl\ngNqDJHaQBSWUS@]FNRnnbEa@\ngNqDJIARBSWUUSP]FNRmsdyk]GsB<\ngNqHB@aInij`NcKMgWHvmtKB\ngNqHB@aInijihNcKMWWHvmtKB<\ngNqHB@aInijihNcKMWWHvmtKB>\ngNqHBLQInijihNkENZmshiK_KmBp`<\ngNqHBLQInijihNkENZmshiK_KmBp`>\ngNqHD@aInij`NkGIZmobFaXP\ngNqHH@aJnfjhDNfENRu[\\xICPlH>\ngNqHH@aJnfjhDNfENbu[\\xICPlH<\ngNqHH@aJnfjhDNfENbu[\\xICPlH>\ngNqHHGAJkjh@NlGI[gAH[m{@=\ngNqHHGAJkjh@NlGQkgAH[m{@=\ngNqHHGAJkjhHDNlGIkgAH[m{@+\ngNqHHGAJkjhHDNlGIkgAH[m{@-\ngNqHHGAJkjhHDNlGQ[gAOkm{@+\ngNqHHGAJkjhHDNlGQ[gAOkm{@-\ngNqHHGAJkjj`NfENRu[\\xICPlH\ngNqHHGAJkjjhDNfENSU[\\xICPlH<\ngNqHHGAJkjjhDNfENSU[\\xICPlH>\ngNqHHOAJkfh@NlGI[gAH[m{@=\ngNqHHOAJkfh@NlGI[gAH[m}@\ngNqHHOAJkfh@NlGQkgAH[m{@=\ngNqHHOAJkfh@NlGQkgAH[m}@\ngNqHHOAJkfh@NlGQkgAH[u}@=\ngNqHHOAJkfh@NlGQlvJ\\ek\\xIC^oh=\ngNqHHOAJkfhHDNlGIkgAH[m{@+\ngNqHHOAJkfhHDNlGIkgAH[m{@-\ngNqHHOAJkfhHDNlGIkgAH[m}@<\ngNqHHOAJkfhHDNlGIkgAH[m}@>\ngNqHHOAJkfhHDNlGQ[gAOkm{@+\ngNqHHOAJkfhHDNlGQ[gAOkm{@-\ngNqHHOAJkfi`NfENcU[\\xIC^lH\ngNqHHOAJkfi`NfENcU]\\xIC^lH\ngNqHHOAJkfi`NfENcU]_XIBp`\ngNqHHOAJkfj`NfENRu[\\xICPlH\ngNqHHOAJkfj`NfENcU[\\xICPlH\ngNqHHOAJkfjhDNfENSU[\\xICPlH<\ngNqHHOAJkfjhDNfENSU[\\xICPlH>\ngNqHHOAJkfjhdNfENcU]\\xICPlH<\ngNqHJIAIijjeDhNkENRmshik_XI|p`>\ngNqHaJ@SNRZZj@CkQtZypRF}_P=\ngNqIAJB\\dtuT@GVchus`dMv}`=\ngNqIAJB\\dtuT@GVchus`dMz~`=\ngNqIAJB\\dtuTDbGVcdus`dMz~`+\ngNqIAJB\\dtuTDbGVcdus`dMz~`-\ngNqIHO@ReUuT@GVChus`dMv}`=\ngNqIHO@ReUuT@GVChus`dMz~`=\ngNqLJIARFdLbdLjf@ztRmoFD\ngNqLJIARFdLbdLjf@ztRnoFD\ngNqLJIARFdLbdLji@ztRmoGt\ngNqLJIARFdLbdLjja`ztRmoFD<\ngNqLJIARFdLbdLjja`ztRmoFD>\ngNqLJIARFdLbdLjja`ztRmoGx<\ngNqLJIARFdLbdLjja`ztRmoGx>\ngNqLL@b^BBLbdLZ`dPzd[j{^p+\ngNqLL@b^BBLbdLZ`dPzd[j{^p-\ngNq`@ZdsSUPGQbgK\\zJZwVBp`\ngNq`@ZdsSUPGQbgK\\zJZwV|p`\ngNq`@ZdsSUTRGQbgK\\zJ\\wVBp`<\ngNq`@bdwSUPGQcfk[jaXP\ngNq`@bdwSUPGQcfk[j~_`\ngNq`@bdwSUPGQcfskjaXP\ngNq`@bdwSUTtGQcfk[ja_`<\ngNq`@bdwSUTtGQcfk[ja_`>\ngNq`@bdwSUTtGQcfk\\zJRwUBp`>\ngNq`@bdwSUTtGQcfkkjaXP<\ngNq`@bdwSUTtGQcfkkjaXP>\ngNq`@bdwSUTtGQcfs[ja_`<\ngNq`@bdwSUTtGQcfs[ja_`>\ngNq`@jduuURbrGQcdk\\xJZwQBp`<\ngNq`@jduuURbtGQcdk\\dJ\\uncya@>\ngNq`@jduuUTtGQcdk[haXP<\ngNq`@jduuUTtGQcdk\\yNZwQBp`<\ngNq`@mdTaeT@GTc]W[v=\ngNq`AVdtuUPGQbgI\\lLTyKVzpRD\ngNqa@bnR[ijhChqsUmuPlH\ngNqhHl@cIIKEh@NhFznwl=\ngNqhHl@cIIKEh@NhFznwt\ngNqhHlBsIIKJh@NhGNSdmu^ooyHFD\ngNqhHlGCIIKJh@NhFznwl=\ngNqhHlGCIIKJh@NhFznwt\ngNqhHlGCIIKJj`NbDmVwUBp`\ngNqhHlOCIIKFh@NhFznwl=\ngNqhHlOCIIKFh@NhFznwt\ngNqhHlOCIIKFh@NhFzoWt=\ngNqhHlOCIIKFi`NbDmVwUzp`\ngNqhHlOCIIKFi`NbDmVwcB\ngNqhHlOCIIKFi`NbDmWWUzp`\ngNqhHlOCIIKFj`NbDmVwUBp`\ngNqhHlOCIIKFjhTNbDmWWUBp`>\ngNqi@mJB]dTaeT@GTc]W[v=\ngNqi@mJB]dTaeT@GTc]W[z\ngNqiHl@c]ddebt@GTC]W[v=\ngNqiHl@c]ddebt@GTC]W[z\ngNqiHl@c]ddebt@GTC]Wkz=\ngNqiHlOC]ddecTDBGTC]W[v+\ngNqiHlOC]ddecTDBGTC]W[v-\ngNr@ACTjzjj@zpdmoio[X_v`@\ngNr@ACTjzjj@zpdnoio[X_v`@\ngNrDEcPDSpRZYjhCkQRv|X_vb@\ngNrDHlQxWpRjyjhCkARwNCDmu_LO{Q@\ngNrHEcQxIMMUTAthjnkm{ZH\ngNrHHlPxIUMUTAt`rnkm}ZP\ngNrHHlQxIU\\uTAtPijvzhVG}h`=\ngNrHHlQxIU\\uTAtPijwIbgI[jaX_vb@\ngNrHHlQxYIHXETAulu[\\sZwPlO{S@=\ngNrHHlQxYIHXETAulu[gIrVyfunaX_vf@\ngNrIHlQxRTjnZj@zHTu[]TKC~tP=\ngNrIHlQxRTjnZj@zHTu[_SmBpmD=\ngNrIXlPxAiJgRYRjZj@CjAnkm{b@[R@=\ngNr`hZpiJyInfj`NeGO{R@\ngNt@@TfzBj@zvZmnQm[hVD\ngNt@@Tfzfj@zLlu[gASfyGUnaXP\ngNt@@Tfzfj@zLlu[gQSfyFuvaXP\ngNt@@TjZjj`PzXXiuUn\\EN[eApZEa@<\ngNt@@TjZjj`PzXXiuUn\\EN[eApZEa@>\ngNt@@dfnj`@zTRwqC]oX=\ngNt@@dfnj`@zTRwq}]oX=\ngNt@@dfnj`@zTSWqC]oX=\ngNt@@dfzZj@zl\\ejvyGRFaXP\ngNt@@dfzZj@zl\\ejv~HZEa@\ngNt@@dfzjj@zl\\ejv~HZEa@\ngNt@@dfzjj@zl\\ejwICEN[xahVD\ngNt@ADjzjj@zXTyKUms`dMBpm@\ngNt@ADjzjj@zhdejv}f}tahVG}h@\ngNt@ATffjjb`zlTyJz~pREa@>\ngNtDHpxUpRjZjjQCjabgI[eApRF~@<\ngNtDHpxUpRjZjjQCjabgI[eApRF~@>\ngNtDJqHJPRZzj@CiQK_Guv}`=\ngNtHH`xIUMUTAtpqrVk[gAHZEaZP=\ngNtHH`xYIHYU@At`fobF{^p=\ngNtHHaxYIHXE@AoYm[H[m{@=\ngNtH`iPBYrSWUPRH]JIkxanwl+\ngNtH`iPBYrSWUPRH]JIkxanwl-\ngNtI@]P[ldadjj@zHlv]gASfygUvaX_v`@\ngNtI@iPSdfnj`@zTSWqC]oX=\ngNtIHaxB\\ddLj`@zPSWqC]oX=\ngNtI`]PB]qgIHYFj`NbKMVwLvmtKC~t@\ngNtI`iPBYreIkjh@NeDu|Pw[v=\ngNtI`iPBYreIkjj`NkGIZmrTyKV~HZEa@\ngNtLJqDJHtQdTaeTpGRbT\ngNtLJqHJPtadTaeT@GTc]W[v=\ngNtLJqHJPtadTaeTpGRbT\ngNtLJqHJPtadTaeTpGRbZznwl\ngNtLJqHJPtadTaeTpGRbZznwt\ngNtLlQHR`TaNLiM]UTAtXyjwNSdmuPlO{S@\ngNtLlQHR`TaNLiM]UTAtXyj{NSdmuPlO{S@\ngNtLlQHR`TaNLiM]UTAthzsdyK]Wk{~tp\ngNtLlQHR`TaNtiM]U@AuHyr\\unkm}ZX\ngNtLlQHR`TaNtiM]ULAtXyj{NSdmu^lO{S@\ngNtLlQHR`TaNtiM]ULAthzsdyK]Wk{~tp\ngNtMLQHR`TaNRZzjhCiQugIrVzoWw}i`\ngNtMLQHR`TaNRZzjhCiQugIsVznww}i`\ngNt`CPdfzZj@zt\\moFD\ngNt`CPdfzZj@zt\\moGx\ngNt`EPTfzZjfPzt\\mshiK^LH<\ngNt`EPTfzZjfPzt\\mshiK^LH>\ngNt`hPiJyInfj`NcGMVwUBpdbZ[R@\ngNt`hPiJyInfj`NcGMVwUBpmH\ngNtdLx`DTHrRRqZdCiAM]W[v\ngNthJx`DYIHXmLAu`zK_DMv~`\ngNthLX`DYIHXmTAtPyjvzhVG}i`=\ngNthLX`DYIHXmTAtPyjwNSdmuPlO{S@\ngNthLX`DYIHXmTAt`znkm{ZX=\ngNthMX`DYIHXmTAtPyLvzHVG}i`\ngNthMX`DYIHXmTAtPyLvzHW{}i`\ngNthMX`DYIHXmTAu`zM_DMv~mL\ngNthMX`DYIIXm@Au@wUv}`\ngNthejqHJWrSSUSRH]ZJRwaC~tP<\ngNthejqHJWrSSUSRH]ZJRwaC~tP>\ngNtiLPiPSdfnjj@zT]Yr\\enku}ZX\ngNtiLPiPSdfnjjdPzT]YhTyKVzoWw}i`-\ngNu@DPdwSUPGQcfk[jaXP\ngNu@DPdwSUPGQcfk[jaX_rQMH\ngNu@DPdwSUPGQcfk\\zJ\\wUBp`\ngNu@DPdwSUTtGQcfk\\fJ\\enjEa@<\ngNu@DPdwSUTtGQcfk\\fJ\\enjEa@>\ngNu@DPdwSUTtGQcfk\\zJRwUBp`<\ngNu@DPdwSUTtGQcfk\\zJRwUBp`>\ngNu@DPdwSUTtGQcfkkjaXP<\ngNu@DPdwSUTtGQcfkkjaXP>\ngNuHDz@aIkjiiDNmGI\\dLTuoBD<\ngNuHDz@aIkjiiDNmGI\\dLTuoBD>\ngNuHDz@aIkjiiDNmGI\\zJZwaB<\ngNuHEhOCIIKFh@NhFznwl=\ngNx@@dju\\@GTc]W[v=\ngNx@@dsSUPGSbgIZmn\\DahVD\ngNx@@dsSUPGSbgIZmshis\\xICPlH\ngNx@@dsSUPGSbgQZmn\\DahVD\ngNx@@dsSUPGUddmVwhwmdMBp`\ngNx@@dsSUPGUddmVwhwndMBp`\ngNx@@dsUUTbGSbgIZmn\\DahVD<\ngNx@@dsUUTbGSbgIZmn\\DahVD>\ngNx@@dsUUTbGSbgIZmrPqSfypRFaXP<\ngNx@@dsUUTbGSbgIZmsPqSdms`dMBp`<\ngNx@@dsUUTbGSbgIZmsPqSdmsoDMBp`<\ngNx@@dsUUTbGSbgIZmsPqSdmsoDMBp`>\ngNx@@dsUUTbGSbgIZms`qs\\xICPlH<\ngNx@@dsUUTbGSbgIZms`qs\\xICPlH>\ngNx@@dsUUTbGSbgIZmshis\\xICPlH>\ngNx@@dsUUTbGSbgQZmn\\DahVD<\ngNx@@dsUUTbGSbgQZmn\\DahVD>\ngNx@@dsUUTbGSbgQZmsPqSdms`dMBp`<\ngNx@@dsUUTbGSbgQZms`qs\\xICPlH<\ngNx@@dsUUTbGSbgQZms`qs\\xICPlH>\ngNx@@dtuT@GVcdms`dMv}`=\ngNx@@dtuT@GVcdms`dMv~`\ngNx@@dtuT@GVcdn\\FM[gAH[m}@\ngNx@@dtuT@GVchus`dMv}`=\ngNx@@dtuT@GVchus`dMv~`\ngNx@@dtuT@GVchvSENZwNBPw[z\ngNx@@dtuTDbGVcdms`guv}`+\ngNx@@dtuTDbGVcdms`guv}`-\ngNx@@dtuTDbGVcdn]EM[gAH[m}@<\ngNx@@dtuTDbGVcdn]EM[gAH[m}@>\ngNx@@dtuTDbGVcdus`dMv}`+\ngNx@@dtuTDbGVcdus`dMv}`-\ngNx@@dtuTDbGVchv]EM[gAH[m}@<\ngNx@@dtuTDbGVchv]EM[gAH[m}@>\ngNx@@dtuTpGSbgIZms`qK\\xIC^lH\ngNx@@dtuTtbGQbkIkgAH[m}@>\ngNx@@dtuUPGSbgIZmn\\DahVD\ngNx@@dtuUPGSbgIZmrpqSdm[gAHZEa@\ngNx@@dtuURbRGSbgIZmshiK\\xICPlH>\ngNx@@dtuURbTGSbgIZmshiK\\xICPlH>\ngNx@@dtuUTRGSbgIZms`qK\\xICPlH<\ngNx@@dtuUTRGSbgIZnn\\DahVD<\ngNx@@dtuUTRGSbgIZnn\\DahVD>\ngNx@@dtuUTbGSbgIZmrXiKVypRFaXP<\ngNx@@dtuUTbGSbgIZmrXiKVypRFaXP>\ngNx@@dtuUTbGSbgIZmsPqRVms`dMBp`<\ngNx@@dtuUTbGSbgIZmsPqRVms`dMBp`>\ngNx@@dtuUTbGSbgIjmn\\DahVD<\ngNx@@dtuUTbGSbgIjmn\\DahVD>\ngNx@@dwPUPGQrVk[t[VrFaXP\ngNx@@dwPUPGQrVk\\zJ\\whvndMBp`\ngNx@@dwPUPGQrVkkt[VrFaXP\ngNx@@dwTuPGSbgIZmobFaXP\ngNx@@dwTuPGSbgIZmshis\\kiCPlH\ngNx@@dwTuPGUedmVwhvmdMBp`\ngNx@@dwTuPGUedmVwhvndMBp`\ngNx@@dwTuPGUedmVwhzmdMBp`\ngNx@@dwTuPGUedmVypTyoQu]HZEa@\ngNx@@dwTuPGUedmVytTyoQm]HZEa@\ngNx@@dwTuPGUedmWWhvmdMBp`\ngNx@@dwTuPGUedmWWhvndMBp`\ngNx@@dwTuPGUedmgWhvmdMBp`\ngNx@@dwTuPGUedmgWhvndMBp`\ngNx@@dwTuPGUedugWhvmdMBp`\ngNx@@eSUUPGUEDmVwjwmdMBpm@=\ngNx@@eSUUPGUEDmVwjwndMBpm@\ngNx@@eSUUPGUEDmVwj{ndMBpm@=\ngNx@@eSUUPGWCENRu[^hNBPtKB\ngNx@@eSUUPGWCENRu[^hNBPtKC~t@=\ngNx@@eSUUPGWCENRu[^hN|PtKC~t@\ngNx@@eSUUPGWCENRu[gASf}P]xahVG}h@\ngNx@@eSUUPGWCENRu[gAcf}P\\DahVG}h@\ngNx@@eSUUPGWCENRu]gAcV}P\\DahVG}h@\ngNx@@eSUUPGWCENbu[^hNBPtKC~t@\ngNx@@eSUUPGWCENcV]^hNBPtKC~t@\ngNx@@eSUUTBGWCENRu[gASf}P]xahVD<\ngNx@@eSUUTBGWCENRu[gASf}P]xahVD>\ngNx@@eSUUTBGWCENRu[gAcf}P\\DahVD<\ngNxA@IRZZj@CkQrVypRF{^p=\ngNxA@IRZZj@CkQtZypRF{^p=\ngNxA@IRijjhCkabgIZmoTGAHZEa@\ngNxA@IRijjjACkabgIZms`is^hN|PtKB<\ngNxA@IRijjjACkabgIZms`is^hN|PtKB>\ngNxA@IRjZj@ChaSdmz`xIC]oX=\ngNxA@IRjZjhCkabgIZmoTGAHZEa@\ngNxA@IRkijhCjbRVk[v[vrFaX_v`@\ngNxA@IRkijhCjbRVk[v]vrFaX_v`@\ngNxA@IRkijhCkabgIZmshis\\{qCPlO{P@\ngNxA@IRkijhCkabgQZmrPqrV}g\\DahVG}h@\ngNxDD@b^BSWMPRH]JIkxanwl+\ngNxDD@b^BSWMPRH]JIkxanwl-\ngNxDDDR^BSWMPRH]JIkxanwl+\ngNxDDDR^BSWMPRH]JIkxanwl-\ngNxDHDQHbS]UU@]VNRu[_DMBp`\ngNxDHGBnBUSUURH]LLTyJz}P\\DaofD<\ngNxDHGBnBUSUURH]LLTyJz}P\\DaofD>\ngNxDHOANBS]UU@]VNRu[^cr|PtKC~RAamH\ngNxDHOA^BS]UU@]VNRu[\\cqCPlOyHFFt`\ngNxDHOA^BS]UU@]VNRu[^cr|PtKC~RAamH=\ngNxDHOA^BS]UU@]VNRu[_DMBp`\ngNxDHOA^BS]UU@]VNRu[_DMBpd`XP\ngNxDHOA^BS]UU@]VNRu[_DMBpd`X[R@=\ngNxDL@aNBSMTu@]VRRu[^c^vPtKB\ngNxE@jCT@eJfjj`NjFIZmobFaXP\ngNxEHBqE`eInjjiDNkGIZmnUxahVG|dCB<\ngNxEHBqE`eInjjiDNkGIZmnUxahVG|dCB>\ngNxEHOA^DeInfj`NkGIZmnQtahVG|dCCZP\ngNxEHOA^DeInfj`NkGIZmnUxahVG|dCCZP\ngNxHAjAJfjj`NfFJRu[\\hICPlO{P@\ngNxHAjAJfjjhDNfFJRu[\\hICPlH>\ngNxHAjAJfjjhDNfFJRu[gAcfyWbFaXP<\ngNxHAjAJfjjhDNfFJRu[gAcfyWbFaXP>\ngNxHD@aIkjhIDNeDm|Pw[v-\ngNxHD@aInfj`NkGIZmobFaXP\ngNxHD@aInij`NkKIZmoQm[HZEa@\ngNxHDOAInjjiDNkGIZmnQxahVD>\ngNxHH@aIfjj`NgENRu[gQSf}GlDahVG}i@\ngNxHHGAIfjj`NgENRu[\\xICPlOyHEFt`\ngNxHHGAIfjj`NgENRu[^cvBPtKC~RAQmH\ngNxHHGAIfjj`NgENRu[^cvBPtKC~t`\ngNxHHGAIfjjiDNgENRu[^cvBPtKB<\ngNxHHGAIfjjiDNgENRu[^cvBPtKB>\ngNxHHGAJijj`NnFJ\\ejv}P\\DahVG}i@=\ngNxHHGAJkjh@NlGQkgAH[m{@=\ngNxHHGAJkjj`NfENRu[\\xICPlH\ngNxHHOAJkfh@NlGQkgAH[m{@=\ngNxHHOAJkfh@NlGQkgAH[m}@\ngNxHHOAJkfhHDNlGIkgAH[m{@+\ngNxHHOAJkfhHDNlGIkgAH[m{@-\ngNxHHOAJkfhHDNlGIkv]pRF}_P+\ngNxHHOAJkfhHDNlGIkv]pRF}_P-\ngNxHHOAJkfj`NfENRu[\\xICPlH\ngNxHHOAJnjjhDNfENRu[\\{qCPlH<\ngNxHHOAJnjjhDNfENRu[\\{qCPlH>\ngNxHJIAIiji`NcEVRwN|_W[v\ngNxHaJ@SNRZZj@CkQrVypRF{^p=\ngNxHaJ@SNRZZj@CkQtZypRF{^p=\ngNxHaJ@SNRZZj@CkQtZypRF}_P=\ngNxHaJ@SNRZZj@CkQt[MbgIZwNBPwkz=\ngNxHaJ@SNRZZj@CkQt[NCFms`dMv~`\ngNxHaJ@SNRZZjBQCkQrZypRF{^p+\ngNxHaJ@SNRZZjBQCkQrZypRF{^p-\ngNxHaJ@SNRZZjBQCkQrZypRF}_P+\ngNxHaJ@SNRZZjBQCkQrZypRF}_P-\ngNxHaJ@SNRZZjBQCkQt[Nbfms`dMv~`<\ngNxHaJ@SNRZZjBQCkQt[Nbfms`dMv~`>\ngNxHaJ@SNRZZjjQCiqSdmVyLTek\\xICPlH<\ngNxHaJ@SNRZZjjQCiqSdmVyLTek\\xICPlH>\ngNxHaj@SnrRFPJhChyKUu{MkYCPlO{P@=\ngNxHaj@SnrRFPJhChyKYu{MkYCPlO{P@=\ngNxHaj@SnrRFPJhChyKYv]EN[v[WRFaX_v`@\ngNxHaj@SnrRFPJhChyMYu{MkYCPlO{P@=\ngNxHaj@SnrRFPJhChyMYu{MkiCPlO{P@\ngNxHhG@]IR[jZhCiqSdmVwJzPtKC~RAamH\ngNxIAJB\\dtuT@GVchus`dMv}`=\ngNxIAJB\\dtuT@GVchus`dMz~`=\ngNxIAJB\\dtuTDbGVcdus`dMz~`+\ngNxIAJB\\dtuTDbGVcdus`dMz~`-\ngNxIAjC\\dwTuPGUedugWhzmdMBp`\ngNxIHGBRdwTuPGSbgIZmoQy]HZEaI@pvd@\ngNxIHO@ReUuT@GVChus`dMv}`=\ngNxIHO@ReUuTDBGVCdus`dMv}`+\ngNxIHO@ReUuTDBGVCdus`dMv}`-\ngNxIHOBReUsT@GVChus`dMv}`=\ngNxIHOB\\eUsT@GVChu{NxIC]oX=\ngNxLHGBnC\\Djfjj@zhXirV}P\\Daogx\ngNxLHGBnC\\Djnjj@zHTyK\\xIC_Op\ngNxLHGBnChDjfjjdPzhXirVyP\\Dao`<\ngNxLHGBnChDjfjjdPzhXirVyP\\Dao`>\ngNxLHOANF\\DfZjjdPzlTejvywbFaXP<\ngNxLHOANF\\DfZjjdPzlTejvywbFaXP>\ngNxLJHaQFbLbdLj`@zd[j{^p\ngNxLJIARFdLbdLj`@zd[j{^p\ngNxLJIARFdLbdLj`@zd[j{_P\ngNxLJIARFdLbdLjf@zTSWUv}`\ngNxLJIARFdLbdLjf@zTSWUv~`\ngNxLJIARFdLbdLjf@ztRmoFD\ngNxLJIARFdLbdLjf@ztRnoFD\ngNxLJIARFdLbdLji@zTSWUv}`\ngNxLJIARFdLbdLji@zTSWUv~`\ngNxLJIARFdLbdLji@zTSWUz~`\ngNxLJIARFdLbdLji@ztRm@\ngNxLJIARFdLbdLji@ztRmoGt\ngNxLJIARFdLbdLjja`ztRmoFD<\ngNxLJIARFdLbdLjja`ztRmoFD>\ngNxMHOANF\\IJSMMU@]VJRu[\\{qCPlO{R@\ngNx`BDdwSUPGQcfk[jaXP\ngNx`BDdwSUPGQcfk[jaX_rQMH\ngNx`BDdwSUPGQcfk\\zJ\\wUBp`\ngNx`BDdwSUPGQcfskjaXP\ngNx`BDdwSUTtGQcfk[ja_`<\ngNx`BDdwSUTtGQcfk[ja_`>\ngNx`BDdwSUTtGQcfk\\zJRwUBp`<\ngNx`BDdwSUTtGQcfk\\zJRwUBp`>\ngNx`BDdwSUTtGQcfkkjaXP<\ngNx`BDdwSUTtGQcfkkjaXP>\ngNx`DBdwSUPGQcfk[jaXP\ngNx`DBdwSUPGQcfk\\zJ\\wUBp`\ngNx`DBdwSUTtGQcfk[ja_`<\ngNx`DBdwSUTtGQcfk\\zJRwUBp`>\ngNx`bDnLiMtuTAtXyjvzhVD\ngNx`hEIWIMtuTAuXyKUm|PtKC~t`\ngNx`hEIWIMtuTAuXyKUm|PtK}~t`\ngNx`hEIWIMtuTAuXyKUu|PtKC~t`\ngNxaBDYR[ijhChqsUmuPlH\ngNxdMD@baFRRFKU@]DNSMobF~X_vf@\ngNxdMD@baFRRFKU@]DNSNobF~X_vf@\ngNxdMD@baFRRVKT`]HIkj{^p\ngNxhKD@cIICEh@NdDm|Pw[v\ngNxhMD@cIICEj`NjGIZmobFaX_vf@=\ngNxhMD@cIICEj`NjGIZmoczaX_vf@=\ngNxhMD@cIICEj`NjGIZnobFaX_vf@\ngNxhMD@cIICEj`NjGIZnsdyk_DMBpmL\ngNxhMD@cIICEj`NjGIjmobFaX_rQMMi`=\ngNxhMD@cIICEj`NjGIjmobFaX_vf@=\ngNxhMD@cIICEj`NjGIjmobFa_ovf@\ngNxhMD@cIICEj`NjGIjmsdyK_DMBpmL\ngNxhMD@cIICEj`NjGIjnobFaX_vf@\ngNxhMD@cIICEj`NjGIjnsdyk_DMBpmL\ngNxhMD@cIICEj`NjGIkMobFa_ovf@\ngNxhMD@cIICEj`NlGQ[xaoWw}i`=\ngNxhMD@cIICEj`NlGQkxanwo}i`=\ngNxhMD@cIICEj`NlGQkxanww}i`\ngNxhMD@cIICEj`NlGQkxaoWw}i`=\ngNxhMD@cIIKEh@NhFznwl=\ngNxhMD@cIIKEh@NhFznwt\ngNxhMD@cIIKEh@NhFzoWt=\ngNxhMD@cIIKEh@NhGNSfmu]oh\ngNxhMD@cIIKEi`NbDmVyr\\enkua@\ngNxhMD@cIIKEi`NdDv\\gI[j}^p\ngNxhlEJB]iRZzj@CiQM_DMv}mL=\ngNxhlEJB]irJPrj@CjQnkm{@=\ngNxhlEJB]irJPrj@CjQomz{^p=\ngNxhlEJB]irJPrj@CjQsdyk]W[z\ngNxiMD@c]ddebt@GTC]W[v=\ngNy@BDfZZj@zlTyjv~pZEa@\ngNy@BDfZZjb`zlTyjwNbdm}`tKB>\ngNy@BDfZZjb`zlTzjwNbdm}`tKB>\ngNy@BDfZjjTR`zlTzjwNCDm}`tKB>\ngNy@BDfZjjdPzlTyjv~pZEa@>\ngNy@BDfZjjdPzlTyl{NbgM}`tKB<\ngNy@DDffjjdPz\\TyKUn]EI[gAHZEaZH<\ngNy@DDffjjdPz\\TyKUn]EI[gAHZEaZH>\ngNy@DDfnj`dPzTRwqC]oX+\ngNy@DDfnj`dPzTRwqC]oX-\ngNy@DDfnj`dPzTRwq}]oX-\ngNy@DDfnj`dPzTRytTuobF{_P>\ngNy@DDfnj`dPzTSWqC]oX+\ngNy@DDfnj`dPzTSWqC]oX-\ngNy@DDfzZj@zl\\ejv~HZEa@\ngNy@DDfzZj@zl\\ejv~HZE~@\ngNy@DDfzZj@zl\\ejwNbfm|PtK|\ngNy@DDfzZj@zl\\ejwNbgM|PtKB\ngNy@DDfzZj@zl\\ejz~HZEa@\ngNy@DDfzZj@zl\\ej{Nbfm|PtKB\ngNy@DDfzZj@zl\\elz~HZEa@\ngNy@DDfzZj@zl\\flz~HZEa@\ngNy@DDfzZjfPzl\\ej{NbgM|PtKB<\ngNy@DDfzZjfPzl\\ej{NbgM|PtKB>\ngNy@DDfzfj@zl\\ejv~HZEa@\ngNy@DDfzfj@zllejv}FulahVD\ngNy@DDfzjjdPzl\\ejv~HZEa@<\ngNy@HDfZjjdPz\\TyKUms`dMBp`<\ngNy@HDfZjjdPz\\TyKUms`dMBp`>\ngNy@HDfZjjdPz\\TyKUn]EN[g^HZEa@<\ngNy@HDfZjjdPz\\TyKUn]EN[g^HZEa@>\ngNy@HDfZjjdPz\\TzKUms`dMBp`<\ngNy@HDfZjjdPz\\TzKUms`dMBp`>\ngNy@JDffj`@zt\\en\\Danwl\ngNy@JDffj`@zt]Fn\\Danwl\ngNy@JDffji@zLUYK\\xIC]oX\ngNy@JDffjjTRPzlTyJwNbfm}`dKB<\ngNy@JDffjjTR`zlTyJwIcdm[{AOfD<\ngNy@JDffjjTR`zlTyJwNbfm}`dK|<\ngNy@JDffjjb`zlTyJv~pREa@<\ngNy@JDffjjb`zlTyJv~pREa@>\ngNy@JDffjjb`zlTzLv~pREa@<\ngNy@JDffjjb`zlTzLv~pREa@>\ngNy@hAteInij`NgENRu[_DMBpmH\ngNyAHIJSMMU@]NJ\\ejwNbgMsoDMBpmH\ngNyDGQDJHRZzjXCkQrWNSfmxP`\ngNyDGQHJPRZzjXCkQrV|HP\ngNyDGQHJPRZzjXCkQrV|O`\ngNyHE@DYICHuU@auPyKUm|PtKB<\ngNyHE@DYICHuU@auPyKUm|PtKB>\ngNyHE@DYIHXmA@at`eobF{^p+\ngNyHE@DYIHXmA@at`eobF{^p-\ngNyHEAxIU\\uTAtPjrVywcz{__vb@\ngNyHEAxIU\\uTAtpitZk[gAHZEaZH=\ngNyHEAxYIHXuA@at`fobF{^p+\ngNyHEAxYIHXuA@at`fobF{^p-\ngNyHKAxIU\\u@Au`zM\\xIC]oX\ngNyHdIPSeJSSUP@]ZNcYpXun\\Danww}h`\ngNyHdIPSeJSSUS@]FJmFs`qK\\xIC^oo{Q@\ngNyHdIPSeJSWUPRH]JIkxanwl+\ngNyHdIPSeJSWUPRH]JIkxanwl-\ngNyHdIPSeJSWUPRH]JIkxanwt<\ngNyHdIPSeJSWUPRH]JIkxaoWt+\ngNyHdIPSeJSWUPRH]JIkxaoWt-\ngNyHdIPSeJSWUPRH]JIlyNZwqC]oh<\ngNyHdIPSeJSWUPRH]JIlyNZwqC]oh>\ngNyIDIPSdffjj@z\\TzMUv\\FI[gAHZEaZH\ngNyIDIPSdfnj`dPzTSWqC^oh+\ngNyIDIPSdfnj`dPzTSWqC^oh-\ngNyIDMP[dfzfj@zl\\ej{IbgI[e]HZEa@\ngNyLGQDJHtQdTaeTpGRbT\ngNyLGQDJHtQdTaeUHGRbT\ngNyLGQHJPtadTaeTpGRbT\ngNyLGQHJPtadTaeUHGRbT\ngNyLGQbKDvIdTaeTpGRbT\ngNyLcaHR`TaNLyEHYU@AuHyr\\enku}ZD\ngNyLcaHR`TaNLyEHYU@AuHyr\\unkm}ZD\ngNyLcaHR`TaNLyEHYULAtXejwNSdmxpmB\ngNyLcaHR`TaNLyEHYULAtXej{NSdmxpmB\ngNyLcaHR`TaNLyEHYULAthfsdyK]Wk{~tH\ngNy`JDTfzZjfPzt\\moFD>\ngNydMDpDTHrRPqZhCkAr[NSdmtPww{S@\ngNyhCE`DYIIXmTAtPejwNSdmuPlO{P`\ngNyhCEaxYIIXuTAtPejvzhVG}hP=\ngNyhKEaxYIIXuUBau`e[^LH>\ngNyhKEaxYIIXuUBau`e[^Op>\ngNyhKEaxYIIXuUBau`e]^LH<\ngNyhKEaxYIIXuUBau`e]^LH>\ngNyhMEPDYIHXmTAtPyLvzHVG}i`\ngNyhbEiPScNQRFUS@]FIZms`yK^LO{P`\ngNzHHlZGAJijj`NdFUu]oo{R@\ngN|@@ZeSUUPGVEEu|n{kC~t@=\ngN|@@bdwSUPGQefk[d[WZEa@\ngN|@@bdwSUPGQefk\\zJ\\wHvntKB\ngN|@@mdTaeT@GTc]W[z\ngN|DEbHb^FQRFPU@]XmVwJwmtKC~tH=\ngN|LlZIBTBdIqeIkjj`NmGKlyNRwcC~tp\ngN|LlZIBTBdIveIkjjPNmGK\\yNRmL\ngN|`hZEIWIMtuTAuhy[^LO{R@\ngN|`hZEIWIMtuTAuhy]^LO{R@\ngN}HEcAxIU\\uTAtPijvzhVG}h`=\ngN}HEcAxYIIYATAubu[gArVyV}naX_va@\ngN}HebIPSeJSSUS@]FJZmsXirVmu^lO{Q@\ngN}HebIPSmJSSUURH]FJZmsXirVmuPlO{Q@+\ngN}HebIPSmJSSUURH]FJZmsXirVmuPlO{Q@-\ngN}HebIPSmJSSUURH]JJlvJ\\ek]Wk{~tP+\ngN}HebIPSmJSSUURH]JJlvJ\\ek]Wk{~tP-\ngOp@DjfVjjdEDNnFJ\\ejwMBgIZwjCoDMB_die`<\ngOp@DjfVjjdEDNnFJ\\ejwMBgIZwjCoDMB_die`>\ngOp@DjfVjjdEHNnFJ\\ejwMBgIZwjCoDMB_die`>\ngOp@DjfVjjdEHNnFJ\\ejwMCGIZwj}oDMB_die`<\ngOp@DjzfZj`NnFJ\\ejv}g\\DahVG|dLl\ngOp@LdadMBj`NcdmVwlvmdMBpdmc`=\ngOp@LdadMBj`NcdmVwlvmdMB_dmc`=\ngOp@LdadMBj`NcdmVytTuoYm]HZEaI[G@\ngOp@LdadMBj`NcdmWWlvmdMBpdmc`=\ngOp@LdadMBjidNcdmVwlvmdM|pdmc`+\ngOp@LdadMBjidNcdmVwlvmdM|pdmc`-\ngOp@LdadMBjidNcdmWWlvmdM|pdmc`+\ngOp@LdadMBjidNcdmWWlvmdM|pdmc`-\ngOpB@xQpSagCIIKHjhHCjAoYy^wku}KCSH`=\ngOpBADQpSagCHiCEjhHCjQnU{^oWw|eLl=\ngOpL@xQpSaddadUTDAt`foYy^H[u}ICS@=\ngOpMAxZ`M@IRj[Fjj@zhXijv}P]x~hVG|dml\ngOp`@dfzMZj`NkGIZmobFaX_rVqp\ngOp`@dfzMZj`NkGIZnobFaX_rVqp\ngOp`@dfzMZjidNkGIZmobF~X_rVqp<\ngOp`@dfzMZjidNkGIZmobF~X_rVqp>\ngOp`@dfzMZjidNkGIZnobF~X_rVqp<\ngOp`@dfzMZjidNkGIZnobF~X_rVqp>\ngOphH`DYIHYVmU@]TNSU[_DMBpdck`\ngOq@@dsQkUTAtxitVk[gAHZEaI[G@\ngOq@@eMtUTEIAuhiK\\hIC]o_yHYx+\ngOq@@eMtUUUIAtxirVk[eAHZEaICO@<\ngOq`@bdwQkUUMAtXyjvzhVG|el\\<\ngOt@@TjZkjj`NfFJ]U[gAcfyP\\FaX_rQuuh@\ngOu@DPdwU[UTAtXyjvzhVG|d]\\\ngOx@@eSQmUTAupqSdmVwjC`dMBpdmckP@=\ngOx`hEIWIMtZuU@]VNRu[_DMBpdmckR@\ngOxhMD@cIICJujhCjarZk[xahVG|d]]ZX=\ngOxhMD@cIICJujjYCjarZk[xahW{|d]]ZX\ngOy@DDfzMZj`NkGIZmobFaX_rVqp\ngOy@DDfzMZj`NkGIZnobFaX_rVqp",H),i=1&t?zf.AJb("26,60,96,180\n42,68,91,94\n147,176\n170,261\n210,231,244,267\n59,180\n26,30,38,55,81,96,118,180\n0,54,58,90\n0,55,90\n0,59,68,73\n0,57,77,180\n0,40,90\n0,31,35,46,68\n24,29,55,90\n1,47,51,56,70,75,78,85,88,90\n12,33,67\n0,38\n3,180\n0,44,61,87,90\n27\n0,14,29,35,61,78\n11,28,33,45,55,57\n57,61,63,90,145,148,180\n180\n0,40,47,51,72,179\n0,58\n0,52\n39,60,76,180\n51\n54,59,305\n47,50,66,311\n0,4,62\n63,84,125,163,180\n2,18,56\n60,94,178,180\n52,92,149,178\n42,82,160\n42,79,161\n67,180\n56,166,180\n51\n51\n61,174,180\n42\n0,2,28,174,180\n46,76,163\n60,88,180,208,306\n61,76,304\n0,7,10,13,60,82\n0,60\n3,37,57,60,97,129,180\n0,10,28,136,165,180\n59,61,63,71,169,180\n44,76,165\n44,75,165\n26,47,62,64,68,71,167,186,274,280,301\n27,43,49,55,68,74,145,169,184,190,283,297,301\n24,39,45,58,74,146,184,202,276,302\n47,52,149,162,179,285,287,308\n46,69,180\n40,43,77,158,180\n42,78,80,169\n42,44,49,62,68,156,178,180\n42,47,55,59,81,84,161,178,180\n170\n0,29,57\n180\n2,11,15,44,76,87,90\n0,24,43,76,90\n3\n0,10,18,21,37,44,64\n59,180\n50,72,175,180\n57,180\n58,180\n58,90,150,159,164,168,176,180\n0,3,30,60,64,75,94,123,154,180\n59\n46,52,72,168,172,180\n43,75,164,180\n50,72,172,195,284,315\n45,173,177,180,199,291,315\n170\n16,47,74,166\n53,100,159,180\n43,71,74,111,122,125,180\n31,49,64\n132,171\n32,58,334\n29,58,337,339\n56,180\n54,67,177\n58,160,180\n180\n41,80,173,180\n48,63,84,118,179\n3,41,73,147,166,179\n41,60,72,161,176,180\n48,51,53,78,157,194,282,316\n32,50,81,155,161,166,192,206,280,286,315,325,328\n59,180\n50,60,66,82,158,180\n61,179\n60,180\n48,74,168\n50,85,159,199,220,297,315,351\n61,71,77,83,90,173,193,284,300\n308\n308\n68,192,305\n59,169,174,180\n53\n62\n0,3,9,23,26,28,49\n52,60,62,180\n33,55,180\n35,56\n28,34,53,311\n185,288,290\n0,9,34,37,57,75,77,90,95,102,125,139,142,162,180\n17,62,77,170\n48,76,167,180\n54,58,65,180\n63,80,82,180\n45,48,72,167,179\n59,180\n56,70,74\n18,67,106\n56,180\n56,180\n50,180\n180\n65,186,299\n175\n52,189,191,221,287\n56,175\n62,177\n65,175\n51,72,90,138,181\n188,214,294\n192,226,296\n201,224,275,289\n48,68,77,174,180\n71,299\n44,52,57,59,61,75,298,321\n60,180\n41,73,88,164,180\n59,180\n47,57,60,63,165,167,171,181,287,311\n51,77,80,161,188,204,279,303\n303\n59,180\n61,180\n48,75,167,171,180\n65,183,290,305\n66,178,303\n54,70,178,191,303\n66,181,304\n62,178,194,304\n64,182,309\n53,294\n61,180\n60,180\n60,160,180\n41,45,54,68,93,159,180\n44\n39,55,162,180\n0,35\n0,10,64,92,141,180\n0,6,34\n8,46\n0,22,27,29,42,45,69,90\n0,31,180\n0,29,49,72,98,142,170,179\n42,71,163\n55,172,180\n56,179,295\n60,180\n60,180\n60,180\n43,64,175,191,289,296,303\n45,67,168,176,185,287\n59,178,303\n62,180,301\n53,60,68,70,108,165,289,295,302,305,328\n44,48,51,55,59,64,67,71,75,108,289,294,297,304,308,321\n0,5,41,106\n163,180\n0,15,17,70\n0,20,35,123,180\n61,180\n0,180\n0,20,53,55,75,84\n23,41,60,84,106,138,157\n17,34,53,82,90\n0,10,20,36,46,50,62,66,90\n0,59,61,107,123,180\n13,17,19,33,36,90\n1,31,36,56,58,70,77,90\n0,12,19,27,40,45,48,57,60,68,70,84,109,118,124,128,131,137,157,160,180\n7,54,67,85,90\n2,34,61,65,92,95,106,130,139,144,151,159,173,177\n2,25,28,65,87,109,180\n0,9,66,77,111,114,117,158\n13,34,72,90\n48,63,70,77,90,105,120,134,161,164,179\n0,14,30,54\n17,39,52,57,63,85,151,172,180\n30,51,53,59,69,71,114,136\n2,28,44,66,94,110,113,139,178\n14,34,65,79,136,211,235\n15\n28,35,45,179\n0,60,78\n12,26,40,83,86,105,126,129,137,155,180\n40,110,129,149,180\n24,57,69,180\n180\n62,180\n180\n0,32\n0,31\n0,25,30\n68,180\n66,82,180\n59,83,90,93,104,107,113,120,164,166,180\n55\n56\n0,56\n66,180\n47,77\n45,71,73,148,180\n48\n0,10,58,66,180\n0,7,56\n15,112,130,156,180\n118,147\n0,59,120,180\n123\n13,46,65\n15,44,66\n14,41,62\n17,46,63,65\n93,128,132,159\n0,93,123,149,153,168\n0,4,9,15,17,24,32,45,68\n1,44\n80,86,98\n76\n94,100,111,128,180\n89\n60,77,80,86\n0,14,84,106\n86\n63,164,173,177,180\n61,77,80,157,171\n62,180\n0,14,68\n64,70,81,147,168,180\n59,61,109\n51,53,77,124,179\n180\n60,63,71,92,180\n47,72,114\n87,103,180\n85,109,150,180\n54,73,148,167\n114,180\n43,60,80\n0,50,84\n66,180\n67,180\n60,180\n163,180\n133,140,142,145,147,162,165,169,180\n15,114\n68,88,180\n65,180\n97,180\n62,97\n65\n62\n79,176,180\n65,180\n122,163,179\n0,62,128,171\n0,36\n1,39\n137,152,180\n0,26,56\n70,180\n90,114,153,170,180\n78,97,116,129,142,154,180\n0,56\n45,61,76,96\n59,94\n66,180\n180\n46,63,66,69,79,83\n73,75,122,180\n85,91,157,162,175,180\n53,75,78\n74,126,180\n178,180\n68,180\n71,136,154,163,173,175\n68,111,119,175,179\n0,12,57,76\n3,58,62,163,180\n62,65,67,79,85,163,180\n45,48,72,146,169,180\n106,121,123\n69,78,180\n180\n180\n16,54,77\n74,164,167,179\n65,180\n66,180\n65,180\n180\n55,67,74,180\n48,66,87\n180\n180\n68,180\n69,96,99,115\n180\n72\n73,180\n72,91\n72,94\n86\n89\n78,106,180\n82,91,100,180\n0,28,31,39\n0\n100,113,116,163,180\n117,137,148,158,180\n0,76,78,108\n0,6,69,105\n0,46,71,73,76,117\n68,180\n59\n69\n73,92,111,155,161,168\n0,28,49,64,88\n75,92,180\n46\n136\n180\n180\n0,9,121,162\n0,33,82,124\n51,72,78,94,98,115,147,177,180\n11,21,32,58\n14,41,65\n64,180\n61,75,78,180\n57\n56\n0,67,180\n49\n152,154,179\n0,151,180\n34,55,58,66,75,79,82,104,131,164\n0\n0\n160,180\n0\n0\n84,180\n117,134,137,139,180\n125,134,179\n110,116,119,179\n59\n16,58,85\n58,93\n0,57\n77,180\n131,168,180\n22,50,72,86\n48\n77,180\n77,125,141,144,180\n2,47,87\n27,30,51,77\n76,180\n18,55,83\n169,172,180\n62,94\n30,77\n29\n62,156,176\n97,123,180\n144,151,153,156,164,180\n68,96\n47,78,129,148,153,175,178\n119,121,145,148,154,180\n29,36,51,53\n90,110,162,179\n104,107,129,133,179\n104,127,147,159,161,174,180\n88,111,144,166\n57,82,105\n0,55,93\n0,56\n121,156,180\n36,56,80\n68,180\n68\n67,180\n51,179\n39,66,180\n16,25,66,153,180\n67,160\n106,167,171,180\n85,91,105,111,125,132,139,142,178\n59,92\n61\n0,180\n0,26\n0,180\n0,45\n132,138,180\n130,180\n0,33,60\n180\n180\n180\n0,38\n0,27\n180\n180\n79,90,105,135,180\n77,111,145\n77,91,96,120,142,146,150\n77,101,111,121,140,180\n72,180\n180\n65,180\n0,57\n76,88,91,126,166\n32,38\n80\n40\n78,96,98,128,135,147,179\n78,93,112,154,158,172,178,180\n73,180\n8,57\n15,57\n1\n180\n63,180\n67,73,81,84,119,122,166\n0,57\n0,58\n92,180\n112,178\n165,180\n64\n0,180\n180\n0,98,117,129,138,145\n0,125\n12,80,83,116,125,142,146,157,167,170,173,180\n0,12,52,66\n12,32,69\n155,158,180\n64,180\n26,61,76,84,180\n15,56\n0,55,76\n0,54\n63,180\n49,76\n0,38\n0\n180\n180\n180\n0\n0\n180\n180\n70,180\n85,131,180\n95,152,180\n79,81,105,180\n84,106,180\n57\n0,26,52,66\n55\n19,30,73,88\n56\n65,68,180\n85,90,94,96,122,131,176\n171\n45,47\n54,72,82,148,152,180\n81,116,120,180\n81,84,87,104,113,124,129,134,149,167,178\n0,23,42\n29,46,80\n69,139,175\n80,128,142,146,180\n91,123,137,146,154,180\n123,178\n134,180\n21,37,72\n100,109,136,150,179\n6,8,12,14,27,40,119,153,156,180\n0,54,70\n180\n0,121\n180\n65,180\n136,169,171\n0,9,16,56\n1,55,83\n56\n63,180\n54\n63,180\n149,180\n152,180\n56\n62,180\n73,81,170\n47\n180\n89,109,125,127,153,160,180\n106,123,141,151\n0,27,31,69\n56,69,72,93,102,108,117,126,179\n180\n180\n97\n94,108,112,133,167,180\n153,157,165,177\n96,113,123,167,180\n141,155,180\n54\n63,101,123,130,143,148,159,161,164,180\n32\n87,95,97,104,106,149,153,156,163,180\n0,19,57\n83,101,116,133,159,180\n0,67,180\n67,85,173,179\n62\n62,83\n42,57,80,94\n65,81,83,180\n65,180\n42,57,72,178,180\n70,156,180\n83,113,135,149,153,155,161,164\n58,82,180\n74,178\n65,179\n0,25,33,36,40,52,89\n0,180\n0\n0,180\n180\n180\n1,3,36,53,55\n180\n96,102,122,126,145,156\n76,94,110,121\n75,180\n155,171\n23,56\n72,180\n64,180\n57\n59\n73,131,159,174,179\n60\n47\n61,180\n65,78,180\n58\n58\n0,3,180\n180\n6\n201,249,265\n0,4,9,23,28,30,33,86,109\n0,4,28,50,53,72,75,85,87\n0,85\n122,125,167,180\n10,35,37,168\n2,25,28,40,47,65,170\n0,28\n5,11,29\n35,55,85\n60\n1,31,53,261,356\n71\n83,110,183,189,200,215,219\n89\n221,284,312,329\n233\n274,300,307,309,338\n275,277,295,314\n260,289,291,296,305,308\n160,168,180,203,257\n177,196,226\n0,180\n0,104,134,163,170,180\n25,312,341\n24,310,313,332,358\n58,69,73,163,168,174,180\n160,180\n117,166,169\n357\n3,17,23,31,304,320,343,345\n59,187\n63,65\n74,204\n68,71,205,236\n69,204,221,223,242,284,307\n54,72,98,190,209\n281,297,313,338\n219,222,233,283,286,312,336\n279,313,338\n59,80,190,221\n58,78,188\n72,99,183,196\n2,12,17,31,33,41\n1,27\n4,6,35,167\n4,35,153\n30,181,348\n180\n72\n0\n0,21,31,36,38,164,173\n0,16,19,35,52\n1,12,137,158\n11,147\n89\n102\n180\n90\n0\n4,170\n123,134,140,178\n3,5,25,346\n5,341\n32,56,69,84,105,122,161,180\n0,31\n51,90\n69\n60,95,103,107\n90\n90\n0,48\n0,41\n153,180\n32,53\n0,21,30\n46,127,130,143,158,173,180\n0,11,17,90\n0,36,90\n62,137,180\n0,40,60,81,84,90\n37,41,44,49,95,104,118\n54,57,69,74,85,90\n56,90\n59,91,119\n57,90\n0,29\n142,180\n134,137,158,180\n1,57\n3,38\n71,88,95,113,129\n71,78,90\n8,37,56,71,90\n11,42,58,76\n82,103,106,108,123\n46,55,60,64,73,79,90\n27,30,81\n54,97,125,128,152,167,173,178,180\n1,45,61,81,83,86,90\n0,12,35,42,44,80,89\n67,69,91,121,171\n0,32\n13,35,43\n0,47,56,62\n0,11,15,25,28,56,58\n131\n123,144,166,180\n180\n180\n165,180\n0,21\n0,20\n50,90\n67,89,120\n90\n0,33\n59,84,122\n56,64,72,90\n43\n33\n180\n143,162,177,180\n7,28,48,51,54\n2,50\n0,36,46,50,52,54,152\n47,108,134\n57,77,88,118,138\n47\n52,68,85,105\n0,150,154,180\n59,73,107,123,126,129,138,157\n50,119,148\n58,66,86,114,130\n0,3,159,166,180\n44,46,66,104,136,162,180\n52,137\n60,64,74,117,119\n54,72,77,83,90,111,124,141,153\n0,55,85,90,93,96,99,106,129,180\n0,57,72,77,130,180\n63,91,108,152\n15,180\n0,155,168,179\n0,25,175\n70,89\n53\n149,180\n154,165,179\n180\n0,45\n0,39\n70,122,126,180\n50,86,167\n53,123,127,136,142,154\n23,38,53,78,103,172\n0,35,37,44\n0,17,41\n60,75,97,107,139,158\n38,45,49,57,157,180\n40,62,75,81\n0,44\n66,180\n0,34,59,180\n0,63,65,180\n0,74,180\n282,307,334\n305\n68,163,179,246,321\n21,42,55,72,162,180,231,236,242\n52,71\n55,102,113\n177,199,239,290\n155,158,178,201,285\n6,55,318\n10,56,312,354\n30,59,313,358\n0,23,45,47,50,56,58,309,327,335,338,341\n151,194,284\n152,185,279\n12,14,55,312\n15,54,313,358\n49,314\n46,314\n58,80,183,200,280,285,288\n47,61,185,283\n52,68,71,172,297,311\n64,77,144,169,171,300,308\n31,34,37,51\n0,42,46,58,302\n44,312\n0,54,180\n0,56\n182\n76,87,182\n0,52,79\n67,80,153,164,174\n70,76,80,83,85,87,166,186\n52,309\n46,307,325,345\n71,181\n176\n51\n46,49,307\n49,168,182,310,316\n83,130,175\n80,86,92,95,107,128,157,178\n66,180\n74,175\n74,163,175\n181\n181\n32,52,85,123,180,293,295\n201,300\n63,198,299\n50\n4,56,84\n183\n184\n62,116,118,131,174,293\n61,293\n19,28,50,182,300\n53,184,297\n183,226\n182,187,226\n66,164,298\n69,167,297\n60,180\n59,180\n0,54,71,171\n70,179\n63,78,177,179\n33,42,45,51,59,66,71,88,180\n131,166,178,180\n178\n180\n180\n180\n53\n0,2,4,6,49\n28,55\n9,54\n0,25,46,49\n59,180\n64,180\n49,76\n48\n55,180\n67,179\n180\n180\n46,74\n0,37\n58,175\n61,180\n164\n55\n52,55,58,66,179\n76,180\n63,88,180\n297,303\n300\n58,100\n57,102\n56,96\n54,87\n192,267,292\n189,191,193,201,291\n42,53,311\n306\n9,36,56,307,352\n56,307,339,359\n53,276,296\n36,49,55,300\n31,306\n63,74,174,177,185\n76,175,179,181\n186,207,278,282,291,304\n183,196,280,294\n199,274\n199,271\n9,25,55,61,68,96,102,104,142,174,180\n1,140\n0,30\n1,178,180\n0,2,108,123,125,160\n0,3,9,129,165\n0,8,40,121,129,160\n0\n0,2,138,179\n0,39,135,166,170\n25,94,102,126,133,143,155,161\n157,160,180\n161,180\n0\n0,7,45\n3\n66,99,129\n62,78,103,124,127\n106,124\n0,27,30,38,171,180\n0,5,133,146,150,163\n180\n3,39,164\n1,18,21,127,168,180\n162,180\n63,114\n67,85,88,90,105,125\n180\n123,148,322,336,347,357\n125,297,318,326\n8,50,342\n6,8,10,12,23,335\n2,16,342\n16,305,335,343\n1,6,111,231,245,324,347,350,359\n103,108,114,240,249,260,276,300,319,349\n72,78,85,101,105,110,120,271,287,307\n111,133,185,267,301,350\n9,25,332,348\n16,335,337,352,354\n162,164,173,188\n210,251\n13,137,235,238,298,320\n5,128,237,314,317,327,334,339\n283,303,327\n304,330\n314\n15,224,357\n3,18,43,74,212,249\n13,15,188,220,246,248,340\n200,208,226,248\n204,217,246\n202,219,231,234,252,265\n154,174,211,248,265,267\n219,264\n210,249\n1,8,10,12,45,77,291,338\n12,52,296,341\n17,27,328,345,347\n14,48,339,348\n110,329,348\n21,53,76,79,103,351\n2,6,90,105,339\n10,89,351\n122,140,166,173,208,210,220\n134,147,167\n136,217,236,266\n128,145,147,191,194,236,265\n119,126,132,136,226,239,248\n135,154,226,241\n93,116,119,123,276,302,340\n92,110,122,130,243,277,299\n98,107,114,117,123,253,310,316,342\n99,121,251,271,335,343,348,351\n306\n306\n236,250,276\n180,229,252,255,257\n247,279\n16,339\n339\n5,308,342\n13,339\n122,145\n137,155,229\n215,218,221,254,260\n216,221,224,230,232,253,269\n222,228,234,254,270\n313,343\n347\n34,54,290,309,320,345\n1,33,50,293,311,320,328,339\n10,20,26,335,353\n114,126,136,160\n103,120,204\n10,290,329,352\n0,3,25,46,56,87,123,127,135,142,145,155,180\n0,27,45,48,50,76,122,165,177,180\n78,118,148,151\n180\n180\n0,21,42\n0,2,29\n1\n0\n0,14,25,50,84,121,180\n0,13,34,41\n0,30\n56,81\n21,330,357\n17,345\n356\n6,20,34,341,351\n9,33,36,350,352,356\n31,56,355\n17,27,30,321,358\n0\n0,22,24,42,44,51,85,90\n0,66\n0,2,16,42\n180\n0,132,160,180\n0,45\n5,9,22,54\n180\n0,18\n62,88\n33\n20,145,180\n1,10,12,20,27\n180\n0\n137\n135\n144,148,161,163\n6,18,120,142,146,161,164,166\n122,271,313,325\n114,261,318,343\n305,325\n123,147\n134\n0,8,302,304,331\n2,301,335\n5,32,54,75,79,89,338\n9,26,44,47,51,87\n77,83,106\n51,75,104\n119,121,123,150,199,220,251\n116,150,161,199,225,247,250\n149,167,184,189,195\n132,135,138,150,167,182\n152,156,216\n149,175\n130,150,162,164,181\n169,177\n3,7,50,114\n2,4,48,112,169,175\n261,285,322\n261,287,323\n110,115,127,147\n116,139,155\n303\n303,323\n101,122\n102,121\n247,255,257,261,281\n247,281\n287,332,334\n8,290,332\n9,80,101,348\n12,101,348\n128,164,197,234,241\n119,125,128,148,163,190,194,196,231,233\n72,99,117,119,136\n49,96,98,106,112,134,165\n279,291,301,304,322\n250,266,278,287,301,305,332,352\n289,304\n304\n126\n126\n11,18,23,33,70,77,86,113\n21,39,59,88\n136\n136\n51,337,355\n47,338\n118,146,168,170,221,244\n118,141,154,169,172,188,221,244\n89\n90\n52,55,90\n0\n0,8\n1,3,38,58\n0,132,151,174,180\n0\n74,90\n24,337\n162,179,198\n0,10,19,39\n39,59,180\n59,180\n23,93,252,268,322,338\n0,66,180\n0,180\n0,7,33,112,142,180\n0,22,51,87,107,129,150,180\n0,43\n19,177,180\n74,296\n0\n21,159,166,173,175\n56,180\n31,46\n53\n0,10,14,29\n0\n0,44\n136,143,146,180\n60,110,150,167,180\n43,56,102,168\n60\n56\n60,68,75,80,90,178,180\n59,303\n59,302\n71,85,97,105\n49,72\n56\n0\n180\n69\n69,88,103,111,136\n0,14,18,21,34,41,131,134,156,162\n15,20,29,59,61,90,111,139,141,144,165\n48,80,164\n0\n67,180\n0,56\n56,305\n56,305\n59,173,180\n54,75,123,169,177\n57,180\n69,180\n182\n0\n0,22\n61,74,109,141,180\n29,54,77,83,89,108,162\n38,52,87,90,97,105,174\n46,62,71,107\n31,49,97,143\n35,48,73,95,141,172,286\n35,74,94,155,171,293,317\n58,83,158,164,166,180\n19,41,59,174,180\n61,63,80,179,284,338\n91,178,180,189,306\n52,57,61,114\n63,114\n99,261\n58,82,168\n61,80,177,180\n60,79,102,105,113,116,124,127,133,156,176\n63,180\n36,65\n0\n34,36,43,47,59,80,90\n1,9,35,90\n13,21,35,52,55\n49\n0\n8,12,49,126,154,180\n0,34,36,50,71,90\n1,4,39,73\n66,68,86,136,151,153,155,166,180\n0,27\n0,57,84,122,141,144,146,149,164,180\n0,47,99,131\n137\n0,39,152,180\n1,8,29,51,58,62,73,84,89,100,104,106,109,131,152,180\n0,162,180\n0,8,26,81,150,180\n65,75,81\n80\n27,29,66,68,109\n51,71,98,105\n31,33,59,79,102,235,256\n36,38,41,56,62,90,158\n180\n66\n67,108\n67,174\n12,39,54,96,153,158,174\n161,167,180\n60,145,180\n33\n24,28,45\n48,54,56,59,66,78,162,180\n55,67,86,180\n16,19,42,63,67\n47,154,180\n15,33,39,58,104\n0,20,23,45\n12,21,61\n66\n0,25,38,58,65\n43,67,73,84,87\n0,16,18,29,32,36\n22,30,44,53,56,58\n39,62,78,173\n28,61,81,153,180\n2,49,77,85\n0,26,30,37,41,45,51,55,61,65,90\n60,180\n0,16,138,157,168,180\n0,13,29,48,90\n15,131,152,158\n49,53,68,96,112,142,173\n51,71,74,87,110,132,174\n59,62,93,167\n15,40,57,73,110,115,130,139,143,149,155,180\n0,5,40,74,104,137,159,180\n0,7,85,107,134\n0,11,112,132,144\n61,180\n64,89,148,161,167,180\n60,67,77,108,148,171,176\n21,25,45\n36,40,49,54,82,157,171,180\n37,57,180\n52,55,63,155,180\n20,47\n47,67,168\n2,32,34\n0,3,19,38,64,72,79,81\n124,140,174,180\n40,47,49\n17,46,310,342\n1,31\n42,54,56,65,73,85,90\n0\n62,85\n23,32,56,71,83,87\n192,303\n63,159\n180\n67,81,84,175,177\n48,66,109,174\n238,289\n0,46,55,61,79\n0\n0\n15,32,40,63\n180\n63,76,79,176\n64,73\n57,83\n0,7\n180\n57,180\n54,75,90\n69,80,82\n66,80\n103\n71\n180\n40\n0,5,9,17,57,75,78,85\n0,9,31,43,49,63\n2,19,47,61\n60,64,86,121\n43,75\n43,47,77\n41,78,96,101,104,109\n176\n180\n180\n0,29,33,71,90\n0,118,156,180\n0\n36,40,88,90\n130\n0,3,8,20,28,30,49,70\n0\n90\n10,33,65,88,95,102,122,141,150,164\n8,64,93,109,126,149,158\n4,19,235,254,263,277,282,302,306,319,322,328,335,349\n1,235,278,288,300,325,344,358\n10,109,128,167\n10,15,21,23,25,109,124,174\n21,28,50,105,113,125,137,152\n0,6,50,64,83,121,146,173,177\n6,8,21,58\n66,85,99,104,179\n69,180\n66,209,306,338\n66,207,306,332,334\n187,280,285,291\n111,136\n105,129,133,138,141,143\n90\n35,47,56,69\n70,90\n41\n24,47,54,60,90\n64\n0,9,39,58\n0,45,91,95,122,135,155\n182\n64,90\n34,92,132,180\n0,33\n90\n180\n4\n22,44,47\n176,184\n181\n0,6,24,52,79,82,84,90\n303,330,353\n58,106\n58,92,99,114\n27,31,42,68,102,140,172,176,180\n0,3,20,22,25,32,35,37,52,78\n71\n55,80,96\n82,86,89,93\n180\n180\n51,63,71,180\n0,5,152,156,180\n0,22,29,40,88\n136\n41\n101,168\n98,164\n49,52,61,86,113,180\n63,301,323\n59,195,248,293,330\n50,52,69,167,172,180\n31,61,180\n41,48,61,69,160,180\n25,49,63,71,180\n50,71,73,169\n45,59\n57,176,180\n59,174,176,178\n0,24,34,36,90,136,158,160\n57,59,69,180\n58,180\n0,30,55,57\n32,55,59,72,78,156,171\n34,45,58\n54,81,87,90\n1,10,20,43,70,104,110,115,118,139,142,161\n128,141,145,152,180\n0,8,36,52,88\n179\n77,177,180\n180\n49,81,163\n180\n58\n62,79,82,99,106,109,112,120\n66\n67\n28,61\n0,17,123,125\n0,31,55,66,76,89,154,178\n59,102,180\n54,67,168\n62,180\n180\n30,56\n0,6,11,14,180\n0,35,120,142,146,180\n14,18,23,39,44,147,180\n0,30,59,112,121,155,159,180\n0,9,13,24\n12,92,141,156,164\n13,25,53,78,94,114,145,179\n45,70,158,171\n8,19,42,57,60,80,171,176,179,188,201,205,208,222,251,271,299,341\n11,17,38,55,169,201,309,313\n68\n48\n0,4,58,180\n0,9,46,120,166,177,180\n1,18,52,70,115,180\n180\n0,10,12,14,30,48,69,133,180\n78,99,169\n76,95,99,103,150,168\n70,141,168\n72,165\n29,49,72,74,168\n52,59,180\n33,58,90,100,148,180\n0,2,31,51\n0,2,8,42\n59,180\n13,48,178,192,297,311\n43,155,182,282,297,353\n70,72,149,164\n70,164\n33,37,41,166,177,203,308,355\n9,23,42,45,179,190,204,311\n68,163\n66,165\n0\n0\n114,133,180\n0\n0\n0\n0\n0\n0\n0,180\n180\n0,8,159,180\n151,180\n0\n11,22,35,150,179,183,194,197,348\n1,5,157,166,181,199\n15,355\n221\n216,238,244,259\n22,234,246,249,255,261,268,341,356\n248,358\n4,296,303,314,338,359\n2,246,249,305,344\n6,12,298,346\n19,76,80,117,129,131,234\n16,118,144\n0,180\n0\n68,180\n65,79,81,108,169,187\n295\n295\n292\n180\n184,292\n184,282,287,292,300\n179\n56\n21,55,309\n1,40,56,306\n65,185,302,319\n59,77,178,303\n176\n71,157,178\n180\n63,303\n65,183,305\n33,58,61,306\n33,57,300,325,334,355\n180\n181\n67,175,301\n68,175,299\n66,176\n66,131,180\n301\n187,205,293\n191,294\n192,194,297\n191,211,296\n199,268,298\n60,299\n62,300\n67,193\n59,74,298,301,310,323\n38,44,59,62,195,296\n38,62,76,79\n283,292,298,320\n65,83,176,202,228,263,296\n59,70,167,189,262,282,285\n0\n0,18,43\n63,180\n146,180\n180\n54\n14,54\n0,5,7,56,79\n50,65,170\n180\n61\n59\n13,34,55,306\n51,305\n308\n51,306\n50,307\n0\n0,40,180\n0,67,74,90\n0\n143,179\n0,48,60,90,96,98,103,129,180\n0,15,109,119,142,180\n0,25,27,30,49,55,60,77,100,103,105,138,141,173\n0,180\n0,7,135,156,180\n0,28\n0\n180\n180\n180\n0,27,31,41,46,55,57,70,102,128,144,180\n0,180\n180\n180\n8,180\n0,180\n0,179\n0,61,89,112,180\n180\n2,4,51,71,128,130,147,170,180\n0,11,35,38,55,75,78,110,130,150,170\n89,114,126,147,154,159,179\n28,103,134,150\n129,133,143,148,154,159,163,169,176,196,230,236,239,243,247,249,257,269,273,275,315,317,346\n3,138,145,156,185,217,229,232,245,249,262,272,276,294,299,305,309,329,349,359\n103,125\n2,4,21,30,39,45,67,82,97\n1,15,33,90,93\n138,152,155,171,214\n139,186,194,217\n157,173,220,224\n156,217,220\n50,93,118,147,153,183,185,209,224,258,264,270,337\n19,85,141,196,198,201,205,209,211,243,264,327,336\n139,165,219,248\n11,26,121,235,264,293,300,308,314,326,332,338,353,356\n3,7,23,26,101,172,233,257,275,294,310\n3,22,35,45,61,88\n1,133,171,180\n0,23\n151,155,158,161\n151\n65,180\n57,175\n25,57,303\n57,296,304,306\n302\n0,63,180\n133,180\n63\n60\n63\n60,62,180\n180\n0,78,96,101,110,180\n63,180\n66,174,296,303,306,309\n64,175,299\n26,65,67,173,192\n61,90,174,194\n60,172,296\n1,128,150,170,180\n59,180\n54\n180\n15,52\n10,25,53,60\n54\n48\n48,299\n52,300\n302,325\n301\n303,332\n179\n60,83,85,102,178\n60,82,173\n67,76,85,105\n58,306\n191,208,298\n189,210,216,299\n295\n265,295\n251,275,288\n195,251,266,289\n60,184,302\n58,174,303\n54,306\n55,305\n180,186,196,249,268,270,295\n179,185,192,240,273,295,300\n64,174\n65,175\n72,88,92,133,168\n190,198,206,284,289\n190,194,206,286\n236,239,263,281\n193,224,246,263,265,278,292\n0\n0\n0\n0,44,47,66,102,119,129,132,149,180\n0,57,65,90\n0,5,7,24,27,29,31,39,156,180\n0,12,15,17,46,65,85,95,104,107,130,144,150,153,158,161,169,172,180\n0,64,94,127,130,136,180\n1,112,141,256,272,313,332,349,358\n90\n0,35,55,73,109,115,123,126,130,134,180\n89,123,136,144,180\n80,97,141\n55,76,171,180\n72,178,180\n71,180\n158,180\n153,169\n9,27,50,71,78,81,98,122,145,171,180\n0\n0,21,36,45,64,75,83,94,100,127,153,156,177,180\n1\n5,25,38,67,93,164,297,313,336,341,347,353\n12,35,40,47,68,85,296,311,336,341,350\n0,7,25,35,45,48,63,65,68,94\n28,36,46,79\n50\n123,140,164\n90\n63,90,93,124,166,168,171\n0,42,62,90\n179,218\n0,30,52,85\n87,98,107,112\n0,2,14,45,47,75,114,139\n89,104\n85,105\n16,28,35,42,65,79,101,135,160,180\n36,44,46,54,75,91,216,235,252,279,300\n0,180\n0,180\n0,46,180\n0,22,27,42,78,120,122,139,143,148,158,179\n55,70,74,258,358\n0,50,71,89,218,342\n24,49,67,88,135,182,266,274,280,350\n50,83,153\n38,65,91\n70,94,96,98,104,249,259,266\n8,178\n0,97,107,180\n28,65,91,155,180\n62,165\n67,167\n107,110,126\n0,14,18\n44,48,64,80,82,84,104,106,126,131,156,168,176,178\n106,115\n68,156,180\n15,53\n65,157,172\n64,180\n62,72,85,101,143,152,165\n55,62,180\n59,69,73,75,180\n34,59,84\n0,6,19,28,46\n0,17,21\n75\n0,9,33,50,76,79\n54,59,65,74,79,82,95,180\n98,116,142,172,180\n0,26,28,43\n36,54\n35,41,55,70\n4,19,41,177,321,337\n75,118,139,151,172,180\n21,23,46,48,70,108\n0,13,16,25,82\n24,40\n40\n0,179\n0,5,14,20,28\n2,26,28\n0,10,19,24,116,135\n0,18,98,130,166\n109,142\n0\n58,180\n61,176,180\n180\n56\n42,62,180\n0\n0,40,61,66,68,143,180\n0,75,90\n1\n53,73,92,109,133,172,180\n0\n2\n180\n120,145,147,169,174,178,180\n0,28\n11,56,128,165,180\n28,66,90\n0\n180\n0,23,54,77,148,179\n145,178,180\n61,152,180\n0,80,101,122,142,145,180\n0,8,81,113,133,136,143,148,180\n0\n15,24,27,53\n6,8,25\n0,23\n2,52\n2,31,42,56\n180\n180\n141,166,180\n180\n180\n180\n0,38,50,95\n0\n141,180\n179\n8,25,41,61,64,116,124,154,156,161\n148,151,155,158,162\n0,43,54,64,93,123,140,157\n0,67,89,96,98,105,125,132,137,144,146\n4,7\n1,3,17,19\n0\n0,9,25,48\n180\n180\n180\n180\n70,117,147,151\n0,9,11,35,72,95,122\n180\n180\n144,180\n0,180\n0,177,180\n0,20,25,60,172\n128,149,171,176\n180\n180\n0,42,131,161,180\n3,23,36,51,112\n2,15,40,55,58,70,132,161,168\n180\n158,180\n0,2,9,54,89,136,144,148,151,179\n138,180\n0,159,180\n0\n0,180\n0\n97,142,161,180\n82,127\n126,165\n151\n128,140,158,182,186,190,222,244,250,256,298,345\n128,133,231,243,249,264,284,292,301,303,320,347\n107,118,124,136,142\n112,116,118,120,122\n121,132,141,148\n0,41,53,64,89,115\n40,43,50,55,63,70,92,108,110,356,359\n18,21,47,77,90,104\n149,165,167,172,229,260\n116,133,155,177,228\n179,243,268\n167,184,199,219,222,227,250,257,264\n131,155,205,208,214,236,238\n159,165,228,238,242,244,271\n150,213,242\n152,227,232,240\n140,165,178,212,214,232,234,273\n188,202,205,208,236,253,256,258\n115,124,145,172,227,231\n169,181,194,218,236\n238,251,266,282,287,292,295,298,322,348\n224,237,242,260,300,320,325,345\n25,70,96,146\n135,138,145,152,176,217\n141,145,148,159,165,167,173,179,213\n254,269,272,298,331,351,353\n266,295,298,314,334\n0\n0,35,132,134,137,180\n33,64,79\n0,39\n49,52,65,93,110,126,129\n136,154,180\n159\n0,29\n0,18\n180\n0\n0,13,33,120,149,180\n0,45,49,59,90\n0,2,7,10,19,23\n0,34,36,44,70,77,84,128,153\n0,19,21\n0\n0,15,33,162,180\n0,20\n139,180\n20,28,42,119,149\n46,118,159\n20,84,101,117,216,227,230,261\n21,52,63,108,233,239,244\n51\n28,50,76\n35,71\n36,96\n29,34,38,106,214\n39,67,224\n212,238,257\n212,237,253\n106,127,138,166,201\n102,152,201,215\n251,274,290,326,329\n6,8,13,17,268,290,309,326,338\n271,327,349\n277,292,294,302,307,315,323,337,343\n83,109,131,136,152\n85,87,105,135,141,148,152\n105,134,138,142\n72,93,98,108,127\n4,6,12,18,46,63,83,105,132,156,160\n8,15,38,44,57,96,101,116,142,159\n17,42,46,54,68,101,233,243\n15,19,25,27,41,45,47,50,77,87,101,208,251\n36,59,79,104\n109,140,163,179,198,221,238\n109,140,164\n22,55,74,102,105,110,113,188,192,217,239\n10,12,37,96,195,230\n42,198,218,238,242,246,265\n65,112,207,232,267\n32,225,246\n53,75\n25,131,133,321,349\n25,50\n1,3,8,17,34\n22,229,247,348\n2,22,251,307,343\n6,246,269,358\n246,310,349\n223,246,264,288,337,352\n6,359\n1,240,256,274,310,335\n110,147,164\n89,91,105,120,140\n111,132,155\n109,139,157\n5,13,18,241,251\n19,95,116,235,260,357\n18,112,239\n115,130,133,162,244,248\n23,98,131,239,343\n25,222\n21,40,205,225\n70,92,177\n68,158,168,180,272,309\n295,307,317\n58\n11,67\n60,301\n56,281,302,317\n42,58,299\n52,302\n65,176\n64,176\n114,118,175\n72,170,179\n75,124,155,177\n86,123,179\n93,135,176\n61,177\n118,139\n70,177,200,301\n174\n63,81,175\n146,