!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports):"function"==typeof define&&define.amd?define(["exports"],e):e((t="undefined"!=typeof globalThis?globalThis:t||self).nmrProcessing={})}(this,(function(exports){"use strict";const gyromagneticRatio={"1H":267522187.44,"2H":41065e3,"3H":285350800,"3He":-203789e3,"7Li":103962e3,"13C":67282840,"14N":19331e3,"15N":-27116e3,"17O":-36264e3,"19F":251662e3,"23Na":70761e3,"27Al":69763e3,"29Si":-5319e4,"31P":108291e3,"57Fe":8681e3,"63Cu":71118e3,"67Zn":16767e3,"129Xe":-73997e3},impurities={cdcl3:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"ds",shift:7.26}],h2o:[{proton:"H2O",coupling:0,multiplicity:"bs",shift:1.56}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.1}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.17}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.1}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.36}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.28}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.19},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.22}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.98},{proton:"OHc",coupling:0,multiplicity:"s",shift:5.01},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.27},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.43}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.26}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.43}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.73}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.3}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.21},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.48}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.65},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.57},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.39}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.4},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.55}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.09},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3.02},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.94}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:8.02},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.96},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.88}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.62}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.71}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.25},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.72},{proton:"OH",coupling:5,multiplicity:"s,t",shift:1.32}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.05},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.12},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.26}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.14},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.46},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.06}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.76}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.86},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.26}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.26}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.65}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.49},{proton:"OH",coupling:0,multiplicity:"s",shift:1.09}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.33}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:7},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.27}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.22},{proton:"CH",coupling:6,multiplicity:"sep",shift:4.04}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.62},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.29},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.68}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.07}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.85},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.76}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.36},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.17},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.25}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.03},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.53}]},"(cd3)2co":{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:2.05}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:2.84}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.96}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.09}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.05}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.36}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.18}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.13},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.13}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.96},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.22},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.41}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:8.02}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.43}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.87}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.63}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.11},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.41}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.56},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.47},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.28}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.28},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.46}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.83}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.96},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.94},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.78}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.52}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.59}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.12},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.57},{proton:"OH",coupling:5,multiplicity:"s,t",shift:3.39}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.05},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.2}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.45},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.96}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.28}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.87},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.29}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.28}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.59}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.31},{proton:"OH",coupling:0,multiplicity:"s",shift:3.12}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.43}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.27}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.1},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.9}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.58},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.35},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.76}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.13}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.79},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.63}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.32},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.5},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.5}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.45}]},dmso:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"quint",shift:2.5}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:3.33}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.91}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.09}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.07}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.37}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.11},{proton:"OHc",coupling:0,multiplicity:"s",shift:4.19}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.11},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.08}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.87},{proton:"OHc",coupling:0,multiplicity:"s",shift:6.65},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.18},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.36}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:8.32}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.4}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.9}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.76}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.09},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.38}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.51},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.38},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.24}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.24},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.43}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.96},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.94},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.78}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.95},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.89},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.73}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.54}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.57}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.06},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.44},{proton:"OH",coupling:5,multiplicity:"s,t",shift:4.63}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.99},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.03},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.17}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.43},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.91}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.34}],"grease^f":[],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.86},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.25}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.53}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.16},{proton:"OH",coupling:0,multiplicity:"s",shift:4.01}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.42}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.88},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.27}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.04},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.78}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.58},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.39},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.79}],silicone_greasei:[],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.76},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.6}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.3},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.18},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.25}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.93},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.43}]},c6d6:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:7.16}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:.4}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.55}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.55}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.55}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.15}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.05},{proton:"OHc",coupling:0,multiplicity:"s",shift:1.55}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.07},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.04}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:7.05},{proton:"OHc",coupling:0,multiplicity:"s",shift:4.79},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.24},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.38}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:6.15}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.4}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:2.9}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:4.27}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.11},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.26}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.46},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.34},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.11}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.12},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.33}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.6},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.57},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.05}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.63},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.36},{proton:"CH3",coupling:0,multiplicity:"s",shift:1.86}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.68}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.35}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.34}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.65},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:3.89},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.92}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.58},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:1.81},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.85}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.41}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.92},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.36}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.89},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.24}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.4}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.07}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.94}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.86},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.23}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:.95},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.67}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.53},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:6.66},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:6.98}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.29}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.4},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.57}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.11},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.02},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.13}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.4}]},cd3cn:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:1.94}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:2.13}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.96}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.08}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.96}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.37}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.16},{proton:"OHc",coupling:0,multiplicity:"s",shift:2.18}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.14},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.13}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.97},{proton:"OHc",coupling:0,multiplicity:"s",shift:5.2},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.22},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.39}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.58}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.44}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.81}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.44}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.12},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.42}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.53},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.45},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.29}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.28},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.45}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.96},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.83}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.92},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.89},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.77}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.5}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.6}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.12},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.54},{proton:"OH",coupling:5,multiplicity:"s,t",shift:2.47}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:1.97},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.06},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.2}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.06},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.43},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:.96}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.51}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.86},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.27}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.89},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.28}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.57}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.28},{proton:"OH",coupling:0,multiplicity:"s",shift:2.16}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.31}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.87},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.29}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.09},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.87}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.57},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.33},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.73}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.08}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.8},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.64}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.33},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.2},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.2}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.96},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.45}]},cd3od:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:3.31}],h2o:[{proton:"H2O",coupling:0,multiplicity:"s",shift:4.87}],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.99}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.15}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.03}],benzene:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.33}],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.4}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.15},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.2}],bhtb:[{proton:"ArH",coupling:0,multiplicity:"s",shift:6.92},{proton:"ArCH3",coupling:0,multiplicity:"s",shift:2.21},{proton:"ArC(CH3)3",coupling:0,multiplicity:"s",shift:1.4}],chloroform:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.9}],cyclohexane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:1.45}],"1,2-dichloroethane":[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.78}],dichloromethane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:5.49}],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.18},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.49}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.61},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.58},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.35}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.35},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.52}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3.31},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.92}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.97},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.99},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.86}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.65}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.66}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.19},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.6}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.01},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.09},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.24}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.12},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:2.5},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.01}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.59}],"grease^f":[{proton:"CH3",coupling:0,multiplicity:"m",shift:.88},{proton:"CH2",coupling:0,multiplicity:"br_s",shift:1.29}],"n-hexane":[{proton:"CH3",coupling:0,multiplicity:"t",shift:.9},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.29}],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.64}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.34}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.34}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.89},{proton:"CH2",coupling:0,multiplicity:"m",shift:1.29}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.5},{proton:"CH",coupling:6,multiplicity:"sep",shift:3.92}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.53},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.44},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.85}],silicone_greasei:[{proton:"CH3",coupling:0,multiplicity:"s",shift:.1}],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.87},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.71}],toluene:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.32},{proton:"CH(o/p)",coupling:0,multiplicity:"m",shift:7.16},{proton:"CH(m)",coupling:0,multiplicity:"m",shift:7.16}],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.05},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.58}]},d2o:{tms:[{proton:"X",coupling:0,multiplicity:"",shift:0}],solvent:[{proton:"X",coupling:0,multiplicity:"",shift:4.79}],h2o:[],acetic_acid:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.08}],acetone:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.22}],acetonitrile:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.06}],benzene:[],"tert-butyl_alcohol":[{proton:"CH3",coupling:0,multiplicity:"s",shift:1.24}],"tert-butyl_methyl_ether":[{proton:"CCH3",coupling:0,multiplicity:"s",shift:1.21},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.22}],bhtb:[],chloroform:[],cyclohexane:[],"1,2-dichloroethane":[],dichloromethane:[],diethyl_ether:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.17},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.56}],diglyme:[{proton:"CH2",coupling:0,multiplicity:"m",shift:3.67},{proton:"CH2",coupling:0,multiplicity:"m",shift:3.61},{proton:"OCH3",coupling:0,multiplicity:"s",shift:3.37}],"1,2-dimethoxyethane":[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.37},{proton:"CH2",coupling:0,multiplicity:"s",shift:3.6}],dimethylacetamide:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.08},{proton:"NCH3",coupling:0,multiplicity:"s",shift:3.06},{proton:"NCH3",coupling:0,multiplicity:"s",shift:2.9}],dimethylformamide:[{proton:"CH",coupling:0,multiplicity:"s",shift:7.92},{proton:"CH3",coupling:0,multiplicity:"s",shift:3.01},{proton:"CH3",coupling:0,multiplicity:"s",shift:2.85}],dimethyl_sulfoxide:[{proton:"CH3",coupling:0,multiplicity:"s",shift:2.71}],dioxane:[{proton:"CH2",coupling:0,multiplicity:"s",shift:3.75}],ethanol:[{proton:"CH3",coupling:7,multiplicity:"t",shift:1.17},{proton:"CH2",coupling:7,multiplicity:"q",shift:3.65}],ethyl_acetate:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.07},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:4.14},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.24}],ethyl_methyl_ketone:[{proton:"CH3CO",coupling:0,multiplicity:"s",shift:2.19},{proton:"CH2CH3",coupling:7,multiplicity:"q",shift:3.18},{proton:"CH2CH3",coupling:7,multiplicity:"t",shift:1.26}],ethylene_glycol:[{proton:"CH",coupling:0,multiplicity:"s",shift:3.65}],"grease^f":[],"n-hexane":[],hmpag:[{proton:"CH3",coupling:9.5,multiplicity:"d",shift:2.61}],methanol:[{proton:"CH3",coupling:0,multiplicity:"s",shift:3.34}],nitromethane:[{proton:"CH3",coupling:0,multiplicity:"s",shift:4.4}],"n-pentane":[{proton:"CH3",coupling:7,multiplicity:"t",shift:.9}],"2-propanol":[{proton:"CH3",coupling:6,multiplicity:"d",shift:1.17},{proton:"CH",coupling:6,multiplicity:"sep",shift:4.02}],pyridine:[{proton:"CH(2)",coupling:0,multiplicity:"m",shift:8.52},{proton:"CH(3)",coupling:0,multiplicity:"m",shift:7.45},{proton:"CH(4)",coupling:0,multiplicity:"m",shift:7.87}],silicone_greasei:[],tetrahydrofuran:[{proton:"CH2",coupling:0,multiplicity:"m",shift:1.88},{proton:"CH2O",coupling:0,multiplicity:"m",shift:3.74}],toluene:[],triethylamine:[{proton:"CH3",coupling:7,multiplicity:"t",shift:.99},{proton:"CH2",coupling:7,multiplicity:"q",shift:2.57}]}},couplingPatterns=["s","d","t","q","quint","h","sept","o","n"],toCheck=["solvent","h2o","tms"];function peaksFilterImpurities(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{solvent:s,error:n=.025,remove:i=!1}=e;if(s){"(cd3)2so"===s&&(s="dmso"),"meod"===s&&(s="cd3od");let e=impurities[s];for(let s of toCheck){checkImpurity(t,e[s],{error:n,remove:i,name:s})}}return t}function checkImpurity(t,e,s){let n,i,o,{name:a,error:l,remove:r}=s,m=e.length;for(;m--;)for(n=t.length;n--;)i=l+t[n].width,o=Math.abs(e[m].shift-t[n].x),o<i&&(r?t.splice(n,1):t[n].kind=a)}const GAUSSIAN_EXP_FACTOR=-4*Math.LN2,ROOT_PI_OVER_LN2=Math.sqrt(Math.PI/Math.LN2),ROOT_THREE=Math.sqrt(3),ROOT_2LN2=Math.sqrt(2*Math.LN2),ROOT_2LN2_MINUS_ONE=Math.sqrt(2*Math.LN2)-1;function erfinv(t){if(0===t)return 0;let e=Math.log(1-t*t),s=e/2+2/(.147*Math.PI),n=Math.sqrt(s**2-e/.147);return Math.sqrt(n-s)*(t>0?1:-1)}class Gaussian{constructor(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};const{fwhm:e=500,sd:s}=t;this.fwhm=s?gaussianWidthToFWHM(2*s):e}fwhmToWidth(){return gaussianFwhmToWidth(arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.fwhm)}widthToFWHM(t){return gaussianWidthToFWHM(t)}fct(t){return gaussianFct(t,this.fwhm)}getArea(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:calculateGaussianHeight({fwhm:this.fwhm});return getGaussianArea({fwhm:this.fwhm,height:t})}getFactor(t){return getGaussianFactor(t)}getData(){return getGaussianData(this,arguments.length>0&&void 0!==arguments[0]?arguments[0]:{})}calculateHeight(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:1;return calculateGaussianHeight({fwhm:this.fwhm,area:t})}getParameters(){return["fwhm"]}}function calculateGaussianHeight(t){let{fwhm:e=500,area:s=1,sd:n}=t;return n&&(e=gaussianWidthToFWHM(2*n)),2*s/ROOT_PI_OVER_LN2/e}function gaussianFct(t,e){return Math.exp(GAUSSIAN_EXP_FACTOR*Math.pow(t/e,2))}function gaussianWidthToFWHM(t){return t*ROOT_2LN2}function gaussianFwhmToWidth(t){return t/ROOT_2LN2}function getGaussianArea(t){let{fwhm:e=500,sd:s,height:n=1}=t;return s&&(e=gaussianWidthToFWHM(2*s)),n*ROOT_PI_OVER_LN2*e/2}function getGaussianFactor(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:.9999;return Math.sqrt(2)*erfinv(t)}function getGaussianData(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{fwhm:s=500,sd:n}=t;n&&(s=gaussianWidthToFWHM(2*n));let{length:i,factor:o=getGaussianFactor(),height:a=calculateGaussianHeight({fwhm:s})}=e;i||(i=Math.min(Math.ceil(s*o),Math.pow(2,25)-1),i%2==0&&i++);const l=(i-1)/2,r=new Float64Array(i);for(let t=0;t<=l;t++)r[t]=gaussianFct(t-l,s)*a,r[i-1-t]=r[t];return r}class Lorentzian{constructor(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};const{fwhm:e=500}=t;this.fwhm=e}fwhmToWidth(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.fwhm;return lorentzianFwhmToWidth(t)}widthToFWHM(t){return lorentzianWidthToFWHM(t)}fct(t){return lorentzianFct(t,this.fwhm)}getArea(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:1;return getLorentzianArea({fwhm:this.fwhm,height:t})}getFactor(t){return getLorentzianFactor(t)}getData(){return getLorentzianData(this,arguments.length>0&&void 0!==arguments[0]?arguments[0]:{})}calculateHeight(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:1;return calculateLorentzianHeight({fwhm:this.fwhm,area:t})}getParameters(){return["fwhm"]}}const calculateLorentzianHeight=t=>{let{fwhm:e=1,area:s=1}=t;return 2*s/Math.PI/e},getLorentzianArea=t=>{const{fwhm:e=500,height:s=1}=t;return s*Math.PI*e/2},lorentzianFct=(t,e)=>e**2/(4*t**2+e**2),lorentzianWidthToFWHM=t=>t*ROOT_THREE,lorentzianFwhmToWidth=t=>t/ROOT_THREE,getLorentzianFactor=function(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:.9999;if(t>=1)throw new Error("area should be (0 - 1)");const e=.5*(1-t),s=t=>Math.tan(Math.PI*(t-.5));return(s(1-e)-s(e))/2},getLorentzianData=function(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{fwhm:s=500}=t,{length:n,factor:i=getLorentzianFactor(),height:o=calculateLorentzianHeight({fwhm:s,area:1})}=e;n||(n=Math.min(Math.ceil(s*i),Math.pow(2,25)-1),n%2==0&&n++);const a=(n-1)/2,l=new Float64Array(n);for(let t=0;t<=a;t++)l[t]=lorentzianFct(t-a,s)*o,l[n-1-t]=l[t];return l};class PseudoVoigt{constructor(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};const{fwhm:e=500,mu:s=.5}=t;this.mu=s,this.fwhm=e}fwhmToWidth(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this.fwhm,e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:this.mu;return pseudoVoigtFwhmToWidth(t,e)}widthToFWHM(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:this.mu;return pseudoVoigtWidthToFWHM(t,e)}fct(t){return pseudoVoigtFct(t,this.fwhm,this.mu)}getArea(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:1;return getPseudoVoigtArea({fwhm:this.fwhm,height:t,mu:this.mu})}getFactor(t){return getPseudoVoigtFactor(t)}getData(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};const{length:e,factor:s,height:n=calculatePseudoVoigtHeight({fwhm:this.fwhm,mu:this.mu,area:1})}=t;return getPseudoVoigtData(this,{factor:s,length:e,height:n})}calculateHeight(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:1;return calculatePseudoVoigtHeight({fwhm:this.fwhm,mu:this.mu,area:t})}getParameters(){return["fwhm","mu"]}}const calculatePseudoVoigtHeight=function(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{fwhm:e=1,mu:s=.5,area:n=1}=t;return 2*n/(e*(s*ROOT_PI_OVER_LN2+(1-s)*Math.PI))},pseudoVoigtFct=(t,e,s)=>(1-s)*lorentzianFct(t,e)+s*gaussianFct(t,e),pseudoVoigtWidthToFWHM=function(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:.5;return t*(e*ROOT_2LN2_MINUS_ONE+1)},pseudoVoigtFwhmToWidth=function(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:.5;return t/(e*ROOT_2LN2_MINUS_ONE+1)},getPseudoVoigtArea=t=>{const{fwhm:e=500,height:s=1,mu:n=.5}=t;return e*s*(n*ROOT_PI_OVER_LN2+(1-n)*Math.PI)/2},getPseudoVoigtFactor=function(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:.9999,e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:.5;return e<1?getLorentzianFactor(t):getGaussianFactor(t)},getPseudoVoigtData=function(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{fwhm:s=500,mu:n=.5}=t,{length:i,factor:o=getPseudoVoigtFactor(.999,n),height:a=calculatePseudoVoigtHeight({fwhm:s,mu:n,area:1})}=e;a||(a=1/(n/Math.sqrt(-GAUSSIAN_EXP_FACTOR/Math.PI)*s+(1-n)*s*Math.PI/2)),i||(i=Math.min(Math.ceil(s*o),Math.pow(2,25)-1),i%2==0&&i++);const l=(i-1)/2,r=new Float64Array(i);for(let t=0;t<=l;t++)r[t]=pseudoVoigtFct(t-l,s,n)*a,r[i-1-t]=r[t];return r};class Gaussian2D{constructor(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{fwhm:e=20,sd:s}=t;e=ensureFWHM2D(e,s),this.fwhmX=e.x,this.fwhmY=e.y}fct(t,e){return gaussian2DFct(t,e,this.fwhmX,this.fwhmY)}getData(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};return getGaussian2DData({fwhm:{x:this.fwhmX,y:this.fwhmY}},t)}getFactor(){return getGaussianFactor(arguments.length>0&&void 0!==arguments[0]?arguments[0]:1)}getVolume(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:calculateGaussian2DHeight({fwhm:{x:this.fwhmX,y:this.fwhmY},volume:1});return getGaussian2DVolume({fwhm:{x:this.fwhmX,y:this.fwhmY},height:t})}widthToFWHM(t){return gaussianWidthToFWHM(t)}fwhmToWidth(t){return gaussianFwhmToWidth(t)}calculateHeight(){return calculateGaussian2DHeight({volume:arguments.length>0&&void 0!==arguments[0]?arguments[0]:1,fwhm:{x:this.fwhmX,y:this.fwhmY}})}set fwhm(t){t=ensureXYNumber$2(t),this.fwhmX=t.x,this.fwhmY=t.y}}const gaussian2DFct=(t,e,s,n)=>Math.exp(GAUSSIAN_EXP_FACTOR*(Math.pow(t/s,2)+Math.pow(e/n,2))),getGaussian2DData=function(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{fwhm:s=50,sd:n}=t;s=ensureFWHM2D(s,n);let{factor:i=getGaussianFactor(),length:o={x:0,y:0},height:a=calculateGaussian2DHeight({fwhm:s,volume:1})}=e;i=ensureXYNumber$2(i),o=ensureXYNumber$2(o);for(const t of["x","y"])o[t]||(o[t]=Math.min(Math.ceil(s[t]*i[t]),Math.pow(2,25)-1),o[t]%2==0&&o[t]++);const l=(o.x-1)/2,r=(o.y-1)/2,m=new Array(o.x);for(let t=0;t<o.x;t++)m[t]=new Float64Array(o.y);for(let t=0;t<o.x;t++)for(let e=0;e<o.y;e++)m[t][e]=gaussian2DFct(t-l,e-r,s.x,s.y)*a;return m},calculateGaussian2DHeight=function(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{volume:e=1,fwhm:s=50,sd:n}=t;return s=ensureFWHM2D(s,n),e*Math.LN2*4/(Math.PI*s.y*s.x)},getGaussian2DVolume=function(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{fwhm:e=50,height:s=1,sd:n}=t;return e=ensureFWHM2D(e,n),s*Math.PI*e.y*e.x/Math.LN2/4};function ensureXYNumber$2(t){return"object"!=typeof t?{x:t,y:t}:{...t}}function ensureFWHM2D(t,e){if(void 0!==e){let t=ensureXYNumber$2(e);return{x:gaussianWidthToFWHM(2*t.x),y:gaussianWidthToFWHM(2*t.y)}}if(void 0!==t)return ensureXYNumber$2(t);throw new Error("ensureFWHM2D must have either fwhm or sd defined")}function getShape1D(t){const{kind:e}=t;switch(e){case"gaussian":return new Gaussian(t);case"lorentzian":return new Lorentzian(t);case"pseudoVoigt":return new PseudoVoigt(t);default:throw Error(`Unknown distribution ${e}`)}}function getShape2D(t){const{kind:e}=t;if("gaussian"===e)return new Gaussian2D(t);throw Error(`Unknown distribution ${e}`)}function addBaseline(t,e){if(!e)return t;let s=t.x,n=t.y;for(let t=0;t<s.length;t++)n[t]+=e(s[t]);return t}var commonjsGlobal="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function getDefaultExportFromCjs(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}var d3Array={exports:{}};!function(t,e){!function(t){function e(t,e){return t<e?-1:t>e?1:t>=e?0:NaN}function s(t){return 1===t.length&&(t=n(t)),{left:function(e,s,n,i){for(null==n&&(n=0),null==i&&(i=e.length);n<i;){var o=n+i>>>1;t(e[o],s)<0?n=o+1:i=o}return n},right:function(e,s,n,i){for(null==n&&(n=0),null==i&&(i=e.length);n<i;){var o=n+i>>>1;t(e[o],s)>0?i=o:n=o+1}return n}}}function n(t){return function(s,n){return e(t(s),n)}}var i=s(e),o=i.right,a=i.left;function l(t,e){return e<t?-1:e>t?1:e>=t?0:NaN}function r(t){return null===t?NaN:+t}function m(t,e){var s,n,i=t.length,o=0,a=0,l=-1,m=0;if(null==e)for(;++l<i;)isNaN(s=r(t[l]))||(a+=(n=s-o)*(s-(o+=n/++m)));else for(;++l<i;)isNaN(s=r(e(t[l],l,t)))||(a+=(n=s-o)*(s-(o+=n/++m)));if(m>1)return a/(m-1)}function g(t,e){var s=m(t,e);return s?Math.sqrt(s):s}function u(t,e){var s,n,i,o=-1,a=t.length;if(null==e){for(;++o<a;)if(null!=(n=t[o])&&n>=n){s=i=n;break}for(;++o<a;)null!=(n=t[o])&&(s>n&&(s=n),i<n&&(i=n))}else{for(;++o<a;)if(null!=(n=e(t[o],o,t))&&n>=n){s=i=n;break}for(;++o<a;)null!=(n=e(t[o],o,t))&&(s>n&&(s=n),i<n&&(i=n))}return[s,i]}function c(t){return function(){return t}}function C(t){return t}function f(t,e,s){t=+t,e=+e,s=(i=arguments.length)<2?(e=t,t=0,1):i<3?1:+s;for(var n=-1,i=0|Math.max(0,Math.ceil((e-t)/s)),o=new Array(i);++n<i;)o[n]=t+n*s;return o}var h=Math.sqrt(50),p=Math.sqrt(10),d=Math.sqrt(2);function y(t,e,s){var n=H(t,e,s);return f(Math.ceil(t/n)*n,Math.floor(e/n)*n+n/2,n)}function H(t,e,s){var n=Math.abs(e-t)/Math.max(0,s),i=Math.pow(10,Math.floor(Math.log(n)/Math.LN10)),o=n/i;return o>=h?i*=10:o>=p?i*=5:o>=d&&(i*=2),e<t?-i:i}function v(t){return Math.ceil(Math.log(t.length)/Math.LN2)+1}function b(t){return+t}function w(){var t=C,e=u,s=v;function n(n){var i,a,l=n.length,r=new Array(l);for(i=0;i<l;++i)r[i]=+t(n[i],i,n);var m=e(r),g=+m[0],u=+m[1],c=s(r,g,u);Array.isArray(c)||(c=y(g,u,+c));var C=c.length;for(i=0;i<C;++i)c[i]=+c[i];for(;c[0]<=g;)c.shift(),--C;for(;c[C-1]>=u;)c.pop(),--C;var f,h=new Array(C+1);for(i=0;i<=C;++i)(f=h[i]=[]).x0=i>0?c[i-1]:g,f.x1=i<C?c[i]:u;for(i=0;i<l;++i)g<=(a=r[i])&&a<=u&&h[o(c,a,0,C)].push(n[i]);return h}return n.value=function(e){return arguments.length?(t="function"==typeof e?e:c(+e),n):t},n.domain=function(t){return arguments.length?(e="function"==typeof t?t:c([+t[0],+t[1]]),n):e},n.thresholds=function(t){return arguments.length?(s="function"==typeof t?t:Array.isArray(t)?c(Array.prototype.map.call(t,b)):c(+t),n):s},n}function O(t,e,s){if(null==s&&(s=r),n=t.length){if((e=+e)<=0||n<2)return+s(t[0],0,t);if(e>=1)return+s(t[n-1],n-1,t);var n,i=(n-1)*e,o=Math.floor(i),a=+s(t[o],o,t);return a+(+s(t[o+1],o+1,t)-a)*(i-o)}}function x(t,s,n){return t.sort(e),Math.ceil((n-s)/(2*(O(t,.75)-O(t,.25))*Math.pow(t.length,-1/3)))}function D(t,e,s){return Math.ceil((s-e)/(3.5*g(t)*Math.pow(t.length,-1/3)))}function j(t,e){var s,n,i=-1,o=t.length;if(null==e){for(;++i<o;)if(null!=(n=t[i])&&n>=n){s=n;break}for(;++i<o;)null!=(n=t[i])&&n>s&&(s=n)}else{for(;++i<o;)if(null!=(n=e(t[i],i,t))&&n>=n){s=n;break}for(;++i<o;)null!=(n=e(t[i],i,t))&&n>s&&(s=n)}return s}function A(t,e){var s,n=0,i=t.length,o=-1,a=i;if(null==e)for(;++o<i;)isNaN(s=r(t[o]))?--a:n+=s;else for(;++o<i;)isNaN(s=r(e(t[o],o,t)))?--a:n+=s;if(a)return n/a}function S(t,s){var n,i=[],o=t.length,a=-1;if(null==s)for(;++a<o;)isNaN(n=r(t[a]))||i.push(n);else for(;++a<o;)isNaN(n=r(s(t[a],a,t)))||i.push(n);return O(i.sort(e),.5)}function M(t){for(var e,s,n,i=t.length,o=-1,a=0;++o<i;)a+=t[o].length;for(s=new Array(a);--i>=0;)for(e=(n=t[i]).length;--e>=0;)s[--a]=n[e];return s}function T(t,e){var s,n,i=-1,o=t.length;if(null==e){for(;++i<o;)if(null!=(n=t[i])&&n>=n){s=n;break}for(;++i<o;)null!=(n=t[i])&&s>n&&(s=n)}else{for(;++i<o;)if(null!=(n=e(t[i],i,t))&&n>=n){s=n;break}for(;++i<o;)null!=(n=e(t[i],i,t))&&s>n&&(s=n)}return s}function $(t){for(var e=0,s=t.length-1,n=t[0],i=new Array(s<0?0:s);e<s;)i[e]=[n,n=t[++e]];return i}function N(t,e){for(var s=e.length,n=new Array(s);s--;)n[s]=t[e[s]];return n}function E(t,s){if(n=t.length){var n,i,o=0,a=0,l=t[a];for(s||(s=e);++o<n;)(s(i=t[o],l)<0||0!==s(l,l))&&(l=i,a=o);return 0===s(l,l)?a:void 0}}function k(t,e,s){for(var n,i,o=(null==s?t.length:s)-(e=null==e?0:+e);o;)i=Math.random()*o--|0,n=t[o+e],t[o+e]=t[i+e],t[i+e]=n;return t}function _(t,e){var s,n=0,i=t.length,o=-1;if(null==e)for(;++o<i;)(s=+t[o])&&(n+=s);else for(;++o<i;)(s=+e(t[o],o,t))&&(n+=s);return n}function I(t){if(!(i=t.length))return[];for(var e=-1,s=T(t,F),n=new Array(s);++e<s;)for(var i,o=-1,a=n[e]=new Array(i);++o<i;)a[o]=t[o][e];return n}function F(t){return t.length}function P(){return I(arguments)}var L="0.7.1";t.version=L,t.bisect=o,t.bisectRight=o,t.bisectLeft=a,t.ascending=e,t.bisector=s,t.descending=l,t.deviation=g,t.extent=u,t.histogram=w,t.thresholdFreedmanDiaconis=x,t.thresholdScott=D,t.thresholdSturges=v,t.max=j,t.mean=A,t.median=S,t.merge=M,t.min=T,t.pairs=$,t.permute=N,t.quantile=O,t.range=f,t.scan=E,t.shuffle=k,t.sum=_,t.ticks=y,t.tickStep=H,t.transpose=I,t.variance=m,t.zip=P}(e)}(0,d3Array.exports);const{bisectRight:bisectRight}=d3Array.exports,quincunx=(t,e,s,n)=>{const i=t.length-1;t[0]=0,e[0]=0,s[0]=0,e[1]=e[1]/t[1],s[1]=s[1]/t[1];for(let n=2;n<i;++n)t[n]=t[n]-t[n-2]*s[n-2]*s[n-2]-t[n-1]*e[n-1]*e[n-1],e[n]=(e[n]-t[n-1]*e[n-1]*s[n-1])/t[n],s[n]=s[n]/t[n];for(let t=2;t<i;++t)n[t]=n[t]-e[t-1]*n[t-1]-s[t-2]*n[t-2];for(let e=1;e<i;++e)n[e]=n[e]/t[e];n[i-2]=n[i-2]-e[i-2]*n[i-1];for(let t=i-3;t>0;--t)n[t]=n[t]-e[t]*n[t+1]-s[t]*n[t+2]},smoothingSpline=(t,e,s,n)=>{const i=t.length-1,o=new Array(i+1),a=new Array(i+1),l=new Array(i+1),r=new Array(i+1),m=new Array(i+1),g=new Array(i+1),u=new Array(i+1),c=new Array(i+1),C=t.map((()=>[0,0,0,0]));C.pop();const f=2*(1-n)/(3*n);for(let e=0;e<i;++e)o[e]=t[e+1]-t[e],a[e]=3/o[e];m[0]=0;for(let s=1;s<i;++s)l[s]=-(a[s-1]+a[s]),r[s]=2*(t[s+1]-t[s-1]),m[s]=3*(e[s+1]-e[s])/o[s]-3*(e[s]-e[s-1])/o[s-1];m[i]=0;for(let t=1;t<i;++t)g[t]=a[t-1]*a[t-1]*s[t-1]+l[t]*l[t]*s[t]+a[t]*a[t]*s[t+1],g[t]=f*g[t]+r[t];for(let t=1;t<i-1;++t)u[t]=l[t]*a[t]*s[t]+a[t]*l[t+1]*s[t+1],u[t]=f*u[t]+o[t];for(let t=1;t<i-2;++t)c[t]=f*a[t]*a[t+1]*s[t+1];quincunx(g,u,c,m),C[0][3]=e[0]-f*a[0]*m[1]*s[0],C[1][3]=e[1]-f*(l[1]*m[1]+a[1]*m[2])*s[0],C[0][0]=m[1]/(3*o[0]),C[0][1]=0,C[0][2]=(C[1][3]-C[0][3])/o[0]-m[1]*o[0]/3,a[0]=0;for(let t=1;t<i;++t)C[t][0]=(m[t+1]-m[t])/(3*o[t]),C[t][1]=m[t],C[t][2]=(m[t]+m[t-1])*o[t-1]+C[t-1][2],C[t][3]=a[t-1]*m[t-1]+l[t]*m[t]+a[t]*m[t+1],C[t][3]=e[t]-f*C[t][3]*s[t];return C};class SplineInterpolator{constructor(t,e){let s=arguments.length>2&&void 0!==arguments[2]?arguments[2]:1;const n=t.map(((t,e)=>e));n.sort(((e,s)=>t[e]-t[s]));const i=n.map((e=>t[e])),o=n.map((t=>e[t])),a=n.length,l=n.map((()=>1));this.n=a,this.x=i,this.y=o,this.params=smoothingSpline(i,o,l,s)}interpolate(t){if(t===this.x[this.n-1])return this.y[this.n-1];const e=Math.min(Math.max(0,bisectRight(this.x,t)-1),this.n-2),[s,n,i,o]=this.params[e];return s*(t-=this.x[e])*t*t+n*t*t+i*t+o}max(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:100;const e=this.x[0],s=(this.x[this.n-1]-e)/t;let n=-1/0;for(let i=0,o=e;i<t;++i,o+=s){const t=this.interpolate(o);t>n&&(n=t)}return n}min(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:100;const e=this.x[0],s=(this.x[this.n-1]-e)/t;let n=1/0;for(let i=0,o=e;i<t;++i,o+=s){const t=this.interpolate(o);t<n&&(n=t)}return n}domain(){return[this.x[0],this.x[this.x.length-1]]}range(){return[this.min(),this.max()]}curve(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;e=e||this.domain();const s=(e[1]-e[0])/(t-1),n=new Array(t);for(let i=0;i<t;++i){const t=s*i+e[0];n[i]=[t,this.interpolate(t)]}return n}}var splineInterpolator=SplineInterpolator,SplineInterpolator$1=splineInterpolator;function createFromToArray(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{from:e=0,to:s=1,length:n=1e3,includeFrom:i=!0,includeTo:o=!0,distribution:a="uniform"}=t;const l=new Float64Array(n);let r=n;i&&o?r=n-1:!i&&o||i&&!o?r=n:i||o||(r=n+1);let m=(s-e)/r;if("uniform"===a)if(i){let t=0;for(;t<n;)l[t]=e+m*t,t++}else{let t=0;for(;t<n;)l[t]=e+m*(t+1),t++}else{if("log"!==a)throw new Error("Please choose for the distribution either uniform or log. By default the distribution chosen is uniform.");{let t=(s/e)**(1/r),o=Math.log(e)/Math.log(t);if(i){let e=0;for(;e<n;)l[e]=t**(o+e),e++}else{let e=0;for(;e<n;)l[e]=t**(o+e+1),e++}}}return l}const Y1=.08913147449493408,P1=[-.005387729650712429,.008226878746769157,.02198786811111689,-.03656379714117627,-.012692614766297404,.03348066254097446,-.008368748197417368,-.0005087819496582806],Q1=[.0008862163904564247,-.0023339375937419,.07952836873415717,-.05273963823400997,-.7122890234154284,.662328840472003,1.5622155839842302,-1.5657455823417585,-.9700050433032906,1],Y2=2.249481201171875,P2=[-3.6719225470772936,21.12946554483405,17.445385985570866,-44.6382324441787,-18.851064805871424,17.644729840837403,8.3705032834312,.10526468069939171,-.20243350835593876],Q2=[1.7211476576120028,-22.643693341313973,10.826866735546016,48.560921310873994,-20.14326346804852,-28.66081804998,3.971343795334387,6.242641248542475,1],Y3=.807220458984375,P3=[-6.81149956853777e-10,2.8522533178221704e-8,-6.794655751811263e-7,.0021455899538880526,.029015791000532906,.14286953440815717,.3377855389120359,.38707973897260434,.11703015634199525,-.16379404719331705,-.1311027816799519],Q3=[.011059242293464892,.15226433829533179,.848854343457902,2.5930192162362027,4.778465929458438,5.381683457070069,3.4662540724256723,1],Y4=.9399557113647461,P4=[26633922742578204e-28,-2.304047769118826e-10,460469890584318e-20,.00015754461742496055,.0018712349281955923,.009508047013259196,.018557330651423107,-.0022242652921344794,-.0350353787183178],Q4=[7646752923027944e-20,.00263861676657016,.03415891436709477,.22009110576413124,.7620591645536234,1.3653349817554064,1],Y5=.9836282730102539,P5=[9905570997331033e-32,-2811287356288318e-29,4.625961635228786e-9,4.4969678992770644e-7,14962478375834237e-21,.00020938631748758808,.001056288621524929,-.0011295143874558028,-.016743100507663373],Q5=[2.82243172016108e-7,27533547476472603e-21,.0009640118070051656,.016074608709367652,.1381518657490833,.5914293448864175,1];function polyval(t,e){let s=0;for(const n of t)s=s*e+n;return s}function calc(t,e,s,n,i){const o=t-e;return i*t+polyval(s,o)/polyval(n,o)*t}function erfcinv(t){let e,s,n,i,o=!1;if(Number.isNaN(t))return Number.NaN;if(t<0||t>2)throw new RangeError(`erfcinv()::invalid input argument. Value must be on the interval [0,2]. Value: \`${t}\`.`);return 0===t?Number.POSITIVE_INFINITY:2===t?Number.NEGATIVE_INFINITY:1===t?0:(t>1?(s=2-t,t=1-s,o=!0):(s=t,t=1-t),t<=.5?(n=t*(t+10),i=polyval(P1,t)/polyval(Q1,t),e=n*Y1+n*i,o?-e:e):s>=.25?(n=Math.sqrt(-2*Math.log(s)),s-=.25,i=polyval(P2,s)/polyval(Q2,s),e=n/(Y2+i),o?-e:e):(s=Math.sqrt(-Math.log(s)),s<3?calc(s,1.125,P3,Q3,Y3):s<6?calc(s,3,P4,Q4,Y4):calc(s,6,P5,Q5,Y5)))}function rayleighCdf(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1;return t<0?0:-Math.expm1(-Math.pow(t,2)/(2*Math.pow(e,2)))}function xNoiseSanPlot(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{mask:s,cutOff:n,refine:i=!0,magnitudeMode:o=!1,scaleFactor:a=1,factorStd:l=5,fixOffset:r=!0}=e;let m;if(m=Array.isArray(s)&&s.length===t.length?new Float64Array(t.filter(((t,e)=>!s[e]))):new Float64Array(t),a>1)for(let t=0;t<m.length;t++)m[t]*=a;if(m=m.sort().reverse(),r&&!o){let t=Math.floor(m.length/2),e=.5*(m[t]+m[t+1]);for(let t=0;t<m.length;t++)m[t]-=e}let g=m[m.length-1]>=0?m.length:m.findIndex((t=>t<0)),u=g-1;for(let t=u;t>=0;t--)if(m[t]>0){u=t;break}let c,C=m.slice(0,u+1),f=m.slice(g),h=n||determineCutOff(C,{magnitudeMode:o}),p=Math.floor(C.length*h),d=C[p],y=C[0];if(f.length>0){c=-1*f[Math.floor(f.length*(1-h))]}else c=0;let H=d,v=c,b=C.slice(),w=f.slice(),O=0,x=2;if(i){let t=H*l;O=C.findIndex((e=>e<t)),O>-1&&(b=C.slice(O),H=b[Math.floor(b.length*h)]),t=v*l,x=f.findIndex((e=>e<t)),x>-1&&(w=f.slice(x),v=b[Math.floor(w.length*(1-h))])}let D,j,A=-simpleNormInv(h/2,{magnitudeMode:o});return d/=A,c/=A,i&&O>-1?(D=(h*b.length+O)/(b.length+O),j=-1*simpleNormInv(D/2,{magnitudeMode:o}),H/=j,x>-1&&(D=(h*w.length+x)/(w.length+x),j=-1*simpleNormInv(D/2,{magnitudeMode:o}),0!==v&&(v/=j))):(H/=A,v/=A),{positive:H,negative:v,snr:y/H,sanplot:generateSanPlot(m,{fromTo:{positive:{from:0,to:u},negative:{from:g,to:m.length}}})}}function determineCutOff(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{magnitudeMode:s=!1,considerList:n={from:.5,step:.1,to:.9}}=e,i=[],o=t.length-1;for(let e=.01;e<=.99;e+=.01){let n=-t[Math.round(o*e)]/simpleNormInv([e/2],{magnitudeMode:s});i.push([e,n])}let a=Number.MAX_SAFE_INTEGER,{from:l,to:r,step:m}=n,g=m/2,u=.5;for(let t=l;t<=r;t+=m){let e=t-g,s=t+g,n=i.filter((t=>t[0]<s&&t[0]>e)),o=n.reduce(((t,e)=>t+Math.abs(e[1])),0),l=0;for(const t of n)l+=Math.pow(t[1]-o,2);l<a&&(a=l,u=t)}return u}function simpleNormInv(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{magnitudeMode:s=!1}=e;Array.isArray(t)||(t=[t]);let n=0,i=2,o=.01,a=Array.from(createArray(n,i,o)),l=new Float64Array(t.length),r=new Float64Array(a.length);if(s){let e=1;for(let t=0;t<r.length;t++){let s=a[t]*e;r[t]=1-rayleighCdf(s)}let s=new SplineInterpolator$1(a,r);for(let e=0;e<l.length;e++){let n=2*t[e];l[e]=-1*s.interpolate(n)}}else for(let e=0;e<l.length;e++)l[e]=-1*Math.SQRT2*erfcinv(2*t[e]);return 1===l.length?l[0]:l}function createArray(t,e,s){let n=new Float64Array(Math.abs((t-e)/s+1));for(let e=0;e<n.length;e++)n[e]=t+e*s;return n}function generateSanPlot(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{fromTo:s,logBaseY:n=2}=e;let i={};for(let e in s){let{from:o,to:a}=s[e];i[e]=o!==a?scale(t.slice(o,a),{logBaseY:n}):{x:[],y:[]},"negative"===e&&i[e].y.reverse()}return i}function scale(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{log10:s,abs:n}=Math,{logBaseY:i}=e;if(i){t=t.slice();const e=s(i);for(let i=0;i<t.length;i++)t[i]=s(n(t[i]))/e}const o=createFromToArray({from:0,to:t.length-1,length:t.length});return{x:o,y:t}}function xAbsolute(t){let e=t.slice();for(let t=0;t<e.length;t++)e[t]<0&&(e[t]*=-1);return e}const toString$2=Object.prototype.toString;function isAnyArray(t){return toString$2.call(t).endsWith("Array]")}var medianQuickselect_min={exports:{}};!function(t){!function(){function e(t){for(var e=0,i=t.length-1,o=void 0,a=void 0,l=void 0,r=n(e,i);;){if(i<=e)return t[r];if(i==e+1)return t[e]>t[i]&&s(t,e,i),t[r];for(t[o=n(e,i)]>t[i]&&s(t,o,i),t[e]>t[i]&&s(t,e,i),t[o]>t[e]&&s(t,o,e),s(t,o,e+1),a=e+1,l=i;;){do{a++}while(t[e]>t[a]);do{l--}while(t[l]>t[e]);if(l<a)break;s(t,a,l)}s(t,e,l),l<=r&&(e=a),l>=r&&(i=l-1)}}var s=function(t,e,s){var n;return n=[t[s],t[e]],t[e]=n[0],t[s]=n[1],n},n=function(t,e){return~~((t+e)/2)};t.exports?t.exports=e:window.median=e}()}(medianQuickselect_min);var quickSelectMedian=medianQuickselect_min.exports;function xMedian(t){if(!isAnyArray(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");return quickSelectMedian(t.slice())}function xAbsoluteMedian(t){return xMedian(xAbsolute(t))}function xAdd(t,e){let s=!1,n=0;if(isAnyArray(e)){if(t.length!==e.length)throw new Error("xAdd: size of array1 and array2 must be identical")}else s=!0,n=e;let i=new Float64Array(t.length);if(s)for(let e=0;e<t.length;e++)i[e]=t[e]+n;else for(let s=0;s<t.length;s++)i[s]=t[s]+e[s];return i}function xCheck(t){if(!isAnyArray(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty")}function xFindClosestIndex(t,e){let s=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};const{sorted:n=!0}=s;if(n){let s=0,n=t.length-1,i=0;for(;n-s>1;)if(i=s+(n-s>>1),t[i]<e)s=i;else{if(!(t[i]>e))return i;n=i}return s<t.length-1?Math.abs(e-t[s])<Math.abs(t[s+1]-e)?s:s+1:s}{let s=0,n=Number.POSITIVE_INFINITY;for(let i=0;i<t.length;i++){const o=Math.abs(t[i]-e);o<n&&(n=o,s=i)}return s}}function xGetFromToIndex(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{fromIndex:s,toIndex:n,from:i,to:o}=e;return void 0===s&&(s=void 0!==i?xFindClosestIndex(t,i):0),void 0===n&&(n=void 0!==o?xFindClosestIndex(t,o):t.length-1),s<0&&(s=0),n<0&&(n=0),s>=t.length&&(s=t.length-1),n>=t.length&&(n=t.length-1),s>n&&([s,n]=[n,s]),{fromIndex:s,toIndex:n}}function xMaxValue(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};xCheck(t);const{fromIndex:s,toIndex:n}=xGetFromToIndex(t,e);let i=t[s];for(let e=s+1;e<=n;e++)t[e]>i&&(i=t[e]);return i}function xMinValue(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};xCheck(t);const{fromIndex:s,toIndex:n}=xGetFromToIndex(t,e);let i=t[s];for(let e=s+1;e<=n;e++)t[e]<i&&(i=t[e]);return i}function xIsEquallySpaced(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(t.length<3)return!0;const{tolerance:s=.05}=e;let n=0,i=Number.MAX_SAFE_INTEGER;for(let e=0;e<t.length-1;++e){let s=t[e+1]-t[e];s<i&&(i=s),s>n&&(n=s)}return(n-i)/n<s}function xIsMonotoneIncreasing(t){if(t.length<2)return!0;for(let e=0;e<t.length-1;e++)if(t[e]>=t[e+1])return!1;return!0}function xMedianAbsoluteDeviation(t){const e=xMedian(t),s=new Float64Array(t.length);for(let n=0;n<t.length;n++)s[n]=Math.abs(t[n]-e);return{median:e,mad:xMedian(s)}}function xMinMaxValues(t){xCheck(t);let e=t[0],s=t[0];for(let n of t)n<e&&(e=n),n>s&&(s=n);return{min:e,max:s}}function xNoiseStandardDeviation(t){const{mad:e,median:s}=xMedianAbsoluteDeviation(t);return{sd:e/.6744897501960817,mad:e,median:s}}function xNorm(t){let e=0;for(const s of t)e+=s**2;return Math.sqrt(e)}function xSequentialFill(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if("object"!=typeof t||isAnyArray(t)||(e=t,t=[]),!isAnyArray(t))throw new TypeError("input must be an array");let{from:s=0,to:n=10,size:i=(Array.isArray(t)||t.constructor===Float64Array||t.constructor===Uint16Array?t.length:0),step:o=null}=e;if(i||(i=o?Math.floor((n-s)/o)+1:n-s+1),!o&&i&&(o=(n-s)/(i-1)),Array.isArray(t)){t.length=0;for(let e=0;e<i;e++)t.push(s),o&&(s+=o)}else{if(Array.isArray(t)||t.constructor===Float64Array||t.constructor===Uint16Array&&t.length!==i)throw new Error("sequentialFill typed array must have the correct length");for(let e=0;e<i;e++)(Array.isArray(t)||t.constructor===Float64Array||t.constructor===Uint16Array)&&(t[e]=s),o&&(s+=o)}return Array.isArray(t)||t.constructor===Float64Array||t.constructor===Uint16Array?Array.from(t):[]}function xyCheck(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{minLength:s}=e;if("object"!=typeof t||!isAnyArray(t.x)||!isAnyArray(t.y))throw new Error("Data must be an object of x and y arrays");if(t.x.length!==t.y.length)throw new Error("The x and y arrays must have the same length");if(s&&t.x.length<s)throw new Error(`data.x must have a length of at least ${s}`)}function xyFindClosestPoint(t,e){const{x:s,y:n}=t,i=xFindClosestIndex(s,e);return{x:s[i],y:n[i]}}function zonesNormalize(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{from:s=Number.NEGATIVE_INFINITY,to:n=Number.POSITIVE_INFINITY,exclusions:i=[]}=e;s>n&&([s,n]=[n,s]),t=JSON.parse(JSON.stringify(t)).map((t=>t.from>t.to?{from:t.to,to:t.from}:t)),t=t.sort(((t,e)=>t.from!==e.from?t.from-e.from:t.to-e.to)),0===t.length&&t.push({from:s,to:n});for(const e of t)s>e.from&&(e.from=s),n<e.to&&(e.to=n);if(t=t.filter((t=>t.from<=t.to)),0===t.length)return[];let o=t[0],a=[o];for(let e=1;e<t.length;e++){let s=t[e];s.from<=o.to?o.to<s.to&&(o.to=s.to):(o=s,a.push(o))}if(0===i.length)return a;const l=zonesNormalize(i);let r=0;const m=[];let g=0;for(let t=0;t<a.length&&!(g++>5);t++){const e=a[t];if(r!==l.length){for(;r<l.length&&l[r].to<=e.from;)r++;if(r!==l.length)if(e.to<l[r].from)m.push(e);else{if(l[r].to>=e.to){if(l[r].from<=e.from)continue;m.push({from:l[r].to,to:e.to})}l[r].from>e.from&&m.push({from:e.from,to:l[r].from}),e.from=l[r].to,t--}else m.push(e)}else m.push(e)}return m}function xyExtract(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};xyCheck(t);const{x:s,y:n}=t;let{zones:i}=e;if(i=zonesNormalize(i),void 0===s||void 0===n||!Array.isArray(i)||0===i.length)return t;let o=[],a=[],l=i[0],r=0;t:for(let t=0;t<s.length;t++){for(;l.to<s[t];)if(r++,l=i[r],!l){t=s.length;break t}s[t]>=l.from&&(o.push(s[t]),a.push(n[t]))}return{x:o,y:a}}function xyIntegration(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};xyCheck(t,{minLength:1});const{x:s,y:n}=t;if(1===s.length)return 0;const{fromIndex:i,toIndex:o}=xGetFromToIndex(s,e);let a=0;for(let t=i;t<o;t++)a+=(s[t+1]-s[t])*(n[t+1]+n[t])/2;return a}function matrixCheck(t){if(0===t.length||0===t[0].length)throw new RangeError("matrix should contain data");const e=t[0].length;for(let s=1;s<t.length;s++)if(t[s].length!==e)throw new RangeError("All rows should has the same length")}function matrixMinMaxZ(t){matrixCheck(t);const e=t.length,s=t[0].length;let n=t[0][0],i=t[0][0];for(let o=0;o<s;o++)for(let s=0;s<e;s++)t[s][o]<n&&(n=t[s][o]),t[s][o]>i&&(i=t[s][o]);return{min:n,max:i}}function max(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isAnyArray(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");var s=e.fromIndex,n=void 0===s?0:s,i=e.toIndex,o=void 0===i?t.length:i;if(n<0||n>=t.length||!Number.isInteger(n))throw new Error("fromIndex must be a positive integer smaller than length");if(o<=n||o>t.length||!Number.isInteger(o))throw new Error("toIndex must be an integer greater than fromIndex and at most equal to length");for(var a=t[n],l=n+1;l<o;l++)t[l]>a&&(a=t[l]);return a}function min(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isAnyArray(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");var s=e.fromIndex,n=void 0===s?0:s,i=e.toIndex,o=void 0===i?t.length:i;if(n<0||n>=t.length||!Number.isInteger(n))throw new Error("fromIndex must be a positive integer smaller than length");if(o<=n||o>t.length||!Number.isInteger(o))throw new Error("toIndex must be an integer greater than fromIndex and at most equal to length");for(var a=t[n],l=n+1;l<o;l++)t[l]<a&&(a=t[l]);return a}function rescale(t){var e,s=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isAnyArray(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");if(void 0!==s.output){if(!isAnyArray(s.output))throw new TypeError("output option must be an array if specified");e=s.output}else e=new Array(t.length);var n=min(t),i=max(t);if(n===i)throw new RangeError("minimum and maximum input values are equal. Cannot rescale a constant array");var o=s.min,a=void 0===o?s.autoMinMax?n:0:o,l=s.max,r=void 0===l?s.autoMinMax?i:1:l;if(a>=r)throw new RangeError("min option must be smaller than max option");for(var m=(r-a)/(i-n),g=0;g<t.length;g++)e[g]=(t[g]-n)*m+a;return e}const indent=" ".repeat(2),indentData=" ".repeat(4);function inspectMatrix(){return inspectMatrixWithOptions(this)}function inspectMatrixWithOptions(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{maxRows:s=15,maxColumns:n=10,maxNumSize:i=8,padMinus:o="auto"}=e;return`${t.constructor.name} {\n${indent}[\n${indentData}${inspectData(t,s,n,i,o)}\n${indent}]\n${indent}rows: ${t.rows}\n${indent}columns: ${t.columns}\n}`}function inspectData(t,e,s,n,i){const{rows:o,columns:a}=t,l=Math.min(o,e),r=Math.min(a,s),m=[];if("auto"===i){i=!1;t:for(let e=0;e<l;e++)for(let s=0;s<r;s++)if(t.get(e,s)<0){i=!0;break t}}for(let e=0;e<l;e++){let s=[];for(let o=0;o<r;o++)s.push(formatNumber(t.get(e,o),n,i));m.push(`${s.join(" ")}`)}return r!==a&&(m[m.length-1]+=` ... ${a-s} more columns`),l!==o&&m.push(`... ${o-e} more rows`),m.join(`\n${indentData}`)}function formatNumber(t,e,s){return(t>=0&&s?` ${formatNumber2(t,e-1)}`:formatNumber2(t,e)).padEnd(e)}function formatNumber2(t,e){let s=t.toString();if(s.length<=e)return s;let n=t.toFixed(e);if(n.length>e&&(n=t.toFixed(Math.max(0,e-(n.length-e)))),n.length<=e&&!n.startsWith("0.000")&&!n.startsWith("-0.000"))return n;let i=t.toExponential(e);return i.length>e&&(i=t.toExponential(Math.max(0,e-(i.length-e)))),i.slice(0)}function installMathOperations(t,e){t.prototype.add=function(t){return"number"==typeof t?this.addS(t):this.addM(t)},t.prototype.addS=function(t){for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,this.get(e,s)+t);return this},t.prototype.addM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,this.get(e,s)+t.get(e,s));return this},t.add=function(t,s){return new e(t).add(s)},t.prototype.sub=function(t){return"number"==typeof t?this.subS(t):this.subM(t)},t.prototype.subS=function(t){for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,this.get(e,s)-t);return this},t.prototype.subM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,this.get(e,s)-t.get(e,s));return this},t.sub=function(t,s){return new e(t).sub(s)},t.prototype.subtract=t.prototype.sub,t.prototype.subtractS=t.prototype.subS,t.prototype.subtractM=t.prototype.subM,t.subtract=t.sub,t.prototype.mul=function(t){return"number"==typeof t?this.mulS(t):this.mulM(t)},t.prototype.mulS=function(t){for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,this.get(e,s)*t);return this},t.prototype.mulM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,this.get(e,s)*t.get(e,s));return this},t.mul=function(t,s){return new e(t).mul(s)},t.prototype.multiply=t.prototype.mul,t.prototype.multiplyS=t.prototype.mulS,t.prototype.multiplyM=t.prototype.mulM,t.multiply=t.mul,t.prototype.div=function(t){return"number"==typeof t?this.divS(t):this.divM(t)},t.prototype.divS=function(t){for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,this.get(e,s)/t);return this},t.prototype.divM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,this.get(e,s)/t.get(e,s));return this},t.div=function(t,s){return new e(t).div(s)},t.prototype.divide=t.prototype.div,t.prototype.divideS=t.prototype.divS,t.prototype.divideM=t.prototype.divM,t.divide=t.div,t.prototype.mod=function(t){return"number"==typeof t?this.modS(t):this.modM(t)},t.prototype.modS=function(t){for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,this.get(e,s)%t);return this},t.prototype.modM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,this.get(e,s)%t.get(e,s));return this},t.mod=function(t,s){return new e(t).mod(s)},t.prototype.modulus=t.prototype.mod,t.prototype.modulusS=t.prototype.modS,t.prototype.modulusM=t.prototype.modM,t.modulus=t.mod,t.prototype.and=function(t){return"number"==typeof t?this.andS(t):this.andM(t)},t.prototype.andS=function(t){for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,this.get(e,s)&t);return this},t.prototype.andM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,this.get(e,s)&t.get(e,s));return this},t.and=function(t,s){return new e(t).and(s)},t.prototype.or=function(t){return"number"==typeof t?this.orS(t):this.orM(t)},t.prototype.orS=function(t){for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,this.get(e,s)|t);return this},t.prototype.orM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,this.get(e,s)|t.get(e,s));return this},t.or=function(t,s){return new e(t).or(s)},t.prototype.xor=function(t){return"number"==typeof t?this.xorS(t):this.xorM(t)},t.prototype.xorS=function(t){for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,this.get(e,s)^t);return this},t.prototype.xorM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,this.get(e,s)^t.get(e,s));return this},t.xor=function(t,s){return new e(t).xor(s)},t.prototype.leftShift=function(t){return"number"==typeof t?this.leftShiftS(t):this.leftShiftM(t)},t.prototype.leftShiftS=function(t){for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,this.get(e,s)<<t);return this},t.prototype.leftShiftM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,this.get(e,s)<<t.get(e,s));return this},t.leftShift=function(t,s){return new e(t).leftShift(s)},t.prototype.signPropagatingRightShift=function(t){return"number"==typeof t?this.signPropagatingRightShiftS(t):this.signPropagatingRightShiftM(t)},t.prototype.signPropagatingRightShiftS=function(t){for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,this.get(e,s)>>t);return this},t.prototype.signPropagatingRightShiftM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,this.get(e,s)>>t.get(e,s));return this},t.signPropagatingRightShift=function(t,s){return new e(t).signPropagatingRightShift(s)},t.prototype.rightShift=function(t){return"number"==typeof t?this.rightShiftS(t):this.rightShiftM(t)},t.prototype.rightShiftS=function(t){for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,this.get(e,s)>>>t);return this},t.prototype.rightShiftM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,this.get(e,s)>>>t.get(e,s));return this},t.rightShift=function(t,s){return new e(t).rightShift(s)},t.prototype.zeroFillRightShift=t.prototype.rightShift,t.prototype.zeroFillRightShiftS=t.prototype.rightShiftS,t.prototype.zeroFillRightShiftM=t.prototype.rightShiftM,t.zeroFillRightShift=t.rightShift,t.prototype.not=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,~this.get(t,e));return this},t.not=function(t){return new e(t).not()},t.prototype.abs=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.abs(this.get(t,e)));return this},t.abs=function(t){return new e(t).abs()},t.prototype.acos=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.acos(this.get(t,e)));return this},t.acos=function(t){return new e(t).acos()},t.prototype.acosh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.acosh(this.get(t,e)));return this},t.acosh=function(t){return new e(t).acosh()},t.prototype.asin=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.asin(this.get(t,e)));return this},t.asin=function(t){return new e(t).asin()},t.prototype.asinh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.asinh(this.get(t,e)));return this},t.asinh=function(t){return new e(t).asinh()},t.prototype.atan=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.atan(this.get(t,e)));return this},t.atan=function(t){return new e(t).atan()},t.prototype.atanh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.atanh(this.get(t,e)));return this},t.atanh=function(t){return new e(t).atanh()},t.prototype.cbrt=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.cbrt(this.get(t,e)));return this},t.cbrt=function(t){return new e(t).cbrt()},t.prototype.ceil=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.ceil(this.get(t,e)));return this},t.ceil=function(t){return new e(t).ceil()},t.prototype.clz32=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.clz32(this.get(t,e)));return this},t.clz32=function(t){return new e(t).clz32()},t.prototype.cos=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.cos(this.get(t,e)));return this},t.cos=function(t){return new e(t).cos()},t.prototype.cosh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.cosh(this.get(t,e)));return this},t.cosh=function(t){return new e(t).cosh()},t.prototype.exp=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.exp(this.get(t,e)));return this},t.exp=function(t){return new e(t).exp()},t.prototype.expm1=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.expm1(this.get(t,e)));return this},t.expm1=function(t){return new e(t).expm1()},t.prototype.floor=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.floor(this.get(t,e)));return this},t.floor=function(t){return new e(t).floor()},t.prototype.fround=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.fround(this.get(t,e)));return this},t.fround=function(t){return new e(t).fround()},t.prototype.log=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log(this.get(t,e)));return this},t.log=function(t){return new e(t).log()},t.prototype.log1p=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log1p(this.get(t,e)));return this},t.log1p=function(t){return new e(t).log1p()},t.prototype.log10=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log10(this.get(t,e)));return this},t.log10=function(t){return new e(t).log10()},t.prototype.log2=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log2(this.get(t,e)));return this},t.log2=function(t){return new e(t).log2()},t.prototype.round=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.round(this.get(t,e)));return this},t.round=function(t){return new e(t).round()},t.prototype.sign=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sign(this.get(t,e)));return this},t.sign=function(t){return new e(t).sign()},t.prototype.sin=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sin(this.get(t,e)));return this},t.sin=function(t){return new e(t).sin()},t.prototype.sinh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sinh(this.get(t,e)));return this},t.sinh=function(t){return new e(t).sinh()},t.prototype.sqrt=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sqrt(this.get(t,e)));return this},t.sqrt=function(t){return new e(t).sqrt()},t.prototype.tan=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.tan(this.get(t,e)));return this},t.tan=function(t){return new e(t).tan()},t.prototype.tanh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.tanh(this.get(t,e)));return this},t.tanh=function(t){return new e(t).tanh()},t.prototype.trunc=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.trunc(this.get(t,e)));return this},t.trunc=function(t){return new e(t).trunc()},t.pow=function(t,s){return new e(t).pow(s)},t.prototype.pow=function(t){return"number"==typeof t?this.powS(t):this.powM(t)},t.prototype.powS=function(t){for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,Math.pow(this.get(e,s),t));return this},t.prototype.powM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,Math.pow(this.get(e,s),t.get(e,s)));return this}}function checkRowIndex(t,e,s){let n=s?t.rows:t.rows-1;if(e<0||e>n)throw new RangeError("Row index out of range")}function checkColumnIndex(t,e,s){let n=s?t.columns:t.columns-1;if(e<0||e>n)throw new RangeError("Column index out of range")}function checkRowVector(t,e){if(e.to1DArray&&(e=e.to1DArray()),e.length!==t.columns)throw new RangeError("vector size must be the same as the number of columns");return e}function checkColumnVector(t,e){if(e.to1DArray&&(e=e.to1DArray()),e.length!==t.rows)throw new RangeError("vector size must be the same as the number of rows");return e}function checkRowIndices(t,e){if(!isAnyArray(e))throw new TypeError("row indices must be an array");for(let s=0;s<e.length;s++)if(e[s]<0||e[s]>=t.rows)throw new RangeError("row indices are out of range")}function checkColumnIndices(t,e){if(!isAnyArray(e))throw new TypeError("column indices must be an array");for(let s=0;s<e.length;s++)if(e[s]<0||e[s]>=t.columns)throw new RangeError("column indices are out of range")}function checkRange(t,e,s,n,i){if(5!==arguments.length)throw new RangeError("expected 4 arguments");if(checkNumber("startRow",e),checkNumber("endRow",s),checkNumber("startColumn",n),checkNumber("endColumn",i),e>s||n>i||e<0||e>=t.rows||s<0||s>=t.rows||n<0||n>=t.columns||i<0||i>=t.columns)throw new RangeError("Submatrix indices are out of range")}function newArray$1(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,s=[];for(let n=0;n<t;n++)s.push(e);return s}function checkNumber(t,e){if("number"!=typeof e)throw new TypeError(`${t} must be a number`)}function checkNonEmpty(t){if(t.isEmpty())throw new Error("Empty matrix has no elements to index")}function sumByRow(t){let e=newArray$1(t.rows);for(let s=0;s<t.rows;++s)for(let n=0;n<t.columns;++n)e[s]+=t.get(s,n);return e}function sumByColumn(t){let e=newArray$1(t.columns);for(let s=0;s<t.rows;++s)for(let n=0;n<t.columns;++n)e[n]+=t.get(s,n);return e}function sumAll(t){let e=0;for(let s=0;s<t.rows;s++)for(let n=0;n<t.columns;n++)e+=t.get(s,n);return e}function productByRow(t){let e=newArray$1(t.rows,1);for(let s=0;s<t.rows;++s)for(let n=0;n<t.columns;++n)e[s]*=t.get(s,n);return e}function productByColumn(t){let e=newArray$1(t.columns,1);for(let s=0;s<t.rows;++s)for(let n=0;n<t.columns;++n)e[n]*=t.get(s,n);return e}function productAll(t){let e=1;for(let s=0;s<t.rows;s++)for(let n=0;n<t.columns;n++)e*=t.get(s,n);return e}function varianceByRow(t,e,s){const n=t.rows,i=t.columns,o=[];for(let a=0;a<n;a++){let n=0,l=0,r=0;for(let e=0;e<i;e++)r=t.get(a,e)-s[a],n+=r,l+=r*r;e?o.push((l-n*n/i)/(i-1)):o.push((l-n*n/i)/i)}return o}function varianceByColumn(t,e,s){const n=t.rows,i=t.columns,o=[];for(let a=0;a<i;a++){let i=0,l=0,r=0;for(let e=0;e<n;e++)r=t.get(e,a)-s[a],i+=r,l+=r*r;e?o.push((l-i*i/n)/(n-1)):o.push((l-i*i/n)/n)}return o}function varianceAll(t,e,s){const n=t.rows,i=t.columns,o=n*i;let a=0,l=0,r=0;for(let e=0;e<n;e++)for(let n=0;n<i;n++)r=t.get(e,n)-s,a+=r,l+=r*r;return e?(l-a*a/o)/(o-1):(l-a*a/o)/o}function centerByRow(t,e){for(let s=0;s<t.rows;s++)for(let n=0;n<t.columns;n++)t.set(s,n,t.get(s,n)-e[s])}function centerByColumn(t,e){for(let s=0;s<t.rows;s++)for(let n=0;n<t.columns;n++)t.set(s,n,t.get(s,n)-e[n])}function centerAll(t,e){for(let s=0;s<t.rows;s++)for(let n=0;n<t.columns;n++)t.set(s,n,t.get(s,n)-e)}function getScaleByRow(t){const e=[];for(let s=0;s<t.rows;s++){let n=0;for(let e=0;e<t.columns;e++)n+=Math.pow(t.get(s,e),2)/(t.columns-1);e.push(Math.sqrt(n))}return e}function scaleByRow(t,e){for(let s=0;s<t.rows;s++)for(let n=0;n<t.columns;n++)t.set(s,n,t.get(s,n)/e[s])}function getScaleByColumn(t){const e=[];for(let s=0;s<t.columns;s++){let n=0;for(let e=0;e<t.rows;e++)n+=Math.pow(t.get(e,s),2)/(t.rows-1);e.push(Math.sqrt(n))}return e}function scaleByColumn(t,e){for(let s=0;s<t.rows;s++)for(let n=0;n<t.columns;n++)t.set(s,n,t.get(s,n)/e[n])}function getScaleAll(t){const e=t.size-1;let s=0;for(let n=0;n<t.columns;n++)for(let i=0;i<t.rows;i++)s+=Math.pow(t.get(i,n),2)/e;return Math.sqrt(s)}function scaleAll(t,e){for(let s=0;s<t.rows;s++)for(let n=0;n<t.columns;n++)t.set(s,n,t.get(s,n)/e)}class AbstractMatrix{static from1DArray(t,e,s){if(t*e!==s.length)throw new RangeError("data length does not match given dimensions");let n=new Matrix(t,e);for(let i=0;i<t;i++)for(let t=0;t<e;t++)n.set(i,t,s[i*e+t]);return n}static rowVector(t){let e=new Matrix(1,t.length);for(let s=0;s<t.length;s++)e.set(0,s,t[s]);return e}static columnVector(t){let e=new Matrix(t.length,1);for(let s=0;s<t.length;s++)e.set(s,0,t[s]);return e}static zeros(t,e){return new Matrix(t,e)}static ones(t,e){return new Matrix(t,e).fill(1)}static rand(t,e){let s=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};if("object"!=typeof s)throw new TypeError("options must be an object");const{random:n=Math.random}=s;let i=new Matrix(t,e);for(let s=0;s<t;s++)for(let t=0;t<e;t++)i.set(s,t,n());return i}static randInt(t,e){let s=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};if("object"!=typeof s)throw new TypeError("options must be an object");const{min:n=0,max:i=1e3,random:o=Math.random}=s;if(!Number.isInteger(n))throw new TypeError("min must be an integer");if(!Number.isInteger(i))throw new TypeError("max must be an integer");if(n>=i)throw new RangeError("min must be smaller than max");let a=i-n,l=new Matrix(t,e);for(let s=0;s<t;s++)for(let t=0;t<e;t++){let e=n+Math.round(o()*a);l.set(s,t,e)}return l}static eye(t,e,s){void 0===e&&(e=t),void 0===s&&(s=1);let n=Math.min(t,e),i=this.zeros(t,e);for(let t=0;t<n;t++)i.set(t,t,s);return i}static diag(t,e,s){let n=t.length;void 0===e&&(e=n),void 0===s&&(s=e);let i=Math.min(n,e,s),o=this.zeros(e,s);for(let e=0;e<i;e++)o.set(e,e,t[e]);return o}static min(t,e){t=this.checkMatrix(t),e=this.checkMatrix(e);let s=t.rows,n=t.columns,i=new Matrix(s,n);for(let o=0;o<s;o++)for(let s=0;s<n;s++)i.set(o,s,Math.min(t.get(o,s),e.get(o,s)));return i}static max(t,e){t=this.checkMatrix(t),e=this.checkMatrix(e);let s=t.rows,n=t.columns,i=new this(s,n);for(let o=0;o<s;o++)for(let s=0;s<n;s++)i.set(o,s,Math.max(t.get(o,s),e.get(o,s)));return i}static checkMatrix(t){return AbstractMatrix.isMatrix(t)?t:new Matrix(t)}static isMatrix(t){return null!=t&&"Matrix"===t.klass}get size(){return this.rows*this.columns}apply(t){if("function"!=typeof t)throw new TypeError("callback must be a function");for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)t.call(this,e,s);return this}to1DArray(){let t=[];for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)t.push(this.get(e,s));return t}to2DArray(){let t=[];for(let e=0;e<this.rows;e++){t.push([]);for(let s=0;s<this.columns;s++)t[e].push(this.get(e,s))}return t}toJSON(){return this.to2DArray()}isRowVector(){return 1===this.rows}isColumnVector(){return 1===this.columns}isVector(){return 1===this.rows||1===this.columns}isSquare(){return this.rows===this.columns}isEmpty(){return 0===this.rows||0===this.columns}isSymmetric(){if(this.isSquare()){for(let t=0;t<this.rows;t++)for(let e=0;e<=t;e++)if(this.get(t,e)!==this.get(e,t))return!1;return!0}return!1}isEchelonForm(){let t=0,e=0,s=-1,n=!0,i=!1;for(;t<this.rows&&n;){for(e=0,i=!1;e<this.columns&&!1===i;)0===this.get(t,e)?e++:1===this.get(t,e)&&e>s?(i=!0,s=e):(n=!1,i=!0);t++}return n}isReducedEchelonForm(){let t=0,e=0,s=-1,n=!0,i=!1;for(;t<this.rows&&n;){for(e=0,i=!1;e<this.columns&&!1===i;)0===this.get(t,e)?e++:1===this.get(t,e)&&e>s?(i=!0,s=e):(n=!1,i=!0);for(let s=e+1;s<this.rows;s++)0!==this.get(t,s)&&(n=!1);t++}return n}echelonForm(){let t=this.clone(),e=0,s=0;for(;e<t.rows&&s<t.columns;){let n=e;for(let i=e;i<t.rows;i++)t.get(i,s)>t.get(n,s)&&(n=i);if(0===t.get(n,s))s++;else{t.swapRows(e,n);let i=t.get(e,s);for(let n=s;n<t.columns;n++)t.set(e,n,t.get(e,n)/i);for(let n=e+1;n<t.rows;n++){let i=t.get(n,s)/t.get(e,s);t.set(n,s,0);for(let o=s+1;o<t.columns;o++)t.set(n,o,t.get(n,o)-t.get(e,o)*i)}e++,s++}}return t}reducedEchelonForm(){let t=this.echelonForm(),e=t.columns,s=t.rows,n=s-1;for(;n>=0;)if(0===t.maxRow(n))n--;else{let i=0,o=!1;for(;i<s&&!1===o;)1===t.get(n,i)?o=!0:i++;for(let s=0;s<n;s++){let o=t.get(s,i);for(let a=i;a<e;a++){let e=t.get(s,a)-o*t.get(n,a);t.set(s,a,e)}}n--}return t}set(){throw new Error("set method is unimplemented")}get(){throw new Error("get method is unimplemented")}repeat(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};if("object"!=typeof t)throw new TypeError("options must be an object");const{rows:e=1,columns:s=1}=t;if(!Number.isInteger(e)||e<=0)throw new TypeError("rows must be a positive integer");if(!Number.isInteger(s)||s<=0)throw new TypeError("columns must be a positive integer");let n=new Matrix(this.rows*e,this.columns*s);for(let t=0;t<e;t++)for(let e=0;e<s;e++)n.setSubMatrix(this,this.rows*t,this.columns*e);return n}fill(t){for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,t);return this}neg(){return this.mulS(-1)}getRow(t){checkRowIndex(this,t);let e=[];for(let s=0;s<this.columns;s++)e.push(this.get(t,s));return e}getRowVector(t){return Matrix.rowVector(this.getRow(t))}setRow(t,e){checkRowIndex(this,t),e=checkRowVector(this,e);for(let s=0;s<this.columns;s++)this.set(t,s,e[s]);return this}swapRows(t,e){checkRowIndex(this,t),checkRowIndex(this,e);for(let s=0;s<this.columns;s++){let n=this.get(t,s);this.set(t,s,this.get(e,s)),this.set(e,s,n)}return this}getColumn(t){checkColumnIndex(this,t);let e=[];for(let s=0;s<this.rows;s++)e.push(this.get(s,t));return e}getColumnVector(t){return Matrix.columnVector(this.getColumn(t))}setColumn(t,e){checkColumnIndex(this,t),e=checkColumnVector(this,e);for(let s=0;s<this.rows;s++)this.set(s,t,e[s]);return this}swapColumns(t,e){checkColumnIndex(this,t),checkColumnIndex(this,e);for(let s=0;s<this.rows;s++){let n=this.get(s,t);this.set(s,t,this.get(s,e)),this.set(s,e,n)}return this}addRowVector(t){t=checkRowVector(this,t);for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,this.get(e,s)+t[s]);return this}subRowVector(t){t=checkRowVector(this,t);for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,this.get(e,s)-t[s]);return this}mulRowVector(t){t=checkRowVector(this,t);for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,this.get(e,s)*t[s]);return this}divRowVector(t){t=checkRowVector(this,t);for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,this.get(e,s)/t[s]);return this}addColumnVector(t){t=checkColumnVector(this,t);for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,this.get(e,s)+t[e]);return this}subColumnVector(t){t=checkColumnVector(this,t);for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,this.get(e,s)-t[e]);return this}mulColumnVector(t){t=checkColumnVector(this,t);for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,this.get(e,s)*t[e]);return this}divColumnVector(t){t=checkColumnVector(this,t);for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.set(e,s,this.get(e,s)/t[e]);return this}mulRow(t,e){checkRowIndex(this,t);for(let s=0;s<this.columns;s++)this.set(t,s,this.get(t,s)*e);return this}mulColumn(t,e){checkColumnIndex(this,t);for(let s=0;s<this.rows;s++)this.set(s,t,this.get(s,t)*e);return this}max(t){if(this.isEmpty())return NaN;switch(t){case"row":{const t=new Array(this.rows).fill(Number.NEGATIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.get(e,s)>t[e]&&(t[e]=this.get(e,s));return t}case"column":{const t=new Array(this.columns).fill(Number.NEGATIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.get(e,s)>t[s]&&(t[s]=this.get(e,s));return t}case void 0:{let t=this.get(0,0);for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.get(e,s)>t&&(t=this.get(e,s));return t}default:throw new Error(`invalid option: ${t}`)}}maxIndex(){checkNonEmpty(this);let t=this.get(0,0),e=[0,0];for(let s=0;s<this.rows;s++)for(let n=0;n<this.columns;n++)this.get(s,n)>t&&(t=this.get(s,n),e[0]=s,e[1]=n);return e}min(t){if(this.isEmpty())return NaN;switch(t){case"row":{const t=new Array(this.rows).fill(Number.POSITIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.get(e,s)<t[e]&&(t[e]=this.get(e,s));return t}case"column":{const t=new Array(this.columns).fill(Number.POSITIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.get(e,s)<t[s]&&(t[s]=this.get(e,s));return t}case void 0:{let t=this.get(0,0);for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)this.get(e,s)<t&&(t=this.get(e,s));return t}default:throw new Error(`invalid option: ${t}`)}}minIndex(){checkNonEmpty(this);let t=this.get(0,0),e=[0,0];for(let s=0;s<this.rows;s++)for(let n=0;n<this.columns;n++)this.get(s,n)<t&&(t=this.get(s,n),e[0]=s,e[1]=n);return e}maxRow(t){if(checkRowIndex(this,t),this.isEmpty())return NaN;let e=this.get(t,0);for(let s=1;s<this.columns;s++)this.get(t,s)>e&&(e=this.get(t,s));return e}maxRowIndex(t){checkRowIndex(this,t),checkNonEmpty(this);let e=this.get(t,0),s=[t,0];for(let n=1;n<this.columns;n++)this.get(t,n)>e&&(e=this.get(t,n),s[1]=n);return s}minRow(t){if(checkRowIndex(this,t),this.isEmpty())return NaN;let e=this.get(t,0);for(let s=1;s<this.columns;s++)this.get(t,s)<e&&(e=this.get(t,s));return e}minRowIndex(t){checkRowIndex(this,t),checkNonEmpty(this);let e=this.get(t,0),s=[t,0];for(let n=1;n<this.columns;n++)this.get(t,n)<e&&(e=this.get(t,n),s[1]=n);return s}maxColumn(t){if(checkColumnIndex(this,t),this.isEmpty())return NaN;let e=this.get(0,t);for(let s=1;s<this.rows;s++)this.get(s,t)>e&&(e=this.get(s,t));return e}maxColumnIndex(t){checkColumnIndex(this,t),checkNonEmpty(this);let e=this.get(0,t),s=[0,t];for(let n=1;n<this.rows;n++)this.get(n,t)>e&&(e=this.get(n,t),s[0]=n);return s}minColumn(t){if(checkColumnIndex(this,t),this.isEmpty())return NaN;let e=this.get(0,t);for(let s=1;s<this.rows;s++)this.get(s,t)<e&&(e=this.get(s,t));return e}minColumnIndex(t){checkColumnIndex(this,t),checkNonEmpty(this);let e=this.get(0,t),s=[0,t];for(let n=1;n<this.rows;n++)this.get(n,t)<e&&(e=this.get(n,t),s[0]=n);return s}diag(){let t=Math.min(this.rows,this.columns),e=[];for(let s=0;s<t;s++)e.push(this.get(s,s));return e}norm(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"frobenius",e=0;if("max"===t)return this.max();if("frobenius"===t){for(let t=0;t<this.rows;t++)for(let s=0;s<this.columns;s++)e+=this.get(t,s)*this.get(t,s);return Math.sqrt(e)}throw new RangeError(`unknown norm type: ${t}`)}cumulativeSum(){let t=0;for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)t+=this.get(e,s),this.set(e,s,t);return this}dot(t){AbstractMatrix.isMatrix(t)&&(t=t.to1DArray());let e=this.to1DArray();if(e.length!==t.length)throw new RangeError("vectors do not have the same size");let s=0;for(let n=0;n<e.length;n++)s+=e[n]*t[n];return s}mmul(t){t=Matrix.checkMatrix(t);let e=this.rows,s=this.columns,n=t.columns,i=new Matrix(e,n),o=new Float64Array(s);for(let a=0;a<n;a++){for(let e=0;e<s;e++)o[e]=t.get(e,a);for(let t=0;t<e;t++){let e=0;for(let n=0;n<s;n++)e+=this.get(t,n)*o[n];i.set(t,a,e)}}return i}strassen2x2(t){t=Matrix.checkMatrix(t);let e=new Matrix(2,2);const s=this.get(0,0),n=t.get(0,0),i=this.get(0,1),o=t.get(0,1),a=this.get(1,0),l=t.get(1,0),r=this.get(1,1),m=t.get(1,1),g=(s+r)*(n+m),u=(a+r)*n,c=s*(o-m),C=r*(l-n),f=(s+i)*m,h=g+C-f+(i-r)*(l+m),p=c+f,d=u+C,y=g-u+c+(a-s)*(n+o);return e.set(0,0,h),e.set(0,1,p),e.set(1,0,d),e.set(1,1,y),e}strassen3x3(t){t=Matrix.checkMatrix(t);let e=new Matrix(3,3);const s=this.get(0,0),n=this.get(0,1),i=this.get(0,2),o=this.get(1,0),a=this.get(1,1),l=this.get(1,2),r=this.get(2,0),m=this.get(2,1),g=this.get(2,2),u=t.get(0,0),c=t.get(0,1),C=t.get(0,2),f=t.get(1,0),h=t.get(1,1),p=t.get(1,2),d=t.get(2,0),y=t.get(2,1),H=t.get(2,2),v=(s-o)*(-c+h),b=(-s+o+a)*(u-c+h),w=(o+a)*(-u+c),O=s*u,x=(-s+r+m)*(u-C+p),D=(-s+r)*(C-p),j=(r+m)*(-u+C),A=(-i+m+g)*(h+d-y),S=(i-g)*(h-y),M=i*d,T=(m+g)*(-d+y),$=(-i+a+l)*(p+d-H),N=(i-l)*(p-H),E=(a+l)*(-d+H),k=O+M+n*f,_=(s+n+i-o-a-m-g)*h+b+w+O+A+M+T,I=O+x+j+(s+n+i-a-l-r-m)*p+M+$+E,F=v+a*(-u+c+f-h-p-d+H)+b+O+M+$+N,P=v+b+w+O+l*y,L=M+$+N+E+o*C,z=O+x+D+m*(-u+C+f-h-p-d+y)+A+S+M,R=A+S+M+T+r*c,q=O+x+D+j+g*H;return e.set(0,0,k),e.set(0,1,_),e.set(0,2,I),e.set(1,0,F),e.set(1,1,P),e.set(1,2,L),e.set(2,0,z),e.set(2,1,R),e.set(2,2,q),e}mmulStrassen(t){t=Matrix.checkMatrix(t);let e=this.clone(),s=e.rows,n=e.columns,i=t.rows,o=t.columns;function a(t,e,s){let n=t.rows,i=t.columns;if(n===e&&i===s)return t;{let n=AbstractMatrix.zeros(e,s);return n=n.setSubMatrix(t,0,0),n}}n!==i&&console.warn(`Multiplying ${s} x ${n} and ${i} x ${o} matrix: dimensions do not match.`);let l=Math.max(s,i),r=Math.max(n,o);return e=a(e,l,r),function t(e,s,n,i){if(n<=512||i<=512)return e.mmul(s);n%2==1&&i%2==1?(e=a(e,n+1,i+1),s=a(s,n+1,i+1)):n%2==1?(e=a(e,n+1,i),s=a(s,n+1,i)):i%2==1&&(e=a(e,n,i+1),s=a(s,n,i+1));let o=parseInt(e.rows/2,10),l=parseInt(e.columns/2,10),r=e.subMatrix(0,o-1,0,l-1),m=s.subMatrix(0,o-1,0,l-1),g=e.subMatrix(0,o-1,l,e.columns-1),u=s.subMatrix(0,o-1,l,s.columns-1),c=e.subMatrix(o,e.rows-1,0,l-1),C=s.subMatrix(o,s.rows-1,0,l-1),f=e.subMatrix(o,e.rows-1,l,e.columns-1),h=s.subMatrix(o,s.rows-1,l,s.columns-1),p=t(AbstractMatrix.add(r,f),AbstractMatrix.add(m,h),o,l),d=t(AbstractMatrix.add(c,f),m,o,l),y=t(r,AbstractMatrix.sub(u,h),o,l),H=t(f,AbstractMatrix.sub(C,m),o,l),v=t(AbstractMatrix.add(r,g),h,o,l),b=t(AbstractMatrix.sub(c,r),AbstractMatrix.add(m,u),o,l),w=t(AbstractMatrix.sub(g,f),AbstractMatrix.add(C,h),o,l),O=AbstractMatrix.add(p,H);O.sub(v),O.add(w);let x=AbstractMatrix.add(y,v),D=AbstractMatrix.add(d,H),j=AbstractMatrix.sub(p,d);j.add(y),j.add(b);let A=AbstractMatrix.zeros(2*O.rows,2*O.columns);return A=A.setSubMatrix(O,0,0),A=A.setSubMatrix(x,O.rows,0),A=A.setSubMatrix(D,0,O.columns),A=A.setSubMatrix(j,O.rows,O.columns),A.subMatrix(0,n-1,0,i-1)}(e,t=a(t,l,r),l,r)}scaleRows(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};if("object"!=typeof t)throw new TypeError("options must be an object");const{min:e=0,max:s=1}=t;if(!Number.isFinite(e))throw new TypeError("min must be a number");if(!Number.isFinite(s))throw new TypeError("max must be a number");if(e>=s)throw new RangeError("min must be smaller than max");let n=new Matrix(this.rows,this.columns);for(let t=0;t<this.rows;t++){const i=this.getRow(t);i.length>0&&rescale(i,{min:e,max:s,output:i}),n.setRow(t,i)}return n}scaleColumns(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};if("object"!=typeof t)throw new TypeError("options must be an object");const{min:e=0,max:s=1}=t;if(!Number.isFinite(e))throw new TypeError("min must be a number");if(!Number.isFinite(s))throw new TypeError("max must be a number");if(e>=s)throw new RangeError("min must be smaller than max");let n=new Matrix(this.rows,this.columns);for(let t=0;t<this.columns;t++){const i=this.getColumn(t);i.length&&rescale(i,{min:e,max:s,output:i}),n.setColumn(t,i)}return n}flipRows(){const t=Math.ceil(this.columns/2);for(let e=0;e<this.rows;e++)for(let s=0;s<t;s++){let t=this.get(e,s),n=this.get(e,this.columns-1-s);this.set(e,s,n),this.set(e,this.columns-1-s,t)}return this}flipColumns(){const t=Math.ceil(this.rows/2);for(let e=0;e<this.columns;e++)for(let s=0;s<t;s++){let t=this.get(s,e),n=this.get(this.rows-1-s,e);this.set(s,e,n),this.set(this.rows-1-s,e,t)}return this}kroneckerProduct(t){t=Matrix.checkMatrix(t);let e=this.rows,s=this.columns,n=t.rows,i=t.columns,o=new Matrix(e*n,s*i);for(let a=0;a<e;a++)for(let e=0;e<s;e++)for(let s=0;s<n;s++)for(let l=0;l<i;l++)o.set(n*a+s,i*e+l,this.get(a,e)*t.get(s,l));return o}kroneckerSum(t){if(t=Matrix.checkMatrix(t),!this.isSquare()||!t.isSquare())throw new Error("Kronecker Sum needs two Square Matrices");let e=this.rows,s=t.rows,n=this.kroneckerProduct(Matrix.eye(s,s)),i=Matrix.eye(e,e).kroneckerProduct(t);return n.add(i)}transpose(){let t=new Matrix(this.columns,this.rows);for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)t.set(s,e,this.get(e,s));return t}sortRows(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:compareNumbers;for(let e=0;e<this.rows;e++)this.setRow(e,this.getRow(e).sort(t));return this}sortColumns(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:compareNumbers;for(let e=0;e<this.columns;e++)this.setColumn(e,this.getColumn(e).sort(t));return this}subMatrix(t,e,s,n){checkRange(this,t,e,s,n);let i=new Matrix(e-t+1,n-s+1);for(let o=t;o<=e;o++)for(let e=s;e<=n;e++)i.set(o-t,e-s,this.get(o,e));return i}subMatrixRow(t,e,s){if(void 0===e&&(e=0),void 0===s&&(s=this.columns-1),e>s||e<0||e>=this.columns||s<0||s>=this.columns)throw new RangeError("Argument out of range");let n=new Matrix(t.length,s-e+1);for(let i=0;i<t.length;i++)for(let o=e;o<=s;o++){if(t[i]<0||t[i]>=this.rows)throw new RangeError(`Row index out of range: ${t[i]}`);n.set(i,o-e,this.get(t[i],o))}return n}subMatrixColumn(t,e,s){if(void 0===e&&(e=0),void 0===s&&(s=this.rows-1),e>s||e<0||e>=this.rows||s<0||s>=this.rows)throw new RangeError("Argument out of range");let n=new Matrix(s-e+1,t.length);for(let i=0;i<t.length;i++)for(let o=e;o<=s;o++){if(t[i]<0||t[i]>=this.columns)throw new RangeError(`Column index out of range: ${t[i]}`);n.set(o-e,i,this.get(o,t[i]))}return n}setSubMatrix(t,e,s){if((t=Matrix.checkMatrix(t)).isEmpty())return this;checkRange(this,e,e+t.rows-1,s,s+t.columns-1);for(let n=0;n<t.rows;n++)for(let i=0;i<t.columns;i++)this.set(e+n,s+i,t.get(n,i));return this}selection(t,e){checkRowIndices(this,t),checkColumnIndices(this,e);let s=new Matrix(t.length,e.length);for(let n=0;n<t.length;n++){let i=t[n];for(let t=0;t<e.length;t++){let o=e[t];s.set(n,t,this.get(i,o))}}return s}trace(){let t=Math.min(this.rows,this.columns),e=0;for(let s=0;s<t;s++)e+=this.get(s,s);return e}clone(){let t=new Matrix(this.rows,this.columns);for(let e=0;e<this.rows;e++)for(let s=0;s<this.columns;s++)t.set(e,s,this.get(e,s));return t}sum(t){switch(t){case"row":return sumByRow(this);case"column":return sumByColumn(this);case void 0:return sumAll(this);default:throw new Error(`invalid option: ${t}`)}}product(t){switch(t){case"row":return productByRow(this);case"column":return productByColumn(this);case void 0:return productAll(this);default:throw new Error(`invalid option: ${t}`)}}mean(t){const e=this.sum(t);switch(t){case"row":for(let t=0;t<this.rows;t++)e[t]/=this.columns;return e;case"column":for(let t=0;t<this.columns;t++)e[t]/=this.rows;return e;case void 0:return e/this.size;default:throw new Error(`invalid option: ${t}`)}}variance(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if("object"==typeof t&&(e=t,t=void 0),"object"!=typeof e)throw new TypeError("options must be an object");const{unbiased:s=!0,mean:n=this.mean(t)}=e;if("boolean"!=typeof s)throw new TypeError("unbiased must be a boolean");switch(t){case"row":if(!isAnyArray(n))throw new TypeError("mean must be an array");return varianceByRow(this,s,n);case"column":if(!isAnyArray(n))throw new TypeError("mean must be an array");return varianceByColumn(this,s,n);case void 0:if("number"!=typeof n)throw new TypeError("mean must be a number");return varianceAll(this,s,n);default:throw new Error(`invalid option: ${t}`)}}standardDeviation(t,e){"object"==typeof t&&(e=t,t=void 0);const s=this.variance(t,e);if(void 0===t)return Math.sqrt(s);for(let t=0;t<s.length;t++)s[t]=Math.sqrt(s[t]);return s}center(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if("object"==typeof t&&(e=t,t=void 0),"object"!=typeof e)throw new TypeError("options must be an object");const{center:s=this.mean(t)}=e;switch(t){case"row":if(!isAnyArray(s))throw new TypeError("center must be an array");return centerByRow(this,s),this;case"column":if(!isAnyArray(s))throw new TypeError("center must be an array");return centerByColumn(this,s),this;case void 0:if("number"!=typeof s)throw new TypeError("center must be a number");return centerAll(this,s),this;default:throw new Error(`invalid option: ${t}`)}}scale(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if("object"==typeof t&&(e=t,t=void 0),"object"!=typeof e)throw new TypeError("options must be an object");let s=e.scale;switch(t){case"row":if(void 0===s)s=getScaleByRow(this);else if(!isAnyArray(s))throw new TypeError("scale must be an array");return scaleByRow(this,s),this;case"column":if(void 0===s)s=getScaleByColumn(this);else if(!isAnyArray(s))throw new TypeError("scale must be an array");return scaleByColumn(this,s),this;case void 0:if(void 0===s)s=getScaleAll(this);else if("number"!=typeof s)throw new TypeError("scale must be a number");return scaleAll(this,s),this;default:throw new Error(`invalid option: ${t}`)}}toString(t){return inspectMatrixWithOptions(this,t)}}function compareNumbers(t,e){return t-e}function isArrayOfNumbers(t){return t.every((t=>"number"==typeof t))}AbstractMatrix.prototype.klass="Matrix","undefined"!=typeof Symbol&&(AbstractMatrix.prototype[Symbol.for("nodejs.util.inspect.custom")]=inspectMatrix),AbstractMatrix.random=AbstractMatrix.rand,AbstractMatrix.randomInt=AbstractMatrix.randInt,AbstractMatrix.diagonal=AbstractMatrix.diag,AbstractMatrix.prototype.diagonal=AbstractMatrix.prototype.diag,AbstractMatrix.identity=AbstractMatrix.eye,AbstractMatrix.prototype.negate=AbstractMatrix.prototype.neg,AbstractMatrix.prototype.tensorProduct=AbstractMatrix.prototype.kroneckerProduct;class Matrix extends AbstractMatrix{constructor(t,e){if(super(),Matrix.isMatrix(t))return t.clone();if(Number.isInteger(t)&&t>=0){if(this.data=[],!(Number.isInteger(e)&&e>=0))throw new TypeError("nColumns must be a positive integer");for(let s=0;s<t;s++)this.data.push(new Float64Array(e))}else{if(!isAnyArray(t))throw new TypeError("First argument must be a positive number or an array");{const s=t;if("number"!=typeof(e=(t=s.length)?s[0].length:0))throw new TypeError("Data must be a 2D array with at least one element");this.data=[];for(let n=0;n<t;n++){if(s[n].length!==e)throw new RangeError("Inconsistent array dimensions");if(!isArrayOfNumbers(s[n]))throw new TypeError("Input data contains non-numeric values");this.data.push(Float64Array.from(s[n]))}}}this.rows=t,this.columns=e}set(t,e,s){return this.data[t][e]=s,this}get(t,e){return this.data[t][e]}removeRow(t){return checkRowIndex(this,t),this.data.splice(t,1),this.rows-=1,this}addRow(t,e){return void 0===e&&(e=t,t=this.rows),checkRowIndex(this,t,!0),e=Float64Array.from(checkRowVector(this,e)),this.data.splice(t,0,e),this.rows+=1,this}removeColumn(t){checkColumnIndex(this,t);for(let e=0;e<this.rows;e++){const s=new Float64Array(this.columns-1);for(let n=0;n<t;n++)s[n]=this.data[e][n];for(let n=t+1;n<this.columns;n++)s[n-1]=this.data[e][n];this.data[e]=s}return this.columns-=1,this}addColumn(t,e){void 0===e&&(e=t,t=this.columns),checkColumnIndex(this,t,!0),e=checkColumnVector(this,e);for(let s=0;s<this.rows;s++){const n=new Float64Array(this.columns+1);let i=0;for(;i<t;i++)n[i]=this.data[s][i];for(n[i++]=e[s];i<this.columns+1;i++)n[i]=this.data[s][i-1];this.data[s]=n}return this.columns+=1,this}}installMathOperations(AbstractMatrix,Matrix);class WrapperMatrix2D extends AbstractMatrix{constructor(t){super(),this.data=t,this.rows=t.length,this.columns=t[0].length}set(t,e,s){return this.data[t][e]=s,this}get(t,e){return this.data[t][e]}}class LuDecomposition{constructor(t){let e,s,n,i,o,a,l,r,m,g=(t=WrapperMatrix2D.checkMatrix(t)).clone(),u=g.rows,c=g.columns,C=new Float64Array(u),f=1;for(e=0;e<u;e++)C[e]=e;for(r=new Float64Array(u),s=0;s<c;s++){for(e=0;e<u;e++)r[e]=g.get(e,s);for(e=0;e<u;e++){for(m=Math.min(e,s),o=0,n=0;n<m;n++)o+=g.get(e,n)*r[n];r[e]-=o,g.set(e,s,r[e])}for(i=s,e=s+1;e<u;e++)Math.abs(r[e])>Math.abs(r[i])&&(i=e);if(i!==s){for(n=0;n<c;n++)a=g.get(i,n),g.set(i,n,g.get(s,n)),g.set(s,n,a);l=C[i],C[i]=C[s],C[s]=l,f=-f}if(s<u&&0!==g.get(s,s))for(e=s+1;e<u;e++)g.set(e,s,g.get(e,s)/g.get(s,s))}this.LU=g,this.pivotVector=C,this.pivotSign=f}isSingular(){let t=this.LU,e=t.columns;for(let s=0;s<e;s++)if(0===t.get(s,s))return!0;return!1}solve(t){t=Matrix.checkMatrix(t);let e=this.LU;if(e.rows!==t.rows)throw new Error("Invalid matrix dimensions");if(this.isSingular())throw new Error("LU matrix is singular");let s,n,i,o=t.columns,a=t.subMatrixRow(this.pivotVector,0,o-1),l=e.columns;for(i=0;i<l;i++)for(s=i+1;s<l;s++)for(n=0;n<o;n++)a.set(s,n,a.get(s,n)-a.get(i,n)*e.get(s,i));for(i=l-1;i>=0;i--){for(n=0;n<o;n++)a.set(i,n,a.get(i,n)/e.get(i,i));for(s=0;s<i;s++)for(n=0;n<o;n++)a.set(s,n,a.get(s,n)-a.get(i,n)*e.get(s,i))}return a}get determinant(){let t=this.LU;if(!t.isSquare())throw new Error("Matrix must be square");let e=this.pivotSign,s=t.columns;for(let n=0;n<s;n++)e*=t.get(n,n);return e}get lowerTriangularMatrix(){let t=this.LU,e=t.rows,s=t.columns,n=new Matrix(e,s);for(let i=0;i<e;i++)for(let e=0;e<s;e++)i>e?n.set(i,e,t.get(i,e)):i===e?n.set(i,e,1):n.set(i,e,0);return n}get upperTriangularMatrix(){let t=this.LU,e=t.rows,s=t.columns,n=new Matrix(e,s);for(let i=0;i<e;i++)for(let e=0;e<s;e++)i<=e?n.set(i,e,t.get(i,e)):n.set(i,e,0);return n}get pivotPermutationVector(){return Array.from(this.pivotVector)}}function hypotenuse(t,e){let s=0;return Math.abs(t)>Math.abs(e)?(s=e/t,Math.abs(t)*Math.sqrt(1+s*s)):0!==e?(s=t/e,Math.abs(e)*Math.sqrt(1+s*s)):0}class QrDecomposition{constructor(t){let e,s,n,i,o=(t=WrapperMatrix2D.checkMatrix(t)).clone(),a=t.rows,l=t.columns,r=new Float64Array(l);for(n=0;n<l;n++){let t=0;for(e=n;e<a;e++)t=hypotenuse(t,o.get(e,n));if(0!==t){for(o.get(n,n)<0&&(t=-t),e=n;e<a;e++)o.set(e,n,o.get(e,n)/t);for(o.set(n,n,o.get(n,n)+1),s=n+1;s<l;s++){for(i=0,e=n;e<a;e++)i+=o.get(e,n)*o.get(e,s);for(i=-i/o.get(n,n),e=n;e<a;e++)o.set(e,s,o.get(e,s)+i*o.get(e,n))}}r[n]=-t}this.QR=o,this.Rdiag=r}solve(t){t=Matrix.checkMatrix(t);let e=this.QR,s=e.rows;if(t.rows!==s)throw new Error("Matrix row dimensions must agree");if(!this.isFullRank())throw new Error("Matrix is rank deficient");let n,i,o,a,l=t.columns,r=t.clone(),m=e.columns;for(o=0;o<m;o++)for(i=0;i<l;i++){for(a=0,n=o;n<s;n++)a+=e.get(n,o)*r.get(n,i);for(a=-a/e.get(o,o),n=o;n<s;n++)r.set(n,i,r.get(n,i)+a*e.get(n,o))}for(o=m-1;o>=0;o--){for(i=0;i<l;i++)r.set(o,i,r.get(o,i)/this.Rdiag[o]);for(n=0;n<o;n++)for(i=0;i<l;i++)r.set(n,i,r.get(n,i)-r.get(o,i)*e.get(n,o))}return r.subMatrix(0,m-1,0,l-1)}isFullRank(){let t=this.QR.columns;for(let e=0;e<t;e++)if(0===this.Rdiag[e])return!1;return!0}get upperTriangularMatrix(){let t,e,s=this.QR,n=s.columns,i=new Matrix(n,n);for(t=0;t<n;t++)for(e=0;e<n;e++)t<e?i.set(t,e,s.get(t,e)):t===e?i.set(t,e,this.Rdiag[t]):i.set(t,e,0);return i}get orthogonalMatrix(){let t,e,s,n,i=this.QR,o=i.rows,a=i.columns,l=new Matrix(o,a);for(s=a-1;s>=0;s--){for(t=0;t<o;t++)l.set(t,s,0);for(l.set(s,s,1),e=s;e<a;e++)if(0!==i.get(s,s)){for(n=0,t=s;t<o;t++)n+=i.get(t,s)*l.get(t,e);for(n=-n/i.get(s,s),t=s;t<o;t++)l.set(t,e,l.get(t,e)+n*i.get(t,s))}}return l}}class SingularValueDecomposition{constructor(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if((t=WrapperMatrix2D.checkMatrix(t)).isEmpty())throw new Error("Matrix must be non-empty");let s=t.rows,n=t.columns;const{computeLeftSingularVectors:i=!0,computeRightSingularVectors:o=!0,autoTranspose:a=!1}=e;let l,r=Boolean(i),m=Boolean(o),g=!1;if(s<n)if(a){l=t.transpose(),s=l.rows,n=l.columns,g=!0;let e=r;r=m,m=e}else l=t.clone(),console.warn("Computing SVD on a matrix with more columns than rows. Consider enabling autoTranspose");else l=t.clone();let u=Math.min(s,n),c=Math.min(s+1,n),C=new Float64Array(c),f=new Matrix(s,u),h=new Matrix(n,n),p=new Float64Array(n),d=new Float64Array(s),y=new Float64Array(c);for(let t=0;t<c;t++)y[t]=t;let H=Math.min(s-1,n),v=Math.max(0,Math.min(n-2,s)),b=Math.max(H,v);for(let t=0;t<b;t++){if(t<H){C[t]=0;for(let e=t;e<s;e++)C[t]=hypotenuse(C[t],l.get(e,t));if(0!==C[t]){l.get(t,t)<0&&(C[t]=-C[t]);for(let e=t;e<s;e++)l.set(e,t,l.get(e,t)/C[t]);l.set(t,t,l.get(t,t)+1)}C[t]=-C[t]}for(let e=t+1;e<n;e++){if(t<H&&0!==C[t]){let n=0;for(let i=t;i<s;i++)n+=l.get(i,t)*l.get(i,e);n=-n/l.get(t,t);for(let i=t;i<s;i++)l.set(i,e,l.get(i,e)+n*l.get(i,t))}p[e]=l.get(t,e)}if(r&&t<H)for(let e=t;e<s;e++)f.set(e,t,l.get(e,t));if(t<v){p[t]=0;for(let e=t+1;e<n;e++)p[t]=hypotenuse(p[t],p[e]);if(0!==p[t]){p[t+1]<0&&(p[t]=0-p[t]);for(let e=t+1;e<n;e++)p[e]/=p[t];p[t+1]+=1}if(p[t]=-p[t],t+1<s&&0!==p[t]){for(let e=t+1;e<s;e++)d[e]=0;for(let e=t+1;e<s;e++)for(let s=t+1;s<n;s++)d[e]+=p[s]*l.get(e,s);for(let e=t+1;e<n;e++){let n=-p[e]/p[t+1];for(let i=t+1;i<s;i++)l.set(i,e,l.get(i,e)+n*d[i])}}if(m)for(let e=t+1;e<n;e++)h.set(e,t,p[e])}}let w=Math.min(n,s+1);if(H<n&&(C[H]=l.get(H,H)),s<w&&(C[w-1]=0),v+1<w&&(p[v]=l.get(v,w-1)),p[w-1]=0,r){for(let t=H;t<u;t++){for(let e=0;e<s;e++)f.set(e,t,0);f.set(t,t,1)}for(let t=H-1;t>=0;t--)if(0!==C[t]){for(let e=t+1;e<u;e++){let n=0;for(let i=t;i<s;i++)n+=f.get(i,t)*f.get(i,e);n=-n/f.get(t,t);for(let i=t;i<s;i++)f.set(i,e,f.get(i,e)+n*f.get(i,t))}for(let e=t;e<s;e++)f.set(e,t,-f.get(e,t));f.set(t,t,1+f.get(t,t));for(let e=0;e<t-1;e++)f.set(e,t,0)}else{for(let e=0;e<s;e++)f.set(e,t,0);f.set(t,t,1)}}if(m)for(let t=n-1;t>=0;t--){if(t<v&&0!==p[t])for(let e=t+1;e<n;e++){let s=0;for(let i=t+1;i<n;i++)s+=h.get(i,t)*h.get(i,e);s=-s/h.get(t+1,t);for(let i=t+1;i<n;i++)h.set(i,e,h.get(i,e)+s*h.get(i,t))}for(let e=0;e<n;e++)h.set(e,t,0);h.set(t,t,1)}let O=w-1,x=Number.EPSILON;for(;w>0;){let t,e;for(t=w-2;t>=-1&&-1!==t;t--){const e=Number.MIN_VALUE+x*Math.abs(C[t]+Math.abs(C[t+1]));if(Math.abs(p[t])<=e||Number.isNaN(p[t])){p[t]=0;break}}if(t===w-2)e=4;else{let s;for(s=w-1;s>=t&&s!==t;s--){let e=(s!==w?Math.abs(p[s]):0)+(s!==t+1?Math.abs(p[s-1]):0);if(Math.abs(C[s])<=x*e){C[s]=0;break}}s===t?e=3:s===w-1?e=1:(e=2,t=s)}switch(t++,e){case 1:{let e=p[w-2];p[w-2]=0;for(let s=w-2;s>=t;s--){let i=hypotenuse(C[s],e),o=C[s]/i,a=e/i;if(C[s]=i,s!==t&&(e=-a*p[s-1],p[s-1]=o*p[s-1]),m)for(let t=0;t<n;t++)i=o*h.get(t,s)+a*h.get(t,w-1),h.set(t,w-1,-a*h.get(t,s)+o*h.get(t,w-1)),h.set(t,s,i)}break}case 2:{let e=p[t-1];p[t-1]=0;for(let n=t;n<w;n++){let i=hypotenuse(C[n],e),o=C[n]/i,a=e/i;if(C[n]=i,e=-a*p[n],p[n]=o*p[n],r)for(let e=0;e<s;e++)i=o*f.get(e,n)+a*f.get(e,t-1),f.set(e,t-1,-a*f.get(e,n)+o*f.get(e,t-1)),f.set(e,n,i)}break}case 3:{const e=Math.max(Math.abs(C[w-1]),Math.abs(C[w-2]),Math.abs(p[w-2]),Math.abs(C[t]),Math.abs(p[t])),i=C[w-1]/e,o=C[w-2]/e,a=p[w-2]/e,l=C[t]/e,g=p[t]/e,u=((o+i)*(o-i)+a*a)/2,c=i*a*(i*a);let d=0;0===u&&0===c||(d=u<0?0-Math.sqrt(u*u+c):Math.sqrt(u*u+c),d=c/(u+d));let y=(l+i)*(l-i)+d,H=l*g;for(let e=t;e<w-1;e++){let i=hypotenuse(y,H);0===i&&(i=Number.MIN_VALUE);let o=y/i,a=H/i;if(e!==t&&(p[e-1]=i),y=o*C[e]+a*p[e],p[e]=o*p[e]-a*C[e],H=a*C[e+1],C[e+1]=o*C[e+1],m)for(let t=0;t<n;t++)i=o*h.get(t,e)+a*h.get(t,e+1),h.set(t,e+1,-a*h.get(t,e)+o*h.get(t,e+1)),h.set(t,e,i);if(i=hypotenuse(y,H),0===i&&(i=Number.MIN_VALUE),o=y/i,a=H/i,C[e]=i,y=o*p[e]+a*C[e+1],C[e+1]=-a*p[e]+o*C[e+1],H=a*p[e+1],p[e+1]=o*p[e+1],r&&e<s-1)for(let t=0;t<s;t++)i=o*f.get(t,e)+a*f.get(t,e+1),f.set(t,e+1,-a*f.get(t,e)+o*f.get(t,e+1)),f.set(t,e,i)}p[w-2]=y;break}case 4:if(C[t]<=0&&(C[t]=C[t]<0?-C[t]:0,m))for(let e=0;e<=O;e++)h.set(e,t,-h.get(e,t));for(;t<O&&!(C[t]>=C[t+1]);){let e=C[t];if(C[t]=C[t+1],C[t+1]=e,m&&t<n-1)for(let s=0;s<n;s++)e=h.get(s,t+1),h.set(s,t+1,h.get(s,t)),h.set(s,t,e);if(r&&t<s-1)for(let n=0;n<s;n++)e=f.get(n,t+1),f.set(n,t+1,f.get(n,t)),f.set(n,t,e);t++}w--}}if(g){let t=h;h=f,f=t}this.m=s,this.n=n,this.s=C,this.U=f,this.V=h}solve(t){let e=t,s=this.threshold,n=this.s.length,i=Matrix.zeros(n,n);for(let t=0;t<n;t++)Math.abs(this.s[t])<=s?i.set(t,t,0):i.set(t,t,1/this.s[t]);let o=this.U,a=this.rightSingularVectors,l=a.mmul(i),r=a.rows,m=o.rows,g=Matrix.zeros(r,m);for(let t=0;t<r;t++)for(let e=0;e<m;e++){let s=0;for(let i=0;i<n;i++)s+=l.get(t,i)*o.get(e,i);g.set(t,e,s)}return g.mmul(e)}solveForDiagonal(t){return this.solve(Matrix.diag(t))}inverse(){let t=this.V,e=this.threshold,s=t.rows,n=t.columns,i=new Matrix(s,this.s.length);for(let o=0;o<s;o++)for(let s=0;s<n;s++)Math.abs(this.s[s])>e&&i.set(o,s,t.get(o,s)/this.s[s]);let o=this.U,a=o.rows,l=o.columns,r=new Matrix(s,a);for(let t=0;t<s;t++)for(let e=0;e<a;e++){let s=0;for(let n=0;n<l;n++)s+=i.get(t,n)*o.get(e,n);r.set(t,e,s)}return r}get condition(){return this.s[0]/this.s[Math.min(this.m,this.n)-1]}get norm2(){return this.s[0]}get rank(){let t=Math.max(this.m,this.n)*this.s[0]*Number.EPSILON,e=0,s=this.s;for(let n=0,i=s.length;n<i;n++)s[n]>t&&e++;return e}get diagonal(){return Array.from(this.s)}get threshold(){return Number.EPSILON/2*Math.max(this.m,this.n)*this.s[0]}get leftSingularVectors(){return this.U}get rightSingularVectors(){return this.V}get diagonalMatrix(){return Matrix.diag(this.s)}}function inverse(t){let e=arguments.length>1&&void 0!==arguments[1]&&arguments[1];return t=WrapperMatrix2D.checkMatrix(t),e?new SingularValueDecomposition(t).inverse():solve(t,Matrix.eye(t.rows))}function solve(t,e){let s=arguments.length>2&&void 0!==arguments[2]&&arguments[2];return t=WrapperMatrix2D.checkMatrix(t),e=WrapperMatrix2D.checkMatrix(e),s?new SingularValueDecomposition(t).solve(e):t.isSquare()?new LuDecomposition(t).solve(e):new QrDecomposition(t).solve(e)}class EigenvalueDecomposition{constructor(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{assumeSymmetric:s=!1}=e;if(!(t=WrapperMatrix2D.checkMatrix(t)).isSquare())throw new Error("Matrix is not a square matrix");if(t.isEmpty())throw new Error("Matrix must be non-empty");let n,i,o=t.columns,a=new Matrix(o,o),l=new Float64Array(o),r=new Float64Array(o),m=t,g=!1;if(g=!!s||t.isSymmetric(),g){for(n=0;n<o;n++)for(i=0;i<o;i++)a.set(n,i,m.get(n,i));tred2(o,r,l,a),tql2(o,r,l,a)}else{let t=new Matrix(o,o),e=new Float64Array(o);for(i=0;i<o;i++)for(n=0;n<o;n++)t.set(n,i,m.get(n,i));orthes(o,t,e,a),hqr2(o,r,l,a,t)}this.n=o,this.e=r,this.d=l,this.V=a}get realEigenvalues(){return Array.from(this.d)}get imaginaryEigenvalues(){return Array.from(this.e)}get eigenvectorMatrix(){return this.V}get diagonalMatrix(){let t,e,s=this.n,n=this.e,i=this.d,o=new Matrix(s,s);for(t=0;t<s;t++){for(e=0;e<s;e++)o.set(t,e,0);o.set(t,t,i[t]),n[t]>0?o.set(t,t+1,n[t]):n[t]<0&&o.set(t,t-1,n[t])}return o}}function tred2(t,e,s,n){let i,o,a,l,r,m,g,u;for(r=0;r<t;r++)s[r]=n.get(t-1,r);for(l=t-1;l>0;l--){for(u=0,a=0,m=0;m<l;m++)u+=Math.abs(s[m]);if(0===u)for(e[l]=s[l-1],r=0;r<l;r++)s[r]=n.get(l-1,r),n.set(l,r,0),n.set(r,l,0);else{for(m=0;m<l;m++)s[m]/=u,a+=s[m]*s[m];for(i=s[l-1],o=Math.sqrt(a),i>0&&(o=-o),e[l]=u*o,a-=i*o,s[l-1]=i-o,r=0;r<l;r++)e[r]=0;for(r=0;r<l;r++){for(i=s[r],n.set(r,l,i),o=e[r]+n.get(r,r)*i,m=r+1;m<=l-1;m++)o+=n.get(m,r)*s[m],e[m]+=n.get(m,r)*i;e[r]=o}for(i=0,r=0;r<l;r++)e[r]/=a,i+=e[r]*s[r];for(g=i/(a+a),r=0;r<l;r++)e[r]-=g*s[r];for(r=0;r<l;r++){for(i=s[r],o=e[r],m=r;m<=l-1;m++)n.set(m,r,n.get(m,r)-(i*e[m]+o*s[m]));s[r]=n.get(l-1,r),n.set(l,r,0)}}s[l]=a}for(l=0;l<t-1;l++){if(n.set(t-1,l,n.get(l,l)),n.set(l,l,1),a=s[l+1],0!==a){for(m=0;m<=l;m++)s[m]=n.get(m,l+1)/a;for(r=0;r<=l;r++){for(o=0,m=0;m<=l;m++)o+=n.get(m,l+1)*n.get(m,r);for(m=0;m<=l;m++)n.set(m,r,n.get(m,r)-o*s[m])}}for(m=0;m<=l;m++)n.set(m,l+1,0)}for(r=0;r<t;r++)s[r]=n.get(t-1,r),n.set(t-1,r,0);n.set(t-1,t-1,1),e[0]=0}function tql2(t,e,s,n){let i,o,a,l,r,m,g,u,c,C,f,h,p,d,y,H;for(a=1;a<t;a++)e[a-1]=e[a];e[t-1]=0;let v=0,b=0,w=Number.EPSILON;for(m=0;m<t;m++){for(b=Math.max(b,Math.abs(s[m])+Math.abs(e[m])),g=m;g<t&&!(Math.abs(e[g])<=w*b);)g++;if(g>m)do{for(i=s[m],u=(s[m+1]-i)/(2*e[m]),c=hypotenuse(u,1),u<0&&(c=-c),s[m]=e[m]/(u+c),s[m+1]=e[m]*(u+c),C=s[m+1],o=i-s[m],a=m+2;a<t;a++)s[a]-=o;for(v+=o,u=s[g],f=1,h=f,p=f,d=e[m+1],y=0,H=0,a=g-1;a>=m;a--)for(p=h,h=f,H=y,i=f*e[a],o=f*u,c=hypotenuse(u,e[a]),e[a+1]=y*c,y=e[a]/c,f=u/c,u=f*s[a]-y*i,s[a+1]=o+y*(f*i+y*s[a]),r=0;r<t;r++)o=n.get(r,a+1),n.set(r,a+1,y*n.get(r,a)+f*o),n.set(r,a,f*n.get(r,a)-y*o);u=-y*H*p*d*e[m]/C,e[m]=y*u,s[m]=f*u}while(Math.abs(e[m])>w*b);s[m]=s[m]+v,e[m]=0}for(a=0;a<t-1;a++){for(r=a,u=s[a],l=a+1;l<t;l++)s[l]<u&&(r=l,u=s[l]);if(r!==a)for(s[r]=s[a],s[a]=u,l=0;l<t;l++)u=n.get(l,a),n.set(l,a,n.get(l,r)),n.set(l,r,u)}}function orthes(t,e,s,n){let i,o,a,l,r,m,g,u=t-1;for(m=1;m<=u-1;m++){for(g=0,l=m;l<=u;l++)g+=Math.abs(e.get(l,m-1));if(0!==g){for(a=0,l=u;l>=m;l--)s[l]=e.get(l,m-1)/g,a+=s[l]*s[l];for(o=Math.sqrt(a),s[m]>0&&(o=-o),a-=s[m]*o,s[m]=s[m]-o,r=m;r<t;r++){for(i=0,l=u;l>=m;l--)i+=s[l]*e.get(l,r);for(i/=a,l=m;l<=u;l++)e.set(l,r,e.get(l,r)-i*s[l])}for(l=0;l<=u;l++){for(i=0,r=u;r>=m;r--)i+=s[r]*e.get(l,r);for(i/=a,r=m;r<=u;r++)e.set(l,r,e.get(l,r)-i*s[r])}s[m]=g*s[m],e.set(m,m-1,g*o)}}for(l=0;l<t;l++)for(r=0;r<t;r++)n.set(l,r,l===r?1:0);for(m=u-1;m>=1;m--)if(0!==e.get(m,m-1)){for(l=m+1;l<=u;l++)s[l]=e.get(l,m-1);for(r=m;r<=u;r++){for(o=0,l=m;l<=u;l++)o+=s[l]*n.get(l,r);for(o=o/s[m]/e.get(m,m-1),l=m;l<=u;l++)n.set(l,r,n.get(l,r)+o*s[l])}}}function hqr2(t,e,s,n,i){let o,a,l,r,m,g,u,c,C,f,h,p,d,y,H,v=t-1,b=t-1,w=Number.EPSILON,O=0,x=0,D=0,j=0,A=0,S=0,M=0,T=0;for(o=0;o<t;o++)for((o<0||o>b)&&(s[o]=i.get(o,o),e[o]=0),a=Math.max(o-1,0);a<t;a++)x+=Math.abs(i.get(o,a));for(;v>=0;){for(r=v;r>0&&(S=Math.abs(i.get(r-1,r-1))+Math.abs(i.get(r,r)),0===S&&(S=x),!(Math.abs(i.get(r,r-1))<w*S));)r--;if(r===v)i.set(v,v,i.get(v,v)+O),s[v]=i.get(v,v),e[v]=0,v--,T=0;else if(r===v-1){if(u=i.get(v,v-1)*i.get(v-1,v),D=(i.get(v-1,v-1)-i.get(v,v))/2,j=D*D+u,M=Math.sqrt(Math.abs(j)),i.set(v,v,i.get(v,v)+O),i.set(v-1,v-1,i.get(v-1,v-1)+O),c=i.get(v,v),j>=0){for(M=D>=0?D+M:D-M,s[v-1]=c+M,s[v]=s[v-1],0!==M&&(s[v]=c-u/M),e[v-1]=0,e[v]=0,c=i.get(v,v-1),S=Math.abs(c)+Math.abs(M),D=c/S,j=M/S,A=Math.sqrt(D*D+j*j),D/=A,j/=A,a=v-1;a<t;a++)M=i.get(v-1,a),i.set(v-1,a,j*M+D*i.get(v,a)),i.set(v,a,j*i.get(v,a)-D*M);for(o=0;o<=v;o++)M=i.get(o,v-1),i.set(o,v-1,j*M+D*i.get(o,v)),i.set(o,v,j*i.get(o,v)-D*M);for(o=0;o<=b;o++)M=n.get(o,v-1),n.set(o,v-1,j*M+D*n.get(o,v)),n.set(o,v,j*n.get(o,v)-D*M)}else s[v-1]=c+D,s[v]=c+D,e[v-1]=M,e[v]=-M;v-=2,T=0}else{if(c=i.get(v,v),C=0,u=0,r<v&&(C=i.get(v-1,v-1),u=i.get(v,v-1)*i.get(v-1,v)),10===T){for(O+=c,o=0;o<=v;o++)i.set(o,o,i.get(o,o)-c);S=Math.abs(i.get(v,v-1))+Math.abs(i.get(v-1,v-2)),c=C=.75*S,u=-.4375*S*S}if(30===T&&(S=(C-c)/2,S=S*S+u,S>0)){for(S=Math.sqrt(S),C<c&&(S=-S),S=c-u/((C-c)/2+S),o=0;o<=v;o++)i.set(o,o,i.get(o,o)-S);O+=S,c=C=u=.964}for(T+=1,m=v-2;m>=r&&(M=i.get(m,m),A=c-M,S=C-M,D=(A*S-u)/i.get(m+1,m)+i.get(m,m+1),j=i.get(m+1,m+1)-M-A-S,A=i.get(m+2,m+1),S=Math.abs(D)+Math.abs(j)+Math.abs(A),D/=S,j/=S,A/=S,m!==r)&&!(Math.abs(i.get(m,m-1))*(Math.abs(j)+Math.abs(A))<w*(Math.abs(D)*(Math.abs(i.get(m-1,m-1))+Math.abs(M)+Math.abs(i.get(m+1,m+1)))));)m--;for(o=m+2;o<=v;o++)i.set(o,o-2,0),o>m+2&&i.set(o,o-3,0);for(l=m;l<=v-1&&(y=l!==v-1,l!==m&&(D=i.get(l,l-1),j=i.get(l+1,l-1),A=y?i.get(l+2,l-1):0,c=Math.abs(D)+Math.abs(j)+Math.abs(A),0!==c&&(D/=c,j/=c,A/=c)),0!==c);l++)if(S=Math.sqrt(D*D+j*j+A*A),D<0&&(S=-S),0!==S){for(l!==m?i.set(l,l-1,-S*c):r!==m&&i.set(l,l-1,-i.get(l,l-1)),D+=S,c=D/S,C=j/S,M=A/S,j/=D,A/=D,a=l;a<t;a++)D=i.get(l,a)+j*i.get(l+1,a),y&&(D+=A*i.get(l+2,a),i.set(l+2,a,i.get(l+2,a)-D*M)),i.set(l,a,i.get(l,a)-D*c),i.set(l+1,a,i.get(l+1,a)-D*C);for(o=0;o<=Math.min(v,l+3);o++)D=c*i.get(o,l)+C*i.get(o,l+1),y&&(D+=M*i.get(o,l+2),i.set(o,l+2,i.get(o,l+2)-D*A)),i.set(o,l,i.get(o,l)-D),i.set(o,l+1,i.get(o,l+1)-D*j);for(o=0;o<=b;o++)D=c*n.get(o,l)+C*n.get(o,l+1),y&&(D+=M*n.get(o,l+2),n.set(o,l+2,n.get(o,l+2)-D*A)),n.set(o,l,n.get(o,l)-D),n.set(o,l+1,n.get(o,l+1)-D*j)}}}if(0!==x){for(v=t-1;v>=0;v--)if(D=s[v],j=e[v],0===j)for(r=v,i.set(v,v,1),o=v-1;o>=0;o--){for(u=i.get(o,o)-D,A=0,a=r;a<=v;a++)A+=i.get(o,a)*i.get(a,v);if(e[o]<0)M=u,S=A;else if(r=o,0===e[o]?i.set(o,v,0!==u?-A/u:-A/(w*x)):(c=i.get(o,o+1),C=i.get(o+1,o),j=(s[o]-D)*(s[o]-D)+e[o]*e[o],g=(c*S-M*A)/j,i.set(o,v,g),i.set(o+1,v,Math.abs(c)>Math.abs(M)?(-A-u*g)/c:(-S-C*g)/M)),g=Math.abs(i.get(o,v)),w*g*g>1)for(a=o;a<=v;a++)i.set(a,v,i.get(a,v)/g)}else if(j<0)for(r=v-1,Math.abs(i.get(v,v-1))>Math.abs(i.get(v-1,v))?(i.set(v-1,v-1,j/i.get(v,v-1)),i.set(v-1,v,-(i.get(v,v)-D)/i.get(v,v-1))):(H=cdiv(0,-i.get(v-1,v),i.get(v-1,v-1)-D,j),i.set(v-1,v-1,H[0]),i.set(v-1,v,H[1])),i.set(v,v-1,0),i.set(v,v,1),o=v-2;o>=0;o--){for(f=0,h=0,a=r;a<=v;a++)f+=i.get(o,a)*i.get(a,v-1),h+=i.get(o,a)*i.get(a,v);if(u=i.get(o,o)-D,e[o]<0)M=u,A=f,S=h;else if(r=o,0===e[o]?(H=cdiv(-f,-h,u,j),i.set(o,v-1,H[0]),i.set(o,v,H[1])):(c=i.get(o,o+1),C=i.get(o+1,o),p=(s[o]-D)*(s[o]-D)+e[o]*e[o]-j*j,d=2*(s[o]-D)*j,0===p&&0===d&&(p=w*x*(Math.abs(u)+Math.abs(j)+Math.abs(c)+Math.abs(C)+Math.abs(M))),H=cdiv(c*A-M*f+j*h,c*S-M*h-j*f,p,d),i.set(o,v-1,H[0]),i.set(o,v,H[1]),Math.abs(c)>Math.abs(M)+Math.abs(j)?(i.set(o+1,v-1,(-f-u*i.get(o,v-1)+j*i.get(o,v))/c),i.set(o+1,v,(-h-u*i.get(o,v)-j*i.get(o,v-1))/c)):(H=cdiv(-A-C*i.get(o,v-1),-S-C*i.get(o,v),M,j),i.set(o+1,v-1,H[0]),i.set(o+1,v,H[1]))),g=Math.max(Math.abs(i.get(o,v-1)),Math.abs(i.get(o,v))),w*g*g>1)for(a=o;a<=v;a++)i.set(a,v-1,i.get(a,v-1)/g),i.set(a,v,i.get(a,v)/g)}for(o=0;o<t;o++)if(o<0||o>b)for(a=o;a<t;a++)n.set(o,a,i.get(o,a));for(a=t-1;a>=0;a--)for(o=0;o<=b;o++){for(M=0,l=0;l<=Math.min(a,b);l++)M+=n.get(o,l)*i.get(l,a);n.set(o,a,M)}}}function cdiv(t,e,s,n){let i,o;return Math.abs(s)>Math.abs(n)?(i=n/s,o=s+i*n,[(t+i*e)/o,(e-i*t)/o]):(i=s/n,o=n+i*s,[(i*t+e)/o,(i*e-t)/o])}const LOOP=8,FLOAT_MUL=1/16777216,sh1=15,sh2=18,sh3=11;function multiply_uint32(t,e){const s=65535&(t>>>=0);return((t-s)*(e>>>=0)>>>0)+s*e>>>0}class XSadd{constructor(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:Date.now();this.state=new Uint32Array(4),this.init(t),this.random=this.getFloat.bind(this)}getUint32(){return this.nextState(),this.state[3]+this.state[2]>>>0}getFloat(){return(this.getUint32()>>>8)*FLOAT_MUL}init(t){if(!Number.isInteger(t))throw new TypeError("seed must be an integer");this.state[0]=t,this.state[1]=0,this.state[2]=0,this.state[3]=0;for(let t=1;t<LOOP;t++)this.state[3&t]^=t+multiply_uint32(1812433253,this.state[t-1&3]^this.state[t-1&3]>>>30>>>0)>>>0;this.periodCertification();for(let t=0;t<LOOP;t++)this.nextState()}periodCertification(){0===this.state[0]&&0===this.state[1]&&0===this.state[2]&&0===this.state[3]&&(this.state[0]=88,this.state[1]=83,this.state[2]=65,this.state[3]=68)}nextState(){let t=this.state[0];t^=t<<sh1,t^=t>>>sh2,t^=this.state[3]<<sh3,this.state[0]=this.state[1],this.state[1]=this.state[2],this.state[2]=this.state[3],this.state[3]=t}}let spare,hasSpare=!1;function createRandomArray(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{mean:e=0,standardDeviation:s=1,length:n=1e3,range:i=1,seed:o,distribution:a="normal"}=t;const l=new XSadd(o);let r=new Float64Array(n);switch(a){case"normal":for(let t=0;t<n;t++)r[t]=generateGaussian(e,s,l);break;case"uniform":for(let t=0;t<n;t++)r[t]=(l.random()-.5)*i+e;break;default:throw new Error(`unknown distribution: ${a}`)}return r}function generateGaussian(t,e,s){let n,i,o,a;if(hasSpare)hasSpare=!1,n=spare*e+t;else{do{i=2*s.random()-1,o=2*s.random()-1,a=i*i+o*o}while(a>=1||0===a);a=Math.sqrt(-2*Math.log(a)/a),spare=o*a,hasSpare=!0,n=t+e*i*a}return n}function addNoise(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{seed:s=0,distribution:n="normal",percent:i=1}=e,o=xMaxValue(t.y)*i/100,a=createRandomArray({distribution:n,seed:s,mean:0,standardDeviation:o,range:o,length:t.x.length});return t.y=xAdd(t.y,a),t}class SpectrumGenerator{constructor(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};const{from:e=0,to:s=1e3,nbPoints:n=10001,peakWidthFct:i,shape:o={kind:"gaussian",fwhm:5}}=t;this.from=e,this.to=s,this.nbPoints=n,this.interval=(this.to-this.from)/(this.nbPoints-1),this.peakWidthFct=i,this.maxPeakHeight=Number.MIN_SAFE_INTEGER,this.data={x:new Float64Array(this.nbPoints),y:new Float64Array(this.nbPoints)};let a=getShape1D(o);if(this.shape=a,assertNumber$2(this.from,"from"),assertNumber$2(this.to,"to"),assertInteger$1(this.nbPoints,"nbPoints"),this.to<=this.from)throw new RangeError("to option must be larger than from");if(this.peakWidthFct&&"function"!=typeof this.peakWidthFct)throw new TypeError("peakWidthFct option must be a function");this.reset()}addPeaks(t,e){if(!(Array.isArray(t)||"object"==typeof t&&void 0!==t.x&&void 0!==t.y&&Array.isArray(t.x)&&Array.isArray(t.y)&&t.x.length===t.y.length))throw new TypeError("peaks must be an array or an object containing x[] and y[]");if(Array.isArray(t))for(const s of t)this.addPeak(s,e);else for(let s=0;s<t.x.length;s++)this.addPeak([t.x[s],t.y[s]],e)}addPeak(t){let e,s,n,i,o,a=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(Array.isArray(t)&&t.length<2)throw new Error("peak must be an array with two (or three) values or an object with {x,y,width?}");if(!Array.isArray(t)&&(void 0===t.x||void 0===t.y))throw new Error("peak must be an array with two (or three) values or an object with {x,y,width?}");Array.isArray(t)?[e,s,n,o]=t:(e=t.x,s=t.y,i=t.width,o=t.shape),s>this.maxPeakHeight&&(this.maxPeakHeight=s);let{shape:l}=a;o&&(l=l?{...l,...o}:o);const r=l?getShape1D(l):Object.assign(Object.create(Object.getPrototypeOf(this.shape)),this.shape);let{width:m,widthLeft:g,widthRight:u}=a;const c=void 0!==n?n:i?r.widthToFWHM(i):this.peakWidthFct?this.peakWidthFct(e):void 0!==m?m:r.fwhm;if(g||(g=c),u||(u=c),!g||!u)throw new Error("Width left or right is undefined or zero");let C=void 0===a.factor?r.getFactor():a.factor;const f=e-g/2*C,h=e+u/2*C,p=Math.max(0,Math.floor((f-this.from)/this.interval)),d=Math.min(this.nbPoints-1,Math.ceil((h-this.from)/this.interval)),y=Math.round((e-this.from)/this.interval);r.fwhm=g;for(let t=p;t<Math.max(y,0);t++)this.data.y[t]+=s*r.fct(this.data.x[t]-e);r.fwhm=u;for(let t=Math.min(y,d);t<=d;t++)this.data.y[t]+=s*r.fct(this.data.x[t]-e)}addBaseline(t){return addBaseline(this.data,t),this}addNoise(t){return addNoise(this.data,t),this}getSpectrum(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};"boolean"==typeof t&&(t={copy:t});const{copy:e=!0,threshold:s=0}=t;if(s){let t=this.maxPeakHeight*s,e=[],n=[];for(let s=0;s<this.data.x.length;s++)this.data.y[s]>=t&&(e.push(this.data.x[s]),n.push(this.data.y[s]));return{x:e,y:n}}return e?{x:this.data.x.slice(),y:this.data.y.slice()}:this.data}reset(){const t=this.data;for(let e=0;e<this.nbPoints;e++)t.x[e]=this.from+e*this.interval;return this}}function assertInteger$1(t,e){if(!Number.isInteger(t))throw new TypeError(`${e} option must be an integer`)}function assertNumber$2(t,e){if(!Number.isFinite(t))throw new TypeError(`${e} option must be a number`)}function generateSpectrum(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{generator:s,noise:n,baseline:i,threshold:o,peakOptions:a}=e,l=new SpectrumGenerator(s);return l.addPeaks(t,a),i&&l.addBaseline(i),n&&l.addNoise(n),l.getSpectrum({threshold:o})}const axis2D=["x","y"],peakCoordinates=["x","y","z"],convertWidthToFWHM=(t,e)=>{const s=ensureXYNumber$1(e);for(let e of axis2D)s[e]=t.widthToFWHM(s[e]);return s};class Spectrum2DGenerator{constructor(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{from:e=0,to:s=100,nbPoints:n=1001,peakWidthFct:i=(()=>5),shape:o={kind:"gaussian"}}=t;e=ensureXYNumber$1(e),s=ensureXYNumber$1(s),n=ensureXYNumber$1(n);for(const t of axis2D)assertNumber$1(e[t],`from-${t}`),assertNumber$1(s[t],`to-${t}`),assertInteger(n[t],`nbPoints-${t}`);this.from=e,this.to=s,this.nbPoints=n,this.interval=calculeIntervals(e,s,n),this.peakWidthFct=i,this.maxPeakHeight=Number.MIN_SAFE_INTEGER;let a=getShape2D(o);this.shape=a,this.data={x:new Float64Array(n.x),y:new Float64Array(n.y),z:createMatrix(this.nbPoints)};for(const t of axis2D)if(this.to[t]<=this.from[t])throw new RangeError("to option must be larger than from");if("function"!=typeof this.peakWidthFct)throw new TypeError("peakWidthFct option must be a function");this.reset()}addPeaks(t,e){if(!(Array.isArray(t)||"object"==typeof t&&void 0!==t.x&&void 0!==t.y&&Array.isArray(t.x)&&Array.isArray(t.y)&&t.x.length===t.y.length))throw new TypeError("peaks must be an array or an object containing x[] and y[]");if(Array.isArray(t))for(const s of t)this.addPeak(s,e);else{let s=t.x.length;for(const e of peakCoordinates)if(t[e]&&Array.isArray(t[e])&&s!==t[e].length)throw new Error("x, y, z should have the same length");for(let s=0;s<t.x.length;s++)this.addPeak([t.x[s],t.y[s],t.z[s]],e)}return this}addPeak(t){let e,s,n,i,o,a,l=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(Array.isArray(t)&&t.length<3)throw new Error("peak must be an array with three (or four) values or an object with {x,y,z,width?}");if(!Array.isArray(t)&&peakCoordinates.some((e=>void 0===t[e])))throw new Error("peak must be an array with three (or four) values or an object with {x,y,z,width?}");Array.isArray(t)?[e,s,n,i,a]=t:(e=t.x,s=t.y,n=t.z,i=t.fwhm,o=t.width,a=t.shape);const r={x:e,y:s};n>this.maxPeakHeight&&(this.maxPeakHeight=n);let{shape:m,width:g}=l;a&&(m=m?{...m,...a}:a);const u=m?getShape2D(m):Object.assign(Object.create(Object.getPrototypeOf(this.shape)),JSON.parse(JSON.stringify(this.shape)));let{fwhm:c=(void 0!==i?i:o?convertWidthToFWHM(u,o):g?convertWidthToFWHM(u,g):this.peakWidthFct(e,s))}=l;c=ensureXYNumber$1(c);let C=void 0===l.factor?u.getFactor():l.factor;C=ensureXYNumber$1(C);const f={x:0,y:0},h={x:0,y:0};for(const t of axis2D){const e=r[t]-c[t]/2*C[t],s=r[t]+c[t]/2*C[t];f[t]=Math.max(0,Math.floor((e-this.from[t])/this.interval[t])),h[t]=Math.min(this.nbPoints[t],Math.ceil((s-this.from[t])/this.interval[t]))}u.fwhm=c;for(let t=f.x;t<h.x;t++)for(let e=f.y;e<h.y;e++){const s=n*u.fct(this.data.x[t]-r.x,this.data.y[e]-r.y);s>1e-6&&(this.data.z[e][t]+=s)}return this}getSpectrum(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};"boolean"==typeof t&&(t={copy:t});const{copy:e=!0}=t;let s=matrixMinMaxZ(this.data.z);return{minX:this.from.x,maxX:this.to.x,maxY:this.to.y,minY:this.from.y,minZ:s.min,maxZ:s.max,z:e?this.data.z.slice():this.data.z}}reset(){const t=this.data;for(const e of axis2D)for(let s=0;s<this.nbPoints[e];s++)t[e][s]=this.from[e]+s*this.interval[e];for(let e of t.z)for(let t=0;t<e.length;t++)e[t]=0;return this}}function generateSpectrum2D(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{generator:s,peaks:n}=e,i=new Spectrum2DGenerator(s);return i.addPeaks(t,n),i.getSpectrum()}function ensureXYNumber$1(t){return"object"!=typeof t?{x:t,y:t}:{...t}}function calculeIntervals(t,e,s){return{x:(e.x-t.x)/(s.x-1),y:(e.y-t.y)/(s.y-1)}}function assertInteger(t,e){if(!Number.isInteger(t))throw new TypeError(`${e} option must be an integer`)}function assertNumber$1(t,e){if(!Number.isFinite(t))throw new TypeError(`${e} option must be a number`)}function createMatrix(t){const e=new Array(t.y);for(let s=0;s<t.y;s++)e[s]=new Float64Array(t.x);return e}function hasProperty(t,e){return e in t}const{parse:parse$7,stringify:stringify$7}=JSON;function convertWidth(t,e){const{frequency:s,convertTo:n,output:i=parse$7(stringify$7(t))}=e,o=getConverter(n,s);for(const t of i)if(t.width=o(t.width),hasProperty(t,"shape")){const e=t.shape;e.fwhm&&(e.fwhm=o(e.fwhm))}return i}function getConverter(t,e){switch(t){case"ppm":return t=>t/e;case"hz":return t=>t*e;default:throw new Error(`Does not support convert to ${t}`)}}function convertWidthToPPM(t,e){return convertWidth(t,{...e,convertTo:"ppm"})}function peaksToXY(t,e){const{frequency:s,nbPoints:n=1024,shape:i}=e;if(!s)throw new Error("frequency is mandatory");const o=convertWidthToPPM(t,{frequency:s});return generateSpectrum(o,{generator:{...getFromTo$1(o,e),nbPoints:n,shape:i}})}function getFromTo$1(t,e){if("to"in e&&"from"in e)return{from:e.from,to:e.to};t.sort(((t,e)=>t.x-e.x));const s=t[0],n=t[t.length-1],{from:i=s.x-2*s.width/e.frequency,to:o=n.x+2*n.width/e.frequency}=e;return{from:i,to:o}}for(var IDX=256,HEX=[],BUFFER;IDX--;)HEX[IDX]=(IDX+256).toString(16).substring(1);function v4(){var t,e=0,s="";if(!BUFFER||IDX+16>256){for(BUFFER=Array(e=256);e--;)BUFFER[e]=256*Math.random()|0;e=IDX=0}for(;e<16;e++)t=BUFFER[IDX+e],s+=6==e?HEX[15&t|64]:8==e?HEX[63&t|128]:HEX[t],1&e&&e>1&&e<11&&(s+="-");return IDX++,s}function sgg(t,e){let s=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},{windowSize:n=9,derivative:i=0,polynomial:o=3}=s;if(n%2==0||n<5||!Number.isInteger(n))throw new RangeError("Invalid window size (should be odd and at least 5 integer number)");if(!isAnyArray(t))throw new TypeError("Y values must be an array");if(void 0===e)throw new TypeError("X must be defined");if(n>t.length)throw new RangeError(`Window size is higher than the data length ${n}>${t.length}`);if(i<0||!Number.isInteger(i))throw new RangeError("Derivative should be a positive integer");if(o<1||!Number.isInteger(o))throw new RangeError("Polynomial should be a positive integer");o>=6&&console.warn("You should not use polynomial grade higher than 5 if you are not sure that your data arises from such a model. Possible polynomial oscillation problems");let a=Math.floor(n/2),l=t.length,r=new Float64Array(l),m=fullWeights(n,o,i),g=0,u=!0;isAnyArray(e)?u=!1:g=Math.pow(e,i);for(let s=0;s<a;s++){let o=m[a-s-1],c=m[a+s+1],C=0,f=0;for(let e=0;e<n;e++)C+=o[e]*t[e],f+=c[e]*t[l-n+e];u?(r[a-s-1]=C/g,r[l-a+s]=f/g):(g=getHs(e,a-s-1,a,i),r[a-s-1]=C/g,g=getHs(e,l-a+s,a,i),r[l-a+s]=f/g)}let c=m[a];for(let s=n;s<=l;s++){let o=0;for(let e=0;e<n;e++)o+=c[e]*t[e+s-n];u||(g=getHs(e,s-a-1,a,i)),r[s-a-1]=o/g}return r}function getHs(t,e,s,n){let i=0,o=0;for(let n=e-s;n<e+s;n++)n>=0&&n<t.length-1&&(i+=t[n+1]-t[n],o++);return Math.pow(i/o,n)}function gramPoly(t,e,s,n){let i=0;return i=s>0?(4*s-2)/(s*(2*e-s+1))*(t*gramPoly(t,e,s-1,n)+n*gramPoly(t,e,s-1,n-1))-(s-1)*(2*e+s)/(s*(2*e-s+1))*gramPoly(t,e,s-2,n):0===s&&0===n?1:0,i}function genFact(t,e){let s=1;if(t>=e)for(let n=t-e+1;n<=t;n++)s*=n;return s}function weight(t,e,s,n,i){let o=0;for(let a=0;a<=n;a++)o+=(2*a+1)*(genFact(2*s,a)/genFact(2*s+a+1,a+1))*gramPoly(t,s,a,0)*gramPoly(e,s,a,i);return o}function fullWeights(t,e,s){let n=new Array(t),i=Math.floor(t/2);for(let o=-i;o<=i;o++){n[o+i]=new Float64Array(t);for(let t=-i;t<=i;t++)n[o+i][t+i]=weight(t,o,i,e,s)}return n}function optimizeTop(t,e){const{x:s,y:n}=t;for(const t of e){let e=t.index;if(n[e-1]>=n[e-2]&&n[e-1]>=n[e]?e--:n[e+1]>=n[e]&&n[e+1]>=n[e+2]?e++:n[e-2]>=n[e-3]&&n[e-2]>=n[e-1]?e-=2:n[e+2]>=n[e+1]&&n[e+2]>=n[e+3]&&(e+=2),n[e-1]>0&&n[e+1]>0&&n[e]>=n[e-1]&&n[e]>=n[e+1]&&(n[e]!==n[e-1]||n[e]!==n[e+1])){let i=20*Math.log10(n[e-1]),o=20*Math.log10(n[e]),a=20*Math.log10(n[e+1]),l=.5*(i-a)/(i-2*o+a);t.x=s[e]+(s[e]-s[e-1])*l,t.y=n[e]-.25*(n[e-1]-n[e+1])*l}}}function gsd(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{sgOptions:s={windowSize:9,polynomial:3},noiseLevel:n,smoothY:i=!1,maxCriteria:o=!0,minMaxRatio:a=25e-5,realTopDetection:l=!1}=e,{x:r,y:m}=t;if(!xIsMonotoneIncreasing(r))throw new Error("GSD only accepts monotone increasing x values");m=m.slice();let g=xIsEquallySpaced(r);if(void 0===n)if(g){const t=xNoiseStandardDeviation(m);n=o?t.median+1.5*t.sd:-t.median+1.5*t.sd}else n=0;else!1===o&&(n*=-1);if(!1===o)for(let t=0;t<m.length;t++)m[t]*=-1;if(void 0!==n)for(let t=0;t<m.length;t++)m[t]<n&&(m[t]=n);let u,c,C=m;const{windowSize:f,polynomial:h}=s;g?(i&&(C=sgg(m,r[1]-r[0],{windowSize:f,polynomial:h,derivative:0})),u=sgg(m,r[1]-r[0],{windowSize:f,polynomial:h,derivative:1}),c=sgg(m,r[1]-r[0],{windowSize:f,polynomial:h,derivative:2})):(i&&(C=sgg(m,r,{windowSize:f,polynomial:h,derivative:0})),u=sgg(m,r,{windowSize:f,polynomial:h,derivative:1}),c=sgg(m,r,{windowSize:f,polynomial:h,derivative:2}));const p=xMinValue(C),d=xMaxValue(C);if(p>d||p===d)return[];const y=p+(d-p)*a,H=r[1]-r[0];let v=null,b=null,w=[],O=[],x=[];for(let t=1;t<C.length-1;++t)(u[t]<u[t-1]&&u[t]<=u[t+1]||u[t]<=u[t-1]&&u[t]<u[t+1])&&(b={x:r[t],index:t},H>0&&null!==v&&(O.push(v),x.push(b))),(u[t]>=u[t-1]&&u[t]>u[t+1]||u[t]>u[t-1]&&u[t]>=u[t+1])&&(v={x:r[t],index:t},H<0&&null!==b&&(O.push(v),x.push(b))),c[t]<c[t-1]&&c[t]<c[t+1]&&w.push(t);let D=-1;const j=[];for(const t of w){let e=r[t],s=-1,n=D+1,i=Number.POSITIVE_INFINITY,o=0;for(;-1===s&&n<O.length&&(o=Math.abs(e-(O[n].x+x[n].x)/2),o<(x[n].x-O[n].x)/2&&(s=n,D=n),++n,!(o>=i));)i=o;if(-1!==s&&C[t]>y){let n=Math.abs(x[s].x-O[s].x);j.push({id:v4(),x:e,y:C[t],width:n,index:t,ddY:c[t],inflectionPoints:{from:O[s],to:x[s]}})}}return l&&optimizeTop({x:r,y:C},j),j.forEach((t=>{o||(t.y*=-1,t.ddY=-1*t.ddY)})),j.sort(((t,e)=>t.x-e.x)),j}function getSumOfShapes$1(t){return function(e){return s=>{let n=0;for(const i of t){const t=e[i.fromIndex],o=e[i.fromIndex+1];for(let t=2;t<e.length;t++)i.shapeFct[i.parameters[t]]=e[i.fromIndex+t];n+=o*i.shapeFct.fct(s-t)}return n}}}function assert(t,e){if(!t)throw new Error(e||"unreachable")}const DefaultParameters={x:{init:t=>t.x,min:(t,e)=>t.x-2*e.fwhm,max:(t,e)=>t.x+2*e.fwhm,gradientDifference:(t,e)=>.002*e.fwhm},y:{init:t=>t.y,min:t=>t.y<0?-1.1:0,max:t=>t.y<0?0:1.1,gradientDifference:()=>.001},fwhm:{init:(t,e)=>e.fwhm,min:(t,e)=>.25*e.fwhm,max:(t,e)=>4*e.fwhm,gradientDifference:(t,e)=>.002*e.fwhm},mu:{init:(t,e)=>e.mu,min:()=>0,max:()=>1,gradientDifference:()=>.01}},properties$1=["init","min","max","gradientDifference"];function getInternalPeaks(t,e){let s=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},n=0,i=[];const{baseline:o=e.min}=s,a=t.map((t=>({...t,y:(t.y-o)/e.range})));for(const t of a){const{id:o,shape:a=(s.shape?s.shape:{kind:"gaussian"})}=t,l=getShape1D(a),r=["x","y",...l.getParameters()],m={min:[],max:[],init:[],gradientDifference:[]};for(let n of r)for(let i of properties$1){let o=t?.parameters?.[n]?.[i];if(o){o=getNormalizedValue$1(o,n,i,e,s.baseline),m[i].push(o);continue}let a=s?.parameters?.[n]?.[i];if(a){if("number"==typeof a){a=getNormalizedValue$1(a,n,i,e,s.baseline),m[i].push(a);continue}{let o=a(t);o=getNormalizedValue$1(o,n,i,e,s.baseline),m[i].push(o);continue}}assert(DefaultParameters[n],`No default parameter for ${n}`);const r=DefaultParameters[n][i];m[i].push(r(t,l))}const g=n,u=g+r.length-1;n+=u-g+1,i.push({id:o,shape:a,shapeFct:l,parameters:r,propertiesValues:m,fromIndex:g,toIndex:u})}return i}function getNormalizedValue$1(t,e,s,n,i){return"y"===e?"gradientDifference"===s?t:void 0!==i?(t-i)/n.range:(t-n.min)/n.range:t}function checkOptions(t,e,s){let{timeout:n,minValues:i,maxValues:o,initialValues:a,weights:l=1,damping:r=.01,dampingStepUp:m=11,dampingStepDown:g=9,maxIterations:u=100,errorTolerance:c=1e-7,centralDifference:C=!1,gradientDifference:f=.1,improvementThreshold:h=.001}=s;if(r<=0)throw new Error("The damping option must be a positive number");if(!t.x||!t.y)throw new Error("The data parameter must have x and y elements");if(!isAnyArray(t.x)||t.x.length<2||!isAnyArray(t.y)||t.y.length<2)throw new Error("The data parameter elements must be an array with more than 2 points");if(t.x.length!==t.y.length)throw new Error("The data parameter elements must have the same size");let p,d,y=a||new Array(e.length).fill(1),H=t.y.length,v=y.length;if(o=o||new Array(v).fill(Number.MAX_SAFE_INTEGER),i=i||new Array(v).fill(Number.MIN_SAFE_INTEGER),o.length!==i.length)throw new Error("minValues and maxValues must be the same size");if(!isAnyArray(y))throw new Error("initialValues must be an array");if("number"==typeof f)f=new Array(y.length).fill(f);else{if(!isAnyArray(f))throw new Error("gradientDifference should be a number or array with length equal to the number of parameters");f.length!==v&&(f=new Array(v).fill(f[0]))}if("number"==typeof l){let t=1/l**2;p=()=>t}else{if(!isAnyArray(l))throw new Error("weights should be a number or array with length equal to the number of data points");if(l.length<t.x.length){let t=1/l[0]**2;p=()=>t}else p=t=>1/l[t]**2}if(void 0!==n){if("number"!=typeof n)throw new Error("timeout should be a number");let t=Date.now()+1e3*n;d=()=>Date.now()>t}else d=()=>!1;let b=new Array(t.x.length);for(let t=0;t<H;t++)b[t]=p(t);return{checkTimeout:d,minValues:i,maxValues:o,parameters:y,weightSquare:b,damping:r,dampingStepUp:m,dampingStepDown:g,maxIterations:u,errorTolerance:c,centralDifference:C,gradientDifference:f,improvementThreshold:h}}function errorCalculation(t,e,s,n){let i=0;const o=s(e);for(let e=0;e<t.x.length;e++)i+=Math.pow(t.y[e]-o(t.x[e]),2)/n[e];return i}function gradientFunction(t,e,s,n,i,o){const a=s.length,l=t.x.length;let r=Matrix.zeros(a,l),m=0;for(let g=0;g<a;g++){if(0===n[g])continue;let a=n[g],u=s.slice();u[g]+=a;let c=i(u);if(o){u=s.slice(),u[g]-=a,a*=2;let e=i(u);for(let s=0;s<l;s++)r.set(m,s,(e(t.x[s])-c(t.x[s]))/a)}else for(let s=0;s<l;s++)r.set(m,s,(e[s]-c(t.x[s]))/a);m++}return r}function matrixFunction(t,e){const s=t.x.length;let n=new Matrix(s,1);for(let i=0;i<s;i++)n.set(i,0,t.y[i]-e[i]);return n}function step(t,e,s,n,i,o,a){let l=s,r=Matrix.eye(e.length,e.length,l);const m=i(e);let g=new Float64Array(t.x.length);for(let e=0;e<t.x.length;e++)g[e]=m(t.x[e]);let u=gradientFunction(t,g,e,n,i,o),c=matrixFunction(t,g),C=inverse(r.add(u.mmul(u.transpose().scale("row",{scale:a})))),f=u.mmul(c.scale("row",{scale:a}));return{perturbations:C.mmul(f),jacobianWeightResidualError:f}}function levenbergMarquardt(t,e){let s=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},{checkTimeout:n,minValues:i,maxValues:o,parameters:a,weightSquare:l,damping:r,dampingStepUp:m,dampingStepDown:g,maxIterations:u,errorTolerance:c,centralDifference:C,gradientDifference:f,improvementThreshold:h}=checkOptions(t,e,s),p=errorCalculation(t,a,e,l),d=p,y=a.slice(),H=p<=c,v=0;for(;v<u&&!H;v++){let u=p,{perturbations:v,jacobianWeightResidualError:b}=step(t,a,r,f,e,C,l);for(let t=0;t<a.length;t++)a[t]=Math.min(Math.max(i[t],a[t]-v.get(t,0)),o[t]);if(p=errorCalculation(t,a,e,l),isNaN(p))break;if(p<d-c&&(d=p,y=a.slice()),r=(u-p)/v.transpose().mmul(v.mul(r).add(b)).get(0,0)>h?Math.max(r/g,1e-7):Math.min(r*m,1e7),n())throw new Error(`The execution time is over to ${s.timeout} seconds`);H=p<=c}return{parameterValues:y,parameterError:d,iterations:v}}function antiLowerConvexHull(t,e){if(t.length!==e.length)throw new RangeError("X and Y vectors has different dimensions");const s=t.length-1;if(0===s)return[0];if(1===s)return[0,1];let n=0,i=new Array(t.length).fill(!0);for(;;){const o=n,a=moveOn(n,s,i),l=moveOn(moveOn(n,s,i),s,i);if(t[l]*(e[o]-e[a])+t[o]*(e[a]-e[l])+t[a]*(e[l]-e[o])>=0?n=a:(i[a]=!1,n=moveBack(n,s,i)),l===s)break}return i.map(((t,e)=>!1!==t&&e)).filter((t=>!1!==t))}function moveBack(t,e,s){let n=t-1;for(;!1===s[n];)n--;return 0===t?e:n}function moveOn(t,e,s){let n=t+1;for(;!1===s[n];)n++;return t===e?0:n}function direct(t,e,s){let n=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{};const{iterations:i=50,epsilon:o=1e-4,tolerance:a=1e-16,tolerance2:l=1e-12,initialState:r={}}=n;if(void 0===t||void 0===e||void 0===s)throw new RangeError("There is something undefined");if(e=new Float64Array(e),s=new Float64Array(s),e.length!==s.length)throw new Error("Lower bounds and Upper bounds for x are not of the same length");let m=e.length,g=s.map(((t,s)=>t-e[s])),{numberOfRectangles:u=0,totalIterations:c=0,unitaryCoordinates:C=[new Float64Array(m).fill(.5)],middlePoint:f=new Float64Array(m).map(((t,s)=>e[s]+C[0][s]*g[s])),bestCurrentValue:h=t(f),fCalls:p=1,smallerDistance:d=0,edgeSizes:y=[new Float64Array(m).fill(.5)],diagonalDistances:H=[Math.sqrt(m*Math.pow(.5,2))],functionValues:v=[h],differentDistances:b=H,smallerValuesByDistance:w=[h],choiceLimit:O}=r;if(r.originalCoordinates&&r.originalCoordinates.length>0){h=xMinValue(v),O=o*Math.abs(h)>1e-8?o*Math.abs(h):1e-8,d=getMinIndex(v,H,O,h),C=r.originalCoordinates.slice();for(let t=0;t<C.length;t++)for(let s=0;s<e.length;s++)C[t][s]=(C[t][s]-e[s])/g[s]}let x=0;for(;x<i;){let s,n,i=[],r=b.findIndex((t=>t===H[d])),m=0;for(let t=r;t<b.length;t++)for(let e=0;e<v.length;e++)v[e]===w[t]&H[e]===b[t]&&(i[m++]=e);if(b.length-r>1){let t=H[d],e=v[d],s=b[b.length-1],o=(w[b.length-1]-e)/(s-t),a=e-o*t,r=new Uint32Array(m);m=0;for(let t=0;t<r.length;t++){let e=i[t];v[e]<=o*H[e]+a+l&&(r[m++]=e)}let g=[],u=[];for(let t=0;t<m;t++)g.push(H[r[t]]),u.push(v[r[t]]);let c=antiLowerConvexHull(g,u);n=[];for(let t=0;t<c.length;t++)n.push(r[c[t]])}else n=i.slice(0,m);s=n;for(let n=0;n<s.length;n++){let i=s[n],o=xMaxValue(y[i]),l=new Uint32Array(y[i].length);m=0;for(let t=0;t<y[i].length;t++)Math.abs(y[i][t]-o)<a&&(l[m++]=t);let r=2*o/3,c=[];for(let s=0;s<m;s++){let n=l[s],o=C[i].slice(),a=C[i].slice();o[n]+=r,a[n]-=r;let m=new Float64Array(o.length),u=new Float64Array(a.length);for(let t=0;t<o.length;t++)m[t]=e[t]+o[t]*g[t],u[t]=e[t]+a[t]*g[t];let f=t(m),h=t(u);p+=2,c.push({minValue:Math.min(f,h),index:s}),C.push(o,a),v.push(f,h)}let f=c.sort(((t,e)=>t.minValue-e.minValue));for(let t=0;t<m;t++){let e=l[f[t].index],s=u+2*(f[t].index+1)-1,n=u+2*(f[t].index+1);y[i][e]=r/2,y[s]=y[i].slice(),y[n]=y[i].slice(),H[i]=xNorm(y[i]),H[s]=H[i],H[n]=H[i]}u+=2*m}h=xMinValue(v),O=o*Math.abs(h)>1e-8?o*Math.abs(h):1e-8,d=getMinIndex(v,H,O,h),b=Array.from(new Set(H)),b=b.sort(((t,e)=>t-e)),w=[];for(let t=0;t<b.length;t++){let e,s=Number.POSITIVE_INFINITY;for(let n=0;n<H.length;n++)H[n]===b[t]&&v[n]<s&&(s=v[n],e=n);w.push(v[e])}for(let t=0;t<v.length;t++)if(v[t]===h){let s=[];for(let n=0;n<e.length;n++)s.push(e[n]+C[t][n]*g[n])}x+=1}let D={};D.minFunctionValue=h,D.iterations=x;let j=[];for(let t=0;t<u+1;t++){let s=[];for(let n=0;n<e.length;n++)s.push(e[n]+C[t][n]*g[n]);j.push(s)}D.finalState={numberOfRectangles:u,totalIterations:c+=i,originalCoordinates:j,middlePoint:f,fCalls:p,smallerDistance:d,edgeSizes:y,diagonalDistances:H,functionValues:v,differentDistances:b,smallerValuesByDistance:w,choiceLimit:O};let A=[];for(let t=0;t<v.length;t++)v[t]===h&&A.push(j[t]);return D.optima=A,D}function getMinIndex(t,e,s,n){let i=[];for(let o=0;o<t.length;o++)i[o]=Math.abs(t[o]-(n+s))/e[o];const o=xMinValue(i);return i.findIndex((t=>t===o))}function directOptimization$1(t,e,s){const{minValues:n,maxValues:i,maxIterations:o,epsilon:a,tolerance:l,tolerance2:r,initialState:m}=s,g=direct(getObjectiveFunction$1(t,e),n,i,{iterations:o,epsilon:a,tolerance:l,tolerance2:r,initialState:m}),{optima:u}=g;return{parameterError:g.minFunctionValue,iterations:g.iterations,parameterValues:u[0]}}function getObjectiveFunction$1(t,e){const{x:s,y:n}=t,i=s.length;return t=>{const o=e(t);let a=0;for(let t=0;t<i;t++)a+=Math.pow(n[t]-o(s[t]),2);return a}}function selectMethod(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{kind:e="lm",options:s}=t;switch(e){case"lm":case"levenbergMarquardt":return{algorithm:levenbergMarquardt,optimizationOptions:{damping:1.5,maxIterations:100,errorTolerance:1e-8,...s}};case"direct":return{algorithm:directOptimization$1,optimizationOptions:{iterations:20,epsilon:1e-4,tolerance:1e-16,tolerance2:1e-12,initialState:{},...s}};default:throw new Error("Unknown fitting algorithm")}}function optimize(t,e){let s=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},n=xMinMaxValues(t.y);const i={...n,range:n.max-n.min},o=getInternalPeaks(e,i,s),{baseline:a=i.min}=s;let l=new Float64Array(t.y.length);for(let e=0;e<t.y.length;e++)l[e]=(t.y[e]-a)/i.range;const r=o[o.length-1].toIndex+1,m=new Float64Array(r),g=new Float64Array(r),u=new Float64Array(r),c=new Float64Array(r);let C=0;for(const t of o)for(let e=0;e<t.parameters.length;e++)m[C]=t.propertiesValues.min[e],g[C]=t.propertiesValues.max[e],u[C]=t.propertiesValues.init[e],c[C]=t.propertiesValues.gradientDifference[e],C++;let{algorithm:f,optimizationOptions:h}=selectMethod(s.optimization),p=getSumOfShapes$1(o),d=f({x:t.x,y:l},p,{minValues:m,maxValues:g,initialValues:u,gradientDifference:c,...h});const y=d.parameterValues;let H=[];for(let t of o){const{id:e,shape:s,parameters:n,fromIndex:o}=t;let l={x:0,y:0,shape:s};e&&(l={...l,id:e}),l.x=y[o],l.y=y[o+1]*i.range+a;for(let t=2;t<n.length;t++)l.shape[n[t]]=y[o+t];H.push(l)}return{error:d.parameterError,iterations:d.iterations,peaks:H}}const{parse:parse$6,stringify:stringify$6}=JSON;function addMissingShape(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{shape:s={kind:"gaussian"},output:n=parse$6(stringify$6(t))}=e;let i=getShape1D(s);return n.map((t=>{if(hasShape(t)){if(!("fwhm"in t.shape)){const e=getShape1D(t.shape);t.shape.fwhm=e.widthToFWHM(t.width)}return t}return{...t,shape:{fwhm:i.widthToFWHM(t.width),...s}}}))}function hasShape(t){return"shape"in t}function groupPeaks(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(t&&0===t.length)return[];const{factor:s=1}=e;(t=JSON.parse(JSON.stringify(t))).sort(((t,e)=>t.x-e.x));let n=t[0],i=[n],o=[i];for(let e=1;e<t.length;e++){const a=t[e];(a.x-n.x)/((a.width+n.width)/2)<=s?i.push(a):(i=[a],o.push(i)),n=a}return o}function optimizePeaksWithLogs(t,e){let s=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};const{fromTo:n={},baseline:i,shape:o={kind:"gaussian"},groupingFactor:a=1,factorLimits:l=2,optimization:r={kind:"lm",options:{timeout:10}}}=s;let m=groupPeaks(e,{factor:a}),g=[],u=[];return m.forEach((e=>{const s=Date.now(),a=addMissingShape(e,{shape:o}),m=a[0],c=a[a.length-1],{from:C=m.x-m.width*l,to:f=c.x+c.width*l}=n,{fromIndex:h,toIndex:p}=xGetFromToIndex(t.x,{from:C,to:f}),d=t.x instanceof Float64Array?t.x.subarray(h,p):t.x.slice(h,p),y=t.y instanceof Float64Array?t.y.subarray(h,p):t.y.slice(h,p),H={range:{from:C,to:f},parameters:r,groupSize:e.length,time:Date.now()-s};if(d.length>5){const{iterations:t,error:e,peaks:s}=optimize({x:d,y:y},a,{shape:o,baseline:i,optimization:r});for(let t=0;t<a.length;t++)u.push({...s[t],width:getShape1D(a[t].shape).fwhmToWidth(s[t].shape.fwhm)});g.push({...H,iterations:t,error:e,message:"optimization successful"})}else u.push(...a),g.push({...H,iterations:0,message:"x length too small for optimization"})})),{logs:g,optimizedPeaks:u}}function optimizePeaks(t,e){let s=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};return optimizePeaksWithLogs(t,e,s).optimizedPeaks}const{parse:parse$5,stringify:stringify$5}=JSON;function addMissingIDs$1(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{output:s=parse$5(stringify$5(t))}=e;for(const t of s)"id"in t||(t.id=v4());return s}function joinBroadPeaks(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{shape:s={kind:"gaussian"},optimization:n={kind:"lm",options:{timeout:10}},broadWidth:i=.25,broadRatio:o=.0025}=e,a=0,l=0,r=1;const m=[];if(t.length<2)return addMissingIDs$1(addMissingShape(t.map(getGSDPeakOptimizedStructure),{shape:s}));let g=t[0].ddY;for(let e=1;e<t.length;e++)Math.abs(t[e].ddY)>g&&(g=Math.abs(t[e].ddY));const u=[];for(const e of t)Math.abs(e.ddY)<=o*g?m.push(e):u.push(getGSDPeakOptimizedStructure(e));m.push({x:Number.MAX_VALUE,y:0});let c={x:[m[0].x],y:[m[0].y]},C=[0];for(let t=1;t<m.length;t++)if(Math.abs(m[t-1].x-m[t].x)<i)c.x.push(m[t].x),c.y.push(m[t].y),m[t].y>a&&(a=m[t].y,l=t),C.push(t),r++;else{if(r>2){let t=optimizePeaks(c,[{id:v4(),x:m[l].x,y:a,width:c.x[0]-c.x[c.x.length-1]}],{shape:s,optimization:n});u.push(t[0])}else for(const t of C)u.push(getGSDPeakOptimizedStructure(m[t]));c={x:[m[t].x],y:[m[t].y]},C=[t],a=m[t].y,l=t,r=1}return u.sort(((t,e)=>t.x-e.x)),addMissingIDs$1(u,{output:u})}function getGSDPeakOptimizedStructure(t){const{id:e,shape:s,x:n,y:i,width:o}=t;let a={x:n,y:i,width:o,shape:s};return e&&(a.id=e),a}const{parse:parse$4,stringify:stringify$4}=JSON;function setShape(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{shape:s={kind:"gaussian"},output:n=parse$4(stringify$4(t))}=e,i=getShape1D(s);return n.map((t=>({...t,shape:{fwhm:i.widthToFWHM(t.width),...s}})))}function peakToXY(t,e){const s=addMissingShape([t])[0],n=getShape1D(s.shape).getFactor(),{from:i=s.x-t.width*n/e.frequency,to:o=s.x+t.width*n/e.frequency}=e;return peaksToXY([t],{...e,from:i,to:o})}var browserPonyfill={exports:{}};!function(t,e){var s="undefined"!=typeof self?self:commonjsGlobal,n=function(){function t(){this.fetch=!1,this.DOMException=s.DOMException}return t.prototype=s,new t}();!function(t){!function(e){var s="URLSearchParams"in t,n="Symbol"in t&&"iterator"in Symbol,i="FileReader"in t&&"Blob"in t&&function(){try{return new Blob,!0}catch(t){return!1}}(),o="FormData"in t,a="ArrayBuffer"in t;if(a)var l=["[object Int8Array]","[object Uint8Array]","[object Uint8ClampedArray]","[object Int16Array]","[object Uint16Array]","[object Int32Array]","[object Uint32Array]","[object Float32Array]","[object Float64Array]"],r=ArrayBuffer.isView||function(t){return t&&l.indexOf(Object.prototype.toString.call(t))>-1};function m(t){if("string"!=typeof t&&(t=String(t)),/[^a-z0-9\-#$%&'*+.^_`|~]/i.test(t))throw new TypeError("Invalid character in header field name");return t.toLowerCase()}function g(t){return"string"!=typeof t&&(t=String(t)),t}function u(t){var e={next:function(){var e=t.shift();return{done:void 0===e,value:e}}};return n&&(e[Symbol.iterator]=function(){return e}),e}function c(t){this.map={},t instanceof c?t.forEach((function(t,e){this.append(e,t)}),this):Array.isArray(t)?t.forEach((function(t){this.append(t[0],t[1])}),this):t&&Object.getOwnPropertyNames(t).forEach((function(e){this.append(e,t[e])}),this)}function C(t){if(t.bodyUsed)return Promise.reject(new TypeError("Already read"));t.bodyUsed=!0}function f(t){return new Promise((function(e,s){t.onload=function(){e(t.result)},t.onerror=function(){s(t.error)}}))}function h(t){var e=new FileReader,s=f(e);return e.readAsArrayBuffer(t),s}function p(t){if(t.slice)return t.slice(0);var e=new Uint8Array(t.byteLength);return e.set(new Uint8Array(t)),e.buffer}function d(){return this.bodyUsed=!1,this._initBody=function(t){var e;this._bodyInit=t,t?"string"==typeof t?this._bodyText=t:i&&Blob.prototype.isPrototypeOf(t)?this._bodyBlob=t:o&&FormData.prototype.isPrototypeOf(t)?this._bodyFormData=t:s&&URLSearchParams.prototype.isPrototypeOf(t)?this._bodyText=t.toString():a&&i&&((e=t)&&DataView.prototype.isPrototypeOf(e))?(this._bodyArrayBuffer=p(t.buffer),this._bodyInit=new Blob([this._bodyArrayBuffer])):a&&(ArrayBuffer.prototype.isPrototypeOf(t)||r(t))?this._bodyArrayBuffer=p(t):this._bodyText=t=Object.prototype.toString.call(t):this._bodyText="",this.headers.get("content-type")||("string"==typeof t?this.headers.set("content-type","text/plain;charset=UTF-8"):this._bodyBlob&&this._bodyBlob.type?this.headers.set("content-type",this._bodyBlob.type):s&&URLSearchParams.prototype.isPrototypeOf(t)&&this.headers.set("content-type","application/x-www-form-urlencoded;charset=UTF-8"))},i&&(this.blob=function(){var t=C(this);if(t)return t;if(this._bodyBlob)return Promise.resolve(this._bodyBlob);if(this._bodyArrayBuffer)return Promise.resolve(new Blob([this._bodyArrayBuffer]));if(this._bodyFormData)throw new Error("could not read FormData body as blob");return Promise.resolve(new Blob([this._bodyText]))},this.arrayBuffer=function(){return this._bodyArrayBuffer?C(this)||Promise.resolve(this._bodyArrayBuffer):this.blob().then(h)}),this.text=function(){var t,e,s,n=C(this);if(n)return n;if(this._bodyBlob)return t=this._bodyBlob,e=new FileReader,s=f(e),e.readAsText(t),s;if(this._bodyArrayBuffer)return Promise.resolve(function(t){for(var e=new Uint8Array(t),s=new Array(e.length),n=0;n<e.length;n++)s[n]=String.fromCharCode(e[n]);return s.join("")}(this._bodyArrayBuffer));if(this._bodyFormData)throw new Error("could not read FormData body as text");return Promise.resolve(this._bodyText)},o&&(this.formData=function(){return this.text().then(v)}),this.json=function(){return this.text().then(JSON.parse)},this}c.prototype.append=function(t,e){t=m(t),e=g(e);var s=this.map[t];this.map[t]=s?s+", "+e:e},c.prototype.delete=function(t){delete this.map[m(t)]},c.prototype.get=function(t){return t=m(t),this.has(t)?this.map[t]:null},c.prototype.has=function(t){return this.map.hasOwnProperty(m(t))},c.prototype.set=function(t,e){this.map[m(t)]=g(e)},c.prototype.forEach=function(t,e){for(var s in this.map)this.map.hasOwnProperty(s)&&t.call(e,this.map[s],s,this)},c.prototype.keys=function(){var t=[];return this.forEach((function(e,s){t.push(s)})),u(t)},c.prototype.values=function(){var t=[];return this.forEach((function(e){t.push(e)})),u(t)},c.prototype.entries=function(){var t=[];return this.forEach((function(e,s){t.push([s,e])})),u(t)},n&&(c.prototype[Symbol.iterator]=c.prototype.entries);var y=["DELETE","GET","HEAD","OPTIONS","POST","PUT"];function H(t,e){var s,n,i=(e=e||{}).body;if(t instanceof H){if(t.bodyUsed)throw new TypeError("Already read");this.url=t.url,this.credentials=t.credentials,e.headers||(this.headers=new c(t.headers)),this.method=t.method,this.mode=t.mode,this.signal=t.signal,i||null==t._bodyInit||(i=t._bodyInit,t.bodyUsed=!0)}else this.url=String(t);if(this.credentials=e.credentials||this.credentials||"same-origin",!e.headers&&this.headers||(this.headers=new c(e.headers)),this.method=(s=e.method||this.method||"GET",n=s.toUpperCase(),y.indexOf(n)>-1?n:s),this.mode=e.mode||this.mode||null,this.signal=e.signal||this.signal,this.referrer=null,("GET"===this.method||"HEAD"===this.method)&&i)throw new TypeError("Body not allowed for GET or HEAD requests");this._initBody(i)}function v(t){var e=new FormData;return t.trim().split("&").forEach((function(t){if(t){var s=t.split("="),n=s.shift().replace(/\+/g," "),i=s.join("=").replace(/\+/g," ");e.append(decodeURIComponent(n),decodeURIComponent(i))}})),e}function b(t,e){e||(e={}),this.type="default",this.status=void 0===e.status?200:e.status,this.ok=this.status>=200&&this.status<300,this.statusText="statusText"in e?e.statusText:"OK",this.headers=new c(e.headers),this.url=e.url||"",this._initBody(t)}H.prototype.clone=function(){return new H(this,{body:this._bodyInit})},d.call(H.prototype),d.call(b.prototype),b.prototype.clone=function(){return new b(this._bodyInit,{status:this.status,statusText:this.statusText,headers:new c(this.headers),url:this.url})},b.error=function(){var t=new b(null,{status:0,statusText:""});return t.type="error",t};var w=[301,302,303,307,308];b.redirect=function(t,e){if(-1===w.indexOf(e))throw new RangeError("Invalid status code");return new b(null,{status:e,headers:{location:t}})},e.DOMException=t.DOMException;try{new e.DOMException}catch(t){e.DOMException=function(t,e){this.message=t,this.name=e;var s=Error(t);this.stack=s.stack},e.DOMException.prototype=Object.create(Error.prototype),e.DOMException.prototype.constructor=e.DOMException}function O(t,s){return new Promise((function(n,o){var a=new H(t,s);if(a.signal&&a.signal.aborted)return o(new e.DOMException("Aborted","AbortError"));var l=new XMLHttpRequest;function r(){l.abort()}l.onload=function(){var t,e,s={status:l.status,statusText:l.statusText,headers:(t=l.getAllResponseHeaders()||"",e=new c,t.replace(/\r?\n[\t ]+/g," ").split(/\r?\n/).forEach((function(t){var s=t.split(":"),n=s.shift().trim();if(n){var i=s.join(":").trim();e.append(n,i)}})),e)};s.url="responseURL"in l?l.responseURL:s.headers.get("X-Request-URL");var i="response"in l?l.response:l.responseText;n(new b(i,s))},l.onerror=function(){o(new TypeError("Network request failed"))},l.ontimeout=function(){o(new TypeError("Network request failed"))},l.onabort=function(){o(new e.DOMException("Aborted","AbortError"))},l.open(a.method,a.url,!0),"include"===a.credentials?l.withCredentials=!0:"omit"===a.credentials&&(l.withCredentials=!1),"responseType"in l&&i&&(l.responseType="blob"),a.headers.forEach((function(t,e){l.setRequestHeader(e,t)})),a.signal&&(a.signal.addEventListener("abort",r),l.onreadystatechange=function(){4===l.readyState&&a.signal.removeEventListener("abort",r)}),l.send(void 0===a._bodyInit?null:a._bodyInit)}))}O.polyfill=!0,t.fetch||(t.fetch=O,t.Headers=c,t.Request=H,t.Response=b),e.Headers=c,e.Request=H,e.Response=b,e.fetch=O,Object.defineProperty(e,"__esModule",{value:!0})}({})}(n),n.fetch.ponyfill=!0,delete n.fetch.polyfill;var i=n;(e=i.fetch).default=i.fetch,e.fetch=i.fetch,e.Headers=i.Headers,e.Request=i.Request,e.Response=i.Response,t.exports=e}(browserPonyfill,browserPonyfill.exports);var fetch=getDefaultExportFromCjs(browserPonyfill.exports),browser="object"==typeof self?self.FormData:window.FormData,FormData$1=browser;let xAtomicNumber=0;function tagAtom(t,e){let s=`${t.getAtomLabel(e)}*`;return t.setAtomCustomLabel(e,s),1===t.getAtomicNo(e)?t.setAtomicNo(e,getXAtomicNumber(t)):t.setAtomMass(e,t.getAtomMass(e)+5),s}function getXAtomicNumber(t){if(!xAtomicNumber){const e=t.getOCL();xAtomicNumber=e.Molecule.getAtomicNoFromLabel("X")}return xAtomicNumber}function addDiastereotopicMissingChirality(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{Molecule:s}=t.getOCL(),{esrType:n=s.cESRTypeAnd}=e;for(let e=0;e<t.getAllAtoms();e++){let i=t.getCompactCopy();tagAtom(i,e),i.ensureHelperArrays(s.cHelperBitsStereo);for(let e=0;e<i.getAtoms();e++)if(i.isAtomStereoCenter(e)&&-1===i.getStereoBond(e)){let o=i.getAtomPreferredStereoBond(e);if(-1!==o){if(t.setBondType(o,s.cBondTypeUp),t.getBondAtom(1,o)===e){let s=t.getBondAtom(0,o);t.setBondAtom(0,o,e),t.setBondAtom(1,o,s)}t.setAtomESR(e,n,0)}}}}function makeRacemic(t){const{Molecule:e}=t.getOCL();t.ensureHelperArrays(e.cHelperCIP);for(let s=0;s<t.getAllAtoms();s++)t.getAtomParity(s)!==e.cAtomParityNone&&t.setAtomESR(s,e.cESRTypeAnd,0)}function getDiastereotopicAtomIDs(t){const e=t.getOCL();addDiastereotopicMissingChirality(t);let s=t.getAllAtoms(),n=[];for(let i=0;i<s;i++){let s=t.getCompactCopy();tagAtom(s,i),makeRacemic(s),n[i]=s.getCanonizedIDCode(e.Molecule.CANONIZER_ENCODE_ATOM_CUSTOM_LABELS)}return n}function getGroupedDiastereotopicAtomIDs(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{atomLabel:s}=e;let n=getDiastereotopicAtomIDs(t),i={};for(let e=0;e<n.length;e++)if(!s||t.getAtomLabel(e)===s){let s=n[e];i[s]||(i[s]={counter:0,atoms:[],oclID:s,atomLabel:t.getAtomLabel(e)}),i[s].counter++,i[s].atoms.push(e)}return Object.values(i)}function isCsp3(t,e){return 6===t.getAtomicNo(e)&&(0===t.getAtomCharge(e)&&t.getImplicitHydrogens(e)+t.getConnAtoms(e)===4)}const FULL_HOSE_CODE=1,HOSE_CODE_CUT_C_SP3_SP3=2;function getHoseCodesForAtoms(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[],s=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};const n=t.getOCL(),{minSphereSize:i=0,maxSphereSize:o=4,kind:a=FULL_HOSE_CODE,isTagged:l=!1}=s,r=t.getCompactCopy();if(!l){const t=[];for(let s=0;s<e.length;s++){let i=e[s];t.push(tagAtom(r,i)),r.addImplicitHydrogens(),r.addMissingChirality(),r.ensureHelperArrays(n.Molecule.cHelperNeighbours)}e.length=0;for(let s=0;s<r.getAllAtoms();s++)t.includes(r.getAtomCustomLabel(s))&&e.push(s)}let m=new n.Molecule(0,0),g=[],u=0,c=0,C=new Array(r.getAllAtoms()),f=new Array(r.getAllAtoms());for(let t=0;t<=o;t++){if(0===c)for(let t of e)f[c]=t,C[t]=!0,c++;else{let t=c;for(let e=u;e<c;e++){let s=f[e];for(let e=0;e<r.getAllConnAtoms(s);e++){let n=r.getConnAtom(s,e);if(!C[n])switch(a){case FULL_HOSE_CODE:C[n]=!0,f[t++]=n;break;case HOSE_CODE_CUT_C_SP3_SP3:isCsp3(r,s)&&isCsp3(r,n)||(C[n]=!0,f[t++]=n);break;default:throw new Error("getHoseCoesForAtom unknown kind")}}}u=c,c=t}r.copyMoleculeByAtoms(m,C,!0,null),t>=i&&(makeRacemic(m),g.push(m.getCanonizedIDCode(n.Molecule.CANONIZER_ENCODE_ATOM_CUSTOM_LABELS)))}return g}function getHoseCodesForAtom(t,e){let s=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};return getHoseCodesForAtoms(t,[e],s)}function getHoseCodesFromDiastereotopicID(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};t.addImplicitHydrogens(),t.addMissingChirality();let s=-1;for(let e=0;e<t.getAllAtoms();e++){const n=t.getAtomCustomLabel(e);if(null!=n&&n.endsWith("*")){s=e;break}}if(s>=0)return e.isTagged=!0,getHoseCodesForAtom(t,s,e)}let fragment$1,fragment;function getHoseCodesForPath(t,e,s,n){const i=t.getOCL(),o=e,a=s;let l,r=[];(t=t.getCompactCopy()).getPath(r,e,s,n+1),4===r.length&&(l=t.calculateTorsion(r));const m=tagAtom(t,e),g=tagAtom(t,s);t.addImplicitHydrogens(),t.addMissingChirality(),t.ensureHelperArrays(i.Molecule.cHelperNeighbours),e=-1,s=-1;for(let n=0;n<t.getAllAtoms();n++)m===g?t.getAtomCustomLabel(n)===m&&(-1===e?e=n:s=n):(m===t.getAtomCustomLabel(n)&&(e=n),g===t.getAtomCustomLabel(n)&&(s=n));fragment$1||(fragment$1=new i.Molecule(0,0));let u=[];t.getPath(u,e,s,n+1);let c=0,C=0,f=new Array(t.getAllAtoms()).fill(!1),h=new Array(t.getAllAtoms()).fill(-1),p=[];for(let e=0;e<=2;e++){if(0===C)for(let t of u)f[t]=!0,h[C++]=t;else{let e=C;for(let s=c;s<C;s++){let n=h[s];for(let s=0;s<t.getAllConnAtoms(n);s++){let i=t.getConnAtom(n,s);f[i]||(f[i]=!0,h[e++]=i)}}c=C,C=e}let s=[];t.copyMoleculeByAtoms(fragment$1,f,!0,s),makeRacemic(fragment$1);let n=fragment$1.getCanonizedIDCode(i.Molecule.CANONIZER_ENCODE_ATOM_CUSTOM_LABELS);p.push({sphere:e,oclID:n})}return{atoms:r,from:o,to:a,torsion:l,hoses:p,length:r.length-1}}function getAtomsInfo(t){const e=t.getOCL();t.ensureHelperArrays(e.Molecule.cHelperRings);let s=getDiastereotopicAtomIDs(t),n=[];for(let e=0;e<s.length;e++){let i={oclID:s[e],extra:{singleBonds:0,doubleBonds:0,tripleBonds:0,aromaticBonds:0,cnoHybridation:0}},o=i.extra;n.push(i),i.abnormalValence=t.getAtomAbnormalValence(e),i.charge=t.getAtomCharge(e),i.cipParity=t.getAtomCIPParity(e),i.color=t.getAtomColor(e),i.customLabel=t.getAtomCustomLabel(e),i.atomicNo=t.getAtomicNo(e),i.label=t.getAtomLabel(e),i.mass=t.getAtomMass(e),i.radical=t.getAtomRadical(e),i.ringBondCount=t.getAtomRingBondCount(e),i.ringSize=t.getAtomRingSize(e),i.x=t.getAtomX(e),i.y=t.getAtomY(e),i.z=t.getAtomZ(e),i.allHydrogens=t.getAllHydrogens(e),i.connAtoms=t.getConnAtoms(e),i.allConnAtoms=t.getAllConnAtoms(e),i.implicitHydrogens=i.allHydrogens+i.connAtoms-i.allConnAtoms,i.isAromatic=t.isAromaticAtom(e),i.isAllylic=t.isAllylicAtom(e),i.isStereoCenter=t.isAtomStereoCenter(e),i.isRing=t.isRingAtom(e),i.isSmallRing=t.isSmallRingAtom(e),i.isStabilized=t.isStabilizedAtom(e),i.extra.singleBonds=1===i.atomicNo?0:i.implicitHydrogens;for(let s=0;s<t.getAllConnAtoms(e);s++){let n=t.getConnBond(e,s),i=t.getBondOrder(n);t.isAromaticBond(n)?o.aromaticBonds++:1===i?o.singleBonds++:2===i?o.doubleBonds++:3===i&&o.tripleBonds++}if(i.extra.totalBonds=i.extra.singleBonds+i.extra.doubleBonds+i.extra.tripleBonds+i.extra.aromaticBonds,6===i.atomicNo)i.extra.cnoHybridation=i.extra.totalBonds-1;else if(7===i.atomicNo)i.extra.cnoHybridation=i.extra.totalBonds;else if(8===i.atomicNo)i.extra.cnoHybridation=i.extra.totalBonds+1;else if(1===i.atomicNo){let s=0===t.getAllConnAtoms(e)?0:t.getAtomicNo(t.getConnAtom(e,0));i.extra.hydrogenOnAtomicNo=s,7!==s&&8!==s||(i.extra.labileHydrogen=!0)}}return n}function floydWarshall(t){if(Matrix.isMatrix(t)&&t.columns!==t.rows)throw new TypeError("The adjacency matrix should be squared");const e=t.columns;let s=new Matrix(e,e);s.apply(((e,n)=>{if(e===n)s.set(e,n,0);else{let i=t.get(e,n);i||Object.is(i,-0)?s.set(e,n,i):s.set(e,n,Number.POSITIVE_INFINITY)}}));for(let t=0;t<e;++t)for(let n=0;n<e;++n)for(let i=0;i<e;++i){let e=s.get(n,t)+s.get(t,i);s.get(n,i)>e&&s.set(n,i,e)}return s.apply(((t,e)=>{s.get(t,e)===Number.POSITIVE_INFINITY&&s.set(t,e,-1)})),s}function getConnectivityMatrix(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const s=t.getOCL();t.ensureHelperArrays(s.Molecule.cHelperNeighbours);let n=t.getAllAtoms(),i=new Array(n).fill();if(i=i.map((()=>new Array(n).fill(0))),!e.pathLength)if(e.atomicNo)for(let e=0;e<n;e++)i[e][e]=t.getAtomicNo(e);else if(e.negativeAtomicNo)for(let e=0;e<n;e++)i[e][e]=-t.getAtomicNo(e);else if(e.mass)for(let e=0;e<n;e++)i[e][e]=s.Molecule.cRoundedMass[t.getAtomicNo(e)];else for(let t=0;t<n;t++)i[t][t]=1;if(e.sdt)for(let e=0;e<n;e++){let s=t.getAllConnAtoms(e);for(let n=0;n<s;n++)i[e][t.getConnAtom(e,n)]=t.getConnBondOrder(e,n)}else if(e.sdta)for(let e=0;e<n;e++){let s=t.getAllConnAtoms(e);for(let n=0;n<s;n++){let s=t.getConnBond(e,n);t.isAromaticBond(s)?i[e][t.getConnAtom(e,n)]=4:i[e][t.getConnAtom(e,n)]=t.getConnBondOrder(e,n)}}else for(let e=0;e<n;e++){let s=t.getAllConnAtoms(e);for(let n=0;n<s;n++)i[e][t.getConnAtom(e,n)]=1}return e.pathLength&&(i=floydWarshall(new Matrix(i)).to2DArray()),i}function getPathAndTorsion(t,e,s,n){let i,o=[];return t.getPath(o,e,s,n+1),4===o.length&&(i=t.calculateTorsion(o)),{atoms:o,from:e,to:s,torsion:i,length:o.length-1}}function getPathsInfo(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{fromLabel:s="H",toLabel:n="H",minLength:i=1,maxLength:o=4,withHOSES:a=!1}=e,l=t.getOCL();fragment||(fragment=new l.Molecule(0,0));let r=l.Molecule.getAtomicNoFromLabel(s),m=l.Molecule.getAtomicNoFromLabel(n),g=getAtomsInfo(t),u=getConnectivityMatrix(t,{pathLength:!0});for(let e=0;e<t.getAllAtoms();e++){g[e].paths=[];for(let s=0;s<t.getAllAtoms();s++)if(e!==s&&t.getAtomicNo(e)===r&&t.getAtomicNo(s)===m){let n=u[e][s];n>=i&&n<=o&&(a?g[e].paths.push(getHoseCodesForPath(t,e,s,n)):g[e].paths.push(getPathAndTorsion(t,e,s,n)))}}return g}function sum(t){if(!isAnyArray(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");for(var e=0,s=0;s<t.length;s++)e+=t[s];return e}function mean(t){return sum(t)/t.length}const couplingValues={s:0,d:1,t:2,q:3,quint:4,h:5,hex:5,hept:6,sept:6,oct:7,o:7,non:8,n:8};function joinPatterns(t){const e=t.reduce(((t,e)=>{if(isNaN(couplingValues[e]))throw new Error(`pattern ${e} is not in ${Object.keys(couplingValues).join(" ")}`);return t+couplingValues[e]}),0);if(!couplingPatterns[e])throw new Error("The joined pattern doesn't exist");return couplingPatterns[e]}const localeCompare$1=(t,e)=>t.localeCompare(e),localeCompareJcouplingKeys$1=(t,e)=>{const s=`${t.diaIDs.sort(localeCompare$1).join(" ")}`,n=`${e.diaIDs.sort(localeCompare$1).join(" ")}`;return localeCompare$1(s,n)},areThanClose=(t,e,s)=>Math.abs(t.coupling-e.coupling)<s,takeCareDiaIDs=(t,e,s)=>0===localeCompareJcouplingKeys$1(t,e)&&areThanClose(t,e,s);function signalJoinCouplings(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{tolerance:s=.05,ignoreDiaIDs:n=!1}=e;return!t.js||t.js.length<2?t:n?(checkJs(t),groupJCouplings(t,areThanClose,s)):(checkJsAndDiaID(t),groupJCouplings(t,takeCareDiaIDs,s))}function groupJCouplings(t,e,s){t.js.sort(((t,e)=>e.coupling-t.coupling));let n=[t.js[0]],i=[n];for(let o=1;o<t.js.length;o++){let a=t.js[o];e(n[n.length-1],a,s)?n.push(a):(n=[a],i.push(n))}t.js=[];for(let e of i){let s=sum(e.map((t=>t.coupling)))/e.length,n=distinctValues(e.filter((t=>t.atoms)).map((t=>t.atoms)).flat()),i=distinctValues(e.filter((t=>t.assignment)).map((t=>t.assignment)).flat()).join(" "),o=distinctValues(e.filter((t=>t.diaIDs)).map((t=>t.diaIDs)).flat()),a=distinctValues(e.map((t=>t.pathLength))),l={coupling:s,multiplicity:joinPatterns(e.filter((t=>t.multiplicity)).map((t=>t.multiplicity)))};1===o.length&&(l.diaIDs=o),1===a.length&&a[0]&&(l.pathLength=a[0]),i.length>0&&(l.assignment=i),n.length>0&&(l.atoms=n),t.js.push(l)}return t}function distinctValues(t){const e=new Set;for(const s of t)e.add(s);return Array.from(e)}function checkJsAndDiaID(t){if(!t.js)throw new Error("there is not js");for(const e of t.js)if(!e.diaIDs)throw new Error("there is not diaIDs")}function checkJs(t){if(!t.js)throw new Error("there is not js")}const localeCompare=(t,e)=>t.localeCompare(e),localeCompareJcouplingKeys=(t,e)=>{const s=`${t.diaIDs.join(" ")}${t.pathLength}`,n=`${e.diaIDs.join(" ")}${e.pathLength}`;return localeCompare(s,n)};function checkForMandatory$2(t){for(const e of t){if(!e.js)throw new Error("there is not js");if(!e.diaIDs)throw new Error("there is not diaIDs");for(const t of e.js){if(!t.diaIDs)throw new Error("there is not diaIDs");if(!t.pathLength)throw new Error("there is not pathLength")}}}function signalsJoin(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};checkForMandatory$2(t);const{joinCouplings:s={}}=e,{tolerance:n,ignoreDiaIDs:i}=s,o=JSON.parse(JSON.stringify(t)),a={};for(let t of o){t.js=t.js.sort(localeCompareJcouplingKeys);let e=`${t.diaIDs.join(" ")} ${t.js.map((t=>`${t.diaIDs.join(" ")} ${t.pathLength}`)).sort(localeCompare).join(" ")}`;a[e]||(a[e]=[]),a[e].push(t)}let l=[];return Object.values(a).forEach((t=>{let e=[];for(let s=0;s<t[0].js.length;s++){const n=t[0].js[s];e.push({diaIDs:n.diaIDs,pathLength:n.pathLength,multiplicity:n.multiplicity,coupling:mean(t.map((t=>t.js[s].coupling)))})}let s={id:v4(),nbAtoms:sum(t.map((t=>t.nbAtoms||0))),delta:mean(t.map((t=>t.delta))),diaIDs:t[0].diaIDs,atoms:t.map((t=>t.atoms||[])).flat(),js:e};const n=t.map((t=>t.assignment)).filter((t=>t)).join(" ");n.length>0&&(s.assignment=n),l.push(s)})),l=l.map((t=>{let e=signalJoinCouplings(t,{tolerance:n,ignoreDiaIDs:i});return e.js&&(e.multiplicity=e.js.length>0?e.js.map((t=>t.multiplicity)).join(""):"s"),e})).sort(((t,e)=>t.delta-e.delta)),l}function rangeFromSignal(t,e){const{nucleus:s="1h",frequency:n=400}=e,{tolerance:i=getTolerance(s)/n}=e;let o=0;for(const e of t.js||[]){const{coupling:t,multiplicity:s="d"}=e;o+=couplingValues[s]*t/n}return o=i+o/2,{from:t.delta-o,to:t.delta+o}}function getTolerance(t){switch(t.toLocaleLowerCase()){case"1h":return 1.5;case"13C":return 3;default:return 2}}function checkNbAtoms(t){for(let e of t)if(!e.nbAtoms)throw new Error("nbAtoms is mandatory")}function signalsToRanges(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};checkNbAtoms(t);const{tolerance:s=.05,frequency:n=400}=e;let i=t.map((t=>({original:t})));i.forEach((t=>{const e=rangeFromSignal(t.original,{frequency:n,tolerance:s});t.from=e.from,t.to=e.to})),i=i.sort(((t,e)=>t.from-e.from));let o=[],a={};for(let t of i)void 0===a.from||t.from>a.to?(a={id:v4(),from:t.from,to:t.to,integration:t.original.nbAtoms,signals:[t.original]},o.push(a)):(a.integration+=t.original.nbAtoms,t.to>a.to&&(a.to=t.to),a.signals.push(t.original));return o}async function predictProton(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{cache:s}=e;(t=t.getCompactCopy()).addImplicitHydrogens(),addDiastereotopicMissingChirality(t);const n=t.toMolfile();let i;if(s&&(i=s(n)),void 0===i){const t=new FormData$1;t.append("molfile",n);const e=await fetch("https://www.nmrdb.org/service/predictor",{method:"POST",body:t});i=await e.text(),s&&s(n,i)}const o=getDiastereotopicAtomIDs(t),a=protonParser(i,t,o),l=signalsJoin(a);return{molfile:n,diaIDs:o,nucleus:"1H",joinedSignals:l,signals:a,ranges:signalsToRanges(l),molecule:t}}function protonParser(t,e,s){if(0===e.getAllAtoms())return[];if(t.includes("ERR"))throw Error(`Spinus optimization: ${t}`);let n=getConnectivityMatrix(e,{pathLength:!0}),i=t.split("\n").filter((t=>t)),o=[];for(let t of i){let e=t.split("\t"),i=e.slice(4),a=Number(e[0])-1,l={id:v4(),atoms:[a],diaIDs:[s[a]],nbAtoms:1,delta:Number(e[2]),js:[]};if(!l.js)throw new Error("For atom js property was not added");for(let t=0;t<i.length;t+=3){let e=Number(i[t])-1;l.js.push({coupling:Number(i[t+2]),atoms:[e],diaIDs:[s[e]],multiplicity:"d",pathLength:n[a][e]}),l.js.sort(((t,e)=>e.coupling-t.coupling))}o.push(l)}return o}const{parse:parse$3,stringify:stringify$3}=JSON;function setIDs(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const s=e.output||parse$3(stringify$3(t));for(const t of s)t.id=v4();return s}async function fetchPrediction(t,e){const{webserviceURL:s}=e,n=await browserPonyfill.exports.fetch(s,{headers:{accept:"application/json","content-type":"application/json"},body:JSON.stringify({molfile:t.toMolfile()}),method:"POST"}),i=(await n.json()).data;return i.molecule=t.getOCL().Molecule.fromMolfile(i.molfile),i}function flatGroupedDiaIDs(t){let e=[];for(let s of t)for(let t of s.atoms)e[t]=s.oclID;return e}function getFilteredIDiaIDs(t,e){const{maxSphereSize:s}=e;t.addImplicitHydrogens(),t.addMissingChirality(),addDiastereotopicMissingChirality(t);const n=t.toMolfile();let i=getGroupedDiastereotopicAtomIDs(t),o=i.filter((t=>"C"===t.atomLabel)).sort(((t,e)=>t.atomLabel===e.atomLabel?e.counter-t.counter:t.atomLabel<e.atomLabel?1:-1));const a=t.getOCL();for(const t of o)t.hose=getHoseCodesFromDiastereotopicID(a.Molecule.fromIDCode(t.oclID),{maxSphereSize:s});return{molfile:n,carbonDiaIDs:o,groupedDiaIDs:i}}function queryByHose(t,e,s){const{maxSphereSize:n}=s,i=[];for(const s of t){let t,o=null;for(let i=n;!t&&i>=0;i--)e[i]&&(t=e[i][s.hose[i]],o=i);for(const e of s.atoms){let n={diaIDs:[s.oclID],delta:t?t[0]:null,atoms:[e],nbAtoms:1,level:o,statistic:t&&t.length>1?{mean:t[1],sd:t[2],min:t[3],max:t[4],nb:t[5]}:void 0};i.push(n)}}return i}const cache={};async function loadDB(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"https://www.lactame.com/lib/nmr-processing-data/20210711/carbon.js";if(cache[t])return cache[t];const e=await fetch(t),s=await e.json();return cache[t]=s,s}function checkFromPrediction(t){if(!t.atoms)throw new Error("There is not atoms");if(!t.diaIDs)throw new Error("There is not diaIDs");if(!t.nbAtoms)throw new Error("There is not nbAtoms")}async function predictCarbon(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{url:s,database:n,webserviceURL:i}=e;if(i)return fetchPrediction(t,{webserviceURL:i});if(n||(n=await loadDB(s)),!n)throw new Error("There is not a database");const o=n.length-1;let{maxSphereSize:a=o}=e;a>o&&(a=o);const{groupedDiaIDs:l,carbonDiaIDs:r,molfile:m}=getFilteredIDiaIDs(t,{maxSphereSize:a});let g=queryByHose(r,n,{maxSphereSize:a});const u=formatSignals(g),c=joinSignalByDiaID(u);return{molfile:m,nucleus:"13C",diaIDs:flatGroupedDiaIDs(l),joinedSignals:c,signals:u,ranges:signalsToRanges(c),molecule:t}}function formatSignals(t){let e=[];for(const s of t){const{atoms:t,nbAtoms:n,delta:i,diaIDs:o,statistic:a}=s,l={id:v4(),delta:i||NaN,atoms:t,diaIDs:o,multiplicity:"s",nbAtoms:n,statistic:a,js:[]};e.push(l)}return e}function joinSignalByDiaID(t){let e={};for(let s of t){checkFromPrediction(s);let t=s.diaIDs[0];e[t]?(e[t].nbAtoms+=s.nbAtoms,e[t].atoms.push(...s.atoms)):e[t]=JSON.parse(JSON.stringify(s))}return setIDs(Object.values(e))}function squaredEuclidean(t,e){let s=0;for(let n=0;n<t.length;n++)s+=(t[n]-e[n])*(t[n]-e[n]);return s}function euclidean(t,e){return Math.sqrt(squaredEuclidean(t,e))}function distanceMatrix(t,e){const s=getMatrix(t.length);for(let n=0;n<t.length;n++)for(let i=0;i<=n;i++)s[n][i]=e(t[n],t[i]),s[i][n]=s[n][i];return s}function getMatrix(t){const e=[];for(let s=0;s<t;s++){const s=[];e.push(s);for(let e=0;e<t;e++)s.push(0)}return e}var heap$1={exports:{}};!function(t,e){(function(){var e,s,n,i,o,a,l,r,m,g,u,c,C,f,h;n=Math.floor,g=Math.min,s=function(t,e){return t<e?-1:t>e?1:0},m=function(t,e,i,o,a){var l;if(null==i&&(i=0),null==a&&(a=s),i<0)throw new Error("lo must be non-negative");for(null==o&&(o=t.length);i<o;)a(e,t[l=n((i+o)/2)])<0?o=l:i=l+1;return[].splice.apply(t,[i,i-i].concat(e)),e},a=function(t,e,n){return null==n&&(n=s),t.push(e),f(t,0,t.length-1,n)},o=function(t,e){var n,i;return null==e&&(e=s),n=t.pop(),t.length?(i=t[0],t[0]=n,h(t,0,e)):i=n,i},r=function(t,e,n){var i;return null==n&&(n=s),i=t[0],t[0]=e,h(t,0,n),i},l=function(t,e,n){var i;return null==n&&(n=s),t.length&&n(t[0],e)<0&&(e=(i=[t[0],e])[0],t[0]=i[1],h(t,0,n)),e},i=function(t,e){var i,o,a,l,r,m;for(null==e&&(e=s),r=[],o=0,a=(l=function(){m=[];for(var e=0,s=n(t.length/2);0<=s?e<s:e>s;0<=s?e++:e--)m.push(e);return m}.apply(this).reverse()).length;o<a;o++)i=l[o],r.push(h(t,i,e));return r},C=function(t,e,n){var i;if(null==n&&(n=s),-1!==(i=t.indexOf(e)))return f(t,0,i,n),h(t,i,n)},u=function(t,e,n){var o,a,r,m,g;if(null==n&&(n=s),!(a=t.slice(0,e)).length)return a;for(i(a,n),r=0,m=(g=t.slice(e)).length;r<m;r++)o=g[r],l(a,o,n);return a.sort(n).reverse()},c=function(t,e,n){var a,l,r,u,c,C,f,h,p;if(null==n&&(n=s),10*e<=t.length){if(!(r=t.slice(0,e).sort(n)).length)return r;for(l=r[r.length-1],u=0,C=(f=t.slice(e)).length;u<C;u++)n(a=f[u],l)<0&&(m(r,a,0,null,n),r.pop(),l=r[r.length-1]);return r}for(i(t,n),p=[],c=0,h=g(e,t.length);0<=h?c<h:c>h;0<=h?++c:--c)p.push(o(t,n));return p},f=function(t,e,n,i){var o,a,l;for(null==i&&(i=s),o=t[n];n>e&&i(o,a=t[l=n-1>>1])<0;)t[n]=a,n=l;return t[n]=o},h=function(t,e,n){var i,o,a,l,r;for(null==n&&(n=s),o=t.length,r=e,a=t[e],i=2*e+1;i<o;)(l=i+1)<o&&!(n(t[i],t[l])<0)&&(i=l),t[e]=t[i],i=2*(e=i)+1;return t[e]=a,f(t,r,e,n)},e=function(){function t(t){this.cmp=null!=t?t:s,this.nodes=[]}return t.push=a,t.pop=o,t.replace=r,t.pushpop=l,t.heapify=i,t.updateItem=C,t.nlargest=u,t.nsmallest=c,t.prototype.push=function(t){return a(this.nodes,t,this.cmp)},t.prototype.pop=function(){return o(this.nodes,this.cmp)},t.prototype.peek=function(){return this.nodes[0]},t.prototype.contains=function(t){return-1!==this.nodes.indexOf(t)},t.prototype.replace=function(t){return r(this.nodes,t,this.cmp)},t.prototype.pushpop=function(t){return l(this.nodes,t,this.cmp)},t.prototype.heapify=function(){return i(this.nodes,this.cmp)},t.prototype.updateItem=function(t){return C(this.nodes,t,this.cmp)},t.prototype.clear=function(){return this.nodes=[]},t.prototype.empty=function(){return 0===this.nodes.length},t.prototype.size=function(){return this.nodes.length},t.prototype.clone=function(){var e;return(e=new t).nodes=this.nodes.slice(0),e},t.prototype.toArray=function(){return this.nodes.slice(0)},t.prototype.insert=t.prototype.push,t.prototype.top=t.prototype.peek,t.prototype.front=t.prototype.peek,t.prototype.has=t.prototype.contains,t.prototype.copy=t.prototype.clone,t}(),t.exports=e}).call(commonjsGlobal)}(heap$1);var heap=heap$1.exports,Heap=heap;class Cluster{constructor(){this.children=[],this.height=0,this.size=1,this.index=-1,this.isLeaf=!1}cut(t){if("number"!=typeof t)throw new TypeError("threshold must be a number");if(t<0)throw new RangeError("threshold must be a positive number");let e=[this];const s=[];for(;e.length>0;){const n=e.shift();t>=n.height?s.push(n):e=e.concat(n.children)}return s}group(t){if(!Number.isInteger(t)||t<1)throw new RangeError("groups must be a positive integer");const e=new Heap(((t,e)=>e.height-t.height));for(e.push(this);e.size()<t;){const t=e.pop();if(0===t.children.length)break;t.children.forEach((t=>e.push(t)))}const s=new Cluster;return s.children=e.toArray(),s.height=this.height,s}traverse(t){!function t(e,s){if(s(e),e.children)for(const n of e.children)t(n,s)}(this,t)}indices(){const t=[];return this.traverse((e=>{e.isLeaf&&t.push(e.index)})),t}}function singleLink(t,e){return Math.min(t,e)}function completeLink(t,e){return Math.max(t,e)}function averageLink(t,e,s,n,i){return n/(n+i)*t+i/(n+i)*e}function weightedAverageLink(t,e){return(t+e)/2}function centroidLink(t,e,s,n,i){return n/(n+i)*t+i/(n+i)*e+-n*i/(n+i)**2*s}function medianLink(t,e,s){return t/2+e/2-s/4}function wardLink(t,e,s,n,i,o){return(n+o)/(n+i+o)*t+(i+o)/(n+i+o)*e+-o/(n+i+o)*s}function wardLink2(t,e,s,n,i,o){const a=(n+o)/(n+i+o),l=(i+o)/(n+i+o),r=-o/(n+i+o);return Math.sqrt(a*t*t+l*e*e+r*s*s)}function agnes(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{distanceFunction:s=euclidean,method:n="complete",isDistanceMatrix:i=!1}=e;let o;i||(t=distanceMatrix(t,s));let a=new Matrix(t);const l=a.rows;if("string"==typeof n)switch(n.toLowerCase()){case"single":o=singleLink;break;case"complete":o=completeLink;break;case"average":case"upgma":o=averageLink;break;case"wpgma":o=weightedAverageLink;break;case"centroid":case"upgmc":o=centroidLink;break;case"median":case"wpgmc":o=medianLink;break;case"ward":o=wardLink;break;case"ward2":o=wardLink2;break;default:throw new RangeError(`unknown clustering method: ${n}`)}else if("function"!=typeof n)throw new TypeError("method must be a string or function");let r=[];for(let t=0;t<l;t++){const e=new Cluster;e.isLeaf=!0,e.index=t,r.push(e)}for(let t=0;t<l-1;t++){const[t,e,s]=getSmallestDistance(a),n=r[t],i=r[e],l=new Cluster;l.size=n.size+i.size,l.children.push(n,i),l.height=s;const m=[l],g=new Matrix(a.rows-1,a.rows-1),u=s=>getPreviousIndex(s,Math.min(t,e),Math.max(t,e));for(let l=1;l<g.rows;l++){const c=u(l),C=r[c];m.push(C);for(let r=0;r<l;r++)if(0===r){const m=o(a.get(t,c),a.get(c,e),s,n.size,i.size,C.size);g.set(l,r,m),g.set(r,l,m)}else{const t=a.get(c,u(r));g.set(l,r,t),g.set(r,l,t)}}r=m,a=g}return r[0]}function getSmallestDistance(t){let e=1/0,s=0,n=0;for(let i=1;i<t.rows;i++)for(let o=0;o<i;o++)t.get(i,o)<e&&(e=t.get(i,o),s=i,n=o);return[s,n,e]}function getPreviousIndex(t,e,s){return(t-=1)>=e&&t++,t>=s&&t++,t}const nucleusMap={h:"1H",c:"13C"};function getNuclei(t){return Object.values(t).map((t=>nucleusMap[t.toLowerCase()]))}async function getPredictions(t,e,s,n,i){let o;if(null==i?void 0:i[t])o=i[t];else if(n){const i=n[t];o=i?await i(e,s[t]):void 0}return o}function checkFromTo(t){if(!t.from||!t.to)throw new Error("options from and to are mandatory")}async function predict2D(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};checkFromTo(e);let{from:s,to:n,minLength:i=0,maxLength:o,predictOptions:a={},predictions:l,predictor:r,joinDistance:m={H:.05,C:.5},includeDiagonal:g=!1}=e;t.addImplicitHydrogens();let u=getGroupedDiastereotopicAtomIDs(t);const c=getPathsInfo(t,{fromLabel:s,toLabel:n,minLength:i,maxLength:o});let C=[];for(let t of u)C.push({...t,pathInfo:JSON.parse(JSON.stringify(c[t.atoms[0]]))});const f=await getPredictions(s,t,a,r,l),h=s===n?f:await getPredictions(n,t,a,r,l);if(!f||!h)throw new Error("predictions are not availaible");const p={x:f,y:h},d={x:{},y:{}};for(const t in d)for(const e of p[t].joinedSignals){if(!e.diaIDs)throw new Error("Signal has not diaIDs");d[t][e.diaIDs[0]]=e}let y={};for(const t of C){const e=t.pathInfo;if(e.paths.length<1)continue;if(!d.x[e.oclID])continue;const s=e.paths;for(const t of s){if(!d.y[c[t.to].oclID])continue;let s={x:e,y:c[t.to]};const n=`${s.x.oclID}-${s.y.oclID}`;if(n===`${e.oclID}-${e.oclID}`||y[n])continue;let i={id:v4(),z:100},o={id:v4(),x:{},y:{}};for(let t in s){let e=s[t].oclID;i[t]=d[t][e].delta,o[t].delta=d[t][e].delta,o[t].diaIDs=[e],o[t].atoms=d[t][e].atoms}o.peaks=[i],y[n]=o}}g&&addSelftCorrelation(y,{paths:c,signalsByDiaID:d});const H=Object.values(y),v=createZones(H,{joinDistance:m,from:s,to:n});return{molfile:t.toMolfile(),diaIDs:p.x.diaIDs,nuclei:getNuclei({from:s,to:n}),joinedSignals:H,signals:splitSignals(H),zones:v,molecule:t}}function splitSignals(t){let e=[];for(const s of t)for(const t of s.x.atoms||[])for(const n of s.y.atoms||[]){let i=JSON.parse(JSON.stringify(s));i.x.atoms=[t],i.y.atoms=[n],e.push(i)}return setIDs(e)}function addSelftCorrelation(t,e){const{paths:s=[],signalsByDiaID:n}=e;for(const e of s){if(e.paths.length<1)continue;let s=e.oclID;if(!n.x[s])continue;if(t[`${s}-${s}`])continue;let i={x:{},y:{}},o={z:1};for(let t of["x","y"])o[t]=n[t][s].delta,i[t].delta=n[t][s].delta,i[t].diaIDs=[s],i[t].atoms=n[t][s].atoms;i.peaks=[o],t[`${e.oclID}-${e.oclID}`]=i}}function createZones(t,e){const{joinDistance:s,from:n,to:i}=e,o=new Matrix(t.map((t=>[t.x.delta,t.y.delta]))),a=o.minColumn(0),l=o.maxColumn(0),r=o.minColumn(1),m=o.maxColumn(1);o.mulColumn(0,1/(l-a)),o.mulColumn(1,1/(m-r));const g=Math.sqrt(Math.pow(s[n]/(l-a),2)+Math.pow(s[i]/(m-r),2));const u=splitClusters([agnes(o.to2DArray(),{method:"centroid"})],g),c=[];for(const e of u){const o=[];e.isLeaf&&o.push(t[e.index]);for(const s of e.children)for(const e of s.indices())o.push(t[e]);c.push({id:v4(),...fromTo(o,{joinDistance:s,from:n,to:i}),signals:o})}return c}function fromTo(t,e){const{joinDistance:s,from:n,to:i}=e;let o=Number.MAX_SAFE_INTEGER,a=Number.MAX_SAFE_INTEGER,l=Number.MIN_SAFE_INTEGER,r=Number.MIN_SAFE_INTEGER;for(const e of t)e.x.delta<o&&(o=e.x.delta),e.x.delta>l&&(l=e.x.delta),e.y.delta<a&&(a=e.y.delta),e.y.delta>r&&(r=e.y.delta);return{x:{from:o-s[n],to:l+s[n]},y:{from:a-s[i],to:r+s[i]}}}function splitClusters(t,e){let s=t.length;for(let s=0;s<t.length;s++){const n=t[s];n.height>e&&(t.push(...n.children),t.splice(s--,1))}return t.length<s?splitClusters(t,e):t}async function predictCOSY(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{minLength:s=2,maxLength:n=3,predictions:i,predictor:o={H:predictProton},predictOptions:a,joinDistance:l={H:.05,C:.5},includeDiagonal:r=!0}=e;return predict2D(t,{from:"H",to:"H",predictor:o,minLength:s,maxLength:n,joinDistance:l,predictions:i,includeDiagonal:r,predictOptions:a})}async function predictHSQC(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{minLength:s=1,maxLength:n=1,predictor:i={H:predictProton,C:predictCarbon},predictions:o,joinDistance:a={H:.05,C:.5},predictOptions:l}=e;return predict2D(t,{from:"H",to:"C",predictor:i,minLength:s,maxLength:n,predictions:o,predictOptions:l,joinDistance:a})}async function predictHMBC(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{minLength:s=2,maxLength:n=3,predictor:i={H:predictProton,C:predictCarbon},predictOptions:o,predictions:a,joinDistance:l={H:.05,C:.5}}=e;return predict2D(t,{from:"H",to:"C",predictor:i,minLength:s,maxLength:n,predictions:a,predictOptions:o,joinDistance:l})}async function predictAll(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{from:s="H",to:n="C",predictor:i={H:predictProton,C:predictCarbon},predictions:o,joinDistance:a={H:.05,C:.5},predictOptions:l={}}=e;const r=await getPredictions(s,t,l,i,o),m=await getPredictions(n,t,l,i,o);if(!r||!m)throw new Error("predictions are not availaible");o={H:r,C:m};const{molfile:g,diaIDs:u}=r,c={proton:o.H,carbon:o.C};c.cosy=await predictCOSY(t,{predictions:o,joinDistance:a}),c.hsqc=await predictHSQC(t,{predictions:o,joinDistance:a}),c.hmbc=await predictHMBC(t,{predictions:o,joinDistance:a});for(const t in c)delete c[t].molfile,delete c[t].diaIDs;return{molfile:g,diaIDs:u,...c}}function signals2DToZ(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{from:s=-1,to:n=12,nbPoints:i=512,width:o=.02,factor:a=3}=e;const l=t.reduce(((t,e)=>{let{x:s,y:n}=e;return t.x.push(s.delta),t.y.push(n.delta),t.z.push(1e6),t}),{x:[],y:[],z:[]});return o=ensureXYNumber(o),generateSpectrum2D(mergeClosePeaks(l),{generator:{from:ensureXYNumber(s),to:ensureXYNumber(n),nbPoints:ensureXYNumber(i)},peaks:{width:o,factor:a}})}function ensureXYNumber(t){return"object"!=typeof t?{x:t,y:t}:{...t}}function mergeClosePeaks(t){let e=JSON.parse(JSON.stringify(t));for(let t=0;t<e.x.length;t++)for(let s=t+1;s<e.x.length;s++)e.x[t]===e.x[s]&&e.y[t]===e.y[s]&&(e.z[t]+=e.z[s],e.x.splice(s,1),e.y.splice(s,1),e.z.splice(s,1),s--);return e}const defOptions={threshold:0,out:"assignment"};var src$2=function(t,e){const s=Object.assign({},defOptions,e);var n,i;if("number"==typeof t[0])n=fullClusterGeneratorVector(t);else if("object"==typeof t[0]){for(var o=t.length,a=new Array(o*(o+1)/2),l=0,r=0;r<o;r++)for(var m=r;m<o;m++)t[r][m]>s.threshold?a[l++]=1:a[l++]=0;n=fullClusterGeneratorVector(a)}if("indexes"===s.out||"values"===s.out){var g=new Array(n.length);for(r=0;r<n.length;r++)for(g[r]=[],m=0;m<n[r].length;m++)0!=n[r][m]&&g[r].push(m);if("values"===s.out){var u=new Array(g.length);for(r=0;r<g.length;r++)for(u[r]=new Array(g[r].length),m=0;m<g[r].length;m++)for(u[r][m]=new Array(g[r].length),i=0;i<g[r].length;i++)u[r][m][i]=t[g[r][m]][g[r][i]];return u}return g}return n};function fullClusterGeneratorVector(t){var e=Math.sqrt(2*t.length+.25)-.5,s=[],n=new Array(e),i=e,o=0,a=[];for(o=e-1;o>=0;o--)n[o]=1;for(var l=-1,r=[];i>0;){if(0===r.length){for(a=new Array(e),o=0;o<e;o++)a[o]=0;for(s.push(a),l=0;0==n[l];l++);}else l=r.splice(0,1);a[l]=1,n[l]=0,i--;var m=new Array(e);for(o=0;o<e;o++){var g=Math.max(l,o),u=Math.min(l,o);m[o]=t[u*(2*e-u-1)/2+g],1==m[o]&&1==n[o]&&0==a[o]&&(r.push(o),a[o]=1)}}return s}var simpleClustering=src$2;function checkForMandatory$1(t){for(const e of t){if(!e.js)throw new Error("there is not js");if(!e.atoms)throw new Error("there is not atoms");for(const t of e.js)if(!t.atoms)throw new Error("there is not atoms")}}function signalsToSpinSystem(t){checkForMandatory$1(t);const e=t.length,s=new Array(e),n=new Array(e),i=Matrix.zeros(e,e),o={};for(let i=0;i<e;i++){n[i]=2,s[i]=t[i].delta;o[t[i].atoms[0]]=i}for(let s=0;s<e;s++){let{atoms:e,js:n}=t[s];const a=e[0];for(const t of n){let{coupling:e,atoms:s}=t;const n=s[0];i.set(o[a],o[n],e),i.set(o[n],o[a],e)}}const a=Matrix.ones(i.rows,i.rows);for(let t=0;t<i.rows;t++)for(let e=t;e<i.columns;e++)0===i.get(t,e)&&(a.set(t,e,0),a.set(e,t,0));return{clusters:simpleClustering(a.to2DArray(),{out:"indexes"}),couplingConstants:i,chemicalShifts:s,multiplicity:n,connectivity:a}}var binarySearch=function(t,e,s,n,i){var o,a;if(void 0===n)n=0;else if((n|=0)<0||n>=t.length)throw new RangeError("invalid lower bound");if(void 0===i)i=t.length-1;else if((i|=0)<n||i>=t.length)throw new RangeError("invalid upper bound");for(;n<=i;)if((a=+s(t[o=n+(i-n>>>1)],e,o,t))<0)n=o+1;else{if(!(a>0))return o;i=o-1}return~n},binarySearch$1=binarySearch,numSort={};function assertNumber(t){if("number"!=typeof t)throw new TypeError("Expected a number")}var ascending=numSort.ascending=(t,e)=>(assertNumber(t),assertNumber(e),Number.isNaN(t)?-1:Number.isNaN(e)?1:t-e);numSort.descending=(t,e)=>(assertNumber(t),assertNumber(e),Number.isNaN(t)?1:Number.isNaN(e)?-1:e-t);const largestPrime=2147483647,primeNumbers=[largestPrime,5,11,23,47,97,197,397,797,1597,3203,6421,12853,25717,51437,102877,205759,411527,823117,1646237,3292489,6584983,13169977,26339969,52679969,105359939,210719881,421439783,842879579,1685759167,433,877,1759,3527,7057,14143,28289,56591,113189,226379,452759,905551,1811107,3622219,7244441,14488931,28977863,57955739,115911563,231823147,463646329,927292699,1854585413,953,1907,3821,7643,15287,30577,61169,122347,244703,489407,978821,1957651,3915341,7830701,15661423,31322867,62645741,125291483,250582987,501165979,1002331963,2004663929,1039,2081,4177,8363,16729,33461,66923,133853,267713,535481,1070981,2141977,4283963,8567929,17135863,34271747,68543509,137087021,274174111,548348231,1096696463,31,67,137,277,557,1117,2237,4481,8963,17929,35863,71741,143483,286973,573953,1147921,2295859,4591721,9183457,18366923,36733847,73467739,146935499,293871013,587742049,1175484103,599,1201,2411,4831,9677,19373,38747,77509,155027,310081,620171,1240361,2480729,4961459,9922933,19845871,39691759,79383533,158767069,317534141,635068283,1270136683,311,631,1277,2557,5119,10243,20507,41017,82037,164089,328213,656429,1312867,2625761,5251529,10503061,21006137,42012281,84024581,168049163,336098327,672196673,1344393353,3,7,17,37,79,163,331,673,1361,2729,5471,10949,21911,43853,87719,175447,350899,701819,1403641,2807303,5614657,11229331,22458671,44917381,89834777,179669557,359339171,718678369,1437356741,43,89,179,359,719,1439,2879,5779,11579,23159,46327,92657,185323,370661,741337,1482707,2965421,5930887,11861791,23723597,47447201,94894427,189788857,379577741,759155483,1518310967,379,761,1523,3049,6101,12203,24407,48817,97649,195311,390647,781301,1562611,3125257,6250537,12501169,25002389,50004791,100009607,200019221,400038451,800076929,1600153859,13,29,59,127,257,521,1049,2099,4201,8419,16843,33703,67409,134837,269683,539389,1078787,2157587,4315183,8630387,17260781,34521589,69043189,138086407,276172823,552345671,1104691373,19,41,83,167,337,677,1361,2729,5471,10949,21911,43853,87719,175447,350899,701819,1403641,2807303,5614657,11229331,22458671,44917381,89834777,179669557,359339171,718678369,1437356741,53,107,223,449,907,1823,3659,7321,14653,29311,58631,117269,234539,469099,938207,1876417,3752839,7505681,15011389,30022781,60045577,120091177,240182359,480364727,960729461,1921458943];function nextPrime(t){let e=binarySearch$1(primeNumbers,t,ascending);return e<0&&(e=~e),primeNumbers[e]}primeNumbers.sort(ascending);const FREE=0,FULL=1,REMOVED=2,defaultInitialCapacity=150,defaultMinLoadFactor=1/6,defaultMaxLoadFactor=2/3;class HashTable{constructor(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};if(t instanceof HashTable)return this.table=t.table.slice(),this.values=t.values.slice(),this.state=t.state.slice(),this.minLoadFactor=t.minLoadFactor,this.maxLoadFactor=t.maxLoadFactor,this.distinct=t.distinct,this.freeEntries=t.freeEntries,this.lowWaterMark=t.lowWaterMark,void(this.highWaterMark=t.maxLoadFactor);const e=void 0===t.initialCapacity?defaultInitialCapacity:t.initialCapacity;if(e<0)throw new RangeError(`initial capacity must not be less than zero: ${e}`);const s=void 0===t.minLoadFactor?defaultMinLoadFactor:t.minLoadFactor,n=void 0===t.maxLoadFactor?defaultMaxLoadFactor:t.maxLoadFactor;if(s<0||s>=1)throw new RangeError(`invalid minLoadFactor: ${s}`);if(n<=0||n>=1)throw new RangeError(`invalid maxLoadFactor: ${n}`);if(s>=n)throw new RangeError(`minLoadFactor (${s}) must be smaller than maxLoadFactor (${n})`);let i=e;i=i/n|0,i=nextPrime(i),0===i&&(i=1),this.table=newArray(i),this.values=newArray(i),this.state=newArray(i),this.minLoadFactor=s,this.maxLoadFactor=i===largestPrime?1:n,this.distinct=0,this.freeEntries=i,this.lowWaterMark=0,this.highWaterMark=chooseHighWaterMark(i,this.maxLoadFactor)}clone(){return new HashTable(this)}get size(){return this.distinct}get(t){const e=this.indexOfKey(t);return e<0?0:this.values[e]}set(t,e){let s=this.indexOfInsertion(t);if(s<0)return s=-s-1,this.values[s]=e,!1;if(this.distinct>this.highWaterMark){const s=chooseGrowCapacity(this.distinct+1,this.minLoadFactor,this.maxLoadFactor);return this.rehash(s),this.set(t,e)}if(this.table[s]=t,this.values[s]=e,this.state[s]===FREE&&this.freeEntries--,this.state[s]=FULL,this.distinct++,this.freeEntries<1){const t=chooseGrowCapacity(this.distinct+1,this.minLoadFactor,this.maxLoadFactor);this.rehash(t)}return!0}remove(t,e){const s=this.indexOfKey(t);return!(s<0)&&(this.state[s]=REMOVED,this.distinct--,e||this.maybeShrinkCapacity(),!0)}delete(t,e){const s=this.indexOfKey(t);return!(s<0)&&(this.state[s]=FREE,this.distinct--,e||this.maybeShrinkCapacity(),!0)}maybeShrinkCapacity(){if(this.distinct<this.lowWaterMark){const t=chooseShrinkCapacity(this.distinct,this.minLoadFactor,this.maxLoadFactor);this.rehash(t)}}containsKey(t){return this.indexOfKey(t)>=0}indexOfKey(t){const e=this.table,s=this.state,n=this.table.length,i=2147483647&t;let o=i%n,a=i%(n-2);for(0===a&&(a=1);s[o]!==FREE&&(s[o]===REMOVED||e[o]!==t);)o-=a,o<0&&(o+=n);return s[o]===FREE?-1:o}containsValue(t){return this.indexOfValue(t)>=0}indexOfValue(t){const e=this.values,s=this.state;for(var n=0;n<s.length;n++)if(s[n]===FULL&&e[n]===t)return n;return-1}indexOfInsertion(t){const e=this.table,s=this.state,n=e.length,i=2147483647&t;let o=i%n,a=i%(n-2);for(0===a&&(a=1);s[o]===FULL&&e[o]!==t;)o-=a,o<0&&(o+=n);if(s[o]===REMOVED){const i=o;for(;s[o]!==FREE&&(s[o]===REMOVED||e[o]!==t);)o-=a,o<0&&(o+=n);s[o]===FREE&&(o=i)}return s[o]===FULL?-o-1:o}ensureCapacity(t){if(this.table.length<t){const e=nextPrime(t);this.rehash(e)}}rehash(t){const e=this.table.length;if(t<=this.distinct)throw new Error("Unexpected");const s=this.table,n=this.values,i=this.state,o=newArray(t),a=newArray(t),l=newArray(t);this.lowWaterMark=chooseLowWaterMark(t,this.minLoadFactor),this.highWaterMark=chooseHighWaterMark(t,this.maxLoadFactor),this.table=o,this.values=a,this.state=l,this.freeEntries=t-this.distinct;for(var r=0;r<e;r++)if(i[r]===FULL){var m=s[r],g=this.indexOfInsertion(m);o[g]=m,a[g]=n[r],l[g]=FULL}}forEachKey(t){for(var e=0;e<this.state.length;e++)if(this.state[e]===FULL&&!t(this.table[e]))return!1;return!0}forEachValue(t){for(var e=0;e<this.state.length;e++)if(this.state[e]===FULL&&!t(this.values[e]))return!1;return!0}forEachPair(t){for(var e=0;e<this.state.length;e++)if(this.state[e]===FULL&&!t(this.table[e],this.values[e]))return!1;return!0}}function chooseLowWaterMark(t,e){return t*e|0}function chooseHighWaterMark(t,e){return Math.min(t-2,t*e|0)}function chooseGrowCapacity(t,e,s){return nextPrime(Math.max(t+1,4*t/(3*e+s)|0))}function chooseShrinkCapacity(t,e,s){return nextPrime(Math.max(t+1,4*t/(e+3*s)|0))}function newArray(t){return Array(t).fill(0)}class SparseMatrix{constructor(t,e){let s=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};if(t instanceof SparseMatrix){const e=t;this._init(e.rows,e.columns,e.elements.clone(),e.threshold)}else if(Array.isArray(t)){const n=t;t=n.length,s=e||{},e=n[0].length,this._init(t,e,new HashTable(s),s.threshold);for(let s=0;s<t;s++)for(let t=0;t<e;t++){let i=n[s][t];this.threshold&&Math.abs(i)<this.threshold&&(i=0),0!==i&&this.elements.set(s*e+t,n[s][t])}}else this._init(t,e,new HashTable(s),s.threshold)}_init(t,e,s,n){this.rows=t,this.columns=e,this.elements=s,this.threshold=n||0}static eye(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:1,e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:t;const s=Math.min(t,e),n=new SparseMatrix(t,e,{initialCapacity:s});for(let t=0;t<s;t++)n.set(t,t,1);return n}clone(){return new SparseMatrix(this)}to2DArray(){const t=new Array(this.rows);for(let e=0;e<this.rows;e++){t[e]=new Array(this.columns);for(let s=0;s<this.columns;s++)t[e][s]=this.get(e,s)}return t}isSquare(){return this.rows===this.columns}isSymmetric(){if(!this.isSquare())return!1;let t=!0;return this.forEachNonZero(((e,s,n)=>this.get(s,e)!==n?(t=!1,!1):n)),t}bandWidth(){let t=this.columns,e=-1;return this.forEachNonZero(((s,n,i)=>{let o=s-n;return t=Math.min(t,o),e=Math.max(e,o),i})),e-t}isBanded(t){return this.bandWidth()<=t}get cardinality(){return this.elements.size}get size(){return this.rows*this.columns}get(t,e){return this.elements.get(t*this.columns+e)}set(t,e,s){return this.threshold&&Math.abs(s)<this.threshold&&(s=0),0===s?this.elements.remove(t*this.columns+e):this.elements.set(t*this.columns+e,s),this}mmul(t){this.columns!==t.rows&&console.warn("Number of columns of left matrix are not equal to number of rows of right matrix.");const e=this.rows,s=t.columns,n=new SparseMatrix(e,s);return this.forEachNonZero(((e,s,i)=>(t.forEachNonZero(((t,o,a)=>(s===t&&n.set(e,o,n.get(e,o)+i*a),a))),i))),n}kroneckerProduct(t){const e=this.rows,s=this.columns,n=t.rows,i=t.columns,o=new SparseMatrix(e*n,s*i,{initialCapacity:this.cardinality*t.cardinality});return this.forEachNonZero(((e,s,a)=>(t.forEachNonZero(((t,l,r)=>(o.set(n*e+t,i*s+l,a*r),r))),a))),o}forEachNonZero(t){return this.elements.forEachPair(((e,s)=>{const n=e/this.columns|0,i=e%this.columns;let o=t(n,i,s);return!1!==o&&(this.threshold&&Math.abs(o)<this.threshold&&(o=0),o!==s&&(0===o?this.elements.remove(e,!0):this.elements.set(e,o)),!0)})),this.elements.maybeShrinkCapacity(),this}getNonZeros(){const t=this.cardinality,e=new Array(t),s=new Array(t),n=new Array(t);let i=0;return this.forEachNonZero(((t,o,a)=>(e[i]=t,s[i]=o,n[i]=a,i++,a))),{rows:e,columns:s,values:n}}setThreshold(t){return 0!==t&&t!==this.threshold&&(this.threshold=t,this.forEachNonZero(((t,e,s)=>s))),this}transpose(){let t=new SparseMatrix(this.columns,this.rows,{initialCapacity:this.cardinality});return this.forEachNonZero(((e,s,n)=>(t.set(s,e,n),n))),t}isEmpty(){return 0===this.rows||0===this.columns}}SparseMatrix.prototype.klass="Matrix",SparseMatrix.identity=SparseMatrix.eye,SparseMatrix.prototype.tensorProduct=SparseMatrix.prototype.kroneckerProduct;let inplaceOperator="\n(function %name%(value) {\n    if (typeof value === 'number') return this.%name%S(value);\n    return this.%name%M(value);\n})\n",inplaceOperatorScalar="\n(function %name%S(value) {\n    this.forEachNonZero((i, j, v) => v %op% value);\n    return this;\n})\n",inplaceOperatorMatrix="\n(function %name%M(matrix) {\n    matrix.forEachNonZero((i, j, v) => {\n        this.set(i, j, this.get(i, j) %op% v);\n        return v;\n    });\n    return this;\n})\n",staticOperator="\n(function %name%(matrix, value) {\n    var newMatrix = new SparseMatrix(matrix);\n    return newMatrix.%name%(value);\n})\n",inplaceMethod="\n(function %name%() {\n    this.forEachNonZero((i, j, v) => %method%(v));\n    return this;\n})\n",staticMethod="\n(function %name%(matrix) {\n    var newMatrix = new SparseMatrix(matrix);\n    return newMatrix.%name%();\n})\n";const operators=[["+","add"],["-","sub","subtract"],["*","mul","multiply"],["/","div","divide"],["%","mod","modulus"],["&","and"],["|","or"],["^","xor"],["<<","leftShift"],[">>","signPropagatingRightShift"],[">>>","rightShift","zeroFillRightShift"]];for(const operator of operators)for(let i=1;i<operator.length;i++)SparseMatrix.prototype[operator[i]]=eval(fillTemplateFunction(inplaceOperator,{name:operator[i],op:operator[0]})),SparseMatrix.prototype[`${operator[i]}S`]=eval(fillTemplateFunction(inplaceOperatorScalar,{name:`${operator[i]}S`,op:operator[0]})),SparseMatrix.prototype[`${operator[i]}M`]=eval(fillTemplateFunction(inplaceOperatorMatrix,{name:`${operator[i]}M`,op:operator[0]})),SparseMatrix[operator[i]]=eval(fillTemplateFunction(staticOperator,{name:operator[i]}));let methods=[["~","not"]];["abs","acos","acosh","asin","asinh","atan","atanh","cbrt","ceil","clz32","cos","cosh","exp","expm1","floor","fround","log","log1p","log10","log2","round","sign","sin","sinh","sqrt","tan","tanh","trunc"].forEach((function(t){methods.push([`Math.${t}`,t])}));for(const method of methods)for(let i=1;i<method.length;i++)SparseMatrix.prototype[method[i]]=eval(fillTemplateFunction(inplaceMethod,{name:method[i],method:method[0]})),SparseMatrix[method[i]]=eval(fillTemplateFunction(staticMethod,{name:method[i]}));function fillTemplateFunction(t,e){for(const s in e)t=t.replace(new RegExp(`%${s}%`,"g"),e[s]);return t}function createPauli(t){const e=(t-1)/2,s=new Array(t),n=new Array(t);for(let i=0;i<t;i++)s[i]=t-1-i-e,n[i]=Math.sqrt(e*(e+1)-s[i]*(s[i]+1));const i=diag(n,1,t,t);for(let i=0;i<t;i++)n[i]=Math.sqrt(e*(e+1)-s[i]*(s[i]-1));const o=diag(n,-1,t,t);return{x:i.clone().add(o).mul(.5),y:o.clone().mul(-1).add(i).mul(-.5),z:diag(s,0,t,t),m:o,p:i}}function diag(t,e,s,n){const i=new SparseMatrix(s,n,{initialCapacity:20});for(let o=0;o<t.length;o++)o-e>=0&&o-e<s&&o<n&&i.set(o-e,o,t[o]);return i}const pauli2=createPauli(2);function getPauliMatrix(t){return 2===t?pauli2:createPauli(t)}const smallValue=.01;function simulateXYPeaks(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{lineWidth:s=1,maxClusterSize:n=8,frequency:i=400}=e;const o=t.chemicalShifts.slice();for(let t=0;t<o.length;t++)o[t]=o[t]*i;const a=t.multiplicity,l=[];for(const e of t.clusters){let r=e.map((t=>t<0?-t-1:t)),m=1,g=0,u=[],c=[];if(e.length>n){let s=0;for(;e[s++]<0;);s=e[s-1],u.push(-o[s]);for(let n=0;n<e.length;n++)if(e[n]<0){let e=t.couplingConstants.get(s,r[n])/2,i=u.length;for(let t=0;t<i;t++)u.push(u[t]+e),u[t]-=e}u.sort(((t,e)=>t-e)),g=u.length,m=1;for(let t=0;t<g;t++)c.push(1)}else{const s=getHamiltonian(o,t.couplingConstants,a,t.connectivity,r),n=s.rows,i=new EigenvalueDecomposition(s),l=i.eigenvectorMatrix,C=i.realEigenvalues,f=new SparseMatrix(n,n),h=e.length;m=0;for(let t=0;t<h;t++){const s=getPauliMatrix(a[r[t]]);let n=1;for(let e=0;e<t;e++)n*=a[r[e]];const i=SparseMatrix.eye(n);n=1;for(let e=t+1;e<h;e++)n*=a[r[e]];const o=SparseMatrix.eye(n),l=i.kroneckerProduct(s.m).kroneckerProduct(o);e[t]>=0?(f.add(l.mul(e[t]+1)),m++):f.add(l.mul(e[t]))}let p=Matrix.zeros(n,n);f.forEachNonZero(((t,e,s)=>{if(s>0)for(let s=0;s<l.columns;s++){let n=l.get(e,s);0!==n&&p.set(t,s,p.get(t,s)+n)}return s}));let d=p.clone();f.forEachNonZero(((t,e,s)=>{if(s<0)for(let s=0;s<l.columns;s++){let n=l.get(e,s);0!==n&&d.set(t,s,d.get(t,s)+n)}return s}));const y=l.transpose();p=y.mmul(p);triuTimesAbs(new SparseMatrix(p.to2DArray(),{threshold:smallValue}),smallValue),d=y.mmul(d);const H=new SparseMatrix(d.to2DArray(),{threshold:smallValue});H.forEachNonZero(((t,e,s)=>s)),triuTimesAbs(H,smallValue),H.forEachNonZero(((t,e,s)=>{let n=p.get(t,e);n=Math.min(Math.abs(n),Math.abs(s)),n*=n,g+=n;let i=C[t]-C[e],o=binarySearch$1(u,i,((t,e)=>t-e));o<0?(u.splice(-1-o,0,i),c.splice(-1-o,0,n)):c[o]+=n}))}const C=u.length;if(C>0){m/=g;const t=s/64;let e=u[0],n=c[0],o=1;for(let s=1;s<C;s++)Math.abs(u[s]-e/o)<t?(n+=c[s],e+=u[s],o++):(l.push({x:-e/o/i,y:n*m}),e=u[s],n=c[s],o=1);l.push({x:-e/o/i,y:n*m})}}return l.filter((t=>t.x<1e3))}function triuTimesAbs(t,e){t.forEachNonZero(((t,s,n)=>t>s||Math.abs(n)<=e?0:n))}function getHamiltonian(t,e,s,n,i){let o=1;for(const t of i)o*=s[t];const a=new SparseMatrix(o,o);for(let o=0;o<i.length;o++){let l=i[o];const r=getPauliMatrix(s[l]);let m,g,u=1;for(let t=0;t<o;t++)u*=s[i[t]];m=SparseMatrix.eye(u),u=1;for(let t=o+1;t<i.length;t++)u*=s[i[t]];g=SparseMatrix.eye(u);const c=t[l],C=m.kroneckerProduct(r.z).kroneckerProduct(g);a.add(C.mul(c));for(let t=0;t<i.length;t++){const o=i[t];if(1===n.get(l,o)){const n=getPauliMatrix(s[o]);let u,c,C=1;for(let e=0;e<t;e++)C*=s[i[e]];u=SparseMatrix.eye(C),C=1;for(let e=t+1;e<i.length;e++)C*=s[i[e]];c=SparseMatrix.eye(C);const f=m.kroneckerProduct(r.x).kroneckerProduct(g).mmul(u.kroneckerProduct(n.x).kroneckerProduct(c));f.add(m.kroneckerProduct(r.y).kroneckerProduct(g).mul(-1).mmul(u.kroneckerProduct(n.y).kroneckerProduct(c))),f.add(m.kroneckerProduct(r.z).kroneckerProduct(g).mmul(u.kroneckerProduct(n.z).kroneckerProduct(c))),a.add(f.mul(e.get(l,o)/2))}}}return a}function simulate1D(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{lineWidth:s=1,frequency:n=400,from:i=0,to:o=10,nbPoints:a=1024,shape:l={kind:"gaussian"}}=e,r=s/n;const m=simulateXYPeaks(t,e);return generateSpectrum(m,{generator:{from:i,to:o,nbPoints:a},peakOptions:{shape:l,width:r}})}function splitSpinSystem(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{chemicalShifts:s,couplingConstants:n,connectivity:i}=t,{frequency:o=400,maxClusterSize:a=8}=e,l=calculateBetas(s,n,o),r=agnes(l,{method:"single",isDistanceMatrix:!0}),m=[],g=s.length;splitCluster(r,m,{maxClusterSize:a,force:!1,nSpins:g,connectivity:i});let u=mergeClusters(m,a),c=u.length,C=new Array(c);for(let t=0;t<c;t++){C[t]=[];for(let e=0;e<g;e++){let s=u[t][e];0!==s&&C[t].push(s<0?-(e+1):e)}}return C}function splitCluster(t,e,s){let{maxClusterSize:n,force:i,nSpins:o,connectivity:a}=s;if(!i&&t.size<=n)e.push(getMembers(t.indices(),o));else for(let s of t.children)if(s.size<=n){let t=getMembers(s.indices(),o),i=0;for(let e=0;e<o;e++)if(1===t[e]){for(let s=0;s<o;s++)1===a.get(e,s)&&0===t[s]&&(t[s]=-1,i++);i++}i<=n?e.push(t):s.index<0?splitCluster(s,e,{maxClusterSize:n,force:!0,nSpins:o,connectivity:a}):(t[s.index]=2,e.push(t))}else splitCluster(s,e,{maxClusterSize:n,force:!1,nSpins:o,connectivity:a})}function calculateBetas(t,e,s){let n=e.rows,i=e.columns,o=Matrix.zeros(n,n);for(let a=0;a<n;a++)for(let n=a;n<i;n++){let i=e.get(a,n);if(t[a]-t[n]!=0){let e=1-Math.abs(i/((t[a]-t[n])*s));o.set(a,n,e),o.set(n,a,e)}else a!==n&&0===i&&(o.set(a,n,1),o.set(n,a,1))}return o.to2DArray()}function mergeClusters(t,e){for(let s=t.length-1;s>=0;s--){let n=t[s],i=n.length,o=0;for(;o<i&&-1!==n[o++];);if(!(o>=i))for(let o=t.length-1;o>=s+1;o--){let s=t[o],a=0,l=0;for(let t=0;t<i;t++)n[t]*s[t]==-1&&l++,0===n[t]&&0===s[t]||a++;if(l>0&&a<=e){for(let t=0;t<i;t++)1===s[t]?n[t]=1:-1===s[t]&&1!==n[t]&&(n[t]=-1);t.splice(o,1)}}}return t}function getMembers(t,e){let s=new Int16Array(e);for(let e of t)s[e]=1;return s}function checkForMandatory(t){for(const e of t){if(!e.js)throw new Error("There is not js");if(!e.atoms)throw new Error("There is not atoms");for(const t of e.js)if(!t.atoms)throw new Error("There is not atoms")}}function signalsToXY(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};checkForMandatory(t);let{frequency:s=400,shape:n={kind:"gaussian"},from:i=0,to:o=10,lineWidth:a=1,nbPoints:l=16384,maxValue:r=1e8,maxClusterSize:m=8}=e;if(0===t.length)return{x:xSequentialFill({from:i,to:o,size:l}),y:Array.from(new Float64Array(l))};let g=signalsToSpinSystem(t);g.clusters=splitSpinSystem(g,{frequency:s,maxClusterSize:m});let u=simulate1D(g,{frequency:s,from:i,to:o,nbPoints:l,lineWidth:a,shape:n});return r&&(u.y=rescale(u.y,{max:r})),u}function getFrequency(t,e){const{nucleus:s,frequency:n}=e;return checkExistence$1(t,s),n*gyromagneticRatio[t]/gyromagneticRatio[s]}function checkExistence$1(){let t=[];for(var e=arguments.length,s=new Array(e),n=0;n<e;n++)s[n]=arguments[n];for(const e of s)e in gyromagneticRatio||t.push(e);if(0!==t.length)throw new Error(`${t.join(" , ")} is not supported`)}async function predictAllSpectra(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{simulation:s={oneD:{},twoD:{}},prediction:n={}}=e,i=await predictAll(t,n),o=[],a={spectra:o,molecules:[{molfile:i.molfile}]},l={proton:{from:0,to:14},carbon:{from:0,to:200},nbPoints:65536,lineWidth:1,...s.oneD||{}},r={from:{x:l.proton.from,y:l.carbon.from},to:{x:l.proton.to,y:l.carbon.to},nbPoints:{x:1024,y:1024},...s.twoD||{}};for(const t in i)switch(t){case"carbon":case"proton":o.push(get1DSpectrum(i[t],{nbPoints:l.nbPoints,lineWidth:l.lineWidth,...l[t],experiment:t,frequency:s.frequency}));break;case"cosy":case"hsqc":case"hmbc":o.push(get2DSpectrum(i[t],{...r,experiment:t,frequency:s.frequency}))}return a}function get2DSpectrum(t,e){const{signals:s,zones:n,nuclei:i}=t,{frequency:o,experiment:a}=e,l=get2DWidth(i),r=calculateFrequency(i,o);return{data:{...signals2DToZ(s,{...e,width:l,factor:3}),noise:.01},info:{nucleus:i,originFrequency:r,baseFrequency:r,pulseSequence:a,experiment:"2d"},zones:{values:n}}}function get2DWidth(t){return t[0]===t[1]?.02:{x:.02,y:.2133}}function get1DSpectrum(t,e){const{frequency:s=400,experiment:n}=e,{signals:i,nucleus:o}=t,a=calculateFrequency(o,s),{x:l,y:r}=signalsToXY(i,{...e,frequency:a});return{data:{x:Array.from(l),re:Array.from(r),im:null},info:{nucleus:t.nucleus,dimension:1,originFrequency:a,baseFrequency:a,pulseSequence:"prediction",experiment:n,isFt:!0},ranges:{values:t.ranges}}}function calculateFrequency(t,e){return"string"==typeof t?getFrequency(t,{nucleus:"1H",frequency:e}):t[0]===t[1]?`${e},${e}`:`${e},${getFrequency(t[1],{nucleus:t[0],frequency:e})}`}class TreeSet{constructor(t){this.length=0,this.elements=[],this.compatator=t||function(t,e){return t-e}}size(){return this.elements.length}last(){return this.elements[this.length-1]}first(){return this.elements[0]}isEmpty(){return 0===this.size()}pollLast(){return this.length>0?(this.length--,this.elements.splice(this.length,1)):null}pollFirst(){return this.length>0?(this.length--,this.elements.splice(0,1)):null}add(t){let e=this.binarySearch(t);e<0&&(e=-e-1),this.elements.splice(e,0,t),this.length++}binarySearch(t){for(var e=0,s=this.elements.length-1;e<=s;){var n=e+s>>>1,i=this.elements[n],o=this.compatator(i,t);if(o<0)e=n+1;else{if(!(o>0))return n;s=n-1}}return-(e+1)}}var src$1=TreeSet,TreeSet$1=src$1;function createMapPossibleAssignments(t){const{restrictionByCS:e,predictions:s,targets:n,useIntegrationRestriction:i}=t,{tolerance:o,chemicalShiftRestriction:a}=e;let l=Math.abs(o);const r={};for(const t in s){let e=s[t];if(e.error&&(e.error=Math.abs(e.error)),r[t]=[],n)for(const s in n){let o=n[s];const{nbAtoms:m}=e,{integration:g}=o;if(!i||(!(g>0)||m-g<1))if(a&&void 0!==e.delta){let n=l;e.error&&(n=Math.max(n,e.error));const i=o.signals&&o.signals.length>0?o.signals[0].delta:(o.to+o.from)/2;Math.abs(e.delta-i-l)<4*l&&r[t].push(s)}else r[t].push(s)}r[t].push("*")}return r}function partialScore$1(t,e){const{useIntegrationRestriction:s,diaIDPeerPossibleAssignment:n,nbAllowedUnAssigned:i,restrictionByCS:o,predictions:a,targets:l}=e,{useChemicalShiftScore:r}=o;let m=0,g=t.length,u={};for(let e=0;e<t.length;e++){const s=t[e];s&&"*"!==s&&(u[s]||(u[s]=[]),u[s].push(n[e])),"*"===s&&m++}if(m>i)return 0;const c=Object.keys(u);if(0===c.length)return 0;if(s)for(let t of c){let e=u[t],s=0;for(const t of e){s+=a[t].allHydrogens}const{integration:n}=l[t];if(s-n>=.5)return 0}return(r?chemicalShiftScoring(t,e):1)-m/g}function chemicalShiftScoring(t,e){const{tolerance:s}=e.restrictionByCS,{diaIDPeerPossibleAssignment:n,predictions:i,targets:o}=e;let a=0,l=0;for(let e=0;e<t.length;e++){const r=t[e];if(r&&"*"!==r){l++;let t=i[n[e]],m=o[r],g=s;if(t.error&&(g=Math.max(t.error,s)),void 0===t.delta)a+=1;else{const e=m.signals&&m.signals.length>0?m.signals[0].delta:(m.to+m.from)/2;let s=Math.abs(t.delta-e);s<g?a+=1:(s=Math.abs(s-g),a+=-.25/g*s+1)}}}return l>0&&(a/=l),a}function exploreTreeRec(t,e,s,n){const{nSources:i,restrictionByCS:o,timeout:a,timeStart:l,maxSolutions:r,targets:m,predictions:g,lowerBoundScore:u,nbAllowedUnAssigned:c,possibleAssignmentMap:C,useIntegrationRestriction:f,diaIDPeerPossibleAssignment:h}=t;if((new Date).getTime()-l>a)return n;const p=C[h[e]];for(let t of p){s[e]=t;let p=partialScore$1(s,{useIntegrationRestriction:f,diaIDPeerPossibleAssignment:h,nbAllowedUnAssigned:c,restrictionByCS:o,predictions:g,targets:m});0!==p?e===i-1&&p>=u?addSolution$1(n,{predictions:g,partial:s,score:p,maxSolutions:r}):e<i-1&&exploreTreeRec({nSources:i,restrictionByCS:o,timeout:a,timeStart:l,maxSolutions:r,targets:m,predictions:g,lowerBoundScore:u,nbAllowedUnAssigned:c,possibleAssignmentMap:C,useIntegrationRestriction:f,diaIDPeerPossibleAssignment:h},e+1,JSON.parse(JSON.stringify(s)),n):"*"===t&&(s[e]=null)}}function addSolution$1(t,e){let{score:s,maxSolutions:n,partial:i,predictions:o}=e;s/=doubleAssignmentPenalty$1(i,o),t.nSolutions++;let a={assignment:JSON.parse(JSON.stringify(i)),score:s};t.nSolutions>=n?a.score>t.solutions.last().score&&(t.solutions.pollLast(),t.solutions.add(a)):(t.solutions.add(a),t.nSolutions++)}function doubleAssignmentPenalty$1(t,e){let s=Object.keys(e).length-new Set(t).size;return s>0?2*s:1}const comparator$1=(t,e)=>e.score-t.score;async function buildAssignments$1(t){const{restrictionByCS:e={},useIntegrationRestriction:s,timeout:n,minScore:i,nbAllowedUnAssigned:o,maxSolutions:a,targets:l,joinedSignals:r}=t,{tolerance:m=1,useChemicalShiftScore:g=!1,chemicalShiftRestriction:u=!0}=e;let c=(new Date).getTime(),C={solutions:new TreeSet$1(comparator$1),nSolutions:0},f=r.length;const h={};for(let t of r){const e=t.diaIDs[0],s=t.atoms[0];h[e]={...t,diaIDIndex:s,allHydrogens:t.nbAtoms}}const p=createMapPossibleAssignments({restrictionByCS:{tolerance:m,useChemicalShiftScore:g,chemicalShiftRestriction:u},useIntegrationRestriction:s,predictions:h,targets:l}),d=Object.keys(p);let y=fillPartial$1(f);C={solutions:new TreeSet$1(comparator$1),nSolutions:0},exploreTreeRec({nSources:f,restrictionByCS:{tolerance:m,useChemicalShiftScore:g,chemicalShiftRestriction:u},timeout:n,timeStart:c,targets:l,predictions:h,maxSolutions:a,lowerBoundScore:i,nbAllowedUnAssigned:o,possibleAssignmentMap:p,diaIDPeerPossibleAssignment:d,useIntegrationRestriction:s},0,y,C);const H=[];for(const t of C.solutions.elements){const{assignment:e,score:s}=t,n=JSON.parse(JSON.stringify(l));for(let t=0;t<e.length;t++){let s=n[e[t]];s.diaIDs||(s.diaIDs=[]),e[t]&&s.diaIDs.push(d[t])}H.push({score:s,assignment:Object.values(n)})}return H}function fillPartial$1(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;const s=new Array(t);for(let n=0;n<t;n++)s[n]=e;return s}function checkAtomsAndDiaIDs$1(t){for(const e of t){if(!e.atoms)throw new Error("signal has not atoms property");if(!e.diaIDs)throw new Error("signal has not diaIDs property");if(!e.nbAtoms)throw new Error("signal has not nbAtoms property")}}function checkForIntegration(t){for(let e of t)if(void 0===e.integration)throw new Error("ranges has not integration property")}async function get1HAssignments(t,e){let s=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},{restrictionByCS:n,minScore:i=1,maxSolutions:o=10,nbAllowedUnAssigned:a=0,timeout:l=6e3,predictionOptions:r={}}=s;if(!e)throw new Error("It is needed a OCL molecule instance to assign");e.addImplicitHydrogens(),addDiastereotopicMissingChirality(e);const{joinedSignals:m}=await predictProton(e,r);checkForIntegration(t),checkAtomsAndDiaIDs$1(m);const g={};for(const e of t){const{id:t=v4()}=e;g[t]=JSON.parse(JSON.stringify(e))}return buildAssignments$1({restrictionByCS:n,timeout:l,minScore:i,nbAllowedUnAssigned:a,maxSolutions:o,targets:g,joinedSignals:m,useIntegrationRestriction:!0})}function checkAtomsAndDiaIDs(t){for(const e of t){if(!e.atoms)throw new Error("signal has not atoms property");if(!e.diaIDs)throw new Error("signal has not diaIDs property");if(!e.nbAtoms)throw new Error("signal has not nbAtoms property")}}function checkIntegration(t){for(let e of t)void 0===e.integration&&(e.integration=0);return t}async function get13CAssignments(t,e){let s=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},{restrictionByCS:n={},minScore:i=1,maxSolutions:o=10,nbAllowedUnAssigned:a=0,timeout:l=6e3,predictionOptions:r={}}=s;if(!e)throw new Error("It is needed a OCL molecule instance to assign");addDiastereotopicMissingChirality(e);const{joinedSignals:m}=await predictCarbon(e,r);checkAtomsAndDiaIDs(m);const g=checkIntegration(t),u={};for(const t of g){const{id:e=v4()}=t;u[e]=JSON.parse(JSON.stringify(t))}return buildAssignments$1({restrictionByCS:n,timeout:l,minScore:i,nbAllowedUnAssigned:a,maxSolutions:o,targets:u,joinedSignals:m,useIntegrationRestriction:!1})}function getAtomCounts(t){const e=t?t.match(/[A-Z][a-z]{0,1}/g):[],s={};return e&&e.forEach((e=>{const n=new RegExp(`(${e}\\d+)`,"g").exec(t);let i=1;n&&(i=Number(n[0].split(e)[1])),s[e]=i})),s}function getCorrelationIndex(t,e){return t.findIndex((t=>t.id===e.id))}function getCorrelationsByAtomType(t,e){return t?t.filter((t=>t.atomType===e)):[]}function buildState(t,e){const s={},n=getAtomCounts(e);return t.reduce(((t,e)=>t.includes(e.atomType)?t:t.concat(e.atomType)),[]).forEach((e=>{const i=getCorrelationsByAtomType(t,e);if(i.some((t=>!t.pseudo))){const o={},a=n[e];let l=i.reduce(((t,e)=>e.pseudo?t:t+e.equivalence),0);if("H"===e){t.forEach((t=>{t.pseudo&&"H"!==t.atomType&&1===t.protonsCount.length&&!t.link.some((t=>"hsqc"===t.experimentType))&&(l+=t.protonsCount[0])}));const e=i.reduce(((t,e)=>e.pseudo?t+1:t),0),s=i.reduce(((e,s)=>0===Object.keys(s.attachment).length?e.concat(getCorrelationIndex(t,s)):e),[]);s.length>0&&(o.notAttached=s),l-=s.length-e,l<0&&(l=0);const n=i.reduce(((e,s)=>Object.keys(s.attachment).length>1||Object.keys(s.attachment).some((t=>s.attachment[t].length>1))?e.concat(getCorrelationIndex(t,s)):e),[]);n.length>0&&(o.ambiguousAttachment=n)}if(void 0!==a){i.some(((t,s)=>!t.pseudo&&t.atomType===e&&s>=a))&&(o.outOfLimit=!0)}const r=void 0===a?void 0:l===a;!1===r&&(o.incomplete=!0),s[e]={current:l,total:a,complete:r,error:o}}})),s}var isArray$7=Array.isArray,isArray_1=isArray$7,freeGlobal$1="object"==typeof commonjsGlobal&&commonjsGlobal&&commonjsGlobal.Object===Object&&commonjsGlobal,_freeGlobal=freeGlobal$1,freeGlobal=_freeGlobal,freeSelf="object"==typeof self&&self&&self.Object===Object&&self,root$8=freeGlobal||freeSelf||Function("return this")(),_root=root$8,root$7=_root,Symbol$6=root$7.Symbol,_Symbol=Symbol$6,Symbol$5=_Symbol,objectProto$e=Object.prototype,hasOwnProperty$b=objectProto$e.hasOwnProperty,nativeObjectToString$1=objectProto$e.toString,symToStringTag$1=Symbol$5?Symbol$5.toStringTag:void 0;function getRawTag$1(t){var e=hasOwnProperty$b.call(t,symToStringTag$1),s=t[symToStringTag$1];try{t[symToStringTag$1]=void 0;var n=!0}catch(t){}var i=nativeObjectToString$1.call(t);return n&&(e?t[symToStringTag$1]=s:delete t[symToStringTag$1]),i}var _getRawTag=getRawTag$1,objectProto$d=Object.prototype,nativeObjectToString=objectProto$d.toString;function objectToString$1(t){return nativeObjectToString.call(t)}var _objectToString=objectToString$1,Symbol$4=_Symbol,getRawTag=_getRawTag,objectToString=_objectToString,nullTag="[object Null]",undefinedTag="[object Undefined]",symToStringTag=Symbol$4?Symbol$4.toStringTag:void 0;function baseGetTag$5(t){return null==t?void 0===t?undefinedTag:nullTag:symToStringTag&&symToStringTag in Object(t)?getRawTag(t):objectToString(t)}var _baseGetTag=baseGetTag$5;function isObjectLike$7(t){return null!=t&&"object"==typeof t}var isObjectLike_1=isObjectLike$7,baseGetTag$4=_baseGetTag,isObjectLike$6=isObjectLike_1,symbolTag$3="[object Symbol]";function isSymbol$3(t){return"symbol"==typeof t||isObjectLike$6(t)&&baseGetTag$4(t)==symbolTag$3}var isSymbol_1=isSymbol$3,isArray$6=isArray_1,isSymbol$2=isSymbol_1,reIsDeepProp=/\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,reIsPlainProp=/^\w*$/;function isKey$1(t,e){if(isArray$6(t))return!1;var s=typeof t;return!("number"!=s&&"symbol"!=s&&"boolean"!=s&&null!=t&&!isSymbol$2(t))||(reIsPlainProp.test(t)||!reIsDeepProp.test(t)||null!=e&&t in Object(e))}var _isKey=isKey$1;function isObject$5(t){var e=typeof t;return null!=t&&("object"==e||"function"==e)}var isObject_1=isObject$5,baseGetTag$3=_baseGetTag,isObject$4=isObject_1,asyncTag="[object AsyncFunction]",funcTag$2="[object Function]",genTag$1="[object GeneratorFunction]",proxyTag="[object Proxy]";function isFunction$2(t){if(!isObject$4(t))return!1;var e=baseGetTag$3(t);return e==funcTag$2||e==genTag$1||e==asyncTag||e==proxyTag}var isFunction_1=isFunction$2,root$6=_root,coreJsData$1=root$6["__core-js_shared__"],_coreJsData=coreJsData$1,coreJsData=_coreJsData,maskSrcKey=(uid=/[^.]+$/.exec(coreJsData&&coreJsData.keys&&coreJsData.keys.IE_PROTO||""),uid?"Symbol(src)_1."+uid:""),uid;function isMasked$1(t){return!!maskSrcKey&&maskSrcKey in t}var _isMasked=isMasked$1,funcProto$1=Function.prototype,funcToString$1=funcProto$1.toString;function toSource$2(t){if(null!=t){try{return funcToString$1.call(t)}catch(t){}try{return t+""}catch(t){}}return""}var _toSource=toSource$2,isFunction$1=isFunction_1,isMasked=_isMasked,isObject$3=isObject_1,toSource$1=_toSource,reRegExpChar=/[\\^$.*+?()[\]{}|]/g,reIsHostCtor=/^\[object .+?Constructor\]$/,funcProto=Function.prototype,objectProto$c=Object.prototype,funcToString=funcProto.toString,hasOwnProperty$a=objectProto$c.hasOwnProperty,reIsNative=RegExp("^"+funcToString.call(hasOwnProperty$a).replace(reRegExpChar,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$");function baseIsNative$1(t){return!(!isObject$3(t)||isMasked(t))&&(isFunction$1(t)?reIsNative:reIsHostCtor).test(toSource$1(t))}var _baseIsNative=baseIsNative$1;function getValue$1(t,e){return null==t?void 0:t[e]}var _getValue=getValue$1,baseIsNative=_baseIsNative,getValue=_getValue;function getNative$7(t,e){var s=getValue(t,e);return baseIsNative(s)?s:void 0}var _getNative=getNative$7,getNative$6=_getNative,nativeCreate$4=getNative$6(Object,"create"),_nativeCreate=nativeCreate$4,nativeCreate$3=_nativeCreate;function hashClear$1(){this.__data__=nativeCreate$3?nativeCreate$3(null):{},this.size=0}var _hashClear=hashClear$1;function hashDelete$1(t){var e=this.has(t)&&delete this.__data__[t];return this.size-=e?1:0,e}var _hashDelete=hashDelete$1,nativeCreate$2=_nativeCreate,HASH_UNDEFINED$2="__lodash_hash_undefined__",objectProto$b=Object.prototype,hasOwnProperty$9=objectProto$b.hasOwnProperty;function hashGet$1(t){var e=this.__data__;if(nativeCreate$2){var s=e[t];return s===HASH_UNDEFINED$2?void 0:s}return hasOwnProperty$9.call(e,t)?e[t]:void 0}var _hashGet=hashGet$1,nativeCreate$1=_nativeCreate,objectProto$a=Object.prototype,hasOwnProperty$8=objectProto$a.hasOwnProperty;function hashHas$1(t){var e=this.__data__;return nativeCreate$1?void 0!==e[t]:hasOwnProperty$8.call(e,t)}var _hashHas=hashHas$1,nativeCreate=_nativeCreate,HASH_UNDEFINED$1="__lodash_hash_undefined__";function hashSet$1(t,e){var s=this.__data__;return this.size+=this.has(t)?0:1,s[t]=nativeCreate&&void 0===e?HASH_UNDEFINED$1:e,this}var _hashSet=hashSet$1,hashClear=_hashClear,hashDelete=_hashDelete,hashGet=_hashGet,hashHas=_hashHas,hashSet=_hashSet;function Hash$1(t){var e=-1,s=null==t?0:t.length;for(this.clear();++e<s;){var n=t[e];this.set(n[0],n[1])}}Hash$1.prototype.clear=hashClear,Hash$1.prototype.delete=hashDelete,Hash$1.prototype.get=hashGet,Hash$1.prototype.has=hashHas,Hash$1.prototype.set=hashSet;var _Hash=Hash$1;function listCacheClear$1(){this.__data__=[],this.size=0}var _listCacheClear=listCacheClear$1;function eq$3(t,e){return t===e||t!=t&&e!=e}var eq_1=eq$3,eq$2=eq_1;function assocIndexOf$4(t,e){for(var s=t.length;s--;)if(eq$2(t[s][0],e))return s;return-1}var _assocIndexOf=assocIndexOf$4,assocIndexOf$3=_assocIndexOf,arrayProto=Array.prototype,splice=arrayProto.splice;function listCacheDelete$1(t){var e=this.__data__,s=assocIndexOf$3(e,t);return!(s<0)&&(s==e.length-1?e.pop():splice.call(e,s,1),--this.size,!0)}var _listCacheDelete=listCacheDelete$1,assocIndexOf$2=_assocIndexOf;function listCacheGet$1(t){var e=this.__data__,s=assocIndexOf$2(e,t);return s<0?void 0:e[s][1]}var _listCacheGet=listCacheGet$1,assocIndexOf$1=_assocIndexOf;function listCacheHas$1(t){return assocIndexOf$1(this.__data__,t)>-1}var _listCacheHas=listCacheHas$1,assocIndexOf=_assocIndexOf;function listCacheSet$1(t,e){var s=this.__data__,n=assocIndexOf(s,t);return n<0?(++this.size,s.push([t,e])):s[n][1]=e,this}var _listCacheSet=listCacheSet$1,listCacheClear=_listCacheClear,listCacheDelete=_listCacheDelete,listCacheGet=_listCacheGet,listCacheHas=_listCacheHas,listCacheSet=_listCacheSet;function ListCache$4(t){var e=-1,s=null==t?0:t.length;for(this.clear();++e<s;){var n=t[e];this.set(n[0],n[1])}}ListCache$4.prototype.clear=listCacheClear,ListCache$4.prototype.delete=listCacheDelete,ListCache$4.prototype.get=listCacheGet,ListCache$4.prototype.has=listCacheHas,ListCache$4.prototype.set=listCacheSet;var _ListCache=ListCache$4,getNative$5=_getNative,root$5=_root,Map$4=getNative$5(root$5,"Map"),_Map=Map$4,Hash=_Hash,ListCache$3=_ListCache,Map$3=_Map;function mapCacheClear$1(){this.size=0,this.__data__={hash:new Hash,map:new(Map$3||ListCache$3),string:new Hash}}var _mapCacheClear=mapCacheClear$1;function isKeyable$1(t){var e=typeof t;return"string"==e||"number"==e||"symbol"==e||"boolean"==e?"__proto__"!==t:null===t}var _isKeyable=isKeyable$1,isKeyable=_isKeyable;function getMapData$4(t,e){var s=t.__data__;return isKeyable(e)?s["string"==typeof e?"string":"hash"]:s.map}var _getMapData=getMapData$4,getMapData$3=_getMapData;function mapCacheDelete$1(t){var e=getMapData$3(this,t).delete(t);return this.size-=e?1:0,e}var _mapCacheDelete=mapCacheDelete$1,getMapData$2=_getMapData;function mapCacheGet$1(t){return getMapData$2(this,t).get(t)}var _mapCacheGet=mapCacheGet$1,getMapData$1=_getMapData;function mapCacheHas$1(t){return getMapData$1(this,t).has(t)}var _mapCacheHas=mapCacheHas$1,getMapData=_getMapData;function mapCacheSet$1(t,e){var s=getMapData(this,t),n=s.size;return s.set(t,e),this.size+=s.size==n?0:1,this}var _mapCacheSet=mapCacheSet$1,mapCacheClear=_mapCacheClear,mapCacheDelete=_mapCacheDelete,mapCacheGet=_mapCacheGet,mapCacheHas=_mapCacheHas,mapCacheSet=_mapCacheSet;function MapCache$3(t){var e=-1,s=null==t?0:t.length;for(this.clear();++e<s;){var n=t[e];this.set(n[0],n[1])}}MapCache$3.prototype.clear=mapCacheClear,MapCache$3.prototype.delete=mapCacheDelete,MapCache$3.prototype.get=mapCacheGet,MapCache$3.prototype.has=mapCacheHas,MapCache$3.prototype.set=mapCacheSet;var _MapCache=MapCache$3,MapCache$2=_MapCache,FUNC_ERROR_TEXT="Expected a function";function memoize$1(t,e){if("function"!=typeof t||null!=e&&"function"!=typeof e)throw new TypeError(FUNC_ERROR_TEXT);var s=function(){var n=arguments,i=e?e.apply(this,n):n[0],o=s.cache;if(o.has(i))return o.get(i);var a=t.apply(this,n);return s.cache=o.set(i,a)||o,a};return s.cache=new(memoize$1.Cache||MapCache$2),s}memoize$1.Cache=MapCache$2;var memoize_1=memoize$1,memoize=memoize_1,MAX_MEMOIZE_SIZE=500;function memoizeCapped$1(t){var e=memoize(t,(function(t){return s.size===MAX_MEMOIZE_SIZE&&s.clear(),t})),s=e.cache;return e}var _memoizeCapped=memoizeCapped$1,memoizeCapped=_memoizeCapped,rePropName=/[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g,reEscapeChar=/\\(\\)?/g,stringToPath$1=memoizeCapped((function(t){var e=[];return 46===t.charCodeAt(0)&&e.push(""),t.replace(rePropName,(function(t,s,n,i){e.push(n?i.replace(reEscapeChar,"$1"):s||t)})),e})),_stringToPath=stringToPath$1;function arrayMap$1(t,e){for(var s=-1,n=null==t?0:t.length,i=Array(n);++s<n;)i[s]=e(t[s],s,t);return i}var _arrayMap=arrayMap$1,Symbol$3=_Symbol,arrayMap=_arrayMap,isArray$5=isArray_1,isSymbol$1=isSymbol_1,INFINITY$1=1/0,symbolProto$2=Symbol$3?Symbol$3.prototype:void 0,symbolToString=symbolProto$2?symbolProto$2.toString:void 0;function baseToString$1(t){if("string"==typeof t)return t;if(isArray$5(t))return arrayMap(t,baseToString$1)+"";if(isSymbol$1(t))return symbolToString?symbolToString.call(t):"";var e=t+"";return"0"==e&&1/t==-INFINITY$1?"-0":e}var _baseToString=baseToString$1,baseToString=_baseToString;function toString$1(t){return null==t?"":baseToString(t)}var toString_1=toString$1,isArray$4=isArray_1,isKey=_isKey,stringToPath=_stringToPath,toString=toString_1;function castPath$1(t,e){return isArray$4(t)?t:isKey(t,e)?[t]:stringToPath(toString(t))}var _castPath=castPath$1,isSymbol=isSymbol_1,INFINITY=1/0;function toKey$1(t){if("string"==typeof t||isSymbol(t))return t;var e=t+"";return"0"==e&&1/t==-INFINITY?"-0":e}var _toKey=toKey$1,castPath=_castPath,toKey=_toKey;function baseGet$1(t,e){for(var s=0,n=(e=castPath(e,t)).length;null!=t&&s<n;)t=t[toKey(e[s++])];return s&&s==n?t:void 0}var _baseGet=baseGet$1,baseGet=_baseGet;function get(t,e,s){var n=null==t?void 0:baseGet(t,e);return void 0===n?s:n}var get_1=get,lodashGet=get_1;function checkMatch(t,e,s){return t-s<=e&&e<=t+s}function getLinkDim(t){return"1d"===t.experimentType?1:2}function getLinkDelta(t){if(!t.pseudo)return 1===getLinkDim(t)?t.signal.delta:"x"===t.axis?t.signal.x.delta:t.signal.y.delta}function getCorrelationDelta(t){if(t.link.length>0)return getLinkDelta(t.link[0])}function setProtonsCount(t,e,s,n){for(let i=0;i<t.length;i++){const o=t[i];if(o.edited.protonsCount)continue;const a=getCorrelationDelta(o),l=[-1,-1];for(let t=0;t<e.length;t++)if(void 0!==a&&checkMatch(a,e[t].delta,n)){l[0]=t;break}for(let t=0;t<s.length;t++)if(void 0!==a&&checkMatch(a,s[t].delta,n)){l[1]=t;break}l[0]>=0?o.protonsCount=[1]:l[1]>=0?1===s[l[1]].sign?e.length>0?o.protonsCount=[3]:o.protonsCount=[1,3]:o.protonsCount=[2]:s.length>0?o.protonsCount=[0]:o.protonsCount=[]}return t}function setProtonsCountFromDEPT(t,e,s,n){return setProtonsCount(getCorrelationsByAtomType(t,n).filter((t=>!t.pseudo)),lodashGet(e,"90",[]).filter((t=>t.atomType===n)).map((t=>t.signal)),lodashGet(e,"135",[]).filter((t=>t.atomType===n)).map((t=>t.signal)),s[n]),t}function setProtonsCountFromEditedHSQC(t,e,s,n){return setProtonsCount(t.filter((t=>!t.pseudo&&t.atomType===n)),[],lodashGet(e,"hsqc",[]).filter((t=>t.atomType[1]===n&&0!==t.signal.sign)).map((t=>({delta:t.signal.y.delta,sign:t.signal.sign}))),s[n]),t}function setProtonsCountFromData(t,e,s,n){const i=[];return t.forEach((o=>{o.pseudo||"H"===o.atomType||i.includes(o.atomType)||(i.push(o.atomType),Object.keys(e).length>0?setProtonsCountFromDEPT(t,e,n,o.atomType):setProtonsCountFromEditedHSQC(t,s,n,o.atomType))})),t}function getExperiments(t){if(!t)return{};const e={};for(const s of t){if(s.info.isFid)continue;e[`${s.info.dimension}D`]||(e[`${s.info.dimension}D`]={});const t=s.info.experiment;e[`${s.info.dimension}D`][`${t}`]||(e[`${s.info.dimension}D`][`${t}`]=[]),e[`${s.info.dimension}D`][`${t}`].push(s)}return e}function getAtomTypeFromNucleus(t){return t.length>0?t.split(/\d+/)[1]:""}function addToExperiments(t,e,s,n,i){const o=lodashGet(t,`${s}`,[]).filter((t=>{const e=lodashGet(t,s.includes("1D")?"ranges.values":"zones.values",[]).length>0;return n?getAtomTypeFromNucleus(t.info.nucleus)===i&&e:e}));o.length>0&&(e[i]=o)}function getExperiments1D(t){const e={};return lodashGet(t,"1D.1d",[]).map((t=>getAtomTypeFromNucleus(t.info.nucleus))).forEach((s=>{addToExperiments(t,e,"1D.1d",!0,s)})),e}function getExperiments1DExtra(t){const e={};return Object.keys(lodashGet(t,"1D",{})).filter((t=>"1d"!==t)).forEach((s=>{addToExperiments(t,e,`1D.${s}`,!1,s)})),e}function getExperiments2D(t){const e={};return Object.keys(lodashGet(t,"2D",{})).forEach((s=>{addToExperiments(t,e,`2D.${s}`,!1,s)})),e}const allowedSignalKinds=["signal"];function getSignals1D(t){const e={};for(const s in t){const n=[],i=t[`${s}`]||[];if(0===i.length)continue;const o=i[0];for(const t of o.ranges.values)for(const e of t.signals)e.kind&&allowedSignalKinds.includes(e.kind)&&(checkExistence(e,n)||n.push({experimentType:"1d",experimentID:o.id,integration:e.integration?e.integration:t.integration,atomType:s,signal:{...e}}));e[s]=n}return e}function checkExistence(t,e){for(const s of e)if(checkMatch(s.signal.delta,t.delta,0))return!0;return!1}var ListCache$2=_ListCache;function stackClear$1(){this.__data__=new ListCache$2,this.size=0}var _stackClear=stackClear$1;function stackDelete$1(t){var e=this.__data__,s=e.delete(t);return this.size=e.size,s}var _stackDelete=stackDelete$1;function stackGet$1(t){return this.__data__.get(t)}var _stackGet=stackGet$1;function stackHas$1(t){return this.__data__.has(t)}var _stackHas=stackHas$1,ListCache$1=_ListCache,Map$2=_Map,MapCache$1=_MapCache,LARGE_ARRAY_SIZE=200;function stackSet$1(t,e){var s=this.__data__;if(s instanceof ListCache$1){var n=s.__data__;if(!Map$2||n.length<LARGE_ARRAY_SIZE-1)return n.push([t,e]),this.size=++s.size,this;s=this.__data__=new MapCache$1(n)}return s.set(t,e),this.size=s.size,this}var _stackSet=stackSet$1,ListCache=_ListCache,stackClear=_stackClear,stackDelete=_stackDelete,stackGet=_stackGet,stackHas=_stackHas,stackSet=_stackSet;function Stack$2(t){var e=this.__data__=new ListCache(t);this.size=e.size}Stack$2.prototype.clear=stackClear,Stack$2.prototype.delete=stackDelete,Stack$2.prototype.get=stackGet,Stack$2.prototype.has=stackHas,Stack$2.prototype.set=stackSet;var _Stack=Stack$2;function arrayEach$1(t,e){for(var s=-1,n=null==t?0:t.length;++s<n&&!1!==e(t[s],s,t););return t}var _arrayEach=arrayEach$1,getNative$4=_getNative,defineProperty$1=function(){try{var t=getNative$4(Object,"defineProperty");return t({},"",{}),t}catch(t){}}(),_defineProperty=defineProperty$1,defineProperty=_defineProperty;function baseAssignValue$2(t,e,s){"__proto__"==e&&defineProperty?defineProperty(t,e,{configurable:!0,enumerable:!0,value:s,writable:!0}):t[e]=s}var _baseAssignValue=baseAssignValue$2,baseAssignValue$1=_baseAssignValue,eq$1=eq_1,objectProto$9=Object.prototype,hasOwnProperty$7=objectProto$9.hasOwnProperty;function assignValue$2(t,e,s){var n=t[e];hasOwnProperty$7.call(t,e)&&eq$1(n,s)&&(void 0!==s||e in t)||baseAssignValue$1(t,e,s)}var _assignValue=assignValue$2,assignValue$1=_assignValue,baseAssignValue=_baseAssignValue;function copyObject$4(t,e,s,n){var i=!s;s||(s={});for(var o=-1,a=e.length;++o<a;){var l=e[o],r=n?n(s[l],t[l],l,s,t):void 0;void 0===r&&(r=t[l]),i?baseAssignValue(s,l,r):assignValue$1(s,l,r)}return s}var _copyObject=copyObject$4;function baseTimes$1(t,e){for(var s=-1,n=Array(t);++s<t;)n[s]=e(s);return n}var _baseTimes=baseTimes$1,baseGetTag$2=_baseGetTag,isObjectLike$5=isObjectLike_1,argsTag$3="[object Arguments]";function baseIsArguments$1(t){return isObjectLike$5(t)&&baseGetTag$2(t)==argsTag$3}var _baseIsArguments=baseIsArguments$1,baseIsArguments=_baseIsArguments,isObjectLike$4=isObjectLike_1,objectProto$8=Object.prototype,hasOwnProperty$6=objectProto$8.hasOwnProperty,propertyIsEnumerable$1=objectProto$8.propertyIsEnumerable,isArguments$1=baseIsArguments(function(){return arguments}())?baseIsArguments:function(t){return isObjectLike$4(t)&&hasOwnProperty$6.call(t,"callee")&&!propertyIsEnumerable$1.call(t,"callee")},isArguments_1=isArguments$1,isBuffer$3={exports:{}};function stubFalse(){return!1}var stubFalse_1=stubFalse;!function(t,e){var s=_root,n=stubFalse_1,i=e&&!e.nodeType&&e,o=i&&t&&!t.nodeType&&t,a=o&&o.exports===i?s.Buffer:void 0,l=(a?a.isBuffer:void 0)||n;t.exports=l}(isBuffer$3,isBuffer$3.exports);var MAX_SAFE_INTEGER$1=9007199254740991,reIsUint=/^(?:0|[1-9]\d*)$/;function isIndex$1(t,e){var s=typeof t;return!!(e=null==e?MAX_SAFE_INTEGER$1:e)&&("number"==s||"symbol"!=s&&reIsUint.test(t))&&t>-1&&t%1==0&&t<e}var _isIndex=isIndex$1,MAX_SAFE_INTEGER=9007199254740991;function isLength$2(t){return"number"==typeof t&&t>-1&&t%1==0&&t<=MAX_SAFE_INTEGER}var isLength_1=isLength$2,baseGetTag$1=_baseGetTag,isLength$1=isLength_1,isObjectLike$3=isObjectLike_1,argsTag$2="[object Arguments]",arrayTag$2="[object Array]",boolTag$3="[object Boolean]",dateTag$3="[object Date]",errorTag$2="[object Error]",funcTag$1="[object Function]",mapTag$5="[object Map]",numberTag$3="[object Number]",objectTag$3="[object Object]",regexpTag$3="[object RegExp]",setTag$5="[object Set]",stringTag$3="[object String]",weakMapTag$2="[object WeakMap]",arrayBufferTag$3="[object ArrayBuffer]",dataViewTag$4="[object DataView]",float32Tag$2="[object Float32Array]",float64Tag$2="[object Float64Array]",int8Tag$2="[object Int8Array]",int16Tag$2="[object Int16Array]",int32Tag$2="[object Int32Array]",uint8Tag$2="[object Uint8Array]",uint8ClampedTag$2="[object Uint8ClampedArray]",uint16Tag$2="[object Uint16Array]",uint32Tag$2="[object Uint32Array]",typedArrayTags={};function baseIsTypedArray$1(t){return isObjectLike$3(t)&&isLength$1(t.length)&&!!typedArrayTags[baseGetTag$1(t)]}typedArrayTags[float32Tag$2]=typedArrayTags[float64Tag$2]=typedArrayTags[int8Tag$2]=typedArrayTags[int16Tag$2]=typedArrayTags[int32Tag$2]=typedArrayTags[uint8Tag$2]=typedArrayTags[uint8ClampedTag$2]=typedArrayTags[uint16Tag$2]=typedArrayTags[uint32Tag$2]=!0,typedArrayTags[argsTag$2]=typedArrayTags[arrayTag$2]=typedArrayTags[arrayBufferTag$3]=typedArrayTags[boolTag$3]=typedArrayTags[dataViewTag$4]=typedArrayTags[dateTag$3]=typedArrayTags[errorTag$2]=typedArrayTags[funcTag$1]=typedArrayTags[mapTag$5]=typedArrayTags[numberTag$3]=typedArrayTags[objectTag$3]=typedArrayTags[regexpTag$3]=typedArrayTags[setTag$5]=typedArrayTags[stringTag$3]=typedArrayTags[weakMapTag$2]=!1;var _baseIsTypedArray=baseIsTypedArray$1;function baseUnary$3(t){return function(e){return t(e)}}var _baseUnary=baseUnary$3,_nodeUtil={exports:{}};!function(t,e){var s=_freeGlobal,n=e&&!e.nodeType&&e,i=n&&t&&!t.nodeType&&t,o=i&&i.exports===n&&s.process,a=function(){try{var t=i&&i.require&&i.require("util").types;return t||o&&o.binding&&o.binding("util")}catch(t){}}();t.exports=a}(_nodeUtil,_nodeUtil.exports);var baseIsTypedArray=_baseIsTypedArray,baseUnary$2=_baseUnary,nodeUtil$2=_nodeUtil.exports,nodeIsTypedArray=nodeUtil$2&&nodeUtil$2.isTypedArray,isTypedArray$2=nodeIsTypedArray?baseUnary$2(nodeIsTypedArray):baseIsTypedArray,isTypedArray_1=isTypedArray$2,baseTimes=_baseTimes,isArguments=isArguments_1,isArray$3=isArray_1,isBuffer$2=isBuffer$3.exports,isIndex=_isIndex,isTypedArray$1=isTypedArray_1,objectProto$7=Object.prototype,hasOwnProperty$5=objectProto$7.hasOwnProperty;function arrayLikeKeys$2(t,e){var s=isArray$3(t),n=!s&&isArguments(t),i=!s&&!n&&isBuffer$2(t),o=!s&&!n&&!i&&isTypedArray$1(t),a=s||n||i||o,l=a?baseTimes(t.length,String):[],r=l.length;for(var m in t)!e&&!hasOwnProperty$5.call(t,m)||a&&("length"==m||i&&("offset"==m||"parent"==m)||o&&("buffer"==m||"byteLength"==m||"byteOffset"==m)||isIndex(m,r))||l.push(m);return l}var _arrayLikeKeys=arrayLikeKeys$2,objectProto$6=Object.prototype;function isPrototype$3(t){var e=t&&t.constructor;return t===("function"==typeof e&&e.prototype||objectProto$6)}var _isPrototype=isPrototype$3;function overArg$2(t,e){return function(s){return t(e(s))}}var _overArg=overArg$2,overArg$1=_overArg,nativeKeys$1=overArg$1(Object.keys,Object),_nativeKeys=nativeKeys$1,isPrototype$2=_isPrototype,nativeKeys=_nativeKeys,objectProto$5=Object.prototype,hasOwnProperty$4=objectProto$5.hasOwnProperty;function baseKeys$1(t){if(!isPrototype$2(t))return nativeKeys(t);var e=[];for(var s in Object(t))hasOwnProperty$4.call(t,s)&&"constructor"!=s&&e.push(s);return e}var _baseKeys=baseKeys$1,isFunction=isFunction_1,isLength=isLength_1;function isArrayLike$2(t){return null!=t&&isLength(t.length)&&!isFunction(t)}var isArrayLike_1=isArrayLike$2,arrayLikeKeys$1=_arrayLikeKeys,baseKeys=_baseKeys,isArrayLike$1=isArrayLike_1;function keys$3(t){return isArrayLike$1(t)?arrayLikeKeys$1(t):baseKeys(t)}var keys_1=keys$3,copyObject$3=_copyObject,keys$2=keys_1;function baseAssign$1(t,e){return t&&copyObject$3(e,keys$2(e),t)}var _baseAssign=baseAssign$1;function nativeKeysIn$1(t){var e=[];if(null!=t)for(var s in Object(t))e.push(s);return e}var _nativeKeysIn=nativeKeysIn$1,isObject$2=isObject_1,isPrototype$1=_isPrototype,nativeKeysIn=_nativeKeysIn,objectProto$4=Object.prototype,hasOwnProperty$3=objectProto$4.hasOwnProperty;function baseKeysIn$1(t){if(!isObject$2(t))return nativeKeysIn(t);var e=isPrototype$1(t),s=[];for(var n in t)("constructor"!=n||!e&&hasOwnProperty$3.call(t,n))&&s.push(n);return s}var _baseKeysIn=baseKeysIn$1,arrayLikeKeys=_arrayLikeKeys,baseKeysIn=_baseKeysIn,isArrayLike=isArrayLike_1;function keysIn$3(t){return isArrayLike(t)?arrayLikeKeys(t,!0):baseKeysIn(t)}var keysIn_1=keysIn$3,copyObject$2=_copyObject,keysIn$2=keysIn_1;function baseAssignIn$1(t,e){return t&&copyObject$2(e,keysIn$2(e),t)}var _baseAssignIn=baseAssignIn$1,_cloneBuffer={exports:{}};function copyArray$1(t,e){var s=-1,n=t.length;for(e||(e=Array(n));++s<n;)e[s]=t[s];return e}!function(t,e){var s=_root,n=e&&!e.nodeType&&e,i=n&&t&&!t.nodeType&&t,o=i&&i.exports===n?s.Buffer:void 0,a=o?o.allocUnsafe:void 0;t.exports=function(t,e){if(e)return t.slice();var s=t.length,n=a?a(s):new t.constructor(s);return t.copy(n),n}}(_cloneBuffer,_cloneBuffer.exports);var _copyArray=copyArray$1;function arrayFilter$1(t,e){for(var s=-1,n=null==t?0:t.length,i=0,o=[];++s<n;){var a=t[s];e(a,s,t)&&(o[i++]=a)}return o}var _arrayFilter=arrayFilter$1;function stubArray$2(){return[]}var stubArray_1=stubArray$2,arrayFilter=_arrayFilter,stubArray$1=stubArray_1,objectProto$3=Object.prototype,propertyIsEnumerable=objectProto$3.propertyIsEnumerable,nativeGetSymbols$1=Object.getOwnPropertySymbols,getSymbols$3=nativeGetSymbols$1?function(t){return null==t?[]:(t=Object(t),arrayFilter(nativeGetSymbols$1(t),(function(e){return propertyIsEnumerable.call(t,e)})))}:stubArray$1,_getSymbols=getSymbols$3,copyObject$1=_copyObject,getSymbols$2=_getSymbols;function copySymbols$1(t,e){return copyObject$1(t,getSymbols$2(t),e)}var _copySymbols=copySymbols$1;function arrayPush$2(t,e){for(var s=-1,n=e.length,i=t.length;++s<n;)t[i+s]=e[s];return t}var _arrayPush=arrayPush$2,overArg=_overArg,getPrototype$2=overArg(Object.getPrototypeOf,Object),_getPrototype=getPrototype$2,arrayPush$1=_arrayPush,getPrototype$1=_getPrototype,getSymbols$1=_getSymbols,stubArray=stubArray_1,nativeGetSymbols=Object.getOwnPropertySymbols,getSymbolsIn$2=nativeGetSymbols?function(t){for(var e=[];t;)arrayPush$1(e,getSymbols$1(t)),t=getPrototype$1(t);return e}:stubArray,_getSymbolsIn=getSymbolsIn$2,copyObject=_copyObject,getSymbolsIn$1=_getSymbolsIn;function copySymbolsIn$1(t,e){return copyObject(t,getSymbolsIn$1(t),e)}var _copySymbolsIn=copySymbolsIn$1,arrayPush=_arrayPush,isArray$2=isArray_1;function baseGetAllKeys$2(t,e,s){var n=e(t);return isArray$2(t)?n:arrayPush(n,s(t))}var _baseGetAllKeys=baseGetAllKeys$2,baseGetAllKeys$1=_baseGetAllKeys,getSymbols=_getSymbols,keys$1=keys_1;function getAllKeys$2(t){return baseGetAllKeys$1(t,keys$1,getSymbols)}var _getAllKeys=getAllKeys$2,baseGetAllKeys=_baseGetAllKeys,getSymbolsIn=_getSymbolsIn,keysIn$1=keysIn_1;function getAllKeysIn$1(t){return baseGetAllKeys(t,keysIn$1,getSymbolsIn)}var _getAllKeysIn=getAllKeysIn$1,getNative$3=_getNative,root$4=_root,DataView$2=getNative$3(root$4,"DataView"),_DataView=DataView$2,getNative$2=_getNative,root$3=_root,Promise$2=getNative$2(root$3,"Promise"),_Promise=Promise$2,getNative$1=_getNative,root$2=_root,Set$2=getNative$1(root$2,"Set"),_Set=Set$2,getNative=_getNative,root$1=_root,WeakMap$1=getNative(root$1,"WeakMap"),_WeakMap=WeakMap$1,DataView$1=_DataView,Map$1=_Map,Promise$1=_Promise,Set$1=_Set,WeakMap=_WeakMap,baseGetTag=_baseGetTag,toSource=_toSource,mapTag$4="[object Map]",objectTag$2="[object Object]",promiseTag="[object Promise]",setTag$4="[object Set]",weakMapTag$1="[object WeakMap]",dataViewTag$3="[object DataView]",dataViewCtorString=toSource(DataView$1),mapCtorString=toSource(Map$1),promiseCtorString=toSource(Promise$1),setCtorString=toSource(Set$1),weakMapCtorString=toSource(WeakMap),getTag$4=baseGetTag;(DataView$1&&getTag$4(new DataView$1(new ArrayBuffer(1)))!=dataViewTag$3||Map$1&&getTag$4(new Map$1)!=mapTag$4||Promise$1&&getTag$4(Promise$1.resolve())!=promiseTag||Set$1&&getTag$4(new Set$1)!=setTag$4||WeakMap&&getTag$4(new WeakMap)!=weakMapTag$1)&&(getTag$4=function(t){var e=baseGetTag(t),s=e==objectTag$2?t.constructor:void 0,n=s?toSource(s):"";if(n)switch(n){case dataViewCtorString:return dataViewTag$3;case mapCtorString:return mapTag$4;case promiseCtorString:return promiseTag;case setCtorString:return setTag$4;case weakMapCtorString:return weakMapTag$1}return e});var _getTag=getTag$4,objectProto$2=Object.prototype,hasOwnProperty$2=objectProto$2.hasOwnProperty;function initCloneArray$1(t){var e=t.length,s=new t.constructor(e);return e&&"string"==typeof t[0]&&hasOwnProperty$2.call(t,"index")&&(s.index=t.index,s.input=t.input),s}var _initCloneArray=initCloneArray$1,root=_root,Uint8Array$3=root.Uint8Array,_Uint8Array=Uint8Array$3,Uint8Array$2=_Uint8Array;function cloneArrayBuffer$3(t){var e=new t.constructor(t.byteLength);return new Uint8Array$2(e).set(new Uint8Array$2(t)),e}var _cloneArrayBuffer=cloneArrayBuffer$3,cloneArrayBuffer$2=_cloneArrayBuffer;function cloneDataView$1(t,e){var s=e?cloneArrayBuffer$2(t.buffer):t.buffer;return new t.constructor(s,t.byteOffset,t.byteLength)}var _cloneDataView=cloneDataView$1,reFlags=/\w*$/;function cloneRegExp$1(t){var e=new t.constructor(t.source,reFlags.exec(t));return e.lastIndex=t.lastIndex,e}var _cloneRegExp=cloneRegExp$1,Symbol$2=_Symbol,symbolProto$1=Symbol$2?Symbol$2.prototype:void 0,symbolValueOf$1=symbolProto$1?symbolProto$1.valueOf:void 0;function cloneSymbol$1(t){return symbolValueOf$1?Object(symbolValueOf$1.call(t)):{}}var _cloneSymbol=cloneSymbol$1,cloneArrayBuffer$1=_cloneArrayBuffer;function cloneTypedArray$1(t,e){var s=e?cloneArrayBuffer$1(t.buffer):t.buffer;return new t.constructor(s,t.byteOffset,t.length)}var _cloneTypedArray=cloneTypedArray$1,cloneArrayBuffer=_cloneArrayBuffer,cloneDataView=_cloneDataView,cloneRegExp=_cloneRegExp,cloneSymbol=_cloneSymbol,cloneTypedArray=_cloneTypedArray,boolTag$2="[object Boolean]",dateTag$2="[object Date]",mapTag$3="[object Map]",numberTag$2="[object Number]",regexpTag$2="[object RegExp]",setTag$3="[object Set]",stringTag$2="[object String]",symbolTag$2="[object Symbol]",arrayBufferTag$2="[object ArrayBuffer]",dataViewTag$2="[object DataView]",float32Tag$1="[object Float32Array]",float64Tag$1="[object Float64Array]",int8Tag$1="[object Int8Array]",int16Tag$1="[object Int16Array]",int32Tag$1="[object Int32Array]",uint8Tag$1="[object Uint8Array]",uint8ClampedTag$1="[object Uint8ClampedArray]",uint16Tag$1="[object Uint16Array]",uint32Tag$1="[object Uint32Array]";function initCloneByTag$1(t,e,s){var n=t.constructor;switch(e){case arrayBufferTag$2:return cloneArrayBuffer(t);case boolTag$2:case dateTag$2:return new n(+t);case dataViewTag$2:return cloneDataView(t,s);case float32Tag$1:case float64Tag$1:case int8Tag$1:case int16Tag$1:case int32Tag$1:case uint8Tag$1:case uint8ClampedTag$1:case uint16Tag$1:case uint32Tag$1:return cloneTypedArray(t,s);case mapTag$3:return new n;case numberTag$2:case stringTag$2:return new n(t);case regexpTag$2:return cloneRegExp(t);case setTag$3:return new n;case symbolTag$2:return cloneSymbol(t)}}var _initCloneByTag=initCloneByTag$1,isObject$1=isObject_1,objectCreate=Object.create,baseCreate$1=function(){function t(){}return function(e){if(!isObject$1(e))return{};if(objectCreate)return objectCreate(e);t.prototype=e;var s=new t;return t.prototype=void 0,s}}(),_baseCreate=baseCreate$1,baseCreate=_baseCreate,getPrototype=_getPrototype,isPrototype=_isPrototype;function initCloneObject$1(t){return"function"!=typeof t.constructor||isPrototype(t)?{}:baseCreate(getPrototype(t))}var _initCloneObject=initCloneObject$1,getTag$3=_getTag,isObjectLike$2=isObjectLike_1,mapTag$2="[object Map]";function baseIsMap$1(t){return isObjectLike$2(t)&&getTag$3(t)==mapTag$2}var _baseIsMap=baseIsMap$1,baseIsMap=_baseIsMap,baseUnary$1=_baseUnary,nodeUtil$1=_nodeUtil.exports,nodeIsMap=nodeUtil$1&&nodeUtil$1.isMap,isMap$1=nodeIsMap?baseUnary$1(nodeIsMap):baseIsMap,isMap_1=isMap$1,getTag$2=_getTag,isObjectLike$1=isObjectLike_1,setTag$2="[object Set]";function baseIsSet$1(t){return isObjectLike$1(t)&&getTag$2(t)==setTag$2}var _baseIsSet=baseIsSet$1,baseIsSet=_baseIsSet,baseUnary=_baseUnary,nodeUtil=_nodeUtil.exports,nodeIsSet=nodeUtil&&nodeUtil.isSet,isSet$1=nodeIsSet?baseUnary(nodeIsSet):baseIsSet,isSet_1=isSet$1,Stack$1=_Stack,arrayEach=_arrayEach,assignValue=_assignValue,baseAssign=_baseAssign,baseAssignIn=_baseAssignIn,cloneBuffer=_cloneBuffer.exports,copyArray=_copyArray,copySymbols=_copySymbols,copySymbolsIn=_copySymbolsIn,getAllKeys$1=_getAllKeys,getAllKeysIn=_getAllKeysIn,getTag$1=_getTag,initCloneArray=_initCloneArray,initCloneByTag=_initCloneByTag,initCloneObject=_initCloneObject,isArray$1=isArray_1,isBuffer$1=isBuffer$3.exports,isMap=isMap_1,isObject=isObject_1,isSet=isSet_1,keys=keys_1,keysIn=keysIn_1,CLONE_DEEP_FLAG$1=1,CLONE_FLAT_FLAG=2,CLONE_SYMBOLS_FLAG$1=4,argsTag$1="[object Arguments]",arrayTag$1="[object Array]",boolTag$1="[object Boolean]",dateTag$1="[object Date]",errorTag$1="[object Error]",funcTag="[object Function]",genTag="[object GeneratorFunction]",mapTag$1="[object Map]",numberTag$1="[object Number]",objectTag$1="[object Object]",regexpTag$1="[object RegExp]",setTag$1="[object Set]",stringTag$1="[object String]",symbolTag$1="[object Symbol]",weakMapTag="[object WeakMap]",arrayBufferTag$1="[object ArrayBuffer]",dataViewTag$1="[object DataView]",float32Tag="[object Float32Array]",float64Tag="[object Float64Array]",int8Tag="[object Int8Array]",int16Tag="[object Int16Array]",int32Tag="[object Int32Array]",uint8Tag="[object Uint8Array]",uint8ClampedTag="[object Uint8ClampedArray]",uint16Tag="[object Uint16Array]",uint32Tag="[object Uint32Array]",cloneableTags={};function baseClone$1(t,e,s,n,i,o){var a,l=e&CLONE_DEEP_FLAG$1,r=e&CLONE_FLAT_FLAG,m=e&CLONE_SYMBOLS_FLAG$1;if(s&&(a=i?s(t,n,i,o):s(t)),void 0!==a)return a;if(!isObject(t))return t;var g=isArray$1(t);if(g){if(a=initCloneArray(t),!l)return copyArray(t,a)}else{var u=getTag$1(t),c=u==funcTag||u==genTag;if(isBuffer$1(t))return cloneBuffer(t,l);if(u==objectTag$1||u==argsTag$1||c&&!i){if(a=r||c?{}:initCloneObject(t),!l)return r?copySymbolsIn(t,baseAssignIn(a,t)):copySymbols(t,baseAssign(a,t))}else{if(!cloneableTags[u])return i?t:{};a=initCloneByTag(t,u,l)}}o||(o=new Stack$1);var C=o.get(t);if(C)return C;o.set(t,a),isSet(t)?t.forEach((function(n){a.add(baseClone$1(n,e,s,n,t,o))})):isMap(t)&&t.forEach((function(n,i){a.set(i,baseClone$1(n,e,s,i,t,o))}));var f=g?void 0:(m?r?getAllKeysIn:getAllKeys$1:r?keysIn:keys)(t);return arrayEach(f||t,(function(n,i){f&&(n=t[i=n]),assignValue(a,i,baseClone$1(n,e,s,i,t,o))})),a}cloneableTags[argsTag$1]=cloneableTags[arrayTag$1]=cloneableTags[arrayBufferTag$1]=cloneableTags[dataViewTag$1]=cloneableTags[boolTag$1]=cloneableTags[dateTag$1]=cloneableTags[float32Tag]=cloneableTags[float64Tag]=cloneableTags[int8Tag]=cloneableTags[int16Tag]=cloneableTags[int32Tag]=cloneableTags[mapTag$1]=cloneableTags[numberTag$1]=cloneableTags[objectTag$1]=cloneableTags[regexpTag$1]=cloneableTags[setTag$1]=cloneableTags[stringTag$1]=cloneableTags[symbolTag$1]=cloneableTags[uint8Tag]=cloneableTags[uint8ClampedTag]=cloneableTags[uint16Tag]=cloneableTags[uint32Tag]=!0,cloneableTags[errorTag$1]=cloneableTags[funcTag]=cloneableTags[weakMapTag]=!1;var _baseClone=baseClone$1,baseClone=_baseClone,CLONE_DEEP_FLAG=1,CLONE_SYMBOLS_FLAG=4;function cloneDeep(t){return baseClone(t,CLONE_DEEP_FLAG|CLONE_SYMBOLS_FLAG)}var cloneDeep_1=cloneDeep,lodashCloneDeep=cloneDeep_1,HASH_UNDEFINED="__lodash_hash_undefined__";function setCacheAdd$1(t){return this.__data__.set(t,HASH_UNDEFINED),this}var _setCacheAdd=setCacheAdd$1;function setCacheHas$1(t){return this.__data__.has(t)}var _setCacheHas=setCacheHas$1,MapCache=_MapCache,setCacheAdd=_setCacheAdd,setCacheHas=_setCacheHas;function SetCache$1(t){var e=-1,s=null==t?0:t.length;for(this.__data__=new MapCache;++e<s;)this.add(t[e])}SetCache$1.prototype.add=SetCache$1.prototype.push=setCacheAdd,SetCache$1.prototype.has=setCacheHas;var _SetCache=SetCache$1;function arraySome$1(t,e){for(var s=-1,n=null==t?0:t.length;++s<n;)if(e(t[s],s,t))return!0;return!1}var _arraySome=arraySome$1;function cacheHas$1(t,e){return t.has(e)}var _cacheHas=cacheHas$1,SetCache=_SetCache,arraySome=_arraySome,cacheHas=_cacheHas,COMPARE_PARTIAL_FLAG$3=1,COMPARE_UNORDERED_FLAG$1=2;function equalArrays$2(t,e,s,n,i,o){var a=s&COMPARE_PARTIAL_FLAG$3,l=t.length,r=e.length;if(l!=r&&!(a&&r>l))return!1;var m=o.get(t),g=o.get(e);if(m&&g)return m==e&&g==t;var u=-1,c=!0,C=s&COMPARE_UNORDERED_FLAG$1?new SetCache:void 0;for(o.set(t,e),o.set(e,t);++u<l;){var f=t[u],h=e[u];if(n)var p=a?n(h,f,u,e,t,o):n(f,h,u,t,e,o);if(void 0!==p){if(p)continue;c=!1;break}if(C){if(!arraySome(e,(function(t,e){if(!cacheHas(C,e)&&(f===t||i(f,t,s,n,o)))return C.push(e)}))){c=!1;break}}else if(f!==h&&!i(f,h,s,n,o)){c=!1;break}}return o.delete(t),o.delete(e),c}var _equalArrays=equalArrays$2;function mapToArray$1(t){var e=-1,s=Array(t.size);return t.forEach((function(t,n){s[++e]=[n,t]})),s}var _mapToArray=mapToArray$1;function setToArray$1(t){var e=-1,s=Array(t.size);return t.forEach((function(t){s[++e]=t})),s}var _setToArray=setToArray$1,Symbol$1=_Symbol,Uint8Array$1=_Uint8Array,eq=eq_1,equalArrays$1=_equalArrays,mapToArray=_mapToArray,setToArray=_setToArray,COMPARE_PARTIAL_FLAG$2=1,COMPARE_UNORDERED_FLAG=2,boolTag="[object Boolean]",dateTag="[object Date]",errorTag="[object Error]",mapTag="[object Map]",numberTag="[object Number]",regexpTag="[object RegExp]",setTag="[object Set]",stringTag="[object String]",symbolTag="[object Symbol]",arrayBufferTag="[object ArrayBuffer]",dataViewTag="[object DataView]",symbolProto=Symbol$1?Symbol$1.prototype:void 0,symbolValueOf=symbolProto?symbolProto.valueOf:void 0;function equalByTag$1(t,e,s,n,i,o,a){switch(s){case dataViewTag:if(t.byteLength!=e.byteLength||t.byteOffset!=e.byteOffset)return!1;t=t.buffer,e=e.buffer;case arrayBufferTag:return!(t.byteLength!=e.byteLength||!o(new Uint8Array$1(t),new Uint8Array$1(e)));case boolTag:case dateTag:case numberTag:return eq(+t,+e);case errorTag:return t.name==e.name&&t.message==e.message;case regexpTag:case stringTag:return t==e+"";case mapTag:var l=mapToArray;case setTag:var r=n&COMPARE_PARTIAL_FLAG$2;if(l||(l=setToArray),t.size!=e.size&&!r)return!1;var m=a.get(t);if(m)return m==e;n|=COMPARE_UNORDERED_FLAG,a.set(t,e);var g=equalArrays$1(l(t),l(e),n,i,o,a);return a.delete(t),g;case symbolTag:if(symbolValueOf)return symbolValueOf.call(t)==symbolValueOf.call(e)}return!1}var _equalByTag=equalByTag$1,getAllKeys=_getAllKeys,COMPARE_PARTIAL_FLAG$1=1,objectProto$1=Object.prototype,hasOwnProperty$1=objectProto$1.hasOwnProperty;function equalObjects$1(t,e,s,n,i,o){var a=s&COMPARE_PARTIAL_FLAG$1,l=getAllKeys(t),r=l.length;if(r!=getAllKeys(e).length&&!a)return!1;for(var m=r;m--;){var g=l[m];if(!(a?g in e:hasOwnProperty$1.call(e,g)))return!1}var u=o.get(t),c=o.get(e);if(u&&c)return u==e&&c==t;var C=!0;o.set(t,e),o.set(e,t);for(var f=a;++m<r;){var h=t[g=l[m]],p=e[g];if(n)var d=a?n(p,h,g,e,t,o):n(h,p,g,t,e,o);if(!(void 0===d?h===p||i(h,p,s,n,o):d)){C=!1;break}f||(f="constructor"==g)}if(C&&!f){var y=t.constructor,H=e.constructor;y==H||!("constructor"in t)||!("constructor"in e)||"function"==typeof y&&y instanceof y&&"function"==typeof H&&H instanceof H||(C=!1)}return o.delete(t),o.delete(e),C}var _equalObjects=equalObjects$1,Stack=_Stack,equalArrays=_equalArrays,equalByTag=_equalByTag,equalObjects=_equalObjects,getTag=_getTag,isArray=isArray_1,isBuffer=isBuffer$3.exports,isTypedArray=isTypedArray_1,COMPARE_PARTIAL_FLAG=1,argsTag="[object Arguments]",arrayTag="[object Array]",objectTag="[object Object]",objectProto=Object.prototype,hasOwnProperty=objectProto.hasOwnProperty;function baseIsEqualDeep$1(t,e,s,n,i,o){var a=isArray(t),l=isArray(e),r=a?arrayTag:getTag(t),m=l?arrayTag:getTag(e),g=(r=r==argsTag?objectTag:r)==objectTag,u=(m=m==argsTag?objectTag:m)==objectTag,c=r==m;if(c&&isBuffer(t)){if(!isBuffer(e))return!1;a=!0,g=!1}if(c&&!g)return o||(o=new Stack),a||isTypedArray(t)?equalArrays(t,e,s,n,i,o):equalByTag(t,e,r,s,n,i,o);if(!(s&COMPARE_PARTIAL_FLAG)){var C=g&&hasOwnProperty.call(t,"__wrapped__"),f=u&&hasOwnProperty.call(e,"__wrapped__");if(C||f){var h=C?t.value():t,p=f?e.value():e;return o||(o=new Stack),i(h,p,s,n,o)}}return!!c&&(o||(o=new Stack),equalObjects(t,e,s,n,i,o))}var _baseIsEqualDeep=baseIsEqualDeep$1,baseIsEqualDeep=_baseIsEqualDeep,isObjectLike=isObjectLike_1;function baseIsEqual$1(t,e,s,n,i){return t===e||(null==t||null==e||!isObjectLike(t)&&!isObjectLike(e)?t!=t&&e!=e:baseIsEqualDeep(t,e,s,n,baseIsEqual$1,i))}var _baseIsEqual=baseIsEqual$1,baseIsEqual=_baseIsEqual;function isEqual(t,e){return baseIsEqual(t,e)}var isEqual_1=isEqual,lodashIsEqual=isEqual_1;function isEditedHSQC(t){return t.info.pulseSequence.includes("hsqced")}function getSignals2D(t){const e={};return Object.keys(t).forEach((s=>{const n=[],i=[],o=[];t[s].forEach(((t,e)=>{const s=t;o.some((t=>lodashIsEqual(t,s.info.nucleus)))||(o.push(s.info.nucleus),i.push(e))})),i.forEach((e=>{const i=t[s][e],o=i.info.nucleus.map((t=>getAtomTypeFromNucleus(t)));i.zones.values.map((t=>t.signals.filter((t=>t.kind&&allowedSignalKinds.includes(t.kind))))).flat().forEach((t=>{n.some((e=>checkMatch(e.signal.x.delta,t.x.delta,0)&&checkMatch(e.signal.y.delta,t.y.delta,0)))||n.push({experimentType:s,experimentID:i.id,atomType:o,signal:{...lodashCloneDeep(t),sign:isEditedHSQC(i)&&t.peaks?t.peaks[0].z>=0?1:-1:0}})}))})),e[s]=n})),e}function getSignalsDEPT(t){const e={};return Object.keys(t).filter((t=>"dept"===t)).forEach((s=>t[s].forEach((t=>{const n=t,i=[],o=n.info.pulseSequence.match(/\d/g);if(o){const t=o.reduce(((t,e)=>t+e)),a=getAtomTypeFromNucleus(n.info.nucleus);n.ranges.values.map((t=>t.signals.filter((t=>t.kind&&allowedSignalKinds.includes(t.kind))).map((e=>({...e,sign:t.absolute>0?1:-1}))))).flat().forEach((e=>{i.some((t=>checkMatch(t.signal.delta,e.delta,0)))||i.push({experimentType:s,experimentID:n.id,mode:t,atomType:a,signal:lodashCloneDeep(e)})})),e[t]=i}})))),e}function getSignals(t){const e=getExperiments(t),s=getExperiments1D(e),n=getExperiments1DExtra(e),i=getExperiments2D(e);return{signals1D:getSignals1D(s),signals2D:getSignals2D(i),signalsDEPT:getSignalsDEPT(n)}}const BASE62="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ",LENGTH=8;function generateID(){let t="";for(let e=0;e<LENGTH;e++)t+=BASE62.charAt(Math.floor(62*Math.random()));return t}function buildLink(t){return{id:t.id||generateID(),experimentType:t.experimentType,experimentID:t.experimentID,atomType:t.atomType,signal:t.signal,axis:t.axis,match:t.match||[],experimentLabel:t.experimentLabel||"",pseudo:t.pseudo||!1,edited:t.edited||{}}}function findLinkedCorrelationsBySignalID(t,e){return t.filter((t=>t.link.some((t=>t.signal.id===e))))}function containsLink(t,e){return t.link.some((t=>t.experimentType===e.experimentType&&t.experimentID===e.experimentID&&lodashIsEqual(t.atomType,e.atomType)&&t.signal.id===e.signal.id&&t.axis===e.axis))}function hasLinks(t){return t.link.length>0}function addSignal(t,e,s,n){if(0===t.length){const t=buildCorrelation({atomType:e});addLink(t,s);const i=n.findIndex((t=>t.atomType===e&&t.pseudo&&!hasLinks(t)));i>=0?n[i]=t:n.push(t)}else containsLink(n[t[0]],s)||addLink(n[t[0]],s)}function addFromData(t,e,s,n){return t=t.filter((t=>t.link.length>0||t.pseudo)),Object.keys(e).forEach((s=>{e[s].forEach((e=>{if(0===findLinkedCorrelationsBySignalID(t,e.signal.id||"").length){const i=t.map(((t,i)=>{const o=getCorrelationDelta(t);return!t.pseudo&&t.atomType===s&&void 0!==o&&checkMatch(o,e.signal.delta,n[s])?i:-1})).filter((t=>t>=0)).filter(((t,e,s)=>s.indexOf(t)===e)),o=buildLink({experimentType:e.experimentType,experimentID:e.experimentID,signal:e.signal,atomType:[s]});addSignal(i,s,o,t)}}))})),Object.keys(s).forEach((e=>s[e].forEach((e=>{0===findLinkedCorrelationsBySignalID(t,e.signal.id||"").length&&e.atomType.forEach(((s,i)=>{const o=0===i?"x":"y",a=t.map(((t,i)=>{const a=getCorrelationDelta(t);return!t.pseudo&&t.atomType===s&&void 0!==a&&checkMatch(a,e.signal[o].delta,n[s])?i:-1})).filter((t=>t>=0)).filter(((t,e,s)=>s.indexOf(t)===e)),l=buildLink({experimentType:e.experimentType,experimentID:e.experimentID,signal:e.signal,axis:o,atomType:e.atomType});addSignal(a,s,l,t)}))})))),t}function buildCorrelation(t){return{id:t.id||generateID(),atomType:t.atomType,label:t.label||{},link:t.link||[],equivalence:t.equivalence||1,attachment:t.attachment||{},protonsCount:t.protonsCount||[],hybridization:t.hybridization||[],pseudo:t.pseudo||!1,edited:t.edited||{}}}function addPseudoCorrelations(t,e){for(const s in e){const n=getCorrelationsByAtomType(t,s).reduce(((t,e)=>t+e.equivalence),0);for(let i=n;i<e[s];i++)t.push(buildCorrelation({atomType:s,pseudo:!0}))}return t}function removeLink(t,e){return t.link=t.link.filter((t=>t.id!==e)),t}function removeMatch(t,e){const s=t.match.indexOf(e);return s>=0&&t.match.splice(s,1),t}function checkPseudoCorrelations(t,e){for(const s in e){const n=getCorrelationsByAtomType(t,s);if(n.length>e[s]){const i=n.filter((t=>t.pseudo&&1===t.equivalence&&!hasLinks(t)));for(let o=n.length-1;o>=e[s]&&0!==i.length;o--){const e=i.pop();e&&t.splice(t.indexOf(e),1)}}}for(const e of t){if(!e.pseudo||e.equivalence>1||hasLinks(e))continue;const s=[],n=getCorrelationIndex(t,e);for(const i of e.link){for(const e of i.match)t[e]&&t[e].link.some((t=>t.match.includes(n)))||removeMatch(i,e);0===i.match.length&&s.push(i)}for(const t of s)removeLink(e,t.id);e.edited.protonsCount||e.link.some((t=>"hsqc"===t.experimentType))||(e.protonsCount=[])}return Object.keys(e).length>0?t.filter((t=>Object.keys(e).includes(t.atomType))):t}function replacePseudoCorrelationsByEquivalences(t,e){for(const s in e){const n=getCorrelationsByAtomType(t,s),i=n.filter((t=>!t.pseudo||t.equivalence>1||hasLinks(t))),o=i.reduce(((t,e)=>t+(e.equivalence-1)),0),a=n.filter((t=>t.pseudo&&!i.some((e=>e.id===t.id))));for(let i=0;i<n.length-(e[s]-o)&&0!==a.length;i++){const e=a.pop();e&&t.splice(t.indexOf(e),1)}}return t}function updatePseudoCorrelations(t,e){const s=getAtomCounts(e);return 0===Object.keys(s).length&&(t=t.filter((t=>!t.pseudo))),t=checkPseudoCorrelations(t=replacePseudoCorrelationsByEquivalences(t=addPseudoCorrelations(t,s),s),s)}function removeObsoleteLinksAndNotLinkedCorrelations(t,e,s){const n=t.filter((t=>!t.pseudo)),i=n.slice();return n.forEach((t=>{for(const n of t.link)if("1d"===n.experimentType)if(lodashGet(e,n.atomType[0],[]).some((t=>t.signal.id===n.signal.id))){const e=i.indexOf(t);e>=0&&i.splice(e,1)}else n.pseudo||removeLink(t,n.id);else if(lodashGet(s,`${n.experimentType}`,[]).some((t=>t.signal.id===n.signal.id))){const e=i.indexOf(t);e>=0&&i.splice(e,1)}else n.pseudo||removeLink(t,n.id)})),i.forEach((e=>{const s=t.indexOf(e);s>=0&&t.splice(s,1)})),t}function hasAttachmentAtomType(t,e){return Boolean(t.attachment[e]&&t.attachment[e].length>0)}function addAttachmentAtomType(t,e){return hasAttachmentAtomType(t,e)||(t.attachment[e]=[]),t}function addAttachment(t,e,s){return addAttachmentAtomType(t,e),t.attachment[e].includes(s)||t.attachment[e].push(s),t}function removeAttachments(t){return t.attachment={},t}function setAttachmentsAndProtonEquivalences(t){for(const e of t){removeAttachments(e);const t=e.link.filter((t=>"hsqc"===t.experimentType||"hmqc"===t.experimentType));for(const s of t){const t=s.atomType["x"===s.axis?1:0];for(let n of s.match)addAttachment(e,t,n)}}for(const e of t)"H"===e.atomType&&(e.equivalence=0);for(const e of t)if("H"!==e.atomType&&1===e.protonsCount.length&&hasAttachmentAtomType(e,"H")){const{equivalence:s,protonsCount:n}=e;let i=1;3===n[0]?i=3:2===n[0]&&(i=2);const o=s*i/e.attachment.H.length;for(const s of e.attachment.H)t[s].equivalence+=o}for(const e of t)"H"===e.atomType&&0===e.equivalence&&(e.equivalence=1);return t}function setLabels(t){const e={};return t.forEach((t=>{lodashGet(e,t.atomType,!1)||(e[t.atomType]=0),e[t.atomType]++,t.label.origin=`${t.atomType}${e[t.atomType]}`})),t}function addMatch(t,e){return t.match.includes(e)||t.match.push(e),t}function removeMatches(t){return t.match=[],t}function setMatches(t){return t.forEach((e=>{e.link.forEach((s=>{removeMatches(s);const n="x"===s.axis?s.atomType[1]:s.atomType[0];getCorrelationsByAtomType(t,n).forEach((n=>{if(e.id!==n.id){const e=getCorrelationIndex(t,n);n.link.forEach((t=>{t.experimentType===s.experimentType&&t.experimentID===s.experimentID&&lodashIsEqual(t.atomType,s.atomType)&&t.signal.id===s.signal.id&&t.axis!==s.axis&&addMatch(s,e)}))}}))}))})),t.forEach((t=>{t.link.filter((t=>{var e;return 0===t.match.length&&"1d"!==t.experimentType&&!(null===(e=t.edited)||void 0===e?void 0:e.moved)})).forEach((e=>removeLink(t,e.id)))})),t}function sortCorrelations(t){const e=(t,e)=>{if(!t.pseudo&&!e.pseudo&&t.link.length>0&&e.link.length>0){const s=getCorrelationDelta(t),n=getCorrelationDelta(e);if(void 0!==s&&void 0!==n){if(s<n)return-1;if(s>n)return 1}}return!t.pseudo&&e.pseudo?-1:t.pseudo&&!e.pseudo?1:t.label.origin<e.label.origin?-1:t.label.origin>e.label.origin?1:0};let s=[];const n=t.map((t=>t.atomType)).filter(((t,e,s)=>s.indexOf(t)===e));return n.sort(((t,e)=>"C"===t?-1:"C"===e?1:"H"===t?-1:"H"===e?1:t<e?-1:t>e?1:0)),n.forEach((n=>{const i=getCorrelationsByAtomType(t,n);i.sort(e),s=s.concat(i)})),s}function buildValues(t,e){const{tolerance:s={},mf:n="",values:i=[]}=e,o=getSignals(t);let a=i?i.slice():[];return!0!==e.skipDataUpdate?(a=removeObsoleteLinksAndNotLinkedCorrelations(a,o.signals1D,o.signals2D),a=addFromData(a,o.signals1D,o.signals2D,s)):a=a.filter((t=>t.link.length>0||t.pseudo)),a=setProtonsCountFromData(a,o.signalsDEPT,o.signals2D,s),a=sortCorrelations(a),setMatches(a),setAttachmentsAndProtonEquivalences(a),a=updatePseudoCorrelations(a,n),setLabels(a),a}function buildCorrelationData(t,e){const s=t?buildValues(t,e):[];return delete e.values,delete e.skipDataUpdate,{values:s,options:e,state:buildState(s,e.mf||"")}}function addLink(t,e){return t.link.push(e),t}function createMapPossibleAssignment(t,e){const{restrictionByCS:s,predictions:n,targets:i}=e,{tolerance:o,chemicalShiftRestriction:a}=s,l=Object.keys(n);for(const e of l){let s=o[e],l=n[e],r=i[e];t[e]||(t[e]={});for(const n in l){let i=l[n];if(t[e][n]=[],r)for(const o in r){let l=r[o];const{nbAtoms:m,protonsCount:g}=i,{integration:u,protonsCount:c}=l;if(!u||("H"===e?m-u<1:!(c.length>0)||c.some((t=>g===t))))if(a&&void 0!==i.delta){let a=getCorrelationDelta(l);if(void 0===a)throw new Error("Correlation has not delta");Math.abs(i.delta-a-s)<4*s&&t[e][n].push(o)}else t[e][n].push(o)}t[e][n].push("*")}}return t}function groupCarbonTargetByIntegrationZone(t,e,s){let n=t[0],{H:i=[]}=e[n].attachment,o=[{targetIDs:[n],attachments:new Set(i)}];for(let s=1;s<t.length;s++){let n=t[s],i=e[n],{H:a=[]}=i.attachment,l=!0;for(let t of o){if(a.some((e=>t.attachments.has(e)))){l=!1,t.targetIDs.push(n);for(let e of a)t.attachments.add(e);break}}l&&o.push({targetIDs:[n],attachments:new Set(a)})}return o.map((t=>({atomType:"C",targetIDs:t.targetIDs,integration:s?Array.from(t.attachments).reduce(((t,e)=>s[e].integration+t),0):0})))}function partialScore(t,e){const{diaIDPeerPossibleAssignment:s,infoByAtomTypes:n,restrictionByCS:i,predictions:o,targets:a,correlations:l}=e,{tolerance:r,useChemicalShiftScore:m}=i;let g=0,u=0,c={},C={};const f=Object.keys(t);for(const e of f){let i=0;const{nbAllowedUnAssigned:o}=n[e],a={},l=t[e]||[];c[e]=a,C[e]=[],u+=l.length;for(let t=0;t<l.length;t++){const n=l[t];n&&"*"!==n&&(C[e].push(t),a[n]||(a[n]=[]),a[n].push(s[e][t])),"*"===n&&i++}if(i>o)return 0;g+=i}const h={};for(const t in c)h[t]=Object.keys(c[t]);const p=Object.values(h);if(p.reduce(((t,e)=>0===e.length?t+1:t),0)===p.length)return 0;const d=getPrediction.bind({},o),y=[];for(const e in t)if("C"===e&&h[e].length>0)y.push(...groupCarbonTargetByIntegrationZone(h[e],a[e],l));else for(let t of h[e])y.push({atomType:e,targetIDs:[t],integration:a.H[t].integration});for(const t of y){const{integration:e,atomType:s}=t;if(void 0===e||isNaN(e))continue;let n=0;for(let e of t.targetIDs){let t=c[s][e];for(const e of t){const{prediction:t,atomType:i}=d(e);s===i&&(n+=t.allHydrogens)}}if(n-e>=5)return 0}let H=1,v=1;if(m){v=0,H=0;for(const e of Object.keys(t)){const n=t[e],i=a[e];for(let t=0;t<n.length;t++){const a=n[t];if(a&&"*"!==a){H++;let n=s[e][t],l=o[e][n],m=i[a],g=r[e];if(void 0===l.delta)v+=1;else{const t=getCorrelationDelta(m);if(void 0===t)throw new Error("correlation has not delta");let e=Math.abs(l.delta-t);e<g?v+=1:(e=Math.abs(e-g),v+=-.25/g*e+1)}}}}H>0&&(v/=H)}let b=0;if(howManyActived(h)>1){let e={},n=[];for(const t of Object.keys(C))n=n.concat(C[t].map((e=>({index:e,atomType:t}))));for(let i=0;i<n.length;i++){const{atomType:l,index:r}=n[i],m=o[l][s[l][r]];for(let g=i+1;g<n.length;g++){const{atomType:i,index:u}=n[g],c=o[i][s[i][u]];let C=m.pathLength[c.diaIDIndex]<5,f=t[l][r],h=t[i][u];if(!f||!h)continue;let p=f>h?`${h} ${f}`:`${f} ${h}`,d=checkLinking({from:{targetID:f,atomType:l},to:{targetID:h,atomType:i}},a),y=C?d?1:0:d?0:1;e[p]=e[p]?Math.max(e[p],y):y}}let i=0;for(let t in e)i+=e[t];b=i/(n.length*(n.length-1)/2)}const w=g/u;return 0===v?b-w:0===b?v-w:(v+b)/2-w}function checkLinking(t,e){const{from:s,to:n}=t;if(s.targetID===n.targetID)return!0;let i=e[s.atomType][s.targetID],o=e[n.atomType][n.targetID];for(const t of o.link)for(const e of i.link)if(e.signal.id===t.signal.id)return!0;return!1}function getPrediction(t,e){const s=Object.keys(t);for(const n of s){const s=t[n];if(!s)throw new Error(`prediction by ${n}`);if(s[e])return{atomType:n,prediction:s[e]}}throw new Error(`There is not prediction for ${e}`)}function howManyActived(t){let e=0;for(const s in t)e+=t[s].length;return e}function exploreTree(t,e,s,n){const{currentAtomTypes:i,restrictionByCS:o,timeout:a,timeStart:l,maxSolutions:r,targets:m,predictions:g,correlations:u,lowerBoundScore:c,possibleAssignmentMap:C,diaIDPeerPossibleAssignment:f}=t;if((new Date).getTime()-l>a)return n;for(const t of i){const{currentIndex:h,nSources:p}=e[t];if(h>=p-1&&null!==s[t][h])continue;const d=f[t][h],y=C[t][d];for(let p of y){s[t][h]=p;let d=partialScore(s,{diaIDPeerPossibleAssignment:f,infoByAtomTypes:e,restrictionByCS:o,predictions:g,correlations:u,targets:m});if(0!==d)if(isLastOne(i,e)&&d>=c)addSolution(n,{predictions:g,partial:s,score:d,maxSolutions:r});else{const h=JSON.parse(JSON.stringify(e));h[t].currentIndex+=1,exploreTree({currentAtomTypes:i,restrictionByCS:o,timeout:a,timeStart:l,maxSolutions:r,targets:m,predictions:g,correlations:u,lowerBoundScore:c,possibleAssignmentMap:C,diaIDPeerPossibleAssignment:f},h,JSON.parse(JSON.stringify(s)),n)}}}}function addSolution(t,e){let{score:s,maxSolutions:n,partial:i,predictions:o}=e;s/=doubleAssignmentPenalty(i,o);let a={assignment:JSON.parse(JSON.stringify(i)),score:s};t.nSolutions>=n?a.score>t.solutions.last().score&&(t.solutions.pollLast(),t.solutions.add(a)):(t.solutions.add(a),t.nSolutions++)}function isLastOne(t,e){let s=!0;for(const n of t){const{currentIndex:t,nSources:i}=e[n];s=s&&t>=i-1}return s}function doubleAssignmentPenalty(t,e){let s=0;for(const n in e){s+=Object.keys(e[n]).length-new Set(t[n]).size}return s>0?2*s:1}function isSpectraData1D(t){return"ranges"in t}function searchIndices(t,e){for(let s=0;s<e.length;s++){const n=e[s],i=isSpectraData1D(n)?n.ranges:n.zones;for(let e=0;e<i.length;e++){const n=i[e].signals||[];for(let i=0;i<n.length;i++)if(t===n[i].id)return{spectrumIndex:s,signalIndex:i,elementIndex:e}}}throw new Error(`There is not a signal with ${t} ID`)}const comparator=(t,e)=>e.score-t.score,predictor={H:predictProton,C:predictCarbon};function checkNMRSignal1D(t){const e=["nbAtoms","diaIDs","atoms"];for(const s of t)for(let t of e)if(!s[t])throw new Error(`property ${t} does not exist`)}const getAllHydrogens={C:(t,e)=>t.getAllHydrogens(e),H:()=>1};async function buildAssignments(t){const{spectra:e,molecule:s,restrictionByCS:n,timeout:i,minScore:o,nbAllowedUnAssigned:a={},maxSolutions:l,correlations:r,assignmentOrder:m,predictionOptions:g,predictions:u={},targets:c}=t;let C=(new Date).getTime(),f=o,h={solutions:new TreeSet$1(comparator),nSolutions:0};const p=getConnectivityMatrix(s,{pathLength:!0});let d={};const y={};let H={},v={};for(const t of m){for(const e of t){const t=g[e],n=u[e];let{joinedSignals:i}=n?{joinedSignals:n}:await predictor[e](s,t);checkNMRSignal1D(i),y[e]||(y[e]={});let o=0;for(let t of i){const n=t.diaIDs[0],i=t.atoms[0],a=getAllHydrogens[e](s,i);o+=t.nbAtoms*a,y[e][n]={...t,diaIDIndex:i,allHydrogens:t.nbAtoms*a,protonsCount:a,pathLength:p[i]}}for(let t in y[e])y[e][t].allHydrogens*=100/o;d[e]={nSources:i.length,currentIndex:0,nbAllowedUnAssigned:a[e]||0}}H=createMapPossibleAssignment(H,{restrictionByCS:n,predictions:y,targets:c}),v={};for(const t in H)v[t]=Object.keys(H[t]);let e=getSourceOfPartials(h,d,t);h={solutions:new TreeSet$1(comparator),nSolutions:0};for(let s of e)exploreTree({currentAtomTypes:t,restrictionByCS:n,timeout:i,timeStart:C,targets:c,predictions:y,correlations:r,maxSolutions:l,lowerBoundScore:f,possibleAssignmentMap:H,diaIDPeerPossibleAssignment:v},d,s,h)}return annotateSpectraData({store:h,spectra:e,diaIDPeerPossibleAssignment:v,targets:c})}function annotateSpectraData(t){var e;const{store:s,spectra:n,diaIDPeerPossibleAssignment:i,targets:o}=t,{solutions:a}=s,l={},r=Object.keys(o);for(const t of r){const e=o[t];for(const t in e){let s=e[t];for(const t of s.link){const e=t.signal.id;l[e]||(l[t.signal.id]=searchIndices(e,n))}}}const m=[];for(let t of a.elements){const s=JSON.parse(JSON.stringify(n)),{assignment:a,score:r}=t,g=Object.keys(a);for(const t of g){const n=o[t],r=a[t];for(let o=0;o<r.length;o++){const a=r[o];if("*"===a||!a)continue;const m=n[a],g=i[t][o];for(let t of m.link){const{spectrumIndex:n,elementIndex:i,signalIndex:o}=l[t.signal.id],a=s[n];if(isSpectraData1D(a)){let{ranges:t}=a,e=t[i].signals[o];e.diaIDs||(e.diaIDs=[]),e.diaIDs.push(g)}else{const s=t.axis,n=a.zones[i].signals[o];n[s].diaIDs||(n[s].diaIDs=[]),null===(e=n[s].diaIDs)||void 0===e||e.push(g)}}}}m.push({score:r,assignment:s})}return m}function getSourceOfPartials(t,e,s){return t.nSolutions>0?t.solutions.elements.map((t=>{let n=t.assignment;for(const t of s)n[t]=fillPartial(e[t].nSources);return n})):initializePartials(e,s)}function initializePartials(t,e){const s={},n=Object.keys(t);for(const i of n){const n=e.includes(i)?null:"*";s[i]=fillPartial(t[i].nSources,n)}return[s]}function fillPartial(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;const s=new Array(t);for(let n=0;n<t;n++)s[n]=e;return s}function checkIDs(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],e=JSON.parse(JSON.stringify(t)),s=[];for(const t of e){if(!("info"in t))throw new Error("each spectrum should contain info properties with nucleus information");const{info:e,id:n}=t;if(isSpectraData1D(t)){let i=addIDs(t.ranges);s.push({id:n,info:e,ranges:i})}else{let i=addIDs(t.zones);s.push({id:n,info:e,zones:i})}}return s}function hasIDs(t){for(const e of t){if(!e.id)throw new Error("A range/zone has not an ID");for(let t of e.signals||[])if(!t.id)throw new Error("A signal has not an ID")}}function addIDs(t){for(const e of t){e.id||(e.id=v4());for(let t of e.signals||[])t.id||(t.id=v4())}return hasIDs(t),t}function formatData(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],e=JSON.parse(JSON.stringify(t)),s=[];for(const t of e){const{id:e,info:n}=t;if(isSpectraData1D(t)){const i=rescaleIntegration({id:e,info:n,ranges:t.ranges});s.push({id:e,info:n,ranges:{values:i}})}else s.push({id:e,info:n,zones:{values:t.zones}})}return s}function rescaleIntegration(t){if("1H"!==t.info.nucleus)return t.ranges;let e=t.ranges.reduce(((t,e)=>e.integration?t+e.integration:t),0);for(let s of t.ranges)if(s.integration&&(s.integration*=100/e,s.signals)){const t=s.signals.reduce(((t,e)=>e.integration?t+e.integration:t),0);for(let e of s.signals)e.integration?e.integration*=s.integration/t:e.integration=s.integration}return t.ranges}function getIntegrationOfAttachedProtons(t,e){const{H:s=[]}=t.attachment;let n=0;for(const t of s){const s=e[t];n+=Number(s.link[0].signal.integration)}return n}function getTargetsAndCorrelations(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{tolerance:s={C:.25,H:.05}}=e,n=formatData(t),{values:i}=buildCorrelationData(n,{tolerance:s});let o={};for(const t of i){if(t.pseudo)continue;const{id:e,atomType:s}=t;o[s]||(o[s]={}),o[s][e]=t,o[s][e].integration="H"===s?t.link[0].signal.integration:getIntegrationOfAttachedProtons(t,i)}return{targets:o,correlations:i}}function getWorkFlow(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[];const s=extractExperimentType(t),{hasHSQC:n,types:i}=s;if(e.length>0)return{assignmentOrder:e,experimentTypes:s};const o=[];return n?o.push(["C"],["H"]):o.push(i.filter((t=>"H"===t||"C"===t))),{assignmentOrder:o,experimentTypes:s}}function extractExperimentType(t){const e=[];for(const s of t){let t=s.experimentType;"1d"===t&&(t=`${s.atomType.toUpperCase()}`),e.includes(t)||e.push(t);for(const n of s.link)t=n.experimentType,"1d"===t&&(t=`${n.atomType[0].toUpperCase()}`),e.includes(t)||e.push(t)}return{types:e,hasProton:e.includes("H"),hasCarbon:e.includes("C"),hasHSQC:e.includes("hsqc")}}async function getAssignments(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{restrictionByCS:s={},justAssign:n,minScore:i=.01,maxSolutions:o=10,nbAllowedUnAssigned:a,timeout:l=6e3,predictionOptions:r={},predictions:m={},correlation:g={}}=e;const{tolerance:u={H:.2,C:1},useChemicalShiftScore:c=!1,chemicalShiftRestriction:C=!0}=s,f=t.molecule;if(!f)throw new Error("It is needed a molecule to assign");f.addImplicitHydrogens(),addDiastereotopicMissingChirality(f);const h=checkIDs(t.spectra),{targets:p,correlations:d}=getTargetsAndCorrelations(h,g),{assignmentOrder:y}=getWorkFlow(d,n),H=await buildAssignments({restrictionByCS:{tolerance:u,useChemicalShiftScore:c,chemicalShiftRestriction:C},spectra:h,molecule:f,timeout:l,minScore:i,maxSolutions:o,assignmentOrder:y,nbAllowedUnAssigned:a,correlations:d,targets:p,predictionOptions:r,predictions:m});return H}function signalMultiplicityPattern(t){let e=t.js,s="";if(e&&e.length>0)for(let t of e)s+=t.multiplicity;else s=t.delta?"s":"m";return s}const globalOptions={h:{nucleus:"1H",nbDecimalDelta:2,nbDecimalJ:1,observedFrequency:400},c:{nucleus:"13C",nbDecimalDelta:1,nbDecimalJ:1,observedFrequency:100},f:{nucleus:"19F",nbDecimalDelta:2,nbDecimalJ:1,observedFrequency:400}};function rangesToACS(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};e.nucleus||(e.nucleus="1H");const s=e.nucleus.toLowerCase().replace(/[0-9]/g,""),n=globalOptions[s];e={...n,ascending:!1,format:"IMJA",...e},t=JSON.parse(JSON.stringify(t)),!0===e.ascending&&t.sort(((t,e)=>Math.min(t.from,t.to)-Math.min(e.from,e.to)));let i=formatAcs(t,e);return i.length>0&&(i+="."),i}function formatAcs(t,e){let s=spectroInformation(e);0===s.length&&(s="δ ");const n=[];for(const s of t)uselessKind(s.kind,e.filter)||pushDelta(s,n,e);return n.length>0?s+n.join(", "):""}function spectroInformation(t){const e=[];let s=`${formatNucleus(t.nucleus)} NMR`;return t.solvent&&e.push(formatMF(t.solvent)),t.observedFrequency&&e.push(`${(1*t.observedFrequency).toFixed(0)} MHz`),e.length>0?s+=` (${e.join(", ")}): δ `:s+=": δ ",s}function pushDelta(t,e,s){let n="",i=[];const o=[t.from,t.to];if(t.signals&&(t.signals=t.signals.filter((t=>!uselessKind(t.kind,s.filter)))),t.signals&&t.signals.length>0){let e=t.signals;if(e.length>1){!0===s.ascending&&e.sort(((t,e)=>t.delta-e.delta)),n+=`${Math.min(...o).toFixed(s.nbDecimalDelta)}-${Math.max(...o).toFixed(s.nbDecimalDelta)}`,n+=` (${getIntegral(t,s)}`;for(let t of e){i=[],void 0!==t.delta&&(n=appendSeparator(n),n+=t.delta.toFixed(s.nbDecimalDelta));switchFormat({from:Number.MIN_SAFE_INTEGER,to:Number.MAX_SAFE_INTEGER},t,i,s),i.length>0&&(n+=` (${i.join(", ")})`)}n+=")"}else i=[],void 0!==e[0].delta?(n+=e[0].delta.toFixed(s.nbDecimalDelta),switchFormat(t,e[0],i,s),i.length>0&&(n+=` (${i.join(", ")})`)):(n+=`${Math.min(...o).toFixed(s.nbDecimalDelta)}-${Math.max(...o).toFixed(s.nbDecimalDelta)}`,switchFormat(t,e[0],i,s),i.length>0&&(n+=` (${i})`))}else{n+=`${Math.min(...o).toFixed(s.nbDecimalDelta)}-${Math.max(...o).toFixed(s.nbDecimalDelta)}`;switchFormat(t,{},i,s),i.length>0&&(n+=` (${i.join(", ")})`)}e.push(n)}function getIntegral(t,e){let s="";if(t.pubIntegral)s=String(t.pubIntegral);else if(t.integration){const{nucleus:n}=e;s=t.integration.toFixed(0)+n[n.length-1]}return s}function pushIntegral(t,e,s){let n=getIntegral(t,s);n.length>0&&e.push(n)}function pushmultiplicityFromSignal(t,e){let s=t.multiplicity;if(!s){s=signalMultiplicityPattern(signalJoinCouplings(t,{tolerance:.05,ignoreDiaIDs:!0}))}s.length>0&&e.push(s)}function switchFormat(t,e,s,n){for(const i of n.format)switch(i.toUpperCase()){case"I":pushIntegral(t,s,n);break;case"M":pushmultiplicityFromSignal(e,s);break;case"A":pushAssignment(e,s);break;case"J":pushCoupling(e,s,n);break;default:throw new Error(`Unknow format letter: ${i}`)}}function formatMF(t){return t.replace(/(?<num>[0-9]+)/g,"<sub>$<num></sub>")}function formatNucleus(t){return t.replace(/(?<num>[0-9]+)/g,"<sup>$<num></sup>")}function appendSeparator(t){return t.length>0&&!/ $/.exec(t)&&!/\($/.exec(t)&&(t+=", "),t}function formatAssignment(t){return t=(t=t.replace(/(?<num>[0-9]+)/g,"<sub>$<num></sub>")).replace(/"(?<i>[^"]*)"/g,"<i>$<i></i>")}function pushCoupling(t,e,s){if(Array.isArray(t.js)&&t.js.length>0){t.js.sort(((t,e)=>e.coupling-t.coupling));let n=[];for(let e of t.js)void 0!==e.coupling&&n.push(e.coupling.toFixed(s.nbDecimalJ));n.length>0&&e.push(`<i>J</i> = ${n.join(", ")} Hz`)}}function pushAssignment(t,e){t.assignment&&e.push(formatAssignment(t.assignment))}function uselessKind(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"",e=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];return t=t.toLowerCase(),!(!e||"impurity"!==t&&"solvent"!==t)}function addDummySignals(t){let e=JSON.parse(JSON.stringify(t)),s=t.reduce(((t,e)=>{const{atoms:s=[]}=e;return Math.max(...s)>t?Math.max(...s):t}),0)+1;return t.forEach(((n,i)=>{const{js:o=[],atoms:a=[s++]}=n;let{newCouplings:l,tempSignals:r}=checkCouplings(o,e,a,s+t.length);r.length>0&&e.push(...r),e[i].js=l,e[i].atoms=a})),e.sort(((t,e)=>t.delta-e.delta))}function checkCouplings(t,e,s,n){let i=[];return{newCouplings:t.reduce(((t,e)=>{const{atoms:o=[],multiplicity:a,coupling:l}=e;if(0===o.length)if(l&&a){const t=couplingPatterns.indexOf(a);for(let e=0;e<t;e++)n++,i.push(formatSignal(l,[n],s))}else t.push(e);return t}),[]),tempSignals:i}}function formatSignal(t,e,s){return{delta:1e5,atoms:e,js:[{coupling:t,atoms:s}]}}function hackSignalsToXY(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},s=addDummySignals(t);return signalsToXY(s,e)}function checkForSignals(t){for(let e of t)if(!e.signals)throw new Error("range has not signals")}const defaultFromTo=function(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"";return"13C"===t.toUpperCase()?{from:-5,to:206}:{from:-.5,to:10.5}};function rangesToXY(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};checkForSignals(t);let{frequency:s=400,lineWidth:n=1,nbPoints:i=16384,shape:o={kind:"gaussian"}}=e;const a=(t,e)=>{for(let s=0;s<i;s++)t[s]+=e[s]},{from:l,to:r}=getFromTo(t,e),m={to:r,from:l,nbPoints:i,shape:o,lineWidth:n,frequency:s};let g=new Float64Array(i);for(const e of t){const{integration:t,signals:s=[]}=e,{multiplicity:n=""}=e;if("m"===n&&s.length<1){const{from:t,to:n}=e;s.push({delta:(t+n)/2,multiplicity:"m"})}let o=new Float64Array(i);for(const t of s){const{multiplicity:e}=t;let s="m"===e||"b"===e||"br s"===e?broadPeakOrMultipletSpectrum([t],m).y:hackSignalsToXY([t],m).y;normalizeSpectrum(s,[t]),a(o,s)}e.integration&&normalizeSpectrum(o,s,{integration:t}),a(g,o)}return{x:xSequentialFill({from:l,to:r,size:i}),y:g}}function broadPeakOrMultipletSpectrum(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{lineWidth:s,frequency:n}=e,i=new SpectrumGenerator(e),o=3*s/n;for(let e of t){const{multiplicity:t,delta:a,integration:l=1}=e;if("b"===t||"br s"===t)i.addPeak({x:a,y:l,width:o});else{const t=peaksOfMultiplet(a,{lineWidth:s,frequency:n});i.addPeaks(t)}}return i.getSpectrum()}function peaksOfMultiplet(t,e){const{frequency:s,lineWidth:n,intensities:i=[1,2,5,4,5,7,5,4,5,2,1]}=e,o=n/s,a=1.5*o,l=[],r=t-a*i.length/2;for(let t=0;t<i.length;t++)l.push({x:r+a*t,y:i[t],width:o});return l}function normalizeSpectrum(t,e){let s=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};const{integration:n=e.reduce(((t,e)=>{const{integration:s=1}=e;return t+s}),0)}=s,i=t.reduce(((t,e)=>t+e),0);if(0!==i){const e=n/i*1e6;for(let s=0;s<t.length;s++)t[s]*=e}}function getFromTo(t,e){const{from:s,to:n}=defaultFromTo(e.nucleus);let i=Number.MAX_SAFE_INTEGER,o=Number.MIN_SAFE_INTEGER;for(const e of t)for(const t of e.signals||[])i>t.delta&&(i=t.delta),o<t.delta&&(o=t.delta);const{from:a=Math.min(i-.5,s),to:l=Math.max(o+.5,n)}=e;return{from:a,to:l}}function directOptimization(t,e,s){const{minValues:n,maxValues:i,directOptions:o={}}=s,a=direct(getObjectiveFunction(t,e),n,i,o),{optima:l}=a;return{error:a.minFunctionValue,iterations:a.iterations,parameterValues:l[0]}}function getObjectiveFunction(t,e){const{x:s,y:n}=t,i=s.length;return t=>{const o=e(t);let a=0;for(let t=0;t<i;t++)a+=Math.pow(n[t]-o(s[t]),2);return a}}const defaultParameters={delta:{init:t=>t.signal.delta,min:t=>t.signal.delta-2*t.shape.fwhm,max:t=>t.signal.delta+2*t.shape.fwhm,gradientDifference:()=>.002},intensity:{init:t=>t.signal.intensity||1,min:()=>0,max:()=>1.5,gradientDifference:()=>.001},fwhm:{init:t=>t.shape.fwhm,min:t=>.25*t.shape.fwhm,max:t=>4*t.shape.fwhm,gradientDifference:t=>.002*t.shape.fwhm},mu:{init:t=>t.shape.mu||.5,min:()=>0,max:()=>1,gradientDifference:()=>.01},coupling:{init:t=>t.jCoupling.coupling,min:t=>.8*t.jCoupling.coupling,max:t=>1.2*t.jCoupling.coupling,gradientDifference:()=>.01}};function signalsToPointXY(t,e){const{frequency:s,maxClusterSize:n=1}=e,i=signalsToSpinSystem(addDummySignals(t));i.clusters=splitSpinSystem(i,{frequency:s,maxClusterSize:n});const o=simulateXYPeaks(i,e).filter((t=>t.x<1e3)),a=o.reduce(((t,e)=>e.y>t?e.y:t),Number.MIN_SAFE_INTEGER);for(const t of o)t.y/=a;return o}const properties=["init","min","max","gradientDifference"];function getInternalSignals(t,e,s,n){var i,o;let a=0,l=[];const{shape:r={kind:"gaussian"},baseline:m=s.min,lineWidth:g=1,frequency:u}=n,c=normalizeSignals({signals:e,data:t,shiftValue:m,frequency:u,range:s.range});for(const t of c){const{shape:e={...r}}=t;e.fwhm||(e.fwhm=g),e.fwhm/=u;const m=getShape1D(e),c=["delta","intensity",...m.getParameters()],C={min:[],max:[],init:[],gradientDifference:[]};for(const e of c)for(const n of properties)C[n].push(getPropertyValue({signal:t,frequency:u,parameter:e,property:n,minMaxY:s,shapeFct:m}));for(const e of t.js||[])for(const t of properties){const a="coupling";let l=null===(o=null===(i=null==n?void 0:n.parameters)||void 0===i?void 0:i[a])||void 0===o?void 0:o[t];if(l)if("number"==typeof l)C[t].push(getNormalizedValue(l,a,t,s,u,n.baseline));else{let i=l({jCoupling:e});C[t].push(getNormalizedValue(i,a,t,s,u,n.baseline))}if(!defaultParameters[a])throw new Error(`No default parameter for ${a}`);const r=defaultParameters[a][t];C[t].push(r({jCoupling:e}))}const f=a,h=f+c.length-1,p=h+1,d=p+t.js.length-1;a+=d-f+1,l.push({shape:e,shapeFct:m,signal:t,parameters:c,propertiesValues:C,fromIndex:f,toIndex:h,fromIndexCoupling:p,toIndexCoupling:d})}return l}function normalizeSignals(t){const{signals:e,data:s,frequency:n,shiftValue:i,range:o}=t,a=t=>{const e=signalsToPointXY([t],{frequency:n,maxClusterSize:1}),i=e.reduce(((t,e)=>e.y>t.y?e:t),e[0]),{y:o}=xyFindClosestPoint(s,i.x);return o};return e.map((t=>{const{intensity:e=a(t)}=t;return{...t,js:t.js||[],intensity:(e-i)/o}}))}function getPropertyValue(t){var e,s,n,i;const{signal:o,frequency:a,parameter:l,property:r,minMaxY:m,shapeFct:g}=t;let u=null===(s=null===(e=null==o?void 0:o.parameters)||void 0===e?void 0:e[l])||void 0===s?void 0:s[r];if(u)return getNormalizedValue(u,l,r,m,a,t.baseline);let c=null===(i=null===(n=null==t?void 0:t.parameters)||void 0===n?void 0:n[l])||void 0===i?void 0:i[r];if(c){if("number"==typeof c)return getNormalizedValue(c,l,r,m,a,t.baseline);return getNormalizedValue(c(o),l,r,m,a,t.baseline)}if(!defaultParameters[l])throw new Error(`No default parameter for ${l}`);return(0,defaultParameters[l][r])({signal:o,shape:g})}function getNormalizedValue(t,e,s,n,i,o){return"intensity"===e?"gradientDifference"===s?t:void 0!==o?(t-o)/n.range:(t-n.min)/n.range:"fwhm"===e?t/i:t}const defaultSimulationOptions={maxClusterSize:1};function getSumOfShapes(t,e){const s={...defaultSimulationOptions,...e};return function(e){const n=[];for(const i of t){const t=e[i.fromIndex],o=e[i.fromIndex+1];for(let t=2;t<i.parameters.length;t++)i.shapeFct[i.parameters[t]]=e[i.fromIndex+t];const a=i.signal.js;for(let t=0;t<a.length;t++)a[t].coupling=e[i.fromIndexCoupling+t];const l=signalsToPointXY([{delta:t,js:a}],s);n.push(...l.map((t=>({intensity:o,shape:i.shapeFct,...t}))))}return t=>{let e=0;for(let s of n){const{x:n,y:i,intensity:o,shape:a}=s;e+=i*o*a.fct(t-n)}return e}}}const defaultLMOptimizationOptions={damping:1.5,maxIterations:100,errorTolerance:1e-8},defaultDirectOptimizationOptions={iterations:25};function optimizeSignals(t,e,s){const{optimization:n={},simulation:i,...o}=s;let a=xMinMaxValues(t.y);const l={...a,range:a.max-a.min},r=getInternalSignals(t,e,l,{frequency:i.frequency,...o}),{baseline:m=l.min}=s;let g=new Float64Array(t.y.length);for(let e=0;e<t.y.length;e++)g[e]=(t.y[e]-m)/l.range;const u=r[r.length-1].toIndexCoupling+1,c=new Float64Array(u),C=new Float64Array(u),f=new Float64Array(u),h=new Float64Array(u);let p=0;for(const t of r){for(let e=0;e<t.parameters.length;e++)c[p]=t.propertiesValues.min[e],C[p]=t.propertiesValues.max[e],f[p]=t.propertiesValues.init[e],h[p++]=t.propertiesValues.gradientDifference[e];for(let e=t.parameters.length;e<t.parameters.length+t.signal.js.length;e++)c[p]=t.propertiesValues.min[e],C[p]=t.propertiesValues.max[e],f[p]=t.propertiesValues.init[e],h[p++]=t.propertiesValues.gradientDifference[e]}const d=getSumOfShapes(r,i),{kind:y,options:H}=n,[v,b]="direct"===y?[directOptimization,defaultDirectOptimizationOptions]:[levenbergMarquardt,defaultLMOptimizationOptions];const w=v({x:t.x,y:g},d,{minValues:c,maxValues:C,initialValues:f,gradientDifference:h,...b,...H}).parameterValues,O=[];for(const t of r){const{fromIndexCoupling:e}=t,s=t.signal.js.map(((t,s)=>(t.coupling=w[e+s],t))),n=w[t.fromIndex],o=signalsToPointXY([{delta:n,js:s}],i),a=w[t.fromIndex+1]*l.range+m,r=[];for(const{x:e,y:s}of o){const n={id:v4(),x:e,y:a*s,width:0,shape:{...t.shape}};for(let e=2;e<t.parameters.length;e++)n.shape[t.parameters[e]]=w[t.fromIndex+e];n.shape.fwhm*=i.frequency,n.width=getShape1D(n.shape).fwhmToWidth(n.shape.fwhm),r.push(n)}O.push({delta:n,js:s,shape:{...r[0].shape},intensity:a,peaks:r})}return O}function applyWindow(t,e){const s=t.length,{windowData:n,start:i=0,length:o=s,pointsToShift:a=0,output:l=new Float64Array(t)}=e,r=Math.min(i+o,s-a);for(let t=i,e=0;t<r;t++)l[t]*=n[e++];for(let t=s-1,e=0;t>s-a-1;t--)l[t]*=n[e++];return l}function exponential(t){const{lb:e,dw:s}=t,n=-e*Math.PI*s;return t=>Math.exp(n*t)}function lorentzToGauss(t){const{dw:e,length:s,gaussianHz:n=0,exponentialHz:i=0,center:o=0}=t;if(o>1||o<0)throw new Error("The center of gaussian shape should be inside of the window function: 0 - 1");const a=Math.pow(.6*Math.PI*n*e,2),l=o*(s-1),r=Math.PI*e*i;return t=>Math.exp(t*r-Math.pow(l-t,2)*a)}function getFunction(t){const{kind:e,options:s}=t;switch(e){case"exponential":return exponential(s);case"lorentzToGauss":return lorentzToGauss(s);default:throw Error(`Unknown distribution ${e}`)}}function getData(t,e){const s=new Float64Array(e);let n=Number.MIN_SAFE_INTEGER;for(let i=0;i<e;i++){const e=t(i);s[i]=e,e>n&&(n=e)}for(let t=0;t<e;t++)s[t]/=n;return s}function compose(t){const{length:e,shapes:s=[]}=t;let n=new Float64Array(e).fill(1);return s.forEach((t=>{const{shape:s,start:i=0}=t,{options:o}=s,a="length"in o?o.length:e-i,l=getData(getFunction(s),a);applyWindow(n,{windowData:l,length:a,start:i,output:n})})),n}function apodization(t,e){const{compose:s,pointsToShift:n}=e,i=compose(s),o={windowData:i,pointsToShift:n};return{re:applyWindow(t.re,o),im:applyWindow(t.im,o),windowData:i}}const twoPi=2*Math.PI;function signalsToFID(t,e){const{lb:s=1,from:n=0,to:i=10,nbPoints:o=1024,frequency:a=400,maxClusterSize:l=8}=e;let r=signalsToSpinSystem(t);r.clusters=splitSpinSystem(r,{frequency:a,maxClusterSize:l});const m=simulateXYPeaks(r,{frequency:a}),g=new Float64Array(o),u=new Float64Array(o),c=o/(Math.abs(i-n)*a),C=xSequentialFill({size:o,from:0,to:c});for(const t of m){const{x:e,y:s}=t,n=e*a*twoPi;for(let t=0;t<o;t++)g[t]+=s*Math.cos(n*C[t]),u[t]+=s*Math.sin(n*C[t])}const{windowData:f,...h}=apodization({re:g,im:u},{pointsToShift:0,compose:{length:o,shapes:[{start:0,shape:{kind:"exponential",options:{dw:c/(o-1),lb:s}}}]}});return h}function splitParenthesis(t){const e=/ *(?<before>[^(]*?) *\( *(?<inside>.*?) *\) *(?<after>.*?) */.exec(t);return e?e.groups:{before:t,inside:"",after:""}}function splitPatterns(t){if(/^\s*$/.exec(t))return[];let e=t.match(/ *(quint|hex|sept|hept|oct|nona|non|s|d|t|q|h|o|n) */g);return e?e.map((t=>t.trim())):[t]}function resurrectRange(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{nucleus:s="1h",frequency:n=400}=e,i=splitParenthesis(t);if(!i.before)return;const o=/.*?(?<from>-?[0-9.]+)-?(?<to>-?[0-9.]*).*/.exec(i.before);if(!o||!o.groups)return;const a=""!==o.groups.to,l=Number(o.groups.from),r=a?Number(o.groups.to):l,m=i.inside.split(/ *, */);let g={delta:NaN,js:[]},u={from:l,to:r,signals:[g]};const c=m.filter((t=>t.match(/^[0-9]+H$/)));1===c.length&&(u.integration=Number(c[0].replace("H","")));const C=m.filter((t=>t.match(/^[a-zA-Z]+$/)));if(1===C.length){const t=C[0];"m"===t?a?(g.delta=(l+r)/2,g.multiplicity=t):(g.delta=l,g.multiplicity=t):a||(g.delta=l,g.multiplicity=t)}const f=m.filter((t=>t.match(/(Hz|J|^[0-9.]+$)/))).map((t=>Number(t.replace(/[^0-9.]/g,"")))),h=splitPatterns(g.multiplicity||"");if(h.length===f.length)for(let t=0;t<h.length;t++){if(!g.js)throw new Error("signal has not js");g.js.push({coupling:f[t],multiplicity:h[t]})}return u.from===u.to&&(u={...u,...rangeFromSignal(g,{nucleus:s,frequency:n})}),u}function resurrect(t){const e={experiment:{},ranges:[],acsString:t,normalized:t.replace(/[\r\n\t]/g," ").replace(/[;:]/g,",").replace(/\}/g,")").replace(/\{/g,"(").replace(/[\u2011\u2012\u2013\u2014\u2015\u2212]/g,"-")};return createParts(e),parseParts(e),e}function parseParts(t){for(const e of t.parts)if(e.toLowerCase().includes("nmr"))processExperiment(t,e);else{const{frequency:s,nucleus:n}=t.experiment,i=resurrectRange(e,{frequency:s,nucleus:n});i&&t.ranges.push(i)}}function processExperiment(t,e){const s=splitParenthesis(e),n=s.before.replace(/[ -]*nmr[ -]*/i,"").replace(/[ -]/g,"");if(/^[0-9]+[A-Z][a-z]?$/.exec(n)&&(t.experiment.nucleus=n),/^[A-Z][a-z]?[0-9]+$/.exec(n)&&(t.experiment.nucleus=n.replace(/^([A-Z][a-z]?)([0-9]+)$/,"$2$1")),s.inside){const e=s.inside.split(/[,]/),n=e.filter((t=>/[0-9]{2}/.exec(t)));if(n.length){const e=n[0].replace(/[^0-9]/g,"");e.length>1&&(t.experiment.frequency=Number(e))}const i=e.filter((t=>!t.match(/[0-9]{2}/)));i.length&&(t.experiment.solvent=i[0])}}function createParts(t){const e=t.normalized.split(/\)(?![^()]*\))/).map((t=>t.replace(/^\s*(.*?)\s*$/,"$1"))).filter((t=>t)).map((t=>`${t})`)).map((t=>t.split(/[,;](?![^()]*\))/))).flat().map((t=>t.replace(/^\s*(.*?)\s*$/,"$1"))).filter((t=>t));t.parts=e}function convertWidthToHz(t,e){return convertWidth(t,{...e,convertTo:"hz"})}function xyAutoPeaksPicking(t,e){const{from:s,to:n,frequency:i,noiseLevel:o,thresholdFactor:a=3,minMaxRatio:l=.05,broadRatio:r=25e-5,useSanPlot:m=!1,smoothY:g=!0,optimize:u=!1,factorLimits:c=4,realTopDetection:C=!0,shape:f={kind:"gaussian"},optimization:h={kind:"lm"},broadWidth:p=.25,sgOptions:d={},direction:y="positive"}=e,{windowSize:H=9,polynomial:v=3}=d;if(t.x.length<H)return[];void 0!==s&&void 0!==n&&(t=xyExtract(t,{zones:[{from:s,to:n}]}));const b=getCutOff(t.y,{noiseLevel:o,useSanPlot:m,thresholdFactor:a});let w={shape:f,frequency:i,broadWidth:p,optimize:u,factorLimits:c,maxCriteria:!0,sgOptions:{windowSize:H,polynomial:v},minMaxRatio:l,broadRatio:r,noiseLevel:b.positive,smoothY:g,optimization:h,realTopDetection:C};switch(y){case"positive":return getPeakList(t,w);case"negative":return getNegativePeaks(t,b,w);case"both":return[...getPeakList(t,w),...getNegativePeaks(t,b,w)];default:throw Error(`Unknown distribution ${y}`)}}function getNegativePeaks(t,e,s){return s.noiseLevel=e.negative,s.maxCriteria=!1,getPeakList(t,s)}function getPeakList(t,e){const{shape:s,frequency:n,broadWidth:i,optimize:o,maxCriteria:a,factorLimits:l,sgOptions:r,minMaxRatio:m,broadRatio:g,noiseLevel:u,smoothY:c,optimization:C,realTopDetection:f}=e,h=gsd(t,{sgOptions:r,maxCriteria:a,minMaxRatio:m,noiseLevel:u,smoothY:c,realTopDetection:f}),p=setShape(h,{output:h,shape:s}),d=i?joinBroadPeaks(p,{broadRatio:g,broadWidth:i,shape:s,optimization:C}).map(toNMRPeak1DStructure):p.map(toNMRPeak1DStructure);return convertWidthToHz(o?optimizePeaks(t,d,{shape:s,factorLimits:l,optimization:C}).map(toNMRPeak1DStructure):d,{frequency:n})}function getCutOff(t,e){const{noiseLevel:s,useSanPlot:n,thresholdFactor:i}=e,o=t=>"number"==typeof t?{positive:t,negative:-t}:t;return s?o(s):n?xNoiseSanPlot(t,{factorStd:i}):o(xAbsoluteMedian(t)*i)}function toNMRPeak1DStructure(t){const{id:e,shape:s,x:n,y:i,width:o}=t;return{id:e,x:n,y:i,width:o,shape:s}}function joinRanges(t){t.sort(((t,e)=>t.from-e.from));for(let e=0;e<t.length-1;e++){const s=t[e],n=t[e+1];s.to>n.from&&(s.id=v4(),s.to=Math.max(n.to,s.to),s.signals&&n.signals&&(s.signals=s.signals.concat(n.signals)),void 0!==s.integration&&(s.integration+=n.integration||0),t.splice(e+1,1),e--)}return t}const patterns=["s","d","t","q","quint","h","sept","o","n"];let symRatio=1.5,maxErrorIter1=2.5,maxErrorIter2=1,jAxisKeys={jAxis:"x",intensity:"intensity"};function checkSignalForCompilePattern(t){if(!("symRank"in t))throw new Error("Internal error, symRank was not calculated");if(!("mask"in t))throw new Error("Internal Error, mask was not added")}var jAnalyzer={compilePattern:function(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{jAxisKey:s=jAxisKeys}=e;const n=symmetrizeChoiseBest(t,{maxError:maxErrorIter1,iteration:1,jAxisKey:s});if(n.multiplicity="m",n.asymmetric=!0,checkSignalForCompilePattern(n),n.symRank>=.95&&n.peaksComp.length<32){let t,e,s;n.asymmetric=!1;let i=1,o=[];for(let a=0;a<9;a++){let l=normalize(n,a),r=!1;if(1===l.length&&0===a)r=!0;else if(l.length<=1)continue;let m=getRanges(l);e=Math.pow(2,a);let g=null,u=1;for(;!r&&null!==(g=getNextCombination(m,e))&&u<400;){let e=new Array(g.length);i=1;for(let t=0;t<g.length;t++){e[t]=new Array(g[t]);for(let s=0;s<g[t];s++)e[t][s]=i++}o=[];let n=1;o.push(l[1].x-l[0].x),t=l[0].x,e[0].splice(0,1),e[1].splice(0,1),i=1;let m=2;for(s=Math.pow(2,a)-1;o.length<a&&m<s&&i<l.length;){for(u+=1,n++;i<l.length&&0===e[i].length;)i++;if(i<l.length){o.push(l[i].x-l[0].x),e[i].splice(0,1),m++;for(let s=2;s<=n;s++){let n=0;for(let t=0;t<s;t++)n+=o[t];for(let s=1;s<e.length;s++)if(Math.abs(l[s].x-(t+n))<.25){e[s].splice(0,1),m++;break}}}}let c=idealPattern(o);r=!0;for(let t=0;t<c.length;t++)c[t].intensity!==g[t]&&(r=!1)}r&&updateSignal(n,o)}}for(let t of n.peaksComp)t.x/=n.observe,t.width*=n.observe;return n}};function updateSignal(t,e){let s=t.peaksComp,n=s.length;t.startX=s[0].x/t.observe-s[0].width,t.stopX=s[n-1].x/t.observe+s[n-1].width,t.integralData.from=s[0].x/t.observe-3*s[0].width,t.integralData.to=s[n-1].x/t.observe+3*s[n-1].width,t.maskPattern=t.mask2,t.multiplicity=abstractPattern(t,e),t.pattern=t.multiplicity}function abstractPattern(t,e){let s="",n=1,i=[];if(e&&e.length>0){e.sort(((t,e)=>e-t));for(let t=0;t<e.length-1;t++)Math.abs(e[t]-e[t+1])<.05?n++:(i.push({coupling:Math.abs(e[t]),multiplicity:patterns[n]}),s+=patterns[n],n=1);let o=e.length-1;i.push({coupling:Math.abs(e[o]),multiplicity:patterns[n]}),s+=patterns[n],t.nmrJs=i}else s="s",Math.abs(t.startX-t.stopX)*t.observe>16&&(s="br s");return s}function idealPattern(t){let e=[{x:0,intensity:Math.pow(2,t.length)}];for(const s of t)for(let t=e.length-1;t>=0;t--)e.push({x:e[t].x+s/2,intensity:e[t].intensity/2}),e[t].x=e[t].x-s/2,e[t].intensity=e[t].intensity/2;e.sort(((t,e)=>t.x-e.x));for(let t=e.length-2;t>=0;t--)Math.abs(e[t].x-e[t+1].x)<.1&&(e[t].intensity+=e[t+1].intensity,e.splice(t+1,1));return e}function getNextCombination(t,e){let s,n=Math.ceil(.5*t.values.length),i=t.values.length,o=0;for(;o!==e;){for(s=!1;!s;)if(s=!0,t.currentIndex[t.active]++,t.currentIndex[t.active]>=t.values[t.active].length){if(t.active+1===n)return null;t.currentIndex[t.active]=0,s=!1,t.active++}else t.active=0;o=0;for(let e=0;e<n;e++)o+=2*t.values[e][t.currentIndex[e]];t.values.length%2!=0&&(o-=t.values[n-1][t.currentIndex[n-1]])}if(o===e){let e=new Array(i);for(let s=0;s<n;s++)e[s]=t.values[s][t.currentIndex[s]],e[i-s-1]=t.values[s][t.currentIndex[s]];return e}return null}function getRanges(t){let e,s,n=new Array(t.length),i=new Array(t.length);n[0]=[1],n[t.length-1]=[1],i[0]=-1,i[t.length-1]=0;for(let o=1;o<t.length-1;o++){e=Math.round(.85*t[o].intensity),s=Math.round(1.15*t[o].intensity),n[o]=[];for(let t=e;t<=s;t++)n[o].push(t);i[o]=0}return{values:n,currentIndex:i,active:0}}function symmetrizeChoiseBest(t,e){let{maxError:s,iteration:n,jAxisKey:i=jAxisKeys}=e,o=symmetrize(t,s,n,i);if(!o.peaksComp)throw new Error("internal peaksComp was not created");let a=o.peaksComp,l=o.mask,r=t.delta;t.delta=(t.peaks[0].x+t.peaks[t.peaks.length-1].x)/2;let m=symmetrize(t,s,n,i);if(!m.peaksComp)throw new Error("internal peaksComp was not created");return m.peaksComp.length>a.length?m:(t.delta=r,t.peaksComp=a,t.mask=l,o)}function symmetrize(t,e,s,n){let{jAxis:i,intensity:o}=n;const a=JSON.parse(JSON.stringify(t));let l,r,m,g,u,c=new Array(a.peaks.length);for(let t=0;t<c.length;t++){let e=a.peaks[t];c[t]={x:e[i]*a.observe,intensity:e[o],width:e.width/a.observe}}for(let t=c.length-2;t>=0;t--)Math.abs(c[t].x-c[t+1].x)<.25&&(c[t].x=c[t].x*c[t].intensity+c[t+1].x*c[t+1].intensity,c[t].intensity=c[t].intensity+c[t+1].intensity,c[t].x/=c[t].intensity,c[t].intensity/=2,c[t].width+=c[t+1].width,c.splice(t+1,1));a.peaksComp=c;let C=c.length,f=new Array(C);a.mask=f;let h=0,p=c.length-1,d=a.delta*a.observe,y=[(c[0].x+c[C-1].x)/2,1];e=error(Math.abs(d-y[0]));let H=0;for(let t=0;t<C;t++)f[t]=!0,H+=c[t].intensity;for(;h<=p;){if(f[h]=!0,f[p]=!0,h===p)C>2&&Math.abs(c[h].x-d)>e&&(f[h]=!1);else if(l=Math.max(c[h].intensity,c[p].intensity),r=Math.min(c[h].intensity,c[p].intensity),g=l/r,g>symRatio)c[h].intensity===r?(f[h]=!1,p++):(f[p]=!1,h--);else{let t=Math.abs(c[h].x-d),s=Math.abs(c[p].x-d);Math.abs(t-s)<e?(m=Math.min(c[h].intensity,c[p].intensity),u=Math.min(c[h].width,c[p].width),c[h].intensity=m,c[p].intensity=m,c[h].width=u,c[p].width=u,y=[y[0]+(c[p].x+c[h].x)/2,y[1]+1]):Math.max(t,s)===s?(f[p]=!1,h--):(f[h]=!1,p++)}if(h++,p--,1===s&&(d=chemicalShift(c,f),isNaN(d)))return a.symRank=0,a;e=error(Math.abs(d-y[0]/y[1]))}for(let t=C-1;t>=0;t--)!1===f[t]&&c.splice(t,1);if(d=chemicalShift(c),isNaN(d))return a.symRank=0,a;a.delta=d/a.observe;let v=0,b=0;if(c.length>1){for(let t=Math.ceil(c.length/2)-1;t>=0;t--)v+=(3+Math.min(Math.abs(c[t].x-d),Math.abs(c[c.length-1-t].x-d)))/(3+Math.max(Math.abs(c[t].x-d),Math.abs(c[c.length-1-t].x-d)))*c[t].intensity,b+=c[t].intensity;v/=b}else 1===c.length&&(v=1);let w=0;for(const t of c)w+=t.intensity;if(v-=(H-w)/H*.12,v>.8&&v<.97&&s<2)return symmetrize(a,maxErrorIter2,2,n);if(c.length>1){let t;for(let e=Math.ceil(c.length/2)-1;e>=0;e--)t=(c[e].x-c[c.length-1-e].x)/2,c[e].x=d+t,c[c.length-1-e].x=d-t}return a.symRank=v,a}function error(t){let e=2.5*t;return e<.75&&(e=.75),e>3&&(e=3),e}function normalize(t,e){let s=JSON.parse(JSON.stringify(t.peaksComp)),n=0,i=0;for(let t of s)n+=t.intensity;n=Math.pow(2,e)/n,t.mask2=t.mask.slice();let o=t.mask2.length-1;for(let e=s.length-1;e>=0;e--){for(s[e].intensity*=n;o>=0&&!t.mask2[o];)o--;s[e].intensity<.75?(s.splice(e,1),t.mask2[o]=!1):i+=s[e].intensity,o--}i=Math.pow(2,e)/i;for(let t=s.length-1;t>=0;t--)s[t].intensity*=i;return s}function chemicalShift(t){let e,s=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[],n=0,i=0;if(s.length>0)for(let o=0;o<t.length;o++)s[o]&&(e=getArea(t[o]),n+=e,i+=e*t[o].x);else for(let s of t)e=getArea(s),n+=e,i+=e*s.x;return i/n}function getArea(t){return Math.abs(t.intensity*t.width*1.57)}function checkSignalAfterCompilePattern(t){if(!t.mask)throw new Error("Internal Error, mask was not added");if(!t.mask2)throw new Error("Internal Error, mask2 was not added");if(!t.maskPattern)throw new Error("Internal Error, maskPattern was not added")}const assignSignal=(t,e,s)=>({id:v4(),delta:NaN,nbPeaks:1,kind:"signal",startX:t.x-t.width/e,stopX:t.x+t.width/e,observe:e,nucleus:s,integralData:{from:t.x-3*t.width/e,to:t.x+3*t.width/e,value:0},peaks:[{x:t.x,intensity:t.y,width:t.width}]});function peaksToRanges(t,e){let s=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},{integrationSum:n=100,joinOverlapRanges:i=!0,clean:o=.4,compile:a=!0,integralType:l="sum",frequency:r=400,frequencyCluster:m=16,keepPeaks:g=!1,nucleus:u="1H"}=s,c={integrationSum:n,integralType:l,frequencyCluster:m,frequency:r,nucleus:u};if(0===e.length)return[];t.x[0]>t.x[1]&&(t.x=t.x.reverse(),t.y=t.y.reverse());let C=detectSignals(t,e,c);if(o)for(let t=0;t<C.length;t++)Math.abs(C[t].integralData.value)<o&&C.splice(t,1);if(a){let e,s;for(let n=0;n<C.length;n++){C[n]=jAnalyzer.compilePattern(C[n]);let i=C[n];if(i.maskPattern&&"m"!==i.multiplicity&&""!==i.multiplicity){checkSignalAfterCompilePattern(i),e=0,s=0;let n=[];for(let t=i.maskPattern.length-1;t>=0;t--)if(s+=computeArea(i.peaks[t],r),!i.maskPattern[t]){let s=i.peaks.splice(t,1)[0];n.push({x:s.x,y:s.intensity,width:s.width}),i.mask.splice(t,1),i.mask2.splice(t,1),i.maskPattern.splice(t,1),i.nbPeaks--,e+=computeArea(s,r)}if(n.length>0){e=e*i.integralData.value/s,i.integralData.value-=e;let o=[];for(let t=n.length-1;t>=0;t--)o.push(n[t]);c.integrationSum=Math.abs(e);let a=detectSignals(t,o,c);for(const t of a)C.push(t)}}}let i=0,o=0;for(const t of C)o+=Math.abs(Math.round(t.integralData.value));if(o!==n){i=n/o;for(const t of C)t.integralData.value*=i}}if(C.sort(((t,e)=>e.delta-t.delta)),o)for(let t=C.length-1;t>=0;t--)Math.abs(C[t].integralData.value)<o&&C.splice(t,1);let f=[];for(let t=0;t<C.length;t++){let e=C[t];const s={id:v4(),from:e.integralData.from,to:e.integralData.to,integration:e.integralData.value},n={delta:e.delta,kind:e.kind||"signal",multiplicity:e.multiplicity,integration:e.integralData.value};g&&(n.peaks=e.peaks.map((t=>{const e={y:t.intensity,...t};return delete e.intensity,e}))),e.nmrJs&&(n.js=e.nmrJs),s.signals=[n],f[t]=s}return i&&(f=joinRanges(f)),f}function detectSignals(t,e){let s,n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},{integrationSum:i=100,integralType:o="sum",frequencyCluster:a=16,frequency:l=400,nucleus:r="1H"}=n,m=assignSignal(e[0],l,r),g=[],u={x:Number.MIN_SAFE_INTEGER},c=0;a/=l;for(const t of e){if(Math.abs(t.x-u.x)>a)m=assignSignal(t,l,r),t.kind&&(m.kind=t.kind),g.push(m);else{let e=t.x+t.width/l;m.stopX=Math.max(m.stopX,e),m.startX=Math.min(m.startX,e),m.nbPeaks++,m.peaks.push({x:t.x,intensity:t.y,width:t.width}),m.integralData.from=Math.min(m.integralData.from,t.x-3*t.width/l),m.integralData.to=Math.max(m.integralData.to,t.x+3*t.width/l),t.kind&&(m.kind=t.kind)}u=t}for(let e of g){s=e.peaks;let n=e.integralData,i=0,a=0;for(const t of s){let e=computeArea(t,l);i+=t.x*e,a+=e}e.delta=i/a,n.value="sum"===o?xyIntegration(t,{from:n.from,to:n.to}):a,c+=n.value}if(i>0){let t=i/c;for(let e of g){e.integralData.value*=t}}return g}function computeArea(t,e){return Math.abs(t.intensity*t.width/e*1.57)}function xyAutoRangesPicking(t,e){let s=xyAutoPeaksPicking(t,e.peakPicking);return s=peaksFilterImpurities(s,e.impurities),peaksToRanges(t,s,e.ranges)}function xyPeaksOptimization(t,e,s){const{frequency:n}=s,i=optimizePeaks(t,convertWidthToPPM(e,{frequency:n}),s);return convertWidthToHz(i,{frequency:n,output:i})}var src={},fftlib={};!function(t){(function(){var e,s="0.3.0",n="2013-03";(e=t).toString=function(){return"version "+s+", released "+n};for(var i=0,o=null,a=null,l={init:function(t){if(0===t||0!=(t&t-1))throw new Error("init: radix-2 required");i=t,l._initArray(),l._makeBitReversalTable(),l._makeCosSinTable()},fft1d:function(t,e){l.fft(t,e,1)},ifft1d:function(t,e){var s=1/i;l.fft(t,e,-1);for(var n=0;n<i;n++)t[n]*=s,e[n]*=s},bt1d:function(t,e){l.fft(t,e,-1)},fft2d:function(t,e){for(var s=[],n=[],o=0,a=0;a<i;a++){o=a*i;for(var r=0;r<i;r++)s[r]=t[r+o],n[r]=e[r+o];l.fft1d(s,n);for(var m=0;m<i;m++)t[m+o]=s[m],e[m+o]=n[m]}for(var g=0;g<i;g++){for(var u=0;u<i;u++)o=g+u*i,s[u]=t[o],n[u]=e[o];l.fft1d(s,n);for(var c=0;c<i;c++)t[o=g+c*i]=s[c],e[o]=n[c]}},ifft2d:function(t,e){for(var s=[],n=[],o=0,a=0;a<i;a++){o=a*i;for(var r=0;r<i;r++)s[r]=t[r+o],n[r]=e[r+o];l.ifft1d(s,n);for(var m=0;m<i;m++)t[m+o]=s[m],e[m+o]=n[m]}for(var g=0;g<i;g++){for(var u=0;u<i;u++)o=g+u*i,s[u]=t[o],n[u]=e[o];l.ifft1d(s,n);for(var c=0;c<i;c++)t[o=g+c*i]=s[c],e[o]=n[c]}},fft:function(t,e,s){for(var n,l,r,m,g,u,c,C,f,h=i>>2,p=0;p<i;p++)p<(m=o[p])&&(g=t[p],t[p]=t[m],t[m]=g,g=e[p],e[p]=e[m],e[m]=g);for(var d=1;d<i;d<<=1){l=0,n=i/(d<<1);for(var y=0;y<d;y++){u=a[l+h],c=s*a[l];for(var H=y;H<i;H+=d<<1)C=u*t[r=H+d]+c*e[r],f=u*e[r]-c*t[r],t[r]=t[H]-C,t[H]+=C,e[r]=e[H]-f,e[H]+=f;l+=n}}},_initArray:function(){o="undefined"!=typeof Uint32Array?new Uint32Array(i):[],a="undefined"!=typeof Float64Array?new Float64Array(1.25*i):[]},_paddingZero:function(){},_makeBitReversalTable:function(){var t=0,e=0,s=0;for(o[0]=0;++t<i;){for(s=i>>1;s<=e;)e-=s,s>>=1;e+=s,o[t]=e}},_makeCosSinTable:function(){var t=i>>1,e=i>>2,s=i>>3,n=t+e,o=Math.sin(Math.PI/i),l=2*o*o,r=Math.sqrt(l*(2-l)),m=a[e]=1,g=a[0]=0;o=2*l;for(var u=1;u<s;u++)l+=o*(m-=l),r-=o*(g+=r),a[u]=g,a[e-u]=m;0!==s&&(a[s]=Math.sqrt(.5));for(var c=0;c<e;c++)a[t-c]=a[c];for(var C=0;C<n;C++)a[C+t]=-a[C]}},r=["init","fft1d","ifft1d","fft2d","ifft2d"],m=0;m<r.length;m++)e[r[m]]=l[r[m]];return e.bt=l.bt1d,e.fft=l.fft1d,e.ifft=l.ifft1d,e}).call(commonjsGlobal)}(fftlib);var FFT=fftlib,FFTUtils$1={DEBUG:!1,ifft2DArray:function(t,e,s){var n=new Array(e*s),i=e/2,o=2*(s-1);FFT.init(i);for(var a={re:new Array(i),im:new Array(i)},l=0;l<s;l++){for(var r=i-1;r>=0;r--)a.re[r]=t[2*r*s+l],a.im[r]=t[(2*r+1)*s+l];FFT.bt(a.re,a.im);for(r=i-1;r>=0;r--)n[2*r*s+l]=a.re[r],n[(2*r+1)*s+l]=a.im[r]}var m=new Array(i*o);FFT.init(o);var g={re:new Array(o),im:new Array(o)},u=o*i;for(r=0;r<e;r+=2){g.re[0]=n[r*s],g.im[0]=n[(r+1)*s];for(l=1;l<s;l++)g.re[l]=n[r*s+l],g.im[l]=n[(r+1)*s+l],g.re[o-l]=n[r*s+l],g.im[o-l]=-n[(r+1)*s+l];FFT.bt(g.re,g.im);var c=r/2*o;for(l=o-1;l>=0;l--)m[c+l]=g.re[l]/u}return m},fft2DArray:function(t,e,s,n){Object.assign({},{inplace:!0});var i=s/2+1,o=2*e,a=new Array(o*i);FFT.init(s);for(var l,r,m,g,u,c={re:new Array(s),im:new Array(s)},C={re:new Array(s),im:new Array(s)},f={re:new Array(s),im:new Array(s)},h=0;h<e/2;h++){l=2*h*s,c.re=t.slice(l,l+s),l=(2*h+1)*s,c.im=t.slice(l,l+s),FFT.fft1d(c.re,c.im),this.reconstructTwoRealFFT(c,C,f),r=4*h*i,m=(4*h+1)*i,g=(4*h+2)*i,u=(4*h+3)*i;for(var p=i-1;p>=0;p--)a[r+p]=C.re[p],a[m+p]=C.im[p],a[g+p]=f.re[p],a[u+p]=f.im[p]}C=null,f=null;var d=new Array(o*i);FFT.init(e);for(var y={re:new Array(e),im:new Array(e)},H=i-1;H>=0;H--){for(h=e-1;h>=0;h--)y.re[h]=a[2*h*i+H],y.im[h]=a[(2*h+1)*i+H],isNaN(y.re[h])&&(y.re[h]=0),isNaN(y.im[h])&&(y.im[h]=0);FFT.fft1d(y.re,y.im);for(h=e-1;h>=0;h--)d[2*h*i+H]=y.re[h],d[(2*h+1)*i+H]=y.im[h]}return d},reconstructTwoRealFFT:function(t,e,s){var n,i,o,a,l,r=t.re.length;e.re[0]=t.re[0],e.im[0]=0,s.re[0]=t.im[0],s.im[0]=0;for(var m=r/2;m>0;m--)l=r-m,n=.5*(t.re[m]-t.re[l]),i=.5*(t.re[m]+t.re[l]),o=.5*(t.im[m]-t.im[l]),a=.5*(t.im[m]+t.im[l]),e.re[m]=i,e.im[m]=o,e.re[l]=i,e.im[l]=-o,s.re[m]=a,s.im[m]=-n,s.re[l]=a,s.im[l]=n},convolute2DI:function(t,e,s,n){for(var i,o,a=0;a<s/2;a++)for(var l=0;l<n;l++)i=t[2*a*n+l]*e[2*a*n+l]-t[(2*a+1)*n+l]*e[(2*a+1)*n+l],o=t[2*a*n+l]*e[(2*a+1)*n+l]+t[(2*a+1)*n+l]*e[2*a*n+l],t[2*a*n+l]=i,t[(2*a+1)*n+l]=o},convolute:function(t,e,s,n,i){for(var o=new Array(n*s),a=0;a<s*n;a++)o[a]=t[a];o=this.fft2DArray(o,s,n);var l,r=e.length,m=e[0].length,g=new Array(n*s);for(a=0;a<n*s;a++)g[a]=0;for(var u=Math.floor((r-1)/2),c=Math.floor((m-1)/2),C=0;C<r;C++){l=(C-u+s)%s;for(var f=0;f<m;f++)g[l*n+(f-c+n)%n]=e[C][f]}g=this.fft2DArray(g,s,n);var h=2*s,p=n/2+1;return this.convolute2DI(o,g,h,p),this.ifft2DArray(o,h,p)},toRadix2:function(t,e,s){var n,i,o,a,l=s,r=e;if(0===s||0!=(s&s-1)){for(l=0;s>>++l!=0;);l=1<<l}if(0===e||0!=(e&e-1)){for(r=0;e>>++r!=0;);r=1<<r}if(r==e&&l==s)return{data:t,rows:e,cols:s};var m=new Array(r*l),g=Math.floor((r-e)/2)-e,u=Math.floor((l-s)/2)-s;for(n=0;n<r;n++)for(o=n*l,a=(n-g)%e*s,i=0;i<l;i++)m[o+i]=t[a+(i-u)%s];return{data:m,rows:r,cols:l}},crop:function(t,e,s,n,i,o){if(e==n&&s==i)return t;Object.assign({},o);var a,l,r,m,g=new Array(i*n),u=Math.floor((e-n)/2),c=Math.floor((s-i)/2);for(r=0;r<n;r++)for(a=r*i,l=(r+u)*s,m=0;m<i;m++)g[a+m]=t[l+(m+c)];return g}},FFTUtils_1=FFTUtils$1,FFTUtils=src.FFTUtils=FFTUtils_1;function matrix2Array(t){let e,s,n=t;if("number"!=typeof t[0]){e=t.length,s=t[0].length,n=new Array(e*s);for(let i=0;i<e;i++)for(let e=0;e<s;e++)n[i*s+e]=t[i][e]}else{let n=Math.sqrt(t.length);Number.isInteger(n)&&(e=n,s=n)}return{data:n,rows:e,cols:s}}function convolutionFFT(t,e,s){let n,i,o=matrix2Array(t),a=o.data,l=Object.assign({normalize:!1,divisor:1,rows:o.rows,cols:o.cols},s);if(!l.rows||!l.cols)throw new Error(`Invalid number of rows or columns ${n} ${i}`);n=l.rows,i=l.cols;let r=l.divisor,m=e.length,g=e[0].length;if(l.normalize){r=0;for(let t=0;t<m;t++)for(let s=0;s<g;s++)r+=e[t][s]}if(0===r)throw new RangeError("convolution: The divisor is equal to zero");let u=FFTUtils.toRadix2(a,n,i),c=FFTUtils.convolute(u.data,e,u.rows,u.cols);if(c=FFTUtils.crop(c,u.rows,u.cols,n,i),0!==r&&1!==r)for(let t=0;t<c.length;t++)c[t]/=r;return c}function convolutionDirect(t,e,s){let n,i,o=matrix2Array(t),a=o.data,l=Object.assign({normalize:!1,divisor:1,rows:o.rows,cols:o.cols},s);if(!l.rows||!l.cols)throw new Error(`Invalid number of rows or columns ${n} ${i}`);n=l.rows,i=l.cols;let r,m,g,u,c,C=l.divisor,f=e.length,h=e[0].length;if(l.normalize){C=0;for(let t=0;t<f;t++)for(let s=0;s<h;s++)C+=e[t][s]}if(0===C)throw new RangeError("convolution: The divisor is equal to zero");let p=new Array(n*i),d=Math.floor(f/2),y=Math.floor(h/2);for(let t=0;t<n;t++)for(let s=0;s<i;s++){m=0;for(let o=0;o<f;o++)for(let l=0;l<h;l++)g=e[f-o-1][h-l-1],u=(t+o-d+n)%n,c=(s+l-y+i)%i,r=u*i+c,m+=a[r]*g;r=t*i+s,p[r]=m/C}return p}src.FFT=fftlib;class DisjointSet{constructor(){this.nodes=new Map}add(t){var e=this.nodes.get(t);return e||(e=new DisjointSetNode(t),this.nodes.set(t,e)),e}union(t,e){const s=this.find(t),n=this.find(e);s!==n&&(s.rank<n.rank?s.parent=n:s.rank>n.rank?n.parent=s:(n.parent=s,s.rank++))}find(t){for(var e=t;null!==e.parent;)e=e.parent;for(var s=t;null!==s.parent;){var n=s;s=s.parent,n.parent=e}return e}connected(t,e){return this.find(t)===this.find(e)}}var DisjointSet_1=DisjointSet;function DisjointSetNode(t){this.value=t,this.parent=null,this.rank=0}var DisjointSet$1=DisjointSet_1;const direction8X$2=[-1,-1,0,1,-1,0,1,1],direction8Y$2=[0,-1,-1,-1,1,1,1,0],neighbours8$1=[null,null,null,null,null,null,null,null],direction4X$1=[-1,0,1,0],direction4Y$1=[0,-1,0,1],neighbours4$1=[null,null,null,null];function drainLabelling(t,e){let s=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};const{neighbours:n=8,width:i,height:o}=s;let a,l,r;if(8===n)a=direction8X$2,l=direction8Y$2,r=neighbours8$1;else{if(4!==n)throw new RangeError(`unsupported neighbours count: ${n}`);a=direction4X$1,l=direction4Y$1,r=neighbours4$1}let m=new Array(o*i);for(let s=0,n=0;s<o;s++)for(let o=0;o<i;o++,n++)m[n]={value:t[n],row:s,col:o,mask:e[n]};m.sort(((t,e)=>t.value-e.value));const g=e.length,u=new Array(g),c=new Int16Array(g),C=new DisjointSet$1;for(let s=0,n=1;s<e.length;s++){let e=m[s];if(!e.mask)continue;let{row:g,col:c,value:f}=e,h=c+g*i;u[h]||(u[h]=C.add(n++));for(let e=0;e<r.length;e++){let s=c+a[e],n=g+l[e];if(s>=0&&n>=0&&s<i&&n<o){if(!u[s+n*i]){f<t[s+n*i]&&(u[s+n*i]=u[h])}}}}for(let t=0;t<o;t++)for(let s=0;s<i;s++){let n=s+t*i;e[n]&&(c[n]=C.find(u[n]).value)}return c}const direction4X=[-1,0],direction4Y=[0,-1],neighbours4=[null,null],direction8X$1=[-1,-1,0,1],direction8Y$1=[0,-1,-1,-1],neighbours8=[null,null,null,null];function floodFillLabelling(t,e,s,n){const i=(n=n||{}).neighbours||8;let o,a,l;if(8===i)o=direction8X$1,a=direction8Y$1,l=neighbours8;else{if(4!==i)throw new RangeError(`unsupported neighbours count: ${i}`);o=direction4X,a=direction4Y,l=neighbours4}const r=t.length,m=new Array(r),g=new Int16Array(r),u=new DisjointSet$1;let c,C=1;for(let n=0;n<s;n++)for(let i=0;i<e;i++){let r=null;if(c=i+n*e,t[c]){for(let t=0;t<l.length;t++){let g=i+o[t],u=n+a[t];if(g>=0&&u>=0&&g<e&&u<s){let s=m[g+u*e];s?(l[t]=s,(!r||l[t].value<r.value)&&(r=l[t])):l[t]=null}}if(r){m[c]=r;for(let t=0;t<l.length;t++)l[t]&&l[t]!==r&&u.union(r,l[t])}else m[c]=u.add(C++)}}for(let n=0;n<s;n++)for(let s=0;s<e;s++)c=s+n*e,t[c]&&(g[c]=u.find(m[c]).value);return g}const smallFilter$1=[[0,0,1,2,2,2,1,0,0],[0,1,4,7,7,7,4,1,0],[1,4,5,3,0,3,5,4,1],[2,7,3,-12,-23,-12,3,7,2],[2,7,0,-23,-40,-23,0,7,2],[2,7,3,-12,-23,-12,3,7,2],[1,4,5,3,0,3,5,4,1],[0,1,3,7,7,7,3,1,0],[0,0,1,2,2,2,1,0,0]];function findPeaks2DRegion(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{nStdDev:s=3,kernel:n=smallFilter$1,originalData:i=matrix2Array(t).data,filteredData:o,rows:a,cols:l,labelling:r="drain"}=e,m=matrix2Array(t),g=m.data;if(a&&l||(a=m.rows,l=m.cols),!a||!l)throw new Error(`Invalid number of rows or columns ${a} ${l}`);let u=o;u||(u=convolutionFFT(g,n,e));let c=0;for(let t=l*a-2;t>=0;t--)c+=Math.pow(u[t]-u[t+1],2);c=-Math.sqrt(c)*s/a;let C,f=new Uint16Array(l*a);for(let t=u.length-1;t>=0;t--)u[t]<c&&(f[t]=1);switch(r.toLowerCase()){case"drain":C=drainLabelling(u,f,{neighbours:8,width:l,height:a});break;case"floodfill":C=floodFillLabelling(f,l,a,{neighbours:8});break;default:throw new Error(`labelling ${r} does not support`)}return extractPeaks(C,{data:g,nCols:l,originalData:i})}function extractPeaks(t,e){const{data:s,nCols:n,originalData:i}=e;let o,a,l,r={};for(let e=0;e<t.length;e++)0!==t[e]&&(a=e%n,o=(e-a)/n,r[t[e]]?(l=r[t[e]],l.x+=a*s[e],l.y+=o*s[e],l.z+=i[e],a<l.minX&&(l.minX=a),a>l.maxX&&(l.maxX=a),o<l.minY&&(l.minY=o),o>l.maxY&&(l.maxY=o)):r[t[e]]={x:a*s[e],y:o*s[e],z:i[e],minX:a,maxX:a,minY:o,maxY:o});let m=Object.keys(r),g=new Array(m.length);for(let t=0;t<m.length;t++){g[t]=r[m[t]];let e=Math.abs(g[t].z);g[t].x/=e,g[t].y/=e}return g}const{parse:parse$2,stringify:stringify$2}=JSON;function addMissingIDs(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{output:s=parse$2(stringify$2(t))}=e;for(const t of s)"id"in t||(t.id=v4());return s}const direction8X=[-1,-1,-1,0,0,1,1,1],direction8Y=[-1,0,1,-1,1,-1,0,1],direction16X=[-2,-2,-2,-2,-2,-1,-1,0,0,1,1,2,2,2,2,2],direction16Y=[-2,-1,0,1,2,-2,2,-2,2,-2,2,-2,-1,0,1,2];function determineRealTop(t,e){let{nCols:s,absoluteData:n,originalData:i,minX:o,maxX:a,minY:l,maxY:r}=e;for(let e=0;e<t.length;e++){let m=Math.round(t[e].x),g=Math.round(t[e].y),u=m+g*s,{index:c,isMax:C}=determineMax(n,{xIndex:m,yIndex:g,nCols:s,shell:1});u=C?c:determineMax(n,{xIndex:m,yIndex:g,nCols:s,shell:2}).index;let f=fitGaussian(i,{nCols:s,index:u,minY:l,maxY:r,minX:o,maxX:a});t[e]=Object.assign(t[e],f)}return t}function determineMax(t,e){let{xIndex:s,yIndex:n,shell:i,nCols:o}=e,a=s+n*o,[l,r]=i>1?[direction16X,direction16Y]:[direction8X,direction8Y],m=!1;for(let e=0;e<l.length;e++){let i=s+l[e],g=n+r[e];if(t[i+g*o]>=t[a]){m=!0;let e=i+g*o;for(let s=0;s<direction8Y.length;s++){if(t[i+direction8X[s]+(g+direction8Y[s])*o]>t[e]){m=!1;break}}m&&(a=e)}}return{index:a,isMax:m}}function fitGaussian(t,e){let{nCols:s,index:n,minY:i,maxY:o,minX:a,maxX:l}=e,r=(l-a)/(s-1),m=(o-i)/(t.length/s-1),g=n%s,u=(n-g)/s,c=Number.MIN_SAFE_INTEGER,C=new Array(direction8X.length+1),f=new Array(direction8X.length+1);for(let e=-1,n=0;e<2;e++)for(let i=-1;i<2;i++,f[n]=n++){let n=t[g+i+(u+e)*s];c<n&&(c=n),C[1+i+3*(1+e)]=n}for(let t=0;t<C.length;t++)C[t]/=c;let h=[2,2,1.5,1,1],p=[0,0,-1.5,.001,.001],d=[1,1,C[4],.2,.2],y=levenbergMarquardt({x:f,y:C},paramGaussian2D(r,m,3),{damping:1.5,maxIterations:100,errorTolerance:1e-8,initialValues:d,gradientDifference:[1e-4,1e-4,.001,.001,.001],maxValues:h,minValues:p}).parameterValues;return{x:y[0]+g-1,y:y[1]+u-1,z:y[2]*c}}function paramGaussian2D(t,e,s){const n=new Gaussian2D;return i=>o=>{let a=i.length/5,l=0,r=o%s,m=(o-r)/s;for(let s=0;s<a;s++)n.fwhm={x:i[s+3*a],y:i[s+4*a]},l+=i[s+2*a]*n.fct((r-i[s])*t,(m-i[s+a])*e);return l}}function getKernel(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},{sigma:e=1.4,xLength:s=9,yLength:n=9}=t,i=-40/laplacianOfGaussian(0,0,e);const o=(s-1)/2,a=(n-1)/2;let l=new Array(s);for(let t=0;t<s;t++){l[t]=new Array(n);for(let s=0;s<n;s++)l[t][s]=laplacianOfGaussian(t-o,s-a,e)*i}return l}const laplacianOfGaussian=(t,e,s)=>{let n=-(Math.pow(t,2)+Math.pow(e,2))/2/Math.pow(s,2);return-1/Math.PI/Math.pow(s,4)*(1+n)*Math.exp(n)};let diagonalError=.05,tolerance=.05;function clean(t,e){let s=Number.NEGATIVE_INFINITY;for(let e=t.length-1;e>=0;e--)Math.abs(t[e].z)>s&&(s=Math.abs(t[e].z));s*=e;for(let e=t.length-1;e>=0;e--)Math.abs(t[e].z)<s&&t.splice(e,1);return t}function enhanceSymmetry(t){let e,s=initializeProperties(t),n=t.slice();for(let t=n.length-1;t>=0;t--){let e=n[t];if(e.peaks&&e.peaks.length>1&&s[t][1]++,1===s[t][0]){let i=exist(n,s,e,-1,!0);i>=0&&(s[t][1]+=2,s[i][1]+=2)}}for(let t=n.length-1;t>=0;t--){let i=n[t];0===s[t][0]&&(e=checkCrossPeaks(n,s,i,!0),s[t][1]+=e)}let i=0;for(let t=n.length-1;t>=0;t--)0!==s[t][0]&&s[t][1]>2&&(i++,i+=completeMissingIfNeeded(n,s,n[t],s[t])),s[t][1]>=2&&0===s[t][0]&&i++;let o=new Array(i);i--;for(let t=n.length-1;t>=0;t--)(0!==s[t][0]&&s[t][1]>2||0===s[t][0]&&s[t][1]>1)&&(o[i--]=n[t]);return o}function completeMissingIfNeeded(t,e,s,n){let i,o,a=0,l=null;exist(t,e,s,-n[0],!0)<0&&(i={x:{nucleus:s.x.nucleus,resolution:s.x.resolution,delta:s.y.delta},y:{nucleus:s.y.nucleus,resolution:s.y.resolution,delta:s.x.delta},peaks:[{x:s.y.delta,y:s.x.delta,z:1}]},t.push(i),l=[-n[0],n[1]],e.push(l),a++);let r=!1,m=!1;for(let n=t.length-1;n>=0;n--)o=t[n],0===e[n][0]&&(Math.abs(o.x.delta-s.x.delta)<diagonalError&&(r=!0),Math.abs(o.y.delta-s.y.delta)<diagonalError&&(m=!0));return r||(i={x:{delta:s.y.delta,nucleus:s.x.nucleus,resolution:s.x.resolution},y:{delta:s.x.delta,nucleus:s.y.nucleus,resolution:s.y.resolution},peaks:[{x:s.x.delta,y:s.x.delta,z:1}]},i.peaks=[{x:s.x.delta,y:s.x.delta,z:1}],t.push(i),l=[0,n[1]],e.push(l),a++),m||(i={x:{delta:s.y.delta,nucleus:s.x.nucleus,resolution:s.x.resolution},y:{delta:s.y.delta,nucleus:s.y.nucleus,resolution:s.y.resolution},peaks:[{x:s.y.delta,y:s.y.delta,z:1}]},t.push(i),l=[0,n[1]],e.push(l),a++),a}function checkCrossPeaks(t,e,s,n){let i,o=0,a=4*s.x.delta,l=[],r=[];for(let m=t.length-1;m>=0;m--)i=t[m],0!==e[m][0]&&(Math.abs(i.x.delta-s.x.delta)<diagonalError?(o++,n&&e[m][1]++,l.push(m),a+=i.x.delta):Math.abs(i.y.delta-s.y.delta)<diagonalError&&(o++,n&&e[m][1]++,r.push(m),a+=i.y.delta));if(a/=l.length+r.length+4,l.length>0)for(let e=l.length-1;e>=0;e--)t[l[e]].x.delta=a;if(r.length>0)for(let e=r.length-1;e>=0;e--)t[r[e]].y.delta=a;return s.x.delta=a,s.y.delta=a,o}function exist(t,e,s,n,i){for(let o=t.length-1;o>=0;o--)if(e[o][0]===n&&distanceTo(s,t[o],i)<tolerance){if(i){let e=s.x.delta,n=t[o].x.delta;t[o].y.delta=e,s.y.delta=n}else{let e=(t[o].x.delta+s.x.delta)/2,n=(t[o].y.delta+s.y.delta)/2;t[o].x.delta=e,t[o].y.delta=n,s.x.delta=e,s.y.delta=n}return o}return-1}function initializeProperties(t){let e=new Array(t.length);for(let s=t.length-1;s>=0;s--)if(e[s]=[0,0],Math.abs(t[s].x.delta-t[s].y.delta)<=diagonalError){e[s][1]=1;let n=(2*t[s].x.delta+t[s].y.delta)/3;t[s].x.delta=n,t[s].y.delta=n}else t[s].x.delta-t[s].y.delta>0?e[s][0]=1:e[s][0]=-1;return e}function distanceTo(t,e,s){return s?Math.sqrt(Math.pow(t.x.delta-e.y.delta,2)+Math.pow(t.y.delta-e.x.delta,2)):Math.sqrt(Math.pow(t.x.delta-e.x.delta,2)+Math.pow(t.y.delta-e.y.delta,2))}function formatZones(t){let e=[];for(const s of t){let t=[Number.MAX_VALUE,0],n=[Number.MAX_VALUE,0];for(const e of s.peaks||[])e.minX<t[0]&&(t[0]=e.minX),e.maxX>t[1]&&(t[1]=e.maxX),e.minY<n[0]&&(n[0]=e.minY),e.maxY>n[1]&&(n[1]=e.maxY);e.push({id:v4(),x:{from:t[0],to:t[1]},y:{from:n[0],to:n[1]},signals:[s]})}return e}const smallFilter=[[0,0,1,2,2,2,1,0,0],[0,1,4,7,7,7,4,1,0],[1,4,5,3,0,3,5,4,1],[2,7,3,-12,-23,-12,3,7,2],[2,7,0,-23,-40,-23,0,7,2],[2,7,3,-12,-23,-12,3,7,2],[1,4,5,3,0,3,5,4,1],[0,1,3,7,7,7,3,1,0],[0,0,1,2,2,2,1,0,0]];function xyzAutoZonesPicking(t,e){let{sizeToPad:s=14,realTopDetection:n=!0,thresholdFactor:i=.5,nuclei:o=["1H","1H"],observedFrequencies:a,enhanceSymmetry:l=!1,clean:r=!0,maxPercentCutOff:m=.03,tolerances:g=[24,24],convolutionByFFT:u=!0,kernel:c}=e;if(!Array.isArray(a)&&!ArrayBuffer.isView(a))throw new Error("observedFrequencies is mandatory");i=0===i?1:Math.abs(i);let C=t.z[0].length,f=t.z.length;f<s&&(C=(t=padData(t,{width:s})).z[0].length,f=t.z.length);let h=new Float64Array(C*f),p=new Float64Array(C*f);for(let e=0;e<f;e++){let s=t.z[e];for(let t=0;t<C;t++){let n=e*C+t;h[n]=Math.abs(s[t]),p[n]=s[t]}}const d=c?getKernel(c):smallFilter;let y=findPeaks2DRegion(h,{originalData:p,filteredData:u?convolutionFFT(h,d,{rows:f,cols:C}):convolutionDirect(h,d,{rows:f,cols:C}),rows:f,cols:C,nStdDev:i});r&&(y=clean(y,m));let H=createSignals2D$1(addMissingIDs(y),{nRows:f,nCols:C,minX:t.minX,maxX:t.maxX,minY:t.minY,maxY:t.maxY,absoluteData:h,originalData:p,tolerances:g,nuclei:o,observedFrequencies:a,realTopDetection:n});return l&&(H=enhanceSymmetry(H)),formatZones(H)}function createSignals2D$1(t,e){let{nCols:s,nRows:n,absoluteData:i,originalData:o,observedFrequencies:a,tolerances:l,nuclei:r,realTopDetection:m,minY:g,maxY:u,minX:c,maxX:C}=e,[f,h]=r,[p,d]=l,[y,H]=a,v=(u-g)/(n-1),b=(C-c)/(s-1);m&&(t=determineRealTop(t,{nCols:s,absoluteData:i,originalData:o,minX:c,maxX:C,minY:g,maxY:u}));for(let e=t.length-1;e>=0;e--){let{x:s,y:n}=t[e];t[e].x=c+b*s,t[e].y=g+v*n,t[e].minX=c+b*t[e].minX,t[e].minY=g+v*t[e].minY,t[e].maxX=c+b*t[e].maxX,t[e].maxY=g+v*t[e].maxY}let w=[];for(let e=0;e<t.length;e++)for(let s=e;s<t.length;s++)Math.abs(t[e].x-t[s].x)*y<p&&Math.abs(t[e].y-t[s].y)*H<d?w.push(1):w.push(0);let O=simpleClustering(w),x=[];if(O)for(const e of O){let s={id:v4(),x:{delta:0,nucleus:f,resolution:b},y:{delta:0,nucleus:h,resolution:v}},n=[],i=0;for(let o=0;o<e.length;o++)1===e[o]&&(n.push(t[o]),s.x.delta+=t[o].x*t[o].z,s.y.delta+=t[o].y*t[o].z,i+=t[o].z);s.x.delta/=i,s.y.delta/=i,s.peaks=n,x.push(s)}return x}function padData(t,e){let{minX:s,maxX:n,minY:i,maxY:o}=t;const a=e.width;let l=t.z[0].length,r=t.z.length,m=(o-i)/(r-1),g=(n-s)/(l-1),u=a-r,c=Math.max(a-l,0);c%2&&c++,u%2&&u++;let C=c/2,f=u/2,h=Matrix.zeros(r+u,l+c);for(let e=0;e<r;e++)for(let s=0;s<l;s++)h.set(e+f,s+C,t.z[e][s]);return{z:h.to2DArray(),minX:s-C*g,maxX:n+C*g,minY:i-f*m,maxY:o+f*m}}const{parse:parse$1,stringify:stringify$1}=JSON;function xyzJResAnalyzer(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},{reference:s=0,getZones:n=!1,referenceMaxShiftError:i=.08,tolerances:o=[10,100],nuclei:a=["1H","1H"],observedFrequencies:l=[400,400],jAnalyzer:r={jAxisKey:{jAxis:"y",intensity:"z"}}}=e,m=compilePattern(t,{observedFrequencies:l,tolerances:o,nuclei:a,jAnalyzer:r}),g=[];for(const t of m){let e=t.y.delta;Math.abs(e-s)>i||g.push(t)}return g=addMissingIDs(g),n?formatZones(g):g}function compilePattern(t,e){let{observedFrequencies:s,tolerances:n,nuclei:i,jAnalyzer:o}=e,a={observedFrequencies:s,tolerances:n,nuclei:i,dx:t[0].x.resolution,dy:t[0].y.resolution};const l=.02*s[0],r=parse$1(stringify$1(t));for(const t of r){let e=t.peaks;t.nbPeaks=t.peaks.length,t.multiplicity="",t.pattern="",t.delta1=t.shiftY,t.observe=s[1],t.integralData={from:Number.MAX_SAFE_INTEGER,to:Number.MIN_SAFE_INTEGER};for(const t of e)t.width||(t.width=l);e.sort(((t,e)=>t.y-e.y))}for(let e=0;e<t.length;e++)if(jAnalyzer.compilePattern(r[e],o),r[e].maskPattern&&"m"!==r[e].multiplicity&&""!==r[e].multiplicity){let t=[];for(let s=r[e].maskPattern.length-1;s>=0;s--)if(!1===r[e].maskPattern[s]){let n=r[e].peaks.splice(s,1)[0];t.push(n),r[e].mask.splice(s,1),r[e].mask2.splice(s,1),r[e].maskPattern.splice(s,1),r[e].nbPeaks--}if(t.length>0){t.reverse();let e=createSignals2D(t,a);for(const t of e)r.push(t)}}return t.sort(((t,e)=>e.x.delta-t.x.delta)),t}function createSignals2D(t,e){let{observedFrequencies:s,tolerances:n,nuclei:i,dx:o,dy:a}=e;const l=parse$1(stringify$1(t));let[r,m]=i,[g,u]=n,[c,C]=s,f=[];for(let t=0;t<l.length;t++)for(let e=t;e<l.length;e++)Math.abs(l[t].x-l[e].x)*c<g&&Math.abs(l[t].y-l[e].y)*C<u?f.push(1):f.push(0);let h=simpleClustering(f),p=[];if(h)for(let t of h){let e={id:v4(),nucleusX:r,nucleusY:m,integralData:{from:Number.MAX_SAFE_INTEGER,to:Number.MIN_SAFE_INTEGER},nbPeaks:0,multiplicity:"",pattern:"",observe:C,resolutionX:o,resolutionY:a,shiftX:0,shiftY:0},s=[],n=[Number.MAX_VALUE,0],i=[Number.MAX_VALUE,0],g=0;for(let o=t.length-1;o>=0;o--)1===t[o]&&(e.nbPeaks++,l[o].width||(l[o].width=.02),s.push(l[o]),e.shiftX+=l[o].x*l[o].z,e.shiftY+=l[o].y*l[o].z,g+=l[o].z,l[o].minX<n[0]&&(n[0]=l[o].minX),l[o].maxX>n[1]&&(n[1]=l[o].maxX),l[o].minY<i[0]&&(i[0]=l[o].minY),l[o].maxY>i[1]&&(i[1]=l[o].maxY));e.fromTo=[{from:n[0],to:n[1]},{from:i[0],to:i[1]}],e.shiftX/=g,e.shiftY/=g,e.delta1=e.shiftY,e.peaks=s,p.push(e)}return p}async function getDatabase(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"https://docs.google.com/spreadsheets/d/1uwyq_L38PMRWCcT4If_EhPbHKyY3q_2tpjV8vr5_zh0/edit?usp=sharing",e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{format:s="tsv"}=e;let n;t.includes("google.com")&&(t=`https://googledocs.cheminfo.org/spreadsheets/d/${extractGoogleUUID(t)}/export?format=tsv`);const i=await browserPonyfill.exports.fetch(t);switch(s){case"tsv":n=parseData(await i.text());break;case"json":n=await i.json();break;default:throw new Error("unknown database format")}const o=[];for(let t of n.data){const e={smiles:"",solvent:"",nucleus:"",jcampURL:"",names:[],meta:{},ranges:[]};for(let s=0;s<t.length;s++)switch(n.kinds[s]){case"smiles":e.smiles=t[s];break;case"solvent":e.solvent=t[s];break;case"nucleus":e.nucleus=t[s];break;case"jcampURL":e.jcampURL=t[s];break;case"name":e.names&&e.names.push(t[s]);break;case"meta":e.meta&&(e.meta[n.labels[s]]=t[s]);break;case"signal":{const n=resurrectRange(t[s]);n&&e.ranges.push(n);break}default:throw new Error(`Unknown column kind: ${n.kinds[s]}`)}o.push(e)}return o}function extractGoogleUUID(t){return t.replace(/.*\/(?<uuid>[^/]{20,50}).*/,"$<uuid>")}function parseData(t){const e=t.split(/\r?\n/).filter((t=>!/^\s*$/.exec(t))).map((t=>t.split("\t").map((t=>t.trim()))));return{labels:e[0],kinds:e[1],data:e.slice(2)}}const carbonImpurities=[{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:171.69,assignment:"CO"}],from:171.68625,to:171.69375},{signals:[{delta:20.13,assignment:"CH₃"}],from:20.12625,to:20.13375}],nucleus:"13C",solvent:"THF-d₈"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:204.19,assignment:"CO"}],from:204.18625,to:204.19375},{signals:[{delta:30.17,assignment:"CH₃"}],from:30.16625,to:30.173750000000002}],nucleus:"13C",solvent:"THF-d₈"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:116.79,assignment:"CN"}],from:116.78625000000001,to:116.79375},{signals:[{delta:.45,assignment:"CH₃"}],from:.44625000000000004,to:.45375}],nucleus:"13C",solvent:"THF-d₈"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:128.84,assignment:"CH"}],from:128.83625,to:128.84375}],nucleus:"13C",solvent:"THF-d₈"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:67.5,assignment:"(CH₃)₃C"}],from:67.49625,to:67.50375},{signals:[{delta:30.57,assignment:"(CH₃)₃C"}],from:30.56625,to:30.57375}],nucleus:"13C",solvent:"THF-d₈"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:125.69,assignment:"CO₂"}],from:125.68625,to:125.69375}],nucleus:"13C",solvent:"THF-d₈"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:193.37,assignment:"CS₂"}],from:193.36625,to:193.37375}],nucleus:"13C",solvent:"THF-d₈"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:96.89,assignment:"CCl₄"}],from:96.88625,to:96.89375}],nucleus:"13C",solvent:"THF-d₈"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:79.24,assignment:"CH"}],from:79.23625,to:79.24374999999999}],nucleus:"13C",solvent:"THF-d₈"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:71.34,assignment:"CH₂"}],from:71.33625,to:71.34375}],nucleus:"13C",solvent:"THF-d₈"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:27.58,assignment:"CH₂"}],from:27.576249999999998,to:27.58375}],nucleus:"13C",solvent:"THF-d₈"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:44.64,assignment:"CH₂"}],from:44.636250000000004,to:44.64375}],nucleus:"13C",solvent:"THF-d₈"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:54.67,assignment:"CH₂"}],from:54.666250000000005,to:54.67375}],nucleus:"13C",solvent:"THF-d₈"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.49,assignment:"CH₃"}],from:15.48625,to:15.49375},{signals:[{delta:66.14,assignment:"CH₂"}],from:66.13625,to:66.14375}],nucleus:"13C",solvent:"THF-d₈"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:58.72,assignment:"CH₃"}],from:58.71625,to:58.723749999999995},{signals:[{delta:71.17,assignment:"CH₂"}],from:71.16625,to:71.17375},{signals:[{delta:72.72,assignment:"CH₂"}],from:72.71625,to:72.72375}],nucleus:"13C",solvent:"THF-d₈"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:161.96,assignment:"CH"}],from:161.95625,to:161.96375},{signals:[{delta:35.65,assignment:"CH₃"}],from:35.64625,to:35.653749999999995},{signals:[{delta:30.7,assignment:"CH₃"}],from:30.69625,to:30.70375}],nucleus:"13C",solvent:"THF-d₈"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:67.65,assignment:"CH₂"}],from:67.64625000000001,to:67.65375}],nucleus:"13C",solvent:"THF-d₈"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:58.72,assignment:"CH₃"}],from:58.71625,to:58.723749999999995},{signals:[{delta:72.58,assignment:"CH₂"}],from:72.57625,to:72.58375}],nucleus:"13C",solvent:"THF-d₈"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:6.79,assignment:"CH₃"}],from:6.78625,to:6.79375}],nucleus:"13C",solvent:"THF-d₈"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.9,assignment:"CH₃"}],from:18.89625,to:18.90375},{signals:[{delta:57.6,assignment:"CH₂"}],from:57.596250000000005,to:57.60375}],nucleus:"13C",solvent:"THF-d₈"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:20.45,assignment:"CH₃CO"}],from:20.44625,to:20.45375},{signals:[{delta:170.32,assignment:"CO"}],from:170.31625,to:170.32375},{signals:[{delta:60.3,assignment:"CH₂"}],from:60.29625,to:60.303749999999994},{signals:[{delta:14.37,assignment:"CH₃"}],from:14.366249999999999,to:14.37375}],nucleus:"13C",solvent:"THF-d₈"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:123.09,assignment:"CH₂"}],from:123.08625,to:123.09375}],nucleus:"13C",solvent:"THF-d₈"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:64.35,assignment:"CH₂"}],from:64.34625,to:64.35374999999999}],nucleus:"13C",solvent:"THF-d₈"},{names:["H grease"],smiles:"",ranges:[{signals:[{delta:30.45,assignment:"CH₂"}],from:30.44625,to:30.45375}],nucleus:"13C",solvent:"THF-d₈"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:131.88,assignment:"C"}],from:131.87625,to:131.88375},{signals:[{delta:16.71,assignment:"CH₃"}],from:16.70625,to:16.71375}],nucleus:"13C",solvent:"THF-d₈"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:14.22,assignment:"CH₃"}],from:14.21625,to:14.22375},{signals:[{delta:23.33,assignment:"CH₂(2,5)"}],from:23.326249999999998,to:23.33375},{signals:[{delta:32.34,assignment:"CH₂(3,4)"}],from:32.33625000000001,to:32.34375}],nucleus:"13C",solvent:"THF-d₈"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:1.83,assignment:"CH₃"}],from:1.8262500000000002,to:1.83375}],nucleus:"13C",solvent:"THF-d₈"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:36.89,assignment:"CH₃"}],from:36.886250000000004,to:36.89375}],nucleus:"13C",solvent:"THF-d₈"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:135.72,assignment:"CH(2)"}],from:135.71625,to:135.72375},{signals:[{delta:122.2,assignment:"CH(4,5)"}],from:122.19625,to:122.20375}],nucleus:"13C",solvent:"THF-d₈"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-4.9,assignment:"CH₄"}],from:-4.9037500000000005,to:-4.89625}],nucleus:"13C",solvent:"THF-d₈"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:49.64,assignment:"CH₃"}],from:49.636250000000004,to:49.64375}],nucleus:"13C",solvent:"THF-d₈"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:62.49,assignment:"CH₃"}],from:62.486250000000005,to:62.49375}],nucleus:"13C",solvent:"THF-d₈"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:14.18,assignment:"CH₃"}],from:14.17625,to:14.18375},{signals:[{delta:23,assignment:"CH₂(2,4)"}],from:22.99625,to:23.00375},{signals:[{delta:34.87,assignment:"CH₂(3)"}],from:34.86625,to:34.873749999999994}],nucleus:"13C",solvent:"THF-d₈"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.6,assignment:"CH₃"}],from:16.59625,to:16.60375},{signals:[{delta:16.82,assignment:"CH₂"}],from:16.81625,to:16.82375}],nucleus:"13C",solvent:"THF-d₈"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.7,assignment:"CH₃"}],from:25.69625,to:25.70375},{signals:[{delta:66.14,assignment:"CH"}],from:66.13625,to:66.14375}],nucleus:"13C",solvent:"THF-d₈"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.27,assignment:"CH₃"}],from:19.26625,to:19.27375},{signals:[{delta:115.74,assignment:"CH₂"}],from:115.73625,to:115.74374999999999},{signals:[{delta:134.02,assignment:"CH"}],from:134.01625,to:134.02375}],nucleus:"13C",solvent:"THF-d₈"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:150.57,assignment:"CH(2,6)"}],from:150.56625,to:150.57375},{signals:[{delta:124.08,assignment:"CH(3,5)"}],from:124.07625,to:124.08375},{signals:[{delta:135.99,assignment:"CH(4)"}],from:135.98625,to:135.99375}],nucleus:"13C",solvent:"THF-d₈"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:118.03,assignment:"CH(2,5)"}],from:118.02625,to:118.03375},{signals:[{delta:107.74,assignment:"CH(3,4)"}],from:107.73625,to:107.74374999999999}],nucleus:"13C",solvent:"THF-d₈"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:45.82,assignment:"CH₂(2,5)"}],from:45.816250000000004,to:45.82375},{signals:[{delta:26.17,assignment:"CH₂(3,4)"}],from:26.16625,to:26.173750000000002}],nucleus:"13C",solvent:"THF-d₈"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{delta:1.2,assignment:"CH₃"}],from:1.19625,to:1.2037499999999999}],nucleus:"13C",solvent:"THF-d₈"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:68.03,assignment:"CH₂(2,5)"}],from:68.02625,to:68.03375},{signals:[{delta:26.19,assignment:"CH₂(3,4)"}],from:26.18625,to:26.19375}],nucleus:"13C",solvent:"THF-d₈"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:21.29,assignment:"CH₃"}],from:21.28625,to:21.29375},{signals:[{delta:138.24,assignment:"C(1)"}],from:138.23625,to:138.24375},{signals:[{delta:129.47,assignment:"CH(2,6)"}],from:129.46625,to:129.47375},{signals:[{delta:128.71,assignment:"CH(3,5)"}],from:128.70625,to:128.71375},{signals:[{delta:125.84,assignment:"CH(4)"}],from:125.83625,to:125.84375}],nucleus:"13C",solvent:"THF-d₈"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:12.51,assignment:"CH₃"}],from:12.50625,to:12.51375},{signals:[{delta:47.18,assignment:"CH₂"}],from:47.17625,to:47.183749999999996}],nucleus:"13C",solvent:"THF-d₈"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:175.85,assignment:"CO"}],from:175.84625,to:175.85375},{signals:[{delta:20.91,assignment:"CH₃"}],from:20.90625,to:20.91375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:206.78,assignment:"CO"}],from:206.77625,to:206.78375},{signals:[{delta:31,assignment:"CH₃"}],from:30.99625,to:31.00375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:116.92,assignment:"CN"}],from:116.91625,to:116.92375},{signals:[{delta:2.03,assignment:"CH₃"}],from:2.0262499999999997,to:2.03375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:128.68,assignment:"CH"}],from:128.67625,to:128.68375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:69.11,assignment:"(CH₃)₃C"}],from:69.10625,to:69.11375},{signals:[{delta:31.46,assignment:"(CH₃)₃C"}],from:31.45625,to:31.46375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:125.26,assignment:"CO₂"}],from:125.25625000000001,to:125.26375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:192.95,assignment:"CS₂"}],from:192.94625,to:192.95374999999999}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:96.52,assignment:"CCl₄"}],from:96.51625,to:96.52374999999999}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:77.99,assignment:"CH"}],from:77.98625,to:77.99374999999999}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:70.47,assignment:"CH₂"}],from:70.46625,to:70.47375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:27.38,assignment:"CH₂"}],from:27.37625,to:27.38375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:44.35,assignment:"CH₂"}],from:44.346250000000005,to:44.35375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:54.24,assignment:"CH₂"}],from:54.236250000000005,to:54.24375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.44,assignment:"CH₃"}],from:15.43625,to:15.44375},{signals:[{delta:66.11,assignment:"CH₂"}],from:66.10625,to:66.11375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:58.95,assignment:"CH₃"}],from:58.946250000000006,to:58.95375},{signals:[{delta:70.7,assignment:"CH₂"}],from:70.69625,to:70.70375},{signals:[{delta:72.25,assignment:"CH₂"}],from:72.24625,to:72.25375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:162.57,assignment:"CH"}],from:162.56625,to:162.57375},{signals:[{delta:36.56,assignment:"CH₃"}],from:36.556250000000006,to:36.56375},{signals:[{delta:31.39,assignment:"CH₃"}],from:31.38625,to:31.39375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:67.47,assignment:"CH₂"}],from:67.46625,to:67.47375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:59.02,assignment:"CH₃"}],from:59.01625000000001,to:59.02375},{signals:[{delta:72.24,assignment:"CH₂"}],from:72.23625,to:72.24374999999999}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:6.91,assignment:"CH₃"}],from:6.90625,to:6.91375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.69,assignment:"CH₃"}],from:18.68625,to:18.69375},{signals:[{delta:58.57,assignment:"CH₂"}],from:58.566250000000004,to:58.57375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:21.15,assignment:"CH₃CO"}],from:21.14625,to:21.15375},{signals:[{delta:171.24,assignment:"CO"}],from:171.23625,to:171.24375},{signals:[{delta:60.63,assignment:"CH₂"}],from:60.626250000000006,to:60.63375},{signals:[{delta:14.37,assignment:"CH₃"}],from:14.366249999999999,to:14.37375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:123.2,assignment:"CH₂"}],from:123.19625,to:123.20375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:64.08,assignment:"CH₂"}],from:64.07625,to:64.08375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["H grease"],smiles:"",ranges:[{signals:[{delta:30.14,assignment:"CH₂"}],from:30.13625,to:30.14375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:132.09,assignment:"C"}],from:132.08625,to:132.09375},{signals:[{delta:16.93,assignment:"CH₃"}],from:16.92625,to:16.93375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:14.28,assignment:"CH₃"}],from:14.27625,to:14.28375},{signals:[{delta:23.07,assignment:"CH₂(2,5)"}],from:23.06625,to:23.07375},{signals:[{delta:32.01,assignment:"CH₂(3,4)"}],from:32.00625,to:32.013749999999995}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:1.96,assignment:"CH₃"}],from:1.95625,to:1.9637499999999999}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:36.99,assignment:"CH₃"}],from:36.986250000000005,to:36.99375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:135.76,assignment:"CH(2)"}],from:135.75625,to:135.76375},{signals:[{delta:122.16,assignment:"CH(4,5)"}],from:122.15625,to:122.16375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-4.33,assignment:"CH₄"}],from:-4.33375,to:-4.32625}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:50.45,assignment:"CH₃"}],from:50.446250000000006,to:50.45375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:63.03,assignment:"CH₃"}],from:63.026250000000005,to:63.03375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:14.24,assignment:"CH₃"}],from:14.23625,to:14.24375},{signals:[{delta:22.77,assignment:"CH₂(2,4)"}],from:22.76625,to:22.77375},{signals:[{delta:34.57,assignment:"CH₂(3)"}],from:34.566250000000004,to:34.57375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.63,assignment:"CH₃"}],from:16.62625,to:16.63375},{signals:[{delta:16.63,assignment:"CH₂"}],from:16.62625,to:16.63375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.43,assignment:"CH₃"}],from:25.42625,to:25.43375},{signals:[{delta:64.67,assignment:"CH"}],from:64.66625,to:64.67375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.47,assignment:"CH₃"}],from:19.46625,to:19.47375},{signals:[{delta:115.7,assignment:"CH₂"}],from:115.69625,to:115.70375},{signals:[{delta:134.21,assignment:"CH"}],from:134.20625,to:134.21375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:150.27,assignment:"CH(2,6)"}],from:150.26625,to:150.27375},{signals:[{delta:124.06,assignment:"CH(3,5)"}],from:124.05625,to:124.06375},{signals:[{delta:136.16,assignment:"CH(4)"}],from:136.15625,to:136.16375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:117.93,assignment:"CH(2,5)"}],from:117.92625000000001,to:117.93375},{signals:[{delta:108.02,assignment:"CH(3,4)"}],from:108.01625,to:108.02374999999999}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:47.02,assignment:"CH₂(2,5)"}],from:47.01625000000001,to:47.02375},{signals:[{delta:25.83,assignment:"CH₂(3,4)"}],from:25.826249999999998,to:25.83375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{delta:1.22,assignment:"CH₃"}],from:1.21625,to:1.22375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:68.16,assignment:"CH₂(2,5)"}],from:68.15625,to:68.16375},{signals:[{delta:25.98,assignment:"CH₂(3,4)"}],from:25.97625,to:25.98375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:21.53,assignment:"CH₃"}],from:21.52625,to:21.53375},{signals:[{delta:138.36,assignment:"C(1)"}],from:138.35625000000002,to:138.36375},{signals:[{delta:129.35,assignment:"CH(2,6)"}],from:129.34625,to:129.35375},{signals:[{delta:128.54,assignment:"CH(3,5)"}],from:128.53625,to:128.54375},{signals:[{delta:125.62,assignment:"CH(4)"}],from:125.61625000000001,to:125.62375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:12.12,assignment:"CH₃"}],from:12.116249999999999,to:12.12375},{signals:[{delta:46.75,assignment:"CH₂"}],from:46.74625,to:46.75375}],nucleus:"13C",solvent:"CD₂Cl₂"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:175.99,assignment:"CO"}],from:175.98625,to:175.99375},{signals:[{delta:20.81,assignment:"CH₃"}],from:20.80625,to:20.81375}],nucleus:"13C",solvent:"CDCl₃"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:207.07,assignment:"CO"}],from:207.06625,to:207.07375},{signals:[{delta:30.92,assignment:"CH₃"}],from:30.91625,to:30.923750000000002}],nucleus:"13C",solvent:"CDCl₃"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:116.43,assignment:"CN"}],from:116.42625000000001,to:116.43375},{signals:[{delta:1.89,assignment:"CH₃"}],from:1.88625,to:1.8937499999999998}],nucleus:"13C",solvent:"CDCl₃"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:128.37,assignment:"CH"}],from:128.36625,to:128.37375}],nucleus:"13C",solvent:"CDCl₃"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:69.15,assignment:"(CH₃)₃C"}],from:69.14625000000001,to:69.15375},{signals:[{delta:31.25,assignment:"(CH₃)₃C"}],from:31.24625,to:31.25375}],nucleus:"13C",solvent:"CDCl₃"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:124.99,assignment:"CO₂"}],from:124.98625,to:124.99374999999999}],nucleus:"13C",solvent:"CDCl₃"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:192.83,assignment:"CS₂"}],from:192.82625000000002,to:192.83375}],nucleus:"13C",solvent:"CDCl₃"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:96.34,assignment:"CCl₄"}],from:96.33625,to:96.34375}],nucleus:"13C",solvent:"CDCl₃"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:77.36,assignment:"CH"}],from:77.35625,to:77.36375}],nucleus:"13C",solvent:"CDCl₃"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:70.55,assignment:"CH₂"}],from:70.54625,to:70.55375}],nucleus:"13C",solvent:"CDCl₃"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:26.94,assignment:"CH₂"}],from:26.93625,to:26.94375}],nucleus:"13C",solvent:"CDCl₃"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:43.5,assignment:"CH₂"}],from:43.49625,to:43.50375}],nucleus:"13C",solvent:"CDCl₃"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:53.52,assignment:"CH₂"}],from:53.51625000000001,to:53.52375}],nucleus:"13C",solvent:"CDCl₃"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.2,assignment:"CH₃"}],from:15.19625,to:15.20375},{signals:[{delta:65.91,assignment:"CH₂"}],from:65.90625,to:65.91375}],nucleus:"13C",solvent:"CDCl₃"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:59.01,assignment:"CH₃"}],from:59.00625,to:59.013749999999995},{signals:[{delta:70.51,assignment:"CH₂"}],from:70.50625000000001,to:70.51375},{signals:[{delta:71.9,assignment:"CH₂"}],from:71.89625000000001,to:71.90375}],nucleus:"13C",solvent:"CDCl₃"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:162.62,assignment:"CH"}],from:162.61625,to:162.62375},{signals:[{delta:36.5,assignment:"CH₃"}],from:36.49625,to:36.50375},{signals:[{delta:31.45,assignment:"CH₃"}],from:31.44625,to:31.45375}],nucleus:"13C",solvent:"CDCl₃"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:67.14,assignment:"CH₂"}],from:67.13625,to:67.14375}],nucleus:"13C",solvent:"CDCl₃"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:59.08,assignment:"CH₃"}],from:59.07625,to:59.083749999999995},{signals:[{delta:71.84,assignment:"CH₂"}],from:71.83625,to:71.84375}],nucleus:"13C",solvent:"CDCl₃"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:6.89,assignment:"CH₃"}],from:6.8862499999999995,to:6.89375}],nucleus:"13C",solvent:"CDCl₃"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.41,assignment:"CH₃"}],from:18.40625,to:18.41375},{signals:[{delta:58.28,assignment:"CH₂"}],from:58.276250000000005,to:58.28375}],nucleus:"13C",solvent:"CDCl₃"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:21.04,assignment:"CH₃CO"}],from:21.03625,to:21.04375},{signals:[{delta:171.36,assignment:"CO"}],from:171.35625000000002,to:171.36375},{signals:[{delta:60.49,assignment:"CH₂"}],from:60.486250000000005,to:60.49375},{signals:[{delta:14.19,assignment:"CH₃"}],from:14.18625,to:14.19375}],nucleus:"13C",solvent:"CDCl₃"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:123.13,assignment:"CH₂"}],from:123.12625,to:123.13374999999999}],nucleus:"13C",solvent:"CDCl₃"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:63.79,assignment:"CH₂"}],from:63.78625,to:63.793749999999996}],nucleus:"13C",solvent:"CDCl₃"},{names:["H grease"],smiles:"",ranges:[{signals:[{delta:29.71,assignment:"CH₂"}],from:29.70625,to:29.71375}],nucleus:"13C",solvent:"CDCl₃"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:132.21,assignment:"C"}],from:132.20625,to:132.21375},{signals:[{delta:16.98,assignment:"CH₃"}],from:16.97625,to:16.98375}],nucleus:"13C",solvent:"CDCl₃"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:14.14,assignment:"CH₃"}],from:14.13625,to:14.14375},{signals:[{delta:22.7,assignment:"CH₂(2,5)"}],from:22.69625,to:22.70375},{signals:[{delta:31.64,assignment:"CH₂(3,4)"}],from:31.63625,to:31.64375}],nucleus:"13C",solvent:"CDCl₃"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:1.97,assignment:"CH₃"}],from:1.96625,to:1.97375}],nucleus:"13C",solvent:"CDCl₃"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:36.87,assignment:"CH₃"}],from:36.86625,to:36.873749999999994}],nucleus:"13C",solvent:"CDCl₃"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:135.38,assignment:"CH(2)"}],from:135.37625,to:135.38375},{signals:[{delta:122,assignment:"CH(4,5)"}],from:121.99625,to:122.00375}],nucleus:"13C",solvent:"CDCl₃"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-4.63,assignment:"CH₄"}],from:-4.63375,to:-4.62625}],nucleus:"13C",solvent:"CDCl₃"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:50.41,assignment:"CH₃"}],from:50.40625,to:50.41374999999999}],nucleus:"13C",solvent:"CDCl₃"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:62.5,assignment:"CH₃"}],from:62.49625,to:62.50375}],nucleus:"13C",solvent:"CDCl₃"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:14.08,assignment:"CH₃"}],from:14.07625,to:14.08375},{signals:[{delta:22.38,assignment:"CH₂(2,4)"}],from:22.37625,to:22.38375},{signals:[{delta:34.16,assignment:"CH₂(3)"}],from:34.15625,to:34.16374999999999}],nucleus:"13C",solvent:"CDCl₃"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.63,assignment:"CH₃"}],from:16.62625,to:16.63375},{signals:[{delta:16.37,assignment:"CH₂"}],from:16.36625,to:16.37375}],nucleus:"13C",solvent:"CDCl₃"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.14,assignment:"CH₃"}],from:25.13625,to:25.14375},{signals:[{delta:64.5,assignment:"CH"}],from:64.49625,to:64.50375}],nucleus:"13C",solvent:"CDCl₃"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.5,assignment:"CH₃"}],from:19.49625,to:19.50375},{signals:[{delta:115.74,assignment:"CH₂"}],from:115.73625,to:115.74374999999999},{signals:[{delta:133.91,assignment:"CH"}],from:133.90625,to:133.91375}],nucleus:"13C",solvent:"CDCl₃"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:149.9,assignment:"CH(2,6)"}],from:149.89625,to:149.90375},{signals:[{delta:123.75,assignment:"CH(3,5)"}],from:123.74625,to:123.75375},{signals:[{delta:135.96,assignment:"CH(4)"}],from:135.95625,to:135.96375}],nucleus:"13C",solvent:"CDCl₃"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:117.77,assignment:"CH(2,5)"}],from:117.76625,to:117.77374999999999},{signals:[{delta:107.98,assignment:"CH(3,4)"}],from:107.97625000000001,to:107.98375}],nucleus:"13C",solvent:"CDCl₃"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:46.93,assignment:"CH₂(2,5)"}],from:46.92625,to:46.933749999999996},{signals:[{delta:25.56,assignment:"CH₂(3,4)"}],from:25.55625,to:25.56375}],nucleus:"13C",solvent:"CDCl₃"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{delta:1.19,assignment:"CH₃"}],from:1.18625,to:1.1937499999999999}],nucleus:"13C",solvent:"CDCl₃"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:67.97,assignment:"CH₂(2,5)"}],from:67.96625,to:67.97375},{signals:[{delta:25.62,assignment:"CH₂(3,4)"}],from:25.61625,to:25.62375}],nucleus:"13C",solvent:"CDCl₃"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:21.46,assignment:"CH₃"}],from:21.45625,to:21.46375},{signals:[{delta:137.89,assignment:"C(1)"}],from:137.88625,to:137.89374999999998},{signals:[{delta:129.07,assignment:"CH(2,6)"}],from:129.06625,to:129.07375},{signals:[{delta:128.26,assignment:"CH(3,5)"}],from:128.25625,to:128.26375},{signals:[{delta:125.33,assignment:"CH(4)"}],from:125.32625,to:125.33375}],nucleus:"13C",solvent:"CDCl₃"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:11.61,assignment:"CH₃"}],from:11.60625,to:11.61375},{signals:[{delta:46.25,assignment:"CH₂"}],from:46.24625,to:46.25375}],nucleus:"13C",solvent:"CDCl₃"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:175.3,assignment:"CO"}],from:175.29625000000001,to:175.30375},{signals:[{delta:20.27,assignment:"CH₃"}],from:20.26625,to:20.27375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:204,assignment:"CO"}],from:203.99625,to:204.00375},{signals:[{delta:30.03,assignment:"CH₃"}],from:30.02625,to:30.03375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:115.76,assignment:"CN"}],from:115.75625000000001,to:115.76375},{signals:[{delta:.03,assignment:"CH₃"}],from:.02625,to:.03375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:128.57,assignment:"CH"}],from:128.56625,to:128.57375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:68.12,assignment:"(CH₃)₃C"}],from:68.11625000000001,to:68.12375},{signals:[{delta:30.49,assignment:"(CH₃)₃C"}],from:30.48625,to:30.49375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:124.86,assignment:"CO₂"}],from:124.85625,to:124.86375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:192.71,assignment:"CS₂"}],from:192.70625,to:192.71375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:96.57,assignment:"CCl₄"}],from:96.56625,to:96.57374999999999}],nucleus:"13C",solvent:"toluene- d₈"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:77.89,assignment:"CH"}],from:77.88625,to:77.89375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:70.86,assignment:"CH₂"}],from:70.85625,to:70.86375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:27.31,assignment:"CH₂"}],from:27.30625,to:27.31375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:43.4,assignment:"CH₂"}],from:43.39625,to:43.403749999999995}],nucleus:"13C",solvent:"toluene- d₈"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:53.47,assignment:"CH₂"}],from:53.46625,to:53.473749999999995}],nucleus:"13C",solvent:"toluene- d₈"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.47,assignment:"CH₃"}],from:15.46625,to:15.47375},{signals:[{delta:65.94,assignment:"CH₂"}],from:65.93625,to:65.94375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:58.62,assignment:"CH₃"}],from:58.61625,to:58.623749999999994},{signals:[{delta:70.92,assignment:"CH₂"}],from:70.91625,to:70.92375},{signals:[{delta:72.39,assignment:"CH₂"}],from:72.38625,to:72.39375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:161.93,assignment:"CH"}],from:161.92625,to:161.93375},{signals:[{delta:35.22,assignment:"CH₃"}],from:35.21625,to:35.223749999999995},{signals:[{delta:30.64,assignment:"CH₃"}],from:30.63625,to:30.64375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:67.17,assignment:"CH₂"}],from:67.16625,to:67.17375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:58.63,assignment:"CH₃"}],from:58.626250000000006,to:58.63375},{signals:[{delta:72.25,assignment:"CH₂"}],from:72.24625,to:72.25375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:6.94,assignment:"CH₃"}],from:6.93625,to:6.9437500000000005}],nucleus:"13C",solvent:"toluene- d₈"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.78,assignment:"CH₃"}],from:18.77625,to:18.78375},{signals:[{delta:57.81,assignment:"CH₂"}],from:57.806250000000006,to:57.81375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:20.46,assignment:"CH₃CO"}],from:20.45625,to:20.46375},{signals:[{delta:170.02,assignment:"CO"}],from:170.01625,to:170.02375},{signals:[{delta:60.08,assignment:"CH₂"}],from:60.07625,to:60.083749999999995},{signals:[{delta:14.23,assignment:"CH₃"}],from:14.22625,to:14.23375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:122.92,assignment:"CH₂"}],from:122.91625,to:122.92375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:64.29,assignment:"CH₂"}],from:64.28625000000001,to:64.29375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["H grease"],smiles:"",ranges:[{signals:[{delta:30.31,assignment:"CH₂"}],from:30.30625,to:30.31375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:131.72,assignment:"C"}],from:131.71625,to:131.72375},{signals:[{delta:16.84,assignment:"CH₃"}],from:16.83625,to:16.84375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:14.34,assignment:"CH₃"}],from:14.33625,to:14.34375},{signals:[{delta:23.12,assignment:"CH₂(2,5)"}],from:23.11625,to:23.12375},{signals:[{delta:32.06,assignment:"CH₂(3,4)"}],from:32.056250000000006,to:32.06375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:1.99,assignment:"CH₃"}],from:1.98625,to:1.99375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:36.8,assignment:"CH₃"}],from:36.79625,to:36.803749999999994}],nucleus:"13C",solvent:"toluene- d₈"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:135.57,assignment:"CH(2)"}],from:135.56625,to:135.57375},{signals:[{delta:122.13,assignment:"CH(4,5)"}],from:122.12625,to:122.13374999999999}],nucleus:"13C",solvent:"toluene- d₈"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-4.34,assignment:"CH₄"}],from:-4.34375,to:-4.33625}],nucleus:"13C",solvent:"toluene- d₈"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:49.9,assignment:"CH₃"}],from:49.89625,to:49.903749999999995}],nucleus:"13C",solvent:"toluene- d₈"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:61.14,assignment:"CH₃"}],from:61.136250000000004,to:61.14375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:14.27,assignment:"CH₃"}],from:14.26625,to:14.27375},{signals:[{delta:22.79,assignment:"CH₂(2,4)"}],from:22.78625,to:22.79375},{signals:[{delta:34.54,assignment:"CH₂(3)"}],from:34.53625,to:34.543749999999996}],nucleus:"13C",solvent:"toluene- d₈"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.65,assignment:"CH₃"}],from:16.64625,to:16.65375},{signals:[{delta:16.63,assignment:"CH₂"}],from:16.62625,to:16.63375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.24,assignment:"CH₃"}],from:25.23625,to:25.24375},{signals:[{delta:64.12,assignment:"CH"}],from:64.11625000000001,to:64.12375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.32,assignment:"CH₃"}],from:19.31625,to:19.32375},{signals:[{delta:115.89,assignment:"CH₂"}],from:115.88625,to:115.89375},{signals:[{delta:133.61,assignment:"CH"}],from:133.60625000000002,to:133.61375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:150.25,assignment:"CH(2,6)"}],from:150.24625,to:150.25375},{signals:[{delta:123.46,assignment:"CH(3,5)"}],from:123.45625,to:123.46374999999999},{signals:[{delta:135.17,assignment:"CH(4)"}],from:135.16625,to:135.17374999999998}],nucleus:"13C",solvent:"toluene- d₈"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:117.61,assignment:"CH(2,5)"}],from:117.60625,to:117.61375},{signals:[{delta:108.15,assignment:"CH(3,4)"}],from:108.14625000000001,to:108.15375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:47.12,assignment:"CH₂(2,5)"}],from:47.11625,to:47.123749999999994},{signals:[{delta:25.75,assignment:"CH₂(3,4)"}],from:25.74625,to:25.75375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{delta:1.37,assignment:"CH₃"}],from:1.3662500000000002,to:1.37375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:67.75,assignment:"CH₂(2,5)"}],from:67.74625,to:67.75375},{signals:[{delta:25.79,assignment:"CH₂(3,4)"}],from:25.78625,to:25.79375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:21.37,assignment:"CH₃"}],from:21.36625,to:21.37375},{signals:[{delta:137.84,assignment:"C(1)"}],from:137.83625,to:137.84375},{signals:[{delta:129.33,assignment:"CH(2,6)"}],from:129.32625000000002,to:129.33375},{signals:[{delta:128.51,assignment:"CH(3,5)"}],from:128.50625,to:128.51375},{signals:[{delta:125.66,assignment:"CH(4)"}],from:125.65625,to:125.66375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:12.39,assignment:"CH₃"}],from:12.38625,to:12.39375},{signals:[{delta:46.82,assignment:"CH₂"}],from:46.816250000000004,to:46.82375}],nucleus:"13C",solvent:"toluene- d₈"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:175.82,assignment:"CO"}],from:175.81625,to:175.82375},{signals:[{delta:20.37,assignment:"CH₃"}],from:20.36625,to:20.37375}],nucleus:"13C",solvent:"C₆D₆"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:204.43,assignment:"CO"}],from:204.42625,to:204.43375},{signals:[{delta:30.14,assignment:"CH₃"}],from:30.13625,to:30.14375}],nucleus:"13C",solvent:"C₆D₆"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:116.02,assignment:"CN"}],from:116.01625,to:116.02374999999999},{signals:[{delta:.2,assignment:"CH₃"}],from:.19625,to:.20375000000000001}],nucleus:"13C",solvent:"C₆D₆"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:128.62,assignment:"CH"}],from:128.61625,to:128.62375}],nucleus:"13C",solvent:"C₆D₆"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:68.19,assignment:"(CH₃)₃C"}],from:68.18625,to:68.19375},{signals:[{delta:30.47,assignment:"(CH₃)₃C"}],from:30.46625,to:30.47375}],nucleus:"13C",solvent:"C₆D₆"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:124.76,assignment:"CO₂"}],from:124.75625000000001,to:124.76375}],nucleus:"13C",solvent:"C₆D₆"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:192.69,assignment:"CS₂"}],from:192.68625,to:192.69375}],nucleus:"13C",solvent:"C₆D₆"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:96.44,assignment:"CCl₄"}],from:96.43625,to:96.44375}],nucleus:"13C",solvent:"C₆D₆"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:77.79,assignment:"CH"}],from:77.78625000000001,to:77.79375}],nucleus:"13C",solvent:"C₆D₆"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:70.59,assignment:"CH₂"}],from:70.58625,to:70.59375}],nucleus:"13C",solvent:"C₆D₆"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:27.23,assignment:"CH₂"}],from:27.22625,to:27.23375}],nucleus:"13C",solvent:"C₆D₆"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:43.59,assignment:"CH₂"}],from:43.58625000000001,to:43.59375}],nucleus:"13C",solvent:"C₆D₆"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:53.46,assignment:"CH₂"}],from:53.456250000000004,to:53.46375}],nucleus:"13C",solvent:"C₆D₆"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.46,assignment:"CH₃"}],from:15.45625,to:15.463750000000001},{signals:[{delta:65.94,assignment:"CH₂"}],from:65.93625,to:65.94375}],nucleus:"13C",solvent:"C₆D₆"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:58.66,assignment:"CH₃"}],from:58.65625,to:58.66374999999999},{signals:[{delta:70.87,assignment:"CH₂"}],from:70.86625000000001,to:70.87375},{signals:[{delta:72.35,assignment:"CH₂"}],from:72.34625,to:72.35374999999999}],nucleus:"13C",solvent:"C₆D₆"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:162.13,assignment:"CH"}],from:162.12625,to:162.13375},{signals:[{delta:35.25,assignment:"CH₃"}],from:35.24625,to:35.25375},{signals:[{delta:30.72,assignment:"CH₃"}],from:30.71625,to:30.72375}],nucleus:"13C",solvent:"C₆D₆"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:67.16,assignment:"CH₂"}],from:67.15625,to:67.16375}],nucleus:"13C",solvent:"C₆D₆"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:58.68,assignment:"CH₃"}],from:58.67625,to:58.683749999999996},{signals:[{delta:72.21,assignment:"CH₂"}],from:72.20625,to:72.21374999999999}],nucleus:"13C",solvent:"C₆D₆"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:6.96,assignment:"CH₃"}],from:6.95625,to:6.96375}],nucleus:"13C",solvent:"C₆D₆"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.72,assignment:"CH₃"}],from:18.71625,to:18.72375},{signals:[{delta:57.86,assignment:"CH₂"}],from:57.85625,to:57.863749999999996}],nucleus:"13C",solvent:"C₆D₆"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:20.56,assignment:"CH₃CO"}],from:20.55625,to:20.56375},{signals:[{delta:170.44,assignment:"CO"}],from:170.43625,to:170.44375},{signals:[{delta:60.21,assignment:"CH₂"}],from:60.206250000000004,to:60.21375},{signals:[{delta:14.19,assignment:"CH₃"}],from:14.18625,to:14.19375}],nucleus:"13C",solvent:"C₆D₆"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:122.96,assignment:"CH₂"}],from:122.95625,to:122.96374999999999}],nucleus:"13C",solvent:"C₆D₆"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:64.34,assignment:"CH₂"}],from:64.33625,to:64.34375}],nucleus:"13C",solvent:"C₆D₆"},{names:["H grease"],smiles:"",ranges:[{signals:[{delta:30.22,assignment:"CH₂"}],from:30.21625,to:30.22375}],nucleus:"13C",solvent:"C₆D₆"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:131.79,assignment:"C"}],from:131.78625,to:131.79375},{signals:[{delta:16.95,assignment:"CH₃"}],from:16.94625,to:16.95375}],nucleus:"13C",solvent:"C₆D₆"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:14.32,assignment:"CH₃"}],from:14.31625,to:14.32375},{signals:[{delta:23.04,assignment:"CH₂(2,5)"}],from:23.03625,to:23.04375},{signals:[{delta:31.96,assignment:"CH₂(3,4)"}],from:31.95625,to:31.96375}],nucleus:"13C",solvent:"C₆D₆"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:2.05,assignment:"CH₃"}],from:2.0462499999999997,to:2.05375}],nucleus:"13C",solvent:"C₆D₆"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:36.88,assignment:"CH₃"}],from:36.876250000000006,to:36.88375}],nucleus:"13C",solvent:"C₆D₆"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:135.76,assignment:"CH(2)"}],from:135.75625,to:135.76375},{signals:[{delta:122.16,assignment:"CH(4,5)"}],from:122.15625,to:122.16375}],nucleus:"13C",solvent:"C₆D₆"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-4.29,assignment:"CH₄"}],from:-4.29375,to:-4.28625}],nucleus:"13C",solvent:"C₆D₆"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:49.97,assignment:"CH₃"}],from:49.96625,to:49.973749999999995}],nucleus:"13C",solvent:"C₆D₆"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:61.16,assignment:"CH₃"}],from:61.15625,to:61.16374999999999}],nucleus:"13C",solvent:"C₆D₆"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:14.25,assignment:"CH₃"}],from:14.24625,to:14.25375},{signals:[{delta:22.72,assignment:"CH₂(2,4)"}],from:22.71625,to:22.72375},{signals:[{delta:34.45,assignment:"CH₂(3)"}],from:34.446250000000006,to:34.45375}],nucleus:"13C",solvent:"C₆D₆"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.66,assignment:"CH₃"}],from:16.65625,to:16.66375},{signals:[{delta:16.6,assignment:"CH₂"}],from:16.59625,to:16.60375}],nucleus:"13C",solvent:"C₆D₆"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.18,assignment:"CH₃"}],from:25.17625,to:25.18375},{signals:[{delta:64.23,assignment:"CH"}],from:64.22625000000001,to:64.23375}],nucleus:"13C",solvent:"C₆D₆"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.38,assignment:"CH₃"}],from:19.37625,to:19.38375},{signals:[{delta:115.92,assignment:"CH₂"}],from:115.91625,to:115.92375},{signals:[{delta:133.69,assignment:"CH"}],from:133.68625,to:133.69375}],nucleus:"13C",solvent:"C₆D₆"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:150.27,assignment:"CH(2,6)"}],from:150.26625,to:150.27375},{signals:[{delta:123.58,assignment:"CH(3,5)"}],from:123.57625,to:123.58375},{signals:[{delta:135.28,assignment:"CH(4)"}],from:135.27625,to:135.28375}],nucleus:"13C",solvent:"C₆D₆"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:117.78,assignment:"CH(2,5)"}],from:117.77625,to:117.78375},{signals:[{delta:108.21,assignment:"CH(3,4)"}],from:108.20625,to:108.21374999999999}],nucleus:"13C",solvent:"C₆D₆"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:46.86,assignment:"CH₂(2,5)"}],from:46.85625,to:46.863749999999996},{signals:[{delta:25.65,assignment:"CH₂(3,4)"}],from:25.64625,to:25.65375}],nucleus:"13C",solvent:"C₆D₆"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{delta:1.38,assignment:"CH₃"}],from:1.37625,to:1.3837499999999998}],nucleus:"13C",solvent:"C₆D₆"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:67.8,assignment:"CH₂(2,5)"}],from:67.79625,to:67.80375},{signals:[{delta:25.72,assignment:"CH₂(3,4)"}],from:25.71625,to:25.72375}],nucleus:"13C",solvent:"C₆D₆"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:21.1,assignment:"CH₃"}],from:21.09625,to:21.10375},{signals:[{delta:137.91,assignment:"C(1)"}],from:137.90625,to:137.91375},{signals:[{delta:129.33,assignment:"CH(2,6)"}],from:129.32625000000002,to:129.33375},{signals:[{delta:128.56,assignment:"CH(3,5)"}],from:128.55625,to:128.56375},{signals:[{delta:125.68,assignment:"CH(4)"}],from:125.67625000000001,to:125.68375}],nucleus:"13C",solvent:"C₆D₆"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:12.35,assignment:"CH₃"}],from:12.34625,to:12.35375},{signals:[{delta:46.77,assignment:"CH₂"}],from:46.76625000000001,to:46.77375}],nucleus:"13C",solvent:"C₆D₆"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:175.67,assignment:"CO"}],from:175.66625,to:175.67374999999998},{signals:[{delta:20.4,assignment:"CH₃"}],from:20.39625,to:20.40375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:204.83,assignment:"CO"}],from:204.82625000000002,to:204.83375},{signals:[{delta:30.12,assignment:"CH₃"}],from:30.11625,to:30.12375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:115.93,assignment:"CN"}],from:115.92625000000001,to:115.93375},{signals:[{delta:.63,assignment:"CH₃"}],from:.62625,to:.63375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:128.38,assignment:"CH"}],from:128.37625,to:128.38375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:68.19,assignment:"(CH₃)₃C"}],from:68.18625,to:68.19375},{signals:[{delta:31.13,assignment:"(CH₃)₃C"}],from:31.12625,to:31.13375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:126.08,assignment:"CO₂"}],from:126.07625,to:126.08375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:192.49,assignment:"CS₂"}],from:192.48625,to:192.49375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:96.38,assignment:"CCl₄"}],from:96.37625,to:96.38374999999999}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:77.67,assignment:"CH"}],from:77.66625,to:77.67375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:70.55,assignment:"CH₂"}],from:70.54625,to:70.55375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:26.99,assignment:"CH₂"}],from:26.98625,to:26.99375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:43.6,assignment:"CH₂"}],from:43.596250000000005,to:43.60375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:53.54,assignment:"CH₂"}],from:53.53625,to:53.543749999999996}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.35,assignment:"CH₃"}],from:15.34625,to:15.35375},{signals:[{delta:65.79,assignment:"CH₂"}],from:65.78625000000001,to:65.79375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:58.42,assignment:"CH₃"}],from:58.416250000000005,to:58.42375},{signals:[{delta:70.56,assignment:"CH₂"}],from:70.55625,to:70.56375},{signals:[{delta:72.07,assignment:"CH₂"}],from:72.06625,to:72.07374999999999}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:162.01,assignment:"CH"}],from:162.00625,to:162.01375},{signals:[{delta:35.45,assignment:"CH₃"}],from:35.446250000000006,to:35.45375},{signals:[{delta:30.71,assignment:"CH₃"}],from:30.70625,to:30.71375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:66.95,assignment:"CH₂"}],from:66.94625,to:66.95375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:58.31,assignment:"CH₃"}],from:58.306250000000006,to:58.31375},{signals:[{delta:71.81,assignment:"CH₂"}],from:71.80625,to:71.81375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:6.91,assignment:"CH₃"}],from:6.90625,to:6.91375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.55,assignment:"CH₃"}],from:18.54625,to:18.55375},{signals:[{delta:57.63,assignment:"CH₂"}],from:57.626250000000006,to:57.63375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:20.5,assignment:"CH₃CO"}],from:20.49625,to:20.50375},{signals:[{delta:170.2,assignment:"CO"}],from:170.19625,to:170.20374999999999},{signals:[{delta:60.06,assignment:"CH₂"}],from:60.056250000000006,to:60.06375},{signals:[{delta:14.07,assignment:"CH₃"}],from:14.06625,to:14.07375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:122.95,assignment:"CH₂"}],from:122.94625,to:122.95375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:64.03,assignment:"CH₂"}],from:64.02625,to:64.03375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["H grease"],smiles:"",ranges:[{signals:[{delta:30.11,assignment:"CH₂"}],from:30.10625,to:30.11375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:131.54,assignment:"C"}],from:131.53625,to:131.54375},{signals:[{delta:16.68,assignment:"CH₃"}],from:16.67625,to:16.68375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:14.18,assignment:"CH₃"}],from:14.17625,to:14.18375},{signals:[{delta:22.86,assignment:"CH₂(2,5)"}],from:22.85625,to:22.86375},{signals:[{delta:31.77,assignment:"CH₂(3,4)"}],from:31.76625,to:31.77375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:1.92,assignment:"CH₃"}],from:1.91625,to:1.9237499999999998}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:36.64,assignment:"CH₃"}],from:36.636250000000004,to:36.64375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:135.5,assignment:"CH(2)"}],from:135.49625,to:135.50375},{signals:[{delta:121.96,assignment:"CH(4,5)"}],from:121.95625,to:121.96374999999999}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-4.33,assignment:"CH₄"}],from:-4.33375,to:-4.32625}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:49.66,assignment:"CH₃"}],from:49.65625,to:49.66374999999999}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:61.68,assignment:"CH₃"}],from:61.67625,to:61.683749999999996}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:14.1,assignment:"CH₃"}],from:14.09625,to:14.10375},{signals:[{delta:22.54,assignment:"CH₂(2,4)"}],from:22.53625,to:22.54375},{signals:[{delta:34.26,assignment:"CH₂(3)"}],from:34.25625,to:34.263749999999995}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.56,assignment:"CH₃"}],from:16.55625,to:16.56375},{signals:[{delta:16.48,assignment:"CH₂"}],from:16.47625,to:16.48375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.14,assignment:"CH₃"}],from:25.13625,to:25.14375},{signals:[{delta:64.18,assignment:"CH"}],from:64.17625000000001,to:64.18375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.32,assignment:"CH₃"}],from:19.31625,to:19.32375},{signals:[{delta:115.86,assignment:"CH₂"}],from:115.85625,to:115.86375},{signals:[{delta:133.57,assignment:"CH"}],from:133.56625,to:133.57375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:149.93,assignment:"CH(2,6)"}],from:149.92625,to:149.93375},{signals:[{delta:123.49,assignment:"CH(3,5)"}],from:123.48625,to:123.49374999999999},{signals:[{delta:135.32,assignment:"CH(4)"}],from:135.31625,to:135.32375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:117.65,assignment:"CH(2,5)"}],from:117.64625000000001,to:117.65375},{signals:[{delta:108.03,assignment:"CH(3,4)"}],from:108.02625,to:108.03375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:46.75,assignment:"CH₂(2,5)"}],from:46.74625,to:46.75375},{signals:[{delta:25.59,assignment:"CH₂(3,4)"}],from:25.58625,to:25.59375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{delta:1.09,assignment:"CH₃"}],from:1.0862500000000002,to:1.09375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:67.64,assignment:"CH₂(2,5)"}],from:67.63625,to:67.64375},{signals:[{delta:25.68,assignment:"CH₂(3,4)"}],from:25.67625,to:25.68375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:21.23,assignment:"CH₃"}],from:21.22625,to:21.23375},{signals:[{delta:137.65,assignment:"C(1)"}],from:137.64625,to:137.65375},{signals:[{delta:129.12,assignment:"CH(2,6)"}],from:129.11625,to:129.12375},{signals:[{delta:128.31,assignment:"CH(3,5)"}],from:128.30625,to:128.31375},{signals:[{delta:125.43,assignment:"CH(4)"}],from:125.42625000000001,to:125.43375}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:11.87,assignment:"CH₃"}],from:11.866249999999999,to:11.87375},{signals:[{delta:46.36,assignment:"CH₂"}],from:46.35625,to:46.363749999999996}],nucleus:"13C",solvent:"C₆D₅Cl"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:172.31,assignment:"CO"}],from:172.30625,to:172.31375},{signals:[{delta:20.51,assignment:"CH₃"}],from:20.50625,to:20.51375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:205.87,assignment:"CO"}],from:205.86625,to:205.87375},{signals:[{delta:30.6,assignment:"CH₃"}],from:30.59625,to:30.60375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:117.6,assignment:"CN"}],from:117.59625,to:117.60374999999999},{signals:[{delta:1.12,assignment:"CH₃"}],from:1.1162500000000002,to:1.12375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:129.15,assignment:"CH"}],from:129.14625,to:129.15375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:68.13,assignment:"(CH₃)₃C"}],from:68.12625,to:68.13374999999999},{signals:[{delta:30.72,assignment:"(CH₃)₃C"}],from:30.71625,to:30.72375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:125.81,assignment:"CO₂"}],from:125.80625,to:125.81375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:193.58,assignment:"CS₂"}],from:193.57625000000002,to:193.58375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:96.65,assignment:"CCl₄"}],from:96.64625000000001,to:96.65375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:79.19,assignment:"CH"}],from:79.18625,to:79.19375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:71.25,assignment:"CH₂"}],from:71.24625,to:71.25375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:27.51,assignment:"CH₂"}],from:27.50625,to:27.51375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:45.25,assignment:"CH₂"}],from:45.24625,to:45.25375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:54.95,assignment:"CH₂"}],from:54.946250000000006,to:54.95375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.78,assignment:"CH₃"}],from:15.77625,to:15.78375},{signals:[{delta:66.12,assignment:"CH₂"}],from:66.11625000000001,to:66.12375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:58.77,assignment:"CH₃"}],from:58.76625000000001,to:58.77375},{signals:[{delta:71.03,assignment:"CH₂"}],from:71.02625,to:71.03375},{signals:[{delta:72.63,assignment:"CH₂"}],from:72.62625,to:72.63374999999999}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:162.79,assignment:"CH"}],from:162.78625,to:162.79375},{signals:[{delta:36.15,assignment:"CH₃"}],from:36.14625,to:36.153749999999995},{signals:[{delta:31.03,assignment:"CH₃"}],from:31.02625,to:31.03375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:67.6,assignment:"CH₂"}],from:67.59625,to:67.60374999999999}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:58.45,assignment:"CH₃"}],from:58.446250000000006,to:58.45375},{signals:[{delta:72.47,assignment:"CH₂"}],from:72.46625,to:72.47375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:6.88,assignment:"CH₃"}],from:6.87625,to:6.88375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.89,assignment:"CH₃"}],from:18.88625,to:18.89375},{signals:[{delta:57.72,assignment:"CH₂"}],from:57.71625,to:57.723749999999995}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:20.83,assignment:"CH₃CO"}],from:20.826249999999998,to:20.83375},{signals:[{delta:170.96,assignment:"CO"}],from:170.95625,to:170.96375},{signals:[{delta:60.56,assignment:"CH₂"}],from:60.556250000000006,to:60.56375},{signals:[{delta:14.5,assignment:"CH₃"}],from:14.49625,to:14.50375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:123.47,assignment:"CH₂"}],from:123.46625,to:123.47375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:64.26,assignment:"CH₂"}],from:64.25625000000001,to:64.26375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["H grease"],smiles:"",ranges:[],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:132.22,assignment:"C"}],from:132.21625,to:132.22375},{signals:[{delta:16.86,assignment:"CH₃"}],from:16.85625,to:16.86375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:14.34,assignment:"CH₃"}],from:14.33625,to:14.34375},{signals:[{delta:23.28,assignment:"CH₂(2,5)"}],from:23.27625,to:23.28375},{signals:[{delta:32.3,assignment:"CH₂(3,4)"}],from:32.29625,to:32.303749999999994}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:2.01,assignment:"CH₃"}],from:2.0062499999999996,to:2.01375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:37.04,assignment:"CH₃"}],from:37.03625,to:37.043749999999996}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:135.89,assignment:"CH(2)"}],from:135.88625,to:135.89374999999998},{signals:[{delta:122.31,assignment:"CH(4,5)"}],from:122.30625,to:122.31375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-5.33,assignment:"CH₄"}],from:-5.33375,to:-5.32625}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:49.77,assignment:"CH₃"}],from:49.76625000000001,to:49.77375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:63.21,assignment:"CH₃"}],from:63.206250000000004,to:63.21375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:14.29,assignment:"CH₃"}],from:14.286249999999999,to:14.29375},{signals:[{delta:22.98,assignment:"CH₂(2,4)"}],from:22.97625,to:22.98375},{signals:[{delta:34.83,assignment:"CH₂(3)"}],from:34.82625,to:34.833749999999995}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.68,assignment:"CH₃"}],from:16.67625,to:16.68375},{signals:[{delta:16.78,assignment:"CH₂"}],from:16.77625,to:16.78375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.67,assignment:"CH₃"}],from:25.66625,to:25.673750000000002},{signals:[{delta:63.85,assignment:"CH"}],from:63.846250000000005,to:63.85375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.42,assignment:"CH₃"}],from:19.41625,to:19.423750000000002},{signals:[{delta:116.03,assignment:"CH₂"}],from:116.02625,to:116.03375},{signals:[{delta:134.34,assignment:"CH"}],from:134.33625,to:134.34375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:150.67,assignment:"CH(2,6)"}],from:150.66625,to:150.67374999999998},{signals:[{delta:124.57,assignment:"CH(3,5)"}],from:124.56625,to:124.57374999999999},{signals:[{delta:136.56,assignment:"CH(4)"}],from:136.55625,to:136.56375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:117.98,assignment:"CH(2,5)"}],from:117.97625000000001,to:117.98375},{signals:[{delta:108.04,assignment:"CH(3,4)"}],from:108.03625000000001,to:108.04375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{delta:1.4,assignment:"CH₃"}],from:1.39625,to:1.4037499999999998}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:68.07,assignment:"CH₂(2,5)"}],from:68.06625,to:68.07374999999999},{signals:[{delta:26.15,assignment:"CH₂(3,4)"}],from:26.14625,to:26.15375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:21.46,assignment:"CH₃"}],from:21.45625,to:21.46375},{signals:[{delta:138.48,assignment:"C(1)"}],from:138.47625,to:138.48375},{signals:[{delta:129.76,assignment:"CH(2,6)"}],from:129.75625,to:129.76375},{signals:[{delta:129.03,assignment:"CH(3,5)"}],from:129.02625,to:129.03375},{signals:[{delta:126.12,assignment:"CH(4)"}],from:126.11625000000001,to:126.12375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:12.49,assignment:"CH₃"}],from:12.48625,to:12.49375},{signals:[{delta:47.07,assignment:"CH₂"}],from:47.066250000000004,to:47.07375}],nucleus:"13C",solvent:"(CD₃)₂CO"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:171.93,assignment:"CO"}],from:171.92625,to:171.93375},{signals:[{delta:20.95,assignment:"CH₃"}],from:20.94625,to:20.95375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:206.31,assignment:"CO"}],from:206.30625,to:206.31375},{signals:[{delta:30.56,assignment:"CH₃"}],from:30.55625,to:30.56375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:117.91,assignment:"CN"}],from:117.90625,to:117.91375},{signals:[{delta:1.03,assignment:"CH₃"}],from:1.02625,to:1.03375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:128.3,assignment:"CH"}],from:128.29625000000001,to:128.30375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:66.88,assignment:"(CH₃)₃C"}],from:66.87625,to:66.88374999999999},{signals:[{delta:30.38,assignment:"(CH₃)₃C"}],from:30.37625,to:30.38375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:124.21,assignment:"CO₂"}],from:124.20625,to:124.21374999999999}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:192.63,assignment:"CS₂"}],from:192.62625,to:192.63375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:95.44,assignment:"CCl₄"}],from:95.43625,to:95.44375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:79.16,assignment:"CH"}],from:79.15625,to:79.16375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:69.85,assignment:"CH₂"}],from:69.84625,to:69.85374999999999}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:26.33,assignment:"CH₂"}],from:26.326249999999998,to:26.33375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:45.02,assignment:"CH₂"}],from:45.01625000000001,to:45.02375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:54.84,assignment:"CH₂"}],from:54.83625000000001,to:54.84375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.12,assignment:"CH₃"}],from:15.116249999999999,to:15.12375},{signals:[{delta:62.05,assignment:"CH₂"}],from:62.04625,to:62.053749999999994}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:57.98,assignment:"CH₃"}],from:57.97625,to:57.98374999999999},{signals:[{delta:69.54,assignment:"CH₂"}],from:69.53625000000001,to:69.54375},{signals:[{delta:71.25,assignment:"CH₂"}],from:71.24625,to:71.25375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:162.29,assignment:"CH"}],from:162.28625,to:162.29375},{signals:[{delta:35.73,assignment:"CH₃"}],from:35.72625,to:35.73374999999999},{signals:[{delta:30.73,assignment:"CH₃"}],from:30.72625,to:30.73375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:66.36,assignment:"CH₂"}],from:66.35625,to:66.36375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:58.03,assignment:"CH₃"}],from:58.026250000000005,to:58.03375},{signals:[{delta:71.17,assignment:"CH₂"}],from:71.16625,to:71.17375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:6.61,assignment:"CH₃"}],from:6.60625,to:6.6137500000000005}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.51,assignment:"CH₃"}],from:18.50625,to:18.51375},{signals:[{delta:56.07,assignment:"CH₂"}],from:56.066250000000004,to:56.07375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:20.68,assignment:"CH₃CO"}],from:20.67625,to:20.68375},{signals:[{delta:170.31,assignment:"CO"}],from:170.30625,to:170.31375},{signals:[{delta:59.74,assignment:"CH₂"}],from:59.736250000000005,to:59.74375},{signals:[{delta:14.4,assignment:"CH₃"}],from:14.39625,to:14.40375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:123.52,assignment:"CH₂"}],from:123.51625,to:123.52374999999999}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:62.76,assignment:"CH₂"}],from:62.75625,to:62.763749999999995}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["H grease"],smiles:"",ranges:[],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:131.1,assignment:"C"}],from:131.09625,to:131.10375},{signals:[{delta:16.6,assignment:"CH₃"}],from:16.59625,to:16.60375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:13.88,assignment:"CH₃"}],from:13.87625,to:13.883750000000001},{signals:[{delta:22.05,assignment:"CH₂(2,5)"}],from:22.04625,to:22.05375},{signals:[{delta:30.95,assignment:"CH₂(3,4)"}],from:30.94625,to:30.95375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:1.96,assignment:"CH₃"}],from:1.95625,to:1.9637499999999999}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:36.42,assignment:"CH₃"}],from:36.416250000000005,to:36.42375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:135.15,assignment:"CH(2)"}],from:135.14625,to:135.15375},{signals:[{delta:121.55,assignment:"CH(4,5)"}],from:121.54625,to:121.55375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-4.01,assignment:"CH₄"}],from:-4.01375,to:-4.00625}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:48.59,assignment:"CH₃"}],from:48.58625000000001,to:48.59375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:63.28,assignment:"CH₃"}],from:63.276250000000005,to:63.28375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:13.28,assignment:"CH₃"}],from:13.27625,to:13.28375},{signals:[{delta:21.7,assignment:"CH₂(2,4)"}],from:21.69625,to:21.70375},{signals:[{delta:33.48,assignment:"CH₂(3)"}],from:33.47625,to:33.48374999999999}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.34,assignment:"CH₃"}],from:16.33625,to:16.34375},{signals:[{delta:15.67,assignment:"CH₂"}],from:15.66625,to:15.67375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.43,assignment:"CH₃"}],from:25.42625,to:25.43375},{signals:[{delta:64.92,assignment:"CH"}],from:64.91625,to:64.92375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.2,assignment:"CH₃"}],from:19.19625,to:19.20375},{signals:[{delta:116.07,assignment:"CH₂"}],from:116.06625,to:116.07374999999999},{signals:[{delta:133.55,assignment:"CH"}],from:133.54625000000001,to:133.55375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:149.58,assignment:"CH(2,6)"}],from:149.57625000000002,to:149.58375},{signals:[{delta:123.84,assignment:"CH(3,5)"}],from:123.83625,to:123.84375},{signals:[{delta:136.05,assignment:"CH(4)"}],from:136.04625000000001,to:136.05375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:117.32,assignment:"CH(2,5)"}],from:117.31625,to:117.32374999999999},{signals:[{delta:107.07,assignment:"CH(3,4)"}],from:107.06625,to:107.07374999999999}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:46.51,assignment:"CH₂(2,5)"}],from:46.50625,to:46.513749999999995},{signals:[{delta:25.26,assignment:"CH₂(3,4)"}],from:25.25625,to:25.26375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["silicone grease"],smiles:"",ranges:[],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:67.03,assignment:"CH₂(2,5)"}],from:67.02625,to:67.03375},{signals:[{delta:25.14,assignment:"CH₂(3,4)"}],from:25.13625,to:25.14375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:20.99,assignment:"CH₃"}],from:20.98625,to:20.99375},{signals:[{delta:137.35,assignment:"C(1)"}],from:137.34625,to:137.35375},{signals:[{delta:128.88,assignment:"CH(2,6)"}],from:128.87625,to:128.88375},{signals:[{delta:128.18,assignment:"CH(3,5)"}],from:128.17625,to:128.18375},{signals:[{delta:125.29,assignment:"CH(4)"}],from:125.28625000000001,to:125.29375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:11.74,assignment:"CH₃"}],from:11.73625,to:11.74375},{signals:[{delta:45.74,assignment:"CH₂"}],from:45.736250000000005,to:45.74375}],nucleus:"13C",solvent:"(CD₃)₂SO"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:173.21,assignment:"CO"}],from:173.20625,to:173.21375},{signals:[{delta:20.73,assignment:"CH₃"}],from:20.72625,to:20.73375}],nucleus:"13C",solvent:"CD₃CN"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:207.43,assignment:"CO"}],from:207.42625,to:207.43375},{signals:[{delta:30.91,assignment:"CH₃"}],from:30.90625,to:30.91375}],nucleus:"13C",solvent:"CD₃CN"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:118.26,assignment:"CN"}],from:118.25625000000001,to:118.26375},{signals:[{delta:1.79,assignment:"CH₃"}],from:1.7862500000000001,to:1.79375}],nucleus:"13C",solvent:"CD₃CN"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:129.32,assignment:"CH"}],from:129.31625,to:129.32375}],nucleus:"13C",solvent:"CD₃CN"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:68.74,assignment:"(CH₃)₃C"}],from:68.73625,to:68.74374999999999},{signals:[{delta:30.68,assignment:"(CH₃)₃C"}],from:30.67625,to:30.68375}],nucleus:"13C",solvent:"CD₃CN"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:125.89,assignment:"CO₂"}],from:125.88625,to:125.89375}],nucleus:"13C",solvent:"CD₃CN"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:193.6,assignment:"CS₂"}],from:193.59625,to:193.60375}],nucleus:"13C",solvent:"CD₃CN"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:96.68,assignment:"CCl₄"}],from:96.67625000000001,to:96.68375}],nucleus:"13C",solvent:"CD₃CN"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:79.17,assignment:"CH"}],from:79.16625,to:79.17375}],nucleus:"13C",solvent:"CD₃CN"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:71.22,assignment:"CH₂"}],from:71.21625,to:71.22375}],nucleus:"13C",solvent:"CD₃CN"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:27.63,assignment:"CH₂"}],from:27.62625,to:27.63375}],nucleus:"13C",solvent:"CD₃CN"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:45.54,assignment:"CH₂"}],from:45.53625,to:45.543749999999996}],nucleus:"13C",solvent:"CD₃CN"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:55.32,assignment:"CH₂"}],from:55.316250000000004,to:55.32375}],nucleus:"13C",solvent:"CD₃CN"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.63,assignment:"CH₃"}],from:15.62625,to:15.633750000000001},{signals:[{delta:66.32,assignment:"CH₂"}],from:66.31625,to:66.32374999999999}],nucleus:"13C",solvent:"CD₃CN"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:58.9,assignment:"CH₃"}],from:58.89625,to:58.903749999999995},{signals:[{delta:70.99,assignment:"CH₂"}],from:70.98625,to:70.99374999999999},{signals:[{delta:72.63,assignment:"CH₂"}],from:72.62625,to:72.63374999999999}],nucleus:"13C",solvent:"CD₃CN"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:163.31,assignment:"CH"}],from:163.30625,to:163.31375},{signals:[{delta:36.57,assignment:"CH₃"}],from:36.566250000000004,to:36.57375},{signals:[{delta:31.32,assignment:"CH₃"}],from:31.31625,to:31.32375}],nucleus:"13C",solvent:"CD₃CN"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:67.72,assignment:"CH₂"}],from:67.71625,to:67.72375}],nucleus:"13C",solvent:"CD₃CN"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:58.89,assignment:"CH₃"}],from:58.886250000000004,to:58.89375},{signals:[{delta:72.47,assignment:"CH₂"}],from:72.46625,to:72.47375}],nucleus:"13C",solvent:"CD₃CN"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:6.99,assignment:"CH₃"}],from:6.98625,to:6.99375}],nucleus:"13C",solvent:"CD₃CN"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.8,assignment:"CH₃"}],from:18.79625,to:18.80375},{signals:[{delta:57.96,assignment:"CH₂"}],from:57.956250000000004,to:57.96375}],nucleus:"13C",solvent:"CD₃CN"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:21.16,assignment:"CH₃CO"}],from:21.15625,to:21.16375},{signals:[{delta:171.68,assignment:"CO"}],from:171.67625,to:171.68375},{signals:[{delta:60.98,assignment:"CH₂"}],from:60.97625,to:60.98374999999999},{signals:[{delta:14.54,assignment:"CH₃"}],from:14.536249999999999,to:14.54375}],nucleus:"13C",solvent:"CD₃CN"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:123.69,assignment:"CH₂"}],from:123.68625,to:123.69375}],nucleus:"13C",solvent:"CD₃CN"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:64.22,assignment:"CH₂"}],from:64.21625,to:64.22375}],nucleus:"13C",solvent:"CD₃CN"},{names:["H grease"],smiles:"",ranges:[],nucleus:"13C",solvent:"CD₃CN"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:132.61,assignment:"C"}],from:132.60625000000002,to:132.61375},{signals:[{delta:16.94,assignment:"CH₃"}],from:16.93625,to:16.94375}],nucleus:"13C",solvent:"CD₃CN"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:14.43,assignment:"CH₃"}],from:14.42625,to:14.43375},{signals:[{delta:23.4,assignment:"CH₂(2,5)"}],from:23.39625,to:23.40375},{signals:[{delta:32.36,assignment:"CH₂(3,4)"}],from:32.35625,to:32.363749999999996}],nucleus:"13C",solvent:"CD₃CN"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:2.07,assignment:"CH₃"}],from:2.0662499999999997,to:2.07375}],nucleus:"13C",solvent:"CD₃CN"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:37.1,assignment:"CH₃"}],from:37.096250000000005,to:37.10375}],nucleus:"13C",solvent:"CD₃CN"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:136.33,assignment:"CH(2)"}],from:136.32625000000002,to:136.33375},{signals:[{delta:122.78,assignment:"CH(4,5)"}],from:122.77625,to:122.78375}],nucleus:"13C",solvent:"CD₃CN"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-4.61,assignment:"CH₄"}],from:-4.6137500000000005,to:-4.60625}],nucleus:"13C",solvent:"CD₃CN"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:49.9,assignment:"CH₃"}],from:49.89625,to:49.903749999999995}],nucleus:"13C",solvent:"CD₃CN"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:63.66,assignment:"CH₃"}],from:63.65625,to:63.66374999999999}],nucleus:"13C",solvent:"CD₃CN"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:14.37,assignment:"CH₃"}],from:14.366249999999999,to:14.37375},{signals:[{delta:23.08,assignment:"CH₂(2,4)"}],from:23.076249999999998,to:23.08375},{signals:[{delta:34.89,assignment:"CH₂(3)"}],from:34.886250000000004,to:34.89375}],nucleus:"13C",solvent:"CD₃CN"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.73,assignment:"CH₃"}],from:16.72625,to:16.73375},{signals:[{delta:16.91,assignment:"CH₂"}],from:16.90625,to:16.91375}],nucleus:"13C",solvent:"CD₃CN"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.55,assignment:"CH₃"}],from:25.54625,to:25.55375},{signals:[{delta:64.3,assignment:"CH"}],from:64.29625,to:64.30375}],nucleus:"13C",solvent:"CD₃CN"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.48,assignment:"CH₃"}],from:19.47625,to:19.48375},{signals:[{delta:116.12,assignment:"CH₂"}],from:116.11625000000001,to:116.12375},{signals:[{delta:134.78,assignment:"CH"}],from:134.77625,to:134.78375}],nucleus:"13C",solvent:"CD₃CN"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:150.76,assignment:"CH(2,6)"}],from:150.75625,to:150.76375},{signals:[{delta:127.76,assignment:"CH(3,5)"}],from:127.75625000000001,to:127.76375},{signals:[{delta:136.89,assignment:"CH(4)"}],from:136.88625,to:136.89374999999998}],nucleus:"13C",solvent:"CD₃CN"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:118.47,assignment:"CH(2,5)"}],from:118.46625,to:118.47375},{signals:[{delta:108.31,assignment:"CH(3,4)"}],from:108.30625,to:108.31375}],nucleus:"13C",solvent:"CD₃CN"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:47.57,assignment:"CH₂(2,5)"}],from:47.566250000000004,to:47.57375},{signals:[{delta:26.34,assignment:"CH₂(3,4)"}],from:26.33625,to:26.34375}],nucleus:"13C",solvent:"CD₃CN"},{names:["silicone grease"],smiles:"",ranges:[],nucleus:"13C",solvent:"CD₃CN"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:68.33,assignment:"CH₂(2,5)"}],from:68.32625,to:68.33375},{signals:[{delta:26.27,assignment:"CH₂(3,4)"}],from:26.26625,to:26.27375}],nucleus:"13C",solvent:"CD₃CN"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:21.5,assignment:"CH₃"}],from:21.49625,to:21.50375},{signals:[{delta:138.9,assignment:"C(1)"}],from:138.89625,to:138.90375},{signals:[{delta:129.94,assignment:"CH(2,6)"}],from:129.93625,to:129.94375},{signals:[{delta:129.23,assignment:"CH(3,5)"}],from:129.22625,to:129.23375},{signals:[{delta:126.28,assignment:"CH(4)"}],from:126.27625,to:126.28375}],nucleus:"13C",solvent:"CD₃CN"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:12.38,assignment:"CH₃"}],from:12.37625,to:12.383750000000001},{signals:[{delta:47.1,assignment:"CH₂"}],from:47.096250000000005,to:47.10375}],nucleus:"13C",solvent:"CD₃CN"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:177.96,assignment:"CO"}],from:177.95625,to:177.96375},{signals:[{delta:20.91,assignment:"CH₃"}],from:20.90625,to:20.91375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:32.35,assignment:"CO"}],from:32.346250000000005,to:32.35375},{signals:[{delta:214.98,assignment:"CH₃"}],from:214.97625,to:214.98375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:118.95,assignment:"CN"}],from:118.94625,to:118.95375},{signals:[{delta:1,assignment:"CH₃"}],from:.99625,to:1.00375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:129.84,assignment:"CH"}],from:129.83625,to:129.84375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:72.35,assignment:"(CH₃)₃C"}],from:72.34625,to:72.35374999999999},{signals:[{delta:31.07,assignment:"(CH₃)₃C"}],from:31.06625,to:31.07375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:126.92,assignment:"CO₂"}],from:126.91625,to:126.92375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:196.26,assignment:"CS₂"}],from:196.25625,to:196.26375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:97.74,assignment:"CCl₄"}],from:97.73625,to:97.74374999999999}],nucleus:"13C",solvent:"TFE-d₃"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:78.83,assignment:"CH"}],from:78.82625,to:78.83375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:70.8,assignment:"CH₂"}],from:70.79625,to:70.80375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:28.34,assignment:"CH₂"}],from:28.33625,to:28.34375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:45.28,assignment:"CH₂"}],from:45.276250000000005,to:45.28375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:54.46,assignment:"CH₂"}],from:54.456250000000004,to:54.46375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.33,assignment:"CH₃"}],from:15.32625,to:15.33375},{signals:[{delta:67.55,assignment:"CH₂"}],from:67.54625,to:67.55375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:59.4,assignment:"CH₃"}],from:59.39625,to:59.403749999999995},{signals:[{delta:73.05,assignment:"CH₂"}],from:73.04625,to:73.05375},{signals:[{delta:71.33,assignment:"CH₂"}],from:71.32625,to:71.33375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:166.01,assignment:"CH"}],from:166.00625,to:166.01375},{signals:[{delta:37.76,assignment:"CH₃"}],from:37.75625,to:37.763749999999995},{signals:[{delta:30.96,assignment:"CH₃"}],from:30.95625,to:30.96375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:68.52,assignment:"CH₂"}],from:68.51625,to:68.52374999999999}],nucleus:"13C",solvent:"TFE-d₃"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:59.52,assignment:"CH₃"}],from:59.51625000000001,to:59.52375},{signals:[{delta:72.87,assignment:"CH₂"}],from:72.86625000000001,to:72.87375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:7.01,assignment:"CH₃"}],from:7.00625,to:7.01375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.11,assignment:"CH₃"}],from:18.10625,to:18.11375},{signals:[{delta:59.68,assignment:"CH₂"}],from:59.67625,to:59.683749999999996}],nucleus:"13C",solvent:"TFE-d₃"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:21.18,assignment:"CH₃CO"}],from:21.17625,to:21.18375},{signals:[{delta:175.55,assignment:"CO"}],from:175.54625000000001,to:175.55375},{signals:[{delta:62.7,assignment:"CH₂"}],from:62.696250000000006,to:62.70375},{signals:[{delta:14.36,assignment:"CH₃"}],from:14.35625,to:14.36375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:124.08,assignment:"CH₂"}],from:124.07625,to:124.08375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:64.87,assignment:"CH₂"}],from:64.86625000000001,to:64.87375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["H grease"],smiles:"",ranges:[],nucleus:"13C",solvent:"TFE-d₃"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:134.04,assignment:"C"}],from:134.03625,to:134.04375},{signals:[{delta:17.04,assignment:"CH₃"}],from:17.03625,to:17.04375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:14.63,assignment:"CH₃"}],from:14.62625,to:14.633750000000001},{signals:[{delta:24.06,assignment:"CH₂(2,5)"}],from:24.05625,to:24.06375},{signals:[{delta:33.17,assignment:"CH₂(3,4)"}],from:33.166250000000005,to:33.17375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:2.09,assignment:"CH₃"}],from:2.0862499999999997,to:2.09375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:37.21,assignment:"CH₃"}],from:37.206250000000004,to:37.21375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:136.58,assignment:"CH(2)"}],from:136.57625000000002,to:136.58375},{signals:[{delta:122.93,assignment:"CH(4,5)"}],from:122.92625000000001,to:122.93375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-5.88,assignment:"CH₄"}],from:-5.88375,to:-5.87625}],nucleus:"13C",solvent:"TFE-d₃"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:50.67,assignment:"CH₃"}],from:50.666250000000005,to:50.67375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:63.17,assignment:"CH₃"}],from:63.166250000000005,to:63.17375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:14.54,assignment:"CH₃"}],from:14.536249999999999,to:14.54375},{signals:[{delta:23.75,assignment:"CH₂(2,4)"}],from:23.74625,to:23.75375},{signals:[{delta:35.76,assignment:"CH₂(3)"}],from:35.75625,to:35.763749999999995}],nucleus:"13C",solvent:"TFE-d₃"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.93,assignment:"CH₃"}],from:16.92625,to:16.93375},{signals:[{delta:17.46,assignment:"CH₂"}],from:17.45625,to:17.46375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.21,assignment:"CH₃"}],from:25.20625,to:25.21375},{signals:[{delta:66.69,assignment:"CH"}],from:66.68625,to:66.69375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.63,assignment:"CH₃"}],from:19.62625,to:19.63375},{signals:[{delta:116.38,assignment:"CH₂"}],from:116.37625,to:116.38374999999999},{signals:[{delta:136,assignment:"CH"}],from:135.99625,to:136.00375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:149.76,assignment:"CH(2,6)"}],from:149.75625,to:149.76375},{signals:[{delta:126.27,assignment:"CH(3,5)"}],from:126.26625,to:126.27374999999999},{signals:[{delta:139.62,assignment:"CH(4)"}],from:139.61625,to:139.62375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:119.61,assignment:"CH(2,5)"}],from:119.60625,to:119.61375},{signals:[{delta:108.85,assignment:"CH(3,4)"}],from:108.84625,to:108.85374999999999}],nucleus:"13C",solvent:"TFE-d₃"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:47.43,assignment:"CH₂(2,5)"}],from:47.42625,to:47.433749999999996},{signals:[{delta:25.73,assignment:"CH₂(3,4)"}],from:25.72625,to:25.73375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{delta:2.87,assignment:"CH₃"}],from:2.86625,to:2.8737500000000002}],nucleus:"13C",solvent:"TFE-d₃"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:69.53,assignment:"CH₂(2,5)"}],from:69.52625,to:69.53375},{signals:[{delta:26.69,assignment:"CH₂(3,4)"}],from:26.68625,to:26.69375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:21.62,assignment:"CH₃"}],from:21.61625,to:21.62375},{signals:[{delta:139.92,assignment:"C(1)"}],from:139.91625,to:139.92374999999998},{signals:[{delta:130.58,assignment:"CH(2,6)"}],from:130.57625000000002,to:130.58375},{signals:[{delta:129.79,assignment:"CH(3,5)"}],from:129.78625,to:129.79375},{signals:[{delta:126.82,assignment:"CH(4)"}],from:126.81625,to:126.82374999999999}],nucleus:"13C",solvent:"TFE-d₃"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:9.51,assignment:"CH₃"}],from:9.50625,to:9.51375},{signals:[{delta:48.45,assignment:"CH₂"}],from:48.446250000000006,to:48.45375}],nucleus:"13C",solvent:"TFE-d₃"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:175.11,assignment:"CO"}],from:175.10625000000002,to:175.11375},{signals:[{delta:20.56,assignment:"CH₃"}],from:20.55625,to:20.56375}],nucleus:"13C",solvent:"CD₃OD"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:209.67,assignment:"CO"}],from:209.66625,to:209.67374999999998},{signals:[{delta:30.67,assignment:"CH₃"}],from:30.66625,to:30.673750000000002}],nucleus:"13C",solvent:"CD₃OD"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:118.06,assignment:"CN"}],from:118.05625,to:118.06375},{signals:[{delta:.85,assignment:"CH₃"}],from:.84625,to:.85375}],nucleus:"13C",solvent:"CD₃OD"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{delta:129.34,assignment:"CH"}],from:129.33625,to:129.34375}],nucleus:"13C",solvent:"CD₃OD"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:69.4,assignment:"(CH₃)₃C"}],from:69.39625000000001,to:69.40375},{signals:[{delta:30.91,assignment:"(CH₃)₃C"}],from:30.90625,to:30.91375}],nucleus:"13C",solvent:"CD₃OD"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[{signals:[{delta:126.31,assignment:"CO₂"}],from:126.30625,to:126.31375}],nucleus:"13C",solvent:"CD₃OD"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:193.82,assignment:"CS₂"}],from:193.81625,to:193.82375}],nucleus:"13C",solvent:"CD₃OD"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:97.21,assignment:"CCl₄"}],from:97.20625,to:97.21374999999999}],nucleus:"13C",solvent:"CD₃OD"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{delta:79.44,assignment:"CH"}],from:79.43625,to:79.44375}],nucleus:"13C",solvent:"CD₃OD"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:71.47,assignment:"CH₂"}],from:71.46625,to:71.47375}],nucleus:"13C",solvent:"CD₃OD"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{delta:27.96,assignment:"CH₂"}],from:27.95625,to:27.96375}],nucleus:"13C",solvent:"CD₃OD"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{delta:45.11,assignment:"CH₂"}],from:45.10625,to:45.113749999999996}],nucleus:"13C",solvent:"CD₃OD"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{delta:54.78,assignment:"CH₂"}],from:54.776250000000005,to:54.78375}],nucleus:"13C",solvent:"CD₃OD"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:15.46,assignment:"CH₃"}],from:15.45625,to:15.463750000000001},{signals:[{delta:66.88,assignment:"CH₂"}],from:66.87625,to:66.88374999999999}],nucleus:"13C",solvent:"CD₃OD"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:59.06,assignment:"CH₃"}],from:59.056250000000006,to:59.06375},{signals:[{delta:71.33,assignment:"CH₂"}],from:71.32625,to:71.33375},{signals:[{delta:72.92,assignment:"CH₂"}],from:72.91625,to:72.92375}],nucleus:"13C",solvent:"CD₃OD"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:164.73,assignment:"CH"}],from:164.72625,to:164.73375},{signals:[{delta:36.89,assignment:"CH₃"}],from:36.886250000000004,to:36.89375},{signals:[{delta:31.61,assignment:"CH₃"}],from:31.60625,to:31.61375}],nucleus:"13C",solvent:"CD₃OD"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:68.11,assignment:"CH₂"}],from:68.10625,to:68.11375}],nucleus:"13C",solvent:"CD₃OD"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:59.06,assignment:"CH₃"}],from:59.056250000000006,to:59.06375},{signals:[{delta:72.72,assignment:"CH₂"}],from:72.71625,to:72.72375}],nucleus:"13C",solvent:"CD₃OD"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{delta:6.98,assignment:"CH₃"}],from:6.97625,to:6.983750000000001}],nucleus:"13C",solvent:"CD₃OD"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:18.4,assignment:"CH₃"}],from:18.39625,to:18.40375},{signals:[{delta:58.26,assignment:"CH₂"}],from:58.25625,to:58.263749999999995}],nucleus:"13C",solvent:"CD₃OD"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:20.88,assignment:"CH₃CO"}],from:20.87625,to:20.88375},{signals:[{delta:172.89,assignment:"CO"}],from:172.88625,to:172.89374999999998},{signals:[{delta:61.5,assignment:"CH₂"}],from:61.49625,to:61.50375},{signals:[{delta:14.49,assignment:"CH₃"}],from:14.48625,to:14.49375}],nucleus:"13C",solvent:"CD₃OD"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{delta:123.46,assignment:"CH₂"}],from:123.45625,to:123.46374999999999}],nucleus:"13C",solvent:"CD₃OD"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:64.3,assignment:"CH₂"}],from:64.29625,to:64.30375}],nucleus:"13C",solvent:"CD₃OD"},{names:["H grease"],smiles:"",ranges:[],nucleus:"13C",solvent:"CD₃OD"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{delta:132.53,assignment:"C"}],from:132.52625,to:132.53375},{signals:[{delta:16.9,assignment:"CH₃"}],from:16.89625,to:16.90375}],nucleus:"13C",solvent:"CD₃OD"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{delta:14.45,assignment:"CH₃"}],from:14.44625,to:14.45375},{signals:[{delta:23.68,assignment:"CH₂(2,5)"}],from:23.67625,to:23.68375},{signals:[{delta:32.73,assignment:"CH₂(3,4)"}],from:32.72625,to:32.73374999999999}],nucleus:"13C",solvent:"CD₃OD"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:1.99,assignment:"CH₃"}],from:1.98625,to:1.99375}],nucleus:"13C",solvent:"CD₃OD"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:37,assignment:"CH₃"}],from:36.99625,to:37.00375}],nucleus:"13C",solvent:"CD₃OD"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:136.31,assignment:"CH(2)"}],from:136.30625,to:136.31375},{signals:[{delta:122.6,assignment:"CH(4,5)"}],from:122.59625,to:122.60374999999999}],nucleus:"13C",solvent:"CD₃OD"},{names:["methane"],smiles:"C",ranges:[{signals:[{delta:-4.9,assignment:"CH₄"}],from:-4.9037500000000005,to:-4.89625}],nucleus:"13C",solvent:"CD₃OD"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:49.86,assignment:"CH₃"}],from:49.85625,to:49.863749999999996}],nucleus:"13C",solvent:"CD₃OD"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:63.08,assignment:"CH₃"}],from:63.07625,to:63.083749999999995}],nucleus:"13C",solvent:"CD₃OD"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{delta:14.39,assignment:"CH₃"}],from:14.38625,to:14.39375},{signals:[{delta:23.38,assignment:"CH₂(2,4)"}],from:23.37625,to:23.38375},{signals:[{delta:35.3,assignment:"CH₂(3)"}],from:35.29625,to:35.303749999999994}],nucleus:"13C",solvent:"CD₃OD"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{delta:16.8,assignment:"CH₃"}],from:16.79625,to:16.80375},{signals:[{delta:17.19,assignment:"CH₂"}],from:17.18625,to:17.19375}],nucleus:"13C",solvent:"CD₃OD"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:25.27,assignment:"CH₃"}],from:25.26625,to:25.27375},{signals:[{delta:64.71,assignment:"CH"}],from:64.70625,to:64.71374999999999}],nucleus:"13C",solvent:"CD₃OD"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{delta:19.5,assignment:"CH₃"}],from:19.49625,to:19.50375},{signals:[{delta:116.04,assignment:"CH₂"}],from:116.03625000000001,to:116.04375},{signals:[{delta:134.61,assignment:"CH"}],from:134.60625000000002,to:134.61375}],nucleus:"13C",solvent:"CD₃OD"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:150.07,assignment:"CH(2,6)"}],from:150.06625,to:150.07375},{signals:[{delta:125.53,assignment:"CH(3,5)"}],from:125.52625,to:125.53375},{signals:[{delta:138.35,assignment:"CH(4)"}],from:138.34625,to:138.35375}],nucleus:"13C",solvent:"CD₃OD"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:118.28,assignment:"CH(2,5)"}],from:118.27625,to:118.28375},{signals:[{delta:108.11,assignment:"CH(3,4)"}],from:108.10625,to:108.11375}],nucleus:"13C",solvent:"CD₃OD"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:47.23,assignment:"CH₂(2,5)"}],from:47.22625,to:47.23374999999999},{signals:[{delta:26.29,assignment:"CH₂(3,4)"}],from:26.28625,to:26.29375}],nucleus:"13C",solvent:"CD₃OD"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{delta:2.1,assignment:"CH₃"}],from:2.09625,to:2.1037500000000002}],nucleus:"13C",solvent:"CD₃OD"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:68.83,assignment:"CH₂(2,5)"}],from:68.82625,to:68.83375},{signals:[{delta:26.48,assignment:"CH₂(3,4)"}],from:26.47625,to:26.48375}],nucleus:"13C",solvent:"CD₃OD"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{delta:21.5,assignment:"CH₃"}],from:21.49625,to:21.50375},{signals:[{delta:138.85,assignment:"C(1)"}],from:138.84625,to:138.85375},{signals:[{delta:129.91,assignment:"CH(2,6)"}],from:129.90625,to:129.91375},{signals:[{delta:129.2,assignment:"CH(3,5)"}],from:129.19625,to:129.20374999999999},{signals:[{delta:126.29,assignment:"CH(4)"}],from:126.28625000000001,to:126.29375}],nucleus:"13C",solvent:"CD₃OD"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:11.09,assignment:"CH₃"}],from:11.08625,to:11.09375},{signals:[{delta:46.96,assignment:"CH₂"}],from:46.956250000000004,to:46.96375}],nucleus:"13C",solvent:"CD₃OD"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{delta:177.21,assignment:"CO"}],from:177.20625,to:177.21375},{signals:[{delta:21.03,assignment:"CH₃"}],from:21.02625,to:21.03375}],nucleus:"13C",solvent:"D₂O"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{delta:215.94,assignment:"CO"}],from:215.93625,to:215.94375},{signals:[{delta:30.89,assignment:"CH₃"}],from:30.88625,to:30.89375}],nucleus:"13C",solvent:"D₂O"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{delta:119.68,assignment:"CN"}],from:119.67625000000001,to:119.68375},{signals:[{delta:1.47,assignment:"CH₃"}],from:1.46625,to:1.47375}],nucleus:"13C",solvent:"D₂O"},{names:["benzene"],smiles:"c1ccccc1",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{delta:70.36,assignment:"(CH₃)₃C"}],from:70.35625,to:70.36375},{signals:[{delta:30.29,assignment:"(CH₃)₃C"}],from:30.28625,to:30.29375}],nucleus:"13C",solvent:"D₂O"},{names:["carbon dioxide"],smiles:"O=C=O",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["carbon disulfide"],smiles:"S=C=S",ranges:[{signals:[{delta:197.25,assignment:"CS₂"}],from:197.24625,to:197.25375}],nucleus:"13C",solvent:"D₂O"},{names:["carbon tetrachloride"],smiles:"ClC(Cl)(Cl)Cl",ranges:[{signals:[{delta:96.73,assignment:"CCl₄"}],from:96.72625000000001,to:96.73375}],nucleus:"13C",solvent:"D₂O"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{delta:70.14,assignment:"CH₂"}],from:70.13625,to:70.14375}],nucleus:"13C",solvent:"D₂O"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:14.77,assignment:"CH₃"}],from:14.76625,to:14.77375},{signals:[{delta:66.42,assignment:"CH₂"}],from:66.41625,to:66.42375}],nucleus:"13C",solvent:"D₂O"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{delta:58.67,assignment:"CH₃"}],from:58.666250000000005,to:58.67375},{signals:[{delta:70.05,assignment:"CH₂"}],from:70.04625,to:70.05375},{signals:[{delta:71.63,assignment:"CH₂"}],from:71.62625,to:71.63374999999999}],nucleus:"13C",solvent:"D₂O"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{delta:165.53,assignment:"CH"}],from:165.52625,to:165.53375},{signals:[{delta:37.54,assignment:"CH₃"}],from:37.53625,to:37.543749999999996},{signals:[{delta:32.03,assignment:"CH₃"}],from:32.026250000000005,to:32.03375}],nucleus:"13C",solvent:"D₂O"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{delta:67.19,assignment:"CH₂"}],from:67.18625,to:67.19375}],nucleus:"13C",solvent:"D₂O"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{delta:58.67,assignment:"CH₃"}],from:58.666250000000005,to:58.67375},{signals:[{delta:71.49,assignment:"CH₂"}],from:71.48625,to:71.49374999999999}],nucleus:"13C",solvent:"D₂O"},{names:["ethane"],smiles:"CC",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{delta:17.47,assignment:"CH₃"}],from:17.46625,to:17.47375},{signals:[{delta:58.05,assignment:"CH₂"}],from:58.04625,to:58.053749999999994}],nucleus:"13C",solvent:"D₂O"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{delta:21.15,assignment:"CH₃CO"}],from:21.14625,to:21.15375},{signals:[{delta:175.26,assignment:"CO"}],from:175.25625,to:175.26375},{signals:[{delta:62.32,assignment:"CH₂"}],from:62.316250000000004,to:62.32375},{signals:[{delta:13.92,assignment:"CH₃"}],from:13.91625,to:13.92375}],nucleus:"13C",solvent:"D₂O"},{names:["ethylene"],smiles:"C=C",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{delta:63.17,assignment:"CH₂"}],from:63.166250000000005,to:63.17375}],nucleus:"13C",solvent:"D₂O"},{names:["H grease"],smiles:"",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{delta:2.31,assignment:"CH₃"}],from:2.30625,to:2.31375}],nucleus:"13C",solvent:"D₂O"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{delta:36.46,assignment:"CH₃"}],from:36.456250000000004,to:36.46375}],nucleus:"13C",solvent:"D₂O"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{delta:136.65,assignment:"CH(2)"}],from:136.64625,to:136.65375},{signals:[{delta:122.43,assignment:"CH(4,5)"}],from:122.42625000000001,to:122.43375}],nucleus:"13C",solvent:"D₂O"},{names:["methane"],smiles:"C",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{delta:49.5,assignment:"CH₃"}],from:49.49625,to:49.50375}],nucleus:"13C",solvent:"D₂O"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{delta:63.22,assignment:"CH₃"}],from:63.21625,to:63.223749999999995}],nucleus:"13C",solvent:"D₂O"},{names:["n-pentane"],smiles:"CCCCC",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["propane"],smiles:"CCC",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{delta:24.38,assignment:"CH₃"}],from:24.37625,to:24.38375},{signals:[{delta:64.88,assignment:"CH"}],from:64.87625,to:64.88374999999999}],nucleus:"13C",solvent:"D₂O"},{names:["propylene"],smiles:"CC=C",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{delta:149.18,assignment:"CH(2,6)"}],from:149.17625,to:149.18375},{signals:[{delta:125.12,assignment:"CH(3,5)"}],from:125.11625000000001,to:125.12375},{signals:[{delta:138.27,assignment:"CH(4)"}],from:138.26625,to:138.27375}],nucleus:"13C",solvent:"D₂O"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{delta:119.06,assignment:"CH(2,5)"}],from:119.05625,to:119.06375},{signals:[{delta:107.83,assignment:"CH(3,4)"}],from:107.82625,to:107.83375}],nucleus:"13C",solvent:"D₂O"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{delta:46.83,assignment:"CH₂(2,5)"}],from:46.82625,to:46.833749999999995},{signals:[{delta:25.86,assignment:"CH₂(3,4)"}],from:25.85625,to:25.86375}],nucleus:"13C",solvent:"D₂O"},{names:["silicone grease"],smiles:"",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{delta:68.68,assignment:"CH₂(2,5)"}],from:68.67625000000001,to:68.68375},{signals:[{delta:25.67,assignment:"CH₂(3,4)"}],from:25.66625,to:25.673750000000002}],nucleus:"13C",solvent:"D₂O"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[],nucleus:"13C",solvent:"D₂O"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{delta:9.07,assignment:"CH₃"}],from:9.06625,to:9.07375},{signals:[{delta:47.19,assignment:"CH₂"}],from:47.18625,to:47.193749999999994}],nucleus:"13C",solvent:"D₂O"}],protonImpurities=[{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:2.46,multiplicity:"s",assignment:"OH"}],integration:2,from:2.45625,to:2.46375}],nucleus:"1H",solvent:"THF-d₈"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:1.89,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.88625,to:1.8937499999999998}],nucleus:"1H",solvent:"THF-d₈"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:2.05,multiplicity:"s",assignment:"CH₃"}],integration:6,from:2.0462499999999997,to:2.05375}],nucleus:"1H",solvent:"THF-d₈"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:1.95,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.94625,to:1.9537499999999999}],nucleus:"1H",solvent:"THF-d₈"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.31,multiplicity:"s",assignment:"CH"}],integration:6,from:7.3062499999999995,to:7.31375}],nucleus:"1H",solvent:"THF-d₈"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.15,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.14625,to:1.1537499999999998},{signals:[{js:[],delta:3.16,multiplicity:"s",assignment:"OH"}],integration:1,from:3.15625,to:3.1637500000000003}],nucleus:"1H",solvent:"THF-d₈"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:7.89,multiplicity:"s",assignment:"CH"}],integration:1,from:7.8862499999999995,to:7.89375}],nucleus:"1H",solvent:"THF-d₈"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.57,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.5662499999999997,to:3.57375}],nucleus:"1H",solvent:"THF-d₈"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.44,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.43625,to:1.4437499999999999}],nucleus:"1H",solvent:"THF-d₈"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:3.77,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.76625,to:3.77375}],nucleus:"1H",solvent:"THF-d₈"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:5.51,multiplicity:"s",assignment:"CH₂"}],integration:2,from:5.50625,to:5.51375}],nucleus:"1H",solvent:"THF-d₈"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.12,assignment:"CH₃"}],integration:6,from:1.0987500000000001,to:1.14125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.38,assignment:"CH₂"}],integration:4,from:3.35,to:3.4099999999999997}],nucleus:"1H",solvent:"THF-d₈"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.43,assignment:"CH₂"}],integration:4,from:3.42625,to:3.4337500000000003},{signals:[{js:[],delta:3.53,assignment:"CH₂"}],integration:4,from:3.5262499999999997,to:3.53375},{signals:[{js:[],delta:3.28,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.2762499999999997,to:3.28375}],nucleus:"1H",solvent:"THF-d₈"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.91,multiplicity:"s",assignment:"CH"}],integration:1,from:7.90625,to:7.91375},{signals:[{js:[],delta:2.88,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.8762499999999998,to:2.88375},{signals:[{js:[],delta:2.76,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.7562499999999996,to:2.76375}],nucleus:"1H",solvent:"THF-d₈"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.56,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.55625,to:3.56375}],nucleus:"1H",solvent:"THF-d₈"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.28,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.2762499999999997,to:3.28375},{signals:[{js:[],delta:3.43,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.42625,to:3.4337500000000003}],nucleus:"1H",solvent:"THF-d₈"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.85,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.84625,to:.85375}],nucleus:"1H",solvent:"THF-d₈"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.1,assignment:"CH₃"}],integration:3,from:1.07875,to:1.12125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.51,assignment:"CH₂"}],integration:2,from:3.48,to:3.5399999999999996},{signals:[{js:[],delta:3.3,multiplicity:"s",assignment:"OH"}],integration:1,from:3.2962499999999997,to:3.30375}],nucleus:"1H",solvent:"THF-d₈"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:1.94,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:1.93625,to:1.9437499999999999},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:4.04,assignment:"CH₂CH₃"}],integration:2,from:4.01,to:4.07},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.19,assignment:"CH₂CH₃"}],integration:3,from:1.16875,to:1.21125}],nucleus:"1H",solvent:"THF-d₈"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.36,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.35625,to:5.3637500000000005}],nucleus:"1H",solvent:"THF-d₈"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.48,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.47625,to:3.48375}],nucleus:"1H",solvent:"THF-d₈"},{names:["H greaseᶠ"],smiles:"",ranges:[{signals:[],integration:6,from:.85,to:.91,multiplicity:"m"},{signals:[{js:[],delta:1.29,multiplicity:"br s",assignment:"CH₂"}],integration:10,from:1.2862500000000001,to:1.29375}],nucleus:"1H",solvent:"THF-d₈"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.18,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.17625,to:2.1837500000000003}],nucleus:"1H",solvent:"THF-d₈"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.89,assignment:"CH₃"}],integration:6,from:.86875,to:.91125},{signals:[{js:[],delta:1.29,assignment:"CH₂"}],integration:8,from:1.2862500000000001,to:1.29375}],nucleus:"1H",solvent:"THF-d₈"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.07,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.06625,to:.07375000000000001}],nucleus:"1H",solvent:"THF-d₈"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.58,assignment:"CH₃"}],integration:18,from:2.564375,to:2.595625}],nucleus:"1H",solvent:"THF-d₈"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.55,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.54625,to:4.55375}],nucleus:"1H",solvent:"THF-d₈"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.48,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.47625,to:7.483750000000001},{signals:[{js:[],delta:6.94,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:6.93625,to:6.9437500000000005}],nucleus:"1H",solvent:"THF-d₈"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.19,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.18625,to:.19375}],nucleus:"1H",solvent:"THF-d₈"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.27,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.26625,to:3.27375},{signals:[{js:[],delta:3.02,multiplicity:"s",assignment:"OH"}],integration:1,from:3.01625,to:3.02375}],nucleus:"1H",solvent:"THF-d₈"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:4.31,multiplicity:"s",assignment:"CH₃"}],integration:3,from:4.3062499999999995,to:4.31375}],nucleus:"1H",solvent:"THF-d₈"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.89,assignment:"CH₃"}],integration:6,from:.86875,to:.91125},{signals:[{js:[],delta:1.31,assignment:"CH₂"}],integration:6,from:1.3062500000000001,to:1.31375}],nucleus:"1H",solvent:"THF-d₈"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.9,assignment:"CH₃"}],integration:6,from:.878,to:.922},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.33,assignment:"CH₂"}],integration:2,from:1.2715,to:1.3885}],nucleus:"1H",solvent:"THF-d₈"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:1.08,assignment:"CH₃"}],integration:6,from:1.06875,to:1.09125},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:3.82,assignment:"CH"}],integration:1,from:3.7712499999999998,to:3.86875}],nucleus:"1H",solvent:"THF-d₈"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.69,assignment:"CH₃"}],integration:3,from:1.6744999999999999,to:1.7055},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.89,assignment:"CH₂(1)"}],integration:1,from:4.873749999999999,to:4.90625},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:4.99,assignment:"CH₂(2)"}],integration:1,from:4.965,to:5.015000000000001},{signals:[{js:[],delta:5.79,assignment:"CH"}],integration:1,from:5.78625,to:5.79375}],nucleus:"1H",solvent:"THF-d₈"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.54,assignment:"CH(2,6)"}],integration:2,from:8.536249999999999,to:8.54375},{signals:[{js:[],delta:7.25,assignment:"CH(3,5)"}],integration:2,from:7.24625,to:7.25375},{signals:[{js:[],delta:7.65,assignment:"CH(4)"}],integration:1,from:7.64625,to:7.6537500000000005}],nucleus:"1H",solvent:"THF-d₈"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:9.96,assignment:"NH"}],integration:1,from:9.95625,to:9.963750000000001},{signals:[{js:[],delta:6.66,assignment:"CH(2,5)"}],integration:2,from:6.65625,to:6.66375},{signals:[{js:[],delta:6.02,assignment:"CH(3,4)"}],integration:2,from:6.016249999999999,to:6.02375}],nucleus:"1H",solvent:"THF-d₈"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:2.75,assignment:"CH₂(2,5)"}],integration:4,from:2.74625,to:2.75375},{signals:[{js:[],delta:1.59,assignment:"CH₂(3,4)"}],integration:4,from:1.5862500000000002,to:1.59375}],nucleus:"1H",solvent:"THF-d₈"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:.11,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.10625,to:.11375}],nucleus:"1H",solvent:"THF-d₈"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.62,assignment:"CH₂(2,5)"}],integration:4,from:3.61625,to:3.6237500000000002},{signals:[{js:[],delta:1.79,assignment:"CH₂(3,4)"}],integration:4,from:1.7862500000000001,to:1.79375}],nucleus:"1H",solvent:"THF-d₈"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.31,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.30625,to:2.31375},{signals:[{js:[],delta:7.1,assignment:"CH(2,4,6)"}],integration:3,from:7.0962499999999995,to:7.10375},{signals:[{js:[],delta:7.19,assignment:"CH(3,5)"}],integration:2,from:7.18625,to:7.1937500000000005}],nucleus:"1H",solvent:"THF-d₈"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.97,assignment:"CH₃"}],integration:6,from:.94875,to:.99125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.46,assignment:"CH₂"}],integration:4,from:2.43,to:2.4899999999999998}],nucleus:"1H",solvent:"THF-d₈"},{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:1.52,multiplicity:"s",assignment:"OH"}],integration:2,from:1.51625,to:1.52375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:2.06,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.05625,to:2.06375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:2.12,multiplicity:"s",assignment:"CH₃"}],integration:6,from:2.11625,to:2.1237500000000002}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:1.97,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.96625,to:1.97375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.35,multiplicity:"s",assignment:"CH"}],integration:6,from:7.3462499999999995,to:7.35375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.24,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.23625,to:1.24375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:7.32,multiplicity:"s",assignment:"CH"}],integration:1,from:7.31625,to:7.32375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.59,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.5862499999999997,to:3.59375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.44,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.43625,to:1.4437499999999999}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:3.76,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.7562499999999996,to:3.76375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:5.33,multiplicity:"s",assignment:"CH₂"}],integration:2,from:5.32625,to:5.33375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.15,assignment:"CH₃"}],integration:6,from:1.12875,to:1.17125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.43,assignment:"CH₂"}],integration:4,from:3.4000000000000004,to:3.46}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.57,assignment:"CH₂"}],integration:4,from:3.5662499999999997,to:3.57375},{signals:[{js:[],delta:3.5,assignment:"CH₂"}],integration:4,from:3.49625,to:3.50375},{signals:[{js:[],delta:3.33,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.32625,to:3.33375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.96,multiplicity:"s",assignment:"CH"}],integration:1,from:7.95625,to:7.96375},{signals:[{js:[],delta:2.91,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.90625,to:2.9137500000000003},{signals:[{js:[],delta:2.82,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.8162499999999997,to:2.82375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.65,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.6462499999999998,to:3.65375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.34,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.3362499999999997,to:3.34375},{signals:[{js:[],delta:3.49,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.48625,to:3.4937500000000004}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.85,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.84625,to:.85375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.19,assignment:"CH₃"}],integration:3,from:1.16875,to:1.21125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.66,assignment:"CH₂"}],integration:2,from:3.6300000000000003,to:3.69},{signals:[{js:[],delta:1.33,multiplicity:"s",assignment:"OH"}],integration:1,from:1.3262500000000002,to:1.33375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:2,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:1.99625,to:2.00375},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:4.08,assignment:"CH₂CH₃"}],integration:2,from:4.05,to:4.11},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.23,assignment:"CH₂CH₃"}],integration:3,from:1.20875,to:1.25125}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.4,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.39625,to:5.4037500000000005}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.66,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.65625,to:3.6637500000000003}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["H greaseᶠ"],smiles:"",ranges:[{signals:[],integration:6,from:.84,to:.9,multiplicity:"m"},{signals:[{js:[],delta:1.27,multiplicity:"br s",assignment:"CH₂"}],integration:10,from:1.26625,to:1.27375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.2,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.19625,to:2.2037500000000003}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.89,assignment:"CH₃"}],integration:6,from:.86875,to:.91125},{signals:[{js:[],delta:1.27,assignment:"CH₂"}],integration:8,from:1.26625,to:1.27375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.07,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.06625,to:.07375000000000001}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.6,assignment:"CH₃"}],integration:18,from:2.584375,to:2.615625}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.59,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.58625,to:4.59375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.63,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.62625,to:7.63375},{signals:[{js:[],delta:7.07,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:7.06625,to:7.07375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.21,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.20625,to:.21375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.42,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.41625,to:3.42375},{signals:[{js:[],delta:1.09,multiplicity:"s",assignment:"OH"}],integration:1,from:1.0862500000000002,to:1.09375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:4.31,multiplicity:"s",assignment:"CH₃"}],integration:3,from:4.3062499999999995,to:4.31375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.89,assignment:"CH₃"}],integration:6,from:.86875,to:.91125},{signals:[{js:[],delta:1.3,assignment:"CH₂"}],integration:6,from:1.2962500000000001,to:1.30375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.9,assignment:"CH₃"}],integration:6,from:.878,to:.922},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.32,assignment:"CH₂"}],integration:2,from:1.2615,to:1.3785}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:1.17,assignment:"CH₃"}],integration:6,from:1.15875,to:1.18125},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:3.97,assignment:"CH"}],integration:1,from:3.92125,to:4.01875}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.71,assignment:"CH₃"}],integration:3,from:1.6945,to:1.7255},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.93,assignment:"CH₂(1)"}],integration:1,from:4.913749999999999,to:4.94625},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:5.03,assignment:"CH₂(2)"}],integration:1,from:5.005,to:5.055000000000001},{signals:[{js:[],delta:5.84,assignment:"CH"}],integration:1,from:5.83625,to:5.84375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.59,assignment:"CH(2,6)"}],integration:2,from:8.58625,to:8.59375},{signals:[{js:[],delta:7.28,assignment:"CH(3,5)"}],integration:2,from:7.27625,to:7.28375},{signals:[{js:[],delta:7.68,assignment:"CH(4)"}],integration:1,from:7.67625,to:7.68375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:8.69,assignment:"NH"}],integration:1,from:8.68625,to:8.69375},{signals:[{js:[],delta:6.79,assignment:"CH(2,5)"}],integration:2,from:6.78625,to:6.79375},{signals:[{js:[],delta:6.19,assignment:"CH(3,4)"}],integration:2,from:6.18625,to:6.1937500000000005}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:2.82,assignment:"CH₂(2,5)"}],integration:4,from:2.8162499999999997,to:2.82375},{signals:[{js:[],delta:1.67,assignment:"CH₂(3,4)"}],integration:4,from:1.66625,to:1.6737499999999998}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:.09,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.08625,to:.09375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.69,assignment:"CH₂(2,5)"}],integration:4,from:3.68625,to:3.69375},{signals:[{js:[],delta:1.82,assignment:"CH₂(3,4)"}],integration:4,from:1.8162500000000001,to:1.82375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.34,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.3362499999999997,to:2.34375},{signals:[{js:[],delta:7.15,assignment:"CH(2,4,6)"}],integration:3,from:7.14625,to:7.1537500000000005},{signals:[{js:[],delta:7.24,assignment:"CH(3,5)"}],integration:2,from:7.23625,to:7.24375}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.99,assignment:"CH₃"}],integration:6,from:.96875,to:1.01125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.48,assignment:"CH₂"}],integration:4,from:2.45,to:2.51}],nucleus:"1H",solvent:"CD₂Cl₂"},{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:1.56,multiplicity:"s",assignment:"OH"}],integration:2,from:1.5562500000000001,to:1.56375}],nucleus:"1H",solvent:"CDCl₃"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:2.1,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.09625,to:2.1037500000000002}],nucleus:"1H",solvent:"CDCl₃"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:2.17,multiplicity:"s",assignment:"CH₃"}],integration:6,from:2.16625,to:2.17375}],nucleus:"1H",solvent:"CDCl₃"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:2.1,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.09625,to:2.1037500000000002}],nucleus:"1H",solvent:"CDCl₃"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.36,multiplicity:"s",assignment:"CH"}],integration:6,from:7.35625,to:7.3637500000000005}],nucleus:"1H",solvent:"CDCl₃"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.28,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.27625,to:1.28375}],nucleus:"1H",solvent:"CDCl₃"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:7.26,multiplicity:"s",assignment:"CH"}],integration:1,from:7.25625,to:7.26375}],nucleus:"1H",solvent:"CDCl₃"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.67,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.66625,to:3.67375}],nucleus:"1H",solvent:"CDCl₃"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.43,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.42625,to:1.4337499999999999}],nucleus:"1H",solvent:"CDCl₃"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:3.73,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.72625,to:3.73375}],nucleus:"1H",solvent:"CDCl₃"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:5.3,multiplicity:"s",assignment:"CH₂"}],integration:2,from:5.29625,to:5.30375}],nucleus:"1H",solvent:"CDCl₃"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.21,assignment:"CH₃"}],integration:6,from:1.18875,to:1.23125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.48,assignment:"CH₂"}],integration:4,from:3.45,to:3.51}],nucleus:"1H",solvent:"CDCl₃"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.65,assignment:"CH₂"}],integration:4,from:3.6462499999999998,to:3.65375},{signals:[{js:[],delta:3.57,assignment:"CH₂"}],integration:4,from:3.5662499999999997,to:3.57375},{signals:[{js:[],delta:3.39,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.38625,to:3.3937500000000003}],nucleus:"1H",solvent:"CDCl₃"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:8.02,multiplicity:"s",assignment:"CH"}],integration:1,from:8.01625,to:8.02375},{signals:[{js:[],delta:2.96,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.95625,to:2.96375},{signals:[{js:[],delta:2.88,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.8762499999999998,to:2.88375}],nucleus:"1H",solvent:"CDCl₃"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.71,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.70625,to:3.71375}],nucleus:"1H",solvent:"CDCl₃"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.4,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.3962499999999998,to:3.40375},{signals:[{js:[],delta:3.55,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.5462499999999997,to:3.55375}],nucleus:"1H",solvent:"CDCl₃"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.87,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.86625,to:.87375}],nucleus:"1H",solvent:"CDCl₃"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.25,assignment:"CH₃"}],integration:3,from:1.22875,to:1.27125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.72,assignment:"CH₂"}],integration:2,from:3.6900000000000004,to:3.75},{signals:[{js:[],delta:1.32,multiplicity:"s",assignment:"OH"}],integration:1,from:1.3162500000000001,to:1.32375}],nucleus:"1H",solvent:"CDCl₃"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:2.05,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:2.0462499999999997,to:2.05375},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:4.12,assignment:"CH₂CH₃"}],integration:2,from:4.09,to:4.15},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.26,assignment:"CH₂CH₃"}],integration:3,from:1.23875,to:1.28125}],nucleus:"1H",solvent:"CDCl₃"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.4,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.39625,to:5.4037500000000005}],nucleus:"1H",solvent:"CDCl₃"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.76,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.7562499999999996,to:3.76375}],nucleus:"1H",solvent:"CDCl₃"},{names:["H greaseᶠ"],smiles:"",ranges:[{signals:[],integration:6,from:.84,to:.87,multiplicity:"m"},{signals:[{js:[],delta:1.25,multiplicity:"br s",assignment:"CH₂"}],integration:10,from:1.24625,to:1.25375}],nucleus:"1H",solvent:"CDCl₃"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.24,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.23625,to:2.2437500000000004}],nucleus:"1H",solvent:"CDCl₃"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.88,assignment:"CH₃"}],integration:6,from:.85875,to:.90125},{signals:[{js:[],delta:1.26,assignment:"CH₂"}],integration:8,from:1.25625,to:1.26375}],nucleus:"1H",solvent:"CDCl₃"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.07,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.06625,to:.07375000000000001}],nucleus:"1H",solvent:"CDCl₃"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.65,assignment:"CH₃"}],integration:18,from:2.634375,to:2.665625}],nucleus:"1H",solvent:"CDCl₃"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.62,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.61625,to:4.62375}],nucleus:"1H",solvent:"CDCl₃"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.67,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.66625,to:7.67375},{signals:[{js:[],delta:7.1,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:7.0962499999999995,to:7.10375}],nucleus:"1H",solvent:"CDCl₃"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.22,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.21625,to:.22375}],nucleus:"1H",solvent:"CDCl₃"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.49,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.48625,to:3.4937500000000004},{signals:[{js:[],delta:1.09,multiplicity:"s",assignment:"OH"}],integration:1,from:1.0862500000000002,to:1.09375}],nucleus:"1H",solvent:"CDCl₃"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:4.33,multiplicity:"s",assignment:"CH₃"}],integration:3,from:4.32625,to:4.33375}],nucleus:"1H",solvent:"CDCl₃"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.88,assignment:"CH₃"}],integration:6,from:.85875,to:.90125},{signals:[{js:[],delta:1.27,assignment:"CH₂"}],integration:6,from:1.26625,to:1.27375}],nucleus:"1H",solvent:"CDCl₃"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.9,assignment:"CH₃"}],integration:6,from:.878,to:.922},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.32,assignment:"CH₂"}],integration:2,from:1.2615,to:1.3785}],nucleus:"1H",solvent:"CDCl₃"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:1.22,assignment:"CH₃"}],integration:6,from:1.20875,to:1.23125},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:4.04,assignment:"CH"}],integration:1,from:3.99125,to:4.08875}],nucleus:"1H",solvent:"CDCl₃"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.73,assignment:"CH₃"}],integration:3,from:1.7145,to:1.7455},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.94,assignment:"CH₂(1)"}],integration:1,from:4.92375,to:4.956250000000001},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:5.03,assignment:"CH₂(2)"}],integration:1,from:5.005,to:5.055000000000001},{signals:[{js:[],delta:5.83,assignment:"CH"}],integration:1,from:5.82625,to:5.83375}],nucleus:"1H",solvent:"CDCl₃"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.62,assignment:"CH(2,6)"}],integration:2,from:8.616249999999999,to:8.62375},{signals:[{js:[],delta:7.29,assignment:"CH(3,5)"}],integration:2,from:7.28625,to:7.29375},{signals:[{js:[],delta:7.68,assignment:"CH(4)"}],integration:1,from:7.67625,to:7.68375}],nucleus:"1H",solvent:"CDCl₃"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:8.4,assignment:"NH"}],integration:1,from:8.39625,to:8.40375},{signals:[{js:[],delta:6.83,assignment:"CH(2,5)"}],integration:2,from:6.82625,to:6.83375},{signals:[{js:[],delta:6.26,assignment:"CH(3,4)"}],integration:2,from:6.25625,to:6.26375}],nucleus:"1H",solvent:"CDCl₃"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:2.87,assignment:"CH₂(2,5)"}],integration:4,from:2.86625,to:2.8737500000000002},{signals:[{js:[],delta:1.68,assignment:"CH₂(3,4)"}],integration:4,from:1.67625,to:1.6837499999999999}],nucleus:"1H",solvent:"CDCl₃"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:.07,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.06625,to:.07375000000000001}],nucleus:"1H",solvent:"CDCl₃"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.76,assignment:"CH₂(2,5)"}],integration:4,from:3.7562499999999996,to:3.76375},{signals:[{js:[],delta:1.85,assignment:"CH₂(3,4)"}],integration:4,from:1.8462500000000002,to:1.85375}],nucleus:"1H",solvent:"CDCl₃"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.36,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.3562499999999997,to:2.36375},{signals:[{js:[],delta:7.17,assignment:"CH(2,4,6)"}],integration:3,from:7.16625,to:7.17375},{signals:[{js:[],delta:7.25,assignment:"CH(3,5)"}],integration:2,from:7.24625,to:7.25375}],nucleus:"1H",solvent:"CDCl₃"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.03,assignment:"CH₃"}],integration:6,from:1.00875,to:1.05125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.53,assignment:"CH₂"}],integration:4,from:2.5,to:2.5599999999999996}],nucleus:"1H",solvent:"CDCl₃"},{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:.43,multiplicity:"s",assignment:"OH"}],integration:2,from:.42625,to:.43374999999999997}],nucleus:"1H",solvent:"toluene-d₈"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:1.57,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.5662500000000001,to:1.57375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:1.57,multiplicity:"s",assignment:"CH₃"}],integration:6,from:1.5662500000000001,to:1.57375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:.69,multiplicity:"s",assignment:"CH₃"}],integration:3,from:.6862499999999999,to:.69375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.12,multiplicity:"s",assignment:"CH"}],integration:6,from:7.11625,to:7.12375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.03,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.02625,to:1.03375},{signals:[{js:[],delta:.58,multiplicity:"s",assignment:"OH"}],integration:1,from:.5762499999999999,to:.58375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:6.1,multiplicity:"s",assignment:"CH"}],integration:1,from:6.0962499999999995,to:6.10375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.36,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.3562499999999997,to:3.36375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.4,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.39625,to:1.4037499999999998}],nucleus:"1H",solvent:"toluene-d₈"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:2.91,multiplicity:"s",assignment:"CH₂"}],integration:4,from:2.90625,to:2.9137500000000003}],nucleus:"1H",solvent:"toluene-d₈"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:4.32,multiplicity:"s",assignment:"CH₂"}],integration:2,from:4.31625,to:4.32375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.1,assignment:"CH₃"}],integration:6,from:1.07875,to:1.12125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.25,assignment:"CH₂"}],integration:4,from:3.22,to:3.28}],nucleus:"1H",solvent:"toluene-d₈"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.43,assignment:"CH₂"}],integration:4,from:3.42625,to:3.4337500000000003},{signals:[{js:[],delta:3.31,assignment:"CH₂"}],integration:4,from:3.30625,to:3.31375},{signals:[{js:[],delta:3.12,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.11625,to:3.1237500000000002}],nucleus:"1H",solvent:"toluene-d₈"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.57,multiplicity:"s",assignment:"CH"}],integration:1,from:7.56625,to:7.57375},{signals:[{js:[],delta:2.37,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.36625,to:2.3737500000000002},{signals:[{js:[],delta:1.96,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.95625,to:1.9637499999999999}],nucleus:"1H",solvent:"toluene-d₈"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.33,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.32625,to:3.33375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.12,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.11625,to:3.1237500000000002},{signals:[{js:[],delta:3.31,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.30625,to:3.31375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.81,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.80625,to:.8137500000000001}],nucleus:"1H",solvent:"toluene-d₈"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.97,assignment:"CH₃"}],integration:3,from:.94875,to:.99125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.36,assignment:"CH₂"}],integration:2,from:3.33,to:3.3899999999999997},{signals:[{js:[],delta:.83,multiplicity:"s",assignment:"OH"}],integration:1,from:.8262499999999999,to:.83375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:1.69,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:1.68625,to:1.6937499999999999},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.87,assignment:"CH₂CH₃"}],integration:2,from:3.8400000000000003,to:3.9},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.94,assignment:"CH₂CH₃"}],integration:3,from:.91875,to:.9612499999999999}],nucleus:"1H",solvent:"toluene-d₈"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.25,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.24625,to:5.25375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.36,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.3562499999999997,to:3.36375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["H greaseᶠ"],smiles:"",ranges:[{signals:[],integration:6,from:.89,to:.96,multiplicity:"m"},{signals:[{js:[],delta:1.33,multiplicity:"br s",assignment:"CH₂"}],integration:10,from:1.3262500000000002,to:1.33375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.1,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.09625,to:2.1037500000000002}],nucleus:"1H",solvent:"toluene-d₈"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.88,assignment:"CH₃"}],integration:6,from:.85875,to:.90125},{signals:[{js:[],delta:1.22,assignment:"CH₂"}],integration:8,from:1.21625,to:1.22375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.1,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.09625,to:.10375000000000001}],nucleus:"1H",solvent:"toluene-d₈"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.42,assignment:"CH₃"}],integration:18,from:2.404375,to:2.435625}],nucleus:"1H",solvent:"toluene-d₈"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.5,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.49625,to:4.50375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.3,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.29625,to:7.30375},{signals:[{js:[],delta:6.86,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:6.85625,to:6.8637500000000005}],nucleus:"1H",solvent:"toluene-d₈"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.17,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.16625,to:.17375000000000002}],nucleus:"1H",solvent:"toluene-d₈"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.03,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.0262499999999997,to:3.03375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:3.01,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.0062499999999996,to:3.01375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.87,assignment:"CH₃"}],integration:6,from:.84875,to:.89125},{signals:[{js:[],delta:1.25,assignment:"CH₂"}],integration:6,from:1.24625,to:1.25375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.89,assignment:"CH₃"}],integration:6,from:.868,to:.912},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.32,assignment:"CH₂"}],integration:2,from:1.2615,to:1.3785}],nucleus:"1H",solvent:"toluene-d₈"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:.95,assignment:"CH₃"}],integration:6,from:.93875,to:.9612499999999999},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:3.65,assignment:"CH"}],integration:1,from:3.60125,to:3.69875}],nucleus:"1H",solvent:"toluene-d₈"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.55,assignment:"CH₃"}],integration:3,from:1.5345,to:1.5655000000000001},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.92,assignment:"CH₂(1)"}],integration:1,from:4.90375,to:4.93625},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:4.98,assignment:"CH₂(2)"}],integration:1,from:4.955,to:5.005000000000001},{signals:[{js:[],delta:5.7,assignment:"CH"}],integration:1,from:5.69625,to:5.70375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.47,assignment:"CH(2,6)"}],integration:2,from:8.46625,to:8.47375},{signals:[{js:[],delta:6.67,assignment:"CH(3,5)"}],integration:2,from:6.66625,to:6.67375},{signals:[{js:[],delta:6.99,assignment:"CH(4)"}],integration:1,from:6.98625,to:6.99375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:7.71,assignment:"NH"}],integration:1,from:7.70625,to:7.71375},{signals:[{js:[],delta:6.43,assignment:"CH(2,5)"}],integration:2,from:6.42625,to:6.43375},{signals:[{js:[],delta:6.27,assignment:"CH(3,4)"}],integration:2,from:6.266249999999999,to:6.27375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:2.54,assignment:"CH₂(2,5)"}],integration:4,from:2.53625,to:2.54375},{signals:[{js:[],delta:1.36,assignment:"CH₂(3,4)"}],integration:4,from:1.3562500000000002,to:1.36375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:.26,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.25625000000000003,to:.26375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.54,assignment:"CH₂(2,5)"}],integration:4,from:3.53625,to:3.54375},{signals:[{js:[],delta:1.43,assignment:"CH₂(3,4)"}],integration:4,from:1.42625,to:1.4337499999999999}],nucleus:"1H",solvent:"toluene-d₈"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.11,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.1062499999999997,to:2.11375},{signals:[],integration:3,from:6.96,to:7.01,multiplicity:"m"},{signals:[{js:[],delta:7.09,assignment:"CH(3,5)"}],integration:2,from:7.08625,to:7.09375}],nucleus:"1H",solvent:"toluene-d₈"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.95,assignment:"CH₃"}],integration:6,from:.92875,to:.97125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.39,assignment:"CH₂"}],integration:4,from:2.3600000000000003,to:2.42}],nucleus:"1H",solvent:"toluene-d₈"},{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:.4,multiplicity:"s",assignment:"OH"}],integration:2,from:.39625000000000005,to:.40375}],nucleus:"1H",solvent:"C₆D₆"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:1.52,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.51625,to:1.52375}],nucleus:"1H",solvent:"C₆D₆"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:1.55,multiplicity:"s",assignment:"CH₃"}],integration:6,from:1.5462500000000001,to:1.55375}],nucleus:"1H",solvent:"C₆D₆"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:.58,multiplicity:"s",assignment:"CH₃"}],integration:3,from:.5762499999999999,to:.58375}],nucleus:"1H",solvent:"C₆D₆"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.15,multiplicity:"s",assignment:"CH"}],integration:6,from:7.14625,to:7.1537500000000005}],nucleus:"1H",solvent:"C₆D₆"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.05,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.0462500000000001,to:1.05375},{signals:[{js:[],delta:.63,multiplicity:"s",assignment:"OH"}],integration:1,from:.62625,to:.63375}],nucleus:"1H",solvent:"C₆D₆"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:6.15,multiplicity:"s",assignment:"CH"}],integration:1,from:6.14625,to:6.1537500000000005}],nucleus:"1H",solvent:"C₆D₆"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.39,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.38625,to:3.3937500000000003}],nucleus:"1H",solvent:"C₆D₆"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.4,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.39625,to:1.4037499999999998}],nucleus:"1H",solvent:"C₆D₆"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:2.9,multiplicity:"s",assignment:"CH₂"}],integration:4,from:2.8962499999999998,to:2.90375}],nucleus:"1H",solvent:"C₆D₆"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:4.27,multiplicity:"s",assignment:"CH₂"}],integration:2,from:4.266249999999999,to:4.27375}],nucleus:"1H",solvent:"C₆D₆"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.11,assignment:"CH₃"}],integration:6,from:1.08875,to:1.13125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.26,assignment:"CH₂"}],integration:4,from:3.23,to:3.2899999999999996}],nucleus:"1H",solvent:"C₆D₆"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.46,assignment:"CH₂"}],integration:4,from:3.45625,to:3.46375},{signals:[{js:[],delta:3.34,assignment:"CH₂"}],integration:4,from:3.3362499999999997,to:3.34375},{signals:[{js:[],delta:3.11,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.1062499999999997,to:3.11375}],nucleus:"1H",solvent:"C₆D₆"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.63,multiplicity:"s",assignment:"CH"}],integration:1,from:7.62625,to:7.63375},{signals:[{js:[],delta:2.36,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.3562499999999997,to:2.36375},{signals:[{js:[],delta:1.86,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.8562500000000002,to:1.86375}],nucleus:"1H",solvent:"C₆D₆"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.35,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.34625,to:3.3537500000000002}],nucleus:"1H",solvent:"C₆D₆"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.12,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.11625,to:3.1237500000000002},{signals:[{js:[],delta:3.33,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.32625,to:3.33375}],nucleus:"1H",solvent:"C₆D₆"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.8,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.79625,to:.8037500000000001}],nucleus:"1H",solvent:"C₆D₆"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.96,assignment:"CH₃"}],integration:3,from:.93875,to:.98125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.34,assignment:"CH₂"}],integration:2,from:3.31,to:3.3699999999999997},{signals:[{js:[],delta:.5,multiplicity:"s",assignment:"OH"}],integration:1,from:.49625,to:.50375}],nucleus:"1H",solvent:"C₆D₆"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:1.65,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:1.64625,to:1.6537499999999998},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.89,assignment:"CH₂CH₃"}],integration:2,from:3.8600000000000003,to:3.92},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.92,assignment:"CH₂CH₃"}],integration:3,from:.89875,to:.94125}],nucleus:"1H",solvent:"C₆D₆"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.25,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.24625,to:5.25375}],nucleus:"1H",solvent:"C₆D₆"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.41,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.40625,to:3.4137500000000003}],nucleus:"1H",solvent:"C₆D₆"},{names:["H greaseᶠ"],smiles:"",ranges:[{signals:[],integration:6,from:.9,to:.98,multiplicity:"m"},{signals:[{js:[],delta:1.32,multiplicity:"br s",assignment:"CH₂"}],integration:10,from:1.3162500000000001,to:1.32375}],nucleus:"1H",solvent:"C₆D₆"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.13,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.1262499999999998,to:2.13375}],nucleus:"1H",solvent:"C₆D₆"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.89,assignment:"CH₃"}],integration:6,from:.86875,to:.91125},{signals:[{js:[],delta:1.24,assignment:"CH₂"}],integration:8,from:1.23625,to:1.24375}],nucleus:"1H",solvent:"C₆D₆"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.12,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.11624999999999999,to:.12375}],nucleus:"1H",solvent:"C₆D₆"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.4,assignment:"CH₃"}],integration:18,from:2.384375,to:2.415625}],nucleus:"1H",solvent:"C₆D₆"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.47,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.46625,to:4.47375}],nucleus:"1H",solvent:"C₆D₆"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.33,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.32625,to:7.33375},{signals:[{js:[],delta:6.9,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:6.89625,to:6.9037500000000005}],nucleus:"1H",solvent:"C₆D₆"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.16,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.15625,to:.16375}],nucleus:"1H",solvent:"C₆D₆"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.07,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.0662499999999997,to:3.07375}],nucleus:"1H",solvent:"C₆D₆"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:2.94,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.93625,to:2.94375}],nucleus:"1H",solvent:"C₆D₆"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.87,assignment:"CH₃"}],integration:6,from:.84875,to:.89125},{signals:[{js:[],delta:1.23,assignment:"CH₂"}],integration:6,from:1.22625,to:1.23375}],nucleus:"1H",solvent:"C₆D₆"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.86,assignment:"CH₃"}],integration:6,from:.838,to:.882},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.26,assignment:"CH₂"}],integration:2,from:1.2015,to:1.3185}],nucleus:"1H",solvent:"C₆D₆"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:.95,assignment:"CH₃"}],integration:6,from:.93875,to:.9612499999999999},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:3.67,assignment:"CH"}],integration:1,from:3.62125,to:3.71875}],nucleus:"1H",solvent:"C₆D₆"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.55,assignment:"CH₃"}],integration:3,from:1.5345,to:1.5655000000000001},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.95,assignment:"CH₂(1)"}],integration:1,from:4.93375,to:4.9662500000000005},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:5.01,assignment:"CH₂(2)"}],integration:1,from:4.984999999999999,to:5.035},{signals:[{js:[],delta:5.72,assignment:"CH"}],integration:1,from:5.71625,to:5.72375}],nucleus:"1H",solvent:"C₆D₆"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.53,assignment:"CH(2,6)"}],integration:2,from:8.52625,to:8.53375},{signals:[{js:[],delta:6.66,assignment:"CH(3,5)"}],integration:2,from:6.65625,to:6.66375},{signals:[{js:[],delta:6.98,assignment:"CH(4)"}],integration:1,from:6.97625,to:6.983750000000001}],nucleus:"1H",solvent:"C₆D₆"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:7.8,assignment:"NH"}],integration:1,from:7.79625,to:7.80375},{signals:[{js:[],delta:6.48,assignment:"CH(2,5)"}],integration:2,from:6.47625,to:6.483750000000001},{signals:[{js:[],delta:6.37,assignment:"CH(3,4)"}],integration:2,from:6.36625,to:6.37375}],nucleus:"1H",solvent:"C₆D₆"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:2.54,assignment:"CH₂(2,5)"}],integration:4,from:2.53625,to:2.54375},{signals:[{js:[],delta:1.33,assignment:"CH₂(3,4)"}],integration:4,from:1.3262500000000002,to:1.33375}],nucleus:"1H",solvent:"C₆D₆"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:.29,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.28625,to:.29374999999999996}],nucleus:"1H",solvent:"C₆D₆"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.57,assignment:"CH₂(2,5)"}],integration:4,from:3.5662499999999997,to:3.57375},{signals:[{js:[],delta:1.4,assignment:"CH₂(3,4)"}],integration:4,from:1.39625,to:1.4037499999999998}],nucleus:"1H",solvent:"C₆D₆"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.11,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.1062499999999997,to:2.11375},{signals:[{js:[],delta:7.02,assignment:"CH(2,4,6)"}],integration:3,from:7.016249999999999,to:7.02375},{signals:[{js:[],delta:7.13,assignment:"CH(3,5)"}],integration:2,from:7.12625,to:7.13375}],nucleus:"1H",solvent:"C₆D₆"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.96,assignment:"CH₃"}],integration:6,from:.93875,to:.98125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.4,assignment:"CH₂"}],integration:4,from:2.37,to:2.4299999999999997}],nucleus:"1H",solvent:"C₆D₆"},{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:1.03,multiplicity:"s",assignment:"OH"}],integration:2,from:1.02625,to:1.03375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:1.76,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.75625,to:1.76375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:1.77,multiplicity:"s",assignment:"CH₃"}],integration:6,from:1.76625,to:1.77375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:1.21,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.20625,to:1.2137499999999999}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.2,multiplicity:"s",assignment:"CH"}],integration:6,from:7.19625,to:7.20375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.12,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.1162500000000002,to:1.12375},{signals:[{js:[],delta:1.3,multiplicity:"s",assignment:"OH"}],integration:1,from:1.2962500000000001,to:1.30375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:6.74,multiplicity:"s",assignment:"CH"}],integration:1,from:6.73625,to:6.74375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.41,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.40625,to:3.4137500000000003}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.37,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.3662500000000002,to:1.37375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:3.26,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.2562499999999996,to:3.26375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:4.77,multiplicity:"s",assignment:"CH₂"}],integration:2,from:4.766249999999999,to:4.77375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.1,assignment:"CH₃"}],integration:6,from:1.07875,to:1.12125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.31,assignment:"CH₂"}],integration:4,from:3.2800000000000002,to:3.34}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.49,assignment:"CH₂"}],integration:4,from:3.48625,to:3.4937500000000004},{signals:[{js:[],delta:3.37,assignment:"CH₂"}],integration:4,from:3.36625,to:3.3737500000000002},{signals:[{js:[],delta:3.16,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.15625,to:3.1637500000000003}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.73,multiplicity:"s",assignment:"CH"}],integration:1,from:7.72625,to:7.733750000000001},{signals:[{js:[],delta:2.51,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.5062499999999996,to:2.51375},{signals:[{js:[],delta:2.3,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.2962499999999997,to:2.30375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.45,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.44625,to:3.4537500000000003}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.17,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.16625,to:3.17375},{signals:[{js:[],delta:3.37,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.36625,to:3.3737500000000002}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.79,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.78625,to:.7937500000000001}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.06,assignment:"CH₃"}],integration:3,from:1.03875,to:1.08125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.51,assignment:"CH₂"}],integration:2,from:3.48,to:3.5399999999999996},{signals:[{js:[],delta:1.39,multiplicity:"s",assignment:"OH"}],integration:1,from:1.38625,to:1.3937499999999998}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:1.78,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:1.77625,to:1.78375},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.96,assignment:"CH₂CH₃"}],integration:2,from:3.93,to:3.9899999999999998},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.04,assignment:"CH₂CH₃"}],integration:3,from:1.01875,to:1.06125}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.29,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.28625,to:5.29375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.58,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.57625,to:3.58375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["H greaseᶠ"],smiles:"",ranges:[{signals:[],integration:6,from:.86,to:.92,multiplicity:"m"},{signals:[{js:[],delta:1.3,multiplicity:"br s",assignment:"CH₂"}],integration:10,from:1.2962500000000001,to:1.30375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.1,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.09625,to:2.1037500000000002}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.85,assignment:"CH₃"}],integration:6,from:.82875,to:.87125},{signals:[{js:[],delta:1.19,assignment:"CH₂"}],integration:8,from:1.18625,to:1.1937499999999999}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.1,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.09625,to:.10375000000000001}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.47,assignment:"CH₃"}],integration:18,from:2.454375,to:2.485625}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.49,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.48625,to:4.49375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.53,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.52625,to:7.53375},{signals:[{js:[],delta:7.01,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:7.00625,to:7.01375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.15,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.14625,to:.15375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.25,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.24625,to:3.25375},{signals:[{js:[],delta:1.3,multiplicity:"s",assignment:"OH"}],integration:1,from:1.2962500000000001,to:1.30375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:3.59,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.5862499999999997,to:3.59375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.84,assignment:"CH₃"}],integration:6,from:.81875,to:.86125},{signals:[{js:[],delta:1.23,assignment:"CH₂"}],integration:6,from:1.22625,to:1.23375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.84,assignment:"CH₃"}],integration:6,from:.818,to:.862},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.26,assignment:"CH₂"}],integration:2,from:1.2015,to:1.3185}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:1.04,assignment:"CH₃"}],integration:6,from:1.02875,to:1.05125},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:3.82,assignment:"CH"}],integration:1,from:3.7712499999999998,to:3.86875}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.58,assignment:"CH₃"}],integration:3,from:1.5645,to:1.5955000000000001},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.91,assignment:"CH₂(1)"}],integration:1,from:4.89375,to:4.9262500000000005},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:4.98,assignment:"CH₂(2)"}],integration:1,from:4.955,to:5.005000000000001},{signals:[{js:[],delta:5.72,assignment:"CH"}],integration:1,from:5.71625,to:5.72375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.51,assignment:"CH(2,6)"}],integration:2,from:8.50625,to:8.51375},{signals:[{js:[],delta:6.9,assignment:"CH(3,5)"}],integration:2,from:6.89625,to:6.9037500000000005},{signals:[{js:[],delta:7.25,assignment:"CH(4)"}],integration:1,from:7.24625,to:7.25375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:8.61,assignment:"NH"}],integration:1,from:8.60625,to:8.61375},{signals:[{js:[],delta:6.62,assignment:"CH(2,5)"}],integration:2,from:6.61625,to:6.62375},{signals:[{js:[],delta:6.27,assignment:"CH(3,4)"}],integration:2,from:6.266249999999999,to:6.27375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:2.64,assignment:"CH₂(2,5)"}],integration:4,from:2.63625,to:2.6437500000000003},{signals:[{js:[],delta:1.43,assignment:"CH₂(3,4)"}],integration:4,from:1.42625,to:1.4337499999999999}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:.14,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.13625,to:.14375000000000002}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.59,assignment:"CH₂(2,5)"}],integration:4,from:3.5862499999999997,to:3.59375},{signals:[{js:[],delta:1.55,assignment:"CH₂(3,4)"}],integration:4,from:1.5462500000000001,to:1.55375}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.16,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.15625,to:2.1637500000000003},{signals:[],integration:3,from:7.01,to:7.08,multiplicity:"m"},{signals:[],integration:2,from:7.1,to:7.17,multiplicity:"m"}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.93,assignment:"CH₃"}],integration:6,from:.9087500000000001,to:.95125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.39,assignment:"CH₂"}],integration:4,from:2.3600000000000003,to:2.42}],nucleus:"1H",solvent:"C₆D₅Cl"},{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:2.84,multiplicity:"s",assignment:"OH"}],integration:2,from:2.8362499999999997,to:2.84375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:1.96,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.95625,to:1.9637499999999999}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:2.09,multiplicity:"s",assignment:"CH₃"}],integration:6,from:2.0862499999999997,to:2.09375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:2.05,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.0462499999999997,to:2.05375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.36,multiplicity:"s",assignment:"CH"}],integration:6,from:7.35625,to:7.3637500000000005}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.18,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.17625,to:1.1837499999999999}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:8.02,multiplicity:"s",assignment:"CH"}],integration:1,from:8.01625,to:8.02375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.59,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.5862499999999997,to:3.59375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.43,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.42625,to:1.4337499999999999}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:3.87,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.86625,to:3.8737500000000002}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:5.63,multiplicity:"s",assignment:"CH₂"}],integration:2,from:5.62625,to:5.63375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.11,assignment:"CH₃"}],integration:6,from:1.08875,to:1.13125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.41,assignment:"CH₂"}],integration:4,from:3.3800000000000003,to:3.44}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.56,assignment:"CH₂"}],integration:4,from:3.55625,to:3.56375},{signals:[{js:[],delta:3.47,assignment:"CH₂"}],integration:4,from:3.46625,to:3.4737500000000003},{signals:[{js:[],delta:3.28,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.2762499999999997,to:3.28375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.96,multiplicity:"s",assignment:"CH"}],integration:1,from:7.95625,to:7.96375},{signals:[{js:[],delta:2.94,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.93625,to:2.94375},{signals:[{js:[],delta:2.78,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.7762499999999997,to:2.78375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.59,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.5862499999999997,to:3.59375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.28,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.2762499999999997,to:3.28375},{signals:[{js:[],delta:3.46,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.45625,to:3.46375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.83,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.8262499999999999,to:.83375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.12,assignment:"CH₃"}],integration:3,from:1.0987500000000001,to:1.14125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.57,assignment:"CH₂"}],integration:2,from:3.54,to:3.5999999999999996},{signals:[{js:[],delta:3.39,multiplicity:"s",assignment:"OH"}],integration:1,from:3.38625,to:3.3937500000000003}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:1.97,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:1.96625,to:1.97375},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:4.05,assignment:"CH₂CH₃"}],integration:2,from:4.02,to:4.08},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.2,assignment:"CH₂CH₃"}],integration:3,from:1.17875,to:1.22125}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.38,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.37625,to:5.38375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.28,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.2762499999999997,to:3.28375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["H greaseᶠ"],smiles:"",ranges:[{signals:[{js:[],delta:.9,assignment:"CH₃"}],integration:6,from:.89625,to:.90375},{signals:[{js:[],delta:1.29,multiplicity:"br s",assignment:"CH₂"}],integration:10,from:1.2862500000000001,to:1.29375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.17,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.16625,to:2.17375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.88,assignment:"CH₃"}],integration:6,from:.85875,to:.90125},{signals:[{js:[],delta:1.28,assignment:"CH₂"}],integration:8,from:1.27625,to:1.28375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.07,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.06625,to:.07375000000000001}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.59,assignment:"CH₃"}],integration:18,from:2.574375,to:2.605625}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.54,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.53625,to:4.54375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.62,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.61625,to:7.62375},{signals:[{js:[],delta:7.04,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:7.03625,to:7.04375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.17,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.16625,to:.17375000000000002}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.31,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.30625,to:3.31375},{signals:[{js:[],delta:3.12,multiplicity:"s",assignment:"OH"}],integration:1,from:3.11625,to:3.1237500000000002}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:4.43,multiplicity:"s",assignment:"CH₃"}],integration:3,from:4.42625,to:4.43375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.88,assignment:"CH₃"}],integration:6,from:.85875,to:.90125},{signals:[{js:[],delta:1.27,assignment:"CH₂"}],integration:6,from:1.26625,to:1.27375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.88,assignment:"CH₃"}],integration:6,from:.858,to:.902},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.31,assignment:"CH₂"}],integration:2,from:1.2515,to:1.3685}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:1.1,assignment:"CH₃"}],integration:6,from:1.08875,to:1.11125},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:3.9,assignment:"CH"}],integration:1,from:3.85125,to:3.94875}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.68,assignment:"CH₃"}],integration:3,from:1.6644999999999999,to:1.6955},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.9,assignment:"CH₂(1)"}],integration:1,from:4.88375,to:4.916250000000001},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:5,assignment:"CH₂(2)"}],integration:1,from:4.975,to:5.025},{signals:[{js:[],delta:5.81,assignment:"CH"}],integration:1,from:5.8062499999999995,to:5.81375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.58,assignment:"CH(2,6)"}],integration:2,from:8.57625,to:8.58375},{signals:[{js:[],delta:7.35,assignment:"CH(3,5)"}],integration:2,from:7.3462499999999995,to:7.35375},{signals:[{js:[],delta:7.76,assignment:"CH(4)"}],integration:1,from:7.75625,to:7.76375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:10.02,assignment:"NH"}],integration:1,from:10.01625,to:10.02375},{signals:[{js:[],delta:6.77,assignment:"CH(2,5)"}],integration:2,from:6.766249999999999,to:6.77375},{signals:[{js:[],delta:6.07,assignment:"CH(3,4)"}],integration:2,from:6.06625,to:6.07375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:.13,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.12625,to:.13375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.63,assignment:"CH₂(2,5)"}],integration:4,from:3.6262499999999998,to:3.63375},{signals:[{js:[],delta:1.79,assignment:"CH₂(3,4)"}],integration:4,from:1.7862500000000001,to:1.79375}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.32,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.3162499999999997,to:2.32375},{signals:[],integration:3,from:7.1,to:7.2,multiplicity:"m"},{signals:[],integration:2,from:7.1,to:7.2,multiplicity:"m"}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.96,assignment:"CH₃"}],integration:6,from:.93875,to:.98125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.45,assignment:"CH₂"}],integration:4,from:2.4200000000000004,to:2.48}],nucleus:"1H",solvent:"(CD₃)₂CO"},{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:3.33,multiplicity:"s",assignment:"OH"}],integration:2,from:3.32625,to:3.33375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:1.91,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.90625,to:1.9137499999999998}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:2.09,multiplicity:"s",assignment:"CH₃"}],integration:6,from:2.0862499999999997,to:2.09375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:2.07,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.0662499999999997,to:2.07375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.37,multiplicity:"s",assignment:"CH"}],integration:6,from:7.36625,to:7.37375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.11,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.1062500000000002,to:1.11375},{signals:[{js:[],delta:4.19,multiplicity:"s",assignment:"OH"}],integration:1,from:4.18625,to:4.1937500000000005}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:8.32,multiplicity:"s",assignment:"CH"}],integration:1,from:8.31625,to:8.32375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.51,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.5062499999999996,to:3.51375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.4,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.39625,to:1.4037499999999998}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:3.9,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.8962499999999998,to:3.90375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:5.76,multiplicity:"s",assignment:"CH₂"}],integration:2,from:5.75625,to:5.76375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.09,assignment:"CH₃"}],integration:6,from:1.06875,to:1.11125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.38,assignment:"CH₂"}],integration:4,from:3.35,to:3.4099999999999997}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.51,assignment:"CH₂"}],integration:4,from:3.5062499999999996,to:3.51375},{signals:[{js:[],delta:3.38,assignment:"CH₂"}],integration:4,from:3.3762499999999998,to:3.38375},{signals:[{js:[],delta:3.24,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.23625,to:3.2437500000000004}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.95,multiplicity:"s",assignment:"CH"}],integration:1,from:7.94625,to:7.95375},{signals:[{js:[],delta:2.89,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.88625,to:2.8937500000000003},{signals:[{js:[],delta:2.73,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.72625,to:2.73375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.57,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.5662499999999997,to:3.57375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.24,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.23625,to:3.2437500000000004},{signals:[{js:[],delta:3.43,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.42625,to:3.4337500000000003}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.82,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.8162499999999999,to:.82375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.06,assignment:"CH₃"}],integration:3,from:1.03875,to:1.08125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.44,assignment:"CH₂"}],integration:2,from:3.41,to:3.4699999999999998},{signals:[{js:[],delta:4.63,multiplicity:"s",assignment:"OH"}],integration:1,from:4.62625,to:4.63375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:1.99,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:1.98625,to:1.99375},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:4.03,assignment:"CH₂CH₃"}],integration:2,from:4,to:4.0600000000000005},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.17,assignment:"CH₂CH₃"}],integration:3,from:1.14875,to:1.19125}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.41,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.40625,to:5.41375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.34,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.3362499999999997,to:3.34375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["H greaseᶠ"],smiles:"",ranges:[{signals:[],integration:6,from:.82,to:.88,multiplicity:"m"},{signals:[{js:[],delta:1.24,multiplicity:"br s",assignment:"CH₂"}],integration:10,from:1.23625,to:1.24375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.14,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.13625,to:2.1437500000000003}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.86,assignment:"CH₃"}],integration:6,from:.83875,to:.88125},{signals:[{js:[],delta:1.25,assignment:"CH₂"}],integration:8,from:1.24625,to:1.25375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.06,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.056249999999999994,to:.06375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.53,assignment:"CH₃"}],integration:18,from:2.514375,to:2.545625}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.61,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.60625,to:4.6137500000000005}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.63,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.62625,to:7.63375},{signals:[{js:[],delta:7.01,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:7.00625,to:7.01375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.2,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.19625,to:.20375000000000001}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.16,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.15625,to:3.1637500000000003},{signals:[{js:[],delta:4.01,multiplicity:"s",assignment:"OH"}],integration:1,from:4.00625,to:4.01375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:4.42,multiplicity:"s",assignment:"CH₃"}],integration:3,from:4.41625,to:4.42375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.86,assignment:"CH₃"}],integration:6,from:.83875,to:.88125},{signals:[{js:[],delta:1.27,assignment:"CH₂"}],integration:6,from:1.26625,to:1.27375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.87,assignment:"CH₃"}],integration:6,from:.848,to:.892},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.29,assignment:"CH₂"}],integration:2,from:1.2315,to:1.3485}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:1.04,assignment:"CH₃"}],integration:6,from:1.02875,to:1.05125},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:3.78,assignment:"CH"}],integration:1,from:3.7312499999999997,to:3.82875}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.68,assignment:"CH₃"}],integration:3,from:1.6644999999999999,to:1.6955},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.94,assignment:"CH₂(1)"}],integration:1,from:4.92375,to:4.956250000000001},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:5.03,assignment:"CH₂(2)"}],integration:1,from:5.005,to:5.055000000000001},{signals:[{js:[],delta:5.8,assignment:"CH"}],integration:1,from:5.79625,to:5.80375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.58,assignment:"CH(2,6)"}],integration:2,from:8.57625,to:8.58375},{signals:[{js:[],delta:7.39,assignment:"CH(3,5)"}],integration:2,from:7.3862499999999995,to:7.39375},{signals:[{js:[],delta:7.79,assignment:"CH(4)"}],integration:1,from:7.78625,to:7.79375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:10.75,assignment:"NH"}],integration:1,from:10.74625,to:10.75375},{signals:[{js:[],delta:6.73,assignment:"CH(2,5)"}],integration:2,from:6.72625,to:6.733750000000001},{signals:[{js:[],delta:6.01,assignment:"CH(3,4)"}],integration:2,from:6.00625,to:6.01375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:2.67,assignment:"CH₂(2,5)"}],integration:4,from:2.66625,to:2.67375},{signals:[{js:[],delta:1.55,assignment:"CH₂(3,4)"}],integration:4,from:1.5462500000000001,to:1.55375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:-.06,multiplicity:"s",assignment:"CH₃"}],integration:6,from:-.06375,to:-.056249999999999994}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.6,assignment:"CH₂(2,5)"}],integration:4,from:3.59625,to:3.6037500000000002},{signals:[{js:[],delta:1.76,assignment:"CH₂(3,4)"}],integration:4,from:1.75625,to:1.76375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.3,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.2962499999999997,to:2.30375},{signals:[{js:[],delta:7.18,assignment:"CH(2,4,6)"}],integration:3,from:7.17625,to:7.18375},{signals:[{js:[],delta:7.25,assignment:"CH(3,5)"}],integration:2,from:7.24625,to:7.25375}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.93,assignment:"CH₃"}],integration:6,from:.9087500000000001,to:.95125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.43,assignment:"CH₂"}],integration:4,from:2.4000000000000004,to:2.46}],nucleus:"1H",solvent:"(CD₃)₂SO"},{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:2.13,multiplicity:"s",assignment:"OH"}],integration:2,from:2.1262499999999998,to:2.13375}],nucleus:"1H",solvent:"CD₃CN"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:1.96,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.95625,to:1.9637499999999999}],nucleus:"1H",solvent:"CD₃CN"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:2.08,multiplicity:"s",assignment:"CH₃"}],integration:6,from:2.07625,to:2.08375}],nucleus:"1H",solvent:"CD₃CN"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:1.96,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.95625,to:1.9637499999999999}],nucleus:"1H",solvent:"CD₃CN"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.37,multiplicity:"s",assignment:"CH"}],integration:6,from:7.36625,to:7.37375}],nucleus:"1H",solvent:"CD₃CN"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.16,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.15625,to:1.1637499999999998},{signals:[{js:[],delta:2.18,multiplicity:"s",assignment:"OH"}],integration:1,from:2.17625,to:2.1837500000000003}],nucleus:"1H",solvent:"CD₃CN"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:7.58,multiplicity:"s",assignment:"CH"}],integration:1,from:7.57625,to:7.58375}],nucleus:"1H",solvent:"CD₃CN"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.51,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.5062499999999996,to:3.51375}],nucleus:"1H",solvent:"CD₃CN"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.44,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.43625,to:1.4437499999999999}],nucleus:"1H",solvent:"CD₃CN"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:3.81,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.80625,to:3.81375}],nucleus:"1H",solvent:"CD₃CN"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:5.44,multiplicity:"s",assignment:"CH₂"}],integration:2,from:5.43625,to:5.4437500000000005}],nucleus:"1H",solvent:"CD₃CN"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.12,assignment:"CH₃"}],integration:6,from:1.0987500000000001,to:1.14125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.42,assignment:"CH₂"}],integration:4,from:3.39,to:3.4499999999999997}],nucleus:"1H",solvent:"CD₃CN"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.53,assignment:"CH₂"}],integration:4,from:3.5262499999999997,to:3.53375},{signals:[{js:[],delta:3.45,assignment:"CH₂"}],integration:4,from:3.44625,to:3.4537500000000003},{signals:[{js:[],delta:3.29,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.28625,to:3.29375}],nucleus:"1H",solvent:"CD₃CN"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.92,multiplicity:"s",assignment:"CH"}],integration:1,from:7.91625,to:7.92375},{signals:[{js:[],delta:2.89,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.88625,to:2.8937500000000003},{signals:[{js:[],delta:2.77,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.76625,to:2.77375}],nucleus:"1H",solvent:"CD₃CN"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.6,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.59625,to:3.6037500000000002}],nucleus:"1H",solvent:"CD₃CN"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.28,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.2762499999999997,to:3.28375},{signals:[{js:[],delta:3.45,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.44625,to:3.4537500000000003}],nucleus:"1H",solvent:"CD₃CN"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.85,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.84625,to:.85375}],nucleus:"1H",solvent:"CD₃CN"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.12,assignment:"CH₃"}],integration:3,from:1.0987500000000001,to:1.14125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.54,assignment:"CH₂"}],integration:2,from:3.5100000000000002,to:3.57},{signals:[{js:[],delta:2.47,multiplicity:"s",assignment:"OH"}],integration:1,from:2.46625,to:2.4737500000000003}],nucleus:"1H",solvent:"CD₃CN"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:1.97,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:1.96625,to:1.97375},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:4.06,assignment:"CH₂CH₃"}],integration:2,from:4.029999999999999,to:4.09},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.2,assignment:"CH₂CH₃"}],integration:3,from:1.17875,to:1.22125}],nucleus:"1H",solvent:"CD₃CN"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.41,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.40625,to:5.41375}],nucleus:"1H",solvent:"CD₃CN"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.51,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.5062499999999996,to:3.51375}],nucleus:"1H",solvent:"CD₃CN"},{names:["H greaseᶠ"],smiles:"",ranges:[],nucleus:"1H",solvent:"CD₃CN"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.19,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.18625,to:2.19375}],nucleus:"1H",solvent:"CD₃CN"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.89,assignment:"CH₃"}],integration:6,from:.86875,to:.91125},{signals:[{js:[],delta:1.28,assignment:"CH₂"}],integration:8,from:1.27625,to:1.28375}],nucleus:"1H",solvent:"CD₃CN"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.07,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.06625,to:.07375000000000001}],nucleus:"1H",solvent:"CD₃CN"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.57,assignment:"CH₃"}],integration:18,from:2.554375,to:2.585625}],nucleus:"1H",solvent:"CD₃CN"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.57,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.56625,to:4.57375}],nucleus:"1H",solvent:"CD₃CN"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.57,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.56625,to:7.57375},{signals:[{js:[],delta:7.01,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:7.00625,to:7.01375}],nucleus:"1H",solvent:"CD₃CN"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.2,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.19625,to:.20375000000000001}],nucleus:"1H",solvent:"CD₃CN"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.28,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.2762499999999997,to:3.28375},{signals:[{js:[],delta:2.16,multiplicity:"s",assignment:"OH"}],integration:1,from:2.15625,to:2.1637500000000003}],nucleus:"1H",solvent:"CD₃CN"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:4.31,multiplicity:"s",assignment:"CH₃"}],integration:3,from:4.3062499999999995,to:4.31375}],nucleus:"1H",solvent:"CD₃CN"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.89,assignment:"CH₃"}],integration:6,from:.86875,to:.91125},{signals:[{js:[],delta:1.29,assignment:"CH₂"}],integration:6,from:1.2862500000000001,to:1.29375}],nucleus:"1H",solvent:"CD₃CN"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.9,assignment:"CH₃"}],integration:6,from:.878,to:.922},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.33,assignment:"CH₂"}],integration:2,from:1.2715,to:1.3885}],nucleus:"1H",solvent:"CD₃CN"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:1.09,assignment:"CH₃"}],integration:6,from:1.07875,to:1.10125},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:3.87,assignment:"CH"}],integration:1,from:3.82125,to:3.91875}],nucleus:"1H",solvent:"CD₃CN"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.7,assignment:"CH₃"}],integration:3,from:1.6844999999999999,to:1.7155},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.93,assignment:"CH₂(1)"}],integration:1,from:4.913749999999999,to:4.94625},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:5.04,assignment:"CH₂(2)"}],integration:1,from:5.015,to:5.065},{signals:[{js:[],delta:5.85,assignment:"CH"}],integration:1,from:5.8462499999999995,to:5.85375}],nucleus:"1H",solvent:"CD₃CN"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.57,assignment:"CH(2,6)"}],integration:2,from:8.56625,to:8.57375},{signals:[{js:[],delta:7.33,assignment:"CH(3,5)"}],integration:2,from:7.32625,to:7.33375},{signals:[{js:[],delta:7.73,assignment:"CH(4)"}],integration:1,from:7.72625,to:7.733750000000001}],nucleus:"1H",solvent:"CD₃CN"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:9.27,assignment:"NH"}],integration:1,from:9.26625,to:9.27375},{signals:[{js:[],delta:6.75,assignment:"CH(2,5)"}],integration:2,from:6.74625,to:6.75375},{signals:[{js:[],delta:6.1,assignment:"CH(3,4)"}],integration:2,from:6.0962499999999995,to:6.10375}],nucleus:"1H",solvent:"CD₃CN"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:2.75,assignment:"CH₂(2,5)"}],integration:4,from:2.74625,to:2.75375},{signals:[{js:[],delta:1.61,assignment:"CH₂(3,4)"}],integration:4,from:1.6062500000000002,to:1.61375}],nucleus:"1H",solvent:"CD₃CN"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:.08,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.07625,to:.08375}],nucleus:"1H",solvent:"CD₃CN"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.64,assignment:"CH₂(2,5)"}],integration:4,from:3.63625,to:3.6437500000000003},{signals:[{js:[],delta:1.8,assignment:"CH₂(3,4)"}],integration:4,from:1.7962500000000001,to:1.80375}],nucleus:"1H",solvent:"CD₃CN"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.33,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.32625,to:2.33375},{signals:[],integration:3,from:7.1,to:7.3,multiplicity:"m"},{signals:[],integration:2,from:7.1,to:7.3,multiplicity:"m"}],nucleus:"1H",solvent:"CD₃CN"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.96,assignment:"CH₃"}],integration:6,from:.93875,to:.98125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.45,assignment:"CH₂"}],integration:4,from:2.4200000000000004,to:2.48}],nucleus:"1H",solvent:"CD₃CN"},{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:3.66,multiplicity:"s",assignment:"OH"}],integration:2,from:3.65625,to:3.6637500000000003}],nucleus:"1H",solvent:"TFE-d₃"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:2.06,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.05625,to:2.06375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:2.19,multiplicity:"s",assignment:"CH₃"}],integration:6,from:2.18625,to:2.19375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:1.95,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.94625,to:1.9537499999999999}],nucleus:"1H",solvent:"TFE-d₃"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.36,multiplicity:"s",assignment:"CH"}],integration:6,from:7.35625,to:7.3637500000000005}],nucleus:"1H",solvent:"TFE-d₃"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.28,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.27625,to:1.28375},{signals:[{js:[],delta:2.2,multiplicity:"s",assignment:"OH"}],integration:1,from:2.19625,to:2.2037500000000003}],nucleus:"1H",solvent:"TFE-d₃"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:7.33,multiplicity:"s",assignment:"CH"}],integration:1,from:7.32625,to:7.33375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.64,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.63625,to:3.6437500000000003}],nucleus:"1H",solvent:"TFE-d₃"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.47,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.46625,to:1.47375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:3.71,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.70625,to:3.71375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:5.24,multiplicity:"s",assignment:"CH₂"}],integration:2,from:5.23625,to:5.24375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.2,assignment:"CH₃"}],integration:6,from:1.17875,to:1.22125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.58,assignment:"CH₂"}],integration:4,from:3.5500000000000003,to:3.61}],nucleus:"1H",solvent:"TFE-d₃"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.67,assignment:"CH₂"}],integration:4,from:3.66625,to:3.67375},{signals:[{js:[],delta:3.62,assignment:"CH₂"}],integration:4,from:3.61625,to:3.6237500000000002},{signals:[{js:[],delta:3.41,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.40625,to:3.4137500000000003}],nucleus:"1H",solvent:"TFE-d₃"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.86,multiplicity:"s",assignment:"CH"}],integration:1,from:7.85625,to:7.8637500000000005},{signals:[{js:[],delta:2.98,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.97625,to:2.98375},{signals:[{js:[],delta:2.88,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.8762499999999998,to:2.88375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.76,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.7562499999999996,to:3.76375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.4,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.3962499999999998,to:3.40375},{signals:[{js:[],delta:3.61,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.6062499999999997,to:3.61375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.85,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.84625,to:.85375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.22,assignment:"CH₃"}],integration:3,from:1.19875,to:1.24125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.71,assignment:"CH₂"}],integration:2,from:3.68,to:3.7399999999999998}],nucleus:"1H",solvent:"TFE-d₃"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:2.03,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:2.0262499999999997,to:2.03375},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:4.14,assignment:"CH₂CH₃"}],integration:2,from:4.109999999999999,to:4.17},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.26,assignment:"CH₂CH₃"}],integration:3,from:1.23875,to:1.28125}],nucleus:"1H",solvent:"TFE-d₃"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.4,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.39625,to:5.4037500000000005}],nucleus:"1H",solvent:"TFE-d₃"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.72,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.71625,to:3.7237500000000003}],nucleus:"1H",solvent:"TFE-d₃"},{names:["H greaseᶠ"],smiles:"",ranges:[{signals:[],integration:6,from:.88,to:.94,multiplicity:"m"},{signals:[{js:[],delta:1.33,multiplicity:"br s",assignment:"CH₂"}],integration:10,from:1.3262500000000002,to:1.33375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.24,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.23625,to:2.2437500000000004}],nucleus:"1H",solvent:"TFE-d₃"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.91,assignment:"CH₃"}],integration:6,from:.88875,to:.93125},{signals:[{js:[],delta:1.31,assignment:"CH₂"}],integration:8,from:1.3062500000000001,to:1.31375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.08,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.07625,to:.08375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.63,assignment:"CH₃"}],integration:18,from:2.614375,to:2.645625}],nucleus:"1H",solvent:"TFE-d₃"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.53,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.52625,to:4.53375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.61,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.60625,to:7.6137500000000005},{signals:[{js:[],delta:7.03,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:7.02625,to:7.03375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.18,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.17625,to:.18375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.44,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.43625,to:3.44375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:4.28,multiplicity:"s",assignment:"CH₃"}],integration:3,from:4.27625,to:4.28375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.9,assignment:"CH₃"}],integration:6,from:.87875,to:.92125},{signals:[{js:[],delta:1.33,assignment:"CH₂"}],integration:6,from:1.3262500000000002,to:1.33375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.9,assignment:"CH₃"}],integration:6,from:.878,to:.922},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.33,assignment:"CH₂"}],integration:2,from:1.2715,to:1.3885}],nucleus:"1H",solvent:"TFE-d₃"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:1.2,assignment:"CH₃"}],integration:6,from:1.18875,to:1.21125},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:4.05,assignment:"CH"}],integration:1,from:4.00125,to:4.09875}],nucleus:"1H",solvent:"TFE-d₃"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.7,assignment:"CH₃"}],integration:3,from:1.6844999999999999,to:1.7155},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.93,assignment:"CH₂(1)"}],integration:1,from:4.913749999999999,to:4.94625},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:5.03,assignment:"CH₂(2)"}],integration:1,from:5.005,to:5.055000000000001},{signals:[{js:[],delta:5.87,assignment:"CH"}],integration:1,from:5.86625,to:5.87375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.45,assignment:"CH(2,6)"}],integration:2,from:8.44625,to:8.45375},{signals:[{js:[],delta:7.4,assignment:"CH(3,5)"}],integration:2,from:7.39625,to:7.4037500000000005},{signals:[{js:[],delta:7.82,assignment:"CH(4)"}],integration:1,from:7.81625,to:7.82375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:6.84,assignment:"CH(2,5)"}],integration:2,from:6.83625,to:6.84375},{signals:[{js:[],delta:6.24,assignment:"CH(3,4)"}],integration:2,from:6.23625,to:6.24375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:3.11,assignment:"CH₂(2,5)"}],integration:4,from:3.1062499999999997,to:3.11375},{signals:[{js:[],delta:1.93,assignment:"CH₂(3,4)"}],integration:4,from:1.92625,to:1.9337499999999999}],nucleus:"1H",solvent:"TFE-d₃"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:.16,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.15625,to:.16375}],nucleus:"1H",solvent:"TFE-d₃"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.78,assignment:"CH₂(2,5)"}],integration:4,from:3.7762499999999997,to:3.78375},{signals:[{js:[],delta:1.91,assignment:"CH₂(3,4)"}],integration:4,from:1.90625,to:1.9137499999999998}],nucleus:"1H",solvent:"TFE-d₃"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.33,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.32625,to:2.33375},{signals:[],integration:3,from:7.1,to:7.3,multiplicity:"m"},{signals:[],integration:2,from:7.1,to:7.3,multiplicity:"m"}],nucleus:"1H",solvent:"TFE-d₃"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.31,assignment:"CH₃"}],integration:6,from:1.28875,to:1.33125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.12,assignment:"CH₂"}],integration:4,from:3.0900000000000003,to:3.15}],nucleus:"1H",solvent:"TFE-d₃"},{names:["water"],smiles:"O",ranges:[{signals:[{js:[],delta:4.87,multiplicity:"s",assignment:"OH"}],integration:2,from:4.86625,to:4.87375}],nucleus:"1H",solvent:"CD₃OD"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:1.99,multiplicity:"s",assignment:"CH₃"}],integration:3,from:1.98625,to:1.99375}],nucleus:"1H",solvent:"CD₃OD"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:2.15,multiplicity:"s",assignment:"CH₃"}],integration:6,from:2.1462499999999998,to:2.15375}],nucleus:"1H",solvent:"CD₃OD"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:2.03,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.0262499999999997,to:2.03375}],nucleus:"1H",solvent:"CD₃OD"},{names:["benzene"],smiles:"c1ccccc1",ranges:[{signals:[{js:[],delta:7.33,multiplicity:"s",assignment:"CH"}],integration:6,from:7.32625,to:7.33375}],nucleus:"1H",solvent:"CD₃OD"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.4,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.39625,to:1.4037499999999998}],nucleus:"1H",solvent:"CD₃OD"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[{signals:[{js:[],delta:7.9,multiplicity:"s",assignment:"CH"}],integration:1,from:7.89625,to:7.9037500000000005}],nucleus:"1H",solvent:"CD₃OD"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.64,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.63625,to:3.6437500000000003}],nucleus:"1H",solvent:"CD₃OD"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[{signals:[{js:[],delta:1.45,multiplicity:"s",assignment:"CH₂"}],integration:12,from:1.44625,to:1.4537499999999999}],nucleus:"1H",solvent:"CD₃OD"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[{signals:[{js:[],delta:3.78,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.7762499999999997,to:3.78375}],nucleus:"1H",solvent:"CD₃OD"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[{signals:[{js:[],delta:5.49,multiplicity:"s",assignment:"CH₂"}],integration:2,from:5.48625,to:5.49375}],nucleus:"1H",solvent:"CD₃OD"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.18,assignment:"CH₃"}],integration:6,from:1.15875,to:1.20125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.49,assignment:"CH₂"}],integration:4,from:3.4600000000000004,to:3.52}],nucleus:"1H",solvent:"CD₃OD"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.61,assignment:"CH₂"}],integration:4,from:3.6062499999999997,to:3.61375},{signals:[{js:[],delta:3.58,assignment:"CH₂"}],integration:4,from:3.57625,to:3.58375},{signals:[{js:[],delta:3.35,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.34625,to:3.3537500000000002}],nucleus:"1H",solvent:"CD₃OD"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.97,multiplicity:"s",assignment:"CH"}],integration:1,from:7.96625,to:7.97375},{signals:[{js:[],delta:2.99,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.98625,to:2.9937500000000004},{signals:[{js:[],delta:2.86,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.8562499999999997,to:2.86375}],nucleus:"1H",solvent:"CD₃OD"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.66,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.65625,to:3.6637500000000003}],nucleus:"1H",solvent:"CD₃OD"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.35,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.34625,to:3.3537500000000002},{signals:[{js:[],delta:3.52,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.51625,to:3.52375}],nucleus:"1H",solvent:"CD₃OD"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.85,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.84625,to:.85375}],nucleus:"1H",solvent:"CD₃OD"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.19,assignment:"CH₃"}],integration:3,from:1.16875,to:1.21125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.6,assignment:"CH₂"}],integration:2,from:3.5700000000000003,to:3.63}],nucleus:"1H",solvent:"CD₃OD"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:2.01,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:2.0062499999999996,to:2.01375},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:4.09,assignment:"CH₂CH₃"}],integration:2,from:4.06,to:4.12},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.24,assignment:"CH₂CH₃"}],integration:3,from:1.21875,to:1.26125}],nucleus:"1H",solvent:"CD₃OD"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.39,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.3862499999999995,to:5.39375}],nucleus:"1H",solvent:"CD₃OD"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.59,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.5862499999999997,to:3.59375}],nucleus:"1H",solvent:"CD₃OD"},{names:["H greaseᶠ"],smiles:"",ranges:[{signals:[],integration:6,from:.86,to:.93,multiplicity:"m"},{signals:[{js:[],delta:1.29,multiplicity:"br s",assignment:"CH₂"}],integration:10,from:1.2862500000000001,to:1.29375}],nucleus:"1H",solvent:"CD₃OD"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[{signals:[{js:[],delta:2.19,multiplicity:"s",assignment:"CH₃"}],integration:18,from:2.18625,to:2.19375}],nucleus:"1H",solvent:"CD₃OD"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.9,assignment:"CH₃"}],integration:6,from:.87875,to:.92125},{signals:[{js:[],delta:1.29,assignment:"CH₂"}],integration:8,from:1.2862500000000001,to:1.29375}],nucleus:"1H",solvent:"CD₃OD"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.07,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.06625,to:.07375000000000001}],nucleus:"1H",solvent:"CD₃OD"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.64,assignment:"CH₃"}],integration:18,from:2.624375,to:2.655625}],nucleus:"1H",solvent:"CD₃OD"},{names:["hydrogen"],smiles:"",ranges:[{signals:[{js:[],delta:4.56,multiplicity:"s",assignment:"H₂"}],integration:2,from:4.5562499999999995,to:4.56375}],nucleus:"1H",solvent:"CD₃OD"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.67,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.66625,to:7.67375},{signals:[{js:[],delta:7.05,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:7.04625,to:7.05375}],nucleus:"1H",solvent:"CD₃OD"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.2,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.19625,to:.20375000000000001}],nucleus:"1H",solvent:"CD₃OD"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.34,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.3362499999999997,to:3.34375}],nucleus:"1H",solvent:"CD₃OD"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:4.34,multiplicity:"s",assignment:"CH₃"}],integration:3,from:4.33625,to:4.34375}],nucleus:"1H",solvent:"CD₃OD"},{names:["n-pentane"],smiles:"CCCCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.9,assignment:"CH₃"}],integration:6,from:.87875,to:.92125},{signals:[{js:[],delta:1.29,assignment:"CH₂"}],integration:6,from:1.2862500000000001,to:1.29375}],nucleus:"1H",solvent:"CD₃OD"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.91,assignment:"CH₃"}],integration:6,from:.888,to:.932},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.34,assignment:"CH₂"}],integration:2,from:1.2815,to:1.3985}],nucleus:"1H",solvent:"CD₃OD"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:1.5,assignment:"CH₃"}],integration:6,from:1.48875,to:1.51125},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:3.92,assignment:"CH"}],integration:1,from:3.87125,to:3.96875}],nucleus:"1H",solvent:"CD₃OD"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.7,assignment:"CH₃"}],integration:3,from:1.6844999999999999,to:1.7155},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.91,assignment:"CH₂(1)"}],integration:1,from:4.89375,to:4.9262500000000005},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:5.01,assignment:"CH₂(2)"}],integration:1,from:4.984999999999999,to:5.035},{signals:[{js:[],delta:5.82,assignment:"CH"}],integration:1,from:5.81625,to:5.82375}],nucleus:"1H",solvent:"CD₃OD"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.53,assignment:"CH(2,6)"}],integration:2,from:8.52625,to:8.53375},{signals:[{js:[],delta:7.44,assignment:"CH(3,5)"}],integration:2,from:7.43625,to:7.4437500000000005},{signals:[{js:[],delta:7.85,assignment:"CH(4)"}],integration:1,from:7.8462499999999995,to:7.85375}],nucleus:"1H",solvent:"CD₃OD"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:6.72,assignment:"CH(2,5)"}],integration:2,from:6.71625,to:6.72375},{signals:[{js:[],delta:6.08,assignment:"CH(3,4)"}],integration:2,from:6.07625,to:6.08375}],nucleus:"1H",solvent:"CD₃OD"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:2.8,assignment:"CH₂(2,5)"}],integration:4,from:2.7962499999999997,to:2.80375},{signals:[{js:[],delta:1.72,assignment:"CH₂(3,4)"}],integration:4,from:1.71625,to:1.72375}],nucleus:"1H",solvent:"CD₃OD"},{names:["silicone grease"],smiles:"",ranges:[{signals:[{js:[],delta:.1,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.09625,to:.10375000000000001}],nucleus:"1H",solvent:"CD₃OD"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.71,assignment:"CH₂(2,5)"}],integration:4,from:3.70625,to:3.71375},{signals:[{js:[],delta:1.87,assignment:"CH₂(3,4)"}],integration:4,from:1.8662500000000002,to:1.87375}],nucleus:"1H",solvent:"CD₃OD"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[{signals:[{js:[],delta:2.32,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.3162499999999997,to:2.32375},{signals:[{js:[],delta:7.16,assignment:"CH(2,4,6)"}],integration:3,from:7.15625,to:7.16375},{signals:[{js:[],delta:7.16,assignment:"CH(3,5)"}],integration:2,from:7.15625,to:7.16375}],nucleus:"1H",solvent:"CD₃OD"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.05,assignment:"CH₃"}],integration:6,from:1.02875,to:1.07125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.58,assignment:"CH₂"}],integration:4,from:2.5500000000000003,to:2.61}],nucleus:"1H",solvent:"CD₃OD"},{names:["water"],smiles:"O",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["acetic acid"],smiles:"CC(=O)O",ranges:[{signals:[{js:[],delta:2.08,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.07625,to:2.08375}],nucleus:"1H",solvent:"D₂O"},{names:["acetone"],smiles:"CC(=O)C",ranges:[{signals:[{js:[],delta:2.22,multiplicity:"s",assignment:"CH₃"}],integration:6,from:2.21625,to:2.2237500000000003}],nucleus:"1H",solvent:"D₂O"},{names:["acetonitrile"],smiles:"CC#N",ranges:[{signals:[{js:[],delta:2.06,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.05625,to:2.06375}],nucleus:"1H",solvent:"D₂O"},{names:["benzene"],smiles:"c1ccccc1",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["tert -butyl alcohol"],smiles:"CC(C)(C)O",ranges:[{signals:[{js:[],delta:1.24,multiplicity:"s",assignment:"CH₃"}],integration:9,from:1.23625,to:1.24375}],nucleus:"1H",solvent:"D₂O"},{names:["chloroform"],smiles:"ClC(Cl)Cl",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["18-crown-6"],smiles:"C1COCCOCCOCCOCCOCCO1",ranges:[{signals:[{js:[],delta:3.8,multiplicity:"s",assignment:"CH₂"}],integration:24,from:3.7962499999999997,to:3.80375}],nucleus:"1H",solvent:"D₂O"},{names:["cyclohexane"],smiles:"C1CCCCC1",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["1,2-dichloroethane"],smiles:"ClCCCl",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["dichloromethane"],smiles:"ClCCl",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.17,assignment:"CH₃"}],integration:6,from:1.14875,to:1.19125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.56,assignment:"CH₂"}],integration:4,from:3.5300000000000002,to:3.59}],nucleus:"1H",solvent:"D₂O"},{names:["diglyme"],smiles:"COCCOCCOC",ranges:[{signals:[{js:[],delta:3.67,assignment:"CH₂"}],integration:4,from:3.66625,to:3.67375},{signals:[{js:[],delta:3.61,assignment:"CH₂"}],integration:4,from:3.6062499999999997,to:3.61375},{signals:[{js:[],delta:3.37,multiplicity:"s",assignment:"OCH₃"}],integration:6,from:3.36625,to:3.3737500000000002}],nucleus:"1H",solvent:"D₂O"},{names:["dimethylformamide"],smiles:"C(=O)N(C)C",ranges:[{signals:[{js:[],delta:7.92,multiplicity:"s",assignment:"CH"}],integration:1,from:7.91625,to:7.92375},{signals:[{js:[],delta:3.01,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.0062499999999996,to:3.01375},{signals:[{js:[],delta:2.85,multiplicity:"s",assignment:"CH₃"}],integration:3,from:2.84625,to:2.8537500000000002}],nucleus:"1H",solvent:"D₂O"},{names:["1,4-dioxane"],smiles:"C1COCCOC1",ranges:[{signals:[{js:[],delta:3.75,multiplicity:"s",assignment:"CH₂"}],integration:8,from:3.74625,to:3.75375}],nucleus:"1H",solvent:"D₂O"},{names:["DME","diethyl ether"],smiles:"CCOCC",ranges:[{signals:[{js:[],delta:3.37,multiplicity:"s",assignment:"CH₃"}],integration:6,from:3.36625,to:3.3737500000000002},{signals:[{js:[],delta:3.6,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.59625,to:3.6037500000000002}],nucleus:"1H",solvent:"D₂O"},{names:["ethane"],smiles:"CC",ranges:[{signals:[{js:[],delta:.82,multiplicity:"s",assignment:"CH₃"}],integration:6,from:.8162499999999999,to:.82375}],nucleus:"1H",solvent:"D₂O"},{names:["ethanol"],smiles:"CCO",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.17,assignment:"CH₃"}],integration:3,from:1.14875,to:1.19125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:3.65,assignment:"CH₂"}],integration:2,from:3.62,to:3.6799999999999997}],nucleus:"1H",solvent:"D₂O"},{names:["ethyl acetate"],smiles:"CC(=O)CC",ranges:[{signals:[{js:[],delta:2.07,multiplicity:"s",assignment:"CH₃CO"}],integration:3,from:2.0662499999999997,to:2.07375},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:4.14,assignment:"CH₂CH₃"}],integration:2,from:4.109999999999999,to:4.17},{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:1.24,assignment:"CH₂CH₃"}],integration:3,from:1.21875,to:1.26125}],nucleus:"1H",solvent:"D₂O"},{names:["ethylene"],smiles:"C=C",ranges:[{signals:[{js:[],delta:5.44,multiplicity:"s",assignment:"CH₂"}],integration:4,from:5.43625,to:5.4437500000000005}],nucleus:"1H",solvent:"D₂O"},{names:["ethylene glycol"],smiles:"OCCO",ranges:[{signals:[{js:[],delta:3.65,multiplicity:"s",assignment:"CH₂"}],integration:4,from:3.6462499999999998,to:3.65375}],nucleus:"1H",solvent:"D₂O"},{names:["H greaseᶠ"],smiles:"",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["hexamethylbenzene"],smiles:"CC1=C(C(=C(C(=C1C)C)C)C)C",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["n-hexane"],smiles:"CCCCCC",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["HMDSO"],smiles:"C[Si](C)(C)O[Si](C)(C)C",ranges:[{signals:[{js:[],delta:.28,multiplicity:"s",assignment:"CH₃"}],integration:18,from:.27625000000000005,to:.28375}],nucleus:"1H",solvent:"D₂O"},{names:["HMPA"],smiles:"CN(C)P(=O)(N(C)C)N(C)C",ranges:[{signals:[{js:[{coupling:9.5,multiplicity:"d"}],delta:2.61,assignment:"CH₃"}],integration:18,from:2.594375,to:2.625625}],nucleus:"1H",solvent:"D₂O"},{names:["hydrogen"],smiles:"",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["imidazole"],smiles:"C1=CN=CN1",ranges:[{signals:[{js:[],delta:7.78,multiplicity:"s",assignment:"CH(2)"}],integration:1,from:7.77625,to:7.78375},{signals:[{js:[],delta:7.14,multiplicity:"s",assignment:"CH(4,5)"}],integration:2,from:7.1362499999999995,to:7.14375}],nucleus:"1H",solvent:"D₂O"},{names:["methane"],smiles:"C",ranges:[{signals:[{js:[],delta:.18,multiplicity:"s",assignment:"CH₄"}],integration:4,from:.17625,to:.18375}],nucleus:"1H",solvent:"D₂O"},{names:["methanol"],smiles:"CO",ranges:[{signals:[{js:[],delta:3.34,multiplicity:"s",assignment:"CH₃"}],integration:3,from:3.3362499999999997,to:3.34375}],nucleus:"1H",solvent:"D₂O"},{names:["nitromethane"],smiles:"C[N+](=O)[O-]",ranges:[{signals:[{js:[],delta:4.4,multiplicity:"s",assignment:"CH₃"}],integration:3,from:4.39625,to:4.4037500000000005}],nucleus:"1H",solvent:"D₂O"},{names:["n-pentane"],smiles:"CCCCC",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["propane"],smiles:"CCC",ranges:[{signals:[{js:[{coupling:7.3,multiplicity:"t"}],delta:.88,assignment:"CH₃"}],integration:6,from:.858,to:.902},{signals:[{js:[{coupling:7.3,multiplicity:"sept"}],delta:1.3,assignment:"CH₂"}],integration:2,from:1.2415,to:1.3585}],nucleus:"1H",solvent:"D₂O"},{names:["2-propanol"],smiles:"CC(O)C",ranges:[{signals:[{js:[{coupling:6,multiplicity:"d"}],delta:1.17,assignment:"CH₃"}],integration:6,from:1.15875,to:1.18125},{signals:[{js:[{coupling:6,multiplicity:"sept"}],delta:4.02,assignment:"CH"}],integration:1,from:3.9712499999999995,to:4.06875}],nucleus:"1H",solvent:"D₂O"},{names:["propylene"],smiles:"CC=C",ranges:[{signals:[{js:[{coupling:6.4,multiplicity:"d"},{coupling:1.5,multiplicity:"t"}],delta:1.7,assignment:"CH₃"}],integration:3,from:1.6844999999999999,to:1.7155},{signals:[{js:[{coupling:10,multiplicity:"d"}],delta:4.95,assignment:"CH₂(1)"}],integration:1,from:4.93375,to:4.9662500000000005},{signals:[{js:[{coupling:17,multiplicity:"d"}],delta:5.06,assignment:"CH₂(2)"}],integration:1,from:5.034999999999999,to:5.085},{signals:[{js:[],delta:5.9,assignment:"CH"}],integration:1,from:5.89625,to:5.9037500000000005}],nucleus:"1H",solvent:"D₂O"},{names:["pyridine"],smiles:"C1=CC=NC=C1",ranges:[{signals:[{js:[],delta:8.52,assignment:"CH(2,6)"}],integration:2,from:8.51625,to:8.52375},{signals:[{js:[],delta:7.45,assignment:"CH(3,5)"}],integration:2,from:7.44625,to:7.45375},{signals:[{js:[],delta:7.87,assignment:"CH(4)"}],integration:1,from:7.86625,to:7.87375}],nucleus:"1H",solvent:"D₂O"},{names:["pyrrole"],smiles:"C1=CNC=C1",ranges:[{signals:[{js:[],delta:6.93,assignment:"CH(2,5)"}],integration:2,from:6.92625,to:6.93375},{signals:[{js:[],delta:6.26,assignment:"CH(3,4)"}],integration:2,from:6.25625,to:6.26375}],nucleus:"1H",solvent:"D₂O"},{names:["pyrrolidine"],smiles:"C1CCNC1",ranges:[{signals:[{js:[],delta:3.07,assignment:"CH₂(2,5)"}],integration:4,from:3.0662499999999997,to:3.07375},{signals:[{js:[],delta:1.87,assignment:"CH₂(3,4)"}],integration:4,from:1.8662500000000002,to:1.87375}],nucleus:"1H",solvent:"D₂O"},{names:["silicone grease"],smiles:"",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["tetrahydrofuran"],smiles:"C1COCC1",ranges:[{signals:[{js:[],delta:3.74,assignment:"CH₂(2,5)"}],integration:4,from:3.73625,to:3.7437500000000004},{signals:[{js:[],delta:1.88,assignment:"CH₂(3,4)"}],integration:4,from:1.87625,to:1.8837499999999998}],nucleus:"1H",solvent:"D₂O"},{names:["toluene"],smiles:"Cc1ccccc1",ranges:[],nucleus:"1H",solvent:"D₂O"},{names:["triethylamine"],smiles:"CCN(CC)CC",ranges:[{signals:[{js:[{coupling:7,multiplicity:"t"}],delta:.99,assignment:"CH₃"}],integration:6,from:.96875,to:1.01125},{signals:[{js:[{coupling:7,multiplicity:"q"}],delta:2.57,assignment:"CH₂"}],integration:4,from:2.54,to:2.5999999999999996}],nucleus:"1H",solvent:"D₂O"}];function getShortestPath(t){let{currUnAssCol:e,dualVariableForColumns:s,dualVariableForRows:n,rowAssignments:i,columnAssignments:o,matrix:a}=t,l=a.rows,r=a.columns,m=new Float64Array(l),g=new Float64Array(r),u=new Float64Array(l),c=Array.from(xSequentialFill({from:0,to:l-1})),C=l,f=-1,h=0,p=e,d=new Array(l).fill(Number.POSITIVE_INFINITY);for(;-1===f;){g[p]=1;let t=Number.POSITIVE_INFINITY,e=-1;for(let i=0;i<C;i++){let o=c[i],l=h+a.get(o,p)-s[p]-n[o];l<d[o]&&(m[o]=p,d[o]=l),d[o]<t&&(t=d[o],e=i)}if(!Number.isFinite(t))return{dualVariableForColumns:s,dualVariableForRows:n,sink:f,pred:m};let o=c[e];u[o]=1,C-=1,c.splice(e,1),h=d[o],-1===i[o]?f=o:p=i[o]}s[e]+=h;for(let t=0;t<r;t++)0!==g[t]&&t!==e&&(s[t]+=h-d[o[t]]);for(let t=0;t<l;t++)0!==u[t]&&(n[t]-=h-d[t]);return{sink:f,pred:m,dualVariableForColumns:s,dualVariableForRows:n}}function linearSumAssignment(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const{maximaze:s=!0}=e;let n=Matrix.checkMatrix(t),i=!1;n.columns>n.rows&&(i=!0,n=n.transpose());let o=n.rows,a=n.columns,l=s?n.max():n.min();n=n.subtract(l),s&&(n=n.mul(-1));let r=new Float64Array(o).fill(-1),m=new Float64Array(a).fill(-1),g=new Float64Array(a),u=new Float64Array(o);for(let t=0;t<a;t++){let e=getShortestPath({matrix:n,currUnAssCol:t,dualVariableForColumns:g,dualVariableForRows:u,rowAssignments:r,columnAssignments:m}),{sink:s,pred:i}=e;if(-1===s)return{rowAssignments:r,columnAssignments:m,gain:-1,dualVariableForColumns:g,dualVariableForRows:u};g=e.dualVariableForColumns,u=e.dualVariableForRows;let o=s;for(let e=i[o];;e=i[o]){r[o]=e;let s=m[e];if(m[e]=o,o=s,e===t)break}}let c=0;for(let t=0;t<a;t++)c+=n.get(m[t],t);return c=(s?-1:1)*c+l*a,i&&([m,r]=[r,m],[g,u]=[u,g]),{rowAssignments:r,columnAssignments:m,gain:c,dualVariableForColumns:g,dualVariableForRows:u}}const{stringify:stringify,parse:parse}=JSON;function cloneArray(t){return parse(stringify(t))}function solventSuppression(t,e){let s=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};const n=cloneArray(t).sort(((t,e)=>t.x-e.x)),i=n.map((t=>t.x)),{markSolventPeaks:o=!1,solventZoneExtension:a=1.2}=s;for(const t of e){let e=t.peaks?t.peaks:getSolventPeaks(t);e.sort(((t,e)=>t.x-e.x));let s=xFindClosestIndex(i,e[e.length-1].x+a),l=xFindClosestIndex(i,e[0].x-a);const r=n.filter(((t,e)=>e>=l&&e<=s)),m=[],g=[],u=[];for(let s of r){const{peaks:n,delta:i}=getShiftedSolventPeaks(s,t,e),o=getClosestPeaks(n,r);let a=0,l=0,c=0;for(let t=0;t<o.length;t++)l+=Math.abs(n[t].y-o[t].y),a+=Math.abs(n[t].x-o[t].x);0===o.length?(a=Number.MAX_SAFE_INTEGER,l=Number.MAX_SAFE_INTEGER,c=Number.MAX_SAFE_INTEGER):c=gaussianFct(Math.abs(t.delta-i),.5),m.push(l),g.push(a),u.push(c)}const[c,C,f]=[m,g,u].map((t=>{const e=xMaxValue(t);return 0===e?1:e}));let h=-1,p=Number.MAX_SAFE_INTEGER;for(let t=0;t<g.length;t++){const e=(m[t]/c+g[t]/C+1-u[t]/f)/3;p>e&&(h=t,p=e)}if(p<0||h<0)return n;const{peaks:d}=getShiftedSolventPeaks(r[h],t,e),y=getDiffMatrix(d,r),{rowAssignments:H,gain:v}=linearSumAssignment(y,{maximaze:!1});if(v<0)return n;if(o)for(let t of H)n[t+l].kind="solvent";else{H.sort(((t,e)=>e-t));for(let t of H)n.splice(t+l,1)}}return n}function getSolventPeaks(t){let e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},s=addDummySignals([t]),n=signalsToSpinSystem(s);const{frequency:i=400,maxClusterSize:o=8}=e;n.clusters=splitSpinSystem(n,{frequency:i,maxClusterSize:o});const a=simulateXYPeaks(n);return a.filter((t=>t.x<1e3))}function getShiftedSolventPeaks(t,e,s){const n=JSON.parse(JSON.stringify(s));let i=t.x-e.delta;s.length>1&&s.length%2==0&&(i+=s[0].x);const o=n.reduce(((t,e)=>e.y>t?e.y:t),n[0].y);let a=0;for(let t of n)t.x+=i,t.y/=o,a+=t.x;return{peaks:n,delta:a/n.length}}function getClosestPeaks(t,e){const s=getDiffMatrix(t,e),{rowAssignments:n,gain:i}=linearSumAssignment(s,{maximaze:!1});if(-1===i)return[];const o=[];let a=Number.MIN_SAFE_INTEGER;for(let t of n)a<e[t].y&&(a=e[t].y),o.push({...e[t]});return o.forEach(((t,e,s)=>s[e].y/=a)),o}function getDiffMatrix(t,e){const s=e.length,n=t.length,i=new Matrix(n,s);for(let o=0;o<n;o++)for(let n=0;n<s;n++)i.set(o,n,Math.abs(t[o].x-e[n].x));return i}function markSolventPeaks(t,e){let s=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};const{frequency:n=400}=s,i=addIDs(cloneArray(t));let o=[];for(const t of i){const e=t.id;for(const s of t.signals||[]){const t=s.id;for(let n of s.peaks||[])o.push({...n,rangeID:e,signalID:t})}}const a=solventSuppression(o,e,{markSolventPeaks:!0}),l=getSignalIDsWithSolvent(a);for(let t of i)if(t.signals)for(let e of t.signals){if(!l.includes(e.id))continue;const s=[],i=[];for(let t of a)if(t.signalID===e.id){const{signalID:e,rangeID:n,...o}=t;"solvent"===t.kind?i.push(o):s.push(o)}const o=s.length>0?detectSignals({x:[],y:[]},s,{integralType:"peak",frequency:n}):[];i.sort(((t,e)=>t.x-e.x));const r=i[0].x,m=detectSignals({x:[],y:[]},i,{integralType:"peak",frequencyCluster:(i[i.length-1].x-r)*n,frequency:n});t.signals=[...adaptSignals(o),...adaptSignals(m),...t.signals.filter((t=>t.id!==e.id))]}return i}function getSignalIDsWithSolvent(t){const e=new Set;for(let s of t)"solvent"===s.kind&&e.add(s.signalID);return Array.from(e)}function adaptSignals(t){const e=[];for(let s of t){const t={id:v4(),delta:s.delta,kind:s.kind||"signal",multiplicity:s.multiplicity,integration:s.integralData.value};t.peaks=s.peaks.map((t=>{const e={y:t.intensity,...t};return delete e.intensity,e})),t.js=s.nmrJs||[],e.push(t)}return e}exports.apodization=apodization,exports.carbonImpurities=carbonImpurities,exports.couplingPatterns=couplingPatterns,exports.get13CAssignments=get13CAssignments,exports.get1HAssignments=get1HAssignments,exports.getAssignments=getAssignments,exports.getDatabase=getDatabase,exports.getFrequency=getFrequency,exports.gyromagneticRatio=gyromagneticRatio,exports.impurities=impurities,exports.markSolventPeaks=markSolventPeaks,exports.optimizeSignals=optimizeSignals,exports.peakToXY=peakToXY,exports.peaksFilterImpurities=peaksFilterImpurities,exports.peaksToXY=peaksToXY,exports.predictAll=predictAll,exports.predictAllSpectra=predictAllSpectra,exports.predictCOSY=predictCOSY,exports.predictCarbon=predictCarbon,exports.predictHMBC=predictHMBC,exports.predictHSQC=predictHSQC,exports.predictProton=predictProton,exports.protonImpurities=protonImpurities,exports.rangeFromSignal=rangeFromSignal,exports.rangesToACS=rangesToACS,exports.rangesToXY=rangesToXY,exports.resurrect=resurrect,exports.signals2DToZ=signals2DToZ,exports.signalsToFID=signalsToFID,exports.signalsToRanges=signalsToRanges,exports.signalsToXY=signalsToXY,exports.solventSuppression=solventSuppression,exports.xyAutoPeaksPicking=xyAutoPeaksPicking,exports.xyAutoRangesPicking=xyAutoRangesPicking,exports.xyPeaksOptimization=xyPeaksOptimization,exports.xyzAutoZonesPicking=xyzAutoZonesPicking,exports.xyzJResAnalyzer=xyzJResAnalyzer,Object.defineProperty(exports,"__esModule",{value:!0})}));
//# sourceMappingURL=nmr-processing.min.js.map
